// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');

/**
 * @interface
 */
fluree.db.storage.core.Store = function(){};

var fluree$db$storage$core$Store$exists_QMARK_$dyn_17188 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.exists_QMARK_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.exists_QMARK_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.exists?",s);
}
}
});
/**
 * Returns true when `k` exists in `s`
 */
fluree.db.storage.core.exists_QMARK_ = (function fluree$db$storage$core$exists_QMARK_(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$exists_QMARK_$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$exists_QMARK_$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$exists_QMARK_$dyn_17188(s,k);
}
});

var fluree$db$storage$core$Store$list$dyn_17189 = (function (s,d){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.list[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5394__auto__.call(null,s,d));
} else {
var m__5392__auto__ = (fluree.db.storage.core.list["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,d) : m__5392__auto__.call(null,s,d));
} else {
throw cljs.core.missing_protocol("Store.list",s);
}
}
});
/**
 * Returns a collection containing the keys stored under the subdirectory/prefix `d` of `s`
 */
fluree.db.storage.core.list = (function fluree$db$storage$core$list(s,d){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$list$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$list$arity$2(s,d);
} else {
return fluree$db$storage$core$Store$list$dyn_17189(s,d);
}
});

var fluree$db$storage$core$Store$read$dyn_17190 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.read[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.read["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.read",s);
}
}
});
/**
 * Reads raw bytes from `s` associated with `k`
 */
fluree.db.storage.core.read = (function fluree$db$storage$core$read(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$read$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$read$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$read$dyn_17190(s,k);
}
});

var fluree$db$storage$core$Store$write$dyn_17191 = (function (s,k,data){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.write[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5394__auto__.call(null,s,k,data));
} else {
var m__5392__auto__ = (fluree.db.storage.core.write["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,k,data) : m__5392__auto__.call(null,s,k,data));
} else {
throw cljs.core.missing_protocol("Store.write",s);
}
}
});
/**
 * Writes `data` as raw bytes to `s` and associates it with `k`
 */
fluree.db.storage.core.write = (function fluree$db$storage$core$write(s,k,data){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$write$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$write$arity$3(s,k,data);
} else {
return fluree$db$storage$core$Store$write$dyn_17191(s,k,data);
}
});

var fluree$db$storage$core$Store$rename$dyn_17192 = (function (s,old_key,new_key){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.rename[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5394__auto__.call(null,s,old_key,new_key));
} else {
var m__5392__auto__ = (fluree.db.storage.core.rename["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(s,old_key,new_key) : m__5392__auto__.call(null,s,old_key,new_key));
} else {
throw cljs.core.missing_protocol("Store.rename",s);
}
}
});
/**
 * Remove `old-key` and associate its data to `new-key`
 */
fluree.db.storage.core.rename = (function fluree$db$storage$core$rename(s,old_key,new_key){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$rename$arity$3 == null)))))){
return s.fluree$db$storage$core$Store$rename$arity$3(s,old_key,new_key);
} else {
return fluree$db$storage$core$Store$rename$dyn_17192(s,old_key,new_key);
}
});

var fluree$db$storage$core$Store$delete$dyn_17193 = (function (s,k){
var x__5393__auto__ = (((s == null))?null:s);
var m__5394__auto__ = (fluree.db.storage.core.delete$[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5394__auto__.call(null,s,k));
} else {
var m__5392__auto__ = (fluree.db.storage.core.delete$["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(s,k) : m__5392__auto__.call(null,s,k));
} else {
throw cljs.core.missing_protocol("Store.delete",s);
}
}
});
/**
 * Delete data associated with key `k`
 */
fluree.db.storage.core.delete$ = (function fluree$db$storage$core$delete(s,k){
if((((!((s == null)))) && ((!((s.fluree$db$storage$core$Store$delete$arity$2 == null)))))){
return s.fluree$db$storage$core$Store$delete$arity$2(s,k);
} else {
return fluree$db$storage$core$Store$delete$dyn_17193(s,k);
}
});

/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_prefix = (function fluree$db$storage$core$ledger_garbage_prefix(network,ldgr_id){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ldgr_id,"garbage"], null));
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ldgr_id,block){
var pre = fluree.db.storage.core.ledger_garbage_prefix(network,ldgr_id);
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("_",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pre,block], null));
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17215){
var state_val_17216 = (state_17215[(1)]);
if((state_val_17216 === (7))){
var inst_17204 = (state_17215[(7)]);
var inst_17206 = fluree.db.storage.core.serde(conn);
var inst_17207 = fluree.db.serde.protocol._deserialize_block(inst_17206,inst_17204);
var state_17215__$1 = state_17215;
var statearr_17217_17236 = state_17215__$1;
(statearr_17217_17236[(2)] = inst_17207);

(statearr_17217_17236[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17216 === (1))){
var state_17215__$1 = state_17215;
var statearr_17218_17237 = state_17215__$1;
(statearr_17218_17237[(2)] = null);

(statearr_17218_17237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17216 === (4))){
var inst_17194 = (state_17215[(2)]);
var state_17215__$1 = state_17215;
var statearr_17219_17238 = state_17215__$1;
(statearr_17219_17238[(2)] = inst_17194);

(statearr_17219_17238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17216 === (6))){
var inst_17204 = (state_17215[(7)]);
var inst_17203 = (state_17215[(2)]);
var inst_17204__$1 = fluree.db.util.async.throw_err(inst_17203);
var state_17215__$1 = (function (){var statearr_17220 = state_17215;
(statearr_17220[(7)] = inst_17204__$1);

return statearr_17220;
})();
if(cljs.core.truth_(inst_17204__$1)){
var statearr_17221_17239 = state_17215__$1;
(statearr_17221_17239[(1)] = (7));

} else {
var statearr_17222_17240 = state_17215__$1;
(statearr_17222_17240[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17216 === (3))){
var inst_17213 = (state_17215[(2)]);
var state_17215__$1 = state_17215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17215__$1,inst_17213);
} else {
if((state_val_17216 === (2))){
var _ = (function (){var statearr_17224 = state_17215;
(statearr_17224[(4)] = cljs.core.cons((5),(state_17215[(4)])));

return statearr_17224;
})();
var inst_17200 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17201 = fluree.db.storage.core.read(conn,inst_17200);
var state_17215__$1 = state_17215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17215__$1,(6),inst_17201);
} else {
if((state_val_17216 === (9))){
var inst_17210 = (state_17215[(2)]);
var _ = (function (){var statearr_17225 = state_17215;
(statearr_17225[(4)] = cljs.core.rest((state_17215[(4)])));

return statearr_17225;
})();
var state_17215__$1 = state_17215;
var statearr_17226_17241 = state_17215__$1;
(statearr_17226_17241[(2)] = inst_17210);

(statearr_17226_17241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17216 === (5))){
var _ = (function (){var statearr_17227 = state_17215;
(statearr_17227[(4)] = cljs.core.rest((state_17215[(4)])));

return statearr_17227;
})();
var state_17215__$1 = state_17215;
var ex17223 = (state_17215__$1[(2)]);
var statearr_17228_17242 = state_17215__$1;
(statearr_17228_17242[(5)] = ex17223);


if((ex17223 instanceof Error)){
var statearr_17229_17243 = state_17215__$1;
(statearr_17229_17243[(1)] = (4));

(statearr_17229_17243[(5)] = null);

} else {
throw ex17223;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17216 === (8))){
var state_17215__$1 = state_17215;
var statearr_17230_17244 = state_17215__$1;
(statearr_17230_17244[(2)] = null);

(statearr_17230_17244[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____0 = (function (){
var statearr_17231 = [null,null,null,null,null,null,null,null];
(statearr_17231[(0)] = fluree$db$storage$core$read_block_$_state_machine__2684__auto__);

(statearr_17231[(1)] = (1));

return statearr_17231;
});
var fluree$db$storage$core$read_block_$_state_machine__2684__auto____1 = (function (state_17215){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17215);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17232){var ex__2687__auto__ = e17232;
var statearr_17233_17245 = state_17215;
(statearr_17233_17245[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17215[(4)]))){
var statearr_17234_17246 = state_17215;
(statearr_17234_17246[(1)] = cljs.core.first((state_17215[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17247 = state_17215;
state_17215 = G__17247;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2684__auto__ = function(state_17215){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2684__auto____1.call(this,state_17215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17235 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17235[(6)] = c__2706__auto__);

return statearr_17235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17270){
var state_val_17271 = (state_17270[(1)]);
if((state_val_17271 === (7))){
var inst_17259 = (state_17270[(7)]);
var inst_17261 = fluree.db.storage.core.serde(conn);
var inst_17262 = fluree.db.serde.protocol._deserialize_block(inst_17261,inst_17259);
var state_17270__$1 = state_17270;
var statearr_17272_17291 = state_17270__$1;
(statearr_17272_17291[(2)] = inst_17262);

(statearr_17272_17291[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17271 === (1))){
var state_17270__$1 = state_17270;
var statearr_17273_17292 = state_17270__$1;
(statearr_17273_17292[(2)] = null);

(statearr_17273_17292[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17271 === (4))){
var inst_17248 = (state_17270[(2)]);
var state_17270__$1 = state_17270;
var statearr_17274_17293 = state_17270__$1;
(statearr_17274_17293[(2)] = inst_17248);

(statearr_17274_17293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17271 === (6))){
var inst_17259 = (state_17270[(7)]);
var inst_17258 = (state_17270[(2)]);
var inst_17259__$1 = fluree.db.util.async.throw_err(inst_17258);
var state_17270__$1 = (function (){var statearr_17275 = state_17270;
(statearr_17275[(7)] = inst_17259__$1);

return statearr_17275;
})();
if(cljs.core.truth_(inst_17259__$1)){
var statearr_17276_17294 = state_17270__$1;
(statearr_17276_17294[(1)] = (7));

} else {
var statearr_17277_17295 = state_17270__$1;
(statearr_17277_17295[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17271 === (3))){
var inst_17268 = (state_17270[(2)]);
var state_17270__$1 = state_17270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17270__$1,inst_17268);
} else {
if((state_val_17271 === (2))){
var _ = (function (){var statearr_17279 = state_17270;
(statearr_17279[(4)] = cljs.core.cons((5),(state_17270[(4)])));

return statearr_17279;
})();
var inst_17254 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_17255 = [inst_17254,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17256 = fluree.db.storage.core.read(conn,inst_17255);
var state_17270__$1 = state_17270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17270__$1,(6),inst_17256);
} else {
if((state_val_17271 === (9))){
var inst_17265 = (state_17270[(2)]);
var _ = (function (){var statearr_17280 = state_17270;
(statearr_17280[(4)] = cljs.core.rest((state_17270[(4)])));

return statearr_17280;
})();
var state_17270__$1 = state_17270;
var statearr_17281_17296 = state_17270__$1;
(statearr_17281_17296[(2)] = inst_17265);

(statearr_17281_17296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17271 === (5))){
var _ = (function (){var statearr_17282 = state_17270;
(statearr_17282[(4)] = cljs.core.rest((state_17270[(4)])));

return statearr_17282;
})();
var state_17270__$1 = state_17270;
var ex17278 = (state_17270__$1[(2)]);
var statearr_17283_17297 = state_17270__$1;
(statearr_17283_17297[(5)] = ex17278);


if((ex17278 instanceof Error)){
var statearr_17284_17298 = state_17270__$1;
(statearr_17284_17298[(1)] = (4));

(statearr_17284_17298[(5)] = null);

} else {
throw ex17278;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17271 === (8))){
var state_17270__$1 = state_17270;
var statearr_17285_17299 = state_17270__$1;
(statearr_17285_17299[(2)] = null);

(statearr_17285_17299[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_17286 = [null,null,null,null,null,null,null,null];
(statearr_17286[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__);

(statearr_17286[(1)] = (1));

return statearr_17286;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1 = (function (state_17270){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17270);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17287){var ex__2687__auto__ = e17287;
var statearr_17288_17300 = state_17270;
(statearr_17288_17300[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17270[(4)]))){
var statearr_17289_17301 = state_17270;
(statearr_17289_17301[(1)] = cljs.core.first((state_17270[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17302 = state_17270;
state_17270 = G__17302;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__ = function(state_17270){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1.call(this,state_17270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17290 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17290[(6)] = c__2706__auto__);

return statearr_17290;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,ledger_id,block_data,version){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17326){
var state_val_17327 = (state_17326[(1)]);
if((state_val_17327 === (1))){
var state_17326__$1 = state_17326;
var statearr_17328_17342 = state_17326__$1;
(statearr_17328_17342[(2)] = null);

(statearr_17328_17342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17327 === (2))){
var _ = (function (){var statearr_17329 = state_17326;
(statearr_17329[(4)] = cljs.core.cons((5),(state_17326[(4)])));

return statearr_17329;
})();
var inst_17309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17310 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17311 = (new cljs.core.PersistentVector(null,3,(5),inst_17309,inst_17310,null));
var inst_17312 = cljs.core.select_keys(block_data,inst_17311);
var inst_17313 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17312);
var inst_17314 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17313);
var inst_17315 = [inst_17314,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_17316 = fluree.db.storage.core.serde(conn);
var inst_17317 = fluree.db.serde.protocol._serialize_block(inst_17316,inst_17312);
var inst_17318 = fluree.db.storage.core.write(conn,inst_17315,inst_17317);
var state_17326__$1 = state_17326;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17326__$1,(6),inst_17318);
} else {
if((state_val_17327 === (3))){
var inst_17324 = (state_17326[(2)]);
var state_17326__$1 = state_17326;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17326__$1,inst_17324);
} else {
if((state_val_17327 === (4))){
var inst_17303 = (state_17326[(2)]);
var state_17326__$1 = state_17326;
var statearr_17331_17343 = state_17326__$1;
(statearr_17331_17343[(2)] = inst_17303);

(statearr_17331_17343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17327 === (5))){
var _ = (function (){var statearr_17332 = state_17326;
(statearr_17332[(4)] = cljs.core.rest((state_17326[(4)])));

return statearr_17332;
})();
var state_17326__$1 = state_17326;
var ex17330 = (state_17326__$1[(2)]);
var statearr_17333_17344 = state_17326__$1;
(statearr_17333_17344[(5)] = ex17330);


if((ex17330 instanceof Error)){
var statearr_17334_17345 = state_17326__$1;
(statearr_17334_17345[(1)] = (4));

(statearr_17334_17345[(5)] = null);

} else {
throw ex17330;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17327 === (6))){
var inst_17320 = (state_17326[(2)]);
var inst_17321 = fluree.db.util.async.throw_err(inst_17320);
var _ = (function (){var statearr_17335 = state_17326;
(statearr_17335[(4)] = cljs.core.rest((state_17326[(4)])));

return statearr_17335;
})();
var state_17326__$1 = state_17326;
var statearr_17336_17346 = state_17326__$1;
(statearr_17336_17346[(2)] = inst_17321);

(statearr_17336_17346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0 = (function (){
var statearr_17337 = [null,null,null,null,null,null,null];
(statearr_17337[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__);

(statearr_17337[(1)] = (1));

return statearr_17337;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1 = (function (state_17326){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17326);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17338){var ex__2687__auto__ = e17338;
var statearr_17339_17347 = state_17326;
(statearr_17339_17347[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17326[(4)]))){
var statearr_17340_17348 = state_17326;
(statearr_17340_17348[(1)] = cljs.core.first((state_17326[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17349 = state_17326;
state_17326 = G__17349;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__ = function(state_17326){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1.call(this,state_17326);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17341 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17341[(6)] = c__2706__auto__);

return statearr_17341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash   hash
 * :sigs   sigs
 * :txns   {tid (tx-id, string) {:cmd command (JSON string)
 *                               :sig signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,ledger_id,block_data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17372){
var state_val_17373 = (state_17372[(1)]);
if((state_val_17373 === (1))){
var state_17372__$1 = state_17372;
var statearr_17374_17388 = state_17372__$1;
(statearr_17374_17388[(2)] = null);

(statearr_17374_17388[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (2))){
var _ = (function (){var statearr_17375 = state_17372;
(statearr_17375[(4)] = cljs.core.cons((5),(state_17372[(4)])));

return statearr_17375;
})();
var inst_17356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17357 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17358 = (new cljs.core.PersistentVector(null,3,(5),inst_17356,inst_17357,null));
var inst_17359 = cljs.core.select_keys(block_data,inst_17358);
var inst_17360 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_17359);
var inst_17361 = fluree.db.storage.core.ledger_block_key(network,ledger_id,inst_17360);
var inst_17362 = fluree.db.storage.core.serde(conn);
var inst_17363 = fluree.db.serde.protocol._serialize_block(inst_17362,inst_17359);
var inst_17364 = fluree.db.storage.core.write(conn,inst_17361,inst_17363);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17372__$1,(6),inst_17364);
} else {
if((state_val_17373 === (3))){
var inst_17370 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17372__$1,inst_17370);
} else {
if((state_val_17373 === (4))){
var inst_17350 = (state_17372[(2)]);
var state_17372__$1 = state_17372;
var statearr_17377_17389 = state_17372__$1;
(statearr_17377_17389[(2)] = inst_17350);

(statearr_17377_17389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (5))){
var _ = (function (){var statearr_17378 = state_17372;
(statearr_17378[(4)] = cljs.core.rest((state_17372[(4)])));

return statearr_17378;
})();
var state_17372__$1 = state_17372;
var ex17376 = (state_17372__$1[(2)]);
var statearr_17379_17390 = state_17372__$1;
(statearr_17379_17390[(5)] = ex17376);


if((ex17376 instanceof Error)){
var statearr_17380_17391 = state_17372__$1;
(statearr_17380_17391[(1)] = (4));

(statearr_17380_17391[(5)] = null);

} else {
throw ex17376;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17373 === (6))){
var inst_17366 = (state_17372[(2)]);
var inst_17367 = fluree.db.util.async.throw_err(inst_17366);
var _ = (function (){var statearr_17381 = state_17372;
(statearr_17381[(4)] = cljs.core.rest((state_17372[(4)])));

return statearr_17381;
})();
var state_17372__$1 = state_17372;
var statearr_17382_17392 = state_17372__$1;
(statearr_17382_17392[(2)] = inst_17367);

(statearr_17382_17392[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____0 = (function (){
var statearr_17383 = [null,null,null,null,null,null,null];
(statearr_17383[(0)] = fluree$db$storage$core$write_block_$_state_machine__2684__auto__);

(statearr_17383[(1)] = (1));

return statearr_17383;
});
var fluree$db$storage$core$write_block_$_state_machine__2684__auto____1 = (function (state_17372){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17372);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17384){var ex__2687__auto__ = e17384;
var statearr_17385_17393 = state_17372;
(statearr_17385_17393[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17372[(4)]))){
var statearr_17386_17394 = state_17372;
(statearr_17386_17394[(1)] = cljs.core.first((state_17372[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17395 = state_17372;
state_17372 = G__17395;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2684__auto__ = function(state_17372){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2684__auto____1.call(this,state_17372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17387 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17387[(6)] = c__2706__auto__);

return statearr_17387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into
 *   storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.random_leaf_id = (function fluree$db$storage$core$random_leaf_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"l");
});
/**
 * Writes `leaf` to storage under the provided `leaf-id`, computing a new id if
 *   one isn't provided. Returns the leaf map with the id used attached uner the
 *   `:id` key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(var_args){
var G__17397 = arguments.length;
switch (G__17397) {
case 5:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,leaf){
var leaf_id = fluree.db.storage.core.random_leaf_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,leaf_id,leaf);
}));

(fluree.db.storage.core.write_leaf.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,leaf_id,p__17398){
var map__17399 = p__17398;
var map__17399__$1 = cljs.core.__destructure_map(map__17399);
var leaf = map__17399__$1;
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17399__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17420){
var state_val_17421 = (state_17420[(1)]);
if((state_val_17421 === (1))){
var state_17420__$1 = state_17420;
var statearr_17422_17438 = state_17420__$1;
(statearr_17422_17438[(2)] = null);

(statearr_17422_17438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17421 === (2))){
var _ = (function (){var statearr_17423 = state_17420;
(statearr_17423[(4)] = cljs.core.cons((5),(state_17420[(4)])));

return statearr_17423;
})();
var inst_17406 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_17407 = [flakes];
var inst_17408 = cljs.core.PersistentHashMap.fromArrays(inst_17406,inst_17407);
var inst_17409 = fluree.db.storage.core.serde(conn);
var inst_17410 = fluree.db.serde.protocol._serialize_leaf(inst_17409,inst_17408);
var inst_17411 = fluree.db.storage.core.write(conn,leaf_id,inst_17410);
var state_17420__$1 = state_17420;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17420__$1,(6),inst_17411);
} else {
if((state_val_17421 === (3))){
var inst_17418 = (state_17420[(2)]);
var state_17420__$1 = state_17420;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17420__$1,inst_17418);
} else {
if((state_val_17421 === (4))){
var inst_17400 = (state_17420[(2)]);
var state_17420__$1 = state_17420;
var statearr_17425_17439 = state_17420__$1;
(statearr_17425_17439[(2)] = inst_17400);

(statearr_17425_17439[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17421 === (5))){
var _ = (function (){var statearr_17426 = state_17420;
(statearr_17426[(4)] = cljs.core.rest((state_17420[(4)])));

return statearr_17426;
})();
var state_17420__$1 = state_17420;
var ex17424 = (state_17420__$1[(2)]);
var statearr_17427_17440 = state_17420__$1;
(statearr_17427_17440[(5)] = ex17424);


if((ex17424 instanceof Error)){
var statearr_17428_17441 = state_17420__$1;
(statearr_17428_17441[(1)] = (4));

(statearr_17428_17441[(5)] = null);

} else {
throw ex17424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17421 === (6))){
var inst_17413 = (state_17420[(2)]);
var inst_17414 = fluree.db.util.async.throw_err(inst_17413);
var inst_17415 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(leaf,new cljs.core.Keyword(null,"id","id",-1388402092),leaf_id);
var _ = (function (){var statearr_17429 = state_17420;
(statearr_17429[(4)] = cljs.core.rest((state_17420[(4)])));

return statearr_17429;
})();
var state_17420__$1 = (function (){var statearr_17430 = state_17420;
(statearr_17430[(7)] = inst_17414);

return statearr_17430;
})();
var statearr_17431_17442 = state_17420__$1;
(statearr_17431_17442[(2)] = inst_17415);

(statearr_17431_17442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17432 = [null,null,null,null,null,null,null,null];
(statearr_17432[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17432[(1)] = (1));

return statearr_17432;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17420){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17420);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17433){var ex__2687__auto__ = e17433;
var statearr_17434_17443 = state_17420;
(statearr_17434_17443[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17420[(4)]))){
var statearr_17435_17444 = state_17420;
(statearr_17435_17444[(1)] = cljs.core.first((state_17420[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17445 = state_17420;
state_17420 = G__17445;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17420){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17420);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17436 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17436[(6)] = c__2706__auto__);

return statearr_17436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_leaf.cljs$lang$maxFixedArity = 6);

/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17462){
var state_val_17463 = (state_17462[(1)]);
if((state_val_17463 === (1))){
var state_17462__$1 = state_17462;
var statearr_17464_17479 = state_17462__$1;
(statearr_17464_17479[(2)] = null);

(statearr_17464_17479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17463 === (2))){
var _ = (function (){var statearr_17465 = state_17462;
(statearr_17465[(4)] = cljs.core.cons((5),(state_17462[(4)])));

return statearr_17465;
})();
var inst_17452 = fluree.db.storage.core.serde(conn);
var inst_17453 = fluree.db.serde.protocol._serialize_branch(inst_17452,data);
var inst_17454 = fluree.db.storage.core.write(conn,key,inst_17453);
var state_17462__$1 = state_17462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17462__$1,(6),inst_17454);
} else {
if((state_val_17463 === (3))){
var inst_17460 = (state_17462[(2)]);
var state_17462__$1 = state_17462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17462__$1,inst_17460);
} else {
if((state_val_17463 === (4))){
var inst_17446 = (state_17462[(2)]);
var state_17462__$1 = state_17462;
var statearr_17467_17480 = state_17462__$1;
(statearr_17467_17480[(2)] = inst_17446);

(statearr_17467_17480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17463 === (5))){
var _ = (function (){var statearr_17468 = state_17462;
(statearr_17468[(4)] = cljs.core.rest((state_17462[(4)])));

return statearr_17468;
})();
var state_17462__$1 = state_17462;
var ex17466 = (state_17462__$1[(2)]);
var statearr_17469_17481 = state_17462__$1;
(statearr_17469_17481[(5)] = ex17466);


if((ex17466 instanceof Error)){
var statearr_17470_17482 = state_17462__$1;
(statearr_17470_17482[(1)] = (4));

(statearr_17470_17482[(5)] = null);

} else {
throw ex17466;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17463 === (6))){
var inst_17456 = (state_17462[(2)]);
var inst_17457 = fluree.db.util.async.throw_err(inst_17456);
var _ = (function (){var statearr_17471 = state_17462;
(statearr_17471[(4)] = cljs.core.rest((state_17462[(4)])));

return statearr_17471;
})();
var state_17462__$1 = (function (){var statearr_17472 = state_17462;
(statearr_17472[(7)] = inst_17457);

return statearr_17472;
})();
var statearr_17473_17483 = state_17462__$1;
(statearr_17473_17483[(2)] = key);

(statearr_17473_17483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0 = (function (){
var statearr_17474 = [null,null,null,null,null,null,null,null];
(statearr_17474[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__);

(statearr_17474[(1)] = (1));

return statearr_17474;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1 = (function (state_17462){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17462);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17475){var ex__2687__auto__ = e17475;
var statearr_17476_17484 = state_17462;
(statearr_17476_17484[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17462[(4)]))){
var statearr_17477_17485 = state_17462;
(statearr_17477_17485[(1)] = cljs.core.first((state_17462[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17486 = state_17462;
state_17462 = G__17486;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__ = function(state_17462){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1.call(this,state_17462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17478 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17478[(6)] = c__2706__auto__);

return statearr_17478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.random_branch_id = (function fluree$db$storage$core$random_branch_id(network,ledger_id,idx){
return fluree.db.storage.core.ledger_node_key(network,ledger_id,idx,cljs.core.random_uuid(),"b");
});
/**
 * Writes `branch` to storage under the provided `branch-id`, computing a new id
 *   if one isn't provided. Returns the branch map with the id used attached uner
 *   the `:id` key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(var_args){
var G__17488 = arguments.length;
switch (G__17488) {
case 5:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,idx_type,branch){
var branch_id = fluree.db.storage.core.random_branch_id(network,ledger_id,idx_type);
return fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6(conn,network,ledger_id,idx_type,branch_id,branch);
}));

(fluree.db.storage.core.write_branch.cljs$core$IFn$_invoke$arity$6 = (function (conn,network,ledger_id,idx_type,branch_id,p__17489){
var map__17490 = p__17489;
var map__17490__$1 = cljs.core.__destructure_map(map__17490);
var branch = map__17490__$1;
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17490__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17516){
var state_val_17517 = (state_17516[(1)]);
if((state_val_17517 === (1))){
var state_17516__$1 = state_17516;
var statearr_17518_17535 = state_17516__$1;
(statearr_17518_17535[(2)] = null);

(statearr_17518_17535[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (2))){
var _ = (function (){var statearr_17519 = state_17516;
(statearr_17519[(4)] = cljs.core.cons((5),(state_17516[(4)])));

return statearr_17519;
})();
var inst_17497 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.val,children);
var inst_17498 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.storage.core.child_data,inst_17497);
var inst_17499 = cljs.core.first(inst_17498);
var inst_17500 = new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(inst_17499);
var inst_17501 = cljs.core.rseq(inst_17498);
var inst_17502 = cljs.core.first(inst_17501);
var inst_17503 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_17502);
var inst_17504 = [new cljs.core.Keyword(null,"children","children",-940561982)];
var inst_17505 = [inst_17498];
var inst_17506 = cljs.core.PersistentHashMap.fromArrays(inst_17504,inst_17505);
var inst_17507 = fluree.db.storage.core.write_branch_data(conn,branch_id,inst_17506);
var state_17516__$1 = (function (){var statearr_17520 = state_17516;
(statearr_17520[(7)] = inst_17500);

(statearr_17520[(8)] = inst_17503);

return statearr_17520;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17516__$1,(6),inst_17507);
} else {
if((state_val_17517 === (3))){
var inst_17514 = (state_17516[(2)]);
var state_17516__$1 = state_17516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17516__$1,inst_17514);
} else {
if((state_val_17517 === (4))){
var inst_17491 = (state_17516[(2)]);
var state_17516__$1 = state_17516;
var statearr_17522_17536 = state_17516__$1;
(statearr_17522_17536[(2)] = inst_17491);

(statearr_17522_17536[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (5))){
var _ = (function (){var statearr_17523 = state_17516;
(statearr_17523[(4)] = cljs.core.rest((state_17516[(4)])));

return statearr_17523;
})();
var state_17516__$1 = state_17516;
var ex17521 = (state_17516__$1[(2)]);
var statearr_17524_17537 = state_17516__$1;
(statearr_17524_17537[(5)] = ex17521);


if((ex17521 instanceof Error)){
var statearr_17525_17538 = state_17516__$1;
(statearr_17525_17538[(1)] = (4));

(statearr_17525_17538[(5)] = null);

} else {
throw ex17521;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17517 === (6))){
var inst_17509 = (state_17516[(2)]);
var inst_17510 = fluree.db.util.async.throw_err(inst_17509);
var inst_17511 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch,new cljs.core.Keyword(null,"id","id",-1388402092),branch_id);
var _ = (function (){var statearr_17526 = state_17516;
(statearr_17526[(4)] = cljs.core.rest((state_17516[(4)])));

return statearr_17526;
})();
var state_17516__$1 = (function (){var statearr_17527 = state_17516;
(statearr_17527[(9)] = inst_17510);

return statearr_17527;
})();
var statearr_17528_17539 = state_17516__$1;
(statearr_17528_17539[(2)] = inst_17511);

(statearr_17528_17539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17529 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17529[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17529[(1)] = (1));

return statearr_17529;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17516){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17516);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17530){var ex__2687__auto__ = e17530;
var statearr_17531_17540 = state_17516;
(statearr_17531_17540[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17516[(4)]))){
var statearr_17532_17541 = state_17516;
(statearr_17532_17541[(1)] = cljs.core.first((state_17516[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17542 = state_17516;
state_17516 = G__17542;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17516){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17533 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17533[(6)] = c__2706__auto__);

return statearr_17533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_branch.cljs$lang$maxFixedArity = 6);

/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,garbage){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17570){
var state_val_17571 = (state_17570[(1)]);
if((state_val_17571 === (1))){
var state_17570__$1 = state_17570;
var statearr_17572_17588 = state_17570__$1;
(statearr_17572_17588[(2)] = null);

(statearr_17572_17588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17571 === (2))){
var inst_17556 = (state_17570[(7)]);
var _ = (function (){var statearr_17573 = state_17570;
(statearr_17573[(4)] = cljs.core.cons((5),(state_17570[(4)])));

return statearr_17573;
})();
var inst_17550 = db;
var inst_17551 = cljs.core.__destructure_map(inst_17550);
var inst_17552 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17551,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17551,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17551,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17555 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17551,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17556__$1 = fluree.db.storage.core.ledger_garbage_key(inst_17553,inst_17554,inst_17555);
var inst_17557 = [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_17558 = [inst_17554,inst_17555,garbage];
var inst_17559 = cljs.core.PersistentHashMap.fromArrays(inst_17557,inst_17558);
var inst_17560 = fluree.db.storage.core.serde(inst_17552);
var inst_17561 = fluree.db.serde.protocol._serialize_garbage(inst_17560,inst_17559);
var inst_17562 = fluree.db.storage.core.write(inst_17552,inst_17556__$1,inst_17561);
var state_17570__$1 = (function (){var statearr_17574 = state_17570;
(statearr_17574[(7)] = inst_17556__$1);

return statearr_17574;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17570__$1,(6),inst_17562);
} else {
if((state_val_17571 === (3))){
var inst_17568 = (state_17570[(2)]);
var state_17570__$1 = state_17570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17570__$1,inst_17568);
} else {
if((state_val_17571 === (4))){
var inst_17543 = (state_17570[(2)]);
var state_17570__$1 = state_17570;
var statearr_17576_17589 = state_17570__$1;
(statearr_17576_17589[(2)] = inst_17543);

(statearr_17576_17589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17571 === (5))){
var _ = (function (){var statearr_17577 = state_17570;
(statearr_17577[(4)] = cljs.core.rest((state_17570[(4)])));

return statearr_17577;
})();
var state_17570__$1 = state_17570;
var ex17575 = (state_17570__$1[(2)]);
var statearr_17578_17590 = state_17570__$1;
(statearr_17578_17590[(5)] = ex17575);


if((ex17575 instanceof Error)){
var statearr_17579_17591 = state_17570__$1;
(statearr_17579_17591[(1)] = (4));

(statearr_17579_17591[(5)] = null);

} else {
throw ex17575;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17571 === (6))){
var inst_17556 = (state_17570[(7)]);
var inst_17564 = (state_17570[(2)]);
var inst_17565 = fluree.db.util.async.throw_err(inst_17564);
var _ = (function (){var statearr_17580 = state_17570;
(statearr_17580[(4)] = cljs.core.rest((state_17570[(4)])));

return statearr_17580;
})();
var state_17570__$1 = (function (){var statearr_17581 = state_17570;
(statearr_17581[(8)] = inst_17565);

return statearr_17581;
})();
var statearr_17582_17592 = state_17570__$1;
(statearr_17582_17592[(2)] = inst_17556);

(statearr_17582_17592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_17583 = [null,null,null,null,null,null,null,null,null];
(statearr_17583[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__);

(statearr_17583[(1)] = (1));

return statearr_17583;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1 = (function (state_17570){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17570);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17584){var ex__2687__auto__ = e17584;
var statearr_17585_17593 = state_17570;
(statearr_17585_17593[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17570[(4)]))){
var statearr_17586_17594 = state_17570;
(statearr_17586_17594[(1)] = cljs.core.first((state_17570[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17595 = state_17570;
state_17570 = G__17595;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__ = function(state_17570){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1.call(this,state_17570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17587 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17587[(6)] = c__2706__auto__);

return statearr_17587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__17597 = arguments.length;
switch (G__17597) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17655){
var state_val_17656 = (state_17655[(1)]);
if((state_val_17656 === (7))){
var state_17655__$1 = state_17655;
var statearr_17657_17683 = state_17655__$1;
(statearr_17657_17683[(2)] = (0));

(statearr_17657_17683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (1))){
var state_17655__$1 = state_17655;
var statearr_17658_17684 = state_17655__$1;
(statearr_17658_17684[(2)] = null);

(statearr_17658_17684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (4))){
var inst_17598 = (state_17655[(2)]);
var state_17655__$1 = state_17655;
var statearr_17659_17685 = state_17655__$1;
(statearr_17659_17685[(2)] = inst_17598);

(statearr_17659_17685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (6))){
var inst_17624 = (state_17655[(7)]);
var state_17655__$1 = state_17655;
var statearr_17660_17686 = state_17655__$1;
(statearr_17660_17686[(2)] = inst_17624);

(statearr_17660_17686[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (3))){
var inst_17653 = (state_17655[(2)]);
var state_17655__$1 = state_17655;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17655__$1,inst_17653);
} else {
if((state_val_17656 === (12))){
var inst_17621 = (state_17655[(8)]);
var inst_17649 = (state_17655[(2)]);
var inst_17650 = fluree.db.util.async.throw_err(inst_17649);
var _ = (function (){var statearr_17661 = state_17655;
(statearr_17661[(4)] = cljs.core.rest((state_17655[(4)])));

return statearr_17661;
})();
var state_17655__$1 = (function (){var statearr_17662 = state_17655;
(statearr_17662[(9)] = inst_17650);

return statearr_17662;
})();
var statearr_17663_17687 = state_17655__$1;
(statearr_17663_17687[(2)] = inst_17621);

(statearr_17663_17687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (2))){
var inst_17616 = (state_17655[(10)]);
var inst_17624 = (state_17655[(7)]);
var inst_17613 = (state_17655[(11)]);
var inst_17611 = (state_17655[(12)]);
var _ = (function (){var statearr_17664 = state_17655;
(statearr_17664[(4)] = cljs.core.cons((5),(state_17655[(4)])));

return statearr_17664;
})();
var inst_17605 = db;
var inst_17606 = cljs.core.__destructure_map(inst_17605);
var inst_17607 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_17608 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_17609 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_17610 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_17611__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_17612 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_17613__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"block","block",664686210));
var inst_17614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_17615 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var inst_17616__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_17617 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_17618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_17619 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_17620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17606,new cljs.core.Keyword(null,"post","post",269697687));
var inst_17621 = fluree.db.storage.core.ledger_root_key(inst_17607,inst_17616__$1,inst_17613__$1);
var inst_17622 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_17623 = fluree.db.storage.core.child_data(inst_17614);
var inst_17624__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_17611__$1);
var state_17655__$1 = (function (){var statearr_17665 = state_17655;
(statearr_17665[(13)] = inst_17612);

(statearr_17665[(14)] = inst_17619);

(statearr_17665[(15)] = inst_17623);

(statearr_17665[(16)] = inst_17610);

(statearr_17665[(10)] = inst_17616__$1);

(statearr_17665[(8)] = inst_17621);

(statearr_17665[(7)] = inst_17624__$1);

(statearr_17665[(17)] = inst_17618);

(statearr_17665[(18)] = inst_17617);

(statearr_17665[(19)] = inst_17622);

(statearr_17665[(20)] = inst_17609);

(statearr_17665[(11)] = inst_17613__$1);

(statearr_17665[(21)] = inst_17620);

(statearr_17665[(22)] = inst_17615);

(statearr_17665[(12)] = inst_17611__$1);

(statearr_17665[(23)] = inst_17608);

return statearr_17665;
})();
if(cljs.core.truth_(inst_17624__$1)){
var statearr_17666_17688 = state_17655__$1;
(statearr_17666_17688[(1)] = (6));

} else {
var statearr_17667_17689 = state_17655__$1;
(statearr_17667_17689[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (11))){
var inst_17612 = (state_17655[(13)]);
var inst_17619 = (state_17655[(14)]);
var inst_17623 = (state_17655[(15)]);
var inst_17610 = (state_17655[(16)]);
var inst_17629 = (state_17655[(24)]);
var inst_17616 = (state_17655[(10)]);
var inst_17621 = (state_17655[(8)]);
var inst_17618 = (state_17655[(17)]);
var inst_17622 = (state_17655[(19)]);
var inst_17628 = (state_17655[(25)]);
var inst_17609 = (state_17655[(20)]);
var inst_17613 = (state_17655[(11)]);
var inst_17620 = (state_17655[(21)]);
var inst_17611 = (state_17655[(12)]);
var inst_17608 = (state_17655[(23)]);
var inst_17634 = (state_17655[(2)]);
var inst_17635 = fluree.db.storage.core.child_data(inst_17618);
var inst_17636 = fluree.db.storage.core.child_data(inst_17620);
var inst_17637 = fluree.db.util.core.current_time_millis();
var inst_17638 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17639 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_17640 = (new cljs.core.PersistentVector(null,2,(5),inst_17638,inst_17639,null));
var inst_17641 = cljs.core.select_keys(inst_17611,inst_17640);
var inst_17642 = fluree.db.storage.core.child_data(inst_17610);
var inst_17643 = [inst_17613,inst_17623,inst_17628,inst_17616,inst_17629,inst_17634,inst_17635,inst_17636,inst_17608,inst_17637,inst_17609,inst_17619,inst_17641,inst_17642];
var inst_17644 = cljs.core.PersistentHashMap.fromArrays(inst_17622,inst_17643);
var inst_17645 = fluree.db.storage.core.serde(inst_17612);
var inst_17646 = fluree.db.serde.protocol._serialize_db_root(inst_17645,inst_17644);
var inst_17647 = fluree.db.storage.core.write(inst_17612,inst_17621,inst_17646);
var state_17655__$1 = state_17655;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17655__$1,(12),inst_17647);
} else {
if((state_val_17656 === (9))){
var inst_17630 = (state_17655[(26)]);
var state_17655__$1 = state_17655;
var statearr_17669_17690 = state_17655__$1;
(statearr_17669_17690[(2)] = inst_17630);

(statearr_17669_17690[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (5))){
var _ = (function (){var statearr_17670 = state_17655;
(statearr_17670[(4)] = cljs.core.rest((state_17655[(4)])));

return statearr_17670;
})();
var state_17655__$1 = state_17655;
var ex17668 = (state_17655__$1[(2)]);
var statearr_17671_17691 = state_17655__$1;
(statearr_17671_17691[(5)] = ex17668);


if((ex17668 instanceof Error)){
var statearr_17672_17692 = state_17655__$1;
(statearr_17672_17692[(1)] = (4));

(statearr_17672_17692[(5)] = null);

} else {
throw ex17668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (10))){
var inst_17617 = (state_17655[(18)]);
var state_17655__$1 = state_17655;
var statearr_17673_17693 = state_17655__$1;
(statearr_17673_17693[(2)] = inst_17617);

(statearr_17673_17693[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17656 === (8))){
var inst_17630 = (state_17655[(26)]);
var inst_17615 = (state_17655[(22)]);
var inst_17628 = (state_17655[(2)]);
var inst_17629 = fluree.db.storage.core.child_data(inst_17615);
var inst_17630__$1 = custom_ecount;
var state_17655__$1 = (function (){var statearr_17674 = state_17655;
(statearr_17674[(24)] = inst_17629);

(statearr_17674[(26)] = inst_17630__$1);

(statearr_17674[(25)] = inst_17628);

return statearr_17674;
})();
if(cljs.core.truth_(inst_17630__$1)){
var statearr_17675_17694 = state_17655__$1;
(statearr_17675_17694[(1)] = (9));

} else {
var statearr_17676_17695 = state_17655__$1;
(statearr_17676_17695[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_17677 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17677[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_17677[(1)] = (1));

return statearr_17677;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_17655){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17655);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17678){var ex__2687__auto__ = e17678;
var statearr_17679_17696 = state_17655;
(statearr_17679_17696[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17655[(4)]))){
var statearr_17680_17697 = state_17655;
(statearr_17680_17697[(1)] = cljs.core.first((state_17655[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17698 = state_17655;
state_17655 = G__17698;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_17655){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_17655);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17681 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17681[(6)] = c__2706__auto__);

return statearr_17681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(p__17699,key){
var map__17700 = p__17699;
var map__17700__$1 = cljs.core.__destructure_map(map__17700);
var conn = map__17700__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17700__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17720){
var state_val_17721 = (state_17720[(1)]);
if((state_val_17721 === (7))){
var inst_17710 = (state_17720[(7)]);
var inst_17712 = fluree.db.serde.protocol._deserialize_branch(serializer,inst_17710);
var state_17720__$1 = state_17720;
var statearr_17722_17741 = state_17720__$1;
(statearr_17722_17741[(2)] = inst_17712);

(statearr_17722_17741[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (1))){
var state_17720__$1 = state_17720;
var statearr_17723_17742 = state_17720__$1;
(statearr_17723_17742[(2)] = null);

(statearr_17723_17742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (4))){
var inst_17701 = (state_17720[(2)]);
var state_17720__$1 = state_17720;
var statearr_17724_17743 = state_17720__$1;
(statearr_17724_17743[(2)] = inst_17701);

(statearr_17724_17743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (6))){
var inst_17710 = (state_17720[(7)]);
var inst_17709 = (state_17720[(2)]);
var inst_17710__$1 = fluree.db.util.async.throw_err(inst_17709);
var state_17720__$1 = (function (){var statearr_17725 = state_17720;
(statearr_17725[(7)] = inst_17710__$1);

return statearr_17725;
})();
if(cljs.core.truth_(inst_17710__$1)){
var statearr_17726_17744 = state_17720__$1;
(statearr_17726_17744[(1)] = (7));

} else {
var statearr_17727_17745 = state_17720__$1;
(statearr_17727_17745[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (3))){
var inst_17718 = (state_17720[(2)]);
var state_17720__$1 = state_17720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17720__$1,inst_17718);
} else {
if((state_val_17721 === (2))){
var _ = (function (){var statearr_17729 = state_17720;
(statearr_17729[(4)] = cljs.core.cons((5),(state_17720[(4)])));

return statearr_17729;
})();
var inst_17707 = fluree.db.storage.core.read(conn,key);
var state_17720__$1 = state_17720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17720__$1,(6),inst_17707);
} else {
if((state_val_17721 === (9))){
var inst_17715 = (state_17720[(2)]);
var _ = (function (){var statearr_17730 = state_17720;
(statearr_17730[(4)] = cljs.core.rest((state_17720[(4)])));

return statearr_17730;
})();
var state_17720__$1 = state_17720;
var statearr_17731_17746 = state_17720__$1;
(statearr_17731_17746[(2)] = inst_17715);

(statearr_17731_17746[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (5))){
var _ = (function (){var statearr_17732 = state_17720;
(statearr_17732[(4)] = cljs.core.rest((state_17720[(4)])));

return statearr_17732;
})();
var state_17720__$1 = state_17720;
var ex17728 = (state_17720__$1[(2)]);
var statearr_17733_17747 = state_17720__$1;
(statearr_17733_17747[(5)] = ex17728);


if((ex17728 instanceof Error)){
var statearr_17734_17748 = state_17720__$1;
(statearr_17734_17748[(1)] = (4));

(statearr_17734_17748[(5)] = null);

} else {
throw ex17728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17721 === (8))){
var state_17720__$1 = state_17720;
var statearr_17735_17749 = state_17720__$1;
(statearr_17735_17749[(2)] = null);

(statearr_17735_17749[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0 = (function (){
var statearr_17736 = [null,null,null,null,null,null,null,null];
(statearr_17736[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2684__auto__);

(statearr_17736[(1)] = (1));

return statearr_17736;
});
var fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1 = (function (state_17720){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17720);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17737){var ex__2687__auto__ = e17737;
var statearr_17738_17750 = state_17720;
(statearr_17738_17750[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17720[(4)]))){
var statearr_17739_17751 = state_17720;
(statearr_17739_17751[(1)] = cljs.core.first((state_17720[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17752 = state_17720;
state_17720 = G__17752;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__ = function(state_17720){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1.call(this,state_17720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17740 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17740[(6)] = c__2706__auto__);

return statearr_17740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(p__17753,key){
var map__17754 = p__17753;
var map__17754__$1 = cljs.core.__destructure_map(map__17754);
var conn = map__17754__$1;
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17754__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17774){
var state_val_17775 = (state_17774[(1)]);
if((state_val_17775 === (7))){
var inst_17764 = (state_17774[(7)]);
var inst_17766 = fluree.db.serde.protocol._deserialize_leaf(serializer,inst_17764);
var state_17774__$1 = state_17774;
var statearr_17776_17795 = state_17774__$1;
(statearr_17776_17795[(2)] = inst_17766);

(statearr_17776_17795[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17775 === (1))){
var state_17774__$1 = state_17774;
var statearr_17777_17796 = state_17774__$1;
(statearr_17777_17796[(2)] = null);

(statearr_17777_17796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17775 === (4))){
var inst_17755 = (state_17774[(2)]);
var state_17774__$1 = state_17774;
var statearr_17778_17797 = state_17774__$1;
(statearr_17778_17797[(2)] = inst_17755);

(statearr_17778_17797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17775 === (6))){
var inst_17764 = (state_17774[(7)]);
var inst_17763 = (state_17774[(2)]);
var inst_17764__$1 = fluree.db.util.async.throw_err(inst_17763);
var state_17774__$1 = (function (){var statearr_17779 = state_17774;
(statearr_17779[(7)] = inst_17764__$1);

return statearr_17779;
})();
if(cljs.core.truth_(inst_17764__$1)){
var statearr_17780_17798 = state_17774__$1;
(statearr_17780_17798[(1)] = (7));

} else {
var statearr_17781_17799 = state_17774__$1;
(statearr_17781_17799[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17775 === (3))){
var inst_17772 = (state_17774[(2)]);
var state_17774__$1 = state_17774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17774__$1,inst_17772);
} else {
if((state_val_17775 === (2))){
var _ = (function (){var statearr_17783 = state_17774;
(statearr_17783[(4)] = cljs.core.cons((5),(state_17774[(4)])));

return statearr_17783;
})();
var inst_17761 = fluree.db.storage.core.read(conn,key);
var state_17774__$1 = state_17774;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17774__$1,(6),inst_17761);
} else {
if((state_val_17775 === (9))){
var inst_17769 = (state_17774[(2)]);
var _ = (function (){var statearr_17784 = state_17774;
(statearr_17784[(4)] = cljs.core.rest((state_17774[(4)])));

return statearr_17784;
})();
var state_17774__$1 = state_17774;
var statearr_17785_17800 = state_17774__$1;
(statearr_17785_17800[(2)] = inst_17769);

(statearr_17785_17800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17775 === (5))){
var _ = (function (){var statearr_17786 = state_17774;
(statearr_17786[(4)] = cljs.core.rest((state_17774[(4)])));

return statearr_17786;
})();
var state_17774__$1 = state_17774;
var ex17782 = (state_17774__$1[(2)]);
var statearr_17787_17801 = state_17774__$1;
(statearr_17787_17801[(5)] = ex17782);


if((ex17782 instanceof Error)){
var statearr_17788_17802 = state_17774__$1;
(statearr_17788_17802[(1)] = (4));

(statearr_17788_17802[(5)] = null);

} else {
throw ex17782;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17775 === (8))){
var state_17774__$1 = state_17774;
var statearr_17789_17803 = state_17774__$1;
(statearr_17789_17803[(2)] = null);

(statearr_17789_17803[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0 = (function (){
var statearr_17790 = [null,null,null,null,null,null,null,null];
(statearr_17790[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__);

(statearr_17790[(1)] = (1));

return statearr_17790;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1 = (function (state_17774){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17774);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17791){var ex__2687__auto__ = e17791;
var statearr_17792_17804 = state_17774;
(statearr_17792_17804[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17774[(4)]))){
var statearr_17793_17805 = state_17774;
(statearr_17793_17805[(1)] = cljs.core.first((state_17774[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17806 = state_17774;
state_17774 = G__17806;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__ = function(state_17774){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1.call(this,state_17774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17794 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17794[(6)] = c__2706__auto__);

return statearr_17794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(_conn,p__17807,index,index_data){
var map__17808 = p__17807;
var map__17808__$1 = cljs.core.__destructure_map(map__17808);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17808__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17808__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var comparators = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17808__$1,new cljs.core.Keyword(null,"comparators","comparators",-1325611955));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17808__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17808__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var cmp = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,index);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db index root: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
var G__17809 = index_data;
var G__17809__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17809,new cljs.core.Keyword(null,"rhs","rhs",-229356739),fluree.db.flake.parts__GT_Flake):G__17809);
var G__17809__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(index_data))?cljs.core.update.cljs$core$IFn$_invoke$arity$3(G__17809__$1,new cljs.core.Keyword(null,"first","first",-644103046),fluree.db.flake.parts__GT_Flake):G__17809__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__17809__$2,new cljs.core.Keyword(null,"comparator","comparator",2144896662),cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true], 0));

});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__17810 = root_data;
var map__17810__$1 = cljs.core.__destructure_map(map__17810);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17810__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
var idx_root = fluree.db.storage.core.reify_index_root(conn,db,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,idx_root);
}),db_STAR_,fluree.db.index.types);
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17832){
var state_val_17833 = (state_17832[(1)]);
if((state_val_17833 === (7))){
var state_17832__$1 = state_17832;
var statearr_17834_17854 = state_17832__$1;
(statearr_17834_17854[(2)] = null);

(statearr_17834_17854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17833 === (1))){
var state_17832__$1 = state_17832;
var statearr_17835_17855 = state_17832__$1;
(statearr_17835_17855[(2)] = null);

(statearr_17835_17855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17833 === (4))){
var inst_17811 = (state_17832[(2)]);
var state_17832__$1 = state_17832;
var statearr_17836_17856 = state_17832__$1;
(statearr_17836_17856[(2)] = inst_17811);

(statearr_17836_17856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17833 === (6))){
var inst_17818 = (state_17832[(7)]);
var inst_17820 = fluree.db.storage.core.serde(conn);
var state_17832__$1 = (function (){var statearr_17837 = state_17832;
(statearr_17837[(8)] = inst_17820);

return statearr_17837;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17832__$1,(9),inst_17818);
} else {
if((state_val_17833 === (3))){
var inst_17830 = (state_17832[(2)]);
var state_17832__$1 = state_17832;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17832__$1,inst_17830);
} else {
if((state_val_17833 === (2))){
var inst_17818 = (state_17832[(7)]);
var _ = (function (){var statearr_17839 = state_17832;
(statearr_17839[(4)] = cljs.core.cons((5),(state_17832[(4)])));

return statearr_17839;
})();
var inst_17817 = fluree.db.storage.core.ledger_garbage_key(network,ledger_id,block);
var inst_17818__$1 = fluree.db.storage.core.read(conn,inst_17817);
var state_17832__$1 = (function (){var statearr_17840 = state_17832;
(statearr_17840[(7)] = inst_17818__$1);

return statearr_17840;
})();
if(cljs.core.truth_(inst_17818__$1)){
var statearr_17841_17857 = state_17832__$1;
(statearr_17841_17857[(1)] = (6));

} else {
var statearr_17842_17858 = state_17832__$1;
(statearr_17842_17858[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17833 === (9))){
var inst_17820 = (state_17832[(8)]);
var inst_17822 = (state_17832[(2)]);
var inst_17823 = fluree.db.util.async.throw_err(inst_17822);
var inst_17824 = fluree.db.serde.protocol._deserialize_garbage(inst_17820,inst_17823);
var state_17832__$1 = state_17832;
var statearr_17843_17859 = state_17832__$1;
(statearr_17843_17859[(2)] = inst_17824);

(statearr_17843_17859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17833 === (5))){
var _ = (function (){var statearr_17844 = state_17832;
(statearr_17844[(4)] = cljs.core.rest((state_17832[(4)])));

return statearr_17844;
})();
var state_17832__$1 = state_17832;
var ex17838 = (state_17832__$1[(2)]);
var statearr_17845_17860 = state_17832__$1;
(statearr_17845_17860[(5)] = ex17838);


if((ex17838 instanceof Error)){
var statearr_17846_17861 = state_17832__$1;
(statearr_17846_17861[(1)] = (4));

(statearr_17846_17861[(5)] = null);

} else {
throw ex17838;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17833 === (8))){
var inst_17827 = (state_17832[(2)]);
var _ = (function (){var statearr_17847 = state_17832;
(statearr_17847[(4)] = cljs.core.rest((state_17832[(4)])));

return statearr_17847;
})();
var state_17832__$1 = state_17832;
var statearr_17848_17862 = state_17832__$1;
(statearr_17848_17862[(2)] = inst_17827);

(statearr_17848_17862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0 = (function (){
var statearr_17849 = [null,null,null,null,null,null,null,null,null];
(statearr_17849[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__);

(statearr_17849[(1)] = (1));

return statearr_17849;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1 = (function (state_17832){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17832);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17850){var ex__2687__auto__ = e17850;
var statearr_17851_17863 = state_17832;
(statearr_17851_17863[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17832[(4)]))){
var statearr_17852_17864 = state_17832;
(statearr_17852_17864[(1)] = cljs.core.first((state_17832[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17865 = state_17832;
state_17832 = G__17865;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__ = function(state_17832){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1.call(this,state_17832);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17853 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17853[(6)] = c__2706__auto__);

return statearr_17853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,ledger_id,block){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17887){
var state_val_17888 = (state_17887[(1)]);
if((state_val_17888 === (7))){
var inst_17876 = (state_17887[(7)]);
var inst_17878 = fluree.db.storage.core.serde(conn);
var inst_17879 = fluree.db.serde.protocol._deserialize_db_root(inst_17878,inst_17876);
var state_17887__$1 = state_17887;
var statearr_17889_17908 = state_17887__$1;
(statearr_17889_17908[(2)] = inst_17879);

(statearr_17889_17908[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (1))){
var state_17887__$1 = state_17887;
var statearr_17890_17909 = state_17887__$1;
(statearr_17890_17909[(2)] = null);

(statearr_17890_17909[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (4))){
var inst_17866 = (state_17887[(2)]);
var state_17887__$1 = state_17887;
var statearr_17891_17910 = state_17887__$1;
(statearr_17891_17910[(2)] = inst_17866);

(statearr_17891_17910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (6))){
var inst_17876 = (state_17887[(7)]);
var inst_17875 = (state_17887[(2)]);
var inst_17876__$1 = fluree.db.util.async.throw_err(inst_17875);
var state_17887__$1 = (function (){var statearr_17892 = state_17887;
(statearr_17892[(7)] = inst_17876__$1);

return statearr_17892;
})();
if(cljs.core.truth_(inst_17876__$1)){
var statearr_17893_17911 = state_17887__$1;
(statearr_17893_17911[(1)] = (7));

} else {
var statearr_17894_17912 = state_17887__$1;
(statearr_17894_17912[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (3))){
var inst_17885 = (state_17887[(2)]);
var state_17887__$1 = state_17887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17887__$1,inst_17885);
} else {
if((state_val_17888 === (2))){
var _ = (function (){var statearr_17896 = state_17887;
(statearr_17896[(4)] = cljs.core.cons((5),(state_17887[(4)])));

return statearr_17896;
})();
var inst_17872 = fluree.db.storage.core.ledger_root_key(network,ledger_id,block);
var inst_17873 = fluree.db.storage.core.read(conn,inst_17872);
var state_17887__$1 = state_17887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17887__$1,(6),inst_17873);
} else {
if((state_val_17888 === (9))){
var inst_17882 = (state_17887[(2)]);
var _ = (function (){var statearr_17897 = state_17887;
(statearr_17897[(4)] = cljs.core.rest((state_17887[(4)])));

return statearr_17897;
})();
var state_17887__$1 = state_17887;
var statearr_17898_17913 = state_17887__$1;
(statearr_17898_17913[(2)] = inst_17882);

(statearr_17898_17913[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (5))){
var _ = (function (){var statearr_17899 = state_17887;
(statearr_17899[(4)] = cljs.core.rest((state_17887[(4)])));

return statearr_17899;
})();
var state_17887__$1 = state_17887;
var ex17895 = (state_17887__$1[(2)]);
var statearr_17900_17914 = state_17887__$1;
(statearr_17900_17914[(5)] = ex17895);


if((ex17895 instanceof Error)){
var statearr_17901_17915 = state_17887__$1;
(statearr_17901_17915[(1)] = (4));

(statearr_17901_17915[(5)] = null);

} else {
throw ex17895;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17888 === (8))){
var state_17887__$1 = state_17887;
var statearr_17902_17916 = state_17887__$1;
(statearr_17902_17916[(2)] = null);

(statearr_17902_17916[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0 = (function (){
var statearr_17903 = [null,null,null,null,null,null,null,null];
(statearr_17903[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__);

(statearr_17903[(1)] = (1));

return statearr_17903;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1 = (function (state_17887){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17887);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17904){var ex__2687__auto__ = e17904;
var statearr_17905_17917 = state_17887;
(statearr_17905_17917[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17887[(4)]))){
var statearr_17906_17918 = state_17887;
(statearr_17906_17918[(1)] = cljs.core.first((state_17887[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17919 = state_17887;
state_17887 = G__17919;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__ = function(state_17887){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1.call(this,state_17887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2684__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17907 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17907[(6)] = c__2706__auto__);

return statearr_17907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index,
 *   throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,ledger_id,blank_db,index){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17956){
var state_val_17957 = (state_17956[(1)]);
if((state_val_17957 === (7))){
var inst_17926 = (state_17956[(7)]);
var state_17956__$1 = state_17956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17956__$1,(9),inst_17926);
} else {
if((state_val_17957 === (1))){
var state_17956__$1 = state_17956;
var statearr_17958_17979 = state_17956__$1;
(statearr_17958_17979[(2)] = null);

(statearr_17958_17979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17957 === (4))){
var inst_17920 = (state_17956[(2)]);
var state_17956__$1 = state_17956;
var statearr_17959_17980 = state_17956__$1;
(statearr_17959_17980[(2)] = inst_17920);

(statearr_17959_17980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17957 === (6))){
var inst_17929 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_17930 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17931 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_17932 = cljs.core.PersistentHashMap.fromArrays(inst_17930,inst_17931);
var inst_17933 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_17929,inst_17932);
var inst_17934 = (function(){throw inst_17933})();
var state_17956__$1 = state_17956;
var statearr_17960_17981 = state_17956__$1;
(statearr_17960_17981[(2)] = inst_17934);

(statearr_17960_17981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17957 === (3))){
var inst_17954 = (state_17956[(2)]);
var state_17956__$1 = state_17956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17956__$1,inst_17954);
} else {
if((state_val_17957 === (2))){
var inst_17926 = (state_17956[(7)]);
var _ = (function (){var statearr_17961 = state_17956;
(statearr_17961[(4)] = cljs.core.cons((5),(state_17956[(4)])));

return statearr_17961;
})();
var inst_17926__$1 = fluree.db.storage.core.read_db_root(conn,network,ledger_id,index);
var inst_17927 = cljs.core.not(inst_17926__$1);
var state_17956__$1 = (function (){var statearr_17962 = state_17956;
(statearr_17962[(7)] = inst_17926__$1);

return statearr_17962;
})();
if(inst_17927){
var statearr_17963_17982 = state_17956__$1;
(statearr_17963_17982[(1)] = (6));

} else {
var statearr_17964_17983 = state_17956__$1;
(statearr_17964_17983[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17957 === (11))){
var inst_17944 = (state_17956[(8)]);
var inst_17947 = (state_17956[(2)]);
var inst_17948 = fluree.db.util.async.throw_err(inst_17947);
var inst_17949 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17944,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_17948);
var state_17956__$1 = state_17956;
var statearr_17966_17984 = state_17956__$1;
(statearr_17966_17984[(2)] = inst_17949);

(statearr_17966_17984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17957 === (9))){
var inst_17939 = (state_17956[(9)]);
var inst_17937 = (state_17956[(2)]);
var inst_17938 = fluree.db.util.async.throw_err(inst_17937);
var inst_17939__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_17938);
var inst_17940 = fluree.db.query.schema.schema_map(inst_17939__$1);
var state_17956__$1 = (function (){var statearr_17967 = state_17956;
(statearr_17967[(9)] = inst_17939__$1);

return statearr_17967;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17956__$1,(10),inst_17940);
} else {
if((state_val_17957 === (5))){
var _ = (function (){var statearr_17968 = state_17956;
(statearr_17968[(4)] = cljs.core.rest((state_17956[(4)])));

return statearr_17968;
})();
var state_17956__$1 = state_17956;
var ex17965 = (state_17956__$1[(2)]);
var statearr_17969_17985 = state_17956__$1;
(statearr_17969_17985[(5)] = ex17965);


if((ex17965 instanceof Error)){
var statearr_17970_17986 = state_17956__$1;
(statearr_17970_17986[(1)] = (4));

(statearr_17970_17986[(5)] = null);

} else {
throw ex17965;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17957 === (10))){
var inst_17944 = (state_17956[(8)]);
var inst_17939 = (state_17956[(9)]);
var inst_17942 = (state_17956[(2)]);
var inst_17943 = fluree.db.util.async.throw_err(inst_17942);
var inst_17944__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_17939,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_17943);
var inst_17945 = fluree.db.query.schema.setting_map(inst_17944__$1);
var state_17956__$1 = (function (){var statearr_17971 = state_17956;
(statearr_17971[(8)] = inst_17944__$1);

return statearr_17971;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17956__$1,(11),inst_17945);
} else {
if((state_val_17957 === (8))){
var inst_17951 = (state_17956[(2)]);
var _ = (function (){var statearr_17972 = state_17956;
(statearr_17972[(4)] = cljs.core.rest((state_17956[(4)])));

return statearr_17972;
})();
var state_17956__$1 = state_17956;
var statearr_17973_17987 = state_17956__$1;
(statearr_17973_17987[(2)] = inst_17951);

(statearr_17973_17987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0 = (function (){
var statearr_17974 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17974[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2684__auto__);

(statearr_17974[(1)] = (1));

return statearr_17974;
});
var fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1 = (function (state_17956){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17956);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17975){var ex__2687__auto__ = e17975;
var statearr_17976_17988 = state_17956;
(statearr_17976_17988[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17956[(4)]))){
var statearr_17977_17989 = state_17956;
(statearr_17977_17989[(1)] = cljs.core.first((state_17956[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17990 = state_17956;
state_17956 = G__17990;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__ = function(state_17956){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1.call(this,state_17956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2684__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17978 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17978[(6)] = c__2706__auto__);

return statearr_17978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.fetch_child_attributes = (function fluree$db$storage$core$fetch_child_attributes(conn,p__17991){
var map__17992 = p__17991;
var map__17992__$1 = cljs.core.__destructure_map(map__17992);
var branch = map__17992__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17992__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17992__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17992__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18029){
var state_val_18030 = (state_18029[(1)]);
if((state_val_18030 === (7))){
var inst_18002 = (state_18029[(7)]);
var inst_18005 = cljs.core.__destructure_map(inst_18002);
var inst_18006 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18005,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_18007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18008 = [new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"tempid","tempid",1427663222)];
var inst_18009 = (new cljs.core.PersistentVector(null,7,(5),inst_18007,inst_18008,null));
var inst_18010 = cljs.core.select_keys(branch,inst_18009);
var inst_18011 = (function (){var temp__5802__auto__ = inst_18002;
var map__18004 = inst_18005;
var children = inst_18006;
var branch_metadata = inst_18010;
return (function (i,child){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(branch_metadata,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),(function (){var and__5043__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (i === (0));
} else {
return and__5043__auto__;
}
})()),child], 0));
});
})();
var inst_18012 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_18011,inst_18006);
var inst_18013 = cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"first","first",-644103046),cljs.core.identity);
var inst_18014 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(inst_18013,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_18012], 0));
var inst_18015 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,comparator,inst_18014);
var state_18029__$1 = state_18029;
var statearr_18031_18050 = state_18029__$1;
(statearr_18031_18050[(2)] = inst_18015);

(statearr_18031_18050[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18030 === (1))){
var state_18029__$1 = state_18029;
var statearr_18032_18051 = state_18029__$1;
(statearr_18032_18051[(2)] = null);

(statearr_18032_18051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18030 === (4))){
var inst_17993 = (state_18029[(2)]);
var state_18029__$1 = state_18029;
var statearr_18033_18052 = state_18029__$1;
(statearr_18033_18052[(2)] = inst_17993);

(statearr_18033_18052[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18030 === (6))){
var inst_18002 = (state_18029[(7)]);
var inst_18001 = (state_18029[(2)]);
var inst_18002__$1 = fluree.db.util.async.throw_err(inst_18001);
var state_18029__$1 = (function (){var statearr_18034 = state_18029;
(statearr_18034[(7)] = inst_18002__$1);

return statearr_18034;
})();
if(cljs.core.truth_(inst_18002__$1)){
var statearr_18035_18053 = state_18029__$1;
(statearr_18035_18053[(1)] = (7));

} else {
var statearr_18036_18054 = state_18029__$1;
(statearr_18036_18054[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18030 === (3))){
var inst_18027 = (state_18029[(2)]);
var state_18029__$1 = state_18029;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18029__$1,inst_18027);
} else {
if((state_val_18030 === (2))){
var _ = (function (){var statearr_18038 = state_18029;
(statearr_18038[(4)] = cljs.core.cons((5),(state_18029[(4)])));

return statearr_18038;
})();
var inst_17999 = fluree.db.storage.core.read_branch(conn,id);
var state_18029__$1 = state_18029;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18029__$1,(6),inst_17999);
} else {
if((state_val_18030 === (9))){
var inst_18024 = (state_18029[(2)]);
var _ = (function (){var statearr_18039 = state_18029;
(statearr_18039[(4)] = cljs.core.rest((state_18029[(4)])));

return statearr_18039;
})();
var state_18029__$1 = state_18029;
var statearr_18040_18055 = state_18029__$1;
(statearr_18040_18055[(2)] = inst_18024);

(statearr_18040_18055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18030 === (5))){
var _ = (function (){var statearr_18041 = state_18029;
(statearr_18041[(4)] = cljs.core.rest((state_18029[(4)])));

return statearr_18041;
})();
var state_18029__$1 = state_18029;
var ex18037 = (state_18029__$1[(2)]);
var statearr_18042_18056 = state_18029__$1;
(statearr_18042_18056[(5)] = ex18037);


if((ex18037 instanceof Error)){
var statearr_18043_18057 = state_18029__$1;
(statearr_18043_18057[(1)] = (4));

(statearr_18043_18057[(5)] = null);

} else {
throw ex18037;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18030 === (8))){
var inst_18017 = ["Unable to retrieve index branch with id ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage."].join('');
var inst_18018 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18019 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18020 = cljs.core.PersistentHashMap.fromArrays(inst_18018,inst_18019);
var inst_18021 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18017,inst_18020);
var inst_18022 = (function(){throw inst_18021})();
var state_18029__$1 = state_18029;
var statearr_18044_18058 = state_18029__$1;
(statearr_18044_18058[(2)] = inst_18022);

(statearr_18044_18058[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0 = (function (){
var statearr_18045 = [null,null,null,null,null,null,null,null];
(statearr_18045[(0)] = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__);

(statearr_18045[(1)] = (1));

return statearr_18045;
});
var fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1 = (function (state_18029){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18029);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18046){var ex__2687__auto__ = e18046;
var statearr_18047_18059 = state_18029;
(statearr_18047_18059[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18029[(4)]))){
var statearr_18048_18060 = state_18029;
(statearr_18048_18060[(1)] = cljs.core.first((state_18029[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18061 = state_18029;
state_18029 = G__18061;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__ = function(state_18029){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1.call(this,state_18029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____0;
fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto____1;
return fluree$db$storage$core$fetch_child_attributes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18049 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18049[(6)] = c__2706__auto__);

return statearr_18049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.fetch_leaf_flakes = (function fluree$db$storage$core$fetch_leaf_flakes(conn,p__18062){
var map__18063 = p__18062;
var map__18063__$1 = cljs.core.__destructure_map(map__18063);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18063__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18063__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18092){
var state_val_18093 = (state_18092[(1)]);
if((state_val_18093 === (7))){
var inst_18073 = (state_18092[(7)]);
var inst_18076 = cljs.core.__destructure_map(inst_18073);
var inst_18077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18076,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_18078 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,comparator,inst_18077);
var state_18092__$1 = state_18092;
var statearr_18094_18113 = state_18092__$1;
(statearr_18094_18113[(2)] = inst_18078);

(statearr_18094_18113[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18093 === (1))){
var state_18092__$1 = state_18092;
var statearr_18095_18114 = state_18092__$1;
(statearr_18095_18114[(2)] = null);

(statearr_18095_18114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18093 === (4))){
var inst_18064 = (state_18092[(2)]);
var state_18092__$1 = state_18092;
var statearr_18096_18115 = state_18092__$1;
(statearr_18096_18115[(2)] = inst_18064);

(statearr_18096_18115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18093 === (6))){
var inst_18073 = (state_18092[(7)]);
var inst_18072 = (state_18092[(2)]);
var inst_18073__$1 = fluree.db.util.async.throw_err(inst_18072);
var state_18092__$1 = (function (){var statearr_18097 = state_18092;
(statearr_18097[(7)] = inst_18073__$1);

return statearr_18097;
})();
if(cljs.core.truth_(inst_18073__$1)){
var statearr_18098_18116 = state_18092__$1;
(statearr_18098_18116[(1)] = (7));

} else {
var statearr_18099_18117 = state_18092__$1;
(statearr_18099_18117[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18093 === (3))){
var inst_18090 = (state_18092[(2)]);
var state_18092__$1 = state_18092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18092__$1,inst_18090);
} else {
if((state_val_18093 === (2))){
var _ = (function (){var statearr_18101 = state_18092;
(statearr_18101[(4)] = cljs.core.cons((5),(state_18092[(4)])));

return statearr_18101;
})();
var inst_18070 = fluree.db.storage.core.read_leaf(conn,id);
var state_18092__$1 = state_18092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18092__$1,(6),inst_18070);
} else {
if((state_val_18093 === (9))){
var inst_18087 = (state_18092[(2)]);
var _ = (function (){var statearr_18102 = state_18092;
(statearr_18102[(4)] = cljs.core.rest((state_18092[(4)])));

return statearr_18102;
})();
var state_18092__$1 = state_18092;
var statearr_18103_18118 = state_18092__$1;
(statearr_18103_18118[(2)] = inst_18087);

(statearr_18103_18118[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18093 === (5))){
var _ = (function (){var statearr_18104 = state_18092;
(statearr_18104[(4)] = cljs.core.rest((state_18092[(4)])));

return statearr_18104;
})();
var state_18092__$1 = state_18092;
var ex18100 = (state_18092__$1[(2)]);
var statearr_18105_18119 = state_18092__$1;
(statearr_18105_18119[(5)] = ex18100);


if((ex18100 instanceof Error)){
var statearr_18106_18120 = state_18092__$1;
(statearr_18106_18120[(1)] = (4));

(statearr_18106_18120[(5)] = null);

} else {
throw ex18100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18093 === (8))){
var inst_18080 = ["Unable to retrieve leaf node with id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id)," from storage"].join('');
var inst_18081 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18082 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_18083 = cljs.core.PersistentHashMap.fromArrays(inst_18081,inst_18082);
var inst_18084 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_18080,inst_18083);
var inst_18085 = (function(){throw inst_18084})();
var state_18092__$1 = state_18092;
var statearr_18107_18121 = state_18092__$1;
(statearr_18107_18121[(2)] = inst_18085);

(statearr_18107_18121[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__ = null;
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0 = (function (){
var statearr_18108 = [null,null,null,null,null,null,null,null];
(statearr_18108[(0)] = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__);

(statearr_18108[(1)] = (1));

return statearr_18108;
});
var fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1 = (function (state_18092){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18092);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18109){var ex__2687__auto__ = e18109;
var statearr_18110_18122 = state_18092;
(statearr_18110_18122[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18092[(4)]))){
var statearr_18111_18123 = state_18092;
(statearr_18111_18123[(1)] = cljs.core.first((state_18092[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18124 = state_18092;
state_18092 = G__18124;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__ = function(state_18092){
switch(arguments.length){
case 0:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1.call(this,state_18092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____0;
fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto____1;
return fluree$db$storage$core$fetch_leaf_flakes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18112 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18112[(6)] = c__2706__auto__);

return statearr_18112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.storage.core.resolve_index_node = (function fluree$db$storage$core$resolve_index_node(var_args){
var G__18126 = arguments.length;
switch (G__18126) {
case 2:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2 = (function (conn,node){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$2(node,null);
}));

(fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3 = (function (conn,p__18127,error_fn){
var map__18128 = p__18127;
var map__18128__$1 = cljs.core.__destructure_map(map__18128);
var node = map__18128__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18128__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18128__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
if(cljs.core.truth_(comparator)){
} else {
throw (new Error(["Assert failed: ","Cannot resolve index node; configuration does not have a comparator.","\n","comparator"].join('')));
}

var return_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___18200 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_18172){
var state_val_18173 = (state_18172[(1)]);
if((state_val_18173 === (7))){
var inst_18137 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
var statearr_18174_18201 = state_18172__$1;
(statearr_18174_18201[(2)] = inst_18137);

(statearr_18174_18201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (1))){
var state_18172__$1 = state_18172;
var statearr_18175_18202 = state_18172__$1;
(statearr_18175_18202[(2)] = null);

(statearr_18175_18202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (4))){
var inst_18129 = (state_18172[(7)]);
var inst_18129__$1 = (state_18172[(2)]);
var inst_18130 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(inst_18129__$1,"Error resolving index node") : fluree.db.util.log.error.call(null,inst_18129__$1,"Error resolving index node"));
var state_18172__$1 = (function (){var statearr_18176 = state_18172;
(statearr_18176[(8)] = inst_18130);

(statearr_18176[(7)] = inst_18129__$1);

return statearr_18176;
})();
if(cljs.core.truth_(error_fn)){
var statearr_18177_18203 = state_18172__$1;
(statearr_18177_18203[(1)] = (5));

} else {
var statearr_18178_18204 = state_18172__$1;
(statearr_18178_18204[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (13))){
var inst_18155 = (state_18172[(9)]);
var inst_18158 = (state_18172[(2)]);
var inst_18159 = fluree.db.util.async.throw_err(inst_18158);
var inst_18160 = [new cljs.core.Keyword(null,"children","children",-940561982),inst_18159];
var inst_18161 = (new cljs.core.PersistentVector(null,2,(5),inst_18155,inst_18160,null));
var state_18172__$1 = state_18172;
var statearr_18179_18205 = state_18172__$1;
(statearr_18179_18205[(2)] = inst_18161);

(statearr_18179_18205[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (6))){
var state_18172__$1 = state_18172;
var statearr_18180_18206 = state_18172__$1;
(statearr_18180_18206[(2)] = null);

(statearr_18180_18206[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (3))){
var inst_18170 = (state_18172[(2)]);
var state_18172__$1 = state_18172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18172__$1,inst_18170);
} else {
if((state_val_18173 === (12))){
var inst_18147 = (state_18172[(10)]);
var inst_18150 = (state_18172[(2)]);
var inst_18151 = fluree.db.util.async.throw_err(inst_18150);
var inst_18152 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_18151];
var inst_18153 = (new cljs.core.PersistentVector(null,2,(5),inst_18147,inst_18152,null));
var state_18172__$1 = state_18172;
var statearr_18181_18207 = state_18172__$1;
(statearr_18181_18207[(2)] = inst_18153);

(statearr_18181_18207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (2))){
var _ = (function (){var statearr_18182 = state_18172;
(statearr_18182[(4)] = cljs.core.cons((8),(state_18172[(4)])));

return statearr_18182;
})();
var state_18172__$1 = state_18172;
if(cljs.core.truth_(leaf)){
var statearr_18183_18208 = state_18172__$1;
(statearr_18183_18208[(1)] = (9));

} else {
var statearr_18184_18209 = state_18172__$1;
(statearr_18184_18209[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (11))){
var inst_18163 = (state_18172[(2)]);
var inst_18164 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18163,(0),null);
var inst_18165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_18163,(1),null);
var inst_18166 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,inst_18164,inst_18165);
var inst_18167 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18166);
var _ = (function (){var statearr_18185 = state_18172;
(statearr_18185[(4)] = cljs.core.rest((state_18172[(4)])));

return statearr_18185;
})();
var state_18172__$1 = state_18172;
var statearr_18186_18210 = state_18172__$1;
(statearr_18186_18210[(2)] = inst_18167);

(statearr_18186_18210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (9))){
var inst_18147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18148 = fluree.db.storage.core.fetch_leaf_flakes(conn,node);
var state_18172__$1 = (function (){var statearr_18187 = state_18172;
(statearr_18187[(10)] = inst_18147);

return statearr_18187;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18172__$1,(12),inst_18148);
} else {
if((state_val_18173 === (5))){
var inst_18129 = (state_18172[(7)]);
var inst_18132 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_18129);
var inst_18133 = cljs.core.async.close_BANG_(return_ch);
var inst_18134 = (error_fn.cljs$core$IFn$_invoke$arity$2 ? error_fn.cljs$core$IFn$_invoke$arity$2(inst_18132,inst_18133) : error_fn.call(null,inst_18132,inst_18133));
var state_18172__$1 = state_18172;
var statearr_18189_18211 = state_18172__$1;
(statearr_18189_18211[(2)] = inst_18134);

(statearr_18189_18211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18173 === (10))){
var inst_18155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18156 = fluree.db.storage.core.fetch_child_attributes(conn,node);
var state_18172__$1 = (function (){var statearr_18190 = state_18172;
(statearr_18190[(9)] = inst_18155);

return statearr_18190;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_18172__$1,(13),inst_18156);
} else {
if((state_val_18173 === (8))){
var _ = (function (){var statearr_18191 = state_18172;
(statearr_18191[(4)] = cljs.core.rest((state_18172[(4)])));

return statearr_18191;
})();
var state_18172__$1 = state_18172;
var ex18188 = (state_18172__$1[(2)]);
var statearr_18192_18212 = state_18172__$1;
(statearr_18192_18212[(5)] = ex18188);


var statearr_18193_18213 = state_18172__$1;
(statearr_18193_18213[(1)] = (4));

(statearr_18193_18213[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2684__auto__ = null;
var fluree$db$storage$core$state_machine__2684__auto____0 = (function (){
var statearr_18194 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18194[(0)] = fluree$db$storage$core$state_machine__2684__auto__);

(statearr_18194[(1)] = (1));

return statearr_18194;
});
var fluree$db$storage$core$state_machine__2684__auto____1 = (function (state_18172){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_18172);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e18195){var ex__2687__auto__ = e18195;
var statearr_18196_18214 = state_18172;
(statearr_18196_18214[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_18172[(4)]))){
var statearr_18197_18215 = state_18172;
(statearr_18197_18215[(1)] = cljs.core.first((state_18172[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18216 = state_18172;
state_18172 = G__18216;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2684__auto__ = function(state_18172){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2684__auto____1.call(this,state_18172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2684__auto____0;
fluree$db$storage$core$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2684__auto____1;
return fluree$db$storage$core$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_18198 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_18198[(6)] = c__2706__auto___18200);

return statearr_18198;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_ch;
}));

(fluree.db.storage.core.resolve_index_node.cljs$lang$maxFixedArity = 3);

fluree.db.storage.core.resolve_empty_leaf = (function fluree$db$storage$core$resolve_empty_leaf(p__18217){
var map__18218 = p__18217;
var map__18218__$1 = cljs.core.__destructure_map(map__18218);
var node = map__18218__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18218__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var empty_set = fluree.db.flake.sorted_set_by(comparator);
var empty_node = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set);
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,empty_node);

return ch;
});
