// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16009){
var state_val_16010 = (state_16009[(1)]);
if((state_val_16010 === (1))){
var state_16009__$1 = state_16009;
var statearr_16011_16025 = state_16009__$1;
(statearr_16011_16025[(2)] = null);

(statearr_16011_16025[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16010 === (2))){
var _ = (function (){var statearr_16012 = state_16009;
(statearr_16012[(4)] = cljs.core.cons((5),(state_16009[(4)])));

return statearr_16012;
})();
var inst_16000 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_16009__$1 = state_16009;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16009__$1,(6),inst_16000);
} else {
if((state_val_16010 === (3))){
var inst_16007 = (state_16009[(2)]);
var state_16009__$1 = state_16009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16009__$1,inst_16007);
} else {
if((state_val_16010 === (4))){
var inst_15994 = (state_16009[(2)]);
var state_16009__$1 = state_16009;
var statearr_16014_16026 = state_16009__$1;
(statearr_16014_16026[(2)] = inst_15994);

(statearr_16014_16026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16010 === (5))){
var _ = (function (){var statearr_16015 = state_16009;
(statearr_16015[(4)] = cljs.core.rest((state_16009[(4)])));

return statearr_16015;
})();
var state_16009__$1 = state_16009;
var ex16013 = (state_16009__$1[(2)]);
var statearr_16016_16027 = state_16009__$1;
(statearr_16016_16027[(5)] = ex16013);


if((ex16013 instanceof Error)){
var statearr_16017_16028 = state_16009__$1;
(statearr_16017_16028[(1)] = (4));

(statearr_16017_16028[(5)] = null);

} else {
throw ex16013;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16010 === (6))){
var inst_16002 = (state_16009[(2)]);
var inst_16003 = fluree.db.util.async.throw_err(inst_16002);
var inst_16004 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_16003);
var _ = (function (){var statearr_16018 = state_16009;
(statearr_16018[(4)] = cljs.core.rest((state_16009[(4)])));

return statearr_16018;
})();
var state_16009__$1 = state_16009;
var statearr_16019_16029 = state_16009__$1;
(statearr_16019_16029[(2)] = inst_16004);

(statearr_16019_16029[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0 = (function (){
var statearr_16020 = [null,null,null,null,null,null,null];
(statearr_16020[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__);

(statearr_16020[(1)] = (1));

return statearr_16020;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1 = (function (state_16009){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16009);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16021){var ex__2687__auto__ = e16021;
var statearr_16022_16030 = state_16009;
(statearr_16022_16030[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16009[(4)]))){
var statearr_16023_16031 = state_16009;
(statearr_16023_16031[(1)] = cljs.core.first((state_16009[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16032 = state_16009;
state_16009 = G__16032;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__ = function(state_16009){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1.call(this,state_16009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16024 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16024[(6)] = c__2706__auto__);

return statearr_16024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16064){
var state_val_16065 = (state_16064[(1)]);
if((state_val_16065 === (7))){
var inst_16048 = (state_16064[(7)]);
var inst_16050 = cljs.core.empty_QMARK_(inst_16048);
var inst_16051 = (!(inst_16050));
var state_16064__$1 = state_16064;
var statearr_16066_16090 = state_16064__$1;
(statearr_16066_16090[(2)] = inst_16051);

(statearr_16066_16090[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (1))){
var state_16064__$1 = state_16064;
var statearr_16067_16091 = state_16064__$1;
(statearr_16067_16091[(2)] = null);

(statearr_16067_16091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (4))){
var inst_16034 = (state_16064[(2)]);
var state_16064__$1 = state_16064;
var statearr_16068_16092 = state_16064__$1;
(statearr_16068_16092[(2)] = inst_16034);

(statearr_16068_16092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (6))){
var inst_16048 = (state_16064[(7)]);
var inst_16040 = (state_16064[(8)]);
var inst_16046 = (state_16064[(2)]);
var inst_16047 = fluree.db.util.async.throw_err(inst_16046);
var inst_16048__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_16040,inst_16047);
var state_16064__$1 = (function (){var statearr_16069 = state_16064;
(statearr_16069[(7)] = inst_16048__$1);

return statearr_16069;
})();
if(cljs.core.truth_(inst_16048__$1)){
var statearr_16070_16093 = state_16064__$1;
(statearr_16070_16093[(1)] = (7));

} else {
var statearr_16071_16094 = state_16064__$1;
(statearr_16071_16094[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (3))){
var inst_16062 = (state_16064[(2)]);
var state_16064__$1 = state_16064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16064__$1,inst_16062);
} else {
if((state_val_16065 === (12))){
var inst_16059 = (state_16064[(2)]);
var _ = (function (){var statearr_16072 = state_16064;
(statearr_16072[(4)] = cljs.core.rest((state_16064[(4)])));

return statearr_16072;
})();
var state_16064__$1 = state_16064;
var statearr_16073_16095 = state_16064__$1;
(statearr_16073_16095[(2)] = inst_16059);

(statearr_16073_16095[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (2))){
var _ = (function (){var statearr_16074 = state_16064;
(statearr_16074[(4)] = cljs.core.cons((5),(state_16064[(4)])));

return statearr_16074;
})();
var inst_16040 = (function (){return (function (p1__16033_SHARP_){
return fluree.db.flake.o(p1__16033_SHARP_);
});
})();
var inst_16041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16042 = [pred_id];
var inst_16043 = (new cljs.core.PersistentVector(null,1,(5),inst_16041,inst_16042,null));
var inst_16044 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16043);
var state_16064__$1 = (function (){var statearr_16075 = state_16064;
(statearr_16075[(8)] = inst_16040);

return statearr_16075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16064__$1,(6),inst_16044);
} else {
if((state_val_16065 === (11))){
var state_16064__$1 = state_16064;
var statearr_16077_16096 = state_16064__$1;
(statearr_16077_16096[(2)] = true);

(statearr_16077_16096[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (9))){
var inst_16054 = (state_16064[(2)]);
var state_16064__$1 = state_16064;
if(cljs.core.truth_(inst_16054)){
var statearr_16078_16097 = state_16064__$1;
(statearr_16078_16097[(1)] = (10));

} else {
var statearr_16079_16098 = state_16064__$1;
(statearr_16079_16098[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (5))){
var _ = (function (){var statearr_16080 = state_16064;
(statearr_16080[(4)] = cljs.core.rest((state_16064[(4)])));

return statearr_16080;
})();
var state_16064__$1 = state_16064;
var ex16076 = (state_16064__$1[(2)]);
var statearr_16081_16099 = state_16064__$1;
(statearr_16081_16099[(5)] = ex16076);


if((ex16076 instanceof Error)){
var statearr_16082_16100 = state_16064__$1;
(statearr_16082_16100[(1)] = (4));

(statearr_16082_16100[(5)] = null);

} else {
throw ex16076;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (10))){
var inst_16048 = (state_16064[(7)]);
var inst_16056 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_16048);
var state_16064__$1 = state_16064;
var statearr_16083_16101 = state_16064__$1;
(statearr_16083_16101[(2)] = inst_16056);

(statearr_16083_16101[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16065 === (8))){
var inst_16048 = (state_16064[(7)]);
var state_16064__$1 = state_16064;
var statearr_16084_16102 = state_16064__$1;
(statearr_16084_16102[(2)] = inst_16048);

(statearr_16084_16102[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_16085 = [null,null,null,null,null,null,null,null,null];
(statearr_16085[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__);

(statearr_16085[(1)] = (1));

return statearr_16085;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1 = (function (state_16064){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16064);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16086){var ex__2687__auto__ = e16086;
var statearr_16087_16103 = state_16064;
(statearr_16087_16103[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16064[(4)]))){
var statearr_16088_16104 = state_16064;
(statearr_16088_16104[(1)] = cljs.core.first((state_16064[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16105 = state_16064;
state_16064 = G__16105;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__ = function(state_16064){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1.call(this,state_16064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16089 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16089[(6)] = c__2706__auto__);

return statearr_16089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16186){
var state_val_16187 = (state_16186[(1)]);
if((state_val_16187 === (7))){
var state_16186__$1 = state_16186;
var statearr_16188_16226 = state_16186__$1;
(statearr_16188_16226[(2)] = flakes);

(statearr_16188_16226[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (20))){
var inst_16143 = (state_16186[(7)]);
var inst_16176 = (state_16186[(2)]);
var inst_16135 = inst_16143;
var inst_16136 = inst_16176;
var state_16186__$1 = (function (){var statearr_16189 = state_16186;
(statearr_16189[(8)] = inst_16136);

(statearr_16189[(9)] = inst_16135);

return statearr_16189;
})();
var statearr_16190_16227 = state_16186__$1;
(statearr_16190_16227[(2)] = null);

(statearr_16190_16227[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (1))){
var state_16186__$1 = state_16186;
var statearr_16191_16228 = state_16186__$1;
(statearr_16191_16228[(2)] = null);

(statearr_16191_16228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (4))){
var inst_16108 = (state_16186[(2)]);
var state_16186__$1 = state_16186;
var statearr_16192_16229 = state_16186__$1;
(statearr_16192_16229[(2)] = inst_16108);

(statearr_16192_16229[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (15))){
var inst_16142 = (state_16186[(10)]);
var inst_16160 = fluree.db.flake.o(inst_16142);
var state_16186__$1 = state_16186;
var statearr_16193_16230 = state_16186__$1;
(statearr_16193_16230[(2)] = inst_16160);

(statearr_16193_16230[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (13))){
var inst_16179 = (state_16186[(2)]);
var state_16186__$1 = state_16186;
var statearr_16194_16231 = state_16186__$1;
(statearr_16194_16231[(2)] = inst_16179);

(statearr_16194_16231[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (6))){
var inst_16115 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16186__$1 = state_16186;
var statearr_16195_16232 = state_16186__$1;
(statearr_16195_16232[(2)] = inst_16115);

(statearr_16195_16232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (17))){
var inst_16157 = (state_16186[(2)]);
var inst_16158 = fluree.db.util.async.throw_err(inst_16157);
var state_16186__$1 = state_16186;
var statearr_16196_16233 = state_16186__$1;
(statearr_16196_16233[(2)] = inst_16158);

(statearr_16196_16233[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (3))){
var inst_16184 = (state_16186[(2)]);
var state_16186__$1 = state_16186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16186__$1,inst_16184);
} else {
if((state_val_16187 === (12))){
var inst_16149 = (state_16186[(11)]);
var inst_16142 = (state_16186[(10)]);
var inst_16147 = fluree.db.flake.p(inst_16142);
var inst_16148 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16147);
var inst_16149__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_16148);
var inst_16150 = fluree.db.flake.op(inst_16142);
var inst_16151 = inst_16150 === false;
var inst_16152 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"type","type",1174270348),inst_16149__$1);
var state_16186__$1 = (function (){var statearr_16197 = state_16186;
(statearr_16197[(12)] = inst_16151);

(statearr_16197[(11)] = inst_16149__$1);

return statearr_16197;
})();
if(inst_16152){
var statearr_16198_16234 = state_16186__$1;
(statearr_16198_16234[(1)] = (14));

} else {
var statearr_16199_16235 = state_16186__$1;
(statearr_16199_16235[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (2))){
var _ = (function (){var statearr_16200 = state_16186;
(statearr_16200[(4)] = cljs.core.cons((5),(state_16186[(4)])));

return statearr_16200;
})();
var state_16186__$1 = state_16186;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16201_16236 = state_16186__$1;
(statearr_16201_16236[(1)] = (6));

} else {
var statearr_16202_16237 = state_16186__$1;
(statearr_16202_16237[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (19))){
var inst_16162 = (state_16186[(13)]);
var inst_16149 = (state_16186[(11)]);
var inst_16142 = (state_16186[(10)]);
var inst_16136 = (state_16186[(8)]);
var inst_16170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16171 = fluree.db.flake.s(inst_16142);
var inst_16172 = [inst_16171,inst_16149,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16173 = (new cljs.core.PersistentVector(null,3,(5),inst_16170,inst_16172,null));
var inst_16174 = cljs.core.assoc_in(inst_16136,inst_16173,inst_16162);
var state_16186__$1 = state_16186;
var statearr_16203_16238 = state_16186__$1;
(statearr_16203_16238[(2)] = inst_16174);

(statearr_16203_16238[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (11))){
var inst_16136 = (state_16186[(8)]);
var state_16186__$1 = state_16186;
var statearr_16205_16239 = state_16186__$1;
(statearr_16205_16239[(2)] = inst_16136);

(statearr_16205_16239[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (9))){
var inst_16142 = (state_16186[(10)]);
var inst_16135 = (state_16186[(9)]);
var inst_16141 = cljs.core.seq(inst_16135);
var inst_16142__$1 = cljs.core.first(inst_16141);
var inst_16143 = cljs.core.next(inst_16141);
var inst_16144 = cljs.core.not(inst_16142__$1);
var state_16186__$1 = (function (){var statearr_16206 = state_16186;
(statearr_16206[(7)] = inst_16143);

(statearr_16206[(10)] = inst_16142__$1);

return statearr_16206;
})();
if(inst_16144){
var statearr_16207_16240 = state_16186__$1;
(statearr_16207_16240[(1)] = (11));

} else {
var statearr_16208_16241 = state_16186__$1;
(statearr_16208_16241[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (5))){
var _ = (function (){var statearr_16209 = state_16186;
(statearr_16209[(4)] = cljs.core.rest((state_16186[(4)])));

return statearr_16209;
})();
var state_16186__$1 = state_16186;
var ex16204 = (state_16186__$1[(2)]);
var statearr_16210_16242 = state_16186__$1;
(statearr_16210_16242[(5)] = ex16204);


if((ex16204 instanceof Error)){
var statearr_16211_16243 = state_16186__$1;
(statearr_16211_16243[(1)] = (4));

(statearr_16211_16243[(5)] = null);

} else {
throw ex16204;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (14))){
var inst_16142 = (state_16186[(10)]);
var inst_16154 = fluree.db.flake.o(inst_16142);
var inst_16155 = fluree.db.query.schema.convert_type_to_kw(inst_16154,db);
var state_16186__$1 = state_16186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16186__$1,(17),inst_16155);
} else {
if((state_val_16187 === (16))){
var inst_16151 = (state_16186[(12)]);
var inst_16162 = (state_16186[(2)]);
var state_16186__$1 = (function (){var statearr_16212 = state_16186;
(statearr_16212[(13)] = inst_16162);

return statearr_16212;
})();
if(cljs.core.truth_(inst_16151)){
var statearr_16213_16244 = state_16186__$1;
(statearr_16213_16244[(1)] = (18));

} else {
var statearr_16214_16245 = state_16186__$1;
(statearr_16214_16245[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (10))){
var inst_16181 = (state_16186[(2)]);
var _ = (function (){var statearr_16215 = state_16186;
(statearr_16215[(4)] = cljs.core.rest((state_16186[(4)])));

return statearr_16215;
})();
var state_16186__$1 = state_16186;
var statearr_16216_16246 = state_16186__$1;
(statearr_16216_16246[(2)] = inst_16181);

(statearr_16216_16246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (18))){
var inst_16162 = (state_16186[(13)]);
var inst_16149 = (state_16186[(11)]);
var inst_16142 = (state_16186[(10)]);
var inst_16136 = (state_16186[(8)]);
var inst_16164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16165 = fluree.db.flake.s(inst_16142);
var inst_16166 = [inst_16165,inst_16149,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16167 = (new cljs.core.PersistentVector(null,3,(5),inst_16164,inst_16166,null));
var inst_16168 = cljs.core.assoc_in(inst_16136,inst_16167,inst_16162);
var state_16186__$1 = state_16186;
var statearr_16217_16247 = state_16186__$1;
(statearr_16217_16247[(2)] = inst_16168);

(statearr_16217_16247[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16187 === (8))){
var inst_16118 = (state_16186[(2)]);
var inst_16119 = cljs.core.PersistentHashSet.EMPTY;
var inst_16120 = cljs.core.vals(tempids);
var inst_16121 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_16119,inst_16120);
var inst_16122 = (function (){var pred_flakes = inst_16118;
var is_new_QMARK_ = inst_16121;
return (function (p1__16107_SHARP_,p2__16106_SHARP_){
var f = p2__16106_SHARP_;
return cljs.core.assoc_in(p1__16107_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s(f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$((function (){var G__16218 = fluree.db.flake.s(f);
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__16218) : is_new_QMARK_.call(null,G__16218));
})()));
});
})();
var inst_16123 = cljs.core.PersistentHashMap.EMPTY;
var inst_16124 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_16122,inst_16123,inst_16118);
var inst_16132 = cljs.core.seq(inst_16118);
var inst_16133 = cljs.core.first(inst_16132);
var inst_16134 = cljs.core.next(inst_16132);
var inst_16135 = inst_16118;
var inst_16136 = inst_16124;
var state_16186__$1 = (function (){var statearr_16219 = state_16186;
(statearr_16219[(14)] = inst_16134);

(statearr_16219[(8)] = inst_16136);

(statearr_16219[(15)] = inst_16133);

(statearr_16219[(9)] = inst_16135);

return statearr_16219;
})();
var statearr_16220_16248 = state_16186__$1;
(statearr_16220_16248[(2)] = null);

(statearr_16220_16248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0 = (function (){
var statearr_16221 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16221[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__);

(statearr_16221[(1)] = (1));

return statearr_16221;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1 = (function (state_16186){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16186);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16222){var ex__2687__auto__ = e16222;
var statearr_16223_16249 = state_16186;
(statearr_16223_16249[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16186[(4)]))){
var statearr_16224_16250 = state_16186;
(statearr_16224_16250[(1)] = cljs.core.first((state_16186[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16251 = state_16186;
state_16186 = G__16251;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__ = function(state_16186){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1.call(this,state_16186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16225 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16225[(6)] = c__2706__auto__);

return statearr_16225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16253 = arguments.length;
switch (G__16253) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16256 = arguments.length;
switch (G__16256) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16568){
var state_val_16569 = (state_16568[(1)]);
if((state_val_16569 === (121))){
var inst_16523 = (state_16568[(7)]);
var state_16568__$1 = state_16568;
var statearr_16570_16763 = state_16568__$1;
(statearr_16570_16763[(2)] = inst_16523);

(statearr_16570_16763[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (65))){
var inst_16422 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16422)){
var statearr_16571_16764 = state_16568__$1;
(statearr_16571_16764[(1)] = (66));

} else {
var statearr_16572_16765 = state_16568__$1;
(statearr_16572_16765[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (70))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16432 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16433 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16432,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,3,inst_16432,null));
var inst_16434 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16433,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16433,null));
var inst_16435 = (inst_16434.cljs$core$IFn$_invoke$arity$1 ? inst_16434.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16434.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16435)){
var statearr_16573_16766 = state_16568__$1;
(statearr_16573_16766[(1)] = (72));

} else {
var statearr_16574_16767 = state_16568__$1;
(statearr_16574_16767[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (62))){
var inst_16412 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16575_16768 = state_16568__$1;
(statearr_16575_16768[(2)] = inst_16412);

(statearr_16575_16768[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (74))){
var inst_16518 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16576_16769 = state_16568__$1;
(statearr_16576_16769[(2)] = inst_16518);

(statearr_16576_16769[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (110))){
var inst_16545 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16545)){
var statearr_16577_16770 = state_16568__$1;
(statearr_16577_16770[(1)] = (117));

} else {
var statearr_16578_16771 = state_16568__$1;
(statearr_16578_16771[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (7))){
var inst_16563 = (state_16568[(2)]);
var _ = (function (){var statearr_16579 = state_16568;
(statearr_16579[(4)] = cljs.core.rest((state_16568[(4)])));

return statearr_16579;
})();
var state_16568__$1 = state_16568;
var statearr_16580_16772 = state_16568__$1;
(statearr_16580_16772[(2)] = inst_16563);

(statearr_16580_16772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (59))){
var inst_16416 = (state_16568[(10)]);
var inst_16296 = (state_16568[(11)]);
var inst_16415 = (state_16568[(2)]);
var inst_16416__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16581 = state_16568;
(statearr_16581[(12)] = inst_16415);

(statearr_16581[(10)] = inst_16416__$1);

return statearr_16581;
})();
if(cljs.core.truth_(inst_16416__$1)){
var statearr_16582_16773 = state_16568__$1;
(statearr_16582_16773[(1)] = (63));

} else {
var statearr_16583_16774 = state_16568__$1;
(statearr_16583_16774[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (86))){
var inst_16458 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16584_16775 = state_16568__$1;
(statearr_16584_16775[(2)] = inst_16458);

(statearr_16584_16775[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (20))){
var inst_16322 = (state_16568[(13)]);
var inst_16296 = (state_16568[(11)]);
var inst_16322__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16585 = state_16568;
(statearr_16585[(13)] = inst_16322__$1);

return statearr_16585;
})();
if(cljs.core.truth_(inst_16322__$1)){
var statearr_16586_16776 = state_16568__$1;
(statearr_16586_16776[(1)] = (23));

} else {
var statearr_16587_16777 = state_16568__$1;
(statearr_16587_16777[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (72))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16437 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16588_16778 = state_16568__$1;
(statearr_16588_16778[(2)] = inst_16437);

(statearr_16588_16778[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (58))){
var inst_16377 = (state_16568[(14)]);
var state_16568__$1 = state_16568;
var statearr_16589_16779 = state_16568__$1;
(statearr_16589_16779[(2)] = inst_16377);

(statearr_16589_16779[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (60))){
var inst_16284 = (state_16568[(15)]);
var inst_16295 = (state_16568[(16)]);
var inst_16403 = fluree.db.dbproto._p_prop(inst_16284,new cljs.core.Keyword(null,"name","name",1843675177),inst_16295);
var inst_16404 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16403)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16405 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16406 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16407 = cljs.core.PersistentHashMap.fromArrays(inst_16405,inst_16406);
var inst_16408 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16404,inst_16407);
var inst_16409 = (function(){throw inst_16408})();
var state_16568__$1 = state_16568;
var statearr_16590_16780 = state_16568__$1;
(statearr_16590_16780[(2)] = inst_16409);

(statearr_16590_16780[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (27))){
var inst_16325 = (state_16568[(17)]);
var state_16568__$1 = state_16568;
var statearr_16591_16781 = state_16568__$1;
(statearr_16591_16781[(2)] = inst_16325);

(statearr_16591_16781[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (1))){
var state_16568__$1 = state_16568;
var statearr_16592_16782 = state_16568__$1;
(statearr_16592_16782[(2)] = null);

(statearr_16592_16782[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (69))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16593_16783 = state_16568__$1;
(statearr_16593_16783[(2)] = inst_16415);

(statearr_16593_16783[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (101))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16496 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16594_16784 = state_16568__$1;
(statearr_16594_16784[(2)] = inst_16496);

(statearr_16594_16784[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (24))){
var inst_16322 = (state_16568[(13)]);
var state_16568__$1 = state_16568;
var statearr_16595_16785 = state_16568__$1;
(statearr_16595_16785[(2)] = inst_16322);

(statearr_16595_16785[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (102))){
var inst_16498 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16596_16786 = state_16568__$1;
(statearr_16596_16786[(2)] = inst_16498);

(statearr_16596_16786[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (55))){
var inst_16394 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16597_16787 = state_16568__$1;
(statearr_16597_16787[(2)] = inst_16394);

(statearr_16597_16787[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (85))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16456 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16598_16788 = state_16568__$1;
(statearr_16598_16788[(2)] = inst_16456);

(statearr_16598_16788[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (39))){
var inst_16359 = (state_16568[(18)]);
var state_16568__$1 = state_16568;
var statearr_16599_16789 = state_16568__$1;
(statearr_16599_16789[(2)] = inst_16359);

(statearr_16599_16789[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (88))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16600_16790 = state_16568__$1;
(statearr_16600_16790[(2)] = inst_16415);

(statearr_16600_16790[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (46))){
var inst_16378 = (state_16568[(19)]);
var inst_16296 = (state_16568[(11)]);
var inst_16377 = (state_16568[(2)]);
var inst_16378__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16601 = state_16568;
(statearr_16601[(14)] = inst_16377);

(statearr_16601[(19)] = inst_16378__$1);

return statearr_16601;
})();
if(cljs.core.truth_(inst_16378__$1)){
var statearr_16602_16791 = state_16568__$1;
(statearr_16602_16791[(1)] = (47));

} else {
var statearr_16603_16792 = state_16568__$1;
(statearr_16603_16792[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (4))){
var inst_16257 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16604_16793 = state_16568__$1;
(statearr_16604_16793[(2)] = inst_16257);

(statearr_16604_16793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (77))){
var inst_16516 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16605_16794 = state_16568__$1;
(statearr_16605_16794[(2)] = inst_16516);

(statearr_16605_16794[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (106))){
var inst_16508 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16606_16795 = state_16568__$1;
(statearr_16606_16795[(2)] = inst_16508);

(statearr_16606_16795[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (119))){
var inst_16294 = (state_16568[(20)]);
var inst_16558 = (state_16568[(2)]);
var inst_16283 = inst_16294;
var inst_16284 = inst_16558;
var state_16568__$1 = (function (){var statearr_16607 = state_16568;
(statearr_16607[(21)] = inst_16283);

(statearr_16607[(15)] = inst_16284);

return statearr_16607;
})();
var statearr_16608_16796 = state_16568__$1;
(statearr_16608_16796[(2)] = null);

(statearr_16608_16796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (95))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16480 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16481 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16480,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,5,inst_16480,null));
var inst_16482 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16481,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16481,null));
var inst_16483 = (inst_16482.cljs$core$IFn$_invoke$arity$1 ? inst_16482.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16482.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16483)){
var statearr_16609_16797 = state_16568__$1;
(statearr_16609_16797[(1)] = (96));

} else {
var statearr_16610_16798 = state_16568__$1;
(statearr_16610_16798[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (54))){
var inst_16385 = (state_16568[(22)]);
var state_16568__$1 = state_16568;
var statearr_16611_16799 = state_16568__$1;
(statearr_16611_16799[(2)] = inst_16385);

(statearr_16611_16799[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (92))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16612_16800 = state_16568__$1;
(statearr_16612_16800[(2)] = inst_16415);

(statearr_16612_16800[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (104))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16613_16801 = state_16568__$1;
(statearr_16613_16801[(2)] = inst_16415);

(statearr_16613_16801[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (15))){
var inst_16304 = (state_16568[(23)]);
var state_16568__$1 = state_16568;
var statearr_16614_16802 = state_16568__$1;
(statearr_16614_16802[(2)] = inst_16304);

(statearr_16614_16802[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (48))){
var inst_16378 = (state_16568[(19)]);
var state_16568__$1 = state_16568;
var statearr_16615_16803 = state_16568__$1;
(statearr_16615_16803[(2)] = inst_16378);

(statearr_16615_16803[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (50))){
var inst_16385 = (state_16568[(22)]);
var inst_16296 = (state_16568[(11)]);
var inst_16383 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16384 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16383);
var inst_16385__$1 = inst_16384 === true;
var state_16568__$1 = (function (){var statearr_16616 = state_16568;
(statearr_16616[(22)] = inst_16385__$1);

return statearr_16616;
})();
if(cljs.core.truth_(inst_16385__$1)){
var statearr_16617_16804 = state_16568__$1;
(statearr_16617_16804[(1)] = (53));

} else {
var statearr_16618_16805 = state_16568__$1;
(statearr_16618_16805[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (116))){
var inst_16539 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16619_16806 = state_16568__$1;
(statearr_16619_16806[(2)] = inst_16539);

(statearr_16619_16806[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (75))){
var inst_16428 = (state_16568[(8)]);
var state_16568__$1 = state_16568;
var G__16620_16807 = inst_16428;
var G__16620_16808__$1 = (((G__16620_16807 instanceof cljs.core.Keyword))?G__16620_16807.fqn:null);
switch (G__16620_16808__$1) {
case "long":
var statearr_16621_16810 = state_16568__$1;
(statearr_16621_16810[(1)] = (79));


break;
case "bigint":
var statearr_16622_16811 = state_16568__$1;
(statearr_16622_16811[(1)] = (83));


break;
case "double":
var statearr_16623_16812 = state_16568__$1;
(statearr_16623_16812[(1)] = (87));


break;
case "float":
var statearr_16624_16813 = state_16568__$1;
(statearr_16624_16813[(1)] = (91));


break;
case "bigdec":
var statearr_16625_16814 = state_16568__$1;
(statearr_16625_16814[(1)] = (95));


break;
case "string":
var statearr_16626_16815 = state_16568__$1;
(statearr_16626_16815[(1)] = (99));


break;
case "instant":
var statearr_16627_16816 = state_16568__$1;
(statearr_16627_16816[(1)] = (103));


break;
default:
var statearr_16628_16817 = state_16568__$1;
(statearr_16628_16817[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (99))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16490 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16491 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_16490,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,5,inst_16490,null));
var inst_16492 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16491,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16491,null));
var inst_16493 = (inst_16492.cljs$core$IFn$_invoke$arity$1 ? inst_16492.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16492.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16493)){
var statearr_16629_16818 = state_16568__$1;
(statearr_16629_16818[(1)] = (100));

} else {
var statearr_16630_16819 = state_16568__$1;
(statearr_16630_16819[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (21))){
var inst_16320 = (state_16568[(24)]);
var state_16568__$1 = state_16568;
var statearr_16631_16820 = state_16568__$1;
(statearr_16631_16820[(2)] = inst_16320);

(statearr_16631_16820[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (31))){
var inst_16336 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16632_16821 = state_16568__$1;
(statearr_16632_16821[(2)] = inst_16336);

(statearr_16632_16821[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (113))){
var inst_16542 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16633_16822 = state_16568__$1;
(statearr_16633_16822[(2)] = inst_16542);

(statearr_16633_16822[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (32))){
var state_16568__$1 = state_16568;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16634_16823 = state_16568__$1;
(statearr_16634_16823[(1)] = (35));

} else {
var statearr_16635_16824 = state_16568__$1;
(statearr_16635_16824[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (40))){
var inst_16372 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16372)){
var statearr_16636_16825 = state_16568__$1;
(statearr_16636_16825[(1)] = (44));

} else {
var statearr_16637_16826 = state_16568__$1;
(statearr_16637_16826[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (91))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16470 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16471 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16470,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,3,inst_16470,null));
var inst_16472 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16471,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16471,null));
var inst_16473 = (inst_16472.cljs$core$IFn$_invoke$arity$1 ? inst_16472.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16472.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16473)){
var statearr_16638_16827 = state_16568__$1;
(statearr_16638_16827[(1)] = (92));

} else {
var statearr_16639_16828 = state_16568__$1;
(statearr_16639_16828[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (117))){
var state_16568__$1 = state_16568;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16640_16829 = state_16568__$1;
(statearr_16640_16829[(1)] = (120));

} else {
var statearr_16641_16830 = state_16568__$1;
(statearr_16641_16830[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (108))){
var inst_16527 = (state_16568[(25)]);
var inst_16296 = (state_16568[(11)]);
var inst_16527__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16642 = state_16568;
(statearr_16642[(25)] = inst_16527__$1);

return statearr_16642;
})();
if(cljs.core.truth_(inst_16527__$1)){
var statearr_16643_16831 = state_16568__$1;
(statearr_16643_16831[(1)] = (111));

} else {
var statearr_16644_16832 = state_16568__$1;
(statearr_16644_16832[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (56))){
var inst_16389 = (state_16568[(2)]);
var inst_16390 = fluree.db.util.async.throw_err(inst_16389);
var inst_16391 = cljs.core.not(inst_16390);
var state_16568__$1 = state_16568;
var statearr_16645_16833 = state_16568__$1;
(statearr_16645_16833[(2)] = inst_16391);

(statearr_16645_16833[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (33))){
var inst_16319 = (state_16568[(26)]);
var state_16568__$1 = state_16568;
var statearr_16646_16834 = state_16568__$1;
(statearr_16646_16834[(2)] = inst_16319);

(statearr_16646_16834[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (13))){
var inst_16314 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16314)){
var statearr_16647_16835 = state_16568__$1;
(statearr_16647_16835[(1)] = (17));

} else {
var statearr_16648_16836 = state_16568__$1;
(statearr_16648_16836[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (22))){
var inst_16345 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16345)){
var statearr_16649_16837 = state_16568__$1;
(statearr_16649_16837[(1)] = (32));

} else {
var statearr_16650_16838 = state_16568__$1;
(statearr_16650_16838[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (90))){
var inst_16468 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16651_16839 = state_16568__$1;
(statearr_16651_16839[(2)] = inst_16468);

(statearr_16651_16839[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (109))){
var inst_16525 = (state_16568[(27)]);
var state_16568__$1 = state_16568;
var statearr_16652_16840 = state_16568__$1;
(statearr_16652_16840[(2)] = inst_16525);

(statearr_16652_16840[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (36))){
var inst_16319 = (state_16568[(26)]);
var state_16568__$1 = state_16568;
var statearr_16653_16841 = state_16568__$1;
(statearr_16653_16841[(2)] = inst_16319);

(statearr_16653_16841[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (41))){
var inst_16296 = (state_16568[(11)]);
var inst_16364 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16365 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16364);
var inst_16366 = inst_16365 === true;
var state_16568__$1 = state_16568;
var statearr_16654_16842 = state_16568__$1;
(statearr_16654_16842[(2)] = inst_16366);

(statearr_16654_16842[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (118))){
var inst_16523 = (state_16568[(7)]);
var state_16568__$1 = state_16568;
var statearr_16655_16843 = state_16568__$1;
(statearr_16655_16843[(2)] = inst_16523);

(statearr_16655_16843[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (89))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16466 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16656_16844 = state_16568__$1;
(statearr_16656_16844[(2)] = inst_16466);

(statearr_16656_16844[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (100))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16657_16845 = state_16568__$1;
(statearr_16657_16845[(2)] = inst_16415);

(statearr_16657_16845[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (122))){
var inst_16555 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16658_16846 = state_16568__$1;
(statearr_16658_16846[(2)] = inst_16555);

(statearr_16658_16846[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (43))){
var inst_16369 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16659_16847 = state_16568__$1;
(statearr_16659_16847[(2)] = inst_16369);

(statearr_16659_16847[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (61))){
var inst_16377 = (state_16568[(14)]);
var state_16568__$1 = state_16568;
var statearr_16660_16848 = state_16568__$1;
(statearr_16660_16848[(2)] = inst_16377);

(statearr_16660_16848[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (29))){
var inst_16296 = (state_16568[(11)]);
var inst_16331 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16332 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16331);
var inst_16333 = inst_16332 === true;
var state_16568__$1 = state_16568;
var statearr_16661_16849 = state_16568__$1;
(statearr_16661_16849[(2)] = inst_16333);

(statearr_16661_16849[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (44))){
var inst_16358 = (state_16568[(28)]);
var inst_16374 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16358,"a component","a non-component",throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16662_16850 = state_16568__$1;
(statearr_16662_16850[(2)] = inst_16374);

(statearr_16662_16850[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (93))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16476 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16663_16851 = state_16568__$1;
(statearr_16663_16851[(2)] = inst_16476);

(statearr_16663_16851[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (6))){
var inst_16283 = (state_16568[(21)]);
var inst_16295 = (state_16568[(16)]);
var inst_16292 = cljs.core.seq(inst_16283);
var inst_16293 = cljs.core.first(inst_16292);
var inst_16294 = cljs.core.next(inst_16292);
var inst_16295__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16293,(0),null);
var inst_16296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16293,(1),null);
var inst_16297 = cljs.core.not(inst_16295__$1);
var state_16568__$1 = (function (){var statearr_16664 = state_16568;
(statearr_16664[(20)] = inst_16294);

(statearr_16664[(16)] = inst_16295__$1);

(statearr_16664[(11)] = inst_16296);

return statearr_16664;
})();
if(inst_16297){
var statearr_16665_16852 = state_16568__$1;
(statearr_16665_16852[(1)] = (8));

} else {
var statearr_16666_16853 = state_16568__$1;
(statearr_16666_16853[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (111))){
var inst_16531 = (state_16568[(29)]);
var inst_16296 = (state_16568[(11)]);
var inst_16529 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16530 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16529);
var inst_16531__$1 = inst_16530 === true;
var state_16568__$1 = (function (){var statearr_16667 = state_16568;
(statearr_16667[(29)] = inst_16531__$1);

return statearr_16667;
})();
if(cljs.core.truth_(inst_16531__$1)){
var statearr_16668_16854 = state_16568__$1;
(statearr_16668_16854[(1)] = (114));

} else {
var statearr_16669_16855 = state_16568__$1;
(statearr_16669_16855[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (28))){
var inst_16339 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16670_16856 = state_16568__$1;
(statearr_16670_16856[(2)] = inst_16339);

(statearr_16670_16856[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (64))){
var inst_16416 = (state_16568[(10)]);
var state_16568__$1 = state_16568;
var statearr_16671_16857 = state_16568__$1;
(statearr_16671_16857[(2)] = inst_16416);

(statearr_16671_16857[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (103))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16500 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16501 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16500,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,2,inst_16500,null));
var inst_16502 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16501,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16501,null));
var inst_16503 = (inst_16502.cljs$core$IFn$_invoke$arity$1 ? inst_16502.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16502.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16503)){
var statearr_16672_16858 = state_16568__$1;
(statearr_16672_16858[(1)] = (104));

} else {
var statearr_16673_16859 = state_16568__$1;
(statearr_16673_16859[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (51))){
var inst_16381 = (state_16568[(30)]);
var state_16568__$1 = state_16568;
var statearr_16674_16860 = state_16568__$1;
(statearr_16674_16860[(2)] = inst_16381);

(statearr_16674_16860[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (25))){
var inst_16342 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16675_16861 = state_16568__$1;
(statearr_16675_16861[(2)] = inst_16342);

(statearr_16675_16861[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (34))){
var inst_16359 = (state_16568[(18)]);
var inst_16296 = (state_16568[(11)]);
var inst_16358 = (state_16568[(2)]);
var inst_16359__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16676 = state_16568;
(statearr_16676[(18)] = inst_16359__$1);

(statearr_16676[(28)] = inst_16358);

return statearr_16676;
})();
if(cljs.core.truth_(inst_16359__$1)){
var statearr_16677_16862 = state_16568__$1;
(statearr_16677_16862[(1)] = (38));

} else {
var statearr_16678_16863 = state_16568__$1;
(statearr_16678_16863[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (17))){
var inst_16284 = (state_16568[(15)]);
var inst_16316 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_16284,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16679_16864 = state_16568__$1;
(statearr_16679_16864[(2)] = inst_16316);

(statearr_16679_16864[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (3))){
var inst_16566 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16568__$1,inst_16566);
} else {
if((state_val_16569 === (12))){
var inst_16300 = (state_16568[(31)]);
var state_16568__$1 = state_16568;
var statearr_16680_16865 = state_16568__$1;
(statearr_16680_16865[(2)] = inst_16300);

(statearr_16680_16865[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (2))){
var _ = (function (){var statearr_16681 = state_16568;
(statearr_16681[(4)] = cljs.core.cons((5),(state_16568[(4)])));

return statearr_16681;
})();
var inst_16276 = pred_changes;
var inst_16277 = cljs.core.seq(inst_16276);
var inst_16278 = cljs.core.first(inst_16277);
var inst_16279 = cljs.core.next(inst_16277);
var inst_16280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16278,(0),null);
var inst_16281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16278,(1),null);
var inst_16282 = db;
var inst_16283 = inst_16276;
var inst_16284 = inst_16282;
var state_16568__$1 = (function (){var statearr_16682 = state_16568;
(statearr_16682[(21)] = inst_16283);

(statearr_16682[(15)] = inst_16284);

(statearr_16682[(32)] = inst_16279);

(statearr_16682[(33)] = inst_16281);

(statearr_16682[(34)] = inst_16280);

return statearr_16682;
})();
var statearr_16683_16866 = state_16568__$1;
(statearr_16683_16866[(2)] = null);

(statearr_16683_16866[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (66))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16296 = (state_16568[(11)]);
var inst_16425 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16426 = cljs.core.__destructure_map(inst_16425);
var inst_16427__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16426,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16428__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16426,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16429 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16428__$1,inst_16427__$1);
var state_16568__$1 = (function (){var statearr_16684 = state_16568;
(statearr_16684[(8)] = inst_16428__$1);

(statearr_16684[(9)] = inst_16427__$1);

return statearr_16684;
})();
if(inst_16429){
var statearr_16685_16867 = state_16568__$1;
(statearr_16685_16867[(1)] = (69));

} else {
var statearr_16686_16868 = state_16568__$1;
(statearr_16686_16868[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (107))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16510 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16687_16869 = state_16568__$1;
(statearr_16687_16869[(2)] = inst_16510);

(statearr_16687_16869[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (23))){
var inst_16325 = (state_16568[(17)]);
var inst_16296 = (state_16568[(11)]);
var inst_16324 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16325__$1 = inst_16324 === true;
var state_16568__$1 = (function (){var statearr_16688 = state_16568;
(statearr_16688[(17)] = inst_16325__$1);

return statearr_16688;
})();
if(cljs.core.truth_(inst_16325__$1)){
var statearr_16689_16870 = state_16568__$1;
(statearr_16689_16870[(1)] = (26));

} else {
var statearr_16690_16871 = state_16568__$1;
(statearr_16690_16871[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (47))){
var inst_16381 = (state_16568[(30)]);
var inst_16296 = (state_16568[(11)]);
var inst_16380 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16381__$1 = cljs.core.not(inst_16380);
var state_16568__$1 = (function (){var statearr_16691 = state_16568;
(statearr_16691[(30)] = inst_16381__$1);

return statearr_16691;
})();
if(inst_16381__$1){
var statearr_16692_16872 = state_16568__$1;
(statearr_16692_16872[(1)] = (50));

} else {
var statearr_16693_16873 = state_16568__$1;
(statearr_16693_16873[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (35))){
var inst_16348 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16349 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16350 = cljs.core.PersistentHashMap.fromArrays(inst_16348,inst_16349);
var inst_16351 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_16350);
var inst_16352 = (function(){throw inst_16351})();
var state_16568__$1 = state_16568;
var statearr_16694_16874 = state_16568__$1;
(statearr_16694_16874[(2)] = inst_16352);

(statearr_16694_16874[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (82))){
var inst_16448 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16695_16875 = state_16568__$1;
(statearr_16695_16875[(2)] = inst_16448);

(statearr_16695_16875[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (76))){
var state_16568__$1 = state_16568;
var statearr_16696_16876 = state_16568__$1;
(statearr_16696_16876[(2)] = null);

(statearr_16696_16876[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (97))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16486 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16697_16877 = state_16568__$1;
(statearr_16697_16877[(2)] = inst_16486);

(statearr_16697_16877[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (19))){
var inst_16320 = (state_16568[(24)]);
var inst_16296 = (state_16568[(11)]);
var inst_16319 = (state_16568[(2)]);
var inst_16320__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16698 = state_16568;
(statearr_16698[(26)] = inst_16319);

(statearr_16698[(24)] = inst_16320__$1);

return statearr_16698;
})();
if(cljs.core.truth_(inst_16320__$1)){
var statearr_16699_16878 = state_16568__$1;
(statearr_16699_16878[(1)] = (20));

} else {
var statearr_16700_16879 = state_16568__$1;
(statearr_16700_16879[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (57))){
var state_16568__$1 = state_16568;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16701_16880 = state_16568__$1;
(statearr_16701_16880[(1)] = (60));

} else {
var statearr_16702_16881 = state_16568__$1;
(statearr_16702_16881[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (68))){
var inst_16525 = (state_16568[(27)]);
var inst_16296 = (state_16568[(11)]);
var inst_16523 = (state_16568[(2)]);
var inst_16524 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16525__$1 = inst_16524 === true;
var state_16568__$1 = (function (){var statearr_16703 = state_16568;
(statearr_16703[(7)] = inst_16523);

(statearr_16703[(27)] = inst_16525__$1);

return statearr_16703;
})();
if(cljs.core.truth_(inst_16525__$1)){
var statearr_16704_16882 = state_16568__$1;
(statearr_16704_16882[(1)] = (108));

} else {
var statearr_16705_16883 = state_16568__$1;
(statearr_16705_16883[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (11))){
var inst_16304 = (state_16568[(23)]);
var inst_16296 = (state_16568[(11)]);
var inst_16302 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16303 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16302);
var inst_16304__$1 = inst_16303 === false;
var state_16568__$1 = (function (){var statearr_16706 = state_16568;
(statearr_16706[(23)] = inst_16304__$1);

return statearr_16706;
})();
if(cljs.core.truth_(inst_16304__$1)){
var statearr_16707_16884 = state_16568__$1;
(statearr_16707_16884[(1)] = (14));

} else {
var statearr_16708_16885 = state_16568__$1;
(statearr_16708_16885[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (115))){
var inst_16531 = (state_16568[(29)]);
var state_16568__$1 = state_16568;
var statearr_16710_16886 = state_16568__$1;
(statearr_16710_16886[(2)] = inst_16531);

(statearr_16710_16886[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (9))){
var inst_16300 = (state_16568[(31)]);
var inst_16296 = (state_16568[(11)]);
var inst_16300__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16296);
var state_16568__$1 = (function (){var statearr_16711 = state_16568;
(statearr_16711[(31)] = inst_16300__$1);

return statearr_16711;
})();
if(cljs.core.truth_(inst_16300__$1)){
var statearr_16712_16887 = state_16568__$1;
(statearr_16712_16887[(1)] = (11));

} else {
var statearr_16713_16888 = state_16568__$1;
(statearr_16713_16888[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (5))){
var _ = (function (){var statearr_16714 = state_16568;
(statearr_16714[(4)] = cljs.core.rest((state_16568[(4)])));

return statearr_16714;
})();
var state_16568__$1 = state_16568;
var ex16709 = (state_16568__$1[(2)]);
var statearr_16715_16889 = state_16568__$1;
(statearr_16715_16889[(5)] = ex16709);


if((ex16709 instanceof Error)){
var statearr_16716_16890 = state_16568__$1;
(statearr_16716_16890[(1)] = (4));

(statearr_16716_16890[(5)] = null);

} else {
throw ex16709;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (112))){
var inst_16527 = (state_16568[(25)]);
var state_16568__$1 = state_16568;
var statearr_16717_16891 = state_16568__$1;
(statearr_16717_16891[(2)] = inst_16527);

(statearr_16717_16891[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (83))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16450 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16451 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16450,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,3,inst_16450,null));
var inst_16452 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16451,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16451,null));
var inst_16453 = (inst_16452.cljs$core$IFn$_invoke$arity$1 ? inst_16452.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16452.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16453)){
var statearr_16718_16892 = state_16568__$1;
(statearr_16718_16892[(1)] = (84));

} else {
var statearr_16719_16893 = state_16568__$1;
(statearr_16719_16893[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (14))){
var inst_16296 = (state_16568[(11)]);
var inst_16306 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16307 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16306);
var inst_16308 = inst_16307 === true;
var state_16568__$1 = state_16568;
var statearr_16720_16894 = state_16568__$1;
(statearr_16720_16894[(2)] = inst_16308);

(statearr_16720_16894[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (45))){
var inst_16358 = (state_16568[(28)]);
var state_16568__$1 = state_16568;
var statearr_16721_16895 = state_16568__$1;
(statearr_16721_16895[(2)] = inst_16358);

(statearr_16721_16895[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (53))){
var inst_16284 = (state_16568[(15)]);
var inst_16295 = (state_16568[(16)]);
var inst_16387 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_16284,inst_16295);
var state_16568__$1 = state_16568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16568__$1,(56),inst_16387);
} else {
if((state_val_16569 === (78))){
var inst_16513 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16722_16896 = state_16568__$1;
(statearr_16722_16896[(2)] = inst_16513);

(statearr_16722_16896[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (26))){
var inst_16329 = (state_16568[(35)]);
var inst_16296 = (state_16568[(11)]);
var inst_16327 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16328 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16327);
var inst_16329__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16328);
var state_16568__$1 = (function (){var statearr_16723 = state_16568;
(statearr_16723[(35)] = inst_16329__$1);

return statearr_16723;
})();
if(inst_16329__$1){
var statearr_16724_16897 = state_16568__$1;
(statearr_16724_16897[(1)] = (29));

} else {
var statearr_16725_16898 = state_16568__$1;
(statearr_16725_16898[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (16))){
var inst_16311 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16726_16899 = state_16568__$1;
(statearr_16726_16899[(2)] = inst_16311);

(statearr_16726_16899[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (81))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16446 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16727_16900 = state_16568__$1;
(statearr_16727_16900[(2)] = inst_16446);

(statearr_16727_16900[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (120))){
var inst_16548 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16549 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16550 = cljs.core.PersistentHashMap.fromArrays(inst_16548,inst_16549);
var inst_16551 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_16550);
var inst_16552 = (function(){throw inst_16551})();
var state_16568__$1 = state_16568;
var statearr_16728_16901 = state_16568__$1;
(statearr_16728_16901[(2)] = inst_16552);

(statearr_16728_16901[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (79))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16440 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16441 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_16440,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,2,inst_16440,null));
var inst_16442 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16441,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16441,null));
var inst_16443 = (inst_16442.cljs$core$IFn$_invoke$arity$1 ? inst_16442.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16442.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16443)){
var statearr_16729_16902 = state_16568__$1;
(statearr_16729_16902[(1)] = (80));

} else {
var statearr_16730_16903 = state_16568__$1;
(statearr_16730_16903[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (38))){
var inst_16362 = (state_16568[(36)]);
var inst_16296 = (state_16568[(11)]);
var inst_16361 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16362__$1 = cljs.core.not(inst_16361);
var state_16568__$1 = (function (){var statearr_16731 = state_16568;
(statearr_16731[(36)] = inst_16362__$1);

return statearr_16731;
})();
if(inst_16362__$1){
var statearr_16732_16904 = state_16568__$1;
(statearr_16732_16904[(1)] = (41));

} else {
var statearr_16733_16905 = state_16568__$1;
(statearr_16733_16905[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (98))){
var inst_16488 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16734_16906 = state_16568__$1;
(statearr_16734_16906[(2)] = inst_16488);

(statearr_16734_16906[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (87))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16460 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16461 = (inst_16428.cljs$core$IFn$_invoke$arity$5 ? inst_16428.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_16460,null) : inst_16428.call(null,cljs.core.PersistentArrayMap,null,3,inst_16460,null));
var inst_16462 = (inst_16428.cljs$core$IFn$_invoke$arity$4 ? inst_16428.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_16461,null) : inst_16428.call(null,cljs.core.PersistentHashSet,null,inst_16461,null));
var inst_16463 = (inst_16462.cljs$core$IFn$_invoke$arity$1 ? inst_16462.cljs$core$IFn$_invoke$arity$1(inst_16427) : inst_16462.call(null,inst_16427));
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16463)){
var statearr_16735_16907 = state_16568__$1;
(statearr_16735_16907[(1)] = (88));

} else {
var statearr_16736_16908 = state_16568__$1;
(statearr_16736_16908[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (30))){
var inst_16329 = (state_16568[(35)]);
var state_16568__$1 = state_16568;
var statearr_16737_16909 = state_16568__$1;
(statearr_16737_16909[(2)] = inst_16329);

(statearr_16737_16909[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (73))){
var state_16568__$1 = state_16568;
var statearr_16738_16910 = state_16568__$1;
(statearr_16738_16910[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (96))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16740_16911 = state_16568__$1;
(statearr_16740_16911[(2)] = inst_16415);

(statearr_16740_16911[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (10))){
var inst_16561 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16741_16912 = state_16568__$1;
(statearr_16741_16912[(2)] = inst_16561);

(statearr_16741_16912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (18))){
var inst_16284 = (state_16568[(15)]);
var state_16568__$1 = state_16568;
var statearr_16742_16913 = state_16568__$1;
(statearr_16742_16913[(2)] = inst_16284);

(statearr_16742_16913[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (105))){
var inst_16428 = (state_16568[(8)]);
var inst_16427 = (state_16568[(9)]);
var inst_16506 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_16427,inst_16428,throw_QMARK_);
var state_16568__$1 = state_16568;
var statearr_16743_16914 = state_16568__$1;
(statearr_16743_16914[(2)] = inst_16506);

(statearr_16743_16914[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (52))){
var inst_16397 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16744_16915 = state_16568__$1;
(statearr_16744_16915[(2)] = inst_16397);

(statearr_16744_16915[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (114))){
var inst_16296 = (state_16568[(11)]);
var inst_16533 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16534 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16533);
var inst_16535 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16534);
var inst_16536 = (!(inst_16535));
var state_16568__$1 = state_16568;
var statearr_16745_16916 = state_16568__$1;
(statearr_16745_16916[(2)] = inst_16536);

(statearr_16745_16916[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (67))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16746_16917 = state_16568__$1;
(statearr_16746_16917[(2)] = inst_16415);

(statearr_16746_16917[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (71))){
var inst_16520 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16747_16918 = state_16568__$1;
(statearr_16747_16918[(2)] = inst_16520);

(statearr_16747_16918[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (42))){
var inst_16362 = (state_16568[(36)]);
var state_16568__$1 = state_16568;
var statearr_16748_16919 = state_16568__$1;
(statearr_16748_16919[(2)] = inst_16362);

(statearr_16748_16919[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (80))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16749_16920 = state_16568__$1;
(statearr_16749_16920[(2)] = inst_16415);

(statearr_16749_16920[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (37))){
var inst_16355 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16750_16921 = state_16568__$1;
(statearr_16750_16921[(2)] = inst_16355);

(statearr_16750_16921[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (63))){
var inst_16296 = (state_16568[(11)]);
var inst_16418 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16296);
var inst_16419 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16418);
var state_16568__$1 = state_16568;
var statearr_16751_16922 = state_16568__$1;
(statearr_16751_16922[(2)] = inst_16419);

(statearr_16751_16922[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (94))){
var inst_16478 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
var statearr_16752_16923 = state_16568__$1;
(statearr_16752_16923[(2)] = inst_16478);

(statearr_16752_16923[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (8))){
var inst_16284 = (state_16568[(15)]);
var state_16568__$1 = state_16568;
var statearr_16753_16924 = state_16568__$1;
(statearr_16753_16924[(2)] = inst_16284);

(statearr_16753_16924[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (49))){
var inst_16400 = (state_16568[(2)]);
var state_16568__$1 = state_16568;
if(cljs.core.truth_(inst_16400)){
var statearr_16754_16925 = state_16568__$1;
(statearr_16754_16925[(1)] = (57));

} else {
var statearr_16755_16926 = state_16568__$1;
(statearr_16755_16926[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16569 === (84))){
var inst_16415 = (state_16568[(12)]);
var state_16568__$1 = state_16568;
var statearr_16756_16927 = state_16568__$1;
(statearr_16756_16927[(2)] = inst_16415);

(statearr_16756_16927[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_16757 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16757[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_16757[(1)] = (1));

return statearr_16757;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_16568){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16568);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16758){var ex__2687__auto__ = e16758;
var statearr_16759_16928 = state_16568;
(statearr_16759_16928[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16568[(4)]))){
var statearr_16760_16929 = state_16568;
(statearr_16760_16929[(1)] = cljs.core.first((state_16568[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16930 = state_16568;
state_16568 = G__16930;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_16568){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_16568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16761 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16761[(6)] = c__2706__auto__);

return statearr_16761;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16932 = arguments.length;
switch (G__16932) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_16956){
var state_val_16957 = (state_16956[(1)]);
if((state_val_16957 === (7))){
var state_16956__$1 = state_16956;
var statearr_16958_16978 = state_16956__$1;
(statearr_16958_16978[(2)] = db);

(statearr_16958_16978[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (1))){
var state_16956__$1 = state_16956;
var statearr_16959_16979 = state_16956__$1;
(statearr_16959_16979[(2)] = null);

(statearr_16959_16979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (4))){
var inst_16933 = (state_16956[(2)]);
var state_16956__$1 = state_16956;
var statearr_16960_16980 = state_16956__$1;
(statearr_16960_16980[(2)] = inst_16933);

(statearr_16960_16980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (6))){
var inst_16942 = (state_16956[(7)]);
var inst_16941 = (state_16956[(2)]);
var inst_16942__$1 = fluree.db.util.async.throw_err(inst_16941);
var inst_16943 = cljs.core.empty_QMARK_(inst_16942__$1);
var state_16956__$1 = (function (){var statearr_16961 = state_16956;
(statearr_16961[(7)] = inst_16942__$1);

return statearr_16961;
})();
if(inst_16943){
var statearr_16962_16981 = state_16956__$1;
(statearr_16962_16981[(1)] = (7));

} else {
var statearr_16963_16982 = state_16956__$1;
(statearr_16963_16982[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (3))){
var inst_16954 = (state_16956[(2)]);
var state_16956__$1 = state_16956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16956__$1,inst_16954);
} else {
if((state_val_16957 === (2))){
var _ = (function (){var statearr_16965 = state_16956;
(statearr_16965[(4)] = cljs.core.cons((5),(state_16956[(4)])));

return statearr_16965;
})();
var inst_16939 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_16956__$1 = state_16956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16956__$1,(6),inst_16939);
} else {
if((state_val_16957 === (9))){
var inst_16951 = (state_16956[(2)]);
var _ = (function (){var statearr_16966 = state_16956;
(statearr_16966[(4)] = cljs.core.rest((state_16956[(4)])));

return statearr_16966;
})();
var state_16956__$1 = state_16956;
var statearr_16967_16983 = state_16956__$1;
(statearr_16967_16983[(2)] = inst_16951);

(statearr_16967_16983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (5))){
var _ = (function (){var statearr_16968 = state_16956;
(statearr_16968[(4)] = cljs.core.rest((state_16956[(4)])));

return statearr_16968;
})();
var state_16956__$1 = state_16956;
var ex16964 = (state_16956__$1[(2)]);
var statearr_16969_16984 = state_16956__$1;
(statearr_16969_16984[(5)] = ex16964);


if((ex16964 instanceof Error)){
var statearr_16970_16985 = state_16956__$1;
(statearr_16970_16985[(1)] = (4));

(statearr_16970_16985[(5)] = null);

} else {
throw ex16964;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (10))){
var inst_16948 = (state_16956[(2)]);
var inst_16949 = fluree.db.util.async.throw_err(inst_16948);
var state_16956__$1 = state_16956;
var statearr_16971_16986 = state_16956__$1;
(statearr_16971_16986[(2)] = inst_16949);

(statearr_16971_16986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16957 === (8))){
var inst_16942 = (state_16956[(7)]);
var inst_16946 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_16942,db,true);
var state_16956__$1 = state_16956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16956__$1,(10),inst_16946);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2684__auto__ = null;
var fluree$db$query$schema$state_machine__2684__auto____0 = (function (){
var statearr_16972 = [null,null,null,null,null,null,null,null];
(statearr_16972[(0)] = fluree$db$query$schema$state_machine__2684__auto__);

(statearr_16972[(1)] = (1));

return statearr_16972;
});
var fluree$db$query$schema$state_machine__2684__auto____1 = (function (state_16956){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_16956);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e16973){var ex__2687__auto__ = e16973;
var statearr_16974_16987 = state_16956;
(statearr_16974_16987[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_16956[(4)]))){
var statearr_16975_16988 = state_16956;
(statearr_16975_16988[(1)] = cljs.core.first((state_16956[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16989 = state_16956;
state_16956 = G__16989;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2684__auto__ = function(state_16956){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2684__auto____1.call(this,state_16956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2684__auto____0;
fluree$db$query$schema$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2684__auto____1;
return fluree$db$query$schema$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_16976 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_16976[(6)] = c__2706__auto__);

return statearr_16976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16991 = arguments.length;
switch (G__16991) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16993 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16993,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16993,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16993,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = fluree.db.flake.p(flake);
var o = fluree.db.flake.o(flake);
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__16996_SHARP_,p2__16997_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16996_SHARP_,p2__16997_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__16998_SHARP_){
var f = p1__16998_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,fluree.db.flake.p(f))){
return fluree.db.flake.o(f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17064){
var state_val_17065 = (state_17064[(1)]);
if((state_val_17065 === (1))){
var state_17064__$1 = state_17064;
var statearr_17066_17084 = state_17064__$1;
(statearr_17066_17084[(2)] = null);

(statearr_17066_17084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17065 === (2))){
var _ = (function (){var statearr_17067 = state_17064;
(statearr_17067[(4)] = cljs.core.cons((5),(state_17064[(4)])));

return statearr_17067;
})();
var inst_17016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17017 = fluree.db.flake.max_subject_id((1));
var inst_17018 = [inst_17017];
var inst_17019 = (new cljs.core.PersistentVector(null,1,(5),inst_17016,inst_17018,null));
var inst_17020 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17021 = [(0)];
var inst_17022 = (new cljs.core.PersistentVector(null,1,(5),inst_17020,inst_17021,null));
var inst_17023 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17019,cljs.core._LT__EQ_,inst_17022);
var state_17064__$1 = state_17064;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17064__$1,(6),inst_17023);
} else {
if((state_val_17065 === (3))){
var inst_17062 = (state_17064[(2)]);
var state_17064__$1 = state_17064;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17064__$1,inst_17062);
} else {
if((state_val_17065 === (4))){
var inst_17004 = (state_17064[(2)]);
var state_17064__$1 = state_17064;
var statearr_17069_17085 = state_17064__$1;
(statearr_17069_17085[(2)] = inst_17004);

(statearr_17069_17085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17065 === (5))){
var _ = (function (){var statearr_17070 = state_17064;
(statearr_17070[(4)] = cljs.core.rest((state_17064[(4)])));

return statearr_17070;
})();
var state_17064__$1 = state_17064;
var ex17068 = (state_17064__$1[(2)]);
var statearr_17071_17086 = state_17064__$1;
(statearr_17071_17086[(5)] = ex17068);


if((ex17068 instanceof Error)){
var statearr_17072_17087 = state_17064__$1;
(statearr_17072_17087[(1)] = (4));

(statearr_17072_17087[(5)] = null);

} else {
throw ex17068;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17065 === (6))){
var inst_17025 = (state_17064[(2)]);
var inst_17026 = fluree.db.util.async.throw_err(inst_17025);
var inst_17027 = (function (){var schema_flakes = inst_17026;
return (function (p1__16999_SHARP_){
return (fluree.db.flake.s(p1__16999_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17028 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17027,inst_17026);
var inst_17029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17028,(0),null);
var inst_17030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17028,(1),null);
var inst_17031 = (function (){var schema_flakes = inst_17026;
var vec__17010 = inst_17028;
var collection_flakes = inst_17029;
var predicate_flakes = inst_17030;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = fluree.db.flake.s(first_flake);
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__17002_SHARP_,p2__17001_SHARP_){
var f = p2__17001_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__17002_SHARP_,fluree.db.flake.p(f),fluree.db.flake.o(f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_17032 = [(-1),"_tx"];
var inst_17033 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17034 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17035 = cljs.core.PersistentHashMap.fromArrays(inst_17033,inst_17034);
var inst_17036 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17037 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17038 = cljs.core.PersistentHashMap.fromArrays(inst_17036,inst_17037);
var inst_17039 = [inst_17035,inst_17038];
var inst_17040 = cljs.core.PersistentHashMap.fromArrays(inst_17032,inst_17039);
var inst_17041 = (function (){var schema_flakes = inst_17026;
var vec__17010 = inst_17028;
var collection_flakes = inst_17029;
var predicate_flakes = inst_17030;
return (function (p1__17000_SHARP_){
return fluree.db.flake.s(p1__17000_SHARP_);
});
})();
var inst_17042 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17041,inst_17029);
var inst_17043 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17031,inst_17040,inst_17042);
var inst_17045 = (function (){var schema_flakes = inst_17026;
var vec__17010 = inst_17028;
var collection_flakes = inst_17029;
var predicate_flakes = inst_17030;
var coll = inst_17043;
return (function (p__17044,pred_flakes){
var vec__17073 = p__17044;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17073,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17073,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = fluree.db.flake.s(first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__17076 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null);
return (fexpr__17076.cljs$core$IFn$_invoke$arity$1 ? fexpr__17076.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__17076.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_17046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17047 = cljs.core.PersistentHashMap.EMPTY;
var inst_17048 = cljs.core.PersistentHashSet.EMPTY;
var inst_17049 = [inst_17047,inst_17048];
var inst_17050 = (new cljs.core.PersistentVector(null,2,(5),inst_17046,inst_17049,null));
var inst_17051 = (function (){var schema_flakes = inst_17026;
var vec__17010 = inst_17028;
var collection_flakes = inst_17029;
var predicate_flakes = inst_17030;
var coll = inst_17043;
return (function (p1__17003_SHARP_){
return fluree.db.flake.s(p1__17003_SHARP_);
});
})();
var inst_17052 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_17051,inst_17030);
var inst_17053 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_17045,inst_17050,inst_17052);
var inst_17054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17053,(0),null);
var inst_17055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17053,(1),null);
var inst_17056 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17057 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17058 = [inst_17057,inst_17043,inst_17054,inst_17055];
var inst_17059 = cljs.core.PersistentHashMap.fromArrays(inst_17056,inst_17058);
var _ = (function (){var statearr_17077 = state_17064;
(statearr_17077[(4)] = cljs.core.rest((state_17064[(4)])));

return statearr_17077;
})();
var state_17064__$1 = state_17064;
var statearr_17078_17088 = state_17064__$1;
(statearr_17078_17088[(2)] = inst_17059);

(statearr_17078_17088[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17079 = [null,null,null,null,null,null,null];
(statearr_17079[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2684__auto__);

(statearr_17079[(1)] = (1));

return statearr_17079;
});
var fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1 = (function (state_17064){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17064);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17080){var ex__2687__auto__ = e17080;
var statearr_17081_17089 = state_17064;
(statearr_17081_17089[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17064[(4)]))){
var statearr_17082_17090 = state_17064;
(statearr_17082_17090[(1)] = cljs.core.first((state_17064[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17091 = state_17064;
state_17064 = G__17091;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__ = function(state_17064){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1.call(this,state_17064);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17083 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17083[(6)] = c__2706__auto__);

return statearr_17083;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_17133){
var state_val_17134 = (state_17133[(1)]);
if((state_val_17134 === (7))){
var inst_17116 = (state_17133[(2)]);
var inst_17117 = fluree.db.query.schema.flake__GT_pred_map(inst_17116);
var inst_17118 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17117,(114));
var inst_17120 = cljs.core.boolean$(inst_17119);
var inst_17121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17117,(110));
var inst_17122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17117,(117));
var inst_17123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_17122);
var inst_17124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17117,(111));
var inst_17125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17117,(115));
var inst_17126 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_17117,(112));
var inst_17127 = [inst_17120,inst_17121,inst_17123,inst_17124,inst_17125,inst_17126];
var inst_17128 = cljs.core.PersistentHashMap.fromArrays(inst_17118,inst_17127);
var _ = (function (){var statearr_17135 = state_17133;
(statearr_17135[(4)] = cljs.core.rest((state_17133[(4)])));

return statearr_17135;
})();
var state_17133__$1 = state_17133;
var statearr_17136_17159 = state_17133__$1;
(statearr_17136_17159[(2)] = inst_17128);

(statearr_17136_17159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (1))){
var state_17133__$1 = state_17133;
var statearr_17137_17160 = state_17133__$1;
(statearr_17137_17160[(2)] = null);

(statearr_17137_17160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (4))){
var inst_17092 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
var statearr_17138_17161 = state_17133__$1;
(statearr_17138_17161[(2)] = inst_17092);

(statearr_17138_17161[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (6))){
var _ = (function (){var statearr_17139 = state_17133;
(statearr_17139[(4)] = cljs.core.cons((9),(state_17133[(4)])));

return statearr_17139;
})();
var inst_17104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17106 = ["_setting/id","root"];
var inst_17107 = (new cljs.core.PersistentVector(null,2,(5),inst_17105,inst_17106,null));
var inst_17108 = [inst_17107];
var inst_17109 = (new cljs.core.PersistentVector(null,1,(5),inst_17104,inst_17108,null));
var inst_17110 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17109);
var state_17133__$1 = state_17133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17133__$1,(10),inst_17110);
} else {
if((state_val_17134 === (3))){
var inst_17131 = (state_17133[(2)]);
var state_17133__$1 = state_17133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17133__$1,inst_17131);
} else {
if((state_val_17134 === (2))){
var _ = (function (){var statearr_17142 = state_17133;
(statearr_17142[(4)] = cljs.core.cons((5),(state_17133[(4)])));

return statearr_17142;
})();
var state_17133__$1 = state_17133;
var statearr_17143_17162 = state_17133__$1;
(statearr_17143_17162[(2)] = null);

(statearr_17143_17162[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (9))){
var _ = (function (){var statearr_17144 = state_17133;
(statearr_17144[(4)] = cljs.core.rest((state_17133[(4)])));

return statearr_17144;
})();
var state_17133__$1 = state_17133;
var ex17140 = (state_17133__$1[(2)]);
var statearr_17145_17163 = state_17133__$1;
(statearr_17145_17163[(5)] = ex17140);


var statearr_17146_17164 = state_17133__$1;
(statearr_17146_17164[(1)] = (8));

(statearr_17146_17164[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (5))){
var _ = (function (){var statearr_17147 = state_17133;
(statearr_17147[(4)] = cljs.core.rest((state_17133[(4)])));

return statearr_17147;
})();
var state_17133__$1 = state_17133;
var ex17141 = (state_17133__$1[(2)]);
var statearr_17148_17165 = state_17133__$1;
(statearr_17148_17165[(5)] = ex17141);


if((ex17141 instanceof Error)){
var statearr_17149_17166 = state_17133__$1;
(statearr_17149_17166[(1)] = (4));

(statearr_17149_17166[(5)] = null);

} else {
throw ex17141;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (10))){
var inst_17112 = (state_17133[(2)]);
var inst_17113 = fluree.db.util.async.throw_err(inst_17112);
var _ = (function (){var statearr_17150 = state_17133;
(statearr_17150[(4)] = cljs.core.rest((state_17133[(4)])));

return statearr_17150;
})();
var state_17133__$1 = state_17133;
var statearr_17151_17167 = state_17133__$1;
(statearr_17151_17167[(2)] = inst_17113);

(statearr_17151_17167[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17134 === (8))){
var inst_17098 = (state_17133[(2)]);
var state_17133__$1 = (function (){var statearr_17152 = state_17133;
(statearr_17152[(7)] = inst_17098);

return statearr_17152;
})();
var statearr_17153_17168 = state_17133__$1;
(statearr_17153_17168[(2)] = null);

(statearr_17153_17168[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0 = (function (){
var statearr_17154 = [null,null,null,null,null,null,null,null];
(statearr_17154[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2684__auto__);

(statearr_17154[(1)] = (1));

return statearr_17154;
});
var fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1 = (function (state_17133){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_17133);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e17155){var ex__2687__auto__ = e17155;
var statearr_17156_17169 = state_17133;
(statearr_17156_17169[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_17133[(4)]))){
var statearr_17157_17170 = state_17133;
(statearr_17157_17170[(1)] = cljs.core.first((state_17133[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17171 = state_17133;
state_17133 = G__17171;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__ = function(state_17133){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1.call(this,state_17133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2684__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_17158 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_17158[(6)] = c__2706__auto__);

return statearr_17158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
