// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21871 = arguments.length;
switch (G__21871) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__21872 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__21872) : f.call(null,G__21872));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__21873 = cljs.core._deref(vol);
var G__21874 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__21873,G__21874) : f.call(null,G__21873,G__21874));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__21875 = cljs.core._deref(vol);
var G__21876 = arg1;
var G__21877 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__21875,G__21876,G__21877) : f.call(null,G__21875,G__21876,G__21877));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__21878 = cljs.core._deref(vol);
var G__21879 = arg1;
var G__21880 = arg2;
var G__21881 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__21878,G__21879,G__21880,G__21881) : f.call(null,G__21878,G__21879,G__21880,G__21881));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22042){
var state_val_22043 = (state_22042[(1)]);
if((state_val_22043 === (7))){
var inst_22037 = (state_22042[(2)]);
var _ = (function (){var statearr_22044 = state_22042;
(statearr_22044[(4)] = cljs.core.rest((state_22042[(4)])));

return statearr_22044;
})();
var state_22042__$1 = state_22042;
var statearr_22045_22127 = state_22042__$1;
(statearr_22045_22127[(2)] = inst_22037);

(statearr_22045_22127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (20))){
var inst_21964 = (state_22042[(7)]);
var state_22042__$1 = state_22042;
var statearr_22046_22128 = state_22042__$1;
(statearr_22046_22128[(2)] = inst_21964);

(statearr_22046_22128[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (27))){
var inst_21919 = (state_22042[(8)]);
var state_22042__$1 = state_22042;
if(cljs.core.truth_(inst_21919)){
var statearr_22047_22129 = state_22042__$1;
(statearr_22047_22129[(1)] = (29));

} else {
var statearr_22048_22130 = state_22042__$1;
(statearr_22048_22130[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (1))){
var state_22042__$1 = state_22042;
var statearr_22049_22131 = state_22042__$1;
(statearr_22049_22131[(2)] = null);

(statearr_22049_22131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (24))){
var inst_21920 = (state_22042[(9)]);
var state_22042__$1 = state_22042;
var statearr_22050_22132 = state_22042__$1;
(statearr_22050_22132[(2)] = inst_21920);

(statearr_22050_22132[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (39))){
var inst_21956 = (state_22042[(10)]);
var state_22042__$1 = state_22042;
var statearr_22051_22133 = state_22042__$1;
(statearr_22051_22133[(2)] = inst_21956);

(statearr_22051_22133[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (46))){
var inst_21921 = (state_22042[(11)]);
var state_22042__$1 = state_22042;
var statearr_22052_22134 = state_22042__$1;
(statearr_22052_22134[(2)] = inst_21921);

(statearr_22052_22134[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (4))){
var inst_21883 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22053_22135 = state_22042__$1;
(statearr_22053_22135[(2)] = inst_21883);

(statearr_22053_22135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (15))){
var inst_21932 = (state_22042[(12)]);
var inst_21938 = cljs.core.count(inst_21932);
var inst_21939 = fluree.db.query.fql_resp.add_fuel(fuel,inst_21938,max_fuel);
var state_22042__$1 = state_22042;
var statearr_22054_22136 = state_22042__$1;
(statearr_22054_22136[(2)] = inst_21939);

(statearr_22054_22136[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (48))){
var inst_22023 = (state_22042[(13)]);
var inst_21908 = (state_22042[(14)]);
var inst_21901 = (state_22042[(15)]);
var inst_22031 = (state_22042[(2)]);
var inst_22032 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21901,inst_22031,inst_22023);
var inst_21900 = inst_21908;
var inst_21901__$1 = inst_22032;
var state_22042__$1 = (function (){var statearr_22055 = state_22042;
(statearr_22055[(16)] = inst_21900);

(statearr_22055[(15)] = inst_21901__$1);

return statearr_22055;
})();
var statearr_22056_22137 = state_22042__$1;
(statearr_22056_22137[(2)] = null);

(statearr_22056_22137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (50))){
var inst_21923 = (state_22042[(17)]);
var state_22042__$1 = state_22042;
var statearr_22057_22138 = state_22042__$1;
(statearr_22057_22138[(2)] = inst_21923);

(statearr_22057_22138[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (21))){
var inst_21920 = (state_22042[(9)]);
var state_22042__$1 = state_22042;
if(cljs.core.truth_(inst_21920)){
var statearr_22059_22139 = state_22042__$1;
(statearr_22059_22139[(1)] = (23));

} else {
var statearr_22060_22140 = state_22042__$1;
(statearr_22060_22140[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (31))){
var inst_21980 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
if(cljs.core.truth_(inst_21980)){
var statearr_22061_22141 = state_22042__$1;
(statearr_22061_22141[(1)] = (32));

} else {
var statearr_22062_22142 = state_22042__$1;
(statearr_22062_22142[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (32))){
var inst_21956 = (state_22042[(10)]);
var inst_21955 = (state_22042[(18)]);
var inst_21963 = (state_22042[(19)]);
var inst_21982 = (inst_21955 + (1));
var tmp22058 = inst_21956;
var inst_21954 = inst_21963;
var inst_21955__$1 = inst_21982;
var inst_21956__$1 = tmp22058;
var state_22042__$1 = (function (){var statearr_22063 = state_22042;
(statearr_22063[(20)] = inst_21954);

(statearr_22063[(10)] = inst_21956__$1);

(statearr_22063[(18)] = inst_21955__$1);

return statearr_22063;
})();
var statearr_22064_22143 = state_22042__$1;
(statearr_22064_22143[(2)] = null);

(statearr_22064_22143[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (40))){
var state_22042__$1 = state_22042;
if(cljs.core.truth_(fuel)){
var statearr_22065_22144 = state_22042__$1;
(statearr_22065_22144[(1)] = (42));

} else {
var statearr_22066_22145 = state_22042__$1;
(statearr_22066_22145[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (33))){
var state_22042__$1 = state_22042;
var statearr_22067_22146 = state_22042__$1;
(statearr_22067_22146[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (13))){
var inst_21932 = (state_22042[(12)]);
var state_22042__$1 = state_22042;
var statearr_22069_22147 = state_22042__$1;
(statearr_22069_22147[(2)] = inst_21932);

(statearr_22069_22147[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (22))){
var inst_21973 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
if(cljs.core.truth_(inst_21973)){
var statearr_22070_22148 = state_22042__$1;
(statearr_22070_22148[(1)] = (26));

} else {
var statearr_22071_22149 = state_22042__$1;
(statearr_22071_22149[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (36))){
var state_22042__$1 = state_22042;
var statearr_22072_22150 = state_22042__$1;
(statearr_22072_22150[(2)] = null);

(statearr_22072_22150[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (41))){
var inst_21955 = (state_22042[(18)]);
var inst_21963 = (state_22042[(19)]);
var inst_22012 = (state_22042[(2)]);
var inst_22013 = (inst_21955 + (1));
var inst_21954 = inst_21963;
var inst_21955__$1 = inst_22013;
var inst_21956 = inst_22012;
var state_22042__$1 = (function (){var statearr_22073 = state_22042;
(statearr_22073[(20)] = inst_21954);

(statearr_22073[(10)] = inst_21956);

(statearr_22073[(18)] = inst_21955__$1);

return statearr_22073;
})();
var statearr_22074_22151 = state_22042__$1;
(statearr_22074_22151[(2)] = null);

(statearr_22074_22151[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (43))){
var state_22042__$1 = state_22042;
var statearr_22075_22152 = state_22042__$1;
(statearr_22075_22152[(2)] = null);

(statearr_22075_22152[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (29))){
var inst_21919 = (state_22042[(8)]);
var inst_21955 = (state_22042[(18)]);
var inst_21977 = (inst_21955 < inst_21919);
var state_22042__$1 = state_22042;
var statearr_22076_22153 = state_22042__$1;
(statearr_22076_22153[(2)] = inst_21977);

(statearr_22076_22153[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (44))){
var inst_21992 = (state_22042[(21)]);
var inst_21996 = (state_22042[(22)]);
var inst_22005 = (state_22042[(2)]);
var inst_22006 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_21996,inst_21992) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21996,inst_21992));
var state_22042__$1 = (function (){var statearr_22077 = state_22042;
(statearr_22077[(23)] = inst_22005);

return statearr_22077;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22042__$1,(45),inst_22006);
} else {
if((state_val_22043 === (6))){
var inst_21900 = (state_22042[(16)]);
var inst_21907 = (state_22042[(24)]);
var inst_21906 = cljs.core.seq(inst_21900);
var inst_21907__$1 = cljs.core.first(inst_21906);
var inst_21908 = cljs.core.next(inst_21906);
var inst_21909 = cljs.core.not(inst_21907__$1);
var state_22042__$1 = (function (){var statearr_22078 = state_22042;
(statearr_22078[(14)] = inst_21908);

(statearr_22078[(24)] = inst_21907__$1);

return statearr_22078;
})();
if(inst_21909){
var statearr_22079_22154 = state_22042__$1;
(statearr_22079_22154[(1)] = (8));

} else {
var statearr_22080_22155 = state_22042__$1;
(statearr_22080_22155[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (28))){
var inst_22021 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22081_22156 = state_22042__$1;
(statearr_22081_22156[(2)] = inst_22021);

(statearr_22081_22156[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (51))){
var inst_22029 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22082_22157 = state_22042__$1;
(statearr_22082_22157[(2)] = inst_22029);

(statearr_22082_22157[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (25))){
var inst_21971 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22083_22158 = state_22042__$1;
(statearr_22083_22158[(2)] = inst_21971);

(statearr_22083_22158[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (34))){
var inst_22019 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22084_22159 = state_22042__$1;
(statearr_22084_22159[(2)] = inst_22019);

(statearr_22084_22159[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (17))){
var inst_21932 = (state_22042[(12)]);
var inst_21942 = (state_22042[(2)]);
var inst_21950 = cljs.core.seq(inst_21932);
var inst_21951 = cljs.core.first(inst_21950);
var inst_21952 = cljs.core.next(inst_21950);
var inst_21953 = cljs.core.PersistentVector.EMPTY;
var inst_21954 = inst_21932;
var inst_21955 = (0);
var inst_21956 = inst_21953;
var state_22042__$1 = (function (){var statearr_22085 = state_22042;
(statearr_22085[(25)] = inst_21952);

(statearr_22085[(20)] = inst_21954);

(statearr_22085[(26)] = inst_21942);

(statearr_22085[(27)] = inst_21951);

(statearr_22085[(10)] = inst_21956);

(statearr_22085[(18)] = inst_21955);

return statearr_22085;
})();
var statearr_22086_22160 = state_22042__$1;
(statearr_22086_22160[(2)] = null);

(statearr_22086_22160[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (3))){
var inst_22040 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22042__$1,inst_22040);
} else {
if((state_val_22043 === (12))){
var state_22042__$1 = state_22042;
var statearr_22087_22161 = state_22042__$1;
(statearr_22087_22161[(2)] = fuel);

(statearr_22087_22161[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (2))){
var _ = (function (){var statearr_22088 = state_22042;
(statearr_22088[(4)] = cljs.core.cons((5),(state_22042[(4)])));

return statearr_22088;
})();
var inst_21896 = reverse_refs_specs;
var inst_21897 = cljs.core.seq(inst_21896);
var inst_21898 = cljs.core.first(inst_21897);
var inst_21899 = cljs.core.next(inst_21897);
var inst_21900 = inst_21896;
var inst_21901 = null;
var state_22042__$1 = (function (){var statearr_22089 = state_22042;
(statearr_22089[(16)] = inst_21900);

(statearr_22089[(15)] = inst_21901);

(statearr_22089[(28)] = inst_21898);

(statearr_22089[(29)] = inst_21899);

return statearr_22089;
})();
var statearr_22090_22162 = state_22042__$1;
(statearr_22090_22162[(2)] = null);

(statearr_22090_22162[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (23))){
var inst_21920 = (state_22042[(9)]);
var inst_21955 = (state_22042[(18)]);
var inst_21968 = (inst_21955 >= inst_21920);
var state_22042__$1 = state_22042;
var statearr_22091_22163 = state_22042__$1;
(statearr_22091_22163[(2)] = inst_21968);

(statearr_22091_22163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (47))){
var inst_21922 = (state_22042[(30)]);
var state_22042__$1 = state_22042;
if(cljs.core.truth_(inst_21922)){
var statearr_22092_22164 = state_22042__$1;
(statearr_22092_22164[(1)] = (49));

} else {
var statearr_22093_22165 = state_22042__$1;
(statearr_22093_22165[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (35))){
var inst_21962 = (state_22042[(31)]);
var inst_21986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21987 = [inst_21962];
var inst_21988 = (new cljs.core.PersistentVector(null,1,(5),inst_21986,inst_21987,null));
var inst_21989 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21988);
var state_22042__$1 = state_22042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22042__$1,(38),inst_21989);
} else {
if((state_val_22043 === (19))){
var inst_21921 = (state_22042[(11)]);
var inst_22023 = (state_22042[(2)]);
var state_22042__$1 = (function (){var statearr_22094 = state_22042;
(statearr_22094[(13)] = inst_22023);

return statearr_22094;
})();
if(cljs.core.truth_(inst_21921)){
var statearr_22095_22166 = state_22042__$1;
(statearr_22095_22166[(1)] = (46));

} else {
var statearr_22096_22167 = state_22042__$1;
(statearr_22096_22167[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (11))){
var inst_21932 = (state_22042[(12)]);
var inst_21929 = (state_22042[(2)]);
var inst_21930 = fluree.db.util.async.throw_err(inst_21929);
var inst_21931 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.s,inst_21930);
var inst_21932__$1 = cljs.core.not_empty(inst_21931);
var state_22042__$1 = (function (){var statearr_22098 = state_22042;
(statearr_22098[(12)] = inst_21932__$1);

return statearr_22098;
})();
if(cljs.core.truth_(inst_21932__$1)){
var statearr_22099_22168 = state_22042__$1;
(statearr_22099_22168[(1)] = (12));

} else {
var statearr_22100_22169 = state_22042__$1;
(statearr_22100_22169[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (9))){
var inst_21907 = (state_22042[(24)]);
var inst_21917 = (state_22042[(32)]);
var inst_21916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21907,(0),null);
var inst_21917__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21907,(1),null);
var inst_21918 = cljs.core.__destructure_map(inst_21917__$1);
var inst_21919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21918,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21918,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21921 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21918,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21922 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21918,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21918,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21925 = [subject_id,inst_21916];
var inst_21926 = (new cljs.core.PersistentVector(null,2,(5),inst_21924,inst_21925,null));
var inst_21927 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21926);
var state_22042__$1 = (function (){var statearr_22101 = state_22042;
(statearr_22101[(9)] = inst_21920);

(statearr_22101[(17)] = inst_21923);

(statearr_22101[(11)] = inst_21921);

(statearr_22101[(8)] = inst_21919);

(statearr_22101[(32)] = inst_21917__$1);

(statearr_22101[(30)] = inst_21922);

return statearr_22101;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22042__$1,(11),inst_21927);
} else {
if((state_val_22043 === (5))){
var _ = (function (){var statearr_22102 = state_22042;
(statearr_22102[(4)] = cljs.core.rest((state_22042[(4)])));

return statearr_22102;
})();
var state_22042__$1 = state_22042;
var ex22097 = (state_22042__$1[(2)]);
var statearr_22103_22170 = state_22042__$1;
(statearr_22103_22170[(5)] = ex22097);


if((ex22097 instanceof Error)){
var statearr_22104_22171 = state_22042__$1;
(statearr_22104_22171[(1)] = (4));

(statearr_22104_22171[(5)] = null);

} else {
throw ex22097;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (14))){
var inst_21936 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
if(cljs.core.truth_(inst_21936)){
var statearr_22105_22172 = state_22042__$1;
(statearr_22105_22172[(1)] = (15));

} else {
var statearr_22106_22173 = state_22042__$1;
(statearr_22106_22173[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (45))){
var inst_21956 = (state_22042[(10)]);
var inst_22008 = (state_22042[(2)]);
var inst_22009 = fluree.db.util.async.throw_err(inst_22008);
var inst_22010 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21956,inst_22009);
var state_22042__$1 = state_22042;
var statearr_22107_22174 = state_22042__$1;
(statearr_22107_22174[(2)] = inst_22010);

(statearr_22107_22174[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (26))){
var inst_21956 = (state_22042[(10)]);
var state_22042__$1 = state_22042;
var statearr_22108_22175 = state_22042__$1;
(statearr_22108_22175[(2)] = inst_21956);

(statearr_22108_22175[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (16))){
var state_22042__$1 = state_22042;
var statearr_22109_22176 = state_22042__$1;
(statearr_22109_22176[(2)] = null);

(statearr_22109_22176[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (38))){
var inst_21992 = (state_22042[(21)]);
var inst_21917 = (state_22042[(32)]);
var inst_21991 = (state_22042[(2)]);
var inst_21992__$1 = fluree.db.util.async.throw_err(inst_21991);
var inst_21993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21994 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21995 = (new cljs.core.PersistentVector(null,4,(5),inst_21993,inst_21994,null));
var inst_21996 = cljs.core.select_keys(inst_21917,inst_21995);
var inst_21997 = cljs.core.empty_QMARK_(inst_21992__$1);
var state_22042__$1 = (function (){var statearr_22110 = state_22042;
(statearr_22110[(21)] = inst_21992__$1);

(statearr_22110[(22)] = inst_21996);

return statearr_22110;
})();
if(inst_21997){
var statearr_22111_22177 = state_22042__$1;
(statearr_22111_22177[(1)] = (39));

} else {
var statearr_22112_22178 = state_22042__$1;
(statearr_22112_22178[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (30))){
var inst_21919 = (state_22042[(8)]);
var state_22042__$1 = state_22042;
var statearr_22113_22179 = state_22042__$1;
(statearr_22113_22179[(2)] = inst_21919);

(statearr_22113_22179[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (10))){
var inst_22035 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22114_22180 = state_22042__$1;
(statearr_22114_22180[(2)] = inst_22035);

(statearr_22114_22180[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (18))){
var inst_21962 = (state_22042[(31)]);
var inst_21954 = (state_22042[(20)]);
var inst_21964 = (state_22042[(7)]);
var inst_21961 = cljs.core.seq(inst_21954);
var inst_21962__$1 = cljs.core.first(inst_21961);
var inst_21963 = cljs.core.next(inst_21961);
var inst_21964__$1 = cljs.core.not(inst_21962__$1);
var state_22042__$1 = (function (){var statearr_22115 = state_22042;
(statearr_22115[(31)] = inst_21962__$1);

(statearr_22115[(7)] = inst_21964__$1);

(statearr_22115[(19)] = inst_21963);

return statearr_22115;
})();
if(inst_21964__$1){
var statearr_22116_22181 = state_22042__$1;
(statearr_22116_22181[(1)] = (20));

} else {
var statearr_22117_22182 = state_22042__$1;
(statearr_22117_22182[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (42))){
var inst_21992 = (state_22042[(21)]);
var inst_22001 = cljs.core.count(inst_21992);
var inst_22002 = fluree.db.query.fql_resp.add_fuel(fuel,inst_22001,max_fuel);
var state_22042__$1 = state_22042;
var statearr_22118_22183 = state_22042__$1;
(statearr_22118_22183[(2)] = inst_22002);

(statearr_22118_22183[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (37))){
var inst_22017 = (state_22042[(2)]);
var state_22042__$1 = state_22042;
var statearr_22119_22184 = state_22042__$1;
(statearr_22119_22184[(2)] = inst_22017);

(statearr_22119_22184[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (8))){
var inst_21901 = (state_22042[(15)]);
var state_22042__$1 = state_22042;
var statearr_22120_22185 = state_22042__$1;
(statearr_22120_22185[(2)] = inst_21901);

(statearr_22120_22185[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22043 === (49))){
var inst_21922 = (state_22042[(30)]);
var state_22042__$1 = state_22042;
var statearr_22121_22186 = state_22042__$1;
(statearr_22121_22186[(2)] = inst_21922);

(statearr_22121_22186[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0 = (function (){
var statearr_22122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22122[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__);

(statearr_22122[(1)] = (1));

return statearr_22122;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1 = (function (state_22042){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22042);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22123){var ex__2687__auto__ = e22123;
var statearr_22124_22187 = state_22042;
(statearr_22124_22187[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22042[(4)]))){
var statearr_22125_22188 = state_22042;
(statearr_22125_22188[(1)] = cljs.core.first((state_22042[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22189 = state_22042;
state_22042 = G__22189;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__ = function(state_22042){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1.call(this,state_22042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22126 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22126[(6)] = c__2706__auto__);

return statearr_22126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22191 = arguments.length;
switch (G__22191) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22193 = null;
var G__22193__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22193__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22193__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22193 = function(result,flake){
switch(arguments.length){
case 0:
return G__22193__0.call(this);
case 1:
return G__22193__1.call(this,result);
case 2:
return G__22193__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22193.cljs$core$IFn$_invoke$arity$0 = G__22193__0;
G__22193.cljs$core$IFn$_invoke$arity$1 = G__22193__1;
G__22193.cljs$core$IFn$_invoke$arity$2 = G__22193__2;
return G__22193;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o(flake);
var recur_pred = fluree.db.flake.p(flake);
var map__22194 = select_spec;
var map__22194__$1 = cljs.core.__destructure_map(map__22194);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22194__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22194__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22308){
var state_val_22309 = (state_22308[(1)]);
if((state_val_22309 === (7))){
var inst_22220 = flakes;
var inst_22221 = cljs.core.seq(inst_22220);
var inst_22222 = cljs.core.first(inst_22221);
var inst_22223 = cljs.core.next(inst_22221);
var inst_22224 = cljs.core.PersistentVector.EMPTY;
var inst_22225 = inst_22220;
var inst_22226 = (0);
var inst_22227 = inst_22224;
var state_22308__$1 = (function (){var statearr_22310 = state_22308;
(statearr_22310[(7)] = inst_22227);

(statearr_22310[(8)] = inst_22225);

(statearr_22310[(9)] = inst_22223);

(statearr_22310[(10)] = inst_22226);

(statearr_22310[(11)] = inst_22222);

return statearr_22310;
})();
var statearr_22311_22377 = state_22308__$1;
(statearr_22311_22377[(2)] = null);

(statearr_22311_22377[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (20))){
var state_22308__$1 = state_22308;
var statearr_22312_22378 = state_22308__$1;
(statearr_22312_22378[(2)] = results);

(statearr_22312_22378[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (27))){
var state_22308__$1 = state_22308;
var statearr_22313_22379 = state_22308__$1;
(statearr_22313_22379[(2)] = null);

(statearr_22313_22379[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (1))){
var state_22308__$1 = state_22308;
var statearr_22314_22380 = state_22308__$1;
(statearr_22314_22380[(2)] = null);

(statearr_22314_22380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (24))){
var state_22308__$1 = state_22308;
var statearr_22315_22381 = state_22308__$1;
(statearr_22315_22381[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (39))){
var inst_22227 = (state_22308[(7)]);
var inst_22234 = (state_22308[(12)]);
var inst_22289 = (state_22308[(13)]);
var inst_22292 = (state_22308[(2)]);
var inst_22293 = fluree.db.util.async.throw_err(inst_22292);
var inst_22294 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22227,inst_22293);
var inst_22225 = inst_22234;
var inst_22226 = inst_22289;
var inst_22227__$1 = inst_22294;
var state_22308__$1 = (function (){var statearr_22317 = state_22308;
(statearr_22317[(7)] = inst_22227__$1);

(statearr_22317[(8)] = inst_22225);

(statearr_22317[(10)] = inst_22226);

return statearr_22317;
})();
var statearr_22318_22382 = state_22308__$1;
(statearr_22318_22382[(2)] = null);

(statearr_22318_22382[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (4))){
var inst_22195 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22319_22383 = state_22308__$1;
(statearr_22319_22383[(2)] = inst_22195);

(statearr_22319_22383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (15))){
var inst_22208 = (state_22308[(14)]);
var state_22308__$1 = state_22308;
var statearr_22320_22384 = state_22308__$1;
(statearr_22320_22384[(2)] = inst_22208);

(statearr_22320_22384[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (21))){
var inst_22204 = (state_22308[(15)]);
var state_22308__$1 = state_22308;
if(cljs.core.truth_(inst_22204)){
var statearr_22321_22385 = state_22308__$1;
(statearr_22321_22385[(1)] = (23));

} else {
var statearr_22322_22386 = state_22308__$1;
(statearr_22322_22386[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (31))){
var inst_22272 = (state_22308[(16)]);
var state_22308__$1 = state_22308;
var statearr_22323_22387 = state_22308__$1;
(statearr_22323_22387[(2)] = inst_22272);

(statearr_22323_22387[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (32))){
var inst_22264 = (state_22308[(17)]);
var inst_22278 = (state_22308[(2)]);
var state_22308__$1 = (function (){var statearr_22324 = state_22308;
(statearr_22324[(18)] = inst_22278);

return statearr_22324;
})();
if(cljs.core.truth_(inst_22264)){
var statearr_22325_22388 = state_22308__$1;
(statearr_22325_22388[(1)] = (33));

} else {
var statearr_22326_22389 = state_22308__$1;
(statearr_22326_22389[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (33))){
var inst_22264 = (state_22308[(17)]);
var state_22308__$1 = state_22308;
var statearr_22327_22390 = state_22308__$1;
(statearr_22327_22390[(2)] = inst_22264);

(statearr_22327_22390[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (13))){
var inst_22244 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
if(cljs.core.truth_(inst_22244)){
var statearr_22329_22391 = state_22308__$1;
(statearr_22329_22391[(1)] = (17));

} else {
var statearr_22330_22392 = state_22308__$1;
(statearr_22330_22392[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (22))){
var inst_22261 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22331_22393 = state_22308__$1;
(statearr_22331_22393[(2)] = inst_22261);

(statearr_22331_22393[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (36))){
var inst_22227 = (state_22308[(7)]);
var inst_22234 = (state_22308[(12)]);
var inst_22226 = (state_22308[(10)]);
var inst_22286 = (inst_22226 + (1));
var tmp22328 = inst_22227;
var inst_22225 = inst_22234;
var inst_22226__$1 = inst_22286;
var inst_22227__$1 = tmp22328;
var state_22308__$1 = (function (){var statearr_22332 = state_22308;
(statearr_22332[(7)] = inst_22227__$1);

(statearr_22332[(8)] = inst_22225);

(statearr_22332[(10)] = inst_22226__$1);

return statearr_22332;
})();
var statearr_22333_22394 = state_22308__$1;
(statearr_22333_22394[(2)] = null);

(statearr_22333_22394[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (29))){
var inst_22271 = (state_22308[(2)]);
var inst_22272 = fluree.db.util.async.throw_err(inst_22271);
var state_22308__$1 = (function (){var statearr_22334 = state_22308;
(statearr_22334[(16)] = inst_22272);

return statearr_22334;
})();
if(cljs.core.truth_(fuel)){
var statearr_22335_22395 = state_22308__$1;
(statearr_22335_22395[(1)] = (30));

} else {
var statearr_22336_22396 = state_22308__$1;
(statearr_22336_22396[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (6))){
var state_22308__$1 = state_22308;
var statearr_22337_22397 = state_22308__$1;
(statearr_22337_22397[(2)] = results);

(statearr_22337_22397[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (28))){
var inst_22257 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22338_22398 = state_22308__$1;
(statearr_22338_22398[(2)] = inst_22257);

(statearr_22338_22398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (25))){
var inst_22259 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22339_22399 = state_22308__$1;
(statearr_22339_22399[(2)] = inst_22259);

(statearr_22339_22399[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (34))){
var inst_22278 = (state_22308[(18)]);
var inst_22281 = cljs.core.empty_QMARK_(inst_22278);
var state_22308__$1 = state_22308;
var statearr_22340_22400 = state_22308__$1;
(statearr_22340_22400[(2)] = inst_22281);

(statearr_22340_22400[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (17))){
var inst_22227 = (state_22308[(7)]);
var inst_22246 = cljs.core.empty_QMARK_(inst_22227);
var state_22308__$1 = state_22308;
if(inst_22246){
var statearr_22341_22401 = state_22308__$1;
(statearr_22341_22401[(1)] = (20));

} else {
var statearr_22342_22402 = state_22308__$1;
(statearr_22342_22402[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (3))){
var inst_22306 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22308__$1,inst_22306);
} else {
if((state_val_22309 === (12))){
var inst_22208 = (state_22308[(14)]);
var state_22308__$1 = state_22308;
if(cljs.core.truth_(inst_22208)){
var statearr_22343_22403 = state_22308__$1;
(statearr_22343_22403[(1)] = (14));

} else {
var statearr_22344_22404 = state_22308__$1;
(statearr_22344_22404[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (2))){
var _ = (function (){var statearr_22345 = state_22308;
(statearr_22345[(4)] = cljs.core.cons((5),(state_22308[(4)])));

return statearr_22345;
})();
var inst_22202 = select_spec;
var inst_22203 = cljs.core.__destructure_map(inst_22202);
var inst_22204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22203,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22203,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22203,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22207 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22203,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22208 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22203,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22209 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22210 = (inst_22207 > inst_22209);
var state_22308__$1 = (function (){var statearr_22346 = state_22308;
(statearr_22346[(19)] = inst_22206);

(statearr_22346[(15)] = inst_22204);

(statearr_22346[(14)] = inst_22208);

(statearr_22346[(20)] = inst_22205);

return statearr_22346;
})();
if(cljs.core.truth_(inst_22210)){
var statearr_22347_22405 = state_22308__$1;
(statearr_22347_22405[(1)] = (6));

} else {
var statearr_22348_22406 = state_22308__$1;
(statearr_22348_22406[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (23))){
var inst_22227 = (state_22308[(7)]);
var inst_22205 = (state_22308[(20)]);
var inst_22250 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_22205,inst_22227);
var state_22308__$1 = state_22308;
var statearr_22349_22407 = state_22308__$1;
(statearr_22349_22407[(2)] = inst_22250);

(statearr_22349_22407[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (35))){
var inst_22233 = (state_22308[(21)]);
var inst_22283 = (state_22308[(2)]);
var inst_22284 = fluree.db.query.fql_resp.recur_select_spec(select_spec,inst_22233);
var state_22308__$1 = (function (){var statearr_22350 = state_22308;
(statearr_22350[(22)] = inst_22284);

return statearr_22350;
})();
if(cljs.core.truth_(inst_22283)){
var statearr_22351_22408 = state_22308__$1;
(statearr_22351_22408[(1)] = (36));

} else {
var statearr_22352_22409 = state_22308__$1;
(statearr_22352_22409[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (19))){
var inst_22299 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22353_22410 = state_22308__$1;
(statearr_22353_22410[(2)] = inst_22299);

(statearr_22353_22410[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (11))){
var inst_22235 = (state_22308[(23)]);
var state_22308__$1 = state_22308;
var statearr_22355_22411 = state_22308__$1;
(statearr_22355_22411[(2)] = inst_22235);

(statearr_22355_22411[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (9))){
var inst_22233 = (state_22308[(21)]);
var inst_22235 = (state_22308[(23)]);
var inst_22225 = (state_22308[(8)]);
var inst_22232 = cljs.core.seq(inst_22225);
var inst_22233__$1 = cljs.core.first(inst_22232);
var inst_22234 = cljs.core.next(inst_22232);
var inst_22235__$1 = cljs.core.not(inst_22233__$1);
var state_22308__$1 = (function (){var statearr_22356 = state_22308;
(statearr_22356[(21)] = inst_22233__$1);

(statearr_22356[(23)] = inst_22235__$1);

(statearr_22356[(12)] = inst_22234);

return statearr_22356;
})();
if(inst_22235__$1){
var statearr_22357_22412 = state_22308__$1;
(statearr_22357_22412[(1)] = (11));

} else {
var statearr_22358_22413 = state_22308__$1;
(statearr_22358_22413[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (5))){
var _ = (function (){var statearr_22359 = state_22308;
(statearr_22359[(4)] = cljs.core.rest((state_22308[(4)])));

return statearr_22359;
})();
var state_22308__$1 = state_22308;
var ex22354 = (state_22308__$1[(2)]);
var statearr_22360_22414 = state_22308__$1;
(statearr_22360_22414[(5)] = ex22354);


if((ex22354 instanceof Error)){
var statearr_22361_22415 = state_22308__$1;
(statearr_22361_22415[(1)] = (4));

(statearr_22361_22415[(5)] = null);

} else {
throw ex22354;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (14))){
var inst_22208 = (state_22308[(14)]);
var inst_22226 = (state_22308[(10)]);
var inst_22239 = (inst_22226 < inst_22208);
var state_22308__$1 = state_22308;
var statearr_22362_22416 = state_22308__$1;
(statearr_22362_22416[(2)] = inst_22239);

(statearr_22362_22416[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (26))){
var inst_22227 = (state_22308[(7)]);
var inst_22205 = (state_22308[(20)]);
var inst_22253 = cljs.core.first(inst_22227);
var inst_22254 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_22205,inst_22253);
var state_22308__$1 = state_22308;
var statearr_22363_22417 = state_22308__$1;
(statearr_22363_22417[(2)] = inst_22254);

(statearr_22363_22417[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (16))){
var inst_22242 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22364_22418 = state_22308__$1;
(statearr_22364_22418[(2)] = inst_22242);

(statearr_22364_22418[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (38))){
var inst_22297 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22365_22419 = state_22308__$1;
(statearr_22365_22419[(2)] = inst_22297);

(statearr_22365_22419[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (30))){
var inst_22272 = (state_22308[(16)]);
var inst_22274 = fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_22275 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22274,inst_22272);
var state_22308__$1 = state_22308;
var statearr_22366_22420 = state_22308__$1;
(statearr_22366_22420[(2)] = inst_22275);

(statearr_22366_22420[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (10))){
var inst_22301 = (state_22308[(2)]);
var state_22308__$1 = state_22308;
var statearr_22367_22421 = state_22308__$1;
(statearr_22367_22421[(2)] = inst_22301);

(statearr_22367_22421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22309 === (18))){
var inst_22206 = (state_22308[(19)]);
var inst_22233 = (state_22308[(21)]);
var inst_22263 = fluree.db.flake.o(inst_22233);
var inst_22264 = cljs.core.contains_QMARK_(inst_22206,inst_22263);
var inst_22266 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22267 = [inst_22263];
var inst_22268 = (new cljs.core.PersistentVector(null,1,(5),inst_22266,inst_22267,null));
var inst_22269 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22268);
var state_22308__$1 = (function (){var statearr_22368 = state_22308;
(statearr_22368[(17)] = inst_22264);

return statearr_22368;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22308__$1,(29),inst_22269);
} else {
if((state_val_22309 === (37))){
var inst_22226 = (state_22308[(10)]);
var inst_22278 = (state_22308[(18)]);
var inst_22284 = (state_22308[(22)]);
var inst_22289 = (inst_22226 + (1));
var inst_22290 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22284,inst_22278) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22284,inst_22278));
var state_22308__$1 = (function (){var statearr_22369 = state_22308;
(statearr_22369[(13)] = inst_22289);

return statearr_22369;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22308__$1,(39),inst_22290);
} else {
if((state_val_22309 === (8))){
var inst_22303 = (state_22308[(2)]);
var _ = (function (){var statearr_22370 = state_22308;
(statearr_22370[(4)] = cljs.core.rest((state_22308[(4)])));

return statearr_22370;
})();
var state_22308__$1 = state_22308;
var statearr_22371_22422 = state_22308__$1;
(statearr_22371_22422[(2)] = inst_22303);

(statearr_22371_22422[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_22372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22372[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__);

(statearr_22372[(1)] = (1));

return statearr_22372;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1 = (function (state_22308){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22308);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e22373){var ex__2687__auto__ = e22373;
var statearr_22374_22423 = state_22308;
(statearr_22374_22423[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22308[(4)]))){
var statearr_22375_22424 = state_22308;
(statearr_22375_22424[(1)] = cljs.core.first((state_22308[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22425 = state_22308;
state_22308 = G__22425;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__ = function(state_22308){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1.call(this,state_22308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_22376 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_22376[(6)] = c__2706__auto__);

return statearr_22376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22429 = arguments.length;
switch (G__22429) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_22868){
var state_val_22869 = (state_22868[(1)]);
if((state_val_22869 === (121))){
var inst_22791 = (state_22868[(2)]);
var inst_22792 = fluree.db.util.async.throw_err(inst_22791);
var inst_22793 = cljs.core.seq(inst_22792);
var state_22868__$1 = state_22868;
if(inst_22793){
var statearr_22870_23084 = state_22868__$1;
(statearr_22870_23084[(1)] = (122));

} else {
var statearr_22871_23085 = state_22868__$1;
(statearr_22871_23085[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (65))){
var inst_22584 = (state_22868[(7)]);
var inst_22583 = (state_22868[(2)]);
var inst_22584__$1 = fluree.db.util.async.throw_err(inst_22583);
var inst_22585 = cljs.core.seq(inst_22584__$1);
var state_22868__$1 = (function (){var statearr_22872 = state_22868;
(statearr_22872[(7)] = inst_22584__$1);

return statearr_22872;
})();
if(inst_22585){
var statearr_22873_23086 = state_22868__$1;
(statearr_22873_23086[(1)] = (66));

} else {
var statearr_22874_23087 = state_22868__$1;
(statearr_22874_23087[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (70))){
var inst_22584 = (state_22868[(7)]);
var inst_22595 = cljs.core.count(inst_22584);
var inst_22596 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22595);
var state_22868__$1 = state_22868;
var statearr_22875_23088 = state_22868__$1;
(statearr_22875_23088[(2)] = inst_22596);

(statearr_22875_23088[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (62))){
var inst_22574 = (state_22868[(8)]);
var inst_22577 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22578 = fluree.db.flake.o(inst_22574);
var inst_22579 = [inst_22578];
var inst_22580 = (new cljs.core.PersistentVector(null,1,(5),inst_22577,inst_22579,null));
var inst_22581 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22580);
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22868__$1,(65),inst_22581);
} else {
if((state_val_22869 === (74))){
var inst_22568 = (state_22868[(9)]);
var state_22868__$1 = state_22868;
var statearr_22876_23089 = state_22868__$1;
(statearr_22876_23089[(2)] = inst_22568);

(statearr_22876_23089[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (110))){
var inst_22753 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22754 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22753);
var inst_22755 = inst_22754 === true;
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22755)){
var statearr_22877_23090 = state_22868__$1;
(statearr_22877_23090[(1)] = (113));

} else {
var statearr_22878_23091 = state_22868__$1;
(statearr_22878_23091[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (130))){
var inst_22863 = (state_22868[(2)]);
var _ = (function (){var statearr_22879 = state_22868;
(statearr_22879[(4)] = cljs.core.rest((state_22868[(4)])));

return statearr_22879;
})();
var state_22868__$1 = state_22868;
var statearr_22880_23092 = state_22868__$1;
(statearr_22880_23092[(2)] = inst_22863);

(statearr_22880_23092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (128))){
var inst_22838 = (state_22868[(10)]);
var inst_22841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22842 = [acc,inst_22838];
var inst_22843 = (new cljs.core.PersistentVector(null,2,(5),inst_22841,inst_22842,null));
var state_22868__$1 = state_22868;
var statearr_22881_23093 = state_22868__$1;
(statearr_22881_23093[(2)] = inst_22843);

(statearr_22881_23093[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (7))){
var inst_22441 = (state_22868[(11)]);
var state_22868__$1 = state_22868;
var statearr_22882_23094 = state_22868__$1;
(statearr_22882_23094[(2)] = inst_22441);

(statearr_22882_23094[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (59))){
var inst_22832 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22883_23095 = state_22868__$1;
(statearr_22883_23095[(2)] = inst_22832);

(statearr_22883_23095[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (86))){
var inst_22662 = (state_22868[(12)]);
var inst_22662__$1 = (state_22868[(2)]);
var state_22868__$1 = (function (){var statearr_22884 = state_22868;
(statearr_22884[(12)] = inst_22662__$1);

return statearr_22884;
})();
if(cljs.core.truth_(inst_22662__$1)){
var statearr_22885_23096 = state_22868__$1;
(statearr_22885_23096[(1)] = (88));

} else {
var statearr_22886_23097 = state_22868__$1;
(statearr_22886_23097[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (20))){
var inst_22482 = (state_22868[(13)]);
var inst_22483 = (state_22868[(14)]);
var inst_22470 = (state_22868[(15)]);
var inst_22481 = (state_22868[(2)]);
var inst_22482__$1 = cljs.core.__destructure_map(inst_22470);
var inst_22483__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22482__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22484 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22482__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22485 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22482__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22482__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22482__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22482__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22868__$1 = (function (){var statearr_22887 = state_22868;
(statearr_22887[(16)] = inst_22481);

(statearr_22887[(13)] = inst_22482__$1);

(statearr_22887[(14)] = inst_22483__$1);

(statearr_22887[(17)] = inst_22485);

(statearr_22887[(18)] = inst_22486);

(statearr_22887[(19)] = inst_22488);

(statearr_22887[(20)] = inst_22487);

(statearr_22887[(21)] = inst_22484);

return statearr_22887;
})();
if(cljs.core.truth_(inst_22483__$1)){
var statearr_22888_23098 = state_22868__$1;
(statearr_22888_23098[(1)] = (24));

} else {
var statearr_22889_23099 = state_22868__$1;
(statearr_22889_23099[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (72))){
var inst_22593 = (state_22868[(22)]);
var inst_22599 = (state_22868[(2)]);
var inst_22600 = cljs.core.seq(inst_22593);
var state_22868__$1 = (function (){var statearr_22890 = state_22868;
(statearr_22890[(23)] = inst_22599);

return statearr_22890;
})();
if(inst_22600){
var statearr_22891_23100 = state_22868__$1;
(statearr_22891_23100[(1)] = (73));

} else {
var statearr_22892_23101 = state_22868__$1;
(statearr_22892_23101[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (58))){
var inst_22470 = (state_22868[(15)]);
var inst_22615 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22470);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22615)){
var statearr_22893_23102 = state_22868__$1;
(statearr_22893_23102[(1)] = (76));

} else {
var statearr_22894_23103 = state_22868__$1;
(statearr_22894_23103[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (60))){
var inst_22567 = (state_22868[(24)]);
var inst_22574 = (state_22868[(8)]);
var inst_22573 = cljs.core.seq(inst_22567);
var inst_22574__$1 = cljs.core.first(inst_22573);
var inst_22575 = cljs.core.next(inst_22573);
var state_22868__$1 = (function (){var statearr_22895 = state_22868;
(statearr_22895[(8)] = inst_22574__$1);

(statearr_22895[(25)] = inst_22575);

return statearr_22895;
})();
if(cljs.core.truth_(inst_22574__$1)){
var statearr_22896_23104 = state_22868__$1;
(statearr_22896_23104[(1)] = (62));

} else {
var statearr_22897_23105 = state_22868__$1;
(statearr_22897_23105[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (27))){
var inst_22487 = (state_22868[(20)]);
var inst_22491 = (state_22868[(26)]);
var inst_22491__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22487);
var state_22868__$1 = (function (){var statearr_22898 = state_22868;
(statearr_22898[(26)] = inst_22491__$1);

return statearr_22898;
})();
if(inst_22491__$1){
var statearr_22899_23106 = state_22868__$1;
(statearr_22899_23106[(1)] = (30));

} else {
var statearr_22900_23107 = state_22868__$1;
(statearr_22900_23107[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (1))){
var state_22868__$1 = state_22868;
var statearr_22901_23108 = state_22868__$1;
(statearr_22901_23108[(2)] = null);

(statearr_22901_23108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (69))){
var inst_22589 = (state_22868[(2)]);
var inst_22590 = fluree.db.util.async.throw_err(inst_22589);
var state_22868__$1 = state_22868;
var statearr_22902_23109 = state_22868__$1;
(statearr_22902_23109[(2)] = inst_22590);

(statearr_22902_23109[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (101))){
var inst_22746 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22903_23110 = state_22868__$1;
(statearr_22903_23110[(2)] = inst_22746);

(statearr_22903_23110[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (24))){
var inst_22487 = (state_22868[(20)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22487)){
var statearr_22904_23111 = state_22868__$1;
(statearr_22904_23111[(1)] = (27));

} else {
var statearr_22905_23112 = state_22868__$1;
(statearr_22905_23112[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (102))){
var inst_22718 = (state_22868[(27)]);
var inst_22717 = (state_22868[(2)]);
var inst_22718__$1 = fluree.db.util.async.throw_err(inst_22717);
var inst_22719 = cljs.core.empty_QMARK_(inst_22718__$1);
var state_22868__$1 = (function (){var statearr_22906 = state_22868;
(statearr_22906[(27)] = inst_22718__$1);

return statearr_22906;
})();
if(inst_22719){
var statearr_22907_23113 = state_22868__$1;
(statearr_22907_23113[(1)] = (103));

} else {
var statearr_22908_23114 = state_22868__$1;
(statearr_22908_23114[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (135))){
var state_22868__$1 = state_22868;
var statearr_22909_23115 = state_22868__$1;
(statearr_22909_23115[(2)] = null);

(statearr_22909_23115[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (55))){
var inst_22470 = (state_22868[(15)]);
var inst_22543 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22470);
var state_22868__$1 = state_22868;
var statearr_22910_23116 = state_22868__$1;
(statearr_22910_23116[(2)] = inst_22543);

(statearr_22910_23116[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (85))){
var inst_22637 = (state_22868[(28)]);
var inst_22470 = (state_22868[(15)]);
var inst_22649 = fluree.db.flake.o(inst_22637);
var inst_22650 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22470);
var inst_22651 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22649,inst_22650);
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22868__$1,(87),inst_22651);
} else {
if((state_val_22869 === (39))){
var inst_22486 = (state_22868[(18)]);
var inst_22518 = (state_22868[(29)]);
var inst_22518__$1 = cljs.core.not(inst_22486);
var state_22868__$1 = (function (){var statearr_22911 = state_22868;
(statearr_22911[(29)] = inst_22518__$1);

return statearr_22911;
})();
if(inst_22518__$1){
var statearr_22912_23117 = state_22868__$1;
(statearr_22912_23117[(1)] = (42));

} else {
var statearr_22913_23118 = state_22868__$1;
(statearr_22913_23118[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (88))){
var inst_22631 = (state_22868[(30)]);
var inst_22662 = (state_22868[(12)]);
var inst_22664 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22631,inst_22662);
var state_22868__$1 = state_22868;
var statearr_22914_23119 = state_22868__$1;
(statearr_22914_23119[(2)] = inst_22664);

(statearr_22914_23119[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (46))){
var inst_22485 = (state_22868[(17)]);
var state_22868__$1 = state_22868;
var statearr_22915_23120 = state_22868__$1;
(statearr_22915_23120[(2)] = inst_22485);

(statearr_22915_23120[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (4))){
var inst_22430 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22916_23121 = state_22868__$1;
(statearr_22916_23121[(2)] = inst_22430);

(statearr_22916_23121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (77))){
var inst_22677 = (state_22868[(31)]);
var inst_22677__$1 = componentFollow_QMARK_;
var state_22868__$1 = (function (){var statearr_22917 = state_22868;
(statearr_22917[(31)] = inst_22677__$1);

return statearr_22917;
})();
if(cljs.core.truth_(inst_22677__$1)){
var statearr_22918_23122 = state_22868__$1;
(statearr_22918_23122[(1)] = (91));

} else {
var statearr_22919_23123 = state_22868__$1;
(statearr_22919_23123[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (106))){
var inst_22698 = (state_22868[(32)]);
var inst_22732 = (state_22868[(2)]);
var inst_22733 = fluree.db.util.async.throw_err(inst_22732);
var inst_22734 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22698,inst_22733);
var state_22868__$1 = state_22868;
var statearr_22920_23124 = state_22868__$1;
(statearr_22920_23124[(2)] = inst_22734);

(statearr_22920_23124[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (119))){
var inst_22776 = (state_22868[(33)]);
var inst_22806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22807 = [inst_22776,offset_map];
var inst_22808 = (new cljs.core.PersistentVector(null,2,(5),inst_22806,inst_22807,null));
var state_22868__$1 = state_22868;
var statearr_22921_23125 = state_22868__$1;
(statearr_22921_23125[(2)] = inst_22808);

(statearr_22921_23125[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (95))){
var inst_22484 = (state_22868[(21)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22484)){
var statearr_22922_23126 = state_22868__$1;
(statearr_22922_23126[(1)] = (110));

} else {
var statearr_22923_23127 = state_22868__$1;
(statearr_22923_23127[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (54))){
var inst_22540 = (state_22868[(34)]);
var state_22868__$1 = state_22868;
var statearr_22924_23128 = state_22868__$1;
(statearr_22924_23128[(2)] = inst_22540);

(statearr_22924_23128[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (92))){
var inst_22677 = (state_22868[(31)]);
var state_22868__$1 = state_22868;
var statearr_22925_23129 = state_22868__$1;
(statearr_22925_23129[(2)] = inst_22677);

(statearr_22925_23129[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (104))){
var inst_22718 = (state_22868[(27)]);
var inst_22440 = (state_22868[(35)]);
var inst_22727 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22728 = [true,inst_22440];
var inst_22729 = cljs.core.PersistentHashMap.fromArrays(inst_22727,inst_22728);
var inst_22730 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22729,inst_22718) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22729,inst_22718));
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22868__$1,(106),inst_22730);
} else {
if((state_val_22869 === (15))){
var inst_22463 = (state_22868[(36)]);
var inst_22440 = (state_22868[(35)]);
var inst_22467 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22463,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22440);
var state_22868__$1 = state_22868;
var statearr_22926_23130 = state_22868__$1;
(statearr_22926_23130[(2)] = inst_22467);

(statearr_22926_23130[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (48))){
var inst_22534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22535 = [null,offset_map];
var inst_22536 = (new cljs.core.PersistentVector(null,2,(5),inst_22534,inst_22535,null));
var state_22868__$1 = state_22868;
var statearr_22927_23131 = state_22868__$1;
(statearr_22927_23131[(2)] = inst_22536);

(statearr_22927_23131[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (50))){
var inst_22834 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22928_23132 = state_22868__$1;
(statearr_22928_23132[(2)] = inst_22834);

(statearr_22928_23132[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (116))){
var inst_22782 = (state_22868[(37)]);
var inst_22775 = (state_22868[(38)]);
var inst_22781 = cljs.core.seq(inst_22775);
var inst_22782__$1 = cljs.core.first(inst_22781);
var inst_22783 = cljs.core.next(inst_22781);
var state_22868__$1 = (function (){var statearr_22929 = state_22868;
(statearr_22929[(37)] = inst_22782__$1);

(statearr_22929[(39)] = inst_22783);

return statearr_22929;
})();
if(cljs.core.truth_(inst_22782__$1)){
var statearr_22930_23133 = state_22868__$1;
(statearr_22930_23133[(1)] = (118));

} else {
var statearr_22931_23134 = state_22868__$1;
(statearr_22931_23134[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (75))){
var inst_22575 = (state_22868[(25)]);
var inst_22605 = (state_22868[(2)]);
var inst_22567 = inst_22575;
var inst_22568 = inst_22605;
var state_22868__$1 = (function (){var statearr_22932 = state_22868;
(statearr_22932[(24)] = inst_22567);

(statearr_22932[(9)] = inst_22568);

return statearr_22932;
})();
var statearr_22933_23135 = state_22868__$1;
(statearr_22933_23135[(2)] = null);

(statearr_22933_23135[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (99))){
var inst_22704 = (state_22868[(40)]);
var inst_22470 = (state_22868[(15)]);
var inst_22707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22708 = fluree.db.flake.o(inst_22704);
var inst_22709 = [inst_22708];
var inst_22710 = (new cljs.core.PersistentVector(null,1,(5),inst_22707,inst_22709,null));
var inst_22711 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22712 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22470);
var inst_22713 = [inst_22712];
var inst_22714 = cljs.core.PersistentHashMap.fromArrays(inst_22711,inst_22713);
var inst_22715 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22710,inst_22714);
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22868__$1,(102),inst_22715);
} else {
if((state_val_22869 === (21))){
var inst_22474 = (state_22868[(41)]);
var state_22868__$1 = state_22868;
var statearr_22934_23136 = state_22868__$1;
(statearr_22934_23136[(2)] = inst_22474);

(statearr_22934_23136[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (31))){
var inst_22491 = (state_22868[(26)]);
var state_22868__$1 = state_22868;
var statearr_22935_23137 = state_22868__$1;
(statearr_22935_23137[(2)] = inst_22491);

(statearr_22935_23137[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (113))){
var inst_22481 = (state_22868[(16)]);
var inst_22482 = (state_22868[(13)]);
var inst_22483 = (state_22868[(14)]);
var inst_22485 = (state_22868[(17)]);
var inst_22486 = (state_22868[(18)]);
var inst_22488 = (state_22868[(19)]);
var inst_22440 = (state_22868[(35)]);
var inst_22487 = (state_22868[(20)]);
var inst_22470 = (state_22868[(15)]);
var inst_22455 = (state_22868[(42)]);
var inst_22484 = (state_22868[(21)]);
var inst_22757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22758 = (function (){var p = inst_22488;
var pred_spec__$1 = inst_22455;
var orderBy = inst_22486;
var multi_QMARK_ = inst_22483;
var limit = inst_22485;
var offset = inst_22487;
var map__22436 = inst_22482;
var k = inst_22481;
var compact_QMARK_ = inst_22440;
var pred_spec_SINGLEQUOTE_ = inst_22470;
var ref_QMARK_ = inst_22484;
return (function (p1__22426_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o(p1__22426_SHARP_)]);
});
})();
var inst_22759 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22758,flakes);
var inst_22760 = [inst_22759,offset_map];
var inst_22761 = (new cljs.core.PersistentVector(null,2,(5),inst_22757,inst_22760,null));
var state_22868__$1 = state_22868;
var statearr_22936_23138 = state_22868__$1;
(statearr_22936_23138[(2)] = inst_22761);

(statearr_22936_23138[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (32))){
var inst_22497 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22937_23139 = state_22868__$1;
(statearr_22937_23139[(2)] = inst_22497);

(statearr_22937_23139[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (136))){
var inst_22859 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22938_23140 = state_22868__$1;
(statearr_22938_23140[(2)] = inst_22859);

(statearr_22938_23140[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (40))){
var inst_22483 = (state_22868[(14)]);
var state_22868__$1 = state_22868;
var statearr_22939_23141 = state_22868__$1;
(statearr_22939_23141[(2)] = inst_22483);

(statearr_22939_23141[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (129))){
var inst_22483 = (state_22868[(14)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22483)){
var statearr_22940_23142 = state_22868__$1;
(statearr_22940_23142[(1)] = (131));

} else {
var statearr_22941_23143 = state_22868__$1;
(statearr_22941_23143[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (91))){
var inst_22470 = (state_22868[(15)]);
var inst_22679 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22470);
var state_22868__$1 = state_22868;
var statearr_22942_23144 = state_22868__$1;
(statearr_22942_23144[(2)] = inst_22679);

(statearr_22942_23144[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (117))){
var inst_22812 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22943_23145 = state_22868__$1;
(statearr_22943_23145[(2)] = inst_22812);

(statearr_22943_23145[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (108))){
var state_22868__$1 = state_22868;
var statearr_22944_23146 = state_22868__$1;
(statearr_22944_23146[(2)] = null);

(statearr_22944_23146[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (56))){
var inst_22545 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22945_23147 = state_22868__$1;
(statearr_22945_23147[(2)] = inst_22545);

(statearr_22945_23147[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (33))){
var inst_22488 = (state_22868[(19)]);
var inst_22505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22506 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22488);
var state_22868__$1 = (function (){var statearr_22946 = state_22868;
(statearr_22946[(43)] = inst_22505);

return statearr_22946;
})();
if(cljs.core.truth_(inst_22506)){
var statearr_22947_23148 = state_22868__$1;
(statearr_22947_23148[(1)] = (36));

} else {
var statearr_22948_23149 = state_22868__$1;
(statearr_22948_23149[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (13))){
var inst_22455 = (state_22868[(42)]);
var state_22868__$1 = state_22868;
var statearr_22949_23150 = state_22868__$1;
(statearr_22949_23150[(2)] = inst_22455);

(statearr_22949_23150[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (22))){
var inst_22470 = (state_22868[(15)]);
var inst_22477 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22470);
var state_22868__$1 = state_22868;
var statearr_22950_23151 = state_22868__$1;
(statearr_22950_23151[(2)] = inst_22477);

(statearr_22950_23151[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (90))){
var inst_22638 = (state_22868[(44)]);
var inst_22667 = (state_22868[(2)]);
var inst_22630 = inst_22638;
var inst_22631 = inst_22667;
var state_22868__$1 = (function (){var statearr_22951 = state_22868;
(statearr_22951[(30)] = inst_22631);

(statearr_22951[(45)] = inst_22630);

return statearr_22951;
})();
var statearr_22952_23152 = state_22868__$1;
(statearr_22952_23152[(2)] = null);

(statearr_22952_23152[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (109))){
var inst_22705 = (state_22868[(46)]);
var inst_22736 = (state_22868[(47)]);
var inst_22742 = (state_22868[(2)]);
var inst_22697 = inst_22705;
var inst_22698 = inst_22736;
var state_22868__$1 = (function (){var statearr_22953 = state_22868;
(statearr_22953[(48)] = inst_22742);

(statearr_22953[(49)] = inst_22697);

(statearr_22953[(32)] = inst_22698);

return statearr_22953;
})();
var statearr_22954_23153 = state_22868__$1;
(statearr_22954_23153[(2)] = null);

(statearr_22954_23153[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (36))){
var inst_22488 = (state_22868[(19)]);
var inst_22508 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22488,cljs.core.dec);
var state_22868__$1 = state_22868;
var statearr_22955_23154 = state_22868__$1;
(statearr_22955_23154[(2)] = inst_22508);

(statearr_22955_23154[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (41))){
var inst_22532 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22532)){
var statearr_22956_23155 = state_22868__$1;
(statearr_22956_23155[(1)] = (48));

} else {
var statearr_22957_23156 = state_22868__$1;
(statearr_22957_23156[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (118))){
var inst_22782 = (state_22868[(37)]);
var inst_22785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22786 = fluree.db.flake.o(inst_22782);
var inst_22787 = [inst_22786];
var inst_22788 = (new cljs.core.PersistentVector(null,1,(5),inst_22785,inst_22787,null));
var inst_22789 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22788);
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22868__$1,(121),inst_22789);
} else {
if((state_val_22869 === (89))){
var inst_22631 = (state_22868[(30)]);
var state_22868__$1 = state_22868;
var statearr_22958_23157 = state_22868__$1;
(statearr_22958_23157[(2)] = inst_22631);

(statearr_22958_23157[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (100))){
var inst_22698 = (state_22868[(32)]);
var state_22868__$1 = state_22868;
var statearr_22959_23158 = state_22868__$1;
(statearr_22959_23158[(2)] = inst_22698);

(statearr_22959_23158[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (131))){
var inst_22481 = (state_22868[(16)]);
var inst_22838 = (state_22868[(10)]);
var inst_22837 = (state_22868[(50)]);
var inst_22846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22847 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22481,inst_22837);
var inst_22848 = [inst_22847,inst_22838];
var inst_22849 = (new cljs.core.PersistentVector(null,2,(5),inst_22846,inst_22848,null));
var state_22868__$1 = state_22868;
var statearr_22960_23159 = state_22868__$1;
(statearr_22960_23159[(2)] = inst_22849);

(statearr_22960_23159[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (122))){
var inst_22782 = (state_22868[(37)]);
var inst_22783 = (state_22868[(39)]);
var inst_22776 = (state_22868[(33)]);
var inst_22795 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22796 = fluree.db.flake.o(inst_22782);
var inst_22797 = [inst_22796];
var inst_22798 = cljs.core.PersistentHashMap.fromArrays(inst_22795,inst_22797);
var inst_22799 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22776,inst_22798);
var inst_22775 = inst_22783;
var inst_22776__$1 = inst_22799;
var state_22868__$1 = (function (){var statearr_22961 = state_22868;
(statearr_22961[(38)] = inst_22775);

(statearr_22961[(33)] = inst_22776__$1);

return statearr_22961;
})();
var statearr_22962_23160 = state_22868__$1;
(statearr_22962_23160[(2)] = null);

(statearr_22962_23160[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (43))){
var inst_22518 = (state_22868[(29)]);
var state_22868__$1 = state_22868;
var statearr_22963_23161 = state_22868__$1;
(statearr_22963_23161[(2)] = inst_22518);

(statearr_22963_23161[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (61))){
var inst_22554 = (state_22868[(51)]);
var inst_22611 = (state_22868[(2)]);
var inst_22612 = [inst_22611,offset_map];
var inst_22613 = (new cljs.core.PersistentVector(null,2,(5),inst_22554,inst_22612,null));
var state_22868__$1 = state_22868;
var statearr_22964_23162 = state_22868__$1;
(statearr_22964_23162[(2)] = inst_22613);

(statearr_22964_23162[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (29))){
var inst_22500 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22965_23163 = state_22868__$1;
(statearr_22965_23163[(2)] = inst_22500);

(statearr_22965_23163[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (44))){
var inst_22529 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22966_23164 = state_22868__$1;
(statearr_22966_23164[(2)] = inst_22529);

(statearr_22966_23164[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (93))){
var inst_22682 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22682)){
var statearr_22967_23165 = state_22868__$1;
(statearr_22967_23165[(1)] = (94));

} else {
var statearr_22968_23166 = state_22868__$1;
(statearr_22968_23166[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (6))){
var inst_22443 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22444 = (inst_22443 == null);
var state_22868__$1 = state_22868;
var statearr_22969_23167 = state_22868__$1;
(statearr_22969_23167[(2)] = inst_22444);

(statearr_22969_23167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (111))){
var state_22868__$1 = state_22868;
var statearr_22970_23168 = state_22868__$1;
(statearr_22970_23168[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (28))){
var inst_22487 = (state_22868[(20)]);
var state_22868__$1 = state_22868;
var statearr_22972_23169 = state_22868__$1;
(statearr_22972_23169[(2)] = inst_22487);

(statearr_22972_23169[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (134))){
var inst_22481 = (state_22868[(16)]);
var inst_22838 = (state_22868[(10)]);
var inst_22837 = (state_22868[(50)]);
var inst_22852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22853 = cljs.core.first(inst_22837);
var inst_22854 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22481,inst_22853);
var inst_22855 = [inst_22854,inst_22838];
var inst_22856 = (new cljs.core.PersistentVector(null,2,(5),inst_22852,inst_22855,null));
var state_22868__$1 = state_22868;
var statearr_22973_23170 = state_22868__$1;
(statearr_22973_23170[(2)] = inst_22856);

(statearr_22973_23170[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (64))){
var inst_22609 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22974_23171 = state_22868__$1;
(statearr_22974_23171[(2)] = inst_22609);

(statearr_22974_23171[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (103))){
var inst_22704 = (state_22868[(40)]);
var inst_22698 = (state_22868[(32)]);
var inst_22721 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22722 = fluree.db.flake.o(inst_22704);
var inst_22723 = [inst_22722];
var inst_22724 = cljs.core.PersistentHashMap.fromArrays(inst_22721,inst_22723);
var inst_22725 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22698,inst_22724);
var state_22868__$1 = state_22868;
var statearr_22975_23172 = state_22868__$1;
(statearr_22975_23172[(2)] = inst_22725);

(statearr_22975_23172[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (51))){
var inst_22470 = (state_22868[(15)]);
var inst_22540 = (state_22868[(34)]);
var inst_22540__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22470);
var state_22868__$1 = (function (){var statearr_22976 = state_22868;
(statearr_22976[(34)] = inst_22540__$1);

return statearr_22976;
})();
if(cljs.core.truth_(inst_22540__$1)){
var statearr_22977_23173 = state_22868__$1;
(statearr_22977_23173[(1)] = (54));

} else {
var statearr_22978_23174 = state_22868__$1;
(statearr_22978_23174[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (25))){
var inst_22483 = (state_22868[(14)]);
var state_22868__$1 = state_22868;
var statearr_22979_23175 = state_22868__$1;
(statearr_22979_23175[(2)] = inst_22483);

(statearr_22979_23175[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (34))){
var inst_22483 = (state_22868[(14)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22483)){
var statearr_22980_23176 = state_22868__$1;
(statearr_22980_23176[(1)] = (39));

} else {
var statearr_22981_23177 = state_22868__$1;
(statearr_22981_23177[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (125))){
var inst_22481 = (state_22868[(16)]);
var inst_22482 = (state_22868[(13)]);
var inst_22483 = (state_22868[(14)]);
var inst_22485 = (state_22868[(17)]);
var inst_22486 = (state_22868[(18)]);
var inst_22488 = (state_22868[(19)]);
var inst_22440 = (state_22868[(35)]);
var inst_22487 = (state_22868[(20)]);
var inst_22470 = (state_22868[(15)]);
var inst_22455 = (state_22868[(42)]);
var inst_22484 = (state_22868[(21)]);
var inst_22817 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22818 = (function (){var p = inst_22488;
var pred_spec__$1 = inst_22455;
var orderBy = inst_22486;
var multi_QMARK_ = inst_22483;
var limit = inst_22485;
var offset = inst_22487;
var map__22436 = inst_22482;
var k = inst_22481;
var compact_QMARK_ = inst_22440;
var pred_spec_SINGLEQUOTE_ = inst_22470;
var ref_QMARK_ = inst_22484;
return (function (p1__22427_SHARP_){
return fluree.db.flake.o(p1__22427_SHARP_);
});
})();
var inst_22819 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22818,flakes);
var inst_22820 = [inst_22819,offset_map];
var inst_22821 = (new cljs.core.PersistentVector(null,2,(5),inst_22817,inst_22820,null));
var state_22868__$1 = state_22868;
var statearr_22982_23178 = state_22868__$1;
(statearr_22982_23178[(2)] = inst_22821);

(statearr_22982_23178[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (17))){
var inst_22471 = (state_22868[(52)]);
var inst_22470 = (state_22868[(15)]);
var inst_22470__$1 = (state_22868[(2)]);
var inst_22471__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22470__$1);
var state_22868__$1 = (function (){var statearr_22983 = state_22868;
(statearr_22983[(52)] = inst_22471__$1);

(statearr_22983[(15)] = inst_22470__$1);

return statearr_22983;
})();
if(cljs.core.truth_(inst_22471__$1)){
var statearr_22984_23179 = state_22868__$1;
(statearr_22984_23179[(1)] = (18));

} else {
var statearr_22985_23180 = state_22868__$1;
(statearr_22985_23180[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (3))){
var inst_22866 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22868__$1,inst_22866);
} else {
if((state_val_22869 === (12))){
var inst_22455 = (state_22868[(42)]);
var inst_22460 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22455,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22868__$1 = state_22868;
var statearr_22986_23181 = state_22868__$1;
(statearr_22986_23181[(2)] = inst_22460);

(statearr_22986_23181[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (2))){
var inst_22441 = (state_22868[(11)]);
var _ = (function (){var statearr_22987 = state_22868;
(statearr_22987[(4)] = cljs.core.cons((5),(state_22868[(4)])));

return statearr_22987;
})();
var inst_22440 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22441__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22868__$1 = (function (){var statearr_22988 = state_22868;
(statearr_22988[(35)] = inst_22440);

(statearr_22988[(11)] = inst_22441__$1);

return statearr_22988;
})();
if(cljs.core.truth_(inst_22441__$1)){
var statearr_22989_23182 = state_22868__$1;
(statearr_22989_23182[(1)] = (6));

} else {
var statearr_22990_23183 = state_22868__$1;
(statearr_22990_23183[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (66))){
var inst_22553 = (state_22868[(53)]);
var inst_22584 = (state_22868[(7)]);
var inst_22587 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22553,inst_22584) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22553,inst_22584));
var state_22868__$1 = state_22868;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22868__$1,(69),inst_22587);
} else {
if((state_val_22869 === (107))){
var inst_22718 = (state_22868[(27)]);
var inst_22738 = cljs.core.count(inst_22718);
var inst_22739 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22738);
var state_22868__$1 = state_22868;
var statearr_22991_23184 = state_22868__$1;
(statearr_22991_23184[(2)] = inst_22739);

(statearr_22991_23184[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (23))){
var inst_22479 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22992_23185 = state_22868__$1;
(statearr_22992_23185[(2)] = inst_22479);

(statearr_22992_23185[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (47))){
var inst_22526 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22993_23186 = state_22868__$1;
(statearr_22993_23186[(2)] = inst_22526);

(statearr_22993_23186[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (35))){
var inst_22837 = (state_22868[(50)]);
var inst_22836 = (state_22868[(2)]);
var inst_22837__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22836,(0),null);
var inst_22838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22836,(1),null);
var inst_22839 = cljs.core.empty_QMARK_(inst_22837__$1);
var state_22868__$1 = (function (){var statearr_22994 = state_22868;
(statearr_22994[(10)] = inst_22838);

(statearr_22994[(50)] = inst_22837__$1);

return statearr_22994;
})();
if(inst_22839){
var statearr_22995_23187 = state_22868__$1;
(statearr_22995_23187[(1)] = (128));

} else {
var statearr_22996_23188 = state_22868__$1;
(statearr_22996_23188[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (127))){
var inst_22824 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_22997_23189 = state_22868__$1;
(statearr_22997_23189[(2)] = inst_22824);

(statearr_22997_23189[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (82))){
var inst_22631 = (state_22868[(30)]);
var state_22868__$1 = state_22868;
var statearr_22998_23190 = state_22868__$1;
(statearr_22998_23190[(2)] = inst_22631);

(statearr_22998_23190[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (76))){
var inst_22617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22625 = flakes;
var inst_22626 = cljs.core.seq(inst_22625);
var inst_22627 = cljs.core.first(inst_22626);
var inst_22628 = cljs.core.next(inst_22626);
var inst_22629 = cljs.core.PersistentVector.EMPTY;
var inst_22630 = inst_22625;
var inst_22631 = inst_22629;
var state_22868__$1 = (function (){var statearr_22999 = state_22868;
(statearr_22999[(54)] = inst_22617);

(statearr_22999[(55)] = inst_22627);

(statearr_22999[(30)] = inst_22631);

(statearr_22999[(56)] = inst_22628);

(statearr_22999[(45)] = inst_22630);

return statearr_22999;
})();
var statearr_23000_23191 = state_22868__$1;
(statearr_23000_23191[(2)] = null);

(statearr_23000_23191[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (97))){
var inst_22704 = (state_22868[(40)]);
var inst_22697 = (state_22868[(49)]);
var inst_22703 = cljs.core.seq(inst_22697);
var inst_22704__$1 = cljs.core.first(inst_22703);
var inst_22705 = cljs.core.next(inst_22703);
var state_22868__$1 = (function (){var statearr_23001 = state_22868;
(statearr_23001[(40)] = inst_22704__$1);

(statearr_23001[(46)] = inst_22705);

return statearr_23001;
})();
if(cljs.core.truth_(inst_22704__$1)){
var statearr_23002_23192 = state_22868__$1;
(statearr_23002_23192[(1)] = (99));

} else {
var statearr_23003_23193 = state_22868__$1;
(statearr_23003_23193[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (19))){
var inst_22474 = (state_22868[(41)]);
var inst_22470 = (state_22868[(15)]);
var inst_22474__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22470);
var state_22868__$1 = (function (){var statearr_23004 = state_22868;
(statearr_23004[(41)] = inst_22474__$1);

return statearr_23004;
})();
if(cljs.core.truth_(inst_22474__$1)){
var statearr_23005_23194 = state_22868__$1;
(statearr_23005_23194[(1)] = (21));

} else {
var statearr_23006_23195 = state_22868__$1;
(statearr_23006_23195[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (57))){
var inst_22470 = (state_22868[(15)]);
var inst_22550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22551 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22552 = (new cljs.core.PersistentVector(null,3,(5),inst_22550,inst_22551,null));
var inst_22553 = cljs.core.select_keys(inst_22470,inst_22552);
var inst_22554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22562 = flakes;
var inst_22563 = cljs.core.seq(inst_22562);
var inst_22564 = cljs.core.first(inst_22563);
var inst_22565 = cljs.core.next(inst_22563);
var inst_22566 = cljs.core.PersistentVector.EMPTY;
var inst_22567 = inst_22562;
var inst_22568 = inst_22566;
var state_22868__$1 = (function (){var statearr_23007 = state_22868;
(statearr_23007[(57)] = inst_22565);

(statearr_23007[(58)] = inst_22564);

(statearr_23007[(24)] = inst_22567);

(statearr_23007[(53)] = inst_22553);

(statearr_23007[(9)] = inst_22568);

(statearr_23007[(51)] = inst_22554);

return statearr_23007;
})();
var statearr_23008_23196 = state_22868__$1;
(statearr_23008_23196[(2)] = null);

(statearr_23008_23196[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (68))){
var inst_22593 = (state_22868[(2)]);
var state_22868__$1 = (function (){var statearr_23009 = state_22868;
(statearr_23009[(22)] = inst_22593);

return statearr_23009;
})();
if(cljs.core.truth_(fuel)){
var statearr_23010_23197 = state_22868__$1;
(statearr_23010_23197[(1)] = (70));

} else {
var statearr_23011_23198 = state_22868__$1;
(statearr_23011_23198[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (11))){
var inst_22455 = (state_22868[(42)]);
var inst_22455__$1 = (state_22868[(2)]);
var inst_22457 = cljs.core.contains_QMARK_(inst_22455__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22458 = (!(inst_22457));
var state_22868__$1 = (function (){var statearr_23012 = state_22868;
(statearr_23012[(42)] = inst_22455__$1);

return statearr_23012;
})();
if(inst_22458){
var statearr_23013_23199 = state_22868__$1;
(statearr_23013_23199[(1)] = (12));

} else {
var statearr_23014_23200 = state_22868__$1;
(statearr_23014_23200[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (115))){
var inst_22814 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23016_23201 = state_22868__$1;
(statearr_23016_23201[(2)] = inst_22814);

(statearr_23016_23201[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (9))){
var inst_22449 = cljs.core.first(flakes);
var inst_22450 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22449);
var inst_22451 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22452 = fluree.db.query.fql_resp.wildcard_pred_spec(db,cache,inst_22450,inst_22451);
var state_22868__$1 = state_22868;
var statearr_23017_23202 = state_22868__$1;
(statearr_23017_23202[(2)] = inst_22452);

(statearr_23017_23202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (5))){
var _ = (function (){var statearr_23018 = state_22868;
(statearr_23018[(4)] = cljs.core.rest((state_22868[(4)])));

return statearr_23018;
})();
var state_22868__$1 = state_22868;
var ex23015 = (state_22868__$1[(2)]);
var statearr_23019_23203 = state_22868__$1;
(statearr_23019_23203[(5)] = ex23015);


if((ex23015 instanceof Error)){
var statearr_23020_23204 = state_22868__$1;
(statearr_23020_23204[(1)] = (4));

(statearr_23020_23204[(5)] = null);

} else {
throw ex23015;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (112))){
var inst_22826 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23021_23205 = state_22868__$1;
(statearr_23021_23205[(2)] = inst_22826);

(statearr_23021_23205[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (83))){
var inst_22671 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23022_23206 = state_22868__$1;
(statearr_23022_23206[(2)] = inst_22671);

(statearr_23022_23206[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (14))){
var inst_22455 = (state_22868[(42)]);
var inst_22463 = (state_22868[(2)]);
var inst_22464 = cljs.core.contains_QMARK_(inst_22455,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22465 = (!(inst_22464));
var state_22868__$1 = (function (){var statearr_23023 = state_22868;
(statearr_23023[(36)] = inst_22463);

return statearr_23023;
})();
if(inst_22465){
var statearr_23024_23207 = state_22868__$1;
(statearr_23024_23207[(1)] = (15));

} else {
var statearr_23025_23208 = state_22868__$1;
(statearr_23025_23208[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (45))){
var inst_22481 = (state_22868[(16)]);
var inst_22485 = (state_22868[(17)]);
var inst_22521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22481);
var inst_22522 = cljs.core.count(inst_22521);
var inst_22523 = (inst_22522 >= inst_22485);
var state_22868__$1 = state_22868;
var statearr_23026_23209 = state_22868__$1;
(statearr_23026_23209[(2)] = inst_22523);

(statearr_23026_23209[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (53))){
var inst_22548 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22548)){
var statearr_23027_23210 = state_22868__$1;
(statearr_23027_23210[(1)] = (57));

} else {
var statearr_23028_23211 = state_22868__$1;
(statearr_23028_23211[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (78))){
var inst_22830 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23029_23212 = state_22868__$1;
(statearr_23029_23212[(2)] = inst_22830);

(statearr_23029_23212[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (132))){
var state_22868__$1 = state_22868;
var statearr_23031_23213 = state_22868__$1;
(statearr_23031_23213[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (26))){
var inst_22503 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22503)){
var statearr_23033_23214 = state_22868__$1;
(statearr_23033_23214[(1)] = (33));

} else {
var statearr_23034_23215 = state_22868__$1;
(statearr_23034_23215[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (123))){
var inst_22783 = (state_22868[(39)]);
var inst_22776 = (state_22868[(33)]);
var tmp23030 = inst_22776;
var inst_22775 = inst_22783;
var inst_22776__$1 = tmp23030;
var state_22868__$1 = (function (){var statearr_23035 = state_22868;
(statearr_23035[(38)] = inst_22775);

(statearr_23035[(33)] = inst_22776__$1);

return statearr_23035;
})();
var statearr_23036_23216 = state_22868__$1;
(statearr_23036_23216[(2)] = null);

(statearr_23036_23216[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (16))){
var inst_22463 = (state_22868[(36)]);
var state_22868__$1 = state_22868;
var statearr_23037_23217 = state_22868__$1;
(statearr_23037_23217[(2)] = inst_22463);

(statearr_23037_23217[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (133))){
var inst_22861 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23038_23218 = state_22868__$1;
(statearr_23038_23218[(2)] = inst_22861);

(statearr_23038_23218[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (81))){
var inst_22646 = (state_22868[(59)]);
var inst_22637 = (state_22868[(28)]);
var inst_22470 = (state_22868[(15)]);
var inst_22640 = cljs.core.deref(cache);
var inst_22641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22642 = fluree.db.flake.o(inst_22637);
var inst_22643 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22470);
var inst_22644 = [inst_22642,inst_22643];
var inst_22645 = (new cljs.core.PersistentVector(null,2,(5),inst_22641,inst_22644,null));
var inst_22646__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22640,inst_22645);
var state_22868__$1 = (function (){var statearr_23039 = state_22868;
(statearr_23039[(59)] = inst_22646__$1);

return statearr_23039;
})();
if(cljs.core.truth_(inst_22646__$1)){
var statearr_23040_23219 = state_22868__$1;
(statearr_23040_23219[(1)] = (84));

} else {
var statearr_23041_23220 = state_22868__$1;
(statearr_23041_23220[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (120))){
var inst_22810 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23042_23221 = state_22868__$1;
(statearr_23042_23221[(2)] = inst_22810);

(statearr_23042_23221[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (79))){
var inst_22637 = (state_22868[(28)]);
var inst_22630 = (state_22868[(45)]);
var inst_22636 = cljs.core.seq(inst_22630);
var inst_22637__$1 = cljs.core.first(inst_22636);
var inst_22638 = cljs.core.next(inst_22636);
var state_22868__$1 = (function (){var statearr_23043 = state_22868;
(statearr_23043[(44)] = inst_22638);

(statearr_23043[(28)] = inst_22637__$1);

return statearr_23043;
})();
if(cljs.core.truth_(inst_22637__$1)){
var statearr_23044_23222 = state_22868__$1;
(statearr_23044_23222[(1)] = (81));

} else {
var statearr_23045_23223 = state_22868__$1;
(statearr_23045_23223[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (38))){
var inst_22505 = (state_22868[(43)]);
var inst_22513 = (state_22868[(2)]);
var inst_22514 = [null,inst_22513];
var inst_22515 = (new cljs.core.PersistentVector(null,2,(5),inst_22505,inst_22514,null));
var state_22868__$1 = state_22868;
var statearr_23046_23224 = state_22868__$1;
(statearr_23046_23224[(2)] = inst_22515);

(statearr_23046_23224[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (126))){
var state_22868__$1 = state_22868;
var statearr_23047_23225 = state_22868__$1;
(statearr_23047_23225[(2)] = null);

(statearr_23047_23225[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (98))){
var inst_22684 = (state_22868[(60)]);
var inst_22748 = (state_22868[(2)]);
var inst_22749 = [inst_22748,offset_map];
var inst_22750 = (new cljs.core.PersistentVector(null,2,(5),inst_22684,inst_22749,null));
var state_22868__$1 = state_22868;
var statearr_23048_23226 = state_22868__$1;
(statearr_23048_23226[(2)] = inst_22750);

(statearr_23048_23226[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (124))){
var inst_22804 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23049_23227 = state_22868__$1;
(statearr_23049_23227[(2)] = inst_22804);

(statearr_23049_23227[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (87))){
var inst_22637 = (state_22868[(28)]);
var inst_22470 = (state_22868[(15)]);
var inst_22653 = (state_22868[(2)]);
var inst_22654 = fluree.db.util.async.throw_err(inst_22653);
var inst_22655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22656 = fluree.db.flake.o(inst_22637);
var inst_22657 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22470);
var inst_22658 = [inst_22656,inst_22657];
var inst_22659 = (new cljs.core.PersistentVector(null,2,(5),inst_22655,inst_22658,null));
var inst_22660 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22659,inst_22654);
var state_22868__$1 = (function (){var statearr_23050 = state_22868;
(statearr_23050[(61)] = inst_22660);

return statearr_23050;
})();
var statearr_23051_23228 = state_22868__$1;
(statearr_23051_23228[(2)] = inst_22654);

(statearr_23051_23228[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (30))){
var inst_22488 = (state_22868[(19)]);
var inst_22493 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22488);
var inst_22494 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22493);
var state_22868__$1 = state_22868;
var statearr_23052_23229 = state_22868__$1;
(statearr_23052_23229[(2)] = inst_22494);

(statearr_23052_23229[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (73))){
var inst_22593 = (state_22868[(22)]);
var inst_22568 = (state_22868[(9)]);
var inst_22602 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22568,inst_22593);
var state_22868__$1 = state_22868;
var statearr_23053_23230 = state_22868__$1;
(statearr_23053_23230[(2)] = inst_22602);

(statearr_23053_23230[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (96))){
var inst_22828 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
var statearr_23054_23231 = state_22868__$1;
(statearr_23054_23231[(2)] = inst_22828);

(statearr_23054_23231[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (10))){
var state_22868__$1 = state_22868;
var statearr_23055_23232 = state_22868__$1;
(statearr_23055_23232[(2)] = pred_spec);

(statearr_23055_23232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (18))){
var inst_22471 = (state_22868[(52)]);
var state_22868__$1 = state_22868;
var statearr_23056_23233 = state_22868__$1;
(statearr_23056_23233[(2)] = inst_22471);

(statearr_23056_23233[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (105))){
var inst_22736 = (state_22868[(2)]);
var state_22868__$1 = (function (){var statearr_23057 = state_22868;
(statearr_23057[(47)] = inst_22736);

return statearr_23057;
})();
if(cljs.core.truth_(fuel)){
var statearr_23058_23234 = state_22868__$1;
(statearr_23058_23234[(1)] = (107));

} else {
var statearr_23059_23235 = state_22868__$1;
(statearr_23059_23235[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (52))){
var inst_22538 = (state_22868[(62)]);
var state_22868__$1 = state_22868;
var statearr_23060_23236 = state_22868__$1;
(statearr_23060_23236[(2)] = inst_22538);

(statearr_23060_23236[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (114))){
var inst_22770 = flakes;
var inst_22771 = cljs.core.seq(inst_22770);
var inst_22772 = cljs.core.first(inst_22771);
var inst_22773 = cljs.core.next(inst_22771);
var inst_22774 = cljs.core.PersistentVector.EMPTY;
var inst_22775 = inst_22770;
var inst_22776 = inst_22774;
var state_22868__$1 = (function (){var statearr_23061 = state_22868;
(statearr_23061[(63)] = inst_22773);

(statearr_23061[(38)] = inst_22775);

(statearr_23061[(64)] = inst_22772);

(statearr_23061[(33)] = inst_22776);

return statearr_23061;
})();
var statearr_23062_23237 = state_22868__$1;
(statearr_23062_23237[(2)] = null);

(statearr_23062_23237[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (67))){
var state_22868__$1 = state_22868;
var statearr_23063_23238 = state_22868__$1;
(statearr_23063_23238[(2)] = null);

(statearr_23063_23238[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (71))){
var state_22868__$1 = state_22868;
var statearr_23064_23239 = state_22868__$1;
(statearr_23064_23239[(2)] = null);

(statearr_23064_23239[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (42))){
var inst_22485 = (state_22868[(17)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22485)){
var statearr_23065_23240 = state_22868__$1;
(statearr_23065_23240[(1)] = (45));

} else {
var statearr_23066_23241 = state_22868__$1;
(statearr_23066_23241[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (80))){
var inst_22617 = (state_22868[(54)]);
var inst_22673 = (state_22868[(2)]);
var inst_22674 = [inst_22673,offset_map];
var inst_22675 = (new cljs.core.PersistentVector(null,2,(5),inst_22617,inst_22674,null));
var state_22868__$1 = state_22868;
var statearr_23067_23242 = state_22868__$1;
(statearr_23067_23242[(2)] = inst_22675);

(statearr_23067_23242[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (37))){
var inst_22488 = (state_22868[(19)]);
var inst_22487 = (state_22868[(20)]);
var inst_22510 = (inst_22487 - (1));
var inst_22511 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22488,inst_22510);
var state_22868__$1 = state_22868;
var statearr_23068_23243 = state_22868__$1;
(statearr_23068_23243[(2)] = inst_22511);

(statearr_23068_23243[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (63))){
var inst_22568 = (state_22868[(9)]);
var state_22868__$1 = state_22868;
var statearr_23069_23244 = state_22868__$1;
(statearr_23069_23244[(2)] = inst_22568);

(statearr_23069_23244[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (94))){
var inst_22684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22692 = flakes;
var inst_22693 = cljs.core.seq(inst_22692);
var inst_22694 = cljs.core.first(inst_22693);
var inst_22695 = cljs.core.next(inst_22693);
var inst_22696 = cljs.core.PersistentVector.EMPTY;
var inst_22697 = inst_22692;
var inst_22698 = inst_22696;
var state_22868__$1 = (function (){var statearr_23070 = state_22868;
(statearr_23070[(65)] = inst_22695);

(statearr_23070[(66)] = inst_22694);

(statearr_23070[(49)] = inst_22697);

(statearr_23070[(60)] = inst_22684);

(statearr_23070[(32)] = inst_22698);

return statearr_23070;
})();
var statearr_23071_23245 = state_22868__$1;
(statearr_23071_23245[(2)] = null);

(statearr_23071_23245[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (8))){
var inst_22447 = (state_22868[(2)]);
var state_22868__$1 = state_22868;
if(cljs.core.truth_(inst_22447)){
var statearr_23072_23246 = state_22868__$1;
(statearr_23072_23246[(1)] = (9));

} else {
var statearr_23073_23247 = state_22868__$1;
(statearr_23073_23247[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (49))){
var inst_22538 = (state_22868[(62)]);
var inst_22538__$1 = cljs.core.not(recur_QMARK_);
var state_22868__$1 = (function (){var statearr_23074 = state_22868;
(statearr_23074[(62)] = inst_22538__$1);

return statearr_23074;
})();
if(inst_22538__$1){
var statearr_23075_23248 = state_22868__$1;
(statearr_23075_23248[(1)] = (51));

} else {
var statearr_23076_23249 = state_22868__$1;
(statearr_23076_23249[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22869 === (84))){
var inst_22646 = (state_22868[(59)]);
var state_22868__$1 = state_22868;
var statearr_23077_23250 = state_22868__$1;
(statearr_23077_23250[(2)] = inst_22646);

(statearr_23077_23250[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2684__auto____0 = (function (){
var statearr_23078 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23078[(0)] = fluree$db$query$fql_resp$state_machine__2684__auto__);

(statearr_23078[(1)] = (1));

return statearr_23078;
});
var fluree$db$query$fql_resp$state_machine__2684__auto____1 = (function (state_22868){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_22868);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23079){var ex__2687__auto__ = e23079;
var statearr_23080_23251 = state_22868;
(statearr_23080_23251[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_22868[(4)]))){
var statearr_23081_23252 = state_22868;
(statearr_23081_23252[(1)] = cljs.core.first((state_22868[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23253 = state_22868;
state_22868 = G__23253;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2684__auto__ = function(state_22868){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2684__auto____1.call(this,state_22868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2684__auto____0;
fluree$db$query$fql_resp$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2684__auto____1;
return fluree$db$query$fql_resp$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23082 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23082[(6)] = c__2706__auto__);

return statearr_23082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__23255 = res;
var G__23255__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__23254_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__23254_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23255):G__23255);
var G__23255__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__23255__$1):G__23255__$1);
var G__23255__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__23255__$2):G__23255__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__23255__$3);
} else {
return G__23255__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23436){
var state_val_23437 = (state_23436[(1)]);
if((state_val_23437 === (7))){
var state_23436__$1 = state_23436;
var statearr_23438_23524 = state_23436__$1;
(statearr_23438_23524[(2)] = null);

(statearr_23438_23524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (20))){
var inst_23294 = cljs.core.PersistentHashMap.EMPTY;
var state_23436__$1 = state_23436;
var statearr_23439_23525 = state_23436__$1;
(statearr_23439_23525[(2)] = inst_23294);

(statearr_23439_23525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (27))){
var inst_23282 = (state_23436[(7)]);
var inst_23312 = (state_23436[(8)]);
var inst_23296 = (state_23436[(9)]);
var inst_23276 = (state_23436[(10)]);
var inst_23415 = (state_23436[(2)]);
var inst_23416 = (function (){var top_level_subject = inst_23276;
var select_spec = inst_23282;
var base_acc = inst_23296;
var acc_PLUS_refs = inst_23312;
var result = inst_23415;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23417 = cljs.core.PersistentVector.EMPTY;
var inst_23418 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23282);
var inst_23419 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23418);
var inst_23420 = cljs.core.vals(inst_23419);
var inst_23421 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23282);
var inst_23422 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23421);
var inst_23423 = cljs.core.vals(inst_23422);
var inst_23424 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23420,inst_23423);
var inst_23425 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23416,inst_23417,inst_23424);
var inst_23427 = (function (){var top_level_subject = inst_23276;
var select_spec = inst_23282;
var base_acc = inst_23296;
var acc_PLUS_refs = inst_23312;
var result = inst_23415;
var sort_preds = inst_23425;
return (function (acc,p__23426){
var vec__23440 = p__23426;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23440,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23440,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23440,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23440,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23428 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23427,inst_23415,inst_23425);
var state_23436__$1 = state_23436;
var statearr_23443_23526 = state_23436__$1;
(statearr_23443_23526[(2)] = inst_23428);

(statearr_23443_23526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (1))){
var state_23436__$1 = state_23436;
var statearr_23444_23527 = state_23436__$1;
(statearr_23444_23527[(2)] = null);

(statearr_23444_23527[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (24))){
var inst_23312 = (state_23436[(8)]);
var inst_23312__$1 = (state_23436[(2)]);
var inst_23313 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23314 = cljs.core.PersistentHashMap.EMPTY;
var inst_23315 = inst_23313;
var inst_23316 = inst_23312__$1;
var inst_23317 = inst_23314;
var state_23436__$1 = (function (){var statearr_23445 = state_23436;
(statearr_23445[(11)] = inst_23315);

(statearr_23445[(12)] = inst_23316);

(statearr_23445[(8)] = inst_23312__$1);

(statearr_23445[(13)] = inst_23317);

return statearr_23445;
})();
var statearr_23446_23528 = state_23436__$1;
(statearr_23446_23528[(2)] = null);

(statearr_23446_23528[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (39))){
var inst_23316 = (state_23436[(12)]);
var inst_23282 = (state_23436[(7)]);
var inst_23332 = (state_23436[(14)]);
var inst_23325 = (state_23436[(15)]);
var inst_23361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23362 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23316,inst_23282,inst_23325,inst_23332,false);
var state_23436__$1 = (function (){var statearr_23447 = state_23436;
(statearr_23447[(16)] = inst_23361);

return statearr_23447;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23436__$1,(42),inst_23362);
} else {
if((state_val_23437 === (46))){
var inst_23315 = (state_23436[(11)]);
var inst_23317 = (state_23436[(13)]);
var inst_23325 = (state_23436[(15)]);
var inst_23379 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23380 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23381 = cljs.core.first(inst_23325);
var inst_23382 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23381);
var inst_23383 = [inst_23382];
var inst_23384 = cljs.core.PersistentHashMap.fromArrays(inst_23380,inst_23383);
var inst_23385 = cljs.core.rest(inst_23315);
var inst_23386 = [inst_23384,inst_23385,inst_23317];
var inst_23387 = (new cljs.core.PersistentVector(null,3,(5),inst_23379,inst_23386,null));
var state_23436__$1 = state_23436;
var statearr_23448_23529 = state_23436__$1;
(statearr_23448_23529[(2)] = inst_23387);

(statearr_23448_23529[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (4))){
var inst_23256 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
var statearr_23449_23530 = state_23436__$1;
(statearr_23449_23530[(2)] = inst_23256);

(statearr_23449_23530[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (15))){
var inst_23282 = (state_23436[(7)]);
var inst_23283 = (state_23436[(17)]);
var inst_23282__$1 = (state_23436[(2)]);
var inst_23283__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23282__$1);
var state_23436__$1 = (function (){var statearr_23450 = state_23436;
(statearr_23450[(7)] = inst_23282__$1);

(statearr_23450[(17)] = inst_23283__$1);

return statearr_23450;
})();
if(cljs.core.truth_(inst_23283__$1)){
var statearr_23451_23531 = state_23436__$1;
(statearr_23451_23531[(1)] = (16));

} else {
var statearr_23452_23532 = state_23436__$1;
(statearr_23452_23532[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (48))){
var inst_23398 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
var statearr_23453_23533 = state_23436__$1;
(statearr_23453_23533[(2)] = inst_23398);

(statearr_23453_23533[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (50))){
var state_23436__$1 = state_23436;
var statearr_23454_23534 = state_23436__$1;
(statearr_23454_23534[(2)] = null);

(statearr_23454_23534[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (21))){
var inst_23282 = (state_23436[(7)]);
var inst_23296 = (state_23436[(2)]);
var inst_23297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23298 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23299 = (new cljs.core.PersistentVector(null,2,(5),inst_23297,inst_23298,null));
var inst_23300 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23282,inst_23299);
var state_23436__$1 = (function (){var statearr_23455 = state_23436;
(statearr_23455[(9)] = inst_23296);

return statearr_23455;
})();
if(cljs.core.truth_(inst_23300)){
var statearr_23456_23535 = state_23436__$1;
(statearr_23456_23535[(1)] = (22));

} else {
var statearr_23457_23536 = state_23436__$1;
(statearr_23457_23536[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (31))){
var inst_23316 = (state_23436[(12)]);
var inst_23331 = (state_23436[(18)]);
var inst_23325 = (state_23436[(15)]);
var inst_23335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23336 = fluree.db.query.fql_resp.flake__GT_recur(db,inst_23325,inst_23331,inst_23316,fuel,max_fuel,cache);
var state_23436__$1 = (function (){var statearr_23458 = state_23436;
(statearr_23458[(19)] = inst_23335);

return statearr_23458;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23436__$1,(34),inst_23336);
} else {
if((state_val_23437 === (32))){
var inst_23331 = (state_23436[(18)]);
var state_23436__$1 = state_23436;
if(cljs.core.truth_(inst_23331)){
var statearr_23459_23537 = state_23436__$1;
(statearr_23459_23537[(1)] = (35));

} else {
var statearr_23460_23538 = state_23436__$1;
(statearr_23460_23538[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (40))){
var inst_23282 = (state_23436[(7)]);
var inst_23372 = (state_23436[(20)]);
var inst_23371 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23282);
var inst_23372__$1 = cljs.core.empty_QMARK_(inst_23371);
var state_23436__$1 = (function (){var statearr_23461 = state_23436;
(statearr_23461[(20)] = inst_23372__$1);

return statearr_23461;
})();
if(inst_23372__$1){
var statearr_23462_23539 = state_23436__$1;
(statearr_23462_23539[(1)] = (43));

} else {
var statearr_23463_23540 = state_23436__$1;
(statearr_23463_23540[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (33))){
var inst_23325 = (state_23436[(15)]);
var inst_23404 = (state_23436[(2)]);
var inst_23405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23404,(0),null);
var inst_23406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23404,(1),null);
var inst_23407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23404,(2),null);
var inst_23408 = cljs.core.first(inst_23325);
var inst_23409 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23408);
var inst_23410 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23405,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23409);
var inst_23315 = inst_23406;
var inst_23316 = inst_23410;
var inst_23317 = inst_23407;
var state_23436__$1 = (function (){var statearr_23464 = state_23436;
(statearr_23464[(11)] = inst_23315);

(statearr_23464[(12)] = inst_23316);

(statearr_23464[(13)] = inst_23317);

return statearr_23464;
})();
var statearr_23465_23541 = state_23436__$1;
(statearr_23465_23541[(2)] = null);

(statearr_23465_23541[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (13))){
var inst_23276 = (state_23436[(10)]);
var inst_23279 = fluree.db.query.fql_resp.full_select_spec(db,cache,base_select_spec,inst_23276);
var state_23436__$1 = state_23436;
var statearr_23466_23542 = state_23436__$1;
(statearr_23466_23542[(2)] = inst_23279);

(statearr_23466_23542[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (22))){
var inst_23282 = (state_23436[(7)]);
var inst_23302 = cljs.core.first(flakes);
var inst_23303 = fluree.db.flake.s(inst_23302);
var inst_23304 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs(inst_23282);
var inst_23305 = fluree.db.query.fql_resp.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23303,inst_23304);
var state_23436__$1 = state_23436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23436__$1,(25),inst_23305);
} else {
if((state_val_23437 === (36))){
var inst_23282 = (state_23436[(7)]);
var inst_23359 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23282);
var state_23436__$1 = state_23436;
if(cljs.core.truth_(inst_23359)){
var statearr_23467_23543 = state_23436__$1;
(statearr_23467_23543[(1)] = (39));

} else {
var statearr_23468_23544 = state_23436__$1;
(statearr_23468_23544[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (41))){
var inst_23400 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
var statearr_23469_23545 = state_23436__$1;
(statearr_23469_23545[(2)] = inst_23400);

(statearr_23469_23545[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (43))){
var inst_23282 = (state_23436[(7)]);
var inst_23374 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23282);
var state_23436__$1 = state_23436;
var statearr_23470_23546 = state_23436__$1;
(statearr_23470_23546[(2)] = inst_23374);

(statearr_23470_23546[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (29))){
var inst_23315 = (state_23436[(11)]);
var inst_23282 = (state_23436[(7)]);
var inst_23331 = (state_23436[(18)]);
var inst_23325 = (state_23436[(15)]);
var inst_23325__$1 = cljs.core.first(inst_23315);
var inst_23326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23327 = cljs.core.first(inst_23325__$1);
var inst_23328 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23327);
var inst_23329 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23328];
var inst_23330 = (new cljs.core.PersistentVector(null,3,(5),inst_23326,inst_23329,null));
var inst_23331__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23282,inst_23330);
var inst_23332 = fluree.db.query.fql_resp.component_follow_QMARK_(inst_23331__$1,inst_23282);
var inst_23333 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23331__$1);
var state_23436__$1 = (function (){var statearr_23471 = state_23436;
(statearr_23471[(14)] = inst_23332);

(statearr_23471[(18)] = inst_23331__$1);

(statearr_23471[(15)] = inst_23325__$1);

return statearr_23471;
})();
if(cljs.core.truth_(inst_23333)){
var statearr_23472_23547 = state_23436__$1;
(statearr_23472_23547[(1)] = (31));

} else {
var statearr_23473_23548 = state_23436__$1;
(statearr_23473_23548[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (44))){
var inst_23372 = (state_23436[(20)]);
var state_23436__$1 = state_23436;
var statearr_23474_23549 = state_23436__$1;
(statearr_23474_23549[(2)] = inst_23372);

(statearr_23474_23549[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (6))){
var state_23436__$1 = state_23436;
var statearr_23475_23550 = state_23436__$1;
(statearr_23475_23550[(2)] = null);

(statearr_23475_23550[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (28))){
var inst_23316 = (state_23436[(12)]);
var state_23436__$1 = state_23436;
var statearr_23476_23551 = state_23436__$1;
(statearr_23476_23551[(2)] = inst_23316);

(statearr_23476_23551[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (51))){
var inst_23396 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
var statearr_23477_23552 = state_23436__$1;
(statearr_23477_23552[(2)] = inst_23396);

(statearr_23477_23552[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (25))){
var inst_23296 = (state_23436[(9)]);
var inst_23307 = (state_23436[(2)]);
var inst_23308 = fluree.db.util.async.throw_err(inst_23307);
var inst_23309 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23296,inst_23308], 0));
var state_23436__$1 = state_23436;
var statearr_23478_23553 = state_23436__$1;
(statearr_23478_23553[(2)] = inst_23309);

(statearr_23478_23553[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (34))){
var inst_23315 = (state_23436[(11)]);
var inst_23335 = (state_23436[(19)]);
var inst_23317 = (state_23436[(13)]);
var inst_23338 = (state_23436[(2)]);
var inst_23339 = fluree.db.util.async.throw_err(inst_23338);
var inst_23340 = cljs.core.rest(inst_23315);
var inst_23341 = [inst_23339,inst_23340,inst_23317];
var inst_23342 = (new cljs.core.PersistentVector(null,3,(5),inst_23335,inst_23341,null));
var state_23436__$1 = state_23436;
var statearr_23479_23554 = state_23436__$1;
(statearr_23479_23554[(2)] = inst_23342);

(statearr_23479_23554[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (17))){
var inst_23282 = (state_23436[(7)]);
var inst_23286 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23282);
var state_23436__$1 = state_23436;
var statearr_23481_23555 = state_23436__$1;
(statearr_23481_23555[(2)] = inst_23286);

(statearr_23481_23555[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (3))){
var inst_23434 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23436__$1,inst_23434);
} else {
if((state_val_23437 === (12))){
var _ = (function (){var statearr_23482 = state_23436;
(statearr_23482[(4)] = cljs.core.rest((state_23436[(4)])));

return statearr_23482;
})();
var state_23436__$1 = state_23436;
var ex23480 = (state_23436__$1[(2)]);
var statearr_23483_23556 = state_23436__$1;
(statearr_23483_23556[(5)] = ex23480);


var statearr_23484_23557 = state_23436__$1;
(statearr_23484_23557[(1)] = (11));

(statearr_23484_23557[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (2))){
var _ = (function (){var statearr_23485 = state_23436;
(statearr_23485[(4)] = cljs.core.cons((5),(state_23436[(4)])));

return statearr_23485;
})();
var inst_23262 = cljs.core.not_empty(flakes);
var state_23436__$1 = state_23436;
if(cljs.core.truth_(inst_23262)){
var statearr_23486_23558 = state_23436__$1;
(statearr_23486_23558[(1)] = (6));

} else {
var statearr_23487_23559 = state_23436__$1;
(statearr_23487_23559[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (23))){
var inst_23296 = (state_23436[(9)]);
var state_23436__$1 = state_23436;
var statearr_23488_23560 = state_23436__$1;
(statearr_23488_23560[(2)] = inst_23296);

(statearr_23488_23560[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (47))){
var state_23436__$1 = state_23436;
var statearr_23489_23561 = state_23436__$1;
(statearr_23489_23561[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (35))){
var inst_23316 = (state_23436[(12)]);
var inst_23332 = (state_23436[(14)]);
var inst_23331 = (state_23436[(18)]);
var inst_23317 = (state_23436[(13)]);
var inst_23325 = (state_23436[(15)]);
var inst_23348 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23316,inst_23331,inst_23325,inst_23332,false,inst_23317);
var state_23436__$1 = state_23436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23436__$1,(38),inst_23348);
} else {
if((state_val_23437 === (19))){
var inst_23276 = (state_23436[(10)]);
var inst_23290 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23291 = [inst_23276];
var inst_23292 = cljs.core.PersistentHashMap.fromArrays(inst_23290,inst_23291);
var state_23436__$1 = state_23436;
var statearr_23491_23562 = state_23436__$1;
(statearr_23491_23562[(2)] = inst_23292);

(statearr_23491_23562[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (11))){
var inst_23264 = (state_23436[(2)]);
var inst_23265 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(inst_23264) : fluree.db.util.log.error.call(null,inst_23264));
var inst_23266 = (function(){throw inst_23264})();
var state_23436__$1 = (function (){var statearr_23493 = state_23436;
(statearr_23493[(21)] = inst_23265);

return statearr_23493;
})();
var statearr_23494_23563 = state_23436__$1;
(statearr_23494_23563[(2)] = inst_23266);

(statearr_23494_23563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (9))){
var _ = (function (){var statearr_23495 = state_23436;
(statearr_23495[(4)] = cljs.core.cons((12),(state_23436[(4)])));

return statearr_23495;
})();
var inst_23272 = cljs.core.first(flakes);
var inst_23273 = fluree.db.flake.s(inst_23272);
var ___$1 = (function (){var statearr_23496 = state_23436;
(statearr_23496[(4)] = cljs.core.rest((state_23436[(4)])));

return statearr_23496;
})();
var state_23436__$1 = state_23436;
var statearr_23497_23564 = state_23436__$1;
(statearr_23497_23564[(2)] = inst_23273);

(statearr_23497_23564[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (5))){
var _ = (function (){var statearr_23498 = state_23436;
(statearr_23498[(4)] = cljs.core.rest((state_23436[(4)])));

return statearr_23498;
})();
var state_23436__$1 = state_23436;
var ex23492 = (state_23436__$1[(2)]);
var statearr_23499_23565 = state_23436__$1;
(statearr_23499_23565[(5)] = ex23492);


if((ex23492 instanceof Error)){
var statearr_23500_23566 = state_23436__$1;
(statearr_23500_23566[(1)] = (4));

(statearr_23500_23566[(5)] = null);

} else {
throw ex23492;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (14))){
var state_23436__$1 = state_23436;
var statearr_23501_23567 = state_23436__$1;
(statearr_23501_23567[(2)] = base_select_spec);

(statearr_23501_23567[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (45))){
var inst_23377 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
if(cljs.core.truth_(inst_23377)){
var statearr_23502_23568 = state_23436__$1;
(statearr_23502_23568[(1)] = (46));

} else {
var statearr_23503_23569 = state_23436__$1;
(statearr_23503_23569[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (26))){
var inst_23315 = (state_23436[(11)]);
var inst_23319 = cljs.core.empty_QMARK_(inst_23315);
var state_23436__$1 = state_23436;
if(inst_23319){
var statearr_23504_23570 = state_23436__$1;
(statearr_23504_23570[(1)] = (28));

} else {
var statearr_23505_23571 = state_23436__$1;
(statearr_23505_23571[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (16))){
var inst_23283 = (state_23436[(17)]);
var state_23436__$1 = state_23436;
var statearr_23506_23572 = state_23436__$1;
(statearr_23506_23572[(2)] = inst_23283);

(statearr_23506_23572[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (38))){
var inst_23315 = (state_23436[(11)]);
var inst_23350 = (state_23436[(2)]);
var inst_23351 = fluree.db.util.async.throw_err(inst_23350);
var inst_23352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23351,(0),null);
var inst_23353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23351,(1),null);
var inst_23354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23355 = cljs.core.rest(inst_23315);
var inst_23356 = [inst_23352,inst_23355,inst_23353];
var inst_23357 = (new cljs.core.PersistentVector(null,3,(5),inst_23354,inst_23356,null));
var state_23436__$1 = state_23436;
var statearr_23507_23573 = state_23436__$1;
(statearr_23507_23573[(2)] = inst_23357);

(statearr_23507_23573[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (30))){
var inst_23413 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
var statearr_23508_23574 = state_23436__$1;
(statearr_23508_23574[(2)] = inst_23413);

(statearr_23508_23574[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (10))){
var inst_23276 = (state_23436[(2)]);
var inst_23277 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_(base_select_spec);
var state_23436__$1 = (function (){var statearr_23509 = state_23436;
(statearr_23509[(10)] = inst_23276);

return statearr_23509;
})();
if(cljs.core.truth_(inst_23277)){
var statearr_23510_23575 = state_23436__$1;
(statearr_23510_23575[(1)] = (13));

} else {
var statearr_23511_23576 = state_23436__$1;
(statearr_23511_23576[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (18))){
var inst_23288 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
if(cljs.core.truth_(inst_23288)){
var statearr_23512_23577 = state_23436__$1;
(statearr_23512_23577[(1)] = (19));

} else {
var statearr_23513_23578 = state_23436__$1;
(statearr_23513_23578[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (42))){
var inst_23315 = (state_23436[(11)]);
var inst_23361 = (state_23436[(16)]);
var inst_23317 = (state_23436[(13)]);
var inst_23364 = (state_23436[(2)]);
var inst_23365 = fluree.db.util.async.throw_err(inst_23364);
var inst_23366 = cljs.core.first(inst_23365);
var inst_23367 = cljs.core.rest(inst_23315);
var inst_23368 = [inst_23366,inst_23367,inst_23317];
var inst_23369 = (new cljs.core.PersistentVector(null,3,(5),inst_23361,inst_23368,null));
var state_23436__$1 = state_23436;
var statearr_23514_23579 = state_23436__$1;
(statearr_23514_23579[(2)] = inst_23369);

(statearr_23514_23579[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (37))){
var inst_23402 = (state_23436[(2)]);
var state_23436__$1 = state_23436;
var statearr_23515_23580 = state_23436__$1;
(statearr_23515_23580[(2)] = inst_23402);

(statearr_23515_23580[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (8))){
var inst_23431 = (state_23436[(2)]);
var _ = (function (){var statearr_23516 = state_23436;
(statearr_23516[(4)] = cljs.core.rest((state_23436[(4)])));

return statearr_23516;
})();
var state_23436__$1 = state_23436;
var statearr_23517_23581 = state_23436__$1;
(statearr_23517_23581[(2)] = inst_23431);

(statearr_23517_23581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23437 === (49))){
var inst_23315 = (state_23436[(11)]);
var inst_23316 = (state_23436[(12)]);
var inst_23317 = (state_23436[(13)]);
var inst_23390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23391 = cljs.core.rest(inst_23315);
var inst_23392 = [inst_23316,inst_23391,inst_23317];
var inst_23393 = (new cljs.core.PersistentVector(null,3,(5),inst_23390,inst_23392,null));
var state_23436__$1 = state_23436;
var statearr_23518_23582 = state_23436__$1;
(statearr_23518_23582[(2)] = inst_23393);

(statearr_23518_23582[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0 = (function (){
var statearr_23519 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23519[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__);

(statearr_23519[(1)] = (1));

return statearr_23519;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1 = (function (state_23436){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23436);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23520){var ex__2687__auto__ = e23520;
var statearr_23521_23583 = state_23436;
(statearr_23521_23583[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23436[(4)]))){
var statearr_23522_23584 = state_23436;
(statearr_23522_23584[(1)] = cljs.core.first((state_23436[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23585 = state_23436;
state_23436 = G__23585;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__ = function(state_23436){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1.call(this,state_23436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23523 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23523[(6)] = c__2706__auto__);

return statearr_23523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
