// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19882_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19882_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19886 = coll;
var vec__19887 = G__19886;
var seq__19888 = cljs.core.seq(vec__19887);
var first__19889 = cljs.core.first(seq__19888);
var seq__19888__$1 = cljs.core.next(seq__19888);
var clause = first__19889;
var r = seq__19888__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19886__$1 = G__19886;
var res__$1 = res;
while(true){
var vec__19893 = G__19886__$1;
var seq__19894 = cljs.core.seq(vec__19893);
var first__19895 = cljs.core.first(seq__19894);
var seq__19894__$1 = cljs.core.next(seq__19894);
var clause__$1 = first__19895;
var r__$1 = seq__19894__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19896 = r__$1;
var G__19897 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19886__$1 = G__19896;
res__$1 = G__19897;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__19898){
var map__19899 = p__19898;
var map__19899__$1 = cljs.core.__destructure_map(map__19899);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19899__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19903 = coll;
var vec__19904 = G__19903;
var seq__19905 = cljs.core.seq(vec__19904);
var first__19906 = cljs.core.first(seq__19905);
var seq__19905__$1 = cljs.core.next(seq__19905);
var clause = first__19906;
var r = seq__19905__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19903__$1 = G__19903;
var res__$1 = res;
while(true){
var vec__19910 = G__19903__$1;
var seq__19911 = cljs.core.seq(vec__19910);
var first__19912 = cljs.core.first(seq__19911);
var seq__19911__$1 = cljs.core.next(seq__19911);
var clause__$1 = first__19912;
var r__$1 = seq__19911__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19913 = r__$1;
var G__19914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__19903__$1 = G__19913;
res__$1 = G__19914;
continue;
} else {
var G__19915 = r__$1;
var G__19916 = res__$2;
G__19903__$1 = G__19915;
res__$1 = G__19916;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19920 = coll;
var vec__19921 = G__19920;
var seq__19922 = cljs.core.seq(vec__19921);
var first__19923 = cljs.core.first(seq__19922);
var seq__19922__$1 = cljs.core.next(seq__19922);
var clause = first__19923;
var r = seq__19922__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19920__$1 = G__19920;
var res__$1 = res;
while(true){
var vec__19927 = G__19920__$1;
var seq__19928 = cljs.core.seq(vec__19927);
var first__19929 = cljs.core.first(seq__19928);
var seq__19928__$1 = cljs.core.next(seq__19928);
var clause__$1 = first__19929;
var r__$1 = seq__19928__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19930 = r__$1;
var G__19931 = res__$2;
G__19920__$1 = G__19930;
res__$1 = G__19931;
continue;
} else {
var G__19932 = r__$1;
var G__19933 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19920__$1 = G__19932;
res__$1 = G__19933;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19936 = clause;
var G__19936__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__19936):G__19936);
var G__19936__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__19936__$1)
;
var G__19936__$3 = (function (){var fexpr__19937 = (function (p1__19934_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19934_SHARP_)," ."].join('');
});
return fexpr__19937(G__19936__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__19938 = (function (p1__19935_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19935_SHARP_),"}"].join('');
});
return fexpr__19938(G__19936__$3);
} else {
return G__19936__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__19942 = opts;
var map__19942__$1 = cljs.core.__destructure_map(map__19942);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19942__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19942__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19942__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19942__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19942__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19939_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19939_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19940_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19940_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19941_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19941_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19956){
var state_val_19957 = (state_19956[(1)]);
if((state_val_19957 === (1))){
var inst_19943 = fluree.db.util.core.url_encode(query);
var inst_19944 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19943)].join('');
var inst_19945 = ["User-Agent","Accept"];
var inst_19946 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19947 = cljs.core.PersistentHashMap.fromArrays(inst_19945,inst_19946);
var inst_19948 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19949 = [inst_19947,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19950 = cljs.core.PersistentHashMap.fromArrays(inst_19948,inst_19949);
var inst_19951 = fluree.db.util.xhttp.get(inst_19944,inst_19950);
var state_19956__$1 = state_19956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19956__$1,(2),inst_19951);
} else {
if((state_val_19957 === (2))){
var inst_19953 = (state_19956[(2)]);
var inst_19954 = fluree.db.util.async.throw_err(inst_19953);
var state_19956__$1 = state_19956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19956__$1,inst_19954);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_19958 = [null,null,null,null,null,null,null];
(statearr_19958[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__);

(statearr_19958[(1)] = (1));

return statearr_19958;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1 = (function (state_19956){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19956);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19959){var ex__2687__auto__ = e19959;
var statearr_19960_19963 = state_19956;
(statearr_19960_19963[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19956[(4)]))){
var statearr_19961_19964 = state_19956;
(statearr_19961_19964[(1)] = cljs.core.first((state_19956[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19965 = state_19956;
state_19956 = G__19965;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__ = function(state_19956){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1.call(this,state_19956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19962 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19962[(6)] = c__2706__auto__);

return statearr_19962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_19983){
var state_val_19984 = (state_19983[(1)]);
if((state_val_19984 === (1))){
var inst_19966 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_19983__$1 = state_19983;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19983__$1,(2),inst_19966);
} else {
if((state_val_19984 === (2))){
var inst_19969 = (state_19983[(7)]);
var inst_19968 = (state_19983[(2)]);
var inst_19969__$1 = fluree.db.util.async.throw_err(inst_19968);
var inst_19970 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19969__$1);
var inst_19971 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_19970);
var state_19983__$1 = (function (){var statearr_19985 = state_19983;
(statearr_19985[(7)] = inst_19969__$1);

return statearr_19985;
})();
if(inst_19971){
var statearr_19986_19995 = state_19983__$1;
(statearr_19986_19995[(1)] = (3));

} else {
var statearr_19987_19996 = state_19983__$1;
(statearr_19987_19996[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (3))){
var inst_19969 = (state_19983[(7)]);
var state_19983__$1 = state_19983;
var statearr_19988_19997 = state_19983__$1;
(statearr_19988_19997[(2)] = inst_19969);

(statearr_19988_19997[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (4))){
var inst_19969 = (state_19983[(7)]);
var inst_19974 = (function (){var body = inst_19969;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19975 = cljs.core.second(inst_19969);
var inst_19976 = cljs.core.second(inst_19975);
var inst_19977 = cljs.core.first(inst_19976);
var inst_19978 = cljs.core.second(inst_19977);
var inst_19979 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_19974,inst_19978);
var state_19983__$1 = state_19983;
var statearr_19989_19998 = state_19983__$1;
(statearr_19989_19998[(2)] = inst_19979);

(statearr_19989_19998[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (5))){
var inst_19981 = (state_19983[(2)]);
var state_19983__$1 = state_19983;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19983__$1,inst_19981);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0 = (function (){
var statearr_19990 = [null,null,null,null,null,null,null,null];
(statearr_19990[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__);

(statearr_19990[(1)] = (1));

return statearr_19990;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1 = (function (state_19983){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_19983);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e19991){var ex__2687__auto__ = e19991;
var statearr_19992_19999 = state_19983;
(statearr_19992_19999[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_19983[(4)]))){
var statearr_19993_20000 = state_19983;
(statearr_19993_20000[(1)] = cljs.core.first((state_19983[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20001 = state_19983;
state_19983 = G__20001;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__ = function(state_19983){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1.call(this,state_19983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_19994 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_19994[(6)] = c__2706__auto__);

return statearr_19994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20002_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20002_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20003_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20003_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20004_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20004_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20004_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20004_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20050){
var state_val_20051 = (state_20050[(1)]);
if((state_val_20051 === (7))){
var inst_20015 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20050__$1 = state_20050;
var statearr_20052_20080 = state_20050__$1;
(statearr_20052_20080[(2)] = inst_20015);

(statearr_20052_20080[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (1))){
var state_20050__$1 = state_20050;
var statearr_20053_20081 = state_20050__$1;
(statearr_20053_20081[(2)] = null);

(statearr_20053_20081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (4))){
var inst_20005 = (state_20050[(2)]);
var state_20050__$1 = state_20050;
var statearr_20054_20082 = state_20050__$1;
(statearr_20054_20082[(2)] = inst_20005);

(statearr_20054_20082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (15))){
var inst_20029 = (state_20050[(7)]);
var inst_20023 = (state_20050[(8)]);
var inst_20024 = (state_20050[(9)]);
var inst_20034 = (state_20050[(2)]);
var inst_20035 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20029,(0),inst_20034);
var inst_20036 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20037 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20023);
var inst_20038 = [inst_20024,inst_20037];
var inst_20039 = cljs.core.PersistentHashMap.fromArrays(inst_20036,inst_20038);
var inst_20040 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20035,inst_20039);
var inst_20041 = (function(){throw inst_20040})();
var state_20050__$1 = state_20050;
var statearr_20055_20083 = state_20050__$1;
(statearr_20055_20083[(2)] = inst_20041);

(statearr_20055_20083[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (13))){
var inst_20028 = (state_20050[(10)]);
var state_20050__$1 = state_20050;
var statearr_20056_20084 = state_20050__$1;
(statearr_20056_20084[(2)] = inst_20028);

(statearr_20056_20084[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (6))){
var state_20050__$1 = state_20050;
var statearr_20057_20085 = state_20050__$1;
(statearr_20057_20085[(2)] = null);

(statearr_20057_20085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (3))){
var inst_20048 = (state_20050[(2)]);
var state_20050__$1 = state_20050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20050__$1,inst_20048);
} else {
if((state_val_20051 === (12))){
var inst_20045 = (state_20050[(2)]);
var _ = (function (){var statearr_20058 = state_20050;
(statearr_20058[(4)] = cljs.core.rest((state_20050[(4)])));

return statearr_20058;
})();
var state_20050__$1 = state_20050;
var statearr_20059_20086 = state_20050__$1;
(statearr_20059_20086[(2)] = inst_20045);

(statearr_20059_20086[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (2))){
var _ = (function (){var statearr_20060 = state_20050;
(statearr_20060[(4)] = cljs.core.cons((5),(state_20050[(4)])));

return statearr_20060;
})();
var inst_20012 = cljs.core.empty_QMARK_(matching_vars);
var state_20050__$1 = state_20050;
if(inst_20012){
var statearr_20061_20087 = state_20050__$1;
(statearr_20061_20087[(1)] = (6));

} else {
var statearr_20062_20088 = state_20050__$1;
(statearr_20062_20088[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (11))){
var inst_20023 = (state_20050[(8)]);
var inst_20043 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20023,all_vars);
var state_20050__$1 = state_20050;
var statearr_20064_20089 = state_20050__$1;
(statearr_20064_20089[(2)] = inst_20043);

(statearr_20064_20089[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (9))){
var inst_20023 = (state_20050[(8)]);
var inst_20024 = (state_20050[(9)]);
var inst_20021 = (state_20050[(2)]);
var inst_20022 = fluree.db.util.async.throw_err(inst_20021);
var inst_20023__$1 = cljs.core.__destructure_map(inst_20022);
var inst_20024__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20023__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20023__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20026 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20024__$1);
var state_20050__$1 = (function (){var statearr_20065 = state_20050;
(statearr_20065[(11)] = inst_20025);

(statearr_20065[(8)] = inst_20023__$1);

(statearr_20065[(9)] = inst_20024__$1);

return statearr_20065;
})();
if(inst_20026){
var statearr_20066_20090 = state_20050__$1;
(statearr_20066_20090[(1)] = (10));

} else {
var statearr_20067_20091 = state_20050__$1;
(statearr_20067_20091[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (5))){
var _ = (function (){var statearr_20068 = state_20050;
(statearr_20068[(4)] = cljs.core.rest((state_20050[(4)])));

return statearr_20068;
})();
var state_20050__$1 = state_20050;
var ex20063 = (state_20050__$1[(2)]);
var statearr_20069_20092 = state_20050__$1;
(statearr_20069_20092[(5)] = ex20063);


if((ex20063 instanceof Error)){
var statearr_20070_20093 = state_20050__$1;
(statearr_20070_20093[(1)] = (4));

(statearr_20070_20093[(5)] = null);

} else {
throw ex20063;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (14))){
var state_20050__$1 = state_20050;
var statearr_20071_20094 = state_20050__$1;
(statearr_20071_20094[(2)] = (1000));

(statearr_20071_20094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (10))){
var inst_20025 = (state_20050[(11)]);
var inst_20028 = (state_20050[(10)]);
var inst_20023 = (state_20050[(8)]);
var inst_20028__$1 = cljs.core.count(inst_20025);
var inst_20029 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20023);
var inst_20030 = (inst_20028__$1 < (1000));
var state_20050__$1 = (function (){var statearr_20072 = state_20050;
(statearr_20072[(10)] = inst_20028__$1);

(statearr_20072[(7)] = inst_20029);

return statearr_20072;
})();
if(cljs.core.truth_(inst_20030)){
var statearr_20073_20095 = state_20050__$1;
(statearr_20073_20095[(1)] = (13));

} else {
var statearr_20074_20096 = state_20050__$1;
(statearr_20074_20096[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20051 === (8))){
var inst_20017 = (state_20050[(2)]);
var inst_20018 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20017,optional_clauses);
var inst_20019 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20018);
var state_20050__$1 = state_20050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20050__$1,(9),inst_20019);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_20075 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20075[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__);

(statearr_20075[(1)] = (1));

return statearr_20075;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1 = (function (state_20050){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20050);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20076){var ex__2687__auto__ = e20076;
var statearr_20077_20097 = state_20050;
(statearr_20077_20097[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20050[(4)]))){
var statearr_20078_20098 = state_20050;
(statearr_20078_20098[(1)] = cljs.core.first((state_20050[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20099 = state_20050;
state_20050 = G__20099;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__ = function(state_20050){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1.call(this,state_20050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20079 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20079[(6)] = c__2706__auto__);

return statearr_20079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
