// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28219 = arguments.length;
var i__5770__auto___28220 = (0);
while(true){
if((i__5770__auto___28220 < len__5769__auto___28219)){
args__5775__auto__.push((arguments[i__5770__auto___28220]));

var G__28221 = (i__5770__auto___28220 + (1));
i__5770__auto___28220 = G__28221;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
var G__28214_28222 = e;
var G__28215_28223 = "Function Error: ";
var G__28216_28224 = function_name;
var G__28217_28225 = "args: ";
var G__28218_28226 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$5(G__28214_28222,G__28215_28223,G__28216_28224,G__28217_28225,G__28218_28226) : fluree.db.util.log.error.call(null,G__28214_28222,G__28215_28223,G__28216_28224,G__28217_28225,G__28218_28226));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28211){
var G__28212 = cljs.core.first(seq28211);
var seq28211__$1 = cljs.core.next(seq28211);
var G__28213 = cljs.core.first(seq28211__$1);
var seq28211__$2 = cljs.core.next(seq28211__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28212,G__28213,seq28211__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28227){var e = e28227;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28228){var e = e28228;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28229){var e = e28229;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28230){var e = e28230;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28231){var e = e28231;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28234 = arguments.length;
var i__5770__auto___28235 = (0);
while(true){
if((i__5770__auto___28235 < len__5769__auto___28234)){
args__5775__auto__.push((arguments[i__5770__auto___28235]));

var G__28236 = (i__5770__auto___28235 + (1));
i__5770__auto___28235 = G__28236;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28233){var e = e28233;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28232){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28232));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28239 = arguments.length;
var i__5770__auto___28240 = (0);
while(true){
if((i__5770__auto___28240 < len__5769__auto___28239)){
args__5775__auto__.push((arguments[i__5770__auto___28240]));

var G__28241 = (i__5770__auto___28240 + (1));
i__5770__auto___28240 = G__28241;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28238){var e = e28238;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28237){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28237));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28242){var e = e28242;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28245 = arguments.length;
var i__5770__auto___28246 = (0);
while(true){
if((i__5770__auto___28246 < len__5769__auto___28245)){
args__5775__auto__.push((arguments[i__5770__auto___28246]));

var G__28247 = (i__5770__auto___28246 + (1));
i__5770__auto___28246 = G__28247;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28244){var e = e28244;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28243){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28243));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28250 = arguments.length;
var i__5770__auto___28251 = (0);
while(true){
if((i__5770__auto___28251 < len__5769__auto___28250)){
args__5775__auto__.push((arguments[i__5770__auto___28251]));

var G__28252 = (i__5770__auto___28251 + (1));
i__5770__auto___28251 = G__28252;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28249){var e = e28249;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28248){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28248));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28253){var e = e28253;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28254){var e = e28254;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28257 = arguments.length;
var i__5770__auto___28258 = (0);
while(true){
if((i__5770__auto___28258 < len__5769__auto___28257)){
args__5775__auto__.push((arguments[i__5770__auto___28258]));

var G__28259 = (i__5770__auto___28258 + (1));
i__5770__auto___28258 = G__28259;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28256){var e = e28256;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28255){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28255));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28262 = arguments.length;
var i__5770__auto___28263 = (0);
while(true){
if((i__5770__auto___28263 < len__5769__auto___28262)){
args__5775__auto__.push((arguments[i__5770__auto___28263]));

var G__28264 = (i__5770__auto___28263 + (1));
i__5770__auto___28263 = G__28264;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28261){var e = e28261;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28260){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28260));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28267 = arguments.length;
var i__5770__auto___28268 = (0);
while(true){
if((i__5770__auto___28268 < len__5769__auto___28267)){
args__5775__auto__.push((arguments[i__5770__auto___28268]));

var G__28269 = (i__5770__auto___28268 + (1));
i__5770__auto___28268 = G__28269;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28266){var e = e28266;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28265){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28265));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28272 = arguments.length;
var i__5770__auto___28273 = (0);
while(true){
if((i__5770__auto___28273 < len__5769__auto___28272)){
args__5775__auto__.push((arguments[i__5770__auto___28273]));

var G__28274 = (i__5770__auto___28273 + (1));
i__5770__auto___28273 = G__28274;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28271){var e = e28271;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28270){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28270));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28277 = arguments.length;
var i__5770__auto___28278 = (0);
while(true){
if((i__5770__auto___28278 < len__5769__auto___28277)){
args__5775__auto__.push((arguments[i__5770__auto___28278]));

var G__28279 = (i__5770__auto___28278 + (1));
i__5770__auto___28278 = G__28279;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28276){var e = e28276;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28275){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28275));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28282 = arguments.length;
var i__5770__auto___28283 = (0);
while(true){
if((i__5770__auto___28283 < len__5769__auto___28282)){
args__5775__auto__.push((arguments[i__5770__auto___28283]));

var G__28284 = (i__5770__auto___28283 + (1));
i__5770__auto___28283 = G__28284;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28281){var e = e28281;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28280){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28280));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28287 = arguments.length;
var i__5770__auto___28288 = (0);
while(true){
if((i__5770__auto___28288 < len__5769__auto___28287)){
args__5775__auto__.push((arguments[i__5770__auto___28288]));

var G__28289 = (i__5770__auto___28288 + (1));
i__5770__auto___28288 = G__28289;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28286){var e = e28286;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28285){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28285));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28291 = arguments.length;
switch (G__28291) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28319){
var state_val_28320 = (state_28319[(1)]);
if((state_val_28320 === (7))){
var inst_28304 = (state_28319[(7)]);
var inst_28307 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28304,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28319__$1 = state_28319;
var statearr_28321_28407 = state_28319__$1;
(statearr_28321_28407[(2)] = inst_28307);

(statearr_28321_28407[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28320 === (1))){
var state_28319__$1 = state_28319;
var statearr_28322_28408 = state_28319__$1;
(statearr_28322_28408[(2)] = null);

(statearr_28322_28408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28320 === (4))){
var inst_28292 = (state_28319[(2)]);
var state_28319__$1 = state_28319;
var statearr_28323_28409 = state_28319__$1;
(statearr_28323_28409[(2)] = inst_28292);

(statearr_28323_28409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28320 === (6))){
var inst_28304 = (state_28319[(7)]);
var inst_28304__$1 = (state_28319[(2)]);
var inst_28305 = fluree.db.util.core.exception_QMARK_(inst_28304__$1);
var state_28319__$1 = (function (){var statearr_28324 = state_28319;
(statearr_28324[(7)] = inst_28304__$1);

return statearr_28324;
})();
if(inst_28305){
var statearr_28325_28410 = state_28319__$1;
(statearr_28325_28410[(1)] = (7));

} else {
var statearr_28326_28411 = state_28319__$1;
(statearr_28326_28411[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28320 === (3))){
var inst_28317 = (state_28319[(2)]);
var state_28319__$1 = state_28319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28319__$1,inst_28317);
} else {
if((state_val_28320 === (2))){
var inst_28298 = (state_28319[(8)]);
var _ = (function (){var statearr_28328 = state_28319;
(statearr_28328[(4)] = cljs.core.cons((5),(state_28319[(4)])));

return statearr_28328;
})();
var inst_28298__$1 = cljs.core.volatile_BANG_((0));
var inst_28299 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28300 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28299,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28298__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28301 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28300);
var inst_28302 = fluree.db.query.fql.query(db,inst_28301);
var state_28319__$1 = (function (){var statearr_28329 = state_28319;
(statearr_28329[(8)] = inst_28298__$1);

return statearr_28329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28319__$1,(6),inst_28302);
} else {
if((state_val_28320 === (9))){
var inst_28314 = (state_28319[(2)]);
var _ = (function (){var statearr_28330 = state_28319;
(statearr_28330[(4)] = cljs.core.rest((state_28319[(4)])));

return statearr_28330;
})();
var state_28319__$1 = state_28319;
var statearr_28331_28412 = state_28319__$1;
(statearr_28331_28412[(2)] = inst_28314);

(statearr_28331_28412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28320 === (5))){
var _ = (function (){var statearr_28332 = state_28319;
(statearr_28332[(4)] = cljs.core.rest((state_28319[(4)])));

return statearr_28332;
})();
var state_28319__$1 = state_28319;
var ex28327 = (state_28319__$1[(2)]);
var statearr_28333_28413 = state_28319__$1;
(statearr_28333_28413[(5)] = ex28327);


if((ex28327 instanceof Error)){
var statearr_28334_28414 = state_28319__$1;
(statearr_28334_28414[(1)] = (4));

(statearr_28334_28414[(5)] = null);

} else {
throw ex28327;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28320 === (8))){
var inst_28304 = (state_28319[(7)]);
var inst_28298 = (state_28319[(8)]);
var inst_28309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28310 = cljs.core.deref(inst_28298);
var inst_28311 = [inst_28304,inst_28310];
var inst_28312 = (new cljs.core.PersistentVector(null,2,(5),inst_28309,inst_28311,null));
var state_28319__$1 = state_28319;
var statearr_28335_28415 = state_28319__$1;
(statearr_28335_28415[(2)] = inst_28312);

(statearr_28335_28415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_28336 = [null,null,null,null,null,null,null,null,null];
(statearr_28336[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_28336[(1)] = (1));

return statearr_28336;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_28319){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28319);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28337){var ex__2687__auto__ = e28337;
var statearr_28338_28416 = state_28319;
(statearr_28338_28416[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28319[(4)]))){
var statearr_28339_28417 = state_28319;
(statearr_28339_28417[(1)] = cljs.core.first((state_28319[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28418 = state_28319;
state_28319 = G__28418;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_28319){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_28319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28340 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28340[(6)] = c__2706__auto__);

return statearr_28340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28385){
var state_val_28386 = (state_28385[(1)]);
if((state_val_28386 === (7))){
var inst_28371 = (state_28385[(2)]);
var inst_28372 = fluree.db.query.fql.query(db,inst_28371);
var state_28385__$1 = state_28385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28385__$1,(8),inst_28372);
} else {
if((state_val_28386 === (1))){
var inst_28341 = typeof select === 'string';
var state_28385__$1 = state_28385;
if(cljs.core.truth_(inst_28341)){
var statearr_28387_28419 = state_28385__$1;
(statearr_28387_28419[(1)] = (2));

} else {
var statearr_28388_28420 = state_28385__$1;
(statearr_28388_28420[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (4))){
var inst_28347 = (state_28385[(7)]);
var inst_28354 = (state_28385[(8)]);
var inst_28346 = (state_28385[(2)]);
var inst_28347__$1 = cljs.core.volatile_BANG_((0));
var inst_28348 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28349 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28350 = [inst_28347__$1,(100000)];
var inst_28351 = cljs.core.PersistentHashMap.fromArrays(inst_28349,inst_28350);
var inst_28352 = [inst_28346,from,where,block,limit,inst_28351];
var inst_28353 = cljs.core.PersistentHashMap.fromArrays(inst_28348,inst_28352);
var inst_28354__$1 = fluree.db.util.core.without_nils(inst_28353);
var inst_28355 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28354__$1);
var inst_28356 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28354__$1);
var inst_28357 = cljs.core.first(inst_28356);
var inst_28358 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28357], 0));
var inst_28359 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28358);
var inst_28360 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28354__$1);
var inst_28361 = cljs.core.last(inst_28360);
var inst_28362 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28361], 0));
var inst_28363 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28362);
var inst_28364 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28355,inst_28359,inst_28363], 0));
var state_28385__$1 = (function (){var statearr_28389 = state_28385;
(statearr_28389[(7)] = inst_28347__$1);

(statearr_28389[(8)] = inst_28354__$1);

return statearr_28389;
})();
if(cljs.core.truth_(inst_28364)){
var statearr_28390_28421 = state_28385__$1;
(statearr_28390_28421[(1)] = (5));

} else {
var statearr_28391_28422 = state_28385__$1;
(statearr_28391_28422[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (6))){
var inst_28354 = (state_28385[(8)]);
var state_28385__$1 = state_28385;
var statearr_28392_28423 = state_28385__$1;
(statearr_28392_28423[(2)] = inst_28354);

(statearr_28392_28423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (3))){
var state_28385__$1 = state_28385;
var statearr_28393_28424 = state_28385__$1;
(statearr_28393_28424[(2)] = select);

(statearr_28393_28424[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (2))){
var inst_28343 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28385__$1 = state_28385;
var statearr_28394_28425 = state_28385__$1;
(statearr_28394_28425[(2)] = inst_28343);

(statearr_28394_28425[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (11))){
var inst_28383 = (state_28385[(2)]);
var state_28385__$1 = state_28385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28385__$1,inst_28383);
} else {
if((state_val_28386 === (9))){
var inst_28374 = (state_28385[(9)]);
var state_28385__$1 = state_28385;
var statearr_28395_28426 = state_28385__$1;
(statearr_28395_28426[(2)] = inst_28374);

(statearr_28395_28426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (5))){
var inst_28354 = (state_28385[(8)]);
var inst_28366 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28354);
var inst_28367 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28366);
var inst_28368 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28354,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28367);
var state_28385__$1 = state_28385;
var statearr_28396_28427 = state_28385__$1;
(statearr_28396_28427[(2)] = inst_28368);

(statearr_28396_28427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (10))){
var inst_28347 = (state_28385[(7)]);
var inst_28374 = (state_28385[(9)]);
var inst_28378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28379 = cljs.core.deref(inst_28347);
var inst_28380 = [inst_28374,inst_28379];
var inst_28381 = (new cljs.core.PersistentVector(null,2,(5),inst_28378,inst_28380,null));
var state_28385__$1 = state_28385;
var statearr_28397_28428 = state_28385__$1;
(statearr_28397_28428[(2)] = inst_28381);

(statearr_28397_28428[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28386 === (8))){
var inst_28374 = (state_28385[(9)]);
var inst_28374__$1 = (state_28385[(2)]);
var inst_28375 = fluree.db.util.core.exception_QMARK_(inst_28374__$1);
var state_28385__$1 = (function (){var statearr_28398 = state_28385;
(statearr_28398[(9)] = inst_28374__$1);

return statearr_28398;
})();
if(inst_28375){
var statearr_28399_28429 = state_28385__$1;
(statearr_28399_28429[(1)] = (9));

} else {
var statearr_28400_28430 = state_28385__$1;
(statearr_28400_28430[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_28401 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28401[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_28401[(1)] = (1));

return statearr_28401;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_28385){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28385);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28402){var ex__2687__auto__ = e28402;
var statearr_28403_28431 = state_28385;
(statearr_28403_28431[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28385[(4)]))){
var statearr_28404_28432 = state_28385;
(statearr_28404_28432[(1)] = cljs.core.first((state_28385[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28433 = state_28385;
state_28385 = G__28433;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_28385){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_28385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28405 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28405[(6)] = c__2706__auto__);

return statearr_28405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28437 = path;
var vec__28438 = G__28437;
var seq__28439 = cljs.core.seq(vec__28438);
var first__28440 = cljs.core.first(seq__28439);
var seq__28439__$1 = cljs.core.next(seq__28439);
var var$ = first__28440;
var r = seq__28439__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28437__$1 = G__28437;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28444 = G__28437__$1;
var seq__28445 = cljs.core.seq(vec__28444);
var first__28446 = cljs.core.first(seq__28445);
var seq__28445__$1 = cljs.core.next(seq__28445);
var var$__$1 = first__28446;
var r__$1 = seq__28445__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28447 = r__$1;
var G__28448 = n__$2;
var G__28449 = next_clauses;
G__28437__$1 = G__28447;
n__$1 = G__28448;
where_clauses__$1 = G__28449;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28450 = r__$1;
var G__28451 = next_n;
var G__28452 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28437__$1 = G__28450;
n__$1 = G__28451;
where_clauses__$1 = G__28452;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28489){
var state_val_28490 = (state_28489[(1)]);
if((state_val_28490 === (7))){
var inst_28462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28463 = [path];
var inst_28464 = (new cljs.core.PersistentVector(null,1,(5),inst_28462,inst_28463,null));
var state_28489__$1 = state_28489;
var statearr_28491_28519 = state_28489__$1;
(statearr_28491_28519[(2)] = inst_28464);

(statearr_28491_28519[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (1))){
var state_28489__$1 = state_28489;
var statearr_28492_28520 = state_28489__$1;
(statearr_28492_28520[(2)] = null);

(statearr_28492_28520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (4))){
var inst_28453 = (state_28489[(2)]);
var state_28489__$1 = state_28489;
var statearr_28493_28521 = state_28489__$1;
(statearr_28493_28521[(2)] = inst_28453);

(statearr_28493_28521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (13))){
var inst_28480 = (state_28489[(2)]);
var inst_28481 = fluree.db.util.async.throw_err(inst_28480);
var _ = (function (){var statearr_28494 = state_28489;
(statearr_28494[(4)] = cljs.core.rest((state_28489[(4)])));

return statearr_28494;
})();
var state_28489__$1 = state_28489;
var statearr_28495_28522 = state_28489__$1;
(statearr_28495_28522[(2)] = inst_28481);

(statearr_28495_28522[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (6))){
var state_28489__$1 = state_28489;
var statearr_28497_28523 = state_28489__$1;
(statearr_28497_28523[(2)] = path);

(statearr_28497_28523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (3))){
var inst_28487 = (state_28489[(2)]);
var state_28489__$1 = state_28489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28489__$1,inst_28487);
} else {
if((state_val_28490 === (12))){
var _ = (function (){var statearr_28498 = state_28489;
(statearr_28498[(4)] = cljs.core.rest((state_28489[(4)])));

return statearr_28498;
})();
var state_28489__$1 = state_28489;
var ex28496 = (state_28489__$1[(2)]);
var statearr_28499_28524 = state_28489__$1;
(statearr_28499_28524[(5)] = ex28496);


var statearr_28500_28525 = state_28489__$1;
(statearr_28500_28525[(1)] = (11));

(statearr_28500_28525[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (2))){
var _ = (function (){var statearr_28501 = state_28489;
(statearr_28501[(4)] = cljs.core.cons((5),(state_28489[(4)])));

return statearr_28501;
})();
var inst_28459 = cljs.core.vector_QMARK_(path);
var state_28489__$1 = state_28489;
if(inst_28459){
var statearr_28502_28526 = state_28489__$1;
(statearr_28502_28526[(1)] = (6));

} else {
var statearr_28503_28527 = state_28489__$1;
(statearr_28503_28527[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (11))){
var inst_28466 = (state_28489[(7)]);
var inst_28471 = (state_28489[(2)]);
var inst_28472 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28471,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28466,endSubject], 0));
var state_28489__$1 = state_28489;
var statearr_28505_28528 = state_28489__$1;
(statearr_28505_28528[(2)] = inst_28472);

(statearr_28505_28528[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (9))){
var inst_28470 = (state_28489[(8)]);
var _ = (function (){var statearr_28506 = state_28489;
(statearr_28506[(4)] = cljs.core.cons((12),(state_28489[(4)])));

return statearr_28506;
})();
var inst_28478 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28470);
var state_28489__$1 = state_28489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28489__$1,(13),inst_28478);
} else {
if((state_val_28490 === (5))){
var _ = (function (){var statearr_28507 = state_28489;
(statearr_28507[(4)] = cljs.core.rest((state_28489[(4)])));

return statearr_28507;
})();
var state_28489__$1 = state_28489;
var ex28504 = (state_28489__$1[(2)]);
var statearr_28508_28529 = state_28489__$1;
(statearr_28508_28529[(5)] = ex28504);


if((ex28504 instanceof Error)){
var statearr_28509_28530 = state_28489__$1;
(statearr_28509_28530[(1)] = (4));

(statearr_28509_28530[(5)] = null);

} else {
throw ex28504;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (10))){
var inst_28484 = (state_28489[(2)]);
var _ = (function (){var statearr_28510 = state_28489;
(statearr_28510[(4)] = cljs.core.rest((state_28489[(4)])));

return statearr_28510;
})();
var state_28489__$1 = state_28489;
var statearr_28511_28531 = state_28489__$1;
(statearr_28511_28531[(2)] = inst_28484);

(statearr_28511_28531[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28490 === (8))){
var inst_28466 = (state_28489[(7)]);
var inst_28466__$1 = (state_28489[(2)]);
var inst_28467 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28466__$1,endSubject);
var inst_28468 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28469 = ["?var1",inst_28467];
var inst_28470 = cljs.core.PersistentHashMap.fromArrays(inst_28468,inst_28469);
var state_28489__$1 = (function (){var statearr_28512 = state_28489;
(statearr_28512[(8)] = inst_28470);

(statearr_28512[(7)] = inst_28466__$1);

return statearr_28512;
})();
var statearr_28513_28532 = state_28489__$1;
(statearr_28513_28532[(2)] = null);

(statearr_28513_28532[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0 = (function (){
var statearr_28514 = [null,null,null,null,null,null,null,null,null];
(statearr_28514[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__);

(statearr_28514[(1)] = (1));

return statearr_28514;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1 = (function (state_28489){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28489);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28515){var ex__2687__auto__ = e28515;
var statearr_28516_28533 = state_28489;
(statearr_28516_28533[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28489[(4)]))){
var statearr_28517_28534 = state_28489;
(statearr_28517_28534[(1)] = cljs.core.first((state_28489[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28535 = state_28489;
state_28489 = G__28535;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__ = function(state_28489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1.call(this,state_28489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28518 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28518[(6)] = c__2706__auto__);

return statearr_28518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28536){var e = e28536;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28537){var e = e28537;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28538){var e = e28538;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28592){
var state_val_28593 = (state_28592[(1)]);
if((state_val_28593 === (7))){
var state_28592__$1 = state_28592;
var statearr_28594_28632 = state_28592__$1;
(statearr_28594_28632[(2)] = pred);

(statearr_28594_28632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (20))){
var inst_28571 = (state_28592[(7)]);
var inst_28575 = (state_28592[(8)]);
var inst_28579 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_28575,inst_28571);
var state_28592__$1 = state_28592;
var statearr_28595_28633 = state_28592__$1;
(statearr_28595_28633[(2)] = inst_28579);

(statearr_28595_28633[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (1))){
var state_28592__$1 = state_28592;
var statearr_28596_28634 = state_28592__$1;
(statearr_28596_28634[(2)] = null);

(statearr_28596_28634[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (4))){
var inst_28539 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
var statearr_28597_28635 = state_28592__$1;
(statearr_28597_28635[(2)] = inst_28539);

(statearr_28597_28635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (15))){
var state_28592__$1 = state_28592;
var statearr_28598_28636 = state_28592__$1;
(statearr_28598_28636[(2)] = fluree.db.flake.o);

(statearr_28598_28636[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (21))){
var inst_28571 = (state_28592[(7)]);
var inst_28575 = (state_28592[(8)]);
var inst_28581 = cljs.core.first(inst_28571);
var inst_28582 = (inst_28575.cljs$core$IFn$_invoke$arity$1 ? inst_28575.cljs$core$IFn$_invoke$arity$1(inst_28581) : inst_28575.call(null,inst_28581));
var state_28592__$1 = state_28592;
var statearr_28599_28637 = state_28592__$1;
(statearr_28599_28637[(2)] = inst_28582);

(statearr_28599_28637[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (13))){
var inst_28568 = (state_28592[(2)]);
var inst_28569 = fluree.db.util.async.throw_err(inst_28568);
var state_28592__$1 = state_28592;
var statearr_28600_28638 = state_28592__$1;
(statearr_28600_28638[(2)] = inst_28569);

(statearr_28600_28638[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (22))){
var inst_28584 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
var statearr_28601_28639 = state_28592__$1;
(statearr_28601_28639[(2)] = inst_28584);

(statearr_28601_28639[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (6))){
var inst_28549 = clojure.string.replace(pred,"/_","/");
var state_28592__$1 = state_28592;
var statearr_28602_28640 = state_28592__$1;
(statearr_28602_28640[(2)] = inst_28549);

(statearr_28602_28640[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (17))){
var inst_28553 = (state_28592[(9)]);
var state_28592__$1 = state_28592;
if(cljs.core.truth_(inst_28553)){
var statearr_28603_28641 = state_28592__$1;
(statearr_28603_28641[(1)] = (20));

} else {
var statearr_28604_28642 = state_28592__$1;
(statearr_28604_28642[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (3))){
var inst_28590 = (state_28592[(2)]);
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28592__$1,inst_28590);
} else {
if((state_val_28593 === (12))){
var inst_28560 = (state_28592[(2)]);
var inst_28561 = fluree.db.util.async.throw_err(inst_28560);
var state_28592__$1 = state_28592;
var statearr_28605_28643 = state_28592__$1;
(statearr_28605_28643[(2)] = inst_28561);

(statearr_28605_28643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (2))){
var inst_28547 = (state_28592[(10)]);
var _ = (function (){var statearr_28606 = state_28592;
(statearr_28606[(4)] = cljs.core.cons((5),(state_28592[(4)])));

return statearr_28606;
})();
var inst_28545 = typeof pred === 'string';
var inst_28546 = cljs.core.re_matches(/.+\/_.+/,pred);
var inst_28547__$1 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28545,inst_28546], 0));
var state_28592__$1 = (function (){var statearr_28607 = state_28592;
(statearr_28607[(10)] = inst_28547__$1);

return statearr_28607;
})();
if(cljs.core.truth_(inst_28547__$1)){
var statearr_28608_28644 = state_28592__$1;
(statearr_28608_28644[(1)] = (6));

} else {
var statearr_28609_28645 = state_28592__$1;
(statearr_28609_28645[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (19))){
var inst_28587 = (state_28592[(2)]);
var _ = (function (){var statearr_28610 = state_28592;
(statearr_28610[(4)] = cljs.core.rest((state_28592[(4)])));

return statearr_28610;
})();
var state_28592__$1 = state_28592;
var statearr_28611_28646 = state_28592__$1;
(statearr_28611_28646[(2)] = inst_28587);

(statearr_28611_28646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (11))){
var inst_28547 = (state_28592[(10)]);
var inst_28571 = (state_28592[(2)]);
var state_28592__$1 = (function (){var statearr_28613 = state_28592;
(statearr_28613[(7)] = inst_28571);

return statearr_28613;
})();
if(cljs.core.truth_(inst_28547)){
var statearr_28614_28647 = state_28592__$1;
(statearr_28614_28647[(1)] = (14));

} else {
var statearr_28615_28648 = state_28592__$1;
(statearr_28615_28648[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (9))){
var inst_28552 = (state_28592[(11)]);
var inst_28555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28556 = [sid,inst_28552];
var inst_28557 = (new cljs.core.PersistentVector(null,2,(5),inst_28555,inst_28556,null));
var inst_28558 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_28557);
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28592__$1,(12),inst_28558);
} else {
if((state_val_28593 === (5))){
var _ = (function (){var statearr_28616 = state_28592;
(statearr_28616[(4)] = cljs.core.rest((state_28592[(4)])));

return statearr_28616;
})();
var state_28592__$1 = state_28592;
var ex28612 = (state_28592__$1[(2)]);
var statearr_28617_28649 = state_28592__$1;
(statearr_28617_28649[(5)] = ex28612);


if((ex28612 instanceof Error)){
var statearr_28618_28650 = state_28592__$1;
(statearr_28618_28650[(1)] = (4));

(statearr_28618_28650[(5)] = null);

} else {
throw ex28612;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (14))){
var state_28592__$1 = state_28592;
var statearr_28619_28651 = state_28592__$1;
(statearr_28619_28651[(2)] = fluree.db.flake.s);

(statearr_28619_28651[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (16))){
var inst_28571 = (state_28592[(7)]);
var inst_28575 = (state_28592[(2)]);
var inst_28576 = cljs.core.seq(inst_28571);
var state_28592__$1 = (function (){var statearr_28620 = state_28592;
(statearr_28620[(8)] = inst_28575);

return statearr_28620;
})();
if(inst_28576){
var statearr_28621_28652 = state_28592__$1;
(statearr_28621_28652[(1)] = (17));

} else {
var statearr_28622_28653 = state_28592__$1;
(statearr_28622_28653[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (10))){
var inst_28552 = (state_28592[(11)]);
var inst_28563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28564 = [sid,inst_28552];
var inst_28565 = (new cljs.core.PersistentVector(null,2,(5),inst_28563,inst_28564,null));
var inst_28566 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28565);
var state_28592__$1 = state_28592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28592__$1,(13),inst_28566);
} else {
if((state_val_28593 === (18))){
var state_28592__$1 = state_28592;
var statearr_28623_28654 = state_28592__$1;
(statearr_28623_28654[(2)] = null);

(statearr_28623_28654[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28593 === (8))){
var inst_28547 = (state_28592[(10)]);
var inst_28552 = (state_28592[(11)]);
var inst_28552__$1 = (state_28592[(2)]);
var inst_28553 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28552__$1);
var state_28592__$1 = (function (){var statearr_28624 = state_28592;
(statearr_28624[(11)] = inst_28552__$1);

(statearr_28624[(9)] = inst_28553);

return statearr_28624;
})();
if(cljs.core.truth_(inst_28547)){
var statearr_28625_28655 = state_28592__$1;
(statearr_28625_28655[(1)] = (9));

} else {
var statearr_28626_28656 = state_28592__$1;
(statearr_28626_28656[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0 = (function (){
var statearr_28627 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28627[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__);

(statearr_28627[(1)] = (1));

return statearr_28627;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1 = (function (state_28592){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28592);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28628){var ex__2687__auto__ = e28628;
var statearr_28629_28657 = state_28592;
(statearr_28629_28657[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28592[(4)]))){
var statearr_28630_28658 = state_28592;
(statearr_28630_28658[(1)] = cljs.core.first((state_28592[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28659 = state_28592;
state_28592 = G__28659;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__ = function(state_28592){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1.call(this,state_28592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28631 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28631[(6)] = c__2706__auto__);

return statearr_28631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28660){var e = e28660;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28663 = arguments.length;
var i__5770__auto___28664 = (0);
while(true){
if((i__5770__auto___28664 < len__5769__auto___28663)){
args__5775__auto__.push((arguments[i__5770__auto___28664]));

var G__28665 = (i__5770__auto___28664 + (1));
i__5770__auto___28664 = G__28665;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28662){var e = e28662;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28661){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28661));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28668 = arguments.length;
var i__5770__auto___28669 = (0);
while(true){
if((i__5770__auto___28669 < len__5769__auto___28668)){
args__5775__auto__.push((arguments[i__5770__auto___28669]));

var G__28670 = (i__5770__auto___28669 + (1));
i__5770__auto___28669 = G__28670;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28667){var e = e28667;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28666){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28666));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28673 = arguments.length;
var i__5770__auto___28674 = (0);
while(true){
if((i__5770__auto___28674 < len__5769__auto___28673)){
args__5775__auto__.push((arguments[i__5770__auto___28674]));

var G__28675 = (i__5770__auto___28674 + (1));
i__5770__auto___28674 = G__28675;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28672){var e = e28672;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28671){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28671));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28678 = arguments.length;
var i__5770__auto___28679 = (0);
while(true){
if((i__5770__auto___28679 < len__5769__auto___28678)){
args__5775__auto__.push((arguments[i__5770__auto___28679]));

var G__28680 = (i__5770__auto___28679 + (1));
i__5770__auto___28679 = G__28680;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28677){var e = e28677;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28676){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28676));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28681){var e = e28681;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28682){var e = e28682;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28683){var e = e28683;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28684){var e = e28684;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28685){var e = e28685;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28691 = path;
var vec__28692 = G__28691;
var seq__28693 = cljs.core.seq(vec__28692);
var first__28694 = cljs.core.first(seq__28693);
var seq__28693__$1 = cljs.core.next(seq__28693);
var pred = first__28694;
var r = seq__28693__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28691__$1 = G__28691;
var subjects__$1 = subjects;
while(true){
var vec__28698 = G__28691__$1;
var seq__28699 = cljs.core.seq(vec__28698);
var first__28700 = cljs.core.first(seq__28699);
var seq__28699__$1 = cljs.core.next(seq__28699);
var pred__$1 = first__28700;
var r__$1 = seq__28699__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28691__$1,subjects__$1,vec__28698,seq__28699,first__28700,seq__28699__$1,pred__$1,r__$1,subjects__$2,G__28691,vec__28692,seq__28693,first__28694,seq__28693__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28691__$1,subjects__$1,vec__28698,seq__28699,first__28700,seq__28699__$1,pred__$1,r__$1,subjects__$2,G__28691,vec__28692,seq__28693,first__28694,seq__28693__$1,pred,r,subjects){
return (function (p1__28686_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28686_SHARP_,pred__$1);
});})(G__28691__$1,subjects__$1,vec__28698,seq__28699,first__28700,seq__28699__$1,pred__$1,r__$1,subjects__$2,G__28691,vec__28692,seq__28693,first__28694,seq__28693__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28691__$1,subjects__$1,vec__28698,seq__28699,first__28700,seq__28699__$1,pred__$1,r__$1,subjects__$2,G__28691,vec__28692,seq__28693,first__28694,seq__28693__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__28701 = r__$1;
var G__28702 = next_subjects;
G__28691__$1 = G__28701;
subjects__$1 = G__28702;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28687){var e = e28687;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),fluree.db.dbfunctions.internal.count(path))){
return path;
} else {
var r_path = cljs.core.reverse(path);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first(r_path),cljs.core.rest(r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28742){
var state_val_28743 = (state_28742[(1)]);
if((state_val_28743 === (7))){
var state_28742__$1 = state_28742;
var statearr_28744_28763 = state_28742__$1;
(statearr_28744_28763[(2)] = path);

(statearr_28744_28763[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28743 === (1))){
var state_28742__$1 = state_28742;
var statearr_28745_28764 = state_28742__$1;
(statearr_28745_28764[(2)] = null);

(statearr_28745_28764[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28743 === (4))){
var inst_28703 = (state_28742[(2)]);
var inst_28704 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28703,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([sid,path], 0));
var state_28742__$1 = state_28742;
var statearr_28746_28765 = state_28742__$1;
(statearr_28746_28765[(2)] = inst_28704);

(statearr_28746_28765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28743 === (6))){
var inst_28721 = (state_28742[(2)]);
var inst_28722 = fluree.db.util.async.throw_err(inst_28721);
var inst_28723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28722,(0),null);
var inst_28724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28722,(1),null);
var inst_28725 = cljs.core.last(path);
var inst_28726 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_28725);
var state_28742__$1 = (function (){var statearr_28747 = state_28742;
(statearr_28747[(7)] = inst_28723);

(statearr_28747[(8)] = inst_28724);

return statearr_28747;
})();
if(inst_28726){
var statearr_28748_28766 = state_28742__$1;
(statearr_28748_28766[(1)] = (7));

} else {
var statearr_28749_28767 = state_28742__$1;
(statearr_28749_28767[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28743 === (3))){
var inst_28740 = (state_28742[(2)]);
var state_28742__$1 = state_28742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28742__$1,inst_28740);
} else {
if((state_val_28743 === (2))){
var _ = (function (){var statearr_28751 = state_28742;
(statearr_28751[(4)] = cljs.core.cons((5),(state_28742[(4)])));

return statearr_28751;
})();
var inst_28713 = fluree.db.dbfunctions.internal.select_from_path(path);
var inst_28714 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28715 = cljs.core.PersistentHashMap.EMPTY;
var inst_28716 = [inst_28713,sid,inst_28715];
var inst_28717 = cljs.core.PersistentHashMap.fromArrays(inst_28714,inst_28716);
var inst_28718 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28719 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_28718,inst_28717);
var state_28742__$1 = state_28742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28742__$1,(6),inst_28719);
} else {
if((state_val_28743 === (9))){
var inst_28723 = (state_28742[(7)]);
var inst_28724 = (state_28742[(8)]);
var inst_28731 = (state_28742[(2)]);
var inst_28732 = fluree.db.dbfunctions.internal.get_all(inst_28723,inst_28731);
var inst_28733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28734 = fluree.db.dbfunctions.internal.count(path);
var inst_28735 = fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28724,inst_28734,(9)], 0));
var inst_28736 = [inst_28732,inst_28735];
var inst_28737 = (new cljs.core.PersistentVector(null,2,(5),inst_28733,inst_28736,null));
var _ = (function (){var statearr_28752 = state_28742;
(statearr_28752[(4)] = cljs.core.rest((state_28742[(4)])));

return statearr_28752;
})();
var state_28742__$1 = state_28742;
var statearr_28753_28768 = state_28742__$1;
(statearr_28753_28768[(2)] = inst_28737);

(statearr_28753_28768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28743 === (5))){
var _ = (function (){var statearr_28754 = state_28742;
(statearr_28754[(4)] = cljs.core.rest((state_28742[(4)])));

return statearr_28754;
})();
var state_28742__$1 = state_28742;
var ex28750 = (state_28742__$1[(2)]);
var statearr_28755_28769 = state_28742__$1;
(statearr_28755_28769[(5)] = ex28750);


var statearr_28756_28770 = state_28742__$1;
(statearr_28756_28770[(1)] = (4));

(statearr_28756_28770[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28743 === (8))){
var inst_28729 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(path,"_id");
var state_28742__$1 = state_28742;
var statearr_28757_28771 = state_28742__$1;
(statearr_28757_28771[(2)] = inst_28729);

(statearr_28757_28771[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0 = (function (){
var statearr_28758 = [null,null,null,null,null,null,null,null,null];
(statearr_28758[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__);

(statearr_28758[(1)] = (1));

return statearr_28758;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1 = (function (state_28742){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28742);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28759){var ex__2687__auto__ = e28759;
var statearr_28760_28772 = state_28742;
(statearr_28760_28772[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28742[(4)]))){
var statearr_28761_28773 = state_28742;
(statearr_28761_28773[(1)] = cljs.core.first((state_28742[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28774 = state_28742;
state_28742 = G__28774;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__ = function(state_28742){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1.call(this,state_28742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28762 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28762[(6)] = c__2706__auto__);

return statearr_28762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28775){var e = e28775;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_(key)){
return cljs.core.some((function (p1__28776_SHARP_){
return (fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.dbfunctions.internal.contains_QMARK_.cljs$core$IFn$_invoke$arity$2(coll,p1__28776_SHARP_) : fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__28776_SHARP_));
}),key);
} else {
return cljs.core.contains_QMARK_(coll,key);
}
}catch (e28777){var e = e28777;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28780 = arguments.length;
var i__5770__auto___28781 = (0);
while(true){
if((i__5770__auto___28781 < len__5769__auto___28780)){
args__5775__auto__.push((arguments[i__5770__auto___28781]));

var G__28782 = (i__5770__auto___28781 + (1));
i__5770__auto___28781 = G__28782;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e28779){var e = e28779;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28778){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28778));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e28783){var e = e28783;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28786 = arguments.length;
var i__5770__auto___28787 = (0);
while(true){
if((i__5770__auto___28787 < len__5769__auto___28786)){
args__5775__auto__.push((arguments[i__5770__auto___28787]));

var G__28788 = (i__5770__auto___28787 + (1));
i__5770__auto___28787 = G__28788;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e28785){var e = e28785;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28784){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28784));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e28789){var e = e28789;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28846){
var state_val_28847 = (state_28846[(1)]);
if((state_val_28847 === (7))){
var inst_28792 = (state_28846[(2)]);
var state_28846__$1 = state_28846;
var statearr_28848_28882 = state_28846__$1;
(statearr_28848_28882[(2)] = inst_28792);

(statearr_28848_28882[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (1))){
var state_28846__$1 = state_28846;
var statearr_28849_28883 = state_28846__$1;
(statearr_28849_28883[(2)] = null);

(statearr_28849_28883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (4))){
var inst_28791 = (state_28846[(2)]);
var state_28846__$1 = (function (){var statearr_28850 = state_28846;
(statearr_28850[(7)] = inst_28791);

return statearr_28850;
})();
var statearr_28851_28884 = state_28846__$1;
(statearr_28851_28884[(2)] = null);

(statearr_28851_28884[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (15))){
var inst_28816 = (state_28846[(8)]);
var inst_28826 = (state_28846[(9)]);
var inst_28814 = (state_28846[(10)]);
var inst_28817 = (state_28846[(11)]);
var inst_28829 = (state_28846[(12)]);
var inst_28827 = (state_28846[(13)]);
var inst_28833 = (function (){var db = inst_28814;
var prevT = inst_28816;
var db_SINGLEQUOTE_ = inst_28817;
var prev_vals = inst_28826;
var fuel = inst_28827;
var G__28828 = inst_28829;
return (function (p1__28790_SHARP_){
var f = p1__28790_SHARP_;
return fluree.db.flake.o(f);
});
})();
var inst_28834 = (inst_28833.cljs$core$IFn$_invoke$arity$1 ? inst_28833.cljs$core$IFn$_invoke$arity$1(inst_28829) : inst_28833.call(null,inst_28829));
var state_28846__$1 = state_28846;
var statearr_28852_28885 = state_28846__$1;
(statearr_28852_28885[(2)] = inst_28834);

(statearr_28852_28885[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (13))){
var inst_28826 = (state_28846[(9)]);
var inst_28829 = (state_28846[(12)]);
var inst_28825 = (state_28846[(2)]);
var inst_28826__$1 = fluree.db.util.async.throw_err(inst_28825);
var inst_28827 = fluree.db.dbfunctions.internal.count(inst_28826__$1);
var inst_28829__$1 = cljs.core.first(inst_28826__$1);
var inst_28830 = (inst_28829__$1 == null);
var state_28846__$1 = (function (){var statearr_28853 = state_28846;
(statearr_28853[(9)] = inst_28826__$1);

(statearr_28853[(12)] = inst_28829__$1);

(statearr_28853[(13)] = inst_28827);

return statearr_28853;
})();
if(cljs.core.truth_(inst_28830)){
var statearr_28854_28886 = state_28846__$1;
(statearr_28854_28886[(1)] = (14));

} else {
var statearr_28855_28887 = state_28846__$1;
(statearr_28855_28887[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (6))){
var inst_28801 = (state_28846[(2)]);
var state_28846__$1 = state_28846;
var statearr_28856_28888 = state_28846__$1;
(statearr_28856_28888[(2)] = inst_28801);

(statearr_28856_28888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (3))){
var inst_28844 = (state_28846[(2)]);
var state_28846__$1 = state_28846;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28846__$1,inst_28844);
} else {
if((state_val_28847 === (12))){
var inst_28841 = (state_28846[(2)]);
var _ = (function (){var statearr_28857 = state_28846;
(statearr_28857[(4)] = cljs.core.rest((state_28846[(4)])));

return statearr_28857;
})();
var state_28846__$1 = state_28846;
var statearr_28858_28889 = state_28846__$1;
(statearr_28858_28889[(2)] = inst_28841);

(statearr_28858_28889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (2))){
var _ = (function (){var statearr_28860 = state_28846;
(statearr_28860[(4)] = cljs.core.cons((9),(state_28846[(4)])));

return statearr_28860;
})();
var inst_28807 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28808 = typeof inst_28807 === 'string';
var state_28846__$1 = state_28846;
if(cljs.core.truth_(inst_28808)){
var statearr_28861_28890 = state_28846__$1;
(statearr_28861_28890[(1)] = (10));

} else {
var statearr_28862_28891 = state_28846__$1;
(statearr_28862_28891[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (11))){
var inst_28816 = (state_28846[(8)]);
var inst_28814 = (state_28846[(10)]);
var inst_28817 = (state_28846[(11)]);
var inst_28814__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28815 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28814__$1);
var inst_28816__$1 = fluree.db.dbfunctions.internal.inc(inst_28815);
var inst_28817__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28814__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28816__$1);
var inst_28818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28819 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28820 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28821 = [inst_28819,inst_28820];
var inst_28822 = (new cljs.core.PersistentVector(null,2,(5),inst_28818,inst_28821,null));
var inst_28823 = fluree.db.dbproto._search(inst_28817__$1,inst_28822);
var state_28846__$1 = (function (){var statearr_28863 = state_28846;
(statearr_28863[(8)] = inst_28816__$1);

(statearr_28863[(10)] = inst_28814__$1);

(statearr_28863[(11)] = inst_28817__$1);

return statearr_28863;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28846__$1,(13),inst_28823);
} else {
if((state_val_28847 === (9))){
var _ = (function (){var statearr_28864 = state_28846;
(statearr_28864[(4)] = cljs.core.rest((state_28846[(4)])));

return statearr_28864;
})();
var state_28846__$1 = state_28846;
var ex28859 = (state_28846__$1[(2)]);
var statearr_28865_28892 = state_28846__$1;
(statearr_28865_28892[(5)] = ex28859);


var statearr_28866_28893 = state_28846__$1;
(statearr_28866_28893[(1)] = (4));

(statearr_28866_28893[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (5))){
var inst_28791 = (state_28846[(7)]);
var _ = (function (){var statearr_28867 = state_28846;
(statearr_28867[(4)] = cljs.core.cons((8),(state_28846[(4)])));

return statearr_28867;
})();
var inst_28798 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28791,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_28868 = state_28846;
(statearr_28868[(4)] = cljs.core.rest((state_28846[(4)])));

return statearr_28868;
})();
var state_28846__$1 = state_28846;
var statearr_28869_28894 = state_28846__$1;
(statearr_28869_28894[(2)] = inst_28798);

(statearr_28869_28894[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (14))){
var state_28846__$1 = state_28846;
var statearr_28870_28895 = state_28846__$1;
(statearr_28870_28895[(2)] = null);

(statearr_28870_28895[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (16))){
var inst_28827 = (state_28846[(13)]);
var inst_28836 = (state_28846[(2)]);
var inst_28837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28838 = [inst_28836,inst_28827];
var inst_28839 = (new cljs.core.PersistentVector(null,2,(5),inst_28837,inst_28838,null));
var state_28846__$1 = state_28846;
var statearr_28872_28896 = state_28846__$1;
(statearr_28872_28896[(2)] = inst_28839);

(statearr_28872_28896[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (10))){
var inst_28810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28811 = [null,(0)];
var inst_28812 = (new cljs.core.PersistentVector(null,2,(5),inst_28810,inst_28811,null));
var state_28846__$1 = state_28846;
var statearr_28873_28897 = state_28846__$1;
(statearr_28873_28897[(2)] = inst_28812);

(statearr_28873_28897[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28847 === (8))){
var _ = (function (){var statearr_28874 = state_28846;
(statearr_28874[(4)] = cljs.core.rest((state_28846[(4)])));

return statearr_28874;
})();
var state_28846__$1 = state_28846;
var ex28871 = (state_28846__$1[(2)]);
var statearr_28875_28898 = state_28846__$1;
(statearr_28875_28898[(5)] = ex28871);


var statearr_28876_28899 = state_28846__$1;
(statearr_28876_28899[(1)] = (7));

(statearr_28876_28899[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0 = (function (){
var statearr_28877 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28877[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__);

(statearr_28877[(1)] = (1));

return statearr_28877;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1 = (function (state_28846){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28846);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28878){var ex__2687__auto__ = e28878;
var statearr_28879_28900 = state_28846;
(statearr_28879_28900[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28846[(4)]))){
var statearr_28880_28901 = state_28846;
(statearr_28880_28901[(1)] = cljs.core.first((state_28846[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28902 = state_28846;
state_28846 = G__28902;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__ = function(state_28846){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1.call(this,state_28846);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28881 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28881[(6)] = c__2706__auto__);

return statearr_28881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_28954){
var state_val_28955 = (state_28954[(1)]);
if((state_val_28955 === (7))){
var inst_28904 = (state_28954[(2)]);
var state_28954__$1 = state_28954;
var statearr_28956_28985 = state_28954__$1;
(statearr_28956_28985[(2)] = inst_28904);

(statearr_28956_28985[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (1))){
var state_28954__$1 = state_28954;
var statearr_28957_28986 = state_28954__$1;
(statearr_28957_28986[(2)] = null);

(statearr_28957_28986[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (4))){
var inst_28903 = (state_28954[(2)]);
var state_28954__$1 = (function (){var statearr_28958 = state_28954;
(statearr_28958[(7)] = inst_28903);

return statearr_28958;
})();
var statearr_28959_28987 = state_28954__$1;
(statearr_28959_28987[(2)] = null);

(statearr_28959_28987[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (13))){
var inst_28949 = (state_28954[(2)]);
var _ = (function (){var statearr_28960 = state_28954;
(statearr_28960[(4)] = cljs.core.rest((state_28954[(4)])));

return statearr_28960;
})();
var state_28954__$1 = state_28954;
var statearr_28961_28988 = state_28954__$1;
(statearr_28961_28988[(2)] = inst_28949);

(statearr_28961_28988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (6))){
var inst_28913 = (state_28954[(2)]);
var state_28954__$1 = state_28954;
var statearr_28962_28989 = state_28954__$1;
(statearr_28962_28989[(2)] = inst_28913);

(statearr_28962_28989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (3))){
var inst_28952 = (state_28954[(2)]);
var state_28954__$1 = state_28954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28954__$1,inst_28952);
} else {
if((state_val_28955 === (12))){
var inst_28936 = (state_28954[(8)]);
var inst_28945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28946 = [null,inst_28936];
var inst_28947 = (new cljs.core.PersistentVector(null,2,(5),inst_28945,inst_28946,null));
var state_28954__$1 = state_28954;
var statearr_28963_28990 = state_28954__$1;
(statearr_28963_28990[(2)] = inst_28947);

(statearr_28963_28990[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (2))){
var _ = (function (){var statearr_28965 = state_28954;
(statearr_28965[(4)] = cljs.core.cons((9),(state_28954[(4)])));

return statearr_28965;
})();
var inst_28922 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28925 = [null,pred_name,"?o"];
var inst_28926 = (new cljs.core.PersistentVector(null,3,(5),inst_28924,inst_28925,null));
var inst_28927 = [inst_28926];
var inst_28928 = (new cljs.core.PersistentVector(null,1,(5),inst_28923,inst_28927,null));
var inst_28929 = ["?o",inst_28928,opts];
var inst_28930 = cljs.core.PersistentHashMap.fromArrays(inst_28922,inst_28929);
var inst_28931 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28930);
var state_28954__$1 = state_28954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28954__$1,(10),inst_28931);
} else {
if((state_val_28955 === (11))){
var inst_28935 = (state_28954[(9)]);
var inst_28936 = (state_28954[(8)]);
var inst_28940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28941 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_28935);
var inst_28942 = [inst_28941,inst_28936];
var inst_28943 = (new cljs.core.PersistentVector(null,2,(5),inst_28940,inst_28942,null));
var state_28954__$1 = state_28954;
var statearr_28966_28991 = state_28954__$1;
(statearr_28966_28991[(2)] = inst_28943);

(statearr_28966_28991[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (9))){
var _ = (function (){var statearr_28967 = state_28954;
(statearr_28967[(4)] = cljs.core.rest((state_28954[(4)])));

return statearr_28967;
})();
var state_28954__$1 = state_28954;
var ex28964 = (state_28954__$1[(2)]);
var statearr_28968_28992 = state_28954__$1;
(statearr_28968_28992[(5)] = ex28964);


var statearr_28969_28993 = state_28954__$1;
(statearr_28969_28993[(1)] = (4));

(statearr_28969_28993[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (5))){
var inst_28903 = (state_28954[(7)]);
var _ = (function (){var statearr_28971 = state_28954;
(statearr_28971[(4)] = cljs.core.cons((8),(state_28954[(4)])));

return statearr_28971;
})();
var inst_28910 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28903,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_28972 = state_28954;
(statearr_28972[(4)] = cljs.core.rest((state_28954[(4)])));

return statearr_28972;
})();
var state_28954__$1 = state_28954;
var statearr_28973_28994 = state_28954__$1;
(statearr_28973_28994[(2)] = inst_28910);

(statearr_28973_28994[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (10))){
var inst_28935 = (state_28954[(9)]);
var inst_28933 = (state_28954[(2)]);
var inst_28934 = fluree.db.util.async.throw_err(inst_28933);
var inst_28935__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28934,(0),null);
var inst_28936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28934,(1),null);
var inst_28937 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_28935__$1);
var inst_28938 = cljs.core.not(inst_28937);
var state_28954__$1 = (function (){var statearr_28974 = state_28954;
(statearr_28974[(9)] = inst_28935__$1);

(statearr_28974[(8)] = inst_28936);

return statearr_28974;
})();
if(inst_28938){
var statearr_28975_28995 = state_28954__$1;
(statearr_28975_28995[(1)] = (11));

} else {
var statearr_28976_28996 = state_28954__$1;
(statearr_28976_28996[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28955 === (8))){
var _ = (function (){var statearr_28977 = state_28954;
(statearr_28977[(4)] = cljs.core.rest((state_28954[(4)])));

return statearr_28977;
})();
var state_28954__$1 = state_28954;
var ex28970 = (state_28954__$1[(2)]);
var statearr_28978_28997 = state_28954__$1;
(statearr_28978_28997[(5)] = ex28970);


var statearr_28979_28998 = state_28954__$1;
(statearr_28979_28998[(1)] = (7));

(statearr_28979_28998[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0 = (function (){
var statearr_28980 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28980[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__);

(statearr_28980[(1)] = (1));

return statearr_28980;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1 = (function (state_28954){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_28954);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e28981){var ex__2687__auto__ = e28981;
var statearr_28982_28999 = state_28954;
(statearr_28982_28999[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_28954[(4)]))){
var statearr_28983_29000 = state_28954;
(statearr_28983_29000[(1)] = cljs.core.first((state_28954[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29001 = state_28954;
state_28954 = G__29001;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__ = function(state_28954){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1.call(this,state_28954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_28984 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_28984[(6)] = c__2706__auto__);

return statearr_28984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e29002){var e = e29002;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29004 = arguments.length;
switch (G__29004) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29074){
var state_val_29075 = (state_29074[(1)]);
if((state_val_29075 === (7))){
var inst_29006 = (state_29074[(2)]);
var state_29074__$1 = state_29074;
var statearr_29076_29120 = state_29074__$1;
(statearr_29076_29120[(2)] = inst_29006);

(statearr_29076_29120[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (20))){
var inst_29050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29051 = ["*"];
var inst_29052 = (new cljs.core.PersistentVector(null,1,(5),inst_29050,inst_29051,null));
var state_29074__$1 = state_29074;
var statearr_29077_29121 = state_29074__$1;
(statearr_29077_29121[(2)] = inst_29052);

(statearr_29077_29121[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (1))){
var state_29074__$1 = state_29074;
var statearr_29078_29122 = state_29074__$1;
(statearr_29078_29122[(2)] = null);

(statearr_29078_29122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (4))){
var inst_29005 = (state_29074[(2)]);
var state_29074__$1 = (function (){var statearr_29079 = state_29074;
(statearr_29079[(7)] = inst_29005);

return statearr_29079;
})();
var statearr_29080_29123 = state_29074__$1;
(statearr_29080_29123[(2)] = null);

(statearr_29080_29123[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (15))){
var inst_29069 = (state_29074[(2)]);
var _ = (function (){var statearr_29081 = state_29074;
(statearr_29081[(4)] = cljs.core.rest((state_29074[(4)])));

return statearr_29081;
})();
var state_29074__$1 = state_29074;
var statearr_29082_29124 = state_29074__$1;
(statearr_29082_29124[(2)] = inst_29069);

(statearr_29082_29124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (21))){
var inst_29040 = (state_29074[(8)]);
var inst_29033 = (state_29074[(9)]);
var inst_29054 = (state_29074[(2)]);
var inst_29055 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29056 = cljs.core.PersistentHashMap.EMPTY;
var inst_29057 = [inst_29054,inst_29040,inst_29056];
var inst_29058 = cljs.core.PersistentHashMap.fromArrays(inst_29055,inst_29057);
var inst_29059 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29033,inst_29058);
var state_29074__$1 = state_29074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29074__$1,(22),inst_29059);
} else {
if((state_val_29075 === (13))){
var inst_29028 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29074__$1 = state_29074;
var statearr_29083_29125 = state_29074__$1;
(statearr_29083_29125[(2)] = inst_29028);

(statearr_29083_29125[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (22))){
var inst_29061 = (state_29074[(2)]);
var inst_29062 = fluree.db.util.async.throw_err(inst_29061);
var inst_29063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29062,(0),null);
var inst_29064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29062,(1),null);
var inst_29065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29066 = [inst_29063,inst_29064];
var inst_29067 = (new cljs.core.PersistentVector(null,2,(5),inst_29065,inst_29066,null));
var state_29074__$1 = state_29074;
var statearr_29084_29126 = state_29074__$1;
(statearr_29084_29126[(2)] = inst_29067);

(statearr_29084_29126[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (6))){
var inst_29015 = (state_29074[(2)]);
var state_29074__$1 = state_29074;
var statearr_29085_29127 = state_29074__$1;
(statearr_29085_29127[(2)] = inst_29015);

(statearr_29085_29127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (17))){
var inst_29037 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29038 = fluree.db.dbfunctions.internal.get(inst_29037,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29074__$1 = state_29074;
var statearr_29086_29128 = state_29074__$1;
(statearr_29086_29128[(2)] = inst_29038);

(statearr_29086_29128[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (3))){
var inst_29072 = (state_29074[(2)]);
var state_29074__$1 = state_29074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29074__$1,inst_29072);
} else {
if((state_val_29075 === (12))){
var inst_29026 = (state_29074[(2)]);
var state_29074__$1 = state_29074;
if(cljs.core.truth_(inst_29026)){
var statearr_29087_29129 = state_29074__$1;
(statearr_29087_29129[(1)] = (13));

} else {
var statearr_29088_29130 = state_29074__$1;
(statearr_29088_29130[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (2))){
var inst_29021 = (state_29074[(10)]);
var _ = (function (){var statearr_29089 = state_29074;
(statearr_29089[(4)] = cljs.core.cons((9),(state_29074[(4)])));

return statearr_29089;
})();
var inst_29021__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29074__$1 = (function (){var statearr_29090 = state_29074;
(statearr_29090[(10)] = inst_29021__$1);

return statearr_29090;
})();
if(cljs.core.truth_(inst_29021__$1)){
var statearr_29091_29131 = state_29074__$1;
(statearr_29091_29131[(1)] = (10));

} else {
var statearr_29092_29132 = state_29074__$1;
(statearr_29092_29132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (19))){
var inst_29042 = cljs.core.PersistentVector.EMPTY;
var inst_29043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29044 = ["*"];
var inst_29045 = (new cljs.core.PersistentVector(null,1,(5),inst_29043,inst_29044,null));
var inst_29046 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29047 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29045,inst_29046);
var inst_29048 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29042,inst_29047);
var state_29074__$1 = state_29074;
var statearr_29094_29133 = state_29074__$1;
(statearr_29094_29133[(2)] = inst_29048);

(statearr_29094_29133[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (11))){
var inst_29021 = (state_29074[(10)]);
var state_29074__$1 = state_29074;
var statearr_29095_29134 = state_29074__$1;
(statearr_29095_29134[(2)] = inst_29021);

(statearr_29095_29134[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (9))){
var _ = (function (){var statearr_29096 = state_29074;
(statearr_29096[(4)] = cljs.core.rest((state_29074[(4)])));

return statearr_29096;
})();
var state_29074__$1 = state_29074;
var ex29093 = (state_29074__$1[(2)]);
var statearr_29097_29135 = state_29074__$1;
(statearr_29097_29135[(5)] = ex29093);


var statearr_29098_29136 = state_29074__$1;
(statearr_29098_29136[(1)] = (4));

(statearr_29098_29136[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (5))){
var inst_29005 = (state_29074[(7)]);
var _ = (function (){var statearr_29099 = state_29074;
(statearr_29099[(4)] = cljs.core.cons((8),(state_29074[(4)])));

return statearr_29099;
})();
var inst_29012 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29005,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29100 = state_29074;
(statearr_29100[(4)] = cljs.core.rest((state_29074[(4)])));

return statearr_29100;
})();
var state_29074__$1 = state_29074;
var statearr_29101_29137 = state_29074__$1;
(statearr_29101_29137[(2)] = inst_29012);

(statearr_29101_29137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (14))){
var inst_29034 = (state_29074[(11)]);
var inst_29033 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29034__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29074__$1 = (function (){var statearr_29102 = state_29074;
(statearr_29102[(11)] = inst_29034__$1);

(statearr_29102[(9)] = inst_29033);

return statearr_29102;
})();
if(cljs.core.truth_(inst_29034__$1)){
var statearr_29103_29138 = state_29074__$1;
(statearr_29103_29138[(1)] = (16));

} else {
var statearr_29104_29139 = state_29074__$1;
(statearr_29104_29139[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (16))){
var inst_29034 = (state_29074[(11)]);
var state_29074__$1 = state_29074;
var statearr_29105_29140 = state_29074__$1;
(statearr_29105_29140[(2)] = inst_29034);

(statearr_29105_29140[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (10))){
var inst_29023 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29074__$1 = state_29074;
var statearr_29107_29141 = state_29074__$1;
(statearr_29107_29141[(2)] = inst_29023);

(statearr_29107_29141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (18))){
var inst_29040 = (state_29074[(2)]);
var state_29074__$1 = (function (){var statearr_29108 = state_29074;
(statearr_29108[(8)] = inst_29040);

return statearr_29108;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29109_29142 = state_29074__$1;
(statearr_29109_29142[(1)] = (19));

} else {
var statearr_29110_29143 = state_29074__$1;
(statearr_29110_29143[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29075 === (8))){
var _ = (function (){var statearr_29111 = state_29074;
(statearr_29111[(4)] = cljs.core.rest((state_29074[(4)])));

return statearr_29111;
})();
var state_29074__$1 = state_29074;
var ex29106 = (state_29074__$1[(2)]);
var statearr_29112_29144 = state_29074__$1;
(statearr_29112_29144[(5)] = ex29106);


var statearr_29113_29145 = state_29074__$1;
(statearr_29113_29145[(1)] = (7));

(statearr_29113_29145[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_29114 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29114[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_29114[(1)] = (1));

return statearr_29114;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_29074){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29074);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29115){var ex__2687__auto__ = e29115;
var statearr_29116_29146 = state_29074;
(statearr_29116_29146[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29074[(4)]))){
var statearr_29117_29147 = state_29074;
(statearr_29117_29147[(1)] = cljs.core.first((state_29074[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29148 = state_29074;
state_29074 = G__29148;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_29074){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_29074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29118 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29118[(6)] = c__2706__auto__);

return statearr_29118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29150 = arguments.length;
switch (G__29150) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29194){
var state_val_29195 = (state_29194[(1)]);
if((state_val_29195 === (7))){
var inst_29172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29173 = ["*"];
var inst_29174 = (new cljs.core.PersistentVector(null,1,(5),inst_29172,inst_29173,null));
var state_29194__$1 = state_29194;
var statearr_29196_29216 = state_29194__$1;
(statearr_29196_29216[(2)] = inst_29174);

(statearr_29196_29216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (1))){
var state_29194__$1 = state_29194;
var statearr_29197_29217 = state_29194__$1;
(statearr_29197_29217[(2)] = null);

(statearr_29197_29217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (4))){
var inst_29151 = (state_29194[(2)]);
var inst_29152 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29151,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29194__$1 = state_29194;
var statearr_29198_29218 = state_29194__$1;
(statearr_29198_29218[(2)] = inst_29152);

(statearr_29198_29218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (6))){
var inst_29164 = cljs.core.PersistentVector.EMPTY;
var inst_29165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29166 = ["*"];
var inst_29167 = (new cljs.core.PersistentVector(null,1,(5),inst_29165,inst_29166,null));
var inst_29168 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29169 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29167,inst_29168);
var inst_29170 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29164,inst_29169);
var state_29194__$1 = state_29194;
var statearr_29199_29219 = state_29194__$1;
(statearr_29199_29219[(2)] = inst_29170);

(statearr_29199_29219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (3))){
var inst_29192 = (state_29194[(2)]);
var state_29194__$1 = state_29194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29194__$1,inst_29192);
} else {
if((state_val_29195 === (2))){
var _ = (function (){var statearr_29201 = state_29194;
(statearr_29201[(4)] = cljs.core.cons((5),(state_29194[(4)])));

return statearr_29201;
})();
var inst_29161 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29162 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29194__$1 = (function (){var statearr_29202 = state_29194;
(statearr_29202[(7)] = inst_29161);

(statearr_29202[(8)] = inst_29162);

return statearr_29202;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29203_29220 = state_29194__$1;
(statearr_29203_29220[(1)] = (6));

} else {
var statearr_29204_29221 = state_29194__$1;
(statearr_29204_29221[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (9))){
var inst_29183 = (state_29194[(2)]);
var inst_29184 = fluree.db.util.async.throw_err(inst_29183);
var inst_29185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29184,(0),null);
var inst_29186 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29184,(1),null);
var inst_29187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29188 = [inst_29185,inst_29186];
var inst_29189 = (new cljs.core.PersistentVector(null,2,(5),inst_29187,inst_29188,null));
var _ = (function (){var statearr_29205 = state_29194;
(statearr_29205[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29205;
})();
var state_29194__$1 = state_29194;
var statearr_29206_29222 = state_29194__$1;
(statearr_29206_29222[(2)] = inst_29189);

(statearr_29206_29222[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (5))){
var _ = (function (){var statearr_29207 = state_29194;
(statearr_29207[(4)] = cljs.core.rest((state_29194[(4)])));

return statearr_29207;
})();
var state_29194__$1 = state_29194;
var ex29200 = (state_29194__$1[(2)]);
var statearr_29208_29223 = state_29194__$1;
(statearr_29208_29223[(5)] = ex29200);


var statearr_29209_29224 = state_29194__$1;
(statearr_29209_29224[(1)] = (4));

(statearr_29209_29224[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29195 === (8))){
var inst_29161 = (state_29194[(7)]);
var inst_29162 = (state_29194[(8)]);
var inst_29176 = (state_29194[(2)]);
var inst_29177 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29178 = cljs.core.PersistentHashMap.EMPTY;
var inst_29179 = [inst_29176,inst_29162,inst_29178];
var inst_29180 = cljs.core.PersistentHashMap.fromArrays(inst_29177,inst_29179);
var inst_29181 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29161,inst_29180);
var state_29194__$1 = state_29194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29194__$1,(9),inst_29181);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2684__auto____0 = (function (){
var statearr_29210 = [null,null,null,null,null,null,null,null,null];
(statearr_29210[(0)] = fluree$db$dbfunctions$internal$state_machine__2684__auto__);

(statearr_29210[(1)] = (1));

return statearr_29210;
});
var fluree$db$dbfunctions$internal$state_machine__2684__auto____1 = (function (state_29194){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29194);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29211){var ex__2687__auto__ = e29211;
var statearr_29212_29225 = state_29194;
(statearr_29212_29225[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29194[(4)]))){
var statearr_29213_29226 = state_29194;
(statearr_29213_29226[(1)] = cljs.core.first((state_29194[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29227 = state_29194;
state_29194 = G__29227;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2684__auto__ = function(state_29194){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2684__auto____1.call(this,state_29194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29214 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29214[(6)] = c__2706__auto__);

return statearr_29214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29271){
var state_val_29272 = (state_29271[(1)]);
if((state_val_29272 === (1))){
var state_29271__$1 = state_29271;
var statearr_29273_29287 = state_29271__$1;
(statearr_29273_29287[(2)] = null);

(statearr_29273_29287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29272 === (2))){
var _ = (function (){var statearr_29274 = state_29271;
(statearr_29274[(4)] = cljs.core.cons((5),(state_29271[(4)])));

return statearr_29274;
})();
var inst_29238 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29240 = ["_user/_auth"];
var inst_29241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29242 = ["*"];
var inst_29243 = (new cljs.core.PersistentVector(null,1,(5),inst_29241,inst_29242,null));
var inst_29244 = [inst_29243];
var inst_29245 = cljs.core.PersistentHashMap.fromArrays(inst_29240,inst_29244);
var inst_29246 = [inst_29245];
var inst_29247 = (new cljs.core.PersistentVector(null,1,(5),inst_29239,inst_29246,null));
var inst_29248 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29249 = cljs.core.PersistentHashMap.EMPTY;
var inst_29250 = [inst_29247,inst_29248,inst_29249];
var inst_29251 = cljs.core.PersistentHashMap.fromArrays(inst_29238,inst_29250);
var inst_29252 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29253 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29252,inst_29251);
var state_29271__$1 = state_29271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29271__$1,(6),inst_29253);
} else {
if((state_val_29272 === (3))){
var inst_29269 = (state_29271[(2)]);
var state_29271__$1 = state_29271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29271__$1,inst_29269);
} else {
if((state_val_29272 === (4))){
var inst_29228 = (state_29271[(2)]);
var inst_29229 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29228,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29271__$1 = state_29271;
var statearr_29276_29288 = state_29271__$1;
(statearr_29276_29288[(2)] = inst_29229);

(statearr_29276_29288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29272 === (5))){
var _ = (function (){var statearr_29277 = state_29271;
(statearr_29277[(4)] = cljs.core.rest((state_29271[(4)])));

return statearr_29277;
})();
var state_29271__$1 = state_29271;
var ex29275 = (state_29271__$1[(2)]);
var statearr_29278_29289 = state_29271__$1;
(statearr_29278_29289[(5)] = ex29275);


var statearr_29279_29290 = state_29271__$1;
(statearr_29279_29290[(1)] = (4));

(statearr_29279_29290[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29272 === (6))){
var inst_29255 = (state_29271[(2)]);
var inst_29256 = fluree.db.util.async.throw_err(inst_29255);
var inst_29257 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29256,(0),null);
var inst_29258 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29256,(1),null);
var inst_29259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29260 = ["_user/_auth","_id"];
var inst_29261 = (new cljs.core.PersistentVector(null,2,(5),inst_29259,inst_29260,null));
var inst_29262 = fluree.db.dbfunctions.internal.get_in(inst_29257,inst_29261);
var inst_29263 = cljs.core.first(inst_29262);
var inst_29264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29265 = [inst_29263,inst_29258];
var inst_29266 = (new cljs.core.PersistentVector(null,2,(5),inst_29264,inst_29265,null));
var _ = (function (){var statearr_29280 = state_29271;
(statearr_29280[(4)] = cljs.core.rest((state_29271[(4)])));

return statearr_29280;
})();
var state_29271__$1 = state_29271;
var statearr_29281_29291 = state_29271__$1;
(statearr_29281_29291[(2)] = inst_29266);

(statearr_29281_29291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0 = (function (){
var statearr_29282 = [null,null,null,null,null,null,null];
(statearr_29282[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__);

(statearr_29282[(1)] = (1));

return statearr_29282;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1 = (function (state_29271){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29271);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29283){var ex__2687__auto__ = e29283;
var statearr_29284_29292 = state_29271;
(statearr_29284_29292[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29271[(4)]))){
var statearr_29285_29293 = state_29271;
(statearr_29285_29293[(1)] = cljs.core.first((state_29271[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29294 = state_29271;
state_29271 = G__29294;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__ = function(state_29271){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1.call(this,state_29271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29286 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29286[(6)] = c__2706__auto__);

return statearr_29286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29316){
var state_val_29317 = (state_29316[(1)]);
if((state_val_29317 === (7))){
var inst_29301 = (state_29316[(7)]);
var inst_29305 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29306 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29305,inst_29301);
var state_29316__$1 = state_29316;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29316__$1,(9),inst_29306);
} else {
if((state_val_29317 === (1))){
var state_29316__$1 = state_29316;
var statearr_29318_29337 = state_29316__$1;
(statearr_29318_29337[(2)] = null);

(statearr_29318_29337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (4))){
var inst_29295 = (state_29316[(2)]);
var state_29316__$1 = state_29316;
var statearr_29319_29338 = state_29316__$1;
(statearr_29319_29338[(2)] = inst_29295);

(statearr_29319_29338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (6))){
var inst_29301 = (state_29316[(7)]);
var state_29316__$1 = state_29316;
var statearr_29320_29339 = state_29316__$1;
(statearr_29320_29339[(2)] = inst_29301);

(statearr_29320_29339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (3))){
var inst_29314 = (state_29316[(2)]);
var state_29316__$1 = state_29316;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29316__$1,inst_29314);
} else {
if((state_val_29317 === (2))){
var inst_29301 = (state_29316[(7)]);
var _ = (function (){var statearr_29322 = state_29316;
(statearr_29322[(4)] = cljs.core.cons((5),(state_29316[(4)])));

return statearr_29322;
})();
var inst_29301__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29302 = typeof inst_29301__$1 === 'number';
var state_29316__$1 = (function (){var statearr_29323 = state_29316;
(statearr_29323[(7)] = inst_29301__$1);

return statearr_29323;
})();
if(cljs.core.truth_(inst_29302)){
var statearr_29324_29340 = state_29316__$1;
(statearr_29324_29340[(1)] = (6));

} else {
var statearr_29325_29341 = state_29316__$1;
(statearr_29325_29341[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (9))){
var inst_29308 = (state_29316[(2)]);
var inst_29309 = fluree.db.util.async.throw_err(inst_29308);
var state_29316__$1 = state_29316;
var statearr_29326_29342 = state_29316__$1;
(statearr_29326_29342[(2)] = inst_29309);

(statearr_29326_29342[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (5))){
var _ = (function (){var statearr_29327 = state_29316;
(statearr_29327[(4)] = cljs.core.rest((state_29316[(4)])));

return statearr_29327;
})();
var state_29316__$1 = state_29316;
var ex29321 = (state_29316__$1[(2)]);
var statearr_29328_29343 = state_29316__$1;
(statearr_29328_29343[(5)] = ex29321);


if((ex29321 instanceof Error)){
var statearr_29329_29344 = state_29316__$1;
(statearr_29329_29344[(1)] = (4));

(statearr_29329_29344[(5)] = null);

} else {
throw ex29321;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29317 === (8))){
var inst_29311 = (state_29316[(2)]);
var _ = (function (){var statearr_29330 = state_29316;
(statearr_29330[(4)] = cljs.core.rest((state_29316[(4)])));

return statearr_29330;
})();
var state_29316__$1 = state_29316;
var statearr_29331_29345 = state_29316__$1;
(statearr_29331_29345[(2)] = inst_29311);

(statearr_29331_29345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0 = (function (){
var statearr_29332 = [null,null,null,null,null,null,null,null];
(statearr_29332[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__);

(statearr_29332[(1)] = (1));

return statearr_29332;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1 = (function (state_29316){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29316);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29333){var ex__2687__auto__ = e29333;
var statearr_29334_29346 = state_29316;
(statearr_29334_29346[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29316[(4)]))){
var statearr_29335_29347 = state_29316;
(statearr_29335_29347[(1)] = cljs.core.first((state_29316[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29348 = state_29316;
state_29316 = G__29348;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__ = function(state_29316){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1.call(this,state_29316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29336 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29336[(6)] = c__2706__auto__);

return statearr_29336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29349_SHARP_){
return fluree.db.flake.op(p1__29349_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29350_SHARP_){
return fluree.db.flake.o(p1__29350_SHARP_);
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29351){var e = e29351;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29352_SHARP_){
return fluree.db.flake.op(p1__29352_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29353_SHARP_){
return fluree.db.flake.o(p1__29353_SHARP_);
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29354){var e = e29354;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29356 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29356);
})() | (0));
return num;
}catch (e29355){var e = e29355;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_29436){
var state_val_29437 = (state_29436[(1)]);
if((state_val_29437 === (7))){
var inst_29375 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29376 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29377 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29378 = cljs.core.PersistentHashMap.fromArrays(inst_29376,inst_29377);
var inst_29379 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29375,inst_29378);
var inst_29380 = (function(){throw inst_29379})();
var state_29436__$1 = state_29436;
var statearr_29438_29473 = state_29436__$1;
(statearr_29438_29473[(2)] = inst_29380);

(statearr_29438_29473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (1))){
var state_29436__$1 = state_29436;
var statearr_29439_29474 = state_29436__$1;
(statearr_29439_29474[(2)] = null);

(statearr_29439_29474[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (4))){
var inst_29357 = (state_29436[(2)]);
var state_29436__$1 = state_29436;
var statearr_29440_29475 = state_29436__$1;
(statearr_29440_29475[(2)] = inst_29357);

(statearr_29440_29475[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (15))){
var inst_29420 = (state_29436[(7)]);
var inst_29416 = (state_29436[(2)]);
var inst_29417 = fluree.db.util.async.throw_err(inst_29416);
var inst_29418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29417,(0),null);
var inst_29419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29417,(1),null);
var inst_29420__$1 = cljs.core.first(inst_29418);
var inst_29421 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29420__$1,compare_val);
var state_29436__$1 = (function (){var statearr_29441 = state_29436;
(statearr_29441[(7)] = inst_29420__$1);

(statearr_29441[(8)] = inst_29419);

return statearr_29441;
})();
if(inst_29421){
var statearr_29442_29476 = state_29436__$1;
(statearr_29442_29476[(1)] = (16));

} else {
var statearr_29443_29477 = state_29436__$1;
(statearr_29443_29477[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (13))){
var state_29436__$1 = state_29436;
var statearr_29444_29478 = state_29436__$1;
(statearr_29444_29478[(2)] = null);

(statearr_29444_29478[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (6))){
var state_29436__$1 = state_29436;
var statearr_29445_29479 = state_29436__$1;
(statearr_29445_29479[(2)] = null);

(statearr_29445_29479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (17))){
var inst_29420 = (state_29436[(7)]);
var inst_29424 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29420)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29425 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29426 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29427 = cljs.core.PersistentHashMap.fromArrays(inst_29425,inst_29426);
var inst_29428 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29424,inst_29427);
var inst_29429 = (function(){throw inst_29428})();
var state_29436__$1 = state_29436;
var statearr_29446_29480 = state_29436__$1;
(statearr_29446_29480[(2)] = inst_29429);

(statearr_29446_29480[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (3))){
var inst_29434 = (state_29436[(2)]);
var state_29436__$1 = state_29436;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29436__$1,inst_29434);
} else {
if((state_val_29437 === (12))){
var inst_29372 = (state_29436[(9)]);
var inst_29395 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29372], 0));
var inst_29396 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29397 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29398 = cljs.core.PersistentHashMap.fromArrays(inst_29396,inst_29397);
var inst_29399 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29395,inst_29398);
var inst_29400 = (function(){throw inst_29399})();
var state_29436__$1 = state_29436;
var statearr_29447_29481 = state_29436__$1;
(statearr_29447_29481[(2)] = inst_29400);

(statearr_29447_29481[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (2))){
var inst_29369 = (state_29436[(10)]);
var inst_29371 = (state_29436[(11)]);
var inst_29370 = (state_29436[(12)]);
var _ = (function (){var statearr_29448 = state_29436;
(statearr_29448[(4)] = cljs.core.cons((5),(state_29436[(4)])));

return statearr_29448;
})();
var inst_29367 = _QMARK_ctx;
var inst_29368 = cljs.core.__destructure_map(inst_29367);
var inst_29369__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29368,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29370__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29368,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29371__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29368,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29372 = fluree.db.dbproto._p_prop(inst_29371__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29370__$1);
var state_29436__$1 = (function (){var statearr_29449 = state_29436;
(statearr_29449[(9)] = inst_29372);

(statearr_29449[(10)] = inst_29369__$1);

(statearr_29449[(11)] = inst_29371__$1);

(statearr_29449[(12)] = inst_29370__$1);

return statearr_29449;
})();
if(cljs.core.truth_(inst_29369__$1)){
var statearr_29450_29482 = state_29436__$1;
(statearr_29450_29482[(1)] = (6));

} else {
var statearr_29451_29483 = state_29436__$1;
(statearr_29451_29483[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (11))){
var inst_29371 = (state_29436[(11)]);
var inst_29370 = (state_29436[(12)]);
var inst_29392 = (state_29436[(2)]);
var inst_29393 = fluree.db.dbproto._p_prop(inst_29371,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29370);
var state_29436__$1 = (function (){var statearr_29453 = state_29436;
(statearr_29453[(13)] = inst_29392);

return statearr_29453;
})();
if(cljs.core.truth_(inst_29393)){
var statearr_29454_29484 = state_29436__$1;
(statearr_29454_29484[(1)] = (12));

} else {
var statearr_29455_29485 = state_29436__$1;
(statearr_29455_29485[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (9))){
var state_29436__$1 = state_29436;
var statearr_29456_29486 = state_29436__$1;
(statearr_29456_29486[(2)] = null);

(statearr_29456_29486[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (5))){
var _ = (function (){var statearr_29457 = state_29436;
(statearr_29457[(4)] = cljs.core.rest((state_29436[(4)])));

return statearr_29457;
})();
var state_29436__$1 = state_29436;
var ex29452 = (state_29436__$1[(2)]);
var statearr_29458_29487 = state_29436__$1;
(statearr_29458_29487[(5)] = ex29452);


if((ex29452 instanceof Error)){
var statearr_29459_29488 = state_29436__$1;
(statearr_29459_29488[(1)] = (4));

(statearr_29459_29488[(5)] = null);

} else {
throw ex29452;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (14))){
var inst_29372 = (state_29436[(9)]);
var inst_29369 = (state_29436[(10)]);
var inst_29371 = (state_29436[(11)]);
var inst_29403 = (state_29436[(2)]);
var inst_29404 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29406 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29407 = [inst_29369,inst_29372,"?current-val"];
var inst_29408 = (new cljs.core.PersistentVector(null,3,(5),inst_29406,inst_29407,null));
var inst_29409 = [inst_29408];
var inst_29410 = (new cljs.core.PersistentVector(null,1,(5),inst_29405,inst_29409,null));
var inst_29411 = cljs.core.PersistentHashMap.EMPTY;
var inst_29412 = ["?current-val",inst_29410,inst_29411];
var inst_29413 = cljs.core.PersistentHashMap.fromArrays(inst_29404,inst_29412);
var inst_29414 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29371,inst_29413);
var state_29436__$1 = (function (){var statearr_29460 = state_29436;
(statearr_29460[(14)] = inst_29403);

return statearr_29460;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29436__$1,(15),inst_29414);
} else {
if((state_val_29437 === (16))){
var state_29436__$1 = state_29436;
var statearr_29461_29489 = state_29436__$1;
(statearr_29461_29489[(2)] = new_val);

(statearr_29461_29489[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (10))){
var inst_29385 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29386 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29387 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29388 = cljs.core.PersistentHashMap.fromArrays(inst_29386,inst_29387);
var inst_29389 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29385,inst_29388);
var inst_29390 = (function(){throw inst_29389})();
var state_29436__$1 = state_29436;
var statearr_29462_29490 = state_29436__$1;
(statearr_29462_29490[(2)] = inst_29390);

(statearr_29462_29490[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (18))){
var inst_29431 = (state_29436[(2)]);
var _ = (function (){var statearr_29463 = state_29436;
(statearr_29463[(4)] = cljs.core.rest((state_29436[(4)])));

return statearr_29463;
})();
var state_29436__$1 = state_29436;
var statearr_29464_29491 = state_29436__$1;
(statearr_29464_29491[(2)] = inst_29431);

(statearr_29464_29491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29437 === (8))){
var inst_29372 = (state_29436[(9)]);
var inst_29382 = (state_29436[(2)]);
var state_29436__$1 = (function (){var statearr_29465 = state_29436;
(statearr_29465[(15)] = inst_29382);

return statearr_29465;
})();
if(cljs.core.truth_(inst_29372)){
var statearr_29466_29492 = state_29436__$1;
(statearr_29466_29492[(1)] = (9));

} else {
var statearr_29467_29493 = state_29436__$1;
(statearr_29467_29493[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0 = (function (){
var statearr_29468 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29468[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__);

(statearr_29468[(1)] = (1));

return statearr_29468;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1 = (function (state_29436){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_29436);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e29469){var ex__2687__auto__ = e29469;
var statearr_29470_29494 = state_29436;
(statearr_29470_29494[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_29436[(4)]))){
var statearr_29471_29495 = state_29436;
(statearr_29471_29495[(1)] = cljs.core.first((state_29436[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29496 = state_29436;
state_29436 = G__29496;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__ = function(state_29436){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1.call(this,state_29436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_29472 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_29472[(6)] = c__2706__auto__);

return statearr_29472;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
