// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__69117 = arguments.length;
switch (G__69117) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69162){
var state_val_69163 = (state_69162[(1)]);
if((state_val_69163 === (7))){
var inst_69132 = typeof user === 'string';
var state_69162__$1 = state_69162;
if(cljs.core.truth_(inst_69132)){
var statearr_69164_69193 = state_69162__$1;
(statearr_69164_69193[(1)] = (9));

} else {
var statearr_69165_69194 = state_69162__$1;
(statearr_69165_69194[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (1))){
var state_69162__$1 = state_69162;
var statearr_69166_69195 = state_69162__$1;
(statearr_69166_69195[(2)] = null);

(statearr_69166_69195[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (4))){
var inst_69118 = (state_69162[(2)]);
var inst_69119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69120 = [inst_69118];
var inst_69121 = (new cljs.core.PersistentVector(null,1,(5),inst_69119,inst_69120,null));
var inst_69122 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69121);
var inst_69123 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69118) : reject.call(null,inst_69118));
var state_69162__$1 = (function (){var statearr_69167 = state_69162;
(statearr_69167[(7)] = inst_69122);

return statearr_69167;
})();
var statearr_69168_69196 = state_69162__$1;
(statearr_69168_69196[(2)] = inst_69123);

(statearr_69168_69196[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (15))){
var inst_69151 = (state_69162[(2)]);
var inst_69152 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_69151);
var inst_69153 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69154 = cljs.core.constantly(inst_69152);
var inst_69155 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69153,inst_69154);
var inst_69156 = fluree.db.connection.add_token(conn,inst_69152);
var inst_69157 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_69151) : resolve.call(null,inst_69151));
var _ = (function (){var statearr_69169 = state_69162;
(statearr_69169[(4)] = cljs.core.rest((state_69162[(4)])));

return statearr_69169;
})();
var state_69162__$1 = (function (){var statearr_69170 = state_69162;
(statearr_69170[(8)] = inst_69155);

(statearr_69170[(9)] = inst_69156);

return statearr_69170;
})();
var statearr_69171_69197 = state_69162__$1;
(statearr_69171_69197[(2)] = inst_69157);

(statearr_69171_69197[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (13))){
var state_69162__$1 = state_69162;
var statearr_69172_69198 = state_69162__$1;
(statearr_69172_69198[(2)] = null);

(statearr_69172_69198[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (6))){
var state_69162__$1 = state_69162;
var statearr_69173_69199 = state_69162__$1;
(statearr_69173_69199[(2)] = user);

(statearr_69173_69199[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (3))){
var inst_69160 = (state_69162[(2)]);
var state_69162__$1 = state_69162;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69162__$1,inst_69160);
} else {
if((state_val_69163 === (12))){
var state_69162__$1 = state_69162;
var statearr_69174_69200 = state_69162__$1;
(statearr_69174_69200[(2)] = user);

(statearr_69174_69200[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (2))){
var _ = (function (){var statearr_69175 = state_69162;
(statearr_69175[(4)] = cljs.core.cons((5),(state_69162[(4)])));

return statearr_69175;
})();
var inst_69129 = typeof user === 'number';
var state_69162__$1 = state_69162;
if(cljs.core.truth_(inst_69129)){
var statearr_69176_69201 = state_69162__$1;
(statearr_69176_69201[(1)] = (6));

} else {
var statearr_69177_69202 = state_69162__$1;
(statearr_69177_69202[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (11))){
var inst_69143 = (state_69162[(2)]);
var state_69162__$1 = state_69162;
var statearr_69179_69203 = state_69162__$1;
(statearr_69179_69203[(2)] = inst_69143);

(statearr_69179_69203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (9))){
var inst_69134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69135 = ["_user/username",user];
var inst_69136 = (new cljs.core.PersistentVector(null,2,(5),inst_69134,inst_69135,null));
var state_69162__$1 = state_69162;
var statearr_69180_69204 = state_69162__$1;
(statearr_69180_69204[(2)] = inst_69136);

(statearr_69180_69204[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (5))){
var _ = (function (){var statearr_69181 = state_69162;
(statearr_69181[(4)] = cljs.core.rest((state_69162[(4)])));

return statearr_69181;
})();
var state_69162__$1 = state_69162;
var ex69178 = (state_69162__$1[(2)]);
var statearr_69182_69205 = state_69162__$1;
(statearr_69182_69205[(5)] = ex69178);


var statearr_69183_69206 = state_69162__$1;
(statearr_69183_69206[(1)] = (4));

(statearr_69183_69206[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (14))){
var inst_69141 = (state_69162[(2)]);
var state_69162__$1 = state_69162;
var statearr_69184_69207 = state_69162__$1;
(statearr_69184_69207[(2)] = inst_69141);

(statearr_69184_69207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (10))){
var state_69162__$1 = state_69162;
var statearr_69185_69208 = state_69162__$1;
(statearr_69185_69208[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69163 === (8))){
var inst_69145 = (state_69162[(2)]);
var inst_69146 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_69147 = [account,inst_69145,password,expireSeconds,syncTo];
var inst_69148 = cljs.core.PersistentHashMap.fromArrays(inst_69146,inst_69147);
var inst_69149 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_69148);
var state_69162__$1 = state_69162;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69162__$1,(15),inst_69149);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69187 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69187[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69187[(1)] = (1));

return statearr_69187;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69162){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69162);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69188){var ex__2687__auto__ = e69188;
var statearr_69189_69209 = state_69162;
(statearr_69189_69209[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69162[(4)]))){
var statearr_69190_69210 = state_69162;
(statearr_69190_69210[(1)] = cljs.core.first((state_69162[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69211 = state_69162;
state_69162 = G__69211;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69162){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69191 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69191[(6)] = c__2706__auto__);

return statearr_69191;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__69213 = arguments.length;
switch (G__69213) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69222){
var state_val_69223 = (state_69222[(1)]);
if((state_val_69223 === (1))){
var inst_69214 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69216 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_69217 = (new cljs.core.PersistentVector(null,4,(5),inst_69215,inst_69216,null));
var inst_69218 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69214,inst_69217);
var inst_69219 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__69224 = cljs.core.seq(cljs.core.keys(x));
var chunk__69225 = null;
var count__69226 = (0);
var i__69227 = (0);
while(true){
if((i__69227 < count__69226)){
var k = chunk__69225.cljs$core$IIndexed$_nth$arity$2(null,i__69227);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__69235 = seq__69224;
var G__69236 = chunk__69225;
var G__69237 = count__69226;
var G__69238 = (i__69227 + (1));
seq__69224 = G__69235;
chunk__69225 = G__69236;
count__69226 = G__69237;
i__69227 = G__69238;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__69224);
if(temp__5804__auto__){
var seq__69224__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__69224__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__69224__$1);
var G__69239 = cljs.core.chunk_rest(seq__69224__$1);
var G__69240 = c__5568__auto__;
var G__69241 = cljs.core.count(c__5568__auto__);
var G__69242 = (0);
seq__69224 = G__69239;
chunk__69225 = G__69240;
count__69226 = G__69241;
i__69227 = G__69242;
continue;
} else {
var k = cljs.core.first(seq__69224__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__69243 = cljs.core.next(seq__69224__$1);
var G__69244 = null;
var G__69245 = (0);
var G__69246 = (0);
seq__69224 = G__69243;
chunk__69225 = G__69244;
count__69226 = G__69245;
i__69227 = G__69246;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_69220 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69219);
var state_69222__$1 = (function (){var statearr_69228 = state_69222;
(statearr_69228[(7)] = inst_69218);

return statearr_69228;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69222__$1,inst_69220);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69229 = [null,null,null,null,null,null,null,null];
(statearr_69229[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69229[(1)] = (1));

return statearr_69229;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69222){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69222);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69230){var ex__2687__auto__ = e69230;
var statearr_69231_69247 = state_69222;
(statearr_69231_69247[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69222[(4)]))){
var statearr_69232_69248 = state_69222;
(statearr_69232_69248[(1)] = cljs.core.first((state_69222[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69249 = state_69222;
state_69222 = G__69249;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69222){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69233 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69233[(6)] = c__2706__auto__);

return statearr_69233;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__69251 = arguments.length;
switch (G__69251) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69288){
var state_val_69289 = (state_69288[(1)]);
if((state_val_69289 === (1))){
var state_69288__$1 = state_69288;
var statearr_69290_69311 = state_69288__$1;
(statearr_69290_69311[(2)] = null);

(statearr_69290_69311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69289 === (2))){
var _ = (function (){var statearr_69291 = state_69288;
(statearr_69291[(4)] = cljs.core.cons((5),(state_69288[(4)])));

return statearr_69291;
})();
var inst_69263 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_69264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69265 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_69266 = (new cljs.core.PersistentVector(null,1,(5),inst_69264,inst_69265,null));
var inst_69267 = cljs.core.PersistentHashMap.EMPTY;
var inst_69268 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_69267);
var inst_69269 = cljs.core.assoc_in(inst_69263,inst_69266,inst_69268);
var inst_69270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69271 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69272 = (new cljs.core.PersistentVector(null,1,(5),inst_69270,inst_69271,null));
var inst_69273 = cljs.core.PersistentHashMap.EMPTY;
var inst_69274 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_69273);
var inst_69275 = cljs.core.assoc_in(inst_69269,inst_69272,inst_69274);
var inst_69276 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69277 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_69275);
var inst_69278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69279 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_69276,null];
var inst_69280 = (new cljs.core.PersistentVector(null,4,(5),inst_69278,inst_69279,null));
var inst_69281 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69277,inst_69280);
var inst_69282 = (function (){var conn = inst_69275;
var pc = inst_69276;
return (function (x){
if((x == null)){
} else {
var seq__69292_69312 = cljs.core.seq(cljs.core.keys(x));
var chunk__69293_69313 = null;
var count__69294_69314 = (0);
var i__69295_69315 = (0);
while(true){
if((i__69295_69315 < count__69294_69314)){
var k_69316 = chunk__69293_69313.cljs$core$IIndexed$_nth$arity$2(null,i__69295_69315);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69316], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_69316,null));


var G__69317 = seq__69292_69312;
var G__69318 = chunk__69293_69313;
var G__69319 = count__69294_69314;
var G__69320 = (i__69295_69315 + (1));
seq__69292_69312 = G__69317;
chunk__69293_69313 = G__69318;
count__69294_69314 = G__69319;
i__69295_69315 = G__69320;
continue;
} else {
var temp__5804__auto___69321 = cljs.core.seq(seq__69292_69312);
if(temp__5804__auto___69321){
var seq__69292_69322__$1 = temp__5804__auto___69321;
if(cljs.core.chunked_seq_QMARK_(seq__69292_69322__$1)){
var c__5568__auto___69323 = cljs.core.chunk_first(seq__69292_69322__$1);
var G__69324 = cljs.core.chunk_rest(seq__69292_69322__$1);
var G__69325 = c__5568__auto___69323;
var G__69326 = cljs.core.count(c__5568__auto___69323);
var G__69327 = (0);
seq__69292_69312 = G__69324;
chunk__69293_69313 = G__69325;
count__69294_69314 = G__69326;
i__69295_69315 = G__69327;
continue;
} else {
var k_69328 = cljs.core.first(seq__69292_69322__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69328], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_69328,null));


var G__69329 = cljs.core.next(seq__69292_69322__$1);
var G__69330 = null;
var G__69331 = (0);
var G__69332 = (0);
seq__69292_69312 = G__69329;
chunk__69293_69313 = G__69330;
count__69294_69314 = G__69331;
i__69295_69315 = G__69332;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_69283 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69276,inst_69282);
var ___$1 = (function (){var statearr_69296 = state_69288;
(statearr_69296[(4)] = cljs.core.rest((state_69288[(4)])));

return statearr_69296;
})();
var state_69288__$1 = (function (){var statearr_69297 = state_69288;
(statearr_69297[(7)] = inst_69281);

return statearr_69297;
})();
var statearr_69298_69333 = state_69288__$1;
(statearr_69298_69333[(2)] = inst_69283);

(statearr_69298_69333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69289 === (3))){
var inst_69286 = (state_69288[(2)]);
var state_69288__$1 = state_69288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69288__$1,inst_69286);
} else {
if((state_val_69289 === (4))){
var inst_69252 = (state_69288[(2)]);
var inst_69253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69254 = [inst_69252];
var inst_69255 = (new cljs.core.PersistentVector(null,1,(5),inst_69253,inst_69254,null));
var inst_69256 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69255);
var inst_69257 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69252) : reject.call(null,inst_69252));
var state_69288__$1 = (function (){var statearr_69300 = state_69288;
(statearr_69300[(8)] = inst_69256);

return statearr_69300;
})();
var statearr_69301_69334 = state_69288__$1;
(statearr_69301_69334[(2)] = inst_69257);

(statearr_69301_69334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69289 === (5))){
var _ = (function (){var statearr_69302 = state_69288;
(statearr_69302[(4)] = cljs.core.rest((state_69288[(4)])));

return statearr_69302;
})();
var state_69288__$1 = state_69288;
var ex69299 = (state_69288__$1[(2)]);
var statearr_69303_69335 = state_69288__$1;
(statearr_69303_69335[(5)] = ex69299);


var statearr_69304_69336 = state_69288__$1;
(statearr_69304_69336[(1)] = (4));

(statearr_69304_69336[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69305 = [null,null,null,null,null,null,null,null,null];
(statearr_69305[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69305[(1)] = (1));

return statearr_69305;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69288){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69288);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69306){var ex__2687__auto__ = e69306;
var statearr_69307_69337 = state_69288;
(statearr_69307_69337[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69288[(4)]))){
var statearr_69308_69338 = state_69288;
(statearr_69308_69338[(1)] = cljs.core.first((state_69288[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69339 = state_69288;
state_69288 = G__69339;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69288){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69309 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69309[(6)] = c__2706__auto__);

return statearr_69309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__69341 = arguments.length;
switch (G__69341) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__69343 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69343,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69343,(1),null);
var cb_STAR_ = (function (header,data){
var G__69346 = cljs.core.clj__GT_js(header);
var G__69347 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__69346,G__69347) : callback.call(null,G__69346,G__69347));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__69348 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69348,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69348,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69401){
var state_val_69402 = (state_69401[(1)]);
if((state_val_69402 === (7))){
var inst_69362 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69363 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69364 = cljs.core.PersistentHashMap.fromArrays(inst_69362,inst_69363);
var inst_69365 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_69364);
var inst_69366 = (function(){throw inst_69365})();
var state_69401__$1 = state_69401;
var statearr_69403_69435 = state_69401__$1;
(statearr_69403_69435[(2)] = inst_69366);

(statearr_69403_69435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (1))){
var state_69401__$1 = state_69401;
var statearr_69404_69436 = state_69401__$1;
(statearr_69404_69436[(2)] = null);

(statearr_69404_69436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (4))){
var inst_69351 = (state_69401[(2)]);
var inst_69352 = cljs.core.clj__GT_js(inst_69351);
var inst_69353 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69352) : reject.call(null,inst_69352));
var state_69401__$1 = state_69401;
var statearr_69405_69437 = state_69401__$1;
(statearr_69405_69437[(2)] = inst_69353);

(statearr_69405_69437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (13))){
var inst_69380 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69381 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69382 = cljs.core.PersistentHashMap.fromArrays(inst_69380,inst_69381);
var inst_69383 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_69382);
var inst_69384 = (function(){throw inst_69383})();
var state_69401__$1 = state_69401;
var statearr_69406_69438 = state_69401__$1;
(statearr_69406_69438[(2)] = inst_69384);

(statearr_69406_69438[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (6))){
var state_69401__$1 = state_69401;
var statearr_69407_69439 = state_69401__$1;
(statearr_69407_69439[(2)] = null);

(statearr_69407_69439[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (3))){
var inst_69399 = (state_69401[(2)]);
var state_69401__$1 = state_69401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69401__$1,inst_69399);
} else {
if((state_val_69402 === (12))){
var state_69401__$1 = state_69401;
var statearr_69408_69440 = state_69401__$1;
(statearr_69408_69440[(2)] = null);

(statearr_69408_69440[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (2))){
var _ = (function (){var statearr_69409 = state_69401;
(statearr_69409[(4)] = cljs.core.cons((5),(state_69401[(4)])));

return statearr_69409;
})();
var inst_69359 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_69401__$1 = state_69401;
if(cljs.core.truth_(inst_69359)){
var statearr_69410_69441 = state_69401__$1;
(statearr_69410_69441[(1)] = (6));

} else {
var statearr_69411_69442 = state_69401__$1;
(statearr_69411_69442[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (11))){
var inst_69377 = (state_69401[(2)]);
var state_69401__$1 = (function (){var statearr_69413 = state_69401;
(statearr_69413[(7)] = inst_69377);

return statearr_69413;
})();
if(cljs.core.truth_(password)){
var statearr_69414_69443 = state_69401__$1;
(statearr_69414_69443[(1)] = (12));

} else {
var statearr_69415_69444 = state_69401__$1;
(statearr_69415_69444[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (9))){
var state_69401__$1 = state_69401;
var statearr_69416_69445 = state_69401__$1;
(statearr_69416_69445[(2)] = null);

(statearr_69416_69445[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (5))){
var _ = (function (){var statearr_69417 = state_69401;
(statearr_69417[(4)] = cljs.core.rest((state_69401[(4)])));

return statearr_69417;
})();
var state_69401__$1 = state_69401;
var ex69412 = (state_69401__$1[(2)]);
var statearr_69418_69446 = state_69401__$1;
(statearr_69418_69446[(5)] = ex69412);


var statearr_69419_69447 = state_69401__$1;
(statearr_69419_69447[(1)] = (4));

(statearr_69419_69447[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (14))){
var inst_69386 = (state_69401[(2)]);
var inst_69387 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_69388 = fluree.db.util.core.without_nils(inst_69387);
var inst_69389 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69390 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69392 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_69388,inst_69389,null];
var inst_69393 = (new cljs.core.PersistentVector(null,4,(5),inst_69391,inst_69392,null));
var inst_69394 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69390,inst_69393);
var inst_69395 = (function (){var _ = inst_69386;
var data = inst_69388;
var pc = inst_69389;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__69420 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69420) : reject.call(null,G__69420));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__69421 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69421) : reject.call(null,G__69421));
} else {
var G__69422 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__69422) : resolve.call(null,G__69422));

}
}
});
})();
var inst_69396 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69389,inst_69395);
var _ = (function (){var statearr_69423 = state_69401;
(statearr_69423[(4)] = cljs.core.rest((state_69401[(4)])));

return statearr_69423;
})();
var state_69401__$1 = (function (){var statearr_69424 = state_69401;
(statearr_69424[(8)] = inst_69394);

return statearr_69424;
})();
var statearr_69425_69448 = state_69401__$1;
(statearr_69425_69448[(2)] = inst_69396);

(statearr_69425_69448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (10))){
var inst_69371 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69372 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69373 = cljs.core.PersistentHashMap.fromArrays(inst_69371,inst_69372);
var inst_69374 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_69373);
var inst_69375 = (function(){throw inst_69374})();
var state_69401__$1 = state_69401;
var statearr_69426_69449 = state_69401__$1;
(statearr_69426_69449[(2)] = inst_69375);

(statearr_69426_69449[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69402 === (8))){
var inst_69368 = (state_69401[(2)]);
var state_69401__$1 = (function (){var statearr_69427 = state_69401;
(statearr_69427[(9)] = inst_69368);

return statearr_69427;
})();
if(cljs.core.truth_(ledger)){
var statearr_69428_69450 = state_69401__$1;
(statearr_69428_69450[(1)] = (9));

} else {
var statearr_69429_69451 = state_69401__$1;
(statearr_69429_69451[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_69430 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69430[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2684__auto__);

(statearr_69430[(1)] = (1));

return statearr_69430;
});
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1 = (function (state_69401){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69401);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69431){var ex__2687__auto__ = e69431;
var statearr_69432_69452 = state_69401;
(statearr_69432_69452[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69401[(4)]))){
var statearr_69433_69453 = state_69401;
(statearr_69433_69453[(1)] = cljs.core.first((state_69401[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69454 = state_69401;
state_69401 = G__69454;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = function(state_69401){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1.call(this,state_69401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69434 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69434[(6)] = c__2706__auto__);

return statearr_69434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__69456 = arguments.length;
switch (G__69456) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69523){
var state_val_69524 = (state_69523[(1)]);
if((state_val_69524 === (7))){
var inst_69468 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69469 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69470 = cljs.core.PersistentHashMap.fromArrays(inst_69468,inst_69469);
var inst_69471 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_69470);
var inst_69472 = (function(){throw inst_69471})();
var state_69523__$1 = state_69523;
var statearr_69525_69567 = state_69523__$1;
(statearr_69525_69567[(2)] = inst_69472);

(statearr_69525_69567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (20))){
var inst_69506 = (state_69523[(2)]);
var inst_69507 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69508 = [ledger,password,user,auth,expire];
var inst_69509 = cljs.core.PersistentHashMap.fromArrays(inst_69507,inst_69508);
var inst_69510 = fluree.db.util.core.without_nils(inst_69509);
var inst_69511 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69512 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69514 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_69510,inst_69511,null];
var inst_69515 = (new cljs.core.PersistentVector(null,4,(5),inst_69513,inst_69514,null));
var inst_69516 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69512,inst_69515);
var inst_69517 = (function (){var _ = inst_69506;
var data = inst_69510;
var pc = inst_69511;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__69526 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69526) : reject.call(null,G__69526));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__69527 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69527) : reject.call(null,G__69527));
} else {
fluree.db.connection.add_token(conn,result);

var G__69528 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__69528) : resolve.call(null,G__69528));

}
}
});
})();
var inst_69518 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69511,inst_69517);
var _ = (function (){var statearr_69529 = state_69523;
(statearr_69529[(4)] = cljs.core.rest((state_69523[(4)])));

return statearr_69529;
})();
var state_69523__$1 = (function (){var statearr_69530 = state_69523;
(statearr_69530[(7)] = inst_69516);

return statearr_69530;
})();
var statearr_69531_69568 = state_69523__$1;
(statearr_69531_69568[(2)] = inst_69518);

(statearr_69531_69568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (1))){
var state_69523__$1 = state_69523;
var statearr_69532_69569 = state_69523__$1;
(statearr_69532_69569[(2)] = null);

(statearr_69532_69569[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (4))){
var inst_69457 = (state_69523[(2)]);
var inst_69458 = cljs.core.clj__GT_js(inst_69457);
var inst_69459 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69458) : reject.call(null,inst_69458));
var state_69523__$1 = state_69523;
var statearr_69533_69570 = state_69523__$1;
(statearr_69533_69570[(2)] = inst_69459);

(statearr_69533_69570[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (15))){
var inst_69493 = (state_69523[(8)]);
var state_69523__$1 = state_69523;
var statearr_69534_69571 = state_69523__$1;
(statearr_69534_69571[(2)] = inst_69493);

(statearr_69534_69571[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (13))){
var inst_69486 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69487 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69488 = cljs.core.PersistentHashMap.fromArrays(inst_69486,inst_69487);
var inst_69489 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_69488);
var inst_69490 = (function(){throw inst_69489})();
var state_69523__$1 = state_69523;
var statearr_69535_69572 = state_69523__$1;
(statearr_69535_69572[(2)] = inst_69490);

(statearr_69535_69572[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (6))){
var state_69523__$1 = state_69523;
var statearr_69536_69573 = state_69523__$1;
(statearr_69536_69573[(2)] = null);

(statearr_69536_69573[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (17))){
var inst_69497 = (state_69523[(2)]);
var state_69523__$1 = state_69523;
if(cljs.core.truth_(inst_69497)){
var statearr_69537_69574 = state_69523__$1;
(statearr_69537_69574[(1)] = (18));

} else {
var statearr_69538_69575 = state_69523__$1;
(statearr_69538_69575[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (3))){
var inst_69521 = (state_69523[(2)]);
var state_69523__$1 = state_69523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69523__$1,inst_69521);
} else {
if((state_val_69524 === (12))){
var state_69523__$1 = state_69523;
var statearr_69539_69576 = state_69523__$1;
(statearr_69539_69576[(2)] = null);

(statearr_69539_69576[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (2))){
var _ = (function (){var statearr_69540 = state_69523;
(statearr_69540[(4)] = cljs.core.cons((5),(state_69523[(4)])));

return statearr_69540;
})();
var inst_69465 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_69523__$1 = state_69523;
if(cljs.core.truth_(inst_69465)){
var statearr_69541_69577 = state_69523__$1;
(statearr_69541_69577[(1)] = (6));

} else {
var statearr_69542_69578 = state_69523__$1;
(statearr_69542_69578[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (19))){
var inst_69500 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69501 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69502 = cljs.core.PersistentHashMap.fromArrays(inst_69500,inst_69501);
var inst_69503 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_69502);
var inst_69504 = (function(){throw inst_69503})();
var state_69523__$1 = state_69523;
var statearr_69543_69579 = state_69523__$1;
(statearr_69543_69579[(2)] = inst_69504);

(statearr_69543_69579[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (11))){
var inst_69483 = (state_69523[(2)]);
var state_69523__$1 = (function (){var statearr_69545 = state_69523;
(statearr_69545[(9)] = inst_69483);

return statearr_69545;
})();
if(cljs.core.truth_(password)){
var statearr_69546_69580 = state_69523__$1;
(statearr_69546_69580[(1)] = (12));

} else {
var statearr_69547_69581 = state_69523__$1;
(statearr_69547_69581[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (9))){
var state_69523__$1 = state_69523;
var statearr_69548_69582 = state_69523__$1;
(statearr_69548_69582[(2)] = null);

(statearr_69548_69582[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (5))){
var _ = (function (){var statearr_69549 = state_69523;
(statearr_69549[(4)] = cljs.core.rest((state_69523[(4)])));

return statearr_69549;
})();
var state_69523__$1 = state_69523;
var ex69544 = (state_69523__$1[(2)]);
var statearr_69550_69583 = state_69523__$1;
(statearr_69550_69583[(5)] = ex69544);


var statearr_69551_69584 = state_69523__$1;
(statearr_69551_69584[(1)] = (4));

(statearr_69551_69584[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (14))){
var inst_69493 = (state_69523[(8)]);
var inst_69492 = (state_69523[(2)]);
var inst_69493__$1 = user;
var state_69523__$1 = (function (){var statearr_69552 = state_69523;
(statearr_69552[(10)] = inst_69492);

(statearr_69552[(8)] = inst_69493__$1);

return statearr_69552;
})();
if(cljs.core.truth_(inst_69493__$1)){
var statearr_69553_69585 = state_69523__$1;
(statearr_69553_69585[(1)] = (15));

} else {
var statearr_69554_69586 = state_69523__$1;
(statearr_69554_69586[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (16))){
var state_69523__$1 = state_69523;
var statearr_69555_69587 = state_69523__$1;
(statearr_69555_69587[(2)] = auth);

(statearr_69555_69587[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (10))){
var inst_69477 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69478 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69479 = cljs.core.PersistentHashMap.fromArrays(inst_69477,inst_69478);
var inst_69480 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_69479);
var inst_69481 = (function(){throw inst_69480})();
var state_69523__$1 = state_69523;
var statearr_69556_69588 = state_69523__$1;
(statearr_69556_69588[(2)] = inst_69481);

(statearr_69556_69588[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (18))){
var state_69523__$1 = state_69523;
var statearr_69557_69589 = state_69523__$1;
(statearr_69557_69589[(2)] = null);

(statearr_69557_69589[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69524 === (8))){
var inst_69474 = (state_69523[(2)]);
var state_69523__$1 = (function (){var statearr_69558 = state_69523;
(statearr_69558[(11)] = inst_69474);

return statearr_69558;
})();
if(cljs.core.truth_(ledger)){
var statearr_69559_69590 = state_69523__$1;
(statearr_69559_69590[(1)] = (9));

} else {
var statearr_69560_69591 = state_69523__$1;
(statearr_69560_69591[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69561 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69561[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69561[(1)] = (1));

return statearr_69561;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69523){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69523);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69562){var ex__2687__auto__ = e69562;
var statearr_69563_69592 = state_69523;
(statearr_69563_69592[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69523[(4)]))){
var statearr_69564_69593 = state_69523;
(statearr_69564_69593[(1)] = cljs.core.first((state_69523[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69594 = state_69523;
state_69523 = G__69594;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69523){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69565 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69565[(6)] = c__2706__auto__);

return statearr_69565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__69596 = arguments.length;
switch (G__69596) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69631){
var state_val_69632 = (state_69631[(1)]);
if((state_val_69632 === (1))){
var state_69631__$1 = state_69631;
var statearr_69633_69655 = state_69631__$1;
(statearr_69633_69655[(2)] = null);

(statearr_69633_69655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69632 === (2))){
var _ = (function (){var statearr_69634 = state_69631;
(statearr_69634[(4)] = cljs.core.cons((5),(state_69631[(4)])));

return statearr_69634;
})();
var inst_69605 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_69631__$1 = state_69631;
if(cljs.core.truth_(inst_69605)){
var statearr_69635_69656 = state_69631__$1;
(statearr_69635_69656[(1)] = (6));

} else {
var statearr_69636_69657 = state_69631__$1;
(statearr_69636_69657[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69632 === (3))){
var inst_69629 = (state_69631[(2)]);
var state_69631__$1 = state_69631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69631__$1,inst_69629);
} else {
if((state_val_69632 === (4))){
var inst_69597 = (state_69631[(2)]);
var inst_69598 = cljs.core.clj__GT_js(inst_69597);
var inst_69599 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69598) : reject.call(null,inst_69598));
var state_69631__$1 = state_69631;
var statearr_69638_69658 = state_69631__$1;
(statearr_69638_69658[(2)] = inst_69599);

(statearr_69638_69658[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69632 === (5))){
var _ = (function (){var statearr_69639 = state_69631;
(statearr_69639[(4)] = cljs.core.rest((state_69631[(4)])));

return statearr_69639;
})();
var state_69631__$1 = state_69631;
var ex69637 = (state_69631__$1[(2)]);
var statearr_69640_69659 = state_69631__$1;
(statearr_69640_69659[(5)] = ex69637);


var statearr_69641_69660 = state_69631__$1;
(statearr_69641_69660[(1)] = (4));

(statearr_69641_69660[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69632 === (6))){
var state_69631__$1 = state_69631;
var statearr_69642_69661 = state_69631__$1;
(statearr_69642_69661[(2)] = null);

(statearr_69642_69661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69632 === (7))){
var inst_69608 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69609 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69610 = cljs.core.PersistentHashMap.fromArrays(inst_69608,inst_69609);
var inst_69611 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_69610);
var inst_69612 = (function(){throw inst_69611})();
var state_69631__$1 = state_69631;
var statearr_69643_69662 = state_69631__$1;
(statearr_69643_69662[(2)] = inst_69612);

(statearr_69643_69662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69632 === (8))){
var inst_69614 = (state_69631[(2)]);
var inst_69615 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69616 = [jwt,expire];
var inst_69617 = cljs.core.PersistentHashMap.fromArrays(inst_69615,inst_69616);
var inst_69618 = fluree.db.util.core.without_nils(inst_69617);
var inst_69619 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69620 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69622 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_69618,inst_69619,null];
var inst_69623 = (new cljs.core.PersistentVector(null,4,(5),inst_69621,inst_69622,null));
var inst_69624 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69620,inst_69623);
var inst_69625 = (function (){var _ = inst_69614;
var data = inst_69618;
var pc = inst_69619;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__69644 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69644) : reject.call(null,G__69644));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__69645 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__69645) : resolve.call(null,G__69645));

}
});
})();
var inst_69626 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69619,inst_69625);
var _ = (function (){var statearr_69646 = state_69631;
(statearr_69646[(4)] = cljs.core.rest((state_69631[(4)])));

return statearr_69646;
})();
var state_69631__$1 = (function (){var statearr_69647 = state_69631;
(statearr_69647[(7)] = inst_69624);

return statearr_69647;
})();
var statearr_69648_69663 = state_69631__$1;
(statearr_69648_69663[(2)] = inst_69626);

(statearr_69648_69663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69649 = [null,null,null,null,null,null,null,null];
(statearr_69649[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69649[(1)] = (1));

return statearr_69649;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69631){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69631);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69650){var ex__2687__auto__ = e69650;
var statearr_69651_69664 = state_69631;
(statearr_69651_69664[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69631[(4)]))){
var statearr_69652_69665 = state_69631;
(statearr_69652_69665[(1)] = cljs.core.first((state_69631[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69666 = state_69631;
state_69631 = G__69666;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69631){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69653 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69653[(6)] = c__2706__auto__);

return statearr_69653;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

