// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__67843_68024 = cljs.core.seq(servers);
var chunk__67844_68025 = null;
var count__67845_68026 = (0);
var i__67846_68027 = (0);
while(true){
if((i__67846_68027 < count__67845_68026)){
var server_68028 = chunk__67844_68025.cljs$core$IIndexed$_nth$arity$2(null,i__67846_68027);
var healthcheck_uri_68029 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68028),"/fdb/health"].join('');
var resp_chan_68030 = fluree.db.util.xhttp.post_json(healthcheck_uri_68029,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___68031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68031,healthcheck_uri_68029,resp_chan_68030,server_68028){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68031,healthcheck_uri_68029,resp_chan_68030,server_68028){
return (function (state_67916){
var state_val_67917 = (state_67916[(1)]);
if((state_val_67917 === (1))){
var state_67916__$1 = state_67916;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67916__$1,(2),resp_chan_68030);
} else {
if((state_val_67917 === (2))){
var inst_67902 = (state_67916[(7)]);
var inst_67902__$1 = (state_67916[(2)]);
var inst_67903 = fluree.db.util.core.exception_QMARK_(inst_67902__$1);
var state_67916__$1 = (function (){var statearr_67918 = state_67916;
(statearr_67918[(7)] = inst_67902__$1);

return statearr_67918;
})();
if(inst_67903){
var statearr_67919_68032 = state_67916__$1;
(statearr_67919_68032[(1)] = (3));

} else {
var statearr_67920_68033 = state_67916__$1;
(statearr_67920_68033[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67917 === (3))){
var inst_67902 = (state_67916[(7)]);
var inst_67905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67906 = cljs.core.ex_message(inst_67902);
var inst_67907 = cljs.core.ex_data(inst_67902);
var inst_67908 = ["Server contact error: ",inst_67906,inst_67907];
var inst_67909 = (new cljs.core.PersistentVector(null,3,(5),inst_67905,inst_67908,null));
var inst_67910 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67909);
var state_67916__$1 = state_67916;
var statearr_67921_68034 = state_67916__$1;
(statearr_67921_68034[(2)] = inst_67910);

(statearr_67921_68034[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67917 === (4))){
var inst_67912 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_68028);
var state_67916__$1 = state_67916;
var statearr_67922_68035 = state_67916__$1;
(statearr_67922_68035[(2)] = inst_67912);

(statearr_67922_68035[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67917 === (5))){
var inst_67914 = (state_67916[(2)]);
var state_67916__$1 = state_67916;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67916__$1,inst_67914);
} else {
return null;
}
}
}
}
}
});})(seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68031,healthcheck_uri_68029,resp_chan_68030,server_68028))
;
return ((function (seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,switch__2683__auto__,c__2706__auto___68031,healthcheck_uri_68029,resp_chan_68030,server_68028){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_67923 = [null,null,null,null,null,null,null,null];
(statearr_67923[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_67923[(1)] = (1));

return statearr_67923;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_67916){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67916);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67924){var ex__2687__auto__ = e67924;
var statearr_67925_68036 = state_67916;
(statearr_67925_68036[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67916[(4)]))){
var statearr_67926_68037 = state_67916;
(statearr_67926_68037[(1)] = cljs.core.first((state_67916[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68038 = state_67916;
state_67916 = G__68038;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_67916){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_67916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,switch__2683__auto__,c__2706__auto___68031,healthcheck_uri_68029,resp_chan_68030,server_68028))
})();
var state__2708__auto__ = (function (){var statearr_67927 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67927[(6)] = c__2706__auto___68031);

return statearr_67927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68031,healthcheck_uri_68029,resp_chan_68030,server_68028))
);



var G__68039 = seq__67843_68024;
var G__68040 = chunk__67844_68025;
var G__68041 = count__67845_68026;
var G__68042 = (i__67846_68027 + (1));
seq__67843_68024 = G__68039;
chunk__67844_68025 = G__68040;
count__67845_68026 = G__68041;
i__67846_68027 = G__68042;
continue;
} else {
var temp__5804__auto___68043 = cljs.core.seq(seq__67843_68024);
if(temp__5804__auto___68043){
var seq__67843_68044__$1 = temp__5804__auto___68043;
if(cljs.core.chunked_seq_QMARK_(seq__67843_68044__$1)){
var c__5568__auto___68045 = cljs.core.chunk_first(seq__67843_68044__$1);
var G__68046 = cljs.core.chunk_rest(seq__67843_68044__$1);
var G__68047 = c__5568__auto___68045;
var G__68048 = cljs.core.count(c__5568__auto___68045);
var G__68049 = (0);
seq__67843_68024 = G__68046;
chunk__67844_68025 = G__68047;
count__67845_68026 = G__68048;
i__67846_68027 = G__68049;
continue;
} else {
var server_68050 = cljs.core.first(seq__67843_68044__$1);
var healthcheck_uri_68051 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68050),"/fdb/health"].join('');
var resp_chan_68052 = fluree.db.util.xhttp.post_json(healthcheck_uri_68051,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___68053 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68053,healthcheck_uri_68051,resp_chan_68052,server_68050,seq__67843_68044__$1,temp__5804__auto___68043){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68053,healthcheck_uri_68051,resp_chan_68052,server_68050,seq__67843_68044__$1,temp__5804__auto___68043){
return (function (state_67943){
var state_val_67944 = (state_67943[(1)]);
if((state_val_67944 === (1))){
var state_67943__$1 = state_67943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67943__$1,(2),resp_chan_68052);
} else {
if((state_val_67944 === (2))){
var inst_67929 = (state_67943[(7)]);
var inst_67929__$1 = (state_67943[(2)]);
var inst_67930 = fluree.db.util.core.exception_QMARK_(inst_67929__$1);
var state_67943__$1 = (function (){var statearr_67945 = state_67943;
(statearr_67945[(7)] = inst_67929__$1);

return statearr_67945;
})();
if(inst_67930){
var statearr_67946_68054 = state_67943__$1;
(statearr_67946_68054[(1)] = (3));

} else {
var statearr_67947_68055 = state_67943__$1;
(statearr_67947_68055[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67944 === (3))){
var inst_67929 = (state_67943[(7)]);
var inst_67932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67933 = cljs.core.ex_message(inst_67929);
var inst_67934 = cljs.core.ex_data(inst_67929);
var inst_67935 = ["Server contact error: ",inst_67933,inst_67934];
var inst_67936 = (new cljs.core.PersistentVector(null,3,(5),inst_67932,inst_67935,null));
var inst_67937 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67936);
var state_67943__$1 = state_67943;
var statearr_67948_68056 = state_67943__$1;
(statearr_67948_68056[(2)] = inst_67937);

(statearr_67948_68056[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67944 === (4))){
var inst_67939 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_68050);
var state_67943__$1 = state_67943;
var statearr_67949_68057 = state_67943__$1;
(statearr_67949_68057[(2)] = inst_67939);

(statearr_67949_68057[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67944 === (5))){
var inst_67941 = (state_67943[(2)]);
var state_67943__$1 = state_67943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67943__$1,inst_67941);
} else {
return null;
}
}
}
}
}
});})(seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68053,healthcheck_uri_68051,resp_chan_68052,server_68050,seq__67843_68044__$1,temp__5804__auto___68043))
;
return ((function (seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,switch__2683__auto__,c__2706__auto___68053,healthcheck_uri_68051,resp_chan_68052,server_68050,seq__67843_68044__$1,temp__5804__auto___68043){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_67950 = [null,null,null,null,null,null,null,null];
(statearr_67950[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_67950[(1)] = (1));

return statearr_67950;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_67943){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67943);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67951){var ex__2687__auto__ = e67951;
var statearr_67952_68058 = state_67943;
(statearr_67952_68058[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67943[(4)]))){
var statearr_67953_68059 = state_67943;
(statearr_67953_68059[(1)] = cljs.core.first((state_67943[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68060 = state_67943;
state_67943 = G__68060;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_67943){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_67943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,switch__2683__auto__,c__2706__auto___68053,healthcheck_uri_68051,resp_chan_68052,server_68050,seq__67843_68044__$1,temp__5804__auto___68043))
})();
var state__2708__auto__ = (function (){var statearr_67954 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67954[(6)] = c__2706__auto___68053);

return statearr_67954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__67843_68024,chunk__67844_68025,count__67845_68026,i__67846_68027,c__2706__auto___68053,healthcheck_uri_68051,resp_chan_68052,server_68050,seq__67843_68044__$1,temp__5804__auto___68043))
);



var G__68061 = cljs.core.next(seq__67843_68044__$1);
var G__68062 = null;
var G__68063 = (0);
var G__68064 = (0);
seq__67843_68024 = G__68061;
chunk__67844_68025 = G__68062;
count__67845_68026 = G__68063;
i__67846_68027 = G__68064;
continue;
}
} else {
}
}
break;
}

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67998){
var state_val_67999 = (state_67998[(1)]);
if((state_val_67999 === (7))){
var inst_67970 = (state_67998[(7)]);
var inst_67977 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67970,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_67998__$1 = state_67998;
if(inst_67977){
var statearr_68000_68065 = state_67998__$1;
(statearr_68000_68065[(1)] = (9));

} else {
var statearr_68001_68066 = state_67998__$1;
(statearr_68001_68066[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (1))){
var inst_67963 = (state_67998[(8)]);
var inst_67962 = (state_67998[(9)]);
var inst_67962__$1 = promise_chan;
var inst_67963__$1 = cljs.core.async.timeout((60000));
var inst_67964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67965 = [inst_67962__$1,inst_67963__$1];
var inst_67966 = (new cljs.core.PersistentVector(null,2,(5),inst_67964,inst_67965,null));
var state_67998__$1 = (function (){var statearr_68002 = state_67998;
(statearr_68002[(8)] = inst_67963__$1);

(statearr_68002[(9)] = inst_67962__$1);

return statearr_68002;
})();
return cljs.core.async.ioc_alts_BANG_(state_67998__$1,(2),inst_67966);
} else {
if((state_val_67999 === (4))){
var inst_67963 = (state_67998[(8)]);
var inst_67970 = (state_67998[(7)]);
var inst_67974 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67970,inst_67963);
var state_67998__$1 = state_67998;
if(inst_67974){
var statearr_68003_68067 = state_67998__$1;
(statearr_68003_68067[(1)] = (6));

} else {
var statearr_68004_68068 = state_67998__$1;
(statearr_68004_68068[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (13))){
var state_67998__$1 = state_67998;
var statearr_68005_68069 = state_67998__$1;
(statearr_68005_68069[(2)] = null);

(statearr_68005_68069[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (6))){
var state_67998__$1 = state_67998;
var statearr_68006_68070 = state_67998__$1;
(statearr_68006_68070[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_68006_68070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (3))){
var state_67998__$1 = state_67998;
var statearr_68007_68071 = state_67998__$1;
(statearr_68007_68071[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_68007_68071[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (12))){
var inst_67988 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_67989 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67990 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_67991 = cljs.core.PersistentHashMap.fromArrays(inst_67989,inst_67990);
var inst_67992 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_67991);
var inst_67993 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_67992);
var state_67998__$1 = (function (){var statearr_68008 = state_67998;
(statearr_68008[(10)] = inst_67988);

return statearr_68008;
})();
var statearr_68009_68072 = state_67998__$1;
(statearr_68009_68072[(2)] = inst_67993);

(statearr_68009_68072[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (2))){
var inst_67970 = (state_67998[(7)]);
var inst_67962 = (state_67998[(9)]);
var inst_67968 = (state_67998[(2)]);
var inst_67969 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67968,(0),null);
var inst_67970__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67968,(1),null);
var inst_67971 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67970__$1,inst_67962);
var state_67998__$1 = (function (){var statearr_68010 = state_67998;
(statearr_68010[(7)] = inst_67970__$1);

(statearr_68010[(11)] = inst_67969);

return statearr_68010;
})();
if(inst_67971){
var statearr_68011_68073 = state_67998__$1;
(statearr_68011_68073[(1)] = (3));

} else {
var statearr_68012_68074 = state_67998__$1;
(statearr_68012_68074[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (11))){
var inst_67981 = (state_67998[(2)]);
var state_67998__$1 = state_67998;
var statearr_68013_68075 = state_67998__$1;
(statearr_68013_68075[(2)] = inst_67981);

(statearr_68013_68075[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (9))){
var inst_67969 = (state_67998[(11)]);
var state_67998__$1 = state_67998;
var statearr_68014_68076 = state_67998__$1;
(statearr_68014_68076[(2)] = inst_67969);

(statearr_68014_68076[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (5))){
var inst_67985 = (state_67998[(2)]);
var inst_67986 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_67985);
var state_67998__$1 = state_67998;
if(inst_67986){
var statearr_68015_68077 = state_67998__$1;
(statearr_68015_68077[(1)] = (12));

} else {
var statearr_68016_68078 = state_67998__$1;
(statearr_68016_68078[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (14))){
var inst_67996 = (state_67998[(2)]);
var state_67998__$1 = state_67998;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67998__$1,inst_67996);
} else {
if((state_val_67999 === (10))){
var state_67998__$1 = state_67998;
var statearr_68017_68079 = state_67998__$1;
(statearr_68017_68079[(2)] = null);

(statearr_68017_68079[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67999 === (8))){
var inst_67983 = (state_67998[(2)]);
var state_67998__$1 = state_67998;
var statearr_68018_68080 = state_67998__$1;
(statearr_68018_68080[(2)] = inst_67983);

(statearr_68018_68080[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68019 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68019[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68019[(1)] = (1));

return statearr_68019;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_67998){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67998);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68020){var ex__2687__auto__ = e68020;
var statearr_68021_68081 = state_67998;
(statearr_68021_68081[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67998[(4)]))){
var statearr_68022_68082 = state_67998;
(statearr_68022_68082[(1)] = cljs.core.first((state_67998[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68083 = state_67998;
state_67998 = G__68083;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_67998){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_67998);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68023 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68023[(6)] = c__2706__auto__);

return statearr_68023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68127){
var state_val_68128 = (state_68127[(1)]);
if((state_val_68128 === (7))){
var state_68127__$1 = state_68127;
var statearr_68129_68155 = state_68127__$1;
(statearr_68129_68155[(2)] = null);

(statearr_68129_68155[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (1))){
var state_68127__$1 = state_68127;
var statearr_68130_68156 = state_68127__$1;
(statearr_68130_68156[(2)] = null);

(statearr_68130_68156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (4))){
var inst_68084 = (state_68127[(2)]);
var state_68127__$1 = state_68127;
var statearr_68131_68157 = state_68127__$1;
(statearr_68131_68157[(2)] = inst_68084);

(statearr_68131_68157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (6))){
var inst_68106 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_68127__$1 = state_68127;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68127__$1,(9),inst_68106);
} else {
if((state_val_68128 === (3))){
var inst_68125 = (state_68127[(2)]);
var state_68127__$1 = state_68127;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68127__$1,inst_68125);
} else {
if((state_val_68128 === (12))){
var inst_68119 = (state_68127[(2)]);
var state_68127__$1 = state_68127;
var statearr_68132_68158 = state_68127__$1;
(statearr_68132_68158[(2)] = inst_68119);

(statearr_68132_68158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (2))){
var inst_68100 = (state_68127[(7)]);
var inst_68090 = (state_68127[(8)]);
var inst_68095 = (state_68127[(9)]);
var _ = (function (){var statearr_68133 = state_68127;
(statearr_68133[(4)] = cljs.core.cons((5),(state_68127[(4)])));

return statearr_68133;
})();
var inst_68090__$1 = cljs.core.random_uuid();
var inst_68091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68092 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_68093 = (new cljs.core.PersistentVector(null,2,(5),inst_68091,inst_68092,null));
var inst_68094 = (function (){var lock_id = inst_68090__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_68095__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_68093,inst_68094);
var inst_68096 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68097 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_68098 = (new cljs.core.PersistentVector(null,3,(5),inst_68096,inst_68097,null));
var inst_68099 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68095__$1,inst_68098);
var inst_68100__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68090__$1,inst_68099);
var inst_68101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68102 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68103 = (new cljs.core.PersistentVector(null,3,(5),inst_68101,inst_68102,null));
var inst_68104 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68095__$1,inst_68103);
var state_68127__$1 = (function (){var statearr_68134 = state_68127;
(statearr_68134[(7)] = inst_68100__$1);

(statearr_68134[(8)] = inst_68090__$1);

(statearr_68134[(9)] = inst_68095__$1);

(statearr_68134[(10)] = inst_68104);

return statearr_68134;
})();
if(inst_68100__$1){
var statearr_68135_68159 = state_68127__$1;
(statearr_68135_68159[(1)] = (6));

} else {
var statearr_68136_68160 = state_68127__$1;
(statearr_68136_68160[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (11))){
var inst_68111 = (state_68127[(11)]);
var inst_68104 = (state_68127[(10)]);
var inst_68110 = (state_68127[(12)]);
var inst_68117 = fluree.db.util.xhttp.try_socket(inst_68110,sub_chan,pub_chan,inst_68104,(60000),inst_68111);
var state_68127__$1 = state_68127;
var statearr_68138_68161 = state_68127__$1;
(statearr_68138_68161[(2)] = inst_68117);

(statearr_68138_68161[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (9))){
var inst_68100 = (state_68127[(7)]);
var inst_68108 = (state_68127[(13)]);
var inst_68090 = (state_68127[(8)]);
var inst_68095 = (state_68127[(9)]);
var inst_68104 = (state_68127[(10)]);
var inst_68110 = (state_68127[(12)]);
var inst_68108__$1 = (state_68127[(2)]);
var inst_68109 = clojure.string.replace(inst_68108__$1,"http","ws");
var inst_68110__$1 = [inst_68109,"/fdb/ws"].join('');
var inst_68111 = (function (){var lock_id = inst_68090;
var state = inst_68095;
var have_lock_QMARK_ = inst_68100;
var resp_chan = inst_68104;
var healthy_server = inst_68108__$1;
var ws_url = inst_68110__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_68112 = fluree.db.util.core.exception_QMARK_(inst_68108__$1);
var state_68127__$1 = (function (){var statearr_68139 = state_68127;
(statearr_68139[(13)] = inst_68108__$1);

(statearr_68139[(11)] = inst_68111);

(statearr_68139[(12)] = inst_68110__$1);

return statearr_68139;
})();
if(inst_68112){
var statearr_68140_68162 = state_68127__$1;
(statearr_68140_68162[(1)] = (10));

} else {
var statearr_68141_68163 = state_68127__$1;
(statearr_68141_68163[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (5))){
var _ = (function (){var statearr_68142 = state_68127;
(statearr_68142[(4)] = cljs.core.rest((state_68127[(4)])));

return statearr_68142;
})();
var state_68127__$1 = state_68127;
var ex68137 = (state_68127__$1[(2)]);
var statearr_68143_68164 = state_68127__$1;
(statearr_68143_68164[(5)] = ex68137);


if((ex68137 instanceof Error)){
var statearr_68144_68165 = state_68127__$1;
(statearr_68144_68165[(1)] = (4));

(statearr_68144_68165[(5)] = null);

} else {
throw ex68137;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (10))){
var inst_68108 = (state_68127[(13)]);
var inst_68104 = (state_68127[(10)]);
var inst_68114 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_68115 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68104,inst_68108);
var state_68127__$1 = (function (){var statearr_68145 = state_68127;
(statearr_68145[(14)] = inst_68114);

return statearr_68145;
})();
var statearr_68146_68166 = state_68127__$1;
(statearr_68146_68166[(2)] = inst_68115);

(statearr_68146_68166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68128 === (8))){
var inst_68104 = (state_68127[(10)]);
var inst_68122 = (state_68127[(2)]);
var _ = (function (){var statearr_68147 = state_68127;
(statearr_68147[(4)] = cljs.core.rest((state_68127[(4)])));

return statearr_68147;
})();
var state_68127__$1 = (function (){var statearr_68148 = state_68127;
(statearr_68148[(15)] = inst_68122);

return statearr_68148;
})();
var statearr_68149_68167 = state_68127__$1;
(statearr_68149_68167[(2)] = inst_68104);

(statearr_68149_68167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_68150 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68150[(0)] = fluree$db$connection$establish_socket_$_state_machine__2684__auto__);

(statearr_68150[(1)] = (1));

return statearr_68150;
});
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____1 = (function (state_68127){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68127);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68151){var ex__2687__auto__ = e68151;
var statearr_68152_68168 = state_68127;
(statearr_68152_68168[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68127[(4)]))){
var statearr_68153_68169 = state_68127;
(statearr_68153_68169[(1)] = cljs.core.first((state_68127[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68170 = state_68127;
state_68127 = G__68170;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = function(state_68127){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____1.call(this,state_68127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68154 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68154[(6)] = c__2706__auto__);

return statearr_68154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k68172,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__68176 = k68172;
var G__68176__$1 = (((G__68176 instanceof cljs.core.Keyword))?G__68176.fqn:null);
switch (G__68176__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k68172,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__68177){
var vec__68178 = p__68177;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68178,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68178,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__68171){
var self__ = this;
var G__68171__$1 = this;
return (new cljs.core.RecordIter((0),G__68171__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__68181 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__68181(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this68173,other68174){
var self__ = this;
var this68173__$1 = this;
return (((!((other68174 == null)))) && ((((this68173__$1.constructor === other68174.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.id,other68174.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.servers,other68174.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.state,other68174.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.req_chan,other68174.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.sub_chan,other68174.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.pub_chan,other68174.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.group,other68174.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.storage_read,other68174.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.storage_list,other68174.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.storage_write,other68174.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.storage_exists,other68174.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.storage_rename,other68174.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.storage_delete,other68174.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.object_cache,other68174.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.async_cache,other68174.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.parallelism,other68174.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.serializer,other68174.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.default_network,other68174.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.transactor_QMARK_,other68174.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.publish,other68174.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.transact_handler,other68174.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.tx_private_key,other68174.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.tx_key_id,other68174.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.meta,other68174.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.add_listener,other68174.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.remove_listener,other68174.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.close,other68174.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68173__$1.__extmap,other68174.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__68182){
var self__ = this;
var map__68183 = p__68182;
var map__68183__$1 = cljs.core.__destructure_map(map__68183);
var node = map__68183__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68183__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68183__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68183__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__68184 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__68185 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__68186 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__68187 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__68186,G__68187) : self__.async_cache.call(null,G__68186,G__68187));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__68184,G__68185) : self__.async_cache.call(null,G__68184,G__68185));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k68172){
var self__ = this;
var this__5350__auto____$1 = this;
var G__68188 = k68172;
var G__68188__$1 = (((G__68188 instanceof cljs.core.Keyword))?G__68188.fqn:null);
switch (G__68188__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k68172);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__68171){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__68189 = cljs.core.keyword_identical_QMARK_;
var expr__68190 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__68192 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__68193 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68192,G__68193) : pred__68189.call(null,G__68192,G__68193));
})())){
return (new fluree.db.connection.Connection(G__68171,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68194 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__68195 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68194,G__68195) : pred__68189.call(null,G__68194,G__68195));
})())){
return (new fluree.db.connection.Connection(self__.id,G__68171,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68196 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__68197 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68196,G__68197) : pred__68189.call(null,G__68196,G__68197));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__68171,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68198 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__68199 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68198,G__68199) : pred__68189.call(null,G__68198,G__68199));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__68171,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68200 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__68201 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68200,G__68201) : pred__68189.call(null,G__68200,G__68201));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__68171,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68202 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__68203 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68202,G__68203) : pred__68189.call(null,G__68202,G__68203));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__68171,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68204 = new cljs.core.Keyword(null,"group","group",582596132);
var G__68205 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68204,G__68205) : pred__68189.call(null,G__68204,G__68205));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__68171,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68206 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__68207 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68206,G__68207) : pred__68189.call(null,G__68206,G__68207));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__68171,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68208 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__68209 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68208,G__68209) : pred__68189.call(null,G__68208,G__68209));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__68171,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68210 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__68211 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68210,G__68211) : pred__68189.call(null,G__68210,G__68211));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__68171,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68212 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__68213 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68212,G__68213) : pred__68189.call(null,G__68212,G__68213));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__68171,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68214 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__68215 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68214,G__68215) : pred__68189.call(null,G__68214,G__68215));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__68171,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68216 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__68217 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68216,G__68217) : pred__68189.call(null,G__68216,G__68217));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__68171,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68218 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__68219 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68218,G__68219) : pred__68189.call(null,G__68218,G__68219));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__68171,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68220 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__68221 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68220,G__68221) : pred__68189.call(null,G__68220,G__68221));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__68171,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68222 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__68223 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68222,G__68223) : pred__68189.call(null,G__68222,G__68223));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__68171,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68224 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__68225 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68224,G__68225) : pred__68189.call(null,G__68224,G__68225));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__68171,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68226 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__68227 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68226,G__68227) : pred__68189.call(null,G__68226,G__68227));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__68171,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68228 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__68229 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68228,G__68229) : pred__68189.call(null,G__68228,G__68229));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__68171,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68230 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__68231 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68230,G__68231) : pred__68189.call(null,G__68230,G__68231));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__68171,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68232 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__68233 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68232,G__68233) : pred__68189.call(null,G__68232,G__68233));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__68171,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68234 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__68235 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68234,G__68235) : pred__68189.call(null,G__68234,G__68235));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__68171,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68236 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__68237 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68236,G__68237) : pred__68189.call(null,G__68236,G__68237));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__68171,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68238 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__68239 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68238,G__68239) : pred__68189.call(null,G__68238,G__68239));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__68171,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68240 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__68241 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68240,G__68241) : pred__68189.call(null,G__68240,G__68241));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__68171,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68242 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__68243 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68242,G__68243) : pred__68189.call(null,G__68242,G__68243));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__68171,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68244 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__68245 = expr__68190;
return (pred__68189.cljs$core$IFn$_invoke$arity$2 ? pred__68189.cljs$core$IFn$_invoke$arity$2(G__68244,G__68245) : pred__68189.call(null,G__68244,G__68245));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__68171,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__68171),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__68171){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__68171,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__68175){
var extmap__5385__auto__ = (function (){var G__68246 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__68175,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__68175)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__68246);
} else {
return G__68246;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__68175),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__68175),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__68252 = servers_STAR_;
var vec__68253 = G__68252;
var seq__68254 = cljs.core.seq(vec__68253);
var first__68255 = cljs.core.first(seq__68254);
var seq__68254__$1 = cljs.core.next(seq__68254);
var server = first__68255;
var r = seq__68254__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__68252__$1 = G__68252;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__68259 = G__68252__$1;
var seq__68260 = cljs.core.seq(vec__68259);
var first__68261 = cljs.core.first(seq__68260);
var seq__68260__$1 = cljs.core.next(seq__68260);
var server__$1 = first__68261;
var r__$1 = seq__68260__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__68262 = r__$1;
var G__68263 = is_https_QMARK_;
var G__68264 = result_STAR_;
G__68252__$1 = G__68262;
https_QMARK___$1 = G__68263;
result__$1 = G__68264;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__68265 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__68265 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__68265);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68294){
var state_val_68295 = (state_68294[(1)]);
if((state_val_68295 === (7))){
var inst_68280 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68281 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68282 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68283 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68284 = fluree.db.connection.establish_socket(inst_68280,inst_68281,inst_68282,inst_68283);
var state_68294__$1 = state_68294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68294__$1,(9),inst_68284);
} else {
if((state_val_68295 === (1))){
var state_68294__$1 = state_68294;
var statearr_68296_68315 = state_68294__$1;
(statearr_68296_68315[(2)] = null);

(statearr_68296_68315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68295 === (4))){
var inst_68266 = (state_68294[(2)]);
var state_68294__$1 = state_68294;
var statearr_68297_68316 = state_68294__$1;
(statearr_68297_68316[(2)] = inst_68266);

(statearr_68297_68316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68295 === (6))){
var inst_68277 = (state_68294[(7)]);
var state_68294__$1 = state_68294;
var statearr_68298_68317 = state_68294__$1;
(statearr_68298_68317[(2)] = inst_68277);

(statearr_68298_68317[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68295 === (3))){
var inst_68292 = (state_68294[(2)]);
var state_68294__$1 = state_68294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68294__$1,inst_68292);
} else {
if((state_val_68295 === (2))){
var inst_68277 = (state_68294[(7)]);
var _ = (function (){var statearr_68300 = state_68294;
(statearr_68300[(4)] = cljs.core.cons((5),(state_68294[(4)])));

return statearr_68300;
})();
var inst_68272 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_68273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68274 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68275 = [inst_68274,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68276 = (new cljs.core.PersistentVector(null,3,(5),inst_68273,inst_68275,null));
var inst_68277__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68272,inst_68276);
var state_68294__$1 = (function (){var statearr_68301 = state_68294;
(statearr_68301[(7)] = inst_68277__$1);

return statearr_68301;
})();
if(cljs.core.truth_(inst_68277__$1)){
var statearr_68302_68318 = state_68294__$1;
(statearr_68302_68318[(1)] = (6));

} else {
var statearr_68303_68319 = state_68294__$1;
(statearr_68303_68319[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68295 === (9))){
var inst_68286 = (state_68294[(2)]);
var inst_68287 = fluree.db.util.async.throw_err(inst_68286);
var state_68294__$1 = state_68294;
var statearr_68304_68320 = state_68294__$1;
(statearr_68304_68320[(2)] = inst_68287);

(statearr_68304_68320[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68295 === (5))){
var _ = (function (){var statearr_68305 = state_68294;
(statearr_68305[(4)] = cljs.core.rest((state_68294[(4)])));

return statearr_68305;
})();
var state_68294__$1 = state_68294;
var ex68299 = (state_68294__$1[(2)]);
var statearr_68306_68321 = state_68294__$1;
(statearr_68306_68321[(5)] = ex68299);


if((ex68299 instanceof Error)){
var statearr_68307_68322 = state_68294__$1;
(statearr_68307_68322[(1)] = (4));

(statearr_68307_68322[(5)] = null);

} else {
throw ex68299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68295 === (8))){
var inst_68289 = (state_68294[(2)]);
var _ = (function (){var statearr_68308 = state_68294;
(statearr_68308[(4)] = cljs.core.rest((state_68294[(4)])));

return statearr_68308;
})();
var state_68294__$1 = state_68294;
var statearr_68309_68323 = state_68294__$1;
(statearr_68309_68323[(2)] = inst_68289);

(statearr_68309_68323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_68310 = [null,null,null,null,null,null,null,null];
(statearr_68310[(0)] = fluree$db$connection$get_socket_$_state_machine__2684__auto__);

(statearr_68310[(1)] = (1));

return statearr_68310;
});
var fluree$db$connection$get_socket_$_state_machine__2684__auto____1 = (function (state_68294){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68294);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68311){var ex__2687__auto__ = e68311;
var statearr_68312_68324 = state_68294;
(statearr_68312_68324[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68294[(4)]))){
var statearr_68313_68325 = state_68294;
(statearr_68313_68325[(1)] = cljs.core.first((state_68294[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68326 = state_68294;
state_68294 = G__68326;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2684__auto__ = function(state_68294){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____1.call(this,state_68294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2684__auto____0;
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68314 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68314[(6)] = c__2706__auto__);

return statearr_68314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e68327){var e = e68327;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__68329){
var map__68330 = p__68329;
var map__68330__$1 = cljs.core.__destructure_map(map__68330);
var conn = map__68330__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68330__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68330__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68330__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68476){
var state_val_68477 = (state_68476[(1)]);
if((state_val_68477 === (7))){
var inst_68472 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
var statearr_68479_68553 = state_68476__$1;
(statearr_68479_68553[(2)] = inst_68472);

(statearr_68479_68553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (20))){
var _ = (function (){var statearr_68480 = state_68476;
(statearr_68480[(4)] = cljs.core.rest((state_68476[(4)])));

return statearr_68480;
})();
var state_68476__$1 = state_68476;
var ex68478 = (state_68476__$1[(2)]);
var statearr_68481_68554 = state_68476__$1;
(statearr_68481_68554[(5)] = ex68478);


var statearr_68482_68555 = state_68476__$1;
(statearr_68482_68555[(1)] = (10));

(statearr_68482_68555[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (27))){
var inst_68433 = (state_68476[(7)]);
var inst_68433__$1 = (state_68476[(2)]);
var inst_68434 = inst_68433__$1 === true;
var state_68476__$1 = (function (){var statearr_68483 = state_68476;
(statearr_68483[(7)] = inst_68433__$1);

return statearr_68483;
})();
if(cljs.core.truth_(inst_68434)){
var statearr_68484_68556 = state_68476__$1;
(statearr_68484_68556[(1)] = (28));

} else {
var statearr_68485_68557 = state_68476__$1;
(statearr_68485_68557[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (1))){
var inst_68331 = (0);
var state_68476__$1 = (function (){var statearr_68486 = state_68476;
(statearr_68486[(8)] = inst_68331);

return statearr_68486;
})();
var statearr_68487_68558 = state_68476__$1;
(statearr_68487_68558[(2)] = null);

(statearr_68487_68558[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (24))){
var inst_68423 = (state_68476[(9)]);
var state_68476__$1 = state_68476;
var statearr_68488_68559 = state_68476__$1;
(statearr_68488_68559[(2)] = inst_68423);

(statearr_68488_68559[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (39))){
var inst_68458 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
var statearr_68489_68560 = state_68476__$1;
(statearr_68489_68560[(2)] = inst_68458);

(statearr_68489_68560[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (4))){
var inst_68334 = (state_68476[(10)]);
var inst_68334__$1 = (state_68476[(2)]);
var state_68476__$1 = (function (){var statearr_68490 = state_68476;
(statearr_68490[(10)] = inst_68334__$1);

return statearr_68490;
})();
if(cljs.core.truth_(inst_68334__$1)){
var statearr_68491_68561 = state_68476__$1;
(statearr_68491_68561[(1)] = (5));

} else {
var statearr_68492_68562 = state_68476__$1;
(statearr_68492_68562[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (15))){
var inst_68347 = (state_68476[(11)]);
var state_68476__$1 = state_68476;
var statearr_68493_68563 = state_68476__$1;
(statearr_68493_68563[(2)] = inst_68347);

(statearr_68493_68563[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (21))){
var inst_68379 = (state_68476[(12)]);
var inst_68384 = (state_68476[(13)]);
var inst_68380 = (state_68476[(14)]);
var inst_68376 = (state_68476[(15)]);
var inst_68377 = (state_68476[(16)]);
var inst_68378 = (state_68476[(17)]);
var inst_68334 = (state_68476[(10)]);
var inst_68385 = (state_68476[(18)]);
var inst_68331 = (state_68476[(8)]);
var inst_68381 = (state_68476[(19)]);
var inst_68387 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68388 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68384];
var inst_68389 = (new cljs.core.PersistentVector(null,2,(5),inst_68387,inst_68388,null));
var inst_68390 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_68389,inst_68379);
var inst_68417 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_68418 = (function (){var resp_chan = inst_68379;
var timeout = inst_68385;
var i = inst_68331;
var data = inst_68378;
var map__68372 = inst_68381;
var _ = inst_68376;
var req_id = inst_68384;
var operation = inst_68377;
var msg = inst_68334;
var vec__68369 = inst_68334;
var temp__5804__auto__ = inst_68334;
var c__2706__auto____$1 = inst_68417;
var opts = inst_68380;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68415){
var state_val_68416 = (state_68415[(1)]);
if((state_val_68416 === (1))){
var inst_68394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68395 = cljs.core.async.timeout(timeout);
var inst_68396 = [resp_chan,inst_68395];
var inst_68397 = (new cljs.core.PersistentVector(null,2,(5),inst_68394,inst_68396,null));
var state_68415__$1 = state_68415;
return cljs.core.async.ioc_alts_BANG_(state_68415__$1,(2),inst_68397);
} else {
if((state_val_68416 === (2))){
var inst_68400 = (state_68415[(7)]);
var inst_68399 = (state_68415[(2)]);
var inst_68400__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68399,(0),null);
var inst_68401 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68399,(1),null);
var inst_68402 = (function (){var vec__68391 = inst_68399;
var resp = inst_68400__$1;
var c = inst_68401;
return (function (p1__68328_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__68328_SHARP_,req_id);
});
})();
var inst_68403 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68402);
var inst_68404 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68401,resp_chan);
var state_68415__$1 = (function (){var statearr_68494 = state_68415;
(statearr_68494[(8)] = inst_68403);

(statearr_68494[(7)] = inst_68400__$1);

return statearr_68494;
})();
if(inst_68404){
var statearr_68495_68564 = state_68415__$1;
(statearr_68495_68564[(1)] = (3));

} else {
var statearr_68496_68565 = state_68415__$1;
(statearr_68496_68565[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68416 === (3))){
var inst_68400 = (state_68415[(7)]);
var state_68415__$1 = state_68415;
var statearr_68497_68566 = state_68415__$1;
(statearr_68497_68566[(2)] = inst_68400);

(statearr_68497_68566[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68416 === (4))){
var inst_68407 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_68408 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68409 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68410 = cljs.core.PersistentHashMap.fromArrays(inst_68408,inst_68409);
var inst_68411 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68407,inst_68410);
var state_68415__$1 = state_68415;
var statearr_68498_68567 = state_68415__$1;
(statearr_68498_68567[(2)] = inst_68411);

(statearr_68498_68567[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68416 === (5))){
var inst_68413 = (state_68415[(2)]);
var state_68415__$1 = state_68415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68415__$1,inst_68413);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_68499 = [null,null,null,null,null,null,null,null,null];
(statearr_68499[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_68499[(1)] = (1));

return statearr_68499;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_68415){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68415);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68500){var ex__2687__auto__ = e68500;
var statearr_68501_68568 = state_68415;
(statearr_68501_68568[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68415[(4)]))){
var statearr_68502_68569 = state_68415;
(statearr_68502_68569[(1)] = cljs.core.first((state_68415[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68570 = state_68415;
state_68415 = G__68570;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_68415){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_68415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68503 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68503[(6)] = c__2706__auto____$1);

return statearr_68503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_68419 = cljs.core.async.impl.dispatch.run(inst_68418);
var state_68476__$1 = (function (){var statearr_68504 = state_68476;
(statearr_68504[(20)] = inst_68419);

(statearr_68504[(21)] = inst_68390);

return statearr_68504;
})();
var statearr_68505_68571 = state_68476__$1;
(statearr_68505_68571[(2)] = inst_68417);

(statearr_68505_68571[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (31))){
var inst_68433 = (state_68476[(7)]);
var inst_68439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68440 = [inst_68433,"Error processing message in producer."];
var inst_68441 = (new cljs.core.PersistentVector(null,2,(5),inst_68439,inst_68440,null));
var inst_68442 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68441);
var state_68476__$1 = state_68476;
var statearr_68506_68572 = state_68476__$1;
(statearr_68506_68572[(2)] = inst_68442);

(statearr_68506_68572[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (32))){
var inst_68433 = (state_68476[(7)]);
var inst_68444 = (inst_68433 == null);
var state_68476__$1 = state_68476;
if(cljs.core.truth_(inst_68444)){
var statearr_68507_68573 = state_68476__$1;
(statearr_68507_68573[(1)] = (34));

} else {
var statearr_68508_68574 = state_68476__$1;
(statearr_68508_68574[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (33))){
var inst_68462 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
var statearr_68509_68575 = state_68476__$1;
(statearr_68509_68575[(2)] = inst_68462);

(statearr_68509_68575[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (13))){
var inst_68347 = (state_68476[(11)]);
var inst_68344 = (state_68476[(2)]);
var inst_68345 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68344,(0),null);
var inst_68346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68344,(1),null);
var inst_68347__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68344,(2),null);
var state_68476__$1 = (function (){var statearr_68510 = state_68476;
(statearr_68510[(11)] = inst_68347__$1);

(statearr_68510[(22)] = inst_68345);

(statearr_68510[(23)] = inst_68346);

return statearr_68510;
})();
if(cljs.core.truth_(inst_68347__$1)){
var statearr_68511_68576 = state_68476__$1;
(statearr_68511_68576[(1)] = (14));

} else {
var statearr_68512_68577 = state_68476__$1;
(statearr_68512_68577[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (22))){
var state_68476__$1 = state_68476;
var statearr_68513_68578 = state_68476__$1;
(statearr_68513_68578[(2)] = null);

(statearr_68513_68578[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (36))){
var inst_68460 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
var statearr_68514_68579 = state_68476__$1;
(statearr_68514_68579[(2)] = inst_68460);

(statearr_68514_68579[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (29))){
var inst_68433 = (state_68476[(7)]);
var inst_68437 = fluree.db.util.core.exception_QMARK_(inst_68433);
var state_68476__$1 = state_68476;
if(inst_68437){
var statearr_68515_68580 = state_68476__$1;
(statearr_68515_68580[(1)] = (31));

} else {
var statearr_68516_68581 = state_68476__$1;
(statearr_68516_68581[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (6))){
var state_68476__$1 = state_68476;
var statearr_68517_68582 = state_68476__$1;
(statearr_68517_68582[(2)] = null);

(statearr_68517_68582[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (28))){
var state_68476__$1 = state_68476;
var statearr_68518_68583 = state_68476__$1;
(statearr_68518_68583[(2)] = null);

(statearr_68518_68583[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (25))){
var state_68476__$1 = state_68476;
var statearr_68519_68584 = state_68476__$1;
(statearr_68519_68584[(2)] = fluree.db.connection.default_publish_fn);

(statearr_68519_68584[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (34))){
var inst_68446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68447 = ["Error processing message in producer. Socket closed."];
var inst_68448 = (new cljs.core.PersistentVector(null,1,(5),inst_68446,inst_68447,null));
var inst_68449 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68448);
var state_68476__$1 = state_68476;
var statearr_68520_68585 = state_68476__$1;
(statearr_68520_68585[(2)] = inst_68449);

(statearr_68520_68585[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (17))){
var inst_68347 = (state_68476[(11)]);
var inst_68336 = (state_68476[(24)]);
var inst_68354 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68347,inst_68336);
var state_68476__$1 = state_68476;
var statearr_68521_68586 = state_68476__$1;
(statearr_68521_68586[(2)] = inst_68354);

(statearr_68521_68586[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (3))){
var inst_68474 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68476__$1,inst_68474);
} else {
if((state_val_68477 === (12))){
var state_68476__$1 = state_68476;
var statearr_68522_68587 = state_68476__$1;
(statearr_68522_68587[(2)] = null);

(statearr_68522_68587[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (2))){
var state_68476__$1 = state_68476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68476__$1,(4),req_chan);
} else {
if((state_val_68477 === (23))){
var inst_68423 = (state_68476[(9)]);
var inst_68422 = (state_68476[(2)]);
var inst_68423__$1 = publish;
var state_68476__$1 = (function (){var statearr_68523 = state_68476;
(statearr_68523[(25)] = inst_68422);

(statearr_68523[(9)] = inst_68423__$1);

return statearr_68523;
})();
if(cljs.core.truth_(inst_68423__$1)){
var statearr_68524_68588 = state_68476__$1;
(statearr_68524_68588[(1)] = (24));

} else {
var statearr_68525_68589 = state_68476__$1;
(statearr_68525_68589[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (35))){
var state_68476__$1 = state_68476;
var statearr_68526_68590 = state_68476__$1;
(statearr_68526_68590[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (19))){
var inst_68363 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
var statearr_68528_68591 = state_68476__$1;
(statearr_68528_68591[(2)] = inst_68363);

(statearr_68528_68591[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (11))){
var inst_68334 = (state_68476[(10)]);
var state_68476__$1 = state_68476;
var statearr_68529_68592 = state_68476__$1;
(statearr_68529_68592[(2)] = inst_68334);

(statearr_68529_68592[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (9))){
var inst_68331 = (state_68476[(8)]);
var inst_68467 = (state_68476[(2)]);
var inst_68468 = (inst_68331 + (1));
var inst_68331__$1 = inst_68468;
var state_68476__$1 = (function (){var statearr_68530 = state_68476;
(statearr_68530[(26)] = inst_68467);

(statearr_68530[(8)] = inst_68331__$1);

return statearr_68530;
})();
var statearr_68531_68593 = state_68476__$1;
(statearr_68531_68593[(2)] = null);

(statearr_68531_68593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (5))){
var state_68476__$1 = state_68476;
var statearr_68532_68594 = state_68476__$1;
(statearr_68532_68594[(2)] = null);

(statearr_68532_68594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (14))){
var inst_68347 = (state_68476[(11)]);
var inst_68349 = fluree.db.util.async.channel_QMARK_(inst_68347);
var state_68476__$1 = state_68476;
var statearr_68533_68595 = state_68476__$1;
(statearr_68533_68595[(2)] = inst_68349);

(statearr_68533_68595[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (26))){
var inst_68384 = (state_68476[(13)]);
var inst_68377 = (state_68476[(16)]);
var inst_68378 = (state_68476[(17)]);
var inst_68427 = (state_68476[(2)]);
var inst_68428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68429 = [inst_68377,inst_68384,inst_68378];
var inst_68430 = (new cljs.core.PersistentVector(null,3,(5),inst_68428,inst_68429,null));
var inst_68431 = (inst_68427.cljs$core$IFn$_invoke$arity$2 ? inst_68427.cljs$core$IFn$_invoke$arity$2(conn,inst_68430) : inst_68427.call(null,conn,inst_68430));
var state_68476__$1 = state_68476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68476__$1,(27),inst_68431);
} else {
if((state_val_68477 === (16))){
var inst_68352 = (state_68476[(2)]);
var state_68476__$1 = state_68476;
if(cljs.core.truth_(inst_68352)){
var statearr_68534_68596 = state_68476__$1;
(statearr_68534_68596[(1)] = (17));

} else {
var statearr_68535_68597 = state_68476__$1;
(statearr_68535_68597[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (38))){
var state_68476__$1 = state_68476;
var statearr_68536_68598 = state_68476__$1;
(statearr_68536_68598[(2)] = null);

(statearr_68536_68598[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (30))){
var inst_68464 = (state_68476[(2)]);
var _ = (function (){var statearr_68537 = state_68476;
(statearr_68537[(4)] = cljs.core.rest((state_68476[(4)])));

return statearr_68537;
})();
var state_68476__$1 = state_68476;
var statearr_68538_68599 = state_68476__$1;
(statearr_68538_68599[(2)] = inst_68464);

(statearr_68538_68599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (10))){
var inst_68334 = (state_68476[(10)]);
var inst_68336 = (state_68476[(2)]);
var inst_68340 = cljs.core.sequential_QMARK_(inst_68334);
var state_68476__$1 = (function (){var statearr_68539 = state_68476;
(statearr_68539[(24)] = inst_68336);

return statearr_68539;
})();
if(inst_68340){
var statearr_68540_68600 = state_68476__$1;
(statearr_68540_68600[(1)] = (11));

} else {
var statearr_68541_68601 = state_68476__$1;
(statearr_68541_68601[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (18))){
var inst_68336 = (state_68476[(24)]);
var inst_68334 = (state_68476[(10)]);
var inst_68356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68357 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68334], 0));
var inst_68358 = ["Error processing ledger request, no valid return channel: ",inst_68357].join('');
var inst_68359 = [inst_68336,inst_68358];
var inst_68360 = (new cljs.core.PersistentVector(null,2,(5),inst_68356,inst_68359,null));
var inst_68361 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68360);
var state_68476__$1 = state_68476;
var statearr_68542_68602 = state_68476__$1;
(statearr_68542_68602[(2)] = inst_68361);

(statearr_68542_68602[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (37))){
var inst_68433 = (state_68476[(7)]);
var inst_68452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68453 = ["Error processing message in producer. Socket closed. Published result",inst_68433];
var inst_68454 = (new cljs.core.PersistentVector(null,2,(5),inst_68452,inst_68453,null));
var inst_68455 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68454);
var state_68476__$1 = state_68476;
var statearr_68543_68603 = state_68476__$1;
(statearr_68543_68603[(2)] = inst_68455);

(statearr_68543_68603[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68477 === (8))){
var inst_68379 = (state_68476[(12)]);
var inst_68380 = (state_68476[(14)]);
var inst_68334 = (state_68476[(10)]);
var inst_68381 = (state_68476[(19)]);
var _ = (function (){var statearr_68544 = state_68476;
(statearr_68544[(4)] = cljs.core.cons((20),(state_68476[(4)])));

return statearr_68544;
})();
var inst_68373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68374 = ["Outgoing message to websocket: ",inst_68334];
var inst_68375 = (new cljs.core.PersistentVector(null,2,(5),inst_68373,inst_68374,null));
var inst_68376 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68375);
var inst_68377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68334,(0),null);
var inst_68378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68334,(1),null);
var inst_68379__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68334,(2),null);
var inst_68380__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68334,(3),null);
var inst_68381__$1 = cljs.core.__destructure_map(inst_68380__$1);
var inst_68382 = cljs.core.random_uuid();
var inst_68383 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68382);
var inst_68384 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_68381__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_68383);
var inst_68385 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_68381__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_68476__$1 = (function (){var statearr_68545 = state_68476;
(statearr_68545[(12)] = inst_68379__$1);

(statearr_68545[(13)] = inst_68384);

(statearr_68545[(14)] = inst_68380__$1);

(statearr_68545[(15)] = inst_68376);

(statearr_68545[(16)] = inst_68377);

(statearr_68545[(17)] = inst_68378);

(statearr_68545[(18)] = inst_68385);

(statearr_68545[(19)] = inst_68381__$1);

return statearr_68545;
})();
if(cljs.core.truth_(inst_68379__$1)){
var statearr_68546_68604 = state_68476__$1;
(statearr_68546_68604[(1)] = (21));

} else {
var statearr_68547_68605 = state_68476__$1;
(statearr_68547_68605[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_68548 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68548[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_68548[(1)] = (1));

return statearr_68548;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_68476){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68476);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68549){var ex__2687__auto__ = e68549;
var statearr_68550_68606 = state_68476;
(statearr_68550_68606[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68476[(4)]))){
var statearr_68551_68607 = state_68476;
(statearr_68551_68607[(1)] = cljs.core.first((state_68476[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68608 = state_68476;
state_68476 = G__68608;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_68476){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_68476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68552 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68552[(6)] = c__2706__auto__);

return statearr_68552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68646){
var state_val_68647 = (state_68646[(1)]);
if((state_val_68647 === (7))){
var inst_68617 = (state_68646[(7)]);
var state_68646__$1 = state_68646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68646__$1,(9),inst_68617);
} else {
if((state_val_68647 === (1))){
var inst_68609 = (1);
var state_68646__$1 = (function (){var statearr_68648 = state_68646;
(statearr_68648[(8)] = inst_68609);

return statearr_68648;
})();
var statearr_68649_68672 = state_68646__$1;
(statearr_68649_68672[(2)] = null);

(statearr_68649_68672[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (4))){
var inst_68614 = (state_68646[(2)]);
var inst_68615 = fluree.db.connection.get_socket(conn);
var state_68646__$1 = (function (){var statearr_68650 = state_68646;
(statearr_68650[(9)] = inst_68614);

return statearr_68650;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68646__$1,(5),inst_68615);
} else {
if((state_val_68647 === (15))){
var inst_68642 = (state_68646[(2)]);
var state_68646__$1 = state_68646;
var statearr_68651_68673 = state_68646__$1;
(statearr_68651_68673[(2)] = inst_68642);

(statearr_68651_68673[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (13))){
var inst_68609 = (state_68646[(8)]);
var inst_68624 = (state_68646[(10)]);
var inst_68632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68633 = [inst_68624,"Cannot establish connection to a healthy server, backing off:",inst_68609,"s."];
var inst_68634 = (new cljs.core.PersistentVector(null,4,(5),inst_68632,inst_68633,null));
var inst_68635 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68634);
var inst_68636 = ((2) * inst_68609);
var inst_68637 = ((60) * (2));
var inst_68638 = ((inst_68636 < inst_68637) ? inst_68636 : inst_68637);
var inst_68609__$1 = inst_68638;
var state_68646__$1 = (function (){var statearr_68652 = state_68646;
(statearr_68652[(11)] = inst_68635);

(statearr_68652[(8)] = inst_68609__$1);

return statearr_68652;
})();
var statearr_68653_68674 = state_68646__$1;
(statearr_68653_68674[(2)] = null);

(statearr_68653_68674[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (6))){
var inst_68617 = (state_68646[(7)]);
var state_68646__$1 = state_68646;
var statearr_68654_68675 = state_68646__$1;
(statearr_68654_68675[(2)] = inst_68617);

(statearr_68654_68675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (3))){
var inst_68644 = (state_68646[(2)]);
var state_68646__$1 = state_68646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68646__$1,inst_68644);
} else {
if((state_val_68647 === (12))){
var inst_68630 = (state_68646[(2)]);
var state_68646__$1 = state_68646;
if(cljs.core.truth_(inst_68630)){
var statearr_68655_68676 = state_68646__$1;
(statearr_68655_68676[(1)] = (13));

} else {
var statearr_68656_68677 = state_68646__$1;
(statearr_68656_68677[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (2))){
var inst_68609 = (state_68646[(8)]);
var inst_68611 = (inst_68609 * (1000));
var inst_68612 = cljs.core.async.timeout(inst_68611);
var state_68646__$1 = state_68646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68646__$1,(4),inst_68612);
} else {
if((state_val_68647 === (11))){
var inst_68624 = (state_68646[(10)]);
var inst_68628 = fluree.db.util.core.exception_QMARK_(inst_68624);
var state_68646__$1 = state_68646;
var statearr_68657_68678 = state_68646__$1;
(statearr_68657_68678[(2)] = inst_68628);

(statearr_68657_68678[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (9))){
var inst_68622 = (state_68646[(2)]);
var state_68646__$1 = state_68646;
var statearr_68658_68679 = state_68646__$1;
(statearr_68658_68679[(2)] = inst_68622);

(statearr_68658_68679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (5))){
var inst_68617 = (state_68646[(7)]);
var inst_68617__$1 = (state_68646[(2)]);
var inst_68618 = fluree.db.util.core.exception_QMARK_(inst_68617__$1);
var state_68646__$1 = (function (){var statearr_68659 = state_68646;
(statearr_68659[(7)] = inst_68617__$1);

return statearr_68659;
})();
if(inst_68618){
var statearr_68660_68680 = state_68646__$1;
(statearr_68660_68680[(1)] = (6));

} else {
var statearr_68661_68681 = state_68646__$1;
(statearr_68661_68681[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (14))){
var inst_68624 = (state_68646[(10)]);
var state_68646__$1 = state_68646;
var statearr_68662_68682 = state_68646__$1;
(statearr_68662_68682[(2)] = inst_68624);

(statearr_68662_68682[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (10))){
var inst_68625 = (state_68646[(12)]);
var state_68646__$1 = state_68646;
var statearr_68663_68683 = state_68646__$1;
(statearr_68663_68683[(2)] = inst_68625);

(statearr_68663_68683[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68647 === (8))){
var inst_68625 = (state_68646[(12)]);
var inst_68624 = (state_68646[(10)]);
var inst_68624__$1 = (state_68646[(2)]);
var inst_68625__$1 = (inst_68624__$1 == null);
var state_68646__$1 = (function (){var statearr_68664 = state_68646;
(statearr_68664[(12)] = inst_68625__$1);

(statearr_68664[(10)] = inst_68624__$1);

return statearr_68664;
})();
if(cljs.core.truth_(inst_68625__$1)){
var statearr_68665_68684 = state_68646__$1;
(statearr_68665_68684[(1)] = (10));

} else {
var statearr_68666_68685 = state_68646__$1;
(statearr_68666_68685[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0 = (function (){
var statearr_68667 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68667[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__);

(statearr_68667[(1)] = (1));

return statearr_68667;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1 = (function (state_68646){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68646);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68668){var ex__2687__auto__ = e68668;
var statearr_68669_68686 = state_68646;
(statearr_68669_68686[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68646[(4)]))){
var statearr_68670_68687 = state_68646;
(statearr_68670_68687[(1)] = cljs.core.first((state_68646[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68688 = state_68646;
state_68646 = G__68688;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = function(state_68646){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1.call(this,state_68646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68671 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68671[(6)] = c__2706__auto__);

return statearr_68671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__68689){
var map__68690 = p__68689;
var map__68690__$1 = cljs.core.__destructure_map(map__68690);
var conn = map__68690__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68690__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68690__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68690__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68690__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68801){
var state_val_68802 = (state_68801[(1)]);
if((state_val_68802 === (7))){
var inst_68797 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68803_68859 = state_68801__$1;
(statearr_68803_68859[(2)] = inst_68797);

(statearr_68803_68859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (20))){
var inst_68748 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68804_68860 = state_68801__$1;
(statearr_68804_68860[(2)] = inst_68748);

(statearr_68804_68860[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (27))){
var inst_68766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68767 = ["Connection closed."];
var inst_68768 = (new cljs.core.PersistentVector(null,1,(5),inst_68766,inst_68767,null));
var inst_68769 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_68768);
var state_68801__$1 = state_68801;
var statearr_68805_68861 = state_68801__$1;
(statearr_68805_68861[(2)] = inst_68769);

(statearr_68805_68861[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (1))){
var inst_68691 = (0);
var state_68801__$1 = (function (){var statearr_68806 = state_68801;
(statearr_68806[(7)] = inst_68691);

return statearr_68806;
})();
var statearr_68807_68862 = state_68801__$1;
(statearr_68807_68862[(2)] = null);

(statearr_68807_68862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (24))){
var inst_68735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68736 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_68737 = [keep_alive_fn];
var inst_68738 = cljs.core.PersistentHashMap.fromArrays(inst_68736,inst_68737);
var inst_68739 = ["Unsupported callback registered",inst_68738];
var inst_68740 = (new cljs.core.PersistentVector(null,2,(5),inst_68735,inst_68739,null));
var inst_68741 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68740);
var state_68801__$1 = state_68801;
var statearr_68808_68863 = state_68801__$1;
(statearr_68808_68863[(2)] = inst_68741);

(statearr_68808_68863[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (4))){
var inst_68696 = (state_68801[(8)]);
var inst_68701 = (state_68801[(2)]);
var inst_68702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68701,(0),null);
var inst_68703 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68701,(1),null);
var inst_68704 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68703,inst_68696);
var state_68801__$1 = (function (){var statearr_68809 = state_68801;
(statearr_68809[(9)] = inst_68702);

return statearr_68809;
})();
if(inst_68704){
var statearr_68810_68864 = state_68801__$1;
(statearr_68810_68864[(1)] = (5));

} else {
var statearr_68811_68865 = state_68801__$1;
(statearr_68811_68865[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (15))){
var inst_68721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68722 = ["No keep-alive callback is registered"];
var inst_68723 = (new cljs.core.PersistentVector(null,1,(5),inst_68721,inst_68722,null));
var inst_68724 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68723);
var state_68801__$1 = state_68801;
var statearr_68812_68866 = state_68801__$1;
(statearr_68812_68866[(2)] = inst_68724);

(statearr_68812_68866[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (21))){
var inst_68732 = cljs.core.eval(keep_alive_fn);
var state_68801__$1 = state_68801;
var statearr_68813_68867 = state_68801__$1;
(statearr_68813_68867[(2)] = inst_68732);

(statearr_68813_68867[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (31))){
var state_68801__$1 = state_68801;
var statearr_68814_68868 = state_68801__$1;
(statearr_68814_68868[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (32))){
var inst_68793 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68816_68869 = state_68801__$1;
(statearr_68816_68869[(2)] = inst_68793);

(statearr_68816_68869[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (33))){
var inst_68702 = (state_68801[(9)]);
var inst_68780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68781 = fluree.db.util.json.parse(inst_68702);
var inst_68782 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68781], 0));
var inst_68783 = ["Received message:",inst_68782];
var inst_68784 = (new cljs.core.PersistentVector(null,2,(5),inst_68780,inst_68783,null));
var inst_68785 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68784);
var inst_68786 = fluree.db.util.json.parse(inst_68702);
var inst_68787 = fluree.db.conn_events.process_events(conn,inst_68786);
var inst_68691 = (0);
var state_68801__$1 = (function (){var statearr_68817 = state_68801;
(statearr_68817[(7)] = inst_68691);

(statearr_68817[(10)] = inst_68785);

(statearr_68817[(11)] = inst_68787);

return statearr_68817;
})();
var statearr_68818_68870 = state_68801__$1;
(statearr_68818_68870[(2)] = null);

(statearr_68818_68870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (13))){
var inst_68756 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68819_68871 = state_68801__$1;
(statearr_68819_68871[(2)] = inst_68756);

(statearr_68819_68871[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (22))){
var state_68801__$1 = state_68801;
var statearr_68820_68872 = state_68801__$1;
(statearr_68820_68872[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (29))){
var inst_68795 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68822_68873 = state_68801__$1;
(statearr_68822_68873[(2)] = inst_68795);

(statearr_68822_68873[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (6))){
var inst_68702 = (state_68801[(9)]);
var inst_68764 = (inst_68702 == null);
var state_68801__$1 = state_68801;
if(cljs.core.truth_(inst_68764)){
var statearr_68823_68874 = state_68801__$1;
(statearr_68823_68874[(1)] = (27));

} else {
var statearr_68824_68875 = state_68801__$1;
(statearr_68824_68875[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (28))){
var inst_68702 = (state_68801[(9)]);
var inst_68771 = fluree.db.util.core.exception_QMARK_(inst_68702);
var state_68801__$1 = state_68801;
if(inst_68771){
var statearr_68825_68876 = state_68801__$1;
(statearr_68825_68876[(1)] = (30));

} else {
var statearr_68826_68877 = state_68801__$1;
(statearr_68826_68877[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (25))){
var state_68801__$1 = state_68801;
var statearr_68827_68878 = state_68801__$1;
(statearr_68827_68878[(2)] = null);

(statearr_68827_68878[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (34))){
var state_68801__$1 = state_68801;
var statearr_68828_68879 = state_68801__$1;
(statearr_68828_68879[(2)] = null);

(statearr_68828_68879[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (17))){
var inst_68750 = (state_68801[(2)]);
var inst_68751 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68752 = fluree.db.connection.close_websocket(inst_68751);
var inst_68753 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68754 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_68753);
var state_68801__$1 = (function (){var statearr_68829 = state_68801;
(statearr_68829[(12)] = inst_68750);

(statearr_68829[(13)] = inst_68752);

return statearr_68829;
})();
var statearr_68830_68880 = state_68801__$1;
(statearr_68830_68880[(2)] = inst_68754);

(statearr_68830_68880[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (3))){
var inst_68799 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68801__$1,inst_68799);
} else {
if((state_val_68802 === (12))){
var inst_68714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68715 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_68716 = (new cljs.core.PersistentVector(null,1,(5),inst_68714,inst_68715,null));
var inst_68717 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68716);
var inst_68718 = keep_alive_fn;
var inst_68719 = (keep_alive_fn == null);
var state_68801__$1 = (function (){var statearr_68831 = state_68801;
(statearr_68831[(14)] = inst_68718);

(statearr_68831[(15)] = inst_68717);

return statearr_68831;
})();
if(cljs.core.truth_(inst_68719)){
var statearr_68832_68881 = state_68801__$1;
(statearr_68832_68881[(1)] = (15));

} else {
var statearr_68833_68882 = state_68801__$1;
(statearr_68833_68882[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (2))){
var inst_68696 = (state_68801[(8)]);
var inst_68696__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_68697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68698 = [sub_chan,inst_68696__$1];
var inst_68699 = (new cljs.core.PersistentVector(null,2,(5),inst_68697,inst_68698,null));
var state_68801__$1 = (function (){var statearr_68834 = state_68801;
(statearr_68834[(8)] = inst_68696__$1);

return statearr_68834;
})();
return cljs.core.async.ioc_alts_BANG_(state_68801__$1,(4),inst_68699);
} else {
if((state_val_68802 === (23))){
var inst_68746 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68835_68883 = state_68801__$1;
(statearr_68835_68883[(2)] = inst_68746);

(statearr_68835_68883[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (35))){
var inst_68791 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68836_68884 = state_68801__$1;
(statearr_68836_68884[(2)] = inst_68791);

(statearr_68836_68884[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (19))){
var inst_68730 = typeof keep_alive_fn === 'string';
var state_68801__$1 = state_68801;
if(cljs.core.truth_(inst_68730)){
var statearr_68837_68885 = state_68801__$1;
(statearr_68837_68885[(1)] = (21));

} else {
var statearr_68838_68886 = state_68801__$1;
(statearr_68838_68886[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (11))){
var inst_68709 = fluree.db.connection.reconnect_conn(conn);
var state_68801__$1 = state_68801;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68801__$1,(14),inst_68709);
} else {
if((state_val_68802 === (9))){
var inst_68691 = (state_68801[(7)]);
var inst_68758 = fluree.db.connection.ping_transactor(req_chan);
var inst_68759 = (inst_68691 + (1));
var inst_68691__$1 = inst_68759;
var state_68801__$1 = (function (){var statearr_68839 = state_68801;
(statearr_68839[(7)] = inst_68691__$1);

(statearr_68839[(16)] = inst_68758);

return statearr_68839;
})();
var statearr_68840_68887 = state_68801__$1;
(statearr_68840_68887[(2)] = null);

(statearr_68840_68887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (5))){
var inst_68691 = (state_68801[(7)]);
var inst_68706 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_68691);
var state_68801__$1 = state_68801;
if(inst_68706){
var statearr_68841_68888 = state_68801__$1;
(statearr_68841_68888[(1)] = (8));

} else {
var statearr_68842_68889 = state_68801__$1;
(statearr_68842_68889[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (14))){
var inst_68711 = (state_68801[(2)]);
var inst_68691 = (0);
var state_68801__$1 = (function (){var statearr_68843 = state_68801;
(statearr_68843[(7)] = inst_68691);

(statearr_68843[(17)] = inst_68711);

return statearr_68843;
})();
var statearr_68844_68890 = state_68801__$1;
(statearr_68844_68890[(2)] = null);

(statearr_68844_68890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (26))){
var inst_68744 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68845_68891 = state_68801__$1;
(statearr_68845_68891[(2)] = inst_68744);

(statearr_68845_68891[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (16))){
var inst_68726 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_68801__$1 = state_68801;
if(inst_68726){
var statearr_68846_68892 = state_68801__$1;
(statearr_68846_68892[(1)] = (18));

} else {
var statearr_68847_68893 = state_68801__$1;
(statearr_68847_68893[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (30))){
var inst_68702 = (state_68801[(9)]);
var inst_68773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68774 = [inst_68702];
var inst_68775 = (new cljs.core.PersistentVector(null,1,(5),inst_68773,inst_68774,null));
var inst_68776 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68775);
var inst_68691 = (0);
var state_68801__$1 = (function (){var statearr_68848 = state_68801;
(statearr_68848[(7)] = inst_68691);

(statearr_68848[(18)] = inst_68776);

return statearr_68848;
})();
var statearr_68849_68894 = state_68801__$1;
(statearr_68849_68894[(2)] = null);

(statearr_68849_68894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (10))){
var inst_68762 = (state_68801[(2)]);
var state_68801__$1 = state_68801;
var statearr_68850_68895 = state_68801__$1;
(statearr_68850_68895[(2)] = inst_68762);

(statearr_68850_68895[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (18))){
var inst_68728 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_68801__$1 = state_68801;
var statearr_68851_68896 = state_68801__$1;
(statearr_68851_68896[(2)] = inst_68728);

(statearr_68851_68896[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68802 === (8))){
var state_68801__$1 = state_68801;
if(cljs.core.truth_(keep_alive)){
var statearr_68852_68897 = state_68801__$1;
(statearr_68852_68897[(1)] = (11));

} else {
var statearr_68853_68898 = state_68801__$1;
(statearr_68853_68898[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0 = (function (){
var statearr_68854 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68854[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2684__auto__);

(statearr_68854[(1)] = (1));

return statearr_68854;
});
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1 = (function (state_68801){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68801);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68855){var ex__2687__auto__ = e68855;
var statearr_68856_68899 = state_68801;
(statearr_68856_68899[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68801[(4)]))){
var statearr_68857_68900 = state_68801;
(statearr_68857_68900[(1)] = cljs.core.first((state_68801[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68901 = state_68801;
state_68801 = G__68901;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = function(state_68801){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1.call(this,state_68801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68858 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68858[(6)] = c__2706__auto__);

return statearr_68858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__68903 = arguments.length;
switch (G__68903) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__68904 = opts;
var map__68904__$1 = cljs.core.__destructure_map(map__68904);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68904__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68904__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68956){
var state_val_68957 = (state_68956[(1)]);
if((state_val_68957 === (7))){
var inst_68914 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_68915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68916 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_68917 = (new cljs.core.PersistentVector(null,2,(5),inst_68915,inst_68916,null));
var inst_68918 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68914,inst_68917);
var state_68956__$1 = state_68956;
var statearr_68958_68989 = state_68956__$1;
(statearr_68958_68989[(2)] = inst_68918);

(statearr_68958_68989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (1))){
var state_68956__$1 = state_68956;
var statearr_68959_68990 = state_68956__$1;
(statearr_68959_68990[(2)] = null);

(statearr_68959_68990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (4))){
var inst_68905 = (state_68956[(2)]);
var state_68956__$1 = state_68956;
var statearr_68960_68991 = state_68956__$1;
(statearr_68960_68991[(2)] = inst_68905);

(statearr_68960_68991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (15))){
var inst_68925 = (state_68956[(7)]);
var inst_68944 = (state_68956[(2)]);
var inst_68945 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_68946 = [(5000),inst_68944,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_68947 = cljs.core.PersistentHashMap.fromArrays(inst_68945,inst_68946);
var inst_68948 = fluree.db.util.xhttp.get(inst_68925,inst_68947);
var state_68956__$1 = state_68956;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68956__$1,(16),inst_68948);
} else {
if((state_val_68957 === (13))){
var inst_68925 = (state_68956[(7)]);
var inst_68935 = (state_68956[(8)]);
var inst_68937 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_68938 = [inst_68935];
var inst_68939 = cljs.core.PersistentHashMap.fromArrays(inst_68937,inst_68938);
var inst_68940 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_68925,inst_68939,private$);
var inst_68941 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_68940);
var state_68956__$1 = state_68956;
var statearr_68961_68992 = state_68956__$1;
(statearr_68961_68992[(2)] = inst_68941);

(statearr_68961_68992[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (6))){
var inst_68911 = (state_68956[(9)]);
var state_68956__$1 = state_68956;
var statearr_68962_68993 = state_68956__$1;
(statearr_68962_68993[(2)] = inst_68911);

(statearr_68962_68993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (3))){
var inst_68954 = (state_68956[(2)]);
var state_68956__$1 = state_68956;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68956__$1,inst_68954);
} else {
if((state_val_68957 === (12))){
var inst_68935 = (state_68956[(2)]);
var state_68956__$1 = (function (){var statearr_68963 = state_68956;
(statearr_68963[(8)] = inst_68935);

return statearr_68963;
})();
if(cljs.core.truth_(private$)){
var statearr_68964_68994 = state_68956__$1;
(statearr_68964_68994[(1)] = (13));

} else {
var statearr_68965_68995 = state_68956__$1;
(statearr_68965_68995[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (2))){
var inst_68911 = (state_68956[(9)]);
var _ = (function (){var statearr_68966 = state_68956;
(statearr_68966[(4)] = cljs.core.cons((5),(state_68956[(4)])));

return statearr_68966;
})();
var inst_68911__$1 = jwt;
var state_68956__$1 = (function (){var statearr_68967 = state_68956;
(statearr_68967[(9)] = inst_68911__$1);

return statearr_68967;
})();
if(cljs.core.truth_(inst_68911__$1)){
var statearr_68968_68996 = state_68956__$1;
(statearr_68968_68996[(1)] = (6));

} else {
var statearr_68969_68997 = state_68956__$1;
(statearr_68969_68997[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (11))){
var inst_68929 = (state_68956[(10)]);
var state_68956__$1 = state_68956;
var statearr_68971_68998 = state_68956__$1;
(statearr_68971_68998[(2)] = inst_68929);

(statearr_68971_68998[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (9))){
var inst_68921 = (state_68956[(11)]);
var inst_68920 = (state_68956[(12)]);
var inst_68924 = (state_68956[(2)]);
var inst_68925 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68924),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68921)].join('');
var inst_68927 = ["Accept"];
var inst_68928 = ["application/json"];
var inst_68929 = cljs.core.PersistentHashMap.fromArrays(inst_68927,inst_68928);
var state_68956__$1 = (function (){var statearr_68972 = state_68956;
(statearr_68972[(7)] = inst_68925);

(statearr_68972[(10)] = inst_68929);

return statearr_68972;
})();
if(cljs.core.truth_(inst_68920)){
var statearr_68973_68999 = state_68956__$1;
(statearr_68973_68999[(1)] = (10));

} else {
var statearr_68974_69000 = state_68956__$1;
(statearr_68974_69000[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (5))){
var _ = (function (){var statearr_68975 = state_68956;
(statearr_68975[(4)] = cljs.core.rest((state_68956[(4)])));

return statearr_68975;
})();
var state_68956__$1 = state_68956;
var ex68970 = (state_68956__$1[(2)]);
var statearr_68976_69001 = state_68956__$1;
(statearr_68976_69001[(5)] = ex68970);


if((ex68970 instanceof Error)){
var statearr_68977_69002 = state_68956__$1;
(statearr_68977_69002[(1)] = (4));

(statearr_68977_69002[(5)] = null);

} else {
throw ex68970;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (14))){
var inst_68935 = (state_68956[(8)]);
var state_68956__$1 = state_68956;
var statearr_68978_69003 = state_68956__$1;
(statearr_68978_69003[(2)] = inst_68935);

(statearr_68978_69003[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (16))){
var inst_68950 = (state_68956[(2)]);
var inst_68951 = fluree.db.util.async.throw_err(inst_68950);
var _ = (function (){var statearr_68979 = state_68956;
(statearr_68979[(4)] = cljs.core.rest((state_68956[(4)])));

return statearr_68979;
})();
var state_68956__$1 = state_68956;
var statearr_68980_69004 = state_68956__$1;
(statearr_68980_69004[(2)] = inst_68951);

(statearr_68980_69004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (10))){
var inst_68929 = (state_68956[(10)]);
var inst_68920 = (state_68956[(12)]);
var inst_68931 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68920)].join('');
var inst_68932 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_68929,"Authorization",inst_68931);
var state_68956__$1 = state_68956;
var statearr_68981_69005 = state_68956__$1;
(statearr_68981_69005[(2)] = inst_68932);

(statearr_68981_69005[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68957 === (8))){
var inst_68920 = (state_68956[(2)]);
var inst_68921 = clojure.string.replace(k,"_","/");
var inst_68922 = fluree.db.connection.get_server(conn_id,servers);
var state_68956__$1 = (function (){var statearr_68982 = state_68956;
(statearr_68982[(11)] = inst_68921);

(statearr_68982[(12)] = inst_68920);

return statearr_68982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68956__$1,(9),inst_68922);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_68983 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68983[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_68983[(1)] = (1));

return statearr_68983;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_68956){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68956);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68984){var ex__2687__auto__ = e68984;
var statearr_68985_69006 = state_68956;
(statearr_68985_69006[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68956[(4)]))){
var statearr_68986_69007 = state_68956;
(statearr_68986_69007[(1)] = cljs.core.first((state_68956[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69008 = state_68956;
state_68956 = G__69008;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_68956){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_68956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68987 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68987[(6)] = c__2706__auto__);

return statearr_68987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___69033 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___69033)){
var v_69034 = temp__5802__auto___69033;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_69034);
} else {
var c__2706__auto___69035 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69020){
var state_val_69021 = (state_69020[(1)]);
if((state_val_69021 === (1))){
var inst_69009 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_69020__$1 = state_69020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69020__$1,(2),inst_69009);
} else {
if((state_val_69021 === (2))){
var inst_69011 = (state_69020[(7)]);
var inst_69011__$1 = (state_69020[(2)]);
var inst_69012 = fluree.db.util.core.exception_QMARK_(inst_69011__$1);
var state_69020__$1 = (function (){var statearr_69022 = state_69020;
(statearr_69022[(7)] = inst_69011__$1);

return statearr_69022;
})();
if(inst_69012){
var statearr_69023_69036 = state_69020__$1;
(statearr_69023_69036[(1)] = (3));

} else {
var statearr_69024_69037 = state_69020__$1;
(statearr_69024_69037[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69021 === (3))){
var state_69020__$1 = state_69020;
var statearr_69025_69038 = state_69020__$1;
(statearr_69025_69038[(2)] = null);

(statearr_69025_69038[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69021 === (4))){
var inst_69011 = (state_69020[(7)]);
var inst_69015 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_69011);
var state_69020__$1 = state_69020;
var statearr_69026_69039 = state_69020__$1;
(statearr_69026_69039[(2)] = inst_69015);

(statearr_69026_69039[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69021 === (5))){
var inst_69011 = (state_69020[(7)]);
var inst_69017 = (state_69020[(2)]);
var inst_69018 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_69011);
var state_69020__$1 = (function (){var statearr_69027 = state_69020;
(statearr_69027[(8)] = inst_69017);

return statearr_69027;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69020__$1,inst_69018);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_69028 = [null,null,null,null,null,null,null,null,null];
(statearr_69028[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__);

(statearr_69028[(1)] = (1));

return statearr_69028;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1 = (function (state_69020){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69020);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69029){var ex__2687__auto__ = e69029;
var statearr_69030_69040 = state_69020;
(statearr_69030_69040[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69020[(4)]))){
var statearr_69031_69041 = state_69020;
(statearr_69031_69041[(1)] = cljs.core.first((state_69020[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69042 = state_69020;
state_69020 = G__69042;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = function(state_69020){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1.call(this,state_69020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69032 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69032[(6)] = c__2706__auto___69035);

return statearr_69032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__69043_SHARP_){
if(cljs.core.truth_(p1__69043_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__69044_SHARP_){
var or__5045__auto__ = p1__69044_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e69045){var e = e69045;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__69046 = opts;
var map__69046__$1 = cljs.core.__destructure_map(map__69046);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69046__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69046__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__69047_69048 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__69047_69048.cljs$core$IFn$_invoke$arity$0 ? fexpr__69047_69048.cljs$core$IFn$_invoke$arity$0() : fexpr__69047_69048.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69092 = arguments.length;
var i__5770__auto___69093 = (0);
while(true){
if((i__5770__auto___69093 < len__5769__auto___69092)){
args__5775__auto__.push((arguments[i__5770__auto___69093]));

var G__69094 = (i__5770__auto___69093 + (1));
i__5770__auto___69093 = G__69094;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__69051){
var vec__69052 = p__69051;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69052,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2706__auto___69095 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69075){
var state_val_69076 = (state_69075[(1)]);
if((state_val_69076 === (1))){
var inst_69055 = fluree.db.connection.get_socket(conn);
var state_69075__$1 = state_69075;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69075__$1,(2),inst_69055);
} else {
if((state_val_69076 === (2))){
var inst_69058 = (state_69075[(7)]);
var inst_69057 = (state_69075[(8)]);
var inst_69057__$1 = (state_69075[(2)]);
var inst_69058__$1 = (inst_69057__$1 == null);
var state_69075__$1 = (function (){var statearr_69077 = state_69075;
(statearr_69077[(7)] = inst_69058__$1);

(statearr_69077[(8)] = inst_69057__$1);

return statearr_69077;
})();
if(cljs.core.truth_(inst_69058__$1)){
var statearr_69078_69096 = state_69075__$1;
(statearr_69078_69096[(1)] = (3));

} else {
var statearr_69079_69097 = state_69075__$1;
(statearr_69079_69097[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (3))){
var inst_69058 = (state_69075[(7)]);
var state_69075__$1 = state_69075;
var statearr_69080_69098 = state_69075__$1;
(statearr_69080_69098[(2)] = inst_69058);

(statearr_69080_69098[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (4))){
var inst_69057 = (state_69075[(8)]);
var inst_69061 = fluree.db.util.core.exception_QMARK_(inst_69057);
var state_69075__$1 = state_69075;
var statearr_69081_69099 = state_69075__$1;
(statearr_69081_69099[(2)] = inst_69061);

(statearr_69081_69099[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (5))){
var inst_69063 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
if(cljs.core.truth_(inst_69063)){
var statearr_69082_69100 = state_69075__$1;
(statearr_69082_69100[(1)] = (6));

} else {
var statearr_69083_69101 = state_69075__$1;
(statearr_69083_69101[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (6))){
var inst_69057 = (state_69075[(8)]);
var inst_69065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69066 = [inst_69057,"Cannot establish connection to a healthy server, disconnecting."];
var inst_69067 = (new cljs.core.PersistentVector(null,2,(5),inst_69065,inst_69066,null));
var inst_69068 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69067);
var inst_69069 = cljs.core.async.close_BANG_(conn);
var state_69075__$1 = (function (){var statearr_69084 = state_69075;
(statearr_69084[(9)] = inst_69068);

return statearr_69084;
})();
var statearr_69085_69102 = state_69075__$1;
(statearr_69085_69102[(2)] = inst_69069);

(statearr_69085_69102[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (7))){
var inst_69071 = fluree.db.connection.msg_consumer(conn);
var state_69075__$1 = state_69075;
var statearr_69086_69103 = state_69075__$1;
(statearr_69086_69103[(2)] = inst_69071);

(statearr_69086_69103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69076 === (8))){
var inst_69073 = (state_69075[(2)]);
var state_69075__$1 = state_69075;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69075__$1,inst_69073);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_69087 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69087[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_69087[(1)] = (1));

return statearr_69087;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_69075){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69075);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69088){var ex__2687__auto__ = e69088;
var statearr_69089_69104 = state_69075;
(statearr_69089_69104[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69075[(4)]))){
var statearr_69090_69105 = state_69075;
(statearr_69090_69105[(1)] = cljs.core.first((state_69075[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69106 = state_69075;
state_69075 = G__69106;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_69075){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_69075);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69091 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69091[(6)] = c__2706__auto___69095);

return statearr_69091;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq69049){
var G__69050 = cljs.core.first(seq69049);
var seq69049__$1 = cljs.core.next(seq69049);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69050,seq69049__$1);
}));

