// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.dbfunctions.ctx');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__70058 = arguments.length;
switch (G__70058) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5802__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var block = temp__5802__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___70097 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70079){
var state_val_70080 = (state_70079[(1)]);
if((state_val_70080 === (1))){
var state_70079__$1 = state_70079;
var statearr_70081_70098 = state_70079__$1;
(statearr_70081_70098[(2)] = null);

(statearr_70081_70098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (2))){
var _ = (function (){var statearr_70082 = state_70079;
(statearr_70082[(4)] = cljs.core.cons((5),(state_70079[(4)])));

return statearr_70082;
})();
var inst_70065 = fluree.db.session.db(conn,ledger,null);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70079__$1,(7),inst_70065);
} else {
if((state_val_70080 === (3))){
var inst_70075 = (state_70079[(2)]);
var inst_70076 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70075);
var inst_70077 = cljs.core.async.close_BANG_(pc);
var state_70079__$1 = (function (){var statearr_70084 = state_70079;
(statearr_70084[(7)] = inst_70076);

return statearr_70084;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_70079__$1,inst_70077);
} else {
if((state_val_70080 === (4))){
var inst_70059 = (state_70079[(2)]);
var state_70079__$1 = state_70079;
var statearr_70085_70099 = state_70079__$1;
(statearr_70085_70099[(2)] = inst_70059);

(statearr_70085_70099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (5))){
var _ = (function (){var statearr_70086 = state_70079;
(statearr_70086[(4)] = cljs.core.rest((state_70079[(4)])));

return statearr_70086;
})();
var state_70079__$1 = state_70079;
var ex70083 = (state_70079__$1[(2)]);
var statearr_70087_70100 = state_70079__$1;
(statearr_70087_70100[(5)] = ex70083);


var statearr_70088_70101 = state_70079__$1;
(statearr_70088_70101[(1)] = (4));

(statearr_70088_70101[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (6))){
var inst_70071 = (state_70079[(2)]);
var inst_70072 = fluree.db.util.async.throw_err(inst_70071);
var _ = (function (){var statearr_70089 = state_70079;
(statearr_70089[(4)] = cljs.core.rest((state_70079[(4)])));

return statearr_70089;
})();
var state_70079__$1 = state_70079;
var statearr_70090_70102 = state_70079__$1;
(statearr_70090_70102[(2)] = inst_70072);

(statearr_70090_70102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70080 === (7))){
var inst_70067 = (state_70079[(2)]);
var inst_70068 = fluree.db.util.async.throw_err(inst_70067);
var inst_70069 = fluree.db.time_travel.as_of_block(inst_70068,block);
var state_70079__$1 = state_70079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70079__$1,(6),inst_70069);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_70091 = [null,null,null,null,null,null,null,null];
(statearr_70091[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_70091[(1)] = (1));

return statearr_70091;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_70079){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70079);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70092){var ex__2687__auto__ = e70092;
var statearr_70093_70103 = state_70079;
(statearr_70093_70103[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70079[(4)]))){
var statearr_70094_70104 = state_70079;
(statearr_70094_70104[(1)] = cljs.core.first((state_70079[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70105 = state_70079;
state_70079 = G__70105;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_70079){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_70079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70095 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70095[(6)] = c__2706__auto___70097);

return statearr_70095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t(db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70146){
var state_val_70147 = (state_70146[(1)]);
if((state_val_70147 === (7))){
var inst_70115 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_70146__$1 = state_70146;
if(inst_70115){
var statearr_70148_70179 = state_70146__$1;
(statearr_70148_70179[(1)] = (9));

} else {
var statearr_70149_70180 = state_70146__$1;
(statearr_70149_70180[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (1))){
var state_70146__$1 = state_70146;
var statearr_70150_70181 = state_70146__$1;
(statearr_70150_70181[(2)] = null);

(statearr_70150_70181[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (4))){
var inst_70106 = (state_70146[(2)]);
var state_70146__$1 = state_70146;
var statearr_70151_70182 = state_70146__$1;
(statearr_70151_70182[(2)] = inst_70106);

(statearr_70151_70182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (15))){
var inst_70123 = (state_70146[(7)]);
var inst_70122 = (state_70146[(2)]);
var inst_70123__$1 = fluree.db.util.async.throw_err(inst_70122);
var state_70146__$1 = (function (){var statearr_70152 = state_70146;
(statearr_70152[(7)] = inst_70123__$1);

return statearr_70152;
})();
if(cljs.core.truth_(inst_70123__$1)){
var statearr_70153_70183 = state_70146__$1;
(statearr_70153_70183[(1)] = (16));

} else {
var statearr_70154_70184 = state_70146__$1;
(statearr_70154_70184[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (13))){
var state_70146__$1 = state_70146;
var statearr_70155_70185 = state_70146__$1;
(statearr_70155_70185[(2)] = null);

(statearr_70155_70185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (6))){
var state_70146__$1 = state_70146;
var statearr_70156_70186 = state_70146__$1;
(statearr_70156_70186[(2)] = db);

(statearr_70156_70186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (17))){
var inst_70127 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_70128 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70129 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70130 = cljs.core.PersistentHashMap.fromArrays(inst_70128,inst_70129);
var inst_70131 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70127,inst_70130);
var inst_70132 = (function(){throw inst_70131})();
var state_70146__$1 = state_70146;
var statearr_70157_70187 = state_70146__$1;
(statearr_70157_70187[(2)] = inst_70132);

(statearr_70157_70187[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (3))){
var inst_70144 = (state_70146[(2)]);
var state_70146__$1 = state_70146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70146__$1,inst_70144);
} else {
if((state_val_70147 === (12))){
var inst_70120 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_70146__$1 = state_70146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70146__$1,(15),inst_70120);
} else {
if((state_val_70147 === (2))){
var _ = (function (){var statearr_70158 = state_70146;
(statearr_70158[(4)] = cljs.core.cons((5),(state_70146[(4)])));

return statearr_70158;
})();
var inst_70112 = cljs.core.not(auth);
var state_70146__$1 = state_70146;
if(inst_70112){
var statearr_70159_70188 = state_70146__$1;
(statearr_70159_70188[(1)] = (6));

} else {
var statearr_70160_70189 = state_70146__$1;
(statearr_70160_70189[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (11))){
var inst_70139 = (state_70146[(2)]);
var state_70146__$1 = state_70146;
var statearr_70162_70190 = state_70146__$1;
(statearr_70162_70190[(2)] = inst_70139);

(statearr_70162_70190[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (9))){
var inst_70117 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_70146__$1 = state_70146;
var statearr_70163_70191 = state_70146__$1;
(statearr_70163_70191[(2)] = inst_70117);

(statearr_70163_70191[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (5))){
var _ = (function (){var statearr_70164 = state_70146;
(statearr_70164[(4)] = cljs.core.rest((state_70146[(4)])));

return statearr_70164;
})();
var state_70146__$1 = state_70146;
var ex70161 = (state_70146__$1[(2)]);
var statearr_70165_70192 = state_70146__$1;
(statearr_70165_70192[(5)] = ex70161);


if((ex70161 instanceof Error)){
var statearr_70166_70193 = state_70146__$1;
(statearr_70166_70193[(1)] = (4));

(statearr_70166_70193[(5)] = null);

} else {
throw ex70161;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (14))){
var inst_70137 = (state_70146[(2)]);
var state_70146__$1 = state_70146;
var statearr_70167_70194 = state_70146__$1;
(statearr_70167_70194[(2)] = inst_70137);

(statearr_70167_70194[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (16))){
var inst_70123 = (state_70146[(7)]);
var inst_70125 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70123);
var state_70146__$1 = state_70146;
var statearr_70168_70195 = state_70146__$1;
(statearr_70168_70195[(2)] = inst_70125);

(statearr_70168_70195[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (10))){
var state_70146__$1 = state_70146;
var statearr_70169_70196 = state_70146__$1;
(statearr_70169_70196[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (18))){
var inst_70134 = (state_70146[(2)]);
var state_70146__$1 = state_70146;
var statearr_70171_70197 = state_70146__$1;
(statearr_70171_70197[(2)] = inst_70134);

(statearr_70171_70197[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70147 === (8))){
var inst_70141 = (state_70146[(2)]);
var _ = (function (){var statearr_70172 = state_70146;
(statearr_70172[(4)] = cljs.core.rest((state_70146[(4)])));

return statearr_70172;
})();
var state_70146__$1 = state_70146;
var statearr_70173_70198 = state_70146__$1;
(statearr_70173_70198[(2)] = inst_70141);

(statearr_70173_70198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0 = (function (){
var statearr_70174 = [null,null,null,null,null,null,null,null];
(statearr_70174[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__);

(statearr_70174[(1)] = (1));

return statearr_70174;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1 = (function (state_70146){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70146);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70175){var ex__2687__auto__ = e70175;
var statearr_70176_70199 = state_70146;
(statearr_70176_70199[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70146[(4)]))){
var statearr_70177_70200 = state_70146;
(statearr_70177_70200[(1)] = cljs.core.first((state_70146[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70201 = state_70146;
state_70146 = G__70201;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__ = function(state_70146){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1.call(this,state_70146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70178 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70178[(6)] = c__2706__auto__);

return statearr_70178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70273){
var state_val_70274 = (state_70273[(1)]);
if((state_val_70274 === (7))){
var inst_70211 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_70273__$1 = state_70273;
if(inst_70211){
var statearr_70275_70329 = state_70273__$1;
(statearr_70275_70329[(1)] = (9));

} else {
var statearr_70276_70330 = state_70273__$1;
(statearr_70276_70330[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (20))){
var inst_70235 = (state_70273[(7)]);
var state_70273__$1 = state_70273;
if(cljs.core.truth_(inst_70235)){
var statearr_70277_70331 = state_70273__$1;
(statearr_70277_70331[(1)] = (22));

} else {
var statearr_70278_70332 = state_70273__$1;
(statearr_70278_70332[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (27))){
var state_70273__$1 = state_70273;
var statearr_70279_70333 = state_70273__$1;
(statearr_70279_70333[(2)] = null);

(statearr_70279_70333[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (1))){
var state_70273__$1 = state_70273;
var statearr_70280_70334 = state_70273__$1;
(statearr_70280_70334[(2)] = null);

(statearr_70280_70334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (24))){
var inst_70249 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
var statearr_70281_70335 = state_70273__$1;
(statearr_70281_70335[(2)] = inst_70249);

(statearr_70281_70335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (4))){
var inst_70202 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
var statearr_70282_70336 = state_70273__$1;
(statearr_70282_70336[(2)] = inst_70202);

(statearr_70282_70336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (15))){
var inst_70218 = (state_70273[(8)]);
var inst_70217 = (state_70273[(2)]);
var inst_70218__$1 = fluree.db.util.async.throw_err(inst_70217);
var state_70273__$1 = (function (){var statearr_70283 = state_70273;
(statearr_70283[(8)] = inst_70218__$1);

return statearr_70283;
})();
if(cljs.core.truth_(inst_70218__$1)){
var statearr_70284_70337 = state_70273__$1;
(statearr_70284_70337[(1)] = (16));

} else {
var statearr_70285_70338 = state_70273__$1;
(statearr_70285_70338[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (21))){
var inst_70251 = (state_70273[(9)]);
var inst_70251__$1 = (state_70273[(2)]);
var state_70273__$1 = (function (){var statearr_70286 = state_70273;
(statearr_70286[(9)] = inst_70251__$1);

return statearr_70286;
})();
if(cljs.core.truth_(inst_70251__$1)){
var statearr_70287_70339 = state_70273__$1;
(statearr_70287_70339[(1)] = (29));

} else {
var statearr_70288_70340 = state_70273__$1;
(statearr_70288_70340[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (31))){
var inst_70251 = (state_70273[(9)]);
var inst_70259 = (state_70273[(2)]);
var state_70273__$1 = (function (){var statearr_70289 = state_70273;
(statearr_70289[(10)] = inst_70259);

return statearr_70289;
})();
if(cljs.core.truth_(inst_70251)){
var statearr_70290_70341 = state_70273__$1;
(statearr_70290_70341[(1)] = (33));

} else {
var statearr_70291_70342 = state_70273__$1;
(statearr_70291_70342[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (32))){
var inst_70255 = (state_70273[(2)]);
var inst_70256 = fluree.db.util.async.throw_err(inst_70255);
var state_70273__$1 = state_70273;
var statearr_70292_70343 = state_70273__$1;
(statearr_70292_70343[(2)] = inst_70256);

(statearr_70292_70343[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (33))){
var inst_70251 = (state_70273[(9)]);
var inst_70261 = fluree.db.permissions.permission_map(db,inst_70251,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_70273__$1 = state_70273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70273__$1,(36),inst_70261);
} else {
if((state_val_70274 === (13))){
var state_70273__$1 = state_70273;
var statearr_70293_70344 = state_70273__$1;
(statearr_70293_70344[(2)] = null);

(statearr_70293_70344[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (22))){
var inst_70235 = (state_70273[(7)]);
var inst_70239 = fluree.db.auth.roles(db,inst_70235);
var state_70273__$1 = state_70273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70273__$1,(25),inst_70239);
} else {
if((state_val_70274 === (36))){
var inst_70263 = (state_70273[(2)]);
var inst_70264 = fluree.db.util.async.throw_err(inst_70263);
var state_70273__$1 = state_70273;
var statearr_70294_70345 = state_70273__$1;
(statearr_70294_70345[(2)] = inst_70264);

(statearr_70294_70345[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (29))){
var inst_70251 = (state_70273[(9)]);
var inst_70235 = (state_70273[(7)]);
var inst_70253 = fluree.db.dbfunctions.ctx.build(db,inst_70235,inst_70251);
var state_70273__$1 = state_70273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70273__$1,(32),inst_70253);
} else {
if((state_val_70274 === (6))){
var state_70273__$1 = state_70273;
var statearr_70295_70346 = state_70273__$1;
(statearr_70295_70346[(2)] = null);

(statearr_70295_70346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (28))){
var inst_70247 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
var statearr_70296_70347 = state_70273__$1;
(statearr_70296_70347[(2)] = inst_70247);

(statearr_70296_70347[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (25))){
var inst_70241 = (state_70273[(2)]);
var inst_70242 = fluree.db.util.async.throw_err(inst_70241);
var state_70273__$1 = state_70273;
var statearr_70297_70348 = state_70273__$1;
(statearr_70297_70348[(2)] = inst_70242);

(statearr_70297_70348[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (34))){
var state_70273__$1 = state_70273;
var statearr_70298_70349 = state_70273__$1;
(statearr_70298_70349[(2)] = null);

(statearr_70298_70349[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (17))){
var inst_70221 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_70222 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70223 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_70224 = cljs.core.PersistentHashMap.fromArrays(inst_70222,inst_70223);
var inst_70225 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70221,inst_70224);
var inst_70226 = (function(){throw inst_70225})();
var state_70273__$1 = state_70273;
var statearr_70299_70350 = state_70273__$1;
(statearr_70299_70350[(2)] = inst_70226);

(statearr_70299_70350[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (3))){
var inst_70271 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70273__$1,inst_70271);
} else {
if((state_val_70274 === (12))){
var inst_70215 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_70273__$1 = state_70273;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70273__$1,(15),inst_70215);
} else {
if((state_val_70274 === (2))){
var _ = (function (){var statearr_70300 = state_70273;
(statearr_70300[(4)] = cljs.core.cons((5),(state_70273[(4)])));

return statearr_70300;
})();
var inst_70208 = (auth == null);
var state_70273__$1 = state_70273;
if(cljs.core.truth_(inst_70208)){
var statearr_70301_70351 = state_70273__$1;
(statearr_70301_70351[(1)] = (6));

} else {
var statearr_70302_70352 = state_70273__$1;
(statearr_70302_70352[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (23))){
var state_70273__$1 = state_70273;
var statearr_70303_70353 = state_70273__$1;
(statearr_70303_70353[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (35))){
var inst_70251 = (state_70273[(9)]);
var inst_70259 = (state_70273[(10)]);
var inst_70235 = (state_70273[(7)]);
var inst_70267 = (state_70273[(2)]);
var inst_70268 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_70235,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"auth-id","auth-id",444160740),auth,new cljs.core.Keyword(null,"roles","roles",143379530),inst_70251,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_70267,new cljs.core.Keyword(null,"ctx","ctx",-493610118),inst_70259], 0));
var _ = (function (){var statearr_70305 = state_70273;
(statearr_70305[(4)] = cljs.core.rest((state_70273[(4)])));

return statearr_70305;
})();
var state_70273__$1 = state_70273;
var statearr_70306_70354 = state_70273__$1;
(statearr_70306_70354[(2)] = inst_70268);

(statearr_70306_70354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (19))){
var state_70273__$1 = state_70273;
var statearr_70307_70355 = state_70273__$1;
(statearr_70307_70355[(2)] = roles);

(statearr_70307_70355[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (11))){
var inst_70233 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
var statearr_70309_70356 = state_70273__$1;
(statearr_70309_70356[(2)] = inst_70233);

(statearr_70309_70356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (9))){
var state_70273__$1 = state_70273;
var statearr_70310_70357 = state_70273__$1;
(statearr_70310_70357[(2)] = (0));

(statearr_70310_70357[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (5))){
var _ = (function (){var statearr_70311 = state_70273;
(statearr_70311[(4)] = cljs.core.rest((state_70273[(4)])));

return statearr_70311;
})();
var state_70273__$1 = state_70273;
var ex70308 = (state_70273__$1[(2)]);
var statearr_70312_70358 = state_70273__$1;
(statearr_70312_70358[(5)] = ex70308);


if((ex70308 instanceof Error)){
var statearr_70313_70359 = state_70273__$1;
(statearr_70313_70359[(1)] = (4));

(statearr_70313_70359[(5)] = null);

} else {
throw ex70308;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (14))){
var inst_70231 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
var statearr_70314_70360 = state_70273__$1;
(statearr_70314_70360[(2)] = inst_70231);

(statearr_70314_70360[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (26))){
var state_70273__$1 = state_70273;
var statearr_70315_70361 = state_70273__$1;
(statearr_70315_70361[(2)] = null);

(statearr_70315_70361[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (16))){
var inst_70218 = (state_70273[(8)]);
var state_70273__$1 = state_70273;
var statearr_70316_70362 = state_70273__$1;
(statearr_70316_70362[(2)] = inst_70218);

(statearr_70316_70362[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (30))){
var state_70273__$1 = state_70273;
var statearr_70317_70363 = state_70273__$1;
(statearr_70317_70363[(2)] = null);

(statearr_70317_70363[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (10))){
var state_70273__$1 = state_70273;
if(cljs.core.truth_(auth)){
var statearr_70318_70364 = state_70273__$1;
(statearr_70318_70364[(1)] = (12));

} else {
var statearr_70319_70365 = state_70273__$1;
(statearr_70319_70365[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (18))){
var inst_70228 = (state_70273[(2)]);
var state_70273__$1 = state_70273;
var statearr_70320_70366 = state_70273__$1;
(statearr_70320_70366[(2)] = inst_70228);

(statearr_70320_70366[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70274 === (8))){
var inst_70235 = (state_70273[(2)]);
var state_70273__$1 = (function (){var statearr_70321 = state_70273;
(statearr_70321[(7)] = inst_70235);

return statearr_70321;
})();
if(cljs.core.truth_(roles)){
var statearr_70322_70367 = state_70273__$1;
(statearr_70322_70367[(1)] = (19));

} else {
var statearr_70323_70368 = state_70273__$1;
(statearr_70323_70368[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0 = (function (){
var statearr_70324 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70324[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__);

(statearr_70324[(1)] = (1));

return statearr_70324;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1 = (function (state_70273){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70273);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70325){var ex__2687__auto__ = e70325;
var statearr_70326_70369 = state_70273;
(statearr_70326_70369[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70273[(4)]))){
var statearr_70327_70370 = state_70273;
(statearr_70327_70370[(1)] = cljs.core.first((state_70273[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70371 = state_70273;
state_70273 = G__70371;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__ = function(state_70273){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1.call(this,state_70273);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70328 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70328[(6)] = c__2706__auto__);

return statearr_70328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__70372 = db;
var map__70372__$1 = cljs.core.__destructure_map(map__70372);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70372__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70372__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70372__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70379){
var state_val_70380 = (state_70379[(1)]);
if((state_val_70380 === (1))){
var inst_70373 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_70374 = fluree.db.session.db(conn,inst_70373,null);
var state_70379__$1 = state_70379;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70379__$1,(2),inst_70374);
} else {
if((state_val_70380 === (2))){
var inst_70376 = (state_70379[(2)]);
var inst_70377 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_70376);
var state_70379__$1 = state_70379;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70379__$1,inst_70377);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_70381 = [null,null,null,null,null,null,null];
(statearr_70381[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_70381[(1)] = (1));

return statearr_70381;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_70379){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70379);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70382){var ex__2687__auto__ = e70382;
var statearr_70383_70410 = state_70379;
(statearr_70383_70410[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70379[(4)]))){
var statearr_70384_70411 = state_70379;
(statearr_70384_70411[(1)] = cljs.core.first((state_70379[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70412 = state_70379;
state_70379 = G__70412;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_70379){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_70379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70385 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70385[(6)] = c__2706__auto__);

return statearr_70385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,ledger_id,listen_id,event_fn);

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70398){
var state_val_70399 = (state_70398[(1)]);
if((state_val_70399 === (1))){
var inst_70386 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_70387 = fluree.db.session.db(conn,inst_70386,null);
var state_70398__$1 = state_70398;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70398__$1,(2),inst_70387);
} else {
if((state_val_70399 === (2))){
var inst_70389 = (state_70398[(7)]);
var inst_70389__$1 = (state_70398[(2)]);
var inst_70390 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_70389__$1);
var inst_70391 = newer_block_QMARK_(inst_70390);
var state_70398__$1 = (function (){var statearr_70400 = state_70398;
(statearr_70400[(7)] = inst_70389__$1);

return statearr_70400;
})();
if(inst_70391){
var statearr_70401_70413 = state_70398__$1;
(statearr_70401_70413[(1)] = (3));

} else {
var statearr_70402_70414 = state_70398__$1;
(statearr_70402_70414[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70399 === (3))){
var inst_70389 = (state_70398[(7)]);
var inst_70393 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_70389);
var state_70398__$1 = state_70398;
var statearr_70403_70415 = state_70398__$1;
(statearr_70403_70415[(2)] = inst_70393);

(statearr_70403_70415[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70399 === (4))){
var state_70398__$1 = state_70398;
var statearr_70404_70416 = state_70398__$1;
(statearr_70404_70416[(2)] = null);

(statearr_70404_70416[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70399 === (5))){
var inst_70396 = (state_70398[(2)]);
var state_70398__$1 = state_70398;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70398__$1,inst_70396);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0 = (function (){
var statearr_70405 = [null,null,null,null,null,null,null,null];
(statearr_70405[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__);

(statearr_70405[(1)] = (1));

return statearr_70405;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1 = (function (state_70398){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70398);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70406){var ex__2687__auto__ = e70406;
var statearr_70407_70417 = state_70398;
(statearr_70407_70417[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70398[(4)]))){
var statearr_70408_70418 = state_70398;
(statearr_70408_70418[(1)] = cljs.core.first((state_70398[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70419 = state_70398;
state_70398 = G__70419;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__ = function(state_70398){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1.call(this,state_70398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70409 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70409[(6)] = c__2706__auto__);

return statearr_70409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__70420 = db;
var map__70420__$1 = cljs.core.__destructure_map(map__70420);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70420__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70420__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70420__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var listen_id = cljs.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__5133__auto__ = syncTimeout;
var y__5134__auto__ = (120000);
return ((x__5133__auto__ < y__5134__auto__) ? x__5133__auto__ : y__5134__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2706__auto___70496 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70470){
var state_val_70471 = (state_70470[(1)]);
if((state_val_70471 === (7))){
var inst_70436 = (state_70470[(7)]);
var inst_70447 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70436,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_70470__$1 = state_70470;
if(inst_70447){
var statearr_70472_70497 = state_70470__$1;
(statearr_70472_70497[(1)] = (9));

} else {
var statearr_70473_70498 = state_70470__$1;
(statearr_70473_70498[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (1))){
var inst_70421 = (state_70470[(8)]);
var inst_70429 = (state_70470[(9)]);
var inst_70421__$1 = cljs.core.async.timeout(timeout);
var inst_70429__$1 = res_port;
var inst_70430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70431 = [inst_70421__$1,inst_70429__$1];
var inst_70432 = (new cljs.core.PersistentVector(null,2,(5),inst_70430,inst_70431,null));
var state_70470__$1 = (function (){var statearr_70474 = state_70470;
(statearr_70474[(8)] = inst_70421__$1);

(statearr_70474[(9)] = inst_70429__$1);

return statearr_70474;
})();
return cljs.core.async.ioc_alts_BANG_(state_70470__$1,(2),inst_70432);
} else {
if((state_val_70471 === (4))){
var inst_70429 = (state_70470[(9)]);
var inst_70436 = (state_70470[(7)]);
var inst_70440 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70436,inst_70429);
var state_70470__$1 = state_70470;
if(inst_70440){
var statearr_70475_70499 = state_70470__$1;
(statearr_70475_70499[(1)] = (6));

} else {
var statearr_70476_70500 = state_70470__$1;
(statearr_70476_70500[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (13))){
var inst_70455 = (state_70470[(10)]);
var inst_70466 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70455);
var state_70470__$1 = state_70470;
var statearr_70477_70501 = state_70470__$1;
(statearr_70477_70501[(2)] = inst_70466);

(statearr_70477_70501[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (6))){
var inst_70434 = (state_70470[(11)]);
var inst_70445 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70434,(0),null);
var state_70470__$1 = state_70470;
var statearr_70478_70502 = state_70470__$1;
(statearr_70478_70502[(2)] = inst_70445);

(statearr_70478_70502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (3))){
var state_70470__$1 = state_70470;
var statearr_70479_70503 = state_70470__$1;
(statearr_70479_70503[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_70479_70503[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (12))){
var inst_70459 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_70460 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70461 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_70462 = cljs.core.PersistentHashMap.fromArrays(inst_70460,inst_70461);
var inst_70463 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70459,inst_70462);
var inst_70464 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70463);
var state_70470__$1 = state_70470;
var statearr_70480_70504 = state_70470__$1;
(statearr_70480_70504[(2)] = inst_70464);

(statearr_70480_70504[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (2))){
var inst_70421 = (state_70470[(8)]);
var inst_70436 = (state_70470[(7)]);
var inst_70434 = (state_70470[(11)]);
var inst_70434__$1 = (state_70470[(2)]);
var inst_70435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70434__$1,(0),null);
var inst_70436__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70434__$1,(1),null);
var inst_70437 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_70436__$1,inst_70421);
var state_70470__$1 = (function (){var statearr_70481 = state_70470;
(statearr_70481[(7)] = inst_70436__$1);

(statearr_70481[(11)] = inst_70434__$1);

(statearr_70481[(12)] = inst_70435);

return statearr_70481;
})();
if(inst_70437){
var statearr_70482_70505 = state_70470__$1;
(statearr_70482_70505[(1)] = (3));

} else {
var statearr_70483_70506 = state_70470__$1;
(statearr_70483_70506[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (11))){
var inst_70451 = (state_70470[(2)]);
var state_70470__$1 = state_70470;
var statearr_70484_70507 = state_70470__$1;
(statearr_70484_70507[(2)] = inst_70451);

(statearr_70484_70507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (9))){
var inst_70435 = (state_70470[(12)]);
var state_70470__$1 = state_70470;
var statearr_70485_70508 = state_70470__$1;
(statearr_70485_70508[(2)] = inst_70435);

(statearr_70485_70508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (5))){
var inst_70455 = (state_70470[(10)]);
var inst_70455__$1 = (state_70470[(2)]);
var inst_70456 = fluree.db.connection.remove_listener(conn,network,ledger_id,listen_id);
var inst_70457 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_70455__$1);
var state_70470__$1 = (function (){var statearr_70486 = state_70470;
(statearr_70486[(13)] = inst_70456);

(statearr_70486[(10)] = inst_70455__$1);

return statearr_70486;
})();
if(inst_70457){
var statearr_70487_70509 = state_70470__$1;
(statearr_70487_70509[(1)] = (12));

} else {
var statearr_70488_70510 = state_70470__$1;
(statearr_70488_70510[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (14))){
var inst_70468 = (state_70470[(2)]);
var state_70470__$1 = state_70470;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70470__$1,inst_70468);
} else {
if((state_val_70471 === (10))){
var state_70470__$1 = state_70470;
var statearr_70489_70511 = state_70470__$1;
(statearr_70489_70511[(2)] = null);

(statearr_70489_70511[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70471 === (8))){
var inst_70453 = (state_70470[(2)]);
var state_70470__$1 = state_70470;
var statearr_70490_70512 = state_70470__$1;
(statearr_70490_70512[(2)] = inst_70453);

(statearr_70490_70512[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0 = (function (){
var statearr_70491 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70491[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__);

(statearr_70491[(1)] = (1));

return statearr_70491;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1 = (function (state_70470){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70470);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70492){var ex__2687__auto__ = e70492;
var statearr_70493_70513 = state_70470;
(statearr_70493_70513[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70470[(4)]))){
var statearr_70494_70514 = state_70470;
(statearr_70494_70514[(1)] = cljs.core.first((state_70470[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70515 = state_70470;
state_70470 = G__70515;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__ = function(state_70470){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1.call(this,state_70470);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70495 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70495[(6)] = c__2706__auto___70496);

return statearr_70495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__70517 = arguments.length;
switch (G__70517) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__70518){
var map__70519 = p__70518;
var map__70519__$1 = cljs.core.__destructure_map(map__70519);
var opts = map__70519__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70519__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2706__auto___70608 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70570){
var state_val_70571 = (state_70570[(1)]);
if((state_val_70571 === (7))){
var inst_70532 = (state_70570[(7)]);
var inst_70534 = fluree.db.api.ledger.syncTo_db(inst_70532,syncTo,syncTimeout);
var state_70570__$1 = state_70570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70570__$1,(10),inst_70534);
} else {
if((state_val_70571 === (20))){
var inst_70556 = (state_70570[(8)]);
var state_70570__$1 = state_70570;
var statearr_70572_70609 = state_70570__$1;
(statearr_70572_70609[(2)] = inst_70556);

(statearr_70572_70609[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (1))){
var state_70570__$1 = state_70570;
var statearr_70573_70610 = state_70570__$1;
(statearr_70573_70610[(2)] = null);

(statearr_70573_70610[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (4))){
var inst_70520 = (state_70570[(2)]);
var inst_70521 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70520);
var inst_70522 = cljs.core.async.close_BANG_(pc);
var state_70570__$1 = (function (){var statearr_70574 = state_70570;
(statearr_70574[(9)] = inst_70521);

return statearr_70574;
})();
var statearr_70575_70611 = state_70570__$1;
(statearr_70575_70611[(2)] = inst_70522);

(statearr_70575_70611[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (15))){
var inst_70548 = (state_70570[(10)]);
var inst_70550 = fluree.db.api.ledger.add_db_permissions(inst_70548,auth,roles);
var state_70570__$1 = state_70570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70570__$1,(18),inst_70550);
} else {
if((state_val_70571 === (21))){
var inst_70564 = (state_70570[(2)]);
var inst_70565 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_70564);
var _ = (function (){var statearr_70576 = state_70570;
(statearr_70576[(4)] = cljs.core.rest((state_70570[(4)])));

return statearr_70576;
})();
var state_70570__$1 = state_70570;
var statearr_70577_70612 = state_70570__$1;
(statearr_70577_70612[(2)] = inst_70565);

(statearr_70577_70612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (13))){
var inst_70548 = (state_70570[(2)]);
var state_70570__$1 = (function (){var statearr_70578 = state_70570;
(statearr_70578[(10)] = inst_70548);

return statearr_70578;
})();
if(cljs.core.truth_(roles)){
var statearr_70579_70613 = state_70570__$1;
(statearr_70579_70613[(1)] = (15));

} else {
var statearr_70580_70614 = state_70570__$1;
(statearr_70580_70614[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (22))){
var inst_70560 = (state_70570[(2)]);
var inst_70561 = fluree.db.util.async.throw_err(inst_70560);
var state_70570__$1 = state_70570;
var statearr_70581_70615 = state_70570__$1;
(statearr_70581_70615[(2)] = inst_70561);

(statearr_70581_70615[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (6))){
var inst_70531 = (state_70570[(2)]);
var inst_70532 = fluree.db.util.async.throw_err(inst_70531);
var state_70570__$1 = (function (){var statearr_70582 = state_70570;
(statearr_70582[(7)] = inst_70532);

return statearr_70582;
})();
if(cljs.core.truth_(syncTo)){
var statearr_70583_70616 = state_70570__$1;
(statearr_70583_70616[(1)] = (7));

} else {
var statearr_70584_70617 = state_70570__$1;
(statearr_70584_70617[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (17))){
var inst_70556 = (state_70570[(2)]);
var state_70570__$1 = (function (){var statearr_70585 = state_70570;
(statearr_70585[(8)] = inst_70556);

return statearr_70585;
})();
if(cljs.core.truth_(auth)){
var statearr_70586_70618 = state_70570__$1;
(statearr_70586_70618[(1)] = (19));

} else {
var statearr_70587_70619 = state_70570__$1;
(statearr_70587_70619[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (3))){
var inst_70568 = (state_70570[(2)]);
var state_70570__$1 = state_70570;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70570__$1,inst_70568);
} else {
if((state_val_70571 === (12))){
var inst_70540 = (state_70570[(11)]);
var state_70570__$1 = state_70570;
var statearr_70588_70620 = state_70570__$1;
(statearr_70588_70620[(2)] = inst_70540);

(statearr_70588_70620[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (2))){
var _ = (function (){var statearr_70589 = state_70570;
(statearr_70589[(4)] = cljs.core.cons((5),(state_70570[(4)])));

return statearr_70589;
})();
var inst_70529 = fluree.db.session.db(conn,ledger,opts_SINGLEQUOTE_);
var state_70570__$1 = state_70570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70570__$1,(6),inst_70529);
} else {
if((state_val_70571 === (19))){
var inst_70556 = (state_70570[(8)]);
var inst_70558 = fluree.db.api.ledger.add_db_permissions(inst_70556,auth,roles);
var state_70570__$1 = state_70570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70570__$1,(22),inst_70558);
} else {
if((state_val_70571 === (11))){
var inst_70540 = (state_70570[(11)]);
var inst_70542 = fluree.db.time_travel.as_of_block(inst_70540,block);
var state_70570__$1 = state_70570;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70570__$1,(14),inst_70542);
} else {
if((state_val_70571 === (9))){
var inst_70540 = (state_70570[(2)]);
var state_70570__$1 = (function (){var statearr_70591 = state_70570;
(statearr_70591[(11)] = inst_70540);

return statearr_70591;
})();
if(cljs.core.truth_(block)){
var statearr_70592_70621 = state_70570__$1;
(statearr_70592_70621[(1)] = (11));

} else {
var statearr_70593_70622 = state_70570__$1;
(statearr_70593_70622[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (5))){
var _ = (function (){var statearr_70594 = state_70570;
(statearr_70594[(4)] = cljs.core.rest((state_70570[(4)])));

return statearr_70594;
})();
var state_70570__$1 = state_70570;
var ex70590 = (state_70570__$1[(2)]);
var statearr_70595_70623 = state_70570__$1;
(statearr_70595_70623[(5)] = ex70590);


var statearr_70596_70624 = state_70570__$1;
(statearr_70596_70624[(1)] = (4));

(statearr_70596_70624[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (14))){
var inst_70544 = (state_70570[(2)]);
var inst_70545 = fluree.db.util.async.throw_err(inst_70544);
var state_70570__$1 = state_70570;
var statearr_70597_70625 = state_70570__$1;
(statearr_70597_70625[(2)] = inst_70545);

(statearr_70597_70625[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (16))){
var inst_70548 = (state_70570[(10)]);
var state_70570__$1 = state_70570;
var statearr_70598_70626 = state_70570__$1;
(statearr_70598_70626[(2)] = inst_70548);

(statearr_70598_70626[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (10))){
var inst_70536 = (state_70570[(2)]);
var inst_70537 = fluree.db.util.async.throw_err(inst_70536);
var state_70570__$1 = state_70570;
var statearr_70599_70627 = state_70570__$1;
(statearr_70599_70627[(2)] = inst_70537);

(statearr_70599_70627[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (18))){
var inst_70552 = (state_70570[(2)]);
var inst_70553 = fluree.db.util.async.throw_err(inst_70552);
var state_70570__$1 = state_70570;
var statearr_70600_70628 = state_70570__$1;
(statearr_70600_70628[(2)] = inst_70553);

(statearr_70600_70628[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70571 === (8))){
var inst_70532 = (state_70570[(7)]);
var state_70570__$1 = state_70570;
var statearr_70601_70629 = state_70570__$1;
(statearr_70601_70629[(2)] = inst_70532);

(statearr_70601_70629[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2684__auto__ = null;
var fluree$db$api$ledger$state_machine__2684__auto____0 = (function (){
var statearr_70602 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70602[(0)] = fluree$db$api$ledger$state_machine__2684__auto__);

(statearr_70602[(1)] = (1));

return statearr_70602;
});
var fluree$db$api$ledger$state_machine__2684__auto____1 = (function (state_70570){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70570);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70603){var ex__2687__auto__ = e70603;
var statearr_70604_70630 = state_70570;
(statearr_70604_70630[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70570[(4)]))){
var statearr_70605_70631 = state_70570;
(statearr_70605_70631[(1)] = cljs.core.first((state_70570[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70632 = state_70570;
state_70570 = G__70632;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2684__auto__ = function(state_70570){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2684__auto____1.call(this,state_70570);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2684__auto____0;
fluree$db$api$ledger$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2684__auto____1;
return fluree$db$api$ledger$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70606 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70606[(6)] = c__2706__auto___70608);

return statearr_70606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

