// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67830 = arguments.length;
var i__5770__auto___67831 = (0);
while(true){
if((i__5770__auto___67831 < len__5769__auto___67830)){
args__5775__auto__.push((arguments[i__5770__auto___67831]));

var G__67832 = (i__5770__auto___67831 + (1));
i__5770__auto___67831 = G__67832;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__67824){
var vec__67825 = p__67824;
var map__67828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67825,(0),null);
var map__67828__$1 = cljs.core.__destructure_map(map__67828);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67828__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67828__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__67829 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__67829__$1 = (((G__67829 instanceof cljs.core.Keyword))?G__67829.fqn:null);
switch (G__67829__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67829__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq67821){
var G__67822 = cljs.core.first(seq67821);
var seq67821__$1 = cljs.core.next(seq67821);
var G__67823 = cljs.core.first(seq67821__$1);
var seq67821__$2 = cljs.core.next(seq67821__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67822,G__67823,seq67821__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__5775__auto__ = [];
var len__5769__auto___67845 = arguments.length;
var i__5770__auto___67846 = (0);
while(true){
if((i__5770__auto___67846 < len__5769__auto___67845)){
args__5775__auto__.push((arguments[i__5770__auto___67846]));

var G__67847 = (i__5770__auto___67846 + (1));
i__5770__auto___67846 = G__67847;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__67838){
var vec__67839 = p__67838;
var map__67842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67839,(0),null);
var map__67842__$1 = cljs.core.__destructure_map(map__67842);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67842__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67842__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__67842__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__67843 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__67843__$1 = (((G__67843 instanceof cljs.core.Keyword))?G__67843.fqn:null);
switch (G__67843__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67843__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__67844 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__67844__$1 = (((G__67844 instanceof cljs.core.Keyword))?G__67844.fqn:null);
switch (G__67844__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67844__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq67835){
var G__67836 = cljs.core.first(seq67835);
var seq67835__$1 = cljs.core.next(seq67835);
var G__67837 = cljs.core.first(seq67835__$1);
var seq67835__$2 = cljs.core.next(seq67835__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67836,G__67837,seq67835__$2);
}));

