(ns alphabase.base64
  "Base 64 optimized namespace"
  (:require [clojure.set :as set]
            #?@(:cljs [[goog.crypt.base64 :as g-base64]]))
  #?(:clj (:import (java.util Base64))))

#?(:clj (set! *warn-on-reflection* true))

(def ^:const base64-chars "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=")
(def ^:const base64-set (set base64-chars))


(defn encode
  "Converts a byte array into a base64-check string."
  ^String
  [ba]
  #?(:clj  (-> (Base64/getEncoder)
               (.encodeToString ba))
     :cljs (g-base64/encodeByteArray ba)))


(defn decode
  "Decodes a base64-check string into a byte array."
  ^bytes
  [b64-string]
  #?(:clj  (-> (Base64/getDecoder)
               (.decode ^String b64-string))
     :cljs (g-base64/decodeStringToByteArray b64-string)))


(defn base64?
  "Test if input is base64"
  [x]
  (and (string? x) (set/subset? (set x) base64-set)))
