// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__5045__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_12318){
var state_val_12319 = (state_12318[(1)]);
if((state_val_12319 === (7))){
var inst_12313 = (state_12318[(2)]);
var _ = (function (){var statearr_12320 = state_12318;
(statearr_12320[(4)] = cljs.core.rest.call(null,(state_12318[(4)])));

return statearr_12320;
})();
var state_12318__$1 = state_12318;
var statearr_12321_12343 = state_12318__$1;
(statearr_12321_12343[(2)] = inst_12313);

(statearr_12321_12343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (1))){
var state_12318__$1 = state_12318;
var statearr_12322_12344 = state_12318__$1;
(statearr_12322_12344[(2)] = null);

(statearr_12322_12344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (4))){
var inst_12275 = (state_12318[(2)]);
var state_12318__$1 = state_12318;
var statearr_12323_12345 = state_12318__$1;
(statearr_12323_12345[(2)] = inst_12275);

(statearr_12323_12345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (6))){
var inst_12300 = (state_12318[(7)]);
var inst_12293 = (state_12318[(8)]);
var inst_12299 = cljs.core.seq.call(null,inst_12293);
var inst_12300__$1 = cljs.core.first.call(null,inst_12299);
var inst_12301 = cljs.core.next.call(null,inst_12299);
var inst_12302 = cljs.core.not.call(null,inst_12300__$1);
var state_12318__$1 = (function (){var statearr_12324 = state_12318;
(statearr_12324[(7)] = inst_12300__$1);

(statearr_12324[(9)] = inst_12301);

return statearr_12324;
})();
if(inst_12302){
var statearr_12325_12346 = state_12318__$1;
(statearr_12325_12346[(1)] = (8));

} else {
var statearr_12326_12347 = state_12318__$1;
(statearr_12326_12347[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (3))){
var inst_12316 = (state_12318[(2)]);
var state_12318__$1 = state_12318;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12318__$1,inst_12316);
} else {
if((state_val_12319 === (2))){
var _ = (function (){var statearr_12327 = state_12318;
(statearr_12327[(4)] = cljs.core.cons.call(null,(5),(state_12318[(4)])));

return statearr_12327;
})();
var inst_12288 = chs;
var inst_12289 = cljs.core.seq.call(null,inst_12288);
var inst_12290 = cljs.core.first.call(null,inst_12289);
var inst_12291 = cljs.core.next.call(null,inst_12289);
var inst_12292 = coll;
var inst_12293 = inst_12288;
var inst_12294 = inst_12292;
var state_12318__$1 = (function (){var statearr_12328 = state_12318;
(statearr_12328[(10)] = inst_12290);

(statearr_12328[(11)] = inst_12294);

(statearr_12328[(8)] = inst_12293);

(statearr_12328[(12)] = inst_12291);

return statearr_12328;
})();
var statearr_12329_12348 = state_12318__$1;
(statearr_12329_12348[(2)] = null);

(statearr_12329_12348[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (11))){
var inst_12294 = (state_12318[(11)]);
var inst_12301 = (state_12318[(9)]);
var inst_12306 = (state_12318[(2)]);
var inst_12307 = fluree.db.util.async.throw_err.call(null,inst_12306);
var inst_12308 = cljs.core.conj.call(null,inst_12294,inst_12307);
var inst_12293 = inst_12301;
var inst_12294__$1 = inst_12308;
var state_12318__$1 = (function (){var statearr_12331 = state_12318;
(statearr_12331[(11)] = inst_12294__$1);

(statearr_12331[(8)] = inst_12293);

return statearr_12331;
})();
var statearr_12332_12349 = state_12318__$1;
(statearr_12332_12349[(2)] = null);

(statearr_12332_12349[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (9))){
var inst_12300 = (state_12318[(7)]);
var state_12318__$1 = state_12318;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12318__$1,(11),inst_12300);
} else {
if((state_val_12319 === (5))){
var _ = (function (){var statearr_12333 = state_12318;
(statearr_12333[(4)] = cljs.core.rest.call(null,(state_12318[(4)])));

return statearr_12333;
})();
var state_12318__$1 = state_12318;
var ex12330 = (state_12318__$1[(2)]);
var statearr_12334_12350 = state_12318__$1;
(statearr_12334_12350[(5)] = ex12330);


var statearr_12335_12351 = state_12318__$1;
(statearr_12335_12351[(1)] = (4));

(statearr_12335_12351[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (10))){
var inst_12311 = (state_12318[(2)]);
var state_12318__$1 = state_12318;
var statearr_12336_12352 = state_12318__$1;
(statearr_12336_12352[(2)] = inst_12311);

(statearr_12336_12352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12319 === (8))){
var inst_12294 = (state_12318[(11)]);
var state_12318__$1 = state_12318;
var statearr_12337_12353 = state_12318__$1;
(statearr_12337_12353[(2)] = inst_12294);

(statearr_12337_12353[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_12338 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12338[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__);

(statearr_12338[(1)] = (1));

return statearr_12338;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1 = (function (state_12318){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_12318);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e12339){var ex__2749__auto__ = e12339;
var statearr_12340_12354 = state_12318;
(statearr_12340_12354[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_12318[(4)]))){
var statearr_12341_12355 = state_12318;
(statearr_12341_12355[(1)] = cljs.core.first.call(null,(state_12318[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12356 = state_12318;
state_12318 = G__12356;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__ = function(state_12318){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1.call(this,state_12318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_12342 = f__2769__auto__.call(null);
(statearr_12342[(6)] = c__2768__auto__);

return statearr_12342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_12382){
var state_val_12383 = (state_12382[(1)]);
if((state_val_12383 === (7))){
var inst_12377 = (state_12382[(2)]);
var _ = (function (){var statearr_12384 = state_12382;
(statearr_12384[(4)] = cljs.core.rest.call(null,(state_12382[(4)])));

return statearr_12384;
})();
var state_12382__$1 = state_12382;
var statearr_12385_12407 = state_12382__$1;
(statearr_12385_12407[(2)] = inst_12377);

(statearr_12385_12407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (1))){
var state_12382__$1 = state_12382;
var statearr_12386_12408 = state_12382__$1;
(statearr_12386_12408[(2)] = null);

(statearr_12386_12408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (4))){
var inst_12357 = (state_12382[(2)]);
var state_12382__$1 = state_12382;
var statearr_12387_12409 = state_12382__$1;
(statearr_12387_12409[(2)] = inst_12357);

(statearr_12387_12409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (6))){
var state_12382__$1 = state_12382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12382__$1,(8),chan);
} else {
if((state_val_12383 === (3))){
var inst_12380 = (state_12382[(2)]);
var state_12382__$1 = state_12382;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12382__$1,inst_12380);
} else {
if((state_val_12383 === (2))){
var _ = (function (){var statearr_12388 = state_12382;
(statearr_12388[(4)] = cljs.core.cons.call(null,(5),(state_12382[(4)])));

return statearr_12388;
})();
var inst_12363 = coll;
var inst_12364 = inst_12363;
var state_12382__$1 = (function (){var statearr_12389 = state_12382;
(statearr_12389[(7)] = inst_12364);

return statearr_12389;
})();
var statearr_12390_12410 = state_12382__$1;
(statearr_12390_12410[(2)] = null);

(statearr_12390_12410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (11))){
var inst_12375 = (state_12382[(2)]);
var state_12382__$1 = state_12382;
var statearr_12392_12411 = state_12382__$1;
(statearr_12392_12411[(2)] = inst_12375);

(statearr_12392_12411[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (9))){
var inst_12364 = (state_12382[(7)]);
var state_12382__$1 = state_12382;
var statearr_12393_12412 = state_12382__$1;
(statearr_12393_12412[(2)] = inst_12364);

(statearr_12393_12412[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (5))){
var _ = (function (){var statearr_12394 = state_12382;
(statearr_12394[(4)] = cljs.core.rest.call(null,(state_12382[(4)])));

return statearr_12394;
})();
var state_12382__$1 = state_12382;
var ex12391 = (state_12382__$1[(2)]);
var statearr_12395_12413 = state_12382__$1;
(statearr_12395_12413[(5)] = ex12391);


var statearr_12396_12414 = state_12382__$1;
(statearr_12396_12414[(1)] = (4));

(statearr_12396_12414[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (10))){
var inst_12364 = (state_12382[(7)]);
var inst_12368 = (state_12382[(8)]);
var inst_12372 = cljs.core.conj.call(null,inst_12364,inst_12368);
var inst_12364__$1 = inst_12372;
var state_12382__$1 = (function (){var statearr_12397 = state_12382;
(statearr_12397[(7)] = inst_12364__$1);

return statearr_12397;
})();
var statearr_12398_12415 = state_12382__$1;
(statearr_12398_12415[(2)] = null);

(statearr_12398_12415[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12383 === (8))){
var inst_12368 = (state_12382[(8)]);
var inst_12367 = (state_12382[(2)]);
var inst_12368__$1 = fluree.db.util.async.throw_err.call(null,inst_12367);
var inst_12369 = (inst_12368__$1 == null);
var state_12382__$1 = (function (){var statearr_12399 = state_12382;
(statearr_12399[(8)] = inst_12368__$1);

return statearr_12399;
})();
if(cljs.core.truth_(inst_12369)){
var statearr_12400_12416 = state_12382__$1;
(statearr_12400_12416[(1)] = (9));

} else {
var statearr_12401_12417 = state_12382__$1;
(statearr_12401_12417[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_12402 = [null,null,null,null,null,null,null,null,null];
(statearr_12402[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__);

(statearr_12402[(1)] = (1));

return statearr_12402;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1 = (function (state_12382){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_12382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e12403){var ex__2749__auto__ = e12403;
var statearr_12404_12418 = state_12382;
(statearr_12404_12418[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_12382[(4)]))){
var statearr_12405_12419 = state_12382;
(statearr_12405_12419[(1)] = cljs.core.first.call(null,(state_12382[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12420 = state_12382;
state_12382 = G__12420;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__ = function(state_12382){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1.call(this,state_12382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2746__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_12406 = f__2769__auto__.call(null);
(statearr_12406[(6)] = c__2768__auto__);

return statearr_12406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
