// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.token_auth');
goog.require('cljs.core');
goog.require('fluree.crypto.hmac');
goog.require('alphabase.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('clojure.string');
fluree.db.token_auth.base64__GT_base64url = (function fluree$db$token_auth$base64__GT_base64url(b64){
return clojure.string.replace.call(null,clojure.string.replace.call(null,clojure.string.replace.call(null,b64,/=+$/,""),/\+/,"-"),/\//,"_");
});
fluree.db.token_auth.jwt_header = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"alg","alg",-830920638),"HS256",new cljs.core.Keyword(null,"typ","typ",-1304536900),"JWT"], null);
fluree.db.token_auth.jwt_header_enc = fluree.db.token_auth.base64__GT_base64url.call(null,alphabase.core.bytes__GT_base64.call(null,fluree.db.util.json.stringify_UTF8.call(null,fluree.db.token_auth.jwt_header)));
/**
 * Generates jwt signature as base64URL using secret given a string token.
 */
fluree.db.token_auth.generate_jwt_sig = (function fluree$db$token_auth$generate_jwt_sig(secret,token){
return fluree.db.token_auth.base64__GT_base64url.call(null,alphabase.core.bytes__GT_base64.call(null,fluree.crypto.hmac.hmac_sha256.call(null,alphabase.core.string__GT_bytes.call(null,token),secret)));
});
/**
 * Generates a HS256 JWT token containing data as a map and secured with secret.
 */
fluree.db.token_auth.generate_jwt = (function fluree$db$token_auth$generate_jwt(secret,payload){
var data_enc = fluree.db.token_auth.base64__GT_base64url.call(null,alphabase.core.bytes__GT_base64.call(null,fluree.db.util.json.stringify_UTF8.call(null,payload)));
var token = [fluree.db.token_auth.jwt_header_enc,".",data_enc].join('');
var hs256 = fluree.db.token_auth.generate_jwt_sig.call(null,secret,token);
return [token,".",hs256].join('');
});
/**
 * Returns the JWT payload as map if valid, else an exception.
 */
fluree.db.token_auth.verify_jwt = (function fluree$db$token_auth$verify_jwt(secret,jwt){
var vec__68955 = clojure.string.split.call(null,jwt,/\./);
var header = cljs.core.nth.call(null,vec__68955,(0),null);
var payload = cljs.core.nth.call(null,vec__68955,(1),null);
var sig = cljs.core.nth.call(null,vec__68955,(2),null);
var header_STAR_ = (function (){try{return fluree.db.util.json.parse.call(null,alphabase.core.base64__GT_bytes.call(null,header));
}catch (e68958){var e = e68958;
throw cljs.core.ex_info.call(null,"Invalid JWT header.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"reason","reason",-2070751759),e.getMessage()], null)], null));
}})();
var token = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(header),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(payload)].join('');
var sig_STAR_ = fluree.db.token_auth.generate_jwt_sig.call(null,secret,token);
var _ = ((cljs.core.not_EQ_.call(null,header_STAR_,fluree.db.token_auth.jwt_header))?(function(){throw cljs.core.ex_info.call(null,"Invalid JWT header. Only HS256 algorithm supported.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"header","header",119441134),header_STAR_], null)], null))})():null);
var ___$1 = ((cljs.core.not_EQ_.call(null,sig_STAR_,sig))?(function(){throw cljs.core.ex_info.call(null,"Invalid JWT signature.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null)], null))})():null);
var payload_STAR_ = (function (){try{return fluree.db.util.json.parse.call(null,alphabase.core.base64__GT_bytes.call(null,payload));
}catch (e68959){var e = e68959;
throw cljs.core.ex_info.call(null,"Invalid JWT payload.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-token","db/invalid-token",2042659556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"reason","reason",-2070751759),e.getMessage()], null)], null));
}})();
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"exp","exp",-261706262).cljs$core$IFn$_invoke$arity$1(payload_STAR_);
if(cljs.core.truth_(and__5043__auto__)){
return (new cljs.core.Keyword(null,"exp","exp",-261706262).cljs$core$IFn$_invoke$arity$1(payload_STAR_) < fluree.db.util.core.current_time_millis.call(null));
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"JWT has expired.",new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","expired-token","db/expired-token",-311685617),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null)], null));
} else {
}

return payload_STAR_;
});
