// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27119,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27123 = k27119;
var G__27123__$1 = (((G__27123 instanceof cljs.core.Keyword))?G__27123.fqn:null);
switch (G__27123__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27119,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__27124){
var vec__27125 = p__27124;
var k__5367__auto__ = cljs.core.nth.call(null,vec__27125,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__27125,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27118){
var self__ = this;
var G__27118__$1 = this;
return (new cljs.core.RecordIter((0),G__27118__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27120,other27121){
var self__ = this;
var this27120__$1 = this;
return (((!((other27121 == null)))) && ((((this27120__$1.constructor === other27121.constructor)) && (((cljs.core._EQ_.call(null,this27120__$1.conn,other27121.conn)) && (((cljs.core._EQ_.call(null,this27120__$1.network,other27121.network)) && (((cljs.core._EQ_.call(null,this27120__$1.ledger_id,other27121.ledger_id)) && (((cljs.core._EQ_.call(null,this27120__$1.db_name,other27121.db_name)) && (((cljs.core._EQ_.call(null,this27120__$1.update_chan,other27121.update_chan)) && (((cljs.core._EQ_.call(null,this27120__$1.transact_chan,other27121.transact_chan)) && (((cljs.core._EQ_.call(null,this27120__$1.state,other27121.state)) && (((cljs.core._EQ_.call(null,this27120__$1.schema_cache,other27121.schema_cache)) && (((cljs.core._EQ_.call(null,this27120__$1.blank_db,other27121.blank_db)) && (((cljs.core._EQ_.call(null,this27120__$1.close,other27121.close)) && (((cljs.core._EQ_.call(null,this27120__$1.id,other27121.id)) && (cljs.core._EQ_.call(null,this27120__$1.__extmap,other27121.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27119){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27128 = k27119;
var G__27128__$1 = (((G__27128 instanceof cljs.core.Keyword))?G__27128.fqn:null);
switch (G__27128__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27119);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27118){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27129 = cljs.core.keyword_identical_QMARK_;
var expr__27130 = k__5352__auto__;
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27130))){
return (new fluree.db.session.DbSession(G__27118,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,G__27118,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27118,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__27118,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__27118,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__27118,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__27118,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27118,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27118,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27118,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27129.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27130))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27118,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__27118),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27118){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27118,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27122){
var extmap__5385__auto__ = (function (){var G__27132 = cljs.core.dissoc.call(null,G__27122,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27122)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27132);
} else {
return G__27132;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27122),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27122),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27135 = session;
var map__27135__$1 = cljs.core.__destructure_map.call(null,map__27135);
var network = cljs.core.get.call(null,map__27135__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27135__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27177){
var state_val_27178 = (state_27177[(1)]);
if((state_val_27178 === (7))){
var inst_27151 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_27152 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27153 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27154 = cljs.core.PersistentHashMap.fromArrays(inst_27152,inst_27153);
var inst_27155 = cljs.core.ex_info.call(null,inst_27151,inst_27154);
var inst_27156 = (function(){throw inst_27155})();
var state_27177__$1 = state_27177;
var statearr_27179_27202 = state_27177__$1;
(statearr_27179_27202[(2)] = inst_27156);

(statearr_27179_27202[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (1))){
var state_27177__$1 = state_27177;
var statearr_27180_27203 = state_27177__$1;
(statearr_27180_27203[(2)] = null);

(statearr_27180_27203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (4))){
var inst_27136 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
var statearr_27181_27204 = state_27177__$1;
(statearr_27181_27204[(2)] = inst_27136);

(statearr_27181_27204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (6))){
var inst_27148 = (state_27177[(7)]);
var inst_27147 = (state_27177[(2)]);
var inst_27148__$1 = fluree.db.util.async.throw_err.call(null,inst_27147);
var inst_27149 = cljs.core.empty_QMARK_.call(null,inst_27148__$1);
var state_27177__$1 = (function (){var statearr_27182 = state_27177;
(statearr_27182[(7)] = inst_27148__$1);

return statearr_27182;
})();
if(inst_27149){
var statearr_27183_27205 = state_27177__$1;
(statearr_27183_27205[(1)] = (7));

} else {
var statearr_27184_27206 = state_27177__$1;
(statearr_27184_27206[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (3))){
var inst_27175 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27177__$1,inst_27175);
} else {
if((state_val_27178 === (12))){
var inst_27170 = (state_27177[(2)]);
var state_27177__$1 = state_27177;
var statearr_27185_27207 = state_27177__$1;
(statearr_27185_27207[(2)] = inst_27170);

(statearr_27185_27207[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (2))){
var _ = (function (){var statearr_27186 = state_27177;
(statearr_27186[(4)] = cljs.core.cons.call(null,(5),(state_27177[(4)])));

return statearr_27186;
})();
var inst_27142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27143 = [network,ledger_id];
var inst_27144 = (new cljs.core.PersistentVector(null,2,(5),inst_27142,inst_27143,null));
var inst_27145 = fluree.db.operations.ledger_info_async.call(null,conn,inst_27144);
var state_27177__$1 = state_27177;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27177__$1,(6),inst_27145);
} else {
if((state_val_27178 === (11))){
var inst_27148 = (state_27177[(7)]);
var state_27177__$1 = state_27177;
var statearr_27188_27208 = state_27177__$1;
(statearr_27188_27208[(2)] = inst_27148);

(statearr_27188_27208[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (9))){
var inst_27172 = (state_27177[(2)]);
var _ = (function (){var statearr_27189 = state_27177;
(statearr_27189[(4)] = cljs.core.rest.call(null,(state_27177[(4)])));

return statearr_27189;
})();
var state_27177__$1 = state_27177;
var statearr_27190_27209 = state_27177__$1;
(statearr_27190_27209[(2)] = inst_27172);

(statearr_27190_27209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (5))){
var _ = (function (){var statearr_27191 = state_27177;
(statearr_27191[(4)] = cljs.core.rest.call(null,(state_27177[(4)])));

return statearr_27191;
})();
var state_27177__$1 = state_27177;
var ex27187 = (state_27177__$1[(2)]);
var statearr_27192_27210 = state_27177__$1;
(statearr_27192_27210[(5)] = ex27187);


if((ex27187 instanceof Error)){
var statearr_27193_27211 = state_27177__$1;
(statearr_27193_27211[(1)] = (4));

(statearr_27193_27211[(5)] = null);

} else {
throw ex27187;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (10))){
var inst_27148 = (state_27177[(7)]);
var inst_27161 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27148);
var inst_27162 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27161),"."].join('');
var inst_27163 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27164 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27165 = cljs.core.PersistentHashMap.fromArrays(inst_27163,inst_27164);
var inst_27166 = cljs.core.ex_info.call(null,inst_27162,inst_27165);
var inst_27167 = (function(){throw inst_27166})();
var state_27177__$1 = state_27177;
var statearr_27194_27212 = state_27177__$1;
(statearr_27194_27212[(2)] = inst_27167);

(statearr_27194_27212[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27178 === (8))){
var inst_27148 = (state_27177[(7)]);
var inst_27158 = fluree.db.session.ready_QMARK_.call(null,inst_27148);
var inst_27159 = (!(inst_27158));
var state_27177__$1 = state_27177;
if(inst_27159){
var statearr_27195_27213 = state_27177__$1;
(statearr_27195_27213[(1)] = (10));

} else {
var statearr_27196_27214 = state_27177__$1;
(statearr_27196_27214[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0 = (function (){
var statearr_27197 = [null,null,null,null,null,null,null,null];
(statearr_27197[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2746__auto__);

(statearr_27197[(1)] = (1));

return statearr_27197;
});
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1 = (function (state_27177){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27177);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27198){var ex__2749__auto__ = e27198;
var statearr_27199_27215 = state_27177;
(statearr_27199_27215[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27177[(4)]))){
var statearr_27200_27216 = state_27177;
(statearr_27200_27216[(1)] = cljs.core.first.call(null,(state_27177[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27217 = state_27177;
state_27177 = G__27217;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = function(state_27177){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1.call(this,state_27177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27201 = f__2769__auto__.call(null);
(statearr_27201[(6)] = c__2768__auto__);

return statearr_27201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__27218){
var map__27219 = p__27218;
var map__27219__$1 = cljs.core.__destructure_map.call(null,map__27219);
var blank_db = map__27219__$1;
var network = cljs.core.get.call(null,map__27219__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27219__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27294){
var state_val_27295 = (state_27294[(1)]);
if((state_val_27295 === (7))){
var inst_27237 = (state_27294[(7)]);
var inst_27236 = (state_27294[(2)]);
var inst_27237__$1 = fluree.db.util.async.throw_err.call(null,inst_27236);
var state_27294__$1 = (function (){var statearr_27296 = state_27294;
(statearr_27296[(7)] = inst_27237__$1);

return statearr_27296;
})();
if(cljs.core.truth_(inst_27237__$1)){
var statearr_27297_27332 = state_27294__$1;
(statearr_27297_27332[(1)] = (8));

} else {
var statearr_27298_27333 = state_27294__$1;
(statearr_27298_27333[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (20))){
var inst_27242 = (state_27294[(8)]);
var inst_27275 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27242)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27276 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27277 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27278 = cljs.core.PersistentHashMap.fromArrays(inst_27276,inst_27277);
var inst_27279 = cljs.core.ex_info.call(null,inst_27275,inst_27278);
var inst_27280 = (function(){throw inst_27279})();
var state_27294__$1 = state_27294;
var statearr_27299_27334 = state_27294__$1;
(statearr_27299_27334[(2)] = inst_27280);

(statearr_27299_27334[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (1))){
var state_27294__$1 = state_27294;
var statearr_27300_27335 = state_27294__$1;
(statearr_27300_27335[(2)] = null);

(statearr_27300_27335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (4))){
var inst_27220 = (state_27294[(2)]);
var state_27294__$1 = state_27294;
var statearr_27301_27336 = state_27294__$1;
(statearr_27301_27336[(2)] = inst_27220);

(statearr_27301_27336[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (15))){
var inst_27284 = (state_27294[(2)]);
var state_27294__$1 = state_27294;
var statearr_27302_27337 = state_27294__$1;
(statearr_27302_27337[(2)] = inst_27284);

(statearr_27302_27337[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (21))){
var inst_27282 = (state_27294[(2)]);
var state_27294__$1 = state_27294;
var statearr_27303_27338 = state_27294__$1;
(statearr_27303_27338[(2)] = inst_27282);

(statearr_27303_27338[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (13))){
var inst_27241 = (state_27294[(9)]);
var inst_27246 = fluree.db.query.schema.schema_map.call(null,inst_27241);
var inst_27247 = fluree.db.query.schema.setting_map.call(null,inst_27241);
var inst_27248 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_27241);
var inst_27249 = cljs.core.swap_BANG_.call(null,inst_27248,cljs.core.empty);
var state_27294__$1 = (function (){var statearr_27304 = state_27294;
(statearr_27304[(10)] = inst_27249);

(statearr_27304[(11)] = inst_27247);

return statearr_27304;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27294__$1,(16),inst_27246);
} else {
if((state_val_27295 === (22))){
var inst_27242 = (state_27294[(8)]);
var inst_27270 = (state_27294[(2)]);
var inst_27271 = fluree.db.util.async.throw_err.call(null,inst_27270);
var inst_27272 = (inst_27242 + (1));
var inst_27241 = inst_27271;
var inst_27242__$1 = inst_27272;
var state_27294__$1 = (function (){var statearr_27305 = state_27294;
(statearr_27305[(9)] = inst_27241);

(statearr_27305[(8)] = inst_27242__$1);

return statearr_27305;
})();
var statearr_27306_27339 = state_27294__$1;
(statearr_27306_27339[(2)] = null);

(statearr_27306_27339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (6))){
var inst_27229 = (state_27294[(2)]);
var inst_27230 = fluree.db.util.async.throw_err.call(null,inst_27229);
var inst_27231 = cljs.core.__destructure_map.call(null,inst_27230);
var inst_27232 = cljs.core.get.call(null,inst_27231,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27233 = cljs.core.get.call(null,inst_27231,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_27234 = fluree.db.storage.core.reify_db.call(null,conn,network,ledger_id,blank_db,inst_27233);
var state_27294__$1 = (function (){var statearr_27307 = state_27294;
(statearr_27307[(12)] = inst_27232);

return statearr_27307;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27294__$1,(7),inst_27234);
} else {
if((state_val_27295 === (17))){
var inst_27252 = (state_27294[(13)]);
var inst_27241 = (state_27294[(9)]);
var inst_27254 = (state_27294[(2)]);
var inst_27255 = fluree.db.util.async.throw_err.call(null,inst_27254);
var inst_27256 = cljs.core.assoc.call(null,inst_27241,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27252,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27255);
var state_27294__$1 = state_27294;
var statearr_27308_27340 = state_27294__$1;
(statearr_27308_27340[(2)] = inst_27256);

(statearr_27308_27340[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (3))){
var inst_27292 = (state_27294[(2)]);
var state_27294__$1 = state_27294;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27294__$1,inst_27292);
} else {
if((state_val_27295 === (12))){
var inst_27286 = (state_27294[(2)]);
var state_27294__$1 = state_27294;
var statearr_27309_27341 = state_27294__$1;
(statearr_27309_27341[(2)] = inst_27286);

(statearr_27309_27341[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (2))){
var _ = (function (){var statearr_27310 = state_27294;
(statearr_27310[(4)] = cljs.core.cons.call(null,(5),(state_27294[(4)])));

return statearr_27310;
})();
var inst_27227 = fluree.db.session.load_ledger_info.call(null,conn,network,ledger_id);
var state_27294__$1 = state_27294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27294__$1,(6),inst_27227);
} else {
if((state_val_27295 === (19))){
var inst_27241 = (state_27294[(9)]);
var inst_27261 = (state_27294[(14)]);
var inst_27264 = cljs.core.__destructure_map.call(null,inst_27261);
var inst_27265 = cljs.core.get.call(null,inst_27264,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27266 = cljs.core.get.call(null,inst_27264,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27267 = cljs.core.get.call(null,inst_27264,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27268 = fluree.db.dbproto._with.call(null,inst_27241,inst_27266,inst_27265);
var state_27294__$1 = (function (){var statearr_27311 = state_27294;
(statearr_27311[(15)] = inst_27267);

return statearr_27311;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27294__$1,(22),inst_27268);
} else {
if((state_val_27295 === (11))){
var inst_27232 = (state_27294[(12)]);
var inst_27242 = (state_27294[(8)]);
var inst_27244 = (inst_27242 > inst_27232);
var state_27294__$1 = state_27294;
if(cljs.core.truth_(inst_27244)){
var statearr_27313_27342 = state_27294__$1;
(statearr_27313_27342[(1)] = (13));

} else {
var statearr_27314_27343 = state_27294__$1;
(statearr_27314_27343[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (9))){
var state_27294__$1 = state_27294;
var statearr_27315_27344 = state_27294__$1;
(statearr_27315_27344[(2)] = null);

(statearr_27315_27344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (5))){
var _ = (function (){var statearr_27316 = state_27294;
(statearr_27316[(4)] = cljs.core.rest.call(null,(state_27294[(4)])));

return statearr_27316;
})();
var state_27294__$1 = state_27294;
var ex27312 = (state_27294__$1[(2)]);
var statearr_27317_27345 = state_27294__$1;
(statearr_27317_27345[(5)] = ex27312);


if((ex27312 instanceof Error)){
var statearr_27318_27346 = state_27294__$1;
(statearr_27318_27346[(1)] = (4));

(statearr_27318_27346[(5)] = null);

} else {
throw ex27312;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (14))){
var inst_27242 = (state_27294[(8)]);
var inst_27258 = fluree.db.storage.core.read_block.call(null,conn,network,ledger_id,inst_27242);
var state_27294__$1 = state_27294;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27294__$1,(18),inst_27258);
} else {
if((state_val_27295 === (16))){
var inst_27247 = (state_27294[(11)]);
var inst_27251 = (state_27294[(2)]);
var inst_27252 = fluree.db.util.async.throw_err.call(null,inst_27251);
var state_27294__$1 = (function (){var statearr_27319 = state_27294;
(statearr_27319[(13)] = inst_27252);

return statearr_27319;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27294__$1,(17),inst_27247);
} else {
if((state_val_27295 === (10))){
var inst_27289 = (state_27294[(2)]);
var _ = (function (){var statearr_27320 = state_27294;
(statearr_27320[(4)] = cljs.core.rest.call(null,(state_27294[(4)])));

return statearr_27320;
})();
var state_27294__$1 = state_27294;
var statearr_27321_27347 = state_27294__$1;
(statearr_27321_27347[(2)] = inst_27289);

(statearr_27321_27347[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (18))){
var inst_27261 = (state_27294[(14)]);
var inst_27260 = (state_27294[(2)]);
var inst_27261__$1 = fluree.db.util.async.throw_err.call(null,inst_27260);
var state_27294__$1 = (function (){var statearr_27322 = state_27294;
(statearr_27322[(14)] = inst_27261__$1);

return statearr_27322;
})();
if(cljs.core.truth_(inst_27261__$1)){
var statearr_27323_27348 = state_27294__$1;
(statearr_27323_27348[(1)] = (19));

} else {
var statearr_27324_27349 = state_27294__$1;
(statearr_27324_27349[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27295 === (8))){
var inst_27237 = (state_27294[(7)]);
var inst_27239 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27237);
var inst_27240 = (inst_27239 + (1));
var inst_27241 = inst_27237;
var inst_27242 = inst_27240;
var state_27294__$1 = (function (){var statearr_27325 = state_27294;
(statearr_27325[(9)] = inst_27241);

(statearr_27325[(8)] = inst_27242);

return statearr_27325;
})();
var statearr_27326_27350 = state_27294__$1;
(statearr_27326_27350[(2)] = null);

(statearr_27326_27350[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2746__auto____0 = (function (){
var statearr_27327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27327[(0)] = fluree$db$session$load_current_db_$_state_machine__2746__auto__);

(statearr_27327[(1)] = (1));

return statearr_27327;
});
var fluree$db$session$load_current_db_$_state_machine__2746__auto____1 = (function (state_27294){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27294);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27328){var ex__2749__auto__ = e27328;
var statearr_27329_27351 = state_27294;
(statearr_27329_27351[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27294[(4)]))){
var statearr_27330_27352 = state_27294;
(statearr_27330_27352[(1)] = cljs.core.first.call(null,(state_27294[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27353 = state_27294;
state_27294 = G__27353;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2746__auto__ = function(state_27294){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____1.call(this,state_27294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2746__auto____0;
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2746__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27331 = f__2769__auto__.call(null);
(statearr_27331[(6)] = c__2768__auto__);

return statearr_27331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27354,old_db_ch,new_db_ch){
var map__27355 = p__27354;
var map__27355__$1 = cljs.core.__destructure_map.call(null,map__27355);
var state = cljs.core.get.call(null,map__27355__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__27356){
var map__27357 = p__27356;
var map__27357__$1 = cljs.core.__destructure_map.call(null,map__27357);
var s = map__27357__$1;
var current = cljs.core.get.call(null,map__27357__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27358){
var map__27359 = p__27358;
var map__27359__$1 = cljs.core.__destructure_map.call(null,map__27359);
var state = cljs.core.get.call(null,map__27359__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27360){
var map__27361 = p__27360;
var map__27361__$1 = cljs.core.__destructure_map.call(null,map__27361);
var conn = cljs.core.get.call(null,map__27361__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__27361__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__27361__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2768__auto___27398 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27381){
var state_val_27382 = (state_27381[(1)]);
if((state_val_27382 === (1))){
var state_27381__$1 = state_27381;
var statearr_27383_27399 = state_27381__$1;
(statearr_27383_27399[(2)] = null);

(statearr_27383_27399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27382 === (2))){
var _ = (function (){var statearr_27384 = state_27381;
(statearr_27384[(4)] = cljs.core.cons.call(null,(5),(state_27381[(4)])));

return statearr_27384;
})();
var inst_27371 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27381__$1 = state_27381;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27381__$1,(6),inst_27371);
} else {
if((state_val_27382 === (3))){
var inst_27379 = (state_27381[(2)]);
var state_27381__$1 = state_27381;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27381__$1,inst_27379);
} else {
if((state_val_27382 === (4))){
var inst_27362 = (state_27381[(2)]);
var inst_27363 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27364 = fluree.db.util.log.error.call(null,inst_27362,"Error reloading db");
var inst_27365 = cljs.core.async.put_BANG_.call(null,db_ch,inst_27362);
var state_27381__$1 = (function (){var statearr_27386 = state_27381;
(statearr_27386[(7)] = inst_27363);

(statearr_27386[(8)] = inst_27364);

return statearr_27386;
})();
var statearr_27387_27400 = state_27381__$1;
(statearr_27387_27400[(2)] = inst_27365);

(statearr_27387_27400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27382 === (5))){
var _ = (function (){var statearr_27388 = state_27381;
(statearr_27388[(4)] = cljs.core.rest.call(null,(state_27381[(4)])));

return statearr_27388;
})();
var state_27381__$1 = state_27381;
var ex27385 = (state_27381__$1[(2)]);
var statearr_27389_27401 = state_27381__$1;
(statearr_27389_27401[(5)] = ex27385);


var statearr_27390_27402 = state_27381__$1;
(statearr_27390_27402[(1)] = (4));

(statearr_27390_27402[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27382 === (6))){
var inst_27373 = (state_27381[(2)]);
var inst_27374 = fluree.db.util.async.throw_err.call(null,inst_27373);
var state_27381__$1 = state_27381;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27381__$1,(7),db_ch,inst_27374);
} else {
if((state_val_27382 === (7))){
var inst_27376 = (state_27381[(2)]);
var _ = (function (){var statearr_27391 = state_27381;
(statearr_27391[(4)] = cljs.core.rest.call(null,(state_27381[(4)])));

return statearr_27391;
})();
var state_27381__$1 = state_27381;
var statearr_27392_27403 = state_27381__$1;
(statearr_27392_27403[(2)] = inst_27376);

(statearr_27392_27403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0 = (function (){
var statearr_27393 = [null,null,null,null,null,null,null,null,null];
(statearr_27393[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__);

(statearr_27393[(1)] = (1));

return statearr_27393;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1 = (function (state_27381){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27381);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27394){var ex__2749__auto__ = e27394;
var statearr_27395_27404 = state_27381;
(statearr_27395_27404[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27381[(4)]))){
var statearr_27396_27405 = state_27381;
(statearr_27396_27405[(1)] = cljs.core.first.call(null,(state_27381[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27406 = state_27381;
state_27381 = G__27406;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = function(state_27381){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1.call(this,state_27381);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27397 = f__2769__auto__.call(null);
(statearr_27397[(6)] = c__2768__auto___27398);

return statearr_27397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27408 = arguments.length;
switch (G__27408) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27409){
var map__27410 = p__27409;
var map__27410__$1 = cljs.core.__destructure_map.call(null,map__27410);
var session = map__27410__$1;
var blank_db = cljs.core.get.call(null,map__27410__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27411,blank_db){
var map__27412 = p__27411;
var map__27412__$1 = cljs.core.__destructure_map.call(null,map__27412);
var session = map__27412__$1;
var conn = cljs.core.get.call(null,map__27412__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__27412__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2768__auto___27450 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27432){
var state_val_27433 = (state_27432[(1)]);
if((state_val_27433 === (1))){
var state_27432__$1 = state_27432;
var statearr_27434_27451 = state_27432__$1;
(statearr_27434_27451[(2)] = null);

(statearr_27434_27451[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (2))){
var _ = (function (){var statearr_27435 = state_27432;
(statearr_27435[(4)] = cljs.core.cons.call(null,(5),(state_27432[(4)])));

return statearr_27435;
})();
var inst_27422 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27432__$1 = state_27432;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27432__$1,(6),inst_27422);
} else {
if((state_val_27433 === (3))){
var inst_27430 = (state_27432[(2)]);
var state_27432__$1 = state_27432;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27432__$1,inst_27430);
} else {
if((state_val_27433 === (4))){
var inst_27413 = (state_27432[(2)]);
var inst_27414 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27415 = fluree.db.util.log.error.call(null,inst_27413,"Error loading current db");
var inst_27416 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_27413);
var state_27432__$1 = (function (){var statearr_27437 = state_27432;
(statearr_27437[(7)] = inst_27415);

(statearr_27437[(8)] = inst_27414);

return statearr_27437;
})();
var statearr_27438_27452 = state_27432__$1;
(statearr_27438_27452[(2)] = inst_27416);

(statearr_27438_27452[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (5))){
var _ = (function (){var statearr_27439 = state_27432;
(statearr_27439[(4)] = cljs.core.rest.call(null,(state_27432[(4)])));

return statearr_27439;
})();
var state_27432__$1 = state_27432;
var ex27436 = (state_27432__$1[(2)]);
var statearr_27440_27453 = state_27432__$1;
(statearr_27440_27453[(5)] = ex27436);


var statearr_27441_27454 = state_27432__$1;
(statearr_27441_27454[(1)] = (4));

(statearr_27441_27454[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27433 === (6))){
var inst_27424 = (state_27432[(2)]);
var inst_27425 = fluree.db.util.async.throw_err.call(null,inst_27424);
var state_27432__$1 = state_27432;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27432__$1,(7),cur_ch,inst_27425);
} else {
if((state_val_27433 === (7))){
var inst_27427 = (state_27432[(2)]);
var _ = (function (){var statearr_27442 = state_27432;
(statearr_27442[(4)] = cljs.core.rest.call(null,(state_27432[(4)])));

return statearr_27442;
})();
var state_27432__$1 = state_27432;
var statearr_27443_27455 = state_27432__$1;
(statearr_27443_27455[(2)] = inst_27427);

(statearr_27443_27455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27444 = [null,null,null,null,null,null,null,null,null];
(statearr_27444[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27444[(1)] = (1));

return statearr_27444;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27432){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27432);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27445){var ex__2749__auto__ = e27445;
var statearr_27446_27456 = state_27432;
(statearr_27446_27456[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27432[(4)]))){
var statearr_27447_27457 = state_27432;
(statearr_27447_27457[(1)] = cljs.core.first.call(null,(state_27432[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27458 = state_27432;
state_27432 = G__27458;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27432){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27432);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27448 = f__2769__auto__.call(null);
(statearr_27448[(6)] = c__2768__auto___27450);

return statearr_27448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger named testledger on network testnet.
 *   - [testnet testledger] - already in form of [network ledger-id]
 * 
 *   The two-arity version of this exists for backwards compatibility. It doesn't do anything with the
 *   conn arg so there is also a single-arity version that just takes the ledger name.
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(var_args){
var G__27460 = arguments.length;
switch (G__27460) {
case 1:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$1 = (function (ledger){
return fluree.db.session.resolve_ledger.call(null,null,ledger);
}));

(fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2 = (function (_conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var ledger_id = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return ledger_id;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
}
}));

(fluree.db.session.resolve_ledger.cljs$lang$maxFixedArity = 2);

if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27463){
var state_val_27464 = (state_27463[(1)]);
if((state_val_27464 === (1))){
var state_27463__$1 = state_27463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27463__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27465 = [null,null,null,null,null,null,null];
(statearr_27465[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27465[(1)] = (1));

return statearr_27465;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27463){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27466){var ex__2749__auto__ = e27466;
var statearr_27467_27470 = state_27463;
(statearr_27467_27470[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27463[(4)]))){
var statearr_27468_27471 = state_27463;
(statearr_27468_27471[(1)] = cljs.core.first.call(null,(state_27463[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27472 = state_27463;
state_27463 = G__27472;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27463){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27469 = f__2769__auto__.call(null);
(statearr_27469[(6)] = c__2768__auto__);

return statearr_27469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27473){
var map__27474 = p__27473;
var map__27474__$1 = cljs.core.__destructure_map.call(null,map__27474);
var data = map__27474__$1;
var block = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27474__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27533){
var state_val_27534 = (state_27533[(1)]);
if((state_val_27534 === (7))){
var inst_27485 = (state_27533[(7)]);
var inst_27488 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27489 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27490 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27488),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27489),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27485),". No-op."].join('');
var inst_27491 = fluree.db.util.log.info.call(null,inst_27490);
var state_27533__$1 = state_27533;
var statearr_27535_27569 = state_27533__$1;
(statearr_27535_27569[(2)] = inst_27491);

(statearr_27535_27569[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (1))){
var state_27533__$1 = state_27533;
var statearr_27536_27570 = state_27533__$1;
(statearr_27536_27570[(2)] = null);

(statearr_27536_27570[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (4))){
var inst_27475 = (state_27533[(2)]);
var state_27533__$1 = state_27533;
var statearr_27537_27571 = state_27533__$1;
(statearr_27537_27571[(2)] = inst_27475);

(statearr_27537_27571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (15))){
var inst_27514 = (state_27533[(2)]);
var state_27533__$1 = state_27533;
var statearr_27538_27572 = state_27533__$1;
(statearr_27538_27572[(2)] = inst_27514);

(statearr_27538_27572[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (13))){
var inst_27505 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27507 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27508 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27509 = [inst_27507,inst_27508];
var inst_27510 = (new cljs.core.PersistentVector(null,2,(5),inst_27506,inst_27509,null));
var inst_27511 = fluree.db.conn_events.process_event.call(null,inst_27505,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27510,data);
var state_27533__$1 = state_27533;
var statearr_27539_27573 = state_27533__$1;
(statearr_27539_27573[(2)] = inst_27511);

(statearr_27539_27573[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (6))){
var inst_27485 = (state_27533[(7)]);
var inst_27484 = (state_27533[(8)]);
var inst_27483 = (state_27533[(2)]);
var inst_27484__$1 = fluree.db.util.async.throw_err.call(null,inst_27483);
var inst_27485__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27484__$1);
var inst_27486 = (block <= inst_27485__$1);
var state_27533__$1 = (function (){var statearr_27540 = state_27533;
(statearr_27540[(7)] = inst_27485__$1);

(statearr_27540[(8)] = inst_27484__$1);

return statearr_27540;
})();
if(cljs.core.truth_(inst_27486)){
var statearr_27541_27574 = state_27533__$1;
(statearr_27541_27574[(1)] = (7));

} else {
var statearr_27542_27575 = state_27533__$1;
(statearr_27542_27575[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (17))){
var state_27533__$1 = state_27533;
var statearr_27543_27576 = state_27533__$1;
(statearr_27543_27576[(2)] = null);

(statearr_27543_27576[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (3))){
var inst_27531 = (state_27533[(2)]);
var state_27533__$1 = state_27533;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27533__$1,inst_27531);
} else {
if((state_val_27534 === (12))){
var inst_27526 = (state_27533[(2)]);
var state_27533__$1 = state_27533;
var statearr_27544_27577 = state_27533__$1;
(statearr_27544_27577[(2)] = inst_27526);

(statearr_27544_27577[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (2))){
var inst_27481 = (state_27533[(9)]);
var _ = (function (){var statearr_27545 = state_27533;
(statearr_27545[(4)] = cljs.core.cons.call(null,(5),(state_27533[(4)])));

return statearr_27545;
})();
var inst_27481__$1 = fluree.db.session.current_db.call(null,session);
var state_27533__$1 = (function (){var statearr_27546 = state_27533;
(statearr_27546[(9)] = inst_27481__$1);

return statearr_27546;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27533__$1,(6),inst_27481__$1);
} else {
if((state_val_27534 === (11))){
var state_27533__$1 = state_27533;
var statearr_27548_27578 = state_27533__$1;
(statearr_27548_27578[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (9))){
var inst_27528 = (state_27533[(2)]);
var _ = (function (){var statearr_27550 = state_27533;
(statearr_27550[(4)] = cljs.core.rest.call(null,(state_27533[(4)])));

return statearr_27550;
})();
var state_27533__$1 = state_27533;
var statearr_27551_27579 = state_27533__$1;
(statearr_27551_27579[(2)] = inst_27528);

(statearr_27551_27579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (5))){
var _ = (function (){var statearr_27552 = state_27533;
(statearr_27552[(4)] = cljs.core.rest.call(null,(state_27533[(4)])));

return statearr_27552;
})();
var state_27533__$1 = state_27533;
var ex27547 = (state_27533__$1[(2)]);
var statearr_27553_27580 = state_27533__$1;
(statearr_27553_27580[(5)] = ex27547);


if((ex27547 instanceof Error)){
var statearr_27554_27581 = state_27533__$1;
(statearr_27554_27581[(1)] = (4));

(statearr_27554_27581[(5)] = null);

} else {
throw ex27547;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (14))){
var state_27533__$1 = state_27533;
var statearr_27555_27582 = state_27533__$1;
(statearr_27555_27582[(2)] = null);

(statearr_27555_27582[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (16))){
var inst_27485 = (state_27533[(7)]);
var inst_27517 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27518 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27519 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27517),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27518),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27485),". Forcing a db reload."].join('');
var inst_27520 = fluree.db.util.log.info.call(null,inst_27519);
var inst_27521 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27533__$1 = (function (){var statearr_27556 = state_27533;
(statearr_27556[(10)] = inst_27520);

return statearr_27556;
})();
var statearr_27557_27583 = state_27533__$1;
(statearr_27557_27583[(2)] = inst_27521);

(statearr_27557_27583[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (10))){
var inst_27485 = (state_27533[(7)]);
var inst_27481 = (state_27533[(9)]);
var inst_27484 = (state_27533[(8)]);
var inst_27496 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27497 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27498 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27496),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27497),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27499 = fluree.db.util.log.trace.call(null,inst_27498);
var inst_27500 = (function (){var current_db_ch = inst_27481;
var current_db = inst_27484;
var current_block = inst_27485;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_27501 = cljs.core.map.call(null,inst_27500,flakes);
var inst_27502 = fluree.db.dbproto._with.call(null,inst_27484,block,inst_27501);
var inst_27503 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27481,inst_27502);
var state_27533__$1 = (function (){var statearr_27558 = state_27533;
(statearr_27558[(11)] = inst_27499);

return statearr_27558;
})();
if(inst_27503){
var statearr_27559_27584 = state_27533__$1;
(statearr_27559_27584[(1)] = (13));

} else {
var statearr_27560_27585 = state_27533__$1;
(statearr_27560_27585[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (18))){
var inst_27524 = (state_27533[(2)]);
var state_27533__$1 = state_27533;
var statearr_27561_27586 = state_27533__$1;
(statearr_27561_27586[(2)] = inst_27524);

(statearr_27561_27586[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27534 === (8))){
var inst_27485 = (state_27533[(7)]);
var inst_27493 = ((1) + inst_27485);
var inst_27494 = cljs.core._EQ_.call(null,block,inst_27493);
var state_27533__$1 = state_27533;
if(inst_27494){
var statearr_27562_27587 = state_27533__$1;
(statearr_27562_27587[(1)] = (10));

} else {
var statearr_27563_27588 = state_27533__$1;
(statearr_27563_27588[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27564 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27564[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27564[(1)] = (1));

return statearr_27564;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27533){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27533);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27565){var ex__2749__auto__ = e27565;
var statearr_27566_27589 = state_27533;
(statearr_27566_27589[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27533[(4)]))){
var statearr_27567_27590 = state_27533;
(statearr_27567_27590[(1)] = cljs.core.first.call(null,(state_27533[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27591 = state_27533;
state_27533 = G__27591;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27533){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27568 = f__2769__auto__.call(null);
(statearr_27568[(6)] = c__2768__auto__);

return statearr_27568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27598){
var state_val_27599 = (state_27598[(1)]);
if((state_val_27599 === (1))){
var inst_27592 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27593 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27594 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27595 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27593),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27594)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27596 = fluree.db.util.log.debug.call(null,inst_27595);
var state_27598__$1 = (function (){var statearr_27600 = state_27598;
(statearr_27600[(7)] = inst_27596);

(statearr_27600[(8)] = inst_27592);

return statearr_27600;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27598__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27601 = [null,null,null,null,null,null,null,null,null];
(statearr_27601[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27601[(1)] = (1));

return statearr_27601;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27598){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27598);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27602){var ex__2749__auto__ = e27602;
var statearr_27603_27606 = state_27598;
(statearr_27603_27606[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27598[(4)]))){
var statearr_27604_27607 = state_27598;
(statearr_27604_27607[(1)] = cljs.core.first.call(null,(state_27598[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27608 = state_27598;
state_27598 = G__27608;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27598){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27605 = f__2769__auto__.call(null);
(statearr_27605[(6)] = c__2768__auto__);

return statearr_27605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27610 = arguments.length;
switch (G__27610) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27611){
var map__27612 = p__27611;
var map__27612__$1 = cljs.core.__destructure_map.call(null,map__27612);
var session = map__27612__$1;
var conn = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.call(null,map__27612__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27665){
var state_val_27666 = (state_27665[(1)]);
if((state_val_27666 === (7))){
var inst_27661 = (state_27665[(2)]);
var state_27665__$1 = state_27665;
var statearr_27667_27698 = state_27665__$1;
(statearr_27667_27698[(2)] = inst_27661);

(statearr_27667_27698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (1))){
var state_27665__$1 = state_27665;
var statearr_27668_27699 = state_27665__$1;
(statearr_27668_27699[(2)] = null);

(statearr_27668_27699[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (4))){
var inst_27617 = (state_27665[(7)]);
var inst_27616 = (state_27665[(2)]);
var inst_27617__$1 = fluree.db.util.async.throw_err.call(null,inst_27616);
var inst_27618 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27619 = (inst_27617__$1 == null);
var state_27665__$1 = (function (){var statearr_27669 = state_27665;
(statearr_27669[(7)] = inst_27617__$1);

(statearr_27669[(8)] = inst_27618);

return statearr_27669;
})();
if(cljs.core.truth_(inst_27619)){
var statearr_27670_27700 = state_27665__$1;
(statearr_27670_27700[(1)] = (5));

} else {
var statearr_27671_27701 = state_27665__$1;
(statearr_27671_27701[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (15))){
var inst_27653 = (state_27665[(2)]);
var state_27665__$1 = (function (){var statearr_27672 = state_27665;
(statearr_27672[(9)] = inst_27653);

return statearr_27672;
})();
var statearr_27673_27702 = state_27665__$1;
(statearr_27673_27702[(2)] = null);

(statearr_27673_27702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (13))){
var inst_27657 = (state_27665[(2)]);
var state_27665__$1 = state_27665;
var statearr_27675_27703 = state_27665__$1;
(statearr_27675_27703[(2)] = inst_27657);

(statearr_27675_27703[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (6))){
var inst_27618 = (state_27665[(8)]);
var inst_27624 = (inst_27618 == null);
var state_27665__$1 = state_27665;
if(cljs.core.truth_(inst_27624)){
var statearr_27676_27704 = state_27665__$1;
(statearr_27676_27704[(1)] = (8));

} else {
var statearr_27677_27705 = state_27665__$1;
(statearr_27677_27705[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (17))){
var _ = (function (){var statearr_27678 = state_27665;
(statearr_27678[(4)] = cljs.core.rest.call(null,(state_27665[(4)])));

return statearr_27678;
})();
var state_27665__$1 = state_27665;
var ex27674 = (state_27665__$1[(2)]);
var statearr_27679_27706 = state_27665__$1;
(statearr_27679_27706[(5)] = ex27674);


var statearr_27680_27707 = state_27665__$1;
(statearr_27680_27707[(1)] = (16));

(statearr_27680_27707[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (3))){
var inst_27663 = (state_27665[(2)]);
var state_27665__$1 = state_27665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27665__$1,inst_27663);
} else {
if((state_val_27666 === (12))){
var state_27665__$1 = state_27665;
var statearr_27681_27708 = state_27665__$1;
(statearr_27681_27708[(2)] = null);

(statearr_27681_27708[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (2))){
var state_27665__$1 = state_27665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27665__$1,(4),update_chan);
} else {
if((state_val_27666 === (11))){
var state_27665__$1 = state_27665;
var statearr_27682_27709 = state_27665__$1;
(statearr_27682_27709[(2)] = null);

(statearr_27682_27709[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (9))){
var state_27665__$1 = state_27665;
var statearr_27683_27710 = state_27665__$1;
(statearr_27683_27710[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (5))){
var inst_27621 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27622 = fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27621);
var state_27665__$1 = state_27665;
var statearr_27685_27711 = state_27665__$1;
(statearr_27685_27711[(2)] = inst_27622);

(statearr_27685_27711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (14))){
var inst_27617 = (state_27665[(7)]);
var inst_27618 = (state_27665[(8)]);
var _ = (function (){var statearr_27686 = state_27665;
(statearr_27686[(4)] = cljs.core.cons.call(null,(17),(state_27665[(4)])));

return statearr_27686;
})();
var inst_27641 = cljs.core.nth.call(null,inst_27617,(0),null);
var inst_27642 = cljs.core.nth.call(null,inst_27617,(1),null);
var inst_27643 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27644 = cljs.core.pr_str.call(null,inst_27617);
var inst_27645 = fluree.db.util.core.trunc.call(null,inst_27644,(200));
var inst_27646 = fluree.db.util.log.trace.call(null,inst_27643,inst_27645);
var inst_27647 = fluree.db.session.process_ledger_update.call(null,inst_27618,inst_27641,inst_27642);
var state_27665__$1 = (function (){var statearr_27687 = state_27665;
(statearr_27687[(10)] = inst_27646);

return statearr_27687;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27665__$1,(18),inst_27647);
} else {
if((state_val_27666 === (16))){
var inst_27617 = (state_27665[(7)]);
var inst_27631 = (state_27665[(2)]);
var inst_27632 = fluree.db.util.log.error.call(null,inst_27631,"Exception processing ledger updates for message: ",inst_27617);
var state_27665__$1 = state_27665;
var statearr_27688_27712 = state_27665__$1;
(statearr_27688_27712[(2)] = inst_27632);

(statearr_27688_27712[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (10))){
var inst_27659 = (state_27665[(2)]);
var state_27665__$1 = state_27665;
var statearr_27689_27713 = state_27665__$1;
(statearr_27689_27713[(2)] = inst_27659);

(statearr_27689_27713[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (18))){
var inst_27649 = (state_27665[(2)]);
var inst_27650 = fluree.db.util.async.throw_err.call(null,inst_27649);
var _ = (function (){var statearr_27690 = state_27665;
(statearr_27690[(4)] = cljs.core.rest.call(null,(state_27665[(4)])));

return statearr_27690;
})();
var state_27665__$1 = state_27665;
var statearr_27691_27714 = state_27665__$1;
(statearr_27691_27714[(2)] = inst_27650);

(statearr_27691_27714[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27666 === (8))){
var inst_27617 = (state_27665[(7)]);
var inst_27626 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27627 = cljs.core.first.call(null,inst_27617);
var inst_27628 = fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27626,"Message: ",inst_27627);
var state_27665__$1 = state_27665;
var statearr_27692_27715 = state_27665__$1;
(statearr_27692_27715[(2)] = inst_27628);

(statearr_27692_27715[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0 = (function (){
var statearr_27693 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27693[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__);

(statearr_27693[(1)] = (1));

return statearr_27693;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1 = (function (state_27665){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27694){var ex__2749__auto__ = e27694;
var statearr_27695_27716 = state_27665;
(statearr_27695_27716[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27665[(4)]))){
var statearr_27696_27717 = state_27665;
(statearr_27696_27717[(1)] = cljs.core.first.call(null,(state_27665[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27718 = state_27665;
state_27665 = G__27718;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = function(state_27665){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1.call(this,state_27665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27697 = f__2769__auto__.call(null);
(statearr_27697[(6)] = c__2768__auto__);

return statearr_27697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27719){
var map__27720 = p__27719;
var map__27720__$1 = cljs.core.__destructure_map.call(null,map__27720);
var network = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27720__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27724 = block_result;
var map__27724__$1 = cljs.core.__destructure_map.call(null,map__27724);
var block = cljs.core.get.call(null,map__27724__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27724__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27724__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27724__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27724__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27725 = tx_result;
var map__27725__$1 = cljs.core.__destructure_map.call(null,map__27725);
var t = cljs.core.get.call(null,map__27725__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27725__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27721_SHARP_){
return cljs.core._EQ_.call(null,t,fluree.db.flake.t.call(null,p1__27721_SHARP_));
}):(function (p1__27722_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27722_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27723_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27723_SHARP_))){
return cljs.core.nth.call(null,p1__27723_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27726 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27726,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27726,(1),null);
var error = cljs.core.nth.call(null,vec__27726,(2),null);
var message = cljs.core.nth.call(null,vec__27726,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27730 = arguments.length;
switch (G__27730) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27731){
var map__27732 = p__27731;
var map__27732__$1 = cljs.core.__destructure_map.call(null,map__27732);
var state = cljs.core.get.call(null,map__27732__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27732__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27732__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27732__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27733 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27733,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27733,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27733,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27736 = cljs.core.seq.call(null,tids);
var chunk__27737 = null;
var count__27738 = (0);
var i__27739 = (0);
while(true){
if((i__27739 < count__27738)){
var tid = cljs.core._nth.call(null,chunk__27737,i__27739);
var temp__5804__auto___27852__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27852__$1)){
var keyed_callbacks_27853 = temp__5804__auto___27852__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27854 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27780_27855 = cljs.core.seq.call(null,keyed_callbacks_27853);
var chunk__27781_27856 = null;
var count__27782_27857 = (0);
var i__27783_27858 = (0);
while(true){
if((i__27783_27858 < count__27782_27857)){
var vec__27792_27859 = cljs.core._nth.call(null,chunk__27781_27856,i__27783_27858);
var k_27860 = cljs.core.nth.call(null,vec__27792_27859,(0),null);
var f_27861 = cljs.core.nth.call(null,vec__27792_27859,(1),null);
try{f_27861.call(null,tx_response_27854);
}catch (e27795){var e_27862 = e27795;
fluree.db.util.log.error.call(null,e_27862,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27863 = seq__27780_27855;
var G__27864 = chunk__27781_27856;
var G__27865 = count__27782_27857;
var G__27866 = (i__27783_27858 + (1));
seq__27780_27855 = G__27863;
chunk__27781_27856 = G__27864;
count__27782_27857 = G__27865;
i__27783_27858 = G__27866;
continue;
} else {
var temp__5804__auto___27867__$2 = cljs.core.seq.call(null,seq__27780_27855);
if(temp__5804__auto___27867__$2){
var seq__27780_27868__$1 = temp__5804__auto___27867__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27780_27868__$1)){
var c__5568__auto___27869 = cljs.core.chunk_first.call(null,seq__27780_27868__$1);
var G__27870 = cljs.core.chunk_rest.call(null,seq__27780_27868__$1);
var G__27871 = c__5568__auto___27869;
var G__27872 = cljs.core.count.call(null,c__5568__auto___27869);
var G__27873 = (0);
seq__27780_27855 = G__27870;
chunk__27781_27856 = G__27871;
count__27782_27857 = G__27872;
i__27783_27858 = G__27873;
continue;
} else {
var vec__27796_27874 = cljs.core.first.call(null,seq__27780_27868__$1);
var k_27875 = cljs.core.nth.call(null,vec__27796_27874,(0),null);
var f_27876 = cljs.core.nth.call(null,vec__27796_27874,(1),null);
try{f_27876.call(null,tx_response_27854);
}catch (e27799){var e_27877 = e27799;
fluree.db.util.log.error.call(null,e_27877,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27878 = cljs.core.next.call(null,seq__27780_27868__$1);
var G__27879 = null;
var G__27880 = (0);
var G__27881 = (0);
seq__27780_27855 = G__27878;
chunk__27781_27856 = G__27879;
count__27782_27857 = G__27880;
i__27783_27858 = G__27881;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27882 = seq__27736;
var G__27883 = chunk__27737;
var G__27884 = count__27738;
var G__27885 = (i__27739 + (1));
seq__27736 = G__27882;
chunk__27737 = G__27883;
count__27738 = G__27884;
i__27739 = G__27885;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__27736);
if(temp__5804__auto____$1){
var seq__27736__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27736__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27736__$1);
var G__27886 = cljs.core.chunk_rest.call(null,seq__27736__$1);
var G__27887 = c__5568__auto__;
var G__27888 = cljs.core.count.call(null,c__5568__auto__);
var G__27889 = (0);
seq__27736 = G__27886;
chunk__27737 = G__27887;
count__27738 = G__27888;
i__27739 = G__27889;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27736__$1);
var temp__5804__auto___27890__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27890__$2)){
var keyed_callbacks_27891 = temp__5804__auto___27890__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27892 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27800_27893 = cljs.core.seq.call(null,keyed_callbacks_27891);
var chunk__27801_27894 = null;
var count__27802_27895 = (0);
var i__27803_27896 = (0);
while(true){
if((i__27803_27896 < count__27802_27895)){
var vec__27812_27897 = cljs.core._nth.call(null,chunk__27801_27894,i__27803_27896);
var k_27898 = cljs.core.nth.call(null,vec__27812_27897,(0),null);
var f_27899 = cljs.core.nth.call(null,vec__27812_27897,(1),null);
try{f_27899.call(null,tx_response_27892);
}catch (e27815){var e_27900 = e27815;
fluree.db.util.log.error.call(null,e_27900,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27901 = seq__27800_27893;
var G__27902 = chunk__27801_27894;
var G__27903 = count__27802_27895;
var G__27904 = (i__27803_27896 + (1));
seq__27800_27893 = G__27901;
chunk__27801_27894 = G__27902;
count__27802_27895 = G__27903;
i__27803_27896 = G__27904;
continue;
} else {
var temp__5804__auto___27905__$3 = cljs.core.seq.call(null,seq__27800_27893);
if(temp__5804__auto___27905__$3){
var seq__27800_27906__$1 = temp__5804__auto___27905__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27800_27906__$1)){
var c__5568__auto___27907 = cljs.core.chunk_first.call(null,seq__27800_27906__$1);
var G__27908 = cljs.core.chunk_rest.call(null,seq__27800_27906__$1);
var G__27909 = c__5568__auto___27907;
var G__27910 = cljs.core.count.call(null,c__5568__auto___27907);
var G__27911 = (0);
seq__27800_27893 = G__27908;
chunk__27801_27894 = G__27909;
count__27802_27895 = G__27910;
i__27803_27896 = G__27911;
continue;
} else {
var vec__27816_27912 = cljs.core.first.call(null,seq__27800_27906__$1);
var k_27913 = cljs.core.nth.call(null,vec__27816_27912,(0),null);
var f_27914 = cljs.core.nth.call(null,vec__27816_27912,(1),null);
try{f_27914.call(null,tx_response_27892);
}catch (e27819){var e_27915 = e27819;
fluree.db.util.log.error.call(null,e_27915,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27916 = cljs.core.next.call(null,seq__27800_27906__$1);
var G__27917 = null;
var G__27918 = (0);
var G__27919 = (0);
seq__27800_27893 = G__27916;
chunk__27801_27894 = G__27917;
count__27802_27895 = G__27918;
i__27803_27896 = G__27919;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27920 = cljs.core.next.call(null,seq__27736__$1);
var G__27921 = null;
var G__27922 = (0);
var G__27923 = (0);
seq__27736 = G__27920;
chunk__27737 = G__27921;
count__27738 = G__27922;
i__27739 = G__27923;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27924 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2768__auto___27925 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27836){
var state_val_27837 = (state_27836[(1)]);
if((state_val_27837 === (1))){
var state_27836__$1 = state_27836;
var statearr_27838_27926 = state_27836__$1;
(statearr_27838_27926[(2)] = null);

(statearr_27838_27926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27837 === (2))){
var inst_27821 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27836__$1 = state_27836;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27836__$1,(4),inst_27821);
} else {
if((state_val_27837 === (3))){
var inst_27834 = (state_27836[(2)]);
var state_27836__$1 = state_27836;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27836__$1,inst_27834);
} else {
if((state_val_27837 === (4))){
var inst_27823 = (state_27836[(7)]);
var inst_27823__$1 = (state_27836[(2)]);
var inst_27824 = (inst_27823__$1 == null);
var state_27836__$1 = (function (){var statearr_27839 = state_27836;
(statearr_27839[(7)] = inst_27823__$1);

return statearr_27839;
})();
if(cljs.core.truth_(inst_27824)){
var statearr_27840_27927 = state_27836__$1;
(statearr_27840_27927[(1)] = (5));

} else {
var statearr_27841_27928 = state_27836__$1;
(statearr_27841_27928[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27837 === (5))){
var inst_27826 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27827 = fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27826);
var state_27836__$1 = state_27836;
var statearr_27842_27929 = state_27836__$1;
(statearr_27842_27929[(2)] = inst_27827);

(statearr_27842_27929[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27837 === (6))){
var inst_27823 = (state_27836[(7)]);
var inst_27829 = transact_handler_27924.call(null,conn,inst_27823);
var state_27836__$1 = (function (){var statearr_27843 = state_27836;
(statearr_27843[(8)] = inst_27829);

return statearr_27843;
})();
var statearr_27844_27930 = state_27836__$1;
(statearr_27844_27930[(2)] = null);

(statearr_27844_27930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27837 === (7))){
var inst_27832 = (state_27836[(2)]);
var state_27836__$1 = state_27836;
var statearr_27845_27931 = state_27836__$1;
(statearr_27845_27931[(2)] = inst_27832);

(statearr_27845_27931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27846 = [null,null,null,null,null,null,null,null,null];
(statearr_27846[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27846[(1)] = (1));

return statearr_27846;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27836){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27836);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27847){var ex__2749__auto__ = e27847;
var statearr_27848_27932 = state_27836;
(statearr_27848_27932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27836[(4)]))){
var statearr_27849_27933 = state_27836;
(statearr_27849_27933[(1)] = cljs.core.first.call(null,(state_27836[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27934 = state_27836;
state_27836 = G__27934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27836){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27850 = f__2769__auto__.call(null);
(statearr_27850[(6)] = c__2768__auto___27925);

return statearr_27850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27937 = arguments.length;
switch (G__27937) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27938 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__27935_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__27935_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27938);
} else {
return G__27938;
}
})();
var seq__27939 = cljs.core.seq.call(null,sessions);
var chunk__27940 = null;
var count__27941 = (0);
var i__27942 = (0);
while(true){
if((i__27942 < count__27941)){
var session = cljs.core._nth.call(null,chunk__27940,i__27942);
fluree.db.session.close.call(null,session);


var G__27944 = seq__27939;
var G__27945 = chunk__27940;
var G__27946 = count__27941;
var G__27947 = (i__27942 + (1));
seq__27939 = G__27944;
chunk__27940 = G__27945;
count__27941 = G__27946;
i__27942 = G__27947;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__27939);
if(temp__5804__auto__){
var seq__27939__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27939__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27939__$1);
var G__27948 = cljs.core.chunk_rest.call(null,seq__27939__$1);
var G__27949 = c__5568__auto__;
var G__27950 = cljs.core.count.call(null,c__5568__auto__);
var G__27951 = (0);
seq__27939 = G__27948;
chunk__27940 = G__27949;
count__27941 = G__27950;
i__27942 = G__27951;
continue;
} else {
var session = cljs.core.first.call(null,seq__27939__$1);
fluree.db.session.close.call(null,session);


var G__27952 = cljs.core.next.call(null,seq__27939__$1);
var G__27953 = null;
var G__27954 = (0);
var G__27955 = (0);
seq__27939 = G__27952;
chunk__27940 = G__27953;
count__27941 = G__27954;
i__27942 = G__27955;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
