// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23822,error_ch,vars,p__23823){
var map__23824 = p__23822;
var map__23824__$1 = cljs.core.__destructure_map.call(null,map__23824);
var db = map__23824__$1;
var conn = cljs.core.get.call(null,map__23824__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__23824__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__23824__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23825 = p__23823;
var map__23825__$1 = cljs.core.__destructure_map.call(null,map__23825);
var _where_clause = map__23825__$1;
var p = cljs.core.get.call(null,map__23825__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__23825__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__23825__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23826 = (function (){var G__23829 = idx;
var G__23829__$1 = (((G__23829 instanceof cljs.core.Keyword))?G__23829.fqn:null);
switch (G__23829__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23829__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__23826,(0),null);
var lflake = cljs.core.nth.call(null,vec__23826,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23820_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__23820_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23821_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__23821_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2768__auto___23899 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23868){
var state_val_23869 = (state_23868[(1)]);
if((state_val_23869 === (7))){
var inst_23864 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23870_23900 = state_23868__$1;
(statearr_23870_23900[(2)] = inst_23864);

(statearr_23870_23900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (1))){
var state_23868__$1 = state_23868;
var statearr_23871_23901 = state_23868__$1;
(statearr_23871_23901[(2)] = null);

(statearr_23871_23901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (4))){
var inst_23832 = (state_23868[(7)]);
var inst_23832__$1 = (state_23868[(2)]);
var inst_23833 = (inst_23832__$1 == null);
var state_23868__$1 = (function (){var statearr_23872 = state_23868;
(statearr_23872[(7)] = inst_23832__$1);

return statearr_23872;
})();
if(cljs.core.truth_(inst_23833)){
var statearr_23873_23902 = state_23868__$1;
(statearr_23873_23902[(1)] = (5));

} else {
var statearr_23874_23903 = state_23868__$1;
(statearr_23874_23903[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (15))){
var state_23868__$1 = state_23868;
var statearr_23875_23904 = state_23868__$1;
(statearr_23875_23904[(2)] = false);

(statearr_23875_23904[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (13))){
var inst_23844 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
if(cljs.core.truth_(inst_23844)){
var statearr_23876_23905 = state_23868__$1;
(statearr_23876_23905[(1)] = (14));

} else {
var statearr_23877_23906 = state_23868__$1;
(statearr_23877_23906[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (6))){
var inst_23832 = (state_23868[(7)]);
var inst_23837 = cljs.core.seq.call(null,inst_23832);
var inst_23838 = inst_23837;
var inst_23839 = (0);
var state_23868__$1 = (function (){var statearr_23878 = state_23868;
(statearr_23878[(8)] = inst_23839);

(statearr_23878[(9)] = inst_23838);

return statearr_23878;
})();
var statearr_23879_23907 = state_23868__$1;
(statearr_23879_23907[(2)] = null);

(statearr_23879_23907[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (17))){
var state_23868__$1 = state_23868;
var statearr_23880_23908 = state_23868__$1;
(statearr_23880_23908[(2)] = null);

(statearr_23880_23908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (3))){
var inst_23866 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23868__$1,inst_23866);
} else {
if((state_val_23869 === (12))){
var inst_23854 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23881_23909 = state_23868__$1;
(statearr_23881_23909[(2)] = inst_23854);

(statearr_23881_23909[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (2))){
var state_23868__$1 = state_23868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23868__$1,(4),tree_chan);
} else {
if((state_val_23869 === (19))){
var inst_23862 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23882_23910 = state_23868__$1;
(statearr_23882_23910[(2)] = inst_23862);

(statearr_23882_23910[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (11))){
var state_23868__$1 = state_23868;
var statearr_23883_23911 = state_23868__$1;
(statearr_23883_23911[(2)] = true);

(statearr_23883_23911[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (9))){
var inst_23856 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
if(cljs.core.truth_(inst_23856)){
var statearr_23884_23912 = state_23868__$1;
(statearr_23884_23912[(1)] = (17));

} else {
var statearr_23885_23913 = state_23868__$1;
(statearr_23885_23913[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (5))){
var inst_23835 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23868__$1 = state_23868;
var statearr_23886_23914 = state_23868__$1;
(statearr_23886_23914[(2)] = inst_23835);

(statearr_23886_23914[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (14))){
var inst_23839 = (state_23868[(8)]);
var inst_23838 = (state_23868[(9)]);
var inst_23846 = cljs.core.next.call(null,inst_23838);
var inst_23847 = (inst_23839 + (1));
var inst_23838__$1 = inst_23846;
var inst_23839__$1 = inst_23847;
var state_23868__$1 = (function (){var statearr_23887 = state_23868;
(statearr_23887[(8)] = inst_23839__$1);

(statearr_23887[(9)] = inst_23838__$1);

return statearr_23887;
})();
var statearr_23888_23915 = state_23868__$1;
(statearr_23888_23915[(2)] = null);

(statearr_23888_23915[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (16))){
var inst_23851 = (state_23868[(2)]);
var state_23868__$1 = state_23868;
var statearr_23889_23916 = state_23868__$1;
(statearr_23889_23916[(2)] = inst_23851);

(statearr_23889_23916[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (10))){
var inst_23838 = (state_23868[(9)]);
var inst_23842 = cljs.core.first.call(null,inst_23838);
var state_23868__$1 = state_23868;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23868__$1,(13),return_chan,inst_23842);
} else {
if((state_val_23869 === (18))){
var inst_23860 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23868__$1 = state_23868;
var statearr_23890_23917 = state_23868__$1;
(statearr_23890_23917[(2)] = inst_23860);

(statearr_23890_23917[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23869 === (8))){
var inst_23838 = (state_23868[(9)]);
var state_23868__$1 = state_23868;
if(cljs.core.truth_(inst_23838)){
var statearr_23891_23918 = state_23868__$1;
(statearr_23891_23918[(1)] = (10));

} else {
var statearr_23892_23919 = state_23868__$1;
(statearr_23892_23919[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23893 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23893[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__);

(statearr_23893[(1)] = (1));

return statearr_23893;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1 = (function (state_23868){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23894){var ex__2749__auto__ = e23894;
var statearr_23895_23920 = state_23868;
(statearr_23895_23920[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23868[(4)]))){
var statearr_23896_23921 = state_23868;
(statearr_23896_23921[(1)] = cljs.core.first.call(null,(state_23868[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23922 = state_23868;
state_23868 = G__23922;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = function(state_23868){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1.call(this,state_23868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23897 = f__2769__auto__.call(null);
(statearr_23897[(6)] = c__2768__auto___23899);

return statearr_23897;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23923){
var map__23924 = p__23923;
var map__23924__$1 = cljs.core.__destructure_map.call(null,map__23924);
var _opts = map__23924__$1;
var db = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__23924__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23969){
var state_val_23970 = (state_23969[(1)]);
if((state_val_23970 === (7))){
var inst_23940 = (state_23969[(7)]);
var inst_23942 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_23940);
var state_23969__$1 = state_23969;
var statearr_23971_24007 = state_23969__$1;
(statearr_23971_24007[(2)] = inst_23942);

(statearr_23971_24007[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (1))){
var state_23969__$1 = state_23969;
var statearr_23972_24008 = state_23969__$1;
(statearr_23972_24008[(2)] = null);

(statearr_23972_24008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (4))){
var inst_23925 = (state_23969[(2)]);
var inst_23926 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23925);
var inst_23927 = cljs.core.async.close_BANG_.call(null,port);
var state_23969__$1 = (function (){var statearr_23973 = state_23969;
(statearr_23973[(8)] = inst_23926);

(statearr_23973[(9)] = inst_23927);

return statearr_23973;
})();
var statearr_23974_24009 = state_23969__$1;
(statearr_23974_24009[(2)] = null);

(statearr_23974_24009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (15))){
var inst_23957 = (state_23969[(10)]);
var inst_23957__$1 = (state_23969[(2)]);
var inst_23958 = cljs.core.seq.call(null,inst_23957__$1);
var state_23969__$1 = (function (){var statearr_23975 = state_23969;
(statearr_23975[(10)] = inst_23957__$1);

return statearr_23975;
})();
if(inst_23958){
var statearr_23976_24010 = state_23969__$1;
(statearr_23976_24010[(1)] = (17));

} else {
var statearr_23977_24011 = state_23969__$1;
(statearr_23977_24011[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (13))){
var inst_23950 = (state_23969[(11)]);
var state_23969__$1 = state_23969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23969__$1,(16),inst_23950);
} else {
if((state_val_23970 === (6))){
var inst_23939 = (state_23969[(2)]);
var inst_23940 = fluree.db.util.async.throw_err.call(null,inst_23939);
var state_23969__$1 = (function (){var statearr_23978 = state_23969;
(statearr_23978[(7)] = inst_23940);

return statearr_23978;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23979_24012 = state_23969__$1;
(statearr_23979_24012[(1)] = (7));

} else {
var statearr_23980_24013 = state_23969__$1;
(statearr_23980_24013[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (17))){
var inst_23957 = (state_23969[(10)]);
var inst_23960 = cljs.core.async.put_BANG_.call(null,port,inst_23957);
var state_23969__$1 = state_23969;
var statearr_23981_24014 = state_23969__$1;
(statearr_23981_24014[(2)] = inst_23960);

(statearr_23981_24014[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (3))){
var inst_23967 = (state_23969[(2)]);
var state_23969__$1 = state_23969;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23969__$1,inst_23967);
} else {
if((state_val_23970 === (12))){
var inst_23950 = (state_23969[(2)]);
var state_23969__$1 = (function (){var statearr_23982 = state_23969;
(statearr_23982[(11)] = inst_23950);

return statearr_23982;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23983_24015 = state_23969__$1;
(statearr_23983_24015[(1)] = (13));

} else {
var statearr_23984_24016 = state_23969__$1;
(statearr_23984_24016[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (2))){
var _ = (function (){var statearr_23985 = state_23969;
(statearr_23985[(4)] = cljs.core.cons.call(null,(5),(state_23969[(4)])));

return statearr_23985;
})();
var inst_23934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23935 = [sid];
var inst_23936 = (new cljs.core.PersistentVector(null,1,(5),inst_23934,inst_23935,null));
var inst_23937 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23936);
var state_23969__$1 = state_23969;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23969__$1,(6),inst_23937);
} else {
if((state_val_23970 === (19))){
var inst_23963 = (state_23969[(2)]);
var inst_23964 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23986 = state_23969;
(statearr_23986[(4)] = cljs.core.rest.call(null,(state_23969[(4)])));

return statearr_23986;
})();
var state_23969__$1 = (function (){var statearr_23987 = state_23969;
(statearr_23987[(12)] = inst_23963);

return statearr_23987;
})();
var statearr_23988_24017 = state_23969__$1;
(statearr_23988_24017[(2)] = inst_23964);

(statearr_23988_24017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (11))){
var inst_23945 = (state_23969[(13)]);
var state_23969__$1 = state_23969;
var statearr_23990_24018 = state_23969__$1;
(statearr_23990_24018[(2)] = inst_23945);

(statearr_23990_24018[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (9))){
var inst_23945 = (state_23969[(2)]);
var state_23969__$1 = (function (){var statearr_23991 = state_23969;
(statearr_23991[(13)] = inst_23945);

return statearr_23991;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23992_24019 = state_23969__$1;
(statearr_23992_24019[(1)] = (10));

} else {
var statearr_23993_24020 = state_23969__$1;
(statearr_23993_24020[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (5))){
var _ = (function (){var statearr_23994 = state_23969;
(statearr_23994[(4)] = cljs.core.rest.call(null,(state_23969[(4)])));

return statearr_23994;
})();
var state_23969__$1 = state_23969;
var ex23989 = (state_23969__$1[(2)]);
var statearr_23995_24021 = state_23969__$1;
(statearr_23995_24021[(5)] = ex23989);


var statearr_23996_24022 = state_23969__$1;
(statearr_23996_24022[(1)] = (4));

(statearr_23996_24022[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (14))){
var inst_23950 = (state_23969[(11)]);
var state_23969__$1 = state_23969;
var statearr_23997_24023 = state_23969__$1;
(statearr_23997_24023[(2)] = inst_23950);

(statearr_23997_24023[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (16))){
var inst_23953 = (state_23969[(2)]);
var inst_23954 = fluree.db.util.async.throw_err.call(null,inst_23953);
var state_23969__$1 = state_23969;
var statearr_23998_24024 = state_23969__$1;
(statearr_23998_24024[(2)] = inst_23954);

(statearr_23998_24024[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (10))){
var inst_23945 = (state_23969[(13)]);
var inst_23947 = permissions.call(null,inst_23945);
var state_23969__$1 = state_23969;
var statearr_23999_24025 = state_23969__$1;
(statearr_23999_24025[(2)] = inst_23947);

(statearr_23999_24025[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (18))){
var state_23969__$1 = state_23969;
var statearr_24000_24026 = state_23969__$1;
(statearr_24000_24026[(2)] = null);

(statearr_24000_24026[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23970 === (8))){
var inst_23940 = (state_23969[(7)]);
var state_23969__$1 = state_23969;
var statearr_24001_24027 = state_23969__$1;
(statearr_24001_24027[(2)] = inst_23940);

(statearr_24001_24027[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0 = (function (){
var statearr_24002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24002[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__);

(statearr_24002[(1)] = (1));

return statearr_24002;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1 = (function (state_23969){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23969);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24003){var ex__2749__auto__ = e24003;
var statearr_24004_24028 = state_23969;
(statearr_24004_24028[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23969[(4)]))){
var statearr_24005_24029 = state_23969;
(statearr_24005_24029[(1)] = cljs.core.first.call(null,(state_23969[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24030 = state_23969;
state_23969 = G__24030;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = function(state_23969){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1.call(this,state_23969);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24006 = f__2769__auto__.call(null);
(statearr_24006[(6)] = c__2768__auto__);

return statearr_24006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__24031){
var map__24032 = p__24031;
var map__24032__$1 = cljs.core.__destructure_map.call(null,map__24032);
var f_where = map__24032__$1;
var o = cljs.core.get.call(null,map__24032__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2768__auto___24069 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24052){
var state_val_24053 = (state_24052[(1)]);
if((state_val_24053 === (7))){
var inst_24040 = (state_24052[(7)]);
var inst_24043 = cljs.core.async.put_BANG_.call(null,error_ch,inst_24040);
var state_24052__$1 = state_24052;
var statearr_24054_24070 = state_24052__$1;
(statearr_24054_24070[(2)] = inst_24043);

(statearr_24054_24070[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24053 === (1))){
var inst_24033 = typeof _id_val === 'number';
var state_24052__$1 = state_24052;
if(cljs.core.truth_(inst_24033)){
var statearr_24055_24071 = state_24052__$1;
(statearr_24055_24071[(1)] = (2));

} else {
var statearr_24056_24072 = state_24052__$1;
(statearr_24056_24072[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24053 === (4))){
var inst_24049 = (state_24052[(2)]);
var inst_24050 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_24052__$1 = (function (){var statearr_24057 = state_24052;
(statearr_24057[(8)] = inst_24049);

return statearr_24057;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24052__$1,inst_24050);
} else {
if((state_val_24053 === (6))){
var inst_24040 = (state_24052[(7)]);
var inst_24040__$1 = (state_24052[(2)]);
var inst_24041 = fluree.db.util.core.exception_QMARK_.call(null,inst_24040__$1);
var state_24052__$1 = (function (){var statearr_24058 = state_24052;
(statearr_24058[(7)] = inst_24040__$1);

return statearr_24058;
})();
if(inst_24041){
var statearr_24059_24073 = state_24052__$1;
(statearr_24059_24073[(1)] = (7));

} else {
var statearr_24060_24074 = state_24052__$1;
(statearr_24060_24074[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24053 === (3))){
var inst_24038 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_24052__$1 = state_24052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24052__$1,(6),inst_24038);
} else {
if((state_val_24053 === (2))){
var state_24052__$1 = state_24052;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_24052__$1,(5),return_ch,_id_val);
} else {
if((state_val_24053 === (9))){
var inst_24047 = (state_24052[(2)]);
var state_24052__$1 = state_24052;
var statearr_24061_24075 = state_24052__$1;
(statearr_24061_24075[(2)] = inst_24047);

(statearr_24061_24075[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24053 === (5))){
var inst_24036 = (state_24052[(2)]);
var state_24052__$1 = state_24052;
var statearr_24062_24076 = state_24052__$1;
(statearr_24062_24076[(2)] = inst_24036);

(statearr_24062_24076[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24053 === (8))){
var inst_24040 = (state_24052[(7)]);
var inst_24045 = cljs.core.async.put_BANG_.call(null,return_ch,inst_24040);
var state_24052__$1 = state_24052;
var statearr_24063_24077 = state_24052__$1;
(statearr_24063_24077[(2)] = inst_24045);

(statearr_24063_24077[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_24064 = [null,null,null,null,null,null,null,null,null];
(statearr_24064[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__);

(statearr_24064[(1)] = (1));

return statearr_24064;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1 = (function (state_24052){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24065){var ex__2749__auto__ = e24065;
var statearr_24066_24078 = state_24052;
(statearr_24066_24078[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24052[(4)]))){
var statearr_24067_24079 = state_24052;
(statearr_24067_24079[(1)] = cljs.core.first.call(null,(state_24052[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24080 = state_24052;
state_24052 = G__24080;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = function(state_24052){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1.call(this,state_24052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24068 = f__2769__auto__.call(null);
(statearr_24068[(6)] = c__2768__auto___24069);

return statearr_24068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
/**
 * If the predicate is a ref? type with an 'o' value, it must be resolved into a subject id.
 */
fluree.db.query.subject_crawl.subject.resolve_o_ident = (function fluree$db$query$subject_crawl$subject$resolve_o_ident(db,p__24081){
var map__24082 = p__24081;
var map__24082__$1 = cljs.core.__destructure_map.call(null,map__24082);
var where_clause = map__24082__$1;
var o = cljs.core.get.call(null,map__24082__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24106){
var state_val_24107 = (state_24106[(1)]);
if((state_val_24107 === (7))){
var inst_24093 = (state_24106[(7)]);
var state_24106__$1 = state_24106;
var statearr_24108_24127 = state_24106__$1;
(statearr_24108_24127[(2)] = inst_24093);

(statearr_24108_24127[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24107 === (1))){
var state_24106__$1 = state_24106;
var statearr_24109_24128 = state_24106__$1;
(statearr_24109_24128[(2)] = null);

(statearr_24109_24128[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24107 === (4))){
var inst_24083 = (state_24106[(2)]);
var state_24106__$1 = state_24106;
var statearr_24110_24129 = state_24106__$1;
(statearr_24110_24129[(2)] = inst_24083);

(statearr_24110_24129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24107 === (6))){
var inst_24093 = (state_24106[(7)]);
var inst_24092 = (state_24106[(2)]);
var inst_24093__$1 = fluree.db.util.async.throw_err.call(null,inst_24092);
var state_24106__$1 = (function (){var statearr_24111 = state_24106;
(statearr_24111[(7)] = inst_24093__$1);

return statearr_24111;
})();
if(cljs.core.truth_(inst_24093__$1)){
var statearr_24112_24130 = state_24106__$1;
(statearr_24112_24130[(1)] = (7));

} else {
var statearr_24113_24131 = state_24106__$1;
(statearr_24113_24131[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24107 === (3))){
var inst_24104 = (state_24106[(2)]);
var state_24106__$1 = state_24106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24106__$1,inst_24104);
} else {
if((state_val_24107 === (2))){
var _ = (function (){var statearr_24115 = state_24106;
(statearr_24115[(4)] = cljs.core.cons.call(null,(5),(state_24106[(4)])));

return statearr_24115;
})();
var inst_24089 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(o);
var inst_24090 = fluree.db.dbproto._subid.call(null,db,inst_24089);
var state_24106__$1 = state_24106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24106__$1,(6),inst_24090);
} else {
if((state_val_24107 === (9))){
var inst_24097 = (state_24106[(2)]);
var inst_24098 = [new cljs.core.Keyword(null,"value","value",305978217)];
var inst_24099 = [inst_24097];
var inst_24100 = cljs.core.PersistentHashMap.fromArrays(inst_24098,inst_24099);
var inst_24101 = cljs.core.assoc.call(null,where_clause,new cljs.core.Keyword(null,"o","o",-1350007228),inst_24100);
var _ = (function (){var statearr_24116 = state_24106;
(statearr_24116[(4)] = cljs.core.rest.call(null,(state_24106[(4)])));

return statearr_24116;
})();
var state_24106__$1 = state_24106;
var statearr_24117_24132 = state_24106__$1;
(statearr_24117_24132[(2)] = inst_24101);

(statearr_24117_24132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24107 === (5))){
var _ = (function (){var statearr_24118 = state_24106;
(statearr_24118[(4)] = cljs.core.rest.call(null,(state_24106[(4)])));

return statearr_24118;
})();
var state_24106__$1 = state_24106;
var ex24114 = (state_24106__$1[(2)]);
var statearr_24119_24133 = state_24106__$1;
(statearr_24119_24133[(5)] = ex24114);


if((ex24114 instanceof Error)){
var statearr_24120_24134 = state_24106__$1;
(statearr_24120_24134[(1)] = (4));

(statearr_24120_24134[(5)] = null);

} else {
throw ex24114;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24107 === (8))){
var state_24106__$1 = state_24106;
var statearr_24121_24135 = state_24106__$1;
(statearr_24121_24135[(2)] = (0));

(statearr_24121_24135[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____0 = (function (){
var statearr_24122 = [null,null,null,null,null,null,null,null];
(statearr_24122[(0)] = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__);

(statearr_24122[(1)] = (1));

return statearr_24122;
});
var fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____1 = (function (state_24106){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24123){var ex__2749__auto__ = e24123;
var statearr_24124_24136 = state_24106;
(statearr_24124_24136[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24106[(4)]))){
var statearr_24125_24137 = state_24106;
(statearr_24125_24137[(1)] = cljs.core.first.call(null,(state_24106[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24138 = state_24106;
state_24106 = G__24138;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__ = function(state_24106){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____1.call(this,state_24106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$resolve_o_ident_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24126 = f__2769__auto__.call(null);
(statearr_24126[(6)] = c__2768__auto__);

return statearr_24126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__24139){
var map__24140 = p__24139;
var map__24140__$1 = cljs.core.__destructure_map.call(null,map__24140);
var opts = map__24140__$1;
var finish_fn = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var vars = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var f_where = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var parallelism = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var limit = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var ident_vars = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var db = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"db","db",993250759));
var offset = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var error_ch = cljs.core.get.call(null,map__24140__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24234){
var state_val_24235 = (state_24234[(1)]);
if((state_val_24235 === (7))){
var state_24234__$1 = state_24234;
var statearr_24236_24288 = state_24234__$1;
(statearr_24236_24288[(2)] = vars);

(statearr_24236_24288[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (20))){
var inst_24187 = (state_24234[(7)]);
var inst_24197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24198 = [error_ch,inst_24187];
var inst_24199 = (new cljs.core.PersistentVector(null,2,(5),inst_24197,inst_24198,null));
var state_24234__$1 = state_24234;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24234__$1,(22),inst_24199);
} else {
if((state_val_24235 === (27))){
var state_24234__$1 = state_24234;
var statearr_24237_24289 = state_24234__$1;
(statearr_24237_24289[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (1))){
var state_24234__$1 = state_24234;
var statearr_24239_24290 = state_24234__$1;
(statearr_24239_24290[(2)] = null);

(statearr_24239_24290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (24))){
var inst_24202 = (state_24234[(8)]);
var inst_24211 = (inst_24202 == null);
var state_24234__$1 = state_24234;
if(cljs.core.truth_(inst_24211)){
var statearr_24240_24291 = state_24234__$1;
(statearr_24240_24291[(1)] = (26));

} else {
var statearr_24241_24292 = state_24234__$1;
(statearr_24241_24292[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (4))){
var inst_24141 = (state_24234[(2)]);
var state_24234__$1 = state_24234;
var statearr_24242_24293 = state_24234__$1;
(statearr_24242_24293[(2)] = inst_24141);

(statearr_24242_24293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (15))){
var inst_24173 = (state_24234[(9)]);
var inst_24173__$1 = (state_24234[(2)]);
var inst_24174 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_24173__$1);
var inst_24175 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_24174);
var state_24234__$1 = (function (){var statearr_24243 = state_24234;
(statearr_24243[(9)] = inst_24173__$1);

return statearr_24243;
})();
if(inst_24175){
var statearr_24244_24294 = state_24234__$1;
(statearr_24244_24294[(1)] = (17));

} else {
var statearr_24245_24295 = state_24234__$1;
(statearr_24245_24295[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (21))){
var inst_24229 = (state_24234[(2)]);
var _ = (function (){var statearr_24246 = state_24234;
(statearr_24246[(4)] = cljs.core.rest.call(null,(state_24234[(4)])));

return statearr_24246;
})();
var state_24234__$1 = state_24234;
var statearr_24247_24296 = state_24234__$1;
(statearr_24247_24296[(2)] = inst_24229);

(statearr_24247_24296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (31))){
var inst_24223 = (state_24234[(2)]);
var state_24234__$1 = state_24234;
var statearr_24248_24297 = state_24234__$1;
(statearr_24248_24297[(2)] = inst_24223);

(statearr_24248_24297[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (13))){
var inst_24167 = fluree.db.query.subject_crawl.subject.resolve_o_ident.call(null,db,f_where);
var state_24234__$1 = state_24234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24234__$1,(16),inst_24167);
} else {
if((state_val_24235 === (22))){
var inst_24201 = (state_24234[(2)]);
var inst_24202 = cljs.core.nth.call(null,inst_24201,(0),null);
var inst_24203 = cljs.core.nth.call(null,inst_24201,(1),null);
var inst_24204 = cljs.core._EQ_.call(null,inst_24203,error_ch);
var state_24234__$1 = (function (){var statearr_24249 = state_24234;
(statearr_24249[(8)] = inst_24202);

return statearr_24249;
})();
if(inst_24204){
var statearr_24250_24298 = state_24234__$1;
(statearr_24250_24298[(1)] = (23));

} else {
var statearr_24251_24299 = state_24234__$1;
(statearr_24251_24299[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (29))){
var inst_24202 = (state_24234[(8)]);
var inst_24192 = (state_24234[(10)]);
var inst_24219 = cljs.core.conj.call(null,inst_24192,inst_24202);
var inst_24192__$1 = inst_24219;
var state_24234__$1 = (function (){var statearr_24252 = state_24234;
(statearr_24252[(10)] = inst_24192__$1);

return statearr_24252;
})();
var statearr_24253_24300 = state_24234__$1;
(statearr_24253_24300[(2)] = null);

(statearr_24253_24300[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (6))){
var inst_24153 = fluree.db.query.subject_crawl.common.resolve_ident_vars.call(null,db,vars,ident_vars);
var state_24234__$1 = state_24234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24234__$1,(9),inst_24153);
} else {
if((state_val_24235 === (28))){
var inst_24225 = (state_24234[(2)]);
var state_24234__$1 = state_24234;
var statearr_24254_24301 = state_24234__$1;
(statearr_24254_24301[(2)] = inst_24225);

(statearr_24254_24301[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (25))){
var inst_24227 = (state_24234[(2)]);
var state_24234__$1 = state_24234;
var statearr_24255_24302 = state_24234__$1;
(statearr_24255_24302[(2)] = inst_24227);

(statearr_24255_24302[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (17))){
var inst_24173 = (state_24234[(9)]);
var inst_24159 = (state_24234[(11)]);
var inst_24177 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,inst_24159,inst_24173);
var state_24234__$1 = state_24234;
var statearr_24256_24303 = state_24234__$1;
(statearr_24256_24303[(2)] = inst_24177);

(statearr_24256_24303[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (3))){
var inst_24232 = (state_24234[(2)]);
var state_24234__$1 = state_24234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24234__$1,inst_24232);
} else {
if((state_val_24235 === (12))){
var inst_24165 = (state_24234[(2)]);
var state_24234__$1 = state_24234;
if(cljs.core.truth_(inst_24165)){
var statearr_24257_24304 = state_24234__$1;
(statearr_24257_24304[(1)] = (13));

} else {
var statearr_24258_24305 = state_24234__$1;
(statearr_24258_24305[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (2))){
var _ = (function (){var statearr_24259 = state_24234;
(statearr_24259[(4)] = cljs.core.cons.call(null,(5),(state_24234[(4)])));

return statearr_24259;
})();
var inst_24148 = f_where;
var inst_24149 = cljs.core.__destructure_map.call(null,inst_24148);
var inst_24150 = cljs.core.get.call(null,inst_24149,new cljs.core.Keyword(null,"o","o",-1350007228));
var inst_24151 = cljs.core.get.call(null,inst_24149,new cljs.core.Keyword(null,"p-ref?","p-ref?",-1416067934));
var state_24234__$1 = (function (){var statearr_24260 = state_24234;
(statearr_24260[(12)] = inst_24150);

(statearr_24260[(13)] = inst_24151);

return statearr_24260;
})();
if(cljs.core.truth_(ident_vars)){
var statearr_24261_24306 = state_24234__$1;
(statearr_24261_24306[(1)] = (6));

} else {
var statearr_24262_24307 = state_24234__$1;
(statearr_24262_24307[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (23))){
var inst_24202 = (state_24234[(8)]);
var inst_24186 = (state_24234[(14)]);
var inst_24181 = (state_24234[(15)]);
var inst_24187 = (state_24234[(7)]);
var inst_24206 = cljs.core.async.close_BANG_.call(null,inst_24181);
var inst_24207 = cljs.core.async.close_BANG_.call(null,inst_24186);
var inst_24208 = cljs.core.async.close_BANG_.call(null,inst_24187);
var inst_24209 = (function(){throw inst_24202})();
var state_24234__$1 = (function (){var statearr_24263 = state_24234;
(statearr_24263[(16)] = inst_24206);

(statearr_24263[(17)] = inst_24208);

(statearr_24263[(18)] = inst_24207);

return statearr_24263;
})();
var statearr_24264_24308 = state_24234__$1;
(statearr_24264_24308[(2)] = inst_24209);

(statearr_24264_24308[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (19))){
var inst_24186 = (state_24234[(14)]);
var inst_24181 = (state_24234[(15)]);
var inst_24160 = (state_24234[(19)]);
var inst_24187 = (state_24234[(7)]);
var inst_24181__$1 = (state_24234[(2)]);
var inst_24182 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,inst_24160);
var inst_24183 = cljs.core.drop.call(null,offset);
var inst_24184 = cljs.core.take.call(null,limit);
var inst_24185 = cljs.core.comp.call(null,inst_24183,inst_24184);
var inst_24186__$1 = cljs.core.async.chan.call(null,(32),inst_24185);
var inst_24187__$1 = cljs.core.async.chan.call(null);
var inst_24188 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24186__$1,inst_24182,inst_24181__$1);
var inst_24189 = fluree.db.query.subject_crawl.common.result_af.call(null,inst_24160);
var inst_24190 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24187__$1,inst_24189,inst_24186__$1);
var inst_24191 = cljs.core.PersistentVector.EMPTY;
var inst_24192 = inst_24191;
var state_24234__$1 = (function (){var statearr_24265 = state_24234;
(statearr_24265[(20)] = inst_24190);

(statearr_24265[(14)] = inst_24186__$1);

(statearr_24265[(21)] = inst_24188);

(statearr_24265[(10)] = inst_24192);

(statearr_24265[(15)] = inst_24181__$1);

(statearr_24265[(7)] = inst_24187__$1);

return statearr_24265;
})();
var statearr_24266_24309 = state_24234__$1;
(statearr_24266_24309[(2)] = null);

(statearr_24266_24309[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (11))){
var inst_24151 = (state_24234[(13)]);
var state_24234__$1 = state_24234;
var statearr_24268_24310 = state_24234__$1;
(statearr_24268_24310[(2)] = inst_24151);

(statearr_24268_24310[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (9))){
var inst_24155 = (state_24234[(2)]);
var inst_24156 = fluree.db.util.async.throw_err.call(null,inst_24155);
var state_24234__$1 = state_24234;
var statearr_24269_24311 = state_24234__$1;
(statearr_24269_24311[(2)] = inst_24156);

(statearr_24269_24311[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (5))){
var _ = (function (){var statearr_24270 = state_24234;
(statearr_24270[(4)] = cljs.core.rest.call(null,(state_24234[(4)])));

return statearr_24270;
})();
var state_24234__$1 = state_24234;
var ex24267 = (state_24234__$1[(2)]);
var statearr_24271_24312 = state_24234__$1;
(statearr_24271_24312[(5)] = ex24267);


if((ex24267 instanceof Error)){
var statearr_24272_24313 = state_24234__$1;
(statearr_24272_24313[(1)] = (4));

(statearr_24272_24313[(5)] = null);

} else {
throw ex24267;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (14))){
var state_24234__$1 = state_24234;
var statearr_24273_24314 = state_24234__$1;
(statearr_24273_24314[(2)] = f_where);

(statearr_24273_24314[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (26))){
var inst_24186 = (state_24234[(14)]);
var inst_24192 = (state_24234[(10)]);
var inst_24181 = (state_24234[(15)]);
var inst_24187 = (state_24234[(7)]);
var inst_24213 = cljs.core.async.close_BANG_.call(null,inst_24181);
var inst_24214 = cljs.core.async.close_BANG_.call(null,inst_24186);
var inst_24215 = cljs.core.async.close_BANG_.call(null,inst_24187);
var inst_24216 = finish_fn.call(null,inst_24192);
var state_24234__$1 = (function (){var statearr_24274 = state_24234;
(statearr_24274[(22)] = inst_24215);

(statearr_24274[(23)] = inst_24213);

(statearr_24274[(24)] = inst_24214);

return statearr_24274;
})();
var statearr_24275_24315 = state_24234__$1;
(statearr_24275_24315[(2)] = inst_24216);

(statearr_24275_24315[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (16))){
var inst_24169 = (state_24234[(2)]);
var inst_24170 = fluree.db.util.async.throw_err.call(null,inst_24169);
var state_24234__$1 = state_24234;
var statearr_24276_24316 = state_24234__$1;
(statearr_24276_24316[(2)] = inst_24170);

(statearr_24276_24316[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (30))){
var state_24234__$1 = state_24234;
var statearr_24277_24317 = state_24234__$1;
(statearr_24277_24317[(2)] = null);

(statearr_24277_24317[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (10))){
var inst_24150 = (state_24234[(12)]);
var inst_24162 = new cljs.core.Keyword(null,"ident","ident",-742346).cljs$core$IFn$_invoke$arity$1(inst_24150);
var state_24234__$1 = state_24234;
var statearr_24278_24318 = state_24234__$1;
(statearr_24278_24318[(2)] = inst_24162);

(statearr_24278_24318[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (18))){
var inst_24173 = (state_24234[(9)]);
var inst_24159 = (state_24234[(11)]);
var inst_24179 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,inst_24159,inst_24173);
var state_24234__$1 = state_24234;
var statearr_24279_24319 = state_24234__$1;
(statearr_24279_24319[(2)] = inst_24179);

(statearr_24279_24319[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24235 === (8))){
var inst_24159 = (state_24234[(11)]);
var inst_24151 = (state_24234[(13)]);
var inst_24159__$1 = (state_24234[(2)]);
var inst_24160 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24159__$1);
var state_24234__$1 = (function (){var statearr_24280 = state_24234;
(statearr_24280[(11)] = inst_24159__$1);

(statearr_24280[(19)] = inst_24160);

return statearr_24280;
})();
if(cljs.core.truth_(inst_24151)){
var statearr_24281_24320 = state_24234__$1;
(statearr_24281_24320[(1)] = (10));

} else {
var statearr_24282_24321 = state_24234__$1;
(statearr_24282_24321[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0 = (function (){
var statearr_24283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24283[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__);

(statearr_24283[(1)] = (1));

return statearr_24283;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1 = (function (state_24234){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24284){var ex__2749__auto__ = e24284;
var statearr_24285_24322 = state_24234;
(statearr_24285_24322[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24234[(4)]))){
var statearr_24286_24323 = state_24234;
(statearr_24286_24323[(1)] = cljs.core.first.call(null,(state_24234[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24324 = state_24234;
state_24234 = G__24324;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = function(state_24234){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1.call(this,state_24234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24287 = f__2769__auto__.call(null);
(statearr_24287[(6)] = c__2768__auto__);

return statearr_24287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
