// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__24644){
var map__24645 = p__24644;
var map__24645__$1 = cljs.core.__destructure_map.call(null,map__24645);
var parsed_query = map__24645__$1;
var select = cljs.core.get.call(null,map__24645__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.call(null,map__24645__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db.call(null,db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__24646){
var map__24647 = p__24646;
var map__24647__$1 = cljs.core.__destructure_map.call(null,map__24647);
var opts = map__24647__$1;
var rdf_type_QMARK_ = cljs.core.get.call(null,map__24647__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.call(null,map__24647__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24691){
var state_val_24692 = (state_24691[(1)]);
if((state_val_24692 === (7))){
var inst_24670 = (state_24691[(7)]);
var inst_24672 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,inst_24670);
var state_24691__$1 = state_24691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24691__$1,(10),inst_24672);
} else {
if((state_val_24692 === (1))){
var inst_24655 = vars;
var inst_24656 = cljs.core.seq.call(null,inst_24655);
var inst_24657 = cljs.core.first.call(null,inst_24656);
var inst_24658 = cljs.core.next.call(null,inst_24656);
var inst_24659 = cljs.core.PersistentVector.EMPTY;
var inst_24660 = inst_24655;
var inst_24661 = inst_24659;
var state_24691__$1 = (function (){var statearr_24693 = state_24691;
(statearr_24693[(8)] = inst_24657);

(statearr_24693[(9)] = inst_24660);

(statearr_24693[(10)] = inst_24661);

(statearr_24693[(11)] = inst_24658);

return statearr_24693;
})();
var statearr_24694_24712 = state_24691__$1;
(statearr_24694_24712[(2)] = null);

(statearr_24694_24712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (4))){
var inst_24667 = (state_24691[(12)]);
var inst_24670 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24667);
var state_24691__$1 = (function (){var statearr_24695 = state_24691;
(statearr_24695[(7)] = inst_24670);

return statearr_24695;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_24696_24713 = state_24691__$1;
(statearr_24696_24713[(1)] = (7));

} else {
var statearr_24697_24714 = state_24691__$1;
(statearr_24697_24714[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (6))){
var inst_24687 = (state_24691[(2)]);
var state_24691__$1 = state_24691;
var statearr_24698_24715 = state_24691__$1;
(statearr_24698_24715[(2)] = inst_24687);

(statearr_24698_24715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (3))){
var inst_24689 = (state_24691[(2)]);
var state_24691__$1 = state_24691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24691__$1,inst_24689);
} else {
if((state_val_24692 === (2))){
var inst_24660 = (state_24691[(9)]);
var inst_24667 = (state_24691[(12)]);
var inst_24666 = cljs.core.seq.call(null,inst_24660);
var inst_24667__$1 = cljs.core.first.call(null,inst_24666);
var inst_24668 = cljs.core.next.call(null,inst_24666);
var state_24691__$1 = (function (){var statearr_24699 = state_24691;
(statearr_24699[(12)] = inst_24667__$1);

(statearr_24699[(13)] = inst_24668);

return statearr_24699;
})();
if(cljs.core.truth_(inst_24667__$1)){
var statearr_24700_24716 = state_24691__$1;
(statearr_24700_24716[(1)] = (4));

} else {
var statearr_24701_24717 = state_24691__$1;
(statearr_24701_24717[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (11))){
var inst_24679 = (state_24691[(2)]);
var inst_24680 = fluree.db.util.async.throw_err.call(null,inst_24679);
var state_24691__$1 = state_24691;
var statearr_24702_24718 = state_24691__$1;
(statearr_24702_24718[(2)] = inst_24680);

(statearr_24702_24718[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (9))){
var inst_24668 = (state_24691[(13)]);
var inst_24661 = (state_24691[(10)]);
var inst_24682 = (state_24691[(2)]);
var inst_24683 = cljs.core.into.call(null,inst_24661,inst_24682);
var inst_24660 = inst_24668;
var inst_24661__$1 = inst_24683;
var state_24691__$1 = (function (){var statearr_24703 = state_24691;
(statearr_24703[(9)] = inst_24660);

(statearr_24703[(10)] = inst_24661__$1);

return statearr_24703;
})();
var statearr_24704_24719 = state_24691__$1;
(statearr_24704_24719[(2)] = null);

(statearr_24704_24719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (5))){
var inst_24661 = (state_24691[(10)]);
var state_24691__$1 = state_24691;
var statearr_24705_24720 = state_24691__$1;
(statearr_24705_24720[(2)] = inst_24661);

(statearr_24705_24720[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (10))){
var inst_24674 = (state_24691[(2)]);
var inst_24675 = fluree.db.util.async.throw_err.call(null,inst_24674);
var state_24691__$1 = state_24691;
var statearr_24706_24721 = state_24691__$1;
(statearr_24706_24721[(2)] = inst_24675);

(statearr_24706_24721[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24692 === (8))){
var inst_24670 = (state_24691[(7)]);
var inst_24677 = fluree.db.query.subject_crawl.subject.subj_crawl.call(null,inst_24670);
var state_24691__$1 = state_24691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24691__$1,(11),inst_24677);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0 = (function (){
var statearr_24707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24707[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__);

(statearr_24707[(1)] = (1));

return statearr_24707;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1 = (function (state_24691){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24708){var ex__2749__auto__ = e24708;
var statearr_24709_24722 = state_24691;
(statearr_24709_24722[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24691[(4)]))){
var statearr_24710_24723 = state_24691;
(statearr_24710_24723[(1)] = cljs.core.first.call(null,(state_24691[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24724 = state_24691;
state_24691 = G__24724;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__ = function(state_24691){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1.call(this,state_24691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24711 = f__2769__auto__.call(null);
(statearr_24711[(6)] = c__2768__auto__);

return statearr_24711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__24726){
var map__24727 = p__24726;
var map__24727__$1 = cljs.core.__destructure_map.call(null,map__24727);
var parsed_query = map__24727__$1;
var selectOne_QMARK_ = cljs.core.get.call(null,map__24727__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.call(null,map__24727__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.call(null,map__24727__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var limit = cljs.core.get.call(null,map__24727__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var fns = (function (){var G__24728 = cljs.core.PersistentVector.EMPTY;
var G__24728__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.call(null,G__24728,(function (result){
return cljs.core.first.call(null,result);
})):G__24728);
var G__24728__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.call(null,G__24728__$1,(function (){var select_var = cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.call(null,(function (p1__24725_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__24725_SHARP_]);
}),result);
});
})()):G__24728__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.call(null,G__24728__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results.call(null,result,order_by,limit);
}));
} else {
return G__24728__$2;
}
})();
if(cljs.core.empty_QMARK_.call(null,fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.call(null,cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__24729){
var map__24730 = p__24729;
var map__24730__$1 = cljs.core.__destructure_map.call(null,map__24730);
var parsed_query = map__24730__$1;
var vars = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var ident_vars = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986));
var where = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var order_by = cljs.core.get.call(null,map__24730__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var error_ch = cljs.core.async.chan.call(null);
var f_where = cljs.core.first.call(null,where);
var rdf_type_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,where));
var cache = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_.call(null,(0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec.call(null,db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn.call(null,parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,(cljs.core.truth_(order_by)?(9007199254740991):limit),ident_vars,offset,db,error_ch,cljs.core.not.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding.call(null,opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl.call(null,opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl.call(null,opts);
}
}
});
