// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16007){
var state_val_16008 = (state_16007[(1)]);
if((state_val_16008 === (1))){
var state_16007__$1 = state_16007;
var statearr_16009_16023 = state_16007__$1;
(statearr_16009_16023[(2)] = null);

(statearr_16009_16023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16008 === (2))){
var _ = (function (){var statearr_16010 = state_16007;
(statearr_16010[(4)] = cljs.core.cons.call(null,(5),(state_16007[(4)])));

return statearr_16010;
})();
var inst_15998 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_16007__$1 = state_16007;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16007__$1,(6),inst_15998);
} else {
if((state_val_16008 === (3))){
var inst_16005 = (state_16007[(2)]);
var state_16007__$1 = state_16007;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16007__$1,inst_16005);
} else {
if((state_val_16008 === (4))){
var inst_15992 = (state_16007[(2)]);
var state_16007__$1 = state_16007;
var statearr_16012_16024 = state_16007__$1;
(statearr_16012_16024[(2)] = inst_15992);

(statearr_16012_16024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16008 === (5))){
var _ = (function (){var statearr_16013 = state_16007;
(statearr_16013[(4)] = cljs.core.rest.call(null,(state_16007[(4)])));

return statearr_16013;
})();
var state_16007__$1 = state_16007;
var ex16011 = (state_16007__$1[(2)]);
var statearr_16014_16025 = state_16007__$1;
(statearr_16014_16025[(5)] = ex16011);


if((ex16011 instanceof Error)){
var statearr_16015_16026 = state_16007__$1;
(statearr_16015_16026[(1)] = (4));

(statearr_16015_16026[(5)] = null);

} else {
throw ex16011;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16008 === (6))){
var inst_16000 = (state_16007[(2)]);
var inst_16001 = fluree.db.util.async.throw_err.call(null,inst_16000);
var inst_16002 = cljs.core.keyword.call(null,inst_16001);
var _ = (function (){var statearr_16016 = state_16007;
(statearr_16016[(4)] = cljs.core.rest.call(null,(state_16007[(4)])));

return statearr_16016;
})();
var state_16007__$1 = state_16007;
var statearr_16017_16027 = state_16007__$1;
(statearr_16017_16027[(2)] = inst_16002);

(statearr_16017_16027[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0 = (function (){
var statearr_16018 = [null,null,null,null,null,null,null];
(statearr_16018[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__);

(statearr_16018[(1)] = (1));

return statearr_16018;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1 = (function (state_16007){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16007);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16019){var ex__2749__auto__ = e16019;
var statearr_16020_16028 = state_16007;
(statearr_16020_16028[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16007[(4)]))){
var statearr_16021_16029 = state_16007;
(statearr_16021_16029[(1)] = cljs.core.first.call(null,(state_16007[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16030 = state_16007;
state_16007 = G__16030;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__ = function(state_16007){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1.call(this,state_16007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16022 = f__2769__auto__.call(null);
(statearr_16022[(6)] = c__2768__auto__);

return statearr_16022;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16062){
var state_val_16063 = (state_16062[(1)]);
if((state_val_16063 === (7))){
var inst_16046 = (state_16062[(7)]);
var inst_16048 = cljs.core.empty_QMARK_.call(null,inst_16046);
var inst_16049 = (!(inst_16048));
var state_16062__$1 = state_16062;
var statearr_16064_16088 = state_16062__$1;
(statearr_16064_16088[(2)] = inst_16049);

(statearr_16064_16088[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (1))){
var state_16062__$1 = state_16062;
var statearr_16065_16089 = state_16062__$1;
(statearr_16065_16089[(2)] = null);

(statearr_16065_16089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (4))){
var inst_16032 = (state_16062[(2)]);
var state_16062__$1 = state_16062;
var statearr_16066_16090 = state_16062__$1;
(statearr_16066_16090[(2)] = inst_16032);

(statearr_16066_16090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (6))){
var inst_16038 = (state_16062[(8)]);
var inst_16046 = (state_16062[(7)]);
var inst_16044 = (state_16062[(2)]);
var inst_16045 = fluree.db.util.async.throw_err.call(null,inst_16044);
var inst_16046__$1 = cljs.core.map.call(null,inst_16038,inst_16045);
var state_16062__$1 = (function (){var statearr_16067 = state_16062;
(statearr_16067[(7)] = inst_16046__$1);

return statearr_16067;
})();
if(cljs.core.truth_(inst_16046__$1)){
var statearr_16068_16091 = state_16062__$1;
(statearr_16068_16091[(1)] = (7));

} else {
var statearr_16069_16092 = state_16062__$1;
(statearr_16069_16092[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (3))){
var inst_16060 = (state_16062[(2)]);
var state_16062__$1 = state_16062;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16062__$1,inst_16060);
} else {
if((state_val_16063 === (12))){
var inst_16057 = (state_16062[(2)]);
var _ = (function (){var statearr_16070 = state_16062;
(statearr_16070[(4)] = cljs.core.rest.call(null,(state_16062[(4)])));

return statearr_16070;
})();
var state_16062__$1 = state_16062;
var statearr_16071_16093 = state_16062__$1;
(statearr_16071_16093[(2)] = inst_16057);

(statearr_16071_16093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (2))){
var _ = (function (){var statearr_16072 = state_16062;
(statearr_16072[(4)] = cljs.core.cons.call(null,(5),(state_16062[(4)])));

return statearr_16072;
})();
var inst_16038 = (function (){return (function (p1__16031_SHARP_){
return fluree.db.flake.o.call(null,p1__16031_SHARP_);
});
})();
var inst_16039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16040 = [pred_id];
var inst_16041 = (new cljs.core.PersistentVector(null,1,(5),inst_16039,inst_16040,null));
var inst_16042 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_16041);
var state_16062__$1 = (function (){var statearr_16073 = state_16062;
(statearr_16073[(8)] = inst_16038);

return statearr_16073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16062__$1,(6),inst_16042);
} else {
if((state_val_16063 === (11))){
var state_16062__$1 = state_16062;
var statearr_16075_16094 = state_16062__$1;
(statearr_16075_16094[(2)] = true);

(statearr_16075_16094[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (9))){
var inst_16052 = (state_16062[(2)]);
var state_16062__$1 = state_16062;
if(cljs.core.truth_(inst_16052)){
var statearr_16076_16095 = state_16062__$1;
(statearr_16076_16095[(1)] = (10));

} else {
var statearr_16077_16096 = state_16062__$1;
(statearr_16077_16096[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (5))){
var _ = (function (){var statearr_16078 = state_16062;
(statearr_16078[(4)] = cljs.core.rest.call(null,(state_16062[(4)])));

return statearr_16078;
})();
var state_16062__$1 = state_16062;
var ex16074 = (state_16062__$1[(2)]);
var statearr_16079_16097 = state_16062__$1;
(statearr_16079_16097[(5)] = ex16074);


if((ex16074 instanceof Error)){
var statearr_16080_16098 = state_16062__$1;
(statearr_16080_16098[(1)] = (4));

(statearr_16080_16098[(5)] = null);

} else {
throw ex16074;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (10))){
var inst_16046 = (state_16062[(7)]);
var inst_16054 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_16046);
var state_16062__$1 = state_16062;
var statearr_16081_16099 = state_16062__$1;
(statearr_16081_16099[(2)] = inst_16054);

(statearr_16081_16099[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16063 === (8))){
var inst_16046 = (state_16062[(7)]);
var state_16062__$1 = state_16062;
var statearr_16082_16100 = state_16062__$1;
(statearr_16082_16100[(2)] = inst_16046);

(statearr_16082_16100[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_16083 = [null,null,null,null,null,null,null,null,null];
(statearr_16083[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__);

(statearr_16083[(1)] = (1));

return statearr_16083;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1 = (function (state_16062){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16062);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16084){var ex__2749__auto__ = e16084;
var statearr_16085_16101 = state_16062;
(statearr_16085_16101[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16062[(4)]))){
var statearr_16086_16102 = state_16062;
(statearr_16086_16102[(1)] = cljs.core.first.call(null,(state_16062[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16103 = state_16062;
state_16062 = G__16103;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__ = function(state_16062){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1.call(this,state_16062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16087 = f__2769__auto__.call(null);
(statearr_16087[(6)] = c__2768__auto__);

return statearr_16087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16184){
var state_val_16185 = (state_16184[(1)]);
if((state_val_16185 === (7))){
var state_16184__$1 = state_16184;
var statearr_16186_16223 = state_16184__$1;
(statearr_16186_16223[(2)] = flakes);

(statearr_16186_16223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (20))){
var inst_16141 = (state_16184[(7)]);
var inst_16174 = (state_16184[(2)]);
var inst_16133 = inst_16141;
var inst_16134 = inst_16174;
var state_16184__$1 = (function (){var statearr_16187 = state_16184;
(statearr_16187[(8)] = inst_16134);

(statearr_16187[(9)] = inst_16133);

return statearr_16187;
})();
var statearr_16188_16224 = state_16184__$1;
(statearr_16188_16224[(2)] = null);

(statearr_16188_16224[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (1))){
var state_16184__$1 = state_16184;
var statearr_16189_16225 = state_16184__$1;
(statearr_16189_16225[(2)] = null);

(statearr_16189_16225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (4))){
var inst_16106 = (state_16184[(2)]);
var state_16184__$1 = state_16184;
var statearr_16190_16226 = state_16184__$1;
(statearr_16190_16226[(2)] = inst_16106);

(statearr_16190_16226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (15))){
var inst_16140 = (state_16184[(10)]);
var inst_16158 = fluree.db.flake.o.call(null,inst_16140);
var state_16184__$1 = state_16184;
var statearr_16191_16227 = state_16184__$1;
(statearr_16191_16227[(2)] = inst_16158);

(statearr_16191_16227[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (13))){
var inst_16177 = (state_16184[(2)]);
var state_16184__$1 = state_16184;
var statearr_16192_16228 = state_16184__$1;
(statearr_16192_16228[(2)] = inst_16177);

(statearr_16192_16228[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (6))){
var inst_16113 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_16184__$1 = state_16184;
var statearr_16193_16229 = state_16184__$1;
(statearr_16193_16229[(2)] = inst_16113);

(statearr_16193_16229[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (17))){
var inst_16155 = (state_16184[(2)]);
var inst_16156 = fluree.db.util.async.throw_err.call(null,inst_16155);
var state_16184__$1 = state_16184;
var statearr_16194_16230 = state_16184__$1;
(statearr_16194_16230[(2)] = inst_16156);

(statearr_16194_16230[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (3))){
var inst_16182 = (state_16184[(2)]);
var state_16184__$1 = state_16184;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16184__$1,inst_16182);
} else {
if((state_val_16185 === (12))){
var inst_16140 = (state_16184[(10)]);
var inst_16147 = (state_16184[(11)]);
var inst_16145 = fluree.db.flake.p.call(null,inst_16140);
var inst_16146 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_16145);
var inst_16147__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_16146);
var inst_16148 = fluree.db.flake.op.call(null,inst_16140);
var inst_16149 = inst_16148 === false;
var inst_16150 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_16147__$1);
var state_16184__$1 = (function (){var statearr_16195 = state_16184;
(statearr_16195[(12)] = inst_16149);

(statearr_16195[(11)] = inst_16147__$1);

return statearr_16195;
})();
if(inst_16150){
var statearr_16196_16231 = state_16184__$1;
(statearr_16196_16231[(1)] = (14));

} else {
var statearr_16197_16232 = state_16184__$1;
(statearr_16197_16232[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (2))){
var _ = (function (){var statearr_16198 = state_16184;
(statearr_16198[(4)] = cljs.core.cons.call(null,(5),(state_16184[(4)])));

return statearr_16198;
})();
var state_16184__$1 = state_16184;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_16199_16233 = state_16184__$1;
(statearr_16199_16233[(1)] = (6));

} else {
var statearr_16200_16234 = state_16184__$1;
(statearr_16200_16234[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (19))){
var inst_16134 = (state_16184[(8)]);
var inst_16140 = (state_16184[(10)]);
var inst_16160 = (state_16184[(13)]);
var inst_16147 = (state_16184[(11)]);
var inst_16168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16169 = fluree.db.flake.s.call(null,inst_16140);
var inst_16170 = [inst_16169,inst_16147,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_16171 = (new cljs.core.PersistentVector(null,3,(5),inst_16168,inst_16170,null));
var inst_16172 = cljs.core.assoc_in.call(null,inst_16134,inst_16171,inst_16160);
var state_16184__$1 = state_16184;
var statearr_16201_16235 = state_16184__$1;
(statearr_16201_16235[(2)] = inst_16172);

(statearr_16201_16235[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (11))){
var inst_16134 = (state_16184[(8)]);
var state_16184__$1 = state_16184;
var statearr_16203_16236 = state_16184__$1;
(statearr_16203_16236[(2)] = inst_16134);

(statearr_16203_16236[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (9))){
var inst_16133 = (state_16184[(9)]);
var inst_16140 = (state_16184[(10)]);
var inst_16139 = cljs.core.seq.call(null,inst_16133);
var inst_16140__$1 = cljs.core.first.call(null,inst_16139);
var inst_16141 = cljs.core.next.call(null,inst_16139);
var inst_16142 = cljs.core.not.call(null,inst_16140__$1);
var state_16184__$1 = (function (){var statearr_16204 = state_16184;
(statearr_16204[(7)] = inst_16141);

(statearr_16204[(10)] = inst_16140__$1);

return statearr_16204;
})();
if(inst_16142){
var statearr_16205_16237 = state_16184__$1;
(statearr_16205_16237[(1)] = (11));

} else {
var statearr_16206_16238 = state_16184__$1;
(statearr_16206_16238[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (5))){
var _ = (function (){var statearr_16207 = state_16184;
(statearr_16207[(4)] = cljs.core.rest.call(null,(state_16184[(4)])));

return statearr_16207;
})();
var state_16184__$1 = state_16184;
var ex16202 = (state_16184__$1[(2)]);
var statearr_16208_16239 = state_16184__$1;
(statearr_16208_16239[(5)] = ex16202);


if((ex16202 instanceof Error)){
var statearr_16209_16240 = state_16184__$1;
(statearr_16209_16240[(1)] = (4));

(statearr_16209_16240[(5)] = null);

} else {
throw ex16202;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (14))){
var inst_16140 = (state_16184[(10)]);
var inst_16152 = fluree.db.flake.o.call(null,inst_16140);
var inst_16153 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_16152,db);
var state_16184__$1 = state_16184;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16184__$1,(17),inst_16153);
} else {
if((state_val_16185 === (16))){
var inst_16149 = (state_16184[(12)]);
var inst_16160 = (state_16184[(2)]);
var state_16184__$1 = (function (){var statearr_16210 = state_16184;
(statearr_16210[(13)] = inst_16160);

return statearr_16210;
})();
if(cljs.core.truth_(inst_16149)){
var statearr_16211_16241 = state_16184__$1;
(statearr_16211_16241[(1)] = (18));

} else {
var statearr_16212_16242 = state_16184__$1;
(statearr_16212_16242[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (10))){
var inst_16179 = (state_16184[(2)]);
var _ = (function (){var statearr_16213 = state_16184;
(statearr_16213[(4)] = cljs.core.rest.call(null,(state_16184[(4)])));

return statearr_16213;
})();
var state_16184__$1 = state_16184;
var statearr_16214_16243 = state_16184__$1;
(statearr_16214_16243[(2)] = inst_16179);

(statearr_16214_16243[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (18))){
var inst_16134 = (state_16184[(8)]);
var inst_16140 = (state_16184[(10)]);
var inst_16160 = (state_16184[(13)]);
var inst_16147 = (state_16184[(11)]);
var inst_16162 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16163 = fluree.db.flake.s.call(null,inst_16140);
var inst_16164 = [inst_16163,inst_16147,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_16165 = (new cljs.core.PersistentVector(null,3,(5),inst_16162,inst_16164,null));
var inst_16166 = cljs.core.assoc_in.call(null,inst_16134,inst_16165,inst_16160);
var state_16184__$1 = state_16184;
var statearr_16215_16244 = state_16184__$1;
(statearr_16215_16244[(2)] = inst_16166);

(statearr_16215_16244[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16185 === (8))){
var inst_16116 = (state_16184[(2)]);
var inst_16117 = cljs.core.PersistentHashSet.EMPTY;
var inst_16118 = cljs.core.vals.call(null,tempids);
var inst_16119 = cljs.core.into.call(null,inst_16117,inst_16118);
var inst_16120 = (function (){var pred_flakes = inst_16116;
var is_new_QMARK_ = inst_16119;
return (function (p1__16105_SHARP_,p2__16104_SHARP_){
var f = p2__16104_SHARP_;
return cljs.core.assoc_in.call(null,p1__16105_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s.call(null,f),new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,fluree.db.flake.s.call(null,f))));
});
})();
var inst_16121 = cljs.core.PersistentHashMap.EMPTY;
var inst_16122 = cljs.core.reduce.call(null,inst_16120,inst_16121,inst_16116);
var inst_16130 = cljs.core.seq.call(null,inst_16116);
var inst_16131 = cljs.core.first.call(null,inst_16130);
var inst_16132 = cljs.core.next.call(null,inst_16130);
var inst_16133 = inst_16116;
var inst_16134 = inst_16122;
var state_16184__$1 = (function (){var statearr_16216 = state_16184;
(statearr_16216[(8)] = inst_16134);

(statearr_16216[(14)] = inst_16131);

(statearr_16216[(9)] = inst_16133);

(statearr_16216[(15)] = inst_16132);

return statearr_16216;
})();
var statearr_16217_16245 = state_16184__$1;
(statearr_16217_16245[(2)] = null);

(statearr_16217_16245[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0 = (function (){
var statearr_16218 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16218[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__);

(statearr_16218[(1)] = (1));

return statearr_16218;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1 = (function (state_16184){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16184);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16219){var ex__2749__auto__ = e16219;
var statearr_16220_16246 = state_16184;
(statearr_16220_16246[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16184[(4)]))){
var statearr_16221_16247 = state_16184;
(statearr_16221_16247[(1)] = cljs.core.first.call(null,(state_16184[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16248 = state_16184;
state_16184 = G__16248;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__ = function(state_16184){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1.call(this,state_16184);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16222 = f__2769__auto__.call(null);
(statearr_16222[(6)] = c__2768__auto__);

return statearr_16222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__16250 = arguments.length;
switch (G__16250) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__16253 = arguments.length;
switch (G__16253) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16565){
var state_val_16566 = (state_16565[(1)]);
if((state_val_16566 === (121))){
var inst_16520 = (state_16565[(7)]);
var state_16565__$1 = state_16565;
var statearr_16567_16760 = state_16565__$1;
(statearr_16567_16760[(2)] = inst_16520);

(statearr_16567_16760[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (65))){
var inst_16419 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16419)){
var statearr_16568_16761 = state_16565__$1;
(statearr_16568_16761[(1)] = (66));

} else {
var statearr_16569_16762 = state_16565__$1;
(statearr_16569_16762[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (70))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16429 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_16430 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,3,inst_16429,null);
var inst_16431 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16430,null);
var inst_16432 = inst_16431.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16432)){
var statearr_16570_16763 = state_16565__$1;
(statearr_16570_16763[(1)] = (72));

} else {
var statearr_16571_16764 = state_16565__$1;
(statearr_16571_16764[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (62))){
var inst_16409 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16572_16765 = state_16565__$1;
(statearr_16572_16765[(2)] = inst_16409);

(statearr_16572_16765[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (74))){
var inst_16515 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16573_16766 = state_16565__$1;
(statearr_16573_16766[(2)] = inst_16515);

(statearr_16573_16766[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (110))){
var inst_16542 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16542)){
var statearr_16574_16767 = state_16565__$1;
(statearr_16574_16767[(1)] = (117));

} else {
var statearr_16575_16768 = state_16565__$1;
(statearr_16575_16768[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (7))){
var inst_16560 = (state_16565[(2)]);
var _ = (function (){var statearr_16576 = state_16565;
(statearr_16576[(4)] = cljs.core.rest.call(null,(state_16565[(4)])));

return statearr_16576;
})();
var state_16565__$1 = state_16565;
var statearr_16577_16769 = state_16565__$1;
(statearr_16577_16769[(2)] = inst_16560);

(statearr_16577_16769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (59))){
var inst_16413 = (state_16565[(10)]);
var inst_16293 = (state_16565[(11)]);
var inst_16412 = (state_16565[(2)]);
var inst_16413__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16578 = state_16565;
(statearr_16578[(12)] = inst_16412);

(statearr_16578[(10)] = inst_16413__$1);

return statearr_16578;
})();
if(cljs.core.truth_(inst_16413__$1)){
var statearr_16579_16770 = state_16565__$1;
(statearr_16579_16770[(1)] = (63));

} else {
var statearr_16580_16771 = state_16565__$1;
(statearr_16580_16771[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (86))){
var inst_16455 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16581_16772 = state_16565__$1;
(statearr_16581_16772[(2)] = inst_16455);

(statearr_16581_16772[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (20))){
var inst_16319 = (state_16565[(13)]);
var inst_16293 = (state_16565[(11)]);
var inst_16319__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16582 = state_16565;
(statearr_16582[(13)] = inst_16319__$1);

return statearr_16582;
})();
if(cljs.core.truth_(inst_16319__$1)){
var statearr_16583_16773 = state_16565__$1;
(statearr_16583_16773[(1)] = (23));

} else {
var statearr_16584_16774 = state_16565__$1;
(statearr_16584_16774[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (72))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16434 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16585_16775 = state_16565__$1;
(statearr_16585_16775[(2)] = inst_16434);

(statearr_16585_16775[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (58))){
var inst_16374 = (state_16565[(14)]);
var state_16565__$1 = state_16565;
var statearr_16586_16776 = state_16565__$1;
(statearr_16586_16776[(2)] = inst_16374);

(statearr_16586_16776[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (60))){
var inst_16281 = (state_16565[(15)]);
var inst_16292 = (state_16565[(16)]);
var inst_16400 = fluree.db.dbproto._p_prop.call(null,inst_16281,new cljs.core.Keyword(null,"name","name",1843675177),inst_16292);
var inst_16401 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16400)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_16402 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16403 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16404 = cljs.core.PersistentHashMap.fromArrays(inst_16402,inst_16403);
var inst_16405 = cljs.core.ex_info.call(null,inst_16401,inst_16404);
var inst_16406 = (function(){throw inst_16405})();
var state_16565__$1 = state_16565;
var statearr_16587_16777 = state_16565__$1;
(statearr_16587_16777[(2)] = inst_16406);

(statearr_16587_16777[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (27))){
var inst_16322 = (state_16565[(17)]);
var state_16565__$1 = state_16565;
var statearr_16588_16778 = state_16565__$1;
(statearr_16588_16778[(2)] = inst_16322);

(statearr_16588_16778[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (1))){
var state_16565__$1 = state_16565;
var statearr_16589_16779 = state_16565__$1;
(statearr_16589_16779[(2)] = null);

(statearr_16589_16779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (69))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16590_16780 = state_16565__$1;
(statearr_16590_16780[(2)] = inst_16412);

(statearr_16590_16780[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (101))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16493 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16591_16781 = state_16565__$1;
(statearr_16591_16781[(2)] = inst_16493);

(statearr_16591_16781[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (24))){
var inst_16319 = (state_16565[(13)]);
var state_16565__$1 = state_16565;
var statearr_16592_16782 = state_16565__$1;
(statearr_16592_16782[(2)] = inst_16319);

(statearr_16592_16782[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (102))){
var inst_16495 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16593_16783 = state_16565__$1;
(statearr_16593_16783[(2)] = inst_16495);

(statearr_16593_16783[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (55))){
var inst_16391 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16594_16784 = state_16565__$1;
(statearr_16594_16784[(2)] = inst_16391);

(statearr_16594_16784[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (85))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16453 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16595_16785 = state_16565__$1;
(statearr_16595_16785[(2)] = inst_16453);

(statearr_16595_16785[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (39))){
var inst_16356 = (state_16565[(18)]);
var state_16565__$1 = state_16565;
var statearr_16596_16786 = state_16565__$1;
(statearr_16596_16786[(2)] = inst_16356);

(statearr_16596_16786[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (88))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16597_16787 = state_16565__$1;
(statearr_16597_16787[(2)] = inst_16412);

(statearr_16597_16787[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (46))){
var inst_16375 = (state_16565[(19)]);
var inst_16293 = (state_16565[(11)]);
var inst_16374 = (state_16565[(2)]);
var inst_16375__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16598 = state_16565;
(statearr_16598[(19)] = inst_16375__$1);

(statearr_16598[(14)] = inst_16374);

return statearr_16598;
})();
if(cljs.core.truth_(inst_16375__$1)){
var statearr_16599_16788 = state_16565__$1;
(statearr_16599_16788[(1)] = (47));

} else {
var statearr_16600_16789 = state_16565__$1;
(statearr_16600_16789[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (4))){
var inst_16254 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16601_16790 = state_16565__$1;
(statearr_16601_16790[(2)] = inst_16254);

(statearr_16601_16790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (77))){
var inst_16513 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16602_16791 = state_16565__$1;
(statearr_16602_16791[(2)] = inst_16513);

(statearr_16602_16791[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (106))){
var inst_16505 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16603_16792 = state_16565__$1;
(statearr_16603_16792[(2)] = inst_16505);

(statearr_16603_16792[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (119))){
var inst_16291 = (state_16565[(20)]);
var inst_16555 = (state_16565[(2)]);
var inst_16280 = inst_16291;
var inst_16281 = inst_16555;
var state_16565__$1 = (function (){var statearr_16604 = state_16565;
(statearr_16604[(15)] = inst_16281);

(statearr_16604[(21)] = inst_16280);

return statearr_16604;
})();
var statearr_16605_16793 = state_16565__$1;
(statearr_16605_16793[(2)] = null);

(statearr_16605_16793[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (95))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16477 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16478 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,5,inst_16477,null);
var inst_16479 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16478,null);
var inst_16480 = inst_16479.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16480)){
var statearr_16606_16794 = state_16565__$1;
(statearr_16606_16794[(1)] = (96));

} else {
var statearr_16607_16795 = state_16565__$1;
(statearr_16607_16795[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (54))){
var inst_16382 = (state_16565[(22)]);
var state_16565__$1 = state_16565;
var statearr_16608_16796 = state_16565__$1;
(statearr_16608_16796[(2)] = inst_16382);

(statearr_16608_16796[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (92))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16609_16797 = state_16565__$1;
(statearr_16609_16797[(2)] = inst_16412);

(statearr_16609_16797[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (104))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16610_16798 = state_16565__$1;
(statearr_16610_16798[(2)] = inst_16412);

(statearr_16610_16798[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (15))){
var inst_16301 = (state_16565[(23)]);
var state_16565__$1 = state_16565;
var statearr_16611_16799 = state_16565__$1;
(statearr_16611_16799[(2)] = inst_16301);

(statearr_16611_16799[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (48))){
var inst_16375 = (state_16565[(19)]);
var state_16565__$1 = state_16565;
var statearr_16612_16800 = state_16565__$1;
(statearr_16612_16800[(2)] = inst_16375);

(statearr_16612_16800[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (50))){
var inst_16382 = (state_16565[(22)]);
var inst_16293 = (state_16565[(11)]);
var inst_16380 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16381 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16380);
var inst_16382__$1 = inst_16381 === true;
var state_16565__$1 = (function (){var statearr_16613 = state_16565;
(statearr_16613[(22)] = inst_16382__$1);

return statearr_16613;
})();
if(cljs.core.truth_(inst_16382__$1)){
var statearr_16614_16801 = state_16565__$1;
(statearr_16614_16801[(1)] = (53));

} else {
var statearr_16615_16802 = state_16565__$1;
(statearr_16615_16802[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (116))){
var inst_16536 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16616_16803 = state_16565__$1;
(statearr_16616_16803[(2)] = inst_16536);

(statearr_16616_16803[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (75))){
var inst_16425 = (state_16565[(9)]);
var state_16565__$1 = state_16565;
var G__16617_16804 = inst_16425;
var G__16617_16805__$1 = (((G__16617_16804 instanceof cljs.core.Keyword))?G__16617_16804.fqn:null);
switch (G__16617_16805__$1) {
case "long":
var statearr_16618_16807 = state_16565__$1;
(statearr_16618_16807[(1)] = (79));


break;
case "bigint":
var statearr_16619_16808 = state_16565__$1;
(statearr_16619_16808[(1)] = (83));


break;
case "double":
var statearr_16620_16809 = state_16565__$1;
(statearr_16620_16809[(1)] = (87));


break;
case "float":
var statearr_16621_16810 = state_16565__$1;
(statearr_16621_16810[(1)] = (91));


break;
case "bigdec":
var statearr_16622_16811 = state_16565__$1;
(statearr_16622_16811[(1)] = (95));


break;
case "string":
var statearr_16623_16812 = state_16565__$1;
(statearr_16623_16812[(1)] = (99));


break;
case "instant":
var statearr_16624_16813 = state_16565__$1;
(statearr_16624_16813[(1)] = (103));


break;
default:
var statearr_16625_16814 = state_16565__$1;
(statearr_16625_16814[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (99))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16487 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_16488 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,5,inst_16487,null);
var inst_16489 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16488,null);
var inst_16490 = inst_16489.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16490)){
var statearr_16626_16815 = state_16565__$1;
(statearr_16626_16815[(1)] = (100));

} else {
var statearr_16627_16816 = state_16565__$1;
(statearr_16627_16816[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (21))){
var inst_16317 = (state_16565[(24)]);
var state_16565__$1 = state_16565;
var statearr_16628_16817 = state_16565__$1;
(statearr_16628_16817[(2)] = inst_16317);

(statearr_16628_16817[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (31))){
var inst_16333 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16629_16818 = state_16565__$1;
(statearr_16629_16818[(2)] = inst_16333);

(statearr_16629_16818[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (113))){
var inst_16539 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16630_16819 = state_16565__$1;
(statearr_16630_16819[(2)] = inst_16539);

(statearr_16630_16819[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (32))){
var state_16565__$1 = state_16565;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16631_16820 = state_16565__$1;
(statearr_16631_16820[(1)] = (35));

} else {
var statearr_16632_16821 = state_16565__$1;
(statearr_16632_16821[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (40))){
var inst_16369 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16369)){
var statearr_16633_16822 = state_16565__$1;
(statearr_16633_16822[(1)] = (44));

} else {
var statearr_16634_16823 = state_16565__$1;
(statearr_16634_16823[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (91))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16467 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16468 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,3,inst_16467,null);
var inst_16469 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16468,null);
var inst_16470 = inst_16469.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16470)){
var statearr_16635_16824 = state_16565__$1;
(statearr_16635_16824[(1)] = (92));

} else {
var statearr_16636_16825 = state_16565__$1;
(statearr_16636_16825[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (117))){
var state_16565__$1 = state_16565;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16637_16826 = state_16565__$1;
(statearr_16637_16826[(1)] = (120));

} else {
var statearr_16638_16827 = state_16565__$1;
(statearr_16638_16827[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (108))){
var inst_16524 = (state_16565[(25)]);
var inst_16293 = (state_16565[(11)]);
var inst_16524__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16639 = state_16565;
(statearr_16639[(25)] = inst_16524__$1);

return statearr_16639;
})();
if(cljs.core.truth_(inst_16524__$1)){
var statearr_16640_16828 = state_16565__$1;
(statearr_16640_16828[(1)] = (111));

} else {
var statearr_16641_16829 = state_16565__$1;
(statearr_16641_16829[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (56))){
var inst_16386 = (state_16565[(2)]);
var inst_16387 = fluree.db.util.async.throw_err.call(null,inst_16386);
var inst_16388 = cljs.core.not.call(null,inst_16387);
var state_16565__$1 = state_16565;
var statearr_16642_16830 = state_16565__$1;
(statearr_16642_16830[(2)] = inst_16388);

(statearr_16642_16830[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (33))){
var inst_16316 = (state_16565[(26)]);
var state_16565__$1 = state_16565;
var statearr_16643_16831 = state_16565__$1;
(statearr_16643_16831[(2)] = inst_16316);

(statearr_16643_16831[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (13))){
var inst_16311 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16311)){
var statearr_16644_16832 = state_16565__$1;
(statearr_16644_16832[(1)] = (17));

} else {
var statearr_16645_16833 = state_16565__$1;
(statearr_16645_16833[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (22))){
var inst_16342 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16342)){
var statearr_16646_16834 = state_16565__$1;
(statearr_16646_16834[(1)] = (32));

} else {
var statearr_16647_16835 = state_16565__$1;
(statearr_16647_16835[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (90))){
var inst_16465 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16648_16836 = state_16565__$1;
(statearr_16648_16836[(2)] = inst_16465);

(statearr_16648_16836[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (109))){
var inst_16522 = (state_16565[(27)]);
var state_16565__$1 = state_16565;
var statearr_16649_16837 = state_16565__$1;
(statearr_16649_16837[(2)] = inst_16522);

(statearr_16649_16837[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (36))){
var inst_16316 = (state_16565[(26)]);
var state_16565__$1 = state_16565;
var statearr_16650_16838 = state_16565__$1;
(statearr_16650_16838[(2)] = inst_16316);

(statearr_16650_16838[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (41))){
var inst_16293 = (state_16565[(11)]);
var inst_16361 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16362 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16361);
var inst_16363 = inst_16362 === true;
var state_16565__$1 = state_16565;
var statearr_16651_16839 = state_16565__$1;
(statearr_16651_16839[(2)] = inst_16363);

(statearr_16651_16839[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (118))){
var inst_16520 = (state_16565[(7)]);
var state_16565__$1 = state_16565;
var statearr_16652_16840 = state_16565__$1;
(statearr_16652_16840[(2)] = inst_16520);

(statearr_16652_16840[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (89))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16463 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16653_16841 = state_16565__$1;
(statearr_16653_16841[(2)] = inst_16463);

(statearr_16653_16841[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (100))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16654_16842 = state_16565__$1;
(statearr_16654_16842[(2)] = inst_16412);

(statearr_16654_16842[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (122))){
var inst_16552 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16655_16843 = state_16565__$1;
(statearr_16655_16843[(2)] = inst_16552);

(statearr_16655_16843[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (43))){
var inst_16366 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16656_16844 = state_16565__$1;
(statearr_16656_16844[(2)] = inst_16366);

(statearr_16656_16844[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (61))){
var inst_16374 = (state_16565[(14)]);
var state_16565__$1 = state_16565;
var statearr_16657_16845 = state_16565__$1;
(statearr_16657_16845[(2)] = inst_16374);

(statearr_16657_16845[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (29))){
var inst_16293 = (state_16565[(11)]);
var inst_16328 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16329 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16328);
var inst_16330 = inst_16329 === true;
var state_16565__$1 = state_16565;
var statearr_16658_16846 = state_16565__$1;
(statearr_16658_16846[(2)] = inst_16330);

(statearr_16658_16846[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (44))){
var inst_16355 = (state_16565[(28)]);
var inst_16371 = fluree.db.query.schema.type_error.call(null,inst_16355,"a component","a non-component",throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16659_16847 = state_16565__$1;
(statearr_16659_16847[(2)] = inst_16371);

(statearr_16659_16847[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (93))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16473 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16660_16848 = state_16565__$1;
(statearr_16660_16848[(2)] = inst_16473);

(statearr_16660_16848[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (6))){
var inst_16280 = (state_16565[(21)]);
var inst_16292 = (state_16565[(16)]);
var inst_16289 = cljs.core.seq.call(null,inst_16280);
var inst_16290 = cljs.core.first.call(null,inst_16289);
var inst_16291 = cljs.core.next.call(null,inst_16289);
var inst_16292__$1 = cljs.core.nth.call(null,inst_16290,(0),null);
var inst_16293 = cljs.core.nth.call(null,inst_16290,(1),null);
var inst_16294 = cljs.core.not.call(null,inst_16292__$1);
var state_16565__$1 = (function (){var statearr_16661 = state_16565;
(statearr_16661[(20)] = inst_16291);

(statearr_16661[(16)] = inst_16292__$1);

(statearr_16661[(11)] = inst_16293);

return statearr_16661;
})();
if(inst_16294){
var statearr_16662_16849 = state_16565__$1;
(statearr_16662_16849[(1)] = (8));

} else {
var statearr_16663_16850 = state_16565__$1;
(statearr_16663_16850[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (111))){
var inst_16528 = (state_16565[(29)]);
var inst_16293 = (state_16565[(11)]);
var inst_16526 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16527 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16526);
var inst_16528__$1 = inst_16527 === true;
var state_16565__$1 = (function (){var statearr_16664 = state_16565;
(statearr_16664[(29)] = inst_16528__$1);

return statearr_16664;
})();
if(cljs.core.truth_(inst_16528__$1)){
var statearr_16665_16851 = state_16565__$1;
(statearr_16665_16851[(1)] = (114));

} else {
var statearr_16666_16852 = state_16565__$1;
(statearr_16666_16852[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (28))){
var inst_16336 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16667_16853 = state_16565__$1;
(statearr_16667_16853[(2)] = inst_16336);

(statearr_16667_16853[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (64))){
var inst_16413 = (state_16565[(10)]);
var state_16565__$1 = state_16565;
var statearr_16668_16854 = state_16565__$1;
(statearr_16668_16854[(2)] = inst_16413);

(statearr_16668_16854[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (103))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16497 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16498 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,2,inst_16497,null);
var inst_16499 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16498,null);
var inst_16500 = inst_16499.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16500)){
var statearr_16669_16855 = state_16565__$1;
(statearr_16669_16855[(1)] = (104));

} else {
var statearr_16670_16856 = state_16565__$1;
(statearr_16670_16856[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (51))){
var inst_16378 = (state_16565[(30)]);
var state_16565__$1 = state_16565;
var statearr_16671_16857 = state_16565__$1;
(statearr_16671_16857[(2)] = inst_16378);

(statearr_16671_16857[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (25))){
var inst_16339 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16672_16858 = state_16565__$1;
(statearr_16672_16858[(2)] = inst_16339);

(statearr_16672_16858[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (34))){
var inst_16356 = (state_16565[(18)]);
var inst_16293 = (state_16565[(11)]);
var inst_16355 = (state_16565[(2)]);
var inst_16356__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16673 = state_16565;
(statearr_16673[(28)] = inst_16355);

(statearr_16673[(18)] = inst_16356__$1);

return statearr_16673;
})();
if(cljs.core.truth_(inst_16356__$1)){
var statearr_16674_16859 = state_16565__$1;
(statearr_16674_16859[(1)] = (38));

} else {
var statearr_16675_16860 = state_16565__$1;
(statearr_16675_16860[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (17))){
var inst_16281 = (state_16565[(15)]);
var inst_16313 = fluree.db.query.schema.type_error.call(null,inst_16281,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16676_16861 = state_16565__$1;
(statearr_16676_16861[(2)] = inst_16313);

(statearr_16676_16861[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (3))){
var inst_16563 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16565__$1,inst_16563);
} else {
if((state_val_16566 === (12))){
var inst_16297 = (state_16565[(31)]);
var state_16565__$1 = state_16565;
var statearr_16677_16862 = state_16565__$1;
(statearr_16677_16862[(2)] = inst_16297);

(statearr_16677_16862[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (2))){
var _ = (function (){var statearr_16678 = state_16565;
(statearr_16678[(4)] = cljs.core.cons.call(null,(5),(state_16565[(4)])));

return statearr_16678;
})();
var inst_16273 = pred_changes;
var inst_16274 = cljs.core.seq.call(null,inst_16273);
var inst_16275 = cljs.core.first.call(null,inst_16274);
var inst_16276 = cljs.core.next.call(null,inst_16274);
var inst_16277 = cljs.core.nth.call(null,inst_16275,(0),null);
var inst_16278 = cljs.core.nth.call(null,inst_16275,(1),null);
var inst_16279 = db;
var inst_16280 = inst_16273;
var inst_16281 = inst_16279;
var state_16565__$1 = (function (){var statearr_16679 = state_16565;
(statearr_16679[(32)] = inst_16276);

(statearr_16679[(15)] = inst_16281);

(statearr_16679[(21)] = inst_16280);

(statearr_16679[(33)] = inst_16278);

(statearr_16679[(34)] = inst_16277);

return statearr_16679;
})();
var statearr_16680_16863 = state_16565__$1;
(statearr_16680_16863[(2)] = null);

(statearr_16680_16863[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (66))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16293 = (state_16565[(11)]);
var inst_16422 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16423 = cljs.core.__destructure_map.call(null,inst_16422);
var inst_16424__$1 = cljs.core.get.call(null,inst_16423,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_16425__$1 = cljs.core.get.call(null,inst_16423,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_16426 = cljs.core._EQ_.call(null,inst_16425__$1,inst_16424__$1);
var state_16565__$1 = (function (){var statearr_16681 = state_16565;
(statearr_16681[(8)] = inst_16424__$1);

(statearr_16681[(9)] = inst_16425__$1);

return statearr_16681;
})();
if(inst_16426){
var statearr_16682_16864 = state_16565__$1;
(statearr_16682_16864[(1)] = (69));

} else {
var statearr_16683_16865 = state_16565__$1;
(statearr_16683_16865[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (107))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16507 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16684_16866 = state_16565__$1;
(statearr_16684_16866[(2)] = inst_16507);

(statearr_16684_16866[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (23))){
var inst_16322 = (state_16565[(17)]);
var inst_16293 = (state_16565[(11)]);
var inst_16321 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16322__$1 = inst_16321 === true;
var state_16565__$1 = (function (){var statearr_16685 = state_16565;
(statearr_16685[(17)] = inst_16322__$1);

return statearr_16685;
})();
if(cljs.core.truth_(inst_16322__$1)){
var statearr_16686_16867 = state_16565__$1;
(statearr_16686_16867[(1)] = (26));

} else {
var statearr_16687_16868 = state_16565__$1;
(statearr_16687_16868[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (47))){
var inst_16378 = (state_16565[(30)]);
var inst_16293 = (state_16565[(11)]);
var inst_16377 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16378__$1 = cljs.core.not.call(null,inst_16377);
var state_16565__$1 = (function (){var statearr_16688 = state_16565;
(statearr_16688[(30)] = inst_16378__$1);

return statearr_16688;
})();
if(inst_16378__$1){
var statearr_16689_16869 = state_16565__$1;
(statearr_16689_16869[(1)] = (50));

} else {
var statearr_16690_16870 = state_16565__$1;
(statearr_16690_16870[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (35))){
var inst_16345 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16346 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16347 = cljs.core.PersistentHashMap.fromArrays(inst_16345,inst_16346);
var inst_16348 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_16347);
var inst_16349 = (function(){throw inst_16348})();
var state_16565__$1 = state_16565;
var statearr_16691_16871 = state_16565__$1;
(statearr_16691_16871[(2)] = inst_16349);

(statearr_16691_16871[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (82))){
var inst_16445 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16692_16872 = state_16565__$1;
(statearr_16692_16872[(2)] = inst_16445);

(statearr_16692_16872[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (76))){
var state_16565__$1 = state_16565;
var statearr_16693_16873 = state_16565__$1;
(statearr_16693_16873[(2)] = null);

(statearr_16693_16873[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (97))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16483 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16694_16874 = state_16565__$1;
(statearr_16694_16874[(2)] = inst_16483);

(statearr_16694_16874[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (19))){
var inst_16317 = (state_16565[(24)]);
var inst_16293 = (state_16565[(11)]);
var inst_16316 = (state_16565[(2)]);
var inst_16317__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16695 = state_16565;
(statearr_16695[(24)] = inst_16317__$1);

(statearr_16695[(26)] = inst_16316);

return statearr_16695;
})();
if(cljs.core.truth_(inst_16317__$1)){
var statearr_16696_16875 = state_16565__$1;
(statearr_16696_16875[(1)] = (20));

} else {
var statearr_16697_16876 = state_16565__$1;
(statearr_16697_16876[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (57))){
var state_16565__$1 = state_16565;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_16698_16877 = state_16565__$1;
(statearr_16698_16877[(1)] = (60));

} else {
var statearr_16699_16878 = state_16565__$1;
(statearr_16699_16878[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (68))){
var inst_16293 = (state_16565[(11)]);
var inst_16522 = (state_16565[(27)]);
var inst_16520 = (state_16565[(2)]);
var inst_16521 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16522__$1 = inst_16521 === true;
var state_16565__$1 = (function (){var statearr_16700 = state_16565;
(statearr_16700[(7)] = inst_16520);

(statearr_16700[(27)] = inst_16522__$1);

return statearr_16700;
})();
if(cljs.core.truth_(inst_16522__$1)){
var statearr_16701_16879 = state_16565__$1;
(statearr_16701_16879[(1)] = (108));

} else {
var statearr_16702_16880 = state_16565__$1;
(statearr_16702_16880[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (11))){
var inst_16301 = (state_16565[(23)]);
var inst_16293 = (state_16565[(11)]);
var inst_16299 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16300 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16299);
var inst_16301__$1 = inst_16300 === false;
var state_16565__$1 = (function (){var statearr_16703 = state_16565;
(statearr_16703[(23)] = inst_16301__$1);

return statearr_16703;
})();
if(cljs.core.truth_(inst_16301__$1)){
var statearr_16704_16881 = state_16565__$1;
(statearr_16704_16881[(1)] = (14));

} else {
var statearr_16705_16882 = state_16565__$1;
(statearr_16705_16882[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (115))){
var inst_16528 = (state_16565[(29)]);
var state_16565__$1 = state_16565;
var statearr_16707_16883 = state_16565__$1;
(statearr_16707_16883[(2)] = inst_16528);

(statearr_16707_16883[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (9))){
var inst_16297 = (state_16565[(31)]);
var inst_16293 = (state_16565[(11)]);
var inst_16297__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16293);
var state_16565__$1 = (function (){var statearr_16708 = state_16565;
(statearr_16708[(31)] = inst_16297__$1);

return statearr_16708;
})();
if(cljs.core.truth_(inst_16297__$1)){
var statearr_16709_16884 = state_16565__$1;
(statearr_16709_16884[(1)] = (11));

} else {
var statearr_16710_16885 = state_16565__$1;
(statearr_16710_16885[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (5))){
var _ = (function (){var statearr_16711 = state_16565;
(statearr_16711[(4)] = cljs.core.rest.call(null,(state_16565[(4)])));

return statearr_16711;
})();
var state_16565__$1 = state_16565;
var ex16706 = (state_16565__$1[(2)]);
var statearr_16712_16886 = state_16565__$1;
(statearr_16712_16886[(5)] = ex16706);


if((ex16706 instanceof Error)){
var statearr_16713_16887 = state_16565__$1;
(statearr_16713_16887[(1)] = (4));

(statearr_16713_16887[(5)] = null);

} else {
throw ex16706;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (112))){
var inst_16524 = (state_16565[(25)]);
var state_16565__$1 = state_16565;
var statearr_16714_16888 = state_16565__$1;
(statearr_16714_16888[(2)] = inst_16524);

(statearr_16714_16888[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (83))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16447 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16448 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,3,inst_16447,null);
var inst_16449 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16448,null);
var inst_16450 = inst_16449.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16450)){
var statearr_16715_16889 = state_16565__$1;
(statearr_16715_16889[(1)] = (84));

} else {
var statearr_16716_16890 = state_16565__$1;
(statearr_16716_16890[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (14))){
var inst_16293 = (state_16565[(11)]);
var inst_16303 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16304 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16303);
var inst_16305 = inst_16304 === true;
var state_16565__$1 = state_16565;
var statearr_16717_16891 = state_16565__$1;
(statearr_16717_16891[(2)] = inst_16305);

(statearr_16717_16891[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (45))){
var inst_16355 = (state_16565[(28)]);
var state_16565__$1 = state_16565;
var statearr_16718_16892 = state_16565__$1;
(statearr_16718_16892[(2)] = inst_16355);

(statearr_16718_16892[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (53))){
var inst_16281 = (state_16565[(15)]);
var inst_16292 = (state_16565[(16)]);
var inst_16384 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_16281,inst_16292);
var state_16565__$1 = state_16565;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16565__$1,(56),inst_16384);
} else {
if((state_val_16566 === (78))){
var inst_16510 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16719_16893 = state_16565__$1;
(statearr_16719_16893[(2)] = inst_16510);

(statearr_16719_16893[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (26))){
var inst_16326 = (state_16565[(35)]);
var inst_16293 = (state_16565[(11)]);
var inst_16324 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16325 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16324);
var inst_16326__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_16325);
var state_16565__$1 = (function (){var statearr_16720 = state_16565;
(statearr_16720[(35)] = inst_16326__$1);

return statearr_16720;
})();
if(inst_16326__$1){
var statearr_16721_16894 = state_16565__$1;
(statearr_16721_16894[(1)] = (29));

} else {
var statearr_16722_16895 = state_16565__$1;
(statearr_16722_16895[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (16))){
var inst_16308 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16723_16896 = state_16565__$1;
(statearr_16723_16896[(2)] = inst_16308);

(statearr_16723_16896[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (81))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16443 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16724_16897 = state_16565__$1;
(statearr_16724_16897[(2)] = inst_16443);

(statearr_16724_16897[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (120))){
var inst_16545 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16546 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_16547 = cljs.core.PersistentHashMap.fromArrays(inst_16545,inst_16546);
var inst_16548 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_16547);
var inst_16549 = (function(){throw inst_16548})();
var state_16565__$1 = state_16565;
var statearr_16725_16898 = state_16565__$1;
(statearr_16725_16898[(2)] = inst_16549);

(statearr_16725_16898[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (79))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16437 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_16438 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,2,inst_16437,null);
var inst_16439 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16438,null);
var inst_16440 = inst_16439.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16440)){
var statearr_16726_16899 = state_16565__$1;
(statearr_16726_16899[(1)] = (80));

} else {
var statearr_16727_16900 = state_16565__$1;
(statearr_16727_16900[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (38))){
var inst_16359 = (state_16565[(36)]);
var inst_16293 = (state_16565[(11)]);
var inst_16358 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16359__$1 = cljs.core.not.call(null,inst_16358);
var state_16565__$1 = (function (){var statearr_16728 = state_16565;
(statearr_16728[(36)] = inst_16359__$1);

return statearr_16728;
})();
if(inst_16359__$1){
var statearr_16729_16901 = state_16565__$1;
(statearr_16729_16901[(1)] = (41));

} else {
var statearr_16730_16902 = state_16565__$1;
(statearr_16730_16902[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (98))){
var inst_16485 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16731_16903 = state_16565__$1;
(statearr_16731_16903[(2)] = inst_16485);

(statearr_16731_16903[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (87))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16457 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_16458 = inst_16425.call(null,cljs.core.PersistentArrayMap,null,3,inst_16457,null);
var inst_16459 = inst_16425.call(null,cljs.core.PersistentHashSet,null,inst_16458,null);
var inst_16460 = inst_16459.call(null,inst_16424);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16460)){
var statearr_16732_16904 = state_16565__$1;
(statearr_16732_16904[(1)] = (88));

} else {
var statearr_16733_16905 = state_16565__$1;
(statearr_16733_16905[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (30))){
var inst_16326 = (state_16565[(35)]);
var state_16565__$1 = state_16565;
var statearr_16734_16906 = state_16565__$1;
(statearr_16734_16906[(2)] = inst_16326);

(statearr_16734_16906[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (73))){
var state_16565__$1 = state_16565;
var statearr_16735_16907 = state_16565__$1;
(statearr_16735_16907[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (96))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16737_16908 = state_16565__$1;
(statearr_16737_16908[(2)] = inst_16412);

(statearr_16737_16908[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (10))){
var inst_16558 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16738_16909 = state_16565__$1;
(statearr_16738_16909[(2)] = inst_16558);

(statearr_16738_16909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (18))){
var inst_16281 = (state_16565[(15)]);
var state_16565__$1 = state_16565;
var statearr_16739_16910 = state_16565__$1;
(statearr_16739_16910[(2)] = inst_16281);

(statearr_16739_16910[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (105))){
var inst_16424 = (state_16565[(8)]);
var inst_16425 = (state_16565[(9)]);
var inst_16503 = fluree.db.query.schema.type_error.call(null,inst_16424,inst_16425,throw_QMARK_);
var state_16565__$1 = state_16565;
var statearr_16740_16911 = state_16565__$1;
(statearr_16740_16911[(2)] = inst_16503);

(statearr_16740_16911[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (52))){
var inst_16394 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16741_16912 = state_16565__$1;
(statearr_16741_16912[(2)] = inst_16394);

(statearr_16741_16912[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (114))){
var inst_16293 = (state_16565[(11)]);
var inst_16530 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16531 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_16530);
var inst_16532 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_16531);
var inst_16533 = (!(inst_16532));
var state_16565__$1 = state_16565;
var statearr_16742_16913 = state_16565__$1;
(statearr_16742_16913[(2)] = inst_16533);

(statearr_16742_16913[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (67))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16743_16914 = state_16565__$1;
(statearr_16743_16914[(2)] = inst_16412);

(statearr_16743_16914[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (71))){
var inst_16517 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16744_16915 = state_16565__$1;
(statearr_16744_16915[(2)] = inst_16517);

(statearr_16744_16915[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (42))){
var inst_16359 = (state_16565[(36)]);
var state_16565__$1 = state_16565;
var statearr_16745_16916 = state_16565__$1;
(statearr_16745_16916[(2)] = inst_16359);

(statearr_16745_16916[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (80))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16746_16917 = state_16565__$1;
(statearr_16746_16917[(2)] = inst_16412);

(statearr_16746_16917[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (37))){
var inst_16352 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16747_16918 = state_16565__$1;
(statearr_16747_16918[(2)] = inst_16352);

(statearr_16747_16918[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (63))){
var inst_16293 = (state_16565[(11)]);
var inst_16415 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_16293);
var inst_16416 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_16415);
var state_16565__$1 = state_16565;
var statearr_16748_16919 = state_16565__$1;
(statearr_16748_16919[(2)] = inst_16416);

(statearr_16748_16919[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (94))){
var inst_16475 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
var statearr_16749_16920 = state_16565__$1;
(statearr_16749_16920[(2)] = inst_16475);

(statearr_16749_16920[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (8))){
var inst_16281 = (state_16565[(15)]);
var state_16565__$1 = state_16565;
var statearr_16750_16921 = state_16565__$1;
(statearr_16750_16921[(2)] = inst_16281);

(statearr_16750_16921[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (49))){
var inst_16397 = (state_16565[(2)]);
var state_16565__$1 = state_16565;
if(cljs.core.truth_(inst_16397)){
var statearr_16751_16922 = state_16565__$1;
(statearr_16751_16922[(1)] = (57));

} else {
var statearr_16752_16923 = state_16565__$1;
(statearr_16752_16923[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16566 === (84))){
var inst_16412 = (state_16565[(12)]);
var state_16565__$1 = state_16565;
var statearr_16753_16924 = state_16565__$1;
(statearr_16753_16924[(2)] = inst_16412);

(statearr_16753_16924[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16754 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16754[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16754[(1)] = (1));

return statearr_16754;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16565){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16755){var ex__2749__auto__ = e16755;
var statearr_16756_16925 = state_16565;
(statearr_16756_16925[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16565[(4)]))){
var statearr_16757_16926 = state_16565;
(statearr_16757_16926[(1)] = cljs.core.first.call(null,(state_16565[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16927 = state_16565;
state_16565 = G__16927;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16565){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16758 = f__2769__auto__.call(null);
(statearr_16758[(6)] = c__2768__auto__);

return statearr_16758;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__16929 = arguments.length;
switch (G__16929) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_16953){
var state_val_16954 = (state_16953[(1)]);
if((state_val_16954 === (7))){
var state_16953__$1 = state_16953;
var statearr_16955_16975 = state_16953__$1;
(statearr_16955_16975[(2)] = db);

(statearr_16955_16975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (1))){
var state_16953__$1 = state_16953;
var statearr_16956_16976 = state_16953__$1;
(statearr_16956_16976[(2)] = null);

(statearr_16956_16976[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (4))){
var inst_16930 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
var statearr_16957_16977 = state_16953__$1;
(statearr_16957_16977[(2)] = inst_16930);

(statearr_16957_16977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (6))){
var inst_16939 = (state_16953[(7)]);
var inst_16938 = (state_16953[(2)]);
var inst_16939__$1 = fluree.db.util.async.throw_err.call(null,inst_16938);
var inst_16940 = cljs.core.empty_QMARK_.call(null,inst_16939__$1);
var state_16953__$1 = (function (){var statearr_16958 = state_16953;
(statearr_16958[(7)] = inst_16939__$1);

return statearr_16958;
})();
if(inst_16940){
var statearr_16959_16978 = state_16953__$1;
(statearr_16959_16978[(1)] = (7));

} else {
var statearr_16960_16979 = state_16953__$1;
(statearr_16960_16979[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (3))){
var inst_16951 = (state_16953[(2)]);
var state_16953__$1 = state_16953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16953__$1,inst_16951);
} else {
if((state_val_16954 === (2))){
var _ = (function (){var statearr_16962 = state_16953;
(statearr_16962[(4)] = cljs.core.cons.call(null,(5),(state_16953[(4)])));

return statearr_16962;
})();
var inst_16936 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_16953__$1 = state_16953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16953__$1,(6),inst_16936);
} else {
if((state_val_16954 === (9))){
var inst_16948 = (state_16953[(2)]);
var _ = (function (){var statearr_16963 = state_16953;
(statearr_16963[(4)] = cljs.core.rest.call(null,(state_16953[(4)])));

return statearr_16963;
})();
var state_16953__$1 = state_16953;
var statearr_16964_16980 = state_16953__$1;
(statearr_16964_16980[(2)] = inst_16948);

(statearr_16964_16980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (5))){
var _ = (function (){var statearr_16965 = state_16953;
(statearr_16965[(4)] = cljs.core.rest.call(null,(state_16953[(4)])));

return statearr_16965;
})();
var state_16953__$1 = state_16953;
var ex16961 = (state_16953__$1[(2)]);
var statearr_16966_16981 = state_16953__$1;
(statearr_16966_16981[(5)] = ex16961);


if((ex16961 instanceof Error)){
var statearr_16967_16982 = state_16953__$1;
(statearr_16967_16982[(1)] = (4));

(statearr_16967_16982[(5)] = null);

} else {
throw ex16961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (10))){
var inst_16945 = (state_16953[(2)]);
var inst_16946 = fluree.db.util.async.throw_err.call(null,inst_16945);
var state_16953__$1 = state_16953;
var statearr_16968_16983 = state_16953__$1;
(statearr_16968_16983[(2)] = inst_16946);

(statearr_16968_16983[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16954 === (8))){
var inst_16939 = (state_16953[(7)]);
var inst_16943 = fluree.db.query.schema.predicate_change_error.call(null,inst_16939,db,true);
var state_16953__$1 = state_16953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16953__$1,(10),inst_16943);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2746__auto__ = null;
var fluree$db$query$schema$state_machine__2746__auto____0 = (function (){
var statearr_16969 = [null,null,null,null,null,null,null,null];
(statearr_16969[(0)] = fluree$db$query$schema$state_machine__2746__auto__);

(statearr_16969[(1)] = (1));

return statearr_16969;
});
var fluree$db$query$schema$state_machine__2746__auto____1 = (function (state_16953){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_16953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e16970){var ex__2749__auto__ = e16970;
var statearr_16971_16984 = state_16953;
(statearr_16971_16984[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_16953[(4)]))){
var statearr_16972_16985 = state_16953;
(statearr_16972_16985[(1)] = cljs.core.first.call(null,(state_16953[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16986 = state_16953;
state_16953 = G__16986;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2746__auto__ = function(state_16953){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2746__auto____1.call(this,state_16953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2746__auto____0;
fluree$db$query$schema$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2746__auto____1;
return fluree$db$query$schema$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_16973 = f__2769__auto__.call(null);
(statearr_16973[(6)] = c__2768__auto__);

return statearr_16973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__16988 = arguments.length;
switch (G__16988) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__16990 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__16990,(0),null);
var ns = cljs.core.nth.call(null,vec__16990,(1),null);
var name = cljs.core.nth.call(null,vec__16990,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = fluree.db.flake.p.call(null,flake);
var o = fluree.db.flake.o.call(null,flake);
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__5043__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__5043__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__16993_SHARP_,p2__16994_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16993_SHARP_,p2__16994_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__16995_SHARP_){
var f = p1__16995_SHARP_;
if(cljs.core._EQ_.call(null,spec_pid,fluree.db.flake.p.call(null,f))){
return fluree.db.flake.o.call(null,f);
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17061){
var state_val_17062 = (state_17061[(1)]);
if((state_val_17062 === (1))){
var state_17061__$1 = state_17061;
var statearr_17063_17080 = state_17061__$1;
(statearr_17063_17080[(2)] = null);

(statearr_17063_17080[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17062 === (2))){
var _ = (function (){var statearr_17064 = state_17061;
(statearr_17064[(4)] = cljs.core.cons.call(null,(5),(state_17061[(4)])));

return statearr_17064;
})();
var inst_17013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17014 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_17015 = [inst_17014];
var inst_17016 = (new cljs.core.PersistentVector(null,1,(5),inst_17013,inst_17015,null));
var inst_17017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17018 = [(0)];
var inst_17019 = (new cljs.core.PersistentVector(null,1,(5),inst_17017,inst_17018,null));
var inst_17020 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_17016,cljs.core._LT__EQ_,inst_17019);
var state_17061__$1 = state_17061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17061__$1,(6),inst_17020);
} else {
if((state_val_17062 === (3))){
var inst_17059 = (state_17061[(2)]);
var state_17061__$1 = state_17061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17061__$1,inst_17059);
} else {
if((state_val_17062 === (4))){
var inst_17001 = (state_17061[(2)]);
var state_17061__$1 = state_17061;
var statearr_17066_17081 = state_17061__$1;
(statearr_17066_17081[(2)] = inst_17001);

(statearr_17066_17081[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17062 === (5))){
var _ = (function (){var statearr_17067 = state_17061;
(statearr_17067[(4)] = cljs.core.rest.call(null,(state_17061[(4)])));

return statearr_17067;
})();
var state_17061__$1 = state_17061;
var ex17065 = (state_17061__$1[(2)]);
var statearr_17068_17082 = state_17061__$1;
(statearr_17068_17082[(5)] = ex17065);


if((ex17065 instanceof Error)){
var statearr_17069_17083 = state_17061__$1;
(statearr_17069_17083[(1)] = (4));

(statearr_17069_17083[(5)] = null);

} else {
throw ex17065;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17062 === (6))){
var inst_17022 = (state_17061[(2)]);
var inst_17023 = fluree.db.util.async.throw_err.call(null,inst_17022);
var inst_17024 = (function (){var schema_flakes = inst_17023;
return (function (p1__16996_SHARP_){
return (fluree.db.flake.s.call(null,p1__16996_SHARP_) <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_17025 = cljs.core.partition_by.call(null,inst_17024,inst_17023);
var inst_17026 = cljs.core.nth.call(null,inst_17025,(0),null);
var inst_17027 = cljs.core.nth.call(null,inst_17025,(1),null);
var inst_17028 = (function (){var schema_flakes = inst_17023;
var vec__17007 = inst_17025;
var collection_flakes = inst_17026;
var predicate_flakes = inst_17027;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first.call(null,coll_flakes);
var sid = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__16999_SHARP_,p2__16998_SHARP_){
var f = p2__16998_SHARP_;
return cljs.core.assoc.call(null,p1__16999_SHARP_,fluree.db.flake.p.call(null,f),fluree.db.flake.o.call(null,f));
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__5045__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_17029 = [(-1),"_tx"];
var inst_17030 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17031 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17032 = cljs.core.PersistentHashMap.fromArrays(inst_17030,inst_17031);
var inst_17033 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"partition","partition",1174740751),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692)];
var inst_17034 = ["_tx",(-1),(-1),(-1),null,null];
var inst_17035 = cljs.core.PersistentHashMap.fromArrays(inst_17033,inst_17034);
var inst_17036 = [inst_17032,inst_17035];
var inst_17037 = cljs.core.PersistentHashMap.fromArrays(inst_17029,inst_17036);
var inst_17038 = (function (){var schema_flakes = inst_17023;
var vec__17007 = inst_17025;
var collection_flakes = inst_17026;
var predicate_flakes = inst_17027;
return (function (p1__16997_SHARP_){
return fluree.db.flake.s.call(null,p1__16997_SHARP_);
});
})();
var inst_17039 = cljs.core.partition_by.call(null,inst_17038,inst_17026);
var inst_17040 = cljs.core.reduce.call(null,inst_17028,inst_17037,inst_17039);
var inst_17042 = (function (){var schema_flakes = inst_17023;
var vec__17007 = inst_17025;
var collection_flakes = inst_17026;
var predicate_flakes = inst_17027;
var coll = inst_17040;
return (function (p__17041,pred_flakes){
var vec__17070 = p__17041;
var pred = cljs.core.nth.call(null,vec__17070,(0),null);
var fullText = cljs.core.nth.call(null,vec__17070,(1),null);
var first_flake = cljs.core.first.call(null,pred_flakes);
var id = fluree.db.flake.s.call(null,first_flake);
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = ref_QMARK_;
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_17043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17044 = cljs.core.PersistentHashMap.EMPTY;
var inst_17045 = cljs.core.PersistentHashSet.EMPTY;
var inst_17046 = [inst_17044,inst_17045];
var inst_17047 = (new cljs.core.PersistentVector(null,2,(5),inst_17043,inst_17046,null));
var inst_17048 = (function (){var schema_flakes = inst_17023;
var vec__17007 = inst_17025;
var collection_flakes = inst_17026;
var predicate_flakes = inst_17027;
var coll = inst_17040;
return (function (p1__17000_SHARP_){
return fluree.db.flake.s.call(null,p1__17000_SHARP_);
});
})();
var inst_17049 = cljs.core.partition_by.call(null,inst_17048,inst_17027);
var inst_17050 = cljs.core.reduce.call(null,inst_17042,inst_17047,inst_17049);
var inst_17051 = cljs.core.nth.call(null,inst_17050,(0),null);
var inst_17052 = cljs.core.nth.call(null,inst_17050,(1),null);
var inst_17053 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_17054 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17055 = [inst_17054,inst_17040,inst_17051,inst_17052];
var inst_17056 = cljs.core.PersistentHashMap.fromArrays(inst_17053,inst_17055);
var _ = (function (){var statearr_17073 = state_17061;
(statearr_17073[(4)] = cljs.core.rest.call(null,(state_17061[(4)])));

return statearr_17073;
})();
var state_17061__$1 = state_17061;
var statearr_17074_17084 = state_17061__$1;
(statearr_17074_17084[(2)] = inst_17056);

(statearr_17074_17084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0 = (function (){
var statearr_17075 = [null,null,null,null,null,null,null];
(statearr_17075[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2746__auto__);

(statearr_17075[(1)] = (1));

return statearr_17075;
});
var fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1 = (function (state_17061){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17076){var ex__2749__auto__ = e17076;
var statearr_17077_17085 = state_17061;
(statearr_17077_17085[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17061[(4)]))){
var statearr_17078_17086 = state_17061;
(statearr_17078_17086[(1)] = cljs.core.first.call(null,(state_17061[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17087 = state_17061;
state_17061 = G__17087;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__ = function(state_17061){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1.call(this,state_17061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17079 = f__2769__auto__.call(null);
(statearr_17079[(6)] = c__2768__auto__);

return statearr_17079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_17129){
var state_val_17130 = (state_17129[(1)]);
if((state_val_17130 === (7))){
var inst_17112 = (state_17129[(2)]);
var inst_17113 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_17112);
var inst_17114 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_17115 = cljs.core.get.call(null,inst_17113,(114));
var inst_17116 = cljs.core.boolean$.call(null,inst_17115);
var inst_17117 = cljs.core.get.call(null,inst_17113,(110));
var inst_17118 = cljs.core.get.call(null,inst_17113,(117));
var inst_17119 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_17118);
var inst_17120 = cljs.core.get.call(null,inst_17113,(111));
var inst_17121 = cljs.core.get.call(null,inst_17113,(115));
var inst_17122 = cljs.core.get.call(null,inst_17113,(112));
var inst_17123 = [inst_17116,inst_17117,inst_17119,inst_17120,inst_17121,inst_17122];
var inst_17124 = cljs.core.PersistentHashMap.fromArrays(inst_17114,inst_17123);
var _ = (function (){var statearr_17131 = state_17129;
(statearr_17131[(4)] = cljs.core.rest.call(null,(state_17129[(4)])));

return statearr_17131;
})();
var state_17129__$1 = state_17129;
var statearr_17132_17155 = state_17129__$1;
(statearr_17132_17155[(2)] = inst_17124);

(statearr_17132_17155[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (1))){
var state_17129__$1 = state_17129;
var statearr_17133_17156 = state_17129__$1;
(statearr_17133_17156[(2)] = null);

(statearr_17133_17156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (4))){
var inst_17088 = (state_17129[(2)]);
var state_17129__$1 = state_17129;
var statearr_17134_17157 = state_17129__$1;
(statearr_17134_17157[(2)] = inst_17088);

(statearr_17134_17157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (6))){
var _ = (function (){var statearr_17135 = state_17129;
(statearr_17135[(4)] = cljs.core.cons.call(null,(9),(state_17129[(4)])));

return statearr_17135;
})();
var inst_17100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17102 = ["_setting/id","root"];
var inst_17103 = (new cljs.core.PersistentVector(null,2,(5),inst_17101,inst_17102,null));
var inst_17104 = [inst_17103];
var inst_17105 = (new cljs.core.PersistentVector(null,1,(5),inst_17100,inst_17104,null));
var inst_17106 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17105);
var state_17129__$1 = state_17129;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17129__$1,(10),inst_17106);
} else {
if((state_val_17130 === (3))){
var inst_17127 = (state_17129[(2)]);
var state_17129__$1 = state_17129;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17129__$1,inst_17127);
} else {
if((state_val_17130 === (2))){
var _ = (function (){var statearr_17138 = state_17129;
(statearr_17138[(4)] = cljs.core.cons.call(null,(5),(state_17129[(4)])));

return statearr_17138;
})();
var state_17129__$1 = state_17129;
var statearr_17139_17158 = state_17129__$1;
(statearr_17139_17158[(2)] = null);

(statearr_17139_17158[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (9))){
var _ = (function (){var statearr_17140 = state_17129;
(statearr_17140[(4)] = cljs.core.rest.call(null,(state_17129[(4)])));

return statearr_17140;
})();
var state_17129__$1 = state_17129;
var ex17136 = (state_17129__$1[(2)]);
var statearr_17141_17159 = state_17129__$1;
(statearr_17141_17159[(5)] = ex17136);


var statearr_17142_17160 = state_17129__$1;
(statearr_17142_17160[(1)] = (8));

(statearr_17142_17160[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (5))){
var _ = (function (){var statearr_17143 = state_17129;
(statearr_17143[(4)] = cljs.core.rest.call(null,(state_17129[(4)])));

return statearr_17143;
})();
var state_17129__$1 = state_17129;
var ex17137 = (state_17129__$1[(2)]);
var statearr_17144_17161 = state_17129__$1;
(statearr_17144_17161[(5)] = ex17137);


if((ex17137 instanceof Error)){
var statearr_17145_17162 = state_17129__$1;
(statearr_17145_17162[(1)] = (4));

(statearr_17145_17162[(5)] = null);

} else {
throw ex17137;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (10))){
var inst_17108 = (state_17129[(2)]);
var inst_17109 = fluree.db.util.async.throw_err.call(null,inst_17108);
var _ = (function (){var statearr_17146 = state_17129;
(statearr_17146[(4)] = cljs.core.rest.call(null,(state_17129[(4)])));

return statearr_17146;
})();
var state_17129__$1 = state_17129;
var statearr_17147_17163 = state_17129__$1;
(statearr_17147_17163[(2)] = inst_17109);

(statearr_17147_17163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17130 === (8))){
var inst_17094 = (state_17129[(2)]);
var state_17129__$1 = (function (){var statearr_17148 = state_17129;
(statearr_17148[(7)] = inst_17094);

return statearr_17148;
})();
var statearr_17149_17164 = state_17129__$1;
(statearr_17149_17164[(2)] = null);

(statearr_17149_17164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0 = (function (){
var statearr_17150 = [null,null,null,null,null,null,null,null];
(statearr_17150[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2746__auto__);

(statearr_17150[(1)] = (1));

return statearr_17150;
});
var fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1 = (function (state_17129){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_17129);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e17151){var ex__2749__auto__ = e17151;
var statearr_17152_17165 = state_17129;
(statearr_17152_17165[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_17129[(4)]))){
var statearr_17153_17166 = state_17129;
(statearr_17153_17166[(1)] = cljs.core.first.call(null,(state_17129[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17167 = state_17129;
state_17129 = G__17167;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__ = function(state_17129){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1.call(this,state_17129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2746__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_17154 = f__2769__auto__.call(null);
(statearr_17154[(6)] = c__2768__auto__);

return statearr_17154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
