// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21784 = arguments.length;
switch (G__21784) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol)));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_.call(null,vol,f.call(null,cljs.core._deref.call(null,vol),arg1,arg2,arg3));
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_21945){
var state_val_21946 = (state_21945[(1)]);
if((state_val_21946 === (7))){
var inst_21940 = (state_21945[(2)]);
var _ = (function (){var statearr_21947 = state_21945;
(statearr_21947[(4)] = cljs.core.rest.call(null,(state_21945[(4)])));

return statearr_21947;
})();
var state_21945__$1 = state_21945;
var statearr_21948_22030 = state_21945__$1;
(statearr_21948_22030[(2)] = inst_21940);

(statearr_21948_22030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (20))){
var inst_21867 = (state_21945[(7)]);
var state_21945__$1 = state_21945;
var statearr_21949_22031 = state_21945__$1;
(statearr_21949_22031[(2)] = inst_21867);

(statearr_21949_22031[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (27))){
var inst_21822 = (state_21945[(8)]);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21822)){
var statearr_21950_22032 = state_21945__$1;
(statearr_21950_22032[(1)] = (29));

} else {
var statearr_21951_22033 = state_21945__$1;
(statearr_21951_22033[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (1))){
var state_21945__$1 = state_21945;
var statearr_21952_22034 = state_21945__$1;
(statearr_21952_22034[(2)] = null);

(statearr_21952_22034[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (24))){
var inst_21823 = (state_21945[(9)]);
var state_21945__$1 = state_21945;
var statearr_21953_22035 = state_21945__$1;
(statearr_21953_22035[(2)] = inst_21823);

(statearr_21953_22035[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (39))){
var inst_21859 = (state_21945[(10)]);
var state_21945__$1 = state_21945;
var statearr_21954_22036 = state_21945__$1;
(statearr_21954_22036[(2)] = inst_21859);

(statearr_21954_22036[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (46))){
var inst_21824 = (state_21945[(11)]);
var state_21945__$1 = state_21945;
var statearr_21955_22037 = state_21945__$1;
(statearr_21955_22037[(2)] = inst_21824);

(statearr_21955_22037[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (4))){
var inst_21786 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_21956_22038 = state_21945__$1;
(statearr_21956_22038[(2)] = inst_21786);

(statearr_21956_22038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (15))){
var inst_21835 = (state_21945[(12)]);
var inst_21841 = cljs.core.count.call(null,inst_21835);
var inst_21842 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21841,max_fuel);
var state_21945__$1 = state_21945;
var statearr_21957_22039 = state_21945__$1;
(statearr_21957_22039[(2)] = inst_21842);

(statearr_21957_22039[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (48))){
var inst_21926 = (state_21945[(13)]);
var inst_21811 = (state_21945[(14)]);
var inst_21804 = (state_21945[(15)]);
var inst_21934 = (state_21945[(2)]);
var inst_21935 = cljs.core.assoc.call(null,inst_21804,inst_21934,inst_21926);
var inst_21803 = inst_21811;
var inst_21804__$1 = inst_21935;
var state_21945__$1 = (function (){var statearr_21958 = state_21945;
(statearr_21958[(16)] = inst_21803);

(statearr_21958[(15)] = inst_21804__$1);

return statearr_21958;
})();
var statearr_21959_22040 = state_21945__$1;
(statearr_21959_22040[(2)] = null);

(statearr_21959_22040[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (50))){
var inst_21826 = (state_21945[(17)]);
var state_21945__$1 = state_21945;
var statearr_21960_22041 = state_21945__$1;
(statearr_21960_22041[(2)] = inst_21826);

(statearr_21960_22041[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (21))){
var inst_21823 = (state_21945[(9)]);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21823)){
var statearr_21962_22042 = state_21945__$1;
(statearr_21962_22042[(1)] = (23));

} else {
var statearr_21963_22043 = state_21945__$1;
(statearr_21963_22043[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (31))){
var inst_21883 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21883)){
var statearr_21964_22044 = state_21945__$1;
(statearr_21964_22044[(1)] = (32));

} else {
var statearr_21965_22045 = state_21945__$1;
(statearr_21965_22045[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (32))){
var inst_21866 = (state_21945[(18)]);
var inst_21859 = (state_21945[(10)]);
var inst_21858 = (state_21945[(19)]);
var inst_21885 = (inst_21858 + (1));
var tmp21961 = inst_21859;
var inst_21857 = inst_21866;
var inst_21858__$1 = inst_21885;
var inst_21859__$1 = tmp21961;
var state_21945__$1 = (function (){var statearr_21966 = state_21945;
(statearr_21966[(20)] = inst_21857);

(statearr_21966[(10)] = inst_21859__$1);

(statearr_21966[(19)] = inst_21858__$1);

return statearr_21966;
})();
var statearr_21967_22046 = state_21945__$1;
(statearr_21967_22046[(2)] = null);

(statearr_21967_22046[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (40))){
var state_21945__$1 = state_21945;
if(cljs.core.truth_(fuel)){
var statearr_21968_22047 = state_21945__$1;
(statearr_21968_22047[(1)] = (42));

} else {
var statearr_21969_22048 = state_21945__$1;
(statearr_21969_22048[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (33))){
var state_21945__$1 = state_21945;
var statearr_21970_22049 = state_21945__$1;
(statearr_21970_22049[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (13))){
var inst_21835 = (state_21945[(12)]);
var state_21945__$1 = state_21945;
var statearr_21972_22050 = state_21945__$1;
(statearr_21972_22050[(2)] = inst_21835);

(statearr_21972_22050[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (22))){
var inst_21876 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21876)){
var statearr_21973_22051 = state_21945__$1;
(statearr_21973_22051[(1)] = (26));

} else {
var statearr_21974_22052 = state_21945__$1;
(statearr_21974_22052[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (36))){
var state_21945__$1 = state_21945;
var statearr_21975_22053 = state_21945__$1;
(statearr_21975_22053[(2)] = null);

(statearr_21975_22053[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (41))){
var inst_21866 = (state_21945[(18)]);
var inst_21858 = (state_21945[(19)]);
var inst_21915 = (state_21945[(2)]);
var inst_21916 = (inst_21858 + (1));
var inst_21857 = inst_21866;
var inst_21858__$1 = inst_21916;
var inst_21859 = inst_21915;
var state_21945__$1 = (function (){var statearr_21976 = state_21945;
(statearr_21976[(20)] = inst_21857);

(statearr_21976[(10)] = inst_21859);

(statearr_21976[(19)] = inst_21858__$1);

return statearr_21976;
})();
var statearr_21977_22054 = state_21945__$1;
(statearr_21977_22054[(2)] = null);

(statearr_21977_22054[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (43))){
var state_21945__$1 = state_21945;
var statearr_21978_22055 = state_21945__$1;
(statearr_21978_22055[(2)] = null);

(statearr_21978_22055[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (29))){
var inst_21822 = (state_21945[(8)]);
var inst_21858 = (state_21945[(19)]);
var inst_21880 = (inst_21858 < inst_21822);
var state_21945__$1 = state_21945;
var statearr_21979_22056 = state_21945__$1;
(statearr_21979_22056[(2)] = inst_21880);

(statearr_21979_22056[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (44))){
var inst_21899 = (state_21945[(21)]);
var inst_21895 = (state_21945[(22)]);
var inst_21908 = (state_21945[(2)]);
var inst_21909 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_21899,inst_21895);
var state_21945__$1 = (function (){var statearr_21980 = state_21945;
(statearr_21980[(23)] = inst_21908);

return statearr_21980;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21945__$1,(45),inst_21909);
} else {
if((state_val_21946 === (6))){
var inst_21810 = (state_21945[(24)]);
var inst_21803 = (state_21945[(16)]);
var inst_21809 = cljs.core.seq.call(null,inst_21803);
var inst_21810__$1 = cljs.core.first.call(null,inst_21809);
var inst_21811 = cljs.core.next.call(null,inst_21809);
var inst_21812 = cljs.core.not.call(null,inst_21810__$1);
var state_21945__$1 = (function (){var statearr_21981 = state_21945;
(statearr_21981[(14)] = inst_21811);

(statearr_21981[(24)] = inst_21810__$1);

return statearr_21981;
})();
if(inst_21812){
var statearr_21982_22057 = state_21945__$1;
(statearr_21982_22057[(1)] = (8));

} else {
var statearr_21983_22058 = state_21945__$1;
(statearr_21983_22058[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (28))){
var inst_21924 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_21984_22059 = state_21945__$1;
(statearr_21984_22059[(2)] = inst_21924);

(statearr_21984_22059[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (51))){
var inst_21932 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_21985_22060 = state_21945__$1;
(statearr_21985_22060[(2)] = inst_21932);

(statearr_21985_22060[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (25))){
var inst_21874 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_21986_22061 = state_21945__$1;
(statearr_21986_22061[(2)] = inst_21874);

(statearr_21986_22061[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (34))){
var inst_21922 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_21987_22062 = state_21945__$1;
(statearr_21987_22062[(2)] = inst_21922);

(statearr_21987_22062[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (17))){
var inst_21835 = (state_21945[(12)]);
var inst_21845 = (state_21945[(2)]);
var inst_21853 = cljs.core.seq.call(null,inst_21835);
var inst_21854 = cljs.core.first.call(null,inst_21853);
var inst_21855 = cljs.core.next.call(null,inst_21853);
var inst_21856 = cljs.core.PersistentVector.EMPTY;
var inst_21857 = inst_21835;
var inst_21858 = (0);
var inst_21859 = inst_21856;
var state_21945__$1 = (function (){var statearr_21988 = state_21945;
(statearr_21988[(25)] = inst_21845);

(statearr_21988[(20)] = inst_21857);

(statearr_21988[(26)] = inst_21855);

(statearr_21988[(10)] = inst_21859);

(statearr_21988[(19)] = inst_21858);

(statearr_21988[(27)] = inst_21854);

return statearr_21988;
})();
var statearr_21989_22063 = state_21945__$1;
(statearr_21989_22063[(2)] = null);

(statearr_21989_22063[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (3))){
var inst_21943 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21945__$1,inst_21943);
} else {
if((state_val_21946 === (12))){
var state_21945__$1 = state_21945;
var statearr_21990_22064 = state_21945__$1;
(statearr_21990_22064[(2)] = fuel);

(statearr_21990_22064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (2))){
var _ = (function (){var statearr_21991 = state_21945;
(statearr_21991[(4)] = cljs.core.cons.call(null,(5),(state_21945[(4)])));

return statearr_21991;
})();
var inst_21799 = reverse_refs_specs;
var inst_21800 = cljs.core.seq.call(null,inst_21799);
var inst_21801 = cljs.core.first.call(null,inst_21800);
var inst_21802 = cljs.core.next.call(null,inst_21800);
var inst_21803 = inst_21799;
var inst_21804 = null;
var state_21945__$1 = (function (){var statearr_21992 = state_21945;
(statearr_21992[(28)] = inst_21802);

(statearr_21992[(29)] = inst_21801);

(statearr_21992[(16)] = inst_21803);

(statearr_21992[(15)] = inst_21804);

return statearr_21992;
})();
var statearr_21993_22065 = state_21945__$1;
(statearr_21993_22065[(2)] = null);

(statearr_21993_22065[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (23))){
var inst_21823 = (state_21945[(9)]);
var inst_21858 = (state_21945[(19)]);
var inst_21871 = (inst_21858 >= inst_21823);
var state_21945__$1 = state_21945;
var statearr_21994_22066 = state_21945__$1;
(statearr_21994_22066[(2)] = inst_21871);

(statearr_21994_22066[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (47))){
var inst_21825 = (state_21945[(30)]);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21825)){
var statearr_21995_22067 = state_21945__$1;
(statearr_21995_22067[(1)] = (49));

} else {
var statearr_21996_22068 = state_21945__$1;
(statearr_21996_22068[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (35))){
var inst_21865 = (state_21945[(31)]);
var inst_21889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21890 = [inst_21865];
var inst_21891 = (new cljs.core.PersistentVector(null,1,(5),inst_21889,inst_21890,null));
var inst_21892 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_21891);
var state_21945__$1 = state_21945;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21945__$1,(38),inst_21892);
} else {
if((state_val_21946 === (19))){
var inst_21824 = (state_21945[(11)]);
var inst_21926 = (state_21945[(2)]);
var state_21945__$1 = (function (){var statearr_21997 = state_21945;
(statearr_21997[(13)] = inst_21926);

return statearr_21997;
})();
if(cljs.core.truth_(inst_21824)){
var statearr_21998_22069 = state_21945__$1;
(statearr_21998_22069[(1)] = (46));

} else {
var statearr_21999_22070 = state_21945__$1;
(statearr_21999_22070[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (11))){
var inst_21835 = (state_21945[(12)]);
var inst_21832 = (state_21945[(2)]);
var inst_21833 = fluree.db.util.async.throw_err.call(null,inst_21832);
var inst_21834 = cljs.core.map.call(null,fluree.db.flake.s,inst_21833);
var inst_21835__$1 = cljs.core.not_empty.call(null,inst_21834);
var state_21945__$1 = (function (){var statearr_22001 = state_21945;
(statearr_22001[(12)] = inst_21835__$1);

return statearr_22001;
})();
if(cljs.core.truth_(inst_21835__$1)){
var statearr_22002_22071 = state_21945__$1;
(statearr_22002_22071[(1)] = (12));

} else {
var statearr_22003_22072 = state_21945__$1;
(statearr_22003_22072[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (9))){
var inst_21820 = (state_21945[(32)]);
var inst_21810 = (state_21945[(24)]);
var inst_21819 = cljs.core.nth.call(null,inst_21810,(0),null);
var inst_21820__$1 = cljs.core.nth.call(null,inst_21810,(1),null);
var inst_21821 = cljs.core.__destructure_map.call(null,inst_21820__$1);
var inst_21822 = cljs.core.get.call(null,inst_21821,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21823 = cljs.core.get.call(null,inst_21821,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21824 = cljs.core.get.call(null,inst_21821,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21825 = cljs.core.get.call(null,inst_21821,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21826 = cljs.core.get.call(null,inst_21821,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21828 = [subject_id,inst_21819];
var inst_21829 = (new cljs.core.PersistentVector(null,2,(5),inst_21827,inst_21828,null));
var inst_21830 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21829);
var state_21945__$1 = (function (){var statearr_22004 = state_21945;
(statearr_22004[(8)] = inst_21822);

(statearr_22004[(32)] = inst_21820__$1);

(statearr_22004[(30)] = inst_21825);

(statearr_22004[(17)] = inst_21826);

(statearr_22004[(11)] = inst_21824);

(statearr_22004[(9)] = inst_21823);

return statearr_22004;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21945__$1,(11),inst_21830);
} else {
if((state_val_21946 === (5))){
var _ = (function (){var statearr_22005 = state_21945;
(statearr_22005[(4)] = cljs.core.rest.call(null,(state_21945[(4)])));

return statearr_22005;
})();
var state_21945__$1 = state_21945;
var ex22000 = (state_21945__$1[(2)]);
var statearr_22006_22073 = state_21945__$1;
(statearr_22006_22073[(5)] = ex22000);


if((ex22000 instanceof Error)){
var statearr_22007_22074 = state_21945__$1;
(statearr_22007_22074[(1)] = (4));

(statearr_22007_22074[(5)] = null);

} else {
throw ex22000;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (14))){
var inst_21839 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
if(cljs.core.truth_(inst_21839)){
var statearr_22008_22075 = state_21945__$1;
(statearr_22008_22075[(1)] = (15));

} else {
var statearr_22009_22076 = state_21945__$1;
(statearr_22009_22076[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (45))){
var inst_21859 = (state_21945[(10)]);
var inst_21911 = (state_21945[(2)]);
var inst_21912 = fluree.db.util.async.throw_err.call(null,inst_21911);
var inst_21913 = cljs.core.conj.call(null,inst_21859,inst_21912);
var state_21945__$1 = state_21945;
var statearr_22010_22077 = state_21945__$1;
(statearr_22010_22077[(2)] = inst_21913);

(statearr_22010_22077[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (26))){
var inst_21859 = (state_21945[(10)]);
var state_21945__$1 = state_21945;
var statearr_22011_22078 = state_21945__$1;
(statearr_22011_22078[(2)] = inst_21859);

(statearr_22011_22078[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (16))){
var state_21945__$1 = state_21945;
var statearr_22012_22079 = state_21945__$1;
(statearr_22012_22079[(2)] = null);

(statearr_22012_22079[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (38))){
var inst_21820 = (state_21945[(32)]);
var inst_21895 = (state_21945[(22)]);
var inst_21894 = (state_21945[(2)]);
var inst_21895__$1 = fluree.db.util.async.throw_err.call(null,inst_21894);
var inst_21896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21897 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_21898 = (new cljs.core.PersistentVector(null,4,(5),inst_21896,inst_21897,null));
var inst_21899 = cljs.core.select_keys.call(null,inst_21820,inst_21898);
var inst_21900 = cljs.core.empty_QMARK_.call(null,inst_21895__$1);
var state_21945__$1 = (function (){var statearr_22013 = state_21945;
(statearr_22013[(21)] = inst_21899);

(statearr_22013[(22)] = inst_21895__$1);

return statearr_22013;
})();
if(inst_21900){
var statearr_22014_22080 = state_21945__$1;
(statearr_22014_22080[(1)] = (39));

} else {
var statearr_22015_22081 = state_21945__$1;
(statearr_22015_22081[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (30))){
var inst_21822 = (state_21945[(8)]);
var state_21945__$1 = state_21945;
var statearr_22016_22082 = state_21945__$1;
(statearr_22016_22082[(2)] = inst_21822);

(statearr_22016_22082[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (10))){
var inst_21938 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_22017_22083 = state_21945__$1;
(statearr_22017_22083[(2)] = inst_21938);

(statearr_22017_22083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (18))){
var inst_21865 = (state_21945[(31)]);
var inst_21857 = (state_21945[(20)]);
var inst_21867 = (state_21945[(7)]);
var inst_21864 = cljs.core.seq.call(null,inst_21857);
var inst_21865__$1 = cljs.core.first.call(null,inst_21864);
var inst_21866 = cljs.core.next.call(null,inst_21864);
var inst_21867__$1 = cljs.core.not.call(null,inst_21865__$1);
var state_21945__$1 = (function (){var statearr_22018 = state_21945;
(statearr_22018[(18)] = inst_21866);

(statearr_22018[(31)] = inst_21865__$1);

(statearr_22018[(7)] = inst_21867__$1);

return statearr_22018;
})();
if(inst_21867__$1){
var statearr_22019_22084 = state_21945__$1;
(statearr_22019_22084[(1)] = (20));

} else {
var statearr_22020_22085 = state_21945__$1;
(statearr_22020_22085[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (42))){
var inst_21895 = (state_21945[(22)]);
var inst_21904 = cljs.core.count.call(null,inst_21895);
var inst_21905 = fluree.db.query.fql_resp.add_fuel.call(null,fuel,inst_21904,max_fuel);
var state_21945__$1 = state_21945;
var statearr_22021_22086 = state_21945__$1;
(statearr_22021_22086[(2)] = inst_21905);

(statearr_22021_22086[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (37))){
var inst_21920 = (state_21945[(2)]);
var state_21945__$1 = state_21945;
var statearr_22022_22087 = state_21945__$1;
(statearr_22022_22087[(2)] = inst_21920);

(statearr_22022_22087[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (8))){
var inst_21804 = (state_21945[(15)]);
var state_21945__$1 = state_21945;
var statearr_22023_22088 = state_21945__$1;
(statearr_22023_22088[(2)] = inst_21804);

(statearr_22023_22088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21946 === (49))){
var inst_21825 = (state_21945[(30)]);
var state_21945__$1 = state_21945;
var statearr_22024_22089 = state_21945__$1;
(statearr_22024_22089[(2)] = inst_21825);

(statearr_22024_22089[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0 = (function (){
var statearr_22025 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22025[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__);

(statearr_22025[(1)] = (1));

return statearr_22025;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1 = (function (state_21945){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_21945);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22026){var ex__2749__auto__ = e22026;
var statearr_22027_22090 = state_21945;
(statearr_22027_22090[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_21945[(4)]))){
var statearr_22028_22091 = state_21945;
(statearr_22028_22091[(1)] = cljs.core.first.call(null,(state_21945[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22092 = state_21945;
state_21945 = G__22092;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__ = function(state_21945){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1.call(this,state_21945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22029 = f__2769__auto__.call(null);
(statearr_22029[(6)] = c__2768__auto__);

return statearr_22029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22094 = arguments.length;
switch (G__22094) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22096 = null;
var G__22096__0 = (function (){
return xf.call(null);
});
var G__22096__1 = (function (result){
return xf.call(null,result);
});
var G__22096__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22096 = function(result,flake){
switch(arguments.length){
case 0:
return G__22096__0.call(this);
case 1:
return G__22096__1.call(this,result);
case 2:
return G__22096__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22096.cljs$core$IFn$_invoke$arity$0 = G__22096__0;
G__22096.cljs$core$IFn$_invoke$arity$1 = G__22096__1;
G__22096.cljs$core$IFn$_invoke$arity$2 = G__22096__2;
return G__22096;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o.call(null,flake);
var recur_pred = fluree.db.flake.p.call(null,flake);
var map__22097 = select_spec;
var map__22097__$1 = cljs.core.__destructure_map.call(null,map__22097);
var recur_seen = cljs.core.get.call(null,map__22097__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__22097__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22211){
var state_val_22212 = (state_22211[(1)]);
if((state_val_22212 === (7))){
var inst_22123 = flakes;
var inst_22124 = cljs.core.seq.call(null,inst_22123);
var inst_22125 = cljs.core.first.call(null,inst_22124);
var inst_22126 = cljs.core.next.call(null,inst_22124);
var inst_22127 = cljs.core.PersistentVector.EMPTY;
var inst_22128 = inst_22123;
var inst_22129 = (0);
var inst_22130 = inst_22127;
var state_22211__$1 = (function (){var statearr_22213 = state_22211;
(statearr_22213[(7)] = inst_22125);

(statearr_22213[(8)] = inst_22129);

(statearr_22213[(9)] = inst_22128);

(statearr_22213[(10)] = inst_22130);

(statearr_22213[(11)] = inst_22126);

return statearr_22213;
})();
var statearr_22214_22280 = state_22211__$1;
(statearr_22214_22280[(2)] = null);

(statearr_22214_22280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (20))){
var state_22211__$1 = state_22211;
var statearr_22215_22281 = state_22211__$1;
(statearr_22215_22281[(2)] = results);

(statearr_22215_22281[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (27))){
var state_22211__$1 = state_22211;
var statearr_22216_22282 = state_22211__$1;
(statearr_22216_22282[(2)] = null);

(statearr_22216_22282[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (1))){
var state_22211__$1 = state_22211;
var statearr_22217_22283 = state_22211__$1;
(statearr_22217_22283[(2)] = null);

(statearr_22217_22283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (24))){
var state_22211__$1 = state_22211;
var statearr_22218_22284 = state_22211__$1;
(statearr_22218_22284[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (39))){
var inst_22137 = (state_22211[(12)]);
var inst_22192 = (state_22211[(13)]);
var inst_22130 = (state_22211[(10)]);
var inst_22195 = (state_22211[(2)]);
var inst_22196 = fluree.db.util.async.throw_err.call(null,inst_22195);
var inst_22197 = cljs.core.conj.call(null,inst_22130,inst_22196);
var inst_22128 = inst_22137;
var inst_22129 = inst_22192;
var inst_22130__$1 = inst_22197;
var state_22211__$1 = (function (){var statearr_22220 = state_22211;
(statearr_22220[(8)] = inst_22129);

(statearr_22220[(9)] = inst_22128);

(statearr_22220[(10)] = inst_22130__$1);

return statearr_22220;
})();
var statearr_22221_22285 = state_22211__$1;
(statearr_22221_22285[(2)] = null);

(statearr_22221_22285[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (4))){
var inst_22098 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22222_22286 = state_22211__$1;
(statearr_22222_22286[(2)] = inst_22098);

(statearr_22222_22286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (15))){
var inst_22111 = (state_22211[(14)]);
var state_22211__$1 = state_22211;
var statearr_22223_22287 = state_22211__$1;
(statearr_22223_22287[(2)] = inst_22111);

(statearr_22223_22287[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (21))){
var inst_22107 = (state_22211[(15)]);
var state_22211__$1 = state_22211;
if(cljs.core.truth_(inst_22107)){
var statearr_22224_22288 = state_22211__$1;
(statearr_22224_22288[(1)] = (23));

} else {
var statearr_22225_22289 = state_22211__$1;
(statearr_22225_22289[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (31))){
var inst_22175 = (state_22211[(16)]);
var state_22211__$1 = state_22211;
var statearr_22226_22290 = state_22211__$1;
(statearr_22226_22290[(2)] = inst_22175);

(statearr_22226_22290[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (32))){
var inst_22167 = (state_22211[(17)]);
var inst_22181 = (state_22211[(2)]);
var state_22211__$1 = (function (){var statearr_22227 = state_22211;
(statearr_22227[(18)] = inst_22181);

return statearr_22227;
})();
if(cljs.core.truth_(inst_22167)){
var statearr_22228_22291 = state_22211__$1;
(statearr_22228_22291[(1)] = (33));

} else {
var statearr_22229_22292 = state_22211__$1;
(statearr_22229_22292[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (33))){
var inst_22167 = (state_22211[(17)]);
var state_22211__$1 = state_22211;
var statearr_22230_22293 = state_22211__$1;
(statearr_22230_22293[(2)] = inst_22167);

(statearr_22230_22293[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (13))){
var inst_22147 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
if(cljs.core.truth_(inst_22147)){
var statearr_22232_22294 = state_22211__$1;
(statearr_22232_22294[(1)] = (17));

} else {
var statearr_22233_22295 = state_22211__$1;
(statearr_22233_22295[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (22))){
var inst_22164 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22234_22296 = state_22211__$1;
(statearr_22234_22296[(2)] = inst_22164);

(statearr_22234_22296[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (36))){
var inst_22129 = (state_22211[(8)]);
var inst_22137 = (state_22211[(12)]);
var inst_22130 = (state_22211[(10)]);
var inst_22189 = (inst_22129 + (1));
var tmp22231 = inst_22130;
var inst_22128 = inst_22137;
var inst_22129__$1 = inst_22189;
var inst_22130__$1 = tmp22231;
var state_22211__$1 = (function (){var statearr_22235 = state_22211;
(statearr_22235[(8)] = inst_22129__$1);

(statearr_22235[(9)] = inst_22128);

(statearr_22235[(10)] = inst_22130__$1);

return statearr_22235;
})();
var statearr_22236_22297 = state_22211__$1;
(statearr_22236_22297[(2)] = null);

(statearr_22236_22297[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (29))){
var inst_22174 = (state_22211[(2)]);
var inst_22175 = fluree.db.util.async.throw_err.call(null,inst_22174);
var state_22211__$1 = (function (){var statearr_22237 = state_22211;
(statearr_22237[(16)] = inst_22175);

return statearr_22237;
})();
if(cljs.core.truth_(fuel)){
var statearr_22238_22298 = state_22211__$1;
(statearr_22238_22298[(1)] = (30));

} else {
var statearr_22239_22299 = state_22211__$1;
(statearr_22239_22299[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (6))){
var state_22211__$1 = state_22211;
var statearr_22240_22300 = state_22211__$1;
(statearr_22240_22300[(2)] = results);

(statearr_22240_22300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (28))){
var inst_22160 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22241_22301 = state_22211__$1;
(statearr_22241_22301[(2)] = inst_22160);

(statearr_22241_22301[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (25))){
var inst_22162 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22242_22302 = state_22211__$1;
(statearr_22242_22302[(2)] = inst_22162);

(statearr_22242_22302[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (34))){
var inst_22181 = (state_22211[(18)]);
var inst_22184 = cljs.core.empty_QMARK_.call(null,inst_22181);
var state_22211__$1 = state_22211;
var statearr_22243_22303 = state_22211__$1;
(statearr_22243_22303[(2)] = inst_22184);

(statearr_22243_22303[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (17))){
var inst_22130 = (state_22211[(10)]);
var inst_22149 = cljs.core.empty_QMARK_.call(null,inst_22130);
var state_22211__$1 = state_22211;
if(inst_22149){
var statearr_22244_22304 = state_22211__$1;
(statearr_22244_22304[(1)] = (20));

} else {
var statearr_22245_22305 = state_22211__$1;
(statearr_22245_22305[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (3))){
var inst_22209 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22211__$1,inst_22209);
} else {
if((state_val_22212 === (12))){
var inst_22111 = (state_22211[(14)]);
var state_22211__$1 = state_22211;
if(cljs.core.truth_(inst_22111)){
var statearr_22246_22306 = state_22211__$1;
(statearr_22246_22306[(1)] = (14));

} else {
var statearr_22247_22307 = state_22211__$1;
(statearr_22247_22307[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (2))){
var _ = (function (){var statearr_22248 = state_22211;
(statearr_22248[(4)] = cljs.core.cons.call(null,(5),(state_22211[(4)])));

return statearr_22248;
})();
var inst_22105 = select_spec;
var inst_22106 = cljs.core.__destructure_map.call(null,inst_22105);
var inst_22107 = cljs.core.get.call(null,inst_22106,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22108 = cljs.core.get.call(null,inst_22106,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22109 = cljs.core.get.call(null,inst_22106,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22110 = cljs.core.get.call(null,inst_22106,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22111 = cljs.core.get.call(null,inst_22106,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22112 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22113 = (inst_22110 > inst_22112);
var state_22211__$1 = (function (){var statearr_22249 = state_22211;
(statearr_22249[(14)] = inst_22111);

(statearr_22249[(19)] = inst_22108);

(statearr_22249[(15)] = inst_22107);

(statearr_22249[(20)] = inst_22109);

return statearr_22249;
})();
if(cljs.core.truth_(inst_22113)){
var statearr_22250_22308 = state_22211__$1;
(statearr_22250_22308[(1)] = (6));

} else {
var statearr_22251_22309 = state_22211__$1;
(statearr_22251_22309[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (23))){
var inst_22108 = (state_22211[(19)]);
var inst_22130 = (state_22211[(10)]);
var inst_22153 = cljs.core.assoc.call(null,results,inst_22108,inst_22130);
var state_22211__$1 = state_22211;
var statearr_22252_22310 = state_22211__$1;
(statearr_22252_22310[(2)] = inst_22153);

(statearr_22252_22310[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (35))){
var inst_22136 = (state_22211[(21)]);
var inst_22186 = (state_22211[(2)]);
var inst_22187 = fluree.db.query.fql_resp.recur_select_spec.call(null,select_spec,inst_22136);
var state_22211__$1 = (function (){var statearr_22253 = state_22211;
(statearr_22253[(22)] = inst_22187);

return statearr_22253;
})();
if(cljs.core.truth_(inst_22186)){
var statearr_22254_22311 = state_22211__$1;
(statearr_22254_22311[(1)] = (36));

} else {
var statearr_22255_22312 = state_22211__$1;
(statearr_22255_22312[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (19))){
var inst_22202 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22256_22313 = state_22211__$1;
(statearr_22256_22313[(2)] = inst_22202);

(statearr_22256_22313[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (11))){
var inst_22138 = (state_22211[(23)]);
var state_22211__$1 = state_22211;
var statearr_22258_22314 = state_22211__$1;
(statearr_22258_22314[(2)] = inst_22138);

(statearr_22258_22314[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (9))){
var inst_22136 = (state_22211[(21)]);
var inst_22128 = (state_22211[(9)]);
var inst_22138 = (state_22211[(23)]);
var inst_22135 = cljs.core.seq.call(null,inst_22128);
var inst_22136__$1 = cljs.core.first.call(null,inst_22135);
var inst_22137 = cljs.core.next.call(null,inst_22135);
var inst_22138__$1 = cljs.core.not.call(null,inst_22136__$1);
var state_22211__$1 = (function (){var statearr_22259 = state_22211;
(statearr_22259[(21)] = inst_22136__$1);

(statearr_22259[(23)] = inst_22138__$1);

(statearr_22259[(12)] = inst_22137);

return statearr_22259;
})();
if(inst_22138__$1){
var statearr_22260_22315 = state_22211__$1;
(statearr_22260_22315[(1)] = (11));

} else {
var statearr_22261_22316 = state_22211__$1;
(statearr_22261_22316[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (5))){
var _ = (function (){var statearr_22262 = state_22211;
(statearr_22262[(4)] = cljs.core.rest.call(null,(state_22211[(4)])));

return statearr_22262;
})();
var state_22211__$1 = state_22211;
var ex22257 = (state_22211__$1[(2)]);
var statearr_22263_22317 = state_22211__$1;
(statearr_22263_22317[(5)] = ex22257);


if((ex22257 instanceof Error)){
var statearr_22264_22318 = state_22211__$1;
(statearr_22264_22318[(1)] = (4));

(statearr_22264_22318[(5)] = null);

} else {
throw ex22257;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (14))){
var inst_22111 = (state_22211[(14)]);
var inst_22129 = (state_22211[(8)]);
var inst_22142 = (inst_22129 < inst_22111);
var state_22211__$1 = state_22211;
var statearr_22265_22319 = state_22211__$1;
(statearr_22265_22319[(2)] = inst_22142);

(statearr_22265_22319[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (26))){
var inst_22108 = (state_22211[(19)]);
var inst_22130 = (state_22211[(10)]);
var inst_22156 = cljs.core.first.call(null,inst_22130);
var inst_22157 = cljs.core.assoc.call(null,results,inst_22108,inst_22156);
var state_22211__$1 = state_22211;
var statearr_22266_22320 = state_22211__$1;
(statearr_22266_22320[(2)] = inst_22157);

(statearr_22266_22320[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (16))){
var inst_22145 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22267_22321 = state_22211__$1;
(statearr_22267_22321[(2)] = inst_22145);

(statearr_22267_22321[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (38))){
var inst_22200 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22268_22322 = state_22211__$1;
(statearr_22268_22322[(2)] = inst_22200);

(statearr_22268_22322[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (30))){
var inst_22175 = (state_22211[(16)]);
var inst_22177 = fluree.db.query.fql_resp.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22178 = cljs.core.sequence.call(null,inst_22177,inst_22175);
var state_22211__$1 = state_22211;
var statearr_22269_22323 = state_22211__$1;
(statearr_22269_22323[(2)] = inst_22178);

(statearr_22269_22323[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (10))){
var inst_22204 = (state_22211[(2)]);
var state_22211__$1 = state_22211;
var statearr_22270_22324 = state_22211__$1;
(statearr_22270_22324[(2)] = inst_22204);

(statearr_22270_22324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22212 === (18))){
var inst_22136 = (state_22211[(21)]);
var inst_22109 = (state_22211[(20)]);
var inst_22166 = fluree.db.flake.o.call(null,inst_22136);
var inst_22167 = cljs.core.contains_QMARK_.call(null,inst_22109,inst_22166);
var inst_22169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22170 = [inst_22166];
var inst_22171 = (new cljs.core.PersistentVector(null,1,(5),inst_22169,inst_22170,null));
var inst_22172 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22171);
var state_22211__$1 = (function (){var statearr_22271 = state_22211;
(statearr_22271[(17)] = inst_22167);

return statearr_22271;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22211__$1,(29),inst_22172);
} else {
if((state_val_22212 === (37))){
var inst_22181 = (state_22211[(18)]);
var inst_22129 = (state_22211[(8)]);
var inst_22187 = (state_22211[(22)]);
var inst_22192 = (inst_22129 + (1));
var inst_22193 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22187,inst_22181);
var state_22211__$1 = (function (){var statearr_22272 = state_22211;
(statearr_22272[(13)] = inst_22192);

return statearr_22272;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22211__$1,(39),inst_22193);
} else {
if((state_val_22212 === (8))){
var inst_22206 = (state_22211[(2)]);
var _ = (function (){var statearr_22273 = state_22211;
(statearr_22273[(4)] = cljs.core.rest.call(null,(state_22211[(4)])));

return statearr_22273;
})();
var state_22211__$1 = state_22211;
var statearr_22274_22325 = state_22211__$1;
(statearr_22274_22325[(2)] = inst_22206);

(statearr_22274_22325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0 = (function (){
var statearr_22275 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22275[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__);

(statearr_22275[(1)] = (1));

return statearr_22275;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1 = (function (state_22211){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22276){var ex__2749__auto__ = e22276;
var statearr_22277_22326 = state_22211;
(statearr_22277_22326[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22211[(4)]))){
var statearr_22278_22327 = state_22211;
(statearr_22278_22327[(1)] = cljs.core.first.call(null,(state_22211[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22328 = state_22211;
state_22211 = G__22328;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__ = function(state_22211){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1.call(this,state_22211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22279 = f__2769__auto__.call(null);
(statearr_22279[(6)] = c__2768__auto__);

return statearr_22279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22332 = arguments.length;
switch (G__22332) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_22771){
var state_val_22772 = (state_22771[(1)]);
if((state_val_22772 === (121))){
var inst_22694 = (state_22771[(2)]);
var inst_22695 = fluree.db.util.async.throw_err.call(null,inst_22694);
var inst_22696 = cljs.core.seq.call(null,inst_22695);
var state_22771__$1 = state_22771;
if(inst_22696){
var statearr_22773_22987 = state_22771__$1;
(statearr_22773_22987[(1)] = (122));

} else {
var statearr_22774_22988 = state_22771__$1;
(statearr_22774_22988[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (65))){
var inst_22487 = (state_22771[(7)]);
var inst_22486 = (state_22771[(2)]);
var inst_22487__$1 = fluree.db.util.async.throw_err.call(null,inst_22486);
var inst_22488 = cljs.core.seq.call(null,inst_22487__$1);
var state_22771__$1 = (function (){var statearr_22775 = state_22771;
(statearr_22775[(7)] = inst_22487__$1);

return statearr_22775;
})();
if(inst_22488){
var statearr_22776_22989 = state_22771__$1;
(statearr_22776_22989[(1)] = (66));

} else {
var statearr_22777_22990 = state_22771__$1;
(statearr_22777_22990[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (70))){
var inst_22487 = (state_22771[(7)]);
var inst_22498 = cljs.core.count.call(null,inst_22487);
var inst_22499 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22498);
var state_22771__$1 = state_22771;
var statearr_22778_22991 = state_22771__$1;
(statearr_22778_22991[(2)] = inst_22499);

(statearr_22778_22991[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (62))){
var inst_22477 = (state_22771[(8)]);
var inst_22480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22481 = fluree.db.flake.o.call(null,inst_22477);
var inst_22482 = [inst_22481];
var inst_22483 = (new cljs.core.PersistentVector(null,1,(5),inst_22480,inst_22482,null));
var inst_22484 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22483);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22771__$1,(65),inst_22484);
} else {
if((state_val_22772 === (74))){
var inst_22471 = (state_22771[(9)]);
var state_22771__$1 = state_22771;
var statearr_22779_22992 = state_22771__$1;
(statearr_22779_22992[(2)] = inst_22471);

(statearr_22779_22992[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (110))){
var inst_22656 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22657 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22656);
var inst_22658 = inst_22657 === true;
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22658)){
var statearr_22780_22993 = state_22771__$1;
(statearr_22780_22993[(1)] = (113));

} else {
var statearr_22781_22994 = state_22771__$1;
(statearr_22781_22994[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (130))){
var inst_22766 = (state_22771[(2)]);
var _ = (function (){var statearr_22782 = state_22771;
(statearr_22782[(4)] = cljs.core.rest.call(null,(state_22771[(4)])));

return statearr_22782;
})();
var state_22771__$1 = state_22771;
var statearr_22783_22995 = state_22771__$1;
(statearr_22783_22995[(2)] = inst_22766);

(statearr_22783_22995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (128))){
var inst_22741 = (state_22771[(10)]);
var inst_22744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22745 = [acc,inst_22741];
var inst_22746 = (new cljs.core.PersistentVector(null,2,(5),inst_22744,inst_22745,null));
var state_22771__$1 = state_22771;
var statearr_22784_22996 = state_22771__$1;
(statearr_22784_22996[(2)] = inst_22746);

(statearr_22784_22996[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (7))){
var inst_22344 = (state_22771[(11)]);
var state_22771__$1 = state_22771;
var statearr_22785_22997 = state_22771__$1;
(statearr_22785_22997[(2)] = inst_22344);

(statearr_22785_22997[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (59))){
var inst_22735 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22786_22998 = state_22771__$1;
(statearr_22786_22998[(2)] = inst_22735);

(statearr_22786_22998[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (86))){
var inst_22565 = (state_22771[(12)]);
var inst_22565__$1 = (state_22771[(2)]);
var state_22771__$1 = (function (){var statearr_22787 = state_22771;
(statearr_22787[(12)] = inst_22565__$1);

return statearr_22787;
})();
if(cljs.core.truth_(inst_22565__$1)){
var statearr_22788_22999 = state_22771__$1;
(statearr_22788_22999[(1)] = (88));

} else {
var statearr_22789_23000 = state_22771__$1;
(statearr_22789_23000[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (20))){
var inst_22385 = (state_22771[(13)]);
var inst_22373 = (state_22771[(14)]);
var inst_22386 = (state_22771[(15)]);
var inst_22384 = (state_22771[(2)]);
var inst_22385__$1 = cljs.core.__destructure_map.call(null,inst_22373);
var inst_22386__$1 = cljs.core.get.call(null,inst_22385__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22387 = cljs.core.get.call(null,inst_22385__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22388 = cljs.core.get.call(null,inst_22385__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22389 = cljs.core.get.call(null,inst_22385__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22390 = cljs.core.get.call(null,inst_22385__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22391 = cljs.core.get.call(null,inst_22385__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22771__$1 = (function (){var statearr_22790 = state_22771;
(statearr_22790[(16)] = inst_22389);

(statearr_22790[(17)] = inst_22388);

(statearr_22790[(18)] = inst_22384);

(statearr_22790[(19)] = inst_22387);

(statearr_22790[(20)] = inst_22391);

(statearr_22790[(13)] = inst_22385__$1);

(statearr_22790[(15)] = inst_22386__$1);

(statearr_22790[(21)] = inst_22390);

return statearr_22790;
})();
if(cljs.core.truth_(inst_22386__$1)){
var statearr_22791_23001 = state_22771__$1;
(statearr_22791_23001[(1)] = (24));

} else {
var statearr_22792_23002 = state_22771__$1;
(statearr_22792_23002[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (72))){
var inst_22496 = (state_22771[(22)]);
var inst_22502 = (state_22771[(2)]);
var inst_22503 = cljs.core.seq.call(null,inst_22496);
var state_22771__$1 = (function (){var statearr_22793 = state_22771;
(statearr_22793[(23)] = inst_22502);

return statearr_22793;
})();
if(inst_22503){
var statearr_22794_23003 = state_22771__$1;
(statearr_22794_23003[(1)] = (73));

} else {
var statearr_22795_23004 = state_22771__$1;
(statearr_22795_23004[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (58))){
var inst_22373 = (state_22771[(14)]);
var inst_22518 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22373);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22518)){
var statearr_22796_23005 = state_22771__$1;
(statearr_22796_23005[(1)] = (76));

} else {
var statearr_22797_23006 = state_22771__$1;
(statearr_22797_23006[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (60))){
var inst_22477 = (state_22771[(8)]);
var inst_22470 = (state_22771[(24)]);
var inst_22476 = cljs.core.seq.call(null,inst_22470);
var inst_22477__$1 = cljs.core.first.call(null,inst_22476);
var inst_22478 = cljs.core.next.call(null,inst_22476);
var state_22771__$1 = (function (){var statearr_22798 = state_22771;
(statearr_22798[(8)] = inst_22477__$1);

(statearr_22798[(25)] = inst_22478);

return statearr_22798;
})();
if(cljs.core.truth_(inst_22477__$1)){
var statearr_22799_23007 = state_22771__$1;
(statearr_22799_23007[(1)] = (62));

} else {
var statearr_22800_23008 = state_22771__$1;
(statearr_22800_23008[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (27))){
var inst_22394 = (state_22771[(26)]);
var inst_22390 = (state_22771[(21)]);
var inst_22394__$1 = cljs.core.not_EQ_.call(null,(0),inst_22390);
var state_22771__$1 = (function (){var statearr_22801 = state_22771;
(statearr_22801[(26)] = inst_22394__$1);

return statearr_22801;
})();
if(inst_22394__$1){
var statearr_22802_23009 = state_22771__$1;
(statearr_22802_23009[(1)] = (30));

} else {
var statearr_22803_23010 = state_22771__$1;
(statearr_22803_23010[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (1))){
var state_22771__$1 = state_22771;
var statearr_22804_23011 = state_22771__$1;
(statearr_22804_23011[(2)] = null);

(statearr_22804_23011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (69))){
var inst_22492 = (state_22771[(2)]);
var inst_22493 = fluree.db.util.async.throw_err.call(null,inst_22492);
var state_22771__$1 = state_22771;
var statearr_22805_23012 = state_22771__$1;
(statearr_22805_23012[(2)] = inst_22493);

(statearr_22805_23012[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (101))){
var inst_22649 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22806_23013 = state_22771__$1;
(statearr_22806_23013[(2)] = inst_22649);

(statearr_22806_23013[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (24))){
var inst_22390 = (state_22771[(21)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22390)){
var statearr_22807_23014 = state_22771__$1;
(statearr_22807_23014[(1)] = (27));

} else {
var statearr_22808_23015 = state_22771__$1;
(statearr_22808_23015[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (102))){
var inst_22621 = (state_22771[(27)]);
var inst_22620 = (state_22771[(2)]);
var inst_22621__$1 = fluree.db.util.async.throw_err.call(null,inst_22620);
var inst_22622 = cljs.core.empty_QMARK_.call(null,inst_22621__$1);
var state_22771__$1 = (function (){var statearr_22809 = state_22771;
(statearr_22809[(27)] = inst_22621__$1);

return statearr_22809;
})();
if(inst_22622){
var statearr_22810_23016 = state_22771__$1;
(statearr_22810_23016[(1)] = (103));

} else {
var statearr_22811_23017 = state_22771__$1;
(statearr_22811_23017[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (135))){
var state_22771__$1 = state_22771;
var statearr_22812_23018 = state_22771__$1;
(statearr_22812_23018[(2)] = null);

(statearr_22812_23018[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (55))){
var inst_22373 = (state_22771[(14)]);
var inst_22446 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22373);
var state_22771__$1 = state_22771;
var statearr_22813_23019 = state_22771__$1;
(statearr_22813_23019[(2)] = inst_22446);

(statearr_22813_23019[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (85))){
var inst_22373 = (state_22771[(14)]);
var inst_22540 = (state_22771[(28)]);
var inst_22552 = fluree.db.flake.o.call(null,inst_22540);
var inst_22553 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22373);
var inst_22554 = fluree.db.dbproto._tag.call(null,db,inst_22552,inst_22553);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22771__$1,(87),inst_22554);
} else {
if((state_val_22772 === (39))){
var inst_22421 = (state_22771[(29)]);
var inst_22389 = (state_22771[(16)]);
var inst_22421__$1 = cljs.core.not.call(null,inst_22389);
var state_22771__$1 = (function (){var statearr_22814 = state_22771;
(statearr_22814[(29)] = inst_22421__$1);

return statearr_22814;
})();
if(inst_22421__$1){
var statearr_22815_23020 = state_22771__$1;
(statearr_22815_23020[(1)] = (42));

} else {
var statearr_22816_23021 = state_22771__$1;
(statearr_22816_23021[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (88))){
var inst_22565 = (state_22771[(12)]);
var inst_22534 = (state_22771[(30)]);
var inst_22567 = cljs.core.conj.call(null,inst_22534,inst_22565);
var state_22771__$1 = state_22771;
var statearr_22817_23022 = state_22771__$1;
(statearr_22817_23022[(2)] = inst_22567);

(statearr_22817_23022[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (46))){
var inst_22388 = (state_22771[(17)]);
var state_22771__$1 = state_22771;
var statearr_22818_23023 = state_22771__$1;
(statearr_22818_23023[(2)] = inst_22388);

(statearr_22818_23023[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (4))){
var inst_22333 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22819_23024 = state_22771__$1;
(statearr_22819_23024[(2)] = inst_22333);

(statearr_22819_23024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (77))){
var inst_22580 = (state_22771[(31)]);
var inst_22580__$1 = componentFollow_QMARK_;
var state_22771__$1 = (function (){var statearr_22820 = state_22771;
(statearr_22820[(31)] = inst_22580__$1);

return statearr_22820;
})();
if(cljs.core.truth_(inst_22580__$1)){
var statearr_22821_23025 = state_22771__$1;
(statearr_22821_23025[(1)] = (91));

} else {
var statearr_22822_23026 = state_22771__$1;
(statearr_22822_23026[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (106))){
var inst_22601 = (state_22771[(32)]);
var inst_22635 = (state_22771[(2)]);
var inst_22636 = fluree.db.util.async.throw_err.call(null,inst_22635);
var inst_22637 = cljs.core.conj.call(null,inst_22601,inst_22636);
var state_22771__$1 = state_22771;
var statearr_22823_23027 = state_22771__$1;
(statearr_22823_23027[(2)] = inst_22637);

(statearr_22823_23027[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (119))){
var inst_22679 = (state_22771[(33)]);
var inst_22709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22710 = [inst_22679,offset_map];
var inst_22711 = (new cljs.core.PersistentVector(null,2,(5),inst_22709,inst_22710,null));
var state_22771__$1 = state_22771;
var statearr_22824_23028 = state_22771__$1;
(statearr_22824_23028[(2)] = inst_22711);

(statearr_22824_23028[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (95))){
var inst_22387 = (state_22771[(19)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22387)){
var statearr_22825_23029 = state_22771__$1;
(statearr_22825_23029[(1)] = (110));

} else {
var statearr_22826_23030 = state_22771__$1;
(statearr_22826_23030[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (54))){
var inst_22443 = (state_22771[(34)]);
var state_22771__$1 = state_22771;
var statearr_22827_23031 = state_22771__$1;
(statearr_22827_23031[(2)] = inst_22443);

(statearr_22827_23031[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (92))){
var inst_22580 = (state_22771[(31)]);
var state_22771__$1 = state_22771;
var statearr_22828_23032 = state_22771__$1;
(statearr_22828_23032[(2)] = inst_22580);

(statearr_22828_23032[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (104))){
var inst_22621 = (state_22771[(27)]);
var inst_22343 = (state_22771[(35)]);
var inst_22630 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22631 = [true,inst_22343];
var inst_22632 = cljs.core.PersistentHashMap.fromArrays(inst_22630,inst_22631);
var inst_22633 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22632,inst_22621);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22771__$1,(106),inst_22633);
} else {
if((state_val_22772 === (15))){
var inst_22343 = (state_22771[(35)]);
var inst_22366 = (state_22771[(36)]);
var inst_22370 = cljs.core.assoc.call(null,inst_22366,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22343);
var state_22771__$1 = state_22771;
var statearr_22829_23033 = state_22771__$1;
(statearr_22829_23033[(2)] = inst_22370);

(statearr_22829_23033[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (48))){
var inst_22437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22438 = [null,offset_map];
var inst_22439 = (new cljs.core.PersistentVector(null,2,(5),inst_22437,inst_22438,null));
var state_22771__$1 = state_22771;
var statearr_22830_23034 = state_22771__$1;
(statearr_22830_23034[(2)] = inst_22439);

(statearr_22830_23034[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (50))){
var inst_22737 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22831_23035 = state_22771__$1;
(statearr_22831_23035[(2)] = inst_22737);

(statearr_22831_23035[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (116))){
var inst_22678 = (state_22771[(37)]);
var inst_22685 = (state_22771[(38)]);
var inst_22684 = cljs.core.seq.call(null,inst_22678);
var inst_22685__$1 = cljs.core.first.call(null,inst_22684);
var inst_22686 = cljs.core.next.call(null,inst_22684);
var state_22771__$1 = (function (){var statearr_22832 = state_22771;
(statearr_22832[(39)] = inst_22686);

(statearr_22832[(38)] = inst_22685__$1);

return statearr_22832;
})();
if(cljs.core.truth_(inst_22685__$1)){
var statearr_22833_23036 = state_22771__$1;
(statearr_22833_23036[(1)] = (118));

} else {
var statearr_22834_23037 = state_22771__$1;
(statearr_22834_23037[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (75))){
var inst_22478 = (state_22771[(25)]);
var inst_22508 = (state_22771[(2)]);
var inst_22470 = inst_22478;
var inst_22471 = inst_22508;
var state_22771__$1 = (function (){var statearr_22835 = state_22771;
(statearr_22835[(9)] = inst_22471);

(statearr_22835[(24)] = inst_22470);

return statearr_22835;
})();
var statearr_22836_23038 = state_22771__$1;
(statearr_22836_23038[(2)] = null);

(statearr_22836_23038[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (99))){
var inst_22607 = (state_22771[(40)]);
var inst_22373 = (state_22771[(14)]);
var inst_22610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22611 = fluree.db.flake.o.call(null,inst_22607);
var inst_22612 = [inst_22611];
var inst_22613 = (new cljs.core.PersistentVector(null,1,(5),inst_22610,inst_22612,null));
var inst_22614 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22615 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22373);
var inst_22616 = [inst_22615];
var inst_22617 = cljs.core.PersistentHashMap.fromArrays(inst_22614,inst_22616);
var inst_22618 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22613,inst_22617);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22771__$1,(102),inst_22618);
} else {
if((state_val_22772 === (21))){
var inst_22377 = (state_22771[(41)]);
var state_22771__$1 = state_22771;
var statearr_22837_23039 = state_22771__$1;
(statearr_22837_23039[(2)] = inst_22377);

(statearr_22837_23039[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (31))){
var inst_22394 = (state_22771[(26)]);
var state_22771__$1 = state_22771;
var statearr_22838_23040 = state_22771__$1;
(statearr_22838_23040[(2)] = inst_22394);

(statearr_22838_23040[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (113))){
var inst_22389 = (state_22771[(16)]);
var inst_22388 = (state_22771[(17)]);
var inst_22384 = (state_22771[(18)]);
var inst_22387 = (state_22771[(19)]);
var inst_22391 = (state_22771[(20)]);
var inst_22385 = (state_22771[(13)]);
var inst_22373 = (state_22771[(14)]);
var inst_22343 = (state_22771[(35)]);
var inst_22358 = (state_22771[(42)]);
var inst_22386 = (state_22771[(15)]);
var inst_22390 = (state_22771[(21)]);
var inst_22660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22661 = (function (){var p = inst_22391;
var pred_spec__$1 = inst_22358;
var orderBy = inst_22389;
var multi_QMARK_ = inst_22386;
var limit = inst_22388;
var offset = inst_22390;
var k = inst_22384;
var map__22339 = inst_22385;
var compact_QMARK_ = inst_22343;
var pred_spec_SINGLEQUOTE_ = inst_22373;
var ref_QMARK_ = inst_22387;
return (function (p1__22329_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o.call(null,p1__22329_SHARP_)]);
});
})();
var inst_22662 = cljs.core.mapv.call(null,inst_22661,flakes);
var inst_22663 = [inst_22662,offset_map];
var inst_22664 = (new cljs.core.PersistentVector(null,2,(5),inst_22660,inst_22663,null));
var state_22771__$1 = state_22771;
var statearr_22839_23041 = state_22771__$1;
(statearr_22839_23041[(2)] = inst_22664);

(statearr_22839_23041[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (32))){
var inst_22400 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22840_23042 = state_22771__$1;
(statearr_22840_23042[(2)] = inst_22400);

(statearr_22840_23042[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (136))){
var inst_22762 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22841_23043 = state_22771__$1;
(statearr_22841_23043[(2)] = inst_22762);

(statearr_22841_23043[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (40))){
var inst_22386 = (state_22771[(15)]);
var state_22771__$1 = state_22771;
var statearr_22842_23044 = state_22771__$1;
(statearr_22842_23044[(2)] = inst_22386);

(statearr_22842_23044[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (129))){
var inst_22386 = (state_22771[(15)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22386)){
var statearr_22843_23045 = state_22771__$1;
(statearr_22843_23045[(1)] = (131));

} else {
var statearr_22844_23046 = state_22771__$1;
(statearr_22844_23046[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (91))){
var inst_22373 = (state_22771[(14)]);
var inst_22582 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22373);
var state_22771__$1 = state_22771;
var statearr_22845_23047 = state_22771__$1;
(statearr_22845_23047[(2)] = inst_22582);

(statearr_22845_23047[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (117))){
var inst_22715 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22846_23048 = state_22771__$1;
(statearr_22846_23048[(2)] = inst_22715);

(statearr_22846_23048[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (108))){
var state_22771__$1 = state_22771;
var statearr_22847_23049 = state_22771__$1;
(statearr_22847_23049[(2)] = null);

(statearr_22847_23049[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (56))){
var inst_22448 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22848_23050 = state_22771__$1;
(statearr_22848_23050[(2)] = inst_22448);

(statearr_22848_23050[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (33))){
var inst_22391 = (state_22771[(20)]);
var inst_22408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22409 = cljs.core.get.call(null,offset_map,inst_22391);
var state_22771__$1 = (function (){var statearr_22849 = state_22771;
(statearr_22849[(43)] = inst_22408);

return statearr_22849;
})();
if(cljs.core.truth_(inst_22409)){
var statearr_22850_23051 = state_22771__$1;
(statearr_22850_23051[(1)] = (36));

} else {
var statearr_22851_23052 = state_22771__$1;
(statearr_22851_23052[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (13))){
var inst_22358 = (state_22771[(42)]);
var state_22771__$1 = state_22771;
var statearr_22852_23053 = state_22771__$1;
(statearr_22852_23053[(2)] = inst_22358);

(statearr_22852_23053[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (22))){
var inst_22373 = (state_22771[(14)]);
var inst_22380 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22373);
var state_22771__$1 = state_22771;
var statearr_22853_23054 = state_22771__$1;
(statearr_22853_23054[(2)] = inst_22380);

(statearr_22853_23054[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (90))){
var inst_22541 = (state_22771[(44)]);
var inst_22570 = (state_22771[(2)]);
var inst_22533 = inst_22541;
var inst_22534 = inst_22570;
var state_22771__$1 = (function (){var statearr_22854 = state_22771;
(statearr_22854[(30)] = inst_22534);

(statearr_22854[(45)] = inst_22533);

return statearr_22854;
})();
var statearr_22855_23055 = state_22771__$1;
(statearr_22855_23055[(2)] = null);

(statearr_22855_23055[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (109))){
var inst_22608 = (state_22771[(46)]);
var inst_22639 = (state_22771[(47)]);
var inst_22645 = (state_22771[(2)]);
var inst_22600 = inst_22608;
var inst_22601 = inst_22639;
var state_22771__$1 = (function (){var statearr_22856 = state_22771;
(statearr_22856[(32)] = inst_22601);

(statearr_22856[(48)] = inst_22600);

(statearr_22856[(49)] = inst_22645);

return statearr_22856;
})();
var statearr_22857_23056 = state_22771__$1;
(statearr_22857_23056[(2)] = null);

(statearr_22857_23056[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (36))){
var inst_22391 = (state_22771[(20)]);
var inst_22411 = cljs.core.update.call(null,offset_map,inst_22391,cljs.core.dec);
var state_22771__$1 = state_22771;
var statearr_22858_23057 = state_22771__$1;
(statearr_22858_23057[(2)] = inst_22411);

(statearr_22858_23057[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (41))){
var inst_22435 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22435)){
var statearr_22859_23058 = state_22771__$1;
(statearr_22859_23058[(1)] = (48));

} else {
var statearr_22860_23059 = state_22771__$1;
(statearr_22860_23059[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (118))){
var inst_22685 = (state_22771[(38)]);
var inst_22688 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22689 = fluree.db.flake.o.call(null,inst_22685);
var inst_22690 = [inst_22689];
var inst_22691 = (new cljs.core.PersistentVector(null,1,(5),inst_22688,inst_22690,null));
var inst_22692 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22691);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22771__$1,(121),inst_22692);
} else {
if((state_val_22772 === (89))){
var inst_22534 = (state_22771[(30)]);
var state_22771__$1 = state_22771;
var statearr_22861_23060 = state_22771__$1;
(statearr_22861_23060[(2)] = inst_22534);

(statearr_22861_23060[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (100))){
var inst_22601 = (state_22771[(32)]);
var state_22771__$1 = state_22771;
var statearr_22862_23061 = state_22771__$1;
(statearr_22862_23061[(2)] = inst_22601);

(statearr_22862_23061[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (131))){
var inst_22741 = (state_22771[(10)]);
var inst_22384 = (state_22771[(18)]);
var inst_22740 = (state_22771[(50)]);
var inst_22749 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22750 = cljs.core.assoc.call(null,acc,inst_22384,inst_22740);
var inst_22751 = [inst_22750,inst_22741];
var inst_22752 = (new cljs.core.PersistentVector(null,2,(5),inst_22749,inst_22751,null));
var state_22771__$1 = state_22771;
var statearr_22863_23062 = state_22771__$1;
(statearr_22863_23062[(2)] = inst_22752);

(statearr_22863_23062[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (122))){
var inst_22686 = (state_22771[(39)]);
var inst_22679 = (state_22771[(33)]);
var inst_22685 = (state_22771[(38)]);
var inst_22698 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22699 = fluree.db.flake.o.call(null,inst_22685);
var inst_22700 = [inst_22699];
var inst_22701 = cljs.core.PersistentHashMap.fromArrays(inst_22698,inst_22700);
var inst_22702 = cljs.core.conj.call(null,inst_22679,inst_22701);
var inst_22678 = inst_22686;
var inst_22679__$1 = inst_22702;
var state_22771__$1 = (function (){var statearr_22864 = state_22771;
(statearr_22864[(37)] = inst_22678);

(statearr_22864[(33)] = inst_22679__$1);

return statearr_22864;
})();
var statearr_22865_23063 = state_22771__$1;
(statearr_22865_23063[(2)] = null);

(statearr_22865_23063[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (43))){
var inst_22421 = (state_22771[(29)]);
var state_22771__$1 = state_22771;
var statearr_22866_23064 = state_22771__$1;
(statearr_22866_23064[(2)] = inst_22421);

(statearr_22866_23064[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (61))){
var inst_22457 = (state_22771[(51)]);
var inst_22514 = (state_22771[(2)]);
var inst_22515 = [inst_22514,offset_map];
var inst_22516 = (new cljs.core.PersistentVector(null,2,(5),inst_22457,inst_22515,null));
var state_22771__$1 = state_22771;
var statearr_22867_23065 = state_22771__$1;
(statearr_22867_23065[(2)] = inst_22516);

(statearr_22867_23065[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (29))){
var inst_22403 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22868_23066 = state_22771__$1;
(statearr_22868_23066[(2)] = inst_22403);

(statearr_22868_23066[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (44))){
var inst_22432 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22869_23067 = state_22771__$1;
(statearr_22869_23067[(2)] = inst_22432);

(statearr_22869_23067[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (93))){
var inst_22585 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22585)){
var statearr_22870_23068 = state_22771__$1;
(statearr_22870_23068[(1)] = (94));

} else {
var statearr_22871_23069 = state_22771__$1;
(statearr_22871_23069[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (6))){
var inst_22346 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22347 = (inst_22346 == null);
var state_22771__$1 = state_22771;
var statearr_22872_23070 = state_22771__$1;
(statearr_22872_23070[(2)] = inst_22347);

(statearr_22872_23070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (111))){
var state_22771__$1 = state_22771;
var statearr_22873_23071 = state_22771__$1;
(statearr_22873_23071[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (28))){
var inst_22390 = (state_22771[(21)]);
var state_22771__$1 = state_22771;
var statearr_22875_23072 = state_22771__$1;
(statearr_22875_23072[(2)] = inst_22390);

(statearr_22875_23072[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (134))){
var inst_22741 = (state_22771[(10)]);
var inst_22384 = (state_22771[(18)]);
var inst_22740 = (state_22771[(50)]);
var inst_22755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22756 = cljs.core.first.call(null,inst_22740);
var inst_22757 = cljs.core.assoc.call(null,acc,inst_22384,inst_22756);
var inst_22758 = [inst_22757,inst_22741];
var inst_22759 = (new cljs.core.PersistentVector(null,2,(5),inst_22755,inst_22758,null));
var state_22771__$1 = state_22771;
var statearr_22876_23073 = state_22771__$1;
(statearr_22876_23073[(2)] = inst_22759);

(statearr_22876_23073[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (64))){
var inst_22512 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22877_23074 = state_22771__$1;
(statearr_22877_23074[(2)] = inst_22512);

(statearr_22877_23074[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (103))){
var inst_22601 = (state_22771[(32)]);
var inst_22607 = (state_22771[(40)]);
var inst_22624 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22625 = fluree.db.flake.o.call(null,inst_22607);
var inst_22626 = [inst_22625];
var inst_22627 = cljs.core.PersistentHashMap.fromArrays(inst_22624,inst_22626);
var inst_22628 = cljs.core.conj.call(null,inst_22601,inst_22627);
var state_22771__$1 = state_22771;
var statearr_22878_23075 = state_22771__$1;
(statearr_22878_23075[(2)] = inst_22628);

(statearr_22878_23075[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (51))){
var inst_22373 = (state_22771[(14)]);
var inst_22443 = (state_22771[(34)]);
var inst_22443__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22373);
var state_22771__$1 = (function (){var statearr_22879 = state_22771;
(statearr_22879[(34)] = inst_22443__$1);

return statearr_22879;
})();
if(cljs.core.truth_(inst_22443__$1)){
var statearr_22880_23076 = state_22771__$1;
(statearr_22880_23076[(1)] = (54));

} else {
var statearr_22881_23077 = state_22771__$1;
(statearr_22881_23077[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (25))){
var inst_22386 = (state_22771[(15)]);
var state_22771__$1 = state_22771;
var statearr_22882_23078 = state_22771__$1;
(statearr_22882_23078[(2)] = inst_22386);

(statearr_22882_23078[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (34))){
var inst_22386 = (state_22771[(15)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22386)){
var statearr_22883_23079 = state_22771__$1;
(statearr_22883_23079[(1)] = (39));

} else {
var statearr_22884_23080 = state_22771__$1;
(statearr_22884_23080[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (125))){
var inst_22389 = (state_22771[(16)]);
var inst_22388 = (state_22771[(17)]);
var inst_22384 = (state_22771[(18)]);
var inst_22387 = (state_22771[(19)]);
var inst_22391 = (state_22771[(20)]);
var inst_22385 = (state_22771[(13)]);
var inst_22373 = (state_22771[(14)]);
var inst_22343 = (state_22771[(35)]);
var inst_22358 = (state_22771[(42)]);
var inst_22386 = (state_22771[(15)]);
var inst_22390 = (state_22771[(21)]);
var inst_22720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22721 = (function (){var p = inst_22391;
var pred_spec__$1 = inst_22358;
var orderBy = inst_22389;
var multi_QMARK_ = inst_22386;
var limit = inst_22388;
var offset = inst_22390;
var k = inst_22384;
var map__22339 = inst_22385;
var compact_QMARK_ = inst_22343;
var pred_spec_SINGLEQUOTE_ = inst_22373;
var ref_QMARK_ = inst_22387;
return (function (p1__22330_SHARP_){
return fluree.db.flake.o.call(null,p1__22330_SHARP_);
});
})();
var inst_22722 = cljs.core.mapv.call(null,inst_22721,flakes);
var inst_22723 = [inst_22722,offset_map];
var inst_22724 = (new cljs.core.PersistentVector(null,2,(5),inst_22720,inst_22723,null));
var state_22771__$1 = state_22771;
var statearr_22885_23081 = state_22771__$1;
(statearr_22885_23081[(2)] = inst_22724);

(statearr_22885_23081[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (17))){
var inst_22374 = (state_22771[(52)]);
var inst_22373 = (state_22771[(14)]);
var inst_22373__$1 = (state_22771[(2)]);
var inst_22374__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22373__$1);
var state_22771__$1 = (function (){var statearr_22886 = state_22771;
(statearr_22886[(52)] = inst_22374__$1);

(statearr_22886[(14)] = inst_22373__$1);

return statearr_22886;
})();
if(cljs.core.truth_(inst_22374__$1)){
var statearr_22887_23082 = state_22771__$1;
(statearr_22887_23082[(1)] = (18));

} else {
var statearr_22888_23083 = state_22771__$1;
(statearr_22888_23083[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (3))){
var inst_22769 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22771__$1,inst_22769);
} else {
if((state_val_22772 === (12))){
var inst_22358 = (state_22771[(42)]);
var inst_22363 = cljs.core.assoc.call(null,inst_22358,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22771__$1 = state_22771;
var statearr_22889_23084 = state_22771__$1;
(statearr_22889_23084[(2)] = inst_22363);

(statearr_22889_23084[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (2))){
var inst_22344 = (state_22771[(11)]);
var _ = (function (){var statearr_22890 = state_22771;
(statearr_22890[(4)] = cljs.core.cons.call(null,(5),(state_22771[(4)])));

return statearr_22890;
})();
var inst_22343 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22344__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22771__$1 = (function (){var statearr_22891 = state_22771;
(statearr_22891[(11)] = inst_22344__$1);

(statearr_22891[(35)] = inst_22343);

return statearr_22891;
})();
if(cljs.core.truth_(inst_22344__$1)){
var statearr_22892_23085 = state_22771__$1;
(statearr_22892_23085[(1)] = (6));

} else {
var statearr_22893_23086 = state_22771__$1;
(statearr_22893_23086[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (66))){
var inst_22456 = (state_22771[(53)]);
var inst_22487 = (state_22771[(7)]);
var inst_22490 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22456,inst_22487);
var state_22771__$1 = state_22771;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22771__$1,(69),inst_22490);
} else {
if((state_val_22772 === (107))){
var inst_22621 = (state_22771[(27)]);
var inst_22641 = cljs.core.count.call(null,inst_22621);
var inst_22642 = fluree.db.query.fql_resp.vswap_BANG_.call(null,fuel,cljs.core._PLUS_,inst_22641);
var state_22771__$1 = state_22771;
var statearr_22894_23087 = state_22771__$1;
(statearr_22894_23087[(2)] = inst_22642);

(statearr_22894_23087[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (23))){
var inst_22382 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22895_23088 = state_22771__$1;
(statearr_22895_23088[(2)] = inst_22382);

(statearr_22895_23088[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (47))){
var inst_22429 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22896_23089 = state_22771__$1;
(statearr_22896_23089[(2)] = inst_22429);

(statearr_22896_23089[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (35))){
var inst_22740 = (state_22771[(50)]);
var inst_22739 = (state_22771[(2)]);
var inst_22740__$1 = cljs.core.nth.call(null,inst_22739,(0),null);
var inst_22741 = cljs.core.nth.call(null,inst_22739,(1),null);
var inst_22742 = cljs.core.empty_QMARK_.call(null,inst_22740__$1);
var state_22771__$1 = (function (){var statearr_22897 = state_22771;
(statearr_22897[(10)] = inst_22741);

(statearr_22897[(50)] = inst_22740__$1);

return statearr_22897;
})();
if(inst_22742){
var statearr_22898_23090 = state_22771__$1;
(statearr_22898_23090[(1)] = (128));

} else {
var statearr_22899_23091 = state_22771__$1;
(statearr_22899_23091[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (127))){
var inst_22727 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22900_23092 = state_22771__$1;
(statearr_22900_23092[(2)] = inst_22727);

(statearr_22900_23092[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (82))){
var inst_22534 = (state_22771[(30)]);
var state_22771__$1 = state_22771;
var statearr_22901_23093 = state_22771__$1;
(statearr_22901_23093[(2)] = inst_22534);

(statearr_22901_23093[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (76))){
var inst_22520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22528 = flakes;
var inst_22529 = cljs.core.seq.call(null,inst_22528);
var inst_22530 = cljs.core.first.call(null,inst_22529);
var inst_22531 = cljs.core.next.call(null,inst_22529);
var inst_22532 = cljs.core.PersistentVector.EMPTY;
var inst_22533 = inst_22528;
var inst_22534 = inst_22532;
var state_22771__$1 = (function (){var statearr_22902 = state_22771;
(statearr_22902[(54)] = inst_22531);

(statearr_22902[(30)] = inst_22534);

(statearr_22902[(55)] = inst_22520);

(statearr_22902[(45)] = inst_22533);

(statearr_22902[(56)] = inst_22530);

return statearr_22902;
})();
var statearr_22903_23094 = state_22771__$1;
(statearr_22903_23094[(2)] = null);

(statearr_22903_23094[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (97))){
var inst_22607 = (state_22771[(40)]);
var inst_22600 = (state_22771[(48)]);
var inst_22606 = cljs.core.seq.call(null,inst_22600);
var inst_22607__$1 = cljs.core.first.call(null,inst_22606);
var inst_22608 = cljs.core.next.call(null,inst_22606);
var state_22771__$1 = (function (){var statearr_22904 = state_22771;
(statearr_22904[(46)] = inst_22608);

(statearr_22904[(40)] = inst_22607__$1);

return statearr_22904;
})();
if(cljs.core.truth_(inst_22607__$1)){
var statearr_22905_23095 = state_22771__$1;
(statearr_22905_23095[(1)] = (99));

} else {
var statearr_22906_23096 = state_22771__$1;
(statearr_22906_23096[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (19))){
var inst_22377 = (state_22771[(41)]);
var inst_22373 = (state_22771[(14)]);
var inst_22377__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22373);
var state_22771__$1 = (function (){var statearr_22907 = state_22771;
(statearr_22907[(41)] = inst_22377__$1);

return statearr_22907;
})();
if(cljs.core.truth_(inst_22377__$1)){
var statearr_22908_23097 = state_22771__$1;
(statearr_22908_23097[(1)] = (21));

} else {
var statearr_22909_23098 = state_22771__$1;
(statearr_22909_23098[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (57))){
var inst_22373 = (state_22771[(14)]);
var inst_22453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22454 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22455 = (new cljs.core.PersistentVector(null,3,(5),inst_22453,inst_22454,null));
var inst_22456 = cljs.core.select_keys.call(null,inst_22373,inst_22455);
var inst_22457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22465 = flakes;
var inst_22466 = cljs.core.seq.call(null,inst_22465);
var inst_22467 = cljs.core.first.call(null,inst_22466);
var inst_22468 = cljs.core.next.call(null,inst_22466);
var inst_22469 = cljs.core.PersistentVector.EMPTY;
var inst_22470 = inst_22465;
var inst_22471 = inst_22469;
var state_22771__$1 = (function (){var statearr_22910 = state_22771;
(statearr_22910[(53)] = inst_22456);

(statearr_22910[(9)] = inst_22471);

(statearr_22910[(57)] = inst_22467);

(statearr_22910[(51)] = inst_22457);

(statearr_22910[(24)] = inst_22470);

(statearr_22910[(58)] = inst_22468);

return statearr_22910;
})();
var statearr_22911_23099 = state_22771__$1;
(statearr_22911_23099[(2)] = null);

(statearr_22911_23099[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (68))){
var inst_22496 = (state_22771[(2)]);
var state_22771__$1 = (function (){var statearr_22912 = state_22771;
(statearr_22912[(22)] = inst_22496);

return statearr_22912;
})();
if(cljs.core.truth_(fuel)){
var statearr_22913_23100 = state_22771__$1;
(statearr_22913_23100[(1)] = (70));

} else {
var statearr_22914_23101 = state_22771__$1;
(statearr_22914_23101[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (11))){
var inst_22358 = (state_22771[(42)]);
var inst_22358__$1 = (state_22771[(2)]);
var inst_22360 = cljs.core.contains_QMARK_.call(null,inst_22358__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22361 = (!(inst_22360));
var state_22771__$1 = (function (){var statearr_22915 = state_22771;
(statearr_22915[(42)] = inst_22358__$1);

return statearr_22915;
})();
if(inst_22361){
var statearr_22916_23102 = state_22771__$1;
(statearr_22916_23102[(1)] = (12));

} else {
var statearr_22917_23103 = state_22771__$1;
(statearr_22917_23103[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (115))){
var inst_22717 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22919_23104 = state_22771__$1;
(statearr_22919_23104[(2)] = inst_22717);

(statearr_22919_23104[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (9))){
var inst_22352 = cljs.core.first.call(null,flakes);
var inst_22353 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22352);
var inst_22354 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22355 = fluree.db.query.fql_resp.wildcard_pred_spec.call(null,db,cache,inst_22353,inst_22354);
var state_22771__$1 = state_22771;
var statearr_22920_23105 = state_22771__$1;
(statearr_22920_23105[(2)] = inst_22355);

(statearr_22920_23105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (5))){
var _ = (function (){var statearr_22921 = state_22771;
(statearr_22921[(4)] = cljs.core.rest.call(null,(state_22771[(4)])));

return statearr_22921;
})();
var state_22771__$1 = state_22771;
var ex22918 = (state_22771__$1[(2)]);
var statearr_22922_23106 = state_22771__$1;
(statearr_22922_23106[(5)] = ex22918);


if((ex22918 instanceof Error)){
var statearr_22923_23107 = state_22771__$1;
(statearr_22923_23107[(1)] = (4));

(statearr_22923_23107[(5)] = null);

} else {
throw ex22918;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (112))){
var inst_22729 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22924_23108 = state_22771__$1;
(statearr_22924_23108[(2)] = inst_22729);

(statearr_22924_23108[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (83))){
var inst_22574 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22925_23109 = state_22771__$1;
(statearr_22925_23109[(2)] = inst_22574);

(statearr_22925_23109[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (14))){
var inst_22358 = (state_22771[(42)]);
var inst_22366 = (state_22771[(2)]);
var inst_22367 = cljs.core.contains_QMARK_.call(null,inst_22358,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22368 = (!(inst_22367));
var state_22771__$1 = (function (){var statearr_22926 = state_22771;
(statearr_22926[(36)] = inst_22366);

return statearr_22926;
})();
if(inst_22368){
var statearr_22927_23110 = state_22771__$1;
(statearr_22927_23110[(1)] = (15));

} else {
var statearr_22928_23111 = state_22771__$1;
(statearr_22928_23111[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (45))){
var inst_22388 = (state_22771[(17)]);
var inst_22384 = (state_22771[(18)]);
var inst_22424 = cljs.core.get.call(null,acc,inst_22384);
var inst_22425 = cljs.core.count.call(null,inst_22424);
var inst_22426 = (inst_22425 >= inst_22388);
var state_22771__$1 = state_22771;
var statearr_22929_23112 = state_22771__$1;
(statearr_22929_23112[(2)] = inst_22426);

(statearr_22929_23112[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (53))){
var inst_22451 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22451)){
var statearr_22930_23113 = state_22771__$1;
(statearr_22930_23113[(1)] = (57));

} else {
var statearr_22931_23114 = state_22771__$1;
(statearr_22931_23114[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (78))){
var inst_22733 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22932_23115 = state_22771__$1;
(statearr_22932_23115[(2)] = inst_22733);

(statearr_22932_23115[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (132))){
var state_22771__$1 = state_22771;
var statearr_22934_23116 = state_22771__$1;
(statearr_22934_23116[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (26))){
var inst_22406 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22406)){
var statearr_22936_23117 = state_22771__$1;
(statearr_22936_23117[(1)] = (33));

} else {
var statearr_22937_23118 = state_22771__$1;
(statearr_22937_23118[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (123))){
var inst_22686 = (state_22771[(39)]);
var inst_22679 = (state_22771[(33)]);
var tmp22933 = inst_22679;
var inst_22678 = inst_22686;
var inst_22679__$1 = tmp22933;
var state_22771__$1 = (function (){var statearr_22938 = state_22771;
(statearr_22938[(37)] = inst_22678);

(statearr_22938[(33)] = inst_22679__$1);

return statearr_22938;
})();
var statearr_22939_23119 = state_22771__$1;
(statearr_22939_23119[(2)] = null);

(statearr_22939_23119[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (16))){
var inst_22366 = (state_22771[(36)]);
var state_22771__$1 = state_22771;
var statearr_22940_23120 = state_22771__$1;
(statearr_22940_23120[(2)] = inst_22366);

(statearr_22940_23120[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (133))){
var inst_22764 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22941_23121 = state_22771__$1;
(statearr_22941_23121[(2)] = inst_22764);

(statearr_22941_23121[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (81))){
var inst_22549 = (state_22771[(59)]);
var inst_22373 = (state_22771[(14)]);
var inst_22540 = (state_22771[(28)]);
var inst_22543 = cljs.core.deref.call(null,cache);
var inst_22544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22545 = fluree.db.flake.o.call(null,inst_22540);
var inst_22546 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22373);
var inst_22547 = [inst_22545,inst_22546];
var inst_22548 = (new cljs.core.PersistentVector(null,2,(5),inst_22544,inst_22547,null));
var inst_22549__$1 = cljs.core.get.call(null,inst_22543,inst_22548);
var state_22771__$1 = (function (){var statearr_22942 = state_22771;
(statearr_22942[(59)] = inst_22549__$1);

return statearr_22942;
})();
if(cljs.core.truth_(inst_22549__$1)){
var statearr_22943_23122 = state_22771__$1;
(statearr_22943_23122[(1)] = (84));

} else {
var statearr_22944_23123 = state_22771__$1;
(statearr_22944_23123[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (120))){
var inst_22713 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22945_23124 = state_22771__$1;
(statearr_22945_23124[(2)] = inst_22713);

(statearr_22945_23124[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (79))){
var inst_22540 = (state_22771[(28)]);
var inst_22533 = (state_22771[(45)]);
var inst_22539 = cljs.core.seq.call(null,inst_22533);
var inst_22540__$1 = cljs.core.first.call(null,inst_22539);
var inst_22541 = cljs.core.next.call(null,inst_22539);
var state_22771__$1 = (function (){var statearr_22946 = state_22771;
(statearr_22946[(44)] = inst_22541);

(statearr_22946[(28)] = inst_22540__$1);

return statearr_22946;
})();
if(cljs.core.truth_(inst_22540__$1)){
var statearr_22947_23125 = state_22771__$1;
(statearr_22947_23125[(1)] = (81));

} else {
var statearr_22948_23126 = state_22771__$1;
(statearr_22948_23126[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (38))){
var inst_22408 = (state_22771[(43)]);
var inst_22416 = (state_22771[(2)]);
var inst_22417 = [null,inst_22416];
var inst_22418 = (new cljs.core.PersistentVector(null,2,(5),inst_22408,inst_22417,null));
var state_22771__$1 = state_22771;
var statearr_22949_23127 = state_22771__$1;
(statearr_22949_23127[(2)] = inst_22418);

(statearr_22949_23127[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (126))){
var state_22771__$1 = state_22771;
var statearr_22950_23128 = state_22771__$1;
(statearr_22950_23128[(2)] = null);

(statearr_22950_23128[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (98))){
var inst_22587 = (state_22771[(60)]);
var inst_22651 = (state_22771[(2)]);
var inst_22652 = [inst_22651,offset_map];
var inst_22653 = (new cljs.core.PersistentVector(null,2,(5),inst_22587,inst_22652,null));
var state_22771__$1 = state_22771;
var statearr_22951_23129 = state_22771__$1;
(statearr_22951_23129[(2)] = inst_22653);

(statearr_22951_23129[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (124))){
var inst_22707 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22952_23130 = state_22771__$1;
(statearr_22952_23130[(2)] = inst_22707);

(statearr_22952_23130[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (87))){
var inst_22373 = (state_22771[(14)]);
var inst_22540 = (state_22771[(28)]);
var inst_22556 = (state_22771[(2)]);
var inst_22557 = fluree.db.util.async.throw_err.call(null,inst_22556);
var inst_22558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22559 = fluree.db.flake.o.call(null,inst_22540);
var inst_22560 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22373);
var inst_22561 = [inst_22559,inst_22560];
var inst_22562 = (new cljs.core.PersistentVector(null,2,(5),inst_22558,inst_22561,null));
var inst_22563 = fluree.db.query.fql_resp.vswap_BANG_.call(null,cache,cljs.core.assoc,inst_22562,inst_22557);
var state_22771__$1 = (function (){var statearr_22953 = state_22771;
(statearr_22953[(61)] = inst_22563);

return statearr_22953;
})();
var statearr_22954_23131 = state_22771__$1;
(statearr_22954_23131[(2)] = inst_22557);

(statearr_22954_23131[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (30))){
var inst_22391 = (state_22771[(20)]);
var inst_22396 = cljs.core.get.call(null,offset_map,inst_22391);
var inst_22397 = cljs.core.not_EQ_.call(null,(0),inst_22396);
var state_22771__$1 = state_22771;
var statearr_22955_23132 = state_22771__$1;
(statearr_22955_23132[(2)] = inst_22397);

(statearr_22955_23132[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (73))){
var inst_22471 = (state_22771[(9)]);
var inst_22496 = (state_22771[(22)]);
var inst_22505 = cljs.core.conj.call(null,inst_22471,inst_22496);
var state_22771__$1 = state_22771;
var statearr_22956_23133 = state_22771__$1;
(statearr_22956_23133[(2)] = inst_22505);

(statearr_22956_23133[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (96))){
var inst_22731 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
var statearr_22957_23134 = state_22771__$1;
(statearr_22957_23134[(2)] = inst_22731);

(statearr_22957_23134[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (10))){
var state_22771__$1 = state_22771;
var statearr_22958_23135 = state_22771__$1;
(statearr_22958_23135[(2)] = pred_spec);

(statearr_22958_23135[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (18))){
var inst_22374 = (state_22771[(52)]);
var state_22771__$1 = state_22771;
var statearr_22959_23136 = state_22771__$1;
(statearr_22959_23136[(2)] = inst_22374);

(statearr_22959_23136[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (105))){
var inst_22639 = (state_22771[(2)]);
var state_22771__$1 = (function (){var statearr_22960 = state_22771;
(statearr_22960[(47)] = inst_22639);

return statearr_22960;
})();
if(cljs.core.truth_(fuel)){
var statearr_22961_23137 = state_22771__$1;
(statearr_22961_23137[(1)] = (107));

} else {
var statearr_22962_23138 = state_22771__$1;
(statearr_22962_23138[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (52))){
var inst_22441 = (state_22771[(62)]);
var state_22771__$1 = state_22771;
var statearr_22963_23139 = state_22771__$1;
(statearr_22963_23139[(2)] = inst_22441);

(statearr_22963_23139[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (114))){
var inst_22673 = flakes;
var inst_22674 = cljs.core.seq.call(null,inst_22673);
var inst_22675 = cljs.core.first.call(null,inst_22674);
var inst_22676 = cljs.core.next.call(null,inst_22674);
var inst_22677 = cljs.core.PersistentVector.EMPTY;
var inst_22678 = inst_22673;
var inst_22679 = inst_22677;
var state_22771__$1 = (function (){var statearr_22964 = state_22771;
(statearr_22964[(37)] = inst_22678);

(statearr_22964[(33)] = inst_22679);

(statearr_22964[(63)] = inst_22675);

(statearr_22964[(64)] = inst_22676);

return statearr_22964;
})();
var statearr_22965_23140 = state_22771__$1;
(statearr_22965_23140[(2)] = null);

(statearr_22965_23140[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (67))){
var state_22771__$1 = state_22771;
var statearr_22966_23141 = state_22771__$1;
(statearr_22966_23141[(2)] = null);

(statearr_22966_23141[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (71))){
var state_22771__$1 = state_22771;
var statearr_22967_23142 = state_22771__$1;
(statearr_22967_23142[(2)] = null);

(statearr_22967_23142[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (42))){
var inst_22388 = (state_22771[(17)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22388)){
var statearr_22968_23143 = state_22771__$1;
(statearr_22968_23143[(1)] = (45));

} else {
var statearr_22969_23144 = state_22771__$1;
(statearr_22969_23144[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (80))){
var inst_22520 = (state_22771[(55)]);
var inst_22576 = (state_22771[(2)]);
var inst_22577 = [inst_22576,offset_map];
var inst_22578 = (new cljs.core.PersistentVector(null,2,(5),inst_22520,inst_22577,null));
var state_22771__$1 = state_22771;
var statearr_22970_23145 = state_22771__$1;
(statearr_22970_23145[(2)] = inst_22578);

(statearr_22970_23145[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (37))){
var inst_22391 = (state_22771[(20)]);
var inst_22390 = (state_22771[(21)]);
var inst_22413 = (inst_22390 - (1));
var inst_22414 = cljs.core.assoc.call(null,offset_map,inst_22391,inst_22413);
var state_22771__$1 = state_22771;
var statearr_22971_23146 = state_22771__$1;
(statearr_22971_23146[(2)] = inst_22414);

(statearr_22971_23146[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (63))){
var inst_22471 = (state_22771[(9)]);
var state_22771__$1 = state_22771;
var statearr_22972_23147 = state_22771__$1;
(statearr_22972_23147[(2)] = inst_22471);

(statearr_22972_23147[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (94))){
var inst_22587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22595 = flakes;
var inst_22596 = cljs.core.seq.call(null,inst_22595);
var inst_22597 = cljs.core.first.call(null,inst_22596);
var inst_22598 = cljs.core.next.call(null,inst_22596);
var inst_22599 = cljs.core.PersistentVector.EMPTY;
var inst_22600 = inst_22595;
var inst_22601 = inst_22599;
var state_22771__$1 = (function (){var statearr_22973 = state_22771;
(statearr_22973[(65)] = inst_22598);

(statearr_22973[(66)] = inst_22597);

(statearr_22973[(32)] = inst_22601);

(statearr_22973[(48)] = inst_22600);

(statearr_22973[(60)] = inst_22587);

return statearr_22973;
})();
var statearr_22974_23148 = state_22771__$1;
(statearr_22974_23148[(2)] = null);

(statearr_22974_23148[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (8))){
var inst_22350 = (state_22771[(2)]);
var state_22771__$1 = state_22771;
if(cljs.core.truth_(inst_22350)){
var statearr_22975_23149 = state_22771__$1;
(statearr_22975_23149[(1)] = (9));

} else {
var statearr_22976_23150 = state_22771__$1;
(statearr_22976_23150[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (49))){
var inst_22441 = (state_22771[(62)]);
var inst_22441__$1 = cljs.core.not.call(null,recur_QMARK_);
var state_22771__$1 = (function (){var statearr_22977 = state_22771;
(statearr_22977[(62)] = inst_22441__$1);

return statearr_22977;
})();
if(inst_22441__$1){
var statearr_22978_23151 = state_22771__$1;
(statearr_22978_23151[(1)] = (51));

} else {
var statearr_22979_23152 = state_22771__$1;
(statearr_22979_23152[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22772 === (84))){
var inst_22549 = (state_22771[(59)]);
var state_22771__$1 = state_22771;
var statearr_22980_23153 = state_22771__$1;
(statearr_22980_23153[(2)] = inst_22549);

(statearr_22980_23153[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2746__auto____0 = (function (){
var statearr_22981 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22981[(0)] = fluree$db$query$fql_resp$state_machine__2746__auto__);

(statearr_22981[(1)] = (1));

return statearr_22981;
});
var fluree$db$query$fql_resp$state_machine__2746__auto____1 = (function (state_22771){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_22771);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e22982){var ex__2749__auto__ = e22982;
var statearr_22983_23154 = state_22771;
(statearr_22983_23154[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_22771[(4)]))){
var statearr_22984_23155 = state_22771;
(statearr_22984_23155[(1)] = cljs.core.first.call(null,(state_22771[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23156 = state_22771;
state_22771 = G__23156;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2746__auto__ = function(state_22771){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2746__auto____1.call(this,state_22771);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2746__auto____0;
fluree$db$query$fql_resp$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2746__auto____1;
return fluree$db$query$fql_resp$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_22985 = f__2769__auto__.call(null);
(statearr_22985[(6)] = c__2768__auto__);

return statearr_22985;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__23158 = res;
var G__23158__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__23157_SHARP_){
return cljs.core.get.call(null,p1__23157_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23158):G__23158);
var G__23158__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__23158__$1):G__23158__$1);
var G__23158__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__23158__$2):G__23158__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__23158__$3);
} else {
return G__23158__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23339){
var state_val_23340 = (state_23339[(1)]);
if((state_val_23340 === (7))){
var state_23339__$1 = state_23339;
var statearr_23341_23427 = state_23339__$1;
(statearr_23341_23427[(2)] = null);

(statearr_23341_23427[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (20))){
var inst_23197 = cljs.core.PersistentHashMap.EMPTY;
var state_23339__$1 = state_23339;
var statearr_23342_23428 = state_23339__$1;
(statearr_23342_23428[(2)] = inst_23197);

(statearr_23342_23428[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (27))){
var inst_23199 = (state_23339[(7)]);
var inst_23215 = (state_23339[(8)]);
var inst_23185 = (state_23339[(9)]);
var inst_23179 = (state_23339[(10)]);
var inst_23318 = (state_23339[(2)]);
var inst_23319 = (function (){var top_level_subject = inst_23179;
var select_spec = inst_23185;
var base_acc = inst_23199;
var acc_PLUS_refs = inst_23215;
var result = inst_23318;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23320 = cljs.core.PersistentVector.EMPTY;
var inst_23321 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23185);
var inst_23322 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23321);
var inst_23323 = cljs.core.vals.call(null,inst_23322);
var inst_23324 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23185);
var inst_23325 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23324);
var inst_23326 = cljs.core.vals.call(null,inst_23325);
var inst_23327 = cljs.core.concat.call(null,inst_23323,inst_23326);
var inst_23328 = cljs.core.reduce.call(null,inst_23319,inst_23320,inst_23327);
var inst_23330 = (function (){var top_level_subject = inst_23179;
var select_spec = inst_23185;
var base_acc = inst_23199;
var acc_PLUS_refs = inst_23215;
var result = inst_23318;
var sort_preds = inst_23328;
return (function (acc,p__23329){
var vec__23343 = p__23329;
var selectPred = cljs.core.nth.call(null,vec__23343,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23343,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23343,(2),null);
var limit = cljs.core.nth.call(null,vec__23343,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23331 = cljs.core.reduce.call(null,inst_23330,inst_23318,inst_23328);
var state_23339__$1 = state_23339;
var statearr_23346_23429 = state_23339__$1;
(statearr_23346_23429[(2)] = inst_23331);

(statearr_23346_23429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (1))){
var state_23339__$1 = state_23339;
var statearr_23347_23430 = state_23339__$1;
(statearr_23347_23430[(2)] = null);

(statearr_23347_23430[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (24))){
var inst_23215 = (state_23339[(8)]);
var inst_23215__$1 = (state_23339[(2)]);
var inst_23216 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23217 = cljs.core.PersistentHashMap.EMPTY;
var inst_23218 = inst_23216;
var inst_23219 = inst_23215__$1;
var inst_23220 = inst_23217;
var state_23339__$1 = (function (){var statearr_23348 = state_23339;
(statearr_23348[(11)] = inst_23219);

(statearr_23348[(12)] = inst_23220);

(statearr_23348[(8)] = inst_23215__$1);

(statearr_23348[(13)] = inst_23218);

return statearr_23348;
})();
var statearr_23349_23431 = state_23339__$1;
(statearr_23349_23431[(2)] = null);

(statearr_23349_23431[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (39))){
var inst_23219 = (state_23339[(11)]);
var inst_23235 = (state_23339[(14)]);
var inst_23228 = (state_23339[(15)]);
var inst_23185 = (state_23339[(9)]);
var inst_23264 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23265 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23219,inst_23185,inst_23228,inst_23235,false);
var state_23339__$1 = (function (){var statearr_23350 = state_23339;
(statearr_23350[(16)] = inst_23264);

return statearr_23350;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23339__$1,(42),inst_23265);
} else {
if((state_val_23340 === (46))){
var inst_23228 = (state_23339[(15)]);
var inst_23220 = (state_23339[(12)]);
var inst_23218 = (state_23339[(13)]);
var inst_23282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23283 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23284 = cljs.core.first.call(null,inst_23228);
var inst_23285 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23284);
var inst_23286 = [inst_23285];
var inst_23287 = cljs.core.PersistentHashMap.fromArrays(inst_23283,inst_23286);
var inst_23288 = cljs.core.rest.call(null,inst_23218);
var inst_23289 = [inst_23287,inst_23288,inst_23220];
var inst_23290 = (new cljs.core.PersistentVector(null,3,(5),inst_23282,inst_23289,null));
var state_23339__$1 = state_23339;
var statearr_23351_23432 = state_23339__$1;
(statearr_23351_23432[(2)] = inst_23290);

(statearr_23351_23432[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (4))){
var inst_23159 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
var statearr_23352_23433 = state_23339__$1;
(statearr_23352_23433[(2)] = inst_23159);

(statearr_23352_23433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (15))){
var inst_23186 = (state_23339[(17)]);
var inst_23185 = (state_23339[(9)]);
var inst_23185__$1 = (state_23339[(2)]);
var inst_23186__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23185__$1);
var state_23339__$1 = (function (){var statearr_23353 = state_23339;
(statearr_23353[(17)] = inst_23186__$1);

(statearr_23353[(9)] = inst_23185__$1);

return statearr_23353;
})();
if(cljs.core.truth_(inst_23186__$1)){
var statearr_23354_23434 = state_23339__$1;
(statearr_23354_23434[(1)] = (16));

} else {
var statearr_23355_23435 = state_23339__$1;
(statearr_23355_23435[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (48))){
var inst_23301 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
var statearr_23356_23436 = state_23339__$1;
(statearr_23356_23436[(2)] = inst_23301);

(statearr_23356_23436[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (50))){
var state_23339__$1 = state_23339;
var statearr_23357_23437 = state_23339__$1;
(statearr_23357_23437[(2)] = null);

(statearr_23357_23437[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (21))){
var inst_23185 = (state_23339[(9)]);
var inst_23199 = (state_23339[(2)]);
var inst_23200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23201 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23202 = (new cljs.core.PersistentVector(null,2,(5),inst_23200,inst_23201,null));
var inst_23203 = cljs.core.get_in.call(null,inst_23185,inst_23202);
var state_23339__$1 = (function (){var statearr_23358 = state_23339;
(statearr_23358[(7)] = inst_23199);

return statearr_23358;
})();
if(cljs.core.truth_(inst_23203)){
var statearr_23359_23438 = state_23339__$1;
(statearr_23359_23438[(1)] = (22));

} else {
var statearr_23360_23439 = state_23339__$1;
(statearr_23360_23439[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (31))){
var inst_23219 = (state_23339[(11)]);
var inst_23234 = (state_23339[(18)]);
var inst_23228 = (state_23339[(15)]);
var inst_23238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23239 = fluree.db.query.fql_resp.flake__GT_recur.call(null,db,inst_23228,inst_23234,inst_23219,fuel,max_fuel,cache);
var state_23339__$1 = (function (){var statearr_23361 = state_23339;
(statearr_23361[(19)] = inst_23238);

return statearr_23361;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23339__$1,(34),inst_23239);
} else {
if((state_val_23340 === (32))){
var inst_23234 = (state_23339[(18)]);
var state_23339__$1 = state_23339;
if(cljs.core.truth_(inst_23234)){
var statearr_23362_23440 = state_23339__$1;
(statearr_23362_23440[(1)] = (35));

} else {
var statearr_23363_23441 = state_23339__$1;
(statearr_23363_23441[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (40))){
var inst_23185 = (state_23339[(9)]);
var inst_23275 = (state_23339[(20)]);
var inst_23274 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23185);
var inst_23275__$1 = cljs.core.empty_QMARK_.call(null,inst_23274);
var state_23339__$1 = (function (){var statearr_23364 = state_23339;
(statearr_23364[(20)] = inst_23275__$1);

return statearr_23364;
})();
if(inst_23275__$1){
var statearr_23365_23442 = state_23339__$1;
(statearr_23365_23442[(1)] = (43));

} else {
var statearr_23366_23443 = state_23339__$1;
(statearr_23366_23443[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (33))){
var inst_23228 = (state_23339[(15)]);
var inst_23307 = (state_23339[(2)]);
var inst_23308 = cljs.core.nth.call(null,inst_23307,(0),null);
var inst_23309 = cljs.core.nth.call(null,inst_23307,(1),null);
var inst_23310 = cljs.core.nth.call(null,inst_23307,(2),null);
var inst_23311 = cljs.core.first.call(null,inst_23228);
var inst_23312 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23311);
var inst_23313 = cljs.core.assoc.call(null,inst_23308,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23312);
var inst_23218 = inst_23309;
var inst_23219 = inst_23313;
var inst_23220 = inst_23310;
var state_23339__$1 = (function (){var statearr_23367 = state_23339;
(statearr_23367[(11)] = inst_23219);

(statearr_23367[(12)] = inst_23220);

(statearr_23367[(13)] = inst_23218);

return statearr_23367;
})();
var statearr_23368_23444 = state_23339__$1;
(statearr_23368_23444[(2)] = null);

(statearr_23368_23444[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (13))){
var inst_23179 = (state_23339[(10)]);
var inst_23182 = fluree.db.query.fql_resp.full_select_spec.call(null,db,cache,base_select_spec,inst_23179);
var state_23339__$1 = state_23339;
var statearr_23369_23445 = state_23339__$1;
(statearr_23369_23445[(2)] = inst_23182);

(statearr_23369_23445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (22))){
var inst_23185 = (state_23339[(9)]);
var inst_23205 = cljs.core.first.call(null,flakes);
var inst_23206 = fluree.db.flake.s.call(null,inst_23205);
var inst_23207 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs.call(null,inst_23185);
var inst_23208 = fluree.db.query.fql_resp.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23206,inst_23207);
var state_23339__$1 = state_23339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23339__$1,(25),inst_23208);
} else {
if((state_val_23340 === (36))){
var inst_23185 = (state_23339[(9)]);
var inst_23262 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23185);
var state_23339__$1 = state_23339;
if(cljs.core.truth_(inst_23262)){
var statearr_23370_23446 = state_23339__$1;
(statearr_23370_23446[(1)] = (39));

} else {
var statearr_23371_23447 = state_23339__$1;
(statearr_23371_23447[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (41))){
var inst_23303 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
var statearr_23372_23448 = state_23339__$1;
(statearr_23372_23448[(2)] = inst_23303);

(statearr_23372_23448[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (43))){
var inst_23185 = (state_23339[(9)]);
var inst_23277 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23185);
var state_23339__$1 = state_23339;
var statearr_23373_23449 = state_23339__$1;
(statearr_23373_23449[(2)] = inst_23277);

(statearr_23373_23449[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (29))){
var inst_23234 = (state_23339[(18)]);
var inst_23228 = (state_23339[(15)]);
var inst_23185 = (state_23339[(9)]);
var inst_23218 = (state_23339[(13)]);
var inst_23228__$1 = cljs.core.first.call(null,inst_23218);
var inst_23229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23230 = cljs.core.first.call(null,inst_23228__$1);
var inst_23231 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23230);
var inst_23232 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23231];
var inst_23233 = (new cljs.core.PersistentVector(null,3,(5),inst_23229,inst_23232,null));
var inst_23234__$1 = cljs.core.get_in.call(null,inst_23185,inst_23233);
var inst_23235 = fluree.db.query.fql_resp.component_follow_QMARK_.call(null,inst_23234__$1,inst_23185);
var inst_23236 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23234__$1);
var state_23339__$1 = (function (){var statearr_23374 = state_23339;
(statearr_23374[(14)] = inst_23235);

(statearr_23374[(18)] = inst_23234__$1);

(statearr_23374[(15)] = inst_23228__$1);

return statearr_23374;
})();
if(cljs.core.truth_(inst_23236)){
var statearr_23375_23450 = state_23339__$1;
(statearr_23375_23450[(1)] = (31));

} else {
var statearr_23376_23451 = state_23339__$1;
(statearr_23376_23451[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (44))){
var inst_23275 = (state_23339[(20)]);
var state_23339__$1 = state_23339;
var statearr_23377_23452 = state_23339__$1;
(statearr_23377_23452[(2)] = inst_23275);

(statearr_23377_23452[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (6))){
var state_23339__$1 = state_23339;
var statearr_23378_23453 = state_23339__$1;
(statearr_23378_23453[(2)] = null);

(statearr_23378_23453[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (28))){
var inst_23219 = (state_23339[(11)]);
var state_23339__$1 = state_23339;
var statearr_23379_23454 = state_23339__$1;
(statearr_23379_23454[(2)] = inst_23219);

(statearr_23379_23454[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (51))){
var inst_23299 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
var statearr_23380_23455 = state_23339__$1;
(statearr_23380_23455[(2)] = inst_23299);

(statearr_23380_23455[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (25))){
var inst_23199 = (state_23339[(7)]);
var inst_23210 = (state_23339[(2)]);
var inst_23211 = fluree.db.util.async.throw_err.call(null,inst_23210);
var inst_23212 = cljs.core.merge.call(null,inst_23199,inst_23211);
var state_23339__$1 = state_23339;
var statearr_23381_23456 = state_23339__$1;
(statearr_23381_23456[(2)] = inst_23212);

(statearr_23381_23456[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (34))){
var inst_23238 = (state_23339[(19)]);
var inst_23220 = (state_23339[(12)]);
var inst_23218 = (state_23339[(13)]);
var inst_23241 = (state_23339[(2)]);
var inst_23242 = fluree.db.util.async.throw_err.call(null,inst_23241);
var inst_23243 = cljs.core.rest.call(null,inst_23218);
var inst_23244 = [inst_23242,inst_23243,inst_23220];
var inst_23245 = (new cljs.core.PersistentVector(null,3,(5),inst_23238,inst_23244,null));
var state_23339__$1 = state_23339;
var statearr_23382_23457 = state_23339__$1;
(statearr_23382_23457[(2)] = inst_23245);

(statearr_23382_23457[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (17))){
var inst_23185 = (state_23339[(9)]);
var inst_23189 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23185);
var state_23339__$1 = state_23339;
var statearr_23384_23458 = state_23339__$1;
(statearr_23384_23458[(2)] = inst_23189);

(statearr_23384_23458[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (3))){
var inst_23337 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23339__$1,inst_23337);
} else {
if((state_val_23340 === (12))){
var _ = (function (){var statearr_23385 = state_23339;
(statearr_23385[(4)] = cljs.core.rest.call(null,(state_23339[(4)])));

return statearr_23385;
})();
var state_23339__$1 = state_23339;
var ex23383 = (state_23339__$1[(2)]);
var statearr_23386_23459 = state_23339__$1;
(statearr_23386_23459[(5)] = ex23383);


var statearr_23387_23460 = state_23339__$1;
(statearr_23387_23460[(1)] = (11));

(statearr_23387_23460[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (2))){
var _ = (function (){var statearr_23388 = state_23339;
(statearr_23388[(4)] = cljs.core.cons.call(null,(5),(state_23339[(4)])));

return statearr_23388;
})();
var inst_23165 = cljs.core.not_empty.call(null,flakes);
var state_23339__$1 = state_23339;
if(cljs.core.truth_(inst_23165)){
var statearr_23389_23461 = state_23339__$1;
(statearr_23389_23461[(1)] = (6));

} else {
var statearr_23390_23462 = state_23339__$1;
(statearr_23390_23462[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (23))){
var inst_23199 = (state_23339[(7)]);
var state_23339__$1 = state_23339;
var statearr_23391_23463 = state_23339__$1;
(statearr_23391_23463[(2)] = inst_23199);

(statearr_23391_23463[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (47))){
var state_23339__$1 = state_23339;
var statearr_23392_23464 = state_23339__$1;
(statearr_23392_23464[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (35))){
var inst_23219 = (state_23339[(11)]);
var inst_23235 = (state_23339[(14)]);
var inst_23234 = (state_23339[(18)]);
var inst_23228 = (state_23339[(15)]);
var inst_23220 = (state_23339[(12)]);
var inst_23251 = fluree.db.query.fql_resp.add_pred.call(null,db,cache,fuel,max_fuel,inst_23219,inst_23234,inst_23228,inst_23235,false,inst_23220);
var state_23339__$1 = state_23339;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23339__$1,(38),inst_23251);
} else {
if((state_val_23340 === (19))){
var inst_23179 = (state_23339[(10)]);
var inst_23193 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23194 = [inst_23179];
var inst_23195 = cljs.core.PersistentHashMap.fromArrays(inst_23193,inst_23194);
var state_23339__$1 = state_23339;
var statearr_23394_23465 = state_23339__$1;
(statearr_23394_23465[(2)] = inst_23195);

(statearr_23394_23465[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (11))){
var inst_23167 = (state_23339[(2)]);
var inst_23168 = fluree.db.util.log.error.call(null,inst_23167);
var inst_23169 = (function(){throw inst_23167})();
var state_23339__$1 = (function (){var statearr_23396 = state_23339;
(statearr_23396[(21)] = inst_23168);

return statearr_23396;
})();
var statearr_23397_23466 = state_23339__$1;
(statearr_23397_23466[(2)] = inst_23169);

(statearr_23397_23466[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (9))){
var _ = (function (){var statearr_23398 = state_23339;
(statearr_23398[(4)] = cljs.core.cons.call(null,(12),(state_23339[(4)])));

return statearr_23398;
})();
var inst_23175 = cljs.core.first.call(null,flakes);
var inst_23176 = fluree.db.flake.s.call(null,inst_23175);
var ___$1 = (function (){var statearr_23399 = state_23339;
(statearr_23399[(4)] = cljs.core.rest.call(null,(state_23339[(4)])));

return statearr_23399;
})();
var state_23339__$1 = state_23339;
var statearr_23400_23467 = state_23339__$1;
(statearr_23400_23467[(2)] = inst_23176);

(statearr_23400_23467[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (5))){
var _ = (function (){var statearr_23401 = state_23339;
(statearr_23401[(4)] = cljs.core.rest.call(null,(state_23339[(4)])));

return statearr_23401;
})();
var state_23339__$1 = state_23339;
var ex23395 = (state_23339__$1[(2)]);
var statearr_23402_23468 = state_23339__$1;
(statearr_23402_23468[(5)] = ex23395);


if((ex23395 instanceof Error)){
var statearr_23403_23469 = state_23339__$1;
(statearr_23403_23469[(1)] = (4));

(statearr_23403_23469[(5)] = null);

} else {
throw ex23395;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (14))){
var state_23339__$1 = state_23339;
var statearr_23404_23470 = state_23339__$1;
(statearr_23404_23470[(2)] = base_select_spec);

(statearr_23404_23470[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (45))){
var inst_23280 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
if(cljs.core.truth_(inst_23280)){
var statearr_23405_23471 = state_23339__$1;
(statearr_23405_23471[(1)] = (46));

} else {
var statearr_23406_23472 = state_23339__$1;
(statearr_23406_23472[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (26))){
var inst_23218 = (state_23339[(13)]);
var inst_23222 = cljs.core.empty_QMARK_.call(null,inst_23218);
var state_23339__$1 = state_23339;
if(inst_23222){
var statearr_23407_23473 = state_23339__$1;
(statearr_23407_23473[(1)] = (28));

} else {
var statearr_23408_23474 = state_23339__$1;
(statearr_23408_23474[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (16))){
var inst_23186 = (state_23339[(17)]);
var state_23339__$1 = state_23339;
var statearr_23409_23475 = state_23339__$1;
(statearr_23409_23475[(2)] = inst_23186);

(statearr_23409_23475[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (38))){
var inst_23218 = (state_23339[(13)]);
var inst_23253 = (state_23339[(2)]);
var inst_23254 = fluree.db.util.async.throw_err.call(null,inst_23253);
var inst_23255 = cljs.core.nth.call(null,inst_23254,(0),null);
var inst_23256 = cljs.core.nth.call(null,inst_23254,(1),null);
var inst_23257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23258 = cljs.core.rest.call(null,inst_23218);
var inst_23259 = [inst_23255,inst_23258,inst_23256];
var inst_23260 = (new cljs.core.PersistentVector(null,3,(5),inst_23257,inst_23259,null));
var state_23339__$1 = state_23339;
var statearr_23410_23476 = state_23339__$1;
(statearr_23410_23476[(2)] = inst_23260);

(statearr_23410_23476[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (30))){
var inst_23316 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
var statearr_23411_23477 = state_23339__$1;
(statearr_23411_23477[(2)] = inst_23316);

(statearr_23411_23477[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (10))){
var inst_23179 = (state_23339[(2)]);
var inst_23180 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23339__$1 = (function (){var statearr_23412 = state_23339;
(statearr_23412[(10)] = inst_23179);

return statearr_23412;
})();
if(cljs.core.truth_(inst_23180)){
var statearr_23413_23478 = state_23339__$1;
(statearr_23413_23478[(1)] = (13));

} else {
var statearr_23414_23479 = state_23339__$1;
(statearr_23414_23479[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (18))){
var inst_23191 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
if(cljs.core.truth_(inst_23191)){
var statearr_23415_23480 = state_23339__$1;
(statearr_23415_23480[(1)] = (19));

} else {
var statearr_23416_23481 = state_23339__$1;
(statearr_23416_23481[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (42))){
var inst_23220 = (state_23339[(12)]);
var inst_23264 = (state_23339[(16)]);
var inst_23218 = (state_23339[(13)]);
var inst_23267 = (state_23339[(2)]);
var inst_23268 = fluree.db.util.async.throw_err.call(null,inst_23267);
var inst_23269 = cljs.core.first.call(null,inst_23268);
var inst_23270 = cljs.core.rest.call(null,inst_23218);
var inst_23271 = [inst_23269,inst_23270,inst_23220];
var inst_23272 = (new cljs.core.PersistentVector(null,3,(5),inst_23264,inst_23271,null));
var state_23339__$1 = state_23339;
var statearr_23417_23482 = state_23339__$1;
(statearr_23417_23482[(2)] = inst_23272);

(statearr_23417_23482[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (37))){
var inst_23305 = (state_23339[(2)]);
var state_23339__$1 = state_23339;
var statearr_23418_23483 = state_23339__$1;
(statearr_23418_23483[(2)] = inst_23305);

(statearr_23418_23483[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (8))){
var inst_23334 = (state_23339[(2)]);
var _ = (function (){var statearr_23419 = state_23339;
(statearr_23419[(4)] = cljs.core.rest.call(null,(state_23339[(4)])));

return statearr_23419;
})();
var state_23339__$1 = state_23339;
var statearr_23420_23484 = state_23339__$1;
(statearr_23420_23484[(2)] = inst_23334);

(statearr_23420_23484[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23340 === (49))){
var inst_23219 = (state_23339[(11)]);
var inst_23220 = (state_23339[(12)]);
var inst_23218 = (state_23339[(13)]);
var inst_23293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23294 = cljs.core.rest.call(null,inst_23218);
var inst_23295 = [inst_23219,inst_23294,inst_23220];
var inst_23296 = (new cljs.core.PersistentVector(null,3,(5),inst_23293,inst_23295,null));
var state_23339__$1 = state_23339;
var statearr_23421_23485 = state_23339__$1;
(statearr_23421_23485[(2)] = inst_23296);

(statearr_23421_23485[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0 = (function (){
var statearr_23422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23422[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__);

(statearr_23422[(1)] = (1));

return statearr_23422;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1 = (function (state_23339){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23339);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23423){var ex__2749__auto__ = e23423;
var statearr_23424_23486 = state_23339;
(statearr_23424_23486[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23339[(4)]))){
var statearr_23425_23487 = state_23339;
(statearr_23425_23487[(1)] = cljs.core.first.call(null,(state_23339[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23488 = state_23339;
state_23339 = G__23488;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__ = function(state_23339){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1.call(this,state_23339);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23426 = f__2769__auto__.call(null);
(statearr_23426[(6)] = c__2768__auto__);

return statearr_23426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
