// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__19817_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19817_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19821 = coll;
var vec__19822 = G__19821;
var seq__19823 = cljs.core.seq.call(null,vec__19822);
var first__19824 = cljs.core.first.call(null,seq__19823);
var seq__19823__$1 = cljs.core.next.call(null,seq__19823);
var clause = first__19824;
var r = seq__19823__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19821__$1 = G__19821;
var res__$1 = res;
while(true){
var vec__19828 = G__19821__$1;
var seq__19829 = cljs.core.seq.call(null,vec__19828);
var first__19830 = cljs.core.first.call(null,seq__19829);
var seq__19829__$1 = cljs.core.next.call(null,seq__19829);
var clause__$1 = first__19830;
var r__$1 = seq__19829__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19831 = r__$1;
var G__19832 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19821__$1 = G__19831;
res__$1 = G__19832;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__19833){
var map__19834 = p__19833;
var map__19834__$1 = cljs.core.__destructure_map.call(null,map__19834);
var optional = cljs.core.get.call(null,map__19834__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19838 = coll;
var vec__19839 = G__19838;
var seq__19840 = cljs.core.seq.call(null,vec__19839);
var first__19841 = cljs.core.first.call(null,seq__19840);
var seq__19840__$1 = cljs.core.next.call(null,seq__19840);
var clause = first__19841;
var r = seq__19840__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19838__$1 = G__19838;
var res__$1 = res;
while(true){
var vec__19845 = G__19838__$1;
var seq__19846 = cljs.core.seq.call(null,vec__19845);
var first__19847 = cljs.core.first.call(null,seq__19846);
var seq__19846__$1 = cljs.core.next.call(null,seq__19846);
var clause__$1 = first__19847;
var r__$1 = seq__19846__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19848 = r__$1;
var G__19849 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__19838__$1 = G__19848;
res__$1 = G__19849;
continue;
} else {
var G__19850 = r__$1;
var G__19851 = res__$2;
G__19838__$1 = G__19850;
res__$1 = G__19851;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19855 = coll;
var vec__19856 = G__19855;
var seq__19857 = cljs.core.seq.call(null,vec__19856);
var first__19858 = cljs.core.first.call(null,seq__19857);
var seq__19857__$1 = cljs.core.next.call(null,seq__19857);
var clause = first__19858;
var r = seq__19857__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19855__$1 = G__19855;
var res__$1 = res;
while(true){
var vec__19862 = G__19855__$1;
var seq__19863 = cljs.core.seq.call(null,vec__19862);
var first__19864 = cljs.core.first.call(null,seq__19863);
var seq__19863__$1 = cljs.core.next.call(null,seq__19863);
var clause__$1 = first__19864;
var r__$1 = seq__19863__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__19865 = r__$1;
var G__19866 = res__$2;
G__19855__$1 = G__19865;
res__$1 = G__19866;
continue;
} else {
var G__19867 = r__$1;
var G__19868 = cljs.core.conj.call(null,res__$2,clause__$1);
G__19855__$1 = G__19867;
res__$1 = G__19868;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19871 = clause;
var G__19871__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__19871):G__19871);
var G__19871__$2 = clojure.string.join.call(null," ",G__19871__$1)
;
var G__19871__$3 = (function (p1__19869_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19869_SHARP_)," ."].join('');
}).call(null,G__19871__$2)
;
if(cljs.core.truth_(optional_QMARK_)){
return (function (p1__19870_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19870_SHARP_),"}"].join('');
}).call(null,G__19871__$3);
} else {
return G__19871__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__19875 = opts;
var map__19875__$1 = cljs.core.__destructure_map.call(null,map__19875);
var limit = cljs.core.get.call(null,map__19875__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__19875__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__19875__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__19875__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__19875__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__19872_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19872_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19873_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19873_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__19874_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__19874_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19889){
var state_val_19890 = (state_19889[(1)]);
if((state_val_19890 === (1))){
var inst_19876 = fluree.db.util.core.url_encode.call(null,query);
var inst_19877 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19876)].join('');
var inst_19878 = ["User-Agent","Accept"];
var inst_19879 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19880 = cljs.core.PersistentHashMap.fromArrays(inst_19878,inst_19879);
var inst_19881 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19882 = [inst_19880,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19883 = cljs.core.PersistentHashMap.fromArrays(inst_19881,inst_19882);
var inst_19884 = fluree.db.util.xhttp.get.call(null,inst_19877,inst_19883);
var state_19889__$1 = state_19889;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19889__$1,(2),inst_19884);
} else {
if((state_val_19890 === (2))){
var inst_19886 = (state_19889[(2)]);
var inst_19887 = fluree.db.util.async.throw_err.call(null,inst_19886);
var state_19889__$1 = state_19889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19889__$1,inst_19887);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19891 = [null,null,null,null,null,null,null];
(statearr_19891[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__);

(statearr_19891[(1)] = (1));

return statearr_19891;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19889){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19892){var ex__2749__auto__ = e19892;
var statearr_19893_19896 = state_19889;
(statearr_19893_19896[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19889[(4)]))){
var statearr_19894_19897 = state_19889;
(statearr_19894_19897[(1)] = cljs.core.first.call(null,(state_19889[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19898 = state_19889;
state_19889 = G__19898;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__ = function(state_19889){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19895 = f__2769__auto__.call(null);
(statearr_19895[(6)] = c__2768__auto__);

return statearr_19895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19916){
var state_val_19917 = (state_19916[(1)]);
if((state_val_19917 === (1))){
var inst_19899 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_19916__$1 = state_19916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19916__$1,(2),inst_19899);
} else {
if((state_val_19917 === (2))){
var inst_19902 = (state_19916[(7)]);
var inst_19901 = (state_19916[(2)]);
var inst_19902__$1 = fluree.db.util.async.throw_err.call(null,inst_19901);
var inst_19903 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_19902__$1);
var inst_19904 = cljs.core.not_EQ_.call(null,(200),inst_19903);
var state_19916__$1 = (function (){var statearr_19918 = state_19916;
(statearr_19918[(7)] = inst_19902__$1);

return statearr_19918;
})();
if(inst_19904){
var statearr_19919_19928 = state_19916__$1;
(statearr_19919_19928[(1)] = (3));

} else {
var statearr_19920_19929 = state_19916__$1;
(statearr_19920_19929[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19917 === (3))){
var inst_19902 = (state_19916[(7)]);
var state_19916__$1 = state_19916;
var statearr_19921_19930 = state_19916__$1;
(statearr_19921_19930[(2)] = inst_19902);

(statearr_19921_19930[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19917 === (4))){
var inst_19902 = (state_19916[(7)]);
var inst_19907 = (function (){var body = inst_19902;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_19908 = cljs.core.second.call(null,inst_19902);
var inst_19909 = cljs.core.second.call(null,inst_19908);
var inst_19910 = cljs.core.first.call(null,inst_19909);
var inst_19911 = cljs.core.second.call(null,inst_19910);
var inst_19912 = cljs.core.mapv.call(null,inst_19907,inst_19911);
var state_19916__$1 = state_19916;
var statearr_19922_19931 = state_19916__$1;
(statearr_19922_19931[(2)] = inst_19912);

(statearr_19922_19931[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19917 === (5))){
var inst_19914 = (state_19916[(2)]);
var state_19916__$1 = state_19916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19916__$1,inst_19914);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0 = (function (){
var statearr_19923 = [null,null,null,null,null,null,null,null];
(statearr_19923[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__);

(statearr_19923[(1)] = (1));

return statearr_19923;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1 = (function (state_19916){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e19924){var ex__2749__auto__ = e19924;
var statearr_19925_19932 = state_19916;
(statearr_19925_19932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19916[(4)]))){
var statearr_19926_19933 = state_19916;
(statearr_19926_19933[(1)] = cljs.core.first.call(null,(state_19916[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19934 = state_19916;
state_19916 = G__19934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__ = function(state_19916){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1.call(this,state_19916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_19927 = f__2769__auto__.call(null);
(statearr_19927[(6)] = c__2768__auto__);

return statearr_19927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__19935_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19935_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__19936_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19936_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__19937_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__19937_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_19983){
var state_val_19984 = (state_19983[(1)]);
if((state_val_19984 === (7))){
var inst_19948 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_19983__$1 = state_19983;
var statearr_19985_20013 = state_19983__$1;
(statearr_19985_20013[(2)] = inst_19948);

(statearr_19985_20013[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (1))){
var state_19983__$1 = state_19983;
var statearr_19986_20014 = state_19983__$1;
(statearr_19986_20014[(2)] = null);

(statearr_19986_20014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (4))){
var inst_19938 = (state_19983[(2)]);
var state_19983__$1 = state_19983;
var statearr_19987_20015 = state_19983__$1;
(statearr_19987_20015[(2)] = inst_19938);

(statearr_19987_20015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (15))){
var inst_19957 = (state_19983[(7)]);
var inst_19962 = (state_19983[(8)]);
var inst_19956 = (state_19983[(9)]);
var inst_19967 = (state_19983[(2)]);
var inst_19968 = cljs.core.subs.call(null,inst_19962,(0),inst_19967);
var inst_19969 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19970 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_19956);
var inst_19971 = [inst_19957,inst_19970];
var inst_19972 = cljs.core.PersistentHashMap.fromArrays(inst_19969,inst_19971);
var inst_19973 = cljs.core.ex_info.call(null,inst_19968,inst_19972);
var inst_19974 = (function(){throw inst_19973})();
var state_19983__$1 = state_19983;
var statearr_19988_20016 = state_19983__$1;
(statearr_19988_20016[(2)] = inst_19974);

(statearr_19988_20016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (13))){
var inst_19961 = (state_19983[(10)]);
var state_19983__$1 = state_19983;
var statearr_19989_20017 = state_19983__$1;
(statearr_19989_20017[(2)] = inst_19961);

(statearr_19989_20017[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (6))){
var state_19983__$1 = state_19983;
var statearr_19990_20018 = state_19983__$1;
(statearr_19990_20018[(2)] = null);

(statearr_19990_20018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (3))){
var inst_19981 = (state_19983[(2)]);
var state_19983__$1 = state_19983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19983__$1,inst_19981);
} else {
if((state_val_19984 === (12))){
var inst_19978 = (state_19983[(2)]);
var _ = (function (){var statearr_19991 = state_19983;
(statearr_19991[(4)] = cljs.core.rest.call(null,(state_19983[(4)])));

return statearr_19991;
})();
var state_19983__$1 = state_19983;
var statearr_19992_20019 = state_19983__$1;
(statearr_19992_20019[(2)] = inst_19978);

(statearr_19992_20019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (2))){
var _ = (function (){var statearr_19993 = state_19983;
(statearr_19993[(4)] = cljs.core.cons.call(null,(5),(state_19983[(4)])));

return statearr_19993;
})();
var inst_19945 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_19983__$1 = state_19983;
if(inst_19945){
var statearr_19994_20020 = state_19983__$1;
(statearr_19994_20020[(1)] = (6));

} else {
var statearr_19995_20021 = state_19983__$1;
(statearr_19995_20021[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (11))){
var inst_19956 = (state_19983[(9)]);
var inst_19976 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_19956,all_vars);
var state_19983__$1 = state_19983;
var statearr_19997_20022 = state_19983__$1;
(statearr_19997_20022[(2)] = inst_19976);

(statearr_19997_20022[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (9))){
var inst_19957 = (state_19983[(7)]);
var inst_19956 = (state_19983[(9)]);
var inst_19954 = (state_19983[(2)]);
var inst_19955 = fluree.db.util.async.throw_err.call(null,inst_19954);
var inst_19956__$1 = cljs.core.__destructure_map.call(null,inst_19955);
var inst_19957__$1 = cljs.core.get.call(null,inst_19956__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_19958 = cljs.core.get.call(null,inst_19956__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_19959 = cljs.core._EQ_.call(null,(400),inst_19957__$1);
var state_19983__$1 = (function (){var statearr_19998 = state_19983;
(statearr_19998[(7)] = inst_19957__$1);

(statearr_19998[(11)] = inst_19958);

(statearr_19998[(9)] = inst_19956__$1);

return statearr_19998;
})();
if(inst_19959){
var statearr_19999_20023 = state_19983__$1;
(statearr_19999_20023[(1)] = (10));

} else {
var statearr_20000_20024 = state_19983__$1;
(statearr_20000_20024[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (5))){
var _ = (function (){var statearr_20001 = state_19983;
(statearr_20001[(4)] = cljs.core.rest.call(null,(state_19983[(4)])));

return statearr_20001;
})();
var state_19983__$1 = state_19983;
var ex19996 = (state_19983__$1[(2)]);
var statearr_20002_20025 = state_19983__$1;
(statearr_20002_20025[(5)] = ex19996);


if((ex19996 instanceof Error)){
var statearr_20003_20026 = state_19983__$1;
(statearr_20003_20026[(1)] = (4));

(statearr_20003_20026[(5)] = null);

} else {
throw ex19996;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (14))){
var state_19983__$1 = state_19983;
var statearr_20004_20027 = state_19983__$1;
(statearr_20004_20027[(2)] = (1000));

(statearr_20004_20027[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (10))){
var inst_19958 = (state_19983[(11)]);
var inst_19961 = (state_19983[(10)]);
var inst_19956 = (state_19983[(9)]);
var inst_19961__$1 = cljs.core.count.call(null,inst_19958);
var inst_19962 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_19956);
var inst_19963 = (inst_19961__$1 < (1000));
var state_19983__$1 = (function (){var statearr_20005 = state_19983;
(statearr_20005[(8)] = inst_19962);

(statearr_20005[(10)] = inst_19961__$1);

return statearr_20005;
})();
if(cljs.core.truth_(inst_19963)){
var statearr_20006_20028 = state_19983__$1;
(statearr_20006_20028[(1)] = (13));

} else {
var statearr_20007_20029 = state_19983__$1;
(statearr_20007_20029[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19984 === (8))){
var inst_19950 = (state_19983[(2)]);
var inst_19951 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_19950,optional_clauses);
var inst_19952 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_19951);
var state_19983__$1 = state_19983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19983__$1,(9),inst_19952);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0 = (function (){
var statearr_20008 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20008[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__);

(statearr_20008[(1)] = (1));

return statearr_20008;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1 = (function (state_19983){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_19983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e20009){var ex__2749__auto__ = e20009;
var statearr_20010_20030 = state_19983;
(statearr_20010_20030[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_19983[(4)]))){
var statearr_20011_20031 = state_19983;
(statearr_20011_20031[(1)] = cljs.core.first.call(null,(state_19983[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20032 = state_19983;
state_19983 = G__20032;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__ = function(state_19983){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1.call(this,state_19983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_20012 = f__2769__auto__.call(null);
(statearr_20012[(6)] = c__2768__auto__);

return statearr_20012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
