// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_parse');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.subject_crawl.legacy');
goog.require('fluree.db.query.subject_crawl.reparse');
fluree.db.query.analytical_parse.read_str_fn = cljs.reader.read_string;
fluree.db.query.analytical_parse.safe_read_fn = (function fluree$db$query$analytical_parse$safe_read_fn(code_str){
if(typeof code_str === 'string'){
} else {
throw cljs.core.ex_info.call(null,code_str.call(null,"Invalid function: ",code_str),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

try{var code_str_STAR_ = ((clojure.string.starts_with_QMARK_.call(null,code_str,"#"))?cljs.core.subs.call(null,code_str,(1)):code_str);
var res = fluree.db.query.analytical_parse.read_str_fn.call(null,code_str_STAR_);
if(cljs.core.list_QMARK_.call(null,res)){
} else {
throw cljs.core.ex_info.call(null,code_str.call(null,"Invalid function: ",code_str),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return res;
}catch (e18650){var e = e18650;
fluree.db.util.log.warn.call(null,"Invalid query function attempted: ",code_str," with error message: ",cljs.core.ex_message.call(null,e));

throw cljs.core.ex_info.call(null,code_str.call(null,"Invalid query function: ",code_str),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}});
fluree.db.query.analytical_parse.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical_parse$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical_parse$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical_parse$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__18656 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__18656 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__18656;
}
});
var variance = (function fluree$db$query$analytical_parse$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__5523__auto__ = (function fluree$db$query$analytical_parse$variance_$_iter__18657(s__18658){
return (new cljs.core.LazySeq(null,(function (){
var s__18658__$1 = s__18658;
while(true){
var temp__5804__auto__ = cljs.core.seq.call(null,s__18658__$1);
if(temp__5804__auto__){
var s__18658__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18658__$2)){
var c__5521__auto__ = cljs.core.chunk_first.call(null,s__18658__$2);
var size__5522__auto__ = cljs.core.count.call(null,c__5521__auto__);
var b__18660 = cljs.core.chunk_buffer.call(null,size__5522__auto__);
if((function (){var i__18659 = (0);
while(true){
if((i__18659 < size__5522__auto__)){
var x = cljs.core._nth.call(null,c__5521__auto__,i__18659);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__18660,(delta * delta));

var G__18661 = (i__18659 + (1));
i__18659 = G__18661;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18660),fluree$db$query$analytical_parse$variance_$_iter__18657.call(null,cljs.core.chunk_rest.call(null,s__18658__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18660),null);
}
} else {
var x = cljs.core.first.call(null,s__18658__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical_parse$variance_$_iter__18657.call(null,cljs.core.rest.call(null,s__18658__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical_parse$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__18662 = null;
var G__18662__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__18662__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18662 = function(n,coll){
switch(arguments.length){
case 1:
return G__18662__1.call(this,n);
case 2:
return G__18662__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18662.cljs$core$IFn$_invoke$arity$1 = G__18662__1;
G__18662.cljs$core$IFn$_invoke$arity$2 = G__18662__2;
return G__18662;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__18663 = null;
var G__18663__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__18663__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18663 = function(n,coll){
switch(arguments.length){
case 1:
return G__18663__1.call(this,n);
case 2:
return G__18663__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18663.cljs$core$IFn$_invoke$arity$1 = G__18663__1;
G__18663.cljs$core$IFn$_invoke$arity$2 = G__18663__2;
return G__18663;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__18664 = null;
var G__18664__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__18664__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__18664 = function(n,coll){
switch(arguments.length){
case 1:
return G__18664__1.call(this,n);
case 2:
return G__18664__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18664.cljs$core$IFn$_invoke$arity$1 = G__18664__1;
G__18664.cljs$core$IFn$_invoke$arity$2 = G__18664__2;
return G__18664;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
/**
 * Aggregate as positioned in a :select statement
 */
fluree.db.query.analytical_parse.aggregate_QMARK_ = (function fluree$db$query$analytical_parse$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Query function as positioned in a :where statement
 */
fluree.db.query.analytical_parse.query_fn_QMARK_ = (function fluree$db$query$analytical_parse$query_fn_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns a query variable as a symbol, else nil if not a query variable.
 */
fluree.db.query.analytical_parse.q_var__GT_symbol = (function fluree$db$query$analytical_parse$q_var__GT_symbol(x){
if((((x instanceof cljs.core.Keyword)) || (((((typeof x === 'string') && (cljs.core._EQ_.call(null,"?",cljs.core.first.call(null,x))))) || ((((x instanceof cljs.core.Symbol)) && (cljs.core._EQ_.call(null,"?",cljs.core.first.call(null,cljs.core.name.call(null,x)))))))))){
return cljs.core.symbol.call(null,x);
} else {
return null;
}
});
/**
 * Returns as var symbol if 'as' function is used in an aggregate,
 *   e.g. (as (sum ?nums) ?sum).
 * 
 *   Checks that has 3 elements to the form, and the last element
 *   is a symbol that starts with a '?'. Else will throw.
 */
fluree.db.query.analytical_parse.extract_aggregate_as = (function fluree$db$query$analytical_parse$extract_aggregate_as(as_fn_parsed){
if(((cljs.core._EQ_.call(null,(3),cljs.core.count.call(null,as_fn_parsed))) && ((cljs.core.last.call(null,as_fn_parsed) instanceof cljs.core.Symbol)))){
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate function using 'as': ",cljs.core.pr_str.call(null,as_fn_parsed)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return cljs.core.last.call(null,as_fn_parsed);
});
fluree.db.query.analytical_parse.parse_aggregate_STAR_ = (function fluree$db$query$analytical_parse$parse_aggregate_STAR_(fn_parsed,fn_str,as){
var list_count = cljs.core.count.call(null,fn_parsed);
var vec__18665 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,fn_parsed),cljs.core.second.call(null,fn_parsed),cljs.core.last.call(null,fn_parsed)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,fn_parsed)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,fn_parsed),null,cljs.core.last.call(null,fn_parsed)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__18665,(0),null);
var arg = cljs.core.nth.call(null,vec__18665,(1),null);
var var$ = cljs.core.nth.call(null,vec__18665,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = fluree.db.query.analytical_parse.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__18668 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__18668,(0),null);
var variable = cljs.core.nth.call(null,vec__18668,(1),null);
var as_SINGLEQUOTE_ = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fun)].join(''));
}
})();
if((((variable instanceof cljs.core.Symbol)) && (cljs.core._EQ_.call(null,"?",cljs.core.first.call(null,cljs.core.name.call(null,variable)))))){
} else {
throw cljs.core.ex_info.call(null,["Variables used in aggregate functions must start with a '?'. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as_SINGLEQUOTE_,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses an aggregate function string and returns map with keys:
 *   :variable - input variable symbol
 *   :as - return variable/binding name
 *   :fn-str - original function string, for use in reporting errors
 *   :function - executable function.
 */
fluree.db.query.analytical_parse.parse_aggregate = (function fluree$db$query$analytical_parse$parse_aggregate(aggregate_fn_str){
var list_agg = fluree.db.query.analytical_parse.safe_read_fn.call(null,aggregate_fn_str);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var func_list = ((as_QMARK_)?cljs.core.second.call(null,list_agg):list_agg);
var _ = ((cljs.core.coll_QMARK_.call(null,func_list))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(aggregate_fn_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var as = ((as_QMARK_)?fluree.db.query.analytical_parse.extract_aggregate_as.call(null,list_agg):null);
return fluree.db.query.analytical_parse.parse_aggregate_STAR_.call(null,func_list,aggregate_fn_str,as);
});
/**
 * Returns true if provided variable exists as a variable
 *   somewhere within the where clause.
 */
fluree.db.query.analytical_parse.variable_in_where_QMARK_ = (function fluree$db$query$analytical_parse$variable_in_where_QMARK_(variable,where){
fluree.db.util.log.debug.call(null,"variable-in-where? variable:",variable,"where:",where);

return cljs.core.some.call(null,(function (p__18671){
var map__18672 = p__18671;
var map__18672__$1 = cljs.core.__destructure_map.call(null,map__18672);
var where_smt = map__18672__$1;
var s = cljs.core.get.call(null,map__18672__$1,new cljs.core.Keyword(null,"s","s",1705939918));
var o = cljs.core.get.call(null,map__18672__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var type = cljs.core.get.call(null,map__18672__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var or__5045__auto__ = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o),variable);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s),variable);
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
var G__18673 = type;
var G__18673__$1 = (((G__18673 instanceof cljs.core.Keyword))?G__18673.fqn:null);
switch (G__18673__$1) {
case "optional":
return fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(where_smt));

break;
case "binding":
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(where_smt),variable);

break;
case "union":
var or__5045__auto____$2 = fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,cljs.core.first.call(null,new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(where_smt)));
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,cljs.core.second.call(null,new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(where_smt)));
}

break;
default:
return null;

}
}
}
}),where);
});
fluree.db.query.analytical_parse.parse_map = (function fluree$db$query$analytical_parse$parse_map(select_map){
var vec__18675 = cljs.core.first.call(null,select_map);
var var$ = cljs.core.nth.call(null,vec__18675,(0),null);
var selection = cljs.core.nth.call(null,vec__18675,(1),null);
var var_as_symbol = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,var$);
if(((cljs.core.not_EQ_.call(null,(1),cljs.core.count.call(null,select_map))) || ((var_as_symbol == null)))){
throw cljs.core.ex_info.call(null,["Invalid select statement, maps must have only one key/val. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_map)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),selection], null);
});
/**
 * Returns two-tuple of [params updated-code]
 *   where params are the function parameters and updated-code is a revised version of
 *   code-parsed where all functions within the code are mapped to actual executable functions.
 */
fluree.db.query.analytical_parse.parse_having_code = (function fluree$db$query$analytical_parse$parse_having_code(code_parsed,code_string){
var vec__18678 = code_parsed;
var seq__18679 = cljs.core.seq.call(null,vec__18678);
var first__18680 = cljs.core.first.call(null,seq__18679);
var seq__18679__$1 = cljs.core.next.call(null,seq__18679);
var form_f = first__18680;
var form_r = seq__18679__$1;
var form_f_SINGLEQUOTE_ = (function (){var or__5045__auto__ = cljs.core.get.call(null,fluree.db.query.analytical_parse.built_in_aggregates,form_f);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,fluree.db.query.analytical_filter.filter_fns_with_ns,cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_f));
}
})();
var vars = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.filter.call(null,cljs.core.symbol_QMARK_,form_r));
var G__18684 = form_r;
var vec__18685 = G__18684;
var seq__18686 = cljs.core.seq.call(null,vec__18685);
var first__18687 = cljs.core.first.call(null,seq__18686);
var seq__18686__$1 = cljs.core.next.call(null,seq__18686);
var form_next = first__18687;
var form_rest = seq__18686__$1;
var vars_STAR_ = vars;
var acc = cljs.core.PersistentVector.EMPTY;
var G__18684__$1 = G__18684;
var vars_STAR___$1 = vars_STAR_;
var acc__$1 = acc;
while(true){
var vec__18694 = G__18684__$1;
var seq__18695 = cljs.core.seq.call(null,vec__18694);
var first__18696 = cljs.core.first.call(null,seq__18695);
var seq__18695__$1 = cljs.core.next.call(null,seq__18695);
var form_next__$1 = first__18696;
var form_rest__$1 = seq__18695__$1;
var vars_STAR___$2 = vars_STAR___$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(form_next__$1)){
var vec__18697 = ((cljs.core.list_QMARK_.call(null,form_next__$1))?fluree.db.query.analytical_parse.parse_having_code.call(null,form_next__$1,code_string):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,(((form_next__$1 instanceof cljs.core.Symbol))?(((!(clojure.string.starts_with_QMARK_.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_next__$1),"?"))))?(function(){throw cljs.core.ex_info.call(null,["Invalid variable name '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_next__$1),"' in having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_string),". All vars must start with '?'."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():form_next__$1):((typeof form_next__$1 === 'string')?form_next__$1:((cljs.core.boolean_QMARK_.call(null,form_next__$1))?form_next__$1:((typeof form_next__$1 === 'number')?form_next__$1:(function(){throw cljs.core.ex_info.call(null,["Invalid having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_string),". Only scalar types allowed besides functions: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(form_next__$1),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
))))], null));
var params = cljs.core.nth.call(null,vec__18697,(0),null);
var item = cljs.core.nth.call(null,vec__18697,(1),null);
var vars_STAR__STAR_ = (cljs.core.truth_(params)?cljs.core.into.call(null,vars_STAR___$2,params):vars_STAR___$2);
var G__18700 = form_rest__$1;
var G__18701 = vars_STAR__STAR_;
var G__18702 = cljs.core.conj.call(null,acc__$2,item);
G__18684__$1 = G__18700;
vars_STAR___$1 = G__18701;
acc__$1 = G__18702;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.vec.call(null,vars_STAR___$2),cljs.core.cons.call(null,form_f_SINGLEQUOTE_,acc__$2)], null);
}
break;
}
});
fluree.db.query.analytical_parse.parse_having = (function fluree$db$query$analytical_parse$parse_having(having){
if(cljs.core.truth_(fluree.db.query.analytical_parse.aggregate_QMARK_.call(null,having))){
} else {
throw cljs.core.ex_info.call(null,["Invalid 'having' statement aggregate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(having)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var code = fluree.db.query.analytical_parse.safe_read_fn.call(null,having);
var vec__18703 = fluree.db.query.analytical_parse.parse_having_code.call(null,code,having);
var params = cljs.core.nth.call(null,vec__18703,(0),null);
var code_STAR_ = cljs.core.nth.call(null,vec__18703,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),null,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code)].join(''),new cljs.core.Keyword(null,"function","function",-2127255473),fluree.db.query.analytical_filter.make_executable.call(null,params,code_STAR_)], null);
});
fluree.db.query.analytical_parse.parse_select = (function fluree$db$query$analytical_parse$parse_select(select_smt){
var _ = (function (){var or__5045__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__18706_SHARP_){
return ((typeof p1__18706_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__18706_SHARP_)));
}),select_smt);
if(or__5045__auto__){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
return cljs.core.map.call(null,(function (select){
var var_symbol = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,select);
if(cljs.core.truth_(var_symbol)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical_parse.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical_parse.parse_aggregate.call(null,select);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.analytical_parse.parse_map.call(null,select);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}),select_smt);
});
fluree.db.query.analytical_parse.add_select_spec = (function fluree$db$query$analytical_parse$add_select_spec(p__18709,p__18710){
var map__18711 = p__18709;
var map__18711__$1 = cljs.core.__destructure_map.call(null,map__18711);
var parsed_query = map__18711__$1;
var group_by = cljs.core.get.call(null,map__18711__$1,new cljs.core.Keyword(null,"group-by","group-by",-379139802));
var order_by = cljs.core.get.call(null,map__18711__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var limit = cljs.core.get.call(null,map__18711__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__18711__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var pretty_print = cljs.core.get.call(null,map__18711__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var map__18712 = p__18710;
var map__18712__$1 = cljs.core.__destructure_map.call(null,map__18712);
var _query_map_SINGLEQUOTE_ = map__18712__$1;
var selectOne = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var opts = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var orderBy = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var having = cljs.core.get.call(null,map__18712__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var select_smt = (function (){var or__5045__auto__ = selectOne;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = select;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var selectOne_QMARK_ = cljs.core.boolean$.call(null,selectOne);
var limit_STAR_ = ((selectOne_QMARK_)?(1):limit);
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.analytical_parse.parse_select.call(null,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__18707_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__18707_SHARP_,new cljs.core.Keyword(null,"function","function",-2127255473));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__18708_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__18708_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var orderBy_STAR_ = (function (){var temp__5804__auto__ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return orderBy;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var orderBy__$1 = temp__5804__auto__;
if(cljs.core.truth_((function (){var or__5045__auto__ = typeof orderBy__$1 === 'string';
if(or__5045__auto__){
return or__5045__auto__;
} else {
var and__5043__auto__ = cljs.core.vector_QMARK_.call(null,orderBy__$1);
if(and__5043__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy__$1));
} else {
return and__5043__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy__$1)){
return orderBy__$1;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy__$1], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
var having_STAR_ = (function (){var or__5045__auto__ = having;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"having","having",-399543166).cljs$core$IFn$_invoke$arity$1(opts);
}
})();
var having_parsed = (cljs.core.truth_(having_STAR_)?fluree.db.query.analytical_parse.parse_having.call(null,having_STAR_):null);
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"limit","limit",-1355822363),limit_STAR_,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),selectOne_QMARK_,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"having","having",-399543166),new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[having_parsed,expandMap_QMARK_,new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(opts),limit_STAR_,(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),cljs.core.not_empty.call(null,aggregates),selectOne_QMARK_,pretty_print,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return groupBy;
}
})(),cljs.core.boolean$.call(null,(function (){var or__5045__auto__ = selectDistinct;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy_STAR_,inVector_QMARK_]));
});
/**
 * Turns keys of var maps into symbols
 */
fluree.db.query.analytical_parse.symbolize_var_keys = (function fluree$db$query$analytical_parse$symbolize_var_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Adds a valid filter fn into the respective where statement(s).
 *   If the filter fn uses a var not found in a where statement, throws
 *   an exception
 */
fluree.db.query.analytical_parse.add_filter_where = (function fluree$db$query$analytical_parse$add_filter_where(where,p__18713){
var map__18714 = p__18713;
var map__18714__$1 = cljs.core.__destructure_map.call(null,map__18714);
var filter_fn_map = map__18714__$1;
var variable = cljs.core.get.call(null,map__18714__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var G__18719 = where;
var vec__18720 = G__18719;
var seq__18721 = cljs.core.seq.call(null,vec__18720);
var first__18722 = cljs.core.first.call(null,seq__18721);
var seq__18721__$1 = cljs.core.next.call(null,seq__18721);
var map__18723 = first__18722;
var map__18723__$1 = cljs.core.__destructure_map.call(null,map__18723);
var where_smt = map__18723__$1;
var o = cljs.core.get.call(null,map__18723__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r = seq__18721__$1;
var found_var_QMARK_ = false;
var where_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__18719__$1 = G__18719;
var found_var_QMARK___$1 = found_var_QMARK_;
var where_STAR___$1 = where_STAR_;
while(true){
var vec__18728 = G__18719__$1;
var seq__18729 = cljs.core.seq.call(null,vec__18728);
var first__18730 = cljs.core.first.call(null,seq__18729);
var seq__18729__$1 = cljs.core.next.call(null,seq__18729);
var map__18731 = first__18730;
var map__18731__$1 = cljs.core.__destructure_map.call(null,map__18731);
var where_smt__$1 = map__18731__$1;
var o__$1 = cljs.core.get.call(null,map__18731__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var r__$1 = seq__18729__$1;
var found_var_QMARK___$2 = found_var_QMARK___$1;
var where_STAR___$2 = where_STAR___$1;
if(cljs.core.truth_(where_smt__$1)){
var match_QMARK_ = cljs.core._EQ_.call(null,variable,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o__$1));
if(match_QMARK_){
var G__18732 = r__$1;
var G__18733 = true;
var G__18734 = cljs.core.conj.call(null,where_STAR___$2,cljs.core.assoc.call(null,where_smt__$1,new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"filter","filter",-948537934),filter_fn_map], null)));
G__18719__$1 = G__18732;
found_var_QMARK___$1 = G__18733;
where_STAR___$1 = G__18734;
continue;
} else {
var G__18735 = r__$1;
var G__18736 = found_var_QMARK___$2;
var G__18737 = cljs.core.conj.call(null,where_STAR___$2,where_smt__$1);
G__18719__$1 = G__18735;
found_var_QMARK___$1 = G__18736;
where_STAR___$1 = G__18737;
continue;
}
} else {
if(found_var_QMARK___$2){
return where_STAR___$2;
} else {
throw cljs.core.ex_info.call(null,["Filter function uses variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable)," however that variable is not used in a where statement ","or was already used in another filter function."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}
break;
}
});
/**
 * Returns a set of valid vars.
 */
fluree.db.query.analytical_parse.get_vars = (function fluree$db$query$analytical_parse$get_vars(code){
return cljs.core.reduce.call(null,(function (acc,code_segment){
if(cljs.core.coll_QMARK_.call(null,code_segment)){
return cljs.core.into.call(null,acc,fluree.db.query.analytical_parse.get_vars.call(null,code_segment));
} else {
var temp__5802__auto__ = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,code_segment);
if(cljs.core.truth_(temp__5802__auto__)){
var allowed_var = temp__5802__auto__;
return cljs.core.conj.call(null,acc,allowed_var);
} else {
return acc;
}
}
}),cljs.core.PersistentHashSet.EMPTY,code);
});
/**
 * Returns the var that will represent flake/o when passed in a flake to execute filter fn.
 * 
 *   There can be multiple vars in the filter function which can utilize the original query's 'vars' map,
 *   however there should be exactly one var in the filter fn that isn't in that map - which should be the
 *   var that will receive flake/o.
 */
fluree.db.query.analytical_parse.get_object_var = (function fluree$db$query$analytical_parse$get_object_var(params,all_vars){
var non_assigned_vars = cljs.core.remove.call(null,(function (p1__18738_SHARP_){
return cljs.core.contains_QMARK_.call(null,all_vars,p1__18738_SHARP_);
}),params);
var G__18739 = cljs.core.count.call(null,non_assigned_vars);
switch (G__18739) {
case (1):
return cljs.core.first.call(null,non_assigned_vars);

break;
case (0):
throw cljs.core.ex_info.call(null,["Query filter function has no variable assigned to it, all parameters ","exist in the 'vars' map. Filter function params: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params),". ","Vars assigned in query: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(all_vars),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

break;
default:
throw cljs.core.ex_info.call(null,["Vars used in a filter function are not included in the 'vars' map ","or as a binding. Should only be missing one var, but missing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.vec.call(null,non_assigned_vars)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
});
/**
 * Evals, and returns query function.
 */
fluree.db.query.analytical_parse.parse_filter_fn = (function fluree$db$query$analytical_parse$parse_filter_fn(filter_fn,all_vars){
var filter_code = fluree.db.query.analytical_parse.safe_read_fn.call(null,filter_fn);
var fn_vars = (function (){var or__5045__auto__ = cljs.core.not_empty.call(null,fluree.db.query.analytical_parse.get_vars.call(null,filter_code));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var params = cljs.core.vec.call(null,fn_vars);
var o_var = fluree.db.query.analytical_parse.get_object_var.call(null,params,all_vars);
var vec__18741 = fluree.db.query.analytical_filter.extract_filter_fn.call(null,filter_code,fn_vars);
var fun = cljs.core.nth.call(null,vec__18741,(0),null);
var _ = cljs.core.nth.call(null,vec__18741,(1),null);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),o_var,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),["(fn ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(params)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fun)].join(''),new cljs.core.Keyword(null,"function","function",-2127255473),fluree.db.query.analytical_filter.make_executable.call(null,params,fun)], null);
});
fluree.db.query.analytical_parse.add_filter = (function fluree$db$query$analytical_parse$add_filter(p__18744,filter,all_vars){
var map__18745 = p__18744;
var map__18745__$1 = cljs.core.__destructure_map.call(null,map__18745);
var parsed_query = map__18745__$1;
var where = cljs.core.get.call(null,map__18745__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
if((!(cljs.core.sequential_QMARK_.call(null,filter)))){
throw cljs.core.ex_info.call(null,["Filter clause must be a vector/array, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var G__18749 = filter;
var vec__18750 = G__18749;
var seq__18751 = cljs.core.seq.call(null,vec__18750);
var first__18752 = cljs.core.first.call(null,seq__18751);
var seq__18751__$1 = cljs.core.next.call(null,seq__18751);
var filter_fn = first__18752;
var r = seq__18751__$1;
var parsed_query_STAR_ = parsed_query;
var G__18749__$1 = G__18749;
var parsed_query_STAR___$1 = parsed_query_STAR_;
while(true){
var vec__18756 = G__18749__$1;
var seq__18757 = cljs.core.seq.call(null,vec__18756);
var first__18758 = cljs.core.first.call(null,seq__18757);
var seq__18757__$1 = cljs.core.next.call(null,seq__18757);
var filter_fn__$1 = first__18758;
var r__$1 = seq__18757__$1;
var parsed_query_STAR___$2 = parsed_query_STAR___$1;
if(cljs.core.truth_(filter_fn__$1)){
var parsed = fluree.db.query.analytical_parse.parse_filter_fn.call(null,filter_fn__$1,all_vars);
var G__18759 = r__$1;
var G__18760 = cljs.core.assoc.call(null,parsed_query_STAR___$2,new cljs.core.Keyword(null,"where","where",-2044795965),fluree.db.query.analytical_parse.add_filter_where.call(null,where,parsed));
G__18749__$1 = G__18759;
parsed_query_STAR___$1 = G__18760;
continue;
} else {
return parsed_query_STAR___$2;
}
break;
}
}
});
/**
 * Parses binding map. Returns a two-tuple of binding maps
 *   including aggregates and scalars, for bindings that are
 *   aggregate functions vs static scalar values.
 * 
 *   Scalars end up getting hoisted, and essentially merged
 *   with query :vars - this way filter functions that get
 *   merged into their respective where statements will have
 *   the variable available to them.
 */
fluree.db.query.analytical_parse.parse_binding = (function fluree$db$query$analytical_parse$parse_binding(bind_map){
return cljs.core.reduce_kv.call(null,(function (p__18761,k,v){
var vec__18762 = p__18761;
var aggregates = cljs.core.nth.call(null,vec__18762,(0),null);
var scalars = cljs.core.nth.call(null,vec__18762,(1),null);
if(cljs.core.truth_(fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,v))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,aggregates,k,fluree.db.query.analytical_parse.parse_aggregate.call(null,v)),scalars], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [aggregates,cljs.core.assoc.call(null,scalars,k,v)], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY], null),bind_map);
});
/**
 * When a where clause is a map, parses it into accumulating parsed where.
 *   Note parsed-where is not complete, but only has where clauses parsed that
 *   preceded the map clause.
 * 
 *   Returns a two-tuple of where-map type (i.e. :filter, :bind, :union .. etc.) and
 *   updated where clause. Updates where clause because a filter function may impact
 *   a prior where statement.
 *   
 */
fluree.db.query.analytical_parse.parse_where_map = (function fluree$db$query$analytical_parse$parse_where_map(db,parsed_where,map_clause,supplied_vars){
if(cljs.core.not_EQ_.call(null,(1),cljs.core.count.call(null,map_clause))){
throw cljs.core.ex_info.call(null,["Where clause maps can only have one key/val, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(map_clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

var vec__18766 = cljs.core.first.call(null,map_clause);
var clause_type = cljs.core.nth.call(null,vec__18766,(0),null);
var clause_val = cljs.core.nth.call(null,vec__18766,(1),null);
var G__18769 = clause_type;
var G__18769__$1 = (((G__18769 instanceof cljs.core.Keyword))?G__18769.fqn:null);
switch (G__18769__$1) {
case "filter":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"filter","filter",-948537934),clause_val], null);

break;
case "optional":
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"optional","optional",2053951509),new cljs.core.Keyword(null,"where","where",-2044795965),fluree.db.query.analytical_parse.parse_where.call(null,db,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),clause_val], null),supplied_vars)], null);

break;
case "union":
if(cljs.core._EQ_.call(null,(2),cljs.core.count.call(null,clause_val))){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"union","union",2142937499),new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.mapv.call(null,(function (p1__18765_SHARP_){
return fluree.db.query.analytical_parse.parse_where.call(null,db,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),p1__18765_SHARP_], null),supplied_vars);
}),clause_val)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, 'union' clause must have exactly two solutions. ","Each solution must be its own 'where' clause wrapped in a vector"].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

break;
case "bind":
if(cljs.core.map_QMARK_.call(null,clause_val)){
var bind_map = fluree.db.query.analytical_parse.symbolize_var_keys.call(null,clause_val);
var vec__18770 = fluree.db.query.analytical_parse.parse_binding.call(null,bind_map);
var aggregates = cljs.core.nth.call(null,vec__18770,(0),null);
var scalars = cljs.core.nth.call(null,vec__18770,(1),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),aggregates,new cljs.core.Keyword(null,"scalars","scalars",-350192527),scalars], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, 'bind' must be a map with binding vars as keys ","and binding scalars, or aggregates, as values."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

break;
case "minus":
throw cljs.core.ex_info.call(null,"Invalid where clause, Fluree does not yet support the 'minus' operation.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

break;
default:
throw cljs.core.ex_info.call(null,["Invalid where clause, unsupported where clause operation: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause_type)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
});
/**
 * Parses a two-tuple variable binding where clause
 */
fluree.db.query.analytical_parse.parse_binding_tuple = (function fluree$db$query$analytical_parse$parse_binding_tuple(binding_var,binding_val){
var var$ = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,binding_var);
var fn_QMARK_ = fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,binding_val);
if(cljs.core.truth_(fn_QMARK_)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"variable","variable",-281346492),var$,new cljs.core.Keyword(null,"fn","fn",-1175266204),binding_val], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"binding","binding",539932593),new cljs.core.Keyword(null,"variable","variable",-281346492),var$,new cljs.core.Keyword(null,"value","value",305978217),binding_val], null);
}
});
/**
 * For both 's' and 'o', returns a map with respective value
 *   that indicates the value's type and if needed other information.
 * 
 *   'o' values have special handling before calling this function as they can
 *   also have 'tag' values or query-functions.
 */
fluree.db.query.analytical_parse.value_type_map = (function fluree$db$query$analytical_parse$value_type_map(value,subject_QMARK_){
if(fluree.db.util.core.pred_ident_QMARK_.call(null,value)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ident","ident",-742346),value], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,value))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,value)], null);
} else {
if((value == null)){
return null;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = subject_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.int_QMARK_.call(null,value)));
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Subject values in where statement must be integer subject IDs or two-tuple identies. ","Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value], null);
}

}
}
}
});
fluree.db.query.analytical_parse.default_recursion_depth = (100);
/**
 * A predicate that ends in a '+', or a '+' with some integer afterwards is a recursion
 *   predicate. e.g.: person/follows+3
 * 
 *   Returns a two-tuple of predicate followed by # of times to recur.
 * 
 *   If not a recursion predicate, returns nil.
 */
fluree.db.query.analytical_parse.recursion_predicate = (function fluree$db$query$analytical_parse$recursion_predicate(predicate){
var temp__5804__auto__ = cljs.core.re_find.call(null,/(.+)\+(\d+)?$/,predicate);
if(cljs.core.truth_(temp__5804__auto__)){
var vec__18774 = temp__5804__auto__;
var _ = cljs.core.nth.call(null,vec__18774,(0),null);
var pred = cljs.core.nth.call(null,vec__18774,(1),null);
var recur_n = cljs.core.nth.call(null,vec__18774,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pred,(cljs.core.truth_(recur_n)?fluree.db.util.core.str__GT_int.call(null,recur_n):(100))], null);
} else {
return null;
}
});
/**
 * Returns predicate ID for a given predicate, else will throw with an invalid
 *   predicate error.
 */
fluree.db.query.analytical_parse.pred_id_strict = (function fluree$db$query$analytical_parse$pred_id_strict(db,predicate){
var or__5045__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),predicate);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(predicate)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
});
/**
 * Parses where clause tuples (not maps).
 *   - supplied-vars will include user-supplied variables in the :vars
 *   - all-vars will include all variable inputs - which includes any defined in :bind statements.
 */
fluree.db.query.analytical_parse.parse_where_tuple = (function fluree$db$query$analytical_parse$parse_where_tuple(supplied_vars,all_vars,db,s,p,o){
var fulltext_QMARK_ = clojure.string.starts_with_QMARK_.call(null,p,"fullText:");
var rdf_type_QMARK_ = ((cljs.core._EQ_.call(null,"rdf:type",p)) || (cljs.core._EQ_.call(null,"a",p)));
var _id_QMARK_ = cljs.core._EQ_.call(null,"_id",p);
var vec__18777 = fluree.db.query.analytical_parse.recursion_predicate.call(null,p);
var recur_pred = cljs.core.nth.call(null,vec__18777,(0),null);
var recur_n = cljs.core.nth.call(null,vec__18777,(1),null);
var s_STAR_ = fluree.db.query.analytical_parse.value_type_map.call(null,s,true);
var p_STAR_ = ((fulltext_QMARK_)?(function(){throw cljs.core.ex_info.call(null,"Full text queries not supported in JavaScript currently.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((rdf_type_QMARK_)?new cljs.core.Keyword("rdf","type","rdf/type",1175423232):((_id_QMARK_)?new cljs.core.Keyword(null,"_id","_id",-789960287):(cljs.core.truth_(recur_pred)?(function (){var G__18780 = recur_pred;
if(cljs.core.truth_(db)){
return fluree.db.query.analytical_parse.pred_id_strict.call(null,db,G__18780);
} else {
return G__18780;
}
})():(function (){var G__18781 = p;
if(cljs.core.truth_(db)){
return fluree.db.query.analytical_parse.pred_id_strict.call(null,db,G__18781);
} else {
return G__18781;
}
})()
))));
var p_idx_QMARK_ = (cljs.core.truth_(p_STAR_)?fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p_STAR_):null);
var p_ref_QMARK_ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
var p_tag_QMARK_ = (cljs.core.truth_(p_STAR_)?cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p)):null);
var o_STAR_ = (cljs.core.truth_(o)?(cljs.core.truth_(p_tag_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),o], null):(cljs.core.truth_(fluree.db.query.analytical_parse.query_fn_QMARK_.call(null,o))?(function (){var parsed_filter_map = fluree.db.query.analytical_parse.parse_filter_fn.call(null,o,all_vars);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(parsed_filter_map),new cljs.core.Keyword(null,"filter","filter",-948537934),parsed_filter_map], null);
})():((rdf_type_QMARK_)?((cljs.core._EQ_.call(null,"_block",o))?fluree.db.query.analytical_parse.value_type_map.call(null,"_tx",false):fluree.db.query.analytical_parse.value_type_map.call(null,o,false)):fluree.db.query.analytical_parse.value_type_map.call(null,o,p_ref_QMARK_)
))):null);
var idx = ((fulltext_QMARK_)?new cljs.core.Keyword(null,"full-text","full-text",1432444182):((((_id_QMARK_) || (rdf_type_QMARK_)))?new cljs.core.Keyword(null,"spot","spot",-1706962147):(cljs.core.truth_((function (){var and__5043__auto__ = s_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s_STAR_));
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword(null,"spot","spot",-1706962147):(cljs.core.truth_((function (){var and__5043__auto__ = p_idx_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return o_STAR_;
} else {
return and__5043__auto__;
}
})())?new cljs.core.Keyword(null,"post","post",269697687):(cljs.core.truth_(p)?(function (){
if(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o_STAR_))){
fluree.db.util.log.info.call(null,["Searching for a property value on unindexed predicate: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p),". Consider making property indexed for improved performance ","and lower fuel consumption."].join(''));
} else {
}

return new cljs.core.Keyword(null,"psot","psot",2111653059);
})()
:(cljs.core.truth_(o)?new cljs.core.Keyword(null,"opst","opst",1213963058):(function(){throw cljs.core.ex_info.call(null,["Unable to determine query type for where statement: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [s,p,o], null)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
))))));
var ident_vars = (function (){var G__18782 = cljs.core.PersistentHashSet.EMPTY;
var G__18782__$1 = ((cljs.core.contains_QMARK_.call(null,supplied_vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s_STAR_)))?cljs.core.conj.call(null,G__18782,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(s_STAR_)):G__18782);
if(cljs.core.truth_((function (){var and__5043__auto__ = p_ref_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.contains_QMARK_.call(null,supplied_vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o_STAR_));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.conj.call(null,G__18782__$1,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o_STAR_));
} else {
return G__18782__$1;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"p-ref?","p-ref?",-1416067934),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"p-idx?","p-idx?",977503771),new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.Keyword(null,"p-tag?","p-tag?",2131007743)],[p_ref_QMARK_,o_STAR_,cljs.core.not_empty.call(null,ident_vars),recur_n,((fulltext_QMARK_)?new cljs.core.Keyword(null,"full-text","full-text",1432444182):((rdf_type_QMARK_)?new cljs.core.Keyword("rdf","type","rdf/type",1175423232):((_id_QMARK_)?new cljs.core.Keyword(null,"_id","_id",-789960287):new cljs.core.Keyword(null,"tuple","tuple",-472667284)
))),s_STAR_,idx,p_idx_QMARK_,p_STAR_,p_tag_QMARK_]);
});
/**
 * When a specific DB is used (not default) for a where statement.
 *   This is in the form of a 4-tuple where clause.
 */
fluree.db.query.analytical_parse.parse_remote_tuple = (function fluree$db$query$analytical_parse$parse_remote_tuple(supplied_vars,all_vars,db,s,p,o){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"remote-tuple","remote-tuple",-1236726618),new cljs.core.Keyword(null,"s","s",1705939918),s,new cljs.core.Keyword(null,"p","p",151049309),p,new cljs.core.Keyword(null,"o","o",-1350007228),o], null);
});
/**
 * Parses where clause
 */
fluree.db.query.analytical_parse.parse_where = (function fluree$db$query$analytical_parse$parse_where(db,p__18783,supplied_vars){
var map__18784 = p__18783;
var map__18784__$1 = cljs.core.__destructure_map.call(null,map__18784);
var _query_map_SINGLEQUOTE_ = map__18784__$1;
var where = cljs.core.get.call(null,map__18784__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
if(cljs.core.sequential_QMARK_.call(null,where)){
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, must be a vector of tuples and/or maps: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var G__18788 = where;
var vec__18789 = G__18788;
var seq__18790 = cljs.core.seq.call(null,vec__18789);
var first__18791 = cljs.core.first.call(null,seq__18790);
var seq__18790__$1 = cljs.core.next.call(null,seq__18790);
var where_smt = first__18791;
var r = seq__18790__$1;
var filters = cljs.core.PersistentVector.EMPTY;
var hoisted_bind = cljs.core.PersistentArrayMap.EMPTY;
var all_vars = supplied_vars;
var where_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__18788__$1 = G__18788;
var filters__$1 = filters;
var hoisted_bind__$1 = hoisted_bind;
var all_vars__$1 = all_vars;
var where_STAR___$1 = where_STAR_;
while(true){
var vec__18799 = G__18788__$1;
var seq__18800 = cljs.core.seq.call(null,vec__18799);
var first__18801 = cljs.core.first.call(null,seq__18800);
var seq__18800__$1 = cljs.core.next.call(null,seq__18800);
var where_smt__$1 = first__18801;
var r__$1 = seq__18800__$1;
var filters__$2 = filters__$1;
var hoisted_bind__$2 = hoisted_bind__$1;
var all_vars__$2 = all_vars__$1;
var where_STAR___$2 = where_STAR___$1;
if(cljs.core.truth_(where_smt__$1)){
if(cljs.core.map_QMARK_.call(null,where_smt__$1)){
var map__18802 = fluree.db.query.analytical_parse.parse_where_map.call(null,db,where_STAR___$2,where_smt__$1,all_vars__$2);
var map__18802__$1 = cljs.core.__destructure_map.call(null,map__18802);
var where_map = map__18802__$1;
var type = cljs.core.get.call(null,map__18802__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var G__18803 = type;
var G__18803__$1 = (((G__18803 instanceof cljs.core.Keyword))?G__18803.fqn:null);
switch (G__18803__$1) {
case "bind":
var map__18804 = where_map;
var map__18804__$1 = cljs.core.__destructure_map.call(null,map__18804);
var aggregates = cljs.core.get.call(null,map__18804__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var scalars = cljs.core.get.call(null,map__18804__$1,new cljs.core.Keyword(null,"scalars","scalars",-350192527));
var G__18807 = r__$1;
var G__18808 = filters__$2;
var G__18809 = cljs.core.merge.call(null,hoisted_bind__$2,scalars);
var G__18810 = cljs.core.set.call(null,cljs.core.concat.call(null,all_vars__$2,cljs.core.keys.call(null,aggregates),cljs.core.keys.call(null,scalars)));
var G__18811 = (cljs.core.truth_(cljs.core.not_empty.call(null,aggregates))?cljs.core.conj.call(null,where_STAR___$2,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),aggregates], null)):where_STAR___$2);
G__18788__$1 = G__18807;
filters__$1 = G__18808;
hoisted_bind__$1 = G__18809;
all_vars__$1 = G__18810;
where_STAR___$1 = G__18811;
continue;

break;
case "filter":
var G__18812 = r__$1;
var G__18813 = cljs.core.conj.call(null,filters__$2,new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(where_map));
var G__18814 = hoisted_bind__$2;
var G__18815 = all_vars__$2;
var G__18816 = where_STAR___$2;
G__18788__$1 = G__18812;
filters__$1 = G__18813;
hoisted_bind__$1 = G__18814;
all_vars__$1 = G__18815;
where_STAR___$1 = G__18816;
continue;

break;
default:
var G__18817 = r__$1;
var G__18818 = filters__$2;
var G__18819 = hoisted_bind__$2;
var G__18820 = all_vars__$2;
var G__18821 = cljs.core.conj.call(null,where_STAR___$2,where_map);
G__18788__$1 = G__18817;
filters__$1 = G__18818;
hoisted_bind__$1 = G__18819;
all_vars__$1 = G__18820;
where_STAR___$1 = G__18821;
continue;

}
} else {
if(cljs.core.sequential_QMARK_.call(null,where_smt__$1)){
var tuple_count = cljs.core.count.call(null,where_smt__$1);
var where_smt_STAR_ = (function (){var G__18805 = tuple_count;
switch (G__18805) {
case (3):
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_where_tuple,supplied_vars,all_vars__$2,db,where_smt__$1);

break;
case (4):
if(cljs.core._EQ_.call(null,"$fdb",cljs.core.first.call(null,where_smt__$1))){
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_where_tuple,supplied_vars,all_vars__$2,db,cljs.core.rest.call(null,where_smt__$1));
} else {
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_remote_tuple,supplied_vars,all_vars__$2,where_smt__$1);
}

break;
case (2):
return cljs.core.apply.call(null,fluree.db.query.analytical_parse.parse_binding_tuple,where_smt__$1);

break;
default:
if(cljs.core.sequential_QMARK_.call(null,cljs.core.first.call(null,where_smt__$1))){
throw cljs.core.ex_info.call(null,["Invalid where clause, it should contain 2, 3 or 4 tuples. ","It appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, it should contain 2, 3 or 4 tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

}
})();
var G__18823 = r__$1;
var G__18824 = filters__$2;
var G__18825 = hoisted_bind__$2;
var G__18826 = all_vars__$2;
var G__18827 = cljs.core.conj.call(null,where_STAR___$2,where_smt_STAR_);
G__18788__$1 = G__18823;
filters__$1 = G__18824;
hoisted_bind__$1 = G__18825;
all_vars__$1 = G__18826;
where_STAR___$1 = G__18827;
continue;
} else {
throw cljs.core.ex_info.call(null,["Invalid where clause, must be a vector of tuples and/or maps: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
} else {
var where_PLUS_filters = ((cljs.core.seq.call(null,filters__$2))?cljs.core.reduce.call(null,((function (G__18788__$1,filters__$1,hoisted_bind__$1,all_vars__$1,where_STAR___$1,vec__18799,seq__18800,first__18801,seq__18800__$1,where_smt__$1,r__$1,filters__$2,hoisted_bind__$2,all_vars__$2,where_STAR___$2,G__18788,vec__18789,seq__18790,first__18791,seq__18790__$1,where_smt,r,filters,hoisted_bind,all_vars,where_STAR_,map__18784,map__18784__$1,_query_map_SINGLEQUOTE_,where){
return (function (where_SINGLEQUOTE_,filter){
return new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(fluree.db.query.analytical_parse.add_filter.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"where","where",-2044795965),where_SINGLEQUOTE_], null),filter,all_vars__$2));
});})(G__18788__$1,filters__$1,hoisted_bind__$1,all_vars__$1,where_STAR___$1,vec__18799,seq__18800,first__18801,seq__18800__$1,where_smt__$1,r__$1,filters__$2,hoisted_bind__$2,all_vars__$2,where_STAR___$2,G__18788,vec__18789,seq__18790,first__18791,seq__18790__$1,where_smt,r,filters,hoisted_bind,all_vars,where_STAR_,map__18784,map__18784__$1,_query_map_SINGLEQUOTE_,where))
,where_STAR___$2,filters__$2):where_STAR___$2);
if(cljs.core.truth_(cljs.core.not_empty.call(null,hoisted_bind__$2))){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"bind","bind",-113428417),new cljs.core.Keyword(null,"scalars","scalars",-350192527),hoisted_bind__$2], null)], null),where_PLUS_filters);
} else {
return where_PLUS_filters;
}
}
break;
}
});
/**
 * Returns query map without vars, to allow more effective caching of parsing.
 */
fluree.db.query.analytical_parse.extract_vars = (function fluree$db$query$analytical_parse$extract_vars(query_map){
return cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"vars","vars",-2046957217));
});
fluree.db.query.analytical_parse.parse_order_by = (function fluree$db$query$analytical_parse$parse_order_by(order_by_clause){
var throw_BANG_ = (function (msg){
throw cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = msg;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ["Invalid orderBy clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(order_by_clause)].join('');
}
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
var vec__18828 = ((cljs.core.vector_QMARK_.call(null,order_by_clause))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.second.call(null,order_by_clause),cljs.core.first.call(null,order_by_clause)], null):((typeof order_by_clause === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [order_by_clause,new cljs.core.Keyword(null,"asc","asc",356854569)], null):throw_BANG_.call(null,null)
));
var pred = cljs.core.nth.call(null,vec__18828,(0),null);
var order = cljs.core.nth.call(null,vec__18828,(1),null);
var order_STAR_ = (function (){var G__18831 = order;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"asc","asc",356854569),G__18831)){
return order;
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"desc","desc",2093485764),G__18831)){
return order;
} else {
if(cljs.core._EQ_.call(null,"ASC",G__18831)){
return new cljs.core.Keyword(null,"asc","asc",356854569);
} else {
if(cljs.core._EQ_.call(null,"DESC",G__18831)){
return new cljs.core.Keyword(null,"desc","desc",2093485764);
} else {
return throw_BANG_.call(null,null);

}
}
}
}
})();
var pred_var = fluree.db.query.analytical_parse.q_var__GT_symbol.call(null,pred);
if(cljs.core.truth_(pred_var)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"variable","variable",-281346492),new cljs.core.Keyword(null,"order","order",-1254677256),order_STAR_,new cljs.core.Keyword(null,"variable","variable",-281346492),pred_var], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.Keyword(null,"order","order",-1254677256),order_STAR_,new cljs.core.Keyword(null,"predicate","predicate",-1742501860),pred], null);
}
});
/**
 * Parses order-by and returns a map with more details
 *   Map contains keys:
 * :type      - contains :variable or :predicate for type
 * :order     - :asc or :desc
 * :predicate - predicate name, if :predicate type
 * :variable  - variable name, if :variable type
 */
fluree.db.query.analytical_parse.add_order_by = (function fluree$db$query$analytical_parse$add_order_by(p__18832,order_by){
var map__18833 = p__18832;
var map__18833__$1 = cljs.core.__destructure_map.call(null,map__18833);
var parsed_query = map__18833__$1;
var where = cljs.core.get.call(null,map__18833__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var map__18834 = fluree.db.query.analytical_parse.parse_order_by.call(null,order_by);
var map__18834__$1 = cljs.core.__destructure_map.call(null,map__18834);
var parsed_order_by = map__18834__$1;
var variable = cljs.core.get.call(null,map__18834__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
if(cljs.core.truth_((function (){var and__5043__auto__ = variable;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,variable,where));
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Order by specifies a variable, ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable)," that is not used in a where statement."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"order-by","order-by",1527318070),parsed_order_by);
});
fluree.db.query.analytical_parse.add_group_by = (function fluree$db$query$analytical_parse$add_group_by(p__18836,group_by){
var map__18837 = p__18836;
var map__18837__$1 = cljs.core.__destructure_map.call(null,map__18837);
var parsed_query = map__18837__$1;
var where = cljs.core.get.call(null,map__18837__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var group_by_STAR_ = cljs.core.mapv.call(null,fluree.db.query.analytical_parse.q_var__GT_symbol,((cljs.core.sequential_QMARK_.call(null,group_by))?group_by:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [group_by], null)));
if(cljs.core.every_QMARK_.call(null,cljs.core.symbol_QMARK_,group_by_STAR_)){
} else {
throw cljs.core.ex_info.call(null,["Group by must only include variable(s), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_by)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.every_QMARK_.call(null,(function (p1__18835_SHARP_){
return fluree.db.query.analytical_parse.variable_in_where_QMARK_.call(null,p1__18835_SHARP_,where);
}),group_by_STAR_)){
} else {
throw cljs.core.ex_info.call(null,["Group by includes variable(s) not specified in the where clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(group_by)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"group-by","group-by",-379139802),group_by_STAR_);
});
/**
 * Extracts limit, if available, and verifies it is a positive integer.
 *   Uses Integer/max as default if not present.
 */
fluree.db.query.analytical_parse.get_limit = (function fluree$db$query$analytical_parse$get_limit(p__18838){
var map__18839 = p__18838;
var map__18839__$1 = cljs.core.__destructure_map.call(null,map__18839);
var _query_map_SINGLEQUOTE_ = map__18839__$1;
var limit = cljs.core.get.call(null,map__18839__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var opts = cljs.core.get.call(null,map__18839__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var limit_STAR_ = (function (){var or__5045__auto__ = limit;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (2147483647);
}
}
})();
if(cljs.core.pos_int_QMARK_.call(null,limit_STAR_)){
} else {
throw cljs.core.ex_info.call(null,["Invalid query limit specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit_STAR_)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return limit_STAR_;
});
/**
 * Extracts offset, if specified, and verifies it is a positive integer.
 *   Uses 0 as default if not present.
 */
fluree.db.query.analytical_parse.get_offset = (function fluree$db$query$analytical_parse$get_offset(p__18840){
var map__18841 = p__18840;
var map__18841__$1 = cljs.core.__destructure_map.call(null,map__18841);
var _query_map_SINGLEQUOTE_ = map__18841__$1;
var offset = cljs.core.get.call(null,map__18841__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var opts = cljs.core.get.call(null,map__18841__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var offset_STAR_ = (function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (0);
}
}
})();
if((offset_STAR_ >= (0))){
} else {
throw cljs.core.ex_info.call(null,["Invalid query offset specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset_STAR_)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return offset_STAR_;
});
/**
 * Extracts max-fuel from query if specified, or uses Integer/max a default.
 */
fluree.db.query.analytical_parse.get_max_fuel = (function fluree$db$query$analytical_parse$get_max_fuel(p__18842){
var map__18843 = p__18842;
var map__18843__$1 = cljs.core.__destructure_map.call(null,map__18843);
var query_map_SINGLEQUOTE_ = map__18843__$1;
var fuel = cljs.core.get.call(null,map__18843__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.call(null,map__18843__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
if(cljs.core.truth_(max_fuel)){
fluree.db.util.log.info.call(null,"Deprecated max-fuel used in query: ",query_map_SINGLEQUOTE_);
} else {
}

var max_fuel__$1 = ((typeof max_fuel === 'number')?max_fuel:((typeof fuel === 'number')?fuel:(2147483647)
));
if((max_fuel__$1 > (0))){
} else {
throw cljs.core.ex_info.call(null,["Invalid query fuel specified: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return max_fuel__$1;
});
/**
 * Expands a relational bindings vars definition where it was not supplied
 *   as a vector of maps, but instead a map with one or more vectors as vals.
 *   e.g.
 *   {?x [1 2 3 4]}
 *   {?x [1 2 3 4]
 * ?y ['a' 'b' 'c' 'd']}
 *   {?x [1 2 3 4]
 * ?y 'some-constant-var'}
 * 
 *   Returns a vector of full vars maps.
 */
fluree.db.query.analytical_parse.expand_var_rel_binding = (function fluree$db$query$analytical_parse$expand_var_rel_binding(supplied_vars){
var ks = cljs.core.keys.call(null,supplied_vars);
return cljs.core.mapv.call(null,(function (p1__18845_SHARP_){
return cljs.core.zipmap.call(null,ks,p1__18845_SHARP_);
}),cljs.core.partition.call(null,cljs.core.count.call(null,ks),cljs.core.apply.call(null,cljs.core.interleave,cljs.core.mapv.call(null,(function (p1__18844_SHARP_){
if(cljs.core.sequential_QMARK_.call(null,p1__18844_SHARP_)){
return p1__18844_SHARP_;
} else {
return cljs.core.repeat.call(null,p1__18844_SHARP_);
}
}),cljs.core.vals.call(null,supplied_vars)))));
});
/**
 * Turns all var keys into symbols.
 *   If multiple vars (relational bindings) then will
 *   return a vector of vars maps.
 */
fluree.db.query.analytical_parse.coerce_vars = (function fluree$db$query$analytical_parse$coerce_vars(supplied_vars){
if(cljs.core.truth_(supplied_vars)){
if(cljs.core.sequential_QMARK_.call(null,supplied_vars)){
return cljs.core.mapv.call(null,fluree.db.query.analytical_parse.symbolize_var_keys,supplied_vars);
} else {
var supplied_vars_STAR_ = fluree.db.query.analytical_parse.symbolize_var_keys.call(null,supplied_vars);
var rel_binding_QMARK_ = (function (){var and__5043__auto__ = cljs.core.some.call(null,cljs.core.sequential_QMARK_,cljs.core.vals.call(null,supplied_vars_STAR_));
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.every_QMARK_.call(null,(function (p1__18846_SHARP_){
return fluree.db.util.core.pred_ident_QMARK_.call(null,p1__18846_SHARP_);
}),cljs.core.vals.call(null,supplied_vars_STAR_))));
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.analytical_parse.expand_var_rel_binding.call(null,supplied_vars_STAR_);
} else {
return supplied_vars_STAR_;
}
}
} else {
return null;
}
});
/**
 * Returns true if the query is the legacy 'basic query' type.
 *   e.g.:
 * {select [*], from: '_user'}
 * {select [*], from: ['_user/username' 'userid']}
 * {select [*], from: '_user', where: '_user/username = userid'}
 */
fluree.db.query.analytical_parse.basic_query_QMARK_ = (function fluree$db$query$analytical_parse$basic_query_QMARK_(p__18847){
var map__18848 = p__18847;
var map__18848__$1 = cljs.core.__destructure_map.call(null,map__18848);
var _query_map = map__18848__$1;
var where = cljs.core.get.call(null,map__18848__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
return (!(cljs.core.sequential_QMARK_.call(null,where)));
});
/**
 * When where statements use supplied vars that are identies in s or o position
 *   they need to get resolved before executing the query.
 *   Here we consolidate them from all where statements into a single :ident-vars
 *   key on the parsed query map.
 */
fluree.db.query.analytical_parse.consolidate_ident_vars = (function fluree$db$query$analytical_parse$consolidate_ident_vars(p__18849){
var map__18850 = p__18849;
var map__18850__$1 = cljs.core.__destructure_map.call(null,map__18850);
var parsed_query = map__18850__$1;
var where = cljs.core.get.call(null,map__18850__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var all_ident_vars = cljs.core.not_empty.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),where)));
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"ident-vars","ident-vars",-876752986),all_ident_vars);
});
fluree.db.query.analytical_parse.parse_STAR_ = (function fluree$db$query$analytical_parse$parse_STAR_(db,p__18851,supplied_vars){
var map__18852 = p__18851;
var map__18852__$1 = cljs.core.__destructure_map.call(null,map__18852);
var query_map_SINGLEQUOTE_ = map__18852__$1;
var opts = cljs.core.get.call(null,map__18852__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var prettyPrint = cljs.core.get.call(null,map__18852__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var filter = cljs.core.get.call(null,map__18852__$1,new cljs.core.Keyword(null,"filter","filter",-948537934));
var orderBy = cljs.core.get.call(null,map__18852__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.call(null,map__18852__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var rel_binding_QMARK_ = cljs.core.sequential_QMARK_.call(null,supplied_vars);
var supplied_var_keys = ((rel_binding_QMARK_)?cljs.core.set.call(null,cljs.core.keys.call(null,cljs.core.first.call(null,supplied_vars))):cljs.core.set.call(null,cljs.core.keys.call(null,supplied_vars)));
var orderBy_STAR_ = (function (){var or__5045__auto__ = orderBy;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
}
})();
var groupBy_STAR_ = (function (){var or__5045__auto__ = groupBy;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts);
}
})();
var parsed = (function (){var G__18853 = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094),new cljs.core.Keyword(null,"strategy","strategy",-1471631918),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"supplied-vars","supplied-vars",-919438628)],[fluree.db.query.analytical_parse.parse_where.call(null,db,query_map_SINGLEQUOTE_,supplied_var_keys),fluree.db.query.analytical_parse.get_limit.call(null,query_map_SINGLEQUOTE_),fluree.db.query.analytical_parse.get_offset.call(null,query_map_SINGLEQUOTE_),fluree.db.query.analytical_parse.get_max_fuel.call(null,query_map_SINGLEQUOTE_),rel_binding_QMARK_,new cljs.core.Keyword(null,"legacy","legacy",1434943289),opts,((cljs.core.boolean_QMARK_.call(null,prettyPrint))?prettyPrint:new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts)),supplied_var_keys]);
var G__18853__$1 = (cljs.core.truth_(filter)?fluree.db.query.analytical_parse.add_filter.call(null,G__18853,filter,supplied_var_keys):G__18853);
var G__18853__$2 = (cljs.core.truth_(orderBy_STAR_)?fluree.db.query.analytical_parse.add_order_by.call(null,G__18853__$1,orderBy_STAR_):G__18853__$1);
var G__18853__$3 = (cljs.core.truth_(groupBy_STAR_)?fluree.db.query.analytical_parse.add_group_by.call(null,G__18853__$2,groupBy_STAR_):G__18853__$2);
var G__18853__$4 = fluree.db.query.analytical_parse.consolidate_ident_vars.call(null,G__18853__$3)
;
return fluree.db.query.analytical_parse.add_select_spec.call(null,G__18853__$4,query_map_SINGLEQUOTE_);

})();
var or__5045__auto__ = fluree.db.query.subject_crawl.reparse.re_parse_as_simple_subj_crawl.call(null,parsed);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return parsed;
}
});
fluree.db.query.analytical_parse.parse = (function fluree$db$query$analytical_parse$parse(db,query_map){
var query_map_STAR_ = ((fluree.db.query.analytical_parse.basic_query_QMARK_.call(null,query_map))?fluree.db.query.subject_crawl.legacy.basic_to_analytical_transpiler.call(null,query_map):query_map);
var map__18854 = query_map_STAR_;
var map__18854__$1 = cljs.core.__destructure_map.call(null,map__18854);
var vars = cljs.core.get.call(null,map__18854__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var opts = cljs.core.get.call(null,map__18854__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var vars_STAR_ = fluree.db.query.analytical_parse.coerce_vars.call(null,vars);
var opts_STAR_ = (cljs.core.truth_(opts)?fluree.db.util.core.keywordize_keys.call(null,opts):null);
var parsed_query = fluree.db.query.analytical_parse.parse_STAR_.call(null,db,cljs.core.dissoc.call(null,cljs.core.assoc.call(null,query_map_STAR_,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_),new cljs.core.Keyword(null,"vars","vars",-2046957217)),vars_STAR_);
return cljs.core.assoc.call(null,parsed_query,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars_STAR_);
});
