// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.flake');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
fluree.db.flake.MAX_COLLECTION_ID = (511);
fluree.db.flake.MAX_COLL_SUBJECTS = ((17592186044415) - (1));



/**
 * Increments a transaction value
 */
fluree.db.flake.inc_t = cljs.core.dec;
/**
 * Decrements a transaction value
 */
fluree.db.flake.dec_t = cljs.core.inc;
fluree.db.flake.lshift = (function fluree$db$flake$lshift(n,bits){
return (n * Math.pow((2),bits));
});
/**
 * Converts a collection id and a number (n) into a subject-id.
 */
fluree.db.flake.__GT_sid = (function fluree$db$flake$__GT_sid(cid,n){
return (fluree.db.flake.lshift.call(null,cid,(44)) + n);
});
/**
 * Like ->sid, but checks that cid and n are within allowable range.
 */
fluree.db.flake.__GT_sid_checked = (function fluree$db$flake$__GT_sid_checked(cid,n){
if(((((0) < cid)) && ((cid < (511))))){
} else {
throw (new Error(["Assert failed: ",["Collection id is out of allowable range of 0 - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((511))].join(''),"\n","(< 0 cid MAX-COLLECTION-ID)"].join('')));
}

if(((((0) < n)) && ((n < fluree.db.flake.MAX_COLL_SUBJECTS)))){
} else {
throw (new Error(["Assert failed: ",["Subject number is out of allowable range of 0 - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.MAX_COLL_SUBJECTS)].join(''),"\n","(< 0 n MAX-COLL-SUBJECTS)"].join('')));
}

return fluree.db.flake.__GT_sid.call(null,cid,n);
});
/**
 * For a given collection id, returns the min subject id that is allowed.
 */
fluree.db.flake.min_subject_id = (function fluree$db$flake$min_subject_id(cid){
return fluree.db.flake.__GT_sid.call(null,cid,(0));
});
/**
 * For a given collection id, returns the max subject id that is allowed.
 */
fluree.db.flake.max_subject_id = (function fluree$db$flake$max_subject_id(cid){
return fluree.db.flake.__GT_sid.call(null,cid,fluree.db.flake.MAX_COLL_SUBJECTS);
});
fluree.db.flake.MIN_PREDICATE_ID = fluree.db.flake.min_subject_id.call(null,(0));
fluree.db.flake.MAX_PREDICATE_ID = fluree.db.flake.max_subject_id.call(null,(0));
/**
 * Will return a collection id from a subject-id.
 */
fluree.db.flake.sid__GT_cid = (function fluree$db$flake$sid__GT_cid(sid){
return Math.floor(fluree.db.flake.lshift.call(null,sid,(-44)));
});
/**
 * Returns the subject index from a subject-id.
 */
fluree.db.flake.sid__GT_i = (function fluree$db$flake$sid__GT_i(sid){
return (sid - fluree.db.flake.lshift.call(null,fluree.db.flake.sid__GT_cid.call(null,sid),(44)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
*/
fluree.db.flake.Flake = (function (s,p,o,t,op,m){
this.s = s;
this.p = p;
this.o = o;
this.t = t;
this.op = op;
this.m = m;
this.cljs$lang$protocol_mask$partition0$ = 2162164496;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(fluree.db.flake.Flake.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return fluree.db.flake.get_flake_val.call(null,this$__$1,k,null);
}));

(fluree.db.flake.Flake.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,not_found){
var self__ = this;
var this$__$1 = this;
return fluree.db.flake.get_flake_val.call(null,this$__$1,k,not_found);
}));

(fluree.db.flake.Flake.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,i){
var self__ = this;
var this$__$1 = this;
return fluree.db.flake.nth_flake.call(null,this$__$1,i,null);
}));

(fluree.db.flake.Flake.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,i,not_found){
var self__ = this;
var this$__$1 = this;
return fluree.db.flake.nth_flake.call(null,this$__$1,i,not_found);
}));

(fluree.db.flake.Flake.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.List(null,this$__$1.s,(new cljs.core.List(null,this$__$1.p,(new cljs.core.List(null,this$__$1.o,(new cljs.core.List(null,this$__$1.t,(new cljs.core.List(null,this$__$1.op,(new cljs.core.List(null,this$__$1.m,null,(1),null)),(2),null)),(3),null)),(4),null)),(5),null)),(6),null));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash.call(null,cljs.core.seq.call(null,this$__$1));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,o__$1){
var self__ = this;
var this$__$1 = this;
var and__5043__auto__ = (o__$1 instanceof fluree.db.flake.Flake);
if(and__5043__auto__){
return fluree.db.flake.equiv_flake.call(null,this$__$1,o__$1);
} else {
return and__5043__auto__;
}
}));

(fluree.db.flake.Flake.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,k,v){
var self__ = this;
var this$__$1 = this;
return fluree.db.flake.assoc_flake.call(null,this$__$1,k,v);
}));

(fluree.db.flake.Flake.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (f,writer,opts){
var self__ = this;
var f__$1 = this;
return cljs.core.pr_sequential_writer.call(null,writer,cljs.core.pr_writer,"#Flake ["," ","]",opts,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [f__$1.s,f__$1.p,f__$1.o,f__$1.t,f__$1.op,f__$1.m], null));
}));

(fluree.db.flake.Flake.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"s","s",-948495851,null),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"o","o",290524299,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"op","op",-242456428,null),new cljs.core.Symbol(null,"m","m",-1021758608,null)], null);
}));

(fluree.db.flake.Flake.cljs$lang$type = true);

(fluree.db.flake.Flake.cljs$lang$ctorStr = "fluree.db.flake/Flake");

(fluree.db.flake.Flake.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"fluree.db.flake/Flake");
}));

/**
 * Positional factory function for fluree.db.flake/Flake.
 */
fluree.db.flake.__GT_Flake = (function fluree$db$flake$__GT_Flake(s,p,o,t,op,m){
return (new fluree.db.flake.Flake(s,p,o,t,op,m));
});

fluree.db.flake.s = (function fluree$db$flake$s(f){
return f.s;
});
fluree.db.flake.p = (function fluree$db$flake$p(f){
return f.p;
});
fluree.db.flake.o = (function fluree$db$flake$o(f){
return f.o;
});
fluree.db.flake.t = (function fluree$db$flake$t(f){
return f.t;
});
fluree.db.flake.op = (function fluree$db$flake$op(f){
return f.op;
});
fluree.db.flake.m = (function fluree$db$flake$m(f){
return f.m;
});
fluree.db.flake.equiv_flake = (function fluree$db$flake$equiv_flake(f,other){
return ((cljs.core._EQ_.call(null,fluree.db.flake.s.call(null,f),fluree.db.flake.s.call(null,other))) && (((cljs.core._EQ_.call(null,fluree.db.flake.p.call(null,f),fluree.db.flake.p.call(null,other))) && (cljs.core._EQ_.call(null,fluree.db.flake.o.call(null,f),fluree.db.flake.o.call(null,other))))));
});
/**
 * Used primarily to generate flakes for comparator. If you wish to
 *   generate a flake for other purposes, be sure to supply all components.
 */
fluree.db.flake.parts__GT_Flake = (function fluree$db$flake$parts__GT_Flake(var_args){
var G__13818 = arguments.length;
switch (G__13818) {
case 1:
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1 = (function (p__13819){
var vec__13820 = p__13819;
var s = cljs.core.nth.call(null,vec__13820,(0),null);
var p = cljs.core.nth.call(null,vec__13820,(1),null);
var o = cljs.core.nth.call(null,vec__13820,(2),null);
var t = cljs.core.nth.call(null,vec__13820,(3),null);
var op = cljs.core.nth.call(null,vec__13820,(4),null);
var m = cljs.core.nth.call(null,vec__13820,(5),null);
return fluree.db.flake.__GT_Flake.call(null,s,p,o,t,op,m);
}));

(fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$2 = (function (p__13823,default_tx){
var vec__13824 = p__13823;
var s = cljs.core.nth.call(null,vec__13824,(0),null);
var p = cljs.core.nth.call(null,vec__13824,(1),null);
var o = cljs.core.nth.call(null,vec__13824,(2),null);
var t = cljs.core.nth.call(null,vec__13824,(3),null);
var op = cljs.core.nth.call(null,vec__13824,(4),null);
var m = cljs.core.nth.call(null,vec__13824,(5),null);
return fluree.db.flake.__GT_Flake.call(null,s,p,o,(function (){var or__5045__auto__ = t;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default_tx;
}
})(),op,m);
}));

(fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$3 = (function (p__13827,default_tx,default_op){
var vec__13828 = p__13827;
var s = cljs.core.nth.call(null,vec__13828,(0),null);
var p = cljs.core.nth.call(null,vec__13828,(1),null);
var o = cljs.core.nth.call(null,vec__13828,(2),null);
var t = cljs.core.nth.call(null,vec__13828,(3),null);
var op = cljs.core.nth.call(null,vec__13828,(4),null);
var m = cljs.core.nth.call(null,vec__13828,(5),null);
return fluree.db.flake.__GT_Flake.call(null,s,p,o,(function (){var or__5045__auto__ = t;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default_tx;
}
})(),(function (){var or__5045__auto__ = op;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default_op;
}
})(),m);
}));

(fluree.db.flake.parts__GT_Flake.cljs$lang$maxFixedArity = 3);

fluree.db.flake.Flake__GT_parts = (function fluree$db$flake$Flake__GT_parts(flake){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.s.call(null,flake),fluree.db.flake.p.call(null,flake),fluree.db.flake.o.call(null,flake),fluree.db.flake.t.call(null,flake),fluree.db.flake.op.call(null,flake),fluree.db.flake.m.call(null,flake)], null);
});
/**
 * The largest flake possible
 */
fluree.db.flake.maximum = fluree.db.flake.__GT_Flake.call(null,(9007199254740991),(0),(9007199254740991),(0),true,null);
/**
 * Assoc for Flakes
 */
fluree.db.flake.assoc_flake = (function fluree$db$flake$assoc_flake(flake,k,v){
var vec__13832 = fluree.db.flake.Flake__GT_parts.call(null,flake);
var s = cljs.core.nth.call(null,vec__13832,(0),null);
var p = cljs.core.nth.call(null,vec__13832,(1),null);
var o = cljs.core.nth.call(null,vec__13832,(2),null);
var t = cljs.core.nth.call(null,vec__13832,(3),null);
var op = cljs.core.nth.call(null,vec__13832,(4),null);
var m = cljs.core.nth.call(null,vec__13832,(5),null);
var G__13835 = k;
var G__13835__$1 = (((G__13835 instanceof cljs.core.Keyword))?G__13835.fqn:null);
switch (G__13835__$1) {
case "s":
return fluree.db.flake.__GT_Flake.call(null,v,p,o,t,op,m);

break;
case "p":
return fluree.db.flake.__GT_Flake.call(null,s,v,o,t,op,m);

break;
case "o":
return fluree.db.flake.__GT_Flake.call(null,s,p,v,t,op,m);

break;
case "t":
return fluree.db.flake.__GT_Flake.call(null,s,p,o,v,op,m);

break;
case "op":
return fluree.db.flake.__GT_Flake.call(null,s,p,o,t,v,m);

break;
case "m":
return fluree.db.flake.__GT_Flake.call(null,s,p,o,t,op,v);

break;
default:
throw (new Error(["Flake does not contain key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join('')));

}
});
fluree.db.flake.get_flake_val = (function fluree$db$flake$get_flake_val(flake,k,not_found){
var G__13837 = k;
if(cljs.core._EQ_.call(null,"s",G__13837)){
return fluree.db.flake.s.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"o","o",-1350007228),G__13837)){
return fluree.db.flake.o.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,"p",G__13837)){
return fluree.db.flake.p.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"m","m",1632677161),G__13837)){
return fluree.db.flake.m.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955),G__13837)){
return fluree.db.flake.op.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"s","s",1705939918),G__13837)){
return fluree.db.flake.s.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,"t",G__13837)){
return fluree.db.flake.t.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),G__13837)){
return fluree.db.flake.t.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,"op",G__13837)){
return fluree.db.flake.op.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,"m",G__13837)){
return fluree.db.flake.m.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"p","p",151049309),G__13837)){
return fluree.db.flake.p.call(null,flake);
} else {
if(cljs.core._EQ_.call(null,"o",G__13837)){
return fluree.db.flake.o.call(null,flake);
} else {
return not_found;

}
}
}
}
}
}
}
}
}
}
}
}
});
/**
 * Gets position i in flake.
 */
fluree.db.flake.nth_flake = (function fluree$db$flake$nth_flake(flake,i,not_found){
var ii = (i | (0));
var G__13838 = ii;
switch (G__13838) {
case (0):
return fluree.db.flake.s.call(null,flake);

break;
case (1):
return fluree.db.flake.p.call(null,flake);

break;
case (2):
return fluree.db.flake.o.call(null,flake);

break;
case (3):
return fluree.db.flake.t.call(null,flake);

break;
case (4):
return fluree.db.flake.op.call(null,flake);

break;
case (5):
return fluree.db.flake.m.call(null,flake);

break;
default:
var or__5045__auto__ = not_found;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ii)," out of bounds for flake: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(flake)].join('')));
}

}
});
fluree.db.flake.cmp_val = (function fluree$db$flake$cmp_val(o1,o2){
if((((!((o1 == null)))) && ((!((o2 == null)))))){
return cljs.core.compare.call(null,o1,o2);
} else {
return (0);
}
});
fluree.db.flake.cc_cmp_class = (function fluree$db$flake$cc_cmp_class(x){
if(typeof x === 'string'){
return "string";
} else {
return "number";
}
});
/**
 * Use this instead of `cmp-val` if possibly doing cross-type value comparison
 */
fluree.db.flake.cmp_val_xtype = (function fluree$db$flake$cmp_val_xtype(o1,o2){
if((((!((o1 == null)))) && ((!((o2 == null)))))){
var o1_str = fluree.db.flake.cc_cmp_class.call(null,o1);
var o2_str = fluree.db.flake.cc_cmp_class.call(null,o2);
var type_cmp = cljs.core.compare.call(null,o1_str,o2_str);
if(cljs.core._EQ_.call(null,(0),type_cmp)){
return cljs.core.compare.call(null,o1,o2);
} else {
return type_cmp;
}
} else {
return (0);
}
});
fluree.db.flake.cmp_bool = (function fluree$db$flake$cmp_bool(b1,b2){
if(((cljs.core.boolean_QMARK_.call(null,b1)) && (cljs.core.boolean_QMARK_.call(null,b2)))){
return cljs.core.compare.call(null,b1,b2);
} else {
return (0);
}
});
/**
 * Meta will always be a map or nil, but can be searched using an integer to
 *   perform effective range scans if needed. i.e. (Integer/MIN_VALUE)
 *   to (Integer/MAX_VALUE) will always include all meta values.
 */
fluree.db.flake.cmp_meta = (function fluree$db$flake$cmp_meta(m1,m2){
var m1h = ((cljs.core.int_QMARK_.call(null,m1))?m1:cljs.core.hash.call(null,m1));
var m2h = ((cljs.core.int_QMARK_.call(null,m2))?m2:cljs.core.hash.call(null,m2));
return (m1h - m2h);
});
fluree.db.flake.cmp_long = (function fluree$db$flake$cmp_long(l1,l2){
if(cljs.core.truth_((function (){var and__5043__auto__ = l1;
if(cljs.core.truth_(and__5043__auto__)){
return l2;
} else {
return and__5043__auto__;
}
})())){
return (l1 - l2);
} else {
return (0);
}
});
/**
 * Comparator for subject values. The supplied values are reversed before the
 *   comparison to account for the decreasing sort order of subjects
 */
fluree.db.flake.cmp_subj = (function fluree$db$flake$cmp_subj(s1,s2){
return fluree.db.flake.cmp_long.call(null,s2,s1);
});
fluree.db.flake.cmp_pred = (function fluree$db$flake$cmp_pred(p1,p2){
return fluree.db.flake.cmp_long.call(null,p1,p2);
});
/**
 * Comparator for transaction values. The supplied values are reversed before the
 *   comparison to account for the decreasing sort order of transactions
 */
fluree.db.flake.cmp_tx = (function fluree$db$flake$cmp_tx(t1,t2){
return fluree.db.flake.cmp_long.call(null,t2,t1);
});
fluree.db.flake.cmp_obj = (function fluree$db$flake$cmp_obj(o1,o2){
return fluree.db.flake.cmp_val_xtype.call(null,o1,o2);
});
fluree.db.flake.cmp_op = (function fluree$db$flake$cmp_op(op1,op2){
return fluree.db.flake.cmp_bool.call(null,op1,op2);
});
fluree.db.flake.cmp_flakes_spot = (function fluree$db$flake$cmp_flakes_spot(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_subj.call(null,fluree.db.flake.s.call(null,f1),fluree.db.flake.s.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = fluree.db.flake.cmp_pred.call(null,fluree.db.flake.p.call(null,f1),fluree.db.flake.p.call(null,f2));
if(((0) === c__13702__auto____$1)){
var c__13702__auto____$2 = fluree.db.flake.cmp_obj.call(null,fluree.db.flake.o.call(null,f1),fluree.db.flake.o.call(null,f2));
if(((0) === c__13702__auto____$2)){
var c__13702__auto____$3 = fluree.db.flake.cmp_tx.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto____$3)){
var c__13702__auto____$4 = fluree.db.flake.cmp_bool.call(null,fluree.db.flake.op.call(null,f1),fluree.db.flake.op.call(null,f2));
if(((0) === c__13702__auto____$4)){
var c__13702__auto____$5 = fluree.db.flake.cmp_meta.call(null,fluree.db.flake.m.call(null,f1),fluree.db.flake.m.call(null,f2));
if(((0) === c__13702__auto____$5)){
return (0);
} else {
return c__13702__auto____$5;
}
} else {
return c__13702__auto____$4;
}
} else {
return c__13702__auto____$3;
}
} else {
return c__13702__auto____$2;
}
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
fluree.db.flake.cmp_flakes_psot = (function fluree$db$flake$cmp_flakes_psot(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_pred.call(null,fluree.db.flake.p.call(null,f1),fluree.db.flake.p.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = fluree.db.flake.cmp_subj.call(null,fluree.db.flake.s.call(null,f1),fluree.db.flake.s.call(null,f2));
if(((0) === c__13702__auto____$1)){
var c__13702__auto____$2 = fluree.db.flake.cmp_obj.call(null,fluree.db.flake.o.call(null,f1),fluree.db.flake.o.call(null,f2));
if(((0) === c__13702__auto____$2)){
var c__13702__auto____$3 = fluree.db.flake.cmp_tx.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto____$3)){
var c__13702__auto____$4 = fluree.db.flake.cmp_bool.call(null,fluree.db.flake.op.call(null,f1),fluree.db.flake.op.call(null,f2));
if(((0) === c__13702__auto____$4)){
var c__13702__auto____$5 = fluree.db.flake.cmp_meta.call(null,fluree.db.flake.m.call(null,f1),fluree.db.flake.m.call(null,f2));
if(((0) === c__13702__auto____$5)){
return (0);
} else {
return c__13702__auto____$5;
}
} else {
return c__13702__auto____$4;
}
} else {
return c__13702__auto____$3;
}
} else {
return c__13702__auto____$2;
}
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
fluree.db.flake.cmp_flakes_post = (function fluree$db$flake$cmp_flakes_post(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_pred.call(null,fluree.db.flake.p.call(null,f1),fluree.db.flake.p.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = fluree.db.flake.cmp_obj.call(null,fluree.db.flake.o.call(null,f1),fluree.db.flake.o.call(null,f2));
if(((0) === c__13702__auto____$1)){
var c__13702__auto____$2 = fluree.db.flake.cmp_subj.call(null,fluree.db.flake.s.call(null,f1),fluree.db.flake.s.call(null,f2));
if(((0) === c__13702__auto____$2)){
var c__13702__auto____$3 = fluree.db.flake.cmp_tx.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto____$3)){
var c__13702__auto____$4 = fluree.db.flake.cmp_bool.call(null,fluree.db.flake.op.call(null,f1),fluree.db.flake.op.call(null,f2));
if(((0) === c__13702__auto____$4)){
var c__13702__auto____$5 = fluree.db.flake.cmp_meta.call(null,fluree.db.flake.m.call(null,f1),fluree.db.flake.m.call(null,f2));
if(((0) === c__13702__auto____$5)){
return (0);
} else {
return c__13702__auto____$5;
}
} else {
return c__13702__auto____$4;
}
} else {
return c__13702__auto____$3;
}
} else {
return c__13702__auto____$2;
}
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
fluree.db.flake.cmp_flakes_opst = (function fluree$db$flake$cmp_flakes_opst(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_subj.call(null,fluree.db.flake.o.call(null,f1),fluree.db.flake.o.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = fluree.db.flake.cmp_pred.call(null,fluree.db.flake.p.call(null,f1),fluree.db.flake.p.call(null,f2));
if(((0) === c__13702__auto____$1)){
var c__13702__auto____$2 = fluree.db.flake.cmp_subj.call(null,fluree.db.flake.s.call(null,f1),fluree.db.flake.s.call(null,f2));
if(((0) === c__13702__auto____$2)){
var c__13702__auto____$3 = fluree.db.flake.cmp_tx.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto____$3)){
var c__13702__auto____$4 = fluree.db.flake.cmp_bool.call(null,fluree.db.flake.op.call(null,f1),fluree.db.flake.op.call(null,f2));
if(((0) === c__13702__auto____$4)){
var c__13702__auto____$5 = fluree.db.flake.cmp_meta.call(null,fluree.db.flake.m.call(null,f1),fluree.db.flake.m.call(null,f2));
if(((0) === c__13702__auto____$5)){
return (0);
} else {
return c__13702__auto____$5;
}
} else {
return c__13702__auto____$4;
}
} else {
return c__13702__auto____$3;
}
} else {
return c__13702__auto____$2;
}
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
/**
 * Comparison for flakes in blocks. Like cmp-flakes-spot, but with 't'
 *   moved up front.
 */
fluree.db.flake.cmp_flakes_block = (function fluree$db$flake$cmp_flakes_block(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_tx.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = fluree.db.flake.cmp_subj.call(null,fluree.db.flake.s.call(null,f1),fluree.db.flake.s.call(null,f2));
if(((0) === c__13702__auto____$1)){
var c__13702__auto____$2 = fluree.db.flake.cmp_pred.call(null,fluree.db.flake.p.call(null,f1),fluree.db.flake.p.call(null,f2));
if(((0) === c__13702__auto____$2)){
var c__13702__auto____$3 = fluree.db.flake.cmp_obj.call(null,fluree.db.flake.o.call(null,f1),fluree.db.flake.o.call(null,f2));
if(((0) === c__13702__auto____$3)){
var c__13702__auto____$4 = fluree.db.flake.cmp_bool.call(null,fluree.db.flake.op.call(null,f1),fluree.db.flake.op.call(null,f2));
if(((0) === c__13702__auto____$4)){
var c__13702__auto____$5 = fluree.db.flake.cmp_meta.call(null,fluree.db.flake.m.call(null,f1),fluree.db.flake.m.call(null,f2));
if(((0) === c__13702__auto____$5)){
return (0);
} else {
return c__13702__auto____$5;
}
} else {
return c__13702__auto____$4;
}
} else {
return c__13702__auto____$3;
}
} else {
return c__13702__auto____$2;
}
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
/**
 * Note this is not suitable for a set, only a vector/list.
 */
fluree.db.flake.cmp_flakes_history = (function fluree$db$flake$cmp_flakes_history(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_long.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = cljs.core.compare.call(null,fluree.db.flake.op.call(null,f2),fluree.db.flake.op.call(null,f1));
if(((0) === c__13702__auto____$1)){
return (0);
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
/**
 * Sorts by transaction time in ascending order (newest first), then by
 *   the boolean operation descending so assertions (true) come before retractions (false)
 *   so that we can 're-play' the log in reverse order to come up with historical states.
 *   Suitable only for sorting a vector, not a sorted set.
 */
fluree.db.flake.cmp_history_quick_reverse_sort = (function fluree$db$flake$cmp_history_quick_reverse_sort(f1,f2){
var c__13702__auto__ = fluree.db.flake.cmp_long.call(null,fluree.db.flake.t.call(null,f1),fluree.db.flake.t.call(null,f2));
if(((0) === c__13702__auto__)){
var c__13702__auto____$1 = cljs.core.compare.call(null,fluree.db.flake.op.call(null,f2),fluree.db.flake.op.call(null,f1));
if(((0) === c__13702__auto____$1)){
return (0);
} else {
return c__13702__auto____$1;
}
} else {
return c__13702__auto__;
}
});
fluree.db.flake.new_flake = (function fluree$db$flake$new_flake(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13845 = arguments.length;
var i__5770__auto___13846 = (0);
while(true){
if((i__5770__auto___13846 < len__5769__auto___13845)){
args__5775__auto__.push((arguments[i__5770__auto___13846]));

var G__13847 = (i__5770__auto___13846 + (1));
i__5770__auto___13846 = G__13847;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.flake.new_flake.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.flake.new_flake.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
var vec__13842 = parts;
var s = cljs.core.nth.call(null,vec__13842,(0),null);
var p = cljs.core.nth.call(null,vec__13842,(1),null);
var o = cljs.core.nth.call(null,vec__13842,(2),null);
var t = cljs.core.nth.call(null,vec__13842,(3),null);
var op = cljs.core.nth.call(null,vec__13842,(4),null);
var m = cljs.core.nth.call(null,vec__13842,(5),null);
return fluree.db.flake.__GT_Flake.call(null,s,p,o,t,op,m);
}));

(fluree.db.flake.new_flake.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.flake.new_flake.cljs$lang$applyTo = (function (seq13841){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq13841));
}));

/**
 * Takes a flake and returns one with the provided block and op flipped from true/false.
 *   Don't over-ride no-history, even if no-history for this predicate has changed. New inserts
 *   will have the no-history flag, but we need the old inserts to be properly retracted in the txlog.
 */
fluree.db.flake.flip_flake = (function fluree$db$flake$flip_flake(var_args){
var G__13849 = arguments.length;
switch (G__13849) {
case 1:
return fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1 = (function (flake){
return fluree.db.flake.__GT_Flake.call(null,fluree.db.flake.s.call(null,flake),fluree.db.flake.p.call(null,flake),fluree.db.flake.o.call(null,flake),fluree.db.flake.t.call(null,flake),cljs.core.not.call(null,fluree.db.flake.op.call(null,flake)),fluree.db.flake.m.call(null,flake));
}));

(fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$2 = (function (flake,tx){
return fluree.db.flake.__GT_Flake.call(null,fluree.db.flake.s.call(null,flake),fluree.db.flake.p.call(null,flake),fluree.db.flake.o.call(null,flake),tx,cljs.core.not.call(null,fluree.db.flake.op.call(null,flake)),fluree.db.flake.m.call(null,flake));
}));

(fluree.db.flake.flip_flake.cljs$lang$maxFixedArity = 2);

/**
 * Takes a flake and returns one with the provided block and op flipped from true/false.
 *   Don't over-ride no-history, even if no-history for this predicate has changed. New inserts
 *   will have the no-history flag, but we need the old inserts to be properly retracted in the txlog.
 */
fluree.db.flake.change_t = (function fluree$db$flake$change_t(flake,t){
return fluree.db.flake.__GT_Flake.call(null,fluree.db.flake.s.call(null,flake),fluree.db.flake.p.call(null,flake),fluree.db.flake.o.call(null,flake),t,fluree.db.flake.op.call(null,flake),fluree.db.flake.m.call(null,flake));
});
/**
 * From and to are Flakes
 */
fluree.db.flake.slice = (function fluree$db$flake$slice(ss,from,to){
if(cljs.core.truth_((function (){var and__5043__auto__ = from;
if(cljs.core.truth_(and__5043__auto__)){
return to;
} else {
return and__5043__auto__;
}
})())){
return clojure.data.avl.subrange.call(null,ss,cljs.core._GT__EQ_,from,cljs.core._LT__EQ_,to);
} else {
if((from == null)){
return clojure.data.avl.subrange.call(null,ss,cljs.core._LT__EQ_,to);
} else {
if((to == null)){
return clojure.data.avl.subrange.call(null,ss,cljs.core._GT__EQ_,from);
} else {
throw cljs.core.ex_info.call(null,"Unexpected error performing slice, both from and to conditions are nil. Please report.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
}
});
fluree.db.flake.lookup = (function fluree$db$flake$lookup(ss,start_flake,end_flake){
return clojure.data.avl.subrange.call(null,ss,cljs.core._GT__EQ_,start_flake,cljs.core._LT__EQ_,end_flake);
});
fluree.db.flake.subrange = (function fluree$db$flake$subrange(var_args){
var G__13852 = arguments.length;
switch (G__13852) {
case 3:
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$3 = (function (ss,test,flake){
return clojure.data.avl.subrange.call(null,ss,test,flake);
}));

(fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5 = (function (ss,start_test,start_flake,end_test,end_flake){
return clojure.data.avl.subrange.call(null,ss,start_test,start_flake,end_test,end_flake);
}));

(fluree.db.flake.subrange.cljs$lang$maxFixedArity = 5);

fluree.db.flake.split_at = (function fluree$db$flake$split_at(n,ss){
return clojure.data.avl.split_at.call(null,n,ss);
});
fluree.db.flake.lower_than_all_QMARK_ = (function fluree$db$flake$lower_than_all_QMARK_(f,ss){
var vec__13854 = clojure.data.avl.split_key.call(null,f,ss);
var lower = cljs.core.nth.call(null,vec__13854,(0),null);
var e = cljs.core.nth.call(null,vec__13854,(1),null);
var _ = cljs.core.nth.call(null,vec__13854,(2),null);
return (((e == null)) && (cljs.core.empty_QMARK_.call(null,lower)));
});
fluree.db.flake.higher_than_all_QMARK_ = (function fluree$db$flake$higher_than_all_QMARK_(f,ss){
var vec__13857 = clojure.data.avl.split_key.call(null,f,ss);
var _ = cljs.core.nth.call(null,vec__13857,(0),null);
var e = cljs.core.nth.call(null,vec__13857,(1),null);
var upper = cljs.core.nth.call(null,vec__13857,(2),null);
return (((e == null)) && (cljs.core.empty_QMARK_.call(null,upper)));
});
/**
 * Splits a sorted set at a given flake. If there is an exact match for flake,
 *   puts it in the left-side. Primarily for use with last-flake.
 */
fluree.db.flake.split_by_flake = (function fluree$db$flake$split_by_flake(f,ss){
var vec__13860 = clojure.data.avl.split_key.call(null,f,ss);
var l = cljs.core.nth.call(null,vec__13860,(0),null);
var e = cljs.core.nth.call(null,vec__13860,(1),null);
var r = cljs.core.nth.call(null,vec__13860,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(e)?cljs.core.conj.call(null,l,e):l),r], null);
});
fluree.db.flake.sorted_set_by = (function fluree$db$flake$sorted_set_by(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13865 = arguments.length;
var i__5770__auto___13866 = (0);
while(true){
if((i__5770__auto___13866 < len__5769__auto___13865)){
args__5775__auto__.push((arguments[i__5770__auto___13866]));

var G__13867 = (i__5770__auto___13866 + (1));
i__5770__auto___13866 = G__13867;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,flakes){
return cljs.core.apply.call(null,clojure.data.avl.sorted_set_by,comparator,flakes);
}));

(fluree.db.flake.sorted_set_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.flake.sorted_set_by.cljs$lang$applyTo = (function (seq13863){
var G__13864 = cljs.core.first.call(null,seq13863);
var seq13863__$1 = cljs.core.next.call(null,seq13863);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13864,seq13863__$1);
}));

fluree.db.flake.sorted_map_by = (function fluree$db$flake$sorted_map_by(var_args){
var args__5775__auto__ = [];
var len__5769__auto___13870 = arguments.length;
var i__5770__auto___13871 = (0);
while(true){
if((i__5770__auto___13871 < len__5769__auto___13870)){
args__5775__auto__.push((arguments[i__5770__auto___13871]));

var G__13872 = (i__5770__auto___13871 + (1));
i__5770__auto___13871 = G__13872;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.flake.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.flake.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,entries){
return cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,comparator,entries);
}));

(fluree.db.flake.sorted_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.flake.sorted_map_by.cljs$lang$applyTo = (function (seq13868){
var G__13869 = cljs.core.first.call(null,seq13868);
var seq13868__$1 = cljs.core.next.call(null,seq13868);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__13869,seq13868__$1);
}));

fluree.db.flake.transient_reduce = (function fluree$db$flake$transient_reduce(reducer,ss,coll){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,reducer,cljs.core.transient$.call(null,ss),coll));
});
/**
 * Adds all flakes in the `to-add` collection from the AVL-backed sorted flake set
 *   `sorted-set`. This function uses transients for intermediate set values for
 *   better performance because of the slower batched update performance of
 *   AVL-backed sorted sets.
 */
fluree.db.flake.conj_all = (function fluree$db$flake$conj_all(ss,to_add){
return fluree.db.flake.transient_reduce.call(null,cljs.core.conj_BANG_,ss,to_add);
});
/**
 * Removes all flakes in the `to-remove` collection from the AVL-backed sorted
 *   flake set `sorted-set`. This function uses transients for intermediate set
 *   values for better performance because of the slower batched update performance
 *   of AVL-backed sorted sets.
 */
fluree.db.flake.disj_all = (function fluree$db$flake$disj_all(ss,to_remove){
return fluree.db.flake.transient_reduce.call(null,cljs.core.disj_BANG_,ss,to_remove);
});
fluree.db.flake.assoc_all = (function fluree$db$flake$assoc_all(sm,entries){
return fluree.db.flake.transient_reduce.call(null,(function (m,p__13873){
var vec__13874 = p__13873;
var k = cljs.core.nth.call(null,vec__13874,(0),null);
var v = cljs.core.nth.call(null,vec__13874,(1),null);
return cljs.core.assoc_BANG_.call(null,m,k,v);
}),sm,entries);
});
fluree.db.flake.dissoc_all = (function fluree$db$flake$dissoc_all(sm,ks){
return fluree.db.flake.transient_reduce.call(null,cljs.core.dissoc_BANG_,sm,ks);
});
/**
 * Returns the last item in `ss` in constant time as long as `ss` is a sorted
 *   set.
 */
fluree.db.flake.last = (function fluree$db$flake$last(ss){
return cljs.core.first.call(null,cljs.core.rseq.call(null,ss));
});
/**
 * Base size of a flake is 38 bytes... then add size for 'o' and 'm'.
 *   Flakes have the following:
 *  - s - 8 bytes
 *  - p - 8 bytes
 *  - o - ??
 *  - t - 8 bytes
 *  - add? - 1 byte
 *  - m - 1 byte + ??
 *  - header - 12 bytes - object header...
 * 
 *   Objects will be rounded up to nearest 8 bytes... we don't do this here as
 *   it should be 'close enough'
 *   reference: https://www.javamex.com/tutorials/memory/string_memory_usage.shtml
 */
fluree.db.flake.size_flake = (function fluree$db$flake$size_flake(f){
var o = fluree.db.flake.o.call(null,f);
return (((37) + ((cljs.core.pr_str.call(null,o)).length)) + (((fluree.db.flake.m.call(null,f) == null))?(1):((2) * ((cljs.core.pr_str.call(null,fluree.db.flake.m.call(null,f))).length))));
});
/**
 * Returns approx number of bytes in a collection of flakes.
 */
fluree.db.flake.size_bytes = (function fluree$db$flake$size_bytes(flakes){
return cljs.core.reduce.call(null,(function (p1__13877_SHARP_,p2__13878_SHARP_){
return (p1__13877_SHARP_ + fluree.db.flake.size_flake.call(null,p2__13878_SHARP_));
}),(0),flakes);
});
/**
 * Like size-bytes, but kb.
 *   Rounds down for simplicity, as bytes is just an estimate anyhow.
 */
fluree.db.flake.size_kb = (function fluree$db$flake$size_kb(flakes){
return Math.round((fluree.db.flake.size_bytes.call(null,flakes) / (1000)));
});
/**
 * Takes n flakes from a sorted flake set, retaining the set itself.
 */
fluree.db.flake.take = (function fluree$db$flake$take(n,flake_set){
if((n >= cljs.core.count.call(null,flake_set))){
return flake_set;
} else {
var k = cljs.core.nth.call(null,flake_set,n);
return cljs.core.first.call(null,clojure.data.avl.split_key.call(null,k,flake_set));
}
});
