// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.range');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.call(null,param_str):param_str);
if(cljs.core.map_QMARK_.call(null,parsed_param)){
var key = cljs.core.first.call(null,cljs.core.keys.call(null,parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace.call(null,key) == null))?cljs.core.name.call(null,key):[cljs.core.namespace.call(null,key),"/",cljs.core.name.call(null,key)].join('')));
var value = cljs.core.first.call(null,cljs.core.vals.call(null,parsed_param));
var value_SINGLEQUOTE_ = fluree.db.dbfunctions.internal.parse_select_map.call(null,value);
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,value_SINGLEQUOTE_))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.call(null,cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_.call(null,parsed_param)))){
if((cljs.core.namespace.call(null,parsed_param) == null)){
return cljs.core.name.call(null,parsed_param);
} else {
return [cljs.core.namespace.call(null,parsed_param),"/",cljs.core.name.call(null,parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_.call(null,parsed_param)){
return cljs.core.mapv.call(null,fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.call(null,["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27961 = arguments.length;
var i__5770__auto___27962 = (0);
while(true){
if((i__5770__auto___27962 < len__5769__auto___27961)){
args__5775__auto__.push((arguments[i__5770__auto___27962]));

var G__27963 = (i__5770__auto___27962 + (1));
i__5770__auto___27962 = G__27963;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.call(null,e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.call(null,args));

throw cljs.core.ex_info.call(null,(function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_.call(null,args))?clojure.string.join.call(null," ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq27958){
var G__27959 = cljs.core.first.call(null,seq27958);
var seq27958__$1 = cljs.core.next.call(null,seq27958);
var G__27960 = cljs.core.first.call(null,seq27958__$1);
var seq27958__$2 = cljs.core.next.call(null,seq27958__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27959,G__27960,seq27958__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$.call(null,x);
}catch (e27964){var e = e27964;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"boolean",x);
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e27965){var e = e27965;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nil?",arg);
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not.call(null,arg);
}catch (e27966){var e = e27966;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not",arg);
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_.call(null,arg)) || (cljs.core._EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e27967){var e = e27967;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"empty?",arg);
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e27968){var e = e27968;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"if-else",test,true_res,false_res);
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27971 = arguments.length;
var i__5770__auto___27972 = (0);
while(true){
if((i__5770__auto___27972 < len__5769__auto___27971)){
args__5775__auto__.push((arguments[i__5770__auto___27972]));

var G__27973 = (i__5770__auto___27972 + (1));
i__5770__auto___27972 = G__27973;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27970){var e = e27970;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"and",args);
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq27969){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27969));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27976 = arguments.length;
var i__5770__auto___27977 = (0);
while(true){
if((i__5770__auto___27977 < len__5769__auto___27976)){
args__5775__auto__.push((arguments[i__5770__auto___27977]));

var G__27978 = (i__5770__auto___27977 + (1));
i__5770__auto___27977 = G__27978;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.call(null,fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.some.call(null,cljs.core.true_QMARK_,coerced_coll));
}
}catch (e27975){var e = e27975;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"or",args);
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq27974){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27974));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count.call(null,coll);
}catch (e27979){var e = e27979;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"count",coll);
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27982 = arguments.length;
var i__5770__auto___27983 = (0);
while(true){
if((i__5770__auto___27983 < len__5769__auto___27982)){
args__5775__auto__.push((arguments[i__5770__auto___27983]));

var G__27984 = (i__5770__auto___27983 + (1));
i__5770__auto___27983 = G__27984;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.str,args);
}catch (e27981){var e = e27981;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"str",args);
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq27980){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27980));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27987 = arguments.length;
var i__5770__auto___27988 = (0);
while(true){
if((i__5770__auto___27988 < len__5769__auto___27987)){
args__5775__auto__.push((arguments[i__5770__auto___27988]));

var G__27989 = (i__5770__auto___27988 + (1));
i__5770__auto___27988 = G__27989;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.subs,args);
}catch (e27986){var e = e27986;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"subs",args);
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq27985){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27985));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case.call(null,str);
}catch (e27990){var e = e27990;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"lower-case",str);
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case.call(null,str);
}catch (e27991){var e = e27991;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"upper-case",str);
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27994 = arguments.length;
var i__5770__auto___27995 = (0);
while(true){
if((i__5770__auto___27995 < len__5769__auto___27994)){
args__5775__auto__.push((arguments[i__5770__auto___27995]));

var G__27996 = (i__5770__auto___27995 + (1));
i__5770__auto___27995 = G__27996;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.max,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27993){var e = e27993;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"max",args);
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq27992){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27992));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___27999 = arguments.length;
var i__5770__auto___28000 = (0);
while(true){
if((i__5770__auto___28000 < len__5769__auto___27999)){
args__5775__auto__.push((arguments[i__5770__auto___28000]));

var G__28001 = (i__5770__auto___28000 + (1));
i__5770__auto___28000 = G__28001;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e27998){var e = e27998;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"min",args);
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq27997){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq27997));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28004 = arguments.length;
var i__5770__auto___28005 = (0);
while(true){
if((i__5770__auto___28005 < len__5769__auto___28004)){
args__5775__auto__.push((arguments[i__5770__auto___28005]));

var G__28006 = (i__5770__auto___28005 + (1));
i__5770__auto___28005 = G__28006;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT_,args);
}catch (e28003){var e = e28003;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">",args);
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28002){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28002));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28009 = arguments.length;
var i__5770__auto___28010 = (0);
while(true){
if((i__5770__auto___28010 < len__5769__auto___28009)){
args__5775__auto__.push((arguments[i__5770__auto___28010]));

var G__28011 = (i__5770__auto___28010 + (1));
i__5770__auto___28010 = G__28011;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._GT__EQ_,args);
}catch (e28008){var e = e28008;
return fluree.db.dbfunctions.internal.function_error.call(null,e,">=",args);
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28007){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28007));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28014 = arguments.length;
var i__5770__auto___28015 = (0);
while(true){
if((i__5770__auto___28015 < len__5769__auto___28014)){
args__5775__auto__.push((arguments[i__5770__auto___28015]));

var G__28016 = (i__5770__auto___28015 + (1));
i__5770__auto___28015 = G__28016;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT_,args);
}catch (e28013){var e = e28013;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<",args);
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28012){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28012));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28019 = arguments.length;
var i__5770__auto___28020 = (0);
while(true){
if((i__5770__auto___28020 < len__5769__auto___28019)){
args__5775__auto__.push((arguments[i__5770__auto___28020]));

var G__28021 = (i__5770__auto___28020 + (1));
i__5770__auto___28020 = G__28021;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._LT__EQ_,args);
}catch (e28018){var e = e28018;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"<=",args);
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28017){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28017));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28024 = arguments.length;
var i__5770__auto___28025 = (0);
while(true){
if((i__5770__auto___28025 < len__5769__auto___28024)){
args__5775__auto__.push((arguments[i__5770__auto___28025]));

var G__28026 = (i__5770__auto___28025 + (1));
i__5770__auto___28025 = G__28026;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.not_EQ_,args);
}catch (e28023){var e = e28023;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"not=",args);
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28022){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28022));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28028 = arguments.length;
switch (G__28028) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28056){
var state_val_28057 = (state_28056[(1)]);
if((state_val_28057 === (7))){
var inst_28041 = (state_28056[(7)]);
var inst_28044 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28041,"query",query_map);
var state_28056__$1 = state_28056;
var statearr_28058_28144 = state_28056__$1;
(statearr_28058_28144[(2)] = inst_28044);

(statearr_28058_28144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (1))){
var state_28056__$1 = state_28056;
var statearr_28059_28145 = state_28056__$1;
(statearr_28059_28145[(2)] = null);

(statearr_28059_28145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (4))){
var inst_28029 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
var statearr_28060_28146 = state_28056__$1;
(statearr_28060_28146[(2)] = inst_28029);

(statearr_28060_28146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (6))){
var inst_28041 = (state_28056[(7)]);
var inst_28041__$1 = (state_28056[(2)]);
var inst_28042 = fluree.db.util.core.exception_QMARK_.call(null,inst_28041__$1);
var state_28056__$1 = (function (){var statearr_28061 = state_28056;
(statearr_28061[(7)] = inst_28041__$1);

return statearr_28061;
})();
if(inst_28042){
var statearr_28062_28147 = state_28056__$1;
(statearr_28062_28147[(1)] = (7));

} else {
var statearr_28063_28148 = state_28056__$1;
(statearr_28063_28148[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (3))){
var inst_28054 = (state_28056[(2)]);
var state_28056__$1 = state_28056;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28056__$1,inst_28054);
} else {
if((state_val_28057 === (2))){
var inst_28035 = (state_28056[(8)]);
var _ = (function (){var statearr_28065 = state_28056;
(statearr_28065[(4)] = cljs.core.cons.call(null,(5),(state_28056[(4)])));

return statearr_28065;
})();
var inst_28035__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28036 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28037 = cljs.core.assoc.call(null,inst_28036,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28035__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000));
var inst_28038 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28037);
var inst_28039 = fluree.db.query.fql.query.call(null,db,inst_28038);
var state_28056__$1 = (function (){var statearr_28066 = state_28056;
(statearr_28066[(8)] = inst_28035__$1);

return statearr_28066;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28056__$1,(6),inst_28039);
} else {
if((state_val_28057 === (9))){
var inst_28051 = (state_28056[(2)]);
var _ = (function (){var statearr_28067 = state_28056;
(statearr_28067[(4)] = cljs.core.rest.call(null,(state_28056[(4)])));

return statearr_28067;
})();
var state_28056__$1 = state_28056;
var statearr_28068_28149 = state_28056__$1;
(statearr_28068_28149[(2)] = inst_28051);

(statearr_28068_28149[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (5))){
var _ = (function (){var statearr_28069 = state_28056;
(statearr_28069[(4)] = cljs.core.rest.call(null,(state_28056[(4)])));

return statearr_28069;
})();
var state_28056__$1 = state_28056;
var ex28064 = (state_28056__$1[(2)]);
var statearr_28070_28150 = state_28056__$1;
(statearr_28070_28150[(5)] = ex28064);


if((ex28064 instanceof Error)){
var statearr_28071_28151 = state_28056__$1;
(statearr_28071_28151[(1)] = (4));

(statearr_28071_28151[(5)] = null);

} else {
throw ex28064;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28057 === (8))){
var inst_28041 = (state_28056[(7)]);
var inst_28035 = (state_28056[(8)]);
var inst_28046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28047 = cljs.core.deref.call(null,inst_28035);
var inst_28048 = [inst_28041,inst_28047];
var inst_28049 = (new cljs.core.PersistentVector(null,2,(5),inst_28046,inst_28048,null));
var state_28056__$1 = state_28056;
var statearr_28072_28152 = state_28056__$1;
(statearr_28072_28152[(2)] = inst_28049);

(statearr_28072_28152[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28073 = [null,null,null,null,null,null,null,null,null];
(statearr_28073[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28073[(1)] = (1));

return statearr_28073;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28056){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28056);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28074){var ex__2749__auto__ = e28074;
var statearr_28075_28153 = state_28056;
(statearr_28075_28153[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28056[(4)]))){
var statearr_28076_28154 = state_28056;
(statearr_28076_28154[(1)] = cljs.core.first.call(null,(state_28056[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28155 = state_28056;
state_28056 = G__28155;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28056){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28056);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28077 = f__2769__auto__.call(null);
(statearr_28077[(6)] = c__2768__auto__);

return statearr_28077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28122){
var state_val_28123 = (state_28122[(1)]);
if((state_val_28123 === (7))){
var inst_28108 = (state_28122[(2)]);
var inst_28109 = fluree.db.query.fql.query.call(null,db,inst_28108);
var state_28122__$1 = state_28122;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28122__$1,(8),inst_28109);
} else {
if((state_val_28123 === (1))){
var inst_28078 = typeof select === 'string';
var state_28122__$1 = state_28122;
if(cljs.core.truth_(inst_28078)){
var statearr_28124_28156 = state_28122__$1;
(statearr_28124_28156[(1)] = (2));

} else {
var statearr_28125_28157 = state_28122__$1;
(statearr_28125_28157[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (4))){
var inst_28084 = (state_28122[(7)]);
var inst_28091 = (state_28122[(8)]);
var inst_28083 = (state_28122[(2)]);
var inst_28084__$1 = cljs.core.volatile_BANG_.call(null,(0));
var inst_28085 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28086 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28087 = [inst_28084__$1,(100000)];
var inst_28088 = cljs.core.PersistentHashMap.fromArrays(inst_28086,inst_28087);
var inst_28089 = [inst_28083,from,where,block,limit,inst_28088];
var inst_28090 = cljs.core.PersistentHashMap.fromArrays(inst_28085,inst_28089);
var inst_28091__$1 = fluree.db.util.core.without_nils.call(null,inst_28090);
var inst_28092 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28091__$1);
var inst_28093 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28091__$1);
var inst_28094 = cljs.core.first.call(null,inst_28093);
var inst_28095 = fluree.db.dbfunctions.internal.str.call(null,inst_28094);
var inst_28096 = cljs.core._EQ_.call(null,"[",inst_28095);
var inst_28097 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28091__$1);
var inst_28098 = cljs.core.last.call(null,inst_28097);
var inst_28099 = fluree.db.dbfunctions.internal.str.call(null,inst_28098);
var inst_28100 = cljs.core._EQ_.call(null,"]",inst_28099);
var inst_28101 = fluree.db.dbfunctions.internal.and.call(null,inst_28092,inst_28096,inst_28100);
var state_28122__$1 = (function (){var statearr_28126 = state_28122;
(statearr_28126[(7)] = inst_28084__$1);

(statearr_28126[(8)] = inst_28091__$1);

return statearr_28126;
})();
if(cljs.core.truth_(inst_28101)){
var statearr_28127_28158 = state_28122__$1;
(statearr_28127_28158[(1)] = (5));

} else {
var statearr_28128_28159 = state_28122__$1;
(statearr_28128_28159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (6))){
var inst_28091 = (state_28122[(8)]);
var state_28122__$1 = state_28122;
var statearr_28129_28160 = state_28122__$1;
(statearr_28129_28160[(2)] = inst_28091);

(statearr_28129_28160[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (3))){
var state_28122__$1 = state_28122;
var statearr_28130_28161 = state_28122__$1;
(statearr_28130_28161[(2)] = select);

(statearr_28130_28161[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (2))){
var inst_28080 = fluree.db.dbfunctions.internal.parse_select_map.call(null,select);
var state_28122__$1 = state_28122;
var statearr_28131_28162 = state_28122__$1;
(statearr_28131_28162[(2)] = inst_28080);

(statearr_28131_28162[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (11))){
var inst_28120 = (state_28122[(2)]);
var state_28122__$1 = state_28122;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28122__$1,inst_28120);
} else {
if((state_val_28123 === (9))){
var inst_28111 = (state_28122[(9)]);
var state_28122__$1 = state_28122;
var statearr_28132_28163 = state_28122__$1;
(statearr_28132_28163[(2)] = inst_28111);

(statearr_28132_28163[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (5))){
var inst_28091 = (state_28122[(8)]);
var inst_28103 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28091);
var inst_28104 = cljs.reader.read_string.call(null,inst_28103);
var inst_28105 = cljs.core.assoc.call(null,inst_28091,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28104);
var state_28122__$1 = state_28122;
var statearr_28133_28164 = state_28122__$1;
(statearr_28133_28164[(2)] = inst_28105);

(statearr_28133_28164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (10))){
var inst_28111 = (state_28122[(9)]);
var inst_28084 = (state_28122[(7)]);
var inst_28115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28116 = cljs.core.deref.call(null,inst_28084);
var inst_28117 = [inst_28111,inst_28116];
var inst_28118 = (new cljs.core.PersistentVector(null,2,(5),inst_28115,inst_28117,null));
var state_28122__$1 = state_28122;
var statearr_28134_28165 = state_28122__$1;
(statearr_28134_28165[(2)] = inst_28118);

(statearr_28134_28165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28123 === (8))){
var inst_28111 = (state_28122[(9)]);
var inst_28111__$1 = (state_28122[(2)]);
var inst_28112 = fluree.db.util.core.exception_QMARK_.call(null,inst_28111__$1);
var state_28122__$1 = (function (){var statearr_28135 = state_28122;
(statearr_28135[(9)] = inst_28111__$1);

return statearr_28135;
})();
if(inst_28112){
var statearr_28136_28166 = state_28122__$1;
(statearr_28136_28166[(1)] = (9));

} else {
var statearr_28137_28167 = state_28122__$1;
(statearr_28137_28167[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28138 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28138[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28138[(1)] = (1));

return statearr_28138;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28122){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28122);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28139){var ex__2749__auto__ = e28139;
var statearr_28140_28168 = state_28122;
(statearr_28140_28168[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28122[(4)]))){
var statearr_28141_28169 = state_28122;
(statearr_28141_28169[(1)] = cljs.core.first.call(null,(state_28122[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28170 = state_28122;
state_28122 = G__28170;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28122){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28142 = f__2769__auto__.call(null);
(statearr_28142[(6)] = c__2768__auto__);

return statearr_28142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.call(null,fluree.db.dbfunctions.internal.str.call(null,"Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace.call(null,pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28174 = path;
var vec__28175 = G__28174;
var seq__28176 = cljs.core.seq.call(null,vec__28175);
var first__28177 = cljs.core.first.call(null,seq__28176);
var seq__28176__$1 = cljs.core.next.call(null,seq__28176);
var var$ = first__28177;
var r = seq__28176__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28174__$1 = G__28174;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28181 = G__28174__$1;
var seq__28182 = cljs.core.seq.call(null,vec__28181);
var first__28183 = cljs.core.first.call(null,seq__28182);
var seq__28182__$1 = cljs.core.next.call(null,seq__28182);
var var$__$1 = first__28183;
var r__$1 = seq__28182__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.call(null,fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_.call(null,r__$1)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path.call(null,startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_.call(null,where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null)], null));
var G__28184 = r__$1;
var G__28185 = n__$2;
var G__28186 = next_clauses;
G__28174__$1 = G__28184;
n__$1 = G__28185;
where_clauses__$1 = G__28186;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",next_n),fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,fluree.db.dbfunctions.internal.str.call(null,"?var",next_n)], null));
var G__28187 = r__$1;
var G__28188 = next_n;
var G__28189 = cljs.core.conj.call(null,where_clauses__$2,next_clause);
G__28174__$1 = G__28187;
n__$1 = G__28188;
where_clauses__$1 = G__28189;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_.call(null,var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var.call(null,var$__$1),fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.call(null,"?var",n__$2),var$__$1,endSubject], null));
return cljs.core.conj.call(null,where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28226){
var state_val_28227 = (state_28226[(1)]);
if((state_val_28227 === (7))){
var inst_28199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28200 = [path];
var inst_28201 = (new cljs.core.PersistentVector(null,1,(5),inst_28199,inst_28200,null));
var state_28226__$1 = state_28226;
var statearr_28228_28256 = state_28226__$1;
(statearr_28228_28256[(2)] = inst_28201);

(statearr_28228_28256[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (1))){
var state_28226__$1 = state_28226;
var statearr_28229_28257 = state_28226__$1;
(statearr_28229_28257[(2)] = null);

(statearr_28229_28257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (4))){
var inst_28190 = (state_28226[(2)]);
var state_28226__$1 = state_28226;
var statearr_28230_28258 = state_28226__$1;
(statearr_28230_28258[(2)] = inst_28190);

(statearr_28230_28258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (13))){
var inst_28217 = (state_28226[(2)]);
var inst_28218 = fluree.db.util.async.throw_err.call(null,inst_28217);
var _ = (function (){var statearr_28231 = state_28226;
(statearr_28231[(4)] = cljs.core.rest.call(null,(state_28226[(4)])));

return statearr_28231;
})();
var state_28226__$1 = state_28226;
var statearr_28232_28259 = state_28226__$1;
(statearr_28232_28259[(2)] = inst_28218);

(statearr_28232_28259[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (6))){
var state_28226__$1 = state_28226;
var statearr_28234_28260 = state_28226__$1;
(statearr_28234_28260[(2)] = path);

(statearr_28234_28260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (3))){
var inst_28224 = (state_28226[(2)]);
var state_28226__$1 = state_28226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28226__$1,inst_28224);
} else {
if((state_val_28227 === (12))){
var _ = (function (){var statearr_28235 = state_28226;
(statearr_28235[(4)] = cljs.core.rest.call(null,(state_28226[(4)])));

return statearr_28235;
})();
var state_28226__$1 = state_28226;
var ex28233 = (state_28226__$1[(2)]);
var statearr_28236_28261 = state_28226__$1;
(statearr_28236_28261[(5)] = ex28233);


var statearr_28237_28262 = state_28226__$1;
(statearr_28237_28262[(1)] = (11));

(statearr_28237_28262[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (2))){
var _ = (function (){var statearr_28238 = state_28226;
(statearr_28238[(4)] = cljs.core.cons.call(null,(5),(state_28226[(4)])));

return statearr_28238;
})();
var inst_28196 = cljs.core.vector_QMARK_.call(null,path);
var state_28226__$1 = state_28226;
if(inst_28196){
var statearr_28239_28263 = state_28226__$1;
(statearr_28239_28263[(1)] = (6));

} else {
var statearr_28240_28264 = state_28226__$1;
(statearr_28240_28264[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (11))){
var inst_28203 = (state_28226[(7)]);
var inst_28208 = (state_28226[(2)]);
var inst_28209 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28208,"relationship?",startSubject,inst_28203,endSubject);
var state_28226__$1 = state_28226;
var statearr_28242_28265 = state_28226__$1;
(statearr_28242_28265[(2)] = inst_28209);

(statearr_28242_28265[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (9))){
var inst_28207 = (state_28226[(8)]);
var _ = (function (){var statearr_28243 = state_28226;
(statearr_28243[(4)] = cljs.core.cons.call(null,(12),(state_28226[(4)])));

return statearr_28243;
})();
var inst_28215 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28207);
var state_28226__$1 = state_28226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28226__$1,(13),inst_28215);
} else {
if((state_val_28227 === (5))){
var _ = (function (){var statearr_28244 = state_28226;
(statearr_28244[(4)] = cljs.core.rest.call(null,(state_28226[(4)])));

return statearr_28244;
})();
var state_28226__$1 = state_28226;
var ex28241 = (state_28226__$1[(2)]);
var statearr_28245_28266 = state_28226__$1;
(statearr_28245_28266[(5)] = ex28241);


if((ex28241 instanceof Error)){
var statearr_28246_28267 = state_28226__$1;
(statearr_28246_28267[(1)] = (4));

(statearr_28246_28267[(5)] = null);

} else {
throw ex28241;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (10))){
var inst_28221 = (state_28226[(2)]);
var _ = (function (){var statearr_28247 = state_28226;
(statearr_28247[(4)] = cljs.core.rest.call(null,(state_28226[(4)])));

return statearr_28247;
})();
var state_28226__$1 = state_28226;
var statearr_28248_28268 = state_28226__$1;
(statearr_28248_28268[(2)] = inst_28221);

(statearr_28248_28268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28227 === (8))){
var inst_28203 = (state_28226[(7)]);
var inst_28203__$1 = (state_28226[(2)]);
var inst_28204 = fluree.db.dbfunctions.internal.build_where_clause.call(null,startSubject,inst_28203__$1,endSubject);
var inst_28205 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28206 = ["?var1",inst_28204];
var inst_28207 = cljs.core.PersistentHashMap.fromArrays(inst_28205,inst_28206);
var state_28226__$1 = (function (){var statearr_28249 = state_28226;
(statearr_28249[(8)] = inst_28207);

(statearr_28249[(7)] = inst_28203__$1);

return statearr_28249;
})();
var statearr_28250_28269 = state_28226__$1;
(statearr_28250_28269[(2)] = null);

(statearr_28250_28269[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_28251 = [null,null,null,null,null,null,null,null,null];
(statearr_28251[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_28251[(1)] = (1));

return statearr_28251;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_28226){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28252){var ex__2749__auto__ = e28252;
var statearr_28253_28270 = state_28226;
(statearr_28253_28270[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28226[(4)]))){
var statearr_28254_28271 = state_28226;
(statearr_28254_28271[(1)] = cljs.core.first.call(null,(state_28226[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28272 = state_28226;
state_28226 = G__28272;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__ = function(state_28226){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_28226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28255 = f__2769__auto__.call(null);
(statearr_28255[(6)] = c__2768__auto__);

return statearr_28255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (1);
} else {
return (n + (1));
}
}catch (e28273){var e = e28273;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"inc",n);
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28274){var e = e28274;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"dec",n);
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__5045__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,m,cljs.core.keyword.call(null,k));
}
}catch (e28275){var e = e28275;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get",m,k);
}});
/**
 * Retrieve's a subject's predicate value by doing a lookup.
 *   If multi returns a vector, else a single value.
 */
fluree.db.dbfunctions.internal.get_subj_pred = (function fluree$db$dbfunctions$internal$get_subj_pred(db,sid,pred){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28329){
var state_val_28330 = (state_28329[(1)]);
if((state_val_28330 === (7))){
var state_28329__$1 = state_28329;
var statearr_28331_28369 = state_28329__$1;
(statearr_28331_28369[(2)] = pred);

(statearr_28331_28369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (20))){
var inst_28312 = (state_28329[(7)]);
var inst_28308 = (state_28329[(8)]);
var inst_28316 = cljs.core.mapv.call(null,inst_28312,inst_28308);
var state_28329__$1 = state_28329;
var statearr_28332_28370 = state_28329__$1;
(statearr_28332_28370[(2)] = inst_28316);

(statearr_28332_28370[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (1))){
var state_28329__$1 = state_28329;
var statearr_28333_28371 = state_28329__$1;
(statearr_28333_28371[(2)] = null);

(statearr_28333_28371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (4))){
var inst_28276 = (state_28329[(2)]);
var state_28329__$1 = state_28329;
var statearr_28334_28372 = state_28329__$1;
(statearr_28334_28372[(2)] = inst_28276);

(statearr_28334_28372[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (15))){
var state_28329__$1 = state_28329;
var statearr_28335_28373 = state_28329__$1;
(statearr_28335_28373[(2)] = fluree.db.flake.o);

(statearr_28335_28373[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (21))){
var inst_28312 = (state_28329[(7)]);
var inst_28308 = (state_28329[(8)]);
var inst_28318 = cljs.core.first.call(null,inst_28308);
var inst_28319 = inst_28312.call(null,inst_28318);
var state_28329__$1 = state_28329;
var statearr_28336_28374 = state_28329__$1;
(statearr_28336_28374[(2)] = inst_28319);

(statearr_28336_28374[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (13))){
var inst_28305 = (state_28329[(2)]);
var inst_28306 = fluree.db.util.async.throw_err.call(null,inst_28305);
var state_28329__$1 = state_28329;
var statearr_28337_28375 = state_28329__$1;
(statearr_28337_28375[(2)] = inst_28306);

(statearr_28337_28375[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (22))){
var inst_28321 = (state_28329[(2)]);
var state_28329__$1 = state_28329;
var statearr_28338_28376 = state_28329__$1;
(statearr_28338_28376[(2)] = inst_28321);

(statearr_28338_28376[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (6))){
var inst_28286 = clojure.string.replace.call(null,pred,"/_","/");
var state_28329__$1 = state_28329;
var statearr_28339_28377 = state_28329__$1;
(statearr_28339_28377[(2)] = inst_28286);

(statearr_28339_28377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (17))){
var inst_28290 = (state_28329[(9)]);
var state_28329__$1 = state_28329;
if(cljs.core.truth_(inst_28290)){
var statearr_28340_28378 = state_28329__$1;
(statearr_28340_28378[(1)] = (20));

} else {
var statearr_28341_28379 = state_28329__$1;
(statearr_28341_28379[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (3))){
var inst_28327 = (state_28329[(2)]);
var state_28329__$1 = state_28329;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28329__$1,inst_28327);
} else {
if((state_val_28330 === (12))){
var inst_28297 = (state_28329[(2)]);
var inst_28298 = fluree.db.util.async.throw_err.call(null,inst_28297);
var state_28329__$1 = state_28329;
var statearr_28342_28380 = state_28329__$1;
(statearr_28342_28380[(2)] = inst_28298);

(statearr_28342_28380[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (2))){
var inst_28284 = (state_28329[(10)]);
var _ = (function (){var statearr_28343 = state_28329;
(statearr_28343[(4)] = cljs.core.cons.call(null,(5),(state_28329[(4)])));

return statearr_28343;
})();
var inst_28282 = typeof pred === 'string';
var inst_28283 = cljs.core.re_matches.call(null,/.+\/_.+/,pred);
var inst_28284__$1 = fluree.db.dbfunctions.internal.and.call(null,inst_28282,inst_28283);
var state_28329__$1 = (function (){var statearr_28344 = state_28329;
(statearr_28344[(10)] = inst_28284__$1);

return statearr_28344;
})();
if(cljs.core.truth_(inst_28284__$1)){
var statearr_28345_28381 = state_28329__$1;
(statearr_28345_28381[(1)] = (6));

} else {
var statearr_28346_28382 = state_28329__$1;
(statearr_28346_28382[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (19))){
var inst_28324 = (state_28329[(2)]);
var _ = (function (){var statearr_28347 = state_28329;
(statearr_28347[(4)] = cljs.core.rest.call(null,(state_28329[(4)])));

return statearr_28347;
})();
var state_28329__$1 = state_28329;
var statearr_28348_28383 = state_28329__$1;
(statearr_28348_28383[(2)] = inst_28324);

(statearr_28348_28383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (11))){
var inst_28284 = (state_28329[(10)]);
var inst_28308 = (state_28329[(2)]);
var state_28329__$1 = (function (){var statearr_28350 = state_28329;
(statearr_28350[(8)] = inst_28308);

return statearr_28350;
})();
if(cljs.core.truth_(inst_28284)){
var statearr_28351_28384 = state_28329__$1;
(statearr_28351_28384[(1)] = (14));

} else {
var statearr_28352_28385 = state_28329__$1;
(statearr_28352_28385[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (9))){
var inst_28289 = (state_28329[(11)]);
var inst_28292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28293 = [sid,inst_28289];
var inst_28294 = (new cljs.core.PersistentVector(null,2,(5),inst_28292,inst_28293,null));
var inst_28295 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_28294);
var state_28329__$1 = state_28329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28329__$1,(12),inst_28295);
} else {
if((state_val_28330 === (5))){
var _ = (function (){var statearr_28353 = state_28329;
(statearr_28353[(4)] = cljs.core.rest.call(null,(state_28329[(4)])));

return statearr_28353;
})();
var state_28329__$1 = state_28329;
var ex28349 = (state_28329__$1[(2)]);
var statearr_28354_28386 = state_28329__$1;
(statearr_28354_28386[(5)] = ex28349);


if((ex28349 instanceof Error)){
var statearr_28355_28387 = state_28329__$1;
(statearr_28355_28387[(1)] = (4));

(statearr_28355_28387[(5)] = null);

} else {
throw ex28349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (14))){
var state_28329__$1 = state_28329;
var statearr_28356_28388 = state_28329__$1;
(statearr_28356_28388[(2)] = fluree.db.flake.s);

(statearr_28356_28388[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (16))){
var inst_28308 = (state_28329[(8)]);
var inst_28312 = (state_28329[(2)]);
var inst_28313 = cljs.core.seq.call(null,inst_28308);
var state_28329__$1 = (function (){var statearr_28357 = state_28329;
(statearr_28357[(7)] = inst_28312);

return statearr_28357;
})();
if(inst_28313){
var statearr_28358_28389 = state_28329__$1;
(statearr_28358_28389[(1)] = (17));

} else {
var statearr_28359_28390 = state_28329__$1;
(statearr_28359_28390[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (10))){
var inst_28289 = (state_28329[(11)]);
var inst_28300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28301 = [sid,inst_28289];
var inst_28302 = (new cljs.core.PersistentVector(null,2,(5),inst_28300,inst_28301,null));
var inst_28303 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_28302);
var state_28329__$1 = state_28329;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28329__$1,(13),inst_28303);
} else {
if((state_val_28330 === (18))){
var state_28329__$1 = state_28329;
var statearr_28360_28391 = state_28329__$1;
(statearr_28360_28391[(2)] = null);

(statearr_28360_28391[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28330 === (8))){
var inst_28289 = (state_28329[(11)]);
var inst_28284 = (state_28329[(10)]);
var inst_28289__$1 = (state_28329[(2)]);
var inst_28290 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_28289__$1);
var state_28329__$1 = (function (){var statearr_28361 = state_28329;
(statearr_28361[(11)] = inst_28289__$1);

(statearr_28361[(9)] = inst_28290);

return statearr_28361;
})();
if(cljs.core.truth_(inst_28284)){
var statearr_28362_28392 = state_28329__$1;
(statearr_28362_28392[(1)] = (9));

} else {
var statearr_28363_28393 = state_28329__$1;
(statearr_28363_28393[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0 = (function (){
var statearr_28364 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28364[(0)] = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__);

(statearr_28364[(1)] = (1));

return statearr_28364;
});
var fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1 = (function (state_28329){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28329);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28365){var ex__2749__auto__ = e28365;
var statearr_28366_28394 = state_28329;
(statearr_28366_28394[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28329[(4)]))){
var statearr_28367_28395 = state_28329;
(statearr_28367_28395[(1)] = cljs.core.first.call(null,(state_28329[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28396 = state_28329;
state_28329 = G__28396;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__ = function(state_28329){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1.call(this,state_28329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$get_subj_pred_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28368 = f__2769__auto__.call(null);
(statearr_28368[(6)] = c__2768__auto__);

return statearr_28368;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis.call(null);
}catch (e28397){var e = e28397;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28400 = arguments.length;
var i__5770__auto___28401 = (0);
while(true){
if((i__5770__auto___28401 < len__5769__auto___28400)){
args__5775__auto__.push((arguments[i__5770__auto___28401]));

var G__28402 = (i__5770__auto___28401 + (1));
i__5770__auto___28401 = G__28402;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._PLUS_,args);
}catch (e28399){var e = e28399;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"+",args);
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28398){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28398));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28405 = arguments.length;
var i__5770__auto___28406 = (0);
while(true){
if((i__5770__auto___28406 < len__5769__auto___28405)){
args__5775__auto__.push((arguments[i__5770__auto___28406]));

var G__28407 = (i__5770__auto___28406 + (1));
i__5770__auto___28406 = G__28407;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._,args);
}catch (e28404){var e = e28404;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"-",args);
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28403){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28403));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28410 = arguments.length;
var i__5770__auto___28411 = (0);
while(true){
if((i__5770__auto___28411 < len__5769__auto___28410)){
args__5775__auto__.push((arguments[i__5770__auto___28411]));

var G__28412 = (i__5770__auto___28411 + (1));
i__5770__auto___28411 = G__28412;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__5045__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_.call(null,args);
}
})())){
return (1);
} else {
return cljs.core.apply.call(null,cljs.core._STAR_,args);
}
}catch (e28409){var e = e28409;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"*",args);
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28408){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28408));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28415 = arguments.length;
var i__5770__auto___28416 = (0);
while(true){
if((i__5770__auto___28416 < len__5769__auto___28415)){
args__5775__auto__.push((arguments[i__5770__auto___28416]));

var G__28417 = (i__5770__auto___28416 + (1));
i__5770__auto___28416 = G__28417;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_.call(null,args))){
throw cljs.core.ex_info.call(null,"Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.call(null,cljs.core._SLASH_,args);
}
}catch (e28414){var e = e28414;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"/",args);
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28413){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28413));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot.call(null,n,d);
}catch (e28418){var e = e28418;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"quot",n,d);
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod.call(null,n,d);
}catch (e28419){var e = e28419;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"mod",n,d);
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem.call(null,n,d);
}catch (e28420){var e = e28420;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rem",n,d);
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28421){var e = e28421;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"ceil",num);
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28422){var e = e28422;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"floor",num);
}});
/**
 * Follows a result set down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28428 = path;
var vec__28429 = G__28428;
var seq__28430 = cljs.core.seq.call(null,vec__28429);
var first__28431 = cljs.core.first.call(null,seq__28430);
var seq__28430__$1 = cljs.core.next.call(null,seq__28430);
var pred = first__28431;
var r = seq__28430__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28428__$1 = G__28428;
var subjects__$1 = subjects;
while(true){
var vec__28435 = G__28428__$1;
var seq__28436 = cljs.core.seq.call(null,vec__28435);
var first__28437 = cljs.core.first.call(null,seq__28436);
var seq__28436__$1 = cljs.core.next.call(null,seq__28436);
var pred__$1 = first__28437;
var r__$1 = seq__28436__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.call(null,((function (G__28428__$1,subjects__$1,vec__28435,seq__28436,first__28437,seq__28436__$1,pred__$1,r__$1,subjects__$2,G__28428,vec__28429,seq__28430,first__28431,seq__28430__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_.call(null,subject))?cljs.core.mapv.call(null,((function (G__28428__$1,subjects__$1,vec__28435,seq__28436,first__28437,seq__28436__$1,pred__$1,r__$1,subjects__$2,G__28428,vec__28429,seq__28430,first__28431,seq__28430__$1,pred,r,subjects){
return (function (p1__28423_SHARP_){
return fluree.db.dbfunctions.internal.get.call(null,p1__28423_SHARP_,pred__$1);
});})(G__28428__$1,subjects__$1,vec__28435,seq__28436,first__28437,seq__28436__$1,pred__$1,r__$1,subjects__$2,G__28428,vec__28429,seq__28430,first__28431,seq__28430__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get.call(null,subject,pred__$1));
if(((cljs.core.vector_QMARK_.call(null,sub_subjects)) || (cljs.core.set_QMARK_.call(null,sub_subjects)))){
return cljs.core.into.call(null,acc,sub_subjects);
} else {
return cljs.core.conj.call(null,acc,sub_subjects);
}
});})(G__28428__$1,subjects__$1,vec__28435,seq__28436,first__28437,seq__28436__$1,pred__$1,r__$1,subjects__$2,G__28428,vec__28429,seq__28430,first__28431,seq__28430__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__5043__auto__ = r__$1;
if(and__5043__auto__){
return cljs.core.not_empty.call(null,next_subjects);
} else {
return and__5043__auto__;
}
})())){
var G__28438 = r__$1;
var G__28439 = next_subjects;
G__28428__$1 = G__28438;
subjects__$1 = G__28439;
continue;
} else {
return cljs.core.set.call(null,cljs.core.remove.call(null,fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28424){var e = e28424;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-all",start_subject,path);
}});
/**
 * Takes a path in a vector format and returns a select statement to crawl those vars.
 *   e.g. convert: ['_user/_auth', 'groupMembership/_user', 'group/_admins']
 *          to: {'_user/_auth' [{'groupMembership/_user' ['group/_admins']}]}
 */
fluree.db.dbfunctions.internal.select_from_path = (function fluree$db$dbfunctions$internal$select_from_path(path){
if(cljs.core._EQ_.call(null,(1),fluree.db.dbfunctions.internal.count.call(null,path))){
return path;
} else {
var r_path = cljs.core.reverse.call(null,path);
return cljs.core.reduce.call(null,(function (acc,p){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc], null)]);
}),cljs.core.first.call(null,r_path),cljs.core.rest.call(null,r_path));
}
});
/**
 * Follows a subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.follow_subject = (function fluree$db$dbfunctions$internal$follow_subject(_QMARK_ctx,sid,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28479){
var state_val_28480 = (state_28479[(1)]);
if((state_val_28480 === (7))){
var state_28479__$1 = state_28479;
var statearr_28481_28500 = state_28479__$1;
(statearr_28481_28500[(2)] = path);

(statearr_28481_28500[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28480 === (1))){
var state_28479__$1 = state_28479;
var statearr_28482_28501 = state_28479__$1;
(statearr_28482_28501[(2)] = null);

(statearr_28482_28501[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28480 === (4))){
var inst_28440 = (state_28479[(2)]);
var inst_28441 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28440,"get-all",sid,path);
var state_28479__$1 = state_28479;
var statearr_28483_28502 = state_28479__$1;
(statearr_28483_28502[(2)] = inst_28441);

(statearr_28483_28502[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28480 === (6))){
var inst_28458 = (state_28479[(2)]);
var inst_28459 = fluree.db.util.async.throw_err.call(null,inst_28458);
var inst_28460 = cljs.core.nth.call(null,inst_28459,(0),null);
var inst_28461 = cljs.core.nth.call(null,inst_28459,(1),null);
var inst_28462 = cljs.core.last.call(null,path);
var inst_28463 = cljs.core._EQ_.call(null,"_id",inst_28462);
var state_28479__$1 = (function (){var statearr_28484 = state_28479;
(statearr_28484[(7)] = inst_28460);

(statearr_28484[(8)] = inst_28461);

return statearr_28484;
})();
if(inst_28463){
var statearr_28485_28503 = state_28479__$1;
(statearr_28485_28503[(1)] = (7));

} else {
var statearr_28486_28504 = state_28479__$1;
(statearr_28486_28504[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28480 === (3))){
var inst_28477 = (state_28479[(2)]);
var state_28479__$1 = state_28479;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28479__$1,inst_28477);
} else {
if((state_val_28480 === (2))){
var _ = (function (){var statearr_28488 = state_28479;
(statearr_28488[(4)] = cljs.core.cons.call(null,(5),(state_28479[(4)])));

return statearr_28488;
})();
var inst_28450 = fluree.db.dbfunctions.internal.select_from_path.call(null,path);
var inst_28451 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28452 = cljs.core.PersistentHashMap.EMPTY;
var inst_28453 = [inst_28450,sid,inst_28452];
var inst_28454 = cljs.core.PersistentHashMap.fromArrays(inst_28451,inst_28453);
var inst_28455 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28456 = fluree.db.dbfunctions.internal.query.call(null,inst_28455,inst_28454);
var state_28479__$1 = state_28479;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28479__$1,(6),inst_28456);
} else {
if((state_val_28480 === (9))){
var inst_28460 = (state_28479[(7)]);
var inst_28461 = (state_28479[(8)]);
var inst_28468 = (state_28479[(2)]);
var inst_28469 = fluree.db.dbfunctions.internal.get_all.call(null,inst_28460,inst_28468);
var inst_28470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28471 = fluree.db.dbfunctions.internal.count.call(null,path);
var inst_28472 = fluree.db.dbfunctions.internal._PLUS_.call(null,inst_28461,inst_28471,(9));
var inst_28473 = [inst_28469,inst_28472];
var inst_28474 = (new cljs.core.PersistentVector(null,2,(5),inst_28470,inst_28473,null));
var _ = (function (){var statearr_28489 = state_28479;
(statearr_28489[(4)] = cljs.core.rest.call(null,(state_28479[(4)])));

return statearr_28489;
})();
var state_28479__$1 = state_28479;
var statearr_28490_28505 = state_28479__$1;
(statearr_28490_28505[(2)] = inst_28474);

(statearr_28490_28505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28480 === (5))){
var _ = (function (){var statearr_28491 = state_28479;
(statearr_28491[(4)] = cljs.core.rest.call(null,(state_28479[(4)])));

return statearr_28491;
})();
var state_28479__$1 = state_28479;
var ex28487 = (state_28479__$1[(2)]);
var statearr_28492_28506 = state_28479__$1;
(statearr_28492_28506[(5)] = ex28487);


var statearr_28493_28507 = state_28479__$1;
(statearr_28493_28507[(1)] = (4));

(statearr_28493_28507[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28480 === (8))){
var inst_28466 = cljs.core.conj.call(null,path,"_id");
var state_28479__$1 = state_28479;
var statearr_28494_28508 = state_28479__$1;
(statearr_28494_28508[(2)] = inst_28466);

(statearr_28494_28508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0 = (function (){
var statearr_28495 = [null,null,null,null,null,null,null,null,null];
(statearr_28495[(0)] = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__);

(statearr_28495[(1)] = (1));

return statearr_28495;
});
var fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1 = (function (state_28479){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28479);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28496){var ex__2749__auto__ = e28496;
var statearr_28497_28509 = state_28479;
(statearr_28497_28509[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28479[(4)]))){
var statearr_28498_28510 = state_28479;
(statearr_28498_28510[(1)] = cljs.core.first.call(null,(state_28479[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28511 = state_28479;
state_28479 = G__28511;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__ = function(state_28479){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1.call(this,state_28479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$follow_subject_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28499 = f__2769__auto__.call(null);
(statearr_28499[(6)] = c__2768__auto__);

return statearr_28499;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all.call(null,m,ks);
}catch (e28512){var e = e28512;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"get-in",m,ks);
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{if(cljs.core.sequential_QMARK_.call(null,key)){
return cljs.core.some.call(null,(function (p1__28513_SHARP_){
return fluree.db.dbfunctions.internal.contains_QMARK_.call(null,coll,p1__28513_SHARP_);
}),key);
} else {
return cljs.core.contains_QMARK_.call(null,coll,key);
}
}catch (e28514){var e = e28514;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"contains?",coll,key);
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28517 = arguments.length;
var i__5770__auto___28518 = (0);
while(true){
if((i__5770__auto___28518 < len__5769__auto___28517)){
args__5775__auto__.push((arguments[i__5770__auto___28518]));

var G__28519 = (i__5770__auto___28518 + (1));
i__5770__auto___28518 = G__28519;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core.hash_set,args);
}catch (e28516){var e = e28516;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"hash-set",args);
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28515){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28515));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_.call(null,coll))?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.call(null,coll_SINGLEQUOTE_,key);
}catch (e28520){var e = e28520;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"nth",coll,key);
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___28523 = arguments.length;
var i__5770__auto___28524 = (0);
while(true){
if((i__5770__auto___28524 < len__5769__auto___28523)){
args__5775__auto__.push((arguments[i__5770__auto___28524]));

var G__28525 = (i__5770__auto___28524 + (1));
i__5770__auto___28524 = G__28525;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.call(null,cljs.core._EQ_,args);
}catch (e28522){var e = e28522;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"==",args);
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq28521){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq28521));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,pattern),string);
}catch (e28526){var e = e28526;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"re-find",pattern,string);
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28583){
var state_val_28584 = (state_28583[(1)]);
if((state_val_28584 === (7))){
var inst_28529 = (state_28583[(2)]);
var state_28583__$1 = state_28583;
var statearr_28585_28619 = state_28583__$1;
(statearr_28585_28619[(2)] = inst_28529);

(statearr_28585_28619[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (1))){
var state_28583__$1 = state_28583;
var statearr_28586_28620 = state_28583__$1;
(statearr_28586_28620[(2)] = null);

(statearr_28586_28620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (4))){
var inst_28528 = (state_28583[(2)]);
var state_28583__$1 = (function (){var statearr_28587 = state_28583;
(statearr_28587[(7)] = inst_28528);

return statearr_28587;
})();
var statearr_28588_28621 = state_28583__$1;
(statearr_28588_28621[(2)] = null);

(statearr_28588_28621[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (15))){
var inst_28563 = (state_28583[(8)]);
var inst_28554 = (state_28583[(9)]);
var inst_28564 = (state_28583[(10)]);
var inst_28566 = (state_28583[(11)]);
var inst_28551 = (state_28583[(12)]);
var inst_28553 = (state_28583[(13)]);
var inst_28570 = (function (){var db = inst_28551;
var prevT = inst_28553;
var db_SINGLEQUOTE_ = inst_28554;
var prev_vals = inst_28563;
var fuel = inst_28564;
var G__28565 = inst_28566;
return (function (p1__28527_SHARP_){
var f = p1__28527_SHARP_;
return fluree.db.flake.o.call(null,f);
});
})();
var inst_28571 = inst_28570.call(null,inst_28566);
var state_28583__$1 = state_28583;
var statearr_28589_28622 = state_28583__$1;
(statearr_28589_28622[(2)] = inst_28571);

(statearr_28589_28622[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (13))){
var inst_28563 = (state_28583[(8)]);
var inst_28566 = (state_28583[(11)]);
var inst_28562 = (state_28583[(2)]);
var inst_28563__$1 = fluree.db.util.async.throw_err.call(null,inst_28562);
var inst_28564 = fluree.db.dbfunctions.internal.count.call(null,inst_28563__$1);
var inst_28566__$1 = cljs.core.first.call(null,inst_28563__$1);
var inst_28567 = (inst_28566__$1 == null);
var state_28583__$1 = (function (){var statearr_28590 = state_28583;
(statearr_28590[(8)] = inst_28563__$1);

(statearr_28590[(10)] = inst_28564);

(statearr_28590[(11)] = inst_28566__$1);

return statearr_28590;
})();
if(cljs.core.truth_(inst_28567)){
var statearr_28591_28623 = state_28583__$1;
(statearr_28591_28623[(1)] = (14));

} else {
var statearr_28592_28624 = state_28583__$1;
(statearr_28592_28624[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (6))){
var inst_28538 = (state_28583[(2)]);
var state_28583__$1 = state_28583;
var statearr_28593_28625 = state_28583__$1;
(statearr_28593_28625[(2)] = inst_28538);

(statearr_28593_28625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (3))){
var inst_28581 = (state_28583[(2)]);
var state_28583__$1 = state_28583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28583__$1,inst_28581);
} else {
if((state_val_28584 === (12))){
var inst_28578 = (state_28583[(2)]);
var _ = (function (){var statearr_28594 = state_28583;
(statearr_28594[(4)] = cljs.core.rest.call(null,(state_28583[(4)])));

return statearr_28594;
})();
var state_28583__$1 = state_28583;
var statearr_28595_28626 = state_28583__$1;
(statearr_28595_28626[(2)] = inst_28578);

(statearr_28595_28626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (2))){
var _ = (function (){var statearr_28597 = state_28583;
(statearr_28597[(4)] = cljs.core.cons.call(null,(9),(state_28583[(4)])));

return statearr_28597;
})();
var inst_28544 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28545 = typeof inst_28544 === 'string';
var state_28583__$1 = state_28583;
if(cljs.core.truth_(inst_28545)){
var statearr_28598_28627 = state_28583__$1;
(statearr_28598_28627[(1)] = (10));

} else {
var statearr_28599_28628 = state_28583__$1;
(statearr_28599_28628[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (11))){
var inst_28554 = (state_28583[(9)]);
var inst_28551 = (state_28583[(12)]);
var inst_28553 = (state_28583[(13)]);
var inst_28551__$1 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28552 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_28551__$1);
var inst_28553__$1 = fluree.db.dbfunctions.internal.inc.call(null,inst_28552);
var inst_28554__$1 = cljs.core.assoc.call(null,inst_28551__$1,new cljs.core.Keyword(null,"t","t",-1397832519),inst_28553__$1);
var inst_28555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28556 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28557 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28558 = [inst_28556,inst_28557];
var inst_28559 = (new cljs.core.PersistentVector(null,2,(5),inst_28555,inst_28558,null));
var inst_28560 = fluree.db.dbproto._search.call(null,inst_28554__$1,inst_28559);
var state_28583__$1 = (function (){var statearr_28600 = state_28583;
(statearr_28600[(9)] = inst_28554__$1);

(statearr_28600[(12)] = inst_28551__$1);

(statearr_28600[(13)] = inst_28553__$1);

return statearr_28600;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28583__$1,(13),inst_28560);
} else {
if((state_val_28584 === (9))){
var _ = (function (){var statearr_28601 = state_28583;
(statearr_28601[(4)] = cljs.core.rest.call(null,(state_28583[(4)])));

return statearr_28601;
})();
var state_28583__$1 = state_28583;
var ex28596 = (state_28583__$1[(2)]);
var statearr_28602_28629 = state_28583__$1;
(statearr_28602_28629[(5)] = ex28596);


var statearr_28603_28630 = state_28583__$1;
(statearr_28603_28630[(1)] = (4));

(statearr_28603_28630[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (5))){
var inst_28528 = (state_28583[(7)]);
var _ = (function (){var statearr_28604 = state_28583;
(statearr_28604[(4)] = cljs.core.cons.call(null,(8),(state_28583[(4)])));

return statearr_28604;
})();
var inst_28535 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28528,"?pO","Context Object");
var ___$1 = (function (){var statearr_28605 = state_28583;
(statearr_28605[(4)] = cljs.core.rest.call(null,(state_28583[(4)])));

return statearr_28605;
})();
var state_28583__$1 = state_28583;
var statearr_28606_28631 = state_28583__$1;
(statearr_28606_28631[(2)] = inst_28535);

(statearr_28606_28631[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (14))){
var state_28583__$1 = state_28583;
var statearr_28607_28632 = state_28583__$1;
(statearr_28607_28632[(2)] = null);

(statearr_28607_28632[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (16))){
var inst_28564 = (state_28583[(10)]);
var inst_28573 = (state_28583[(2)]);
var inst_28574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28575 = [inst_28573,inst_28564];
var inst_28576 = (new cljs.core.PersistentVector(null,2,(5),inst_28574,inst_28575,null));
var state_28583__$1 = state_28583;
var statearr_28609_28633 = state_28583__$1;
(statearr_28609_28633[(2)] = inst_28576);

(statearr_28609_28633[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (10))){
var inst_28547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28548 = [null,(0)];
var inst_28549 = (new cljs.core.PersistentVector(null,2,(5),inst_28547,inst_28548,null));
var state_28583__$1 = state_28583;
var statearr_28610_28634 = state_28583__$1;
(statearr_28610_28634[(2)] = inst_28549);

(statearr_28610_28634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28584 === (8))){
var _ = (function (){var statearr_28611 = state_28583;
(statearr_28611[(4)] = cljs.core.rest.call(null,(state_28583[(4)])));

return statearr_28611;
})();
var state_28583__$1 = state_28583;
var ex28608 = (state_28583__$1[(2)]);
var statearr_28612_28635 = state_28583__$1;
(statearr_28612_28635[(5)] = ex28608);


var statearr_28613_28636 = state_28583__$1;
(statearr_28613_28636[(1)] = (7));

(statearr_28613_28636[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_28614 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28614[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_28614[(1)] = (1));

return statearr_28614;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_28583){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28615){var ex__2749__auto__ = e28615;
var statearr_28616_28637 = state_28583;
(statearr_28616_28637[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28583[(4)]))){
var statearr_28617_28638 = state_28583;
(statearr_28617_28638[(1)] = cljs.core.first.call(null,(state_28583[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28639 = state_28583;
state_28583 = G__28639;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__ = function(state_28583){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_28583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28618 = f__2769__auto__.call(null);
(statearr_28618[(6)] = c__2768__auto__);

return statearr_28618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28691){
var state_val_28692 = (state_28691[(1)]);
if((state_val_28692 === (7))){
var inst_28641 = (state_28691[(2)]);
var state_28691__$1 = state_28691;
var statearr_28693_28722 = state_28691__$1;
(statearr_28693_28722[(2)] = inst_28641);

(statearr_28693_28722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (1))){
var state_28691__$1 = state_28691;
var statearr_28694_28723 = state_28691__$1;
(statearr_28694_28723[(2)] = null);

(statearr_28694_28723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (4))){
var inst_28640 = (state_28691[(2)]);
var state_28691__$1 = (function (){var statearr_28695 = state_28691;
(statearr_28695[(7)] = inst_28640);

return statearr_28695;
})();
var statearr_28696_28724 = state_28691__$1;
(statearr_28696_28724[(2)] = null);

(statearr_28696_28724[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (13))){
var inst_28686 = (state_28691[(2)]);
var _ = (function (){var statearr_28697 = state_28691;
(statearr_28697[(4)] = cljs.core.rest.call(null,(state_28691[(4)])));

return statearr_28697;
})();
var state_28691__$1 = state_28691;
var statearr_28698_28725 = state_28691__$1;
(statearr_28698_28725[(2)] = inst_28686);

(statearr_28698_28725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (6))){
var inst_28650 = (state_28691[(2)]);
var state_28691__$1 = state_28691;
var statearr_28699_28726 = state_28691__$1;
(statearr_28699_28726[(2)] = inst_28650);

(statearr_28699_28726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (3))){
var inst_28689 = (state_28691[(2)]);
var state_28691__$1 = state_28691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28691__$1,inst_28689);
} else {
if((state_val_28692 === (12))){
var inst_28673 = (state_28691[(8)]);
var inst_28682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28683 = [null,inst_28673];
var inst_28684 = (new cljs.core.PersistentVector(null,2,(5),inst_28682,inst_28683,null));
var state_28691__$1 = state_28691;
var statearr_28700_28727 = state_28691__$1;
(statearr_28700_28727[(2)] = inst_28684);

(statearr_28700_28727[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (2))){
var _ = (function (){var statearr_28702 = state_28691;
(statearr_28702[(4)] = cljs.core.cons.call(null,(9),(state_28691[(4)])));

return statearr_28702;
})();
var inst_28659 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28662 = [null,pred_name,"?o"];
var inst_28663 = (new cljs.core.PersistentVector(null,3,(5),inst_28661,inst_28662,null));
var inst_28664 = [inst_28663];
var inst_28665 = (new cljs.core.PersistentVector(null,1,(5),inst_28660,inst_28664,null));
var inst_28666 = ["?o",inst_28665,opts];
var inst_28667 = cljs.core.PersistentHashMap.fromArrays(inst_28659,inst_28666);
var inst_28668 = fluree.db.dbfunctions.internal.query.call(null,db,inst_28667);
var state_28691__$1 = state_28691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28691__$1,(10),inst_28668);
} else {
if((state_val_28692 === (11))){
var inst_28673 = (state_28691[(8)]);
var inst_28672 = (state_28691[(9)]);
var inst_28677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28678 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_28672);
var inst_28679 = [inst_28678,inst_28673];
var inst_28680 = (new cljs.core.PersistentVector(null,2,(5),inst_28677,inst_28679,null));
var state_28691__$1 = state_28691;
var statearr_28703_28728 = state_28691__$1;
(statearr_28703_28728[(2)] = inst_28680);

(statearr_28703_28728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (9))){
var _ = (function (){var statearr_28704 = state_28691;
(statearr_28704[(4)] = cljs.core.rest.call(null,(state_28691[(4)])));

return statearr_28704;
})();
var state_28691__$1 = state_28691;
var ex28701 = (state_28691__$1[(2)]);
var statearr_28705_28729 = state_28691__$1;
(statearr_28705_28729[(5)] = ex28701);


var statearr_28706_28730 = state_28691__$1;
(statearr_28706_28730[(1)] = (4));

(statearr_28706_28730[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (5))){
var inst_28640 = (state_28691[(7)]);
var _ = (function (){var statearr_28708 = state_28691;
(statearr_28708[(4)] = cljs.core.cons.call(null,(8),(state_28691[(4)])));

return statearr_28708;
})();
var inst_28647 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28640,"max-pred-val",pred_name);
var ___$1 = (function (){var statearr_28709 = state_28691;
(statearr_28709[(4)] = cljs.core.rest.call(null,(state_28691[(4)])));

return statearr_28709;
})();
var state_28691__$1 = state_28691;
var statearr_28710_28731 = state_28691__$1;
(statearr_28710_28731[(2)] = inst_28647);

(statearr_28710_28731[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (10))){
var inst_28672 = (state_28691[(9)]);
var inst_28670 = (state_28691[(2)]);
var inst_28671 = fluree.db.util.async.throw_err.call(null,inst_28670);
var inst_28672__$1 = cljs.core.nth.call(null,inst_28671,(0),null);
var inst_28673 = cljs.core.nth.call(null,inst_28671,(1),null);
var inst_28674 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_28672__$1);
var inst_28675 = cljs.core.not.call(null,inst_28674);
var state_28691__$1 = (function (){var statearr_28711 = state_28691;
(statearr_28711[(8)] = inst_28673);

(statearr_28711[(9)] = inst_28672__$1);

return statearr_28711;
})();
if(inst_28675){
var statearr_28712_28732 = state_28691__$1;
(statearr_28712_28732[(1)] = (11));

} else {
var statearr_28713_28733 = state_28691__$1;
(statearr_28713_28733[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28692 === (8))){
var _ = (function (){var statearr_28714 = state_28691;
(statearr_28714[(4)] = cljs.core.rest.call(null,(state_28691[(4)])));

return statearr_28714;
})();
var state_28691__$1 = state_28691;
var ex28707 = (state_28691__$1[(2)]);
var statearr_28715_28734 = state_28691__$1;
(statearr_28715_28734[(5)] = ex28707);


var statearr_28716_28735 = state_28691__$1;
(statearr_28716_28735[(1)] = (7));

(statearr_28716_28735[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_28717 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28717[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__);

(statearr_28717[(1)] = (1));

return statearr_28717;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1 = (function (state_28691){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28718){var ex__2749__auto__ = e28718;
var statearr_28719_28736 = state_28691;
(statearr_28719_28736[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28691[(4)]))){
var statearr_28720_28737 = state_28691;
(statearr_28720_28737[(1)] = cljs.core.first.call(null,(state_28691[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28738 = state_28691;
state_28691 = G__28738;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__ = function(state_28691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1.call(this,state_28691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28721 = f__2769__auto__.call(null);
(statearr_28721[(6)] = c__2768__auto__);

return statearr_28721;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$.call(null,(function (){var and__5043__auto__ = typeof email === 'string';
if(and__5043__auto__){
return cljs.core.re_matches.call(null,pattern,email);
} else {
return and__5043__auto__;
}
})());
}catch (e28739){var e = e28739;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"valid-email?",email);
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__28741 = arguments.length;
switch (G__28741) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28811){
var state_val_28812 = (state_28811[(1)]);
if((state_val_28812 === (7))){
var inst_28743 = (state_28811[(2)]);
var state_28811__$1 = state_28811;
var statearr_28813_28857 = state_28811__$1;
(statearr_28813_28857[(2)] = inst_28743);

(statearr_28813_28857[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (20))){
var inst_28787 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28788 = ["*"];
var inst_28789 = (new cljs.core.PersistentVector(null,1,(5),inst_28787,inst_28788,null));
var state_28811__$1 = state_28811;
var statearr_28814_28858 = state_28811__$1;
(statearr_28814_28858[(2)] = inst_28789);

(statearr_28814_28858[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (1))){
var state_28811__$1 = state_28811;
var statearr_28815_28859 = state_28811__$1;
(statearr_28815_28859[(2)] = null);

(statearr_28815_28859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (4))){
var inst_28742 = (state_28811[(2)]);
var state_28811__$1 = (function (){var statearr_28816 = state_28811;
(statearr_28816[(7)] = inst_28742);

return statearr_28816;
})();
var statearr_28817_28860 = state_28811__$1;
(statearr_28817_28860[(2)] = null);

(statearr_28817_28860[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (15))){
var inst_28806 = (state_28811[(2)]);
var _ = (function (){var statearr_28818 = state_28811;
(statearr_28818[(4)] = cljs.core.rest.call(null,(state_28811[(4)])));

return statearr_28818;
})();
var state_28811__$1 = state_28811;
var statearr_28819_28861 = state_28811__$1;
(statearr_28819_28861[(2)] = inst_28806);

(statearr_28819_28861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (21))){
var inst_28770 = (state_28811[(8)]);
var inst_28777 = (state_28811[(9)]);
var inst_28791 = (state_28811[(2)]);
var inst_28792 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28793 = cljs.core.PersistentHashMap.EMPTY;
var inst_28794 = [inst_28791,inst_28777,inst_28793];
var inst_28795 = cljs.core.PersistentHashMap.fromArrays(inst_28792,inst_28794);
var inst_28796 = fluree.db.dbfunctions.internal.query.call(null,inst_28770,inst_28795);
var state_28811__$1 = state_28811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28811__$1,(22),inst_28796);
} else {
if((state_val_28812 === (13))){
var inst_28765 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28811__$1 = state_28811;
var statearr_28820_28862 = state_28811__$1;
(statearr_28820_28862[(2)] = inst_28765);

(statearr_28820_28862[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (22))){
var inst_28798 = (state_28811[(2)]);
var inst_28799 = fluree.db.util.async.throw_err.call(null,inst_28798);
var inst_28800 = cljs.core.nth.call(null,inst_28799,(0),null);
var inst_28801 = cljs.core.nth.call(null,inst_28799,(1),null);
var inst_28802 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28803 = [inst_28800,inst_28801];
var inst_28804 = (new cljs.core.PersistentVector(null,2,(5),inst_28802,inst_28803,null));
var state_28811__$1 = state_28811;
var statearr_28821_28863 = state_28811__$1;
(statearr_28821_28863[(2)] = inst_28804);

(statearr_28821_28863[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (6))){
var inst_28752 = (state_28811[(2)]);
var state_28811__$1 = state_28811;
var statearr_28822_28864 = state_28811__$1;
(statearr_28822_28864[(2)] = inst_28752);

(statearr_28822_28864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (17))){
var inst_28774 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28775 = fluree.db.dbfunctions.internal.get.call(null,inst_28774,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_28811__$1 = state_28811;
var statearr_28823_28865 = state_28811__$1;
(statearr_28823_28865[(2)] = inst_28775);

(statearr_28823_28865[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (3))){
var inst_28809 = (state_28811[(2)]);
var state_28811__$1 = state_28811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28811__$1,inst_28809);
} else {
if((state_val_28812 === (12))){
var inst_28763 = (state_28811[(2)]);
var state_28811__$1 = state_28811;
if(cljs.core.truth_(inst_28763)){
var statearr_28824_28866 = state_28811__$1;
(statearr_28824_28866[(1)] = (13));

} else {
var statearr_28825_28867 = state_28811__$1;
(statearr_28825_28867[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (2))){
var inst_28758 = (state_28811[(10)]);
var _ = (function (){var statearr_28826 = state_28811;
(statearr_28826[(4)] = cljs.core.cons.call(null,(9),(state_28811[(4)])));

return statearr_28826;
})();
var inst_28758__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28811__$1 = (function (){var statearr_28827 = state_28811;
(statearr_28827[(10)] = inst_28758__$1);

return statearr_28827;
})();
if(cljs.core.truth_(inst_28758__$1)){
var statearr_28828_28868 = state_28811__$1;
(statearr_28828_28868[(1)] = (10));

} else {
var statearr_28829_28869 = state_28811__$1;
(statearr_28829_28869[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (19))){
var inst_28779 = cljs.core.PersistentVector.EMPTY;
var inst_28780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28781 = ["*"];
var inst_28782 = (new cljs.core.PersistentVector(null,1,(5),inst_28780,inst_28781,null));
var inst_28783 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28784 = cljs.core.concat.call(null,inst_28782,inst_28783);
var inst_28785 = cljs.core.into.call(null,inst_28779,inst_28784);
var state_28811__$1 = state_28811;
var statearr_28831_28870 = state_28811__$1;
(statearr_28831_28870[(2)] = inst_28785);

(statearr_28831_28870[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (11))){
var inst_28758 = (state_28811[(10)]);
var state_28811__$1 = state_28811;
var statearr_28832_28871 = state_28811__$1;
(statearr_28832_28871[(2)] = inst_28758);

(statearr_28832_28871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (9))){
var _ = (function (){var statearr_28833 = state_28811;
(statearr_28833[(4)] = cljs.core.rest.call(null,(state_28811[(4)])));

return statearr_28833;
})();
var state_28811__$1 = state_28811;
var ex28830 = (state_28811__$1[(2)]);
var statearr_28834_28872 = state_28811__$1;
(statearr_28834_28872[(5)] = ex28830);


var statearr_28835_28873 = state_28811__$1;
(statearr_28835_28873[(1)] = (4));

(statearr_28835_28873[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (5))){
var inst_28742 = (state_28811[(7)]);
var _ = (function (){var statearr_28836 = state_28811;
(statearr_28836[(4)] = cljs.core.cons.call(null,(8),(state_28811[(4)])));

return statearr_28836;
})();
var inst_28749 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28742,"?s","Context Object",additional_params);
var ___$1 = (function (){var statearr_28837 = state_28811;
(statearr_28837[(4)] = cljs.core.rest.call(null,(state_28811[(4)])));

return statearr_28837;
})();
var state_28811__$1 = state_28811;
var statearr_28838_28874 = state_28811__$1;
(statearr_28838_28874[(2)] = inst_28749);

(statearr_28838_28874[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (14))){
var inst_28771 = (state_28811[(11)]);
var inst_28770 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28771__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28811__$1 = (function (){var statearr_28839 = state_28811;
(statearr_28839[(8)] = inst_28770);

(statearr_28839[(11)] = inst_28771__$1);

return statearr_28839;
})();
if(cljs.core.truth_(inst_28771__$1)){
var statearr_28840_28875 = state_28811__$1;
(statearr_28840_28875[(1)] = (16));

} else {
var statearr_28841_28876 = state_28811__$1;
(statearr_28841_28876[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (16))){
var inst_28771 = (state_28811[(11)]);
var state_28811__$1 = state_28811;
var statearr_28842_28877 = state_28811__$1;
(statearr_28842_28877[(2)] = inst_28771);

(statearr_28842_28877[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (10))){
var inst_28760 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,additional_params);
var state_28811__$1 = state_28811;
var statearr_28844_28878 = state_28811__$1;
(statearr_28844_28878[(2)] = inst_28760);

(statearr_28844_28878[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (18))){
var inst_28777 = (state_28811[(2)]);
var state_28811__$1 = (function (){var statearr_28845 = state_28811;
(statearr_28845[(9)] = inst_28777);

return statearr_28845;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28846_28879 = state_28811__$1;
(statearr_28846_28879[(1)] = (19));

} else {
var statearr_28847_28880 = state_28811__$1;
(statearr_28847_28880[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28812 === (8))){
var _ = (function (){var statearr_28848 = state_28811;
(statearr_28848[(4)] = cljs.core.rest.call(null,(state_28811[(4)])));

return statearr_28848;
})();
var state_28811__$1 = state_28811;
var ex28843 = (state_28811__$1[(2)]);
var statearr_28849_28881 = state_28811__$1;
(statearr_28849_28881[(5)] = ex28843);


var statearr_28850_28882 = state_28811__$1;
(statearr_28850_28882[(1)] = (7));

(statearr_28850_28882[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28851 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28851[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28851[(1)] = (1));

return statearr_28851;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28811){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28852){var ex__2749__auto__ = e28852;
var statearr_28853_28883 = state_28811;
(statearr_28853_28883[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28811[(4)]))){
var statearr_28854_28884 = state_28811;
(statearr_28854_28884[(1)] = cljs.core.first.call(null,(state_28811[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28885 = state_28811;
state_28811 = G__28885;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28811){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28855 = f__2769__auto__.call(null);
(statearr_28855[(6)] = c__2768__auto__);

return statearr_28855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__28887 = arguments.length;
switch (G__28887) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_28931){
var state_val_28932 = (state_28931[(1)]);
if((state_val_28932 === (7))){
var inst_28909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28910 = ["*"];
var inst_28911 = (new cljs.core.PersistentVector(null,1,(5),inst_28909,inst_28910,null));
var state_28931__$1 = state_28931;
var statearr_28933_28953 = state_28931__$1;
(statearr_28933_28953[(2)] = inst_28911);

(statearr_28933_28953[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (1))){
var state_28931__$1 = state_28931;
var statearr_28934_28954 = state_28931__$1;
(statearr_28934_28954[(2)] = null);

(statearr_28934_28954[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (4))){
var inst_28888 = (state_28931[(2)]);
var inst_28889 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28888,"?p","Context Object",additional_params);
var state_28931__$1 = state_28931;
var statearr_28935_28955 = state_28931__$1;
(statearr_28935_28955[(2)] = inst_28889);

(statearr_28935_28955[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (6))){
var inst_28901 = cljs.core.PersistentVector.EMPTY;
var inst_28902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28903 = ["*"];
var inst_28904 = (new cljs.core.PersistentVector(null,1,(5),inst_28902,inst_28903,null));
var inst_28905 = fluree.db.dbfunctions.internal.parse_select_map.call(null,additional_params);
var inst_28906 = cljs.core.concat.call(null,inst_28904,inst_28905);
var inst_28907 = cljs.core.into.call(null,inst_28901,inst_28906);
var state_28931__$1 = state_28931;
var statearr_28936_28956 = state_28931__$1;
(statearr_28936_28956[(2)] = inst_28907);

(statearr_28936_28956[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (3))){
var inst_28929 = (state_28931[(2)]);
var state_28931__$1 = state_28931;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28931__$1,inst_28929);
} else {
if((state_val_28932 === (2))){
var _ = (function (){var statearr_28938 = state_28931;
(statearr_28938[(4)] = cljs.core.cons.call(null,(5),(state_28931[(4)])));

return statearr_28938;
})();
var inst_28898 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28899 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_28931__$1 = (function (){var statearr_28939 = state_28931;
(statearr_28939[(7)] = inst_28898);

(statearr_28939[(8)] = inst_28899);

return statearr_28939;
})();
if(cljs.core.truth_(additional_params)){
var statearr_28940_28957 = state_28931__$1;
(statearr_28940_28957[(1)] = (6));

} else {
var statearr_28941_28958 = state_28931__$1;
(statearr_28941_28958[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (9))){
var inst_28920 = (state_28931[(2)]);
var inst_28921 = fluree.db.util.async.throw_err.call(null,inst_28920);
var inst_28922 = cljs.core.nth.call(null,inst_28921,(0),null);
var inst_28923 = cljs.core.nth.call(null,inst_28921,(1),null);
var inst_28924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28925 = [inst_28922,inst_28923];
var inst_28926 = (new cljs.core.PersistentVector(null,2,(5),inst_28924,inst_28925,null));
var _ = (function (){var statearr_28942 = state_28931;
(statearr_28942[(4)] = cljs.core.rest.call(null,(state_28931[(4)])));

return statearr_28942;
})();
var state_28931__$1 = state_28931;
var statearr_28943_28959 = state_28931__$1;
(statearr_28943_28959[(2)] = inst_28926);

(statearr_28943_28959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (5))){
var _ = (function (){var statearr_28944 = state_28931;
(statearr_28944[(4)] = cljs.core.rest.call(null,(state_28931[(4)])));

return statearr_28944;
})();
var state_28931__$1 = state_28931;
var ex28937 = (state_28931__$1[(2)]);
var statearr_28945_28960 = state_28931__$1;
(statearr_28945_28960[(5)] = ex28937);


var statearr_28946_28961 = state_28931__$1;
(statearr_28946_28961[(1)] = (4));

(statearr_28946_28961[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28932 === (8))){
var inst_28898 = (state_28931[(7)]);
var inst_28899 = (state_28931[(8)]);
var inst_28913 = (state_28931[(2)]);
var inst_28914 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28915 = cljs.core.PersistentHashMap.EMPTY;
var inst_28916 = [inst_28913,inst_28899,inst_28915];
var inst_28917 = cljs.core.PersistentHashMap.fromArrays(inst_28914,inst_28916);
var inst_28918 = fluree.db.dbfunctions.internal.query.call(null,inst_28898,inst_28917);
var state_28931__$1 = state_28931;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28931__$1,(9),inst_28918);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2746__auto____0 = (function (){
var statearr_28947 = [null,null,null,null,null,null,null,null,null];
(statearr_28947[(0)] = fluree$db$dbfunctions$internal$state_machine__2746__auto__);

(statearr_28947[(1)] = (1));

return statearr_28947;
});
var fluree$db$dbfunctions$internal$state_machine__2746__auto____1 = (function (state_28931){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_28931);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e28948){var ex__2749__auto__ = e28948;
var statearr_28949_28962 = state_28931;
(statearr_28949_28962[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_28931[(4)]))){
var statearr_28950_28963 = state_28931;
(statearr_28950_28963[(1)] = cljs.core.first.call(null,(state_28931[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28964 = state_28931;
state_28931 = G__28964;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2746__auto__ = function(state_28931){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2746__auto____1.call(this,state_28931);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_28951 = f__2769__auto__.call(null);
(statearr_28951[(6)] = c__2768__auto__);

return statearr_28951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29008){
var state_val_29009 = (state_29008[(1)]);
if((state_val_29009 === (1))){
var state_29008__$1 = state_29008;
var statearr_29010_29024 = state_29008__$1;
(statearr_29010_29024[(2)] = null);

(statearr_29010_29024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29009 === (2))){
var _ = (function (){var statearr_29011 = state_29008;
(statearr_29011[(4)] = cljs.core.cons.call(null,(5),(state_29008[(4)])));

return statearr_29011;
})();
var inst_28975 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28977 = ["_user/_auth"];
var inst_28978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28979 = ["*"];
var inst_28980 = (new cljs.core.PersistentVector(null,1,(5),inst_28978,inst_28979,null));
var inst_28981 = [inst_28980];
var inst_28982 = cljs.core.PersistentHashMap.fromArrays(inst_28977,inst_28981);
var inst_28983 = [inst_28982];
var inst_28984 = (new cljs.core.PersistentVector(null,1,(5),inst_28976,inst_28983,null));
var inst_28985 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28986 = cljs.core.PersistentHashMap.EMPTY;
var inst_28987 = [inst_28984,inst_28985,inst_28986];
var inst_28988 = cljs.core.PersistentHashMap.fromArrays(inst_28975,inst_28987);
var inst_28989 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_28990 = fluree.db.dbfunctions.internal.query.call(null,inst_28989,inst_28988);
var state_29008__$1 = state_29008;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29008__$1,(6),inst_28990);
} else {
if((state_val_29009 === (3))){
var inst_29006 = (state_29008[(2)]);
var state_29008__$1 = state_29008;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29008__$1,inst_29006);
} else {
if((state_val_29009 === (4))){
var inst_28965 = (state_29008[(2)]);
var inst_28966 = fluree.db.dbfunctions.internal.function_error.call(null,inst_28965,"?user_id-from-auth","Context Object");
var state_29008__$1 = state_29008;
var statearr_29013_29025 = state_29008__$1;
(statearr_29013_29025[(2)] = inst_28966);

(statearr_29013_29025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29009 === (5))){
var _ = (function (){var statearr_29014 = state_29008;
(statearr_29014[(4)] = cljs.core.rest.call(null,(state_29008[(4)])));

return statearr_29014;
})();
var state_29008__$1 = state_29008;
var ex29012 = (state_29008__$1[(2)]);
var statearr_29015_29026 = state_29008__$1;
(statearr_29015_29026[(5)] = ex29012);


var statearr_29016_29027 = state_29008__$1;
(statearr_29016_29027[(1)] = (4));

(statearr_29016_29027[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29009 === (6))){
var inst_28992 = (state_29008[(2)]);
var inst_28993 = fluree.db.util.async.throw_err.call(null,inst_28992);
var inst_28994 = cljs.core.nth.call(null,inst_28993,(0),null);
var inst_28995 = cljs.core.nth.call(null,inst_28993,(1),null);
var inst_28996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28997 = ["_user/_auth","_id"];
var inst_28998 = (new cljs.core.PersistentVector(null,2,(5),inst_28996,inst_28997,null));
var inst_28999 = fluree.db.dbfunctions.internal.get_in.call(null,inst_28994,inst_28998);
var inst_29000 = cljs.core.first.call(null,inst_28999);
var inst_29001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29002 = [inst_29000,inst_28995];
var inst_29003 = (new cljs.core.PersistentVector(null,2,(5),inst_29001,inst_29002,null));
var _ = (function (){var statearr_29017 = state_29008;
(statearr_29017[(4)] = cljs.core.rest.call(null,(state_29008[(4)])));

return statearr_29017;
})();
var state_29008__$1 = state_29008;
var statearr_29018_29028 = state_29008__$1;
(statearr_29018_29028[(2)] = inst_29003);

(statearr_29018_29028[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0 = (function (){
var statearr_29019 = [null,null,null,null,null,null,null];
(statearr_29019[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__);

(statearr_29019[(1)] = (1));

return statearr_29019;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1 = (function (state_29008){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29008);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29020){var ex__2749__auto__ = e29020;
var statearr_29021_29029 = state_29008;
(statearr_29021_29029[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29008[(4)]))){
var statearr_29022_29030 = state_29008;
(statearr_29022_29030[(1)] = cljs.core.first.call(null,(state_29008[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29031 = state_29008;
state_29008 = G__29031;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__ = function(state_29008){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1.call(this,state_29008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29023 = f__2769__auto__.call(null);
(statearr_29023[(6)] = c__2768__auto__);

return statearr_29023;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29053){
var state_val_29054 = (state_29053[(1)]);
if((state_val_29054 === (7))){
var inst_29038 = (state_29053[(7)]);
var inst_29042 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29043 = fluree.db.dbproto._subid.call(null,inst_29042,inst_29038);
var state_29053__$1 = state_29053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29053__$1,(9),inst_29043);
} else {
if((state_val_29054 === (1))){
var state_29053__$1 = state_29053;
var statearr_29055_29074 = state_29053__$1;
(statearr_29055_29074[(2)] = null);

(statearr_29055_29074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29054 === (4))){
var inst_29032 = (state_29053[(2)]);
var state_29053__$1 = state_29053;
var statearr_29056_29075 = state_29053__$1;
(statearr_29056_29075[(2)] = inst_29032);

(statearr_29056_29075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29054 === (6))){
var inst_29038 = (state_29053[(7)]);
var state_29053__$1 = state_29053;
var statearr_29057_29076 = state_29053__$1;
(statearr_29057_29076[(2)] = inst_29038);

(statearr_29057_29076[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29054 === (3))){
var inst_29051 = (state_29053[(2)]);
var state_29053__$1 = state_29053;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29053__$1,inst_29051);
} else {
if((state_val_29054 === (2))){
var inst_29038 = (state_29053[(7)]);
var _ = (function (){var statearr_29059 = state_29053;
(statearr_29059[(4)] = cljs.core.cons.call(null,(5),(state_29053[(4)])));

return statearr_29059;
})();
var inst_29038__$1 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29039 = typeof inst_29038__$1 === 'number';
var state_29053__$1 = (function (){var statearr_29060 = state_29053;
(statearr_29060[(7)] = inst_29038__$1);

return statearr_29060;
})();
if(cljs.core.truth_(inst_29039)){
var statearr_29061_29077 = state_29053__$1;
(statearr_29061_29077[(1)] = (6));

} else {
var statearr_29062_29078 = state_29053__$1;
(statearr_29062_29078[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29054 === (9))){
var inst_29045 = (state_29053[(2)]);
var inst_29046 = fluree.db.util.async.throw_err.call(null,inst_29045);
var state_29053__$1 = state_29053;
var statearr_29063_29079 = state_29053__$1;
(statearr_29063_29079[(2)] = inst_29046);

(statearr_29063_29079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29054 === (5))){
var _ = (function (){var statearr_29064 = state_29053;
(statearr_29064[(4)] = cljs.core.rest.call(null,(state_29053[(4)])));

return statearr_29064;
})();
var state_29053__$1 = state_29053;
var ex29058 = (state_29053__$1[(2)]);
var statearr_29065_29080 = state_29053__$1;
(statearr_29065_29080[(5)] = ex29058);


if((ex29058 instanceof Error)){
var statearr_29066_29081 = state_29053__$1;
(statearr_29066_29081[(1)] = (4));

(statearr_29066_29081[(5)] = null);

} else {
throw ex29058;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29054 === (8))){
var inst_29048 = (state_29053[(2)]);
var _ = (function (){var statearr_29067 = state_29053;
(statearr_29067[(4)] = cljs.core.rest.call(null,(state_29053[(4)])));

return statearr_29067;
})();
var state_29053__$1 = state_29053;
var statearr_29068_29082 = state_29053__$1;
(statearr_29068_29082[(2)] = inst_29048);

(statearr_29068_29082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_29069 = [null,null,null,null,null,null,null,null];
(statearr_29069[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_29069[(1)] = (1));

return statearr_29069;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_29053){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29070){var ex__2749__auto__ = e29070;
var statearr_29071_29083 = state_29053;
(statearr_29071_29083[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29053[(4)]))){
var statearr_29072_29084 = state_29053;
(statearr_29072_29084[(1)] = cljs.core.first.call(null,(state_29053[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29085 = state_29053;
state_29053 = G__29085;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_29053){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_29053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29073 = f__2769__auto__.call(null);
(statearr_29073[(6)] = c__2768__auto__);

return statearr_29073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv.call(null,(function (p1__29086_SHARP_){
return fluree.db.flake.op.call(null,p1__29086_SHARP_) === true;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29087_SHARP_){
return fluree.db.flake.o.call(null,p1__29087_SHARP_);
}),trueF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29088){var e = e29088;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objT",flakes);
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv.call(null,(function (p1__29089_SHARP_){
return fluree.db.flake.op.call(null,p1__29089_SHARP_) === false;
}),flakes);
var objs = cljs.core.map.call(null,(function (p1__29090_SHARP_){
return fluree.db.flake.o.call(null,p1__29090_SHARP_);
}),falseF);
var sum = cljs.core.reduce.call(null,cljs.core._PLUS_,objs);
return sum;
}catch (e29091){var e = e29091;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"objF",flakes);
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = (Math.floor(fluree.db.dbfunctions.internal._STAR_.call(null,base,max_SINGLEQUOTE_)) | (0));
return num;
}catch (e29092){var e = e29092;
return fluree.db.dbfunctions.internal.function_error.call(null,e,"rand",instant,max_SINGLEQUOTE_);
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_29172){
var state_val_29173 = (state_29172[(1)]);
if((state_val_29173 === (7))){
var inst_29111 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val);
var inst_29112 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29113 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29114 = cljs.core.PersistentHashMap.fromArrays(inst_29112,inst_29113);
var inst_29115 = cljs.core.ex_info.call(null,inst_29111,inst_29114);
var inst_29116 = (function(){throw inst_29115})();
var state_29172__$1 = state_29172;
var statearr_29174_29209 = state_29172__$1;
(statearr_29174_29209[(2)] = inst_29116);

(statearr_29174_29209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (1))){
var state_29172__$1 = state_29172;
var statearr_29175_29210 = state_29172__$1;
(statearr_29175_29210[(2)] = null);

(statearr_29175_29210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (4))){
var inst_29093 = (state_29172[(2)]);
var state_29172__$1 = state_29172;
var statearr_29176_29211 = state_29172__$1;
(statearr_29176_29211[(2)] = inst_29093);

(statearr_29176_29211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (15))){
var inst_29156 = (state_29172[(7)]);
var inst_29152 = (state_29172[(2)]);
var inst_29153 = fluree.db.util.async.throw_err.call(null,inst_29152);
var inst_29154 = cljs.core.nth.call(null,inst_29153,(0),null);
var inst_29155 = cljs.core.nth.call(null,inst_29153,(1),null);
var inst_29156__$1 = cljs.core.first.call(null,inst_29154);
var inst_29157 = cljs.core._EQ_.call(null,inst_29156__$1,compare_val);
var state_29172__$1 = (function (){var statearr_29177 = state_29172;
(statearr_29177[(8)] = inst_29155);

(statearr_29177[(7)] = inst_29156__$1);

return statearr_29177;
})();
if(inst_29157){
var statearr_29178_29212 = state_29172__$1;
(statearr_29178_29212[(1)] = (16));

} else {
var statearr_29179_29213 = state_29172__$1;
(statearr_29179_29213[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (13))){
var state_29172__$1 = state_29172;
var statearr_29180_29214 = state_29172__$1;
(statearr_29180_29214[(2)] = null);

(statearr_29180_29214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (6))){
var state_29172__$1 = state_29172;
var statearr_29181_29215 = state_29172__$1;
(statearr_29181_29215[(2)] = null);

(statearr_29181_29215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (17))){
var inst_29156 = (state_29172[(7)]);
var inst_29160 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29156)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29161 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29162 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29163 = cljs.core.PersistentHashMap.fromArrays(inst_29161,inst_29162);
var inst_29164 = cljs.core.ex_info.call(null,inst_29160,inst_29163);
var inst_29165 = (function(){throw inst_29164})();
var state_29172__$1 = state_29172;
var statearr_29182_29216 = state_29172__$1;
(statearr_29182_29216[(2)] = inst_29165);

(statearr_29182_29216[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (3))){
var inst_29170 = (state_29172[(2)]);
var state_29172__$1 = state_29172;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29172__$1,inst_29170);
} else {
if((state_val_29173 === (12))){
var inst_29108 = (state_29172[(9)]);
var inst_29131 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas on a multi-cardinality predicate: ",inst_29108);
var inst_29132 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29133 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29134 = cljs.core.PersistentHashMap.fromArrays(inst_29132,inst_29133);
var inst_29135 = cljs.core.ex_info.call(null,inst_29131,inst_29134);
var inst_29136 = (function(){throw inst_29135})();
var state_29172__$1 = state_29172;
var statearr_29183_29217 = state_29172__$1;
(statearr_29183_29217[(2)] = inst_29136);

(statearr_29183_29217[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (2))){
var inst_29105 = (state_29172[(10)]);
var inst_29107 = (state_29172[(11)]);
var inst_29106 = (state_29172[(12)]);
var _ = (function (){var statearr_29184 = state_29172;
(statearr_29184[(4)] = cljs.core.cons.call(null,(5),(state_29172[(4)])));

return statearr_29184;
})();
var inst_29103 = _QMARK_ctx;
var inst_29104 = cljs.core.__destructure_map.call(null,inst_29103);
var inst_29105__$1 = cljs.core.get.call(null,inst_29104,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29106__$1 = cljs.core.get.call(null,inst_29104,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29107__$1 = cljs.core.get.call(null,inst_29104,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29108 = fluree.db.dbproto._p_prop.call(null,inst_29107__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29106__$1);
var state_29172__$1 = (function (){var statearr_29185 = state_29172;
(statearr_29185[(10)] = inst_29105__$1);

(statearr_29185[(11)] = inst_29107__$1);

(statearr_29185[(9)] = inst_29108);

(statearr_29185[(12)] = inst_29106__$1);

return statearr_29185;
})();
if(cljs.core.truth_(inst_29105__$1)){
var statearr_29186_29218 = state_29172__$1;
(statearr_29186_29218[(1)] = (6));

} else {
var statearr_29187_29219 = state_29172__$1;
(statearr_29187_29219[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (11))){
var inst_29107 = (state_29172[(11)]);
var inst_29106 = (state_29172[(12)]);
var inst_29128 = (state_29172[(2)]);
var inst_29129 = fluree.db.dbproto._p_prop.call(null,inst_29107,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29106);
var state_29172__$1 = (function (){var statearr_29189 = state_29172;
(statearr_29189[(13)] = inst_29128);

return statearr_29189;
})();
if(cljs.core.truth_(inst_29129)){
var statearr_29190_29220 = state_29172__$1;
(statearr_29190_29220[(1)] = (12));

} else {
var statearr_29191_29221 = state_29172__$1;
(statearr_29191_29221[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (9))){
var state_29172__$1 = state_29172;
var statearr_29192_29222 = state_29172__$1;
(statearr_29192_29222[(2)] = null);

(statearr_29192_29222[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (5))){
var _ = (function (){var statearr_29193 = state_29172;
(statearr_29193[(4)] = cljs.core.rest.call(null,(state_29172[(4)])));

return statearr_29193;
})();
var state_29172__$1 = state_29172;
var ex29188 = (state_29172__$1[(2)]);
var statearr_29194_29223 = state_29172__$1;
(statearr_29194_29223[(5)] = ex29188);


if((ex29188 instanceof Error)){
var statearr_29195_29224 = state_29172__$1;
(statearr_29195_29224[(1)] = (4));

(statearr_29195_29224[(5)] = null);

} else {
throw ex29188;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (14))){
var inst_29105 = (state_29172[(10)]);
var inst_29107 = (state_29172[(11)]);
var inst_29108 = (state_29172[(9)]);
var inst_29139 = (state_29172[(2)]);
var inst_29140 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29143 = [inst_29105,inst_29108,"?current-val"];
var inst_29144 = (new cljs.core.PersistentVector(null,3,(5),inst_29142,inst_29143,null));
var inst_29145 = [inst_29144];
var inst_29146 = (new cljs.core.PersistentVector(null,1,(5),inst_29141,inst_29145,null));
var inst_29147 = cljs.core.PersistentHashMap.EMPTY;
var inst_29148 = ["?current-val",inst_29146,inst_29147];
var inst_29149 = cljs.core.PersistentHashMap.fromArrays(inst_29140,inst_29148);
var inst_29150 = fluree.db.dbfunctions.internal.query.call(null,inst_29107,inst_29149);
var state_29172__$1 = (function (){var statearr_29196 = state_29172;
(statearr_29196[(14)] = inst_29139);

return statearr_29196;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29172__$1,(15),inst_29150);
} else {
if((state_val_29173 === (16))){
var state_29172__$1 = state_29172;
var statearr_29197_29225 = state_29172__$1;
(statearr_29197_29225[(2)] = new_val);

(statearr_29197_29225[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (10))){
var inst_29121 = fluree.db.dbfunctions.internal.str.call(null,"Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val);
var inst_29122 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29123 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29124 = cljs.core.PersistentHashMap.fromArrays(inst_29122,inst_29123);
var inst_29125 = cljs.core.ex_info.call(null,inst_29121,inst_29124);
var inst_29126 = (function(){throw inst_29125})();
var state_29172__$1 = state_29172;
var statearr_29198_29226 = state_29172__$1;
(statearr_29198_29226[(2)] = inst_29126);

(statearr_29198_29226[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (18))){
var inst_29167 = (state_29172[(2)]);
var _ = (function (){var statearr_29199 = state_29172;
(statearr_29199[(4)] = cljs.core.rest.call(null,(state_29172[(4)])));

return statearr_29199;
})();
var state_29172__$1 = state_29172;
var statearr_29200_29227 = state_29172__$1;
(statearr_29200_29227[(2)] = inst_29167);

(statearr_29200_29227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (8))){
var inst_29108 = (state_29172[(9)]);
var inst_29118 = (state_29172[(2)]);
var state_29172__$1 = (function (){var statearr_29201 = state_29172;
(statearr_29201[(15)] = inst_29118);

return statearr_29201;
})();
if(cljs.core.truth_(inst_29108)){
var statearr_29202_29228 = state_29172__$1;
(statearr_29202_29228[(1)] = (9));

} else {
var statearr_29203_29229 = state_29172__$1;
(statearr_29203_29229[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_29204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29204[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__);

(statearr_29204[(1)] = (1));

return statearr_29204;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1 = (function (state_29172){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_29172);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e29205){var ex__2749__auto__ = e29205;
var statearr_29206_29230 = state_29172;
(statearr_29206_29230[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_29172[(4)]))){
var statearr_29207_29231 = state_29172;
(statearr_29207_29231[(1)] = cljs.core.first.call(null,(state_29172[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29232 = state_29172;
state_29172 = G__29232;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__ = function(state_29172){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1.call(this,state_29172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_29208 = f__2769__auto__.call(null);
(statearr_29208[(6)] = c__2768__auto__);

return statearr_29208;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
