// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___54136 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54187){
var state_val_54188 = (state_54187[(1)]);
if((state_val_54188 === (7))){
var inst_54182 = (state_54187[(2)]);
var _ = (function (){var statearr_54189 = state_54187;
(statearr_54189[(4)] = cljs.core.rest.call(null,(state_54187[(4)])));

return statearr_54189;
})();
var state_54187__$1 = state_54187;
var statearr_54190_54217 = state_54187__$1;
(statearr_54190_54217[(2)] = inst_54182);

(statearr_54190_54217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (1))){
var state_54187__$1 = state_54187;
var statearr_54191_54218 = state_54187__$1;
(statearr_54191_54218[(2)] = null);

(statearr_54191_54218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (4))){
var inst_54137 = (state_54187[(2)]);
var state_54187__$1 = state_54187;
var statearr_54192_54219 = state_54187__$1;
(statearr_54192_54219[(2)] = inst_54137);

(statearr_54192_54219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (13))){
var inst_54178 = (state_54187[(2)]);
var state_54187__$1 = state_54187;
var statearr_54193_54220 = state_54187__$1;
(statearr_54193_54220[(2)] = inst_54178);

(statearr_54193_54220[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (6))){
var inst_54162 = (state_54187[(7)]);
var inst_54155 = (state_54187[(8)]);
var inst_54161 = cljs.core.seq.call(null,inst_54155);
var inst_54162__$1 = cljs.core.first.call(null,inst_54161);
var inst_54163 = cljs.core.next.call(null,inst_54161);
var inst_54164 = cljs.core.not.call(null,inst_54162__$1);
var state_54187__$1 = (function (){var statearr_54194 = state_54187;
(statearr_54194[(7)] = inst_54162__$1);

(statearr_54194[(9)] = inst_54163);

return statearr_54194;
})();
if(inst_54164){
var statearr_54195_54221 = state_54187__$1;
(statearr_54195_54221[(1)] = (8));

} else {
var statearr_54196_54222 = state_54187__$1;
(statearr_54196_54222[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (3))){
var inst_54185 = (state_54187[(2)]);
var state_54187__$1 = state_54187;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54187__$1,inst_54185);
} else {
if((state_val_54188 === (12))){
var inst_54162 = (state_54187[(7)]);
var inst_54163 = (state_54187[(9)]);
var inst_54156 = (state_54187[(10)]);
var inst_54175 = cljs.core.conj.call(null,inst_54156,inst_54162);
var inst_54155 = inst_54163;
var inst_54156__$1 = inst_54175;
var state_54187__$1 = (function (){var statearr_54197 = state_54187;
(statearr_54197[(8)] = inst_54155);

(statearr_54197[(10)] = inst_54156__$1);

return statearr_54197;
})();
var statearr_54198_54223 = state_54187__$1;
(statearr_54198_54223[(2)] = null);

(statearr_54198_54223[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (2))){
var _ = (function (){var statearr_54199 = state_54187;
(statearr_54199[(4)] = cljs.core.cons.call(null,(5),(state_54187[(4)])));

return statearr_54199;
})();
var inst_54150 = args;
var inst_54151 = cljs.core.seq.call(null,inst_54150);
var inst_54152 = cljs.core.first.call(null,inst_54151);
var inst_54153 = cljs.core.next.call(null,inst_54151);
var inst_54154 = cljs.core.PersistentVector.EMPTY;
var inst_54155 = inst_54150;
var inst_54156 = inst_54154;
var state_54187__$1 = (function (){var statearr_54200 = state_54187;
(statearr_54200[(11)] = inst_54152);

(statearr_54200[(12)] = inst_54153);

(statearr_54200[(8)] = inst_54155);

(statearr_54200[(10)] = inst_54156);

return statearr_54200;
})();
var statearr_54201_54224 = state_54187__$1;
(statearr_54201_54224[(2)] = null);

(statearr_54201_54224[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (11))){
var inst_54162 = (state_54187[(7)]);
var state_54187__$1 = state_54187;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54187__$1,(14),inst_54162);
} else {
if((state_val_54188 === (9))){
var inst_54162 = (state_54187[(7)]);
var inst_54167 = fluree.db.util.async.channel_QMARK_.call(null,inst_54162);
var state_54187__$1 = state_54187;
if(inst_54167){
var statearr_54203_54225 = state_54187__$1;
(statearr_54203_54225[(1)] = (11));

} else {
var statearr_54204_54226 = state_54187__$1;
(statearr_54204_54226[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (5))){
var _ = (function (){var statearr_54205 = state_54187;
(statearr_54205[(4)] = cljs.core.rest.call(null,(state_54187[(4)])));

return statearr_54205;
})();
var state_54187__$1 = state_54187;
var ex54202 = (state_54187__$1[(2)]);
var statearr_54206_54227 = state_54187__$1;
(statearr_54206_54227[(5)] = ex54202);


if((ex54202 instanceof Error)){
var statearr_54207_54228 = state_54187__$1;
(statearr_54207_54228[(1)] = (4));

(statearr_54207_54228[(5)] = null);

} else {
throw ex54202;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (14))){
var inst_54163 = (state_54187[(9)]);
var inst_54156 = (state_54187[(10)]);
var inst_54170 = (state_54187[(2)]);
var inst_54171 = fluree.db.util.async.throw_err.call(null,inst_54170);
var inst_54172 = cljs.core.conj.call(null,inst_54156,inst_54171);
var inst_54155 = inst_54163;
var inst_54156__$1 = inst_54172;
var state_54187__$1 = (function (){var statearr_54208 = state_54187;
(statearr_54208[(8)] = inst_54155);

(statearr_54208[(10)] = inst_54156__$1);

return statearr_54208;
})();
var statearr_54209_54229 = state_54187__$1;
(statearr_54209_54229[(2)] = null);

(statearr_54209_54229[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (10))){
var inst_54180 = (state_54187[(2)]);
var state_54187__$1 = state_54187;
var statearr_54210_54230 = state_54187__$1;
(statearr_54210_54230[(2)] = inst_54180);

(statearr_54210_54230[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54188 === (8))){
var inst_54156 = (state_54187[(10)]);
var state_54187__$1 = state_54187;
var statearr_54211_54231 = state_54187__$1;
(statearr_54211_54231[(2)] = inst_54156);

(statearr_54211_54231[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0 = (function (){
var statearr_54212 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54212[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__);

(statearr_54212[(1)] = (1));

return statearr_54212;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1 = (function (state_54187){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54187);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54213){var ex__2749__auto__ = e54213;
var statearr_54214_54232 = state_54187;
(statearr_54214_54232[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54187[(4)]))){
var statearr_54215_54233 = state_54187;
(statearr_54215_54233[(1)] = cljs.core.first.call(null,(state_54187[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54234 = state_54187;
state_54187 = G__54234;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__ = function(state_54187){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1.call(this,state_54187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54216 = f__2769__auto__.call(null);
(statearr_54216[(6)] = c__2768__auto__);

return statearr_54216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54236 = entry;
var res = cljs.core.nth.call(null,vec__54236,(0),null);
var cost = cljs.core.nth.call(null,vec__54236,(1),null);
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__54235_SHARP_){
return cljs.core.update.call(null,cljs.core.update.call(null,cljs.core.update.call(null,p1__54235_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54284){
var state_val_54285 = (state_54284[(1)]);
if((state_val_54285 === (7))){
var state_54284__$1 = state_54284;
var statearr_54286_54315 = state_54284__$1;
(statearr_54286_54315[(2)] = coll);

(statearr_54286_54315[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (1))){
var state_54284__$1 = state_54284;
var statearr_54287_54316 = state_54284__$1;
(statearr_54287_54316[(2)] = null);

(statearr_54287_54316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (4))){
var inst_54239 = (state_54284[(2)]);
var state_54284__$1 = state_54284;
var statearr_54288_54317 = state_54284__$1;
(statearr_54288_54317[(2)] = inst_54239);

(statearr_54288_54317[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (15))){
var inst_54258 = (state_54284[(7)]);
var inst_54266 = (state_54284[(2)]);
var inst_54267 = fluree.db.dbfunctions.internal.nth.call(null,inst_54258,inst_54266);
var inst_54268 = cljs.core.count.call(null,inst_54258);
var inst_54269 = ((9) + inst_54268);
var inst_54270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54271 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54273 = [inst_54258,inst_54266];
var inst_54274 = (new cljs.core.PersistentVector(null,2,(5),inst_54272,inst_54273,null));
var inst_54275 = ["nth",inst_54274,inst_54267];
var inst_54276 = cljs.core.PersistentHashMap.fromArrays(inst_54271,inst_54275);
var inst_54277 = [inst_54276,inst_54269];
var inst_54278 = (new cljs.core.PersistentVector(null,2,(5),inst_54270,inst_54277,null));
var inst_54279 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54278);
var _ = (function (){var statearr_54289 = state_54284;
(statearr_54289[(4)] = cljs.core.rest.call(null,(state_54284[(4)])));

return statearr_54289;
})();
var state_54284__$1 = (function (){var statearr_54290 = state_54284;
(statearr_54290[(8)] = inst_54279);

return statearr_54290;
})();
var statearr_54291_54318 = state_54284__$1;
(statearr_54291_54318[(2)] = inst_54267);

(statearr_54291_54318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (13))){
var state_54284__$1 = state_54284;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54284__$1,(16),key);
} else {
if((state_val_54285 === (6))){
var state_54284__$1 = state_54284;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54284__$1,(9),coll);
} else {
if((state_val_54285 === (3))){
var inst_54282 = (state_54284[(2)]);
var state_54284__$1 = state_54284;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54284__$1,inst_54282);
} else {
if((state_val_54285 === (12))){
var inst_54258 = (state_54284[(2)]);
var inst_54259 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54284__$1 = (function (){var statearr_54292 = state_54284;
(statearr_54292[(7)] = inst_54258);

return statearr_54292;
})();
if(inst_54259){
var statearr_54293_54319 = state_54284__$1;
(statearr_54293_54319[(1)] = (13));

} else {
var statearr_54294_54320 = state_54284__$1;
(statearr_54294_54320[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (2))){
var _ = (function (){var statearr_54295 = state_54284;
(statearr_54295[(4)] = cljs.core.cons.call(null,(5),(state_54284[(4)])));

return statearr_54295;
})();
var inst_54245 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54284__$1 = state_54284;
if(inst_54245){
var statearr_54296_54321 = state_54284__$1;
(statearr_54296_54321[(1)] = (6));

} else {
var statearr_54297_54322 = state_54284__$1;
(statearr_54297_54322[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (11))){
var inst_54252 = (state_54284[(9)]);
var state_54284__$1 = state_54284;
var statearr_54299_54323 = state_54284__$1;
(statearr_54299_54323[(2)] = inst_54252);

(statearr_54299_54323[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (9))){
var inst_54248 = (state_54284[(2)]);
var inst_54249 = fluree.db.util.async.throw_err.call(null,inst_54248);
var state_54284__$1 = state_54284;
var statearr_54300_54324 = state_54284__$1;
(statearr_54300_54324[(2)] = inst_54249);

(statearr_54300_54324[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (5))){
var _ = (function (){var statearr_54301 = state_54284;
(statearr_54301[(4)] = cljs.core.rest.call(null,(state_54284[(4)])));

return statearr_54301;
})();
var state_54284__$1 = state_54284;
var ex54298 = (state_54284__$1[(2)]);
var statearr_54302_54325 = state_54284__$1;
(statearr_54302_54325[(5)] = ex54298);


if((ex54298 instanceof Error)){
var statearr_54303_54326 = state_54284__$1;
(statearr_54303_54326[(1)] = (4));

(statearr_54303_54326[(5)] = null);

} else {
throw ex54298;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (14))){
var state_54284__$1 = state_54284;
var statearr_54304_54327 = state_54284__$1;
(statearr_54304_54327[(2)] = key);

(statearr_54304_54327[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (16))){
var inst_54262 = (state_54284[(2)]);
var inst_54263 = fluree.db.util.async.throw_err.call(null,inst_54262);
var state_54284__$1 = state_54284;
var statearr_54305_54328 = state_54284__$1;
(statearr_54305_54328[(2)] = inst_54263);

(statearr_54305_54328[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (10))){
var inst_54252 = (state_54284[(9)]);
var inst_54255 = cljs.core.vec.call(null,inst_54252);
var state_54284__$1 = state_54284;
var statearr_54306_54329 = state_54284__$1;
(statearr_54306_54329[(2)] = inst_54255);

(statearr_54306_54329[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54285 === (8))){
var inst_54252 = (state_54284[(9)]);
var inst_54252__$1 = (state_54284[(2)]);
var inst_54253 = cljs.core.set_QMARK_.call(null,inst_54252__$1);
var state_54284__$1 = (function (){var statearr_54307 = state_54284;
(statearr_54307[(9)] = inst_54252__$1);

return statearr_54307;
})();
if(inst_54253){
var statearr_54308_54330 = state_54284__$1;
(statearr_54308_54330[(1)] = (10));

} else {
var statearr_54309_54331 = state_54284__$1;
(statearr_54309_54331[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0 = (function (){
var statearr_54310 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54310[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__);

(statearr_54310[(1)] = (1));

return statearr_54310;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1 = (function (state_54284){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54284);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54311){var ex__2749__auto__ = e54311;
var statearr_54312_54332 = state_54284;
(statearr_54312_54332[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54284[(4)]))){
var statearr_54313_54333 = state_54284;
(statearr_54313_54333[(1)] = cljs.core.first.call(null,(state_54284[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54334 = state_54284;
state_54284 = G__54334;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__ = function(state_54284){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1.call(this,state_54284);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54314 = f__2769__auto__.call(null);
(statearr_54314[(6)] = c__2768__auto__);

return statearr_54314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54395){
var state_val_54396 = (state_54395[(1)]);
if((state_val_54396 === (7))){
var state_54395__$1 = state_54395;
var statearr_54397_54431 = state_54395__$1;
(statearr_54397_54431[(2)] = test);

(statearr_54397_54431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (20))){
var inst_54369 = (state_54395[(2)]);
var inst_54370 = fluree.db.util.async.throw_err.call(null,inst_54369);
var state_54395__$1 = state_54395;
var statearr_54398_54432 = state_54395__$1;
(statearr_54398_54432[(2)] = inst_54370);

(statearr_54398_54432[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (1))){
var state_54395__$1 = state_54395;
var statearr_54399_54433 = state_54395__$1;
(statearr_54399_54433[(2)] = null);

(statearr_54399_54433[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (4))){
var inst_54335 = (state_54395[(2)]);
var state_54395__$1 = state_54395;
var statearr_54400_54434 = state_54395__$1;
(statearr_54400_54434[(2)] = inst_54335);

(statearr_54400_54434[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (15))){
var inst_54353 = (state_54395[(7)]);
var inst_54361 = (state_54395[(2)]);
var inst_54362 = [inst_54361,f];
var inst_54363 = (new cljs.core.PersistentVector(null,2,(5),inst_54353,inst_54362,null));
var state_54395__$1 = state_54395;
var statearr_54401_54435 = state_54395__$1;
(statearr_54401_54435[(2)] = inst_54363);

(statearr_54401_54435[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (13))){
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54395__$1,(16),t);
} else {
if((state_val_54396 === (6))){
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54395__$1,(9),test);
} else {
if((state_val_54396 === (17))){
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54395__$1,(20),f);
} else {
if((state_val_54396 === (3))){
var inst_54393 = (state_54395[(2)]);
var state_54395__$1 = state_54395;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54395__$1,inst_54393);
} else {
if((state_val_54396 === (12))){
var inst_54351 = (state_54395[(8)]);
var inst_54377 = (state_54395[(2)]);
var inst_54378 = cljs.core.nth.call(null,inst_54377,(0),null);
var inst_54379 = cljs.core.nth.call(null,inst_54377,(1),null);
var inst_54380 = fluree.db.dbfunctions.internal.if_else.call(null,inst_54351,inst_54378,inst_54379);
var inst_54381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54382 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54384 = [inst_54351,inst_54378,inst_54379];
var inst_54385 = (new cljs.core.PersistentVector(null,3,(5),inst_54383,inst_54384,null));
var inst_54386 = ["if-else",inst_54385,inst_54380];
var inst_54387 = cljs.core.PersistentHashMap.fromArrays(inst_54382,inst_54386);
var inst_54388 = [inst_54387,(10)];
var inst_54389 = (new cljs.core.PersistentVector(null,2,(5),inst_54381,inst_54388,null));
var inst_54390 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54389);
var _ = (function (){var statearr_54402 = state_54395;
(statearr_54402[(4)] = cljs.core.rest.call(null,(state_54395[(4)])));

return statearr_54402;
})();
var state_54395__$1 = (function (){var statearr_54403 = state_54395;
(statearr_54403[(9)] = inst_54390);

return statearr_54403;
})();
var statearr_54404_54436 = state_54395__$1;
(statearr_54404_54436[(2)] = inst_54380);

(statearr_54404_54436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (2))){
var _ = (function (){var statearr_54405 = state_54395;
(statearr_54405[(4)] = cljs.core.cons.call(null,(5),(state_54395[(4)])));

return statearr_54405;
})();
var inst_54344 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_54395__$1 = state_54395;
if(inst_54344){
var statearr_54406_54437 = state_54395__$1;
(statearr_54406_54437[(1)] = (6));

} else {
var statearr_54407_54438 = state_54395__$1;
(statearr_54407_54438[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (19))){
var inst_54365 = (state_54395[(10)]);
var inst_54373 = (state_54395[(2)]);
var inst_54374 = [f,inst_54373];
var inst_54375 = (new cljs.core.PersistentVector(null,2,(5),inst_54365,inst_54374,null));
var state_54395__$1 = state_54395;
var statearr_54408_54439 = state_54395__$1;
(statearr_54408_54439[(2)] = inst_54375);

(statearr_54408_54439[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (11))){
var inst_54365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54366 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_54395__$1 = (function (){var statearr_54410 = state_54395;
(statearr_54410[(10)] = inst_54365);

return statearr_54410;
})();
if(inst_54366){
var statearr_54411_54440 = state_54395__$1;
(statearr_54411_54440[(1)] = (17));

} else {
var statearr_54412_54441 = state_54395__$1;
(statearr_54412_54441[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (9))){
var inst_54347 = (state_54395[(2)]);
var inst_54348 = fluree.db.util.async.throw_err.call(null,inst_54347);
var state_54395__$1 = state_54395;
var statearr_54413_54442 = state_54395__$1;
(statearr_54413_54442[(2)] = inst_54348);

(statearr_54413_54442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (5))){
var _ = (function (){var statearr_54414 = state_54395;
(statearr_54414[(4)] = cljs.core.rest.call(null,(state_54395[(4)])));

return statearr_54414;
})();
var state_54395__$1 = state_54395;
var ex54409 = (state_54395__$1[(2)]);
var statearr_54415_54443 = state_54395__$1;
(statearr_54415_54443[(5)] = ex54409);


if((ex54409 instanceof Error)){
var statearr_54416_54444 = state_54395__$1;
(statearr_54416_54444[(1)] = (4));

(statearr_54416_54444[(5)] = null);

} else {
throw ex54409;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (14))){
var state_54395__$1 = state_54395;
var statearr_54417_54445 = state_54395__$1;
(statearr_54417_54445[(2)] = t);

(statearr_54417_54445[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (16))){
var inst_54357 = (state_54395[(2)]);
var inst_54358 = fluree.db.util.async.throw_err.call(null,inst_54357);
var state_54395__$1 = state_54395;
var statearr_54418_54446 = state_54395__$1;
(statearr_54418_54446[(2)] = inst_54358);

(statearr_54418_54446[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (10))){
var inst_54353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54354 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_54395__$1 = (function (){var statearr_54419 = state_54395;
(statearr_54419[(7)] = inst_54353);

return statearr_54419;
})();
if(inst_54354){
var statearr_54420_54447 = state_54395__$1;
(statearr_54420_54447[(1)] = (13));

} else {
var statearr_54421_54448 = state_54395__$1;
(statearr_54421_54448[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (18))){
var state_54395__$1 = state_54395;
var statearr_54422_54449 = state_54395__$1;
(statearr_54422_54449[(2)] = f);

(statearr_54422_54449[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54396 === (8))){
var inst_54351 = (state_54395[(8)]);
var inst_54351__$1 = (state_54395[(2)]);
var state_54395__$1 = (function (){var statearr_54423 = state_54395;
(statearr_54423[(8)] = inst_54351__$1);

return statearr_54423;
})();
if(cljs.core.truth_(inst_54351__$1)){
var statearr_54424_54450 = state_54395__$1;
(statearr_54424_54450[(1)] = (10));

} else {
var statearr_54425_54451 = state_54395__$1;
(statearr_54425_54451[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0 = (function (){
var statearr_54426 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54426[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__);

(statearr_54426[(1)] = (1));

return statearr_54426;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1 = (function (state_54395){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54395);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54427){var ex__2749__auto__ = e54427;
var statearr_54428_54452 = state_54395;
(statearr_54428_54452[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54395[(4)]))){
var statearr_54429_54453 = state_54395;
(statearr_54429_54453[(1)] = cljs.core.first.call(null,(state_54395[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54454 = state_54395;
state_54395 = G__54454;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__ = function(state_54395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1.call(this,state_54395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54430 = f__2769__auto__.call(null);
(statearr_54430[(6)] = c__2768__auto__);

return statearr_54430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54484){
var state_val_54485 = (state_54484[(1)]);
if((state_val_54485 === (7))){
var state_54484__$1 = state_54484;
var statearr_54486_54505 = state_54484__$1;
(statearr_54486_54505[(2)] = arg);

(statearr_54486_54505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54485 === (1))){
var state_54484__$1 = state_54484;
var statearr_54487_54506 = state_54484__$1;
(statearr_54487_54506[(2)] = null);

(statearr_54487_54506[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54485 === (4))){
var inst_54455 = (state_54484[(2)]);
var state_54484__$1 = state_54484;
var statearr_54488_54507 = state_54484__$1;
(statearr_54488_54507[(2)] = inst_54455);

(statearr_54488_54507[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54485 === (6))){
var state_54484__$1 = state_54484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54484__$1,(9),arg);
} else {
if((state_val_54485 === (3))){
var inst_54482 = (state_54484[(2)]);
var state_54484__$1 = state_54484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54484__$1,inst_54482);
} else {
if((state_val_54485 === (2))){
var _ = (function (){var statearr_54490 = state_54484;
(statearr_54490[(4)] = cljs.core.cons.call(null,(5),(state_54484[(4)])));

return statearr_54490;
})();
var inst_54461 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54484__$1 = state_54484;
if(inst_54461){
var statearr_54491_54508 = state_54484__$1;
(statearr_54491_54508[(1)] = (6));

} else {
var statearr_54492_54509 = state_54484__$1;
(statearr_54492_54509[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54485 === (9))){
var inst_54464 = (state_54484[(2)]);
var inst_54465 = fluree.db.util.async.throw_err.call(null,inst_54464);
var state_54484__$1 = state_54484;
var statearr_54493_54510 = state_54484__$1;
(statearr_54493_54510[(2)] = inst_54465);

(statearr_54493_54510[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54485 === (5))){
var _ = (function (){var statearr_54494 = state_54484;
(statearr_54494[(4)] = cljs.core.rest.call(null,(state_54484[(4)])));

return statearr_54494;
})();
var state_54484__$1 = state_54484;
var ex54489 = (state_54484__$1[(2)]);
var statearr_54495_54511 = state_54484__$1;
(statearr_54495_54511[(5)] = ex54489);


if((ex54489 instanceof Error)){
var statearr_54496_54512 = state_54484__$1;
(statearr_54496_54512[(1)] = (4));

(statearr_54496_54512[(5)] = null);

} else {
throw ex54489;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54485 === (8))){
var inst_54468 = (state_54484[(2)]);
var inst_54469 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_54468);
var inst_54470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54473 = [inst_54468];
var inst_54474 = (new cljs.core.PersistentVector(null,1,(5),inst_54472,inst_54473,null));
var inst_54475 = ["nil?",inst_54474,inst_54469];
var inst_54476 = cljs.core.PersistentHashMap.fromArrays(inst_54471,inst_54475);
var inst_54477 = [inst_54476,(10)];
var inst_54478 = (new cljs.core.PersistentVector(null,2,(5),inst_54470,inst_54477,null));
var inst_54479 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54478);
var _ = (function (){var statearr_54497 = state_54484;
(statearr_54497[(4)] = cljs.core.rest.call(null,(state_54484[(4)])));

return statearr_54497;
})();
var state_54484__$1 = (function (){var statearr_54498 = state_54484;
(statearr_54498[(7)] = inst_54479);

return statearr_54498;
})();
var statearr_54499_54513 = state_54484__$1;
(statearr_54499_54513[(2)] = inst_54469);

(statearr_54499_54513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54500 = [null,null,null,null,null,null,null,null];
(statearr_54500[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__);

(statearr_54500[(1)] = (1));

return statearr_54500;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1 = (function (state_54484){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54501){var ex__2749__auto__ = e54501;
var statearr_54502_54514 = state_54484;
(statearr_54502_54514[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54484[(4)]))){
var statearr_54503_54515 = state_54484;
(statearr_54503_54515[(1)] = cljs.core.first.call(null,(state_54484[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54516 = state_54484;
state_54484 = G__54516;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__ = function(state_54484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1.call(this,state_54484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54504 = f__2769__auto__.call(null);
(statearr_54504[(6)] = c__2768__auto__);

return statearr_54504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54546){
var state_val_54547 = (state_54546[(1)]);
if((state_val_54547 === (7))){
var state_54546__$1 = state_54546;
var statearr_54548_54567 = state_54546__$1;
(statearr_54548_54567[(2)] = arg);

(statearr_54548_54567[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54547 === (1))){
var state_54546__$1 = state_54546;
var statearr_54549_54568 = state_54546__$1;
(statearr_54549_54568[(2)] = null);

(statearr_54549_54568[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54547 === (4))){
var inst_54517 = (state_54546[(2)]);
var state_54546__$1 = state_54546;
var statearr_54550_54569 = state_54546__$1;
(statearr_54550_54569[(2)] = inst_54517);

(statearr_54550_54569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54547 === (6))){
var state_54546__$1 = state_54546;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54546__$1,(9),arg);
} else {
if((state_val_54547 === (3))){
var inst_54544 = (state_54546[(2)]);
var state_54546__$1 = state_54546;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54546__$1,inst_54544);
} else {
if((state_val_54547 === (2))){
var _ = (function (){var statearr_54552 = state_54546;
(statearr_54552[(4)] = cljs.core.cons.call(null,(5),(state_54546[(4)])));

return statearr_54552;
})();
var inst_54523 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54546__$1 = state_54546;
if(inst_54523){
var statearr_54553_54570 = state_54546__$1;
(statearr_54553_54570[(1)] = (6));

} else {
var statearr_54554_54571 = state_54546__$1;
(statearr_54554_54571[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54547 === (9))){
var inst_54526 = (state_54546[(2)]);
var inst_54527 = fluree.db.util.async.throw_err.call(null,inst_54526);
var state_54546__$1 = state_54546;
var statearr_54555_54572 = state_54546__$1;
(statearr_54555_54572[(2)] = inst_54527);

(statearr_54555_54572[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54547 === (5))){
var _ = (function (){var statearr_54556 = state_54546;
(statearr_54556[(4)] = cljs.core.rest.call(null,(state_54546[(4)])));

return statearr_54556;
})();
var state_54546__$1 = state_54546;
var ex54551 = (state_54546__$1[(2)]);
var statearr_54557_54573 = state_54546__$1;
(statearr_54557_54573[(5)] = ex54551);


if((ex54551 instanceof Error)){
var statearr_54558_54574 = state_54546__$1;
(statearr_54558_54574[(1)] = (4));

(statearr_54558_54574[(5)] = null);

} else {
throw ex54551;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54547 === (8))){
var inst_54530 = (state_54546[(2)]);
var inst_54531 = fluree.db.dbfunctions.internal.not.call(null,inst_54530);
var inst_54532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54533 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54535 = [inst_54530];
var inst_54536 = (new cljs.core.PersistentVector(null,1,(5),inst_54534,inst_54535,null));
var inst_54537 = ["not",inst_54536,inst_54531];
var inst_54538 = cljs.core.PersistentHashMap.fromArrays(inst_54533,inst_54537);
var inst_54539 = [inst_54538,(10)];
var inst_54540 = (new cljs.core.PersistentVector(null,2,(5),inst_54532,inst_54539,null));
var inst_54541 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54540);
var _ = (function (){var statearr_54559 = state_54546;
(statearr_54559[(4)] = cljs.core.rest.call(null,(state_54546[(4)])));

return statearr_54559;
})();
var state_54546__$1 = (function (){var statearr_54560 = state_54546;
(statearr_54560[(7)] = inst_54541);

return statearr_54560;
})();
var statearr_54561_54575 = state_54546__$1;
(statearr_54561_54575[(2)] = inst_54531);

(statearr_54561_54575[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0 = (function (){
var statearr_54562 = [null,null,null,null,null,null,null,null];
(statearr_54562[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__);

(statearr_54562[(1)] = (1));

return statearr_54562;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1 = (function (state_54546){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54546);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54563){var ex__2749__auto__ = e54563;
var statearr_54564_54576 = state_54546;
(statearr_54564_54576[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54546[(4)]))){
var statearr_54565_54577 = state_54546;
(statearr_54565_54577[(1)] = cljs.core.first.call(null,(state_54546[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54578 = state_54546;
state_54546 = G__54578;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__ = function(state_54546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1.call(this,state_54546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54566 = f__2769__auto__.call(null);
(statearr_54566[(6)] = c__2768__auto__);

return statearr_54566;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54608){
var state_val_54609 = (state_54608[(1)]);
if((state_val_54609 === (7))){
var state_54608__$1 = state_54608;
var statearr_54610_54629 = state_54608__$1;
(statearr_54610_54629[(2)] = arg);

(statearr_54610_54629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (1))){
var state_54608__$1 = state_54608;
var statearr_54611_54630 = state_54608__$1;
(statearr_54611_54630[(2)] = null);

(statearr_54611_54630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (4))){
var inst_54579 = (state_54608[(2)]);
var state_54608__$1 = state_54608;
var statearr_54612_54631 = state_54608__$1;
(statearr_54612_54631[(2)] = inst_54579);

(statearr_54612_54631[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (6))){
var state_54608__$1 = state_54608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54608__$1,(9),arg);
} else {
if((state_val_54609 === (3))){
var inst_54606 = (state_54608[(2)]);
var state_54608__$1 = state_54608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54608__$1,inst_54606);
} else {
if((state_val_54609 === (2))){
var _ = (function (){var statearr_54614 = state_54608;
(statearr_54614[(4)] = cljs.core.cons.call(null,(5),(state_54608[(4)])));

return statearr_54614;
})();
var inst_54585 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54608__$1 = state_54608;
if(inst_54585){
var statearr_54615_54632 = state_54608__$1;
(statearr_54615_54632[(1)] = (6));

} else {
var statearr_54616_54633 = state_54608__$1;
(statearr_54616_54633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (9))){
var inst_54588 = (state_54608[(2)]);
var inst_54589 = fluree.db.util.async.throw_err.call(null,inst_54588);
var state_54608__$1 = state_54608;
var statearr_54617_54634 = state_54608__$1;
(statearr_54617_54634[(2)] = inst_54589);

(statearr_54617_54634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (5))){
var _ = (function (){var statearr_54618 = state_54608;
(statearr_54618[(4)] = cljs.core.rest.call(null,(state_54608[(4)])));

return statearr_54618;
})();
var state_54608__$1 = state_54608;
var ex54613 = (state_54608__$1[(2)]);
var statearr_54619_54635 = state_54608__$1;
(statearr_54619_54635[(5)] = ex54613);


if((ex54613 instanceof Error)){
var statearr_54620_54636 = state_54608__$1;
(statearr_54620_54636[(1)] = (4));

(statearr_54620_54636[(5)] = null);

} else {
throw ex54613;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54609 === (8))){
var inst_54592 = (state_54608[(2)]);
var inst_54593 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_54592);
var inst_54594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54595 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54597 = [inst_54592];
var inst_54598 = (new cljs.core.PersistentVector(null,1,(5),inst_54596,inst_54597,null));
var inst_54599 = ["empty?",inst_54598,inst_54593];
var inst_54600 = cljs.core.PersistentHashMap.fromArrays(inst_54595,inst_54599);
var inst_54601 = [inst_54600,(10)];
var inst_54602 = (new cljs.core.PersistentVector(null,2,(5),inst_54594,inst_54601,null));
var inst_54603 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54602);
var _ = (function (){var statearr_54621 = state_54608;
(statearr_54621[(4)] = cljs.core.rest.call(null,(state_54608[(4)])));

return statearr_54621;
})();
var state_54608__$1 = (function (){var statearr_54622 = state_54608;
(statearr_54622[(7)] = inst_54603);

return statearr_54622;
})();
var statearr_54623_54637 = state_54608__$1;
(statearr_54623_54637[(2)] = inst_54593);

(statearr_54623_54637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_54624 = [null,null,null,null,null,null,null,null];
(statearr_54624[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__);

(statearr_54624[(1)] = (1));

return statearr_54624;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1 = (function (state_54608){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54625){var ex__2749__auto__ = e54625;
var statearr_54626_54638 = state_54608;
(statearr_54626_54638[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54608[(4)]))){
var statearr_54627_54639 = state_54608;
(statearr_54627_54639[(1)] = cljs.core.first.call(null,(state_54608[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54640 = state_54608;
state_54608 = G__54640;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__ = function(state_54608){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1.call(this,state_54608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54628 = f__2769__auto__.call(null);
(statearr_54628[(6)] = c__2768__auto__);

return statearr_54628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54685 = arguments.length;
var i__5770__auto___54686 = (0);
while(true){
if((i__5770__auto___54686 < len__5769__auto___54685)){
args__5775__auto__.push((arguments[i__5770__auto___54686]));

var G__54687 = (i__5770__auto___54686 + (1));
i__5770__auto___54686 = G__54687;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54668){
var state_val_54669 = (state_54668[(1)]);
if((state_val_54669 === (1))){
var state_54668__$1 = state_54668;
var statearr_54670_54688 = state_54668__$1;
(statearr_54670_54688[(2)] = null);

(statearr_54670_54688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54669 === (2))){
var _ = (function (){var statearr_54671 = state_54668;
(statearr_54671[(4)] = cljs.core.cons.call(null,(5),(state_54668[(4)])));

return statearr_54671;
})();
var inst_54649 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54668__$1 = state_54668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54668__$1,(6),inst_54649);
} else {
if((state_val_54669 === (3))){
var inst_54666 = (state_54668[(2)]);
var state_54668__$1 = state_54668;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54668__$1,inst_54666);
} else {
if((state_val_54669 === (4))){
var inst_54643 = (state_54668[(2)]);
var state_54668__$1 = state_54668;
var statearr_54673_54689 = state_54668__$1;
(statearr_54673_54689[(2)] = inst_54643);

(statearr_54673_54689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54669 === (5))){
var _ = (function (){var statearr_54674 = state_54668;
(statearr_54674[(4)] = cljs.core.rest.call(null,(state_54668[(4)])));

return statearr_54674;
})();
var state_54668__$1 = state_54668;
var ex54672 = (state_54668__$1[(2)]);
var statearr_54675_54690 = state_54668__$1;
(statearr_54675_54690[(5)] = ex54672);


if((ex54672 instanceof Error)){
var statearr_54676_54691 = state_54668__$1;
(statearr_54676_54691[(1)] = (4));

(statearr_54676_54691[(5)] = null);

} else {
throw ex54672;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54669 === (6))){
var inst_54651 = (state_54668[(2)]);
var inst_54652 = fluree.db.util.async.throw_err.call(null,inst_54651);
var inst_54653 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_54652);
var inst_54654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54655 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54656 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54657 = [inst_54652];
var inst_54658 = (new cljs.core.PersistentVector(null,1,(5),inst_54656,inst_54657,null));
var inst_54659 = ["str",inst_54658,inst_54653];
var inst_54660 = cljs.core.PersistentHashMap.fromArrays(inst_54655,inst_54659);
var inst_54661 = [inst_54660,(10)];
var inst_54662 = (new cljs.core.PersistentVector(null,2,(5),inst_54654,inst_54661,null));
var inst_54663 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54662);
var _ = (function (){var statearr_54677 = state_54668;
(statearr_54677[(4)] = cljs.core.rest.call(null,(state_54668[(4)])));

return statearr_54677;
})();
var state_54668__$1 = (function (){var statearr_54678 = state_54668;
(statearr_54678[(7)] = inst_54663);

return statearr_54678;
})();
var statearr_54679_54692 = state_54668__$1;
(statearr_54679_54692[(2)] = inst_54653);

(statearr_54679_54692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54680 = [null,null,null,null,null,null,null,null];
(statearr_54680[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54680[(1)] = (1));

return statearr_54680;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54668){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54681){var ex__2749__auto__ = e54681;
var statearr_54682_54693 = state_54668;
(statearr_54682_54693[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54668[(4)]))){
var statearr_54683_54694 = state_54668;
(statearr_54683_54694[(1)] = cljs.core.first.call(null,(state_54668[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54695 = state_54668;
state_54668 = G__54695;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54668){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54684 = f__2769__auto__.call(null);
(statearr_54684[(6)] = c__2768__auto__);

return statearr_54684;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54641){
var G__54642 = cljs.core.first.call(null,seq54641);
var seq54641__$1 = cljs.core.next.call(null,seq54641);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54642,seq54641__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54721){
var state_val_54722 = (state_54721[(1)]);
if((state_val_54722 === (1))){
var state_54721__$1 = state_54721;
var statearr_54723_54738 = state_54721__$1;
(statearr_54723_54738[(2)] = null);

(statearr_54723_54738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54722 === (2))){
var _ = (function (){var statearr_54724 = state_54721;
(statearr_54724[(4)] = cljs.core.cons.call(null,(5),(state_54721[(4)])));

return statearr_54724;
})();
var inst_54702 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54721__$1 = state_54721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54721__$1,(6),inst_54702);
} else {
if((state_val_54722 === (3))){
var inst_54719 = (state_54721[(2)]);
var state_54721__$1 = state_54721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54721__$1,inst_54719);
} else {
if((state_val_54722 === (4))){
var inst_54696 = (state_54721[(2)]);
var state_54721__$1 = state_54721;
var statearr_54726_54739 = state_54721__$1;
(statearr_54726_54739[(2)] = inst_54696);

(statearr_54726_54739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54722 === (5))){
var _ = (function (){var statearr_54727 = state_54721;
(statearr_54727[(4)] = cljs.core.rest.call(null,(state_54721[(4)])));

return statearr_54727;
})();
var state_54721__$1 = state_54721;
var ex54725 = (state_54721__$1[(2)]);
var statearr_54728_54740 = state_54721__$1;
(statearr_54728_54740[(5)] = ex54725);


if((ex54725 instanceof Error)){
var statearr_54729_54741 = state_54721__$1;
(statearr_54729_54741[(1)] = (4));

(statearr_54729_54741[(5)] = null);

} else {
throw ex54725;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54722 === (6))){
var inst_54704 = (state_54721[(2)]);
var inst_54705 = fluree.db.util.async.throw_err.call(null,inst_54704);
var inst_54706 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_54705);
var inst_54707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54708 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54710 = [inst_54705];
var inst_54711 = (new cljs.core.PersistentVector(null,1,(5),inst_54709,inst_54710,null));
var inst_54712 = ["subs",inst_54711,inst_54706];
var inst_54713 = cljs.core.PersistentHashMap.fromArrays(inst_54708,inst_54712);
var inst_54714 = [inst_54713,(30)];
var inst_54715 = (new cljs.core.PersistentVector(null,2,(5),inst_54707,inst_54714,null));
var inst_54716 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54715);
var _ = (function (){var statearr_54730 = state_54721;
(statearr_54730[(4)] = cljs.core.rest.call(null,(state_54721[(4)])));

return statearr_54730;
})();
var state_54721__$1 = (function (){var statearr_54731 = state_54721;
(statearr_54731[(7)] = inst_54716);

return statearr_54731;
})();
var statearr_54732_54742 = state_54721__$1;
(statearr_54732_54742[(2)] = inst_54706);

(statearr_54732_54742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0 = (function (){
var statearr_54733 = [null,null,null,null,null,null,null,null];
(statearr_54733[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__);

(statearr_54733[(1)] = (1));

return statearr_54733;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1 = (function (state_54721){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54734){var ex__2749__auto__ = e54734;
var statearr_54735_54743 = state_54721;
(statearr_54735_54743[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54721[(4)]))){
var statearr_54736_54744 = state_54721;
(statearr_54736_54744[(1)] = cljs.core.first.call(null,(state_54721[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54745 = state_54721;
state_54721 = G__54745;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__ = function(state_54721){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1.call(this,state_54721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54737 = f__2769__auto__.call(null);
(statearr_54737[(6)] = c__2768__auto__);

return statearr_54737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54775){
var state_val_54776 = (state_54775[(1)]);
if((state_val_54776 === (7))){
var state_54775__$1 = state_54775;
var statearr_54777_54796 = state_54775__$1;
(statearr_54777_54796[(2)] = str);

(statearr_54777_54796[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54776 === (1))){
var state_54775__$1 = state_54775;
var statearr_54778_54797 = state_54775__$1;
(statearr_54778_54797[(2)] = null);

(statearr_54778_54797[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54776 === (4))){
var inst_54746 = (state_54775[(2)]);
var state_54775__$1 = state_54775;
var statearr_54779_54798 = state_54775__$1;
(statearr_54779_54798[(2)] = inst_54746);

(statearr_54779_54798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54776 === (6))){
var state_54775__$1 = state_54775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54775__$1,(9),str);
} else {
if((state_val_54776 === (3))){
var inst_54773 = (state_54775[(2)]);
var state_54775__$1 = state_54775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54775__$1,inst_54773);
} else {
if((state_val_54776 === (2))){
var _ = (function (){var statearr_54781 = state_54775;
(statearr_54781[(4)] = cljs.core.cons.call(null,(5),(state_54775[(4)])));

return statearr_54781;
})();
var inst_54752 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54775__$1 = state_54775;
if(inst_54752){
var statearr_54782_54799 = state_54775__$1;
(statearr_54782_54799[(1)] = (6));

} else {
var statearr_54783_54800 = state_54775__$1;
(statearr_54783_54800[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54776 === (9))){
var inst_54755 = (state_54775[(2)]);
var inst_54756 = fluree.db.util.async.throw_err.call(null,inst_54755);
var state_54775__$1 = state_54775;
var statearr_54784_54801 = state_54775__$1;
(statearr_54784_54801[(2)] = inst_54756);

(statearr_54784_54801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54776 === (5))){
var _ = (function (){var statearr_54785 = state_54775;
(statearr_54785[(4)] = cljs.core.rest.call(null,(state_54775[(4)])));

return statearr_54785;
})();
var state_54775__$1 = state_54775;
var ex54780 = (state_54775__$1[(2)]);
var statearr_54786_54802 = state_54775__$1;
(statearr_54786_54802[(5)] = ex54780);


if((ex54780 instanceof Error)){
var statearr_54787_54803 = state_54775__$1;
(statearr_54787_54803[(1)] = (4));

(statearr_54787_54803[(5)] = null);

} else {
throw ex54780;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54776 === (8))){
var inst_54759 = (state_54775[(2)]);
var inst_54760 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_54759);
var inst_54761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54762 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54764 = [inst_54759];
var inst_54765 = (new cljs.core.PersistentVector(null,1,(5),inst_54763,inst_54764,null));
var inst_54766 = ["lower-case",inst_54765,inst_54760];
var inst_54767 = cljs.core.PersistentHashMap.fromArrays(inst_54762,inst_54766);
var inst_54768 = [inst_54767,(10)];
var inst_54769 = (new cljs.core.PersistentVector(null,2,(5),inst_54761,inst_54768,null));
var inst_54770 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54769);
var _ = (function (){var statearr_54788 = state_54775;
(statearr_54788[(4)] = cljs.core.rest.call(null,(state_54775[(4)])));

return statearr_54788;
})();
var state_54775__$1 = (function (){var statearr_54789 = state_54775;
(statearr_54789[(7)] = inst_54770);

return statearr_54789;
})();
var statearr_54790_54804 = state_54775__$1;
(statearr_54790_54804[(2)] = inst_54760);

(statearr_54790_54804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0 = (function (){
var statearr_54791 = [null,null,null,null,null,null,null,null];
(statearr_54791[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__);

(statearr_54791[(1)] = (1));

return statearr_54791;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1 = (function (state_54775){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54792){var ex__2749__auto__ = e54792;
var statearr_54793_54805 = state_54775;
(statearr_54793_54805[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54775[(4)]))){
var statearr_54794_54806 = state_54775;
(statearr_54794_54806[(1)] = cljs.core.first.call(null,(state_54775[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54807 = state_54775;
state_54775 = G__54807;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__ = function(state_54775){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1.call(this,state_54775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54795 = f__2769__auto__.call(null);
(statearr_54795[(6)] = c__2768__auto__);

return statearr_54795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54837){
var state_val_54838 = (state_54837[(1)]);
if((state_val_54838 === (7))){
var state_54837__$1 = state_54837;
var statearr_54839_54858 = state_54837__$1;
(statearr_54839_54858[(2)] = str);

(statearr_54839_54858[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (1))){
var state_54837__$1 = state_54837;
var statearr_54840_54859 = state_54837__$1;
(statearr_54840_54859[(2)] = null);

(statearr_54840_54859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (4))){
var inst_54808 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
var statearr_54841_54860 = state_54837__$1;
(statearr_54841_54860[(2)] = inst_54808);

(statearr_54841_54860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (6))){
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54837__$1,(9),str);
} else {
if((state_val_54838 === (3))){
var inst_54835 = (state_54837[(2)]);
var state_54837__$1 = state_54837;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54837__$1,inst_54835);
} else {
if((state_val_54838 === (2))){
var _ = (function (){var statearr_54843 = state_54837;
(statearr_54843[(4)] = cljs.core.cons.call(null,(5),(state_54837[(4)])));

return statearr_54843;
})();
var inst_54814 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54837__$1 = state_54837;
if(inst_54814){
var statearr_54844_54861 = state_54837__$1;
(statearr_54844_54861[(1)] = (6));

} else {
var statearr_54845_54862 = state_54837__$1;
(statearr_54845_54862[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (9))){
var inst_54817 = (state_54837[(2)]);
var inst_54818 = fluree.db.util.async.throw_err.call(null,inst_54817);
var state_54837__$1 = state_54837;
var statearr_54846_54863 = state_54837__$1;
(statearr_54846_54863[(2)] = inst_54818);

(statearr_54846_54863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (5))){
var _ = (function (){var statearr_54847 = state_54837;
(statearr_54847[(4)] = cljs.core.rest.call(null,(state_54837[(4)])));

return statearr_54847;
})();
var state_54837__$1 = state_54837;
var ex54842 = (state_54837__$1[(2)]);
var statearr_54848_54864 = state_54837__$1;
(statearr_54848_54864[(5)] = ex54842);


if((ex54842 instanceof Error)){
var statearr_54849_54865 = state_54837__$1;
(statearr_54849_54865[(1)] = (4));

(statearr_54849_54865[(5)] = null);

} else {
throw ex54842;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54838 === (8))){
var inst_54821 = (state_54837[(2)]);
var inst_54822 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_54821);
var inst_54823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54824 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54826 = [inst_54821];
var inst_54827 = (new cljs.core.PersistentVector(null,1,(5),inst_54825,inst_54826,null));
var inst_54828 = ["upper-case",inst_54827,inst_54822];
var inst_54829 = cljs.core.PersistentHashMap.fromArrays(inst_54824,inst_54828);
var inst_54830 = [inst_54829,(10)];
var inst_54831 = (new cljs.core.PersistentVector(null,2,(5),inst_54823,inst_54830,null));
var inst_54832 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54831);
var _ = (function (){var statearr_54850 = state_54837;
(statearr_54850[(4)] = cljs.core.rest.call(null,(state_54837[(4)])));

return statearr_54850;
})();
var state_54837__$1 = (function (){var statearr_54851 = state_54837;
(statearr_54851[(7)] = inst_54832);

return statearr_54851;
})();
var statearr_54852_54866 = state_54837__$1;
(statearr_54852_54866[(2)] = inst_54822);

(statearr_54852_54866[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0 = (function (){
var statearr_54853 = [null,null,null,null,null,null,null,null];
(statearr_54853[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__);

(statearr_54853[(1)] = (1));

return statearr_54853;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1 = (function (state_54837){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54837);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54854){var ex__2749__auto__ = e54854;
var statearr_54855_54867 = state_54837;
(statearr_54855_54867[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54837[(4)]))){
var statearr_54856_54868 = state_54837;
(statearr_54856_54868[(1)] = cljs.core.first.call(null,(state_54837[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54869 = state_54837;
state_54837 = G__54869;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__ = function(state_54837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1.call(this,state_54837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54857 = f__2769__auto__.call(null);
(statearr_54857[(6)] = c__2768__auto__);

return statearr_54857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54871 = arguments.length;
switch (G__54871) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54899){
var state_val_54900 = (state_54899[(1)]);
if((state_val_54900 === (1))){
var state_54899__$1 = state_54899;
var statearr_54901_54917 = state_54899__$1;
(statearr_54901_54917[(2)] = null);

(statearr_54901_54917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54900 === (2))){
var _ = (function (){var statearr_54902 = state_54899;
(statearr_54902[(4)] = cljs.core.cons.call(null,(5),(state_54899[(4)])));

return statearr_54902;
})();
var inst_54881 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_54899__$1 = state_54899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54899__$1,(6),inst_54881);
} else {
if((state_val_54900 === (3))){
var inst_54897 = (state_54899[(2)]);
var state_54899__$1 = state_54899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54899__$1,inst_54897);
} else {
if((state_val_54900 === (4))){
var inst_54872 = (state_54899[(2)]);
var state_54899__$1 = state_54899;
var statearr_54904_54918 = state_54899__$1;
(statearr_54904_54918[(2)] = inst_54872);

(statearr_54904_54918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54900 === (5))){
var _ = (function (){var statearr_54905 = state_54899;
(statearr_54905[(4)] = cljs.core.rest.call(null,(state_54899[(4)])));

return statearr_54905;
})();
var state_54899__$1 = state_54899;
var ex54903 = (state_54899__$1[(2)]);
var statearr_54906_54919 = state_54899__$1;
(statearr_54906_54919[(5)] = ex54903);


if((ex54903 instanceof Error)){
var statearr_54907_54920 = state_54899__$1;
(statearr_54907_54920[(1)] = (4));

(statearr_54907_54920[(5)] = null);

} else {
throw ex54903;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54900 === (6))){
var inst_54883 = (state_54899[(2)]);
var inst_54884 = fluree.db.util.async.throw_err.call(null,inst_54883);
var inst_54885 = cljs.core.nth.call(null,inst_54884,(0),null);
var inst_54886 = cljs.core.nth.call(null,inst_54884,(1),null);
var inst_54887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54888 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54889 = ["?s","?ctx",inst_54885];
var inst_54890 = cljs.core.PersistentHashMap.fromArrays(inst_54888,inst_54889);
var inst_54891 = ((10) + inst_54886);
var inst_54892 = [inst_54890,inst_54891];
var inst_54893 = (new cljs.core.PersistentVector(null,2,(5),inst_54887,inst_54892,null));
var inst_54894 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54893);
var _ = (function (){var statearr_54908 = state_54899;
(statearr_54908[(4)] = cljs.core.rest.call(null,(state_54899[(4)])));

return statearr_54908;
})();
var state_54899__$1 = (function (){var statearr_54909 = state_54899;
(statearr_54909[(7)] = inst_54894);

return statearr_54909;
})();
var statearr_54910_54921 = state_54899__$1;
(statearr_54910_54921[(2)] = inst_54885);

(statearr_54910_54921[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54911 = [null,null,null,null,null,null,null,null];
(statearr_54911[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54911[(1)] = (1));

return statearr_54911;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54899){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54912){var ex__2749__auto__ = e54912;
var statearr_54913_54922 = state_54899;
(statearr_54913_54922[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54899[(4)]))){
var statearr_54914_54923 = state_54899;
(statearr_54914_54923[(1)] = cljs.core.first.call(null,(state_54899[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54924 = state_54899;
state_54899 = G__54924;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54899){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54915 = f__2769__auto__.call(null);
(statearr_54915[(6)] = c__2768__auto__);

return statearr_54915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54926 = arguments.length;
switch (G__54926) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_54964){
var state_val_54965 = (state_54964[(1)]);
if((state_val_54965 === (7))){
var inst_54957 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54964__$1 = state_54964;
var statearr_54966_54986 = state_54964__$1;
(statearr_54966_54986[(2)] = inst_54957);

(statearr_54966_54986[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (1))){
var state_54964__$1 = state_54964;
var statearr_54967_54987 = state_54964__$1;
(statearr_54967_54987[(2)] = null);

(statearr_54967_54987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (4))){
var inst_54927 = (state_54964[(2)]);
var state_54964__$1 = state_54964;
var statearr_54968_54988 = state_54964__$1;
(statearr_54968_54988[(2)] = inst_54927);

(statearr_54968_54988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (6))){
var inst_54938 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_54964__$1 = state_54964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54964__$1,(10),inst_54938);
} else {
if((state_val_54965 === (3))){
var inst_54962 = (state_54964[(2)]);
var state_54964__$1 = state_54964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54964__$1,inst_54962);
} else {
if((state_val_54965 === (2))){
var _ = (function (){var statearr_54970 = state_54964;
(statearr_54970[(4)] = cljs.core.cons.call(null,(5),(state_54964[(4)])));

return statearr_54970;
})();
var inst_54933 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54964__$1 = state_54964;
if(cljs.core.truth_(inst_54933)){
var statearr_54971_54989 = state_54964__$1;
(statearr_54971_54989[(1)] = (6));

} else {
var statearr_54972_54990 = state_54964__$1;
(statearr_54972_54990[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (9))){
var inst_54944 = (state_54964[(2)]);
var inst_54945 = fluree.db.util.async.throw_err.call(null,inst_54944);
var inst_54946 = cljs.core.nth.call(null,inst_54945,(0),null);
var inst_54947 = cljs.core.nth.call(null,inst_54945,(1),null);
var inst_54948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54949 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54950 = ["?p","?ctx",inst_54946];
var inst_54951 = cljs.core.PersistentHashMap.fromArrays(inst_54949,inst_54950);
var inst_54952 = ((10) + inst_54947);
var inst_54953 = [inst_54951,inst_54952];
var inst_54954 = (new cljs.core.PersistentVector(null,2,(5),inst_54948,inst_54953,null));
var inst_54955 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54954);
var state_54964__$1 = (function (){var statearr_54973 = state_54964;
(statearr_54973[(7)] = inst_54955);

return statearr_54973;
})();
var statearr_54974_54991 = state_54964__$1;
(statearr_54974_54991[(2)] = inst_54946);

(statearr_54974_54991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (5))){
var _ = (function (){var statearr_54975 = state_54964;
(statearr_54975[(4)] = cljs.core.rest.call(null,(state_54964[(4)])));

return statearr_54975;
})();
var state_54964__$1 = state_54964;
var ex54969 = (state_54964__$1[(2)]);
var statearr_54976_54992 = state_54964__$1;
(statearr_54976_54992[(5)] = ex54969);


if((ex54969 instanceof Error)){
var statearr_54977_54993 = state_54964__$1;
(statearr_54977_54993[(1)] = (4));

(statearr_54977_54993[(5)] = null);

} else {
throw ex54969;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54965 === (10))){
var inst_54940 = (state_54964[(2)]);
var inst_54941 = fluree.db.util.async.throw_err.call(null,inst_54940);
var inst_54942 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_54941);
var state_54964__$1 = state_54964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54964__$1,(9),inst_54942);
} else {
if((state_val_54965 === (8))){
var inst_54959 = (state_54964[(2)]);
var _ = (function (){var statearr_54978 = state_54964;
(statearr_54978[(4)] = cljs.core.rest.call(null,(state_54964[(4)])));

return statearr_54978;
})();
var state_54964__$1 = state_54964;
var statearr_54979_54994 = state_54964__$1;
(statearr_54979_54994[(2)] = inst_54959);

(statearr_54979_54994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_54980 = [null,null,null,null,null,null,null,null];
(statearr_54980[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_54980[(1)] = (1));

return statearr_54980;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_54964){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_54964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e54981){var ex__2749__auto__ = e54981;
var statearr_54982_54995 = state_54964;
(statearr_54982_54995[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_54964[(4)]))){
var statearr_54983_54996 = state_54964;
(statearr_54983_54996[(1)] = cljs.core.first.call(null,(state_54964[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54997 = state_54964;
state_54964 = G__54997;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_54964){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_54964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_54984 = f__2769__auto__.call(null);
(statearr_54984[(6)] = c__2768__auto__);

return statearr_54984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55046 = arguments.length;
var i__5770__auto___55047 = (0);
while(true){
if((i__5770__auto___55047 < len__5769__auto___55046)){
args__5775__auto__.push((arguments[i__5770__auto___55047]));

var G__55048 = (i__5770__auto___55047 + (1));
i__5770__auto___55047 = G__55048;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55029){
var state_val_55030 = (state_55029[(1)]);
if((state_val_55030 === (1))){
var state_55029__$1 = state_55029;
var statearr_55031_55049 = state_55029__$1;
(statearr_55031_55049[(2)] = null);

(statearr_55031_55049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (2))){
var _ = (function (){var statearr_55032 = state_55029;
(statearr_55032[(4)] = cljs.core.cons.call(null,(5),(state_55029[(4)])));

return statearr_55032;
})();
var inst_55006 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55029__$1 = state_55029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55029__$1,(6),inst_55006);
} else {
if((state_val_55030 === (3))){
var inst_55027 = (state_55029[(2)]);
var state_55029__$1 = state_55029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55029__$1,inst_55027);
} else {
if((state_val_55030 === (4))){
var inst_55000 = (state_55029[(2)]);
var state_55029__$1 = state_55029;
var statearr_55034_55050 = state_55029__$1;
(statearr_55034_55050[(2)] = inst_55000);

(statearr_55034_55050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (5))){
var _ = (function (){var statearr_55035 = state_55029;
(statearr_55035[(4)] = cljs.core.rest.call(null,(state_55029[(4)])));

return statearr_55035;
})();
var state_55029__$1 = state_55029;
var ex55033 = (state_55029__$1[(2)]);
var statearr_55036_55051 = state_55029__$1;
(statearr_55036_55051[(5)] = ex55033);


if((ex55033 instanceof Error)){
var statearr_55037_55052 = state_55029__$1;
(statearr_55037_55052[(1)] = (4));

(statearr_55037_55052[(5)] = null);

} else {
throw ex55033;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55030 === (6))){
var inst_55008 = (state_55029[(2)]);
var inst_55009 = fluree.db.util.async.throw_err.call(null,inst_55008);
var inst_55010 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_55009);
var inst_55011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55012 = [inst_55009];
var inst_55013 = (new cljs.core.PersistentVector(null,1,(5),inst_55011,inst_55012,null));
var inst_55014 = cljs.core.count.call(null,inst_55013);
var inst_55015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55016 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55018 = [inst_55009];
var inst_55019 = (new cljs.core.PersistentVector(null,1,(5),inst_55017,inst_55018,null));
var inst_55020 = ["and",inst_55019,inst_55010];
var inst_55021 = cljs.core.PersistentHashMap.fromArrays(inst_55016,inst_55020);
var inst_55022 = [inst_55021,inst_55014];
var inst_55023 = (new cljs.core.PersistentVector(null,2,(5),inst_55015,inst_55022,null));
var inst_55024 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55023);
var _ = (function (){var statearr_55038 = state_55029;
(statearr_55038[(4)] = cljs.core.rest.call(null,(state_55029[(4)])));

return statearr_55038;
})();
var state_55029__$1 = (function (){var statearr_55039 = state_55029;
(statearr_55039[(7)] = inst_55024);

return statearr_55039;
})();
var statearr_55040_55053 = state_55029__$1;
(statearr_55040_55053[(2)] = inst_55010);

(statearr_55040_55053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55041 = [null,null,null,null,null,null,null,null];
(statearr_55041[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55041[(1)] = (1));

return statearr_55041;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55029){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55042){var ex__2749__auto__ = e55042;
var statearr_55043_55054 = state_55029;
(statearr_55043_55054[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55029[(4)]))){
var statearr_55044_55055 = state_55029;
(statearr_55044_55055[(1)] = cljs.core.first.call(null,(state_55029[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55056 = state_55029;
state_55029 = G__55056;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55029){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55045 = f__2769__auto__.call(null);
(statearr_55045[(6)] = c__2768__auto__);

return statearr_55045;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54998){
var G__54999 = cljs.core.first.call(null,seq54998);
var seq54998__$1 = cljs.core.next.call(null,seq54998);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54999,seq54998__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55105 = arguments.length;
var i__5770__auto___55106 = (0);
while(true){
if((i__5770__auto___55106 < len__5769__auto___55105)){
args__5775__auto__.push((arguments[i__5770__auto___55106]));

var G__55107 = (i__5770__auto___55106 + (1));
i__5770__auto___55106 = G__55107;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55088){
var state_val_55089 = (state_55088[(1)]);
if((state_val_55089 === (1))){
var state_55088__$1 = state_55088;
var statearr_55090_55108 = state_55088__$1;
(statearr_55090_55108[(2)] = null);

(statearr_55090_55108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55089 === (2))){
var _ = (function (){var statearr_55091 = state_55088;
(statearr_55091[(4)] = cljs.core.cons.call(null,(5),(state_55088[(4)])));

return statearr_55091;
})();
var inst_55065 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55088__$1 = state_55088;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55088__$1,(6),inst_55065);
} else {
if((state_val_55089 === (3))){
var inst_55086 = (state_55088[(2)]);
var state_55088__$1 = state_55088;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55088__$1,inst_55086);
} else {
if((state_val_55089 === (4))){
var inst_55059 = (state_55088[(2)]);
var state_55088__$1 = state_55088;
var statearr_55093_55109 = state_55088__$1;
(statearr_55093_55109[(2)] = inst_55059);

(statearr_55093_55109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55089 === (5))){
var _ = (function (){var statearr_55094 = state_55088;
(statearr_55094[(4)] = cljs.core.rest.call(null,(state_55088[(4)])));

return statearr_55094;
})();
var state_55088__$1 = state_55088;
var ex55092 = (state_55088__$1[(2)]);
var statearr_55095_55110 = state_55088__$1;
(statearr_55095_55110[(5)] = ex55092);


if((ex55092 instanceof Error)){
var statearr_55096_55111 = state_55088__$1;
(statearr_55096_55111[(1)] = (4));

(statearr_55096_55111[(5)] = null);

} else {
throw ex55092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55089 === (6))){
var inst_55067 = (state_55088[(2)]);
var inst_55068 = fluree.db.util.async.throw_err.call(null,inst_55067);
var inst_55069 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_55068);
var inst_55070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55071 = [inst_55068];
var inst_55072 = (new cljs.core.PersistentVector(null,1,(5),inst_55070,inst_55071,null));
var inst_55073 = cljs.core.count.call(null,inst_55072);
var inst_55074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55075 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55077 = [inst_55068];
var inst_55078 = (new cljs.core.PersistentVector(null,1,(5),inst_55076,inst_55077,null));
var inst_55079 = ["or",inst_55078,inst_55069];
var inst_55080 = cljs.core.PersistentHashMap.fromArrays(inst_55075,inst_55079);
var inst_55081 = [inst_55080,inst_55073];
var inst_55082 = (new cljs.core.PersistentVector(null,2,(5),inst_55074,inst_55081,null));
var inst_55083 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55082);
var _ = (function (){var statearr_55097 = state_55088;
(statearr_55097[(4)] = cljs.core.rest.call(null,(state_55088[(4)])));

return statearr_55097;
})();
var state_55088__$1 = (function (){var statearr_55098 = state_55088;
(statearr_55098[(7)] = inst_55083);

return statearr_55098;
})();
var statearr_55099_55112 = state_55088__$1;
(statearr_55099_55112[(2)] = inst_55069);

(statearr_55099_55112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55100 = [null,null,null,null,null,null,null,null];
(statearr_55100[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55100[(1)] = (1));

return statearr_55100;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55088){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55088);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55101){var ex__2749__auto__ = e55101;
var statearr_55102_55113 = state_55088;
(statearr_55102_55113[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55088[(4)]))){
var statearr_55103_55114 = state_55088;
(statearr_55103_55114[(1)] = cljs.core.first.call(null,(state_55088[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55115 = state_55088;
state_55088 = G__55115;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55088){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55104 = f__2769__auto__.call(null);
(statearr_55104[(6)] = c__2768__auto__);

return statearr_55104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55057){
var G__55058 = cljs.core.first.call(null,seq55057);
var seq55057__$1 = cljs.core.next.call(null,seq55057);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55058,seq55057__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55153){
var state_val_55154 = (state_55153[(1)]);
if((state_val_55154 === (7))){
var inst_55129 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55153__$1 = state_55153;
if(inst_55129){
var statearr_55155_55178 = state_55153__$1;
(statearr_55155_55178[(1)] = (10));

} else {
var statearr_55156_55179 = state_55153__$1;
(statearr_55156_55179[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (1))){
var state_55153__$1 = state_55153;
var statearr_55157_55180 = state_55153__$1;
(statearr_55157_55180[(2)] = null);

(statearr_55157_55180[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (4))){
var inst_55116 = (state_55153[(2)]);
var state_55153__$1 = state_55153;
var statearr_55158_55181 = state_55153__$1;
(statearr_55158_55181[(2)] = inst_55116);

(statearr_55158_55181[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (13))){
var inst_55132 = (state_55153[(2)]);
var inst_55133 = fluree.db.util.async.throw_err.call(null,inst_55132);
var state_55153__$1 = state_55153;
var statearr_55159_55182 = state_55153__$1;
(statearr_55159_55182[(2)] = inst_55133);

(statearr_55159_55182[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (6))){
var inst_55124 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_55153__$1 = state_55153;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55153__$1,(9),inst_55124);
} else {
if((state_val_55154 === (3))){
var inst_55151 = (state_55153[(2)]);
var state_55153__$1 = state_55153;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55153__$1,inst_55151);
} else {
if((state_val_55154 === (12))){
var inst_55136 = (state_55153[(2)]);
var state_55153__$1 = state_55153;
var statearr_55160_55183 = state_55153__$1;
(statearr_55160_55183[(2)] = inst_55136);

(statearr_55160_55183[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (2))){
var _ = (function (){var statearr_55161 = state_55153;
(statearr_55161[(4)] = cljs.core.cons.call(null,(5),(state_55153[(4)])));

return statearr_55161;
})();
var inst_55122 = cljs.core.vector_QMARK_.call(null,coll);
var state_55153__$1 = state_55153;
if(inst_55122){
var statearr_55162_55184 = state_55153__$1;
(statearr_55162_55184[(1)] = (6));

} else {
var statearr_55163_55185 = state_55153__$1;
(statearr_55163_55185[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (11))){
var state_55153__$1 = state_55153;
var statearr_55165_55186 = state_55153__$1;
(statearr_55165_55186[(2)] = coll);

(statearr_55165_55186[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (9))){
var inst_55126 = (state_55153[(2)]);
var inst_55127 = fluree.db.util.async.throw_err.call(null,inst_55126);
var state_55153__$1 = state_55153;
var statearr_55166_55187 = state_55153__$1;
(statearr_55166_55187[(2)] = inst_55127);

(statearr_55166_55187[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (5))){
var _ = (function (){var statearr_55167 = state_55153;
(statearr_55167[(4)] = cljs.core.rest.call(null,(state_55153[(4)])));

return statearr_55167;
})();
var state_55153__$1 = state_55153;
var ex55164 = (state_55153__$1[(2)]);
var statearr_55168_55188 = state_55153__$1;
(statearr_55168_55188[(5)] = ex55164);


if((ex55164 instanceof Error)){
var statearr_55169_55189 = state_55153__$1;
(statearr_55169_55189[(1)] = (4));

(statearr_55169_55189[(5)] = null);

} else {
throw ex55164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55154 === (10))){
var state_55153__$1 = state_55153;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55153__$1,(13),coll);
} else {
if((state_val_55154 === (8))){
var inst_55138 = (state_55153[(2)]);
var inst_55139 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_55138);
var inst_55140 = cljs.core.count.call(null,inst_55139);
var inst_55141 = ((9) + inst_55140);
var inst_55142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55143 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55144 = ["count",inst_55138,inst_55140];
var inst_55145 = cljs.core.PersistentHashMap.fromArrays(inst_55143,inst_55144);
var inst_55146 = [inst_55145,inst_55141];
var inst_55147 = (new cljs.core.PersistentVector(null,2,(5),inst_55142,inst_55146,null));
var inst_55148 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55147);
var _ = (function (){var statearr_55170 = state_55153;
(statearr_55170[(4)] = cljs.core.rest.call(null,(state_55153[(4)])));

return statearr_55170;
})();
var state_55153__$1 = (function (){var statearr_55171 = state_55153;
(statearr_55171[(7)] = inst_55148);

return statearr_55171;
})();
var statearr_55172_55190 = state_55153__$1;
(statearr_55172_55190[(2)] = inst_55140);

(statearr_55172_55190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0 = (function (){
var statearr_55173 = [null,null,null,null,null,null,null,null];
(statearr_55173[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__);

(statearr_55173[(1)] = (1));

return statearr_55173;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1 = (function (state_55153){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55153);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55174){var ex__2749__auto__ = e55174;
var statearr_55175_55191 = state_55153;
(statearr_55175_55191[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55153[(4)]))){
var statearr_55176_55192 = state_55153;
(statearr_55176_55192[(1)] = cljs.core.first.call(null,(state_55153[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55193 = state_55153;
state_55153 = G__55193;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__ = function(state_55153){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1.call(this,state_55153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55177 = f__2769__auto__.call(null);
(statearr_55177[(6)] = c__2768__auto__);

return statearr_55177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__55194,subject,pred){
var map__55195 = p__55194;
var map__55195__$1 = cljs.core.__destructure_map.call(null,map__55195);
var _QMARK_ctx = map__55195__$1;
var cache = cljs.core.get.call(null,map__55195__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.call(null,map__55195__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55286){
var state_val_55287 = (state_55286[(1)]);
if((state_val_55287 === (7))){
var state_55286__$1 = state_55286;
var statearr_55288_55344 = state_55286__$1;
(statearr_55288_55344[(2)] = subject);

(statearr_55288_55344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (20))){
var state_55286__$1 = state_55286;
var statearr_55289_55345 = state_55286__$1;
(statearr_55289_55345[(2)] = cache);

(statearr_55289_55345[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (27))){
var inst_55229 = (state_55286[(7)]);
var inst_55217 = (state_55286[(8)]);
var inst_55243 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_55229,inst_55217);
var state_55286__$1 = state_55286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55286__$1,(29),inst_55243);
} else {
if((state_val_55287 === (1))){
var state_55286__$1 = state_55286;
var statearr_55290_55346 = state_55286__$1;
(statearr_55290_55346[(2)] = null);

(statearr_55290_55346[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (24))){
var inst_55229 = (state_55286[(7)]);
var inst_55256 = cljs.core.int_QMARK_.call(null,inst_55229);
var state_55286__$1 = state_55286;
if(inst_55256){
var statearr_55291_55347 = state_55286__$1;
(statearr_55291_55347[(1)] = (30));

} else {
var statearr_55292_55348 = state_55286__$1;
(statearr_55292_55348[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (4))){
var inst_55196 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
var statearr_55293_55349 = state_55286__$1;
(statearr_55293_55349[(2)] = inst_55196);

(statearr_55293_55349[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (15))){
var inst_55209 = (state_55286[(9)]);
var state_55286__$1 = state_55286;
var statearr_55294_55350 = state_55286__$1;
(statearr_55294_55350[(2)] = inst_55209);

(statearr_55294_55350[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (21))){
var inst_55230 = (state_55286[(10)]);
var state_55286__$1 = state_55286;
var statearr_55295_55351 = state_55286__$1;
(statearr_55295_55351[(2)] = inst_55230);

(statearr_55295_55351[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (31))){
var state_55286__$1 = state_55286;
var statearr_55296_55352 = state_55286__$1;
(statearr_55296_55352[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (32))){
var inst_55269 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
var statearr_55298_55353 = state_55286__$1;
(statearr_55298_55353[(2)] = inst_55269);

(statearr_55298_55353[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (33))){
var inst_55260 = (state_55286[(2)]);
var inst_55261 = fluree.db.util.async.throw_err.call(null,inst_55260);
var state_55286__$1 = state_55286;
var statearr_55299_55354 = state_55286__$1;
(statearr_55299_55354[(2)] = inst_55261);

(statearr_55299_55354[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (13))){
var inst_55213 = (state_55286[(2)]);
var inst_55214 = fluree.db.util.async.throw_err.call(null,inst_55213);
var state_55286__$1 = state_55286;
var statearr_55300_55355 = state_55286__$1;
(statearr_55300_55355[(2)] = inst_55214);

(statearr_55300_55355[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (22))){
var inst_55234 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
if(cljs.core.truth_(inst_55234)){
var statearr_55301_55356 = state_55286__$1;
(statearr_55301_55356[(1)] = (23));

} else {
var statearr_55302_55357 = state_55286__$1;
(statearr_55302_55357[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (36))){
var inst_55267 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
var statearr_55303_55358 = state_55286__$1;
(statearr_55303_55358[(2)] = inst_55267);

(statearr_55303_55358[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (29))){
var inst_55229 = (state_55286[(7)]);
var inst_55217 = (state_55286[(8)]);
var inst_55245 = (state_55286[(2)]);
var inst_55246 = fluree.db.util.async.throw_err.call(null,inst_55245);
var inst_55247 = cljs.core._deref.call(null,cache);
var inst_55248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55249 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55229,inst_55217];
var inst_55250 = (new cljs.core.PersistentVector(null,3,(5),inst_55248,inst_55249,null));
var inst_55251 = cljs.core.assoc_in.call(null,inst_55247,inst_55250,inst_55246);
var inst_55252 = cljs.core._vreset_BANG_.call(null,cache,inst_55251);
var state_55286__$1 = (function (){var statearr_55304 = state_55286;
(statearr_55304[(11)] = inst_55252);

return statearr_55304;
})();
var statearr_55305_55359 = state_55286__$1;
(statearr_55305_55359[(2)] = inst_55246);

(statearr_55305_55359[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (6))){
var state_55286__$1 = state_55286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55286__$1,(9),subject);
} else {
if((state_val_55287 === (28))){
var inst_55254 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
var statearr_55306_55360 = state_55286__$1;
(statearr_55306_55360[(2)] = inst_55254);

(statearr_55306_55360[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (25))){
var inst_55209 = (state_55286[(9)]);
var inst_55217 = (state_55286[(8)]);
var inst_55271 = (state_55286[(2)]);
var inst_55272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55273 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55275 = [inst_55209,inst_55217];
var inst_55276 = (new cljs.core.PersistentVector(null,2,(5),inst_55274,inst_55275,null));
var inst_55277 = ["get",inst_55276,inst_55271];
var inst_55278 = cljs.core.PersistentHashMap.fromArrays(inst_55273,inst_55277);
var inst_55279 = [inst_55278,(10)];
var inst_55280 = (new cljs.core.PersistentVector(null,2,(5),inst_55272,inst_55279,null));
var inst_55281 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55280);
var _ = (function (){var statearr_55307 = state_55286;
(statearr_55307[(4)] = cljs.core.rest.call(null,(state_55286[(4)])));

return statearr_55307;
})();
var state_55286__$1 = (function (){var statearr_55308 = state_55286;
(statearr_55308[(12)] = inst_55281);

return statearr_55308;
})();
var statearr_55309_55361 = state_55286__$1;
(statearr_55309_55361[(2)] = inst_55271);

(statearr_55309_55361[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (34))){
var inst_55229 = (state_55286[(7)]);
var inst_55217 = (state_55286[(8)]);
var inst_55264 = fluree.db.dbfunctions.internal.get.call(null,inst_55229,inst_55217);
var state_55286__$1 = state_55286;
var statearr_55310_55362 = state_55286__$1;
(statearr_55310_55362[(2)] = inst_55264);

(statearr_55310_55362[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (17))){
var inst_55209 = (state_55286[(9)]);
var inst_55223 = cljs.core.first.call(null,inst_55209);
var state_55286__$1 = state_55286;
var statearr_55311_55363 = state_55286__$1;
(statearr_55311_55363[(2)] = inst_55223);

(statearr_55311_55363[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (3))){
var inst_55284 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55286__$1,inst_55284);
} else {
if((state_val_55287 === (12))){
var inst_55209 = (state_55286[(9)]);
var inst_55217 = (state_55286[(2)]);
var inst_55218 = cljs.core.vector_QMARK_.call(null,inst_55209);
var state_55286__$1 = (function (){var statearr_55312 = state_55286;
(statearr_55312[(8)] = inst_55217);

return statearr_55312;
})();
if(inst_55218){
var statearr_55313_55364 = state_55286__$1;
(statearr_55313_55364[(1)] = (14));

} else {
var statearr_55314_55365 = state_55286__$1;
(statearr_55314_55365[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (2))){
var _ = (function (){var statearr_55315 = state_55286;
(statearr_55315[(4)] = cljs.core.cons.call(null,(5),(state_55286[(4)])));

return statearr_55315;
})();
var inst_55202 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55286__$1 = state_55286;
if(inst_55202){
var statearr_55316_55366 = state_55286__$1;
(statearr_55316_55366[(1)] = (6));

} else {
var statearr_55317_55367 = state_55286__$1;
(statearr_55317_55367[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (23))){
var inst_55229 = (state_55286[(7)]);
var inst_55240 = (state_55286[(13)]);
var inst_55217 = (state_55286[(8)]);
var inst_55236 = cljs.core.deref.call(null,cache);
var inst_55237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55238 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_55229,inst_55217];
var inst_55239 = (new cljs.core.PersistentVector(null,3,(5),inst_55237,inst_55238,null));
var inst_55240__$1 = cljs.core.get_in.call(null,inst_55236,inst_55239);
var state_55286__$1 = (function (){var statearr_55318 = state_55286;
(statearr_55318[(13)] = inst_55240__$1);

return statearr_55318;
})();
if(cljs.core.truth_(inst_55240__$1)){
var statearr_55319_55368 = state_55286__$1;
(statearr_55319_55368[(1)] = (26));

} else {
var statearr_55320_55369 = state_55286__$1;
(statearr_55320_55369[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (35))){
var state_55286__$1 = state_55286;
var statearr_55321_55370 = state_55286__$1;
(statearr_55321_55370[(2)] = null);

(statearr_55321_55370[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (19))){
var inst_55226 = (state_55286[(2)]);
var state_55286__$1 = state_55286;
var statearr_55322_55371 = state_55286__$1;
(statearr_55322_55371[(2)] = inst_55226);

(statearr_55322_55371[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (11))){
var state_55286__$1 = state_55286;
var statearr_55324_55372 = state_55286__$1;
(statearr_55324_55372[(2)] = pred);

(statearr_55324_55372[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (9))){
var inst_55205 = (state_55286[(2)]);
var inst_55206 = fluree.db.util.async.throw_err.call(null,inst_55205);
var state_55286__$1 = state_55286;
var statearr_55325_55373 = state_55286__$1;
(statearr_55325_55373[(2)] = inst_55206);

(statearr_55325_55373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (5))){
var _ = (function (){var statearr_55326 = state_55286;
(statearr_55326[(4)] = cljs.core.rest.call(null,(state_55286[(4)])));

return statearr_55326;
})();
var state_55286__$1 = state_55286;
var ex55323 = (state_55286__$1[(2)]);
var statearr_55327_55374 = state_55286__$1;
(statearr_55327_55374[(5)] = ex55323);


if((ex55323 instanceof Error)){
var statearr_55328_55375 = state_55286__$1;
(statearr_55328_55375[(1)] = (4));

(statearr_55328_55375[(5)] = null);

} else {
throw ex55323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (14))){
var inst_55209 = (state_55286[(9)]);
var inst_55220 = cljs.core.count.call(null,inst_55209);
var inst_55221 = cljs.core._EQ_.call(null,(1),inst_55220);
var state_55286__$1 = state_55286;
if(inst_55221){
var statearr_55329_55376 = state_55286__$1;
(statearr_55329_55376[(1)] = (17));

} else {
var statearr_55330_55377 = state_55286__$1;
(statearr_55330_55377[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (26))){
var inst_55240 = (state_55286[(13)]);
var state_55286__$1 = state_55286;
var statearr_55331_55378 = state_55286__$1;
(statearr_55331_55378[(2)] = inst_55240);

(statearr_55331_55378[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (16))){
var inst_55229 = (state_55286[(7)]);
var inst_55230 = (state_55286[(10)]);
var inst_55229__$1 = (state_55286[(2)]);
var inst_55230__$1 = cljs.core.int_QMARK_.call(null,inst_55229__$1);
var state_55286__$1 = (function (){var statearr_55332 = state_55286;
(statearr_55332[(7)] = inst_55229__$1);

(statearr_55332[(10)] = inst_55230__$1);

return statearr_55332;
})();
if(inst_55230__$1){
var statearr_55333_55379 = state_55286__$1;
(statearr_55333_55379[(1)] = (20));

} else {
var statearr_55334_55380 = state_55286__$1;
(statearr_55334_55380[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (30))){
var inst_55229 = (state_55286[(7)]);
var inst_55217 = (state_55286[(8)]);
var inst_55258 = fluree.db.dbfunctions.internal.get_subj_pred.call(null,db,inst_55229,inst_55217);
var state_55286__$1 = state_55286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55286__$1,(33),inst_55258);
} else {
if((state_val_55287 === (10))){
var state_55286__$1 = state_55286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55286__$1,(13),pred);
} else {
if((state_val_55287 === (18))){
var inst_55209 = (state_55286[(9)]);
var state_55286__$1 = state_55286;
var statearr_55335_55381 = state_55286__$1;
(statearr_55335_55381[(2)] = inst_55209);

(statearr_55335_55381[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55287 === (8))){
var inst_55209 = (state_55286[(2)]);
var inst_55210 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_55286__$1 = (function (){var statearr_55336 = state_55286;
(statearr_55336[(9)] = inst_55209);

return statearr_55336;
})();
if(inst_55210){
var statearr_55337_55382 = state_55286__$1;
(statearr_55337_55382[(1)] = (10));

} else {
var statearr_55338_55383 = state_55286__$1;
(statearr_55338_55383[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0 = (function (){
var statearr_55339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_55339[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__);

(statearr_55339[(1)] = (1));

return statearr_55339;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1 = (function (state_55286){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55340){var ex__2749__auto__ = e55340;
var statearr_55341_55384 = state_55286;
(statearr_55341_55384[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55286[(4)]))){
var statearr_55342_55385 = state_55286;
(statearr_55342_55385[(1)] = cljs.core.first.call(null,(state_55286[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55386 = state_55286;
state_55286 = G__55386;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__ = function(state_55286){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1.call(this,state_55286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55343 = f__2769__auto__.call(null);
(statearr_55343[(6)] = c__2768__auto__);

return statearr_55343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55425){
var state_val_55426 = (state_55425[(1)]);
if((state_val_55426 === (7))){
var inst_55393 = (state_55425[(7)]);
var state_55425__$1 = state_55425;
var statearr_55427_55451 = state_55425__$1;
(statearr_55427_55451[(2)] = inst_55393);

(statearr_55427_55451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (1))){
var state_55425__$1 = state_55425;
var statearr_55428_55452 = state_55425__$1;
(statearr_55428_55452[(2)] = null);

(statearr_55428_55452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (4))){
var inst_55387 = (state_55425[(2)]);
var state_55425__$1 = state_55425;
var statearr_55429_55453 = state_55425__$1;
(statearr_55429_55453[(2)] = inst_55387);

(statearr_55429_55453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (6))){
var inst_55395 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55425__$1 = state_55425;
var statearr_55430_55454 = state_55425__$1;
(statearr_55430_55454[(2)] = inst_55395);

(statearr_55430_55454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (3))){
var inst_55423 = (state_55425[(2)]);
var state_55425__$1 = state_55425;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55425__$1,inst_55423);
} else {
if((state_val_55426 === (12))){
var inst_55405 = (state_55425[(2)]);
var inst_55406 = fluree.db.util.async.throw_err.call(null,inst_55405);
var inst_55407 = cljs.core.nth.call(null,inst_55406,(0),null);
var inst_55408 = cljs.core.nth.call(null,inst_55406,(1),null);
var inst_55409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55410 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55411 = ["?pO","?ctx",inst_55407];
var inst_55412 = cljs.core.PersistentHashMap.fromArrays(inst_55410,inst_55411);
var inst_55413 = ((10) + inst_55408);
var inst_55414 = [inst_55412,inst_55413];
var inst_55415 = (new cljs.core.PersistentVector(null,2,(5),inst_55409,inst_55414,null));
var inst_55416 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55415);
var state_55425__$1 = (function (){var statearr_55431 = state_55425;
(statearr_55431[(8)] = inst_55416);

return statearr_55431;
})();
var statearr_55432_55455 = state_55425__$1;
(statearr_55432_55455[(2)] = inst_55407);

(statearr_55432_55455[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (2))){
var inst_55393 = (state_55425[(7)]);
var _ = (function (){var statearr_55433 = state_55425;
(statearr_55433[(4)] = cljs.core.cons.call(null,(5),(state_55425[(4)])));

return statearr_55433;
})();
var inst_55393__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55425__$1 = (function (){var statearr_55434 = state_55425;
(statearr_55434[(7)] = inst_55393__$1);

return statearr_55434;
})();
if(cljs.core.truth_(inst_55393__$1)){
var statearr_55435_55456 = state_55425__$1;
(statearr_55435_55456[(1)] = (6));

} else {
var statearr_55436_55457 = state_55425__$1;
(statearr_55436_55457[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (11))){
var inst_55420 = (state_55425[(2)]);
var _ = (function (){var statearr_55438 = state_55425;
(statearr_55438[(4)] = cljs.core.rest.call(null,(state_55425[(4)])));

return statearr_55438;
})();
var state_55425__$1 = state_55425;
var statearr_55439_55458 = state_55425__$1;
(statearr_55439_55458[(2)] = inst_55420);

(statearr_55439_55458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (9))){
var inst_55403 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_55425__$1 = state_55425;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55425__$1,(12),inst_55403);
} else {
if((state_val_55426 === (5))){
var _ = (function (){var statearr_55440 = state_55425;
(statearr_55440[(4)] = cljs.core.rest.call(null,(state_55425[(4)])));

return statearr_55440;
})();
var state_55425__$1 = state_55425;
var ex55437 = (state_55425__$1[(2)]);
var statearr_55441_55459 = state_55425__$1;
(statearr_55441_55459[(5)] = ex55437);


if((ex55437 instanceof Error)){
var statearr_55442_55460 = state_55425__$1;
(statearr_55442_55460[(1)] = (4));

(statearr_55442_55460[(5)] = null);

} else {
throw ex55437;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (10))){
var inst_55418 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55425__$1 = state_55425;
var statearr_55443_55461 = state_55425__$1;
(statearr_55443_55461[(2)] = inst_55418);

(statearr_55443_55461[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55426 === (8))){
var inst_55398 = (state_55425[(2)]);
var state_55425__$1 = state_55425;
if(cljs.core.truth_(inst_55398)){
var statearr_55444_55462 = state_55425__$1;
(statearr_55444_55462[(1)] = (9));

} else {
var statearr_55445_55463 = state_55425__$1;
(statearr_55445_55463[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0 = (function (){
var statearr_55446 = [null,null,null,null,null,null,null,null,null];
(statearr_55446[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__);

(statearr_55446[(1)] = (1));

return statearr_55446;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1 = (function (state_55425){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55425);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55447){var ex__2749__auto__ = e55447;
var statearr_55448_55464 = state_55425;
(statearr_55448_55464[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55425[(4)]))){
var statearr_55449_55465 = state_55425;
(statearr_55449_55465[(1)] = cljs.core.first.call(null,(state_55425[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55466 = state_55425;
state_55425 = G__55466;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__ = function(state_55425){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1.call(this,state_55425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55450 = f__2769__auto__.call(null);
(statearr_55450[(6)] = c__2768__auto__);

return statearr_55450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55535){
var state_val_55536 = (state_55535[(1)]);
if((state_val_55536 === (7))){
var state_55535__$1 = state_55535;
var statearr_55537_55575 = state_55535__$1;
(statearr_55537_55575[(2)] = subject);

(statearr_55537_55575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (20))){
var inst_55503 = (state_55535[(7)]);
var inst_55491 = (state_55535[(8)]);
var inst_55506 = fluree.db.dbfunctions.internal.follow_subject.call(null,_QMARK_ctx,inst_55503,inst_55491);
var state_55535__$1 = state_55535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55535__$1,(23),inst_55506);
} else {
if((state_val_55536 === (1))){
var state_55535__$1 = state_55535;
var statearr_55538_55576 = state_55535__$1;
(statearr_55538_55576[(2)] = null);

(statearr_55538_55576[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (4))){
var inst_55467 = (state_55535[(2)]);
var state_55535__$1 = state_55535;
var statearr_55539_55577 = state_55535__$1;
(statearr_55539_55577[(2)] = inst_55467);

(statearr_55539_55577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (15))){
var inst_55483 = (state_55535[(9)]);
var state_55535__$1 = state_55535;
var statearr_55540_55578 = state_55535__$1;
(statearr_55540_55578[(2)] = inst_55483);

(statearr_55540_55578[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (21))){
var inst_55503 = (state_55535[(7)]);
var inst_55491 = (state_55535[(8)]);
var inst_55511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55512 = fluree.db.dbfunctions.internal.get_all.call(null,inst_55503,inst_55491);
var inst_55513 = cljs.core.count.call(null,inst_55491);
var inst_55514 = ((9) + inst_55513);
var inst_55515 = [inst_55512,inst_55514];
var inst_55516 = (new cljs.core.PersistentVector(null,2,(5),inst_55511,inst_55515,null));
var state_55535__$1 = state_55535;
var statearr_55541_55579 = state_55535__$1;
(statearr_55541_55579[(2)] = inst_55516);

(statearr_55541_55579[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (13))){
var inst_55487 = (state_55535[(2)]);
var inst_55488 = fluree.db.util.async.throw_err.call(null,inst_55487);
var state_55535__$1 = state_55535;
var statearr_55542_55580 = state_55535__$1;
(statearr_55542_55580[(2)] = inst_55488);

(statearr_55542_55580[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (22))){
var inst_55483 = (state_55535[(9)]);
var inst_55491 = (state_55535[(8)]);
var inst_55518 = (state_55535[(2)]);
var inst_55519 = cljs.core.nth.call(null,inst_55518,(0),null);
var inst_55520 = cljs.core.nth.call(null,inst_55518,(1),null);
var inst_55521 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55522 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55524 = [inst_55483,inst_55491];
var inst_55525 = (new cljs.core.PersistentVector(null,2,(5),inst_55523,inst_55524,null));
var inst_55526 = ["get-all",inst_55525,inst_55519];
var inst_55527 = cljs.core.PersistentHashMap.fromArrays(inst_55522,inst_55526);
var inst_55528 = [inst_55527,inst_55520];
var inst_55529 = (new cljs.core.PersistentVector(null,2,(5),inst_55521,inst_55528,null));
var inst_55530 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55529);
var _ = (function (){var statearr_55543 = state_55535;
(statearr_55543[(4)] = cljs.core.rest.call(null,(state_55535[(4)])));

return statearr_55543;
})();
var state_55535__$1 = (function (){var statearr_55544 = state_55535;
(statearr_55544[(10)] = inst_55530);

return statearr_55544;
})();
var statearr_55545_55581 = state_55535__$1;
(statearr_55545_55581[(2)] = inst_55519);

(statearr_55545_55581[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (6))){
var state_55535__$1 = state_55535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55535__$1,(9),subject);
} else {
if((state_val_55536 === (17))){
var inst_55483 = (state_55535[(9)]);
var inst_55497 = cljs.core.first.call(null,inst_55483);
var state_55535__$1 = state_55535;
var statearr_55546_55582 = state_55535__$1;
(statearr_55546_55582[(2)] = inst_55497);

(statearr_55546_55582[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (3))){
var inst_55533 = (state_55535[(2)]);
var state_55535__$1 = state_55535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55535__$1,inst_55533);
} else {
if((state_val_55536 === (12))){
var inst_55483 = (state_55535[(9)]);
var inst_55491 = (state_55535[(2)]);
var inst_55492 = cljs.core.vector_QMARK_.call(null,inst_55483);
var state_55535__$1 = (function (){var statearr_55547 = state_55535;
(statearr_55547[(8)] = inst_55491);

return statearr_55547;
})();
if(inst_55492){
var statearr_55548_55583 = state_55535__$1;
(statearr_55548_55583[(1)] = (14));

} else {
var statearr_55549_55584 = state_55535__$1;
(statearr_55549_55584[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (2))){
var _ = (function (){var statearr_55550 = state_55535;
(statearr_55550[(4)] = cljs.core.cons.call(null,(5),(state_55535[(4)])));

return statearr_55550;
})();
var inst_55476 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55535__$1 = state_55535;
if(inst_55476){
var statearr_55551_55585 = state_55535__$1;
(statearr_55551_55585[(1)] = (6));

} else {
var statearr_55552_55586 = state_55535__$1;
(statearr_55552_55586[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (23))){
var inst_55508 = (state_55535[(2)]);
var inst_55509 = fluree.db.util.async.throw_err.call(null,inst_55508);
var state_55535__$1 = state_55535;
var statearr_55553_55587 = state_55535__$1;
(statearr_55553_55587[(2)] = inst_55509);

(statearr_55553_55587[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (19))){
var inst_55500 = (state_55535[(2)]);
var state_55535__$1 = state_55535;
var statearr_55554_55588 = state_55535__$1;
(statearr_55554_55588[(2)] = inst_55500);

(statearr_55554_55588[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (11))){
var state_55535__$1 = state_55535;
var statearr_55556_55589 = state_55535__$1;
(statearr_55556_55589[(2)] = path);

(statearr_55556_55589[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (9))){
var inst_55479 = (state_55535[(2)]);
var inst_55480 = fluree.db.util.async.throw_err.call(null,inst_55479);
var state_55535__$1 = state_55535;
var statearr_55557_55590 = state_55535__$1;
(statearr_55557_55590[(2)] = inst_55480);

(statearr_55557_55590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (5))){
var _ = (function (){var statearr_55558 = state_55535;
(statearr_55558[(4)] = cljs.core.rest.call(null,(state_55535[(4)])));

return statearr_55558;
})();
var state_55535__$1 = state_55535;
var ex55555 = (state_55535__$1[(2)]);
var statearr_55559_55591 = state_55535__$1;
(statearr_55559_55591[(5)] = ex55555);


if((ex55555 instanceof Error)){
var statearr_55560_55592 = state_55535__$1;
(statearr_55560_55592[(1)] = (4));

(statearr_55560_55592[(5)] = null);

} else {
throw ex55555;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (14))){
var inst_55483 = (state_55535[(9)]);
var inst_55494 = cljs.core.count.call(null,inst_55483);
var inst_55495 = cljs.core._EQ_.call(null,(1),inst_55494);
var state_55535__$1 = state_55535;
if(inst_55495){
var statearr_55561_55593 = state_55535__$1;
(statearr_55561_55593[(1)] = (17));

} else {
var statearr_55562_55594 = state_55535__$1;
(statearr_55562_55594[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (16))){
var inst_55503 = (state_55535[(7)]);
var inst_55503__$1 = (state_55535[(2)]);
var inst_55504 = cljs.core.int_QMARK_.call(null,inst_55503__$1);
var state_55535__$1 = (function (){var statearr_55563 = state_55535;
(statearr_55563[(7)] = inst_55503__$1);

return statearr_55563;
})();
if(inst_55504){
var statearr_55564_55595 = state_55535__$1;
(statearr_55564_55595[(1)] = (20));

} else {
var statearr_55565_55596 = state_55535__$1;
(statearr_55565_55596[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (10))){
var state_55535__$1 = state_55535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55535__$1,(13),path);
} else {
if((state_val_55536 === (18))){
var inst_55483 = (state_55535[(9)]);
var state_55535__$1 = state_55535;
var statearr_55566_55597 = state_55535__$1;
(statearr_55566_55597[(2)] = inst_55483);

(statearr_55566_55597[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55536 === (8))){
var inst_55483 = (state_55535[(2)]);
var inst_55484 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55535__$1 = (function (){var statearr_55567 = state_55535;
(statearr_55567[(9)] = inst_55483);

return statearr_55567;
})();
if(inst_55484){
var statearr_55568_55598 = state_55535__$1;
(statearr_55568_55598[(1)] = (10));

} else {
var statearr_55569_55599 = state_55535__$1;
(statearr_55569_55599[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0 = (function (){
var statearr_55570 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55570[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__);

(statearr_55570[(1)] = (1));

return statearr_55570;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1 = (function (state_55535){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55571){var ex__2749__auto__ = e55571;
var statearr_55572_55600 = state_55535;
(statearr_55572_55600[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55535[(4)]))){
var statearr_55573_55601 = state_55535;
(statearr_55573_55601[(1)] = cljs.core.first.call(null,(state_55535[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55602 = state_55535;
state_55535 = G__55602;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__ = function(state_55535){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1.call(this,state_55535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55574 = f__2769__auto__.call(null);
(statearr_55574[(6)] = c__2768__auto__);

return statearr_55574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55641){
var state_val_55642 = (state_55641[(1)]);
if((state_val_55642 === (7))){
var state_55641__$1 = state_55641;
var statearr_55643_55667 = state_55641__$1;
(statearr_55643_55667[(2)] = subject);

(statearr_55643_55667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (1))){
var state_55641__$1 = state_55641;
var statearr_55644_55668 = state_55641__$1;
(statearr_55644_55668[(2)] = null);

(statearr_55644_55668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (4))){
var inst_55603 = (state_55641[(2)]);
var state_55641__$1 = state_55641;
var statearr_55645_55669 = state_55641__$1;
(statearr_55645_55669[(2)] = inst_55603);

(statearr_55645_55669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (13))){
var inst_55620 = (state_55641[(2)]);
var inst_55621 = fluree.db.util.async.throw_err.call(null,inst_55620);
var state_55641__$1 = state_55641;
var statearr_55646_55670 = state_55641__$1;
(statearr_55646_55670[(2)] = inst_55621);

(statearr_55646_55670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (6))){
var state_55641__$1 = state_55641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55641__$1,(9),subject);
} else {
if((state_val_55642 === (3))){
var inst_55639 = (state_55641[(2)]);
var state_55641__$1 = state_55641;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55641__$1,inst_55639);
} else {
if((state_val_55642 === (12))){
var inst_55616 = (state_55641[(7)]);
var inst_55624 = (state_55641[(2)]);
var inst_55625 = fluree.db.dbfunctions.internal.get_in.call(null,inst_55616,inst_55624);
var inst_55626 = cljs.core.count.call(null,inst_55624);
var inst_55627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55628 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55630 = [inst_55616,inst_55624];
var inst_55631 = (new cljs.core.PersistentVector(null,2,(5),inst_55629,inst_55630,null));
var inst_55632 = ["get-in",inst_55631,inst_55625];
var inst_55633 = cljs.core.PersistentHashMap.fromArrays(inst_55628,inst_55632);
var inst_55634 = [inst_55633,inst_55626];
var inst_55635 = (new cljs.core.PersistentVector(null,2,(5),inst_55627,inst_55634,null));
var inst_55636 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55635);
var _ = (function (){var statearr_55647 = state_55641;
(statearr_55647[(4)] = cljs.core.rest.call(null,(state_55641[(4)])));

return statearr_55647;
})();
var state_55641__$1 = (function (){var statearr_55648 = state_55641;
(statearr_55648[(8)] = inst_55636);

return statearr_55648;
})();
var statearr_55649_55671 = state_55641__$1;
(statearr_55649_55671[(2)] = inst_55625);

(statearr_55649_55671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (2))){
var _ = (function (){var statearr_55650 = state_55641;
(statearr_55650[(4)] = cljs.core.cons.call(null,(5),(state_55641[(4)])));

return statearr_55650;
})();
var inst_55609 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55641__$1 = state_55641;
if(inst_55609){
var statearr_55651_55672 = state_55641__$1;
(statearr_55651_55672[(1)] = (6));

} else {
var statearr_55652_55673 = state_55641__$1;
(statearr_55652_55673[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (11))){
var state_55641__$1 = state_55641;
var statearr_55654_55674 = state_55641__$1;
(statearr_55654_55674[(2)] = path);

(statearr_55654_55674[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (9))){
var inst_55612 = (state_55641[(2)]);
var inst_55613 = fluree.db.util.async.throw_err.call(null,inst_55612);
var state_55641__$1 = state_55641;
var statearr_55655_55675 = state_55641__$1;
(statearr_55655_55675[(2)] = inst_55613);

(statearr_55655_55675[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (5))){
var _ = (function (){var statearr_55656 = state_55641;
(statearr_55656[(4)] = cljs.core.rest.call(null,(state_55641[(4)])));

return statearr_55656;
})();
var state_55641__$1 = state_55641;
var ex55653 = (state_55641__$1[(2)]);
var statearr_55657_55676 = state_55641__$1;
(statearr_55657_55676[(5)] = ex55653);


if((ex55653 instanceof Error)){
var statearr_55658_55677 = state_55641__$1;
(statearr_55658_55677[(1)] = (4));

(statearr_55658_55677[(5)] = null);

} else {
throw ex55653;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55642 === (10))){
var state_55641__$1 = state_55641;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55641__$1,(13),path);
} else {
if((state_val_55642 === (8))){
var inst_55616 = (state_55641[(2)]);
var inst_55617 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55641__$1 = (function (){var statearr_55659 = state_55641;
(statearr_55659[(7)] = inst_55616);

return statearr_55659;
})();
if(inst_55617){
var statearr_55660_55678 = state_55641__$1;
(statearr_55660_55678[(1)] = (10));

} else {
var statearr_55661_55679 = state_55641__$1;
(statearr_55661_55679[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0 = (function (){
var statearr_55662 = [null,null,null,null,null,null,null,null,null];
(statearr_55662[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__);

(statearr_55662[(1)] = (1));

return statearr_55662;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1 = (function (state_55641){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55641);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55663){var ex__2749__auto__ = e55663;
var statearr_55664_55680 = state_55641;
(statearr_55664_55680[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55641[(4)]))){
var statearr_55665_55681 = state_55641;
(statearr_55665_55681[(1)] = cljs.core.first.call(null,(state_55641[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55682 = state_55641;
state_55641 = G__55682;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__ = function(state_55641){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1.call(this,state_55641);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55666 = f__2769__auto__.call(null);
(statearr_55666[(6)] = c__2768__auto__);

return statearr_55666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__55683,key_or_ks){
var map__55684 = p__55683;
var map__55684__$1 = cljs.core.__destructure_map.call(null,map__55684);
var _QMARK_ctx = map__55684__$1;
var db = cljs.core.get.call(null,map__55684__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_.call(null,key_or_ks)){
return cljs.core.get_in.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.call(null,new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55729){
var state_val_55730 = (state_55729[(1)]);
if((state_val_55730 === (7))){
var state_55729__$1 = state_55729;
var statearr_55731_55760 = state_55729__$1;
(statearr_55731_55760[(2)] = coll);

(statearr_55731_55760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (1))){
var state_55729__$1 = state_55729;
var statearr_55732_55761 = state_55729__$1;
(statearr_55732_55761[(2)] = null);

(statearr_55732_55761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (4))){
var inst_55685 = (state_55729[(2)]);
var state_55729__$1 = state_55729;
var statearr_55733_55762 = state_55729__$1;
(statearr_55733_55762[(2)] = inst_55685);

(statearr_55733_55762[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (15))){
var inst_55705 = (state_55729[(7)]);
var inst_55713 = (state_55729[(2)]);
var inst_55714 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_55705,inst_55713);
var inst_55715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55716 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55718 = [inst_55705,inst_55713];
var inst_55719 = (new cljs.core.PersistentVector(null,2,(5),inst_55717,inst_55718,null));
var inst_55720 = ["contains?",inst_55719,inst_55714];
var inst_55721 = cljs.core.PersistentHashMap.fromArrays(inst_55716,inst_55720);
var inst_55722 = [inst_55721,(10)];
var inst_55723 = (new cljs.core.PersistentVector(null,2,(5),inst_55715,inst_55722,null));
var inst_55724 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55723);
var _ = (function (){var statearr_55734 = state_55729;
(statearr_55734[(4)] = cljs.core.rest.call(null,(state_55729[(4)])));

return statearr_55734;
})();
var state_55729__$1 = (function (){var statearr_55735 = state_55729;
(statearr_55735[(8)] = inst_55724);

return statearr_55735;
})();
var statearr_55736_55763 = state_55729__$1;
(statearr_55736_55763[(2)] = inst_55714);

(statearr_55736_55763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (13))){
var state_55729__$1 = state_55729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55729__$1,(16),key);
} else {
if((state_val_55730 === (6))){
var state_55729__$1 = state_55729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55729__$1,(9),coll);
} else {
if((state_val_55730 === (3))){
var inst_55727 = (state_55729[(2)]);
var state_55729__$1 = state_55729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55729__$1,inst_55727);
} else {
if((state_val_55730 === (12))){
var inst_55705 = (state_55729[(2)]);
var inst_55706 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_55729__$1 = (function (){var statearr_55737 = state_55729;
(statearr_55737[(7)] = inst_55705);

return statearr_55737;
})();
if(inst_55706){
var statearr_55738_55764 = state_55729__$1;
(statearr_55738_55764[(1)] = (13));

} else {
var statearr_55739_55765 = state_55729__$1;
(statearr_55739_55765[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (2))){
var _ = (function (){var statearr_55740 = state_55729;
(statearr_55740[(4)] = cljs.core.cons.call(null,(5),(state_55729[(4)])));

return statearr_55740;
})();
var inst_55691 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55729__$1 = state_55729;
if(inst_55691){
var statearr_55741_55766 = state_55729__$1;
(statearr_55741_55766[(1)] = (6));

} else {
var statearr_55742_55767 = state_55729__$1;
(statearr_55742_55767[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (11))){
var inst_55698 = (state_55729[(9)]);
var inst_55702 = cljs.core.flatten.call(null,inst_55698);
var inst_55703 = cljs.core.set.call(null,inst_55702);
var state_55729__$1 = state_55729;
var statearr_55744_55768 = state_55729__$1;
(statearr_55744_55768[(2)] = inst_55703);

(statearr_55744_55768[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (9))){
var inst_55694 = (state_55729[(2)]);
var inst_55695 = fluree.db.util.async.throw_err.call(null,inst_55694);
var state_55729__$1 = state_55729;
var statearr_55745_55769 = state_55729__$1;
(statearr_55745_55769[(2)] = inst_55695);

(statearr_55745_55769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (5))){
var _ = (function (){var statearr_55746 = state_55729;
(statearr_55746[(4)] = cljs.core.rest.call(null,(state_55729[(4)])));

return statearr_55746;
})();
var state_55729__$1 = state_55729;
var ex55743 = (state_55729__$1[(2)]);
var statearr_55747_55770 = state_55729__$1;
(statearr_55747_55770[(5)] = ex55743);


if((ex55743 instanceof Error)){
var statearr_55748_55771 = state_55729__$1;
(statearr_55748_55771[(1)] = (4));

(statearr_55748_55771[(5)] = null);

} else {
throw ex55743;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (14))){
var state_55729__$1 = state_55729;
var statearr_55749_55772 = state_55729__$1;
(statearr_55749_55772[(2)] = key);

(statearr_55749_55772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (16))){
var inst_55709 = (state_55729[(2)]);
var inst_55710 = fluree.db.util.async.throw_err.call(null,inst_55709);
var state_55729__$1 = state_55729;
var statearr_55750_55773 = state_55729__$1;
(statearr_55750_55773[(2)] = inst_55710);

(statearr_55750_55773[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (10))){
var inst_55698 = (state_55729[(9)]);
var state_55729__$1 = state_55729;
var statearr_55751_55774 = state_55729__$1;
(statearr_55751_55774[(2)] = inst_55698);

(statearr_55751_55774[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55730 === (8))){
var inst_55698 = (state_55729[(9)]);
var inst_55698__$1 = (state_55729[(2)]);
var inst_55699 = cljs.core.set_QMARK_.call(null,inst_55698__$1);
var state_55729__$1 = (function (){var statearr_55752 = state_55729;
(statearr_55752[(9)] = inst_55698__$1);

return statearr_55752;
})();
if(inst_55699){
var statearr_55753_55775 = state_55729__$1;
(statearr_55753_55775[(1)] = (10));

} else {
var statearr_55754_55776 = state_55729__$1;
(statearr_55754_55776[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_55755 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55755[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__);

(statearr_55755[(1)] = (1));

return statearr_55755;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1 = (function (state_55729){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55756){var ex__2749__auto__ = e55756;
var statearr_55757_55777 = state_55729;
(statearr_55757_55777[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55729[(4)]))){
var statearr_55758_55778 = state_55729;
(statearr_55758_55778[(1)] = cljs.core.first.call(null,(state_55729[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55779 = state_55729;
state_55729 = G__55779;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__ = function(state_55729){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1.call(this,state_55729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55759 = f__2769__auto__.call(null);
(statearr_55759[(6)] = c__2768__auto__);

return statearr_55759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55851 = arguments.length;
var i__5770__auto___55852 = (0);
while(true){
if((i__5770__auto___55852 < len__5769__auto___55851)){
args__5775__auto__.push((arguments[i__5770__auto___55852]));

var G__55853 = (i__5770__auto___55852 + (1));
i__5770__auto___55852 = G__55853;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55825){
var state_val_55826 = (state_55825[(1)]);
if((state_val_55826 === (7))){
var inst_55791 = (state_55825[(7)]);
var inst_55795 = cljs.core.first.call(null,inst_55791);
var inst_55796 = cljs.core.coll_QMARK_.call(null,inst_55795);
var state_55825__$1 = state_55825;
var statearr_55827_55854 = state_55825__$1;
(statearr_55827_55854[(2)] = inst_55796);

(statearr_55827_55854[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (1))){
var state_55825__$1 = state_55825;
var statearr_55828_55855 = state_55825__$1;
(statearr_55828_55855[(2)] = null);

(statearr_55828_55855[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (4))){
var inst_55782 = (state_55825[(2)]);
var state_55825__$1 = state_55825;
var statearr_55829_55856 = state_55825__$1;
(statearr_55829_55856[(2)] = inst_55782);

(statearr_55829_55856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (6))){
var inst_55793 = (state_55825[(8)]);
var inst_55791 = (state_55825[(7)]);
var inst_55790 = (state_55825[(2)]);
var inst_55791__$1 = fluree.db.util.async.throw_err.call(null,inst_55790);
var inst_55792 = cljs.core.count.call(null,inst_55791__$1);
var inst_55793__$1 = cljs.core._EQ_.call(null,(1),inst_55792);
var state_55825__$1 = (function (){var statearr_55830 = state_55825;
(statearr_55830[(8)] = inst_55793__$1);

(statearr_55830[(7)] = inst_55791__$1);

return statearr_55830;
})();
if(inst_55793__$1){
var statearr_55831_55857 = state_55825__$1;
(statearr_55831_55857[(1)] = (7));

} else {
var statearr_55832_55858 = state_55825__$1;
(statearr_55832_55858[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (3))){
var inst_55823 = (state_55825[(2)]);
var state_55825__$1 = state_55825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55825__$1,inst_55823);
} else {
if((state_val_55826 === (12))){
var inst_55804 = (state_55825[(2)]);
var inst_55805 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_55804);
var inst_55806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55807 = [inst_55804];
var inst_55808 = (new cljs.core.PersistentVector(null,1,(5),inst_55806,inst_55807,null));
var inst_55809 = cljs.core.count.call(null,inst_55808);
var inst_55810 = ((9) + inst_55809);
var inst_55811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55812 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55814 = [inst_55804];
var inst_55815 = (new cljs.core.PersistentVector(null,1,(5),inst_55813,inst_55814,null));
var inst_55816 = ["hash-set",inst_55815,inst_55805];
var inst_55817 = cljs.core.PersistentHashMap.fromArrays(inst_55812,inst_55816);
var inst_55818 = [inst_55817,inst_55810];
var inst_55819 = (new cljs.core.PersistentVector(null,2,(5),inst_55811,inst_55818,null));
var inst_55820 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55819);
var _ = (function (){var statearr_55833 = state_55825;
(statearr_55833[(4)] = cljs.core.rest.call(null,(state_55825[(4)])));

return statearr_55833;
})();
var state_55825__$1 = (function (){var statearr_55834 = state_55825;
(statearr_55834[(9)] = inst_55820);

return statearr_55834;
})();
var statearr_55835_55859 = state_55825__$1;
(statearr_55835_55859[(2)] = inst_55805);

(statearr_55835_55859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (2))){
var _ = (function (){var statearr_55836 = state_55825;
(statearr_55836[(4)] = cljs.core.cons.call(null,(5),(state_55825[(4)])));

return statearr_55836;
})();
var inst_55788 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55825__$1 = state_55825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55825__$1,(6),inst_55788);
} else {
if((state_val_55826 === (11))){
var inst_55791 = (state_55825[(7)]);
var state_55825__$1 = state_55825;
var statearr_55838_55860 = state_55825__$1;
(statearr_55838_55860[(2)] = inst_55791);

(statearr_55838_55860[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (9))){
var inst_55799 = (state_55825[(2)]);
var state_55825__$1 = state_55825;
if(cljs.core.truth_(inst_55799)){
var statearr_55839_55861 = state_55825__$1;
(statearr_55839_55861[(1)] = (10));

} else {
var statearr_55840_55862 = state_55825__$1;
(statearr_55840_55862[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (5))){
var _ = (function (){var statearr_55841 = state_55825;
(statearr_55841[(4)] = cljs.core.rest.call(null,(state_55825[(4)])));

return statearr_55841;
})();
var state_55825__$1 = state_55825;
var ex55837 = (state_55825__$1[(2)]);
var statearr_55842_55863 = state_55825__$1;
(statearr_55842_55863[(5)] = ex55837);


if((ex55837 instanceof Error)){
var statearr_55843_55864 = state_55825__$1;
(statearr_55843_55864[(1)] = (4));

(statearr_55843_55864[(5)] = null);

} else {
throw ex55837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (10))){
var inst_55791 = (state_55825[(7)]);
var inst_55801 = cljs.core.first.call(null,inst_55791);
var state_55825__$1 = state_55825;
var statearr_55844_55865 = state_55825__$1;
(statearr_55844_55865[(2)] = inst_55801);

(statearr_55844_55865[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55826 === (8))){
var inst_55793 = (state_55825[(8)]);
var state_55825__$1 = state_55825;
var statearr_55845_55866 = state_55825__$1;
(statearr_55845_55866[(2)] = inst_55793);

(statearr_55845_55866[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55846 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55846[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55846[(1)] = (1));

return statearr_55846;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55825){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55847){var ex__2749__auto__ = e55847;
var statearr_55848_55867 = state_55825;
(statearr_55848_55867[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55825[(4)]))){
var statearr_55849_55868 = state_55825;
(statearr_55849_55868[(1)] = cljs.core.first.call(null,(state_55825[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55869 = state_55825;
state_55825 = G__55869;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55825){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55850 = f__2769__auto__.call(null);
(statearr_55850[(6)] = c__2768__auto__);

return statearr_55850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55780){
var G__55781 = cljs.core.first.call(null,seq55780);
var seq55780__$1 = cljs.core.next.call(null,seq55780);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55781,seq55780__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55919 = arguments.length;
var i__5770__auto___55920 = (0);
while(true){
if((i__5770__auto___55920 < len__5769__auto___55919)){
args__5775__auto__.push((arguments[i__5770__auto___55920]));

var G__55921 = (i__5770__auto___55920 + (1));
i__5770__auto___55920 = G__55921;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55902){
var state_val_55903 = (state_55902[(1)]);
if((state_val_55903 === (1))){
var state_55902__$1 = state_55902;
var statearr_55904_55922 = state_55902__$1;
(statearr_55904_55922[(2)] = null);

(statearr_55904_55922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55903 === (2))){
var _ = (function (){var statearr_55905 = state_55902;
(statearr_55905[(4)] = cljs.core.cons.call(null,(5),(state_55902[(4)])));

return statearr_55905;
})();
var inst_55878 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55902__$1 = state_55902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55902__$1,(6),inst_55878);
} else {
if((state_val_55903 === (3))){
var inst_55900 = (state_55902[(2)]);
var state_55902__$1 = state_55902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55902__$1,inst_55900);
} else {
if((state_val_55903 === (4))){
var inst_55872 = (state_55902[(2)]);
var state_55902__$1 = state_55902;
var statearr_55907_55923 = state_55902__$1;
(statearr_55907_55923[(2)] = inst_55872);

(statearr_55907_55923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55903 === (5))){
var _ = (function (){var statearr_55908 = state_55902;
(statearr_55908[(4)] = cljs.core.rest.call(null,(state_55902[(4)])));

return statearr_55908;
})();
var state_55902__$1 = state_55902;
var ex55906 = (state_55902__$1[(2)]);
var statearr_55909_55924 = state_55902__$1;
(statearr_55909_55924[(5)] = ex55906);


if((ex55906 instanceof Error)){
var statearr_55910_55925 = state_55902__$1;
(statearr_55910_55925[(1)] = (4));

(statearr_55910_55925[(5)] = null);

} else {
throw ex55906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55903 === (6))){
var inst_55880 = (state_55902[(2)]);
var inst_55881 = fluree.db.util.async.throw_err.call(null,inst_55880);
var inst_55882 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_55881);
var inst_55883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55884 = [inst_55881];
var inst_55885 = (new cljs.core.PersistentVector(null,1,(5),inst_55883,inst_55884,null));
var inst_55886 = cljs.core.count.call(null,inst_55885);
var inst_55887 = ((9) + inst_55886);
var inst_55888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55891 = [inst_55881];
var inst_55892 = (new cljs.core.PersistentVector(null,1,(5),inst_55890,inst_55891,null));
var inst_55893 = ["==",inst_55892,inst_55882];
var inst_55894 = cljs.core.PersistentHashMap.fromArrays(inst_55889,inst_55893);
var inst_55895 = [inst_55894,inst_55887];
var inst_55896 = (new cljs.core.PersistentVector(null,2,(5),inst_55888,inst_55895,null));
var inst_55897 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55896);
var _ = (function (){var statearr_55911 = state_55902;
(statearr_55911[(4)] = cljs.core.rest.call(null,(state_55902[(4)])));

return statearr_55911;
})();
var state_55902__$1 = (function (){var statearr_55912 = state_55902;
(statearr_55912[(7)] = inst_55897);

return statearr_55912;
})();
var statearr_55913_55926 = state_55902__$1;
(statearr_55913_55926[(2)] = inst_55882);

(statearr_55913_55926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55914 = [null,null,null,null,null,null,null,null];
(statearr_55914[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55914[(1)] = (1));

return statearr_55914;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55902){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55915){var ex__2749__auto__ = e55915;
var statearr_55916_55927 = state_55902;
(statearr_55916_55927[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55902[(4)]))){
var statearr_55917_55928 = state_55902;
(statearr_55917_55928[(1)] = cljs.core.first.call(null,(state_55902[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55929 = state_55902;
state_55902 = G__55929;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55918 = f__2769__auto__.call(null);
(statearr_55918[(6)] = c__2768__auto__);

return statearr_55918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55870){
var G__55871 = cljs.core.first.call(null,seq55870);
var seq55870__$1 = cljs.core.next.call(null,seq55870);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55871,seq55870__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55979 = arguments.length;
var i__5770__auto___55980 = (0);
while(true){
if((i__5770__auto___55980 < len__5769__auto___55979)){
args__5775__auto__.push((arguments[i__5770__auto___55980]));

var G__55981 = (i__5770__auto___55980 + (1));
i__5770__auto___55980 = G__55981;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_55962){
var state_val_55963 = (state_55962[(1)]);
if((state_val_55963 === (1))){
var state_55962__$1 = state_55962;
var statearr_55964_55982 = state_55962__$1;
(statearr_55964_55982[(2)] = null);

(statearr_55964_55982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (2))){
var _ = (function (){var statearr_55965 = state_55962;
(statearr_55965[(4)] = cljs.core.cons.call(null,(5),(state_55962[(4)])));

return statearr_55965;
})();
var inst_55938 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55962__$1 = state_55962;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55962__$1,(6),inst_55938);
} else {
if((state_val_55963 === (3))){
var inst_55960 = (state_55962[(2)]);
var state_55962__$1 = state_55962;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55962__$1,inst_55960);
} else {
if((state_val_55963 === (4))){
var inst_55932 = (state_55962[(2)]);
var state_55962__$1 = state_55962;
var statearr_55967_55983 = state_55962__$1;
(statearr_55967_55983[(2)] = inst_55932);

(statearr_55967_55983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (5))){
var _ = (function (){var statearr_55968 = state_55962;
(statearr_55968[(4)] = cljs.core.rest.call(null,(state_55962[(4)])));

return statearr_55968;
})();
var state_55962__$1 = state_55962;
var ex55966 = (state_55962__$1[(2)]);
var statearr_55969_55984 = state_55962__$1;
(statearr_55969_55984[(5)] = ex55966);


if((ex55966 instanceof Error)){
var statearr_55970_55985 = state_55962__$1;
(statearr_55970_55985[(1)] = (4));

(statearr_55970_55985[(5)] = null);

} else {
throw ex55966;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55963 === (6))){
var inst_55940 = (state_55962[(2)]);
var inst_55941 = fluree.db.util.async.throw_err.call(null,inst_55940);
var inst_55942 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_55941);
var inst_55943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55944 = [inst_55941];
var inst_55945 = (new cljs.core.PersistentVector(null,1,(5),inst_55943,inst_55944,null));
var inst_55946 = cljs.core.count.call(null,inst_55945);
var inst_55947 = ((9) + inst_55946);
var inst_55948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55949 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55951 = [inst_55941];
var inst_55952 = (new cljs.core.PersistentVector(null,1,(5),inst_55950,inst_55951,null));
var inst_55953 = [">",inst_55952,inst_55942];
var inst_55954 = cljs.core.PersistentHashMap.fromArrays(inst_55949,inst_55953);
var inst_55955 = [inst_55954,inst_55947];
var inst_55956 = (new cljs.core.PersistentVector(null,2,(5),inst_55948,inst_55955,null));
var inst_55957 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55956);
var _ = (function (){var statearr_55971 = state_55962;
(statearr_55971[(4)] = cljs.core.rest.call(null,(state_55962[(4)])));

return statearr_55971;
})();
var state_55962__$1 = (function (){var statearr_55972 = state_55962;
(statearr_55972[(7)] = inst_55957);

return statearr_55972;
})();
var statearr_55973_55986 = state_55962__$1;
(statearr_55973_55986[(2)] = inst_55942);

(statearr_55973_55986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_55974 = [null,null,null,null,null,null,null,null];
(statearr_55974[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_55974[(1)] = (1));

return statearr_55974;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_55962){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_55962);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e55975){var ex__2749__auto__ = e55975;
var statearr_55976_55987 = state_55962;
(statearr_55976_55987[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_55962[(4)]))){
var statearr_55977_55988 = state_55962;
(statearr_55977_55988[(1)] = cljs.core.first.call(null,(state_55962[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55989 = state_55962;
state_55962 = G__55989;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_55962){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_55962);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_55978 = f__2769__auto__.call(null);
(statearr_55978[(6)] = c__2768__auto__);

return statearr_55978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55930){
var G__55931 = cljs.core.first.call(null,seq55930);
var seq55930__$1 = cljs.core.next.call(null,seq55930);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55931,seq55930__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56039 = arguments.length;
var i__5770__auto___56040 = (0);
while(true){
if((i__5770__auto___56040 < len__5769__auto___56039)){
args__5775__auto__.push((arguments[i__5770__auto___56040]));

var G__56041 = (i__5770__auto___56040 + (1));
i__5770__auto___56040 = G__56041;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56022){
var state_val_56023 = (state_56022[(1)]);
if((state_val_56023 === (1))){
var state_56022__$1 = state_56022;
var statearr_56024_56042 = state_56022__$1;
(statearr_56024_56042[(2)] = null);

(statearr_56024_56042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56023 === (2))){
var _ = (function (){var statearr_56025 = state_56022;
(statearr_56025[(4)] = cljs.core.cons.call(null,(5),(state_56022[(4)])));

return statearr_56025;
})();
var inst_55998 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56022__$1 = state_56022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56022__$1,(6),inst_55998);
} else {
if((state_val_56023 === (3))){
var inst_56020 = (state_56022[(2)]);
var state_56022__$1 = state_56022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56022__$1,inst_56020);
} else {
if((state_val_56023 === (4))){
var inst_55992 = (state_56022[(2)]);
var state_56022__$1 = state_56022;
var statearr_56027_56043 = state_56022__$1;
(statearr_56027_56043[(2)] = inst_55992);

(statearr_56027_56043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56023 === (5))){
var _ = (function (){var statearr_56028 = state_56022;
(statearr_56028[(4)] = cljs.core.rest.call(null,(state_56022[(4)])));

return statearr_56028;
})();
var state_56022__$1 = state_56022;
var ex56026 = (state_56022__$1[(2)]);
var statearr_56029_56044 = state_56022__$1;
(statearr_56029_56044[(5)] = ex56026);


if((ex56026 instanceof Error)){
var statearr_56030_56045 = state_56022__$1;
(statearr_56030_56045[(1)] = (4));

(statearr_56030_56045[(5)] = null);

} else {
throw ex56026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56023 === (6))){
var inst_56000 = (state_56022[(2)]);
var inst_56001 = fluree.db.util.async.throw_err.call(null,inst_56000);
var inst_56002 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_56001);
var inst_56003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56004 = [inst_56001];
var inst_56005 = (new cljs.core.PersistentVector(null,1,(5),inst_56003,inst_56004,null));
var inst_56006 = cljs.core.count.call(null,inst_56005);
var inst_56007 = ((9) + inst_56006);
var inst_56008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56009 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56011 = [inst_56001];
var inst_56012 = (new cljs.core.PersistentVector(null,1,(5),inst_56010,inst_56011,null));
var inst_56013 = ["<",inst_56012,inst_56002];
var inst_56014 = cljs.core.PersistentHashMap.fromArrays(inst_56009,inst_56013);
var inst_56015 = [inst_56014,inst_56007];
var inst_56016 = (new cljs.core.PersistentVector(null,2,(5),inst_56008,inst_56015,null));
var inst_56017 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56016);
var _ = (function (){var statearr_56031 = state_56022;
(statearr_56031[(4)] = cljs.core.rest.call(null,(state_56022[(4)])));

return statearr_56031;
})();
var state_56022__$1 = (function (){var statearr_56032 = state_56022;
(statearr_56032[(7)] = inst_56017);

return statearr_56032;
})();
var statearr_56033_56046 = state_56022__$1;
(statearr_56033_56046[(2)] = inst_56002);

(statearr_56033_56046[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56034 = [null,null,null,null,null,null,null,null];
(statearr_56034[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56034[(1)] = (1));

return statearr_56034;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56022){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56035){var ex__2749__auto__ = e56035;
var statearr_56036_56047 = state_56022;
(statearr_56036_56047[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56022[(4)]))){
var statearr_56037_56048 = state_56022;
(statearr_56037_56048[(1)] = cljs.core.first.call(null,(state_56022[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56049 = state_56022;
state_56022 = G__56049;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56022){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56038 = f__2769__auto__.call(null);
(statearr_56038[(6)] = c__2768__auto__);

return statearr_56038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55990){
var G__55991 = cljs.core.first.call(null,seq55990);
var seq55990__$1 = cljs.core.next.call(null,seq55990);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55991,seq55990__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56099 = arguments.length;
var i__5770__auto___56100 = (0);
while(true){
if((i__5770__auto___56100 < len__5769__auto___56099)){
args__5775__auto__.push((arguments[i__5770__auto___56100]));

var G__56101 = (i__5770__auto___56100 + (1));
i__5770__auto___56100 = G__56101;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56082){
var state_val_56083 = (state_56082[(1)]);
if((state_val_56083 === (1))){
var state_56082__$1 = state_56082;
var statearr_56084_56102 = state_56082__$1;
(statearr_56084_56102[(2)] = null);

(statearr_56084_56102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56083 === (2))){
var _ = (function (){var statearr_56085 = state_56082;
(statearr_56085[(4)] = cljs.core.cons.call(null,(5),(state_56082[(4)])));

return statearr_56085;
})();
var inst_56058 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56082__$1 = state_56082;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56082__$1,(6),inst_56058);
} else {
if((state_val_56083 === (3))){
var inst_56080 = (state_56082[(2)]);
var state_56082__$1 = state_56082;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56082__$1,inst_56080);
} else {
if((state_val_56083 === (4))){
var inst_56052 = (state_56082[(2)]);
var state_56082__$1 = state_56082;
var statearr_56087_56103 = state_56082__$1;
(statearr_56087_56103[(2)] = inst_56052);

(statearr_56087_56103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56083 === (5))){
var _ = (function (){var statearr_56088 = state_56082;
(statearr_56088[(4)] = cljs.core.rest.call(null,(state_56082[(4)])));

return statearr_56088;
})();
var state_56082__$1 = state_56082;
var ex56086 = (state_56082__$1[(2)]);
var statearr_56089_56104 = state_56082__$1;
(statearr_56089_56104[(5)] = ex56086);


if((ex56086 instanceof Error)){
var statearr_56090_56105 = state_56082__$1;
(statearr_56090_56105[(1)] = (4));

(statearr_56090_56105[(5)] = null);

} else {
throw ex56086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56083 === (6))){
var inst_56060 = (state_56082[(2)]);
var inst_56061 = fluree.db.util.async.throw_err.call(null,inst_56060);
var inst_56062 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_56061);
var inst_56063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56064 = [inst_56061];
var inst_56065 = (new cljs.core.PersistentVector(null,1,(5),inst_56063,inst_56064,null));
var inst_56066 = cljs.core.count.call(null,inst_56065);
var inst_56067 = ((9) + inst_56066);
var inst_56068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56069 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56071 = [inst_56061];
var inst_56072 = (new cljs.core.PersistentVector(null,1,(5),inst_56070,inst_56071,null));
var inst_56073 = ["<=",inst_56072,inst_56062];
var inst_56074 = cljs.core.PersistentHashMap.fromArrays(inst_56069,inst_56073);
var inst_56075 = [inst_56074,inst_56067];
var inst_56076 = (new cljs.core.PersistentVector(null,2,(5),inst_56068,inst_56075,null));
var inst_56077 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56076);
var _ = (function (){var statearr_56091 = state_56082;
(statearr_56091[(4)] = cljs.core.rest.call(null,(state_56082[(4)])));

return statearr_56091;
})();
var state_56082__$1 = (function (){var statearr_56092 = state_56082;
(statearr_56092[(7)] = inst_56077);

return statearr_56092;
})();
var statearr_56093_56106 = state_56082__$1;
(statearr_56093_56106[(2)] = inst_56062);

(statearr_56093_56106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56094 = [null,null,null,null,null,null,null,null];
(statearr_56094[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56094[(1)] = (1));

return statearr_56094;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56082){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56082);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56095){var ex__2749__auto__ = e56095;
var statearr_56096_56107 = state_56082;
(statearr_56096_56107[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56082[(4)]))){
var statearr_56097_56108 = state_56082;
(statearr_56097_56108[(1)] = cljs.core.first.call(null,(state_56082[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56109 = state_56082;
state_56082 = G__56109;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56082){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56098 = f__2769__auto__.call(null);
(statearr_56098[(6)] = c__2768__auto__);

return statearr_56098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq56050){
var G__56051 = cljs.core.first.call(null,seq56050);
var seq56050__$1 = cljs.core.next.call(null,seq56050);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56051,seq56050__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56159 = arguments.length;
var i__5770__auto___56160 = (0);
while(true){
if((i__5770__auto___56160 < len__5769__auto___56159)){
args__5775__auto__.push((arguments[i__5770__auto___56160]));

var G__56161 = (i__5770__auto___56160 + (1));
i__5770__auto___56160 = G__56161;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56142){
var state_val_56143 = (state_56142[(1)]);
if((state_val_56143 === (1))){
var state_56142__$1 = state_56142;
var statearr_56144_56162 = state_56142__$1;
(statearr_56144_56162[(2)] = null);

(statearr_56144_56162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56143 === (2))){
var _ = (function (){var statearr_56145 = state_56142;
(statearr_56145[(4)] = cljs.core.cons.call(null,(5),(state_56142[(4)])));

return statearr_56145;
})();
var inst_56118 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56142__$1 = state_56142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56142__$1,(6),inst_56118);
} else {
if((state_val_56143 === (3))){
var inst_56140 = (state_56142[(2)]);
var state_56142__$1 = state_56142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56142__$1,inst_56140);
} else {
if((state_val_56143 === (4))){
var inst_56112 = (state_56142[(2)]);
var state_56142__$1 = state_56142;
var statearr_56147_56163 = state_56142__$1;
(statearr_56147_56163[(2)] = inst_56112);

(statearr_56147_56163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56143 === (5))){
var _ = (function (){var statearr_56148 = state_56142;
(statearr_56148[(4)] = cljs.core.rest.call(null,(state_56142[(4)])));

return statearr_56148;
})();
var state_56142__$1 = state_56142;
var ex56146 = (state_56142__$1[(2)]);
var statearr_56149_56164 = state_56142__$1;
(statearr_56149_56164[(5)] = ex56146);


if((ex56146 instanceof Error)){
var statearr_56150_56165 = state_56142__$1;
(statearr_56150_56165[(1)] = (4));

(statearr_56150_56165[(5)] = null);

} else {
throw ex56146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56143 === (6))){
var inst_56120 = (state_56142[(2)]);
var inst_56121 = fluree.db.util.async.throw_err.call(null,inst_56120);
var inst_56122 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_56121);
var inst_56123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56124 = [inst_56121];
var inst_56125 = (new cljs.core.PersistentVector(null,1,(5),inst_56123,inst_56124,null));
var inst_56126 = cljs.core.count.call(null,inst_56125);
var inst_56127 = ((9) + inst_56126);
var inst_56128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56129 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56131 = [inst_56121];
var inst_56132 = (new cljs.core.PersistentVector(null,1,(5),inst_56130,inst_56131,null));
var inst_56133 = [">=",inst_56132,inst_56122];
var inst_56134 = cljs.core.PersistentHashMap.fromArrays(inst_56129,inst_56133);
var inst_56135 = [inst_56134,inst_56127];
var inst_56136 = (new cljs.core.PersistentVector(null,2,(5),inst_56128,inst_56135,null));
var inst_56137 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56136);
var _ = (function (){var statearr_56151 = state_56142;
(statearr_56151[(4)] = cljs.core.rest.call(null,(state_56142[(4)])));

return statearr_56151;
})();
var state_56142__$1 = (function (){var statearr_56152 = state_56142;
(statearr_56152[(7)] = inst_56137);

return statearr_56152;
})();
var statearr_56153_56166 = state_56142__$1;
(statearr_56153_56166[(2)] = inst_56122);

(statearr_56153_56166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56154 = [null,null,null,null,null,null,null,null];
(statearr_56154[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56154[(1)] = (1));

return statearr_56154;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56142){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56155){var ex__2749__auto__ = e56155;
var statearr_56156_56167 = state_56142;
(statearr_56156_56167[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56142[(4)]))){
var statearr_56157_56168 = state_56142;
(statearr_56157_56168[(1)] = cljs.core.first.call(null,(state_56142[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56169 = state_56142;
state_56142 = G__56169;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56142){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56158 = f__2769__auto__.call(null);
(statearr_56158[(6)] = c__2768__auto__);

return statearr_56158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq56110){
var G__56111 = cljs.core.first.call(null,seq56110);
var seq56110__$1 = cljs.core.next.call(null,seq56110);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56111,seq56110__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56219 = arguments.length;
var i__5770__auto___56220 = (0);
while(true){
if((i__5770__auto___56220 < len__5769__auto___56219)){
args__5775__auto__.push((arguments[i__5770__auto___56220]));

var G__56221 = (i__5770__auto___56220 + (1));
i__5770__auto___56220 = G__56221;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56202){
var state_val_56203 = (state_56202[(1)]);
if((state_val_56203 === (1))){
var state_56202__$1 = state_56202;
var statearr_56204_56222 = state_56202__$1;
(statearr_56204_56222[(2)] = null);

(statearr_56204_56222[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56203 === (2))){
var _ = (function (){var statearr_56205 = state_56202;
(statearr_56205[(4)] = cljs.core.cons.call(null,(5),(state_56202[(4)])));

return statearr_56205;
})();
var inst_56178 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56202__$1 = state_56202;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56202__$1,(6),inst_56178);
} else {
if((state_val_56203 === (3))){
var inst_56200 = (state_56202[(2)]);
var state_56202__$1 = state_56202;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56202__$1,inst_56200);
} else {
if((state_val_56203 === (4))){
var inst_56172 = (state_56202[(2)]);
var state_56202__$1 = state_56202;
var statearr_56207_56223 = state_56202__$1;
(statearr_56207_56223[(2)] = inst_56172);

(statearr_56207_56223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56203 === (5))){
var _ = (function (){var statearr_56208 = state_56202;
(statearr_56208[(4)] = cljs.core.rest.call(null,(state_56202[(4)])));

return statearr_56208;
})();
var state_56202__$1 = state_56202;
var ex56206 = (state_56202__$1[(2)]);
var statearr_56209_56224 = state_56202__$1;
(statearr_56209_56224[(5)] = ex56206);


if((ex56206 instanceof Error)){
var statearr_56210_56225 = state_56202__$1;
(statearr_56210_56225[(1)] = (4));

(statearr_56210_56225[(5)] = null);

} else {
throw ex56206;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56203 === (6))){
var inst_56180 = (state_56202[(2)]);
var inst_56181 = fluree.db.util.async.throw_err.call(null,inst_56180);
var inst_56182 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_56181);
var inst_56183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56184 = [inst_56181];
var inst_56185 = (new cljs.core.PersistentVector(null,1,(5),inst_56183,inst_56184,null));
var inst_56186 = cljs.core.count.call(null,inst_56185);
var inst_56187 = ((9) + inst_56186);
var inst_56188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56189 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56191 = [inst_56181];
var inst_56192 = (new cljs.core.PersistentVector(null,1,(5),inst_56190,inst_56191,null));
var inst_56193 = ["not=",inst_56192,inst_56182];
var inst_56194 = cljs.core.PersistentHashMap.fromArrays(inst_56189,inst_56193);
var inst_56195 = [inst_56194,inst_56187];
var inst_56196 = (new cljs.core.PersistentVector(null,2,(5),inst_56188,inst_56195,null));
var inst_56197 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56196);
var _ = (function (){var statearr_56211 = state_56202;
(statearr_56211[(4)] = cljs.core.rest.call(null,(state_56202[(4)])));

return statearr_56211;
})();
var state_56202__$1 = (function (){var statearr_56212 = state_56202;
(statearr_56212[(7)] = inst_56197);

return statearr_56212;
})();
var statearr_56213_56226 = state_56202__$1;
(statearr_56213_56226[(2)] = inst_56182);

(statearr_56213_56226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56214 = [null,null,null,null,null,null,null,null];
(statearr_56214[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56214[(1)] = (1));

return statearr_56214;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56202){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56202);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56215){var ex__2749__auto__ = e56215;
var statearr_56216_56227 = state_56202;
(statearr_56216_56227[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56202[(4)]))){
var statearr_56217_56228 = state_56202;
(statearr_56217_56228[(1)] = cljs.core.first.call(null,(state_56202[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56229 = state_56202;
state_56202 = G__56229;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56202){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56218 = f__2769__auto__.call(null);
(statearr_56218[(6)] = c__2768__auto__);

return statearr_56218;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56170){
var G__56171 = cljs.core.first.call(null,seq56170);
var seq56170__$1 = cljs.core.next.call(null,seq56170);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56171,seq56170__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56279 = arguments.length;
var i__5770__auto___56280 = (0);
while(true){
if((i__5770__auto___56280 < len__5769__auto___56279)){
args__5775__auto__.push((arguments[i__5770__auto___56280]));

var G__56281 = (i__5770__auto___56280 + (1));
i__5770__auto___56280 = G__56281;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56262){
var state_val_56263 = (state_56262[(1)]);
if((state_val_56263 === (1))){
var state_56262__$1 = state_56262;
var statearr_56264_56282 = state_56262__$1;
(statearr_56264_56282[(2)] = null);

(statearr_56264_56282[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56263 === (2))){
var _ = (function (){var statearr_56265 = state_56262;
(statearr_56265[(4)] = cljs.core.cons.call(null,(5),(state_56262[(4)])));

return statearr_56265;
})();
var inst_56238 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56262__$1 = state_56262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56262__$1,(6),inst_56238);
} else {
if((state_val_56263 === (3))){
var inst_56260 = (state_56262[(2)]);
var state_56262__$1 = state_56262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56262__$1,inst_56260);
} else {
if((state_val_56263 === (4))){
var inst_56232 = (state_56262[(2)]);
var state_56262__$1 = state_56262;
var statearr_56267_56283 = state_56262__$1;
(statearr_56267_56283[(2)] = inst_56232);

(statearr_56267_56283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56263 === (5))){
var _ = (function (){var statearr_56268 = state_56262;
(statearr_56268[(4)] = cljs.core.rest.call(null,(state_56262[(4)])));

return statearr_56268;
})();
var state_56262__$1 = state_56262;
var ex56266 = (state_56262__$1[(2)]);
var statearr_56269_56284 = state_56262__$1;
(statearr_56269_56284[(5)] = ex56266);


if((ex56266 instanceof Error)){
var statearr_56270_56285 = state_56262__$1;
(statearr_56270_56285[(1)] = (4));

(statearr_56270_56285[(5)] = null);

} else {
throw ex56266;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56263 === (6))){
var inst_56240 = (state_56262[(2)]);
var inst_56241 = fluree.db.util.async.throw_err.call(null,inst_56240);
var inst_56242 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_56241);
var inst_56243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56244 = [inst_56241];
var inst_56245 = (new cljs.core.PersistentVector(null,1,(5),inst_56243,inst_56244,null));
var inst_56246 = cljs.core.count.call(null,inst_56245);
var inst_56247 = ((9) + inst_56246);
var inst_56248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56249 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56251 = [inst_56241];
var inst_56252 = (new cljs.core.PersistentVector(null,1,(5),inst_56250,inst_56251,null));
var inst_56253 = ["max",inst_56252,inst_56242];
var inst_56254 = cljs.core.PersistentHashMap.fromArrays(inst_56249,inst_56253);
var inst_56255 = [inst_56254,inst_56247];
var inst_56256 = (new cljs.core.PersistentVector(null,2,(5),inst_56248,inst_56255,null));
var inst_56257 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56256);
var _ = (function (){var statearr_56271 = state_56262;
(statearr_56271[(4)] = cljs.core.rest.call(null,(state_56262[(4)])));

return statearr_56271;
})();
var state_56262__$1 = (function (){var statearr_56272 = state_56262;
(statearr_56272[(7)] = inst_56257);

return statearr_56272;
})();
var statearr_56273_56286 = state_56262__$1;
(statearr_56273_56286[(2)] = inst_56242);

(statearr_56273_56286[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56274 = [null,null,null,null,null,null,null,null];
(statearr_56274[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56274[(1)] = (1));

return statearr_56274;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56262){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56275){var ex__2749__auto__ = e56275;
var statearr_56276_56287 = state_56262;
(statearr_56276_56287[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56262[(4)]))){
var statearr_56277_56288 = state_56262;
(statearr_56277_56288[(1)] = cljs.core.first.call(null,(state_56262[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56289 = state_56262;
state_56262 = G__56289;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56262){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56278 = f__2769__auto__.call(null);
(statearr_56278[(6)] = c__2768__auto__);

return statearr_56278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56230){
var G__56231 = cljs.core.first.call(null,seq56230);
var seq56230__$1 = cljs.core.next.call(null,seq56230);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56231,seq56230__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56339 = arguments.length;
var i__5770__auto___56340 = (0);
while(true){
if((i__5770__auto___56340 < len__5769__auto___56339)){
args__5775__auto__.push((arguments[i__5770__auto___56340]));

var G__56341 = (i__5770__auto___56340 + (1));
i__5770__auto___56340 = G__56341;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56322){
var state_val_56323 = (state_56322[(1)]);
if((state_val_56323 === (1))){
var state_56322__$1 = state_56322;
var statearr_56324_56342 = state_56322__$1;
(statearr_56324_56342[(2)] = null);

(statearr_56324_56342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56323 === (2))){
var _ = (function (){var statearr_56325 = state_56322;
(statearr_56325[(4)] = cljs.core.cons.call(null,(5),(state_56322[(4)])));

return statearr_56325;
})();
var inst_56298 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56322__$1 = state_56322;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56322__$1,(6),inst_56298);
} else {
if((state_val_56323 === (3))){
var inst_56320 = (state_56322[(2)]);
var state_56322__$1 = state_56322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56322__$1,inst_56320);
} else {
if((state_val_56323 === (4))){
var inst_56292 = (state_56322[(2)]);
var state_56322__$1 = state_56322;
var statearr_56327_56343 = state_56322__$1;
(statearr_56327_56343[(2)] = inst_56292);

(statearr_56327_56343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56323 === (5))){
var _ = (function (){var statearr_56328 = state_56322;
(statearr_56328[(4)] = cljs.core.rest.call(null,(state_56322[(4)])));

return statearr_56328;
})();
var state_56322__$1 = state_56322;
var ex56326 = (state_56322__$1[(2)]);
var statearr_56329_56344 = state_56322__$1;
(statearr_56329_56344[(5)] = ex56326);


if((ex56326 instanceof Error)){
var statearr_56330_56345 = state_56322__$1;
(statearr_56330_56345[(1)] = (4));

(statearr_56330_56345[(5)] = null);

} else {
throw ex56326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56323 === (6))){
var inst_56300 = (state_56322[(2)]);
var inst_56301 = fluree.db.util.async.throw_err.call(null,inst_56300);
var inst_56302 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_56301);
var inst_56303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56304 = [inst_56301];
var inst_56305 = (new cljs.core.PersistentVector(null,1,(5),inst_56303,inst_56304,null));
var inst_56306 = cljs.core.count.call(null,inst_56305);
var inst_56307 = ((9) + inst_56306);
var inst_56308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56309 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56311 = [inst_56301];
var inst_56312 = (new cljs.core.PersistentVector(null,1,(5),inst_56310,inst_56311,null));
var inst_56313 = ["min",inst_56312,inst_56302];
var inst_56314 = cljs.core.PersistentHashMap.fromArrays(inst_56309,inst_56313);
var inst_56315 = [inst_56314,inst_56307];
var inst_56316 = (new cljs.core.PersistentVector(null,2,(5),inst_56308,inst_56315,null));
var inst_56317 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56316);
var _ = (function (){var statearr_56331 = state_56322;
(statearr_56331[(4)] = cljs.core.rest.call(null,(state_56322[(4)])));

return statearr_56331;
})();
var state_56322__$1 = (function (){var statearr_56332 = state_56322;
(statearr_56332[(7)] = inst_56317);

return statearr_56332;
})();
var statearr_56333_56346 = state_56322__$1;
(statearr_56333_56346[(2)] = inst_56302);

(statearr_56333_56346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56334 = [null,null,null,null,null,null,null,null];
(statearr_56334[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56334[(1)] = (1));

return statearr_56334;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56322){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56335){var ex__2749__auto__ = e56335;
var statearr_56336_56347 = state_56322;
(statearr_56336_56347[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56322[(4)]))){
var statearr_56337_56348 = state_56322;
(statearr_56337_56348[(1)] = cljs.core.first.call(null,(state_56322[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56349 = state_56322;
state_56322 = G__56349;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56322){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56338 = f__2769__auto__.call(null);
(statearr_56338[(6)] = c__2768__auto__);

return statearr_56338;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56290){
var G__56291 = cljs.core.first.call(null,seq56290);
var seq56290__$1 = cljs.core.next.call(null,seq56290);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56291,seq56290__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56351 = arguments.length;
switch (G__56351) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56396){
var state_val_56397 = (state_56396[(1)]);
if((state_val_56397 === (7))){
var state_56396__$1 = state_56396;
var statearr_56398_56535 = state_56396__$1;
(statearr_56398_56535[(2)] = query_map);

(statearr_56398_56535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (1))){
var state_56396__$1 = state_56396;
var statearr_56399_56536 = state_56396__$1;
(statearr_56399_56536[(2)] = null);

(statearr_56399_56536[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (4))){
var inst_56352 = (state_56396[(2)]);
var state_56396__$1 = state_56396;
var statearr_56400_56537 = state_56396__$1;
(statearr_56400_56537[(2)] = inst_56352);

(statearr_56400_56537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (13))){
var inst_56374 = (state_56396[(7)]);
var inst_56378 = (state_56396[(2)]);
var inst_56379 = fluree.db.util.async.throw_err.call(null,inst_56378);
var inst_56380 = cljs.core.nth.call(null,inst_56379,(0),null);
var inst_56381 = cljs.core.nth.call(null,inst_56379,(1),null);
var inst_56382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56383 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56385 = [inst_56374];
var inst_56386 = (new cljs.core.PersistentVector(null,1,(5),inst_56384,inst_56385,null));
var inst_56387 = ["query",inst_56386,inst_56380];
var inst_56388 = cljs.core.PersistentHashMap.fromArrays(inst_56383,inst_56387);
var inst_56389 = [inst_56388,inst_56381];
var inst_56390 = (new cljs.core.PersistentVector(null,2,(5),inst_56382,inst_56389,null));
var inst_56391 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56390);
var _ = (function (){var statearr_56401 = state_56396;
(statearr_56401[(4)] = cljs.core.rest.call(null,(state_56396[(4)])));

return statearr_56401;
})();
var state_56396__$1 = (function (){var statearr_56402 = state_56396;
(statearr_56402[(8)] = inst_56391);

return statearr_56402;
})();
var statearr_56403_56538 = state_56396__$1;
(statearr_56403_56538[(2)] = inst_56380);

(statearr_56403_56538[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (6))){
var state_56396__$1 = state_56396;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56396__$1,(9),query_map);
} else {
if((state_val_56397 === (3))){
var inst_56394 = (state_56396[(2)]);
var state_56396__$1 = state_56396;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56396__$1,inst_56394);
} else {
if((state_val_56397 === (12))){
var inst_56374 = (state_56396[(7)]);
var inst_56374__$1 = (state_56396[(2)]);
var inst_56375 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56376 = fluree.db.dbfunctions.internal.query.call(null,inst_56375,inst_56374__$1);
var state_56396__$1 = (function (){var statearr_56404 = state_56396;
(statearr_56404[(7)] = inst_56374__$1);

return statearr_56404;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56396__$1,(13),inst_56376);
} else {
if((state_val_56397 === (2))){
var _ = (function (){var statearr_56405 = state_56396;
(statearr_56405[(4)] = cljs.core.cons.call(null,(5),(state_56396[(4)])));

return statearr_56405;
})();
var inst_56361 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_56396__$1 = state_56396;
if(inst_56361){
var statearr_56406_56539 = state_56396__$1;
(statearr_56406_56539[(1)] = (6));

} else {
var statearr_56407_56540 = state_56396__$1;
(statearr_56407_56540[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (11))){
var inst_56368 = (state_56396[(9)]);
var state_56396__$1 = state_56396;
var statearr_56409_56541 = state_56396__$1;
(statearr_56409_56541[(2)] = inst_56368);

(statearr_56409_56541[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (9))){
var inst_56364 = (state_56396[(2)]);
var inst_56365 = fluree.db.util.async.throw_err.call(null,inst_56364);
var state_56396__$1 = state_56396;
var statearr_56410_56542 = state_56396__$1;
(statearr_56410_56542[(2)] = inst_56365);

(statearr_56410_56542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (5))){
var _ = (function (){var statearr_56411 = state_56396;
(statearr_56411[(4)] = cljs.core.rest.call(null,(state_56396[(4)])));

return statearr_56411;
})();
var state_56396__$1 = state_56396;
var ex56408 = (state_56396__$1[(2)]);
var statearr_56412_56543 = state_56396__$1;
(statearr_56412_56543[(5)] = ex56408);


if((ex56408 instanceof Error)){
var statearr_56413_56544 = state_56396__$1;
(statearr_56413_56544[(1)] = (4));

(statearr_56413_56544[(5)] = null);

} else {
throw ex56408;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (10))){
var inst_56368 = (state_56396[(9)]);
var inst_56371 = fluree.db.util.json.parse.call(null,inst_56368);
var state_56396__$1 = state_56396;
var statearr_56414_56545 = state_56396__$1;
(statearr_56414_56545[(2)] = inst_56371);

(statearr_56414_56545[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56397 === (8))){
var inst_56368 = (state_56396[(9)]);
var inst_56368__$1 = (state_56396[(2)]);
var inst_56369 = typeof inst_56368__$1 === 'string';
var state_56396__$1 = (function (){var statearr_56415 = state_56396;
(statearr_56415[(9)] = inst_56368__$1);

return statearr_56415;
})();
if(cljs.core.truth_(inst_56369)){
var statearr_56416_56546 = state_56396__$1;
(statearr_56416_56546[(1)] = (10));

} else {
var statearr_56417_56547 = state_56396__$1;
(statearr_56417_56547[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56418 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56418[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56418[(1)] = (1));

return statearr_56418;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56396){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56396);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56419){var ex__2749__auto__ = e56419;
var statearr_56420_56548 = state_56396;
(statearr_56420_56548[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56396[(4)]))){
var statearr_56421_56549 = state_56396;
(statearr_56421_56549[(1)] = cljs.core.first.call(null,(state_56396[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56550 = state_56396;
state_56396 = G__56550;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56396){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56422 = f__2769__auto__.call(null);
(statearr_56422[(6)] = c__2768__auto__);

return statearr_56422;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56493){
var state_val_56494 = (state_56493[(1)]);
if((state_val_56494 === (7))){
var state_56493__$1 = state_56493;
var statearr_56495_56551 = state_56493__$1;
(statearr_56495_56551[(2)] = select);

(statearr_56495_56551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (20))){
var inst_56463 = (state_56493[(2)]);
var inst_56464 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_56493__$1 = (function (){var statearr_56496 = state_56493;
(statearr_56496[(7)] = inst_56463);

return statearr_56496;
})();
if(inst_56464){
var statearr_56497_56552 = state_56493__$1;
(statearr_56497_56552[(1)] = (22));

} else {
var statearr_56498_56553 = state_56493__$1;
(statearr_56498_56553[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (1))){
var state_56493__$1 = state_56493;
var statearr_56499_56554 = state_56493__$1;
(statearr_56499_56554[(2)] = null);

(statearr_56499_56554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (24))){
var inst_56447 = (state_56493[(8)]);
var inst_56455 = (state_56493[(9)]);
var inst_56439 = (state_56493[(10)]);
var inst_56463 = (state_56493[(7)]);
var inst_56471 = (state_56493[(2)]);
var inst_56472 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56473 = fluree.db.dbfunctions.internal.query.call(null,inst_56472,inst_56439,inst_56447,inst_56455,inst_56463,inst_56471);
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56493__$1,(26),inst_56473);
} else {
if((state_val_56494 === (4))){
var inst_56423 = (state_56493[(2)]);
var state_56493__$1 = state_56493;
var statearr_56500_56555 = state_56493__$1;
(statearr_56500_56555[(2)] = inst_56423);

(statearr_56500_56555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (15))){
var state_56493__$1 = state_56493;
var statearr_56501_56556 = state_56493__$1;
(statearr_56501_56556[(2)] = where);

(statearr_56501_56556[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (21))){
var inst_56459 = (state_56493[(2)]);
var inst_56460 = fluree.db.util.async.throw_err.call(null,inst_56459);
var state_56493__$1 = state_56493;
var statearr_56502_56557 = state_56493__$1;
(statearr_56502_56557[(2)] = inst_56460);

(statearr_56502_56557[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (13))){
var inst_56443 = (state_56493[(2)]);
var inst_56444 = fluree.db.util.async.throw_err.call(null,inst_56443);
var state_56493__$1 = state_56493;
var statearr_56503_56558 = state_56493__$1;
(statearr_56503_56558[(2)] = inst_56444);

(statearr_56503_56558[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (22))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56493__$1,(25),limit);
} else {
if((state_val_56494 === (6))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56493__$1,(9),select);
} else {
if((state_val_56494 === (25))){
var inst_56467 = (state_56493[(2)]);
var inst_56468 = fluree.db.util.async.throw_err.call(null,inst_56467);
var state_56493__$1 = state_56493;
var statearr_56504_56559 = state_56493__$1;
(statearr_56504_56559[(2)] = inst_56468);

(statearr_56504_56559[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (17))){
var inst_56451 = (state_56493[(2)]);
var inst_56452 = fluree.db.util.async.throw_err.call(null,inst_56451);
var state_56493__$1 = state_56493;
var statearr_56505_56560 = state_56493__$1;
(statearr_56505_56560[(2)] = inst_56452);

(statearr_56505_56560[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (3))){
var inst_56491 = (state_56493[(2)]);
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56493__$1,inst_56491);
} else {
if((state_val_56494 === (12))){
var inst_56447 = (state_56493[(2)]);
var inst_56448 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_56493__$1 = (function (){var statearr_56506 = state_56493;
(statearr_56506[(8)] = inst_56447);

return statearr_56506;
})();
if(inst_56448){
var statearr_56507_56561 = state_56493__$1;
(statearr_56507_56561[(1)] = (14));

} else {
var statearr_56508_56562 = state_56493__$1;
(statearr_56508_56562[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (2))){
var _ = (function (){var statearr_56509 = state_56493;
(statearr_56509[(4)] = cljs.core.cons.call(null,(5),(state_56493[(4)])));

return statearr_56509;
})();
var inst_56432 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_56493__$1 = state_56493;
if(inst_56432){
var statearr_56510_56563 = state_56493__$1;
(statearr_56510_56563[(1)] = (6));

} else {
var statearr_56511_56564 = state_56493__$1;
(statearr_56511_56564[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (23))){
var state_56493__$1 = state_56493;
var statearr_56512_56565 = state_56493__$1;
(statearr_56512_56565[(2)] = limit);

(statearr_56512_56565[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (19))){
var state_56493__$1 = state_56493;
var statearr_56513_56566 = state_56493__$1;
(statearr_56513_56566[(2)] = block);

(statearr_56513_56566[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (11))){
var state_56493__$1 = state_56493;
var statearr_56515_56567 = state_56493__$1;
(statearr_56515_56567[(2)] = from);

(statearr_56515_56567[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (9))){
var inst_56435 = (state_56493[(2)]);
var inst_56436 = fluree.db.util.async.throw_err.call(null,inst_56435);
var state_56493__$1 = state_56493;
var statearr_56516_56568 = state_56493__$1;
(statearr_56516_56568[(2)] = inst_56436);

(statearr_56516_56568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (5))){
var _ = (function (){var statearr_56517 = state_56493;
(statearr_56517[(4)] = cljs.core.rest.call(null,(state_56493[(4)])));

return statearr_56517;
})();
var state_56493__$1 = state_56493;
var ex56514 = (state_56493__$1[(2)]);
var statearr_56518_56569 = state_56493__$1;
(statearr_56518_56569[(5)] = ex56514);


if((ex56514 instanceof Error)){
var statearr_56519_56570 = state_56493__$1;
(statearr_56519_56570[(1)] = (4));

(statearr_56519_56570[(5)] = null);

} else {
throw ex56514;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (14))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56493__$1,(17),where);
} else {
if((state_val_56494 === (26))){
var inst_56447 = (state_56493[(8)]);
var inst_56455 = (state_56493[(9)]);
var inst_56439 = (state_56493[(10)]);
var inst_56463 = (state_56493[(7)]);
var inst_56475 = (state_56493[(2)]);
var inst_56476 = fluree.db.util.async.throw_err.call(null,inst_56475);
var inst_56477 = cljs.core.nth.call(null,inst_56476,(0),null);
var inst_56478 = cljs.core.nth.call(null,inst_56476,(1),null);
var inst_56479 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56480 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56482 = [inst_56439,inst_56447,inst_56455,inst_56463];
var inst_56483 = (new cljs.core.PersistentVector(null,4,(5),inst_56481,inst_56482,null));
var inst_56484 = ["query",inst_56483,inst_56477];
var inst_56485 = cljs.core.PersistentHashMap.fromArrays(inst_56480,inst_56484);
var inst_56486 = [inst_56485,inst_56478];
var inst_56487 = (new cljs.core.PersistentVector(null,2,(5),inst_56479,inst_56486,null));
var inst_56488 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56487);
var _ = (function (){var statearr_56520 = state_56493;
(statearr_56520[(4)] = cljs.core.rest.call(null,(state_56493[(4)])));

return statearr_56520;
})();
var state_56493__$1 = (function (){var statearr_56521 = state_56493;
(statearr_56521[(11)] = inst_56488);

return statearr_56521;
})();
var statearr_56522_56571 = state_56493__$1;
(statearr_56522_56571[(2)] = inst_56477);

(statearr_56522_56571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (16))){
var inst_56455 = (state_56493[(2)]);
var inst_56456 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_56493__$1 = (function (){var statearr_56523 = state_56493;
(statearr_56523[(9)] = inst_56455);

return statearr_56523;
})();
if(inst_56456){
var statearr_56524_56572 = state_56493__$1;
(statearr_56524_56572[(1)] = (18));

} else {
var statearr_56525_56573 = state_56493__$1;
(statearr_56525_56573[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56494 === (10))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56493__$1,(13),from);
} else {
if((state_val_56494 === (18))){
var state_56493__$1 = state_56493;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56493__$1,(21),block);
} else {
if((state_val_56494 === (8))){
var inst_56439 = (state_56493[(2)]);
var inst_56440 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_56493__$1 = (function (){var statearr_56526 = state_56493;
(statearr_56526[(10)] = inst_56439);

return statearr_56526;
})();
if(inst_56440){
var statearr_56527_56574 = state_56493__$1;
(statearr_56527_56574[(1)] = (10));

} else {
var statearr_56528_56575 = state_56493__$1;
(statearr_56528_56575[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56529 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56529[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56529[(1)] = (1));

return statearr_56529;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56493){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56493);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56530){var ex__2749__auto__ = e56530;
var statearr_56531_56576 = state_56493;
(statearr_56531_56576[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56493[(4)]))){
var statearr_56532_56577 = state_56493;
(statearr_56532_56577[(1)] = cljs.core.first.call(null,(state_56493[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56578 = state_56493;
state_56493 = G__56578;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56493){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56533 = f__2769__auto__.call(null);
(statearr_56533[(6)] = c__2768__auto__);

return statearr_56533;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56634){
var state_val_56635 = (state_56634[(1)]);
if((state_val_56635 === (7))){
var state_56634__$1 = state_56634;
var statearr_56636_56667 = state_56634__$1;
(statearr_56636_56667[(2)] = startSubject);

(statearr_56636_56667[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (1))){
var state_56634__$1 = state_56634;
var statearr_56637_56668 = state_56634__$1;
(statearr_56637_56668[(2)] = null);

(statearr_56637_56668[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (4))){
var inst_56579 = (state_56634[(2)]);
var state_56634__$1 = state_56634;
var statearr_56638_56669 = state_56634__$1;
(statearr_56638_56669[(2)] = inst_56579);

(statearr_56638_56669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (15))){
var inst_56611 = (state_56634[(2)]);
var inst_56612 = fluree.db.util.async.throw_err.call(null,inst_56611);
var inst_56613 = cljs.core.nth.call(null,inst_56612,(0),null);
var inst_56614 = cljs.core.nth.call(null,inst_56612,(1),null);
var inst_56615 = cljs.core.empty_QMARK_.call(null,inst_56613);
var state_56634__$1 = (function (){var statearr_56639 = state_56634;
(statearr_56639[(7)] = inst_56614);

return statearr_56639;
})();
if(inst_56615){
var statearr_56640_56670 = state_56634__$1;
(statearr_56640_56670[(1)] = (16));

} else {
var statearr_56641_56671 = state_56634__$1;
(statearr_56641_56671[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (13))){
var inst_56599 = (state_56634[(8)]);
var inst_56595 = (state_56634[(9)]);
var inst_56607 = (state_56634[(10)]);
var inst_56607__$1 = (state_56634[(2)]);
var inst_56608 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56609 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_56608,inst_56595,inst_56599,inst_56607__$1);
var state_56634__$1 = (function (){var statearr_56642 = state_56634;
(statearr_56642[(10)] = inst_56607__$1);

return statearr_56642;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56634__$1,(15),inst_56609);
} else {
if((state_val_56635 === (6))){
var state_56634__$1 = state_56634;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56634__$1,(9),startSubject);
} else {
if((state_val_56635 === (17))){
var state_56634__$1 = state_56634;
var statearr_56643_56672 = state_56634__$1;
(statearr_56643_56672[(2)] = true);

(statearr_56643_56672[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (3))){
var inst_56632 = (state_56634[(2)]);
var state_56634__$1 = state_56634;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56634__$1,inst_56632);
} else {
if((state_val_56635 === (12))){
var state_56634__$1 = state_56634;
var statearr_56644_56673 = state_56634__$1;
(statearr_56644_56673[(2)] = endSubject);

(statearr_56644_56673[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (2))){
var _ = (function (){var statearr_56645 = state_56634;
(statearr_56645[(4)] = cljs.core.cons.call(null,(5),(state_56634[(4)])));

return statearr_56645;
})();
var inst_56588 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_56634__$1 = state_56634;
if(inst_56588){
var statearr_56646_56674 = state_56634__$1;
(statearr_56646_56674[(1)] = (6));

} else {
var statearr_56647_56675 = state_56634__$1;
(statearr_56647_56675[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (11))){
var state_56634__$1 = state_56634;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56634__$1,(14),endSubject);
} else {
if((state_val_56635 === (9))){
var inst_56591 = (state_56634[(2)]);
var inst_56592 = fluree.db.util.async.throw_err.call(null,inst_56591);
var state_56634__$1 = state_56634;
var statearr_56649_56676 = state_56634__$1;
(statearr_56649_56676[(2)] = inst_56592);

(statearr_56649_56676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (5))){
var _ = (function (){var statearr_56650 = state_56634;
(statearr_56650[(4)] = cljs.core.rest.call(null,(state_56634[(4)])));

return statearr_56650;
})();
var state_56634__$1 = state_56634;
var ex56648 = (state_56634__$1[(2)]);
var statearr_56651_56677 = state_56634__$1;
(statearr_56651_56677[(5)] = ex56648);


if((ex56648 instanceof Error)){
var statearr_56652_56678 = state_56634__$1;
(statearr_56652_56678[(1)] = (4));

(statearr_56652_56678[(5)] = null);

} else {
throw ex56648;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (14))){
var inst_56603 = (state_56634[(2)]);
var inst_56604 = fluree.db.util.async.throw_err.call(null,inst_56603);
var state_56634__$1 = state_56634;
var statearr_56653_56679 = state_56634__$1;
(statearr_56653_56679[(2)] = inst_56604);

(statearr_56653_56679[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (16))){
var state_56634__$1 = state_56634;
var statearr_56654_56680 = state_56634__$1;
(statearr_56654_56680[(2)] = false);

(statearr_56654_56680[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (10))){
var inst_56598 = (state_56634[(2)]);
var inst_56599 = fluree.db.util.async.throw_err.call(null,inst_56598);
var inst_56600 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_56634__$1 = (function (){var statearr_56655 = state_56634;
(statearr_56655[(8)] = inst_56599);

return statearr_56655;
})();
if(inst_56600){
var statearr_56656_56681 = state_56634__$1;
(statearr_56656_56681[(1)] = (11));

} else {
var statearr_56657_56682 = state_56634__$1;
(statearr_56657_56682[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (18))){
var inst_56614 = (state_56634[(7)]);
var inst_56599 = (state_56634[(8)]);
var inst_56595 = (state_56634[(9)]);
var inst_56607 = (state_56634[(10)]);
var inst_56619 = (state_56634[(2)]);
var inst_56620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56621 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56623 = [inst_56595,inst_56599,inst_56607];
var inst_56624 = (new cljs.core.PersistentVector(null,3,(5),inst_56622,inst_56623,null));
var inst_56625 = ["relationship?",inst_56624,inst_56619];
var inst_56626 = cljs.core.PersistentHashMap.fromArrays(inst_56621,inst_56625);
var inst_56627 = [inst_56626,inst_56614];
var inst_56628 = (new cljs.core.PersistentVector(null,2,(5),inst_56620,inst_56627,null));
var inst_56629 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56628);
var _ = (function (){var statearr_56658 = state_56634;
(statearr_56658[(4)] = cljs.core.rest.call(null,(state_56634[(4)])));

return statearr_56658;
})();
var state_56634__$1 = (function (){var statearr_56659 = state_56634;
(statearr_56659[(11)] = inst_56629);

return statearr_56659;
})();
var statearr_56660_56683 = state_56634__$1;
(statearr_56660_56683[(2)] = inst_56619);

(statearr_56660_56683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56635 === (8))){
var inst_56595 = (state_56634[(2)]);
var inst_56596 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_56634__$1 = (function (){var statearr_56661 = state_56634;
(statearr_56661[(9)] = inst_56595);

return statearr_56661;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56634__$1,(10),inst_56596);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_56662 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56662[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__);

(statearr_56662[(1)] = (1));

return statearr_56662;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1 = (function (state_56634){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56663){var ex__2749__auto__ = e56663;
var statearr_56664_56684 = state_56634;
(statearr_56664_56684[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56634[(4)]))){
var statearr_56665_56685 = state_56634;
(statearr_56665_56685[(1)] = cljs.core.first.call(null,(state_56634[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56686 = state_56634;
state_56634 = G__56686;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__ = function(state_56634){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1.call(this,state_56634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56666 = f__2769__auto__.call(null);
(statearr_56666[(6)] = c__2768__auto__);

return statearr_56666;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56723){
var state_val_56724 = (state_56723[(1)]);
if((state_val_56724 === (7))){
var state_56723__$1 = state_56723;
var statearr_56725_56745 = state_56723__$1;
(statearr_56725_56745[(2)] = pred_name);

(statearr_56725_56745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (1))){
var state_56723__$1 = state_56723;
var statearr_56726_56746 = state_56723__$1;
(statearr_56726_56746[(2)] = null);

(statearr_56726_56746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (4))){
var inst_56687 = (state_56723[(2)]);
var state_56723__$1 = state_56723;
var statearr_56727_56747 = state_56723__$1;
(statearr_56727_56747[(2)] = inst_56687);

(statearr_56727_56747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (6))){
var state_56723__$1 = state_56723;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56723__$1,(9),pred_name);
} else {
if((state_val_56724 === (3))){
var inst_56721 = (state_56723[(2)]);
var state_56723__$1 = state_56723;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56723__$1,inst_56721);
} else {
if((state_val_56724 === (2))){
var _ = (function (){var statearr_56729 = state_56723;
(statearr_56729[(4)] = cljs.core.cons.call(null,(5),(state_56723[(4)])));

return statearr_56729;
})();
var inst_56696 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_56723__$1 = state_56723;
if(inst_56696){
var statearr_56730_56748 = state_56723__$1;
(statearr_56730_56748[(1)] = (6));

} else {
var statearr_56731_56749 = state_56723__$1;
(statearr_56731_56749[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (9))){
var inst_56699 = (state_56723[(2)]);
var inst_56700 = fluree.db.util.async.throw_err.call(null,inst_56699);
var state_56723__$1 = state_56723;
var statearr_56732_56750 = state_56723__$1;
(statearr_56732_56750[(2)] = inst_56700);

(statearr_56732_56750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (5))){
var _ = (function (){var statearr_56733 = state_56723;
(statearr_56733[(4)] = cljs.core.rest.call(null,(state_56723[(4)])));

return statearr_56733;
})();
var state_56723__$1 = state_56723;
var ex56728 = (state_56723__$1[(2)]);
var statearr_56734_56751 = state_56723__$1;
(statearr_56734_56751[(5)] = ex56728);


if((ex56728 instanceof Error)){
var statearr_56735_56752 = state_56723__$1;
(statearr_56735_56752[(1)] = (4));

(statearr_56735_56752[(5)] = null);

} else {
throw ex56728;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (10))){
var inst_56703 = (state_56723[(7)]);
var inst_56707 = (state_56723[(2)]);
var inst_56708 = fluree.db.util.async.throw_err.call(null,inst_56707);
var inst_56709 = cljs.core.nth.call(null,inst_56708,(0),null);
var inst_56710 = cljs.core.nth.call(null,inst_56708,(1),null);
var inst_56711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56712 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56713 = ["max-pred-val",inst_56703,inst_56709];
var inst_56714 = cljs.core.PersistentHashMap.fromArrays(inst_56712,inst_56713);
var inst_56715 = (inst_56710 + (10));
var inst_56716 = [inst_56714,inst_56715];
var inst_56717 = (new cljs.core.PersistentVector(null,2,(5),inst_56711,inst_56716,null));
var inst_56718 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56717);
var _ = (function (){var statearr_56736 = state_56723;
(statearr_56736[(4)] = cljs.core.rest.call(null,(state_56723[(4)])));

return statearr_56736;
})();
var state_56723__$1 = (function (){var statearr_56737 = state_56723;
(statearr_56737[(8)] = inst_56718);

return statearr_56737;
})();
var statearr_56738_56753 = state_56723__$1;
(statearr_56738_56753[(2)] = inst_56709);

(statearr_56738_56753[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56724 === (8))){
var inst_56703 = (state_56723[(7)]);
var inst_56703__$1 = (state_56723[(2)]);
var inst_56704 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56705 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_56704,inst_56703__$1,null);
var state_56723__$1 = (function (){var statearr_56739 = state_56723;
(statearr_56739[(7)] = inst_56703__$1);

return statearr_56739;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56723__$1,(10),inst_56705);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0 = (function (){
var statearr_56740 = [null,null,null,null,null,null,null,null,null];
(statearr_56740[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__);

(statearr_56740[(1)] = (1));

return statearr_56740;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1 = (function (state_56723){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56723);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56741){var ex__2749__auto__ = e56741;
var statearr_56742_56754 = state_56723;
(statearr_56742_56754[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56723[(4)]))){
var statearr_56743_56755 = state_56723;
(statearr_56743_56755[(1)] = cljs.core.first.call(null,(state_56723[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56756 = state_56723;
state_56723 = G__56756;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__ = function(state_56723){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1.call(this,state_56723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56744 = f__2769__auto__.call(null);
(statearr_56744[(6)] = c__2768__auto__);

return statearr_56744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56783){
var state_val_56784 = (state_56783[(1)]);
if((state_val_56784 === (7))){
var state_56783__$1 = state_56783;
var statearr_56785_56804 = state_56783__$1;
(statearr_56785_56804[(2)] = n);

(statearr_56785_56804[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56784 === (1))){
var state_56783__$1 = state_56783;
var statearr_56786_56805 = state_56783__$1;
(statearr_56786_56805[(2)] = null);

(statearr_56786_56805[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56784 === (4))){
var inst_56757 = (state_56783[(2)]);
var state_56783__$1 = state_56783;
var statearr_56787_56806 = state_56783__$1;
(statearr_56787_56806[(2)] = inst_56757);

(statearr_56787_56806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56784 === (6))){
var state_56783__$1 = state_56783;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56783__$1,(9),n);
} else {
if((state_val_56784 === (3))){
var inst_56781 = (state_56783[(2)]);
var state_56783__$1 = state_56783;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56783__$1,inst_56781);
} else {
if((state_val_56784 === (2))){
var _ = (function (){var statearr_56789 = state_56783;
(statearr_56789[(4)] = cljs.core.cons.call(null,(5),(state_56783[(4)])));

return statearr_56789;
})();
var inst_56763 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56783__$1 = state_56783;
if(inst_56763){
var statearr_56790_56807 = state_56783__$1;
(statearr_56790_56807[(1)] = (6));

} else {
var statearr_56791_56808 = state_56783__$1;
(statearr_56791_56808[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56784 === (9))){
var inst_56766 = (state_56783[(2)]);
var inst_56767 = fluree.db.util.async.throw_err.call(null,inst_56766);
var state_56783__$1 = state_56783;
var statearr_56792_56809 = state_56783__$1;
(statearr_56792_56809[(2)] = inst_56767);

(statearr_56792_56809[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56784 === (5))){
var _ = (function (){var statearr_56793 = state_56783;
(statearr_56793[(4)] = cljs.core.rest.call(null,(state_56783[(4)])));

return statearr_56793;
})();
var state_56783__$1 = state_56783;
var ex56788 = (state_56783__$1[(2)]);
var statearr_56794_56810 = state_56783__$1;
(statearr_56794_56810[(5)] = ex56788);


if((ex56788 instanceof Error)){
var statearr_56795_56811 = state_56783__$1;
(statearr_56795_56811[(1)] = (4));

(statearr_56795_56811[(5)] = null);

} else {
throw ex56788;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56784 === (8))){
var inst_56770 = (state_56783[(2)]);
var inst_56771 = fluree.db.dbfunctions.internal.inc.call(null,inst_56770);
var inst_56772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56773 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56774 = ["inc",inst_56770,inst_56771];
var inst_56775 = cljs.core.PersistentHashMap.fromArrays(inst_56773,inst_56774);
var inst_56776 = [inst_56775,(10)];
var inst_56777 = (new cljs.core.PersistentVector(null,2,(5),inst_56772,inst_56776,null));
var inst_56778 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56777);
var _ = (function (){var statearr_56796 = state_56783;
(statearr_56796[(4)] = cljs.core.rest.call(null,(state_56783[(4)])));

return statearr_56796;
})();
var state_56783__$1 = (function (){var statearr_56797 = state_56783;
(statearr_56797[(7)] = inst_56778);

return statearr_56797;
})();
var statearr_56798_56812 = state_56783__$1;
(statearr_56798_56812[(2)] = inst_56771);

(statearr_56798_56812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0 = (function (){
var statearr_56799 = [null,null,null,null,null,null,null,null];
(statearr_56799[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__);

(statearr_56799[(1)] = (1));

return statearr_56799;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1 = (function (state_56783){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56783);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56800){var ex__2749__auto__ = e56800;
var statearr_56801_56813 = state_56783;
(statearr_56801_56813[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56783[(4)]))){
var statearr_56802_56814 = state_56783;
(statearr_56802_56814[(1)] = cljs.core.first.call(null,(state_56783[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56815 = state_56783;
state_56783 = G__56815;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__ = function(state_56783){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1.call(this,state_56783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56803 = f__2769__auto__.call(null);
(statearr_56803[(6)] = c__2768__auto__);

return statearr_56803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56842){
var state_val_56843 = (state_56842[(1)]);
if((state_val_56843 === (7))){
var state_56842__$1 = state_56842;
var statearr_56844_56863 = state_56842__$1;
(statearr_56844_56863[(2)] = n);

(statearr_56844_56863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (1))){
var state_56842__$1 = state_56842;
var statearr_56845_56864 = state_56842__$1;
(statearr_56845_56864[(2)] = null);

(statearr_56845_56864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (4))){
var inst_56816 = (state_56842[(2)]);
var state_56842__$1 = state_56842;
var statearr_56846_56865 = state_56842__$1;
(statearr_56846_56865[(2)] = inst_56816);

(statearr_56846_56865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (6))){
var state_56842__$1 = state_56842;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56842__$1,(9),n);
} else {
if((state_val_56843 === (3))){
var inst_56840 = (state_56842[(2)]);
var state_56842__$1 = state_56842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56842__$1,inst_56840);
} else {
if((state_val_56843 === (2))){
var _ = (function (){var statearr_56848 = state_56842;
(statearr_56848[(4)] = cljs.core.cons.call(null,(5),(state_56842[(4)])));

return statearr_56848;
})();
var inst_56822 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56842__$1 = state_56842;
if(inst_56822){
var statearr_56849_56866 = state_56842__$1;
(statearr_56849_56866[(1)] = (6));

} else {
var statearr_56850_56867 = state_56842__$1;
(statearr_56850_56867[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (9))){
var inst_56825 = (state_56842[(2)]);
var inst_56826 = fluree.db.util.async.throw_err.call(null,inst_56825);
var state_56842__$1 = state_56842;
var statearr_56851_56868 = state_56842__$1;
(statearr_56851_56868[(2)] = inst_56826);

(statearr_56851_56868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (5))){
var _ = (function (){var statearr_56852 = state_56842;
(statearr_56852[(4)] = cljs.core.rest.call(null,(state_56842[(4)])));

return statearr_56852;
})();
var state_56842__$1 = state_56842;
var ex56847 = (state_56842__$1[(2)]);
var statearr_56853_56869 = state_56842__$1;
(statearr_56853_56869[(5)] = ex56847);


if((ex56847 instanceof Error)){
var statearr_56854_56870 = state_56842__$1;
(statearr_56854_56870[(1)] = (4));

(statearr_56854_56870[(5)] = null);

} else {
throw ex56847;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56843 === (8))){
var inst_56829 = (state_56842[(2)]);
var inst_56830 = fluree.db.dbfunctions.internal.dec.call(null,inst_56829);
var inst_56831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56832 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56833 = ["dec",inst_56829,inst_56830];
var inst_56834 = cljs.core.PersistentHashMap.fromArrays(inst_56832,inst_56833);
var inst_56835 = [inst_56834,(10)];
var inst_56836 = (new cljs.core.PersistentVector(null,2,(5),inst_56831,inst_56835,null));
var inst_56837 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56836);
var _ = (function (){var statearr_56855 = state_56842;
(statearr_56855[(4)] = cljs.core.rest.call(null,(state_56842[(4)])));

return statearr_56855;
})();
var state_56842__$1 = (function (){var statearr_56856 = state_56842;
(statearr_56856[(7)] = inst_56837);

return statearr_56856;
})();
var statearr_56857_56871 = state_56842__$1;
(statearr_56857_56871[(2)] = inst_56830);

(statearr_56857_56871[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0 = (function (){
var statearr_56858 = [null,null,null,null,null,null,null,null];
(statearr_56858[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__);

(statearr_56858[(1)] = (1));

return statearr_56858;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1 = (function (state_56842){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56859){var ex__2749__auto__ = e56859;
var statearr_56860_56872 = state_56842;
(statearr_56860_56872[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56842[(4)]))){
var statearr_56861_56873 = state_56842;
(statearr_56861_56873[(1)] = cljs.core.first.call(null,(state_56842[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56874 = state_56842;
state_56842 = G__56874;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__ = function(state_56842){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1.call(this,state_56842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56862 = f__2769__auto__.call(null);
(statearr_56862[(6)] = c__2768__auto__);

return statearr_56862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56924 = arguments.length;
var i__5770__auto___56925 = (0);
while(true){
if((i__5770__auto___56925 < len__5769__auto___56924)){
args__5775__auto__.push((arguments[i__5770__auto___56925]));

var G__56926 = (i__5770__auto___56925 + (1));
i__5770__auto___56925 = G__56926;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56907){
var state_val_56908 = (state_56907[(1)]);
if((state_val_56908 === (1))){
var state_56907__$1 = state_56907;
var statearr_56909_56927 = state_56907__$1;
(statearr_56909_56927[(2)] = null);

(statearr_56909_56927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (2))){
var _ = (function (){var statearr_56910 = state_56907;
(statearr_56910[(4)] = cljs.core.cons.call(null,(5),(state_56907[(4)])));

return statearr_56910;
})();
var inst_56883 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56907__$1 = state_56907;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56907__$1,(6),inst_56883);
} else {
if((state_val_56908 === (3))){
var inst_56905 = (state_56907[(2)]);
var state_56907__$1 = state_56907;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56907__$1,inst_56905);
} else {
if((state_val_56908 === (4))){
var inst_56877 = (state_56907[(2)]);
var state_56907__$1 = state_56907;
var statearr_56912_56928 = state_56907__$1;
(statearr_56912_56928[(2)] = inst_56877);

(statearr_56912_56928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (5))){
var _ = (function (){var statearr_56913 = state_56907;
(statearr_56913[(4)] = cljs.core.rest.call(null,(state_56907[(4)])));

return statearr_56913;
})();
var state_56907__$1 = state_56907;
var ex56911 = (state_56907__$1[(2)]);
var statearr_56914_56929 = state_56907__$1;
(statearr_56914_56929[(5)] = ex56911);


if((ex56911 instanceof Error)){
var statearr_56915_56930 = state_56907__$1;
(statearr_56915_56930[(1)] = (4));

(statearr_56915_56930[(5)] = null);

} else {
throw ex56911;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56908 === (6))){
var inst_56885 = (state_56907[(2)]);
var inst_56886 = fluree.db.util.async.throw_err.call(null,inst_56885);
var inst_56887 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_56886);
var inst_56888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56889 = [inst_56886];
var inst_56890 = (new cljs.core.PersistentVector(null,1,(5),inst_56888,inst_56889,null));
var inst_56891 = cljs.core.count.call(null,inst_56890);
var inst_56892 = ((9) + inst_56891);
var inst_56893 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56894 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56895 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56896 = [inst_56886];
var inst_56897 = (new cljs.core.PersistentVector(null,1,(5),inst_56895,inst_56896,null));
var inst_56898 = ["+",inst_56897,inst_56887];
var inst_56899 = cljs.core.PersistentHashMap.fromArrays(inst_56894,inst_56898);
var inst_56900 = [inst_56899,inst_56892];
var inst_56901 = (new cljs.core.PersistentVector(null,2,(5),inst_56893,inst_56900,null));
var inst_56902 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56901);
var _ = (function (){var statearr_56916 = state_56907;
(statearr_56916[(4)] = cljs.core.rest.call(null,(state_56907[(4)])));

return statearr_56916;
})();
var state_56907__$1 = (function (){var statearr_56917 = state_56907;
(statearr_56917[(7)] = inst_56902);

return statearr_56917;
})();
var statearr_56918_56931 = state_56907__$1;
(statearr_56918_56931[(2)] = inst_56887);

(statearr_56918_56931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56919 = [null,null,null,null,null,null,null,null];
(statearr_56919[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56919[(1)] = (1));

return statearr_56919;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56907){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56907);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56920){var ex__2749__auto__ = e56920;
var statearr_56921_56932 = state_56907;
(statearr_56921_56932[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56907[(4)]))){
var statearr_56922_56933 = state_56907;
(statearr_56922_56933[(1)] = cljs.core.first.call(null,(state_56907[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56934 = state_56907;
state_56907 = G__56934;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56907){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56907);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56923 = f__2769__auto__.call(null);
(statearr_56923[(6)] = c__2768__auto__);

return statearr_56923;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56875){
var G__56876 = cljs.core.first.call(null,seq56875);
var seq56875__$1 = cljs.core.next.call(null,seq56875);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56876,seq56875__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56984 = arguments.length;
var i__5770__auto___56985 = (0);
while(true){
if((i__5770__auto___56985 < len__5769__auto___56984)){
args__5775__auto__.push((arguments[i__5770__auto___56985]));

var G__56986 = (i__5770__auto___56985 + (1));
i__5770__auto___56985 = G__56986;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_56967){
var state_val_56968 = (state_56967[(1)]);
if((state_val_56968 === (1))){
var state_56967__$1 = state_56967;
var statearr_56969_56987 = state_56967__$1;
(statearr_56969_56987[(2)] = null);

(statearr_56969_56987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56968 === (2))){
var _ = (function (){var statearr_56970 = state_56967;
(statearr_56970[(4)] = cljs.core.cons.call(null,(5),(state_56967[(4)])));

return statearr_56970;
})();
var inst_56943 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56967__$1 = state_56967;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56967__$1,(6),inst_56943);
} else {
if((state_val_56968 === (3))){
var inst_56965 = (state_56967[(2)]);
var state_56967__$1 = state_56967;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56967__$1,inst_56965);
} else {
if((state_val_56968 === (4))){
var inst_56937 = (state_56967[(2)]);
var state_56967__$1 = state_56967;
var statearr_56972_56988 = state_56967__$1;
(statearr_56972_56988[(2)] = inst_56937);

(statearr_56972_56988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56968 === (5))){
var _ = (function (){var statearr_56973 = state_56967;
(statearr_56973[(4)] = cljs.core.rest.call(null,(state_56967[(4)])));

return statearr_56973;
})();
var state_56967__$1 = state_56967;
var ex56971 = (state_56967__$1[(2)]);
var statearr_56974_56989 = state_56967__$1;
(statearr_56974_56989[(5)] = ex56971);


if((ex56971 instanceof Error)){
var statearr_56975_56990 = state_56967__$1;
(statearr_56975_56990[(1)] = (4));

(statearr_56975_56990[(5)] = null);

} else {
throw ex56971;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56968 === (6))){
var inst_56945 = (state_56967[(2)]);
var inst_56946 = fluree.db.util.async.throw_err.call(null,inst_56945);
var inst_56947 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_56946);
var inst_56948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56949 = [inst_56946];
var inst_56950 = (new cljs.core.PersistentVector(null,1,(5),inst_56948,inst_56949,null));
var inst_56951 = cljs.core.count.call(null,inst_56950);
var inst_56952 = ((9) + inst_56951);
var inst_56953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56954 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56955 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56956 = [inst_56946];
var inst_56957 = (new cljs.core.PersistentVector(null,1,(5),inst_56955,inst_56956,null));
var inst_56958 = ["-",inst_56957,inst_56947];
var inst_56959 = cljs.core.PersistentHashMap.fromArrays(inst_56954,inst_56958);
var inst_56960 = [inst_56959,inst_56952];
var inst_56961 = (new cljs.core.PersistentVector(null,2,(5),inst_56953,inst_56960,null));
var inst_56962 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56961);
var _ = (function (){var statearr_56976 = state_56967;
(statearr_56976[(4)] = cljs.core.rest.call(null,(state_56967[(4)])));

return statearr_56976;
})();
var state_56967__$1 = (function (){var statearr_56977 = state_56967;
(statearr_56977[(7)] = inst_56962);

return statearr_56977;
})();
var statearr_56978_56991 = state_56967__$1;
(statearr_56978_56991[(2)] = inst_56947);

(statearr_56978_56991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_56979 = [null,null,null,null,null,null,null,null];
(statearr_56979[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_56979[(1)] = (1));

return statearr_56979;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_56967){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_56967);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e56980){var ex__2749__auto__ = e56980;
var statearr_56981_56992 = state_56967;
(statearr_56981_56992[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_56967[(4)]))){
var statearr_56982_56993 = state_56967;
(statearr_56982_56993[(1)] = cljs.core.first.call(null,(state_56967[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56994 = state_56967;
state_56967 = G__56994;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_56967){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_56967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_56983 = f__2769__auto__.call(null);
(statearr_56983[(6)] = c__2768__auto__);

return statearr_56983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56935){
var G__56936 = cljs.core.first.call(null,seq56935);
var seq56935__$1 = cljs.core.next.call(null,seq56935);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56936,seq56935__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57044 = arguments.length;
var i__5770__auto___57045 = (0);
while(true){
if((i__5770__auto___57045 < len__5769__auto___57044)){
args__5775__auto__.push((arguments[i__5770__auto___57045]));

var G__57046 = (i__5770__auto___57045 + (1));
i__5770__auto___57045 = G__57046;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57027){
var state_val_57028 = (state_57027[(1)]);
if((state_val_57028 === (1))){
var state_57027__$1 = state_57027;
var statearr_57029_57047 = state_57027__$1;
(statearr_57029_57047[(2)] = null);

(statearr_57029_57047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57028 === (2))){
var _ = (function (){var statearr_57030 = state_57027;
(statearr_57030[(4)] = cljs.core.cons.call(null,(5),(state_57027[(4)])));

return statearr_57030;
})();
var inst_57003 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57027__$1 = state_57027;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57027__$1,(6),inst_57003);
} else {
if((state_val_57028 === (3))){
var inst_57025 = (state_57027[(2)]);
var state_57027__$1 = state_57027;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57027__$1,inst_57025);
} else {
if((state_val_57028 === (4))){
var inst_56997 = (state_57027[(2)]);
var state_57027__$1 = state_57027;
var statearr_57032_57048 = state_57027__$1;
(statearr_57032_57048[(2)] = inst_56997);

(statearr_57032_57048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57028 === (5))){
var _ = (function (){var statearr_57033 = state_57027;
(statearr_57033[(4)] = cljs.core.rest.call(null,(state_57027[(4)])));

return statearr_57033;
})();
var state_57027__$1 = state_57027;
var ex57031 = (state_57027__$1[(2)]);
var statearr_57034_57049 = state_57027__$1;
(statearr_57034_57049[(5)] = ex57031);


if((ex57031 instanceof Error)){
var statearr_57035_57050 = state_57027__$1;
(statearr_57035_57050[(1)] = (4));

(statearr_57035_57050[(5)] = null);

} else {
throw ex57031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57028 === (6))){
var inst_57005 = (state_57027[(2)]);
var inst_57006 = fluree.db.util.async.throw_err.call(null,inst_57005);
var inst_57007 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_57006);
var inst_57008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57009 = [inst_57006];
var inst_57010 = (new cljs.core.PersistentVector(null,1,(5),inst_57008,inst_57009,null));
var inst_57011 = cljs.core.count.call(null,inst_57010);
var inst_57012 = ((9) + inst_57011);
var inst_57013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57014 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57016 = [inst_57006];
var inst_57017 = (new cljs.core.PersistentVector(null,1,(5),inst_57015,inst_57016,null));
var inst_57018 = ["*",inst_57017,inst_57007];
var inst_57019 = cljs.core.PersistentHashMap.fromArrays(inst_57014,inst_57018);
var inst_57020 = [inst_57019,inst_57012];
var inst_57021 = (new cljs.core.PersistentVector(null,2,(5),inst_57013,inst_57020,null));
var inst_57022 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57021);
var _ = (function (){var statearr_57036 = state_57027;
(statearr_57036[(4)] = cljs.core.rest.call(null,(state_57027[(4)])));

return statearr_57036;
})();
var state_57027__$1 = (function (){var statearr_57037 = state_57027;
(statearr_57037[(7)] = inst_57022);

return statearr_57037;
})();
var statearr_57038_57051 = state_57027__$1;
(statearr_57038_57051[(2)] = inst_57007);

(statearr_57038_57051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57039 = [null,null,null,null,null,null,null,null];
(statearr_57039[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57039[(1)] = (1));

return statearr_57039;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57027){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57027);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57040){var ex__2749__auto__ = e57040;
var statearr_57041_57052 = state_57027;
(statearr_57041_57052[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57027[(4)]))){
var statearr_57042_57053 = state_57027;
(statearr_57042_57053[(1)] = cljs.core.first.call(null,(state_57027[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57054 = state_57027;
state_57027 = G__57054;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57027){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57043 = f__2769__auto__.call(null);
(statearr_57043[(6)] = c__2768__auto__);

return statearr_57043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56995){
var G__56996 = cljs.core.first.call(null,seq56995);
var seq56995__$1 = cljs.core.next.call(null,seq56995);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56996,seq56995__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___57104 = arguments.length;
var i__5770__auto___57105 = (0);
while(true){
if((i__5770__auto___57105 < len__5769__auto___57104)){
args__5775__auto__.push((arguments[i__5770__auto___57105]));

var G__57106 = (i__5770__auto___57105 + (1));
i__5770__auto___57105 = G__57106;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57087){
var state_val_57088 = (state_57087[(1)]);
if((state_val_57088 === (1))){
var state_57087__$1 = state_57087;
var statearr_57089_57107 = state_57087__$1;
(statearr_57089_57107[(2)] = null);

(statearr_57089_57107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (2))){
var _ = (function (){var statearr_57090 = state_57087;
(statearr_57090[(4)] = cljs.core.cons.call(null,(5),(state_57087[(4)])));

return statearr_57090;
})();
var inst_57063 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57087__$1 = state_57087;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57087__$1,(6),inst_57063);
} else {
if((state_val_57088 === (3))){
var inst_57085 = (state_57087[(2)]);
var state_57087__$1 = state_57087;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57087__$1,inst_57085);
} else {
if((state_val_57088 === (4))){
var inst_57057 = (state_57087[(2)]);
var state_57087__$1 = state_57087;
var statearr_57092_57108 = state_57087__$1;
(statearr_57092_57108[(2)] = inst_57057);

(statearr_57092_57108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (5))){
var _ = (function (){var statearr_57093 = state_57087;
(statearr_57093[(4)] = cljs.core.rest.call(null,(state_57087[(4)])));

return statearr_57093;
})();
var state_57087__$1 = state_57087;
var ex57091 = (state_57087__$1[(2)]);
var statearr_57094_57109 = state_57087__$1;
(statearr_57094_57109[(5)] = ex57091);


if((ex57091 instanceof Error)){
var statearr_57095_57110 = state_57087__$1;
(statearr_57095_57110[(1)] = (4));

(statearr_57095_57110[(5)] = null);

} else {
throw ex57091;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57088 === (6))){
var inst_57065 = (state_57087[(2)]);
var inst_57066 = fluree.db.util.async.throw_err.call(null,inst_57065);
var inst_57067 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_57066);
var inst_57068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57069 = [inst_57066];
var inst_57070 = (new cljs.core.PersistentVector(null,1,(5),inst_57068,inst_57069,null));
var inst_57071 = cljs.core.count.call(null,inst_57070);
var inst_57072 = ((9) + inst_57071);
var inst_57073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57074 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57076 = [inst_57066];
var inst_57077 = (new cljs.core.PersistentVector(null,1,(5),inst_57075,inst_57076,null));
var inst_57078 = ["/",inst_57077,inst_57067];
var inst_57079 = cljs.core.PersistentHashMap.fromArrays(inst_57074,inst_57078);
var inst_57080 = [inst_57079,inst_57072];
var inst_57081 = (new cljs.core.PersistentVector(null,2,(5),inst_57073,inst_57080,null));
var inst_57082 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57081);
var _ = (function (){var statearr_57096 = state_57087;
(statearr_57096[(4)] = cljs.core.rest.call(null,(state_57087[(4)])));

return statearr_57096;
})();
var state_57087__$1 = (function (){var statearr_57097 = state_57087;
(statearr_57097[(7)] = inst_57082);

return statearr_57097;
})();
var statearr_57098_57111 = state_57087__$1;
(statearr_57098_57111[(2)] = inst_57067);

(statearr_57098_57111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57099 = [null,null,null,null,null,null,null,null];
(statearr_57099[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57099[(1)] = (1));

return statearr_57099;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57087){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57087);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57100){var ex__2749__auto__ = e57100;
var statearr_57101_57112 = state_57087;
(statearr_57101_57112[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57087[(4)]))){
var statearr_57102_57113 = state_57087;
(statearr_57102_57113[(1)] = cljs.core.first.call(null,(state_57087[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57114 = state_57087;
state_57087 = G__57114;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57087){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57103 = f__2769__auto__.call(null);
(statearr_57103[(6)] = c__2768__auto__);

return statearr_57103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq57055){
var G__57056 = cljs.core.first.call(null,seq57055);
var seq57055__$1 = cljs.core.next.call(null,seq57055);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57056,seq57055__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57152){
var state_val_57153 = (state_57152[(1)]);
if((state_val_57153 === (7))){
var state_57152__$1 = state_57152;
var statearr_57154_57178 = state_57152__$1;
(statearr_57154_57178[(2)] = n);

(statearr_57154_57178[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (1))){
var state_57152__$1 = state_57152;
var statearr_57155_57179 = state_57152__$1;
(statearr_57155_57179[(2)] = null);

(statearr_57155_57179[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (4))){
var inst_57115 = (state_57152[(2)]);
var state_57152__$1 = state_57152;
var statearr_57156_57180 = state_57152__$1;
(statearr_57156_57180[(2)] = inst_57115);

(statearr_57156_57180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (13))){
var inst_57132 = (state_57152[(2)]);
var inst_57133 = fluree.db.util.async.throw_err.call(null,inst_57132);
var state_57152__$1 = state_57152;
var statearr_57157_57181 = state_57152__$1;
(statearr_57157_57181[(2)] = inst_57133);

(statearr_57157_57181[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (6))){
var state_57152__$1 = state_57152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57152__$1,(9),n);
} else {
if((state_val_57153 === (3))){
var inst_57150 = (state_57152[(2)]);
var state_57152__$1 = state_57152;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57152__$1,inst_57150);
} else {
if((state_val_57153 === (12))){
var inst_57128 = (state_57152[(7)]);
var inst_57136 = (state_57152[(2)]);
var inst_57137 = fluree.db.dbfunctions.internal.quot.call(null,inst_57128,inst_57136);
var inst_57138 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57139 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57141 = [inst_57128,inst_57136];
var inst_57142 = (new cljs.core.PersistentVector(null,2,(5),inst_57140,inst_57141,null));
var inst_57143 = ["quot",inst_57142,inst_57137];
var inst_57144 = cljs.core.PersistentHashMap.fromArrays(inst_57139,inst_57143);
var inst_57145 = [inst_57144,(2)];
var inst_57146 = (new cljs.core.PersistentVector(null,2,(5),inst_57138,inst_57145,null));
var inst_57147 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57146);
var _ = (function (){var statearr_57158 = state_57152;
(statearr_57158[(4)] = cljs.core.rest.call(null,(state_57152[(4)])));

return statearr_57158;
})();
var state_57152__$1 = (function (){var statearr_57159 = state_57152;
(statearr_57159[(8)] = inst_57147);

return statearr_57159;
})();
var statearr_57160_57182 = state_57152__$1;
(statearr_57160_57182[(2)] = inst_57137);

(statearr_57160_57182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (2))){
var _ = (function (){var statearr_57161 = state_57152;
(statearr_57161[(4)] = cljs.core.cons.call(null,(5),(state_57152[(4)])));

return statearr_57161;
})();
var inst_57121 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57152__$1 = state_57152;
if(inst_57121){
var statearr_57162_57183 = state_57152__$1;
(statearr_57162_57183[(1)] = (6));

} else {
var statearr_57163_57184 = state_57152__$1;
(statearr_57163_57184[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (11))){
var state_57152__$1 = state_57152;
var statearr_57165_57185 = state_57152__$1;
(statearr_57165_57185[(2)] = d);

(statearr_57165_57185[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (9))){
var inst_57124 = (state_57152[(2)]);
var inst_57125 = fluree.db.util.async.throw_err.call(null,inst_57124);
var state_57152__$1 = state_57152;
var statearr_57166_57186 = state_57152__$1;
(statearr_57166_57186[(2)] = inst_57125);

(statearr_57166_57186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (5))){
var _ = (function (){var statearr_57167 = state_57152;
(statearr_57167[(4)] = cljs.core.rest.call(null,(state_57152[(4)])));

return statearr_57167;
})();
var state_57152__$1 = state_57152;
var ex57164 = (state_57152__$1[(2)]);
var statearr_57168_57187 = state_57152__$1;
(statearr_57168_57187[(5)] = ex57164);


if((ex57164 instanceof Error)){
var statearr_57169_57188 = state_57152__$1;
(statearr_57169_57188[(1)] = (4));

(statearr_57169_57188[(5)] = null);

} else {
throw ex57164;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57153 === (10))){
var state_57152__$1 = state_57152;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57152__$1,(13),d);
} else {
if((state_val_57153 === (8))){
var inst_57128 = (state_57152[(2)]);
var inst_57129 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57152__$1 = (function (){var statearr_57170 = state_57152;
(statearr_57170[(7)] = inst_57128);

return statearr_57170;
})();
if(inst_57129){
var statearr_57171_57189 = state_57152__$1;
(statearr_57171_57189[(1)] = (10));

} else {
var statearr_57172_57190 = state_57152__$1;
(statearr_57172_57190[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0 = (function (){
var statearr_57173 = [null,null,null,null,null,null,null,null,null];
(statearr_57173[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__);

(statearr_57173[(1)] = (1));

return statearr_57173;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1 = (function (state_57152){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57152);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57174){var ex__2749__auto__ = e57174;
var statearr_57175_57191 = state_57152;
(statearr_57175_57191[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57152[(4)]))){
var statearr_57176_57192 = state_57152;
(statearr_57176_57192[(1)] = cljs.core.first.call(null,(state_57152[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57193 = state_57152;
state_57152 = G__57193;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__ = function(state_57152){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1.call(this,state_57152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57177 = f__2769__auto__.call(null);
(statearr_57177[(6)] = c__2768__auto__);

return statearr_57177;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57231){
var state_val_57232 = (state_57231[(1)]);
if((state_val_57232 === (7))){
var state_57231__$1 = state_57231;
var statearr_57233_57257 = state_57231__$1;
(statearr_57233_57257[(2)] = n);

(statearr_57233_57257[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (1))){
var state_57231__$1 = state_57231;
var statearr_57234_57258 = state_57231__$1;
(statearr_57234_57258[(2)] = null);

(statearr_57234_57258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (4))){
var inst_57194 = (state_57231[(2)]);
var state_57231__$1 = state_57231;
var statearr_57235_57259 = state_57231__$1;
(statearr_57235_57259[(2)] = inst_57194);

(statearr_57235_57259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (13))){
var inst_57211 = (state_57231[(2)]);
var inst_57212 = fluree.db.util.async.throw_err.call(null,inst_57211);
var state_57231__$1 = state_57231;
var statearr_57236_57260 = state_57231__$1;
(statearr_57236_57260[(2)] = inst_57212);

(statearr_57236_57260[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (6))){
var state_57231__$1 = state_57231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57231__$1,(9),n);
} else {
if((state_val_57232 === (3))){
var inst_57229 = (state_57231[(2)]);
var state_57231__$1 = state_57231;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57231__$1,inst_57229);
} else {
if((state_val_57232 === (12))){
var inst_57207 = (state_57231[(7)]);
var inst_57215 = (state_57231[(2)]);
var inst_57216 = fluree.db.dbfunctions.internal.mod.call(null,inst_57207,inst_57215);
var inst_57217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57218 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57219 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57220 = [inst_57207,inst_57215];
var inst_57221 = (new cljs.core.PersistentVector(null,2,(5),inst_57219,inst_57220,null));
var inst_57222 = ["mod",inst_57221,inst_57216];
var inst_57223 = cljs.core.PersistentHashMap.fromArrays(inst_57218,inst_57222);
var inst_57224 = [inst_57223,(2)];
var inst_57225 = (new cljs.core.PersistentVector(null,2,(5),inst_57217,inst_57224,null));
var inst_57226 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57225);
var _ = (function (){var statearr_57237 = state_57231;
(statearr_57237[(4)] = cljs.core.rest.call(null,(state_57231[(4)])));

return statearr_57237;
})();
var state_57231__$1 = (function (){var statearr_57238 = state_57231;
(statearr_57238[(8)] = inst_57226);

return statearr_57238;
})();
var statearr_57239_57261 = state_57231__$1;
(statearr_57239_57261[(2)] = inst_57216);

(statearr_57239_57261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (2))){
var _ = (function (){var statearr_57240 = state_57231;
(statearr_57240[(4)] = cljs.core.cons.call(null,(5),(state_57231[(4)])));

return statearr_57240;
})();
var inst_57200 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57231__$1 = state_57231;
if(inst_57200){
var statearr_57241_57262 = state_57231__$1;
(statearr_57241_57262[(1)] = (6));

} else {
var statearr_57242_57263 = state_57231__$1;
(statearr_57242_57263[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (11))){
var state_57231__$1 = state_57231;
var statearr_57244_57264 = state_57231__$1;
(statearr_57244_57264[(2)] = d);

(statearr_57244_57264[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (9))){
var inst_57203 = (state_57231[(2)]);
var inst_57204 = fluree.db.util.async.throw_err.call(null,inst_57203);
var state_57231__$1 = state_57231;
var statearr_57245_57265 = state_57231__$1;
(statearr_57245_57265[(2)] = inst_57204);

(statearr_57245_57265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (5))){
var _ = (function (){var statearr_57246 = state_57231;
(statearr_57246[(4)] = cljs.core.rest.call(null,(state_57231[(4)])));

return statearr_57246;
})();
var state_57231__$1 = state_57231;
var ex57243 = (state_57231__$1[(2)]);
var statearr_57247_57266 = state_57231__$1;
(statearr_57247_57266[(5)] = ex57243);


if((ex57243 instanceof Error)){
var statearr_57248_57267 = state_57231__$1;
(statearr_57248_57267[(1)] = (4));

(statearr_57248_57267[(5)] = null);

} else {
throw ex57243;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57232 === (10))){
var state_57231__$1 = state_57231;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57231__$1,(13),d);
} else {
if((state_val_57232 === (8))){
var inst_57207 = (state_57231[(2)]);
var inst_57208 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57231__$1 = (function (){var statearr_57249 = state_57231;
(statearr_57249[(7)] = inst_57207);

return statearr_57249;
})();
if(inst_57208){
var statearr_57250_57268 = state_57231__$1;
(statearr_57250_57268[(1)] = (10));

} else {
var statearr_57251_57269 = state_57231__$1;
(statearr_57251_57269[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0 = (function (){
var statearr_57252 = [null,null,null,null,null,null,null,null,null];
(statearr_57252[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__);

(statearr_57252[(1)] = (1));

return statearr_57252;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1 = (function (state_57231){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57231);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57253){var ex__2749__auto__ = e57253;
var statearr_57254_57270 = state_57231;
(statearr_57254_57270[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57231[(4)]))){
var statearr_57255_57271 = state_57231;
(statearr_57255_57271[(1)] = cljs.core.first.call(null,(state_57231[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57272 = state_57231;
state_57231 = G__57272;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__ = function(state_57231){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1.call(this,state_57231);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57256 = f__2769__auto__.call(null);
(statearr_57256[(6)] = c__2768__auto__);

return statearr_57256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57310){
var state_val_57311 = (state_57310[(1)]);
if((state_val_57311 === (7))){
var state_57310__$1 = state_57310;
var statearr_57312_57336 = state_57310__$1;
(statearr_57312_57336[(2)] = n);

(statearr_57312_57336[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (1))){
var state_57310__$1 = state_57310;
var statearr_57313_57337 = state_57310__$1;
(statearr_57313_57337[(2)] = null);

(statearr_57313_57337[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (4))){
var inst_57273 = (state_57310[(2)]);
var state_57310__$1 = state_57310;
var statearr_57314_57338 = state_57310__$1;
(statearr_57314_57338[(2)] = inst_57273);

(statearr_57314_57338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (13))){
var inst_57290 = (state_57310[(2)]);
var inst_57291 = fluree.db.util.async.throw_err.call(null,inst_57290);
var state_57310__$1 = state_57310;
var statearr_57315_57339 = state_57310__$1;
(statearr_57315_57339[(2)] = inst_57291);

(statearr_57315_57339[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (6))){
var state_57310__$1 = state_57310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57310__$1,(9),n);
} else {
if((state_val_57311 === (3))){
var inst_57308 = (state_57310[(2)]);
var state_57310__$1 = state_57310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57310__$1,inst_57308);
} else {
if((state_val_57311 === (12))){
var inst_57286 = (state_57310[(7)]);
var inst_57294 = (state_57310[(2)]);
var inst_57295 = fluree.db.dbfunctions.internal.rem.call(null,inst_57286,inst_57294);
var inst_57296 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57297 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57299 = [inst_57286,inst_57294];
var inst_57300 = (new cljs.core.PersistentVector(null,2,(5),inst_57298,inst_57299,null));
var inst_57301 = ["rem",inst_57300,inst_57295];
var inst_57302 = cljs.core.PersistentHashMap.fromArrays(inst_57297,inst_57301);
var inst_57303 = [inst_57302,(2)];
var inst_57304 = (new cljs.core.PersistentVector(null,2,(5),inst_57296,inst_57303,null));
var inst_57305 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57304);
var _ = (function (){var statearr_57316 = state_57310;
(statearr_57316[(4)] = cljs.core.rest.call(null,(state_57310[(4)])));

return statearr_57316;
})();
var state_57310__$1 = (function (){var statearr_57317 = state_57310;
(statearr_57317[(8)] = inst_57305);

return statearr_57317;
})();
var statearr_57318_57340 = state_57310__$1;
(statearr_57318_57340[(2)] = inst_57295);

(statearr_57318_57340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (2))){
var _ = (function (){var statearr_57319 = state_57310;
(statearr_57319[(4)] = cljs.core.cons.call(null,(5),(state_57310[(4)])));

return statearr_57319;
})();
var inst_57279 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57310__$1 = state_57310;
if(inst_57279){
var statearr_57320_57341 = state_57310__$1;
(statearr_57320_57341[(1)] = (6));

} else {
var statearr_57321_57342 = state_57310__$1;
(statearr_57321_57342[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (11))){
var state_57310__$1 = state_57310;
var statearr_57323_57343 = state_57310__$1;
(statearr_57323_57343[(2)] = d);

(statearr_57323_57343[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (9))){
var inst_57282 = (state_57310[(2)]);
var inst_57283 = fluree.db.util.async.throw_err.call(null,inst_57282);
var state_57310__$1 = state_57310;
var statearr_57324_57344 = state_57310__$1;
(statearr_57324_57344[(2)] = inst_57283);

(statearr_57324_57344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (5))){
var _ = (function (){var statearr_57325 = state_57310;
(statearr_57325[(4)] = cljs.core.rest.call(null,(state_57310[(4)])));

return statearr_57325;
})();
var state_57310__$1 = state_57310;
var ex57322 = (state_57310__$1[(2)]);
var statearr_57326_57345 = state_57310__$1;
(statearr_57326_57345[(5)] = ex57322);


if((ex57322 instanceof Error)){
var statearr_57327_57346 = state_57310__$1;
(statearr_57327_57346[(1)] = (4));

(statearr_57327_57346[(5)] = null);

} else {
throw ex57322;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57311 === (10))){
var state_57310__$1 = state_57310;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57310__$1,(13),d);
} else {
if((state_val_57311 === (8))){
var inst_57286 = (state_57310[(2)]);
var inst_57287 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57310__$1 = (function (){var statearr_57328 = state_57310;
(statearr_57328[(7)] = inst_57286);

return statearr_57328;
})();
if(inst_57287){
var statearr_57329_57347 = state_57310__$1;
(statearr_57329_57347[(1)] = (10));

} else {
var statearr_57330_57348 = state_57310__$1;
(statearr_57330_57348[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0 = (function (){
var statearr_57331 = [null,null,null,null,null,null,null,null,null];
(statearr_57331[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__);

(statearr_57331[(1)] = (1));

return statearr_57331;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1 = (function (state_57310){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57332){var ex__2749__auto__ = e57332;
var statearr_57333_57349 = state_57310;
(statearr_57333_57349[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57310[(4)]))){
var statearr_57334_57350 = state_57310;
(statearr_57334_57350[(1)] = cljs.core.first.call(null,(state_57310[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57351 = state_57310;
state_57310 = G__57351;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__ = function(state_57310){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1.call(this,state_57310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57335 = f__2769__auto__.call(null);
(statearr_57335[(6)] = c__2768__auto__);

return statearr_57335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57378){
var state_val_57379 = (state_57378[(1)]);
if((state_val_57379 === (7))){
var state_57378__$1 = state_57378;
var statearr_57380_57399 = state_57378__$1;
(statearr_57380_57399[(2)] = x);

(statearr_57380_57399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57379 === (1))){
var state_57378__$1 = state_57378;
var statearr_57381_57400 = state_57378__$1;
(statearr_57381_57400[(2)] = null);

(statearr_57381_57400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57379 === (4))){
var inst_57352 = (state_57378[(2)]);
var state_57378__$1 = state_57378;
var statearr_57382_57401 = state_57378__$1;
(statearr_57382_57401[(2)] = inst_57352);

(statearr_57382_57401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57379 === (6))){
var state_57378__$1 = state_57378;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57378__$1,(9),x);
} else {
if((state_val_57379 === (3))){
var inst_57376 = (state_57378[(2)]);
var state_57378__$1 = state_57378;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57378__$1,inst_57376);
} else {
if((state_val_57379 === (2))){
var _ = (function (){var statearr_57384 = state_57378;
(statearr_57384[(4)] = cljs.core.cons.call(null,(5),(state_57378[(4)])));

return statearr_57384;
})();
var inst_57358 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_57378__$1 = state_57378;
if(inst_57358){
var statearr_57385_57402 = state_57378__$1;
(statearr_57385_57402[(1)] = (6));

} else {
var statearr_57386_57403 = state_57378__$1;
(statearr_57386_57403[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57379 === (9))){
var inst_57361 = (state_57378[(2)]);
var inst_57362 = fluree.db.util.async.throw_err.call(null,inst_57361);
var state_57378__$1 = state_57378;
var statearr_57387_57404 = state_57378__$1;
(statearr_57387_57404[(2)] = inst_57362);

(statearr_57387_57404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57379 === (5))){
var _ = (function (){var statearr_57388 = state_57378;
(statearr_57388[(4)] = cljs.core.rest.call(null,(state_57378[(4)])));

return statearr_57388;
})();
var state_57378__$1 = state_57378;
var ex57383 = (state_57378__$1[(2)]);
var statearr_57389_57405 = state_57378__$1;
(statearr_57389_57405[(5)] = ex57383);


if((ex57383 instanceof Error)){
var statearr_57390_57406 = state_57378__$1;
(statearr_57390_57406[(1)] = (4));

(statearr_57390_57406[(5)] = null);

} else {
throw ex57383;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57379 === (8))){
var inst_57365 = (state_57378[(2)]);
var inst_57366 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_57365);
var inst_57367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57368 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57369 = ["boolean",inst_57365,inst_57366];
var inst_57370 = cljs.core.PersistentHashMap.fromArrays(inst_57368,inst_57369);
var inst_57371 = [inst_57370,(10)];
var inst_57372 = (new cljs.core.PersistentVector(null,2,(5),inst_57367,inst_57371,null));
var inst_57373 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57372);
var _ = (function (){var statearr_57391 = state_57378;
(statearr_57391[(4)] = cljs.core.rest.call(null,(state_57378[(4)])));

return statearr_57391;
})();
var state_57378__$1 = (function (){var statearr_57392 = state_57378;
(statearr_57392[(7)] = inst_57373);

return statearr_57392;
})();
var statearr_57393_57407 = state_57378__$1;
(statearr_57393_57407[(2)] = inst_57366);

(statearr_57393_57407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0 = (function (){
var statearr_57394 = [null,null,null,null,null,null,null,null];
(statearr_57394[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__);

(statearr_57394[(1)] = (1));

return statearr_57394;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1 = (function (state_57378){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57378);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57395){var ex__2749__auto__ = e57395;
var statearr_57396_57408 = state_57378;
(statearr_57396_57408[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57378[(4)]))){
var statearr_57397_57409 = state_57378;
(statearr_57397_57409[(1)] = cljs.core.first.call(null,(state_57378[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57410 = state_57378;
state_57378 = G__57410;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__ = function(state_57378){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1.call(this,state_57378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57398 = f__2769__auto__.call(null);
(statearr_57398[(6)] = c__2768__auto__);

return statearr_57398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57448){
var state_val_57449 = (state_57448[(1)]);
if((state_val_57449 === (7))){
var state_57448__$1 = state_57448;
var statearr_57450_57474 = state_57448__$1;
(statearr_57450_57474[(2)] = pattern);

(statearr_57450_57474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (1))){
var state_57448__$1 = state_57448;
var statearr_57451_57475 = state_57448__$1;
(statearr_57451_57475[(2)] = null);

(statearr_57451_57475[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (4))){
var inst_57411 = (state_57448[(2)]);
var state_57448__$1 = state_57448;
var statearr_57452_57476 = state_57448__$1;
(statearr_57452_57476[(2)] = inst_57411);

(statearr_57452_57476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (13))){
var inst_57428 = (state_57448[(2)]);
var inst_57429 = fluree.db.util.async.throw_err.call(null,inst_57428);
var state_57448__$1 = state_57448;
var statearr_57453_57477 = state_57448__$1;
(statearr_57453_57477[(2)] = inst_57429);

(statearr_57453_57477[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (6))){
var state_57448__$1 = state_57448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57448__$1,(9),pattern);
} else {
if((state_val_57449 === (3))){
var inst_57446 = (state_57448[(2)]);
var state_57448__$1 = state_57448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57448__$1,inst_57446);
} else {
if((state_val_57449 === (12))){
var inst_57424 = (state_57448[(7)]);
var inst_57432 = (state_57448[(2)]);
var inst_57433 = fluree.db.dbfunctions.internal.re_find.call(null,inst_57424,inst_57432);
var inst_57434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57435 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57437 = [inst_57424,inst_57432];
var inst_57438 = (new cljs.core.PersistentVector(null,2,(5),inst_57436,inst_57437,null));
var inst_57439 = ["re-find",inst_57438,inst_57433];
var inst_57440 = cljs.core.PersistentHashMap.fromArrays(inst_57435,inst_57439);
var inst_57441 = [inst_57440,(10)];
var inst_57442 = (new cljs.core.PersistentVector(null,2,(5),inst_57434,inst_57441,null));
var inst_57443 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57442);
var _ = (function (){var statearr_57454 = state_57448;
(statearr_57454[(4)] = cljs.core.rest.call(null,(state_57448[(4)])));

return statearr_57454;
})();
var state_57448__$1 = (function (){var statearr_57455 = state_57448;
(statearr_57455[(8)] = inst_57443);

return statearr_57455;
})();
var statearr_57456_57478 = state_57448__$1;
(statearr_57456_57478[(2)] = inst_57433);

(statearr_57456_57478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (2))){
var _ = (function (){var statearr_57457 = state_57448;
(statearr_57457[(4)] = cljs.core.cons.call(null,(5),(state_57448[(4)])));

return statearr_57457;
})();
var inst_57417 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_57448__$1 = state_57448;
if(inst_57417){
var statearr_57458_57479 = state_57448__$1;
(statearr_57458_57479[(1)] = (6));

} else {
var statearr_57459_57480 = state_57448__$1;
(statearr_57459_57480[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (11))){
var state_57448__$1 = state_57448;
var statearr_57461_57481 = state_57448__$1;
(statearr_57461_57481[(2)] = string);

(statearr_57461_57481[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (9))){
var inst_57420 = (state_57448[(2)]);
var inst_57421 = fluree.db.util.async.throw_err.call(null,inst_57420);
var state_57448__$1 = state_57448;
var statearr_57462_57482 = state_57448__$1;
(statearr_57462_57482[(2)] = inst_57421);

(statearr_57462_57482[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (5))){
var _ = (function (){var statearr_57463 = state_57448;
(statearr_57463[(4)] = cljs.core.rest.call(null,(state_57448[(4)])));

return statearr_57463;
})();
var state_57448__$1 = state_57448;
var ex57460 = (state_57448__$1[(2)]);
var statearr_57464_57483 = state_57448__$1;
(statearr_57464_57483[(5)] = ex57460);


if((ex57460 instanceof Error)){
var statearr_57465_57484 = state_57448__$1;
(statearr_57465_57484[(1)] = (4));

(statearr_57465_57484[(5)] = null);

} else {
throw ex57460;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57449 === (10))){
var state_57448__$1 = state_57448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57448__$1,(13),string);
} else {
if((state_val_57449 === (8))){
var inst_57424 = (state_57448[(2)]);
var inst_57425 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_57448__$1 = (function (){var statearr_57466 = state_57448;
(statearr_57466[(7)] = inst_57424);

return statearr_57466;
})();
if(inst_57425){
var statearr_57467_57485 = state_57448__$1;
(statearr_57467_57485[(1)] = (10));

} else {
var statearr_57468_57486 = state_57448__$1;
(statearr_57468_57486[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0 = (function (){
var statearr_57469 = [null,null,null,null,null,null,null,null,null];
(statearr_57469[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__);

(statearr_57469[(1)] = (1));

return statearr_57469;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1 = (function (state_57448){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57470){var ex__2749__auto__ = e57470;
var statearr_57471_57487 = state_57448;
(statearr_57471_57487[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57448[(4)]))){
var statearr_57472_57488 = state_57448;
(statearr_57472_57488[(1)] = cljs.core.first.call(null,(state_57448[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57489 = state_57448;
state_57448 = G__57489;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__ = function(state_57448){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1.call(this,state_57448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57473 = f__2769__auto__.call(null);
(statearr_57473[(6)] = c__2768__auto__);

return statearr_57473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57516){
var state_val_57517 = (state_57516[(1)]);
if((state_val_57517 === (7))){
var state_57516__$1 = state_57516;
var statearr_57518_57537 = state_57516__$1;
(statearr_57518_57537[(2)] = email);

(statearr_57518_57537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57517 === (1))){
var state_57516__$1 = state_57516;
var statearr_57519_57538 = state_57516__$1;
(statearr_57519_57538[(2)] = null);

(statearr_57519_57538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57517 === (4))){
var inst_57490 = (state_57516[(2)]);
var state_57516__$1 = state_57516;
var statearr_57520_57539 = state_57516__$1;
(statearr_57520_57539[(2)] = inst_57490);

(statearr_57520_57539[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57517 === (6))){
var state_57516__$1 = state_57516;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57516__$1,(9),email);
} else {
if((state_val_57517 === (3))){
var inst_57514 = (state_57516[(2)]);
var state_57516__$1 = state_57516;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57516__$1,inst_57514);
} else {
if((state_val_57517 === (2))){
var _ = (function (){var statearr_57522 = state_57516;
(statearr_57522[(4)] = cljs.core.cons.call(null,(5),(state_57516[(4)])));

return statearr_57522;
})();
var inst_57496 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_57516__$1 = state_57516;
if(inst_57496){
var statearr_57523_57540 = state_57516__$1;
(statearr_57523_57540[(1)] = (6));

} else {
var statearr_57524_57541 = state_57516__$1;
(statearr_57524_57541[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57517 === (9))){
var inst_57499 = (state_57516[(2)]);
var inst_57500 = fluree.db.util.async.throw_err.call(null,inst_57499);
var state_57516__$1 = state_57516;
var statearr_57525_57542 = state_57516__$1;
(statearr_57525_57542[(2)] = inst_57500);

(statearr_57525_57542[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57517 === (5))){
var _ = (function (){var statearr_57526 = state_57516;
(statearr_57526[(4)] = cljs.core.rest.call(null,(state_57516[(4)])));

return statearr_57526;
})();
var state_57516__$1 = state_57516;
var ex57521 = (state_57516__$1[(2)]);
var statearr_57527_57543 = state_57516__$1;
(statearr_57527_57543[(5)] = ex57521);


if((ex57521 instanceof Error)){
var statearr_57528_57544 = state_57516__$1;
(statearr_57528_57544[(1)] = (4));

(statearr_57528_57544[(5)] = null);

} else {
throw ex57521;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57517 === (8))){
var inst_57503 = (state_57516[(2)]);
var inst_57504 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_57503);
var inst_57505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57506 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57507 = ["re-find",inst_57503,inst_57504];
var inst_57508 = cljs.core.PersistentHashMap.fromArrays(inst_57506,inst_57507);
var inst_57509 = [inst_57508,(10)];
var inst_57510 = (new cljs.core.PersistentVector(null,2,(5),inst_57505,inst_57509,null));
var inst_57511 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57510);
var _ = (function (){var statearr_57529 = state_57516;
(statearr_57529[(4)] = cljs.core.rest.call(null,(state_57516[(4)])));

return statearr_57529;
})();
var state_57516__$1 = (function (){var statearr_57530 = state_57516;
(statearr_57530[(7)] = inst_57511);

return statearr_57530;
})();
var statearr_57531_57545 = state_57516__$1;
(statearr_57531_57545[(2)] = inst_57504);

(statearr_57531_57545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0 = (function (){
var statearr_57532 = [null,null,null,null,null,null,null,null];
(statearr_57532[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__);

(statearr_57532[(1)] = (1));

return statearr_57532;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1 = (function (state_57516){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57516);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57533){var ex__2749__auto__ = e57533;
var statearr_57534_57546 = state_57516;
(statearr_57534_57546[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57516[(4)]))){
var statearr_57535_57547 = state_57516;
(statearr_57535_57547[(1)] = cljs.core.first.call(null,(state_57516[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57548 = state_57516;
state_57516 = G__57548;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__ = function(state_57516){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1.call(this,state_57516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57536 = f__2769__auto__.call(null);
(statearr_57536[(6)] = c__2768__auto__);

return statearr_57536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57595){
var state_val_57596 = (state_57595[(1)]);
if((state_val_57596 === (7))){
var inst_57565 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57595__$1 = state_57595;
if(cljs.core.truth_(inst_57565)){
var statearr_57597_57624 = state_57595__$1;
(statearr_57597_57624[(1)] = (9));

} else {
var statearr_57598_57625 = state_57595__$1;
(statearr_57598_57625[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (1))){
var state_57595__$1 = state_57595;
var statearr_57599_57626 = state_57595__$1;
(statearr_57599_57626[(2)] = null);

(statearr_57599_57626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (4))){
var inst_57549 = (state_57595[(2)]);
var state_57595__$1 = state_57595;
var statearr_57600_57627 = state_57595__$1;
(statearr_57600_57627[(2)] = inst_57549);

(statearr_57600_57627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (15))){
var inst_57576 = (state_57595[(2)]);
var state_57595__$1 = state_57595;
var statearr_57601_57628 = state_57595__$1;
(statearr_57601_57628[(2)] = inst_57576);

(statearr_57601_57628[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (13))){
var inst_57573 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57595__$1 = state_57595;
var statearr_57602_57629 = state_57595__$1;
(statearr_57602_57629[(2)] = inst_57573);

(statearr_57602_57629[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (6))){
var inst_57560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57561 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57562 = [inst_57561,(0)];
var inst_57563 = (new cljs.core.PersistentVector(null,2,(5),inst_57560,inst_57562,null));
var state_57595__$1 = state_57595;
var statearr_57603_57630 = state_57595__$1;
(statearr_57603_57630[(2)] = inst_57563);

(statearr_57603_57630[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (3))){
var inst_57593 = (state_57595[(2)]);
var state_57595__$1 = state_57595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57595__$1,inst_57593);
} else {
if((state_val_57596 === (12))){
var inst_57569 = (state_57595[(2)]);
var inst_57570 = fluree.db.util.async.throw_err.call(null,inst_57569);
var state_57595__$1 = state_57595;
var statearr_57604_57631 = state_57595__$1;
(statearr_57604_57631[(2)] = inst_57570);

(statearr_57604_57631[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (2))){
var _ = (function (){var statearr_57605 = state_57595;
(statearr_57605[(4)] = cljs.core.cons.call(null,(5),(state_57595[(4)])));

return statearr_57605;
})();
var inst_57558 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57595__$1 = state_57595;
if(cljs.core.truth_(inst_57558)){
var statearr_57606_57632 = state_57595__$1;
(statearr_57606_57632[(1)] = (6));

} else {
var statearr_57607_57633 = state_57595__$1;
(statearr_57607_57633[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (11))){
var inst_57578 = (state_57595[(2)]);
var state_57595__$1 = state_57595;
var statearr_57609_57634 = state_57595__$1;
(statearr_57609_57634[(2)] = inst_57578);

(statearr_57609_57634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (9))){
var inst_57567 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_57595__$1 = state_57595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57595__$1,(12),inst_57567);
} else {
if((state_val_57596 === (5))){
var _ = (function (){var statearr_57610 = state_57595;
(statearr_57610[(4)] = cljs.core.rest.call(null,(state_57595[(4)])));

return statearr_57610;
})();
var state_57595__$1 = state_57595;
var ex57608 = (state_57595__$1[(2)]);
var statearr_57611_57635 = state_57595__$1;
(statearr_57611_57635[(5)] = ex57608);


if((ex57608 instanceof Error)){
var statearr_57612_57636 = state_57595__$1;
(statearr_57612_57636[(1)] = (4));

(statearr_57612_57636[(5)] = null);

} else {
throw ex57608;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (14))){
var state_57595__$1 = state_57595;
var statearr_57613_57637 = state_57595__$1;
(statearr_57613_57637[(2)] = null);

(statearr_57613_57637[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (10))){
var state_57595__$1 = state_57595;
var statearr_57614_57638 = state_57595__$1;
(statearr_57614_57638[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57596 === (8))){
var inst_57580 = (state_57595[(2)]);
var inst_57581 = cljs.core.nth.call(null,inst_57580,(0),null);
var inst_57582 = cljs.core.nth.call(null,inst_57580,(1),null);
var inst_57583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57584 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57585 = ["?user_id","?ctx",inst_57581];
var inst_57586 = cljs.core.PersistentHashMap.fromArrays(inst_57584,inst_57585);
var inst_57587 = ((10) + inst_57582);
var inst_57588 = [inst_57586,inst_57587];
var inst_57589 = (new cljs.core.PersistentVector(null,2,(5),inst_57583,inst_57588,null));
var inst_57590 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57589);
var _ = (function (){var statearr_57616 = state_57595;
(statearr_57616[(4)] = cljs.core.rest.call(null,(state_57595[(4)])));

return statearr_57616;
})();
var state_57595__$1 = (function (){var statearr_57617 = state_57595;
(statearr_57617[(7)] = inst_57590);

return statearr_57617;
})();
var statearr_57618_57639 = state_57595__$1;
(statearr_57618_57639[(2)] = inst_57581);

(statearr_57618_57639[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0 = (function (){
var statearr_57619 = [null,null,null,null,null,null,null,null];
(statearr_57619[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__);

(statearr_57619[(1)] = (1));

return statearr_57619;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1 = (function (state_57595){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57620){var ex__2749__auto__ = e57620;
var statearr_57621_57640 = state_57595;
(statearr_57621_57640[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57595[(4)]))){
var statearr_57622_57641 = state_57595;
(statearr_57622_57641[(1)] = cljs.core.first.call(null,(state_57595[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57642 = state_57595;
state_57595 = G__57642;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__ = function(state_57595){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1.call(this,state_57595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57623 = f__2769__auto__.call(null);
(statearr_57623[(6)] = c__2768__auto__);

return statearr_57623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57670){
var state_val_57671 = (state_57670[(1)]);
if((state_val_57671 === (7))){
var inst_57663 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57670__$1 = state_57670;
var statearr_57672_57691 = state_57670__$1;
(statearr_57672_57691[(2)] = inst_57663);

(statearr_57672_57691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57671 === (1))){
var state_57670__$1 = state_57670;
var statearr_57673_57692 = state_57670__$1;
(statearr_57673_57692[(2)] = null);

(statearr_57673_57692[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57671 === (4))){
var inst_57643 = (state_57670[(2)]);
var state_57670__$1 = state_57670;
var statearr_57674_57693 = state_57670__$1;
(statearr_57674_57693[(2)] = inst_57643);

(statearr_57674_57693[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57671 === (6))){
var inst_57651 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_57670__$1 = state_57670;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57670__$1,(9),inst_57651);
} else {
if((state_val_57671 === (3))){
var inst_57668 = (state_57670[(2)]);
var state_57670__$1 = state_57670;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57670__$1,inst_57668);
} else {
if((state_val_57671 === (2))){
var _ = (function (){var statearr_57676 = state_57670;
(statearr_57676[(4)] = cljs.core.cons.call(null,(5),(state_57670[(4)])));

return statearr_57676;
})();
var inst_57649 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57670__$1 = state_57670;
if(cljs.core.truth_(inst_57649)){
var statearr_57677_57694 = state_57670__$1;
(statearr_57677_57694[(1)] = (6));

} else {
var statearr_57678_57695 = state_57670__$1;
(statearr_57678_57695[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57671 === (9))){
var inst_57653 = (state_57670[(2)]);
var inst_57654 = fluree.db.util.async.throw_err.call(null,inst_57653);
var inst_57655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57656 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57657 = ["?auth_id","?ctx",inst_57654];
var inst_57658 = cljs.core.PersistentHashMap.fromArrays(inst_57656,inst_57657);
var inst_57659 = [inst_57658,(10)];
var inst_57660 = (new cljs.core.PersistentVector(null,2,(5),inst_57655,inst_57659,null));
var inst_57661 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57660);
var state_57670__$1 = (function (){var statearr_57679 = state_57670;
(statearr_57679[(7)] = inst_57661);

return statearr_57679;
})();
var statearr_57680_57696 = state_57670__$1;
(statearr_57680_57696[(2)] = inst_57654);

(statearr_57680_57696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57671 === (5))){
var _ = (function (){var statearr_57681 = state_57670;
(statearr_57681[(4)] = cljs.core.rest.call(null,(state_57670[(4)])));

return statearr_57681;
})();
var state_57670__$1 = state_57670;
var ex57675 = (state_57670__$1[(2)]);
var statearr_57682_57697 = state_57670__$1;
(statearr_57682_57697[(5)] = ex57675);


if((ex57675 instanceof Error)){
var statearr_57683_57698 = state_57670__$1;
(statearr_57683_57698[(1)] = (4));

(statearr_57683_57698[(5)] = null);

} else {
throw ex57675;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57671 === (8))){
var inst_57665 = (state_57670[(2)]);
var _ = (function (){var statearr_57684 = state_57670;
(statearr_57684[(4)] = cljs.core.rest.call(null,(state_57670[(4)])));

return statearr_57684;
})();
var state_57670__$1 = state_57670;
var statearr_57685_57699 = state_57670__$1;
(statearr_57685_57699[(2)] = inst_57665);

(statearr_57685_57699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0 = (function (){
var statearr_57686 = [null,null,null,null,null,null,null,null];
(statearr_57686[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__);

(statearr_57686[(1)] = (1));

return statearr_57686;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1 = (function (state_57670){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57670);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57687){var ex__2749__auto__ = e57687;
var statearr_57688_57700 = state_57670;
(statearr_57688_57700[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57670[(4)]))){
var statearr_57689_57701 = state_57670;
(statearr_57689_57701[(1)] = cljs.core.first.call(null,(state_57670[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57702 = state_57670;
state_57670 = G__57702;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__ = function(state_57670){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1.call(this,state_57670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57690 = f__2769__auto__.call(null);
(statearr_57690[(6)] = c__2768__auto__);

return statearr_57690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57704 = arguments.length;
switch (G__57704) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57746){
var state_val_57747 = (state_57746[(1)]);
if((state_val_57747 === (7))){
var state_57746__$1 = state_57746;
var statearr_57748_57778 = state_57746__$1;
(statearr_57748_57778[(2)] = seed);

(statearr_57748_57778[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (1))){
var state_57746__$1 = state_57746;
var statearr_57749_57779 = state_57746__$1;
(statearr_57749_57779[(2)] = null);

(statearr_57749_57779[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (4))){
var inst_57705 = (state_57746[(2)]);
var state_57746__$1 = state_57746;
var statearr_57750_57780 = state_57746__$1;
(statearr_57750_57780[(2)] = inst_57705);

(statearr_57750_57780[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (15))){
var state_57746__$1 = state_57746;
var statearr_57751_57781 = state_57746__$1;
(statearr_57751_57781[(2)] = (10));

(statearr_57751_57781[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (13))){
var inst_57722 = (state_57746[(2)]);
var inst_57723 = fluree.db.util.async.throw_err.call(null,inst_57722);
var state_57746__$1 = state_57746;
var statearr_57752_57782 = state_57746__$1;
(statearr_57752_57782[(2)] = inst_57723);

(statearr_57752_57782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (6))){
var state_57746__$1 = state_57746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57746__$1,(9),seed);
} else {
if((state_val_57747 === (3))){
var inst_57744 = (state_57746[(2)]);
var state_57746__$1 = state_57746;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57746__$1,inst_57744);
} else {
if((state_val_57747 === (12))){
var inst_57726 = (state_57746[(7)]);
var inst_57726__$1 = (state_57746[(2)]);
var state_57746__$1 = (function (){var statearr_57753 = state_57746;
(statearr_57753[(7)] = inst_57726__$1);

return statearr_57753;
})();
if(cljs.core.truth_(inst_57726__$1)){
var statearr_57754_57783 = state_57746__$1;
(statearr_57754_57783[(1)] = (14));

} else {
var statearr_57755_57784 = state_57746__$1;
(statearr_57755_57784[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (2))){
var _ = (function (){var statearr_57756 = state_57746;
(statearr_57756[(4)] = cljs.core.cons.call(null,(5),(state_57746[(4)])));

return statearr_57756;
})();
var inst_57711 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_57746__$1 = state_57746;
if(inst_57711){
var statearr_57757_57785 = state_57746__$1;
(statearr_57757_57785[(1)] = (6));

} else {
var statearr_57758_57786 = state_57746__$1;
(statearr_57758_57786[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (11))){
var state_57746__$1 = state_57746;
var statearr_57760_57787 = state_57746__$1;
(statearr_57760_57787[(2)] = max);

(statearr_57760_57787[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (9))){
var inst_57714 = (state_57746[(2)]);
var inst_57715 = fluree.db.util.async.throw_err.call(null,inst_57714);
var state_57746__$1 = state_57746;
var statearr_57761_57788 = state_57746__$1;
(statearr_57761_57788[(2)] = inst_57715);

(statearr_57761_57788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (5))){
var _ = (function (){var statearr_57762 = state_57746;
(statearr_57762[(4)] = cljs.core.rest.call(null,(state_57746[(4)])));

return statearr_57762;
})();
var state_57746__$1 = state_57746;
var ex57759 = (state_57746__$1[(2)]);
var statearr_57763_57789 = state_57746__$1;
(statearr_57763_57789[(5)] = ex57759);


if((ex57759 instanceof Error)){
var statearr_57764_57790 = state_57746__$1;
(statearr_57764_57790[(1)] = (4));

(statearr_57764_57790[(5)] = null);

} else {
throw ex57759;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (14))){
var inst_57726 = (state_57746[(7)]);
var state_57746__$1 = state_57746;
var statearr_57765_57791 = state_57746__$1;
(statearr_57765_57791[(2)] = inst_57726);

(statearr_57765_57791[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (16))){
var inst_57718 = (state_57746[(8)]);
var inst_57730 = (state_57746[(2)]);
var inst_57731 = fluree.db.dbfunctions.internal.rand.call(null,inst_57718,inst_57730);
var inst_57732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57733 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57734 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57735 = [max,seed];
var inst_57736 = (new cljs.core.PersistentVector(null,2,(5),inst_57734,inst_57735,null));
var inst_57737 = ["rand",inst_57736,inst_57731];
var inst_57738 = cljs.core.PersistentHashMap.fromArrays(inst_57733,inst_57737);
var inst_57739 = [inst_57738,(10)];
var inst_57740 = (new cljs.core.PersistentVector(null,2,(5),inst_57732,inst_57739,null));
var inst_57741 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57740);
var _ = (function (){var statearr_57766 = state_57746;
(statearr_57766[(4)] = cljs.core.rest.call(null,(state_57746[(4)])));

return statearr_57766;
})();
var state_57746__$1 = (function (){var statearr_57767 = state_57746;
(statearr_57767[(9)] = inst_57741);

return statearr_57767;
})();
var statearr_57768_57792 = state_57746__$1;
(statearr_57768_57792[(2)] = inst_57731);

(statearr_57768_57792[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57747 === (10))){
var state_57746__$1 = state_57746;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57746__$1,(13),max);
} else {
if((state_val_57747 === (8))){
var inst_57718 = (state_57746[(2)]);
var inst_57719 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_57746__$1 = (function (){var statearr_57769 = state_57746;
(statearr_57769[(8)] = inst_57718);

return statearr_57769;
})();
if(inst_57719){
var statearr_57770_57793 = state_57746__$1;
(statearr_57770_57793[(1)] = (10));

} else {
var statearr_57771_57794 = state_57746__$1;
(statearr_57771_57794[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2746__auto____0 = (function (){
var statearr_57772 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57772[(0)] = fluree$db$dbfunctions$fns$state_machine__2746__auto__);

(statearr_57772[(1)] = (1));

return statearr_57772;
});
var fluree$db$dbfunctions$fns$state_machine__2746__auto____1 = (function (state_57746){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57746);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57773){var ex__2749__auto__ = e57773;
var statearr_57774_57795 = state_57746;
(statearr_57774_57795[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57746[(4)]))){
var statearr_57775_57796 = state_57746;
(statearr_57775_57796[(1)] = cljs.core.first.call(null,(state_57746[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57797 = state_57746;
state_57746 = G__57797;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2746__auto__ = function(state_57746){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2746__auto____1.call(this,state_57746);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57776 = f__2769__auto__.call(null);
(statearr_57776[(6)] = c__2768__auto__);

return statearr_57776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57818){
var state_val_57819 = (state_57818[(1)]);
if((state_val_57819 === (1))){
var state_57818__$1 = state_57818;
var statearr_57820_57835 = state_57818__$1;
(statearr_57820_57835[(2)] = null);

(statearr_57820_57835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57819 === (2))){
var _ = (function (){var statearr_57821 = state_57818;
(statearr_57821[(4)] = cljs.core.cons.call(null,(5),(state_57818[(4)])));

return statearr_57821;
})();
var inst_57804 = cljs.core.random_uuid.call(null);
var inst_57805 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57804);
var inst_57806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57807 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57808 = cljs.core.PersistentVector.EMPTY;
var inst_57809 = ["uuid",inst_57808,inst_57805];
var inst_57810 = cljs.core.PersistentHashMap.fromArrays(inst_57807,inst_57809);
var inst_57811 = [inst_57810,(10)];
var inst_57812 = (new cljs.core.PersistentVector(null,2,(5),inst_57806,inst_57811,null));
var inst_57813 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57812);
var ___$1 = (function (){var statearr_57822 = state_57818;
(statearr_57822[(4)] = cljs.core.rest.call(null,(state_57818[(4)])));

return statearr_57822;
})();
var state_57818__$1 = (function (){var statearr_57823 = state_57818;
(statearr_57823[(7)] = inst_57813);

return statearr_57823;
})();
var statearr_57824_57836 = state_57818__$1;
(statearr_57824_57836[(2)] = inst_57805);

(statearr_57824_57836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57819 === (3))){
var inst_57816 = (state_57818[(2)]);
var state_57818__$1 = state_57818;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57818__$1,inst_57816);
} else {
if((state_val_57819 === (4))){
var inst_57798 = (state_57818[(2)]);
var state_57818__$1 = state_57818;
var statearr_57826_57837 = state_57818__$1;
(statearr_57826_57837[(2)] = inst_57798);

(statearr_57826_57837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57819 === (5))){
var _ = (function (){var statearr_57827 = state_57818;
(statearr_57827[(4)] = cljs.core.rest.call(null,(state_57818[(4)])));

return statearr_57827;
})();
var state_57818__$1 = state_57818;
var ex57825 = (state_57818__$1[(2)]);
var statearr_57828_57838 = state_57818__$1;
(statearr_57828_57838[(5)] = ex57825);


if((ex57825 instanceof Error)){
var statearr_57829_57839 = state_57818__$1;
(statearr_57829_57839[(1)] = (4));

(statearr_57829_57839[(5)] = null);

} else {
throw ex57825;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0 = (function (){
var statearr_57830 = [null,null,null,null,null,null,null,null];
(statearr_57830[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__);

(statearr_57830[(1)] = (1));

return statearr_57830;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1 = (function (state_57818){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57818);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57831){var ex__2749__auto__ = e57831;
var statearr_57832_57840 = state_57818;
(statearr_57832_57840[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57818[(4)]))){
var statearr_57833_57841 = state_57818;
(statearr_57833_57841[(1)] = cljs.core.first.call(null,(state_57818[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57842 = state_57818;
state_57818 = G__57842;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__ = function(state_57818){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1.call(this,state_57818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57834 = f__2769__auto__.call(null);
(statearr_57834[(6)] = c__2768__auto__);

return statearr_57834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57872){
var state_val_57873 = (state_57872[(1)]);
if((state_val_57873 === (7))){
var state_57872__$1 = state_57872;
var statearr_57874_57893 = state_57872__$1;
(statearr_57874_57893[(2)] = num);

(statearr_57874_57893[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57873 === (1))){
var state_57872__$1 = state_57872;
var statearr_57875_57894 = state_57872__$1;
(statearr_57875_57894[(2)] = null);

(statearr_57875_57894[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57873 === (4))){
var inst_57843 = (state_57872[(2)]);
var state_57872__$1 = state_57872;
var statearr_57876_57895 = state_57872__$1;
(statearr_57876_57895[(2)] = inst_57843);

(statearr_57876_57895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57873 === (6))){
var state_57872__$1 = state_57872;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57872__$1,(9),num);
} else {
if((state_val_57873 === (3))){
var inst_57870 = (state_57872[(2)]);
var state_57872__$1 = state_57872;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57872__$1,inst_57870);
} else {
if((state_val_57873 === (2))){
var _ = (function (){var statearr_57878 = state_57872;
(statearr_57878[(4)] = cljs.core.cons.call(null,(5),(state_57872[(4)])));

return statearr_57878;
})();
var inst_57849 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57872__$1 = state_57872;
if(inst_57849){
var statearr_57879_57896 = state_57872__$1;
(statearr_57879_57896[(1)] = (6));

} else {
var statearr_57880_57897 = state_57872__$1;
(statearr_57880_57897[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57873 === (9))){
var inst_57852 = (state_57872[(2)]);
var inst_57853 = fluree.db.util.async.throw_err.call(null,inst_57852);
var state_57872__$1 = state_57872;
var statearr_57881_57898 = state_57872__$1;
(statearr_57881_57898[(2)] = inst_57853);

(statearr_57881_57898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57873 === (5))){
var _ = (function (){var statearr_57882 = state_57872;
(statearr_57882[(4)] = cljs.core.rest.call(null,(state_57872[(4)])));

return statearr_57882;
})();
var state_57872__$1 = state_57872;
var ex57877 = (state_57872__$1[(2)]);
var statearr_57883_57899 = state_57872__$1;
(statearr_57883_57899[(5)] = ex57877);


if((ex57877 instanceof Error)){
var statearr_57884_57900 = state_57872__$1;
(statearr_57884_57900[(1)] = (4));

(statearr_57884_57900[(5)] = null);

} else {
throw ex57877;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57873 === (8))){
var inst_57856 = (state_57872[(2)]);
var inst_57857 = fluree.db.dbfunctions.internal.ceil.call(null,inst_57856);
var inst_57858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57859 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57860 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57861 = [fluree.db.dbfunctions.fns.ceil];
var inst_57862 = (new cljs.core.PersistentVector(null,1,(5),inst_57860,inst_57861,null));
var inst_57863 = ["",inst_57862,inst_57857];
var inst_57864 = cljs.core.PersistentHashMap.fromArrays(inst_57859,inst_57863);
var inst_57865 = [inst_57864,(10)];
var inst_57866 = (new cljs.core.PersistentVector(null,2,(5),inst_57858,inst_57865,null));
var inst_57867 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57866);
var _ = (function (){var statearr_57885 = state_57872;
(statearr_57885[(4)] = cljs.core.rest.call(null,(state_57872[(4)])));

return statearr_57885;
})();
var state_57872__$1 = (function (){var statearr_57886 = state_57872;
(statearr_57886[(7)] = inst_57867);

return statearr_57886;
})();
var statearr_57887_57901 = state_57872__$1;
(statearr_57887_57901[(2)] = inst_57857);

(statearr_57887_57901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0 = (function (){
var statearr_57888 = [null,null,null,null,null,null,null,null];
(statearr_57888[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__);

(statearr_57888[(1)] = (1));

return statearr_57888;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1 = (function (state_57872){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57872);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57889){var ex__2749__auto__ = e57889;
var statearr_57890_57902 = state_57872;
(statearr_57890_57902[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57872[(4)]))){
var statearr_57891_57903 = state_57872;
(statearr_57891_57903[(1)] = cljs.core.first.call(null,(state_57872[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57904 = state_57872;
state_57872 = G__57904;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__ = function(state_57872){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1.call(this,state_57872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57892 = f__2769__auto__.call(null);
(statearr_57892[(6)] = c__2768__auto__);

return statearr_57892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57934){
var state_val_57935 = (state_57934[(1)]);
if((state_val_57935 === (7))){
var state_57934__$1 = state_57934;
var statearr_57936_57955 = state_57934__$1;
(statearr_57936_57955[(2)] = num);

(statearr_57936_57955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57935 === (1))){
var state_57934__$1 = state_57934;
var statearr_57937_57956 = state_57934__$1;
(statearr_57937_57956[(2)] = null);

(statearr_57937_57956[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57935 === (4))){
var inst_57905 = (state_57934[(2)]);
var state_57934__$1 = state_57934;
var statearr_57938_57957 = state_57934__$1;
(statearr_57938_57957[(2)] = inst_57905);

(statearr_57938_57957[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57935 === (6))){
var state_57934__$1 = state_57934;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57934__$1,(9),num);
} else {
if((state_val_57935 === (3))){
var inst_57932 = (state_57934[(2)]);
var state_57934__$1 = state_57934;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57934__$1,inst_57932);
} else {
if((state_val_57935 === (2))){
var _ = (function (){var statearr_57940 = state_57934;
(statearr_57940[(4)] = cljs.core.cons.call(null,(5),(state_57934[(4)])));

return statearr_57940;
})();
var inst_57911 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57934__$1 = state_57934;
if(inst_57911){
var statearr_57941_57958 = state_57934__$1;
(statearr_57941_57958[(1)] = (6));

} else {
var statearr_57942_57959 = state_57934__$1;
(statearr_57942_57959[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57935 === (9))){
var inst_57914 = (state_57934[(2)]);
var inst_57915 = fluree.db.util.async.throw_err.call(null,inst_57914);
var state_57934__$1 = state_57934;
var statearr_57943_57960 = state_57934__$1;
(statearr_57943_57960[(2)] = inst_57915);

(statearr_57943_57960[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57935 === (5))){
var _ = (function (){var statearr_57944 = state_57934;
(statearr_57944[(4)] = cljs.core.rest.call(null,(state_57934[(4)])));

return statearr_57944;
})();
var state_57934__$1 = state_57934;
var ex57939 = (state_57934__$1[(2)]);
var statearr_57945_57961 = state_57934__$1;
(statearr_57945_57961[(5)] = ex57939);


if((ex57939 instanceof Error)){
var statearr_57946_57962 = state_57934__$1;
(statearr_57946_57962[(1)] = (4));

(statearr_57946_57962[(5)] = null);

} else {
throw ex57939;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57935 === (8))){
var inst_57918 = (state_57934[(2)]);
var inst_57919 = fluree.db.dbfunctions.internal.floor.call(null,inst_57918);
var inst_57920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57921 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57923 = [fluree.db.dbfunctions.fns.floor];
var inst_57924 = (new cljs.core.PersistentVector(null,1,(5),inst_57922,inst_57923,null));
var inst_57925 = ["",inst_57924,inst_57919];
var inst_57926 = cljs.core.PersistentHashMap.fromArrays(inst_57921,inst_57925);
var inst_57927 = [inst_57926,(10)];
var inst_57928 = (new cljs.core.PersistentVector(null,2,(5),inst_57920,inst_57927,null));
var inst_57929 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57928);
var _ = (function (){var statearr_57947 = state_57934;
(statearr_57947[(4)] = cljs.core.rest.call(null,(state_57934[(4)])));

return statearr_57947;
})();
var state_57934__$1 = (function (){var statearr_57948 = state_57934;
(statearr_57948[(7)] = inst_57929);

return statearr_57948;
})();
var statearr_57949_57963 = state_57934__$1;
(statearr_57949_57963[(2)] = inst_57919);

(statearr_57949_57963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0 = (function (){
var statearr_57950 = [null,null,null,null,null,null,null,null];
(statearr_57950[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__);

(statearr_57950[(1)] = (1));

return statearr_57950;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1 = (function (state_57934){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57934);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e57951){var ex__2749__auto__ = e57951;
var statearr_57952_57964 = state_57934;
(statearr_57952_57964[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57934[(4)]))){
var statearr_57953_57965 = state_57934;
(statearr_57953_57965[(1)] = cljs.core.first.call(null,(state_57934[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57966 = state_57934;
state_57934 = G__57966;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__ = function(state_57934){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1.call(this,state_57934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_57954 = f__2769__auto__.call(null);
(statearr_57954[(6)] = c__2768__auto__);

return statearr_57954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_57991){
var state_val_57992 = (state_57991[(1)]);
if((state_val_57992 === (1))){
var state_57991__$1 = state_57991;
var statearr_57993_58008 = state_57991__$1;
(statearr_57993_58008[(2)] = null);

(statearr_57993_58008[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (2))){
var _ = (function (){var statearr_57994 = state_57991;
(statearr_57994[(4)] = cljs.core.cons.call(null,(5),(state_57991[(4)])));

return statearr_57994;
})();
var inst_57973 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_57991__$1 = state_57991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57991__$1,(6),inst_57973);
} else {
if((state_val_57992 === (3))){
var inst_57989 = (state_57991[(2)]);
var state_57991__$1 = state_57991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57991__$1,inst_57989);
} else {
if((state_val_57992 === (4))){
var inst_57967 = (state_57991[(2)]);
var state_57991__$1 = state_57991;
var statearr_57996_58009 = state_57991__$1;
(statearr_57996_58009[(2)] = inst_57967);

(statearr_57996_58009[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (5))){
var _ = (function (){var statearr_57997 = state_57991;
(statearr_57997[(4)] = cljs.core.rest.call(null,(state_57991[(4)])));

return statearr_57997;
})();
var state_57991__$1 = state_57991;
var ex57995 = (state_57991__$1[(2)]);
var statearr_57998_58010 = state_57991__$1;
(statearr_57998_58010[(5)] = ex57995);


if((ex57995 instanceof Error)){
var statearr_57999_58011 = state_57991__$1;
(statearr_57999_58011[(1)] = (4));

(statearr_57999_58011[(5)] = null);

} else {
throw ex57995;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (6))){
var inst_57975 = (state_57991[(2)]);
var inst_57976 = fluree.db.util.async.throw_err.call(null,inst_57975);
var inst_57977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57978 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57980 = [compare_val,new_val];
var inst_57981 = (new cljs.core.PersistentVector(null,2,(5),inst_57979,inst_57980,null));
var inst_57982 = ["",inst_57981,inst_57976];
var inst_57983 = cljs.core.PersistentHashMap.fromArrays(inst_57978,inst_57982);
var inst_57984 = [inst_57983,(10)];
var inst_57985 = (new cljs.core.PersistentVector(null,2,(5),inst_57977,inst_57984,null));
var inst_57986 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57985);
var _ = (function (){var statearr_58000 = state_57991;
(statearr_58000[(4)] = cljs.core.rest.call(null,(state_57991[(4)])));

return statearr_58000;
})();
var state_57991__$1 = (function (){var statearr_58001 = state_57991;
(statearr_58001[(7)] = inst_57986);

return statearr_58001;
})();
var statearr_58002_58012 = state_57991__$1;
(statearr_58002_58012[(2)] = inst_57976);

(statearr_58002_58012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0 = (function (){
var statearr_58003 = [null,null,null,null,null,null,null,null];
(statearr_58003[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__);

(statearr_58003[(1)] = (1));

return statearr_58003;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1 = (function (state_57991){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_57991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e58004){var ex__2749__auto__ = e58004;
var statearr_58005_58013 = state_57991;
(statearr_58005_58013[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_57991[(4)]))){
var statearr_58006_58014 = state_57991;
(statearr_58006_58014[(1)] = cljs.core.first.call(null,(state_57991[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58015 = state_57991;
state_57991 = G__58015;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__ = function(state_57991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1.call(this,state_57991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_58007 = f__2769__auto__.call(null);
(statearr_58007[(6)] = c__2768__auto__);

return statearr_58007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
