// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__67750_67931 = cljs.core.seq.call(null,servers);
var chunk__67751_67932 = null;
var count__67752_67933 = (0);
var i__67753_67934 = (0);
while(true){
if((i__67753_67934 < count__67752_67933)){
var server_67935 = cljs.core._nth.call(null,chunk__67751_67932,i__67753_67934);
var healthcheck_uri_67936 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_67935),"/fdb/health"].join('');
var resp_chan_67937 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_67936,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___67938 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67938,healthcheck_uri_67936,resp_chan_67937,server_67935){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67938,healthcheck_uri_67936,resp_chan_67937,server_67935){
return (function (state_67823){
var state_val_67824 = (state_67823[(1)]);
if((state_val_67824 === (1))){
var state_67823__$1 = state_67823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67823__$1,(2),resp_chan_67937);
} else {
if((state_val_67824 === (2))){
var inst_67809 = (state_67823[(7)]);
var inst_67809__$1 = (state_67823[(2)]);
var inst_67810 = fluree.db.util.core.exception_QMARK_.call(null,inst_67809__$1);
var state_67823__$1 = (function (){var statearr_67825 = state_67823;
(statearr_67825[(7)] = inst_67809__$1);

return statearr_67825;
})();
if(inst_67810){
var statearr_67826_67939 = state_67823__$1;
(statearr_67826_67939[(1)] = (3));

} else {
var statearr_67827_67940 = state_67823__$1;
(statearr_67827_67940[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67824 === (3))){
var inst_67809 = (state_67823[(7)]);
var inst_67812 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67813 = cljs.core.ex_message.call(null,inst_67809);
var inst_67814 = cljs.core.ex_data.call(null,inst_67809);
var inst_67815 = ["Server contact error: ",inst_67813,inst_67814];
var inst_67816 = (new cljs.core.PersistentVector(null,3,(5),inst_67812,inst_67815,null));
var inst_67817 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67816);
var state_67823__$1 = state_67823;
var statearr_67828_67941 = state_67823__$1;
(statearr_67828_67941[(2)] = inst_67817);

(statearr_67828_67941[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67824 === (4))){
var inst_67819 = cljs.core.async.put_BANG_.call(null,promise_chan,server_67935);
var state_67823__$1 = state_67823;
var statearr_67829_67942 = state_67823__$1;
(statearr_67829_67942[(2)] = inst_67819);

(statearr_67829_67942[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67824 === (5))){
var inst_67821 = (state_67823[(2)]);
var state_67823__$1 = state_67823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67823__$1,inst_67821);
} else {
return null;
}
}
}
}
}
});})(seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67938,healthcheck_uri_67936,resp_chan_67937,server_67935))
;
return ((function (seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,switch__2745__auto__,c__2768__auto___67938,healthcheck_uri_67936,resp_chan_67937,server_67935){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_67830 = [null,null,null,null,null,null,null,null];
(statearr_67830[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_67830[(1)] = (1));

return statearr_67830;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_67823){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67831){var ex__2749__auto__ = e67831;
var statearr_67832_67943 = state_67823;
(statearr_67832_67943[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67823[(4)]))){
var statearr_67833_67944 = state_67823;
(statearr_67833_67944[(1)] = cljs.core.first.call(null,(state_67823[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67945 = state_67823;
state_67823 = G__67945;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_67823){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_67823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,switch__2745__auto__,c__2768__auto___67938,healthcheck_uri_67936,resp_chan_67937,server_67935))
})();
var state__2770__auto__ = (function (){var statearr_67834 = f__2769__auto__.call(null);
(statearr_67834[(6)] = c__2768__auto___67938);

return statearr_67834;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67938,healthcheck_uri_67936,resp_chan_67937,server_67935))
);



var G__67946 = seq__67750_67931;
var G__67947 = chunk__67751_67932;
var G__67948 = count__67752_67933;
var G__67949 = (i__67753_67934 + (1));
seq__67750_67931 = G__67946;
chunk__67751_67932 = G__67947;
count__67752_67933 = G__67948;
i__67753_67934 = G__67949;
continue;
} else {
var temp__5804__auto___67950 = cljs.core.seq.call(null,seq__67750_67931);
if(temp__5804__auto___67950){
var seq__67750_67951__$1 = temp__5804__auto___67950;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__67750_67951__$1)){
var c__5568__auto___67952 = cljs.core.chunk_first.call(null,seq__67750_67951__$1);
var G__67953 = cljs.core.chunk_rest.call(null,seq__67750_67951__$1);
var G__67954 = c__5568__auto___67952;
var G__67955 = cljs.core.count.call(null,c__5568__auto___67952);
var G__67956 = (0);
seq__67750_67931 = G__67953;
chunk__67751_67932 = G__67954;
count__67752_67933 = G__67955;
i__67753_67934 = G__67956;
continue;
} else {
var server_67957 = cljs.core.first.call(null,seq__67750_67951__$1);
var healthcheck_uri_67958 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_67957),"/fdb/health"].join('');
var resp_chan_67959 = fluree.db.util.xhttp.post_json.call(null,healthcheck_uri_67958,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2768__auto___67960 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67960,healthcheck_uri_67958,resp_chan_67959,server_67957,seq__67750_67951__$1,temp__5804__auto___67950){
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = ((function (seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67960,healthcheck_uri_67958,resp_chan_67959,server_67957,seq__67750_67951__$1,temp__5804__auto___67950){
return (function (state_67850){
var state_val_67851 = (state_67850[(1)]);
if((state_val_67851 === (1))){
var state_67850__$1 = state_67850;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67850__$1,(2),resp_chan_67959);
} else {
if((state_val_67851 === (2))){
var inst_67836 = (state_67850[(7)]);
var inst_67836__$1 = (state_67850[(2)]);
var inst_67837 = fluree.db.util.core.exception_QMARK_.call(null,inst_67836__$1);
var state_67850__$1 = (function (){var statearr_67852 = state_67850;
(statearr_67852[(7)] = inst_67836__$1);

return statearr_67852;
})();
if(inst_67837){
var statearr_67853_67961 = state_67850__$1;
(statearr_67853_67961[(1)] = (3));

} else {
var statearr_67854_67962 = state_67850__$1;
(statearr_67854_67962[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67851 === (3))){
var inst_67836 = (state_67850[(7)]);
var inst_67839 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67840 = cljs.core.ex_message.call(null,inst_67836);
var inst_67841 = cljs.core.ex_data.call(null,inst_67836);
var inst_67842 = ["Server contact error: ",inst_67840,inst_67841];
var inst_67843 = (new cljs.core.PersistentVector(null,3,(5),inst_67839,inst_67842,null));
var inst_67844 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67843);
var state_67850__$1 = state_67850;
var statearr_67855_67963 = state_67850__$1;
(statearr_67855_67963[(2)] = inst_67844);

(statearr_67855_67963[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67851 === (4))){
var inst_67846 = cljs.core.async.put_BANG_.call(null,promise_chan,server_67957);
var state_67850__$1 = state_67850;
var statearr_67856_67964 = state_67850__$1;
(statearr_67856_67964[(2)] = inst_67846);

(statearr_67856_67964[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67851 === (5))){
var inst_67848 = (state_67850[(2)]);
var state_67850__$1 = state_67850;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67850__$1,inst_67848);
} else {
return null;
}
}
}
}
}
});})(seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67960,healthcheck_uri_67958,resp_chan_67959,server_67957,seq__67750_67951__$1,temp__5804__auto___67950))
;
return ((function (seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,switch__2745__auto__,c__2768__auto___67960,healthcheck_uri_67958,resp_chan_67959,server_67957,seq__67750_67951__$1,temp__5804__auto___67950){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_67857 = [null,null,null,null,null,null,null,null];
(statearr_67857[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_67857[(1)] = (1));

return statearr_67857;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_67850){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67850);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67858){var ex__2749__auto__ = e67858;
var statearr_67859_67965 = state_67850;
(statearr_67859_67965[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67850[(4)]))){
var statearr_67860_67966 = state_67850;
(statearr_67860_67966[(1)] = cljs.core.first.call(null,(state_67850[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67967 = state_67850;
state_67850 = G__67967;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_67850){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_67850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
;})(seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,switch__2745__auto__,c__2768__auto___67960,healthcheck_uri_67958,resp_chan_67959,server_67957,seq__67750_67951__$1,temp__5804__auto___67950))
})();
var state__2770__auto__ = (function (){var statearr_67861 = f__2769__auto__.call(null);
(statearr_67861[(6)] = c__2768__auto___67960);

return statearr_67861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});})(seq__67750_67931,chunk__67751_67932,count__67752_67933,i__67753_67934,c__2768__auto___67960,healthcheck_uri_67958,resp_chan_67959,server_67957,seq__67750_67951__$1,temp__5804__auto___67950))
);



var G__67968 = cljs.core.next.call(null,seq__67750_67951__$1);
var G__67969 = null;
var G__67970 = (0);
var G__67971 = (0);
seq__67750_67931 = G__67968;
chunk__67751_67932 = G__67969;
count__67752_67933 = G__67970;
i__67753_67934 = G__67971;
continue;
}
} else {
}
}
break;
}

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67905){
var state_val_67906 = (state_67905[(1)]);
if((state_val_67906 === (7))){
var inst_67877 = (state_67905[(7)]);
var inst_67884 = cljs.core._EQ_.call(null,inst_67877,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_67905__$1 = state_67905;
if(inst_67884){
var statearr_67907_67972 = state_67905__$1;
(statearr_67907_67972[(1)] = (9));

} else {
var statearr_67908_67973 = state_67905__$1;
(statearr_67908_67973[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (1))){
var inst_67870 = (state_67905[(8)]);
var inst_67869 = (state_67905[(9)]);
var inst_67869__$1 = promise_chan;
var inst_67870__$1 = cljs.core.async.timeout.call(null,(60000));
var inst_67871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67872 = [inst_67869__$1,inst_67870__$1];
var inst_67873 = (new cljs.core.PersistentVector(null,2,(5),inst_67871,inst_67872,null));
var state_67905__$1 = (function (){var statearr_67909 = state_67905;
(statearr_67909[(8)] = inst_67870__$1);

(statearr_67909[(9)] = inst_67869__$1);

return statearr_67909;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_67905__$1,(2),inst_67873);
} else {
if((state_val_67906 === (4))){
var inst_67870 = (state_67905[(8)]);
var inst_67877 = (state_67905[(7)]);
var inst_67881 = cljs.core._EQ_.call(null,inst_67877,inst_67870);
var state_67905__$1 = state_67905;
if(inst_67881){
var statearr_67910_67974 = state_67905__$1;
(statearr_67910_67974[(1)] = (6));

} else {
var statearr_67911_67975 = state_67905__$1;
(statearr_67911_67975[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (13))){
var state_67905__$1 = state_67905;
var statearr_67912_67976 = state_67905__$1;
(statearr_67912_67976[(2)] = null);

(statearr_67912_67976[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (6))){
var state_67905__$1 = state_67905;
var statearr_67913_67977 = state_67905__$1;
(statearr_67913_67977[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_67913_67977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (3))){
var state_67905__$1 = state_67905;
var statearr_67914_67978 = state_67905__$1;
(statearr_67914_67978[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_67914_67978[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (12))){
var inst_67895 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"server","server",1499190120));
var inst_67896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67897 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_67898 = cljs.core.PersistentHashMap.fromArrays(inst_67896,inst_67897);
var inst_67899 = cljs.core.ex_info.call(null,"Unable to find healthy server before timeout.",inst_67898);
var inst_67900 = cljs.core.async.put_BANG_.call(null,promise_chan,inst_67899);
var state_67905__$1 = (function (){var statearr_67915 = state_67905;
(statearr_67915[(10)] = inst_67895);

return statearr_67915;
})();
var statearr_67916_67979 = state_67905__$1;
(statearr_67916_67979[(2)] = inst_67900);

(statearr_67916_67979[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (2))){
var inst_67869 = (state_67905[(9)]);
var inst_67877 = (state_67905[(7)]);
var inst_67875 = (state_67905[(2)]);
var inst_67876 = cljs.core.nth.call(null,inst_67875,(0),null);
var inst_67877__$1 = cljs.core.nth.call(null,inst_67875,(1),null);
var inst_67878 = cljs.core._EQ_.call(null,inst_67877__$1,inst_67869);
var state_67905__$1 = (function (){var statearr_67917 = state_67905;
(statearr_67917[(11)] = inst_67876);

(statearr_67917[(7)] = inst_67877__$1);

return statearr_67917;
})();
if(inst_67878){
var statearr_67918_67980 = state_67905__$1;
(statearr_67918_67980[(1)] = (3));

} else {
var statearr_67919_67981 = state_67905__$1;
(statearr_67919_67981[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (11))){
var inst_67888 = (state_67905[(2)]);
var state_67905__$1 = state_67905;
var statearr_67920_67982 = state_67905__$1;
(statearr_67920_67982[(2)] = inst_67888);

(statearr_67920_67982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (9))){
var inst_67876 = (state_67905[(11)]);
var state_67905__$1 = state_67905;
var statearr_67921_67983 = state_67905__$1;
(statearr_67921_67983[(2)] = inst_67876);

(statearr_67921_67983[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (5))){
var inst_67892 = (state_67905[(2)]);
var inst_67893 = cljs.core._EQ_.call(null,new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_67892);
var state_67905__$1 = state_67905;
if(inst_67893){
var statearr_67922_67984 = state_67905__$1;
(statearr_67922_67984[(1)] = (12));

} else {
var statearr_67923_67985 = state_67905__$1;
(statearr_67923_67985[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (14))){
var inst_67903 = (state_67905[(2)]);
var state_67905__$1 = state_67905;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67905__$1,inst_67903);
} else {
if((state_val_67906 === (10))){
var state_67905__$1 = state_67905;
var statearr_67924_67986 = state_67905__$1;
(statearr_67924_67986[(2)] = null);

(statearr_67924_67986[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67906 === (8))){
var inst_67890 = (state_67905[(2)]);
var state_67905__$1 = state_67905;
var statearr_67925_67987 = state_67905__$1;
(statearr_67925_67987[(2)] = inst_67890);

(statearr_67925_67987[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0 = (function (){
var statearr_67926 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67926[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__);

(statearr_67926[(1)] = (1));

return statearr_67926;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1 = (function (state_67905){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67905);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67927){var ex__2749__auto__ = e67927;
var statearr_67928_67988 = state_67905;
(statearr_67928_67988[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67905[(4)]))){
var statearr_67929_67989 = state_67905;
(statearr_67929_67989[(1)] = cljs.core.first.call(null,(state_67905[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67990 = state_67905;
state_67905 = G__67990;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__ = function(state_67905){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1.call(this,state_67905);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67930 = f__2769__auto__.call(null);
(statearr_67930[(6)] = c__2768__auto__);

return statearr_67930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid.call(null);
var new_state = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.call(null)], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.call(null,lock_id,cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.call(null,new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server.call(null,conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68034){
var state_val_68035 = (state_68034[(1)]);
if((state_val_68035 === (7))){
var state_68034__$1 = state_68034;
var statearr_68036_68062 = state_68034__$1;
(statearr_68036_68062[(2)] = null);

(statearr_68036_68062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (1))){
var state_68034__$1 = state_68034;
var statearr_68037_68063 = state_68034__$1;
(statearr_68037_68063[(2)] = null);

(statearr_68037_68063[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (4))){
var inst_67991 = (state_68034[(2)]);
var state_68034__$1 = state_68034;
var statearr_68038_68064 = state_68034__$1;
(statearr_68038_68064[(2)] = inst_67991);

(statearr_68038_68064[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (6))){
var inst_68013 = fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
var state_68034__$1 = state_68034;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68034__$1,(9),inst_68013);
} else {
if((state_val_68035 === (3))){
var inst_68032 = (state_68034[(2)]);
var state_68034__$1 = state_68034;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68034__$1,inst_68032);
} else {
if((state_val_68035 === (12))){
var inst_68026 = (state_68034[(2)]);
var state_68034__$1 = state_68034;
var statearr_68039_68065 = state_68034__$1;
(statearr_68039_68065[(2)] = inst_68026);

(statearr_68039_68065[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (2))){
var inst_68007 = (state_68034[(7)]);
var inst_68002 = (state_68034[(8)]);
var inst_67997 = (state_68034[(9)]);
var _ = (function (){var statearr_68040 = state_68034;
(statearr_68040[(4)] = cljs.core.cons.call(null,(5),(state_68034[(4)])));

return statearr_68040;
})();
var inst_67997__$1 = cljs.core.random_uuid.call(null);
var inst_67998 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67999 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_68000 = (new cljs.core.PersistentVector(null,2,(5),inst_67998,inst_67999,null));
var inst_68001 = (function (){var lock_id = inst_67997__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.call(null)], null);
}
});
})();
var inst_68002__$1 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_68000,inst_68001);
var inst_68003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68004 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_68005 = (new cljs.core.PersistentVector(null,3,(5),inst_68003,inst_68004,null));
var inst_68006 = cljs.core.get_in.call(null,inst_68002__$1,inst_68005);
var inst_68007__$1 = cljs.core._EQ_.call(null,inst_67997__$1,inst_68006);
var inst_68008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68009 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68010 = (new cljs.core.PersistentVector(null,3,(5),inst_68008,inst_68009,null));
var inst_68011 = cljs.core.get_in.call(null,inst_68002__$1,inst_68010);
var state_68034__$1 = (function (){var statearr_68041 = state_68034;
(statearr_68041[(7)] = inst_68007__$1);

(statearr_68041[(8)] = inst_68002__$1);

(statearr_68041[(9)] = inst_67997__$1);

(statearr_68041[(10)] = inst_68011);

return statearr_68041;
})();
if(inst_68007__$1){
var statearr_68042_68066 = state_68034__$1;
(statearr_68042_68066[(1)] = (6));

} else {
var statearr_68043_68067 = state_68034__$1;
(statearr_68043_68067[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (11))){
var inst_68017 = (state_68034[(11)]);
var inst_68011 = (state_68034[(10)]);
var inst_68018 = (state_68034[(12)]);
var inst_68024 = fluree.db.util.xhttp.try_socket.call(null,inst_68017,sub_chan,pub_chan,inst_68011,(60000),inst_68018);
var state_68034__$1 = state_68034;
var statearr_68045_68068 = state_68034__$1;
(statearr_68045_68068[(2)] = inst_68024);

(statearr_68045_68068[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (9))){
var inst_68017 = (state_68034[(11)]);
var inst_68007 = (state_68034[(7)]);
var inst_68002 = (state_68034[(8)]);
var inst_68015 = (state_68034[(13)]);
var inst_67997 = (state_68034[(9)]);
var inst_68011 = (state_68034[(10)]);
var inst_68015__$1 = (state_68034[(2)]);
var inst_68016 = clojure.string.replace.call(null,inst_68015__$1,"http","ws");
var inst_68017__$1 = [inst_68016,"/fdb/ws"].join('');
var inst_68018 = (function (){var lock_id = inst_67997;
var state = inst_68002;
var have_lock_QMARK_ = inst_68007;
var resp_chan = inst_68011;
var healthy_server = inst_68015__$1;
var ws_url = inst_68017__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.call(null,conn_id);
});
})();
var inst_68019 = fluree.db.util.core.exception_QMARK_.call(null,inst_68015__$1);
var state_68034__$1 = (function (){var statearr_68046 = state_68034;
(statearr_68046[(11)] = inst_68017__$1);

(statearr_68046[(13)] = inst_68015__$1);

(statearr_68046[(12)] = inst_68018);

return statearr_68046;
})();
if(inst_68019){
var statearr_68047_68069 = state_68034__$1;
(statearr_68047_68069[(1)] = (10));

} else {
var statearr_68048_68070 = state_68034__$1;
(statearr_68048_68070[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (5))){
var _ = (function (){var statearr_68049 = state_68034;
(statearr_68049[(4)] = cljs.core.rest.call(null,(state_68034[(4)])));

return statearr_68049;
})();
var state_68034__$1 = state_68034;
var ex68044 = (state_68034__$1[(2)]);
var statearr_68050_68071 = state_68034__$1;
(statearr_68050_68071[(5)] = ex68044);


if((ex68044 instanceof Error)){
var statearr_68051_68072 = state_68034__$1;
(statearr_68051_68072[(1)] = (4));

(statearr_68051_68072[(5)] = null);

} else {
throw ex68044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (10))){
var inst_68015 = (state_68034[(13)]);
var inst_68011 = (state_68034[(10)]);
var inst_68021 = cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,new cljs.core.Keyword(null,"ws","ws",86841443));
var inst_68022 = cljs.core.async.put_BANG_.call(null,inst_68011,inst_68015);
var state_68034__$1 = (function (){var statearr_68052 = state_68034;
(statearr_68052[(14)] = inst_68021);

return statearr_68052;
})();
var statearr_68053_68073 = state_68034__$1;
(statearr_68053_68073[(2)] = inst_68022);

(statearr_68053_68073[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68035 === (8))){
var inst_68011 = (state_68034[(10)]);
var inst_68029 = (state_68034[(2)]);
var _ = (function (){var statearr_68054 = state_68034;
(statearr_68054[(4)] = cljs.core.rest.call(null,(state_68034[(4)])));

return statearr_68054;
})();
var state_68034__$1 = (function (){var statearr_68055 = state_68034;
(statearr_68055[(15)] = inst_68029);

return statearr_68055;
})();
var statearr_68056_68074 = state_68034__$1;
(statearr_68056_68074[(2)] = inst_68011);

(statearr_68056_68074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_68057 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68057[(0)] = fluree$db$connection$establish_socket_$_state_machine__2746__auto__);

(statearr_68057[(1)] = (1));

return statearr_68057;
});
var fluree$db$connection$establish_socket_$_state_machine__2746__auto____1 = (function (state_68034){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68034);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68058){var ex__2749__auto__ = e68058;
var statearr_68059_68075 = state_68034;
(statearr_68059_68075[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68034[(4)]))){
var statearr_68060_68076 = state_68034;
(statearr_68060_68076[(1)] = cljs.core.first.call(null,(state_68034[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68077 = state_68034;
state_68034 = G__68077;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2746__auto__ = function(state_68034){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2746__auto____1.call(this,state_68034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68061 = f__2769__auto__.call(null);
(statearr_68061[(6)] = c__2768__auto__);

return statearr_68061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k68079,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__68083 = k68079;
var G__68083__$1 = (((G__68083 instanceof cljs.core.Keyword))?G__68083.fqn:null);
switch (G__68083__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k68079,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__68084){
var vec__68085 = p__68084;
var k__5367__auto__ = cljs.core.nth.call(null,vec__68085,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__68085,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__68078){
var self__ = this;
var G__68078__$1 = this;
return (new cljs.core.RecordIter((0),G__68078__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this68080,other68081){
var self__ = this;
var this68080__$1 = this;
return (((!((other68081 == null)))) && ((((this68080__$1.constructor === other68081.constructor)) && (((cljs.core._EQ_.call(null,this68080__$1.id,other68081.id)) && (((cljs.core._EQ_.call(null,this68080__$1.servers,other68081.servers)) && (((cljs.core._EQ_.call(null,this68080__$1.state,other68081.state)) && (((cljs.core._EQ_.call(null,this68080__$1.req_chan,other68081.req_chan)) && (((cljs.core._EQ_.call(null,this68080__$1.sub_chan,other68081.sub_chan)) && (((cljs.core._EQ_.call(null,this68080__$1.pub_chan,other68081.pub_chan)) && (((cljs.core._EQ_.call(null,this68080__$1.group,other68081.group)) && (((cljs.core._EQ_.call(null,this68080__$1.storage_read,other68081.storage_read)) && (((cljs.core._EQ_.call(null,this68080__$1.storage_list,other68081.storage_list)) && (((cljs.core._EQ_.call(null,this68080__$1.storage_write,other68081.storage_write)) && (((cljs.core._EQ_.call(null,this68080__$1.storage_exists,other68081.storage_exists)) && (((cljs.core._EQ_.call(null,this68080__$1.storage_rename,other68081.storage_rename)) && (((cljs.core._EQ_.call(null,this68080__$1.storage_delete,other68081.storage_delete)) && (((cljs.core._EQ_.call(null,this68080__$1.object_cache,other68081.object_cache)) && (((cljs.core._EQ_.call(null,this68080__$1.async_cache,other68081.async_cache)) && (((cljs.core._EQ_.call(null,this68080__$1.parallelism,other68081.parallelism)) && (((cljs.core._EQ_.call(null,this68080__$1.serializer,other68081.serializer)) && (((cljs.core._EQ_.call(null,this68080__$1.default_network,other68081.default_network)) && (((cljs.core._EQ_.call(null,this68080__$1.transactor_QMARK_,other68081.transactor_QMARK_)) && (((cljs.core._EQ_.call(null,this68080__$1.publish,other68081.publish)) && (((cljs.core._EQ_.call(null,this68080__$1.transact_handler,other68081.transact_handler)) && (((cljs.core._EQ_.call(null,this68080__$1.tx_private_key,other68081.tx_private_key)) && (((cljs.core._EQ_.call(null,this68080__$1.tx_key_id,other68081.tx_key_id)) && (((cljs.core._EQ_.call(null,this68080__$1.meta,other68081.meta)) && (((cljs.core._EQ_.call(null,this68080__$1.add_listener,other68081.add_listener)) && (((cljs.core._EQ_.call(null,this68080__$1.remove_listener,other68081.remove_listener)) && (((cljs.core._EQ_.call(null,this68080__$1.close,other68081.close)) && (cljs.core._EQ_.call(null,this68080__$1.__extmap,other68081.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__68088){
var self__ = this;
var map__68089 = p__68088;
var map__68089__$1 = cljs.core.__destructure_map.call(null,map__68089);
var node = map__68089__$1;
var id__$1 = cljs.core.get.call(null,map__68089__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__68089__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.call(null,map__68089__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf.call(null,node);
} else {
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),(function (_){
return fluree.db.storage.core.resolve_index_node.call(null,conn__$1,node,(function (){
return self__.async_cache.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null),null);
}));
}));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k68079){
var self__ = this;
var this__5350__auto____$1 = this;
var G__68090 = k68079;
var G__68090__$1 = (((G__68090 instanceof cljs.core.Keyword))?G__68090.fqn:null);
switch (G__68090__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k68079);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__68078){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__68091 = cljs.core.keyword_identical_QMARK_;
var expr__68092 = k__5352__auto__;
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__68092))){
return (new fluree.db.connection.Connection(G__68078,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"servers","servers",1881102005),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,G__68078,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__68078,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__68078,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__68078,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__68078,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"group","group",582596132),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__68078,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__68078,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__68078,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__68078,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__68078,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__68078,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__68078,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__68078,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__68078,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__68078,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__68078,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"default-network","default-network",586420705),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__68078,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__68078,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"publish","publish",-1178026850),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__68078,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__68078,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__68078,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__68078,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"meta","meta",1499536964),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__68078,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__68078,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__68078,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__68091.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__68092))){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__68078,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__68078),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_read.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return self__.storage_write.call(null,k,data);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_exists.call(null,k);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return self__.storage_rename.call(null,old_key,new_key);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return self__.storage_list.call(null,d);
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return self__.storage_delete.call(null,k);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__68078){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__68078,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__68082){
var extmap__5385__auto__ = (function (){var G__68094 = cljs.core.dissoc.call(null,G__68082,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582));
if(cljs.core.record_QMARK_.call(null,G__68082)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__68094);
} else {
return G__68094;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__68082),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__68082),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.call(null,servers,/,/):servers);
if(((cljs.core.empty_QMARK_.call(null,servers)) && (cljs.core.not.call(null,transactor_QMARK_)))){
throw cljs.core.ex_info.call(null,"At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty.call(null,servers_STAR_))){
var G__68100 = servers_STAR_;
var vec__68101 = G__68100;
var seq__68102 = cljs.core.seq.call(null,vec__68101);
var first__68103 = cljs.core.first.call(null,seq__68102);
var seq__68102__$1 = cljs.core.next.call(null,seq__68102);
var server = first__68103;
var r = seq__68102__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__68100__$1 = G__68100;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__68107 = G__68100__$1;
var seq__68108 = cljs.core.seq.call(null,vec__68107);
var first__68109 = cljs.core.first.call(null,seq__68108);
var seq__68108__$1 = cljs.core.next.call(null,seq__68108);
var server__$1 = first__68109;
var r__$1 = seq__68108__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.call(null,["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.call(null,server__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace.call(null,server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches.call(null,/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_.call(null,server__$2,"//"))?(function(){throw cljs.core.ex_info.call(null,["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches.call(null,/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_.call(null,server__$2,"https://");
var result_STAR_ = cljs.core.conj.call(null,result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches.call(null,fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.call(null,["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_.call(null,r__$1)){
return cljs.core.shuffle.call(null,result_STAR_);
} else {
var G__68110 = r__$1;
var G__68111 = is_https_QMARK_;
var G__68112 = result_STAR_;
G__68100__$1 = G__68110;
https_QMARK___$1 = G__68111;
result__$1 = G__68112;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__68113 = cljs.core.get_in.call(null,fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__68113 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_.call(null,G__68113);
}
})();
cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket.call(null,existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68142){
var state_val_68143 = (state_68142[(1)]);
if((state_val_68143 === (7))){
var inst_68128 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68129 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68130 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68131 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68132 = fluree.db.connection.establish_socket.call(null,inst_68128,inst_68129,inst_68130,inst_68131);
var state_68142__$1 = state_68142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68142__$1,(9),inst_68132);
} else {
if((state_val_68143 === (1))){
var state_68142__$1 = state_68142;
var statearr_68144_68163 = state_68142__$1;
(statearr_68144_68163[(2)] = null);

(statearr_68144_68163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68143 === (4))){
var inst_68114 = (state_68142[(2)]);
var state_68142__$1 = state_68142;
var statearr_68145_68164 = state_68142__$1;
(statearr_68145_68164[(2)] = inst_68114);

(statearr_68145_68164[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68143 === (6))){
var inst_68125 = (state_68142[(7)]);
var state_68142__$1 = state_68142;
var statearr_68146_68165 = state_68142__$1;
(statearr_68146_68165[(2)] = inst_68125);

(statearr_68146_68165[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68143 === (3))){
var inst_68140 = (state_68142[(2)]);
var state_68142__$1 = state_68142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68142__$1,inst_68140);
} else {
if((state_val_68143 === (2))){
var inst_68125 = (state_68142[(7)]);
var _ = (function (){var statearr_68148 = state_68142;
(statearr_68148[(4)] = cljs.core.cons.call(null,(5),(state_68142[(4)])));

return statearr_68148;
})();
var inst_68120 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_68121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68122 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68123 = [inst_68122,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68124 = (new cljs.core.PersistentVector(null,3,(5),inst_68121,inst_68123,null));
var inst_68125__$1 = cljs.core.get_in.call(null,inst_68120,inst_68124);
var state_68142__$1 = (function (){var statearr_68149 = state_68142;
(statearr_68149[(7)] = inst_68125__$1);

return statearr_68149;
})();
if(cljs.core.truth_(inst_68125__$1)){
var statearr_68150_68166 = state_68142__$1;
(statearr_68150_68166[(1)] = (6));

} else {
var statearr_68151_68167 = state_68142__$1;
(statearr_68151_68167[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68143 === (9))){
var inst_68134 = (state_68142[(2)]);
var inst_68135 = fluree.db.util.async.throw_err.call(null,inst_68134);
var state_68142__$1 = state_68142;
var statearr_68152_68168 = state_68142__$1;
(statearr_68152_68168[(2)] = inst_68135);

(statearr_68152_68168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68143 === (5))){
var _ = (function (){var statearr_68153 = state_68142;
(statearr_68153[(4)] = cljs.core.rest.call(null,(state_68142[(4)])));

return statearr_68153;
})();
var state_68142__$1 = state_68142;
var ex68147 = (state_68142__$1[(2)]);
var statearr_68154_68169 = state_68142__$1;
(statearr_68154_68169[(5)] = ex68147);


if((ex68147 instanceof Error)){
var statearr_68155_68170 = state_68142__$1;
(statearr_68155_68170[(1)] = (4));

(statearr_68155_68170[(5)] = null);

} else {
throw ex68147;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68143 === (8))){
var inst_68137 = (state_68142[(2)]);
var _ = (function (){var statearr_68156 = state_68142;
(statearr_68156[(4)] = cljs.core.rest.call(null,(state_68142[(4)])));

return statearr_68156;
})();
var state_68142__$1 = state_68142;
var statearr_68157_68171 = state_68142__$1;
(statearr_68157_68171[(2)] = inst_68137);

(statearr_68157_68171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2746__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2746__auto____0 = (function (){
var statearr_68158 = [null,null,null,null,null,null,null,null];
(statearr_68158[(0)] = fluree$db$connection$get_socket_$_state_machine__2746__auto__);

(statearr_68158[(1)] = (1));

return statearr_68158;
});
var fluree$db$connection$get_socket_$_state_machine__2746__auto____1 = (function (state_68142){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68159){var ex__2749__auto__ = e68159;
var statearr_68160_68172 = state_68142;
(statearr_68160_68172[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68142[(4)]))){
var statearr_68161_68173 = state_68142;
(statearr_68161_68173[(1)] = cljs.core.first.call(null,(state_68142[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68174 = state_68142;
state_68142 = G__68174;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2746__auto__ = function(state_68142){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2746__auto____1.call(this,state_68142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2746__auto____0;
fluree$db$connection$get_socket_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2746__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68162 = f__2769__auto__.call(null);
(statearr_68162[(6)] = c__2768__auto__);

return statearr_68162;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server.call(null,conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.call(null);
var msg = (function (){try{return fluree.db.util.json.stringify.call(null,message);
}catch (e68175){var e = e68175;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.call(null,resp_chan,cljs.core.ex_info.call(null,["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.call(null,pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__68177){
var map__68178 = p__68177;
var map__68178__$1 = cljs.core.__destructure_map.call(null,map__68178);
var conn = map__68178__$1;
var state = cljs.core.get.call(null,map__68178__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.call(null,map__68178__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.call(null,map__68178__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68324){
var state_val_68325 = (state_68324[(1)]);
if((state_val_68325 === (7))){
var inst_68320 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
var statearr_68327_68401 = state_68324__$1;
(statearr_68327_68401[(2)] = inst_68320);

(statearr_68327_68401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (20))){
var _ = (function (){var statearr_68328 = state_68324;
(statearr_68328[(4)] = cljs.core.rest.call(null,(state_68324[(4)])));

return statearr_68328;
})();
var state_68324__$1 = state_68324;
var ex68326 = (state_68324__$1[(2)]);
var statearr_68329_68402 = state_68324__$1;
(statearr_68329_68402[(5)] = ex68326);


var statearr_68330_68403 = state_68324__$1;
(statearr_68330_68403[(1)] = (10));

(statearr_68330_68403[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (27))){
var inst_68281 = (state_68324[(7)]);
var inst_68281__$1 = (state_68324[(2)]);
var inst_68282 = inst_68281__$1 === true;
var state_68324__$1 = (function (){var statearr_68331 = state_68324;
(statearr_68331[(7)] = inst_68281__$1);

return statearr_68331;
})();
if(cljs.core.truth_(inst_68282)){
var statearr_68332_68404 = state_68324__$1;
(statearr_68332_68404[(1)] = (28));

} else {
var statearr_68333_68405 = state_68324__$1;
(statearr_68333_68405[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (1))){
var inst_68179 = (0);
var state_68324__$1 = (function (){var statearr_68334 = state_68324;
(statearr_68334[(8)] = inst_68179);

return statearr_68334;
})();
var statearr_68335_68406 = state_68324__$1;
(statearr_68335_68406[(2)] = null);

(statearr_68335_68406[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (24))){
var inst_68271 = (state_68324[(9)]);
var state_68324__$1 = state_68324;
var statearr_68336_68407 = state_68324__$1;
(statearr_68336_68407[(2)] = inst_68271);

(statearr_68336_68407[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (39))){
var inst_68306 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
var statearr_68337_68408 = state_68324__$1;
(statearr_68337_68408[(2)] = inst_68306);

(statearr_68337_68408[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (4))){
var inst_68182 = (state_68324[(10)]);
var inst_68182__$1 = (state_68324[(2)]);
var state_68324__$1 = (function (){var statearr_68338 = state_68324;
(statearr_68338[(10)] = inst_68182__$1);

return statearr_68338;
})();
if(cljs.core.truth_(inst_68182__$1)){
var statearr_68339_68409 = state_68324__$1;
(statearr_68339_68409[(1)] = (5));

} else {
var statearr_68340_68410 = state_68324__$1;
(statearr_68340_68410[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (15))){
var inst_68195 = (state_68324[(11)]);
var state_68324__$1 = state_68324;
var statearr_68341_68411 = state_68324__$1;
(statearr_68341_68411[(2)] = inst_68195);

(statearr_68341_68411[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (21))){
var inst_68228 = (state_68324[(12)]);
var inst_68225 = (state_68324[(13)]);
var inst_68224 = (state_68324[(14)]);
var inst_68232 = (state_68324[(15)]);
var inst_68229 = (state_68324[(16)]);
var inst_68226 = (state_68324[(17)]);
var inst_68182 = (state_68324[(10)]);
var inst_68179 = (state_68324[(8)]);
var inst_68227 = (state_68324[(18)]);
var inst_68233 = (state_68324[(19)]);
var inst_68235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68236 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68232];
var inst_68237 = (new cljs.core.PersistentVector(null,2,(5),inst_68235,inst_68236,null));
var inst_68238 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,inst_68237,inst_68227);
var inst_68265 = cljs.core.async.chan.call(null,(1));
var inst_68266 = (function (){var resp_chan = inst_68227;
var timeout = inst_68233;
var i = inst_68179;
var data = inst_68226;
var _ = inst_68224;
var req_id = inst_68232;
var operation = inst_68225;
var msg = inst_68182;
var temp__5804__auto__ = inst_68182;
var vec__68217 = inst_68182;
var c__2768__auto____$1 = inst_68265;
var map__68220 = inst_68229;
var opts = inst_68228;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68263){
var state_val_68264 = (state_68263[(1)]);
if((state_val_68264 === (1))){
var inst_68242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68243 = cljs.core.async.timeout.call(null,timeout);
var inst_68244 = [resp_chan,inst_68243];
var inst_68245 = (new cljs.core.PersistentVector(null,2,(5),inst_68242,inst_68244,null));
var state_68263__$1 = state_68263;
return cljs.core.async.ioc_alts_BANG_.call(null,state_68263__$1,(2),inst_68245);
} else {
if((state_val_68264 === (2))){
var inst_68248 = (state_68263[(7)]);
var inst_68247 = (state_68263[(2)]);
var inst_68248__$1 = cljs.core.nth.call(null,inst_68247,(0),null);
var inst_68249 = cljs.core.nth.call(null,inst_68247,(1),null);
var inst_68250 = (function (){var vec__68239 = inst_68247;
var resp = inst_68248__$1;
var c = inst_68249;
return (function (p1__68176_SHARP_){
return cljs.core.dissoc.call(null,p1__68176_SHARP_,req_id);
});
})();
var inst_68251 = cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68250);
var inst_68252 = cljs.core._EQ_.call(null,inst_68249,resp_chan);
var state_68263__$1 = (function (){var statearr_68342 = state_68263;
(statearr_68342[(8)] = inst_68251);

(statearr_68342[(7)] = inst_68248__$1);

return statearr_68342;
})();
if(inst_68252){
var statearr_68343_68412 = state_68263__$1;
(statearr_68343_68412[(1)] = (3));

} else {
var statearr_68344_68413 = state_68263__$1;
(statearr_68344_68413[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68264 === (3))){
var inst_68248 = (state_68263[(7)]);
var state_68263__$1 = state_68263;
var statearr_68345_68414 = state_68263__$1;
(statearr_68345_68414[(2)] = inst_68248);

(statearr_68345_68414[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68264 === (4))){
var inst_68255 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_68256 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68257 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68258 = cljs.core.PersistentHashMap.fromArrays(inst_68256,inst_68257);
var inst_68259 = cljs.core.ex_info.call(null,inst_68255,inst_68258);
var state_68263__$1 = state_68263;
var statearr_68346_68415 = state_68263__$1;
(statearr_68346_68415[(2)] = inst_68259);

(statearr_68346_68415[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68264 === (5))){
var inst_68261 = (state_68263[(2)]);
var state_68263__$1 = state_68263;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68263__$1,inst_68261);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_68347 = [null,null,null,null,null,null,null,null,null];
(statearr_68347[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_68347[(1)] = (1));

return statearr_68347;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_68263){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68263);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68348){var ex__2749__auto__ = e68348;
var statearr_68349_68416 = state_68263;
(statearr_68349_68416[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68263[(4)]))){
var statearr_68350_68417 = state_68263;
(statearr_68350_68417[(1)] = cljs.core.first.call(null,(state_68263[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68418 = state_68263;
state_68263 = G__68418;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_68263){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_68263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68351 = f__2769__auto__.call(null);
(statearr_68351[(6)] = c__2768__auto____$1);

return statearr_68351;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_68267 = cljs.core.async.impl.dispatch.run.call(null,inst_68266);
var state_68324__$1 = (function (){var statearr_68352 = state_68324;
(statearr_68352[(20)] = inst_68267);

(statearr_68352[(21)] = inst_68238);

return statearr_68352;
})();
var statearr_68353_68419 = state_68324__$1;
(statearr_68353_68419[(2)] = inst_68265);

(statearr_68353_68419[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (31))){
var inst_68281 = (state_68324[(7)]);
var inst_68287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68288 = [inst_68281,"Error processing message in producer."];
var inst_68289 = (new cljs.core.PersistentVector(null,2,(5),inst_68287,inst_68288,null));
var inst_68290 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68289);
var state_68324__$1 = state_68324;
var statearr_68354_68420 = state_68324__$1;
(statearr_68354_68420[(2)] = inst_68290);

(statearr_68354_68420[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (32))){
var inst_68281 = (state_68324[(7)]);
var inst_68292 = (inst_68281 == null);
var state_68324__$1 = state_68324;
if(cljs.core.truth_(inst_68292)){
var statearr_68355_68421 = state_68324__$1;
(statearr_68355_68421[(1)] = (34));

} else {
var statearr_68356_68422 = state_68324__$1;
(statearr_68356_68422[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (33))){
var inst_68310 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
var statearr_68357_68423 = state_68324__$1;
(statearr_68357_68423[(2)] = inst_68310);

(statearr_68357_68423[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (13))){
var inst_68195 = (state_68324[(11)]);
var inst_68192 = (state_68324[(2)]);
var inst_68193 = cljs.core.nth.call(null,inst_68192,(0),null);
var inst_68194 = cljs.core.nth.call(null,inst_68192,(1),null);
var inst_68195__$1 = cljs.core.nth.call(null,inst_68192,(2),null);
var state_68324__$1 = (function (){var statearr_68358 = state_68324;
(statearr_68358[(11)] = inst_68195__$1);

(statearr_68358[(22)] = inst_68194);

(statearr_68358[(23)] = inst_68193);

return statearr_68358;
})();
if(cljs.core.truth_(inst_68195__$1)){
var statearr_68359_68424 = state_68324__$1;
(statearr_68359_68424[(1)] = (14));

} else {
var statearr_68360_68425 = state_68324__$1;
(statearr_68360_68425[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (22))){
var state_68324__$1 = state_68324;
var statearr_68361_68426 = state_68324__$1;
(statearr_68361_68426[(2)] = null);

(statearr_68361_68426[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (36))){
var inst_68308 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
var statearr_68362_68427 = state_68324__$1;
(statearr_68362_68427[(2)] = inst_68308);

(statearr_68362_68427[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (29))){
var inst_68281 = (state_68324[(7)]);
var inst_68285 = fluree.db.util.core.exception_QMARK_.call(null,inst_68281);
var state_68324__$1 = state_68324;
if(inst_68285){
var statearr_68363_68428 = state_68324__$1;
(statearr_68363_68428[(1)] = (31));

} else {
var statearr_68364_68429 = state_68324__$1;
(statearr_68364_68429[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (6))){
var state_68324__$1 = state_68324;
var statearr_68365_68430 = state_68324__$1;
(statearr_68365_68430[(2)] = null);

(statearr_68365_68430[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (28))){
var state_68324__$1 = state_68324;
var statearr_68366_68431 = state_68324__$1;
(statearr_68366_68431[(2)] = null);

(statearr_68366_68431[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (25))){
var state_68324__$1 = state_68324;
var statearr_68367_68432 = state_68324__$1;
(statearr_68367_68432[(2)] = fluree.db.connection.default_publish_fn);

(statearr_68367_68432[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (34))){
var inst_68294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68295 = ["Error processing message in producer. Socket closed."];
var inst_68296 = (new cljs.core.PersistentVector(null,1,(5),inst_68294,inst_68295,null));
var inst_68297 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68296);
var state_68324__$1 = state_68324;
var statearr_68368_68433 = state_68324__$1;
(statearr_68368_68433[(2)] = inst_68297);

(statearr_68368_68433[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (17))){
var inst_68195 = (state_68324[(11)]);
var inst_68184 = (state_68324[(24)]);
var inst_68202 = cljs.core.async.put_BANG_.call(null,inst_68195,inst_68184);
var state_68324__$1 = state_68324;
var statearr_68369_68434 = state_68324__$1;
(statearr_68369_68434[(2)] = inst_68202);

(statearr_68369_68434[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (3))){
var inst_68322 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68324__$1,inst_68322);
} else {
if((state_val_68325 === (12))){
var state_68324__$1 = state_68324;
var statearr_68370_68435 = state_68324__$1;
(statearr_68370_68435[(2)] = null);

(statearr_68370_68435[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (2))){
var state_68324__$1 = state_68324;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68324__$1,(4),req_chan);
} else {
if((state_val_68325 === (23))){
var inst_68271 = (state_68324[(9)]);
var inst_68270 = (state_68324[(2)]);
var inst_68271__$1 = publish;
var state_68324__$1 = (function (){var statearr_68371 = state_68324;
(statearr_68371[(9)] = inst_68271__$1);

(statearr_68371[(25)] = inst_68270);

return statearr_68371;
})();
if(cljs.core.truth_(inst_68271__$1)){
var statearr_68372_68436 = state_68324__$1;
(statearr_68372_68436[(1)] = (24));

} else {
var statearr_68373_68437 = state_68324__$1;
(statearr_68373_68437[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (35))){
var state_68324__$1 = state_68324;
var statearr_68374_68438 = state_68324__$1;
(statearr_68374_68438[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (19))){
var inst_68211 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
var statearr_68376_68439 = state_68324__$1;
(statearr_68376_68439[(2)] = inst_68211);

(statearr_68376_68439[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (11))){
var inst_68182 = (state_68324[(10)]);
var state_68324__$1 = state_68324;
var statearr_68377_68440 = state_68324__$1;
(statearr_68377_68440[(2)] = inst_68182);

(statearr_68377_68440[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (9))){
var inst_68179 = (state_68324[(8)]);
var inst_68315 = (state_68324[(2)]);
var inst_68316 = (inst_68179 + (1));
var inst_68179__$1 = inst_68316;
var state_68324__$1 = (function (){var statearr_68378 = state_68324;
(statearr_68378[(26)] = inst_68315);

(statearr_68378[(8)] = inst_68179__$1);

return statearr_68378;
})();
var statearr_68379_68441 = state_68324__$1;
(statearr_68379_68441[(2)] = null);

(statearr_68379_68441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (5))){
var state_68324__$1 = state_68324;
var statearr_68380_68442 = state_68324__$1;
(statearr_68380_68442[(2)] = null);

(statearr_68380_68442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (14))){
var inst_68195 = (state_68324[(11)]);
var inst_68197 = fluree.db.util.async.channel_QMARK_.call(null,inst_68195);
var state_68324__$1 = state_68324;
var statearr_68381_68443 = state_68324__$1;
(statearr_68381_68443[(2)] = inst_68197);

(statearr_68381_68443[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (26))){
var inst_68225 = (state_68324[(13)]);
var inst_68232 = (state_68324[(15)]);
var inst_68226 = (state_68324[(17)]);
var inst_68275 = (state_68324[(2)]);
var inst_68276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68277 = [inst_68225,inst_68232,inst_68226];
var inst_68278 = (new cljs.core.PersistentVector(null,3,(5),inst_68276,inst_68277,null));
var inst_68279 = inst_68275.call(null,conn,inst_68278);
var state_68324__$1 = state_68324;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68324__$1,(27),inst_68279);
} else {
if((state_val_68325 === (16))){
var inst_68200 = (state_68324[(2)]);
var state_68324__$1 = state_68324;
if(cljs.core.truth_(inst_68200)){
var statearr_68382_68444 = state_68324__$1;
(statearr_68382_68444[(1)] = (17));

} else {
var statearr_68383_68445 = state_68324__$1;
(statearr_68383_68445[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (38))){
var state_68324__$1 = state_68324;
var statearr_68384_68446 = state_68324__$1;
(statearr_68384_68446[(2)] = null);

(statearr_68384_68446[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (30))){
var inst_68312 = (state_68324[(2)]);
var _ = (function (){var statearr_68385 = state_68324;
(statearr_68385[(4)] = cljs.core.rest.call(null,(state_68324[(4)])));

return statearr_68385;
})();
var state_68324__$1 = state_68324;
var statearr_68386_68447 = state_68324__$1;
(statearr_68386_68447[(2)] = inst_68312);

(statearr_68386_68447[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (10))){
var inst_68182 = (state_68324[(10)]);
var inst_68184 = (state_68324[(2)]);
var inst_68188 = cljs.core.sequential_QMARK_.call(null,inst_68182);
var state_68324__$1 = (function (){var statearr_68387 = state_68324;
(statearr_68387[(24)] = inst_68184);

return statearr_68387;
})();
if(inst_68188){
var statearr_68388_68448 = state_68324__$1;
(statearr_68388_68448[(1)] = (11));

} else {
var statearr_68389_68449 = state_68324__$1;
(statearr_68389_68449[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (18))){
var inst_68184 = (state_68324[(24)]);
var inst_68182 = (state_68324[(10)]);
var inst_68204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68205 = cljs.core.pr_str.call(null,inst_68182);
var inst_68206 = ["Error processing ledger request, no valid return channel: ",inst_68205].join('');
var inst_68207 = [inst_68184,inst_68206];
var inst_68208 = (new cljs.core.PersistentVector(null,2,(5),inst_68204,inst_68207,null));
var inst_68209 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68208);
var state_68324__$1 = state_68324;
var statearr_68390_68450 = state_68324__$1;
(statearr_68390_68450[(2)] = inst_68209);

(statearr_68390_68450[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (37))){
var inst_68281 = (state_68324[(7)]);
var inst_68300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68301 = ["Error processing message in producer. Socket closed. Published result",inst_68281];
var inst_68302 = (new cljs.core.PersistentVector(null,2,(5),inst_68300,inst_68301,null));
var inst_68303 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68302);
var state_68324__$1 = state_68324;
var statearr_68391_68451 = state_68324__$1;
(statearr_68391_68451[(2)] = inst_68303);

(statearr_68391_68451[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68325 === (8))){
var inst_68228 = (state_68324[(12)]);
var inst_68229 = (state_68324[(16)]);
var inst_68182 = (state_68324[(10)]);
var inst_68227 = (state_68324[(18)]);
var _ = (function (){var statearr_68392 = state_68324;
(statearr_68392[(4)] = cljs.core.cons.call(null,(20),(state_68324[(4)])));

return statearr_68392;
})();
var inst_68221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68222 = ["Outgoing message to websocket: ",inst_68182];
var inst_68223 = (new cljs.core.PersistentVector(null,2,(5),inst_68221,inst_68222,null));
var inst_68224 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68223);
var inst_68225 = cljs.core.nth.call(null,inst_68182,(0),null);
var inst_68226 = cljs.core.nth.call(null,inst_68182,(1),null);
var inst_68227__$1 = cljs.core.nth.call(null,inst_68182,(2),null);
var inst_68228__$1 = cljs.core.nth.call(null,inst_68182,(3),null);
var inst_68229__$1 = cljs.core.__destructure_map.call(null,inst_68228__$1);
var inst_68230 = cljs.core.random_uuid.call(null);
var inst_68231 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68230);
var inst_68232 = cljs.core.get.call(null,inst_68229__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_68231);
var inst_68233 = cljs.core.get.call(null,inst_68229__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_68324__$1 = (function (){var statearr_68393 = state_68324;
(statearr_68393[(12)] = inst_68228__$1);

(statearr_68393[(13)] = inst_68225);

(statearr_68393[(14)] = inst_68224);

(statearr_68393[(15)] = inst_68232);

(statearr_68393[(16)] = inst_68229__$1);

(statearr_68393[(17)] = inst_68226);

(statearr_68393[(18)] = inst_68227__$1);

(statearr_68393[(19)] = inst_68233);

return statearr_68393;
})();
if(cljs.core.truth_(inst_68227__$1)){
var statearr_68394_68452 = state_68324__$1;
(statearr_68394_68452[(1)] = (21));

} else {
var statearr_68395_68453 = state_68324__$1;
(statearr_68395_68453[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____0 = (function (){
var statearr_68396 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68396[(0)] = fluree$db$connection$msg_producer_$_state_machine__2746__auto__);

(statearr_68396[(1)] = (1));

return statearr_68396;
});
var fluree$db$connection$msg_producer_$_state_machine__2746__auto____1 = (function (state_68324){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68324);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68397){var ex__2749__auto__ = e68397;
var statearr_68398_68454 = state_68324;
(statearr_68398_68454[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68324[(4)]))){
var statearr_68399_68455 = state_68324;
(statearr_68399_68455[(1)] = cljs.core.first.call(null,(state_68324[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68456 = state_68324;
state_68324 = G__68456;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2746__auto__ = function(state_68324){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2746__auto____1.call(this,state_68324);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68400 = f__2769__auto__.call(null);
(statearr_68400[(6)] = c__2768__auto__);

return statearr_68400;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.call(null,req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68494){
var state_val_68495 = (state_68494[(1)]);
if((state_val_68495 === (7))){
var inst_68465 = (state_68494[(7)]);
var state_68494__$1 = state_68494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68494__$1,(9),inst_68465);
} else {
if((state_val_68495 === (1))){
var inst_68457 = (1);
var state_68494__$1 = (function (){var statearr_68496 = state_68494;
(statearr_68496[(8)] = inst_68457);

return statearr_68496;
})();
var statearr_68497_68520 = state_68494__$1;
(statearr_68497_68520[(2)] = null);

(statearr_68497_68520[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (4))){
var inst_68462 = (state_68494[(2)]);
var inst_68463 = fluree.db.connection.get_socket.call(null,conn);
var state_68494__$1 = (function (){var statearr_68498 = state_68494;
(statearr_68498[(9)] = inst_68462);

return statearr_68498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68494__$1,(5),inst_68463);
} else {
if((state_val_68495 === (15))){
var inst_68490 = (state_68494[(2)]);
var state_68494__$1 = state_68494;
var statearr_68499_68521 = state_68494__$1;
(statearr_68499_68521[(2)] = inst_68490);

(statearr_68499_68521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (13))){
var inst_68472 = (state_68494[(10)]);
var inst_68457 = (state_68494[(8)]);
var inst_68480 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68481 = [inst_68472,"Cannot establish connection to a healthy server, backing off:",inst_68457,"s."];
var inst_68482 = (new cljs.core.PersistentVector(null,4,(5),inst_68480,inst_68481,null));
var inst_68483 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68482);
var inst_68484 = ((2) * inst_68457);
var inst_68485 = ((60) * (2));
var inst_68486 = ((inst_68484 < inst_68485) ? inst_68484 : inst_68485);
var inst_68457__$1 = inst_68486;
var state_68494__$1 = (function (){var statearr_68500 = state_68494;
(statearr_68500[(11)] = inst_68483);

(statearr_68500[(8)] = inst_68457__$1);

return statearr_68500;
})();
var statearr_68501_68522 = state_68494__$1;
(statearr_68501_68522[(2)] = null);

(statearr_68501_68522[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (6))){
var inst_68465 = (state_68494[(7)]);
var state_68494__$1 = state_68494;
var statearr_68502_68523 = state_68494__$1;
(statearr_68502_68523[(2)] = inst_68465);

(statearr_68502_68523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (3))){
var inst_68492 = (state_68494[(2)]);
var state_68494__$1 = state_68494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68494__$1,inst_68492);
} else {
if((state_val_68495 === (12))){
var inst_68478 = (state_68494[(2)]);
var state_68494__$1 = state_68494;
if(cljs.core.truth_(inst_68478)){
var statearr_68503_68524 = state_68494__$1;
(statearr_68503_68524[(1)] = (13));

} else {
var statearr_68504_68525 = state_68494__$1;
(statearr_68504_68525[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (2))){
var inst_68457 = (state_68494[(8)]);
var inst_68459 = (inst_68457 * (1000));
var inst_68460 = cljs.core.async.timeout.call(null,inst_68459);
var state_68494__$1 = state_68494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68494__$1,(4),inst_68460);
} else {
if((state_val_68495 === (11))){
var inst_68472 = (state_68494[(10)]);
var inst_68476 = fluree.db.util.core.exception_QMARK_.call(null,inst_68472);
var state_68494__$1 = state_68494;
var statearr_68505_68526 = state_68494__$1;
(statearr_68505_68526[(2)] = inst_68476);

(statearr_68505_68526[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (9))){
var inst_68470 = (state_68494[(2)]);
var state_68494__$1 = state_68494;
var statearr_68506_68527 = state_68494__$1;
(statearr_68506_68527[(2)] = inst_68470);

(statearr_68506_68527[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (5))){
var inst_68465 = (state_68494[(7)]);
var inst_68465__$1 = (state_68494[(2)]);
var inst_68466 = fluree.db.util.core.exception_QMARK_.call(null,inst_68465__$1);
var state_68494__$1 = (function (){var statearr_68507 = state_68494;
(statearr_68507[(7)] = inst_68465__$1);

return statearr_68507;
})();
if(inst_68466){
var statearr_68508_68528 = state_68494__$1;
(statearr_68508_68528[(1)] = (6));

} else {
var statearr_68509_68529 = state_68494__$1;
(statearr_68509_68529[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (14))){
var inst_68472 = (state_68494[(10)]);
var state_68494__$1 = state_68494;
var statearr_68510_68530 = state_68494__$1;
(statearr_68510_68530[(2)] = inst_68472);

(statearr_68510_68530[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (10))){
var inst_68473 = (state_68494[(12)]);
var state_68494__$1 = state_68494;
var statearr_68511_68531 = state_68494__$1;
(statearr_68511_68531[(2)] = inst_68473);

(statearr_68511_68531[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68495 === (8))){
var inst_68472 = (state_68494[(10)]);
var inst_68473 = (state_68494[(12)]);
var inst_68472__$1 = (state_68494[(2)]);
var inst_68473__$1 = (inst_68472__$1 == null);
var state_68494__$1 = (function (){var statearr_68512 = state_68494;
(statearr_68512[(10)] = inst_68472__$1);

(statearr_68512[(12)] = inst_68473__$1);

return statearr_68512;
})();
if(cljs.core.truth_(inst_68473__$1)){
var statearr_68513_68532 = state_68494__$1;
(statearr_68513_68532[(1)] = (10));

} else {
var statearr_68514_68533 = state_68494__$1;
(statearr_68514_68533[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0 = (function (){
var statearr_68515 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68515[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__);

(statearr_68515[(1)] = (1));

return statearr_68515;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1 = (function (state_68494){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68516){var ex__2749__auto__ = e68516;
var statearr_68517_68534 = state_68494;
(statearr_68517_68534[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68494[(4)]))){
var statearr_68518_68535 = state_68494;
(statearr_68518_68535[(1)] = cljs.core.first.call(null,(state_68494[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68536 = state_68494;
state_68494 = G__68536;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__ = function(state_68494){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1.call(this,state_68494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2746__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68519 = f__2769__auto__.call(null);
(statearr_68519[(6)] = c__2768__auto__);

return statearr_68519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__68537){
var map__68538 = p__68537;
var map__68538__$1 = cljs.core.__destructure_map.call(null,map__68538);
var conn = map__68538__$1;
var sub_chan = cljs.core.get.call(null,map__68538__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.call(null,map__68538__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.call(null,map__68538__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.call(null,map__68538__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68649){
var state_val_68650 = (state_68649[(1)]);
if((state_val_68650 === (7))){
var inst_68645 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68651_68707 = state_68649__$1;
(statearr_68651_68707[(2)] = inst_68645);

(statearr_68651_68707[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (20))){
var inst_68596 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68652_68708 = state_68649__$1;
(statearr_68652_68708[(2)] = inst_68596);

(statearr_68652_68708[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (27))){
var inst_68614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68615 = ["Connection closed."];
var inst_68616 = (new cljs.core.PersistentVector(null,1,(5),inst_68614,inst_68615,null));
var inst_68617 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_68616);
var state_68649__$1 = state_68649;
var statearr_68653_68709 = state_68649__$1;
(statearr_68653_68709[(2)] = inst_68617);

(statearr_68653_68709[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (1))){
var inst_68539 = (0);
var state_68649__$1 = (function (){var statearr_68654 = state_68649;
(statearr_68654[(7)] = inst_68539);

return statearr_68654;
})();
var statearr_68655_68710 = state_68649__$1;
(statearr_68655_68710[(2)] = null);

(statearr_68655_68710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (24))){
var inst_68583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68584 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_68585 = [keep_alive_fn];
var inst_68586 = cljs.core.PersistentHashMap.fromArrays(inst_68584,inst_68585);
var inst_68587 = ["Unsupported callback registered",inst_68586];
var inst_68588 = (new cljs.core.PersistentVector(null,2,(5),inst_68583,inst_68587,null));
var inst_68589 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68588);
var state_68649__$1 = state_68649;
var statearr_68656_68711 = state_68649__$1;
(statearr_68656_68711[(2)] = inst_68589);

(statearr_68656_68711[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (4))){
var inst_68544 = (state_68649[(8)]);
var inst_68549 = (state_68649[(2)]);
var inst_68550 = cljs.core.nth.call(null,inst_68549,(0),null);
var inst_68551 = cljs.core.nth.call(null,inst_68549,(1),null);
var inst_68552 = cljs.core._EQ_.call(null,inst_68551,inst_68544);
var state_68649__$1 = (function (){var statearr_68657 = state_68649;
(statearr_68657[(9)] = inst_68550);

return statearr_68657;
})();
if(inst_68552){
var statearr_68658_68712 = state_68649__$1;
(statearr_68658_68712[(1)] = (5));

} else {
var statearr_68659_68713 = state_68649__$1;
(statearr_68659_68713[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (15))){
var inst_68569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68570 = ["No keep-alive callback is registered"];
var inst_68571 = (new cljs.core.PersistentVector(null,1,(5),inst_68569,inst_68570,null));
var inst_68572 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68571);
var state_68649__$1 = state_68649;
var statearr_68660_68714 = state_68649__$1;
(statearr_68660_68714[(2)] = inst_68572);

(statearr_68660_68714[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (21))){
var inst_68580 = cljs.core.eval.call(null,keep_alive_fn);
var state_68649__$1 = state_68649;
var statearr_68661_68715 = state_68649__$1;
(statearr_68661_68715[(2)] = inst_68580);

(statearr_68661_68715[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (31))){
var state_68649__$1 = state_68649;
var statearr_68662_68716 = state_68649__$1;
(statearr_68662_68716[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (32))){
var inst_68641 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68664_68717 = state_68649__$1;
(statearr_68664_68717[(2)] = inst_68641);

(statearr_68664_68717[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (33))){
var inst_68550 = (state_68649[(9)]);
var inst_68628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68629 = fluree.db.util.json.parse.call(null,inst_68550);
var inst_68630 = cljs.core.pr_str.call(null,inst_68629);
var inst_68631 = ["Received message:",inst_68630];
var inst_68632 = (new cljs.core.PersistentVector(null,2,(5),inst_68628,inst_68631,null));
var inst_68633 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68632);
var inst_68634 = fluree.db.util.json.parse.call(null,inst_68550);
var inst_68635 = fluree.db.conn_events.process_events.call(null,conn,inst_68634);
var inst_68539 = (0);
var state_68649__$1 = (function (){var statearr_68665 = state_68649;
(statearr_68665[(10)] = inst_68635);

(statearr_68665[(7)] = inst_68539);

(statearr_68665[(11)] = inst_68633);

return statearr_68665;
})();
var statearr_68666_68718 = state_68649__$1;
(statearr_68666_68718[(2)] = null);

(statearr_68666_68718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (13))){
var inst_68604 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68667_68719 = state_68649__$1;
(statearr_68667_68719[(2)] = inst_68604);

(statearr_68667_68719[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (22))){
var state_68649__$1 = state_68649;
var statearr_68668_68720 = state_68649__$1;
(statearr_68668_68720[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (29))){
var inst_68643 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68670_68721 = state_68649__$1;
(statearr_68670_68721[(2)] = inst_68643);

(statearr_68670_68721[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (6))){
var inst_68550 = (state_68649[(9)]);
var inst_68612 = (inst_68550 == null);
var state_68649__$1 = state_68649;
if(cljs.core.truth_(inst_68612)){
var statearr_68671_68722 = state_68649__$1;
(statearr_68671_68722[(1)] = (27));

} else {
var statearr_68672_68723 = state_68649__$1;
(statearr_68672_68723[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (28))){
var inst_68550 = (state_68649[(9)]);
var inst_68619 = fluree.db.util.core.exception_QMARK_.call(null,inst_68550);
var state_68649__$1 = state_68649;
if(inst_68619){
var statearr_68673_68724 = state_68649__$1;
(statearr_68673_68724[(1)] = (30));

} else {
var statearr_68674_68725 = state_68649__$1;
(statearr_68674_68725[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (25))){
var state_68649__$1 = state_68649;
var statearr_68675_68726 = state_68649__$1;
(statearr_68675_68726[(2)] = null);

(statearr_68675_68726[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (34))){
var state_68649__$1 = state_68649;
var statearr_68676_68727 = state_68649__$1;
(statearr_68676_68727[(2)] = null);

(statearr_68676_68727[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (17))){
var inst_68598 = (state_68649[(2)]);
var inst_68599 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68600 = fluree.db.connection.close_websocket.call(null,inst_68599);
var inst_68601 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68602 = fluree.db.session.close_all_sessions.call(null,inst_68601);
var state_68649__$1 = (function (){var statearr_68677 = state_68649;
(statearr_68677[(12)] = inst_68600);

(statearr_68677[(13)] = inst_68598);

return statearr_68677;
})();
var statearr_68678_68728 = state_68649__$1;
(statearr_68678_68728[(2)] = inst_68602);

(statearr_68678_68728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (3))){
var inst_68647 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68649__$1,inst_68647);
} else {
if((state_val_68650 === (12))){
var inst_68562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68563 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_68564 = (new cljs.core.PersistentVector(null,1,(5),inst_68562,inst_68563,null));
var inst_68565 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68564);
var inst_68566 = keep_alive_fn;
var inst_68567 = (keep_alive_fn == null);
var state_68649__$1 = (function (){var statearr_68679 = state_68649;
(statearr_68679[(14)] = inst_68565);

(statearr_68679[(15)] = inst_68566);

return statearr_68679;
})();
if(cljs.core.truth_(inst_68567)){
var statearr_68680_68729 = state_68649__$1;
(statearr_68680_68729[(1)] = (15));

} else {
var statearr_68681_68730 = state_68649__$1;
(statearr_68681_68730[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (2))){
var inst_68544 = (state_68649[(8)]);
var inst_68544__$1 = cljs.core.async.timeout.call(null,ping_transactor_after);
var inst_68545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68546 = [sub_chan,inst_68544__$1];
var inst_68547 = (new cljs.core.PersistentVector(null,2,(5),inst_68545,inst_68546,null));
var state_68649__$1 = (function (){var statearr_68682 = state_68649;
(statearr_68682[(8)] = inst_68544__$1);

return statearr_68682;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_68649__$1,(4),inst_68547);
} else {
if((state_val_68650 === (23))){
var inst_68594 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68683_68731 = state_68649__$1;
(statearr_68683_68731[(2)] = inst_68594);

(statearr_68683_68731[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (35))){
var inst_68639 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68684_68732 = state_68649__$1;
(statearr_68684_68732[(2)] = inst_68639);

(statearr_68684_68732[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (19))){
var inst_68578 = typeof keep_alive_fn === 'string';
var state_68649__$1 = state_68649;
if(cljs.core.truth_(inst_68578)){
var statearr_68685_68733 = state_68649__$1;
(statearr_68685_68733[(1)] = (21));

} else {
var statearr_68686_68734 = state_68649__$1;
(statearr_68686_68734[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (11))){
var inst_68557 = fluree.db.connection.reconnect_conn.call(null,conn);
var state_68649__$1 = state_68649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68649__$1,(14),inst_68557);
} else {
if((state_val_68650 === (9))){
var inst_68539 = (state_68649[(7)]);
var inst_68606 = fluree.db.connection.ping_transactor.call(null,req_chan);
var inst_68607 = (inst_68539 + (1));
var inst_68539__$1 = inst_68607;
var state_68649__$1 = (function (){var statearr_68687 = state_68649;
(statearr_68687[(16)] = inst_68606);

(statearr_68687[(7)] = inst_68539__$1);

return statearr_68687;
})();
var statearr_68688_68735 = state_68649__$1;
(statearr_68688_68735[(2)] = null);

(statearr_68688_68735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (5))){
var inst_68539 = (state_68649[(7)]);
var inst_68554 = cljs.core._EQ_.call(null,(2),inst_68539);
var state_68649__$1 = state_68649;
if(inst_68554){
var statearr_68689_68736 = state_68649__$1;
(statearr_68689_68736[(1)] = (8));

} else {
var statearr_68690_68737 = state_68649__$1;
(statearr_68690_68737[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (14))){
var inst_68559 = (state_68649[(2)]);
var inst_68539 = (0);
var state_68649__$1 = (function (){var statearr_68691 = state_68649;
(statearr_68691[(17)] = inst_68559);

(statearr_68691[(7)] = inst_68539);

return statearr_68691;
})();
var statearr_68692_68738 = state_68649__$1;
(statearr_68692_68738[(2)] = null);

(statearr_68692_68738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (26))){
var inst_68592 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68693_68739 = state_68649__$1;
(statearr_68693_68739[(2)] = inst_68592);

(statearr_68693_68739[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (16))){
var inst_68574 = cljs.core.fn_QMARK_.call(null,keep_alive_fn);
var state_68649__$1 = state_68649;
if(inst_68574){
var statearr_68694_68740 = state_68649__$1;
(statearr_68694_68740[(1)] = (18));

} else {
var statearr_68695_68741 = state_68649__$1;
(statearr_68695_68741[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (30))){
var inst_68550 = (state_68649[(9)]);
var inst_68621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68622 = [inst_68550];
var inst_68623 = (new cljs.core.PersistentVector(null,1,(5),inst_68621,inst_68622,null));
var inst_68624 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68623);
var inst_68539 = (0);
var state_68649__$1 = (function (){var statearr_68696 = state_68649;
(statearr_68696[(7)] = inst_68539);

(statearr_68696[(18)] = inst_68624);

return statearr_68696;
})();
var statearr_68697_68742 = state_68649__$1;
(statearr_68697_68742[(2)] = null);

(statearr_68697_68742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (10))){
var inst_68610 = (state_68649[(2)]);
var state_68649__$1 = state_68649;
var statearr_68698_68743 = state_68649__$1;
(statearr_68698_68743[(2)] = inst_68610);

(statearr_68698_68743[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (18))){
var inst_68576 = keep_alive_fn.call(null);
var state_68649__$1 = state_68649;
var statearr_68699_68744 = state_68649__$1;
(statearr_68699_68744[(2)] = inst_68576);

(statearr_68699_68744[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68650 === (8))){
var state_68649__$1 = state_68649;
if(cljs.core.truth_(keep_alive)){
var statearr_68700_68745 = state_68649__$1;
(statearr_68700_68745[(1)] = (11));

} else {
var statearr_68701_68746 = state_68649__$1;
(statearr_68701_68746[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0 = (function (){
var statearr_68702 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68702[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2746__auto__);

(statearr_68702[(1)] = (1));

return statearr_68702;
});
var fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1 = (function (state_68649){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68703){var ex__2749__auto__ = e68703;
var statearr_68704_68747 = state_68649;
(statearr_68704_68747[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68649[(4)]))){
var statearr_68705_68748 = state_68649;
(statearr_68705_68748[(1)] = cljs.core.first.call(null,(state_68649[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68749 = state_68649;
state_68649 = G__68749;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__ = function(state_68649){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1.call(this,state_68649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2746__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68706 = f__2769__auto__.call(null);
(statearr_68706[(6)] = c__2768__auto__);

return statearr_68706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__68751 = arguments.length;
switch (G__68751) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.call(null,conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__68752 = opts;
var map__68752__$1 = cljs.core.__destructure_map.call(null,map__68752);
var private$ = cljs.core.get.call(null,map__68752__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.call(null,map__68752__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68804){
var state_val_68805 = (state_68804[(1)]);
if((state_val_68805 === (7))){
var inst_68762 = cljs.core.deref.call(null,fluree.db.connection.server_connections_atom);
var inst_68763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68764 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_68765 = (new cljs.core.PersistentVector(null,2,(5),inst_68763,inst_68764,null));
var inst_68766 = cljs.core.get_in.call(null,inst_68762,inst_68765);
var state_68804__$1 = state_68804;
var statearr_68806_68837 = state_68804__$1;
(statearr_68806_68837[(2)] = inst_68766);

(statearr_68806_68837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (1))){
var state_68804__$1 = state_68804;
var statearr_68807_68838 = state_68804__$1;
(statearr_68807_68838[(2)] = null);

(statearr_68807_68838[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (4))){
var inst_68753 = (state_68804[(2)]);
var state_68804__$1 = state_68804;
var statearr_68808_68839 = state_68804__$1;
(statearr_68808_68839[(2)] = inst_68753);

(statearr_68808_68839[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (15))){
var inst_68773 = (state_68804[(7)]);
var inst_68792 = (state_68804[(2)]);
var inst_68793 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_68794 = [(5000),inst_68792,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_68795 = cljs.core.PersistentHashMap.fromArrays(inst_68793,inst_68794);
var inst_68796 = fluree.db.util.xhttp.get.call(null,inst_68773,inst_68795);
var state_68804__$1 = state_68804;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68804__$1,(16),inst_68796);
} else {
if((state_val_68805 === (13))){
var inst_68773 = (state_68804[(7)]);
var inst_68783 = (state_68804[(8)]);
var inst_68785 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_68786 = [inst_68783];
var inst_68787 = cljs.core.PersistentHashMap.fromArrays(inst_68785,inst_68786);
var inst_68788 = fluree.db.query.http_signatures.sign_request.call(null,"get",inst_68773,inst_68787,private$);
var inst_68789 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_68788);
var state_68804__$1 = state_68804;
var statearr_68809_68840 = state_68804__$1;
(statearr_68809_68840[(2)] = inst_68789);

(statearr_68809_68840[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (6))){
var inst_68759 = (state_68804[(9)]);
var state_68804__$1 = state_68804;
var statearr_68810_68841 = state_68804__$1;
(statearr_68810_68841[(2)] = inst_68759);

(statearr_68810_68841[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (3))){
var inst_68802 = (state_68804[(2)]);
var state_68804__$1 = state_68804;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68804__$1,inst_68802);
} else {
if((state_val_68805 === (12))){
var inst_68783 = (state_68804[(2)]);
var state_68804__$1 = (function (){var statearr_68811 = state_68804;
(statearr_68811[(8)] = inst_68783);

return statearr_68811;
})();
if(cljs.core.truth_(private$)){
var statearr_68812_68842 = state_68804__$1;
(statearr_68812_68842[(1)] = (13));

} else {
var statearr_68813_68843 = state_68804__$1;
(statearr_68813_68843[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (2))){
var inst_68759 = (state_68804[(9)]);
var _ = (function (){var statearr_68814 = state_68804;
(statearr_68814[(4)] = cljs.core.cons.call(null,(5),(state_68804[(4)])));

return statearr_68814;
})();
var inst_68759__$1 = jwt;
var state_68804__$1 = (function (){var statearr_68815 = state_68804;
(statearr_68815[(9)] = inst_68759__$1);

return statearr_68815;
})();
if(cljs.core.truth_(inst_68759__$1)){
var statearr_68816_68844 = state_68804__$1;
(statearr_68816_68844[(1)] = (6));

} else {
var statearr_68817_68845 = state_68804__$1;
(statearr_68817_68845[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (11))){
var inst_68777 = (state_68804[(10)]);
var state_68804__$1 = state_68804;
var statearr_68819_68846 = state_68804__$1;
(statearr_68819_68846[(2)] = inst_68777);

(statearr_68819_68846[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (9))){
var inst_68768 = (state_68804[(11)]);
var inst_68769 = (state_68804[(12)]);
var inst_68772 = (state_68804[(2)]);
var inst_68773 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68772),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68769)].join('');
var inst_68775 = ["Accept"];
var inst_68776 = ["application/json"];
var inst_68777 = cljs.core.PersistentHashMap.fromArrays(inst_68775,inst_68776);
var state_68804__$1 = (function (){var statearr_68820 = state_68804;
(statearr_68820[(10)] = inst_68777);

(statearr_68820[(7)] = inst_68773);

return statearr_68820;
})();
if(cljs.core.truth_(inst_68768)){
var statearr_68821_68847 = state_68804__$1;
(statearr_68821_68847[(1)] = (10));

} else {
var statearr_68822_68848 = state_68804__$1;
(statearr_68822_68848[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (5))){
var _ = (function (){var statearr_68823 = state_68804;
(statearr_68823[(4)] = cljs.core.rest.call(null,(state_68804[(4)])));

return statearr_68823;
})();
var state_68804__$1 = state_68804;
var ex68818 = (state_68804__$1[(2)]);
var statearr_68824_68849 = state_68804__$1;
(statearr_68824_68849[(5)] = ex68818);


if((ex68818 instanceof Error)){
var statearr_68825_68850 = state_68804__$1;
(statearr_68825_68850[(1)] = (4));

(statearr_68825_68850[(5)] = null);

} else {
throw ex68818;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (14))){
var inst_68783 = (state_68804[(8)]);
var state_68804__$1 = state_68804;
var statearr_68826_68851 = state_68804__$1;
(statearr_68826_68851[(2)] = inst_68783);

(statearr_68826_68851[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (16))){
var inst_68798 = (state_68804[(2)]);
var inst_68799 = fluree.db.util.async.throw_err.call(null,inst_68798);
var _ = (function (){var statearr_68827 = state_68804;
(statearr_68827[(4)] = cljs.core.rest.call(null,(state_68804[(4)])));

return statearr_68827;
})();
var state_68804__$1 = state_68804;
var statearr_68828_68852 = state_68804__$1;
(statearr_68828_68852[(2)] = inst_68799);

(statearr_68828_68852[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (10))){
var inst_68768 = (state_68804[(11)]);
var inst_68777 = (state_68804[(10)]);
var inst_68779 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68768)].join('');
var inst_68780 = cljs.core.assoc.call(null,inst_68777,"Authorization",inst_68779);
var state_68804__$1 = state_68804;
var statearr_68829_68853 = state_68804__$1;
(statearr_68829_68853[(2)] = inst_68780);

(statearr_68829_68853[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68805 === (8))){
var inst_68768 = (state_68804[(2)]);
var inst_68769 = clojure.string.replace.call(null,k,"_","/");
var inst_68770 = fluree.db.connection.get_server.call(null,conn_id,servers);
var state_68804__$1 = (function (){var statearr_68830 = state_68804;
(statearr_68830[(11)] = inst_68768);

(statearr_68830[(12)] = inst_68769);

return statearr_68830;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68804__$1,(9),inst_68770);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_68831 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68831[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_68831[(1)] = (1));

return statearr_68831;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_68804){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68804);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68832){var ex__2749__auto__ = e68832;
var statearr_68833_68854 = state_68804;
(statearr_68833_68854[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68804[(4)]))){
var statearr_68834_68855 = state_68804;
(statearr_68834_68855[(1)] = cljs.core.first.call(null,(state_68804[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68856 = state_68804;
state_68804 = G__68856;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_68804){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_68804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68835 = f__2769__auto__.call(null);
(statearr_68835[(6)] = c__2768__auto__);

return statearr_68835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = value_fn.call(null,k);
cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.call(null);
var temp__5802__auto___68881 = fluree.db.connection.lookup_cache.call(null,cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___68881)){
var v_68882 = temp__5802__auto___68881;
cljs.core.async.put_BANG_.call(null,out,v_68882);
} else {
var c__2768__auto___68883 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68868){
var state_val_68869 = (state_68868[(1)]);
if((state_val_68869 === (1))){
var inst_68857 = value_fn.call(null,k);
var state_68868__$1 = state_68868;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68868__$1,(2),inst_68857);
} else {
if((state_val_68869 === (2))){
var inst_68859 = (state_68868[(7)]);
var inst_68859__$1 = (state_68868[(2)]);
var inst_68860 = fluree.db.util.core.exception_QMARK_.call(null,inst_68859__$1);
var state_68868__$1 = (function (){var statearr_68870 = state_68868;
(statearr_68870[(7)] = inst_68859__$1);

return statearr_68870;
})();
if(inst_68860){
var statearr_68871_68884 = state_68868__$1;
(statearr_68871_68884[(1)] = (3));

} else {
var statearr_68872_68885 = state_68868__$1;
(statearr_68872_68885[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68869 === (3))){
var state_68868__$1 = state_68868;
var statearr_68873_68886 = state_68868__$1;
(statearr_68873_68886[(2)] = null);

(statearr_68873_68886[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68869 === (4))){
var inst_68859 = (state_68868[(7)]);
var inst_68863 = cljs.core.swap_BANG_.call(null,cache_atom,cljs.cache.miss,k,inst_68859);
var state_68868__$1 = state_68868;
var statearr_68874_68887 = state_68868__$1;
(statearr_68874_68887[(2)] = inst_68863);

(statearr_68874_68887[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68869 === (5))){
var inst_68859 = (state_68868[(7)]);
var inst_68865 = (state_68868[(2)]);
var inst_68866 = cljs.core.async.put_BANG_.call(null,out,inst_68859);
var state_68868__$1 = (function (){var statearr_68875 = state_68868;
(statearr_68875[(8)] = inst_68865);

return statearr_68875;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68868__$1,inst_68866);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0 = (function (){
var statearr_68876 = [null,null,null,null,null,null,null,null,null];
(statearr_68876[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__);

(statearr_68876[(1)] = (1));

return statearr_68876;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1 = (function (state_68868){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68868);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68877){var ex__2749__auto__ = e68877;
var statearr_68878_68888 = state_68868;
(statearr_68878_68888[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68868[(4)]))){
var statearr_68879_68889 = state_68868;
(statearr_68879_68889[(1)] = cljs.core.first.call(null,(state_68868[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68890 = state_68868;
state_68868 = G__68890;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__ = function(state_68868){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1.call(this,state_68868);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68880 = f__2769__auto__.call(null);
(statearr_68880[(6)] = c__2768__auto___68883);

return statearr_68880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size);
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_.call(null,fn)){
} else {
throw cljs.core.ex_info.call(null,"add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.call(null,"add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__68891_SHARP_){
if(cljs.core.truth_(p1__68891_SHARP_)){
throw cljs.core.ex_info.call(null,["add-listener key already in use: ",cljs.core.pr_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.call(null,conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,key);

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db.call(null,conn,ledger,null);
return fluree.db.connection.add_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.call(null,fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__68892_SHARP_){
var or__5045__auto__ = p1__68892_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e68893){var e = e68893;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__68894 = opts;
var map__68894__$1 = cljs.core.__destructure_map.call(null,map__68894);
var sub_chan = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.call(null));
var storage_rename = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde.call(null));
var memory = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.call(null,["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.call(null));
var pub_chan = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.call(null));
var private_key_file = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.call(null,map__68894__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot.call(null,memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.call(null,["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.call(null,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn.call(null,default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn.call(null,default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null));
var close = (function (){
cljs.core.async.close_BANG_.call(null,req_chan);

cljs.core.async.close_BANG_.call(null,sub_chan);

cljs.core.async.close_BANG_.call(null,pub_chan);

fluree.db.connection.close_websocket.call(null,conn_id);

cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.call(null,conn_id);

cljs.core.reset_BANG_.call(null,default_cache_atom,fluree.db.connection.default_object_cache_factory.call(null,memory_object_size));

if(cljs.core.fn_QMARK_.call(null,close_fn)){
close_fn.call(null);
} else {
}

return fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers.call(null,servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.call(null,conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_.call(null,storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.call(null,storage_read)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_.call(null,storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.call(null,["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.call(null,storage_exists)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_.call(null,storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.call(null,storage_write)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.call(null,fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.call(null,fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_.call(null,keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection.call(null,settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_.call(null,conn))){
return false;
} else {
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn).call(null);

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68938 = arguments.length;
var i__5770__auto___68939 = (0);
while(true){
if((i__5770__auto___68939 < len__5769__auto___68938)){
args__5775__auto__.push((arguments[i__5770__auto___68939]));

var G__68940 = (i__5770__auto___68939 + (1));
i__5770__auto___68939 = G__68940;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__68897){
var vec__68898 = p__68897;
var opts = cljs.core.nth.call(null,vec__68898,(0),null);
var conn = fluree.db.connection.generate_connection.call(null,servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2768__auto___68941 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_68921){
var state_val_68922 = (state_68921[(1)]);
if((state_val_68922 === (1))){
var inst_68901 = fluree.db.connection.get_socket.call(null,conn);
var state_68921__$1 = state_68921;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68921__$1,(2),inst_68901);
} else {
if((state_val_68922 === (2))){
var inst_68903 = (state_68921[(7)]);
var inst_68904 = (state_68921[(8)]);
var inst_68903__$1 = (state_68921[(2)]);
var inst_68904__$1 = (inst_68903__$1 == null);
var state_68921__$1 = (function (){var statearr_68923 = state_68921;
(statearr_68923[(7)] = inst_68903__$1);

(statearr_68923[(8)] = inst_68904__$1);

return statearr_68923;
})();
if(cljs.core.truth_(inst_68904__$1)){
var statearr_68924_68942 = state_68921__$1;
(statearr_68924_68942[(1)] = (3));

} else {
var statearr_68925_68943 = state_68921__$1;
(statearr_68925_68943[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68922 === (3))){
var inst_68904 = (state_68921[(8)]);
var state_68921__$1 = state_68921;
var statearr_68926_68944 = state_68921__$1;
(statearr_68926_68944[(2)] = inst_68904);

(statearr_68926_68944[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68922 === (4))){
var inst_68903 = (state_68921[(7)]);
var inst_68907 = fluree.db.util.core.exception_QMARK_.call(null,inst_68903);
var state_68921__$1 = state_68921;
var statearr_68927_68945 = state_68921__$1;
(statearr_68927_68945[(2)] = inst_68907);

(statearr_68927_68945[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68922 === (5))){
var inst_68909 = (state_68921[(2)]);
var state_68921__$1 = state_68921;
if(cljs.core.truth_(inst_68909)){
var statearr_68928_68946 = state_68921__$1;
(statearr_68928_68946[(1)] = (6));

} else {
var statearr_68929_68947 = state_68921__$1;
(statearr_68929_68947[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68922 === (6))){
var inst_68903 = (state_68921[(7)]);
var inst_68911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68912 = [inst_68903,"Cannot establish connection to a healthy server, disconnecting."];
var inst_68913 = (new cljs.core.PersistentVector(null,2,(5),inst_68911,inst_68912,null));
var inst_68914 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68913);
var inst_68915 = cljs.core.async.close_BANG_.call(null,conn);
var state_68921__$1 = (function (){var statearr_68930 = state_68921;
(statearr_68930[(9)] = inst_68914);

return statearr_68930;
})();
var statearr_68931_68948 = state_68921__$1;
(statearr_68931_68948[(2)] = inst_68915);

(statearr_68931_68948[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68922 === (7))){
var inst_68917 = fluree.db.connection.msg_consumer.call(null,conn);
var state_68921__$1 = state_68921;
var statearr_68932_68949 = state_68921__$1;
(statearr_68932_68949[(2)] = inst_68917);

(statearr_68932_68949[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68922 === (8))){
var inst_68919 = (state_68921[(2)]);
var state_68921__$1 = state_68921;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68921__$1,inst_68919);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2746__auto__ = null;
var fluree$db$connection$state_machine__2746__auto____0 = (function (){
var statearr_68933 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68933[(0)] = fluree$db$connection$state_machine__2746__auto__);

(statearr_68933[(1)] = (1));

return statearr_68933;
});
var fluree$db$connection$state_machine__2746__auto____1 = (function (state_68921){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_68921);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e68934){var ex__2749__auto__ = e68934;
var statearr_68935_68950 = state_68921;
(statearr_68935_68950[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_68921[(4)]))){
var statearr_68936_68951 = state_68921;
(statearr_68936_68951[(1)] = cljs.core.first.call(null,(state_68921[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68952 = state_68921;
state_68921 = G__68952;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2746__auto__ = function(state_68921){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2746__auto____1.call(this,state_68921);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2746__auto____0;
fluree$db$connection$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2746__auto____1;
return fluree$db$connection$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_68937 = f__2769__auto__.call(null);
(statearr_68937[(6)] = c__2768__auto___68941);

return statearr_68937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

}

fluree.db.connection.msg_producer.call(null,conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq68895){
var G__68896 = cljs.core.first.call(null,seq68895);
var seq68895__$1 = cljs.core.next.call(null,seq68895);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68896,seq68895__$1);
}));

