// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69579 = arguments.length;
var i__5770__auto___69580 = (0);
while(true){
if((i__5770__auto___69580 < len__5769__auto___69579)){
args__5775__auto__.push((arguments[i__5770__auto___69580]));

var G__69581 = (i__5770__auto___69580 + (1));
i__5770__auto___69580 = G__69581;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__69508){
var vec__69509 = p__69508;
var opts = cljs.core.nth.call(null,vec__69509,(0),null);
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___69582 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69556){
var state_val_69557 = (state_69556[(1)]);
if((state_val_69557 === (7))){
var inst_69533 = (state_69556[(7)]);
var inst_69542 = (state_69556[(8)]);
var inst_69544 = fluree.db.time_travel.as_of_block.call(null,inst_69542,inst_69533);
var state_69556__$1 = state_69556;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69556__$1,(10),inst_69544);
} else {
if((state_val_69557 === (1))){
var state_69556__$1 = state_69556;
var statearr_69558_69583 = state_69556__$1;
(statearr_69558_69583[(2)] = null);

(statearr_69558_69583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69557 === (4))){
var inst_69512 = (state_69556[(2)]);
var inst_69513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69514 = [inst_69512];
var inst_69515 = (new cljs.core.PersistentVector(null,1,(5),inst_69513,inst_69514,null));
var inst_69516 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69515);
var inst_69517 = cljs.core.async.put_BANG_.call(null,pc,inst_69512);
var inst_69518 = cljs.core.async.close_BANG_.call(null,pc);
var state_69556__$1 = (function (){var statearr_69559 = state_69556;
(statearr_69559[(9)] = inst_69516);

(statearr_69559[(10)] = inst_69517);

return statearr_69559;
})();
var statearr_69560_69584 = state_69556__$1;
(statearr_69560_69584[(2)] = inst_69518);

(statearr_69560_69584[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69557 === (6))){
var inst_69536 = (state_69556[(11)]);
var inst_69533 = (state_69556[(7)]);
var inst_69537 = (state_69556[(12)]);
var inst_69540 = (state_69556[(2)]);
var inst_69541 = fluree.db.util.async.throw_err.call(null,inst_69540);
var inst_69542 = cljs.core.assoc.call(null,inst_69541,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_69536,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_69537);
var state_69556__$1 = (function (){var statearr_69561 = state_69556;
(statearr_69561[(8)] = inst_69542);

return statearr_69561;
})();
if(cljs.core.truth_(inst_69533)){
var statearr_69562_69585 = state_69556__$1;
(statearr_69562_69585[(1)] = (7));

} else {
var statearr_69563_69586 = state_69556__$1;
(statearr_69563_69586[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69557 === (3))){
var inst_69554 = (state_69556[(2)]);
var state_69556__$1 = state_69556;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69556__$1,inst_69554);
} else {
if((state_val_69557 === (2))){
var _ = (function (){var statearr_69565 = state_69556;
(statearr_69565[(4)] = cljs.core.cons.call(null,(5),(state_69556[(4)])));

return statearr_69565;
})();
var inst_69528 = opts;
var inst_69529 = cljs.core.__destructure_map.call(null,inst_69528);
var inst_69530 = cljs.core.get.call(null,inst_69529,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69531 = cljs.core.get.call(null,inst_69529,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69532 = cljs.core.get.call(null,inst_69529,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69533 = cljs.core.get.call(null,inst_69529,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69534 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_69535 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_69536 = cljs.core.nth.call(null,inst_69535,(0),null);
var inst_69537 = cljs.core.nth.call(null,inst_69535,(1),null);
var inst_69538 = fluree.db.session.db.call(null,conn,ledger,opts);
var state_69556__$1 = (function (){var statearr_69566 = state_69556;
(statearr_69566[(13)] = inst_69530);

(statearr_69566[(11)] = inst_69536);

(statearr_69566[(7)] = inst_69533);

(statearr_69566[(14)] = inst_69531);

(statearr_69566[(15)] = inst_69534);

(statearr_69566[(12)] = inst_69537);

(statearr_69566[(16)] = inst_69532);

return statearr_69566;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69556__$1,(6),inst_69538);
} else {
if((state_val_69557 === (9))){
var inst_69550 = (state_69556[(2)]);
var inst_69551 = cljs.core.async.put_BANG_.call(null,pc,inst_69550);
var _ = (function (){var statearr_69567 = state_69556;
(statearr_69567[(4)] = cljs.core.rest.call(null,(state_69556[(4)])));

return statearr_69567;
})();
var state_69556__$1 = state_69556;
var statearr_69568_69587 = state_69556__$1;
(statearr_69568_69587[(2)] = inst_69551);

(statearr_69568_69587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69557 === (5))){
var _ = (function (){var statearr_69569 = state_69556;
(statearr_69569[(4)] = cljs.core.rest.call(null,(state_69556[(4)])));

return statearr_69569;
})();
var state_69556__$1 = state_69556;
var ex69564 = (state_69556__$1[(2)]);
var statearr_69570_69588 = state_69556__$1;
(statearr_69570_69588[(5)] = ex69564);


var statearr_69571_69589 = state_69556__$1;
(statearr_69571_69589[(1)] = (4));

(statearr_69571_69589[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69557 === (10))){
var inst_69546 = (state_69556[(2)]);
var inst_69547 = fluree.db.util.async.throw_err.call(null,inst_69546);
var state_69556__$1 = state_69556;
var statearr_69572_69590 = state_69556__$1;
(statearr_69572_69590[(2)] = inst_69547);

(statearr_69572_69590[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69557 === (8))){
var inst_69542 = (state_69556[(8)]);
var state_69556__$1 = state_69556;
var statearr_69573_69591 = state_69556__$1;
(statearr_69573_69591[(2)] = inst_69542);

(statearr_69573_69591[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_69574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69574[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_69574[(1)] = (1));

return statearr_69574;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_69556){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69556);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69575){var ex__2749__auto__ = e69575;
var statearr_69576_69592 = state_69556;
(statearr_69576_69592[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69556[(4)]))){
var statearr_69577_69593 = state_69556;
(statearr_69577_69593[(1)] = cljs.core.first.call(null,(state_69556[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69594 = state_69556;
state_69556 = G__69594;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_69556){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_69556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69578 = f__2769__auto__.call(null);
(statearr_69578[(6)] = c__2768__auto___69582);

return statearr_69578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq69505){
var G__69506 = cljs.core.first.call(null,seq69505);
var seq69505__$1 = cljs.core.next.call(null,seq69505);
var G__69507 = cljs.core.first.call(null,seq69505__$1);
var seq69505__$2 = cljs.core.next.call(null,seq69505__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69506,G__69507,seq69505__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.call(null,network,cljs.core.first.call(null,clojure.string.split.call(null,val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,opts);
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.call(null,"When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_.call(null,val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id.call(null,val);
var ledger = cljs.core.apply.call(null,db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.call(null,acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__69596 = arguments.length;
switch (G__69596) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.call(null,sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69725){
var state_val_69726 = (state_69725[(1)]);
if((state_val_69726 === (7))){
var inst_69615 = (state_69725[(7)]);
var inst_69625 = (state_69725[(8)]);
var inst_69627 = fluree.db.time_travel.as_of_block.call(null,inst_69625,inst_69615);
var state_69725__$1 = state_69725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69725__$1,(10),inst_69627);
} else {
if((state_val_69726 === (20))){
var inst_69619 = (state_69725[(9)]);
var state_69725__$1 = state_69725;
var statearr_69727_69807 = state_69725__$1;
(statearr_69727_69807[(2)] = inst_69619);

(statearr_69727_69807[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (27))){
var inst_69613 = (state_69725[(10)]);
var state_69725__$1 = state_69725;
var statearr_69728_69808 = state_69725__$1;
(statearr_69728_69808[(2)] = inst_69613);

(statearr_69728_69808[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (1))){
var state_69725__$1 = state_69725;
var statearr_69729_69809 = state_69725__$1;
(statearr_69729_69809[(2)] = null);

(statearr_69729_69809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (24))){
var inst_69622 = (state_69725[(11)]);
var state_69725__$1 = state_69725;
if(cljs.core.truth_(inst_69622)){
var statearr_69730_69810 = state_69725__$1;
(statearr_69730_69810[(1)] = (26));

} else {
var statearr_69731_69811 = state_69725__$1;
(statearr_69731_69811[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (39))){
var inst_69687 = (state_69725[(12)]);
var inst_69690 = cljs.core.ex_data.call(null,inst_69687);
var inst_69691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69692 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_69690);
var inst_69693 = cljs.core.ex_message.call(null,inst_69687);
var inst_69694 = [inst_69692,inst_69693,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69695 = cljs.core.PersistentHashMap.fromArrays(inst_69691,inst_69694);
var state_69725__$1 = state_69725;
var statearr_69732_69812 = state_69725__$1;
(statearr_69732_69812[(2)] = inst_69695);

(statearr_69732_69812[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (46))){
var inst_69687 = (state_69725[(12)]);
var state_69725__$1 = state_69725;
var statearr_69733_69813 = state_69725__$1;
(statearr_69733_69813[(2)] = inst_69687);

(statearr_69733_69813[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (4))){
var inst_69597 = (state_69725[(2)]);
var inst_69598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69599 = [inst_69597];
var inst_69600 = (new cljs.core.PersistentVector(null,1,(5),inst_69598,inst_69599,null));
var inst_69601 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69600);
var inst_69602 = cljs.core.ex_data.call(null,inst_69597);
var inst_69603 = cljs.core.ex_message.call(null,inst_69597);
var inst_69604 = cljs.core.assoc.call(null,inst_69602,new cljs.core.Keyword(null,"message","message",-406056002),inst_69603);
var state_69725__$1 = (function (){var statearr_69734 = state_69725;
(statearr_69734[(13)] = inst_69601);

return statearr_69734;
})();
var statearr_69735_69814 = state_69725__$1;
(statearr_69735_69814[(2)] = inst_69604);

(statearr_69735_69814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (15))){
var state_69725__$1 = state_69725;
var statearr_69736_69815 = state_69725__$1;
(statearr_69736_69815[(2)] = (1000000));

(statearr_69736_69815[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (48))){
var inst_69687 = (state_69725[(12)]);
var state_69725__$1 = state_69725;
var statearr_69737_69816 = state_69725__$1;
(statearr_69737_69816[(2)] = inst_69687);

(statearr_69737_69816[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (50))){
var inst_69714 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69738_69817 = state_69725__$1;
(statearr_69738_69817[(2)] = inst_69714);

(statearr_69738_69817[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (21))){
var inst_69618 = (state_69725[(14)]);
var state_69725__$1 = state_69725;
if(cljs.core.truth_(inst_69618)){
var statearr_69739_69818 = state_69725__$1;
(statearr_69739_69818[(1)] = (23));

} else {
var statearr_69740_69819 = state_69725__$1;
(statearr_69740_69819[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (31))){
var inst_69676 = (state_69725[(2)]);
var inst_69677 = cljs.core.not.call(null,inst_69676);
var state_69725__$1 = state_69725;
if(inst_69677){
var statearr_69741_69820 = state_69725__$1;
(statearr_69741_69820[(1)] = (35));

} else {
var statearr_69742_69821 = state_69725__$1;
(statearr_69742_69821[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (32))){
var inst_69620 = (state_69725[(15)]);
var state_69725__$1 = state_69725;
var statearr_69743_69822 = state_69725__$1;
(statearr_69743_69822[(2)] = inst_69620);

(statearr_69743_69822[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (40))){
var inst_69650 = (state_69725[(16)]);
var state_69725__$1 = state_69725;
if(cljs.core.truth_(inst_69650)){
var statearr_69744_69823 = state_69725__$1;
(statearr_69744_69823[(1)] = (42));

} else {
var statearr_69745_69824 = state_69725__$1;
(statearr_69745_69824[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (33))){
var inst_69616 = (state_69725[(17)]);
var state_69725__$1 = state_69725;
var statearr_69746_69825 = state_69725__$1;
(statearr_69746_69825[(2)] = inst_69616);

(statearr_69746_69825[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (13))){
var inst_69645 = (state_69725[(18)]);
var inst_69621 = (state_69725[(19)]);
var inst_69643 = (state_69725[(2)]);
var inst_69644 = cljs.core.volatile_BANG_.call(null,(0));
var inst_69645__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_69621);
var state_69725__$1 = (function (){var statearr_69747 = state_69725;
(statearr_69747[(18)] = inst_69645__$1);

(statearr_69747[(20)] = inst_69644);

(statearr_69747[(21)] = inst_69643);

return statearr_69747;
})();
if(cljs.core.truth_(inst_69645__$1)){
var statearr_69748_69826 = state_69725__$1;
(statearr_69748_69826[(1)] = (14));

} else {
var statearr_69749_69827 = state_69725__$1;
(statearr_69749_69827[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (22))){
var inst_69666 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69750_69828 = state_69725__$1;
(statearr_69750_69828[(2)] = inst_69666);

(statearr_69750_69828[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (36))){
var inst_69633 = (state_69725[(22)]);
var inst_69652 = (state_69725[(23)]);
var inst_69683 = cljs.core.assoc.call(null,query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_69652);
var inst_69684 = fluree.db.query.fql.query.call(null,inst_69633,inst_69683);
var state_69725__$1 = state_69725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69725__$1,(38),inst_69684);
} else {
if((state_val_69726 === (41))){
var inst_69718 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69751_69829 = state_69725__$1;
(statearr_69751_69829[(2)] = inst_69718);

(statearr_69751_69829[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (43))){
var state_69725__$1 = state_69725;
var statearr_69752_69830 = state_69725__$1;
(statearr_69752_69830[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (29))){
var inst_69620 = (state_69725[(15)]);
var state_69725__$1 = state_69725;
if(cljs.core.truth_(inst_69620)){
var statearr_69754_69831 = state_69725__$1;
(statearr_69754_69831[(1)] = (32));

} else {
var statearr_69755_69832 = state_69725__$1;
(statearr_69755_69832[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (44))){
var inst_69716 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69756_69833 = state_69725__$1;
(statearr_69756_69833[(2)] = inst_69716);

(statearr_69756_69833[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (6))){
var inst_69615 = (state_69725[(7)]);
var inst_69624 = (state_69725[(2)]);
var inst_69625 = fluree.db.util.async.throw_err.call(null,inst_69624);
var state_69725__$1 = (function (){var statearr_69757 = state_69725;
(statearr_69757[(8)] = inst_69625);

return statearr_69757;
})();
if(cljs.core.truth_(inst_69615)){
var statearr_69758_69834 = state_69725__$1;
(statearr_69758_69834[(1)] = (7));

} else {
var statearr_69759_69835 = state_69725__$1;
(statearr_69759_69835[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (28))){
var inst_69662 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69760_69836 = state_69725__$1;
(statearr_69760_69836[(2)] = inst_69662);

(statearr_69760_69836[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (25))){
var inst_69664 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69761_69837 = state_69725__$1;
(statearr_69761_69837[(2)] = inst_69664);

(statearr_69761_69837[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (34))){
var inst_69673 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
var statearr_69762_69838 = state_69725__$1;
(statearr_69762_69838[(2)] = inst_69673);

(statearr_69762_69838[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (17))){
var inst_69614 = (state_69725[(24)]);
var state_69725__$1 = state_69725;
var statearr_69763_69839 = state_69725__$1;
(statearr_69763_69839[(2)] = inst_69614);

(statearr_69763_69839[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (3))){
var inst_69723 = (state_69725[(2)]);
var state_69725__$1 = state_69725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69725__$1,inst_69723);
} else {
if((state_val_69726 === (12))){
var inst_69641 = cljs.core.PersistentHashMap.EMPTY;
var state_69725__$1 = state_69725;
var statearr_69764_69840 = state_69725__$1;
(statearr_69764_69840[(2)] = inst_69641);

(statearr_69764_69840[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (2))){
var _ = (function (){var statearr_69765 = state_69725;
(statearr_69765[(4)] = cljs.core.cons.call(null,(5),(state_69725[(4)])));

return statearr_69765;
})();
var inst_69611 = query_map;
var inst_69612 = cljs.core.__destructure_map.call(null,inst_69611);
var inst_69613 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_69614 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_69615 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69616 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_69617 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_69618 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_69619 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_69620 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_69621 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69622 = cljs.core.get.call(null,inst_69612,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_69725__$1 = (function (){var statearr_69766 = state_69725;
(statearr_69766[(10)] = inst_69613);

(statearr_69766[(25)] = inst_69617);

(statearr_69766[(9)] = inst_69619);

(statearr_69766[(24)] = inst_69614);

(statearr_69766[(11)] = inst_69622);

(statearr_69766[(15)] = inst_69620);

(statearr_69766[(14)] = inst_69618);

(statearr_69766[(7)] = inst_69615);

(statearr_69766[(17)] = inst_69616);

(statearr_69766[(19)] = inst_69621);

return statearr_69766;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69725__$1,(6),sources);
} else {
if((state_val_69726 === (23))){
var inst_69618 = (state_69725[(14)]);
var state_69725__$1 = state_69725;
var statearr_69767_69841 = state_69725__$1;
(statearr_69767_69841[(2)] = inst_69618);

(statearr_69767_69841[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (47))){
var inst_69698 = (state_69725[(26)]);
var inst_69633 = (state_69725[(22)]);
var inst_69644 = (state_69725[(20)]);
var inst_69651 = (state_69725[(27)]);
var inst_69704 = (state_69725[(2)]);
var inst_69705 = cljs.core.deref.call(null,inst_69644);
var inst_69706 = fluree.db.util.core.response_time_formatted.call(null,inst_69651);
var inst_69707 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_69633);
var inst_69708 = [(200),inst_69704,inst_69705,inst_69706,inst_69707];
var inst_69709 = cljs.core.PersistentHashMap.fromArrays(inst_69698,inst_69708);
var state_69725__$1 = state_69725;
var statearr_69768_69842 = state_69725__$1;
(statearr_69768_69842[(2)] = inst_69709);

(statearr_69768_69842[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (35))){
var inst_69679 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69680 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_69681 = cljs.core.PersistentHashMap.fromArrays(inst_69679,inst_69680);
var state_69725__$1 = state_69725;
var statearr_69769_69843 = state_69725__$1;
(statearr_69769_69843[(2)] = inst_69681);

(statearr_69769_69843[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (19))){
var inst_69668 = (state_69725[(28)]);
var inst_69668__$1 = (state_69725[(2)]);
var state_69725__$1 = (function (){var statearr_69770 = state_69725;
(statearr_69770[(28)] = inst_69668__$1);

return statearr_69770;
})();
if(cljs.core.truth_(inst_69668__$1)){
var statearr_69771_69844 = state_69725__$1;
(statearr_69771_69844[(1)] = (29));

} else {
var statearr_69772_69845 = state_69725__$1;
(statearr_69772_69845[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (11))){
var inst_69633 = (state_69725[(22)]);
var inst_69617 = (state_69725[(25)]);
var inst_69634 = (state_69725[(29)]);
var inst_69636 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_69633);
var inst_69637 = fluree.db.connection_js.open_api_QMARK_.call(null,inst_69634);
var inst_69638 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_69633);
var inst_69639 = fluree.db.api_js.get_sources.call(null,inst_69634,inst_69636,inst_69637,inst_69638,inst_69617,db_fn);
var state_69725__$1 = state_69725;
var statearr_69774_69846 = state_69725__$1;
(statearr_69774_69846[(2)] = inst_69639);

(statearr_69774_69846[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (9))){
var inst_69633 = (state_69725[(22)]);
var inst_69617 = (state_69725[(25)]);
var inst_69633__$1 = (state_69725[(2)]);
var inst_69634 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_69633__$1);
var state_69725__$1 = (function (){var statearr_69775 = state_69725;
(statearr_69775[(22)] = inst_69633__$1);

(statearr_69775[(29)] = inst_69634);

return statearr_69775;
})();
if(cljs.core.truth_(inst_69617)){
var statearr_69776_69847 = state_69725__$1;
(statearr_69776_69847[(1)] = (11));

} else {
var statearr_69777_69848 = state_69725__$1;
(statearr_69777_69848[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (5))){
var _ = (function (){var statearr_69778 = state_69725;
(statearr_69778[(4)] = cljs.core.rest.call(null,(state_69725[(4)])));

return statearr_69778;
})();
var state_69725__$1 = state_69725;
var ex69773 = (state_69725__$1[(2)]);
var statearr_69779_69849 = state_69725__$1;
(statearr_69779_69849[(5)] = ex69773);


var statearr_69780_69850 = state_69725__$1;
(statearr_69780_69850[(1)] = (4));

(statearr_69780_69850[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (14))){
var inst_69645 = (state_69725[(18)]);
var state_69725__$1 = state_69725;
var statearr_69781_69851 = state_69725__$1;
(statearr_69781_69851[(2)] = inst_69645);

(statearr_69781_69851[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (45))){
var inst_69687 = (state_69725[(12)]);
var inst_69701 = cljs.core.doall.call(null,inst_69687);
var state_69725__$1 = state_69725;
var statearr_69782_69852 = state_69725__$1;
(statearr_69782_69852[(2)] = inst_69701);

(statearr_69782_69852[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (26))){
var inst_69622 = (state_69725[(11)]);
var state_69725__$1 = state_69725;
var statearr_69783_69853 = state_69725__$1;
(statearr_69783_69853[(2)] = inst_69622);

(statearr_69783_69853[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (16))){
var inst_69614 = (state_69725[(24)]);
var inst_69644 = (state_69725[(20)]);
var inst_69643 = (state_69725[(21)]);
var inst_69621 = (state_69725[(19)]);
var inst_69649 = (state_69725[(2)]);
var inst_69650 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69621);
var inst_69651 = fluree.db.util.core.current_time_millis.call(null);
var inst_69652 = cljs.core.assoc.call(null,inst_69621,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_69643,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_69649,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_69644);
var state_69725__$1 = (function (){var statearr_69784 = state_69725;
(statearr_69784[(23)] = inst_69652);

(statearr_69784[(27)] = inst_69651);

(statearr_69784[(16)] = inst_69650);

return statearr_69784;
})();
if(cljs.core.truth_(inst_69614)){
var statearr_69785_69854 = state_69725__$1;
(statearr_69785_69854[(1)] = (17));

} else {
var statearr_69786_69855 = state_69725__$1;
(statearr_69786_69855[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (38))){
var inst_69687 = (state_69725[(12)]);
var inst_69686 = (state_69725[(2)]);
var inst_69687__$1 = fluree.db.util.async.throw_err.call(null,inst_69686);
var inst_69688 = (inst_69687__$1 instanceof cljs.core.ExceptionInfo);
var state_69725__$1 = (function (){var statearr_69787 = state_69725;
(statearr_69787[(12)] = inst_69687__$1);

return statearr_69787;
})();
if(cljs.core.truth_(inst_69688)){
var statearr_69788_69856 = state_69725__$1;
(statearr_69788_69856[(1)] = (39));

} else {
var statearr_69789_69857 = state_69725__$1;
(statearr_69789_69857[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (30))){
var inst_69668 = (state_69725[(28)]);
var state_69725__$1 = state_69725;
var statearr_69790_69858 = state_69725__$1;
(statearr_69790_69858[(2)] = inst_69668);

(statearr_69790_69858[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (10))){
var inst_69629 = (state_69725[(2)]);
var inst_69630 = fluree.db.util.async.throw_err.call(null,inst_69629);
var state_69725__$1 = state_69725;
var statearr_69791_69859 = state_69725__$1;
(statearr_69791_69859[(2)] = inst_69630);

(statearr_69791_69859[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (18))){
var inst_69619 = (state_69725[(9)]);
var state_69725__$1 = state_69725;
if(cljs.core.truth_(inst_69619)){
var statearr_69792_69860 = state_69725__$1;
(statearr_69792_69860[(1)] = (20));

} else {
var statearr_69793_69861 = state_69725__$1;
(statearr_69793_69861[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (42))){
var inst_69687 = (state_69725[(12)]);
var inst_69698 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_69699 = cljs.core.sequential_QMARK_.call(null,inst_69687);
var state_69725__$1 = (function (){var statearr_69794 = state_69725;
(statearr_69794[(26)] = inst_69698);

return statearr_69794;
})();
if(inst_69699){
var statearr_69795_69862 = state_69725__$1;
(statearr_69795_69862[(1)] = (45));

} else {
var statearr_69796_69863 = state_69725__$1;
(statearr_69796_69863[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (37))){
var inst_69720 = (state_69725[(2)]);
var _ = (function (){var statearr_69797 = state_69725;
(statearr_69797[(4)] = cljs.core.rest.call(null,(state_69725[(4)])));

return statearr_69797;
})();
var state_69725__$1 = state_69725;
var statearr_69798_69864 = state_69725__$1;
(statearr_69798_69864[(2)] = inst_69720);

(statearr_69798_69864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (8))){
var inst_69625 = (state_69725[(8)]);
var state_69725__$1 = state_69725;
var statearr_69799_69865 = state_69725__$1;
(statearr_69799_69865[(2)] = inst_69625);

(statearr_69799_69865[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69726 === (49))){
var state_69725__$1 = state_69725;
var statearr_69800_69866 = state_69725__$1;
(statearr_69800_69866[(2)] = null);

(statearr_69800_69866[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_69801 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69801[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_69801[(1)] = (1));

return statearr_69801;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_69725){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69802){var ex__2749__auto__ = e69802;
var statearr_69803_69867 = state_69725;
(statearr_69803_69867[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69725[(4)]))){
var statearr_69804_69868 = state_69725;
(statearr_69804_69868[(1)] = cljs.core.first.call(null,(state_69725[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69869 = state_69725;
state_69725 = G__69869;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_69725){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_69725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69805 = f__2769__auto__.call(null);
(statearr_69805[(6)] = c__2768__auto__);

return statearr_69805;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.call(null,conn,ledger);
var key = cljs.core.random_uuid.call(null);
var resp_chan = cljs.core.async.chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout_ms);
fluree.db.session.monitor_tx.call(null,session,tid,key,(function (p1__69870_SHARP_){
return cljs.core.async.put_BANG_.call(null,resp_chan,p1__69870_SHARP_);
}));

var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69892){
var state_val_69893 = (state_69892[(1)]);
if((state_val_69893 === (1))){
var inst_69874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69875 = [resp_chan,timeout_chan];
var inst_69876 = (new cljs.core.PersistentVector(null,2,(5),inst_69874,inst_69875,null));
var state_69892__$1 = state_69892;
return cljs.core.async.ioc_alts_BANG_.call(null,state_69892__$1,(2),inst_69876);
} else {
if((state_val_69893 === (2))){
var inst_69878 = (state_69892[(2)]);
var inst_69879 = cljs.core.nth.call(null,inst_69878,(0),null);
var inst_69880 = cljs.core.nth.call(null,inst_69878,(1),null);
var inst_69881 = cljs.core._EQ_.call(null,timeout_chan,inst_69880);
var state_69892__$1 = (function (){var statearr_69894 = state_69892;
(statearr_69894[(7)] = inst_69879);

return statearr_69894;
})();
if(inst_69881){
var statearr_69895_69905 = state_69892__$1;
(statearr_69895_69905[(1)] = (3));

} else {
var statearr_69896_69906 = state_69892__$1;
(statearr_69896_69906[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69893 === (3))){
var inst_69883 = fluree.db.session.monitor_tx_remove.call(null,session,tid,key);
var inst_69884 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_69885 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_69886 = [tid,(408),inst_69885];
var inst_69887 = cljs.core.PersistentHashMap.fromArrays(inst_69884,inst_69886);
var state_69892__$1 = (function (){var statearr_69897 = state_69892;
(statearr_69897[(8)] = inst_69883);

return statearr_69897;
})();
var statearr_69898_69907 = state_69892__$1;
(statearr_69898_69907[(2)] = inst_69887);

(statearr_69898_69907[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69893 === (4))){
var inst_69879 = (state_69892[(7)]);
var state_69892__$1 = state_69892;
var statearr_69899_69908 = state_69892__$1;
(statearr_69899_69908[(2)] = inst_69879);

(statearr_69899_69908[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69893 === (5))){
var inst_69890 = (state_69892[(2)]);
var state_69892__$1 = state_69892;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69892__$1,inst_69890);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0 = (function (){
var statearr_69900 = [null,null,null,null,null,null,null,null,null];
(statearr_69900[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__);

(statearr_69900[(1)] = (1));

return statearr_69900;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1 = (function (state_69892){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69892);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e69901){var ex__2749__auto__ = e69901;
var statearr_69902_69909 = state_69892;
(statearr_69902_69909[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69892[(4)]))){
var statearr_69903_69910 = state_69892;
(statearr_69903_69910[(1)] = cljs.core.first.call(null,(state_69892[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69911 = state_69892;
state_69892 = G__69911;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__ = function(state_69892){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1.call(this,state_69892);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2746__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_69904 = f__2769__auto__.call(null);
(statearr_69904[(6)] = c__2768__auto__);

return statearr_69904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__69913 = arguments.length;
switch (G__69913) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__69914 = opts;
var map__69914__$1 = cljs.core.__destructure_map.call(null,map__69914);
var auth = cljs.core.get.call(null,map__69914__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__69914__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__69914__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.call(null,map__69914__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_.call(null,deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__69915 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__69915,(0),null);
var authority = cljs.core.nth.call(null,vec__69915,(1),null);
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e69918){var e = e69918;

throw cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__69921 = arguments.length;
switch (G__69921) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.call(null,conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_69990){
var state_val_69991 = (state_69990[(1)]);
if((state_val_69991 === (7))){
var inst_69941 = (state_69990[(7)]);
var inst_69943 = (state_69990[(8)]);
var inst_69945 = (state_69990[(9)]);
var inst_69946 = (state_69990[(10)]);
var inst_69944 = (state_69990[(11)]);
var inst_69959 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_69960 = [ledger,txn,inst_69941,inst_69943,inst_69944,inst_69945,inst_69946];
var inst_69961 = cljs.core.PersistentHashMap.fromArrays(inst_69959,inst_69960);
var inst_69962 = fluree.db.util.core.without_nils.call(null,inst_69961);
var inst_69963 = fluree.db.operations.transact_async.call(null,conn,inst_69962);
var state_69990__$1 = state_69990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69990__$1,(13),inst_69963);
} else {
if((state_val_69991 === (20))){
var inst_69981 = (state_69990[(2)]);
var state_69990__$1 = state_69990;
var statearr_69992_70028 = state_69990__$1;
(statearr_69992_70028[(2)] = inst_69981);

(statearr_69992_70028[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (1))){
var state_69990__$1 = state_69990;
var statearr_69993_70029 = state_69990__$1;
(statearr_69993_70029[(2)] = null);

(statearr_69993_70029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (4))){
var inst_69922 = (state_69990[(2)]);
var inst_69923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69924 = [inst_69922];
var inst_69925 = (new cljs.core.PersistentVector(null,1,(5),inst_69923,inst_69924,null));
var inst_69926 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69925);
var inst_69927 = cljs.core.ex_data.call(null,inst_69922);
var inst_69928 = cljs.core.ex_message.call(null,inst_69922);
var inst_69929 = cljs.core.assoc.call(null,inst_69927,new cljs.core.Keyword(null,"message","message",-406056002),inst_69928);
var state_69990__$1 = (function (){var statearr_69994 = state_69990;
(statearr_69994[(12)] = inst_69926);

return statearr_69994;
})();
var statearr_69995_70030 = state_69990__$1;
(statearr_69995_70030[(2)] = inst_69929);

(statearr_69995_70030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (15))){
var inst_69965 = (state_69990[(13)]);
var inst_69940 = (state_69990[(14)]);
var inst_69968 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_69965,inst_69940);
var state_69990__$1 = state_69990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69990__$1,(17),inst_69968);
} else {
if((state_val_69991 === (13))){
var inst_69939 = (state_69990[(15)]);
var inst_69965 = (state_69990[(2)]);
var state_69990__$1 = (function (){var statearr_69996 = state_69990;
(statearr_69996[(13)] = inst_69965);

return statearr_69996;
})();
if(cljs.core.truth_(inst_69939)){
var statearr_69997_70031 = state_69990__$1;
(statearr_69997_70031[(1)] = (14));

} else {
var statearr_69998_70032 = state_69990__$1;
(statearr_69998_70032[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (6))){
var inst_69939 = (state_69990[(15)]);
var inst_69938 = (state_69990[(16)]);
var inst_69948 = fluree.db.api_js.tx__GT_command.call(null,ledger,txn,inst_69938,opts);
var inst_69949 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_69948);
var inst_69950 = fluree.db.operations.command_async.call(null,conn,inst_69948);
var state_69990__$1 = (function (){var statearr_69999 = state_69990;
(statearr_69999[(17)] = inst_69949);

(statearr_69999[(18)] = inst_69950);

return statearr_69999;
})();
if(cljs.core.truth_(inst_69939)){
var statearr_70000_70033 = state_69990__$1;
(statearr_70000_70033[(1)] = (9));

} else {
var statearr_70001_70034 = state_69990__$1;
(statearr_70001_70034[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (17))){
var inst_69970 = (state_69990[(19)]);
var inst_69970__$1 = (state_69990[(2)]);
var inst_69971 = (inst_69970__$1 instanceof cljs.core.ExceptionInfo);
var state_69990__$1 = (function (){var statearr_70002 = state_69990;
(statearr_70002[(19)] = inst_69970__$1);

return statearr_70002;
})();
if(cljs.core.truth_(inst_69971)){
var statearr_70003_70035 = state_69990__$1;
(statearr_70003_70035[(1)] = (18));

} else {
var statearr_70004_70036 = state_69990__$1;
(statearr_70004_70036[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (3))){
var inst_69988 = (state_69990[(2)]);
var state_69990__$1 = state_69990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69990__$1,inst_69988);
} else {
if((state_val_69991 === (12))){
var inst_69955 = (state_69990[(2)]);
var state_69990__$1 = state_69990;
var statearr_70005_70037 = state_69990__$1;
(statearr_70005_70037[(2)] = inst_69955);

(statearr_70005_70037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (2))){
var inst_69938 = (state_69990[(16)]);
var _ = (function (){var statearr_70006 = state_69990;
(statearr_70006[(4)] = cljs.core.cons.call(null,(5),(state_69990[(4)])));

return statearr_70006;
})();
var inst_69936 = opts;
var inst_69937 = cljs.core.__destructure_map.call(null,inst_69936);
var inst_69938__$1 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_69939 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_69940 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_69941 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69942 = fluree.db.util.core.current_time_millis.call(null);
var inst_69943 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_69942);
var inst_69944 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_69945 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_69946 = cljs.core.get.call(null,inst_69937,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_69990__$1 = (function (){var statearr_70007 = state_69990;
(statearr_70007[(7)] = inst_69941);

(statearr_70007[(8)] = inst_69943);

(statearr_70007[(9)] = inst_69945);

(statearr_70007[(15)] = inst_69939);

(statearr_70007[(10)] = inst_69946);

(statearr_70007[(11)] = inst_69944);

(statearr_70007[(16)] = inst_69938__$1);

(statearr_70007[(14)] = inst_69940);

return statearr_70007;
})();
if(cljs.core.truth_(inst_69938__$1)){
var statearr_70008_70038 = state_69990__$1;
(statearr_70008_70038[(1)] = (6));

} else {
var statearr_70009_70039 = state_69990__$1;
(statearr_70009_70039[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (19))){
var inst_69970 = (state_69990[(19)]);
var state_69990__$1 = state_69990;
var statearr_70010_70040 = state_69990__$1;
(statearr_70010_70040[(2)] = inst_69970);

(statearr_70010_70040[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (11))){
var inst_69957 = (state_69990[(2)]);
var state_69990__$1 = state_69990;
var statearr_70012_70041 = state_69990__$1;
(statearr_70012_70041[(2)] = inst_69957);

(statearr_70012_70041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (9))){
var inst_69950 = (state_69990[(18)]);
var state_69990__$1 = state_69990;
var statearr_70013_70042 = state_69990__$1;
(statearr_70013_70042[(2)] = inst_69950);

(statearr_70013_70042[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (5))){
var _ = (function (){var statearr_70014 = state_69990;
(statearr_70014[(4)] = cljs.core.rest.call(null,(state_69990[(4)])));

return statearr_70014;
})();
var state_69990__$1 = state_69990;
var ex70011 = (state_69990__$1[(2)]);
var statearr_70015_70043 = state_69990__$1;
(statearr_70015_70043[(5)] = ex70011);


var statearr_70016_70044 = state_69990__$1;
(statearr_70016_70044[(1)] = (4));

(statearr_70016_70044[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (14))){
var inst_69965 = (state_69990[(13)]);
var state_69990__$1 = state_69990;
var statearr_70017_70045 = state_69990__$1;
(statearr_70017_70045[(2)] = inst_69965);

(statearr_70017_70045[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (16))){
var inst_69983 = (state_69990[(2)]);
var state_69990__$1 = state_69990;
var statearr_70018_70046 = state_69990__$1;
(statearr_70018_70046[(2)] = inst_69983);

(statearr_70018_70046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (10))){
var inst_69949 = (state_69990[(17)]);
var inst_69940 = (state_69990[(14)]);
var inst_69953 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,inst_69949,inst_69940);
var state_69990__$1 = state_69990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69990__$1,(12),inst_69953);
} else {
if((state_val_69991 === (18))){
var inst_69970 = (state_69990[(19)]);
var inst_69973 = cljs.core.ex_data.call(null,inst_69970);
var inst_69974 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69975 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_69973);
var inst_69976 = cljs.core.ex_message.call(null,inst_69970);
var inst_69977 = [inst_69975,inst_69976,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_69978 = cljs.core.PersistentHashMap.fromArrays(inst_69974,inst_69977);
var state_69990__$1 = state_69990;
var statearr_70019_70047 = state_69990__$1;
(statearr_70019_70047[(2)] = inst_69978);

(statearr_70019_70047[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69991 === (8))){
var inst_69985 = (state_69990[(2)]);
var _ = (function (){var statearr_70020 = state_69990;
(statearr_70020[(4)] = cljs.core.rest.call(null,(state_69990[(4)])));

return statearr_70020;
})();
var state_69990__$1 = state_69990;
var statearr_70021_70048 = state_69990__$1;
(statearr_70021_70048[(2)] = inst_69985);

(statearr_70021_70048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_70022 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70022[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_70022[(1)] = (1));

return statearr_70022;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_69990){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_69990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70023){var ex__2749__auto__ = e70023;
var statearr_70024_70049 = state_69990;
(statearr_70024_70049[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_69990[(4)]))){
var statearr_70025_70050 = state_69990;
(statearr_70025_70050[(1)] = cljs.core.first.call(null,(state_69990[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70051 = state_69990;
state_69990 = G__70051;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_69990){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_69990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70026 = f__2769__auto__.call(null);
(statearr_70026[(6)] = c__2768__auto__);

return statearr_70026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70053 = arguments.length;
var i__5770__auto___70054 = (0);
while(true){
if((i__5770__auto___70054 < len__5769__auto___70053)){
args__5775__auto__.push((arguments[i__5770__auto___70054]));

var G__70055 = (i__5770__auto___70054 + (1));
i__5770__auto___70054 = G__70055;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq70052){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq70052));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70086){
var state_val_70087 = (state_70086[(1)]);
if((state_val_70087 === (1))){
var inst_70056 = cljs.core.first.call(null,flakes);
var inst_70057 = cljs.core.rest.call(null,flakes);
var inst_70058 = cljs.core.PersistentVector.EMPTY;
var inst_70059 = inst_70056;
var inst_70060 = inst_70057;
var inst_70061 = inst_70058;
var state_70086__$1 = (function (){var statearr_70088 = state_70086;
(statearr_70088[(7)] = inst_70060);

(statearr_70088[(8)] = inst_70061);

(statearr_70088[(9)] = inst_70059);

return statearr_70088;
})();
var statearr_70089_70102 = state_70086__$1;
(statearr_70089_70102[(2)] = null);

(statearr_70089_70102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70087 === (2))){
var inst_70059 = (state_70086[(9)]);
var inst_70063 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70064 = cljs.core.PersistentHashMap.EMPTY;
var inst_70065 = [true,inst_70064];
var inst_70066 = cljs.core.PersistentHashMap.fromArrays(inst_70063,inst_70065);
var inst_70067 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_70066,inst_70059);
var state_70086__$1 = state_70086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70086__$1,(4),inst_70067);
} else {
if((state_val_70087 === (3))){
var inst_70084 = (state_70086[(2)]);
var state_70086__$1 = state_70086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70086__$1,inst_70084);
} else {
if((state_val_70087 === (4))){
var inst_70060 = (state_70086[(7)]);
var inst_70061 = (state_70086[(8)]);
var inst_70069 = (state_70086[(2)]);
var inst_70070 = fluree.db.util.async.throw_err.call(null,inst_70069);
var inst_70071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70072 = [inst_70070];
var inst_70073 = (new cljs.core.PersistentVector(null,1,(5),inst_70071,inst_70072,null));
var inst_70074 = cljs.core.concat.call(null,inst_70061,inst_70073);
var inst_70075 = cljs.core.first.call(null,inst_70060);
var state_70086__$1 = (function (){var statearr_70090 = state_70086;
(statearr_70090[(10)] = inst_70074);

return statearr_70090;
})();
if(cljs.core.truth_(inst_70075)){
var statearr_70091_70103 = state_70086__$1;
(statearr_70091_70103[(1)] = (5));

} else {
var statearr_70092_70104 = state_70086__$1;
(statearr_70092_70104[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70087 === (5))){
var inst_70074 = (state_70086[(10)]);
var inst_70060 = (state_70086[(7)]);
var inst_70077 = cljs.core.first.call(null,inst_70060);
var inst_70078 = cljs.core.rest.call(null,inst_70060);
var inst_70059 = inst_70077;
var inst_70060__$1 = inst_70078;
var inst_70061 = inst_70074;
var state_70086__$1 = (function (){var statearr_70093 = state_70086;
(statearr_70093[(7)] = inst_70060__$1);

(statearr_70093[(8)] = inst_70061);

(statearr_70093[(9)] = inst_70059);

return statearr_70093;
})();
var statearr_70094_70105 = state_70086__$1;
(statearr_70094_70105[(2)] = null);

(statearr_70094_70105[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70087 === (6))){
var inst_70074 = (state_70086[(10)]);
var state_70086__$1 = state_70086;
var statearr_70095_70106 = state_70086__$1;
(statearr_70095_70106[(2)] = inst_70074);

(statearr_70095_70106[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70087 === (7))){
var inst_70082 = (state_70086[(2)]);
var state_70086__$1 = state_70086;
var statearr_70096_70107 = state_70086__$1;
(statearr_70096_70107[(2)] = inst_70082);

(statearr_70096_70107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_70097 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70097[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__);

(statearr_70097[(1)] = (1));

return statearr_70097;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1 = (function (state_70086){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70098){var ex__2749__auto__ = e70098;
var statearr_70099_70108 = state_70086;
(statearr_70099_70108[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70086[(4)]))){
var statearr_70100_70109 = state_70086;
(statearr_70100_70109[(1)] = cljs.core.first.call(null,(state_70086[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70110 = state_70086;
state_70086 = G__70110;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__ = function(state_70086){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1.call(this,state_70086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70101 = f__2769__auto__.call(null);
(statearr_70101[(6)] = c__2768__auto__);

return statearr_70101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70178){
var state_val_70179 = (state_70178[(1)]);
if((state_val_70179 === (7))){
var inst_70138 = (state_70178[(2)]);
var inst_70139 = fluree.db.util.async.throw_err.call(null,inst_70138);
var state_70178__$1 = state_70178;
var statearr_70180_70206 = state_70178__$1;
(statearr_70180_70206[(2)] = inst_70139);

(statearr_70180_70206[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (1))){
var inst_70115 = cljs.core.volatile_BANG_.call(null,(0));
var inst_70116 = cljs.core.PersistentHashMap.EMPTY;
var inst_70117 = cljs.core.volatile_BANG_.call(null,inst_70116);
var inst_70118 = cljs.core.first.call(null,resp);
var inst_70119 = cljs.core.rest.call(null,resp);
var inst_70120 = cljs.core.PersistentVector.EMPTY;
var inst_70121 = inst_70115;
var inst_70122 = inst_70117;
var inst_70123 = inst_70118;
var inst_70124 = inst_70119;
var inst_70125 = inst_70120;
var state_70178__$1 = (function (){var statearr_70181 = state_70178;
(statearr_70181[(7)] = inst_70121);

(statearr_70181[(8)] = inst_70123);

(statearr_70181[(9)] = inst_70125);

(statearr_70181[(10)] = inst_70124);

(statearr_70181[(11)] = inst_70122);

return statearr_70181;
})();
var statearr_70182_70207 = state_70178__$1;
(statearr_70182_70207[(2)] = null);

(statearr_70182_70207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (4))){
var inst_70121 = (state_70178[(7)]);
var inst_70123 = (state_70178[(8)]);
var inst_70125 = (state_70178[(9)]);
var inst_70127 = (state_70178[(12)]);
var inst_70124 = (state_70178[(10)]);
var inst_70129 = (state_70178[(13)]);
var inst_70122 = (state_70178[(11)]);
var inst_70133 = (function (){var fuel = inst_70121;
var cache = inst_70122;
var curr_block = inst_70123;
var rest_blocks = inst_70124;
var acc = inst_70125;
var flakes = inst_70127;
var asserted = inst_70129;
return (function (p1__70112_SHARP_){
return p1__70112_SHARP_.s;
});
})();
var inst_70134 = cljs.core.group_by.call(null,inst_70133,inst_70129);
var inst_70135 = cljs.core.vals.call(null,inst_70134);
var inst_70136 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_70122,inst_70121,inst_70135);
var state_70178__$1 = state_70178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70178__$1,(7),inst_70136);
} else {
if((state_val_70179 === (13))){
var inst_70166 = (state_70178[(14)]);
var state_70178__$1 = state_70178;
var statearr_70183_70208 = state_70178__$1;
(statearr_70183_70208[(2)] = inst_70166);

(statearr_70183_70208[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (6))){
var inst_70121 = (state_70178[(7)]);
var inst_70123 = (state_70178[(8)]);
var inst_70125 = (state_70178[(9)]);
var inst_70127 = (state_70178[(12)]);
var inst_70124 = (state_70178[(10)]);
var inst_70129 = (state_70178[(13)]);
var inst_70122 = (state_70178[(11)]);
var inst_70144 = (state_70178[(15)]);
var inst_70142 = (state_70178[(16)]);
var inst_70142__$1 = (state_70178[(2)]);
var inst_70143 = (function (){var fuel = inst_70121;
var cache = inst_70122;
var curr_block = inst_70123;
var rest_blocks = inst_70124;
var acc = inst_70125;
var flakes = inst_70127;
var asserted = inst_70129;
var asserted_SINGLEQUOTE_ = inst_70142__$1;
return (function (p1__70113_SHARP_){
return p1__70113_SHARP_.op === false;
});
})();
var inst_70144__$1 = cljs.core.filter.call(null,inst_70143,inst_70127);
var inst_70145 = cljs.core.empty_QMARK_.call(null,inst_70144__$1);
var inst_70146 = (!(inst_70145));
var state_70178__$1 = (function (){var statearr_70186 = state_70178;
(statearr_70186[(15)] = inst_70144__$1);

(statearr_70186[(16)] = inst_70142__$1);

return statearr_70186;
})();
if(inst_70146){
var statearr_70187_70209 = state_70178__$1;
(statearr_70187_70209[(1)] = (8));

} else {
var statearr_70188_70210 = state_70178__$1;
(statearr_70188_70210[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (3))){
var inst_70176 = (state_70178[(2)]);
var state_70178__$1 = state_70178;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70178__$1,inst_70176);
} else {
if((state_val_70179 === (12))){
var inst_70121 = (state_70178[(7)]);
var inst_70166 = (state_70178[(14)]);
var inst_70124 = (state_70178[(10)]);
var inst_70122 = (state_70178[(11)]);
var inst_70169 = cljs.core.first.call(null,inst_70124);
var inst_70170 = cljs.core.rest.call(null,inst_70124);
var tmp70184 = inst_70121;
var tmp70185 = inst_70122;
var inst_70121__$1 = tmp70184;
var inst_70122__$1 = tmp70185;
var inst_70123 = inst_70169;
var inst_70124__$1 = inst_70170;
var inst_70125 = inst_70166;
var state_70178__$1 = (function (){var statearr_70189 = state_70178;
(statearr_70189[(7)] = inst_70121__$1);

(statearr_70189[(8)] = inst_70123);

(statearr_70189[(9)] = inst_70125);

(statearr_70189[(10)] = inst_70124__$1);

(statearr_70189[(11)] = inst_70122__$1);

return statearr_70189;
})();
var statearr_70190_70211 = state_70178__$1;
(statearr_70190_70211[(2)] = null);

(statearr_70190_70211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (2))){
var inst_70121 = (state_70178[(7)]);
var inst_70123 = (state_70178[(8)]);
var inst_70125 = (state_70178[(9)]);
var inst_70127 = (state_70178[(12)]);
var inst_70124 = (state_70178[(10)]);
var inst_70129 = (state_70178[(13)]);
var inst_70122 = (state_70178[(11)]);
var inst_70127__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_70123);
var inst_70128 = (function (){var fuel = inst_70121;
var cache = inst_70122;
var curr_block = inst_70123;
var rest_blocks = inst_70124;
var acc = inst_70125;
var flakes = inst_70127__$1;
return (function (p1__70111_SHARP_){
return p1__70111_SHARP_.op;
});
})();
var inst_70129__$1 = cljs.core.filter.call(null,inst_70128,inst_70127__$1);
var inst_70130 = cljs.core.empty_QMARK_.call(null,inst_70129__$1);
var inst_70131 = (!(inst_70130));
var state_70178__$1 = (function (){var statearr_70191 = state_70178;
(statearr_70191[(12)] = inst_70127__$1);

(statearr_70191[(13)] = inst_70129__$1);

return statearr_70191;
})();
if(inst_70131){
var statearr_70192_70212 = state_70178__$1;
(statearr_70192_70212[(1)] = (4));

} else {
var statearr_70193_70213 = state_70178__$1;
(statearr_70193_70213[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (11))){
var inst_70154 = (state_70178[(2)]);
var inst_70155 = fluree.db.util.async.throw_err.call(null,inst_70154);
var state_70178__$1 = state_70178;
var statearr_70194_70214 = state_70178__$1;
(statearr_70194_70214[(2)] = inst_70155);

(statearr_70194_70214[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (9))){
var state_70178__$1 = state_70178;
var statearr_70195_70215 = state_70178__$1;
(statearr_70195_70215[(2)] = null);

(statearr_70195_70215[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (5))){
var state_70178__$1 = state_70178;
var statearr_70196_70216 = state_70178__$1;
(statearr_70196_70216[(2)] = null);

(statearr_70196_70216[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (14))){
var inst_70174 = (state_70178[(2)]);
var state_70178__$1 = state_70178;
var statearr_70197_70217 = state_70178__$1;
(statearr_70197_70217[(2)] = inst_70174);

(statearr_70197_70217[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (10))){
var inst_70123 = (state_70178[(8)]);
var inst_70125 = (state_70178[(9)]);
var inst_70124 = (state_70178[(10)]);
var inst_70142 = (state_70178[(16)]);
var inst_70158 = (state_70178[(2)]);
var inst_70159 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_70160 = [inst_70142,inst_70158];
var inst_70161 = cljs.core.PersistentHashMap.fromArrays(inst_70159,inst_70160);
var inst_70162 = cljs.core.assoc.call(null,inst_70123,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_70161);
var inst_70163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70164 = [inst_70162];
var inst_70165 = (new cljs.core.PersistentVector(null,1,(5),inst_70163,inst_70164,null));
var inst_70166 = cljs.core.concat.call(null,inst_70125,inst_70165);
var inst_70167 = cljs.core.first.call(null,inst_70124);
var state_70178__$1 = (function (){var statearr_70198 = state_70178;
(statearr_70198[(14)] = inst_70166);

return statearr_70198;
})();
if(cljs.core.truth_(inst_70167)){
var statearr_70199_70218 = state_70178__$1;
(statearr_70199_70218[(1)] = (12));

} else {
var statearr_70200_70219 = state_70178__$1;
(statearr_70200_70219[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70179 === (8))){
var inst_70121 = (state_70178[(7)]);
var inst_70123 = (state_70178[(8)]);
var inst_70125 = (state_70178[(9)]);
var inst_70127 = (state_70178[(12)]);
var inst_70124 = (state_70178[(10)]);
var inst_70129 = (state_70178[(13)]);
var inst_70122 = (state_70178[(11)]);
var inst_70144 = (state_70178[(15)]);
var inst_70142 = (state_70178[(16)]);
var inst_70148 = (function (){var flakes = inst_70127;
var rest_blocks = inst_70124;
var curr_block = inst_70123;
var asserted_SINGLEQUOTE_ = inst_70142;
var acc = inst_70125;
var fuel = inst_70121;
var cache = inst_70122;
var retracted = inst_70144;
var asserted = inst_70129;
return (function (p1__70114_SHARP_){
return p1__70114_SHARP_.s;
});
})();
var inst_70149 = cljs.core.map.call(null,fluree.db.flake.flip_flake,inst_70144);
var inst_70150 = cljs.core.group_by.call(null,inst_70148,inst_70149);
var inst_70151 = cljs.core.vals.call(null,inst_70150);
var inst_70152 = fluree.db.api_js.format_flake_groups_pretty.call(null,db,inst_70122,inst_70121,inst_70151);
var state_70178__$1 = state_70178;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70178__$1,(11),inst_70152);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_70201 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70201[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_70201[(1)] = (1));

return statearr_70201;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_70178){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70178);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70202){var ex__2749__auto__ = e70202;
var statearr_70203_70220 = state_70178;
(statearr_70203_70220[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70178[(4)]))){
var statearr_70204_70221 = state_70178;
(statearr_70204_70221[(1)] = cljs.core.first.call(null,(state_70178[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70222 = state_70178;
state_70178 = G__70222;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_70178){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_70178);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70205 = f__2769__auto__.call(null);
(statearr_70205[(6)] = c__2768__auto__);

return statearr_70205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70322){
var state_val_70323 = (state_70322[(1)]);
if((state_val_70323 === (7))){
var inst_70294 = (state_70322[(7)]);
var inst_70287 = (state_70322[(8)]);
var inst_70293 = cljs.core.seq.call(null,inst_70287);
var inst_70294__$1 = cljs.core.first.call(null,inst_70293);
var inst_70295 = cljs.core.next.call(null,inst_70293);
var state_70322__$1 = (function (){var statearr_70324 = state_70322;
(statearr_70324[(7)] = inst_70294__$1);

(statearr_70324[(9)] = inst_70295);

return statearr_70324;
})();
if(cljs.core.truth_(inst_70294__$1)){
var statearr_70325_70362 = state_70322__$1;
(statearr_70325_70362[(1)] = (9));

} else {
var statearr_70326_70363 = state_70322__$1;
(statearr_70326_70363[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (1))){
var state_70322__$1 = state_70322;
var statearr_70327_70364 = state_70322__$1;
(statearr_70327_70364[(2)] = null);

(statearr_70327_70364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (4))){
var inst_70224 = (state_70322[(2)]);
var state_70322__$1 = state_70322;
var statearr_70328_70365 = state_70322__$1;
(statearr_70328_70365[(2)] = inst_70224);

(statearr_70328_70365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (6))){
var inst_70273 = (state_70322[(2)]);
var inst_70274 = fluree.db.util.async.throw_err.call(null,inst_70273);
var inst_70282 = resp;
var inst_70283 = cljs.core.seq.call(null,inst_70282);
var inst_70284 = cljs.core.first.call(null,inst_70283);
var inst_70285 = cljs.core.next.call(null,inst_70283);
var inst_70286 = cljs.core.PersistentHashMap.EMPTY;
var inst_70287 = inst_70282;
var inst_70288 = inst_70286;
var state_70322__$1 = (function (){var statearr_70329 = state_70322;
(statearr_70329[(10)] = inst_70288);

(statearr_70329[(11)] = inst_70274);

(statearr_70329[(12)] = inst_70285);

(statearr_70329[(8)] = inst_70287);

(statearr_70329[(13)] = inst_70284);

return statearr_70329;
})();
var statearr_70330_70366 = state_70322__$1;
(statearr_70330_70366[(2)] = null);

(statearr_70330_70366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (3))){
var inst_70320 = (state_70322[(2)]);
var state_70322__$1 = state_70322;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70322__$1,inst_70320);
} else {
if((state_val_70323 === (2))){
var _ = (function (){var statearr_70331 = state_70322;
(statearr_70331[(4)] = cljs.core.cons.call(null,(5),(state_70322[(4)])));

return statearr_70331;
})();
var inst_70230 = (function (){return (function (p1__70223_SHARP_){
return p1__70223_SHARP_.t;
});
})();
var inst_70231 = cljs.core.map.call(null,inst_70230,resp);
var inst_70232 = cljs.core.set.call(null,inst_70231);
var inst_70269 = cljs.core.async.chan.call(null,(1));
var inst_70270 = (function (){var ts = inst_70232;
var c__2768__auto____$1 = inst_70269;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70267){
var state_val_70268 = (state_70267[(1)]);
if((state_val_70268 === (1))){
var inst_70240 = ts;
var inst_70241 = cljs.core.seq.call(null,inst_70240);
var inst_70242 = cljs.core.first.call(null,inst_70241);
var inst_70243 = cljs.core.next.call(null,inst_70241);
var inst_70244 = cljs.core.PersistentHashMap.EMPTY;
var inst_70245 = inst_70240;
var inst_70246 = inst_70244;
var state_70267__$1 = (function (){var statearr_70332 = state_70267;
(statearr_70332[(7)] = inst_70245);

(statearr_70332[(8)] = inst_70246);

(statearr_70332[(9)] = inst_70242);

(statearr_70332[(10)] = inst_70243);

return statearr_70332;
})();
var statearr_70333_70367 = state_70267__$1;
(statearr_70333_70367[(2)] = null);

(statearr_70333_70367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70268 === (2))){
var inst_70245 = (state_70267[(7)]);
var inst_70252 = (state_70267[(11)]);
var inst_70251 = cljs.core.seq.call(null,inst_70245);
var inst_70252__$1 = cljs.core.first.call(null,inst_70251);
var inst_70253 = cljs.core.next.call(null,inst_70251);
var state_70267__$1 = (function (){var statearr_70334 = state_70267;
(statearr_70334[(11)] = inst_70252__$1);

(statearr_70334[(12)] = inst_70253);

return statearr_70334;
})();
if(cljs.core.truth_(inst_70252__$1)){
var statearr_70335_70368 = state_70267__$1;
(statearr_70335_70368[(1)] = (4));

} else {
var statearr_70336_70369 = state_70267__$1;
(statearr_70336_70369[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70268 === (3))){
var inst_70265 = (state_70267[(2)]);
var state_70267__$1 = state_70267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70267__$1,inst_70265);
} else {
if((state_val_70268 === (4))){
var inst_70252 = (state_70267[(11)]);
var inst_70255 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_70252);
var state_70267__$1 = state_70267;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70267__$1,(7),inst_70255);
} else {
if((state_val_70268 === (5))){
var inst_70246 = (state_70267[(8)]);
var state_70267__$1 = state_70267;
var statearr_70337_70370 = state_70267__$1;
(statearr_70337_70370[(2)] = inst_70246);

(statearr_70337_70370[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70268 === (6))){
var inst_70263 = (state_70267[(2)]);
var state_70267__$1 = state_70267;
var statearr_70338_70371 = state_70267__$1;
(statearr_70338_70371[(2)] = inst_70263);

(statearr_70338_70371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70268 === (7))){
var inst_70246 = (state_70267[(8)]);
var inst_70252 = (state_70267[(11)]);
var inst_70253 = (state_70267[(12)]);
var inst_70257 = (state_70267[(2)]);
var inst_70258 = fluree.db.util.async.throw_err.call(null,inst_70257);
var inst_70259 = cljs.core.assoc.call(null,inst_70246,inst_70252,inst_70258);
var inst_70245 = inst_70253;
var inst_70246__$1 = inst_70259;
var state_70267__$1 = (function (){var statearr_70339 = state_70267;
(statearr_70339[(7)] = inst_70245);

(statearr_70339[(8)] = inst_70246__$1);

return statearr_70339;
})();
var statearr_70340_70372 = state_70267__$1;
(statearr_70340_70372[(2)] = null);

(statearr_70340_70372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_70341 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70341[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_70341[(1)] = (1));

return statearr_70341;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_70267){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70342){var ex__2749__auto__ = e70342;
var statearr_70343_70373 = state_70267;
(statearr_70343_70373[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70267[(4)]))){
var statearr_70344_70374 = state_70267;
(statearr_70344_70374[(1)] = cljs.core.first.call(null,(state_70267[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70375 = state_70267;
state_70267 = G__70375;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_70267){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_70267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70345 = f__2769__auto__.call(null);
(statearr_70345[(6)] = c__2768__auto____$1);

return statearr_70345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_70271 = cljs.core.async.impl.dispatch.run.call(null,inst_70270);
var state_70322__$1 = (function (){var statearr_70346 = state_70322;
(statearr_70346[(14)] = inst_70271);

return statearr_70346;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70322__$1,(6),inst_70269);
} else {
if((state_val_70323 === (11))){
var inst_70314 = (state_70322[(2)]);
var state_70322__$1 = state_70322;
var statearr_70348_70376 = state_70322__$1;
(statearr_70348_70376[(2)] = inst_70314);

(statearr_70348_70376[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (9))){
var inst_70294 = (state_70322[(7)]);
var inst_70295 = (state_70322[(9)]);
var inst_70288 = (state_70322[(10)]);
var inst_70274 = (state_70322[(11)]);
var inst_70297 = inst_70294.t;
var inst_70298 = cljs.core.get.call(null,inst_70274,inst_70297);
var inst_70299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70300 = [inst_70298,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70301 = (new cljs.core.PersistentVector(null,2,(5),inst_70299,inst_70300,null));
var inst_70302 = cljs.core.assoc_in.call(null,inst_70288,inst_70301,inst_70298);
var inst_70303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70304 = [inst_70298,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70305 = (new cljs.core.PersistentVector(null,2,(5),inst_70303,inst_70304,null));
var inst_70306 = cljs.core.update_in.call(null,inst_70302,inst_70305,cljs.core.conj,inst_70294);
var inst_70307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70308 = [inst_70298,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70309 = (new cljs.core.PersistentVector(null,2,(5),inst_70307,inst_70308,null));
var inst_70310 = cljs.core.update_in.call(null,inst_70306,inst_70309,fluree.db.api_js.min_safe,inst_70297);
var inst_70287 = inst_70295;
var inst_70288__$1 = inst_70310;
var state_70322__$1 = (function (){var statearr_70349 = state_70322;
(statearr_70349[(10)] = inst_70288__$1);

(statearr_70349[(8)] = inst_70287);

return statearr_70349;
})();
var statearr_70350_70377 = state_70322__$1;
(statearr_70350_70377[(2)] = null);

(statearr_70350_70377[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (5))){
var _ = (function (){var statearr_70351 = state_70322;
(statearr_70351[(4)] = cljs.core.rest.call(null,(state_70322[(4)])));

return statearr_70351;
})();
var state_70322__$1 = state_70322;
var ex70347 = (state_70322__$1[(2)]);
var statearr_70352_70378 = state_70322__$1;
(statearr_70352_70378[(5)] = ex70347);


if((ex70347 instanceof Error)){
var statearr_70353_70379 = state_70322__$1;
(statearr_70353_70379[(1)] = (4));

(statearr_70353_70379[(5)] = null);

} else {
throw ex70347;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (10))){
var inst_70288 = (state_70322[(10)]);
var state_70322__$1 = state_70322;
var statearr_70354_70380 = state_70322__$1;
(statearr_70354_70380[(2)] = inst_70288);

(statearr_70354_70380[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70323 === (8))){
var inst_70316 = (state_70322[(2)]);
var inst_70317 = cljs.core.vals.call(null,inst_70316);
var _ = (function (){var statearr_70355 = state_70322;
(statearr_70355[(4)] = cljs.core.rest.call(null,(state_70322[(4)])));

return statearr_70355;
})();
var state_70322__$1 = state_70322;
var statearr_70356_70381 = state_70322__$1;
(statearr_70356_70381[(2)] = inst_70317);

(statearr_70356_70381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_70357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70357[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__);

(statearr_70357[(1)] = (1));

return statearr_70357;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1 = (function (state_70322){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70322);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70358){var ex__2749__auto__ = e70358;
var statearr_70359_70382 = state_70322;
(statearr_70359_70382[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70322[(4)]))){
var statearr_70360_70383 = state_70322;
(statearr_70360_70383[(1)] = cljs.core.first.call(null,(state_70322[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70384 = state_70322;
state_70322 = G__70384;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__ = function(state_70322){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1.call(this,state_70322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70361 = f__2769__auto__.call(null);
(statearr_70361[(6)] = c__2768__auto__);

return statearr_70361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70532){
var state_val_70533 = (state_70532[(1)]);
if((state_val_70533 === (7))){
var inst_70412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70413 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70414 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70415 = [inst_70413,inst_70414];
var inst_70416 = (new cljs.core.PersistentVector(null,2,(5),inst_70412,inst_70415,null));
var state_70532__$1 = state_70532;
var statearr_70534_70605 = state_70532__$1;
(statearr_70534_70605[(2)] = inst_70416);

(statearr_70534_70605[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (20))){
var inst_70442 = (state_70532[(7)]);
var state_70532__$1 = state_70532;
var statearr_70535_70606 = state_70532__$1;
(statearr_70535_70606[(2)] = inst_70442);

(statearr_70535_70606[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (27))){
var state_70532__$1 = state_70532;
var statearr_70536_70607 = state_70532__$1;
(statearr_70536_70607[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (1))){
var state_70532__$1 = state_70532;
var statearr_70538_70608 = state_70532__$1;
(statearr_70538_70608[(2)] = null);

(statearr_70538_70608[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (24))){
var inst_70441 = (state_70532[(8)]);
var state_70532__$1 = state_70532;
if(cljs.core.truth_(inst_70441)){
var statearr_70539_70609 = state_70532__$1;
(statearr_70539_70609[(1)] = (26));

} else {
var statearr_70540_70610 = state_70532__$1;
(statearr_70540_70610[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (39))){
var inst_70488 = (state_70532[(9)]);
var inst_70487 = (state_70532[(10)]);
var inst_70513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70514 = [inst_70487,inst_70488];
var inst_70515 = (new cljs.core.PersistentVector(null,2,(5),inst_70513,inst_70514,null));
var state_70532__$1 = state_70532;
var statearr_70541_70611 = state_70532__$1;
(statearr_70541_70611[(2)] = inst_70515);

(statearr_70541_70611[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (4))){
var inst_70385 = (state_70532[(2)]);
var inst_70386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70387 = [inst_70385];
var inst_70388 = (new cljs.core.PersistentVector(null,1,(5),inst_70386,inst_70387,null));
var inst_70389 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70388);
var inst_70390 = cljs.core.ex_data.call(null,inst_70385);
var inst_70391 = cljs.core.ex_message.call(null,inst_70385);
var inst_70392 = cljs.core.assoc.call(null,inst_70390,new cljs.core.Keyword(null,"message","message",-406056002),inst_70391);
var state_70532__$1 = (function (){var statearr_70542 = state_70532;
(statearr_70542[(11)] = inst_70389);

return statearr_70542;
})();
var statearr_70543_70612 = state_70532__$1;
(statearr_70543_70612[(2)] = inst_70392);

(statearr_70543_70612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (15))){
var inst_70421 = (state_70532[(12)]);
var inst_70426 = (state_70532[(13)]);
var inst_70435 = (state_70532[(2)]);
var inst_70436 = [inst_70426,inst_70435];
var inst_70437 = (new cljs.core.PersistentVector(null,2,(5),inst_70421,inst_70436,null));
var state_70532__$1 = state_70532;
var statearr_70544_70613 = state_70532__$1;
(statearr_70544_70613[(2)] = inst_70437);

(statearr_70544_70613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (21))){
var inst_70441 = (state_70532[(8)]);
var state_70532__$1 = state_70532;
var statearr_70545_70614 = state_70532__$1;
(statearr_70545_70614[(2)] = inst_70441);

(statearr_70545_70614[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (31))){
var inst_70482 = (state_70532[(2)]);
var state_70532__$1 = state_70532;
var statearr_70546_70615 = state_70532__$1;
(statearr_70546_70615[(2)] = inst_70482);

(statearr_70546_70615[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (32))){
var inst_70488 = (state_70532[(9)]);
var inst_70491 = cljs.core.pos_int_QMARK_.call(null,inst_70488);
var state_70532__$1 = state_70532;
var statearr_70547_70616 = state_70532__$1;
(statearr_70547_70616[(2)] = inst_70491);

(statearr_70547_70616[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (40))){
var inst_70443 = (state_70532[(14)]);
var inst_70519 = (state_70532[(15)]);
var inst_70517 = (state_70532[(2)]);
var inst_70518 = cljs.core.nth.call(null,inst_70517,(0),null);
var inst_70519__$1 = cljs.core.nth.call(null,inst_70517,(1),null);
var inst_70520 = (inst_70519__$1 > inst_70443);
var state_70532__$1 = (function (){var statearr_70548 = state_70532;
(statearr_70548[(16)] = inst_70518);

(statearr_70548[(15)] = inst_70519__$1);

return statearr_70548;
})();
if(cljs.core.truth_(inst_70520)){
var statearr_70549_70617 = state_70532__$1;
(statearr_70549_70617[(1)] = (41));

} else {
var statearr_70550_70618 = state_70532__$1;
(statearr_70550_70618[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (33))){
var inst_70489 = (state_70532[(17)]);
var state_70532__$1 = state_70532;
var statearr_70551_70619 = state_70532__$1;
(statearr_70551_70619[(2)] = inst_70489);

(statearr_70551_70619[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (13))){
var inst_70427 = (state_70532[(18)]);
var inst_70429 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70427);
var state_70532__$1 = state_70532;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70532__$1,(16),inst_70429);
} else {
if((state_val_70533 === (22))){
var inst_70460 = (state_70532[(2)]);
var state_70532__$1 = state_70532;
if(cljs.core.truth_(inst_70460)){
var statearr_70552_70620 = state_70532__$1;
(statearr_70552_70620[(1)] = (23));

} else {
var statearr_70553_70621 = state_70532__$1;
(statearr_70553_70621[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (36))){
var state_70532__$1 = state_70532;
var statearr_70554_70622 = state_70532__$1;
(statearr_70554_70622[(2)] = null);

(statearr_70554_70622[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (41))){
var inst_70443 = (state_70532[(14)]);
var state_70532__$1 = state_70532;
var statearr_70555_70623 = state_70532__$1;
(statearr_70555_70623[(2)] = inst_70443);

(statearr_70555_70623[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (43))){
var inst_70518 = (state_70532[(16)]);
var inst_70524 = (state_70532[(2)]);
var inst_70525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70526 = [inst_70518,inst_70524];
var inst_70527 = (new cljs.core.PersistentVector(null,2,(5),inst_70525,inst_70526,null));
var _ = (function (){var statearr_70556 = state_70532;
(statearr_70556[(4)] = cljs.core.rest.call(null,(state_70532[(4)])));

return statearr_70556;
})();
var state_70532__$1 = state_70532;
var statearr_70557_70624 = state_70532__$1;
(statearr_70557_70624[(2)] = inst_70527);

(statearr_70557_70624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (29))){
var inst_70418 = (state_70532[(19)]);
var inst_70473 = cljs.core.pr_str.call(null,inst_70418);
var inst_70474 = ["Invalid block range provided: ",inst_70473].join('');
var inst_70475 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70476 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70477 = cljs.core.PersistentHashMap.fromArrays(inst_70475,inst_70476);
var inst_70478 = cljs.core.ex_info.call(null,inst_70474,inst_70477);
var inst_70479 = (function(){throw inst_70478})();
var state_70532__$1 = state_70532;
var statearr_70558_70625 = state_70532__$1;
(statearr_70558_70625[(2)] = inst_70479);

(statearr_70558_70625[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (6))){
var inst_70410 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70532__$1 = state_70532;
var statearr_70559_70626 = state_70532__$1;
(statearr_70559_70626[(2)] = inst_70410);

(statearr_70559_70626[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (28))){
var inst_70484 = (state_70532[(2)]);
var state_70532__$1 = state_70532;
var statearr_70560_70627 = state_70532__$1;
(statearr_70560_70627[(2)] = inst_70484);

(statearr_70560_70627[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (25))){
var inst_70487 = (state_70532[(10)]);
var inst_70489 = (state_70532[(17)]);
var inst_70486 = (state_70532[(2)]);
var inst_70487__$1 = cljs.core.nth.call(null,inst_70486,(0),null);
var inst_70488 = cljs.core.nth.call(null,inst_70486,(1),null);
var inst_70489__$1 = cljs.core.pos_int_QMARK_.call(null,inst_70487__$1);
var state_70532__$1 = (function (){var statearr_70561 = state_70532;
(statearr_70561[(9)] = inst_70488);

(statearr_70561[(10)] = inst_70487__$1);

(statearr_70561[(17)] = inst_70489__$1);

return statearr_70561;
})();
if(inst_70489__$1){
var statearr_70562_70628 = state_70532__$1;
(statearr_70562_70628[(1)] = (32));

} else {
var statearr_70563_70629 = state_70532__$1;
(statearr_70563_70629[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (34))){
var inst_70494 = (state_70532[(2)]);
var inst_70495 = cljs.core.not.call(null,inst_70494);
var state_70532__$1 = state_70532;
if(inst_70495){
var statearr_70564_70630 = state_70532__$1;
(statearr_70564_70630[(1)] = (35));

} else {
var statearr_70565_70631 = state_70532__$1;
(statearr_70565_70631[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (17))){
var inst_70441 = (state_70532[(8)]);
var inst_70443 = (state_70532[(14)]);
var inst_70446 = cljs.core.pr_str.call(null,inst_70441);
var inst_70447 = cljs.core.pr_str.call(null,inst_70443);
var inst_70448 = ["Start block is out of range for this ledger. Start block provided: ",inst_70446,". Database block: ",inst_70447].join('');
var inst_70449 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70450 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70451 = cljs.core.PersistentHashMap.fromArrays(inst_70449,inst_70450);
var inst_70452 = cljs.core.ex_info.call(null,inst_70448,inst_70451);
var inst_70453 = (function(){throw inst_70452})();
var state_70532__$1 = state_70532;
var statearr_70566_70632 = state_70532__$1;
(statearr_70566_70632[(2)] = inst_70453);

(statearr_70566_70632[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (3))){
var inst_70530 = (state_70532[(2)]);
var state_70532__$1 = state_70532;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70532__$1,inst_70530);
} else {
if((state_val_70533 === (12))){
var inst_70427 = (state_70532[(18)]);
var inst_70418 = (state_70532[(19)]);
var inst_70425 = (state_70532[(2)]);
var inst_70426 = fluree.db.util.async.throw_err.call(null,inst_70425);
var inst_70427__$1 = cljs.core.second.call(null,inst_70418);
var state_70532__$1 = (function (){var statearr_70567 = state_70532;
(statearr_70567[(18)] = inst_70427__$1);

(statearr_70567[(13)] = inst_70426);

return statearr_70567;
})();
if(cljs.core.truth_(inst_70427__$1)){
var statearr_70568_70633 = state_70532__$1;
(statearr_70568_70633[(1)] = (13));

} else {
var statearr_70569_70634 = state_70532__$1;
(statearr_70569_70634[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (2))){
var _ = (function (){var statearr_70570 = state_70532;
(statearr_70570[(4)] = cljs.core.cons.call(null,(5),(state_70532[(4)])));

return statearr_70570;
})();
var inst_70407 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70408 = cljs.core.sequential_QMARK_.call(null,inst_70407);
var state_70532__$1 = state_70532;
if(inst_70408){
var statearr_70571_70635 = state_70532__$1;
(statearr_70571_70635[(1)] = (6));

} else {
var statearr_70572_70636 = state_70532__$1;
(statearr_70572_70636[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (23))){
var inst_70441 = (state_70532[(8)]);
var inst_70442 = (state_70532[(7)]);
var inst_70462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70463 = [inst_70441,inst_70442];
var inst_70464 = (new cljs.core.PersistentVector(null,2,(5),inst_70462,inst_70463,null));
var state_70532__$1 = state_70532;
var statearr_70573_70637 = state_70532__$1;
(statearr_70573_70637[(2)] = inst_70464);

(statearr_70573_70637[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (35))){
var inst_70418 = (state_70532[(19)]);
var inst_70497 = cljs.core.pr_str.call(null,inst_70418);
var inst_70498 = ["Invalid block range provided: ",inst_70497].join('');
var inst_70499 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70500 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70501 = cljs.core.PersistentHashMap.fromArrays(inst_70499,inst_70500);
var inst_70502 = cljs.core.ex_info.call(null,inst_70498,inst_70501);
var inst_70503 = (function(){throw inst_70502})();
var state_70532__$1 = state_70532;
var statearr_70574_70638 = state_70532__$1;
(statearr_70574_70638[(2)] = inst_70503);

(statearr_70574_70638[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (19))){
var inst_70441 = (state_70532[(8)]);
var inst_70456 = (state_70532[(2)]);
var state_70532__$1 = (function (){var statearr_70575 = state_70532;
(statearr_70575[(20)] = inst_70456);

return statearr_70575;
})();
if(cljs.core.truth_(inst_70441)){
var statearr_70576_70639 = state_70532__$1;
(statearr_70576_70639[(1)] = (20));

} else {
var statearr_70577_70640 = state_70532__$1;
(statearr_70577_70640[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (11))){
var inst_70441 = (state_70532[(8)]);
var inst_70443 = (state_70532[(14)]);
var inst_70440 = (state_70532[(2)]);
var inst_70441__$1 = cljs.core.nth.call(null,inst_70440,(0),null);
var inst_70442 = cljs.core.nth.call(null,inst_70440,(1),null);
var inst_70443__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70444 = (inst_70441__$1 > inst_70443__$1);
var state_70532__$1 = (function (){var statearr_70579 = state_70532;
(statearr_70579[(8)] = inst_70441__$1);

(statearr_70579[(7)] = inst_70442);

(statearr_70579[(14)] = inst_70443__$1);

return statearr_70579;
})();
if(cljs.core.truth_(inst_70444)){
var statearr_70580_70641 = state_70532__$1;
(statearr_70580_70641[(1)] = (17));

} else {
var statearr_70581_70642 = state_70532__$1;
(statearr_70581_70642[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (9))){
var inst_70418 = (state_70532[(19)]);
var inst_70421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70422 = cljs.core.first.call(null,inst_70418);
var inst_70423 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_70422);
var state_70532__$1 = (function (){var statearr_70582 = state_70532;
(statearr_70582[(12)] = inst_70421);

return statearr_70582;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70532__$1,(12),inst_70423);
} else {
if((state_val_70533 === (5))){
var _ = (function (){var statearr_70583 = state_70532;
(statearr_70583[(4)] = cljs.core.rest.call(null,(state_70532[(4)])));

return statearr_70583;
})();
var state_70532__$1 = state_70532;
var ex70578 = (state_70532__$1[(2)]);
var statearr_70584_70643 = state_70532__$1;
(statearr_70584_70643[(5)] = ex70578);


var statearr_70585_70644 = state_70532__$1;
(statearr_70585_70644[(1)] = (4));

(statearr_70585_70644[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (14))){
var state_70532__$1 = state_70532;
var statearr_70586_70645 = state_70532__$1;
(statearr_70586_70645[(2)] = null);

(statearr_70586_70645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (26))){
var inst_70441 = (state_70532[(8)]);
var inst_70467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70468 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70469 = [inst_70441,inst_70468];
var inst_70470 = (new cljs.core.PersistentVector(null,2,(5),inst_70467,inst_70469,null));
var state_70532__$1 = state_70532;
var statearr_70587_70646 = state_70532__$1;
(statearr_70587_70646[(2)] = inst_70470);

(statearr_70587_70646[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (16))){
var inst_70431 = (state_70532[(2)]);
var inst_70432 = fluree.db.util.async.throw_err.call(null,inst_70431);
var state_70532__$1 = state_70532;
var statearr_70588_70647 = state_70532__$1;
(statearr_70588_70647[(2)] = inst_70432);

(statearr_70588_70647[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (38))){
var inst_70488 = (state_70532[(9)]);
var inst_70487 = (state_70532[(10)]);
var inst_70509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70510 = [inst_70488,inst_70487];
var inst_70511 = (new cljs.core.PersistentVector(null,2,(5),inst_70509,inst_70510,null));
var state_70532__$1 = state_70532;
var statearr_70589_70648 = state_70532__$1;
(statearr_70589_70648[(2)] = inst_70511);

(statearr_70589_70648[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (30))){
var state_70532__$1 = state_70532;
var statearr_70590_70649 = state_70532__$1;
(statearr_70590_70649[(2)] = null);

(statearr_70590_70649[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (10))){
var inst_70418 = (state_70532[(19)]);
var state_70532__$1 = state_70532;
var statearr_70591_70650 = state_70532__$1;
(statearr_70591_70650[(2)] = inst_70418);

(statearr_70591_70650[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (18))){
var state_70532__$1 = state_70532;
var statearr_70592_70651 = state_70532__$1;
(statearr_70592_70651[(2)] = null);

(statearr_70592_70651[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (42))){
var inst_70519 = (state_70532[(15)]);
var state_70532__$1 = state_70532;
var statearr_70593_70652 = state_70532__$1;
(statearr_70593_70652[(2)] = inst_70519);

(statearr_70593_70652[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (37))){
var inst_70488 = (state_70532[(9)]);
var inst_70487 = (state_70532[(10)]);
var inst_70506 = (state_70532[(2)]);
var inst_70507 = (inst_70488 < inst_70487);
var state_70532__$1 = (function (){var statearr_70594 = state_70532;
(statearr_70594[(21)] = inst_70506);

return statearr_70594;
})();
if(cljs.core.truth_(inst_70507)){
var statearr_70595_70653 = state_70532__$1;
(statearr_70595_70653[(1)] = (38));

} else {
var statearr_70596_70654 = state_70532__$1;
(statearr_70596_70654[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70533 === (8))){
var inst_70418 = (state_70532[(19)]);
var inst_70418__$1 = (state_70532[(2)]);
var inst_70419 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_70418__$1);
var state_70532__$1 = (function (){var statearr_70597 = state_70532;
(statearr_70597[(19)] = inst_70418__$1);

return statearr_70597;
})();
if(cljs.core.truth_(inst_70419)){
var statearr_70598_70655 = state_70532__$1;
(statearr_70598_70655[(1)] = (9));

} else {
var statearr_70599_70656 = state_70532__$1;
(statearr_70599_70656[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_70600 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70600[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__);

(statearr_70600[(1)] = (1));

return statearr_70600;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_70532){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70532);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70601){var ex__2749__auto__ = e70601;
var statearr_70602_70657 = state_70532;
(statearr_70602_70657[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70532[(4)]))){
var statearr_70603_70658 = state_70532;
(statearr_70603_70658[(1)] = cljs.core.first.call(null,(state_70532[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70659 = state_70532;
state_70532 = G__70659;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__ = function(state_70532){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_70532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70604 = f__2769__auto__.call(null);
(statearr_70604[(6)] = c__2768__auto__);

return statearr_70604;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__70661 = arguments.length;
switch (G__70661) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.call(null,db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_70755){
var state_val_70756 = (state_70755[(1)]);
if((state_val_70756 === (7))){
var inst_70687 = (state_70755[(7)]);
var inst_70690 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_70687);
var state_70755__$1 = state_70755;
var statearr_70757_70808 = state_70755__$1;
(statearr_70757_70808[(2)] = inst_70690);

(statearr_70757_70808[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (20))){
var inst_70726 = (state_70755[(8)]);
var inst_70729 = fluree.db.api_js.format_block_resp_pretty.call(null,db,inst_70726);
var state_70755__$1 = state_70755;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70755__$1,(23),inst_70729);
} else {
if((state_val_70756 === (27))){
var inst_70735 = (state_70755[(9)]);
var inst_70741 = cljs.core.doall.call(null,inst_70735);
var state_70755__$1 = state_70755;
var statearr_70758_70809 = state_70755__$1;
(statearr_70758_70809[(2)] = inst_70741);

(statearr_70758_70809[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (1))){
var state_70755__$1 = state_70755;
var statearr_70759_70810 = state_70755__$1;
(statearr_70759_70810[(2)] = null);

(statearr_70759_70810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (24))){
var inst_70735 = (state_70755[(9)]);
var inst_70738 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_70739 = cljs.core.sequential_QMARK_.call(null,inst_70735);
var state_70755__$1 = (function (){var statearr_70760 = state_70755;
(statearr_70760[(10)] = inst_70738);

return statearr_70760;
})();
if(inst_70739){
var statearr_70761_70811 = state_70755__$1;
(statearr_70761_70811[(1)] = (27));

} else {
var statearr_70762_70812 = state_70755__$1;
(statearr_70762_70812[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (4))){
var inst_70662 = (state_70755[(2)]);
var inst_70663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70664 = [inst_70662];
var inst_70665 = (new cljs.core.PersistentVector(null,1,(5),inst_70663,inst_70664,null));
var inst_70666 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70665);
var inst_70667 = cljs.core.ex_data.call(null,inst_70662);
var inst_70668 = cljs.core.ex_message.call(null,inst_70662);
var inst_70669 = cljs.core.assoc.call(null,inst_70667,new cljs.core.Keyword(null,"message","message",-406056002),inst_70668);
var state_70755__$1 = (function (){var statearr_70763 = state_70755;
(statearr_70763[(11)] = inst_70666);

return statearr_70763;
})();
var statearr_70764_70813 = state_70755__$1;
(statearr_70764_70813[(2)] = inst_70669);

(statearr_70764_70813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (15))){
var inst_70687 = (state_70755[(7)]);
var inst_70700 = (state_70755[(2)]);
var inst_70701 = cljs.core.ex_info.call(null,inst_70700,inst_70687);
var inst_70702 = (function(){throw inst_70701})();
var state_70755__$1 = state_70755;
var statearr_70765_70814 = state_70755__$1;
(statearr_70765_70814[(2)] = inst_70702);

(statearr_70765_70814[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (21))){
var inst_70726 = (state_70755[(8)]);
var state_70755__$1 = state_70755;
var statearr_70766_70815 = state_70755__$1;
(statearr_70766_70815[(2)] = inst_70726);

(statearr_70766_70815[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (13))){
var inst_70695 = (state_70755[(12)]);
var state_70755__$1 = state_70755;
var statearr_70767_70816 = state_70755__$1;
(statearr_70767_70816[(2)] = inst_70695);

(statearr_70767_70816[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (22))){
var inst_70735 = (state_70755[(2)]);
var inst_70736 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_70755__$1 = (function (){var statearr_70768 = state_70755;
(statearr_70768[(9)] = inst_70735);

return statearr_70768;
})();
if(cljs.core.truth_(inst_70736)){
var statearr_70769_70817 = state_70755__$1;
(statearr_70769_70817[(1)] = (24));

} else {
var statearr_70770_70818 = state_70755__$1;
(statearr_70770_70818[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (29))){
var inst_70738 = (state_70755[(10)]);
var inst_70679 = (state_70755[(13)]);
var inst_70744 = (state_70755[(2)]);
var inst_70745 = fluree.db.util.core.response_time_formatted.call(null,inst_70679);
var inst_70746 = [(200),inst_70744,(100),inst_70745];
var inst_70747 = cljs.core.PersistentHashMap.fromArrays(inst_70738,inst_70746);
var state_70755__$1 = state_70755;
var statearr_70771_70819 = state_70755__$1;
(statearr_70771_70819[(2)] = inst_70747);

(statearr_70771_70819[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (6))){
var inst_70687 = (state_70755[(7)]);
var inst_70688 = (state_70755[(14)]);
var inst_70686 = (state_70755[(2)]);
var inst_70687__$1 = fluree.db.util.async.throw_err.call(null,inst_70686);
var inst_70688__$1 = cljs.core.map_QMARK_.call(null,inst_70687__$1);
var state_70755__$1 = (function (){var statearr_70772 = state_70755;
(statearr_70772[(7)] = inst_70687__$1);

(statearr_70772[(14)] = inst_70688__$1);

return statearr_70772;
})();
if(inst_70688__$1){
var statearr_70773_70820 = state_70755__$1;
(statearr_70773_70820[(1)] = (7));

} else {
var statearr_70774_70821 = state_70755__$1;
(statearr_70774_70821[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (28))){
var inst_70735 = (state_70755[(9)]);
var state_70755__$1 = state_70755;
var statearr_70775_70822 = state_70755__$1;
(statearr_70775_70822[(2)] = inst_70735);

(statearr_70775_70822[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (25))){
var inst_70735 = (state_70755[(9)]);
var state_70755__$1 = state_70755;
var statearr_70776_70823 = state_70755__$1;
(statearr_70776_70823[(2)] = inst_70735);

(statearr_70776_70823[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (17))){
var inst_70718 = cljs.core.pr_str.call(null,query_map);
var inst_70719 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_70718].join('');
var inst_70720 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70721 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70722 = cljs.core.PersistentHashMap.fromArrays(inst_70720,inst_70721);
var inst_70723 = cljs.core.ex_info.call(null,inst_70719,inst_70722);
var inst_70724 = (function(){throw inst_70723})();
var state_70755__$1 = state_70755;
var statearr_70777_70824 = state_70755__$1;
(statearr_70777_70824[(2)] = inst_70724);

(statearr_70777_70824[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (3))){
var inst_70753 = (state_70755[(2)]);
var state_70755__$1 = state_70755;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70755__$1,inst_70753);
} else {
if((state_val_70756 === (12))){
var inst_70687 = (state_70755[(7)]);
var inst_70705 = (state_70755[(2)]);
var inst_70706 = cljs.core.nth.call(null,inst_70687,(0),null);
var inst_70707 = cljs.core.nth.call(null,inst_70687,(1),null);
var inst_70708 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_70709 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_70710 = cljs.core.keys.call(null,inst_70709);
var inst_70711 = cljs.core._EQ_.call(null,inst_70708,inst_70710);
var state_70755__$1 = (function (){var statearr_70778 = state_70755;
(statearr_70778[(15)] = inst_70705);

(statearr_70778[(16)] = inst_70707);

(statearr_70778[(17)] = inst_70706);

return statearr_70778;
})();
if(inst_70711){
var statearr_70779_70825 = state_70755__$1;
(statearr_70779_70825[(1)] = (16));

} else {
var statearr_70780_70826 = state_70755__$1;
(statearr_70780_70826[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (2))){
var _ = (function (){var statearr_70781 = state_70755;
(statearr_70781[(4)] = cljs.core.cons.call(null,(5),(state_70755[(4)])));

return statearr_70781;
})();
var inst_70679 = fluree.db.util.core.current_time_millis.call(null);
var inst_70680 = db;
var inst_70681 = cljs.core.__destructure_map.call(null,inst_70680);
var inst_70682 = cljs.core.get.call(null,inst_70681,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_70683 = cljs.core.get.call(null,inst_70681,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_70684 = fluree.db.api_js.resolve_block_range.call(null,db,query_map);
var state_70755__$1 = (function (){var statearr_70782 = state_70755;
(statearr_70782[(18)] = inst_70682);

(statearr_70782[(13)] = inst_70679);

(statearr_70782[(19)] = inst_70683);

return statearr_70782;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70755__$1,(6),inst_70684);
} else {
if((state_val_70756 === (23))){
var inst_70731 = (state_70755[(2)]);
var inst_70732 = fluree.db.util.async.throw_err.call(null,inst_70731);
var state_70755__$1 = state_70755;
var statearr_70783_70827 = state_70755__$1;
(statearr_70783_70827[(2)] = inst_70732);

(statearr_70783_70827[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (19))){
var inst_70715 = (state_70755[(2)]);
var inst_70716 = fluree.db.util.async.throw_err.call(null,inst_70715);
var state_70755__$1 = state_70755;
var statearr_70784_70828 = state_70755__$1;
(statearr_70784_70828[(2)] = inst_70716);

(statearr_70784_70828[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (11))){
var state_70755__$1 = state_70755;
var statearr_70786_70829 = state_70755__$1;
(statearr_70786_70829[(2)] = null);

(statearr_70786_70829[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (9))){
var inst_70693 = (state_70755[(2)]);
var state_70755__$1 = state_70755;
if(cljs.core.truth_(inst_70693)){
var statearr_70787_70830 = state_70755__$1;
(statearr_70787_70830[(1)] = (10));

} else {
var statearr_70788_70831 = state_70755__$1;
(statearr_70788_70831[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (5))){
var _ = (function (){var statearr_70789 = state_70755;
(statearr_70789[(4)] = cljs.core.rest.call(null,(state_70755[(4)])));

return statearr_70789;
})();
var state_70755__$1 = state_70755;
var ex70785 = (state_70755__$1[(2)]);
var statearr_70790_70832 = state_70755__$1;
(statearr_70790_70832[(5)] = ex70785);


var statearr_70791_70833 = state_70755__$1;
(statearr_70791_70833[(1)] = (4));

(statearr_70791_70833[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (14))){
var inst_70682 = (state_70755[(18)]);
var inst_70683 = (state_70755[(19)]);
var inst_70698 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70682),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70683)].join('');
var state_70755__$1 = state_70755;
var statearr_70792_70834 = state_70755__$1;
(statearr_70792_70834[(2)] = inst_70698);

(statearr_70792_70834[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (26))){
var inst_70750 = (state_70755[(2)]);
var _ = (function (){var statearr_70793 = state_70755;
(statearr_70793[(4)] = cljs.core.rest.call(null,(state_70755[(4)])));

return statearr_70793;
})();
var state_70755__$1 = state_70755;
var statearr_70794_70835 = state_70755__$1;
(statearr_70794_70835[(2)] = inst_70750);

(statearr_70794_70835[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (16))){
var inst_70707 = (state_70755[(16)]);
var inst_70706 = (state_70755[(17)]);
var inst_70713 = fluree.db.query.block.block_range.call(null,db,inst_70706,inst_70707,opts);
var state_70755__$1 = state_70755;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70755__$1,(19),inst_70713);
} else {
if((state_val_70756 === (10))){
var inst_70687 = (state_70755[(7)]);
var inst_70695 = (state_70755[(12)]);
var inst_70695__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_70687);
var state_70755__$1 = (function (){var statearr_70795 = state_70755;
(statearr_70795[(12)] = inst_70695__$1);

return statearr_70795;
})();
if(cljs.core.truth_(inst_70695__$1)){
var statearr_70796_70836 = state_70755__$1;
(statearr_70796_70836[(1)] = (13));

} else {
var statearr_70797_70837 = state_70755__$1;
(statearr_70797_70837[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (18))){
var inst_70726 = (state_70755[(2)]);
var inst_70727 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70755__$1 = (function (){var statearr_70798 = state_70755;
(statearr_70798[(8)] = inst_70726);

return statearr_70798;
})();
if(cljs.core.truth_(inst_70727)){
var statearr_70799_70838 = state_70755__$1;
(statearr_70799_70838[(1)] = (20));

} else {
var statearr_70800_70839 = state_70755__$1;
(statearr_70800_70839[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70756 === (8))){
var inst_70688 = (state_70755[(14)]);
var state_70755__$1 = state_70755;
var statearr_70801_70840 = state_70755__$1;
(statearr_70801_70840[(2)] = inst_70688);

(statearr_70801_70840[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_70802 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70802[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_70802[(1)] = (1));

return statearr_70802;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_70755){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_70755);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e70803){var ex__2749__auto__ = e70803;
var statearr_70804_70841 = state_70755;
(statearr_70804_70841[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_70755[(4)]))){
var statearr_70805_70842 = state_70755;
(statearr_70805_70842[(1)] = cljs.core.first.call(null,(state_70755[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70843 = state_70755;
state_70755 = G__70843;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_70755){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_70755);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_70806 = f__2769__auto__.call(null);
(statearr_70806[(6)] = c__2768__auto__);

return statearr_70806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__70845 = arguments.length;
switch (G__70845) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.call(null,sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71040){
var state_val_71041 = (state_71040[(1)]);
if((state_val_71041 === (62))){
var inst_71038 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71040__$1,inst_71038);
} else {
if((state_val_71041 === (7))){
var inst_70866 = (state_71040[(7)]);
var inst_70876 = cljs.core.not_EQ_.call(null,(1),inst_70866);
var state_71040__$1 = state_71040;
var statearr_71042_71133 = state_71040__$1;
(statearr_71042_71133[(2)] = inst_70876);

(statearr_71042_71133[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (59))){
var inst_71026 = (state_71040[(2)]);
var inst_71027 = fluree.db.util.async.throw_err.call(null,inst_71026);
var state_71040__$1 = state_71040;
var statearr_71043_71134 = state_71040__$1;
(statearr_71043_71134[(2)] = inst_71027);

(statearr_71043_71134[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (20))){
var inst_70942 = (state_71040[(8)]);
var inst_70934 = (state_71040[(9)]);
var inst_70934__$1 = (state_71040[(2)]);
var inst_70935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70936 = cljs.core.get.call(null,inst_70934__$1,(0));
var inst_70937 = cljs.core.get.call(null,inst_70934__$1,(1));
var inst_70938 = cljs.core.get.call(null,inst_70934__$1,(2));
var inst_70939 = cljs.core.get.call(null,inst_70934__$1,(3));
var inst_70940 = [inst_70936,inst_70937,inst_70938,inst_70939];
var inst_70941 = (new cljs.core.PersistentVector(null,4,(5),inst_70935,inst_70940,null));
var inst_70942__$1 = cljs.core.nth.call(null,inst_70941,(0),null);
var inst_70943 = cljs.core.nth.call(null,inst_70941,(1),null);
var inst_70944 = cljs.core.nth.call(null,inst_70941,(2),null);
var inst_70945 = cljs.core.nth.call(null,inst_70941,(3),null);
var inst_70946 = (inst_70942__$1 == null);
var inst_70947 = cljs.core.not.call(null,inst_70946);
var state_71040__$1 = (function (){var statearr_71044 = state_71040;
(statearr_71044[(8)] = inst_70942__$1);

(statearr_71044[(10)] = inst_70943);

(statearr_71044[(9)] = inst_70934__$1);

(statearr_71044[(11)] = inst_70944);

(statearr_71044[(12)] = inst_70945);

return statearr_71044;
})();
if(inst_70947){
var statearr_71045_71135 = state_71040__$1;
(statearr_71045_71135[(1)] = (30));

} else {
var statearr_71046_71136 = state_71040__$1;
(statearr_71046_71136[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (58))){
var inst_70874 = (state_71040[(13)]);
var inst_71030 = (state_71040[(2)]);
var state_71040__$1 = (function (){var statearr_71047 = state_71040;
(statearr_71047[(14)] = inst_71030);

return statearr_71047;
})();
if(cljs.core.truth_(inst_70874)){
var statearr_71048_71137 = state_71040__$1;
(statearr_71048_71137[(1)] = (60));

} else {
var statearr_71049_71138 = state_71040__$1;
(statearr_71049_71138[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (60))){
var inst_71018 = (state_71040[(15)]);
var inst_71030 = (state_71040[(14)]);
var inst_71032 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_71033 = cljs.core.count.call(null,inst_71018);
var inst_71034 = [inst_71030,inst_71033,(200)];
var inst_71035 = cljs.core.PersistentHashMap.fromArrays(inst_71032,inst_71034);
var state_71040__$1 = state_71040;
var statearr_71050_71139 = state_71040__$1;
(statearr_71050_71139[(2)] = inst_71035);

(statearr_71050_71139[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (27))){
var inst_70853 = (state_71040[(16)]);
var inst_70922 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70853)].join('');
var inst_70923 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70924 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70925 = cljs.core.PersistentHashMap.fromArrays(inst_70923,inst_70924);
var inst_70926 = cljs.core.ex_info.call(null,inst_70922,inst_70925);
var inst_70927 = (function(){throw inst_70926})();
var state_71040__$1 = state_71040;
var statearr_71051_71140 = state_71040__$1;
(statearr_71051_71140[(2)] = inst_70927);

(statearr_71051_71140[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (1))){
var inst_70850 = query_map;
var inst_70851 = cljs.core.__destructure_map.call(null,inst_70850);
var inst_70852 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"block","block",664686210));
var inst_70853 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_70854 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_71040__$1 = (function (){var statearr_71052 = state_71040;
(statearr_71052[(17)] = inst_70854);

(statearr_71052[(18)] = inst_70852);

(statearr_71052[(16)] = inst_70853);

return statearr_71052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(2),sources);
} else {
if((state_val_71041 === (24))){
var inst_70853 = (state_71040[(16)]);
var inst_70911 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70853)].join('');
var inst_70912 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70913 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70914 = cljs.core.PersistentHashMap.fromArrays(inst_70912,inst_70913);
var inst_70915 = cljs.core.ex_info.call(null,inst_70911,inst_70914);
var inst_70916 = (function(){throw inst_70915})();
var state_71040__$1 = state_71040;
var statearr_71053_71141 = state_71040__$1;
(statearr_71053_71141[(2)] = inst_70916);

(statearr_71053_71141[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (55))){
var inst_70854 = (state_71040[(17)]);
var inst_71021 = (state_71040[(2)]);
var inst_71022 = fluree.db.util.async.throw_err.call(null,inst_71021);
var state_71040__$1 = (function (){var statearr_71054 = state_71040;
(statearr_71054[(19)] = inst_71022);

return statearr_71054;
})();
if(cljs.core.truth_(inst_70854)){
var statearr_71055_71142 = state_71040__$1;
(statearr_71055_71142[(1)] = (56));

} else {
var statearr_71056_71143 = state_71040__$1;
(statearr_71056_71143[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (39))){
var inst_70942 = (state_71040[(8)]);
var inst_70943 = (state_71040[(10)]);
var inst_70944 = (state_71040[(11)]);
var inst_70945 = (state_71040[(12)]);
var inst_70966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70968 = [inst_70943,inst_70942,inst_70944,inst_70945];
var inst_70969 = (new cljs.core.PersistentVector(null,4,(5),inst_70967,inst_70968,null));
var inst_70970 = [inst_70969,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_70971 = (new cljs.core.PersistentVector(null,2,(5),inst_70966,inst_70970,null));
var state_71040__$1 = state_71040;
var statearr_71057_71144 = state_71040__$1;
(statearr_71057_71144[(2)] = inst_70971);

(statearr_71057_71144[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (46))){
var inst_70976 = (state_71040[(20)]);
var state_71040__$1 = state_71040;
var statearr_71058_71145 = state_71040__$1;
(statearr_71058_71145[(2)] = inst_70976);

(statearr_71058_71145[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (4))){
var state_71040__$1 = state_71040;
var statearr_71059_71146 = state_71040__$1;
(statearr_71059_71146[(2)] = null);

(statearr_71059_71146[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (54))){
var inst_71018 = (state_71040[(15)]);
var inst_70857 = (state_71040[(21)]);
var inst_71017 = (state_71040[(2)]);
var inst_71018__$1 = fluree.db.util.async.throw_err.call(null,inst_71017);
var inst_71019 = fluree.db.api_js.format_history_resp.call(null,inst_70857,inst_71018__$1);
var state_71040__$1 = (function (){var statearr_71060 = state_71040;
(statearr_71060[(15)] = inst_71018__$1);

return statearr_71060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(55),inst_71019);
} else {
if((state_val_71041 === (15))){
var inst_70857 = (state_71040[(21)]);
var inst_70898 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70857);
var state_71040__$1 = state_71040;
var statearr_71061_71147 = state_71040__$1;
(statearr_71061_71147[(2)] = inst_70898);

(statearr_71061_71147[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (48))){
var inst_70942 = (state_71040[(8)]);
var inst_70943 = (state_71040[(10)]);
var inst_70944 = (state_71040[(11)]);
var inst_70945 = (state_71040[(12)]);
var inst_70987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70989 = [inst_70943,inst_70944,inst_70942,inst_70945];
var inst_70990 = (new cljs.core.PersistentVector(null,4,(5),inst_70988,inst_70989,null));
var inst_70991 = [inst_70990,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_70992 = (new cljs.core.PersistentVector(null,2,(5),inst_70987,inst_70991,null));
var state_71040__$1 = state_71040;
var statearr_71062_71148 = state_71040__$1;
(statearr_71062_71148[(2)] = inst_70992);

(statearr_71062_71148[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (50))){
var inst_71005 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71063_71149 = state_71040__$1;
(statearr_71063_71149[(2)] = inst_71005);

(statearr_71063_71149[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (21))){
var inst_70853 = (state_71040[(16)]);
var inst_70909 = cljs.core.empty_QMARK_.call(null,inst_70853);
var state_71040__$1 = state_71040;
if(inst_70909){
var statearr_71064_71150 = state_71040__$1;
(statearr_71064_71150[(1)] = (24));

} else {
var statearr_71065_71151 = state_71040__$1;
(statearr_71065_71151[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (31))){
var inst_70942 = (state_71040[(8)]);
var inst_70953 = (state_71040[(22)]);
var inst_70953__$1 = (inst_70942 == null);
var state_71040__$1 = (function (){var statearr_71066 = state_71040;
(statearr_71066[(22)] = inst_70953__$1);

return statearr_71066;
})();
if(cljs.core.truth_(inst_70953__$1)){
var statearr_71067_71152 = state_71040__$1;
(statearr_71067_71152[(1)] = (33));

} else {
var statearr_71068_71153 = state_71040__$1;
(statearr_71068_71153[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (32))){
var inst_70900 = (state_71040[(23)]);
var inst_70890 = (state_71040[(24)]);
var inst_70857 = (state_71040[(21)]);
var inst_71009 = (state_71040[(2)]);
var inst_71010 = cljs.core.nth.call(null,inst_71009,(0),null);
var inst_71011 = cljs.core.nth.call(null,inst_71009,(1),null);
var inst_71012 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_71013 = [inst_70890,inst_70900];
var inst_71014 = cljs.core.PersistentHashMap.fromArrays(inst_71012,inst_71013);
var inst_71015 = fluree.db.query.range.time_range.call(null,inst_70857,inst_71011,cljs.core._EQ_,inst_71010,inst_71014);
var state_71040__$1 = state_71040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(54),inst_71015);
} else {
if((state_val_71041 === (40))){
var inst_70942 = (state_71040[(8)]);
var inst_70973 = (state_71040[(25)]);
var inst_70973__$1 = (inst_70942 == null);
var state_71040__$1 = (function (){var statearr_71069 = state_71040;
(statearr_71069[(25)] = inst_70973__$1);

return statearr_71069;
})();
if(cljs.core.truth_(inst_70973__$1)){
var statearr_71070_71154 = state_71040__$1;
(statearr_71070_71154[(1)] = (42));

} else {
var statearr_71071_71155 = state_71040__$1;
(statearr_71071_71155[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (56))){
var inst_71022 = (state_71040[(19)]);
var inst_70857 = (state_71040[(21)]);
var inst_71024 = fluree.db.api_js.format_block_resp_pretty.call(null,inst_70857,inst_71022);
var state_71040__$1 = state_71040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(59),inst_71024);
} else {
if((state_val_71041 === (33))){
var inst_70943 = (state_71040[(10)]);
var inst_70956 = (state_71040[(26)]);
var inst_70955 = (inst_70943 == null);
var inst_70956__$1 = cljs.core.not.call(null,inst_70955);
var state_71040__$1 = (function (){var statearr_71072 = state_71040;
(statearr_71072[(26)] = inst_70956__$1);

return statearr_71072;
})();
if(inst_70956__$1){
var statearr_71073_71156 = state_71040__$1;
(statearr_71073_71156[(1)] = (36));

} else {
var statearr_71074_71157 = state_71040__$1;
(statearr_71074_71157[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (13))){
var inst_70884 = (state_71040[(2)]);
var inst_70885 = fluree.db.util.async.throw_err.call(null,inst_70884);
var inst_70886 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70885);
var inst_70887 = (inst_70886 - (1));
var state_71040__$1 = state_71040;
var statearr_71075_71158 = state_71040__$1;
(statearr_71075_71158[(2)] = inst_70887);

(statearr_71075_71158[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (22))){
var state_71040__$1 = state_71040;
var statearr_71076_71159 = state_71040__$1;
(statearr_71076_71159[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (36))){
var inst_70944 = (state_71040[(11)]);
var inst_70958 = (inst_70944 == null);
var state_71040__$1 = state_71040;
var statearr_71078_71160 = state_71040__$1;
(statearr_71078_71160[(2)] = inst_70958);

(statearr_71078_71160[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (41))){
var inst_71007 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71079_71161 = state_71040__$1;
(statearr_71079_71161[(2)] = inst_71007);

(statearr_71079_71161[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (43))){
var inst_70973 = (state_71040[(25)]);
var state_71040__$1 = state_71040;
var statearr_71080_71162 = state_71040__$1;
(statearr_71080_71162[(2)] = inst_70973);

(statearr_71080_71162[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (61))){
var inst_71030 = (state_71040[(14)]);
var state_71040__$1 = state_71040;
var statearr_71081_71163 = state_71040__$1;
(statearr_71081_71163[(2)] = inst_71030);

(statearr_71081_71163[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (29))){
var inst_70930 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71082_71164 = state_71040__$1;
(statearr_71082_71164[(2)] = inst_70930);

(statearr_71082_71164[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (44))){
var inst_70985 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
if(cljs.core.truth_(inst_70985)){
var statearr_71083_71165 = state_71040__$1;
(statearr_71083_71165[(1)] = (48));

} else {
var statearr_71084_71166 = state_71040__$1;
(statearr_71084_71166[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (6))){
var inst_70861 = (state_71040[(2)]);
var inst_70862 = fluree.db.util.async.throw_err.call(null,inst_70861);
var state_71040__$1 = state_71040;
var statearr_71085_71167 = state_71040__$1;
(statearr_71085_71167[(2)] = inst_70862);

(statearr_71085_71167[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (28))){
var state_71040__$1 = state_71040;
var statearr_71086_71168 = state_71040__$1;
(statearr_71086_71168[(2)] = null);

(statearr_71086_71168[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (51))){
var inst_70853 = (state_71040[(16)]);
var inst_70995 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70853)].join('');
var inst_70996 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70997 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70998 = cljs.core.PersistentHashMap.fromArrays(inst_70996,inst_70997);
var inst_70999 = cljs.core.ex_info.call(null,inst_70995,inst_70998);
var inst_71000 = (function(){throw inst_70999})();
var state_71040__$1 = state_71040;
var statearr_71087_71169 = state_71040__$1;
(statearr_71087_71169[(2)] = inst_71000);

(statearr_71087_71169[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (25))){
var inst_70853 = (state_71040[(16)]);
var state_71040__$1 = state_71040;
var statearr_71088_71170 = state_71040__$1;
(statearr_71088_71170[(2)] = inst_70853);

(statearr_71088_71170[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (34))){
var inst_70953 = (state_71040[(22)]);
var state_71040__$1 = state_71040;
var statearr_71089_71171 = state_71040__$1;
(statearr_71089_71171[(2)] = inst_70953);

(statearr_71089_71171[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (17))){
var inst_70894 = (state_71040[(2)]);
var inst_70895 = fluree.db.util.async.throw_err.call(null,inst_70894);
var inst_70896 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_70895);
var state_71040__$1 = state_71040;
var statearr_71090_71172 = state_71040__$1;
(statearr_71090_71172[(2)] = inst_70896);

(statearr_71090_71172[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (3))){
var inst_70857 = (state_71040[(21)]);
var inst_70859 = fluree.db.api_js.resolve_block_range.call(null,inst_70857,query_map);
var state_71040__$1 = state_71040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(6),inst_70859);
} else {
if((state_val_71041 === (12))){
var inst_70867 = (state_71040[(27)]);
var inst_70890 = (state_71040[(2)]);
var state_71040__$1 = (function (){var statearr_71091 = state_71040;
(statearr_71091[(24)] = inst_70890);

return statearr_71091;
})();
if(cljs.core.truth_(inst_70867)){
var statearr_71092_71173 = state_71040__$1;
(statearr_71092_71173[(1)] = (14));

} else {
var statearr_71093_71174 = state_71040__$1;
(statearr_71093_71174[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (2))){
var inst_70852 = (state_71040[(18)]);
var inst_70856 = (state_71040[(2)]);
var inst_70857 = fluree.db.util.async.throw_err.call(null,inst_70856);
var state_71040__$1 = (function (){var statearr_71094 = state_71040;
(statearr_71094[(21)] = inst_70857);

return statearr_71094;
})();
if(cljs.core.truth_(inst_70852)){
var statearr_71095_71175 = state_71040__$1;
(statearr_71095_71175[(1)] = (3));

} else {
var statearr_71096_71176 = state_71040__$1;
(statearr_71096_71176[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (23))){
var inst_70932 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71097_71177 = state_71040__$1;
(statearr_71097_71177[(2)] = inst_70932);

(statearr_71097_71177[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (47))){
var inst_70982 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71098_71178 = state_71040__$1;
(statearr_71098_71178[(2)] = inst_70982);

(statearr_71098_71178[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (35))){
var inst_70964 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
if(cljs.core.truth_(inst_70964)){
var statearr_71099_71179 = state_71040__$1;
(statearr_71099_71179[(1)] = (39));

} else {
var statearr_71100_71180 = state_71040__$1;
(statearr_71100_71180[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (19))){
var inst_70853 = (state_71040[(16)]);
var inst_70907 = cljs.core.sequential_QMARK_.call(null,inst_70853);
var state_71040__$1 = state_71040;
if(inst_70907){
var statearr_71101_71181 = state_71040__$1;
(statearr_71101_71181[(1)] = (21));

} else {
var statearr_71102_71182 = state_71040__$1;
(statearr_71102_71182[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (57))){
var inst_71022 = (state_71040[(19)]);
var state_71040__$1 = state_71040;
var statearr_71103_71183 = state_71040__$1;
(statearr_71103_71183[(2)] = inst_71022);

(statearr_71103_71183[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (11))){
var state_71040__$1 = state_71040;
var statearr_71104_71184 = state_71040__$1;
(statearr_71104_71184[(2)] = (-1));

(statearr_71104_71184[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (9))){
var inst_70879 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
if(cljs.core.truth_(inst_70879)){
var statearr_71105_71185 = state_71040__$1;
(statearr_71105_71185[(1)] = (10));

} else {
var statearr_71106_71186 = state_71040__$1;
(statearr_71106_71186[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (5))){
var inst_70866 = (state_71040[(7)]);
var inst_70865 = (state_71040[(2)]);
var inst_70866__$1 = cljs.core.nth.call(null,inst_70865,(0),null);
var inst_70867 = cljs.core.nth.call(null,inst_70865,(1),null);
var inst_70874 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71040__$1 = (function (){var statearr_71107 = state_71040;
(statearr_71107[(13)] = inst_70874);

(statearr_71107[(27)] = inst_70867);

(statearr_71107[(7)] = inst_70866__$1);

return statearr_71107;
})();
if(cljs.core.truth_(inst_70866__$1)){
var statearr_71108_71187 = state_71040__$1;
(statearr_71108_71187[(1)] = (7));

} else {
var statearr_71109_71188 = state_71040__$1;
(statearr_71109_71188[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (14))){
var inst_70867 = (state_71040[(27)]);
var inst_70857 = (state_71040[(21)]);
var inst_70892 = fluree.db.time_travel.as_of_block.call(null,inst_70857,inst_70867);
var state_71040__$1 = state_71040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(17),inst_70892);
} else {
if((state_val_71041 === (45))){
var inst_70944 = (state_71040[(11)]);
var inst_70978 = (inst_70944 == null);
var inst_70979 = cljs.core.not.call(null,inst_70978);
var state_71040__$1 = state_71040;
var statearr_71110_71189 = state_71040__$1;
(statearr_71110_71189[(2)] = inst_70979);

(statearr_71110_71189[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (53))){
var inst_71003 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71111_71190 = state_71040__$1;
(statearr_71111_71190[(2)] = inst_71003);

(statearr_71111_71190[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (26))){
var inst_70919 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71112_71191 = state_71040__$1;
(statearr_71112_71191[(2)] = inst_70919);

(statearr_71112_71191[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (16))){
var inst_70853 = (state_71040[(16)]);
var inst_70900 = (state_71040[(2)]);
var inst_70901 = fluree.db.util.core.subj_ident_QMARK_.call(null,inst_70853);
var state_71040__$1 = (function (){var statearr_71113 = state_71040;
(statearr_71113[(23)] = inst_70900);

return statearr_71113;
})();
if(inst_70901){
var statearr_71114_71192 = state_71040__$1;
(statearr_71114_71192[(1)] = (18));

} else {
var statearr_71115_71193 = state_71040__$1;
(statearr_71115_71193[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (38))){
var inst_70961 = (state_71040[(2)]);
var state_71040__$1 = state_71040;
var statearr_71116_71194 = state_71040__$1;
(statearr_71116_71194[(2)] = inst_70961);

(statearr_71116_71194[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (30))){
var inst_70934 = (state_71040[(9)]);
var inst_70949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70950 = [inst_70934,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_70951 = (new cljs.core.PersistentVector(null,2,(5),inst_70949,inst_70950,null));
var state_71040__$1 = state_71040;
var statearr_71117_71195 = state_71040__$1;
(statearr_71117_71195[(2)] = inst_70951);

(statearr_71117_71195[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (10))){
var inst_70857 = (state_71040[(21)]);
var inst_70866 = (state_71040[(7)]);
var inst_70881 = (inst_70866 - (1));
var inst_70882 = fluree.db.time_travel.as_of_block.call(null,inst_70857,inst_70881);
var state_71040__$1 = state_71040;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71040__$1,(13),inst_70882);
} else {
if((state_val_71041 === (18))){
var inst_70853 = (state_71040[(16)]);
var inst_70903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70904 = [inst_70853];
var inst_70905 = (new cljs.core.PersistentVector(null,1,(5),inst_70903,inst_70904,null));
var state_71040__$1 = state_71040;
var statearr_71118_71196 = state_71040__$1;
(statearr_71118_71196[(2)] = inst_70905);

(statearr_71118_71196[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (52))){
var state_71040__$1 = state_71040;
var statearr_71119_71197 = state_71040__$1;
(statearr_71119_71197[(2)] = null);

(statearr_71119_71197[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (42))){
var inst_70976 = (state_71040[(20)]);
var inst_70943 = (state_71040[(10)]);
var inst_70975 = (inst_70943 == null);
var inst_70976__$1 = cljs.core.not.call(null,inst_70975);
var state_71040__$1 = (function (){var statearr_71120 = state_71040;
(statearr_71120[(20)] = inst_70976__$1);

return statearr_71120;
})();
if(inst_70976__$1){
var statearr_71121_71198 = state_71040__$1;
(statearr_71121_71198[(1)] = (45));

} else {
var statearr_71122_71199 = state_71040__$1;
(statearr_71122_71199[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (37))){
var inst_70956 = (state_71040[(26)]);
var state_71040__$1 = state_71040;
var statearr_71123_71200 = state_71040__$1;
(statearr_71123_71200[(2)] = inst_70956);

(statearr_71123_71200[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (8))){
var inst_70866 = (state_71040[(7)]);
var state_71040__$1 = state_71040;
var statearr_71124_71201 = state_71040__$1;
(statearr_71124_71201[(2)] = inst_70866);

(statearr_71124_71201[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71041 === (49))){
var state_71040__$1 = state_71040;
var statearr_71125_71202 = state_71040__$1;
(statearr_71125_71202[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71127 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71127[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71127[(1)] = (1));

return statearr_71127;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71040){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71040);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71128){var ex__2749__auto__ = e71128;
var statearr_71129_71203 = state_71040;
(statearr_71129_71203[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71040[(4)]))){
var statearr_71130_71204 = state_71040;
(statearr_71130_71204[(1)] = cljs.core.first.call(null,(state_71040[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71205 = state_71040;
state_71040 = G__71205;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71040){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71040);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71131 = f__2769__auto__.call(null);
(statearr_71131[(6)] = c__2768__auto__);

return statearr_71131;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__71213 = arguments.length;
switch (G__71213) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.call(null,sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,fluree.db.time_travel.block_to_int_format.call(null,fluree.db.util.async.throw_err.call(null,cljs.core.async._LT__BANG_.call(null,db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_.call(null,block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.call(null,["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.call(null,multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__71206_SHARP_){
return cljs.core.dissoc.call(null,p1__71206_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals.call(null,multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys.call(null,multi_query_map_SINGLEQUOTE_);
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71302){
var state_val_71303 = (state_71302[(1)]);
if((state_val_71303 === (7))){
var inst_71256 = (state_71302[(7)]);
var inst_71263 = (state_71302[(8)]);
var inst_71259 = (state_71302[(9)]);
var inst_71253 = (state_71302[(10)]);
var inst_71269 = (function (){var responses = inst_71253;
var responses_STAR_ = inst_71256;
var statuses = inst_71259;
var fuel = inst_71263;
return (function (p1__71209_SHARP_){
return cljs.core._EQ_.call(null,(200),p1__71209_SHARP_);
});
})();
var inst_71270 = cljs.core.some.call(null,inst_71269,inst_71259);
var state_71302__$1 = state_71302;
if(cljs.core.truth_(inst_71270)){
var statearr_71304_71352 = state_71302__$1;
(statearr_71304_71352[(1)] = (9));

} else {
var statearr_71305_71353 = state_71302__$1;
(statearr_71305_71353[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (20))){
var inst_71297 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
var statearr_71306_71354 = state_71302__$1;
(statearr_71306_71354[(2)] = inst_71297);

(statearr_71306_71354[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (1))){
var inst_71248 = cljs.core.async.chan.call(null,(1));
var inst_71249 = (function (){var c__2768__auto____$1 = inst_71248;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71246){
var state_val_71247 = (state_71246[(1)]);
if((state_val_71247 === (1))){
var inst_71214 = cljs.core.first.call(null,keys_SINGLEQUOTE_);
var inst_71215 = cljs.core.first.call(null,vals_SINGLEQUOTE_);
var inst_71216 = cljs.core.assoc.call(null,inst_71215,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_71217 = cljs.core.rest.call(null,keys_SINGLEQUOTE_);
var inst_71218 = cljs.core.rest.call(null,vals_SINGLEQUOTE_);
var inst_71219 = cljs.core.PersistentHashMap.EMPTY;
var inst_71220 = inst_71214;
var inst_71221 = inst_71216;
var inst_71222 = inst_71217;
var inst_71223 = inst_71218;
var inst_71224 = inst_71219;
var state_71246__$1 = (function (){var statearr_71307 = state_71246;
(statearr_71307[(7)] = inst_71220);

(statearr_71307[(8)] = inst_71223);

(statearr_71307[(9)] = inst_71222);

(statearr_71307[(10)] = inst_71221);

(statearr_71307[(11)] = inst_71224);

return statearr_71307;
})();
var statearr_71308_71355 = state_71246__$1;
(statearr_71308_71355[(2)] = null);

(statearr_71308_71355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71247 === (2))){
var inst_71221 = (state_71246[(10)]);
var inst_71226 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71221);
var inst_71227 = cljs.core.merge.call(null,opts,inst_71226);
var inst_71228 = cljs.core.assoc.call(null,inst_71221,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71227);
var inst_71229 = fluree.db.api_js.query_async.call(null,db,inst_71228,db_fn);
var state_71246__$1 = state_71246;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71246__$1,(4),inst_71229);
} else {
if((state_val_71247 === (3))){
var inst_71244 = (state_71246[(2)]);
var state_71246__$1 = state_71246;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71246__$1,inst_71244);
} else {
if((state_val_71247 === (4))){
var inst_71220 = (state_71246[(7)]);
var inst_71222 = (state_71246[(9)]);
var inst_71224 = (state_71246[(11)]);
var inst_71231 = (state_71246[(2)]);
var inst_71232 = cljs.core.assoc.call(null,inst_71224,inst_71220,inst_71231);
var inst_71233 = cljs.core.first.call(null,inst_71222);
var state_71246__$1 = (function (){var statearr_71309 = state_71246;
(statearr_71309[(12)] = inst_71232);

return statearr_71309;
})();
if(cljs.core.truth_(inst_71233)){
var statearr_71310_71356 = state_71246__$1;
(statearr_71310_71356[(1)] = (5));

} else {
var statearr_71311_71357 = state_71246__$1;
(statearr_71311_71357[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71247 === (5))){
var inst_71232 = (state_71246[(12)]);
var inst_71223 = (state_71246[(8)]);
var inst_71222 = (state_71246[(9)]);
var inst_71235 = cljs.core.first.call(null,inst_71222);
var inst_71236 = cljs.core.first.call(null,inst_71223);
var inst_71237 = cljs.core.rest.call(null,inst_71222);
var inst_71238 = cljs.core.rest.call(null,inst_71223);
var inst_71220 = inst_71235;
var inst_71221 = inst_71236;
var inst_71222__$1 = inst_71237;
var inst_71223__$1 = inst_71238;
var inst_71224 = inst_71232;
var state_71246__$1 = (function (){var statearr_71312 = state_71246;
(statearr_71312[(7)] = inst_71220);

(statearr_71312[(8)] = inst_71223__$1);

(statearr_71312[(9)] = inst_71222__$1);

(statearr_71312[(10)] = inst_71221);

(statearr_71312[(11)] = inst_71224);

return statearr_71312;
})();
var statearr_71313_71358 = state_71246__$1;
(statearr_71313_71358[(2)] = null);

(statearr_71313_71358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71247 === (6))){
var inst_71232 = (state_71246[(12)]);
var state_71246__$1 = state_71246;
var statearr_71314_71359 = state_71246__$1;
(statearr_71314_71359[(2)] = inst_71232);

(statearr_71314_71359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71247 === (7))){
var inst_71242 = (state_71246[(2)]);
var state_71246__$1 = state_71246;
var statearr_71315_71360 = state_71246__$1;
(statearr_71315_71360[(2)] = inst_71242);

(statearr_71315_71360[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71316 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71316[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71316[(1)] = (1));

return statearr_71316;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71246){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71246);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71317){var ex__2749__auto__ = e71317;
var statearr_71318_71361 = state_71246;
(statearr_71318_71361[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71246[(4)]))){
var statearr_71319_71362 = state_71246;
(statearr_71319_71362[(1)] = cljs.core.first.call(null,(state_71246[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71363 = state_71246;
state_71246 = G__71363;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71246){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71320 = f__2769__auto__.call(null);
(statearr_71320[(6)] = c__2768__auto____$1);

return statearr_71320;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_71250 = cljs.core.async.impl.dispatch.run.call(null,inst_71249);
var state_71302__$1 = (function (){var statearr_71321 = state_71302;
(statearr_71321[(11)] = inst_71250);

return statearr_71321;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71302__$1,(2),inst_71248);
} else {
if((state_val_71303 === (4))){
var inst_71253 = (state_71302[(10)]);
var state_71302__$1 = state_71302;
var statearr_71322_71364 = state_71302__$1;
(statearr_71322_71364[(2)] = inst_71253);

(statearr_71322_71364[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (15))){
var state_71302__$1 = state_71302;
var statearr_71323_71365 = state_71302__$1;
(statearr_71323_71365[(2)] = (400));

(statearr_71323_71365[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (13))){
var state_71302__$1 = state_71302;
var statearr_71324_71366 = state_71302__$1;
(statearr_71324_71366[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (6))){
var inst_71259 = (state_71302[(9)]);
var inst_71267 = cljs.core.first.call(null,inst_71259);
var state_71302__$1 = state_71302;
var statearr_71326_71367 = state_71302__$1;
(statearr_71326_71367[(2)] = inst_71267);

(statearr_71326_71367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (17))){
var inst_71280 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
var statearr_71327_71368 = state_71302__$1;
(statearr_71327_71368[(2)] = inst_71280);

(statearr_71327_71368[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (3))){
var inst_71256 = (state_71302[(7)]);
var inst_71263 = (state_71302[(8)]);
var inst_71259 = (state_71302[(9)]);
var inst_71253 = (state_71302[(10)]);
var inst_71258 = cljs.core.vals.call(null,inst_71253);
var inst_71259__$1 = cljs.core.map.call(null,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71258);
var inst_71260 = (function (){var responses = inst_71253;
var responses_STAR_ = inst_71256;
var statuses = inst_71259__$1;
return (function (p1__71207_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__71207_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_71261 = cljs.core.vals.call(null,inst_71253);
var inst_71262 = cljs.core.map.call(null,inst_71260,inst_71261);
var inst_71263__$1 = cljs.core.apply.call(null,cljs.core._PLUS_,inst_71262);
var inst_71264 = (function (){var responses = inst_71253;
var responses_STAR_ = inst_71256;
var statuses = inst_71259__$1;
var fuel = inst_71263__$1;
return (function (p1__71208_SHARP_){
return cljs.core._EQ_.call(null,cljs.core.first.call(null,statuses),p1__71208_SHARP_);
});
})();
var inst_71265 = cljs.core.every_QMARK_.call(null,inst_71264,inst_71259__$1);
var state_71302__$1 = (function (){var statearr_71328 = state_71302;
(statearr_71328[(8)] = inst_71263__$1);

(statearr_71328[(9)] = inst_71259__$1);

return statearr_71328;
})();
if(inst_71265){
var statearr_71329_71369 = state_71302__$1;
(statearr_71329_71369[(1)] = (6));

} else {
var statearr_71330_71370 = state_71302__$1;
(statearr_71330_71370[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (12))){
var state_71302__$1 = state_71302;
var statearr_71331_71371 = state_71302__$1;
(statearr_71331_71371[(2)] = (500));

(statearr_71331_71371[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (2))){
var inst_71253 = (state_71302[(10)]);
var inst_71252 = (state_71302[(2)]);
var inst_71253__$1 = fluree.db.util.async.throw_err.call(null,inst_71252);
var inst_71254 = (function (){var responses = inst_71253__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.call(null,acc,index,resp);
}
});
})();
var inst_71255 = cljs.core.PersistentHashMap.EMPTY;
var inst_71256 = cljs.core.reduce_kv.call(null,inst_71254,inst_71255,inst_71253__$1);
var state_71302__$1 = (function (){var statearr_71332 = state_71302;
(statearr_71332[(7)] = inst_71256);

(statearr_71332[(10)] = inst_71253__$1);

return statearr_71332;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_71333_71372 = state_71302__$1;
(statearr_71333_71372[(1)] = (3));

} else {
var statearr_71334_71373 = state_71302__$1;
(statearr_71334_71373[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (19))){
var inst_71256 = (state_71302[(7)]);
var inst_71263 = (state_71302[(8)]);
var inst_71286 = (state_71302[(12)]);
var inst_71295 = cljs.core.assoc.call(null,inst_71256,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71286,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71263);
var state_71302__$1 = state_71302;
var statearr_71335_71374 = state_71302__$1;
(statearr_71335_71374[(2)] = inst_71295);

(statearr_71335_71374[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (11))){
var inst_71284 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
var statearr_71336_71375 = state_71302__$1;
(statearr_71336_71375[(2)] = inst_71284);

(statearr_71336_71375[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (9))){
var state_71302__$1 = state_71302;
var statearr_71337_71376 = state_71302__$1;
(statearr_71337_71376[(2)] = (207));

(statearr_71337_71376[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (5))){
var inst_71300 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71302__$1,inst_71300);
} else {
if((state_val_71303 === (14))){
var inst_71282 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
var statearr_71338_71377 = state_71302__$1;
(statearr_71338_71377[(2)] = inst_71282);

(statearr_71338_71377[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (16))){
var state_71302__$1 = state_71302;
var statearr_71339_71378 = state_71302__$1;
(statearr_71339_71378[(2)] = null);

(statearr_71339_71378[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (10))){
var inst_71256 = (state_71302[(7)]);
var inst_71263 = (state_71302[(8)]);
var inst_71259 = (state_71302[(9)]);
var inst_71253 = (state_71302[(10)]);
var inst_71273 = (function (){var responses = inst_71253;
var responses_STAR_ = inst_71256;
var statuses = inst_71259;
var fuel = inst_71263;
return (function (p1__71210_SHARP_){
return ((499) < p1__71210_SHARP_);
});
})();
var inst_71274 = cljs.core.some.call(null,inst_71273,inst_71259);
var state_71302__$1 = state_71302;
if(cljs.core.truth_(inst_71274)){
var statearr_71340_71379 = state_71302__$1;
(statearr_71340_71379[(1)] = (12));

} else {
var statearr_71341_71380 = state_71302__$1;
(statearr_71341_71380[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (18))){
var inst_71291 = (state_71302[(13)]);
var inst_71256 = (state_71302[(7)]);
var inst_71263 = (state_71302[(8)]);
var inst_71286 = (state_71302[(12)]);
var inst_71293 = cljs.core.assoc.call(null,inst_71256,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71286,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71263,new cljs.core.Keyword(null,"block","block",664686210),inst_71291);
var state_71302__$1 = state_71302;
var statearr_71342_71381 = state_71302__$1;
(statearr_71342_71381[(2)] = inst_71293);

(statearr_71342_71381[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (8))){
var inst_71291 = (state_71302[(13)]);
var inst_71256 = (state_71302[(7)]);
var inst_71263 = (state_71302[(8)]);
var inst_71259 = (state_71302[(9)]);
var inst_71286 = (state_71302[(12)]);
var inst_71253 = (state_71302[(10)]);
var inst_71286__$1 = (state_71302[(2)]);
var inst_71287 = (function (){var responses = inst_71253;
var responses_STAR_ = inst_71256;
var statuses = inst_71259;
var fuel = inst_71263;
var status = inst_71286__$1;
return (function (p1__71211_SHARP_){
return cljs.core._EQ_.call(null,(200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__71211_SHARP_));
});
})();
var inst_71288 = cljs.core.vals.call(null,inst_71253);
var inst_71289 = cljs.core.filter.call(null,inst_71287,inst_71288);
var inst_71290 = cljs.core.first.call(null,inst_71289);
var inst_71291__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71290);
var state_71302__$1 = (function (){var statearr_71343 = state_71302;
(statearr_71343[(13)] = inst_71291__$1);

(statearr_71343[(12)] = inst_71286__$1);

return statearr_71343;
})();
if(cljs.core.truth_(inst_71291__$1)){
var statearr_71344_71382 = state_71302__$1;
(statearr_71344_71382[(1)] = (18));

} else {
var statearr_71345_71383 = state_71302__$1;
(statearr_71345_71383[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71346 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71346[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71346[(1)] = (1));

return statearr_71346;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71302){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71347){var ex__2749__auto__ = e71347;
var statearr_71348_71384 = state_71302;
(statearr_71348_71384[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71302[(4)]))){
var statearr_71349_71385 = state_71302;
(statearr_71349_71385[(1)] = cljs.core.first.call(null,(state_71302[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71386 = state_71302;
state_71302 = G__71386;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71302){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71350 = f__2769__auto__.call(null);
(statearr_71350[(6)] = c__2768__auto__);

return statearr_71350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__71388 = arguments.length;
switch (G__71388) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.call(null,ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_.call(null,ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,ledger))].join(''):ledger);
var map__71389 = opts;
var map__71389__$1 = cljs.core.__destructure_map.call(null,map__71389);
var auth = cljs.core.get.call(null,map__71389__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__71389__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.call(null,map__71389__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.call(null,map__71389__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = fluree.crypto.account_id_from_private.call(null,private_key);
var vec__71390 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.call(null,auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.call(null,vec__71390,(0),null);
var authority = cljs.core.nth.call(null,vec__71390,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis.call(null);
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace.call(null,fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e71393){var e = e71393;
throw cljs.core.ex_info.call(null,"Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message.call(null,cmd,private_key);
var id = fluree.crypto.sha3_256.call(null,cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__71396 = arguments.length;
switch (G__71396) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.call(null,conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_71430){
var state_val_71431 = (state_71430[(1)]);
if((state_val_71431 === (7))){
var state_71430__$1 = state_71430;
var statearr_71432_71453 = state_71430__$1;
(statearr_71432_71453[(2)] = opts);

(statearr_71432_71453[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (1))){
var state_71430__$1 = state_71430;
var statearr_71433_71454 = state_71430__$1;
(statearr_71433_71454[(2)] = null);

(statearr_71433_71454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (4))){
var inst_71397 = (state_71430[(2)]);
var inst_71398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71399 = [inst_71397];
var inst_71400 = (new cljs.core.PersistentVector(null,1,(5),inst_71398,inst_71399,null));
var inst_71401 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71400);
var inst_71402 = cljs.core.ex_data.call(null,inst_71397);
var inst_71403 = cljs.core.ex_message.call(null,inst_71397);
var inst_71404 = cljs.core.assoc.call(null,inst_71402,new cljs.core.Keyword(null,"message","message",-406056002),inst_71403);
var state_71430__$1 = (function (){var statearr_71434 = state_71430;
(statearr_71434[(7)] = inst_71401);

return statearr_71434;
})();
var statearr_71435_71455 = state_71430__$1;
(statearr_71435_71455[(2)] = inst_71404);

(statearr_71435_71455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (6))){
var inst_71414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71415 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_71416 = (new cljs.core.PersistentVector(null,1,(5),inst_71414,inst_71415,null));
var inst_71417 = cljs.core.assoc_in.call(null,opts,inst_71416,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_71430__$1 = state_71430;
var statearr_71436_71456 = state_71430__$1;
(statearr_71436_71456[(2)] = inst_71417);

(statearr_71436_71456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (3))){
var inst_71428 = (state_71430[(2)]);
var state_71430__$1 = state_71430;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71430__$1,inst_71428);
} else {
if((state_val_71431 === (2))){
var _ = (function (){var statearr_71438 = state_71430;
(statearr_71438[(4)] = cljs.core.cons.call(null,(5),(state_71430[(4)])));

return statearr_71438;
})();
var inst_71410 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71411 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71412 = (inst_71411 == null);
var state_71430__$1 = (function (){var statearr_71439 = state_71430;
(statearr_71439[(8)] = inst_71410);

return statearr_71439;
})();
if(cljs.core.truth_(inst_71412)){
var statearr_71440_71457 = state_71430__$1;
(statearr_71440_71457[(1)] = (6));

} else {
var statearr_71441_71458 = state_71430__$1;
(statearr_71441_71458[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (9))){
var inst_71424 = (state_71430[(2)]);
var inst_71425 = fluree.db.util.async.throw_err.call(null,inst_71424);
var _ = (function (){var statearr_71442 = state_71430;
(statearr_71442[(4)] = cljs.core.rest.call(null,(state_71430[(4)])));

return statearr_71442;
})();
var state_71430__$1 = state_71430;
var statearr_71443_71459 = state_71430__$1;
(statearr_71443_71459[(2)] = inst_71425);

(statearr_71443_71459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (5))){
var _ = (function (){var statearr_71444 = state_71430;
(statearr_71444[(4)] = cljs.core.rest.call(null,(state_71430[(4)])));

return statearr_71444;
})();
var state_71430__$1 = state_71430;
var ex71437 = (state_71430__$1[(2)]);
var statearr_71445_71460 = state_71430__$1;
(statearr_71445_71460[(5)] = ex71437);


var statearr_71446_71461 = state_71430__$1;
(statearr_71446_71461[(1)] = (4));

(statearr_71446_71461[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71431 === (8))){
var inst_71410 = (state_71430[(8)]);
var inst_71420 = (state_71430[(2)]);
var inst_71421 = fluree.db.api_js.qry__GT_command.call(null,ledger,query_map,inst_71410,inst_71420);
var inst_71422 = fluree.db.operations.command_async.call(null,conn,inst_71421);
var state_71430__$1 = state_71430;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71430__$1,(9),inst_71422);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2746__auto__ = null;
var fluree$db$api_js$state_machine__2746__auto____0 = (function (){
var statearr_71447 = [null,null,null,null,null,null,null,null,null];
(statearr_71447[(0)] = fluree$db$api_js$state_machine__2746__auto__);

(statearr_71447[(1)] = (1));

return statearr_71447;
});
var fluree$db$api_js$state_machine__2746__auto____1 = (function (state_71430){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_71430);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e71448){var ex__2749__auto__ = e71448;
var statearr_71449_71462 = state_71430;
(statearr_71449_71462[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_71430[(4)]))){
var statearr_71450_71463 = state_71430;
(statearr_71450_71463[(1)] = cljs.core.first.call(null,(state_71430[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71464 = state_71430;
state_71430 = G__71464;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2746__auto__ = function(state_71430){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2746__auto____1.call(this,state_71430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2746__auto____0;
fluree$db$api_js$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2746__auto____1;
return fluree$db$api_js$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_71451 = f__2769__auto__.call(null);
(statearr_71451[(6)] = c__2768__auto__);

return statearr_71451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

