// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__65456 = arguments.length;
switch (G__65456) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___65604 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65543){
var state_val_65544 = (state_65543[(1)]);
if((state_val_65544 === (7))){
var inst_65474 = (state_65543[(7)]);
var inst_65477 = cljs.core.not_EQ_.call(null,(0),inst_65474);
var state_65543__$1 = state_65543;
var statearr_65545_65605 = state_65543__$1;
(statearr_65545_65605[(2)] = inst_65477);

(statearr_65545_65605[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (20))){
var inst_65498 = (state_65543[(8)]);
var inst_65469 = (state_65543[(9)]);
var inst_65502 = fluree.db.auth.roles.call(null,inst_65469,inst_65498);
var state_65543__$1 = state_65543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65543__$1,(23),inst_65502);
} else {
if((state_val_65544 === (27))){
var inst_65469 = (state_65543[(9)]);
var inst_65517 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65518 = fluree.db.time_travel.as_of_block.call(null,inst_65469,inst_65517);
var state_65543__$1 = state_65543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65543__$1,(30),inst_65518);
} else {
if((state_val_65544 === (1))){
var state_65543__$1 = state_65543;
var statearr_65546_65606 = state_65543__$1;
(statearr_65546_65606[(2)] = null);

(statearr_65546_65606[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (24))){
var inst_65510 = (state_65543[(10)]);
var inst_65469 = (state_65543[(9)]);
var inst_65512 = fluree.db.permissions.permission_map.call(null,inst_65469,inst_65510,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65543__$1 = state_65543;
var statearr_65547_65607 = state_65543__$1;
(statearr_65547_65607[(2)] = inst_65512);

(statearr_65547_65607[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (4))){
var inst_65457 = (state_65543[(2)]);
var inst_65458 = cljs.core.async.put_BANG_.call(null,pc,inst_65457);
var inst_65459 = cljs.core.async.close_BANG_.call(null,pc);
var state_65543__$1 = (function (){var statearr_65548 = state_65543;
(statearr_65548[(11)] = inst_65458);

return statearr_65548;
})();
var statearr_65549_65608 = state_65543__$1;
(statearr_65549_65608[(2)] = inst_65459);

(statearr_65549_65608[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (15))){
var inst_65474 = (state_65543[(7)]);
var inst_65488 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65474)," unknown."].join('');
var inst_65489 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65490 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65491 = cljs.core.PersistentHashMap.fromArrays(inst_65489,inst_65490);
var inst_65492 = cljs.core.ex_info.call(null,inst_65488,inst_65491);
var inst_65493 = (function(){throw inst_65492})();
var state_65543__$1 = state_65543;
var statearr_65550_65609 = state_65543__$1;
(statearr_65550_65609[(2)] = inst_65493);

(statearr_65550_65609[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (21))){
var state_65543__$1 = state_65543;
var statearr_65551_65610 = state_65543__$1;
(statearr_65551_65610[(2)] = null);

(statearr_65551_65610[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (31))){
var inst_65524 = (state_65543[(12)]);
var inst_65474 = (state_65543[(7)]);
var inst_65526 = cljs.core.assoc.call(null,inst_65524,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65474);
var state_65543__$1 = state_65543;
var statearr_65552_65611 = state_65543__$1;
(statearr_65552_65611[(2)] = inst_65526);

(statearr_65552_65611[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (32))){
var inst_65524 = (state_65543[(12)]);
var state_65543__$1 = state_65543;
var statearr_65553_65612 = state_65543__$1;
(statearr_65553_65612[(2)] = inst_65524);

(statearr_65553_65612[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (33))){
var inst_65510 = (state_65543[(10)]);
var inst_65529 = (state_65543[(2)]);
var state_65543__$1 = (function (){var statearr_65554 = state_65543;
(statearr_65554[(13)] = inst_65529);

return statearr_65554;
})();
if(cljs.core.truth_(inst_65510)){
var statearr_65555_65613 = state_65543__$1;
(statearr_65555_65613[(1)] = (34));

} else {
var statearr_65556_65614 = state_65543__$1;
(statearr_65556_65614[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (13))){
var inst_65485 = (state_65543[(14)]);
var inst_65484 = (state_65543[(2)]);
var inst_65485__$1 = fluree.db.util.async.throw_err.call(null,inst_65484);
var state_65543__$1 = (function (){var statearr_65557 = state_65543;
(statearr_65557[(14)] = inst_65485__$1);

return statearr_65557;
})();
if(cljs.core.truth_(inst_65485__$1)){
var statearr_65558_65615 = state_65543__$1;
(statearr_65558_65615[(1)] = (14));

} else {
var statearr_65559_65616 = state_65543__$1;
(statearr_65559_65616[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (22))){
var inst_65508 = (state_65543[(2)]);
var state_65543__$1 = state_65543;
var statearr_65560_65617 = state_65543__$1;
(statearr_65560_65617[(2)] = inst_65508);

(statearr_65560_65617[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (36))){
var inst_65537 = (state_65543[(2)]);
var inst_65538 = cljs.core.async.put_BANG_.call(null,pc,inst_65537);
var _ = (function (){var statearr_65561 = state_65543;
(statearr_65561[(4)] = cljs.core.rest.call(null,(state_65543[(4)])));

return statearr_65561;
})();
var state_65543__$1 = state_65543;
var statearr_65562_65618 = state_65543__$1;
(statearr_65562_65618[(2)] = inst_65538);

(statearr_65562_65618[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (29))){
var inst_65474 = (state_65543[(7)]);
var inst_65524 = (state_65543[(2)]);
var state_65543__$1 = (function (){var statearr_65563 = state_65543;
(statearr_65563[(12)] = inst_65524);

return statearr_65563;
})();
if(cljs.core.truth_(inst_65474)){
var statearr_65564_65619 = state_65543__$1;
(statearr_65564_65619[(1)] = (31));

} else {
var statearr_65565_65620 = state_65543__$1;
(statearr_65565_65620[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (6))){
var inst_65474 = (state_65543[(7)]);
var inst_65468 = (state_65543[(2)]);
var inst_65469 = fluree.db.util.async.throw_err.call(null,inst_65468);
var inst_65470 = opts;
var inst_65471 = cljs.core.__destructure_map.call(null,inst_65470);
var inst_65472 = cljs.core.get.call(null,inst_65471,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_65473 = cljs.core.get.call(null,inst_65471,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_65474__$1 = cljs.core.get.call(null,inst_65471,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65475 = cljs.core.get.call(null,inst_65471,new cljs.core.Keyword(null,"block","block",664686210));
var state_65543__$1 = (function (){var statearr_65566 = state_65543;
(statearr_65566[(15)] = inst_65475);

(statearr_65566[(7)] = inst_65474__$1);

(statearr_65566[(9)] = inst_65469);

(statearr_65566[(16)] = inst_65472);

(statearr_65566[(17)] = inst_65473);

return statearr_65566;
})();
if(cljs.core.truth_(inst_65474__$1)){
var statearr_65567_65621 = state_65543__$1;
(statearr_65567_65621[(1)] = (7));

} else {
var statearr_65568_65622 = state_65543__$1;
(statearr_65568_65622[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (28))){
var inst_65469 = (state_65543[(9)]);
var state_65543__$1 = state_65543;
var statearr_65569_65623 = state_65543__$1;
(statearr_65569_65623[(2)] = inst_65469);

(statearr_65569_65623[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (25))){
var state_65543__$1 = state_65543;
var statearr_65570_65624 = state_65543__$1;
(statearr_65570_65624[(2)] = null);

(statearr_65570_65624[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (34))){
var inst_65515 = (state_65543[(18)]);
var state_65543__$1 = state_65543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65543__$1,(37),inst_65515);
} else {
if((state_val_65544 === (17))){
var inst_65472 = (state_65543[(16)]);
var state_65543__$1 = state_65543;
var statearr_65571_65625 = state_65543__$1;
(statearr_65571_65625[(2)] = inst_65472);

(statearr_65571_65625[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (3))){
var inst_65541 = (state_65543[(2)]);
var state_65543__$1 = state_65543;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65543__$1,inst_65541);
} else {
if((state_val_65544 === (12))){
var inst_65472 = (state_65543[(16)]);
var inst_65498 = (state_65543[(2)]);
var state_65543__$1 = (function (){var statearr_65572 = state_65543;
(statearr_65572[(8)] = inst_65498);

return statearr_65572;
})();
if(cljs.core.truth_(inst_65472)){
var statearr_65573_65626 = state_65543__$1;
(statearr_65573_65626[(1)] = (17));

} else {
var statearr_65574_65627 = state_65543__$1;
(statearr_65574_65627[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (2))){
var _ = (function (){var statearr_65575 = state_65543;
(statearr_65575[(4)] = cljs.core.cons.call(null,(5),(state_65543[(4)])));

return statearr_65575;
})();
var inst_65466 = fluree.db.session.db.call(null,conn,ledger,null);
var state_65543__$1 = state_65543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65543__$1,(6),inst_65466);
} else {
if((state_val_65544 === (23))){
var inst_65504 = (state_65543[(2)]);
var inst_65505 = fluree.db.util.async.throw_err.call(null,inst_65504);
var state_65543__$1 = state_65543;
var statearr_65576_65628 = state_65543__$1;
(statearr_65576_65628[(2)] = inst_65505);

(statearr_65576_65628[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (35))){
var inst_65529 = (state_65543[(13)]);
var state_65543__$1 = state_65543;
var statearr_65577_65629 = state_65543__$1;
(statearr_65577_65629[(2)] = inst_65529);

(statearr_65577_65629[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (19))){
var inst_65510 = (state_65543[(10)]);
var inst_65510__$1 = (state_65543[(2)]);
var state_65543__$1 = (function (){var statearr_65578 = state_65543;
(statearr_65578[(10)] = inst_65510__$1);

return statearr_65578;
})();
if(cljs.core.truth_(inst_65510__$1)){
var statearr_65579_65630 = state_65543__$1;
(statearr_65579_65630[(1)] = (24));

} else {
var statearr_65580_65631 = state_65543__$1;
(statearr_65580_65631[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (11))){
var state_65543__$1 = state_65543;
var statearr_65582_65632 = state_65543__$1;
(statearr_65582_65632[(2)] = null);

(statearr_65582_65632[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (9))){
var inst_65480 = (state_65543[(2)]);
var state_65543__$1 = state_65543;
if(cljs.core.truth_(inst_65480)){
var statearr_65583_65633 = state_65543__$1;
(statearr_65583_65633[(1)] = (10));

} else {
var statearr_65584_65634 = state_65543__$1;
(statearr_65584_65634[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (5))){
var _ = (function (){var statearr_65585 = state_65543;
(statearr_65585[(4)] = cljs.core.rest.call(null,(state_65543[(4)])));

return statearr_65585;
})();
var state_65543__$1 = state_65543;
var ex65581 = (state_65543__$1[(2)]);
var statearr_65586_65635 = state_65543__$1;
(statearr_65586_65635[(5)] = ex65581);


var statearr_65587_65636 = state_65543__$1;
(statearr_65587_65636[(1)] = (4));

(statearr_65587_65636[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (14))){
var inst_65485 = (state_65543[(14)]);
var state_65543__$1 = state_65543;
var statearr_65588_65637 = state_65543__$1;
(statearr_65588_65637[(2)] = inst_65485);

(statearr_65588_65637[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (26))){
var inst_65475 = (state_65543[(15)]);
var inst_65515 = (state_65543[(2)]);
var state_65543__$1 = (function (){var statearr_65589 = state_65543;
(statearr_65589[(18)] = inst_65515);

return statearr_65589;
})();
if(cljs.core.truth_(inst_65475)){
var statearr_65590_65638 = state_65543__$1;
(statearr_65590_65638[(1)] = (27));

} else {
var statearr_65591_65639 = state_65543__$1;
(statearr_65591_65639[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (16))){
var inst_65495 = (state_65543[(2)]);
var state_65543__$1 = state_65543;
var statearr_65592_65640 = state_65543__$1;
(statearr_65592_65640[(2)] = inst_65495);

(statearr_65592_65640[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (30))){
var inst_65520 = (state_65543[(2)]);
var inst_65521 = fluree.db.util.async.throw_err.call(null,inst_65520);
var state_65543__$1 = state_65543;
var statearr_65593_65641 = state_65543__$1;
(statearr_65593_65641[(2)] = inst_65521);

(statearr_65593_65641[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (10))){
var inst_65474 = (state_65543[(7)]);
var inst_65469 = (state_65543[(9)]);
var inst_65482 = fluree.db.dbproto._subid.call(null,inst_65469,inst_65474);
var state_65543__$1 = state_65543;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65543__$1,(13),inst_65482);
} else {
if((state_val_65544 === (18))){
var inst_65498 = (state_65543[(8)]);
var state_65543__$1 = state_65543;
if(cljs.core.truth_(inst_65498)){
var statearr_65594_65642 = state_65543__$1;
(statearr_65594_65642[(1)] = (20));

} else {
var statearr_65595_65643 = state_65543__$1;
(statearr_65595_65643[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (37))){
var inst_65529 = (state_65543[(13)]);
var inst_65532 = (state_65543[(2)]);
var inst_65533 = fluree.db.util.async.throw_err.call(null,inst_65532);
var inst_65534 = cljs.core.assoc.call(null,inst_65529,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65533);
var state_65543__$1 = state_65543;
var statearr_65596_65644 = state_65543__$1;
(statearr_65596_65644[(2)] = inst_65534);

(statearr_65596_65644[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65544 === (8))){
var inst_65474 = (state_65543[(7)]);
var state_65543__$1 = state_65543;
var statearr_65597_65645 = state_65543__$1;
(statearr_65597_65645[(2)] = inst_65474);

(statearr_65597_65645[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2746__auto__ = null;
var fluree$db$api$query$state_machine__2746__auto____0 = (function (){
var statearr_65598 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65598[(0)] = fluree$db$api$query$state_machine__2746__auto__);

(statearr_65598[(1)] = (1));

return statearr_65598;
});
var fluree$db$api$query$state_machine__2746__auto____1 = (function (state_65543){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65543);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65599){var ex__2749__auto__ = e65599;
var statearr_65600_65646 = state_65543;
(statearr_65600_65646[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65543[(4)]))){
var statearr_65601_65647 = state_65543;
(statearr_65601_65647[(1)] = cljs.core.first.call(null,(state_65543[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65648 = state_65543;
state_65543 = G__65648;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2746__auto__ = function(state_65543){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2746__auto____1.call(this,state_65543);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2746__auto____0;
fluree$db$api$query$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2746__auto____1;
return fluree$db$api$query$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65602 = f__2769__auto__.call(null);
(statearr_65602[(6)] = c__2768__auto___65604);

return statearr_65602;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_65789){
var state_val_65790 = (state_65789[(1)]);
if((state_val_65790 === (7))){
var inst_65669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65670 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65671 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65672 = [inst_65670,inst_65671];
var inst_65673 = (new cljs.core.PersistentVector(null,2,(5),inst_65669,inst_65672,null));
var state_65789__$1 = state_65789;
var statearr_65791_65861 = state_65789__$1;
(statearr_65791_65861[(2)] = inst_65673);

(statearr_65791_65861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (20))){
var inst_65699 = (state_65789[(7)]);
var state_65789__$1 = state_65789;
var statearr_65792_65862 = state_65789__$1;
(statearr_65792_65862[(2)] = inst_65699);

(statearr_65792_65862[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (27))){
var state_65789__$1 = state_65789;
var statearr_65793_65863 = state_65789__$1;
(statearr_65793_65863[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (1))){
var state_65789__$1 = state_65789;
var statearr_65795_65864 = state_65789__$1;
(statearr_65795_65864[(2)] = null);

(statearr_65795_65864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (24))){
var inst_65698 = (state_65789[(8)]);
var state_65789__$1 = state_65789;
if(cljs.core.truth_(inst_65698)){
var statearr_65796_65865 = state_65789__$1;
(statearr_65796_65865[(1)] = (26));

} else {
var statearr_65797_65866 = state_65789__$1;
(statearr_65797_65866[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (39))){
var inst_65745 = (state_65789[(9)]);
var inst_65744 = (state_65789[(10)]);
var inst_65770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65771 = [inst_65744,inst_65745];
var inst_65772 = (new cljs.core.PersistentVector(null,2,(5),inst_65770,inst_65771,null));
var state_65789__$1 = state_65789;
var statearr_65798_65867 = state_65789__$1;
(statearr_65798_65867[(2)] = inst_65772);

(statearr_65798_65867[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (4))){
var inst_65649 = (state_65789[(2)]);
var state_65789__$1 = state_65789;
var statearr_65799_65868 = state_65789__$1;
(statearr_65799_65868[(2)] = inst_65649);

(statearr_65799_65868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (15))){
var inst_65683 = (state_65789[(11)]);
var inst_65678 = (state_65789[(12)]);
var inst_65692 = (state_65789[(2)]);
var inst_65693 = [inst_65683,inst_65692];
var inst_65694 = (new cljs.core.PersistentVector(null,2,(5),inst_65678,inst_65693,null));
var state_65789__$1 = state_65789;
var statearr_65800_65869 = state_65789__$1;
(statearr_65800_65869[(2)] = inst_65694);

(statearr_65800_65869[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (21))){
var inst_65698 = (state_65789[(8)]);
var state_65789__$1 = state_65789;
var statearr_65801_65870 = state_65789__$1;
(statearr_65801_65870[(2)] = inst_65698);

(statearr_65801_65870[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (31))){
var inst_65739 = (state_65789[(2)]);
var state_65789__$1 = state_65789;
var statearr_65802_65871 = state_65789__$1;
(statearr_65802_65871[(2)] = inst_65739);

(statearr_65802_65871[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (32))){
var inst_65745 = (state_65789[(9)]);
var inst_65748 = cljs.core.pos_int_QMARK_.call(null,inst_65745);
var state_65789__$1 = state_65789;
var statearr_65803_65872 = state_65789__$1;
(statearr_65803_65872[(2)] = inst_65748);

(statearr_65803_65872[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (40))){
var inst_65700 = (state_65789[(13)]);
var inst_65776 = (state_65789[(14)]);
var inst_65774 = (state_65789[(2)]);
var inst_65775 = cljs.core.nth.call(null,inst_65774,(0),null);
var inst_65776__$1 = cljs.core.nth.call(null,inst_65774,(1),null);
var inst_65777 = (inst_65776__$1 > inst_65700);
var state_65789__$1 = (function (){var statearr_65804 = state_65789;
(statearr_65804[(15)] = inst_65775);

(statearr_65804[(14)] = inst_65776__$1);

return statearr_65804;
})();
if(cljs.core.truth_(inst_65777)){
var statearr_65805_65873 = state_65789__$1;
(statearr_65805_65873[(1)] = (41));

} else {
var statearr_65806_65874 = state_65789__$1;
(statearr_65806_65874[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (33))){
var inst_65746 = (state_65789[(16)]);
var state_65789__$1 = state_65789;
var statearr_65807_65875 = state_65789__$1;
(statearr_65807_65875[(2)] = inst_65746);

(statearr_65807_65875[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (13))){
var inst_65684 = (state_65789[(17)]);
var inst_65686 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_65684);
var state_65789__$1 = state_65789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65789__$1,(16),inst_65686);
} else {
if((state_val_65790 === (22))){
var inst_65717 = (state_65789[(2)]);
var state_65789__$1 = state_65789;
if(cljs.core.truth_(inst_65717)){
var statearr_65808_65876 = state_65789__$1;
(statearr_65808_65876[(1)] = (23));

} else {
var statearr_65809_65877 = state_65789__$1;
(statearr_65809_65877[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (36))){
var state_65789__$1 = state_65789;
var statearr_65810_65878 = state_65789__$1;
(statearr_65810_65878[(2)] = null);

(statearr_65810_65878[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (41))){
var inst_65700 = (state_65789[(13)]);
var state_65789__$1 = state_65789;
var statearr_65811_65879 = state_65789__$1;
(statearr_65811_65879[(2)] = inst_65700);

(statearr_65811_65879[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (43))){
var inst_65775 = (state_65789[(15)]);
var inst_65781 = (state_65789[(2)]);
var inst_65782 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65783 = [inst_65775,inst_65781];
var inst_65784 = (new cljs.core.PersistentVector(null,2,(5),inst_65782,inst_65783,null));
var _ = (function (){var statearr_65812 = state_65789;
(statearr_65812[(4)] = cljs.core.rest.call(null,(state_65789[(4)])));

return statearr_65812;
})();
var state_65789__$1 = state_65789;
var statearr_65813_65880 = state_65789__$1;
(statearr_65813_65880[(2)] = inst_65784);

(statearr_65813_65880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (29))){
var inst_65675 = (state_65789[(18)]);
var inst_65730 = cljs.core.pr_str.call(null,inst_65675);
var inst_65731 = ["Invalid block range provided: ",inst_65730].join('');
var inst_65732 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65733 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65734 = cljs.core.PersistentHashMap.fromArrays(inst_65732,inst_65733);
var inst_65735 = cljs.core.ex_info.call(null,inst_65731,inst_65734);
var inst_65736 = (function(){throw inst_65735})();
var state_65789__$1 = state_65789;
var statearr_65814_65881 = state_65789__$1;
(statearr_65814_65881[(2)] = inst_65736);

(statearr_65814_65881[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (6))){
var inst_65667 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65789__$1 = state_65789;
var statearr_65815_65882 = state_65789__$1;
(statearr_65815_65882[(2)] = inst_65667);

(statearr_65815_65882[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (28))){
var inst_65741 = (state_65789[(2)]);
var state_65789__$1 = state_65789;
var statearr_65816_65883 = state_65789__$1;
(statearr_65816_65883[(2)] = inst_65741);

(statearr_65816_65883[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (25))){
var inst_65746 = (state_65789[(16)]);
var inst_65744 = (state_65789[(10)]);
var inst_65743 = (state_65789[(2)]);
var inst_65744__$1 = cljs.core.nth.call(null,inst_65743,(0),null);
var inst_65745 = cljs.core.nth.call(null,inst_65743,(1),null);
var inst_65746__$1 = cljs.core.pos_int_QMARK_.call(null,inst_65744__$1);
var state_65789__$1 = (function (){var statearr_65817 = state_65789;
(statearr_65817[(9)] = inst_65745);

(statearr_65817[(16)] = inst_65746__$1);

(statearr_65817[(10)] = inst_65744__$1);

return statearr_65817;
})();
if(inst_65746__$1){
var statearr_65818_65884 = state_65789__$1;
(statearr_65818_65884[(1)] = (32));

} else {
var statearr_65819_65885 = state_65789__$1;
(statearr_65819_65885[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (34))){
var inst_65751 = (state_65789[(2)]);
var inst_65752 = cljs.core.not.call(null,inst_65751);
var state_65789__$1 = state_65789;
if(inst_65752){
var statearr_65820_65886 = state_65789__$1;
(statearr_65820_65886[(1)] = (35));

} else {
var statearr_65821_65887 = state_65789__$1;
(statearr_65821_65887[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (17))){
var inst_65700 = (state_65789[(13)]);
var inst_65698 = (state_65789[(8)]);
var inst_65703 = cljs.core.pr_str.call(null,inst_65698);
var inst_65704 = cljs.core.pr_str.call(null,inst_65700);
var inst_65705 = ["Start block is out of range for this ledger. Start block provided: ",inst_65703,". Database block: ",inst_65704].join('');
var inst_65706 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65707 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65708 = cljs.core.PersistentHashMap.fromArrays(inst_65706,inst_65707);
var inst_65709 = cljs.core.ex_info.call(null,inst_65705,inst_65708);
var inst_65710 = (function(){throw inst_65709})();
var state_65789__$1 = state_65789;
var statearr_65822_65888 = state_65789__$1;
(statearr_65822_65888[(2)] = inst_65710);

(statearr_65822_65888[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (3))){
var inst_65787 = (state_65789[(2)]);
var state_65789__$1 = state_65789;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_65789__$1,inst_65787);
} else {
if((state_val_65790 === (12))){
var inst_65684 = (state_65789[(17)]);
var inst_65675 = (state_65789[(18)]);
var inst_65682 = (state_65789[(2)]);
var inst_65683 = fluree.db.util.async.throw_err.call(null,inst_65682);
var inst_65684__$1 = cljs.core.second.call(null,inst_65675);
var state_65789__$1 = (function (){var statearr_65823 = state_65789;
(statearr_65823[(17)] = inst_65684__$1);

(statearr_65823[(11)] = inst_65683);

return statearr_65823;
})();
if(cljs.core.truth_(inst_65684__$1)){
var statearr_65824_65889 = state_65789__$1;
(statearr_65824_65889[(1)] = (13));

} else {
var statearr_65825_65890 = state_65789__$1;
(statearr_65825_65890[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (2))){
var _ = (function (){var statearr_65826 = state_65789;
(statearr_65826[(4)] = cljs.core.cons.call(null,(5),(state_65789[(4)])));

return statearr_65826;
})();
var inst_65664 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65665 = cljs.core.sequential_QMARK_.call(null,inst_65664);
var state_65789__$1 = state_65789;
if(inst_65665){
var statearr_65827_65891 = state_65789__$1;
(statearr_65827_65891[(1)] = (6));

} else {
var statearr_65828_65892 = state_65789__$1;
(statearr_65828_65892[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (23))){
var inst_65698 = (state_65789[(8)]);
var inst_65699 = (state_65789[(7)]);
var inst_65719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65720 = [inst_65698,inst_65699];
var inst_65721 = (new cljs.core.PersistentVector(null,2,(5),inst_65719,inst_65720,null));
var state_65789__$1 = state_65789;
var statearr_65829_65893 = state_65789__$1;
(statearr_65829_65893[(2)] = inst_65721);

(statearr_65829_65893[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (35))){
var inst_65675 = (state_65789[(18)]);
var inst_65754 = cljs.core.pr_str.call(null,inst_65675);
var inst_65755 = ["Invalid block range provided: ",inst_65754].join('');
var inst_65756 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65757 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65758 = cljs.core.PersistentHashMap.fromArrays(inst_65756,inst_65757);
var inst_65759 = cljs.core.ex_info.call(null,inst_65755,inst_65758);
var inst_65760 = (function(){throw inst_65759})();
var state_65789__$1 = state_65789;
var statearr_65830_65894 = state_65789__$1;
(statearr_65830_65894[(2)] = inst_65760);

(statearr_65830_65894[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (19))){
var inst_65698 = (state_65789[(8)]);
var inst_65713 = (state_65789[(2)]);
var state_65789__$1 = (function (){var statearr_65831 = state_65789;
(statearr_65831[(19)] = inst_65713);

return statearr_65831;
})();
if(cljs.core.truth_(inst_65698)){
var statearr_65832_65895 = state_65789__$1;
(statearr_65832_65895[(1)] = (20));

} else {
var statearr_65833_65896 = state_65789__$1;
(statearr_65833_65896[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (11))){
var inst_65700 = (state_65789[(13)]);
var inst_65698 = (state_65789[(8)]);
var inst_65697 = (state_65789[(2)]);
var inst_65698__$1 = cljs.core.nth.call(null,inst_65697,(0),null);
var inst_65699 = cljs.core.nth.call(null,inst_65697,(1),null);
var inst_65700__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65701 = (inst_65698__$1 > inst_65700__$1);
var state_65789__$1 = (function (){var statearr_65835 = state_65789;
(statearr_65835[(13)] = inst_65700__$1);

(statearr_65835[(8)] = inst_65698__$1);

(statearr_65835[(7)] = inst_65699);

return statearr_65835;
})();
if(cljs.core.truth_(inst_65701)){
var statearr_65836_65897 = state_65789__$1;
(statearr_65836_65897[(1)] = (17));

} else {
var statearr_65837_65898 = state_65789__$1;
(statearr_65837_65898[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (9))){
var inst_65675 = (state_65789[(18)]);
var inst_65678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65679 = cljs.core.first.call(null,inst_65675);
var inst_65680 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_65679);
var state_65789__$1 = (function (){var statearr_65838 = state_65789;
(statearr_65838[(12)] = inst_65678);

return statearr_65838;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_65789__$1,(12),inst_65680);
} else {
if((state_val_65790 === (5))){
var _ = (function (){var statearr_65839 = state_65789;
(statearr_65839[(4)] = cljs.core.rest.call(null,(state_65789[(4)])));

return statearr_65839;
})();
var state_65789__$1 = state_65789;
var ex65834 = (state_65789__$1[(2)]);
var statearr_65840_65899 = state_65789__$1;
(statearr_65840_65899[(5)] = ex65834);


if((ex65834 instanceof Error)){
var statearr_65841_65900 = state_65789__$1;
(statearr_65841_65900[(1)] = (4));

(statearr_65841_65900[(5)] = null);

} else {
throw ex65834;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (14))){
var state_65789__$1 = state_65789;
var statearr_65842_65901 = state_65789__$1;
(statearr_65842_65901[(2)] = null);

(statearr_65842_65901[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (26))){
var inst_65698 = (state_65789[(8)]);
var inst_65724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65725 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65726 = [inst_65698,inst_65725];
var inst_65727 = (new cljs.core.PersistentVector(null,2,(5),inst_65724,inst_65726,null));
var state_65789__$1 = state_65789;
var statearr_65843_65902 = state_65789__$1;
(statearr_65843_65902[(2)] = inst_65727);

(statearr_65843_65902[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (16))){
var inst_65688 = (state_65789[(2)]);
var inst_65689 = fluree.db.util.async.throw_err.call(null,inst_65688);
var state_65789__$1 = state_65789;
var statearr_65844_65903 = state_65789__$1;
(statearr_65844_65903[(2)] = inst_65689);

(statearr_65844_65903[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (38))){
var inst_65745 = (state_65789[(9)]);
var inst_65744 = (state_65789[(10)]);
var inst_65766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65767 = [inst_65745,inst_65744];
var inst_65768 = (new cljs.core.PersistentVector(null,2,(5),inst_65766,inst_65767,null));
var state_65789__$1 = state_65789;
var statearr_65845_65904 = state_65789__$1;
(statearr_65845_65904[(2)] = inst_65768);

(statearr_65845_65904[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (30))){
var state_65789__$1 = state_65789;
var statearr_65846_65905 = state_65789__$1;
(statearr_65846_65905[(2)] = null);

(statearr_65846_65905[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (10))){
var inst_65675 = (state_65789[(18)]);
var state_65789__$1 = state_65789;
var statearr_65847_65906 = state_65789__$1;
(statearr_65847_65906[(2)] = inst_65675);

(statearr_65847_65906[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (18))){
var state_65789__$1 = state_65789;
var statearr_65848_65907 = state_65789__$1;
(statearr_65848_65907[(2)] = null);

(statearr_65848_65907[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (42))){
var inst_65776 = (state_65789[(14)]);
var state_65789__$1 = state_65789;
var statearr_65849_65908 = state_65789__$1;
(statearr_65849_65908[(2)] = inst_65776);

(statearr_65849_65908[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (37))){
var inst_65745 = (state_65789[(9)]);
var inst_65744 = (state_65789[(10)]);
var inst_65763 = (state_65789[(2)]);
var inst_65764 = (inst_65745 < inst_65744);
var state_65789__$1 = (function (){var statearr_65850 = state_65789;
(statearr_65850[(20)] = inst_65763);

return statearr_65850;
})();
if(cljs.core.truth_(inst_65764)){
var statearr_65851_65909 = state_65789__$1;
(statearr_65851_65909[(1)] = (38));

} else {
var statearr_65852_65910 = state_65789__$1;
(statearr_65852_65910[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65790 === (8))){
var inst_65675 = (state_65789[(18)]);
var inst_65675__$1 = (state_65789[(2)]);
var inst_65676 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_65675__$1);
var state_65789__$1 = (function (){var statearr_65853 = state_65789;
(statearr_65853[(18)] = inst_65675__$1);

return statearr_65853;
})();
if(cljs.core.truth_(inst_65676)){
var statearr_65854_65911 = state_65789__$1;
(statearr_65854_65911[(1)] = (9));

} else {
var statearr_65855_65912 = state_65789__$1;
(statearr_65855_65912[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0 = (function (){
var statearr_65856 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65856[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__);

(statearr_65856[(1)] = (1));

return statearr_65856;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1 = (function (state_65789){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_65789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e65857){var ex__2749__auto__ = e65857;
var statearr_65858_65913 = state_65789;
(statearr_65858_65913[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_65789[(4)]))){
var statearr_65859_65914 = state_65789;
(statearr_65859_65914[(1)] = cljs.core.first.call(null,(state_65789[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65915 = state_65789;
state_65789 = G__65915;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__ = function(state_65789){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1.call(this,state_65789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_65860 = f__2769__auto__.call(null);
(statearr_65860[(6)] = c__2768__auto__);

return statearr_65860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66065){
var state_val_66066 = (state_66065[(1)]);
if((state_val_66066 === (7))){
var inst_65977 = (state_66065[(2)]);
var inst_65978 = cljs.core.nth.call(null,inst_65977,(0),null);
var inst_65979 = cljs.core.nth.call(null,inst_65977,(1),null);
var inst_65987 = cljs.core.vals.call(null,inst_65979);
var inst_65988 = cljs.core.seq.call(null,inst_65987);
var inst_65989 = cljs.core.first.call(null,inst_65988);
var inst_65990 = cljs.core.next.call(null,inst_65988);
var inst_65991 = cljs.core.PersistentVector.EMPTY;
var inst_65992 = inst_65987;
var inst_65993 = inst_65991;
var state_66065__$1 = (function (){var statearr_66067 = state_66065;
(statearr_66067[(7)] = inst_65990);

(statearr_66067[(8)] = inst_65993);

(statearr_66067[(9)] = inst_65978);

(statearr_66067[(10)] = inst_65992);

(statearr_66067[(11)] = inst_65989);

return statearr_66067;
})();
var statearr_66068_66121 = state_66065__$1;
(statearr_66068_66121[(2)] = null);

(statearr_66068_66121[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (20))){
var inst_65999 = (state_66065[(12)]);
var inst_66004 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66005 = cljs.core.PersistentHashMap.EMPTY;
var inst_66006 = [true,inst_66005];
var inst_66007 = cljs.core.PersistentHashMap.fromArrays(inst_66004,inst_66006);
var inst_66008 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_66007,inst_65999);
var state_66065__$1 = state_66065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66065__$1,(22),inst_66008);
} else {
if((state_val_66066 === (27))){
var inst_66053 = (state_66065[(2)]);
var state_66065__$1 = state_66065;
var statearr_66069_66122 = state_66065__$1;
(statearr_66069_66122[(2)] = inst_66053);

(statearr_66069_66122[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (1))){
var state_66065__$1 = state_66065;
var statearr_66070_66123 = state_66065__$1;
(statearr_66070_66123[(2)] = null);

(statearr_66070_66123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (24))){
var inst_66017 = (state_66065[(13)]);
var inst_66055 = (state_66065[(2)]);
var inst_66056 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_66057 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66058 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66059 = [inst_66057,inst_66058,inst_66017,inst_66055];
var inst_66060 = cljs.core.PersistentHashMap.fromArrays(inst_66056,inst_66059);
var _ = (function (){var statearr_66072 = state_66065;
(statearr_66072[(4)] = cljs.core.rest.call(null,(state_66065[(4)])));

return statearr_66072;
})();
var state_66065__$1 = state_66065;
var statearr_66073_66124 = state_66065__$1;
(statearr_66073_66124[(2)] = inst_66060);

(statearr_66073_66124[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (4))){
var inst_65918 = (state_66065[(2)]);
var state_66065__$1 = state_66065;
var statearr_66074_66125 = state_66065__$1;
(statearr_66074_66125[(2)] = inst_65918);

(statearr_66074_66125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (15))){
var inst_65958 = (state_66065[(14)]);
var inst_65941 = (state_66065[(15)]);
var inst_65949 = (state_66065[(16)]);
var inst_65936 = (state_66065[(17)]);
var inst_65937 = (state_66065[(18)]);
var inst_65956 = (state_66065[(19)]);
var inst_65948 = (state_66065[(20)]);
var inst_65942 = (state_66065[(21)]);
var inst_65934 = (state_66065[(22)]);
var inst_65940 = (state_66065[(23)]);
var inst_65963 = (state_66065[(24)]);
var inst_65969 = (function (){var subject = inst_65956;
var flake = inst_65948;
var vec__65944 = inst_65940;
var r = inst_65949;
var asserted_subjects = inst_65941;
var first__65946 = inst_65948;
var flake_SINGLEQUOTE_ = inst_65963;
var retracted_subjects = inst_65942;
var vec__65931 = inst_65934;
var first__65933 = inst_65936;
var seq__65932 = inst_65937;
var G__65930 = inst_65940;
var seq__65945 = inst_65949;
var asserted_QMARK_ = inst_65958;
return (function (p1__65917_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__65917_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_65970 = cljs.core.update.call(null,inst_65942,inst_65956,inst_65969);
var tmp66071 = inst_65941;
var inst_65940__$1 = inst_65949;
var inst_65941__$1 = tmp66071;
var inst_65942__$1 = inst_65970;
var state_66065__$1 = (function (){var statearr_66075 = state_66065;
(statearr_66075[(15)] = inst_65941__$1);

(statearr_66075[(21)] = inst_65942__$1);

(statearr_66075[(23)] = inst_65940__$1);

return statearr_66075;
})();
var statearr_66076_66126 = state_66065__$1;
(statearr_66076_66126[(2)] = null);

(statearr_66076_66126[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (21))){
var inst_66015 = (state_66065[(2)]);
var state_66065__$1 = state_66065;
var statearr_66077_66127 = state_66065__$1;
(statearr_66077_66127[(2)] = inst_66015);

(statearr_66077_66127[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (13))){
var inst_65958 = (state_66065[(14)]);
var inst_65963 = (state_66065[(2)]);
var state_66065__$1 = (function (){var statearr_66078 = state_66065;
(statearr_66078[(24)] = inst_65963);

return statearr_66078;
})();
if(cljs.core.truth_(inst_65958)){
var statearr_66079_66128 = state_66065__$1;
(statearr_66079_66128[(1)] = (14));

} else {
var statearr_66080_66129 = state_66065__$1;
(statearr_66080_66129[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (22))){
var inst_66000 = (state_66065[(25)]);
var inst_65993 = (state_66065[(8)]);
var inst_66010 = (state_66065[(2)]);
var inst_66011 = fluree.db.util.async.throw_err.call(null,inst_66010);
var inst_66012 = cljs.core.conj.call(null,inst_65993,inst_66011);
var inst_65992 = inst_66000;
var inst_65993__$1 = inst_66012;
var state_66065__$1 = (function (){var statearr_66081 = state_66065;
(statearr_66081[(8)] = inst_65993__$1);

(statearr_66081[(10)] = inst_65992);

return statearr_66081;
})();
var statearr_66082_66130 = state_66065__$1;
(statearr_66082_66130[(2)] = null);

(statearr_66082_66130[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (6))){
var inst_65948 = (state_66065[(20)]);
var inst_65940 = (state_66065[(23)]);
var inst_65947 = cljs.core.seq.call(null,inst_65940);
var inst_65948__$1 = cljs.core.first.call(null,inst_65947);
var inst_65949 = cljs.core.next.call(null,inst_65947);
var inst_65950 = cljs.core.not.call(null,inst_65948__$1);
var state_66065__$1 = (function (){var statearr_66083 = state_66065;
(statearr_66083[(16)] = inst_65949);

(statearr_66083[(20)] = inst_65948__$1);

return statearr_66083;
})();
if(inst_65950){
var statearr_66084_66131 = state_66065__$1;
(statearr_66084_66131[(1)] = (8));

} else {
var statearr_66085_66132 = state_66065__$1;
(statearr_66085_66132[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (28))){
var inst_66038 = (state_66065[(26)]);
var inst_66031 = (state_66065[(27)]);
var inst_66048 = (state_66065[(2)]);
var inst_66049 = fluree.db.util.async.throw_err.call(null,inst_66048);
var inst_66050 = cljs.core.conj.call(null,inst_66031,inst_66049);
var inst_66030 = inst_66038;
var inst_66031__$1 = inst_66050;
var state_66065__$1 = (function (){var statearr_66086 = state_66065;
(statearr_66086[(28)] = inst_66030);

(statearr_66086[(27)] = inst_66031__$1);

return statearr_66086;
})();
var statearr_66087_66133 = state_66065__$1;
(statearr_66087_66133[(2)] = null);

(statearr_66087_66133[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (25))){
var inst_66031 = (state_66065[(27)]);
var state_66065__$1 = state_66065;
var statearr_66088_66134 = state_66065__$1;
(statearr_66088_66134[(2)] = inst_66031);

(statearr_66088_66134[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (17))){
var inst_65999 = (state_66065[(12)]);
var inst_65992 = (state_66065[(10)]);
var inst_65998 = cljs.core.seq.call(null,inst_65992);
var inst_65999__$1 = cljs.core.first.call(null,inst_65998);
var inst_66000 = cljs.core.next.call(null,inst_65998);
var inst_66001 = cljs.core.not.call(null,inst_65999__$1);
var state_66065__$1 = (function (){var statearr_66089 = state_66065;
(statearr_66089[(25)] = inst_66000);

(statearr_66089[(12)] = inst_65999__$1);

return statearr_66089;
})();
if(inst_66001){
var statearr_66090_66135 = state_66065__$1;
(statearr_66090_66135[(1)] = (19));

} else {
var statearr_66091_66136 = state_66065__$1;
(statearr_66091_66136[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (3))){
var inst_66063 = (state_66065[(2)]);
var state_66065__$1 = state_66065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66065__$1,inst_66063);
} else {
if((state_val_66066 === (12))){
var inst_65948 = (state_66065[(20)]);
var inst_65961 = fluree.db.flake.flip_flake.call(null,inst_65948);
var state_66065__$1 = state_66065;
var statearr_66092_66137 = state_66065__$1;
(statearr_66092_66137[(2)] = inst_65961);

(statearr_66092_66137[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (2))){
var inst_65934 = (state_66065[(22)]);
var _ = (function (){var statearr_66093 = state_66065;
(statearr_66093[(4)] = cljs.core.cons.call(null,(5),(state_66065[(4)])));

return statearr_66093;
})();
var inst_65934__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_65935 = cljs.core.seq.call(null,inst_65934__$1);
var inst_65936 = cljs.core.first.call(null,inst_65935);
var inst_65937 = cljs.core.next.call(null,inst_65935);
var inst_65938 = cljs.core.PersistentHashMap.EMPTY;
var inst_65939 = cljs.core.PersistentHashMap.EMPTY;
var inst_65940 = inst_65934__$1;
var inst_65941 = inst_65938;
var inst_65942 = inst_65939;
var state_66065__$1 = (function (){var statearr_66094 = state_66065;
(statearr_66094[(15)] = inst_65941);

(statearr_66094[(17)] = inst_65936);

(statearr_66094[(18)] = inst_65937);

(statearr_66094[(21)] = inst_65942);

(statearr_66094[(22)] = inst_65934__$1);

(statearr_66094[(23)] = inst_65940);

return statearr_66094;
})();
var statearr_66095_66138 = state_66065__$1;
(statearr_66095_66138[(2)] = null);

(statearr_66095_66138[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (23))){
var inst_66030 = (state_66065[(28)]);
var inst_66037 = (state_66065[(29)]);
var inst_66036 = cljs.core.seq.call(null,inst_66030);
var inst_66037__$1 = cljs.core.first.call(null,inst_66036);
var inst_66038 = cljs.core.next.call(null,inst_66036);
var inst_66039 = cljs.core.not.call(null,inst_66037__$1);
var state_66065__$1 = (function (){var statearr_66096 = state_66065;
(statearr_66096[(26)] = inst_66038);

(statearr_66096[(29)] = inst_66037__$1);

return statearr_66096;
})();
if(inst_66039){
var statearr_66097_66139 = state_66065__$1;
(statearr_66097_66139[(1)] = (25));

} else {
var statearr_66098_66140 = state_66065__$1;
(statearr_66098_66140[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (19))){
var inst_65993 = (state_66065[(8)]);
var state_66065__$1 = state_66065;
var statearr_66099_66141 = state_66065__$1;
(statearr_66099_66141[(2)] = inst_65993);

(statearr_66099_66141[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (11))){
var inst_65948 = (state_66065[(20)]);
var state_66065__$1 = state_66065;
var statearr_66101_66142 = state_66065__$1;
(statearr_66101_66142[(2)] = inst_65948);

(statearr_66101_66142[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (9))){
var inst_65958 = (state_66065[(14)]);
var inst_65948 = (state_66065[(20)]);
var inst_65956 = fluree.db.flake.s.call(null,inst_65948);
var inst_65957 = fluree.db.flake.op.call(null,inst_65948);
var inst_65958__$1 = inst_65957 === true;
var state_66065__$1 = (function (){var statearr_66103 = state_66065;
(statearr_66103[(14)] = inst_65958__$1);

(statearr_66103[(19)] = inst_65956);

return statearr_66103;
})();
if(cljs.core.truth_(inst_65958__$1)){
var statearr_66104_66143 = state_66065__$1;
(statearr_66104_66143[(1)] = (11));

} else {
var statearr_66105_66144 = state_66065__$1;
(statearr_66105_66144[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (5))){
var _ = (function (){var statearr_66106 = state_66065;
(statearr_66106[(4)] = cljs.core.rest.call(null,(state_66065[(4)])));

return statearr_66106;
})();
var state_66065__$1 = state_66065;
var ex66100 = (state_66065__$1[(2)]);
var statearr_66107_66145 = state_66065__$1;
(statearr_66107_66145[(5)] = ex66100);


if((ex66100 instanceof Error)){
var statearr_66108_66146 = state_66065__$1;
(statearr_66108_66146[(1)] = (4));

(statearr_66108_66146[(5)] = null);

} else {
throw ex66100;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (14))){
var inst_65958 = (state_66065[(14)]);
var inst_65941 = (state_66065[(15)]);
var inst_65949 = (state_66065[(16)]);
var inst_65936 = (state_66065[(17)]);
var inst_65937 = (state_66065[(18)]);
var inst_65956 = (state_66065[(19)]);
var inst_65948 = (state_66065[(20)]);
var inst_65942 = (state_66065[(21)]);
var inst_65934 = (state_66065[(22)]);
var inst_65940 = (state_66065[(23)]);
var inst_65963 = (state_66065[(24)]);
var inst_65965 = (function (){var subject = inst_65956;
var flake = inst_65948;
var vec__65944 = inst_65940;
var r = inst_65949;
var asserted_subjects = inst_65941;
var first__65946 = inst_65948;
var flake_SINGLEQUOTE_ = inst_65963;
var retracted_subjects = inst_65942;
var vec__65931 = inst_65934;
var first__65933 = inst_65936;
var seq__65932 = inst_65937;
var G__65930 = inst_65940;
var seq__65945 = inst_65949;
var asserted_QMARK_ = inst_65958;
return (function (p1__65916_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__65916_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_65966 = cljs.core.update.call(null,inst_65941,inst_65956,inst_65965);
var tmp66102 = inst_65942;
var inst_65940__$1 = inst_65949;
var inst_65941__$1 = inst_65966;
var inst_65942__$1 = tmp66102;
var state_66065__$1 = (function (){var statearr_66109 = state_66065;
(statearr_66109[(15)] = inst_65941__$1);

(statearr_66109[(21)] = inst_65942__$1);

(statearr_66109[(23)] = inst_65940__$1);

return statearr_66109;
})();
var statearr_66110_66147 = state_66065__$1;
(statearr_66110_66147[(2)] = null);

(statearr_66110_66147[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (26))){
var inst_66037 = (state_66065[(29)]);
var inst_66042 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66043 = cljs.core.PersistentHashMap.EMPTY;
var inst_66044 = [true,inst_66043];
var inst_66045 = cljs.core.PersistentHashMap.fromArrays(inst_66042,inst_66044);
var inst_66046 = fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_66045,inst_66037);
var state_66065__$1 = state_66065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66065__$1,(28),inst_66046);
} else {
if((state_val_66066 === (16))){
var inst_65973 = (state_66065[(2)]);
var state_66065__$1 = state_66065;
var statearr_66111_66148 = state_66065__$1;
(statearr_66111_66148[(2)] = inst_65973);

(statearr_66111_66148[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (10))){
var inst_65975 = (state_66065[(2)]);
var state_66065__$1 = state_66065;
var statearr_66112_66149 = state_66065__$1;
(statearr_66112_66149[(2)] = inst_65975);

(statearr_66112_66149[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (18))){
var inst_65978 = (state_66065[(9)]);
var inst_66017 = (state_66065[(2)]);
var inst_66025 = cljs.core.vals.call(null,inst_65978);
var inst_66026 = cljs.core.seq.call(null,inst_66025);
var inst_66027 = cljs.core.first.call(null,inst_66026);
var inst_66028 = cljs.core.next.call(null,inst_66026);
var inst_66029 = cljs.core.PersistentVector.EMPTY;
var inst_66030 = inst_66025;
var inst_66031 = inst_66029;
var state_66065__$1 = (function (){var statearr_66113 = state_66065;
(statearr_66113[(28)] = inst_66030);

(statearr_66113[(30)] = inst_66028);

(statearr_66113[(31)] = inst_66027);

(statearr_66113[(13)] = inst_66017);

(statearr_66113[(27)] = inst_66031);

return statearr_66113;
})();
var statearr_66114_66150 = state_66065__$1;
(statearr_66114_66150[(2)] = null);

(statearr_66114_66150[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66066 === (8))){
var inst_65941 = (state_66065[(15)]);
var inst_65942 = (state_66065[(21)]);
var inst_65952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65953 = [inst_65941,inst_65942];
var inst_65954 = (new cljs.core.PersistentVector(null,2,(5),inst_65952,inst_65953,null));
var state_66065__$1 = state_66065;
var statearr_66115_66151 = state_66065__$1;
(statearr_66115_66151[(2)] = inst_65954);

(statearr_66115_66151[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_66116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66116[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__);

(statearr_66116[(1)] = (1));

return statearr_66116;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1 = (function (state_66065){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66117){var ex__2749__auto__ = e66117;
var statearr_66118_66152 = state_66065;
(statearr_66118_66152[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66065[(4)]))){
var statearr_66119_66153 = state_66065;
(statearr_66119_66153[(1)] = cljs.core.first.call(null,(state_66065[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66154 = state_66065;
state_66065 = G__66154;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__ = function(state_66065){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1.call(this,state_66065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66120 = f__2769__auto__.call(null);
(statearr_66120[(6)] = c__2768__auto__);

return statearr_66120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66186){
var state_val_66187 = (state_66186[(1)]);
if((state_val_66187 === (1))){
var inst_66155 = cljs.core.volatile_BANG_.call(null,(0));
var inst_66156 = cljs.core.PersistentHashMap.EMPTY;
var inst_66157 = cljs.core.volatile_BANG_.call(null,inst_66156);
var inst_66158 = cljs.core.first.call(null,resp);
var inst_66159 = cljs.core.rest.call(null,resp);
var inst_66160 = cljs.core.PersistentVector.EMPTY;
var inst_66161 = inst_66155;
var inst_66162 = inst_66157;
var inst_66163 = inst_66158;
var inst_66164 = inst_66159;
var inst_66165 = inst_66160;
var state_66186__$1 = (function (){var statearr_66188 = state_66186;
(statearr_66188[(7)] = inst_66161);

(statearr_66188[(8)] = inst_66165);

(statearr_66188[(9)] = inst_66164);

(statearr_66188[(10)] = inst_66163);

(statearr_66188[(11)] = inst_66162);

return statearr_66188;
})();
var statearr_66189_66204 = state_66186__$1;
(statearr_66189_66204[(2)] = null);

(statearr_66189_66204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66187 === (2))){
var inst_66161 = (state_66186[(7)]);
var inst_66163 = (state_66186[(10)]);
var inst_66162 = (state_66186[(11)]);
var inst_66167 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_66163,inst_66162,inst_66161);
var state_66186__$1 = state_66186;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66186__$1,(4),inst_66167);
} else {
if((state_val_66187 === (3))){
var inst_66184 = (state_66186[(2)]);
var state_66186__$1 = state_66186;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66186__$1,inst_66184);
} else {
if((state_val_66187 === (4))){
var inst_66165 = (state_66186[(8)]);
var inst_66164 = (state_66186[(9)]);
var inst_66169 = (state_66186[(2)]);
var inst_66170 = fluree.db.util.async.throw_err.call(null,inst_66169);
var inst_66171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66172 = [inst_66170];
var inst_66173 = (new cljs.core.PersistentVector(null,1,(5),inst_66171,inst_66172,null));
var inst_66174 = cljs.core.concat.call(null,inst_66165,inst_66173);
var inst_66175 = cljs.core.first.call(null,inst_66164);
var state_66186__$1 = (function (){var statearr_66192 = state_66186;
(statearr_66192[(12)] = inst_66174);

return statearr_66192;
})();
if(cljs.core.truth_(inst_66175)){
var statearr_66193_66205 = state_66186__$1;
(statearr_66193_66205[(1)] = (5));

} else {
var statearr_66194_66206 = state_66186__$1;
(statearr_66194_66206[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66187 === (5))){
var inst_66174 = (state_66186[(12)]);
var inst_66161 = (state_66186[(7)]);
var inst_66164 = (state_66186[(9)]);
var inst_66162 = (state_66186[(11)]);
var inst_66177 = cljs.core.first.call(null,inst_66164);
var inst_66178 = cljs.core.rest.call(null,inst_66164);
var tmp66190 = inst_66161;
var tmp66191 = inst_66162;
var inst_66161__$1 = tmp66190;
var inst_66162__$1 = tmp66191;
var inst_66163 = inst_66177;
var inst_66164__$1 = inst_66178;
var inst_66165 = inst_66174;
var state_66186__$1 = (function (){var statearr_66195 = state_66186;
(statearr_66195[(7)] = inst_66161__$1);

(statearr_66195[(8)] = inst_66165);

(statearr_66195[(9)] = inst_66164__$1);

(statearr_66195[(10)] = inst_66163);

(statearr_66195[(11)] = inst_66162__$1);

return statearr_66195;
})();
var statearr_66196_66207 = state_66186__$1;
(statearr_66196_66207[(2)] = null);

(statearr_66196_66207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66187 === (6))){
var inst_66174 = (state_66186[(12)]);
var state_66186__$1 = state_66186;
var statearr_66197_66208 = state_66186__$1;
(statearr_66197_66208[(2)] = inst_66174);

(statearr_66197_66208[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66187 === (7))){
var inst_66182 = (state_66186[(2)]);
var state_66186__$1 = state_66186;
var statearr_66198_66209 = state_66186__$1;
(statearr_66198_66209[(2)] = inst_66182);

(statearr_66198_66209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0 = (function (){
var statearr_66199 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66199[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__);

(statearr_66199[(1)] = (1));

return statearr_66199;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1 = (function (state_66186){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66186);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66200){var ex__2749__auto__ = e66200;
var statearr_66201_66210 = state_66186;
(statearr_66201_66210[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66186[(4)]))){
var statearr_66202_66211 = state_66186;
(statearr_66202_66211[(1)] = cljs.core.first.call(null,(state_66186[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66212 = state_66186;
state_66186 = G__66212;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__ = function(state_66186){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1.call(this,state_66186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66203 = f__2769__auto__.call(null);
(statearr_66203[(6)] = c__2768__auto__);

return statearr_66203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__66214 = arguments.length;
switch (G__66214) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__66216){
var map__66217 = p__66216;
var map__66217__$1 = cljs.core.__destructure_map.call(null,map__66217);
var query = map__66217__$1;
var opts = cljs.core.get.call(null,map__66217__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66302){
var state_val_66303 = (state_66302[(1)]);
if((state_val_66303 === (7))){
var inst_66228 = (state_66302[(7)]);
var inst_66232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66233 = ["_auth/id",inst_66228];
var inst_66234 = (new cljs.core.PersistentVector(null,2,(5),inst_66232,inst_66233,null));
var state_66302__$1 = state_66302;
var statearr_66304_66348 = state_66302__$1;
(statearr_66304_66348[(2)] = inst_66234);

(statearr_66304_66348[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (20))){
var inst_66282 = (state_66302[(2)]);
var inst_66283 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_66302__$1 = (function (){var statearr_66305 = state_66302;
(statearr_66305[(8)] = inst_66282);

return statearr_66305;
})();
if(cljs.core.truth_(inst_66283)){
var statearr_66306_66349 = state_66302__$1;
(statearr_66306_66349[(1)] = (22));

} else {
var statearr_66307_66350 = state_66302__$1;
(statearr_66307_66350[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (27))){
var inst_66285 = (state_66302[(9)]);
var inst_66229 = (state_66302[(10)]);
var inst_66291 = (state_66302[(2)]);
var inst_66292 = fluree.db.util.core.response_time_formatted.call(null,inst_66229);
var inst_66293 = [(200),inst_66291,(100),inst_66292];
var inst_66294 = cljs.core.PersistentHashMap.fromArrays(inst_66285,inst_66293);
var state_66302__$1 = state_66302;
var statearr_66308_66351 = state_66302__$1;
(statearr_66308_66351[(2)] = inst_66294);

(statearr_66308_66351[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (1))){
var state_66302__$1 = state_66302;
var statearr_66309_66352 = state_66302__$1;
(statearr_66309_66352[(2)] = null);

(statearr_66309_66352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (24))){
var inst_66297 = (state_66302[(2)]);
var _ = (function (){var statearr_66310 = state_66302;
(statearr_66310[(4)] = cljs.core.rest.call(null,(state_66302[(4)])));

return statearr_66310;
})();
var state_66302__$1 = state_66302;
var statearr_66311_66353 = state_66302__$1;
(statearr_66311_66353[(2)] = inst_66297);

(statearr_66311_66353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (4))){
var inst_66218 = (state_66302[(2)]);
var state_66302__$1 = state_66302;
var statearr_66312_66354 = state_66302__$1;
(statearr_66312_66354[(2)] = inst_66218);

(statearr_66312_66354[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (15))){
var inst_66269 = (state_66302[(11)]);
var state_66302__$1 = state_66302;
var statearr_66313_66355 = state_66302__$1;
(statearr_66313_66355[(2)] = inst_66269);

(statearr_66313_66355[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (21))){
var inst_66278 = (state_66302[(2)]);
var inst_66279 = fluree.db.util.async.throw_err.call(null,inst_66278);
var state_66302__$1 = state_66302;
var statearr_66314_66356 = state_66302__$1;
(statearr_66314_66356[(2)] = inst_66279);

(statearr_66314_66356[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (13))){
var inst_66227 = (state_66302[(12)]);
var inst_66269 = (state_66302[(11)]);
var inst_66268 = (state_66302[(2)]);
var inst_66269__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_66227);
var state_66302__$1 = (function (){var statearr_66315 = state_66302;
(statearr_66315[(13)] = inst_66268);

(statearr_66315[(11)] = inst_66269__$1);

return statearr_66315;
})();
if(cljs.core.truth_(inst_66269__$1)){
var statearr_66316_66357 = state_66302__$1;
(statearr_66316_66357[(1)] = (15));

} else {
var statearr_66317_66358 = state_66302__$1;
(statearr_66317_66358[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (22))){
var inst_66282 = (state_66302[(8)]);
var inst_66285 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_66286 = cljs.core.sequential_QMARK_.call(null,inst_66282);
var state_66302__$1 = (function (){var statearr_66318 = state_66302;
(statearr_66318[(9)] = inst_66285);

return statearr_66318;
})();
if(inst_66286){
var statearr_66319_66359 = state_66302__$1;
(statearr_66319_66359[(1)] = (25));

} else {
var statearr_66320_66360 = state_66302__$1;
(statearr_66320_66360[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (6))){
var inst_66227 = (state_66302[(12)]);
var inst_66243 = (state_66302[(14)]);
var inst_66242 = (state_66302[(2)]);
var inst_66243__$1 = fluree.db.util.async.throw_err.call(null,inst_66242);
var inst_66244 = fluree.db.api.query.resolve_block_range.call(null,inst_66243__$1,inst_66227);
var state_66302__$1 = (function (){var statearr_66321 = state_66302;
(statearr_66321[(14)] = inst_66243__$1);

return statearr_66321;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66302__$1,(10),inst_66244);
} else {
if((state_val_66303 === (25))){
var inst_66282 = (state_66302[(8)]);
var inst_66288 = cljs.core.doall.call(null,inst_66282);
var state_66302__$1 = state_66302;
var statearr_66322_66361 = state_66302__$1;
(statearr_66322_66361[(2)] = inst_66288);

(statearr_66322_66361[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (17))){
var inst_66274 = (state_66302[(2)]);
var state_66302__$1 = state_66302;
if(cljs.core.truth_(inst_66274)){
var statearr_66323_66362 = state_66302__$1;
(statearr_66323_66362[(1)] = (18));

} else {
var statearr_66324_66363 = state_66302__$1;
(statearr_66324_66363[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (3))){
var inst_66300 = (state_66302[(2)]);
var state_66302__$1 = state_66302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66302__$1,inst_66300);
} else {
if((state_val_66303 === (12))){
var inst_66227 = (state_66302[(12)]);
var inst_66260 = cljs.core.pr_str.call(null,inst_66227);
var inst_66261 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_66260].join('');
var inst_66262 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66263 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66264 = cljs.core.PersistentHashMap.fromArrays(inst_66262,inst_66263);
var inst_66265 = cljs.core.ex_info.call(null,inst_66261,inst_66264);
var inst_66266 = (function(){throw inst_66265})();
var state_66302__$1 = state_66302;
var statearr_66325_66364 = state_66302__$1;
(statearr_66325_66364[(2)] = inst_66266);

(statearr_66325_66364[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (2))){
var inst_66228 = (state_66302[(7)]);
var _ = (function (){var statearr_66326 = state_66302;
(statearr_66326[(4)] = cljs.core.cons.call(null,(5),(state_66302[(4)])));

return statearr_66326;
})();
var inst_66227 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_66228__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66229 = fluree.db.util.core.current_time_millis.call(null);
var inst_66230 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_66302__$1 = (function (){var statearr_66327 = state_66302;
(statearr_66327[(15)] = inst_66230);

(statearr_66327[(7)] = inst_66228__$1);

(statearr_66327[(12)] = inst_66227);

(statearr_66327[(10)] = inst_66229);

return statearr_66327;
})();
if(cljs.core.truth_(inst_66228__$1)){
var statearr_66328_66365 = state_66302__$1;
(statearr_66328_66365[(1)] = (7));

} else {
var statearr_66329_66366 = state_66302__$1;
(statearr_66329_66366[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (23))){
var inst_66282 = (state_66302[(8)]);
var state_66302__$1 = state_66302;
var statearr_66330_66367 = state_66302__$1;
(statearr_66330_66367[(2)] = inst_66282);

(statearr_66330_66367[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (19))){
var inst_66268 = (state_66302[(13)]);
var state_66302__$1 = state_66302;
var statearr_66331_66368 = state_66302__$1;
(statearr_66331_66368[(2)] = inst_66268);

(statearr_66331_66368[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (11))){
var inst_66248 = (state_66302[(16)]);
var inst_66249 = (state_66302[(17)]);
var inst_66243 = (state_66302[(14)]);
var inst_66255 = fluree.db.api.query.block_range.call(null,inst_66243,inst_66248,inst_66249,opts);
var state_66302__$1 = state_66302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66302__$1,(14),inst_66255);
} else {
if((state_val_66303 === (9))){
var inst_66230 = (state_66302[(15)]);
var inst_66237 = (state_66302[(2)]);
var inst_66238 = [inst_66237];
var inst_66239 = cljs.core.PersistentHashMap.fromArrays(inst_66230,inst_66238);
var inst_66240 = fluree.db.api.query.db.call(null,conn,ledger,inst_66239);
var state_66302__$1 = state_66302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66302__$1,(6),inst_66240);
} else {
if((state_val_66303 === (5))){
var _ = (function (){var statearr_66333 = state_66302;
(statearr_66333[(4)] = cljs.core.rest.call(null,(state_66302[(4)])));

return statearr_66333;
})();
var state_66302__$1 = state_66302;
var ex66332 = (state_66302__$1[(2)]);
var statearr_66334_66369 = state_66302__$1;
(statearr_66334_66369[(5)] = ex66332);


if((ex66332 instanceof Error)){
var statearr_66335_66370 = state_66302__$1;
(statearr_66335_66370[(1)] = (4));

(statearr_66335_66370[(5)] = null);

} else {
throw ex66332;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (14))){
var inst_66257 = (state_66302[(2)]);
var inst_66258 = fluree.db.util.async.throw_err.call(null,inst_66257);
var state_66302__$1 = state_66302;
var statearr_66336_66371 = state_66302__$1;
(statearr_66336_66371[(2)] = inst_66258);

(statearr_66336_66371[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (26))){
var inst_66282 = (state_66302[(8)]);
var state_66302__$1 = state_66302;
var statearr_66337_66372 = state_66302__$1;
(statearr_66337_66372[(2)] = inst_66282);

(statearr_66337_66372[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (16))){
var inst_66227 = (state_66302[(12)]);
var inst_66272 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_66227);
var state_66302__$1 = state_66302;
var statearr_66338_66373 = state_66302__$1;
(statearr_66338_66373[(2)] = inst_66272);

(statearr_66338_66373[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (10))){
var inst_66227 = (state_66302[(12)]);
var inst_66246 = (state_66302[(2)]);
var inst_66247 = fluree.db.util.async.throw_err.call(null,inst_66246);
var inst_66248 = cljs.core.nth.call(null,inst_66247,(0),null);
var inst_66249 = cljs.core.nth.call(null,inst_66247,(1),null);
var inst_66250 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_66251 = cljs.core.dissoc.call(null,inst_66227,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_66252 = cljs.core.keys.call(null,inst_66251);
var inst_66253 = cljs.core._EQ_.call(null,inst_66250,inst_66252);
var state_66302__$1 = (function (){var statearr_66339 = state_66302;
(statearr_66339[(16)] = inst_66248);

(statearr_66339[(17)] = inst_66249);

return statearr_66339;
})();
if(inst_66253){
var statearr_66340_66374 = state_66302__$1;
(statearr_66340_66374[(1)] = (11));

} else {
var statearr_66341_66375 = state_66302__$1;
(statearr_66341_66375[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66303 === (18))){
var inst_66268 = (state_66302[(13)]);
var inst_66243 = (state_66302[(14)]);
var inst_66276 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_66243,inst_66268);
var state_66302__$1 = state_66302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66302__$1,(21),inst_66276);
} else {
if((state_val_66303 === (8))){
var state_66302__$1 = state_66302;
var statearr_66342_66376 = state_66302__$1;
(statearr_66342_66376[(2)] = null);

(statearr_66342_66376[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_66343 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66343[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2746__auto__);

(statearr_66343[(1)] = (1));

return statearr_66343;
});
var fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1 = (function (state_66302){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66344){var ex__2749__auto__ = e66344;
var statearr_66345_66377 = state_66302;
(statearr_66345_66377[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66302[(4)]))){
var statearr_66346_66378 = state_66302;
(statearr_66346_66378[(1)] = cljs.core.first.call(null,(state_66302[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66379 = state_66302;
state_66302 = G__66379;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__ = function(state_66302){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1.call(this,state_66302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66347 = f__2769__auto__.call(null);
(statearr_66347[(6)] = c__2768__auto__);

return statearr_66347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__66380 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__66380,(0),null);
var p = cljs.core.nth.call(null,vec__66380,(1),null);
var o = cljs.core.nth.call(null,vec__66380,(2),null);
var t = cljs.core.nth.call(null,vec__66380,(3),null);
var vec__66383 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__66383,(0),null);
var idx = cljs.core.nth.call(null,vec__66383,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__66386 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t.call(null,flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__66386,(0),null);
var id = cljs.core.nth.call(null,vec__66386,(1),null);
var or__5045__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66390 = arguments.length;
var i__5770__auto___66391 = (0);
while(true){
if((i__5770__auto___66391 < len__5769__auto___66390)){
args__5775__auto__.push((arguments[i__5770__auto___66391]));

var G__66392 = (i__5770__auto___66391 + (1));
i__5770__auto___66391 = G__66392;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq66389){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq66389));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66588){
var state_val_66589 = (state_66588[(1)]);
if((state_val_66589 === (7))){
var inst_66508 = (state_66588[(7)]);
var inst_66515 = (state_66588[(8)]);
var inst_66514 = cljs.core.seq.call(null,inst_66508);
var inst_66515__$1 = cljs.core.first.call(null,inst_66514);
var inst_66516 = cljs.core.next.call(null,inst_66514);
var state_66588__$1 = (function (){var statearr_66590 = state_66588;
(statearr_66590[(8)] = inst_66515__$1);

(statearr_66590[(9)] = inst_66516);

return statearr_66590;
})();
if(cljs.core.truth_(inst_66515__$1)){
var statearr_66591_66691 = state_66588__$1;
(statearr_66591_66691[(1)] = (9));

} else {
var statearr_66592_66692 = state_66588__$1;
(statearr_66592_66692[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (20))){
var inst_66578 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66593_66693 = state_66588__$1;
(statearr_66593_66693[(2)] = inst_66578);

(statearr_66593_66693[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (27))){
var inst_66533 = (state_66588[(10)]);
var inst_66536 = (state_66588[(11)]);
var inst_66554 = (state_66588[(12)]);
var inst_66556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66557 = [inst_66536,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_66558 = (new cljs.core.PersistentVector(null,2,(5),inst_66556,inst_66557,null));
var inst_66559 = cljs.core.update_in.call(null,inst_66554,inst_66558,fluree.db.api.query.min_safe,inst_66533);
var state_66588__$1 = state_66588;
var statearr_66594_66694 = state_66588__$1;
(statearr_66594_66694[(2)] = inst_66559);

(statearr_66594_66694[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (1))){
var state_66588__$1 = state_66588;
var statearr_66595_66695 = state_66588__$1;
(statearr_66595_66695[(2)] = null);

(statearr_66595_66695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (24))){
var inst_66546 = (state_66588[(13)]);
var inst_66536 = (state_66588[(11)]);
var inst_66515 = (state_66588[(8)]);
var inst_66548 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66549 = [inst_66536,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_66550 = (new cljs.core.PersistentVector(null,2,(5),inst_66548,inst_66549,null));
var inst_66551 = cljs.core.update_in.call(null,inst_66546,inst_66550,cljs.core.conj,inst_66515);
var state_66588__$1 = state_66588;
var statearr_66597_66696 = state_66588__$1;
(statearr_66597_66696[(2)] = inst_66551);

(statearr_66597_66696[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (4))){
var inst_66394 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66598_66697 = state_66588__$1;
(statearr_66598_66697[(2)] = inst_66394);

(statearr_66598_66697[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (15))){
var inst_66509 = (state_66588[(14)]);
var inst_66516 = (state_66588[(9)]);
var tmp66596 = inst_66509;
var inst_66508 = inst_66516;
var inst_66509__$1 = tmp66596;
var state_66588__$1 = (function (){var statearr_66599 = state_66588;
(statearr_66599[(7)] = inst_66508);

(statearr_66599[(14)] = inst_66509__$1);

return statearr_66599;
})();
var statearr_66600_66698 = state_66588__$1;
(statearr_66600_66698[(2)] = null);

(statearr_66600_66698[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (21))){
var inst_66536 = (state_66588[(11)]);
var inst_66509 = (state_66588[(14)]);
var inst_66540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66541 = [inst_66536,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66542 = (new cljs.core.PersistentVector(null,2,(5),inst_66540,inst_66541,null));
var inst_66543 = cljs.core.assoc_in.call(null,inst_66509,inst_66542,inst_66536);
var state_66588__$1 = state_66588;
var statearr_66601_66699 = state_66588__$1;
(statearr_66601_66699[(2)] = inst_66543);

(statearr_66601_66699[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (31))){
var inst_66562 = (state_66588[(15)]);
var state_66588__$1 = state_66588;
var statearr_66602_66700 = state_66588__$1;
(statearr_66602_66700[(2)] = inst_66562);

(statearr_66602_66700[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (32))){
var inst_66516 = (state_66588[(9)]);
var inst_66570 = (state_66588[(2)]);
var inst_66508 = inst_66516;
var inst_66509 = inst_66570;
var state_66588__$1 = (function (){var statearr_66603 = state_66588;
(statearr_66603[(7)] = inst_66508);

(statearr_66603[(14)] = inst_66509);

return statearr_66603;
})();
var statearr_66604_66701 = state_66588__$1;
(statearr_66604_66701[(2)] = null);

(statearr_66604_66701[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (33))){
var inst_66509 = (state_66588[(14)]);
var state_66588__$1 = state_66588;
var statearr_66605_66702 = state_66588__$1;
(statearr_66605_66702[(2)] = inst_66509);

(statearr_66605_66702[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (13))){
var inst_66518 = (state_66588[(16)]);
var state_66588__$1 = state_66588;
var statearr_66606_66703 = state_66588__$1;
(statearr_66606_66703[(2)] = inst_66518);

(statearr_66606_66703[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (22))){
var inst_66509 = (state_66588[(14)]);
var state_66588__$1 = state_66588;
var statearr_66607_66704 = state_66588__$1;
(statearr_66607_66704[(2)] = inst_66509);

(statearr_66607_66704[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (29))){
var inst_66562 = (state_66588[(2)]);
var state_66588__$1 = (function (){var statearr_66608 = state_66588;
(statearr_66608[(15)] = inst_66562);

return statearr_66608;
})();
if(cljs.core.truth_(show_auth)){
var statearr_66609_66705 = state_66588__$1;
(statearr_66609_66705[(1)] = (30));

} else {
var statearr_66610_66706 = state_66588__$1;
(statearr_66610_66706[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (6))){
var inst_66494 = (state_66588[(2)]);
var inst_66495 = fluree.db.util.async.throw_err.call(null,inst_66494);
var inst_66503 = resp;
var inst_66504 = cljs.core.seq.call(null,inst_66503);
var inst_66505 = cljs.core.first.call(null,inst_66504);
var inst_66506 = cljs.core.next.call(null,inst_66504);
var inst_66507 = cljs.core.PersistentHashMap.EMPTY;
var inst_66508 = inst_66503;
var inst_66509 = inst_66507;
var state_66588__$1 = (function (){var statearr_66611 = state_66588;
(statearr_66611[(7)] = inst_66508);

(statearr_66611[(17)] = inst_66505);

(statearr_66611[(14)] = inst_66509);

(statearr_66611[(18)] = inst_66506);

(statearr_66611[(19)] = inst_66495);

return statearr_66611;
})();
var statearr_66612_66707 = state_66588__$1;
(statearr_66612_66707[(2)] = null);

(statearr_66612_66707[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (28))){
var inst_66554 = (state_66588[(12)]);
var state_66588__$1 = state_66588;
var statearr_66613_66708 = state_66588__$1;
(statearr_66613_66708[(2)] = inst_66554);

(statearr_66613_66708[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (25))){
var inst_66546 = (state_66588[(13)]);
var state_66588__$1 = state_66588;
var statearr_66614_66709 = state_66588__$1;
(statearr_66614_66709[(2)] = inst_66546);

(statearr_66614_66709[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (34))){
var state_66588__$1 = state_66588;
var statearr_66615_66710 = state_66588__$1;
(statearr_66615_66710[(2)] = null);

(statearr_66615_66710[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (17))){
var inst_66580 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66616_66711 = state_66588__$1;
(statearr_66616_66711[(2)] = inst_66580);

(statearr_66616_66711[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (3))){
var inst_66586 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66588__$1,inst_66586);
} else {
if((state_val_66589 === (12))){
var inst_66515 = (state_66588[(8)]);
var inst_66495 = (state_66588[(19)]);
var inst_66520 = fluree.db.api.query.auth_match.call(null,auth,inst_66495,inst_66515);
var inst_66521 = cljs.core.not.call(null,inst_66520);
var state_66588__$1 = state_66588;
var statearr_66617_66712 = state_66588__$1;
(statearr_66617_66712[(2)] = inst_66521);

(statearr_66617_66712[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (2))){
var _ = (function (){var statearr_66618 = state_66588;
(statearr_66618[(4)] = cljs.core.cons.call(null,(5),(state_66588[(4)])));

return statearr_66618;
})();
var inst_66400 = (function (){return (function (p1__66393_SHARP_){
return fluree.db.flake.t.call(null,p1__66393_SHARP_);
});
})();
var inst_66401 = cljs.core.map.call(null,inst_66400,resp);
var inst_66402 = cljs.core.set.call(null,inst_66401);
var inst_66490 = cljs.core.async.chan.call(null,(1));
var inst_66491 = (function (){var ts = inst_66402;
var c__2768__auto____$1 = inst_66490;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66488){
var state_val_66489 = (state_66488[(1)]);
if((state_val_66489 === (7))){
var inst_66434 = (state_66488[(7)]);
var inst_66428 = (state_66488[(8)]);
var inst_66422 = (state_66488[(9)]);
var inst_66416 = (state_66488[(10)]);
var inst_66427 = (state_66488[(2)]);
var inst_66428__$1 = fluree.db.util.async.throw_err.call(null,inst_66427);
var inst_66430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66431 = [inst_66422,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66432 = (new cljs.core.PersistentVector(null,2,(5),inst_66430,inst_66431,null));
var inst_66433 = cljs.core.assoc_in.call(null,inst_66416,inst_66432,inst_66428__$1);
var inst_66434__$1 = auth;
var state_66488__$1 = (function (){var statearr_66619 = state_66488;
(statearr_66619[(7)] = inst_66434__$1);

(statearr_66619[(8)] = inst_66428__$1);

(statearr_66619[(11)] = inst_66433);

return statearr_66619;
})();
if(cljs.core.truth_(inst_66434__$1)){
var statearr_66620_66713 = state_66488__$1;
(statearr_66620_66713[(1)] = (8));

} else {
var statearr_66621_66714 = state_66488__$1;
(statearr_66621_66714[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (1))){
var inst_66410 = (state_66488[(12)]);
var inst_66410__$1 = ts;
var inst_66411 = cljs.core.seq.call(null,inst_66410__$1);
var inst_66412 = cljs.core.first.call(null,inst_66411);
var inst_66413 = cljs.core.next.call(null,inst_66411);
var inst_66414 = cljs.core.PersistentHashMap.EMPTY;
var inst_66415 = inst_66410__$1;
var inst_66416 = inst_66414;
var state_66488__$1 = (function (){var statearr_66622 = state_66488;
(statearr_66622[(12)] = inst_66410__$1);

(statearr_66622[(13)] = inst_66415);

(statearr_66622[(14)] = inst_66412);

(statearr_66622[(15)] = inst_66413);

(statearr_66622[(10)] = inst_66416);

return statearr_66622;
})();
var statearr_66623_66715 = state_66488__$1;
(statearr_66623_66715[(2)] = null);

(statearr_66623_66715[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (4))){
var inst_66422 = (state_66488[(9)]);
var inst_66425 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_66422);
var state_66488__$1 = state_66488;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66488__$1,(7),inst_66425);
} else {
if((state_val_66489 === (13))){
var inst_66423 = (state_66488[(16)]);
var inst_66480 = (state_66488[(2)]);
var inst_66415 = inst_66423;
var inst_66416 = inst_66480;
var state_66488__$1 = (function (){var statearr_66624 = state_66488;
(statearr_66624[(13)] = inst_66415);

(statearr_66624[(10)] = inst_66416);

return statearr_66624;
})();
var statearr_66625_66716 = state_66488__$1;
(statearr_66625_66716[(2)] = null);

(statearr_66625_66716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (6))){
var inst_66484 = (state_66488[(2)]);
var state_66488__$1 = state_66488;
var statearr_66626_66717 = state_66488__$1;
(statearr_66626_66717[(2)] = inst_66484);

(statearr_66626_66717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (3))){
var inst_66486 = (state_66488[(2)]);
var state_66488__$1 = state_66488;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66488__$1,inst_66486);
} else {
if((state_val_66489 === (12))){
var inst_66433 = (state_66488[(11)]);
var state_66488__$1 = state_66488;
var statearr_66627_66718 = state_66488__$1;
(statearr_66627_66718[(2)] = inst_66433);

(statearr_66627_66718[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (2))){
var inst_66415 = (state_66488[(13)]);
var inst_66422 = (state_66488[(9)]);
var inst_66421 = cljs.core.seq.call(null,inst_66415);
var inst_66422__$1 = cljs.core.first.call(null,inst_66421);
var inst_66423 = cljs.core.next.call(null,inst_66421);
var state_66488__$1 = (function (){var statearr_66628 = state_66488;
(statearr_66628[(16)] = inst_66423);

(statearr_66628[(9)] = inst_66422__$1);

return statearr_66628;
})();
if(cljs.core.truth_(inst_66422__$1)){
var statearr_66629_66719 = state_66488__$1;
(statearr_66629_66719[(1)] = (4));

} else {
var statearr_66630_66720 = state_66488__$1;
(statearr_66630_66720[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (11))){
var inst_66423 = (state_66488[(16)]);
var inst_66428 = (state_66488[(8)]);
var inst_66410 = (state_66488[(12)]);
var inst_66415 = (state_66488[(13)]);
var inst_66433 = (state_66488[(11)]);
var inst_66422 = (state_66488[(9)]);
var inst_66412 = (state_66488[(14)]);
var inst_66413 = (state_66488[(15)]);
var inst_66416 = (state_66488[(10)]);
var inst_66440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66441 = [inst_66422,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66442 = (new cljs.core.PersistentVector(null,2,(5),inst_66440,inst_66441,null));
var inst_66455 = cljs.core.async.chan.call(null,(1));
var inst_66456 = (function (){var seq__66419 = inst_66423;
var t = inst_66422;
var vec__66407 = inst_66410;
var first__66420 = inst_66422;
var first__66409 = inst_66412;
var block = inst_66428;
var r = inst_66423;
var seq__66408 = inst_66413;
var vec__66418 = inst_66415;
var G__66406 = inst_66415;
var acc = inst_66416;
var c__2768__auto____$2 = inst_66455;
var G__66429 = inst_66433;
return (function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66453){
var state_val_66454 = (state_66453[(1)]);
if((state_val_66454 === (1))){
var state_66453__$1 = state_66453;
var statearr_66631_66721 = state_66453__$1;
(statearr_66631_66721[(2)] = null);

(statearr_66631_66721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66454 === (2))){
var ___$1 = (function (){var statearr_66632 = state_66453;
(statearr_66632[(4)] = cljs.core.cons.call(null,(5),(state_66453[(4)])));

return statearr_66632;
})();
var ___$2 = (function (){var statearr_66633 = state_66453;
(statearr_66633[(4)] = cljs.core.rest.call(null,(state_66453[(4)])));

return statearr_66633;
})();
var state_66453__$1 = state_66453;
var statearr_66634_66722 = state_66453__$1;
(statearr_66634_66722[(2)] = db);

(statearr_66634_66722[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66454 === (3))){
var inst_66451 = (state_66453[(2)]);
var state_66453__$1 = state_66453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66453__$1,inst_66451);
} else {
if((state_val_66454 === (4))){
var inst_66443 = (state_66453[(2)]);
var state_66453__$1 = state_66453;
var statearr_66636_66723 = state_66453__$1;
(statearr_66636_66723[(2)] = inst_66443);

(statearr_66636_66723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66454 === (5))){
var ___$1 = (function (){var statearr_66637 = state_66453;
(statearr_66637[(4)] = cljs.core.rest.call(null,(state_66453[(4)])));

return statearr_66637;
})();
var state_66453__$1 = state_66453;
var ex66635 = (state_66453__$1[(2)]);
var statearr_66638_66724 = state_66453__$1;
(statearr_66638_66724[(5)] = ex66635);


if((ex66635 instanceof Error)){
var statearr_66639_66725 = state_66453__$1;
(statearr_66639_66725[(1)] = (4));

(statearr_66639_66725[(5)] = null);

} else {
throw ex66635;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_66640 = [null,null,null,null,null,null,null];
(statearr_66640[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_66640[(1)] = (1));

return statearr_66640;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_66453){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66641){var ex__2749__auto__ = e66641;
var statearr_66642_66726 = state_66453;
(statearr_66642_66726[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66453[(4)]))){
var statearr_66643_66727 = state_66453;
(statearr_66643_66727[(1)] = cljs.core.first.call(null,(state_66453[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66728 = state_66453;
state_66453 = G__66728;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_66453){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_66453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66644 = f__2769__auto__.call(null);
(statearr_66644[(6)] = c__2768__auto____$2);

return statearr_66644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_66457 = cljs.core.async.impl.dispatch.run.call(null,inst_66456);
var inst_66458 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_66459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66460 = ["?auth","?id"];
var inst_66461 = (new cljs.core.PersistentVector(null,2,(5),inst_66459,inst_66460,null));
var inst_66462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66464 = [inst_66422,"_tx/auth","?auth"];
var inst_66465 = (new cljs.core.PersistentVector(null,3,(5),inst_66463,inst_66464,null));
var inst_66466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66467 = ["?auth","_auth/id","?id"];
var inst_66468 = (new cljs.core.PersistentVector(null,3,(5),inst_66466,inst_66467,null));
var inst_66469 = [inst_66465,inst_66468];
var inst_66470 = (new cljs.core.PersistentVector(null,2,(5),inst_66462,inst_66469,null));
var inst_66471 = [inst_66461,inst_66470];
var inst_66472 = cljs.core.PersistentHashMap.fromArrays(inst_66458,inst_66471);
var inst_66473 = fluree.db.api.query.query_async.call(null,inst_66455,inst_66472);
var state_66488__$1 = (function (){var statearr_66645 = state_66488;
(statearr_66645[(17)] = inst_66442);

(statearr_66645[(18)] = inst_66457);

return statearr_66645;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66488__$1,(14),inst_66473);
} else {
if((state_val_66489 === (9))){
var state_66488__$1 = state_66488;
var statearr_66646_66729 = state_66488__$1;
(statearr_66646_66729[(2)] = show_auth);

(statearr_66646_66729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (5))){
var inst_66416 = (state_66488[(10)]);
var state_66488__$1 = state_66488;
var statearr_66647_66730 = state_66488__$1;
(statearr_66647_66730[(2)] = inst_66416);

(statearr_66647_66730[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (14))){
var inst_66442 = (state_66488[(17)]);
var inst_66433 = (state_66488[(11)]);
var inst_66475 = (state_66488[(2)]);
var inst_66476 = fluree.db.util.async.throw_err.call(null,inst_66475);
var inst_66477 = cljs.core.assoc_in.call(null,inst_66433,inst_66442,inst_66476);
var state_66488__$1 = state_66488;
var statearr_66648_66731 = state_66488__$1;
(statearr_66648_66731[(2)] = inst_66477);

(statearr_66648_66731[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (10))){
var inst_66438 = (state_66488[(2)]);
var state_66488__$1 = state_66488;
if(cljs.core.truth_(inst_66438)){
var statearr_66649_66732 = state_66488__$1;
(statearr_66649_66732[(1)] = (11));

} else {
var statearr_66650_66733 = state_66488__$1;
(statearr_66650_66733[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66489 === (8))){
var inst_66434 = (state_66488[(7)]);
var state_66488__$1 = state_66488;
var statearr_66651_66734 = state_66488__$1;
(statearr_66651_66734[(2)] = inst_66434);

(statearr_66651_66734[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_66652 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66652[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_66652[(1)] = (1));

return statearr_66652;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_66488){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66488);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66653){var ex__2749__auto__ = e66653;
var statearr_66654_66735 = state_66488;
(statearr_66654_66735[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66488[(4)]))){
var statearr_66655_66736 = state_66488;
(statearr_66655_66736[(1)] = cljs.core.first.call(null,(state_66488[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66737 = state_66488;
state_66488 = G__66737;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_66488){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_66488);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66656 = f__2769__auto__.call(null);
(statearr_66656[(6)] = c__2768__auto____$1);

return statearr_66656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
});
})();
var inst_66492 = cljs.core.async.impl.dispatch.run.call(null,inst_66491);
var state_66588__$1 = (function (){var statearr_66657 = state_66588;
(statearr_66657[(20)] = inst_66492);

return statearr_66657;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66588__$1,(6),inst_66490);
} else {
if((state_val_66589 === (23))){
var inst_66546 = (state_66588[(2)]);
var state_66588__$1 = (function (){var statearr_66658 = state_66588;
(statearr_66658[(13)] = inst_66546);

return statearr_66658;
})();
var statearr_66659_66738 = state_66588__$1;
(statearr_66659_66738[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (35))){
var inst_66576 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66661_66739 = state_66588__$1;
(statearr_66661_66739[(2)] = inst_66576);

(statearr_66661_66739[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (19))){
var state_66588__$1 = state_66588;
var statearr_66662_66740 = state_66588__$1;
(statearr_66662_66740[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (11))){
var inst_66527 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
if(cljs.core.truth_(inst_66527)){
var statearr_66665_66741 = state_66588__$1;
(statearr_66665_66741[(1)] = (15));

} else {
var statearr_66666_66742 = state_66588__$1;
(statearr_66666_66742[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (9))){
var inst_66518 = (state_66588[(16)]);
var inst_66518__$1 = auth;
var state_66588__$1 = (function (){var statearr_66667 = state_66588;
(statearr_66667[(16)] = inst_66518__$1);

return statearr_66667;
})();
if(cljs.core.truth_(inst_66518__$1)){
var statearr_66668_66743 = state_66588__$1;
(statearr_66668_66743[(1)] = (12));

} else {
var statearr_66669_66744 = state_66588__$1;
(statearr_66669_66744[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (5))){
var _ = (function (){var statearr_66670 = state_66588;
(statearr_66670[(4)] = cljs.core.rest.call(null,(state_66588[(4)])));

return statearr_66670;
})();
var state_66588__$1 = state_66588;
var ex66664 = (state_66588__$1[(2)]);
var statearr_66671_66745 = state_66588__$1;
(statearr_66671_66745[(5)] = ex66664);


if((ex66664 instanceof Error)){
var statearr_66672_66746 = state_66588__$1;
(statearr_66672_66746[(1)] = (4));

(statearr_66672_66746[(5)] = null);

} else {
throw ex66664;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (14))){
var inst_66524 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66673_66747 = state_66588__$1;
(statearr_66673_66747[(2)] = inst_66524);

(statearr_66673_66747[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (26))){
var inst_66554 = (state_66588[(2)]);
var state_66588__$1 = (function (){var statearr_66674 = state_66588;
(statearr_66674[(12)] = inst_66554);

return statearr_66674;
})();
var statearr_66675_66748 = state_66588__$1;
(statearr_66675_66748[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (16))){
var inst_66515 = (state_66588[(8)]);
var state_66588__$1 = state_66588;
if(cljs.core.truth_(inst_66515)){
var statearr_66677_66749 = state_66588__$1;
(statearr_66677_66749[(1)] = (18));

} else {
var statearr_66678_66750 = state_66588__$1;
(statearr_66678_66750[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (30))){
var inst_66537 = (state_66588[(21)]);
var inst_66536 = (state_66588[(11)]);
var inst_66562 = (state_66588[(15)]);
var inst_66564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66565 = [inst_66536,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66566 = (new cljs.core.PersistentVector(null,2,(5),inst_66564,inst_66565,null));
var inst_66567 = cljs.core.assoc_in.call(null,inst_66562,inst_66566,inst_66537);
var state_66588__$1 = state_66588;
var statearr_66679_66751 = state_66588__$1;
(statearr_66679_66751[(2)] = inst_66567);

(statearr_66679_66751[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (10))){
var inst_66515 = (state_66588[(8)]);
var state_66588__$1 = state_66588;
var statearr_66680_66752 = state_66588__$1;
(statearr_66680_66752[(2)] = inst_66515);

(statearr_66680_66752[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (18))){
var inst_66533 = (state_66588[(10)]);
var inst_66515 = (state_66588[(8)]);
var inst_66495 = (state_66588[(19)]);
var inst_66533__$1 = fluree.db.flake.t.call(null,inst_66515);
var inst_66534 = cljs.core.get.call(null,inst_66495,inst_66533__$1);
var inst_66535 = cljs.core.__destructure_map.call(null,inst_66534);
var inst_66536 = cljs.core.get.call(null,inst_66535,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66537 = cljs.core.get.call(null,inst_66535,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_66588__$1 = (function (){var statearr_66681 = state_66588;
(statearr_66681[(10)] = inst_66533__$1);

(statearr_66681[(21)] = inst_66537);

(statearr_66681[(11)] = inst_66536);

return statearr_66681;
})();
var statearr_66682_66753 = state_66588__$1;
(statearr_66682_66753[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (8))){
var inst_66582 = (state_66588[(2)]);
var inst_66583 = cljs.core.vals.call(null,inst_66582);
var _ = (function (){var statearr_66684 = state_66588;
(statearr_66684[(4)] = cljs.core.rest.call(null,(state_66588[(4)])));

return statearr_66684;
})();
var state_66588__$1 = state_66588;
var statearr_66685_66754 = state_66588__$1;
(statearr_66685_66754[(2)] = inst_66583);

(statearr_66685_66754[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0 = (function (){
var statearr_66686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66686[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__);

(statearr_66686[(1)] = (1));

return statearr_66686;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1 = (function (state_66588){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66588);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66687){var ex__2749__auto__ = e66687;
var statearr_66688_66755 = state_66588;
(statearr_66688_66755[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66588[(4)]))){
var statearr_66689_66756 = state_66588;
(statearr_66689_66756[(1)] = cljs.core.first.call(null,(state_66588[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66757 = state_66588;
state_66588 = G__66757;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__ = function(state_66588){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1.call(this,state_66588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2746__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66690 = f__2769__auto__.call(null);
(statearr_66690[(6)] = c__2768__auto__);

return statearr_66690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_66881){
var state_val_66882 = (state_66881[(1)]);
if((state_val_66882 === (7))){
var inst_66780 = (state_66881[(7)]);
var inst_66782 = fluree.db.api.query.resolve_block_range.call(null,inst_66780,query_map);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(10),inst_66782);
} else {
if((state_val_66882 === (20))){
var inst_66806 = (state_66881[(2)]);
var inst_66807 = fluree.db.util.async.throw_err.call(null,inst_66806);
var inst_66808 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66807);
var inst_66809 = (inst_66808 - (1));
var state_66881__$1 = state_66881;
var statearr_66883_66946 = state_66881__$1;
(statearr_66883_66946[(2)] = inst_66809);

(statearr_66883_66946[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (27))){
var state_66881__$1 = state_66881;
var statearr_66884_66947 = state_66881__$1;
(statearr_66884_66947[(2)] = null);

(statearr_66884_66947[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (1))){
var state_66881__$1 = state_66881;
var statearr_66885_66948 = state_66881__$1;
(statearr_66885_66948[(2)] = null);

(statearr_66885_66948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (24))){
var inst_66816 = (state_66881[(2)]);
var inst_66817 = fluree.db.util.async.throw_err.call(null,inst_66816);
var inst_66818 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66817);
var state_66881__$1 = state_66881;
var statearr_66886_66949 = state_66881__$1;
(statearr_66886_66949[(2)] = inst_66818);

(statearr_66886_66949[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (39))){
var inst_66853 = (state_66881[(2)]);
var inst_66854 = fluree.db.util.async.throw_err.call(null,inst_66853);
var state_66881__$1 = state_66881;
var statearr_66887_66950 = state_66881__$1;
(statearr_66887_66950[(2)] = inst_66854);

(statearr_66887_66950[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (4))){
var inst_66758 = (state_66881[(2)]);
var state_66881__$1 = state_66881;
var statearr_66888_66951 = state_66881__$1;
(statearr_66888_66951[(2)] = inst_66758);

(statearr_66888_66951[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (15))){
var inst_66789 = (state_66881[(8)]);
var state_66881__$1 = state_66881;
var statearr_66889_66952 = state_66881__$1;
(statearr_66889_66952[(2)] = inst_66789);

(statearr_66889_66952[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (21))){
var inst_66790 = (state_66881[(9)]);
var inst_66780 = (state_66881[(7)]);
var inst_66814 = fluree.db.time_travel.as_of_block.call(null,inst_66780,inst_66790);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(24),inst_66814);
} else {
if((state_val_66882 === (31))){
var inst_66774 = (state_66881[(10)]);
var state_66881__$1 = state_66881;
var statearr_66890_66953 = state_66881__$1;
(statearr_66890_66953[(2)] = inst_66774);

(statearr_66890_66953[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (32))){
var inst_66832 = (state_66881[(11)]);
var inst_66837 = (state_66881[(12)]);
var inst_66780 = (state_66881[(7)]);
var inst_66841 = (state_66881[(2)]);
var inst_66842 = fluree.db.api.query.format_history_resp.call(null,inst_66780,inst_66832,inst_66837,inst_66841);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(29),inst_66842);
} else {
if((state_val_66882 === (40))){
var inst_66832 = (state_66881[(11)]);
var inst_66858 = (state_66881[(13)]);
var inst_66860 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_66861 = cljs.core.count.call(null,inst_66832);
var inst_66862 = [inst_66858,inst_66861,(200)];
var inst_66863 = cljs.core.PersistentHashMap.fromArrays(inst_66860,inst_66862);
var state_66881__$1 = state_66881;
var statearr_66891_66954 = state_66881__$1;
(statearr_66891_66954[(2)] = inst_66863);

(statearr_66891_66954[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (33))){
var inst_66773 = (state_66881[(14)]);
var state_66881__$1 = state_66881;
var statearr_66892_66955 = state_66881__$1;
(statearr_66892_66955[(2)] = inst_66773);

(statearr_66892_66955[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (13))){
var inst_66876 = (state_66881[(2)]);
var _ = (function (){var statearr_66893 = state_66881;
(statearr_66893[(4)] = cljs.core.rest.call(null,(state_66881[(4)])));

return statearr_66893;
})();
var state_66881__$1 = state_66881;
var statearr_66894_66956 = state_66881__$1;
(statearr_66894_66956[(2)] = inst_66876);

(statearr_66894_66956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (22))){
var inst_66780 = (state_66881[(7)]);
var inst_66820 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66780);
var state_66881__$1 = state_66881;
var statearr_66895_66957 = state_66881__$1;
(statearr_66895_66957[(2)] = inst_66820);

(statearr_66895_66957[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (36))){
var inst_66845 = (state_66881[(15)]);
var inst_66780 = (state_66881[(7)]);
var inst_66851 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_66780,inst_66845);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(39),inst_66851);
} else {
if((state_val_66882 === (41))){
var inst_66858 = (state_66881[(13)]);
var state_66881__$1 = state_66881;
var statearr_66896_66958 = state_66881__$1;
(statearr_66896_66958[(2)] = inst_66858);

(statearr_66896_66958[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (29))){
var inst_66773 = (state_66881[(14)]);
var inst_66844 = (state_66881[(2)]);
var inst_66845 = fluree.db.util.async.throw_err.call(null,inst_66844);
var state_66881__$1 = (function (){var statearr_66897 = state_66881;
(statearr_66897[(15)] = inst_66845);

return statearr_66897;
})();
if(cljs.core.truth_(inst_66773)){
var statearr_66898_66959 = state_66881__$1;
(statearr_66898_66959[(1)] = (33));

} else {
var statearr_66899_66960 = state_66881__$1;
(statearr_66899_66960[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (6))){
var inst_66770 = (state_66881[(16)]);
var inst_66779 = (state_66881[(2)]);
var inst_66780 = fluree.db.util.async.throw_err.call(null,inst_66779);
var state_66881__$1 = (function (){var statearr_66900 = state_66881;
(statearr_66900[(7)] = inst_66780);

return statearr_66900;
})();
if(cljs.core.truth_(inst_66770)){
var statearr_66901_66961 = state_66881__$1;
(statearr_66901_66961[(1)] = (7));

} else {
var statearr_66902_66962 = state_66881__$1;
(statearr_66902_66962[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (28))){
var inst_66775 = (state_66881[(17)]);
var inst_66837 = (state_66881[(2)]);
var state_66881__$1 = (function (){var statearr_66903 = state_66881;
(statearr_66903[(12)] = inst_66837);

return statearr_66903;
})();
if(cljs.core.truth_(inst_66775)){
var statearr_66904_66963 = state_66881__$1;
(statearr_66904_66963[(1)] = (30));

} else {
var statearr_66905_66964 = state_66881__$1;
(statearr_66905_66964[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (25))){
var inst_66776 = (state_66881[(18)]);
var inst_66831 = (state_66881[(2)]);
var inst_66832 = fluree.db.util.async.throw_err.call(null,inst_66831);
var state_66881__$1 = (function (){var statearr_66906 = state_66881;
(statearr_66906[(11)] = inst_66832);

return statearr_66906;
})();
if(cljs.core.truth_(inst_66776)){
var statearr_66907_66965 = state_66881__$1;
(statearr_66907_66965[(1)] = (26));

} else {
var statearr_66908_66966 = state_66881__$1;
(statearr_66908_66966[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (34))){
var inst_66772 = (state_66881[(19)]);
var state_66881__$1 = state_66881;
var statearr_66909_66967 = state_66881__$1;
(statearr_66909_66967[(2)] = inst_66772);

(statearr_66909_66967[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (17))){
var inst_66789 = (state_66881[(8)]);
var inst_66780 = (state_66881[(7)]);
var inst_66803 = (inst_66789 - (1));
var inst_66804 = fluree.db.time_travel.as_of_block.call(null,inst_66780,inst_66803);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(20),inst_66804);
} else {
if((state_val_66882 === (3))){
var inst_66879 = (state_66881[(2)]);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_66881__$1,inst_66879);
} else {
if((state_val_66882 === (12))){
var inst_66868 = cljs.core.pr_str.call(null,query_map);
var inst_66869 = ["History query not properly formatted. Provided ",inst_66868].join('');
var inst_66870 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66871 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66872 = cljs.core.PersistentHashMap.fromArrays(inst_66870,inst_66871);
var inst_66873 = cljs.core.ex_info.call(null,inst_66869,inst_66872);
var inst_66874 = (function(){throw inst_66873})();
var state_66881__$1 = state_66881;
var statearr_66910_66968 = state_66881__$1;
(statearr_66910_66968[(2)] = inst_66874);

(statearr_66910_66968[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (2))){
var _ = (function (){var statearr_66911 = state_66881;
(statearr_66911[(4)] = cljs.core.cons.call(null,(5),(state_66881[(4)])));

return statearr_66911;
})();
var inst_66768 = query_map;
var inst_66769 = cljs.core.__destructure_map.call(null,inst_66768);
var inst_66770 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66771 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_66772 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_66773 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_66774 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_66775 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_66776 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66777 = cljs.core.get.call(null,inst_66769,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_66881__$1 = (function (){var statearr_66912 = state_66881;
(statearr_66912[(10)] = inst_66774);

(statearr_66912[(14)] = inst_66773);

(statearr_66912[(20)] = inst_66771);

(statearr_66912[(17)] = inst_66775);

(statearr_66912[(19)] = inst_66772);

(statearr_66912[(16)] = inst_66770);

(statearr_66912[(18)] = inst_66776);

(statearr_66912[(21)] = inst_66777);

return statearr_66912;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(6),sources);
} else {
if((state_val_66882 === (23))){
var inst_66771 = (state_66881[(20)]);
var inst_66812 = (state_66881[(22)]);
var inst_66780 = (state_66881[(7)]);
var inst_66822 = (state_66881[(2)]);
var inst_66823 = fluree.db.api.query.get_history_pattern.call(null,inst_66771);
var inst_66824 = cljs.core.nth.call(null,inst_66823,(0),null);
var inst_66825 = cljs.core.nth.call(null,inst_66823,(1),null);
var inst_66826 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_66827 = [inst_66812,inst_66822];
var inst_66828 = cljs.core.PersistentHashMap.fromArrays(inst_66826,inst_66827);
var inst_66829 = fluree.db.query.range.time_range.call(null,inst_66780,inst_66825,cljs.core._EQ_,inst_66824,inst_66828);
var state_66881__$1 = state_66881;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_66881__$1,(25),inst_66829);
} else {
if((state_val_66882 === (35))){
var inst_66849 = (state_66881[(2)]);
var state_66881__$1 = state_66881;
if(cljs.core.truth_(inst_66849)){
var statearr_66913_66969 = state_66881__$1;
(statearr_66913_66969[(1)] = (36));

} else {
var statearr_66914_66970 = state_66881__$1;
(statearr_66914_66970[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (19))){
var inst_66790 = (state_66881[(9)]);
var inst_66812 = (state_66881[(2)]);
var state_66881__$1 = (function (){var statearr_66915 = state_66881;
(statearr_66915[(22)] = inst_66812);

return statearr_66915;
})();
if(cljs.core.truth_(inst_66790)){
var statearr_66916_66971 = state_66881__$1;
(statearr_66916_66971[(1)] = (21));

} else {
var statearr_66917_66972 = state_66881__$1;
(statearr_66917_66972[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (11))){
var inst_66789 = (state_66881[(8)]);
var inst_66777 = (state_66881[(21)]);
var inst_66796 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_66777);
var state_66881__$1 = (function (){var statearr_66919 = state_66881;
(statearr_66919[(23)] = inst_66796);

return statearr_66919;
})();
if(cljs.core.truth_(inst_66789)){
var statearr_66920_66973 = state_66881__$1;
(statearr_66920_66973[(1)] = (14));

} else {
var statearr_66921_66974 = state_66881__$1;
(statearr_66921_66974[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (9))){
var inst_66788 = (state_66881[(2)]);
var inst_66789 = cljs.core.nth.call(null,inst_66788,(0),null);
var inst_66790 = cljs.core.nth.call(null,inst_66788,(1),null);
var inst_66791 = cljs.core.contains_QMARK_.call(null,query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_66881__$1 = (function (){var statearr_66922 = state_66881;
(statearr_66922[(9)] = inst_66790);

(statearr_66922[(8)] = inst_66789);

return statearr_66922;
})();
if(inst_66791){
var statearr_66923_66975 = state_66881__$1;
(statearr_66923_66975[(1)] = (11));

} else {
var statearr_66924_66976 = state_66881__$1;
(statearr_66924_66976[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (5))){
var _ = (function (){var statearr_66925 = state_66881;
(statearr_66925[(4)] = cljs.core.rest.call(null,(state_66881[(4)])));

return statearr_66925;
})();
var state_66881__$1 = state_66881;
var ex66918 = (state_66881__$1[(2)]);
var statearr_66926_66977 = state_66881__$1;
(statearr_66926_66977[(5)] = ex66918);


if((ex66918 instanceof Error)){
var statearr_66927_66978 = state_66881__$1;
(statearr_66927_66978[(1)] = (4));

(statearr_66927_66978[(5)] = null);

} else {
throw ex66918;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (14))){
var inst_66789 = (state_66881[(8)]);
var inst_66798 = cljs.core.not_EQ_.call(null,(1),inst_66789);
var state_66881__$1 = state_66881;
var statearr_66928_66979 = state_66881__$1;
(statearr_66928_66979[(2)] = inst_66798);

(statearr_66928_66979[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (26))){
var inst_66776 = (state_66881[(18)]);
var inst_66834 = cljs.core.set.call(null,inst_66776);
var state_66881__$1 = state_66881;
var statearr_66929_66980 = state_66881__$1;
(statearr_66929_66980[(2)] = inst_66834);

(statearr_66929_66980[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (16))){
var inst_66801 = (state_66881[(2)]);
var state_66881__$1 = state_66881;
if(cljs.core.truth_(inst_66801)){
var statearr_66930_66981 = state_66881__$1;
(statearr_66930_66981[(1)] = (17));

} else {
var statearr_66931_66982 = state_66881__$1;
(statearr_66931_66982[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (38))){
var inst_66796 = (state_66881[(23)]);
var inst_66858 = (state_66881[(2)]);
var state_66881__$1 = (function (){var statearr_66932 = state_66881;
(statearr_66932[(13)] = inst_66858);

return statearr_66932;
})();
if(cljs.core.truth_(inst_66796)){
var statearr_66933_66983 = state_66881__$1;
(statearr_66933_66983[(1)] = (40));

} else {
var statearr_66934_66984 = state_66881__$1;
(statearr_66934_66984[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (30))){
var inst_66775 = (state_66881[(17)]);
var state_66881__$1 = state_66881;
var statearr_66935_66985 = state_66881__$1;
(statearr_66935_66985[(2)] = inst_66775);

(statearr_66935_66985[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (10))){
var inst_66784 = (state_66881[(2)]);
var inst_66785 = fluree.db.util.async.throw_err.call(null,inst_66784);
var state_66881__$1 = state_66881;
var statearr_66936_66986 = state_66881__$1;
(statearr_66936_66986[(2)] = inst_66785);

(statearr_66936_66986[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (18))){
var state_66881__$1 = state_66881;
var statearr_66937_66987 = state_66881__$1;
(statearr_66937_66987[(2)] = (-1));

(statearr_66937_66987[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (42))){
var inst_66866 = (state_66881[(2)]);
var state_66881__$1 = state_66881;
var statearr_66938_66988 = state_66881__$1;
(statearr_66938_66988[(2)] = inst_66866);

(statearr_66938_66988[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (37))){
var inst_66845 = (state_66881[(15)]);
var inst_66856 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_66845);
var state_66881__$1 = state_66881;
var statearr_66939_66989 = state_66881__$1;
(statearr_66939_66989[(2)] = inst_66856);

(statearr_66939_66989[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66882 === (8))){
var state_66881__$1 = state_66881;
var statearr_66940_66990 = state_66881__$1;
(statearr_66940_66990[(2)] = null);

(statearr_66940_66990[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_66941 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66941[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2746__auto__);

(statearr_66941[(1)] = (1));

return statearr_66941;
});
var fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1 = (function (state_66881){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_66881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e66942){var ex__2749__auto__ = e66942;
var statearr_66943_66991 = state_66881;
(statearr_66943_66991[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_66881[(4)]))){
var statearr_66944_66992 = state_66881;
(statearr_66944_66992[(1)] = cljs.core.first.call(null,(state_66881[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66993 = state_66881;
state_66881 = G__66993;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__ = function(state_66881){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1.call(this,state_66881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_66945 = f__2769__auto__.call(null);
(statearr_66945[(6)] = c__2768__auto__);

return statearr_66945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67126){
var state_val_67127 = (state_67126[(1)]);
if((state_val_67127 === (7))){
var inst_67023 = cljs.core.pr_str.call(null,flureeQL);
var inst_67024 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_67023].join('');
var inst_67025 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67026 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67027 = cljs.core.PersistentHashMap.fromArrays(inst_67025,inst_67026);
var inst_67028 = cljs.core.ex_info.call(null,inst_67024,inst_67027);
var inst_67029 = (function(){throw inst_67028})();
var state_67126__$1 = state_67126;
var statearr_67128_67207 = state_67126__$1;
(statearr_67128_67207[(2)] = inst_67029);

(statearr_67128_67207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (20))){
var inst_67061 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
if(cljs.core.truth_(inst_67061)){
var statearr_67129_67208 = state_67126__$1;
(statearr_67129_67208[(1)] = (21));

} else {
var statearr_67130_67209 = state_67126__$1;
(statearr_67130_67209[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (27))){
var inst_67005 = (state_67126[(7)]);
var state_67126__$1 = state_67126;
var statearr_67131_67210 = state_67126__$1;
(statearr_67131_67210[(2)] = inst_67005);

(statearr_67131_67210[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (1))){
var state_67126__$1 = state_67126;
var statearr_67132_67211 = state_67126__$1;
(statearr_67132_67211[(2)] = null);

(statearr_67132_67211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (24))){
var inst_67067 = (state_67126[(8)]);
var state_67126__$1 = state_67126;
var statearr_67133_67212 = state_67126__$1;
(statearr_67133_67212[(2)] = inst_67067);

(statearr_67133_67212[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (39))){
var inst_67011 = (state_67126[(9)]);
var state_67126__$1 = state_67126;
if(cljs.core.truth_(inst_67011)){
var statearr_67134_67213 = state_67126__$1;
(statearr_67134_67213[(1)] = (42));

} else {
var statearr_67135_67214 = state_67126__$1;
(statearr_67135_67214[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (46))){
var inst_67099 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67100 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67101 = cljs.core.PersistentHashMap.fromArrays(inst_67099,inst_67100);
var inst_67102 = cljs.core.ex_info.call(null,"Invalid query.",inst_67101);
var inst_67103 = (function(){throw inst_67102})();
var state_67126__$1 = state_67126;
var statearr_67136_67215 = state_67126__$1;
(statearr_67136_67215[(2)] = inst_67103);

(statearr_67136_67215[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (4))){
var inst_66995 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
var statearr_67137_67216 = state_67126__$1;
(statearr_67137_67216[(2)] = inst_66995);

(statearr_67137_67216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (15))){
var inst_67008 = (state_67126[(10)]);
var inst_67046 = (state_67126[(11)]);
var inst_67048 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_67046);
var inst_67049 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_67046);
var inst_67050 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67046);
var inst_67051 = fluree.db.api.query.get_sources.call(null,inst_67048,inst_67049,inst_67050,inst_67008);
var state_67126__$1 = state_67126;
var statearr_67138_67217 = state_67126__$1;
(statearr_67138_67217[(2)] = inst_67051);

(statearr_67138_67217[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (48))){
var inst_67056 = (state_67126[(12)]);
var inst_67110 = (state_67126[(2)]);
var inst_67111 = fluree.db.util.async.throw_err.call(null,inst_67110);
var state_67126__$1 = (function (){var statearr_67139 = state_67126;
(statearr_67139[(13)] = inst_67111);

return statearr_67139;
})();
if(cljs.core.truth_(inst_67056)){
var statearr_67140_67218 = state_67126__$1;
(statearr_67140_67218[(1)] = (49));

} else {
var statearr_67141_67219 = state_67126__$1;
(statearr_67141_67219[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (50))){
var inst_67111 = (state_67126[(13)]);
var state_67126__$1 = state_67126;
var statearr_67142_67220 = state_67126__$1;
(statearr_67142_67220[(2)] = inst_67111);

(statearr_67142_67220[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (21))){
var inst_67063 = cljs.core.volatile_BANG_.call(null,(0));
var state_67126__$1 = state_67126;
var statearr_67143_67221 = state_67126__$1;
(statearr_67143_67221[(2)] = inst_67063);

(statearr_67143_67221[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (31))){
var inst_67009 = (state_67126[(14)]);
var state_67126__$1 = state_67126;
if(cljs.core.truth_(inst_67009)){
var statearr_67144_67222 = state_67126__$1;
(statearr_67144_67222[(1)] = (33));

} else {
var statearr_67145_67223 = state_67126__$1;
(statearr_67145_67223[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (32))){
var inst_67086 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
var statearr_67146_67224 = state_67126__$1;
(statearr_67146_67224[(2)] = inst_67086);

(statearr_67146_67224[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (40))){
var inst_67088 = (state_67126[(15)]);
var state_67126__$1 = state_67126;
var statearr_67147_67225 = state_67126__$1;
(statearr_67147_67225[(2)] = inst_67088);

(statearr_67147_67225[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (33))){
var inst_67009 = (state_67126[(14)]);
var state_67126__$1 = state_67126;
var statearr_67148_67226 = state_67126__$1;
(statearr_67148_67226[(2)] = inst_67009);

(statearr_67148_67226[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (13))){
var inst_67006 = (state_67126[(16)]);
var inst_67035 = (state_67126[(2)]);
var inst_67036 = fluree.db.util.async.throw_err.call(null,inst_67035);
var inst_67037 = fluree.db.time_travel.as_of_block.call(null,inst_67036,inst_67006);
var state_67126__$1 = state_67126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67126__$1,(12),inst_67037);
} else {
if((state_val_67127 === (22))){
var state_67126__$1 = state_67126;
var statearr_67149_67227 = state_67126__$1;
(statearr_67149_67227[(2)] = null);

(statearr_67149_67227[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (36))){
var inst_67013 = (state_67126[(17)]);
var state_67126__$1 = state_67126;
var statearr_67150_67228 = state_67126__$1;
(statearr_67150_67228[(2)] = inst_67013);

(statearr_67150_67228[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (41))){
var inst_67096 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
if(cljs.core.truth_(inst_67096)){
var statearr_67151_67229 = state_67126__$1;
(statearr_67151_67229[(1)] = (45));

} else {
var statearr_67152_67230 = state_67126__$1;
(statearr_67152_67230[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (43))){
var inst_67007 = (state_67126[(18)]);
var state_67126__$1 = state_67126;
var statearr_67153_67231 = state_67126__$1;
(statearr_67153_67231[(2)] = inst_67007);

(statearr_67153_67231[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (29))){
var inst_67088 = (state_67126[(15)]);
var inst_67088__$1 = (state_67126[(2)]);
var state_67126__$1 = (function (){var statearr_67154 = state_67126;
(statearr_67154[(15)] = inst_67088__$1);

return statearr_67154;
})();
if(cljs.core.truth_(inst_67088__$1)){
var statearr_67155_67232 = state_67126__$1;
(statearr_67155_67232[(1)] = (39));

} else {
var statearr_67156_67233 = state_67126__$1;
(statearr_67156_67233[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (44))){
var inst_67093 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
var statearr_67157_67234 = state_67126__$1;
(statearr_67157_67234[(2)] = inst_67093);

(statearr_67157_67234[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (6))){
var state_67126__$1 = state_67126;
var statearr_67158_67235 = state_67126__$1;
(statearr_67158_67235[(2)] = null);

(statearr_67158_67235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (28))){
var inst_67010 = (state_67126[(19)]);
var state_67126__$1 = state_67126;
if(cljs.core.truth_(inst_67010)){
var statearr_67159_67236 = state_67126__$1;
(statearr_67159_67236[(1)] = (30));

} else {
var statearr_67160_67237 = state_67126__$1;
(statearr_67160_67237[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (51))){
var inst_67121 = (state_67126[(2)]);
var _ = (function (){var statearr_67161 = state_67126;
(statearr_67161[(4)] = cljs.core.rest.call(null,(state_67126[(4)])));

return statearr_67161;
})();
var state_67126__$1 = state_67126;
var statearr_67162_67238 = state_67126__$1;
(statearr_67162_67238[(2)] = inst_67121);

(statearr_67162_67238[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (25))){
var state_67126__$1 = state_67126;
var statearr_67163_67239 = state_67126__$1;
(statearr_67163_67239[(2)] = (1000000));

(statearr_67163_67239[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (34))){
var inst_67013 = (state_67126[(17)]);
var state_67126__$1 = state_67126;
if(cljs.core.truth_(inst_67013)){
var statearr_67164_67240 = state_67126__$1;
(statearr_67164_67240[(1)] = (36));

} else {
var statearr_67165_67241 = state_67126__$1;
(statearr_67165_67241[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (17))){
var inst_67057 = (state_67126[(20)]);
var inst_67012 = (state_67126[(21)]);
var inst_67055 = (state_67126[(2)]);
var inst_67056 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_67012);
var inst_67057__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67012);
var state_67126__$1 = (function (){var statearr_67166 = state_67126;
(statearr_67166[(20)] = inst_67057__$1);

(statearr_67166[(22)] = inst_67055);

(statearr_67166[(12)] = inst_67056);

return statearr_67166;
})();
if(cljs.core.truth_(inst_67057__$1)){
var statearr_67167_67242 = state_67126__$1;
(statearr_67167_67242[(1)] = (18));

} else {
var statearr_67168_67243 = state_67126__$1;
(statearr_67168_67243[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (3))){
var inst_67124 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67126__$1,inst_67124);
} else {
if((state_val_67127 === (12))){
var inst_67039 = (state_67126[(2)]);
var inst_67040 = fluree.db.util.async.throw_err.call(null,inst_67039);
var state_67126__$1 = state_67126;
var statearr_67169_67244 = state_67126__$1;
(statearr_67169_67244[(2)] = inst_67040);

(statearr_67169_67244[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (2))){
var inst_67011 = (state_67126[(9)]);
var inst_67008 = (state_67126[(10)]);
var inst_67004 = (state_67126[(23)]);
var inst_67006 = (state_67126[(16)]);
var inst_67009 = (state_67126[(14)]);
var inst_67012 = (state_67126[(21)]);
var inst_67013 = (state_67126[(17)]);
var inst_67005 = (state_67126[(7)]);
var inst_67007 = (state_67126[(18)]);
var inst_67010 = (state_67126[(19)]);
var _ = (function (){var statearr_67170 = state_67126;
(statearr_67170[(4)] = cljs.core.cons.call(null,(5),(state_67126[(4)])));

return statearr_67170;
})();
var inst_67002 = flureeQL;
var inst_67003 = cljs.core.__destructure_map.call(null,inst_67002);
var inst_67004__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_67005__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_67006__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67007__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_67008__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_67009__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_67010__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_67011__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_67012__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_67013__$1 = cljs.core.get.call(null,inst_67003,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_67014 = (function (){var construct = inst_67004__$1;
var select = inst_67005__$1;
var block = inst_67006__$1;
var where = inst_67007__$1;
var prefixes = inst_67008__$1;
var map__67001 = inst_67003;
var selectDistinct = inst_67009__$1;
var selectOne = inst_67010__$1;
var from = inst_67011__$1;
var opts = inst_67012__$1;
var selectReduced = inst_67013__$1;
return (function (p1__66994_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__66994_SHARP_);
});
})();
var inst_67015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67016 = [inst_67005__$1,inst_67010__$1,inst_67009__$1,inst_67013__$1];
var inst_67017 = (new cljs.core.PersistentVector(null,4,(5),inst_67015,inst_67016,null));
var inst_67018 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_67017);
var inst_67019 = cljs.core.count.call(null,inst_67018);
var inst_67020 = inst_67014.call(null,inst_67019);
var state_67126__$1 = (function (){var statearr_67171 = state_67126;
(statearr_67171[(9)] = inst_67011__$1);

(statearr_67171[(10)] = inst_67008__$1);

(statearr_67171[(23)] = inst_67004__$1);

(statearr_67171[(16)] = inst_67006__$1);

(statearr_67171[(14)] = inst_67009__$1);

(statearr_67171[(21)] = inst_67012__$1);

(statearr_67171[(17)] = inst_67013__$1);

(statearr_67171[(7)] = inst_67005__$1);

(statearr_67171[(18)] = inst_67007__$1);

(statearr_67171[(19)] = inst_67010__$1);

return statearr_67171;
})();
if(cljs.core.truth_(inst_67020)){
var statearr_67172_67245 = state_67126__$1;
(statearr_67172_67245[(1)] = (6));

} else {
var statearr_67173_67246 = state_67126__$1;
(statearr_67173_67246[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (23))){
var inst_67012 = (state_67126[(21)]);
var inst_67067 = (state_67126[(8)]);
var inst_67066 = (state_67126[(2)]);
var inst_67067__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67012);
var state_67126__$1 = (function (){var statearr_67174 = state_67126;
(statearr_67174[(24)] = inst_67066);

(statearr_67174[(8)] = inst_67067__$1);

return statearr_67174;
})();
if(cljs.core.truth_(inst_67067__$1)){
var statearr_67175_67247 = state_67126__$1;
(statearr_67175_67247[(1)] = (24));

} else {
var statearr_67176_67248 = state_67126__$1;
(statearr_67176_67248[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (47))){
var inst_67072 = (state_67126[(25)]);
var inst_67046 = (state_67126[(11)]);
var inst_67105 = (state_67126[(2)]);
var inst_67106 = fluree.db.util.core.current_time_millis.call(null);
var inst_67107 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_67072);
var inst_67108 = fluree.db.query.fql.query.call(null,inst_67046,inst_67107);
var state_67126__$1 = (function (){var statearr_67177 = state_67126;
(statearr_67177[(26)] = inst_67105);

(statearr_67177[(27)] = inst_67106);

return statearr_67177;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67126__$1,(48),inst_67108);
} else {
if((state_val_67127 === (35))){
var inst_67084 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
var statearr_67178_67249 = state_67126__$1;
(statearr_67178_67249[(2)] = inst_67084);

(statearr_67178_67249[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (19))){
var inst_67056 = (state_67126[(12)]);
var state_67126__$1 = state_67126;
var statearr_67179_67250 = state_67126__$1;
(statearr_67179_67250[(2)] = inst_67056);

(statearr_67179_67250[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (11))){
var inst_67008 = (state_67126[(10)]);
var inst_67046 = (state_67126[(2)]);
var state_67126__$1 = (function (){var statearr_67181 = state_67126;
(statearr_67181[(11)] = inst_67046);

return statearr_67181;
})();
if(cljs.core.truth_(inst_67008)){
var statearr_67182_67251 = state_67126__$1;
(statearr_67182_67251[(1)] = (15));

} else {
var statearr_67183_67252 = state_67126__$1;
(statearr_67183_67252[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (9))){
var inst_67032 = (state_67126[(28)]);
var state_67126__$1 = state_67126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67126__$1,(13),inst_67032);
} else {
if((state_val_67127 === (5))){
var _ = (function (){var statearr_67184 = state_67126;
(statearr_67184[(4)] = cljs.core.rest.call(null,(state_67126[(4)])));

return statearr_67184;
})();
var state_67126__$1 = state_67126;
var ex67180 = (state_67126__$1[(2)]);
var statearr_67185_67253 = state_67126__$1;
(statearr_67185_67253[(5)] = ex67180);


if((ex67180 instanceof Error)){
var statearr_67186_67254 = state_67126__$1;
(statearr_67186_67254[(1)] = (4));

(statearr_67186_67254[(5)] = null);

} else {
throw ex67180;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (14))){
var inst_67043 = (state_67126[(2)]);
var inst_67044 = fluree.db.util.async.throw_err.call(null,inst_67043);
var state_67126__$1 = state_67126;
var statearr_67187_67255 = state_67126__$1;
(statearr_67187_67255[(2)] = inst_67044);

(statearr_67187_67255[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (45))){
var state_67126__$1 = state_67126;
var statearr_67188_67256 = state_67126__$1;
(statearr_67188_67256[(2)] = null);

(statearr_67188_67256[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (26))){
var inst_67055 = (state_67126[(22)]);
var inst_67066 = (state_67126[(24)]);
var inst_67012 = (state_67126[(21)]);
var inst_67005 = (state_67126[(7)]);
var inst_67071 = (state_67126[(2)]);
var inst_67072 = cljs.core.assoc.call(null,inst_67012,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_67055,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_67071,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_67066);
var state_67126__$1 = (function (){var statearr_67189 = state_67126;
(statearr_67189[(25)] = inst_67072);

return statearr_67189;
})();
if(cljs.core.truth_(inst_67005)){
var statearr_67190_67257 = state_67126__$1;
(statearr_67190_67257[(1)] = (27));

} else {
var statearr_67191_67258 = state_67126__$1;
(statearr_67191_67258[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (16))){
var inst_67053 = cljs.core.PersistentHashMap.EMPTY;
var state_67126__$1 = state_67126;
var statearr_67192_67259 = state_67126__$1;
(statearr_67192_67259[(2)] = inst_67053);

(statearr_67192_67259[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (38))){
var inst_67082 = (state_67126[(2)]);
var state_67126__$1 = state_67126;
var statearr_67193_67260 = state_67126__$1;
(statearr_67193_67260[(2)] = inst_67082);

(statearr_67193_67260[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (30))){
var inst_67010 = (state_67126[(19)]);
var state_67126__$1 = state_67126;
var statearr_67194_67261 = state_67126__$1;
(statearr_67194_67261[(2)] = inst_67010);

(statearr_67194_67261[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (10))){
var inst_67032 = (state_67126[(28)]);
var state_67126__$1 = state_67126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67126__$1,(14),inst_67032);
} else {
if((state_val_67127 === (18))){
var inst_67057 = (state_67126[(20)]);
var state_67126__$1 = state_67126;
var statearr_67195_67262 = state_67126__$1;
(statearr_67195_67262[(2)] = inst_67057);

(statearr_67195_67262[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (42))){
var inst_67011 = (state_67126[(9)]);
var state_67126__$1 = state_67126;
var statearr_67196_67263 = state_67126__$1;
(statearr_67196_67263[(2)] = inst_67011);

(statearr_67196_67263[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (37))){
var inst_67004 = (state_67126[(23)]);
var state_67126__$1 = state_67126;
var statearr_67197_67264 = state_67126__$1;
(statearr_67197_67264[(2)] = inst_67004);

(statearr_67197_67264[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (8))){
var inst_67006 = (state_67126[(16)]);
var inst_67031 = (state_67126[(2)]);
var inst_67032 = sources;
var state_67126__$1 = (function (){var statearr_67198 = state_67126;
(statearr_67198[(28)] = inst_67032);

(statearr_67198[(29)] = inst_67031);

return statearr_67198;
})();
if(cljs.core.truth_(inst_67006)){
var statearr_67199_67265 = state_67126__$1;
(statearr_67199_67265[(1)] = (9));

} else {
var statearr_67200_67266 = state_67126__$1;
(statearr_67200_67266[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67127 === (49))){
var inst_67111 = (state_67126[(13)]);
var inst_67066 = (state_67126[(24)]);
var inst_67106 = (state_67126[(27)]);
var inst_67046 = (state_67126[(11)]);
var inst_67113 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_67114 = cljs.core.deref.call(null,inst_67066);
var inst_67115 = fluree.db.util.core.response_time_formatted.call(null,inst_67106);
var inst_67116 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_67046);
var inst_67117 = [(200),inst_67111,inst_67114,inst_67115,inst_67116];
var inst_67118 = cljs.core.PersistentHashMap.fromArrays(inst_67113,inst_67117);
var state_67126__$1 = state_67126;
var statearr_67201_67267 = state_67126__$1;
(statearr_67201_67267[(2)] = inst_67118);

(statearr_67201_67267[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_67202 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67202[(0)] = fluree$db$api$query$query_async_$_state_machine__2746__auto__);

(statearr_67202[(1)] = (1));

return statearr_67202;
});
var fluree$db$api$query$query_async_$_state_machine__2746__auto____1 = (function (state_67126){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67203){var ex__2749__auto__ = e67203;
var statearr_67204_67268 = state_67126;
(statearr_67204_67268[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67126[(4)]))){
var statearr_67205_67269 = state_67126;
(statearr_67205_67269[(1)] = cljs.core.first.call(null,(state_67126[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67270 = state_67126;
state_67126 = G__67270;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2746__auto__ = function(state_67126){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2746__auto____1.call(this,state_67126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67206 = f__2769__auto__.call(null);
(statearr_67206[(6)] = c__2768__auto__);

return statearr_67206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_67411){
var state_val_67412 = (state_67411[(1)]);
if((state_val_67412 === (7))){
var inst_67406 = (state_67411[(2)]);
var _ = (function (){var statearr_67413 = state_67411;
(statearr_67413[(4)] = cljs.core.rest.call(null,(state_67411[(4)])));

return statearr_67413;
})();
var state_67411__$1 = state_67411;
var statearr_67414_67490 = state_67411__$1;
(statearr_67414_67490[(2)] = inst_67406);

(statearr_67414_67490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (20))){
var inst_67378 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67415_67491 = state_67411__$1;
(statearr_67415_67491[(2)] = inst_67378);

(statearr_67415_67491[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (27))){
var inst_67358 = (state_67411[(7)]);
var state_67411__$1 = state_67411;
var statearr_67416_67492 = state_67411__$1;
(statearr_67416_67492[(2)] = inst_67358);

(statearr_67416_67492[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (1))){
var state_67411__$1 = state_67411;
var statearr_67417_67493 = state_67411__$1;
(statearr_67417_67493[(2)] = null);

(statearr_67417_67493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (24))){
var inst_67355 = (state_67411[(8)]);
var state_67411__$1 = state_67411;
var statearr_67418_67494 = state_67411__$1;
(statearr_67418_67494[(2)] = inst_67355);

(statearr_67418_67494[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (39))){
var inst_67312 = (state_67411[(9)]);
var inst_67345 = (state_67411[(10)]);
var inst_67323 = (state_67411[(11)]);
var inst_67389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67390 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_67323];
var inst_67391 = (new cljs.core.PersistentVector(null,2,(5),inst_67389,inst_67390,null));
var inst_67392 = cljs.core.assoc_in.call(null,inst_67312,inst_67391,inst_67345);
var state_67411__$1 = state_67411;
var statearr_67419_67495 = state_67411__$1;
(statearr_67419_67495[(2)] = inst_67392);

(statearr_67419_67495[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (4))){
var inst_67271 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67420_67496 = state_67411__$1;
(statearr_67420_67496[(2)] = inst_67271);

(statearr_67420_67496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (15))){
var inst_67310 = (state_67411[(12)]);
var inst_67345 = (state_67411[(10)]);
var inst_67348 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_67345);
var inst_67349 = (inst_67310 == null);
var state_67411__$1 = (function (){var statearr_67421 = state_67411;
(statearr_67421[(13)] = inst_67348);

return statearr_67421;
})();
if(cljs.core.truth_(inst_67349)){
var statearr_67422_67497 = state_67411__$1;
(statearr_67422_67497[(1)] = (18));

} else {
var statearr_67423_67498 = state_67411__$1;
(statearr_67423_67498[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (21))){
var inst_67348 = (state_67411[(13)]);
var state_67411__$1 = state_67411;
var statearr_67424_67499 = state_67411__$1;
(statearr_67424_67499[(2)] = inst_67348);

(statearr_67424_67499[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (31))){
var state_67411__$1 = state_67411;
var statearr_67425_67500 = state_67411__$1;
(statearr_67425_67500[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (32))){
var inst_67374 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67427_67501 = state_67411__$1;
(statearr_67427_67501[(2)] = inst_67374);

(statearr_67427_67501[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (40))){
var inst_67343 = (state_67411[(14)]);
var state_67411__$1 = state_67411;
if(cljs.core.truth_(inst_67343)){
var statearr_67428_67502 = state_67411__$1;
(statearr_67428_67502[(1)] = (42));

} else {
var statearr_67429_67503 = state_67411__$1;
(statearr_67429_67503[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (33))){
var inst_67310 = (state_67411[(12)]);
var inst_67348 = (state_67411[(13)]);
var inst_67369 = ((inst_67348 > inst_67310) ? inst_67348 : inst_67310);
var state_67411__$1 = state_67411;
var statearr_67430_67504 = state_67411__$1;
(statearr_67430_67504[(2)] = inst_67369);

(statearr_67430_67504[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (13))){
var inst_67334 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67431_67505 = state_67411__$1;
(statearr_67431_67505[(2)] = inst_67334);

(statearr_67431_67505[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (22))){
var inst_67348 = (state_67411[(13)]);
var inst_67355 = (state_67411[(8)]);
var inst_67355__$1 = cljs.core._EQ_.call(null,(200),inst_67348);
var state_67411__$1 = (function (){var statearr_67432 = state_67411;
(statearr_67432[(8)] = inst_67355__$1);

return statearr_67432;
})();
if(inst_67355__$1){
var statearr_67433_67506 = state_67411__$1;
(statearr_67433_67506[(1)] = (24));

} else {
var statearr_67434_67507 = state_67411__$1;
(statearr_67434_67507[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (36))){
var inst_67345 = (state_67411[(10)]);
var inst_67311 = (state_67411[(15)]);
var inst_67383 = cljs.core.get.call(null,inst_67345,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_67384 = (inst_67311 + inst_67383);
var state_67411__$1 = state_67411;
var statearr_67435_67508 = state_67411__$1;
(statearr_67435_67508[(2)] = inst_67384);

(statearr_67435_67508[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (41))){
var inst_67381 = (state_67411[(16)]);
var inst_67322 = (state_67411[(17)]);
var inst_67387 = (state_67411[(18)]);
var inst_67401 = (state_67411[(2)]);
var inst_67309 = inst_67322;
var inst_67310 = inst_67381;
var inst_67311 = inst_67387;
var inst_67312 = inst_67401;
var state_67411__$1 = (function (){var statearr_67436 = state_67411;
(statearr_67436[(9)] = inst_67312);

(statearr_67436[(19)] = inst_67309);

(statearr_67436[(12)] = inst_67310);

(statearr_67436[(15)] = inst_67311);

return statearr_67436;
})();
var statearr_67437_67509 = state_67411__$1;
(statearr_67437_67509[(2)] = null);

(statearr_67437_67509[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (43))){
var inst_67345 = (state_67411[(10)]);
var state_67411__$1 = state_67411;
var statearr_67438_67510 = state_67411__$1;
(statearr_67438_67510[(2)] = inst_67345);

(statearr_67438_67510[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (29))){
var inst_67363 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67439_67511 = state_67411__$1;
(statearr_67439_67511[(2)] = inst_67363);

(statearr_67439_67511[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (44))){
var inst_67312 = (state_67411[(9)]);
var inst_67323 = (state_67411[(11)]);
var inst_67398 = (state_67411[(2)]);
var inst_67399 = cljs.core.assoc.call(null,inst_67312,inst_67323,inst_67398);
var state_67411__$1 = state_67411;
var statearr_67440_67512 = state_67411__$1;
(statearr_67440_67512[(2)] = inst_67399);

(statearr_67440_67512[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (6))){
var inst_67309 = (state_67411[(19)]);
var inst_67324 = (state_67411[(20)]);
var inst_67320 = cljs.core.seq.call(null,inst_67309);
var inst_67321 = cljs.core.first.call(null,inst_67320);
var inst_67322 = cljs.core.next.call(null,inst_67320);
var inst_67323 = cljs.core.nth.call(null,inst_67321,(0),null);
var inst_67324__$1 = cljs.core.nth.call(null,inst_67321,(1),null);
var inst_67325 = (inst_67324__$1 == null);
var state_67411__$1 = (function (){var statearr_67441 = state_67411;
(statearr_67441[(17)] = inst_67322);

(statearr_67441[(20)] = inst_67324__$1);

(statearr_67441[(11)] = inst_67323);

return statearr_67441;
})();
if(cljs.core.truth_(inst_67325)){
var statearr_67442_67513 = state_67411__$1;
(statearr_67442_67513[(1)] = (8));

} else {
var statearr_67443_67514 = state_67411__$1;
(statearr_67443_67514[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (28))){
var inst_67310 = (state_67411[(12)]);
var inst_67361 = cljs.core._EQ_.call(null,(207),inst_67310);
var state_67411__$1 = state_67411;
var statearr_67444_67515 = state_67411__$1;
(statearr_67444_67515[(2)] = inst_67361);

(statearr_67444_67515[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (25))){
var inst_67358 = (state_67411[(7)]);
var inst_67310 = (state_67411[(12)]);
var inst_67358__$1 = cljs.core._EQ_.call(null,(200),inst_67310);
var state_67411__$1 = (function (){var statearr_67445 = state_67411;
(statearr_67445[(7)] = inst_67358__$1);

return statearr_67445;
})();
if(inst_67358__$1){
var statearr_67446_67516 = state_67411__$1;
(statearr_67446_67516[(1)] = (27));

} else {
var statearr_67447_67517 = state_67411__$1;
(statearr_67447_67517[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (34))){
var state_67411__$1 = state_67411;
var statearr_67448_67518 = state_67411__$1;
(statearr_67448_67518[(2)] = null);

(statearr_67448_67518[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (17))){
var inst_67342 = (state_67411[(21)]);
var inst_67381 = (state_67411[(2)]);
var state_67411__$1 = (function (){var statearr_67449 = state_67411;
(statearr_67449[(16)] = inst_67381);

return statearr_67449;
})();
if(cljs.core.truth_(inst_67342)){
var statearr_67450_67519 = state_67411__$1;
(statearr_67450_67519[(1)] = (36));

} else {
var statearr_67451_67520 = state_67411__$1;
(statearr_67451_67520[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (3))){
var inst_67409 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67411__$1,inst_67409);
} else {
if((state_val_67412 === (12))){
var inst_67312 = (state_67411[(9)]);
var state_67411__$1 = state_67411;
var statearr_67452_67521 = state_67411__$1;
(statearr_67452_67521[(2)] = inst_67312);

(statearr_67452_67521[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (2))){
var inst_67286 = (state_67411[(22)]);
var inst_67285 = (state_67411[(23)]);
var inst_67281 = (state_67411[(24)]);
var _ = (function (){var statearr_67453 = state_67411;
(statearr_67453[(4)] = cljs.core.cons.call(null,(5),(state_67411[(4)])));

return statearr_67453;
})();
var inst_67277 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_67278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67279 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_67280 = (new cljs.core.PersistentVector(null,2,(5),inst_67278,inst_67279,null));
var inst_67281__$1 = cljs.core.get_in.call(null,flureeQL,inst_67280);
var inst_67282 = (function (){var global_block = inst_67277;
var global_meta_QMARK_ = inst_67281__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_67283 = cljs.core.PersistentHashMap.EMPTY;
var inst_67284 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_67285__$1 = cljs.core.reduce_kv.call(null,inst_67282,inst_67283,inst_67284);
var inst_67286__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_67288 = (function (){var global_block = inst_67277;
var global_meta_QMARK_ = inst_67281__$1;
var queries = inst_67285__$1;
var start_time = inst_67286__$1;
return (function (p__67287){
var vec__67454 = p__67287;
var alias = cljs.core.nth.call(null,vec__67454,(0),null);
var q = cljs.core.nth.call(null,vec__67454,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_67289 = cljs.core.map.call(null,inst_67288,inst_67285__$1);
var inst_67303 = cljs.core.seq.call(null,inst_67289);
var inst_67304 = cljs.core.first.call(null,inst_67303);
var inst_67305 = cljs.core.next.call(null,inst_67303);
var inst_67306 = cljs.core.nth.call(null,inst_67304,(0),null);
var inst_67307 = cljs.core.nth.call(null,inst_67304,(1),null);
var inst_67308 = cljs.core.PersistentHashMap.EMPTY;
var inst_67309 = inst_67289;
var inst_67310 = null;
var inst_67311 = (0);
var inst_67312 = inst_67308;
var state_67411__$1 = (function (){var statearr_67457 = state_67411;
(statearr_67457[(9)] = inst_67312);

(statearr_67457[(19)] = inst_67309);

(statearr_67457[(12)] = inst_67310);

(statearr_67457[(22)] = inst_67286__$1);

(statearr_67457[(23)] = inst_67285__$1);

(statearr_67457[(15)] = inst_67311);

(statearr_67457[(25)] = inst_67307);

(statearr_67457[(26)] = inst_67305);

(statearr_67457[(24)] = inst_67281__$1);

(statearr_67457[(27)] = inst_67306);

return statearr_67457;
})();
var statearr_67458_67522 = state_67411__$1;
(statearr_67458_67522[(2)] = null);

(statearr_67458_67522[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (23))){
var inst_67376 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67459_67523 = state_67411__$1;
(statearr_67459_67523[(2)] = inst_67376);

(statearr_67459_67523[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (35))){
var inst_67372 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67460_67524 = state_67411__$1;
(statearr_67460_67524[(2)] = inst_67372);

(statearr_67460_67524[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (19))){
var inst_67310 = (state_67411[(12)]);
var inst_67348 = (state_67411[(13)]);
var inst_67352 = cljs.core._EQ_.call(null,inst_67310,inst_67348);
var state_67411__$1 = state_67411;
if(inst_67352){
var statearr_67461_67525 = state_67411__$1;
(statearr_67461_67525[(1)] = (21));

} else {
var statearr_67462_67526 = state_67411__$1;
(statearr_67462_67526[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (11))){
var inst_67312 = (state_67411[(9)]);
var inst_67310 = (state_67411[(12)]);
var inst_67286 = (state_67411[(22)]);
var inst_67311 = (state_67411[(15)]);
var inst_67328 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_67329 = fluree.db.util.core.response_time_formatted.call(null,inst_67286);
var inst_67330 = [inst_67312,inst_67311,inst_67310,inst_67329];
var inst_67331 = cljs.core.PersistentHashMap.fromArrays(inst_67328,inst_67330);
var state_67411__$1 = state_67411;
var statearr_67464_67527 = state_67411__$1;
(statearr_67464_67527[(2)] = inst_67331);

(statearr_67464_67527[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (9))){
var inst_67285 = (state_67411[(23)]);
var inst_67324 = (state_67411[(20)]);
var inst_67323 = (state_67411[(11)]);
var inst_67337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67338 = [inst_67323,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_67339 = (new cljs.core.PersistentVector(null,2,(5),inst_67337,inst_67338,null));
var inst_67340 = cljs.core.get_in.call(null,inst_67285,inst_67339);
var inst_67341 = cljs.core.__destructure_map.call(null,inst_67340);
var inst_67342 = cljs.core.get.call(null,inst_67341,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_67343 = cljs.core.get.call(null,inst_67341,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_67411__$1 = (function (){var statearr_67465 = state_67411;
(statearr_67465[(14)] = inst_67343);

(statearr_67465[(21)] = inst_67342);

return statearr_67465;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67411__$1,(14),inst_67324);
} else {
if((state_val_67412 === (5))){
var _ = (function (){var statearr_67466 = state_67411;
(statearr_67466[(4)] = cljs.core.rest.call(null,(state_67411[(4)])));

return statearr_67466;
})();
var state_67411__$1 = state_67411;
var ex67463 = (state_67411__$1[(2)]);
var statearr_67467_67528 = state_67411__$1;
(statearr_67467_67528[(5)] = ex67463);


var statearr_67468_67529 = state_67411__$1;
(statearr_67468_67529[(1)] = (4));

(statearr_67468_67529[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (14))){
var inst_67342 = (state_67411[(21)]);
var inst_67345 = (state_67411[(10)]);
var inst_67345__$1 = (state_67411[(2)]);
var inst_67346 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_67345__$1);
var state_67411__$1 = (function (){var statearr_67469 = state_67411;
(statearr_67469[(28)] = inst_67346);

(statearr_67469[(10)] = inst_67345__$1);

return statearr_67469;
})();
if(cljs.core.truth_(inst_67342)){
var statearr_67470_67530 = state_67411__$1;
(statearr_67470_67530[(1)] = (15));

} else {
var statearr_67471_67531 = state_67411__$1;
(statearr_67471_67531[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (26))){
var inst_67365 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
if(cljs.core.truth_(inst_67365)){
var statearr_67472_67532 = state_67411__$1;
(statearr_67472_67532[(1)] = (30));

} else {
var statearr_67473_67533 = state_67411__$1;
(statearr_67473_67533[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (16))){
var state_67411__$1 = state_67411;
var statearr_67474_67534 = state_67411__$1;
(statearr_67474_67534[(2)] = null);

(statearr_67474_67534[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (38))){
var inst_67346 = (state_67411[(28)]);
var inst_67387 = (state_67411[(2)]);
var state_67411__$1 = (function (){var statearr_67475 = state_67411;
(statearr_67475[(18)] = inst_67387);

return statearr_67475;
})();
if(cljs.core.truth_(inst_67346)){
var statearr_67476_67535 = state_67411__$1;
(statearr_67476_67535[(1)] = (39));

} else {
var statearr_67477_67536 = state_67411__$1;
(statearr_67477_67536[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (30))){
var state_67411__$1 = state_67411;
var statearr_67478_67537 = state_67411__$1;
(statearr_67478_67537[(2)] = (207));

(statearr_67478_67537[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (10))){
var inst_67404 = (state_67411[(2)]);
var state_67411__$1 = state_67411;
var statearr_67479_67538 = state_67411__$1;
(statearr_67479_67538[(2)] = inst_67404);

(statearr_67479_67538[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (18))){
var inst_67348 = (state_67411[(13)]);
var state_67411__$1 = state_67411;
var statearr_67480_67539 = state_67411__$1;
(statearr_67480_67539[(2)] = inst_67348);

(statearr_67480_67539[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (42))){
var inst_67345 = (state_67411[(10)]);
var inst_67395 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_67345);
var state_67411__$1 = state_67411;
var statearr_67481_67540 = state_67411__$1;
(statearr_67481_67540[(2)] = inst_67395);

(statearr_67481_67540[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (37))){
var state_67411__$1 = state_67411;
var statearr_67482_67541 = state_67411__$1;
(statearr_67482_67541[(2)] = null);

(statearr_67482_67541[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67412 === (8))){
var inst_67281 = (state_67411[(24)]);
var state_67411__$1 = state_67411;
if(cljs.core.truth_(inst_67281)){
var statearr_67483_67542 = state_67411__$1;
(statearr_67483_67542[(1)] = (11));

} else {
var statearr_67484_67543 = state_67411__$1;
(statearr_67484_67543[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0 = (function (){
var statearr_67485 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67485[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__);

(statearr_67485[(1)] = (1));

return statearr_67485;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1 = (function (state_67411){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_67411);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e67486){var ex__2749__auto__ = e67486;
var statearr_67487_67544 = state_67411;
(statearr_67487_67544[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_67411[(4)]))){
var statearr_67488_67545 = state_67411;
(statearr_67488_67545[(1)] = cljs.core.first.call(null,(state_67411[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67546 = state_67411;
state_67411 = G__67546;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__ = function(state_67411){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1.call(this,state_67411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2746__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_67489 = f__2769__auto__.call(null);
(statearr_67489[(6)] = c__2768__auto__);

return statearr_67489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__67547 = query_type;
var G__67547__$1 = (((G__67547 instanceof cljs.core.Keyword))?G__67547.fqn:null);
switch (G__67547__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67547__$1)].join('')));

}
});
