// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('cljs.analyzer.impl.namespaces');
goog.require('cljs.core');
/**
 * Given a libspec return a map of :as-alias alias, if was present. Return the
 * libspec with :as-alias elided. If the libspec was *only* :as-alias do not
 * return it.
 */
cljs.analyzer.impl.namespaces.check_and_remove_as_alias = (function cljs$analyzer$impl$namespaces$check_and_remove_as_alias(libspec){
if((((libspec instanceof cljs.core.Symbol)) || ((libspec instanceof cljs.core.Keyword)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec], null);
} else {
var vec__4245 = libspec;
var seq__4246 = cljs.core.seq.call(null,vec__4245);
var first__4247 = cljs.core.first.call(null,seq__4246);
var seq__4246__$1 = cljs.core.next.call(null,seq__4246);
var lib = first__4247;
var spec = seq__4246__$1;
var libspec__$1 = vec__4245;
var vec__4248 = cljs.core.split_with.call(null,cljs.core.complement.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),null], null), null)),spec);
var pre_spec = cljs.core.nth.call(null,vec__4248,(0),null);
var vec__4251 = cljs.core.nth.call(null,vec__4248,(1),null);
var seq__4252 = cljs.core.seq.call(null,vec__4251);
var first__4253 = cljs.core.first.call(null,seq__4252);
var seq__4252__$1 = cljs.core.next.call(null,seq__4252);
var _ = first__4253;
var first__4253__$1 = cljs.core.first.call(null,seq__4252__$1);
var seq__4252__$2 = cljs.core.next.call(null,seq__4252__$1);
var alias = first__4253__$1;
var post_spec = seq__4252__$2;
var post = vec__4251;
if(cljs.core.seq.call(null,post)){
var libspec_SINGLEQUOTE_ = cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib], null),cljs.core.concat.call(null,pre_spec,post_spec));
if((alias instanceof cljs.core.Symbol)){
} else {
throw (new Error(["Assert failed: ",[":as-alias must be followed by a symbol, got: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias)].join(''),"\n","(symbol? alias)"].join('')));
}

var G__4254 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as-alias","as-alias",82482467),cljs.core.PersistentArrayMap.createAsIfByAssoc([alias,lib])], null);
if((cljs.core.count.call(null,libspec_SINGLEQUOTE_) > (1))){
return cljs.core.assoc.call(null,G__4254,new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec_SINGLEQUOTE_);
} else {
return G__4254;
}
} else {
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"libspec","libspec",1228503756),libspec__$1], null);
}
}
});
cljs.analyzer.impl.namespaces.check_as_alias_duplicates = (function cljs$analyzer$impl$namespaces$check_as_alias_duplicates(as_aliases,new_as_aliases){
var seq__4255 = cljs.core.seq.call(null,new_as_aliases);
var chunk__4256 = null;
var count__4257 = (0);
var i__4258 = (0);
while(true){
if((i__4258 < count__4257)){
var vec__4265 = cljs.core._nth.call(null,chunk__4256,i__4258);
var alias = cljs.core.nth.call(null,vec__4265,(0),null);
var _ = cljs.core.nth.call(null,vec__4265,(1),null);
if((!(cljs.core.contains_QMARK_.call(null,as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4271 = seq__4255;
var G__4272 = chunk__4256;
var G__4273 = count__4257;
var G__4274 = (i__4258 + (1));
seq__4255 = G__4271;
chunk__4256 = G__4272;
count__4257 = G__4273;
i__4258 = G__4274;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__4255);
if(temp__5804__auto__){
var seq__4255__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4255__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__4255__$1);
var G__4275 = cljs.core.chunk_rest.call(null,seq__4255__$1);
var G__4276 = c__5568__auto__;
var G__4277 = cljs.core.count.call(null,c__5568__auto__);
var G__4278 = (0);
seq__4255 = G__4275;
chunk__4256 = G__4276;
count__4257 = G__4277;
i__4258 = G__4278;
continue;
} else {
var vec__4268 = cljs.core.first.call(null,seq__4255__$1);
var alias = cljs.core.nth.call(null,vec__4268,(0),null);
var _ = cljs.core.nth.call(null,vec__4268,(1),null);
if((!(cljs.core.contains_QMARK_.call(null,as_aliases,alias)))){
} else {
throw (new Error(["Assert failed: ",["Duplicate :as-alias ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(alias),", already in use for lib ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,as_aliases,alias))].join(''),"\n","(not (contains? as-aliases alias))"].join('')));
}


var G__4279 = cljs.core.next.call(null,seq__4255__$1);
var G__4280 = null;
var G__4281 = (0);
var G__4282 = (0);
seq__4255 = G__4279;
chunk__4256 = G__4280;
count__4257 = G__4281;
i__4258 = G__4282;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Given libspecs, elide all :as-alias. Return a map of :libspecs (filtered)
 * and :as-aliases.
 */
cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_libspecs(var_args){
var G__4284 = arguments.length;
switch (G__4284) {
case 1:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$1 = (function (libspecs){
return cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.call(null,libspecs,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$core$IFn$_invoke$arity$2 = (function (libspecs,as_aliases){
var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),as_aliases,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.call(null,(function (ret__$1,libspec){
var map__4285 = cljs.analyzer.impl.namespaces.check_and_remove_as_alias.call(null,libspec);
var map__4285__$1 = cljs.core.__destructure_map.call(null,map__4285);
var as_alias = cljs.core.get.call(null,map__4285__$1,new cljs.core.Keyword(null,"as-alias","as-alias",82482467));
var libspec__$1 = cljs.core.get.call(null,map__4285__$1,new cljs.core.Keyword(null,"libspec","libspec",1228503756));
cljs.analyzer.impl.namespaces.check_as_alias_duplicates.call(null,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798).cljs$core$IFn$_invoke$arity$1(ret__$1),as_alias);

var G__4286 = ret__$1;
var G__4286__$1 = (cljs.core.truth_(libspec__$1)?cljs.core.update.call(null,G__4286,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,libspec__$1):G__4286);
if(cljs.core.truth_(as_alias)){
return cljs.core.update.call(null,G__4286__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_alias);
} else {
return G__4286__$1;
}
}),ret,libspecs);
}));

(cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.cljs$lang$maxFixedArity = 2);

cljs.analyzer.impl.namespaces.elide_aliases_from_ns_specs = (function cljs$analyzer$impl$namespaces$elide_aliases_from_ns_specs(ns_specs){

var ret = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.PersistentVector.EMPTY], null);
return cljs.core.reduce.call(null,(function (p__4288,p__4289){
var map__4290 = p__4288;
var map__4290__$1 = cljs.core.__destructure_map.call(null,map__4290);
var ret__$1 = map__4290__$1;
var as_aliases = cljs.core.get.call(null,map__4290__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var vec__4291 = p__4289;
var seq__4292 = cljs.core.seq.call(null,vec__4291);
var first__4293 = cljs.core.first.call(null,seq__4292);
var seq__4292__$1 = cljs.core.next.call(null,seq__4292);
var spec_key = first__4293;
var libspecs = seq__4292__$1;
if((!(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"refer-clojure","refer-clojure",813784440),spec_key)))){
var map__4294 = cljs.analyzer.impl.namespaces.elide_aliases_from_libspecs.call(null,libspecs,as_aliases);
var map__4294__$1 = cljs.core.__destructure_map.call(null,map__4294);
var as_aliases__$1 = cljs.core.get.call(null,map__4294__$1,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798));
var libspecs__$1 = cljs.core.get.call(null,map__4294__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195));
var G__4295 = ret__$1;
var G__4295__$1 = (((!(cljs.core.empty_QMARK_.call(null,as_aliases__$1))))?cljs.core.update.call(null,G__4295,new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798),cljs.core.merge,as_aliases__$1):G__4295);
if((!(cljs.core.empty_QMARK_.call(null,libspecs__$1)))){
return cljs.core.update.call(null,G__4295__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.call(null,spec_key,libspecs__$1));
} else {
return G__4295__$1;
}
} else {
return cljs.core.update.call(null,ret__$1,new cljs.core.Keyword(null,"libspecs","libspecs",59807195),cljs.core.conj,cljs.core.list_STAR_.call(null,spec_key,libspecs));
}
}),ret,ns_specs);
});
