// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.common');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.schema');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.query.fql_resp');
/**
 * Transducing function to extract matching subjects from initial where clause.
 */
fluree.db.query.subject_crawl.common.where_subj_xf = (function fluree$db$query$subject_crawl$common$where_subj_xf(p__23588){
var map__23589 = p__23588;
var map__23589__$1 = cljs.core.__destructure_map(map__23589);
var start_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23589__$1,new cljs.core.Keyword(null,"start-test","start-test",-952983565));
var start_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23589__$1,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803));
var end_test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23589__$1,new cljs.core.Keyword(null,"end-test","end-test",481973727));
var end_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23589__$1,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179));
var xf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23589__$1,new cljs.core.Keyword(null,"xf","xf",401902988));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,(function (){var G__23590 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"flakes","flakes",1977895739)),cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (flakes){
return fluree.db.flake.subrange.cljs$core$IFn$_invoke$arity$5(flakes,start_test,start_flake,end_test,end_flake);
}))], null);
if(cljs.core.truth_(xf)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__23590,xf);
} else {
return G__23590;
}
})());
});
fluree.db.query.subject_crawl.common.result_af = (function fluree$db$query$subject_crawl$common$result_af(p__23591){
var map__23592 = p__23591;
var map__23592__$1 = cljs.core.__destructure_map(map__23592);
var _opts = map__23592__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23592__$1,new cljs.core.Keyword(null,"db","db",993250759));
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23592__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var fuel_vol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23592__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23592__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var select_spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23592__$1,new cljs.core.Keyword(null,"select-spec","select-spec",55073283));
var error_ch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23592__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
return (function (flakes,port){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23623){
var state_val_23624 = (state_23623[(1)]);
if((state_val_23624 === (7))){
var state_23623__$1 = state_23623;
var statearr_23625_23651 = state_23623__$1;
(statearr_23625_23651[(2)] = null);

(statearr_23625_23651[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (1))){
var state_23623__$1 = state_23623;
var statearr_23626_23652 = state_23623__$1;
(statearr_23626_23652[(2)] = null);

(statearr_23626_23652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (4))){
var inst_23593 = (state_23623[(2)]);
var inst_23594 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(error_ch,inst_23593);
var inst_23595 = cljs.core.async.close_BANG_(port);
var state_23623__$1 = (function (){var statearr_23627 = state_23623;
(statearr_23627[(7)] = inst_23595);

(statearr_23627[(8)] = inst_23594);

return statearr_23627;
})();
var statearr_23628_23653 = state_23623__$1;
(statearr_23628_23653[(2)] = null);

(statearr_23628_23653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (6))){
var inst_23605 = (state_23623[(9)]);
var inst_23604 = (state_23623[(2)]);
var inst_23605__$1 = fluree.db.util.async.throw_err(inst_23604);
var inst_23606 = (inst_23605__$1 == null);
var state_23623__$1 = (function (){var statearr_23629 = state_23623;
(statearr_23629[(9)] = inst_23605__$1);

return statearr_23629;
})();
if(cljs.core.truth_(inst_23606)){
var statearr_23630_23654 = state_23623__$1;
(statearr_23630_23654[(1)] = (7));

} else {
var statearr_23631_23655 = state_23623__$1;
(statearr_23631_23655[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (3))){
var inst_23621 = (state_23623[(2)]);
var state_23623__$1 = state_23623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23623__$1,inst_23621);
} else {
if((state_val_23624 === (12))){
var inst_23617 = (state_23623[(2)]);
var inst_23618 = cljs.core.async.close_BANG_(port);
var _ = (function (){var statearr_23632 = state_23623;
(statearr_23632[(4)] = cljs.core.rest((state_23623[(4)])));

return statearr_23632;
})();
var state_23623__$1 = (function (){var statearr_23633 = state_23623;
(statearr_23633[(10)] = inst_23617);

return statearr_23633;
})();
var statearr_23634_23656 = state_23623__$1;
(statearr_23634_23656[(2)] = inst_23618);

(statearr_23634_23656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (2))){
var _ = (function (){var statearr_23635 = state_23623;
(statearr_23635[(4)] = cljs.core.cons((5),(state_23623[(4)])));

return statearr_23635;
})();
var inst_23602 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel_vol,max_fuel,select_spec,flakes);
var state_23623__$1 = state_23623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23623__$1,(6),inst_23602);
} else {
if((state_val_23624 === (11))){
var inst_23611 = (state_23623[(11)]);
var inst_23615 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_23611);
var state_23623__$1 = state_23623;
var statearr_23637_23657 = state_23623__$1;
(statearr_23637_23657[(2)] = inst_23615);

(statearr_23637_23657[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (9))){
var inst_23611 = (state_23623[(11)]);
var inst_23611__$1 = (state_23623[(2)]);
var inst_23612 = (inst_23611__$1 == null);
var state_23623__$1 = (function (){var statearr_23638 = state_23623;
(statearr_23638[(11)] = inst_23611__$1);

return statearr_23638;
})();
if(cljs.core.truth_(inst_23612)){
var statearr_23639_23658 = state_23623__$1;
(statearr_23639_23658[(1)] = (10));

} else {
var statearr_23640_23659 = state_23623__$1;
(statearr_23640_23659[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (5))){
var _ = (function (){var statearr_23641 = state_23623;
(statearr_23641[(4)] = cljs.core.rest((state_23623[(4)])));

return statearr_23641;
})();
var state_23623__$1 = state_23623;
var ex23636 = (state_23623__$1[(2)]);
var statearr_23642_23660 = state_23623__$1;
(statearr_23642_23660[(5)] = ex23636);


var statearr_23643_23661 = state_23623__$1;
(statearr_23643_23661[(1)] = (4));

(statearr_23643_23661[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (10))){
var state_23623__$1 = state_23623;
var statearr_23644_23662 = state_23623__$1;
(statearr_23644_23662[(2)] = null);

(statearr_23644_23662[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23624 === (8))){
var inst_23605 = (state_23623[(9)]);
var inst_23609 = cljs.core.not_empty(inst_23605);
var state_23623__$1 = state_23623;
var statearr_23645_23663 = state_23623__$1;
(statearr_23645_23663[(2)] = inst_23609);

(statearr_23645_23663[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0 = (function (){
var statearr_23646 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23646[(0)] = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__);

(statearr_23646[(1)] = (1));

return statearr_23646;
});
var fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1 = (function (state_23623){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23623);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23647){var ex__2687__auto__ = e23647;
var statearr_23648_23664 = state_23623;
(statearr_23648_23664[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23623[(4)]))){
var statearr_23649_23665 = state_23623;
(statearr_23649_23665[(1)] = cljs.core.first((state_23623[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23666 = state_23623;
state_23623 = G__23666;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__ = function(state_23623){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1.call(this,state_23623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$result_af_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23650 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23650[(6)] = c__2706__auto__);

return statearr_23650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
});
/**
 * Returns a specific filtering function which takes all subject flakes and
 *   returns the flakes allowed, or nil if none are allowed.
 */
fluree.db.query.subject_crawl.common.subj_perm_filter_fn = (function fluree$db$query$subject_crawl$common$subj_perm_filter_fn(p__23667){
var map__23668 = p__23667;
var map__23668__$1 = cljs.core.__destructure_map(map__23668);
var db = map__23668__$1;
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23668__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var pred_permissions_QMARK_ = cljs.core.contains_QMARK_(permissions,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
var coll_permissions = new cljs.core.Keyword(null,"collection","collection",-683361892).cljs$core$IFn$_invoke$arity$1(permissions);
var filter_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var default_deny_QMARK_ = ((new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(coll_permissions) === true)?false:true);
var filter_predicates_QMARK_ = (function (cid){
var temp__5806__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(filter_cache),cid);
if((temp__5806__auto__ == null)){
var coll_perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll_permissions,cid);
var filter_QMARK_ = ((fluree.db.util.schema.is_schema_cid_QMARK_(cid))?false:((pred_permissions_QMARK_)?true:(((coll_perm == null))?default_deny_QMARK_:((((cljs.core.contains_QMARK_(coll_perm,new cljs.core.Keyword(null,"all","all",892129742))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(coll_perm)))))?false:true
))));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(filter_cache,cljs.core.assoc,cid,filter_QMARK_);

return cljs.core.filter;
} else {
var cached = temp__5806__auto__;
return cached;
}
});
return (function (flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23699){
var state_val_23700 = (state_23699[(1)]);
if((state_val_23700 === (7))){
var inst_23675 = (state_23699[(7)]);
var inst_23685 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_23675);
var state_23699__$1 = state_23699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23699__$1,(10),inst_23685);
} else {
if((state_val_23700 === (1))){
var state_23699__$1 = state_23699;
var statearr_23701_23724 = state_23699__$1;
(statearr_23701_23724[(2)] = null);

(statearr_23701_23724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (4))){
var inst_23669 = (state_23699[(2)]);
var state_23699__$1 = state_23699;
var statearr_23702_23725 = state_23699__$1;
(statearr_23702_23725[(2)] = inst_23669);

(statearr_23702_23725[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (13))){
var inst_23692 = (state_23699[(2)]);
var state_23699__$1 = state_23699;
var statearr_23703_23726 = state_23699__$1;
(statearr_23703_23726[(2)] = inst_23692);

(statearr_23703_23726[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (6))){
var inst_23680 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,flakes);
var state_23699__$1 = state_23699;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23699__$1,(9),inst_23680);
} else {
if((state_val_23700 === (3))){
var inst_23697 = (state_23699[(2)]);
var state_23699__$1 = state_23699;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23699__$1,inst_23697);
} else {
if((state_val_23700 === (12))){
var state_23699__$1 = state_23699;
var statearr_23704_23727 = state_23699__$1;
(statearr_23704_23727[(2)] = null);

(statearr_23704_23727[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (2))){
var inst_23675 = (state_23699[(7)]);
var _ = (function (){var statearr_23705 = state_23699;
(statearr_23705[(4)] = cljs.core.cons((5),(state_23699[(4)])));

return statearr_23705;
})();
var inst_23675__$1 = cljs.core.first(flakes);
var inst_23676 = fluree.db.flake.s(inst_23675__$1);
var inst_23677 = fluree.db.flake.sid__GT_cid(inst_23676);
var inst_23678 = filter_predicates_QMARK_(inst_23677);
var state_23699__$1 = (function (){var statearr_23706 = state_23699;
(statearr_23706[(7)] = inst_23675__$1);

return statearr_23706;
})();
if(cljs.core.truth_(inst_23678)){
var statearr_23707_23728 = state_23699__$1;
(statearr_23707_23728[(1)] = (6));

} else {
var statearr_23708_23729 = state_23699__$1;
(statearr_23708_23729[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (11))){
var state_23699__$1 = state_23699;
var statearr_23710_23730 = state_23699__$1;
(statearr_23710_23730[(2)] = flakes);

(statearr_23710_23730[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (9))){
var inst_23682 = (state_23699[(2)]);
var inst_23683 = fluree.db.util.async.throw_err(inst_23682);
var state_23699__$1 = state_23699;
var statearr_23711_23731 = state_23699__$1;
(statearr_23711_23731[(2)] = inst_23683);

(statearr_23711_23731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (5))){
var _ = (function (){var statearr_23712 = state_23699;
(statearr_23712[(4)] = cljs.core.rest((state_23699[(4)])));

return statearr_23712;
})();
var state_23699__$1 = state_23699;
var ex23709 = (state_23699__$1[(2)]);
var statearr_23713_23732 = state_23699__$1;
(statearr_23713_23732[(5)] = ex23709);


if((ex23709 instanceof Error)){
var statearr_23714_23733 = state_23699__$1;
(statearr_23714_23733[(1)] = (4));

(statearr_23714_23733[(5)] = null);

} else {
throw ex23709;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (10))){
var inst_23687 = (state_23699[(2)]);
var inst_23688 = fluree.db.util.async.throw_err(inst_23687);
var state_23699__$1 = state_23699;
if(cljs.core.truth_(inst_23688)){
var statearr_23715_23734 = state_23699__$1;
(statearr_23715_23734[(1)] = (11));

} else {
var statearr_23716_23735 = state_23699__$1;
(statearr_23716_23735[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23700 === (8))){
var inst_23694 = (state_23699[(2)]);
var _ = (function (){var statearr_23717 = state_23699;
(statearr_23717[(4)] = cljs.core.rest((state_23699[(4)])));

return statearr_23717;
})();
var state_23699__$1 = state_23699;
var statearr_23718_23736 = state_23699__$1;
(statearr_23718_23736[(2)] = inst_23694);

(statearr_23718_23736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_23719 = [null,null,null,null,null,null,null,null];
(statearr_23719[(0)] = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__);

(statearr_23719[(1)] = (1));

return statearr_23719;
});
var fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1 = (function (state_23699){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23699);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23720){var ex__2687__auto__ = e23720;
var statearr_23721_23737 = state_23699;
(statearr_23721_23737[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23699[(4)]))){
var statearr_23722_23738 = state_23699;
(statearr_23722_23738[(1)] = cljs.core.first((state_23699[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23739 = state_23699;
state_23699 = G__23739;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__ = function(state_23699){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1.call(this,state_23699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$subj_perm_filter_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23723 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23723[(6)] = c__2706__auto__);

return statearr_23723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
});
fluree.db.query.subject_crawl.common.passes_filter_QMARK_ = (function fluree$db$query$subject_crawl$common$passes_filter_QMARK_(filter_fn,vars,pred_flakes){
return cljs.core.some((function (p1__23740_SHARP_){
return (filter_fn.cljs$core$IFn$_invoke$arity$2 ? filter_fn.cljs$core$IFn$_invoke$arity$2(p1__23740_SHARP_,vars) : filter_fn.call(null,p1__23740_SHARP_,vars));
}),pred_flakes);
});
/**
 * For a group of predicate flakes (all same .-p value)
 *   and a list of filter-functions, returns true if at least
 *   one of the predicates passes every function, else returns false.
 */
fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_ = (function fluree$db$query$subject_crawl$common$pass_all_filters_QMARK_(filter_fns,vars,pred_flakes){
var G__23744 = filter_fns;
var vec__23745 = G__23744;
var seq__23746 = cljs.core.seq(vec__23745);
var first__23747 = cljs.core.first(seq__23746);
var seq__23746__$1 = cljs.core.next(seq__23746);
var filter_fn = first__23747;
var r_fns = seq__23746__$1;
var G__23744__$1 = G__23744;
while(true){
var vec__23748 = G__23744__$1;
var seq__23749 = cljs.core.seq(vec__23748);
var first__23750 = cljs.core.first(seq__23749);
var seq__23749__$1 = cljs.core.next(seq__23749);
var filter_fn__$1 = first__23750;
var r_fns__$1 = seq__23749__$1;
if(cljs.core.truth_(filter_fn__$1)){
if(cljs.core.truth_(fluree.db.query.subject_crawl.common.passes_filter_QMARK_(filter_fn__$1,vars,pred_flakes))){
var G__23751 = r_fns__$1;
G__23744__$1 = G__23751;
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});
/**
 * Filters a set of flakes for a single subject and returns true if
 *   the subject meets the filter map.
 * 
 *   filter-map is a map where pred-ids are keys and values are a list of filtering functions
 *   where each flake of pred-id must return a truthy value if the subject is allowed.
 */
fluree.db.query.subject_crawl.common.filter_subject = (function fluree$db$query$subject_crawl$common$filter_subject(vars,filter_map,flakes){
var G__23755 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,flakes);
var vec__23756 = G__23755;
var seq__23757 = cljs.core.seq(vec__23756);
var first__23758 = cljs.core.first(seq__23757);
var seq__23757__$1 = cljs.core.next(seq__23757);
var p_flakes = first__23758;
var r = seq__23757__$1;
var required_p = new cljs.core.Keyword(null,"required-p","required-p",-2091946078).cljs$core$IFn$_invoke$arity$1(filter_map);
var G__23755__$1 = G__23755;
var required_p__$1 = required_p;
while(true){
var vec__23762 = G__23755__$1;
var seq__23763 = cljs.core.seq(vec__23762);
var first__23764 = cljs.core.first(seq__23763);
var seq__23763__$1 = cljs.core.next(seq__23763);
var p_flakes__$1 = first__23764;
var r__$1 = seq__23763__$1;
var required_p__$2 = required_p__$1;
if(cljs.core.truth_(p_flakes__$1)){
var p = fluree.db.flake.p(cljs.core.first(p_flakes__$1));
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(filter_map,p);
if(cljs.core.truth_(temp__5802__auto__)){
var filter_fns = temp__5802__auto__;
if(fluree.db.query.subject_crawl.common.pass_all_filters_QMARK_(filter_fns,vars,p_flakes__$1)){
var G__23765 = r__$1;
var G__23766 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23755__$1 = G__23765;
required_p__$1 = G__23766;
continue;
} else {
return null;
}
} else {
var G__23767 = r__$1;
var G__23768 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(required_p__$2,p);
G__23755__$1 = G__23767;
required_p__$1 = G__23768;
continue;
}
} else {
if(cljs.core.empty_QMARK_(required_p__$2)){
return flakes;
} else {
return null;
}
}
break;
}
});
/**
 * If order-by exists in query, orders final results.
 *   order-by is defined by a map with keys (see analytical-parse for code):
 *   - :type - :variable or :predicate
 *   - :order - :asc or :desc
 *   - :predicate - if type = :predicate, contains predicate pid or name
 *   - :variable - if type = :variable, contains variable name (not supported for simple subject crawl)
 */
fluree.db.query.subject_crawl.common.order_results = (function fluree$db$query$subject_crawl$common$order_results(results,p__23769,limit){
var map__23770 = p__23769;
var map__23770__$1 = cljs.core.__destructure_map(map__23770);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23770__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var order = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23770__$1,new cljs.core.Keyword(null,"order","order",-1254677256));
var predicate = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23770__$1,new cljs.core.Keyword(null,"predicate","predicate",-1742501860));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"variable","variable",-281346492),type)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Ordering by a variable not supported in this type of query.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
var sorted = (function (){var G__23771 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (result){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(result,predicate);
}),results);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"desc","desc",2093485764),order)){
return cljs.core.reverse(G__23771);
} else {
return G__23771;
}
})();
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,sorted));
}
});
/**
 * When some variables may be idents (two-tuples) they need to get resolved into
 *   subject _id values before executing query.
 */
fluree.db.query.subject_crawl.common.resolve_ident_vars = (function fluree$db$query$subject_crawl$common$resolve_ident_vars(db,vars,ident_vars){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_23841){
var state_val_23842 = (state_23841[(1)]);
if((state_val_23842 === (7))){
var inst_23836 = (state_23841[(2)]);
var _ = (function (){var statearr_23843 = state_23841;
(statearr_23843[(4)] = cljs.core.rest((state_23841[(4)])));

return statearr_23843;
})();
var state_23841__$1 = state_23841;
var statearr_23844_23886 = state_23841__$1;
(statearr_23844_23886[(2)] = inst_23836);

(statearr_23844_23886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (20))){
var inst_23791 = (state_23841[(7)]);
var inst_23798 = (state_23841[(8)]);
var inst_23797 = (state_23841[(9)]);
var inst_23814 = (state_23841[(2)]);
var inst_23815 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23791,inst_23797,inst_23814);
var inst_23790 = inst_23798;
var inst_23791__$1 = inst_23815;
var state_23841__$1 = (function (){var statearr_23845 = state_23841;
(statearr_23845[(7)] = inst_23791__$1);

(statearr_23845[(10)] = inst_23790);

return statearr_23845;
})();
var statearr_23846_23887 = state_23841__$1;
(statearr_23846_23887[(2)] = null);

(statearr_23846_23887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (1))){
var state_23841__$1 = state_23841;
var statearr_23847_23888 = state_23841__$1;
(statearr_23847_23888[(2)] = null);

(statearr_23847_23888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (4))){
var inst_23772 = (state_23841[(2)]);
var state_23841__$1 = state_23841;
var statearr_23848_23889 = state_23841__$1;
(statearr_23848_23889[(2)] = inst_23772);

(statearr_23848_23889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (15))){
var state_23841__$1 = state_23841;
var statearr_23849_23890 = state_23841__$1;
(statearr_23849_23890[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (21))){
var inst_23797 = (state_23841[(9)]);
var inst_23800 = (state_23841[(11)]);
var inst_23819 = ["Invalid identity provided in variable: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23797),". Must be a two-tuple identity, IRI, or integer id. ","Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23800)].join('');
var inst_23820 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23821 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23822 = cljs.core.PersistentHashMap.fromArrays(inst_23820,inst_23821);
var inst_23823 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23819,inst_23822);
var inst_23824 = (function(){throw inst_23823})();
var state_23841__$1 = state_23841;
var statearr_23851_23891 = state_23841__$1;
(statearr_23851_23891[(2)] = inst_23824);

(statearr_23851_23891[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (13))){
var inst_23831 = (state_23841[(2)]);
var state_23841__$1 = state_23841;
var statearr_23852_23892 = state_23841__$1;
(statearr_23852_23892[(2)] = inst_23831);

(statearr_23852_23892[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (22))){
var state_23841__$1 = state_23841;
var statearr_23853_23893 = state_23841__$1;
(statearr_23853_23893[(2)] = null);

(statearr_23853_23893[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (6))){
var inst_23797 = (state_23841[(9)]);
var inst_23790 = (state_23841[(10)]);
var inst_23796 = cljs.core.seq(inst_23790);
var inst_23797__$1 = cljs.core.first(inst_23796);
var inst_23798 = cljs.core.next(inst_23796);
var state_23841__$1 = (function (){var statearr_23854 = state_23841;
(statearr_23854[(8)] = inst_23798);

(statearr_23854[(9)] = inst_23797__$1);

return statearr_23854;
})();
if(cljs.core.truth_(inst_23797__$1)){
var statearr_23855_23894 = state_23841__$1;
(statearr_23855_23894[(1)] = (8));

} else {
var statearr_23856_23895 = state_23841__$1;
(statearr_23856_23895[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (17))){
var inst_23810 = (state_23841[(12)]);
var inst_23809 = (state_23841[(2)]);
var inst_23810__$1 = fluree.db.util.async.throw_err(inst_23809);
var state_23841__$1 = (function (){var statearr_23857 = state_23841;
(statearr_23857[(12)] = inst_23810__$1);

return statearr_23857;
})();
if(cljs.core.truth_(inst_23810__$1)){
var statearr_23858_23896 = state_23841__$1;
(statearr_23858_23896[(1)] = (18));

} else {
var statearr_23859_23897 = state_23841__$1;
(statearr_23859_23897[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (3))){
var inst_23839 = (state_23841[(2)]);
var state_23841__$1 = state_23841;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23841__$1,inst_23839);
} else {
if((state_val_23842 === (12))){
var inst_23800 = (state_23841[(11)]);
var inst_23805 = fluree.db.util.core.pred_ident_QMARK_(inst_23800);
var state_23841__$1 = state_23841;
if(inst_23805){
var statearr_23860_23898 = state_23841__$1;
(statearr_23860_23898[(1)] = (14));

} else {
var statearr_23861_23899 = state_23841__$1;
(statearr_23861_23899[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (2))){
var _ = (function (){var statearr_23862 = state_23841;
(statearr_23862[(4)] = cljs.core.cons((5),(state_23841[(4)])));

return statearr_23862;
})();
var inst_23785 = ident_vars;
var inst_23786 = cljs.core.seq(inst_23785);
var inst_23787 = cljs.core.first(inst_23786);
var inst_23788 = cljs.core.next(inst_23786);
var inst_23789 = vars;
var inst_23790 = inst_23785;
var inst_23791 = inst_23789;
var state_23841__$1 = (function (){var statearr_23863 = state_23841;
(statearr_23863[(13)] = inst_23787);

(statearr_23863[(7)] = inst_23791);

(statearr_23863[(14)] = inst_23788);

(statearr_23863[(10)] = inst_23790);

return statearr_23863;
})();
var statearr_23864_23900 = state_23841__$1;
(statearr_23864_23900[(2)] = null);

(statearr_23864_23900[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (23))){
var inst_23827 = (state_23841[(2)]);
var state_23841__$1 = state_23841;
var statearr_23866_23901 = state_23841__$1;
(statearr_23866_23901[(2)] = inst_23827);

(statearr_23866_23901[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (19))){
var state_23841__$1 = state_23841;
var statearr_23867_23902 = state_23841__$1;
(statearr_23867_23902[(2)] = (0));

(statearr_23867_23902[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (11))){
var inst_23791 = (state_23841[(7)]);
var inst_23798 = (state_23841[(8)]);
var tmp23865 = inst_23791;
var inst_23790 = inst_23798;
var inst_23791__$1 = tmp23865;
var state_23841__$1 = (function (){var statearr_23869 = state_23841;
(statearr_23869[(7)] = inst_23791__$1);

(statearr_23869[(10)] = inst_23790);

return statearr_23869;
})();
var statearr_23870_23903 = state_23841__$1;
(statearr_23870_23903[(2)] = null);

(statearr_23870_23903[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (9))){
var inst_23791 = (state_23841[(7)]);
var state_23841__$1 = state_23841;
var statearr_23871_23904 = state_23841__$1;
(statearr_23871_23904[(2)] = inst_23791);

(statearr_23871_23904[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (5))){
var _ = (function (){var statearr_23872 = state_23841;
(statearr_23872[(4)] = cljs.core.rest((state_23841[(4)])));

return statearr_23872;
})();
var state_23841__$1 = state_23841;
var ex23868 = (state_23841__$1[(2)]);
var statearr_23873_23905 = state_23841__$1;
(statearr_23873_23905[(5)] = ex23868);


if((ex23868 instanceof Error)){
var statearr_23874_23906 = state_23841__$1;
(statearr_23874_23906[(1)] = (4));

(statearr_23874_23906[(5)] = null);

} else {
throw ex23868;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (14))){
var inst_23800 = (state_23841[(11)]);
var inst_23807 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_23800);
var state_23841__$1 = state_23841;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23841__$1,(17),inst_23807);
} else {
if((state_val_23842 === (16))){
var inst_23829 = (state_23841[(2)]);
var state_23841__$1 = state_23841;
var statearr_23875_23907 = state_23841__$1;
(statearr_23875_23907[(2)] = inst_23829);

(statearr_23875_23907[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (10))){
var inst_23834 = (state_23841[(2)]);
var state_23841__$1 = state_23841;
var statearr_23876_23908 = state_23841__$1;
(statearr_23876_23908[(2)] = inst_23834);

(statearr_23876_23908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (18))){
var inst_23810 = (state_23841[(12)]);
var state_23841__$1 = state_23841;
var statearr_23877_23909 = state_23841__$1;
(statearr_23877_23909[(2)] = inst_23810);

(statearr_23877_23909[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23842 === (8))){
var inst_23797 = (state_23841[(9)]);
var inst_23800 = (state_23841[(11)]);
var inst_23800__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,inst_23797);
var inst_23801 = cljs.core.int_QMARK_(inst_23800__$1);
var state_23841__$1 = (function (){var statearr_23878 = state_23841;
(statearr_23878[(11)] = inst_23800__$1);

return statearr_23878;
})();
if(inst_23801){
var statearr_23879_23910 = state_23841__$1;
(statearr_23879_23910[(1)] = (11));

} else {
var statearr_23880_23911 = state_23841__$1;
(statearr_23880_23911[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__ = null;
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0 = (function (){
var statearr_23881 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23881[(0)] = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__);

(statearr_23881[(1)] = (1));

return statearr_23881;
});
var fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1 = (function (state_23841){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_23841);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e23882){var ex__2687__auto__ = e23882;
var statearr_23883_23912 = state_23841;
(statearr_23883_23912[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_23841[(4)]))){
var statearr_23884_23913 = state_23841;
(statearr_23884_23913[(1)] = cljs.core.first((state_23841[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23914 = state_23841;
state_23841 = G__23914;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__ = function(state_23841){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1.call(this,state_23841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____0;
fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto____1;
return fluree$db$query$subject_crawl$common$resolve_ident_vars_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_23885 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_23885[(6)] = c__2706__auto__);

return statearr_23885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
