// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
goog.require('fluree.db.query.subject_crawl.core');
goog.require('fluree.db.query.fql_resp');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__24832 = arguments.length;
switch (G__24832) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__24833 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24833) : f.call(null,G__24833));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__24834 = cljs.core._deref(vol);
var G__24835 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__24834,G__24835) : f.call(null,G__24834,G__24835));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__24836 = cljs.core._deref(vol);
var G__24837 = arg1;
var G__24838 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__24836,G__24837,G__24838) : f.call(null,G__24836,G__24837,G__24838));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__24839 = cljs.core._deref(vol);
var G__24840 = arg1;
var G__24841 = arg2;
var G__24842 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__24839,G__24840,G__24841,G__24842) : f.call(null,G__24839,G__24840,G__24841,G__24842));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__24845 = arguments.length;
switch (G__24845) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__24847 = null;
var G__24847__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__24847__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__24847__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__24847 = function(result,flake){
switch(arguments.length){
case 0:
return G__24847__0.call(this);
case 1:
return G__24847__1.call(this,result);
case 2:
return G__24847__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__24847.cljs$core$IFn$_invoke$arity$0 = G__24847__0;
G__24847.cljs$core$IFn$_invoke$arity$1 = G__24847__1;
G__24847.cljs$core$IFn$_invoke$arity$2 = G__24847__2;
return G__24847;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24848_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24848_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24852 = vars;
var vec__24853 = G__24852;
var seq__24854 = cljs.core.seq(vec__24853);
var first__24855 = cljs.core.first(seq__24854);
var seq__24854__$1 = cljs.core.next(seq__24854);
var var$ = first__24855;
var r = seq__24854__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24852__$1 = G__24852;
var all_vars__$1 = all_vars;
while(true){
var vec__24860 = G__24852__$1;
var seq__24861 = cljs.core.seq(vec__24860);
var first__24862 = cljs.core.first(seq__24861);
var seq__24861__$1 = cljs.core.next(seq__24861);
var var$__$1 = first__24862;
var r__$1 = seq__24861__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24863 = cljs.core.set(all_vars__$2);
return (fexpr__24863.cljs$core$IFn$_invoke$arity$1 ? fexpr__24863.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24863.call(null,var$__$1));
})())){
var G__24864 = r__$1;
var G__24865 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24852__$1 = G__24864;
all_vars__$1 = G__24865;
continue;
} else {
var G__24866 = r__$1;
var G__24867 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24852__$1 = G__24866;
all_vars__$1 = G__24867;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5804__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5804__auto__)){
var query_map = temp__5804__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24868){
var vec__24869 = p__24868;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24869,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24869,(1),null);
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5804__auto__)){
var _id = temp__5804__auto__;
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24883){
var state_val_24884 = (state_24883[(1)]);
if((state_val_24884 === (1))){
var inst_24872 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24873 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24874 = [query_map,_id,query_opts];
var inst_24875 = cljs.core.PersistentHashMap.fromArrays(inst_24873,inst_24874);
var inst_24876 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24875) : fluree.db.query.fql.query.call(null,db,inst_24875));
var state_24883__$1 = (function (){var statearr_24885 = state_24883;
(statearr_24885[(7)] = inst_24872);

return statearr_24885;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24883__$1,(2),inst_24876);
} else {
if((state_val_24884 === (2))){
var inst_24872 = (state_24883[(7)]);
var inst_24878 = (state_24883[(2)]);
var inst_24879 = fluree.db.util.async.throw_err(inst_24878);
var inst_24880 = [tuple_index,inst_24879];
var inst_24881 = (new cljs.core.PersistentVector(null,2,(5),inst_24872,inst_24880,null));
var state_24883__$1 = state_24883;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24883__$1,inst_24881);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0 = (function (){
var statearr_24886 = [null,null,null,null,null,null,null,null];
(statearr_24886[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2684__auto__);

(statearr_24886[(1)] = (1));

return statearr_24886;
});
var fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1 = (function (state_24883){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24883);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e24887){var ex__2687__auto__ = e24887;
var statearr_24888_24891 = state_24883;
(statearr_24888_24891[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24883[(4)]))){
var statearr_24889_24892 = state_24883;
(statearr_24889_24892[(1)] = cljs.core.first((state_24883[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24893 = state_24883;
state_24883 = G__24893;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__ = function(state_24883){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1.call(this,state_24883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2684__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_24890 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_24890[(6)] = c__2706__auto__);

return statearr_24890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24894 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24894,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24894,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_24957){
var state_val_24958 = (state_24957[(1)]);
if((state_val_24958 === (7))){
var inst_24952 = (state_24957[(2)]);
var _ = (function (){var statearr_24959 = state_24957;
(statearr_24959[(4)] = cljs.core.rest((state_24957[(4)])));

return statearr_24959;
})();
var state_24957__$1 = state_24957;
var statearr_24960_25051 = state_24957__$1;
(statearr_24960_25051[(2)] = inst_24952);

(statearr_24960_25051[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (20))){
var inst_24943 = (state_24957[(2)]);
var state_24957__$1 = state_24957;
var statearr_24961_25052 = state_24957__$1;
(statearr_24961_25052[(2)] = inst_24943);

(statearr_24961_25052[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (1))){
var state_24957__$1 = state_24957;
var statearr_24962_25053 = state_24957__$1;
(statearr_24962_25053[(2)] = null);

(statearr_24962_25053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (4))){
var inst_24899 = (state_24957[(2)]);
var state_24957__$1 = state_24957;
var statearr_24963_25054 = state_24957__$1;
(statearr_24963_25054[(2)] = inst_24899);

(statearr_24963_25054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (15))){
var inst_24919 = (state_24957[(7)]);
var inst_24928 = cljs.core.second(inst_24919);
var inst_24929 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_24928);
var inst_24930 = (inst_24929 > max_fuel);
var state_24957__$1 = state_24957;
if(cljs.core.truth_(inst_24930)){
var statearr_24964_25055 = state_24957__$1;
(statearr_24964_25055[(1)] = (18));

} else {
var statearr_24965_25056 = state_24957__$1;
(statearr_24965_25056[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (13))){
var state_24957__$1 = state_24957;
var statearr_24966_25057 = state_24957__$1;
(statearr_24966_25057[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (6))){
var inst_24907 = (state_24957[(8)]);
var state_24957__$1 = state_24957;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24957__$1,(8),inst_24907);
} else {
if((state_val_24958 === (17))){
var inst_24946 = (state_24957[(2)]);
var state_24957__$1 = state_24957;
var statearr_24968_25058 = state_24957__$1;
(statearr_24968_25058[(2)] = inst_24946);

(statearr_24968_25058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (3))){
var inst_24955 = (state_24957[(2)]);
var state_24957__$1 = state_24957;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24957__$1,inst_24955);
} else {
if((state_val_24958 === (12))){
var inst_24908 = (state_24957[(9)]);
var inst_24919 = (state_24957[(7)]);
var inst_24925 = (inst_24908.cljs$core$IFn$_invoke$arity$0 ? inst_24908.cljs$core$IFn$_invoke$arity$0() : inst_24908.call(null));
var state_24957__$1 = (function (){var statearr_24969 = state_24957;
(statearr_24969[(10)] = inst_24925);

return statearr_24969;
})();
var statearr_24970_25059 = state_24957__$1;
(statearr_24970_25059[(2)] = inst_24919);

(statearr_24970_25059[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (2))){
var inst_24908 = (state_24957[(9)]);
var inst_24907 = (state_24957[(8)]);
var _ = (function (){var statearr_24971 = state_24957;
(statearr_24971[(4)] = cljs.core.cons((5),(state_24957[(4)])));

return statearr_24971;
})();
var inst_24905 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24906 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24907__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24908__$1 = (function (){var expandMaps = inst_24905;
var queue_ch = inst_24906;
var res_ch = inst_24907__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24909 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24910 = cljs.core.volatile_BANG_((0));
var inst_24911 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24909,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24910);
var inst_24912 = (function (){var expandMaps = inst_24905;
var queue_ch = inst_24906;
var res_ch = inst_24907__$1;
var stop_BANG_ = inst_24908__$1;
var opts_STAR_ = inst_24911;
return (function (tuple_res,port){
var c__2706__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25004){
var state_val_25005 = (state_25004[(1)]);
if((state_val_25005 === (7))){
var state_25004__$1 = state_25004;
var statearr_25006_25060 = state_25004__$1;
(statearr_25006_25060[(2)] = tuple_res);

(statearr_25006_25060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (1))){
var state_25004__$1 = state_25004;
var statearr_25007_25061 = state_25004__$1;
(statearr_25007_25061[(2)] = null);

(statearr_25007_25061[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (4))){
var inst_24972 = (state_25004[(2)]);
var inst_24973 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24972);
var inst_24974 = cljs.core.async.close_BANG_(port);
var state_25004__$1 = (function (){var statearr_25008 = state_25004;
(statearr_25008[(7)] = inst_24973);

return statearr_25008;
})();
var statearr_25009_25062 = state_25004__$1;
(statearr_25009_25062[(2)] = inst_24974);

(statearr_25009_25062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (6))){
var inst_24981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24982 = [tuple_res];
var inst_24983 = (new cljs.core.PersistentVector(null,1,(5),inst_24981,inst_24982,null));
var state_25004__$1 = state_25004;
var statearr_25010_25063 = state_25004__$1;
(statearr_25010_25063[(2)] = inst_24983);

(statearr_25010_25063[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (3))){
var inst_25002 = (state_25004[(2)]);
var state_25004__$1 = state_25004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25004__$1,inst_25002);
} else {
if((state_val_25005 === (2))){
var ___$1 = (function (){var statearr_25012 = state_25004;
(statearr_25012[(4)] = cljs.core.cons((5),(state_25004[(4)])));

return statearr_25012;
})();
var state_25004__$1 = state_25004;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_25013_25064 = state_25004__$1;
(statearr_25013_25064[(1)] = (6));

} else {
var statearr_25014_25065 = state_25004__$1;
(statearr_25014_25065[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (9))){
var inst_24986 = (state_25004[(8)]);
var inst_24988 = (state_25004[(9)]);
var inst_24995 = (state_25004[(2)]);
var inst_24996 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24986,inst_24995);
var inst_24997 = (inst_24988.cljs$core$IFn$_invoke$arity$1 ? inst_24988.cljs$core$IFn$_invoke$arity$1(inst_24996) : inst_24988.call(null,inst_24996));
var inst_24998 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24997);
var inst_24999 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_25015 = state_25004;
(statearr_25015[(4)] = cljs.core.rest((state_25004[(4)])));

return statearr_25015;
})();
var state_25004__$1 = (function (){var statearr_25016 = state_25004;
(statearr_25016[(10)] = inst_24998);

return statearr_25016;
})();
var statearr_25017_25066 = state_25004__$1;
(statearr_25017_25066[(2)] = inst_24999);

(statearr_25017_25066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (5))){
var ___$1 = (function (){var statearr_25018 = state_25004;
(statearr_25018[(4)] = cljs.core.rest((state_25004[(4)])));

return statearr_25018;
})();
var state_25004__$1 = state_25004;
var ex25011 = (state_25004__$1[(2)]);
var statearr_25019_25067 = state_25004__$1;
(statearr_25019_25067[(5)] = ex25011);


var statearr_25020_25068 = state_25004__$1;
(statearr_25020_25068[(1)] = (4));

(statearr_25020_25068[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25005 === (8))){
var inst_24986 = (state_25004[(8)]);
var inst_24986__$1 = (state_25004[(2)]);
var inst_24987 = cljs.core.volatile_BANG_((0));
var inst_24988 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24986__$1;
var query_fuel = inst_24987;
return (function (p1__24898_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24898_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24898_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24989 = cljs.core.PersistentVector.EMPTY;
var inst_24990 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24986__$1;
var query_fuel = inst_24987;
return (function (p1__24897_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24897_SHARP_);
});
})();
var inst_24991 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24990,expandMaps);
var inst_24992 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24991);
var inst_24993 = cljs.core.async.into(inst_24989,inst_24992);
var state_25004__$1 = (function (){var statearr_25021 = state_25004;
(statearr_25021[(8)] = inst_24986__$1);

(statearr_25021[(9)] = inst_24988);

return statearr_25021;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25004__$1,(9),inst_24993);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_25022 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_25022[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_25022[(1)] = (1));

return statearr_25022;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_25004){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25004);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25023){var ex__2687__auto__ = e25023;
var statearr_25024_25069 = state_25004;
(statearr_25024_25069[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25004[(4)]))){
var statearr_25025_25070 = state_25004;
(statearr_25025_25070[(1)] = cljs.core.first((state_25004[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25071 = state_25004;
state_25004 = G__25071;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_25004){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_25004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25026 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25026[(6)] = c__2706__auto____$1);

return statearr_25026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto____$1;
});
})();
var inst_24913 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24906,tuples_res);
var inst_24914 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24907__$1,inst_24912,inst_24906);
var inst_24915 = cljs.core.PersistentVector.EMPTY;
var inst_24916 = inst_24915;
var state_24957__$1 = (function (){var statearr_25027 = state_24957;
(statearr_25027[(9)] = inst_24908__$1);

(statearr_25027[(11)] = inst_24916);

(statearr_25027[(12)] = inst_24914);

(statearr_25027[(13)] = inst_24913);

(statearr_25027[(8)] = inst_24907__$1);

return statearr_25027;
})();
var statearr_25028_25072 = state_24957__$1;
(statearr_25028_25072[(2)] = null);

(statearr_25028_25072[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (19))){
var inst_24916 = (state_24957[(11)]);
var inst_24919 = (state_24957[(7)]);
var inst_24939 = cljs.core.first(inst_24919);
var inst_24940 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24916,inst_24939);
var inst_24916__$1 = inst_24940;
var state_24957__$1 = (function (){var statearr_25029 = state_24957;
(statearr_25029[(11)] = inst_24916__$1);

return statearr_25029;
})();
var statearr_25030_25073 = state_24957__$1;
(statearr_25030_25073[(2)] = null);

(statearr_25030_25073[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (11))){
var inst_24950 = (state_24957[(2)]);
var state_24957__$1 = state_24957;
var statearr_25032_25074 = state_24957__$1;
(statearr_25032_25074[(2)] = inst_24950);

(statearr_25032_25074[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (9))){
var inst_24916 = (state_24957[(11)]);
var state_24957__$1 = state_24957;
var statearr_25033_25075 = state_24957__$1;
(statearr_25033_25075[(2)] = inst_24916);

(statearr_25033_25075[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (5))){
var _ = (function (){var statearr_25034 = state_24957;
(statearr_25034[(4)] = cljs.core.rest((state_24957[(4)])));

return statearr_25034;
})();
var state_24957__$1 = state_24957;
var ex25031 = (state_24957__$1[(2)]);
var statearr_25035_25076 = state_24957__$1;
(statearr_25035_25076[(5)] = ex25031);


if((ex25031 instanceof Error)){
var statearr_25036_25077 = state_24957__$1;
(statearr_25036_25077[(1)] = (4));

(statearr_25036_25077[(5)] = null);

} else {
throw ex25031;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (14))){
var inst_24948 = (state_24957[(2)]);
var state_24957__$1 = state_24957;
var statearr_25037_25078 = state_24957__$1;
(statearr_25037_25078[(2)] = inst_24948);

(statearr_25037_25078[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (16))){
var state_24957__$1 = state_24957;
var statearr_25038_25079 = state_24957__$1;
(statearr_25038_25079[(2)] = null);

(statearr_25038_25079[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (10))){
var inst_24919 = (state_24957[(7)]);
var inst_24923 = fluree.db.util.core.exception_QMARK_(inst_24919);
var state_24957__$1 = state_24957;
if(inst_24923){
var statearr_25039_25080 = state_24957__$1;
(statearr_25039_25080[(1)] = (12));

} else {
var statearr_25040_25081 = state_24957__$1;
(statearr_25040_25081[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (18))){
var inst_24908 = (state_24957[(9)]);
var inst_24932 = (inst_24908.cljs$core$IFn$_invoke$arity$0 ? inst_24908.cljs$core$IFn$_invoke$arity$0() : inst_24908.call(null));
var inst_24933 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24934 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24935 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24936 = cljs.core.PersistentHashMap.fromArrays(inst_24934,inst_24935);
var inst_24937 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24933,inst_24936);
var state_24957__$1 = (function (){var statearr_25041 = state_24957;
(statearr_25041[(14)] = inst_24932);

return statearr_25041;
})();
var statearr_25042_25082 = state_24957__$1;
(statearr_25042_25082[(2)] = inst_24937);

(statearr_25042_25082[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24958 === (8))){
var inst_24919 = (state_24957[(7)]);
var inst_24919__$1 = (state_24957[(2)]);
var inst_24920 = (inst_24919__$1 == null);
var state_24957__$1 = (function (){var statearr_25043 = state_24957;
(statearr_25043[(7)] = inst_24919__$1);

return statearr_25043;
})();
if(cljs.core.truth_(inst_24920)){
var statearr_25044_25083 = state_24957__$1;
(statearr_25044_25083[(1)] = (9));

} else {
var statearr_25045_25084 = state_24957__$1;
(statearr_25045_25084[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0 = (function (){
var statearr_25046 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25046[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__);

(statearr_25046[(1)] = (1));

return statearr_25046;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1 = (function (state_24957){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_24957);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25047){var ex__2687__auto__ = e25047;
var statearr_25048_25085 = state_24957;
(statearr_25048_25085[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_24957[(4)]))){
var statearr_25049_25086 = state_24957;
(statearr_25049_25086[(1)] = cljs.core.first((state_24957[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25087 = state_24957;
state_24957 = G__25087;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__ = function(state_24957){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1.call(this,state_24957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25050 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25050[(6)] = c__2706__auto__);

return statearr_25050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__25088 = select;
var map__25088__$1 = cljs.core.__destructure_map(map__25088);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25088__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25088__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25088__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__5045__auto__ = as;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__25091 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25091,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25091,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25091,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__25089_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25089_SHARP_,compare_idx));
}):(function (p1__25090_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25090_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__25096 = arguments.length;
switch (G__25096) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__25097,p__25098,group_limit,opts){
var map__25099 = p__25097;
var map__25099__$1 = cljs.core.__destructure_map(map__25099);
var res = map__25099__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25099__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25100 = p__25098;
var map__25100__$1 = cljs.core.__destructure_map(map__25100);
var select_spec = map__25100__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25100__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25237){
var state_val_25238 = (state_25237[(1)]);
if((state_val_25238 === (7))){
var inst_25107 = (state_25237[(7)]);
var state_25237__$1 = state_25237;
var statearr_25239_25341 = state_25237__$1;
(statearr_25239_25341[(2)] = inst_25107);

(statearr_25239_25341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (59))){
var inst_25230 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25240_25342 = state_25237__$1;
(statearr_25240_25342[(2)] = inst_25230);

(statearr_25240_25342[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (20))){
var inst_25143 = (state_25237[(8)]);
var inst_25146 = (state_25237[(9)]);
var inst_25142 = (state_25237[(2)]);
var inst_25143__$1 = cljs.core.__destructure_map(inst_25142);
var inst_25144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25143__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_25145 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25143__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_25146__$1 = offset;
var state_25237__$1 = (function (){var statearr_25241 = state_25237;
(statearr_25241[(8)] = inst_25143__$1);

(statearr_25241[(9)] = inst_25146__$1);

(statearr_25241[(10)] = inst_25145);

(statearr_25241[(11)] = inst_25144);

return statearr_25241;
})();
if(cljs.core.truth_(inst_25146__$1)){
var statearr_25242_25343 = state_25237__$1;
(statearr_25242_25343[(1)] = (21));

} else {
var statearr_25243_25344 = state_25237__$1;
(statearr_25243_25344[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (58))){
var inst_25222 = (state_25237[(12)]);
var state_25237__$1 = state_25237;
var statearr_25244_25345 = state_25237__$1;
(statearr_25244_25345[(2)] = inst_25222);

(statearr_25244_25345[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (60))){
var inst_25226 = (state_25237[(2)]);
var inst_25227 = fluree.db.util.async.throw_err(inst_25226);
var state_25237__$1 = state_25237;
var statearr_25245_25346 = state_25237__$1;
(statearr_25245_25346[(2)] = inst_25227);

(statearr_25245_25346[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (27))){
var inst_25158 = cljs.core.not(inVector_QMARK_);
var state_25237__$1 = state_25237;
var statearr_25246_25347 = state_25237__$1;
(statearr_25246_25347[(2)] = inst_25158);

(statearr_25246_25347[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (1))){
var state_25237__$1 = state_25237;
var statearr_25247_25348 = state_25237__$1;
(statearr_25247_25348[(2)] = null);

(statearr_25247_25348[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (24))){
var state_25237__$1 = state_25237;
var statearr_25248_25349 = state_25237__$1;
(statearr_25248_25349[(2)] = offset);

(statearr_25248_25349[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (55))){
var inst_25216 = (state_25237[(13)]);
var state_25237__$1 = state_25237;
var statearr_25249_25350 = state_25237__$1;
(statearr_25249_25350[(2)] = inst_25216);

(statearr_25249_25350[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (39))){
var inst_25184 = (state_25237[(14)]);
var inst_25186 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25187 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25184,inst_25186);
var state_25237__$1 = state_25237;
var statearr_25250_25351 = state_25237__$1;
(statearr_25250_25351[(2)] = inst_25187);

(statearr_25250_25351[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (46))){
var inst_25196 = (state_25237[(15)]);
var state_25237__$1 = state_25237;
var statearr_25251_25352 = state_25237__$1;
(statearr_25251_25352[(2)] = inst_25196);

(statearr_25251_25352[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (4))){
var inst_25101 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25252_25353 = state_25237__$1;
(statearr_25252_25353[(2)] = inst_25101);

(statearr_25252_25353[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (54))){
var inst_25216 = (state_25237[(13)]);
var inst_25210 = (state_25237[(16)]);
var inst_25218 = cljs.core.PersistentVector.EMPTY;
var inst_25219 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_25218,inst_25210,inst_25216);
var state_25237__$1 = state_25237;
var statearr_25253_25354 = state_25237__$1;
(statearr_25253_25354[(2)] = inst_25219);

(statearr_25253_25354[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (15))){
var inst_25128 = (state_25237[(17)]);
var inst_25130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25131 = [inst_25128];
var inst_25132 = (new cljs.core.PersistentVector(null,1,(5),inst_25130,inst_25131,null));
var state_25237__$1 = state_25237;
var statearr_25254_25355 = state_25237__$1;
(statearr_25254_25355[(2)] = inst_25132);

(statearr_25254_25355[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (48))){
var inst_25155 = (state_25237[(18)]);
var inst_25166 = (state_25237[(19)]);
var inst_25143 = (state_25237[(8)]);
var inst_25145 = (state_25237[(10)]);
var inst_25202 = (state_25237[(20)]);
var inst_25144 = (state_25237[(11)]);
var inst_25161 = (state_25237[(21)]);
var inst_25204 = (function (){var map__25137 = inst_25143;
var headers = inst_25144;
var tuples = inst_25145;
var offset_SINGLEQUOTE_ = inst_25155;
var single_result_QMARK_ = inst_25161;
var pp_keys = inst_25166;
var G__25167 = inst_25202;
return (function (p1__25094_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__25094_SHARP_);
});
})();
var inst_25205 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25204);
var inst_25206 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25202,inst_25205);
var state_25237__$1 = state_25237;
var statearr_25255_25356 = state_25237__$1;
(statearr_25255_25356[(2)] = inst_25206);

(statearr_25255_25356[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (50))){
var inst_25209 = (state_25237[(2)]);
var inst_25210 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_25209);
var state_25237__$1 = (function (){var statearr_25256 = state_25237;
(statearr_25256[(16)] = inst_25210);

return statearr_25256;
})();
if(cljs.core.truth_(orderBy)){
var statearr_25257_25357 = state_25237__$1;
(statearr_25257_25357[(1)] = (51));

} else {
var statearr_25258_25358 = state_25237__$1;
(statearr_25258_25358[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (21))){
var inst_25148 = cljs.core.not(groupBy);
var state_25237__$1 = state_25237;
var statearr_25259_25359 = state_25237__$1;
(statearr_25259_25359[(2)] = inst_25148);

(statearr_25259_25359[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (31))){
var state_25237__$1 = state_25237;
var statearr_25260_25360 = state_25237__$1;
(statearr_25260_25360[(2)] = null);

(statearr_25260_25360[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (32))){
var inst_25144 = (state_25237[(11)]);
var inst_25161 = (state_25237[(21)]);
var inst_25166 = (state_25237[(2)]);
var inst_25168 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25169 = fluree.db.query.fql.select_tuples_fn(inst_25144,vars,select);
var inst_25170 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_25169);
var inst_25171 = [inst_25170];
var inst_25172 = (new cljs.core.PersistentVector(null,1,(5),inst_25168,inst_25171,null));
var state_25237__$1 = (function (){var statearr_25261 = state_25237;
(statearr_25261[(19)] = inst_25166);

(statearr_25261[(22)] = inst_25172);

return statearr_25261;
})();
if(cljs.core.truth_(inst_25161)){
var statearr_25262_25361 = state_25237__$1;
(statearr_25262_25361[(1)] = (33));

} else {
var statearr_25263_25362 = state_25237__$1;
(statearr_25263_25362[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (40))){
var inst_25184 = (state_25237[(14)]);
var state_25237__$1 = state_25237;
var statearr_25264_25363 = state_25237__$1;
(statearr_25264_25363[(2)] = inst_25184);

(statearr_25264_25363[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (56))){
var inst_25222 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25265 = state_25237;
(statearr_25265[(12)] = inst_25222);

return statearr_25265;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_25266_25364 = state_25237__$1;
(statearr_25266_25364[(1)] = (57));

} else {
var statearr_25267_25365 = state_25237__$1;
(statearr_25267_25365[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (33))){
var inst_25172 = (state_25237[(22)]);
var inst_25174 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_25175 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25172,inst_25174);
var state_25237__$1 = state_25237;
var statearr_25268_25366 = state_25237__$1;
(statearr_25268_25366[(2)] = inst_25175);

(statearr_25268_25366[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (13))){
var inst_25117 = (state_25237[(23)]);
var state_25237__$1 = state_25237;
var statearr_25269_25367 = state_25237__$1;
(statearr_25269_25367[(2)] = inst_25117);

(statearr_25269_25367[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (22))){
var inst_25146 = (state_25237[(9)]);
var state_25237__$1 = state_25237;
var statearr_25270_25368 = state_25237__$1;
(statearr_25270_25368[(2)] = inst_25146);

(statearr_25270_25368[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (36))){
var inst_25178 = (state_25237[(24)]);
var inst_25180 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_25181 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25178,inst_25180);
var state_25237__$1 = state_25237;
var statearr_25271_25369 = state_25237__$1;
(statearr_25271_25369[(2)] = inst_25181);

(statearr_25271_25369[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (41))){
var inst_25155 = (state_25237[(18)]);
var inst_25190 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25272 = state_25237;
(statearr_25272[(25)] = inst_25190);

return statearr_25272;
})();
if(cljs.core.truth_(inst_25155)){
var statearr_25273_25370 = state_25237__$1;
(statearr_25273_25370[(1)] = (42));

} else {
var statearr_25274_25371 = state_25237__$1;
(statearr_25274_25371[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (43))){
var inst_25190 = (state_25237[(25)]);
var state_25237__$1 = state_25237;
var statearr_25275_25372 = state_25237__$1;
(statearr_25275_25372[(2)] = inst_25190);

(statearr_25275_25372[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (29))){
var inst_25161 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25276 = state_25237;
(statearr_25276[(21)] = inst_25161);

return statearr_25276;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25277_25373 = state_25237__$1;
(statearr_25277_25373[(1)] = (30));

} else {
var statearr_25278_25374 = state_25237__$1;
(statearr_25278_25374[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (44))){
var inst_25196 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25279 = state_25237;
(statearr_25279[(15)] = inst_25196);

return statearr_25279;
})();
if(cljs.core.truth_(group_limit)){
var statearr_25280_25375 = state_25237__$1;
(statearr_25280_25375[(1)] = (45));

} else {
var statearr_25281_25376 = state_25237__$1;
(statearr_25281_25376[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (6))){
var inst_25109 = cljs.core.count(select);
var inst_25110 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_25109);
var state_25237__$1 = state_25237;
var statearr_25282_25377 = state_25237__$1;
(statearr_25282_25377[(2)] = inst_25110);

(statearr_25282_25377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (28))){
var inst_25156 = (state_25237[(26)]);
var state_25237__$1 = state_25237;
var statearr_25283_25378 = state_25237__$1;
(statearr_25283_25378[(2)] = inst_25156);

(statearr_25283_25378[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (51))){
var inst_25145 = (state_25237[(10)]);
var inst_25144 = (state_25237[(11)]);
var inst_25213 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_25144,orderBy,inst_25145);
var state_25237__$1 = state_25237;
var statearr_25284_25379 = state_25237__$1;
(statearr_25284_25379[(2)] = inst_25213);

(statearr_25284_25379[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (25))){
var state_25237__$1 = state_25237;
var statearr_25285_25380 = state_25237__$1;
(statearr_25285_25380[(2)] = null);

(statearr_25285_25380[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (34))){
var inst_25172 = (state_25237[(22)]);
var state_25237__$1 = state_25237;
var statearr_25286_25381 = state_25237__$1;
(statearr_25286_25381[(2)] = inst_25172);

(statearr_25286_25381[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (17))){
var inst_25135 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
var statearr_25287_25382 = state_25237__$1;
(statearr_25287_25382[(2)] = inst_25135);

(statearr_25287_25382[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (3))){
var inst_25235 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25237__$1,inst_25235);
} else {
if((state_val_25238 === (12))){
var inst_25117 = (state_25237[(23)]);
var inst_25119 = cljs.core.first(select);
var inst_25120 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_25119);
var inst_25121 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25120);
var inst_25122 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_25121,(1));
var inst_25123 = [inst_25122];
var inst_25124 = [inst_25117];
var inst_25125 = cljs.core.PersistentHashMap.fromArrays(inst_25123,inst_25124);
var state_25237__$1 = state_25237;
var statearr_25288_25383 = state_25237__$1;
(statearr_25288_25383[(2)] = inst_25125);

(statearr_25288_25383[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (2))){
var inst_25107 = (state_25237[(7)]);
var _ = (function (){var statearr_25289 = state_25237;
(statearr_25289[(4)] = cljs.core.cons((5),(state_25237[(4)])));

return statearr_25289;
})();
var inst_25107__$1 = aggregates;
var state_25237__$1 = (function (){var statearr_25290 = state_25237;
(statearr_25290[(7)] = inst_25107__$1);

return statearr_25290;
})();
if(cljs.core.truth_(inst_25107__$1)){
var statearr_25291_25384 = state_25237__$1;
(statearr_25291_25384[(1)] = (6));

} else {
var statearr_25292_25385 = state_25237__$1;
(statearr_25292_25385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (23))){
var inst_25151 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
if(cljs.core.truth_(inst_25151)){
var statearr_25293_25386 = state_25237__$1;
(statearr_25293_25386[(1)] = (24));

} else {
var statearr_25294_25387 = state_25237__$1;
(statearr_25294_25387[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (47))){
var inst_25202 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25295 = state_25237;
(statearr_25295[(20)] = inst_25202);

return statearr_25295;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25296_25388 = state_25237__$1;
(statearr_25296_25388[(1)] = (48));

} else {
var statearr_25297_25389 = state_25237__$1;
(statearr_25297_25389[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (35))){
var inst_25178 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25298 = state_25237;
(statearr_25298[(24)] = inst_25178);

return statearr_25298;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25299_25390 = state_25237__$1;
(statearr_25299_25390[(1)] = (36));

} else {
var statearr_25300_25391 = state_25237__$1;
(statearr_25300_25391[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (19))){
var state_25237__$1 = state_25237;
var statearr_25301_25392 = state_25237__$1;
(statearr_25301_25392[(2)] = res);

(statearr_25301_25392[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (57))){
var inst_25166 = (state_25237[(19)]);
var inst_25161 = (state_25237[(21)]);
var inst_25222 = (state_25237[(12)]);
var inst_25224 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_25166,inst_25161,db,fuel,max_fuel,opts,(8),inst_25222);
var state_25237__$1 = state_25237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25237__$1,(60),inst_25224);
} else {
if((state_val_25238 === (11))){
var inst_25232 = (state_25237[(2)]);
var _ = (function (){var statearr_25303 = state_25237;
(statearr_25303[(4)] = cljs.core.rest((state_25237[(4)])));

return statearr_25303;
})();
var state_25237__$1 = state_25237;
var statearr_25304_25393 = state_25237__$1;
(statearr_25304_25393[(2)] = inst_25232);

(statearr_25304_25393[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (9))){
var inst_25115 = cljs.core.first(aggregates);
var inst_25116 = fluree.db.query.analytical.calculate_aggregate(res,inst_25115);
var inst_25117 = cljs.core.second(inst_25116);
var state_25237__$1 = (function (){var statearr_25305 = state_25237;
(statearr_25305[(23)] = inst_25117);

return statearr_25305;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_25306_25394 = state_25237__$1;
(statearr_25306_25394[(1)] = (12));

} else {
var statearr_25307_25395 = state_25237__$1;
(statearr_25307_25395[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (5))){
var _ = (function (){var statearr_25308 = state_25237;
(statearr_25308[(4)] = cljs.core.rest((state_25237[(4)])));

return statearr_25308;
})();
var state_25237__$1 = state_25237;
var ex25302 = (state_25237__$1[(2)]);
var statearr_25309_25396 = state_25237__$1;
(statearr_25309_25396[(5)] = ex25302);


if((ex25302 instanceof Error)){
var statearr_25310_25397 = state_25237__$1;
(statearr_25310_25397[(1)] = (4));

(statearr_25310_25397[(5)] = null);

} else {
throw ex25302;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (14))){
var inst_25128 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25311 = state_25237;
(statearr_25311[(17)] = inst_25128);

return statearr_25311;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25312_25398 = state_25237__$1;
(statearr_25312_25398[(1)] = (15));

} else {
var statearr_25313_25399 = state_25237__$1;
(statearr_25313_25399[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (45))){
var inst_25196 = (state_25237[(15)]);
var inst_25198 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_25199 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25196,inst_25198);
var state_25237__$1 = state_25237;
var statearr_25314_25400 = state_25237__$1;
(statearr_25314_25400[(2)] = inst_25199);

(statearr_25314_25400[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (53))){
var inst_25216 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25315 = state_25237;
(statearr_25315[(13)] = inst_25216);

return statearr_25315;
})();
var statearr_25316_25401 = state_25237__$1;
(statearr_25316_25401[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (26))){
var inst_25156 = (state_25237[(26)]);
var inst_25155 = (state_25237[(2)]);
var inst_25156__$1 = cljs.core.not(prettyPrint);
var state_25237__$1 = (function (){var statearr_25318 = state_25237;
(statearr_25318[(18)] = inst_25155);

(statearr_25318[(26)] = inst_25156__$1);

return statearr_25318;
})();
if(inst_25156__$1){
var statearr_25319_25402 = state_25237__$1;
(statearr_25319_25402[(1)] = (27));

} else {
var statearr_25320_25403 = state_25237__$1;
(statearr_25320_25403[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (16))){
var inst_25128 = (state_25237[(17)]);
var state_25237__$1 = state_25237;
var statearr_25321_25404 = state_25237__$1;
(statearr_25321_25404[(2)] = inst_25128);

(statearr_25321_25404[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (38))){
var inst_25184 = (state_25237[(2)]);
var state_25237__$1 = (function (){var statearr_25322 = state_25237;
(statearr_25322[(14)] = inst_25184);

return statearr_25322;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25323_25405 = state_25237__$1;
(statearr_25323_25405[(1)] = (39));

} else {
var statearr_25324_25406 = state_25237__$1;
(statearr_25324_25406[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (30))){
var inst_25163 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_25237__$1 = state_25237;
var statearr_25325_25407 = state_25237__$1;
(statearr_25325_25407[(2)] = inst_25163);

(statearr_25325_25407[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (10))){
var state_25237__$1 = state_25237;
if(cljs.core.truth_(aggregates)){
var statearr_25326_25408 = state_25237__$1;
(statearr_25326_25408[(1)] = (18));

} else {
var statearr_25327_25409 = state_25237__$1;
(statearr_25327_25409[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (18))){
var inst_25139 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_25237__$1 = state_25237;
var statearr_25328_25410 = state_25237__$1;
(statearr_25328_25410[(2)] = inst_25139);

(statearr_25328_25410[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (52))){
var inst_25145 = (state_25237[(10)]);
var state_25237__$1 = state_25237;
var statearr_25329_25411 = state_25237__$1;
(statearr_25329_25411[(2)] = inst_25145);

(statearr_25329_25411[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (42))){
var inst_25190 = (state_25237[(25)]);
var inst_25155 = (state_25237[(18)]);
var inst_25192 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_25155);
var inst_25193 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25190,inst_25192);
var state_25237__$1 = state_25237;
var statearr_25330_25412 = state_25237__$1;
(statearr_25330_25412[(2)] = inst_25193);

(statearr_25330_25412[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (37))){
var inst_25178 = (state_25237[(24)]);
var state_25237__$1 = state_25237;
var statearr_25331_25413 = state_25237__$1;
(statearr_25331_25413[(2)] = inst_25178);

(statearr_25331_25413[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (8))){
var inst_25113 = (state_25237[(2)]);
var state_25237__$1 = state_25237;
if(cljs.core.truth_(inst_25113)){
var statearr_25332_25414 = state_25237__$1;
(statearr_25332_25414[(1)] = (9));

} else {
var statearr_25333_25415 = state_25237__$1;
(statearr_25333_25415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25238 === (49))){
var inst_25202 = (state_25237[(20)]);
var state_25237__$1 = state_25237;
var statearr_25334_25416 = state_25237__$1;
(statearr_25334_25416[(2)] = inst_25202);

(statearr_25334_25416[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2684__auto__ = null;
var fluree$db$query$fql$state_machine__2684__auto____0 = (function (){
var statearr_25335 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25335[(0)] = fluree$db$query$fql$state_machine__2684__auto__);

(statearr_25335[(1)] = (1));

return statearr_25335;
});
var fluree$db$query$fql$state_machine__2684__auto____1 = (function (state_25237){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25237);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25336){var ex__2687__auto__ = e25336;
var statearr_25337_25417 = state_25237;
(statearr_25337_25417[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25237[(4)]))){
var statearr_25338_25418 = state_25237;
(statearr_25338_25418[(1)] = cljs.core.first((state_25237[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25419 = state_25237;
state_25237 = G__25419;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2684__auto__ = function(state_25237){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2684__auto____1.call(this,state_25237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2684__auto____0;
fluree$db$query$fql$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2684__auto____1;
return fluree$db$query$fql$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25339 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25339[(6)] = c__2706__auto__);

return statearr_25339;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25422,groupBy){
var map__25423 = p__25422;
var map__25423__$1 = cljs.core.__destructure_map(map__25423);
var res = map__25423__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25423__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25423__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25424 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25424,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25424,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25420_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25420_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25421_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25421_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25427 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25427,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25427,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
/**
 * groupBy statements can optionally have a 'having' statement which filters
 *   items within the group.
 */
fluree.db.query.fql.filter_having = (function fluree$db$query$fql$filter_having(p__25430,headers,group_map){
var map__25431 = p__25430;
var map__25431__$1 = cljs.core.__destructure_map(map__25431);
var having = map__25431__$1;
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25431__$1,new cljs.core.Keyword(null,"params","params",710516235));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25431__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var idxs = fluree.db.query.analytical.get_tuple_indexes(params,headers);
var filtered = (function (){var G__25438 = group_map;
var vec__25439 = G__25438;
var seq__25440 = cljs.core.seq(vec__25439);
var first__25441 = cljs.core.first(seq__25440);
var seq__25440__$1 = cljs.core.next(seq__25440);
var vec__25442 = first__25441;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25442,(0),null);
var tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25442,(1),null);
var r = seq__25440__$1;
var acc = cljs.core.PersistentArrayMap.EMPTY;
var G__25438__$1 = G__25438;
var acc__$1 = acc;
while(true){
var vec__25454 = G__25438__$1;
var seq__25455 = cljs.core.seq(vec__25454);
var first__25456 = cljs.core.first(seq__25455);
var seq__25455__$1 = cljs.core.next(seq__25455);
var vec__25457 = first__25456;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25457,(0),null);
var tuples__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25457,(1),null);
var r__$1 = seq__25455__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(k__$1)){
var argument = cljs.core.flatten(fluree.db.query.analytical.transform_tuples_to_idxs(idxs,tuples__$1));
var res = (function (){try{return (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(argument) : function$.call(null,argument));
}catch (e25460){var e = e25460;
var G__25461_25463 = e;
var G__25462_25464 = ["Error procesing fn: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with argument: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(argument)].join('');
(fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$2(G__25461_25463,G__25462_25464) : fluree.db.util.log.error.call(null,G__25461_25463,G__25462_25464));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error executing having function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402).cljs$core$IFn$_invoke$arity$1(having))," with error message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ex_message(e))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}})();
if(cljs.core.truth_(res)){
var G__25465 = r__$1;
var G__25466 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc__$2,k__$1,tuples__$1);
G__25438__$1 = G__25465;
acc__$1 = G__25466;
continue;
} else {
var G__25467 = r__$1;
var G__25468 = acc__$2;
G__25438__$1 = G__25467;
acc__$1 = G__25468;
continue;
}
} else {
return acc__$2;
}
break;
}
})();
return filtered;
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__25469,p__25470,opts){
var map__25471 = p__25469;
var map__25471__$1 = cljs.core.__destructure_map(map__25471);
var res = map__25471__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25471__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25471__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25472 = p__25470;
var map__25472__$1 = cljs.core.__destructure_map(map__25472);
var select_spec = map__25472__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var having = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25472__$1,new cljs.core.Keyword(null,"having","having",-399543166));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25596){
var state_val_25597 = (state_25596[(1)]);
if((state_val_25597 === (7))){
var state_25596__$1 = state_25596;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25598_25671 = state_25596__$1;
(statearr_25598_25671[(1)] = (30));

} else {
var statearr_25599_25672 = state_25596__$1;
(statearr_25599_25672[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (20))){
var inst_25503 = (state_25596[(2)]);
var state_25596__$1 = (function (){var statearr_25600 = state_25596;
(statearr_25600[(7)] = inst_25503);

return statearr_25600;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25601_25673 = state_25596__$1;
(statearr_25601_25673[(1)] = (21));

} else {
var statearr_25602_25674 = state_25596__$1;
(statearr_25602_25674[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (27))){
var inst_25529 = (state_25596[(8)]);
var state_25596__$1 = state_25596;
var statearr_25603_25675 = state_25596__$1;
(statearr_25603_25675[(2)] = inst_25529);

(statearr_25603_25675[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (1))){
var state_25596__$1 = state_25596;
var statearr_25604_25676 = state_25596__$1;
(statearr_25604_25676[(2)] = null);

(statearr_25604_25676[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (24))){
var inst_25540 = (state_25596[(9)]);
var inst_25528 = (state_25596[(10)]);
var inst_25537 = cljs.core.seq(inst_25528);
var inst_25538 = cljs.core.first(inst_25537);
var inst_25539 = cljs.core.next(inst_25537);
var inst_25540__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25538,(0),null);
var inst_25541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25538,(1),null);
var state_25596__$1 = (function (){var statearr_25605 = state_25596;
(statearr_25605[(11)] = inst_25539);

(statearr_25605[(12)] = inst_25541);

(statearr_25605[(9)] = inst_25540__$1);

return statearr_25605;
})();
if(cljs.core.truth_(inst_25540__$1)){
var statearr_25606_25677 = state_25596__$1;
(statearr_25606_25677[(1)] = (26));

} else {
var statearr_25607_25678 = state_25596__$1;
(statearr_25607_25678[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (39))){
var inst_25577 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25608_25679 = state_25596__$1;
(statearr_25608_25679[(2)] = inst_25577);

(statearr_25608_25679[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (4))){
var inst_25473 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25609_25680 = state_25596__$1;
(statearr_25609_25680[(2)] = inst_25473);

(statearr_25609_25680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (15))){
var inst_25493 = (state_25596[(13)]);
var inst_25495 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_25493);
var state_25596__$1 = state_25596;
var statearr_25610_25681 = state_25596__$1;
(statearr_25610_25681[(2)] = inst_25495);

(statearr_25610_25681[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (21))){
var inst_25503 = (state_25596[(7)]);
var inst_25505 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_25503);
var state_25596__$1 = state_25596;
var statearr_25611_25682 = state_25596__$1;
(statearr_25611_25682[(2)] = inst_25505);

(statearr_25611_25682[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (31))){
var state_25596__$1 = state_25596;
var statearr_25612_25683 = state_25596__$1;
(statearr_25612_25683[(2)] = limit);

(statearr_25612_25683[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (32))){
var inst_25563 = (state_25596[(2)]);
var inst_25564 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25563,opts);
var state_25596__$1 = state_25596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25596__$1,(33),inst_25564);
} else {
if((state_val_25597 === (40))){
var inst_25567 = (state_25596[(14)]);
var inst_25580 = cljs.core.first(inst_25567);
var state_25596__$1 = state_25596;
var statearr_25613_25684 = state_25596__$1;
(statearr_25613_25684[(2)] = inst_25580);

(statearr_25613_25684[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (33))){
var inst_25567 = (state_25596[(14)]);
var inst_25566 = (state_25596[(2)]);
var inst_25567__$1 = fluree.db.util.async.throw_err(inst_25566);
var inst_25568 = cljs.core.coll_QMARK_(inst_25567__$1);
var inst_25569 = (!(inst_25568));
var state_25596__$1 = (function (){var statearr_25614 = state_25596;
(statearr_25614[(14)] = inst_25567__$1);

return statearr_25614;
})();
if(inst_25569){
var statearr_25615_25685 = state_25596__$1;
(statearr_25615_25685[(1)] = (34));

} else {
var statearr_25616_25686 = state_25596__$1;
(statearr_25616_25686[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (13))){
var inst_25488 = (state_25596[(15)]);
var state_25596__$1 = state_25596;
var statearr_25617_25687 = state_25596__$1;
(statearr_25617_25687[(2)] = inst_25488);

(statearr_25617_25687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (22))){
var inst_25503 = (state_25596[(7)]);
var state_25596__$1 = state_25596;
var statearr_25618_25688 = state_25596__$1;
(statearr_25618_25688[(2)] = inst_25503);

(statearr_25618_25688[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (36))){
var inst_25589 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25619_25689 = state_25596__$1;
(statearr_25619_25689[(2)] = inst_25589);

(statearr_25619_25689[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (41))){
var state_25596__$1 = state_25596;
var statearr_25620_25690 = state_25596__$1;
(statearr_25620_25690[(1)] = (43));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (43))){
var inst_25567 = (state_25596[(14)]);
var state_25596__$1 = state_25596;
var statearr_25622_25691 = state_25596__$1;
(statearr_25622_25691[(2)] = inst_25567);

(statearr_25622_25691[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (29))){
var inst_25539 = (state_25596[(11)]);
var inst_25540 = (state_25596[(9)]);
var inst_25529 = (state_25596[(8)]);
var inst_25550 = (state_25596[(2)]);
var inst_25551 = fluree.db.util.async.throw_err(inst_25550);
var inst_25552 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25529,inst_25540,inst_25551);
var inst_25528 = inst_25539;
var inst_25529__$1 = inst_25552;
var state_25596__$1 = (function (){var statearr_25623 = state_25596;
(statearr_25623[(10)] = inst_25528);

(statearr_25623[(8)] = inst_25529__$1);

return statearr_25623;
})();
var statearr_25624_25692 = state_25596__$1;
(statearr_25624_25692[(2)] = null);

(statearr_25624_25692[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (44))){
var state_25596__$1 = state_25596;
var statearr_25625_25693 = state_25596__$1;
(statearr_25625_25693[(2)] = null);

(statearr_25625_25693[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (6))){
var inst_25480 = (state_25596[(16)]);
var inst_25480__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25482 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25596__$1 = (function (){var statearr_25626 = state_25596;
(statearr_25626[(17)] = inst_25482);

(statearr_25626[(16)] = inst_25480__$1);

return statearr_25626;
})();
if(cljs.core.truth_(inst_25480__$1)){
var statearr_25627_25694 = state_25596__$1;
(statearr_25627_25694[(1)] = (9));

} else {
var statearr_25628_25695 = state_25596__$1;
(statearr_25628_25695[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (28))){
var inst_25556 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25629_25696 = state_25596__$1;
(statearr_25629_25696[(2)] = inst_25556);

(statearr_25629_25696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (25))){
var inst_25558 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25630_25697 = state_25596__$1;
(statearr_25630_25697[(2)] = inst_25558);

(statearr_25630_25697[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (34))){
var state_25596__$1 = state_25596;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25631_25698 = state_25596__$1;
(statearr_25631_25698[(1)] = (37));

} else {
var statearr_25632_25699 = state_25596__$1;
(statearr_25632_25699[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (17))){
var inst_25498 = (state_25596[(2)]);
var state_25596__$1 = (function (){var statearr_25633 = state_25596;
(statearr_25633[(18)] = inst_25498);

return statearr_25633;
})();
if(cljs.core.truth_(limit)){
var statearr_25634_25700 = state_25596__$1;
(statearr_25634_25700[(1)] = (18));

} else {
var statearr_25635_25701 = state_25596__$1;
(statearr_25635_25701[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (3))){
var inst_25594 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25596__$1,inst_25594);
} else {
if((state_val_25597 === (12))){
var inst_25488 = (state_25596[(15)]);
var inst_25490 = fluree.db.query.fql.filter_having(having,headers,inst_25488);
var state_25596__$1 = state_25596;
var statearr_25636_25702 = state_25596__$1;
(statearr_25636_25702[(2)] = inst_25490);

(statearr_25636_25702[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (2))){
var _ = (function (){var statearr_25637 = state_25596;
(statearr_25637[(4)] = cljs.core.cons((5),(state_25596[(4)])));

return statearr_25637;
})();
var state_25596__$1 = state_25596;
if(cljs.core.truth_(groupBy)){
var statearr_25638_25703 = state_25596__$1;
(statearr_25638_25703[(1)] = (6));

} else {
var statearr_25639_25704 = state_25596__$1;
(statearr_25639_25704[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (23))){
var inst_25508 = (state_25596[(2)]);
var inst_25522 = cljs.core.seq(inst_25508);
var inst_25523 = cljs.core.first(inst_25522);
var inst_25524 = cljs.core.next(inst_25522);
var inst_25525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25523,(0),null);
var inst_25526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25523,(1),null);
var inst_25527 = cljs.core.PersistentHashMap.EMPTY;
var inst_25528 = inst_25508;
var inst_25529 = inst_25527;
var state_25596__$1 = (function (){var statearr_25640 = state_25596;
(statearr_25640[(19)] = inst_25525);

(statearr_25640[(20)] = inst_25526);

(statearr_25640[(21)] = inst_25524);

(statearr_25640[(10)] = inst_25528);

(statearr_25640[(8)] = inst_25529);

return statearr_25640;
})();
var statearr_25641_25705 = state_25596__$1;
(statearr_25641_25705[(2)] = null);

(statearr_25641_25705[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (35))){
var state_25596__$1 = state_25596;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25642_25706 = state_25596__$1;
(statearr_25642_25706[(1)] = (40));

} else {
var statearr_25643_25707 = state_25596__$1;
(statearr_25643_25707[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (19))){
var inst_25498 = (state_25596[(18)]);
var state_25596__$1 = state_25596;
var statearr_25644_25708 = state_25596__$1;
(statearr_25644_25708[(2)] = inst_25498);

(statearr_25644_25708[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (11))){
var inst_25488 = (state_25596[(2)]);
var state_25596__$1 = (function (){var statearr_25646 = state_25596;
(statearr_25646[(15)] = inst_25488);

return statearr_25646;
})();
if(cljs.core.truth_(having)){
var statearr_25647_25709 = state_25596__$1;
(statearr_25647_25709[(1)] = (12));

} else {
var statearr_25648_25710 = state_25596__$1;
(statearr_25648_25710[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (9))){
var inst_25482 = (state_25596[(17)]);
var inst_25480 = (state_25596[(16)]);
var inst_25484 = cljs.core.sorted_map_by(inst_25480);
var inst_25485 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25484,inst_25482);
var state_25596__$1 = state_25596;
var statearr_25649_25711 = state_25596__$1;
(statearr_25649_25711[(2)] = inst_25485);

(statearr_25649_25711[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (5))){
var _ = (function (){var statearr_25650 = state_25596;
(statearr_25650[(4)] = cljs.core.rest((state_25596[(4)])));

return statearr_25650;
})();
var state_25596__$1 = state_25596;
var ex25645 = (state_25596__$1[(2)]);
var statearr_25651_25712 = state_25596__$1;
(statearr_25651_25712[(5)] = ex25645);


if((ex25645 instanceof Error)){
var statearr_25652_25713 = state_25596__$1;
(statearr_25652_25713[(1)] = (4));

(statearr_25652_25713[(5)] = null);

} else {
throw ex25645;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (14))){
var inst_25493 = (state_25596[(2)]);
var state_25596__$1 = (function (){var statearr_25653 = state_25596;
(statearr_25653[(13)] = inst_25493);

return statearr_25653;
})();
if(cljs.core.truth_(offset)){
var statearr_25654_25714 = state_25596__$1;
(statearr_25654_25714[(1)] = (15));

} else {
var statearr_25655_25715 = state_25596__$1;
(statearr_25655_25715[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (45))){
var inst_25585 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25656_25716 = state_25596__$1;
(statearr_25656_25716[(2)] = inst_25585);

(statearr_25656_25716[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (26))){
var inst_25541 = (state_25596[(12)]);
var inst_25543 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25544 = [headers,vars,inst_25541];
var inst_25545 = cljs.core.PersistentHashMap.fromArrays(inst_25543,inst_25544);
var inst_25546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25547 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25548 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25545,inst_25546,inst_25547);
var state_25596__$1 = state_25596;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25596__$1,(29),inst_25548);
} else {
if((state_val_25597 === (16))){
var inst_25493 = (state_25596[(13)]);
var state_25596__$1 = state_25596;
var statearr_25657_25717 = state_25596__$1;
(statearr_25657_25717[(2)] = inst_25493);

(statearr_25657_25717[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (38))){
var inst_25567 = (state_25596[(14)]);
var state_25596__$1 = state_25596;
var statearr_25658_25718 = state_25596__$1;
(statearr_25658_25718[(2)] = inst_25567);

(statearr_25658_25718[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (30))){
var state_25596__$1 = state_25596;
var statearr_25659_25719 = state_25596__$1;
(statearr_25659_25719[(2)] = (1));

(statearr_25659_25719[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (10))){
var inst_25482 = (state_25596[(17)]);
var state_25596__$1 = state_25596;
var statearr_25660_25720 = state_25596__$1;
(statearr_25660_25720[(2)] = inst_25482);

(statearr_25660_25720[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (18))){
var inst_25498 = (state_25596[(18)]);
var inst_25500 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_25498);
var state_25596__$1 = state_25596;
var statearr_25661_25721 = state_25596__$1;
(statearr_25661_25721[(2)] = inst_25500);

(statearr_25661_25721[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (42))){
var inst_25587 = (state_25596[(2)]);
var state_25596__$1 = state_25596;
var statearr_25662_25722 = state_25596__$1;
(statearr_25662_25722[(2)] = inst_25587);

(statearr_25662_25722[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (37))){
var inst_25567 = (state_25596[(14)]);
var inst_25572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25573 = [inst_25567];
var inst_25574 = (new cljs.core.PersistentVector(null,1,(5),inst_25572,inst_25573,null));
var state_25596__$1 = state_25596;
var statearr_25663_25723 = state_25596__$1;
(statearr_25663_25723[(2)] = inst_25574);

(statearr_25663_25723[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25597 === (8))){
var inst_25591 = (state_25596[(2)]);
var _ = (function (){var statearr_25664 = state_25596;
(statearr_25664[(4)] = cljs.core.rest((state_25596[(4)])));

return statearr_25664;
})();
var state_25596__$1 = state_25596;
var statearr_25665_25724 = state_25596__$1;
(statearr_25665_25724[(2)] = inst_25591);

(statearr_25665_25724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0 = (function (){
var statearr_25666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25666[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__);

(statearr_25666[(1)] = (1));

return statearr_25666;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1 = (function (state_25596){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25596);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25667){var ex__2687__auto__ = e25667;
var statearr_25668_25725 = state_25596;
(statearr_25668_25725[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25596[(4)]))){
var statearr_25669_25726 = state_25596;
(statearr_25669_25726[(1)] = cljs.core.first((state_25596[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25727 = state_25596;
state_25596 = G__25727;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__ = function(state_25596){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1.call(this,state_25596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25670 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25670[(6)] = c__2706__auto__);

return statearr_25670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.process_ad_hoc_query = (function fluree$db$query$fql$process_ad_hoc_query(p__25728){
var map__25729 = p__25728;
var map__25729__$1 = cljs.core.__destructure_map(map__25729);
var opts = map__25729__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25729__$1,new cljs.core.Keyword(null,"db","db",993250759));
var parsed_query = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25729__$1,new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25729__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25729__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25749){
var state_val_25750 = (state_25749[(1)]);
if((state_val_25750 === (1))){
var state_25749__$1 = state_25749;
var statearr_25751_25765 = state_25749__$1;
(statearr_25751_25765[(2)] = null);

(statearr_25751_25765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25750 === (2))){
var _ = (function (){var statearr_25752 = state_25749;
(statearr_25752[(4)] = cljs.core.cons((5),(state_25749[(4)])));

return statearr_25752;
})();
var inst_25736 = fluree.db.query.analytical.q(opts);
var state_25749__$1 = state_25749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25749__$1,(6),inst_25736);
} else {
if((state_val_25750 === (3))){
var inst_25747 = (state_25749[(2)]);
var state_25749__$1 = state_25749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25749__$1,inst_25747);
} else {
if((state_val_25750 === (4))){
var inst_25730 = (state_25749[(2)]);
var state_25749__$1 = state_25749;
var statearr_25754_25766 = state_25749__$1;
(statearr_25754_25766[(2)] = inst_25730);

(statearr_25754_25766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25750 === (5))){
var _ = (function (){var statearr_25755 = state_25749;
(statearr_25755[(4)] = cljs.core.rest((state_25749[(4)])));

return statearr_25755;
})();
var state_25749__$1 = state_25749;
var ex25753 = (state_25749__$1[(2)]);
var statearr_25756_25767 = state_25749__$1;
(statearr_25756_25767[(5)] = ex25753);


if((ex25753 instanceof Error)){
var statearr_25757_25768 = state_25749__$1;
(statearr_25757_25768[(1)] = (4));

(statearr_25757_25768[(5)] = null);

} else {
throw ex25753;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25750 === (6))){
var inst_25738 = (state_25749[(2)]);
var inst_25739 = fluree.db.util.async.throw_err(inst_25738);
var inst_25740 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query);
var inst_25741 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25739,inst_25740,opts);
var state_25749__$1 = state_25749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25749__$1,(7),inst_25741);
} else {
if((state_val_25750 === (7))){
var inst_25743 = (state_25749[(2)]);
var inst_25744 = fluree.db.util.async.throw_err(inst_25743);
var _ = (function (){var statearr_25758 = state_25749;
(statearr_25758[(4)] = cljs.core.rest((state_25749[(4)])));

return statearr_25758;
})();
var state_25749__$1 = state_25749;
var statearr_25759_25769 = state_25749__$1;
(statearr_25759_25769[(2)] = inst_25744);

(statearr_25759_25769[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0 = (function (){
var statearr_25760 = [null,null,null,null,null,null,null];
(statearr_25760[(0)] = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__);

(statearr_25760[(1)] = (1));

return statearr_25760;
});
var fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1 = (function (state_25749){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25749);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25761){var ex__2687__auto__ = e25761;
var statearr_25762_25770 = state_25749;
(statearr_25762_25770[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25749[(4)]))){
var statearr_25763_25771 = state_25749;
(statearr_25763_25771[(1)] = cljs.core.first((state_25749[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25772 = state_25749;
state_25749 = G__25772;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__ = function(state_25749){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1.call(this,state_25749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$process_ad_hoc_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25764 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25764[(6)] = c__2706__auto__);

return statearr_25764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.fql.relationship_binding = (function fluree$db$query$fql$relationship_binding(p__25773){
var map__25774 = p__25773;
var map__25774__$1 = cljs.core.__destructure_map(map__25774);
var opts = map__25774__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25774__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25810){
var state_val_25811 = (state_25810[(1)]);
if((state_val_25811 === (1))){
var inst_25782 = vars;
var inst_25783 = cljs.core.seq(inst_25782);
var inst_25784 = cljs.core.first(inst_25783);
var inst_25785 = cljs.core.next(inst_25783);
var inst_25786 = cljs.core.PersistentVector.EMPTY;
var inst_25787 = inst_25782;
var inst_25788 = inst_25786;
var state_25810__$1 = (function (){var statearr_25812 = state_25810;
(statearr_25812[(7)] = inst_25788);

(statearr_25812[(8)] = inst_25787);

(statearr_25812[(9)] = inst_25784);

(statearr_25812[(10)] = inst_25785);

return statearr_25812;
})();
var statearr_25813_25826 = state_25810__$1;
(statearr_25813_25826[(2)] = null);

(statearr_25813_25826[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25811 === (2))){
var inst_25787 = (state_25810[(8)]);
var inst_25794 = (state_25810[(11)]);
var inst_25793 = cljs.core.seq(inst_25787);
var inst_25794__$1 = cljs.core.first(inst_25793);
var inst_25795 = cljs.core.next(inst_25793);
var state_25810__$1 = (function (){var statearr_25814 = state_25810;
(statearr_25814[(12)] = inst_25795);

(statearr_25814[(11)] = inst_25794__$1);

return statearr_25814;
})();
if(cljs.core.truth_(inst_25794__$1)){
var statearr_25815_25827 = state_25810__$1;
(statearr_25815_25827[(1)] = (4));

} else {
var statearr_25816_25828 = state_25810__$1;
(statearr_25816_25828[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25811 === (3))){
var inst_25808 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25810__$1,inst_25808);
} else {
if((state_val_25811 === (4))){
var inst_25794 = (state_25810[(11)]);
var inst_25797 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_25794);
var inst_25798 = fluree.db.query.fql.process_ad_hoc_query(inst_25797);
var state_25810__$1 = state_25810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25810__$1,(7),inst_25798);
} else {
if((state_val_25811 === (5))){
var inst_25788 = (state_25810[(7)]);
var state_25810__$1 = state_25810;
var statearr_25817_25829 = state_25810__$1;
(statearr_25817_25829[(2)] = inst_25788);

(statearr_25817_25829[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25811 === (6))){
var inst_25806 = (state_25810[(2)]);
var state_25810__$1 = state_25810;
var statearr_25818_25830 = state_25810__$1;
(statearr_25818_25830[(2)] = inst_25806);

(statearr_25818_25830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25811 === (7))){
var inst_25788 = (state_25810[(7)]);
var inst_25795 = (state_25810[(12)]);
var inst_25800 = (state_25810[(2)]);
var inst_25801 = fluree.db.util.async.throw_err(inst_25800);
var inst_25802 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25788,inst_25801);
var inst_25787 = inst_25795;
var inst_25788__$1 = inst_25802;
var state_25810__$1 = (function (){var statearr_25819 = state_25810;
(statearr_25819[(7)] = inst_25788__$1);

(statearr_25819[(8)] = inst_25787);

return statearr_25819;
})();
var statearr_25820_25831 = state_25810__$1;
(statearr_25820_25831[(2)] = null);

(statearr_25820_25831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0 = (function (){
var statearr_25821 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25821[(0)] = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__);

(statearr_25821[(1)] = (1));

return statearr_25821;
});
var fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1 = (function (state_25810){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25810);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25822){var ex__2687__auto__ = e25822;
var statearr_25823_25832 = state_25810;
(statearr_25823_25832[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25810[(4)]))){
var statearr_25824_25833 = state_25810;
(statearr_25824_25833[(1)] = cljs.core.first((state_25810[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25834 = state_25810;
state_25810 = G__25834;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__ = function(state_25810){
switch(arguments.length){
case 0:
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1.call(this,state_25810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____0;
fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto____1;
return fluree$db$query$fql$relationship_binding_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25825 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25825[(6)] = c__2706__auto__);

return statearr_25825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Legacy ad-hoc query processor
 */
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,p__25835,query_map){
var map__25836 = p__25835;
var map__25836__$1 = cljs.core.__destructure_map(map__25836);
var parsed_query = map__25836__$1;
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25836__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25836__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25837 = query_map;
var map__25837__$1 = cljs.core.__destructure_map(map__25837);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25837__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var opts_SINGLEQUOTE_ = (function (){var G__25838 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__5045__auto__ = offset;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
var G__25838__$1 = (cljs.core.truth_(selectOne)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25838,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1)):G__25838);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__25838__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.truth_((function (){var or__5045__auto____$1 = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})(),new cljs.core.Keyword(null,"parsed-query","parsed-query",-428212689),parsed_query,new cljs.core.Keyword(null,"query-map","query-map",-808576972),query_map,new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars], 0));

})();
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.fql.relationship_binding(opts_SINGLEQUOTE_);
} else {
return fluree.db.query.fql.process_ad_hoc_query(opts_SINGLEQUOTE_);
}
});
/**
 * Returns already cached query from cache if available, else
 *   executes and stores query into cache.
 */
fluree.db.query.fql.cache_query = (function fluree$db$query$fql$cache_query(p__25839,p__25840){
var map__25841 = p__25839;
var map__25841__$1 = cljs.core.__destructure_map(map__25841);
var db = map__25841__$1;
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25841__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25841__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25841__$1,new cljs.core.Keyword(null,"block","block",664686210));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25841__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25841__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var map__25842 = p__25840;
var map__25842__$1 = cljs.core.__destructure_map(map__25842);
var query_map = map__25842__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25842__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var oc = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
var query_STAR_ = cljs.core.update.cljs$core$IFn$_invoke$arity$5(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.dissoc,new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var cache_key = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query","query",-1288509510),network,ledger_id,block,auth,query_STAR_], null);
var G__25843 = cache_key;
var G__25844 = (function (_){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___25861 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25854){
var state_val_25855 = (state_25854[(1)]);
if((state_val_25855 === (1))){
var inst_25845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25846 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"cache","cache",-1237023054)];
var inst_25847 = (new cljs.core.PersistentVector(null,2,(5),inst_25845,inst_25846,null));
var inst_25848 = cljs.core.assoc_in(query_map,inst_25847,false);
var inst_25849 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_25848) : fluree.db.query.fql.query.call(null,db,inst_25848));
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25854__$1,(2),inst_25849);
} else {
if((state_val_25855 === (2))){
var inst_25851 = (state_25854[(2)]);
var inst_25852 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_25851);
var state_25854__$1 = state_25854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25854__$1,inst_25852);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto__ = null;
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0 = (function (){
var statearr_25856 = [null,null,null,null,null,null,null];
(statearr_25856[(0)] = fluree$db$query$fql$cache_query_$_state_machine__2684__auto__);

(statearr_25856[(1)] = (1));

return statearr_25856;
});
var fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1 = (function (state_25854){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25854);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25857){var ex__2687__auto__ = e25857;
var statearr_25858_25862 = state_25854;
(statearr_25858_25862[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25854[(4)]))){
var statearr_25859_25863 = state_25854;
(statearr_25859_25863[(1)] = cljs.core.first((state_25854[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25864 = state_25854;
state_25854 = G__25864;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__ = function(state_25854){
switch(arguments.length){
case 0:
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1.call(this,state_25854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$cache_query_$_state_machine__2684__auto____0;
fluree$db$query$fql$cache_query_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$cache_query_$_state_machine__2684__auto____1;
return fluree$db$query$fql$cache_query_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25860 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25860[(6)] = c__2706__auto___25861);

return statearr_25860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
});
return (oc.cljs$core$IFn$_invoke$arity$2 ? oc.cljs$core$IFn$_invoke$arity$2(G__25843,G__25844) : oc.call(null,G__25843,G__25844));
});
/**
 * Returns true if query was requested to run from the cache.
 */
fluree.db.query.fql.cache_QMARK_ = (function fluree$db$query$fql$cache_QMARK_(p__25865){
var map__25866 = p__25865;
var map__25866__$1 = cljs.core.__destructure_map(map__25866);
var _query_map = map__25866__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25866__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
return false;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var G__25867_25869 = "Running query:";
var G__25868_25870 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
(fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$2(G__25867_25869,G__25868_25870) : fluree.db.util.log.debug.call(null,G__25867_25869,G__25868_25870));

if(fluree.db.query.fql.cache_QMARK_(query_map)){
return fluree.db.query.fql.cache_query(db,query_map);
} else {
var parsed_query = fluree.db.query.analytical_parse.parse(db,query_map);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"ctx-cache","ctx-cache",-391738418),cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"simple-subject-crawl","simple-subject-crawl",1022725044),new cljs.core.Keyword(null,"strategy","strategy",-1471631918).cljs$core$IFn$_invoke$arity$1(parsed_query))){
return fluree.db.query.subject_crawl.core.simple_subject_crawl(db_STAR_,parsed_query);
} else {
return fluree.db.query.fql.ad_hoc_query(db_STAR_,parsed_query,query_map);
}
}
});
