// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20102){var e = e20102;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20103_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20103_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20103_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20103_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20103_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20104_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20104_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20105_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20105_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_(key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20110 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20110,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20110,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20106_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20106_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20113 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20113,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20113,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20107_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20107_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20108_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20108_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20109_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20109_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (tuple){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20116_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__20116_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(headers,var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes(vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs(idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__20117 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20117) : intersecting_vars.call(null,G__20117));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20120,optional_QMARK_,fuel,max_fuel){
var map__20121 = p__20120;
var map__20121__$1 = cljs.core.__destructure_map(map__20121);
var res = map__20121__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20121__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20187){
var state_val_20188 = (state_20187[(1)]);
if((state_val_20188 === (7))){
var inst_20176 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20177 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20178 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20177,clause);
var inst_20179 = [null,inst_20178];
var inst_20180 = (new cljs.core.PersistentVector(null,2,(5),inst_20176,inst_20179,null));
var state_20187__$1 = state_20187;
var statearr_20189_20217 = state_20187__$1;
(statearr_20189_20217[(2)] = inst_20180);

(statearr_20189_20217[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (1))){
var state_20187__$1 = state_20187;
var statearr_20190_20218 = state_20187__$1;
(statearr_20190_20218[(2)] = null);

(statearr_20190_20218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (4))){
var inst_20122 = (state_20187[(2)]);
var state_20187__$1 = state_20187;
var statearr_20191_20219 = state_20187__$1;
(statearr_20191_20219[(2)] = inst_20122);

(statearr_20191_20219[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (15))){
var inst_20165 = (state_20187[(2)]);
var inst_20166 = fluree.db.util.async.throw_err(inst_20165);
var inst_20167 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20166);
var inst_20168 = cljs.core.count(inst_20167);
var inst_20169 = fluree.db.query.analytical.add_fuel(inst_20168,fuel,max_fuel);
var inst_20170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20171 = [inst_20166,r];
var inst_20172 = (new cljs.core.PersistentVector(null,2,(5),inst_20170,inst_20171,null));
var state_20187__$1 = (function (){var statearr_20192 = state_20187;
(statearr_20192[(7)] = inst_20169);

return statearr_20192;
})();
var statearr_20193_20220 = state_20187__$1;
(statearr_20193_20220[(2)] = inst_20172);

(statearr_20193_20220[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (13))){
var inst_20131 = (state_20187[(8)]);
var inst_20144 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20145 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20144);
var inst_20146 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20131);
var inst_20147 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20146);
var inst_20148 = cljs.core.set(inst_20147);
var inst_20149 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20145);
var inst_20150 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20149);
var inst_20151 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20148,inst_20150);
var inst_20152 = (function (){var all_wd = inst_20131;
var optional = inst_20145;
var all_wd_vars = inst_20148;
var all_vars = inst_20151;
return (function (p1__20118_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20118_SHARP_) : all_vars.call(null,p1__20118_SHARP_));
});
})();
var inst_20153 = cljs.core.keys(vars);
var inst_20154 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20152,inst_20153);
var inst_20155 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20154);
var inst_20156 = cljs.core.set(inst_20155);
var inst_20157 = (function (){var all_wd = inst_20131;
var optional = inst_20145;
var all_wd_vars = inst_20148;
var all_vars = inst_20151;
var intersecting_vars = inst_20156;
return (function (p1__20119_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20119_SHARP_);
});
})();
var inst_20158 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20157,inst_20131);
var inst_20159 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20158);
var inst_20160 = fluree.db.query.analytical.select_from_tuples(inst_20159,res);
var inst_20161 = fluree.db.query.analytical.replace_vars_wikidata(inst_20131,inst_20156,vars);
var inst_20162 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20156,inst_20151);
var inst_20163 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20161,inst_20159,inst_20160,inst_20162,inst_20145);
var state_20187__$1 = state_20187;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20187__$1,(15),inst_20163);
} else {
if((state_val_20188 === (6))){
var inst_20132 = (state_20187[(9)]);
var inst_20130 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20131 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20130);
var inst_20132__$1 = optional_QMARK_;
var state_20187__$1 = (function (){var statearr_20194 = state_20187;
(statearr_20194[(9)] = inst_20132__$1);

(statearr_20194[(8)] = inst_20131);

return statearr_20194;
})();
if(cljs.core.truth_(inst_20132__$1)){
var statearr_20195_20221 = state_20187__$1;
(statearr_20195_20221[(1)] = (9));

} else {
var statearr_20196_20222 = state_20187__$1;
(statearr_20196_20222[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (3))){
var inst_20185 = (state_20187[(2)]);
var state_20187__$1 = state_20187;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20187__$1,inst_20185);
} else {
if((state_val_20188 === (12))){
var inst_20140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20141 = [null,r];
var inst_20142 = (new cljs.core.PersistentVector(null,2,(5),inst_20140,inst_20141,null));
var state_20187__$1 = state_20187;
var statearr_20197_20223 = state_20187__$1;
(statearr_20197_20223[(2)] = inst_20142);

(statearr_20197_20223[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (2))){
var _ = (function (){var statearr_20198 = state_20187;
(statearr_20198[(4)] = cljs.core.cons((5),(state_20187[(4)])));

return statearr_20198;
})();
var inst_20128 = (r == null);
var state_20187__$1 = state_20187;
if(cljs.core.truth_(inst_20128)){
var statearr_20199_20224 = state_20187__$1;
(statearr_20199_20224[(1)] = (6));

} else {
var statearr_20200_20225 = state_20187__$1;
(statearr_20200_20225[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (11))){
var inst_20138 = (state_20187[(2)]);
var state_20187__$1 = state_20187;
if(cljs.core.truth_(inst_20138)){
var statearr_20202_20226 = state_20187__$1;
(statearr_20202_20226[(1)] = (12));

} else {
var statearr_20203_20227 = state_20187__$1;
(statearr_20203_20227[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (9))){
var inst_20131 = (state_20187[(8)]);
var inst_20134 = cljs.core.empty_QMARK_(inst_20131);
var inst_20135 = (!(inst_20134));
var state_20187__$1 = state_20187;
var statearr_20204_20228 = state_20187__$1;
(statearr_20204_20228[(2)] = inst_20135);

(statearr_20204_20228[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (5))){
var _ = (function (){var statearr_20205 = state_20187;
(statearr_20205[(4)] = cljs.core.rest((state_20187[(4)])));

return statearr_20205;
})();
var state_20187__$1 = state_20187;
var ex20201 = (state_20187__$1[(2)]);
var statearr_20206_20229 = state_20187__$1;
(statearr_20206_20229[(5)] = ex20201);


if((ex20201 instanceof Error)){
var statearr_20207_20230 = state_20187__$1;
(statearr_20207_20230[(1)] = (4));

(statearr_20207_20230[(5)] = null);

} else {
throw ex20201;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (14))){
var inst_20174 = (state_20187[(2)]);
var state_20187__$1 = state_20187;
var statearr_20208_20231 = state_20187__$1;
(statearr_20208_20231[(2)] = inst_20174);

(statearr_20208_20231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (10))){
var inst_20132 = (state_20187[(9)]);
var state_20187__$1 = state_20187;
var statearr_20209_20232 = state_20187__$1;
(statearr_20209_20232[(2)] = inst_20132);

(statearr_20209_20232[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20188 === (8))){
var inst_20182 = (state_20187[(2)]);
var _ = (function (){var statearr_20210 = state_20187;
(statearr_20210[(4)] = cljs.core.rest((state_20187[(4)])));

return statearr_20210;
})();
var state_20187__$1 = state_20187;
var statearr_20211_20233 = state_20187__$1;
(statearr_20211_20233[(2)] = inst_20182);

(statearr_20211_20233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_20212 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20212[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__);

(statearr_20212[(1)] = (1));

return statearr_20212;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1 = (function (state_20187){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20187);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20213){var ex__2687__auto__ = e20213;
var statearr_20214_20234 = state_20187;
(statearr_20214_20234[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20187[(4)]))){
var statearr_20215_20235 = state_20187;
(statearr_20215_20235[(1)] = cljs.core.first((state_20187[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20236 = state_20187;
state_20187 = G__20236;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__ = function(state_20187){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1.call(this,state_20187);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20216 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20216[(6)] = c__2706__auto__);

return statearr_20216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find(/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find(/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20238 = arguments.length;
switch (G__20238) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20332){
var state_val_20333 = (state_20332[(1)]);
if((state_val_20333 === (7))){
var inst_20245 = (state_20332[(7)]);
var inst_20255 = clojure.string.starts_with_QMARK_(inst_20245,"$fdb");
var state_20332__$1 = state_20332;
if(inst_20255){
var statearr_20334_20383 = state_20332__$1;
(statearr_20334_20383[(1)] = (9));

} else {
var statearr_20335_20384 = state_20332__$1;
(statearr_20335_20384[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (20))){
var state_20332__$1 = state_20332;
var statearr_20336_20385 = state_20332__$1;
(statearr_20336_20385[(2)] = null);

(statearr_20336_20385[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (27))){
var inst_20295 = (state_20332[(8)]);
var state_20332__$1 = state_20332;
var statearr_20337_20386 = state_20332__$1;
(statearr_20337_20386[(2)] = inst_20295);

(statearr_20337_20386[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (1))){
var state_20332__$1 = state_20332;
var statearr_20338_20387 = state_20332__$1;
(statearr_20338_20387[(2)] = null);

(statearr_20338_20387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (24))){
var inst_20318 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20339_20388 = state_20332__$1;
(statearr_20339_20388[(2)] = inst_20318);

(statearr_20339_20388[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (4))){
var inst_20239 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20340_20389 = state_20332__$1;
(statearr_20340_20389[(2)] = inst_20239);

(statearr_20340_20389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (15))){
var inst_20262 = (state_20332[(9)]);
var inst_20268 = (state_20332[(2)]);
var inst_20269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20270 = cljs.core.PersistentVector.EMPTY;
var inst_20271 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20272 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20270,inst_20271);
var inst_20273 = [inst_20262,inst_20272];
var inst_20274 = (new cljs.core.PersistentVector(null,2,(5),inst_20269,inst_20273,null));
var state_20332__$1 = (function (){var statearr_20341 = state_20332;
(statearr_20341[(10)] = inst_20268);

return statearr_20341;
})();
var statearr_20342_20390 = state_20332__$1;
(statearr_20342_20390[(2)] = inst_20274);

(statearr_20342_20390[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (21))){
var inst_20321 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20343_20391 = state_20332__$1;
(statearr_20343_20391[(2)] = inst_20321);

(statearr_20343_20391[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (13))){
var inst_20262 = (state_20332[(9)]);
var inst_20265 = (function(){throw inst_20262})();
var state_20332__$1 = state_20332;
var statearr_20344_20392 = state_20332__$1;
(statearr_20344_20392[(2)] = inst_20265);

(statearr_20344_20392[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (22))){
var inst_20286 = (state_20332[(11)]);
var inst_20284 = (state_20332[(12)]);
var inst_20288 = fluree.db.query.analytical.parse_block_from_source(inst_20284);
var inst_20289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20290 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20286];
var inst_20291 = (new cljs.core.PersistentVector(null,2,(5),inst_20289,inst_20290,null));
var inst_20292 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20291);
var state_20332__$1 = (function (){var statearr_20345 = state_20332;
(statearr_20345[(13)] = inst_20288);

return statearr_20345;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20332__$1,(25),inst_20292);
} else {
if((state_val_20333 === (29))){
var inst_20299 = (state_20332[(2)]);
var inst_20300 = fluree.db.util.async.throw_err(inst_20299);
var state_20332__$1 = state_20332;
var statearr_20346_20393 = state_20332__$1;
(statearr_20346_20393[(2)] = inst_20300);

(statearr_20346_20393[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (6))){
var inst_20248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20249 = cljs.core.PersistentVector.EMPTY;
var inst_20250 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20251 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20249,inst_20250);
var inst_20252 = [db,inst_20251];
var inst_20253 = (new cljs.core.PersistentVector(null,2,(5),inst_20248,inst_20252,null));
var state_20332__$1 = state_20332;
var statearr_20347_20394 = state_20332__$1;
(statearr_20347_20394[(2)] = inst_20253);

(statearr_20347_20394[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (28))){
var inst_20303 = (state_20332[(2)]);
var inst_20304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20305 = cljs.core.PersistentVector.EMPTY;
var inst_20306 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20307 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20305,inst_20306);
var inst_20308 = [inst_20303,inst_20307];
var inst_20309 = (new cljs.core.PersistentVector(null,2,(5),inst_20304,inst_20308,null));
var state_20332__$1 = state_20332;
var statearr_20348_20395 = state_20332__$1;
(statearr_20348_20395[(2)] = inst_20309);

(statearr_20348_20395[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (25))){
var inst_20288 = (state_20332[(13)]);
var inst_20294 = (state_20332[(2)]);
var inst_20295 = fluree.db.util.async.throw_err(inst_20294);
var state_20332__$1 = (function (){var statearr_20349 = state_20332;
(statearr_20349[(8)] = inst_20295);

return statearr_20349;
})();
if(cljs.core.truth_(inst_20288)){
var statearr_20350_20396 = state_20332__$1;
(statearr_20350_20396[(1)] = (26));

} else {
var statearr_20351_20397 = state_20332__$1;
(statearr_20351_20397[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (17))){
var state_20332__$1 = state_20332;
var statearr_20352_20398 = state_20332__$1;
(statearr_20352_20398[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (3))){
var inst_20330 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20332__$1,inst_20330);
} else {
if((state_val_20333 === (12))){
var inst_20262 = (state_20332[(9)]);
var inst_20261 = (state_20332[(2)]);
var inst_20262__$1 = fluree.db.util.async.throw_err(inst_20261);
var inst_20263 = fluree.db.util.core.exception_QMARK_(inst_20262__$1);
var state_20332__$1 = (function (){var statearr_20354 = state_20332;
(statearr_20354[(9)] = inst_20262__$1);

return statearr_20354;
})();
if(inst_20263){
var statearr_20355_20399 = state_20332__$1;
(statearr_20355_20399[(1)] = (13));

} else {
var statearr_20356_20400 = state_20332__$1;
(statearr_20356_20400[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (2))){
var inst_20245 = (state_20332[(7)]);
var _ = (function (){var statearr_20357 = state_20332;
(statearr_20357[(4)] = cljs.core.cons((5),(state_20332[(4)])));

return statearr_20357;
})();
var inst_20245__$1 = cljs.core.first(clause);
var inst_20246 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20245__$1);
var state_20332__$1 = (function (){var statearr_20358 = state_20332;
(statearr_20358[(7)] = inst_20245__$1);

return statearr_20358;
})();
if(inst_20246){
var statearr_20359_20401 = state_20332__$1;
(statearr_20359_20401[(1)] = (6));

} else {
var statearr_20360_20402 = state_20332__$1;
(statearr_20360_20402[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (23))){
var inst_20245 = (state_20332[(7)]);
var inst_20311 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20245)," is not supported in Fluree"].join('');
var inst_20312 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20313 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20314 = cljs.core.PersistentHashMap.fromArrays(inst_20312,inst_20313);
var inst_20315 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20311,inst_20314);
var inst_20316 = (function(){throw inst_20315})();
var state_20332__$1 = state_20332;
var statearr_20361_20403 = state_20332__$1;
(statearr_20361_20403[(2)] = inst_20316);

(statearr_20361_20403[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (19))){
var inst_20286 = (state_20332[(11)]);
var inst_20245 = (state_20332[(7)]);
var inst_20283 = fluree.db.query.analytical.isolate_source_name(inst_20245);
var inst_20284 = fluree.db.query.analytical.isolate_source_block(inst_20245);
var inst_20285 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20283);
var inst_20286__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20285);
var state_20332__$1 = (function (){var statearr_20362 = state_20332;
(statearr_20362[(11)] = inst_20286__$1);

(statearr_20362[(12)] = inst_20284);

return statearr_20362;
})();
if(cljs.core.truth_(inst_20286__$1)){
var statearr_20363_20404 = state_20332__$1;
(statearr_20363_20404[(1)] = (22));

} else {
var statearr_20364_20405 = state_20332__$1;
(statearr_20364_20405[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (11))){
var inst_20325 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20366_20406 = state_20332__$1;
(statearr_20366_20406[(2)] = inst_20325);

(statearr_20366_20406[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (9))){
var inst_20245 = (state_20332[(7)]);
var inst_20257 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20245,(4));
var inst_20258 = fluree.db.query.analytical.parse_block_from_source(inst_20257);
var inst_20259 = fluree.db.time_travel.as_of_block(db,inst_20258);
var state_20332__$1 = state_20332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20332__$1,(12),inst_20259);
} else {
if((state_val_20333 === (5))){
var _ = (function (){var statearr_20367 = state_20332;
(statearr_20367[(4)] = cljs.core.rest((state_20332[(4)])));

return statearr_20367;
})();
var state_20332__$1 = state_20332;
var ex20365 = (state_20332__$1[(2)]);
var statearr_20368_20407 = state_20332__$1;
(statearr_20368_20407[(5)] = ex20365);


if((ex20365 instanceof Error)){
var statearr_20369_20408 = state_20332__$1;
(statearr_20369_20408[(1)] = (4));

(statearr_20369_20408[(5)] = null);

} else {
throw ex20365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (14))){
var state_20332__$1 = state_20332;
var statearr_20370_20409 = state_20332__$1;
(statearr_20370_20409[(2)] = null);

(statearr_20370_20409[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (26))){
var inst_20295 = (state_20332[(8)]);
var inst_20288 = (state_20332[(13)]);
var inst_20297 = fluree.db.time_travel.as_of_block(inst_20295,inst_20288);
var state_20332__$1 = state_20332;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20332__$1,(29),inst_20297);
} else {
if((state_val_20333 === (16))){
var inst_20278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20279 = ["$wd",clause];
var inst_20280 = (new cljs.core.PersistentVector(null,2,(5),inst_20278,inst_20279,null));
var state_20332__$1 = state_20332;
var statearr_20371_20410 = state_20332__$1;
(statearr_20371_20410[(2)] = inst_20280);

(statearr_20371_20410[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (10))){
var inst_20245 = (state_20332[(7)]);
var inst_20276 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20245);
var state_20332__$1 = state_20332;
if(inst_20276){
var statearr_20372_20411 = state_20332__$1;
(statearr_20372_20411[(1)] = (16));

} else {
var statearr_20373_20412 = state_20332__$1;
(statearr_20373_20412[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (18))){
var inst_20323 = (state_20332[(2)]);
var state_20332__$1 = state_20332;
var statearr_20374_20413 = state_20332__$1;
(statearr_20374_20413[(2)] = inst_20323);

(statearr_20374_20413[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20333 === (8))){
var inst_20327 = (state_20332[(2)]);
var _ = (function (){var statearr_20375 = state_20332;
(statearr_20375[(4)] = cljs.core.rest((state_20332[(4)])));

return statearr_20375;
})();
var state_20332__$1 = state_20332;
var statearr_20376_20414 = state_20332__$1;
(statearr_20376_20414[(2)] = inst_20327);

(statearr_20376_20414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_20377 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20377[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_20377[(1)] = (1));

return statearr_20377;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_20332){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20332);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20378){var ex__2687__auto__ = e20378;
var statearr_20379_20415 = state_20332;
(statearr_20379_20415[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20332[(4)]))){
var statearr_20380_20416 = state_20332;
(statearr_20380_20416[(1)] = cljs.core.first((state_20332[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20417 = state_20332;
state_20332 = G__20417;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_20332){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_20332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20381 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20381[(6)] = c__2706__auto__);

return statearr_20381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20418){
var vec__20419 = p__20418;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20419,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20419,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20422_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20422_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20426 = subjects;
var vec__20427 = G__20426;
var seq__20428 = cljs.core.seq(vec__20427);
var first__20429 = cljs.core.first(seq__20428);
var seq__20428__$1 = cljs.core.next(seq__20428);
var subject = first__20429;
var r = seq__20428__$1;
var acc = expanded_map;
var G__20426__$1 = G__20426;
var acc__$1 = acc;
while(true){
var vec__20433 = G__20426__$1;
var seq__20434 = cljs.core.seq(vec__20433);
var first__20435 = cljs.core.first(seq__20434);
var seq__20434__$1 = cljs.core.next(seq__20434);
var subject__$1 = first__20435;
var r__$1 = seq__20434__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20436 = r__$1;
var G__20437 = acc__$2;
G__20426__$1 = G__20436;
acc__$1 = G__20437;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20426__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20433,seq__20434,first__20435,seq__20434__$1,subject__$1,r__$1,acc__$2,G__20426,vec__20427,seq__20428,first__20429,seq__20428__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20426__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20433,seq__20434,first__20435,seq__20434__$1,subject__$1,r__$1,acc__$2,G__20426,vec__20427,seq__20428,first__20429,seq__20428__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20426__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20433,seq__20434,first__20435,seq__20434__$1,subject__$1,r__$1,acc__$2,G__20426,vec__20427,seq__20428,first__20429,seq__20428__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20426__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20433,seq__20434,first__20435,seq__20434__$1,subject__$1,r__$1,acc__$2,G__20426,vec__20427,seq__20428,first__20429,seq__20428__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20426__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20433,seq__20434,first__20435,seq__20434__$1,subject__$1,r__$1,acc__$2,G__20426,vec__20427,seq__20428,first__20429,seq__20428__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20426__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20433,seq__20434,first__20435,seq__20434__$1,subject__$1,r__$1,acc__$2,G__20426,vec__20427,seq__20428,first__20429,seq__20428__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20438 = r__$1;
var G__20439 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20426__$1 = G__20438;
acc__$1 = G__20439;
continue;
} else {
var G__20440 = subjects;
var G__20441 = acc_STAR_;
G__20426__$1 = G__20440;
acc__$1 = G__20441;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20442_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20442_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20533){
var state_val_20534 = (state_20533[(1)]);
if((state_val_20534 === (7))){
var state_20533__$1 = state_20533;
var statearr_20535_20581 = state_20533__$1;
(statearr_20535_20581[(2)] = (100));

(statearr_20535_20581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (20))){
var inst_20482 = (state_20533[(7)]);
var state_20533__$1 = state_20533;
var statearr_20536_20582 = state_20533__$1;
(statearr_20536_20582[(2)] = inst_20482);

(statearr_20536_20582[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (1))){
var state_20533__$1 = state_20533;
var statearr_20537_20583 = state_20533__$1;
(statearr_20537_20583[(2)] = null);

(statearr_20537_20583[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (24))){
var inst_20520 = (state_20533[(8)]);
var inst_20521 = (state_20533[(9)]);
var inst_20519 = (state_20533[(10)]);
var inst_20454 = (state_20533[(11)]);
var inst_20524 = (function (){var max_depth = inst_20454;
var recur_map__$1 = inst_20520;
var subjects = inst_20519;
var tuples = inst_20521;
return (function (p1__20443_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20443_SHARP_)],null));
});
})();
var inst_20525 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20524,inst_20521);
var inst_20526 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20525);
var state_20533__$1 = state_20533;
var statearr_20538_20584 = state_20533__$1;
(statearr_20538_20584[(2)] = inst_20526);

(statearr_20538_20584[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (4))){
var inst_20444 = (state_20533[(2)]);
var state_20533__$1 = state_20533;
var statearr_20539_20585 = state_20533__$1;
(statearr_20539_20585[(2)] = inst_20444);

(statearr_20539_20585[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (15))){
var inst_20467 = (state_20533[(12)]);
var inst_20478 = cljs.core.PersistentVector.EMPTY;
var inst_20479 = cljs.core.seq(inst_20467);
var inst_20480 = cljs.core.first(inst_20479);
var inst_20481 = cljs.core.next(inst_20479);
var inst_20482 = inst_20478;
var inst_20483 = inst_20467;
var state_20533__$1 = (function (){var statearr_20540 = state_20533;
(statearr_20540[(13)] = inst_20483);

(statearr_20540[(7)] = inst_20482);

(statearr_20540[(14)] = inst_20480);

(statearr_20540[(15)] = inst_20481);

return statearr_20540;
})();
var statearr_20541_20586 = state_20533__$1;
(statearr_20541_20586[(2)] = null);

(statearr_20541_20586[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (21))){
var inst_20503 = (state_20533[(2)]);
var state_20533__$1 = state_20533;
var statearr_20542_20587 = state_20533__$1;
(statearr_20542_20587[(2)] = inst_20503);

(statearr_20542_20587[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (13))){
var inst_20516 = (state_20533[(2)]);
var state_20533__$1 = state_20533;
var statearr_20543_20588 = state_20533__$1;
(statearr_20543_20588[(2)] = inst_20516);

(statearr_20543_20588[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (22))){
var inst_20482 = (state_20533[(7)]);
var inst_20490 = (state_20533[(16)]);
var inst_20497 = (state_20533[(2)]);
var inst_20498 = fluree.db.util.async.throw_err(inst_20497);
var inst_20499 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20482,inst_20498);
var inst_20482__$1 = inst_20499;
var inst_20483 = inst_20490;
var state_20533__$1 = (function (){var statearr_20544 = state_20533;
(statearr_20544[(13)] = inst_20483);

(statearr_20544[(7)] = inst_20482__$1);

return statearr_20544;
})();
var statearr_20545_20589 = state_20533__$1;
(statearr_20545_20589[(2)] = null);

(statearr_20545_20589[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (6))){
var inst_20450 = (state_20533[(17)]);
var state_20533__$1 = state_20533;
var statearr_20546_20590 = state_20533__$1;
(statearr_20546_20590[(2)] = inst_20450);

(statearr_20546_20590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (25))){
var inst_20528 = (state_20533[(2)]);
var _ = (function (){var statearr_20547 = state_20533;
(statearr_20547[(4)] = cljs.core.rest((state_20533[(4)])));

return statearr_20547;
})();
var state_20533__$1 = state_20533;
var statearr_20548_20591 = state_20533__$1;
(statearr_20548_20591[(2)] = inst_20528);

(statearr_20548_20591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (17))){
var inst_20483 = (state_20533[(13)]);
var inst_20489 = (state_20533[(18)]);
var inst_20488 = cljs.core.seq(inst_20483);
var inst_20489__$1 = cljs.core.first(inst_20488);
var inst_20490 = cljs.core.next(inst_20488);
var state_20533__$1 = (function (){var statearr_20549 = state_20533;
(statearr_20549[(16)] = inst_20490);

(statearr_20549[(18)] = inst_20489__$1);

return statearr_20549;
})();
if(cljs.core.truth_(inst_20489__$1)){
var statearr_20550_20592 = state_20533__$1;
(statearr_20550_20592[(1)] = (19));

} else {
var statearr_20551_20593 = state_20533__$1;
(statearr_20551_20593[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (3))){
var inst_20531 = (state_20533[(2)]);
var state_20533__$1 = state_20533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20533__$1,inst_20531);
} else {
if((state_val_20534 === (12))){
var inst_20456 = (state_20533[(19)]);
var inst_20467 = (state_20533[(12)]);
var inst_20462 = cljs.core.vals(inst_20456);
var inst_20463 = cljs.core.flatten(inst_20462);
var inst_20464 = cljs.core.set(inst_20463);
var inst_20465 = cljs.core.keys(inst_20456);
var inst_20466 = cljs.core.set(inst_20465);
var inst_20467__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20464,inst_20466);
var inst_20468 = cljs.core.empty_QMARK_(inst_20467__$1);
var state_20533__$1 = (function (){var statearr_20552 = state_20533;
(statearr_20552[(12)] = inst_20467__$1);

return statearr_20552;
})();
if(inst_20468){
var statearr_20553_20594 = state_20533__$1;
(statearr_20553_20594[(1)] = (14));

} else {
var statearr_20554_20595 = state_20533__$1;
(statearr_20554_20595[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (2))){
var inst_20450 = (state_20533[(17)]);
var _ = (function (){var statearr_20555 = state_20533;
(statearr_20555[(4)] = cljs.core.cons((5),(state_20533[(4)])));

return statearr_20555;
})();
var inst_20450__$1 = depth;
var state_20533__$1 = (function (){var statearr_20556 = state_20533;
(statearr_20556[(17)] = inst_20450__$1);

return statearr_20556;
})();
if(cljs.core.truth_(inst_20450__$1)){
var statearr_20557_20596 = state_20533__$1;
(statearr_20557_20596[(1)] = (6));

} else {
var statearr_20558_20597 = state_20533__$1;
(statearr_20558_20597[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (23))){
var inst_20521 = (state_20533[(9)]);
var state_20533__$1 = state_20533;
var statearr_20559_20598 = state_20533__$1;
(statearr_20559_20598[(2)] = inst_20521);

(statearr_20559_20598[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (19))){
var inst_20489 = (state_20533[(18)]);
var inst_20492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20493 = [inst_20489,predicate];
var inst_20494 = (new cljs.core.PersistentVector(null,2,(5),inst_20492,inst_20493,null));
var inst_20495 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20494);
var state_20533__$1 = state_20533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20533__$1,(22),inst_20495);
} else {
if((state_val_20534 === (11))){
var inst_20456 = (state_20533[(19)]);
var state_20533__$1 = state_20533;
var statearr_20561_20599 = state_20533__$1;
(statearr_20561_20599[(2)] = inst_20456);

(statearr_20561_20599[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (9))){
var inst_20454 = (state_20533[(11)]);
var inst_20457 = (state_20533[(20)]);
var inst_20459 = (inst_20457 >= inst_20454);
var state_20533__$1 = state_20533;
if(cljs.core.truth_(inst_20459)){
var statearr_20562_20600 = state_20533__$1;
(statearr_20562_20600[(1)] = (11));

} else {
var statearr_20563_20601 = state_20533__$1;
(statearr_20563_20601[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (5))){
var _ = (function (){var statearr_20564 = state_20533;
(statearr_20564[(4)] = cljs.core.rest((state_20533[(4)])));

return statearr_20564;
})();
var state_20533__$1 = state_20533;
var ex20560 = (state_20533__$1[(2)]);
var statearr_20565_20602 = state_20533__$1;
(statearr_20565_20602[(5)] = ex20560);


if((ex20560 instanceof Error)){
var statearr_20566_20603 = state_20533__$1;
(statearr_20566_20603[(1)] = (4));

(statearr_20566_20603[(5)] = null);

} else {
throw ex20560;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (14))){
var inst_20456 = (state_20533[(19)]);
var state_20533__$1 = state_20533;
var statearr_20567_20604 = state_20533__$1;
(statearr_20567_20604[(2)] = inst_20456);

(statearr_20567_20604[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (16))){
var inst_20514 = (state_20533[(2)]);
var state_20533__$1 = state_20533;
var statearr_20568_20605 = state_20533__$1;
(statearr_20568_20605[(2)] = inst_20514);

(statearr_20568_20605[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (10))){
var inst_20520 = (state_20533[(8)]);
var inst_20519 = (state_20533[(10)]);
var inst_20518 = (state_20533[(2)]);
var inst_20519__$1 = cljs.core.keys(inst_20518);
var inst_20520__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20519__$1,inst_20518);
var inst_20521 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20519__$1,inst_20520__$1);
var state_20533__$1 = (function (){var statearr_20569 = state_20533;
(statearr_20569[(8)] = inst_20520__$1);

(statearr_20569[(9)] = inst_20521);

(statearr_20569[(10)] = inst_20519__$1);

return statearr_20569;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20570_20606 = state_20533__$1;
(statearr_20570_20606[(1)] = (23));

} else {
var statearr_20571_20607 = state_20533__$1;
(statearr_20571_20607[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (18))){
var inst_20456 = (state_20533[(19)]);
var inst_20457 = (state_20533[(20)]);
var inst_20505 = (state_20533[(2)]);
var inst_20506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20507 = [(0),(2)];
var inst_20508 = (new cljs.core.PersistentVector(null,2,(5),inst_20506,inst_20507,null));
var inst_20509 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_20508,inst_20505);
var inst_20510 = fluree.db.query.analytical.tuples__GT_map(inst_20456,inst_20509);
var inst_20511 = (inst_20457 + (1));
var inst_20456__$1 = inst_20510;
var inst_20457__$1 = inst_20511;
var state_20533__$1 = (function (){var statearr_20572 = state_20533;
(statearr_20572[(19)] = inst_20456__$1);

(statearr_20572[(20)] = inst_20457__$1);

return statearr_20572;
})();
var statearr_20573_20608 = state_20533__$1;
(statearr_20573_20608[(2)] = null);

(statearr_20573_20608[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20534 === (8))){
var inst_20454 = (state_20533[(2)]);
var inst_20455 = recur_map;
var inst_20456 = inst_20455;
var inst_20457 = (1);
var state_20533__$1 = (function (){var statearr_20574 = state_20533;
(statearr_20574[(19)] = inst_20456);

(statearr_20574[(11)] = inst_20454);

(statearr_20574[(20)] = inst_20457);

return statearr_20574;
})();
var statearr_20575_20609 = state_20533__$1;
(statearr_20575_20609[(2)] = null);

(statearr_20575_20609[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0 = (function (){
var statearr_20576 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20576[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__);

(statearr_20576[(1)] = (1));

return statearr_20576;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1 = (function (state_20533){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20533);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20577){var ex__2687__auto__ = e20577;
var statearr_20578_20610 = state_20533;
(statearr_20578_20610[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20533[(4)]))){
var statearr_20579_20611 = state_20533;
(statearr_20579_20611[(1)] = cljs.core.first((state_20533[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20612 = state_20533;
state_20533 = G__20612;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__ = function(state_20533){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1.call(this,state_20533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20580 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20580[(6)] = c__2706__auto__);

return statearr_20580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20613,clause,fuel,max_fuel){
var map__20614 = p__20613;
var map__20614__$1 = cljs.core.__destructure_map(map__20614);
var res = map__20614__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20614__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20614__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20614__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20725){
var state_val_20726 = (state_20725[(1)]);
if((state_val_20726 === (7))){
var inst_20631 = (state_20725[(7)]);
var state_20725__$1 = state_20725;
var statearr_20727_20780 = state_20725__$1;
(statearr_20727_20780[(2)] = inst_20631);

(statearr_20727_20780[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (20))){
var inst_20659 = (state_20725[(8)]);
var inst_20690 = typeof inst_20659 === 'number';
var state_20725__$1 = state_20725;
if(cljs.core.truth_(inst_20690)){
var statearr_20728_20781 = state_20725__$1;
(statearr_20728_20781[(1)] = (22));

} else {
var statearr_20729_20782 = state_20725__$1;
(statearr_20729_20782[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (27))){
var inst_20705 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20730_20783 = state_20725__$1;
(statearr_20730_20783[(2)] = inst_20705);

(statearr_20730_20783[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (1))){
var state_20725__$1 = state_20725;
var statearr_20731_20784 = state_20725__$1;
(statearr_20731_20784[(2)] = null);

(statearr_20731_20784[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (24))){
var inst_20707 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20732_20785 = state_20725__$1;
(statearr_20732_20785[(2)] = inst_20707);

(statearr_20732_20785[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (4))){
var inst_20615 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20733_20786 = state_20725__$1;
(statearr_20733_20786[(2)] = inst_20615);

(statearr_20733_20786[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (15))){
var inst_20673 = (state_20725[(2)]);
var inst_20674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20675 = fluree.db.query.analytical.variable_QMARK_(inst_20674);
var state_20725__$1 = (function (){var statearr_20734 = state_20725;
(statearr_20734[(9)] = inst_20673);

return statearr_20734;
})();
if(cljs.core.truth_(inst_20675)){
var statearr_20735_20787 = state_20725__$1;
(statearr_20735_20787[(1)] = (16));

} else {
var statearr_20736_20788 = state_20725__$1;
(statearr_20736_20788[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (21))){
var inst_20662 = (state_20725[(10)]);
var inst_20632 = (state_20725[(11)]);
var inst_20661 = (state_20725[(12)]);
var inst_20709 = (state_20725[(2)]);
var inst_20710 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20662,inst_20709,inst_20632,inst_20661);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20725__$1,(28),inst_20710);
} else {
if((state_val_20726 === (13))){
var inst_20641 = (state_20725[(13)]);
var inst_20665 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20641)].join('');
var inst_20666 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20667 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20668 = cljs.core.PersistentHashMap.fromArrays(inst_20666,inst_20667);
var inst_20669 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20665,inst_20668);
var inst_20670 = (function(){throw inst_20669})();
var state_20725__$1 = state_20725;
var statearr_20737_20789 = state_20725__$1;
(statearr_20737_20789[(2)] = inst_20670);

(statearr_20737_20789[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (22))){
var inst_20659 = (state_20725[(8)]);
var inst_20657 = (state_20725[(14)]);
var inst_20692 = cljs.core.PersistentHashMap.EMPTY;
var inst_20693 = cljs.core.flatten(inst_20657);
var inst_20694 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20692,inst_20659,inst_20693);
var state_20725__$1 = state_20725;
var statearr_20738_20790 = state_20725__$1;
(statearr_20738_20790[(2)] = inst_20694);

(statearr_20738_20790[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (6))){
var inst_20643 = (state_20725[(15)]);
var state_20725__$1 = state_20725;
var statearr_20739_20791 = state_20725__$1;
(statearr_20739_20791[(2)] = inst_20643);

(statearr_20739_20791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (28))){
var inst_20712 = (state_20725[(2)]);
var inst_20713 = fluree.db.util.async.throw_err(inst_20712);
var state_20725__$1 = state_20725;
var statearr_20740_20792 = state_20725__$1;
(statearr_20740_20792[(2)] = inst_20713);

(statearr_20740_20792[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (25))){
var inst_20653 = (state_20725[(16)]);
var inst_20657 = (state_20725[(14)]);
var inst_20698 = cljs.core.PersistentHashMap.EMPTY;
var inst_20699 = cljs.core.first(inst_20653);
var inst_20700 = cljs.core.first(inst_20699);
var inst_20701 = cljs.core.flatten(inst_20657);
var inst_20702 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20698,inst_20700,inst_20701);
var state_20725__$1 = state_20725;
var statearr_20741_20793 = state_20725__$1;
(statearr_20741_20793[(2)] = inst_20702);

(statearr_20741_20793[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (17))){
var inst_20641 = (state_20725[(13)]);
var inst_20678 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20641)].join('');
var inst_20679 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20680 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20681 = cljs.core.PersistentHashMap.fromArrays(inst_20679,inst_20680);
var inst_20682 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20678,inst_20681);
var inst_20683 = (function(){throw inst_20682})();
var state_20725__$1 = state_20725;
var statearr_20742_20794 = state_20725__$1;
(statearr_20742_20794[(2)] = inst_20683);

(statearr_20742_20794[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (3))){
var inst_20723 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20725__$1,inst_20723);
} else {
if((state_val_20726 === (12))){
var inst_20628 = (state_20725[(17)]);
var inst_20716 = (state_20725[(2)]);
var inst_20717 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20718 = cljs.core.keys(inst_20628);
var inst_20719 = [inst_20718,vars,inst_20716];
var inst_20720 = cljs.core.PersistentHashMap.fromArrays(inst_20717,inst_20719);
var _ = (function (){var statearr_20743 = state_20725;
(statearr_20743[(4)] = cljs.core.rest((state_20725[(4)])));

return statearr_20743;
})();
var state_20725__$1 = state_20725;
var statearr_20744_20795 = state_20725__$1;
(statearr_20744_20795[(2)] = inst_20720);

(statearr_20744_20795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (2))){
var inst_20631 = (state_20725[(7)]);
var inst_20628 = (state_20725[(17)]);
var inst_20632 = (state_20725[(11)]);
var inst_20643 = (state_20725[(15)]);
var _ = (function (){var statearr_20745 = state_20725;
(statearr_20745[(4)] = cljs.core.cons((5),(state_20725[(4)])));

return statearr_20745;
})();
var inst_20625 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20626 = cljs.core.__destructure_map(inst_20625);
var inst_20627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20626,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20628__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20626,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20626,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20630 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20631__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20629);
var inst_20632__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20629);
var inst_20634 = (function (){var map__20621 = inst_20626;
var search = inst_20627;
var rel = inst_20628__$1;
var opts = inst_20629;
var common_keys = inst_20630;
var object_fn = inst_20631__$1;
var recur_depth = inst_20632__$1;
return (function (p__20633,common_key){
var vec__20746 = p__20633;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20746,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20746,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20749 = cljs.core._EQ_;
var expr__20750 = idx_of;
if(cljs.core.truth_((pred__20749.cljs$core$IFn$_invoke$arity$2 ? pred__20749.cljs$core$IFn$_invoke$arity$2((0),expr__20750) : pred__20749.call(null,(0),expr__20750)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20749.cljs$core$IFn$_invoke$arity$2 ? pred__20749.cljs$core$IFn$_invoke$arity$2((1),expr__20750) : pred__20749.call(null,(1),expr__20750)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20749.cljs$core$IFn$_invoke$arity$2 ? pred__20749.cljs$core$IFn$_invoke$arity$2((2),expr__20750) : pred__20749.call(null,(2),expr__20750)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20750)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20636 = cljs.core.PersistentHashMap.EMPTY;
var inst_20637 = [inst_20636,inst_20627];
var inst_20638 = (new cljs.core.PersistentVector(null,2,(5),inst_20635,inst_20637,null));
var inst_20639 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20634,inst_20638,inst_20630);
var inst_20640 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20639,(0),null);
var inst_20641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20639,(1),null);
var inst_20642 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20643__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20640);
var state_20725__$1 = (function (){var statearr_20752 = state_20725;
(statearr_20752[(7)] = inst_20631__$1);

(statearr_20752[(17)] = inst_20628__$1);

(statearr_20752[(11)] = inst_20632__$1);

(statearr_20752[(15)] = inst_20643__$1);

(statearr_20752[(18)] = inst_20642);

(statearr_20752[(13)] = inst_20641);

return statearr_20752;
})();
if(cljs.core.truth_(inst_20643__$1)){
var statearr_20753_20796 = state_20725__$1;
(statearr_20753_20796[(1)] = (6));

} else {
var statearr_20754_20797 = state_20725__$1;
(statearr_20754_20797[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (23))){
var inst_20659 = (state_20725[(8)]);
var inst_20696 = cljs.core.coll_QMARK_(inst_20659);
var state_20725__$1 = state_20725;
if(inst_20696){
var statearr_20755_20798 = state_20725__$1;
(statearr_20755_20798[(1)] = (25));

} else {
var statearr_20756_20799 = state_20725__$1;
(statearr_20756_20799[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (19))){
var inst_20657 = (state_20725[(14)]);
var inst_20687 = cljs.core.PersistentHashMap.EMPTY;
var inst_20688 = fluree.db.query.analytical.tuples__GT_map(inst_20687,inst_20657);
var state_20725__$1 = state_20725;
var statearr_20757_20800 = state_20725__$1;
(statearr_20757_20800[(2)] = inst_20688);

(statearr_20757_20800[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (11))){
var inst_20657 = (state_20725[(14)]);
var state_20725__$1 = state_20725;
var statearr_20759_20801 = state_20725__$1;
(statearr_20759_20801[(2)] = inst_20657);

(statearr_20759_20801[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (9))){
var inst_20653 = (state_20725[(16)]);
var inst_20628 = (state_20725[(17)]);
var inst_20632 = (state_20725[(11)]);
var inst_20652 = (state_20725[(2)]);
var inst_20653__$1 = fluree.db.util.async.throw_err(inst_20652);
var inst_20654 = cljs.core.count(inst_20653__$1);
var inst_20655 = fluree.db.query.analytical.add_fuel(inst_20654,fuel,max_fuel);
var inst_20656 = cljs.core.vals(inst_20628);
var inst_20657 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_20656,inst_20653__$1);
var state_20725__$1 = (function (){var statearr_20760 = state_20725;
(statearr_20760[(16)] = inst_20653__$1);

(statearr_20760[(14)] = inst_20657);

(statearr_20760[(19)] = inst_20655);

return statearr_20760;
})();
if(cljs.core.truth_(inst_20632)){
var statearr_20761_20802 = state_20725__$1;
(statearr_20761_20802[(1)] = (10));

} else {
var statearr_20762_20803 = state_20725__$1;
(statearr_20762_20803[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (5))){
var _ = (function (){var statearr_20763 = state_20725;
(statearr_20763[(4)] = cljs.core.rest((state_20725[(4)])));

return statearr_20763;
})();
var state_20725__$1 = state_20725;
var ex20758 = (state_20725__$1[(2)]);
var statearr_20764_20804 = state_20725__$1;
(statearr_20764_20804[(5)] = ex20758);


if((ex20758 instanceof Error)){
var statearr_20765_20805 = state_20725__$1;
(statearr_20765_20805[(1)] = (4));

(statearr_20765_20805[(5)] = null);

} else {
throw ex20758;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (14))){
var state_20725__$1 = state_20725;
var statearr_20766_20806 = state_20725__$1;
(statearr_20766_20806[(2)] = null);

(statearr_20766_20806[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (26))){
var state_20725__$1 = state_20725;
var statearr_20767_20807 = state_20725__$1;
(statearr_20767_20807[(2)] = null);

(statearr_20767_20807[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (16))){
var state_20725__$1 = state_20725;
var statearr_20768_20808 = state_20725__$1;
(statearr_20768_20808[(2)] = null);

(statearr_20768_20808[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (10))){
var inst_20662 = (state_20725[(10)]);
var inst_20641 = (state_20725[(13)]);
var inst_20659 = cljs.core.first(inst_20641);
var inst_20660 = cljs.core.first(clause);
var inst_20661 = fluree.db.query.analytical.variable_QMARK_(inst_20660);
var inst_20662__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20641,(1));
var inst_20663 = fluree.db.query.analytical.variable_QMARK_(inst_20662__$1);
var state_20725__$1 = (function (){var statearr_20769 = state_20725;
(statearr_20769[(10)] = inst_20662__$1);

(statearr_20769[(8)] = inst_20659);

(statearr_20769[(12)] = inst_20661);

return statearr_20769;
})();
if(cljs.core.truth_(inst_20663)){
var statearr_20770_20809 = state_20725__$1;
(statearr_20770_20809[(1)] = (13));

} else {
var statearr_20771_20810 = state_20725__$1;
(statearr_20771_20810[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (18))){
var inst_20661 = (state_20725[(12)]);
var inst_20685 = (state_20725[(2)]);
var state_20725__$1 = (function (){var statearr_20772 = state_20725;
(statearr_20772[(20)] = inst_20685);

return statearr_20772;
})();
if(cljs.core.truth_(inst_20661)){
var statearr_20773_20811 = state_20725__$1;
(statearr_20773_20811[(1)] = (19));

} else {
var statearr_20774_20812 = state_20725__$1;
(statearr_20774_20812[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (8))){
var inst_20642 = (state_20725[(18)]);
var inst_20641 = (state_20725[(13)]);
var inst_20647 = (state_20725[(2)]);
var inst_20648 = [inst_20647];
var inst_20649 = cljs.core.PersistentHashMap.fromArrays(inst_20642,inst_20648);
var inst_20650 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20641,inst_20649);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20725__$1,(9),inst_20650);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_20775 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20775[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_20775[(1)] = (1));

return statearr_20775;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_20725){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20725);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20776){var ex__2687__auto__ = e20776;
var statearr_20777_20813 = state_20725;
(statearr_20777_20813[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20725[(4)]))){
var statearr_20778_20814 = state_20725;
(statearr_20778_20814[(1)] = cljs.core.first((state_20725[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20815 = state_20725;
state_20725 = G__20815;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__ = function(state_20725){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_20725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20779 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20779[(6)] = c__2706__auto__);

return statearr_20779;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20816,res,clause){
var map__20817 = p__20816;
var map__20817__$1 = cljs.core.__destructure_map(map__20817);
var db = map__20817__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20817__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20817__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20817__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_20926){
var state_val_20927 = (state_20926[(1)]);
if((state_val_20927 === (7))){
var inst_20826 = (state_20926[(7)]);
var state_20926__$1 = state_20926;
var statearr_20928_20969 = state_20926__$1;
(statearr_20928_20969[(2)] = inst_20826);

(statearr_20928_20969[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (20))){
var state_20926__$1 = state_20926;
var statearr_20929_20970 = state_20926__$1;
(statearr_20929_20970[(2)] = null);

(statearr_20929_20970[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (1))){
var state_20926__$1 = state_20926;
var statearr_20930_20971 = state_20926__$1;
(statearr_20930_20971[(2)] = null);

(statearr_20930_20971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (24))){
var inst_20828 = (state_20926[(8)]);
var inst_20899 = (state_20926[(2)]);
var inst_20900 = fluree.db.flake.sid__GT_cid(inst_20899);
var inst_20901 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20900);
var inst_20902 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20903 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20904 = [inst_20828];
var inst_20905 = (new cljs.core.PersistentVector(null,1,(5),inst_20903,inst_20904,null));
var inst_20906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20908 = [inst_20901];
var inst_20909 = (new cljs.core.PersistentVector(null,1,(5),inst_20907,inst_20908,null));
var inst_20910 = [inst_20909];
var inst_20911 = (new cljs.core.PersistentVector(null,1,(5),inst_20906,inst_20910,null));
var inst_20912 = cljs.core.PersistentHashMap.EMPTY;
var inst_20913 = [inst_20905,inst_20911,inst_20912];
var inst_20914 = cljs.core.PersistentHashMap.fromArrays(inst_20902,inst_20913);
var state_20926__$1 = state_20926;
var statearr_20931_20972 = state_20926__$1;
(statearr_20931_20972[(2)] = inst_20914);

(statearr_20931_20972[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (4))){
var inst_20819 = (state_20926[(2)]);
var state_20926__$1 = state_20926;
var statearr_20932_20973 = state_20926__$1;
(statearr_20932_20973[(2)] = inst_20819);

(statearr_20932_20973[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (15))){
var inst_20828 = (state_20926[(8)]);
var inst_20826 = (state_20926[(7)]);
var inst_20847 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20848 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20850 = [inst_20826];
var inst_20851 = (new cljs.core.PersistentVector(null,1,(5),inst_20849,inst_20850,null));
var inst_20852 = (function (){var subject_var = inst_20826;
var object_var = inst_20828;
var min_sid = inst_20847;
var max_sid = (0);
return (function (p1__20818_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20818_SHARP_);
});
})();
var inst_20853 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20847,(0));
var inst_20854 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20852,inst_20853);
var inst_20855 = cljs.core.PersistentHashMap.EMPTY;
var inst_20856 = [inst_20851,inst_20854,inst_20855];
var inst_20857 = cljs.core.PersistentHashMap.fromArrays(inst_20848,inst_20856);
var state_20926__$1 = state_20926;
var statearr_20933_20974 = state_20926__$1;
(statearr_20933_20974[(2)] = inst_20857);

(statearr_20933_20974[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (21))){
var inst_20917 = (state_20926[(2)]);
var state_20926__$1 = state_20926;
var statearr_20934_20975 = state_20926__$1;
(statearr_20934_20975[(2)] = inst_20917);

(statearr_20934_20975[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (13))){
var inst_20828 = (state_20926[(8)]);
var state_20926__$1 = state_20926;
if(cljs.core.truth_(inst_20828)){
var statearr_20935_20976 = state_20926__$1;
(statearr_20935_20976[(1)] = (19));

} else {
var statearr_20936_20977 = state_20926__$1;
(statearr_20936_20977[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (22))){
var inst_20890 = (state_20926[(9)]);
var state_20926__$1 = state_20926;
var statearr_20937_20978 = state_20926__$1;
(statearr_20937_20978[(2)] = inst_20890);

(statearr_20937_20978[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (6))){
var inst_20828 = (state_20926[(8)]);
var state_20926__$1 = state_20926;
var statearr_20938_20979 = state_20926__$1;
(statearr_20938_20979[(2)] = inst_20828);

(statearr_20938_20979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (25))){
var inst_20896 = (state_20926[(2)]);
var inst_20897 = fluree.db.util.async.throw_err(inst_20896);
var state_20926__$1 = state_20926;
var statearr_20939_20980 = state_20926__$1;
(statearr_20939_20980[(2)] = inst_20897);

(statearr_20939_20980[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (17))){
var inst_20887 = (state_20926[(2)]);
var state_20926__$1 = state_20926;
var statearr_20940_20981 = state_20926__$1;
(statearr_20940_20981[(2)] = inst_20887);

(statearr_20940_20981[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (3))){
var inst_20924 = (state_20926[(2)]);
var state_20926__$1 = state_20926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20926__$1,inst_20924);
} else {
if((state_val_20927 === (12))){
var inst_20841 = ["_tx",null,"_block",null];
var inst_20842 = (new cljs.core.PersistentArrayMap(null,2,inst_20841,null));
var inst_20843 = (new cljs.core.PersistentHashSet(null,inst_20842,null));
var inst_20844 = cljs.core.last(clause);
var inst_20845 = (inst_20843.cljs$core$IFn$_invoke$arity$1 ? inst_20843.cljs$core$IFn$_invoke$arity$1(inst_20844) : inst_20843.call(null,inst_20844));
var state_20926__$1 = state_20926;
if(cljs.core.truth_(inst_20845)){
var statearr_20941_20982 = state_20926__$1;
(statearr_20941_20982[(1)] = (15));

} else {
var statearr_20942_20983 = state_20926__$1;
(statearr_20942_20983[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (2))){
var inst_20826 = (state_20926[(7)]);
var _ = (function (){var statearr_20943 = state_20926;
(statearr_20943[(4)] = cljs.core.cons((5),(state_20926[(4)])));

return statearr_20943;
})();
var inst_20825 = cljs.core.first(clause);
var inst_20826__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20825);
var inst_20827 = cljs.core.last(clause);
var inst_20828 = fluree.db.query.analytical.variable_QMARK_(inst_20827);
var state_20926__$1 = (function (){var statearr_20944 = state_20926;
(statearr_20944[(8)] = inst_20828);

(statearr_20944[(7)] = inst_20826__$1);

return statearr_20944;
})();
if(cljs.core.truth_(inst_20826__$1)){
var statearr_20945_20984 = state_20926__$1;
(statearr_20945_20984[(1)] = (6));

} else {
var statearr_20946_20985 = state_20926__$1;
(statearr_20946_20985[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (23))){
var inst_20890 = (state_20926[(9)]);
var inst_20894 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20890);
var state_20926__$1 = state_20926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20926__$1,(25),inst_20894);
} else {
if((state_val_20927 === (19))){
var inst_20890 = (state_20926[(9)]);
var inst_20890__$1 = cljs.core.first(clause);
var inst_20891 = typeof inst_20890__$1 === 'number';
var state_20926__$1 = (function (){var statearr_20947 = state_20926;
(statearr_20947[(9)] = inst_20890__$1);

return statearr_20947;
})();
if(cljs.core.truth_(inst_20891)){
var statearr_20948_20986 = state_20926__$1;
(statearr_20948_20986[(1)] = (22));

} else {
var statearr_20949_20987 = state_20926__$1;
(statearr_20949_20987[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (11))){
var inst_20921 = (state_20926[(2)]);
var _ = (function (){var statearr_20951 = state_20926;
(statearr_20951[(4)] = cljs.core.rest((state_20926[(4)])));

return statearr_20951;
})();
var state_20926__$1 = state_20926;
var statearr_20952_20988 = state_20926__$1;
(statearr_20952_20988[(2)] = inst_20921);

(statearr_20952_20988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (9))){
var inst_20834 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20835 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20836 = cljs.core.PersistentHashMap.fromArrays(inst_20834,inst_20835);
var inst_20837 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20836);
var inst_20838 = (function(){throw inst_20837})();
var state_20926__$1 = state_20926;
var statearr_20953_20989 = state_20926__$1;
(statearr_20953_20989[(2)] = inst_20838);

(statearr_20953_20989[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (5))){
var _ = (function (){var statearr_20954 = state_20926;
(statearr_20954[(4)] = cljs.core.rest((state_20926[(4)])));

return statearr_20954;
})();
var state_20926__$1 = state_20926;
var ex20950 = (state_20926__$1[(2)]);
var statearr_20955_20990 = state_20926__$1;
(statearr_20955_20990[(5)] = ex20950);


if((ex20950 instanceof Error)){
var statearr_20956_20991 = state_20926__$1;
(statearr_20956_20991[(1)] = (4));

(statearr_20956_20991[(5)] = null);

} else {
throw ex20950;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (14))){
var inst_20919 = (state_20926[(2)]);
var state_20926__$1 = state_20926;
var statearr_20957_20992 = state_20926__$1;
(statearr_20957_20992[(2)] = inst_20919);

(statearr_20957_20992[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (16))){
var inst_20862 = (state_20926[(10)]);
var inst_20860 = (state_20926[(11)]);
var inst_20863 = (state_20926[(12)]);
var inst_20859 = cljs.core.last(clause);
var inst_20860__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20859);
var inst_20861 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20862__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20861,inst_20860__$1);
var inst_20863__$1 = fluree.db.flake.min_subject_id(inst_20860__$1);
var inst_20864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20865 = [inst_20862__$1];
var inst_20866 = (new cljs.core.PersistentVector(null,1,(5),inst_20864,inst_20865,null));
var inst_20867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20868 = [inst_20863__$1];
var inst_20869 = (new cljs.core.PersistentVector(null,1,(5),inst_20867,inst_20868,null));
var inst_20870 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20866,cljs.core._LT__EQ_,inst_20869);
var state_20926__$1 = (function (){var statearr_20958 = state_20926;
(statearr_20958[(10)] = inst_20862__$1);

(statearr_20958[(11)] = inst_20860__$1);

(statearr_20958[(12)] = inst_20863__$1);

return statearr_20958;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20926__$1,(18),inst_20870);
} else {
if((state_val_20927 === (10))){
var inst_20826 = (state_20926[(7)]);
var state_20926__$1 = state_20926;
if(cljs.core.truth_(inst_20826)){
var statearr_20959_20993 = state_20926__$1;
(statearr_20959_20993[(1)] = (12));

} else {
var statearr_20960_20994 = state_20926__$1;
(statearr_20960_20994[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (18))){
var inst_20862 = (state_20926[(10)]);
var inst_20828 = (state_20926[(8)]);
var inst_20860 = (state_20926[(11)]);
var inst_20826 = (state_20926[(7)]);
var inst_20863 = (state_20926[(12)]);
var inst_20872 = (state_20926[(2)]);
var inst_20873 = fluree.db.util.async.throw_err(inst_20872);
var inst_20874 = (function (){var subject_var = inst_20826;
var object_var = inst_20828;
var partition = inst_20860;
var max_sid = inst_20862;
var min_sid = inst_20863;
var flakes = inst_20873;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20875 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20874);
var inst_20876 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20877 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20875,inst_20876);
var inst_20878 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20879 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20880 = [inst_20826];
var inst_20881 = (new cljs.core.PersistentVector(null,1,(5),inst_20879,inst_20880,null));
var inst_20882 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20877,inst_20873);
var inst_20883 = cljs.core.PersistentHashMap.EMPTY;
var inst_20884 = [inst_20881,inst_20882,inst_20883];
var inst_20885 = cljs.core.PersistentHashMap.fromArrays(inst_20878,inst_20884);
var state_20926__$1 = state_20926;
var statearr_20961_20995 = state_20926__$1;
(statearr_20961_20995[(2)] = inst_20885);

(statearr_20961_20995[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20927 === (8))){
var inst_20832 = (state_20926[(2)]);
var state_20926__$1 = state_20926;
if(cljs.core.truth_(inst_20832)){
var statearr_20962_20996 = state_20926__$1;
(statearr_20962_20996[(1)] = (9));

} else {
var statearr_20963_20997 = state_20926__$1;
(statearr_20963_20997[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_20964 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20964[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__);

(statearr_20964[(1)] = (1));

return statearr_20964;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1 = (function (state_20926){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_20926);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e20965){var ex__2687__auto__ = e20965;
var statearr_20966_20998 = state_20926;
(statearr_20966_20998[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_20926[(4)]))){
var statearr_20967_20999 = state_20926;
(statearr_20967_20999[(1)] = cljs.core.first((state_20926[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21000 = state_20926;
state_20926 = G__21000;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__ = function(state_20926){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1.call(this,state_20926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_20968 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_20968[(6)] = c__2706__auto__);

return statearr_20968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21007 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21007;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21008(s__21009){
return (new cljs.core.LazySeq(null,(function (){
var s__21009__$1 = s__21009;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__21009__$1);
if(temp__5804__auto__){
var s__21009__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21009__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__21009__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__21011 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__21010 = (0);
while(true){
if((i__21010 < size__5522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__21010);
var delta = (x - mean);
cljs.core.chunk_append(b__21011,(delta * delta));

var G__21013 = (i__21010 + (1));
i__21010 = G__21013;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21011),fluree$db$query$analytical$variance_$_iter__21008(cljs.core.chunk_rest(s__21009__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21011),null);
}
} else {
var x = cljs.core.first(s__21009__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21008(cljs.core.rest(s__21009__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21012 = variance(coll);
return Math.sqrt(G__21012);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21014 = null;
var G__21014__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21014__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21014 = function(n,coll){
switch(arguments.length){
case 1:
return G__21014__1.call(this,n);
case 2:
return G__21014__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21014.cljs$core$IFn$_invoke$arity$1 = G__21014__1;
G__21014.cljs$core$IFn$_invoke$arity$2 = G__21014__2;
return G__21014;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21015 = null;
var G__21015__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21015__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21015 = function(n,coll){
switch(arguments.length){
case 1:
return G__21015__1.call(this,n);
case 2:
return G__21015__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21015.cljs$core$IFn$_invoke$arity$1 = G__21015__1;
G__21015.cljs$core$IFn$_invoke$arity$2 = G__21015__2;
return G__21015;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21016 = null;
var G__21016__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21016__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21016 = function(n,coll){
switch(arguments.length){
case 1:
return G__21016__1.call(this,n);
case 2:
return G__21016__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21016.cljs$core$IFn$_invoke$arity$1 = G__21016__1;
G__21016.cljs$core$IFn$_invoke$arity$2 = G__21016__2;
return G__21016;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count(parsed_code);
var vec__21017 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),cljs.core.second(parsed_code),cljs.core.last(parsed_code)], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(parsed_code)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),null,cljs.core.last(parsed_code)], null)):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21017,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21017,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21017,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21020 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21023 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21023) : agg_fn.call(null,G__21023));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21020,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21020,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0)),")"].join('');
if(cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(code_str);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_(code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__21024 = aggregate_fn_map;
var map__21024__$1 = cljs.core.__destructure_map(map__21024);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21024__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21024__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21024__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(agg_params) : function$.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21026 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21026,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21026,(1),null);
var map__21029 = res__$1;
var map__21029__$1 = cljs.core.__destructure_map(map__21029);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21029__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21029__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21025_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21025_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21030_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21030_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21031_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21031_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21032_SHARP_,p2__21033_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21032_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21033_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21034_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21034_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21037,row,b_tuple){
var vec__21038 = p__21037;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21038,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21038,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21035_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21035_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21036_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21036_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21041_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21041_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21042_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21042_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21047 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21049 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21048 = (function (p1__21043_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21043_SHARP_);
});
return fexpr__21048(G__21049);
})()),cljs.core.set(b_idxs));
var fexpr__21046 = (function (p1__21044_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21044_SHARP_);
});
return fexpr__21046(G__21047);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21045_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21045_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21050_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21050_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21051_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21051_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21056 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21058 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21057 = (function (p1__21052_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21052_SHARP_);
});
return fexpr__21057(G__21058);
})()),cljs.core.set(b_idxs));
var fexpr__21055 = (function (p1__21053_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21053_SHARP_);
});
return fexpr__21055(G__21056);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21054_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21054_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21060 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21060,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21060,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21059_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21059_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var vec__21065 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21065,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21065,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21063_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21063_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21064_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21064_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21068,filters,optional_QMARK_){
var map__21069 = p__21068;
var map__21069__$1 = cljs.core.__destructure_map(map__21069);
var tuple_map = map__21069__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21069__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21069__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21069__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21070 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21070,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21070,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21073 = res;
var map__21073__$1 = cljs.core.__destructure_map(map__21073);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21073__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21073__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21129){
var state_val_21130 = (state_21129[(1)]);
if((state_val_21130 === (7))){
var inst_21103 = (state_21129[(7)]);
var inst_21101 = (state_21129[(2)]);
var inst_21102 = fluree.db.util.async.throw_err(inst_21101);
var inst_21103__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21102,(0),null);
var inst_21104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21102,(1),null);
var inst_21105 = (inst_21103__$1 == null);
var state_21129__$1 = (function (){var statearr_21131 = state_21129;
(statearr_21131[(7)] = inst_21103__$1);

(statearr_21131[(8)] = inst_21104);

return statearr_21131;
})();
if(cljs.core.truth_(inst_21105)){
var statearr_21132_21161 = state_21129__$1;
(statearr_21132_21161[(1)] = (8));

} else {
var statearr_21133_21162 = state_21129__$1;
(statearr_21133_21162[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (1))){
var inst_21081 = optional_clauses;
var inst_21082 = cljs.core.seq(inst_21081);
var inst_21083 = cljs.core.first(inst_21082);
var inst_21084 = cljs.core.next(inst_21082);
var inst_21085 = where_tuples;
var inst_21086 = inst_21081;
var inst_21087 = inst_21085;
var state_21129__$1 = (function (){var statearr_21134 = state_21129;
(statearr_21134[(9)] = inst_21084);

(statearr_21134[(10)] = inst_21086);

(statearr_21134[(11)] = inst_21083);

(statearr_21134[(12)] = inst_21087);

return statearr_21134;
})();
var statearr_21135_21163 = state_21129__$1;
(statearr_21135_21163[(2)] = null);

(statearr_21135_21163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (4))){
var inst_21094 = (state_21129[(13)]);
var inst_21093 = (state_21129[(14)]);
var inst_21087 = (state_21129[(12)]);
var inst_21099 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21087,inst_21093,inst_21094,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21087,inst_21093,inst_21094,true,fuel,max_fuel,opts));
var state_21129__$1 = state_21129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21129__$1,(7),inst_21099);
} else {
if((state_val_21130 === (15))){
var state_21129__$1 = state_21129;
var statearr_21136_21164 = state_21129__$1;
(statearr_21136_21164[(2)] = null);

(statearr_21136_21164[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (13))){
var inst_21120 = (state_21129[(2)]);
var state_21129__$1 = state_21129;
var statearr_21137_21165 = state_21129__$1;
(statearr_21137_21165[(2)] = inst_21120);

(statearr_21137_21165[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (6))){
var inst_21125 = (state_21129[(2)]);
var state_21129__$1 = state_21129;
var statearr_21138_21166 = state_21129__$1;
(statearr_21138_21166[(2)] = inst_21125);

(statearr_21138_21166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (3))){
var inst_21127 = (state_21129[(2)]);
var state_21129__$1 = state_21129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21129__$1,inst_21127);
} else {
if((state_val_21130 === (12))){
var state_21129__$1 = state_21129;
var statearr_21139_21167 = state_21129__$1;
(statearr_21139_21167[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (2))){
var inst_21093 = (state_21129[(14)]);
var inst_21086 = (state_21129[(10)]);
var inst_21092 = cljs.core.seq(inst_21086);
var inst_21093__$1 = cljs.core.first(inst_21092);
var inst_21094 = cljs.core.next(inst_21092);
var state_21129__$1 = (function (){var statearr_21141 = state_21129;
(statearr_21141[(13)] = inst_21094);

(statearr_21141[(14)] = inst_21093__$1);

return statearr_21141;
})();
if(cljs.core.truth_(inst_21093__$1)){
var statearr_21142_21168 = state_21129__$1;
(statearr_21142_21168[(1)] = (4));

} else {
var statearr_21143_21169 = state_21129__$1;
(statearr_21143_21169[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (11))){
var inst_21103 = (state_21129[(7)]);
var inst_21104 = (state_21129[(8)]);
var inst_21086 = inst_21104;
var inst_21087 = inst_21103;
var state_21129__$1 = (function (){var statearr_21144 = state_21129;
(statearr_21144[(10)] = inst_21086);

(statearr_21144[(12)] = inst_21087);

return statearr_21144;
})();
var statearr_21145_21170 = state_21129__$1;
(statearr_21145_21170[(2)] = null);

(statearr_21145_21170[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (9))){
var inst_21093 = (state_21129[(14)]);
var inst_21109 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21093);
var state_21129__$1 = state_21129;
if(cljs.core.truth_(inst_21109)){
var statearr_21146_21171 = state_21129__$1;
(statearr_21146_21171[(1)] = (11));

} else {
var statearr_21147_21172 = state_21129__$1;
(statearr_21147_21172[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (5))){
var inst_21087 = (state_21129[(12)]);
var state_21129__$1 = state_21129;
var statearr_21148_21173 = state_21129__$1;
(statearr_21148_21173[(2)] = inst_21087);

(statearr_21148_21173[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (14))){
var inst_21103 = (state_21129[(7)]);
var inst_21104 = (state_21129[(8)]);
var inst_21087 = (state_21129[(12)]);
var inst_21114 = fluree.db.query.analytical.left_outer_join(inst_21087,inst_21103);
var inst_21086 = inst_21104;
var inst_21087__$1 = inst_21114;
var state_21129__$1 = (function (){var statearr_21149 = state_21129;
(statearr_21149[(10)] = inst_21086);

(statearr_21149[(12)] = inst_21087__$1);

return statearr_21149;
})();
var statearr_21150_21174 = state_21129__$1;
(statearr_21150_21174[(2)] = null);

(statearr_21150_21174[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (16))){
var inst_21118 = (state_21129[(2)]);
var state_21129__$1 = state_21129;
var statearr_21152_21175 = state_21129__$1;
(statearr_21152_21175[(2)] = inst_21118);

(statearr_21152_21175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (10))){
var inst_21122 = (state_21129[(2)]);
var state_21129__$1 = state_21129;
var statearr_21153_21176 = state_21129__$1;
(statearr_21153_21176[(2)] = inst_21122);

(statearr_21153_21176[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21130 === (8))){
var inst_21104 = (state_21129[(8)]);
var inst_21087 = (state_21129[(12)]);
var tmp21151 = inst_21087;
var inst_21086 = inst_21104;
var inst_21087__$1 = tmp21151;
var state_21129__$1 = (function (){var statearr_21154 = state_21129;
(statearr_21154[(10)] = inst_21086);

(statearr_21154[(12)] = inst_21087__$1);

return statearr_21154;
})();
var statearr_21155_21177 = state_21129__$1;
(statearr_21155_21177[(2)] = null);

(statearr_21155_21177[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0 = (function (){
var statearr_21156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21156[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__);

(statearr_21156[(1)] = (1));

return statearr_21156;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1 = (function (state_21129){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21129);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21157){var ex__2687__auto__ = e21157;
var statearr_21158_21178 = state_21129;
(statearr_21158_21178[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21129[(4)]))){
var statearr_21159_21179 = state_21129;
(statearr_21159_21179[(1)] = cljs.core.first((state_21129[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21180 = state_21129;
state_21129 = G__21180;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__ = function(state_21129){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1.call(this,state_21129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21160 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21160[(6)] = c__2706__auto__);

return statearr_21160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21182){
var vec__21183 = p__21182;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21183,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21183,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21181_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21181_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21187,p__21188,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21189 = p__21187;
var map__21189__$1 = cljs.core.__destructure_map(map__21189);
var q_map = map__21189__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21189__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21190 = p__21188;
var map__21190__$1 = cljs.core.__destructure_map(map__21190);
var res = map__21190__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21190__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21427){
var state_val_21428 = (state_21427[(1)]);
if((state_val_21428 === (65))){
var inst_21376 = (state_21427[(7)]);
var inst_21377 = (state_21427[(8)]);
var inst_21388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21389 = fluree.db.query.analytical.full_text__GT_tuples(inst_21376,res,inst_21377);
var inst_21390 = [inst_21389,r];
var inst_21391 = (new cljs.core.PersistentVector(null,2,(5),inst_21388,inst_21390,null));
var state_21427__$1 = state_21427;
var statearr_21429_21542 = state_21427__$1;
(statearr_21429_21542[(2)] = inst_21391);

(statearr_21429_21542[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (70))){
var inst_21403 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21430_21543 = state_21427__$1;
(statearr_21430_21543[(2)] = inst_21403);

(statearr_21430_21543[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (62))){
var inst_21377 = (state_21427[(8)]);
var inst_21385 = cljs.core.second(inst_21377);
var inst_21386 = clojure.string.starts_with_QMARK_(inst_21385,"fullText:");
var state_21427__$1 = state_21427;
if(inst_21386){
var statearr_21431_21544 = state_21427__$1;
(statearr_21431_21544[(1)] = (65));

} else {
var statearr_21432_21545 = state_21427__$1;
(statearr_21432_21545[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (7))){
var inst_21296 = (state_21427[(9)]);
var inst_21295 = cljs.core.count(clause);
var inst_21296__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21295);
var state_21427__$1 = (function (){var statearr_21433 = state_21427;
(statearr_21433[(9)] = inst_21296__$1);

return statearr_21433;
})();
if(inst_21296__$1){
var statearr_21434_21546 = state_21427__$1;
(statearr_21434_21546[(1)] = (31));

} else {
var statearr_21435_21547 = state_21427__$1;
(statearr_21435_21547[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (59))){
var inst_21410 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21436_21548 = state_21427__$1;
(statearr_21436_21548[(2)] = inst_21410);

(statearr_21436_21548[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (20))){
var inst_21259 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21437_21549 = state_21427__$1;
(statearr_21437_21549[(2)] = inst_21259);

(statearr_21437_21549[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (58))){
var state_21427__$1 = state_21427;
var statearr_21438_21550 = state_21427__$1;
(statearr_21438_21550[(2)] = null);

(statearr_21438_21550[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (60))){
var inst_21376 = (state_21427[(7)]);
var inst_21374 = (state_21427[(2)]);
var inst_21375 = fluree.db.util.async.throw_err(inst_21374);
var inst_21376__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21375,(0),null);
var inst_21377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21375,(1),null);
var inst_21378 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21376__$1);
var state_21427__$1 = (function (){var statearr_21439 = state_21427;
(statearr_21439[(7)] = inst_21376__$1);

(statearr_21439[(8)] = inst_21377);

return statearr_21439;
})();
if(inst_21378){
var statearr_21440_21551 = state_21427__$1;
(statearr_21440_21551[(1)] = (61));

} else {
var statearr_21441_21552 = state_21427__$1;
(statearr_21441_21552[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (27))){
var inst_21289 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21442_21553 = state_21427__$1;
(statearr_21442_21553[(2)] = inst_21289);

(statearr_21442_21553[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (1))){
var state_21427__$1 = state_21427;
var statearr_21443_21554 = state_21427__$1;
(statearr_21443_21554[(2)] = null);

(statearr_21443_21554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (69))){
var state_21427__$1 = state_21427;
var statearr_21444_21555 = state_21427__$1;
(statearr_21444_21555[(2)] = null);

(statearr_21444_21555[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (24))){
var inst_21253 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21445_21556 = state_21427__$1;
(statearr_21445_21556[(2)] = inst_21253);

(statearr_21445_21556[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (55))){
var inst_21359 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21360 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21361 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21362 = cljs.core.PersistentHashMap.fromArrays(inst_21360,inst_21361);
var inst_21363 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21359,inst_21362);
var inst_21364 = (function(){throw inst_21363})();
var state_21427__$1 = state_21427;
var statearr_21446_21557 = state_21427__$1;
(statearr_21446_21557[(2)] = inst_21364);

(statearr_21446_21557[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (39))){
var inst_21316 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
if(cljs.core.truth_(inst_21316)){
var statearr_21447_21558 = state_21427__$1;
(statearr_21447_21558[(1)] = (40));

} else {
var statearr_21448_21559 = state_21427__$1;
(statearr_21448_21559[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (46))){
var inst_21416 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21449_21560 = state_21427__$1;
(statearr_21449_21560[(2)] = inst_21416);

(statearr_21449_21560[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (4))){
var inst_21191 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21450_21561 = state_21427__$1;
(statearr_21450_21561[(2)] = inst_21191);

(statearr_21450_21561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (54))){
var inst_21352 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21353 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21354 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21355 = cljs.core.PersistentHashMap.fromArrays(inst_21353,inst_21354);
var inst_21356 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21352,inst_21355);
var inst_21357 = (function(){throw inst_21356})();
var state_21427__$1 = state_21427;
var statearr_21451_21562 = state_21427__$1;
(statearr_21451_21562[(2)] = inst_21357);

(statearr_21451_21562[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (15))){
var inst_21291 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21452_21563 = state_21427__$1;
(statearr_21452_21563[(2)] = inst_21291);

(statearr_21452_21563[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (48))){
var inst_21340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21341 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21342 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21341);
var inst_21343 = [inst_21342,r];
var inst_21344 = (new cljs.core.PersistentVector(null,2,(5),inst_21340,inst_21343,null));
var state_21427__$1 = state_21427;
var statearr_21453_21564 = state_21427__$1;
(statearr_21453_21564[(2)] = inst_21344);

(statearr_21453_21564[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (50))){
var inst_21414 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21454_21565 = state_21427__$1;
(statearr_21454_21565[(2)] = inst_21414);

(statearr_21454_21565[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (21))){
var inst_21237 = (state_21427[(10)]);
var inst_21225 = (state_21427[(11)]);
var inst_21229 = (state_21427[(12)]);
var inst_21236 = (state_21427[(13)]);
var inst_21227 = (state_21427[(14)]);
var inst_21228 = (state_21427[(15)]);
var inst_21200 = (state_21427[(16)]);
var inst_21204 = (state_21427[(17)]);
var inst_21230 = (state_21427[(18)]);
var inst_21241 = (state_21427[(2)]);
var inst_21242 = fluree.db.util.async.throw_err(inst_21241);
var inst_21243 = (function (){var new_res = inst_21242;
var rest = inst_21237;
var first__21224 = inst_21227;
var tuples = inst_21230;
var G__21221 = inst_21229;
var expr__21202 = inst_21200;
var vec__21232 = inst_21229;
var seq__21233 = inst_21237;
var pred__21201 = inst_21204;
var vec__21222 = inst_21225;
var segment_type = inst_21200;
var seq__21223 = inst_21228;
var clause_group = inst_21236;
var first__21234 = inst_21236;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21244 = cljs.core.keys(vars);
var inst_21245 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21243,inst_21242,inst_21244);
var inst_21246 = fluree.db.query.analytical.res_absorb_vars(inst_21245);
var state_21427__$1 = (function (){var statearr_21455 = state_21427;
(statearr_21455[(19)] = inst_21246);

return statearr_21455;
})();
if(cljs.core.truth_(inst_21230)){
var statearr_21456_21566 = state_21427__$1;
(statearr_21456_21566[(1)] = (22));

} else {
var statearr_21457_21567 = state_21427__$1;
(statearr_21457_21567[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (31))){
var inst_21298 = cljs.core.second(clause);
var inst_21299 = clojure.string.starts_with_QMARK_(inst_21298,"fullText:");
var state_21427__$1 = state_21427;
var statearr_21458_21568 = state_21427__$1;
(statearr_21458_21568[(2)] = inst_21299);

(statearr_21458_21568[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (32))){
var inst_21296 = (state_21427[(9)]);
var state_21427__$1 = state_21427;
var statearr_21459_21569 = state_21427__$1;
(statearr_21459_21569[(2)] = inst_21296);

(statearr_21459_21569[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (40))){
var inst_21318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21319 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21427__$1 = (function (){var statearr_21460 = state_21427;
(statearr_21460[(20)] = inst_21318);

return statearr_21460;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(43),inst_21319);
} else {
if((state_val_21428 === (56))){
var inst_21366 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21461_21570 = state_21427__$1;
(statearr_21461_21570[(2)] = inst_21366);

(statearr_21461_21570[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (33))){
var inst_21302 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
if(cljs.core.truth_(inst_21302)){
var statearr_21462_21571 = state_21427__$1;
(statearr_21462_21571[(1)] = (34));

} else {
var statearr_21463_21572 = state_21427__$1;
(statearr_21463_21572[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (13))){
var inst_21225 = (state_21427[(11)]);
var inst_21225__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21226 = cljs.core.seq(inst_21225__$1);
var inst_21227 = cljs.core.first(inst_21226);
var inst_21228 = cljs.core.next(inst_21226);
var inst_21229 = inst_21225__$1;
var inst_21230 = null;
var state_21427__$1 = (function (){var statearr_21464 = state_21427;
(statearr_21464[(11)] = inst_21225__$1);

(statearr_21464[(12)] = inst_21229);

(statearr_21464[(14)] = inst_21227);

(statearr_21464[(15)] = inst_21228);

(statearr_21464[(18)] = inst_21230);

return statearr_21464;
})();
var statearr_21465_21573 = state_21427__$1;
(statearr_21465_21573[(2)] = null);

(statearr_21465_21573[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (22))){
var inst_21237 = (state_21427[(10)]);
var inst_21246 = (state_21427[(19)]);
var inst_21230 = (state_21427[(18)]);
var inst_21248 = fluree.db.query.union.results(inst_21230,inst_21246);
var inst_21229 = inst_21237;
var inst_21230__$1 = inst_21248;
var state_21427__$1 = (function (){var statearr_21466 = state_21427;
(statearr_21466[(12)] = inst_21229);

(statearr_21466[(18)] = inst_21230__$1);

return statearr_21466;
})();
var statearr_21467_21574 = state_21427__$1;
(statearr_21467_21574[(2)] = null);

(statearr_21467_21574[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (36))){
var inst_21420 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21468_21575 = state_21427__$1;
(statearr_21468_21575[(2)] = inst_21420);

(statearr_21468_21575[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (41))){
var inst_21326 = cljs.core.count(clause);
var inst_21327 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21326);
var state_21427__$1 = state_21427;
if(inst_21327){
var statearr_21469_21576 = state_21427__$1;
(statearr_21469_21576[(1)] = (44));

} else {
var statearr_21470_21577 = state_21427__$1;
(statearr_21470_21577[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (43))){
var inst_21318 = (state_21427[(20)]);
var inst_21321 = (state_21427[(2)]);
var inst_21322 = fluree.db.util.async.throw_err(inst_21321);
var inst_21323 = [inst_21322,r];
var inst_21324 = (new cljs.core.PersistentVector(null,2,(5),inst_21318,inst_21323,null));
var state_21427__$1 = state_21427;
var statearr_21471_21578 = state_21427__$1;
(statearr_21471_21578[(2)] = inst_21324);

(statearr_21471_21578[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (61))){
var inst_21377 = (state_21427[(8)]);
var inst_21380 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21377,r,res,optional_QMARK_,fuel,max_fuel);
var state_21427__$1 = state_21427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(64),inst_21380);
} else {
if((state_val_21428 === (29))){
var inst_21200 = (state_21427[(16)]);
var inst_21283 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21200)].join('');
var inst_21284 = (new Error(inst_21283));
var inst_21285 = (function(){throw inst_21284})();
var state_21427__$1 = state_21427;
var statearr_21472_21579 = state_21427__$1;
(statearr_21472_21579[(2)] = inst_21285);

(statearr_21472_21579[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (44))){
var inst_21329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21330 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21427__$1 = (function (){var statearr_21473 = state_21427;
(statearr_21473[(21)] = inst_21329);

return statearr_21473;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(47),inst_21330);
} else {
if((state_val_21428 === (6))){
var inst_21200 = (state_21427[(16)]);
var inst_21204 = (state_21427[(17)]);
var inst_21199 = cljs.core.keys(clause);
var inst_21200__$1 = cljs.core.first(inst_21199);
var inst_21204__$1 = cljs.core._EQ_;
var inst_21205 = (function (){var G__21474 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21475 = inst_21200__$1;
return (inst_21204__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21204__$1.cljs$core$IFn$_invoke$arity$2(G__21474,G__21475) : inst_21204__$1.call(null,G__21474,G__21475));
})();
var state_21427__$1 = (function (){var statearr_21476 = state_21427;
(statearr_21476[(16)] = inst_21200__$1);

(statearr_21476[(17)] = inst_21204__$1);

return statearr_21476;
})();
if(cljs.core.truth_(inst_21205)){
var statearr_21477_21580 = state_21427__$1;
(statearr_21477_21580[(1)] = (9));

} else {
var statearr_21478_21581 = state_21427__$1;
(statearr_21478_21581[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (28))){
var inst_21277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21278 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21279 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21278,optional_QMARK_);
var inst_21280 = [inst_21279,r];
var inst_21281 = (new cljs.core.PersistentVector(null,2,(5),inst_21277,inst_21280,null));
var state_21427__$1 = state_21427;
var statearr_21479_21582 = state_21427__$1;
(statearr_21479_21582[(2)] = inst_21281);

(statearr_21479_21582[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (64))){
var inst_21382 = (state_21427[(2)]);
var inst_21383 = fluree.db.util.async.throw_err(inst_21382);
var state_21427__$1 = state_21427;
var statearr_21480_21583 = state_21427__$1;
(statearr_21480_21583[(2)] = inst_21383);

(statearr_21480_21583[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (51))){
var inst_21349 = cljs.core.first(clause);
var inst_21350 = cljs.core.sequential_QMARK_(inst_21349);
var state_21427__$1 = state_21427;
if(inst_21350){
var statearr_21481_21584 = state_21427__$1;
(statearr_21481_21584[(1)] = (54));

} else {
var statearr_21482_21585 = state_21427__$1;
(statearr_21482_21585[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (25))){
var inst_21200 = (state_21427[(16)]);
var inst_21204 = (state_21427[(17)]);
var inst_21265 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21266 = (function (){var segment_type = inst_21200;
var pred__21201 = inst_21204;
var expr__21202 = inst_21200;
var bindings = inst_21265;
return (function (p1__21186_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21186_SHARP_);
});
})();
var inst_21267 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21266,inst_21265);
var inst_21268 = cljs.core.PersistentHashMap.EMPTY;
var inst_21269 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21268,inst_21267);
var inst_21270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21271 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21269);
var inst_21272 = [inst_21271,r];
var inst_21273 = (new cljs.core.PersistentVector(null,2,(5),inst_21270,inst_21272,null));
var state_21427__$1 = state_21427;
var statearr_21483_21586 = state_21427__$1;
(statearr_21483_21586[(2)] = inst_21273);

(statearr_21483_21586[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (34))){
var inst_21304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21305 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21306 = [inst_21305,r];
var inst_21307 = (new cljs.core.PersistentVector(null,2,(5),inst_21304,inst_21306,null));
var state_21427__$1 = state_21427;
var statearr_21484_21587 = state_21427__$1;
(statearr_21484_21587[(2)] = inst_21307);

(statearr_21484_21587[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (17))){
var inst_21261 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21485_21588 = state_21427__$1;
(statearr_21485_21588[(2)] = inst_21261);

(statearr_21485_21588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (3))){
var inst_21425 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21427__$1,inst_21425);
} else {
if((state_val_21428 === (12))){
var inst_21207 = (state_21427[(22)]);
var inst_21211 = (state_21427[(2)]);
var inst_21212 = fluree.db.util.async.throw_err(inst_21211);
var inst_21213 = [inst_21212,r];
var inst_21214 = (new cljs.core.PersistentVector(null,2,(5),inst_21207,inst_21213,null));
var state_21427__$1 = state_21427;
var statearr_21486_21589 = state_21427__$1;
(statearr_21486_21589[(2)] = inst_21214);

(statearr_21486_21589[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (2))){
var _ = (function (){var statearr_21487 = state_21427;
(statearr_21487[(4)] = cljs.core.cons((5),(state_21427[(4)])));

return statearr_21487;
})();
var inst_21197 = cljs.core.map_QMARK_(clause);
var state_21427__$1 = state_21427;
if(inst_21197){
var statearr_21488_21590 = state_21427__$1;
(statearr_21488_21590[(1)] = (6));

} else {
var statearr_21489_21591 = state_21427__$1;
(statearr_21489_21591[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (66))){
var state_21427__$1 = state_21427;
var statearr_21490_21592 = state_21427__$1;
(statearr_21490_21592[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (23))){
var inst_21237 = (state_21427[(10)]);
var inst_21246 = (state_21427[(19)]);
var inst_21229 = inst_21237;
var inst_21230 = inst_21246;
var state_21427__$1 = (function (){var statearr_21492 = state_21427;
(statearr_21492[(12)] = inst_21229);

(statearr_21492[(18)] = inst_21230);

return statearr_21492;
})();
var statearr_21493_21593 = state_21427__$1;
(statearr_21493_21593[(2)] = null);

(statearr_21493_21593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (47))){
var inst_21329 = (state_21427[(21)]);
var inst_21332 = (state_21427[(2)]);
var inst_21333 = fluree.db.util.async.throw_err(inst_21332);
var inst_21334 = [inst_21333,r];
var inst_21335 = (new cljs.core.PersistentVector(null,2,(5),inst_21329,inst_21334,null));
var state_21427__$1 = state_21427;
var statearr_21494_21594 = state_21427__$1;
(statearr_21494_21594[(2)] = inst_21335);

(statearr_21494_21594[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (35))){
var inst_21310 = (state_21427[(23)]);
var inst_21309 = cljs.core.count(clause);
var inst_21310__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21309);
var state_21427__$1 = (function (){var statearr_21495 = state_21427;
(statearr_21495[(23)] = inst_21310__$1);

return statearr_21495;
})();
if(inst_21310__$1){
var statearr_21496_21595 = state_21427__$1;
(statearr_21496_21595[(1)] = (37));

} else {
var statearr_21497_21596 = state_21427__$1;
(statearr_21497_21596[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (19))){
var inst_21230 = (state_21427[(18)]);
var inst_21255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21256 = [inst_21230,r];
var inst_21257 = (new cljs.core.PersistentVector(null,2,(5),inst_21255,inst_21256,null));
var state_21427__$1 = state_21427;
var statearr_21498_21597 = state_21427__$1;
(statearr_21498_21597[(2)] = inst_21257);

(statearr_21498_21597[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (57))){
var inst_21372 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21427__$1 = state_21427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(60),inst_21372);
} else {
if((state_val_21428 === (68))){
var inst_21376 = (state_21427[(7)]);
var inst_21377 = (state_21427[(8)]);
var inst_21394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21395 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21376,res,inst_21377,fuel,max_fuel);
var state_21427__$1 = (function (){var statearr_21499 = state_21427;
(statearr_21499[(24)] = inst_21394);

return statearr_21499;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(71),inst_21395);
} else {
if((state_val_21428 === (11))){
var inst_21293 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21501_21598 = state_21427__$1;
(statearr_21501_21598[(2)] = inst_21293);

(statearr_21501_21598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (9))){
var inst_21207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21208 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21209 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21208,res,fuel,max_fuel,opts);
var state_21427__$1 = (function (){var statearr_21502 = state_21427;
(statearr_21502[(22)] = inst_21207);

return statearr_21502;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(12),inst_21209);
} else {
if((state_val_21428 === (5))){
var _ = (function (){var statearr_21503 = state_21427;
(statearr_21503[(4)] = cljs.core.rest((state_21427[(4)])));

return statearr_21503;
})();
var state_21427__$1 = state_21427;
var ex21500 = (state_21427__$1[(2)]);
var statearr_21504_21599 = state_21427__$1;
(statearr_21504_21599[(5)] = ex21500);


if((ex21500 instanceof Error)){
var statearr_21505_21600 = state_21427__$1;
(statearr_21505_21600[(1)] = (4));

(statearr_21505_21600[(5)] = null);

} else {
throw ex21500;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (14))){
var inst_21200 = (state_21427[(16)]);
var inst_21204 = (state_21427[(17)]);
var inst_21263 = (function (){var G__21506 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21507 = inst_21200;
return (inst_21204.cljs$core$IFn$_invoke$arity$2 ? inst_21204.cljs$core$IFn$_invoke$arity$2(G__21506,G__21507) : inst_21204.call(null,G__21506,G__21507));
})();
var state_21427__$1 = state_21427;
if(cljs.core.truth_(inst_21263)){
var statearr_21508_21601 = state_21427__$1;
(statearr_21508_21601[(1)] = (25));

} else {
var statearr_21509_21602 = state_21427__$1;
(statearr_21509_21602[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (45))){
var inst_21337 = cljs.core.count(clause);
var inst_21338 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21337);
var state_21427__$1 = state_21427;
if(inst_21338){
var statearr_21510_21603 = state_21427__$1;
(statearr_21510_21603[(1)] = (48));

} else {
var statearr_21511_21604 = state_21427__$1;
(statearr_21511_21604[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (53))){
var inst_21412 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21512_21605 = state_21427__$1;
(statearr_21512_21605[(2)] = inst_21412);

(statearr_21512_21605[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (26))){
var inst_21200 = (state_21427[(16)]);
var inst_21204 = (state_21427[(17)]);
var inst_21275 = (function (){var G__21513 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21514 = inst_21200;
return (inst_21204.cljs$core$IFn$_invoke$arity$2 ? inst_21204.cljs$core$IFn$_invoke$arity$2(G__21513,G__21514) : inst_21204.call(null,G__21513,G__21514));
})();
var state_21427__$1 = state_21427;
if(cljs.core.truth_(inst_21275)){
var statearr_21515_21606 = state_21427__$1;
(statearr_21515_21606[(1)] = (28));

} else {
var statearr_21516_21607 = state_21427__$1;
(statearr_21516_21607[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (16))){
var inst_21229 = (state_21427[(12)]);
var inst_21236 = (state_21427[(13)]);
var inst_21235 = cljs.core.seq(inst_21229);
var inst_21236__$1 = cljs.core.first(inst_21235);
var inst_21237 = cljs.core.next(inst_21235);
var state_21427__$1 = (function (){var statearr_21517 = state_21427;
(statearr_21517[(10)] = inst_21237);

(statearr_21517[(13)] = inst_21236__$1);

return statearr_21517;
})();
if(cljs.core.truth_(inst_21236__$1)){
var statearr_21518_21608 = state_21427__$1;
(statearr_21518_21608[(1)] = (18));

} else {
var statearr_21519_21609 = state_21427__$1;
(statearr_21519_21609[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (38))){
var inst_21310 = (state_21427[(23)]);
var state_21427__$1 = state_21427;
var statearr_21520_21610 = state_21427__$1;
(statearr_21520_21610[(2)] = inst_21310);

(statearr_21520_21610[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (30))){
var inst_21287 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21521_21611 = state_21427__$1;
(statearr_21521_21611[(2)] = inst_21287);

(statearr_21521_21611[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (10))){
var inst_21200 = (state_21427[(16)]);
var inst_21204 = (state_21427[(17)]);
var inst_21216 = (function (){var G__21522 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21523 = inst_21200;
return (inst_21204.cljs$core$IFn$_invoke$arity$2 ? inst_21204.cljs$core$IFn$_invoke$arity$2(G__21522,G__21523) : inst_21204.call(null,G__21522,G__21523));
})();
var state_21427__$1 = state_21427;
if(cljs.core.truth_(inst_21216)){
var statearr_21524_21612 = state_21427__$1;
(statearr_21524_21612[(1)] = (13));

} else {
var statearr_21525_21613 = state_21427__$1;
(statearr_21525_21613[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (18))){
var inst_21236 = (state_21427[(13)]);
var inst_21239 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21236,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21236,q_map,vars,fuel,max_fuel,opts));
var state_21427__$1 = state_21427;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21427__$1,(21),inst_21239);
} else {
if((state_val_21428 === (52))){
var state_21427__$1 = state_21427;
var statearr_21526_21614 = state_21427__$1;
(statearr_21526_21614[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (67))){
var inst_21405 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21528_21615 = state_21427__$1;
(statearr_21528_21615[(2)] = inst_21405);

(statearr_21528_21615[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (71))){
var inst_21394 = (state_21427[(24)]);
var inst_21397 = (state_21427[(2)]);
var inst_21398 = fluree.db.util.async.throw_err(inst_21397);
var inst_21399 = [inst_21398,r];
var inst_21400 = (new cljs.core.PersistentVector(null,2,(5),inst_21394,inst_21399,null));
var state_21427__$1 = state_21427;
var statearr_21529_21616 = state_21427__$1;
(statearr_21529_21616[(2)] = inst_21400);

(statearr_21529_21616[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (42))){
var inst_21418 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21530_21617 = state_21427__$1;
(statearr_21530_21617[(2)] = inst_21418);

(statearr_21530_21617[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (37))){
var inst_21312 = cljs.core.second(clause);
var inst_21313 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21312,"rdf:type");
var state_21427__$1 = state_21427;
var statearr_21531_21618 = state_21427__$1;
(statearr_21531_21618[(2)] = inst_21313);

(statearr_21531_21618[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (63))){
var inst_21407 = (state_21427[(2)]);
var state_21427__$1 = state_21427;
var statearr_21532_21619 = state_21427__$1;
(statearr_21532_21619[(2)] = inst_21407);

(statearr_21532_21619[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (8))){
var inst_21422 = (state_21427[(2)]);
var _ = (function (){var statearr_21533 = state_21427;
(statearr_21533[(4)] = cljs.core.rest((state_21427[(4)])));

return statearr_21533;
})();
var state_21427__$1 = state_21427;
var statearr_21534_21620 = state_21427__$1;
(statearr_21534_21620[(2)] = inst_21422);

(statearr_21534_21620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21428 === (49))){
var inst_21346 = cljs.core.count(clause);
var inst_21347 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21346);
var state_21427__$1 = state_21427;
if(inst_21347){
var statearr_21535_21621 = state_21427__$1;
(statearr_21535_21621[(1)] = (51));

} else {
var statearr_21536_21622 = state_21427__$1;
(statearr_21536_21622[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0 = (function (){
var statearr_21537 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21537[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__);

(statearr_21537[(1)] = (1));

return statearr_21537;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1 = (function (state_21427){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21427);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21538){var ex__2687__auto__ = e21538;
var statearr_21539_21623 = state_21427;
(statearr_21539_21623[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21427[(4)]))){
var statearr_21540_21624 = state_21427;
(statearr_21540_21624[(1)] = cljs.core.first((state_21427[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21625 = state_21427;
state_21427 = G__21625;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__ = function(state_21427){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1.call(this,state_21427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21541 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21541[(6)] = c__2706__auto__);

return statearr_21541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21627 = arguments.length;
switch (G__21627) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21706){
var state_val_21707 = (state_21706[(1)]);
if((state_val_21707 === (7))){
var inst_21701 = (state_21706[(2)]);
var _ = (function (){var statearr_21708 = state_21706;
(statearr_21708[(4)] = cljs.core.rest((state_21706[(4)])));

return statearr_21708;
})();
var state_21706__$1 = state_21706;
var statearr_21709_21757 = state_21706__$1;
(statearr_21709_21757[(2)] = inst_21701);

(statearr_21709_21757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (20))){
var inst_21666 = (state_21706[(7)]);
var inst_21678 = (state_21706[(2)]);
var inst_21648 = inst_21666;
var inst_21649 = inst_21678;
var state_21706__$1 = (function (){var statearr_21710 = state_21706;
(statearr_21710[(8)] = inst_21649);

(statearr_21710[(9)] = inst_21648);

return statearr_21710;
})();
var statearr_21711_21758 = state_21706__$1;
(statearr_21711_21758[(2)] = null);

(statearr_21711_21758[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (1))){
var state_21706__$1 = state_21706;
var statearr_21712_21759 = state_21706__$1;
(statearr_21712_21759[(2)] = null);

(statearr_21712_21759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (24))){
var inst_21649 = (state_21706[(8)]);
var inst_21665 = (state_21706[(10)]);
var inst_21666 = (state_21706[(7)]);
var inst_21686 = fluree.db.query.analytical.inner_join(inst_21649,inst_21665);
var inst_21648 = inst_21666;
var inst_21649__$1 = inst_21686;
var state_21706__$1 = (function (){var statearr_21713 = state_21706;
(statearr_21713[(8)] = inst_21649__$1);

(statearr_21713[(9)] = inst_21648);

return statearr_21713;
})();
var statearr_21714_21760 = state_21706__$1;
(statearr_21714_21760[(2)] = null);

(statearr_21714_21760[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (4))){
var inst_21628 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21716_21761 = state_21706__$1;
(statearr_21716_21761[(2)] = inst_21628);

(statearr_21716_21761[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (15))){
var inst_21665 = (state_21706[(10)]);
var state_21706__$1 = state_21706;
if(cljs.core.truth_(inst_21665)){
var statearr_21717_21762 = state_21706__$1;
(statearr_21717_21762[(1)] = (18));

} else {
var statearr_21718_21763 = state_21706__$1;
(statearr_21718_21763[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (21))){
var inst_21649 = (state_21706[(8)]);
var inst_21666 = (state_21706[(7)]);
var tmp21715 = inst_21649;
var inst_21648 = inst_21666;
var inst_21649__$1 = tmp21715;
var state_21706__$1 = (function (){var statearr_21719 = state_21706;
(statearr_21719[(8)] = inst_21649__$1);

(statearr_21719[(9)] = inst_21648);

return statearr_21719;
})();
var statearr_21720_21764 = state_21706__$1;
(statearr_21720_21764[(2)] = null);

(statearr_21720_21764[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (13))){
var inst_21649 = (state_21706[(8)]);
var inst_21672 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21649,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21673 = cljs.core.empty_QMARK_(inst_21672);
var state_21706__$1 = state_21706;
if(inst_21673){
var statearr_21721_21765 = state_21706__$1;
(statearr_21721_21765[(1)] = (15));

} else {
var statearr_21722_21766 = state_21706__$1;
(statearr_21722_21766[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (22))){
var state_21706__$1 = state_21706;
var statearr_21723_21767 = state_21706__$1;
(statearr_21723_21767[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (6))){
var inst_21655 = (state_21706[(11)]);
var inst_21648 = (state_21706[(9)]);
var inst_21654 = cljs.core.seq(inst_21648);
var inst_21655__$1 = cljs.core.first(inst_21654);
var inst_21656 = cljs.core.next(inst_21654);
var state_21706__$1 = (function (){var statearr_21725 = state_21706;
(statearr_21725[(12)] = inst_21656);

(statearr_21725[(11)] = inst_21655__$1);

return statearr_21725;
})();
if(cljs.core.truth_(inst_21655__$1)){
var statearr_21726_21768 = state_21706__$1;
(statearr_21726_21768[(1)] = (8));

} else {
var statearr_21727_21769 = state_21706__$1;
(statearr_21727_21769[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (25))){
var state_21706__$1 = state_21706;
var statearr_21728_21770 = state_21706__$1;
(statearr_21728_21770[(2)] = null);

(statearr_21728_21770[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (17))){
var inst_21694 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21729_21771 = state_21706__$1;
(statearr_21729_21771[(2)] = inst_21694);

(statearr_21729_21771[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (3))){
var inst_21704 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21706__$1,inst_21704);
} else {
if((state_val_21707 === (12))){
var inst_21665 = (state_21706[(10)]);
var inst_21666 = (state_21706[(7)]);
var inst_21648 = inst_21666;
var inst_21649 = inst_21665;
var state_21706__$1 = (function (){var statearr_21730 = state_21706;
(statearr_21730[(8)] = inst_21649);

(statearr_21730[(9)] = inst_21648);

return statearr_21730;
})();
var statearr_21731_21772 = state_21706__$1;
(statearr_21731_21772[(2)] = null);

(statearr_21731_21772[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (2))){
var _ = (function (){var statearr_21732 = state_21706;
(statearr_21732[(4)] = cljs.core.cons((5),(state_21706[(4)])));

return statearr_21732;
})();
var inst_21641 = where;
var inst_21642 = cljs.core.seq(inst_21641);
var inst_21643 = cljs.core.first(inst_21642);
var inst_21644 = cljs.core.next(inst_21642);
var inst_21645 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21646 = [vars];
var inst_21647 = cljs.core.PersistentHashMap.fromArrays(inst_21645,inst_21646);
var inst_21648 = inst_21641;
var inst_21649 = inst_21647;
var state_21706__$1 = (function (){var statearr_21733 = state_21706;
(statearr_21733[(13)] = inst_21643);

(statearr_21733[(14)] = inst_21644);

(statearr_21733[(8)] = inst_21649);

(statearr_21733[(9)] = inst_21648);

return statearr_21733;
})();
var statearr_21734_21773 = state_21706__$1;
(statearr_21734_21773[(2)] = null);

(statearr_21734_21773[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (23))){
var inst_21692 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21735_21774 = state_21706__$1;
(statearr_21735_21774[(2)] = inst_21692);

(statearr_21735_21774[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (19))){
var inst_21649 = (state_21706[(8)]);
var state_21706__$1 = state_21706;
var statearr_21736_21775 = state_21706__$1;
(statearr_21736_21775[(2)] = inst_21649);

(statearr_21736_21775[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (11))){
var inst_21655 = (state_21706[(11)]);
var inst_21663 = (state_21706[(2)]);
var inst_21664 = fluree.db.util.async.throw_err(inst_21663);
var inst_21665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21664,(0),null);
var inst_21666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21664,(1),null);
var inst_21667 = cljs.core.count(inst_21655);
var inst_21668 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21667);
var state_21706__$1 = (function (){var statearr_21738 = state_21706;
(statearr_21738[(10)] = inst_21665);

(statearr_21738[(7)] = inst_21666);

return statearr_21738;
})();
if(inst_21668){
var statearr_21739_21776 = state_21706__$1;
(statearr_21739_21776[(1)] = (12));

} else {
var statearr_21740_21777 = state_21706__$1;
(statearr_21740_21777[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (9))){
var inst_21649 = (state_21706[(8)]);
var state_21706__$1 = state_21706;
var statearr_21741_21778 = state_21706__$1;
(statearr_21741_21778[(2)] = inst_21649);

(statearr_21741_21778[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (5))){
var _ = (function (){var statearr_21742 = state_21706;
(statearr_21742[(4)] = cljs.core.rest((state_21706[(4)])));

return statearr_21742;
})();
var state_21706__$1 = state_21706;
var ex21737 = (state_21706__$1[(2)]);
var statearr_21743_21779 = state_21706__$1;
(statearr_21743_21779[(5)] = ex21737);


if((ex21737 instanceof Error)){
var statearr_21744_21780 = state_21706__$1;
(statearr_21744_21780[(1)] = (4));

(statearr_21744_21780[(5)] = null);

} else {
throw ex21737;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (14))){
var inst_21696 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21745_21781 = state_21706__$1;
(statearr_21745_21781[(2)] = inst_21696);

(statearr_21745_21781[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (26))){
var inst_21690 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21746_21782 = state_21706__$1;
(statearr_21746_21782[(2)] = inst_21690);

(statearr_21746_21782[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (16))){
var inst_21665 = (state_21706[(10)]);
var inst_21681 = (inst_21665 == null);
var state_21706__$1 = state_21706;
if(cljs.core.truth_(inst_21681)){
var statearr_21747_21783 = state_21706__$1;
(statearr_21747_21783[(1)] = (21));

} else {
var statearr_21748_21784 = state_21706__$1;
(statearr_21748_21784[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (10))){
var inst_21699 = (state_21706[(2)]);
var state_21706__$1 = state_21706;
var statearr_21749_21785 = state_21706__$1;
(statearr_21749_21785[(2)] = inst_21699);

(statearr_21749_21785[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (18))){
var inst_21665 = (state_21706[(10)]);
var state_21706__$1 = state_21706;
var statearr_21750_21786 = state_21706__$1;
(statearr_21750_21786[(2)] = inst_21665);

(statearr_21750_21786[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21707 === (8))){
var inst_21656 = (state_21706[(12)]);
var inst_21655 = (state_21706[(11)]);
var inst_21649 = (state_21706[(8)]);
var inst_21661 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21649,inst_21655,inst_21656,false,fuel,max_fuel,opts);
var state_21706__$1 = state_21706;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21706__$1,(11),inst_21661);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2684__auto__ = null;
var fluree$db$query$analytical$state_machine__2684__auto____0 = (function (){
var statearr_21751 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21751[(0)] = fluree$db$query$analytical$state_machine__2684__auto__);

(statearr_21751[(1)] = (1));

return statearr_21751;
});
var fluree$db$query$analytical$state_machine__2684__auto____1 = (function (state_21706){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21706);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21752){var ex__2687__auto__ = e21752;
var statearr_21753_21787 = state_21706;
(statearr_21753_21787[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21706[(4)]))){
var statearr_21754_21788 = state_21706;
(statearr_21754_21788[(1)] = cljs.core.first((state_21706[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21789 = state_21706;
state_21706 = G__21789;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2684__auto__ = function(state_21706){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2684__auto____1.call(this,state_21706);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2684__auto____0;
fluree$db$query$analytical$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2684__auto____1;
return fluree$db$query$analytical$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21755 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21755[(6)] = c__2706__auto__);

return statearr_21755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(p__21790){
var map__21791 = p__21790;
var map__21791__$1 = cljs.core.__destructure_map(map__21791);
var opts = map__21791__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21791__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var query_map = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21791__$1,new cljs.core.Keyword(null,"query-map","query-map",-808576972));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21791__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var max_fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21791__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21791__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_21825){
var state_val_21826 = (state_21825[(1)]);
if((state_val_21826 === (7))){
var inst_21807 = (state_21825[(7)]);
var inst_21802 = (state_21825[(8)]);
var inst_21809 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,query_map,inst_21802,inst_21807,fuel,max_fuel,opts);
var state_21825__$1 = state_21825;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21825__$1,(10),inst_21809);
} else {
if((state_val_21826 === (1))){
var state_21825__$1 = state_21825;
var statearr_21827_21852 = state_21825__$1;
(statearr_21827_21852[(2)] = null);

(statearr_21827_21852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (4))){
var inst_21792 = (state_21825[(2)]);
var state_21825__$1 = state_21825;
var statearr_21828_21853 = state_21825__$1;
(statearr_21828_21853[(2)] = inst_21792);

(statearr_21828_21853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (13))){
var inst_21820 = (state_21825[(2)]);
var _ = (function (){var statearr_21829 = state_21825;
(statearr_21829[(4)] = cljs.core.rest((state_21825[(4)])));

return statearr_21829;
})();
var state_21825__$1 = state_21825;
var statearr_21830_21854 = state_21825__$1;
(statearr_21830_21854[(2)] = inst_21820);

(statearr_21830_21854[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (6))){
var inst_21802 = (state_21825[(8)]);
var inst_21806 = (state_21825[(2)]);
var inst_21807 = fluree.db.util.async.throw_err(inst_21806);
var state_21825__$1 = (function (){var statearr_21831 = state_21825;
(statearr_21831[(7)] = inst_21807);

return statearr_21831;
})();
if(cljs.core.truth_(inst_21802)){
var statearr_21832_21855 = state_21825__$1;
(statearr_21832_21855[(1)] = (7));

} else {
var statearr_21833_21856 = state_21825__$1;
(statearr_21833_21856[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (3))){
var inst_21823 = (state_21825[(2)]);
var state_21825__$1 = state_21825;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21825__$1,inst_21823);
} else {
if((state_val_21826 === (12))){
var inst_21815 = (state_21825[(9)]);
var state_21825__$1 = state_21825;
var statearr_21834_21857 = state_21825__$1;
(statearr_21834_21857[(2)] = inst_21815);

(statearr_21834_21857[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (2))){
var _ = (function (){var statearr_21835 = state_21825;
(statearr_21835[(4)] = cljs.core.cons((5),(state_21825[(4)])));

return statearr_21835;
})();
var inst_21799 = query_map;
var inst_21800 = cljs.core.__destructure_map(inst_21799);
var inst_21801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21800,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21800,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21800,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21804 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21801,query_map,vars,fuel,max_fuel,opts);
var state_21825__$1 = (function (){var statearr_21836 = state_21825;
(statearr_21836[(8)] = inst_21802);

(statearr_21836[(10)] = inst_21803);

return statearr_21836;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21825__$1,(6),inst_21804);
} else {
if((state_val_21826 === (11))){
var inst_21815 = (state_21825[(9)]);
var inst_21803 = (state_21825[(10)]);
var inst_21817 = fluree.db.query.analytical.tuples__GT_filtered(inst_21815,inst_21803,null);
var state_21825__$1 = state_21825;
var statearr_21838_21858 = state_21825__$1;
(statearr_21838_21858[(2)] = inst_21817);

(statearr_21838_21858[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (9))){
var inst_21803 = (state_21825[(10)]);
var inst_21815 = (state_21825[(2)]);
var state_21825__$1 = (function (){var statearr_21839 = state_21825;
(statearr_21839[(9)] = inst_21815);

return statearr_21839;
})();
if(cljs.core.truth_(inst_21803)){
var statearr_21840_21859 = state_21825__$1;
(statearr_21840_21859[(1)] = (11));

} else {
var statearr_21841_21860 = state_21825__$1;
(statearr_21841_21860[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (5))){
var _ = (function (){var statearr_21842 = state_21825;
(statearr_21842[(4)] = cljs.core.rest((state_21825[(4)])));

return statearr_21842;
})();
var state_21825__$1 = state_21825;
var ex21837 = (state_21825__$1[(2)]);
var statearr_21843_21861 = state_21825__$1;
(statearr_21843_21861[(5)] = ex21837);


if((ex21837 instanceof Error)){
var statearr_21844_21862 = state_21825__$1;
(statearr_21844_21862[(1)] = (4));

(statearr_21844_21862[(5)] = null);

} else {
throw ex21837;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (10))){
var inst_21811 = (state_21825[(2)]);
var inst_21812 = fluree.db.util.async.throw_err(inst_21811);
var state_21825__$1 = state_21825;
var statearr_21845_21863 = state_21825__$1;
(statearr_21845_21863[(2)] = inst_21812);

(statearr_21845_21863[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21826 === (8))){
var inst_21807 = (state_21825[(7)]);
var state_21825__$1 = state_21825;
var statearr_21846_21864 = state_21825__$1;
(statearr_21846_21864[(2)] = inst_21807);

(statearr_21846_21864[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2684__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2684__auto____0 = (function (){
var statearr_21847 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21847[(0)] = fluree$db$query$analytical$q_$_state_machine__2684__auto__);

(statearr_21847[(1)] = (1));

return statearr_21847;
});
var fluree$db$query$analytical$q_$_state_machine__2684__auto____1 = (function (state_21825){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_21825);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e21848){var ex__2687__auto__ = e21848;
var statearr_21849_21865 = state_21825;
(statearr_21849_21865[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_21825[(4)]))){
var statearr_21850_21866 = state_21825;
(statearr_21850_21866[(1)] = cljs.core.first((state_21825[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21867 = state_21825;
state_21825 = G__21867;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2684__auto__ = function(state_21825){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2684__auto____1.call(this,state_21825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2684__auto____0;
fluree$db$query$analytical$q_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2684__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_21851 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_21851[(6)] = c__2706__auto__);

return statearr_21851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
