// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-ledger-id] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__25873 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25873,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25873,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25873,(2),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
/**
 * Predicates to exclude from the database
 */
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(130),(106)]);
fluree.db.graphdb.exclude_flake_QMARK_ = (function fluree$db$graphdb$exclude_flake_QMARK_(f){
return cljs.core.contains_QMARK_(fluree.db.graphdb.exclude_predicates,fluree.db.flake.p(f));
});
fluree.db.graphdb.include_flake_QMARK_ = cljs.core.complement(fluree.db.graphdb.exclude_flake_QMARK_);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__25876){
var map__25877 = p__25876;
var map__25877__$1 = cljs.core.__destructure_map(map__25877);
var opts = map__25877__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25877__$1,new cljs.core.Keyword(null,"reindex?","reindex?",683464852));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_25937){
var state_val_25938 = (state_25937[(1)]);
if((state_val_25938 === (7))){
var inst_25908 = cljs.core.not(reindex_QMARK_);
var state_25937__$1 = state_25937;
var statearr_25939_25963 = state_25937__$1;
(statearr_25939_25963[(2)] = inst_25908);

(statearr_25939_25963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (1))){
var state_25937__$1 = state_25937;
var statearr_25940_25964 = state_25937__$1;
(statearr_25940_25964[(2)] = null);

(statearr_25940_25964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (4))){
var inst_25878 = (state_25937[(2)]);
var state_25937__$1 = state_25937;
var statearr_25941_25965 = state_25937__$1;
(statearr_25941_25965[(2)] = inst_25878);

(statearr_25941_25965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (6))){
var inst_25898 = (state_25937[(7)]);
var inst_25892 = (state_25937[(8)]);
var inst_25906 = (state_25937[(9)]);
var inst_25891 = (state_25937[(2)]);
var inst_25892__$1 = fluree.db.util.async.throw_err(inst_25891);
var inst_25893 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_25894 = cljs.core.__destructure_map(inst_25893);
var inst_25895 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25894,new cljs.core.Keyword(null,"post","post",269697687));
var inst_25896 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25894,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_25897 = fluree.db.flake.size_bytes(inst_25892__$1);
var inst_25898__$1 = (inst_25896 + inst_25897);
var inst_25899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25900 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_25901 = (new cljs.core.PersistentVector(null,2,(5),inst_25899,inst_25900,null));
var inst_25902 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25901);
var inst_25903 = cljs.core.__destructure_map(inst_25902);
var inst_25904 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25903,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_25905 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25903,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_25906__$1 = (inst_25898__$1 > inst_25905);
var state_25937__$1 = (function (){var statearr_25942 = state_25937;
(statearr_25942[(7)] = inst_25898__$1);

(statearr_25942[(8)] = inst_25892__$1);

(statearr_25942[(9)] = inst_25906__$1);

(statearr_25942[(10)] = inst_25904);

(statearr_25942[(11)] = inst_25895);

return statearr_25942;
})();
if(cljs.core.truth_(inst_25906__$1)){
var statearr_25943_25966 = state_25937__$1;
(statearr_25943_25966[(1)] = (7));

} else {
var statearr_25944_25967 = state_25937__$1;
(statearr_25944_25967[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (3))){
var inst_25935 = (state_25937[(2)]);
var state_25937__$1 = state_25937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25937__$1,inst_25935);
} else {
if((state_val_25938 === (12))){
var inst_25898 = (state_25937[(7)]);
var inst_25892 = (state_25937[(8)]);
var inst_25895 = (state_25937[(11)]);
var inst_25921 = (state_25937[(2)]);
var inst_25922 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25895,inst_25892);
var inst_25923 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_25924 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_25923,cljs.core.empty);
var inst_25925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25926 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_25927 = (new cljs.core.PersistentVector(null,2,(5),inst_25925,inst_25926,null));
var inst_25928 = cljs.core.assoc_in(db,inst_25927,inst_25922);
var inst_25929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25930 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_25931 = (new cljs.core.PersistentVector(null,2,(5),inst_25929,inst_25930,null));
var inst_25932 = cljs.core.assoc_in(inst_25928,inst_25931,inst_25898);
var _ = (function (){var statearr_25945 = state_25937;
(statearr_25945[(4)] = cljs.core.rest((state_25937[(4)])));

return statearr_25945;
})();
var state_25937__$1 = (function (){var statearr_25946 = state_25937;
(statearr_25946[(12)] = inst_25924);

(statearr_25946[(13)] = inst_25921);

return statearr_25946;
})();
var statearr_25947_25968 = state_25937__$1;
(statearr_25947_25968[(2)] = inst_25932);

(statearr_25947_25968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (2))){
var _ = (function (){var statearr_25948 = state_25937;
(statearr_25948[(4)] = cljs.core.cons((5),(state_25937[(4)])));

return statearr_25948;
})();
var inst_25886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25887 = [pred_id];
var inst_25888 = (new cljs.core.PersistentVector(null,1,(5),inst_25886,inst_25887,null));
var inst_25889 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25888);
var state_25937__$1 = state_25937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25937__$1,(6),inst_25889);
} else {
if((state_val_25938 === (11))){
var state_25937__$1 = state_25937;
var statearr_25950_25969 = state_25937__$1;
(statearr_25950_25969[(2)] = null);

(statearr_25950_25969[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (9))){
var inst_25911 = (state_25937[(2)]);
var state_25937__$1 = state_25937;
if(cljs.core.truth_(inst_25911)){
var statearr_25951_25970 = state_25937__$1;
(statearr_25951_25970[(1)] = (10));

} else {
var statearr_25952_25971 = state_25937__$1;
(statearr_25952_25971[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (5))){
var _ = (function (){var statearr_25953 = state_25937;
(statearr_25953[(4)] = cljs.core.rest((state_25937[(4)])));

return statearr_25953;
})();
var state_25937__$1 = state_25937;
var ex25949 = (state_25937__$1[(2)]);
var statearr_25954_25972 = state_25937__$1;
(statearr_25954_25972[(5)] = ex25949);


if((ex25949 instanceof Error)){
var statearr_25955_25973 = state_25937__$1;
(statearr_25955_25973[(1)] = (4));

(statearr_25955_25973[(5)] = null);

} else {
throw ex25949;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (10))){
var inst_25913 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_25914 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_25915 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_25916 = cljs.core.PersistentHashMap.fromArrays(inst_25914,inst_25915);
var inst_25917 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25913,inst_25916);
var inst_25918 = (function(){throw inst_25917})();
var state_25937__$1 = state_25937;
var statearr_25956_25974 = state_25937__$1;
(statearr_25956_25974[(2)] = inst_25918);

(statearr_25956_25974[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25938 === (8))){
var inst_25906 = (state_25937[(9)]);
var state_25937__$1 = state_25937;
var statearr_25957_25975 = state_25937__$1;
(statearr_25957_25975[(2)] = inst_25906);

(statearr_25957_25975[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0 = (function (){
var statearr_25958 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25958[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__);

(statearr_25958[(1)] = (1));

return statearr_25958;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1 = (function (state_25937){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_25937);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e25959){var ex__2687__auto__ = e25959;
var statearr_25960_25976 = state_25937;
(statearr_25960_25976[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_25937[(4)]))){
var statearr_25961_25977 = state_25937;
(statearr_25961_25977[(1)] = cljs.core.first((state_25937[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25978 = state_25937;
state_25937 = G__25978;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__ = function(state_25937){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1.call(this,state_25937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_25962 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_25962[(6)] = c__2706__auto__);

return statearr_25962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__25981 = arguments.length;
switch (G__25981) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26181){
var state_val_26182 = (state_26181[(1)]);
if((state_val_26182 === (7))){
var state_26181__$1 = state_26181;
var statearr_26183_26250 = state_26181__$1;
(statearr_26183_26250[(2)] = null);

(statearr_26183_26250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (20))){
var inst_26103 = (state_26181[(7)]);
var inst_26017 = (state_26181[(8)]);
var inst_26018 = (state_26181[(9)]);
var inst_26101 = (state_26181[(10)]);
var inst_26068 = (state_26181[(11)]);
var inst_26105 = (state_26181[(12)]);
var inst_26106 = (state_26181[(13)]);
var inst_26104 = (state_26181[(14)]);
var inst_26102 = (state_26181[(15)]);
var inst_26116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26117 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26118 = (new cljs.core.PersistentVector(null,2,(5),inst_26116,inst_26117,null));
var inst_26119 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26068,inst_26118);
var inst_26120 = (inst_26119 + inst_26017);
var inst_26121 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26122 = [inst_26101,inst_26102,inst_26103,inst_26104,inst_26105,inst_26120];
var inst_26123 = cljs.core.PersistentHashMap.fromArrays(inst_26121,inst_26122);
var inst_26124 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_26068,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26106,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26123], 0));
var state_26181__$1 = (function (){var statearr_26184 = state_26181;
(statearr_26184[(16)] = inst_26124);

return statearr_26184;
})();
if(cljs.core.truth_(inst_26018)){
var statearr_26185_26251 = state_26181__$1;
(statearr_26185_26251[(1)] = (23));

} else {
var statearr_26186_26252 = state_26181__$1;
(statearr_26186_26252[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (27))){
var inst_26124 = (state_26181[(16)]);
var state_26181__$1 = state_26181;
var statearr_26187_26253 = state_26181__$1;
(statearr_26187_26253[(2)] = inst_26124);

(statearr_26187_26253[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (1))){
var state_26181__$1 = state_26181;
var statearr_26188_26254 = state_26181__$1;
(statearr_26188_26254[(2)] = null);

(statearr_26188_26254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (24))){
var inst_26124 = (state_26181[(16)]);
var inst_26128 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26124);
var inst_26129 = (inst_26128 == null);
var state_26181__$1 = state_26181;
var statearr_26189_26255 = state_26181__$1;
(statearr_26189_26255[(2)] = inst_26129);

(statearr_26189_26255[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (39))){
var inst_26105 = (state_26181[(12)]);
var inst_26112 = (state_26181[(17)]);
var inst_26155 = (state_26181[(18)]);
var inst_26113 = (state_26181[(19)]);
var inst_26163 = (state_26181[(20)]);
var inst_26154 = (state_26181[(21)]);
var inst_26156 = (state_26181[(22)]);
var inst_26170 = (state_26181[(2)]);
var inst_26171 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26105,inst_26112);
var inst_26100 = inst_26113;
var inst_26101 = inst_26155;
var inst_26102 = inst_26156;
var inst_26103 = inst_26163;
var inst_26104 = inst_26170;
var inst_26105__$1 = inst_26171;
var inst_26106 = inst_26154;
var state_26181__$1 = (function (){var statearr_26190 = state_26181;
(statearr_26190[(7)] = inst_26103);

(statearr_26190[(10)] = inst_26101);

(statearr_26190[(12)] = inst_26105__$1);

(statearr_26190[(13)] = inst_26106);

(statearr_26190[(14)] = inst_26104);

(statearr_26190[(23)] = inst_26100);

(statearr_26190[(15)] = inst_26102);

return statearr_26190;
})();
var statearr_26191_26256 = state_26181__$1;
(statearr_26191_26256[(2)] = null);

(statearr_26191_26256[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (4))){
var inst_25982 = (state_26181[(2)]);
var state_26181__$1 = state_26181;
var statearr_26192_26257 = state_26181__$1;
(statearr_26192_26257[(2)] = inst_25982);

(statearr_26192_26257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (15))){
var inst_26040 = (state_26181[(24)]);
var state_26181__$1 = state_26181;
var statearr_26193_26258 = state_26181__$1;
(statearr_26193_26258[(2)] = inst_26040);

(statearr_26193_26258[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (21))){
var inst_26103 = (state_26181[(7)]);
var inst_26017 = (state_26181[(8)]);
var inst_26018 = (state_26181[(9)]);
var inst_26005 = (state_26181[(25)]);
var inst_26101 = (state_26181[(10)]);
var inst_26078 = (state_26181[(26)]);
var inst_26068 = (state_26181[(11)]);
var inst_26019 = (state_26181[(27)]);
var inst_26105 = (state_26181[(12)]);
var inst_25989 = (state_26181[(28)]);
var inst_26106 = (state_26181[(13)]);
var inst_26077 = (state_26181[(29)]);
var inst_26104 = (state_26181[(14)]);
var inst_26112 = (state_26181[(17)]);
var inst_26113 = (state_26181[(19)]);
var inst_26100 = (state_26181[(23)]);
var inst_26012 = (state_26181[(30)]);
var inst_26027 = (state_26181[(31)]);
var inst_26102 = (state_26181[(15)]);
var inst_26004 = (state_26181[(32)]);
var inst_26016 = (state_26181[(33)]);
var inst_26021 = (state_26181[(34)]);
var inst_26008 = (state_26181[(35)]);
var inst_26151 = fluree.db.flake.s(inst_26112);
var inst_26152 = fluree.db.flake.sid__GT_cid(inst_26151);
var inst_26153 = (function (){var flakes_bytes = inst_26017;
var vec__26108 = inst_26100;
var t = inst_25989;
var vec__26073 = inst_26005;
var spot = inst_26101;
var add_flakes = inst_26005;
var first__26110 = inst_26112;
var root_setting_change_QMARK_ = inst_26019;
var ref_QMARK__map = inst_26016;
var r = inst_26113;
var psot = inst_26102;
var seq__26109 = inst_26113;
var add_pred_to_idx_QMARK_ = inst_26027;
var _ = inst_26004;
var tspo = inst_26105;
var cid = inst_26152;
var ecount = inst_26106;
var seq__26074 = inst_26078;
var pred_ecount = inst_26021;
var G__26072 = inst_26100;
var db_STAR_ = inst_26068;
var system_change_QMARK_ = inst_26018;
var add_preds = inst_26008;
var first__26075 = inst_26077;
var opst = inst_26104;
var idx_QMARK__map = inst_26012;
var post = inst_26103;
var f = inst_26112;
return (function (p1__25979_SHARP_){
if(cljs.core.truth_(p1__25979_SHARP_)){
var x__5130__auto__ = p1__25979_SHARP_;
var y__5131__auto__ = fluree.db.flake.s(f);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
} else {
return fluree.db.flake.s(f);
}
});
})();
var inst_26154 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_26106,inst_26152,inst_26153);
var inst_26155 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26101,inst_26112);
var inst_26156 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26102,inst_26112);
var inst_26157 = fluree.db.flake.p(inst_26112);
var inst_26158 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26012,inst_26157);
var state_26181__$1 = (function (){var statearr_26194 = state_26181;
(statearr_26194[(18)] = inst_26155);

(statearr_26194[(21)] = inst_26154);

(statearr_26194[(22)] = inst_26156);

return statearr_26194;
})();
if(cljs.core.truth_(inst_26158)){
var statearr_26195_26259 = state_26181__$1;
(statearr_26195_26259[(1)] = (34));

} else {
var statearr_26196_26260 = state_26181__$1;
(statearr_26196_26260[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (31))){
var inst_26140 = (state_26181[(36)]);
var state_26181__$1 = state_26181;
var statearr_26197_26261 = state_26181__$1;
(statearr_26197_26261[(2)] = inst_26140);

(statearr_26197_26261[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (32))){
var inst_26149 = (state_26181[(2)]);
var state_26181__$1 = state_26181;
var statearr_26198_26262 = state_26181__$1;
(statearr_26198_26262[(2)] = inst_26149);

(statearr_26198_26262[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (33))){
var inst_26140 = (state_26181[(36)]);
var inst_26144 = (state_26181[(2)]);
var inst_26145 = fluree.db.util.async.throw_err(inst_26144);
var inst_26146 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26140,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26145);
var state_26181__$1 = state_26181;
var statearr_26199_26263 = state_26181__$1;
(statearr_26199_26263[(2)] = inst_26146);

(statearr_26199_26263[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (13))){
var inst_26017 = (state_26181[(8)]);
var inst_26005 = (state_26181[(25)]);
var inst_26068 = (state_26181[(11)]);
var inst_25989 = (state_26181[(28)]);
var inst_26058 = (state_26181[(2)]);
var inst_26059 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26058,new cljs.core.Keyword(null,"t","t",-1397832519),inst_25989);
var inst_26060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26061 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26062 = (new cljs.core.PersistentVector(null,2,(5),inst_26060,inst_26061,null));
var inst_26063 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26059,inst_26062,cljs.core._PLUS_,inst_26017);
var inst_26064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26065 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26066 = (new cljs.core.PersistentVector(null,2,(5),inst_26064,inst_26065,null));
var inst_26067 = cljs.core.count(inst_26005);
var inst_26068__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_26063,inst_26066,cljs.core._PLUS_,inst_26067);
var inst_26076 = cljs.core.seq(inst_26005);
var inst_26077 = cljs.core.first(inst_26076);
var inst_26078 = cljs.core.next(inst_26076);
var inst_26079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26080 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26081 = (new cljs.core.PersistentVector(null,2,(5),inst_26079,inst_26080,null));
var inst_26082 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26068__$1,inst_26081);
var inst_26083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26084 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26085 = (new cljs.core.PersistentVector(null,2,(5),inst_26083,inst_26084,null));
var inst_26086 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26068__$1,inst_26085);
var inst_26087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26088 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26089 = (new cljs.core.PersistentVector(null,2,(5),inst_26087,inst_26088,null));
var inst_26090 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26068__$1,inst_26089);
var inst_26091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26092 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26093 = (new cljs.core.PersistentVector(null,2,(5),inst_26091,inst_26092,null));
var inst_26094 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26068__$1,inst_26093);
var inst_26095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26096 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"tspo","tspo",-440144953)];
var inst_26097 = (new cljs.core.PersistentVector(null,2,(5),inst_26095,inst_26096,null));
var inst_26098 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_26068__$1,inst_26097);
var inst_26099 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26100 = inst_26005;
var inst_26101 = inst_26082;
var inst_26102 = inst_26086;
var inst_26103 = inst_26090;
var inst_26104 = inst_26094;
var inst_26105 = inst_26098;
var inst_26106 = inst_26099;
var state_26181__$1 = (function (){var statearr_26200 = state_26181;
(statearr_26200[(7)] = inst_26103);

(statearr_26200[(10)] = inst_26101);

(statearr_26200[(26)] = inst_26078);

(statearr_26200[(11)] = inst_26068__$1);

(statearr_26200[(12)] = inst_26105);

(statearr_26200[(13)] = inst_26106);

(statearr_26200[(29)] = inst_26077);

(statearr_26200[(14)] = inst_26104);

(statearr_26200[(23)] = inst_26100);

(statearr_26200[(15)] = inst_26102);

return statearr_26200;
})();
var statearr_26201_26264 = state_26181__$1;
(statearr_26201_26264[(2)] = null);

(statearr_26201_26264[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (22))){
var inst_26174 = (state_26181[(2)]);
var state_26181__$1 = state_26181;
var statearr_26202_26265 = state_26181__$1;
(statearr_26202_26265[(2)] = inst_26174);

(statearr_26202_26265[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (36))){
var inst_26112 = (state_26181[(17)]);
var inst_26016 = (state_26181[(33)]);
var inst_26163 = (state_26181[(2)]);
var inst_26164 = fluree.db.flake.p(inst_26112);
var inst_26165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26016,inst_26164);
var state_26181__$1 = (function (){var statearr_26203 = state_26181;
(statearr_26203[(20)] = inst_26163);

return statearr_26203;
})();
if(cljs.core.truth_(inst_26165)){
var statearr_26204_26266 = state_26181__$1;
(statearr_26204_26266[(1)] = (37));

} else {
var statearr_26205_26267 = state_26181__$1;
(statearr_26205_26267[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (29))){
var inst_26124 = (state_26181[(16)]);
var inst_26135 = (state_26181[(2)]);
var inst_26136 = fluree.db.util.async.throw_err(inst_26135);
var inst_26137 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26124,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26136);
var state_26181__$1 = state_26181;
var statearr_26206_26268 = state_26181__$1;
(statearr_26206_26268[(2)] = inst_26137);

(statearr_26206_26268[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (6))){
var inst_25989 = (state_26181[(28)]);
var inst_25994 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_25995 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25996 = ["Invalid with called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25994)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25995)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_25989),"."].join('');
var inst_25997 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25998 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_25999 = cljs.core.PersistentHashMap.fromArrays(inst_25997,inst_25998);
var inst_26000 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25996,inst_25999);
var inst_26001 = (function(){throw inst_26000})();
var state_26181__$1 = state_26181;
var statearr_26207_26269 = state_26181__$1;
(statearr_26207_26269[(2)] = inst_26001);

(statearr_26207_26269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (28))){
var inst_26019 = (state_26181[(27)]);
var inst_26140 = (state_26181[(2)]);
var state_26181__$1 = (function (){var statearr_26208 = state_26181;
(statearr_26208[(36)] = inst_26140);

return statearr_26208;
})();
if(cljs.core.truth_(inst_26019)){
var statearr_26209_26270 = state_26181__$1;
(statearr_26209_26270[(1)] = (30));

} else {
var statearr_26210_26271 = state_26181__$1;
(statearr_26210_26271[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (25))){
var inst_26131 = (state_26181[(2)]);
var state_26181__$1 = state_26181;
if(cljs.core.truth_(inst_26131)){
var statearr_26211_26272 = state_26181__$1;
(statearr_26211_26272[(1)] = (26));

} else {
var statearr_26212_26273 = state_26181__$1;
(statearr_26212_26273[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (34))){
var inst_26103 = (state_26181[(7)]);
var inst_26112 = (state_26181[(17)]);
var inst_26160 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26103,inst_26112);
var state_26181__$1 = state_26181;
var statearr_26213_26274 = state_26181__$1;
(statearr_26213_26274[(2)] = inst_26160);

(statearr_26213_26274[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (17))){
var inst_26047 = (state_26181[(37)]);
var inst_26051 = (state_26181[(2)]);
var inst_26052 = fluree.db.util.async.throw_err(inst_26051);
var inst_26039 = inst_26047;
var inst_26040 = inst_26052;
var state_26181__$1 = (function (){var statearr_26214 = state_26181;
(statearr_26214[(24)] = inst_26040);

(statearr_26214[(38)] = inst_26039);

return statearr_26214;
})();
var statearr_26215_26275 = state_26181__$1;
(statearr_26215_26275[(2)] = null);

(statearr_26215_26275[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (3))){
var inst_26179 = (state_26181[(2)]);
var state_26181__$1 = state_26181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26181__$1,inst_26179);
} else {
if((state_val_26182 === (12))){
var inst_26039 = (state_26181[(38)]);
var inst_26046 = (state_26181[(39)]);
var inst_26045 = cljs.core.seq(inst_26039);
var inst_26046__$1 = cljs.core.first(inst_26045);
var inst_26047 = cljs.core.next(inst_26045);
var state_26181__$1 = (function (){var statearr_26216 = state_26181;
(statearr_26216[(37)] = inst_26047);

(statearr_26216[(39)] = inst_26046__$1);

return statearr_26216;
})();
if(cljs.core.truth_(inst_26046__$1)){
var statearr_26217_26276 = state_26181__$1;
(statearr_26217_26276[(1)] = (14));

} else {
var statearr_26218_26277 = state_26181__$1;
(statearr_26218_26277[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (2))){
var inst_25989 = (state_26181[(28)]);
var _ = (function (){var statearr_26219 = state_26181;
(statearr_26219[(4)] = cljs.core.cons((5),(state_26181[(4)])));

return statearr_26219;
})();
var inst_25988 = cljs.core.first(flakes);
var inst_25989__$1 = fluree.db.flake.t(inst_25988);
var inst_25990 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_25991 = (inst_25990 - (1));
var inst_25992 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_25989__$1,inst_25991);
var state_26181__$1 = (function (){var statearr_26220 = state_26181;
(statearr_26220[(28)] = inst_25989__$1);

return statearr_26220;
})();
if(inst_25992){
var statearr_26221_26278 = state_26181__$1;
(statearr_26221_26278[(1)] = (6));

} else {
var statearr_26222_26279 = state_26181__$1;
(statearr_26222_26279[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (23))){
var inst_26018 = (state_26181[(9)]);
var state_26181__$1 = state_26181;
var statearr_26223_26280 = state_26181__$1;
(statearr_26223_26280[(2)] = inst_26018);

(statearr_26223_26280[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (35))){
var inst_26103 = (state_26181[(7)]);
var state_26181__$1 = state_26181;
var statearr_26224_26281 = state_26181__$1;
(statearr_26224_26281[(2)] = inst_26103);

(statearr_26224_26281[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (19))){
var inst_26176 = (state_26181[(2)]);
var _ = (function (){var statearr_26225 = state_26181;
(statearr_26225[(4)] = cljs.core.rest((state_26181[(4)])));

return statearr_26225;
})();
var state_26181__$1 = state_26181;
var statearr_26226_26282 = state_26181__$1;
(statearr_26226_26282[(2)] = inst_26176);

(statearr_26226_26282[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (11))){
var inst_26027 = (state_26181[(31)]);
var inst_26027__$1 = (state_26181[(2)]);
var inst_26035 = cljs.core.seq(inst_26027__$1);
var inst_26036 = cljs.core.first(inst_26035);
var inst_26037 = cljs.core.next(inst_26035);
var inst_26038 = db;
var inst_26039 = inst_26027__$1;
var inst_26040 = inst_26038;
var state_26181__$1 = (function (){var statearr_26228 = state_26181;
(statearr_26228[(24)] = inst_26040);

(statearr_26228[(40)] = inst_26037);

(statearr_26228[(38)] = inst_26039);

(statearr_26228[(41)] = inst_26036);

(statearr_26228[(31)] = inst_26027__$1);

return statearr_26228;
})();
var statearr_26229_26283 = state_26181__$1;
(statearr_26229_26283[(2)] = null);

(statearr_26229_26283[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (9))){
var inst_26005 = (state_26181[(25)]);
var inst_26021 = (state_26181[(34)]);
var inst_26023 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_26005,inst_26021);
var state_26181__$1 = state_26181;
var statearr_26230_26284 = state_26181__$1;
(statearr_26230_26284[(2)] = inst_26023);

(statearr_26230_26284[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (5))){
var _ = (function (){var statearr_26231 = state_26181;
(statearr_26231[(4)] = cljs.core.rest((state_26181[(4)])));

return statearr_26231;
})();
var state_26181__$1 = state_26181;
var ex26227 = (state_26181__$1[(2)]);
var statearr_26232_26285 = state_26181__$1;
(statearr_26232_26285[(5)] = ex26227);


if((ex26227 instanceof Error)){
var statearr_26233_26286 = state_26181__$1;
(statearr_26233_26286[(1)] = (4));

(statearr_26233_26286[(5)] = null);

} else {
throw ex26227;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (14))){
var inst_26040 = (state_26181[(24)]);
var inst_26046 = (state_26181[(39)]);
var inst_26049 = fluree.db.graphdb.add_predicate_to_idx(inst_26040,inst_26046,opts);
var state_26181__$1 = state_26181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26181__$1,(17),inst_26049);
} else {
if((state_val_26182 === (26))){
var inst_26124 = (state_26181[(16)]);
var inst_26133 = fluree.db.query.schema.schema_map(inst_26124);
var state_26181__$1 = state_26181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26181__$1,(29),inst_26133);
} else {
if((state_val_26182 === (16))){
var inst_26056 = (state_26181[(2)]);
var state_26181__$1 = state_26181;
var statearr_26234_26287 = state_26181__$1;
(statearr_26234_26287[(2)] = inst_26056);

(statearr_26234_26287[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (38))){
var inst_26104 = (state_26181[(14)]);
var state_26181__$1 = state_26181;
var statearr_26235_26288 = state_26181__$1;
(statearr_26235_26288[(2)] = inst_26104);

(statearr_26235_26288[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (30))){
var inst_26124 = (state_26181[(16)]);
var inst_26142 = fluree.db.query.schema.setting_map(inst_26124);
var state_26181__$1 = state_26181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26181__$1,(33),inst_26142);
} else {
if((state_val_26182 === (10))){
var inst_26025 = cljs.core.PersistentVector.EMPTY;
var state_26181__$1 = state_26181;
var statearr_26236_26289 = state_26181__$1;
(statearr_26236_26289[(2)] = inst_26025);

(statearr_26236_26289[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (18))){
var inst_26112 = (state_26181[(17)]);
var inst_26100 = (state_26181[(23)]);
var inst_26111 = cljs.core.seq(inst_26100);
var inst_26112__$1 = cljs.core.first(inst_26111);
var inst_26113 = cljs.core.next(inst_26111);
var inst_26114 = cljs.core.not(inst_26112__$1);
var state_26181__$1 = (function (){var statearr_26237 = state_26181;
(statearr_26237[(17)] = inst_26112__$1);

(statearr_26237[(19)] = inst_26113);

return statearr_26237;
})();
if(inst_26114){
var statearr_26238_26290 = state_26181__$1;
(statearr_26238_26290[(1)] = (20));

} else {
var statearr_26239_26291 = state_26181__$1;
(statearr_26239_26291[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (37))){
var inst_26104 = (state_26181[(14)]);
var inst_26112 = (state_26181[(17)]);
var inst_26167 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26104,inst_26112);
var state_26181__$1 = state_26181;
var statearr_26240_26292 = state_26181__$1;
(statearr_26240_26292[(2)] = inst_26167);

(statearr_26240_26292[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26182 === (8))){
var inst_26018 = (state_26181[(9)]);
var inst_26005 = (state_26181[(25)]);
var inst_25989 = (state_26181[(28)]);
var inst_26012 = (state_26181[(30)]);
var inst_26004 = (state_26181[(32)]);
var inst_26008 = (state_26181[(35)]);
var inst_26004__$1 = (state_26181[(2)]);
var inst_26005__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.graphdb.include_flake_QMARK_,flakes);
var inst_26006 = cljs.core.PersistentHashSet.EMPTY;
var inst_26007 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.p,inst_26005__$1);
var inst_26008__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26006,inst_26007);
var inst_26009 = cljs.core.PersistentHashMap.EMPTY;
var inst_26010 = (function (){var t = inst_25989;
var _ = inst_26004__$1;
var add_flakes = inst_26005__$1;
var add_preds = inst_26008__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26011 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26010,inst_26008__$1);
var inst_26012__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26009,inst_26011);
var inst_26013 = cljs.core.PersistentHashMap.EMPTY;
var inst_26014 = (function (){var t = inst_25989;
var _ = inst_26004__$1;
var add_flakes = inst_26005__$1;
var add_preds = inst_26008__$1;
var idx_QMARK__map = inst_26012__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26015 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_26014,inst_26008__$1);
var inst_26016 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26013,inst_26015);
var inst_26017 = fluree.db.flake.size_bytes(inst_26005__$1);
var inst_26018__$1 = fluree.db.util.schema.system_change_QMARK_(inst_26005__$1);
var inst_26019 = fluree.db.util.schema.setting_change_QMARK_(inst_26005__$1);
var inst_26020 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26021 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26020,(0));
var state_26181__$1 = (function (){var statearr_26241 = state_26181;
(statearr_26241[(8)] = inst_26017);

(statearr_26241[(9)] = inst_26018__$1);

(statearr_26241[(25)] = inst_26005__$1);

(statearr_26241[(27)] = inst_26019);

(statearr_26241[(30)] = inst_26012__$1);

(statearr_26241[(32)] = inst_26004__$1);

(statearr_26241[(33)] = inst_26016);

(statearr_26241[(34)] = inst_26021);

(statearr_26241[(35)] = inst_26008__$1);

return statearr_26241;
})();
if(cljs.core.truth_(inst_26018__$1)){
var statearr_26242_26293 = state_26181__$1;
(statearr_26242_26293[(1)] = (9));

} else {
var statearr_26243_26294 = state_26181__$1;
(statearr_26243_26294[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26244[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26244[(1)] = (1));

return statearr_26244;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26181){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26181);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26245){var ex__2687__auto__ = e26245;
var statearr_26246_26295 = state_26181;
(statearr_26246_26295[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26181[(4)]))){
var statearr_26247_26296 = state_26181;
(statearr_26247_26296[(1)] = cljs.core.first((state_26181[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26297 = state_26181;
state_26181 = G__26297;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26181){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26248 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26248[(6)] = c__2706__auto__);

return statearr_26248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__26299 = arguments.length;
switch (G__26299) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___26446 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26395){
var state_val_26396 = (state_26395[(1)]);
if((state_val_26396 === (7))){
var state_26395__$1 = state_26395;
var statearr_26397_26447 = state_26395__$1;
(statearr_26397_26447[(2)] = null);

(statearr_26397_26447[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (20))){
var inst_26344 = (state_26395[(7)]);
var inst_26343 = (state_26395[(8)]);
var inst_26345 = (state_26395[(9)]);
var inst_26364 = (inst_26343 + (1));
var inst_26365 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26345,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26364);
var inst_26366 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_26365,inst_26344,opts);
var state_26395__$1 = state_26395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26395__$1,(23),inst_26366);
} else {
if((state_val_26396 === (1))){
var state_26395__$1 = state_26395;
var statearr_26398_26448 = state_26395__$1;
(statearr_26398_26448[(2)] = null);

(statearr_26398_26448[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (24))){
var inst_26369 = (state_26395[(10)]);
var inst_26372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26369,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26395__$1 = state_26395;
var statearr_26399_26449 = state_26395__$1;
(statearr_26399_26449[(2)] = inst_26372);

(statearr_26399_26449[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (4))){
var inst_26300 = (state_26395[(2)]);
var inst_26301 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26300);
var state_26395__$1 = state_26395;
var statearr_26400_26450 = state_26395__$1;
(statearr_26400_26450[(2)] = inst_26301);

(statearr_26400_26450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (15))){
var inst_26351 = (state_26395[(11)]);
var state_26395__$1 = state_26395;
var statearr_26401_26451 = state_26395__$1;
(statearr_26401_26451[(2)] = inst_26351);

(statearr_26401_26451[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (21))){
var state_26395__$1 = state_26395;
var statearr_26402_26452 = state_26395__$1;
(statearr_26402_26452[(2)] = null);

(statearr_26402_26452[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (13))){
var inst_26387 = (state_26395[(2)]);
var inst_26388 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26387);
var state_26395__$1 = state_26395;
var statearr_26403_26453 = state_26395__$1;
(statearr_26403_26453[(2)] = inst_26388);

(statearr_26403_26453[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (22))){
var inst_26383 = (state_26395[(2)]);
var state_26395__$1 = state_26395;
var statearr_26404_26454 = state_26395__$1;
(statearr_26404_26454[(2)] = inst_26383);

(statearr_26404_26454[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (6))){
var inst_26311 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(db);
var inst_26312 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26313 = ["Invalid 'with' called for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26311)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26312)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26314 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26315 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26316 = cljs.core.PersistentHashMap.fromArrays(inst_26314,inst_26315);
var inst_26317 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26313,inst_26316);
var inst_26318 = (function(){throw inst_26317})();
var state_26395__$1 = state_26395;
var statearr_26407_26455 = state_26395__$1;
(statearr_26407_26455[(2)] = inst_26318);

(statearr_26407_26455[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (25))){
var inst_26352 = (state_26395[(12)]);
var inst_26351 = (state_26395[(11)]);
var inst_26369 = (state_26395[(10)]);
var inst_26374 = fluree.db.flake.t(inst_26351);
var inst_26375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26376 = [inst_26351];
var inst_26377 = (new cljs.core.PersistentVector(null,1,(5),inst_26375,inst_26376,null));
var inst_26342 = inst_26352;
var inst_26343 = inst_26374;
var inst_26344 = inst_26377;
var inst_26345 = inst_26369;
var state_26395__$1 = (function (){var statearr_26408 = state_26395;
(statearr_26408[(13)] = inst_26342);

(statearr_26408[(7)] = inst_26344);

(statearr_26408[(8)] = inst_26343);

(statearr_26408[(9)] = inst_26345);

return statearr_26408;
})();
var statearr_26409_26456 = state_26395__$1;
(statearr_26409_26456[(2)] = null);

(statearr_26409_26456[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (17))){
var inst_26344 = (state_26395[(7)]);
var inst_26352 = (state_26395[(12)]);
var inst_26343 = (state_26395[(8)]);
var inst_26345 = (state_26395[(9)]);
var inst_26351 = (state_26395[(11)]);
var inst_26360 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26344,inst_26351);
var tmp26405 = inst_26343;
var tmp26406 = inst_26345;
var inst_26342 = inst_26352;
var inst_26343__$1 = tmp26405;
var inst_26344__$1 = inst_26360;
var inst_26345__$1 = tmp26406;
var state_26395__$1 = (function (){var statearr_26410 = state_26395;
(statearr_26410[(13)] = inst_26342);

(statearr_26410[(7)] = inst_26344__$1);

(statearr_26410[(8)] = inst_26343__$1);

(statearr_26410[(9)] = inst_26345__$1);

return statearr_26410;
})();
var statearr_26411_26457 = state_26395__$1;
(statearr_26411_26457[(2)] = null);

(statearr_26411_26457[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (3))){
var inst_26393 = (state_26395[(2)]);
var state_26395__$1 = state_26395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26395__$1,inst_26393);
} else {
if((state_val_26396 === (12))){
var inst_26342 = (state_26395[(13)]);
var inst_26351 = (state_26395[(11)]);
var inst_26350 = cljs.core.seq(inst_26342);
var inst_26351__$1 = cljs.core.first(inst_26350);
var inst_26352 = cljs.core.next(inst_26350);
var state_26395__$1 = (function (){var statearr_26412 = state_26395;
(statearr_26412[(12)] = inst_26352);

(statearr_26412[(11)] = inst_26351__$1);

return statearr_26412;
})();
if(cljs.core.truth_(inst_26351__$1)){
var statearr_26413_26458 = state_26395__$1;
(statearr_26413_26458[(1)] = (14));

} else {
var statearr_26414_26459 = state_26395__$1;
(statearr_26414_26459[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (2))){
var _ = (function (){var statearr_26415 = state_26395;
(statearr_26415[(4)] = cljs.core.cons((5),(state_26395[(4)])));

return statearr_26415;
})();
var inst_26307 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26308 = (inst_26307 + (1));
var inst_26309 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_26308);
var state_26395__$1 = state_26395;
if(inst_26309){
var statearr_26416_26460 = state_26395__$1;
(statearr_26416_26460[(1)] = (6));

} else {
var statearr_26417_26461 = state_26395__$1;
(statearr_26417_26461[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (23))){
var inst_26351 = (state_26395[(11)]);
var inst_26368 = (state_26395[(2)]);
var inst_26369 = fluree.db.util.async.throw_err(inst_26368);
var inst_26370 = (inst_26351 == null);
var state_26395__$1 = (function (){var statearr_26418 = state_26395;
(statearr_26418[(10)] = inst_26369);

return statearr_26418;
})();
if(cljs.core.truth_(inst_26370)){
var statearr_26419_26462 = state_26395__$1;
(statearr_26419_26462[(1)] = (24));

} else {
var statearr_26420_26463 = state_26395__$1;
(statearr_26420_26463[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (19))){
var inst_26385 = (state_26395[(2)]);
var state_26395__$1 = state_26395;
var statearr_26421_26464 = state_26395__$1;
(statearr_26421_26464[(2)] = inst_26385);

(statearr_26421_26464[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (11))){
var inst_26390 = (state_26395[(2)]);
var _ = (function (){var statearr_26423 = state_26395;
(statearr_26423[(4)] = cljs.core.rest((state_26395[(4)])));

return statearr_26423;
})();
var state_26395__$1 = state_26395;
var statearr_26424_26465 = state_26395__$1;
(statearr_26424_26465[(2)] = inst_26390);

(statearr_26424_26465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (9))){
var inst_26324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26325 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_26324);
var state_26395__$1 = state_26395;
var statearr_26425_26466 = state_26395__$1;
(statearr_26425_26466[(2)] = inst_26325);

(statearr_26425_26466[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (5))){
var _ = (function (){var statearr_26426 = state_26395;
(statearr_26426[(4)] = cljs.core.rest((state_26395[(4)])));

return statearr_26426;
})();
var state_26395__$1 = state_26395;
var ex26422 = (state_26395__$1[(2)]);
var statearr_26427_26467 = state_26395__$1;
(statearr_26427_26467[(5)] = ex26422);


var statearr_26428_26468 = state_26395__$1;
(statearr_26428_26468[(1)] = (4));

(statearr_26428_26468[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (14))){
var inst_26343 = (state_26395[(8)]);
var inst_26351 = (state_26395[(11)]);
var inst_26354 = fluree.db.flake.t(inst_26351);
var inst_26355 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26343,inst_26354);
var state_26395__$1 = state_26395;
var statearr_26429_26469 = state_26395__$1;
(statearr_26429_26469[(2)] = inst_26355);

(statearr_26429_26469[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (26))){
var inst_26380 = (state_26395[(2)]);
var state_26395__$1 = state_26395;
var statearr_26430_26470 = state_26395__$1;
(statearr_26430_26470[(2)] = inst_26380);

(statearr_26430_26470[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (16))){
var inst_26358 = (state_26395[(2)]);
var state_26395__$1 = state_26395;
if(cljs.core.truth_(inst_26358)){
var statearr_26431_26471 = state_26395__$1;
(statearr_26431_26471[(1)] = (17));

} else {
var statearr_26432_26472 = state_26395__$1;
(statearr_26432_26472[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (10))){
var inst_26327 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_26335 = cljs.core.seq(inst_26327);
var inst_26336 = cljs.core.first(inst_26335);
var inst_26337 = cljs.core.next(inst_26335);
var inst_26338 = cljs.core.first(inst_26327);
var inst_26339 = fluree.db.flake.t(inst_26338);
var inst_26340 = cljs.core.PersistentVector.EMPTY;
var inst_26341 = db;
var inst_26342 = inst_26327;
var inst_26343 = inst_26339;
var inst_26344 = inst_26340;
var inst_26345 = inst_26341;
var state_26395__$1 = (function (){var statearr_26433 = state_26395;
(statearr_26433[(13)] = inst_26342);

(statearr_26433[(7)] = inst_26344);

(statearr_26433[(8)] = inst_26343);

(statearr_26433[(9)] = inst_26345);

(statearr_26433[(14)] = inst_26336);

(statearr_26433[(15)] = inst_26337);

return statearr_26433;
})();
var statearr_26434_26473 = state_26395__$1;
(statearr_26434_26473[(2)] = null);

(statearr_26434_26473[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (18))){
var state_26395__$1 = state_26395;
var statearr_26435_26474 = state_26395__$1;
(statearr_26435_26474[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26396 === (8))){
var inst_26321 = (state_26395[(2)]);
var inst_26322 = cljs.core.empty_QMARK_(flakes);
var state_26395__$1 = (function (){var statearr_26437 = state_26395;
(statearr_26437[(16)] = inst_26321);

return statearr_26437;
})();
if(inst_26322){
var statearr_26438_26475 = state_26395__$1;
(statearr_26438_26475[(1)] = (9));

} else {
var statearr_26439_26476 = state_26395__$1;
(statearr_26439_26476[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26440 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26440[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26440[(1)] = (1));

return statearr_26440;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26395){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26395);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26441){var ex__2687__auto__ = e26441;
var statearr_26442_26477 = state_26395;
(statearr_26442_26477[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26395[(4)]))){
var statearr_26443_26478 = state_26395;
(statearr_26443_26478[(1)] = cljs.core.first((state_26395[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26479 = state_26395;
state_26395 = G__26479;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26395){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26444 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26444[(6)] = c__2706__auto___26446);

return statearr_26444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26531){
var state_val_26532 = (state_26531[(1)]);
if((state_val_26532 === (7))){
var state_26531__$1 = state_26531;
var statearr_26533_26560 = state_26531__$1;
(statearr_26533_26560[(2)] = tt_id);

(statearr_26533_26560[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (1))){
var state_26531__$1 = state_26531;
var statearr_26534_26561 = state_26531__$1;
(statearr_26534_26561[(2)] = null);

(statearr_26534_26561[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (4))){
var inst_26480 = (state_26531[(2)]);
var state_26531__$1 = state_26531;
var statearr_26535_26562 = state_26531__$1;
(statearr_26535_26562[(2)] = inst_26480);

(statearr_26535_26562[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (13))){
var inst_26524 = (state_26531[(2)]);
var state_26531__$1 = state_26531;
var statearr_26536_26563 = state_26531__$1;
(statearr_26536_26563[(2)] = inst_26524);

(statearr_26536_26563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (6))){
var inst_26488 = cljs.core.random_uuid();
var state_26531__$1 = state_26531;
var statearr_26537_26564 = state_26531__$1;
(statearr_26537_26564[(2)] = inst_26488);

(statearr_26537_26564[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (3))){
var inst_26529 = (state_26531[(2)]);
var state_26531__$1 = state_26531;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26531__$1,inst_26529);
} else {
if((state_val_26532 === (12))){
var inst_26507 = (state_26531[(7)]);
var state_26531__$1 = state_26531;
var statearr_26538_26565 = state_26531__$1;
(statearr_26538_26565[(2)] = inst_26507);

(statearr_26538_26565[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (2))){
var _ = (function (){var statearr_26539 = state_26531;
(statearr_26539[(4)] = cljs.core.cons((5),(state_26531[(4)])));

return statearr_26539;
})();
var inst_26486 = (tt_id == null);
var state_26531__$1 = state_26531;
if(cljs.core.truth_(inst_26486)){
var statearr_26540_26566 = state_26531__$1;
(statearr_26540_26566[(1)] = (6));

} else {
var statearr_26541_26567 = state_26531__$1;
(statearr_26541_26567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (11))){
var inst_26514 = (state_26531[(8)]);
var inst_26507 = (state_26531[(7)]);
var inst_26517 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_26507,inst_26514);
var state_26531__$1 = state_26531;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26531__$1,(14),inst_26517);
} else {
if((state_val_26532 === (9))){
var inst_26514 = (state_26531[(8)]);
var inst_26508 = (state_26531[(9)]);
var inst_26513 = cljs.core.seq(inst_26508);
var inst_26514__$1 = cljs.core.first(inst_26513);
var inst_26515 = cljs.core.next(inst_26513);
var state_26531__$1 = (function (){var statearr_26543 = state_26531;
(statearr_26543[(10)] = inst_26515);

(statearr_26543[(8)] = inst_26514__$1);

return statearr_26543;
})();
if(cljs.core.truth_(inst_26514__$1)){
var statearr_26544_26568 = state_26531__$1;
(statearr_26544_26568[(1)] = (11));

} else {
var statearr_26545_26569 = state_26531__$1;
(statearr_26545_26569[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (5))){
var _ = (function (){var statearr_26546 = state_26531;
(statearr_26546[(4)] = cljs.core.rest((state_26531[(4)])));

return statearr_26546;
})();
var state_26531__$1 = state_26531;
var ex26542 = (state_26531__$1[(2)]);
var statearr_26547_26570 = state_26531__$1;
(statearr_26547_26570[(5)] = ex26542);


if((ex26542 instanceof Error)){
var statearr_26548_26571 = state_26531__$1;
(statearr_26548_26571[(1)] = (4));

(statearr_26548_26571[(5)] = null);

} else {
throw ex26542;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (14))){
var inst_26515 = (state_26531[(10)]);
var inst_26519 = (state_26531[(2)]);
var inst_26520 = fluree.db.util.async.throw_err(inst_26519);
var inst_26507 = inst_26520;
var inst_26508 = inst_26515;
var state_26531__$1 = (function (){var statearr_26549 = state_26531;
(statearr_26549[(7)] = inst_26507);

(statearr_26549[(9)] = inst_26508);

return statearr_26549;
})();
var statearr_26550_26572 = state_26531__$1;
(statearr_26550_26572[(2)] = null);

(statearr_26550_26572[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (10))){
var inst_26526 = (state_26531[(2)]);
var _ = (function (){var statearr_26551 = state_26531;
(statearr_26551[(4)] = cljs.core.rest((state_26531[(4)])));

return statearr_26551;
})();
var state_26531__$1 = state_26531;
var statearr_26552_26573 = state_26531__$1;
(statearr_26552_26573[(2)] = inst_26526);

(statearr_26552_26573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26532 === (8))){
var inst_26491 = (state_26531[(2)]);
var inst_26492 = (function (){var tt_id__$1 = inst_26491;
return (function (db_STAR_,idx){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(db_STAR_,idx,cljs.core.assoc,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id__$1);
});
})();
var inst_26493 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26491);
var inst_26494 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_26492,inst_26493,fluree.db.index.types);
var inst_26495 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(new cljs.core.Keyword(null,"t","t",-1397832519),fluree.db.flake.cmp_tx,flakes);
var inst_26496 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"t","t",-1397832519),inst_26495);
var inst_26504 = cljs.core.seq(inst_26496);
var inst_26505 = cljs.core.first(inst_26504);
var inst_26506 = cljs.core.next(inst_26504);
var inst_26507 = inst_26494;
var inst_26508 = inst_26496;
var state_26531__$1 = (function (){var statearr_26553 = state_26531;
(statearr_26553[(7)] = inst_26507);

(statearr_26553[(11)] = inst_26506);

(statearr_26553[(12)] = inst_26505);

(statearr_26553[(9)] = inst_26508);

return statearr_26553;
})();
var statearr_26554_26574 = state_26531__$1;
(statearr_26554_26574[(2)] = null);

(statearr_26554_26574[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0 = (function (){
var statearr_26555 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26555[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__);

(statearr_26555[(1)] = (1));

return statearr_26555;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1 = (function (state_26531){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26531);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26556){var ex__2687__auto__ = e26556;
var statearr_26557_26575 = state_26531;
(statearr_26557_26575[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26531[(4)]))){
var statearr_26558_26576 = state_26531;
(statearr_26558_26576[(1)] = cljs.core.first((state_26531[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26577 = state_26531;
state_26531 = G__26577;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__ = function(state_26531){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1.call(this,state_26531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26559 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26559[(6)] = c__2706__auto__);

return statearr_26559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___26764 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26695){
var state_val_26696 = (state_26695[(1)]);
if((state_val_26696 === (7))){
var inst_26605 = (state_26695[(7)]);
var inst_26605__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26695__$1 = (function (){var statearr_26697 = state_26695;
(statearr_26697[(7)] = inst_26605__$1);

return statearr_26697;
})();
if(inst_26605__$1){
var statearr_26698_26765 = state_26695__$1;
(statearr_26698_26765[(1)] = (13));

} else {
var statearr_26699_26766 = state_26695__$1;
(statearr_26699_26766[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (20))){
var state_26695__$1 = state_26695;
var statearr_26700_26767 = state_26695__$1;
(statearr_26700_26767[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (27))){
var inst_26641 = (state_26695[(8)]);
var inst_26645 = fluree.db.flake.s(inst_26641);
var state_26695__$1 = state_26695;
var statearr_26702_26768 = state_26695__$1;
(statearr_26702_26768[(2)] = inst_26645);

(statearr_26702_26768[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (1))){
var state_26695__$1 = state_26695;
var statearr_26703_26769 = state_26695__$1;
(statearr_26703_26769[(2)] = null);

(statearr_26703_26769[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (24))){
var inst_26635 = (state_26695[(9)]);
var inst_26639 = cljs.core.first(inst_26635);
var state_26695__$1 = state_26695;
var statearr_26704_26770 = state_26695__$1;
(statearr_26704_26770[(2)] = inst_26639);

(statearr_26704_26770[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (39))){
var state_26695__$1 = state_26695;
var statearr_26705_26771 = state_26695__$1;
(statearr_26705_26771[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (4))){
var inst_26578 = (state_26695[(2)]);
var inst_26579 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26580 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26581 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26582 = cljs.core.PersistentHashMap.fromArrays(inst_26580,inst_26581);
var inst_26583 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_26579,inst_26582,inst_26578);
var inst_26584 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26583);
var state_26695__$1 = state_26695;
var statearr_26707_26772 = state_26695__$1;
(statearr_26707_26772[(2)] = inst_26584);

(statearr_26707_26772[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (15))){
var inst_26612 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
if(cljs.core.truth_(inst_26612)){
var statearr_26708_26773 = state_26695__$1;
(statearr_26708_26773[(1)] = (16));

} else {
var statearr_26709_26774 = state_26695__$1;
(statearr_26709_26774[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (21))){
var inst_26661 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26710_26775 = state_26695__$1;
(statearr_26710_26775[(2)] = inst_26661);

(statearr_26710_26775[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (31))){
var inst_26659 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26711_26776 = state_26695__$1;
(statearr_26711_26776[(2)] = inst_26659);

(statearr_26711_26776[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (32))){
var inst_26665 = (state_26695[(10)]);
var inst_26667 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26665);
var state_26695__$1 = state_26695;
var statearr_26712_26777 = state_26695__$1;
(statearr_26712_26777[(2)] = inst_26667);

(statearr_26712_26777[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (40))){
var inst_26688 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26713_26778 = state_26695__$1;
(statearr_26713_26778[(2)] = inst_26688);

(statearr_26713_26778[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (33))){
var inst_26665 = (state_26695[(10)]);
var inst_26669 = (state_26695[(11)]);
var inst_26669__$1 = (inst_26665 == null);
var state_26695__$1 = (function (){var statearr_26714 = state_26695;
(statearr_26714[(11)] = inst_26669__$1);

return statearr_26714;
})();
if(cljs.core.truth_(inst_26669__$1)){
var statearr_26715_26779 = state_26695__$1;
(statearr_26715_26779[(1)] = (35));

} else {
var statearr_26716_26780 = state_26695__$1;
(statearr_26716_26780[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (13))){
var inst_26607 = cljs.core.first(ident);
var inst_26608 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26607);
var inst_26609 = (inst_26608 == null);
var state_26695__$1 = state_26695;
var statearr_26717_26781 = state_26695__$1;
(statearr_26717_26781[(2)] = inst_26609);

(statearr_26717_26781[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (22))){
var inst_26635 = (state_26695[(9)]);
var inst_26634 = (state_26695[(2)]);
var inst_26635__$1 = fluree.db.util.async.throw_err(inst_26634);
var inst_26636 = (inst_26635__$1 == null);
var state_26695__$1 = (function (){var statearr_26718 = state_26695;
(statearr_26718[(9)] = inst_26635__$1);

return statearr_26718;
})();
if(cljs.core.truth_(inst_26636)){
var statearr_26719_26782 = state_26695__$1;
(statearr_26719_26782[(1)] = (23));

} else {
var statearr_26720_26783 = state_26695__$1;
(statearr_26720_26783[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (36))){
var inst_26669 = (state_26695[(11)]);
var state_26695__$1 = state_26695;
var statearr_26721_26784 = state_26695__$1;
(statearr_26721_26784[(2)] = inst_26669);

(statearr_26721_26784[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (41))){
var inst_26683 = cljs.core.async.close_BANG_(return_chan);
var state_26695__$1 = state_26695;
var statearr_26722_26785 = state_26695__$1;
(statearr_26722_26785[(2)] = inst_26683);

(statearr_26722_26785[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (43))){
var inst_26686 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26723_26786 = state_26695__$1;
(statearr_26723_26786[(2)] = inst_26686);

(statearr_26723_26786[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (29))){
var inst_26650 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_26651 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_26650].join('');
var inst_26652 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26653 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26654 = cljs.core.PersistentHashMap.fromArrays(inst_26652,inst_26653);
var inst_26655 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26651,inst_26654);
var inst_26656 = (function(){throw inst_26655})();
var state_26695__$1 = state_26695;
var statearr_26724_26787 = state_26695__$1;
(statearr_26724_26787[(2)] = inst_26656);

(statearr_26724_26787[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (6))){
var inst_26592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26593 = [ident];
var inst_26594 = (new cljs.core.PersistentVector(null,1,(5),inst_26592,inst_26593,null));
var inst_26595 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26594);
var state_26695__$1 = state_26695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26695__$1,(9),inst_26595);
} else {
if((state_val_26696 === (28))){
var inst_26647 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26725_26788 = state_26695__$1;
(statearr_26725_26788[(2)] = inst_26647);

(statearr_26725_26788[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (25))){
var inst_26641 = (state_26695[(8)]);
var inst_26641__$1 = (state_26695[(2)]);
var inst_26642 = (inst_26641__$1 == null);
var state_26695__$1 = (function (){var statearr_26726 = state_26695;
(statearr_26726[(8)] = inst_26641__$1);

return statearr_26726;
})();
if(cljs.core.truth_(inst_26642)){
var statearr_26727_26789 = state_26695__$1;
(statearr_26727_26789[(1)] = (26));

} else {
var statearr_26728_26790 = state_26695__$1;
(statearr_26728_26790[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (34))){
var inst_26690 = (state_26695[(2)]);
var _ = (function (){var statearr_26729 = state_26695;
(statearr_26729[(4)] = cljs.core.rest((state_26695[(4)])));

return statearr_26729;
})();
var state_26695__$1 = state_26695;
var statearr_26730_26791 = state_26695__$1;
(statearr_26730_26791[(2)] = inst_26690);

(statearr_26730_26791[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (17))){
var inst_26623 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_26695__$1 = state_26695;
if(inst_26623){
var statearr_26731_26792 = state_26695__$1;
(statearr_26731_26792[(1)] = (19));

} else {
var statearr_26732_26793 = state_26695__$1;
(statearr_26732_26793[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (3))){
var inst_26693 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26695__$1,inst_26693);
} else {
if((state_val_26696 === (12))){
var inst_26603 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26733_26794 = state_26695__$1;
(statearr_26733_26794[(2)] = inst_26603);

(statearr_26733_26794[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (2))){
var _ = (function (){var statearr_26734 = state_26695;
(statearr_26734[(4)] = cljs.core.cons((5),(state_26695[(4)])));

return statearr_26734;
})();
var inst_26590 = typeof ident === 'number';
var state_26695__$1 = state_26695;
if(cljs.core.truth_(inst_26590)){
var statearr_26735_26795 = state_26695__$1;
(statearr_26735_26795[(1)] = (6));

} else {
var statearr_26736_26796 = state_26695__$1;
(statearr_26736_26796[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (23))){
var state_26695__$1 = state_26695;
var statearr_26737_26797 = state_26695__$1;
(statearr_26737_26797[(2)] = null);

(statearr_26737_26797[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (35))){
var state_26695__$1 = state_26695;
var statearr_26738_26798 = state_26695__$1;
(statearr_26738_26798[(2)] = strict_QMARK_);

(statearr_26738_26798[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (19))){
var inst_26626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26627 = cljs.core.first(ident);
var inst_26628 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26627);
var inst_26629 = cljs.core.second(ident);
var inst_26630 = [inst_26628,inst_26629];
var inst_26631 = (new cljs.core.PersistentVector(null,2,(5),inst_26626,inst_26630,null));
var inst_26632 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_26631);
var state_26695__$1 = state_26695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26695__$1,(22),inst_26632);
} else {
if((state_val_26696 === (11))){
var state_26695__$1 = state_26695;
var statearr_26740_26799 = state_26695__$1;
(statearr_26740_26799[(2)] = null);

(statearr_26740_26799[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (9))){
var inst_26597 = (state_26695[(2)]);
var inst_26598 = fluree.db.util.async.throw_err(inst_26597);
var inst_26599 = cljs.core.not_empty(inst_26598);
var state_26695__$1 = state_26695;
if(cljs.core.truth_(inst_26599)){
var statearr_26741_26800 = state_26695__$1;
(statearr_26741_26800[(1)] = (10));

} else {
var statearr_26742_26801 = state_26695__$1;
(statearr_26742_26801[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (5))){
var _ = (function (){var statearr_26743 = state_26695;
(statearr_26743[(4)] = cljs.core.rest((state_26695[(4)])));

return statearr_26743;
})();
var state_26695__$1 = state_26695;
var ex26739 = (state_26695__$1[(2)]);
var statearr_26744_26802 = state_26695__$1;
(statearr_26744_26802[(5)] = ex26739);


var statearr_26745_26803 = state_26695__$1;
(statearr_26745_26803[(1)] = (4));

(statearr_26745_26803[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (14))){
var inst_26605 = (state_26695[(7)]);
var state_26695__$1 = state_26695;
var statearr_26746_26804 = state_26695__$1;
(statearr_26746_26804[(2)] = inst_26605);

(statearr_26746_26804[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (26))){
var state_26695__$1 = state_26695;
var statearr_26747_26805 = state_26695__$1;
(statearr_26747_26805[(2)] = null);

(statearr_26747_26805[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (16))){
var inst_26614 = cljs.core.first(ident);
var inst_26615 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_26614], 0));
var inst_26616 = ["Subject ID lookup failed. The predicate ",inst_26615," does not exist."].join('');
var inst_26617 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26618 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26619 = cljs.core.PersistentHashMap.fromArrays(inst_26617,inst_26618);
var inst_26620 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26616,inst_26619);
var inst_26621 = (function(){throw inst_26620})();
var state_26695__$1 = state_26695;
var statearr_26748_26806 = state_26695__$1;
(statearr_26748_26806[(2)] = inst_26621);

(statearr_26748_26806[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (38))){
var inst_26675 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26676 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26677 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26678 = cljs.core.PersistentHashMap.fromArrays(inst_26676,inst_26677);
var inst_26679 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_26675,inst_26678);
var inst_26680 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_26679);
var state_26695__$1 = state_26695;
var statearr_26749_26807 = state_26695__$1;
(statearr_26749_26807[(2)] = inst_26680);

(statearr_26749_26807[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (30))){
var state_26695__$1 = state_26695;
var statearr_26750_26808 = state_26695__$1;
(statearr_26750_26808[(2)] = null);

(statearr_26750_26808[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (10))){
var state_26695__$1 = state_26695;
var statearr_26751_26809 = state_26695__$1;
(statearr_26751_26809[(2)] = ident);

(statearr_26751_26809[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (18))){
var inst_26663 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
var statearr_26752_26810 = state_26695__$1;
(statearr_26752_26810[(2)] = inst_26663);

(statearr_26752_26810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (42))){
var state_26695__$1 = state_26695;
var statearr_26753_26811 = state_26695__$1;
(statearr_26753_26811[(2)] = null);

(statearr_26753_26811[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (37))){
var inst_26673 = (state_26695[(2)]);
var state_26695__$1 = state_26695;
if(cljs.core.truth_(inst_26673)){
var statearr_26754_26812 = state_26695__$1;
(statearr_26754_26812[(1)] = (38));

} else {
var statearr_26755_26813 = state_26695__$1;
(statearr_26755_26813[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26696 === (8))){
var inst_26665 = (state_26695[(10)]);
var inst_26665__$1 = (state_26695[(2)]);
var state_26695__$1 = (function (){var statearr_26756 = state_26695;
(statearr_26756[(10)] = inst_26665__$1);

return statearr_26756;
})();
if(cljs.core.truth_(inst_26665__$1)){
var statearr_26757_26814 = state_26695__$1;
(statearr_26757_26814[(1)] = (32));

} else {
var statearr_26758_26815 = state_26695__$1;
(statearr_26758_26815[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2684__auto____0 = (function (){
var statearr_26759 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26759[(0)] = fluree$db$graphdb$subid_$_state_machine__2684__auto__);

(statearr_26759[(1)] = (1));

return statearr_26759;
});
var fluree$db$graphdb$subid_$_state_machine__2684__auto____1 = (function (state_26695){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26695);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26760){var ex__2687__auto__ = e26760;
var statearr_26761_26816 = state_26695;
(statearr_26761_26816[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26695[(4)]))){
var statearr_26762_26817 = state_26695;
(statearr_26762_26817[(1)] = cljs.core.first((state_26695[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26818 = state_26695;
state_26695 = G__26818;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2684__auto__ = function(state_26695){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2684__auto____1.call(this,state_26695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2684__auto____0;
fluree$db$graphdb$subid_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2684__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26763 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26763[(6)] = c__2706__auto___26764);

return statearr_26763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__26819){
var map__26820 = p__26819;
var map__26820__$1 = cljs.core.__destructure_map(map__26820);
var db = map__26820__$1;
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26820__$1,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26820__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26836){
var state_val_26837 = (state_26836[(1)]);
if((state_val_26837 === (1))){
var state_26836__$1 = state_26836;
var statearr_26838_26852 = state_26836__$1;
(statearr_26838_26852[(2)] = null);

(statearr_26838_26852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26837 === (2))){
var _ = (function (){var statearr_26839 = state_26836;
(statearr_26839[(4)] = cljs.core.cons((5),(state_26836[(4)])));

return statearr_26839;
})();
var inst_26827 = (current_db_fn.cljs$core$IFn$_invoke$arity$1 ? current_db_fn.cljs$core$IFn$_invoke$arity$1(db) : current_db_fn.call(null,db));
var state_26836__$1 = state_26836;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26836__$1,(6),inst_26827);
} else {
if((state_val_26837 === (3))){
var inst_26834 = (state_26836[(2)]);
var state_26836__$1 = state_26836;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26836__$1,inst_26834);
} else {
if((state_val_26837 === (4))){
var inst_26821 = (state_26836[(2)]);
var state_26836__$1 = state_26836;
var statearr_26841_26853 = state_26836__$1;
(statearr_26841_26853[(2)] = inst_26821);

(statearr_26841_26853[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26837 === (5))){
var _ = (function (){var statearr_26842 = state_26836;
(statearr_26842[(4)] = cljs.core.rest((state_26836[(4)])));

return statearr_26842;
})();
var state_26836__$1 = state_26836;
var ex26840 = (state_26836__$1[(2)]);
var statearr_26843_26854 = state_26836__$1;
(statearr_26843_26854[(5)] = ex26840);


if((ex26840 instanceof Error)){
var statearr_26844_26855 = state_26836__$1;
(statearr_26844_26855[(1)] = (4));

(statearr_26844_26855[(5)] = null);

} else {
throw ex26840;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26837 === (6))){
var inst_26829 = (state_26836[(2)]);
var inst_26830 = fluree.db.util.async.throw_err(inst_26829);
var inst_26831 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_26830,new cljs.core.Keyword(null,"permissions","permissions",67803075),permissions);
var _ = (function (){var statearr_26845 = state_26836;
(statearr_26845[(4)] = cljs.core.rest((state_26836[(4)])));

return statearr_26845;
})();
var state_26836__$1 = state_26836;
var statearr_26846_26856 = state_26836__$1;
(statearr_26846_26856[(2)] = inst_26831);

(statearr_26846_26856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0 = (function (){
var statearr_26847 = [null,null,null,null,null,null,null];
(statearr_26847[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__);

(statearr_26847[(1)] = (1));

return statearr_26847;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1 = (function (state_26836){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26836);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26848){var ex__2687__auto__ = e26848;
var statearr_26849_26857 = state_26836;
(statearr_26849_26857[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26836[(4)]))){
var statearr_26850_26858 = state_26836;
(statearr_26850_26858[(1)] = cljs.core.first((state_26836[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26859 = state_26836;
state_26836 = G__26859;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__ = function(state_26836){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1.call(this,state_26836);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26851 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26851[(6)] = c__2706__auto__);

return statearr_26851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__26860,property,collection){
var map__26861 = p__26860;
var map__26861__$1 = cljs.core.__destructure_map(map__26861);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26861__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26862 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"partition","partition",1174740751),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null);
return (fexpr__26862.cljs$core$IFn$_invoke$arity$1 ? fexpr__26862.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26862.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__26863,property,predicate){
var map__26864 = p__26863;
var map__26864__$1 = cljs.core.__destructure_map(map__26864);
var this$ = map__26864__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26864__$1,new cljs.core.Keyword(null,"schema","schema",-1582001791));
if(cljs.core.truth_((function (){var fexpr__26865 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null);
return (fexpr__26865.cljs$core$IFn$_invoke$arity$1 ? fexpr__26865.cljs$core$IFn$_invoke$arity$1(property) : fexpr__26865.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__26866 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return fluree.db.dbproto._c_prop(this$,new cljs.core.Keyword(null,"partition","partition",1174740751),G__26866);
} else {
return G__26866;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return new cljs.core.Keyword("fluree.db.graphdb","no-pred","fluree.db.graphdb/no-pred",1182779470);
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__26868 = arguments.length;
switch (G__26868) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26900){
var state_val_26901 = (state_26900[(1)]);
if((state_val_26901 === (7))){
var state_26900__$1 = state_26900;
var statearr_26902_26996 = state_26900__$1;
(statearr_26902_26996[(2)] = null);

(statearr_26902_26996[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (1))){
var state_26900__$1 = state_26900;
var statearr_26903_26997 = state_26900__$1;
(statearr_26903_26997[(2)] = null);

(statearr_26903_26997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (4))){
var inst_26869 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
var statearr_26904_26998 = state_26900__$1;
(statearr_26904_26998[(2)] = inst_26869);

(statearr_26904_26998[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (6))){
var inst_26883 = (state_26900[(7)]);
var inst_26882 = (state_26900[(2)]);
var inst_26883__$1 = fluree.db.util.async.throw_err(inst_26882);
var inst_26884 = (inst_26883__$1 == null);
var state_26900__$1 = (function (){var statearr_26905 = state_26900;
(statearr_26905[(7)] = inst_26883__$1);

return statearr_26905;
})();
if(cljs.core.truth_(inst_26884)){
var statearr_26906_26999 = state_26900__$1;
(statearr_26906_26999[(1)] = (7));

} else {
var statearr_26907_27000 = state_26900__$1;
(statearr_26907_27000[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (3))){
var inst_26898 = (state_26900[(2)]);
var state_26900__$1 = state_26900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26900__$1,inst_26898);
} else {
if((state_val_26901 === (12))){
var inst_26895 = (state_26900[(2)]);
var _ = (function (){var statearr_26908 = state_26900;
(statearr_26908[(4)] = cljs.core.rest((state_26900[(4)])));

return statearr_26908;
})();
var state_26900__$1 = state_26900;
var statearr_26909_27001 = state_26900__$1;
(statearr_26909_27001[(2)] = inst_26895);

(statearr_26909_27001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (2))){
var _ = (function (){var statearr_26910 = state_26900;
(statearr_26910[(4)] = cljs.core.cons((5),(state_26900[(4)])));

return statearr_26910;
})();
var inst_26876 = fluree.db.dbproto._rootdb(this$);
var inst_26877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26878 = [tag_id,(30)];
var inst_26879 = (new cljs.core.PersistentVector(null,2,(5),inst_26877,inst_26878,null));
var inst_26880 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_26876,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26879);
var state_26900__$1 = state_26900;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26900__$1,(6),inst_26880);
} else {
if((state_val_26901 === (11))){
var inst_26889 = (state_26900[(8)]);
var inst_26893 = fluree.db.flake.o(inst_26889);
var state_26900__$1 = state_26900;
var statearr_26912_27002 = state_26900__$1;
(statearr_26912_27002[(2)] = inst_26893);

(statearr_26912_27002[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (9))){
var inst_26889 = (state_26900[(8)]);
var inst_26889__$1 = (state_26900[(2)]);
var inst_26890 = (inst_26889__$1 == null);
var state_26900__$1 = (function (){var statearr_26913 = state_26900;
(statearr_26913[(8)] = inst_26889__$1);

return statearr_26913;
})();
if(cljs.core.truth_(inst_26890)){
var statearr_26914_27003 = state_26900__$1;
(statearr_26914_27003[(1)] = (10));

} else {
var statearr_26915_27004 = state_26900__$1;
(statearr_26915_27004[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (5))){
var _ = (function (){var statearr_26916 = state_26900;
(statearr_26916[(4)] = cljs.core.rest((state_26900[(4)])));

return statearr_26916;
})();
var state_26900__$1 = state_26900;
var ex26911 = (state_26900__$1[(2)]);
var statearr_26917_27005 = state_26900__$1;
(statearr_26917_27005[(5)] = ex26911);


if((ex26911 instanceof Error)){
var statearr_26918_27006 = state_26900__$1;
(statearr_26918_27006[(1)] = (4));

(statearr_26918_27006[(5)] = null);

} else {
throw ex26911;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (10))){
var state_26900__$1 = state_26900;
var statearr_26919_27007 = state_26900__$1;
(statearr_26919_27007[(2)] = null);

(statearr_26919_27007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26901 === (8))){
var inst_26883 = (state_26900[(7)]);
var inst_26887 = cljs.core.first(inst_26883);
var state_26900__$1 = state_26900;
var statearr_26920_27008 = state_26900__$1;
(statearr_26920_27008[(2)] = inst_26887);

(statearr_26920_27008[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26921 = [null,null,null,null,null,null,null,null,null];
(statearr_26921[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26921[(1)] = (1));

return statearr_26921;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26900){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26900);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26922){var ex__2687__auto__ = e26922;
var statearr_26923_27009 = state_26900;
(statearr_26923_27009[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26900[(4)]))){
var statearr_26924_27010 = state_26900;
(statearr_26924_27010[(1)] = cljs.core.first((state_26900[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27011 = state_26900;
state_26900 = G__27011;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26900){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26925 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26925[(6)] = c__2706__auto__);

return statearr_26925;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_26961){
var state_val_26962 = (state_26961[(1)]);
if((state_val_26962 === (7))){
var inst_26935 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_26961__$1 = state_26961;
var statearr_26963_27012 = state_26961__$1;
(statearr_26963_27012[(2)] = inst_26935);

(statearr_26963_27012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (1))){
var state_26961__$1 = state_26961;
var statearr_26964_27013 = state_26961__$1;
(statearr_26964_27013[(2)] = null);

(statearr_26964_27013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (4))){
var inst_26926 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
var statearr_26965_27014 = state_26961__$1;
(statearr_26965_27014[(2)] = inst_26926);

(statearr_26965_27014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (15))){
var inst_26956 = (state_26961[(2)]);
var _ = (function (){var statearr_26966 = state_26961;
(statearr_26966[(4)] = cljs.core.rest((state_26961[(4)])));

return statearr_26966;
})();
var state_26961__$1 = state_26961;
var statearr_26967_27015 = state_26961__$1;
(statearr_26967_27015[(2)] = inst_26956);

(statearr_26967_27015[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (13))){
var inst_26941 = (state_26961[(7)]);
var inst_26947 = clojure.string.includes_QMARK_(inst_26941,":");
var state_26961__$1 = state_26961;
if(inst_26947){
var statearr_26968_27016 = state_26961__$1;
(statearr_26968_27016[(1)] = (16));

} else {
var statearr_26969_27017 = state_26961__$1;
(statearr_26969_27017[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (6))){
var state_26961__$1 = state_26961;
var statearr_26970_27018 = state_26961__$1;
(statearr_26970_27018[(2)] = pred);

(statearr_26970_27018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (17))){
var inst_26941 = (state_26961[(7)]);
var state_26961__$1 = state_26961;
var statearr_26971_27019 = state_26961__$1;
(statearr_26971_27019[(2)] = inst_26941);

(statearr_26971_27019[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (3))){
var inst_26959 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26961__$1,inst_26959);
} else {
if((state_val_26962 === (12))){
var inst_26945 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
if(cljs.core.truth_(inst_26945)){
var statearr_26972_27020 = state_26961__$1;
(statearr_26972_27020[(1)] = (13));

} else {
var statearr_26973_27021 = state_26961__$1;
(statearr_26973_27021[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (2))){
var _ = (function (){var statearr_26974 = state_26961;
(statearr_26974[(4)] = cljs.core.cons((5),(state_26961[(4)])));

return statearr_26974;
})();
var inst_26932 = typeof pred === 'string';
var state_26961__$1 = state_26961;
if(cljs.core.truth_(inst_26932)){
var statearr_26975_27022 = state_26961__$1;
(statearr_26975_27022[(1)] = (6));

} else {
var statearr_26976_27023 = state_26961__$1;
(statearr_26976_27023[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (11))){
var inst_26937 = (state_26961[(8)]);
var state_26961__$1 = state_26961;
var statearr_26978_27024 = state_26961__$1;
(statearr_26978_27024[(2)] = inst_26937);

(statearr_26978_27024[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (9))){
var inst_26937 = (state_26961[(8)]);
var inst_26940 = (state_26961[(2)]);
var inst_26941 = fluree.db.util.async.throw_err(inst_26940);
var state_26961__$1 = (function (){var statearr_26979 = state_26961;
(statearr_26979[(7)] = inst_26941);

return statearr_26979;
})();
if(cljs.core.truth_(inst_26937)){
var statearr_26980_27025 = state_26961__$1;
(statearr_26980_27025[(1)] = (10));

} else {
var statearr_26981_27026 = state_26961__$1;
(statearr_26981_27026[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (5))){
var _ = (function (){var statearr_26982 = state_26961;
(statearr_26982[(4)] = cljs.core.rest((state_26961[(4)])));

return statearr_26982;
})();
var state_26961__$1 = state_26961;
var ex26977 = (state_26961__$1[(2)]);
var statearr_26983_27027 = state_26961__$1;
(statearr_26983_27027[(5)] = ex26977);


if((ex26977 instanceof Error)){
var statearr_26984_27028 = state_26961__$1;
(statearr_26984_27028[(1)] = (4));

(statearr_26984_27028[(5)] = null);

} else {
throw ex26977;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (14))){
var state_26961__$1 = state_26961;
var statearr_26985_27029 = state_26961__$1;
(statearr_26985_27029[(2)] = null);

(statearr_26985_27029[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (16))){
var inst_26941 = (state_26961[(7)]);
var inst_26949 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_26941,/:/);
var inst_26950 = cljs.core.second(inst_26949);
var state_26961__$1 = state_26961;
var statearr_26986_27030 = state_26961__$1;
(statearr_26986_27030[(2)] = inst_26950);

(statearr_26986_27030[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (10))){
var inst_26941 = (state_26961[(7)]);
var state_26961__$1 = state_26961;
var statearr_26987_27031 = state_26961__$1;
(statearr_26987_27031[(2)] = inst_26941);

(statearr_26987_27031[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (18))){
var inst_26953 = (state_26961[(2)]);
var state_26961__$1 = state_26961;
var statearr_26988_27032 = state_26961__$1;
(statearr_26988_27032[(2)] = inst_26953);

(statearr_26988_27032[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26962 === (8))){
var inst_26937 = (state_26961[(2)]);
var inst_26938 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_26961__$1 = (function (){var statearr_26989 = state_26961;
(statearr_26989[(8)] = inst_26937);

return statearr_26989;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26961__$1,(9),inst_26938);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_26990 = [null,null,null,null,null,null,null,null,null];
(statearr_26990[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_26990[(1)] = (1));

return statearr_26990;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_26961){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_26961);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e26991){var ex__2687__auto__ = e26991;
var statearr_26992_27033 = state_26961;
(statearr_26992_27033[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_26961[(4)]))){
var statearr_26993_27034 = state_26961;
(statearr_26993_27034[(1)] = cljs.core.first((state_26961[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27035 = state_26961;
state_26961 = G__27035;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_26961){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_26961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_26994 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_26994[(6)] = c__2706__auto__);

return statearr_26994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__27037 = arguments.length;
switch (G__27037) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27070){
var state_val_27071 = (state_27070[(1)]);
if((state_val_27071 === (7))){
var state_27070__$1 = state_27070;
var statearr_27072_27160 = state_27070__$1;
(statearr_27072_27160[(2)] = null);

(statearr_27072_27160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (1))){
var state_27070__$1 = state_27070;
var statearr_27073_27161 = state_27070__$1;
(statearr_27073_27161[(2)] = null);

(statearr_27073_27161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (4))){
var inst_27038 = (state_27070[(2)]);
var state_27070__$1 = state_27070;
var statearr_27074_27162 = state_27070__$1;
(statearr_27074_27162[(2)] = inst_27038);

(statearr_27074_27162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (6))){
var inst_27053 = (state_27070[(7)]);
var inst_27052 = (state_27070[(2)]);
var inst_27053__$1 = fluree.db.util.async.throw_err(inst_27052);
var inst_27054 = (inst_27053__$1 == null);
var state_27070__$1 = (function (){var statearr_27075 = state_27070;
(statearr_27075[(7)] = inst_27053__$1);

return statearr_27075;
})();
if(cljs.core.truth_(inst_27054)){
var statearr_27076_27163 = state_27070__$1;
(statearr_27076_27163[(1)] = (7));

} else {
var statearr_27077_27164 = state_27070__$1;
(statearr_27077_27164[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (3))){
var inst_27068 = (state_27070[(2)]);
var state_27070__$1 = state_27070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27070__$1,inst_27068);
} else {
if((state_val_27071 === (12))){
var inst_27065 = (state_27070[(2)]);
var _ = (function (){var statearr_27078 = state_27070;
(statearr_27078[(4)] = cljs.core.rest((state_27070[(4)])));

return statearr_27078;
})();
var state_27070__$1 = state_27070;
var statearr_27079_27165 = state_27070__$1;
(statearr_27079_27165[(2)] = inst_27065);

(statearr_27079_27165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (2))){
var _ = (function (){var statearr_27080 = state_27070;
(statearr_27080[(4)] = cljs.core.cons((5),(state_27070[(4)])));

return statearr_27080;
})();
var inst_27044 = (30);
var inst_27046 = fluree.db.dbproto._rootdb(this$);
var inst_27047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27048 = [inst_27044,tag_name];
var inst_27049 = (new cljs.core.PersistentVector(null,2,(5),inst_27047,inst_27048,null));
var inst_27050 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_27046,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27049);
var state_27070__$1 = state_27070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27070__$1,(6),inst_27050);
} else {
if((state_val_27071 === (11))){
var inst_27059 = (state_27070[(8)]);
var inst_27063 = fluree.db.flake.s(inst_27059);
var state_27070__$1 = state_27070;
var statearr_27082_27166 = state_27070__$1;
(statearr_27082_27166[(2)] = inst_27063);

(statearr_27082_27166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (9))){
var inst_27059 = (state_27070[(8)]);
var inst_27059__$1 = (state_27070[(2)]);
var inst_27060 = (inst_27059__$1 == null);
var state_27070__$1 = (function (){var statearr_27083 = state_27070;
(statearr_27083[(8)] = inst_27059__$1);

return statearr_27083;
})();
if(cljs.core.truth_(inst_27060)){
var statearr_27084_27167 = state_27070__$1;
(statearr_27084_27167[(1)] = (10));

} else {
var statearr_27085_27168 = state_27070__$1;
(statearr_27085_27168[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (5))){
var _ = (function (){var statearr_27086 = state_27070;
(statearr_27086[(4)] = cljs.core.rest((state_27070[(4)])));

return statearr_27086;
})();
var state_27070__$1 = state_27070;
var ex27081 = (state_27070__$1[(2)]);
var statearr_27087_27169 = state_27070__$1;
(statearr_27087_27169[(5)] = ex27081);


if((ex27081 instanceof Error)){
var statearr_27088_27170 = state_27070__$1;
(statearr_27088_27170[(1)] = (4));

(statearr_27088_27170[(5)] = null);

} else {
throw ex27081;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (10))){
var state_27070__$1 = state_27070;
var statearr_27089_27171 = state_27070__$1;
(statearr_27089_27171[(2)] = null);

(statearr_27089_27171[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27071 === (8))){
var inst_27053 = (state_27070[(7)]);
var inst_27057 = cljs.core.first(inst_27053);
var state_27070__$1 = state_27070;
var statearr_27090_27172 = state_27070__$1;
(statearr_27090_27172[(2)] = inst_27057);

(statearr_27090_27172[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27091 = [null,null,null,null,null,null,null,null,null];
(statearr_27091[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27091[(1)] = (1));

return statearr_27091;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27070){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27070);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27092){var ex__2687__auto__ = e27092;
var statearr_27093_27173 = state_27070;
(statearr_27093_27173[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27070[(4)]))){
var statearr_27094_27174 = state_27070;
(statearr_27094_27174[(1)] = cljs.core.first((state_27070[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27175 = state_27070;
state_27070 = G__27175;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27070){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27095 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27095[(6)] = c__2706__auto__);

return statearr_27095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_27130){
var state_val_27131 = (state_27130[(1)]);
if((state_val_27131 === (7))){
var inst_27109 = typeof pred === 'string';
var state_27130__$1 = state_27130;
if(cljs.core.truth_(inst_27109)){
var statearr_27132_27176 = state_27130__$1;
(statearr_27132_27176[(1)] = (10));

} else {
var statearr_27133_27177 = state_27130__$1;
(statearr_27133_27177[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (1))){
var state_27130__$1 = state_27130;
var statearr_27134_27178 = state_27130__$1;
(statearr_27134_27178[(2)] = null);

(statearr_27134_27178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (4))){
var inst_27096 = (state_27130[(2)]);
var state_27130__$1 = state_27130;
var statearr_27135_27179 = state_27130__$1;
(statearr_27135_27179[(2)] = inst_27096);

(statearr_27135_27179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (15))){
var inst_27123 = (state_27130[(2)]);
var state_27130__$1 = state_27130;
var statearr_27136_27180 = state_27130__$1;
(statearr_27136_27180[(2)] = inst_27123);

(statearr_27136_27180[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (13))){
var inst_27114 = (state_27130[(7)]);
var inst_27116 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27114),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27117 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_27116);
var state_27130__$1 = state_27130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27130__$1,(16),inst_27117);
} else {
if((state_val_27131 === (6))){
var inst_27104 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_27130__$1 = state_27130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27130__$1,(9),inst_27104);
} else {
if((state_val_27131 === (3))){
var inst_27128 = (state_27130[(2)]);
var state_27130__$1 = state_27130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27130__$1,inst_27128);
} else {
if((state_val_27131 === (12))){
var inst_27114 = (state_27130[(7)]);
var inst_27114__$1 = (state_27130[(2)]);
var state_27130__$1 = (function (){var statearr_27137 = state_27130;
(statearr_27137[(7)] = inst_27114__$1);

return statearr_27137;
})();
if(cljs.core.truth_(inst_27114__$1)){
var statearr_27138_27181 = state_27130__$1;
(statearr_27138_27181[(1)] = (13));

} else {
var statearr_27139_27182 = state_27130__$1;
(statearr_27139_27182[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (2))){
var _ = (function (){var statearr_27140 = state_27130;
(statearr_27140[(4)] = cljs.core.cons((5),(state_27130[(4)])));

return statearr_27140;
})();
var inst_27102 = clojure.string.includes_QMARK_(tag_name,"/");
var state_27130__$1 = state_27130;
if(inst_27102){
var statearr_27141_27183 = state_27130__$1;
(statearr_27141_27183[(1)] = (6));

} else {
var statearr_27142_27184 = state_27130__$1;
(statearr_27142_27184[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (11))){
var inst_27112 = fluree.db.dbproto._p_prop(this$,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27130__$1 = state_27130;
var statearr_27144_27185 = state_27130__$1;
(statearr_27144_27185[(2)] = inst_27112);

(statearr_27144_27185[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (9))){
var inst_27106 = (state_27130[(2)]);
var inst_27107 = fluree.db.util.async.throw_err(inst_27106);
var state_27130__$1 = state_27130;
var statearr_27145_27186 = state_27130__$1;
(statearr_27145_27186[(2)] = inst_27107);

(statearr_27145_27186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (5))){
var _ = (function (){var statearr_27146 = state_27130;
(statearr_27146[(4)] = cljs.core.rest((state_27130[(4)])));

return statearr_27146;
})();
var state_27130__$1 = state_27130;
var ex27143 = (state_27130__$1[(2)]);
var statearr_27147_27187 = state_27130__$1;
(statearr_27147_27187[(5)] = ex27143);


if((ex27143 instanceof Error)){
var statearr_27148_27188 = state_27130__$1;
(statearr_27148_27188[(1)] = (4));

(statearr_27148_27188[(5)] = null);

} else {
throw ex27143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (14))){
var state_27130__$1 = state_27130;
var statearr_27149_27189 = state_27130__$1;
(statearr_27149_27189[(2)] = null);

(statearr_27149_27189[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (16))){
var inst_27119 = (state_27130[(2)]);
var inst_27120 = fluree.db.util.async.throw_err(inst_27119);
var state_27130__$1 = state_27130;
var statearr_27150_27190 = state_27130__$1;
(statearr_27150_27190[(2)] = inst_27120);

(statearr_27150_27190[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (10))){
var state_27130__$1 = state_27130;
var statearr_27151_27191 = state_27130__$1;
(statearr_27151_27191[(2)] = pred);

(statearr_27151_27191[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27131 === (8))){
var inst_27125 = (state_27130[(2)]);
var _ = (function (){var statearr_27152 = state_27130;
(statearr_27152[(4)] = cljs.core.rest((state_27130[(4)])));

return statearr_27152;
})();
var state_27130__$1 = state_27130;
var statearr_27153_27192 = state_27130__$1;
(statearr_27153_27192[(2)] = inst_27125);

(statearr_27153_27192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2684__auto__ = null;
var fluree$db$graphdb$state_machine__2684__auto____0 = (function (){
var statearr_27154 = [null,null,null,null,null,null,null,null];
(statearr_27154[(0)] = fluree$db$graphdb$state_machine__2684__auto__);

(statearr_27154[(1)] = (1));

return statearr_27154;
});
var fluree$db$graphdb$state_machine__2684__auto____1 = (function (state_27130){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_27130);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e27155){var ex__2687__auto__ = e27155;
var statearr_27156_27193 = state_27130;
(statearr_27156_27193[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_27130[(4)]))){
var statearr_27157_27194 = state_27130;
(statearr_27157_27194[(1)] = cljs.core.first((state_27130[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27195 = state_27130;
state_27130 = G__27195;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2684__auto__ = function(state_27130){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2684__auto____1.call(this,state_27130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2684__auto____0;
fluree$db$graphdb$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2684__auto____1;
return fluree$db$graphdb$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_27158 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_27158[(6)] = c__2706__auto__);

return statearr_27158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.tspo = tspo;
this.schema = schema;
this.settings = settings;
this.comparators = comparators;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k27197,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__27201 = k27197;
var G__27201__$1 = (((G__27201 instanceof cljs.core.Keyword))?G__27201.fqn:null);
switch (G__27201__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "tspo":
return self__.tspo;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "comparators":
return self__.comparators;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k27197,else__5346__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__27202){
var vec__27203 = p__27202;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27203,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27203,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27196){
var self__ = this;
var G__27196__$1 = this;
return (new cljs.core.RecordIter((0),G__27196__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__27206 = (function (coll__5340__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__27206(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27198,other27199){
var self__ = this;
var this27198__$1 = this;
return (((!((other27199 == null)))) && ((((this27198__$1.constructor === other27199.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.conn,other27199.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.network,other27199.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.ledger_id,other27199.ledger_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.block,other27199.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.t,other27199.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.tt_id,other27199.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.stats,other27199.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.spot,other27199.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.psot,other27199.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.post,other27199.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.opst,other27199.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.tspo,other27199.tspo)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.schema,other27199.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.settings,other27199.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.comparators,other27199.comparators)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.schema_cache,other27199.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.novelty,other27199.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.permissions,other27199.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.fork,other27199.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.fork_block,other27199.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.current_db_fn,other27199.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this27198__$1.__extmap,other27199.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"tspo","tspo",-440144953),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"comparators","comparators",-1325611955),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k27197){
var self__ = this;
var this__5350__auto____$1 = this;
var G__27207 = k27197;
var G__27207__$1 = (((G__27207 instanceof cljs.core.Keyword))?G__27207.fqn:null);
switch (G__27207__$1) {
case "conn":
case "network":
case "ledger-id":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "tspo":
case "schema":
case "settings":
case "comparators":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k27197);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__27196){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__27208 = cljs.core.keyword_identical_QMARK_;
var expr__27209 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__27211 = new cljs.core.Keyword(null,"conn","conn",278309663);
var G__27212 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27211,G__27212) : pred__27208.call(null,G__27211,G__27212));
})())){
return (new fluree.db.graphdb.GraphDb(G__27196,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27213 = new cljs.core.Keyword(null,"network","network",2050004697);
var G__27214 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27213,G__27214) : pred__27208.call(null,G__27213,G__27214));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27196,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27215 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015);
var G__27216 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27215,G__27216) : pred__27208.call(null,G__27215,G__27216));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27196,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27217 = new cljs.core.Keyword(null,"block","block",664686210);
var G__27218 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27217,G__27218) : pred__27208.call(null,G__27217,G__27218));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,G__27196,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27219 = new cljs.core.Keyword(null,"t","t",-1397832519);
var G__27220 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27219,G__27220) : pred__27208.call(null,G__27219,G__27220));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,G__27196,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27221 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484);
var G__27222 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27221,G__27222) : pred__27208.call(null,G__27221,G__27222));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,G__27196,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27223 = new cljs.core.Keyword(null,"stats","stats",-85643011);
var G__27224 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27223,G__27224) : pred__27208.call(null,G__27223,G__27224));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,G__27196,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27225 = new cljs.core.Keyword(null,"spot","spot",-1706962147);
var G__27226 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27225,G__27226) : pred__27208.call(null,G__27225,G__27226));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,G__27196,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27227 = new cljs.core.Keyword(null,"psot","psot",2111653059);
var G__27228 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27227,G__27228) : pred__27208.call(null,G__27227,G__27228));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27196,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27229 = new cljs.core.Keyword(null,"post","post",269697687);
var G__27230 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27229,G__27230) : pred__27208.call(null,G__27229,G__27230));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27196,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27231 = new cljs.core.Keyword(null,"opst","opst",1213963058);
var G__27232 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27231,G__27232) : pred__27208.call(null,G__27231,G__27232));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27196,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27233 = new cljs.core.Keyword(null,"tspo","tspo",-440144953);
var G__27234 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27233,G__27234) : pred__27208.call(null,G__27233,G__27234));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27196,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27235 = new cljs.core.Keyword(null,"schema","schema",-1582001791);
var G__27236 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27235,G__27236) : pred__27208.call(null,G__27235,G__27236));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,G__27196,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27237 = new cljs.core.Keyword(null,"settings","settings",1556144875);
var G__27238 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27237,G__27238) : pred__27208.call(null,G__27237,G__27238));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,G__27196,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27239 = new cljs.core.Keyword(null,"comparators","comparators",-1325611955);
var G__27240 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27239,G__27240) : pred__27208.call(null,G__27239,G__27240));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,G__27196,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27241 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225);
var G__27242 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27241,G__27242) : pred__27208.call(null,G__27241,G__27242));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,G__27196,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27243 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__27244 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27243,G__27244) : pred__27208.call(null,G__27243,G__27244));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,G__27196,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27245 = new cljs.core.Keyword(null,"permissions","permissions",67803075);
var G__27246 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27245,G__27246) : pred__27208.call(null,G__27245,G__27246));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,G__27196,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27247 = new cljs.core.Keyword(null,"fork","fork",1062974235);
var G__27248 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27247,G__27248) : pred__27208.call(null,G__27247,G__27248));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,G__27196,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27249 = new cljs.core.Keyword(null,"fork-block","fork-block",178387923);
var G__27250 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27249,G__27250) : pred__27208.call(null,G__27249,G__27250));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27196,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__27251 = new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336);
var G__27252 = expr__27209;
return (pred__27208.cljs$core$IFn$_invoke$arity$2 ? pred__27208.cljs$core$IFn$_invoke$arity$2(G__27251,G__27252) : pred__27208.call(null,G__27251,G__27252));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27196,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__27196),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tspo","tspo",-440144953),self__.tspo,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparators","comparators",-1325611955),self__.comparators,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__27196){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.ledger_id,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.tspo,self__.schema,self__.settings,self__.comparators,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27196,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"tspo","tspo",1200386574,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"comparators","comparators",314919572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,ledger_id,block,t,tt_id,stats,spot,psot,post,opst,tspo,schema,settings,comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27200){
var extmap__5385__auto__ = (function (){var G__27253 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__27200,new cljs.core.Keyword(null,"conn","conn",278309663),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"tspo","tspo",-440144953),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"comparators","comparators",-1325611955),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], 0));
if(cljs.core.record_QMARK_(G__27200)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__27253);
} else {
return G__27253;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"tspo","tspo",-440144953).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"comparators","comparators",-1325611955).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27200),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27200),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),db__$1.ledger_id,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(comparators){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,clojure.data.avl.sorted_set_by(cljs.core.get.cljs$core$IFn$_invoke$arity$2(comparators,idx)));
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),fluree.db.index.types);
});
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,ledger_id,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(ledger_id)){
} else {
throw (new Error(["Assert failed: ","No ledger-id provided when creating new db.","\n","ledger-id"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.index.default_comparators);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var map__27256 = fluree.db.index.default_comparators;
var map__27256__$1 = cljs.core.__destructure_map(map__27256);
var spot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27256__$1,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27256__$1,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27256__$1,new cljs.core.Keyword(null,"post","post",269697687));
var opst_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27256__$1,new cljs.core.Keyword(null,"opst","opst",1213963058));
var tspo_cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27256__$1,new cljs.core.Keyword(null,"tspo","tspo",-440144953));
var spot = fluree.db.index.empty_branch(network,ledger_id,spot_cmp);
var psot = fluree.db.index.empty_branch(network,ledger_id,psot_cmp);
var post = fluree.db.index.empty_branch(network,ledger_id,post_cmp);
var opst = fluree.db.index.empty_branch(network,ledger_id,opst_cmp);
var tspo = fluree.db.index.empty_branch(network,ledger_id,tspo_cmp);
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,ledger_id,(0),(-1),null,stats,spot,psot,post,opst,tspo,schema,settings,fluree.db.index.default_comparators,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
