// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__69305 = arguments.length;
switch (G__69305) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69350){
var state_val_69351 = (state_69350[(1)]);
if((state_val_69351 === (7))){
var inst_69320 = typeof user === 'string';
var state_69350__$1 = state_69350;
if(cljs.core.truth_(inst_69320)){
var statearr_69352_69381 = state_69350__$1;
(statearr_69352_69381[(1)] = (9));

} else {
var statearr_69353_69382 = state_69350__$1;
(statearr_69353_69382[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (1))){
var state_69350__$1 = state_69350;
var statearr_69354_69383 = state_69350__$1;
(statearr_69354_69383[(2)] = null);

(statearr_69354_69383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (4))){
var inst_69306 = (state_69350[(2)]);
var inst_69307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69308 = [inst_69306];
var inst_69309 = (new cljs.core.PersistentVector(null,1,(5),inst_69307,inst_69308,null));
var inst_69310 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69309);
var inst_69311 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69306) : reject.call(null,inst_69306));
var state_69350__$1 = (function (){var statearr_69355 = state_69350;
(statearr_69355[(7)] = inst_69310);

return statearr_69355;
})();
var statearr_69356_69384 = state_69350__$1;
(statearr_69356_69384[(2)] = inst_69311);

(statearr_69356_69384[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (15))){
var inst_69339 = (state_69350[(2)]);
var inst_69340 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_69339);
var inst_69341 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69342 = cljs.core.constantly(inst_69340);
var inst_69343 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69341,inst_69342);
var inst_69344 = fluree.db.connection.add_token(conn,inst_69340);
var inst_69345 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_69339) : resolve.call(null,inst_69339));
var _ = (function (){var statearr_69357 = state_69350;
(statearr_69357[(4)] = cljs.core.rest((state_69350[(4)])));

return statearr_69357;
})();
var state_69350__$1 = (function (){var statearr_69358 = state_69350;
(statearr_69358[(8)] = inst_69344);

(statearr_69358[(9)] = inst_69343);

return statearr_69358;
})();
var statearr_69359_69385 = state_69350__$1;
(statearr_69359_69385[(2)] = inst_69345);

(statearr_69359_69385[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (13))){
var state_69350__$1 = state_69350;
var statearr_69360_69386 = state_69350__$1;
(statearr_69360_69386[(2)] = null);

(statearr_69360_69386[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (6))){
var state_69350__$1 = state_69350;
var statearr_69361_69387 = state_69350__$1;
(statearr_69361_69387[(2)] = user);

(statearr_69361_69387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (3))){
var inst_69348 = (state_69350[(2)]);
var state_69350__$1 = state_69350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69350__$1,inst_69348);
} else {
if((state_val_69351 === (12))){
var state_69350__$1 = state_69350;
var statearr_69362_69388 = state_69350__$1;
(statearr_69362_69388[(2)] = user);

(statearr_69362_69388[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (2))){
var _ = (function (){var statearr_69363 = state_69350;
(statearr_69363[(4)] = cljs.core.cons((5),(state_69350[(4)])));

return statearr_69363;
})();
var inst_69317 = typeof user === 'number';
var state_69350__$1 = state_69350;
if(cljs.core.truth_(inst_69317)){
var statearr_69364_69389 = state_69350__$1;
(statearr_69364_69389[(1)] = (6));

} else {
var statearr_69365_69390 = state_69350__$1;
(statearr_69365_69390[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (11))){
var inst_69331 = (state_69350[(2)]);
var state_69350__$1 = state_69350;
var statearr_69367_69391 = state_69350__$1;
(statearr_69367_69391[(2)] = inst_69331);

(statearr_69367_69391[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (9))){
var inst_69322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69323 = ["_user/username",user];
var inst_69324 = (new cljs.core.PersistentVector(null,2,(5),inst_69322,inst_69323,null));
var state_69350__$1 = state_69350;
var statearr_69368_69392 = state_69350__$1;
(statearr_69368_69392[(2)] = inst_69324);

(statearr_69368_69392[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (5))){
var _ = (function (){var statearr_69369 = state_69350;
(statearr_69369[(4)] = cljs.core.rest((state_69350[(4)])));

return statearr_69369;
})();
var state_69350__$1 = state_69350;
var ex69366 = (state_69350__$1[(2)]);
var statearr_69370_69393 = state_69350__$1;
(statearr_69370_69393[(5)] = ex69366);


var statearr_69371_69394 = state_69350__$1;
(statearr_69371_69394[(1)] = (4));

(statearr_69371_69394[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (14))){
var inst_69329 = (state_69350[(2)]);
var state_69350__$1 = state_69350;
var statearr_69372_69395 = state_69350__$1;
(statearr_69372_69395[(2)] = inst_69329);

(statearr_69372_69395[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (10))){
var state_69350__$1 = state_69350;
var statearr_69373_69396 = state_69350__$1;
(statearr_69373_69396[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69351 === (8))){
var inst_69333 = (state_69350[(2)]);
var inst_69334 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_69335 = [account,inst_69333,password,expireSeconds,syncTo];
var inst_69336 = cljs.core.PersistentHashMap.fromArrays(inst_69334,inst_69335);
var inst_69337 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_69336);
var state_69350__$1 = state_69350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69350__$1,(15),inst_69337);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69375 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69375[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69375[(1)] = (1));

return statearr_69375;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69350){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69350);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69376){var ex__2687__auto__ = e69376;
var statearr_69377_69397 = state_69350;
(statearr_69377_69397[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69350[(4)]))){
var statearr_69378_69398 = state_69350;
(statearr_69378_69398[(1)] = cljs.core.first((state_69350[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69399 = state_69350;
state_69350 = G__69399;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69350){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69379 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69379[(6)] = c__2706__auto__);

return statearr_69379;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__69401 = arguments.length;
switch (G__69401) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69410){
var state_val_69411 = (state_69410[(1)]);
if((state_val_69411 === (1))){
var inst_69402 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69404 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_69405 = (new cljs.core.PersistentVector(null,4,(5),inst_69403,inst_69404,null));
var inst_69406 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69402,inst_69405);
var inst_69407 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__69412 = cljs.core.seq(cljs.core.keys(x));
var chunk__69413 = null;
var count__69414 = (0);
var i__69415 = (0);
while(true){
if((i__69415 < count__69414)){
var k = chunk__69413.cljs$core$IIndexed$_nth$arity$2(null,i__69415);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__69423 = seq__69412;
var G__69424 = chunk__69413;
var G__69425 = count__69414;
var G__69426 = (i__69415 + (1));
seq__69412 = G__69423;
chunk__69413 = G__69424;
count__69414 = G__69425;
i__69415 = G__69426;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__69412);
if(temp__5804__auto__){
var seq__69412__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__69412__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__69412__$1);
var G__69427 = cljs.core.chunk_rest(seq__69412__$1);
var G__69428 = c__5568__auto__;
var G__69429 = cljs.core.count(c__5568__auto__);
var G__69430 = (0);
seq__69412 = G__69427;
chunk__69413 = G__69428;
count__69414 = G__69429;
i__69415 = G__69430;
continue;
} else {
var k = cljs.core.first(seq__69412__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__69431 = cljs.core.next(seq__69412__$1);
var G__69432 = null;
var G__69433 = (0);
var G__69434 = (0);
seq__69412 = G__69431;
chunk__69413 = G__69432;
count__69414 = G__69433;
i__69415 = G__69434;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_69408 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69407);
var state_69410__$1 = (function (){var statearr_69416 = state_69410;
(statearr_69416[(7)] = inst_69406);

return statearr_69416;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69410__$1,inst_69408);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69417 = [null,null,null,null,null,null,null,null];
(statearr_69417[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69417[(1)] = (1));

return statearr_69417;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69410){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69410);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69418){var ex__2687__auto__ = e69418;
var statearr_69419_69435 = state_69410;
(statearr_69419_69435[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69410[(4)]))){
var statearr_69420_69436 = state_69410;
(statearr_69420_69436[(1)] = cljs.core.first((state_69410[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69437 = state_69410;
state_69410 = G__69437;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69410){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69410);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69421 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69421[(6)] = c__2706__auto__);

return statearr_69421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__69439 = arguments.length;
switch (G__69439) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69476){
var state_val_69477 = (state_69476[(1)]);
if((state_val_69477 === (1))){
var state_69476__$1 = state_69476;
var statearr_69478_69499 = state_69476__$1;
(statearr_69478_69499[(2)] = null);

(statearr_69478_69499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69477 === (2))){
var _ = (function (){var statearr_69479 = state_69476;
(statearr_69479[(4)] = cljs.core.cons((5),(state_69476[(4)])));

return statearr_69479;
})();
var inst_69451 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_69452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69453 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_69454 = (new cljs.core.PersistentVector(null,1,(5),inst_69452,inst_69453,null));
var inst_69455 = cljs.core.PersistentHashMap.EMPTY;
var inst_69456 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_69455);
var inst_69457 = cljs.core.assoc_in(inst_69451,inst_69454,inst_69456);
var inst_69458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69459 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69460 = (new cljs.core.PersistentVector(null,1,(5),inst_69458,inst_69459,null));
var inst_69461 = cljs.core.PersistentHashMap.EMPTY;
var inst_69462 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_69461);
var inst_69463 = cljs.core.assoc_in(inst_69457,inst_69460,inst_69462);
var inst_69464 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69465 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_69463);
var inst_69466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69467 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_69464,null];
var inst_69468 = (new cljs.core.PersistentVector(null,4,(5),inst_69466,inst_69467,null));
var inst_69469 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69465,inst_69468);
var inst_69470 = (function (){var conn = inst_69463;
var pc = inst_69464;
return (function (x){
if((x == null)){
} else {
var seq__69480_69500 = cljs.core.seq(cljs.core.keys(x));
var chunk__69481_69501 = null;
var count__69482_69502 = (0);
var i__69483_69503 = (0);
while(true){
if((i__69483_69503 < count__69482_69502)){
var k_69504 = chunk__69481_69501.cljs$core$IIndexed$_nth$arity$2(null,i__69483_69503);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69504], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_69504,null));


var G__69505 = seq__69480_69500;
var G__69506 = chunk__69481_69501;
var G__69507 = count__69482_69502;
var G__69508 = (i__69483_69503 + (1));
seq__69480_69500 = G__69505;
chunk__69481_69501 = G__69506;
count__69482_69502 = G__69507;
i__69483_69503 = G__69508;
continue;
} else {
var temp__5804__auto___69509 = cljs.core.seq(seq__69480_69500);
if(temp__5804__auto___69509){
var seq__69480_69510__$1 = temp__5804__auto___69509;
if(cljs.core.chunked_seq_QMARK_(seq__69480_69510__$1)){
var c__5568__auto___69511 = cljs.core.chunk_first(seq__69480_69510__$1);
var G__69512 = cljs.core.chunk_rest(seq__69480_69510__$1);
var G__69513 = c__5568__auto___69511;
var G__69514 = cljs.core.count(c__5568__auto___69511);
var G__69515 = (0);
seq__69480_69500 = G__69512;
chunk__69481_69501 = G__69513;
count__69482_69502 = G__69514;
i__69483_69503 = G__69515;
continue;
} else {
var k_69516 = cljs.core.first(seq__69480_69510__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_69516], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_69516,null));


var G__69517 = cljs.core.next(seq__69480_69510__$1);
var G__69518 = null;
var G__69519 = (0);
var G__69520 = (0);
seq__69480_69500 = G__69517;
chunk__69481_69501 = G__69518;
count__69482_69502 = G__69519;
i__69483_69503 = G__69520;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_69471 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69464,inst_69470);
var ___$1 = (function (){var statearr_69484 = state_69476;
(statearr_69484[(4)] = cljs.core.rest((state_69476[(4)])));

return statearr_69484;
})();
var state_69476__$1 = (function (){var statearr_69485 = state_69476;
(statearr_69485[(7)] = inst_69469);

return statearr_69485;
})();
var statearr_69486_69521 = state_69476__$1;
(statearr_69486_69521[(2)] = inst_69471);

(statearr_69486_69521[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69477 === (3))){
var inst_69474 = (state_69476[(2)]);
var state_69476__$1 = state_69476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69476__$1,inst_69474);
} else {
if((state_val_69477 === (4))){
var inst_69440 = (state_69476[(2)]);
var inst_69441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69442 = [inst_69440];
var inst_69443 = (new cljs.core.PersistentVector(null,1,(5),inst_69441,inst_69442,null));
var inst_69444 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69443);
var inst_69445 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69440) : reject.call(null,inst_69440));
var state_69476__$1 = (function (){var statearr_69488 = state_69476;
(statearr_69488[(8)] = inst_69444);

return statearr_69488;
})();
var statearr_69489_69522 = state_69476__$1;
(statearr_69489_69522[(2)] = inst_69445);

(statearr_69489_69522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69477 === (5))){
var _ = (function (){var statearr_69490 = state_69476;
(statearr_69490[(4)] = cljs.core.rest((state_69476[(4)])));

return statearr_69490;
})();
var state_69476__$1 = state_69476;
var ex69487 = (state_69476__$1[(2)]);
var statearr_69491_69523 = state_69476__$1;
(statearr_69491_69523[(5)] = ex69487);


var statearr_69492_69524 = state_69476__$1;
(statearr_69492_69524[(1)] = (4));

(statearr_69492_69524[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69493 = [null,null,null,null,null,null,null,null,null];
(statearr_69493[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69493[(1)] = (1));

return statearr_69493;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69476){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69476);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69494){var ex__2687__auto__ = e69494;
var statearr_69495_69525 = state_69476;
(statearr_69495_69525[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69476[(4)]))){
var statearr_69496_69526 = state_69476;
(statearr_69496_69526[(1)] = cljs.core.first((state_69476[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69527 = state_69476;
state_69476 = G__69527;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69476){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69497 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69497[(6)] = c__2706__auto__);

return statearr_69497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__69529 = arguments.length;
switch (G__69529) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__69531 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69531,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69531,(1),null);
var cb_STAR_ = (function (header,data){
var G__69534 = cljs.core.clj__GT_js(header);
var G__69535 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__69534,G__69535) : callback.call(null,G__69534,G__69535));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__69536 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69536,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69536,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69589){
var state_val_69590 = (state_69589[(1)]);
if((state_val_69590 === (7))){
var inst_69550 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69551 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69552 = cljs.core.PersistentHashMap.fromArrays(inst_69550,inst_69551);
var inst_69553 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_69552);
var inst_69554 = (function(){throw inst_69553})();
var state_69589__$1 = state_69589;
var statearr_69591_69623 = state_69589__$1;
(statearr_69591_69623[(2)] = inst_69554);

(statearr_69591_69623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (1))){
var state_69589__$1 = state_69589;
var statearr_69592_69624 = state_69589__$1;
(statearr_69592_69624[(2)] = null);

(statearr_69592_69624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (4))){
var inst_69539 = (state_69589[(2)]);
var inst_69540 = cljs.core.clj__GT_js(inst_69539);
var inst_69541 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69540) : reject.call(null,inst_69540));
var state_69589__$1 = state_69589;
var statearr_69593_69625 = state_69589__$1;
(statearr_69593_69625[(2)] = inst_69541);

(statearr_69593_69625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (13))){
var inst_69568 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69569 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69570 = cljs.core.PersistentHashMap.fromArrays(inst_69568,inst_69569);
var inst_69571 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_69570);
var inst_69572 = (function(){throw inst_69571})();
var state_69589__$1 = state_69589;
var statearr_69594_69626 = state_69589__$1;
(statearr_69594_69626[(2)] = inst_69572);

(statearr_69594_69626[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (6))){
var state_69589__$1 = state_69589;
var statearr_69595_69627 = state_69589__$1;
(statearr_69595_69627[(2)] = null);

(statearr_69595_69627[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (3))){
var inst_69587 = (state_69589[(2)]);
var state_69589__$1 = state_69589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69589__$1,inst_69587);
} else {
if((state_val_69590 === (12))){
var state_69589__$1 = state_69589;
var statearr_69596_69628 = state_69589__$1;
(statearr_69596_69628[(2)] = null);

(statearr_69596_69628[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (2))){
var _ = (function (){var statearr_69597 = state_69589;
(statearr_69597[(4)] = cljs.core.cons((5),(state_69589[(4)])));

return statearr_69597;
})();
var inst_69547 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_69589__$1 = state_69589;
if(cljs.core.truth_(inst_69547)){
var statearr_69598_69629 = state_69589__$1;
(statearr_69598_69629[(1)] = (6));

} else {
var statearr_69599_69630 = state_69589__$1;
(statearr_69599_69630[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (11))){
var inst_69565 = (state_69589[(2)]);
var state_69589__$1 = (function (){var statearr_69601 = state_69589;
(statearr_69601[(7)] = inst_69565);

return statearr_69601;
})();
if(cljs.core.truth_(password)){
var statearr_69602_69631 = state_69589__$1;
(statearr_69602_69631[(1)] = (12));

} else {
var statearr_69603_69632 = state_69589__$1;
(statearr_69603_69632[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (9))){
var state_69589__$1 = state_69589;
var statearr_69604_69633 = state_69589__$1;
(statearr_69604_69633[(2)] = null);

(statearr_69604_69633[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (5))){
var _ = (function (){var statearr_69605 = state_69589;
(statearr_69605[(4)] = cljs.core.rest((state_69589[(4)])));

return statearr_69605;
})();
var state_69589__$1 = state_69589;
var ex69600 = (state_69589__$1[(2)]);
var statearr_69606_69634 = state_69589__$1;
(statearr_69606_69634[(5)] = ex69600);


var statearr_69607_69635 = state_69589__$1;
(statearr_69607_69635[(1)] = (4));

(statearr_69607_69635[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (14))){
var inst_69574 = (state_69589[(2)]);
var inst_69575 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_69576 = fluree.db.util.core.without_nils(inst_69575);
var inst_69577 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69578 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69580 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_69576,inst_69577,null];
var inst_69581 = (new cljs.core.PersistentVector(null,4,(5),inst_69579,inst_69580,null));
var inst_69582 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69578,inst_69581);
var inst_69583 = (function (){var _ = inst_69574;
var data = inst_69576;
var pc = inst_69577;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__69608 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69608) : reject.call(null,G__69608));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__69609 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69609) : reject.call(null,G__69609));
} else {
var G__69610 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__69610) : resolve.call(null,G__69610));

}
}
});
})();
var inst_69584 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69577,inst_69583);
var _ = (function (){var statearr_69611 = state_69589;
(statearr_69611[(4)] = cljs.core.rest((state_69589[(4)])));

return statearr_69611;
})();
var state_69589__$1 = (function (){var statearr_69612 = state_69589;
(statearr_69612[(8)] = inst_69582);

return statearr_69612;
})();
var statearr_69613_69636 = state_69589__$1;
(statearr_69613_69636[(2)] = inst_69584);

(statearr_69613_69636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (10))){
var inst_69559 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69560 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69561 = cljs.core.PersistentHashMap.fromArrays(inst_69559,inst_69560);
var inst_69562 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_69561);
var inst_69563 = (function(){throw inst_69562})();
var state_69589__$1 = state_69589;
var statearr_69614_69637 = state_69589__$1;
(statearr_69614_69637[(2)] = inst_69563);

(statearr_69614_69637[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69590 === (8))){
var inst_69556 = (state_69589[(2)]);
var state_69589__$1 = (function (){var statearr_69615 = state_69589;
(statearr_69615[(9)] = inst_69556);

return statearr_69615;
})();
if(cljs.core.truth_(ledger)){
var statearr_69616_69638 = state_69589__$1;
(statearr_69616_69638[(1)] = (9));

} else {
var statearr_69617_69639 = state_69589__$1;
(statearr_69617_69639[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0 = (function (){
var statearr_69618 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69618[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2684__auto__);

(statearr_69618[(1)] = (1));

return statearr_69618;
});
var fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1 = (function (state_69589){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69589);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69619){var ex__2687__auto__ = e69619;
var statearr_69620_69640 = state_69589;
(statearr_69620_69640[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69589[(4)]))){
var statearr_69621_69641 = state_69589;
(statearr_69621_69641[(1)] = cljs.core.first((state_69589[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69642 = state_69589;
state_69589 = G__69642;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__ = function(state_69589){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1.call(this,state_69589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2684__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69622 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69622[(6)] = c__2706__auto__);

return statearr_69622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__69644 = arguments.length;
switch (G__69644) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69711){
var state_val_69712 = (state_69711[(1)]);
if((state_val_69712 === (7))){
var inst_69656 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69657 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69658 = cljs.core.PersistentHashMap.fromArrays(inst_69656,inst_69657);
var inst_69659 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_69658);
var inst_69660 = (function(){throw inst_69659})();
var state_69711__$1 = state_69711;
var statearr_69713_69755 = state_69711__$1;
(statearr_69713_69755[(2)] = inst_69660);

(statearr_69713_69755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (20))){
var inst_69694 = (state_69711[(2)]);
var inst_69695 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69696 = [ledger,password,user,auth,expire];
var inst_69697 = cljs.core.PersistentHashMap.fromArrays(inst_69695,inst_69696);
var inst_69698 = fluree.db.util.core.without_nils(inst_69697);
var inst_69699 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69700 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69702 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_69698,inst_69699,null];
var inst_69703 = (new cljs.core.PersistentVector(null,4,(5),inst_69701,inst_69702,null));
var inst_69704 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69700,inst_69703);
var inst_69705 = (function (){var _ = inst_69694;
var data = inst_69698;
var pc = inst_69699;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__69714 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69714) : reject.call(null,G__69714));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__69715 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69715) : reject.call(null,G__69715));
} else {
fluree.db.connection.add_token(conn,result);

var G__69716 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__69716) : resolve.call(null,G__69716));

}
}
});
})();
var inst_69706 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69699,inst_69705);
var _ = (function (){var statearr_69717 = state_69711;
(statearr_69717[(4)] = cljs.core.rest((state_69711[(4)])));

return statearr_69717;
})();
var state_69711__$1 = (function (){var statearr_69718 = state_69711;
(statearr_69718[(7)] = inst_69704);

return statearr_69718;
})();
var statearr_69719_69756 = state_69711__$1;
(statearr_69719_69756[(2)] = inst_69706);

(statearr_69719_69756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (1))){
var state_69711__$1 = state_69711;
var statearr_69720_69757 = state_69711__$1;
(statearr_69720_69757[(2)] = null);

(statearr_69720_69757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (4))){
var inst_69645 = (state_69711[(2)]);
var inst_69646 = cljs.core.clj__GT_js(inst_69645);
var inst_69647 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69646) : reject.call(null,inst_69646));
var state_69711__$1 = state_69711;
var statearr_69721_69758 = state_69711__$1;
(statearr_69721_69758[(2)] = inst_69647);

(statearr_69721_69758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (15))){
var inst_69681 = (state_69711[(8)]);
var state_69711__$1 = state_69711;
var statearr_69722_69759 = state_69711__$1;
(statearr_69722_69759[(2)] = inst_69681);

(statearr_69722_69759[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (13))){
var inst_69674 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69675 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69676 = cljs.core.PersistentHashMap.fromArrays(inst_69674,inst_69675);
var inst_69677 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_69676);
var inst_69678 = (function(){throw inst_69677})();
var state_69711__$1 = state_69711;
var statearr_69723_69760 = state_69711__$1;
(statearr_69723_69760[(2)] = inst_69678);

(statearr_69723_69760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (6))){
var state_69711__$1 = state_69711;
var statearr_69724_69761 = state_69711__$1;
(statearr_69724_69761[(2)] = null);

(statearr_69724_69761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (17))){
var inst_69685 = (state_69711[(2)]);
var state_69711__$1 = state_69711;
if(cljs.core.truth_(inst_69685)){
var statearr_69725_69762 = state_69711__$1;
(statearr_69725_69762[(1)] = (18));

} else {
var statearr_69726_69763 = state_69711__$1;
(statearr_69726_69763[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (3))){
var inst_69709 = (state_69711[(2)]);
var state_69711__$1 = state_69711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69711__$1,inst_69709);
} else {
if((state_val_69712 === (12))){
var state_69711__$1 = state_69711;
var statearr_69727_69764 = state_69711__$1;
(statearr_69727_69764[(2)] = null);

(statearr_69727_69764[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (2))){
var _ = (function (){var statearr_69728 = state_69711;
(statearr_69728[(4)] = cljs.core.cons((5),(state_69711[(4)])));

return statearr_69728;
})();
var inst_69653 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_69711__$1 = state_69711;
if(cljs.core.truth_(inst_69653)){
var statearr_69729_69765 = state_69711__$1;
(statearr_69729_69765[(1)] = (6));

} else {
var statearr_69730_69766 = state_69711__$1;
(statearr_69730_69766[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (19))){
var inst_69688 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69689 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69690 = cljs.core.PersistentHashMap.fromArrays(inst_69688,inst_69689);
var inst_69691 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_69690);
var inst_69692 = (function(){throw inst_69691})();
var state_69711__$1 = state_69711;
var statearr_69731_69767 = state_69711__$1;
(statearr_69731_69767[(2)] = inst_69692);

(statearr_69731_69767[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (11))){
var inst_69671 = (state_69711[(2)]);
var state_69711__$1 = (function (){var statearr_69733 = state_69711;
(statearr_69733[(9)] = inst_69671);

return statearr_69733;
})();
if(cljs.core.truth_(password)){
var statearr_69734_69768 = state_69711__$1;
(statearr_69734_69768[(1)] = (12));

} else {
var statearr_69735_69769 = state_69711__$1;
(statearr_69735_69769[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (9))){
var state_69711__$1 = state_69711;
var statearr_69736_69770 = state_69711__$1;
(statearr_69736_69770[(2)] = null);

(statearr_69736_69770[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (5))){
var _ = (function (){var statearr_69737 = state_69711;
(statearr_69737[(4)] = cljs.core.rest((state_69711[(4)])));

return statearr_69737;
})();
var state_69711__$1 = state_69711;
var ex69732 = (state_69711__$1[(2)]);
var statearr_69738_69771 = state_69711__$1;
(statearr_69738_69771[(5)] = ex69732);


var statearr_69739_69772 = state_69711__$1;
(statearr_69739_69772[(1)] = (4));

(statearr_69739_69772[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (14))){
var inst_69681 = (state_69711[(8)]);
var inst_69680 = (state_69711[(2)]);
var inst_69681__$1 = user;
var state_69711__$1 = (function (){var statearr_69740 = state_69711;
(statearr_69740[(8)] = inst_69681__$1);

(statearr_69740[(10)] = inst_69680);

return statearr_69740;
})();
if(cljs.core.truth_(inst_69681__$1)){
var statearr_69741_69773 = state_69711__$1;
(statearr_69741_69773[(1)] = (15));

} else {
var statearr_69742_69774 = state_69711__$1;
(statearr_69742_69774[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (16))){
var state_69711__$1 = state_69711;
var statearr_69743_69775 = state_69711__$1;
(statearr_69743_69775[(2)] = auth);

(statearr_69743_69775[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (10))){
var inst_69665 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69666 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_69667 = cljs.core.PersistentHashMap.fromArrays(inst_69665,inst_69666);
var inst_69668 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_69667);
var inst_69669 = (function(){throw inst_69668})();
var state_69711__$1 = state_69711;
var statearr_69744_69776 = state_69711__$1;
(statearr_69744_69776[(2)] = inst_69669);

(statearr_69744_69776[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (18))){
var state_69711__$1 = state_69711;
var statearr_69745_69777 = state_69711__$1;
(statearr_69745_69777[(2)] = null);

(statearr_69745_69777[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69712 === (8))){
var inst_69662 = (state_69711[(2)]);
var state_69711__$1 = (function (){var statearr_69746 = state_69711;
(statearr_69746[(11)] = inst_69662);

return statearr_69746;
})();
if(cljs.core.truth_(ledger)){
var statearr_69747_69778 = state_69711__$1;
(statearr_69747_69778[(1)] = (9));

} else {
var statearr_69748_69779 = state_69711__$1;
(statearr_69748_69779[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69749 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69749[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69749[(1)] = (1));

return statearr_69749;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69711){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69711);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69750){var ex__2687__auto__ = e69750;
var statearr_69751_69780 = state_69711;
(statearr_69751_69780[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69711[(4)]))){
var statearr_69752_69781 = state_69711;
(statearr_69752_69781[(1)] = cljs.core.first((state_69711[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69782 = state_69711;
state_69711 = G__69782;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69711){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69753 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69753[(6)] = c__2706__auto__);

return statearr_69753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__69784 = arguments.length;
switch (G__69784) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69819){
var state_val_69820 = (state_69819[(1)]);
if((state_val_69820 === (1))){
var state_69819__$1 = state_69819;
var statearr_69821_69843 = state_69819__$1;
(statearr_69821_69843[(2)] = null);

(statearr_69821_69843[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69820 === (2))){
var _ = (function (){var statearr_69822 = state_69819;
(statearr_69822[(4)] = cljs.core.cons((5),(state_69819[(4)])));

return statearr_69822;
})();
var inst_69793 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_69819__$1 = state_69819;
if(cljs.core.truth_(inst_69793)){
var statearr_69823_69844 = state_69819__$1;
(statearr_69823_69844[(1)] = (6));

} else {
var statearr_69824_69845 = state_69819__$1;
(statearr_69824_69845[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69820 === (3))){
var inst_69817 = (state_69819[(2)]);
var state_69819__$1 = state_69819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69819__$1,inst_69817);
} else {
if((state_val_69820 === (4))){
var inst_69785 = (state_69819[(2)]);
var inst_69786 = cljs.core.clj__GT_js(inst_69785);
var inst_69787 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_69786) : reject.call(null,inst_69786));
var state_69819__$1 = state_69819;
var statearr_69826_69846 = state_69819__$1;
(statearr_69826_69846[(2)] = inst_69787);

(statearr_69826_69846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69820 === (5))){
var _ = (function (){var statearr_69827 = state_69819;
(statearr_69827[(4)] = cljs.core.rest((state_69819[(4)])));

return statearr_69827;
})();
var state_69819__$1 = state_69819;
var ex69825 = (state_69819__$1[(2)]);
var statearr_69828_69847 = state_69819__$1;
(statearr_69828_69847[(5)] = ex69825);


var statearr_69829_69848 = state_69819__$1;
(statearr_69829_69848[(1)] = (4));

(statearr_69829_69848[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69820 === (6))){
var state_69819__$1 = state_69819;
var statearr_69830_69849 = state_69819__$1;
(statearr_69830_69849[(2)] = null);

(statearr_69830_69849[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69820 === (7))){
var inst_69796 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69797 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_69798 = cljs.core.PersistentHashMap.fromArrays(inst_69796,inst_69797);
var inst_69799 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_69798);
var inst_69800 = (function(){throw inst_69799})();
var state_69819__$1 = state_69819;
var statearr_69831_69850 = state_69819__$1;
(statearr_69831_69850[(2)] = inst_69800);

(statearr_69831_69850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69820 === (8))){
var inst_69802 = (state_69819[(2)]);
var inst_69803 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69804 = [jwt,expire];
var inst_69805 = cljs.core.PersistentHashMap.fromArrays(inst_69803,inst_69804);
var inst_69806 = fluree.db.util.core.without_nils(inst_69805);
var inst_69807 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_69808 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_69809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69810 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_69806,inst_69807,null];
var inst_69811 = (new cljs.core.PersistentVector(null,4,(5),inst_69809,inst_69810,null));
var inst_69812 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69808,inst_69811);
var inst_69813 = (function (){var _ = inst_69802;
var data = inst_69806;
var pc = inst_69807;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__69832 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__69832) : reject.call(null,G__69832));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__69833 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__69833) : resolve.call(null,G__69833));

}
});
})();
var inst_69814 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_69807,inst_69813);
var _ = (function (){var statearr_69834 = state_69819;
(statearr_69834[(4)] = cljs.core.rest((state_69819[(4)])));

return statearr_69834;
})();
var state_69819__$1 = (function (){var statearr_69835 = state_69819;
(statearr_69835[(7)] = inst_69812);

return statearr_69835;
})();
var statearr_69836_69851 = state_69819__$1;
(statearr_69836_69851[(2)] = inst_69814);

(statearr_69836_69851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2684__auto__ = null;
var fluree$db$connection_js$state_machine__2684__auto____0 = (function (){
var statearr_69837 = [null,null,null,null,null,null,null,null];
(statearr_69837[(0)] = fluree$db$connection_js$state_machine__2684__auto__);

(statearr_69837[(1)] = (1));

return statearr_69837;
});
var fluree$db$connection_js$state_machine__2684__auto____1 = (function (state_69819){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69819);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69838){var ex__2687__auto__ = e69838;
var statearr_69839_69852 = state_69819;
(statearr_69839_69852[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69819[(4)]))){
var statearr_69840_69853 = state_69819;
(statearr_69840_69853[(1)] = cljs.core.first((state_69819[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69854 = state_69819;
state_69819 = G__69854;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2684__auto__ = function(state_69819){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2684__auto____1.call(this,state_69819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2684__auto____0;
fluree$db$connection_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2684__auto____1;
return fluree$db$connection_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69841 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69841[(6)] = c__2706__auto__);

return statearr_69841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

