// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__68031_68212 = cljs.core.seq(servers);
var chunk__68032_68213 = null;
var count__68033_68214 = (0);
var i__68034_68215 = (0);
while(true){
if((i__68034_68215 < count__68033_68214)){
var server_68216 = chunk__68032_68213.cljs$core$IIndexed$_nth$arity$2(null,i__68034_68215);
var healthcheck_uri_68217 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68216),"/fdb/health"].join('');
var resp_chan_68218 = fluree.db.util.xhttp.post_json(healthcheck_uri_68217,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___68219 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68219,healthcheck_uri_68217,resp_chan_68218,server_68216){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68219,healthcheck_uri_68217,resp_chan_68218,server_68216){
return (function (state_68104){
var state_val_68105 = (state_68104[(1)]);
if((state_val_68105 === (1))){
var state_68104__$1 = state_68104;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68104__$1,(2),resp_chan_68218);
} else {
if((state_val_68105 === (2))){
var inst_68090 = (state_68104[(7)]);
var inst_68090__$1 = (state_68104[(2)]);
var inst_68091 = fluree.db.util.core.exception_QMARK_(inst_68090__$1);
var state_68104__$1 = (function (){var statearr_68106 = state_68104;
(statearr_68106[(7)] = inst_68090__$1);

return statearr_68106;
})();
if(inst_68091){
var statearr_68107_68220 = state_68104__$1;
(statearr_68107_68220[(1)] = (3));

} else {
var statearr_68108_68221 = state_68104__$1;
(statearr_68108_68221[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68105 === (3))){
var inst_68090 = (state_68104[(7)]);
var inst_68093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68094 = cljs.core.ex_message(inst_68090);
var inst_68095 = cljs.core.ex_data(inst_68090);
var inst_68096 = ["Server contact error: ",inst_68094,inst_68095];
var inst_68097 = (new cljs.core.PersistentVector(null,3,(5),inst_68093,inst_68096,null));
var inst_68098 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68097);
var state_68104__$1 = state_68104;
var statearr_68109_68222 = state_68104__$1;
(statearr_68109_68222[(2)] = inst_68098);

(statearr_68109_68222[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68105 === (4))){
var inst_68100 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_68216);
var state_68104__$1 = state_68104;
var statearr_68110_68223 = state_68104__$1;
(statearr_68110_68223[(2)] = inst_68100);

(statearr_68110_68223[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68105 === (5))){
var inst_68102 = (state_68104[(2)]);
var state_68104__$1 = state_68104;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68104__$1,inst_68102);
} else {
return null;
}
}
}
}
}
});})(seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68219,healthcheck_uri_68217,resp_chan_68218,server_68216))
;
return ((function (seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,switch__2683__auto__,c__2706__auto___68219,healthcheck_uri_68217,resp_chan_68218,server_68216){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68111 = [null,null,null,null,null,null,null,null];
(statearr_68111[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68111[(1)] = (1));

return statearr_68111;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_68104){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68104);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68112){var ex__2687__auto__ = e68112;
var statearr_68113_68224 = state_68104;
(statearr_68113_68224[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68104[(4)]))){
var statearr_68114_68225 = state_68104;
(statearr_68114_68225[(1)] = cljs.core.first((state_68104[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68226 = state_68104;
state_68104 = G__68226;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_68104){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_68104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,switch__2683__auto__,c__2706__auto___68219,healthcheck_uri_68217,resp_chan_68218,server_68216))
})();
var state__2708__auto__ = (function (){var statearr_68115 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68115[(6)] = c__2706__auto___68219);

return statearr_68115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68219,healthcheck_uri_68217,resp_chan_68218,server_68216))
);



var G__68227 = seq__68031_68212;
var G__68228 = chunk__68032_68213;
var G__68229 = count__68033_68214;
var G__68230 = (i__68034_68215 + (1));
seq__68031_68212 = G__68227;
chunk__68032_68213 = G__68228;
count__68033_68214 = G__68229;
i__68034_68215 = G__68230;
continue;
} else {
var temp__5804__auto___68231 = cljs.core.seq(seq__68031_68212);
if(temp__5804__auto___68231){
var seq__68031_68232__$1 = temp__5804__auto___68231;
if(cljs.core.chunked_seq_QMARK_(seq__68031_68232__$1)){
var c__5568__auto___68233 = cljs.core.chunk_first(seq__68031_68232__$1);
var G__68234 = cljs.core.chunk_rest(seq__68031_68232__$1);
var G__68235 = c__5568__auto___68233;
var G__68236 = cljs.core.count(c__5568__auto___68233);
var G__68237 = (0);
seq__68031_68212 = G__68234;
chunk__68032_68213 = G__68235;
count__68033_68214 = G__68236;
i__68034_68215 = G__68237;
continue;
} else {
var server_68238 = cljs.core.first(seq__68031_68232__$1);
var healthcheck_uri_68239 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_68238),"/fdb/health"].join('');
var resp_chan_68240 = fluree.db.util.xhttp.post_json(healthcheck_uri_68239,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2706__auto___68241 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68241,healthcheck_uri_68239,resp_chan_68240,server_68238,seq__68031_68232__$1,temp__5804__auto___68231){
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = ((function (seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68241,healthcheck_uri_68239,resp_chan_68240,server_68238,seq__68031_68232__$1,temp__5804__auto___68231){
return (function (state_68131){
var state_val_68132 = (state_68131[(1)]);
if((state_val_68132 === (1))){
var state_68131__$1 = state_68131;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68131__$1,(2),resp_chan_68240);
} else {
if((state_val_68132 === (2))){
var inst_68117 = (state_68131[(7)]);
var inst_68117__$1 = (state_68131[(2)]);
var inst_68118 = fluree.db.util.core.exception_QMARK_(inst_68117__$1);
var state_68131__$1 = (function (){var statearr_68133 = state_68131;
(statearr_68133[(7)] = inst_68117__$1);

return statearr_68133;
})();
if(inst_68118){
var statearr_68134_68242 = state_68131__$1;
(statearr_68134_68242[(1)] = (3));

} else {
var statearr_68135_68243 = state_68131__$1;
(statearr_68135_68243[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68132 === (3))){
var inst_68117 = (state_68131[(7)]);
var inst_68120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68121 = cljs.core.ex_message(inst_68117);
var inst_68122 = cljs.core.ex_data(inst_68117);
var inst_68123 = ["Server contact error: ",inst_68121,inst_68122];
var inst_68124 = (new cljs.core.PersistentVector(null,3,(5),inst_68120,inst_68123,null));
var inst_68125 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68124);
var state_68131__$1 = state_68131;
var statearr_68136_68244 = state_68131__$1;
(statearr_68136_68244[(2)] = inst_68125);

(statearr_68136_68244[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68132 === (4))){
var inst_68127 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_68238);
var state_68131__$1 = state_68131;
var statearr_68137_68245 = state_68131__$1;
(statearr_68137_68245[(2)] = inst_68127);

(statearr_68137_68245[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68132 === (5))){
var inst_68129 = (state_68131[(2)]);
var state_68131__$1 = state_68131;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68131__$1,inst_68129);
} else {
return null;
}
}
}
}
}
});})(seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68241,healthcheck_uri_68239,resp_chan_68240,server_68238,seq__68031_68232__$1,temp__5804__auto___68231))
;
return ((function (seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,switch__2683__auto__,c__2706__auto___68241,healthcheck_uri_68239,resp_chan_68240,server_68238,seq__68031_68232__$1,temp__5804__auto___68231){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68138 = [null,null,null,null,null,null,null,null];
(statearr_68138[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68138[(1)] = (1));

return statearr_68138;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_68131){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68131);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68139){var ex__2687__auto__ = e68139;
var statearr_68140_68246 = state_68131;
(statearr_68140_68246[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68131[(4)]))){
var statearr_68141_68247 = state_68131;
(statearr_68141_68247[(1)] = cljs.core.first((state_68131[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68248 = state_68131;
state_68131 = G__68248;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_68131){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_68131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
;})(seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,switch__2683__auto__,c__2706__auto___68241,healthcheck_uri_68239,resp_chan_68240,server_68238,seq__68031_68232__$1,temp__5804__auto___68231))
})();
var state__2708__auto__ = (function (){var statearr_68142 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68142[(6)] = c__2706__auto___68241);

return statearr_68142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});})(seq__68031_68212,chunk__68032_68213,count__68033_68214,i__68034_68215,c__2706__auto___68241,healthcheck_uri_68239,resp_chan_68240,server_68238,seq__68031_68232__$1,temp__5804__auto___68231))
);



var G__68249 = cljs.core.next(seq__68031_68232__$1);
var G__68250 = null;
var G__68251 = (0);
var G__68252 = (0);
seq__68031_68212 = G__68249;
chunk__68032_68213 = G__68250;
count__68033_68214 = G__68251;
i__68034_68215 = G__68252;
continue;
}
} else {
}
}
break;
}

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68186){
var state_val_68187 = (state_68186[(1)]);
if((state_val_68187 === (7))){
var inst_68158 = (state_68186[(7)]);
var inst_68165 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68158,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_68186__$1 = state_68186;
if(inst_68165){
var statearr_68188_68253 = state_68186__$1;
(statearr_68188_68253[(1)] = (9));

} else {
var statearr_68189_68254 = state_68186__$1;
(statearr_68189_68254[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (1))){
var inst_68150 = (state_68186[(8)]);
var inst_68151 = (state_68186[(9)]);
var inst_68150__$1 = promise_chan;
var inst_68151__$1 = cljs.core.async.timeout((60000));
var inst_68152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68153 = [inst_68150__$1,inst_68151__$1];
var inst_68154 = (new cljs.core.PersistentVector(null,2,(5),inst_68152,inst_68153,null));
var state_68186__$1 = (function (){var statearr_68190 = state_68186;
(statearr_68190[(8)] = inst_68150__$1);

(statearr_68190[(9)] = inst_68151__$1);

return statearr_68190;
})();
return cljs.core.async.ioc_alts_BANG_(state_68186__$1,(2),inst_68154);
} else {
if((state_val_68187 === (4))){
var inst_68158 = (state_68186[(7)]);
var inst_68151 = (state_68186[(9)]);
var inst_68162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68158,inst_68151);
var state_68186__$1 = state_68186;
if(inst_68162){
var statearr_68191_68255 = state_68186__$1;
(statearr_68191_68255[(1)] = (6));

} else {
var statearr_68192_68256 = state_68186__$1;
(statearr_68192_68256[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (13))){
var state_68186__$1 = state_68186;
var statearr_68193_68257 = state_68186__$1;
(statearr_68193_68257[(2)] = null);

(statearr_68193_68257[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (6))){
var state_68186__$1 = state_68186;
var statearr_68194_68258 = state_68186__$1;
(statearr_68194_68258[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_68194_68258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (3))){
var state_68186__$1 = state_68186;
var statearr_68195_68259 = state_68186__$1;
(statearr_68195_68259[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_68195_68259[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (12))){
var inst_68176 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_68177 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68178 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_68179 = cljs.core.PersistentHashMap.fromArrays(inst_68177,inst_68178);
var inst_68180 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_68179);
var inst_68181 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_68180);
var state_68186__$1 = (function (){var statearr_68196 = state_68186;
(statearr_68196[(10)] = inst_68176);

return statearr_68196;
})();
var statearr_68197_68260 = state_68186__$1;
(statearr_68197_68260[(2)] = inst_68181);

(statearr_68197_68260[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (2))){
var inst_68158 = (state_68186[(7)]);
var inst_68150 = (state_68186[(8)]);
var inst_68156 = (state_68186[(2)]);
var inst_68157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68156,(0),null);
var inst_68158__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68156,(1),null);
var inst_68159 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68158__$1,inst_68150);
var state_68186__$1 = (function (){var statearr_68198 = state_68186;
(statearr_68198[(7)] = inst_68158__$1);

(statearr_68198[(11)] = inst_68157);

return statearr_68198;
})();
if(inst_68159){
var statearr_68199_68261 = state_68186__$1;
(statearr_68199_68261[(1)] = (3));

} else {
var statearr_68200_68262 = state_68186__$1;
(statearr_68200_68262[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (11))){
var inst_68169 = (state_68186[(2)]);
var state_68186__$1 = state_68186;
var statearr_68201_68263 = state_68186__$1;
(statearr_68201_68263[(2)] = inst_68169);

(statearr_68201_68263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (9))){
var inst_68157 = (state_68186[(11)]);
var state_68186__$1 = state_68186;
var statearr_68202_68264 = state_68186__$1;
(statearr_68202_68264[(2)] = inst_68157);

(statearr_68202_68264[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (5))){
var inst_68173 = (state_68186[(2)]);
var inst_68174 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_68173);
var state_68186__$1 = state_68186;
if(inst_68174){
var statearr_68203_68265 = state_68186__$1;
(statearr_68203_68265[(1)] = (12));

} else {
var statearr_68204_68266 = state_68186__$1;
(statearr_68204_68266[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (14))){
var inst_68184 = (state_68186[(2)]);
var state_68186__$1 = state_68186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68186__$1,inst_68184);
} else {
if((state_val_68187 === (10))){
var state_68186__$1 = state_68186;
var statearr_68205_68267 = state_68186__$1;
(statearr_68205_68267[(2)] = null);

(statearr_68205_68267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68187 === (8))){
var inst_68171 = (state_68186[(2)]);
var state_68186__$1 = state_68186;
var statearr_68206_68268 = state_68186__$1;
(statearr_68206_68268[(2)] = inst_68171);

(statearr_68206_68268[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0 = (function (){
var statearr_68207 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68207[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__);

(statearr_68207[(1)] = (1));

return statearr_68207;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1 = (function (state_68186){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68186);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68208){var ex__2687__auto__ = e68208;
var statearr_68209_68269 = state_68186;
(statearr_68209_68269[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68186[(4)]))){
var statearr_68210_68270 = state_68186;
(statearr_68210_68270[(1)] = cljs.core.first((state_68186[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68271 = state_68186;
state_68186 = G__68271;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__ = function(state_68186){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1.call(this,state_68186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68211 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68211[(6)] = c__2706__auto__);

return statearr_68211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68315){
var state_val_68316 = (state_68315[(1)]);
if((state_val_68316 === (7))){
var state_68315__$1 = state_68315;
var statearr_68317_68343 = state_68315__$1;
(statearr_68317_68343[(2)] = null);

(statearr_68317_68343[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (1))){
var state_68315__$1 = state_68315;
var statearr_68318_68344 = state_68315__$1;
(statearr_68318_68344[(2)] = null);

(statearr_68318_68344[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (4))){
var inst_68272 = (state_68315[(2)]);
var state_68315__$1 = state_68315;
var statearr_68319_68345 = state_68315__$1;
(statearr_68319_68345[(2)] = inst_68272);

(statearr_68319_68345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (6))){
var inst_68294 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_68315__$1 = state_68315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68315__$1,(9),inst_68294);
} else {
if((state_val_68316 === (3))){
var inst_68313 = (state_68315[(2)]);
var state_68315__$1 = state_68315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68315__$1,inst_68313);
} else {
if((state_val_68316 === (12))){
var inst_68307 = (state_68315[(2)]);
var state_68315__$1 = state_68315;
var statearr_68320_68346 = state_68315__$1;
(statearr_68320_68346[(2)] = inst_68307);

(statearr_68320_68346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (2))){
var inst_68288 = (state_68315[(7)]);
var inst_68283 = (state_68315[(8)]);
var inst_68278 = (state_68315[(9)]);
var _ = (function (){var statearr_68321 = state_68315;
(statearr_68321[(4)] = cljs.core.cons((5),(state_68315[(4)])));

return statearr_68321;
})();
var inst_68278__$1 = cljs.core.random_uuid();
var inst_68279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68280 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_68281 = (new cljs.core.PersistentVector(null,2,(5),inst_68279,inst_68280,null));
var inst_68282 = (function (){var lock_id = inst_68278__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_68283__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_68281,inst_68282);
var inst_68284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68285 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_68286 = (new cljs.core.PersistentVector(null,3,(5),inst_68284,inst_68285,null));
var inst_68287 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68283__$1,inst_68286);
var inst_68288__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68278__$1,inst_68287);
var inst_68289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68290 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68291 = (new cljs.core.PersistentVector(null,3,(5),inst_68289,inst_68290,null));
var inst_68292 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68283__$1,inst_68291);
var state_68315__$1 = (function (){var statearr_68322 = state_68315;
(statearr_68322[(7)] = inst_68288__$1);

(statearr_68322[(10)] = inst_68292);

(statearr_68322[(8)] = inst_68283__$1);

(statearr_68322[(9)] = inst_68278__$1);

return statearr_68322;
})();
if(inst_68288__$1){
var statearr_68323_68347 = state_68315__$1;
(statearr_68323_68347[(1)] = (6));

} else {
var statearr_68324_68348 = state_68315__$1;
(statearr_68324_68348[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (11))){
var inst_68299 = (state_68315[(11)]);
var inst_68298 = (state_68315[(12)]);
var inst_68292 = (state_68315[(10)]);
var inst_68305 = fluree.db.util.xhttp.try_socket(inst_68298,sub_chan,pub_chan,inst_68292,(60000),inst_68299);
var state_68315__$1 = state_68315;
var statearr_68326_68349 = state_68315__$1;
(statearr_68326_68349[(2)] = inst_68305);

(statearr_68326_68349[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (9))){
var inst_68296 = (state_68315[(13)]);
var inst_68288 = (state_68315[(7)]);
var inst_68298 = (state_68315[(12)]);
var inst_68292 = (state_68315[(10)]);
var inst_68283 = (state_68315[(8)]);
var inst_68278 = (state_68315[(9)]);
var inst_68296__$1 = (state_68315[(2)]);
var inst_68297 = clojure.string.replace(inst_68296__$1,"http","ws");
var inst_68298__$1 = [inst_68297,"/fdb/ws"].join('');
var inst_68299 = (function (){var lock_id = inst_68278;
var state = inst_68283;
var have_lock_QMARK_ = inst_68288;
var resp_chan = inst_68292;
var healthy_server = inst_68296__$1;
var ws_url = inst_68298__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_68300 = fluree.db.util.core.exception_QMARK_(inst_68296__$1);
var state_68315__$1 = (function (){var statearr_68327 = state_68315;
(statearr_68327[(13)] = inst_68296__$1);

(statearr_68327[(11)] = inst_68299);

(statearr_68327[(12)] = inst_68298__$1);

return statearr_68327;
})();
if(inst_68300){
var statearr_68328_68350 = state_68315__$1;
(statearr_68328_68350[(1)] = (10));

} else {
var statearr_68329_68351 = state_68315__$1;
(statearr_68329_68351[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (5))){
var _ = (function (){var statearr_68330 = state_68315;
(statearr_68330[(4)] = cljs.core.rest((state_68315[(4)])));

return statearr_68330;
})();
var state_68315__$1 = state_68315;
var ex68325 = (state_68315__$1[(2)]);
var statearr_68331_68352 = state_68315__$1;
(statearr_68331_68352[(5)] = ex68325);


if((ex68325 instanceof Error)){
var statearr_68332_68353 = state_68315__$1;
(statearr_68332_68353[(1)] = (4));

(statearr_68332_68353[(5)] = null);

} else {
throw ex68325;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (10))){
var inst_68296 = (state_68315[(13)]);
var inst_68292 = (state_68315[(10)]);
var inst_68302 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_68303 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68292,inst_68296);
var state_68315__$1 = (function (){var statearr_68333 = state_68315;
(statearr_68333[(14)] = inst_68302);

return statearr_68333;
})();
var statearr_68334_68354 = state_68315__$1;
(statearr_68334_68354[(2)] = inst_68303);

(statearr_68334_68354[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68316 === (8))){
var inst_68292 = (state_68315[(10)]);
var inst_68310 = (state_68315[(2)]);
var _ = (function (){var statearr_68335 = state_68315;
(statearr_68335[(4)] = cljs.core.rest((state_68315[(4)])));

return statearr_68335;
})();
var state_68315__$1 = (function (){var statearr_68336 = state_68315;
(statearr_68336[(15)] = inst_68310);

return statearr_68336;
})();
var statearr_68337_68355 = state_68315__$1;
(statearr_68337_68355[(2)] = inst_68292);

(statearr_68337_68355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_68338 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68338[(0)] = fluree$db$connection$establish_socket_$_state_machine__2684__auto__);

(statearr_68338[(1)] = (1));

return statearr_68338;
});
var fluree$db$connection$establish_socket_$_state_machine__2684__auto____1 = (function (state_68315){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68315);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68339){var ex__2687__auto__ = e68339;
var statearr_68340_68356 = state_68315;
(statearr_68340_68356[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68315[(4)]))){
var statearr_68341_68357 = state_68315;
(statearr_68341_68357[(1)] = cljs.core.first((state_68315[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68358 = state_68315;
state_68315 = G__68358;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2684__auto__ = function(state_68315){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2684__auto____1.call(this,state_68315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68342 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68342[(6)] = c__2706__auto__);

return statearr_68342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k68360,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__68364 = k68360;
var G__68364__$1 = (((G__68364 instanceof cljs.core.Keyword))?G__68364.fqn:null);
switch (G__68364__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k68360,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__68365){
var vec__68366 = p__68365;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68366,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68366,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__68359){
var self__ = this;
var G__68359__$1 = this;
return (new cljs.core.RecordIter((0),G__68359__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__68369 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__68369(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this68361,other68362){
var self__ = this;
var this68361__$1 = this;
return (((!((other68362 == null)))) && ((((this68361__$1.constructor === other68362.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.id,other68362.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.servers,other68362.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.state,other68362.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.req_chan,other68362.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.sub_chan,other68362.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.pub_chan,other68362.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.group,other68362.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.storage_read,other68362.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.storage_list,other68362.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.storage_write,other68362.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.storage_exists,other68362.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.storage_rename,other68362.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.storage_delete,other68362.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.object_cache,other68362.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.async_cache,other68362.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.parallelism,other68362.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.serializer,other68362.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.default_network,other68362.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.transactor_QMARK_,other68362.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.publish,other68362.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.transact_handler,other68362.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.tx_private_key,other68362.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.tx_key_id,other68362.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.meta,other68362.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.add_listener,other68362.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.remove_listener,other68362.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.close,other68362.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this68361__$1.__extmap,other68362.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__68370){
var self__ = this;
var map__68371 = p__68370;
var map__68371__$1 = cljs.core.__destructure_map(map__68371);
var node = map__68371__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68371__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68371__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68371__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__68372 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__68373 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__68374 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__68375 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__68374,G__68375) : self__.async_cache.call(null,G__68374,G__68375));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__68372,G__68373) : self__.async_cache.call(null,G__68372,G__68373));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k68360){
var self__ = this;
var this__5350__auto____$1 = this;
var G__68376 = k68360;
var G__68376__$1 = (((G__68376 instanceof cljs.core.Keyword))?G__68376.fqn:null);
switch (G__68376__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k68360);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__68359){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__68377 = cljs.core.keyword_identical_QMARK_;
var expr__68378 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__68380 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__68381 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68380,G__68381) : pred__68377.call(null,G__68380,G__68381));
})())){
return (new fluree.db.connection.Connection(G__68359,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68382 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__68383 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68382,G__68383) : pred__68377.call(null,G__68382,G__68383));
})())){
return (new fluree.db.connection.Connection(self__.id,G__68359,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68384 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__68385 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68384,G__68385) : pred__68377.call(null,G__68384,G__68385));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__68359,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68386 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__68387 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68386,G__68387) : pred__68377.call(null,G__68386,G__68387));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__68359,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68388 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__68389 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68388,G__68389) : pred__68377.call(null,G__68388,G__68389));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__68359,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68390 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__68391 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68390,G__68391) : pred__68377.call(null,G__68390,G__68391));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__68359,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68392 = new cljs.core.Keyword(null,"group","group",582596132);
var G__68393 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68392,G__68393) : pred__68377.call(null,G__68392,G__68393));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__68359,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68394 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__68395 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68394,G__68395) : pred__68377.call(null,G__68394,G__68395));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__68359,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68396 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__68397 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68396,G__68397) : pred__68377.call(null,G__68396,G__68397));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__68359,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68398 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__68399 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68398,G__68399) : pred__68377.call(null,G__68398,G__68399));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__68359,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68400 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__68401 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68400,G__68401) : pred__68377.call(null,G__68400,G__68401));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__68359,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68402 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__68403 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68402,G__68403) : pred__68377.call(null,G__68402,G__68403));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__68359,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68404 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__68405 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68404,G__68405) : pred__68377.call(null,G__68404,G__68405));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__68359,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68406 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__68407 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68406,G__68407) : pred__68377.call(null,G__68406,G__68407));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__68359,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68408 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__68409 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68408,G__68409) : pred__68377.call(null,G__68408,G__68409));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__68359,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68410 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__68411 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68410,G__68411) : pred__68377.call(null,G__68410,G__68411));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__68359,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68412 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__68413 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68412,G__68413) : pred__68377.call(null,G__68412,G__68413));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__68359,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68414 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__68415 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68414,G__68415) : pred__68377.call(null,G__68414,G__68415));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__68359,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68416 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__68417 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68416,G__68417) : pred__68377.call(null,G__68416,G__68417));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__68359,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68418 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__68419 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68418,G__68419) : pred__68377.call(null,G__68418,G__68419));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__68359,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68420 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__68421 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68420,G__68421) : pred__68377.call(null,G__68420,G__68421));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__68359,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68422 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__68423 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68422,G__68423) : pred__68377.call(null,G__68422,G__68423));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__68359,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68424 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__68425 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68424,G__68425) : pred__68377.call(null,G__68424,G__68425));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__68359,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68426 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__68427 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68426,G__68427) : pred__68377.call(null,G__68426,G__68427));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__68359,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68428 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__68429 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68428,G__68429) : pred__68377.call(null,G__68428,G__68429));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__68359,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68430 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__68431 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68430,G__68431) : pred__68377.call(null,G__68430,G__68431));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__68359,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__68432 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__68433 = expr__68378;
return (pred__68377.cljs$core$IFn$_invoke$arity$2 ? pred__68377.cljs$core$IFn$_invoke$arity$2(G__68432,G__68433) : pred__68377.call(null,G__68432,G__68433));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__68359,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__68359),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__68359){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__68359,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__68363){
var extmap__5385__auto__ = (function (){var G__68434 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__68363,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__68363)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__68434);
} else {
return G__68434;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__68363),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__68363),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__68440 = servers_STAR_;
var vec__68441 = G__68440;
var seq__68442 = cljs.core.seq(vec__68441);
var first__68443 = cljs.core.first(seq__68442);
var seq__68442__$1 = cljs.core.next(seq__68442);
var server = first__68443;
var r = seq__68442__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__68440__$1 = G__68440;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__68447 = G__68440__$1;
var seq__68448 = cljs.core.seq(vec__68447);
var first__68449 = cljs.core.first(seq__68448);
var seq__68448__$1 = cljs.core.next(seq__68448);
var server__$1 = first__68449;
var r__$1 = seq__68448__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__68450 = r__$1;
var G__68451 = is_https_QMARK_;
var G__68452 = result_STAR_;
G__68440__$1 = G__68450;
https_QMARK___$1 = G__68451;
result__$1 = G__68452;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__68453 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__68453 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__68453);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68482){
var state_val_68483 = (state_68482[(1)]);
if((state_val_68483 === (7))){
var inst_68468 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68469 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68470 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68471 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68472 = fluree.db.connection.establish_socket(inst_68468,inst_68469,inst_68470,inst_68471);
var state_68482__$1 = state_68482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68482__$1,(9),inst_68472);
} else {
if((state_val_68483 === (1))){
var state_68482__$1 = state_68482;
var statearr_68484_68503 = state_68482__$1;
(statearr_68484_68503[(2)] = null);

(statearr_68484_68503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (4))){
var inst_68454 = (state_68482[(2)]);
var state_68482__$1 = state_68482;
var statearr_68485_68504 = state_68482__$1;
(statearr_68485_68504[(2)] = inst_68454);

(statearr_68485_68504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (6))){
var inst_68465 = (state_68482[(7)]);
var state_68482__$1 = state_68482;
var statearr_68486_68505 = state_68482__$1;
(statearr_68486_68505[(2)] = inst_68465);

(statearr_68486_68505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (3))){
var inst_68480 = (state_68482[(2)]);
var state_68482__$1 = state_68482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68482__$1,inst_68480);
} else {
if((state_val_68483 === (2))){
var inst_68465 = (state_68482[(7)]);
var _ = (function (){var statearr_68488 = state_68482;
(statearr_68488[(4)] = cljs.core.cons((5),(state_68482[(4)])));

return statearr_68488;
})();
var inst_68460 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_68461 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68462 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68463 = [inst_68462,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_68464 = (new cljs.core.PersistentVector(null,3,(5),inst_68461,inst_68463,null));
var inst_68465__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68460,inst_68464);
var state_68482__$1 = (function (){var statearr_68489 = state_68482;
(statearr_68489[(7)] = inst_68465__$1);

return statearr_68489;
})();
if(cljs.core.truth_(inst_68465__$1)){
var statearr_68490_68506 = state_68482__$1;
(statearr_68490_68506[(1)] = (6));

} else {
var statearr_68491_68507 = state_68482__$1;
(statearr_68491_68507[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (9))){
var inst_68474 = (state_68482[(2)]);
var inst_68475 = fluree.db.util.async.throw_err(inst_68474);
var state_68482__$1 = state_68482;
var statearr_68492_68508 = state_68482__$1;
(statearr_68492_68508[(2)] = inst_68475);

(statearr_68492_68508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (5))){
var _ = (function (){var statearr_68493 = state_68482;
(statearr_68493[(4)] = cljs.core.rest((state_68482[(4)])));

return statearr_68493;
})();
var state_68482__$1 = state_68482;
var ex68487 = (state_68482__$1[(2)]);
var statearr_68494_68509 = state_68482__$1;
(statearr_68494_68509[(5)] = ex68487);


if((ex68487 instanceof Error)){
var statearr_68495_68510 = state_68482__$1;
(statearr_68495_68510[(1)] = (4));

(statearr_68495_68510[(5)] = null);

} else {
throw ex68487;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68483 === (8))){
var inst_68477 = (state_68482[(2)]);
var _ = (function (){var statearr_68496 = state_68482;
(statearr_68496[(4)] = cljs.core.rest((state_68482[(4)])));

return statearr_68496;
})();
var state_68482__$1 = state_68482;
var statearr_68497_68511 = state_68482__$1;
(statearr_68497_68511[(2)] = inst_68477);

(statearr_68497_68511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2684__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2684__auto____0 = (function (){
var statearr_68498 = [null,null,null,null,null,null,null,null];
(statearr_68498[(0)] = fluree$db$connection$get_socket_$_state_machine__2684__auto__);

(statearr_68498[(1)] = (1));

return statearr_68498;
});
var fluree$db$connection$get_socket_$_state_machine__2684__auto____1 = (function (state_68482){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68482);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68499){var ex__2687__auto__ = e68499;
var statearr_68500_68512 = state_68482;
(statearr_68500_68512[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68482[(4)]))){
var statearr_68501_68513 = state_68482;
(statearr_68501_68513[(1)] = cljs.core.first((state_68482[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68514 = state_68482;
state_68482 = G__68514;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2684__auto__ = function(state_68482){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2684__auto____1.call(this,state_68482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2684__auto____0;
fluree$db$connection$get_socket_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2684__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68502 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68502[(6)] = c__2706__auto__);

return statearr_68502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e68515){var e = e68515;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__68517){
var map__68518 = p__68517;
var map__68518__$1 = cljs.core.__destructure_map(map__68518);
var conn = map__68518__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68518__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68518__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68518__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68664){
var state_val_68665 = (state_68664[(1)]);
if((state_val_68665 === (7))){
var inst_68660 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
var statearr_68667_68741 = state_68664__$1;
(statearr_68667_68741[(2)] = inst_68660);

(statearr_68667_68741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (20))){
var _ = (function (){var statearr_68668 = state_68664;
(statearr_68668[(4)] = cljs.core.rest((state_68664[(4)])));

return statearr_68668;
})();
var state_68664__$1 = state_68664;
var ex68666 = (state_68664__$1[(2)]);
var statearr_68669_68742 = state_68664__$1;
(statearr_68669_68742[(5)] = ex68666);


var statearr_68670_68743 = state_68664__$1;
(statearr_68670_68743[(1)] = (10));

(statearr_68670_68743[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (27))){
var inst_68621 = (state_68664[(7)]);
var inst_68621__$1 = (state_68664[(2)]);
var inst_68622 = inst_68621__$1 === true;
var state_68664__$1 = (function (){var statearr_68671 = state_68664;
(statearr_68671[(7)] = inst_68621__$1);

return statearr_68671;
})();
if(cljs.core.truth_(inst_68622)){
var statearr_68672_68744 = state_68664__$1;
(statearr_68672_68744[(1)] = (28));

} else {
var statearr_68673_68745 = state_68664__$1;
(statearr_68673_68745[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (1))){
var inst_68519 = (0);
var state_68664__$1 = (function (){var statearr_68674 = state_68664;
(statearr_68674[(8)] = inst_68519);

return statearr_68674;
})();
var statearr_68675_68746 = state_68664__$1;
(statearr_68675_68746[(2)] = null);

(statearr_68675_68746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (24))){
var inst_68611 = (state_68664[(9)]);
var state_68664__$1 = state_68664;
var statearr_68676_68747 = state_68664__$1;
(statearr_68676_68747[(2)] = inst_68611);

(statearr_68676_68747[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (39))){
var inst_68646 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
var statearr_68677_68748 = state_68664__$1;
(statearr_68677_68748[(2)] = inst_68646);

(statearr_68677_68748[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (4))){
var inst_68522 = (state_68664[(10)]);
var inst_68522__$1 = (state_68664[(2)]);
var state_68664__$1 = (function (){var statearr_68678 = state_68664;
(statearr_68678[(10)] = inst_68522__$1);

return statearr_68678;
})();
if(cljs.core.truth_(inst_68522__$1)){
var statearr_68679_68749 = state_68664__$1;
(statearr_68679_68749[(1)] = (5));

} else {
var statearr_68680_68750 = state_68664__$1;
(statearr_68680_68750[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (15))){
var inst_68535 = (state_68664[(11)]);
var state_68664__$1 = state_68664;
var statearr_68681_68751 = state_68664__$1;
(statearr_68681_68751[(2)] = inst_68535);

(statearr_68681_68751[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (21))){
var inst_68573 = (state_68664[(12)]);
var inst_68567 = (state_68664[(13)]);
var inst_68568 = (state_68664[(14)]);
var inst_68565 = (state_68664[(15)]);
var inst_68519 = (state_68664[(8)]);
var inst_68572 = (state_68664[(16)]);
var inst_68564 = (state_68664[(17)]);
var inst_68569 = (state_68664[(18)]);
var inst_68566 = (state_68664[(19)]);
var inst_68522 = (state_68664[(10)]);
var inst_68575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68576 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68572];
var inst_68577 = (new cljs.core.PersistentVector(null,2,(5),inst_68575,inst_68576,null));
var inst_68578 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_68577,inst_68567);
var inst_68605 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_68606 = (function (){var resp_chan = inst_68567;
var timeout = inst_68573;
var i = inst_68519;
var data = inst_68566;
var map__68560 = inst_68569;
var _ = inst_68564;
var req_id = inst_68572;
var operation = inst_68565;
var msg = inst_68522;
var vec__68557 = inst_68522;
var temp__5804__auto__ = inst_68522;
var c__2706__auto____$1 = inst_68605;
var opts = inst_68568;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68603){
var state_val_68604 = (state_68603[(1)]);
if((state_val_68604 === (1))){
var inst_68582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68583 = cljs.core.async.timeout(timeout);
var inst_68584 = [resp_chan,inst_68583];
var inst_68585 = (new cljs.core.PersistentVector(null,2,(5),inst_68582,inst_68584,null));
var state_68603__$1 = state_68603;
return cljs.core.async.ioc_alts_BANG_(state_68603__$1,(2),inst_68585);
} else {
if((state_val_68604 === (2))){
var inst_68588 = (state_68603[(7)]);
var inst_68587 = (state_68603[(2)]);
var inst_68588__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68587,(0),null);
var inst_68589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68587,(1),null);
var inst_68590 = (function (){var vec__68579 = inst_68587;
var resp = inst_68588__$1;
var c = inst_68589;
return (function (p1__68516_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__68516_SHARP_,req_id);
});
})();
var inst_68591 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_68590);
var inst_68592 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68589,resp_chan);
var state_68603__$1 = (function (){var statearr_68682 = state_68603;
(statearr_68682[(7)] = inst_68588__$1);

(statearr_68682[(8)] = inst_68591);

return statearr_68682;
})();
if(inst_68592){
var statearr_68683_68752 = state_68603__$1;
(statearr_68683_68752[(1)] = (3));

} else {
var statearr_68684_68753 = state_68603__$1;
(statearr_68684_68753[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68604 === (3))){
var inst_68588 = (state_68603[(7)]);
var state_68603__$1 = state_68603;
var statearr_68685_68754 = state_68603__$1;
(statearr_68685_68754[(2)] = inst_68588);

(statearr_68685_68754[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68604 === (4))){
var inst_68595 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_68596 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68597 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68598 = cljs.core.PersistentHashMap.fromArrays(inst_68596,inst_68597);
var inst_68599 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_68595,inst_68598);
var state_68603__$1 = state_68603;
var statearr_68686_68755 = state_68603__$1;
(statearr_68686_68755[(2)] = inst_68599);

(statearr_68686_68755[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68604 === (5))){
var inst_68601 = (state_68603[(2)]);
var state_68603__$1 = state_68603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68603__$1,inst_68601);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_68687 = [null,null,null,null,null,null,null,null,null];
(statearr_68687[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_68687[(1)] = (1));

return statearr_68687;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_68603){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68603);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68688){var ex__2687__auto__ = e68688;
var statearr_68689_68756 = state_68603;
(statearr_68689_68756[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68603[(4)]))){
var statearr_68690_68757 = state_68603;
(statearr_68690_68757[(1)] = cljs.core.first((state_68603[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68758 = state_68603;
state_68603 = G__68758;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_68603){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_68603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68691 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68691[(6)] = c__2706__auto____$1);

return statearr_68691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_68607 = cljs.core.async.impl.dispatch.run(inst_68606);
var state_68664__$1 = (function (){var statearr_68692 = state_68664;
(statearr_68692[(20)] = inst_68607);

(statearr_68692[(21)] = inst_68578);

return statearr_68692;
})();
var statearr_68693_68759 = state_68664__$1;
(statearr_68693_68759[(2)] = inst_68605);

(statearr_68693_68759[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (31))){
var inst_68621 = (state_68664[(7)]);
var inst_68627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68628 = [inst_68621,"Error processing message in producer."];
var inst_68629 = (new cljs.core.PersistentVector(null,2,(5),inst_68627,inst_68628,null));
var inst_68630 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68629);
var state_68664__$1 = state_68664;
var statearr_68694_68760 = state_68664__$1;
(statearr_68694_68760[(2)] = inst_68630);

(statearr_68694_68760[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (32))){
var inst_68621 = (state_68664[(7)]);
var inst_68632 = (inst_68621 == null);
var state_68664__$1 = state_68664;
if(cljs.core.truth_(inst_68632)){
var statearr_68695_68761 = state_68664__$1;
(statearr_68695_68761[(1)] = (34));

} else {
var statearr_68696_68762 = state_68664__$1;
(statearr_68696_68762[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (33))){
var inst_68650 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
var statearr_68697_68763 = state_68664__$1;
(statearr_68697_68763[(2)] = inst_68650);

(statearr_68697_68763[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (13))){
var inst_68535 = (state_68664[(11)]);
var inst_68532 = (state_68664[(2)]);
var inst_68533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68532,(0),null);
var inst_68534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68532,(1),null);
var inst_68535__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68532,(2),null);
var state_68664__$1 = (function (){var statearr_68698 = state_68664;
(statearr_68698[(11)] = inst_68535__$1);

(statearr_68698[(22)] = inst_68533);

(statearr_68698[(23)] = inst_68534);

return statearr_68698;
})();
if(cljs.core.truth_(inst_68535__$1)){
var statearr_68699_68764 = state_68664__$1;
(statearr_68699_68764[(1)] = (14));

} else {
var statearr_68700_68765 = state_68664__$1;
(statearr_68700_68765[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (22))){
var state_68664__$1 = state_68664;
var statearr_68701_68766 = state_68664__$1;
(statearr_68701_68766[(2)] = null);

(statearr_68701_68766[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (36))){
var inst_68648 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
var statearr_68702_68767 = state_68664__$1;
(statearr_68702_68767[(2)] = inst_68648);

(statearr_68702_68767[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (29))){
var inst_68621 = (state_68664[(7)]);
var inst_68625 = fluree.db.util.core.exception_QMARK_(inst_68621);
var state_68664__$1 = state_68664;
if(inst_68625){
var statearr_68703_68768 = state_68664__$1;
(statearr_68703_68768[(1)] = (31));

} else {
var statearr_68704_68769 = state_68664__$1;
(statearr_68704_68769[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (6))){
var state_68664__$1 = state_68664;
var statearr_68705_68770 = state_68664__$1;
(statearr_68705_68770[(2)] = null);

(statearr_68705_68770[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (28))){
var state_68664__$1 = state_68664;
var statearr_68706_68771 = state_68664__$1;
(statearr_68706_68771[(2)] = null);

(statearr_68706_68771[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (25))){
var state_68664__$1 = state_68664;
var statearr_68707_68772 = state_68664__$1;
(statearr_68707_68772[(2)] = fluree.db.connection.default_publish_fn);

(statearr_68707_68772[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (34))){
var inst_68634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68635 = ["Error processing message in producer. Socket closed."];
var inst_68636 = (new cljs.core.PersistentVector(null,1,(5),inst_68634,inst_68635,null));
var inst_68637 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68636);
var state_68664__$1 = state_68664;
var statearr_68708_68773 = state_68664__$1;
(statearr_68708_68773[(2)] = inst_68637);

(statearr_68708_68773[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (17))){
var inst_68535 = (state_68664[(11)]);
var inst_68524 = (state_68664[(24)]);
var inst_68542 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68535,inst_68524);
var state_68664__$1 = state_68664;
var statearr_68709_68774 = state_68664__$1;
(statearr_68709_68774[(2)] = inst_68542);

(statearr_68709_68774[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (3))){
var inst_68662 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68664__$1,inst_68662);
} else {
if((state_val_68665 === (12))){
var state_68664__$1 = state_68664;
var statearr_68710_68775 = state_68664__$1;
(statearr_68710_68775[(2)] = null);

(statearr_68710_68775[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (2))){
var state_68664__$1 = state_68664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68664__$1,(4),req_chan);
} else {
if((state_val_68665 === (23))){
var inst_68611 = (state_68664[(9)]);
var inst_68610 = (state_68664[(2)]);
var inst_68611__$1 = publish;
var state_68664__$1 = (function (){var statearr_68711 = state_68664;
(statearr_68711[(9)] = inst_68611__$1);

(statearr_68711[(25)] = inst_68610);

return statearr_68711;
})();
if(cljs.core.truth_(inst_68611__$1)){
var statearr_68712_68776 = state_68664__$1;
(statearr_68712_68776[(1)] = (24));

} else {
var statearr_68713_68777 = state_68664__$1;
(statearr_68713_68777[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (35))){
var state_68664__$1 = state_68664;
var statearr_68714_68778 = state_68664__$1;
(statearr_68714_68778[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (19))){
var inst_68551 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
var statearr_68716_68779 = state_68664__$1;
(statearr_68716_68779[(2)] = inst_68551);

(statearr_68716_68779[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (11))){
var inst_68522 = (state_68664[(10)]);
var state_68664__$1 = state_68664;
var statearr_68717_68780 = state_68664__$1;
(statearr_68717_68780[(2)] = inst_68522);

(statearr_68717_68780[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (9))){
var inst_68519 = (state_68664[(8)]);
var inst_68655 = (state_68664[(2)]);
var inst_68656 = (inst_68519 + (1));
var inst_68519__$1 = inst_68656;
var state_68664__$1 = (function (){var statearr_68718 = state_68664;
(statearr_68718[(8)] = inst_68519__$1);

(statearr_68718[(26)] = inst_68655);

return statearr_68718;
})();
var statearr_68719_68781 = state_68664__$1;
(statearr_68719_68781[(2)] = null);

(statearr_68719_68781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (5))){
var state_68664__$1 = state_68664;
var statearr_68720_68782 = state_68664__$1;
(statearr_68720_68782[(2)] = null);

(statearr_68720_68782[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (14))){
var inst_68535 = (state_68664[(11)]);
var inst_68537 = fluree.db.util.async.channel_QMARK_(inst_68535);
var state_68664__$1 = state_68664;
var statearr_68721_68783 = state_68664__$1;
(statearr_68721_68783[(2)] = inst_68537);

(statearr_68721_68783[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (26))){
var inst_68565 = (state_68664[(15)]);
var inst_68572 = (state_68664[(16)]);
var inst_68566 = (state_68664[(19)]);
var inst_68615 = (state_68664[(2)]);
var inst_68616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68617 = [inst_68565,inst_68572,inst_68566];
var inst_68618 = (new cljs.core.PersistentVector(null,3,(5),inst_68616,inst_68617,null));
var inst_68619 = (inst_68615.cljs$core$IFn$_invoke$arity$2 ? inst_68615.cljs$core$IFn$_invoke$arity$2(conn,inst_68618) : inst_68615.call(null,conn,inst_68618));
var state_68664__$1 = state_68664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68664__$1,(27),inst_68619);
} else {
if((state_val_68665 === (16))){
var inst_68540 = (state_68664[(2)]);
var state_68664__$1 = state_68664;
if(cljs.core.truth_(inst_68540)){
var statearr_68722_68784 = state_68664__$1;
(statearr_68722_68784[(1)] = (17));

} else {
var statearr_68723_68785 = state_68664__$1;
(statearr_68723_68785[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (38))){
var state_68664__$1 = state_68664;
var statearr_68724_68786 = state_68664__$1;
(statearr_68724_68786[(2)] = null);

(statearr_68724_68786[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (30))){
var inst_68652 = (state_68664[(2)]);
var _ = (function (){var statearr_68725 = state_68664;
(statearr_68725[(4)] = cljs.core.rest((state_68664[(4)])));

return statearr_68725;
})();
var state_68664__$1 = state_68664;
var statearr_68726_68787 = state_68664__$1;
(statearr_68726_68787[(2)] = inst_68652);

(statearr_68726_68787[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (10))){
var inst_68522 = (state_68664[(10)]);
var inst_68524 = (state_68664[(2)]);
var inst_68528 = cljs.core.sequential_QMARK_(inst_68522);
var state_68664__$1 = (function (){var statearr_68727 = state_68664;
(statearr_68727[(24)] = inst_68524);

return statearr_68727;
})();
if(inst_68528){
var statearr_68728_68788 = state_68664__$1;
(statearr_68728_68788[(1)] = (11));

} else {
var statearr_68729_68789 = state_68664__$1;
(statearr_68729_68789[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (18))){
var inst_68524 = (state_68664[(24)]);
var inst_68522 = (state_68664[(10)]);
var inst_68544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68545 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68522], 0));
var inst_68546 = ["Error processing ledger request, no valid return channel: ",inst_68545].join('');
var inst_68547 = [inst_68524,inst_68546];
var inst_68548 = (new cljs.core.PersistentVector(null,2,(5),inst_68544,inst_68547,null));
var inst_68549 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68548);
var state_68664__$1 = state_68664;
var statearr_68730_68790 = state_68664__$1;
(statearr_68730_68790[(2)] = inst_68549);

(statearr_68730_68790[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (37))){
var inst_68621 = (state_68664[(7)]);
var inst_68640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68641 = ["Error processing message in producer. Socket closed. Published result",inst_68621];
var inst_68642 = (new cljs.core.PersistentVector(null,2,(5),inst_68640,inst_68641,null));
var inst_68643 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68642);
var state_68664__$1 = state_68664;
var statearr_68731_68791 = state_68664__$1;
(statearr_68731_68791[(2)] = inst_68643);

(statearr_68731_68791[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68665 === (8))){
var inst_68567 = (state_68664[(13)]);
var inst_68568 = (state_68664[(14)]);
var inst_68569 = (state_68664[(18)]);
var inst_68522 = (state_68664[(10)]);
var _ = (function (){var statearr_68732 = state_68664;
(statearr_68732[(4)] = cljs.core.cons((20),(state_68664[(4)])));

return statearr_68732;
})();
var inst_68561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68562 = ["Outgoing message to websocket: ",inst_68522];
var inst_68563 = (new cljs.core.PersistentVector(null,2,(5),inst_68561,inst_68562,null));
var inst_68564 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68563);
var inst_68565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68522,(0),null);
var inst_68566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68522,(1),null);
var inst_68567__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68522,(2),null);
var inst_68568__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68522,(3),null);
var inst_68569__$1 = cljs.core.__destructure_map(inst_68568__$1);
var inst_68570 = cljs.core.random_uuid();
var inst_68571 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68570);
var inst_68572 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_68569__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_68571);
var inst_68573 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_68569__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_68664__$1 = (function (){var statearr_68733 = state_68664;
(statearr_68733[(12)] = inst_68573);

(statearr_68733[(13)] = inst_68567__$1);

(statearr_68733[(14)] = inst_68568__$1);

(statearr_68733[(15)] = inst_68565);

(statearr_68733[(16)] = inst_68572);

(statearr_68733[(17)] = inst_68564);

(statearr_68733[(18)] = inst_68569__$1);

(statearr_68733[(19)] = inst_68566);

return statearr_68733;
})();
if(cljs.core.truth_(inst_68567__$1)){
var statearr_68734_68792 = state_68664__$1;
(statearr_68734_68792[(1)] = (21));

} else {
var statearr_68735_68793 = state_68664__$1;
(statearr_68735_68793[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____0 = (function (){
var statearr_68736 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68736[(0)] = fluree$db$connection$msg_producer_$_state_machine__2684__auto__);

(statearr_68736[(1)] = (1));

return statearr_68736;
});
var fluree$db$connection$msg_producer_$_state_machine__2684__auto____1 = (function (state_68664){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68664);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68737){var ex__2687__auto__ = e68737;
var statearr_68738_68794 = state_68664;
(statearr_68738_68794[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68664[(4)]))){
var statearr_68739_68795 = state_68664;
(statearr_68739_68795[(1)] = cljs.core.first((state_68664[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68796 = state_68664;
state_68664 = G__68796;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2684__auto__ = function(state_68664){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2684__auto____1.call(this,state_68664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68740 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68740[(6)] = c__2706__auto__);

return statearr_68740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68834){
var state_val_68835 = (state_68834[(1)]);
if((state_val_68835 === (7))){
var inst_68805 = (state_68834[(7)]);
var state_68834__$1 = state_68834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68834__$1,(9),inst_68805);
} else {
if((state_val_68835 === (1))){
var inst_68797 = (1);
var state_68834__$1 = (function (){var statearr_68836 = state_68834;
(statearr_68836[(8)] = inst_68797);

return statearr_68836;
})();
var statearr_68837_68860 = state_68834__$1;
(statearr_68837_68860[(2)] = null);

(statearr_68837_68860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (4))){
var inst_68802 = (state_68834[(2)]);
var inst_68803 = fluree.db.connection.get_socket(conn);
var state_68834__$1 = (function (){var statearr_68838 = state_68834;
(statearr_68838[(9)] = inst_68802);

return statearr_68838;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68834__$1,(5),inst_68803);
} else {
if((state_val_68835 === (15))){
var inst_68830 = (state_68834[(2)]);
var state_68834__$1 = state_68834;
var statearr_68839_68861 = state_68834__$1;
(statearr_68839_68861[(2)] = inst_68830);

(statearr_68839_68861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (13))){
var inst_68797 = (state_68834[(8)]);
var inst_68812 = (state_68834[(10)]);
var inst_68820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68821 = [inst_68812,"Cannot establish connection to a healthy server, backing off:",inst_68797,"s."];
var inst_68822 = (new cljs.core.PersistentVector(null,4,(5),inst_68820,inst_68821,null));
var inst_68823 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68822);
var inst_68824 = ((2) * inst_68797);
var inst_68825 = ((60) * (2));
var inst_68826 = ((inst_68824 < inst_68825) ? inst_68824 : inst_68825);
var inst_68797__$1 = inst_68826;
var state_68834__$1 = (function (){var statearr_68840 = state_68834;
(statearr_68840[(8)] = inst_68797__$1);

(statearr_68840[(11)] = inst_68823);

return statearr_68840;
})();
var statearr_68841_68862 = state_68834__$1;
(statearr_68841_68862[(2)] = null);

(statearr_68841_68862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (6))){
var inst_68805 = (state_68834[(7)]);
var state_68834__$1 = state_68834;
var statearr_68842_68863 = state_68834__$1;
(statearr_68842_68863[(2)] = inst_68805);

(statearr_68842_68863[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (3))){
var inst_68832 = (state_68834[(2)]);
var state_68834__$1 = state_68834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68834__$1,inst_68832);
} else {
if((state_val_68835 === (12))){
var inst_68818 = (state_68834[(2)]);
var state_68834__$1 = state_68834;
if(cljs.core.truth_(inst_68818)){
var statearr_68843_68864 = state_68834__$1;
(statearr_68843_68864[(1)] = (13));

} else {
var statearr_68844_68865 = state_68834__$1;
(statearr_68844_68865[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (2))){
var inst_68797 = (state_68834[(8)]);
var inst_68799 = (inst_68797 * (1000));
var inst_68800 = cljs.core.async.timeout(inst_68799);
var state_68834__$1 = state_68834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68834__$1,(4),inst_68800);
} else {
if((state_val_68835 === (11))){
var inst_68812 = (state_68834[(10)]);
var inst_68816 = fluree.db.util.core.exception_QMARK_(inst_68812);
var state_68834__$1 = state_68834;
var statearr_68845_68866 = state_68834__$1;
(statearr_68845_68866[(2)] = inst_68816);

(statearr_68845_68866[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (9))){
var inst_68810 = (state_68834[(2)]);
var state_68834__$1 = state_68834;
var statearr_68846_68867 = state_68834__$1;
(statearr_68846_68867[(2)] = inst_68810);

(statearr_68846_68867[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (5))){
var inst_68805 = (state_68834[(7)]);
var inst_68805__$1 = (state_68834[(2)]);
var inst_68806 = fluree.db.util.core.exception_QMARK_(inst_68805__$1);
var state_68834__$1 = (function (){var statearr_68847 = state_68834;
(statearr_68847[(7)] = inst_68805__$1);

return statearr_68847;
})();
if(inst_68806){
var statearr_68848_68868 = state_68834__$1;
(statearr_68848_68868[(1)] = (6));

} else {
var statearr_68849_68869 = state_68834__$1;
(statearr_68849_68869[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (14))){
var inst_68812 = (state_68834[(10)]);
var state_68834__$1 = state_68834;
var statearr_68850_68870 = state_68834__$1;
(statearr_68850_68870[(2)] = inst_68812);

(statearr_68850_68870[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (10))){
var inst_68813 = (state_68834[(12)]);
var state_68834__$1 = state_68834;
var statearr_68851_68871 = state_68834__$1;
(statearr_68851_68871[(2)] = inst_68813);

(statearr_68851_68871[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68835 === (8))){
var inst_68813 = (state_68834[(12)]);
var inst_68812 = (state_68834[(10)]);
var inst_68812__$1 = (state_68834[(2)]);
var inst_68813__$1 = (inst_68812__$1 == null);
var state_68834__$1 = (function (){var statearr_68852 = state_68834;
(statearr_68852[(12)] = inst_68813__$1);

(statearr_68852[(10)] = inst_68812__$1);

return statearr_68852;
})();
if(cljs.core.truth_(inst_68813__$1)){
var statearr_68853_68872 = state_68834__$1;
(statearr_68853_68872[(1)] = (10));

} else {
var statearr_68854_68873 = state_68834__$1;
(statearr_68854_68873[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0 = (function (){
var statearr_68855 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68855[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__);

(statearr_68855[(1)] = (1));

return statearr_68855;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1 = (function (state_68834){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68834);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e68856){var ex__2687__auto__ = e68856;
var statearr_68857_68874 = state_68834;
(statearr_68857_68874[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68834[(4)]))){
var statearr_68858_68875 = state_68834;
(statearr_68858_68875[(1)] = cljs.core.first((state_68834[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68876 = state_68834;
state_68834 = G__68876;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__ = function(state_68834){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1.call(this,state_68834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2684__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_68859 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_68859[(6)] = c__2706__auto__);

return statearr_68859;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__68877){
var map__68878 = p__68877;
var map__68878__$1 = cljs.core.__destructure_map(map__68878);
var conn = map__68878__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68878__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_68989){
var state_val_68990 = (state_68989[(1)]);
if((state_val_68990 === (7))){
var inst_68985 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_68991_69047 = state_68989__$1;
(statearr_68991_69047[(2)] = inst_68985);

(statearr_68991_69047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (20))){
var inst_68936 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_68992_69048 = state_68989__$1;
(statearr_68992_69048[(2)] = inst_68936);

(statearr_68992_69048[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (27))){
var inst_68954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68955 = ["Connection closed."];
var inst_68956 = (new cljs.core.PersistentVector(null,1,(5),inst_68954,inst_68955,null));
var inst_68957 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_68956);
var state_68989__$1 = state_68989;
var statearr_68993_69049 = state_68989__$1;
(statearr_68993_69049[(2)] = inst_68957);

(statearr_68993_69049[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (1))){
var inst_68879 = (0);
var state_68989__$1 = (function (){var statearr_68994 = state_68989;
(statearr_68994[(7)] = inst_68879);

return statearr_68994;
})();
var statearr_68995_69050 = state_68989__$1;
(statearr_68995_69050[(2)] = null);

(statearr_68995_69050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (24))){
var inst_68923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68924 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_68925 = [keep_alive_fn];
var inst_68926 = cljs.core.PersistentHashMap.fromArrays(inst_68924,inst_68925);
var inst_68927 = ["Unsupported callback registered",inst_68926];
var inst_68928 = (new cljs.core.PersistentVector(null,2,(5),inst_68923,inst_68927,null));
var inst_68929 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68928);
var state_68989__$1 = state_68989;
var statearr_68996_69051 = state_68989__$1;
(statearr_68996_69051[(2)] = inst_68929);

(statearr_68996_69051[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (4))){
var inst_68884 = (state_68989[(8)]);
var inst_68889 = (state_68989[(2)]);
var inst_68890 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68889,(0),null);
var inst_68891 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68889,(1),null);
var inst_68892 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68891,inst_68884);
var state_68989__$1 = (function (){var statearr_68997 = state_68989;
(statearr_68997[(9)] = inst_68890);

return statearr_68997;
})();
if(inst_68892){
var statearr_68998_69052 = state_68989__$1;
(statearr_68998_69052[(1)] = (5));

} else {
var statearr_68999_69053 = state_68989__$1;
(statearr_68999_69053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (15))){
var inst_68909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68910 = ["No keep-alive callback is registered"];
var inst_68911 = (new cljs.core.PersistentVector(null,1,(5),inst_68909,inst_68910,null));
var inst_68912 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68911);
var state_68989__$1 = state_68989;
var statearr_69000_69054 = state_68989__$1;
(statearr_69000_69054[(2)] = inst_68912);

(statearr_69000_69054[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (21))){
var inst_68920 = cljs.core.eval(keep_alive_fn);
var state_68989__$1 = state_68989;
var statearr_69001_69055 = state_68989__$1;
(statearr_69001_69055[(2)] = inst_68920);

(statearr_69001_69055[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (31))){
var state_68989__$1 = state_68989;
var statearr_69002_69056 = state_68989__$1;
(statearr_69002_69056[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (32))){
var inst_68981 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69004_69057 = state_68989__$1;
(statearr_69004_69057[(2)] = inst_68981);

(statearr_69004_69057[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (33))){
var inst_68890 = (state_68989[(9)]);
var inst_68968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68969 = fluree.db.util.json.parse(inst_68890);
var inst_68970 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68969], 0));
var inst_68971 = ["Received message:",inst_68970];
var inst_68972 = (new cljs.core.PersistentVector(null,2,(5),inst_68968,inst_68971,null));
var inst_68973 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68972);
var inst_68974 = fluree.db.util.json.parse(inst_68890);
var inst_68975 = fluree.db.conn_events.process_events(conn,inst_68974);
var inst_68879 = (0);
var state_68989__$1 = (function (){var statearr_69005 = state_68989;
(statearr_69005[(10)] = inst_68973);

(statearr_69005[(11)] = inst_68975);

(statearr_69005[(7)] = inst_68879);

return statearr_69005;
})();
var statearr_69006_69058 = state_68989__$1;
(statearr_69006_69058[(2)] = null);

(statearr_69006_69058[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (13))){
var inst_68944 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69007_69059 = state_68989__$1;
(statearr_69007_69059[(2)] = inst_68944);

(statearr_69007_69059[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (22))){
var state_68989__$1 = state_68989;
var statearr_69008_69060 = state_68989__$1;
(statearr_69008_69060[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (29))){
var inst_68983 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69010_69061 = state_68989__$1;
(statearr_69010_69061[(2)] = inst_68983);

(statearr_69010_69061[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (6))){
var inst_68890 = (state_68989[(9)]);
var inst_68952 = (inst_68890 == null);
var state_68989__$1 = state_68989;
if(cljs.core.truth_(inst_68952)){
var statearr_69011_69062 = state_68989__$1;
(statearr_69011_69062[(1)] = (27));

} else {
var statearr_69012_69063 = state_68989__$1;
(statearr_69012_69063[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (28))){
var inst_68890 = (state_68989[(9)]);
var inst_68959 = fluree.db.util.core.exception_QMARK_(inst_68890);
var state_68989__$1 = state_68989;
if(inst_68959){
var statearr_69013_69064 = state_68989__$1;
(statearr_69013_69064[(1)] = (30));

} else {
var statearr_69014_69065 = state_68989__$1;
(statearr_69014_69065[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (25))){
var state_68989__$1 = state_68989;
var statearr_69015_69066 = state_68989__$1;
(statearr_69015_69066[(2)] = null);

(statearr_69015_69066[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (34))){
var state_68989__$1 = state_68989;
var statearr_69016_69067 = state_68989__$1;
(statearr_69016_69067[(2)] = null);

(statearr_69016_69067[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (17))){
var inst_68938 = (state_68989[(2)]);
var inst_68939 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68940 = fluree.db.connection.close_websocket(inst_68939);
var inst_68941 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68942 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_68941);
var state_68989__$1 = (function (){var statearr_69017 = state_68989;
(statearr_69017[(12)] = inst_68938);

(statearr_69017[(13)] = inst_68940);

return statearr_69017;
})();
var statearr_69018_69068 = state_68989__$1;
(statearr_69018_69068[(2)] = inst_68942);

(statearr_69018_69068[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (3))){
var inst_68987 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68989__$1,inst_68987);
} else {
if((state_val_68990 === (12))){
var inst_68902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68903 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_68904 = (new cljs.core.PersistentVector(null,1,(5),inst_68902,inst_68903,null));
var inst_68905 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68904);
var inst_68906 = keep_alive_fn;
var inst_68907 = (keep_alive_fn == null);
var state_68989__$1 = (function (){var statearr_69019 = state_68989;
(statearr_69019[(14)] = inst_68905);

(statearr_69019[(15)] = inst_68906);

return statearr_69019;
})();
if(cljs.core.truth_(inst_68907)){
var statearr_69020_69069 = state_68989__$1;
(statearr_69020_69069[(1)] = (15));

} else {
var statearr_69021_69070 = state_68989__$1;
(statearr_69021_69070[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (2))){
var inst_68884 = (state_68989[(8)]);
var inst_68884__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_68885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68886 = [sub_chan,inst_68884__$1];
var inst_68887 = (new cljs.core.PersistentVector(null,2,(5),inst_68885,inst_68886,null));
var state_68989__$1 = (function (){var statearr_69022 = state_68989;
(statearr_69022[(8)] = inst_68884__$1);

return statearr_69022;
})();
return cljs.core.async.ioc_alts_BANG_(state_68989__$1,(4),inst_68887);
} else {
if((state_val_68990 === (23))){
var inst_68934 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69023_69071 = state_68989__$1;
(statearr_69023_69071[(2)] = inst_68934);

(statearr_69023_69071[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (35))){
var inst_68979 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69024_69072 = state_68989__$1;
(statearr_69024_69072[(2)] = inst_68979);

(statearr_69024_69072[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (19))){
var inst_68918 = typeof keep_alive_fn === 'string';
var state_68989__$1 = state_68989;
if(cljs.core.truth_(inst_68918)){
var statearr_69025_69073 = state_68989__$1;
(statearr_69025_69073[(1)] = (21));

} else {
var statearr_69026_69074 = state_68989__$1;
(statearr_69026_69074[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (11))){
var inst_68897 = fluree.db.connection.reconnect_conn(conn);
var state_68989__$1 = state_68989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68989__$1,(14),inst_68897);
} else {
if((state_val_68990 === (9))){
var inst_68879 = (state_68989[(7)]);
var inst_68946 = fluree.db.connection.ping_transactor(req_chan);
var inst_68947 = (inst_68879 + (1));
var inst_68879__$1 = inst_68947;
var state_68989__$1 = (function (){var statearr_69027 = state_68989;
(statearr_69027[(16)] = inst_68946);

(statearr_69027[(7)] = inst_68879__$1);

return statearr_69027;
})();
var statearr_69028_69075 = state_68989__$1;
(statearr_69028_69075[(2)] = null);

(statearr_69028_69075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (5))){
var inst_68879 = (state_68989[(7)]);
var inst_68894 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_68879);
var state_68989__$1 = state_68989;
if(inst_68894){
var statearr_69029_69076 = state_68989__$1;
(statearr_69029_69076[(1)] = (8));

} else {
var statearr_69030_69077 = state_68989__$1;
(statearr_69030_69077[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (14))){
var inst_68899 = (state_68989[(2)]);
var inst_68879 = (0);
var state_68989__$1 = (function (){var statearr_69031 = state_68989;
(statearr_69031[(17)] = inst_68899);

(statearr_69031[(7)] = inst_68879);

return statearr_69031;
})();
var statearr_69032_69078 = state_68989__$1;
(statearr_69032_69078[(2)] = null);

(statearr_69032_69078[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (26))){
var inst_68932 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69033_69079 = state_68989__$1;
(statearr_69033_69079[(2)] = inst_68932);

(statearr_69033_69079[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (16))){
var inst_68914 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_68989__$1 = state_68989;
if(inst_68914){
var statearr_69034_69080 = state_68989__$1;
(statearr_69034_69080[(1)] = (18));

} else {
var statearr_69035_69081 = state_68989__$1;
(statearr_69035_69081[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (30))){
var inst_68890 = (state_68989[(9)]);
var inst_68961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68962 = [inst_68890];
var inst_68963 = (new cljs.core.PersistentVector(null,1,(5),inst_68961,inst_68962,null));
var inst_68964 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68963);
var inst_68879 = (0);
var state_68989__$1 = (function (){var statearr_69036 = state_68989;
(statearr_69036[(7)] = inst_68879);

(statearr_69036[(18)] = inst_68964);

return statearr_69036;
})();
var statearr_69037_69082 = state_68989__$1;
(statearr_69037_69082[(2)] = null);

(statearr_69037_69082[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (10))){
var inst_68950 = (state_68989[(2)]);
var state_68989__$1 = state_68989;
var statearr_69038_69083 = state_68989__$1;
(statearr_69038_69083[(2)] = inst_68950);

(statearr_69038_69083[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (18))){
var inst_68916 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_68989__$1 = state_68989;
var statearr_69039_69084 = state_68989__$1;
(statearr_69039_69084[(2)] = inst_68916);

(statearr_69039_69084[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68990 === (8))){
var state_68989__$1 = state_68989;
if(cljs.core.truth_(keep_alive)){
var statearr_69040_69085 = state_68989__$1;
(statearr_69040_69085[(1)] = (11));

} else {
var statearr_69041_69086 = state_68989__$1;
(statearr_69041_69086[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0 = (function (){
var statearr_69042 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69042[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2684__auto__);

(statearr_69042[(1)] = (1));

return statearr_69042;
});
var fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1 = (function (state_68989){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_68989);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69043){var ex__2687__auto__ = e69043;
var statearr_69044_69087 = state_68989;
(statearr_69044_69087[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_68989[(4)]))){
var statearr_69045_69088 = state_68989;
(statearr_69045_69088[(1)] = cljs.core.first((state_68989[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69089 = state_68989;
state_68989 = G__69089;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__ = function(state_68989){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1.call(this,state_68989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2684__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69046 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69046[(6)] = c__2706__auto__);

return statearr_69046;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__69091 = arguments.length;
switch (G__69091) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__69092 = opts;
var map__69092__$1 = cljs.core.__destructure_map(map__69092);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69092__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69092__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69144){
var state_val_69145 = (state_69144[(1)]);
if((state_val_69145 === (7))){
var inst_69102 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_69103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69104 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_69105 = (new cljs.core.PersistentVector(null,2,(5),inst_69103,inst_69104,null));
var inst_69106 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_69102,inst_69105);
var state_69144__$1 = state_69144;
var statearr_69146_69177 = state_69144__$1;
(statearr_69146_69177[(2)] = inst_69106);

(statearr_69146_69177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (1))){
var state_69144__$1 = state_69144;
var statearr_69147_69178 = state_69144__$1;
(statearr_69147_69178[(2)] = null);

(statearr_69147_69178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (4))){
var inst_69093 = (state_69144[(2)]);
var state_69144__$1 = state_69144;
var statearr_69148_69179 = state_69144__$1;
(statearr_69148_69179[(2)] = inst_69093);

(statearr_69148_69179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (15))){
var inst_69113 = (state_69144[(7)]);
var inst_69132 = (state_69144[(2)]);
var inst_69133 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_69134 = [(5000),inst_69132,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_69135 = cljs.core.PersistentHashMap.fromArrays(inst_69133,inst_69134);
var inst_69136 = fluree.db.util.xhttp.get(inst_69113,inst_69135);
var state_69144__$1 = state_69144;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69144__$1,(16),inst_69136);
} else {
if((state_val_69145 === (13))){
var inst_69113 = (state_69144[(7)]);
var inst_69123 = (state_69144[(8)]);
var inst_69125 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_69126 = [inst_69123];
var inst_69127 = cljs.core.PersistentHashMap.fromArrays(inst_69125,inst_69126);
var inst_69128 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_69113,inst_69127,private$);
var inst_69129 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_69128);
var state_69144__$1 = state_69144;
var statearr_69149_69180 = state_69144__$1;
(statearr_69149_69180[(2)] = inst_69129);

(statearr_69149_69180[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (6))){
var inst_69099 = (state_69144[(9)]);
var state_69144__$1 = state_69144;
var statearr_69150_69181 = state_69144__$1;
(statearr_69150_69181[(2)] = inst_69099);

(statearr_69150_69181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (3))){
var inst_69142 = (state_69144[(2)]);
var state_69144__$1 = state_69144;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69144__$1,inst_69142);
} else {
if((state_val_69145 === (12))){
var inst_69123 = (state_69144[(2)]);
var state_69144__$1 = (function (){var statearr_69151 = state_69144;
(statearr_69151[(8)] = inst_69123);

return statearr_69151;
})();
if(cljs.core.truth_(private$)){
var statearr_69152_69182 = state_69144__$1;
(statearr_69152_69182[(1)] = (13));

} else {
var statearr_69153_69183 = state_69144__$1;
(statearr_69153_69183[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (2))){
var inst_69099 = (state_69144[(9)]);
var _ = (function (){var statearr_69154 = state_69144;
(statearr_69154[(4)] = cljs.core.cons((5),(state_69144[(4)])));

return statearr_69154;
})();
var inst_69099__$1 = jwt;
var state_69144__$1 = (function (){var statearr_69155 = state_69144;
(statearr_69155[(9)] = inst_69099__$1);

return statearr_69155;
})();
if(cljs.core.truth_(inst_69099__$1)){
var statearr_69156_69184 = state_69144__$1;
(statearr_69156_69184[(1)] = (6));

} else {
var statearr_69157_69185 = state_69144__$1;
(statearr_69157_69185[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (11))){
var inst_69117 = (state_69144[(10)]);
var state_69144__$1 = state_69144;
var statearr_69159_69186 = state_69144__$1;
(statearr_69159_69186[(2)] = inst_69117);

(statearr_69159_69186[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (9))){
var inst_69108 = (state_69144[(11)]);
var inst_69109 = (state_69144[(12)]);
var inst_69112 = (state_69144[(2)]);
var inst_69113 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69112),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69109)].join('');
var inst_69115 = ["Accept"];
var inst_69116 = ["application/json"];
var inst_69117 = cljs.core.PersistentHashMap.fromArrays(inst_69115,inst_69116);
var state_69144__$1 = (function (){var statearr_69160 = state_69144;
(statearr_69160[(10)] = inst_69117);

(statearr_69160[(7)] = inst_69113);

return statearr_69160;
})();
if(cljs.core.truth_(inst_69108)){
var statearr_69161_69187 = state_69144__$1;
(statearr_69161_69187[(1)] = (10));

} else {
var statearr_69162_69188 = state_69144__$1;
(statearr_69162_69188[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (5))){
var _ = (function (){var statearr_69163 = state_69144;
(statearr_69163[(4)] = cljs.core.rest((state_69144[(4)])));

return statearr_69163;
})();
var state_69144__$1 = state_69144;
var ex69158 = (state_69144__$1[(2)]);
var statearr_69164_69189 = state_69144__$1;
(statearr_69164_69189[(5)] = ex69158);


if((ex69158 instanceof Error)){
var statearr_69165_69190 = state_69144__$1;
(statearr_69165_69190[(1)] = (4));

(statearr_69165_69190[(5)] = null);

} else {
throw ex69158;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (14))){
var inst_69123 = (state_69144[(8)]);
var state_69144__$1 = state_69144;
var statearr_69166_69191 = state_69144__$1;
(statearr_69166_69191[(2)] = inst_69123);

(statearr_69166_69191[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (16))){
var inst_69138 = (state_69144[(2)]);
var inst_69139 = fluree.db.util.async.throw_err(inst_69138);
var _ = (function (){var statearr_69167 = state_69144;
(statearr_69167[(4)] = cljs.core.rest((state_69144[(4)])));

return statearr_69167;
})();
var state_69144__$1 = state_69144;
var statearr_69168_69192 = state_69144__$1;
(statearr_69168_69192[(2)] = inst_69139);

(statearr_69168_69192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (10))){
var inst_69117 = (state_69144[(10)]);
var inst_69108 = (state_69144[(11)]);
var inst_69119 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69108)].join('');
var inst_69120 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69117,"Authorization",inst_69119);
var state_69144__$1 = state_69144;
var statearr_69169_69193 = state_69144__$1;
(statearr_69169_69193[(2)] = inst_69120);

(statearr_69169_69193[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69145 === (8))){
var inst_69108 = (state_69144[(2)]);
var inst_69109 = clojure.string.replace(k,"_","/");
var inst_69110 = fluree.db.connection.get_server(conn_id,servers);
var state_69144__$1 = (function (){var statearr_69170 = state_69144;
(statearr_69170[(11)] = inst_69108);

(statearr_69170[(12)] = inst_69109);

return statearr_69170;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69144__$1,(9),inst_69110);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_69171 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69171[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_69171[(1)] = (1));

return statearr_69171;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_69144){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69144);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69172){var ex__2687__auto__ = e69172;
var statearr_69173_69194 = state_69144;
(statearr_69173_69194[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69144[(4)]))){
var statearr_69174_69195 = state_69144;
(statearr_69174_69195[(1)] = cljs.core.first((state_69144[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69196 = state_69144;
state_69144 = G__69196;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_69144){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_69144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69175 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69175[(6)] = c__2706__auto__);

return statearr_69175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___69221 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___69221)){
var v_69222 = temp__5802__auto___69221;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_69222);
} else {
var c__2706__auto___69223 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69208){
var state_val_69209 = (state_69208[(1)]);
if((state_val_69209 === (1))){
var inst_69197 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_69208__$1 = state_69208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69208__$1,(2),inst_69197);
} else {
if((state_val_69209 === (2))){
var inst_69199 = (state_69208[(7)]);
var inst_69199__$1 = (state_69208[(2)]);
var inst_69200 = fluree.db.util.core.exception_QMARK_(inst_69199__$1);
var state_69208__$1 = (function (){var statearr_69210 = state_69208;
(statearr_69210[(7)] = inst_69199__$1);

return statearr_69210;
})();
if(inst_69200){
var statearr_69211_69224 = state_69208__$1;
(statearr_69211_69224[(1)] = (3));

} else {
var statearr_69212_69225 = state_69208__$1;
(statearr_69212_69225[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69209 === (3))){
var state_69208__$1 = state_69208;
var statearr_69213_69226 = state_69208__$1;
(statearr_69213_69226[(2)] = null);

(statearr_69213_69226[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69209 === (4))){
var inst_69199 = (state_69208[(7)]);
var inst_69203 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_69199);
var state_69208__$1 = state_69208;
var statearr_69214_69227 = state_69208__$1;
(statearr_69214_69227[(2)] = inst_69203);

(statearr_69214_69227[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69209 === (5))){
var inst_69199 = (state_69208[(7)]);
var inst_69205 = (state_69208[(2)]);
var inst_69206 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_69199);
var state_69208__$1 = (function (){var statearr_69215 = state_69208;
(statearr_69215[(8)] = inst_69205);

return statearr_69215;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_69208__$1,inst_69206);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0 = (function (){
var statearr_69216 = [null,null,null,null,null,null,null,null,null];
(statearr_69216[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__);

(statearr_69216[(1)] = (1));

return statearr_69216;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1 = (function (state_69208){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69208);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69217){var ex__2687__auto__ = e69217;
var statearr_69218_69228 = state_69208;
(statearr_69218_69228[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69208[(4)]))){
var statearr_69219_69229 = state_69208;
(statearr_69219_69229[(1)] = cljs.core.first((state_69208[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69230 = state_69208;
state_69208 = G__69230;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__ = function(state_69208){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1.call(this,state_69208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69220 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69220[(6)] = c__2706__auto___69223);

return statearr_69220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__69231_SHARP_){
if(cljs.core.truth_(p1__69231_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__69232_SHARP_){
var or__5045__auto__ = p1__69232_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e69233){var e = e69233;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__69234 = opts;
var map__69234__$1 = cljs.core.__destructure_map(map__69234);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__69234__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__69234__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__69235_69236 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__69235_69236.cljs$core$IFn$_invoke$arity$0 ? fexpr__69235_69236.cljs$core$IFn$_invoke$arity$0() : fexpr__69235_69236.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69280 = arguments.length;
var i__5770__auto___69281 = (0);
while(true){
if((i__5770__auto___69281 < len__5769__auto___69280)){
args__5775__auto__.push((arguments[i__5770__auto___69281]));

var G__69282 = (i__5770__auto___69281 + (1));
i__5770__auto___69281 = G__69282;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__69239){
var vec__69240 = p__69239;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69240,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2706__auto___69283 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69263){
var state_val_69264 = (state_69263[(1)]);
if((state_val_69264 === (1))){
var inst_69243 = fluree.db.connection.get_socket(conn);
var state_69263__$1 = state_69263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69263__$1,(2),inst_69243);
} else {
if((state_val_69264 === (2))){
var inst_69246 = (state_69263[(7)]);
var inst_69245 = (state_69263[(8)]);
var inst_69245__$1 = (state_69263[(2)]);
var inst_69246__$1 = (inst_69245__$1 == null);
var state_69263__$1 = (function (){var statearr_69265 = state_69263;
(statearr_69265[(7)] = inst_69246__$1);

(statearr_69265[(8)] = inst_69245__$1);

return statearr_69265;
})();
if(cljs.core.truth_(inst_69246__$1)){
var statearr_69266_69284 = state_69263__$1;
(statearr_69266_69284[(1)] = (3));

} else {
var statearr_69267_69285 = state_69263__$1;
(statearr_69267_69285[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69264 === (3))){
var inst_69246 = (state_69263[(7)]);
var state_69263__$1 = state_69263;
var statearr_69268_69286 = state_69263__$1;
(statearr_69268_69286[(2)] = inst_69246);

(statearr_69268_69286[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69264 === (4))){
var inst_69245 = (state_69263[(8)]);
var inst_69249 = fluree.db.util.core.exception_QMARK_(inst_69245);
var state_69263__$1 = state_69263;
var statearr_69269_69287 = state_69263__$1;
(statearr_69269_69287[(2)] = inst_69249);

(statearr_69269_69287[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69264 === (5))){
var inst_69251 = (state_69263[(2)]);
var state_69263__$1 = state_69263;
if(cljs.core.truth_(inst_69251)){
var statearr_69270_69288 = state_69263__$1;
(statearr_69270_69288[(1)] = (6));

} else {
var statearr_69271_69289 = state_69263__$1;
(statearr_69271_69289[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69264 === (6))){
var inst_69245 = (state_69263[(8)]);
var inst_69253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69254 = [inst_69245,"Cannot establish connection to a healthy server, disconnecting."];
var inst_69255 = (new cljs.core.PersistentVector(null,2,(5),inst_69253,inst_69254,null));
var inst_69256 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69255);
var inst_69257 = cljs.core.async.close_BANG_(conn);
var state_69263__$1 = (function (){var statearr_69272 = state_69263;
(statearr_69272[(9)] = inst_69256);

return statearr_69272;
})();
var statearr_69273_69290 = state_69263__$1;
(statearr_69273_69290[(2)] = inst_69257);

(statearr_69273_69290[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69264 === (7))){
var inst_69259 = fluree.db.connection.msg_consumer(conn);
var state_69263__$1 = state_69263;
var statearr_69274_69291 = state_69263__$1;
(statearr_69274_69291[(2)] = inst_69259);

(statearr_69274_69291[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69264 === (8))){
var inst_69261 = (state_69263[(2)]);
var state_69263__$1 = state_69263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69263__$1,inst_69261);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2684__auto__ = null;
var fluree$db$connection$state_machine__2684__auto____0 = (function (){
var statearr_69275 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69275[(0)] = fluree$db$connection$state_machine__2684__auto__);

(statearr_69275[(1)] = (1));

return statearr_69275;
});
var fluree$db$connection$state_machine__2684__auto____1 = (function (state_69263){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69263);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69276){var ex__2687__auto__ = e69276;
var statearr_69277_69292 = state_69263;
(statearr_69277_69292[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69263[(4)]))){
var statearr_69278_69293 = state_69263;
(statearr_69278_69293[(1)] = cljs.core.first((state_69263[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69294 = state_69263;
state_69263 = G__69294;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2684__auto__ = function(state_69263){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2684__auto____1.call(this,state_69263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2684__auto____0;
fluree$db$connection$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2684__auto____1;
return fluree$db$connection$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69279 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69279[(6)] = c__2706__auto___69283);

return statearr_69279;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq69237){
var G__69238 = cljs.core.first(seq69237);
var seq69237__$1 = cljs.core.next(seq69237);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69238,seq69237__$1);
}));

