// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.query.fql_resp');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___69931 = arguments.length;
var i__5770__auto___69932 = (0);
while(true){
if((i__5770__auto___69932 < len__5769__auto___69931)){
args__5775__auto__.push((arguments[i__5770__auto___69932]));

var G__69933 = (i__5770__auto___69932 + (1));
i__5770__auto___69932 = G__69933;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__69860){
var vec__69861 = p__69860;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69861,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___69934 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_69908){
var state_val_69909 = (state_69908[(1)]);
if((state_val_69909 === (7))){
var inst_69885 = (state_69908[(7)]);
var inst_69894 = (state_69908[(8)]);
var inst_69896 = fluree.db.time_travel.as_of_block(inst_69894,inst_69885);
var state_69908__$1 = state_69908;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69908__$1,(10),inst_69896);
} else {
if((state_val_69909 === (1))){
var state_69908__$1 = state_69908;
var statearr_69910_69935 = state_69908__$1;
(statearr_69910_69935[(2)] = null);

(statearr_69910_69935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69909 === (4))){
var inst_69864 = (state_69908[(2)]);
var inst_69865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69866 = [inst_69864];
var inst_69867 = (new cljs.core.PersistentVector(null,1,(5),inst_69865,inst_69866,null));
var inst_69868 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69867);
var inst_69869 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69864);
var inst_69870 = cljs.core.async.close_BANG_(pc);
var state_69908__$1 = (function (){var statearr_69911 = state_69908;
(statearr_69911[(9)] = inst_69869);

(statearr_69911[(10)] = inst_69868);

return statearr_69911;
})();
var statearr_69912_69936 = state_69908__$1;
(statearr_69912_69936[(2)] = inst_69870);

(statearr_69912_69936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69909 === (6))){
var inst_69885 = (state_69908[(7)]);
var inst_69888 = (state_69908[(11)]);
var inst_69889 = (state_69908[(12)]);
var inst_69892 = (state_69908[(2)]);
var inst_69893 = fluree.db.util.async.throw_err(inst_69892);
var inst_69894 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_69893,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_69888,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_69889], 0));
var state_69908__$1 = (function (){var statearr_69913 = state_69908;
(statearr_69913[(8)] = inst_69894);

return statearr_69913;
})();
if(cljs.core.truth_(inst_69885)){
var statearr_69914_69937 = state_69908__$1;
(statearr_69914_69937[(1)] = (7));

} else {
var statearr_69915_69938 = state_69908__$1;
(statearr_69915_69938[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69909 === (3))){
var inst_69906 = (state_69908[(2)]);
var state_69908__$1 = state_69908;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69908__$1,inst_69906);
} else {
if((state_val_69909 === (2))){
var _ = (function (){var statearr_69917 = state_69908;
(statearr_69917[(4)] = cljs.core.cons((5),(state_69908[(4)])));

return statearr_69917;
})();
var inst_69880 = opts;
var inst_69881 = cljs.core.__destructure_map(inst_69880);
var inst_69882 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69881,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_69883 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69881,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_69884 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69881,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69885 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69881,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69886 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_69887 = fluree.db.session.resolve_ledger.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var inst_69888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69887,(0),null);
var inst_69889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69887,(1),null);
var inst_69890 = fluree.db.session.db(conn,ledger,opts);
var state_69908__$1 = (function (){var statearr_69918 = state_69908;
(statearr_69918[(7)] = inst_69885);

(statearr_69918[(13)] = inst_69882);

(statearr_69918[(14)] = inst_69886);

(statearr_69918[(11)] = inst_69888);

(statearr_69918[(15)] = inst_69884);

(statearr_69918[(16)] = inst_69883);

(statearr_69918[(12)] = inst_69889);

return statearr_69918;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69908__$1,(6),inst_69890);
} else {
if((state_val_69909 === (9))){
var inst_69902 = (state_69908[(2)]);
var inst_69903 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_69902);
var _ = (function (){var statearr_69919 = state_69908;
(statearr_69919[(4)] = cljs.core.rest((state_69908[(4)])));

return statearr_69919;
})();
var state_69908__$1 = state_69908;
var statearr_69920_69939 = state_69908__$1;
(statearr_69920_69939[(2)] = inst_69903);

(statearr_69920_69939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69909 === (5))){
var _ = (function (){var statearr_69921 = state_69908;
(statearr_69921[(4)] = cljs.core.rest((state_69908[(4)])));

return statearr_69921;
})();
var state_69908__$1 = state_69908;
var ex69916 = (state_69908__$1[(2)]);
var statearr_69922_69940 = state_69908__$1;
(statearr_69922_69940[(5)] = ex69916);


var statearr_69923_69941 = state_69908__$1;
(statearr_69923_69941[(1)] = (4));

(statearr_69923_69941[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69909 === (10))){
var inst_69898 = (state_69908[(2)]);
var inst_69899 = fluree.db.util.async.throw_err(inst_69898);
var state_69908__$1 = state_69908;
var statearr_69924_69942 = state_69908__$1;
(statearr_69924_69942[(2)] = inst_69899);

(statearr_69924_69942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69909 === (8))){
var inst_69894 = (state_69908[(8)]);
var state_69908__$1 = state_69908;
var statearr_69925_69943 = state_69908__$1;
(statearr_69925_69943[(2)] = inst_69894);

(statearr_69925_69943[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_69926 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69926[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_69926[(1)] = (1));

return statearr_69926;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_69908){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_69908);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e69927){var ex__2687__auto__ = e69927;
var statearr_69928_69944 = state_69908;
(statearr_69928_69944[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_69908[(4)]))){
var statearr_69929_69945 = state_69908;
(statearr_69929_69945[(1)] = cljs.core.first((state_69908[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69946 = state_69908;
state_69908 = G__69946;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_69908){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_69908);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_69930 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_69930[(6)] = c__2706__auto___69934);

return statearr_69930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq69857){
var G__69858 = cljs.core.first(seq69857);
var seq69857__$1 = cljs.core.next(seq69857);
var G__69859 = cljs.core.first(seq69857__$1);
var seq69857__$2 = cljs.core.next(seq69857__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69858,G__69859,seq69857__$2);
}));

fluree.db.api_js.ledger_ident_QMARK_ = (function fluree$db$api_js$ledger_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
var and__5043__auto____$1 = open_api;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,ledger_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
return open_api;
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.api_js.ledger_ident_QMARK_(val);
if(and__5043__auto__){
return auth;
} else {
return and__5043__auto__;
}
})())){
var ledger_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,ledger_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__69948 = arguments.length;
switch (G__69948) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70077){
var state_val_70078 = (state_70077[(1)]);
if((state_val_70078 === (7))){
var inst_69977 = (state_70077[(7)]);
var inst_69967 = (state_70077[(8)]);
var inst_69979 = fluree.db.time_travel.as_of_block(inst_69977,inst_69967);
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70077__$1,(10),inst_69979);
} else {
if((state_val_70078 === (20))){
var inst_69971 = (state_70077[(9)]);
var state_70077__$1 = state_70077;
var statearr_70079_70159 = state_70077__$1;
(statearr_70079_70159[(2)] = inst_69971);

(statearr_70079_70159[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (27))){
var inst_69965 = (state_70077[(10)]);
var state_70077__$1 = state_70077;
var statearr_70080_70160 = state_70077__$1;
(statearr_70080_70160[(2)] = inst_69965);

(statearr_70080_70160[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (1))){
var state_70077__$1 = state_70077;
var statearr_70081_70161 = state_70077__$1;
(statearr_70081_70161[(2)] = null);

(statearr_70081_70161[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (24))){
var inst_69974 = (state_70077[(11)]);
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_69974)){
var statearr_70082_70162 = state_70077__$1;
(statearr_70082_70162[(1)] = (26));

} else {
var statearr_70083_70163 = state_70077__$1;
(statearr_70083_70163[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (39))){
var inst_70039 = (state_70077[(12)]);
var inst_70042 = cljs.core.ex_data(inst_70039);
var inst_70043 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70044 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_70042);
var inst_70045 = cljs.core.ex_message(inst_70039);
var inst_70046 = [inst_70044,inst_70045,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70047 = cljs.core.PersistentHashMap.fromArrays(inst_70043,inst_70046);
var state_70077__$1 = state_70077;
var statearr_70084_70164 = state_70077__$1;
(statearr_70084_70164[(2)] = inst_70047);

(statearr_70084_70164[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (46))){
var inst_70039 = (state_70077[(12)]);
var state_70077__$1 = state_70077;
var statearr_70085_70165 = state_70077__$1;
(statearr_70085_70165[(2)] = inst_70039);

(statearr_70085_70165[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (4))){
var inst_69949 = (state_70077[(2)]);
var inst_69950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69951 = [inst_69949];
var inst_69952 = (new cljs.core.PersistentVector(null,1,(5),inst_69950,inst_69951,null));
var inst_69953 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_69952);
var inst_69954 = cljs.core.ex_data(inst_69949);
var inst_69955 = cljs.core.ex_message(inst_69949);
var inst_69956 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_69954,new cljs.core.Keyword(null,"message","message",-406056002),inst_69955);
var state_70077__$1 = (function (){var statearr_70086 = state_70077;
(statearr_70086[(13)] = inst_69953);

return statearr_70086;
})();
var statearr_70087_70166 = state_70077__$1;
(statearr_70087_70166[(2)] = inst_69956);

(statearr_70087_70166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (15))){
var state_70077__$1 = state_70077;
var statearr_70088_70167 = state_70077__$1;
(statearr_70088_70167[(2)] = (1000000));

(statearr_70088_70167[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (48))){
var inst_70039 = (state_70077[(12)]);
var state_70077__$1 = state_70077;
var statearr_70089_70168 = state_70077__$1;
(statearr_70089_70168[(2)] = inst_70039);

(statearr_70089_70168[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (50))){
var inst_70066 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70090_70169 = state_70077__$1;
(statearr_70090_70169[(2)] = inst_70066);

(statearr_70090_70169[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (21))){
var inst_69970 = (state_70077[(14)]);
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_69970)){
var statearr_70091_70170 = state_70077__$1;
(statearr_70091_70170[(1)] = (23));

} else {
var statearr_70092_70171 = state_70077__$1;
(statearr_70092_70171[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (31))){
var inst_70028 = (state_70077[(2)]);
var inst_70029 = cljs.core.not(inst_70028);
var state_70077__$1 = state_70077;
if(inst_70029){
var statearr_70093_70172 = state_70077__$1;
(statearr_70093_70172[(1)] = (35));

} else {
var statearr_70094_70173 = state_70077__$1;
(statearr_70094_70173[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (32))){
var inst_69972 = (state_70077[(15)]);
var state_70077__$1 = state_70077;
var statearr_70095_70174 = state_70077__$1;
(statearr_70095_70174[(2)] = inst_69972);

(statearr_70095_70174[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (40))){
var inst_70002 = (state_70077[(16)]);
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_70002)){
var statearr_70096_70175 = state_70077__$1;
(statearr_70096_70175[(1)] = (42));

} else {
var statearr_70097_70176 = state_70077__$1;
(statearr_70097_70176[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (33))){
var inst_69968 = (state_70077[(17)]);
var state_70077__$1 = state_70077;
var statearr_70098_70177 = state_70077__$1;
(statearr_70098_70177[(2)] = inst_69968);

(statearr_70098_70177[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (13))){
var inst_69997 = (state_70077[(18)]);
var inst_69973 = (state_70077[(19)]);
var inst_69995 = (state_70077[(2)]);
var inst_69996 = cljs.core.volatile_BANG_((0));
var inst_69997__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_69973);
var state_70077__$1 = (function (){var statearr_70099 = state_70077;
(statearr_70099[(20)] = inst_69995);

(statearr_70099[(21)] = inst_69996);

(statearr_70099[(18)] = inst_69997__$1);

return statearr_70099;
})();
if(cljs.core.truth_(inst_69997__$1)){
var statearr_70100_70178 = state_70077__$1;
(statearr_70100_70178[(1)] = (14));

} else {
var statearr_70101_70179 = state_70077__$1;
(statearr_70101_70179[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (22))){
var inst_70018 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70102_70180 = state_70077__$1;
(statearr_70102_70180[(2)] = inst_70018);

(statearr_70102_70180[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (36))){
var inst_69985 = (state_70077[(22)]);
var inst_70004 = (state_70077[(23)]);
var inst_70035 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70004);
var inst_70036 = fluree.db.query.fql.query(inst_69985,inst_70035);
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70077__$1,(38),inst_70036);
} else {
if((state_val_70078 === (41))){
var inst_70070 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70103_70181 = state_70077__$1;
(statearr_70103_70181[(2)] = inst_70070);

(statearr_70103_70181[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (43))){
var state_70077__$1 = state_70077;
var statearr_70104_70182 = state_70077__$1;
(statearr_70104_70182[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (29))){
var inst_69972 = (state_70077[(15)]);
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_69972)){
var statearr_70106_70183 = state_70077__$1;
(statearr_70106_70183[(1)] = (32));

} else {
var statearr_70107_70184 = state_70077__$1;
(statearr_70107_70184[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (44))){
var inst_70068 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70108_70185 = state_70077__$1;
(statearr_70108_70185[(2)] = inst_70068);

(statearr_70108_70185[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (6))){
var inst_69967 = (state_70077[(8)]);
var inst_69976 = (state_70077[(2)]);
var inst_69977 = fluree.db.util.async.throw_err(inst_69976);
var state_70077__$1 = (function (){var statearr_70109 = state_70077;
(statearr_70109[(7)] = inst_69977);

return statearr_70109;
})();
if(cljs.core.truth_(inst_69967)){
var statearr_70110_70186 = state_70077__$1;
(statearr_70110_70186[(1)] = (7));

} else {
var statearr_70111_70187 = state_70077__$1;
(statearr_70111_70187[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (28))){
var inst_70014 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70112_70188 = state_70077__$1;
(statearr_70112_70188[(2)] = inst_70014);

(statearr_70112_70188[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (25))){
var inst_70016 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70113_70189 = state_70077__$1;
(statearr_70113_70189[(2)] = inst_70016);

(statearr_70113_70189[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (34))){
var inst_70025 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
var statearr_70114_70190 = state_70077__$1;
(statearr_70114_70190[(2)] = inst_70025);

(statearr_70114_70190[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (17))){
var inst_69966 = (state_70077[(24)]);
var state_70077__$1 = state_70077;
var statearr_70115_70191 = state_70077__$1;
(statearr_70115_70191[(2)] = inst_69966);

(statearr_70115_70191[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (3))){
var inst_70075 = (state_70077[(2)]);
var state_70077__$1 = state_70077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70077__$1,inst_70075);
} else {
if((state_val_70078 === (12))){
var inst_69993 = cljs.core.PersistentHashMap.EMPTY;
var state_70077__$1 = state_70077;
var statearr_70116_70192 = state_70077__$1;
(statearr_70116_70192[(2)] = inst_69993);

(statearr_70116_70192[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (2))){
var _ = (function (){var statearr_70117 = state_70077;
(statearr_70117[(4)] = cljs.core.cons((5),(state_70077[(4)])));

return statearr_70117;
})();
var inst_69963 = query_map;
var inst_69964 = cljs.core.__destructure_map(inst_69963);
var inst_69965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_69966 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_69967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"block","block",664686210));
var inst_69968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_69969 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_69970 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_69971 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_69972 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_69973 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_69974 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_69964,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_70077__$1 = (function (){var statearr_70118 = state_70077;
(statearr_70118[(25)] = inst_69969);

(statearr_70118[(14)] = inst_69970);

(statearr_70118[(15)] = inst_69972);

(statearr_70118[(9)] = inst_69971);

(statearr_70118[(17)] = inst_69968);

(statearr_70118[(24)] = inst_69966);

(statearr_70118[(19)] = inst_69973);

(statearr_70118[(10)] = inst_69965);

(statearr_70118[(8)] = inst_69967);

(statearr_70118[(11)] = inst_69974);

return statearr_70118;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70077__$1,(6),sources);
} else {
if((state_val_70078 === (23))){
var inst_69970 = (state_70077[(14)]);
var state_70077__$1 = state_70077;
var statearr_70119_70193 = state_70077__$1;
(statearr_70119_70193[(2)] = inst_69970);

(statearr_70119_70193[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (47))){
var inst_70003 = (state_70077[(26)]);
var inst_69985 = (state_70077[(22)]);
var inst_70050 = (state_70077[(27)]);
var inst_69996 = (state_70077[(21)]);
var inst_70056 = (state_70077[(2)]);
var inst_70057 = cljs.core.deref(inst_69996);
var inst_70058 = fluree.db.util.core.response_time_formatted(inst_70003);
var inst_70059 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_69985);
var inst_70060 = [(200),inst_70056,inst_70057,inst_70058,inst_70059];
var inst_70061 = cljs.core.PersistentHashMap.fromArrays(inst_70050,inst_70060);
var state_70077__$1 = state_70077;
var statearr_70120_70194 = state_70077__$1;
(statearr_70120_70194[(2)] = inst_70061);

(statearr_70120_70194[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (35))){
var inst_70031 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70032 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70033 = cljs.core.PersistentHashMap.fromArrays(inst_70031,inst_70032);
var state_70077__$1 = state_70077;
var statearr_70121_70195 = state_70077__$1;
(statearr_70121_70195[(2)] = inst_70033);

(statearr_70121_70195[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (19))){
var inst_70020 = (state_70077[(28)]);
var inst_70020__$1 = (state_70077[(2)]);
var state_70077__$1 = (function (){var statearr_70122 = state_70077;
(statearr_70122[(28)] = inst_70020__$1);

return statearr_70122;
})();
if(cljs.core.truth_(inst_70020__$1)){
var statearr_70123_70196 = state_70077__$1;
(statearr_70123_70196[(1)] = (29));

} else {
var statearr_70124_70197 = state_70077__$1;
(statearr_70124_70197[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (11))){
var inst_69969 = (state_70077[(25)]);
var inst_69985 = (state_70077[(22)]);
var inst_69986 = (state_70077[(29)]);
var inst_69988 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_69985);
var inst_69989 = fluree.db.connection_js.open_api_QMARK_(inst_69986);
var inst_69990 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_69985);
var inst_69991 = fluree.db.api_js.get_sources(inst_69986,inst_69988,inst_69989,inst_69990,inst_69969,db_fn);
var state_70077__$1 = state_70077;
var statearr_70126_70198 = state_70077__$1;
(statearr_70126_70198[(2)] = inst_69991);

(statearr_70126_70198[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (9))){
var inst_69969 = (state_70077[(25)]);
var inst_69985 = (state_70077[(22)]);
var inst_69985__$1 = (state_70077[(2)]);
var inst_69986 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_69985__$1);
var state_70077__$1 = (function (){var statearr_70127 = state_70077;
(statearr_70127[(22)] = inst_69985__$1);

(statearr_70127[(29)] = inst_69986);

return statearr_70127;
})();
if(cljs.core.truth_(inst_69969)){
var statearr_70128_70199 = state_70077__$1;
(statearr_70128_70199[(1)] = (11));

} else {
var statearr_70129_70200 = state_70077__$1;
(statearr_70129_70200[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (5))){
var _ = (function (){var statearr_70130 = state_70077;
(statearr_70130[(4)] = cljs.core.rest((state_70077[(4)])));

return statearr_70130;
})();
var state_70077__$1 = state_70077;
var ex70125 = (state_70077__$1[(2)]);
var statearr_70131_70201 = state_70077__$1;
(statearr_70131_70201[(5)] = ex70125);


var statearr_70132_70202 = state_70077__$1;
(statearr_70132_70202[(1)] = (4));

(statearr_70132_70202[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (14))){
var inst_69997 = (state_70077[(18)]);
var state_70077__$1 = state_70077;
var statearr_70133_70203 = state_70077__$1;
(statearr_70133_70203[(2)] = inst_69997);

(statearr_70133_70203[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (45))){
var inst_70039 = (state_70077[(12)]);
var inst_70053 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_70039);
var state_70077__$1 = state_70077;
var statearr_70134_70204 = state_70077__$1;
(statearr_70134_70204[(2)] = inst_70053);

(statearr_70134_70204[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (26))){
var inst_69974 = (state_70077[(11)]);
var state_70077__$1 = state_70077;
var statearr_70135_70205 = state_70077__$1;
(statearr_70135_70205[(2)] = inst_69974);

(statearr_70135_70205[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (16))){
var inst_69995 = (state_70077[(20)]);
var inst_69966 = (state_70077[(24)]);
var inst_69996 = (state_70077[(21)]);
var inst_69973 = (state_70077[(19)]);
var inst_70001 = (state_70077[(2)]);
var inst_70002 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_69973);
var inst_70003 = fluree.db.util.core.current_time_millis();
var inst_70004 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_69973,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_69995,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_70001,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_69996], 0));
var state_70077__$1 = (function (){var statearr_70136 = state_70077;
(statearr_70136[(26)] = inst_70003);

(statearr_70136[(16)] = inst_70002);

(statearr_70136[(23)] = inst_70004);

return statearr_70136;
})();
if(cljs.core.truth_(inst_69966)){
var statearr_70137_70206 = state_70077__$1;
(statearr_70137_70206[(1)] = (17));

} else {
var statearr_70138_70207 = state_70077__$1;
(statearr_70138_70207[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (38))){
var inst_70039 = (state_70077[(12)]);
var inst_70038 = (state_70077[(2)]);
var inst_70039__$1 = fluree.db.util.async.throw_err(inst_70038);
var inst_70040 = (inst_70039__$1 instanceof cljs.core.ExceptionInfo);
var state_70077__$1 = (function (){var statearr_70139 = state_70077;
(statearr_70139[(12)] = inst_70039__$1);

return statearr_70139;
})();
if(cljs.core.truth_(inst_70040)){
var statearr_70140_70208 = state_70077__$1;
(statearr_70140_70208[(1)] = (39));

} else {
var statearr_70141_70209 = state_70077__$1;
(statearr_70141_70209[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (30))){
var inst_70020 = (state_70077[(28)]);
var state_70077__$1 = state_70077;
var statearr_70142_70210 = state_70077__$1;
(statearr_70142_70210[(2)] = inst_70020);

(statearr_70142_70210[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (10))){
var inst_69981 = (state_70077[(2)]);
var inst_69982 = fluree.db.util.async.throw_err(inst_69981);
var state_70077__$1 = state_70077;
var statearr_70143_70211 = state_70077__$1;
(statearr_70143_70211[(2)] = inst_69982);

(statearr_70143_70211[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (18))){
var inst_69971 = (state_70077[(9)]);
var state_70077__$1 = state_70077;
if(cljs.core.truth_(inst_69971)){
var statearr_70144_70212 = state_70077__$1;
(statearr_70144_70212[(1)] = (20));

} else {
var statearr_70145_70213 = state_70077__$1;
(statearr_70145_70213[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (42))){
var inst_70039 = (state_70077[(12)]);
var inst_70050 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70051 = cljs.core.sequential_QMARK_(inst_70039);
var state_70077__$1 = (function (){var statearr_70146 = state_70077;
(statearr_70146[(27)] = inst_70050);

return statearr_70146;
})();
if(inst_70051){
var statearr_70147_70214 = state_70077__$1;
(statearr_70147_70214[(1)] = (45));

} else {
var statearr_70148_70215 = state_70077__$1;
(statearr_70148_70215[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (37))){
var inst_70072 = (state_70077[(2)]);
var _ = (function (){var statearr_70149 = state_70077;
(statearr_70149[(4)] = cljs.core.rest((state_70077[(4)])));

return statearr_70149;
})();
var state_70077__$1 = state_70077;
var statearr_70150_70216 = state_70077__$1;
(statearr_70150_70216[(2)] = inst_70072);

(statearr_70150_70216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (8))){
var inst_69977 = (state_70077[(7)]);
var state_70077__$1 = state_70077;
var statearr_70151_70217 = state_70077__$1;
(statearr_70151_70217[(2)] = inst_69977);

(statearr_70151_70217[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70078 === (49))){
var state_70077__$1 = state_70077;
var statearr_70152_70218 = state_70077__$1;
(statearr_70152_70218[(2)] = null);

(statearr_70152_70218[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_70153 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70153[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_70153[(1)] = (1));

return statearr_70153;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_70077){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70077);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70154){var ex__2687__auto__ = e70154;
var statearr_70155_70219 = state_70077;
(statearr_70155_70219[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70077[(4)]))){
var statearr_70156_70220 = state_70077;
(statearr_70156_70220[(1)] = cljs.core.first((state_70077[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70221 = state_70077;
state_70077 = G__70221;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_70077){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_70077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70157 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70157[(6)] = c__2706__auto__);

return statearr_70157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__70222_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__70222_SHARP_);
}));

var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70244){
var state_val_70245 = (state_70244[(1)]);
if((state_val_70245 === (1))){
var inst_70226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70227 = [resp_chan,timeout_chan];
var inst_70228 = (new cljs.core.PersistentVector(null,2,(5),inst_70226,inst_70227,null));
var state_70244__$1 = state_70244;
return cljs.core.async.ioc_alts_BANG_(state_70244__$1,(2),inst_70228);
} else {
if((state_val_70245 === (2))){
var inst_70230 = (state_70244[(2)]);
var inst_70231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70230,(0),null);
var inst_70232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70230,(1),null);
var inst_70233 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_70232);
var state_70244__$1 = (function (){var statearr_70246 = state_70244;
(statearr_70246[(7)] = inst_70231);

return statearr_70246;
})();
if(inst_70233){
var statearr_70247_70257 = state_70244__$1;
(statearr_70247_70257[(1)] = (3));

} else {
var statearr_70248_70258 = state_70244__$1;
(statearr_70248_70258[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70245 === (3))){
var inst_70235 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_70236 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_70237 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_70238 = [tid,(408),inst_70237];
var inst_70239 = cljs.core.PersistentHashMap.fromArrays(inst_70236,inst_70238);
var state_70244__$1 = (function (){var statearr_70249 = state_70244;
(statearr_70249[(8)] = inst_70235);

return statearr_70249;
})();
var statearr_70250_70259 = state_70244__$1;
(statearr_70250_70259[(2)] = inst_70239);

(statearr_70250_70259[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70245 === (4))){
var inst_70231 = (state_70244[(7)]);
var state_70244__$1 = state_70244;
var statearr_70251_70260 = state_70244__$1;
(statearr_70251_70260[(2)] = inst_70231);

(statearr_70251_70260[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70245 === (5))){
var inst_70242 = (state_70244[(2)]);
var state_70244__$1 = state_70244;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70244__$1,inst_70242);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0 = (function (){
var statearr_70252 = [null,null,null,null,null,null,null,null,null];
(statearr_70252[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__);

(statearr_70252[(1)] = (1));

return statearr_70252;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1 = (function (state_70244){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70244);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70253){var ex__2687__auto__ = e70253;
var statearr_70254_70261 = state_70244;
(statearr_70254_70261[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70244[(4)]))){
var statearr_70255_70262 = state_70244;
(statearr_70255_70262[(1)] = cljs.core.first((state_70244[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70263 = state_70244;
state_70244 = G__70263;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__ = function(state_70244){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1.call(this,state_70244);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2684__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70256 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70256[(6)] = c__2706__auto__);

return statearr_70256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__70265 = arguments.length;
switch (G__70265) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__70266 = opts;
var map__70266__$1 = cljs.core.__destructure_map(map__70266);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70266__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70266__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70266__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__70266__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__70267 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70267,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__70267,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e70270){var e = e70270;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__70273 = arguments.length;
switch (G__70273) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70342){
var state_val_70343 = (state_70342[(1)]);
if((state_val_70343 === (7))){
var inst_70297 = (state_70342[(7)]);
var inst_70298 = (state_70342[(8)]);
var inst_70295 = (state_70342[(9)]);
var inst_70293 = (state_70342[(10)]);
var inst_70296 = (state_70342[(11)]);
var inst_70311 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_70312 = [ledger,txn,inst_70293,inst_70295,inst_70296,inst_70297,inst_70298];
var inst_70313 = cljs.core.PersistentHashMap.fromArrays(inst_70311,inst_70312);
var inst_70314 = fluree.db.util.core.without_nils(inst_70313);
var inst_70315 = fluree.db.operations.transact_async(conn,inst_70314);
var state_70342__$1 = state_70342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70342__$1,(13),inst_70315);
} else {
if((state_val_70343 === (20))){
var inst_70333 = (state_70342[(2)]);
var state_70342__$1 = state_70342;
var statearr_70344_70380 = state_70342__$1;
(statearr_70344_70380[(2)] = inst_70333);

(statearr_70344_70380[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (1))){
var state_70342__$1 = state_70342;
var statearr_70345_70381 = state_70342__$1;
(statearr_70345_70381[(2)] = null);

(statearr_70345_70381[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (4))){
var inst_70274 = (state_70342[(2)]);
var inst_70275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70276 = [inst_70274];
var inst_70277 = (new cljs.core.PersistentVector(null,1,(5),inst_70275,inst_70276,null));
var inst_70278 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70277);
var inst_70279 = cljs.core.ex_data(inst_70274);
var inst_70280 = cljs.core.ex_message(inst_70274);
var inst_70281 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70279,new cljs.core.Keyword(null,"message","message",-406056002),inst_70280);
var state_70342__$1 = (function (){var statearr_70346 = state_70342;
(statearr_70346[(12)] = inst_70278);

return statearr_70346;
})();
var statearr_70347_70382 = state_70342__$1;
(statearr_70347_70382[(2)] = inst_70281);

(statearr_70347_70382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (15))){
var inst_70292 = (state_70342[(13)]);
var inst_70317 = (state_70342[(14)]);
var inst_70320 = fluree.db.api_js.monitor_tx(conn,ledger,inst_70317,inst_70292);
var state_70342__$1 = state_70342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70342__$1,(17),inst_70320);
} else {
if((state_val_70343 === (13))){
var inst_70291 = (state_70342[(15)]);
var inst_70317 = (state_70342[(2)]);
var state_70342__$1 = (function (){var statearr_70348 = state_70342;
(statearr_70348[(14)] = inst_70317);

return statearr_70348;
})();
if(cljs.core.truth_(inst_70291)){
var statearr_70349_70383 = state_70342__$1;
(statearr_70349_70383[(1)] = (14));

} else {
var statearr_70350_70384 = state_70342__$1;
(statearr_70350_70384[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (6))){
var inst_70291 = (state_70342[(15)]);
var inst_70290 = (state_70342[(16)]);
var inst_70300 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_70290,opts);
var inst_70301 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_70300);
var inst_70302 = fluree.db.operations.command_async(conn,inst_70300);
var state_70342__$1 = (function (){var statearr_70351 = state_70342;
(statearr_70351[(17)] = inst_70301);

(statearr_70351[(18)] = inst_70302);

return statearr_70351;
})();
if(cljs.core.truth_(inst_70291)){
var statearr_70352_70385 = state_70342__$1;
(statearr_70352_70385[(1)] = (9));

} else {
var statearr_70353_70386 = state_70342__$1;
(statearr_70353_70386[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (17))){
var inst_70322 = (state_70342[(19)]);
var inst_70322__$1 = (state_70342[(2)]);
var inst_70323 = (inst_70322__$1 instanceof cljs.core.ExceptionInfo);
var state_70342__$1 = (function (){var statearr_70354 = state_70342;
(statearr_70354[(19)] = inst_70322__$1);

return statearr_70354;
})();
if(cljs.core.truth_(inst_70323)){
var statearr_70355_70387 = state_70342__$1;
(statearr_70355_70387[(1)] = (18));

} else {
var statearr_70356_70388 = state_70342__$1;
(statearr_70356_70388[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (3))){
var inst_70340 = (state_70342[(2)]);
var state_70342__$1 = state_70342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70342__$1,inst_70340);
} else {
if((state_val_70343 === (12))){
var inst_70307 = (state_70342[(2)]);
var state_70342__$1 = state_70342;
var statearr_70357_70389 = state_70342__$1;
(statearr_70357_70389[(2)] = inst_70307);

(statearr_70357_70389[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (2))){
var inst_70290 = (state_70342[(16)]);
var _ = (function (){var statearr_70358 = state_70342;
(statearr_70358[(4)] = cljs.core.cons((5),(state_70342[(4)])));

return statearr_70358;
})();
var inst_70288 = opts;
var inst_70289 = cljs.core.__destructure_map(inst_70288);
var inst_70290__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70289,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_70291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70289,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_70292 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70289,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_70293 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70289,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70294 = fluree.db.util.core.current_time_millis();
var inst_70295 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_70289,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_70294);
var inst_70296 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70289,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_70297 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70289,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_70298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70289,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_70342__$1 = (function (){var statearr_70359 = state_70342;
(statearr_70359[(7)] = inst_70297);

(statearr_70359[(8)] = inst_70298);

(statearr_70359[(9)] = inst_70295);

(statearr_70359[(15)] = inst_70291);

(statearr_70359[(13)] = inst_70292);

(statearr_70359[(10)] = inst_70293);

(statearr_70359[(11)] = inst_70296);

(statearr_70359[(16)] = inst_70290__$1);

return statearr_70359;
})();
if(cljs.core.truth_(inst_70290__$1)){
var statearr_70360_70390 = state_70342__$1;
(statearr_70360_70390[(1)] = (6));

} else {
var statearr_70361_70391 = state_70342__$1;
(statearr_70361_70391[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (19))){
var inst_70322 = (state_70342[(19)]);
var state_70342__$1 = state_70342;
var statearr_70362_70392 = state_70342__$1;
(statearr_70362_70392[(2)] = inst_70322);

(statearr_70362_70392[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (11))){
var inst_70309 = (state_70342[(2)]);
var state_70342__$1 = state_70342;
var statearr_70364_70393 = state_70342__$1;
(statearr_70364_70393[(2)] = inst_70309);

(statearr_70364_70393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (9))){
var inst_70302 = (state_70342[(18)]);
var state_70342__$1 = state_70342;
var statearr_70365_70394 = state_70342__$1;
(statearr_70365_70394[(2)] = inst_70302);

(statearr_70365_70394[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (5))){
var _ = (function (){var statearr_70366 = state_70342;
(statearr_70366[(4)] = cljs.core.rest((state_70342[(4)])));

return statearr_70366;
})();
var state_70342__$1 = state_70342;
var ex70363 = (state_70342__$1[(2)]);
var statearr_70367_70395 = state_70342__$1;
(statearr_70367_70395[(5)] = ex70363);


var statearr_70368_70396 = state_70342__$1;
(statearr_70368_70396[(1)] = (4));

(statearr_70368_70396[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (14))){
var inst_70317 = (state_70342[(14)]);
var state_70342__$1 = state_70342;
var statearr_70369_70397 = state_70342__$1;
(statearr_70369_70397[(2)] = inst_70317);

(statearr_70369_70397[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (16))){
var inst_70335 = (state_70342[(2)]);
var state_70342__$1 = state_70342;
var statearr_70370_70398 = state_70342__$1;
(statearr_70370_70398[(2)] = inst_70335);

(statearr_70370_70398[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (10))){
var inst_70301 = (state_70342[(17)]);
var inst_70292 = (state_70342[(13)]);
var inst_70305 = fluree.db.api_js.monitor_tx(conn,ledger,inst_70301,inst_70292);
var state_70342__$1 = state_70342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70342__$1,(12),inst_70305);
} else {
if((state_val_70343 === (18))){
var inst_70322 = (state_70342[(19)]);
var inst_70325 = cljs.core.ex_data(inst_70322);
var inst_70326 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70327 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_70325);
var inst_70328 = cljs.core.ex_message(inst_70322);
var inst_70329 = [inst_70327,inst_70328,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_70330 = cljs.core.PersistentHashMap.fromArrays(inst_70326,inst_70329);
var state_70342__$1 = state_70342;
var statearr_70371_70399 = state_70342__$1;
(statearr_70371_70399[(2)] = inst_70330);

(statearr_70371_70399[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70343 === (8))){
var inst_70337 = (state_70342[(2)]);
var _ = (function (){var statearr_70372 = state_70342;
(statearr_70372[(4)] = cljs.core.rest((state_70342[(4)])));

return statearr_70372;
})();
var state_70342__$1 = state_70342;
var statearr_70373_70400 = state_70342__$1;
(statearr_70373_70400[(2)] = inst_70337);

(statearr_70373_70400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_70374 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70374[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_70374[(1)] = (1));

return statearr_70374;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_70342){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70342);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70375){var ex__2687__auto__ = e70375;
var statearr_70376_70401 = state_70342;
(statearr_70376_70401[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70342[(4)]))){
var statearr_70377_70402 = state_70342;
(statearr_70377_70402[(1)] = cljs.core.first((state_70342[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70403 = state_70342;
state_70342 = G__70403;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_70342){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_70342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70378 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70378[(6)] = c__2706__auto__);

return statearr_70378;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___70405 = arguments.length;
var i__5770__auto___70406 = (0);
while(true){
if((i__5770__auto___70406 < len__5769__auto___70405)){
args__5775__auto__.push((arguments[i__5770__auto___70406]));

var G__70407 = (i__5770__auto___70406 + (1));
i__5770__auto___70406 = G__70407;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq70404){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq70404));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70438){
var state_val_70439 = (state_70438[(1)]);
if((state_val_70439 === (1))){
var inst_70408 = cljs.core.first(flakes);
var inst_70409 = cljs.core.rest(flakes);
var inst_70410 = cljs.core.PersistentVector.EMPTY;
var inst_70411 = inst_70408;
var inst_70412 = inst_70409;
var inst_70413 = inst_70410;
var state_70438__$1 = (function (){var statearr_70440 = state_70438;
(statearr_70440[(7)] = inst_70411);

(statearr_70440[(8)] = inst_70413);

(statearr_70440[(9)] = inst_70412);

return statearr_70440;
})();
var statearr_70441_70454 = state_70438__$1;
(statearr_70441_70454[(2)] = null);

(statearr_70441_70454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70439 === (2))){
var inst_70411 = (state_70438[(7)]);
var inst_70415 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_70416 = cljs.core.PersistentHashMap.EMPTY;
var inst_70417 = [true,inst_70416];
var inst_70418 = cljs.core.PersistentHashMap.fromArrays(inst_70415,inst_70417);
var inst_70419 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_70418,inst_70411);
var state_70438__$1 = state_70438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70438__$1,(4),inst_70419);
} else {
if((state_val_70439 === (3))){
var inst_70436 = (state_70438[(2)]);
var state_70438__$1 = state_70438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70438__$1,inst_70436);
} else {
if((state_val_70439 === (4))){
var inst_70413 = (state_70438[(8)]);
var inst_70412 = (state_70438[(9)]);
var inst_70421 = (state_70438[(2)]);
var inst_70422 = fluree.db.util.async.throw_err(inst_70421);
var inst_70423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70424 = [inst_70422];
var inst_70425 = (new cljs.core.PersistentVector(null,1,(5),inst_70423,inst_70424,null));
var inst_70426 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_70413,inst_70425);
var inst_70427 = cljs.core.first(inst_70412);
var state_70438__$1 = (function (){var statearr_70442 = state_70438;
(statearr_70442[(10)] = inst_70426);

return statearr_70442;
})();
if(cljs.core.truth_(inst_70427)){
var statearr_70443_70455 = state_70438__$1;
(statearr_70443_70455[(1)] = (5));

} else {
var statearr_70444_70456 = state_70438__$1;
(statearr_70444_70456[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70439 === (5))){
var inst_70412 = (state_70438[(9)]);
var inst_70426 = (state_70438[(10)]);
var inst_70429 = cljs.core.first(inst_70412);
var inst_70430 = cljs.core.rest(inst_70412);
var inst_70411 = inst_70429;
var inst_70412__$1 = inst_70430;
var inst_70413 = inst_70426;
var state_70438__$1 = (function (){var statearr_70445 = state_70438;
(statearr_70445[(7)] = inst_70411);

(statearr_70445[(8)] = inst_70413);

(statearr_70445[(9)] = inst_70412__$1);

return statearr_70445;
})();
var statearr_70446_70457 = state_70438__$1;
(statearr_70446_70457[(2)] = null);

(statearr_70446_70457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70439 === (6))){
var inst_70426 = (state_70438[(10)]);
var state_70438__$1 = state_70438;
var statearr_70447_70458 = state_70438__$1;
(statearr_70447_70458[(2)] = inst_70426);

(statearr_70447_70458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70439 === (7))){
var inst_70434 = (state_70438[(2)]);
var state_70438__$1 = state_70438;
var statearr_70448_70459 = state_70438__$1;
(statearr_70448_70459[(2)] = inst_70434);

(statearr_70448_70459[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_70449 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70449[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__);

(statearr_70449[(1)] = (1));

return statearr_70449;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1 = (function (state_70438){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70438);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70450){var ex__2687__auto__ = e70450;
var statearr_70451_70460 = state_70438;
(statearr_70451_70460[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70438[(4)]))){
var statearr_70452_70461 = state_70438;
(statearr_70452_70461[(1)] = cljs.core.first((state_70438[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70462 = state_70438;
state_70438 = G__70462;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__ = function(state_70438){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1.call(this,state_70438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70453 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70453[(6)] = c__2706__auto__);

return statearr_70453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70530){
var state_val_70531 = (state_70530[(1)]);
if((state_val_70531 === (7))){
var inst_70490 = (state_70530[(2)]);
var inst_70491 = fluree.db.util.async.throw_err(inst_70490);
var state_70530__$1 = state_70530;
var statearr_70532_70558 = state_70530__$1;
(statearr_70532_70558[(2)] = inst_70491);

(statearr_70532_70558[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (1))){
var inst_70467 = cljs.core.volatile_BANG_((0));
var inst_70468 = cljs.core.PersistentHashMap.EMPTY;
var inst_70469 = cljs.core.volatile_BANG_(inst_70468);
var inst_70470 = cljs.core.first(resp);
var inst_70471 = cljs.core.rest(resp);
var inst_70472 = cljs.core.PersistentVector.EMPTY;
var inst_70473 = inst_70467;
var inst_70474 = inst_70469;
var inst_70475 = inst_70470;
var inst_70476 = inst_70471;
var inst_70477 = inst_70472;
var state_70530__$1 = (function (){var statearr_70533 = state_70530;
(statearr_70533[(7)] = inst_70475);

(statearr_70533[(8)] = inst_70476);

(statearr_70533[(9)] = inst_70474);

(statearr_70533[(10)] = inst_70477);

(statearr_70533[(11)] = inst_70473);

return statearr_70533;
})();
var statearr_70534_70559 = state_70530__$1;
(statearr_70534_70559[(2)] = null);

(statearr_70534_70559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (4))){
var inst_70479 = (state_70530[(12)]);
var inst_70475 = (state_70530[(7)]);
var inst_70476 = (state_70530[(8)]);
var inst_70474 = (state_70530[(9)]);
var inst_70481 = (state_70530[(13)]);
var inst_70477 = (state_70530[(10)]);
var inst_70473 = (state_70530[(11)]);
var inst_70485 = (function (){var fuel = inst_70473;
var cache = inst_70474;
var curr_block = inst_70475;
var rest_blocks = inst_70476;
var acc = inst_70477;
var flakes = inst_70479;
var asserted = inst_70481;
return (function (p1__70464_SHARP_){
return p1__70464_SHARP_.s;
});
})();
var inst_70486 = cljs.core.group_by(inst_70485,inst_70481);
var inst_70487 = cljs.core.vals(inst_70486);
var inst_70488 = fluree.db.api_js.format_flake_groups_pretty(db,inst_70474,inst_70473,inst_70487);
var state_70530__$1 = state_70530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70530__$1,(7),inst_70488);
} else {
if((state_val_70531 === (13))){
var inst_70518 = (state_70530[(14)]);
var state_70530__$1 = state_70530;
var statearr_70535_70560 = state_70530__$1;
(statearr_70535_70560[(2)] = inst_70518);

(statearr_70535_70560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (6))){
var inst_70479 = (state_70530[(12)]);
var inst_70494 = (state_70530[(15)]);
var inst_70496 = (state_70530[(16)]);
var inst_70475 = (state_70530[(7)]);
var inst_70476 = (state_70530[(8)]);
var inst_70474 = (state_70530[(9)]);
var inst_70481 = (state_70530[(13)]);
var inst_70477 = (state_70530[(10)]);
var inst_70473 = (state_70530[(11)]);
var inst_70494__$1 = (state_70530[(2)]);
var inst_70495 = (function (){var fuel = inst_70473;
var cache = inst_70474;
var curr_block = inst_70475;
var rest_blocks = inst_70476;
var acc = inst_70477;
var flakes = inst_70479;
var asserted = inst_70481;
var asserted_SINGLEQUOTE_ = inst_70494__$1;
return (function (p1__70465_SHARP_){
return p1__70465_SHARP_.op === false;
});
})();
var inst_70496__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_70495,inst_70479);
var inst_70497 = cljs.core.empty_QMARK_(inst_70496__$1);
var inst_70498 = (!(inst_70497));
var state_70530__$1 = (function (){var statearr_70538 = state_70530;
(statearr_70538[(15)] = inst_70494__$1);

(statearr_70538[(16)] = inst_70496__$1);

return statearr_70538;
})();
if(inst_70498){
var statearr_70539_70561 = state_70530__$1;
(statearr_70539_70561[(1)] = (8));

} else {
var statearr_70540_70562 = state_70530__$1;
(statearr_70540_70562[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (3))){
var inst_70528 = (state_70530[(2)]);
var state_70530__$1 = state_70530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70530__$1,inst_70528);
} else {
if((state_val_70531 === (12))){
var inst_70518 = (state_70530[(14)]);
var inst_70476 = (state_70530[(8)]);
var inst_70474 = (state_70530[(9)]);
var inst_70473 = (state_70530[(11)]);
var inst_70521 = cljs.core.first(inst_70476);
var inst_70522 = cljs.core.rest(inst_70476);
var tmp70536 = inst_70474;
var tmp70537 = inst_70473;
var inst_70473__$1 = tmp70537;
var inst_70474__$1 = tmp70536;
var inst_70475 = inst_70521;
var inst_70476__$1 = inst_70522;
var inst_70477 = inst_70518;
var state_70530__$1 = (function (){var statearr_70541 = state_70530;
(statearr_70541[(7)] = inst_70475);

(statearr_70541[(8)] = inst_70476__$1);

(statearr_70541[(9)] = inst_70474__$1);

(statearr_70541[(10)] = inst_70477);

(statearr_70541[(11)] = inst_70473__$1);

return statearr_70541;
})();
var statearr_70542_70563 = state_70530__$1;
(statearr_70542_70563[(2)] = null);

(statearr_70542_70563[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (2))){
var inst_70479 = (state_70530[(12)]);
var inst_70475 = (state_70530[(7)]);
var inst_70476 = (state_70530[(8)]);
var inst_70474 = (state_70530[(9)]);
var inst_70481 = (state_70530[(13)]);
var inst_70477 = (state_70530[(10)]);
var inst_70473 = (state_70530[(11)]);
var inst_70479__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_70475);
var inst_70480 = (function (){var fuel = inst_70473;
var cache = inst_70474;
var curr_block = inst_70475;
var rest_blocks = inst_70476;
var acc = inst_70477;
var flakes = inst_70479__$1;
return (function (p1__70463_SHARP_){
return p1__70463_SHARP_.op;
});
})();
var inst_70481__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_70480,inst_70479__$1);
var inst_70482 = cljs.core.empty_QMARK_(inst_70481__$1);
var inst_70483 = (!(inst_70482));
var state_70530__$1 = (function (){var statearr_70543 = state_70530;
(statearr_70543[(12)] = inst_70479__$1);

(statearr_70543[(13)] = inst_70481__$1);

return statearr_70543;
})();
if(inst_70483){
var statearr_70544_70564 = state_70530__$1;
(statearr_70544_70564[(1)] = (4));

} else {
var statearr_70545_70565 = state_70530__$1;
(statearr_70545_70565[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (11))){
var inst_70506 = (state_70530[(2)]);
var inst_70507 = fluree.db.util.async.throw_err(inst_70506);
var state_70530__$1 = state_70530;
var statearr_70546_70566 = state_70530__$1;
(statearr_70546_70566[(2)] = inst_70507);

(statearr_70546_70566[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (9))){
var state_70530__$1 = state_70530;
var statearr_70547_70567 = state_70530__$1;
(statearr_70547_70567[(2)] = null);

(statearr_70547_70567[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (5))){
var state_70530__$1 = state_70530;
var statearr_70548_70568 = state_70530__$1;
(statearr_70548_70568[(2)] = null);

(statearr_70548_70568[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (14))){
var inst_70526 = (state_70530[(2)]);
var state_70530__$1 = state_70530;
var statearr_70549_70569 = state_70530__$1;
(statearr_70549_70569[(2)] = inst_70526);

(statearr_70549_70569[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (10))){
var inst_70494 = (state_70530[(15)]);
var inst_70475 = (state_70530[(7)]);
var inst_70476 = (state_70530[(8)]);
var inst_70477 = (state_70530[(10)]);
var inst_70510 = (state_70530[(2)]);
var inst_70511 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_70512 = [inst_70494,inst_70510];
var inst_70513 = cljs.core.PersistentHashMap.fromArrays(inst_70511,inst_70512);
var inst_70514 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70475,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_70513);
var inst_70515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70516 = [inst_70514];
var inst_70517 = (new cljs.core.PersistentVector(null,1,(5),inst_70515,inst_70516,null));
var inst_70518 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_70477,inst_70517);
var inst_70519 = cljs.core.first(inst_70476);
var state_70530__$1 = (function (){var statearr_70550 = state_70530;
(statearr_70550[(14)] = inst_70518);

return statearr_70550;
})();
if(cljs.core.truth_(inst_70519)){
var statearr_70551_70570 = state_70530__$1;
(statearr_70551_70570[(1)] = (12));

} else {
var statearr_70552_70571 = state_70530__$1;
(statearr_70552_70571[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70531 === (8))){
var inst_70479 = (state_70530[(12)]);
var inst_70494 = (state_70530[(15)]);
var inst_70496 = (state_70530[(16)]);
var inst_70475 = (state_70530[(7)]);
var inst_70476 = (state_70530[(8)]);
var inst_70474 = (state_70530[(9)]);
var inst_70481 = (state_70530[(13)]);
var inst_70477 = (state_70530[(10)]);
var inst_70473 = (state_70530[(11)]);
var inst_70500 = (function (){var flakes = inst_70479;
var rest_blocks = inst_70476;
var curr_block = inst_70475;
var asserted_SINGLEQUOTE_ = inst_70494;
var acc = inst_70477;
var fuel = inst_70473;
var cache = inst_70474;
var retracted = inst_70496;
var asserted = inst_70481;
return (function (p1__70466_SHARP_){
return p1__70466_SHARP_.s;
});
})();
var inst_70501 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_70496);
var inst_70502 = cljs.core.group_by(inst_70500,inst_70501);
var inst_70503 = cljs.core.vals(inst_70502);
var inst_70504 = fluree.db.api_js.format_flake_groups_pretty(db,inst_70474,inst_70473,inst_70503);
var state_70530__$1 = state_70530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70530__$1,(11),inst_70504);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_70553 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70553[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_70553[(1)] = (1));

return statearr_70553;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_70530){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70530);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70554){var ex__2687__auto__ = e70554;
var statearr_70555_70572 = state_70530;
(statearr_70555_70572[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70530[(4)]))){
var statearr_70556_70573 = state_70530;
(statearr_70556_70573[(1)] = cljs.core.first((state_70530[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70574 = state_70530;
state_70530 = G__70574;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_70530){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_70530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70557 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70557[(6)] = c__2706__auto__);

return statearr_70557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70674){
var state_val_70675 = (state_70674[(1)]);
if((state_val_70675 === (7))){
var inst_70646 = (state_70674[(7)]);
var inst_70639 = (state_70674[(8)]);
var inst_70645 = cljs.core.seq(inst_70639);
var inst_70646__$1 = cljs.core.first(inst_70645);
var inst_70647 = cljs.core.next(inst_70645);
var state_70674__$1 = (function (){var statearr_70676 = state_70674;
(statearr_70676[(9)] = inst_70647);

(statearr_70676[(7)] = inst_70646__$1);

return statearr_70676;
})();
if(cljs.core.truth_(inst_70646__$1)){
var statearr_70677_70714 = state_70674__$1;
(statearr_70677_70714[(1)] = (9));

} else {
var statearr_70678_70715 = state_70674__$1;
(statearr_70678_70715[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (1))){
var state_70674__$1 = state_70674;
var statearr_70679_70716 = state_70674__$1;
(statearr_70679_70716[(2)] = null);

(statearr_70679_70716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (4))){
var inst_70576 = (state_70674[(2)]);
var state_70674__$1 = state_70674;
var statearr_70680_70717 = state_70674__$1;
(statearr_70680_70717[(2)] = inst_70576);

(statearr_70680_70717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (6))){
var inst_70625 = (state_70674[(2)]);
var inst_70626 = fluree.db.util.async.throw_err(inst_70625);
var inst_70634 = resp;
var inst_70635 = cljs.core.seq(inst_70634);
var inst_70636 = cljs.core.first(inst_70635);
var inst_70637 = cljs.core.next(inst_70635);
var inst_70638 = cljs.core.PersistentHashMap.EMPTY;
var inst_70639 = inst_70634;
var inst_70640 = inst_70638;
var state_70674__$1 = (function (){var statearr_70681 = state_70674;
(statearr_70681[(10)] = inst_70640);

(statearr_70681[(11)] = inst_70636);

(statearr_70681[(12)] = inst_70626);

(statearr_70681[(13)] = inst_70637);

(statearr_70681[(8)] = inst_70639);

return statearr_70681;
})();
var statearr_70682_70718 = state_70674__$1;
(statearr_70682_70718[(2)] = null);

(statearr_70682_70718[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (3))){
var inst_70672 = (state_70674[(2)]);
var state_70674__$1 = state_70674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70674__$1,inst_70672);
} else {
if((state_val_70675 === (2))){
var _ = (function (){var statearr_70683 = state_70674;
(statearr_70683[(4)] = cljs.core.cons((5),(state_70674[(4)])));

return statearr_70683;
})();
var inst_70582 = (function (){return (function (p1__70575_SHARP_){
return p1__70575_SHARP_.t;
});
})();
var inst_70583 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_70582,resp);
var inst_70584 = cljs.core.set(inst_70583);
var inst_70621 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_70622 = (function (){var ts = inst_70584;
var c__2706__auto____$1 = inst_70621;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70619){
var state_val_70620 = (state_70619[(1)]);
if((state_val_70620 === (1))){
var inst_70592 = ts;
var inst_70593 = cljs.core.seq(inst_70592);
var inst_70594 = cljs.core.first(inst_70593);
var inst_70595 = cljs.core.next(inst_70593);
var inst_70596 = cljs.core.PersistentHashMap.EMPTY;
var inst_70597 = inst_70592;
var inst_70598 = inst_70596;
var state_70619__$1 = (function (){var statearr_70684 = state_70619;
(statearr_70684[(7)] = inst_70594);

(statearr_70684[(8)] = inst_70595);

(statearr_70684[(9)] = inst_70598);

(statearr_70684[(10)] = inst_70597);

return statearr_70684;
})();
var statearr_70685_70719 = state_70619__$1;
(statearr_70685_70719[(2)] = null);

(statearr_70685_70719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70620 === (2))){
var inst_70597 = (state_70619[(10)]);
var inst_70604 = (state_70619[(11)]);
var inst_70603 = cljs.core.seq(inst_70597);
var inst_70604__$1 = cljs.core.first(inst_70603);
var inst_70605 = cljs.core.next(inst_70603);
var state_70619__$1 = (function (){var statearr_70686 = state_70619;
(statearr_70686[(12)] = inst_70605);

(statearr_70686[(11)] = inst_70604__$1);

return statearr_70686;
})();
if(cljs.core.truth_(inst_70604__$1)){
var statearr_70687_70720 = state_70619__$1;
(statearr_70687_70720[(1)] = (4));

} else {
var statearr_70688_70721 = state_70619__$1;
(statearr_70688_70721[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70620 === (3))){
var inst_70617 = (state_70619[(2)]);
var state_70619__$1 = state_70619;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70619__$1,inst_70617);
} else {
if((state_val_70620 === (4))){
var inst_70604 = (state_70619[(11)]);
var inst_70607 = fluree.db.time_travel.non_border_t_to_block(db,inst_70604);
var state_70619__$1 = state_70619;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70619__$1,(7),inst_70607);
} else {
if((state_val_70620 === (5))){
var inst_70598 = (state_70619[(9)]);
var state_70619__$1 = state_70619;
var statearr_70689_70722 = state_70619__$1;
(statearr_70689_70722[(2)] = inst_70598);

(statearr_70689_70722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70620 === (6))){
var inst_70615 = (state_70619[(2)]);
var state_70619__$1 = state_70619;
var statearr_70690_70723 = state_70619__$1;
(statearr_70690_70723[(2)] = inst_70615);

(statearr_70690_70723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70620 === (7))){
var inst_70598 = (state_70619[(9)]);
var inst_70605 = (state_70619[(12)]);
var inst_70604 = (state_70619[(11)]);
var inst_70609 = (state_70619[(2)]);
var inst_70610 = fluree.db.util.async.throw_err(inst_70609);
var inst_70611 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70598,inst_70604,inst_70610);
var inst_70597 = inst_70605;
var inst_70598__$1 = inst_70611;
var state_70619__$1 = (function (){var statearr_70691 = state_70619;
(statearr_70691[(9)] = inst_70598__$1);

(statearr_70691[(10)] = inst_70597);

return statearr_70691;
})();
var statearr_70692_70724 = state_70619__$1;
(statearr_70692_70724[(2)] = null);

(statearr_70692_70724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_70693 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70693[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_70693[(1)] = (1));

return statearr_70693;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_70619){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70619);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70694){var ex__2687__auto__ = e70694;
var statearr_70695_70725 = state_70619;
(statearr_70695_70725[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70619[(4)]))){
var statearr_70696_70726 = state_70619;
(statearr_70696_70726[(1)] = cljs.core.first((state_70619[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70727 = state_70619;
state_70619 = G__70727;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_70619){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_70619);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70697 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70697[(6)] = c__2706__auto____$1);

return statearr_70697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_70623 = cljs.core.async.impl.dispatch.run(inst_70622);
var state_70674__$1 = (function (){var statearr_70698 = state_70674;
(statearr_70698[(14)] = inst_70623);

return statearr_70698;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70674__$1,(6),inst_70621);
} else {
if((state_val_70675 === (11))){
var inst_70666 = (state_70674[(2)]);
var state_70674__$1 = state_70674;
var statearr_70700_70728 = state_70674__$1;
(statearr_70700_70728[(2)] = inst_70666);

(statearr_70700_70728[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (9))){
var inst_70647 = (state_70674[(9)]);
var inst_70646 = (state_70674[(7)]);
var inst_70640 = (state_70674[(10)]);
var inst_70626 = (state_70674[(12)]);
var inst_70649 = inst_70646.t;
var inst_70650 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_70626,inst_70649);
var inst_70651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70652 = [inst_70650,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_70653 = (new cljs.core.PersistentVector(null,2,(5),inst_70651,inst_70652,null));
var inst_70654 = cljs.core.assoc_in(inst_70640,inst_70653,inst_70650);
var inst_70655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70656 = [inst_70650,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_70657 = (new cljs.core.PersistentVector(null,2,(5),inst_70655,inst_70656,null));
var inst_70658 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70654,inst_70657,cljs.core.conj,inst_70646);
var inst_70659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70660 = [inst_70650,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_70661 = (new cljs.core.PersistentVector(null,2,(5),inst_70659,inst_70660,null));
var inst_70662 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_70658,inst_70661,fluree.db.api_js.min_safe,inst_70649);
var inst_70639 = inst_70647;
var inst_70640__$1 = inst_70662;
var state_70674__$1 = (function (){var statearr_70701 = state_70674;
(statearr_70701[(10)] = inst_70640__$1);

(statearr_70701[(8)] = inst_70639);

return statearr_70701;
})();
var statearr_70702_70729 = state_70674__$1;
(statearr_70702_70729[(2)] = null);

(statearr_70702_70729[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (5))){
var _ = (function (){var statearr_70703 = state_70674;
(statearr_70703[(4)] = cljs.core.rest((state_70674[(4)])));

return statearr_70703;
})();
var state_70674__$1 = state_70674;
var ex70699 = (state_70674__$1[(2)]);
var statearr_70704_70730 = state_70674__$1;
(statearr_70704_70730[(5)] = ex70699);


if((ex70699 instanceof Error)){
var statearr_70705_70731 = state_70674__$1;
(statearr_70705_70731[(1)] = (4));

(statearr_70705_70731[(5)] = null);

} else {
throw ex70699;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (10))){
var inst_70640 = (state_70674[(10)]);
var state_70674__$1 = state_70674;
var statearr_70706_70732 = state_70674__$1;
(statearr_70706_70732[(2)] = inst_70640);

(statearr_70706_70732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (8))){
var inst_70668 = (state_70674[(2)]);
var inst_70669 = cljs.core.vals(inst_70668);
var _ = (function (){var statearr_70707 = state_70674;
(statearr_70707[(4)] = cljs.core.rest((state_70674[(4)])));

return statearr_70707;
})();
var state_70674__$1 = state_70674;
var statearr_70708_70733 = state_70674__$1;
(statearr_70708_70733[(2)] = inst_70669);

(statearr_70708_70733[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_70709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70709[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__);

(statearr_70709[(1)] = (1));

return statearr_70709;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1 = (function (state_70674){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70674);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70710){var ex__2687__auto__ = e70710;
var statearr_70711_70734 = state_70674;
(statearr_70711_70734[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70674[(4)]))){
var statearr_70712_70735 = state_70674;
(statearr_70712_70735[(1)] = cljs.core.first((state_70674[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70736 = state_70674;
state_70674 = G__70736;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__ = function(state_70674){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1.call(this,state_70674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70713 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70713[(6)] = c__2706__auto__);

return statearr_70713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_70884){
var state_val_70885 = (state_70884[(1)]);
if((state_val_70885 === (7))){
var inst_70764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70765 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70766 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70767 = [inst_70765,inst_70766];
var inst_70768 = (new cljs.core.PersistentVector(null,2,(5),inst_70764,inst_70767,null));
var state_70884__$1 = state_70884;
var statearr_70886_70957 = state_70884__$1;
(statearr_70886_70957[(2)] = inst_70768);

(statearr_70886_70957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (20))){
var inst_70794 = (state_70884[(7)]);
var state_70884__$1 = state_70884;
var statearr_70887_70958 = state_70884__$1;
(statearr_70887_70958[(2)] = inst_70794);

(statearr_70887_70958[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (27))){
var state_70884__$1 = state_70884;
var statearr_70888_70959 = state_70884__$1;
(statearr_70888_70959[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (1))){
var state_70884__$1 = state_70884;
var statearr_70890_70960 = state_70884__$1;
(statearr_70890_70960[(2)] = null);

(statearr_70890_70960[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (24))){
var inst_70793 = (state_70884[(8)]);
var state_70884__$1 = state_70884;
if(cljs.core.truth_(inst_70793)){
var statearr_70891_70961 = state_70884__$1;
(statearr_70891_70961[(1)] = (26));

} else {
var statearr_70892_70962 = state_70884__$1;
(statearr_70892_70962[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (39))){
var inst_70840 = (state_70884[(9)]);
var inst_70839 = (state_70884[(10)]);
var inst_70865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70866 = [inst_70839,inst_70840];
var inst_70867 = (new cljs.core.PersistentVector(null,2,(5),inst_70865,inst_70866,null));
var state_70884__$1 = state_70884;
var statearr_70893_70963 = state_70884__$1;
(statearr_70893_70963[(2)] = inst_70867);

(statearr_70893_70963[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (4))){
var inst_70737 = (state_70884[(2)]);
var inst_70738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70739 = [inst_70737];
var inst_70740 = (new cljs.core.PersistentVector(null,1,(5),inst_70738,inst_70739,null));
var inst_70741 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_70740);
var inst_70742 = cljs.core.ex_data(inst_70737);
var inst_70743 = cljs.core.ex_message(inst_70737);
var inst_70744 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_70742,new cljs.core.Keyword(null,"message","message",-406056002),inst_70743);
var state_70884__$1 = (function (){var statearr_70894 = state_70884;
(statearr_70894[(11)] = inst_70741);

return statearr_70894;
})();
var statearr_70895_70964 = state_70884__$1;
(statearr_70895_70964[(2)] = inst_70744);

(statearr_70895_70964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (15))){
var inst_70773 = (state_70884[(12)]);
var inst_70778 = (state_70884[(13)]);
var inst_70787 = (state_70884[(2)]);
var inst_70788 = [inst_70778,inst_70787];
var inst_70789 = (new cljs.core.PersistentVector(null,2,(5),inst_70773,inst_70788,null));
var state_70884__$1 = state_70884;
var statearr_70896_70965 = state_70884__$1;
(statearr_70896_70965[(2)] = inst_70789);

(statearr_70896_70965[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (21))){
var inst_70793 = (state_70884[(8)]);
var state_70884__$1 = state_70884;
var statearr_70897_70966 = state_70884__$1;
(statearr_70897_70966[(2)] = inst_70793);

(statearr_70897_70966[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (31))){
var inst_70834 = (state_70884[(2)]);
var state_70884__$1 = state_70884;
var statearr_70898_70967 = state_70884__$1;
(statearr_70898_70967[(2)] = inst_70834);

(statearr_70898_70967[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (32))){
var inst_70840 = (state_70884[(9)]);
var inst_70843 = cljs.core.pos_int_QMARK_(inst_70840);
var state_70884__$1 = state_70884;
var statearr_70899_70968 = state_70884__$1;
(statearr_70899_70968[(2)] = inst_70843);

(statearr_70899_70968[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (40))){
var inst_70795 = (state_70884[(14)]);
var inst_70871 = (state_70884[(15)]);
var inst_70869 = (state_70884[(2)]);
var inst_70870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70869,(0),null);
var inst_70871__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70869,(1),null);
var inst_70872 = (inst_70871__$1 > inst_70795);
var state_70884__$1 = (function (){var statearr_70900 = state_70884;
(statearr_70900[(15)] = inst_70871__$1);

(statearr_70900[(16)] = inst_70870);

return statearr_70900;
})();
if(cljs.core.truth_(inst_70872)){
var statearr_70901_70969 = state_70884__$1;
(statearr_70901_70969[(1)] = (41));

} else {
var statearr_70902_70970 = state_70884__$1;
(statearr_70902_70970[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (33))){
var inst_70841 = (state_70884[(17)]);
var state_70884__$1 = state_70884;
var statearr_70903_70971 = state_70884__$1;
(statearr_70903_70971[(2)] = inst_70841);

(statearr_70903_70971[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (13))){
var inst_70779 = (state_70884[(18)]);
var inst_70781 = fluree.db.time_travel.block_to_int_format(db,inst_70779);
var state_70884__$1 = state_70884;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70884__$1,(16),inst_70781);
} else {
if((state_val_70885 === (22))){
var inst_70812 = (state_70884[(2)]);
var state_70884__$1 = state_70884;
if(cljs.core.truth_(inst_70812)){
var statearr_70904_70972 = state_70884__$1;
(statearr_70904_70972[(1)] = (23));

} else {
var statearr_70905_70973 = state_70884__$1;
(statearr_70905_70973[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (36))){
var state_70884__$1 = state_70884;
var statearr_70906_70974 = state_70884__$1;
(statearr_70906_70974[(2)] = null);

(statearr_70906_70974[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (41))){
var inst_70795 = (state_70884[(14)]);
var state_70884__$1 = state_70884;
var statearr_70907_70975 = state_70884__$1;
(statearr_70907_70975[(2)] = inst_70795);

(statearr_70907_70975[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (43))){
var inst_70870 = (state_70884[(16)]);
var inst_70876 = (state_70884[(2)]);
var inst_70877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70878 = [inst_70870,inst_70876];
var inst_70879 = (new cljs.core.PersistentVector(null,2,(5),inst_70877,inst_70878,null));
var _ = (function (){var statearr_70908 = state_70884;
(statearr_70908[(4)] = cljs.core.rest((state_70884[(4)])));

return statearr_70908;
})();
var state_70884__$1 = state_70884;
var statearr_70909_70976 = state_70884__$1;
(statearr_70909_70976[(2)] = inst_70879);

(statearr_70909_70976[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (29))){
var inst_70770 = (state_70884[(19)]);
var inst_70825 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70770], 0));
var inst_70826 = ["Invalid block range provided: ",inst_70825].join('');
var inst_70827 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70828 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70829 = cljs.core.PersistentHashMap.fromArrays(inst_70827,inst_70828);
var inst_70830 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70826,inst_70829);
var inst_70831 = (function(){throw inst_70830})();
var state_70884__$1 = state_70884;
var statearr_70910_70977 = state_70884__$1;
(statearr_70910_70977[(2)] = inst_70831);

(statearr_70910_70977[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (6))){
var inst_70762 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_70884__$1 = state_70884;
var statearr_70911_70978 = state_70884__$1;
(statearr_70911_70978[(2)] = inst_70762);

(statearr_70911_70978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (28))){
var inst_70836 = (state_70884[(2)]);
var state_70884__$1 = state_70884;
var statearr_70912_70979 = state_70884__$1;
(statearr_70912_70979[(2)] = inst_70836);

(statearr_70912_70979[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (25))){
var inst_70839 = (state_70884[(10)]);
var inst_70841 = (state_70884[(17)]);
var inst_70838 = (state_70884[(2)]);
var inst_70839__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70838,(0),null);
var inst_70840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70838,(1),null);
var inst_70841__$1 = cljs.core.pos_int_QMARK_(inst_70839__$1);
var state_70884__$1 = (function (){var statearr_70913 = state_70884;
(statearr_70913[(9)] = inst_70840);

(statearr_70913[(10)] = inst_70839__$1);

(statearr_70913[(17)] = inst_70841__$1);

return statearr_70913;
})();
if(inst_70841__$1){
var statearr_70914_70980 = state_70884__$1;
(statearr_70914_70980[(1)] = (32));

} else {
var statearr_70915_70981 = state_70884__$1;
(statearr_70915_70981[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (34))){
var inst_70846 = (state_70884[(2)]);
var inst_70847 = cljs.core.not(inst_70846);
var state_70884__$1 = state_70884;
if(inst_70847){
var statearr_70916_70982 = state_70884__$1;
(statearr_70916_70982[(1)] = (35));

} else {
var statearr_70917_70983 = state_70884__$1;
(statearr_70917_70983[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (17))){
var inst_70795 = (state_70884[(14)]);
var inst_70793 = (state_70884[(8)]);
var inst_70798 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70793], 0));
var inst_70799 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70795], 0));
var inst_70800 = ["Start block is out of range for this ledger. Start block provided: ",inst_70798,". Database block: ",inst_70799].join('');
var inst_70801 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70802 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70803 = cljs.core.PersistentHashMap.fromArrays(inst_70801,inst_70802);
var inst_70804 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70800,inst_70803);
var inst_70805 = (function(){throw inst_70804})();
var state_70884__$1 = state_70884;
var statearr_70918_70984 = state_70884__$1;
(statearr_70918_70984[(2)] = inst_70805);

(statearr_70918_70984[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (3))){
var inst_70882 = (state_70884[(2)]);
var state_70884__$1 = state_70884;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70884__$1,inst_70882);
} else {
if((state_val_70885 === (12))){
var inst_70770 = (state_70884[(19)]);
var inst_70779 = (state_70884[(18)]);
var inst_70777 = (state_70884[(2)]);
var inst_70778 = fluree.db.util.async.throw_err(inst_70777);
var inst_70779__$1 = cljs.core.second(inst_70770);
var state_70884__$1 = (function (){var statearr_70919 = state_70884;
(statearr_70919[(18)] = inst_70779__$1);

(statearr_70919[(13)] = inst_70778);

return statearr_70919;
})();
if(cljs.core.truth_(inst_70779__$1)){
var statearr_70920_70985 = state_70884__$1;
(statearr_70920_70985[(1)] = (13));

} else {
var statearr_70921_70986 = state_70884__$1;
(statearr_70921_70986[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (2))){
var _ = (function (){var statearr_70922 = state_70884;
(statearr_70922[(4)] = cljs.core.cons((5),(state_70884[(4)])));

return statearr_70922;
})();
var inst_70759 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_70760 = cljs.core.sequential_QMARK_(inst_70759);
var state_70884__$1 = state_70884;
if(inst_70760){
var statearr_70923_70987 = state_70884__$1;
(statearr_70923_70987[(1)] = (6));

} else {
var statearr_70924_70988 = state_70884__$1;
(statearr_70924_70988[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (23))){
var inst_70793 = (state_70884[(8)]);
var inst_70794 = (state_70884[(7)]);
var inst_70814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70815 = [inst_70793,inst_70794];
var inst_70816 = (new cljs.core.PersistentVector(null,2,(5),inst_70814,inst_70815,null));
var state_70884__$1 = state_70884;
var statearr_70925_70989 = state_70884__$1;
(statearr_70925_70989[(2)] = inst_70816);

(statearr_70925_70989[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (35))){
var inst_70770 = (state_70884[(19)]);
var inst_70849 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_70770], 0));
var inst_70850 = ["Invalid block range provided: ",inst_70849].join('');
var inst_70851 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70852 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_70853 = cljs.core.PersistentHashMap.fromArrays(inst_70851,inst_70852);
var inst_70854 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_70850,inst_70853);
var inst_70855 = (function(){throw inst_70854})();
var state_70884__$1 = state_70884;
var statearr_70926_70990 = state_70884__$1;
(statearr_70926_70990[(2)] = inst_70855);

(statearr_70926_70990[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (19))){
var inst_70793 = (state_70884[(8)]);
var inst_70808 = (state_70884[(2)]);
var state_70884__$1 = (function (){var statearr_70927 = state_70884;
(statearr_70927[(20)] = inst_70808);

return statearr_70927;
})();
if(cljs.core.truth_(inst_70793)){
var statearr_70928_70991 = state_70884__$1;
(statearr_70928_70991[(1)] = (20));

} else {
var statearr_70929_70992 = state_70884__$1;
(statearr_70929_70992[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (11))){
var inst_70795 = (state_70884[(14)]);
var inst_70793 = (state_70884[(8)]);
var inst_70792 = (state_70884[(2)]);
var inst_70793__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70792,(0),null);
var inst_70794 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70792,(1),null);
var inst_70795__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70796 = (inst_70793__$1 > inst_70795__$1);
var state_70884__$1 = (function (){var statearr_70931 = state_70884;
(statearr_70931[(14)] = inst_70795__$1);

(statearr_70931[(8)] = inst_70793__$1);

(statearr_70931[(7)] = inst_70794);

return statearr_70931;
})();
if(cljs.core.truth_(inst_70796)){
var statearr_70932_70993 = state_70884__$1;
(statearr_70932_70993[(1)] = (17));

} else {
var statearr_70933_70994 = state_70884__$1;
(statearr_70933_70994[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (9))){
var inst_70770 = (state_70884[(19)]);
var inst_70773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70774 = cljs.core.first(inst_70770);
var inst_70775 = fluree.db.time_travel.block_to_int_format(db,inst_70774);
var state_70884__$1 = (function (){var statearr_70934 = state_70884;
(statearr_70934[(12)] = inst_70773);

return statearr_70934;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70884__$1,(12),inst_70775);
} else {
if((state_val_70885 === (5))){
var _ = (function (){var statearr_70935 = state_70884;
(statearr_70935[(4)] = cljs.core.rest((state_70884[(4)])));

return statearr_70935;
})();
var state_70884__$1 = state_70884;
var ex70930 = (state_70884__$1[(2)]);
var statearr_70936_70995 = state_70884__$1;
(statearr_70936_70995[(5)] = ex70930);


var statearr_70937_70996 = state_70884__$1;
(statearr_70937_70996[(1)] = (4));

(statearr_70937_70996[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (14))){
var state_70884__$1 = state_70884;
var statearr_70938_70997 = state_70884__$1;
(statearr_70938_70997[(2)] = null);

(statearr_70938_70997[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (26))){
var inst_70793 = (state_70884[(8)]);
var inst_70819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70820 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_70821 = [inst_70793,inst_70820];
var inst_70822 = (new cljs.core.PersistentVector(null,2,(5),inst_70819,inst_70821,null));
var state_70884__$1 = state_70884;
var statearr_70939_70998 = state_70884__$1;
(statearr_70939_70998[(2)] = inst_70822);

(statearr_70939_70998[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (16))){
var inst_70783 = (state_70884[(2)]);
var inst_70784 = fluree.db.util.async.throw_err(inst_70783);
var state_70884__$1 = state_70884;
var statearr_70940_70999 = state_70884__$1;
(statearr_70940_70999[(2)] = inst_70784);

(statearr_70940_70999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (38))){
var inst_70840 = (state_70884[(9)]);
var inst_70839 = (state_70884[(10)]);
var inst_70861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70862 = [inst_70840,inst_70839];
var inst_70863 = (new cljs.core.PersistentVector(null,2,(5),inst_70861,inst_70862,null));
var state_70884__$1 = state_70884;
var statearr_70941_71000 = state_70884__$1;
(statearr_70941_71000[(2)] = inst_70863);

(statearr_70941_71000[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (30))){
var state_70884__$1 = state_70884;
var statearr_70942_71001 = state_70884__$1;
(statearr_70942_71001[(2)] = null);

(statearr_70942_71001[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (10))){
var inst_70770 = (state_70884[(19)]);
var state_70884__$1 = state_70884;
var statearr_70943_71002 = state_70884__$1;
(statearr_70943_71002[(2)] = inst_70770);

(statearr_70943_71002[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (18))){
var state_70884__$1 = state_70884;
var statearr_70944_71003 = state_70884__$1;
(statearr_70944_71003[(2)] = null);

(statearr_70944_71003[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (42))){
var inst_70871 = (state_70884[(15)]);
var state_70884__$1 = state_70884;
var statearr_70945_71004 = state_70884__$1;
(statearr_70945_71004[(2)] = inst_70871);

(statearr_70945_71004[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (37))){
var inst_70840 = (state_70884[(9)]);
var inst_70839 = (state_70884[(10)]);
var inst_70858 = (state_70884[(2)]);
var inst_70859 = (inst_70840 < inst_70839);
var state_70884__$1 = (function (){var statearr_70946 = state_70884;
(statearr_70946[(21)] = inst_70858);

return statearr_70946;
})();
if(cljs.core.truth_(inst_70859)){
var statearr_70947_71005 = state_70884__$1;
(statearr_70947_71005[(1)] = (38));

} else {
var statearr_70948_71006 = state_70884__$1;
(statearr_70948_71006[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70885 === (8))){
var inst_70770 = (state_70884[(19)]);
var inst_70770__$1 = (state_70884[(2)]);
var inst_70771 = cljs.core.some(cljs.core.string_QMARK_,inst_70770__$1);
var state_70884__$1 = (function (){var statearr_70949 = state_70884;
(statearr_70949[(19)] = inst_70770__$1);

return statearr_70949;
})();
if(cljs.core.truth_(inst_70771)){
var statearr_70950_71007 = state_70884__$1;
(statearr_70950_71007[(1)] = (9));

} else {
var statearr_70951_71008 = state_70884__$1;
(statearr_70951_71008[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_70952 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70952[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__);

(statearr_70952[(1)] = (1));

return statearr_70952;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_70884){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_70884);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e70953){var ex__2687__auto__ = e70953;
var statearr_70954_71009 = state_70884;
(statearr_70954_71009[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_70884[(4)]))){
var statearr_70955_71010 = state_70884;
(statearr_70955_71010[(1)] = cljs.core.first((state_70884[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71011 = state_70884;
state_70884 = G__71011;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__ = function(state_70884){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_70884);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_70956 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_70956[(6)] = c__2706__auto__);

return statearr_70956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__71013 = arguments.length;
switch (G__71013) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71107){
var state_val_71108 = (state_71107[(1)]);
if((state_val_71108 === (7))){
var inst_71039 = (state_71107[(7)]);
var inst_71042 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_71039);
var state_71107__$1 = state_71107;
var statearr_71109_71160 = state_71107__$1;
(statearr_71109_71160[(2)] = inst_71042);

(statearr_71109_71160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (20))){
var inst_71078 = (state_71107[(8)]);
var inst_71081 = fluree.db.api_js.format_block_resp_pretty(db,inst_71078);
var state_71107__$1 = state_71107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71107__$1,(23),inst_71081);
} else {
if((state_val_71108 === (27))){
var inst_71087 = (state_71107[(9)]);
var inst_71093 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_71087);
var state_71107__$1 = state_71107;
var statearr_71110_71161 = state_71107__$1;
(statearr_71110_71161[(2)] = inst_71093);

(statearr_71110_71161[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (1))){
var state_71107__$1 = state_71107;
var statearr_71111_71162 = state_71107__$1;
(statearr_71111_71162[(2)] = null);

(statearr_71111_71162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (24))){
var inst_71087 = (state_71107[(9)]);
var inst_71090 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_71091 = cljs.core.sequential_QMARK_(inst_71087);
var state_71107__$1 = (function (){var statearr_71112 = state_71107;
(statearr_71112[(10)] = inst_71090);

return statearr_71112;
})();
if(inst_71091){
var statearr_71113_71163 = state_71107__$1;
(statearr_71113_71163[(1)] = (27));

} else {
var statearr_71114_71164 = state_71107__$1;
(statearr_71114_71164[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (4))){
var inst_71014 = (state_71107[(2)]);
var inst_71015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71016 = [inst_71014];
var inst_71017 = (new cljs.core.PersistentVector(null,1,(5),inst_71015,inst_71016,null));
var inst_71018 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71017);
var inst_71019 = cljs.core.ex_data(inst_71014);
var inst_71020 = cljs.core.ex_message(inst_71014);
var inst_71021 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71019,new cljs.core.Keyword(null,"message","message",-406056002),inst_71020);
var state_71107__$1 = (function (){var statearr_71115 = state_71107;
(statearr_71115[(11)] = inst_71018);

return statearr_71115;
})();
var statearr_71116_71165 = state_71107__$1;
(statearr_71116_71165[(2)] = inst_71021);

(statearr_71116_71165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (15))){
var inst_71039 = (state_71107[(7)]);
var inst_71052 = (state_71107[(2)]);
var inst_71053 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71052,inst_71039);
var inst_71054 = (function(){throw inst_71053})();
var state_71107__$1 = state_71107;
var statearr_71117_71166 = state_71107__$1;
(statearr_71117_71166[(2)] = inst_71054);

(statearr_71117_71166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (21))){
var inst_71078 = (state_71107[(8)]);
var state_71107__$1 = state_71107;
var statearr_71118_71167 = state_71107__$1;
(statearr_71118_71167[(2)] = inst_71078);

(statearr_71118_71167[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (13))){
var inst_71047 = (state_71107[(12)]);
var state_71107__$1 = state_71107;
var statearr_71119_71168 = state_71107__$1;
(statearr_71119_71168[(2)] = inst_71047);

(statearr_71119_71168[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (22))){
var inst_71087 = (state_71107[(2)]);
var inst_71088 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71107__$1 = (function (){var statearr_71120 = state_71107;
(statearr_71120[(9)] = inst_71087);

return statearr_71120;
})();
if(cljs.core.truth_(inst_71088)){
var statearr_71121_71169 = state_71107__$1;
(statearr_71121_71169[(1)] = (24));

} else {
var statearr_71122_71170 = state_71107__$1;
(statearr_71122_71170[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (29))){
var inst_71031 = (state_71107[(13)]);
var inst_71090 = (state_71107[(10)]);
var inst_71096 = (state_71107[(2)]);
var inst_71097 = fluree.db.util.core.response_time_formatted(inst_71031);
var inst_71098 = [(200),inst_71096,(100),inst_71097];
var inst_71099 = cljs.core.PersistentHashMap.fromArrays(inst_71090,inst_71098);
var state_71107__$1 = state_71107;
var statearr_71123_71171 = state_71107__$1;
(statearr_71123_71171[(2)] = inst_71099);

(statearr_71123_71171[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (6))){
var inst_71040 = (state_71107[(14)]);
var inst_71039 = (state_71107[(7)]);
var inst_71038 = (state_71107[(2)]);
var inst_71039__$1 = fluree.db.util.async.throw_err(inst_71038);
var inst_71040__$1 = cljs.core.map_QMARK_(inst_71039__$1);
var state_71107__$1 = (function (){var statearr_71124 = state_71107;
(statearr_71124[(14)] = inst_71040__$1);

(statearr_71124[(7)] = inst_71039__$1);

return statearr_71124;
})();
if(inst_71040__$1){
var statearr_71125_71172 = state_71107__$1;
(statearr_71125_71172[(1)] = (7));

} else {
var statearr_71126_71173 = state_71107__$1;
(statearr_71126_71173[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (28))){
var inst_71087 = (state_71107[(9)]);
var state_71107__$1 = state_71107;
var statearr_71127_71174 = state_71107__$1;
(statearr_71127_71174[(2)] = inst_71087);

(statearr_71127_71174[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (25))){
var inst_71087 = (state_71107[(9)]);
var state_71107__$1 = state_71107;
var statearr_71128_71175 = state_71107__$1;
(statearr_71128_71175[(2)] = inst_71087);

(statearr_71128_71175[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (17))){
var inst_71070 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_71071 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_71070].join('');
var inst_71072 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71073 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71074 = cljs.core.PersistentHashMap.fromArrays(inst_71072,inst_71073);
var inst_71075 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71071,inst_71074);
var inst_71076 = (function(){throw inst_71075})();
var state_71107__$1 = state_71107;
var statearr_71129_71176 = state_71107__$1;
(statearr_71129_71176[(2)] = inst_71076);

(statearr_71129_71176[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (3))){
var inst_71105 = (state_71107[(2)]);
var state_71107__$1 = state_71107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71107__$1,inst_71105);
} else {
if((state_val_71108 === (12))){
var inst_71039 = (state_71107[(7)]);
var inst_71057 = (state_71107[(2)]);
var inst_71058 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71039,(0),null);
var inst_71059 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71039,(1),null);
var inst_71060 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_71061 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_71062 = cljs.core.keys(inst_71061);
var inst_71063 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_71060,inst_71062);
var state_71107__$1 = (function (){var statearr_71130 = state_71107;
(statearr_71130[(15)] = inst_71058);

(statearr_71130[(16)] = inst_71059);

(statearr_71130[(17)] = inst_71057);

return statearr_71130;
})();
if(inst_71063){
var statearr_71131_71177 = state_71107__$1;
(statearr_71131_71177[(1)] = (16));

} else {
var statearr_71132_71178 = state_71107__$1;
(statearr_71132_71178[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (2))){
var _ = (function (){var statearr_71133 = state_71107;
(statearr_71133[(4)] = cljs.core.cons((5),(state_71107[(4)])));

return statearr_71133;
})();
var inst_71031 = fluree.db.util.core.current_time_millis();
var inst_71032 = db;
var inst_71033 = cljs.core.__destructure_map(inst_71032);
var inst_71034 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71033,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_71035 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71033,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_71036 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_71107__$1 = (function (){var statearr_71134 = state_71107;
(statearr_71134[(18)] = inst_71035);

(statearr_71134[(13)] = inst_71031);

(statearr_71134[(19)] = inst_71034);

return statearr_71134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71107__$1,(6),inst_71036);
} else {
if((state_val_71108 === (23))){
var inst_71083 = (state_71107[(2)]);
var inst_71084 = fluree.db.util.async.throw_err(inst_71083);
var state_71107__$1 = state_71107;
var statearr_71135_71179 = state_71107__$1;
(statearr_71135_71179[(2)] = inst_71084);

(statearr_71135_71179[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (19))){
var inst_71067 = (state_71107[(2)]);
var inst_71068 = fluree.db.util.async.throw_err(inst_71067);
var state_71107__$1 = state_71107;
var statearr_71136_71180 = state_71107__$1;
(statearr_71136_71180[(2)] = inst_71068);

(statearr_71136_71180[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (11))){
var state_71107__$1 = state_71107;
var statearr_71138_71181 = state_71107__$1;
(statearr_71138_71181[(2)] = null);

(statearr_71138_71181[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (9))){
var inst_71045 = (state_71107[(2)]);
var state_71107__$1 = state_71107;
if(cljs.core.truth_(inst_71045)){
var statearr_71139_71182 = state_71107__$1;
(statearr_71139_71182[(1)] = (10));

} else {
var statearr_71140_71183 = state_71107__$1;
(statearr_71140_71183[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (5))){
var _ = (function (){var statearr_71141 = state_71107;
(statearr_71141[(4)] = cljs.core.rest((state_71107[(4)])));

return statearr_71141;
})();
var state_71107__$1 = state_71107;
var ex71137 = (state_71107__$1[(2)]);
var statearr_71142_71184 = state_71107__$1;
(statearr_71142_71184[(5)] = ex71137);


var statearr_71143_71185 = state_71107__$1;
(statearr_71143_71185[(1)] = (4));

(statearr_71143_71185[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (14))){
var inst_71035 = (state_71107[(18)]);
var inst_71034 = (state_71107[(19)]);
var inst_71050 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71034),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71035)].join('');
var state_71107__$1 = state_71107;
var statearr_71144_71186 = state_71107__$1;
(statearr_71144_71186[(2)] = inst_71050);

(statearr_71144_71186[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (26))){
var inst_71102 = (state_71107[(2)]);
var _ = (function (){var statearr_71145 = state_71107;
(statearr_71145[(4)] = cljs.core.rest((state_71107[(4)])));

return statearr_71145;
})();
var state_71107__$1 = state_71107;
var statearr_71146_71187 = state_71107__$1;
(statearr_71146_71187[(2)] = inst_71102);

(statearr_71146_71187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (16))){
var inst_71058 = (state_71107[(15)]);
var inst_71059 = (state_71107[(16)]);
var inst_71065 = fluree.db.query.block.block_range(db,inst_71058,inst_71059,opts);
var state_71107__$1 = state_71107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71107__$1,(19),inst_71065);
} else {
if((state_val_71108 === (10))){
var inst_71039 = (state_71107[(7)]);
var inst_71047 = (state_71107[(12)]);
var inst_71047__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_71039);
var state_71107__$1 = (function (){var statearr_71147 = state_71107;
(statearr_71147[(12)] = inst_71047__$1);

return statearr_71147;
})();
if(cljs.core.truth_(inst_71047__$1)){
var statearr_71148_71188 = state_71107__$1;
(statearr_71148_71188[(1)] = (13));

} else {
var statearr_71149_71189 = state_71107__$1;
(statearr_71149_71189[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (18))){
var inst_71078 = (state_71107[(2)]);
var inst_71079 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_71107__$1 = (function (){var statearr_71150 = state_71107;
(statearr_71150[(8)] = inst_71078);

return statearr_71150;
})();
if(cljs.core.truth_(inst_71079)){
var statearr_71151_71190 = state_71107__$1;
(statearr_71151_71190[(1)] = (20));

} else {
var statearr_71152_71191 = state_71107__$1;
(statearr_71152_71191[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71108 === (8))){
var inst_71040 = (state_71107[(14)]);
var state_71107__$1 = state_71107;
var statearr_71153_71192 = state_71107__$1;
(statearr_71153_71192[(2)] = inst_71040);

(statearr_71153_71192[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_71154 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71154[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_71154[(1)] = (1));

return statearr_71154;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_71107){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71107);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71155){var ex__2687__auto__ = e71155;
var statearr_71156_71193 = state_71107;
(statearr_71156_71193[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71107[(4)]))){
var statearr_71157_71194 = state_71107;
(statearr_71157_71194[(1)] = cljs.core.first((state_71107[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71195 = state_71107;
state_71107 = G__71195;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_71107){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_71107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71158 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71158[(6)] = c__2706__auto__);

return statearr_71158;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__71197 = arguments.length;
switch (G__71197) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71392){
var state_val_71393 = (state_71392[(1)]);
if((state_val_71393 === (62))){
var inst_71390 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71392__$1,inst_71390);
} else {
if((state_val_71393 === (7))){
var inst_71218 = (state_71392[(7)]);
var inst_71228 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_71218);
var state_71392__$1 = state_71392;
var statearr_71394_71485 = state_71392__$1;
(statearr_71394_71485[(2)] = inst_71228);

(statearr_71394_71485[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (59))){
var inst_71378 = (state_71392[(2)]);
var inst_71379 = fluree.db.util.async.throw_err(inst_71378);
var state_71392__$1 = state_71392;
var statearr_71395_71486 = state_71392__$1;
(statearr_71395_71486[(2)] = inst_71379);

(statearr_71395_71486[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (20))){
var inst_71286 = (state_71392[(8)]);
var inst_71294 = (state_71392[(9)]);
var inst_71286__$1 = (state_71392[(2)]);
var inst_71287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71286__$1,(0));
var inst_71289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71286__$1,(1));
var inst_71290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71286__$1,(2));
var inst_71291 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71286__$1,(3));
var inst_71292 = [inst_71288,inst_71289,inst_71290,inst_71291];
var inst_71293 = (new cljs.core.PersistentVector(null,4,(5),inst_71287,inst_71292,null));
var inst_71294__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71293,(0),null);
var inst_71295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71293,(1),null);
var inst_71296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71293,(2),null);
var inst_71297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71293,(3),null);
var inst_71298 = (inst_71294__$1 == null);
var inst_71299 = cljs.core.not(inst_71298);
var state_71392__$1 = (function (){var statearr_71396 = state_71392;
(statearr_71396[(10)] = inst_71295);

(statearr_71396[(11)] = inst_71296);

(statearr_71396[(12)] = inst_71297);

(statearr_71396[(8)] = inst_71286__$1);

(statearr_71396[(9)] = inst_71294__$1);

return statearr_71396;
})();
if(inst_71299){
var statearr_71397_71487 = state_71392__$1;
(statearr_71397_71487[(1)] = (30));

} else {
var statearr_71398_71488 = state_71392__$1;
(statearr_71398_71488[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (58))){
var inst_71226 = (state_71392[(13)]);
var inst_71382 = (state_71392[(2)]);
var state_71392__$1 = (function (){var statearr_71399 = state_71392;
(statearr_71399[(14)] = inst_71382);

return statearr_71399;
})();
if(cljs.core.truth_(inst_71226)){
var statearr_71400_71489 = state_71392__$1;
(statearr_71400_71489[(1)] = (60));

} else {
var statearr_71401_71490 = state_71392__$1;
(statearr_71401_71490[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (60))){
var inst_71382 = (state_71392[(14)]);
var inst_71370 = (state_71392[(15)]);
var inst_71384 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_71385 = cljs.core.count(inst_71370);
var inst_71386 = [inst_71382,inst_71385,(200)];
var inst_71387 = cljs.core.PersistentHashMap.fromArrays(inst_71384,inst_71386);
var state_71392__$1 = state_71392;
var statearr_71402_71491 = state_71392__$1;
(statearr_71402_71491[(2)] = inst_71387);

(statearr_71402_71491[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (27))){
var inst_71205 = (state_71392[(16)]);
var inst_71274 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71205)].join('');
var inst_71275 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71276 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71277 = cljs.core.PersistentHashMap.fromArrays(inst_71275,inst_71276);
var inst_71278 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71274,inst_71277);
var inst_71279 = (function(){throw inst_71278})();
var state_71392__$1 = state_71392;
var statearr_71403_71492 = state_71392__$1;
(statearr_71403_71492[(2)] = inst_71279);

(statearr_71403_71492[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (1))){
var inst_71202 = query_map;
var inst_71203 = cljs.core.__destructure_map(inst_71202);
var inst_71204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71203,new cljs.core.Keyword(null,"block","block",664686210));
var inst_71205 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71203,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_71206 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_71203,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_71392__$1 = (function (){var statearr_71404 = state_71392;
(statearr_71404[(17)] = inst_71204);

(statearr_71404[(18)] = inst_71206);

(statearr_71404[(16)] = inst_71205);

return statearr_71404;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(2),sources);
} else {
if((state_val_71393 === (24))){
var inst_71205 = (state_71392[(16)]);
var inst_71263 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71205)].join('');
var inst_71264 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71265 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71266 = cljs.core.PersistentHashMap.fromArrays(inst_71264,inst_71265);
var inst_71267 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71263,inst_71266);
var inst_71268 = (function(){throw inst_71267})();
var state_71392__$1 = state_71392;
var statearr_71405_71493 = state_71392__$1;
(statearr_71405_71493[(2)] = inst_71268);

(statearr_71405_71493[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (55))){
var inst_71206 = (state_71392[(18)]);
var inst_71373 = (state_71392[(2)]);
var inst_71374 = fluree.db.util.async.throw_err(inst_71373);
var state_71392__$1 = (function (){var statearr_71406 = state_71392;
(statearr_71406[(19)] = inst_71374);

return statearr_71406;
})();
if(cljs.core.truth_(inst_71206)){
var statearr_71407_71494 = state_71392__$1;
(statearr_71407_71494[(1)] = (56));

} else {
var statearr_71408_71495 = state_71392__$1;
(statearr_71408_71495[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (39))){
var inst_71295 = (state_71392[(10)]);
var inst_71296 = (state_71392[(11)]);
var inst_71297 = (state_71392[(12)]);
var inst_71294 = (state_71392[(9)]);
var inst_71318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71320 = [inst_71295,inst_71294,inst_71296,inst_71297];
var inst_71321 = (new cljs.core.PersistentVector(null,4,(5),inst_71319,inst_71320,null));
var inst_71322 = [inst_71321,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_71323 = (new cljs.core.PersistentVector(null,2,(5),inst_71318,inst_71322,null));
var state_71392__$1 = state_71392;
var statearr_71409_71496 = state_71392__$1;
(statearr_71409_71496[(2)] = inst_71323);

(statearr_71409_71496[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (46))){
var inst_71328 = (state_71392[(20)]);
var state_71392__$1 = state_71392;
var statearr_71410_71497 = state_71392__$1;
(statearr_71410_71497[(2)] = inst_71328);

(statearr_71410_71497[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (4))){
var state_71392__$1 = state_71392;
var statearr_71411_71498 = state_71392__$1;
(statearr_71411_71498[(2)] = null);

(statearr_71411_71498[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (54))){
var inst_71370 = (state_71392[(15)]);
var inst_71209 = (state_71392[(21)]);
var inst_71369 = (state_71392[(2)]);
var inst_71370__$1 = fluree.db.util.async.throw_err(inst_71369);
var inst_71371 = fluree.db.api_js.format_history_resp(inst_71209,inst_71370__$1);
var state_71392__$1 = (function (){var statearr_71412 = state_71392;
(statearr_71412[(15)] = inst_71370__$1);

return statearr_71412;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(55),inst_71371);
} else {
if((state_val_71393 === (15))){
var inst_71209 = (state_71392[(21)]);
var inst_71250 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71209);
var state_71392__$1 = state_71392;
var statearr_71413_71499 = state_71392__$1;
(statearr_71413_71499[(2)] = inst_71250);

(statearr_71413_71499[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (48))){
var inst_71295 = (state_71392[(10)]);
var inst_71296 = (state_71392[(11)]);
var inst_71297 = (state_71392[(12)]);
var inst_71294 = (state_71392[(9)]);
var inst_71339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71341 = [inst_71295,inst_71296,inst_71294,inst_71297];
var inst_71342 = (new cljs.core.PersistentVector(null,4,(5),inst_71340,inst_71341,null));
var inst_71343 = [inst_71342,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_71344 = (new cljs.core.PersistentVector(null,2,(5),inst_71339,inst_71343,null));
var state_71392__$1 = state_71392;
var statearr_71414_71500 = state_71392__$1;
(statearr_71414_71500[(2)] = inst_71344);

(statearr_71414_71500[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (50))){
var inst_71357 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71415_71501 = state_71392__$1;
(statearr_71415_71501[(2)] = inst_71357);

(statearr_71415_71501[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (21))){
var inst_71205 = (state_71392[(16)]);
var inst_71261 = cljs.core.empty_QMARK_(inst_71205);
var state_71392__$1 = state_71392;
if(inst_71261){
var statearr_71416_71502 = state_71392__$1;
(statearr_71416_71502[(1)] = (24));

} else {
var statearr_71417_71503 = state_71392__$1;
(statearr_71417_71503[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (31))){
var inst_71305 = (state_71392[(22)]);
var inst_71294 = (state_71392[(9)]);
var inst_71305__$1 = (inst_71294 == null);
var state_71392__$1 = (function (){var statearr_71418 = state_71392;
(statearr_71418[(22)] = inst_71305__$1);

return statearr_71418;
})();
if(cljs.core.truth_(inst_71305__$1)){
var statearr_71419_71504 = state_71392__$1;
(statearr_71419_71504[(1)] = (33));

} else {
var statearr_71420_71505 = state_71392__$1;
(statearr_71420_71505[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (32))){
var inst_71242 = (state_71392[(23)]);
var inst_71209 = (state_71392[(21)]);
var inst_71252 = (state_71392[(24)]);
var inst_71361 = (state_71392[(2)]);
var inst_71362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71361,(0),null);
var inst_71363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71361,(1),null);
var inst_71364 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_71365 = [inst_71242,inst_71252];
var inst_71366 = cljs.core.PersistentHashMap.fromArrays(inst_71364,inst_71365);
var inst_71367 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_71209,inst_71363,cljs.core._EQ_,inst_71362,inst_71366);
var state_71392__$1 = state_71392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(54),inst_71367);
} else {
if((state_val_71393 === (40))){
var inst_71325 = (state_71392[(25)]);
var inst_71294 = (state_71392[(9)]);
var inst_71325__$1 = (inst_71294 == null);
var state_71392__$1 = (function (){var statearr_71421 = state_71392;
(statearr_71421[(25)] = inst_71325__$1);

return statearr_71421;
})();
if(cljs.core.truth_(inst_71325__$1)){
var statearr_71422_71506 = state_71392__$1;
(statearr_71422_71506[(1)] = (42));

} else {
var statearr_71423_71507 = state_71392__$1;
(statearr_71423_71507[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (56))){
var inst_71209 = (state_71392[(21)]);
var inst_71374 = (state_71392[(19)]);
var inst_71376 = fluree.db.api_js.format_block_resp_pretty(inst_71209,inst_71374);
var state_71392__$1 = state_71392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(59),inst_71376);
} else {
if((state_val_71393 === (33))){
var inst_71295 = (state_71392[(10)]);
var inst_71308 = (state_71392[(26)]);
var inst_71307 = (inst_71295 == null);
var inst_71308__$1 = cljs.core.not(inst_71307);
var state_71392__$1 = (function (){var statearr_71424 = state_71392;
(statearr_71424[(26)] = inst_71308__$1);

return statearr_71424;
})();
if(inst_71308__$1){
var statearr_71425_71508 = state_71392__$1;
(statearr_71425_71508[(1)] = (36));

} else {
var statearr_71426_71509 = state_71392__$1;
(statearr_71426_71509[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (13))){
var inst_71236 = (state_71392[(2)]);
var inst_71237 = fluree.db.util.async.throw_err(inst_71236);
var inst_71238 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71237);
var inst_71239 = (inst_71238 - (1));
var state_71392__$1 = state_71392;
var statearr_71427_71510 = state_71392__$1;
(statearr_71427_71510[(2)] = inst_71239);

(statearr_71427_71510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (22))){
var state_71392__$1 = state_71392;
var statearr_71428_71511 = state_71392__$1;
(statearr_71428_71511[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (36))){
var inst_71296 = (state_71392[(11)]);
var inst_71310 = (inst_71296 == null);
var state_71392__$1 = state_71392;
var statearr_71430_71512 = state_71392__$1;
(statearr_71430_71512[(2)] = inst_71310);

(statearr_71430_71512[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (41))){
var inst_71359 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71431_71513 = state_71392__$1;
(statearr_71431_71513[(2)] = inst_71359);

(statearr_71431_71513[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (43))){
var inst_71325 = (state_71392[(25)]);
var state_71392__$1 = state_71392;
var statearr_71432_71514 = state_71392__$1;
(statearr_71432_71514[(2)] = inst_71325);

(statearr_71432_71514[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (61))){
var inst_71382 = (state_71392[(14)]);
var state_71392__$1 = state_71392;
var statearr_71433_71515 = state_71392__$1;
(statearr_71433_71515[(2)] = inst_71382);

(statearr_71433_71515[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (29))){
var inst_71282 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71434_71516 = state_71392__$1;
(statearr_71434_71516[(2)] = inst_71282);

(statearr_71434_71516[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (44))){
var inst_71337 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
if(cljs.core.truth_(inst_71337)){
var statearr_71435_71517 = state_71392__$1;
(statearr_71435_71517[(1)] = (48));

} else {
var statearr_71436_71518 = state_71392__$1;
(statearr_71436_71518[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (6))){
var inst_71213 = (state_71392[(2)]);
var inst_71214 = fluree.db.util.async.throw_err(inst_71213);
var state_71392__$1 = state_71392;
var statearr_71437_71519 = state_71392__$1;
(statearr_71437_71519[(2)] = inst_71214);

(statearr_71437_71519[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (28))){
var state_71392__$1 = state_71392;
var statearr_71438_71520 = state_71392__$1;
(statearr_71438_71520[(2)] = null);

(statearr_71438_71520[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (51))){
var inst_71205 = (state_71392[(16)]);
var inst_71347 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_71205)].join('');
var inst_71348 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_71349 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_71350 = cljs.core.PersistentHashMap.fromArrays(inst_71348,inst_71349);
var inst_71351 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_71347,inst_71350);
var inst_71352 = (function(){throw inst_71351})();
var state_71392__$1 = state_71392;
var statearr_71439_71521 = state_71392__$1;
(statearr_71439_71521[(2)] = inst_71352);

(statearr_71439_71521[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (25))){
var inst_71205 = (state_71392[(16)]);
var state_71392__$1 = state_71392;
var statearr_71440_71522 = state_71392__$1;
(statearr_71440_71522[(2)] = inst_71205);

(statearr_71440_71522[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (34))){
var inst_71305 = (state_71392[(22)]);
var state_71392__$1 = state_71392;
var statearr_71441_71523 = state_71392__$1;
(statearr_71441_71523[(2)] = inst_71305);

(statearr_71441_71523[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (17))){
var inst_71246 = (state_71392[(2)]);
var inst_71247 = fluree.db.util.async.throw_err(inst_71246);
var inst_71248 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_71247);
var state_71392__$1 = state_71392;
var statearr_71442_71524 = state_71392__$1;
(statearr_71442_71524[(2)] = inst_71248);

(statearr_71442_71524[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (3))){
var inst_71209 = (state_71392[(21)]);
var inst_71211 = fluree.db.api_js.resolve_block_range(inst_71209,query_map);
var state_71392__$1 = state_71392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(6),inst_71211);
} else {
if((state_val_71393 === (12))){
var inst_71219 = (state_71392[(27)]);
var inst_71242 = (state_71392[(2)]);
var state_71392__$1 = (function (){var statearr_71443 = state_71392;
(statearr_71443[(23)] = inst_71242);

return statearr_71443;
})();
if(cljs.core.truth_(inst_71219)){
var statearr_71444_71525 = state_71392__$1;
(statearr_71444_71525[(1)] = (14));

} else {
var statearr_71445_71526 = state_71392__$1;
(statearr_71445_71526[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (2))){
var inst_71204 = (state_71392[(17)]);
var inst_71208 = (state_71392[(2)]);
var inst_71209 = fluree.db.util.async.throw_err(inst_71208);
var state_71392__$1 = (function (){var statearr_71446 = state_71392;
(statearr_71446[(21)] = inst_71209);

return statearr_71446;
})();
if(cljs.core.truth_(inst_71204)){
var statearr_71447_71527 = state_71392__$1;
(statearr_71447_71527[(1)] = (3));

} else {
var statearr_71448_71528 = state_71392__$1;
(statearr_71448_71528[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (23))){
var inst_71284 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71449_71529 = state_71392__$1;
(statearr_71449_71529[(2)] = inst_71284);

(statearr_71449_71529[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (47))){
var inst_71334 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71450_71530 = state_71392__$1;
(statearr_71450_71530[(2)] = inst_71334);

(statearr_71450_71530[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (35))){
var inst_71316 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
if(cljs.core.truth_(inst_71316)){
var statearr_71451_71531 = state_71392__$1;
(statearr_71451_71531[(1)] = (39));

} else {
var statearr_71452_71532 = state_71392__$1;
(statearr_71452_71532[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (19))){
var inst_71205 = (state_71392[(16)]);
var inst_71259 = cljs.core.sequential_QMARK_(inst_71205);
var state_71392__$1 = state_71392;
if(inst_71259){
var statearr_71453_71533 = state_71392__$1;
(statearr_71453_71533[(1)] = (21));

} else {
var statearr_71454_71534 = state_71392__$1;
(statearr_71454_71534[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (57))){
var inst_71374 = (state_71392[(19)]);
var state_71392__$1 = state_71392;
var statearr_71455_71535 = state_71392__$1;
(statearr_71455_71535[(2)] = inst_71374);

(statearr_71455_71535[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (11))){
var state_71392__$1 = state_71392;
var statearr_71456_71536 = state_71392__$1;
(statearr_71456_71536[(2)] = (-1));

(statearr_71456_71536[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (9))){
var inst_71231 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
if(cljs.core.truth_(inst_71231)){
var statearr_71457_71537 = state_71392__$1;
(statearr_71457_71537[(1)] = (10));

} else {
var statearr_71458_71538 = state_71392__$1;
(statearr_71458_71538[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (5))){
var inst_71218 = (state_71392[(7)]);
var inst_71217 = (state_71392[(2)]);
var inst_71218__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71217,(0),null);
var inst_71219 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71217,(1),null);
var inst_71226 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_71392__$1 = (function (){var statearr_71459 = state_71392;
(statearr_71459[(13)] = inst_71226);

(statearr_71459[(7)] = inst_71218__$1);

(statearr_71459[(27)] = inst_71219);

return statearr_71459;
})();
if(cljs.core.truth_(inst_71218__$1)){
var statearr_71460_71539 = state_71392__$1;
(statearr_71460_71539[(1)] = (7));

} else {
var statearr_71461_71540 = state_71392__$1;
(statearr_71461_71540[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (14))){
var inst_71209 = (state_71392[(21)]);
var inst_71219 = (state_71392[(27)]);
var inst_71244 = fluree.db.time_travel.as_of_block(inst_71209,inst_71219);
var state_71392__$1 = state_71392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(17),inst_71244);
} else {
if((state_val_71393 === (45))){
var inst_71296 = (state_71392[(11)]);
var inst_71330 = (inst_71296 == null);
var inst_71331 = cljs.core.not(inst_71330);
var state_71392__$1 = state_71392;
var statearr_71462_71541 = state_71392__$1;
(statearr_71462_71541[(2)] = inst_71331);

(statearr_71462_71541[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (53))){
var inst_71355 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71463_71542 = state_71392__$1;
(statearr_71463_71542[(2)] = inst_71355);

(statearr_71463_71542[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (26))){
var inst_71271 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71464_71543 = state_71392__$1;
(statearr_71464_71543[(2)] = inst_71271);

(statearr_71464_71543[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (16))){
var inst_71205 = (state_71392[(16)]);
var inst_71252 = (state_71392[(2)]);
var inst_71253 = fluree.db.util.core.subj_ident_QMARK_(inst_71205);
var state_71392__$1 = (function (){var statearr_71465 = state_71392;
(statearr_71465[(24)] = inst_71252);

return statearr_71465;
})();
if(inst_71253){
var statearr_71466_71544 = state_71392__$1;
(statearr_71466_71544[(1)] = (18));

} else {
var statearr_71467_71545 = state_71392__$1;
(statearr_71467_71545[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (38))){
var inst_71313 = (state_71392[(2)]);
var state_71392__$1 = state_71392;
var statearr_71468_71546 = state_71392__$1;
(statearr_71468_71546[(2)] = inst_71313);

(statearr_71468_71546[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (30))){
var inst_71286 = (state_71392[(8)]);
var inst_71301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71302 = [inst_71286,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_71303 = (new cljs.core.PersistentVector(null,2,(5),inst_71301,inst_71302,null));
var state_71392__$1 = state_71392;
var statearr_71469_71547 = state_71392__$1;
(statearr_71469_71547[(2)] = inst_71303);

(statearr_71469_71547[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (10))){
var inst_71218 = (state_71392[(7)]);
var inst_71209 = (state_71392[(21)]);
var inst_71233 = (inst_71218 - (1));
var inst_71234 = fluree.db.time_travel.as_of_block(inst_71209,inst_71233);
var state_71392__$1 = state_71392;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71392__$1,(13),inst_71234);
} else {
if((state_val_71393 === (18))){
var inst_71205 = (state_71392[(16)]);
var inst_71255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71256 = [inst_71205];
var inst_71257 = (new cljs.core.PersistentVector(null,1,(5),inst_71255,inst_71256,null));
var state_71392__$1 = state_71392;
var statearr_71470_71548 = state_71392__$1;
(statearr_71470_71548[(2)] = inst_71257);

(statearr_71470_71548[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (52))){
var state_71392__$1 = state_71392;
var statearr_71471_71549 = state_71392__$1;
(statearr_71471_71549[(2)] = null);

(statearr_71471_71549[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (42))){
var inst_71295 = (state_71392[(10)]);
var inst_71328 = (state_71392[(20)]);
var inst_71327 = (inst_71295 == null);
var inst_71328__$1 = cljs.core.not(inst_71327);
var state_71392__$1 = (function (){var statearr_71472 = state_71392;
(statearr_71472[(20)] = inst_71328__$1);

return statearr_71472;
})();
if(inst_71328__$1){
var statearr_71473_71550 = state_71392__$1;
(statearr_71473_71550[(1)] = (45));

} else {
var statearr_71474_71551 = state_71392__$1;
(statearr_71474_71551[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (37))){
var inst_71308 = (state_71392[(26)]);
var state_71392__$1 = state_71392;
var statearr_71475_71552 = state_71392__$1;
(statearr_71475_71552[(2)] = inst_71308);

(statearr_71475_71552[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (8))){
var inst_71218 = (state_71392[(7)]);
var state_71392__$1 = state_71392;
var statearr_71476_71553 = state_71392__$1;
(statearr_71476_71553[(2)] = inst_71218);

(statearr_71476_71553[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71393 === (49))){
var state_71392__$1 = state_71392;
var statearr_71477_71554 = state_71392__$1;
(statearr_71477_71554[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_71479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71479[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_71479[(1)] = (1));

return statearr_71479;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_71392){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71392);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71480){var ex__2687__auto__ = e71480;
var statearr_71481_71555 = state_71392;
(statearr_71481_71555[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71392[(4)]))){
var statearr_71482_71556 = state_71392;
(statearr_71482_71556[(1)] = cljs.core.first((state_71392[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71557 = state_71392;
state_71392 = G__71557;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_71392){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_71392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71483 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71483[(6)] = c__2706__auto__);

return statearr_71483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__71565 = arguments.length;
switch (G__71565) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5804__auto__)){
var block = temp__5804__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__5043__auto__ = block;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__71558_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__71558_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71654){
var state_val_71655 = (state_71654[(1)]);
if((state_val_71655 === (7))){
var inst_71615 = (state_71654[(7)]);
var inst_71605 = (state_71654[(8)]);
var inst_71608 = (state_71654[(9)]);
var inst_71611 = (state_71654[(10)]);
var inst_71621 = (function (){var responses = inst_71605;
var responses_STAR_ = inst_71608;
var statuses = inst_71611;
var fuel = inst_71615;
return (function (p1__71561_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__71561_SHARP_);
});
})();
var inst_71622 = cljs.core.some(inst_71621,inst_71611);
var state_71654__$1 = state_71654;
if(cljs.core.truth_(inst_71622)){
var statearr_71656_71704 = state_71654__$1;
(statearr_71656_71704[(1)] = (9));

} else {
var statearr_71657_71705 = state_71654__$1;
(statearr_71657_71705[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (20))){
var inst_71649 = (state_71654[(2)]);
var state_71654__$1 = state_71654;
var statearr_71658_71706 = state_71654__$1;
(statearr_71658_71706[(2)] = inst_71649);

(statearr_71658_71706[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (1))){
var inst_71600 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_71601 = (function (){var c__2706__auto____$1 = inst_71600;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71598){
var state_val_71599 = (state_71598[(1)]);
if((state_val_71599 === (1))){
var inst_71566 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_71567 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_71568 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71567,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_71569 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_71570 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_71571 = cljs.core.PersistentHashMap.EMPTY;
var inst_71572 = inst_71566;
var inst_71573 = inst_71568;
var inst_71574 = inst_71569;
var inst_71575 = inst_71570;
var inst_71576 = inst_71571;
var state_71598__$1 = (function (){var statearr_71659 = state_71598;
(statearr_71659[(7)] = inst_71575);

(statearr_71659[(8)] = inst_71573);

(statearr_71659[(9)] = inst_71572);

(statearr_71659[(10)] = inst_71574);

(statearr_71659[(11)] = inst_71576);

return statearr_71659;
})();
var statearr_71660_71707 = state_71598__$1;
(statearr_71660_71707[(2)] = null);

(statearr_71660_71707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71599 === (2))){
var inst_71573 = (state_71598[(8)]);
var inst_71578 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71573);
var inst_71579 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_71578], 0));
var inst_71580 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71573,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71579);
var inst_71581 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_71580,db_fn);
var state_71598__$1 = state_71598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71598__$1,(4),inst_71581);
} else {
if((state_val_71599 === (3))){
var inst_71596 = (state_71598[(2)]);
var state_71598__$1 = state_71598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71598__$1,inst_71596);
} else {
if((state_val_71599 === (4))){
var inst_71572 = (state_71598[(9)]);
var inst_71574 = (state_71598[(10)]);
var inst_71576 = (state_71598[(11)]);
var inst_71583 = (state_71598[(2)]);
var inst_71584 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71576,inst_71572,inst_71583);
var inst_71585 = cljs.core.first(inst_71574);
var state_71598__$1 = (function (){var statearr_71661 = state_71598;
(statearr_71661[(12)] = inst_71584);

return statearr_71661;
})();
if(cljs.core.truth_(inst_71585)){
var statearr_71662_71708 = state_71598__$1;
(statearr_71662_71708[(1)] = (5));

} else {
var statearr_71663_71709 = state_71598__$1;
(statearr_71663_71709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71599 === (5))){
var inst_71584 = (state_71598[(12)]);
var inst_71575 = (state_71598[(7)]);
var inst_71574 = (state_71598[(10)]);
var inst_71587 = cljs.core.first(inst_71574);
var inst_71588 = cljs.core.first(inst_71575);
var inst_71589 = cljs.core.rest(inst_71574);
var inst_71590 = cljs.core.rest(inst_71575);
var inst_71572 = inst_71587;
var inst_71573 = inst_71588;
var inst_71574__$1 = inst_71589;
var inst_71575__$1 = inst_71590;
var inst_71576 = inst_71584;
var state_71598__$1 = (function (){var statearr_71664 = state_71598;
(statearr_71664[(7)] = inst_71575__$1);

(statearr_71664[(8)] = inst_71573);

(statearr_71664[(9)] = inst_71572);

(statearr_71664[(10)] = inst_71574__$1);

(statearr_71664[(11)] = inst_71576);

return statearr_71664;
})();
var statearr_71665_71710 = state_71598__$1;
(statearr_71665_71710[(2)] = null);

(statearr_71665_71710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71599 === (6))){
var inst_71584 = (state_71598[(12)]);
var state_71598__$1 = state_71598;
var statearr_71666_71711 = state_71598__$1;
(statearr_71666_71711[(2)] = inst_71584);

(statearr_71666_71711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71599 === (7))){
var inst_71594 = (state_71598[(2)]);
var state_71598__$1 = state_71598;
var statearr_71667_71712 = state_71598__$1;
(statearr_71667_71712[(2)] = inst_71594);

(statearr_71667_71712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_71668 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71668[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_71668[(1)] = (1));

return statearr_71668;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_71598){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71598);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71669){var ex__2687__auto__ = e71669;
var statearr_71670_71713 = state_71598;
(statearr_71670_71713[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71598[(4)]))){
var statearr_71671_71714 = state_71598;
(statearr_71671_71714[(1)] = cljs.core.first((state_71598[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71715 = state_71598;
state_71598 = G__71715;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_71598){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_71598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71672 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71672[(6)] = c__2706__auto____$1);

return statearr_71672;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_71602 = cljs.core.async.impl.dispatch.run(inst_71601);
var state_71654__$1 = (function (){var statearr_71673 = state_71654;
(statearr_71673[(11)] = inst_71602);

return statearr_71673;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71654__$1,(2),inst_71600);
} else {
if((state_val_71655 === (4))){
var inst_71605 = (state_71654[(8)]);
var state_71654__$1 = state_71654;
var statearr_71674_71716 = state_71654__$1;
(statearr_71674_71716[(2)] = inst_71605);

(statearr_71674_71716[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (15))){
var state_71654__$1 = state_71654;
var statearr_71675_71717 = state_71654__$1;
(statearr_71675_71717[(2)] = (400));

(statearr_71675_71717[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (13))){
var state_71654__$1 = state_71654;
var statearr_71676_71718 = state_71654__$1;
(statearr_71676_71718[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (6))){
var inst_71611 = (state_71654[(10)]);
var inst_71619 = cljs.core.first(inst_71611);
var state_71654__$1 = state_71654;
var statearr_71678_71719 = state_71654__$1;
(statearr_71678_71719[(2)] = inst_71619);

(statearr_71678_71719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (17))){
var inst_71632 = (state_71654[(2)]);
var state_71654__$1 = state_71654;
var statearr_71679_71720 = state_71654__$1;
(statearr_71679_71720[(2)] = inst_71632);

(statearr_71679_71720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (3))){
var inst_71615 = (state_71654[(7)]);
var inst_71605 = (state_71654[(8)]);
var inst_71608 = (state_71654[(9)]);
var inst_71611 = (state_71654[(10)]);
var inst_71610 = cljs.core.vals(inst_71605);
var inst_71611__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_71610);
var inst_71612 = (function (){var responses = inst_71605;
var responses_STAR_ = inst_71608;
var statuses = inst_71611__$1;
return (function (p1__71559_SHARP_){
var or__5045__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__71559_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (0);
}
});
})();
var inst_71613 = cljs.core.vals(inst_71605);
var inst_71614 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_71612,inst_71613);
var inst_71615__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_71614);
var inst_71616 = (function (){var responses = inst_71605;
var responses_STAR_ = inst_71608;
var statuses = inst_71611__$1;
var fuel = inst_71615__$1;
return (function (p1__71560_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__71560_SHARP_);
});
})();
var inst_71617 = cljs.core.every_QMARK_(inst_71616,inst_71611__$1);
var state_71654__$1 = (function (){var statearr_71680 = state_71654;
(statearr_71680[(7)] = inst_71615__$1);

(statearr_71680[(10)] = inst_71611__$1);

return statearr_71680;
})();
if(inst_71617){
var statearr_71681_71721 = state_71654__$1;
(statearr_71681_71721[(1)] = (6));

} else {
var statearr_71682_71722 = state_71654__$1;
(statearr_71682_71722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (12))){
var state_71654__$1 = state_71654;
var statearr_71683_71723 = state_71654__$1;
(statearr_71683_71723[(2)] = (500));

(statearr_71683_71723[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (2))){
var inst_71605 = (state_71654[(8)]);
var inst_71604 = (state_71654[(2)]);
var inst_71605__$1 = fluree.db.util.async.throw_err(inst_71604);
var inst_71606 = (function (){var responses = inst_71605__$1;
return (function (acc,index,response){
var resp = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_71607 = cljs.core.PersistentHashMap.EMPTY;
var inst_71608 = cljs.core.reduce_kv(inst_71606,inst_71607,inst_71605__$1);
var state_71654__$1 = (function (){var statearr_71684 = state_71654;
(statearr_71684[(8)] = inst_71605__$1);

(statearr_71684[(9)] = inst_71608);

return statearr_71684;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_71685_71724 = state_71654__$1;
(statearr_71685_71724[(1)] = (3));

} else {
var statearr_71686_71725 = state_71654__$1;
(statearr_71686_71725[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (19))){
var inst_71615 = (state_71654[(7)]);
var inst_71638 = (state_71654[(12)]);
var inst_71608 = (state_71654[(9)]);
var inst_71647 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_71608,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71638,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71615], 0));
var state_71654__$1 = state_71654;
var statearr_71687_71726 = state_71654__$1;
(statearr_71687_71726[(2)] = inst_71647);

(statearr_71687_71726[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (11))){
var inst_71636 = (state_71654[(2)]);
var state_71654__$1 = state_71654;
var statearr_71688_71727 = state_71654__$1;
(statearr_71688_71727[(2)] = inst_71636);

(statearr_71688_71727[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (9))){
var state_71654__$1 = state_71654;
var statearr_71689_71728 = state_71654__$1;
(statearr_71689_71728[(2)] = (207));

(statearr_71689_71728[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (5))){
var inst_71652 = (state_71654[(2)]);
var state_71654__$1 = state_71654;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71654__$1,inst_71652);
} else {
if((state_val_71655 === (14))){
var inst_71634 = (state_71654[(2)]);
var state_71654__$1 = state_71654;
var statearr_71690_71729 = state_71654__$1;
(statearr_71690_71729[(2)] = inst_71634);

(statearr_71690_71729[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (16))){
var state_71654__$1 = state_71654;
var statearr_71691_71730 = state_71654__$1;
(statearr_71691_71730[(2)] = null);

(statearr_71691_71730[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (10))){
var inst_71615 = (state_71654[(7)]);
var inst_71605 = (state_71654[(8)]);
var inst_71608 = (state_71654[(9)]);
var inst_71611 = (state_71654[(10)]);
var inst_71625 = (function (){var responses = inst_71605;
var responses_STAR_ = inst_71608;
var statuses = inst_71611;
var fuel = inst_71615;
return (function (p1__71562_SHARP_){
return ((499) < p1__71562_SHARP_);
});
})();
var inst_71626 = cljs.core.some(inst_71625,inst_71611);
var state_71654__$1 = state_71654;
if(cljs.core.truth_(inst_71626)){
var statearr_71692_71731 = state_71654__$1;
(statearr_71692_71731[(1)] = (12));

} else {
var statearr_71693_71732 = state_71654__$1;
(statearr_71693_71732[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (18))){
var inst_71615 = (state_71654[(7)]);
var inst_71638 = (state_71654[(12)]);
var inst_71608 = (state_71654[(9)]);
var inst_71643 = (state_71654[(13)]);
var inst_71645 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_71608,new cljs.core.Keyword(null,"status","status",-1997798413),inst_71638,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_71615,new cljs.core.Keyword(null,"block","block",664686210),inst_71643], 0));
var state_71654__$1 = state_71654;
var statearr_71694_71733 = state_71654__$1;
(statearr_71694_71733[(2)] = inst_71645);

(statearr_71694_71733[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71655 === (8))){
var inst_71615 = (state_71654[(7)]);
var inst_71638 = (state_71654[(12)]);
var inst_71605 = (state_71654[(8)]);
var inst_71608 = (state_71654[(9)]);
var inst_71643 = (state_71654[(13)]);
var inst_71611 = (state_71654[(10)]);
var inst_71638__$1 = (state_71654[(2)]);
var inst_71639 = (function (){var responses = inst_71605;
var responses_STAR_ = inst_71608;
var statuses = inst_71611;
var fuel = inst_71615;
var status = inst_71638__$1;
return (function (p1__71563_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__71563_SHARP_));
});
})();
var inst_71640 = cljs.core.vals(inst_71605);
var inst_71641 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_71639,inst_71640);
var inst_71642 = cljs.core.first(inst_71641);
var inst_71643__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_71642);
var state_71654__$1 = (function (){var statearr_71695 = state_71654;
(statearr_71695[(12)] = inst_71638__$1);

(statearr_71695[(13)] = inst_71643__$1);

return statearr_71695;
})();
if(cljs.core.truth_(inst_71643__$1)){
var statearr_71696_71734 = state_71654__$1;
(statearr_71696_71734[(1)] = (18));

} else {
var statearr_71697_71735 = state_71654__$1;
(statearr_71697_71735[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_71698 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71698[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_71698[(1)] = (1));

return statearr_71698;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_71654){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71654);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71699){var ex__2687__auto__ = e71699;
var statearr_71700_71736 = state_71654;
(statearr_71700_71736[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71654[(4)]))){
var statearr_71701_71737 = state_71654;
(statearr_71701_71737[(1)] = cljs.core.first((state_71654[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71738 = state_71654;
state_71654 = G__71738;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_71654){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_71654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71702 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71702[(6)] = c__2706__auto__);

return statearr_71702;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__71740 = arguments.length;
switch (G__71740) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var ledger_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__71741 = opts;
var map__71741__$1 = cljs.core.__destructure_map(map__71741);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71741__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71741__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71741__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__71741__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__71742 = (cljs.core.truth_((function (){var and__5043__auto__ = auth;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__5043__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71742,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__71742,(1),null);
var action__$1 = (function (){var or__5045__auto__ = action;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__5045__auto__ = nonce;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__5045__auto__ = expire;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e71745){var e = e71745;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__71748 = arguments.length;
switch (G__71748) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_71782){
var state_val_71783 = (state_71782[(1)]);
if((state_val_71783 === (7))){
var state_71782__$1 = state_71782;
var statearr_71784_71805 = state_71782__$1;
(statearr_71784_71805[(2)] = opts);

(statearr_71784_71805[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (1))){
var state_71782__$1 = state_71782;
var statearr_71785_71806 = state_71782__$1;
(statearr_71785_71806[(2)] = null);

(statearr_71785_71806[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (4))){
var inst_71749 = (state_71782[(2)]);
var inst_71750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71751 = [inst_71749];
var inst_71752 = (new cljs.core.PersistentVector(null,1,(5),inst_71750,inst_71751,null));
var inst_71753 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_71752);
var inst_71754 = cljs.core.ex_data(inst_71749);
var inst_71755 = cljs.core.ex_message(inst_71749);
var inst_71756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_71754,new cljs.core.Keyword(null,"message","message",-406056002),inst_71755);
var state_71782__$1 = (function (){var statearr_71786 = state_71782;
(statearr_71786[(7)] = inst_71753);

return statearr_71786;
})();
var statearr_71787_71807 = state_71782__$1;
(statearr_71787_71807[(2)] = inst_71756);

(statearr_71787_71807[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (6))){
var inst_71766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71767 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_71768 = (new cljs.core.PersistentVector(null,1,(5),inst_71766,inst_71767,null));
var inst_71769 = cljs.core.assoc_in(opts,inst_71768,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_71782__$1 = state_71782;
var statearr_71788_71808 = state_71782__$1;
(statearr_71788_71808[(2)] = inst_71769);

(statearr_71788_71808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (3))){
var inst_71780 = (state_71782[(2)]);
var state_71782__$1 = state_71782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71782__$1,inst_71780);
} else {
if((state_val_71783 === (2))){
var _ = (function (){var statearr_71790 = state_71782;
(statearr_71790[(4)] = cljs.core.cons((5),(state_71782[(4)])));

return statearr_71790;
})();
var inst_71762 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71763 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_71764 = (inst_71763 == null);
var state_71782__$1 = (function (){var statearr_71791 = state_71782;
(statearr_71791[(8)] = inst_71762);

return statearr_71791;
})();
if(cljs.core.truth_(inst_71764)){
var statearr_71792_71809 = state_71782__$1;
(statearr_71792_71809[(1)] = (6));

} else {
var statearr_71793_71810 = state_71782__$1;
(statearr_71793_71810[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (9))){
var inst_71776 = (state_71782[(2)]);
var inst_71777 = fluree.db.util.async.throw_err(inst_71776);
var _ = (function (){var statearr_71794 = state_71782;
(statearr_71794[(4)] = cljs.core.rest((state_71782[(4)])));

return statearr_71794;
})();
var state_71782__$1 = state_71782;
var statearr_71795_71811 = state_71782__$1;
(statearr_71795_71811[(2)] = inst_71777);

(statearr_71795_71811[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (5))){
var _ = (function (){var statearr_71796 = state_71782;
(statearr_71796[(4)] = cljs.core.rest((state_71782[(4)])));

return statearr_71796;
})();
var state_71782__$1 = state_71782;
var ex71789 = (state_71782__$1[(2)]);
var statearr_71797_71812 = state_71782__$1;
(statearr_71797_71812[(5)] = ex71789);


var statearr_71798_71813 = state_71782__$1;
(statearr_71798_71813[(1)] = (4));

(statearr_71798_71813[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71783 === (8))){
var inst_71762 = (state_71782[(8)]);
var inst_71772 = (state_71782[(2)]);
var inst_71773 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_71762,inst_71772);
var inst_71774 = fluree.db.operations.command_async(conn,inst_71773);
var state_71782__$1 = state_71782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71782__$1,(9),inst_71774);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2684__auto__ = null;
var fluree$db$api_js$state_machine__2684__auto____0 = (function (){
var statearr_71799 = [null,null,null,null,null,null,null,null,null];
(statearr_71799[(0)] = fluree$db$api_js$state_machine__2684__auto__);

(statearr_71799[(1)] = (1));

return statearr_71799;
});
var fluree$db$api_js$state_machine__2684__auto____1 = (function (state_71782){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_71782);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e71800){var ex__2687__auto__ = e71800;
var statearr_71801_71814 = state_71782;
(statearr_71801_71814[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_71782[(4)]))){
var statearr_71802_71815 = state_71782;
(statearr_71802_71815[(1)] = cljs.core.first((state_71782[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71816 = state_71782;
state_71782 = G__71816;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2684__auto__ = function(state_71782){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2684__auto____1.call(this,state_71782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2684__auto____0;
fluree$db$api_js$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2684__auto____1;
return fluree$db$api_js$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_71803 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_71803[(6)] = c__2706__auto__);

return statearr_71803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

