// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__65708 = arguments.length;
switch (G__65708) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2706__auto___65856 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_65795){
var state_val_65796 = (state_65795[(1)]);
if((state_val_65796 === (7))){
var inst_65726 = (state_65795[(7)]);
var inst_65729 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_65726);
var state_65795__$1 = state_65795;
var statearr_65797_65857 = state_65795__$1;
(statearr_65797_65857[(2)] = inst_65729);

(statearr_65797_65857[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (20))){
var inst_65721 = (state_65795[(8)]);
var inst_65750 = (state_65795[(9)]);
var inst_65754 = fluree.db.auth.roles(inst_65721,inst_65750);
var state_65795__$1 = state_65795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65795__$1,(23),inst_65754);
} else {
if((state_val_65796 === (27))){
var inst_65721 = (state_65795[(8)]);
var inst_65769 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65770 = fluree.db.time_travel.as_of_block(inst_65721,inst_65769);
var state_65795__$1 = state_65795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65795__$1,(30),inst_65770);
} else {
if((state_val_65796 === (1))){
var state_65795__$1 = state_65795;
var statearr_65798_65858 = state_65795__$1;
(statearr_65798_65858[(2)] = null);

(statearr_65798_65858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (24))){
var inst_65721 = (state_65795[(8)]);
var inst_65762 = (state_65795[(10)]);
var inst_65764 = fluree.db.permissions.permission_map(inst_65721,inst_65762,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65795__$1 = state_65795;
var statearr_65799_65859 = state_65795__$1;
(statearr_65799_65859[(2)] = inst_65764);

(statearr_65799_65859[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (4))){
var inst_65709 = (state_65795[(2)]);
var inst_65710 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65709);
var inst_65711 = cljs.core.async.close_BANG_(pc);
var state_65795__$1 = (function (){var statearr_65800 = state_65795;
(statearr_65800[(11)] = inst_65710);

return statearr_65800;
})();
var statearr_65801_65860 = state_65795__$1;
(statearr_65801_65860[(2)] = inst_65711);

(statearr_65801_65860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (15))){
var inst_65726 = (state_65795[(7)]);
var inst_65740 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65726)," unknown."].join('');
var inst_65741 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65742 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65743 = cljs.core.PersistentHashMap.fromArrays(inst_65741,inst_65742);
var inst_65744 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65740,inst_65743);
var inst_65745 = (function(){throw inst_65744})();
var state_65795__$1 = state_65795;
var statearr_65802_65861 = state_65795__$1;
(statearr_65802_65861[(2)] = inst_65745);

(statearr_65802_65861[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (21))){
var state_65795__$1 = state_65795;
var statearr_65803_65862 = state_65795__$1;
(statearr_65803_65862[(2)] = null);

(statearr_65803_65862[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (31))){
var inst_65726 = (state_65795[(7)]);
var inst_65776 = (state_65795[(12)]);
var inst_65778 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65776,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65726);
var state_65795__$1 = state_65795;
var statearr_65804_65863 = state_65795__$1;
(statearr_65804_65863[(2)] = inst_65778);

(statearr_65804_65863[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (32))){
var inst_65776 = (state_65795[(12)]);
var state_65795__$1 = state_65795;
var statearr_65805_65864 = state_65795__$1;
(statearr_65805_65864[(2)] = inst_65776);

(statearr_65805_65864[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (33))){
var inst_65762 = (state_65795[(10)]);
var inst_65781 = (state_65795[(2)]);
var state_65795__$1 = (function (){var statearr_65806 = state_65795;
(statearr_65806[(13)] = inst_65781);

return statearr_65806;
})();
if(cljs.core.truth_(inst_65762)){
var statearr_65807_65865 = state_65795__$1;
(statearr_65807_65865[(1)] = (34));

} else {
var statearr_65808_65866 = state_65795__$1;
(statearr_65808_65866[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (13))){
var inst_65737 = (state_65795[(14)]);
var inst_65736 = (state_65795[(2)]);
var inst_65737__$1 = fluree.db.util.async.throw_err(inst_65736);
var state_65795__$1 = (function (){var statearr_65809 = state_65795;
(statearr_65809[(14)] = inst_65737__$1);

return statearr_65809;
})();
if(cljs.core.truth_(inst_65737__$1)){
var statearr_65810_65867 = state_65795__$1;
(statearr_65810_65867[(1)] = (14));

} else {
var statearr_65811_65868 = state_65795__$1;
(statearr_65811_65868[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (22))){
var inst_65760 = (state_65795[(2)]);
var state_65795__$1 = state_65795;
var statearr_65812_65869 = state_65795__$1;
(statearr_65812_65869[(2)] = inst_65760);

(statearr_65812_65869[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (36))){
var inst_65789 = (state_65795[(2)]);
var inst_65790 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65789);
var _ = (function (){var statearr_65813 = state_65795;
(statearr_65813[(4)] = cljs.core.rest((state_65795[(4)])));

return statearr_65813;
})();
var state_65795__$1 = state_65795;
var statearr_65814_65870 = state_65795__$1;
(statearr_65814_65870[(2)] = inst_65790);

(statearr_65814_65870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (29))){
var inst_65726 = (state_65795[(7)]);
var inst_65776 = (state_65795[(2)]);
var state_65795__$1 = (function (){var statearr_65815 = state_65795;
(statearr_65815[(12)] = inst_65776);

return statearr_65815;
})();
if(cljs.core.truth_(inst_65726)){
var statearr_65816_65871 = state_65795__$1;
(statearr_65816_65871[(1)] = (31));

} else {
var statearr_65817_65872 = state_65795__$1;
(statearr_65817_65872[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (6))){
var inst_65726 = (state_65795[(7)]);
var inst_65720 = (state_65795[(2)]);
var inst_65721 = fluree.db.util.async.throw_err(inst_65720);
var inst_65722 = opts;
var inst_65723 = cljs.core.__destructure_map(inst_65722);
var inst_65724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65723,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_65725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65723,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_65726__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65723,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65727 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65723,new cljs.core.Keyword(null,"block","block",664686210));
var state_65795__$1 = (function (){var statearr_65818 = state_65795;
(statearr_65818[(8)] = inst_65721);

(statearr_65818[(15)] = inst_65727);

(statearr_65818[(7)] = inst_65726__$1);

(statearr_65818[(16)] = inst_65725);

(statearr_65818[(17)] = inst_65724);

return statearr_65818;
})();
if(cljs.core.truth_(inst_65726__$1)){
var statearr_65819_65873 = state_65795__$1;
(statearr_65819_65873[(1)] = (7));

} else {
var statearr_65820_65874 = state_65795__$1;
(statearr_65820_65874[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (28))){
var inst_65721 = (state_65795[(8)]);
var state_65795__$1 = state_65795;
var statearr_65821_65875 = state_65795__$1;
(statearr_65821_65875[(2)] = inst_65721);

(statearr_65821_65875[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (25))){
var state_65795__$1 = state_65795;
var statearr_65822_65876 = state_65795__$1;
(statearr_65822_65876[(2)] = null);

(statearr_65822_65876[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (34))){
var inst_65767 = (state_65795[(18)]);
var state_65795__$1 = state_65795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65795__$1,(37),inst_65767);
} else {
if((state_val_65796 === (17))){
var inst_65724 = (state_65795[(17)]);
var state_65795__$1 = state_65795;
var statearr_65823_65877 = state_65795__$1;
(statearr_65823_65877[(2)] = inst_65724);

(statearr_65823_65877[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (3))){
var inst_65793 = (state_65795[(2)]);
var state_65795__$1 = state_65795;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65795__$1,inst_65793);
} else {
if((state_val_65796 === (12))){
var inst_65724 = (state_65795[(17)]);
var inst_65750 = (state_65795[(2)]);
var state_65795__$1 = (function (){var statearr_65824 = state_65795;
(statearr_65824[(9)] = inst_65750);

return statearr_65824;
})();
if(cljs.core.truth_(inst_65724)){
var statearr_65825_65878 = state_65795__$1;
(statearr_65825_65878[(1)] = (17));

} else {
var statearr_65826_65879 = state_65795__$1;
(statearr_65826_65879[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (2))){
var _ = (function (){var statearr_65827 = state_65795;
(statearr_65827[(4)] = cljs.core.cons((5),(state_65795[(4)])));

return statearr_65827;
})();
var inst_65718 = fluree.db.session.db(conn,ledger,null);
var state_65795__$1 = state_65795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65795__$1,(6),inst_65718);
} else {
if((state_val_65796 === (23))){
var inst_65756 = (state_65795[(2)]);
var inst_65757 = fluree.db.util.async.throw_err(inst_65756);
var state_65795__$1 = state_65795;
var statearr_65828_65880 = state_65795__$1;
(statearr_65828_65880[(2)] = inst_65757);

(statearr_65828_65880[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (35))){
var inst_65781 = (state_65795[(13)]);
var state_65795__$1 = state_65795;
var statearr_65829_65881 = state_65795__$1;
(statearr_65829_65881[(2)] = inst_65781);

(statearr_65829_65881[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (19))){
var inst_65762 = (state_65795[(10)]);
var inst_65762__$1 = (state_65795[(2)]);
var state_65795__$1 = (function (){var statearr_65830 = state_65795;
(statearr_65830[(10)] = inst_65762__$1);

return statearr_65830;
})();
if(cljs.core.truth_(inst_65762__$1)){
var statearr_65831_65882 = state_65795__$1;
(statearr_65831_65882[(1)] = (24));

} else {
var statearr_65832_65883 = state_65795__$1;
(statearr_65832_65883[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (11))){
var state_65795__$1 = state_65795;
var statearr_65834_65884 = state_65795__$1;
(statearr_65834_65884[(2)] = null);

(statearr_65834_65884[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (9))){
var inst_65732 = (state_65795[(2)]);
var state_65795__$1 = state_65795;
if(cljs.core.truth_(inst_65732)){
var statearr_65835_65885 = state_65795__$1;
(statearr_65835_65885[(1)] = (10));

} else {
var statearr_65836_65886 = state_65795__$1;
(statearr_65836_65886[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (5))){
var _ = (function (){var statearr_65837 = state_65795;
(statearr_65837[(4)] = cljs.core.rest((state_65795[(4)])));

return statearr_65837;
})();
var state_65795__$1 = state_65795;
var ex65833 = (state_65795__$1[(2)]);
var statearr_65838_65887 = state_65795__$1;
(statearr_65838_65887[(5)] = ex65833);


var statearr_65839_65888 = state_65795__$1;
(statearr_65839_65888[(1)] = (4));

(statearr_65839_65888[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (14))){
var inst_65737 = (state_65795[(14)]);
var state_65795__$1 = state_65795;
var statearr_65840_65889 = state_65795__$1;
(statearr_65840_65889[(2)] = inst_65737);

(statearr_65840_65889[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (26))){
var inst_65727 = (state_65795[(15)]);
var inst_65767 = (state_65795[(2)]);
var state_65795__$1 = (function (){var statearr_65841 = state_65795;
(statearr_65841[(18)] = inst_65767);

return statearr_65841;
})();
if(cljs.core.truth_(inst_65727)){
var statearr_65842_65890 = state_65795__$1;
(statearr_65842_65890[(1)] = (27));

} else {
var statearr_65843_65891 = state_65795__$1;
(statearr_65843_65891[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (16))){
var inst_65747 = (state_65795[(2)]);
var state_65795__$1 = state_65795;
var statearr_65844_65892 = state_65795__$1;
(statearr_65844_65892[(2)] = inst_65747);

(statearr_65844_65892[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (30))){
var inst_65772 = (state_65795[(2)]);
var inst_65773 = fluree.db.util.async.throw_err(inst_65772);
var state_65795__$1 = state_65795;
var statearr_65845_65893 = state_65795__$1;
(statearr_65845_65893[(2)] = inst_65773);

(statearr_65845_65893[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (10))){
var inst_65721 = (state_65795[(8)]);
var inst_65726 = (state_65795[(7)]);
var inst_65734 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_65721,inst_65726);
var state_65795__$1 = state_65795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65795__$1,(13),inst_65734);
} else {
if((state_val_65796 === (18))){
var inst_65750 = (state_65795[(9)]);
var state_65795__$1 = state_65795;
if(cljs.core.truth_(inst_65750)){
var statearr_65846_65894 = state_65795__$1;
(statearr_65846_65894[(1)] = (20));

} else {
var statearr_65847_65895 = state_65795__$1;
(statearr_65847_65895[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (37))){
var inst_65781 = (state_65795[(13)]);
var inst_65784 = (state_65795[(2)]);
var inst_65785 = fluree.db.util.async.throw_err(inst_65784);
var inst_65786 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65781,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65785);
var state_65795__$1 = state_65795;
var statearr_65848_65896 = state_65795__$1;
(statearr_65848_65896[(2)] = inst_65786);

(statearr_65848_65896[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65796 === (8))){
var inst_65726 = (state_65795[(7)]);
var state_65795__$1 = state_65795;
var statearr_65849_65897 = state_65795__$1;
(statearr_65849_65897[(2)] = inst_65726);

(statearr_65849_65897[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2684__auto__ = null;
var fluree$db$api$query$state_machine__2684__auto____0 = (function (){
var statearr_65850 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65850[(0)] = fluree$db$api$query$state_machine__2684__auto__);

(statearr_65850[(1)] = (1));

return statearr_65850;
});
var fluree$db$api$query$state_machine__2684__auto____1 = (function (state_65795){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_65795);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e65851){var ex__2687__auto__ = e65851;
var statearr_65852_65898 = state_65795;
(statearr_65852_65898[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_65795[(4)]))){
var statearr_65853_65899 = state_65795;
(statearr_65853_65899[(1)] = cljs.core.first((state_65795[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65900 = state_65795;
state_65795 = G__65900;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2684__auto__ = function(state_65795){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2684__auto____1.call(this,state_65795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2684__auto____0;
fluree$db$api$query$state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2684__auto____1;
return fluree$db$api$query$state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_65854 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_65854[(6)] = c__2706__auto___65856);

return statearr_65854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66041){
var state_val_66042 = (state_66041[(1)]);
if((state_val_66042 === (7))){
var inst_65921 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65922 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65923 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65924 = [inst_65922,inst_65923];
var inst_65925 = (new cljs.core.PersistentVector(null,2,(5),inst_65921,inst_65924,null));
var state_66041__$1 = state_66041;
var statearr_66043_66113 = state_66041__$1;
(statearr_66043_66113[(2)] = inst_65925);

(statearr_66043_66113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (20))){
var inst_65951 = (state_66041[(7)]);
var state_66041__$1 = state_66041;
var statearr_66044_66114 = state_66041__$1;
(statearr_66044_66114[(2)] = inst_65951);

(statearr_66044_66114[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (27))){
var state_66041__$1 = state_66041;
var statearr_66045_66115 = state_66041__$1;
(statearr_66045_66115[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (1))){
var state_66041__$1 = state_66041;
var statearr_66047_66116 = state_66041__$1;
(statearr_66047_66116[(2)] = null);

(statearr_66047_66116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (24))){
var inst_65950 = (state_66041[(8)]);
var state_66041__$1 = state_66041;
if(cljs.core.truth_(inst_65950)){
var statearr_66048_66117 = state_66041__$1;
(statearr_66048_66117[(1)] = (26));

} else {
var statearr_66049_66118 = state_66041__$1;
(statearr_66049_66118[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (39))){
var inst_65996 = (state_66041[(9)]);
var inst_65997 = (state_66041[(10)]);
var inst_66022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66023 = [inst_65996,inst_65997];
var inst_66024 = (new cljs.core.PersistentVector(null,2,(5),inst_66022,inst_66023,null));
var state_66041__$1 = state_66041;
var statearr_66050_66119 = state_66041__$1;
(statearr_66050_66119[(2)] = inst_66024);

(statearr_66050_66119[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (4))){
var inst_65901 = (state_66041[(2)]);
var state_66041__$1 = state_66041;
var statearr_66051_66120 = state_66041__$1;
(statearr_66051_66120[(2)] = inst_65901);

(statearr_66051_66120[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (15))){
var inst_65930 = (state_66041[(11)]);
var inst_65935 = (state_66041[(12)]);
var inst_65944 = (state_66041[(2)]);
var inst_65945 = [inst_65935,inst_65944];
var inst_65946 = (new cljs.core.PersistentVector(null,2,(5),inst_65930,inst_65945,null));
var state_66041__$1 = state_66041;
var statearr_66052_66121 = state_66041__$1;
(statearr_66052_66121[(2)] = inst_65946);

(statearr_66052_66121[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (21))){
var inst_65950 = (state_66041[(8)]);
var state_66041__$1 = state_66041;
var statearr_66053_66122 = state_66041__$1;
(statearr_66053_66122[(2)] = inst_65950);

(statearr_66053_66122[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (31))){
var inst_65991 = (state_66041[(2)]);
var state_66041__$1 = state_66041;
var statearr_66054_66123 = state_66041__$1;
(statearr_66054_66123[(2)] = inst_65991);

(statearr_66054_66123[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (32))){
var inst_65997 = (state_66041[(10)]);
var inst_66000 = cljs.core.pos_int_QMARK_(inst_65997);
var state_66041__$1 = state_66041;
var statearr_66055_66124 = state_66041__$1;
(statearr_66055_66124[(2)] = inst_66000);

(statearr_66055_66124[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (40))){
var inst_66028 = (state_66041[(13)]);
var inst_65952 = (state_66041[(14)]);
var inst_66026 = (state_66041[(2)]);
var inst_66027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66026,(0),null);
var inst_66028__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66026,(1),null);
var inst_66029 = (inst_66028__$1 > inst_65952);
var state_66041__$1 = (function (){var statearr_66056 = state_66041;
(statearr_66056[(13)] = inst_66028__$1);

(statearr_66056[(15)] = inst_66027);

return statearr_66056;
})();
if(cljs.core.truth_(inst_66029)){
var statearr_66057_66125 = state_66041__$1;
(statearr_66057_66125[(1)] = (41));

} else {
var statearr_66058_66126 = state_66041__$1;
(statearr_66058_66126[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (33))){
var inst_65998 = (state_66041[(16)]);
var state_66041__$1 = state_66041;
var statearr_66059_66127 = state_66041__$1;
(statearr_66059_66127[(2)] = inst_65998);

(statearr_66059_66127[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (13))){
var inst_65936 = (state_66041[(17)]);
var inst_65938 = fluree.db.time_travel.block_to_int_format(db,inst_65936);
var state_66041__$1 = state_66041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66041__$1,(16),inst_65938);
} else {
if((state_val_66042 === (22))){
var inst_65969 = (state_66041[(2)]);
var state_66041__$1 = state_66041;
if(cljs.core.truth_(inst_65969)){
var statearr_66060_66128 = state_66041__$1;
(statearr_66060_66128[(1)] = (23));

} else {
var statearr_66061_66129 = state_66041__$1;
(statearr_66061_66129[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (36))){
var state_66041__$1 = state_66041;
var statearr_66062_66130 = state_66041__$1;
(statearr_66062_66130[(2)] = null);

(statearr_66062_66130[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (41))){
var inst_65952 = (state_66041[(14)]);
var state_66041__$1 = state_66041;
var statearr_66063_66131 = state_66041__$1;
(statearr_66063_66131[(2)] = inst_65952);

(statearr_66063_66131[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (43))){
var inst_66027 = (state_66041[(15)]);
var inst_66033 = (state_66041[(2)]);
var inst_66034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66035 = [inst_66027,inst_66033];
var inst_66036 = (new cljs.core.PersistentVector(null,2,(5),inst_66034,inst_66035,null));
var _ = (function (){var statearr_66064 = state_66041;
(statearr_66064[(4)] = cljs.core.rest((state_66041[(4)])));

return statearr_66064;
})();
var state_66041__$1 = state_66041;
var statearr_66065_66132 = state_66041__$1;
(statearr_66065_66132[(2)] = inst_66036);

(statearr_66065_66132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (29))){
var inst_65927 = (state_66041[(18)]);
var inst_65982 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65927], 0));
var inst_65983 = ["Invalid block range provided: ",inst_65982].join('');
var inst_65984 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65985 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65986 = cljs.core.PersistentHashMap.fromArrays(inst_65984,inst_65985);
var inst_65987 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65983,inst_65986);
var inst_65988 = (function(){throw inst_65987})();
var state_66041__$1 = state_66041;
var statearr_66066_66133 = state_66041__$1;
(statearr_66066_66133[(2)] = inst_65988);

(statearr_66066_66133[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (6))){
var inst_65919 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_66041__$1 = state_66041;
var statearr_66067_66134 = state_66041__$1;
(statearr_66067_66134[(2)] = inst_65919);

(statearr_66067_66134[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (28))){
var inst_65993 = (state_66041[(2)]);
var state_66041__$1 = state_66041;
var statearr_66068_66135 = state_66041__$1;
(statearr_66068_66135[(2)] = inst_65993);

(statearr_66068_66135[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (25))){
var inst_65996 = (state_66041[(9)]);
var inst_65998 = (state_66041[(16)]);
var inst_65995 = (state_66041[(2)]);
var inst_65996__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65995,(0),null);
var inst_65997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65995,(1),null);
var inst_65998__$1 = cljs.core.pos_int_QMARK_(inst_65996__$1);
var state_66041__$1 = (function (){var statearr_66069 = state_66041;
(statearr_66069[(9)] = inst_65996__$1);

(statearr_66069[(16)] = inst_65998__$1);

(statearr_66069[(10)] = inst_65997);

return statearr_66069;
})();
if(inst_65998__$1){
var statearr_66070_66136 = state_66041__$1;
(statearr_66070_66136[(1)] = (32));

} else {
var statearr_66071_66137 = state_66041__$1;
(statearr_66071_66137[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (34))){
var inst_66003 = (state_66041[(2)]);
var inst_66004 = cljs.core.not(inst_66003);
var state_66041__$1 = state_66041;
if(inst_66004){
var statearr_66072_66138 = state_66041__$1;
(statearr_66072_66138[(1)] = (35));

} else {
var statearr_66073_66139 = state_66041__$1;
(statearr_66073_66139[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (17))){
var inst_65950 = (state_66041[(8)]);
var inst_65952 = (state_66041[(14)]);
var inst_65955 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65950], 0));
var inst_65956 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65952], 0));
var inst_65957 = ["Start block is out of range for this ledger. Start block provided: ",inst_65955,". Database block: ",inst_65956].join('');
var inst_65958 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65959 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65960 = cljs.core.PersistentHashMap.fromArrays(inst_65958,inst_65959);
var inst_65961 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65957,inst_65960);
var inst_65962 = (function(){throw inst_65961})();
var state_66041__$1 = state_66041;
var statearr_66074_66140 = state_66041__$1;
(statearr_66074_66140[(2)] = inst_65962);

(statearr_66074_66140[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (3))){
var inst_66039 = (state_66041[(2)]);
var state_66041__$1 = state_66041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66041__$1,inst_66039);
} else {
if((state_val_66042 === (12))){
var inst_65927 = (state_66041[(18)]);
var inst_65936 = (state_66041[(17)]);
var inst_65934 = (state_66041[(2)]);
var inst_65935 = fluree.db.util.async.throw_err(inst_65934);
var inst_65936__$1 = cljs.core.second(inst_65927);
var state_66041__$1 = (function (){var statearr_66075 = state_66041;
(statearr_66075[(17)] = inst_65936__$1);

(statearr_66075[(12)] = inst_65935);

return statearr_66075;
})();
if(cljs.core.truth_(inst_65936__$1)){
var statearr_66076_66141 = state_66041__$1;
(statearr_66076_66141[(1)] = (13));

} else {
var statearr_66077_66142 = state_66041__$1;
(statearr_66077_66142[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (2))){
var _ = (function (){var statearr_66078 = state_66041;
(statearr_66078[(4)] = cljs.core.cons((5),(state_66041[(4)])));

return statearr_66078;
})();
var inst_65916 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65917 = cljs.core.sequential_QMARK_(inst_65916);
var state_66041__$1 = state_66041;
if(inst_65917){
var statearr_66079_66143 = state_66041__$1;
(statearr_66079_66143[(1)] = (6));

} else {
var statearr_66080_66144 = state_66041__$1;
(statearr_66080_66144[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (23))){
var inst_65951 = (state_66041[(7)]);
var inst_65950 = (state_66041[(8)]);
var inst_65971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65972 = [inst_65950,inst_65951];
var inst_65973 = (new cljs.core.PersistentVector(null,2,(5),inst_65971,inst_65972,null));
var state_66041__$1 = state_66041;
var statearr_66081_66145 = state_66041__$1;
(statearr_66081_66145[(2)] = inst_65973);

(statearr_66081_66145[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (35))){
var inst_65927 = (state_66041[(18)]);
var inst_66006 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65927], 0));
var inst_66007 = ["Invalid block range provided: ",inst_66006].join('');
var inst_66008 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66009 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66010 = cljs.core.PersistentHashMap.fromArrays(inst_66008,inst_66009);
var inst_66011 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66007,inst_66010);
var inst_66012 = (function(){throw inst_66011})();
var state_66041__$1 = state_66041;
var statearr_66082_66146 = state_66041__$1;
(statearr_66082_66146[(2)] = inst_66012);

(statearr_66082_66146[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (19))){
var inst_65950 = (state_66041[(8)]);
var inst_65965 = (state_66041[(2)]);
var state_66041__$1 = (function (){var statearr_66083 = state_66041;
(statearr_66083[(19)] = inst_65965);

return statearr_66083;
})();
if(cljs.core.truth_(inst_65950)){
var statearr_66084_66147 = state_66041__$1;
(statearr_66084_66147[(1)] = (20));

} else {
var statearr_66085_66148 = state_66041__$1;
(statearr_66085_66148[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (11))){
var inst_65950 = (state_66041[(8)]);
var inst_65952 = (state_66041[(14)]);
var inst_65949 = (state_66041[(2)]);
var inst_65950__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65949,(0),null);
var inst_65951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65949,(1),null);
var inst_65952__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65953 = (inst_65950__$1 > inst_65952__$1);
var state_66041__$1 = (function (){var statearr_66087 = state_66041;
(statearr_66087[(7)] = inst_65951);

(statearr_66087[(8)] = inst_65950__$1);

(statearr_66087[(14)] = inst_65952__$1);

return statearr_66087;
})();
if(cljs.core.truth_(inst_65953)){
var statearr_66088_66149 = state_66041__$1;
(statearr_66088_66149[(1)] = (17));

} else {
var statearr_66089_66150 = state_66041__$1;
(statearr_66089_66150[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (9))){
var inst_65927 = (state_66041[(18)]);
var inst_65930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65931 = cljs.core.first(inst_65927);
var inst_65932 = fluree.db.time_travel.block_to_int_format(db,inst_65931);
var state_66041__$1 = (function (){var statearr_66090 = state_66041;
(statearr_66090[(11)] = inst_65930);

return statearr_66090;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66041__$1,(12),inst_65932);
} else {
if((state_val_66042 === (5))){
var _ = (function (){var statearr_66091 = state_66041;
(statearr_66091[(4)] = cljs.core.rest((state_66041[(4)])));

return statearr_66091;
})();
var state_66041__$1 = state_66041;
var ex66086 = (state_66041__$1[(2)]);
var statearr_66092_66151 = state_66041__$1;
(statearr_66092_66151[(5)] = ex66086);


if((ex66086 instanceof Error)){
var statearr_66093_66152 = state_66041__$1;
(statearr_66093_66152[(1)] = (4));

(statearr_66093_66152[(5)] = null);

} else {
throw ex66086;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (14))){
var state_66041__$1 = state_66041;
var statearr_66094_66153 = state_66041__$1;
(statearr_66094_66153[(2)] = null);

(statearr_66094_66153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (26))){
var inst_65950 = (state_66041[(8)]);
var inst_65976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65977 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65978 = [inst_65950,inst_65977];
var inst_65979 = (new cljs.core.PersistentVector(null,2,(5),inst_65976,inst_65978,null));
var state_66041__$1 = state_66041;
var statearr_66095_66154 = state_66041__$1;
(statearr_66095_66154[(2)] = inst_65979);

(statearr_66095_66154[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (16))){
var inst_65940 = (state_66041[(2)]);
var inst_65941 = fluree.db.util.async.throw_err(inst_65940);
var state_66041__$1 = state_66041;
var statearr_66096_66155 = state_66041__$1;
(statearr_66096_66155[(2)] = inst_65941);

(statearr_66096_66155[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (38))){
var inst_65996 = (state_66041[(9)]);
var inst_65997 = (state_66041[(10)]);
var inst_66018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66019 = [inst_65997,inst_65996];
var inst_66020 = (new cljs.core.PersistentVector(null,2,(5),inst_66018,inst_66019,null));
var state_66041__$1 = state_66041;
var statearr_66097_66156 = state_66041__$1;
(statearr_66097_66156[(2)] = inst_66020);

(statearr_66097_66156[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (30))){
var state_66041__$1 = state_66041;
var statearr_66098_66157 = state_66041__$1;
(statearr_66098_66157[(2)] = null);

(statearr_66098_66157[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (10))){
var inst_65927 = (state_66041[(18)]);
var state_66041__$1 = state_66041;
var statearr_66099_66158 = state_66041__$1;
(statearr_66099_66158[(2)] = inst_65927);

(statearr_66099_66158[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (18))){
var state_66041__$1 = state_66041;
var statearr_66100_66159 = state_66041__$1;
(statearr_66100_66159[(2)] = null);

(statearr_66100_66159[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (42))){
var inst_66028 = (state_66041[(13)]);
var state_66041__$1 = state_66041;
var statearr_66101_66160 = state_66041__$1;
(statearr_66101_66160[(2)] = inst_66028);

(statearr_66101_66160[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (37))){
var inst_65996 = (state_66041[(9)]);
var inst_65997 = (state_66041[(10)]);
var inst_66015 = (state_66041[(2)]);
var inst_66016 = (inst_65997 < inst_65996);
var state_66041__$1 = (function (){var statearr_66102 = state_66041;
(statearr_66102[(20)] = inst_66015);

return statearr_66102;
})();
if(cljs.core.truth_(inst_66016)){
var statearr_66103_66161 = state_66041__$1;
(statearr_66103_66161[(1)] = (38));

} else {
var statearr_66104_66162 = state_66041__$1;
(statearr_66104_66162[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66042 === (8))){
var inst_65927 = (state_66041[(18)]);
var inst_65927__$1 = (state_66041[(2)]);
var inst_65928 = cljs.core.some(cljs.core.string_QMARK_,inst_65927__$1);
var state_66041__$1 = (function (){var statearr_66105 = state_66041;
(statearr_66105[(18)] = inst_65927__$1);

return statearr_66105;
})();
if(cljs.core.truth_(inst_65928)){
var statearr_66106_66163 = state_66041__$1;
(statearr_66106_66163[(1)] = (9));

} else {
var statearr_66107_66164 = state_66041__$1;
(statearr_66107_66164[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0 = (function (){
var statearr_66108 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66108[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__);

(statearr_66108[(1)] = (1));

return statearr_66108;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1 = (function (state_66041){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66041);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66109){var ex__2687__auto__ = e66109;
var statearr_66110_66165 = state_66041;
(statearr_66110_66165[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66041[(4)]))){
var statearr_66111_66166 = state_66041;
(statearr_66111_66166[(1)] = cljs.core.first((state_66041[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66167 = state_66041;
state_66041 = G__66167;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__ = function(state_66041){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1.call(this,state_66041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66112 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66112[(6)] = c__2706__auto__);

return statearr_66112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66317){
var state_val_66318 = (state_66317[(1)]);
if((state_val_66318 === (7))){
var inst_66229 = (state_66317[(2)]);
var inst_66230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66229,(0),null);
var inst_66231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66229,(1),null);
var inst_66239 = cljs.core.vals(inst_66231);
var inst_66240 = cljs.core.seq(inst_66239);
var inst_66241 = cljs.core.first(inst_66240);
var inst_66242 = cljs.core.next(inst_66240);
var inst_66243 = cljs.core.PersistentVector.EMPTY;
var inst_66244 = inst_66239;
var inst_66245 = inst_66243;
var state_66317__$1 = (function (){var statearr_66319 = state_66317;
(statearr_66319[(7)] = inst_66230);

(statearr_66319[(8)] = inst_66241);

(statearr_66319[(9)] = inst_66245);

(statearr_66319[(10)] = inst_66244);

(statearr_66319[(11)] = inst_66242);

return statearr_66319;
})();
var statearr_66320_66373 = state_66317__$1;
(statearr_66320_66373[(2)] = null);

(statearr_66320_66373[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (20))){
var inst_66251 = (state_66317[(12)]);
var inst_66256 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66257 = cljs.core.PersistentHashMap.EMPTY;
var inst_66258 = [true,inst_66257];
var inst_66259 = cljs.core.PersistentHashMap.fromArrays(inst_66256,inst_66258);
var inst_66260 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_66259,inst_66251);
var state_66317__$1 = state_66317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66317__$1,(22),inst_66260);
} else {
if((state_val_66318 === (27))){
var inst_66305 = (state_66317[(2)]);
var state_66317__$1 = state_66317;
var statearr_66321_66374 = state_66317__$1;
(statearr_66321_66374[(2)] = inst_66305);

(statearr_66321_66374[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (1))){
var state_66317__$1 = state_66317;
var statearr_66322_66375 = state_66317__$1;
(statearr_66322_66375[(2)] = null);

(statearr_66322_66375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (24))){
var inst_66269 = (state_66317[(13)]);
var inst_66307 = (state_66317[(2)]);
var inst_66308 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_66309 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66310 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66311 = [inst_66309,inst_66310,inst_66269,inst_66307];
var inst_66312 = cljs.core.PersistentHashMap.fromArrays(inst_66308,inst_66311);
var _ = (function (){var statearr_66324 = state_66317;
(statearr_66324[(4)] = cljs.core.rest((state_66317[(4)])));

return statearr_66324;
})();
var state_66317__$1 = state_66317;
var statearr_66325_66376 = state_66317__$1;
(statearr_66325_66376[(2)] = inst_66312);

(statearr_66325_66376[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (4))){
var inst_66170 = (state_66317[(2)]);
var state_66317__$1 = state_66317;
var statearr_66326_66377 = state_66317__$1;
(statearr_66326_66377[(2)] = inst_66170);

(statearr_66326_66377[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (15))){
var inst_66200 = (state_66317[(14)]);
var inst_66201 = (state_66317[(15)]);
var inst_66210 = (state_66317[(16)]);
var inst_66193 = (state_66317[(17)]);
var inst_66189 = (state_66317[(18)]);
var inst_66192 = (state_66317[(19)]);
var inst_66208 = (state_66317[(20)]);
var inst_66186 = (state_66317[(21)]);
var inst_66215 = (state_66317[(22)]);
var inst_66188 = (state_66317[(23)]);
var inst_66194 = (state_66317[(24)]);
var inst_66221 = (function (){var subject = inst_66208;
var flake = inst_66200;
var first__66198 = inst_66200;
var r = inst_66201;
var G__66182 = inst_66192;
var asserted_subjects = inst_66193;
var seq__66184 = inst_66189;
var flake_SINGLEQUOTE_ = inst_66215;
var retracted_subjects = inst_66194;
var seq__66197 = inst_66201;
var asserted_QMARK_ = inst_66210;
var vec__66196 = inst_66192;
var vec__66183 = inst_66186;
var first__66185 = inst_66188;
return (function (p1__66169_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__66169_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_66222 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_66194,inst_66208,inst_66221);
var tmp66323 = inst_66193;
var inst_66192__$1 = inst_66201;
var inst_66193__$1 = tmp66323;
var inst_66194__$1 = inst_66222;
var state_66317__$1 = (function (){var statearr_66327 = state_66317;
(statearr_66327[(17)] = inst_66193__$1);

(statearr_66327[(19)] = inst_66192__$1);

(statearr_66327[(24)] = inst_66194__$1);

return statearr_66327;
})();
var statearr_66328_66378 = state_66317__$1;
(statearr_66328_66378[(2)] = null);

(statearr_66328_66378[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (21))){
var inst_66267 = (state_66317[(2)]);
var state_66317__$1 = state_66317;
var statearr_66329_66379 = state_66317__$1;
(statearr_66329_66379[(2)] = inst_66267);

(statearr_66329_66379[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (13))){
var inst_66210 = (state_66317[(16)]);
var inst_66215 = (state_66317[(2)]);
var state_66317__$1 = (function (){var statearr_66330 = state_66317;
(statearr_66330[(22)] = inst_66215);

return statearr_66330;
})();
if(cljs.core.truth_(inst_66210)){
var statearr_66331_66380 = state_66317__$1;
(statearr_66331_66380[(1)] = (14));

} else {
var statearr_66332_66381 = state_66317__$1;
(statearr_66332_66381[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (22))){
var inst_66252 = (state_66317[(25)]);
var inst_66245 = (state_66317[(9)]);
var inst_66262 = (state_66317[(2)]);
var inst_66263 = fluree.db.util.async.throw_err(inst_66262);
var inst_66264 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_66245,inst_66263);
var inst_66244 = inst_66252;
var inst_66245__$1 = inst_66264;
var state_66317__$1 = (function (){var statearr_66333 = state_66317;
(statearr_66333[(9)] = inst_66245__$1);

(statearr_66333[(10)] = inst_66244);

return statearr_66333;
})();
var statearr_66334_66382 = state_66317__$1;
(statearr_66334_66382[(2)] = null);

(statearr_66334_66382[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (6))){
var inst_66200 = (state_66317[(14)]);
var inst_66192 = (state_66317[(19)]);
var inst_66199 = cljs.core.seq(inst_66192);
var inst_66200__$1 = cljs.core.first(inst_66199);
var inst_66201 = cljs.core.next(inst_66199);
var inst_66202 = cljs.core.not(inst_66200__$1);
var state_66317__$1 = (function (){var statearr_66335 = state_66317;
(statearr_66335[(14)] = inst_66200__$1);

(statearr_66335[(15)] = inst_66201);

return statearr_66335;
})();
if(inst_66202){
var statearr_66336_66383 = state_66317__$1;
(statearr_66336_66383[(1)] = (8));

} else {
var statearr_66337_66384 = state_66317__$1;
(statearr_66337_66384[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (28))){
var inst_66290 = (state_66317[(26)]);
var inst_66283 = (state_66317[(27)]);
var inst_66300 = (state_66317[(2)]);
var inst_66301 = fluree.db.util.async.throw_err(inst_66300);
var inst_66302 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_66283,inst_66301);
var inst_66282 = inst_66290;
var inst_66283__$1 = inst_66302;
var state_66317__$1 = (function (){var statearr_66338 = state_66317;
(statearr_66338[(27)] = inst_66283__$1);

(statearr_66338[(28)] = inst_66282);

return statearr_66338;
})();
var statearr_66339_66385 = state_66317__$1;
(statearr_66339_66385[(2)] = null);

(statearr_66339_66385[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (25))){
var inst_66283 = (state_66317[(27)]);
var state_66317__$1 = state_66317;
var statearr_66340_66386 = state_66317__$1;
(statearr_66340_66386[(2)] = inst_66283);

(statearr_66340_66386[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (17))){
var inst_66251 = (state_66317[(12)]);
var inst_66244 = (state_66317[(10)]);
var inst_66250 = cljs.core.seq(inst_66244);
var inst_66251__$1 = cljs.core.first(inst_66250);
var inst_66252 = cljs.core.next(inst_66250);
var inst_66253 = cljs.core.not(inst_66251__$1);
var state_66317__$1 = (function (){var statearr_66341 = state_66317;
(statearr_66341[(25)] = inst_66252);

(statearr_66341[(12)] = inst_66251__$1);

return statearr_66341;
})();
if(inst_66253){
var statearr_66342_66387 = state_66317__$1;
(statearr_66342_66387[(1)] = (19));

} else {
var statearr_66343_66388 = state_66317__$1;
(statearr_66343_66388[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (3))){
var inst_66315 = (state_66317[(2)]);
var state_66317__$1 = state_66317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66317__$1,inst_66315);
} else {
if((state_val_66318 === (12))){
var inst_66200 = (state_66317[(14)]);
var inst_66213 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_66200);
var state_66317__$1 = state_66317;
var statearr_66344_66389 = state_66317__$1;
(statearr_66344_66389[(2)] = inst_66213);

(statearr_66344_66389[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (2))){
var inst_66186 = (state_66317[(21)]);
var _ = (function (){var statearr_66345 = state_66317;
(statearr_66345[(4)] = cljs.core.cons((5),(state_66317[(4)])));

return statearr_66345;
})();
var inst_66186__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_66187 = cljs.core.seq(inst_66186__$1);
var inst_66188 = cljs.core.first(inst_66187);
var inst_66189 = cljs.core.next(inst_66187);
var inst_66190 = cljs.core.PersistentHashMap.EMPTY;
var inst_66191 = cljs.core.PersistentHashMap.EMPTY;
var inst_66192 = inst_66186__$1;
var inst_66193 = inst_66190;
var inst_66194 = inst_66191;
var state_66317__$1 = (function (){var statearr_66346 = state_66317;
(statearr_66346[(17)] = inst_66193);

(statearr_66346[(18)] = inst_66189);

(statearr_66346[(19)] = inst_66192);

(statearr_66346[(21)] = inst_66186__$1);

(statearr_66346[(23)] = inst_66188);

(statearr_66346[(24)] = inst_66194);

return statearr_66346;
})();
var statearr_66347_66390 = state_66317__$1;
(statearr_66347_66390[(2)] = null);

(statearr_66347_66390[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (23))){
var inst_66289 = (state_66317[(29)]);
var inst_66282 = (state_66317[(28)]);
var inst_66288 = cljs.core.seq(inst_66282);
var inst_66289__$1 = cljs.core.first(inst_66288);
var inst_66290 = cljs.core.next(inst_66288);
var inst_66291 = cljs.core.not(inst_66289__$1);
var state_66317__$1 = (function (){var statearr_66348 = state_66317;
(statearr_66348[(26)] = inst_66290);

(statearr_66348[(29)] = inst_66289__$1);

return statearr_66348;
})();
if(inst_66291){
var statearr_66349_66391 = state_66317__$1;
(statearr_66349_66391[(1)] = (25));

} else {
var statearr_66350_66392 = state_66317__$1;
(statearr_66350_66392[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (19))){
var inst_66245 = (state_66317[(9)]);
var state_66317__$1 = state_66317;
var statearr_66351_66393 = state_66317__$1;
(statearr_66351_66393[(2)] = inst_66245);

(statearr_66351_66393[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (11))){
var inst_66200 = (state_66317[(14)]);
var state_66317__$1 = state_66317;
var statearr_66353_66394 = state_66317__$1;
(statearr_66353_66394[(2)] = inst_66200);

(statearr_66353_66394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (9))){
var inst_66200 = (state_66317[(14)]);
var inst_66210 = (state_66317[(16)]);
var inst_66208 = fluree.db.flake.s(inst_66200);
var inst_66209 = fluree.db.flake.op(inst_66200);
var inst_66210__$1 = inst_66209 === true;
var state_66317__$1 = (function (){var statearr_66355 = state_66317;
(statearr_66355[(16)] = inst_66210__$1);

(statearr_66355[(20)] = inst_66208);

return statearr_66355;
})();
if(cljs.core.truth_(inst_66210__$1)){
var statearr_66356_66395 = state_66317__$1;
(statearr_66356_66395[(1)] = (11));

} else {
var statearr_66357_66396 = state_66317__$1;
(statearr_66357_66396[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (5))){
var _ = (function (){var statearr_66358 = state_66317;
(statearr_66358[(4)] = cljs.core.rest((state_66317[(4)])));

return statearr_66358;
})();
var state_66317__$1 = state_66317;
var ex66352 = (state_66317__$1[(2)]);
var statearr_66359_66397 = state_66317__$1;
(statearr_66359_66397[(5)] = ex66352);


if((ex66352 instanceof Error)){
var statearr_66360_66398 = state_66317__$1;
(statearr_66360_66398[(1)] = (4));

(statearr_66360_66398[(5)] = null);

} else {
throw ex66352;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (14))){
var inst_66200 = (state_66317[(14)]);
var inst_66201 = (state_66317[(15)]);
var inst_66210 = (state_66317[(16)]);
var inst_66193 = (state_66317[(17)]);
var inst_66189 = (state_66317[(18)]);
var inst_66192 = (state_66317[(19)]);
var inst_66208 = (state_66317[(20)]);
var inst_66186 = (state_66317[(21)]);
var inst_66215 = (state_66317[(22)]);
var inst_66188 = (state_66317[(23)]);
var inst_66194 = (state_66317[(24)]);
var inst_66217 = (function (){var subject = inst_66208;
var flake = inst_66200;
var first__66198 = inst_66200;
var r = inst_66201;
var G__66182 = inst_66192;
var asserted_subjects = inst_66193;
var seq__66184 = inst_66189;
var flake_SINGLEQUOTE_ = inst_66215;
var retracted_subjects = inst_66194;
var seq__66197 = inst_66201;
var asserted_QMARK_ = inst_66210;
var vec__66196 = inst_66192;
var vec__66183 = inst_66186;
var first__66185 = inst_66188;
return (function (p1__66168_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__66168_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_66218 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_66193,inst_66208,inst_66217);
var tmp66354 = inst_66194;
var inst_66192__$1 = inst_66201;
var inst_66193__$1 = inst_66218;
var inst_66194__$1 = tmp66354;
var state_66317__$1 = (function (){var statearr_66361 = state_66317;
(statearr_66361[(17)] = inst_66193__$1);

(statearr_66361[(19)] = inst_66192__$1);

(statearr_66361[(24)] = inst_66194__$1);

return statearr_66361;
})();
var statearr_66362_66399 = state_66317__$1;
(statearr_66362_66399[(2)] = null);

(statearr_66362_66399[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (26))){
var inst_66289 = (state_66317[(29)]);
var inst_66294 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_66295 = cljs.core.PersistentHashMap.EMPTY;
var inst_66296 = [true,inst_66295];
var inst_66297 = cljs.core.PersistentHashMap.fromArrays(inst_66294,inst_66296);
var inst_66298 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_66297,inst_66289);
var state_66317__$1 = state_66317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66317__$1,(28),inst_66298);
} else {
if((state_val_66318 === (16))){
var inst_66225 = (state_66317[(2)]);
var state_66317__$1 = state_66317;
var statearr_66363_66400 = state_66317__$1;
(statearr_66363_66400[(2)] = inst_66225);

(statearr_66363_66400[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (10))){
var inst_66227 = (state_66317[(2)]);
var state_66317__$1 = state_66317;
var statearr_66364_66401 = state_66317__$1;
(statearr_66364_66401[(2)] = inst_66227);

(statearr_66364_66401[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (18))){
var inst_66230 = (state_66317[(7)]);
var inst_66269 = (state_66317[(2)]);
var inst_66277 = cljs.core.vals(inst_66230);
var inst_66278 = cljs.core.seq(inst_66277);
var inst_66279 = cljs.core.first(inst_66278);
var inst_66280 = cljs.core.next(inst_66278);
var inst_66281 = cljs.core.PersistentVector.EMPTY;
var inst_66282 = inst_66277;
var inst_66283 = inst_66281;
var state_66317__$1 = (function (){var statearr_66365 = state_66317;
(statearr_66365[(30)] = inst_66280);

(statearr_66365[(13)] = inst_66269);

(statearr_66365[(27)] = inst_66283);

(statearr_66365[(28)] = inst_66282);

(statearr_66365[(31)] = inst_66279);

return statearr_66365;
})();
var statearr_66366_66402 = state_66317__$1;
(statearr_66366_66402[(2)] = null);

(statearr_66366_66402[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66318 === (8))){
var inst_66193 = (state_66317[(17)]);
var inst_66194 = (state_66317[(24)]);
var inst_66204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66205 = [inst_66193,inst_66194];
var inst_66206 = (new cljs.core.PersistentVector(null,2,(5),inst_66204,inst_66205,null));
var state_66317__$1 = state_66317;
var statearr_66367_66403 = state_66317__$1;
(statearr_66367_66403[(2)] = inst_66206);

(statearr_66367_66403[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_66368 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66368[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__);

(statearr_66368[(1)] = (1));

return statearr_66368;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1 = (function (state_66317){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66317);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66369){var ex__2687__auto__ = e66369;
var statearr_66370_66404 = state_66317;
(statearr_66370_66404[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66317[(4)]))){
var statearr_66371_66405 = state_66317;
(statearr_66371_66405[(1)] = cljs.core.first((state_66317[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66406 = state_66317;
state_66317 = G__66406;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__ = function(state_66317){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1.call(this,state_66317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66372 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66372[(6)] = c__2706__auto__);

return statearr_66372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66438){
var state_val_66439 = (state_66438[(1)]);
if((state_val_66439 === (1))){
var inst_66407 = cljs.core.volatile_BANG_((0));
var inst_66408 = cljs.core.PersistentHashMap.EMPTY;
var inst_66409 = cljs.core.volatile_BANG_(inst_66408);
var inst_66410 = cljs.core.first(resp);
var inst_66411 = cljs.core.rest(resp);
var inst_66412 = cljs.core.PersistentVector.EMPTY;
var inst_66413 = inst_66407;
var inst_66414 = inst_66409;
var inst_66415 = inst_66410;
var inst_66416 = inst_66411;
var inst_66417 = inst_66412;
var state_66438__$1 = (function (){var statearr_66440 = state_66438;
(statearr_66440[(7)] = inst_66414);

(statearr_66440[(8)] = inst_66415);

(statearr_66440[(9)] = inst_66417);

(statearr_66440[(10)] = inst_66413);

(statearr_66440[(11)] = inst_66416);

return statearr_66440;
})();
var statearr_66441_66456 = state_66438__$1;
(statearr_66441_66456[(2)] = null);

(statearr_66441_66456[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66439 === (2))){
var inst_66414 = (state_66438[(7)]);
var inst_66415 = (state_66438[(8)]);
var inst_66413 = (state_66438[(10)]);
var inst_66419 = fluree.db.api.query.format_block_resp_pretty(db,inst_66415,inst_66414,inst_66413);
var state_66438__$1 = state_66438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66438__$1,(4),inst_66419);
} else {
if((state_val_66439 === (3))){
var inst_66436 = (state_66438[(2)]);
var state_66438__$1 = state_66438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66438__$1,inst_66436);
} else {
if((state_val_66439 === (4))){
var inst_66417 = (state_66438[(9)]);
var inst_66416 = (state_66438[(11)]);
var inst_66421 = (state_66438[(2)]);
var inst_66422 = fluree.db.util.async.throw_err(inst_66421);
var inst_66423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66424 = [inst_66422];
var inst_66425 = (new cljs.core.PersistentVector(null,1,(5),inst_66423,inst_66424,null));
var inst_66426 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_66417,inst_66425);
var inst_66427 = cljs.core.first(inst_66416);
var state_66438__$1 = (function (){var statearr_66444 = state_66438;
(statearr_66444[(12)] = inst_66426);

return statearr_66444;
})();
if(cljs.core.truth_(inst_66427)){
var statearr_66445_66457 = state_66438__$1;
(statearr_66445_66457[(1)] = (5));

} else {
var statearr_66446_66458 = state_66438__$1;
(statearr_66446_66458[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66439 === (5))){
var inst_66414 = (state_66438[(7)]);
var inst_66426 = (state_66438[(12)]);
var inst_66413 = (state_66438[(10)]);
var inst_66416 = (state_66438[(11)]);
var inst_66429 = cljs.core.first(inst_66416);
var inst_66430 = cljs.core.rest(inst_66416);
var tmp66442 = inst_66414;
var tmp66443 = inst_66413;
var inst_66413__$1 = tmp66443;
var inst_66414__$1 = tmp66442;
var inst_66415 = inst_66429;
var inst_66416__$1 = inst_66430;
var inst_66417 = inst_66426;
var state_66438__$1 = (function (){var statearr_66447 = state_66438;
(statearr_66447[(7)] = inst_66414__$1);

(statearr_66447[(8)] = inst_66415);

(statearr_66447[(9)] = inst_66417);

(statearr_66447[(10)] = inst_66413__$1);

(statearr_66447[(11)] = inst_66416__$1);

return statearr_66447;
})();
var statearr_66448_66459 = state_66438__$1;
(statearr_66448_66459[(2)] = null);

(statearr_66448_66459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66439 === (6))){
var inst_66426 = (state_66438[(12)]);
var state_66438__$1 = state_66438;
var statearr_66449_66460 = state_66438__$1;
(statearr_66449_66460[(2)] = inst_66426);

(statearr_66449_66460[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66439 === (7))){
var inst_66434 = (state_66438[(2)]);
var state_66438__$1 = state_66438;
var statearr_66450_66461 = state_66438__$1;
(statearr_66450_66461[(2)] = inst_66434);

(statearr_66450_66461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0 = (function (){
var statearr_66451 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66451[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__);

(statearr_66451[(1)] = (1));

return statearr_66451;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1 = (function (state_66438){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66438);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66452){var ex__2687__auto__ = e66452;
var statearr_66453_66462 = state_66438;
(statearr_66453_66462[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66438[(4)]))){
var statearr_66454_66463 = state_66438;
(statearr_66454_66463[(1)] = cljs.core.first((state_66438[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66464 = state_66438;
state_66438 = G__66464;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__ = function(state_66438){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1.call(this,state_66438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66455 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66455[(6)] = c__2706__auto__);

return statearr_66455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__66466 = arguments.length;
switch (G__66466) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__66468){
var map__66469 = p__66468;
var map__66469__$1 = cljs.core.__destructure_map(map__66469);
var query = map__66469__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66469__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66554){
var state_val_66555 = (state_66554[(1)]);
if((state_val_66555 === (7))){
var inst_66480 = (state_66554[(7)]);
var inst_66484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66485 = ["_auth/id",inst_66480];
var inst_66486 = (new cljs.core.PersistentVector(null,2,(5),inst_66484,inst_66485,null));
var state_66554__$1 = state_66554;
var statearr_66556_66600 = state_66554__$1;
(statearr_66556_66600[(2)] = inst_66486);

(statearr_66556_66600[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (20))){
var inst_66534 = (state_66554[(2)]);
var inst_66535 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_66554__$1 = (function (){var statearr_66557 = state_66554;
(statearr_66557[(8)] = inst_66534);

return statearr_66557;
})();
if(cljs.core.truth_(inst_66535)){
var statearr_66558_66601 = state_66554__$1;
(statearr_66558_66601[(1)] = (22));

} else {
var statearr_66559_66602 = state_66554__$1;
(statearr_66559_66602[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (27))){
var inst_66537 = (state_66554[(9)]);
var inst_66481 = (state_66554[(10)]);
var inst_66543 = (state_66554[(2)]);
var inst_66544 = fluree.db.util.core.response_time_formatted(inst_66481);
var inst_66545 = [(200),inst_66543,(100),inst_66544];
var inst_66546 = cljs.core.PersistentHashMap.fromArrays(inst_66537,inst_66545);
var state_66554__$1 = state_66554;
var statearr_66560_66603 = state_66554__$1;
(statearr_66560_66603[(2)] = inst_66546);

(statearr_66560_66603[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (1))){
var state_66554__$1 = state_66554;
var statearr_66561_66604 = state_66554__$1;
(statearr_66561_66604[(2)] = null);

(statearr_66561_66604[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (24))){
var inst_66549 = (state_66554[(2)]);
var _ = (function (){var statearr_66562 = state_66554;
(statearr_66562[(4)] = cljs.core.rest((state_66554[(4)])));

return statearr_66562;
})();
var state_66554__$1 = state_66554;
var statearr_66563_66605 = state_66554__$1;
(statearr_66563_66605[(2)] = inst_66549);

(statearr_66563_66605[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (4))){
var inst_66470 = (state_66554[(2)]);
var state_66554__$1 = state_66554;
var statearr_66564_66606 = state_66554__$1;
(statearr_66564_66606[(2)] = inst_66470);

(statearr_66564_66606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (15))){
var inst_66521 = (state_66554[(11)]);
var state_66554__$1 = state_66554;
var statearr_66565_66607 = state_66554__$1;
(statearr_66565_66607[(2)] = inst_66521);

(statearr_66565_66607[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (21))){
var inst_66530 = (state_66554[(2)]);
var inst_66531 = fluree.db.util.async.throw_err(inst_66530);
var state_66554__$1 = state_66554;
var statearr_66566_66608 = state_66554__$1;
(statearr_66566_66608[(2)] = inst_66531);

(statearr_66566_66608[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (13))){
var inst_66521 = (state_66554[(11)]);
var inst_66479 = (state_66554[(12)]);
var inst_66520 = (state_66554[(2)]);
var inst_66521__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_66479);
var state_66554__$1 = (function (){var statearr_66567 = state_66554;
(statearr_66567[(13)] = inst_66520);

(statearr_66567[(11)] = inst_66521__$1);

return statearr_66567;
})();
if(cljs.core.truth_(inst_66521__$1)){
var statearr_66568_66609 = state_66554__$1;
(statearr_66568_66609[(1)] = (15));

} else {
var statearr_66569_66610 = state_66554__$1;
(statearr_66569_66610[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (22))){
var inst_66534 = (state_66554[(8)]);
var inst_66537 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_66538 = cljs.core.sequential_QMARK_(inst_66534);
var state_66554__$1 = (function (){var statearr_66570 = state_66554;
(statearr_66570[(9)] = inst_66537);

return statearr_66570;
})();
if(inst_66538){
var statearr_66571_66611 = state_66554__$1;
(statearr_66571_66611[(1)] = (25));

} else {
var statearr_66572_66612 = state_66554__$1;
(statearr_66572_66612[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (6))){
var inst_66479 = (state_66554[(12)]);
var inst_66495 = (state_66554[(14)]);
var inst_66494 = (state_66554[(2)]);
var inst_66495__$1 = fluree.db.util.async.throw_err(inst_66494);
var inst_66496 = fluree.db.api.query.resolve_block_range(inst_66495__$1,inst_66479);
var state_66554__$1 = (function (){var statearr_66573 = state_66554;
(statearr_66573[(14)] = inst_66495__$1);

return statearr_66573;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66554__$1,(10),inst_66496);
} else {
if((state_val_66555 === (25))){
var inst_66534 = (state_66554[(8)]);
var inst_66540 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_66534);
var state_66554__$1 = state_66554;
var statearr_66574_66613 = state_66554__$1;
(statearr_66574_66613[(2)] = inst_66540);

(statearr_66574_66613[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (17))){
var inst_66526 = (state_66554[(2)]);
var state_66554__$1 = state_66554;
if(cljs.core.truth_(inst_66526)){
var statearr_66575_66614 = state_66554__$1;
(statearr_66575_66614[(1)] = (18));

} else {
var statearr_66576_66615 = state_66554__$1;
(statearr_66576_66615[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (3))){
var inst_66552 = (state_66554[(2)]);
var state_66554__$1 = state_66554;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66554__$1,inst_66552);
} else {
if((state_val_66555 === (12))){
var inst_66479 = (state_66554[(12)]);
var inst_66512 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66479], 0));
var inst_66513 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_66512].join('');
var inst_66514 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66515 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66516 = cljs.core.PersistentHashMap.fromArrays(inst_66514,inst_66515);
var inst_66517 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66513,inst_66516);
var inst_66518 = (function(){throw inst_66517})();
var state_66554__$1 = state_66554;
var statearr_66577_66616 = state_66554__$1;
(statearr_66577_66616[(2)] = inst_66518);

(statearr_66577_66616[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (2))){
var inst_66480 = (state_66554[(7)]);
var _ = (function (){var statearr_66578 = state_66554;
(statearr_66578[(4)] = cljs.core.cons((5),(state_66554[(4)])));

return statearr_66578;
})();
var inst_66479 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_66480__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66481 = fluree.db.util.core.current_time_millis();
var inst_66482 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_66554__$1 = (function (){var statearr_66579 = state_66554;
(statearr_66579[(15)] = inst_66482);

(statearr_66579[(12)] = inst_66479);

(statearr_66579[(10)] = inst_66481);

(statearr_66579[(7)] = inst_66480__$1);

return statearr_66579;
})();
if(cljs.core.truth_(inst_66480__$1)){
var statearr_66580_66617 = state_66554__$1;
(statearr_66580_66617[(1)] = (7));

} else {
var statearr_66581_66618 = state_66554__$1;
(statearr_66581_66618[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (23))){
var inst_66534 = (state_66554[(8)]);
var state_66554__$1 = state_66554;
var statearr_66582_66619 = state_66554__$1;
(statearr_66582_66619[(2)] = inst_66534);

(statearr_66582_66619[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (19))){
var inst_66520 = (state_66554[(13)]);
var state_66554__$1 = state_66554;
var statearr_66583_66620 = state_66554__$1;
(statearr_66583_66620[(2)] = inst_66520);

(statearr_66583_66620[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (11))){
var inst_66501 = (state_66554[(16)]);
var inst_66500 = (state_66554[(17)]);
var inst_66495 = (state_66554[(14)]);
var inst_66507 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_66495,inst_66500,inst_66501,opts);
var state_66554__$1 = state_66554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66554__$1,(14),inst_66507);
} else {
if((state_val_66555 === (9))){
var inst_66482 = (state_66554[(15)]);
var inst_66489 = (state_66554[(2)]);
var inst_66490 = [inst_66489];
var inst_66491 = cljs.core.PersistentHashMap.fromArrays(inst_66482,inst_66490);
var inst_66492 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_66491);
var state_66554__$1 = state_66554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66554__$1,(6),inst_66492);
} else {
if((state_val_66555 === (5))){
var _ = (function (){var statearr_66585 = state_66554;
(statearr_66585[(4)] = cljs.core.rest((state_66554[(4)])));

return statearr_66585;
})();
var state_66554__$1 = state_66554;
var ex66584 = (state_66554__$1[(2)]);
var statearr_66586_66621 = state_66554__$1;
(statearr_66586_66621[(5)] = ex66584);


if((ex66584 instanceof Error)){
var statearr_66587_66622 = state_66554__$1;
(statearr_66587_66622[(1)] = (4));

(statearr_66587_66622[(5)] = null);

} else {
throw ex66584;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (14))){
var inst_66509 = (state_66554[(2)]);
var inst_66510 = fluree.db.util.async.throw_err(inst_66509);
var state_66554__$1 = state_66554;
var statearr_66588_66623 = state_66554__$1;
(statearr_66588_66623[(2)] = inst_66510);

(statearr_66588_66623[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (26))){
var inst_66534 = (state_66554[(8)]);
var state_66554__$1 = state_66554;
var statearr_66589_66624 = state_66554__$1;
(statearr_66589_66624[(2)] = inst_66534);

(statearr_66589_66624[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (16))){
var inst_66479 = (state_66554[(12)]);
var inst_66524 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_66479);
var state_66554__$1 = state_66554;
var statearr_66590_66625 = state_66554__$1;
(statearr_66590_66625[(2)] = inst_66524);

(statearr_66590_66625[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (10))){
var inst_66479 = (state_66554[(12)]);
var inst_66498 = (state_66554[(2)]);
var inst_66499 = fluree.db.util.async.throw_err(inst_66498);
var inst_66500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66499,(0),null);
var inst_66501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66499,(1),null);
var inst_66502 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_66503 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_66479,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_66504 = cljs.core.keys(inst_66503);
var inst_66505 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66502,inst_66504);
var state_66554__$1 = (function (){var statearr_66591 = state_66554;
(statearr_66591[(16)] = inst_66501);

(statearr_66591[(17)] = inst_66500);

return statearr_66591;
})();
if(inst_66505){
var statearr_66592_66626 = state_66554__$1;
(statearr_66592_66626[(1)] = (11));

} else {
var statearr_66593_66627 = state_66554__$1;
(statearr_66593_66627[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66555 === (18))){
var inst_66520 = (state_66554[(13)]);
var inst_66495 = (state_66554[(14)]);
var inst_66528 = fluree.db.api.query.format_blocks_resp_pretty(inst_66495,inst_66520);
var state_66554__$1 = state_66554;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66554__$1,(21),inst_66528);
} else {
if((state_val_66555 === (8))){
var state_66554__$1 = state_66554;
var statearr_66594_66628 = state_66554__$1;
(statearr_66594_66628[(2)] = null);

(statearr_66594_66628[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_66595 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66595[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2684__auto__);

(statearr_66595[(1)] = (1));

return statearr_66595;
});
var fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1 = (function (state_66554){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66554);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66596){var ex__2687__auto__ = e66596;
var statearr_66597_66629 = state_66554;
(statearr_66597_66629[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66554[(4)]))){
var statearr_66598_66630 = state_66554;
(statearr_66598_66630[(1)] = cljs.core.first((state_66554[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66631 = state_66554;
state_66554 = G__66631;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__ = function(state_66554){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1.call(this,state_66554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66599 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66599[(6)] = c__2706__auto__);

return statearr_66599;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__66632 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66632,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66632,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66632,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66632,(3),null);
var vec__66635 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66635,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66635,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__66638 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66638,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66638,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___66642 = arguments.length;
var i__5770__auto___66643 = (0);
while(true){
if((i__5770__auto___66643 < len__5769__auto___66642)){
args__5775__auto__.push((arguments[i__5770__auto___66643]));

var G__66644 = (i__5770__auto___66643 + (1));
i__5770__auto___66643 = G__66644;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq66641){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq66641));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66840){
var state_val_66841 = (state_66840[(1)]);
if((state_val_66841 === (7))){
var inst_66767 = (state_66840[(7)]);
var inst_66760 = (state_66840[(8)]);
var inst_66766 = cljs.core.seq(inst_66760);
var inst_66767__$1 = cljs.core.first(inst_66766);
var inst_66768 = cljs.core.next(inst_66766);
var state_66840__$1 = (function (){var statearr_66842 = state_66840;
(statearr_66842[(9)] = inst_66768);

(statearr_66842[(7)] = inst_66767__$1);

return statearr_66842;
})();
if(cljs.core.truth_(inst_66767__$1)){
var statearr_66843_66943 = state_66840__$1;
(statearr_66843_66943[(1)] = (9));

} else {
var statearr_66844_66944 = state_66840__$1;
(statearr_66844_66944[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (20))){
var inst_66830 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66845_66945 = state_66840__$1;
(statearr_66845_66945[(2)] = inst_66830);

(statearr_66845_66945[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (27))){
var inst_66806 = (state_66840[(10)]);
var inst_66788 = (state_66840[(11)]);
var inst_66785 = (state_66840[(12)]);
var inst_66808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66809 = [inst_66788,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_66810 = (new cljs.core.PersistentVector(null,2,(5),inst_66808,inst_66809,null));
var inst_66811 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_66806,inst_66810,fluree.db.api.query.min_safe,inst_66785);
var state_66840__$1 = state_66840;
var statearr_66846_66946 = state_66840__$1;
(statearr_66846_66946[(2)] = inst_66811);

(statearr_66846_66946[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (1))){
var state_66840__$1 = state_66840;
var statearr_66847_66947 = state_66840__$1;
(statearr_66847_66947[(2)] = null);

(statearr_66847_66947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (24))){
var inst_66767 = (state_66840[(7)]);
var inst_66788 = (state_66840[(11)]);
var inst_66798 = (state_66840[(13)]);
var inst_66800 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66801 = [inst_66788,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_66802 = (new cljs.core.PersistentVector(null,2,(5),inst_66800,inst_66801,null));
var inst_66803 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_66798,inst_66802,cljs.core.conj,inst_66767);
var state_66840__$1 = state_66840;
var statearr_66849_66948 = state_66840__$1;
(statearr_66849_66948[(2)] = inst_66803);

(statearr_66849_66948[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (4))){
var inst_66646 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66850_66949 = state_66840__$1;
(statearr_66850_66949[(2)] = inst_66646);

(statearr_66850_66949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (15))){
var inst_66761 = (state_66840[(14)]);
var inst_66768 = (state_66840[(9)]);
var tmp66848 = inst_66761;
var inst_66760 = inst_66768;
var inst_66761__$1 = tmp66848;
var state_66840__$1 = (function (){var statearr_66851 = state_66840;
(statearr_66851[(14)] = inst_66761__$1);

(statearr_66851[(8)] = inst_66760);

return statearr_66851;
})();
var statearr_66852_66950 = state_66840__$1;
(statearr_66852_66950[(2)] = null);

(statearr_66852_66950[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (21))){
var inst_66761 = (state_66840[(14)]);
var inst_66788 = (state_66840[(11)]);
var inst_66792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66793 = [inst_66788,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66794 = (new cljs.core.PersistentVector(null,2,(5),inst_66792,inst_66793,null));
var inst_66795 = cljs.core.assoc_in(inst_66761,inst_66794,inst_66788);
var state_66840__$1 = state_66840;
var statearr_66853_66951 = state_66840__$1;
(statearr_66853_66951[(2)] = inst_66795);

(statearr_66853_66951[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (31))){
var inst_66814 = (state_66840[(15)]);
var state_66840__$1 = state_66840;
var statearr_66854_66952 = state_66840__$1;
(statearr_66854_66952[(2)] = inst_66814);

(statearr_66854_66952[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (32))){
var inst_66768 = (state_66840[(9)]);
var inst_66822 = (state_66840[(2)]);
var inst_66760 = inst_66768;
var inst_66761 = inst_66822;
var state_66840__$1 = (function (){var statearr_66855 = state_66840;
(statearr_66855[(14)] = inst_66761);

(statearr_66855[(8)] = inst_66760);

return statearr_66855;
})();
var statearr_66856_66953 = state_66840__$1;
(statearr_66856_66953[(2)] = null);

(statearr_66856_66953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (33))){
var inst_66761 = (state_66840[(14)]);
var state_66840__$1 = state_66840;
var statearr_66857_66954 = state_66840__$1;
(statearr_66857_66954[(2)] = inst_66761);

(statearr_66857_66954[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (13))){
var inst_66770 = (state_66840[(16)]);
var state_66840__$1 = state_66840;
var statearr_66858_66955 = state_66840__$1;
(statearr_66858_66955[(2)] = inst_66770);

(statearr_66858_66955[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (22))){
var inst_66761 = (state_66840[(14)]);
var state_66840__$1 = state_66840;
var statearr_66859_66956 = state_66840__$1;
(statearr_66859_66956[(2)] = inst_66761);

(statearr_66859_66956[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (29))){
var inst_66814 = (state_66840[(2)]);
var state_66840__$1 = (function (){var statearr_66860 = state_66840;
(statearr_66860[(15)] = inst_66814);

return statearr_66860;
})();
if(cljs.core.truth_(show_auth)){
var statearr_66861_66957 = state_66840__$1;
(statearr_66861_66957[(1)] = (30));

} else {
var statearr_66862_66958 = state_66840__$1;
(statearr_66862_66958[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (6))){
var inst_66746 = (state_66840[(2)]);
var inst_66747 = fluree.db.util.async.throw_err(inst_66746);
var inst_66755 = resp;
var inst_66756 = cljs.core.seq(inst_66755);
var inst_66757 = cljs.core.first(inst_66756);
var inst_66758 = cljs.core.next(inst_66756);
var inst_66759 = cljs.core.PersistentHashMap.EMPTY;
var inst_66760 = inst_66755;
var inst_66761 = inst_66759;
var state_66840__$1 = (function (){var statearr_66863 = state_66840;
(statearr_66863[(17)] = inst_66747);

(statearr_66863[(14)] = inst_66761);

(statearr_66863[(18)] = inst_66757);

(statearr_66863[(19)] = inst_66758);

(statearr_66863[(8)] = inst_66760);

return statearr_66863;
})();
var statearr_66864_66959 = state_66840__$1;
(statearr_66864_66959[(2)] = null);

(statearr_66864_66959[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (28))){
var inst_66806 = (state_66840[(10)]);
var state_66840__$1 = state_66840;
var statearr_66865_66960 = state_66840__$1;
(statearr_66865_66960[(2)] = inst_66806);

(statearr_66865_66960[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (25))){
var inst_66798 = (state_66840[(13)]);
var state_66840__$1 = state_66840;
var statearr_66866_66961 = state_66840__$1;
(statearr_66866_66961[(2)] = inst_66798);

(statearr_66866_66961[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (34))){
var state_66840__$1 = state_66840;
var statearr_66867_66962 = state_66840__$1;
(statearr_66867_66962[(2)] = null);

(statearr_66867_66962[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (17))){
var inst_66832 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66868_66963 = state_66840__$1;
(statearr_66868_66963[(2)] = inst_66832);

(statearr_66868_66963[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (3))){
var inst_66838 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66840__$1,inst_66838);
} else {
if((state_val_66841 === (12))){
var inst_66747 = (state_66840[(17)]);
var inst_66767 = (state_66840[(7)]);
var inst_66772 = fluree.db.api.query.auth_match(auth,inst_66747,inst_66767);
var inst_66773 = cljs.core.not(inst_66772);
var state_66840__$1 = state_66840;
var statearr_66869_66964 = state_66840__$1;
(statearr_66869_66964[(2)] = inst_66773);

(statearr_66869_66964[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (2))){
var _ = (function (){var statearr_66870 = state_66840;
(statearr_66870[(4)] = cljs.core.cons((5),(state_66840[(4)])));

return statearr_66870;
})();
var inst_66652 = (function (){return (function (p1__66645_SHARP_){
return fluree.db.flake.t(p1__66645_SHARP_);
});
})();
var inst_66653 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_66652,resp);
var inst_66654 = cljs.core.set(inst_66653);
var inst_66742 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_66743 = (function (){var ts = inst_66654;
var c__2706__auto____$1 = inst_66742;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66740){
var state_val_66741 = (state_66740[(1)]);
if((state_val_66741 === (7))){
var inst_66686 = (state_66740[(7)]);
var inst_66668 = (state_66740[(8)]);
var inst_66674 = (state_66740[(9)]);
var inst_66680 = (state_66740[(10)]);
var inst_66679 = (state_66740[(2)]);
var inst_66680__$1 = fluree.db.util.async.throw_err(inst_66679);
var inst_66682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66683 = [inst_66674,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66684 = (new cljs.core.PersistentVector(null,2,(5),inst_66682,inst_66683,null));
var inst_66685 = cljs.core.assoc_in(inst_66668,inst_66684,inst_66680__$1);
var inst_66686__$1 = auth;
var state_66740__$1 = (function (){var statearr_66871 = state_66740;
(statearr_66871[(11)] = inst_66685);

(statearr_66871[(7)] = inst_66686__$1);

(statearr_66871[(10)] = inst_66680__$1);

return statearr_66871;
})();
if(cljs.core.truth_(inst_66686__$1)){
var statearr_66872_66965 = state_66740__$1;
(statearr_66872_66965[(1)] = (8));

} else {
var statearr_66873_66966 = state_66740__$1;
(statearr_66873_66966[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (1))){
var inst_66662 = (state_66740[(12)]);
var inst_66662__$1 = ts;
var inst_66663 = cljs.core.seq(inst_66662__$1);
var inst_66664 = cljs.core.first(inst_66663);
var inst_66665 = cljs.core.next(inst_66663);
var inst_66666 = cljs.core.PersistentHashMap.EMPTY;
var inst_66667 = inst_66662__$1;
var inst_66668 = inst_66666;
var state_66740__$1 = (function (){var statearr_66874 = state_66740;
(statearr_66874[(13)] = inst_66664);

(statearr_66874[(12)] = inst_66662__$1);

(statearr_66874[(14)] = inst_66665);

(statearr_66874[(8)] = inst_66668);

(statearr_66874[(15)] = inst_66667);

return statearr_66874;
})();
var statearr_66875_66967 = state_66740__$1;
(statearr_66875_66967[(2)] = null);

(statearr_66875_66967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (4))){
var inst_66674 = (state_66740[(9)]);
var inst_66677 = fluree.db.time_travel.non_border_t_to_block(db,inst_66674);
var state_66740__$1 = state_66740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66740__$1,(7),inst_66677);
} else {
if((state_val_66741 === (13))){
var inst_66675 = (state_66740[(16)]);
var inst_66732 = (state_66740[(2)]);
var inst_66667 = inst_66675;
var inst_66668 = inst_66732;
var state_66740__$1 = (function (){var statearr_66876 = state_66740;
(statearr_66876[(8)] = inst_66668);

(statearr_66876[(15)] = inst_66667);

return statearr_66876;
})();
var statearr_66877_66968 = state_66740__$1;
(statearr_66877_66968[(2)] = null);

(statearr_66877_66968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (6))){
var inst_66736 = (state_66740[(2)]);
var state_66740__$1 = state_66740;
var statearr_66878_66969 = state_66740__$1;
(statearr_66878_66969[(2)] = inst_66736);

(statearr_66878_66969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (3))){
var inst_66738 = (state_66740[(2)]);
var state_66740__$1 = state_66740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66740__$1,inst_66738);
} else {
if((state_val_66741 === (12))){
var inst_66685 = (state_66740[(11)]);
var state_66740__$1 = state_66740;
var statearr_66879_66970 = state_66740__$1;
(statearr_66879_66970[(2)] = inst_66685);

(statearr_66879_66970[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (2))){
var inst_66667 = (state_66740[(15)]);
var inst_66674 = (state_66740[(9)]);
var inst_66673 = cljs.core.seq(inst_66667);
var inst_66674__$1 = cljs.core.first(inst_66673);
var inst_66675 = cljs.core.next(inst_66673);
var state_66740__$1 = (function (){var statearr_66880 = state_66740;
(statearr_66880[(9)] = inst_66674__$1);

(statearr_66880[(16)] = inst_66675);

return statearr_66880;
})();
if(cljs.core.truth_(inst_66674__$1)){
var statearr_66881_66971 = state_66740__$1;
(statearr_66881_66971[(1)] = (4));

} else {
var statearr_66882_66972 = state_66740__$1;
(statearr_66882_66972[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (11))){
var inst_66664 = (state_66740[(13)]);
var inst_66685 = (state_66740[(11)]);
var inst_66662 = (state_66740[(12)]);
var inst_66665 = (state_66740[(14)]);
var inst_66668 = (state_66740[(8)]);
var inst_66667 = (state_66740[(15)]);
var inst_66674 = (state_66740[(9)]);
var inst_66680 = (state_66740[(10)]);
var inst_66675 = (state_66740[(16)]);
var inst_66692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66693 = [inst_66674,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66694 = (new cljs.core.PersistentVector(null,2,(5),inst_66692,inst_66693,null));
var inst_66707 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_66708 = (function (){var t = inst_66674;
var first__66661 = inst_66664;
var block = inst_66680;
var r = inst_66675;
var first__66672 = inst_66674;
var acc = inst_66668;
var seq__66671 = inst_66675;
var G__66658 = inst_66667;
var c__2706__auto____$2 = inst_66707;
var vec__66659 = inst_66662;
var vec__66670 = inst_66667;
var seq__66660 = inst_66665;
var G__66681 = inst_66685;
return (function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_66705){
var state_val_66706 = (state_66705[(1)]);
if((state_val_66706 === (1))){
var state_66705__$1 = state_66705;
var statearr_66883_66973 = state_66705__$1;
(statearr_66883_66973[(2)] = null);

(statearr_66883_66973[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66706 === (2))){
var ___$1 = (function (){var statearr_66884 = state_66705;
(statearr_66884[(4)] = cljs.core.cons((5),(state_66705[(4)])));

return statearr_66884;
})();
var ___$2 = (function (){var statearr_66885 = state_66705;
(statearr_66885[(4)] = cljs.core.rest((state_66705[(4)])));

return statearr_66885;
})();
var state_66705__$1 = state_66705;
var statearr_66886_66974 = state_66705__$1;
(statearr_66886_66974[(2)] = db);

(statearr_66886_66974[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66706 === (3))){
var inst_66703 = (state_66705[(2)]);
var state_66705__$1 = state_66705;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66705__$1,inst_66703);
} else {
if((state_val_66706 === (4))){
var inst_66695 = (state_66705[(2)]);
var state_66705__$1 = state_66705;
var statearr_66888_66975 = state_66705__$1;
(statearr_66888_66975[(2)] = inst_66695);

(statearr_66888_66975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66706 === (5))){
var ___$1 = (function (){var statearr_66889 = state_66705;
(statearr_66889[(4)] = cljs.core.rest((state_66705[(4)])));

return statearr_66889;
})();
var state_66705__$1 = state_66705;
var ex66887 = (state_66705__$1[(2)]);
var statearr_66890_66976 = state_66705__$1;
(statearr_66890_66976[(5)] = ex66887);


if((ex66887 instanceof Error)){
var statearr_66891_66977 = state_66705__$1;
(statearr_66891_66977[(1)] = (4));

(statearr_66891_66977[(5)] = null);

} else {
throw ex66887;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_66892 = [null,null,null,null,null,null,null];
(statearr_66892[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_66892[(1)] = (1));

return statearr_66892;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_66705){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66705);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66893){var ex__2687__auto__ = e66893;
var statearr_66894_66978 = state_66705;
(statearr_66894_66978[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66705[(4)]))){
var statearr_66895_66979 = state_66705;
(statearr_66895_66979[(1)] = cljs.core.first((state_66705[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66980 = state_66705;
state_66705 = G__66980;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_66705){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_66705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66896 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66896[(6)] = c__2706__auto____$2);

return statearr_66896;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_66709 = cljs.core.async.impl.dispatch.run(inst_66708);
var inst_66710 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_66711 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66712 = ["?auth","?id"];
var inst_66713 = (new cljs.core.PersistentVector(null,2,(5),inst_66711,inst_66712,null));
var inst_66714 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66716 = [inst_66674,"_tx/auth","?auth"];
var inst_66717 = (new cljs.core.PersistentVector(null,3,(5),inst_66715,inst_66716,null));
var inst_66718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66719 = ["?auth","_auth/id","?id"];
var inst_66720 = (new cljs.core.PersistentVector(null,3,(5),inst_66718,inst_66719,null));
var inst_66721 = [inst_66717,inst_66720];
var inst_66722 = (new cljs.core.PersistentVector(null,2,(5),inst_66714,inst_66721,null));
var inst_66723 = [inst_66713,inst_66722];
var inst_66724 = cljs.core.PersistentHashMap.fromArrays(inst_66710,inst_66723);
var inst_66725 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_66707,inst_66724) : fluree.db.api.query.query_async.call(null,inst_66707,inst_66724));
var state_66740__$1 = (function (){var statearr_66897 = state_66740;
(statearr_66897[(17)] = inst_66694);

(statearr_66897[(18)] = inst_66709);

return statearr_66897;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66740__$1,(14),inst_66725);
} else {
if((state_val_66741 === (9))){
var state_66740__$1 = state_66740;
var statearr_66898_66981 = state_66740__$1;
(statearr_66898_66981[(2)] = show_auth);

(statearr_66898_66981[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (5))){
var inst_66668 = (state_66740[(8)]);
var state_66740__$1 = state_66740;
var statearr_66899_66982 = state_66740__$1;
(statearr_66899_66982[(2)] = inst_66668);

(statearr_66899_66982[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (14))){
var inst_66685 = (state_66740[(11)]);
var inst_66694 = (state_66740[(17)]);
var inst_66727 = (state_66740[(2)]);
var inst_66728 = fluree.db.util.async.throw_err(inst_66727);
var inst_66729 = cljs.core.assoc_in(inst_66685,inst_66694,inst_66728);
var state_66740__$1 = state_66740;
var statearr_66900_66983 = state_66740__$1;
(statearr_66900_66983[(2)] = inst_66729);

(statearr_66900_66983[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (10))){
var inst_66690 = (state_66740[(2)]);
var state_66740__$1 = state_66740;
if(cljs.core.truth_(inst_66690)){
var statearr_66901_66984 = state_66740__$1;
(statearr_66901_66984[(1)] = (11));

} else {
var statearr_66902_66985 = state_66740__$1;
(statearr_66902_66985[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66741 === (8))){
var inst_66686 = (state_66740[(7)]);
var state_66740__$1 = state_66740;
var statearr_66903_66986 = state_66740__$1;
(statearr_66903_66986[(2)] = inst_66686);

(statearr_66903_66986[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_66904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66904[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_66904[(1)] = (1));

return statearr_66904;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_66740){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66740);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66905){var ex__2687__auto__ = e66905;
var statearr_66906_66987 = state_66740;
(statearr_66906_66987[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66740[(4)]))){
var statearr_66907_66988 = state_66740;
(statearr_66907_66988[(1)] = cljs.core.first((state_66740[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66989 = state_66740;
state_66740 = G__66989;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_66740){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_66740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66908 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66908[(6)] = c__2706__auto____$1);

return statearr_66908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
});
})();
var inst_66744 = cljs.core.async.impl.dispatch.run(inst_66743);
var state_66840__$1 = (function (){var statearr_66909 = state_66840;
(statearr_66909[(20)] = inst_66744);

return statearr_66909;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66840__$1,(6),inst_66742);
} else {
if((state_val_66841 === (23))){
var inst_66798 = (state_66840[(2)]);
var state_66840__$1 = (function (){var statearr_66910 = state_66840;
(statearr_66910[(13)] = inst_66798);

return statearr_66910;
})();
var statearr_66911_66990 = state_66840__$1;
(statearr_66911_66990[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (35))){
var inst_66828 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66913_66991 = state_66840__$1;
(statearr_66913_66991[(2)] = inst_66828);

(statearr_66913_66991[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (19))){
var state_66840__$1 = state_66840;
var statearr_66914_66992 = state_66840__$1;
(statearr_66914_66992[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (11))){
var inst_66779 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
if(cljs.core.truth_(inst_66779)){
var statearr_66917_66993 = state_66840__$1;
(statearr_66917_66993[(1)] = (15));

} else {
var statearr_66918_66994 = state_66840__$1;
(statearr_66918_66994[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (9))){
var inst_66770 = (state_66840[(16)]);
var inst_66770__$1 = auth;
var state_66840__$1 = (function (){var statearr_66919 = state_66840;
(statearr_66919[(16)] = inst_66770__$1);

return statearr_66919;
})();
if(cljs.core.truth_(inst_66770__$1)){
var statearr_66920_66995 = state_66840__$1;
(statearr_66920_66995[(1)] = (12));

} else {
var statearr_66921_66996 = state_66840__$1;
(statearr_66921_66996[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (5))){
var _ = (function (){var statearr_66922 = state_66840;
(statearr_66922[(4)] = cljs.core.rest((state_66840[(4)])));

return statearr_66922;
})();
var state_66840__$1 = state_66840;
var ex66916 = (state_66840__$1[(2)]);
var statearr_66923_66997 = state_66840__$1;
(statearr_66923_66997[(5)] = ex66916);


if((ex66916 instanceof Error)){
var statearr_66924_66998 = state_66840__$1;
(statearr_66924_66998[(1)] = (4));

(statearr_66924_66998[(5)] = null);

} else {
throw ex66916;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (14))){
var inst_66776 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66925_66999 = state_66840__$1;
(statearr_66925_66999[(2)] = inst_66776);

(statearr_66925_66999[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (26))){
var inst_66806 = (state_66840[(2)]);
var state_66840__$1 = (function (){var statearr_66926 = state_66840;
(statearr_66926[(10)] = inst_66806);

return statearr_66926;
})();
var statearr_66927_67000 = state_66840__$1;
(statearr_66927_67000[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (16))){
var inst_66767 = (state_66840[(7)]);
var state_66840__$1 = state_66840;
if(cljs.core.truth_(inst_66767)){
var statearr_66929_67001 = state_66840__$1;
(statearr_66929_67001[(1)] = (18));

} else {
var statearr_66930_67002 = state_66840__$1;
(statearr_66930_67002[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (30))){
var inst_66814 = (state_66840[(15)]);
var inst_66788 = (state_66840[(11)]);
var inst_66789 = (state_66840[(21)]);
var inst_66816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66817 = [inst_66788,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66818 = (new cljs.core.PersistentVector(null,2,(5),inst_66816,inst_66817,null));
var inst_66819 = cljs.core.assoc_in(inst_66814,inst_66818,inst_66789);
var state_66840__$1 = state_66840;
var statearr_66931_67003 = state_66840__$1;
(statearr_66931_67003[(2)] = inst_66819);

(statearr_66931_67003[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (10))){
var inst_66767 = (state_66840[(7)]);
var state_66840__$1 = state_66840;
var statearr_66932_67004 = state_66840__$1;
(statearr_66932_67004[(2)] = inst_66767);

(statearr_66932_67004[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (18))){
var inst_66747 = (state_66840[(17)]);
var inst_66767 = (state_66840[(7)]);
var inst_66785 = (state_66840[(12)]);
var inst_66785__$1 = fluree.db.flake.t(inst_66767);
var inst_66786 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66747,inst_66785__$1);
var inst_66787 = cljs.core.__destructure_map(inst_66786);
var inst_66788 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66787,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66789 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66787,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_66840__$1 = (function (){var statearr_66933 = state_66840;
(statearr_66933[(11)] = inst_66788);

(statearr_66933[(21)] = inst_66789);

(statearr_66933[(12)] = inst_66785__$1);

return statearr_66933;
})();
var statearr_66934_67005 = state_66840__$1;
(statearr_66934_67005[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (8))){
var inst_66834 = (state_66840[(2)]);
var inst_66835 = cljs.core.vals(inst_66834);
var _ = (function (){var statearr_66936 = state_66840;
(statearr_66936[(4)] = cljs.core.rest((state_66840[(4)])));

return statearr_66936;
})();
var state_66840__$1 = state_66840;
var statearr_66937_67006 = state_66840__$1;
(statearr_66937_67006[(2)] = inst_66835);

(statearr_66937_67006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0 = (function (){
var statearr_66938 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66938[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__);

(statearr_66938[(1)] = (1));

return statearr_66938;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1 = (function (state_66840){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_66840);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e66939){var ex__2687__auto__ = e66939;
var statearr_66940_67007 = state_66840;
(statearr_66940_67007[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_66840[(4)]))){
var statearr_66941_67008 = state_66840;
(statearr_66941_67008[(1)] = cljs.core.first((state_66840[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67009 = state_66840;
state_66840 = G__67009;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__ = function(state_66840){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1.call(this,state_66840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2684__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_66942 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_66942[(6)] = c__2706__auto__);

return statearr_66942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67133){
var state_val_67134 = (state_67133[(1)]);
if((state_val_67134 === (7))){
var inst_67032 = (state_67133[(7)]);
var inst_67034 = fluree.db.api.query.resolve_block_range(inst_67032,query_map);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(10),inst_67034);
} else {
if((state_val_67134 === (20))){
var inst_67058 = (state_67133[(2)]);
var inst_67059 = fluree.db.util.async.throw_err(inst_67058);
var inst_67060 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_67059);
var inst_67061 = (inst_67060 - (1));
var state_67133__$1 = state_67133;
var statearr_67135_67198 = state_67133__$1;
(statearr_67135_67198[(2)] = inst_67061);

(statearr_67135_67198[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (27))){
var state_67133__$1 = state_67133;
var statearr_67136_67199 = state_67133__$1;
(statearr_67136_67199[(2)] = null);

(statearr_67136_67199[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (1))){
var state_67133__$1 = state_67133;
var statearr_67137_67200 = state_67133__$1;
(statearr_67137_67200[(2)] = null);

(statearr_67137_67200[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (24))){
var inst_67068 = (state_67133[(2)]);
var inst_67069 = fluree.db.util.async.throw_err(inst_67068);
var inst_67070 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_67069);
var state_67133__$1 = state_67133;
var statearr_67138_67201 = state_67133__$1;
(statearr_67138_67201[(2)] = inst_67070);

(statearr_67138_67201[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (39))){
var inst_67105 = (state_67133[(2)]);
var inst_67106 = fluree.db.util.async.throw_err(inst_67105);
var state_67133__$1 = state_67133;
var statearr_67139_67202 = state_67133__$1;
(statearr_67139_67202[(2)] = inst_67106);

(statearr_67139_67202[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (4))){
var inst_67010 = (state_67133[(2)]);
var state_67133__$1 = state_67133;
var statearr_67140_67203 = state_67133__$1;
(statearr_67140_67203[(2)] = inst_67010);

(statearr_67140_67203[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (15))){
var inst_67041 = (state_67133[(8)]);
var state_67133__$1 = state_67133;
var statearr_67141_67204 = state_67133__$1;
(statearr_67141_67204[(2)] = inst_67041);

(statearr_67141_67204[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (21))){
var inst_67032 = (state_67133[(7)]);
var inst_67042 = (state_67133[(9)]);
var inst_67066 = fluree.db.time_travel.as_of_block(inst_67032,inst_67042);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(24),inst_67066);
} else {
if((state_val_67134 === (31))){
var inst_67026 = (state_67133[(10)]);
var state_67133__$1 = state_67133;
var statearr_67142_67205 = state_67133__$1;
(statearr_67142_67205[(2)] = inst_67026);

(statearr_67142_67205[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (32))){
var inst_67084 = (state_67133[(11)]);
var inst_67032 = (state_67133[(7)]);
var inst_67089 = (state_67133[(12)]);
var inst_67093 = (state_67133[(2)]);
var inst_67094 = fluree.db.api.query.format_history_resp(inst_67032,inst_67084,inst_67089,inst_67093);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(29),inst_67094);
} else {
if((state_val_67134 === (40))){
var inst_67110 = (state_67133[(13)]);
var inst_67084 = (state_67133[(11)]);
var inst_67112 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_67113 = cljs.core.count(inst_67084);
var inst_67114 = [inst_67110,inst_67113,(200)];
var inst_67115 = cljs.core.PersistentHashMap.fromArrays(inst_67112,inst_67114);
var state_67133__$1 = state_67133;
var statearr_67143_67206 = state_67133__$1;
(statearr_67143_67206[(2)] = inst_67115);

(statearr_67143_67206[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (33))){
var inst_67025 = (state_67133[(14)]);
var state_67133__$1 = state_67133;
var statearr_67144_67207 = state_67133__$1;
(statearr_67144_67207[(2)] = inst_67025);

(statearr_67144_67207[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (13))){
var inst_67128 = (state_67133[(2)]);
var _ = (function (){var statearr_67145 = state_67133;
(statearr_67145[(4)] = cljs.core.rest((state_67133[(4)])));

return statearr_67145;
})();
var state_67133__$1 = state_67133;
var statearr_67146_67208 = state_67133__$1;
(statearr_67146_67208[(2)] = inst_67128);

(statearr_67146_67208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (22))){
var inst_67032 = (state_67133[(7)]);
var inst_67072 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_67032);
var state_67133__$1 = state_67133;
var statearr_67147_67209 = state_67133__$1;
(statearr_67147_67209[(2)] = inst_67072);

(statearr_67147_67209[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (36))){
var inst_67097 = (state_67133[(15)]);
var inst_67032 = (state_67133[(7)]);
var inst_67103 = fluree.db.api.query.format_blocks_resp_pretty(inst_67032,inst_67097);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(39),inst_67103);
} else {
if((state_val_67134 === (41))){
var inst_67110 = (state_67133[(13)]);
var state_67133__$1 = state_67133;
var statearr_67148_67210 = state_67133__$1;
(statearr_67148_67210[(2)] = inst_67110);

(statearr_67148_67210[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (29))){
var inst_67025 = (state_67133[(14)]);
var inst_67096 = (state_67133[(2)]);
var inst_67097 = fluree.db.util.async.throw_err(inst_67096);
var state_67133__$1 = (function (){var statearr_67149 = state_67133;
(statearr_67149[(15)] = inst_67097);

return statearr_67149;
})();
if(cljs.core.truth_(inst_67025)){
var statearr_67150_67211 = state_67133__$1;
(statearr_67150_67211[(1)] = (33));

} else {
var statearr_67151_67212 = state_67133__$1;
(statearr_67151_67212[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (6))){
var inst_67022 = (state_67133[(16)]);
var inst_67031 = (state_67133[(2)]);
var inst_67032 = fluree.db.util.async.throw_err(inst_67031);
var state_67133__$1 = (function (){var statearr_67152 = state_67133;
(statearr_67152[(7)] = inst_67032);

return statearr_67152;
})();
if(cljs.core.truth_(inst_67022)){
var statearr_67153_67213 = state_67133__$1;
(statearr_67153_67213[(1)] = (7));

} else {
var statearr_67154_67214 = state_67133__$1;
(statearr_67154_67214[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (28))){
var inst_67027 = (state_67133[(17)]);
var inst_67089 = (state_67133[(2)]);
var state_67133__$1 = (function (){var statearr_67155 = state_67133;
(statearr_67155[(12)] = inst_67089);

return statearr_67155;
})();
if(cljs.core.truth_(inst_67027)){
var statearr_67156_67215 = state_67133__$1;
(statearr_67156_67215[(1)] = (30));

} else {
var statearr_67157_67216 = state_67133__$1;
(statearr_67157_67216[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (25))){
var inst_67028 = (state_67133[(18)]);
var inst_67083 = (state_67133[(2)]);
var inst_67084 = fluree.db.util.async.throw_err(inst_67083);
var state_67133__$1 = (function (){var statearr_67158 = state_67133;
(statearr_67158[(11)] = inst_67084);

return statearr_67158;
})();
if(cljs.core.truth_(inst_67028)){
var statearr_67159_67217 = state_67133__$1;
(statearr_67159_67217[(1)] = (26));

} else {
var statearr_67160_67218 = state_67133__$1;
(statearr_67160_67218[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (34))){
var inst_67024 = (state_67133[(19)]);
var state_67133__$1 = state_67133;
var statearr_67161_67219 = state_67133__$1;
(statearr_67161_67219[(2)] = inst_67024);

(statearr_67161_67219[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (17))){
var inst_67041 = (state_67133[(8)]);
var inst_67032 = (state_67133[(7)]);
var inst_67055 = (inst_67041 - (1));
var inst_67056 = fluree.db.time_travel.as_of_block(inst_67032,inst_67055);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(20),inst_67056);
} else {
if((state_val_67134 === (3))){
var inst_67131 = (state_67133[(2)]);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67133__$1,inst_67131);
} else {
if((state_val_67134 === (12))){
var inst_67120 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_67121 = ["History query not properly formatted. Provided ",inst_67120].join('');
var inst_67122 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67123 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67124 = cljs.core.PersistentHashMap.fromArrays(inst_67122,inst_67123);
var inst_67125 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67121,inst_67124);
var inst_67126 = (function(){throw inst_67125})();
var state_67133__$1 = state_67133;
var statearr_67162_67220 = state_67133__$1;
(statearr_67162_67220[(2)] = inst_67126);

(statearr_67162_67220[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (2))){
var _ = (function (){var statearr_67163 = state_67133;
(statearr_67163[(4)] = cljs.core.cons((5),(state_67133[(4)])));

return statearr_67163;
})();
var inst_67020 = query_map;
var inst_67021 = cljs.core.__destructure_map(inst_67020);
var inst_67022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_67024 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_67025 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_67026 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_67027 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_67028 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_67029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67021,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_67133__$1 = (function (){var statearr_67164 = state_67133;
(statearr_67164[(20)] = inst_67029);

(statearr_67164[(17)] = inst_67027);

(statearr_67164[(18)] = inst_67028);

(statearr_67164[(21)] = inst_67023);

(statearr_67164[(10)] = inst_67026);

(statearr_67164[(19)] = inst_67024);

(statearr_67164[(14)] = inst_67025);

(statearr_67164[(16)] = inst_67022);

return statearr_67164;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(6),sources);
} else {
if((state_val_67134 === (23))){
var inst_67023 = (state_67133[(21)]);
var inst_67064 = (state_67133[(22)]);
var inst_67032 = (state_67133[(7)]);
var inst_67074 = (state_67133[(2)]);
var inst_67075 = fluree.db.api.query.get_history_pattern(inst_67023);
var inst_67076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67075,(0),null);
var inst_67077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67075,(1),null);
var inst_67078 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_67079 = [inst_67064,inst_67074];
var inst_67080 = cljs.core.PersistentHashMap.fromArrays(inst_67078,inst_67079);
var inst_67081 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_67032,inst_67077,cljs.core._EQ_,inst_67076,inst_67080);
var state_67133__$1 = state_67133;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67133__$1,(25),inst_67081);
} else {
if((state_val_67134 === (35))){
var inst_67101 = (state_67133[(2)]);
var state_67133__$1 = state_67133;
if(cljs.core.truth_(inst_67101)){
var statearr_67165_67221 = state_67133__$1;
(statearr_67165_67221[(1)] = (36));

} else {
var statearr_67166_67222 = state_67133__$1;
(statearr_67166_67222[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (19))){
var inst_67042 = (state_67133[(9)]);
var inst_67064 = (state_67133[(2)]);
var state_67133__$1 = (function (){var statearr_67167 = state_67133;
(statearr_67167[(22)] = inst_67064);

return statearr_67167;
})();
if(cljs.core.truth_(inst_67042)){
var statearr_67168_67223 = state_67133__$1;
(statearr_67168_67223[(1)] = (21));

} else {
var statearr_67169_67224 = state_67133__$1;
(statearr_67169_67224[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (11))){
var inst_67041 = (state_67133[(8)]);
var inst_67029 = (state_67133[(20)]);
var inst_67048 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_67029);
var state_67133__$1 = (function (){var statearr_67171 = state_67133;
(statearr_67171[(23)] = inst_67048);

return statearr_67171;
})();
if(cljs.core.truth_(inst_67041)){
var statearr_67172_67225 = state_67133__$1;
(statearr_67172_67225[(1)] = (14));

} else {
var statearr_67173_67226 = state_67133__$1;
(statearr_67173_67226[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (9))){
var inst_67040 = (state_67133[(2)]);
var inst_67041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67040,(0),null);
var inst_67042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67040,(1),null);
var inst_67043 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_67133__$1 = (function (){var statearr_67174 = state_67133;
(statearr_67174[(8)] = inst_67041);

(statearr_67174[(9)] = inst_67042);

return statearr_67174;
})();
if(inst_67043){
var statearr_67175_67227 = state_67133__$1;
(statearr_67175_67227[(1)] = (11));

} else {
var statearr_67176_67228 = state_67133__$1;
(statearr_67176_67228[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (5))){
var _ = (function (){var statearr_67177 = state_67133;
(statearr_67177[(4)] = cljs.core.rest((state_67133[(4)])));

return statearr_67177;
})();
var state_67133__$1 = state_67133;
var ex67170 = (state_67133__$1[(2)]);
var statearr_67178_67229 = state_67133__$1;
(statearr_67178_67229[(5)] = ex67170);


if((ex67170 instanceof Error)){
var statearr_67179_67230 = state_67133__$1;
(statearr_67179_67230[(1)] = (4));

(statearr_67179_67230[(5)] = null);

} else {
throw ex67170;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (14))){
var inst_67041 = (state_67133[(8)]);
var inst_67050 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_67041);
var state_67133__$1 = state_67133;
var statearr_67180_67231 = state_67133__$1;
(statearr_67180_67231[(2)] = inst_67050);

(statearr_67180_67231[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (26))){
var inst_67028 = (state_67133[(18)]);
var inst_67086 = cljs.core.set(inst_67028);
var state_67133__$1 = state_67133;
var statearr_67181_67232 = state_67133__$1;
(statearr_67181_67232[(2)] = inst_67086);

(statearr_67181_67232[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (16))){
var inst_67053 = (state_67133[(2)]);
var state_67133__$1 = state_67133;
if(cljs.core.truth_(inst_67053)){
var statearr_67182_67233 = state_67133__$1;
(statearr_67182_67233[(1)] = (17));

} else {
var statearr_67183_67234 = state_67133__$1;
(statearr_67183_67234[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (38))){
var inst_67048 = (state_67133[(23)]);
var inst_67110 = (state_67133[(2)]);
var state_67133__$1 = (function (){var statearr_67184 = state_67133;
(statearr_67184[(13)] = inst_67110);

return statearr_67184;
})();
if(cljs.core.truth_(inst_67048)){
var statearr_67185_67235 = state_67133__$1;
(statearr_67185_67235[(1)] = (40));

} else {
var statearr_67186_67236 = state_67133__$1;
(statearr_67186_67236[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (30))){
var inst_67027 = (state_67133[(17)]);
var state_67133__$1 = state_67133;
var statearr_67187_67237 = state_67133__$1;
(statearr_67187_67237[(2)] = inst_67027);

(statearr_67187_67237[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (10))){
var inst_67036 = (state_67133[(2)]);
var inst_67037 = fluree.db.util.async.throw_err(inst_67036);
var state_67133__$1 = state_67133;
var statearr_67188_67238 = state_67133__$1;
(statearr_67188_67238[(2)] = inst_67037);

(statearr_67188_67238[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (18))){
var state_67133__$1 = state_67133;
var statearr_67189_67239 = state_67133__$1;
(statearr_67189_67239[(2)] = (-1));

(statearr_67189_67239[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (42))){
var inst_67118 = (state_67133[(2)]);
var state_67133__$1 = state_67133;
var statearr_67190_67240 = state_67133__$1;
(statearr_67190_67240[(2)] = inst_67118);

(statearr_67190_67240[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (37))){
var inst_67097 = (state_67133[(15)]);
var inst_67108 = fluree.db.api.query.block_Flakes__GT_vector(inst_67097);
var state_67133__$1 = state_67133;
var statearr_67191_67241 = state_67133__$1;
(statearr_67191_67241[(2)] = inst_67108);

(statearr_67191_67241[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67134 === (8))){
var state_67133__$1 = state_67133;
var statearr_67192_67242 = state_67133__$1;
(statearr_67192_67242[(2)] = null);

(statearr_67192_67242[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_67193 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67193[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2684__auto__);

(statearr_67193[(1)] = (1));

return statearr_67193;
});
var fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1 = (function (state_67133){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67133);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67194){var ex__2687__auto__ = e67194;
var statearr_67195_67243 = state_67133;
(statearr_67195_67243[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67133[(4)]))){
var statearr_67196_67244 = state_67133;
(statearr_67196_67244[(1)] = cljs.core.first((state_67133[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67245 = state_67133;
state_67133 = G__67245;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__ = function(state_67133){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1.call(this,state_67133);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67197 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67197[(6)] = c__2706__auto__);

return statearr_67197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67378){
var state_val_67379 = (state_67378[(1)]);
if((state_val_67379 === (7))){
var inst_67275 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_67276 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_67275].join('');
var inst_67277 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67278 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67279 = cljs.core.PersistentHashMap.fromArrays(inst_67277,inst_67278);
var inst_67280 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67276,inst_67279);
var inst_67281 = (function(){throw inst_67280})();
var state_67378__$1 = state_67378;
var statearr_67380_67459 = state_67378__$1;
(statearr_67380_67459[(2)] = inst_67281);

(statearr_67380_67459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (20))){
var inst_67313 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
if(cljs.core.truth_(inst_67313)){
var statearr_67381_67460 = state_67378__$1;
(statearr_67381_67460[(1)] = (21));

} else {
var statearr_67382_67461 = state_67378__$1;
(statearr_67382_67461[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (27))){
var inst_67257 = (state_67378[(7)]);
var state_67378__$1 = state_67378;
var statearr_67383_67462 = state_67378__$1;
(statearr_67383_67462[(2)] = inst_67257);

(statearr_67383_67462[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (1))){
var state_67378__$1 = state_67378;
var statearr_67384_67463 = state_67378__$1;
(statearr_67384_67463[(2)] = null);

(statearr_67384_67463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (24))){
var inst_67319 = (state_67378[(8)]);
var state_67378__$1 = state_67378;
var statearr_67385_67464 = state_67378__$1;
(statearr_67385_67464[(2)] = inst_67319);

(statearr_67385_67464[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (39))){
var inst_67263 = (state_67378[(9)]);
var state_67378__$1 = state_67378;
if(cljs.core.truth_(inst_67263)){
var statearr_67386_67465 = state_67378__$1;
(statearr_67386_67465[(1)] = (42));

} else {
var statearr_67387_67466 = state_67378__$1;
(statearr_67387_67466[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (46))){
var inst_67351 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67352 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_67353 = cljs.core.PersistentHashMap.fromArrays(inst_67351,inst_67352);
var inst_67354 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_67353);
var inst_67355 = (function(){throw inst_67354})();
var state_67378__$1 = state_67378;
var statearr_67388_67467 = state_67378__$1;
(statearr_67388_67467[(2)] = inst_67355);

(statearr_67388_67467[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (4))){
var inst_67247 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
var statearr_67389_67468 = state_67378__$1;
(statearr_67389_67468[(2)] = inst_67247);

(statearr_67389_67468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (15))){
var inst_67260 = (state_67378[(10)]);
var inst_67298 = (state_67378[(11)]);
var inst_67300 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_67298);
var inst_67301 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_67298);
var inst_67302 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_67298);
var inst_67303 = fluree.db.api.query.get_sources(inst_67300,inst_67301,inst_67302,inst_67260);
var state_67378__$1 = state_67378;
var statearr_67390_67469 = state_67378__$1;
(statearr_67390_67469[(2)] = inst_67303);

(statearr_67390_67469[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (48))){
var inst_67308 = (state_67378[(12)]);
var inst_67362 = (state_67378[(2)]);
var inst_67363 = fluree.db.util.async.throw_err(inst_67362);
var state_67378__$1 = (function (){var statearr_67391 = state_67378;
(statearr_67391[(13)] = inst_67363);

return statearr_67391;
})();
if(cljs.core.truth_(inst_67308)){
var statearr_67392_67470 = state_67378__$1;
(statearr_67392_67470[(1)] = (49));

} else {
var statearr_67393_67471 = state_67378__$1;
(statearr_67393_67471[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (50))){
var inst_67363 = (state_67378[(13)]);
var state_67378__$1 = state_67378;
var statearr_67394_67472 = state_67378__$1;
(statearr_67394_67472[(2)] = inst_67363);

(statearr_67394_67472[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (21))){
var inst_67315 = cljs.core.volatile_BANG_((0));
var state_67378__$1 = state_67378;
var statearr_67395_67473 = state_67378__$1;
(statearr_67395_67473[(2)] = inst_67315);

(statearr_67395_67473[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (31))){
var inst_67261 = (state_67378[(14)]);
var state_67378__$1 = state_67378;
if(cljs.core.truth_(inst_67261)){
var statearr_67396_67474 = state_67378__$1;
(statearr_67396_67474[(1)] = (33));

} else {
var statearr_67397_67475 = state_67378__$1;
(statearr_67397_67475[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (32))){
var inst_67338 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
var statearr_67398_67476 = state_67378__$1;
(statearr_67398_67476[(2)] = inst_67338);

(statearr_67398_67476[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (40))){
var inst_67340 = (state_67378[(15)]);
var state_67378__$1 = state_67378;
var statearr_67399_67477 = state_67378__$1;
(statearr_67399_67477[(2)] = inst_67340);

(statearr_67399_67477[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (33))){
var inst_67261 = (state_67378[(14)]);
var state_67378__$1 = state_67378;
var statearr_67400_67478 = state_67378__$1;
(statearr_67400_67478[(2)] = inst_67261);

(statearr_67400_67478[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (13))){
var inst_67258 = (state_67378[(16)]);
var inst_67287 = (state_67378[(2)]);
var inst_67288 = fluree.db.util.async.throw_err(inst_67287);
var inst_67289 = fluree.db.time_travel.as_of_block(inst_67288,inst_67258);
var state_67378__$1 = state_67378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67378__$1,(12),inst_67289);
} else {
if((state_val_67379 === (22))){
var state_67378__$1 = state_67378;
var statearr_67401_67479 = state_67378__$1;
(statearr_67401_67479[(2)] = null);

(statearr_67401_67479[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (36))){
var inst_67265 = (state_67378[(17)]);
var state_67378__$1 = state_67378;
var statearr_67402_67480 = state_67378__$1;
(statearr_67402_67480[(2)] = inst_67265);

(statearr_67402_67480[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (41))){
var inst_67348 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
if(cljs.core.truth_(inst_67348)){
var statearr_67403_67481 = state_67378__$1;
(statearr_67403_67481[(1)] = (45));

} else {
var statearr_67404_67482 = state_67378__$1;
(statearr_67404_67482[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (43))){
var inst_67259 = (state_67378[(18)]);
var state_67378__$1 = state_67378;
var statearr_67405_67483 = state_67378__$1;
(statearr_67405_67483[(2)] = inst_67259);

(statearr_67405_67483[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (29))){
var inst_67340 = (state_67378[(15)]);
var inst_67340__$1 = (state_67378[(2)]);
var state_67378__$1 = (function (){var statearr_67406 = state_67378;
(statearr_67406[(15)] = inst_67340__$1);

return statearr_67406;
})();
if(cljs.core.truth_(inst_67340__$1)){
var statearr_67407_67484 = state_67378__$1;
(statearr_67407_67484[(1)] = (39));

} else {
var statearr_67408_67485 = state_67378__$1;
(statearr_67408_67485[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (44))){
var inst_67345 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
var statearr_67409_67486 = state_67378__$1;
(statearr_67409_67486[(2)] = inst_67345);

(statearr_67409_67486[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (6))){
var state_67378__$1 = state_67378;
var statearr_67410_67487 = state_67378__$1;
(statearr_67410_67487[(2)] = null);

(statearr_67410_67487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (28))){
var inst_67262 = (state_67378[(19)]);
var state_67378__$1 = state_67378;
if(cljs.core.truth_(inst_67262)){
var statearr_67411_67488 = state_67378__$1;
(statearr_67411_67488[(1)] = (30));

} else {
var statearr_67412_67489 = state_67378__$1;
(statearr_67412_67489[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (51))){
var inst_67373 = (state_67378[(2)]);
var _ = (function (){var statearr_67413 = state_67378;
(statearr_67413[(4)] = cljs.core.rest((state_67378[(4)])));

return statearr_67413;
})();
var state_67378__$1 = state_67378;
var statearr_67414_67490 = state_67378__$1;
(statearr_67414_67490[(2)] = inst_67373);

(statearr_67414_67490[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (25))){
var state_67378__$1 = state_67378;
var statearr_67415_67491 = state_67378__$1;
(statearr_67415_67491[(2)] = (1000000));

(statearr_67415_67491[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (34))){
var inst_67265 = (state_67378[(17)]);
var state_67378__$1 = state_67378;
if(cljs.core.truth_(inst_67265)){
var statearr_67416_67492 = state_67378__$1;
(statearr_67416_67492[(1)] = (36));

} else {
var statearr_67417_67493 = state_67378__$1;
(statearr_67417_67493[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (17))){
var inst_67309 = (state_67378[(20)]);
var inst_67264 = (state_67378[(21)]);
var inst_67307 = (state_67378[(2)]);
var inst_67308 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_67264);
var inst_67309__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67264);
var state_67378__$1 = (function (){var statearr_67418 = state_67378;
(statearr_67418[(20)] = inst_67309__$1);

(statearr_67418[(12)] = inst_67308);

(statearr_67418[(22)] = inst_67307);

return statearr_67418;
})();
if(cljs.core.truth_(inst_67309__$1)){
var statearr_67419_67494 = state_67378__$1;
(statearr_67419_67494[(1)] = (18));

} else {
var statearr_67420_67495 = state_67378__$1;
(statearr_67420_67495[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (3))){
var inst_67376 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67378__$1,inst_67376);
} else {
if((state_val_67379 === (12))){
var inst_67291 = (state_67378[(2)]);
var inst_67292 = fluree.db.util.async.throw_err(inst_67291);
var state_67378__$1 = state_67378;
var statearr_67421_67496 = state_67378__$1;
(statearr_67421_67496[(2)] = inst_67292);

(statearr_67421_67496[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (2))){
var inst_67263 = (state_67378[(9)]);
var inst_67260 = (state_67378[(10)]);
var inst_67259 = (state_67378[(18)]);
var inst_67256 = (state_67378[(23)]);
var inst_67262 = (state_67378[(19)]);
var inst_67261 = (state_67378[(14)]);
var inst_67264 = (state_67378[(21)]);
var inst_67257 = (state_67378[(7)]);
var inst_67265 = (state_67378[(17)]);
var inst_67258 = (state_67378[(16)]);
var _ = (function (){var statearr_67422 = state_67378;
(statearr_67422[(4)] = cljs.core.cons((5),(state_67378[(4)])));

return statearr_67422;
})();
var inst_67254 = flureeQL;
var inst_67255 = cljs.core.__destructure_map(inst_67254);
var inst_67256__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_67257__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_67258__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"block","block",664686210));
var inst_67259__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_67260__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_67261__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_67262__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_67263__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_67264__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_67265__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67255,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_67266 = (function (){var construct = inst_67256__$1;
var select = inst_67257__$1;
var block = inst_67258__$1;
var where = inst_67259__$1;
var prefixes = inst_67260__$1;
var map__67253 = inst_67255;
var selectDistinct = inst_67261__$1;
var selectOne = inst_67262__$1;
var from = inst_67263__$1;
var opts = inst_67264__$1;
var selectReduced = inst_67265__$1;
return (function (p1__67246_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__67246_SHARP_);
});
})();
var inst_67267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67268 = [inst_67257__$1,inst_67262__$1,inst_67261__$1,inst_67265__$1];
var inst_67269 = (new cljs.core.PersistentVector(null,4,(5),inst_67267,inst_67268,null));
var inst_67270 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_67269);
var inst_67271 = cljs.core.count(inst_67270);
var inst_67272 = (inst_67266.cljs$core$IFn$_invoke$arity$1 ? inst_67266.cljs$core$IFn$_invoke$arity$1(inst_67271) : inst_67266.call(null,inst_67271));
var state_67378__$1 = (function (){var statearr_67423 = state_67378;
(statearr_67423[(9)] = inst_67263__$1);

(statearr_67423[(10)] = inst_67260__$1);

(statearr_67423[(18)] = inst_67259__$1);

(statearr_67423[(23)] = inst_67256__$1);

(statearr_67423[(19)] = inst_67262__$1);

(statearr_67423[(14)] = inst_67261__$1);

(statearr_67423[(21)] = inst_67264__$1);

(statearr_67423[(7)] = inst_67257__$1);

(statearr_67423[(17)] = inst_67265__$1);

(statearr_67423[(16)] = inst_67258__$1);

return statearr_67423;
})();
if(cljs.core.truth_(inst_67272)){
var statearr_67424_67497 = state_67378__$1;
(statearr_67424_67497[(1)] = (6));

} else {
var statearr_67425_67498 = state_67378__$1;
(statearr_67425_67498[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (23))){
var inst_67264 = (state_67378[(21)]);
var inst_67319 = (state_67378[(8)]);
var inst_67318 = (state_67378[(2)]);
var inst_67319__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_67264);
var state_67378__$1 = (function (){var statearr_67426 = state_67378;
(statearr_67426[(24)] = inst_67318);

(statearr_67426[(8)] = inst_67319__$1);

return statearr_67426;
})();
if(cljs.core.truth_(inst_67319__$1)){
var statearr_67427_67499 = state_67378__$1;
(statearr_67427_67499[(1)] = (24));

} else {
var statearr_67428_67500 = state_67378__$1;
(statearr_67428_67500[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (47))){
var inst_67298 = (state_67378[(11)]);
var inst_67324 = (state_67378[(25)]);
var inst_67357 = (state_67378[(2)]);
var inst_67358 = fluree.db.util.core.current_time_millis();
var inst_67359 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_67324);
var inst_67360 = fluree.db.query.fql.query(inst_67298,inst_67359);
var state_67378__$1 = (function (){var statearr_67429 = state_67378;
(statearr_67429[(26)] = inst_67358);

(statearr_67429[(27)] = inst_67357);

return statearr_67429;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67378__$1,(48),inst_67360);
} else {
if((state_val_67379 === (35))){
var inst_67336 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
var statearr_67430_67501 = state_67378__$1;
(statearr_67430_67501[(2)] = inst_67336);

(statearr_67430_67501[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (19))){
var inst_67308 = (state_67378[(12)]);
var state_67378__$1 = state_67378;
var statearr_67431_67502 = state_67378__$1;
(statearr_67431_67502[(2)] = inst_67308);

(statearr_67431_67502[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (11))){
var inst_67260 = (state_67378[(10)]);
var inst_67298 = (state_67378[(2)]);
var state_67378__$1 = (function (){var statearr_67433 = state_67378;
(statearr_67433[(11)] = inst_67298);

return statearr_67433;
})();
if(cljs.core.truth_(inst_67260)){
var statearr_67434_67503 = state_67378__$1;
(statearr_67434_67503[(1)] = (15));

} else {
var statearr_67435_67504 = state_67378__$1;
(statearr_67435_67504[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (9))){
var inst_67284 = (state_67378[(28)]);
var state_67378__$1 = state_67378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67378__$1,(13),inst_67284);
} else {
if((state_val_67379 === (5))){
var _ = (function (){var statearr_67436 = state_67378;
(statearr_67436[(4)] = cljs.core.rest((state_67378[(4)])));

return statearr_67436;
})();
var state_67378__$1 = state_67378;
var ex67432 = (state_67378__$1[(2)]);
var statearr_67437_67505 = state_67378__$1;
(statearr_67437_67505[(5)] = ex67432);


if((ex67432 instanceof Error)){
var statearr_67438_67506 = state_67378__$1;
(statearr_67438_67506[(1)] = (4));

(statearr_67438_67506[(5)] = null);

} else {
throw ex67432;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (14))){
var inst_67295 = (state_67378[(2)]);
var inst_67296 = fluree.db.util.async.throw_err(inst_67295);
var state_67378__$1 = state_67378;
var statearr_67439_67507 = state_67378__$1;
(statearr_67439_67507[(2)] = inst_67296);

(statearr_67439_67507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (45))){
var state_67378__$1 = state_67378;
var statearr_67440_67508 = state_67378__$1;
(statearr_67440_67508[(2)] = null);

(statearr_67440_67508[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (26))){
var inst_67318 = (state_67378[(24)]);
var inst_67264 = (state_67378[(21)]);
var inst_67257 = (state_67378[(7)]);
var inst_67307 = (state_67378[(22)]);
var inst_67323 = (state_67378[(2)]);
var inst_67324 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_67264,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_67307,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_67323,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_67318], 0));
var state_67378__$1 = (function (){var statearr_67441 = state_67378;
(statearr_67441[(25)] = inst_67324);

return statearr_67441;
})();
if(cljs.core.truth_(inst_67257)){
var statearr_67442_67509 = state_67378__$1;
(statearr_67442_67509[(1)] = (27));

} else {
var statearr_67443_67510 = state_67378__$1;
(statearr_67443_67510[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (16))){
var inst_67305 = cljs.core.PersistentHashMap.EMPTY;
var state_67378__$1 = state_67378;
var statearr_67444_67511 = state_67378__$1;
(statearr_67444_67511[(2)] = inst_67305);

(statearr_67444_67511[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (38))){
var inst_67334 = (state_67378[(2)]);
var state_67378__$1 = state_67378;
var statearr_67445_67512 = state_67378__$1;
(statearr_67445_67512[(2)] = inst_67334);

(statearr_67445_67512[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (30))){
var inst_67262 = (state_67378[(19)]);
var state_67378__$1 = state_67378;
var statearr_67446_67513 = state_67378__$1;
(statearr_67446_67513[(2)] = inst_67262);

(statearr_67446_67513[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (10))){
var inst_67284 = (state_67378[(28)]);
var state_67378__$1 = state_67378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67378__$1,(14),inst_67284);
} else {
if((state_val_67379 === (18))){
var inst_67309 = (state_67378[(20)]);
var state_67378__$1 = state_67378;
var statearr_67447_67514 = state_67378__$1;
(statearr_67447_67514[(2)] = inst_67309);

(statearr_67447_67514[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (42))){
var inst_67263 = (state_67378[(9)]);
var state_67378__$1 = state_67378;
var statearr_67448_67515 = state_67378__$1;
(statearr_67448_67515[(2)] = inst_67263);

(statearr_67448_67515[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (37))){
var inst_67256 = (state_67378[(23)]);
var state_67378__$1 = state_67378;
var statearr_67449_67516 = state_67378__$1;
(statearr_67449_67516[(2)] = inst_67256);

(statearr_67449_67516[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (8))){
var inst_67258 = (state_67378[(16)]);
var inst_67283 = (state_67378[(2)]);
var inst_67284 = sources;
var state_67378__$1 = (function (){var statearr_67450 = state_67378;
(statearr_67450[(28)] = inst_67284);

(statearr_67450[(29)] = inst_67283);

return statearr_67450;
})();
if(cljs.core.truth_(inst_67258)){
var statearr_67451_67517 = state_67378__$1;
(statearr_67451_67517[(1)] = (9));

} else {
var statearr_67452_67518 = state_67378__$1;
(statearr_67452_67518[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67379 === (49))){
var inst_67358 = (state_67378[(26)]);
var inst_67363 = (state_67378[(13)]);
var inst_67318 = (state_67378[(24)]);
var inst_67298 = (state_67378[(11)]);
var inst_67365 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_67366 = cljs.core.deref(inst_67318);
var inst_67367 = fluree.db.util.core.response_time_formatted(inst_67358);
var inst_67368 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_67298);
var inst_67369 = [(200),inst_67363,inst_67366,inst_67367,inst_67368];
var inst_67370 = cljs.core.PersistentHashMap.fromArrays(inst_67365,inst_67369);
var state_67378__$1 = state_67378;
var statearr_67453_67519 = state_67378__$1;
(statearr_67453_67519[(2)] = inst_67370);

(statearr_67453_67519[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_67454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67454[(0)] = fluree$db$api$query$query_async_$_state_machine__2684__auto__);

(statearr_67454[(1)] = (1));

return statearr_67454;
});
var fluree$db$api$query$query_async_$_state_machine__2684__auto____1 = (function (state_67378){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67378);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67455){var ex__2687__auto__ = e67455;
var statearr_67456_67520 = state_67378;
(statearr_67456_67520[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67378[(4)]))){
var statearr_67457_67521 = state_67378;
(statearr_67457_67521[(1)] = cljs.core.first((state_67378[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67522 = state_67378;
state_67378 = G__67522;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2684__auto__ = function(state_67378){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2684__auto____1.call(this,state_67378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67458 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67458[(6)] = c__2706__auto__);

return statearr_67458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2706__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2707__auto__ = (function (){var switch__2683__auto__ = (function (state_67663){
var state_val_67664 = (state_67663[(1)]);
if((state_val_67664 === (7))){
var inst_67658 = (state_67663[(2)]);
var _ = (function (){var statearr_67665 = state_67663;
(statearr_67665[(4)] = cljs.core.rest((state_67663[(4)])));

return statearr_67665;
})();
var state_67663__$1 = state_67663;
var statearr_67666_67742 = state_67663__$1;
(statearr_67666_67742[(2)] = inst_67658);

(statearr_67666_67742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (20))){
var inst_67630 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67667_67743 = state_67663__$1;
(statearr_67667_67743[(2)] = inst_67630);

(statearr_67667_67743[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (27))){
var inst_67610 = (state_67663[(7)]);
var state_67663__$1 = state_67663;
var statearr_67668_67744 = state_67663__$1;
(statearr_67668_67744[(2)] = inst_67610);

(statearr_67668_67744[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (1))){
var state_67663__$1 = state_67663;
var statearr_67669_67745 = state_67663__$1;
(statearr_67669_67745[(2)] = null);

(statearr_67669_67745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (24))){
var inst_67607 = (state_67663[(8)]);
var state_67663__$1 = state_67663;
var statearr_67670_67746 = state_67663__$1;
(statearr_67670_67746[(2)] = inst_67607);

(statearr_67670_67746[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (39))){
var inst_67597 = (state_67663[(9)]);
var inst_67564 = (state_67663[(10)]);
var inst_67575 = (state_67663[(11)]);
var inst_67641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67642 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_67575];
var inst_67643 = (new cljs.core.PersistentVector(null,2,(5),inst_67641,inst_67642,null));
var inst_67644 = cljs.core.assoc_in(inst_67564,inst_67643,inst_67597);
var state_67663__$1 = state_67663;
var statearr_67671_67747 = state_67663__$1;
(statearr_67671_67747[(2)] = inst_67644);

(statearr_67671_67747[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (4))){
var inst_67523 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67672_67748 = state_67663__$1;
(statearr_67672_67748[(2)] = inst_67523);

(statearr_67672_67748[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (15))){
var inst_67562 = (state_67663[(12)]);
var inst_67597 = (state_67663[(9)]);
var inst_67600 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_67597);
var inst_67601 = (inst_67562 == null);
var state_67663__$1 = (function (){var statearr_67673 = state_67663;
(statearr_67673[(13)] = inst_67600);

return statearr_67673;
})();
if(cljs.core.truth_(inst_67601)){
var statearr_67674_67749 = state_67663__$1;
(statearr_67674_67749[(1)] = (18));

} else {
var statearr_67675_67750 = state_67663__$1;
(statearr_67675_67750[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (21))){
var inst_67600 = (state_67663[(13)]);
var state_67663__$1 = state_67663;
var statearr_67676_67751 = state_67663__$1;
(statearr_67676_67751[(2)] = inst_67600);

(statearr_67676_67751[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (31))){
var state_67663__$1 = state_67663;
var statearr_67677_67752 = state_67663__$1;
(statearr_67677_67752[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (32))){
var inst_67626 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67679_67753 = state_67663__$1;
(statearr_67679_67753[(2)] = inst_67626);

(statearr_67679_67753[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (40))){
var inst_67595 = (state_67663[(14)]);
var state_67663__$1 = state_67663;
if(cljs.core.truth_(inst_67595)){
var statearr_67680_67754 = state_67663__$1;
(statearr_67680_67754[(1)] = (42));

} else {
var statearr_67681_67755 = state_67663__$1;
(statearr_67681_67755[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (33))){
var inst_67600 = (state_67663[(13)]);
var inst_67562 = (state_67663[(12)]);
var inst_67621 = ((inst_67600 > inst_67562) ? inst_67600 : inst_67562);
var state_67663__$1 = state_67663;
var statearr_67682_67756 = state_67663__$1;
(statearr_67682_67756[(2)] = inst_67621);

(statearr_67682_67756[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (13))){
var inst_67586 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67683_67757 = state_67663__$1;
(statearr_67683_67757[(2)] = inst_67586);

(statearr_67683_67757[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (22))){
var inst_67600 = (state_67663[(13)]);
var inst_67607 = (state_67663[(8)]);
var inst_67607__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_67600);
var state_67663__$1 = (function (){var statearr_67684 = state_67663;
(statearr_67684[(8)] = inst_67607__$1);

return statearr_67684;
})();
if(inst_67607__$1){
var statearr_67685_67758 = state_67663__$1;
(statearr_67685_67758[(1)] = (24));

} else {
var statearr_67686_67759 = state_67663__$1;
(statearr_67686_67759[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (36))){
var inst_67563 = (state_67663[(15)]);
var inst_67597 = (state_67663[(9)]);
var inst_67635 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_67597,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_67636 = (inst_67563 + inst_67635);
var state_67663__$1 = state_67663;
var statearr_67687_67760 = state_67663__$1;
(statearr_67687_67760[(2)] = inst_67636);

(statearr_67687_67760[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (41))){
var inst_67574 = (state_67663[(16)]);
var inst_67639 = (state_67663[(17)]);
var inst_67633 = (state_67663[(18)]);
var inst_67653 = (state_67663[(2)]);
var inst_67561 = inst_67574;
var inst_67562 = inst_67633;
var inst_67563 = inst_67639;
var inst_67564 = inst_67653;
var state_67663__$1 = (function (){var statearr_67688 = state_67663;
(statearr_67688[(19)] = inst_67561);

(statearr_67688[(15)] = inst_67563);

(statearr_67688[(12)] = inst_67562);

(statearr_67688[(10)] = inst_67564);

return statearr_67688;
})();
var statearr_67689_67761 = state_67663__$1;
(statearr_67689_67761[(2)] = null);

(statearr_67689_67761[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (43))){
var inst_67597 = (state_67663[(9)]);
var state_67663__$1 = state_67663;
var statearr_67690_67762 = state_67663__$1;
(statearr_67690_67762[(2)] = inst_67597);

(statearr_67690_67762[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (29))){
var inst_67615 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67691_67763 = state_67663__$1;
(statearr_67691_67763[(2)] = inst_67615);

(statearr_67691_67763[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (44))){
var inst_67564 = (state_67663[(10)]);
var inst_67575 = (state_67663[(11)]);
var inst_67650 = (state_67663[(2)]);
var inst_67651 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_67564,inst_67575,inst_67650);
var state_67663__$1 = state_67663;
var statearr_67692_67764 = state_67663__$1;
(statearr_67692_67764[(2)] = inst_67651);

(statearr_67692_67764[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (6))){
var inst_67561 = (state_67663[(19)]);
var inst_67576 = (state_67663[(20)]);
var inst_67572 = cljs.core.seq(inst_67561);
var inst_67573 = cljs.core.first(inst_67572);
var inst_67574 = cljs.core.next(inst_67572);
var inst_67575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67573,(0),null);
var inst_67576__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67573,(1),null);
var inst_67577 = (inst_67576__$1 == null);
var state_67663__$1 = (function (){var statearr_67693 = state_67663;
(statearr_67693[(16)] = inst_67574);

(statearr_67693[(20)] = inst_67576__$1);

(statearr_67693[(11)] = inst_67575);

return statearr_67693;
})();
if(cljs.core.truth_(inst_67577)){
var statearr_67694_67765 = state_67663__$1;
(statearr_67694_67765[(1)] = (8));

} else {
var statearr_67695_67766 = state_67663__$1;
(statearr_67695_67766[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (28))){
var inst_67562 = (state_67663[(12)]);
var inst_67613 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_67562);
var state_67663__$1 = state_67663;
var statearr_67696_67767 = state_67663__$1;
(statearr_67696_67767[(2)] = inst_67613);

(statearr_67696_67767[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (25))){
var inst_67610 = (state_67663[(7)]);
var inst_67562 = (state_67663[(12)]);
var inst_67610__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_67562);
var state_67663__$1 = (function (){var statearr_67697 = state_67663;
(statearr_67697[(7)] = inst_67610__$1);

return statearr_67697;
})();
if(inst_67610__$1){
var statearr_67698_67768 = state_67663__$1;
(statearr_67698_67768[(1)] = (27));

} else {
var statearr_67699_67769 = state_67663__$1;
(statearr_67699_67769[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (34))){
var state_67663__$1 = state_67663;
var statearr_67700_67770 = state_67663__$1;
(statearr_67700_67770[(2)] = null);

(statearr_67700_67770[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (17))){
var inst_67594 = (state_67663[(21)]);
var inst_67633 = (state_67663[(2)]);
var state_67663__$1 = (function (){var statearr_67701 = state_67663;
(statearr_67701[(18)] = inst_67633);

return statearr_67701;
})();
if(cljs.core.truth_(inst_67594)){
var statearr_67702_67771 = state_67663__$1;
(statearr_67702_67771[(1)] = (36));

} else {
var statearr_67703_67772 = state_67663__$1;
(statearr_67703_67772[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (3))){
var inst_67661 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67663__$1,inst_67661);
} else {
if((state_val_67664 === (12))){
var inst_67564 = (state_67663[(10)]);
var state_67663__$1 = state_67663;
var statearr_67704_67773 = state_67663__$1;
(statearr_67704_67773[(2)] = inst_67564);

(statearr_67704_67773[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (2))){
var inst_67538 = (state_67663[(22)]);
var inst_67533 = (state_67663[(23)]);
var inst_67537 = (state_67663[(24)]);
var _ = (function (){var statearr_67705 = state_67663;
(statearr_67705[(4)] = cljs.core.cons((5),(state_67663[(4)])));

return statearr_67705;
})();
var inst_67529 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_67530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67531 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_67532 = (new cljs.core.PersistentVector(null,2,(5),inst_67530,inst_67531,null));
var inst_67533__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_67532);
var inst_67534 = (function (){var global_block = inst_67529;
var global_meta_QMARK_ = inst_67533__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_67535 = cljs.core.PersistentHashMap.EMPTY;
var inst_67536 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_67537__$1 = cljs.core.reduce_kv(inst_67534,inst_67535,inst_67536);
var inst_67538__$1 = fluree.db.util.core.current_time_millis();
var inst_67540 = (function (){var global_block = inst_67529;
var global_meta_QMARK_ = inst_67533__$1;
var queries = inst_67537__$1;
var start_time = inst_67538__$1;
return (function (p__67539){
var vec__67706 = p__67539;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67706,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67706,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_67541 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_67540,inst_67537__$1);
var inst_67555 = cljs.core.seq(inst_67541);
var inst_67556 = cljs.core.first(inst_67555);
var inst_67557 = cljs.core.next(inst_67555);
var inst_67558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67556,(0),null);
var inst_67559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67556,(1),null);
var inst_67560 = cljs.core.PersistentHashMap.EMPTY;
var inst_67561 = inst_67541;
var inst_67562 = null;
var inst_67563 = (0);
var inst_67564 = inst_67560;
var state_67663__$1 = (function (){var statearr_67709 = state_67663;
(statearr_67709[(19)] = inst_67561);

(statearr_67709[(22)] = inst_67538__$1);

(statearr_67709[(25)] = inst_67558);

(statearr_67709[(15)] = inst_67563);

(statearr_67709[(23)] = inst_67533__$1);

(statearr_67709[(12)] = inst_67562);

(statearr_67709[(10)] = inst_67564);

(statearr_67709[(24)] = inst_67537__$1);

(statearr_67709[(26)] = inst_67557);

(statearr_67709[(27)] = inst_67559);

return statearr_67709;
})();
var statearr_67710_67774 = state_67663__$1;
(statearr_67710_67774[(2)] = null);

(statearr_67710_67774[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (23))){
var inst_67628 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67711_67775 = state_67663__$1;
(statearr_67711_67775[(2)] = inst_67628);

(statearr_67711_67775[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (35))){
var inst_67624 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67712_67776 = state_67663__$1;
(statearr_67712_67776[(2)] = inst_67624);

(statearr_67712_67776[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (19))){
var inst_67600 = (state_67663[(13)]);
var inst_67562 = (state_67663[(12)]);
var inst_67604 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67562,inst_67600);
var state_67663__$1 = state_67663;
if(inst_67604){
var statearr_67713_67777 = state_67663__$1;
(statearr_67713_67777[(1)] = (21));

} else {
var statearr_67714_67778 = state_67663__$1;
(statearr_67714_67778[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (11))){
var inst_67538 = (state_67663[(22)]);
var inst_67563 = (state_67663[(15)]);
var inst_67562 = (state_67663[(12)]);
var inst_67564 = (state_67663[(10)]);
var inst_67580 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_67581 = fluree.db.util.core.response_time_formatted(inst_67538);
var inst_67582 = [inst_67564,inst_67563,inst_67562,inst_67581];
var inst_67583 = cljs.core.PersistentHashMap.fromArrays(inst_67580,inst_67582);
var state_67663__$1 = state_67663;
var statearr_67716_67779 = state_67663__$1;
(statearr_67716_67779[(2)] = inst_67583);

(statearr_67716_67779[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (9))){
var inst_67576 = (state_67663[(20)]);
var inst_67537 = (state_67663[(24)]);
var inst_67575 = (state_67663[(11)]);
var inst_67589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67590 = [inst_67575,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_67591 = (new cljs.core.PersistentVector(null,2,(5),inst_67589,inst_67590,null));
var inst_67592 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_67537,inst_67591);
var inst_67593 = cljs.core.__destructure_map(inst_67592);
var inst_67594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67593,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_67595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67593,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_67663__$1 = (function (){var statearr_67717 = state_67663;
(statearr_67717[(14)] = inst_67595);

(statearr_67717[(21)] = inst_67594);

return statearr_67717;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67663__$1,(14),inst_67576);
} else {
if((state_val_67664 === (5))){
var _ = (function (){var statearr_67718 = state_67663;
(statearr_67718[(4)] = cljs.core.rest((state_67663[(4)])));

return statearr_67718;
})();
var state_67663__$1 = state_67663;
var ex67715 = (state_67663__$1[(2)]);
var statearr_67719_67780 = state_67663__$1;
(statearr_67719_67780[(5)] = ex67715);


var statearr_67720_67781 = state_67663__$1;
(statearr_67720_67781[(1)] = (4));

(statearr_67720_67781[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (14))){
var inst_67594 = (state_67663[(21)]);
var inst_67597 = (state_67663[(9)]);
var inst_67597__$1 = (state_67663[(2)]);
var inst_67598 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_67597__$1);
var state_67663__$1 = (function (){var statearr_67721 = state_67663;
(statearr_67721[(28)] = inst_67598);

(statearr_67721[(9)] = inst_67597__$1);

return statearr_67721;
})();
if(cljs.core.truth_(inst_67594)){
var statearr_67722_67782 = state_67663__$1;
(statearr_67722_67782[(1)] = (15));

} else {
var statearr_67723_67783 = state_67663__$1;
(statearr_67723_67783[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (26))){
var inst_67617 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
if(cljs.core.truth_(inst_67617)){
var statearr_67724_67784 = state_67663__$1;
(statearr_67724_67784[(1)] = (30));

} else {
var statearr_67725_67785 = state_67663__$1;
(statearr_67725_67785[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (16))){
var state_67663__$1 = state_67663;
var statearr_67726_67786 = state_67663__$1;
(statearr_67726_67786[(2)] = null);

(statearr_67726_67786[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (38))){
var inst_67598 = (state_67663[(28)]);
var inst_67639 = (state_67663[(2)]);
var state_67663__$1 = (function (){var statearr_67727 = state_67663;
(statearr_67727[(17)] = inst_67639);

return statearr_67727;
})();
if(cljs.core.truth_(inst_67598)){
var statearr_67728_67787 = state_67663__$1;
(statearr_67728_67787[(1)] = (39));

} else {
var statearr_67729_67788 = state_67663__$1;
(statearr_67729_67788[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (30))){
var state_67663__$1 = state_67663;
var statearr_67730_67789 = state_67663__$1;
(statearr_67730_67789[(2)] = (207));

(statearr_67730_67789[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (10))){
var inst_67656 = (state_67663[(2)]);
var state_67663__$1 = state_67663;
var statearr_67731_67790 = state_67663__$1;
(statearr_67731_67790[(2)] = inst_67656);

(statearr_67731_67790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (18))){
var inst_67600 = (state_67663[(13)]);
var state_67663__$1 = state_67663;
var statearr_67732_67791 = state_67663__$1;
(statearr_67732_67791[(2)] = inst_67600);

(statearr_67732_67791[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (42))){
var inst_67597 = (state_67663[(9)]);
var inst_67647 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_67597);
var state_67663__$1 = state_67663;
var statearr_67733_67792 = state_67663__$1;
(statearr_67733_67792[(2)] = inst_67647);

(statearr_67733_67792[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (37))){
var state_67663__$1 = state_67663;
var statearr_67734_67793 = state_67663__$1;
(statearr_67734_67793[(2)] = null);

(statearr_67734_67793[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67664 === (8))){
var inst_67533 = (state_67663[(23)]);
var state_67663__$1 = state_67663;
if(cljs.core.truth_(inst_67533)){
var statearr_67735_67794 = state_67663__$1;
(statearr_67735_67794[(1)] = (11));

} else {
var statearr_67736_67795 = state_67663__$1;
(statearr_67736_67795[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0 = (function (){
var statearr_67737 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67737[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__);

(statearr_67737[(1)] = (1));

return statearr_67737;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1 = (function (state_67663){
while(true){
var ret_value__2685__auto__ = (function (){try{while(true){
var result__2686__auto__ = switch__2683__auto__(state_67663);
if(cljs.core.keyword_identical_QMARK_(result__2686__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2686__auto__;
}
break;
}
}catch (e67738){var ex__2687__auto__ = e67738;
var statearr_67739_67796 = state_67663;
(statearr_67739_67796[(2)] = ex__2687__auto__);


if(cljs.core.seq((state_67663[(4)]))){
var statearr_67740_67797 = state_67663;
(statearr_67740_67797[(1)] = cljs.core.first((state_67663[(4)])));

} else {
throw ex__2687__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2685__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67798 = state_67663;
state_67663 = G__67798;
continue;
} else {
return ret_value__2685__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__ = function(state_67663){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1.call(this,state_67663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2684__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2684__auto__;
})()
})();
var state__2708__auto__ = (function (){var statearr_67741 = (f__2707__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2707__auto__.cljs$core$IFn$_invoke$arity$0() : f__2707__auto__.call(null));
(statearr_67741[(6)] = c__2706__auto__);

return statearr_67741;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2708__auto__);
}));

return c__2706__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__67799 = query_type;
var G__67799__$1 = (((G__67799 instanceof cljs.core.Keyword))?G__67799.fqn:null);
switch (G__67799__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67799__$1)].join('')));

}
});
