// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.subject_crawl.core');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.subject');
goog.require('fluree.db.query.subject_crawl.rdf_type');
goog.require('fluree.db.query.subject_crawl.common');
/**
 * Returns a parsed selection specification.
 * 
 *   This strategy is only deployed if there is a single selection graph crawl,
 *   so this assumes this case is true in code.
 */
fluree.db.query.subject_crawl.core.retrieve_select_spec = (function fluree$db$query$subject_crawl$core$retrieve_select_spec(db,p__24522){
var map__24523 = p__24522;
var map__24523__$1 = cljs.core.__destructure_map(map__24523);
var parsed_query = map__24523__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24523__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24523__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var select_smt = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(select)));
return fluree.db.query.fql_parser.parse_db(db,select_smt,opts);
});
fluree.db.query.subject_crawl.core.relationship_binding = (function fluree$db$query$subject_crawl$core$relationship_binding(p__24524){
var map__24525 = p__24524;
var map__24525__$1 = cljs.core.__destructure_map(map__24525);
var opts = map__24525__$1;
var rdf_type_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24525__$1,new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24525__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_24569){
var state_val_24570 = (state_24569[(1)]);
if((state_val_24570 === (7))){
var inst_24548 = (state_24569[(7)]);
var inst_24550 = fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(inst_24548);
var state_24569__$1 = state_24569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24569__$1,(10),inst_24550);
} else {
if((state_val_24570 === (1))){
var inst_24533 = vars;
var inst_24534 = cljs.core.seq(inst_24533);
var inst_24535 = cljs.core.first(inst_24534);
var inst_24536 = cljs.core.next(inst_24534);
var inst_24537 = cljs.core.PersistentVector.EMPTY;
var inst_24538 = inst_24533;
var inst_24539 = inst_24537;
var state_24569__$1 = (function (){var statearr_24571 = state_24569;
(statearr_24571[(8)] = inst_24536);

(statearr_24571[(9)] = inst_24535);

(statearr_24571[(10)] = inst_24538);

(statearr_24571[(11)] = inst_24539);

return statearr_24571;
})();
var statearr_24572_24590 = state_24569__$1;
(statearr_24572_24590[(2)] = null);

(statearr_24572_24590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (4))){
var inst_24545 = (state_24569[(12)]);
var inst_24548 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"vars","vars",-2046957217),inst_24545);
var state_24569__$1 = (function (){var statearr_24573 = state_24569;
(statearr_24573[(7)] = inst_24548);

return statearr_24573;
})();
if(cljs.core.truth_(rdf_type_QMARK_)){
var statearr_24574_24591 = state_24569__$1;
(statearr_24574_24591[(1)] = (7));

} else {
var statearr_24575_24592 = state_24569__$1;
(statearr_24575_24592[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (6))){
var inst_24565 = (state_24569[(2)]);
var state_24569__$1 = state_24569;
var statearr_24576_24593 = state_24569__$1;
(statearr_24576_24593[(2)] = inst_24565);

(statearr_24576_24593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (3))){
var inst_24567 = (state_24569[(2)]);
var state_24569__$1 = state_24569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24569__$1,inst_24567);
} else {
if((state_val_24570 === (2))){
var inst_24538 = (state_24569[(10)]);
var inst_24545 = (state_24569[(12)]);
var inst_24544 = cljs.core.seq(inst_24538);
var inst_24545__$1 = cljs.core.first(inst_24544);
var inst_24546 = cljs.core.next(inst_24544);
var state_24569__$1 = (function (){var statearr_24577 = state_24569;
(statearr_24577[(13)] = inst_24546);

(statearr_24577[(12)] = inst_24545__$1);

return statearr_24577;
})();
if(cljs.core.truth_(inst_24545__$1)){
var statearr_24578_24594 = state_24569__$1;
(statearr_24578_24594[(1)] = (4));

} else {
var statearr_24579_24595 = state_24569__$1;
(statearr_24579_24595[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (11))){
var inst_24557 = (state_24569[(2)]);
var inst_24558 = fluree.db.util.async.throw_err(inst_24557);
var state_24569__$1 = state_24569;
var statearr_24580_24596 = state_24569__$1;
(statearr_24580_24596[(2)] = inst_24558);

(statearr_24580_24596[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (9))){
var inst_24546 = (state_24569[(13)]);
var inst_24539 = (state_24569[(11)]);
var inst_24560 = (state_24569[(2)]);
var inst_24561 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24539,inst_24560);
var inst_24538 = inst_24546;
var inst_24539__$1 = inst_24561;
var state_24569__$1 = (function (){var statearr_24581 = state_24569;
(statearr_24581[(10)] = inst_24538);

(statearr_24581[(11)] = inst_24539__$1);

return statearr_24581;
})();
var statearr_24582_24597 = state_24569__$1;
(statearr_24582_24597[(2)] = null);

(statearr_24582_24597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (5))){
var inst_24539 = (state_24569[(11)]);
var state_24569__$1 = state_24569;
var statearr_24583_24598 = state_24569__$1;
(statearr_24583_24598[(2)] = inst_24539);

(statearr_24583_24598[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (10))){
var inst_24552 = (state_24569[(2)]);
var inst_24553 = fluree.db.util.async.throw_err(inst_24552);
var state_24569__$1 = state_24569;
var statearr_24584_24599 = state_24569__$1;
(statearr_24584_24599[(2)] = inst_24553);

(statearr_24584_24599[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24570 === (8))){
var inst_24548 = (state_24569[(7)]);
var inst_24555 = fluree.db.query.subject_crawl.subject.subj_crawl(inst_24548);
var state_24569__$1 = state_24569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24569__$1,(11),inst_24555);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = null;
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0 = (function (){
var statearr_24585 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24585[(0)] = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__);

(statearr_24585[(1)] = (1));

return statearr_24585;
});
var fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1 = (function (state_24569){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_24569);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e24586){var ex__2730__auto__ = e24586;
var statearr_24587_24600 = state_24569;
(statearr_24587_24600[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_24569[(4)]))){
var statearr_24588_24601 = state_24569;
(statearr_24588_24601[(1)] = cljs.core.first((state_24569[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24602 = state_24569;
state_24569 = G__24602;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__ = function(state_24569){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1.call(this,state_24569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____0;
fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto____1;
return fluree$db$query$subject_crawl$core$relationship_binding_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_24589 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_24589[(6)] = c__2749__auto__);

return statearr_24589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * After results are processed, the response may be modified if:
 *   - order-by exists, in which case we need to perform a sort
 *   - selectOne? exists, in which case we take the (first result)
 *   - pretty-print is true, in which case each result needs to get embedded in a map
 */
fluree.db.query.subject_crawl.core.build_finishing_fn = (function fluree$db$query$subject_crawl$core$build_finishing_fn(p__24604){
var map__24605 = p__24604;
var map__24605__$1 = cljs.core.__destructure_map(map__24605);
var parsed_query = map__24605__$1;
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var pretty_print = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24605__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var fns = (function (){var G__24606 = cljs.core.PersistentVector.EMPTY;
var G__24606__$1 = (cljs.core.truth_(selectOne_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24606,(function (result){
return cljs.core.first(result);
})):G__24606);
var G__24606__$2 = (cljs.core.truth_(pretty_print)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24606__$1,(function (){var select_var = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(parsed_query))))),(1));
return (function (result){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__24603_SHARP_){
return cljs.core.PersistentArrayMap.createAsIfByAssoc([select_var,p1__24603_SHARP_]);
}),result);
});
})()):G__24606__$1);
if(cljs.core.truth_(order_by)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__24606__$2,(function (result){
return fluree.db.query.subject_crawl.common.order_results(result,order_by,limit);
}));
} else {
return G__24606__$2;
}
})();
if(cljs.core.empty_QMARK_(fns)){
return cljs.core.identity;
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,fns);
}
});
/**
 * Executes a simple subject crawl analytical query execution strategy.
 * 
 *   Strategy involves:
 *   (a) Get a list of subjects from first where clause
 *   (b) select all flakes for each subject
 *   (c) filter subjects based on subsequent where clause(s)
 *   (d) apply offset/limit for (c)
 *   (e) send result into :select graph crawl
 */
fluree.db.query.subject_crawl.core.simple_subject_crawl = (function fluree$db$query$subject_crawl$core$simple_subject_crawl(db,p__24607){
var map__24608 = p__24607;
var map__24608__$1 = cljs.core.__destructure_map(map__24608);
var parsed_query = map__24608__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var fuel = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485));
var rel_binding_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"rel-binding?","rel-binding?",1563806094));
var order_by = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24608__$1,new cljs.core.Keyword(null,"order-by","order-by",1527318070));
var error_ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var f_where = cljs.core.first(where);
var rdf_type_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("rdf","type","rdf/type",1175423232),new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where));
var filter_map = new cljs.core.Keyword(null,"s-filter","s-filter",-1111214020).cljs$core$IFn$_invoke$arity$1(cljs.core.second(where));
var cache = cljs.core.volatile_BANG_(cljs.core.PersistentArrayMap.EMPTY);
var fuel_vol = cljs.core.volatile_BANG_((0));
var select_spec = fluree.db.query.subject_crawl.core.retrieve_select_spec(db,parsed_query);
var finish_fn = fluree.db.query.subject_crawl.core.build_finishing_fn(parsed_query);
var opts = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"f-where","f-where",-958007776),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"select-spec","select-spec",55073283),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736),new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803),new cljs.core.Keyword(null,"rdf-type?","rdf-type?",942727441),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142),new cljs.core.Keyword(null,"query","query",-1288509510),new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"filter-map","filter-map",-314788257)],[f_where,(3),select_spec,(cljs.core.truth_(order_by)?(9007199254740991):limit),offset,db,error_ch,cljs.core.not(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"root?","root?",-2045639518)], null))),rdf_type_QMARK_,cache,fuel,fuel_vol,parsed_query,finish_fn,vars,filter_map]);
if(cljs.core.truth_(rel_binding_QMARK_)){
return fluree.db.query.subject_crawl.core.relationship_binding(opts);
} else {
if(rdf_type_QMARK_){
return fluree.db.query.subject_crawl.rdf_type.rdf_type_crawl(opts);
} else {
return fluree.db.query.subject_crawl.subject.subj_crawl(opts);
}
}
});
