// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.http_signatures');
goog.require('cljs.core');
goog.require('fluree.crypto');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
/**
 * keys must include:
 *   method - post, get, etc. - used for (request-target) which is required
 *   path - path of the request
 *   
 */
fluree.db.query.http_signatures.generate_signing_string = (function fluree$db$query$http_signatures$generate_signing_string(val_map,ks){
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["(request-target)",null], null), null),ks);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["mydate",null,"x-fluree-date",null,"date",null], null), null),ks);
} else {
return and__5043__auto__;
}
})())){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["A valid http-signature must sign at least (request-target), date (or x-fluree-date), ","and digest if the request has a body. You requested a signature based on: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ks], 0)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)], null));
}

var get_or_throw = (function (m,k){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Signing string component ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," is not present."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)], null));
}
});
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("(request-target)",k)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,["(request-target): ",clojure.string.lower_case(cljs.core.name(get_or_throw(val_map,"method")))," ",clojure.string.lower_case(get_or_throw(val_map,"path"))].join(''));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(get_or_throw(val_map,k))].join(''));
}
}),cljs.core.PersistentVector.EMPTY,ks));
});
fluree.db.query.http_signatures.verify_signature_header_STAR_ = (function fluree$db$query$http_signatures$verify_signature_header_STAR_(req,sig_header_str){
var map__67133 = req;
var map__67133__$1 = cljs.core.__destructure_map(map__67133);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67133__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67133__$1,new cljs.core.Keyword(null,"uri","uri",-774711847));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67133__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var sig_map = (function (){try{return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__67132_SHARP_){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.replace(p1__67132_SHARP_,/\"/,""),/=/);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(sig_header_str,/\",/)));
}catch (e67134){var _ = e67134;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid Signature header. Ensure you have ","key1=value1,key2=value2 format and all string ","values are inside double-quotes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)], null));
}})();
var sig_parts = clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(sig_map,"headers",""),/ /);
var sign_string = fluree.db.query.http_signatures.generate_signing_string(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(headers,"method",request_method,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["path",uri], 0)),sig_parts);
var signature = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sig_map,"signature");
var authority = fluree.crypto.account_id_from_message(sign_string,signature);
var key_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sig_map,"keyId");
var auth = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("na",key_id))?null:key_id);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Verifying signature. Sign string:",sign_string,"Signature:",signature,"Account Id:",authority], null));

return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"auth","auth",1389754926),(function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return authority;
}
})(),new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"http-signature","http-signature",993976719),new cljs.core.Keyword(null,"signed","signed",305517343),sign_string,new cljs.core.Keyword(null,"signature","signature",1463754794),signature], null);
});
/**
 * Verifies signed http request. If signature header does not exist,
 *   returns nil. If it exists and is valid, returns the authid associated
 *   with it. If it exists and is invalid, throws exception.
 */
fluree.db.query.http_signatures.verify_signature_header = (function fluree$db$query$http_signatures$verify_signature_header(req){
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(req),"signature");
if(cljs.core.truth_(temp__5804__auto__)){
var sig_header_str = temp__5804__auto__;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Verifying http signature header:",sig_header_str], null));

return fluree.db.query.http_signatures.verify_signature_header_STAR_(req,sig_header_str);
} else {
return null;
}
});
/**
 * If a message digest is present, verifies it.
 */
fluree.db.query.http_signatures.verify_digest = (function fluree$db$query$http_signatures$verify_digest(req){
var digest = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"digest"], null));
if(cljs.core.truth_((function (){var and__5043__auto__ = digest;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(digest,"null");
} else {
return and__5043__auto__;
}
})())){
var vec__67135 = cljs.core.re_find(/^([^=]+)=(.+)$/,digest);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67135,(0),null);
var hash_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67135,(1),null);
var hash = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67135,(2),null);
var ___$1 = (cljs.core.truth_((function (){var fexpr__67138 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["SHA-256",null], null), null);
return (fexpr__67138.cljs$core$IFn$_invoke$arity$1 ? fexpr__67138.cljs$core$IFn$_invoke$arity$1(hash_type) : fexpr__67138.call(null,hash_type));
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Digest type of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hash_type)," is not supported."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)], null))})());
var body = new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(req);
var body__$1 = (((((body == null)) || (typeof body === 'string')))?body:fluree.db.util.json.stringify(body));
var ___$2 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["verify-digest request body:",body__$1], null));
var calc_digest = (function (){var G__67139 = hash_type;
switch (G__67139) {
case "SHA-256":
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2(body__$1,new cljs.core.Keyword(null,"base64","base64",167760174));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67139)].join('')));

}
})();
var ___$3 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["request digest:",hash,"computed digest:",calc_digest], null));
var valid_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hash,calc_digest);
if((!(valid_QMARK_))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid digest.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)], null));
} else {
return req;
}
} else {
return req;
}
});
/**
 * Signs http request by creating required headers and using supplied private key.
 *   req-type should be :get, :post, etc.
 */
fluree.db.query.http_signatures.sign_request = (function fluree$db$query$http_signatures$sign_request(var_args){
var G__67142 = arguments.length;
switch (G__67142) {
case 4:
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,null);
}));

(fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var map__67143 = request;
var map__67143__$1 = cljs.core.__destructure_map(map__67143);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67143__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67143__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var path = (function (){var match = cljs.core.re_find(/^(https?\:)\/\/(([^:\/?#]*)(?:\:([0-9]+))?)([\/]{0,1}[^?#]*)$/,url);
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(match,(5));
})();
var date = (function (){var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(headers,"date");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (new Date()).toUTCString();
}
})();
var digest = (cljs.core.truth_(body)?["SHA-256=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2(body,new cljs.core.Keyword(null,"base64","base64",167760174)))].join(''):null);
var sign_headers = (cljs.core.truth_(body)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(request-target)","x-fluree-date","digest"], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(request-target)","x-fluree-date"], null));
var sign_vals = (cljs.core.truth_(body)?new cljs.core.PersistentArrayMap(null, 4, ["x-fluree-date",date,"digest",digest,"method",req_method,"path",path], null):new cljs.core.PersistentArrayMap(null, 3, ["x-fluree-date",date,"method",req_method,"path",path], null));
var signing_string = fluree.db.query.http_signatures.generate_signing_string(sign_vals,sign_headers);
var sign_headers_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",sign_headers);
var sig = fluree.crypto.sign_message(signing_string,private_key);
var auth__$1 = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "na";
}
})();
var sig_header = ["keyId=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth__$1),"\",headers=\"",sign_headers_str,"\",algorithm=\"ecdsa-sha256\",signature=\"",sig,"\",date=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(date),"\""].join('');
var headers_STAR_ = fluree.db.util.core.without_nils(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([headers,new cljs.core.PersistentArrayMap(null, 3, ["Digest",digest,"X-Fluree-Date",date,"Signature",sig_header], null)], 0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_STAR_);
}));

(fluree.db.query.http_signatures.sign_request.cljs$lang$maxFixedArity = 5);

/**
 * Returns auth record from separated request parts.
 */
fluree.db.query.http_signatures.verify_request_STAR_ = (function fluree$db$query$http_signatures$verify_request_STAR_(var_args){
var G__67146 = arguments.length;
switch (G__67146) {
case 4:
return fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (req,method,action,db_name){
return fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$3(req,method,["/fdb/",fluree.db.util.core.keyword__GT_str(db_name),"/",fluree.db.util.core.keyword__GT_str(action)].join(''));
}));

(fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (req,method,uri){
return fluree.db.query.http_signatures.verify_signature_header(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(fluree.db.query.http_signatures.verify_digest(req),new cljs.core.Keyword(null,"request-method","request-method",1764796830),method,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"uri","uri",-774711847),uri], 0)));
}));

(fluree.db.query.http_signatures.verify_request_STAR_.cljs$lang$maxFixedArity = 4);

/**
 * Returns map of auth and authority from request.
 */
fluree.db.query.http_signatures.verify_request = (function fluree$db$query$http_signatures$verify_request(request){
return fluree.db.query.http_signatures.verify_signature_header(fluree.db.query.http_signatures.verify_digest(request));
});
