// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql_resp');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.analytical_parse');
/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql_resp.vswap_BANG_ = (function fluree$db$query$fql_resp$vswap_BANG_(var_args){
var G__21906 = arguments.length;
switch (G__21906) {
case 2:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__21907 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__21907) : f.call(null,G__21907));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__21908 = cljs.core._deref(vol);
var G__21909 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__21908,G__21909) : f.call(null,G__21908,G__21909));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__21910 = cljs.core._deref(vol);
var G__21911 = arg1;
var G__21912 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__21910,G__21911,G__21912) : f.call(null,G__21910,G__21911,G__21912));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__21913 = cljs.core._deref(vol);
var G__21914 = arg1;
var G__21915 = arg2;
var G__21916 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__21913,G__21914,G__21915,G__21916) : f.call(null,G__21913,G__21914,G__21915,G__21916));
})());
}));

(fluree.db.query.fql_resp.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql_resp.has_ns_lookups_QMARK_ = (function fluree$db$query$fql_resp$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql_resp.full_select_spec = (function fluree$db$query$fql_resp$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql_resp$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql_resp.add_fuel = (function fluree$db$query$fql_resp$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql_resp.resolve_reverse_refs = (function fluree$db$query$fql_resp$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22077){
var state_val_22078 = (state_22077[(1)]);
if((state_val_22078 === (7))){
var inst_22072 = (state_22077[(2)]);
var _ = (function (){var statearr_22079 = state_22077;
(statearr_22079[(4)] = cljs.core.rest((state_22077[(4)])));

return statearr_22079;
})();
var state_22077__$1 = state_22077;
var statearr_22080_22162 = state_22077__$1;
(statearr_22080_22162[(2)] = inst_22072);

(statearr_22080_22162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (20))){
var inst_21999 = (state_22077[(7)]);
var state_22077__$1 = state_22077;
var statearr_22081_22163 = state_22077__$1;
(statearr_22081_22163[(2)] = inst_21999);

(statearr_22081_22163[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (27))){
var inst_21954 = (state_22077[(8)]);
var state_22077__$1 = state_22077;
if(cljs.core.truth_(inst_21954)){
var statearr_22082_22164 = state_22077__$1;
(statearr_22082_22164[(1)] = (29));

} else {
var statearr_22083_22165 = state_22077__$1;
(statearr_22083_22165[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (1))){
var state_22077__$1 = state_22077;
var statearr_22084_22166 = state_22077__$1;
(statearr_22084_22166[(2)] = null);

(statearr_22084_22166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (24))){
var inst_21955 = (state_22077[(9)]);
var state_22077__$1 = state_22077;
var statearr_22085_22167 = state_22077__$1;
(statearr_22085_22167[(2)] = inst_21955);

(statearr_22085_22167[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (39))){
var inst_21991 = (state_22077[(10)]);
var state_22077__$1 = state_22077;
var statearr_22086_22168 = state_22077__$1;
(statearr_22086_22168[(2)] = inst_21991);

(statearr_22086_22168[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (46))){
var inst_21956 = (state_22077[(11)]);
var state_22077__$1 = state_22077;
var statearr_22087_22169 = state_22077__$1;
(statearr_22087_22169[(2)] = inst_21956);

(statearr_22087_22169[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (4))){
var inst_21918 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22088_22170 = state_22077__$1;
(statearr_22088_22170[(2)] = inst_21918);

(statearr_22088_22170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (15))){
var inst_21967 = (state_22077[(12)]);
var inst_21973 = cljs.core.count(inst_21967);
var inst_21974 = fluree.db.query.fql_resp.add_fuel(fuel,inst_21973,max_fuel);
var state_22077__$1 = state_22077;
var statearr_22089_22171 = state_22077__$1;
(statearr_22089_22171[(2)] = inst_21974);

(statearr_22089_22171[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (48))){
var inst_21936 = (state_22077[(13)]);
var inst_22058 = (state_22077[(14)]);
var inst_21943 = (state_22077[(15)]);
var inst_22066 = (state_22077[(2)]);
var inst_22067 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_21936,inst_22066,inst_22058);
var inst_21935 = inst_21943;
var inst_21936__$1 = inst_22067;
var state_22077__$1 = (function (){var statearr_22090 = state_22077;
(statearr_22090[(13)] = inst_21936__$1);

(statearr_22090[(16)] = inst_21935);

return statearr_22090;
})();
var statearr_22091_22172 = state_22077__$1;
(statearr_22091_22172[(2)] = null);

(statearr_22091_22172[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (50))){
var inst_21958 = (state_22077[(17)]);
var state_22077__$1 = state_22077;
var statearr_22092_22173 = state_22077__$1;
(statearr_22092_22173[(2)] = inst_21958);

(statearr_22092_22173[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (21))){
var inst_21955 = (state_22077[(9)]);
var state_22077__$1 = state_22077;
if(cljs.core.truth_(inst_21955)){
var statearr_22094_22174 = state_22077__$1;
(statearr_22094_22174[(1)] = (23));

} else {
var statearr_22095_22175 = state_22077__$1;
(statearr_22095_22175[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (31))){
var inst_22015 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
if(cljs.core.truth_(inst_22015)){
var statearr_22096_22176 = state_22077__$1;
(statearr_22096_22176[(1)] = (32));

} else {
var statearr_22097_22177 = state_22077__$1;
(statearr_22097_22177[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (32))){
var inst_21990 = (state_22077[(18)]);
var inst_21998 = (state_22077[(19)]);
var inst_21991 = (state_22077[(10)]);
var inst_22017 = (inst_21990 + (1));
var tmp22093 = inst_21991;
var inst_21989 = inst_21998;
var inst_21990__$1 = inst_22017;
var inst_21991__$1 = tmp22093;
var state_22077__$1 = (function (){var statearr_22098 = state_22077;
(statearr_22098[(20)] = inst_21989);

(statearr_22098[(18)] = inst_21990__$1);

(statearr_22098[(10)] = inst_21991__$1);

return statearr_22098;
})();
var statearr_22099_22178 = state_22077__$1;
(statearr_22099_22178[(2)] = null);

(statearr_22099_22178[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (40))){
var state_22077__$1 = state_22077;
if(cljs.core.truth_(fuel)){
var statearr_22100_22179 = state_22077__$1;
(statearr_22100_22179[(1)] = (42));

} else {
var statearr_22101_22180 = state_22077__$1;
(statearr_22101_22180[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (33))){
var state_22077__$1 = state_22077;
var statearr_22102_22181 = state_22077__$1;
(statearr_22102_22181[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (13))){
var inst_21967 = (state_22077[(12)]);
var state_22077__$1 = state_22077;
var statearr_22104_22182 = state_22077__$1;
(statearr_22104_22182[(2)] = inst_21967);

(statearr_22104_22182[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (22))){
var inst_22008 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
if(cljs.core.truth_(inst_22008)){
var statearr_22105_22183 = state_22077__$1;
(statearr_22105_22183[(1)] = (26));

} else {
var statearr_22106_22184 = state_22077__$1;
(statearr_22106_22184[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (36))){
var state_22077__$1 = state_22077;
var statearr_22107_22185 = state_22077__$1;
(statearr_22107_22185[(2)] = null);

(statearr_22107_22185[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (41))){
var inst_21990 = (state_22077[(18)]);
var inst_21998 = (state_22077[(19)]);
var inst_22047 = (state_22077[(2)]);
var inst_22048 = (inst_21990 + (1));
var inst_21989 = inst_21998;
var inst_21990__$1 = inst_22048;
var inst_21991 = inst_22047;
var state_22077__$1 = (function (){var statearr_22108 = state_22077;
(statearr_22108[(20)] = inst_21989);

(statearr_22108[(18)] = inst_21990__$1);

(statearr_22108[(10)] = inst_21991);

return statearr_22108;
})();
var statearr_22109_22186 = state_22077__$1;
(statearr_22109_22186[(2)] = null);

(statearr_22109_22186[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (43))){
var state_22077__$1 = state_22077;
var statearr_22110_22187 = state_22077__$1;
(statearr_22110_22187[(2)] = null);

(statearr_22110_22187[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (29))){
var inst_21990 = (state_22077[(18)]);
var inst_21954 = (state_22077[(8)]);
var inst_22012 = (inst_21990 < inst_21954);
var state_22077__$1 = state_22077;
var statearr_22111_22188 = state_22077__$1;
(statearr_22111_22188[(2)] = inst_22012);

(statearr_22111_22188[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (44))){
var inst_22027 = (state_22077[(21)]);
var inst_22031 = (state_22077[(22)]);
var inst_22040 = (state_22077[(2)]);
var inst_22041 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22031,inst_22027) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22031,inst_22027));
var state_22077__$1 = (function (){var statearr_22112 = state_22077;
(statearr_22112[(23)] = inst_22040);

return statearr_22112;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22077__$1,(45),inst_22041);
} else {
if((state_val_22078 === (6))){
var inst_21935 = (state_22077[(16)]);
var inst_21942 = (state_22077[(24)]);
var inst_21941 = cljs.core.seq(inst_21935);
var inst_21942__$1 = cljs.core.first(inst_21941);
var inst_21943 = cljs.core.next(inst_21941);
var inst_21944 = cljs.core.not(inst_21942__$1);
var state_22077__$1 = (function (){var statearr_22113 = state_22077;
(statearr_22113[(15)] = inst_21943);

(statearr_22113[(24)] = inst_21942__$1);

return statearr_22113;
})();
if(inst_21944){
var statearr_22114_22189 = state_22077__$1;
(statearr_22114_22189[(1)] = (8));

} else {
var statearr_22115_22190 = state_22077__$1;
(statearr_22115_22190[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (28))){
var inst_22056 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22116_22191 = state_22077__$1;
(statearr_22116_22191[(2)] = inst_22056);

(statearr_22116_22191[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (51))){
var inst_22064 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22117_22192 = state_22077__$1;
(statearr_22117_22192[(2)] = inst_22064);

(statearr_22117_22192[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (25))){
var inst_22006 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22118_22193 = state_22077__$1;
(statearr_22118_22193[(2)] = inst_22006);

(statearr_22118_22193[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (34))){
var inst_22054 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22119_22194 = state_22077__$1;
(statearr_22119_22194[(2)] = inst_22054);

(statearr_22119_22194[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (17))){
var inst_21967 = (state_22077[(12)]);
var inst_21977 = (state_22077[(2)]);
var inst_21985 = cljs.core.seq(inst_21967);
var inst_21986 = cljs.core.first(inst_21985);
var inst_21987 = cljs.core.next(inst_21985);
var inst_21988 = cljs.core.PersistentVector.EMPTY;
var inst_21989 = inst_21967;
var inst_21990 = (0);
var inst_21991 = inst_21988;
var state_22077__$1 = (function (){var statearr_22120 = state_22077;
(statearr_22120[(20)] = inst_21989);

(statearr_22120[(18)] = inst_21990);

(statearr_22120[(10)] = inst_21991);

(statearr_22120[(25)] = inst_21986);

(statearr_22120[(26)] = inst_21987);

(statearr_22120[(27)] = inst_21977);

return statearr_22120;
})();
var statearr_22121_22195 = state_22077__$1;
(statearr_22121_22195[(2)] = null);

(statearr_22121_22195[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (3))){
var inst_22075 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22077__$1,inst_22075);
} else {
if((state_val_22078 === (12))){
var state_22077__$1 = state_22077;
var statearr_22122_22196 = state_22077__$1;
(statearr_22122_22196[(2)] = fuel);

(statearr_22122_22196[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (2))){
var _ = (function (){var statearr_22123 = state_22077;
(statearr_22123[(4)] = cljs.core.cons((5),(state_22077[(4)])));

return statearr_22123;
})();
var inst_21931 = reverse_refs_specs;
var inst_21932 = cljs.core.seq(inst_21931);
var inst_21933 = cljs.core.first(inst_21932);
var inst_21934 = cljs.core.next(inst_21932);
var inst_21935 = inst_21931;
var inst_21936 = null;
var state_22077__$1 = (function (){var statearr_22124 = state_22077;
(statearr_22124[(28)] = inst_21934);

(statearr_22124[(13)] = inst_21936);

(statearr_22124[(29)] = inst_21933);

(statearr_22124[(16)] = inst_21935);

return statearr_22124;
})();
var statearr_22125_22197 = state_22077__$1;
(statearr_22125_22197[(2)] = null);

(statearr_22125_22197[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (23))){
var inst_21990 = (state_22077[(18)]);
var inst_21955 = (state_22077[(9)]);
var inst_22003 = (inst_21990 >= inst_21955);
var state_22077__$1 = state_22077;
var statearr_22126_22198 = state_22077__$1;
(statearr_22126_22198[(2)] = inst_22003);

(statearr_22126_22198[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (47))){
var inst_21957 = (state_22077[(30)]);
var state_22077__$1 = state_22077;
if(cljs.core.truth_(inst_21957)){
var statearr_22127_22199 = state_22077__$1;
(statearr_22127_22199[(1)] = (49));

} else {
var statearr_22128_22200 = state_22077__$1;
(statearr_22128_22200[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (35))){
var inst_21997 = (state_22077[(31)]);
var inst_22021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22022 = [inst_21997];
var inst_22023 = (new cljs.core.PersistentVector(null,1,(5),inst_22021,inst_22022,null));
var inst_22024 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22023);
var state_22077__$1 = state_22077;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22077__$1,(38),inst_22024);
} else {
if((state_val_22078 === (19))){
var inst_21956 = (state_22077[(11)]);
var inst_22058 = (state_22077[(2)]);
var state_22077__$1 = (function (){var statearr_22129 = state_22077;
(statearr_22129[(14)] = inst_22058);

return statearr_22129;
})();
if(cljs.core.truth_(inst_21956)){
var statearr_22130_22201 = state_22077__$1;
(statearr_22130_22201[(1)] = (46));

} else {
var statearr_22131_22202 = state_22077__$1;
(statearr_22131_22202[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (11))){
var inst_21967 = (state_22077[(12)]);
var inst_21964 = (state_22077[(2)]);
var inst_21965 = fluree.db.util.async.throw_err(inst_21964);
var inst_21966 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.s,inst_21965);
var inst_21967__$1 = cljs.core.not_empty(inst_21966);
var state_22077__$1 = (function (){var statearr_22133 = state_22077;
(statearr_22133[(12)] = inst_21967__$1);

return statearr_22133;
})();
if(cljs.core.truth_(inst_21967__$1)){
var statearr_22134_22203 = state_22077__$1;
(statearr_22134_22203[(1)] = (12));

} else {
var statearr_22135_22204 = state_22077__$1;
(statearr_22135_22204[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (9))){
var inst_21952 = (state_22077[(32)]);
var inst_21942 = (state_22077[(24)]);
var inst_21951 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21942,(0),null);
var inst_21952__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21942,(1),null);
var inst_21953 = cljs.core.__destructure_map(inst_21952__$1);
var inst_21954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21953,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_21955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21953,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_21956 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21953,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_21957 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21953,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_21958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21953,new cljs.core.Keyword(null,"p","p",151049309));
var inst_21959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21960 = [subject_id,inst_21951];
var inst_21961 = (new cljs.core.PersistentVector(null,2,(5),inst_21959,inst_21960,null));
var inst_21962 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_21961);
var state_22077__$1 = (function (){var statearr_22136 = state_22077;
(statearr_22136[(32)] = inst_21952__$1);

(statearr_22136[(17)] = inst_21958);

(statearr_22136[(8)] = inst_21954);

(statearr_22136[(11)] = inst_21956);

(statearr_22136[(9)] = inst_21955);

(statearr_22136[(30)] = inst_21957);

return statearr_22136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22077__$1,(11),inst_21962);
} else {
if((state_val_22078 === (5))){
var _ = (function (){var statearr_22137 = state_22077;
(statearr_22137[(4)] = cljs.core.rest((state_22077[(4)])));

return statearr_22137;
})();
var state_22077__$1 = state_22077;
var ex22132 = (state_22077__$1[(2)]);
var statearr_22138_22205 = state_22077__$1;
(statearr_22138_22205[(5)] = ex22132);


if((ex22132 instanceof Error)){
var statearr_22139_22206 = state_22077__$1;
(statearr_22139_22206[(1)] = (4));

(statearr_22139_22206[(5)] = null);

} else {
throw ex22132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (14))){
var inst_21971 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
if(cljs.core.truth_(inst_21971)){
var statearr_22140_22207 = state_22077__$1;
(statearr_22140_22207[(1)] = (15));

} else {
var statearr_22141_22208 = state_22077__$1;
(statearr_22141_22208[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (45))){
var inst_21991 = (state_22077[(10)]);
var inst_22043 = (state_22077[(2)]);
var inst_22044 = fluree.db.util.async.throw_err(inst_22043);
var inst_22045 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_21991,inst_22044);
var state_22077__$1 = state_22077;
var statearr_22142_22209 = state_22077__$1;
(statearr_22142_22209[(2)] = inst_22045);

(statearr_22142_22209[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (26))){
var inst_21991 = (state_22077[(10)]);
var state_22077__$1 = state_22077;
var statearr_22143_22210 = state_22077__$1;
(statearr_22143_22210[(2)] = inst_21991);

(statearr_22143_22210[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (16))){
var state_22077__$1 = state_22077;
var statearr_22144_22211 = state_22077__$1;
(statearr_22144_22211[(2)] = null);

(statearr_22144_22211[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (38))){
var inst_21952 = (state_22077[(32)]);
var inst_22027 = (state_22077[(21)]);
var inst_22026 = (state_22077[(2)]);
var inst_22027__$1 = fluree.db.util.async.throw_err(inst_22026);
var inst_22028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22029 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22030 = (new cljs.core.PersistentVector(null,4,(5),inst_22028,inst_22029,null));
var inst_22031 = cljs.core.select_keys(inst_21952,inst_22030);
var inst_22032 = cljs.core.empty_QMARK_(inst_22027__$1);
var state_22077__$1 = (function (){var statearr_22145 = state_22077;
(statearr_22145[(21)] = inst_22027__$1);

(statearr_22145[(22)] = inst_22031);

return statearr_22145;
})();
if(inst_22032){
var statearr_22146_22212 = state_22077__$1;
(statearr_22146_22212[(1)] = (39));

} else {
var statearr_22147_22213 = state_22077__$1;
(statearr_22147_22213[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (30))){
var inst_21954 = (state_22077[(8)]);
var state_22077__$1 = state_22077;
var statearr_22148_22214 = state_22077__$1;
(statearr_22148_22214[(2)] = inst_21954);

(statearr_22148_22214[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (10))){
var inst_22070 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22149_22215 = state_22077__$1;
(statearr_22149_22215[(2)] = inst_22070);

(statearr_22149_22215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (18))){
var inst_21989 = (state_22077[(20)]);
var inst_21999 = (state_22077[(7)]);
var inst_21997 = (state_22077[(31)]);
var inst_21996 = cljs.core.seq(inst_21989);
var inst_21997__$1 = cljs.core.first(inst_21996);
var inst_21998 = cljs.core.next(inst_21996);
var inst_21999__$1 = cljs.core.not(inst_21997__$1);
var state_22077__$1 = (function (){var statearr_22150 = state_22077;
(statearr_22150[(19)] = inst_21998);

(statearr_22150[(7)] = inst_21999__$1);

(statearr_22150[(31)] = inst_21997__$1);

return statearr_22150;
})();
if(inst_21999__$1){
var statearr_22151_22216 = state_22077__$1;
(statearr_22151_22216[(1)] = (20));

} else {
var statearr_22152_22217 = state_22077__$1;
(statearr_22152_22217[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (42))){
var inst_22027 = (state_22077[(21)]);
var inst_22036 = cljs.core.count(inst_22027);
var inst_22037 = fluree.db.query.fql_resp.add_fuel(fuel,inst_22036,max_fuel);
var state_22077__$1 = state_22077;
var statearr_22153_22218 = state_22077__$1;
(statearr_22153_22218[(2)] = inst_22037);

(statearr_22153_22218[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (37))){
var inst_22052 = (state_22077[(2)]);
var state_22077__$1 = state_22077;
var statearr_22154_22219 = state_22077__$1;
(statearr_22154_22219[(2)] = inst_22052);

(statearr_22154_22219[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (8))){
var inst_21936 = (state_22077[(13)]);
var state_22077__$1 = state_22077;
var statearr_22155_22220 = state_22077__$1;
(statearr_22155_22220[(2)] = inst_21936);

(statearr_22155_22220[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22078 === (49))){
var inst_21957 = (state_22077[(30)]);
var state_22077__$1 = state_22077;
var statearr_22156_22221 = state_22077__$1;
(statearr_22156_22221[(2)] = inst_21957);

(statearr_22156_22221[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0 = (function (){
var statearr_22157 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22157[(0)] = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__);

(statearr_22157[(1)] = (1));

return statearr_22157;
});
var fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1 = (function (state_22077){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22077);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22158){var ex__2730__auto__ = e22158;
var statearr_22159_22222 = state_22077;
(statearr_22159_22222[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22077[(4)]))){
var statearr_22160_22223 = state_22077;
(statearr_22160_22223[(1)] = cljs.core.first((state_22077[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22224 = state_22077;
state_22077 = G__22224;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__ = function(state_22077){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1.call(this,state_22077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$resolve_reverse_refs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22161 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22161[(6)] = c__2749__auto__);

return statearr_22161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.fql_resp.component_follow_QMARK_ = (function fluree$db$query$fql_resp$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql_resp.fuel_flake_transducer = (function fluree$db$query$fql_resp$fuel_flake_transducer(var_args){
var G__22226 = arguments.length;
switch (G__22226) {
case 2:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22228 = null;
var G__22228__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22228__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22228__2 = (function (result,flake){
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22228 = function(result,flake){
switch(arguments.length){
case 0:
return G__22228__0.call(this);
case 1:
return G__22228__1.call(this,result);
case 2:
return G__22228__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22228.cljs$core$IFn$_invoke$arity$0 = G__22228__0;
G__22228.cljs$core$IFn$_invoke$arity$1 = G__22228__1;
G__22228.cljs$core$IFn$_invoke$arity$2 = G__22228__2;
return G__22228;
})()
});
}));

(fluree.db.query.fql_resp.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql_resp.recur_select_spec = (function fluree$db$query$fql_resp$recur_select_spec(select_spec,flake){
var recur_subject = fluree.db.flake.o(flake);
var recur_pred = fluree.db.flake.p(flake);
var map__22229 = select_spec;
var map__22229__$1 = cljs.core.__destructure_map(map__22229);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22229__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22229__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.flake__GT_recur = (function fluree$db$query$fql_resp$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22343){
var state_val_22344 = (state_22343[(1)]);
if((state_val_22344 === (7))){
var inst_22255 = flakes;
var inst_22256 = cljs.core.seq(inst_22255);
var inst_22257 = cljs.core.first(inst_22256);
var inst_22258 = cljs.core.next(inst_22256);
var inst_22259 = cljs.core.PersistentVector.EMPTY;
var inst_22260 = inst_22255;
var inst_22261 = (0);
var inst_22262 = inst_22259;
var state_22343__$1 = (function (){var statearr_22345 = state_22343;
(statearr_22345[(7)] = inst_22261);

(statearr_22345[(8)] = inst_22260);

(statearr_22345[(9)] = inst_22258);

(statearr_22345[(10)] = inst_22262);

(statearr_22345[(11)] = inst_22257);

return statearr_22345;
})();
var statearr_22346_22412 = state_22343__$1;
(statearr_22346_22412[(2)] = null);

(statearr_22346_22412[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (20))){
var state_22343__$1 = state_22343;
var statearr_22347_22413 = state_22343__$1;
(statearr_22347_22413[(2)] = results);

(statearr_22347_22413[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (27))){
var state_22343__$1 = state_22343;
var statearr_22348_22414 = state_22343__$1;
(statearr_22348_22414[(2)] = null);

(statearr_22348_22414[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (1))){
var state_22343__$1 = state_22343;
var statearr_22349_22415 = state_22343__$1;
(statearr_22349_22415[(2)] = null);

(statearr_22349_22415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (24))){
var state_22343__$1 = state_22343;
var statearr_22350_22416 = state_22343__$1;
(statearr_22350_22416[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (39))){
var inst_22269 = (state_22343[(12)]);
var inst_22324 = (state_22343[(13)]);
var inst_22262 = (state_22343[(10)]);
var inst_22327 = (state_22343[(2)]);
var inst_22328 = fluree.db.util.async.throw_err(inst_22327);
var inst_22329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22262,inst_22328);
var inst_22260 = inst_22269;
var inst_22261 = inst_22324;
var inst_22262__$1 = inst_22329;
var state_22343__$1 = (function (){var statearr_22352 = state_22343;
(statearr_22352[(7)] = inst_22261);

(statearr_22352[(8)] = inst_22260);

(statearr_22352[(10)] = inst_22262__$1);

return statearr_22352;
})();
var statearr_22353_22417 = state_22343__$1;
(statearr_22353_22417[(2)] = null);

(statearr_22353_22417[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (4))){
var inst_22230 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22354_22418 = state_22343__$1;
(statearr_22354_22418[(2)] = inst_22230);

(statearr_22354_22418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (15))){
var inst_22243 = (state_22343[(14)]);
var state_22343__$1 = state_22343;
var statearr_22355_22419 = state_22343__$1;
(statearr_22355_22419[(2)] = inst_22243);

(statearr_22355_22419[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (21))){
var inst_22239 = (state_22343[(15)]);
var state_22343__$1 = state_22343;
if(cljs.core.truth_(inst_22239)){
var statearr_22356_22420 = state_22343__$1;
(statearr_22356_22420[(1)] = (23));

} else {
var statearr_22357_22421 = state_22343__$1;
(statearr_22357_22421[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (31))){
var inst_22307 = (state_22343[(16)]);
var state_22343__$1 = state_22343;
var statearr_22358_22422 = state_22343__$1;
(statearr_22358_22422[(2)] = inst_22307);

(statearr_22358_22422[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (32))){
var inst_22299 = (state_22343[(17)]);
var inst_22313 = (state_22343[(2)]);
var state_22343__$1 = (function (){var statearr_22359 = state_22343;
(statearr_22359[(18)] = inst_22313);

return statearr_22359;
})();
if(cljs.core.truth_(inst_22299)){
var statearr_22360_22423 = state_22343__$1;
(statearr_22360_22423[(1)] = (33));

} else {
var statearr_22361_22424 = state_22343__$1;
(statearr_22361_22424[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (33))){
var inst_22299 = (state_22343[(17)]);
var state_22343__$1 = state_22343;
var statearr_22362_22425 = state_22343__$1;
(statearr_22362_22425[(2)] = inst_22299);

(statearr_22362_22425[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (13))){
var inst_22279 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
if(cljs.core.truth_(inst_22279)){
var statearr_22364_22426 = state_22343__$1;
(statearr_22364_22426[(1)] = (17));

} else {
var statearr_22365_22427 = state_22343__$1;
(statearr_22365_22427[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (22))){
var inst_22296 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22366_22428 = state_22343__$1;
(statearr_22366_22428[(2)] = inst_22296);

(statearr_22366_22428[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (36))){
var inst_22261 = (state_22343[(7)]);
var inst_22269 = (state_22343[(12)]);
var inst_22262 = (state_22343[(10)]);
var inst_22321 = (inst_22261 + (1));
var tmp22363 = inst_22262;
var inst_22260 = inst_22269;
var inst_22261__$1 = inst_22321;
var inst_22262__$1 = tmp22363;
var state_22343__$1 = (function (){var statearr_22367 = state_22343;
(statearr_22367[(7)] = inst_22261__$1);

(statearr_22367[(8)] = inst_22260);

(statearr_22367[(10)] = inst_22262__$1);

return statearr_22367;
})();
var statearr_22368_22429 = state_22343__$1;
(statearr_22368_22429[(2)] = null);

(statearr_22368_22429[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (29))){
var inst_22306 = (state_22343[(2)]);
var inst_22307 = fluree.db.util.async.throw_err(inst_22306);
var state_22343__$1 = (function (){var statearr_22369 = state_22343;
(statearr_22369[(16)] = inst_22307);

return statearr_22369;
})();
if(cljs.core.truth_(fuel)){
var statearr_22370_22430 = state_22343__$1;
(statearr_22370_22430[(1)] = (30));

} else {
var statearr_22371_22431 = state_22343__$1;
(statearr_22371_22431[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (6))){
var state_22343__$1 = state_22343;
var statearr_22372_22432 = state_22343__$1;
(statearr_22372_22432[(2)] = results);

(statearr_22372_22432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (28))){
var inst_22292 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22373_22433 = state_22343__$1;
(statearr_22373_22433[(2)] = inst_22292);

(statearr_22373_22433[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (25))){
var inst_22294 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22374_22434 = state_22343__$1;
(statearr_22374_22434[(2)] = inst_22294);

(statearr_22374_22434[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (34))){
var inst_22313 = (state_22343[(18)]);
var inst_22316 = cljs.core.empty_QMARK_(inst_22313);
var state_22343__$1 = state_22343;
var statearr_22375_22435 = state_22343__$1;
(statearr_22375_22435[(2)] = inst_22316);

(statearr_22375_22435[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (17))){
var inst_22262 = (state_22343[(10)]);
var inst_22281 = cljs.core.empty_QMARK_(inst_22262);
var state_22343__$1 = state_22343;
if(inst_22281){
var statearr_22376_22436 = state_22343__$1;
(statearr_22376_22436[(1)] = (20));

} else {
var statearr_22377_22437 = state_22343__$1;
(statearr_22377_22437[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (3))){
var inst_22341 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22343__$1,inst_22341);
} else {
if((state_val_22344 === (12))){
var inst_22243 = (state_22343[(14)]);
var state_22343__$1 = state_22343;
if(cljs.core.truth_(inst_22243)){
var statearr_22378_22438 = state_22343__$1;
(statearr_22378_22438[(1)] = (14));

} else {
var statearr_22379_22439 = state_22343__$1;
(statearr_22379_22439[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (2))){
var _ = (function (){var statearr_22380 = state_22343;
(statearr_22380[(4)] = cljs.core.cons((5),(state_22343[(4)])));

return statearr_22380;
})();
var inst_22237 = select_spec;
var inst_22238 = cljs.core.__destructure_map(inst_22237);
var inst_22239 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22238,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22240 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22238,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22241 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22238,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22238,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22238,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22244 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_22245 = (inst_22242 > inst_22244);
var state_22343__$1 = (function (){var statearr_22381 = state_22343;
(statearr_22381[(15)] = inst_22239);

(statearr_22381[(19)] = inst_22240);

(statearr_22381[(14)] = inst_22243);

(statearr_22381[(20)] = inst_22241);

return statearr_22381;
})();
if(cljs.core.truth_(inst_22245)){
var statearr_22382_22440 = state_22343__$1;
(statearr_22382_22440[(1)] = (6));

} else {
var statearr_22383_22441 = state_22343__$1;
(statearr_22383_22441[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (23))){
var inst_22240 = (state_22343[(19)]);
var inst_22262 = (state_22343[(10)]);
var inst_22285 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_22240,inst_22262);
var state_22343__$1 = state_22343;
var statearr_22384_22442 = state_22343__$1;
(statearr_22384_22442[(2)] = inst_22285);

(statearr_22384_22442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (35))){
var inst_22268 = (state_22343[(21)]);
var inst_22318 = (state_22343[(2)]);
var inst_22319 = fluree.db.query.fql_resp.recur_select_spec(select_spec,inst_22268);
var state_22343__$1 = (function (){var statearr_22385 = state_22343;
(statearr_22385[(22)] = inst_22319);

return statearr_22385;
})();
if(cljs.core.truth_(inst_22318)){
var statearr_22386_22443 = state_22343__$1;
(statearr_22386_22443[(1)] = (36));

} else {
var statearr_22387_22444 = state_22343__$1;
(statearr_22387_22444[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (19))){
var inst_22334 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22388_22445 = state_22343__$1;
(statearr_22388_22445[(2)] = inst_22334);

(statearr_22388_22445[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (11))){
var inst_22270 = (state_22343[(23)]);
var state_22343__$1 = state_22343;
var statearr_22390_22446 = state_22343__$1;
(statearr_22390_22446[(2)] = inst_22270);

(statearr_22390_22446[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (9))){
var inst_22268 = (state_22343[(21)]);
var inst_22270 = (state_22343[(23)]);
var inst_22260 = (state_22343[(8)]);
var inst_22267 = cljs.core.seq(inst_22260);
var inst_22268__$1 = cljs.core.first(inst_22267);
var inst_22269 = cljs.core.next(inst_22267);
var inst_22270__$1 = cljs.core.not(inst_22268__$1);
var state_22343__$1 = (function (){var statearr_22391 = state_22343;
(statearr_22391[(21)] = inst_22268__$1);

(statearr_22391[(23)] = inst_22270__$1);

(statearr_22391[(12)] = inst_22269);

return statearr_22391;
})();
if(inst_22270__$1){
var statearr_22392_22447 = state_22343__$1;
(statearr_22392_22447[(1)] = (11));

} else {
var statearr_22393_22448 = state_22343__$1;
(statearr_22393_22448[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (5))){
var _ = (function (){var statearr_22394 = state_22343;
(statearr_22394[(4)] = cljs.core.rest((state_22343[(4)])));

return statearr_22394;
})();
var state_22343__$1 = state_22343;
var ex22389 = (state_22343__$1[(2)]);
var statearr_22395_22449 = state_22343__$1;
(statearr_22395_22449[(5)] = ex22389);


if((ex22389 instanceof Error)){
var statearr_22396_22450 = state_22343__$1;
(statearr_22396_22450[(1)] = (4));

(statearr_22396_22450[(5)] = null);

} else {
throw ex22389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (14))){
var inst_22261 = (state_22343[(7)]);
var inst_22243 = (state_22343[(14)]);
var inst_22274 = (inst_22261 < inst_22243);
var state_22343__$1 = state_22343;
var statearr_22397_22451 = state_22343__$1;
(statearr_22397_22451[(2)] = inst_22274);

(statearr_22397_22451[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (26))){
var inst_22240 = (state_22343[(19)]);
var inst_22262 = (state_22343[(10)]);
var inst_22288 = cljs.core.first(inst_22262);
var inst_22289 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_22240,inst_22288);
var state_22343__$1 = state_22343;
var statearr_22398_22452 = state_22343__$1;
(statearr_22398_22452[(2)] = inst_22289);

(statearr_22398_22452[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (16))){
var inst_22277 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22399_22453 = state_22343__$1;
(statearr_22399_22453[(2)] = inst_22277);

(statearr_22399_22453[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (38))){
var inst_22332 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22400_22454 = state_22343__$1;
(statearr_22400_22454[(2)] = inst_22332);

(statearr_22400_22454[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (30))){
var inst_22307 = (state_22343[(16)]);
var inst_22309 = fluree.db.query.fql_resp.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_22310 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22309,inst_22307);
var state_22343__$1 = state_22343;
var statearr_22401_22455 = state_22343__$1;
(statearr_22401_22455[(2)] = inst_22310);

(statearr_22401_22455[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (10))){
var inst_22336 = (state_22343[(2)]);
var state_22343__$1 = state_22343;
var statearr_22402_22456 = state_22343__$1;
(statearr_22402_22456[(2)] = inst_22336);

(statearr_22402_22456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22344 === (18))){
var inst_22268 = (state_22343[(21)]);
var inst_22241 = (state_22343[(20)]);
var inst_22298 = fluree.db.flake.o(inst_22268);
var inst_22299 = cljs.core.contains_QMARK_(inst_22241,inst_22298);
var inst_22301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22302 = [inst_22298];
var inst_22303 = (new cljs.core.PersistentVector(null,1,(5),inst_22301,inst_22302,null));
var inst_22304 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22303);
var state_22343__$1 = (function (){var statearr_22403 = state_22343;
(statearr_22403[(17)] = inst_22299);

return statearr_22403;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22343__$1,(29),inst_22304);
} else {
if((state_val_22344 === (37))){
var inst_22261 = (state_22343[(7)]);
var inst_22319 = (state_22343[(22)]);
var inst_22313 = (state_22343[(18)]);
var inst_22324 = (inst_22261 + (1));
var inst_22325 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22319,inst_22313) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22319,inst_22313));
var state_22343__$1 = (function (){var statearr_22404 = state_22343;
(statearr_22404[(13)] = inst_22324);

return statearr_22404;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22343__$1,(39),inst_22325);
} else {
if((state_val_22344 === (8))){
var inst_22338 = (state_22343[(2)]);
var _ = (function (){var statearr_22405 = state_22343;
(statearr_22405[(4)] = cljs.core.rest((state_22343[(4)])));

return statearr_22405;
})();
var state_22343__$1 = state_22343;
var statearr_22406_22457 = state_22343__$1;
(statearr_22406_22457[(2)] = inst_22338);

(statearr_22406_22457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_22407 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22407[(0)] = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__);

(statearr_22407[(1)] = (1));

return statearr_22407;
});
var fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1 = (function (state_22343){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22343);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e22408){var ex__2730__auto__ = e22408;
var statearr_22409_22458 = state_22343;
(statearr_22409_22458[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22343[(4)]))){
var statearr_22410_22459 = state_22343;
(statearr_22410_22459[(1)] = cljs.core.first((state_22343[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22460 = state_22343;
state_22343 = G__22460;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__ = function(state_22343){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1.call(this,state_22343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flake__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_22411 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_22411[(6)] = c__2749__auto__);

return statearr_22411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql_resp.wildcard_pred_spec = (function fluree$db$query$fql_resp$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql_resp.add_pred = (function fluree$db$query$fql_resp$add_pred(var_args){
var G__22464 = arguments.length;
switch (G__22464) {
case 9:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_22903){
var state_val_22904 = (state_22903[(1)]);
if((state_val_22904 === (121))){
var inst_22826 = (state_22903[(2)]);
var inst_22827 = fluree.db.util.async.throw_err(inst_22826);
var inst_22828 = cljs.core.seq(inst_22827);
var state_22903__$1 = state_22903;
if(inst_22828){
var statearr_22905_23119 = state_22903__$1;
(statearr_22905_23119[(1)] = (122));

} else {
var statearr_22906_23120 = state_22903__$1;
(statearr_22906_23120[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (65))){
var inst_22619 = (state_22903[(7)]);
var inst_22618 = (state_22903[(2)]);
var inst_22619__$1 = fluree.db.util.async.throw_err(inst_22618);
var inst_22620 = cljs.core.seq(inst_22619__$1);
var state_22903__$1 = (function (){var statearr_22907 = state_22903;
(statearr_22907[(7)] = inst_22619__$1);

return statearr_22907;
})();
if(inst_22620){
var statearr_22908_23121 = state_22903__$1;
(statearr_22908_23121[(1)] = (66));

} else {
var statearr_22909_23122 = state_22903__$1;
(statearr_22909_23122[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (70))){
var inst_22619 = (state_22903[(7)]);
var inst_22630 = cljs.core.count(inst_22619);
var inst_22631 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22630);
var state_22903__$1 = state_22903;
var statearr_22910_23123 = state_22903__$1;
(statearr_22910_23123[(2)] = inst_22631);

(statearr_22910_23123[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (62))){
var inst_22609 = (state_22903[(8)]);
var inst_22612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22613 = fluree.db.flake.o(inst_22609);
var inst_22614 = [inst_22613];
var inst_22615 = (new cljs.core.PersistentVector(null,1,(5),inst_22612,inst_22614,null));
var inst_22616 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22615);
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22903__$1,(65),inst_22616);
} else {
if((state_val_22904 === (74))){
var inst_22603 = (state_22903[(9)]);
var state_22903__$1 = state_22903;
var statearr_22911_23124 = state_22903__$1;
(statearr_22911_23124[(2)] = inst_22603);

(statearr_22911_23124[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (110))){
var inst_22788 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_22789 = new cljs.core.Keyword(null,"root?","root?",-2045639518).cljs$core$IFn$_invoke$arity$1(inst_22788);
var inst_22790 = inst_22789 === true;
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22790)){
var statearr_22912_23125 = state_22903__$1;
(statearr_22912_23125[(1)] = (113));

} else {
var statearr_22913_23126 = state_22903__$1;
(statearr_22913_23126[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (130))){
var inst_22898 = (state_22903[(2)]);
var _ = (function (){var statearr_22914 = state_22903;
(statearr_22914[(4)] = cljs.core.rest((state_22903[(4)])));

return statearr_22914;
})();
var state_22903__$1 = state_22903;
var statearr_22915_23127 = state_22903__$1;
(statearr_22915_23127[(2)] = inst_22898);

(statearr_22915_23127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (128))){
var inst_22873 = (state_22903[(10)]);
var inst_22876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22877 = [acc,inst_22873];
var inst_22878 = (new cljs.core.PersistentVector(null,2,(5),inst_22876,inst_22877,null));
var state_22903__$1 = state_22903;
var statearr_22916_23128 = state_22903__$1;
(statearr_22916_23128[(2)] = inst_22878);

(statearr_22916_23128[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (7))){
var inst_22476 = (state_22903[(11)]);
var state_22903__$1 = state_22903;
var statearr_22917_23129 = state_22903__$1;
(statearr_22917_23129[(2)] = inst_22476);

(statearr_22917_23129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (59))){
var inst_22867 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22918_23130 = state_22903__$1;
(statearr_22918_23130[(2)] = inst_22867);

(statearr_22918_23130[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (86))){
var inst_22697 = (state_22903[(12)]);
var inst_22697__$1 = (state_22903[(2)]);
var state_22903__$1 = (function (){var statearr_22919 = state_22903;
(statearr_22919[(12)] = inst_22697__$1);

return statearr_22919;
})();
if(cljs.core.truth_(inst_22697__$1)){
var statearr_22920_23131 = state_22903__$1;
(statearr_22920_23131[(1)] = (88));

} else {
var statearr_22921_23132 = state_22903__$1;
(statearr_22921_23132[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (20))){
var inst_22517 = (state_22903[(13)]);
var inst_22505 = (state_22903[(14)]);
var inst_22518 = (state_22903[(15)]);
var inst_22516 = (state_22903[(2)]);
var inst_22517__$1 = cljs.core.__destructure_map(inst_22505);
var inst_22518__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22517__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22519 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22517__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22517__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22521 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22517__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22522 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22517__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22517__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22903__$1 = (function (){var statearr_22922 = state_22903;
(statearr_22922[(16)] = inst_22523);

(statearr_22922[(13)] = inst_22517__$1);

(statearr_22922[(17)] = inst_22519);

(statearr_22922[(18)] = inst_22522);

(statearr_22922[(19)] = inst_22516);

(statearr_22922[(15)] = inst_22518__$1);

(statearr_22922[(20)] = inst_22520);

(statearr_22922[(21)] = inst_22521);

return statearr_22922;
})();
if(cljs.core.truth_(inst_22518__$1)){
var statearr_22923_23133 = state_22903__$1;
(statearr_22923_23133[(1)] = (24));

} else {
var statearr_22924_23134 = state_22903__$1;
(statearr_22924_23134[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (72))){
var inst_22628 = (state_22903[(22)]);
var inst_22634 = (state_22903[(2)]);
var inst_22635 = cljs.core.seq(inst_22628);
var state_22903__$1 = (function (){var statearr_22925 = state_22903;
(statearr_22925[(23)] = inst_22634);

return statearr_22925;
})();
if(inst_22635){
var statearr_22926_23135 = state_22903__$1;
(statearr_22926_23135[(1)] = (73));

} else {
var statearr_22927_23136 = state_22903__$1;
(statearr_22927_23136[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (58))){
var inst_22505 = (state_22903[(14)]);
var inst_22650 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22505);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22650)){
var statearr_22928_23137 = state_22903__$1;
(statearr_22928_23137[(1)] = (76));

} else {
var statearr_22929_23138 = state_22903__$1;
(statearr_22929_23138[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (60))){
var inst_22602 = (state_22903[(24)]);
var inst_22609 = (state_22903[(8)]);
var inst_22608 = cljs.core.seq(inst_22602);
var inst_22609__$1 = cljs.core.first(inst_22608);
var inst_22610 = cljs.core.next(inst_22608);
var state_22903__$1 = (function (){var statearr_22930 = state_22903;
(statearr_22930[(25)] = inst_22610);

(statearr_22930[(8)] = inst_22609__$1);

return statearr_22930;
})();
if(cljs.core.truth_(inst_22609__$1)){
var statearr_22931_23139 = state_22903__$1;
(statearr_22931_23139[(1)] = (62));

} else {
var statearr_22932_23140 = state_22903__$1;
(statearr_22932_23140[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (27))){
var inst_22526 = (state_22903[(26)]);
var inst_22522 = (state_22903[(18)]);
var inst_22526__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22522);
var state_22903__$1 = (function (){var statearr_22933 = state_22903;
(statearr_22933[(26)] = inst_22526__$1);

return statearr_22933;
})();
if(inst_22526__$1){
var statearr_22934_23141 = state_22903__$1;
(statearr_22934_23141[(1)] = (30));

} else {
var statearr_22935_23142 = state_22903__$1;
(statearr_22935_23142[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (1))){
var state_22903__$1 = state_22903;
var statearr_22936_23143 = state_22903__$1;
(statearr_22936_23143[(2)] = null);

(statearr_22936_23143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (69))){
var inst_22624 = (state_22903[(2)]);
var inst_22625 = fluree.db.util.async.throw_err(inst_22624);
var state_22903__$1 = state_22903;
var statearr_22937_23144 = state_22903__$1;
(statearr_22937_23144[(2)] = inst_22625);

(statearr_22937_23144[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (101))){
var inst_22781 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22938_23145 = state_22903__$1;
(statearr_22938_23145[(2)] = inst_22781);

(statearr_22938_23145[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (24))){
var inst_22522 = (state_22903[(18)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22522)){
var statearr_22939_23146 = state_22903__$1;
(statearr_22939_23146[(1)] = (27));

} else {
var statearr_22940_23147 = state_22903__$1;
(statearr_22940_23147[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (102))){
var inst_22753 = (state_22903[(27)]);
var inst_22752 = (state_22903[(2)]);
var inst_22753__$1 = fluree.db.util.async.throw_err(inst_22752);
var inst_22754 = cljs.core.empty_QMARK_(inst_22753__$1);
var state_22903__$1 = (function (){var statearr_22941 = state_22903;
(statearr_22941[(27)] = inst_22753__$1);

return statearr_22941;
})();
if(inst_22754){
var statearr_22942_23148 = state_22903__$1;
(statearr_22942_23148[(1)] = (103));

} else {
var statearr_22943_23149 = state_22903__$1;
(statearr_22943_23149[(1)] = (104));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (135))){
var state_22903__$1 = state_22903;
var statearr_22944_23150 = state_22903__$1;
(statearr_22944_23150[(2)] = null);

(statearr_22944_23150[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (55))){
var inst_22505 = (state_22903[(14)]);
var inst_22578 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22505);
var state_22903__$1 = state_22903;
var statearr_22945_23151 = state_22903__$1;
(statearr_22945_23151[(2)] = inst_22578);

(statearr_22945_23151[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (85))){
var inst_22672 = (state_22903[(28)]);
var inst_22505 = (state_22903[(14)]);
var inst_22684 = fluree.db.flake.o(inst_22672);
var inst_22685 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22505);
var inst_22686 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22684,inst_22685);
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22903__$1,(87),inst_22686);
} else {
if((state_val_22904 === (39))){
var inst_22553 = (state_22903[(29)]);
var inst_22521 = (state_22903[(21)]);
var inst_22553__$1 = cljs.core.not(inst_22521);
var state_22903__$1 = (function (){var statearr_22946 = state_22903;
(statearr_22946[(29)] = inst_22553__$1);

return statearr_22946;
})();
if(inst_22553__$1){
var statearr_22947_23152 = state_22903__$1;
(statearr_22947_23152[(1)] = (42));

} else {
var statearr_22948_23153 = state_22903__$1;
(statearr_22948_23153[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (88))){
var inst_22666 = (state_22903[(30)]);
var inst_22697 = (state_22903[(12)]);
var inst_22699 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22666,inst_22697);
var state_22903__$1 = state_22903;
var statearr_22949_23154 = state_22903__$1;
(statearr_22949_23154[(2)] = inst_22699);

(statearr_22949_23154[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (46))){
var inst_22520 = (state_22903[(20)]);
var state_22903__$1 = state_22903;
var statearr_22950_23155 = state_22903__$1;
(statearr_22950_23155[(2)] = inst_22520);

(statearr_22950_23155[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (4))){
var inst_22465 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22951_23156 = state_22903__$1;
(statearr_22951_23156[(2)] = inst_22465);

(statearr_22951_23156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (77))){
var inst_22712 = (state_22903[(31)]);
var inst_22712__$1 = componentFollow_QMARK_;
var state_22903__$1 = (function (){var statearr_22952 = state_22903;
(statearr_22952[(31)] = inst_22712__$1);

return statearr_22952;
})();
if(cljs.core.truth_(inst_22712__$1)){
var statearr_22953_23157 = state_22903__$1;
(statearr_22953_23157[(1)] = (91));

} else {
var statearr_22954_23158 = state_22903__$1;
(statearr_22954_23158[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (106))){
var inst_22733 = (state_22903[(32)]);
var inst_22767 = (state_22903[(2)]);
var inst_22768 = fluree.db.util.async.throw_err(inst_22767);
var inst_22769 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22733,inst_22768);
var state_22903__$1 = state_22903;
var statearr_22955_23159 = state_22903__$1;
(statearr_22955_23159[(2)] = inst_22769);

(statearr_22955_23159[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (119))){
var inst_22811 = (state_22903[(33)]);
var inst_22841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22842 = [inst_22811,offset_map];
var inst_22843 = (new cljs.core.PersistentVector(null,2,(5),inst_22841,inst_22842,null));
var state_22903__$1 = state_22903;
var statearr_22956_23160 = state_22903__$1;
(statearr_22956_23160[(2)] = inst_22843);

(statearr_22956_23160[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (95))){
var inst_22519 = (state_22903[(17)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22519)){
var statearr_22957_23161 = state_22903__$1;
(statearr_22957_23161[(1)] = (110));

} else {
var statearr_22958_23162 = state_22903__$1;
(statearr_22958_23162[(1)] = (111));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (54))){
var inst_22575 = (state_22903[(34)]);
var state_22903__$1 = state_22903;
var statearr_22959_23163 = state_22903__$1;
(statearr_22959_23163[(2)] = inst_22575);

(statearr_22959_23163[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (92))){
var inst_22712 = (state_22903[(31)]);
var state_22903__$1 = state_22903;
var statearr_22960_23164 = state_22903__$1;
(statearr_22960_23164[(2)] = inst_22712);

(statearr_22960_23164[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (104))){
var inst_22753 = (state_22903[(27)]);
var inst_22475 = (state_22903[(35)]);
var inst_22762 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298)];
var inst_22763 = [true,inst_22475];
var inst_22764 = cljs.core.PersistentHashMap.fromArrays(inst_22762,inst_22763);
var inst_22765 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22764,inst_22753) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22764,inst_22753));
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22903__$1,(106),inst_22765);
} else {
if((state_val_22904 === (15))){
var inst_22498 = (state_22903[(36)]);
var inst_22475 = (state_22903[(35)]);
var inst_22502 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22498,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22475);
var state_22903__$1 = state_22903;
var statearr_22961_23165 = state_22903__$1;
(statearr_22961_23165[(2)] = inst_22502);

(statearr_22961_23165[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (48))){
var inst_22569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22570 = [null,offset_map];
var inst_22571 = (new cljs.core.PersistentVector(null,2,(5),inst_22569,inst_22570,null));
var state_22903__$1 = state_22903;
var statearr_22962_23166 = state_22903__$1;
(statearr_22962_23166[(2)] = inst_22571);

(statearr_22962_23166[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (50))){
var inst_22869 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22963_23167 = state_22903__$1;
(statearr_22963_23167[(2)] = inst_22869);

(statearr_22963_23167[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (116))){
var inst_22817 = (state_22903[(37)]);
var inst_22810 = (state_22903[(38)]);
var inst_22816 = cljs.core.seq(inst_22810);
var inst_22817__$1 = cljs.core.first(inst_22816);
var inst_22818 = cljs.core.next(inst_22816);
var state_22903__$1 = (function (){var statearr_22964 = state_22903;
(statearr_22964[(39)] = inst_22818);

(statearr_22964[(37)] = inst_22817__$1);

return statearr_22964;
})();
if(cljs.core.truth_(inst_22817__$1)){
var statearr_22965_23168 = state_22903__$1;
(statearr_22965_23168[(1)] = (118));

} else {
var statearr_22966_23169 = state_22903__$1;
(statearr_22966_23169[(1)] = (119));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (75))){
var inst_22610 = (state_22903[(25)]);
var inst_22640 = (state_22903[(2)]);
var inst_22602 = inst_22610;
var inst_22603 = inst_22640;
var state_22903__$1 = (function (){var statearr_22967 = state_22903;
(statearr_22967[(24)] = inst_22602);

(statearr_22967[(9)] = inst_22603);

return statearr_22967;
})();
var statearr_22968_23170 = state_22903__$1;
(statearr_22968_23170[(2)] = null);

(statearr_22968_23170[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (99))){
var inst_22739 = (state_22903[(40)]);
var inst_22505 = (state_22903[(14)]);
var inst_22742 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22743 = fluree.db.flake.o(inst_22739);
var inst_22744 = [inst_22743];
var inst_22745 = (new cljs.core.PersistentVector(null,1,(5),inst_22742,inst_22744,null));
var inst_22746 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22747 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22505);
var inst_22748 = [inst_22747];
var inst_22749 = cljs.core.PersistentHashMap.fromArrays(inst_22746,inst_22748);
var inst_22750 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22745,inst_22749);
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22903__$1,(102),inst_22750);
} else {
if((state_val_22904 === (21))){
var inst_22509 = (state_22903[(41)]);
var state_22903__$1 = state_22903;
var statearr_22969_23171 = state_22903__$1;
(statearr_22969_23171[(2)] = inst_22509);

(statearr_22969_23171[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (31))){
var inst_22526 = (state_22903[(26)]);
var state_22903__$1 = state_22903;
var statearr_22970_23172 = state_22903__$1;
(statearr_22970_23172[(2)] = inst_22526);

(statearr_22970_23172[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (113))){
var inst_22523 = (state_22903[(16)]);
var inst_22517 = (state_22903[(13)]);
var inst_22505 = (state_22903[(14)]);
var inst_22519 = (state_22903[(17)]);
var inst_22522 = (state_22903[(18)]);
var inst_22516 = (state_22903[(19)]);
var inst_22490 = (state_22903[(42)]);
var inst_22518 = (state_22903[(15)]);
var inst_22475 = (state_22903[(35)]);
var inst_22520 = (state_22903[(20)]);
var inst_22521 = (state_22903[(21)]);
var inst_22792 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22793 = (function (){var p = inst_22523;
var pred_spec__$1 = inst_22490;
var orderBy = inst_22521;
var multi_QMARK_ = inst_22518;
var limit = inst_22520;
var offset = inst_22522;
var map__22471 = inst_22517;
var k = inst_22516;
var compact_QMARK_ = inst_22475;
var pred_spec_SINGLEQUOTE_ = inst_22505;
var ref_QMARK_ = inst_22519;
return (function (p1__22461_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"_id","_id",-789960287)],[fluree.db.flake.o(p1__22461_SHARP_)]);
});
})();
var inst_22794 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22793,flakes);
var inst_22795 = [inst_22794,offset_map];
var inst_22796 = (new cljs.core.PersistentVector(null,2,(5),inst_22792,inst_22795,null));
var state_22903__$1 = state_22903;
var statearr_22971_23173 = state_22903__$1;
(statearr_22971_23173[(2)] = inst_22796);

(statearr_22971_23173[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (32))){
var inst_22532 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22972_23174 = state_22903__$1;
(statearr_22972_23174[(2)] = inst_22532);

(statearr_22972_23174[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (136))){
var inst_22894 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22973_23175 = state_22903__$1;
(statearr_22973_23175[(2)] = inst_22894);

(statearr_22973_23175[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (40))){
var inst_22518 = (state_22903[(15)]);
var state_22903__$1 = state_22903;
var statearr_22974_23176 = state_22903__$1;
(statearr_22974_23176[(2)] = inst_22518);

(statearr_22974_23176[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (129))){
var inst_22518 = (state_22903[(15)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22518)){
var statearr_22975_23177 = state_22903__$1;
(statearr_22975_23177[(1)] = (131));

} else {
var statearr_22976_23178 = state_22903__$1;
(statearr_22976_23178[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (91))){
var inst_22505 = (state_22903[(14)]);
var inst_22714 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22505);
var state_22903__$1 = state_22903;
var statearr_22977_23179 = state_22903__$1;
(statearr_22977_23179[(2)] = inst_22714);

(statearr_22977_23179[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (117))){
var inst_22847 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22978_23180 = state_22903__$1;
(statearr_22978_23180[(2)] = inst_22847);

(statearr_22978_23180[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (108))){
var state_22903__$1 = state_22903;
var statearr_22979_23181 = state_22903__$1;
(statearr_22979_23181[(2)] = null);

(statearr_22979_23181[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (56))){
var inst_22580 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_22980_23182 = state_22903__$1;
(statearr_22980_23182[(2)] = inst_22580);

(statearr_22980_23182[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (33))){
var inst_22523 = (state_22903[(16)]);
var inst_22540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22541 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22523);
var state_22903__$1 = (function (){var statearr_22981 = state_22903;
(statearr_22981[(43)] = inst_22540);

return statearr_22981;
})();
if(cljs.core.truth_(inst_22541)){
var statearr_22982_23183 = state_22903__$1;
(statearr_22982_23183[(1)] = (36));

} else {
var statearr_22983_23184 = state_22903__$1;
(statearr_22983_23184[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (13))){
var inst_22490 = (state_22903[(42)]);
var state_22903__$1 = state_22903;
var statearr_22984_23185 = state_22903__$1;
(statearr_22984_23185[(2)] = inst_22490);

(statearr_22984_23185[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (22))){
var inst_22505 = (state_22903[(14)]);
var inst_22512 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22505);
var state_22903__$1 = state_22903;
var statearr_22985_23186 = state_22903__$1;
(statearr_22985_23186[(2)] = inst_22512);

(statearr_22985_23186[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (90))){
var inst_22673 = (state_22903[(44)]);
var inst_22702 = (state_22903[(2)]);
var inst_22665 = inst_22673;
var inst_22666 = inst_22702;
var state_22903__$1 = (function (){var statearr_22986 = state_22903;
(statearr_22986[(45)] = inst_22665);

(statearr_22986[(30)] = inst_22666);

return statearr_22986;
})();
var statearr_22987_23187 = state_22903__$1;
(statearr_22987_23187[(2)] = null);

(statearr_22987_23187[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (109))){
var inst_22771 = (state_22903[(46)]);
var inst_22740 = (state_22903[(47)]);
var inst_22777 = (state_22903[(2)]);
var inst_22732 = inst_22740;
var inst_22733 = inst_22771;
var state_22903__$1 = (function (){var statearr_22988 = state_22903;
(statearr_22988[(48)] = inst_22777);

(statearr_22988[(49)] = inst_22732);

(statearr_22988[(32)] = inst_22733);

return statearr_22988;
})();
var statearr_22989_23188 = state_22903__$1;
(statearr_22989_23188[(2)] = null);

(statearr_22989_23188[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (36))){
var inst_22523 = (state_22903[(16)]);
var inst_22543 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22523,cljs.core.dec);
var state_22903__$1 = state_22903;
var statearr_22990_23189 = state_22903__$1;
(statearr_22990_23189[(2)] = inst_22543);

(statearr_22990_23189[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (41))){
var inst_22567 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22567)){
var statearr_22991_23190 = state_22903__$1;
(statearr_22991_23190[(1)] = (48));

} else {
var statearr_22992_23191 = state_22903__$1;
(statearr_22992_23191[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (118))){
var inst_22817 = (state_22903[(37)]);
var inst_22820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22821 = fluree.db.flake.o(inst_22817);
var inst_22822 = [inst_22821];
var inst_22823 = (new cljs.core.PersistentVector(null,1,(5),inst_22820,inst_22822,null));
var inst_22824 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22823);
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22903__$1,(121),inst_22824);
} else {
if((state_val_22904 === (89))){
var inst_22666 = (state_22903[(30)]);
var state_22903__$1 = state_22903;
var statearr_22993_23192 = state_22903__$1;
(statearr_22993_23192[(2)] = inst_22666);

(statearr_22993_23192[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (100))){
var inst_22733 = (state_22903[(32)]);
var state_22903__$1 = state_22903;
var statearr_22994_23193 = state_22903__$1;
(statearr_22994_23193[(2)] = inst_22733);

(statearr_22994_23193[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (131))){
var inst_22873 = (state_22903[(10)]);
var inst_22516 = (state_22903[(19)]);
var inst_22872 = (state_22903[(50)]);
var inst_22881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22882 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22516,inst_22872);
var inst_22883 = [inst_22882,inst_22873];
var inst_22884 = (new cljs.core.PersistentVector(null,2,(5),inst_22881,inst_22883,null));
var state_22903__$1 = state_22903;
var statearr_22995_23194 = state_22903__$1;
(statearr_22995_23194[(2)] = inst_22884);

(statearr_22995_23194[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (122))){
var inst_22818 = (state_22903[(39)]);
var inst_22817 = (state_22903[(37)]);
var inst_22811 = (state_22903[(33)]);
var inst_22830 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22831 = fluree.db.flake.o(inst_22817);
var inst_22832 = [inst_22831];
var inst_22833 = cljs.core.PersistentHashMap.fromArrays(inst_22830,inst_22832);
var inst_22834 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22811,inst_22833);
var inst_22810 = inst_22818;
var inst_22811__$1 = inst_22834;
var state_22903__$1 = (function (){var statearr_22996 = state_22903;
(statearr_22996[(33)] = inst_22811__$1);

(statearr_22996[(38)] = inst_22810);

return statearr_22996;
})();
var statearr_22997_23195 = state_22903__$1;
(statearr_22997_23195[(2)] = null);

(statearr_22997_23195[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (43))){
var inst_22553 = (state_22903[(29)]);
var state_22903__$1 = state_22903;
var statearr_22998_23196 = state_22903__$1;
(statearr_22998_23196[(2)] = inst_22553);

(statearr_22998_23196[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (61))){
var inst_22589 = (state_22903[(51)]);
var inst_22646 = (state_22903[(2)]);
var inst_22647 = [inst_22646,offset_map];
var inst_22648 = (new cljs.core.PersistentVector(null,2,(5),inst_22589,inst_22647,null));
var state_22903__$1 = state_22903;
var statearr_22999_23197 = state_22903__$1;
(statearr_22999_23197[(2)] = inst_22648);

(statearr_22999_23197[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (29))){
var inst_22535 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23000_23198 = state_22903__$1;
(statearr_23000_23198[(2)] = inst_22535);

(statearr_23000_23198[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (44))){
var inst_22564 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23001_23199 = state_22903__$1;
(statearr_23001_23199[(2)] = inst_22564);

(statearr_23001_23199[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (93))){
var inst_22717 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22717)){
var statearr_23002_23200 = state_22903__$1;
(statearr_23002_23200[(1)] = (94));

} else {
var statearr_23003_23201 = state_22903__$1;
(statearr_23003_23201[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (6))){
var inst_22478 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22479 = (inst_22478 == null);
var state_22903__$1 = state_22903;
var statearr_23004_23202 = state_22903__$1;
(statearr_23004_23202[(2)] = inst_22479);

(statearr_23004_23202[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (111))){
var state_22903__$1 = state_22903;
var statearr_23005_23203 = state_22903__$1;
(statearr_23005_23203[(1)] = (125));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (28))){
var inst_22522 = (state_22903[(18)]);
var state_22903__$1 = state_22903;
var statearr_23007_23204 = state_22903__$1;
(statearr_23007_23204[(2)] = inst_22522);

(statearr_23007_23204[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (134))){
var inst_22873 = (state_22903[(10)]);
var inst_22516 = (state_22903[(19)]);
var inst_22872 = (state_22903[(50)]);
var inst_22887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22888 = cljs.core.first(inst_22872);
var inst_22889 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22516,inst_22888);
var inst_22890 = [inst_22889,inst_22873];
var inst_22891 = (new cljs.core.PersistentVector(null,2,(5),inst_22887,inst_22890,null));
var state_22903__$1 = state_22903;
var statearr_23008_23205 = state_22903__$1;
(statearr_23008_23205[(2)] = inst_22891);

(statearr_23008_23205[(1)] = (136));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (64))){
var inst_22644 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23009_23206 = state_22903__$1;
(statearr_23009_23206[(2)] = inst_22644);

(statearr_23009_23206[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (103))){
var inst_22739 = (state_22903[(40)]);
var inst_22733 = (state_22903[(32)]);
var inst_22756 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22757 = fluree.db.flake.o(inst_22739);
var inst_22758 = [inst_22757];
var inst_22759 = cljs.core.PersistentHashMap.fromArrays(inst_22756,inst_22758);
var inst_22760 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22733,inst_22759);
var state_22903__$1 = state_22903;
var statearr_23010_23207 = state_22903__$1;
(statearr_23010_23207[(2)] = inst_22760);

(statearr_23010_23207[(1)] = (105));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (51))){
var inst_22505 = (state_22903[(14)]);
var inst_22575 = (state_22903[(34)]);
var inst_22575__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22505);
var state_22903__$1 = (function (){var statearr_23011 = state_22903;
(statearr_23011[(34)] = inst_22575__$1);

return statearr_23011;
})();
if(cljs.core.truth_(inst_22575__$1)){
var statearr_23012_23208 = state_22903__$1;
(statearr_23012_23208[(1)] = (54));

} else {
var statearr_23013_23209 = state_22903__$1;
(statearr_23013_23209[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (25))){
var inst_22518 = (state_22903[(15)]);
var state_22903__$1 = state_22903;
var statearr_23014_23210 = state_22903__$1;
(statearr_23014_23210[(2)] = inst_22518);

(statearr_23014_23210[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (34))){
var inst_22518 = (state_22903[(15)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22518)){
var statearr_23015_23211 = state_22903__$1;
(statearr_23015_23211[(1)] = (39));

} else {
var statearr_23016_23212 = state_22903__$1;
(statearr_23016_23212[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (125))){
var inst_22523 = (state_22903[(16)]);
var inst_22517 = (state_22903[(13)]);
var inst_22505 = (state_22903[(14)]);
var inst_22519 = (state_22903[(17)]);
var inst_22522 = (state_22903[(18)]);
var inst_22516 = (state_22903[(19)]);
var inst_22490 = (state_22903[(42)]);
var inst_22518 = (state_22903[(15)]);
var inst_22475 = (state_22903[(35)]);
var inst_22520 = (state_22903[(20)]);
var inst_22521 = (state_22903[(21)]);
var inst_22852 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22853 = (function (){var p = inst_22523;
var pred_spec__$1 = inst_22490;
var orderBy = inst_22521;
var multi_QMARK_ = inst_22518;
var limit = inst_22520;
var offset = inst_22522;
var map__22471 = inst_22517;
var k = inst_22516;
var compact_QMARK_ = inst_22475;
var pred_spec_SINGLEQUOTE_ = inst_22505;
var ref_QMARK_ = inst_22519;
return (function (p1__22462_SHARP_){
return fluree.db.flake.o(p1__22462_SHARP_);
});
})();
var inst_22854 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_22853,flakes);
var inst_22855 = [inst_22854,offset_map];
var inst_22856 = (new cljs.core.PersistentVector(null,2,(5),inst_22852,inst_22855,null));
var state_22903__$1 = state_22903;
var statearr_23017_23213 = state_22903__$1;
(statearr_23017_23213[(2)] = inst_22856);

(statearr_23017_23213[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (17))){
var inst_22506 = (state_22903[(52)]);
var inst_22505 = (state_22903[(14)]);
var inst_22505__$1 = (state_22903[(2)]);
var inst_22506__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22505__$1);
var state_22903__$1 = (function (){var statearr_23018 = state_22903;
(statearr_23018[(52)] = inst_22506__$1);

(statearr_23018[(14)] = inst_22505__$1);

return statearr_23018;
})();
if(cljs.core.truth_(inst_22506__$1)){
var statearr_23019_23214 = state_22903__$1;
(statearr_23019_23214[(1)] = (18));

} else {
var statearr_23020_23215 = state_22903__$1;
(statearr_23020_23215[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (3))){
var inst_22901 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22903__$1,inst_22901);
} else {
if((state_val_22904 === (12))){
var inst_22490 = (state_22903[(42)]);
var inst_22495 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22490,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22903__$1 = state_22903;
var statearr_23021_23216 = state_22903__$1;
(statearr_23021_23216[(2)] = inst_22495);

(statearr_23021_23216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (2))){
var inst_22476 = (state_22903[(11)]);
var _ = (function (){var statearr_23022 = state_22903;
(statearr_23022[(4)] = cljs.core.cons((5),(state_22903[(4)])));

return statearr_23022;
})();
var inst_22475 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22476__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22903__$1 = (function (){var statearr_23023 = state_22903;
(statearr_23023[(11)] = inst_22476__$1);

(statearr_23023[(35)] = inst_22475);

return statearr_23023;
})();
if(cljs.core.truth_(inst_22476__$1)){
var statearr_23024_23217 = state_22903__$1;
(statearr_23024_23217[(1)] = (6));

} else {
var statearr_23025_23218 = state_22903__$1;
(statearr_23025_23218[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (66))){
var inst_22588 = (state_22903[(53)]);
var inst_22619 = (state_22903[(7)]);
var inst_22622 = (fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql_resp.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22588,inst_22619) : fluree.db.query.fql_resp.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22588,inst_22619));
var state_22903__$1 = state_22903;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22903__$1,(69),inst_22622);
} else {
if((state_val_22904 === (107))){
var inst_22753 = (state_22903[(27)]);
var inst_22773 = cljs.core.count(inst_22753);
var inst_22774 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_22773);
var state_22903__$1 = state_22903;
var statearr_23026_23219 = state_22903__$1;
(statearr_23026_23219[(2)] = inst_22774);

(statearr_23026_23219[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (23))){
var inst_22514 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23027_23220 = state_22903__$1;
(statearr_23027_23220[(2)] = inst_22514);

(statearr_23027_23220[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (47))){
var inst_22561 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23028_23221 = state_22903__$1;
(statearr_23028_23221[(2)] = inst_22561);

(statearr_23028_23221[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (35))){
var inst_22872 = (state_22903[(50)]);
var inst_22871 = (state_22903[(2)]);
var inst_22872__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22871,(0),null);
var inst_22873 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22871,(1),null);
var inst_22874 = cljs.core.empty_QMARK_(inst_22872__$1);
var state_22903__$1 = (function (){var statearr_23029 = state_22903;
(statearr_23029[(10)] = inst_22873);

(statearr_23029[(50)] = inst_22872__$1);

return statearr_23029;
})();
if(inst_22874){
var statearr_23030_23222 = state_22903__$1;
(statearr_23030_23222[(1)] = (128));

} else {
var statearr_23031_23223 = state_22903__$1;
(statearr_23031_23223[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (127))){
var inst_22859 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23032_23224 = state_22903__$1;
(statearr_23032_23224[(2)] = inst_22859);

(statearr_23032_23224[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (82))){
var inst_22666 = (state_22903[(30)]);
var state_22903__$1 = state_22903;
var statearr_23033_23225 = state_22903__$1;
(statearr_23033_23225[(2)] = inst_22666);

(statearr_23033_23225[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (76))){
var inst_22652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22660 = flakes;
var inst_22661 = cljs.core.seq(inst_22660);
var inst_22662 = cljs.core.first(inst_22661);
var inst_22663 = cljs.core.next(inst_22661);
var inst_22664 = cljs.core.PersistentVector.EMPTY;
var inst_22665 = inst_22660;
var inst_22666 = inst_22664;
var state_22903__$1 = (function (){var statearr_23034 = state_22903;
(statearr_23034[(54)] = inst_22652);

(statearr_23034[(45)] = inst_22665);

(statearr_23034[(30)] = inst_22666);

(statearr_23034[(55)] = inst_22663);

(statearr_23034[(56)] = inst_22662);

return statearr_23034;
})();
var statearr_23035_23226 = state_22903__$1;
(statearr_23035_23226[(2)] = null);

(statearr_23035_23226[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (97))){
var inst_22739 = (state_22903[(40)]);
var inst_22732 = (state_22903[(49)]);
var inst_22738 = cljs.core.seq(inst_22732);
var inst_22739__$1 = cljs.core.first(inst_22738);
var inst_22740 = cljs.core.next(inst_22738);
var state_22903__$1 = (function (){var statearr_23036 = state_22903;
(statearr_23036[(40)] = inst_22739__$1);

(statearr_23036[(47)] = inst_22740);

return statearr_23036;
})();
if(cljs.core.truth_(inst_22739__$1)){
var statearr_23037_23227 = state_22903__$1;
(statearr_23037_23227[(1)] = (99));

} else {
var statearr_23038_23228 = state_22903__$1;
(statearr_23038_23228[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (19))){
var inst_22505 = (state_22903[(14)]);
var inst_22509 = (state_22903[(41)]);
var inst_22509__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22505);
var state_22903__$1 = (function (){var statearr_23039 = state_22903;
(statearr_23039[(41)] = inst_22509__$1);

return statearr_23039;
})();
if(cljs.core.truth_(inst_22509__$1)){
var statearr_23040_23229 = state_22903__$1;
(statearr_23040_23229[(1)] = (21));

} else {
var statearr_23041_23230 = state_22903__$1;
(statearr_23041_23230[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (57))){
var inst_22505 = (state_22903[(14)]);
var inst_22585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22586 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22587 = (new cljs.core.PersistentVector(null,3,(5),inst_22585,inst_22586,null));
var inst_22588 = cljs.core.select_keys(inst_22505,inst_22587);
var inst_22589 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22597 = flakes;
var inst_22598 = cljs.core.seq(inst_22597);
var inst_22599 = cljs.core.first(inst_22598);
var inst_22600 = cljs.core.next(inst_22598);
var inst_22601 = cljs.core.PersistentVector.EMPTY;
var inst_22602 = inst_22597;
var inst_22603 = inst_22601;
var state_22903__$1 = (function (){var statearr_23042 = state_22903;
(statearr_23042[(24)] = inst_22602);

(statearr_23042[(57)] = inst_22599);

(statearr_23042[(53)] = inst_22588);

(statearr_23042[(58)] = inst_22600);

(statearr_23042[(9)] = inst_22603);

(statearr_23042[(51)] = inst_22589);

return statearr_23042;
})();
var statearr_23043_23231 = state_22903__$1;
(statearr_23043_23231[(2)] = null);

(statearr_23043_23231[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (68))){
var inst_22628 = (state_22903[(2)]);
var state_22903__$1 = (function (){var statearr_23044 = state_22903;
(statearr_23044[(22)] = inst_22628);

return statearr_23044;
})();
if(cljs.core.truth_(fuel)){
var statearr_23045_23232 = state_22903__$1;
(statearr_23045_23232[(1)] = (70));

} else {
var statearr_23046_23233 = state_22903__$1;
(statearr_23046_23233[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (11))){
var inst_22490 = (state_22903[(42)]);
var inst_22490__$1 = (state_22903[(2)]);
var inst_22492 = cljs.core.contains_QMARK_(inst_22490__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22493 = (!(inst_22492));
var state_22903__$1 = (function (){var statearr_23047 = state_22903;
(statearr_23047[(42)] = inst_22490__$1);

return statearr_23047;
})();
if(inst_22493){
var statearr_23048_23234 = state_22903__$1;
(statearr_23048_23234[(1)] = (12));

} else {
var statearr_23049_23235 = state_22903__$1;
(statearr_23049_23235[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (115))){
var inst_22849 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23051_23236 = state_22903__$1;
(statearr_23051_23236[(2)] = inst_22849);

(statearr_23051_23236[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (9))){
var inst_22484 = cljs.core.first(flakes);
var inst_22485 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22484);
var inst_22486 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22487 = fluree.db.query.fql_resp.wildcard_pred_spec(db,cache,inst_22485,inst_22486);
var state_22903__$1 = state_22903;
var statearr_23052_23237 = state_22903__$1;
(statearr_23052_23237[(2)] = inst_22487);

(statearr_23052_23237[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (5))){
var _ = (function (){var statearr_23053 = state_22903;
(statearr_23053[(4)] = cljs.core.rest((state_22903[(4)])));

return statearr_23053;
})();
var state_22903__$1 = state_22903;
var ex23050 = (state_22903__$1[(2)]);
var statearr_23054_23238 = state_22903__$1;
(statearr_23054_23238[(5)] = ex23050);


if((ex23050 instanceof Error)){
var statearr_23055_23239 = state_22903__$1;
(statearr_23055_23239[(1)] = (4));

(statearr_23055_23239[(5)] = null);

} else {
throw ex23050;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (112))){
var inst_22861 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23056_23240 = state_22903__$1;
(statearr_23056_23240[(2)] = inst_22861);

(statearr_23056_23240[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (83))){
var inst_22706 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23057_23241 = state_22903__$1;
(statearr_23057_23241[(2)] = inst_22706);

(statearr_23057_23241[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (14))){
var inst_22490 = (state_22903[(42)]);
var inst_22498 = (state_22903[(2)]);
var inst_22499 = cljs.core.contains_QMARK_(inst_22490,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22500 = (!(inst_22499));
var state_22903__$1 = (function (){var statearr_23058 = state_22903;
(statearr_23058[(36)] = inst_22498);

return statearr_23058;
})();
if(inst_22500){
var statearr_23059_23242 = state_22903__$1;
(statearr_23059_23242[(1)] = (15));

} else {
var statearr_23060_23243 = state_22903__$1;
(statearr_23060_23243[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (45))){
var inst_22516 = (state_22903[(19)]);
var inst_22520 = (state_22903[(20)]);
var inst_22556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22516);
var inst_22557 = cljs.core.count(inst_22556);
var inst_22558 = (inst_22557 >= inst_22520);
var state_22903__$1 = state_22903;
var statearr_23061_23244 = state_22903__$1;
(statearr_23061_23244[(2)] = inst_22558);

(statearr_23061_23244[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (53))){
var inst_22583 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22583)){
var statearr_23062_23245 = state_22903__$1;
(statearr_23062_23245[(1)] = (57));

} else {
var statearr_23063_23246 = state_22903__$1;
(statearr_23063_23246[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (78))){
var inst_22865 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23064_23247 = state_22903__$1;
(statearr_23064_23247[(2)] = inst_22865);

(statearr_23064_23247[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (132))){
var state_22903__$1 = state_22903;
var statearr_23066_23248 = state_22903__$1;
(statearr_23066_23248[(1)] = (134));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (26))){
var inst_22538 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22538)){
var statearr_23068_23249 = state_22903__$1;
(statearr_23068_23249[(1)] = (33));

} else {
var statearr_23069_23250 = state_22903__$1;
(statearr_23069_23250[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (123))){
var inst_22818 = (state_22903[(39)]);
var inst_22811 = (state_22903[(33)]);
var tmp23065 = inst_22811;
var inst_22810 = inst_22818;
var inst_22811__$1 = tmp23065;
var state_22903__$1 = (function (){var statearr_23070 = state_22903;
(statearr_23070[(33)] = inst_22811__$1);

(statearr_23070[(38)] = inst_22810);

return statearr_23070;
})();
var statearr_23071_23251 = state_22903__$1;
(statearr_23071_23251[(2)] = null);

(statearr_23071_23251[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (16))){
var inst_22498 = (state_22903[(36)]);
var state_22903__$1 = state_22903;
var statearr_23072_23252 = state_22903__$1;
(statearr_23072_23252[(2)] = inst_22498);

(statearr_23072_23252[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (133))){
var inst_22896 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23073_23253 = state_22903__$1;
(statearr_23073_23253[(2)] = inst_22896);

(statearr_23073_23253[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (81))){
var inst_22672 = (state_22903[(28)]);
var inst_22505 = (state_22903[(14)]);
var inst_22681 = (state_22903[(59)]);
var inst_22675 = cljs.core.deref(cache);
var inst_22676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22677 = fluree.db.flake.o(inst_22672);
var inst_22678 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22505);
var inst_22679 = [inst_22677,inst_22678];
var inst_22680 = (new cljs.core.PersistentVector(null,2,(5),inst_22676,inst_22679,null));
var inst_22681__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22675,inst_22680);
var state_22903__$1 = (function (){var statearr_23074 = state_22903;
(statearr_23074[(59)] = inst_22681__$1);

return statearr_23074;
})();
if(cljs.core.truth_(inst_22681__$1)){
var statearr_23075_23254 = state_22903__$1;
(statearr_23075_23254[(1)] = (84));

} else {
var statearr_23076_23255 = state_22903__$1;
(statearr_23076_23255[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (120))){
var inst_22845 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23077_23256 = state_22903__$1;
(statearr_23077_23256[(2)] = inst_22845);

(statearr_23077_23256[(1)] = (117));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (79))){
var inst_22672 = (state_22903[(28)]);
var inst_22665 = (state_22903[(45)]);
var inst_22671 = cljs.core.seq(inst_22665);
var inst_22672__$1 = cljs.core.first(inst_22671);
var inst_22673 = cljs.core.next(inst_22671);
var state_22903__$1 = (function (){var statearr_23078 = state_22903;
(statearr_23078[(28)] = inst_22672__$1);

(statearr_23078[(44)] = inst_22673);

return statearr_23078;
})();
if(cljs.core.truth_(inst_22672__$1)){
var statearr_23079_23257 = state_22903__$1;
(statearr_23079_23257[(1)] = (81));

} else {
var statearr_23080_23258 = state_22903__$1;
(statearr_23080_23258[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (38))){
var inst_22540 = (state_22903[(43)]);
var inst_22548 = (state_22903[(2)]);
var inst_22549 = [null,inst_22548];
var inst_22550 = (new cljs.core.PersistentVector(null,2,(5),inst_22540,inst_22549,null));
var state_22903__$1 = state_22903;
var statearr_23081_23259 = state_22903__$1;
(statearr_23081_23259[(2)] = inst_22550);

(statearr_23081_23259[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (126))){
var state_22903__$1 = state_22903;
var statearr_23082_23260 = state_22903__$1;
(statearr_23082_23260[(2)] = null);

(statearr_23082_23260[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (98))){
var inst_22719 = (state_22903[(60)]);
var inst_22783 = (state_22903[(2)]);
var inst_22784 = [inst_22783,offset_map];
var inst_22785 = (new cljs.core.PersistentVector(null,2,(5),inst_22719,inst_22784,null));
var state_22903__$1 = state_22903;
var statearr_23083_23261 = state_22903__$1;
(statearr_23083_23261[(2)] = inst_22785);

(statearr_23083_23261[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (124))){
var inst_22839 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23084_23262 = state_22903__$1;
(statearr_23084_23262[(2)] = inst_22839);

(statearr_23084_23262[(1)] = (120));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (87))){
var inst_22672 = (state_22903[(28)]);
var inst_22505 = (state_22903[(14)]);
var inst_22688 = (state_22903[(2)]);
var inst_22689 = fluree.db.util.async.throw_err(inst_22688);
var inst_22690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22691 = fluree.db.flake.o(inst_22672);
var inst_22692 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22505);
var inst_22693 = [inst_22691,inst_22692];
var inst_22694 = (new cljs.core.PersistentVector(null,2,(5),inst_22690,inst_22693,null));
var inst_22695 = fluree.db.query.fql_resp.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_22694,inst_22689);
var state_22903__$1 = (function (){var statearr_23085 = state_22903;
(statearr_23085[(61)] = inst_22695);

return statearr_23085;
})();
var statearr_23086_23263 = state_22903__$1;
(statearr_23086_23263[(2)] = inst_22689);

(statearr_23086_23263[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (30))){
var inst_22523 = (state_22903[(16)]);
var inst_22528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22523);
var inst_22529 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22528);
var state_22903__$1 = state_22903;
var statearr_23087_23264 = state_22903__$1;
(statearr_23087_23264[(2)] = inst_22529);

(statearr_23087_23264[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (73))){
var inst_22603 = (state_22903[(9)]);
var inst_22628 = (state_22903[(22)]);
var inst_22637 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22603,inst_22628);
var state_22903__$1 = state_22903;
var statearr_23088_23265 = state_22903__$1;
(statearr_23088_23265[(2)] = inst_22637);

(statearr_23088_23265[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (96))){
var inst_22863 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
var statearr_23089_23266 = state_22903__$1;
(statearr_23089_23266[(2)] = inst_22863);

(statearr_23089_23266[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (10))){
var state_22903__$1 = state_22903;
var statearr_23090_23267 = state_22903__$1;
(statearr_23090_23267[(2)] = pred_spec);

(statearr_23090_23267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (18))){
var inst_22506 = (state_22903[(52)]);
var state_22903__$1 = state_22903;
var statearr_23091_23268 = state_22903__$1;
(statearr_23091_23268[(2)] = inst_22506);

(statearr_23091_23268[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (105))){
var inst_22771 = (state_22903[(2)]);
var state_22903__$1 = (function (){var statearr_23092 = state_22903;
(statearr_23092[(46)] = inst_22771);

return statearr_23092;
})();
if(cljs.core.truth_(fuel)){
var statearr_23093_23269 = state_22903__$1;
(statearr_23093_23269[(1)] = (107));

} else {
var statearr_23094_23270 = state_22903__$1;
(statearr_23094_23270[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (52))){
var inst_22573 = (state_22903[(62)]);
var state_22903__$1 = state_22903;
var statearr_23095_23271 = state_22903__$1;
(statearr_23095_23271[(2)] = inst_22573);

(statearr_23095_23271[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (114))){
var inst_22805 = flakes;
var inst_22806 = cljs.core.seq(inst_22805);
var inst_22807 = cljs.core.first(inst_22806);
var inst_22808 = cljs.core.next(inst_22806);
var inst_22809 = cljs.core.PersistentVector.EMPTY;
var inst_22810 = inst_22805;
var inst_22811 = inst_22809;
var state_22903__$1 = (function (){var statearr_23096 = state_22903;
(statearr_23096[(63)] = inst_22808);

(statearr_23096[(64)] = inst_22807);

(statearr_23096[(33)] = inst_22811);

(statearr_23096[(38)] = inst_22810);

return statearr_23096;
})();
var statearr_23097_23272 = state_22903__$1;
(statearr_23097_23272[(2)] = null);

(statearr_23097_23272[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (67))){
var state_22903__$1 = state_22903;
var statearr_23098_23273 = state_22903__$1;
(statearr_23098_23273[(2)] = null);

(statearr_23098_23273[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (71))){
var state_22903__$1 = state_22903;
var statearr_23099_23274 = state_22903__$1;
(statearr_23099_23274[(2)] = null);

(statearr_23099_23274[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (42))){
var inst_22520 = (state_22903[(20)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22520)){
var statearr_23100_23275 = state_22903__$1;
(statearr_23100_23275[(1)] = (45));

} else {
var statearr_23101_23276 = state_22903__$1;
(statearr_23101_23276[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (80))){
var inst_22652 = (state_22903[(54)]);
var inst_22708 = (state_22903[(2)]);
var inst_22709 = [inst_22708,offset_map];
var inst_22710 = (new cljs.core.PersistentVector(null,2,(5),inst_22652,inst_22709,null));
var state_22903__$1 = state_22903;
var statearr_23102_23277 = state_22903__$1;
(statearr_23102_23277[(2)] = inst_22710);

(statearr_23102_23277[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (37))){
var inst_22523 = (state_22903[(16)]);
var inst_22522 = (state_22903[(18)]);
var inst_22545 = (inst_22522 - (1));
var inst_22546 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22523,inst_22545);
var state_22903__$1 = state_22903;
var statearr_23103_23278 = state_22903__$1;
(statearr_23103_23278[(2)] = inst_22546);

(statearr_23103_23278[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (63))){
var inst_22603 = (state_22903[(9)]);
var state_22903__$1 = state_22903;
var statearr_23104_23279 = state_22903__$1;
(statearr_23104_23279[(2)] = inst_22603);

(statearr_23104_23279[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (94))){
var inst_22719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22727 = flakes;
var inst_22728 = cljs.core.seq(inst_22727);
var inst_22729 = cljs.core.first(inst_22728);
var inst_22730 = cljs.core.next(inst_22728);
var inst_22731 = cljs.core.PersistentVector.EMPTY;
var inst_22732 = inst_22727;
var inst_22733 = inst_22731;
var state_22903__$1 = (function (){var statearr_23105 = state_22903;
(statearr_23105[(65)] = inst_22729);

(statearr_23105[(66)] = inst_22730);

(statearr_23105[(49)] = inst_22732);

(statearr_23105[(60)] = inst_22719);

(statearr_23105[(32)] = inst_22733);

return statearr_23105;
})();
var statearr_23106_23280 = state_22903__$1;
(statearr_23106_23280[(2)] = null);

(statearr_23106_23280[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (8))){
var inst_22482 = (state_22903[(2)]);
var state_22903__$1 = state_22903;
if(cljs.core.truth_(inst_22482)){
var statearr_23107_23281 = state_22903__$1;
(statearr_23107_23281[(1)] = (9));

} else {
var statearr_23108_23282 = state_22903__$1;
(statearr_23108_23282[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (49))){
var inst_22573 = (state_22903[(62)]);
var inst_22573__$1 = cljs.core.not(recur_QMARK_);
var state_22903__$1 = (function (){var statearr_23109 = state_22903;
(statearr_23109[(62)] = inst_22573__$1);

return statearr_23109;
})();
if(inst_22573__$1){
var statearr_23110_23283 = state_22903__$1;
(statearr_23110_23283[(1)] = (51));

} else {
var statearr_23111_23284 = state_22903__$1;
(statearr_23111_23284[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22904 === (84))){
var inst_22681 = (state_22903[(59)]);
var state_22903__$1 = state_22903;
var statearr_23112_23285 = state_22903__$1;
(statearr_23112_23285[(2)] = inst_22681);

(statearr_23112_23285[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$state_machine__2727__auto____0 = (function (){
var statearr_23113 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23113[(0)] = fluree$db$query$fql_resp$state_machine__2727__auto__);

(statearr_23113[(1)] = (1));

return statearr_23113;
});
var fluree$db$query$fql_resp$state_machine__2727__auto____1 = (function (state_22903){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_22903);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23114){var ex__2730__auto__ = e23114;
var statearr_23115_23286 = state_22903;
(statearr_23115_23286[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_22903[(4)]))){
var statearr_23116_23287 = state_22903;
(statearr_23116_23287[(1)] = cljs.core.first((state_22903[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23288 = state_22903;
state_22903 = G__23288;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$state_machine__2727__auto__ = function(state_22903){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$state_machine__2727__auto____1.call(this,state_22903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$state_machine__2727__auto____0;
fluree$db$query$fql_resp$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$state_machine__2727__auto____1;
return fluree$db$query$fql_resp$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23117 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23117[(6)] = c__2749__auto__);

return statearr_23117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.fql_resp.add_pred.cljs$lang$maxFixedArity = 10);

fluree.db.query.fql_resp.compare_fn = (function fluree$db$query$fql_resp$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql_resp.sort_offset_and_limit_res = (function fluree$db$query$fql_resp$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__23290 = res;
var G__23290__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__23289_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__23289_SHARP_,sortPred);
}),fluree.db.query.fql_resp.compare_fn,G__23290):G__23290);
var G__23290__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__23290__$1):G__23290__$1);
var G__23290__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__23290__$2):G__23290__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__23290__$3);
} else {
return G__23290__$3;
}
} else {
return res;
}
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql_resp.flakes__GT_res = (function fluree$db$query$fql_resp$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_23471){
var state_val_23472 = (state_23471[(1)]);
if((state_val_23472 === (7))){
var state_23471__$1 = state_23471;
var statearr_23473_23559 = state_23471__$1;
(statearr_23473_23559[(2)] = null);

(statearr_23473_23559[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (20))){
var inst_23329 = cljs.core.PersistentHashMap.EMPTY;
var state_23471__$1 = state_23471;
var statearr_23474_23560 = state_23471__$1;
(statearr_23474_23560[(2)] = inst_23329);

(statearr_23474_23560[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (27))){
var inst_23311 = (state_23471[(7)]);
var inst_23331 = (state_23471[(8)]);
var inst_23317 = (state_23471[(9)]);
var inst_23347 = (state_23471[(10)]);
var inst_23450 = (state_23471[(2)]);
var inst_23451 = (function (){var top_level_subject = inst_23311;
var select_spec = inst_23317;
var base_acc = inst_23331;
var acc_PLUS_refs = inst_23347;
var result = inst_23450;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__5045__auto__ = (function (){var and__5043__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__5043__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__5043__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23452 = cljs.core.PersistentVector.EMPTY;
var inst_23453 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23317);
var inst_23454 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23453);
var inst_23455 = cljs.core.vals(inst_23454);
var inst_23456 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23317);
var inst_23457 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23456);
var inst_23458 = cljs.core.vals(inst_23457);
var inst_23459 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23455,inst_23458);
var inst_23460 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23451,inst_23452,inst_23459);
var inst_23462 = (function (){var top_level_subject = inst_23311;
var select_spec = inst_23317;
var base_acc = inst_23331;
var acc_PLUS_refs = inst_23347;
var result = inst_23450;
var sort_preds = inst_23460;
return (function (acc,p__23461){
var vec__23475 = p__23461;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23475,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23475,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23475,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23475,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql_resp.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23463 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23462,inst_23450,inst_23460);
var state_23471__$1 = state_23471;
var statearr_23478_23561 = state_23471__$1;
(statearr_23478_23561[(2)] = inst_23463);

(statearr_23478_23561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (1))){
var state_23471__$1 = state_23471;
var statearr_23479_23562 = state_23471__$1;
(statearr_23479_23562[(2)] = null);

(statearr_23479_23562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (24))){
var inst_23347 = (state_23471[(10)]);
var inst_23347__$1 = (state_23471[(2)]);
var inst_23348 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"p","p",151049309),flakes);
var inst_23349 = cljs.core.PersistentHashMap.EMPTY;
var inst_23350 = inst_23348;
var inst_23351 = inst_23347__$1;
var inst_23352 = inst_23349;
var state_23471__$1 = (function (){var statearr_23480 = state_23471;
(statearr_23480[(11)] = inst_23351);

(statearr_23480[(12)] = inst_23350);

(statearr_23480[(10)] = inst_23347__$1);

(statearr_23480[(13)] = inst_23352);

return statearr_23480;
})();
var statearr_23481_23563 = state_23471__$1;
(statearr_23481_23563[(2)] = null);

(statearr_23481_23563[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (39))){
var inst_23367 = (state_23471[(14)]);
var inst_23351 = (state_23471[(11)]);
var inst_23317 = (state_23471[(9)]);
var inst_23360 = (state_23471[(15)]);
var inst_23396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23397 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23351,inst_23317,inst_23360,inst_23367,false);
var state_23471__$1 = (function (){var statearr_23482 = state_23471;
(statearr_23482[(16)] = inst_23396);

return statearr_23482;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23471__$1,(42),inst_23397);
} else {
if((state_val_23472 === (46))){
var inst_23350 = (state_23471[(12)]);
var inst_23360 = (state_23471[(15)]);
var inst_23352 = (state_23471[(13)]);
var inst_23414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23415 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23416 = cljs.core.first(inst_23360);
var inst_23417 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23416);
var inst_23418 = [inst_23417];
var inst_23419 = cljs.core.PersistentHashMap.fromArrays(inst_23415,inst_23418);
var inst_23420 = cljs.core.rest(inst_23350);
var inst_23421 = [inst_23419,inst_23420,inst_23352];
var inst_23422 = (new cljs.core.PersistentVector(null,3,(5),inst_23414,inst_23421,null));
var state_23471__$1 = state_23471;
var statearr_23483_23564 = state_23471__$1;
(statearr_23483_23564[(2)] = inst_23422);

(statearr_23483_23564[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (4))){
var inst_23291 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
var statearr_23484_23565 = state_23471__$1;
(statearr_23484_23565[(2)] = inst_23291);

(statearr_23484_23565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (15))){
var inst_23318 = (state_23471[(17)]);
var inst_23317 = (state_23471[(9)]);
var inst_23317__$1 = (state_23471[(2)]);
var inst_23318__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23317__$1);
var state_23471__$1 = (function (){var statearr_23485 = state_23471;
(statearr_23485[(17)] = inst_23318__$1);

(statearr_23485[(9)] = inst_23317__$1);

return statearr_23485;
})();
if(cljs.core.truth_(inst_23318__$1)){
var statearr_23486_23566 = state_23471__$1;
(statearr_23486_23566[(1)] = (16));

} else {
var statearr_23487_23567 = state_23471__$1;
(statearr_23487_23567[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (48))){
var inst_23433 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
var statearr_23488_23568 = state_23471__$1;
(statearr_23488_23568[(2)] = inst_23433);

(statearr_23488_23568[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (50))){
var state_23471__$1 = state_23471;
var statearr_23489_23569 = state_23471__$1;
(statearr_23489_23569[(2)] = null);

(statearr_23489_23569[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (21))){
var inst_23317 = (state_23471[(9)]);
var inst_23331 = (state_23471[(2)]);
var inst_23332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23333 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23334 = (new cljs.core.PersistentVector(null,2,(5),inst_23332,inst_23333,null));
var inst_23335 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23317,inst_23334);
var state_23471__$1 = (function (){var statearr_23490 = state_23471;
(statearr_23490[(8)] = inst_23331);

return statearr_23490;
})();
if(cljs.core.truth_(inst_23335)){
var statearr_23491_23570 = state_23471__$1;
(statearr_23491_23570[(1)] = (22));

} else {
var statearr_23492_23571 = state_23471__$1;
(statearr_23492_23571[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (31))){
var inst_23351 = (state_23471[(11)]);
var inst_23366 = (state_23471[(18)]);
var inst_23360 = (state_23471[(15)]);
var inst_23370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23371 = fluree.db.query.fql_resp.flake__GT_recur(db,inst_23360,inst_23366,inst_23351,fuel,max_fuel,cache);
var state_23471__$1 = (function (){var statearr_23493 = state_23471;
(statearr_23493[(19)] = inst_23370);

return statearr_23493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23471__$1,(34),inst_23371);
} else {
if((state_val_23472 === (32))){
var inst_23366 = (state_23471[(18)]);
var state_23471__$1 = state_23471;
if(cljs.core.truth_(inst_23366)){
var statearr_23494_23572 = state_23471__$1;
(statearr_23494_23572[(1)] = (35));

} else {
var statearr_23495_23573 = state_23471__$1;
(statearr_23495_23573[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (40))){
var inst_23407 = (state_23471[(20)]);
var inst_23317 = (state_23471[(9)]);
var inst_23406 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23317);
var inst_23407__$1 = cljs.core.empty_QMARK_(inst_23406);
var state_23471__$1 = (function (){var statearr_23496 = state_23471;
(statearr_23496[(20)] = inst_23407__$1);

return statearr_23496;
})();
if(inst_23407__$1){
var statearr_23497_23574 = state_23471__$1;
(statearr_23497_23574[(1)] = (43));

} else {
var statearr_23498_23575 = state_23471__$1;
(statearr_23498_23575[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (33))){
var inst_23360 = (state_23471[(15)]);
var inst_23439 = (state_23471[(2)]);
var inst_23440 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23439,(0),null);
var inst_23441 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23439,(1),null);
var inst_23442 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23439,(2),null);
var inst_23443 = cljs.core.first(inst_23360);
var inst_23444 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(inst_23443);
var inst_23445 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23440,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23444);
var inst_23350 = inst_23441;
var inst_23351 = inst_23445;
var inst_23352 = inst_23442;
var state_23471__$1 = (function (){var statearr_23499 = state_23471;
(statearr_23499[(11)] = inst_23351);

(statearr_23499[(12)] = inst_23350);

(statearr_23499[(13)] = inst_23352);

return statearr_23499;
})();
var statearr_23500_23576 = state_23471__$1;
(statearr_23500_23576[(2)] = null);

(statearr_23500_23576[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (13))){
var inst_23311 = (state_23471[(7)]);
var inst_23314 = fluree.db.query.fql_resp.full_select_spec(db,cache,base_select_spec,inst_23311);
var state_23471__$1 = state_23471;
var statearr_23501_23577 = state_23471__$1;
(statearr_23501_23577[(2)] = inst_23314);

(statearr_23501_23577[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (22))){
var inst_23317 = (state_23471[(9)]);
var inst_23337 = cljs.core.first(flakes);
var inst_23338 = fluree.db.flake.s(inst_23337);
var inst_23339 = fluree.db.query.fql_resp.select_spec__GT_reverse_pred_specs(inst_23317);
var inst_23340 = fluree.db.query.fql_resp.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23338,inst_23339);
var state_23471__$1 = state_23471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23471__$1,(25),inst_23340);
} else {
if((state_val_23472 === (36))){
var inst_23317 = (state_23471[(9)]);
var inst_23394 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23317);
var state_23471__$1 = state_23471;
if(cljs.core.truth_(inst_23394)){
var statearr_23502_23578 = state_23471__$1;
(statearr_23502_23578[(1)] = (39));

} else {
var statearr_23503_23579 = state_23471__$1;
(statearr_23503_23579[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (41))){
var inst_23435 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
var statearr_23504_23580 = state_23471__$1;
(statearr_23504_23580[(2)] = inst_23435);

(statearr_23504_23580[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (43))){
var inst_23317 = (state_23471[(9)]);
var inst_23409 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23317);
var state_23471__$1 = state_23471;
var statearr_23505_23581 = state_23471__$1;
(statearr_23505_23581[(2)] = inst_23409);

(statearr_23505_23581[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (29))){
var inst_23350 = (state_23471[(12)]);
var inst_23317 = (state_23471[(9)]);
var inst_23366 = (state_23471[(18)]);
var inst_23360 = (state_23471[(15)]);
var inst_23360__$1 = cljs.core.first(inst_23350);
var inst_23361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23362 = cljs.core.first(inst_23360__$1);
var inst_23363 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_23362);
var inst_23364 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23363];
var inst_23365 = (new cljs.core.PersistentVector(null,3,(5),inst_23361,inst_23364,null));
var inst_23366__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23317,inst_23365);
var inst_23367 = fluree.db.query.fql_resp.component_follow_QMARK_(inst_23366__$1,inst_23317);
var inst_23368 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23366__$1);
var state_23471__$1 = (function (){var statearr_23506 = state_23471;
(statearr_23506[(14)] = inst_23367);

(statearr_23506[(18)] = inst_23366__$1);

(statearr_23506[(15)] = inst_23360__$1);

return statearr_23506;
})();
if(cljs.core.truth_(inst_23368)){
var statearr_23507_23582 = state_23471__$1;
(statearr_23507_23582[(1)] = (31));

} else {
var statearr_23508_23583 = state_23471__$1;
(statearr_23508_23583[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (44))){
var inst_23407 = (state_23471[(20)]);
var state_23471__$1 = state_23471;
var statearr_23509_23584 = state_23471__$1;
(statearr_23509_23584[(2)] = inst_23407);

(statearr_23509_23584[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (6))){
var state_23471__$1 = state_23471;
var statearr_23510_23585 = state_23471__$1;
(statearr_23510_23585[(2)] = null);

(statearr_23510_23585[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (28))){
var inst_23351 = (state_23471[(11)]);
var state_23471__$1 = state_23471;
var statearr_23511_23586 = state_23471__$1;
(statearr_23511_23586[(2)] = inst_23351);

(statearr_23511_23586[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (51))){
var inst_23431 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
var statearr_23512_23587 = state_23471__$1;
(statearr_23512_23587[(2)] = inst_23431);

(statearr_23512_23587[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (25))){
var inst_23331 = (state_23471[(8)]);
var inst_23342 = (state_23471[(2)]);
var inst_23343 = fluree.db.util.async.throw_err(inst_23342);
var inst_23344 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23331,inst_23343], 0));
var state_23471__$1 = state_23471;
var statearr_23513_23588 = state_23471__$1;
(statearr_23513_23588[(2)] = inst_23344);

(statearr_23513_23588[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (34))){
var inst_23350 = (state_23471[(12)]);
var inst_23370 = (state_23471[(19)]);
var inst_23352 = (state_23471[(13)]);
var inst_23373 = (state_23471[(2)]);
var inst_23374 = fluree.db.util.async.throw_err(inst_23373);
var inst_23375 = cljs.core.rest(inst_23350);
var inst_23376 = [inst_23374,inst_23375,inst_23352];
var inst_23377 = (new cljs.core.PersistentVector(null,3,(5),inst_23370,inst_23376,null));
var state_23471__$1 = state_23471;
var statearr_23514_23589 = state_23471__$1;
(statearr_23514_23589[(2)] = inst_23377);

(statearr_23514_23589[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (17))){
var inst_23317 = (state_23471[(9)]);
var inst_23321 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23317);
var state_23471__$1 = state_23471;
var statearr_23516_23590 = state_23471__$1;
(statearr_23516_23590[(2)] = inst_23321);

(statearr_23516_23590[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (3))){
var inst_23469 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23471__$1,inst_23469);
} else {
if((state_val_23472 === (12))){
var _ = (function (){var statearr_23517 = state_23471;
(statearr_23517[(4)] = cljs.core.rest((state_23471[(4)])));

return statearr_23517;
})();
var state_23471__$1 = state_23471;
var ex23515 = (state_23471__$1[(2)]);
var statearr_23518_23591 = state_23471__$1;
(statearr_23518_23591[(5)] = ex23515);


var statearr_23519_23592 = state_23471__$1;
(statearr_23519_23592[(1)] = (11));

(statearr_23519_23592[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (2))){
var _ = (function (){var statearr_23520 = state_23471;
(statearr_23520[(4)] = cljs.core.cons((5),(state_23471[(4)])));

return statearr_23520;
})();
var inst_23297 = cljs.core.not_empty(flakes);
var state_23471__$1 = state_23471;
if(cljs.core.truth_(inst_23297)){
var statearr_23521_23593 = state_23471__$1;
(statearr_23521_23593[(1)] = (6));

} else {
var statearr_23522_23594 = state_23471__$1;
(statearr_23522_23594[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (23))){
var inst_23331 = (state_23471[(8)]);
var state_23471__$1 = state_23471;
var statearr_23523_23595 = state_23471__$1;
(statearr_23523_23595[(2)] = inst_23331);

(statearr_23523_23595[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (47))){
var state_23471__$1 = state_23471;
var statearr_23524_23596 = state_23471__$1;
(statearr_23524_23596[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (35))){
var inst_23367 = (state_23471[(14)]);
var inst_23351 = (state_23471[(11)]);
var inst_23366 = (state_23471[(18)]);
var inst_23360 = (state_23471[(15)]);
var inst_23352 = (state_23471[(13)]);
var inst_23383 = fluree.db.query.fql_resp.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23351,inst_23366,inst_23360,inst_23367,false,inst_23352);
var state_23471__$1 = state_23471;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23471__$1,(38),inst_23383);
} else {
if((state_val_23472 === (19))){
var inst_23311 = (state_23471[(7)]);
var inst_23325 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23326 = [inst_23311];
var inst_23327 = cljs.core.PersistentHashMap.fromArrays(inst_23325,inst_23326);
var state_23471__$1 = state_23471;
var statearr_23526_23597 = state_23471__$1;
(statearr_23526_23597[(2)] = inst_23327);

(statearr_23526_23597[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (11))){
var inst_23299 = (state_23471[(2)]);
var inst_23300 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$1(inst_23299) : fluree.db.util.log.error.call(null,inst_23299));
var inst_23301 = (function(){throw inst_23299})();
var state_23471__$1 = (function (){var statearr_23528 = state_23471;
(statearr_23528[(21)] = inst_23300);

return statearr_23528;
})();
var statearr_23529_23598 = state_23471__$1;
(statearr_23529_23598[(2)] = inst_23301);

(statearr_23529_23598[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (9))){
var _ = (function (){var statearr_23530 = state_23471;
(statearr_23530[(4)] = cljs.core.cons((12),(state_23471[(4)])));

return statearr_23530;
})();
var inst_23307 = cljs.core.first(flakes);
var inst_23308 = fluree.db.flake.s(inst_23307);
var ___$1 = (function (){var statearr_23531 = state_23471;
(statearr_23531[(4)] = cljs.core.rest((state_23471[(4)])));

return statearr_23531;
})();
var state_23471__$1 = state_23471;
var statearr_23532_23599 = state_23471__$1;
(statearr_23532_23599[(2)] = inst_23308);

(statearr_23532_23599[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (5))){
var _ = (function (){var statearr_23533 = state_23471;
(statearr_23533[(4)] = cljs.core.rest((state_23471[(4)])));

return statearr_23533;
})();
var state_23471__$1 = state_23471;
var ex23527 = (state_23471__$1[(2)]);
var statearr_23534_23600 = state_23471__$1;
(statearr_23534_23600[(5)] = ex23527);


if((ex23527 instanceof Error)){
var statearr_23535_23601 = state_23471__$1;
(statearr_23535_23601[(1)] = (4));

(statearr_23535_23601[(5)] = null);

} else {
throw ex23527;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (14))){
var state_23471__$1 = state_23471;
var statearr_23536_23602 = state_23471__$1;
(statearr_23536_23602[(2)] = base_select_spec);

(statearr_23536_23602[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (45))){
var inst_23412 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
if(cljs.core.truth_(inst_23412)){
var statearr_23537_23603 = state_23471__$1;
(statearr_23537_23603[(1)] = (46));

} else {
var statearr_23538_23604 = state_23471__$1;
(statearr_23538_23604[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (26))){
var inst_23350 = (state_23471[(12)]);
var inst_23354 = cljs.core.empty_QMARK_(inst_23350);
var state_23471__$1 = state_23471;
if(inst_23354){
var statearr_23539_23605 = state_23471__$1;
(statearr_23539_23605[(1)] = (28));

} else {
var statearr_23540_23606 = state_23471__$1;
(statearr_23540_23606[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (16))){
var inst_23318 = (state_23471[(17)]);
var state_23471__$1 = state_23471;
var statearr_23541_23607 = state_23471__$1;
(statearr_23541_23607[(2)] = inst_23318);

(statearr_23541_23607[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (38))){
var inst_23350 = (state_23471[(12)]);
var inst_23385 = (state_23471[(2)]);
var inst_23386 = fluree.db.util.async.throw_err(inst_23385);
var inst_23387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23386,(0),null);
var inst_23388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23386,(1),null);
var inst_23389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23390 = cljs.core.rest(inst_23350);
var inst_23391 = [inst_23387,inst_23390,inst_23388];
var inst_23392 = (new cljs.core.PersistentVector(null,3,(5),inst_23389,inst_23391,null));
var state_23471__$1 = state_23471;
var statearr_23542_23608 = state_23471__$1;
(statearr_23542_23608[(2)] = inst_23392);

(statearr_23542_23608[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (30))){
var inst_23448 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
var statearr_23543_23609 = state_23471__$1;
(statearr_23543_23609[(2)] = inst_23448);

(statearr_23543_23609[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (10))){
var inst_23311 = (state_23471[(2)]);
var inst_23312 = fluree.db.query.fql_resp.has_ns_lookups_QMARK_(base_select_spec);
var state_23471__$1 = (function (){var statearr_23544 = state_23471;
(statearr_23544[(7)] = inst_23311);

return statearr_23544;
})();
if(cljs.core.truth_(inst_23312)){
var statearr_23545_23610 = state_23471__$1;
(statearr_23545_23610[(1)] = (13));

} else {
var statearr_23546_23611 = state_23471__$1;
(statearr_23546_23611[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (18))){
var inst_23323 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
if(cljs.core.truth_(inst_23323)){
var statearr_23547_23612 = state_23471__$1;
(statearr_23547_23612[(1)] = (19));

} else {
var statearr_23548_23613 = state_23471__$1;
(statearr_23548_23613[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (42))){
var inst_23350 = (state_23471[(12)]);
var inst_23352 = (state_23471[(13)]);
var inst_23396 = (state_23471[(16)]);
var inst_23399 = (state_23471[(2)]);
var inst_23400 = fluree.db.util.async.throw_err(inst_23399);
var inst_23401 = cljs.core.first(inst_23400);
var inst_23402 = cljs.core.rest(inst_23350);
var inst_23403 = [inst_23401,inst_23402,inst_23352];
var inst_23404 = (new cljs.core.PersistentVector(null,3,(5),inst_23396,inst_23403,null));
var state_23471__$1 = state_23471;
var statearr_23549_23614 = state_23471__$1;
(statearr_23549_23614[(2)] = inst_23404);

(statearr_23549_23614[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (37))){
var inst_23437 = (state_23471[(2)]);
var state_23471__$1 = state_23471;
var statearr_23550_23615 = state_23471__$1;
(statearr_23550_23615[(2)] = inst_23437);

(statearr_23550_23615[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (8))){
var inst_23466 = (state_23471[(2)]);
var _ = (function (){var statearr_23551 = state_23471;
(statearr_23551[(4)] = cljs.core.rest((state_23471[(4)])));

return statearr_23551;
})();
var state_23471__$1 = state_23471;
var statearr_23552_23616 = state_23471__$1;
(statearr_23552_23616[(2)] = inst_23466);

(statearr_23552_23616[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23472 === (49))){
var inst_23351 = (state_23471[(11)]);
var inst_23350 = (state_23471[(12)]);
var inst_23352 = (state_23471[(13)]);
var inst_23425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23426 = cljs.core.rest(inst_23350);
var inst_23427 = [inst_23351,inst_23426,inst_23352];
var inst_23428 = (new cljs.core.PersistentVector(null,3,(5),inst_23425,inst_23427,null));
var state_23471__$1 = state_23471;
var statearr_23553_23617 = state_23471__$1;
(statearr_23553_23617[(2)] = inst_23428);

(statearr_23553_23617[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = null;
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0 = (function (){
var statearr_23554 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23554[(0)] = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__);

(statearr_23554[(1)] = (1));

return statearr_23554;
});
var fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1 = (function (state_23471){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_23471);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e23555){var ex__2730__auto__ = e23555;
var statearr_23556_23618 = state_23471;
(statearr_23556_23618[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_23471[(4)]))){
var statearr_23557_23619 = state_23471;
(statearr_23557_23619[(1)] = cljs.core.first((state_23471[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23620 = state_23471;
state_23471 = G__23620;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__ = function(state_23471){
switch(arguments.length){
case 0:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1.call(this,state_23471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____0;
fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto____1;
return fluree$db$query$fql_resp$flakes__GT_res_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_23558 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_23558[(6)] = c__2749__auto__);

return statearr_23558;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
