// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19917_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19917_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__19921 = coll;
var vec__19922 = G__19921;
var seq__19923 = cljs.core.seq(vec__19922);
var first__19924 = cljs.core.first(seq__19923);
var seq__19923__$1 = cljs.core.next(seq__19923);
var clause = first__19924;
var r = seq__19923__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19921__$1 = G__19921;
var res__$1 = res;
while(true){
var vec__19928 = G__19921__$1;
var seq__19929 = cljs.core.seq(vec__19928);
var first__19930 = cljs.core.first(seq__19929);
var seq__19929__$1 = cljs.core.next(seq__19929);
var clause__$1 = first__19930;
var r__$1 = seq__19929__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19931 = r__$1;
var G__19932 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19921__$1 = G__19931;
res__$1 = G__19932;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__19933){
var map__19934 = p__19933;
var map__19934__$1 = cljs.core.__destructure_map(map__19934);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19934__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__19938 = coll;
var vec__19939 = G__19938;
var seq__19940 = cljs.core.seq(vec__19939);
var first__19941 = cljs.core.first(seq__19940);
var seq__19940__$1 = cljs.core.next(seq__19940);
var clause = first__19941;
var r = seq__19940__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19938__$1 = G__19938;
var res__$1 = res;
while(true){
var vec__19945 = G__19938__$1;
var seq__19946 = cljs.core.seq(vec__19945);
var first__19947 = cljs.core.first(seq__19946);
var seq__19946__$1 = cljs.core.next(seq__19946);
var clause__$1 = first__19947;
var r__$1 = seq__19946__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19948 = r__$1;
var G__19949 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__19938__$1 = G__19948;
res__$1 = G__19949;
continue;
} else {
var G__19950 = r__$1;
var G__19951 = res__$2;
G__19938__$1 = G__19950;
res__$1 = G__19951;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__19955 = coll;
var vec__19956 = G__19955;
var seq__19957 = cljs.core.seq(vec__19956);
var first__19958 = cljs.core.first(seq__19957);
var seq__19957__$1 = cljs.core.next(seq__19957);
var clause = first__19958;
var r = seq__19957__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__19955__$1 = G__19955;
var res__$1 = res;
while(true){
var vec__19962 = G__19955__$1;
var seq__19963 = cljs.core.seq(vec__19962);
var first__19964 = cljs.core.first(seq__19963);
var seq__19963__$1 = cljs.core.next(seq__19963);
var clause__$1 = first__19964;
var r__$1 = seq__19963__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__19965 = r__$1;
var G__19966 = res__$2;
G__19955__$1 = G__19965;
res__$1 = G__19966;
continue;
} else {
var G__19967 = r__$1;
var G__19968 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__19955__$1 = G__19967;
res__$1 = G__19968;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__19971 = clause;
var G__19971__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__19971):G__19971);
var G__19971__$2 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__19971__$1)
;
var G__19971__$3 = (function (){var fexpr__19972 = (function (p1__19969_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19969_SHARP_)," ."].join('');
});
return fexpr__19972(G__19971__$2);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__19973 = (function (p1__19970_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19970_SHARP_),"}"].join('');
});
return fexpr__19973(G__19971__$3);
} else {
return G__19971__$3;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__19977 = opts;
var map__19977__$1 = cljs.core.__destructure_map(map__19977);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19977__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19977__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19977__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19977__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19977__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__19974_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__19974_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19975_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19975_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__19976_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__19976_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = language;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_19991){
var state_val_19992 = (state_19991[(1)]);
if((state_val_19992 === (1))){
var inst_19978 = fluree.db.util.core.url_encode(query);
var inst_19979 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19978)].join('');
var inst_19980 = ["User-Agent","Accept"];
var inst_19981 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_19982 = cljs.core.PersistentHashMap.fromArrays(inst_19980,inst_19981);
var inst_19983 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_19984 = [inst_19982,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_19985 = cljs.core.PersistentHashMap.fromArrays(inst_19983,inst_19984);
var inst_19986 = fluree.db.util.xhttp.get(inst_19979,inst_19985);
var state_19991__$1 = state_19991;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19991__$1,(2),inst_19986);
} else {
if((state_val_19992 === (2))){
var inst_19988 = (state_19991[(2)]);
var inst_19989 = fluree.db.util.async.throw_err(inst_19988);
var state_19991__$1 = state_19991;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19991__$1,inst_19989);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_19993 = [null,null,null,null,null,null,null];
(statearr_19993[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__);

(statearr_19993[(1)] = (1));

return statearr_19993;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1 = (function (state_19991){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_19991);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e19994){var ex__2730__auto__ = e19994;
var statearr_19995_19998 = state_19991;
(statearr_19995_19998[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_19991[(4)]))){
var statearr_19996_19999 = state_19991;
(statearr_19996_19999[(1)] = cljs.core.first((state_19991[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20000 = state_19991;
state_19991 = G__20000;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__ = function(state_19991){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1.call(this,state_19991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_19997 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_19997[(6)] = c__2749__auto__);

return statearr_19997;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20018){
var state_val_20019 = (state_20018[(1)]);
if((state_val_20019 === (1))){
var inst_20001 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_20018__$1 = state_20018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20018__$1,(2),inst_20001);
} else {
if((state_val_20019 === (2))){
var inst_20004 = (state_20018[(7)]);
var inst_20003 = (state_20018[(2)]);
var inst_20004__$1 = fluree.db.util.async.throw_err(inst_20003);
var inst_20005 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_20004__$1);
var inst_20006 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_20005);
var state_20018__$1 = (function (){var statearr_20020 = state_20018;
(statearr_20020[(7)] = inst_20004__$1);

return statearr_20020;
})();
if(inst_20006){
var statearr_20021_20030 = state_20018__$1;
(statearr_20021_20030[(1)] = (3));

} else {
var statearr_20022_20031 = state_20018__$1;
(statearr_20022_20031[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20019 === (3))){
var inst_20004 = (state_20018[(7)]);
var state_20018__$1 = state_20018;
var statearr_20023_20032 = state_20018__$1;
(statearr_20023_20032[(2)] = inst_20004);

(statearr_20023_20032[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20019 === (4))){
var inst_20004 = (state_20018[(7)]);
var inst_20009 = (function (){var body = inst_20004;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_20010 = cljs.core.second(inst_20004);
var inst_20011 = cljs.core.second(inst_20010);
var inst_20012 = cljs.core.first(inst_20011);
var inst_20013 = cljs.core.second(inst_20012);
var inst_20014 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_20009,inst_20013);
var state_20018__$1 = state_20018;
var statearr_20024_20033 = state_20018__$1;
(statearr_20024_20033[(2)] = inst_20014);

(statearr_20024_20033[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20019 === (5))){
var inst_20016 = (state_20018[(2)]);
var state_20018__$1 = state_20018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20018__$1,inst_20016);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0 = (function (){
var statearr_20025 = [null,null,null,null,null,null,null,null];
(statearr_20025[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__);

(statearr_20025[(1)] = (1));

return statearr_20025;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1 = (function (state_20018){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20018);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20026){var ex__2730__auto__ = e20026;
var statearr_20027_20034 = state_20018;
(statearr_20027_20034[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20018[(4)]))){
var statearr_20028_20035 = state_20018;
(statearr_20028_20035[(1)] = cljs.core.first((state_20018[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20036 = state_20018;
state_20018 = G__20036;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__ = function(state_20018){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1.call(this,state_20018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20029 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20029[(6)] = c__2749__auto__);

return statearr_20029;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20037_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20037_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20038_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__20038_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20039_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__20039_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__20039_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__20039_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20085){
var state_val_20086 = (state_20085[(1)]);
if((state_val_20086 === (7))){
var inst_20050 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_20085__$1 = state_20085;
var statearr_20087_20115 = state_20085__$1;
(statearr_20087_20115[(2)] = inst_20050);

(statearr_20087_20115[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (1))){
var state_20085__$1 = state_20085;
var statearr_20088_20116 = state_20085__$1;
(statearr_20088_20116[(2)] = null);

(statearr_20088_20116[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (4))){
var inst_20040 = (state_20085[(2)]);
var state_20085__$1 = state_20085;
var statearr_20089_20117 = state_20085__$1;
(statearr_20089_20117[(2)] = inst_20040);

(statearr_20089_20117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (15))){
var inst_20058 = (state_20085[(7)]);
var inst_20059 = (state_20085[(8)]);
var inst_20064 = (state_20085[(9)]);
var inst_20069 = (state_20085[(2)]);
var inst_20070 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_20064,(0),inst_20069);
var inst_20071 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20072 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_20058);
var inst_20073 = [inst_20059,inst_20072];
var inst_20074 = cljs.core.PersistentHashMap.fromArrays(inst_20071,inst_20073);
var inst_20075 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20070,inst_20074);
var inst_20076 = (function(){throw inst_20075})();
var state_20085__$1 = state_20085;
var statearr_20090_20118 = state_20085__$1;
(statearr_20090_20118[(2)] = inst_20076);

(statearr_20090_20118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (13))){
var inst_20063 = (state_20085[(10)]);
var state_20085__$1 = state_20085;
var statearr_20091_20119 = state_20085__$1;
(statearr_20091_20119[(2)] = inst_20063);

(statearr_20091_20119[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (6))){
var state_20085__$1 = state_20085;
var statearr_20092_20120 = state_20085__$1;
(statearr_20092_20120[(2)] = null);

(statearr_20092_20120[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (3))){
var inst_20083 = (state_20085[(2)]);
var state_20085__$1 = state_20085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20085__$1,inst_20083);
} else {
if((state_val_20086 === (12))){
var inst_20080 = (state_20085[(2)]);
var _ = (function (){var statearr_20093 = state_20085;
(statearr_20093[(4)] = cljs.core.rest((state_20085[(4)])));

return statearr_20093;
})();
var state_20085__$1 = state_20085;
var statearr_20094_20121 = state_20085__$1;
(statearr_20094_20121[(2)] = inst_20080);

(statearr_20094_20121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (2))){
var _ = (function (){var statearr_20095 = state_20085;
(statearr_20095[(4)] = cljs.core.cons((5),(state_20085[(4)])));

return statearr_20095;
})();
var inst_20047 = cljs.core.empty_QMARK_(matching_vars);
var state_20085__$1 = state_20085;
if(inst_20047){
var statearr_20096_20122 = state_20085__$1;
(statearr_20096_20122[(1)] = (6));

} else {
var statearr_20097_20123 = state_20085__$1;
(statearr_20097_20123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (11))){
var inst_20058 = (state_20085[(7)]);
var inst_20078 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_20058,all_vars);
var state_20085__$1 = state_20085;
var statearr_20099_20124 = state_20085__$1;
(statearr_20099_20124[(2)] = inst_20078);

(statearr_20099_20124[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (9))){
var inst_20058 = (state_20085[(7)]);
var inst_20059 = (state_20085[(8)]);
var inst_20056 = (state_20085[(2)]);
var inst_20057 = fluree.db.util.async.throw_err(inst_20056);
var inst_20058__$1 = cljs.core.__destructure_map(inst_20057);
var inst_20059__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20058__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_20060 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20058__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_20061 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_20059__$1);
var state_20085__$1 = (function (){var statearr_20100 = state_20085;
(statearr_20100[(7)] = inst_20058__$1);

(statearr_20100[(11)] = inst_20060);

(statearr_20100[(8)] = inst_20059__$1);

return statearr_20100;
})();
if(inst_20061){
var statearr_20101_20125 = state_20085__$1;
(statearr_20101_20125[(1)] = (10));

} else {
var statearr_20102_20126 = state_20085__$1;
(statearr_20102_20126[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (5))){
var _ = (function (){var statearr_20103 = state_20085;
(statearr_20103[(4)] = cljs.core.rest((state_20085[(4)])));

return statearr_20103;
})();
var state_20085__$1 = state_20085;
var ex20098 = (state_20085__$1[(2)]);
var statearr_20104_20127 = state_20085__$1;
(statearr_20104_20127[(5)] = ex20098);


if((ex20098 instanceof Error)){
var statearr_20105_20128 = state_20085__$1;
(statearr_20105_20128[(1)] = (4));

(statearr_20105_20128[(5)] = null);

} else {
throw ex20098;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (14))){
var state_20085__$1 = state_20085;
var statearr_20106_20129 = state_20085__$1;
(statearr_20106_20129[(2)] = (1000));

(statearr_20106_20129[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (10))){
var inst_20063 = (state_20085[(10)]);
var inst_20058 = (state_20085[(7)]);
var inst_20060 = (state_20085[(11)]);
var inst_20063__$1 = cljs.core.count(inst_20060);
var inst_20064 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_20058);
var inst_20065 = (inst_20063__$1 < (1000));
var state_20085__$1 = (function (){var statearr_20107 = state_20085;
(statearr_20107[(10)] = inst_20063__$1);

(statearr_20107[(9)] = inst_20064);

return statearr_20107;
})();
if(cljs.core.truth_(inst_20065)){
var statearr_20108_20130 = state_20085__$1;
(statearr_20108_20130[(1)] = (13));

} else {
var statearr_20109_20131 = state_20085__$1;
(statearr_20109_20131[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20086 === (8))){
var inst_20052 = (state_20085[(2)]);
var inst_20053 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_20052,optional_clauses);
var inst_20054 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_20053);
var state_20085__$1 = state_20085;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20085__$1,(9),inst_20054);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20110 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20110[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__);

(statearr_20110[(1)] = (1));

return statearr_20110;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1 = (function (state_20085){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20085);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20111){var ex__2730__auto__ = e20111;
var statearr_20112_20132 = state_20085;
(statearr_20112_20132[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20085[(4)]))){
var statearr_20113_20133 = state_20085;
(statearr_20113_20133[(1)] = cljs.core.first((state_20085[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20134 = state_20085;
state_20085 = G__20134;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__ = function(state_20085){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1.call(this,state_20085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20114 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20114[(6)] = c__2749__auto__);

return statearr_20114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
