// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.query.analytical_parse');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e20137){var e = e20137;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__20138_SHARP_){
var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__20138_SHARP_);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__20138_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__20138_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__20138_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20139_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20139_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20140_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20140_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
if(and__5043__auto__){
return fluree.db.query.analytical_parse.query_fn_QMARK_(key);
} else {
return and__5043__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__5045__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__20145 = fluree.db.query.analytical_filter.extract_filter_fn(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20145,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20145,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20141_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20141_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__5043__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__5043__auto__;
}
})())){
var vec__20148 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20148,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20148,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__5045__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20142_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20142_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20143_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20143_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__20144_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__20144_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
/**
 * Returns an updated list of tuples that only contains tuple indexes from idx.
 *   e.g.:
 *   idx is a list of indexes, eg. [2 0 4]
 *   Thus, the return will be 3-tuples of nth 2, 0, 4 respectively.
 */
fluree.db.query.analytical.transform_tuples_to_idxs = (function fluree$db$query$analytical$transform_tuples_to_idxs(idxs,tuples){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (tuple){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20151_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__20151_SHARP_);
}),idxs);
}),tuples);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5802__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5802__auto__)){
var var$__$1 = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
/**
 * Returns index positions of vars within headers.
 *   e.g. if vars were:
 *   ['?e '?name]
 *   and headers were:
 *   ['?email '?name '?x '?e]
 *   The return value would be: [3 1]
 */
fluree.db.query.analytical.get_tuple_indexes = (function fluree$db$query$analytical$get_tuple_indexes(vars,headers){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5802__auto__ = (function (){var or__5045__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5802__auto__)){
var var$ = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(headers,var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. ","Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var idxs = fluree.db.query.analytical.get_tuple_indexes(vars,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
return fluree.db.query.analytical.transform_tuples_to_idxs(idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__5043__auto__ = max_fuel;
if(cljs.core.truth_(and__5043__auto__)){
return (add_amount > max_fuel);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = fuel;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__5043__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5802__auto__ = (function (){var G__20152 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__20152) : intersecting_vars.call(null,G__20152));
})();
if(cljs.core.truth_(temp__5802__auto__)){
var key_replace = temp__5802__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__20155,optional_QMARK_,fuel,max_fuel){
var map__20156 = p__20155;
var map__20156__$1 = cljs.core.__destructure_map(map__20156);
var res = map__20156__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20156__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20222){
var state_val_20223 = (state_20222[(1)]);
if((state_val_20223 === (7))){
var inst_20211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20212 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_20213 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_20212,clause);
var inst_20214 = [null,inst_20213];
var inst_20215 = (new cljs.core.PersistentVector(null,2,(5),inst_20211,inst_20214,null));
var state_20222__$1 = state_20222;
var statearr_20224_20252 = state_20222__$1;
(statearr_20224_20252[(2)] = inst_20215);

(statearr_20224_20252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (1))){
var state_20222__$1 = state_20222;
var statearr_20225_20253 = state_20222__$1;
(statearr_20225_20253[(2)] = null);

(statearr_20225_20253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (4))){
var inst_20157 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20226_20254 = state_20222__$1;
(statearr_20226_20254[(2)] = inst_20157);

(statearr_20226_20254[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (15))){
var inst_20200 = (state_20222[(2)]);
var inst_20201 = fluree.db.util.async.throw_err(inst_20200);
var inst_20202 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_20201);
var inst_20203 = cljs.core.count(inst_20202);
var inst_20204 = fluree.db.query.analytical.add_fuel(inst_20203,fuel,max_fuel);
var inst_20205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20206 = [inst_20201,r];
var inst_20207 = (new cljs.core.PersistentVector(null,2,(5),inst_20205,inst_20206,null));
var state_20222__$1 = (function (){var statearr_20227 = state_20222;
(statearr_20227[(7)] = inst_20204);

return statearr_20227;
})();
var statearr_20228_20255 = state_20222__$1;
(statearr_20228_20255[(2)] = inst_20207);

(statearr_20228_20255[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (13))){
var inst_20166 = (state_20222[(8)]);
var inst_20179 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20180 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_20179);
var inst_20181 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20166);
var inst_20182 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20181);
var inst_20183 = cljs.core.set(inst_20182);
var inst_20184 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_20180);
var inst_20185 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20184);
var inst_20186 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20183,inst_20185);
var inst_20187 = (function (){var all_wd = inst_20166;
var optional = inst_20180;
var all_wd_vars = inst_20183;
var all_vars = inst_20186;
return (function (p1__20153_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__20153_SHARP_) : all_vars.call(null,p1__20153_SHARP_));
});
})();
var inst_20188 = cljs.core.keys(vars);
var inst_20189 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20187,inst_20188);
var inst_20190 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_20189);
var inst_20191 = cljs.core.set(inst_20190);
var inst_20192 = (function (){var all_wd = inst_20166;
var optional = inst_20180;
var all_wd_vars = inst_20183;
var all_vars = inst_20186;
var intersecting_vars = inst_20191;
return (function (p1__20154_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__20154_SHARP_);
});
})();
var inst_20193 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20192,inst_20166);
var inst_20194 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_20193);
var inst_20195 = fluree.db.query.analytical.select_from_tuples(inst_20194,res);
var inst_20196 = fluree.db.query.analytical.replace_vars_wikidata(inst_20166,inst_20191,vars);
var inst_20197 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_20191,inst_20186);
var inst_20198 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_20196,inst_20194,inst_20195,inst_20197,inst_20180);
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20222__$1,(15),inst_20198);
} else {
if((state_val_20223 === (6))){
var inst_20167 = (state_20222[(9)]);
var inst_20165 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_20166 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_20165);
var inst_20167__$1 = optional_QMARK_;
var state_20222__$1 = (function (){var statearr_20229 = state_20222;
(statearr_20229[(9)] = inst_20167__$1);

(statearr_20229[(8)] = inst_20166);

return statearr_20229;
})();
if(cljs.core.truth_(inst_20167__$1)){
var statearr_20230_20256 = state_20222__$1;
(statearr_20230_20256[(1)] = (9));

} else {
var statearr_20231_20257 = state_20222__$1;
(statearr_20231_20257[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (3))){
var inst_20220 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20222__$1,inst_20220);
} else {
if((state_val_20223 === (12))){
var inst_20175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20176 = [null,r];
var inst_20177 = (new cljs.core.PersistentVector(null,2,(5),inst_20175,inst_20176,null));
var state_20222__$1 = state_20222;
var statearr_20232_20258 = state_20222__$1;
(statearr_20232_20258[(2)] = inst_20177);

(statearr_20232_20258[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (2))){
var _ = (function (){var statearr_20233 = state_20222;
(statearr_20233[(4)] = cljs.core.cons((5),(state_20222[(4)])));

return statearr_20233;
})();
var inst_20163 = (r == null);
var state_20222__$1 = state_20222;
if(cljs.core.truth_(inst_20163)){
var statearr_20234_20259 = state_20222__$1;
(statearr_20234_20259[(1)] = (6));

} else {
var statearr_20235_20260 = state_20222__$1;
(statearr_20235_20260[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (11))){
var inst_20173 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
if(cljs.core.truth_(inst_20173)){
var statearr_20237_20261 = state_20222__$1;
(statearr_20237_20261[(1)] = (12));

} else {
var statearr_20238_20262 = state_20222__$1;
(statearr_20238_20262[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (9))){
var inst_20166 = (state_20222[(8)]);
var inst_20169 = cljs.core.empty_QMARK_(inst_20166);
var inst_20170 = (!(inst_20169));
var state_20222__$1 = state_20222;
var statearr_20239_20263 = state_20222__$1;
(statearr_20239_20263[(2)] = inst_20170);

(statearr_20239_20263[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (5))){
var _ = (function (){var statearr_20240 = state_20222;
(statearr_20240[(4)] = cljs.core.rest((state_20222[(4)])));

return statearr_20240;
})();
var state_20222__$1 = state_20222;
var ex20236 = (state_20222__$1[(2)]);
var statearr_20241_20264 = state_20222__$1;
(statearr_20241_20264[(5)] = ex20236);


if((ex20236 instanceof Error)){
var statearr_20242_20265 = state_20222__$1;
(statearr_20242_20265[(1)] = (4));

(statearr_20242_20265[(5)] = null);

} else {
throw ex20236;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (14))){
var inst_20209 = (state_20222[(2)]);
var state_20222__$1 = state_20222;
var statearr_20243_20266 = state_20222__$1;
(statearr_20243_20266[(2)] = inst_20209);

(statearr_20243_20266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (10))){
var inst_20167 = (state_20222[(9)]);
var state_20222__$1 = state_20222;
var statearr_20244_20267 = state_20222__$1;
(statearr_20244_20267[(2)] = inst_20167);

(statearr_20244_20267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20223 === (8))){
var inst_20217 = (state_20222[(2)]);
var _ = (function (){var statearr_20245 = state_20222;
(statearr_20245[(4)] = cljs.core.rest((state_20222[(4)])));

return statearr_20245;
})();
var state_20222__$1 = state_20222;
var statearr_20246_20268 = state_20222__$1;
(statearr_20246_20268[(2)] = inst_20217);

(statearr_20246_20268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20247 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20247[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__);

(statearr_20247[(1)] = (1));

return statearr_20247;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20222){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20222);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20248){var ex__2730__auto__ = e20248;
var statearr_20249_20269 = state_20222;
(statearr_20249_20269[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20222[(4)]))){
var statearr_20250_20270 = state_20222;
(statearr_20250_20270[(1)] = cljs.core.first((state_20222[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20271 = state_20222;
state_20222 = G__20271;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__ = function(state_20222){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20251 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20251[(6)] = c__2749__auto__);

return statearr_20251;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(ledger_id){
return cljs.core.re_find(/[a-z]+/,ledger_id);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(ledger_id){
return cljs.core.re_find(/[A-Z0-9]+/,ledger_id);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__20273 = arguments.length;
switch (G__20273) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20367){
var state_val_20368 = (state_20367[(1)]);
if((state_val_20368 === (7))){
var inst_20280 = (state_20367[(7)]);
var inst_20290 = clojure.string.starts_with_QMARK_(inst_20280,"$fdb");
var state_20367__$1 = state_20367;
if(inst_20290){
var statearr_20369_20418 = state_20367__$1;
(statearr_20369_20418[(1)] = (9));

} else {
var statearr_20370_20419 = state_20367__$1;
(statearr_20370_20419[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (20))){
var state_20367__$1 = state_20367;
var statearr_20371_20420 = state_20367__$1;
(statearr_20371_20420[(2)] = null);

(statearr_20371_20420[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (27))){
var inst_20330 = (state_20367[(8)]);
var state_20367__$1 = state_20367;
var statearr_20372_20421 = state_20367__$1;
(statearr_20372_20421[(2)] = inst_20330);

(statearr_20372_20421[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (1))){
var state_20367__$1 = state_20367;
var statearr_20373_20422 = state_20367__$1;
(statearr_20373_20422[(2)] = null);

(statearr_20373_20422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (24))){
var inst_20353 = (state_20367[(2)]);
var state_20367__$1 = state_20367;
var statearr_20374_20423 = state_20367__$1;
(statearr_20374_20423[(2)] = inst_20353);

(statearr_20374_20423[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (4))){
var inst_20274 = (state_20367[(2)]);
var state_20367__$1 = state_20367;
var statearr_20375_20424 = state_20367__$1;
(statearr_20375_20424[(2)] = inst_20274);

(statearr_20375_20424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (15))){
var inst_20297 = (state_20367[(9)]);
var inst_20303 = (state_20367[(2)]);
var inst_20304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20305 = cljs.core.PersistentVector.EMPTY;
var inst_20306 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20307 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20305,inst_20306);
var inst_20308 = [inst_20297,inst_20307];
var inst_20309 = (new cljs.core.PersistentVector(null,2,(5),inst_20304,inst_20308,null));
var state_20367__$1 = (function (){var statearr_20376 = state_20367;
(statearr_20376[(10)] = inst_20303);

return statearr_20376;
})();
var statearr_20377_20425 = state_20367__$1;
(statearr_20377_20425[(2)] = inst_20309);

(statearr_20377_20425[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (21))){
var inst_20356 = (state_20367[(2)]);
var state_20367__$1 = state_20367;
var statearr_20378_20426 = state_20367__$1;
(statearr_20378_20426[(2)] = inst_20356);

(statearr_20378_20426[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (13))){
var inst_20297 = (state_20367[(9)]);
var inst_20300 = (function(){throw inst_20297})();
var state_20367__$1 = state_20367;
var statearr_20379_20427 = state_20367__$1;
(statearr_20379_20427[(2)] = inst_20300);

(statearr_20379_20427[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (22))){
var inst_20321 = (state_20367[(11)]);
var inst_20319 = (state_20367[(12)]);
var inst_20323 = fluree.db.query.analytical.parse_block_from_source(inst_20319);
var inst_20324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20325 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_20321];
var inst_20326 = (new cljs.core.PersistentVector(null,2,(5),inst_20324,inst_20325,null));
var inst_20327 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_20326);
var state_20367__$1 = (function (){var statearr_20380 = state_20367;
(statearr_20380[(13)] = inst_20323);

return statearr_20380;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20367__$1,(25),inst_20327);
} else {
if((state_val_20368 === (29))){
var inst_20334 = (state_20367[(2)]);
var inst_20335 = fluree.db.util.async.throw_err(inst_20334);
var state_20367__$1 = state_20367;
var statearr_20381_20428 = state_20367__$1;
(statearr_20381_20428[(2)] = inst_20335);

(statearr_20381_20428[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (6))){
var inst_20283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20284 = cljs.core.PersistentVector.EMPTY;
var inst_20285 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20286 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20284,inst_20285);
var inst_20287 = [db,inst_20286];
var inst_20288 = (new cljs.core.PersistentVector(null,2,(5),inst_20283,inst_20287,null));
var state_20367__$1 = state_20367;
var statearr_20382_20429 = state_20367__$1;
(statearr_20382_20429[(2)] = inst_20288);

(statearr_20382_20429[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (28))){
var inst_20338 = (state_20367[(2)]);
var inst_20339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20340 = cljs.core.PersistentVector.EMPTY;
var inst_20341 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_20342 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_20340,inst_20341);
var inst_20343 = [inst_20338,inst_20342];
var inst_20344 = (new cljs.core.PersistentVector(null,2,(5),inst_20339,inst_20343,null));
var state_20367__$1 = state_20367;
var statearr_20383_20430 = state_20367__$1;
(statearr_20383_20430[(2)] = inst_20344);

(statearr_20383_20430[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (25))){
var inst_20323 = (state_20367[(13)]);
var inst_20329 = (state_20367[(2)]);
var inst_20330 = fluree.db.util.async.throw_err(inst_20329);
var state_20367__$1 = (function (){var statearr_20384 = state_20367;
(statearr_20384[(8)] = inst_20330);

return statearr_20384;
})();
if(cljs.core.truth_(inst_20323)){
var statearr_20385_20431 = state_20367__$1;
(statearr_20385_20431[(1)] = (26));

} else {
var statearr_20386_20432 = state_20367__$1;
(statearr_20386_20432[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (17))){
var state_20367__$1 = state_20367;
var statearr_20387_20433 = state_20367__$1;
(statearr_20387_20433[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (3))){
var inst_20365 = (state_20367[(2)]);
var state_20367__$1 = state_20367;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20367__$1,inst_20365);
} else {
if((state_val_20368 === (12))){
var inst_20297 = (state_20367[(9)]);
var inst_20296 = (state_20367[(2)]);
var inst_20297__$1 = fluree.db.util.async.throw_err(inst_20296);
var inst_20298 = fluree.db.util.core.exception_QMARK_(inst_20297__$1);
var state_20367__$1 = (function (){var statearr_20389 = state_20367;
(statearr_20389[(9)] = inst_20297__$1);

return statearr_20389;
})();
if(inst_20298){
var statearr_20390_20434 = state_20367__$1;
(statearr_20390_20434[(1)] = (13));

} else {
var statearr_20391_20435 = state_20367__$1;
(statearr_20391_20435[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (2))){
var inst_20280 = (state_20367[(7)]);
var _ = (function (){var statearr_20392 = state_20367;
(statearr_20392[(4)] = cljs.core.cons((5),(state_20367[(4)])));

return statearr_20392;
})();
var inst_20280__$1 = cljs.core.first(clause);
var inst_20281 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_20280__$1);
var state_20367__$1 = (function (){var statearr_20393 = state_20367;
(statearr_20393[(7)] = inst_20280__$1);

return statearr_20393;
})();
if(inst_20281){
var statearr_20394_20436 = state_20367__$1;
(statearr_20394_20436[(1)] = (6));

} else {
var statearr_20395_20437 = state_20367__$1;
(statearr_20395_20437[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (23))){
var inst_20280 = (state_20367[(7)]);
var inst_20346 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20280)," is not supported in Fluree"].join('');
var inst_20347 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20348 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20349 = cljs.core.PersistentHashMap.fromArrays(inst_20347,inst_20348);
var inst_20350 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20346,inst_20349);
var inst_20351 = (function(){throw inst_20350})();
var state_20367__$1 = state_20367;
var statearr_20396_20438 = state_20367__$1;
(statearr_20396_20438[(2)] = inst_20351);

(statearr_20396_20438[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (19))){
var inst_20321 = (state_20367[(11)]);
var inst_20280 = (state_20367[(7)]);
var inst_20318 = fluree.db.query.analytical.isolate_source_name(inst_20280);
var inst_20319 = fluree.db.query.analytical.isolate_source_block(inst_20280);
var inst_20320 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_20318);
var inst_20321__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_20320);
var state_20367__$1 = (function (){var statearr_20397 = state_20367;
(statearr_20397[(11)] = inst_20321__$1);

(statearr_20397[(12)] = inst_20319);

return statearr_20397;
})();
if(cljs.core.truth_(inst_20321__$1)){
var statearr_20398_20439 = state_20367__$1;
(statearr_20398_20439[(1)] = (22));

} else {
var statearr_20399_20440 = state_20367__$1;
(statearr_20399_20440[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (11))){
var inst_20360 = (state_20367[(2)]);
var state_20367__$1 = state_20367;
var statearr_20401_20441 = state_20367__$1;
(statearr_20401_20441[(2)] = inst_20360);

(statearr_20401_20441[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (9))){
var inst_20280 = (state_20367[(7)]);
var inst_20292 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_20280,(4));
var inst_20293 = fluree.db.query.analytical.parse_block_from_source(inst_20292);
var inst_20294 = fluree.db.time_travel.as_of_block(db,inst_20293);
var state_20367__$1 = state_20367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20367__$1,(12),inst_20294);
} else {
if((state_val_20368 === (5))){
var _ = (function (){var statearr_20402 = state_20367;
(statearr_20402[(4)] = cljs.core.rest((state_20367[(4)])));

return statearr_20402;
})();
var state_20367__$1 = state_20367;
var ex20400 = (state_20367__$1[(2)]);
var statearr_20403_20442 = state_20367__$1;
(statearr_20403_20442[(5)] = ex20400);


if((ex20400 instanceof Error)){
var statearr_20404_20443 = state_20367__$1;
(statearr_20404_20443[(1)] = (4));

(statearr_20404_20443[(5)] = null);

} else {
throw ex20400;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (14))){
var state_20367__$1 = state_20367;
var statearr_20405_20444 = state_20367__$1;
(statearr_20405_20444[(2)] = null);

(statearr_20405_20444[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (26))){
var inst_20323 = (state_20367[(13)]);
var inst_20330 = (state_20367[(8)]);
var inst_20332 = fluree.db.time_travel.as_of_block(inst_20330,inst_20323);
var state_20367__$1 = state_20367;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20367__$1,(29),inst_20332);
} else {
if((state_val_20368 === (16))){
var inst_20313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20314 = ["$wd",clause];
var inst_20315 = (new cljs.core.PersistentVector(null,2,(5),inst_20313,inst_20314,null));
var state_20367__$1 = state_20367;
var statearr_20406_20445 = state_20367__$1;
(statearr_20406_20445[(2)] = inst_20315);

(statearr_20406_20445[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (10))){
var inst_20280 = (state_20367[(7)]);
var inst_20311 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_20280);
var state_20367__$1 = state_20367;
if(inst_20311){
var statearr_20407_20446 = state_20367__$1;
(statearr_20407_20446[(1)] = (16));

} else {
var statearr_20408_20447 = state_20367__$1;
(statearr_20408_20447[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (18))){
var inst_20358 = (state_20367[(2)]);
var state_20367__$1 = state_20367;
var statearr_20409_20448 = state_20367__$1;
(statearr_20409_20448[(2)] = inst_20358);

(statearr_20409_20448[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20368 === (8))){
var inst_20362 = (state_20367[(2)]);
var _ = (function (){var statearr_20410 = state_20367;
(statearr_20410[(4)] = cljs.core.rest((state_20367[(4)])));

return statearr_20410;
})();
var state_20367__$1 = state_20367;
var statearr_20411_20449 = state_20367__$1;
(statearr_20411_20449[(2)] = inst_20362);

(statearr_20411_20449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_20412 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20412[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_20412[(1)] = (1));

return statearr_20412;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_20367){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20367);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20413){var ex__2730__auto__ = e20413;
var statearr_20414_20450 = state_20367;
(statearr_20414_20450[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20367[(4)]))){
var statearr_20415_20451 = state_20367;
(statearr_20415_20451[(1)] = cljs.core.first((state_20367[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20452 = state_20367;
state_20367 = G__20452;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_20367){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_20367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20416 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20416[(6)] = c__2749__auto__);

return statearr_20416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__20453){
var vec__20454 = p__20453;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20454,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20454,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20457_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__20457_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__20461 = subjects;
var vec__20462 = G__20461;
var seq__20463 = cljs.core.seq(vec__20462);
var first__20464 = cljs.core.first(seq__20463);
var seq__20463__$1 = cljs.core.next(seq__20463);
var subject = first__20464;
var r = seq__20463__$1;
var acc = expanded_map;
var G__20461__$1 = G__20461;
var acc__$1 = acc;
while(true){
var vec__20468 = G__20461__$1;
var seq__20469 = cljs.core.seq(vec__20468);
var first__20470 = cljs.core.first(seq__20469);
var seq__20469__$1 = cljs.core.next(seq__20469);
var subject__$1 = first__20470;
var r__$1 = seq__20469__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__20471 = r__$1;
var G__20472 = acc__$2;
G__20461__$1 = G__20471;
acc__$1 = G__20472;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__20461__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20468,seq__20469,first__20470,seq__20469__$1,subject__$1,r__$1,acc__$2,G__20461,vec__20462,seq__20463,first__20464,seq__20463__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__5045__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__20461__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20468,seq__20469,first__20470,seq__20469__$1,subject__$1,r__$1,acc__$2,G__20461,vec__20462,seq__20463,first__20464,seq__20463__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20461__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20468,seq__20469,first__20470,seq__20469__$1,subject__$1,r__$1,acc__$2,G__20461,vec__20462,seq__20463,first__20464,seq__20463__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__20461__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20468,seq__20469,first__20470,seq__20469__$1,subject__$1,r__$1,acc__$2,G__20461,vec__20462,seq__20463,first__20464,seq__20463__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__20461__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__20468,seq__20469,first__20470,seq__20469__$1,subject__$1,r__$1,acc__$2,G__20461,vec__20462,seq__20463,first__20464,seq__20463__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__20461__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__20468,seq__20469,first__20470,seq__20469__$1,subject__$1,r__$1,acc__$2,G__20461,vec__20462,seq__20463,first__20464,seq__20463__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__20473 = r__$1;
var G__20474 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__20461__$1 = G__20473;
acc__$1 = G__20474;
continue;
} else {
var G__20475 = subjects;
var G__20476 = acc_STAR_;
G__20461__$1 = G__20475;
acc__$1 = G__20476;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__20477_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__20477_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20568){
var state_val_20569 = (state_20568[(1)]);
if((state_val_20569 === (7))){
var state_20568__$1 = state_20568;
var statearr_20570_20616 = state_20568__$1;
(statearr_20570_20616[(2)] = (100));

(statearr_20570_20616[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (20))){
var inst_20517 = (state_20568[(7)]);
var state_20568__$1 = state_20568;
var statearr_20571_20617 = state_20568__$1;
(statearr_20571_20617[(2)] = inst_20517);

(statearr_20571_20617[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (1))){
var state_20568__$1 = state_20568;
var statearr_20572_20618 = state_20568__$1;
(statearr_20572_20618[(2)] = null);

(statearr_20572_20618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (24))){
var inst_20554 = (state_20568[(8)]);
var inst_20556 = (state_20568[(9)]);
var inst_20489 = (state_20568[(10)]);
var inst_20555 = (state_20568[(11)]);
var inst_20559 = (function (){var max_depth = inst_20489;
var recur_map__$1 = inst_20555;
var subjects = inst_20554;
var tuples = inst_20556;
return (function (p1__20478_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__20478_SHARP_)],null));
});
})();
var inst_20560 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20559,inst_20556);
var inst_20561 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_20560);
var state_20568__$1 = state_20568;
var statearr_20573_20619 = state_20568__$1;
(statearr_20573_20619[(2)] = inst_20561);

(statearr_20573_20619[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (4))){
var inst_20479 = (state_20568[(2)]);
var state_20568__$1 = state_20568;
var statearr_20574_20620 = state_20568__$1;
(statearr_20574_20620[(2)] = inst_20479);

(statearr_20574_20620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (15))){
var inst_20502 = (state_20568[(12)]);
var inst_20513 = cljs.core.PersistentVector.EMPTY;
var inst_20514 = cljs.core.seq(inst_20502);
var inst_20515 = cljs.core.first(inst_20514);
var inst_20516 = cljs.core.next(inst_20514);
var inst_20517 = inst_20513;
var inst_20518 = inst_20502;
var state_20568__$1 = (function (){var statearr_20575 = state_20568;
(statearr_20575[(13)] = inst_20518);

(statearr_20575[(14)] = inst_20515);

(statearr_20575[(15)] = inst_20516);

(statearr_20575[(7)] = inst_20517);

return statearr_20575;
})();
var statearr_20576_20621 = state_20568__$1;
(statearr_20576_20621[(2)] = null);

(statearr_20576_20621[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (21))){
var inst_20538 = (state_20568[(2)]);
var state_20568__$1 = state_20568;
var statearr_20577_20622 = state_20568__$1;
(statearr_20577_20622[(2)] = inst_20538);

(statearr_20577_20622[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (13))){
var inst_20551 = (state_20568[(2)]);
var state_20568__$1 = state_20568;
var statearr_20578_20623 = state_20568__$1;
(statearr_20578_20623[(2)] = inst_20551);

(statearr_20578_20623[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (22))){
var inst_20525 = (state_20568[(16)]);
var inst_20517 = (state_20568[(7)]);
var inst_20532 = (state_20568[(2)]);
var inst_20533 = fluree.db.util.async.throw_err(inst_20532);
var inst_20534 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_20517,inst_20533);
var inst_20517__$1 = inst_20534;
var inst_20518 = inst_20525;
var state_20568__$1 = (function (){var statearr_20579 = state_20568;
(statearr_20579[(13)] = inst_20518);

(statearr_20579[(7)] = inst_20517__$1);

return statearr_20579;
})();
var statearr_20580_20624 = state_20568__$1;
(statearr_20580_20624[(2)] = null);

(statearr_20580_20624[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (6))){
var inst_20485 = (state_20568[(17)]);
var state_20568__$1 = state_20568;
var statearr_20581_20625 = state_20568__$1;
(statearr_20581_20625[(2)] = inst_20485);

(statearr_20581_20625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (25))){
var inst_20563 = (state_20568[(2)]);
var _ = (function (){var statearr_20582 = state_20568;
(statearr_20582[(4)] = cljs.core.rest((state_20568[(4)])));

return statearr_20582;
})();
var state_20568__$1 = state_20568;
var statearr_20583_20626 = state_20568__$1;
(statearr_20583_20626[(2)] = inst_20563);

(statearr_20583_20626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (17))){
var inst_20518 = (state_20568[(13)]);
var inst_20524 = (state_20568[(18)]);
var inst_20523 = cljs.core.seq(inst_20518);
var inst_20524__$1 = cljs.core.first(inst_20523);
var inst_20525 = cljs.core.next(inst_20523);
var state_20568__$1 = (function (){var statearr_20584 = state_20568;
(statearr_20584[(18)] = inst_20524__$1);

(statearr_20584[(16)] = inst_20525);

return statearr_20584;
})();
if(cljs.core.truth_(inst_20524__$1)){
var statearr_20585_20627 = state_20568__$1;
(statearr_20585_20627[(1)] = (19));

} else {
var statearr_20586_20628 = state_20568__$1;
(statearr_20586_20628[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (3))){
var inst_20566 = (state_20568[(2)]);
var state_20568__$1 = state_20568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20568__$1,inst_20566);
} else {
if((state_val_20569 === (12))){
var inst_20491 = (state_20568[(19)]);
var inst_20502 = (state_20568[(12)]);
var inst_20497 = cljs.core.vals(inst_20491);
var inst_20498 = cljs.core.flatten(inst_20497);
var inst_20499 = cljs.core.set(inst_20498);
var inst_20500 = cljs.core.keys(inst_20491);
var inst_20501 = cljs.core.set(inst_20500);
var inst_20502__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_20499,inst_20501);
var inst_20503 = cljs.core.empty_QMARK_(inst_20502__$1);
var state_20568__$1 = (function (){var statearr_20587 = state_20568;
(statearr_20587[(12)] = inst_20502__$1);

return statearr_20587;
})();
if(inst_20503){
var statearr_20588_20629 = state_20568__$1;
(statearr_20588_20629[(1)] = (14));

} else {
var statearr_20589_20630 = state_20568__$1;
(statearr_20589_20630[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (2))){
var inst_20485 = (state_20568[(17)]);
var _ = (function (){var statearr_20590 = state_20568;
(statearr_20590[(4)] = cljs.core.cons((5),(state_20568[(4)])));

return statearr_20590;
})();
var inst_20485__$1 = depth;
var state_20568__$1 = (function (){var statearr_20591 = state_20568;
(statearr_20591[(17)] = inst_20485__$1);

return statearr_20591;
})();
if(cljs.core.truth_(inst_20485__$1)){
var statearr_20592_20631 = state_20568__$1;
(statearr_20592_20631[(1)] = (6));

} else {
var statearr_20593_20632 = state_20568__$1;
(statearr_20593_20632[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (23))){
var inst_20556 = (state_20568[(9)]);
var state_20568__$1 = state_20568;
var statearr_20594_20633 = state_20568__$1;
(statearr_20594_20633[(2)] = inst_20556);

(statearr_20594_20633[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (19))){
var inst_20524 = (state_20568[(18)]);
var inst_20527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20528 = [inst_20524,predicate];
var inst_20529 = (new cljs.core.PersistentVector(null,2,(5),inst_20527,inst_20528,null));
var inst_20530 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20529);
var state_20568__$1 = state_20568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20568__$1,(22),inst_20530);
} else {
if((state_val_20569 === (11))){
var inst_20491 = (state_20568[(19)]);
var state_20568__$1 = state_20568;
var statearr_20596_20634 = state_20568__$1;
(statearr_20596_20634[(2)] = inst_20491);

(statearr_20596_20634[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (9))){
var inst_20492 = (state_20568[(20)]);
var inst_20489 = (state_20568[(10)]);
var inst_20494 = (inst_20492 >= inst_20489);
var state_20568__$1 = state_20568;
if(cljs.core.truth_(inst_20494)){
var statearr_20597_20635 = state_20568__$1;
(statearr_20597_20635[(1)] = (11));

} else {
var statearr_20598_20636 = state_20568__$1;
(statearr_20598_20636[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (5))){
var _ = (function (){var statearr_20599 = state_20568;
(statearr_20599[(4)] = cljs.core.rest((state_20568[(4)])));

return statearr_20599;
})();
var state_20568__$1 = state_20568;
var ex20595 = (state_20568__$1[(2)]);
var statearr_20600_20637 = state_20568__$1;
(statearr_20600_20637[(5)] = ex20595);


if((ex20595 instanceof Error)){
var statearr_20601_20638 = state_20568__$1;
(statearr_20601_20638[(1)] = (4));

(statearr_20601_20638[(5)] = null);

} else {
throw ex20595;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (14))){
var inst_20491 = (state_20568[(19)]);
var state_20568__$1 = state_20568;
var statearr_20602_20639 = state_20568__$1;
(statearr_20602_20639[(2)] = inst_20491);

(statearr_20602_20639[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (16))){
var inst_20549 = (state_20568[(2)]);
var state_20568__$1 = state_20568;
var statearr_20603_20640 = state_20568__$1;
(statearr_20603_20640[(2)] = inst_20549);

(statearr_20603_20640[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (10))){
var inst_20554 = (state_20568[(8)]);
var inst_20555 = (state_20568[(11)]);
var inst_20553 = (state_20568[(2)]);
var inst_20554__$1 = cljs.core.keys(inst_20553);
var inst_20555__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_20554__$1,inst_20553);
var inst_20556 = fluree.db.query.analytical.recur_map__GT_tuples(inst_20554__$1,inst_20555__$1);
var state_20568__$1 = (function (){var statearr_20604 = state_20568;
(statearr_20604[(8)] = inst_20554__$1);

(statearr_20604[(9)] = inst_20556);

(statearr_20604[(11)] = inst_20555__$1);

return statearr_20604;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_20605_20641 = state_20568__$1;
(statearr_20605_20641[(1)] = (23));

} else {
var statearr_20606_20642 = state_20568__$1;
(statearr_20606_20642[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (18))){
var inst_20492 = (state_20568[(20)]);
var inst_20491 = (state_20568[(19)]);
var inst_20540 = (state_20568[(2)]);
var inst_20541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20542 = [(0),(2)];
var inst_20543 = (new cljs.core.PersistentVector(null,2,(5),inst_20541,inst_20542,null));
var inst_20544 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_20543,inst_20540);
var inst_20545 = fluree.db.query.analytical.tuples__GT_map(inst_20491,inst_20544);
var inst_20546 = (inst_20492 + (1));
var inst_20491__$1 = inst_20545;
var inst_20492__$1 = inst_20546;
var state_20568__$1 = (function (){var statearr_20607 = state_20568;
(statearr_20607[(20)] = inst_20492__$1);

(statearr_20607[(19)] = inst_20491__$1);

return statearr_20607;
})();
var statearr_20608_20643 = state_20568__$1;
(statearr_20608_20643[(2)] = null);

(statearr_20608_20643[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20569 === (8))){
var inst_20489 = (state_20568[(2)]);
var inst_20490 = recur_map;
var inst_20491 = inst_20490;
var inst_20492 = (1);
var state_20568__$1 = (function (){var statearr_20609 = state_20568;
(statearr_20609[(20)] = inst_20492);

(statearr_20609[(19)] = inst_20491);

(statearr_20609[(10)] = inst_20489);

return statearr_20609;
})();
var statearr_20610_20644 = state_20568__$1;
(statearr_20610_20644[(2)] = null);

(statearr_20610_20644[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0 = (function (){
var statearr_20611 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20611[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__);

(statearr_20611[(1)] = (1));

return statearr_20611;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1 = (function (state_20568){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20568);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20612){var ex__2730__auto__ = e20612;
var statearr_20613_20645 = state_20568;
(statearr_20613_20645[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20568[(4)]))){
var statearr_20614_20646 = state_20568;
(statearr_20614_20646[(1)] = cljs.core.first((state_20568[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20647 = state_20568;
state_20568 = G__20647;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__ = function(state_20568){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1.call(this,state_20568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20615 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20615[(6)] = c__2749__auto__);

return statearr_20615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__20648,clause,fuel,max_fuel){
var map__20649 = p__20648;
var map__20649__$1 = cljs.core.__destructure_map(map__20649);
var res = map__20649__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20649__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20649__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20649__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20760){
var state_val_20761 = (state_20760[(1)]);
if((state_val_20761 === (7))){
var inst_20666 = (state_20760[(7)]);
var state_20760__$1 = state_20760;
var statearr_20762_20815 = state_20760__$1;
(statearr_20762_20815[(2)] = inst_20666);

(statearr_20762_20815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (20))){
var inst_20694 = (state_20760[(8)]);
var inst_20725 = typeof inst_20694 === 'number';
var state_20760__$1 = state_20760;
if(cljs.core.truth_(inst_20725)){
var statearr_20763_20816 = state_20760__$1;
(statearr_20763_20816[(1)] = (22));

} else {
var statearr_20764_20817 = state_20760__$1;
(statearr_20764_20817[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (27))){
var inst_20740 = (state_20760[(2)]);
var state_20760__$1 = state_20760;
var statearr_20765_20818 = state_20760__$1;
(statearr_20765_20818[(2)] = inst_20740);

(statearr_20765_20818[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (1))){
var state_20760__$1 = state_20760;
var statearr_20766_20819 = state_20760__$1;
(statearr_20766_20819[(2)] = null);

(statearr_20766_20819[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (24))){
var inst_20742 = (state_20760[(2)]);
var state_20760__$1 = state_20760;
var statearr_20767_20820 = state_20760__$1;
(statearr_20767_20820[(2)] = inst_20742);

(statearr_20767_20820[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (4))){
var inst_20650 = (state_20760[(2)]);
var state_20760__$1 = state_20760;
var statearr_20768_20821 = state_20760__$1;
(statearr_20768_20821[(2)] = inst_20650);

(statearr_20768_20821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (15))){
var inst_20708 = (state_20760[(2)]);
var inst_20709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_20710 = fluree.db.query.analytical.variable_QMARK_(inst_20709);
var state_20760__$1 = (function (){var statearr_20769 = state_20760;
(statearr_20769[(9)] = inst_20708);

return statearr_20769;
})();
if(cljs.core.truth_(inst_20710)){
var statearr_20770_20822 = state_20760__$1;
(statearr_20770_20822[(1)] = (16));

} else {
var statearr_20771_20823 = state_20760__$1;
(statearr_20771_20823[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (21))){
var inst_20697 = (state_20760[(10)]);
var inst_20696 = (state_20760[(11)]);
var inst_20667 = (state_20760[(12)]);
var inst_20744 = (state_20760[(2)]);
var inst_20745 = fluree.db.query.analytical.tuples__GT_recur(db,inst_20697,inst_20744,inst_20667,inst_20696);
var state_20760__$1 = state_20760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20760__$1,(28),inst_20745);
} else {
if((state_val_20761 === (13))){
var inst_20676 = (state_20760[(13)]);
var inst_20700 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20676)].join('');
var inst_20701 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20702 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20703 = cljs.core.PersistentHashMap.fromArrays(inst_20701,inst_20702);
var inst_20704 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20700,inst_20703);
var inst_20705 = (function(){throw inst_20704})();
var state_20760__$1 = state_20760;
var statearr_20772_20824 = state_20760__$1;
(statearr_20772_20824[(2)] = inst_20705);

(statearr_20772_20824[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (22))){
var inst_20692 = (state_20760[(14)]);
var inst_20694 = (state_20760[(8)]);
var inst_20727 = cljs.core.PersistentHashMap.EMPTY;
var inst_20728 = cljs.core.flatten(inst_20692);
var inst_20729 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20727,inst_20694,inst_20728);
var state_20760__$1 = state_20760;
var statearr_20773_20825 = state_20760__$1;
(statearr_20773_20825[(2)] = inst_20729);

(statearr_20773_20825[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (6))){
var inst_20678 = (state_20760[(15)]);
var state_20760__$1 = state_20760;
var statearr_20774_20826 = state_20760__$1;
(statearr_20774_20826[(2)] = inst_20678);

(statearr_20774_20826[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (28))){
var inst_20747 = (state_20760[(2)]);
var inst_20748 = fluree.db.util.async.throw_err(inst_20747);
var state_20760__$1 = state_20760;
var statearr_20775_20827 = state_20760__$1;
(statearr_20775_20827[(2)] = inst_20748);

(statearr_20775_20827[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (25))){
var inst_20688 = (state_20760[(16)]);
var inst_20692 = (state_20760[(14)]);
var inst_20733 = cljs.core.PersistentHashMap.EMPTY;
var inst_20734 = cljs.core.first(inst_20688);
var inst_20735 = cljs.core.first(inst_20734);
var inst_20736 = cljs.core.flatten(inst_20692);
var inst_20737 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_20733,inst_20735,inst_20736);
var state_20760__$1 = state_20760;
var statearr_20776_20828 = state_20760__$1;
(statearr_20776_20828[(2)] = inst_20737);

(statearr_20776_20828[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (17))){
var inst_20676 = (state_20760[(13)]);
var inst_20713 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20676)].join('');
var inst_20714 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20715 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20716 = cljs.core.PersistentHashMap.fromArrays(inst_20714,inst_20715);
var inst_20717 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_20713,inst_20716);
var inst_20718 = (function(){throw inst_20717})();
var state_20760__$1 = state_20760;
var statearr_20777_20829 = state_20760__$1;
(statearr_20777_20829[(2)] = inst_20718);

(statearr_20777_20829[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (3))){
var inst_20758 = (state_20760[(2)]);
var state_20760__$1 = state_20760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20760__$1,inst_20758);
} else {
if((state_val_20761 === (12))){
var inst_20663 = (state_20760[(17)]);
var inst_20751 = (state_20760[(2)]);
var inst_20752 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_20753 = cljs.core.keys(inst_20663);
var inst_20754 = [inst_20753,vars,inst_20751];
var inst_20755 = cljs.core.PersistentHashMap.fromArrays(inst_20752,inst_20754);
var _ = (function (){var statearr_20778 = state_20760;
(statearr_20778[(4)] = cljs.core.rest((state_20760[(4)])));

return statearr_20778;
})();
var state_20760__$1 = state_20760;
var statearr_20779_20830 = state_20760__$1;
(statearr_20779_20830[(2)] = inst_20755);

(statearr_20779_20830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (2))){
var inst_20666 = (state_20760[(7)]);
var inst_20678 = (state_20760[(15)]);
var inst_20667 = (state_20760[(12)]);
var inst_20663 = (state_20760[(17)]);
var _ = (function (){var statearr_20780 = state_20760;
(statearr_20780[(4)] = cljs.core.cons((5),(state_20760[(4)])));

return statearr_20780;
})();
var inst_20660 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_20661 = cljs.core.__destructure_map(inst_20660);
var inst_20662 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20661,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_20663__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20661,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_20664 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20661,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_20665 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_20666__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20664);
var inst_20667__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_20664);
var inst_20669 = (function (){var map__20656 = inst_20661;
var search = inst_20662;
var rel = inst_20663__$1;
var opts = inst_20664;
var common_keys = inst_20665;
var object_fn = inst_20666__$1;
var recur_depth = inst_20667__$1;
return (function (p__20668,common_key){
var vec__20781 = p__20668;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20781,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__20781,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__20784 = cljs.core._EQ_;
var expr__20785 = idx_of;
if(cljs.core.truth_((pred__20784.cljs$core$IFn$_invoke$arity$2 ? pred__20784.cljs$core$IFn$_invoke$arity$2((0),expr__20785) : pred__20784.call(null,(0),expr__20785)))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_((pred__20784.cljs$core$IFn$_invoke$arity$2 ? pred__20784.cljs$core$IFn$_invoke$arity$2((1),expr__20785) : pred__20784.call(null,(1),expr__20785)))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_((pred__20784.cljs$core$IFn$_invoke$arity$2 ? pred__20784.cljs$core$IFn$_invoke$arity$2((2),expr__20785) : pred__20784.call(null,(2),expr__20785)))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__20785)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.transform_tuples_to_idxs(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__5043__auto__ = (!(single_v_QMARK_));
if(and__5043__auto__){
var and__5043__auto____$1 = object_fn;
if(cljs.core.truth_(and__5043__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_20670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20671 = cljs.core.PersistentHashMap.EMPTY;
var inst_20672 = [inst_20671,inst_20662];
var inst_20673 = (new cljs.core.PersistentVector(null,2,(5),inst_20670,inst_20672,null));
var inst_20674 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_20669,inst_20673,inst_20665);
var inst_20675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20674,(0),null);
var inst_20676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_20674,(1),null);
var inst_20677 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_20678__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_20675);
var state_20760__$1 = (function (){var statearr_20787 = state_20760;
(statearr_20787[(18)] = inst_20677);

(statearr_20787[(7)] = inst_20666__$1);

(statearr_20787[(15)] = inst_20678__$1);

(statearr_20787[(12)] = inst_20667__$1);

(statearr_20787[(13)] = inst_20676);

(statearr_20787[(17)] = inst_20663__$1);

return statearr_20787;
})();
if(cljs.core.truth_(inst_20678__$1)){
var statearr_20788_20831 = state_20760__$1;
(statearr_20788_20831[(1)] = (6));

} else {
var statearr_20789_20832 = state_20760__$1;
(statearr_20789_20832[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (23))){
var inst_20694 = (state_20760[(8)]);
var inst_20731 = cljs.core.coll_QMARK_(inst_20694);
var state_20760__$1 = state_20760;
if(inst_20731){
var statearr_20790_20833 = state_20760__$1;
(statearr_20790_20833[(1)] = (25));

} else {
var statearr_20791_20834 = state_20760__$1;
(statearr_20791_20834[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (19))){
var inst_20692 = (state_20760[(14)]);
var inst_20722 = cljs.core.PersistentHashMap.EMPTY;
var inst_20723 = fluree.db.query.analytical.tuples__GT_map(inst_20722,inst_20692);
var state_20760__$1 = state_20760;
var statearr_20792_20835 = state_20760__$1;
(statearr_20792_20835[(2)] = inst_20723);

(statearr_20792_20835[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (11))){
var inst_20692 = (state_20760[(14)]);
var state_20760__$1 = state_20760;
var statearr_20794_20836 = state_20760__$1;
(statearr_20794_20836[(2)] = inst_20692);

(statearr_20794_20836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (9))){
var inst_20688 = (state_20760[(16)]);
var inst_20667 = (state_20760[(12)]);
var inst_20663 = (state_20760[(17)]);
var inst_20687 = (state_20760[(2)]);
var inst_20688__$1 = fluree.db.util.async.throw_err(inst_20687);
var inst_20689 = cljs.core.count(inst_20688__$1);
var inst_20690 = fluree.db.query.analytical.add_fuel(inst_20689,fuel,max_fuel);
var inst_20691 = cljs.core.vals(inst_20663);
var inst_20692 = fluree.db.query.analytical.transform_tuples_to_idxs(inst_20691,inst_20688__$1);
var state_20760__$1 = (function (){var statearr_20795 = state_20760;
(statearr_20795[(16)] = inst_20688__$1);

(statearr_20795[(19)] = inst_20690);

(statearr_20795[(14)] = inst_20692);

return statearr_20795;
})();
if(cljs.core.truth_(inst_20667)){
var statearr_20796_20837 = state_20760__$1;
(statearr_20796_20837[(1)] = (10));

} else {
var statearr_20797_20838 = state_20760__$1;
(statearr_20797_20838[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (5))){
var _ = (function (){var statearr_20798 = state_20760;
(statearr_20798[(4)] = cljs.core.rest((state_20760[(4)])));

return statearr_20798;
})();
var state_20760__$1 = state_20760;
var ex20793 = (state_20760__$1[(2)]);
var statearr_20799_20839 = state_20760__$1;
(statearr_20799_20839[(5)] = ex20793);


if((ex20793 instanceof Error)){
var statearr_20800_20840 = state_20760__$1;
(statearr_20800_20840[(1)] = (4));

(statearr_20800_20840[(5)] = null);

} else {
throw ex20793;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (14))){
var state_20760__$1 = state_20760;
var statearr_20801_20841 = state_20760__$1;
(statearr_20801_20841[(2)] = null);

(statearr_20801_20841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (26))){
var state_20760__$1 = state_20760;
var statearr_20802_20842 = state_20760__$1;
(statearr_20802_20842[(2)] = null);

(statearr_20802_20842[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (16))){
var state_20760__$1 = state_20760;
var statearr_20803_20843 = state_20760__$1;
(statearr_20803_20843[(2)] = null);

(statearr_20803_20843[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (10))){
var inst_20697 = (state_20760[(10)]);
var inst_20676 = (state_20760[(13)]);
var inst_20694 = cljs.core.first(inst_20676);
var inst_20695 = cljs.core.first(clause);
var inst_20696 = fluree.db.query.analytical.variable_QMARK_(inst_20695);
var inst_20697__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_20676,(1));
var inst_20698 = fluree.db.query.analytical.variable_QMARK_(inst_20697__$1);
var state_20760__$1 = (function (){var statearr_20804 = state_20760;
(statearr_20804[(10)] = inst_20697__$1);

(statearr_20804[(11)] = inst_20696);

(statearr_20804[(8)] = inst_20694);

return statearr_20804;
})();
if(cljs.core.truth_(inst_20698)){
var statearr_20805_20844 = state_20760__$1;
(statearr_20805_20844[(1)] = (13));

} else {
var statearr_20806_20845 = state_20760__$1;
(statearr_20806_20845[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (18))){
var inst_20696 = (state_20760[(11)]);
var inst_20720 = (state_20760[(2)]);
var state_20760__$1 = (function (){var statearr_20807 = state_20760;
(statearr_20807[(20)] = inst_20720);

return statearr_20807;
})();
if(cljs.core.truth_(inst_20696)){
var statearr_20808_20846 = state_20760__$1;
(statearr_20808_20846[(1)] = (19));

} else {
var statearr_20809_20847 = state_20760__$1;
(statearr_20809_20847[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20761 === (8))){
var inst_20677 = (state_20760[(18)]);
var inst_20676 = (state_20760[(13)]);
var inst_20682 = (state_20760[(2)]);
var inst_20683 = [inst_20682];
var inst_20684 = cljs.core.PersistentHashMap.fromArrays(inst_20677,inst_20683);
var inst_20685 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_20676,inst_20684);
var state_20760__$1 = state_20760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20760__$1,(9),inst_20685);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20810[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_20810[(1)] = (1));

return statearr_20810;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20760){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20760);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e20811){var ex__2730__auto__ = e20811;
var statearr_20812_20848 = state_20760;
(statearr_20812_20848[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20760[(4)]))){
var statearr_20813_20849 = state_20760;
(statearr_20813_20849[(1)] = cljs.core.first((state_20760[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20850 = state_20760;
state_20760 = G__20850;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__ = function(state_20760){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_20814 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_20814[(6)] = c__2749__auto__);

return statearr_20814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__20851,res,clause){
var map__20852 = p__20851;
var map__20852__$1 = cljs.core.__destructure_map(map__20852);
var db = map__20852__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20852__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20852__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__20852__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_20961){
var state_val_20962 = (state_20961[(1)]);
if((state_val_20962 === (7))){
var inst_20861 = (state_20961[(7)]);
var state_20961__$1 = state_20961;
var statearr_20963_21004 = state_20961__$1;
(statearr_20963_21004[(2)] = inst_20861);

(statearr_20963_21004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (20))){
var state_20961__$1 = state_20961;
var statearr_20964_21005 = state_20961__$1;
(statearr_20964_21005[(2)] = null);

(statearr_20964_21005[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (1))){
var state_20961__$1 = state_20961;
var statearr_20965_21006 = state_20961__$1;
(statearr_20965_21006[(2)] = null);

(statearr_20965_21006[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (24))){
var inst_20863 = (state_20961[(8)]);
var inst_20934 = (state_20961[(2)]);
var inst_20935 = fluree.db.flake.sid__GT_cid(inst_20934);
var inst_20936 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_20935);
var inst_20937 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20939 = [inst_20863];
var inst_20940 = (new cljs.core.PersistentVector(null,1,(5),inst_20938,inst_20939,null));
var inst_20941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20943 = [inst_20936];
var inst_20944 = (new cljs.core.PersistentVector(null,1,(5),inst_20942,inst_20943,null));
var inst_20945 = [inst_20944];
var inst_20946 = (new cljs.core.PersistentVector(null,1,(5),inst_20941,inst_20945,null));
var inst_20947 = cljs.core.PersistentHashMap.EMPTY;
var inst_20948 = [inst_20940,inst_20946,inst_20947];
var inst_20949 = cljs.core.PersistentHashMap.fromArrays(inst_20937,inst_20948);
var state_20961__$1 = state_20961;
var statearr_20966_21007 = state_20961__$1;
(statearr_20966_21007[(2)] = inst_20949);

(statearr_20966_21007[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (4))){
var inst_20854 = (state_20961[(2)]);
var state_20961__$1 = state_20961;
var statearr_20967_21008 = state_20961__$1;
(statearr_20967_21008[(2)] = inst_20854);

(statearr_20967_21008[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (15))){
var inst_20861 = (state_20961[(7)]);
var inst_20863 = (state_20961[(8)]);
var inst_20882 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20883 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20885 = [inst_20861];
var inst_20886 = (new cljs.core.PersistentVector(null,1,(5),inst_20884,inst_20885,null));
var inst_20887 = (function (){var subject_var = inst_20861;
var object_var = inst_20863;
var min_sid = inst_20882;
var max_sid = (0);
return (function (p1__20853_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__20853_SHARP_);
});
})();
var inst_20888 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_20882,(0));
var inst_20889 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_20887,inst_20888);
var inst_20890 = cljs.core.PersistentHashMap.EMPTY;
var inst_20891 = [inst_20886,inst_20889,inst_20890];
var inst_20892 = cljs.core.PersistentHashMap.fromArrays(inst_20883,inst_20891);
var state_20961__$1 = state_20961;
var statearr_20968_21009 = state_20961__$1;
(statearr_20968_21009[(2)] = inst_20892);

(statearr_20968_21009[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (21))){
var inst_20952 = (state_20961[(2)]);
var state_20961__$1 = state_20961;
var statearr_20969_21010 = state_20961__$1;
(statearr_20969_21010[(2)] = inst_20952);

(statearr_20969_21010[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (13))){
var inst_20863 = (state_20961[(8)]);
var state_20961__$1 = state_20961;
if(cljs.core.truth_(inst_20863)){
var statearr_20970_21011 = state_20961__$1;
(statearr_20970_21011[(1)] = (19));

} else {
var statearr_20971_21012 = state_20961__$1;
(statearr_20971_21012[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (22))){
var inst_20925 = (state_20961[(9)]);
var state_20961__$1 = state_20961;
var statearr_20972_21013 = state_20961__$1;
(statearr_20972_21013[(2)] = inst_20925);

(statearr_20972_21013[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (6))){
var inst_20863 = (state_20961[(8)]);
var state_20961__$1 = state_20961;
var statearr_20973_21014 = state_20961__$1;
(statearr_20973_21014[(2)] = inst_20863);

(statearr_20973_21014[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (25))){
var inst_20931 = (state_20961[(2)]);
var inst_20932 = fluree.db.util.async.throw_err(inst_20931);
var state_20961__$1 = state_20961;
var statearr_20974_21015 = state_20961__$1;
(statearr_20974_21015[(2)] = inst_20932);

(statearr_20974_21015[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (17))){
var inst_20922 = (state_20961[(2)]);
var state_20961__$1 = state_20961;
var statearr_20975_21016 = state_20961__$1;
(statearr_20975_21016[(2)] = inst_20922);

(statearr_20975_21016[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (3))){
var inst_20959 = (state_20961[(2)]);
var state_20961__$1 = state_20961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_20961__$1,inst_20959);
} else {
if((state_val_20962 === (12))){
var inst_20876 = ["_tx",null,"_block",null];
var inst_20877 = (new cljs.core.PersistentArrayMap(null,2,inst_20876,null));
var inst_20878 = (new cljs.core.PersistentHashSet(null,inst_20877,null));
var inst_20879 = cljs.core.last(clause);
var inst_20880 = (inst_20878.cljs$core$IFn$_invoke$arity$1 ? inst_20878.cljs$core$IFn$_invoke$arity$1(inst_20879) : inst_20878.call(null,inst_20879));
var state_20961__$1 = state_20961;
if(cljs.core.truth_(inst_20880)){
var statearr_20976_21017 = state_20961__$1;
(statearr_20976_21017[(1)] = (15));

} else {
var statearr_20977_21018 = state_20961__$1;
(statearr_20977_21018[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (2))){
var inst_20861 = (state_20961[(7)]);
var _ = (function (){var statearr_20978 = state_20961;
(statearr_20978[(4)] = cljs.core.cons((5),(state_20961[(4)])));

return statearr_20978;
})();
var inst_20860 = cljs.core.first(clause);
var inst_20861__$1 = fluree.db.query.analytical.variable_QMARK_(inst_20860);
var inst_20862 = cljs.core.last(clause);
var inst_20863 = fluree.db.query.analytical.variable_QMARK_(inst_20862);
var state_20961__$1 = (function (){var statearr_20979 = state_20961;
(statearr_20979[(7)] = inst_20861__$1);

(statearr_20979[(8)] = inst_20863);

return statearr_20979;
})();
if(cljs.core.truth_(inst_20861__$1)){
var statearr_20980_21019 = state_20961__$1;
(statearr_20980_21019[(1)] = (6));

} else {
var statearr_20981_21020 = state_20961__$1;
(statearr_20981_21020[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (23))){
var inst_20925 = (state_20961[(9)]);
var inst_20929 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_20925);
var state_20961__$1 = state_20961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20961__$1,(25),inst_20929);
} else {
if((state_val_20962 === (19))){
var inst_20925 = (state_20961[(9)]);
var inst_20925__$1 = cljs.core.first(clause);
var inst_20926 = typeof inst_20925__$1 === 'number';
var state_20961__$1 = (function (){var statearr_20982 = state_20961;
(statearr_20982[(9)] = inst_20925__$1);

return statearr_20982;
})();
if(cljs.core.truth_(inst_20926)){
var statearr_20983_21021 = state_20961__$1;
(statearr_20983_21021[(1)] = (22));

} else {
var statearr_20984_21022 = state_20961__$1;
(statearr_20984_21022[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (11))){
var inst_20956 = (state_20961[(2)]);
var _ = (function (){var statearr_20986 = state_20961;
(statearr_20986[(4)] = cljs.core.rest((state_20961[(4)])));

return statearr_20986;
})();
var state_20961__$1 = state_20961;
var statearr_20987_21023 = state_20961__$1;
(statearr_20987_21023[(2)] = inst_20956);

(statearr_20987_21023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (9))){
var inst_20869 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20870 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_20871 = cljs.core.PersistentHashMap.fromArrays(inst_20869,inst_20870);
var inst_20872 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_20871);
var inst_20873 = (function(){throw inst_20872})();
var state_20961__$1 = state_20961;
var statearr_20988_21024 = state_20961__$1;
(statearr_20988_21024[(2)] = inst_20873);

(statearr_20988_21024[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (5))){
var _ = (function (){var statearr_20989 = state_20961;
(statearr_20989[(4)] = cljs.core.rest((state_20961[(4)])));

return statearr_20989;
})();
var state_20961__$1 = state_20961;
var ex20985 = (state_20961__$1[(2)]);
var statearr_20990_21025 = state_20961__$1;
(statearr_20990_21025[(5)] = ex20985);


if((ex20985 instanceof Error)){
var statearr_20991_21026 = state_20961__$1;
(statearr_20991_21026[(1)] = (4));

(statearr_20991_21026[(5)] = null);

} else {
throw ex20985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (14))){
var inst_20954 = (state_20961[(2)]);
var state_20961__$1 = state_20961;
var statearr_20992_21027 = state_20961__$1;
(statearr_20992_21027[(2)] = inst_20954);

(statearr_20992_21027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (16))){
var inst_20897 = (state_20961[(10)]);
var inst_20895 = (state_20961[(11)]);
var inst_20898 = (state_20961[(12)]);
var inst_20894 = cljs.core.last(clause);
var inst_20895__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_20894);
var inst_20896 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_20897__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_20896,inst_20895__$1);
var inst_20898__$1 = fluree.db.flake.min_subject_id(inst_20895__$1);
var inst_20899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20900 = [inst_20897__$1];
var inst_20901 = (new cljs.core.PersistentVector(null,1,(5),inst_20899,inst_20900,null));
var inst_20902 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20903 = [inst_20898__$1];
var inst_20904 = (new cljs.core.PersistentVector(null,1,(5),inst_20902,inst_20903,null));
var inst_20905 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20901,cljs.core._LT__EQ_,inst_20904);
var state_20961__$1 = (function (){var statearr_20993 = state_20961;
(statearr_20993[(10)] = inst_20897__$1);

(statearr_20993[(11)] = inst_20895__$1);

(statearr_20993[(12)] = inst_20898__$1);

return statearr_20993;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_20961__$1,(18),inst_20905);
} else {
if((state_val_20962 === (10))){
var inst_20861 = (state_20961[(7)]);
var state_20961__$1 = state_20961;
if(cljs.core.truth_(inst_20861)){
var statearr_20994_21028 = state_20961__$1;
(statearr_20994_21028[(1)] = (12));

} else {
var statearr_20995_21029 = state_20961__$1;
(statearr_20995_21029[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (18))){
var inst_20897 = (state_20961[(10)]);
var inst_20861 = (state_20961[(7)]);
var inst_20895 = (state_20961[(11)]);
var inst_20863 = (state_20961[(8)]);
var inst_20898 = (state_20961[(12)]);
var inst_20907 = (state_20961[(2)]);
var inst_20908 = fluree.db.util.async.throw_err(inst_20907);
var inst_20909 = (function (){var subject_var = inst_20861;
var object_var = inst_20863;
var partition = inst_20895;
var max_sid = inst_20897;
var min_sid = inst_20898;
var flakes = inst_20908;
return (function (f){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s], null);
});
})();
var inst_20910 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_20909);
var inst_20911 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_20912 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_20910,inst_20911);
var inst_20913 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_20914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20915 = [inst_20861];
var inst_20916 = (new cljs.core.PersistentVector(null,1,(5),inst_20914,inst_20915,null));
var inst_20917 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_20912,inst_20908);
var inst_20918 = cljs.core.PersistentHashMap.EMPTY;
var inst_20919 = [inst_20916,inst_20917,inst_20918];
var inst_20920 = cljs.core.PersistentHashMap.fromArrays(inst_20913,inst_20919);
var state_20961__$1 = state_20961;
var statearr_20996_21030 = state_20961__$1;
(statearr_20996_21030[(2)] = inst_20920);

(statearr_20996_21030[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20962 === (8))){
var inst_20867 = (state_20961[(2)]);
var state_20961__$1 = state_20961;
if(cljs.core.truth_(inst_20867)){
var statearr_20997_21031 = state_20961__$1;
(statearr_20997_21031[(1)] = (9));

} else {
var statearr_20998_21032 = state_20961__$1;
(statearr_20998_21032[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_20999 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20999[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__);

(statearr_20999[(1)] = (1));

return statearr_20999;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1 = (function (state_20961){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_20961);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21000){var ex__2730__auto__ = e21000;
var statearr_21001_21033 = state_20961;
(statearr_21001_21033[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_20961[(4)]))){
var statearr_21002_21034 = state_20961;
(statearr_21002_21034[(1)] = cljs.core.first((state_20961[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21035 = state_20961;
state_20961 = G__21035;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__ = function(state_20961){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1.call(this,state_20961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21003 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21003[(6)] = c__2749__auto__);

return statearr_21003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__21042 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__21042 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__21042;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__5523__auto__ = (function fluree$db$query$analytical$variance_$_iter__21043(s__21044){
return (new cljs.core.LazySeq(null,(function (){
var s__21044__$1 = s__21044;
while(true){
var temp__5804__auto__ = cljs.core.seq(s__21044__$1);
if(temp__5804__auto__){
var s__21044__$2 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(s__21044__$2)){
var c__5521__auto__ = cljs.core.chunk_first(s__21044__$2);
var size__5522__auto__ = cljs.core.count(c__5521__auto__);
var b__21046 = cljs.core.chunk_buffer(size__5522__auto__);
if((function (){var i__21045 = (0);
while(true){
if((i__21045 < size__5522__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__5521__auto__,i__21045);
var delta = (x - mean);
cljs.core.chunk_append(b__21046,(delta * delta));

var G__21048 = (i__21045 + (1));
i__21045 = G__21048;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__21046),fluree$db$query$analytical$variance_$_iter__21043(cljs.core.chunk_rest(s__21044__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__21046),null);
}
} else {
var x = cljs.core.first(s__21044__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__21043(cljs.core.rest(s__21044__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__5523__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__21047 = variance(coll);
return Math.sqrt(G__21047);
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__5130__auto__ = n;
var y__5131__auto__ = (- n);
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
}),(function() {
var G__21049 = null;
var G__21049__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21049__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21049 = function(n,coll){
switch(arguments.length){
case 1:
return G__21049__1.call(this,n);
case 2:
return G__21049__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21049.cljs$core$IFn$_invoke$arity$1 = G__21049__1;
G__21049.cljs$core$IFn$_invoke$arity$2 = G__21049__2;
return G__21049;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__21050 = null;
var G__21050__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__21050__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__21050 = function(n,coll){
switch(arguments.length){
case 1:
return G__21050__1.call(this,n);
case 2:
return G__21050__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21050.cljs$core$IFn$_invoke$arity$1 = G__21050__1;
G__21050.cljs$core$IFn$_invoke$arity$2 = G__21050__2;
return G__21050;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__21051 = null;
var G__21051__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__21051__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__21051 = function(n,coll){
switch(arguments.length){
case 1:
return G__21051__1.call(this,n);
case 2:
return G__21051__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21051.cljs$core$IFn$_invoke$arity$1 = G__21051__1;
G__21051.cljs$core$IFn$_invoke$arity$2 = G__21051__2;
return G__21051;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__5043__auto__ = typeof x === 'string';
if(and__5043__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__5043__auto__;
}
});
/**
 * Returns map of aggregate function executable code or error if invalid aggregate function.
 */
fluree.db.query.analytical.parse_aggregate_STAR_ = (function fluree$db$query$analytical$parse_aggregate_STAR_(parsed_code,as,valid_var){
var list_count = cljs.core.count(parsed_code);
var vec__21052 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),cljs.core.second(parsed_code),cljs.core.last(parsed_code)], null):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first(parsed_code)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parsed_code),null,cljs.core.last(parsed_code)], null)):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21052,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21052,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21052,(2),null);
var agg_fn = (function (){var temp__5802__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5802__auto__)){
var agg_fn = temp__5802__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__21055 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__21058 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__21058) : agg_fn.call(null,G__21058));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21055,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21055,(1),null);
var fn_str = ["(fn [",cljs.core.str.cljs$core$IFn$_invoke$arity$1(variable),"] ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0)),")"].join('');
if(cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([parsed_code], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"fn-str","fn-str",-1348506402),fn_str,new cljs.core.Keyword(null,"function","function",-2127255473),agg_fn__$1], null);
});
/**
 * Parses string aggregate function and returns execution map if valid.
 */
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(code_str,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(code_str);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var code_parsed = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(code_str)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
return fluree.db.query.analytical.parse_aggregate_STAR_(code_parsed,as,valid_var);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(tuples,aggregate_fn_map){
var map__21059 = aggregate_fn_map;
var map__21059__$1 = cljs.core.__destructure_map(map__21059);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21059__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21059__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var function$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21059__$1,new cljs.core.Keyword(null,"function","function",-2127255473));
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),tuples));
var agg_result = (function$.cljs$core$IFn$_invoke$arity$1 ? function$.cljs$core$IFn$_invoke$arity$1(agg_params) : function$.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__21061 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21061,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21061,(1),null);
var map__21064 = res__$1;
var map__21064__$1 = cljs.core.__destructure_map(map__21064);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21064__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21064__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21060_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__21060_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21065_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__21065_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21066_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21066_SHARP_);
}),a_idxs);
var temp__5802__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5802__auto__)){
var b_matched = temp__5802__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__21067_SHARP_,p2__21068_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21067_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__21068_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21069_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__21069_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__21072,row,b_tuple){
var vec__21073 = p__21072;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21073,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21073,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21070_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21070_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__5045__auto__ = acc;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21071_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__21071_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21076_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__21076_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21077_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21077_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21082 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21084 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__21083 = (function (p1__21078_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21078_SHARP_);
});
return fexpr__21083(G__21084);
})()),cljs.core.set(b_idxs));
var fexpr__21081 = (function (p1__21079_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21079_SHARP_);
});
return fexpr__21081(G__21082);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21080_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__21080_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21085_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__21085_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21086_SHARP_){
return fluree.db.util.core.index_of(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21086_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__21091 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__21093 = cljs.core.count(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__21092 = (function (p1__21087_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__21087_SHARP_);
});
return fexpr__21092(G__21093);
})()),cljs.core.set(b_idxs));
var fexpr__21090 = (function (p1__21088_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__21088_SHARP_);
});
return fexpr__21090(G__21091);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21089_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__21089_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__21095 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21095,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21095,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__21094_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__21094_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var vec__21100 = (function (){var or__5045__auto__ = fluree.db.query.analytical_filter.extract_filter_fn(filt,valid_vars);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21100,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21100,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21098_SHARP_){
return fluree.db.util.core.index_of(headers,p1__21098_SHARP_);
}),filt_vars);
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__21099_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__21099_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__21103,filters,optional_QMARK_){
var map__21104 = p__21103;
var map__21104__$1 = cljs.core.__destructure_map(map__21104);
var tuple_map = map__21104__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21104__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21104__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21104__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__21105 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21105,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21105,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__21108 = res;
var map__21108__$1 = cljs.core.__destructure_map(map__21108);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21108__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21108__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5802__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5802__auto__)){
var valid_var = temp__5802__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21164){
var state_val_21165 = (state_21164[(1)]);
if((state_val_21165 === (7))){
var inst_21138 = (state_21164[(7)]);
var inst_21136 = (state_21164[(2)]);
var inst_21137 = fluree.db.util.async.throw_err(inst_21136);
var inst_21138__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21137,(0),null);
var inst_21139 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21137,(1),null);
var inst_21140 = (inst_21138__$1 == null);
var state_21164__$1 = (function (){var statearr_21166 = state_21164;
(statearr_21166[(8)] = inst_21139);

(statearr_21166[(7)] = inst_21138__$1);

return statearr_21166;
})();
if(cljs.core.truth_(inst_21140)){
var statearr_21167_21196 = state_21164__$1;
(statearr_21167_21196[(1)] = (8));

} else {
var statearr_21168_21197 = state_21164__$1;
(statearr_21168_21197[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (1))){
var inst_21116 = optional_clauses;
var inst_21117 = cljs.core.seq(inst_21116);
var inst_21118 = cljs.core.first(inst_21117);
var inst_21119 = cljs.core.next(inst_21117);
var inst_21120 = where_tuples;
var inst_21121 = inst_21116;
var inst_21122 = inst_21120;
var state_21164__$1 = (function (){var statearr_21169 = state_21164;
(statearr_21169[(9)] = inst_21118);

(statearr_21169[(10)] = inst_21121);

(statearr_21169[(11)] = inst_21119);

(statearr_21169[(12)] = inst_21122);

return statearr_21169;
})();
var statearr_21170_21198 = state_21164__$1;
(statearr_21170_21198[(2)] = null);

(statearr_21170_21198[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (4))){
var inst_21129 = (state_21164[(13)]);
var inst_21122 = (state_21164[(12)]);
var inst_21128 = (state_21164[(14)]);
var inst_21134 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_21122,inst_21128,inst_21129,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_21122,inst_21128,inst_21129,true,fuel,max_fuel,opts));
var state_21164__$1 = state_21164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21164__$1,(7),inst_21134);
} else {
if((state_val_21165 === (15))){
var state_21164__$1 = state_21164;
var statearr_21171_21199 = state_21164__$1;
(statearr_21171_21199[(2)] = null);

(statearr_21171_21199[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (13))){
var inst_21155 = (state_21164[(2)]);
var state_21164__$1 = state_21164;
var statearr_21172_21200 = state_21164__$1;
(statearr_21172_21200[(2)] = inst_21155);

(statearr_21172_21200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (6))){
var inst_21160 = (state_21164[(2)]);
var state_21164__$1 = state_21164;
var statearr_21173_21201 = state_21164__$1;
(statearr_21173_21201[(2)] = inst_21160);

(statearr_21173_21201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (3))){
var inst_21162 = (state_21164[(2)]);
var state_21164__$1 = state_21164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21164__$1,inst_21162);
} else {
if((state_val_21165 === (12))){
var state_21164__$1 = state_21164;
var statearr_21174_21202 = state_21164__$1;
(statearr_21174_21202[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (2))){
var inst_21121 = (state_21164[(10)]);
var inst_21128 = (state_21164[(14)]);
var inst_21127 = cljs.core.seq(inst_21121);
var inst_21128__$1 = cljs.core.first(inst_21127);
var inst_21129 = cljs.core.next(inst_21127);
var state_21164__$1 = (function (){var statearr_21176 = state_21164;
(statearr_21176[(13)] = inst_21129);

(statearr_21176[(14)] = inst_21128__$1);

return statearr_21176;
})();
if(cljs.core.truth_(inst_21128__$1)){
var statearr_21177_21203 = state_21164__$1;
(statearr_21177_21203[(1)] = (4));

} else {
var statearr_21178_21204 = state_21164__$1;
(statearr_21178_21204[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (11))){
var inst_21139 = (state_21164[(8)]);
var inst_21138 = (state_21164[(7)]);
var inst_21121 = inst_21139;
var inst_21122 = inst_21138;
var state_21164__$1 = (function (){var statearr_21179 = state_21164;
(statearr_21179[(10)] = inst_21121);

(statearr_21179[(12)] = inst_21122);

return statearr_21179;
})();
var statearr_21180_21205 = state_21164__$1;
(statearr_21180_21205[(2)] = null);

(statearr_21180_21205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (9))){
var inst_21128 = (state_21164[(14)]);
var inst_21144 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_21128);
var state_21164__$1 = state_21164;
if(cljs.core.truth_(inst_21144)){
var statearr_21181_21206 = state_21164__$1;
(statearr_21181_21206[(1)] = (11));

} else {
var statearr_21182_21207 = state_21164__$1;
(statearr_21182_21207[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (5))){
var inst_21122 = (state_21164[(12)]);
var state_21164__$1 = state_21164;
var statearr_21183_21208 = state_21164__$1;
(statearr_21183_21208[(2)] = inst_21122);

(statearr_21183_21208[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (14))){
var inst_21139 = (state_21164[(8)]);
var inst_21138 = (state_21164[(7)]);
var inst_21122 = (state_21164[(12)]);
var inst_21149 = fluree.db.query.analytical.left_outer_join(inst_21122,inst_21138);
var inst_21121 = inst_21139;
var inst_21122__$1 = inst_21149;
var state_21164__$1 = (function (){var statearr_21184 = state_21164;
(statearr_21184[(10)] = inst_21121);

(statearr_21184[(12)] = inst_21122__$1);

return statearr_21184;
})();
var statearr_21185_21209 = state_21164__$1;
(statearr_21185_21209[(2)] = null);

(statearr_21185_21209[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (16))){
var inst_21153 = (state_21164[(2)]);
var state_21164__$1 = state_21164;
var statearr_21187_21210 = state_21164__$1;
(statearr_21187_21210[(2)] = inst_21153);

(statearr_21187_21210[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (10))){
var inst_21157 = (state_21164[(2)]);
var state_21164__$1 = state_21164;
var statearr_21188_21211 = state_21164__$1;
(statearr_21188_21211[(2)] = inst_21157);

(statearr_21188_21211[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21165 === (8))){
var inst_21139 = (state_21164[(8)]);
var inst_21122 = (state_21164[(12)]);
var tmp21186 = inst_21122;
var inst_21121 = inst_21139;
var inst_21122__$1 = tmp21186;
var state_21164__$1 = (function (){var statearr_21189 = state_21164;
(statearr_21189[(10)] = inst_21121);

(statearr_21189[(12)] = inst_21122__$1);

return statearr_21189;
})();
var statearr_21190_21212 = state_21164__$1;
(statearr_21190_21212[(2)] = null);

(statearr_21190_21212[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0 = (function (){
var statearr_21191 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21191[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__);

(statearr_21191[(1)] = (1));

return statearr_21191;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1 = (function (state_21164){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21164);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21192){var ex__2730__auto__ = e21192;
var statearr_21193_21213 = state_21164;
(statearr_21193_21213[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21164[(4)]))){
var statearr_21194_21214 = state_21164;
(statearr_21194_21214[(1)] = cljs.core.first((state_21164[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21215 = state_21164;
state_21164 = G__21215;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__ = function(state_21164){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1.call(this,state_21164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21195 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21195[(6)] = c__2749__auto__);

return statearr_21195;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__21217){
var vec__21218 = p__21217;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21218,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__21218,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__21216_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__21216_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__21222,p__21223,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__21224 = p__21222;
var map__21224__$1 = cljs.core.__destructure_map(map__21224);
var q_map = map__21224__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21224__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__21225 = p__21223;
var map__21225__$1 = cljs.core.__destructure_map(map__21225);
var res = map__21225__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__21225__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21462){
var state_val_21463 = (state_21462[(1)]);
if((state_val_21463 === (65))){
var inst_21411 = (state_21462[(7)]);
var inst_21412 = (state_21462[(8)]);
var inst_21423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21424 = fluree.db.query.analytical.full_text__GT_tuples(inst_21411,res,inst_21412);
var inst_21425 = [inst_21424,r];
var inst_21426 = (new cljs.core.PersistentVector(null,2,(5),inst_21423,inst_21425,null));
var state_21462__$1 = state_21462;
var statearr_21464_21577 = state_21462__$1;
(statearr_21464_21577[(2)] = inst_21426);

(statearr_21464_21577[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (70))){
var inst_21438 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21465_21578 = state_21462__$1;
(statearr_21465_21578[(2)] = inst_21438);

(statearr_21465_21578[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (62))){
var inst_21412 = (state_21462[(8)]);
var inst_21420 = cljs.core.second(inst_21412);
var inst_21421 = clojure.string.starts_with_QMARK_(inst_21420,"fullText:");
var state_21462__$1 = state_21462;
if(inst_21421){
var statearr_21466_21579 = state_21462__$1;
(statearr_21466_21579[(1)] = (65));

} else {
var statearr_21467_21580 = state_21462__$1;
(statearr_21467_21580[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (7))){
var inst_21331 = (state_21462[(9)]);
var inst_21330 = cljs.core.count(clause);
var inst_21331__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21330);
var state_21462__$1 = (function (){var statearr_21468 = state_21462;
(statearr_21468[(9)] = inst_21331__$1);

return statearr_21468;
})();
if(inst_21331__$1){
var statearr_21469_21581 = state_21462__$1;
(statearr_21469_21581[(1)] = (31));

} else {
var statearr_21470_21582 = state_21462__$1;
(statearr_21470_21582[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (59))){
var inst_21445 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21471_21583 = state_21462__$1;
(statearr_21471_21583[(2)] = inst_21445);

(statearr_21471_21583[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (20))){
var inst_21294 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21472_21584 = state_21462__$1;
(statearr_21472_21584[(2)] = inst_21294);

(statearr_21472_21584[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (58))){
var state_21462__$1 = state_21462;
var statearr_21473_21585 = state_21462__$1;
(statearr_21473_21585[(2)] = null);

(statearr_21473_21585[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (60))){
var inst_21411 = (state_21462[(7)]);
var inst_21409 = (state_21462[(2)]);
var inst_21410 = fluree.db.util.async.throw_err(inst_21409);
var inst_21411__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21410,(0),null);
var inst_21412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21410,(1),null);
var inst_21413 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_21411__$1);
var state_21462__$1 = (function (){var statearr_21474 = state_21462;
(statearr_21474[(7)] = inst_21411__$1);

(statearr_21474[(8)] = inst_21412);

return statearr_21474;
})();
if(inst_21413){
var statearr_21475_21586 = state_21462__$1;
(statearr_21475_21586[(1)] = (61));

} else {
var statearr_21476_21587 = state_21462__$1;
(statearr_21476_21587[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (27))){
var inst_21324 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21477_21588 = state_21462__$1;
(statearr_21477_21588[(2)] = inst_21324);

(statearr_21477_21588[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (1))){
var state_21462__$1 = state_21462;
var statearr_21478_21589 = state_21462__$1;
(statearr_21478_21589[(2)] = null);

(statearr_21478_21589[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (69))){
var state_21462__$1 = state_21462;
var statearr_21479_21590 = state_21462__$1;
(statearr_21479_21590[(2)] = null);

(statearr_21479_21590[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (24))){
var inst_21288 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21480_21591 = state_21462__$1;
(statearr_21480_21591[(2)] = inst_21288);

(statearr_21480_21591[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (55))){
var inst_21394 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21395 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21396 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21397 = cljs.core.PersistentHashMap.fromArrays(inst_21395,inst_21396);
var inst_21398 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21394,inst_21397);
var inst_21399 = (function(){throw inst_21398})();
var state_21462__$1 = state_21462;
var statearr_21481_21592 = state_21462__$1;
(statearr_21481_21592[(2)] = inst_21399);

(statearr_21481_21592[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (39))){
var inst_21351 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
if(cljs.core.truth_(inst_21351)){
var statearr_21482_21593 = state_21462__$1;
(statearr_21482_21593[(1)] = (40));

} else {
var statearr_21483_21594 = state_21462__$1;
(statearr_21483_21594[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (46))){
var inst_21451 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21484_21595 = state_21462__$1;
(statearr_21484_21595[(2)] = inst_21451);

(statearr_21484_21595[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (4))){
var inst_21226 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21485_21596 = state_21462__$1;
(statearr_21485_21596[(2)] = inst_21226);

(statearr_21485_21596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (54))){
var inst_21387 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_21388 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21389 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_21390 = cljs.core.PersistentHashMap.fromArrays(inst_21388,inst_21389);
var inst_21391 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_21387,inst_21390);
var inst_21392 = (function(){throw inst_21391})();
var state_21462__$1 = state_21462;
var statearr_21486_21597 = state_21462__$1;
(statearr_21486_21597[(2)] = inst_21392);

(statearr_21486_21597[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (15))){
var inst_21326 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21487_21598 = state_21462__$1;
(statearr_21487_21598[(2)] = inst_21326);

(statearr_21487_21598[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (48))){
var inst_21375 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21376 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_21377 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21376);
var inst_21378 = [inst_21377,r];
var inst_21379 = (new cljs.core.PersistentVector(null,2,(5),inst_21375,inst_21378,null));
var state_21462__$1 = state_21462;
var statearr_21488_21599 = state_21462__$1;
(statearr_21488_21599[(2)] = inst_21379);

(statearr_21488_21599[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (50))){
var inst_21449 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21489_21600 = state_21462__$1;
(statearr_21489_21600[(2)] = inst_21449);

(statearr_21489_21600[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (21))){
var inst_21265 = (state_21462[(10)]);
var inst_21262 = (state_21462[(11)]);
var inst_21272 = (state_21462[(12)]);
var inst_21235 = (state_21462[(13)]);
var inst_21263 = (state_21462[(14)]);
var inst_21271 = (state_21462[(15)]);
var inst_21264 = (state_21462[(16)]);
var inst_21239 = (state_21462[(17)]);
var inst_21260 = (state_21462[(18)]);
var inst_21276 = (state_21462[(2)]);
var inst_21277 = fluree.db.util.async.throw_err(inst_21276);
var inst_21278 = (function (){var expr__21237 = inst_21235;
var new_res = inst_21277;
var G__21256 = inst_21264;
var first__21269 = inst_21271;
var rest = inst_21272;
var pred__21236 = inst_21239;
var tuples = inst_21265;
var seq__21258 = inst_21263;
var vec__21257 = inst_21260;
var seq__21268 = inst_21272;
var segment_type = inst_21235;
var vec__21267 = inst_21264;
var clause_group = inst_21271;
var first__21259 = inst_21262;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_21279 = cljs.core.keys(vars);
var inst_21280 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_21278,inst_21277,inst_21279);
var inst_21281 = fluree.db.query.analytical.res_absorb_vars(inst_21280);
var state_21462__$1 = (function (){var statearr_21490 = state_21462;
(statearr_21490[(19)] = inst_21281);

return statearr_21490;
})();
if(cljs.core.truth_(inst_21265)){
var statearr_21491_21601 = state_21462__$1;
(statearr_21491_21601[(1)] = (22));

} else {
var statearr_21492_21602 = state_21462__$1;
(statearr_21492_21602[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (31))){
var inst_21333 = cljs.core.second(clause);
var inst_21334 = clojure.string.starts_with_QMARK_(inst_21333,"fullText:");
var state_21462__$1 = state_21462;
var statearr_21493_21603 = state_21462__$1;
(statearr_21493_21603[(2)] = inst_21334);

(statearr_21493_21603[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (32))){
var inst_21331 = (state_21462[(9)]);
var state_21462__$1 = state_21462;
var statearr_21494_21604 = state_21462__$1;
(statearr_21494_21604[(2)] = inst_21331);

(statearr_21494_21604[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (40))){
var inst_21353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21354 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_21462__$1 = (function (){var statearr_21495 = state_21462;
(statearr_21495[(20)] = inst_21353);

return statearr_21495;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(43),inst_21354);
} else {
if((state_val_21463 === (56))){
var inst_21401 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21496_21605 = state_21462__$1;
(statearr_21496_21605[(2)] = inst_21401);

(statearr_21496_21605[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (33))){
var inst_21337 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
if(cljs.core.truth_(inst_21337)){
var statearr_21497_21606 = state_21462__$1;
(statearr_21497_21606[(1)] = (34));

} else {
var statearr_21498_21607 = state_21462__$1;
(statearr_21498_21607[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (13))){
var inst_21260 = (state_21462[(18)]);
var inst_21260__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21261 = cljs.core.seq(inst_21260__$1);
var inst_21262 = cljs.core.first(inst_21261);
var inst_21263 = cljs.core.next(inst_21261);
var inst_21264 = inst_21260__$1;
var inst_21265 = null;
var state_21462__$1 = (function (){var statearr_21499 = state_21462;
(statearr_21499[(10)] = inst_21265);

(statearr_21499[(11)] = inst_21262);

(statearr_21499[(14)] = inst_21263);

(statearr_21499[(16)] = inst_21264);

(statearr_21499[(18)] = inst_21260__$1);

return statearr_21499;
})();
var statearr_21500_21608 = state_21462__$1;
(statearr_21500_21608[(2)] = null);

(statearr_21500_21608[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (22))){
var inst_21265 = (state_21462[(10)]);
var inst_21281 = (state_21462[(19)]);
var inst_21272 = (state_21462[(12)]);
var inst_21283 = fluree.db.query.union.results(inst_21265,inst_21281);
var inst_21264 = inst_21272;
var inst_21265__$1 = inst_21283;
var state_21462__$1 = (function (){var statearr_21501 = state_21462;
(statearr_21501[(10)] = inst_21265__$1);

(statearr_21501[(16)] = inst_21264);

return statearr_21501;
})();
var statearr_21502_21609 = state_21462__$1;
(statearr_21502_21609[(2)] = null);

(statearr_21502_21609[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (36))){
var inst_21455 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21503_21610 = state_21462__$1;
(statearr_21503_21610[(2)] = inst_21455);

(statearr_21503_21610[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (41))){
var inst_21361 = cljs.core.count(clause);
var inst_21362 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21361);
var state_21462__$1 = state_21462;
if(inst_21362){
var statearr_21504_21611 = state_21462__$1;
(statearr_21504_21611[(1)] = (44));

} else {
var statearr_21505_21612 = state_21462__$1;
(statearr_21505_21612[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (43))){
var inst_21353 = (state_21462[(20)]);
var inst_21356 = (state_21462[(2)]);
var inst_21357 = fluree.db.util.async.throw_err(inst_21356);
var inst_21358 = [inst_21357,r];
var inst_21359 = (new cljs.core.PersistentVector(null,2,(5),inst_21353,inst_21358,null));
var state_21462__$1 = state_21462;
var statearr_21506_21613 = state_21462__$1;
(statearr_21506_21613[(2)] = inst_21359);

(statearr_21506_21613[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (61))){
var inst_21412 = (state_21462[(8)]);
var inst_21415 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_21412,r,res,optional_QMARK_,fuel,max_fuel);
var state_21462__$1 = state_21462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(64),inst_21415);
} else {
if((state_val_21463 === (29))){
var inst_21235 = (state_21462[(13)]);
var inst_21318 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_21235)].join('');
var inst_21319 = (new Error(inst_21318));
var inst_21320 = (function(){throw inst_21319})();
var state_21462__$1 = state_21462;
var statearr_21507_21614 = state_21462__$1;
(statearr_21507_21614[(2)] = inst_21320);

(statearr_21507_21614[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (44))){
var inst_21364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21365 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_21462__$1 = (function (){var statearr_21508 = state_21462;
(statearr_21508[(21)] = inst_21364);

return statearr_21508;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(47),inst_21365);
} else {
if((state_val_21463 === (6))){
var inst_21235 = (state_21462[(13)]);
var inst_21239 = (state_21462[(17)]);
var inst_21234 = cljs.core.keys(clause);
var inst_21235__$1 = cljs.core.first(inst_21234);
var inst_21239__$1 = cljs.core._EQ_;
var inst_21240 = (function (){var G__21509 = new cljs.core.Keyword(null,"optional","optional",2053951509);
var G__21510 = inst_21235__$1;
return (inst_21239__$1.cljs$core$IFn$_invoke$arity$2 ? inst_21239__$1.cljs$core$IFn$_invoke$arity$2(G__21509,G__21510) : inst_21239__$1.call(null,G__21509,G__21510));
})();
var state_21462__$1 = (function (){var statearr_21511 = state_21462;
(statearr_21511[(13)] = inst_21235__$1);

(statearr_21511[(17)] = inst_21239__$1);

return statearr_21511;
})();
if(cljs.core.truth_(inst_21240)){
var statearr_21512_21615 = state_21462__$1;
(statearr_21512_21615[(1)] = (9));

} else {
var statearr_21513_21616 = state_21462__$1;
(statearr_21513_21616[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (28))){
var inst_21312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21313 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21314 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_21313,optional_QMARK_);
var inst_21315 = [inst_21314,r];
var inst_21316 = (new cljs.core.PersistentVector(null,2,(5),inst_21312,inst_21315,null));
var state_21462__$1 = state_21462;
var statearr_21514_21617 = state_21462__$1;
(statearr_21514_21617[(2)] = inst_21316);

(statearr_21514_21617[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (64))){
var inst_21417 = (state_21462[(2)]);
var inst_21418 = fluree.db.util.async.throw_err(inst_21417);
var state_21462__$1 = state_21462;
var statearr_21515_21618 = state_21462__$1;
(statearr_21515_21618[(2)] = inst_21418);

(statearr_21515_21618[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (51))){
var inst_21384 = cljs.core.first(clause);
var inst_21385 = cljs.core.sequential_QMARK_(inst_21384);
var state_21462__$1 = state_21462;
if(inst_21385){
var statearr_21516_21619 = state_21462__$1;
(statearr_21516_21619[(1)] = (54));

} else {
var statearr_21517_21620 = state_21462__$1;
(statearr_21517_21620[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (25))){
var inst_21235 = (state_21462[(13)]);
var inst_21239 = (state_21462[(17)]);
var inst_21300 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21301 = (function (){var segment_type = inst_21235;
var pred__21236 = inst_21239;
var expr__21237 = inst_21235;
var bindings = inst_21300;
return (function (p1__21221_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__21221_SHARP_);
});
})();
var inst_21302 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_21301,inst_21300);
var inst_21303 = cljs.core.PersistentHashMap.EMPTY;
var inst_21304 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_21303,inst_21302);
var inst_21305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21306 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_21304);
var inst_21307 = [inst_21306,r];
var inst_21308 = (new cljs.core.PersistentVector(null,2,(5),inst_21305,inst_21307,null));
var state_21462__$1 = state_21462;
var statearr_21518_21621 = state_21462__$1;
(statearr_21518_21621[(2)] = inst_21308);

(statearr_21518_21621[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (34))){
var inst_21339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21340 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_21341 = [inst_21340,r];
var inst_21342 = (new cljs.core.PersistentVector(null,2,(5),inst_21339,inst_21341,null));
var state_21462__$1 = state_21462;
var statearr_21519_21622 = state_21462__$1;
(statearr_21519_21622[(2)] = inst_21342);

(statearr_21519_21622[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (17))){
var inst_21296 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21520_21623 = state_21462__$1;
(statearr_21520_21623[(2)] = inst_21296);

(statearr_21520_21623[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (3))){
var inst_21460 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21462__$1,inst_21460);
} else {
if((state_val_21463 === (12))){
var inst_21242 = (state_21462[(22)]);
var inst_21246 = (state_21462[(2)]);
var inst_21247 = fluree.db.util.async.throw_err(inst_21246);
var inst_21248 = [inst_21247,r];
var inst_21249 = (new cljs.core.PersistentVector(null,2,(5),inst_21242,inst_21248,null));
var state_21462__$1 = state_21462;
var statearr_21521_21624 = state_21462__$1;
(statearr_21521_21624[(2)] = inst_21249);

(statearr_21521_21624[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (2))){
var _ = (function (){var statearr_21522 = state_21462;
(statearr_21522[(4)] = cljs.core.cons((5),(state_21462[(4)])));

return statearr_21522;
})();
var inst_21232 = cljs.core.map_QMARK_(clause);
var state_21462__$1 = state_21462;
if(inst_21232){
var statearr_21523_21625 = state_21462__$1;
(statearr_21523_21625[(1)] = (6));

} else {
var statearr_21524_21626 = state_21462__$1;
(statearr_21524_21626[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (66))){
var state_21462__$1 = state_21462;
var statearr_21525_21627 = state_21462__$1;
(statearr_21525_21627[(1)] = (68));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (23))){
var inst_21281 = (state_21462[(19)]);
var inst_21272 = (state_21462[(12)]);
var inst_21264 = inst_21272;
var inst_21265 = inst_21281;
var state_21462__$1 = (function (){var statearr_21527 = state_21462;
(statearr_21527[(10)] = inst_21265);

(statearr_21527[(16)] = inst_21264);

return statearr_21527;
})();
var statearr_21528_21628 = state_21462__$1;
(statearr_21528_21628[(2)] = null);

(statearr_21528_21628[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (47))){
var inst_21364 = (state_21462[(21)]);
var inst_21367 = (state_21462[(2)]);
var inst_21368 = fluree.db.util.async.throw_err(inst_21367);
var inst_21369 = [inst_21368,r];
var inst_21370 = (new cljs.core.PersistentVector(null,2,(5),inst_21364,inst_21369,null));
var state_21462__$1 = state_21462;
var statearr_21529_21629 = state_21462__$1;
(statearr_21529_21629[(2)] = inst_21370);

(statearr_21529_21629[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (35))){
var inst_21345 = (state_21462[(23)]);
var inst_21344 = cljs.core.count(clause);
var inst_21345__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_21344);
var state_21462__$1 = (function (){var statearr_21530 = state_21462;
(statearr_21530[(23)] = inst_21345__$1);

return statearr_21530;
})();
if(inst_21345__$1){
var statearr_21531_21630 = state_21462__$1;
(statearr_21531_21630[(1)] = (37));

} else {
var statearr_21532_21631 = state_21462__$1;
(statearr_21532_21631[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (19))){
var inst_21265 = (state_21462[(10)]);
var inst_21290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21291 = [inst_21265,r];
var inst_21292 = (new cljs.core.PersistentVector(null,2,(5),inst_21290,inst_21291,null));
var state_21462__$1 = state_21462;
var statearr_21533_21632 = state_21462__$1;
(statearr_21533_21632[(2)] = inst_21292);

(statearr_21533_21632[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (57))){
var inst_21407 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_21462__$1 = state_21462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(60),inst_21407);
} else {
if((state_val_21463 === (68))){
var inst_21411 = (state_21462[(7)]);
var inst_21412 = (state_21462[(8)]);
var inst_21429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21430 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_21411,res,inst_21412,fuel,max_fuel);
var state_21462__$1 = (function (){var statearr_21534 = state_21462;
(statearr_21534[(24)] = inst_21429);

return statearr_21534;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(71),inst_21430);
} else {
if((state_val_21463 === (11))){
var inst_21328 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21536_21633 = state_21462__$1;
(statearr_21536_21633[(2)] = inst_21328);

(statearr_21536_21633[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (9))){
var inst_21242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_21243 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_21244 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21243,res,fuel,max_fuel,opts);
var state_21462__$1 = (function (){var statearr_21537 = state_21462;
(statearr_21537[(22)] = inst_21242);

return statearr_21537;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(12),inst_21244);
} else {
if((state_val_21463 === (5))){
var _ = (function (){var statearr_21538 = state_21462;
(statearr_21538[(4)] = cljs.core.rest((state_21462[(4)])));

return statearr_21538;
})();
var state_21462__$1 = state_21462;
var ex21535 = (state_21462__$1[(2)]);
var statearr_21539_21634 = state_21462__$1;
(statearr_21539_21634[(5)] = ex21535);


if((ex21535 instanceof Error)){
var statearr_21540_21635 = state_21462__$1;
(statearr_21540_21635[(1)] = (4));

(statearr_21540_21635[(5)] = null);

} else {
throw ex21535;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (14))){
var inst_21235 = (state_21462[(13)]);
var inst_21239 = (state_21462[(17)]);
var inst_21298 = (function (){var G__21541 = new cljs.core.Keyword(null,"bind","bind",-113428417);
var G__21542 = inst_21235;
return (inst_21239.cljs$core$IFn$_invoke$arity$2 ? inst_21239.cljs$core$IFn$_invoke$arity$2(G__21541,G__21542) : inst_21239.call(null,G__21541,G__21542));
})();
var state_21462__$1 = state_21462;
if(cljs.core.truth_(inst_21298)){
var statearr_21543_21636 = state_21462__$1;
(statearr_21543_21636[(1)] = (25));

} else {
var statearr_21544_21637 = state_21462__$1;
(statearr_21544_21637[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (45))){
var inst_21372 = cljs.core.count(clause);
var inst_21373 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21372);
var state_21462__$1 = state_21462;
if(inst_21373){
var statearr_21545_21638 = state_21462__$1;
(statearr_21545_21638[(1)] = (48));

} else {
var statearr_21546_21639 = state_21462__$1;
(statearr_21546_21639[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (53))){
var inst_21447 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21547_21640 = state_21462__$1;
(statearr_21547_21640[(2)] = inst_21447);

(statearr_21547_21640[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (26))){
var inst_21235 = (state_21462[(13)]);
var inst_21239 = (state_21462[(17)]);
var inst_21310 = (function (){var G__21548 = new cljs.core.Keyword(null,"filter","filter",-948537934);
var G__21549 = inst_21235;
return (inst_21239.cljs$core$IFn$_invoke$arity$2 ? inst_21239.cljs$core$IFn$_invoke$arity$2(G__21548,G__21549) : inst_21239.call(null,G__21548,G__21549));
})();
var state_21462__$1 = state_21462;
if(cljs.core.truth_(inst_21310)){
var statearr_21550_21641 = state_21462__$1;
(statearr_21550_21641[(1)] = (28));

} else {
var statearr_21551_21642 = state_21462__$1;
(statearr_21551_21642[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (16))){
var inst_21271 = (state_21462[(15)]);
var inst_21264 = (state_21462[(16)]);
var inst_21270 = cljs.core.seq(inst_21264);
var inst_21271__$1 = cljs.core.first(inst_21270);
var inst_21272 = cljs.core.next(inst_21270);
var state_21462__$1 = (function (){var statearr_21552 = state_21462;
(statearr_21552[(12)] = inst_21272);

(statearr_21552[(15)] = inst_21271__$1);

return statearr_21552;
})();
if(cljs.core.truth_(inst_21271__$1)){
var statearr_21553_21643 = state_21462__$1;
(statearr_21553_21643[(1)] = (18));

} else {
var statearr_21554_21644 = state_21462__$1;
(statearr_21554_21644[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (38))){
var inst_21345 = (state_21462[(23)]);
var state_21462__$1 = state_21462;
var statearr_21555_21645 = state_21462__$1;
(statearr_21555_21645[(2)] = inst_21345);

(statearr_21555_21645[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (30))){
var inst_21322 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21556_21646 = state_21462__$1;
(statearr_21556_21646[(2)] = inst_21322);

(statearr_21556_21646[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (10))){
var inst_21235 = (state_21462[(13)]);
var inst_21239 = (state_21462[(17)]);
var inst_21251 = (function (){var G__21557 = new cljs.core.Keyword(null,"union","union",2142937499);
var G__21558 = inst_21235;
return (inst_21239.cljs$core$IFn$_invoke$arity$2 ? inst_21239.cljs$core$IFn$_invoke$arity$2(G__21557,G__21558) : inst_21239.call(null,G__21557,G__21558));
})();
var state_21462__$1 = state_21462;
if(cljs.core.truth_(inst_21251)){
var statearr_21559_21647 = state_21462__$1;
(statearr_21559_21647[(1)] = (13));

} else {
var statearr_21560_21648 = state_21462__$1;
(statearr_21560_21648[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (18))){
var inst_21271 = (state_21462[(15)]);
var inst_21274 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21271,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_21271,q_map,vars,fuel,max_fuel,opts));
var state_21462__$1 = state_21462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21462__$1,(21),inst_21274);
} else {
if((state_val_21463 === (52))){
var state_21462__$1 = state_21462;
var statearr_21561_21649 = state_21462__$1;
(statearr_21561_21649[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (67))){
var inst_21440 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21563_21650 = state_21462__$1;
(statearr_21563_21650[(2)] = inst_21440);

(statearr_21563_21650[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (71))){
var inst_21429 = (state_21462[(24)]);
var inst_21432 = (state_21462[(2)]);
var inst_21433 = fluree.db.util.async.throw_err(inst_21432);
var inst_21434 = [inst_21433,r];
var inst_21435 = (new cljs.core.PersistentVector(null,2,(5),inst_21429,inst_21434,null));
var state_21462__$1 = state_21462;
var statearr_21564_21651 = state_21462__$1;
(statearr_21564_21651[(2)] = inst_21435);

(statearr_21564_21651[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (42))){
var inst_21453 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21565_21652 = state_21462__$1;
(statearr_21565_21652[(2)] = inst_21453);

(statearr_21565_21652[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (37))){
var inst_21347 = cljs.core.second(clause);
var inst_21348 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_21347,"rdf:type");
var state_21462__$1 = state_21462;
var statearr_21566_21653 = state_21462__$1;
(statearr_21566_21653[(2)] = inst_21348);

(statearr_21566_21653[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (63))){
var inst_21442 = (state_21462[(2)]);
var state_21462__$1 = state_21462;
var statearr_21567_21654 = state_21462__$1;
(statearr_21567_21654[(2)] = inst_21442);

(statearr_21567_21654[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (8))){
var inst_21457 = (state_21462[(2)]);
var _ = (function (){var statearr_21568 = state_21462;
(statearr_21568[(4)] = cljs.core.rest((state_21462[(4)])));

return statearr_21568;
})();
var state_21462__$1 = state_21462;
var statearr_21569_21655 = state_21462__$1;
(statearr_21569_21655[(2)] = inst_21457);

(statearr_21569_21655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21463 === (49))){
var inst_21381 = cljs.core.count(clause);
var inst_21382 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_21381);
var state_21462__$1 = state_21462;
if(inst_21382){
var statearr_21570_21656 = state_21462__$1;
(statearr_21570_21656[(1)] = (51));

} else {
var statearr_21571_21657 = state_21462__$1;
(statearr_21571_21657[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0 = (function (){
var statearr_21572 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21572[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__);

(statearr_21572[(1)] = (1));

return statearr_21572;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1 = (function (state_21462){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21462);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21573){var ex__2730__auto__ = e21573;
var statearr_21574_21658 = state_21462;
(statearr_21574_21658[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21462[(4)]))){
var statearr_21575_21659 = state_21462;
(statearr_21575_21659[(1)] = cljs.core.first((state_21462[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21660 = state_21462;
state_21462 = G__21660;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__ = function(state_21462){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1.call(this,state_21462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21576 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21576[(6)] = c__2749__auto__);

return statearr_21576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__21662 = arguments.length;
switch (G__21662) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21742){
var state_val_21743 = (state_21742[(1)]);
if((state_val_21743 === (7))){
var inst_21737 = (state_21742[(2)]);
var _ = (function (){var statearr_21744 = state_21742;
(statearr_21744[(4)] = cljs.core.rest((state_21742[(4)])));

return statearr_21744;
})();
var state_21742__$1 = state_21742;
var statearr_21745_21793 = state_21742__$1;
(statearr_21745_21793[(2)] = inst_21737);

(statearr_21745_21793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (20))){
var inst_21702 = (state_21742[(7)]);
var inst_21714 = (state_21742[(2)]);
var inst_21684 = inst_21702;
var inst_21685 = inst_21714;
var state_21742__$1 = (function (){var statearr_21746 = state_21742;
(statearr_21746[(8)] = inst_21684);

(statearr_21746[(9)] = inst_21685);

return statearr_21746;
})();
var statearr_21747_21794 = state_21742__$1;
(statearr_21747_21794[(2)] = null);

(statearr_21747_21794[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (1))){
var state_21742__$1 = state_21742;
var statearr_21748_21795 = state_21742__$1;
(statearr_21748_21795[(2)] = null);

(statearr_21748_21795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (24))){
var inst_21702 = (state_21742[(7)]);
var inst_21701 = (state_21742[(10)]);
var inst_21685 = (state_21742[(9)]);
var inst_21722 = fluree.db.query.analytical.inner_join(inst_21685,inst_21701);
var inst_21684 = inst_21702;
var inst_21685__$1 = inst_21722;
var state_21742__$1 = (function (){var statearr_21749 = state_21742;
(statearr_21749[(8)] = inst_21684);

(statearr_21749[(9)] = inst_21685__$1);

return statearr_21749;
})();
var statearr_21750_21796 = state_21742__$1;
(statearr_21750_21796[(2)] = null);

(statearr_21750_21796[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (4))){
var inst_21663 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
var statearr_21752_21797 = state_21742__$1;
(statearr_21752_21797[(2)] = inst_21663);

(statearr_21752_21797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (15))){
var inst_21701 = (state_21742[(10)]);
var state_21742__$1 = state_21742;
if(cljs.core.truth_(inst_21701)){
var statearr_21753_21798 = state_21742__$1;
(statearr_21753_21798[(1)] = (18));

} else {
var statearr_21754_21799 = state_21742__$1;
(statearr_21754_21799[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (21))){
var inst_21702 = (state_21742[(7)]);
var inst_21685 = (state_21742[(9)]);
var tmp21751 = inst_21685;
var inst_21684 = inst_21702;
var inst_21685__$1 = tmp21751;
var state_21742__$1 = (function (){var statearr_21755 = state_21742;
(statearr_21755[(8)] = inst_21684);

(statearr_21755[(9)] = inst_21685__$1);

return statearr_21755;
})();
var statearr_21756_21800 = state_21742__$1;
(statearr_21756_21800[(2)] = null);

(statearr_21756_21800[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (13))){
var inst_21685 = (state_21742[(9)]);
var inst_21708 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_21685,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21709 = cljs.core.empty_QMARK_(inst_21708);
var state_21742__$1 = state_21742;
if(inst_21709){
var statearr_21757_21801 = state_21742__$1;
(statearr_21757_21801[(1)] = (15));

} else {
var statearr_21758_21802 = state_21742__$1;
(statearr_21758_21802[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (22))){
var state_21742__$1 = state_21742;
var statearr_21759_21803 = state_21742__$1;
(statearr_21759_21803[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (6))){
var inst_21684 = (state_21742[(8)]);
var inst_21691 = (state_21742[(11)]);
var inst_21690 = cljs.core.seq(inst_21684);
var inst_21691__$1 = cljs.core.first(inst_21690);
var inst_21692 = cljs.core.next(inst_21690);
var state_21742__$1 = (function (){var statearr_21761 = state_21742;
(statearr_21761[(11)] = inst_21691__$1);

(statearr_21761[(12)] = inst_21692);

return statearr_21761;
})();
if(cljs.core.truth_(inst_21691__$1)){
var statearr_21762_21804 = state_21742__$1;
(statearr_21762_21804[(1)] = (8));

} else {
var statearr_21763_21805 = state_21742__$1;
(statearr_21763_21805[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (25))){
var state_21742__$1 = state_21742;
var statearr_21764_21806 = state_21742__$1;
(statearr_21764_21806[(2)] = null);

(statearr_21764_21806[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (17))){
var inst_21730 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
var statearr_21765_21807 = state_21742__$1;
(statearr_21765_21807[(2)] = inst_21730);

(statearr_21765_21807[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (3))){
var inst_21740 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21742__$1,inst_21740);
} else {
if((state_val_21743 === (12))){
var inst_21702 = (state_21742[(7)]);
var inst_21701 = (state_21742[(10)]);
var inst_21684 = inst_21702;
var inst_21685 = inst_21701;
var state_21742__$1 = (function (){var statearr_21766 = state_21742;
(statearr_21766[(8)] = inst_21684);

(statearr_21766[(9)] = inst_21685);

return statearr_21766;
})();
var statearr_21767_21808 = state_21742__$1;
(statearr_21767_21808[(2)] = null);

(statearr_21767_21808[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (2))){
var _ = (function (){var statearr_21768 = state_21742;
(statearr_21768[(4)] = cljs.core.cons((5),(state_21742[(4)])));

return statearr_21768;
})();
var inst_21676 = where;
var inst_21677 = cljs.core.seq(inst_21676);
var inst_21678 = cljs.core.first(inst_21677);
var inst_21679 = cljs.core.next(inst_21677);
var inst_21680 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_21681 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_21682 = [inst_21681];
var inst_21683 = cljs.core.PersistentHashMap.fromArrays(inst_21680,inst_21682);
var inst_21684 = inst_21676;
var inst_21685 = inst_21683;
var state_21742__$1 = (function (){var statearr_21769 = state_21742;
(statearr_21769[(13)] = inst_21678);

(statearr_21769[(14)] = inst_21679);

(statearr_21769[(8)] = inst_21684);

(statearr_21769[(9)] = inst_21685);

return statearr_21769;
})();
var statearr_21770_21809 = state_21742__$1;
(statearr_21770_21809[(2)] = null);

(statearr_21770_21809[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (23))){
var inst_21728 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
var statearr_21771_21810 = state_21742__$1;
(statearr_21771_21810[(2)] = inst_21728);

(statearr_21771_21810[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (19))){
var inst_21685 = (state_21742[(9)]);
var state_21742__$1 = state_21742;
var statearr_21772_21811 = state_21742__$1;
(statearr_21772_21811[(2)] = inst_21685);

(statearr_21772_21811[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (11))){
var inst_21691 = (state_21742[(11)]);
var inst_21699 = (state_21742[(2)]);
var inst_21700 = fluree.db.util.async.throw_err(inst_21699);
var inst_21701 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21700,(0),null);
var inst_21702 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_21700,(1),null);
var inst_21703 = cljs.core.count(inst_21691);
var inst_21704 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_21703);
var state_21742__$1 = (function (){var statearr_21774 = state_21742;
(statearr_21774[(7)] = inst_21702);

(statearr_21774[(10)] = inst_21701);

return statearr_21774;
})();
if(inst_21704){
var statearr_21775_21812 = state_21742__$1;
(statearr_21775_21812[(1)] = (12));

} else {
var statearr_21776_21813 = state_21742__$1;
(statearr_21776_21813[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (9))){
var inst_21685 = (state_21742[(9)]);
var state_21742__$1 = state_21742;
var statearr_21777_21814 = state_21742__$1;
(statearr_21777_21814[(2)] = inst_21685);

(statearr_21777_21814[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (5))){
var _ = (function (){var statearr_21778 = state_21742;
(statearr_21778[(4)] = cljs.core.rest((state_21742[(4)])));

return statearr_21778;
})();
var state_21742__$1 = state_21742;
var ex21773 = (state_21742__$1[(2)]);
var statearr_21779_21815 = state_21742__$1;
(statearr_21779_21815[(5)] = ex21773);


if((ex21773 instanceof Error)){
var statearr_21780_21816 = state_21742__$1;
(statearr_21780_21816[(1)] = (4));

(statearr_21780_21816[(5)] = null);

} else {
throw ex21773;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (14))){
var inst_21732 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
var statearr_21781_21817 = state_21742__$1;
(statearr_21781_21817[(2)] = inst_21732);

(statearr_21781_21817[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (26))){
var inst_21726 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
var statearr_21782_21818 = state_21742__$1;
(statearr_21782_21818[(2)] = inst_21726);

(statearr_21782_21818[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (16))){
var inst_21701 = (state_21742[(10)]);
var inst_21717 = (inst_21701 == null);
var state_21742__$1 = state_21742;
if(cljs.core.truth_(inst_21717)){
var statearr_21783_21819 = state_21742__$1;
(statearr_21783_21819[(1)] = (21));

} else {
var statearr_21784_21820 = state_21742__$1;
(statearr_21784_21820[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (10))){
var inst_21735 = (state_21742[(2)]);
var state_21742__$1 = state_21742;
var statearr_21785_21821 = state_21742__$1;
(statearr_21785_21821[(2)] = inst_21735);

(statearr_21785_21821[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (18))){
var inst_21701 = (state_21742[(10)]);
var state_21742__$1 = state_21742;
var statearr_21786_21822 = state_21742__$1;
(statearr_21786_21822[(2)] = inst_21701);

(statearr_21786_21822[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21743 === (8))){
var inst_21691 = (state_21742[(11)]);
var inst_21685 = (state_21742[(9)]);
var inst_21692 = (state_21742[(12)]);
var inst_21697 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_21685,inst_21691,inst_21692,false,fuel,max_fuel,opts);
var state_21742__$1 = state_21742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21742__$1,(11),inst_21697);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2727__auto__ = null;
var fluree$db$query$analytical$state_machine__2727__auto____0 = (function (){
var statearr_21787 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21787[(0)] = fluree$db$query$analytical$state_machine__2727__auto__);

(statearr_21787[(1)] = (1));

return statearr_21787;
});
var fluree$db$query$analytical$state_machine__2727__auto____1 = (function (state_21742){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21742);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21788){var ex__2730__auto__ = e21788;
var statearr_21789_21823 = state_21742;
(statearr_21789_21823[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21742[(4)]))){
var statearr_21790_21824 = state_21742;
(statearr_21790_21824[(1)] = cljs.core.first((state_21742[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21825 = state_21742;
state_21742 = G__21825;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2727__auto__ = function(state_21742){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2727__auto____1.call(this,state_21742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2727__auto____0;
fluree$db$query$analytical$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2727__auto____1;
return fluree$db$query$analytical$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21791 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21791[(6)] = c__2749__auto__);

return statearr_21791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_21860){
var state_val_21861 = (state_21860[(1)]);
if((state_val_21861 === (7))){
var inst_21842 = (state_21860[(7)]);
var inst_21837 = (state_21860[(8)]);
var inst_21844 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_21837,inst_21842,fuel,max_fuel,opts);
var state_21860__$1 = state_21860;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21860__$1,(10),inst_21844);
} else {
if((state_val_21861 === (1))){
var state_21860__$1 = state_21860;
var statearr_21862_21887 = state_21860__$1;
(statearr_21862_21887[(2)] = null);

(statearr_21862_21887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (4))){
var inst_21826 = (state_21860[(2)]);
var state_21860__$1 = state_21860;
var statearr_21863_21888 = state_21860__$1;
(statearr_21863_21888[(2)] = inst_21826);

(statearr_21863_21888[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (13))){
var inst_21855 = (state_21860[(2)]);
var _ = (function (){var statearr_21864 = state_21860;
(statearr_21864[(4)] = cljs.core.rest((state_21860[(4)])));

return statearr_21864;
})();
var state_21860__$1 = state_21860;
var statearr_21865_21889 = state_21860__$1;
(statearr_21865_21889[(2)] = inst_21855);

(statearr_21865_21889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (6))){
var inst_21837 = (state_21860[(8)]);
var inst_21841 = (state_21860[(2)]);
var inst_21842 = fluree.db.util.async.throw_err(inst_21841);
var state_21860__$1 = (function (){var statearr_21866 = state_21860;
(statearr_21866[(7)] = inst_21842);

return statearr_21866;
})();
if(cljs.core.truth_(inst_21837)){
var statearr_21867_21890 = state_21860__$1;
(statearr_21867_21890[(1)] = (7));

} else {
var statearr_21868_21891 = state_21860__$1;
(statearr_21868_21891[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (3))){
var inst_21858 = (state_21860[(2)]);
var state_21860__$1 = state_21860;
return cljs.core.async.impl.ioc_helpers.return_chan(state_21860__$1,inst_21858);
} else {
if((state_val_21861 === (12))){
var inst_21850 = (state_21860[(9)]);
var state_21860__$1 = state_21860;
var statearr_21869_21892 = state_21860__$1;
(statearr_21869_21892[(2)] = inst_21850);

(statearr_21869_21892[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (2))){
var _ = (function (){var statearr_21870 = state_21860;
(statearr_21870[(4)] = cljs.core.cons((5),(state_21860[(4)])));

return statearr_21870;
})();
var inst_21833 = q_map;
var inst_21834 = cljs.core.__destructure_map(inst_21833);
var inst_21835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21834,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_21836 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21834,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_21837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21834,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_21838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_21834,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_21839 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_21836,q_map,inst_21835,fuel,max_fuel,opts);
var state_21860__$1 = (function (){var statearr_21871 = state_21860;
(statearr_21871[(8)] = inst_21837);

(statearr_21871[(10)] = inst_21838);

return statearr_21871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_21860__$1,(6),inst_21839);
} else {
if((state_val_21861 === (11))){
var inst_21850 = (state_21860[(9)]);
var inst_21838 = (state_21860[(10)]);
var inst_21852 = fluree.db.query.analytical.tuples__GT_filtered(inst_21850,inst_21838,null);
var state_21860__$1 = state_21860;
var statearr_21873_21893 = state_21860__$1;
(statearr_21873_21893[(2)] = inst_21852);

(statearr_21873_21893[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (9))){
var inst_21838 = (state_21860[(10)]);
var inst_21850 = (state_21860[(2)]);
var state_21860__$1 = (function (){var statearr_21874 = state_21860;
(statearr_21874[(9)] = inst_21850);

return statearr_21874;
})();
if(cljs.core.truth_(inst_21838)){
var statearr_21875_21894 = state_21860__$1;
(statearr_21875_21894[(1)] = (11));

} else {
var statearr_21876_21895 = state_21860__$1;
(statearr_21876_21895[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (5))){
var _ = (function (){var statearr_21877 = state_21860;
(statearr_21877[(4)] = cljs.core.rest((state_21860[(4)])));

return statearr_21877;
})();
var state_21860__$1 = state_21860;
var ex21872 = (state_21860__$1[(2)]);
var statearr_21878_21896 = state_21860__$1;
(statearr_21878_21896[(5)] = ex21872);


if((ex21872 instanceof Error)){
var statearr_21879_21897 = state_21860__$1;
(statearr_21879_21897[(1)] = (4));

(statearr_21879_21897[(5)] = null);

} else {
throw ex21872;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (10))){
var inst_21846 = (state_21860[(2)]);
var inst_21847 = fluree.db.util.async.throw_err(inst_21846);
var state_21860__$1 = state_21860;
var statearr_21880_21898 = state_21860__$1;
(statearr_21880_21898[(2)] = inst_21847);

(statearr_21880_21898[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21861 === (8))){
var inst_21842 = (state_21860[(7)]);
var state_21860__$1 = state_21860;
var statearr_21881_21899 = state_21860__$1;
(statearr_21881_21899[(2)] = inst_21842);

(statearr_21881_21899[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2727__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2727__auto____0 = (function (){
var statearr_21882 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21882[(0)] = fluree$db$query$analytical$q_$_state_machine__2727__auto__);

(statearr_21882[(1)] = (1));

return statearr_21882;
});
var fluree$db$query$analytical$q_$_state_machine__2727__auto____1 = (function (state_21860){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_21860);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e21883){var ex__2730__auto__ = e21883;
var statearr_21884_21900 = state_21860;
(statearr_21884_21900[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_21860[(4)]))){
var statearr_21885_21901 = state_21860;
(statearr_21885_21901[(1)] = cljs.core.first((state_21860[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21902 = state_21860;
state_21860 = G__21902;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2727__auto__ = function(state_21860){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2727__auto____1.call(this,state_21860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2727__auto____0;
fluree$db$query$analytical$q_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2727__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_21886 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_21886[(6)] = c__2749__auto__);

return statearr_21886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
