// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__18265 = arguments.length;
switch (G__18265) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,ledger){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,ledger,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,ledger,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__18268 = arguments.length;
switch (G__18268) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___18321 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18299){
var state_val_18300 = (state_18299[(1)]);
if((state_val_18300 === (1))){
var state_18299__$1 = state_18299;
var statearr_18301_18322 = state_18299__$1;
(statearr_18301_18322[(2)] = null);

(statearr_18301_18322[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (2))){
var _ = (function (){var statearr_18302 = state_18299;
(statearr_18302[(4)] = cljs.core.cons((5),(state_18299[(4)])));

return statearr_18302;
})();
var inst_18276 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_18299__$1 = state_18299;
if(cljs.core.truth_(inst_18276)){
var statearr_18303_18323 = state_18299__$1;
(statearr_18303_18323[(1)] = (6));

} else {
var statearr_18304_18324 = state_18299__$1;
(statearr_18304_18324[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (3))){
var inst_18297 = (state_18299[(2)]);
var state_18299__$1 = state_18299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18299__$1,inst_18297);
} else {
if((state_val_18300 === (4))){
var inst_18269 = (state_18299[(2)]);
var inst_18270 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_18269);
var state_18299__$1 = state_18299;
var statearr_18306_18325 = state_18299__$1;
(statearr_18306_18325[(2)] = inst_18270);

(statearr_18306_18325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (5))){
var _ = (function (){var statearr_18307 = state_18299;
(statearr_18307[(4)] = cljs.core.rest((state_18299[(4)])));

return statearr_18307;
})();
var state_18299__$1 = state_18299;
var ex18305 = (state_18299__$1[(2)]);
var statearr_18308_18326 = state_18299__$1;
(statearr_18308_18326[(5)] = ex18305);


var statearr_18309_18327 = state_18299__$1;
(statearr_18309_18327[(1)] = (4));

(statearr_18309_18327[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (6))){
var inst_18278 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18279 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_18280 = cljs.core.PersistentHashMap.fromArrays(inst_18278,inst_18279);
var inst_18281 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_18280);
var inst_18282 = (function(){throw inst_18281})();
var state_18299__$1 = state_18299;
var statearr_18310_18328 = state_18299__$1;
(statearr_18310_18328[(2)] = inst_18282);

(statearr_18310_18328[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (7))){
var inst_18284 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_18285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18286 = [operation,data,pc,opts];
var inst_18287 = (new cljs.core.PersistentVector(null,4,(5),inst_18285,inst_18286,null));
var inst_18288 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_18284,inst_18287);
var inst_18289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18290 = [operation,data,pc,opts];
var inst_18291 = (new cljs.core.PersistentVector(null,4,(5),inst_18289,inst_18290,null));
var inst_18292 = (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Put operation on connection req-chan: ",inst_18291) : fluree.db.util.log.trace.call(null,"Put operation on connection req-chan: ",inst_18291));
var state_18299__$1 = (function (){var statearr_18311 = state_18299;
(statearr_18311[(7)] = inst_18288);

return statearr_18311;
})();
var statearr_18312_18329 = state_18299__$1;
(statearr_18312_18329[(2)] = inst_18292);

(statearr_18312_18329[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18300 === (8))){
var inst_18294 = (state_18299[(2)]);
var _ = (function (){var statearr_18313 = state_18299;
(statearr_18313[(4)] = cljs.core.rest((state_18299[(4)])));

return statearr_18313;
})();
var state_18299__$1 = state_18299;
var statearr_18314_18330 = state_18299__$1;
(statearr_18314_18330[(2)] = inst_18294);

(statearr_18314_18330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_18315 = [null,null,null,null,null,null,null,null];
(statearr_18315[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_18315[(1)] = (1));

return statearr_18315;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_18299){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18299);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18316){var ex__2730__auto__ = e18316;
var statearr_18317_18331 = state_18299;
(statearr_18317_18331[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18299[(4)]))){
var statearr_18318_18332 = state_18299;
(statearr_18318_18332[(1)] = cljs.core.first((state_18299[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18333 = state_18299;
state_18299 = G__18333;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_18299){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_18299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18319 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18319[(6)] = c__2749__auto___18321);

return statearr_18319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__18335 = arguments.length;
switch (G__18335) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__18336){
var map__18337 = p__18336;
var map__18337__$1 = cljs.core.__destructure_map(map__18337);
var opts = map__18337__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18337__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__18338 = session;
var map__18338__$1 = cljs.core.__destructure_map(map__18338);
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18338__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18338__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18338__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__5775__auto__ = [];
var len__5769__auto___18365 = arguments.length;
var i__5770__auto___18366 = (0);
while(true){
if((i__5770__auto___18366 < len__5769__auto___18365)){
args__5775__auto__.push((arguments[i__5770__auto___18366]));

var G__18367 = (i__5770__auto___18366 + (1));
i__5770__auto___18366 = G__18367;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__18342){
var vec__18343 = p__18342;
var map__18346 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18343,(0),null);
var map__18346__$1 = cljs.core.__destructure_map(map__18346);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18346__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18346__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__18343;
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_18358){
var state_val_18359 = (state_18358[(1)]);
if((state_val_18359 === (1))){
var inst_18348 = session;
var inst_18349 = cljs.core.__destructure_map(inst_18348);
var inst_18350 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18349,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_18351 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18349,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var inst_18352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_18349,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_18353 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_18354 = [inst_18350,inst_18351,toBlock,toTime];
var inst_18355 = cljs.core.PersistentHashMap.fromArrays(inst_18353,inst_18354);
var inst_18356 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_18352,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_18355);
var state_18358__$1 = state_18358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_18358__$1,inst_18356);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2727__auto__ = null;
var fluree$db$operations$state_machine__2727__auto____0 = (function (){
var statearr_18360 = [null,null,null,null,null,null,null];
(statearr_18360[(0)] = fluree$db$operations$state_machine__2727__auto__);

(statearr_18360[(1)] = (1));

return statearr_18360;
});
var fluree$db$operations$state_machine__2727__auto____1 = (function (state_18358){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_18358);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e18361){var ex__2730__auto__ = e18361;
var statearr_18362_18368 = state_18358;
(statearr_18362_18368[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_18358[(4)]))){
var statearr_18363_18369 = state_18358;
(statearr_18363_18369[(1)] = cljs.core.first((state_18358[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18370 = state_18358;
state_18358 = G__18370;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2727__auto__ = function(state_18358){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2727__auto____1.call(this,state_18358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2727__auto____0;
fluree$db$operations$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2727__auto____1;
return fluree$db$operations$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_18364 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_18364[(6)] = c__2749__auto__);

return statearr_18364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq18340){
var G__18341 = cljs.core.first(seq18340);
var seq18340__$1 = cljs.core.next(seq18340);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__18341,seq18340__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__18371 = session;
var map__18371__$1 = cljs.core.__destructure_map(map__18371);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18371__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18371__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18371__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-ledger","snapshot-ledger",-1972847996),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if ledger doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-list","ledger-list",-945136952),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
(fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$2("Sending transaction async: ",tx_map) : fluree.db.util.log.trace.call(null,"Sending transaction async: ",tx_map));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__18373 = arguments.length;
switch (G__18373) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__18374 = opts;
var map__18374__$1 = cljs.core.__destructure_map(map__18374);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18374__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18374__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__5045__auto__ = auth;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return jwt;
}
})();
var _ = (function (){var G__18375 = "Subscribe to: ";
var G__18376 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var G__18377 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var G__18378 = auth_or_jwt;
return (fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4 ? fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$4(G__18375,G__18376,G__18377,G__18378) : fluree.db.util.log.trace.call(null,G__18375,G__18376,G__18377,G__18378));
})();
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsubscribe","unsubscribe",632650147),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session)], null));
});
