// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
/**
 * Map of default index comparators for the five index types
 */
fluree.db.index.default_comparators = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"post","post",269697687),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"tspo","tspo",-440144953),fluree.db.flake.cmp_flakes_block], null);
/**
 * The five possible index orderings based on the subject, predicate, object,
 *   and transaction flake attributes
 */
fluree.db.index.types = cljs.core.set(cljs.core.keys(fluree.db.index.default_comparators));
/**
 * Returns `true` if `node` is a map for a leaf node
 */
fluree.db.index.leaf_QMARK_ = (function fluree$db$index$leaf_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === true;
});
/**
 * Returns `true` if `node` is a map for branch node
 */
fluree.db.index.branch_QMARK_ = (function fluree$db$index$branch_QMARK_(node){
return new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node) === false;
});

/**
 * @interface
 */
fluree.db.index.Resolver = function(){};

var fluree$db$index$Resolver$resolve$dyn_14655 = (function (r,node){
var x__5393__auto__ = (((r == null))?null:r);
var m__5394__auto__ = (fluree.db.index.resolve[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5394__auto__.call(null,r,node));
} else {
var m__5392__auto__ = (fluree.db.index.resolve["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(r,node) : m__5392__auto__.call(null,r,node));
} else {
throw cljs.core.missing_protocol("Resolver.resolve",r);
}
}
});
/**
 * Populate index branch and leaf node maps with either their child node
 *   attributes or the flakes the store, respectively.
 */
fluree.db.index.resolve = (function fluree$db$index$resolve(r,node){
if((((!((r == null)))) && ((!((r.fluree$db$index$Resolver$resolve$arity$2 == null)))))){
return r.fluree$db$index$Resolver$resolve$arity$2(r,node);
} else {
return fluree$db$index$Resolver$resolve$dyn_14655(r,node);
}
});

fluree.db.index.try_resolve = (function fluree$db$index$try_resolve(r,error_ch,node){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14677){
var state_val_14678 = (state_14677[(1)]);
if((state_val_14678 === (1))){
var state_14677__$1 = state_14677;
var statearr_14679_14694 = state_14677__$1;
(statearr_14679_14694[(2)] = null);

(statearr_14679_14694[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14678 === (2))){
var _ = (function (){var statearr_14680 = state_14677;
(statearr_14680[(4)] = cljs.core.cons((6),(state_14677[(4)])));

return statearr_14680;
})();
var inst_14669 = fluree.db.index.resolve(r,node);
var state_14677__$1 = state_14677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14677__$1,(7),inst_14669);
} else {
if((state_val_14678 === (3))){
var inst_14675 = (state_14677[(2)]);
var state_14677__$1 = state_14677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14677__$1,inst_14675);
} else {
if((state_val_14678 === (4))){
var inst_14656 = (state_14677[(2)]);
var inst_14657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14658 = [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015)];
var inst_14659 = (new cljs.core.PersistentVector(null,3,(5),inst_14657,inst_14658,null));
var inst_14660 = cljs.core.select_keys(node,inst_14659);
var inst_14661 = (fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3 ? fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$3(inst_14656,"Error resolving index node:",inst_14660) : fluree.db.util.log.error.call(null,inst_14656,"Error resolving index node:",inst_14660));
var state_14677__$1 = (function (){var statearr_14682 = state_14677;
(statearr_14682[(7)] = inst_14661);

return statearr_14682;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14677__$1,(5),error_ch,inst_14656);
} else {
if((state_val_14678 === (5))){
var inst_14663 = (state_14677[(2)]);
var state_14677__$1 = state_14677;
var statearr_14683_14695 = state_14677__$1;
(statearr_14683_14695[(2)] = inst_14663);

(statearr_14683_14695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14678 === (6))){
var _ = (function (){var statearr_14684 = state_14677;
(statearr_14684[(4)] = cljs.core.rest((state_14677[(4)])));

return statearr_14684;
})();
var state_14677__$1 = state_14677;
var ex14681 = (state_14677__$1[(2)]);
var statearr_14685_14696 = state_14677__$1;
(statearr_14685_14696[(5)] = ex14681);


var statearr_14686_14697 = state_14677__$1;
(statearr_14686_14697[(1)] = (4));

(statearr_14686_14697[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14678 === (7))){
var inst_14671 = (state_14677[(2)]);
var inst_14672 = fluree.db.util.async.throw_err(inst_14671);
var _ = (function (){var statearr_14687 = state_14677;
(statearr_14687[(4)] = cljs.core.rest((state_14677[(4)])));

return statearr_14687;
})();
var state_14677__$1 = state_14677;
var statearr_14688_14698 = state_14677__$1;
(statearr_14688_14698[(2)] = inst_14672);

(statearr_14688_14698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$try_resolve_$_state_machine__2727__auto__ = null;
var fluree$db$index$try_resolve_$_state_machine__2727__auto____0 = (function (){
var statearr_14689 = [null,null,null,null,null,null,null,null];
(statearr_14689[(0)] = fluree$db$index$try_resolve_$_state_machine__2727__auto__);

(statearr_14689[(1)] = (1));

return statearr_14689;
});
var fluree$db$index$try_resolve_$_state_machine__2727__auto____1 = (function (state_14677){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14677);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14690){var ex__2730__auto__ = e14690;
var statearr_14691_14699 = state_14677;
(statearr_14691_14699[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14677[(4)]))){
var statearr_14692_14700 = state_14677;
(statearr_14692_14700[(1)] = cljs.core.first((state_14677[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14701 = state_14677;
state_14677 = G__14701;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$try_resolve_$_state_machine__2727__auto__ = function(state_14677){
switch(arguments.length){
case 0:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$try_resolve_$_state_machine__2727__auto____1.call(this,state_14677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$try_resolve_$_state_machine__2727__auto____0;
fluree$db$index$try_resolve_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$try_resolve_$_state_machine__2727__auto____1;
return fluree$db$index$try_resolve_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14693 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14693[(6)] = c__2749__auto__);

return statearr_14693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns `true` if the data associated with the index node map `node` is fully
 *   resolved from storage
 */
fluree.db.index.resolved_QMARK_ = (function fluree$db$index$resolved_QMARK_(node){
if(fluree.db.index.leaf_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
if(fluree.db.index.branch_QMARK_(node)){
return (!((new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(node) == null)));
} else {
return null;
}
}
});
fluree.db.index.lookup = (function fluree$db$index$lookup(branch,flake){
if(cljs.core.truth_((function (){var and__5043__auto__ = fluree.db.index.branch_QMARK_(branch);
if(and__5043__auto__){
return fluree.db.index.resolved_QMARK_(branch);
} else {
return and__5043__auto__;
}
})())){
var map__14702 = branch;
var map__14702__$1 = cljs.core.__destructure_map(map__14702);
var children = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14702__$1,new cljs.core.Keyword(null,"children","children",-940561982));
return cljs.core.val((function (){var or__5045__auto__ = clojure.data.avl.nearest(children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.first(children);
}
})());
} else {
return null;
}
});
fluree.db.index.lookup_leaf = (function fluree$db$index$lookup_leaf(r,branch,flake){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14738){
var state_val_14739 = (state_14738[(1)]);
if((state_val_14739 === (7))){
var inst_14709 = (state_14738[(7)]);
var state_14738__$1 = state_14738;
var statearr_14740_14771 = state_14738__$1;
(statearr_14740_14771[(2)] = inst_14709);

(statearr_14740_14771[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (1))){
var state_14738__$1 = state_14738;
var statearr_14741_14772 = state_14738__$1;
(statearr_14741_14772[(2)] = null);

(statearr_14741_14772[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (4))){
var inst_14703 = (state_14738[(2)]);
var state_14738__$1 = state_14738;
var statearr_14742_14773 = state_14738__$1;
(statearr_14742_14773[(2)] = inst_14703);

(statearr_14742_14773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (15))){
var inst_14717 = (state_14738[(8)]);
var inst_14722 = fluree.db.index.resolve(r,inst_14717);
var state_14738__$1 = state_14738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14738__$1,(17),inst_14722);
} else {
if((state_val_14739 === (13))){
var inst_14730 = (state_14738[(2)]);
var state_14738__$1 = state_14738;
var statearr_14743_14774 = state_14738__$1;
(statearr_14743_14774[(2)] = inst_14730);

(statearr_14743_14774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (6))){
var inst_14711 = fluree.db.index.resolved_QMARK_(branch);
var state_14738__$1 = state_14738;
var statearr_14744_14775 = state_14738__$1;
(statearr_14744_14775[(2)] = inst_14711);

(statearr_14744_14775[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (17))){
var inst_14724 = (state_14738[(2)]);
var inst_14725 = fluree.db.util.async.throw_err(inst_14724);
var inst_14717 = inst_14725;
var state_14738__$1 = (function (){var statearr_14745 = state_14738;
(statearr_14745[(8)] = inst_14717);

return statearr_14745;
})();
var statearr_14746_14776 = state_14738__$1;
(statearr_14746_14776[(2)] = null);

(statearr_14746_14776[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (3))){
var inst_14736 = (state_14738[(2)]);
var state_14738__$1 = state_14738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14738__$1,inst_14736);
} else {
if((state_val_14739 === (12))){
var inst_14717 = (state_14738[(8)]);
var inst_14719 = fluree.db.index.leaf_QMARK_(inst_14717);
var state_14738__$1 = state_14738;
if(inst_14719){
var statearr_14747_14777 = state_14738__$1;
(statearr_14747_14777[(1)] = (14));

} else {
var statearr_14748_14778 = state_14738__$1;
(statearr_14748_14778[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (2))){
var inst_14709 = (state_14738[(7)]);
var _ = (function (){var statearr_14749 = state_14738;
(statearr_14749[(4)] = cljs.core.cons((5),(state_14738[(4)])));

return statearr_14749;
})();
var inst_14709__$1 = fluree.db.index.branch_QMARK_(branch);
var state_14738__$1 = (function (){var statearr_14750 = state_14738;
(statearr_14750[(7)] = inst_14709__$1);

return statearr_14750;
})();
if(inst_14709__$1){
var statearr_14751_14779 = state_14738__$1;
(statearr_14751_14779[(1)] = (6));

} else {
var statearr_14752_14780 = state_14738__$1;
(statearr_14752_14780[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (11))){
var inst_14733 = (state_14738[(2)]);
var _ = (function (){var statearr_14754 = state_14738;
(statearr_14754[(4)] = cljs.core.rest((state_14738[(4)])));

return statearr_14754;
})();
var state_14738__$1 = state_14738;
var statearr_14755_14781 = state_14738__$1;
(statearr_14755_14781[(2)] = inst_14733);

(statearr_14755_14781[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (9))){
var inst_14716 = fluree.db.index.lookup(branch,flake);
var inst_14717 = inst_14716;
var state_14738__$1 = (function (){var statearr_14756 = state_14738;
(statearr_14756[(8)] = inst_14717);

return statearr_14756;
})();
var statearr_14757_14782 = state_14738__$1;
(statearr_14757_14782[(2)] = null);

(statearr_14757_14782[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (5))){
var _ = (function (){var statearr_14758 = state_14738;
(statearr_14758[(4)] = cljs.core.rest((state_14738[(4)])));

return statearr_14758;
})();
var state_14738__$1 = state_14738;
var ex14753 = (state_14738__$1[(2)]);
var statearr_14759_14783 = state_14738__$1;
(statearr_14759_14783[(5)] = ex14753);


if((ex14753 instanceof Error)){
var statearr_14760_14784 = state_14738__$1;
(statearr_14760_14784[(1)] = (4));

(statearr_14760_14784[(5)] = null);

} else {
throw ex14753;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (14))){
var inst_14717 = (state_14738[(8)]);
var state_14738__$1 = state_14738;
var statearr_14761_14785 = state_14738__$1;
(statearr_14761_14785[(2)] = inst_14717);

(statearr_14761_14785[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (16))){
var inst_14728 = (state_14738[(2)]);
var state_14738__$1 = state_14738;
var statearr_14762_14786 = state_14738__$1;
(statearr_14762_14786[(2)] = inst_14728);

(statearr_14762_14786[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (10))){
var state_14738__$1 = state_14738;
var statearr_14763_14787 = state_14738__$1;
(statearr_14763_14787[(2)] = null);

(statearr_14763_14787[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14739 === (8))){
var inst_14714 = (state_14738[(2)]);
var state_14738__$1 = state_14738;
if(cljs.core.truth_(inst_14714)){
var statearr_14764_14788 = state_14738__$1;
(statearr_14764_14788[(1)] = (9));

} else {
var statearr_14765_14789 = state_14738__$1;
(statearr_14765_14789[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = null;
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0 = (function (){
var statearr_14766 = [null,null,null,null,null,null,null,null,null];
(statearr_14766[(0)] = fluree$db$index$lookup_leaf_$_state_machine__2727__auto__);

(statearr_14766[(1)] = (1));

return statearr_14766;
});
var fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1 = (function (state_14738){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14738);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14767){var ex__2730__auto__ = e14767;
var statearr_14768_14790 = state_14738;
(statearr_14768_14790[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14738[(4)]))){
var statearr_14769_14791 = state_14738;
(statearr_14769_14791[(1)] = cljs.core.first((state_14738[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14792 = state_14738;
state_14738 = G__14792;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__ = function(state_14738){
switch(arguments.length){
case 0:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1.call(this,state_14738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____0;
fluree$db$index$lookup_leaf_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$lookup_leaf_$_state_machine__2727__auto____1;
return fluree$db$index$lookup_leaf_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14770 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14770[(6)] = c__2749__auto__);

return statearr_14770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.index.add_flakes = (function fluree$db$index$add_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.conj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14793 = new_leaf;
var G__14793__$1 = (((G__14793 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14793));
if((G__14793__$1 == null)){
return null;
} else {
return cljs.core.first(G__14793__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
fluree.db.index.rem_flakes = (function fluree$db$index$rem_flakes(leaf,flakes){
var new_leaf = cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$4(leaf,new cljs.core.Keyword(null,"flakes","flakes",1977895739),fluree.db.flake.disj_all,flakes),new cljs.core.Keyword(null,"size","size",1098693007),(function (size){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.size_flake,flakes));
}));
var new_first = (function (){var or__5045__auto__ = (function (){var G__14794 = new_leaf;
var G__14794__$1 = (((G__14794 == null))?null:new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__14794));
if((G__14794__$1 == null)){
return null;
} else {
return cljs.core.first(G__14794__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_leaf,new cljs.core.Keyword(null,"first","first",-644103046),new_first);
});
/**
 * Returns a blank leaf node map for the provided `network`, `ledger-id`, and index
 *   comparator `cmp`.
 */
fluree.db.index.empty_leaf = (function fluree$db$index$empty_leaf(network,ledger_id,cmp){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[(0),ledger_id,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.new_leaf = (function fluree$db$index$new_leaf(network,ledger_id,cmp,flakes){
var empty_set = fluree.db.flake.sorted_set_by(cmp);
return fluree.db.index.add_flakes(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(fluree.db.index.empty_leaf(network,ledger_id,cmp),new cljs.core.Keyword(null,"flakes","flakes",1977895739),empty_set),flakes);
});
/**
 * Checks if the `node` passed in the second argument is a descendant of the
 *   `branch` passed in the first argument
 */
fluree.db.index.descendant_QMARK_ = (function fluree$db$index$descendant_QMARK_(p__14795,p__14796){
var map__14797 = p__14795;
var map__14797__$1 = cljs.core.__destructure_map(map__14797);
var branch = map__14797__$1;
var cmp = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14797__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14797__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14797__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14797__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var map__14798 = p__14796;
var map__14798__$1 = cljs.core.__destructure_map(map__14798);
var node = map__14798__$1;
var node_first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14798__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var node_rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14798__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
if((!(fluree.db.index.branch_QMARK_(branch)))){
return false;
} else {
var and__5043__auto__ = (function (){var or__5045__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(first_flake,node_first) : cmp.call(null,first_flake,node_first)) > (0))));
}
})();
if(cljs.core.truth_(and__5043__auto__)){
return (((rhs == null)) || ((((!((node_rhs == null)))) && ((!(((cmp.cljs$core$IFn$_invoke$arity$2 ? cmp.cljs$core$IFn$_invoke$arity$2(node_rhs,rhs) : cmp.call(null,node_rhs,rhs)) > (0))))))));
} else {
return and__5043__auto__;
}
}
});
fluree.db.index.child_entry = (function fluree$db$index$child_entry(p__14799){
var map__14800 = p__14799;
var map__14800__$1 = cljs.core.__destructure_map(map__14800);
var node = map__14800__$1;
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14800__$1,new cljs.core.Keyword(null,"first","first",-644103046));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [first,node], null);
});
/**
 * Returns avl sorted map whose keys are the first flakes of the index node
 *   sequence `child-nodes`, and whose values are the corresponding nodes from
 *   `child-nodes`.
 */
fluree.db.index.child_map = (function fluree$db$index$child_map(var_args){
var args__5775__auto__ = [];
var len__5769__auto___14803 = arguments.length;
var i__5770__auto___14804 = (0);
while(true){
if((i__5770__auto___14804 < len__5769__auto___14803)){
args__5775__auto__.push((arguments[i__5770__auto___14804]));

var G__14805 = (i__5770__auto___14804 + (1));
i__5770__auto___14804 = G__14805;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic = (function (cmp,child_nodes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_map_by,cmp,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fluree.db.index.child_entry,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_nodes], 0)));
}));

(fluree.db.index.child_map.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.index.child_map.cljs$lang$applyTo = (function (seq14801){
var G__14802 = cljs.core.first(seq14801);
var seq14801__$1 = cljs.core.next(seq14801);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14802,seq14801__$1);
}));

/**
 * Returns a blank branch node which contains a single empty leaf node for the
 *   provided `network`, `ledger-id`, and index comparator `cmp`.
 */
fluree.db.index.empty_branch = (function fluree$db$index$empty_branch(network,ledger_id,cmp){
var child_node = fluree.db.index.empty_leaf(network,ledger_id,cmp);
var children = fluree.db.index.child_map.cljs$core$IFn$_invoke$arity$variadic(cmp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([child_node], 0));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739)],[children,(0),ledger_id,false,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),cmp,(0),network,fluree.db.flake.maximum,null]);
});
fluree.db.index.reset_children = (function fluree$db$index$reset_children(p__14806,new_child_nodes){
var map__14807 = p__14806;
var map__14807__$1 = cljs.core.__destructure_map(map__14807);
var branch = map__14807__$1;
var comparator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14807__$1,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14807__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var new_kids = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.index.child_map,comparator,new_child_nodes);
var new_first = (function (){var or__5045__auto__ = (function (){var G__14808 = new_kids;
var G__14808__$1 = (((G__14808 == null))?null:cljs.core.first(G__14808));
if((G__14808__$1 == null)){
return null;
} else {
return cljs.core.key(G__14808__$1);
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.flake.maximum;
}
})();
var new_size = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,size,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"size","size",1098693007),new_child_nodes));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(branch,new cljs.core.Keyword(null,"first","first",-644103046),new_first,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"size","size",1098693007),new_size,new cljs.core.Keyword(null,"children","children",-940561982),new_kids], 0));
});
fluree.db.index.new_branch = (function fluree$db$index$new_branch(network,ledger_id,cmp,child_nodes){
return fluree.db.index.reset_children(fluree.db.index.empty_branch(network,ledger_id,cmp),child_nodes);
});
/**
 * Returns `true` if `flake` has a transaction value after the provided `t`
 */
fluree.db.index.after_t_QMARK_ = (function fluree$db$index$after_t_QMARK_(t,flake){
return (fluree.db.flake.t(flake) < t);
});
/**
 * Returns a sequence containing only flakes from the flake set `flakes` with
 *   transaction values after the provided `t`.
 */
fluree.db.index.filter_after = (function fluree$db$index$filter_after(t,flakes){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t),flakes);
});
/**
 * Returns an avl-subset of the avl-set `flakes` with transaction values on or
 *   before the provided `t`.
 */
fluree.db.index.flakes_through = (function fluree$db$index$flakes_through(t,flakes){
return fluree.db.flake.disj_all(flakes,fluree.db.index.filter_after(t,flakes));
});
fluree.db.index.novelty_subrange = (function fluree$db$index$novelty_subrange(p__14809,through_t,novelty){
var map__14810 = p__14809;
var map__14810__$1 = cljs.core.__destructure_map(map__14810);
var node = map__14810__$1;
var first_flake = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14810__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14810__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14810__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var subrange = (cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__5043__auto__ = rhs;
if(cljs.core.truth_(and__5043__auto__)){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__5043__auto__ = (rhs == null);
if(and__5043__auto__){
return leftmost_QMARK_;
} else {
return and__5043__auto__;
}
})())?novelty:null))));
return fluree.db.index.flakes_through(through_t,subrange);
});
/**
 * Returns a sequence of flakes from the sorted set `flakes` that are out of date
 *   by the transaction `t` because `flakes` contains another flake with the same
 *   subject and predicate and a transaction value later than that flake but on or
 *   before `t`.
 */
fluree.db.index.stale_by = (function fluree$db$index$stale_by(t,flakes){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (flakes__$1){
var last_flake = cljs.core.last(flakes__$1);
if(cljs.core.truth_(fluree.db.flake.op(last_flake))){
return cljs.core.butlast(flakes__$1);
} else {
return flakes__$1;
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.s,fluree.db.flake.p,fluree.db.flake.o),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.index.after_t_QMARK_,t)),flakes))], 0));
});
/**
 * Returns a sorted set of flakes that are not out of date between the
 *   transactions `from-t` and `to-t`.
 */
fluree.db.index.t_range = (function fluree$db$index$t_range(p__14811,novelty,from_t,to_t){
var map__14812 = p__14811;
var map__14812__$1 = cljs.core.__destructure_map(map__14812);
var leaf = map__14812__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14812__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14812__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var latest = (function (){var G__14813 = flakes;
if((leaf_t > to_t)){
return fluree.db.flake.conj_all(G__14813,fluree.db.index.novelty_subrange(leaf,to_t,novelty));
} else {
return G__14813;
}
})();
var stale_flakes = fluree.db.index.stale_by(from_t,latest);
var subsequent = fluree.db.index.filter_after(to_t,latest);
var out_of_range = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(stale_flakes,subsequent);
return fluree.db.flake.disj_all(latest,out_of_range);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.CachedTRangeResolver = (function (node_resolver,novelty,from_t,to_t,async_cache,__meta,__extmap,__hash){
this.node_resolver = node_resolver;
this.novelty = novelty;
this.from_t = from_t;
this.to_t = to_t;
this.async_cache = async_cache;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.CachedTRangeResolver.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (_,p__14819){
var self__ = this;
var map__14820 = p__14819;
var map__14820__$1 = cljs.core.__destructure_map(map__14820);
var node = map__14820__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14820__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14820__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var tt_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14820__$1,new cljs.core.Keyword(null,"tt-id","tt-id",725587484));
var ___$1 = this;
if(fluree.db.index.branch_QMARK_(node)){
return fluree.db.index.resolve(self__.node_resolver,node);
} else {
var G__14821 = new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.index","t-range","fluree.db.index/t-range",437950593),id,tempid,tt_id,self__.from_t,self__.to_t], null);
var G__14822 = (function (___$2){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14840){
var state_val_14841 = (state_14840[(1)]);
if((state_val_14841 === (1))){
var state_14840__$1 = state_14840;
var statearr_14842_14877 = state_14840__$1;
(statearr_14842_14877[(2)] = null);

(statearr_14842_14877[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14841 === (2))){
var ___$3 = (function (){var statearr_14843 = state_14840;
(statearr_14843[(4)] = cljs.core.cons((5),(state_14840[(4)])));

return statearr_14843;
})();
var inst_14829 = fluree.db.index.resolve(self__.node_resolver,node);
var state_14840__$1 = state_14840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14840__$1,(6),inst_14829);
} else {
if((state_val_14841 === (3))){
var inst_14838 = (state_14840[(2)]);
var state_14840__$1 = state_14840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14840__$1,inst_14838);
} else {
if((state_val_14841 === (4))){
var inst_14823 = (state_14840[(2)]);
var state_14840__$1 = state_14840;
var statearr_14845_14878 = state_14840__$1;
(statearr_14845_14878[(2)] = inst_14823);

(statearr_14845_14878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14841 === (5))){
var ___$3 = (function (){var statearr_14846 = state_14840;
(statearr_14846[(4)] = cljs.core.rest((state_14840[(4)])));

return statearr_14846;
})();
var state_14840__$1 = state_14840;
var ex14844 = (state_14840__$1[(2)]);
var statearr_14847_14879 = state_14840__$1;
(statearr_14847_14879[(5)] = ex14844);


if((ex14844 instanceof Error)){
var statearr_14848_14880 = state_14840__$1;
(statearr_14848_14880[(1)] = (4));

(statearr_14848_14880[(5)] = null);

} else {
throw ex14844;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14841 === (6))){
var inst_14831 = (state_14840[(2)]);
var inst_14832 = fluree.db.util.async.throw_err(inst_14831);
var inst_14833 = fluree.db.index.t_range(inst_14832,self__.novelty,self__.from_t,self__.to_t);
var inst_14834 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_14832,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_14835 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_14834,new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_14833], 0));
var ___$3 = (function (){var statearr_14849 = state_14840;
(statearr_14849[(4)] = cljs.core.rest((state_14840[(4)])));

return statearr_14849;
})();
var state_14840__$1 = state_14840;
var statearr_14850_14881 = state_14840__$1;
(statearr_14850_14881[(2)] = inst_14835);

(statearr_14850_14881[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14851 = [null,null,null,null,null,null,null];
(statearr_14851[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14851[(1)] = (1));

return statearr_14851;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14840){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14840);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14852){var ex__2730__auto__ = e14852;
var statearr_14853_14882 = state_14840;
(statearr_14853_14882[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14840[(4)]))){
var statearr_14854_14883 = state_14840;
(statearr_14854_14883[(1)] = cljs.core.first((state_14840[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14884 = state_14840;
state_14840 = G__14884;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14840){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14855 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14855[(6)] = c__2749__auto__);

return statearr_14855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__14821,G__14822) : self__.async_cache.call(null,G__14821,G__14822));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k14815,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__14856 = k14815;
var G__14856__$1 = (((G__14856 instanceof cljs.core.Keyword))?G__14856.fqn:null);
switch (G__14856__$1) {
case "node-resolver":
return self__.node_resolver;

break;
case "novelty":
return self__.novelty;

break;
case "from-t":
return self__.from_t;

break;
case "to-t":
return self__.to_t;

break;
case "async-cache":
return self__.async_cache;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k14815,else__5346__auto__);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__14857){
var vec__14858 = p__14857;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14858,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14858,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.index.CachedTRangeResolver{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__14814){
var self__ = this;
var G__14814__$1 = this;
return (new cljs.core.RecordIter((0),G__14814__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__14861 = (function (coll__5340__auto__){
return (361103374 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__14861(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this14816,other14817){
var self__ = this;
var this14816__$1 = this;
return (((!((other14817 == null)))) && ((((this14816__$1.constructor === other14817.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14816__$1.node_resolver,other14817.node_resolver)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14816__$1.novelty,other14817.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14816__$1.from_t,other14817.from_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14816__$1.to_t,other14817.to_t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14816__$1.async_cache,other14817.async_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this14816__$1.__extmap,other14817.__extmap)))))))))))))));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),null,new cljs.core.Keyword(null,"from-t","from-t",1730913525),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"to-t","to-t",569467359),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k14815){
var self__ = this;
var this__5350__auto____$1 = this;
var G__14862 = k14815;
var G__14862__$1 = (((G__14862 instanceof cljs.core.Keyword))?G__14862.fqn:null);
switch (G__14862__$1) {
case "node-resolver":
case "novelty":
case "from-t":
case "to-t":
case "async-cache":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k14815);

}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__14814){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__14863 = cljs.core.keyword_identical_QMARK_;
var expr__14864 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__14866 = new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078);
var G__14867 = expr__14864;
return (pred__14863.cljs$core$IFn$_invoke$arity$2 ? pred__14863.cljs$core$IFn$_invoke$arity$2(G__14866,G__14867) : pred__14863.call(null,G__14866,G__14867));
})())){
return (new fluree.db.index.CachedTRangeResolver(G__14814,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14868 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024);
var G__14869 = expr__14864;
return (pred__14863.cljs$core$IFn$_invoke$arity$2 ? pred__14863.cljs$core$IFn$_invoke$arity$2(G__14868,G__14869) : pred__14863.call(null,G__14868,G__14869));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,G__14814,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14870 = new cljs.core.Keyword(null,"from-t","from-t",1730913525);
var G__14871 = expr__14864;
return (pred__14863.cljs$core$IFn$_invoke$arity$2 ? pred__14863.cljs$core$IFn$_invoke$arity$2(G__14870,G__14871) : pred__14863.call(null,G__14870,G__14871));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,G__14814,self__.to_t,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14872 = new cljs.core.Keyword(null,"to-t","to-t",569467359);
var G__14873 = expr__14864;
return (pred__14863.cljs$core$IFn$_invoke$arity$2 ? pred__14863.cljs$core$IFn$_invoke$arity$2(G__14872,G__14873) : pred__14863.call(null,G__14872,G__14873));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,G__14814,self__.async_cache,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__14874 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__14875 = expr__14864;
return (pred__14863.cljs$core$IFn$_invoke$arity$2 ? pred__14863.cljs$core$IFn$_invoke$arity$2(G__14874,G__14875) : pred__14863.call(null,G__14874,G__14875));
})())){
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,G__14814,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__14814),null));
}
}
}
}
}
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),self__.node_resolver,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"from-t","from-t",1730913525),self__.from_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"to-t","to-t",569467359),self__.to_t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null))], null),self__.__extmap));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__14814){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.index.CachedTRangeResolver(self__.node_resolver,self__.novelty,self__.from_t,self__.to_t,self__.async_cache,G__14814,self__.__extmap,self__.__hash));
}));

(fluree.db.index.CachedTRangeResolver.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.index.CachedTRangeResolver.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"node-resolver","node-resolver",-1971835691,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"from-t","from-t",-923522244,null),new cljs.core.Symbol(null,"to-t","to-t",-2084968410,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null)], null);
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$type = true);

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.index/CachedTRangeResolver",null,(1),null));
}));

(fluree.db.index.CachedTRangeResolver.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.index/CachedTRangeResolver");
}));

/**
 * Positional factory function for fluree.db.index/CachedTRangeResolver.
 */
fluree.db.index.__GT_CachedTRangeResolver = (function fluree$db$index$__GT_CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache){
return (new fluree.db.index.CachedTRangeResolver(node_resolver,novelty,from_t,to_t,async_cache,null,null,null));
});

/**
 * Factory function for fluree.db.index/CachedTRangeResolver, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_CachedTRangeResolver = (function fluree$db$index$map__GT_CachedTRangeResolver(G__14818){
var extmap__5385__auto__ = (function (){var G__14876 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__14818,new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891)], 0));
if(cljs.core.record_QMARK_(G__14818)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__14876);
} else {
return G__14876;
}
})();
return (new fluree.db.index.CachedTRangeResolver(new cljs.core.Keyword(null,"node-resolver","node-resolver",682600078).cljs$core$IFn$_invoke$arity$1(G__14818),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__14818),new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(G__14818),new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(G__14818),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__14818),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Find the value of `leaf` at transaction `t` by adding new flakes from
 *   `idx-novelty` to `leaf` if `t` is newer than `leaf`, or removing flakes later
 *   than `t` from `leaf` if `t` is older than `leaf`.
 */
fluree.db.index.at_t = (function fluree$db$index$at_t(p__14887,t,idx_novelty){
var map__14888 = p__14887;
var map__14888__$1 = cljs.core.__destructure_map(map__14888);
var leaf = map__14888__$1;
var leaf_t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14888__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var rhs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14888__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var leftmost_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14888__$1,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14888__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(leaf_t,t)){
return leaf;
} else {
var G__14889 = leaf;
var G__14889__$1 = (((leaf_t > t))?fluree.db.index.add_flakes(G__14889,fluree.db.index.novelty_subrange(leaf,t,idx_novelty)):G__14889);
var G__14889__$2 = (((leaf_t < t))?fluree.db.index.rem_flakes(G__14889__$1,fluree.db.index.filter_after(t,flakes)):G__14889__$1);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14889__$2,new cljs.core.Keyword(null,"t","t",-1397832519),t);

}
});
fluree.db.index.mark_expanded = (function fluree$db$index$mark_expanded(node){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179),true);
});
fluree.db.index.unmark_expanded = (function fluree$db$index$unmark_expanded(node){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(node,new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179));
});
fluree.db.index.expanded_QMARK_ = (function fluree$db$index$expanded_QMARK_(node){
return new cljs.core.Keyword("fluree.db.index","expanded","fluree.db.index/expanded",-1916776179).cljs$core$IFn$_invoke$arity$1(node) === true;
});
fluree.db.index.resolve_when = (function fluree$db$index$resolve_when(r,resolve_QMARK_,error_ch,node){
if(cljs.core.truth_((resolve_QMARK_.cljs$core$IFn$_invoke$arity$1 ? resolve_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : resolve_QMARK_.call(null,node)))){
return fluree.db.index.try_resolve(r,error_ch,node);
} else {
var G__14890 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(G__14890,node);

return G__14890;
}
});
fluree.db.index.resolve_children_when = (function fluree$db$index$resolve_children_when(r,resolve_QMARK_,error_ch,branch){
if(cljs.core.truth_(fluree.db.index.resolved_QMARK_(branch))){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__14891){
var vec__14892 = p__14891;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14892,(0),null);
var child = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14892,(1),null);
return fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,child);
}),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(branch)));
} else {
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14897){
var state_val_14898 = (state_14897[(1)]);
if((state_val_14898 === (1))){
var inst_14895 = cljs.core.PersistentVector.EMPTY;
var state_14897__$1 = state_14897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14897__$1,inst_14895);
} else {
return null;
}
});
return (function() {
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = null;
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0 = (function (){
var statearr_14899 = [null,null,null,null,null,null,null];
(statearr_14899[(0)] = fluree$db$index$resolve_children_when_$_state_machine__2727__auto__);

(statearr_14899[(1)] = (1));

return statearr_14899;
});
var fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1 = (function (state_14897){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14897);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14900){var ex__2730__auto__ = e14900;
var statearr_14901_14904 = state_14897;
(statearr_14901_14904[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14897[(4)]))){
var statearr_14902_14905 = state_14897;
(statearr_14902_14905[(1)] = cljs.core.first((state_14897[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14906 = state_14897;
state_14897 = G__14906;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__ = function(state_14897){
switch(arguments.length){
case 0:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1.call(this,state_14897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____0;
fluree$db$index$resolve_children_when_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$resolve_children_when_$_state_machine__2727__auto____1;
return fluree$db$index$resolve_children_when_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14903 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14903[(6)] = c__2749__auto__);

return statearr_14903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}
});
/**
 * Returns a channel that will eventually contain the stream of index nodes
 *   descended from `root` in depth-first order. `resolve?` is a boolean function
 *   that will be applied to each node to determine whether or not the data
 *   associated with that node will be resolved from disk using the supplied
 *   `Resolver` `r`. `include?` is a boolean function that will be applied to each
 *   node to determine if it will be included in the final output node stream, `n`
 *   is an optional parameter specifying the number of nodes to load concurrently,
 *   and `xf` is an optional transducer that will transform the output stream if
 *   supplied.
 */
fluree.db.index.tree_chan = (function fluree$db$index$tree_chan(var_args){
var G__14908 = arguments.length;
switch (G__14908) {
case 5:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 7:
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$5 = (function (r,root,resolve_QMARK_,include_QMARK_,error_ch){
return fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7(r,root,resolve_QMARK_,include_QMARK_,(1),cljs.core.identity,error_ch);
}));

(fluree.db.index.tree_chan.cljs$core$IFn$_invoke$arity$7 = (function (r,root,resolve_QMARK_,include_QMARK_,n,xf,error_ch){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(n,xf);
var c__2749__auto___14986 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_14954){
var state_val_14955 = (state_14954[(1)]);
if((state_val_14955 === (7))){
var inst_14949 = (state_14954[(2)]);
var state_14954__$1 = state_14954;
var statearr_14956_14987 = state_14954__$1;
(statearr_14956_14987[(2)] = inst_14949);

(statearr_14956_14987[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (1))){
var inst_14909 = fluree.db.index.resolve_when(r,resolve_QMARK_,error_ch,root);
var state_14954__$1 = state_14954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14954__$1,(2),inst_14909);
} else {
if((state_val_14955 === (4))){
var inst_14951 = (state_14954[(2)]);
var inst_14952 = cljs.core.async.close_BANG_(out);
var state_14954__$1 = (function (){var statearr_14957 = state_14954;
(statearr_14957[(7)] = inst_14951);

return statearr_14957;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14954__$1,inst_14952);
} else {
if((state_val_14955 === (15))){
var state_14954__$1 = state_14954;
var statearr_14958_14988 = state_14954__$1;
(statearr_14958_14988[(2)] = null);

(statearr_14958_14988[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (13))){
var inst_14946 = (state_14954[(2)]);
var state_14954__$1 = state_14954;
var statearr_14959_14989 = state_14954__$1;
(statearr_14959_14989[(2)] = inst_14946);

(statearr_14959_14989[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (6))){
var state_14954__$1 = state_14954;
var statearr_14960_14990 = state_14954__$1;
(statearr_14960_14990[(2)] = null);

(statearr_14960_14990[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (17))){
var inst_14931 = (state_14954[(2)]);
var state_14954__$1 = state_14954;
var statearr_14961_14991 = state_14954__$1;
(statearr_14961_14991[(2)] = inst_14931);

(statearr_14961_14991[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (3))){
var inst_14917 = (state_14954[(8)]);
var inst_14915 = (state_14954[(9)]);
var inst_14917__$1 = cljs.core.peek(inst_14915);
var state_14954__$1 = (function (){var statearr_14962 = state_14954;
(statearr_14962[(8)] = inst_14917__$1);

return statearr_14962;
})();
if(cljs.core.truth_(inst_14917__$1)){
var statearr_14963_14992 = state_14954__$1;
(statearr_14963_14992[(1)] = (5));

} else {
var statearr_14964_14993 = state_14954__$1;
(statearr_14964_14993[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (12))){
var inst_14917 = (state_14954[(8)]);
var inst_14937 = fluree.db.index.resolve_children_when(r,resolve_QMARK_,error_ch,inst_14917);
var state_14954__$1 = state_14954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14954__$1,(18),inst_14937);
} else {
if((state_val_14955 === (2))){
var inst_14911 = (state_14954[(2)]);
var inst_14912 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14913 = [inst_14911];
var inst_14914 = (new cljs.core.PersistentVector(null,1,(5),inst_14912,inst_14913,null));
var inst_14915 = inst_14914;
var state_14954__$1 = (function (){var statearr_14965 = state_14954;
(statearr_14965[(9)] = inst_14915);

return statearr_14965;
})();
var statearr_14966_14994 = state_14954__$1;
(statearr_14966_14994[(2)] = null);

(statearr_14966_14994[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (11))){
var inst_14917 = (state_14954[(8)]);
var inst_14927 = (include_QMARK_.cljs$core$IFn$_invoke$arity$1 ? include_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_14917) : include_QMARK_.call(null,inst_14917));
var state_14954__$1 = state_14954;
if(cljs.core.truth_(inst_14927)){
var statearr_14967_14995 = state_14954__$1;
(statearr_14967_14995[(1)] = (14));

} else {
var statearr_14968_14996 = state_14954__$1;
(statearr_14968_14996[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (9))){
var inst_14917 = (state_14954[(8)]);
var inst_14923 = fluree.db.index.expanded_QMARK_(inst_14917);
var state_14954__$1 = state_14954;
var statearr_14969_14997 = state_14954__$1;
(statearr_14969_14997[(2)] = inst_14923);

(statearr_14969_14997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (5))){
var inst_14917 = (state_14954[(8)]);
var inst_14915 = (state_14954[(9)]);
var inst_14920 = (state_14954[(10)]);
var inst_14919 = cljs.core.pop(inst_14915);
var inst_14920__$1 = fluree.db.index.leaf_QMARK_(inst_14917);
var state_14954__$1 = (function (){var statearr_14970 = state_14954;
(statearr_14970[(11)] = inst_14919);

(statearr_14970[(10)] = inst_14920__$1);

return statearr_14970;
})();
if(inst_14920__$1){
var statearr_14971_14998 = state_14954__$1;
(statearr_14971_14998[(1)] = (8));

} else {
var statearr_14972_14999 = state_14954__$1;
(statearr_14972_14999[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (14))){
var inst_14917 = (state_14954[(8)]);
var inst_14929 = fluree.db.index.unmark_expanded(inst_14917);
var state_14954__$1 = state_14954;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14954__$1,(17),out,inst_14929);
} else {
if((state_val_14955 === (16))){
var inst_14919 = (state_14954[(11)]);
var inst_14934 = (state_14954[(2)]);
var inst_14915 = inst_14919;
var state_14954__$1 = (function (){var statearr_14973 = state_14954;
(statearr_14973[(9)] = inst_14915);

(statearr_14973[(12)] = inst_14934);

return statearr_14973;
})();
var statearr_14974_15000 = state_14954__$1;
(statearr_14974_15000[(2)] = null);

(statearr_14974_15000[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (10))){
var inst_14925 = (state_14954[(2)]);
var state_14954__$1 = state_14954;
if(cljs.core.truth_(inst_14925)){
var statearr_14975_15001 = state_14954__$1;
(statearr_14975_15001[(1)] = (11));

} else {
var statearr_14976_15002 = state_14954__$1;
(statearr_14976_15002[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (18))){
var inst_14917 = (state_14954[(8)]);
var inst_14919 = (state_14954[(11)]);
var inst_14939 = (state_14954[(2)]);
var inst_14940 = fluree.db.index.mark_expanded(inst_14917);
var inst_14941 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_14919,inst_14940);
var inst_14942 = cljs.core.rseq(inst_14939);
var inst_14943 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14941,inst_14942);
var inst_14915 = inst_14943;
var state_14954__$1 = (function (){var statearr_14977 = state_14954;
(statearr_14977[(9)] = inst_14915);

return statearr_14977;
})();
var statearr_14978_15003 = state_14954__$1;
(statearr_14978_15003[(2)] = null);

(statearr_14978_15003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14955 === (8))){
var inst_14920 = (state_14954[(10)]);
var state_14954__$1 = state_14954;
var statearr_14979_15004 = state_14954__$1;
(statearr_14979_15004[(2)] = inst_14920);

(statearr_14979_15004[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2727__auto__ = null;
var fluree$db$index$state_machine__2727__auto____0 = (function (){
var statearr_14980 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14980[(0)] = fluree$db$index$state_machine__2727__auto__);

(statearr_14980[(1)] = (1));

return statearr_14980;
});
var fluree$db$index$state_machine__2727__auto____1 = (function (state_14954){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_14954);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e14981){var ex__2730__auto__ = e14981;
var statearr_14982_15005 = state_14954;
(statearr_14982_15005[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_14954[(4)]))){
var statearr_14983_15006 = state_14954;
(statearr_14983_15006[(1)] = cljs.core.first((state_14954[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15007 = state_14954;
state_14954 = G__15007;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$index$state_machine__2727__auto__ = function(state_14954){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2727__auto____1.call(this,state_14954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2727__auto____0;
fluree$db$index$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2727__auto____1;
return fluree$db$index$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_14984 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_14984[(6)] = c__2749__auto___14986);

return statearr_14984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return out;
}));

(fluree.db.index.tree_chan.cljs$lang$maxFixedArity = 7);

