// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__5824__auto___53713 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53764){
var state_val_53765 = (state_53764[(1)]);
if((state_val_53765 === (7))){
var inst_53759 = (state_53764[(2)]);
var _ = (function (){var statearr_53766 = state_53764;
(statearr_53766[(4)] = cljs.core.rest((state_53764[(4)])));

return statearr_53766;
})();
var state_53764__$1 = state_53764;
var statearr_53767_53794 = state_53764__$1;
(statearr_53767_53794[(2)] = inst_53759);

(statearr_53767_53794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (1))){
var state_53764__$1 = state_53764;
var statearr_53768_53795 = state_53764__$1;
(statearr_53768_53795[(2)] = null);

(statearr_53768_53795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (4))){
var inst_53714 = (state_53764[(2)]);
var state_53764__$1 = state_53764;
var statearr_53769_53796 = state_53764__$1;
(statearr_53769_53796[(2)] = inst_53714);

(statearr_53769_53796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (13))){
var inst_53755 = (state_53764[(2)]);
var state_53764__$1 = state_53764;
var statearr_53770_53797 = state_53764__$1;
(statearr_53770_53797[(2)] = inst_53755);

(statearr_53770_53797[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (6))){
var inst_53739 = (state_53764[(7)]);
var inst_53732 = (state_53764[(8)]);
var inst_53738 = cljs.core.seq(inst_53732);
var inst_53739__$1 = cljs.core.first(inst_53738);
var inst_53740 = cljs.core.next(inst_53738);
var inst_53741 = cljs.core.not(inst_53739__$1);
var state_53764__$1 = (function (){var statearr_53771 = state_53764;
(statearr_53771[(7)] = inst_53739__$1);

(statearr_53771[(9)] = inst_53740);

return statearr_53771;
})();
if(inst_53741){
var statearr_53772_53798 = state_53764__$1;
(statearr_53772_53798[(1)] = (8));

} else {
var statearr_53773_53799 = state_53764__$1;
(statearr_53773_53799[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (3))){
var inst_53762 = (state_53764[(2)]);
var state_53764__$1 = state_53764;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53764__$1,inst_53762);
} else {
if((state_val_53765 === (12))){
var inst_53739 = (state_53764[(7)]);
var inst_53740 = (state_53764[(9)]);
var inst_53733 = (state_53764[(10)]);
var inst_53752 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53733,inst_53739);
var inst_53732 = inst_53740;
var inst_53733__$1 = inst_53752;
var state_53764__$1 = (function (){var statearr_53774 = state_53764;
(statearr_53774[(10)] = inst_53733__$1);

(statearr_53774[(8)] = inst_53732);

return statearr_53774;
})();
var statearr_53775_53800 = state_53764__$1;
(statearr_53775_53800[(2)] = null);

(statearr_53775_53800[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (2))){
var _ = (function (){var statearr_53776 = state_53764;
(statearr_53776[(4)] = cljs.core.cons((5),(state_53764[(4)])));

return statearr_53776;
})();
var inst_53727 = args;
var inst_53728 = cljs.core.seq(inst_53727);
var inst_53729 = cljs.core.first(inst_53728);
var inst_53730 = cljs.core.next(inst_53728);
var inst_53731 = cljs.core.PersistentVector.EMPTY;
var inst_53732 = inst_53727;
var inst_53733 = inst_53731;
var state_53764__$1 = (function (){var statearr_53777 = state_53764;
(statearr_53777[(11)] = inst_53730);

(statearr_53777[(10)] = inst_53733);

(statearr_53777[(12)] = inst_53729);

(statearr_53777[(8)] = inst_53732);

return statearr_53777;
})();
var statearr_53778_53801 = state_53764__$1;
(statearr_53778_53801[(2)] = null);

(statearr_53778_53801[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (11))){
var inst_53739 = (state_53764[(7)]);
var state_53764__$1 = state_53764;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53764__$1,(14),inst_53739);
} else {
if((state_val_53765 === (9))){
var inst_53739 = (state_53764[(7)]);
var inst_53744 = fluree.db.util.async.channel_QMARK_(inst_53739);
var state_53764__$1 = state_53764;
if(inst_53744){
var statearr_53780_53802 = state_53764__$1;
(statearr_53780_53802[(1)] = (11));

} else {
var statearr_53781_53803 = state_53764__$1;
(statearr_53781_53803[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (5))){
var _ = (function (){var statearr_53782 = state_53764;
(statearr_53782[(4)] = cljs.core.rest((state_53764[(4)])));

return statearr_53782;
})();
var state_53764__$1 = state_53764;
var ex53779 = (state_53764__$1[(2)]);
var statearr_53783_53804 = state_53764__$1;
(statearr_53783_53804[(5)] = ex53779);


if((ex53779 instanceof Error)){
var statearr_53784_53805 = state_53764__$1;
(statearr_53784_53805[(1)] = (4));

(statearr_53784_53805[(5)] = null);

} else {
throw ex53779;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (14))){
var inst_53740 = (state_53764[(9)]);
var inst_53733 = (state_53764[(10)]);
var inst_53747 = (state_53764[(2)]);
var inst_53748 = fluree.db.util.async.throw_err(inst_53747);
var inst_53749 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_53733,inst_53748);
var inst_53732 = inst_53740;
var inst_53733__$1 = inst_53749;
var state_53764__$1 = (function (){var statearr_53785 = state_53764;
(statearr_53785[(10)] = inst_53733__$1);

(statearr_53785[(8)] = inst_53732);

return statearr_53785;
})();
var statearr_53786_53806 = state_53764__$1;
(statearr_53786_53806[(2)] = null);

(statearr_53786_53806[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (10))){
var inst_53757 = (state_53764[(2)]);
var state_53764__$1 = state_53764;
var statearr_53787_53807 = state_53764__$1;
(statearr_53787_53807[(2)] = inst_53757);

(statearr_53787_53807[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53765 === (8))){
var inst_53733 = (state_53764[(10)]);
var state_53764__$1 = state_53764;
var statearr_53788_53808 = state_53764__$1;
(statearr_53788_53808[(2)] = inst_53733);

(statearr_53788_53808[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0 = (function (){
var statearr_53789 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53789[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__);

(statearr_53789[(1)] = (1));

return statearr_53789;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1 = (function (state_53764){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53764);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53790){var ex__2730__auto__ = e53790;
var statearr_53791_53809 = state_53764;
(statearr_53791_53809[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53764[(4)]))){
var statearr_53792_53810 = state_53764;
(statearr_53792_53810[(1)] = cljs.core.first((state_53764[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53811 = state_53764;
state_53764 = G__53811;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__ = function(state_53764){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1.call(this,state_53764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53793 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53793[(6)] = c__2749__auto__);

return statearr_53793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__53813 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53813,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53813,(1),null);
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Smart function stack:",res], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (p1__53812_SHARP_){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(p1__53812_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj,entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._,cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_,cost);
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53861){
var state_val_53862 = (state_53861[(1)]);
if((state_val_53862 === (7))){
var state_53861__$1 = state_53861;
var statearr_53863_53892 = state_53861__$1;
(statearr_53863_53892[(2)] = coll);

(statearr_53863_53892[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (1))){
var state_53861__$1 = state_53861;
var statearr_53864_53893 = state_53861__$1;
(statearr_53864_53893[(2)] = null);

(statearr_53864_53893[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (4))){
var inst_53816 = (state_53861[(2)]);
var state_53861__$1 = state_53861;
var statearr_53865_53894 = state_53861__$1;
(statearr_53865_53894[(2)] = inst_53816);

(statearr_53865_53894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (15))){
var inst_53835 = (state_53861[(7)]);
var inst_53843 = (state_53861[(2)]);
var inst_53844 = fluree.db.dbfunctions.internal.nth(inst_53835,inst_53843);
var inst_53845 = cljs.core.count(inst_53835);
var inst_53846 = ((9) + inst_53845);
var inst_53847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53848 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53850 = [inst_53835,inst_53843];
var inst_53851 = (new cljs.core.PersistentVector(null,2,(5),inst_53849,inst_53850,null));
var inst_53852 = ["nth",inst_53851,inst_53844];
var inst_53853 = cljs.core.PersistentHashMap.fromArrays(inst_53848,inst_53852);
var inst_53854 = [inst_53853,inst_53846];
var inst_53855 = (new cljs.core.PersistentVector(null,2,(5),inst_53847,inst_53854,null));
var inst_53856 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53855);
var _ = (function (){var statearr_53866 = state_53861;
(statearr_53866[(4)] = cljs.core.rest((state_53861[(4)])));

return statearr_53866;
})();
var state_53861__$1 = (function (){var statearr_53867 = state_53861;
(statearr_53867[(8)] = inst_53856);

return statearr_53867;
})();
var statearr_53868_53895 = state_53861__$1;
(statearr_53868_53895[(2)] = inst_53844);

(statearr_53868_53895[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (13))){
var state_53861__$1 = state_53861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53861__$1,(16),key);
} else {
if((state_val_53862 === (6))){
var state_53861__$1 = state_53861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53861__$1,(9),coll);
} else {
if((state_val_53862 === (3))){
var inst_53859 = (state_53861[(2)]);
var state_53861__$1 = state_53861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53861__$1,inst_53859);
} else {
if((state_val_53862 === (12))){
var inst_53835 = (state_53861[(2)]);
var inst_53836 = fluree.db.util.async.channel_QMARK_(key);
var state_53861__$1 = (function (){var statearr_53869 = state_53861;
(statearr_53869[(7)] = inst_53835);

return statearr_53869;
})();
if(inst_53836){
var statearr_53870_53896 = state_53861__$1;
(statearr_53870_53896[(1)] = (13));

} else {
var statearr_53871_53897 = state_53861__$1;
(statearr_53871_53897[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (2))){
var _ = (function (){var statearr_53872 = state_53861;
(statearr_53872[(4)] = cljs.core.cons((5),(state_53861[(4)])));

return statearr_53872;
})();
var inst_53822 = fluree.db.util.async.channel_QMARK_(coll);
var state_53861__$1 = state_53861;
if(inst_53822){
var statearr_53873_53898 = state_53861__$1;
(statearr_53873_53898[(1)] = (6));

} else {
var statearr_53874_53899 = state_53861__$1;
(statearr_53874_53899[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (11))){
var inst_53829 = (state_53861[(9)]);
var state_53861__$1 = state_53861;
var statearr_53876_53900 = state_53861__$1;
(statearr_53876_53900[(2)] = inst_53829);

(statearr_53876_53900[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (9))){
var inst_53825 = (state_53861[(2)]);
var inst_53826 = fluree.db.util.async.throw_err(inst_53825);
var state_53861__$1 = state_53861;
var statearr_53877_53901 = state_53861__$1;
(statearr_53877_53901[(2)] = inst_53826);

(statearr_53877_53901[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (5))){
var _ = (function (){var statearr_53878 = state_53861;
(statearr_53878[(4)] = cljs.core.rest((state_53861[(4)])));

return statearr_53878;
})();
var state_53861__$1 = state_53861;
var ex53875 = (state_53861__$1[(2)]);
var statearr_53879_53902 = state_53861__$1;
(statearr_53879_53902[(5)] = ex53875);


if((ex53875 instanceof Error)){
var statearr_53880_53903 = state_53861__$1;
(statearr_53880_53903[(1)] = (4));

(statearr_53880_53903[(5)] = null);

} else {
throw ex53875;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (14))){
var state_53861__$1 = state_53861;
var statearr_53881_53904 = state_53861__$1;
(statearr_53881_53904[(2)] = key);

(statearr_53881_53904[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (16))){
var inst_53839 = (state_53861[(2)]);
var inst_53840 = fluree.db.util.async.throw_err(inst_53839);
var state_53861__$1 = state_53861;
var statearr_53882_53905 = state_53861__$1;
(statearr_53882_53905[(2)] = inst_53840);

(statearr_53882_53905[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (10))){
var inst_53829 = (state_53861[(9)]);
var inst_53832 = cljs.core.vec(inst_53829);
var state_53861__$1 = state_53861;
var statearr_53883_53906 = state_53861__$1;
(statearr_53883_53906[(2)] = inst_53832);

(statearr_53883_53906[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53862 === (8))){
var inst_53829 = (state_53861[(9)]);
var inst_53829__$1 = (state_53861[(2)]);
var inst_53830 = cljs.core.set_QMARK_(inst_53829__$1);
var state_53861__$1 = (function (){var statearr_53884 = state_53861;
(statearr_53884[(9)] = inst_53829__$1);

return statearr_53884;
})();
if(inst_53830){
var statearr_53885_53907 = state_53861__$1;
(statearr_53885_53907[(1)] = (10));

} else {
var statearr_53886_53908 = state_53861__$1;
(statearr_53886_53908[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0 = (function (){
var statearr_53887 = [null,null,null,null,null,null,null,null,null,null];
(statearr_53887[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__);

(statearr_53887[(1)] = (1));

return statearr_53887;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1 = (function (state_53861){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53861);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e53888){var ex__2730__auto__ = e53888;
var statearr_53889_53909 = state_53861;
(statearr_53889_53909[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53861[(4)]))){
var statearr_53890_53910 = state_53861;
(statearr_53890_53910[(1)] = cljs.core.first((state_53861[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__53911 = state_53861;
state_53861 = G__53911;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__ = function(state_53861){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1.call(this,state_53861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_53891 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_53891[(6)] = c__2749__auto__);

return statearr_53891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_53972){
var state_val_53973 = (state_53972[(1)]);
if((state_val_53973 === (7))){
var state_53972__$1 = state_53972;
var statearr_53974_54008 = state_53972__$1;
(statearr_53974_54008[(2)] = test);

(statearr_53974_54008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (20))){
var inst_53946 = (state_53972[(2)]);
var inst_53947 = fluree.db.util.async.throw_err(inst_53946);
var state_53972__$1 = state_53972;
var statearr_53975_54009 = state_53972__$1;
(statearr_53975_54009[(2)] = inst_53947);

(statearr_53975_54009[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (1))){
var state_53972__$1 = state_53972;
var statearr_53976_54010 = state_53972__$1;
(statearr_53976_54010[(2)] = null);

(statearr_53976_54010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (4))){
var inst_53912 = (state_53972[(2)]);
var state_53972__$1 = state_53972;
var statearr_53977_54011 = state_53972__$1;
(statearr_53977_54011[(2)] = inst_53912);

(statearr_53977_54011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (15))){
var inst_53930 = (state_53972[(7)]);
var inst_53938 = (state_53972[(2)]);
var inst_53939 = [inst_53938,f];
var inst_53940 = (new cljs.core.PersistentVector(null,2,(5),inst_53930,inst_53939,null));
var state_53972__$1 = state_53972;
var statearr_53978_54012 = state_53972__$1;
(statearr_53978_54012[(2)] = inst_53940);

(statearr_53978_54012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (13))){
var state_53972__$1 = state_53972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53972__$1,(16),t);
} else {
if((state_val_53973 === (6))){
var state_53972__$1 = state_53972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53972__$1,(9),test);
} else {
if((state_val_53973 === (17))){
var state_53972__$1 = state_53972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53972__$1,(20),f);
} else {
if((state_val_53973 === (3))){
var inst_53970 = (state_53972[(2)]);
var state_53972__$1 = state_53972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53972__$1,inst_53970);
} else {
if((state_val_53973 === (12))){
var inst_53928 = (state_53972[(8)]);
var inst_53954 = (state_53972[(2)]);
var inst_53955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53954,(0),null);
var inst_53956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53954,(1),null);
var inst_53957 = fluree.db.dbfunctions.internal.if_else(inst_53928,inst_53955,inst_53956);
var inst_53958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53959 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_53960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53961 = [inst_53928,inst_53955,inst_53956];
var inst_53962 = (new cljs.core.PersistentVector(null,3,(5),inst_53960,inst_53961,null));
var inst_53963 = ["if-else",inst_53962,inst_53957];
var inst_53964 = cljs.core.PersistentHashMap.fromArrays(inst_53959,inst_53963);
var inst_53965 = [inst_53964,(10)];
var inst_53966 = (new cljs.core.PersistentVector(null,2,(5),inst_53958,inst_53965,null));
var inst_53967 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_53966);
var _ = (function (){var statearr_53979 = state_53972;
(statearr_53979[(4)] = cljs.core.rest((state_53972[(4)])));

return statearr_53979;
})();
var state_53972__$1 = (function (){var statearr_53980 = state_53972;
(statearr_53980[(9)] = inst_53967);

return statearr_53980;
})();
var statearr_53981_54013 = state_53972__$1;
(statearr_53981_54013[(2)] = inst_53957);

(statearr_53981_54013[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (2))){
var _ = (function (){var statearr_53982 = state_53972;
(statearr_53982[(4)] = cljs.core.cons((5),(state_53972[(4)])));

return statearr_53982;
})();
var inst_53921 = fluree.db.util.async.channel_QMARK_(test);
var state_53972__$1 = state_53972;
if(inst_53921){
var statearr_53983_54014 = state_53972__$1;
(statearr_53983_54014[(1)] = (6));

} else {
var statearr_53984_54015 = state_53972__$1;
(statearr_53984_54015[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (19))){
var inst_53942 = (state_53972[(10)]);
var inst_53950 = (state_53972[(2)]);
var inst_53951 = [f,inst_53950];
var inst_53952 = (new cljs.core.PersistentVector(null,2,(5),inst_53942,inst_53951,null));
var state_53972__$1 = state_53972;
var statearr_53985_54016 = state_53972__$1;
(statearr_53985_54016[(2)] = inst_53952);

(statearr_53985_54016[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (11))){
var inst_53942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53943 = fluree.db.util.async.channel_QMARK_(f);
var state_53972__$1 = (function (){var statearr_53987 = state_53972;
(statearr_53987[(10)] = inst_53942);

return statearr_53987;
})();
if(inst_53943){
var statearr_53988_54017 = state_53972__$1;
(statearr_53988_54017[(1)] = (17));

} else {
var statearr_53989_54018 = state_53972__$1;
(statearr_53989_54018[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (9))){
var inst_53924 = (state_53972[(2)]);
var inst_53925 = fluree.db.util.async.throw_err(inst_53924);
var state_53972__$1 = state_53972;
var statearr_53990_54019 = state_53972__$1;
(statearr_53990_54019[(2)] = inst_53925);

(statearr_53990_54019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (5))){
var _ = (function (){var statearr_53991 = state_53972;
(statearr_53991[(4)] = cljs.core.rest((state_53972[(4)])));

return statearr_53991;
})();
var state_53972__$1 = state_53972;
var ex53986 = (state_53972__$1[(2)]);
var statearr_53992_54020 = state_53972__$1;
(statearr_53992_54020[(5)] = ex53986);


if((ex53986 instanceof Error)){
var statearr_53993_54021 = state_53972__$1;
(statearr_53993_54021[(1)] = (4));

(statearr_53993_54021[(5)] = null);

} else {
throw ex53986;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (14))){
var state_53972__$1 = state_53972;
var statearr_53994_54022 = state_53972__$1;
(statearr_53994_54022[(2)] = t);

(statearr_53994_54022[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (16))){
var inst_53934 = (state_53972[(2)]);
var inst_53935 = fluree.db.util.async.throw_err(inst_53934);
var state_53972__$1 = state_53972;
var statearr_53995_54023 = state_53972__$1;
(statearr_53995_54023[(2)] = inst_53935);

(statearr_53995_54023[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (10))){
var inst_53930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53931 = fluree.db.util.async.channel_QMARK_(t);
var state_53972__$1 = (function (){var statearr_53996 = state_53972;
(statearr_53996[(7)] = inst_53930);

return statearr_53996;
})();
if(inst_53931){
var statearr_53997_54024 = state_53972__$1;
(statearr_53997_54024[(1)] = (13));

} else {
var statearr_53998_54025 = state_53972__$1;
(statearr_53998_54025[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (18))){
var state_53972__$1 = state_53972;
var statearr_53999_54026 = state_53972__$1;
(statearr_53999_54026[(2)] = f);

(statearr_53999_54026[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53973 === (8))){
var inst_53928 = (state_53972[(8)]);
var inst_53928__$1 = (state_53972[(2)]);
var state_53972__$1 = (function (){var statearr_54000 = state_53972;
(statearr_54000[(8)] = inst_53928__$1);

return statearr_54000;
})();
if(cljs.core.truth_(inst_53928__$1)){
var statearr_54001_54027 = state_53972__$1;
(statearr_54001_54027[(1)] = (10));

} else {
var statearr_54002_54028 = state_53972__$1;
(statearr_54002_54028[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0 = (function (){
var statearr_54003 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54003[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__);

(statearr_54003[(1)] = (1));

return statearr_54003;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1 = (function (state_53972){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_53972);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54004){var ex__2730__auto__ = e54004;
var statearr_54005_54029 = state_53972;
(statearr_54005_54029[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_53972[(4)]))){
var statearr_54006_54030 = state_53972;
(statearr_54006_54030[(1)] = cljs.core.first((state_53972[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54031 = state_53972;
state_53972 = G__54031;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__ = function(state_53972){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1.call(this,state_53972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54007 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54007[(6)] = c__2749__auto__);

return statearr_54007;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54061){
var state_val_54062 = (state_54061[(1)]);
if((state_val_54062 === (7))){
var state_54061__$1 = state_54061;
var statearr_54063_54082 = state_54061__$1;
(statearr_54063_54082[(2)] = arg);

(statearr_54063_54082[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (1))){
var state_54061__$1 = state_54061;
var statearr_54064_54083 = state_54061__$1;
(statearr_54064_54083[(2)] = null);

(statearr_54064_54083[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (4))){
var inst_54032 = (state_54061[(2)]);
var state_54061__$1 = state_54061;
var statearr_54065_54084 = state_54061__$1;
(statearr_54065_54084[(2)] = inst_54032);

(statearr_54065_54084[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (6))){
var state_54061__$1 = state_54061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54061__$1,(9),arg);
} else {
if((state_val_54062 === (3))){
var inst_54059 = (state_54061[(2)]);
var state_54061__$1 = state_54061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54061__$1,inst_54059);
} else {
if((state_val_54062 === (2))){
var _ = (function (){var statearr_54067 = state_54061;
(statearr_54067[(4)] = cljs.core.cons((5),(state_54061[(4)])));

return statearr_54067;
})();
var inst_54038 = fluree.db.util.async.channel_QMARK_(arg);
var state_54061__$1 = state_54061;
if(inst_54038){
var statearr_54068_54085 = state_54061__$1;
(statearr_54068_54085[(1)] = (6));

} else {
var statearr_54069_54086 = state_54061__$1;
(statearr_54069_54086[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (9))){
var inst_54041 = (state_54061[(2)]);
var inst_54042 = fluree.db.util.async.throw_err(inst_54041);
var state_54061__$1 = state_54061;
var statearr_54070_54087 = state_54061__$1;
(statearr_54070_54087[(2)] = inst_54042);

(statearr_54070_54087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (5))){
var _ = (function (){var statearr_54071 = state_54061;
(statearr_54071[(4)] = cljs.core.rest((state_54061[(4)])));

return statearr_54071;
})();
var state_54061__$1 = state_54061;
var ex54066 = (state_54061__$1[(2)]);
var statearr_54072_54088 = state_54061__$1;
(statearr_54072_54088[(5)] = ex54066);


if((ex54066 instanceof Error)){
var statearr_54073_54089 = state_54061__$1;
(statearr_54073_54089[(1)] = (4));

(statearr_54073_54089[(5)] = null);

} else {
throw ex54066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54062 === (8))){
var inst_54045 = (state_54061[(2)]);
var inst_54046 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_54045);
var inst_54047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54048 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54049 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54050 = [inst_54045];
var inst_54051 = (new cljs.core.PersistentVector(null,1,(5),inst_54049,inst_54050,null));
var inst_54052 = ["nil?",inst_54051,inst_54046];
var inst_54053 = cljs.core.PersistentHashMap.fromArrays(inst_54048,inst_54052);
var inst_54054 = [inst_54053,(10)];
var inst_54055 = (new cljs.core.PersistentVector(null,2,(5),inst_54047,inst_54054,null));
var inst_54056 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54055);
var _ = (function (){var statearr_54074 = state_54061;
(statearr_54074[(4)] = cljs.core.rest((state_54061[(4)])));

return statearr_54074;
})();
var state_54061__$1 = (function (){var statearr_54075 = state_54061;
(statearr_54075[(7)] = inst_54056);

return statearr_54075;
})();
var statearr_54076_54090 = state_54061__$1;
(statearr_54076_54090[(2)] = inst_54046);

(statearr_54076_54090[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54077 = [null,null,null,null,null,null,null,null];
(statearr_54077[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__);

(statearr_54077[(1)] = (1));

return statearr_54077;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1 = (function (state_54061){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54061);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54078){var ex__2730__auto__ = e54078;
var statearr_54079_54091 = state_54061;
(statearr_54079_54091[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54061[(4)]))){
var statearr_54080_54092 = state_54061;
(statearr_54080_54092[(1)] = cljs.core.first((state_54061[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54093 = state_54061;
state_54061 = G__54093;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__ = function(state_54061){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1.call(this,state_54061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54081 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54081[(6)] = c__2749__auto__);

return statearr_54081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54123){
var state_val_54124 = (state_54123[(1)]);
if((state_val_54124 === (7))){
var state_54123__$1 = state_54123;
var statearr_54125_54144 = state_54123__$1;
(statearr_54125_54144[(2)] = arg);

(statearr_54125_54144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54124 === (1))){
var state_54123__$1 = state_54123;
var statearr_54126_54145 = state_54123__$1;
(statearr_54126_54145[(2)] = null);

(statearr_54126_54145[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54124 === (4))){
var inst_54094 = (state_54123[(2)]);
var state_54123__$1 = state_54123;
var statearr_54127_54146 = state_54123__$1;
(statearr_54127_54146[(2)] = inst_54094);

(statearr_54127_54146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54124 === (6))){
var state_54123__$1 = state_54123;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54123__$1,(9),arg);
} else {
if((state_val_54124 === (3))){
var inst_54121 = (state_54123[(2)]);
var state_54123__$1 = state_54123;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54123__$1,inst_54121);
} else {
if((state_val_54124 === (2))){
var _ = (function (){var statearr_54129 = state_54123;
(statearr_54129[(4)] = cljs.core.cons((5),(state_54123[(4)])));

return statearr_54129;
})();
var inst_54100 = fluree.db.util.async.channel_QMARK_(arg);
var state_54123__$1 = state_54123;
if(inst_54100){
var statearr_54130_54147 = state_54123__$1;
(statearr_54130_54147[(1)] = (6));

} else {
var statearr_54131_54148 = state_54123__$1;
(statearr_54131_54148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54124 === (9))){
var inst_54103 = (state_54123[(2)]);
var inst_54104 = fluree.db.util.async.throw_err(inst_54103);
var state_54123__$1 = state_54123;
var statearr_54132_54149 = state_54123__$1;
(statearr_54132_54149[(2)] = inst_54104);

(statearr_54132_54149[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54124 === (5))){
var _ = (function (){var statearr_54133 = state_54123;
(statearr_54133[(4)] = cljs.core.rest((state_54123[(4)])));

return statearr_54133;
})();
var state_54123__$1 = state_54123;
var ex54128 = (state_54123__$1[(2)]);
var statearr_54134_54150 = state_54123__$1;
(statearr_54134_54150[(5)] = ex54128);


if((ex54128 instanceof Error)){
var statearr_54135_54151 = state_54123__$1;
(statearr_54135_54151[(1)] = (4));

(statearr_54135_54151[(5)] = null);

} else {
throw ex54128;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54124 === (8))){
var inst_54107 = (state_54123[(2)]);
var inst_54108 = fluree.db.dbfunctions.internal.not(inst_54107);
var inst_54109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54110 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54112 = [inst_54107];
var inst_54113 = (new cljs.core.PersistentVector(null,1,(5),inst_54111,inst_54112,null));
var inst_54114 = ["not",inst_54113,inst_54108];
var inst_54115 = cljs.core.PersistentHashMap.fromArrays(inst_54110,inst_54114);
var inst_54116 = [inst_54115,(10)];
var inst_54117 = (new cljs.core.PersistentVector(null,2,(5),inst_54109,inst_54116,null));
var inst_54118 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54117);
var _ = (function (){var statearr_54136 = state_54123;
(statearr_54136[(4)] = cljs.core.rest((state_54123[(4)])));

return statearr_54136;
})();
var state_54123__$1 = (function (){var statearr_54137 = state_54123;
(statearr_54137[(7)] = inst_54118);

return statearr_54137;
})();
var statearr_54138_54152 = state_54123__$1;
(statearr_54138_54152[(2)] = inst_54108);

(statearr_54138_54152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0 = (function (){
var statearr_54139 = [null,null,null,null,null,null,null,null];
(statearr_54139[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__);

(statearr_54139[(1)] = (1));

return statearr_54139;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1 = (function (state_54123){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54123);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54140){var ex__2730__auto__ = e54140;
var statearr_54141_54153 = state_54123;
(statearr_54141_54153[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54123[(4)]))){
var statearr_54142_54154 = state_54123;
(statearr_54142_54154[(1)] = cljs.core.first((state_54123[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54155 = state_54123;
state_54123 = G__54155;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__ = function(state_54123){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1.call(this,state_54123);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54143 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54143[(6)] = c__2749__auto__);

return statearr_54143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54185){
var state_val_54186 = (state_54185[(1)]);
if((state_val_54186 === (7))){
var state_54185__$1 = state_54185;
var statearr_54187_54206 = state_54185__$1;
(statearr_54187_54206[(2)] = arg);

(statearr_54187_54206[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54186 === (1))){
var state_54185__$1 = state_54185;
var statearr_54188_54207 = state_54185__$1;
(statearr_54188_54207[(2)] = null);

(statearr_54188_54207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54186 === (4))){
var inst_54156 = (state_54185[(2)]);
var state_54185__$1 = state_54185;
var statearr_54189_54208 = state_54185__$1;
(statearr_54189_54208[(2)] = inst_54156);

(statearr_54189_54208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54186 === (6))){
var state_54185__$1 = state_54185;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54185__$1,(9),arg);
} else {
if((state_val_54186 === (3))){
var inst_54183 = (state_54185[(2)]);
var state_54185__$1 = state_54185;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54185__$1,inst_54183);
} else {
if((state_val_54186 === (2))){
var _ = (function (){var statearr_54191 = state_54185;
(statearr_54191[(4)] = cljs.core.cons((5),(state_54185[(4)])));

return statearr_54191;
})();
var inst_54162 = fluree.db.util.async.channel_QMARK_(arg);
var state_54185__$1 = state_54185;
if(inst_54162){
var statearr_54192_54209 = state_54185__$1;
(statearr_54192_54209[(1)] = (6));

} else {
var statearr_54193_54210 = state_54185__$1;
(statearr_54193_54210[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54186 === (9))){
var inst_54165 = (state_54185[(2)]);
var inst_54166 = fluree.db.util.async.throw_err(inst_54165);
var state_54185__$1 = state_54185;
var statearr_54194_54211 = state_54185__$1;
(statearr_54194_54211[(2)] = inst_54166);

(statearr_54194_54211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54186 === (5))){
var _ = (function (){var statearr_54195 = state_54185;
(statearr_54195[(4)] = cljs.core.rest((state_54185[(4)])));

return statearr_54195;
})();
var state_54185__$1 = state_54185;
var ex54190 = (state_54185__$1[(2)]);
var statearr_54196_54212 = state_54185__$1;
(statearr_54196_54212[(5)] = ex54190);


if((ex54190 instanceof Error)){
var statearr_54197_54213 = state_54185__$1;
(statearr_54197_54213[(1)] = (4));

(statearr_54197_54213[(5)] = null);

} else {
throw ex54190;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54186 === (8))){
var inst_54169 = (state_54185[(2)]);
var inst_54170 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_54169);
var inst_54171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54172 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54174 = [inst_54169];
var inst_54175 = (new cljs.core.PersistentVector(null,1,(5),inst_54173,inst_54174,null));
var inst_54176 = ["empty?",inst_54175,inst_54170];
var inst_54177 = cljs.core.PersistentHashMap.fromArrays(inst_54172,inst_54176);
var inst_54178 = [inst_54177,(10)];
var inst_54179 = (new cljs.core.PersistentVector(null,2,(5),inst_54171,inst_54178,null));
var inst_54180 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54179);
var _ = (function (){var statearr_54198 = state_54185;
(statearr_54198[(4)] = cljs.core.rest((state_54185[(4)])));

return statearr_54198;
})();
var state_54185__$1 = (function (){var statearr_54199 = state_54185;
(statearr_54199[(7)] = inst_54180);

return statearr_54199;
})();
var statearr_54200_54214 = state_54185__$1;
(statearr_54200_54214[(2)] = inst_54170);

(statearr_54200_54214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_54201 = [null,null,null,null,null,null,null,null];
(statearr_54201[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__);

(statearr_54201[(1)] = (1));

return statearr_54201;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1 = (function (state_54185){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54185);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54202){var ex__2730__auto__ = e54202;
var statearr_54203_54215 = state_54185;
(statearr_54203_54215[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54185[(4)]))){
var statearr_54204_54216 = state_54185;
(statearr_54204_54216[(1)] = cljs.core.first((state_54185[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54217 = state_54185;
state_54185 = G__54217;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__ = function(state_54185){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1.call(this,state_54185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54205 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54205[(6)] = c__2749__auto__);

return statearr_54205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54262 = arguments.length;
var i__5770__auto___54263 = (0);
while(true){
if((i__5770__auto___54263 < len__5769__auto___54262)){
args__5775__auto__.push((arguments[i__5770__auto___54263]));

var G__54264 = (i__5770__auto___54263 + (1));
i__5770__auto___54263 = G__54264;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54245){
var state_val_54246 = (state_54245[(1)]);
if((state_val_54246 === (1))){
var state_54245__$1 = state_54245;
var statearr_54247_54265 = state_54245__$1;
(statearr_54247_54265[(2)] = null);

(statearr_54247_54265[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (2))){
var _ = (function (){var statearr_54248 = state_54245;
(statearr_54248[(4)] = cljs.core.cons((5),(state_54245[(4)])));

return statearr_54248;
})();
var inst_54226 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54245__$1,(6),inst_54226);
} else {
if((state_val_54246 === (3))){
var inst_54243 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54245__$1,inst_54243);
} else {
if((state_val_54246 === (4))){
var inst_54220 = (state_54245[(2)]);
var state_54245__$1 = state_54245;
var statearr_54250_54266 = state_54245__$1;
(statearr_54250_54266[(2)] = inst_54220);

(statearr_54250_54266[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (5))){
var _ = (function (){var statearr_54251 = state_54245;
(statearr_54251[(4)] = cljs.core.rest((state_54245[(4)])));

return statearr_54251;
})();
var state_54245__$1 = state_54245;
var ex54249 = (state_54245__$1[(2)]);
var statearr_54252_54267 = state_54245__$1;
(statearr_54252_54267[(5)] = ex54249);


if((ex54249 instanceof Error)){
var statearr_54253_54268 = state_54245__$1;
(statearr_54253_54268[(1)] = (4));

(statearr_54253_54268[(5)] = null);

} else {
throw ex54249;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54246 === (6))){
var inst_54228 = (state_54245[(2)]);
var inst_54229 = fluree.db.util.async.throw_err(inst_54228);
var inst_54230 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_54229);
var inst_54231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54232 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54234 = [inst_54229];
var inst_54235 = (new cljs.core.PersistentVector(null,1,(5),inst_54233,inst_54234,null));
var inst_54236 = ["str",inst_54235,inst_54230];
var inst_54237 = cljs.core.PersistentHashMap.fromArrays(inst_54232,inst_54236);
var inst_54238 = [inst_54237,(10)];
var inst_54239 = (new cljs.core.PersistentVector(null,2,(5),inst_54231,inst_54238,null));
var inst_54240 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54239);
var _ = (function (){var statearr_54254 = state_54245;
(statearr_54254[(4)] = cljs.core.rest((state_54245[(4)])));

return statearr_54254;
})();
var state_54245__$1 = (function (){var statearr_54255 = state_54245;
(statearr_54255[(7)] = inst_54240);

return statearr_54255;
})();
var statearr_54256_54269 = state_54245__$1;
(statearr_54256_54269[(2)] = inst_54230);

(statearr_54256_54269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54257 = [null,null,null,null,null,null,null,null];
(statearr_54257[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54257[(1)] = (1));

return statearr_54257;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54245){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54245);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54258){var ex__2730__auto__ = e54258;
var statearr_54259_54270 = state_54245;
(statearr_54259_54270[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54245[(4)]))){
var statearr_54260_54271 = state_54245;
(statearr_54260_54271[(1)] = cljs.core.first((state_54245[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54272 = state_54245;
state_54245 = G__54272;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54261 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54261[(6)] = c__2749__auto__);

return statearr_54261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54218){
var G__54219 = cljs.core.first(seq54218);
var seq54218__$1 = cljs.core.next(seq54218);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54219,seq54218__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54298){
var state_val_54299 = (state_54298[(1)]);
if((state_val_54299 === (1))){
var state_54298__$1 = state_54298;
var statearr_54300_54315 = state_54298__$1;
(statearr_54300_54315[(2)] = null);

(statearr_54300_54315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (2))){
var _ = (function (){var statearr_54301 = state_54298;
(statearr_54301[(4)] = cljs.core.cons((5),(state_54298[(4)])));

return statearr_54301;
})();
var inst_54279 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54298__$1 = state_54298;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54298__$1,(6),inst_54279);
} else {
if((state_val_54299 === (3))){
var inst_54296 = (state_54298[(2)]);
var state_54298__$1 = state_54298;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54298__$1,inst_54296);
} else {
if((state_val_54299 === (4))){
var inst_54273 = (state_54298[(2)]);
var state_54298__$1 = state_54298;
var statearr_54303_54316 = state_54298__$1;
(statearr_54303_54316[(2)] = inst_54273);

(statearr_54303_54316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (5))){
var _ = (function (){var statearr_54304 = state_54298;
(statearr_54304[(4)] = cljs.core.rest((state_54298[(4)])));

return statearr_54304;
})();
var state_54298__$1 = state_54298;
var ex54302 = (state_54298__$1[(2)]);
var statearr_54305_54317 = state_54298__$1;
(statearr_54305_54317[(5)] = ex54302);


if((ex54302 instanceof Error)){
var statearr_54306_54318 = state_54298__$1;
(statearr_54306_54318[(1)] = (4));

(statearr_54306_54318[(5)] = null);

} else {
throw ex54302;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54299 === (6))){
var inst_54281 = (state_54298[(2)]);
var inst_54282 = fluree.db.util.async.throw_err(inst_54281);
var inst_54283 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_54282);
var inst_54284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54285 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54286 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54287 = [inst_54282];
var inst_54288 = (new cljs.core.PersistentVector(null,1,(5),inst_54286,inst_54287,null));
var inst_54289 = ["subs",inst_54288,inst_54283];
var inst_54290 = cljs.core.PersistentHashMap.fromArrays(inst_54285,inst_54289);
var inst_54291 = [inst_54290,(30)];
var inst_54292 = (new cljs.core.PersistentVector(null,2,(5),inst_54284,inst_54291,null));
var inst_54293 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54292);
var _ = (function (){var statearr_54307 = state_54298;
(statearr_54307[(4)] = cljs.core.rest((state_54298[(4)])));

return statearr_54307;
})();
var state_54298__$1 = (function (){var statearr_54308 = state_54298;
(statearr_54308[(7)] = inst_54293);

return statearr_54308;
})();
var statearr_54309_54319 = state_54298__$1;
(statearr_54309_54319[(2)] = inst_54283);

(statearr_54309_54319[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0 = (function (){
var statearr_54310 = [null,null,null,null,null,null,null,null];
(statearr_54310[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__);

(statearr_54310[(1)] = (1));

return statearr_54310;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1 = (function (state_54298){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54298);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54311){var ex__2730__auto__ = e54311;
var statearr_54312_54320 = state_54298;
(statearr_54312_54320[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54298[(4)]))){
var statearr_54313_54321 = state_54298;
(statearr_54313_54321[(1)] = cljs.core.first((state_54298[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54322 = state_54298;
state_54298 = G__54322;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__ = function(state_54298){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1.call(this,state_54298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54314 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54314[(6)] = c__2749__auto__);

return statearr_54314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54352){
var state_val_54353 = (state_54352[(1)]);
if((state_val_54353 === (7))){
var state_54352__$1 = state_54352;
var statearr_54354_54373 = state_54352__$1;
(statearr_54354_54373[(2)] = str);

(statearr_54354_54373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (1))){
var state_54352__$1 = state_54352;
var statearr_54355_54374 = state_54352__$1;
(statearr_54355_54374[(2)] = null);

(statearr_54355_54374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (4))){
var inst_54323 = (state_54352[(2)]);
var state_54352__$1 = state_54352;
var statearr_54356_54375 = state_54352__$1;
(statearr_54356_54375[(2)] = inst_54323);

(statearr_54356_54375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (6))){
var state_54352__$1 = state_54352;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54352__$1,(9),str);
} else {
if((state_val_54353 === (3))){
var inst_54350 = (state_54352[(2)]);
var state_54352__$1 = state_54352;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54352__$1,inst_54350);
} else {
if((state_val_54353 === (2))){
var _ = (function (){var statearr_54358 = state_54352;
(statearr_54358[(4)] = cljs.core.cons((5),(state_54352[(4)])));

return statearr_54358;
})();
var inst_54329 = fluree.db.util.async.channel_QMARK_(str);
var state_54352__$1 = state_54352;
if(inst_54329){
var statearr_54359_54376 = state_54352__$1;
(statearr_54359_54376[(1)] = (6));

} else {
var statearr_54360_54377 = state_54352__$1;
(statearr_54360_54377[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (9))){
var inst_54332 = (state_54352[(2)]);
var inst_54333 = fluree.db.util.async.throw_err(inst_54332);
var state_54352__$1 = state_54352;
var statearr_54361_54378 = state_54352__$1;
(statearr_54361_54378[(2)] = inst_54333);

(statearr_54361_54378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (5))){
var _ = (function (){var statearr_54362 = state_54352;
(statearr_54362[(4)] = cljs.core.rest((state_54352[(4)])));

return statearr_54362;
})();
var state_54352__$1 = state_54352;
var ex54357 = (state_54352__$1[(2)]);
var statearr_54363_54379 = state_54352__$1;
(statearr_54363_54379[(5)] = ex54357);


if((ex54357 instanceof Error)){
var statearr_54364_54380 = state_54352__$1;
(statearr_54364_54380[(1)] = (4));

(statearr_54364_54380[(5)] = null);

} else {
throw ex54357;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54353 === (8))){
var inst_54336 = (state_54352[(2)]);
var inst_54337 = fluree.db.dbfunctions.internal.lower_case(inst_54336);
var inst_54338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54339 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54341 = [inst_54336];
var inst_54342 = (new cljs.core.PersistentVector(null,1,(5),inst_54340,inst_54341,null));
var inst_54343 = ["lower-case",inst_54342,inst_54337];
var inst_54344 = cljs.core.PersistentHashMap.fromArrays(inst_54339,inst_54343);
var inst_54345 = [inst_54344,(10)];
var inst_54346 = (new cljs.core.PersistentVector(null,2,(5),inst_54338,inst_54345,null));
var inst_54347 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54346);
var _ = (function (){var statearr_54365 = state_54352;
(statearr_54365[(4)] = cljs.core.rest((state_54352[(4)])));

return statearr_54365;
})();
var state_54352__$1 = (function (){var statearr_54366 = state_54352;
(statearr_54366[(7)] = inst_54347);

return statearr_54366;
})();
var statearr_54367_54381 = state_54352__$1;
(statearr_54367_54381[(2)] = inst_54337);

(statearr_54367_54381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0 = (function (){
var statearr_54368 = [null,null,null,null,null,null,null,null];
(statearr_54368[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__);

(statearr_54368[(1)] = (1));

return statearr_54368;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1 = (function (state_54352){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54352);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54369){var ex__2730__auto__ = e54369;
var statearr_54370_54382 = state_54352;
(statearr_54370_54382[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54352[(4)]))){
var statearr_54371_54383 = state_54352;
(statearr_54371_54383[(1)] = cljs.core.first((state_54352[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54384 = state_54352;
state_54352 = G__54384;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__ = function(state_54352){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1.call(this,state_54352);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54372 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54372[(6)] = c__2749__auto__);

return statearr_54372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54414){
var state_val_54415 = (state_54414[(1)]);
if((state_val_54415 === (7))){
var state_54414__$1 = state_54414;
var statearr_54416_54435 = state_54414__$1;
(statearr_54416_54435[(2)] = str);

(statearr_54416_54435[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (1))){
var state_54414__$1 = state_54414;
var statearr_54417_54436 = state_54414__$1;
(statearr_54417_54436[(2)] = null);

(statearr_54417_54436[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (4))){
var inst_54385 = (state_54414[(2)]);
var state_54414__$1 = state_54414;
var statearr_54418_54437 = state_54414__$1;
(statearr_54418_54437[(2)] = inst_54385);

(statearr_54418_54437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (6))){
var state_54414__$1 = state_54414;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54414__$1,(9),str);
} else {
if((state_val_54415 === (3))){
var inst_54412 = (state_54414[(2)]);
var state_54414__$1 = state_54414;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54414__$1,inst_54412);
} else {
if((state_val_54415 === (2))){
var _ = (function (){var statearr_54420 = state_54414;
(statearr_54420[(4)] = cljs.core.cons((5),(state_54414[(4)])));

return statearr_54420;
})();
var inst_54391 = fluree.db.util.async.channel_QMARK_(str);
var state_54414__$1 = state_54414;
if(inst_54391){
var statearr_54421_54438 = state_54414__$1;
(statearr_54421_54438[(1)] = (6));

} else {
var statearr_54422_54439 = state_54414__$1;
(statearr_54422_54439[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (9))){
var inst_54394 = (state_54414[(2)]);
var inst_54395 = fluree.db.util.async.throw_err(inst_54394);
var state_54414__$1 = state_54414;
var statearr_54423_54440 = state_54414__$1;
(statearr_54423_54440[(2)] = inst_54395);

(statearr_54423_54440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (5))){
var _ = (function (){var statearr_54424 = state_54414;
(statearr_54424[(4)] = cljs.core.rest((state_54414[(4)])));

return statearr_54424;
})();
var state_54414__$1 = state_54414;
var ex54419 = (state_54414__$1[(2)]);
var statearr_54425_54441 = state_54414__$1;
(statearr_54425_54441[(5)] = ex54419);


if((ex54419 instanceof Error)){
var statearr_54426_54442 = state_54414__$1;
(statearr_54426_54442[(1)] = (4));

(statearr_54426_54442[(5)] = null);

} else {
throw ex54419;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54415 === (8))){
var inst_54398 = (state_54414[(2)]);
var inst_54399 = fluree.db.dbfunctions.internal.upper_case(inst_54398);
var inst_54400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54401 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54403 = [inst_54398];
var inst_54404 = (new cljs.core.PersistentVector(null,1,(5),inst_54402,inst_54403,null));
var inst_54405 = ["upper-case",inst_54404,inst_54399];
var inst_54406 = cljs.core.PersistentHashMap.fromArrays(inst_54401,inst_54405);
var inst_54407 = [inst_54406,(10)];
var inst_54408 = (new cljs.core.PersistentVector(null,2,(5),inst_54400,inst_54407,null));
var inst_54409 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54408);
var _ = (function (){var statearr_54427 = state_54414;
(statearr_54427[(4)] = cljs.core.rest((state_54414[(4)])));

return statearr_54427;
})();
var state_54414__$1 = (function (){var statearr_54428 = state_54414;
(statearr_54428[(7)] = inst_54409);

return statearr_54428;
})();
var statearr_54429_54443 = state_54414__$1;
(statearr_54429_54443[(2)] = inst_54399);

(statearr_54429_54443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0 = (function (){
var statearr_54430 = [null,null,null,null,null,null,null,null];
(statearr_54430[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__);

(statearr_54430[(1)] = (1));

return statearr_54430;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1 = (function (state_54414){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54414);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54431){var ex__2730__auto__ = e54431;
var statearr_54432_54444 = state_54414;
(statearr_54432_54444[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54414[(4)]))){
var statearr_54433_54445 = state_54414;
(statearr_54433_54445[(1)] = cljs.core.first((state_54414[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54446 = state_54414;
state_54414 = G__54446;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__ = function(state_54414){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1.call(this,state_54414);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54434 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54434[(6)] = c__2749__auto__);

return statearr_54434;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__5043__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__5043__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__54448 = arguments.length;
switch (G__54448) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54476){
var state_val_54477 = (state_54476[(1)]);
if((state_val_54477 === (1))){
var state_54476__$1 = state_54476;
var statearr_54478_54494 = state_54476__$1;
(statearr_54478_54494[(2)] = null);

(statearr_54478_54494[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54477 === (2))){
var _ = (function (){var statearr_54479 = state_54476;
(statearr_54479[(4)] = cljs.core.cons((5),(state_54476[(4)])));

return statearr_54479;
})();
var inst_54458 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_54476__$1 = state_54476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54476__$1,(6),inst_54458);
} else {
if((state_val_54477 === (3))){
var inst_54474 = (state_54476[(2)]);
var state_54476__$1 = state_54476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54476__$1,inst_54474);
} else {
if((state_val_54477 === (4))){
var inst_54449 = (state_54476[(2)]);
var state_54476__$1 = state_54476;
var statearr_54481_54495 = state_54476__$1;
(statearr_54481_54495[(2)] = inst_54449);

(statearr_54481_54495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54477 === (5))){
var _ = (function (){var statearr_54482 = state_54476;
(statearr_54482[(4)] = cljs.core.rest((state_54476[(4)])));

return statearr_54482;
})();
var state_54476__$1 = state_54476;
var ex54480 = (state_54476__$1[(2)]);
var statearr_54483_54496 = state_54476__$1;
(statearr_54483_54496[(5)] = ex54480);


if((ex54480 instanceof Error)){
var statearr_54484_54497 = state_54476__$1;
(statearr_54484_54497[(1)] = (4));

(statearr_54484_54497[(5)] = null);

} else {
throw ex54480;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54477 === (6))){
var inst_54460 = (state_54476[(2)]);
var inst_54461 = fluree.db.util.async.throw_err(inst_54460);
var inst_54462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54461,(0),null);
var inst_54463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54461,(1),null);
var inst_54464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54465 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54466 = ["?s","?ctx",inst_54462];
var inst_54467 = cljs.core.PersistentHashMap.fromArrays(inst_54465,inst_54466);
var inst_54468 = ((10) + inst_54463);
var inst_54469 = [inst_54467,inst_54468];
var inst_54470 = (new cljs.core.PersistentVector(null,2,(5),inst_54464,inst_54469,null));
var inst_54471 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54470);
var _ = (function (){var statearr_54485 = state_54476;
(statearr_54485[(4)] = cljs.core.rest((state_54476[(4)])));

return statearr_54485;
})();
var state_54476__$1 = (function (){var statearr_54486 = state_54476;
(statearr_54486[(7)] = inst_54471);

return statearr_54486;
})();
var statearr_54487_54498 = state_54476__$1;
(statearr_54487_54498[(2)] = inst_54462);

(statearr_54487_54498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54488 = [null,null,null,null,null,null,null,null];
(statearr_54488[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54488[(1)] = (1));

return statearr_54488;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54476){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54476);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54489){var ex__2730__auto__ = e54489;
var statearr_54490_54499 = state_54476;
(statearr_54490_54499[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54476[(4)]))){
var statearr_54491_54500 = state_54476;
(statearr_54491_54500[(1)] = cljs.core.first((state_54476[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54501 = state_54476;
state_54476 = G__54501;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54476){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54492 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54492[(6)] = c__2749__auto__);

return statearr_54492;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__54503 = arguments.length;
switch (G__54503) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54541){
var state_val_54542 = (state_54541[(1)]);
if((state_val_54542 === (7))){
var inst_54534 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_54541__$1 = state_54541;
var statearr_54543_54563 = state_54541__$1;
(statearr_54543_54563[(2)] = inst_54534);

(statearr_54543_54563[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (1))){
var state_54541__$1 = state_54541;
var statearr_54544_54564 = state_54541__$1;
(statearr_54544_54564[(2)] = null);

(statearr_54544_54564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (4))){
var inst_54504 = (state_54541[(2)]);
var state_54541__$1 = state_54541;
var statearr_54545_54565 = state_54541__$1;
(statearr_54545_54565[(2)] = inst_54504);

(statearr_54545_54565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (6))){
var inst_54515 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_54541__$1 = state_54541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54541__$1,(10),inst_54515);
} else {
if((state_val_54542 === (3))){
var inst_54539 = (state_54541[(2)]);
var state_54541__$1 = state_54541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54541__$1,inst_54539);
} else {
if((state_val_54542 === (2))){
var _ = (function (){var statearr_54547 = state_54541;
(statearr_54547[(4)] = cljs.core.cons((5),(state_54541[(4)])));

return statearr_54547;
})();
var inst_54510 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_54541__$1 = state_54541;
if(cljs.core.truth_(inst_54510)){
var statearr_54548_54566 = state_54541__$1;
(statearr_54548_54566[(1)] = (6));

} else {
var statearr_54549_54567 = state_54541__$1;
(statearr_54549_54567[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (9))){
var inst_54521 = (state_54541[(2)]);
var inst_54522 = fluree.db.util.async.throw_err(inst_54521);
var inst_54523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54522,(0),null);
var inst_54524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54522,(1),null);
var inst_54525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54526 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54527 = ["?p","?ctx",inst_54523];
var inst_54528 = cljs.core.PersistentHashMap.fromArrays(inst_54526,inst_54527);
var inst_54529 = ((10) + inst_54524);
var inst_54530 = [inst_54528,inst_54529];
var inst_54531 = (new cljs.core.PersistentVector(null,2,(5),inst_54525,inst_54530,null));
var inst_54532 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54531);
var state_54541__$1 = (function (){var statearr_54550 = state_54541;
(statearr_54550[(7)] = inst_54532);

return statearr_54550;
})();
var statearr_54551_54568 = state_54541__$1;
(statearr_54551_54568[(2)] = inst_54523);

(statearr_54551_54568[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (5))){
var _ = (function (){var statearr_54552 = state_54541;
(statearr_54552[(4)] = cljs.core.rest((state_54541[(4)])));

return statearr_54552;
})();
var state_54541__$1 = state_54541;
var ex54546 = (state_54541__$1[(2)]);
var statearr_54553_54569 = state_54541__$1;
(statearr_54553_54569[(5)] = ex54546);


if((ex54546 instanceof Error)){
var statearr_54554_54570 = state_54541__$1;
(statearr_54554_54570[(1)] = (4));

(statearr_54554_54570[(5)] = null);

} else {
throw ex54546;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54542 === (10))){
var inst_54517 = (state_54541[(2)]);
var inst_54518 = fluree.db.util.async.throw_err(inst_54517);
var inst_54519 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_54518);
var state_54541__$1 = state_54541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54541__$1,(9),inst_54519);
} else {
if((state_val_54542 === (8))){
var inst_54536 = (state_54541[(2)]);
var _ = (function (){var statearr_54555 = state_54541;
(statearr_54555[(4)] = cljs.core.rest((state_54541[(4)])));

return statearr_54555;
})();
var state_54541__$1 = state_54541;
var statearr_54556_54571 = state_54541__$1;
(statearr_54556_54571[(2)] = inst_54536);

(statearr_54556_54571[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54557 = [null,null,null,null,null,null,null,null];
(statearr_54557[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54557[(1)] = (1));

return statearr_54557;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54541){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54541);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54558){var ex__2730__auto__ = e54558;
var statearr_54559_54572 = state_54541;
(statearr_54559_54572[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54541[(4)]))){
var statearr_54560_54573 = state_54541;
(statearr_54560_54573[(1)] = cljs.core.first((state_54541[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54574 = state_54541;
state_54541 = G__54574;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54541){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54561 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54561[(6)] = c__2749__auto__);

return statearr_54561;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54623 = arguments.length;
var i__5770__auto___54624 = (0);
while(true){
if((i__5770__auto___54624 < len__5769__auto___54623)){
args__5775__auto__.push((arguments[i__5770__auto___54624]));

var G__54625 = (i__5770__auto___54624 + (1));
i__5770__auto___54624 = G__54625;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54606){
var state_val_54607 = (state_54606[(1)]);
if((state_val_54607 === (1))){
var state_54606__$1 = state_54606;
var statearr_54608_54626 = state_54606__$1;
(statearr_54608_54626[(2)] = null);

(statearr_54608_54626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54607 === (2))){
var _ = (function (){var statearr_54609 = state_54606;
(statearr_54609[(4)] = cljs.core.cons((5),(state_54606[(4)])));

return statearr_54609;
})();
var inst_54583 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54606__$1 = state_54606;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54606__$1,(6),inst_54583);
} else {
if((state_val_54607 === (3))){
var inst_54604 = (state_54606[(2)]);
var state_54606__$1 = state_54606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54606__$1,inst_54604);
} else {
if((state_val_54607 === (4))){
var inst_54577 = (state_54606[(2)]);
var state_54606__$1 = state_54606;
var statearr_54611_54627 = state_54606__$1;
(statearr_54611_54627[(2)] = inst_54577);

(statearr_54611_54627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54607 === (5))){
var _ = (function (){var statearr_54612 = state_54606;
(statearr_54612[(4)] = cljs.core.rest((state_54606[(4)])));

return statearr_54612;
})();
var state_54606__$1 = state_54606;
var ex54610 = (state_54606__$1[(2)]);
var statearr_54613_54628 = state_54606__$1;
(statearr_54613_54628[(5)] = ex54610);


if((ex54610 instanceof Error)){
var statearr_54614_54629 = state_54606__$1;
(statearr_54614_54629[(1)] = (4));

(statearr_54614_54629[(5)] = null);

} else {
throw ex54610;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54607 === (6))){
var inst_54585 = (state_54606[(2)]);
var inst_54586 = fluree.db.util.async.throw_err(inst_54585);
var inst_54587 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_54586);
var inst_54588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54589 = [inst_54586];
var inst_54590 = (new cljs.core.PersistentVector(null,1,(5),inst_54588,inst_54589,null));
var inst_54591 = cljs.core.count(inst_54590);
var inst_54592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54593 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54595 = [inst_54586];
var inst_54596 = (new cljs.core.PersistentVector(null,1,(5),inst_54594,inst_54595,null));
var inst_54597 = ["and",inst_54596,inst_54587];
var inst_54598 = cljs.core.PersistentHashMap.fromArrays(inst_54593,inst_54597);
var inst_54599 = [inst_54598,inst_54591];
var inst_54600 = (new cljs.core.PersistentVector(null,2,(5),inst_54592,inst_54599,null));
var inst_54601 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54600);
var _ = (function (){var statearr_54615 = state_54606;
(statearr_54615[(4)] = cljs.core.rest((state_54606[(4)])));

return statearr_54615;
})();
var state_54606__$1 = (function (){var statearr_54616 = state_54606;
(statearr_54616[(7)] = inst_54601);

return statearr_54616;
})();
var statearr_54617_54630 = state_54606__$1;
(statearr_54617_54630[(2)] = inst_54587);

(statearr_54617_54630[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54618 = [null,null,null,null,null,null,null,null];
(statearr_54618[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54618[(1)] = (1));

return statearr_54618;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54606){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54606);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54619){var ex__2730__auto__ = e54619;
var statearr_54620_54631 = state_54606;
(statearr_54620_54631[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54606[(4)]))){
var statearr_54621_54632 = state_54606;
(statearr_54621_54632[(1)] = cljs.core.first((state_54606[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54633 = state_54606;
state_54606 = G__54633;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54606){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54622 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54622[(6)] = c__2749__auto__);

return statearr_54622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq54575){
var G__54576 = cljs.core.first(seq54575);
var seq54575__$1 = cljs.core.next(seq54575);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54576,seq54575__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__5775__auto__ = [];
var len__5769__auto___54682 = arguments.length;
var i__5770__auto___54683 = (0);
while(true){
if((i__5770__auto___54683 < len__5769__auto___54682)){
args__5775__auto__.push((arguments[i__5770__auto___54683]));

var G__54684 = (i__5770__auto___54683 + (1));
i__5770__auto___54683 = G__54684;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54665){
var state_val_54666 = (state_54665[(1)]);
if((state_val_54666 === (1))){
var state_54665__$1 = state_54665;
var statearr_54667_54685 = state_54665__$1;
(statearr_54667_54685[(2)] = null);

(statearr_54667_54685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (2))){
var _ = (function (){var statearr_54668 = state_54665;
(statearr_54668[(4)] = cljs.core.cons((5),(state_54665[(4)])));

return statearr_54668;
})();
var inst_54642 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_54665__$1 = state_54665;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54665__$1,(6),inst_54642);
} else {
if((state_val_54666 === (3))){
var inst_54663 = (state_54665[(2)]);
var state_54665__$1 = state_54665;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54665__$1,inst_54663);
} else {
if((state_val_54666 === (4))){
var inst_54636 = (state_54665[(2)]);
var state_54665__$1 = state_54665;
var statearr_54670_54686 = state_54665__$1;
(statearr_54670_54686[(2)] = inst_54636);

(statearr_54670_54686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (5))){
var _ = (function (){var statearr_54671 = state_54665;
(statearr_54671[(4)] = cljs.core.rest((state_54665[(4)])));

return statearr_54671;
})();
var state_54665__$1 = state_54665;
var ex54669 = (state_54665__$1[(2)]);
var statearr_54672_54687 = state_54665__$1;
(statearr_54672_54687[(5)] = ex54669);


if((ex54669 instanceof Error)){
var statearr_54673_54688 = state_54665__$1;
(statearr_54673_54688[(1)] = (4));

(statearr_54673_54688[(5)] = null);

} else {
throw ex54669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (6))){
var inst_54644 = (state_54665[(2)]);
var inst_54645 = fluree.db.util.async.throw_err(inst_54644);
var inst_54646 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_54645);
var inst_54647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54648 = [inst_54645];
var inst_54649 = (new cljs.core.PersistentVector(null,1,(5),inst_54647,inst_54648,null));
var inst_54650 = cljs.core.count(inst_54649);
var inst_54651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54652 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54654 = [inst_54645];
var inst_54655 = (new cljs.core.PersistentVector(null,1,(5),inst_54653,inst_54654,null));
var inst_54656 = ["or",inst_54655,inst_54646];
var inst_54657 = cljs.core.PersistentHashMap.fromArrays(inst_54652,inst_54656);
var inst_54658 = [inst_54657,inst_54650];
var inst_54659 = (new cljs.core.PersistentVector(null,2,(5),inst_54651,inst_54658,null));
var inst_54660 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54659);
var _ = (function (){var statearr_54674 = state_54665;
(statearr_54674[(4)] = cljs.core.rest((state_54665[(4)])));

return statearr_54674;
})();
var state_54665__$1 = (function (){var statearr_54675 = state_54665;
(statearr_54675[(7)] = inst_54660);

return statearr_54675;
})();
var statearr_54676_54689 = state_54665__$1;
(statearr_54676_54689[(2)] = inst_54646);

(statearr_54676_54689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_54677 = [null,null,null,null,null,null,null,null];
(statearr_54677[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_54677[(1)] = (1));

return statearr_54677;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_54665){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54665);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54678){var ex__2730__auto__ = e54678;
var statearr_54679_54690 = state_54665;
(statearr_54679_54690[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54665[(4)]))){
var statearr_54680_54691 = state_54665;
(statearr_54680_54691[(1)] = cljs.core.first((state_54665[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54692 = state_54665;
state_54665 = G__54692;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_54665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_54665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54681 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54681[(6)] = c__2749__auto__);

return statearr_54681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq54634){
var G__54635 = cljs.core.first(seq54634);
var seq54634__$1 = cljs.core.next(seq54634);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54635,seq54634__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54730){
var state_val_54731 = (state_54730[(1)]);
if((state_val_54731 === (7))){
var inst_54706 = fluree.db.util.async.channel_QMARK_(coll);
var state_54730__$1 = state_54730;
if(inst_54706){
var statearr_54732_54755 = state_54730__$1;
(statearr_54732_54755[(1)] = (10));

} else {
var statearr_54733_54756 = state_54730__$1;
(statearr_54733_54756[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (1))){
var state_54730__$1 = state_54730;
var statearr_54734_54757 = state_54730__$1;
(statearr_54734_54757[(2)] = null);

(statearr_54734_54757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (4))){
var inst_54693 = (state_54730[(2)]);
var state_54730__$1 = state_54730;
var statearr_54735_54758 = state_54730__$1;
(statearr_54735_54758[(2)] = inst_54693);

(statearr_54735_54758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (13))){
var inst_54709 = (state_54730[(2)]);
var inst_54710 = fluree.db.util.async.throw_err(inst_54709);
var state_54730__$1 = state_54730;
var statearr_54736_54759 = state_54730__$1;
(statearr_54736_54759[(2)] = inst_54710);

(statearr_54736_54759[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (6))){
var inst_54701 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_54730__$1 = state_54730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54730__$1,(9),inst_54701);
} else {
if((state_val_54731 === (3))){
var inst_54728 = (state_54730[(2)]);
var state_54730__$1 = state_54730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54730__$1,inst_54728);
} else {
if((state_val_54731 === (12))){
var inst_54713 = (state_54730[(2)]);
var state_54730__$1 = state_54730;
var statearr_54737_54760 = state_54730__$1;
(statearr_54737_54760[(2)] = inst_54713);

(statearr_54737_54760[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (2))){
var _ = (function (){var statearr_54738 = state_54730;
(statearr_54738[(4)] = cljs.core.cons((5),(state_54730[(4)])));

return statearr_54738;
})();
var inst_54699 = cljs.core.vector_QMARK_(coll);
var state_54730__$1 = state_54730;
if(inst_54699){
var statearr_54739_54761 = state_54730__$1;
(statearr_54739_54761[(1)] = (6));

} else {
var statearr_54740_54762 = state_54730__$1;
(statearr_54740_54762[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (11))){
var state_54730__$1 = state_54730;
var statearr_54742_54763 = state_54730__$1;
(statearr_54742_54763[(2)] = coll);

(statearr_54742_54763[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (9))){
var inst_54703 = (state_54730[(2)]);
var inst_54704 = fluree.db.util.async.throw_err(inst_54703);
var state_54730__$1 = state_54730;
var statearr_54743_54764 = state_54730__$1;
(statearr_54743_54764[(2)] = inst_54704);

(statearr_54743_54764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (5))){
var _ = (function (){var statearr_54744 = state_54730;
(statearr_54744[(4)] = cljs.core.rest((state_54730[(4)])));

return statearr_54744;
})();
var state_54730__$1 = state_54730;
var ex54741 = (state_54730__$1[(2)]);
var statearr_54745_54765 = state_54730__$1;
(statearr_54745_54765[(5)] = ex54741);


if((ex54741 instanceof Error)){
var statearr_54746_54766 = state_54730__$1;
(statearr_54746_54766[(1)] = (4));

(statearr_54746_54766[(5)] = null);

} else {
throw ex54741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54731 === (10))){
var state_54730__$1 = state_54730;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54730__$1,(13),coll);
} else {
if((state_val_54731 === (8))){
var inst_54715 = (state_54730[(2)]);
var inst_54716 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_54715);
var inst_54717 = cljs.core.count(inst_54716);
var inst_54718 = ((9) + inst_54717);
var inst_54719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54720 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54721 = ["count",inst_54715,inst_54717];
var inst_54722 = cljs.core.PersistentHashMap.fromArrays(inst_54720,inst_54721);
var inst_54723 = [inst_54722,inst_54718];
var inst_54724 = (new cljs.core.PersistentVector(null,2,(5),inst_54719,inst_54723,null));
var inst_54725 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54724);
var _ = (function (){var statearr_54747 = state_54730;
(statearr_54747[(4)] = cljs.core.rest((state_54730[(4)])));

return statearr_54747;
})();
var state_54730__$1 = (function (){var statearr_54748 = state_54730;
(statearr_54748[(7)] = inst_54725);

return statearr_54748;
})();
var statearr_54749_54767 = state_54730__$1;
(statearr_54749_54767[(2)] = inst_54717);

(statearr_54749_54767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0 = (function (){
var statearr_54750 = [null,null,null,null,null,null,null,null];
(statearr_54750[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__);

(statearr_54750[(1)] = (1));

return statearr_54750;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1 = (function (state_54730){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54730);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54751){var ex__2730__auto__ = e54751;
var statearr_54752_54768 = state_54730;
(statearr_54752_54768[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54730[(4)]))){
var statearr_54753_54769 = state_54730;
(statearr_54753_54769[(1)] = cljs.core.first((state_54730[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54770 = state_54730;
state_54730 = G__54770;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__ = function(state_54730){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1.call(this,state_54730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54754 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54754[(6)] = c__2749__auto__);

return statearr_54754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(p__54771,subject,pred){
var map__54772 = p__54771;
var map__54772__$1 = cljs.core.__destructure_map(map__54772);
var _QMARK_ctx = map__54772__$1;
var cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54772__$1,new cljs.core.Keyword(null,"cache","cache",-1237023054));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54772__$1,new cljs.core.Keyword(null,"db","db",993250759));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_54863){
var state_val_54864 = (state_54863[(1)]);
if((state_val_54864 === (7))){
var state_54863__$1 = state_54863;
var statearr_54865_54921 = state_54863__$1;
(statearr_54865_54921[(2)] = subject);

(statearr_54865_54921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (20))){
var state_54863__$1 = state_54863;
var statearr_54866_54922 = state_54863__$1;
(statearr_54866_54922[(2)] = cache);

(statearr_54866_54922[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (27))){
var inst_54794 = (state_54863[(7)]);
var inst_54806 = (state_54863[(8)]);
var inst_54820 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_54806,inst_54794);
var state_54863__$1 = state_54863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54863__$1,(29),inst_54820);
} else {
if((state_val_54864 === (1))){
var state_54863__$1 = state_54863;
var statearr_54867_54923 = state_54863__$1;
(statearr_54867_54923[(2)] = null);

(statearr_54867_54923[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (24))){
var inst_54806 = (state_54863[(8)]);
var inst_54833 = cljs.core.int_QMARK_(inst_54806);
var state_54863__$1 = state_54863;
if(inst_54833){
var statearr_54868_54924 = state_54863__$1;
(statearr_54868_54924[(1)] = (30));

} else {
var statearr_54869_54925 = state_54863__$1;
(statearr_54869_54925[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (4))){
var inst_54773 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
var statearr_54870_54926 = state_54863__$1;
(statearr_54870_54926[(2)] = inst_54773);

(statearr_54870_54926[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (15))){
var inst_54786 = (state_54863[(9)]);
var state_54863__$1 = state_54863;
var statearr_54871_54927 = state_54863__$1;
(statearr_54871_54927[(2)] = inst_54786);

(statearr_54871_54927[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (21))){
var inst_54807 = (state_54863[(10)]);
var state_54863__$1 = state_54863;
var statearr_54872_54928 = state_54863__$1;
(statearr_54872_54928[(2)] = inst_54807);

(statearr_54872_54928[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (31))){
var state_54863__$1 = state_54863;
var statearr_54873_54929 = state_54863__$1;
(statearr_54873_54929[(1)] = (34));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (32))){
var inst_54846 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
var statearr_54875_54930 = state_54863__$1;
(statearr_54875_54930[(2)] = inst_54846);

(statearr_54875_54930[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (33))){
var inst_54837 = (state_54863[(2)]);
var inst_54838 = fluree.db.util.async.throw_err(inst_54837);
var state_54863__$1 = state_54863;
var statearr_54876_54931 = state_54863__$1;
(statearr_54876_54931[(2)] = inst_54838);

(statearr_54876_54931[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (13))){
var inst_54790 = (state_54863[(2)]);
var inst_54791 = fluree.db.util.async.throw_err(inst_54790);
var state_54863__$1 = state_54863;
var statearr_54877_54932 = state_54863__$1;
(statearr_54877_54932[(2)] = inst_54791);

(statearr_54877_54932[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (22))){
var inst_54811 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
if(cljs.core.truth_(inst_54811)){
var statearr_54878_54933 = state_54863__$1;
(statearr_54878_54933[(1)] = (23));

} else {
var statearr_54879_54934 = state_54863__$1;
(statearr_54879_54934[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (36))){
var inst_54844 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
var statearr_54880_54935 = state_54863__$1;
(statearr_54880_54935[(2)] = inst_54844);

(statearr_54880_54935[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (29))){
var inst_54794 = (state_54863[(7)]);
var inst_54806 = (state_54863[(8)]);
var inst_54822 = (state_54863[(2)]);
var inst_54823 = fluree.db.util.async.throw_err(inst_54822);
var inst_54824 = cljs.core._deref(cache);
var inst_54825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54826 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_54806,inst_54794];
var inst_54827 = (new cljs.core.PersistentVector(null,3,(5),inst_54825,inst_54826,null));
var inst_54828 = cljs.core.assoc_in(inst_54824,inst_54827,inst_54823);
var inst_54829 = cljs.core._vreset_BANG_(cache,inst_54828);
var state_54863__$1 = (function (){var statearr_54881 = state_54863;
(statearr_54881[(11)] = inst_54829);

return statearr_54881;
})();
var statearr_54882_54936 = state_54863__$1;
(statearr_54882_54936[(2)] = inst_54823);

(statearr_54882_54936[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (6))){
var state_54863__$1 = state_54863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54863__$1,(9),subject);
} else {
if((state_val_54864 === (28))){
var inst_54831 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
var statearr_54883_54937 = state_54863__$1;
(statearr_54883_54937[(2)] = inst_54831);

(statearr_54883_54937[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (25))){
var inst_54794 = (state_54863[(7)]);
var inst_54786 = (state_54863[(9)]);
var inst_54848 = (state_54863[(2)]);
var inst_54849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54850 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54852 = [inst_54786,inst_54794];
var inst_54853 = (new cljs.core.PersistentVector(null,2,(5),inst_54851,inst_54852,null));
var inst_54854 = ["get",inst_54853,inst_54848];
var inst_54855 = cljs.core.PersistentHashMap.fromArrays(inst_54850,inst_54854);
var inst_54856 = [inst_54855,(10)];
var inst_54857 = (new cljs.core.PersistentVector(null,2,(5),inst_54849,inst_54856,null));
var inst_54858 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54857);
var _ = (function (){var statearr_54884 = state_54863;
(statearr_54884[(4)] = cljs.core.rest((state_54863[(4)])));

return statearr_54884;
})();
var state_54863__$1 = (function (){var statearr_54885 = state_54863;
(statearr_54885[(12)] = inst_54858);

return statearr_54885;
})();
var statearr_54886_54938 = state_54863__$1;
(statearr_54886_54938[(2)] = inst_54848);

(statearr_54886_54938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (34))){
var inst_54794 = (state_54863[(7)]);
var inst_54806 = (state_54863[(8)]);
var inst_54841 = fluree.db.dbfunctions.internal.get(inst_54806,inst_54794);
var state_54863__$1 = state_54863;
var statearr_54887_54939 = state_54863__$1;
(statearr_54887_54939[(2)] = inst_54841);

(statearr_54887_54939[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (17))){
var inst_54786 = (state_54863[(9)]);
var inst_54800 = cljs.core.first(inst_54786);
var state_54863__$1 = state_54863;
var statearr_54888_54940 = state_54863__$1;
(statearr_54888_54940[(2)] = inst_54800);

(statearr_54888_54940[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (3))){
var inst_54861 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54863__$1,inst_54861);
} else {
if((state_val_54864 === (12))){
var inst_54786 = (state_54863[(9)]);
var inst_54794 = (state_54863[(2)]);
var inst_54795 = cljs.core.vector_QMARK_(inst_54786);
var state_54863__$1 = (function (){var statearr_54889 = state_54863;
(statearr_54889[(7)] = inst_54794);

return statearr_54889;
})();
if(inst_54795){
var statearr_54890_54941 = state_54863__$1;
(statearr_54890_54941[(1)] = (14));

} else {
var statearr_54891_54942 = state_54863__$1;
(statearr_54891_54942[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (2))){
var _ = (function (){var statearr_54892 = state_54863;
(statearr_54892[(4)] = cljs.core.cons((5),(state_54863[(4)])));

return statearr_54892;
})();
var inst_54779 = fluree.db.util.async.channel_QMARK_(subject);
var state_54863__$1 = state_54863;
if(inst_54779){
var statearr_54893_54943 = state_54863__$1;
(statearr_54893_54943[(1)] = (6));

} else {
var statearr_54894_54944 = state_54863__$1;
(statearr_54894_54944[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (23))){
var inst_54794 = (state_54863[(7)]);
var inst_54817 = (state_54863[(13)]);
var inst_54806 = (state_54863[(8)]);
var inst_54813 = cljs.core.deref(cache);
var inst_54814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54815 = [new cljs.core.Keyword(null,"get","get",1683182755),inst_54806,inst_54794];
var inst_54816 = (new cljs.core.PersistentVector(null,3,(5),inst_54814,inst_54815,null));
var inst_54817__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_54813,inst_54816);
var state_54863__$1 = (function (){var statearr_54895 = state_54863;
(statearr_54895[(13)] = inst_54817__$1);

return statearr_54895;
})();
if(cljs.core.truth_(inst_54817__$1)){
var statearr_54896_54945 = state_54863__$1;
(statearr_54896_54945[(1)] = (26));

} else {
var statearr_54897_54946 = state_54863__$1;
(statearr_54897_54946[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (35))){
var state_54863__$1 = state_54863;
var statearr_54898_54947 = state_54863__$1;
(statearr_54898_54947[(2)] = null);

(statearr_54898_54947[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (19))){
var inst_54803 = (state_54863[(2)]);
var state_54863__$1 = state_54863;
var statearr_54899_54948 = state_54863__$1;
(statearr_54899_54948[(2)] = inst_54803);

(statearr_54899_54948[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (11))){
var state_54863__$1 = state_54863;
var statearr_54901_54949 = state_54863__$1;
(statearr_54901_54949[(2)] = pred);

(statearr_54901_54949[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (9))){
var inst_54782 = (state_54863[(2)]);
var inst_54783 = fluree.db.util.async.throw_err(inst_54782);
var state_54863__$1 = state_54863;
var statearr_54902_54950 = state_54863__$1;
(statearr_54902_54950[(2)] = inst_54783);

(statearr_54902_54950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (5))){
var _ = (function (){var statearr_54903 = state_54863;
(statearr_54903[(4)] = cljs.core.rest((state_54863[(4)])));

return statearr_54903;
})();
var state_54863__$1 = state_54863;
var ex54900 = (state_54863__$1[(2)]);
var statearr_54904_54951 = state_54863__$1;
(statearr_54904_54951[(5)] = ex54900);


if((ex54900 instanceof Error)){
var statearr_54905_54952 = state_54863__$1;
(statearr_54905_54952[(1)] = (4));

(statearr_54905_54952[(5)] = null);

} else {
throw ex54900;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (14))){
var inst_54786 = (state_54863[(9)]);
var inst_54797 = cljs.core.count(inst_54786);
var inst_54798 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_54797);
var state_54863__$1 = state_54863;
if(inst_54798){
var statearr_54906_54953 = state_54863__$1;
(statearr_54906_54953[(1)] = (17));

} else {
var statearr_54907_54954 = state_54863__$1;
(statearr_54907_54954[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (26))){
var inst_54817 = (state_54863[(13)]);
var state_54863__$1 = state_54863;
var statearr_54908_54955 = state_54863__$1;
(statearr_54908_54955[(2)] = inst_54817);

(statearr_54908_54955[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (16))){
var inst_54807 = (state_54863[(10)]);
var inst_54806 = (state_54863[(8)]);
var inst_54806__$1 = (state_54863[(2)]);
var inst_54807__$1 = cljs.core.int_QMARK_(inst_54806__$1);
var state_54863__$1 = (function (){var statearr_54909 = state_54863;
(statearr_54909[(10)] = inst_54807__$1);

(statearr_54909[(8)] = inst_54806__$1);

return statearr_54909;
})();
if(inst_54807__$1){
var statearr_54910_54956 = state_54863__$1;
(statearr_54910_54956[(1)] = (20));

} else {
var statearr_54911_54957 = state_54863__$1;
(statearr_54911_54957[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (30))){
var inst_54794 = (state_54863[(7)]);
var inst_54806 = (state_54863[(8)]);
var inst_54835 = fluree.db.dbfunctions.internal.get_subj_pred(db,inst_54806,inst_54794);
var state_54863__$1 = state_54863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54863__$1,(33),inst_54835);
} else {
if((state_val_54864 === (10))){
var state_54863__$1 = state_54863;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54863__$1,(13),pred);
} else {
if((state_val_54864 === (18))){
var inst_54786 = (state_54863[(9)]);
var state_54863__$1 = state_54863;
var statearr_54912_54958 = state_54863__$1;
(statearr_54912_54958[(2)] = inst_54786);

(statearr_54912_54958[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54864 === (8))){
var inst_54786 = (state_54863[(2)]);
var inst_54787 = fluree.db.util.async.channel_QMARK_(pred);
var state_54863__$1 = (function (){var statearr_54913 = state_54863;
(statearr_54913[(9)] = inst_54786);

return statearr_54913;
})();
if(inst_54787){
var statearr_54914_54959 = state_54863__$1;
(statearr_54914_54959[(1)] = (10));

} else {
var statearr_54915_54960 = state_54863__$1;
(statearr_54915_54960[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0 = (function (){
var statearr_54916 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54916[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__);

(statearr_54916[(1)] = (1));

return statearr_54916;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1 = (function (state_54863){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_54863);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e54917){var ex__2730__auto__ = e54917;
var statearr_54918_54961 = state_54863;
(statearr_54918_54961[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_54863[(4)]))){
var statearr_54919_54962 = state_54863;
(statearr_54919_54962[(1)] = cljs.core.first((state_54863[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54963 = state_54863;
state_54863 = G__54963;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__ = function(state_54863){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1.call(this,state_54863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_54920 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_54920[(6)] = c__2749__auto__);

return statearr_54920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55002){
var state_val_55003 = (state_55002[(1)]);
if((state_val_55003 === (7))){
var inst_54970 = (state_55002[(7)]);
var state_55002__$1 = state_55002;
var statearr_55004_55028 = state_55002__$1;
(statearr_55004_55028[(2)] = inst_54970);

(statearr_55004_55028[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (1))){
var state_55002__$1 = state_55002;
var statearr_55005_55029 = state_55002__$1;
(statearr_55005_55029[(2)] = null);

(statearr_55005_55029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (4))){
var inst_54964 = (state_55002[(2)]);
var state_55002__$1 = state_55002;
var statearr_55006_55030 = state_55002__$1;
(statearr_55006_55030[(2)] = inst_54964);

(statearr_55006_55030[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (6))){
var inst_54972 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55002__$1 = state_55002;
var statearr_55007_55031 = state_55002__$1;
(statearr_55007_55031[(2)] = inst_54972);

(statearr_55007_55031[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (3))){
var inst_55000 = (state_55002[(2)]);
var state_55002__$1 = state_55002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55002__$1,inst_55000);
} else {
if((state_val_55003 === (12))){
var inst_54982 = (state_55002[(2)]);
var inst_54983 = fluree.db.util.async.throw_err(inst_54982);
var inst_54984 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54983,(0),null);
var inst_54985 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54983,(1),null);
var inst_54986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54987 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54988 = ["?pO","?ctx",inst_54984];
var inst_54989 = cljs.core.PersistentHashMap.fromArrays(inst_54987,inst_54988);
var inst_54990 = ((10) + inst_54985);
var inst_54991 = [inst_54989,inst_54990];
var inst_54992 = (new cljs.core.PersistentVector(null,2,(5),inst_54986,inst_54991,null));
var inst_54993 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_54992);
var state_55002__$1 = (function (){var statearr_55008 = state_55002;
(statearr_55008[(8)] = inst_54993);

return statearr_55008;
})();
var statearr_55009_55032 = state_55002__$1;
(statearr_55009_55032[(2)] = inst_54984);

(statearr_55009_55032[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (2))){
var inst_54970 = (state_55002[(7)]);
var _ = (function (){var statearr_55010 = state_55002;
(statearr_55010[(4)] = cljs.core.cons((5),(state_55002[(4)])));

return statearr_55010;
})();
var inst_54970__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55002__$1 = (function (){var statearr_55011 = state_55002;
(statearr_55011[(7)] = inst_54970__$1);

return statearr_55011;
})();
if(cljs.core.truth_(inst_54970__$1)){
var statearr_55012_55033 = state_55002__$1;
(statearr_55012_55033[(1)] = (6));

} else {
var statearr_55013_55034 = state_55002__$1;
(statearr_55013_55034[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (11))){
var inst_54997 = (state_55002[(2)]);
var _ = (function (){var statearr_55015 = state_55002;
(statearr_55015[(4)] = cljs.core.rest((state_55002[(4)])));

return statearr_55015;
})();
var state_55002__$1 = state_55002;
var statearr_55016_55035 = state_55002__$1;
(statearr_55016_55035[(2)] = inst_54997);

(statearr_55016_55035[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (9))){
var inst_54980 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_55002__$1 = state_55002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55002__$1,(12),inst_54980);
} else {
if((state_val_55003 === (5))){
var _ = (function (){var statearr_55017 = state_55002;
(statearr_55017[(4)] = cljs.core.rest((state_55002[(4)])));

return statearr_55017;
})();
var state_55002__$1 = state_55002;
var ex55014 = (state_55002__$1[(2)]);
var statearr_55018_55036 = state_55002__$1;
(statearr_55018_55036[(5)] = ex55014);


if((ex55014 instanceof Error)){
var statearr_55019_55037 = state_55002__$1;
(statearr_55019_55037[(1)] = (4));

(statearr_55019_55037[(5)] = null);

} else {
throw ex55014;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (10))){
var inst_54995 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55002__$1 = state_55002;
var statearr_55020_55038 = state_55002__$1;
(statearr_55020_55038[(2)] = inst_54995);

(statearr_55020_55038[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55003 === (8))){
var inst_54975 = (state_55002[(2)]);
var state_55002__$1 = state_55002;
if(cljs.core.truth_(inst_54975)){
var statearr_55021_55039 = state_55002__$1;
(statearr_55021_55039[(1)] = (9));

} else {
var statearr_55022_55040 = state_55002__$1;
(statearr_55022_55040[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0 = (function (){
var statearr_55023 = [null,null,null,null,null,null,null,null,null];
(statearr_55023[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__);

(statearr_55023[(1)] = (1));

return statearr_55023;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1 = (function (state_55002){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55002);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55024){var ex__2730__auto__ = e55024;
var statearr_55025_55041 = state_55002;
(statearr_55025_55041[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55002[(4)]))){
var statearr_55026_55042 = state_55002;
(statearr_55026_55042[(1)] = cljs.core.first((state_55002[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55043 = state_55002;
state_55002 = G__55043;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__ = function(state_55002){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1.call(this,state_55002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55027 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55027[(6)] = c__2749__auto__);

return statearr_55027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55112){
var state_val_55113 = (state_55112[(1)]);
if((state_val_55113 === (7))){
var state_55112__$1 = state_55112;
var statearr_55114_55152 = state_55112__$1;
(statearr_55114_55152[(2)] = subject);

(statearr_55114_55152[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (20))){
var inst_55080 = (state_55112[(7)]);
var inst_55068 = (state_55112[(8)]);
var inst_55083 = fluree.db.dbfunctions.internal.follow_subject(_QMARK_ctx,inst_55080,inst_55068);
var state_55112__$1 = state_55112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55112__$1,(23),inst_55083);
} else {
if((state_val_55113 === (1))){
var state_55112__$1 = state_55112;
var statearr_55115_55153 = state_55112__$1;
(statearr_55115_55153[(2)] = null);

(statearr_55115_55153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (4))){
var inst_55044 = (state_55112[(2)]);
var state_55112__$1 = state_55112;
var statearr_55116_55154 = state_55112__$1;
(statearr_55116_55154[(2)] = inst_55044);

(statearr_55116_55154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (15))){
var inst_55060 = (state_55112[(9)]);
var state_55112__$1 = state_55112;
var statearr_55117_55155 = state_55112__$1;
(statearr_55117_55155[(2)] = inst_55060);

(statearr_55117_55155[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (21))){
var inst_55080 = (state_55112[(7)]);
var inst_55068 = (state_55112[(8)]);
var inst_55088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55089 = fluree.db.dbfunctions.internal.get_all(inst_55080,inst_55068);
var inst_55090 = cljs.core.count(inst_55068);
var inst_55091 = ((9) + inst_55090);
var inst_55092 = [inst_55089,inst_55091];
var inst_55093 = (new cljs.core.PersistentVector(null,2,(5),inst_55088,inst_55092,null));
var state_55112__$1 = state_55112;
var statearr_55118_55156 = state_55112__$1;
(statearr_55118_55156[(2)] = inst_55093);

(statearr_55118_55156[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (13))){
var inst_55064 = (state_55112[(2)]);
var inst_55065 = fluree.db.util.async.throw_err(inst_55064);
var state_55112__$1 = state_55112;
var statearr_55119_55157 = state_55112__$1;
(statearr_55119_55157[(2)] = inst_55065);

(statearr_55119_55157[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (22))){
var inst_55060 = (state_55112[(9)]);
var inst_55068 = (state_55112[(8)]);
var inst_55095 = (state_55112[(2)]);
var inst_55096 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55095,(0),null);
var inst_55097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55095,(1),null);
var inst_55098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55099 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55101 = [inst_55060,inst_55068];
var inst_55102 = (new cljs.core.PersistentVector(null,2,(5),inst_55100,inst_55101,null));
var inst_55103 = ["get-all",inst_55102,inst_55096];
var inst_55104 = cljs.core.PersistentHashMap.fromArrays(inst_55099,inst_55103);
var inst_55105 = [inst_55104,inst_55097];
var inst_55106 = (new cljs.core.PersistentVector(null,2,(5),inst_55098,inst_55105,null));
var inst_55107 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55106);
var _ = (function (){var statearr_55120 = state_55112;
(statearr_55120[(4)] = cljs.core.rest((state_55112[(4)])));

return statearr_55120;
})();
var state_55112__$1 = (function (){var statearr_55121 = state_55112;
(statearr_55121[(10)] = inst_55107);

return statearr_55121;
})();
var statearr_55122_55158 = state_55112__$1;
(statearr_55122_55158[(2)] = inst_55096);

(statearr_55122_55158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (6))){
var state_55112__$1 = state_55112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55112__$1,(9),subject);
} else {
if((state_val_55113 === (17))){
var inst_55060 = (state_55112[(9)]);
var inst_55074 = cljs.core.first(inst_55060);
var state_55112__$1 = state_55112;
var statearr_55123_55159 = state_55112__$1;
(statearr_55123_55159[(2)] = inst_55074);

(statearr_55123_55159[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (3))){
var inst_55110 = (state_55112[(2)]);
var state_55112__$1 = state_55112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55112__$1,inst_55110);
} else {
if((state_val_55113 === (12))){
var inst_55060 = (state_55112[(9)]);
var inst_55068 = (state_55112[(2)]);
var inst_55069 = cljs.core.vector_QMARK_(inst_55060);
var state_55112__$1 = (function (){var statearr_55124 = state_55112;
(statearr_55124[(8)] = inst_55068);

return statearr_55124;
})();
if(inst_55069){
var statearr_55125_55160 = state_55112__$1;
(statearr_55125_55160[(1)] = (14));

} else {
var statearr_55126_55161 = state_55112__$1;
(statearr_55126_55161[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (2))){
var _ = (function (){var statearr_55127 = state_55112;
(statearr_55127[(4)] = cljs.core.cons((5),(state_55112[(4)])));

return statearr_55127;
})();
var inst_55053 = fluree.db.util.async.channel_QMARK_(subject);
var state_55112__$1 = state_55112;
if(inst_55053){
var statearr_55128_55162 = state_55112__$1;
(statearr_55128_55162[(1)] = (6));

} else {
var statearr_55129_55163 = state_55112__$1;
(statearr_55129_55163[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (23))){
var inst_55085 = (state_55112[(2)]);
var inst_55086 = fluree.db.util.async.throw_err(inst_55085);
var state_55112__$1 = state_55112;
var statearr_55130_55164 = state_55112__$1;
(statearr_55130_55164[(2)] = inst_55086);

(statearr_55130_55164[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (19))){
var inst_55077 = (state_55112[(2)]);
var state_55112__$1 = state_55112;
var statearr_55131_55165 = state_55112__$1;
(statearr_55131_55165[(2)] = inst_55077);

(statearr_55131_55165[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (11))){
var state_55112__$1 = state_55112;
var statearr_55133_55166 = state_55112__$1;
(statearr_55133_55166[(2)] = path);

(statearr_55133_55166[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (9))){
var inst_55056 = (state_55112[(2)]);
var inst_55057 = fluree.db.util.async.throw_err(inst_55056);
var state_55112__$1 = state_55112;
var statearr_55134_55167 = state_55112__$1;
(statearr_55134_55167[(2)] = inst_55057);

(statearr_55134_55167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (5))){
var _ = (function (){var statearr_55135 = state_55112;
(statearr_55135[(4)] = cljs.core.rest((state_55112[(4)])));

return statearr_55135;
})();
var state_55112__$1 = state_55112;
var ex55132 = (state_55112__$1[(2)]);
var statearr_55136_55168 = state_55112__$1;
(statearr_55136_55168[(5)] = ex55132);


if((ex55132 instanceof Error)){
var statearr_55137_55169 = state_55112__$1;
(statearr_55137_55169[(1)] = (4));

(statearr_55137_55169[(5)] = null);

} else {
throw ex55132;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (14))){
var inst_55060 = (state_55112[(9)]);
var inst_55071 = cljs.core.count(inst_55060);
var inst_55072 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55071);
var state_55112__$1 = state_55112;
if(inst_55072){
var statearr_55138_55170 = state_55112__$1;
(statearr_55138_55170[(1)] = (17));

} else {
var statearr_55139_55171 = state_55112__$1;
(statearr_55139_55171[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (16))){
var inst_55080 = (state_55112[(7)]);
var inst_55080__$1 = (state_55112[(2)]);
var inst_55081 = cljs.core.int_QMARK_(inst_55080__$1);
var state_55112__$1 = (function (){var statearr_55140 = state_55112;
(statearr_55140[(7)] = inst_55080__$1);

return statearr_55140;
})();
if(inst_55081){
var statearr_55141_55172 = state_55112__$1;
(statearr_55141_55172[(1)] = (20));

} else {
var statearr_55142_55173 = state_55112__$1;
(statearr_55142_55173[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (10))){
var state_55112__$1 = state_55112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55112__$1,(13),path);
} else {
if((state_val_55113 === (18))){
var inst_55060 = (state_55112[(9)]);
var state_55112__$1 = state_55112;
var statearr_55143_55174 = state_55112__$1;
(statearr_55143_55174[(2)] = inst_55060);

(statearr_55143_55174[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55113 === (8))){
var inst_55060 = (state_55112[(2)]);
var inst_55061 = fluree.db.util.async.channel_QMARK_(path);
var state_55112__$1 = (function (){var statearr_55144 = state_55112;
(statearr_55144[(9)] = inst_55060);

return statearr_55144;
})();
if(inst_55061){
var statearr_55145_55175 = state_55112__$1;
(statearr_55145_55175[(1)] = (10));

} else {
var statearr_55146_55176 = state_55112__$1;
(statearr_55146_55176[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0 = (function (){
var statearr_55147 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_55147[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__);

(statearr_55147[(1)] = (1));

return statearr_55147;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1 = (function (state_55112){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55112);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55148){var ex__2730__auto__ = e55148;
var statearr_55149_55177 = state_55112;
(statearr_55149_55177[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55112[(4)]))){
var statearr_55150_55178 = state_55112;
(statearr_55150_55178[(1)] = cljs.core.first((state_55112[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55179 = state_55112;
state_55112 = G__55179;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__ = function(state_55112){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1.call(this,state_55112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55151 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55151[(6)] = c__2749__auto__);

return statearr_55151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55218){
var state_val_55219 = (state_55218[(1)]);
if((state_val_55219 === (7))){
var state_55218__$1 = state_55218;
var statearr_55220_55244 = state_55218__$1;
(statearr_55220_55244[(2)] = subject);

(statearr_55220_55244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (1))){
var state_55218__$1 = state_55218;
var statearr_55221_55245 = state_55218__$1;
(statearr_55221_55245[(2)] = null);

(statearr_55221_55245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (4))){
var inst_55180 = (state_55218[(2)]);
var state_55218__$1 = state_55218;
var statearr_55222_55246 = state_55218__$1;
(statearr_55222_55246[(2)] = inst_55180);

(statearr_55222_55246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (13))){
var inst_55197 = (state_55218[(2)]);
var inst_55198 = fluree.db.util.async.throw_err(inst_55197);
var state_55218__$1 = state_55218;
var statearr_55223_55247 = state_55218__$1;
(statearr_55223_55247[(2)] = inst_55198);

(statearr_55223_55247[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (6))){
var state_55218__$1 = state_55218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55218__$1,(9),subject);
} else {
if((state_val_55219 === (3))){
var inst_55216 = (state_55218[(2)]);
var state_55218__$1 = state_55218;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55218__$1,inst_55216);
} else {
if((state_val_55219 === (12))){
var inst_55193 = (state_55218[(7)]);
var inst_55201 = (state_55218[(2)]);
var inst_55202 = fluree.db.dbfunctions.internal.get_in(inst_55193,inst_55201);
var inst_55203 = cljs.core.count(inst_55201);
var inst_55204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55205 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55207 = [inst_55193,inst_55201];
var inst_55208 = (new cljs.core.PersistentVector(null,2,(5),inst_55206,inst_55207,null));
var inst_55209 = ["get-in",inst_55208,inst_55202];
var inst_55210 = cljs.core.PersistentHashMap.fromArrays(inst_55205,inst_55209);
var inst_55211 = [inst_55210,inst_55203];
var inst_55212 = (new cljs.core.PersistentVector(null,2,(5),inst_55204,inst_55211,null));
var inst_55213 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55212);
var _ = (function (){var statearr_55224 = state_55218;
(statearr_55224[(4)] = cljs.core.rest((state_55218[(4)])));

return statearr_55224;
})();
var state_55218__$1 = (function (){var statearr_55225 = state_55218;
(statearr_55225[(8)] = inst_55213);

return statearr_55225;
})();
var statearr_55226_55248 = state_55218__$1;
(statearr_55226_55248[(2)] = inst_55202);

(statearr_55226_55248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (2))){
var _ = (function (){var statearr_55227 = state_55218;
(statearr_55227[(4)] = cljs.core.cons((5),(state_55218[(4)])));

return statearr_55227;
})();
var inst_55186 = fluree.db.util.async.channel_QMARK_(subject);
var state_55218__$1 = state_55218;
if(inst_55186){
var statearr_55228_55249 = state_55218__$1;
(statearr_55228_55249[(1)] = (6));

} else {
var statearr_55229_55250 = state_55218__$1;
(statearr_55229_55250[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (11))){
var state_55218__$1 = state_55218;
var statearr_55231_55251 = state_55218__$1;
(statearr_55231_55251[(2)] = path);

(statearr_55231_55251[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (9))){
var inst_55189 = (state_55218[(2)]);
var inst_55190 = fluree.db.util.async.throw_err(inst_55189);
var state_55218__$1 = state_55218;
var statearr_55232_55252 = state_55218__$1;
(statearr_55232_55252[(2)] = inst_55190);

(statearr_55232_55252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (5))){
var _ = (function (){var statearr_55233 = state_55218;
(statearr_55233[(4)] = cljs.core.rest((state_55218[(4)])));

return statearr_55233;
})();
var state_55218__$1 = state_55218;
var ex55230 = (state_55218__$1[(2)]);
var statearr_55234_55253 = state_55218__$1;
(statearr_55234_55253[(5)] = ex55230);


if((ex55230 instanceof Error)){
var statearr_55235_55254 = state_55218__$1;
(statearr_55235_55254[(1)] = (4));

(statearr_55235_55254[(5)] = null);

} else {
throw ex55230;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55219 === (10))){
var state_55218__$1 = state_55218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55218__$1,(13),path);
} else {
if((state_val_55219 === (8))){
var inst_55193 = (state_55218[(2)]);
var inst_55194 = fluree.db.util.async.channel_QMARK_(path);
var state_55218__$1 = (function (){var statearr_55236 = state_55218;
(statearr_55236[(7)] = inst_55193);

return statearr_55236;
})();
if(inst_55194){
var statearr_55237_55255 = state_55218__$1;
(statearr_55237_55255[(1)] = (10));

} else {
var statearr_55238_55256 = state_55218__$1;
(statearr_55238_55256[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0 = (function (){
var statearr_55239 = [null,null,null,null,null,null,null,null,null];
(statearr_55239[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__);

(statearr_55239[(1)] = (1));

return statearr_55239;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1 = (function (state_55218){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55218);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55240){var ex__2730__auto__ = e55240;
var statearr_55241_55257 = state_55218;
(statearr_55241_55257[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55218[(4)]))){
var statearr_55242_55258 = state_55218;
(statearr_55242_55258[(1)] = cljs.core.first((state_55218[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55259 = state_55218;
state_55218 = G__55259;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__ = function(state_55218){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1.call(this,state_55218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55243 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55243[(6)] = c__2749__auto__);

return statearr_55243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a value from the user's context if set. Provide the key or key sequence.
 */
fluree.db.dbfunctions.fns.ctx = (function fluree$db$dbfunctions$fns$ctx(p__55260,key_or_ks){
var map__55261 = p__55260;
var map__55261__$1 = cljs.core.__destructure_map(map__55261);
var _QMARK_ctx = map__55261__$1;
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__55261__$1,new cljs.core.Keyword(null,"db","db",993250759));
if(cljs.core.sequential_QMARK_(key_or_ks)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ctx","ctx",-493610118).cljs$core$IFn$_invoke$arity$1(db),key_or_ks);
}
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55306){
var state_val_55307 = (state_55306[(1)]);
if((state_val_55307 === (7))){
var state_55306__$1 = state_55306;
var statearr_55308_55337 = state_55306__$1;
(statearr_55308_55337[(2)] = coll);

(statearr_55308_55337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (1))){
var state_55306__$1 = state_55306;
var statearr_55309_55338 = state_55306__$1;
(statearr_55309_55338[(2)] = null);

(statearr_55309_55338[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (4))){
var inst_55262 = (state_55306[(2)]);
var state_55306__$1 = state_55306;
var statearr_55310_55339 = state_55306__$1;
(statearr_55310_55339[(2)] = inst_55262);

(statearr_55310_55339[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (15))){
var inst_55282 = (state_55306[(7)]);
var inst_55290 = (state_55306[(2)]);
var inst_55291 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_55282,inst_55290);
var inst_55292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55293 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55295 = [inst_55282,inst_55290];
var inst_55296 = (new cljs.core.PersistentVector(null,2,(5),inst_55294,inst_55295,null));
var inst_55297 = ["contains?",inst_55296,inst_55291];
var inst_55298 = cljs.core.PersistentHashMap.fromArrays(inst_55293,inst_55297);
var inst_55299 = [inst_55298,(10)];
var inst_55300 = (new cljs.core.PersistentVector(null,2,(5),inst_55292,inst_55299,null));
var inst_55301 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55300);
var _ = (function (){var statearr_55311 = state_55306;
(statearr_55311[(4)] = cljs.core.rest((state_55306[(4)])));

return statearr_55311;
})();
var state_55306__$1 = (function (){var statearr_55312 = state_55306;
(statearr_55312[(8)] = inst_55301);

return statearr_55312;
})();
var statearr_55313_55340 = state_55306__$1;
(statearr_55313_55340[(2)] = inst_55291);

(statearr_55313_55340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (13))){
var state_55306__$1 = state_55306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55306__$1,(16),key);
} else {
if((state_val_55307 === (6))){
var state_55306__$1 = state_55306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55306__$1,(9),coll);
} else {
if((state_val_55307 === (3))){
var inst_55304 = (state_55306[(2)]);
var state_55306__$1 = state_55306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55306__$1,inst_55304);
} else {
if((state_val_55307 === (12))){
var inst_55282 = (state_55306[(2)]);
var inst_55283 = fluree.db.util.async.channel_QMARK_(key);
var state_55306__$1 = (function (){var statearr_55314 = state_55306;
(statearr_55314[(7)] = inst_55282);

return statearr_55314;
})();
if(inst_55283){
var statearr_55315_55341 = state_55306__$1;
(statearr_55315_55341[(1)] = (13));

} else {
var statearr_55316_55342 = state_55306__$1;
(statearr_55316_55342[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (2))){
var _ = (function (){var statearr_55317 = state_55306;
(statearr_55317[(4)] = cljs.core.cons((5),(state_55306[(4)])));

return statearr_55317;
})();
var inst_55268 = fluree.db.util.async.channel_QMARK_(coll);
var state_55306__$1 = state_55306;
if(inst_55268){
var statearr_55318_55343 = state_55306__$1;
(statearr_55318_55343[(1)] = (6));

} else {
var statearr_55319_55344 = state_55306__$1;
(statearr_55319_55344[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (11))){
var inst_55275 = (state_55306[(9)]);
var inst_55279 = cljs.core.flatten(inst_55275);
var inst_55280 = cljs.core.set(inst_55279);
var state_55306__$1 = state_55306;
var statearr_55321_55345 = state_55306__$1;
(statearr_55321_55345[(2)] = inst_55280);

(statearr_55321_55345[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (9))){
var inst_55271 = (state_55306[(2)]);
var inst_55272 = fluree.db.util.async.throw_err(inst_55271);
var state_55306__$1 = state_55306;
var statearr_55322_55346 = state_55306__$1;
(statearr_55322_55346[(2)] = inst_55272);

(statearr_55322_55346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (5))){
var _ = (function (){var statearr_55323 = state_55306;
(statearr_55323[(4)] = cljs.core.rest((state_55306[(4)])));

return statearr_55323;
})();
var state_55306__$1 = state_55306;
var ex55320 = (state_55306__$1[(2)]);
var statearr_55324_55347 = state_55306__$1;
(statearr_55324_55347[(5)] = ex55320);


if((ex55320 instanceof Error)){
var statearr_55325_55348 = state_55306__$1;
(statearr_55325_55348[(1)] = (4));

(statearr_55325_55348[(5)] = null);

} else {
throw ex55320;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (14))){
var state_55306__$1 = state_55306;
var statearr_55326_55349 = state_55306__$1;
(statearr_55326_55349[(2)] = key);

(statearr_55326_55349[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (16))){
var inst_55286 = (state_55306[(2)]);
var inst_55287 = fluree.db.util.async.throw_err(inst_55286);
var state_55306__$1 = state_55306;
var statearr_55327_55350 = state_55306__$1;
(statearr_55327_55350[(2)] = inst_55287);

(statearr_55327_55350[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (10))){
var inst_55275 = (state_55306[(9)]);
var state_55306__$1 = state_55306;
var statearr_55328_55351 = state_55306__$1;
(statearr_55328_55351[(2)] = inst_55275);

(statearr_55328_55351[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55307 === (8))){
var inst_55275 = (state_55306[(9)]);
var inst_55275__$1 = (state_55306[(2)]);
var inst_55276 = cljs.core.set_QMARK_(inst_55275__$1);
var state_55306__$1 = (function (){var statearr_55329 = state_55306;
(statearr_55329[(9)] = inst_55275__$1);

return statearr_55329;
})();
if(inst_55276){
var statearr_55330_55352 = state_55306__$1;
(statearr_55330_55352[(1)] = (10));

} else {
var statearr_55331_55353 = state_55306__$1;
(statearr_55331_55353[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_55332 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55332[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__);

(statearr_55332[(1)] = (1));

return statearr_55332;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1 = (function (state_55306){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55306);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55333){var ex__2730__auto__ = e55333;
var statearr_55334_55354 = state_55306;
(statearr_55334_55354[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55306[(4)]))){
var statearr_55335_55355 = state_55306;
(statearr_55335_55355[(1)] = cljs.core.first((state_55306[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55356 = state_55306;
state_55306 = G__55356;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__ = function(state_55306){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1.call(this,state_55306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55336 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55336[(6)] = c__2749__auto__);

return statearr_55336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55428 = arguments.length;
var i__5770__auto___55429 = (0);
while(true){
if((i__5770__auto___55429 < len__5769__auto___55428)){
args__5775__auto__.push((arguments[i__5770__auto___55429]));

var G__55430 = (i__5770__auto___55429 + (1));
i__5770__auto___55429 = G__55430;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55402){
var state_val_55403 = (state_55402[(1)]);
if((state_val_55403 === (7))){
var inst_55368 = (state_55402[(7)]);
var inst_55372 = cljs.core.first(inst_55368);
var inst_55373 = cljs.core.coll_QMARK_(inst_55372);
var state_55402__$1 = state_55402;
var statearr_55404_55431 = state_55402__$1;
(statearr_55404_55431[(2)] = inst_55373);

(statearr_55404_55431[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (1))){
var state_55402__$1 = state_55402;
var statearr_55405_55432 = state_55402__$1;
(statearr_55405_55432[(2)] = null);

(statearr_55405_55432[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (4))){
var inst_55359 = (state_55402[(2)]);
var state_55402__$1 = state_55402;
var statearr_55406_55433 = state_55402__$1;
(statearr_55406_55433[(2)] = inst_55359);

(statearr_55406_55433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (6))){
var inst_55368 = (state_55402[(7)]);
var inst_55370 = (state_55402[(8)]);
var inst_55367 = (state_55402[(2)]);
var inst_55368__$1 = fluree.db.util.async.throw_err(inst_55367);
var inst_55369 = cljs.core.count(inst_55368__$1);
var inst_55370__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_55369);
var state_55402__$1 = (function (){var statearr_55407 = state_55402;
(statearr_55407[(7)] = inst_55368__$1);

(statearr_55407[(8)] = inst_55370__$1);

return statearr_55407;
})();
if(inst_55370__$1){
var statearr_55408_55434 = state_55402__$1;
(statearr_55408_55434[(1)] = (7));

} else {
var statearr_55409_55435 = state_55402__$1;
(statearr_55409_55435[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (3))){
var inst_55400 = (state_55402[(2)]);
var state_55402__$1 = state_55402;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55402__$1,inst_55400);
} else {
if((state_val_55403 === (12))){
var inst_55381 = (state_55402[(2)]);
var inst_55382 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_55381);
var inst_55383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55384 = [inst_55381];
var inst_55385 = (new cljs.core.PersistentVector(null,1,(5),inst_55383,inst_55384,null));
var inst_55386 = cljs.core.count(inst_55385);
var inst_55387 = ((9) + inst_55386);
var inst_55388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55389 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55391 = [inst_55381];
var inst_55392 = (new cljs.core.PersistentVector(null,1,(5),inst_55390,inst_55391,null));
var inst_55393 = ["hash-set",inst_55392,inst_55382];
var inst_55394 = cljs.core.PersistentHashMap.fromArrays(inst_55389,inst_55393);
var inst_55395 = [inst_55394,inst_55387];
var inst_55396 = (new cljs.core.PersistentVector(null,2,(5),inst_55388,inst_55395,null));
var inst_55397 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55396);
var _ = (function (){var statearr_55410 = state_55402;
(statearr_55410[(4)] = cljs.core.rest((state_55402[(4)])));

return statearr_55410;
})();
var state_55402__$1 = (function (){var statearr_55411 = state_55402;
(statearr_55411[(9)] = inst_55397);

return statearr_55411;
})();
var statearr_55412_55436 = state_55402__$1;
(statearr_55412_55436[(2)] = inst_55382);

(statearr_55412_55436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (2))){
var _ = (function (){var statearr_55413 = state_55402;
(statearr_55413[(4)] = cljs.core.cons((5),(state_55402[(4)])));

return statearr_55413;
})();
var inst_55365 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55402__$1 = state_55402;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55402__$1,(6),inst_55365);
} else {
if((state_val_55403 === (11))){
var inst_55368 = (state_55402[(7)]);
var state_55402__$1 = state_55402;
var statearr_55415_55437 = state_55402__$1;
(statearr_55415_55437[(2)] = inst_55368);

(statearr_55415_55437[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (9))){
var inst_55376 = (state_55402[(2)]);
var state_55402__$1 = state_55402;
if(cljs.core.truth_(inst_55376)){
var statearr_55416_55438 = state_55402__$1;
(statearr_55416_55438[(1)] = (10));

} else {
var statearr_55417_55439 = state_55402__$1;
(statearr_55417_55439[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (5))){
var _ = (function (){var statearr_55418 = state_55402;
(statearr_55418[(4)] = cljs.core.rest((state_55402[(4)])));

return statearr_55418;
})();
var state_55402__$1 = state_55402;
var ex55414 = (state_55402__$1[(2)]);
var statearr_55419_55440 = state_55402__$1;
(statearr_55419_55440[(5)] = ex55414);


if((ex55414 instanceof Error)){
var statearr_55420_55441 = state_55402__$1;
(statearr_55420_55441[(1)] = (4));

(statearr_55420_55441[(5)] = null);

} else {
throw ex55414;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (10))){
var inst_55368 = (state_55402[(7)]);
var inst_55378 = cljs.core.first(inst_55368);
var state_55402__$1 = state_55402;
var statearr_55421_55442 = state_55402__$1;
(statearr_55421_55442[(2)] = inst_55378);

(statearr_55421_55442[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55403 === (8))){
var inst_55370 = (state_55402[(8)]);
var state_55402__$1 = state_55402;
var statearr_55422_55443 = state_55402__$1;
(statearr_55422_55443[(2)] = inst_55370);

(statearr_55422_55443[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55423 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55423[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55423[(1)] = (1));

return statearr_55423;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55402){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55402);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55424){var ex__2730__auto__ = e55424;
var statearr_55425_55444 = state_55402;
(statearr_55425_55444[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55402[(4)]))){
var statearr_55426_55445 = state_55402;
(statearr_55426_55445[(1)] = cljs.core.first((state_55402[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55446 = state_55402;
state_55402 = G__55446;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55402){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55402);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55427 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55427[(6)] = c__2749__auto__);

return statearr_55427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55357){
var G__55358 = cljs.core.first(seq55357);
var seq55357__$1 = cljs.core.next(seq55357);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55358,seq55357__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55496 = arguments.length;
var i__5770__auto___55497 = (0);
while(true){
if((i__5770__auto___55497 < len__5769__auto___55496)){
args__5775__auto__.push((arguments[i__5770__auto___55497]));

var G__55498 = (i__5770__auto___55497 + (1));
i__5770__auto___55497 = G__55498;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55479){
var state_val_55480 = (state_55479[(1)]);
if((state_val_55480 === (1))){
var state_55479__$1 = state_55479;
var statearr_55481_55499 = state_55479__$1;
(statearr_55481_55499[(2)] = null);

(statearr_55481_55499[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55480 === (2))){
var _ = (function (){var statearr_55482 = state_55479;
(statearr_55482[(4)] = cljs.core.cons((5),(state_55479[(4)])));

return statearr_55482;
})();
var inst_55455 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55479__$1 = state_55479;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55479__$1,(6),inst_55455);
} else {
if((state_val_55480 === (3))){
var inst_55477 = (state_55479[(2)]);
var state_55479__$1 = state_55479;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55479__$1,inst_55477);
} else {
if((state_val_55480 === (4))){
var inst_55449 = (state_55479[(2)]);
var state_55479__$1 = state_55479;
var statearr_55484_55500 = state_55479__$1;
(statearr_55484_55500[(2)] = inst_55449);

(statearr_55484_55500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55480 === (5))){
var _ = (function (){var statearr_55485 = state_55479;
(statearr_55485[(4)] = cljs.core.rest((state_55479[(4)])));

return statearr_55485;
})();
var state_55479__$1 = state_55479;
var ex55483 = (state_55479__$1[(2)]);
var statearr_55486_55501 = state_55479__$1;
(statearr_55486_55501[(5)] = ex55483);


if((ex55483 instanceof Error)){
var statearr_55487_55502 = state_55479__$1;
(statearr_55487_55502[(1)] = (4));

(statearr_55487_55502[(5)] = null);

} else {
throw ex55483;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55480 === (6))){
var inst_55457 = (state_55479[(2)]);
var inst_55458 = fluree.db.util.async.throw_err(inst_55457);
var inst_55459 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_55458);
var inst_55460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55461 = [inst_55458];
var inst_55462 = (new cljs.core.PersistentVector(null,1,(5),inst_55460,inst_55461,null));
var inst_55463 = cljs.core.count(inst_55462);
var inst_55464 = ((9) + inst_55463);
var inst_55465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55466 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55468 = [inst_55458];
var inst_55469 = (new cljs.core.PersistentVector(null,1,(5),inst_55467,inst_55468,null));
var inst_55470 = ["==",inst_55469,inst_55459];
var inst_55471 = cljs.core.PersistentHashMap.fromArrays(inst_55466,inst_55470);
var inst_55472 = [inst_55471,inst_55464];
var inst_55473 = (new cljs.core.PersistentVector(null,2,(5),inst_55465,inst_55472,null));
var inst_55474 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55473);
var _ = (function (){var statearr_55488 = state_55479;
(statearr_55488[(4)] = cljs.core.rest((state_55479[(4)])));

return statearr_55488;
})();
var state_55479__$1 = (function (){var statearr_55489 = state_55479;
(statearr_55489[(7)] = inst_55474);

return statearr_55489;
})();
var statearr_55490_55503 = state_55479__$1;
(statearr_55490_55503[(2)] = inst_55459);

(statearr_55490_55503[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55491 = [null,null,null,null,null,null,null,null];
(statearr_55491[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55491[(1)] = (1));

return statearr_55491;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55479){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55479);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55492){var ex__2730__auto__ = e55492;
var statearr_55493_55504 = state_55479;
(statearr_55493_55504[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55479[(4)]))){
var statearr_55494_55505 = state_55479;
(statearr_55494_55505[(1)] = cljs.core.first((state_55479[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55506 = state_55479;
state_55479 = G__55506;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55479){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55495 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55495[(6)] = c__2749__auto__);

return statearr_55495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55447){
var G__55448 = cljs.core.first(seq55447);
var seq55447__$1 = cljs.core.next(seq55447);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55448,seq55447__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55556 = arguments.length;
var i__5770__auto___55557 = (0);
while(true){
if((i__5770__auto___55557 < len__5769__auto___55556)){
args__5775__auto__.push((arguments[i__5770__auto___55557]));

var G__55558 = (i__5770__auto___55557 + (1));
i__5770__auto___55557 = G__55558;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55539){
var state_val_55540 = (state_55539[(1)]);
if((state_val_55540 === (1))){
var state_55539__$1 = state_55539;
var statearr_55541_55559 = state_55539__$1;
(statearr_55541_55559[(2)] = null);

(statearr_55541_55559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55540 === (2))){
var _ = (function (){var statearr_55542 = state_55539;
(statearr_55542[(4)] = cljs.core.cons((5),(state_55539[(4)])));

return statearr_55542;
})();
var inst_55515 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55539__$1 = state_55539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55539__$1,(6),inst_55515);
} else {
if((state_val_55540 === (3))){
var inst_55537 = (state_55539[(2)]);
var state_55539__$1 = state_55539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55539__$1,inst_55537);
} else {
if((state_val_55540 === (4))){
var inst_55509 = (state_55539[(2)]);
var state_55539__$1 = state_55539;
var statearr_55544_55560 = state_55539__$1;
(statearr_55544_55560[(2)] = inst_55509);

(statearr_55544_55560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55540 === (5))){
var _ = (function (){var statearr_55545 = state_55539;
(statearr_55545[(4)] = cljs.core.rest((state_55539[(4)])));

return statearr_55545;
})();
var state_55539__$1 = state_55539;
var ex55543 = (state_55539__$1[(2)]);
var statearr_55546_55561 = state_55539__$1;
(statearr_55546_55561[(5)] = ex55543);


if((ex55543 instanceof Error)){
var statearr_55547_55562 = state_55539__$1;
(statearr_55547_55562[(1)] = (4));

(statearr_55547_55562[(5)] = null);

} else {
throw ex55543;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55540 === (6))){
var inst_55517 = (state_55539[(2)]);
var inst_55518 = fluree.db.util.async.throw_err(inst_55517);
var inst_55519 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_55518);
var inst_55520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55521 = [inst_55518];
var inst_55522 = (new cljs.core.PersistentVector(null,1,(5),inst_55520,inst_55521,null));
var inst_55523 = cljs.core.count(inst_55522);
var inst_55524 = ((9) + inst_55523);
var inst_55525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55526 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55528 = [inst_55518];
var inst_55529 = (new cljs.core.PersistentVector(null,1,(5),inst_55527,inst_55528,null));
var inst_55530 = [">",inst_55529,inst_55519];
var inst_55531 = cljs.core.PersistentHashMap.fromArrays(inst_55526,inst_55530);
var inst_55532 = [inst_55531,inst_55524];
var inst_55533 = (new cljs.core.PersistentVector(null,2,(5),inst_55525,inst_55532,null));
var inst_55534 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55533);
var _ = (function (){var statearr_55548 = state_55539;
(statearr_55548[(4)] = cljs.core.rest((state_55539[(4)])));

return statearr_55548;
})();
var state_55539__$1 = (function (){var statearr_55549 = state_55539;
(statearr_55549[(7)] = inst_55534);

return statearr_55549;
})();
var statearr_55550_55563 = state_55539__$1;
(statearr_55550_55563[(2)] = inst_55519);

(statearr_55550_55563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55551 = [null,null,null,null,null,null,null,null];
(statearr_55551[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55551[(1)] = (1));

return statearr_55551;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55539){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55539);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55552){var ex__2730__auto__ = e55552;
var statearr_55553_55564 = state_55539;
(statearr_55553_55564[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55539[(4)]))){
var statearr_55554_55565 = state_55539;
(statearr_55554_55565[(1)] = cljs.core.first((state_55539[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55566 = state_55539;
state_55539 = G__55566;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55539){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55555 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55555[(6)] = c__2749__auto__);

return statearr_55555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55507){
var G__55508 = cljs.core.first(seq55507);
var seq55507__$1 = cljs.core.next(seq55507);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55508,seq55507__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55616 = arguments.length;
var i__5770__auto___55617 = (0);
while(true){
if((i__5770__auto___55617 < len__5769__auto___55616)){
args__5775__auto__.push((arguments[i__5770__auto___55617]));

var G__55618 = (i__5770__auto___55617 + (1));
i__5770__auto___55617 = G__55618;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55599){
var state_val_55600 = (state_55599[(1)]);
if((state_val_55600 === (1))){
var state_55599__$1 = state_55599;
var statearr_55601_55619 = state_55599__$1;
(statearr_55601_55619[(2)] = null);

(statearr_55601_55619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55600 === (2))){
var _ = (function (){var statearr_55602 = state_55599;
(statearr_55602[(4)] = cljs.core.cons((5),(state_55599[(4)])));

return statearr_55602;
})();
var inst_55575 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55599__$1 = state_55599;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55599__$1,(6),inst_55575);
} else {
if((state_val_55600 === (3))){
var inst_55597 = (state_55599[(2)]);
var state_55599__$1 = state_55599;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55599__$1,inst_55597);
} else {
if((state_val_55600 === (4))){
var inst_55569 = (state_55599[(2)]);
var state_55599__$1 = state_55599;
var statearr_55604_55620 = state_55599__$1;
(statearr_55604_55620[(2)] = inst_55569);

(statearr_55604_55620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55600 === (5))){
var _ = (function (){var statearr_55605 = state_55599;
(statearr_55605[(4)] = cljs.core.rest((state_55599[(4)])));

return statearr_55605;
})();
var state_55599__$1 = state_55599;
var ex55603 = (state_55599__$1[(2)]);
var statearr_55606_55621 = state_55599__$1;
(statearr_55606_55621[(5)] = ex55603);


if((ex55603 instanceof Error)){
var statearr_55607_55622 = state_55599__$1;
(statearr_55607_55622[(1)] = (4));

(statearr_55607_55622[(5)] = null);

} else {
throw ex55603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55600 === (6))){
var inst_55577 = (state_55599[(2)]);
var inst_55578 = fluree.db.util.async.throw_err(inst_55577);
var inst_55579 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_55578);
var inst_55580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55581 = [inst_55578];
var inst_55582 = (new cljs.core.PersistentVector(null,1,(5),inst_55580,inst_55581,null));
var inst_55583 = cljs.core.count(inst_55582);
var inst_55584 = ((9) + inst_55583);
var inst_55585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55586 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55588 = [inst_55578];
var inst_55589 = (new cljs.core.PersistentVector(null,1,(5),inst_55587,inst_55588,null));
var inst_55590 = ["<",inst_55589,inst_55579];
var inst_55591 = cljs.core.PersistentHashMap.fromArrays(inst_55586,inst_55590);
var inst_55592 = [inst_55591,inst_55584];
var inst_55593 = (new cljs.core.PersistentVector(null,2,(5),inst_55585,inst_55592,null));
var inst_55594 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55593);
var _ = (function (){var statearr_55608 = state_55599;
(statearr_55608[(4)] = cljs.core.rest((state_55599[(4)])));

return statearr_55608;
})();
var state_55599__$1 = (function (){var statearr_55609 = state_55599;
(statearr_55609[(7)] = inst_55594);

return statearr_55609;
})();
var statearr_55610_55623 = state_55599__$1;
(statearr_55610_55623[(2)] = inst_55579);

(statearr_55610_55623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55611 = [null,null,null,null,null,null,null,null];
(statearr_55611[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55611[(1)] = (1));

return statearr_55611;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55599){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55599);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55612){var ex__2730__auto__ = e55612;
var statearr_55613_55624 = state_55599;
(statearr_55613_55624[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55599[(4)]))){
var statearr_55614_55625 = state_55599;
(statearr_55614_55625[(1)] = cljs.core.first((state_55599[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55626 = state_55599;
state_55599 = G__55626;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55599){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55599);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55615 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55615[(6)] = c__2749__auto__);

return statearr_55615;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq55567){
var G__55568 = cljs.core.first(seq55567);
var seq55567__$1 = cljs.core.next(seq55567);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55568,seq55567__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55676 = arguments.length;
var i__5770__auto___55677 = (0);
while(true){
if((i__5770__auto___55677 < len__5769__auto___55676)){
args__5775__auto__.push((arguments[i__5770__auto___55677]));

var G__55678 = (i__5770__auto___55677 + (1));
i__5770__auto___55677 = G__55678;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55659){
var state_val_55660 = (state_55659[(1)]);
if((state_val_55660 === (1))){
var state_55659__$1 = state_55659;
var statearr_55661_55679 = state_55659__$1;
(statearr_55661_55679[(2)] = null);

(statearr_55661_55679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (2))){
var _ = (function (){var statearr_55662 = state_55659;
(statearr_55662[(4)] = cljs.core.cons((5),(state_55659[(4)])));

return statearr_55662;
})();
var inst_55635 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55659__$1 = state_55659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55659__$1,(6),inst_55635);
} else {
if((state_val_55660 === (3))){
var inst_55657 = (state_55659[(2)]);
var state_55659__$1 = state_55659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55659__$1,inst_55657);
} else {
if((state_val_55660 === (4))){
var inst_55629 = (state_55659[(2)]);
var state_55659__$1 = state_55659;
var statearr_55664_55680 = state_55659__$1;
(statearr_55664_55680[(2)] = inst_55629);

(statearr_55664_55680[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (5))){
var _ = (function (){var statearr_55665 = state_55659;
(statearr_55665[(4)] = cljs.core.rest((state_55659[(4)])));

return statearr_55665;
})();
var state_55659__$1 = state_55659;
var ex55663 = (state_55659__$1[(2)]);
var statearr_55666_55681 = state_55659__$1;
(statearr_55666_55681[(5)] = ex55663);


if((ex55663 instanceof Error)){
var statearr_55667_55682 = state_55659__$1;
(statearr_55667_55682[(1)] = (4));

(statearr_55667_55682[(5)] = null);

} else {
throw ex55663;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55660 === (6))){
var inst_55637 = (state_55659[(2)]);
var inst_55638 = fluree.db.util.async.throw_err(inst_55637);
var inst_55639 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_55638);
var inst_55640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55641 = [inst_55638];
var inst_55642 = (new cljs.core.PersistentVector(null,1,(5),inst_55640,inst_55641,null));
var inst_55643 = cljs.core.count(inst_55642);
var inst_55644 = ((9) + inst_55643);
var inst_55645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55646 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55648 = [inst_55638];
var inst_55649 = (new cljs.core.PersistentVector(null,1,(5),inst_55647,inst_55648,null));
var inst_55650 = ["<=",inst_55649,inst_55639];
var inst_55651 = cljs.core.PersistentHashMap.fromArrays(inst_55646,inst_55650);
var inst_55652 = [inst_55651,inst_55644];
var inst_55653 = (new cljs.core.PersistentVector(null,2,(5),inst_55645,inst_55652,null));
var inst_55654 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55653);
var _ = (function (){var statearr_55668 = state_55659;
(statearr_55668[(4)] = cljs.core.rest((state_55659[(4)])));

return statearr_55668;
})();
var state_55659__$1 = (function (){var statearr_55669 = state_55659;
(statearr_55669[(7)] = inst_55654);

return statearr_55669;
})();
var statearr_55670_55683 = state_55659__$1;
(statearr_55670_55683[(2)] = inst_55639);

(statearr_55670_55683[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55671 = [null,null,null,null,null,null,null,null];
(statearr_55671[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55671[(1)] = (1));

return statearr_55671;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55659){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55659);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55672){var ex__2730__auto__ = e55672;
var statearr_55673_55684 = state_55659;
(statearr_55673_55684[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55659[(4)]))){
var statearr_55674_55685 = state_55659;
(statearr_55674_55685[(1)] = cljs.core.first((state_55659[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55686 = state_55659;
state_55659 = G__55686;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55659){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55675 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55675[(6)] = c__2749__auto__);

return statearr_55675;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq55627){
var G__55628 = cljs.core.first(seq55627);
var seq55627__$1 = cljs.core.next(seq55627);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55628,seq55627__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55736 = arguments.length;
var i__5770__auto___55737 = (0);
while(true){
if((i__5770__auto___55737 < len__5769__auto___55736)){
args__5775__auto__.push((arguments[i__5770__auto___55737]));

var G__55738 = (i__5770__auto___55737 + (1));
i__5770__auto___55737 = G__55738;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55719){
var state_val_55720 = (state_55719[(1)]);
if((state_val_55720 === (1))){
var state_55719__$1 = state_55719;
var statearr_55721_55739 = state_55719__$1;
(statearr_55721_55739[(2)] = null);

(statearr_55721_55739[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55720 === (2))){
var _ = (function (){var statearr_55722 = state_55719;
(statearr_55722[(4)] = cljs.core.cons((5),(state_55719[(4)])));

return statearr_55722;
})();
var inst_55695 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55719__$1 = state_55719;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55719__$1,(6),inst_55695);
} else {
if((state_val_55720 === (3))){
var inst_55717 = (state_55719[(2)]);
var state_55719__$1 = state_55719;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55719__$1,inst_55717);
} else {
if((state_val_55720 === (4))){
var inst_55689 = (state_55719[(2)]);
var state_55719__$1 = state_55719;
var statearr_55724_55740 = state_55719__$1;
(statearr_55724_55740[(2)] = inst_55689);

(statearr_55724_55740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55720 === (5))){
var _ = (function (){var statearr_55725 = state_55719;
(statearr_55725[(4)] = cljs.core.rest((state_55719[(4)])));

return statearr_55725;
})();
var state_55719__$1 = state_55719;
var ex55723 = (state_55719__$1[(2)]);
var statearr_55726_55741 = state_55719__$1;
(statearr_55726_55741[(5)] = ex55723);


if((ex55723 instanceof Error)){
var statearr_55727_55742 = state_55719__$1;
(statearr_55727_55742[(1)] = (4));

(statearr_55727_55742[(5)] = null);

} else {
throw ex55723;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55720 === (6))){
var inst_55697 = (state_55719[(2)]);
var inst_55698 = fluree.db.util.async.throw_err(inst_55697);
var inst_55699 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_55698);
var inst_55700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55701 = [inst_55698];
var inst_55702 = (new cljs.core.PersistentVector(null,1,(5),inst_55700,inst_55701,null));
var inst_55703 = cljs.core.count(inst_55702);
var inst_55704 = ((9) + inst_55703);
var inst_55705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55706 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55708 = [inst_55698];
var inst_55709 = (new cljs.core.PersistentVector(null,1,(5),inst_55707,inst_55708,null));
var inst_55710 = [">=",inst_55709,inst_55699];
var inst_55711 = cljs.core.PersistentHashMap.fromArrays(inst_55706,inst_55710);
var inst_55712 = [inst_55711,inst_55704];
var inst_55713 = (new cljs.core.PersistentVector(null,2,(5),inst_55705,inst_55712,null));
var inst_55714 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55713);
var _ = (function (){var statearr_55728 = state_55719;
(statearr_55728[(4)] = cljs.core.rest((state_55719[(4)])));

return statearr_55728;
})();
var state_55719__$1 = (function (){var statearr_55729 = state_55719;
(statearr_55729[(7)] = inst_55714);

return statearr_55729;
})();
var statearr_55730_55743 = state_55719__$1;
(statearr_55730_55743[(2)] = inst_55699);

(statearr_55730_55743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55731 = [null,null,null,null,null,null,null,null];
(statearr_55731[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55731[(1)] = (1));

return statearr_55731;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55719){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55719);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55732){var ex__2730__auto__ = e55732;
var statearr_55733_55744 = state_55719;
(statearr_55733_55744[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55719[(4)]))){
var statearr_55734_55745 = state_55719;
(statearr_55734_55745[(1)] = cljs.core.first((state_55719[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55746 = state_55719;
state_55719 = G__55746;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55719){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55735 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55735[(6)] = c__2749__auto__);

return statearr_55735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq55687){
var G__55688 = cljs.core.first(seq55687);
var seq55687__$1 = cljs.core.next(seq55687);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55688,seq55687__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55796 = arguments.length;
var i__5770__auto___55797 = (0);
while(true){
if((i__5770__auto___55797 < len__5769__auto___55796)){
args__5775__auto__.push((arguments[i__5770__auto___55797]));

var G__55798 = (i__5770__auto___55797 + (1));
i__5770__auto___55797 = G__55798;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55779){
var state_val_55780 = (state_55779[(1)]);
if((state_val_55780 === (1))){
var state_55779__$1 = state_55779;
var statearr_55781_55799 = state_55779__$1;
(statearr_55781_55799[(2)] = null);

(statearr_55781_55799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (2))){
var _ = (function (){var statearr_55782 = state_55779;
(statearr_55782[(4)] = cljs.core.cons((5),(state_55779[(4)])));

return statearr_55782;
})();
var inst_55755 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55779__$1 = state_55779;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55779__$1,(6),inst_55755);
} else {
if((state_val_55780 === (3))){
var inst_55777 = (state_55779[(2)]);
var state_55779__$1 = state_55779;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55779__$1,inst_55777);
} else {
if((state_val_55780 === (4))){
var inst_55749 = (state_55779[(2)]);
var state_55779__$1 = state_55779;
var statearr_55784_55800 = state_55779__$1;
(statearr_55784_55800[(2)] = inst_55749);

(statearr_55784_55800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (5))){
var _ = (function (){var statearr_55785 = state_55779;
(statearr_55785[(4)] = cljs.core.rest((state_55779[(4)])));

return statearr_55785;
})();
var state_55779__$1 = state_55779;
var ex55783 = (state_55779__$1[(2)]);
var statearr_55786_55801 = state_55779__$1;
(statearr_55786_55801[(5)] = ex55783);


if((ex55783 instanceof Error)){
var statearr_55787_55802 = state_55779__$1;
(statearr_55787_55802[(1)] = (4));

(statearr_55787_55802[(5)] = null);

} else {
throw ex55783;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55780 === (6))){
var inst_55757 = (state_55779[(2)]);
var inst_55758 = fluree.db.util.async.throw_err(inst_55757);
var inst_55759 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_55758);
var inst_55760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55761 = [inst_55758];
var inst_55762 = (new cljs.core.PersistentVector(null,1,(5),inst_55760,inst_55761,null));
var inst_55763 = cljs.core.count(inst_55762);
var inst_55764 = ((9) + inst_55763);
var inst_55765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55766 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55768 = [inst_55758];
var inst_55769 = (new cljs.core.PersistentVector(null,1,(5),inst_55767,inst_55768,null));
var inst_55770 = ["not=",inst_55769,inst_55759];
var inst_55771 = cljs.core.PersistentHashMap.fromArrays(inst_55766,inst_55770);
var inst_55772 = [inst_55771,inst_55764];
var inst_55773 = (new cljs.core.PersistentVector(null,2,(5),inst_55765,inst_55772,null));
var inst_55774 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55773);
var _ = (function (){var statearr_55788 = state_55779;
(statearr_55788[(4)] = cljs.core.rest((state_55779[(4)])));

return statearr_55788;
})();
var state_55779__$1 = (function (){var statearr_55789 = state_55779;
(statearr_55789[(7)] = inst_55774);

return statearr_55789;
})();
var statearr_55790_55803 = state_55779__$1;
(statearr_55790_55803[(2)] = inst_55759);

(statearr_55790_55803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55791 = [null,null,null,null,null,null,null,null];
(statearr_55791[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55791[(1)] = (1));

return statearr_55791;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55779){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55779);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55792){var ex__2730__auto__ = e55792;
var statearr_55793_55804 = state_55779;
(statearr_55793_55804[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55779[(4)]))){
var statearr_55794_55805 = state_55779;
(statearr_55794_55805[(1)] = cljs.core.first((state_55779[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55806 = state_55779;
state_55779 = G__55806;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55779){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55795 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55795[(6)] = c__2749__auto__);

return statearr_55795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq55747){
var G__55748 = cljs.core.first(seq55747);
var seq55747__$1 = cljs.core.next(seq55747);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55748,seq55747__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55856 = arguments.length;
var i__5770__auto___55857 = (0);
while(true){
if((i__5770__auto___55857 < len__5769__auto___55856)){
args__5775__auto__.push((arguments[i__5770__auto___55857]));

var G__55858 = (i__5770__auto___55857 + (1));
i__5770__auto___55857 = G__55858;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55839){
var state_val_55840 = (state_55839[(1)]);
if((state_val_55840 === (1))){
var state_55839__$1 = state_55839;
var statearr_55841_55859 = state_55839__$1;
(statearr_55841_55859[(2)] = null);

(statearr_55841_55859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55840 === (2))){
var _ = (function (){var statearr_55842 = state_55839;
(statearr_55842[(4)] = cljs.core.cons((5),(state_55839[(4)])));

return statearr_55842;
})();
var inst_55815 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55839__$1 = state_55839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55839__$1,(6),inst_55815);
} else {
if((state_val_55840 === (3))){
var inst_55837 = (state_55839[(2)]);
var state_55839__$1 = state_55839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55839__$1,inst_55837);
} else {
if((state_val_55840 === (4))){
var inst_55809 = (state_55839[(2)]);
var state_55839__$1 = state_55839;
var statearr_55844_55860 = state_55839__$1;
(statearr_55844_55860[(2)] = inst_55809);

(statearr_55844_55860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55840 === (5))){
var _ = (function (){var statearr_55845 = state_55839;
(statearr_55845[(4)] = cljs.core.rest((state_55839[(4)])));

return statearr_55845;
})();
var state_55839__$1 = state_55839;
var ex55843 = (state_55839__$1[(2)]);
var statearr_55846_55861 = state_55839__$1;
(statearr_55846_55861[(5)] = ex55843);


if((ex55843 instanceof Error)){
var statearr_55847_55862 = state_55839__$1;
(statearr_55847_55862[(1)] = (4));

(statearr_55847_55862[(5)] = null);

} else {
throw ex55843;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55840 === (6))){
var inst_55817 = (state_55839[(2)]);
var inst_55818 = fluree.db.util.async.throw_err(inst_55817);
var inst_55819 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_55818);
var inst_55820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55821 = [inst_55818];
var inst_55822 = (new cljs.core.PersistentVector(null,1,(5),inst_55820,inst_55821,null));
var inst_55823 = cljs.core.count(inst_55822);
var inst_55824 = ((9) + inst_55823);
var inst_55825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55826 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55828 = [inst_55818];
var inst_55829 = (new cljs.core.PersistentVector(null,1,(5),inst_55827,inst_55828,null));
var inst_55830 = ["max",inst_55829,inst_55819];
var inst_55831 = cljs.core.PersistentHashMap.fromArrays(inst_55826,inst_55830);
var inst_55832 = [inst_55831,inst_55824];
var inst_55833 = (new cljs.core.PersistentVector(null,2,(5),inst_55825,inst_55832,null));
var inst_55834 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55833);
var _ = (function (){var statearr_55848 = state_55839;
(statearr_55848[(4)] = cljs.core.rest((state_55839[(4)])));

return statearr_55848;
})();
var state_55839__$1 = (function (){var statearr_55849 = state_55839;
(statearr_55849[(7)] = inst_55834);

return statearr_55849;
})();
var statearr_55850_55863 = state_55839__$1;
(statearr_55850_55863[(2)] = inst_55819);

(statearr_55850_55863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55851 = [null,null,null,null,null,null,null,null];
(statearr_55851[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55851[(1)] = (1));

return statearr_55851;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55839){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55839);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55852){var ex__2730__auto__ = e55852;
var statearr_55853_55864 = state_55839;
(statearr_55853_55864[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55839[(4)]))){
var statearr_55854_55865 = state_55839;
(statearr_55854_55865[(1)] = cljs.core.first((state_55839[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55866 = state_55839;
state_55839 = G__55866;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55839){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55855 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55855[(6)] = c__2749__auto__);

return statearr_55855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq55807){
var G__55808 = cljs.core.first(seq55807);
var seq55807__$1 = cljs.core.next(seq55807);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55808,seq55807__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__5775__auto__ = [];
var len__5769__auto___55916 = arguments.length;
var i__5770__auto___55917 = (0);
while(true){
if((i__5770__auto___55917 < len__5769__auto___55916)){
args__5775__auto__.push((arguments[i__5770__auto___55917]));

var G__55918 = (i__5770__auto___55917 + (1));
i__5770__auto___55917 = G__55918;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55899){
var state_val_55900 = (state_55899[(1)]);
if((state_val_55900 === (1))){
var state_55899__$1 = state_55899;
var statearr_55901_55919 = state_55899__$1;
(statearr_55901_55919[(2)] = null);

(statearr_55901_55919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55900 === (2))){
var _ = (function (){var statearr_55902 = state_55899;
(statearr_55902[(4)] = cljs.core.cons((5),(state_55899[(4)])));

return statearr_55902;
})();
var inst_55875 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_55899__$1 = state_55899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55899__$1,(6),inst_55875);
} else {
if((state_val_55900 === (3))){
var inst_55897 = (state_55899[(2)]);
var state_55899__$1 = state_55899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55899__$1,inst_55897);
} else {
if((state_val_55900 === (4))){
var inst_55869 = (state_55899[(2)]);
var state_55899__$1 = state_55899;
var statearr_55904_55920 = state_55899__$1;
(statearr_55904_55920[(2)] = inst_55869);

(statearr_55904_55920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55900 === (5))){
var _ = (function (){var statearr_55905 = state_55899;
(statearr_55905[(4)] = cljs.core.rest((state_55899[(4)])));

return statearr_55905;
})();
var state_55899__$1 = state_55899;
var ex55903 = (state_55899__$1[(2)]);
var statearr_55906_55921 = state_55899__$1;
(statearr_55906_55921[(5)] = ex55903);


if((ex55903 instanceof Error)){
var statearr_55907_55922 = state_55899__$1;
(statearr_55907_55922[(1)] = (4));

(statearr_55907_55922[(5)] = null);

} else {
throw ex55903;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55900 === (6))){
var inst_55877 = (state_55899[(2)]);
var inst_55878 = fluree.db.util.async.throw_err(inst_55877);
var inst_55879 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_55878);
var inst_55880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55881 = [inst_55878];
var inst_55882 = (new cljs.core.PersistentVector(null,1,(5),inst_55880,inst_55881,null));
var inst_55883 = cljs.core.count(inst_55882);
var inst_55884 = ((9) + inst_55883);
var inst_55885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55886 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55888 = [inst_55878];
var inst_55889 = (new cljs.core.PersistentVector(null,1,(5),inst_55887,inst_55888,null));
var inst_55890 = ["min",inst_55889,inst_55879];
var inst_55891 = cljs.core.PersistentHashMap.fromArrays(inst_55886,inst_55890);
var inst_55892 = [inst_55891,inst_55884];
var inst_55893 = (new cljs.core.PersistentVector(null,2,(5),inst_55885,inst_55892,null));
var inst_55894 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55893);
var _ = (function (){var statearr_55908 = state_55899;
(statearr_55908[(4)] = cljs.core.rest((state_55899[(4)])));

return statearr_55908;
})();
var state_55899__$1 = (function (){var statearr_55909 = state_55899;
(statearr_55909[(7)] = inst_55894);

return statearr_55909;
})();
var statearr_55910_55923 = state_55899__$1;
(statearr_55910_55923[(2)] = inst_55879);

(statearr_55910_55923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55911 = [null,null,null,null,null,null,null,null];
(statearr_55911[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55911[(1)] = (1));

return statearr_55911;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55899){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55899);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55912){var ex__2730__auto__ = e55912;
var statearr_55913_55924 = state_55899;
(statearr_55913_55924[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55899[(4)]))){
var statearr_55914_55925 = state_55899;
(statearr_55914_55925[(1)] = cljs.core.first((state_55899[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55926 = state_55899;
state_55899 = G__55926;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55899){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55915 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55915[(6)] = c__2749__auto__);

return statearr_55915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq55867){
var G__55868 = cljs.core.first(seq55867);
var seq55867__$1 = cljs.core.next(seq55867);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55868,seq55867__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__55928 = arguments.length;
switch (G__55928) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_55973){
var state_val_55974 = (state_55973[(1)]);
if((state_val_55974 === (7))){
var state_55973__$1 = state_55973;
var statearr_55975_56112 = state_55973__$1;
(statearr_55975_56112[(2)] = query_map);

(statearr_55975_56112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (1))){
var state_55973__$1 = state_55973;
var statearr_55976_56113 = state_55973__$1;
(statearr_55976_56113[(2)] = null);

(statearr_55976_56113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (4))){
var inst_55929 = (state_55973[(2)]);
var state_55973__$1 = state_55973;
var statearr_55977_56114 = state_55973__$1;
(statearr_55977_56114[(2)] = inst_55929);

(statearr_55977_56114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (13))){
var inst_55951 = (state_55973[(7)]);
var inst_55955 = (state_55973[(2)]);
var inst_55956 = fluree.db.util.async.throw_err(inst_55955);
var inst_55957 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55956,(0),null);
var inst_55958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_55956,(1),null);
var inst_55959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55960 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55962 = [inst_55951];
var inst_55963 = (new cljs.core.PersistentVector(null,1,(5),inst_55961,inst_55962,null));
var inst_55964 = ["query",inst_55963,inst_55957];
var inst_55965 = cljs.core.PersistentHashMap.fromArrays(inst_55960,inst_55964);
var inst_55966 = [inst_55965,inst_55958];
var inst_55967 = (new cljs.core.PersistentVector(null,2,(5),inst_55959,inst_55966,null));
var inst_55968 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_55967);
var _ = (function (){var statearr_55978 = state_55973;
(statearr_55978[(4)] = cljs.core.rest((state_55973[(4)])));

return statearr_55978;
})();
var state_55973__$1 = (function (){var statearr_55979 = state_55973;
(statearr_55979[(8)] = inst_55968);

return statearr_55979;
})();
var statearr_55980_56115 = state_55973__$1;
(statearr_55980_56115[(2)] = inst_55957);

(statearr_55980_56115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (6))){
var state_55973__$1 = state_55973;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55973__$1,(9),query_map);
} else {
if((state_val_55974 === (3))){
var inst_55971 = (state_55973[(2)]);
var state_55973__$1 = state_55973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_55973__$1,inst_55971);
} else {
if((state_val_55974 === (12))){
var inst_55951 = (state_55973[(7)]);
var inst_55951__$1 = (state_55973[(2)]);
var inst_55952 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_55953 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_55952,inst_55951__$1);
var state_55973__$1 = (function (){var statearr_55981 = state_55973;
(statearr_55981[(7)] = inst_55951__$1);

return statearr_55981;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_55973__$1,(13),inst_55953);
} else {
if((state_val_55974 === (2))){
var _ = (function (){var statearr_55982 = state_55973;
(statearr_55982[(4)] = cljs.core.cons((5),(state_55973[(4)])));

return statearr_55982;
})();
var inst_55938 = fluree.db.util.async.channel_QMARK_(query_map);
var state_55973__$1 = state_55973;
if(inst_55938){
var statearr_55983_56116 = state_55973__$1;
(statearr_55983_56116[(1)] = (6));

} else {
var statearr_55984_56117 = state_55973__$1;
(statearr_55984_56117[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (11))){
var inst_55945 = (state_55973[(9)]);
var state_55973__$1 = state_55973;
var statearr_55986_56118 = state_55973__$1;
(statearr_55986_56118[(2)] = inst_55945);

(statearr_55986_56118[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (9))){
var inst_55941 = (state_55973[(2)]);
var inst_55942 = fluree.db.util.async.throw_err(inst_55941);
var state_55973__$1 = state_55973;
var statearr_55987_56119 = state_55973__$1;
(statearr_55987_56119[(2)] = inst_55942);

(statearr_55987_56119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (5))){
var _ = (function (){var statearr_55988 = state_55973;
(statearr_55988[(4)] = cljs.core.rest((state_55973[(4)])));

return statearr_55988;
})();
var state_55973__$1 = state_55973;
var ex55985 = (state_55973__$1[(2)]);
var statearr_55989_56120 = state_55973__$1;
(statearr_55989_56120[(5)] = ex55985);


if((ex55985 instanceof Error)){
var statearr_55990_56121 = state_55973__$1;
(statearr_55990_56121[(1)] = (4));

(statearr_55990_56121[(5)] = null);

} else {
throw ex55985;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (10))){
var inst_55945 = (state_55973[(9)]);
var inst_55948 = fluree.db.util.json.parse(inst_55945);
var state_55973__$1 = state_55973;
var statearr_55991_56122 = state_55973__$1;
(statearr_55991_56122[(2)] = inst_55948);

(statearr_55991_56122[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55974 === (8))){
var inst_55945 = (state_55973[(9)]);
var inst_55945__$1 = (state_55973[(2)]);
var inst_55946 = typeof inst_55945__$1 === 'string';
var state_55973__$1 = (function (){var statearr_55992 = state_55973;
(statearr_55992[(9)] = inst_55945__$1);

return statearr_55992;
})();
if(cljs.core.truth_(inst_55946)){
var statearr_55993_56123 = state_55973__$1;
(statearr_55993_56123[(1)] = (10));

} else {
var statearr_55994_56124 = state_55973__$1;
(statearr_55994_56124[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_55995 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55995[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_55995[(1)] = (1));

return statearr_55995;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_55973){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_55973);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e55996){var ex__2730__auto__ = e55996;
var statearr_55997_56125 = state_55973;
(statearr_55997_56125[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_55973[(4)]))){
var statearr_55998_56126 = state_55973;
(statearr_55998_56126[(1)] = cljs.core.first((state_55973[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56127 = state_55973;
state_55973 = G__56127;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_55973){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_55973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_55999 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_55999[(6)] = c__2749__auto__);

return statearr_55999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56070){
var state_val_56071 = (state_56070[(1)]);
if((state_val_56071 === (7))){
var state_56070__$1 = state_56070;
var statearr_56072_56128 = state_56070__$1;
(statearr_56072_56128[(2)] = select);

(statearr_56072_56128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (20))){
var inst_56040 = (state_56070[(2)]);
var inst_56041 = fluree.db.util.async.channel_QMARK_(limit);
var state_56070__$1 = (function (){var statearr_56073 = state_56070;
(statearr_56073[(7)] = inst_56040);

return statearr_56073;
})();
if(inst_56041){
var statearr_56074_56129 = state_56070__$1;
(statearr_56074_56129[(1)] = (22));

} else {
var statearr_56075_56130 = state_56070__$1;
(statearr_56075_56130[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (1))){
var state_56070__$1 = state_56070;
var statearr_56076_56131 = state_56070__$1;
(statearr_56076_56131[(2)] = null);

(statearr_56076_56131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (24))){
var inst_56024 = (state_56070[(8)]);
var inst_56016 = (state_56070[(9)]);
var inst_56032 = (state_56070[(10)]);
var inst_56040 = (state_56070[(7)]);
var inst_56048 = (state_56070[(2)]);
var inst_56049 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56050 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_56049,inst_56016,inst_56024,inst_56032,inst_56040,inst_56048);
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56070__$1,(26),inst_56050);
} else {
if((state_val_56071 === (4))){
var inst_56000 = (state_56070[(2)]);
var state_56070__$1 = state_56070;
var statearr_56077_56132 = state_56070__$1;
(statearr_56077_56132[(2)] = inst_56000);

(statearr_56077_56132[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (15))){
var state_56070__$1 = state_56070;
var statearr_56078_56133 = state_56070__$1;
(statearr_56078_56133[(2)] = where);

(statearr_56078_56133[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (21))){
var inst_56036 = (state_56070[(2)]);
var inst_56037 = fluree.db.util.async.throw_err(inst_56036);
var state_56070__$1 = state_56070;
var statearr_56079_56134 = state_56070__$1;
(statearr_56079_56134[(2)] = inst_56037);

(statearr_56079_56134[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (13))){
var inst_56020 = (state_56070[(2)]);
var inst_56021 = fluree.db.util.async.throw_err(inst_56020);
var state_56070__$1 = state_56070;
var statearr_56080_56135 = state_56070__$1;
(statearr_56080_56135[(2)] = inst_56021);

(statearr_56080_56135[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (22))){
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56070__$1,(25),limit);
} else {
if((state_val_56071 === (6))){
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56070__$1,(9),select);
} else {
if((state_val_56071 === (25))){
var inst_56044 = (state_56070[(2)]);
var inst_56045 = fluree.db.util.async.throw_err(inst_56044);
var state_56070__$1 = state_56070;
var statearr_56081_56136 = state_56070__$1;
(statearr_56081_56136[(2)] = inst_56045);

(statearr_56081_56136[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (17))){
var inst_56028 = (state_56070[(2)]);
var inst_56029 = fluree.db.util.async.throw_err(inst_56028);
var state_56070__$1 = state_56070;
var statearr_56082_56137 = state_56070__$1;
(statearr_56082_56137[(2)] = inst_56029);

(statearr_56082_56137[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (3))){
var inst_56068 = (state_56070[(2)]);
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56070__$1,inst_56068);
} else {
if((state_val_56071 === (12))){
var inst_56024 = (state_56070[(2)]);
var inst_56025 = fluree.db.util.async.channel_QMARK_(where);
var state_56070__$1 = (function (){var statearr_56083 = state_56070;
(statearr_56083[(8)] = inst_56024);

return statearr_56083;
})();
if(inst_56025){
var statearr_56084_56138 = state_56070__$1;
(statearr_56084_56138[(1)] = (14));

} else {
var statearr_56085_56139 = state_56070__$1;
(statearr_56085_56139[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (2))){
var _ = (function (){var statearr_56086 = state_56070;
(statearr_56086[(4)] = cljs.core.cons((5),(state_56070[(4)])));

return statearr_56086;
})();
var inst_56009 = fluree.db.util.async.channel_QMARK_(select);
var state_56070__$1 = state_56070;
if(inst_56009){
var statearr_56087_56140 = state_56070__$1;
(statearr_56087_56140[(1)] = (6));

} else {
var statearr_56088_56141 = state_56070__$1;
(statearr_56088_56141[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (23))){
var state_56070__$1 = state_56070;
var statearr_56089_56142 = state_56070__$1;
(statearr_56089_56142[(2)] = limit);

(statearr_56089_56142[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (19))){
var state_56070__$1 = state_56070;
var statearr_56090_56143 = state_56070__$1;
(statearr_56090_56143[(2)] = block);

(statearr_56090_56143[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (11))){
var state_56070__$1 = state_56070;
var statearr_56092_56144 = state_56070__$1;
(statearr_56092_56144[(2)] = from);

(statearr_56092_56144[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (9))){
var inst_56012 = (state_56070[(2)]);
var inst_56013 = fluree.db.util.async.throw_err(inst_56012);
var state_56070__$1 = state_56070;
var statearr_56093_56145 = state_56070__$1;
(statearr_56093_56145[(2)] = inst_56013);

(statearr_56093_56145[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (5))){
var _ = (function (){var statearr_56094 = state_56070;
(statearr_56094[(4)] = cljs.core.rest((state_56070[(4)])));

return statearr_56094;
})();
var state_56070__$1 = state_56070;
var ex56091 = (state_56070__$1[(2)]);
var statearr_56095_56146 = state_56070__$1;
(statearr_56095_56146[(5)] = ex56091);


if((ex56091 instanceof Error)){
var statearr_56096_56147 = state_56070__$1;
(statearr_56096_56147[(1)] = (4));

(statearr_56096_56147[(5)] = null);

} else {
throw ex56091;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (14))){
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56070__$1,(17),where);
} else {
if((state_val_56071 === (26))){
var inst_56024 = (state_56070[(8)]);
var inst_56016 = (state_56070[(9)]);
var inst_56032 = (state_56070[(10)]);
var inst_56040 = (state_56070[(7)]);
var inst_56052 = (state_56070[(2)]);
var inst_56053 = fluree.db.util.async.throw_err(inst_56052);
var inst_56054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56053,(0),null);
var inst_56055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56053,(1),null);
var inst_56056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56057 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56059 = [inst_56016,inst_56024,inst_56032,inst_56040];
var inst_56060 = (new cljs.core.PersistentVector(null,4,(5),inst_56058,inst_56059,null));
var inst_56061 = ["query",inst_56060,inst_56054];
var inst_56062 = cljs.core.PersistentHashMap.fromArrays(inst_56057,inst_56061);
var inst_56063 = [inst_56062,inst_56055];
var inst_56064 = (new cljs.core.PersistentVector(null,2,(5),inst_56056,inst_56063,null));
var inst_56065 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56064);
var _ = (function (){var statearr_56097 = state_56070;
(statearr_56097[(4)] = cljs.core.rest((state_56070[(4)])));

return statearr_56097;
})();
var state_56070__$1 = (function (){var statearr_56098 = state_56070;
(statearr_56098[(11)] = inst_56065);

return statearr_56098;
})();
var statearr_56099_56148 = state_56070__$1;
(statearr_56099_56148[(2)] = inst_56054);

(statearr_56099_56148[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (16))){
var inst_56032 = (state_56070[(2)]);
var inst_56033 = fluree.db.util.async.channel_QMARK_(block);
var state_56070__$1 = (function (){var statearr_56100 = state_56070;
(statearr_56100[(10)] = inst_56032);

return statearr_56100;
})();
if(inst_56033){
var statearr_56101_56149 = state_56070__$1;
(statearr_56101_56149[(1)] = (18));

} else {
var statearr_56102_56150 = state_56070__$1;
(statearr_56102_56150[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56071 === (10))){
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56070__$1,(13),from);
} else {
if((state_val_56071 === (18))){
var state_56070__$1 = state_56070;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56070__$1,(21),block);
} else {
if((state_val_56071 === (8))){
var inst_56016 = (state_56070[(2)]);
var inst_56017 = fluree.db.util.async.channel_QMARK_(from);
var state_56070__$1 = (function (){var statearr_56103 = state_56070;
(statearr_56103[(9)] = inst_56016);

return statearr_56103;
})();
if(inst_56017){
var statearr_56104_56151 = state_56070__$1;
(statearr_56104_56151[(1)] = (10));

} else {
var statearr_56105_56152 = state_56070__$1;
(statearr_56105_56152[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56106 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56106[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56106[(1)] = (1));

return statearr_56106;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56070){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56070);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56107){var ex__2730__auto__ = e56107;
var statearr_56108_56153 = state_56070;
(statearr_56108_56153[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56070[(4)]))){
var statearr_56109_56154 = state_56070;
(statearr_56109_56154[(1)] = cljs.core.first((state_56070[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56155 = state_56070;
state_56070 = G__56155;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56070){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56070);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56110 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56110[(6)] = c__2749__auto__);

return statearr_56110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56211){
var state_val_56212 = (state_56211[(1)]);
if((state_val_56212 === (7))){
var state_56211__$1 = state_56211;
var statearr_56213_56244 = state_56211__$1;
(statearr_56213_56244[(2)] = startSubject);

(statearr_56213_56244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (1))){
var state_56211__$1 = state_56211;
var statearr_56214_56245 = state_56211__$1;
(statearr_56214_56245[(2)] = null);

(statearr_56214_56245[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (4))){
var inst_56156 = (state_56211[(2)]);
var state_56211__$1 = state_56211;
var statearr_56215_56246 = state_56211__$1;
(statearr_56215_56246[(2)] = inst_56156);

(statearr_56215_56246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (15))){
var inst_56188 = (state_56211[(2)]);
var inst_56189 = fluree.db.util.async.throw_err(inst_56188);
var inst_56190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56189,(0),null);
var inst_56191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56189,(1),null);
var inst_56192 = cljs.core.empty_QMARK_(inst_56190);
var state_56211__$1 = (function (){var statearr_56216 = state_56211;
(statearr_56216[(7)] = inst_56191);

return statearr_56216;
})();
if(inst_56192){
var statearr_56217_56247 = state_56211__$1;
(statearr_56217_56247[(1)] = (16));

} else {
var statearr_56218_56248 = state_56211__$1;
(statearr_56218_56248[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (13))){
var inst_56172 = (state_56211[(8)]);
var inst_56184 = (state_56211[(9)]);
var inst_56176 = (state_56211[(10)]);
var inst_56184__$1 = (state_56211[(2)]);
var inst_56185 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56186 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_56185,inst_56172,inst_56176,inst_56184__$1);
var state_56211__$1 = (function (){var statearr_56219 = state_56211;
(statearr_56219[(9)] = inst_56184__$1);

return statearr_56219;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56211__$1,(15),inst_56186);
} else {
if((state_val_56212 === (6))){
var state_56211__$1 = state_56211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56211__$1,(9),startSubject);
} else {
if((state_val_56212 === (17))){
var state_56211__$1 = state_56211;
var statearr_56220_56249 = state_56211__$1;
(statearr_56220_56249[(2)] = true);

(statearr_56220_56249[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (3))){
var inst_56209 = (state_56211[(2)]);
var state_56211__$1 = state_56211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56211__$1,inst_56209);
} else {
if((state_val_56212 === (12))){
var state_56211__$1 = state_56211;
var statearr_56221_56250 = state_56211__$1;
(statearr_56221_56250[(2)] = endSubject);

(statearr_56221_56250[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (2))){
var _ = (function (){var statearr_56222 = state_56211;
(statearr_56222[(4)] = cljs.core.cons((5),(state_56211[(4)])));

return statearr_56222;
})();
var inst_56165 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_56211__$1 = state_56211;
if(inst_56165){
var statearr_56223_56251 = state_56211__$1;
(statearr_56223_56251[(1)] = (6));

} else {
var statearr_56224_56252 = state_56211__$1;
(statearr_56224_56252[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (11))){
var state_56211__$1 = state_56211;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56211__$1,(14),endSubject);
} else {
if((state_val_56212 === (9))){
var inst_56168 = (state_56211[(2)]);
var inst_56169 = fluree.db.util.async.throw_err(inst_56168);
var state_56211__$1 = state_56211;
var statearr_56226_56253 = state_56211__$1;
(statearr_56226_56253[(2)] = inst_56169);

(statearr_56226_56253[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (5))){
var _ = (function (){var statearr_56227 = state_56211;
(statearr_56227[(4)] = cljs.core.rest((state_56211[(4)])));

return statearr_56227;
})();
var state_56211__$1 = state_56211;
var ex56225 = (state_56211__$1[(2)]);
var statearr_56228_56254 = state_56211__$1;
(statearr_56228_56254[(5)] = ex56225);


if((ex56225 instanceof Error)){
var statearr_56229_56255 = state_56211__$1;
(statearr_56229_56255[(1)] = (4));

(statearr_56229_56255[(5)] = null);

} else {
throw ex56225;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (14))){
var inst_56180 = (state_56211[(2)]);
var inst_56181 = fluree.db.util.async.throw_err(inst_56180);
var state_56211__$1 = state_56211;
var statearr_56230_56256 = state_56211__$1;
(statearr_56230_56256[(2)] = inst_56181);

(statearr_56230_56256[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (16))){
var state_56211__$1 = state_56211;
var statearr_56231_56257 = state_56211__$1;
(statearr_56231_56257[(2)] = false);

(statearr_56231_56257[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (10))){
var inst_56175 = (state_56211[(2)]);
var inst_56176 = fluree.db.util.async.throw_err(inst_56175);
var inst_56177 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_56211__$1 = (function (){var statearr_56232 = state_56211;
(statearr_56232[(10)] = inst_56176);

return statearr_56232;
})();
if(inst_56177){
var statearr_56233_56258 = state_56211__$1;
(statearr_56233_56258[(1)] = (11));

} else {
var statearr_56234_56259 = state_56211__$1;
(statearr_56234_56259[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (18))){
var inst_56172 = (state_56211[(8)]);
var inst_56184 = (state_56211[(9)]);
var inst_56191 = (state_56211[(7)]);
var inst_56176 = (state_56211[(10)]);
var inst_56196 = (state_56211[(2)]);
var inst_56197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56198 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56200 = [inst_56172,inst_56176,inst_56184];
var inst_56201 = (new cljs.core.PersistentVector(null,3,(5),inst_56199,inst_56200,null));
var inst_56202 = ["relationship?",inst_56201,inst_56196];
var inst_56203 = cljs.core.PersistentHashMap.fromArrays(inst_56198,inst_56202);
var inst_56204 = [inst_56203,inst_56191];
var inst_56205 = (new cljs.core.PersistentVector(null,2,(5),inst_56197,inst_56204,null));
var inst_56206 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56205);
var _ = (function (){var statearr_56235 = state_56211;
(statearr_56235[(4)] = cljs.core.rest((state_56211[(4)])));

return statearr_56235;
})();
var state_56211__$1 = (function (){var statearr_56236 = state_56211;
(statearr_56236[(11)] = inst_56206);

return statearr_56236;
})();
var statearr_56237_56260 = state_56211__$1;
(statearr_56237_56260[(2)] = inst_56196);

(statearr_56237_56260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56212 === (8))){
var inst_56172 = (state_56211[(2)]);
var inst_56173 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_56211__$1 = (function (){var statearr_56238 = state_56211;
(statearr_56238[(8)] = inst_56172);

return statearr_56238;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56211__$1,(10),inst_56173);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_56239 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56239[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__);

(statearr_56239[(1)] = (1));

return statearr_56239;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1 = (function (state_56211){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56211);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56240){var ex__2730__auto__ = e56240;
var statearr_56241_56261 = state_56211;
(statearr_56241_56261[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56211[(4)]))){
var statearr_56242_56262 = state_56211;
(statearr_56242_56262[(1)] = cljs.core.first((state_56211[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56263 = state_56211;
state_56211 = G__56263;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__ = function(state_56211){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1.call(this,state_56211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56243 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56243[(6)] = c__2749__auto__);

return statearr_56243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56300){
var state_val_56301 = (state_56300[(1)]);
if((state_val_56301 === (7))){
var state_56300__$1 = state_56300;
var statearr_56302_56322 = state_56300__$1;
(statearr_56302_56322[(2)] = pred_name);

(statearr_56302_56322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (1))){
var state_56300__$1 = state_56300;
var statearr_56303_56323 = state_56300__$1;
(statearr_56303_56323[(2)] = null);

(statearr_56303_56323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (4))){
var inst_56264 = (state_56300[(2)]);
var state_56300__$1 = state_56300;
var statearr_56304_56324 = state_56300__$1;
(statearr_56304_56324[(2)] = inst_56264);

(statearr_56304_56324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (6))){
var state_56300__$1 = state_56300;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56300__$1,(9),pred_name);
} else {
if((state_val_56301 === (3))){
var inst_56298 = (state_56300[(2)]);
var state_56300__$1 = state_56300;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56300__$1,inst_56298);
} else {
if((state_val_56301 === (2))){
var _ = (function (){var statearr_56306 = state_56300;
(statearr_56306[(4)] = cljs.core.cons((5),(state_56300[(4)])));

return statearr_56306;
})();
var inst_56273 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_56300__$1 = state_56300;
if(inst_56273){
var statearr_56307_56325 = state_56300__$1;
(statearr_56307_56325[(1)] = (6));

} else {
var statearr_56308_56326 = state_56300__$1;
(statearr_56308_56326[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (9))){
var inst_56276 = (state_56300[(2)]);
var inst_56277 = fluree.db.util.async.throw_err(inst_56276);
var state_56300__$1 = state_56300;
var statearr_56309_56327 = state_56300__$1;
(statearr_56309_56327[(2)] = inst_56277);

(statearr_56309_56327[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (5))){
var _ = (function (){var statearr_56310 = state_56300;
(statearr_56310[(4)] = cljs.core.rest((state_56300[(4)])));

return statearr_56310;
})();
var state_56300__$1 = state_56300;
var ex56305 = (state_56300__$1[(2)]);
var statearr_56311_56328 = state_56300__$1;
(statearr_56311_56328[(5)] = ex56305);


if((ex56305 instanceof Error)){
var statearr_56312_56329 = state_56300__$1;
(statearr_56312_56329[(1)] = (4));

(statearr_56312_56329[(5)] = null);

} else {
throw ex56305;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (10))){
var inst_56280 = (state_56300[(7)]);
var inst_56284 = (state_56300[(2)]);
var inst_56285 = fluree.db.util.async.throw_err(inst_56284);
var inst_56286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56285,(0),null);
var inst_56287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56285,(1),null);
var inst_56288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56289 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56290 = ["max-pred-val",inst_56280,inst_56286];
var inst_56291 = cljs.core.PersistentHashMap.fromArrays(inst_56289,inst_56290);
var inst_56292 = (inst_56287 + (10));
var inst_56293 = [inst_56291,inst_56292];
var inst_56294 = (new cljs.core.PersistentVector(null,2,(5),inst_56288,inst_56293,null));
var inst_56295 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56294);
var _ = (function (){var statearr_56313 = state_56300;
(statearr_56313[(4)] = cljs.core.rest((state_56300[(4)])));

return statearr_56313;
})();
var state_56300__$1 = (function (){var statearr_56314 = state_56300;
(statearr_56314[(8)] = inst_56295);

return statearr_56314;
})();
var statearr_56315_56330 = state_56300__$1;
(statearr_56315_56330[(2)] = inst_56286);

(statearr_56315_56330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56301 === (8))){
var inst_56280 = (state_56300[(7)]);
var inst_56280__$1 = (state_56300[(2)]);
var inst_56281 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56282 = fluree.db.dbfunctions.internal.max_pred_val(inst_56281,inst_56280__$1,null);
var state_56300__$1 = (function (){var statearr_56316 = state_56300;
(statearr_56316[(7)] = inst_56280__$1);

return statearr_56316;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56300__$1,(10),inst_56282);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0 = (function (){
var statearr_56317 = [null,null,null,null,null,null,null,null,null];
(statearr_56317[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__);

(statearr_56317[(1)] = (1));

return statearr_56317;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1 = (function (state_56300){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56300);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56318){var ex__2730__auto__ = e56318;
var statearr_56319_56331 = state_56300;
(statearr_56319_56331[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56300[(4)]))){
var statearr_56320_56332 = state_56300;
(statearr_56320_56332[(1)] = cljs.core.first((state_56300[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56333 = state_56300;
state_56300 = G__56333;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__ = function(state_56300){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1.call(this,state_56300);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56321 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56321[(6)] = c__2749__auto__);

return statearr_56321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56360){
var state_val_56361 = (state_56360[(1)]);
if((state_val_56361 === (7))){
var state_56360__$1 = state_56360;
var statearr_56362_56381 = state_56360__$1;
(statearr_56362_56381[(2)] = n);

(statearr_56362_56381[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56361 === (1))){
var state_56360__$1 = state_56360;
var statearr_56363_56382 = state_56360__$1;
(statearr_56363_56382[(2)] = null);

(statearr_56363_56382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56361 === (4))){
var inst_56334 = (state_56360[(2)]);
var state_56360__$1 = state_56360;
var statearr_56364_56383 = state_56360__$1;
(statearr_56364_56383[(2)] = inst_56334);

(statearr_56364_56383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56361 === (6))){
var state_56360__$1 = state_56360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56360__$1,(9),n);
} else {
if((state_val_56361 === (3))){
var inst_56358 = (state_56360[(2)]);
var state_56360__$1 = state_56360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56360__$1,inst_56358);
} else {
if((state_val_56361 === (2))){
var _ = (function (){var statearr_56366 = state_56360;
(statearr_56366[(4)] = cljs.core.cons((5),(state_56360[(4)])));

return statearr_56366;
})();
var inst_56340 = fluree.db.util.async.channel_QMARK_(n);
var state_56360__$1 = state_56360;
if(inst_56340){
var statearr_56367_56384 = state_56360__$1;
(statearr_56367_56384[(1)] = (6));

} else {
var statearr_56368_56385 = state_56360__$1;
(statearr_56368_56385[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56361 === (9))){
var inst_56343 = (state_56360[(2)]);
var inst_56344 = fluree.db.util.async.throw_err(inst_56343);
var state_56360__$1 = state_56360;
var statearr_56369_56386 = state_56360__$1;
(statearr_56369_56386[(2)] = inst_56344);

(statearr_56369_56386[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56361 === (5))){
var _ = (function (){var statearr_56370 = state_56360;
(statearr_56370[(4)] = cljs.core.rest((state_56360[(4)])));

return statearr_56370;
})();
var state_56360__$1 = state_56360;
var ex56365 = (state_56360__$1[(2)]);
var statearr_56371_56387 = state_56360__$1;
(statearr_56371_56387[(5)] = ex56365);


if((ex56365 instanceof Error)){
var statearr_56372_56388 = state_56360__$1;
(statearr_56372_56388[(1)] = (4));

(statearr_56372_56388[(5)] = null);

} else {
throw ex56365;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56361 === (8))){
var inst_56347 = (state_56360[(2)]);
var inst_56348 = fluree.db.dbfunctions.internal.inc(inst_56347);
var inst_56349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56350 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56351 = ["inc",inst_56347,inst_56348];
var inst_56352 = cljs.core.PersistentHashMap.fromArrays(inst_56350,inst_56351);
var inst_56353 = [inst_56352,(10)];
var inst_56354 = (new cljs.core.PersistentVector(null,2,(5),inst_56349,inst_56353,null));
var inst_56355 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56354);
var _ = (function (){var statearr_56373 = state_56360;
(statearr_56373[(4)] = cljs.core.rest((state_56360[(4)])));

return statearr_56373;
})();
var state_56360__$1 = (function (){var statearr_56374 = state_56360;
(statearr_56374[(7)] = inst_56355);

return statearr_56374;
})();
var statearr_56375_56389 = state_56360__$1;
(statearr_56375_56389[(2)] = inst_56348);

(statearr_56375_56389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0 = (function (){
var statearr_56376 = [null,null,null,null,null,null,null,null];
(statearr_56376[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__);

(statearr_56376[(1)] = (1));

return statearr_56376;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1 = (function (state_56360){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56360);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56377){var ex__2730__auto__ = e56377;
var statearr_56378_56390 = state_56360;
(statearr_56378_56390[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56360[(4)]))){
var statearr_56379_56391 = state_56360;
(statearr_56379_56391[(1)] = cljs.core.first((state_56360[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56392 = state_56360;
state_56360 = G__56392;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__ = function(state_56360){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1.call(this,state_56360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56380 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56380[(6)] = c__2749__auto__);

return statearr_56380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56419){
var state_val_56420 = (state_56419[(1)]);
if((state_val_56420 === (7))){
var state_56419__$1 = state_56419;
var statearr_56421_56440 = state_56419__$1;
(statearr_56421_56440[(2)] = n);

(statearr_56421_56440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56420 === (1))){
var state_56419__$1 = state_56419;
var statearr_56422_56441 = state_56419__$1;
(statearr_56422_56441[(2)] = null);

(statearr_56422_56441[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56420 === (4))){
var inst_56393 = (state_56419[(2)]);
var state_56419__$1 = state_56419;
var statearr_56423_56442 = state_56419__$1;
(statearr_56423_56442[(2)] = inst_56393);

(statearr_56423_56442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56420 === (6))){
var state_56419__$1 = state_56419;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56419__$1,(9),n);
} else {
if((state_val_56420 === (3))){
var inst_56417 = (state_56419[(2)]);
var state_56419__$1 = state_56419;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56419__$1,inst_56417);
} else {
if((state_val_56420 === (2))){
var _ = (function (){var statearr_56425 = state_56419;
(statearr_56425[(4)] = cljs.core.cons((5),(state_56419[(4)])));

return statearr_56425;
})();
var inst_56399 = fluree.db.util.async.channel_QMARK_(n);
var state_56419__$1 = state_56419;
if(inst_56399){
var statearr_56426_56443 = state_56419__$1;
(statearr_56426_56443[(1)] = (6));

} else {
var statearr_56427_56444 = state_56419__$1;
(statearr_56427_56444[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56420 === (9))){
var inst_56402 = (state_56419[(2)]);
var inst_56403 = fluree.db.util.async.throw_err(inst_56402);
var state_56419__$1 = state_56419;
var statearr_56428_56445 = state_56419__$1;
(statearr_56428_56445[(2)] = inst_56403);

(statearr_56428_56445[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56420 === (5))){
var _ = (function (){var statearr_56429 = state_56419;
(statearr_56429[(4)] = cljs.core.rest((state_56419[(4)])));

return statearr_56429;
})();
var state_56419__$1 = state_56419;
var ex56424 = (state_56419__$1[(2)]);
var statearr_56430_56446 = state_56419__$1;
(statearr_56430_56446[(5)] = ex56424);


if((ex56424 instanceof Error)){
var statearr_56431_56447 = state_56419__$1;
(statearr_56431_56447[(1)] = (4));

(statearr_56431_56447[(5)] = null);

} else {
throw ex56424;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56420 === (8))){
var inst_56406 = (state_56419[(2)]);
var inst_56407 = fluree.db.dbfunctions.internal.dec(inst_56406);
var inst_56408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56409 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56410 = ["dec",inst_56406,inst_56407];
var inst_56411 = cljs.core.PersistentHashMap.fromArrays(inst_56409,inst_56410);
var inst_56412 = [inst_56411,(10)];
var inst_56413 = (new cljs.core.PersistentVector(null,2,(5),inst_56408,inst_56412,null));
var inst_56414 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56413);
var _ = (function (){var statearr_56432 = state_56419;
(statearr_56432[(4)] = cljs.core.rest((state_56419[(4)])));

return statearr_56432;
})();
var state_56419__$1 = (function (){var statearr_56433 = state_56419;
(statearr_56433[(7)] = inst_56414);

return statearr_56433;
})();
var statearr_56434_56448 = state_56419__$1;
(statearr_56434_56448[(2)] = inst_56407);

(statearr_56434_56448[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0 = (function (){
var statearr_56435 = [null,null,null,null,null,null,null,null];
(statearr_56435[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__);

(statearr_56435[(1)] = (1));

return statearr_56435;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1 = (function (state_56419){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56419);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56436){var ex__2730__auto__ = e56436;
var statearr_56437_56449 = state_56419;
(statearr_56437_56449[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56419[(4)]))){
var statearr_56438_56450 = state_56419;
(statearr_56438_56450[(1)] = cljs.core.first((state_56419[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56451 = state_56419;
state_56419 = G__56451;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__ = function(state_56419){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1.call(this,state_56419);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56439 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56439[(6)] = c__2749__auto__);

return statearr_56439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56501 = arguments.length;
var i__5770__auto___56502 = (0);
while(true){
if((i__5770__auto___56502 < len__5769__auto___56501)){
args__5775__auto__.push((arguments[i__5770__auto___56502]));

var G__56503 = (i__5770__auto___56502 + (1));
i__5770__auto___56502 = G__56503;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56484){
var state_val_56485 = (state_56484[(1)]);
if((state_val_56485 === (1))){
var state_56484__$1 = state_56484;
var statearr_56486_56504 = state_56484__$1;
(statearr_56486_56504[(2)] = null);

(statearr_56486_56504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (2))){
var _ = (function (){var statearr_56487 = state_56484;
(statearr_56487[(4)] = cljs.core.cons((5),(state_56484[(4)])));

return statearr_56487;
})();
var inst_56460 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56484__$1 = state_56484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56484__$1,(6),inst_56460);
} else {
if((state_val_56485 === (3))){
var inst_56482 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56484__$1,inst_56482);
} else {
if((state_val_56485 === (4))){
var inst_56454 = (state_56484[(2)]);
var state_56484__$1 = state_56484;
var statearr_56489_56505 = state_56484__$1;
(statearr_56489_56505[(2)] = inst_56454);

(statearr_56489_56505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (5))){
var _ = (function (){var statearr_56490 = state_56484;
(statearr_56490[(4)] = cljs.core.rest((state_56484[(4)])));

return statearr_56490;
})();
var state_56484__$1 = state_56484;
var ex56488 = (state_56484__$1[(2)]);
var statearr_56491_56506 = state_56484__$1;
(statearr_56491_56506[(5)] = ex56488);


if((ex56488 instanceof Error)){
var statearr_56492_56507 = state_56484__$1;
(statearr_56492_56507[(1)] = (4));

(statearr_56492_56507[(5)] = null);

} else {
throw ex56488;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56485 === (6))){
var inst_56462 = (state_56484[(2)]);
var inst_56463 = fluree.db.util.async.throw_err(inst_56462);
var inst_56464 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_56463);
var inst_56465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56466 = [inst_56463];
var inst_56467 = (new cljs.core.PersistentVector(null,1,(5),inst_56465,inst_56466,null));
var inst_56468 = cljs.core.count(inst_56467);
var inst_56469 = ((9) + inst_56468);
var inst_56470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56471 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56473 = [inst_56463];
var inst_56474 = (new cljs.core.PersistentVector(null,1,(5),inst_56472,inst_56473,null));
var inst_56475 = ["+",inst_56474,inst_56464];
var inst_56476 = cljs.core.PersistentHashMap.fromArrays(inst_56471,inst_56475);
var inst_56477 = [inst_56476,inst_56469];
var inst_56478 = (new cljs.core.PersistentVector(null,2,(5),inst_56470,inst_56477,null));
var inst_56479 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56478);
var _ = (function (){var statearr_56493 = state_56484;
(statearr_56493[(4)] = cljs.core.rest((state_56484[(4)])));

return statearr_56493;
})();
var state_56484__$1 = (function (){var statearr_56494 = state_56484;
(statearr_56494[(7)] = inst_56479);

return statearr_56494;
})();
var statearr_56495_56508 = state_56484__$1;
(statearr_56495_56508[(2)] = inst_56464);

(statearr_56495_56508[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56496 = [null,null,null,null,null,null,null,null];
(statearr_56496[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56496[(1)] = (1));

return statearr_56496;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56484){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56484);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56497){var ex__2730__auto__ = e56497;
var statearr_56498_56509 = state_56484;
(statearr_56498_56509[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56484[(4)]))){
var statearr_56499_56510 = state_56484;
(statearr_56499_56510[(1)] = cljs.core.first((state_56484[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56511 = state_56484;
state_56484 = G__56511;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56500 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56500[(6)] = c__2749__auto__);

return statearr_56500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56452){
var G__56453 = cljs.core.first(seq56452);
var seq56452__$1 = cljs.core.next(seq56452);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56453,seq56452__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56561 = arguments.length;
var i__5770__auto___56562 = (0);
while(true){
if((i__5770__auto___56562 < len__5769__auto___56561)){
args__5775__auto__.push((arguments[i__5770__auto___56562]));

var G__56563 = (i__5770__auto___56562 + (1));
i__5770__auto___56562 = G__56563;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56544){
var state_val_56545 = (state_56544[(1)]);
if((state_val_56545 === (1))){
var state_56544__$1 = state_56544;
var statearr_56546_56564 = state_56544__$1;
(statearr_56546_56564[(2)] = null);

(statearr_56546_56564[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56545 === (2))){
var _ = (function (){var statearr_56547 = state_56544;
(statearr_56547[(4)] = cljs.core.cons((5),(state_56544[(4)])));

return statearr_56547;
})();
var inst_56520 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56544__$1 = state_56544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56544__$1,(6),inst_56520);
} else {
if((state_val_56545 === (3))){
var inst_56542 = (state_56544[(2)]);
var state_56544__$1 = state_56544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56544__$1,inst_56542);
} else {
if((state_val_56545 === (4))){
var inst_56514 = (state_56544[(2)]);
var state_56544__$1 = state_56544;
var statearr_56549_56565 = state_56544__$1;
(statearr_56549_56565[(2)] = inst_56514);

(statearr_56549_56565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56545 === (5))){
var _ = (function (){var statearr_56550 = state_56544;
(statearr_56550[(4)] = cljs.core.rest((state_56544[(4)])));

return statearr_56550;
})();
var state_56544__$1 = state_56544;
var ex56548 = (state_56544__$1[(2)]);
var statearr_56551_56566 = state_56544__$1;
(statearr_56551_56566[(5)] = ex56548);


if((ex56548 instanceof Error)){
var statearr_56552_56567 = state_56544__$1;
(statearr_56552_56567[(1)] = (4));

(statearr_56552_56567[(5)] = null);

} else {
throw ex56548;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56545 === (6))){
var inst_56522 = (state_56544[(2)]);
var inst_56523 = fluree.db.util.async.throw_err(inst_56522);
var inst_56524 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_56523);
var inst_56525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56526 = [inst_56523];
var inst_56527 = (new cljs.core.PersistentVector(null,1,(5),inst_56525,inst_56526,null));
var inst_56528 = cljs.core.count(inst_56527);
var inst_56529 = ((9) + inst_56528);
var inst_56530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56531 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56533 = [inst_56523];
var inst_56534 = (new cljs.core.PersistentVector(null,1,(5),inst_56532,inst_56533,null));
var inst_56535 = ["-",inst_56534,inst_56524];
var inst_56536 = cljs.core.PersistentHashMap.fromArrays(inst_56531,inst_56535);
var inst_56537 = [inst_56536,inst_56529];
var inst_56538 = (new cljs.core.PersistentVector(null,2,(5),inst_56530,inst_56537,null));
var inst_56539 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56538);
var _ = (function (){var statearr_56553 = state_56544;
(statearr_56553[(4)] = cljs.core.rest((state_56544[(4)])));

return statearr_56553;
})();
var state_56544__$1 = (function (){var statearr_56554 = state_56544;
(statearr_56554[(7)] = inst_56539);

return statearr_56554;
})();
var statearr_56555_56568 = state_56544__$1;
(statearr_56555_56568[(2)] = inst_56524);

(statearr_56555_56568[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56556 = [null,null,null,null,null,null,null,null];
(statearr_56556[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56556[(1)] = (1));

return statearr_56556;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56544){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56544);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56557){var ex__2730__auto__ = e56557;
var statearr_56558_56569 = state_56544;
(statearr_56558_56569[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56544[(4)]))){
var statearr_56559_56570 = state_56544;
(statearr_56559_56570[(1)] = cljs.core.first((state_56544[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56571 = state_56544;
state_56544 = G__56571;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56544){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56560 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56560[(6)] = c__2749__auto__);

return statearr_56560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56512){
var G__56513 = cljs.core.first(seq56512);
var seq56512__$1 = cljs.core.next(seq56512);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56513,seq56512__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56621 = arguments.length;
var i__5770__auto___56622 = (0);
while(true){
if((i__5770__auto___56622 < len__5769__auto___56621)){
args__5775__auto__.push((arguments[i__5770__auto___56622]));

var G__56623 = (i__5770__auto___56622 + (1));
i__5770__auto___56622 = G__56623;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56604){
var state_val_56605 = (state_56604[(1)]);
if((state_val_56605 === (1))){
var state_56604__$1 = state_56604;
var statearr_56606_56624 = state_56604__$1;
(statearr_56606_56624[(2)] = null);

(statearr_56606_56624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56605 === (2))){
var _ = (function (){var statearr_56607 = state_56604;
(statearr_56607[(4)] = cljs.core.cons((5),(state_56604[(4)])));

return statearr_56607;
})();
var inst_56580 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56604__$1 = state_56604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56604__$1,(6),inst_56580);
} else {
if((state_val_56605 === (3))){
var inst_56602 = (state_56604[(2)]);
var state_56604__$1 = state_56604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56604__$1,inst_56602);
} else {
if((state_val_56605 === (4))){
var inst_56574 = (state_56604[(2)]);
var state_56604__$1 = state_56604;
var statearr_56609_56625 = state_56604__$1;
(statearr_56609_56625[(2)] = inst_56574);

(statearr_56609_56625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56605 === (5))){
var _ = (function (){var statearr_56610 = state_56604;
(statearr_56610[(4)] = cljs.core.rest((state_56604[(4)])));

return statearr_56610;
})();
var state_56604__$1 = state_56604;
var ex56608 = (state_56604__$1[(2)]);
var statearr_56611_56626 = state_56604__$1;
(statearr_56611_56626[(5)] = ex56608);


if((ex56608 instanceof Error)){
var statearr_56612_56627 = state_56604__$1;
(statearr_56612_56627[(1)] = (4));

(statearr_56612_56627[(5)] = null);

} else {
throw ex56608;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56605 === (6))){
var inst_56582 = (state_56604[(2)]);
var inst_56583 = fluree.db.util.async.throw_err(inst_56582);
var inst_56584 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_56583);
var inst_56585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56586 = [inst_56583];
var inst_56587 = (new cljs.core.PersistentVector(null,1,(5),inst_56585,inst_56586,null));
var inst_56588 = cljs.core.count(inst_56587);
var inst_56589 = ((9) + inst_56588);
var inst_56590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56591 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56593 = [inst_56583];
var inst_56594 = (new cljs.core.PersistentVector(null,1,(5),inst_56592,inst_56593,null));
var inst_56595 = ["*",inst_56594,inst_56584];
var inst_56596 = cljs.core.PersistentHashMap.fromArrays(inst_56591,inst_56595);
var inst_56597 = [inst_56596,inst_56589];
var inst_56598 = (new cljs.core.PersistentVector(null,2,(5),inst_56590,inst_56597,null));
var inst_56599 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56598);
var _ = (function (){var statearr_56613 = state_56604;
(statearr_56613[(4)] = cljs.core.rest((state_56604[(4)])));

return statearr_56613;
})();
var state_56604__$1 = (function (){var statearr_56614 = state_56604;
(statearr_56614[(7)] = inst_56599);

return statearr_56614;
})();
var statearr_56615_56628 = state_56604__$1;
(statearr_56615_56628[(2)] = inst_56584);

(statearr_56615_56628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56616 = [null,null,null,null,null,null,null,null];
(statearr_56616[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56616[(1)] = (1));

return statearr_56616;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56604){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56604);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56617){var ex__2730__auto__ = e56617;
var statearr_56618_56629 = state_56604;
(statearr_56618_56629[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56604[(4)]))){
var statearr_56619_56630 = state_56604;
(statearr_56619_56630[(1)] = cljs.core.first((state_56604[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56631 = state_56604;
state_56604 = G__56631;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56604){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56620 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56620[(6)] = c__2749__auto__);

return statearr_56620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq56572){
var G__56573 = cljs.core.first(seq56572);
var seq56572__$1 = cljs.core.next(seq56572);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56573,seq56572__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___56681 = arguments.length;
var i__5770__auto___56682 = (0);
while(true){
if((i__5770__auto___56682 < len__5769__auto___56681)){
args__5775__auto__.push((arguments[i__5770__auto___56682]));

var G__56683 = (i__5770__auto___56682 + (1));
i__5770__auto___56682 = G__56683;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56664){
var state_val_56665 = (state_56664[(1)]);
if((state_val_56665 === (1))){
var state_56664__$1 = state_56664;
var statearr_56666_56684 = state_56664__$1;
(statearr_56666_56684[(2)] = null);

(statearr_56666_56684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (2))){
var _ = (function (){var statearr_56667 = state_56664;
(statearr_56667[(4)] = cljs.core.cons((5),(state_56664[(4)])));

return statearr_56667;
})();
var inst_56640 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_56664__$1 = state_56664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56664__$1,(6),inst_56640);
} else {
if((state_val_56665 === (3))){
var inst_56662 = (state_56664[(2)]);
var state_56664__$1 = state_56664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56664__$1,inst_56662);
} else {
if((state_val_56665 === (4))){
var inst_56634 = (state_56664[(2)]);
var state_56664__$1 = state_56664;
var statearr_56669_56685 = state_56664__$1;
(statearr_56669_56685[(2)] = inst_56634);

(statearr_56669_56685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (5))){
var _ = (function (){var statearr_56670 = state_56664;
(statearr_56670[(4)] = cljs.core.rest((state_56664[(4)])));

return statearr_56670;
})();
var state_56664__$1 = state_56664;
var ex56668 = (state_56664__$1[(2)]);
var statearr_56671_56686 = state_56664__$1;
(statearr_56671_56686[(5)] = ex56668);


if((ex56668 instanceof Error)){
var statearr_56672_56687 = state_56664__$1;
(statearr_56672_56687[(1)] = (4));

(statearr_56672_56687[(5)] = null);

} else {
throw ex56668;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56665 === (6))){
var inst_56642 = (state_56664[(2)]);
var inst_56643 = fluree.db.util.async.throw_err(inst_56642);
var inst_56644 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_56643);
var inst_56645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56646 = [inst_56643];
var inst_56647 = (new cljs.core.PersistentVector(null,1,(5),inst_56645,inst_56646,null));
var inst_56648 = cljs.core.count(inst_56647);
var inst_56649 = ((9) + inst_56648);
var inst_56650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56651 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56653 = [inst_56643];
var inst_56654 = (new cljs.core.PersistentVector(null,1,(5),inst_56652,inst_56653,null));
var inst_56655 = ["/",inst_56654,inst_56644];
var inst_56656 = cljs.core.PersistentHashMap.fromArrays(inst_56651,inst_56655);
var inst_56657 = [inst_56656,inst_56649];
var inst_56658 = (new cljs.core.PersistentVector(null,2,(5),inst_56650,inst_56657,null));
var inst_56659 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56658);
var _ = (function (){var statearr_56673 = state_56664;
(statearr_56673[(4)] = cljs.core.rest((state_56664[(4)])));

return statearr_56673;
})();
var state_56664__$1 = (function (){var statearr_56674 = state_56664;
(statearr_56674[(7)] = inst_56659);

return statearr_56674;
})();
var statearr_56675_56688 = state_56664__$1;
(statearr_56675_56688[(2)] = inst_56644);

(statearr_56675_56688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_56676 = [null,null,null,null,null,null,null,null];
(statearr_56676[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_56676[(1)] = (1));

return statearr_56676;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_56664){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56664);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56677){var ex__2730__auto__ = e56677;
var statearr_56678_56689 = state_56664;
(statearr_56678_56689[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56664[(4)]))){
var statearr_56679_56690 = state_56664;
(statearr_56679_56690[(1)] = cljs.core.first((state_56664[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56691 = state_56664;
state_56664 = G__56691;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_56664){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_56664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56680 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56680[(6)] = c__2749__auto__);

return statearr_56680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq56632){
var G__56633 = cljs.core.first(seq56632);
var seq56632__$1 = cljs.core.next(seq56632);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56633,seq56632__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56729){
var state_val_56730 = (state_56729[(1)]);
if((state_val_56730 === (7))){
var state_56729__$1 = state_56729;
var statearr_56731_56755 = state_56729__$1;
(statearr_56731_56755[(2)] = n);

(statearr_56731_56755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (1))){
var state_56729__$1 = state_56729;
var statearr_56732_56756 = state_56729__$1;
(statearr_56732_56756[(2)] = null);

(statearr_56732_56756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (4))){
var inst_56692 = (state_56729[(2)]);
var state_56729__$1 = state_56729;
var statearr_56733_56757 = state_56729__$1;
(statearr_56733_56757[(2)] = inst_56692);

(statearr_56733_56757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (13))){
var inst_56709 = (state_56729[(2)]);
var inst_56710 = fluree.db.util.async.throw_err(inst_56709);
var state_56729__$1 = state_56729;
var statearr_56734_56758 = state_56729__$1;
(statearr_56734_56758[(2)] = inst_56710);

(statearr_56734_56758[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (6))){
var state_56729__$1 = state_56729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56729__$1,(9),n);
} else {
if((state_val_56730 === (3))){
var inst_56727 = (state_56729[(2)]);
var state_56729__$1 = state_56729;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56729__$1,inst_56727);
} else {
if((state_val_56730 === (12))){
var inst_56705 = (state_56729[(7)]);
var inst_56713 = (state_56729[(2)]);
var inst_56714 = fluree.db.dbfunctions.internal.quot(inst_56705,inst_56713);
var inst_56715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56716 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56718 = [inst_56705,inst_56713];
var inst_56719 = (new cljs.core.PersistentVector(null,2,(5),inst_56717,inst_56718,null));
var inst_56720 = ["quot",inst_56719,inst_56714];
var inst_56721 = cljs.core.PersistentHashMap.fromArrays(inst_56716,inst_56720);
var inst_56722 = [inst_56721,(2)];
var inst_56723 = (new cljs.core.PersistentVector(null,2,(5),inst_56715,inst_56722,null));
var inst_56724 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56723);
var _ = (function (){var statearr_56735 = state_56729;
(statearr_56735[(4)] = cljs.core.rest((state_56729[(4)])));

return statearr_56735;
})();
var state_56729__$1 = (function (){var statearr_56736 = state_56729;
(statearr_56736[(8)] = inst_56724);

return statearr_56736;
})();
var statearr_56737_56759 = state_56729__$1;
(statearr_56737_56759[(2)] = inst_56714);

(statearr_56737_56759[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (2))){
var _ = (function (){var statearr_56738 = state_56729;
(statearr_56738[(4)] = cljs.core.cons((5),(state_56729[(4)])));

return statearr_56738;
})();
var inst_56698 = fluree.db.util.async.channel_QMARK_(n);
var state_56729__$1 = state_56729;
if(inst_56698){
var statearr_56739_56760 = state_56729__$1;
(statearr_56739_56760[(1)] = (6));

} else {
var statearr_56740_56761 = state_56729__$1;
(statearr_56740_56761[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (11))){
var state_56729__$1 = state_56729;
var statearr_56742_56762 = state_56729__$1;
(statearr_56742_56762[(2)] = d);

(statearr_56742_56762[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (9))){
var inst_56701 = (state_56729[(2)]);
var inst_56702 = fluree.db.util.async.throw_err(inst_56701);
var state_56729__$1 = state_56729;
var statearr_56743_56763 = state_56729__$1;
(statearr_56743_56763[(2)] = inst_56702);

(statearr_56743_56763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (5))){
var _ = (function (){var statearr_56744 = state_56729;
(statearr_56744[(4)] = cljs.core.rest((state_56729[(4)])));

return statearr_56744;
})();
var state_56729__$1 = state_56729;
var ex56741 = (state_56729__$1[(2)]);
var statearr_56745_56764 = state_56729__$1;
(statearr_56745_56764[(5)] = ex56741);


if((ex56741 instanceof Error)){
var statearr_56746_56765 = state_56729__$1;
(statearr_56746_56765[(1)] = (4));

(statearr_56746_56765[(5)] = null);

} else {
throw ex56741;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56730 === (10))){
var state_56729__$1 = state_56729;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56729__$1,(13),d);
} else {
if((state_val_56730 === (8))){
var inst_56705 = (state_56729[(2)]);
var inst_56706 = fluree.db.util.async.channel_QMARK_(d);
var state_56729__$1 = (function (){var statearr_56747 = state_56729;
(statearr_56747[(7)] = inst_56705);

return statearr_56747;
})();
if(inst_56706){
var statearr_56748_56766 = state_56729__$1;
(statearr_56748_56766[(1)] = (10));

} else {
var statearr_56749_56767 = state_56729__$1;
(statearr_56749_56767[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0 = (function (){
var statearr_56750 = [null,null,null,null,null,null,null,null,null];
(statearr_56750[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__);

(statearr_56750[(1)] = (1));

return statearr_56750;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1 = (function (state_56729){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56729);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56751){var ex__2730__auto__ = e56751;
var statearr_56752_56768 = state_56729;
(statearr_56752_56768[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56729[(4)]))){
var statearr_56753_56769 = state_56729;
(statearr_56753_56769[(1)] = cljs.core.first((state_56729[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56770 = state_56729;
state_56729 = G__56770;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__ = function(state_56729){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1.call(this,state_56729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56754 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56754[(6)] = c__2749__auto__);

return statearr_56754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56808){
var state_val_56809 = (state_56808[(1)]);
if((state_val_56809 === (7))){
var state_56808__$1 = state_56808;
var statearr_56810_56834 = state_56808__$1;
(statearr_56810_56834[(2)] = n);

(statearr_56810_56834[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (1))){
var state_56808__$1 = state_56808;
var statearr_56811_56835 = state_56808__$1;
(statearr_56811_56835[(2)] = null);

(statearr_56811_56835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (4))){
var inst_56771 = (state_56808[(2)]);
var state_56808__$1 = state_56808;
var statearr_56812_56836 = state_56808__$1;
(statearr_56812_56836[(2)] = inst_56771);

(statearr_56812_56836[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (13))){
var inst_56788 = (state_56808[(2)]);
var inst_56789 = fluree.db.util.async.throw_err(inst_56788);
var state_56808__$1 = state_56808;
var statearr_56813_56837 = state_56808__$1;
(statearr_56813_56837[(2)] = inst_56789);

(statearr_56813_56837[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (6))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(9),n);
} else {
if((state_val_56809 === (3))){
var inst_56806 = (state_56808[(2)]);
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56808__$1,inst_56806);
} else {
if((state_val_56809 === (12))){
var inst_56784 = (state_56808[(7)]);
var inst_56792 = (state_56808[(2)]);
var inst_56793 = fluree.db.dbfunctions.internal.mod(inst_56784,inst_56792);
var inst_56794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56795 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56796 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56797 = [inst_56784,inst_56792];
var inst_56798 = (new cljs.core.PersistentVector(null,2,(5),inst_56796,inst_56797,null));
var inst_56799 = ["mod",inst_56798,inst_56793];
var inst_56800 = cljs.core.PersistentHashMap.fromArrays(inst_56795,inst_56799);
var inst_56801 = [inst_56800,(2)];
var inst_56802 = (new cljs.core.PersistentVector(null,2,(5),inst_56794,inst_56801,null));
var inst_56803 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56802);
var _ = (function (){var statearr_56814 = state_56808;
(statearr_56814[(4)] = cljs.core.rest((state_56808[(4)])));

return statearr_56814;
})();
var state_56808__$1 = (function (){var statearr_56815 = state_56808;
(statearr_56815[(8)] = inst_56803);

return statearr_56815;
})();
var statearr_56816_56838 = state_56808__$1;
(statearr_56816_56838[(2)] = inst_56793);

(statearr_56816_56838[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (2))){
var _ = (function (){var statearr_56817 = state_56808;
(statearr_56817[(4)] = cljs.core.cons((5),(state_56808[(4)])));

return statearr_56817;
})();
var inst_56777 = fluree.db.util.async.channel_QMARK_(n);
var state_56808__$1 = state_56808;
if(inst_56777){
var statearr_56818_56839 = state_56808__$1;
(statearr_56818_56839[(1)] = (6));

} else {
var statearr_56819_56840 = state_56808__$1;
(statearr_56819_56840[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (11))){
var state_56808__$1 = state_56808;
var statearr_56821_56841 = state_56808__$1;
(statearr_56821_56841[(2)] = d);

(statearr_56821_56841[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (9))){
var inst_56780 = (state_56808[(2)]);
var inst_56781 = fluree.db.util.async.throw_err(inst_56780);
var state_56808__$1 = state_56808;
var statearr_56822_56842 = state_56808__$1;
(statearr_56822_56842[(2)] = inst_56781);

(statearr_56822_56842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (5))){
var _ = (function (){var statearr_56823 = state_56808;
(statearr_56823[(4)] = cljs.core.rest((state_56808[(4)])));

return statearr_56823;
})();
var state_56808__$1 = state_56808;
var ex56820 = (state_56808__$1[(2)]);
var statearr_56824_56843 = state_56808__$1;
(statearr_56824_56843[(5)] = ex56820);


if((ex56820 instanceof Error)){
var statearr_56825_56844 = state_56808__$1;
(statearr_56825_56844[(1)] = (4));

(statearr_56825_56844[(5)] = null);

} else {
throw ex56820;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56809 === (10))){
var state_56808__$1 = state_56808;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56808__$1,(13),d);
} else {
if((state_val_56809 === (8))){
var inst_56784 = (state_56808[(2)]);
var inst_56785 = fluree.db.util.async.channel_QMARK_(d);
var state_56808__$1 = (function (){var statearr_56826 = state_56808;
(statearr_56826[(7)] = inst_56784);

return statearr_56826;
})();
if(inst_56785){
var statearr_56827_56845 = state_56808__$1;
(statearr_56827_56845[(1)] = (10));

} else {
var statearr_56828_56846 = state_56808__$1;
(statearr_56828_56846[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0 = (function (){
var statearr_56829 = [null,null,null,null,null,null,null,null,null];
(statearr_56829[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__);

(statearr_56829[(1)] = (1));

return statearr_56829;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1 = (function (state_56808){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56808);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56830){var ex__2730__auto__ = e56830;
var statearr_56831_56847 = state_56808;
(statearr_56831_56847[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56808[(4)]))){
var statearr_56832_56848 = state_56808;
(statearr_56832_56848[(1)] = cljs.core.first((state_56808[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56849 = state_56808;
state_56808 = G__56849;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__ = function(state_56808){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1.call(this,state_56808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56833 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56833[(6)] = c__2749__auto__);

return statearr_56833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56887){
var state_val_56888 = (state_56887[(1)]);
if((state_val_56888 === (7))){
var state_56887__$1 = state_56887;
var statearr_56889_56913 = state_56887__$1;
(statearr_56889_56913[(2)] = n);

(statearr_56889_56913[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (1))){
var state_56887__$1 = state_56887;
var statearr_56890_56914 = state_56887__$1;
(statearr_56890_56914[(2)] = null);

(statearr_56890_56914[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (4))){
var inst_56850 = (state_56887[(2)]);
var state_56887__$1 = state_56887;
var statearr_56891_56915 = state_56887__$1;
(statearr_56891_56915[(2)] = inst_56850);

(statearr_56891_56915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (13))){
var inst_56867 = (state_56887[(2)]);
var inst_56868 = fluree.db.util.async.throw_err(inst_56867);
var state_56887__$1 = state_56887;
var statearr_56892_56916 = state_56887__$1;
(statearr_56892_56916[(2)] = inst_56868);

(statearr_56892_56916[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (6))){
var state_56887__$1 = state_56887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56887__$1,(9),n);
} else {
if((state_val_56888 === (3))){
var inst_56885 = (state_56887[(2)]);
var state_56887__$1 = state_56887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56887__$1,inst_56885);
} else {
if((state_val_56888 === (12))){
var inst_56863 = (state_56887[(7)]);
var inst_56871 = (state_56887[(2)]);
var inst_56872 = fluree.db.dbfunctions.internal.rem(inst_56863,inst_56871);
var inst_56873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56874 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56876 = [inst_56863,inst_56871];
var inst_56877 = (new cljs.core.PersistentVector(null,2,(5),inst_56875,inst_56876,null));
var inst_56878 = ["rem",inst_56877,inst_56872];
var inst_56879 = cljs.core.PersistentHashMap.fromArrays(inst_56874,inst_56878);
var inst_56880 = [inst_56879,(2)];
var inst_56881 = (new cljs.core.PersistentVector(null,2,(5),inst_56873,inst_56880,null));
var inst_56882 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56881);
var _ = (function (){var statearr_56893 = state_56887;
(statearr_56893[(4)] = cljs.core.rest((state_56887[(4)])));

return statearr_56893;
})();
var state_56887__$1 = (function (){var statearr_56894 = state_56887;
(statearr_56894[(8)] = inst_56882);

return statearr_56894;
})();
var statearr_56895_56917 = state_56887__$1;
(statearr_56895_56917[(2)] = inst_56872);

(statearr_56895_56917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (2))){
var _ = (function (){var statearr_56896 = state_56887;
(statearr_56896[(4)] = cljs.core.cons((5),(state_56887[(4)])));

return statearr_56896;
})();
var inst_56856 = fluree.db.util.async.channel_QMARK_(n);
var state_56887__$1 = state_56887;
if(inst_56856){
var statearr_56897_56918 = state_56887__$1;
(statearr_56897_56918[(1)] = (6));

} else {
var statearr_56898_56919 = state_56887__$1;
(statearr_56898_56919[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (11))){
var state_56887__$1 = state_56887;
var statearr_56900_56920 = state_56887__$1;
(statearr_56900_56920[(2)] = d);

(statearr_56900_56920[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (9))){
var inst_56859 = (state_56887[(2)]);
var inst_56860 = fluree.db.util.async.throw_err(inst_56859);
var state_56887__$1 = state_56887;
var statearr_56901_56921 = state_56887__$1;
(statearr_56901_56921[(2)] = inst_56860);

(statearr_56901_56921[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (5))){
var _ = (function (){var statearr_56902 = state_56887;
(statearr_56902[(4)] = cljs.core.rest((state_56887[(4)])));

return statearr_56902;
})();
var state_56887__$1 = state_56887;
var ex56899 = (state_56887__$1[(2)]);
var statearr_56903_56922 = state_56887__$1;
(statearr_56903_56922[(5)] = ex56899);


if((ex56899 instanceof Error)){
var statearr_56904_56923 = state_56887__$1;
(statearr_56904_56923[(1)] = (4));

(statearr_56904_56923[(5)] = null);

} else {
throw ex56899;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56888 === (10))){
var state_56887__$1 = state_56887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56887__$1,(13),d);
} else {
if((state_val_56888 === (8))){
var inst_56863 = (state_56887[(2)]);
var inst_56864 = fluree.db.util.async.channel_QMARK_(d);
var state_56887__$1 = (function (){var statearr_56905 = state_56887;
(statearr_56905[(7)] = inst_56863);

return statearr_56905;
})();
if(inst_56864){
var statearr_56906_56924 = state_56887__$1;
(statearr_56906_56924[(1)] = (10));

} else {
var statearr_56907_56925 = state_56887__$1;
(statearr_56907_56925[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0 = (function (){
var statearr_56908 = [null,null,null,null,null,null,null,null,null];
(statearr_56908[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__);

(statearr_56908[(1)] = (1));

return statearr_56908;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1 = (function (state_56887){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56887);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56909){var ex__2730__auto__ = e56909;
var statearr_56910_56926 = state_56887;
(statearr_56910_56926[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56887[(4)]))){
var statearr_56911_56927 = state_56887;
(statearr_56911_56927[(1)] = cljs.core.first((state_56887[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56928 = state_56887;
state_56887 = G__56928;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__ = function(state_56887){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1.call(this,state_56887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56912 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56912[(6)] = c__2749__auto__);

return statearr_56912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_56955){
var state_val_56956 = (state_56955[(1)]);
if((state_val_56956 === (7))){
var state_56955__$1 = state_56955;
var statearr_56957_56976 = state_56955__$1;
(statearr_56957_56976[(2)] = x);

(statearr_56957_56976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56956 === (1))){
var state_56955__$1 = state_56955;
var statearr_56958_56977 = state_56955__$1;
(statearr_56958_56977[(2)] = null);

(statearr_56958_56977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56956 === (4))){
var inst_56929 = (state_56955[(2)]);
var state_56955__$1 = state_56955;
var statearr_56959_56978 = state_56955__$1;
(statearr_56959_56978[(2)] = inst_56929);

(statearr_56959_56978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56956 === (6))){
var state_56955__$1 = state_56955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56955__$1,(9),x);
} else {
if((state_val_56956 === (3))){
var inst_56953 = (state_56955[(2)]);
var state_56955__$1 = state_56955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56955__$1,inst_56953);
} else {
if((state_val_56956 === (2))){
var _ = (function (){var statearr_56961 = state_56955;
(statearr_56961[(4)] = cljs.core.cons((5),(state_56955[(4)])));

return statearr_56961;
})();
var inst_56935 = fluree.db.util.async.channel_QMARK_(x);
var state_56955__$1 = state_56955;
if(inst_56935){
var statearr_56962_56979 = state_56955__$1;
(statearr_56962_56979[(1)] = (6));

} else {
var statearr_56963_56980 = state_56955__$1;
(statearr_56963_56980[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56956 === (9))){
var inst_56938 = (state_56955[(2)]);
var inst_56939 = fluree.db.util.async.throw_err(inst_56938);
var state_56955__$1 = state_56955;
var statearr_56964_56981 = state_56955__$1;
(statearr_56964_56981[(2)] = inst_56939);

(statearr_56964_56981[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56956 === (5))){
var _ = (function (){var statearr_56965 = state_56955;
(statearr_56965[(4)] = cljs.core.rest((state_56955[(4)])));

return statearr_56965;
})();
var state_56955__$1 = state_56955;
var ex56960 = (state_56955__$1[(2)]);
var statearr_56966_56982 = state_56955__$1;
(statearr_56966_56982[(5)] = ex56960);


if((ex56960 instanceof Error)){
var statearr_56967_56983 = state_56955__$1;
(statearr_56967_56983[(1)] = (4));

(statearr_56967_56983[(5)] = null);

} else {
throw ex56960;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56956 === (8))){
var inst_56942 = (state_56955[(2)]);
var inst_56943 = fluree.db.dbfunctions.internal.boolean$(inst_56942);
var inst_56944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56945 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56946 = ["boolean",inst_56942,inst_56943];
var inst_56947 = cljs.core.PersistentHashMap.fromArrays(inst_56945,inst_56946);
var inst_56948 = [inst_56947,(10)];
var inst_56949 = (new cljs.core.PersistentVector(null,2,(5),inst_56944,inst_56948,null));
var inst_56950 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_56949);
var _ = (function (){var statearr_56968 = state_56955;
(statearr_56968[(4)] = cljs.core.rest((state_56955[(4)])));

return statearr_56968;
})();
var state_56955__$1 = (function (){var statearr_56969 = state_56955;
(statearr_56969[(7)] = inst_56950);

return statearr_56969;
})();
var statearr_56970_56984 = state_56955__$1;
(statearr_56970_56984[(2)] = inst_56943);

(statearr_56970_56984[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0 = (function (){
var statearr_56971 = [null,null,null,null,null,null,null,null];
(statearr_56971[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__);

(statearr_56971[(1)] = (1));

return statearr_56971;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1 = (function (state_56955){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_56955);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e56972){var ex__2730__auto__ = e56972;
var statearr_56973_56985 = state_56955;
(statearr_56973_56985[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_56955[(4)]))){
var statearr_56974_56986 = state_56955;
(statearr_56974_56986[(1)] = cljs.core.first((state_56955[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56987 = state_56955;
state_56955 = G__56987;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__ = function(state_56955){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1.call(this,state_56955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_56975 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_56975[(6)] = c__2749__auto__);

return statearr_56975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57025){
var state_val_57026 = (state_57025[(1)]);
if((state_val_57026 === (7))){
var state_57025__$1 = state_57025;
var statearr_57027_57051 = state_57025__$1;
(statearr_57027_57051[(2)] = pattern);

(statearr_57027_57051[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (1))){
var state_57025__$1 = state_57025;
var statearr_57028_57052 = state_57025__$1;
(statearr_57028_57052[(2)] = null);

(statearr_57028_57052[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (4))){
var inst_56988 = (state_57025[(2)]);
var state_57025__$1 = state_57025;
var statearr_57029_57053 = state_57025__$1;
(statearr_57029_57053[(2)] = inst_56988);

(statearr_57029_57053[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (13))){
var inst_57005 = (state_57025[(2)]);
var inst_57006 = fluree.db.util.async.throw_err(inst_57005);
var state_57025__$1 = state_57025;
var statearr_57030_57054 = state_57025__$1;
(statearr_57030_57054[(2)] = inst_57006);

(statearr_57030_57054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (6))){
var state_57025__$1 = state_57025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57025__$1,(9),pattern);
} else {
if((state_val_57026 === (3))){
var inst_57023 = (state_57025[(2)]);
var state_57025__$1 = state_57025;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57025__$1,inst_57023);
} else {
if((state_val_57026 === (12))){
var inst_57001 = (state_57025[(7)]);
var inst_57009 = (state_57025[(2)]);
var inst_57010 = fluree.db.dbfunctions.internal.re_find(inst_57001,inst_57009);
var inst_57011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57012 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57014 = [inst_57001,inst_57009];
var inst_57015 = (new cljs.core.PersistentVector(null,2,(5),inst_57013,inst_57014,null));
var inst_57016 = ["re-find",inst_57015,inst_57010];
var inst_57017 = cljs.core.PersistentHashMap.fromArrays(inst_57012,inst_57016);
var inst_57018 = [inst_57017,(10)];
var inst_57019 = (new cljs.core.PersistentVector(null,2,(5),inst_57011,inst_57018,null));
var inst_57020 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57019);
var _ = (function (){var statearr_57031 = state_57025;
(statearr_57031[(4)] = cljs.core.rest((state_57025[(4)])));

return statearr_57031;
})();
var state_57025__$1 = (function (){var statearr_57032 = state_57025;
(statearr_57032[(8)] = inst_57020);

return statearr_57032;
})();
var statearr_57033_57055 = state_57025__$1;
(statearr_57033_57055[(2)] = inst_57010);

(statearr_57033_57055[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (2))){
var _ = (function (){var statearr_57034 = state_57025;
(statearr_57034[(4)] = cljs.core.cons((5),(state_57025[(4)])));

return statearr_57034;
})();
var inst_56994 = fluree.db.util.async.channel_QMARK_(pattern);
var state_57025__$1 = state_57025;
if(inst_56994){
var statearr_57035_57056 = state_57025__$1;
(statearr_57035_57056[(1)] = (6));

} else {
var statearr_57036_57057 = state_57025__$1;
(statearr_57036_57057[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (11))){
var state_57025__$1 = state_57025;
var statearr_57038_57058 = state_57025__$1;
(statearr_57038_57058[(2)] = string);

(statearr_57038_57058[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (9))){
var inst_56997 = (state_57025[(2)]);
var inst_56998 = fluree.db.util.async.throw_err(inst_56997);
var state_57025__$1 = state_57025;
var statearr_57039_57059 = state_57025__$1;
(statearr_57039_57059[(2)] = inst_56998);

(statearr_57039_57059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (5))){
var _ = (function (){var statearr_57040 = state_57025;
(statearr_57040[(4)] = cljs.core.rest((state_57025[(4)])));

return statearr_57040;
})();
var state_57025__$1 = state_57025;
var ex57037 = (state_57025__$1[(2)]);
var statearr_57041_57060 = state_57025__$1;
(statearr_57041_57060[(5)] = ex57037);


if((ex57037 instanceof Error)){
var statearr_57042_57061 = state_57025__$1;
(statearr_57042_57061[(1)] = (4));

(statearr_57042_57061[(5)] = null);

} else {
throw ex57037;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57026 === (10))){
var state_57025__$1 = state_57025;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57025__$1,(13),string);
} else {
if((state_val_57026 === (8))){
var inst_57001 = (state_57025[(2)]);
var inst_57002 = fluree.db.util.async.channel_QMARK_(string);
var state_57025__$1 = (function (){var statearr_57043 = state_57025;
(statearr_57043[(7)] = inst_57001);

return statearr_57043;
})();
if(inst_57002){
var statearr_57044_57062 = state_57025__$1;
(statearr_57044_57062[(1)] = (10));

} else {
var statearr_57045_57063 = state_57025__$1;
(statearr_57045_57063[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0 = (function (){
var statearr_57046 = [null,null,null,null,null,null,null,null,null];
(statearr_57046[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__);

(statearr_57046[(1)] = (1));

return statearr_57046;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1 = (function (state_57025){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57025);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57047){var ex__2730__auto__ = e57047;
var statearr_57048_57064 = state_57025;
(statearr_57048_57064[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57025[(4)]))){
var statearr_57049_57065 = state_57025;
(statearr_57049_57065[(1)] = cljs.core.first((state_57025[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57066 = state_57025;
state_57025 = G__57066;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__ = function(state_57025){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1.call(this,state_57025);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57050 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57050[(6)] = c__2749__auto__);

return statearr_57050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57093){
var state_val_57094 = (state_57093[(1)]);
if((state_val_57094 === (7))){
var state_57093__$1 = state_57093;
var statearr_57095_57114 = state_57093__$1;
(statearr_57095_57114[(2)] = email);

(statearr_57095_57114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57094 === (1))){
var state_57093__$1 = state_57093;
var statearr_57096_57115 = state_57093__$1;
(statearr_57096_57115[(2)] = null);

(statearr_57096_57115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57094 === (4))){
var inst_57067 = (state_57093[(2)]);
var state_57093__$1 = state_57093;
var statearr_57097_57116 = state_57093__$1;
(statearr_57097_57116[(2)] = inst_57067);

(statearr_57097_57116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57094 === (6))){
var state_57093__$1 = state_57093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57093__$1,(9),email);
} else {
if((state_val_57094 === (3))){
var inst_57091 = (state_57093[(2)]);
var state_57093__$1 = state_57093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57093__$1,inst_57091);
} else {
if((state_val_57094 === (2))){
var _ = (function (){var statearr_57099 = state_57093;
(statearr_57099[(4)] = cljs.core.cons((5),(state_57093[(4)])));

return statearr_57099;
})();
var inst_57073 = fluree.db.util.async.channel_QMARK_(email);
var state_57093__$1 = state_57093;
if(inst_57073){
var statearr_57100_57117 = state_57093__$1;
(statearr_57100_57117[(1)] = (6));

} else {
var statearr_57101_57118 = state_57093__$1;
(statearr_57101_57118[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57094 === (9))){
var inst_57076 = (state_57093[(2)]);
var inst_57077 = fluree.db.util.async.throw_err(inst_57076);
var state_57093__$1 = state_57093;
var statearr_57102_57119 = state_57093__$1;
(statearr_57102_57119[(2)] = inst_57077);

(statearr_57102_57119[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57094 === (5))){
var _ = (function (){var statearr_57103 = state_57093;
(statearr_57103[(4)] = cljs.core.rest((state_57093[(4)])));

return statearr_57103;
})();
var state_57093__$1 = state_57093;
var ex57098 = (state_57093__$1[(2)]);
var statearr_57104_57120 = state_57093__$1;
(statearr_57104_57120[(5)] = ex57098);


if((ex57098 instanceof Error)){
var statearr_57105_57121 = state_57093__$1;
(statearr_57105_57121[(1)] = (4));

(statearr_57105_57121[(5)] = null);

} else {
throw ex57098;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57094 === (8))){
var inst_57080 = (state_57093[(2)]);
var inst_57081 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_57080);
var inst_57082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57083 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57084 = ["re-find",inst_57080,inst_57081];
var inst_57085 = cljs.core.PersistentHashMap.fromArrays(inst_57083,inst_57084);
var inst_57086 = [inst_57085,(10)];
var inst_57087 = (new cljs.core.PersistentVector(null,2,(5),inst_57082,inst_57086,null));
var inst_57088 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57087);
var _ = (function (){var statearr_57106 = state_57093;
(statearr_57106[(4)] = cljs.core.rest((state_57093[(4)])));

return statearr_57106;
})();
var state_57093__$1 = (function (){var statearr_57107 = state_57093;
(statearr_57107[(7)] = inst_57088);

return statearr_57107;
})();
var statearr_57108_57122 = state_57093__$1;
(statearr_57108_57122[(2)] = inst_57081);

(statearr_57108_57122[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0 = (function (){
var statearr_57109 = [null,null,null,null,null,null,null,null];
(statearr_57109[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__);

(statearr_57109[(1)] = (1));

return statearr_57109;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1 = (function (state_57093){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57093);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57110){var ex__2730__auto__ = e57110;
var statearr_57111_57123 = state_57093;
(statearr_57111_57123[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57093[(4)]))){
var statearr_57112_57124 = state_57093;
(statearr_57112_57124[(1)] = cljs.core.first((state_57093[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57125 = state_57093;
state_57093 = G__57125;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__ = function(state_57093){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1.call(this,state_57093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57113 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57113[(6)] = c__2749__auto__);

return statearr_57113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57172){
var state_val_57173 = (state_57172[(1)]);
if((state_val_57173 === (7))){
var inst_57142 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57172__$1 = state_57172;
if(cljs.core.truth_(inst_57142)){
var statearr_57174_57201 = state_57172__$1;
(statearr_57174_57201[(1)] = (9));

} else {
var statearr_57175_57202 = state_57172__$1;
(statearr_57175_57202[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (1))){
var state_57172__$1 = state_57172;
var statearr_57176_57203 = state_57172__$1;
(statearr_57176_57203[(2)] = null);

(statearr_57176_57203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (4))){
var inst_57126 = (state_57172[(2)]);
var state_57172__$1 = state_57172;
var statearr_57177_57204 = state_57172__$1;
(statearr_57177_57204[(2)] = inst_57126);

(statearr_57177_57204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (15))){
var inst_57153 = (state_57172[(2)]);
var state_57172__$1 = state_57172;
var statearr_57178_57205 = state_57172__$1;
(statearr_57178_57205[(2)] = inst_57153);

(statearr_57178_57205[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (13))){
var inst_57150 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57172__$1 = state_57172;
var statearr_57179_57206 = state_57172__$1;
(statearr_57179_57206[(2)] = inst_57150);

(statearr_57179_57206[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (6))){
var inst_57137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57138 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57139 = [inst_57138,(0)];
var inst_57140 = (new cljs.core.PersistentVector(null,2,(5),inst_57137,inst_57139,null));
var state_57172__$1 = state_57172;
var statearr_57180_57207 = state_57172__$1;
(statearr_57180_57207[(2)] = inst_57140);

(statearr_57180_57207[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (3))){
var inst_57170 = (state_57172[(2)]);
var state_57172__$1 = state_57172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57172__$1,inst_57170);
} else {
if((state_val_57173 === (12))){
var inst_57146 = (state_57172[(2)]);
var inst_57147 = fluree.db.util.async.throw_err(inst_57146);
var state_57172__$1 = state_57172;
var statearr_57181_57208 = state_57172__$1;
(statearr_57181_57208[(2)] = inst_57147);

(statearr_57181_57208[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (2))){
var _ = (function (){var statearr_57182 = state_57172;
(statearr_57182[(4)] = cljs.core.cons((5),(state_57172[(4)])));

return statearr_57182;
})();
var inst_57135 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57172__$1 = state_57172;
if(cljs.core.truth_(inst_57135)){
var statearr_57183_57209 = state_57172__$1;
(statearr_57183_57209[(1)] = (6));

} else {
var statearr_57184_57210 = state_57172__$1;
(statearr_57184_57210[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (11))){
var inst_57155 = (state_57172[(2)]);
var state_57172__$1 = state_57172;
var statearr_57186_57211 = state_57172__$1;
(statearr_57186_57211[(2)] = inst_57155);

(statearr_57186_57211[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (9))){
var inst_57144 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_57172__$1 = state_57172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57172__$1,(12),inst_57144);
} else {
if((state_val_57173 === (5))){
var _ = (function (){var statearr_57187 = state_57172;
(statearr_57187[(4)] = cljs.core.rest((state_57172[(4)])));

return statearr_57187;
})();
var state_57172__$1 = state_57172;
var ex57185 = (state_57172__$1[(2)]);
var statearr_57188_57212 = state_57172__$1;
(statearr_57188_57212[(5)] = ex57185);


if((ex57185 instanceof Error)){
var statearr_57189_57213 = state_57172__$1;
(statearr_57189_57213[(1)] = (4));

(statearr_57189_57213[(5)] = null);

} else {
throw ex57185;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (14))){
var state_57172__$1 = state_57172;
var statearr_57190_57214 = state_57172__$1;
(statearr_57190_57214[(2)] = null);

(statearr_57190_57214[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (10))){
var state_57172__$1 = state_57172;
var statearr_57191_57215 = state_57172__$1;
(statearr_57191_57215[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57173 === (8))){
var inst_57157 = (state_57172[(2)]);
var inst_57158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57157,(0),null);
var inst_57159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_57157,(1),null);
var inst_57160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57161 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57162 = ["?user_id","?ctx",inst_57158];
var inst_57163 = cljs.core.PersistentHashMap.fromArrays(inst_57161,inst_57162);
var inst_57164 = ((10) + inst_57159);
var inst_57165 = [inst_57163,inst_57164];
var inst_57166 = (new cljs.core.PersistentVector(null,2,(5),inst_57160,inst_57165,null));
var inst_57167 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57166);
var _ = (function (){var statearr_57193 = state_57172;
(statearr_57193[(4)] = cljs.core.rest((state_57172[(4)])));

return statearr_57193;
})();
var state_57172__$1 = (function (){var statearr_57194 = state_57172;
(statearr_57194[(7)] = inst_57167);

return statearr_57194;
})();
var statearr_57195_57216 = state_57172__$1;
(statearr_57195_57216[(2)] = inst_57158);

(statearr_57195_57216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0 = (function (){
var statearr_57196 = [null,null,null,null,null,null,null,null];
(statearr_57196[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__);

(statearr_57196[(1)] = (1));

return statearr_57196;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1 = (function (state_57172){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57172);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57197){var ex__2730__auto__ = e57197;
var statearr_57198_57217 = state_57172;
(statearr_57198_57217[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57172[(4)]))){
var statearr_57199_57218 = state_57172;
(statearr_57199_57218[(1)] = cljs.core.first((state_57172[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57219 = state_57172;
state_57172 = G__57219;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__ = function(state_57172){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1.call(this,state_57172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57200 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57200[(6)] = c__2749__auto__);

return statearr_57200;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57247){
var state_val_57248 = (state_57247[(1)]);
if((state_val_57248 === (7))){
var inst_57240 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57247__$1 = state_57247;
var statearr_57249_57268 = state_57247__$1;
(statearr_57249_57268[(2)] = inst_57240);

(statearr_57249_57268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57248 === (1))){
var state_57247__$1 = state_57247;
var statearr_57250_57269 = state_57247__$1;
(statearr_57250_57269[(2)] = null);

(statearr_57250_57269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57248 === (4))){
var inst_57220 = (state_57247[(2)]);
var state_57247__$1 = state_57247;
var statearr_57251_57270 = state_57247__$1;
(statearr_57251_57270[(2)] = inst_57220);

(statearr_57251_57270[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57248 === (6))){
var inst_57228 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_57247__$1 = state_57247;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57247__$1,(9),inst_57228);
} else {
if((state_val_57248 === (3))){
var inst_57245 = (state_57247[(2)]);
var state_57247__$1 = state_57247;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57247__$1,inst_57245);
} else {
if((state_val_57248 === (2))){
var _ = (function (){var statearr_57253 = state_57247;
(statearr_57253[(4)] = cljs.core.cons((5),(state_57247[(4)])));

return statearr_57253;
})();
var inst_57226 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57247__$1 = state_57247;
if(cljs.core.truth_(inst_57226)){
var statearr_57254_57271 = state_57247__$1;
(statearr_57254_57271[(1)] = (6));

} else {
var statearr_57255_57272 = state_57247__$1;
(statearr_57255_57272[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57248 === (9))){
var inst_57230 = (state_57247[(2)]);
var inst_57231 = fluree.db.util.async.throw_err(inst_57230);
var inst_57232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57233 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57234 = ["?auth_id","?ctx",inst_57231];
var inst_57235 = cljs.core.PersistentHashMap.fromArrays(inst_57233,inst_57234);
var inst_57236 = [inst_57235,(10)];
var inst_57237 = (new cljs.core.PersistentVector(null,2,(5),inst_57232,inst_57236,null));
var inst_57238 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57237);
var state_57247__$1 = (function (){var statearr_57256 = state_57247;
(statearr_57256[(7)] = inst_57238);

return statearr_57256;
})();
var statearr_57257_57273 = state_57247__$1;
(statearr_57257_57273[(2)] = inst_57231);

(statearr_57257_57273[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57248 === (5))){
var _ = (function (){var statearr_57258 = state_57247;
(statearr_57258[(4)] = cljs.core.rest((state_57247[(4)])));

return statearr_57258;
})();
var state_57247__$1 = state_57247;
var ex57252 = (state_57247__$1[(2)]);
var statearr_57259_57274 = state_57247__$1;
(statearr_57259_57274[(5)] = ex57252);


if((ex57252 instanceof Error)){
var statearr_57260_57275 = state_57247__$1;
(statearr_57260_57275[(1)] = (4));

(statearr_57260_57275[(5)] = null);

} else {
throw ex57252;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57248 === (8))){
var inst_57242 = (state_57247[(2)]);
var _ = (function (){var statearr_57261 = state_57247;
(statearr_57261[(4)] = cljs.core.rest((state_57247[(4)])));

return statearr_57261;
})();
var state_57247__$1 = state_57247;
var statearr_57262_57276 = state_57247__$1;
(statearr_57262_57276[(2)] = inst_57242);

(statearr_57262_57276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0 = (function (){
var statearr_57263 = [null,null,null,null,null,null,null,null];
(statearr_57263[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__);

(statearr_57263[(1)] = (1));

return statearr_57263;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1 = (function (state_57247){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57247);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57264){var ex__2730__auto__ = e57264;
var statearr_57265_57277 = state_57247;
(statearr_57265_57277[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57247[(4)]))){
var statearr_57266_57278 = state_57247;
(statearr_57266_57278[(1)] = cljs.core.first((state_57247[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57279 = state_57247;
state_57247 = G__57279;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__ = function(state_57247){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1.call(this,state_57247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57267 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57267[(6)] = c__2749__auto__);

return statearr_57267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57281 = arguments.length;
switch (G__57281) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57323){
var state_val_57324 = (state_57323[(1)]);
if((state_val_57324 === (7))){
var state_57323__$1 = state_57323;
var statearr_57325_57355 = state_57323__$1;
(statearr_57325_57355[(2)] = seed);

(statearr_57325_57355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (1))){
var state_57323__$1 = state_57323;
var statearr_57326_57356 = state_57323__$1;
(statearr_57326_57356[(2)] = null);

(statearr_57326_57356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (4))){
var inst_57282 = (state_57323[(2)]);
var state_57323__$1 = state_57323;
var statearr_57327_57357 = state_57323__$1;
(statearr_57327_57357[(2)] = inst_57282);

(statearr_57327_57357[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (15))){
var state_57323__$1 = state_57323;
var statearr_57328_57358 = state_57323__$1;
(statearr_57328_57358[(2)] = (10));

(statearr_57328_57358[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (13))){
var inst_57299 = (state_57323[(2)]);
var inst_57300 = fluree.db.util.async.throw_err(inst_57299);
var state_57323__$1 = state_57323;
var statearr_57329_57359 = state_57323__$1;
(statearr_57329_57359[(2)] = inst_57300);

(statearr_57329_57359[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (6))){
var state_57323__$1 = state_57323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57323__$1,(9),seed);
} else {
if((state_val_57324 === (3))){
var inst_57321 = (state_57323[(2)]);
var state_57323__$1 = state_57323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57323__$1,inst_57321);
} else {
if((state_val_57324 === (12))){
var inst_57303 = (state_57323[(7)]);
var inst_57303__$1 = (state_57323[(2)]);
var state_57323__$1 = (function (){var statearr_57330 = state_57323;
(statearr_57330[(7)] = inst_57303__$1);

return statearr_57330;
})();
if(cljs.core.truth_(inst_57303__$1)){
var statearr_57331_57360 = state_57323__$1;
(statearr_57331_57360[(1)] = (14));

} else {
var statearr_57332_57361 = state_57323__$1;
(statearr_57332_57361[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (2))){
var _ = (function (){var statearr_57333 = state_57323;
(statearr_57333[(4)] = cljs.core.cons((5),(state_57323[(4)])));

return statearr_57333;
})();
var inst_57288 = fluree.db.util.async.channel_QMARK_(seed);
var state_57323__$1 = state_57323;
if(inst_57288){
var statearr_57334_57362 = state_57323__$1;
(statearr_57334_57362[(1)] = (6));

} else {
var statearr_57335_57363 = state_57323__$1;
(statearr_57335_57363[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (11))){
var state_57323__$1 = state_57323;
var statearr_57337_57364 = state_57323__$1;
(statearr_57337_57364[(2)] = max);

(statearr_57337_57364[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (9))){
var inst_57291 = (state_57323[(2)]);
var inst_57292 = fluree.db.util.async.throw_err(inst_57291);
var state_57323__$1 = state_57323;
var statearr_57338_57365 = state_57323__$1;
(statearr_57338_57365[(2)] = inst_57292);

(statearr_57338_57365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (5))){
var _ = (function (){var statearr_57339 = state_57323;
(statearr_57339[(4)] = cljs.core.rest((state_57323[(4)])));

return statearr_57339;
})();
var state_57323__$1 = state_57323;
var ex57336 = (state_57323__$1[(2)]);
var statearr_57340_57366 = state_57323__$1;
(statearr_57340_57366[(5)] = ex57336);


if((ex57336 instanceof Error)){
var statearr_57341_57367 = state_57323__$1;
(statearr_57341_57367[(1)] = (4));

(statearr_57341_57367[(5)] = null);

} else {
throw ex57336;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (14))){
var inst_57303 = (state_57323[(7)]);
var state_57323__$1 = state_57323;
var statearr_57342_57368 = state_57323__$1;
(statearr_57342_57368[(2)] = inst_57303);

(statearr_57342_57368[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (16))){
var inst_57295 = (state_57323[(8)]);
var inst_57307 = (state_57323[(2)]);
var inst_57308 = fluree.db.dbfunctions.internal.rand(inst_57295,inst_57307);
var inst_57309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57310 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57311 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57312 = [max,seed];
var inst_57313 = (new cljs.core.PersistentVector(null,2,(5),inst_57311,inst_57312,null));
var inst_57314 = ["rand",inst_57313,inst_57308];
var inst_57315 = cljs.core.PersistentHashMap.fromArrays(inst_57310,inst_57314);
var inst_57316 = [inst_57315,(10)];
var inst_57317 = (new cljs.core.PersistentVector(null,2,(5),inst_57309,inst_57316,null));
var inst_57318 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57317);
var _ = (function (){var statearr_57343 = state_57323;
(statearr_57343[(4)] = cljs.core.rest((state_57323[(4)])));

return statearr_57343;
})();
var state_57323__$1 = (function (){var statearr_57344 = state_57323;
(statearr_57344[(9)] = inst_57318);

return statearr_57344;
})();
var statearr_57345_57369 = state_57323__$1;
(statearr_57345_57369[(2)] = inst_57308);

(statearr_57345_57369[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57324 === (10))){
var state_57323__$1 = state_57323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57323__$1,(13),max);
} else {
if((state_val_57324 === (8))){
var inst_57295 = (state_57323[(2)]);
var inst_57296 = fluree.db.util.async.channel_QMARK_(max);
var state_57323__$1 = (function (){var statearr_57346 = state_57323;
(statearr_57346[(8)] = inst_57295);

return statearr_57346;
})();
if(inst_57296){
var statearr_57347_57370 = state_57323__$1;
(statearr_57347_57370[(1)] = (10));

} else {
var statearr_57348_57371 = state_57323__$1;
(statearr_57348_57371[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2727__auto____0 = (function (){
var statearr_57349 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57349[(0)] = fluree$db$dbfunctions$fns$state_machine__2727__auto__);

(statearr_57349[(1)] = (1));

return statearr_57349;
});
var fluree$db$dbfunctions$fns$state_machine__2727__auto____1 = (function (state_57323){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57323);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57350){var ex__2730__auto__ = e57350;
var statearr_57351_57372 = state_57323;
(statearr_57351_57372[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57323[(4)]))){
var statearr_57352_57373 = state_57323;
(statearr_57352_57373[(1)] = cljs.core.first((state_57323[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57374 = state_57323;
state_57323 = G__57374;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2727__auto__ = function(state_57323){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2727__auto____1.call(this,state_57323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57353 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57353[(6)] = c__2749__auto__);

return statearr_57353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57395){
var state_val_57396 = (state_57395[(1)]);
if((state_val_57396 === (1))){
var state_57395__$1 = state_57395;
var statearr_57397_57412 = state_57395__$1;
(statearr_57397_57412[(2)] = null);

(statearr_57397_57412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57396 === (2))){
var _ = (function (){var statearr_57398 = state_57395;
(statearr_57398[(4)] = cljs.core.cons((5),(state_57395[(4)])));

return statearr_57398;
})();
var inst_57381 = cljs.core.random_uuid();
var inst_57382 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57381);
var inst_57383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57384 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57385 = cljs.core.PersistentVector.EMPTY;
var inst_57386 = ["uuid",inst_57385,inst_57382];
var inst_57387 = cljs.core.PersistentHashMap.fromArrays(inst_57384,inst_57386);
var inst_57388 = [inst_57387,(10)];
var inst_57389 = (new cljs.core.PersistentVector(null,2,(5),inst_57383,inst_57388,null));
var inst_57390 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57389);
var ___$1 = (function (){var statearr_57399 = state_57395;
(statearr_57399[(4)] = cljs.core.rest((state_57395[(4)])));

return statearr_57399;
})();
var state_57395__$1 = (function (){var statearr_57400 = state_57395;
(statearr_57400[(7)] = inst_57390);

return statearr_57400;
})();
var statearr_57401_57413 = state_57395__$1;
(statearr_57401_57413[(2)] = inst_57382);

(statearr_57401_57413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57396 === (3))){
var inst_57393 = (state_57395[(2)]);
var state_57395__$1 = state_57395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57395__$1,inst_57393);
} else {
if((state_val_57396 === (4))){
var inst_57375 = (state_57395[(2)]);
var state_57395__$1 = state_57395;
var statearr_57403_57414 = state_57395__$1;
(statearr_57403_57414[(2)] = inst_57375);

(statearr_57403_57414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57396 === (5))){
var _ = (function (){var statearr_57404 = state_57395;
(statearr_57404[(4)] = cljs.core.rest((state_57395[(4)])));

return statearr_57404;
})();
var state_57395__$1 = state_57395;
var ex57402 = (state_57395__$1[(2)]);
var statearr_57405_57415 = state_57395__$1;
(statearr_57405_57415[(5)] = ex57402);


if((ex57402 instanceof Error)){
var statearr_57406_57416 = state_57395__$1;
(statearr_57406_57416[(1)] = (4));

(statearr_57406_57416[(5)] = null);

} else {
throw ex57402;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0 = (function (){
var statearr_57407 = [null,null,null,null,null,null,null,null];
(statearr_57407[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__);

(statearr_57407[(1)] = (1));

return statearr_57407;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1 = (function (state_57395){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57395);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57408){var ex__2730__auto__ = e57408;
var statearr_57409_57417 = state_57395;
(statearr_57409_57417[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57395[(4)]))){
var statearr_57410_57418 = state_57395;
(statearr_57410_57418[(1)] = cljs.core.first((state_57395[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57419 = state_57395;
state_57395 = G__57419;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__ = function(state_57395){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1.call(this,state_57395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57411 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57411[(6)] = c__2749__auto__);

return statearr_57411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57449){
var state_val_57450 = (state_57449[(1)]);
if((state_val_57450 === (7))){
var state_57449__$1 = state_57449;
var statearr_57451_57470 = state_57449__$1;
(statearr_57451_57470[(2)] = num);

(statearr_57451_57470[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (1))){
var state_57449__$1 = state_57449;
var statearr_57452_57471 = state_57449__$1;
(statearr_57452_57471[(2)] = null);

(statearr_57452_57471[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (4))){
var inst_57420 = (state_57449[(2)]);
var state_57449__$1 = state_57449;
var statearr_57453_57472 = state_57449__$1;
(statearr_57453_57472[(2)] = inst_57420);

(statearr_57453_57472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (6))){
var state_57449__$1 = state_57449;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57449__$1,(9),num);
} else {
if((state_val_57450 === (3))){
var inst_57447 = (state_57449[(2)]);
var state_57449__$1 = state_57449;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57449__$1,inst_57447);
} else {
if((state_val_57450 === (2))){
var _ = (function (){var statearr_57455 = state_57449;
(statearr_57455[(4)] = cljs.core.cons((5),(state_57449[(4)])));

return statearr_57455;
})();
var inst_57426 = fluree.db.util.async.channel_QMARK_(num);
var state_57449__$1 = state_57449;
if(inst_57426){
var statearr_57456_57473 = state_57449__$1;
(statearr_57456_57473[(1)] = (6));

} else {
var statearr_57457_57474 = state_57449__$1;
(statearr_57457_57474[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (9))){
var inst_57429 = (state_57449[(2)]);
var inst_57430 = fluree.db.util.async.throw_err(inst_57429);
var state_57449__$1 = state_57449;
var statearr_57458_57475 = state_57449__$1;
(statearr_57458_57475[(2)] = inst_57430);

(statearr_57458_57475[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (5))){
var _ = (function (){var statearr_57459 = state_57449;
(statearr_57459[(4)] = cljs.core.rest((state_57449[(4)])));

return statearr_57459;
})();
var state_57449__$1 = state_57449;
var ex57454 = (state_57449__$1[(2)]);
var statearr_57460_57476 = state_57449__$1;
(statearr_57460_57476[(5)] = ex57454);


if((ex57454 instanceof Error)){
var statearr_57461_57477 = state_57449__$1;
(statearr_57461_57477[(1)] = (4));

(statearr_57461_57477[(5)] = null);

} else {
throw ex57454;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57450 === (8))){
var inst_57433 = (state_57449[(2)]);
var inst_57434 = fluree.db.dbfunctions.internal.ceil(inst_57433);
var inst_57435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57436 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57437 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57438 = [fluree.db.dbfunctions.fns.ceil];
var inst_57439 = (new cljs.core.PersistentVector(null,1,(5),inst_57437,inst_57438,null));
var inst_57440 = ["",inst_57439,inst_57434];
var inst_57441 = cljs.core.PersistentHashMap.fromArrays(inst_57436,inst_57440);
var inst_57442 = [inst_57441,(10)];
var inst_57443 = (new cljs.core.PersistentVector(null,2,(5),inst_57435,inst_57442,null));
var inst_57444 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57443);
var _ = (function (){var statearr_57462 = state_57449;
(statearr_57462[(4)] = cljs.core.rest((state_57449[(4)])));

return statearr_57462;
})();
var state_57449__$1 = (function (){var statearr_57463 = state_57449;
(statearr_57463[(7)] = inst_57444);

return statearr_57463;
})();
var statearr_57464_57478 = state_57449__$1;
(statearr_57464_57478[(2)] = inst_57434);

(statearr_57464_57478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0 = (function (){
var statearr_57465 = [null,null,null,null,null,null,null,null];
(statearr_57465[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__);

(statearr_57465[(1)] = (1));

return statearr_57465;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1 = (function (state_57449){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57449);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57466){var ex__2730__auto__ = e57466;
var statearr_57467_57479 = state_57449;
(statearr_57467_57479[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57449[(4)]))){
var statearr_57468_57480 = state_57449;
(statearr_57468_57480[(1)] = cljs.core.first((state_57449[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57481 = state_57449;
state_57449 = G__57481;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__ = function(state_57449){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1.call(this,state_57449);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57469 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57469[(6)] = c__2749__auto__);

return statearr_57469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57511){
var state_val_57512 = (state_57511[(1)]);
if((state_val_57512 === (7))){
var state_57511__$1 = state_57511;
var statearr_57513_57532 = state_57511__$1;
(statearr_57513_57532[(2)] = num);

(statearr_57513_57532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (1))){
var state_57511__$1 = state_57511;
var statearr_57514_57533 = state_57511__$1;
(statearr_57514_57533[(2)] = null);

(statearr_57514_57533[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (4))){
var inst_57482 = (state_57511[(2)]);
var state_57511__$1 = state_57511;
var statearr_57515_57534 = state_57511__$1;
(statearr_57515_57534[(2)] = inst_57482);

(statearr_57515_57534[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (6))){
var state_57511__$1 = state_57511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57511__$1,(9),num);
} else {
if((state_val_57512 === (3))){
var inst_57509 = (state_57511[(2)]);
var state_57511__$1 = state_57511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57511__$1,inst_57509);
} else {
if((state_val_57512 === (2))){
var _ = (function (){var statearr_57517 = state_57511;
(statearr_57517[(4)] = cljs.core.cons((5),(state_57511[(4)])));

return statearr_57517;
})();
var inst_57488 = fluree.db.util.async.channel_QMARK_(num);
var state_57511__$1 = state_57511;
if(inst_57488){
var statearr_57518_57535 = state_57511__$1;
(statearr_57518_57535[(1)] = (6));

} else {
var statearr_57519_57536 = state_57511__$1;
(statearr_57519_57536[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (9))){
var inst_57491 = (state_57511[(2)]);
var inst_57492 = fluree.db.util.async.throw_err(inst_57491);
var state_57511__$1 = state_57511;
var statearr_57520_57537 = state_57511__$1;
(statearr_57520_57537[(2)] = inst_57492);

(statearr_57520_57537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (5))){
var _ = (function (){var statearr_57521 = state_57511;
(statearr_57521[(4)] = cljs.core.rest((state_57511[(4)])));

return statearr_57521;
})();
var state_57511__$1 = state_57511;
var ex57516 = (state_57511__$1[(2)]);
var statearr_57522_57538 = state_57511__$1;
(statearr_57522_57538[(5)] = ex57516);


if((ex57516 instanceof Error)){
var statearr_57523_57539 = state_57511__$1;
(statearr_57523_57539[(1)] = (4));

(statearr_57523_57539[(5)] = null);

} else {
throw ex57516;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57512 === (8))){
var inst_57495 = (state_57511[(2)]);
var inst_57496 = fluree.db.dbfunctions.internal.floor(inst_57495);
var inst_57497 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57498 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57500 = [fluree.db.dbfunctions.fns.floor];
var inst_57501 = (new cljs.core.PersistentVector(null,1,(5),inst_57499,inst_57500,null));
var inst_57502 = ["",inst_57501,inst_57496];
var inst_57503 = cljs.core.PersistentHashMap.fromArrays(inst_57498,inst_57502);
var inst_57504 = [inst_57503,(10)];
var inst_57505 = (new cljs.core.PersistentVector(null,2,(5),inst_57497,inst_57504,null));
var inst_57506 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57505);
var _ = (function (){var statearr_57524 = state_57511;
(statearr_57524[(4)] = cljs.core.rest((state_57511[(4)])));

return statearr_57524;
})();
var state_57511__$1 = (function (){var statearr_57525 = state_57511;
(statearr_57525[(7)] = inst_57506);

return statearr_57525;
})();
var statearr_57526_57540 = state_57511__$1;
(statearr_57526_57540[(2)] = inst_57496);

(statearr_57526_57540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0 = (function (){
var statearr_57527 = [null,null,null,null,null,null,null,null];
(statearr_57527[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__);

(statearr_57527[(1)] = (1));

return statearr_57527;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1 = (function (state_57511){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57511);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57528){var ex__2730__auto__ = e57528;
var statearr_57529_57541 = state_57511;
(statearr_57529_57541[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57511[(4)]))){
var statearr_57530_57542 = state_57511;
(statearr_57530_57542[(1)] = cljs.core.first((state_57511[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57543 = state_57511;
state_57511 = G__57543;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__ = function(state_57511){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1.call(this,state_57511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57531 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57531[(6)] = c__2749__auto__);

return statearr_57531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_57568){
var state_val_57569 = (state_57568[(1)]);
if((state_val_57569 === (1))){
var state_57568__$1 = state_57568;
var statearr_57570_57585 = state_57568__$1;
(statearr_57570_57585[(2)] = null);

(statearr_57570_57585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (2))){
var _ = (function (){var statearr_57571 = state_57568;
(statearr_57571[(4)] = cljs.core.cons((5),(state_57568[(4)])));

return statearr_57571;
})();
var inst_57550 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_57568__$1 = state_57568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57568__$1,(6),inst_57550);
} else {
if((state_val_57569 === (3))){
var inst_57566 = (state_57568[(2)]);
var state_57568__$1 = state_57568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57568__$1,inst_57566);
} else {
if((state_val_57569 === (4))){
var inst_57544 = (state_57568[(2)]);
var state_57568__$1 = state_57568;
var statearr_57573_57586 = state_57568__$1;
(statearr_57573_57586[(2)] = inst_57544);

(statearr_57573_57586[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (5))){
var _ = (function (){var statearr_57574 = state_57568;
(statearr_57574[(4)] = cljs.core.rest((state_57568[(4)])));

return statearr_57574;
})();
var state_57568__$1 = state_57568;
var ex57572 = (state_57568__$1[(2)]);
var statearr_57575_57587 = state_57568__$1;
(statearr_57575_57587[(5)] = ex57572);


if((ex57572 instanceof Error)){
var statearr_57576_57588 = state_57568__$1;
(statearr_57576_57588[(1)] = (4));

(statearr_57576_57588[(5)] = null);

} else {
throw ex57572;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57569 === (6))){
var inst_57552 = (state_57568[(2)]);
var inst_57553 = fluree.db.util.async.throw_err(inst_57552);
var inst_57554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57555 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57557 = [compare_val,new_val];
var inst_57558 = (new cljs.core.PersistentVector(null,2,(5),inst_57556,inst_57557,null));
var inst_57559 = ["",inst_57558,inst_57553];
var inst_57560 = cljs.core.PersistentHashMap.fromArrays(inst_57555,inst_57559);
var inst_57561 = [inst_57560,(10)];
var inst_57562 = (new cljs.core.PersistentVector(null,2,(5),inst_57554,inst_57561,null));
var inst_57563 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_57562);
var _ = (function (){var statearr_57577 = state_57568;
(statearr_57577[(4)] = cljs.core.rest((state_57568[(4)])));

return statearr_57577;
})();
var state_57568__$1 = (function (){var statearr_57578 = state_57568;
(statearr_57578[(7)] = inst_57563);

return statearr_57578;
})();
var statearr_57579_57589 = state_57568__$1;
(statearr_57579_57589[(2)] = inst_57553);

(statearr_57579_57589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0 = (function (){
var statearr_57580 = [null,null,null,null,null,null,null,null];
(statearr_57580[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__);

(statearr_57580[(1)] = (1));

return statearr_57580;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1 = (function (state_57568){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_57568);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e57581){var ex__2730__auto__ = e57581;
var statearr_57582_57590 = state_57568;
(statearr_57582_57590[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_57568[(4)]))){
var statearr_57583_57591 = state_57568;
(statearr_57583_57591[(1)] = cljs.core.first((state_57568[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57592 = state_57568;
state_57568 = G__57592;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__ = function(state_57568){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1.call(this,state_57568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_57584 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_57584[(6)] = c__2749__auto__);

return statearr_57584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
