// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__68446 = arguments.length;
switch (G__68446) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68491){
var state_val_68492 = (state_68491[(1)]);
if((state_val_68492 === (7))){
var inst_68461 = typeof user === 'string';
var state_68491__$1 = state_68491;
if(cljs.core.truth_(inst_68461)){
var statearr_68493_68522 = state_68491__$1;
(statearr_68493_68522[(1)] = (9));

} else {
var statearr_68494_68523 = state_68491__$1;
(statearr_68494_68523[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (1))){
var state_68491__$1 = state_68491;
var statearr_68495_68524 = state_68491__$1;
(statearr_68495_68524[(2)] = null);

(statearr_68495_68524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (4))){
var inst_68447 = (state_68491[(2)]);
var inst_68448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68449 = [inst_68447];
var inst_68450 = (new cljs.core.PersistentVector(null,1,(5),inst_68448,inst_68449,null));
var inst_68451 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68450);
var inst_68452 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68447) : reject.call(null,inst_68447));
var state_68491__$1 = (function (){var statearr_68496 = state_68491;
(statearr_68496[(7)] = inst_68451);

return statearr_68496;
})();
var statearr_68497_68525 = state_68491__$1;
(statearr_68497_68525[(2)] = inst_68452);

(statearr_68497_68525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (15))){
var inst_68480 = (state_68491[(2)]);
var inst_68481 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_68480);
var inst_68482 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68483 = cljs.core.constantly(inst_68481);
var inst_68484 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68482,inst_68483);
var inst_68485 = fluree.db.connection.add_token(conn,inst_68481);
var inst_68486 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_68480) : resolve.call(null,inst_68480));
var _ = (function (){var statearr_68498 = state_68491;
(statearr_68498[(4)] = cljs.core.rest((state_68491[(4)])));

return statearr_68498;
})();
var state_68491__$1 = (function (){var statearr_68499 = state_68491;
(statearr_68499[(8)] = inst_68484);

(statearr_68499[(9)] = inst_68485);

return statearr_68499;
})();
var statearr_68500_68526 = state_68491__$1;
(statearr_68500_68526[(2)] = inst_68486);

(statearr_68500_68526[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (13))){
var state_68491__$1 = state_68491;
var statearr_68501_68527 = state_68491__$1;
(statearr_68501_68527[(2)] = null);

(statearr_68501_68527[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (6))){
var state_68491__$1 = state_68491;
var statearr_68502_68528 = state_68491__$1;
(statearr_68502_68528[(2)] = user);

(statearr_68502_68528[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (3))){
var inst_68489 = (state_68491[(2)]);
var state_68491__$1 = state_68491;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68491__$1,inst_68489);
} else {
if((state_val_68492 === (12))){
var state_68491__$1 = state_68491;
var statearr_68503_68529 = state_68491__$1;
(statearr_68503_68529[(2)] = user);

(statearr_68503_68529[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (2))){
var _ = (function (){var statearr_68504 = state_68491;
(statearr_68504[(4)] = cljs.core.cons((5),(state_68491[(4)])));

return statearr_68504;
})();
var inst_68458 = typeof user === 'number';
var state_68491__$1 = state_68491;
if(cljs.core.truth_(inst_68458)){
var statearr_68505_68530 = state_68491__$1;
(statearr_68505_68530[(1)] = (6));

} else {
var statearr_68506_68531 = state_68491__$1;
(statearr_68506_68531[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (11))){
var inst_68472 = (state_68491[(2)]);
var state_68491__$1 = state_68491;
var statearr_68508_68532 = state_68491__$1;
(statearr_68508_68532[(2)] = inst_68472);

(statearr_68508_68532[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (9))){
var inst_68463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68464 = ["_user/username",user];
var inst_68465 = (new cljs.core.PersistentVector(null,2,(5),inst_68463,inst_68464,null));
var state_68491__$1 = state_68491;
var statearr_68509_68533 = state_68491__$1;
(statearr_68509_68533[(2)] = inst_68465);

(statearr_68509_68533[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (5))){
var _ = (function (){var statearr_68510 = state_68491;
(statearr_68510[(4)] = cljs.core.rest((state_68491[(4)])));

return statearr_68510;
})();
var state_68491__$1 = state_68491;
var ex68507 = (state_68491__$1[(2)]);
var statearr_68511_68534 = state_68491__$1;
(statearr_68511_68534[(5)] = ex68507);


var statearr_68512_68535 = state_68491__$1;
(statearr_68512_68535[(1)] = (4));

(statearr_68512_68535[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (14))){
var inst_68470 = (state_68491[(2)]);
var state_68491__$1 = state_68491;
var statearr_68513_68536 = state_68491__$1;
(statearr_68513_68536[(2)] = inst_68470);

(statearr_68513_68536[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (10))){
var state_68491__$1 = state_68491;
var statearr_68514_68537 = state_68491__$1;
(statearr_68514_68537[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68492 === (8))){
var inst_68474 = (state_68491[(2)]);
var inst_68475 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_68476 = [account,inst_68474,password,expireSeconds,syncTo];
var inst_68477 = cljs.core.PersistentHashMap.fromArrays(inst_68475,inst_68476);
var inst_68478 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_68477);
var state_68491__$1 = state_68491;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68491__$1,(15),inst_68478);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_68516 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68516[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_68516[(1)] = (1));

return statearr_68516;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_68491){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68491);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68517){var ex__2730__auto__ = e68517;
var statearr_68518_68538 = state_68491;
(statearr_68518_68538[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68491[(4)]))){
var statearr_68519_68539 = state_68491;
(statearr_68519_68539[(1)] = cljs.core.first((state_68491[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68540 = state_68491;
state_68491 = G__68540;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_68491){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_68491);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68520 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68520[(6)] = c__2749__auto__);

return statearr_68520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__68542 = arguments.length;
switch (G__68542) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68551){
var state_val_68552 = (state_68551[(1)]);
if((state_val_68552 === (1))){
var inst_68543 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68545 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_68546 = (new cljs.core.PersistentVector(null,4,(5),inst_68544,inst_68545,null));
var inst_68547 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68543,inst_68546);
var inst_68548 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__68553 = cljs.core.seq(cljs.core.keys(x));
var chunk__68554 = null;
var count__68555 = (0);
var i__68556 = (0);
while(true){
if((i__68556 < count__68555)){
var k = chunk__68554.cljs$core$IIndexed$_nth$arity$2(null,i__68556);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__68564 = seq__68553;
var G__68565 = chunk__68554;
var G__68566 = count__68555;
var G__68567 = (i__68556 + (1));
seq__68553 = G__68564;
chunk__68554 = G__68565;
count__68555 = G__68566;
i__68556 = G__68567;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__68553);
if(temp__5804__auto__){
var seq__68553__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__68553__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__68553__$1);
var G__68568 = cljs.core.chunk_rest(seq__68553__$1);
var G__68569 = c__5568__auto__;
var G__68570 = cljs.core.count(c__5568__auto__);
var G__68571 = (0);
seq__68553 = G__68568;
chunk__68554 = G__68569;
count__68555 = G__68570;
i__68556 = G__68571;
continue;
} else {
var k = cljs.core.first(seq__68553__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__68572 = cljs.core.next(seq__68553__$1);
var G__68573 = null;
var G__68574 = (0);
var G__68575 = (0);
seq__68553 = G__68572;
chunk__68554 = G__68573;
count__68555 = G__68574;
i__68556 = G__68575;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_68549 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_68548);
var state_68551__$1 = (function (){var statearr_68557 = state_68551;
(statearr_68557[(7)] = inst_68547);

return statearr_68557;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_68551__$1,inst_68549);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_68558 = [null,null,null,null,null,null,null,null];
(statearr_68558[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_68558[(1)] = (1));

return statearr_68558;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_68551){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68551);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68559){var ex__2730__auto__ = e68559;
var statearr_68560_68576 = state_68551;
(statearr_68560_68576[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68551[(4)]))){
var statearr_68561_68577 = state_68551;
(statearr_68561_68577[(1)] = cljs.core.first((state_68551[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68578 = state_68551;
state_68551 = G__68578;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_68551){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_68551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68562 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68562[(6)] = c__2749__auto__);

return statearr_68562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__68580 = arguments.length;
switch (G__68580) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68617){
var state_val_68618 = (state_68617[(1)]);
if((state_val_68618 === (1))){
var state_68617__$1 = state_68617;
var statearr_68619_68640 = state_68617__$1;
(statearr_68619_68640[(2)] = null);

(statearr_68619_68640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68618 === (2))){
var _ = (function (){var statearr_68620 = state_68617;
(statearr_68620[(4)] = cljs.core.cons((5),(state_68617[(4)])));

return statearr_68620;
})();
var inst_68592 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_68593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68594 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_68595 = (new cljs.core.PersistentVector(null,1,(5),inst_68593,inst_68594,null));
var inst_68596 = cljs.core.PersistentHashMap.EMPTY;
var inst_68597 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_68596);
var inst_68598 = cljs.core.assoc_in(inst_68592,inst_68595,inst_68597);
var inst_68599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68600 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_68601 = (new cljs.core.PersistentVector(null,1,(5),inst_68599,inst_68600,null));
var inst_68602 = cljs.core.PersistentHashMap.EMPTY;
var inst_68603 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_68602);
var inst_68604 = cljs.core.assoc_in(inst_68598,inst_68601,inst_68603);
var inst_68605 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_68606 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_68604);
var inst_68607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68608 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_68605,null];
var inst_68609 = (new cljs.core.PersistentVector(null,4,(5),inst_68607,inst_68608,null));
var inst_68610 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68606,inst_68609);
var inst_68611 = (function (){var conn = inst_68604;
var pc = inst_68605;
return (function (x){
if((x == null)){
} else {
var seq__68621_68641 = cljs.core.seq(cljs.core.keys(x));
var chunk__68622_68642 = null;
var count__68623_68643 = (0);
var i__68624_68644 = (0);
while(true){
if((i__68624_68644 < count__68623_68643)){
var k_68645 = chunk__68622_68642.cljs$core$IIndexed$_nth$arity$2(null,i__68624_68644);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_68645], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_68645,null));


var G__68646 = seq__68621_68641;
var G__68647 = chunk__68622_68642;
var G__68648 = count__68623_68643;
var G__68649 = (i__68624_68644 + (1));
seq__68621_68641 = G__68646;
chunk__68622_68642 = G__68647;
count__68623_68643 = G__68648;
i__68624_68644 = G__68649;
continue;
} else {
var temp__5804__auto___68650 = cljs.core.seq(seq__68621_68641);
if(temp__5804__auto___68650){
var seq__68621_68651__$1 = temp__5804__auto___68650;
if(cljs.core.chunked_seq_QMARK_(seq__68621_68651__$1)){
var c__5568__auto___68652 = cljs.core.chunk_first(seq__68621_68651__$1);
var G__68653 = cljs.core.chunk_rest(seq__68621_68651__$1);
var G__68654 = c__5568__auto___68652;
var G__68655 = cljs.core.count(c__5568__auto___68652);
var G__68656 = (0);
seq__68621_68641 = G__68653;
chunk__68622_68642 = G__68654;
count__68623_68643 = G__68655;
i__68624_68644 = G__68656;
continue;
} else {
var k_68657 = cljs.core.first(seq__68621_68651__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_68657], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_68657,null));


var G__68658 = cljs.core.next(seq__68621_68651__$1);
var G__68659 = null;
var G__68660 = (0);
var G__68661 = (0);
seq__68621_68641 = G__68658;
chunk__68622_68642 = G__68659;
count__68623_68643 = G__68660;
i__68624_68644 = G__68661;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_68612 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68605,inst_68611);
var ___$1 = (function (){var statearr_68625 = state_68617;
(statearr_68625[(4)] = cljs.core.rest((state_68617[(4)])));

return statearr_68625;
})();
var state_68617__$1 = (function (){var statearr_68626 = state_68617;
(statearr_68626[(7)] = inst_68610);

return statearr_68626;
})();
var statearr_68627_68662 = state_68617__$1;
(statearr_68627_68662[(2)] = inst_68612);

(statearr_68627_68662[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68618 === (3))){
var inst_68615 = (state_68617[(2)]);
var state_68617__$1 = state_68617;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68617__$1,inst_68615);
} else {
if((state_val_68618 === (4))){
var inst_68581 = (state_68617[(2)]);
var inst_68582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68583 = [inst_68581];
var inst_68584 = (new cljs.core.PersistentVector(null,1,(5),inst_68582,inst_68583,null));
var inst_68585 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68584);
var inst_68586 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68581) : reject.call(null,inst_68581));
var state_68617__$1 = (function (){var statearr_68629 = state_68617;
(statearr_68629[(8)] = inst_68585);

return statearr_68629;
})();
var statearr_68630_68663 = state_68617__$1;
(statearr_68630_68663[(2)] = inst_68586);

(statearr_68630_68663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68618 === (5))){
var _ = (function (){var statearr_68631 = state_68617;
(statearr_68631[(4)] = cljs.core.rest((state_68617[(4)])));

return statearr_68631;
})();
var state_68617__$1 = state_68617;
var ex68628 = (state_68617__$1[(2)]);
var statearr_68632_68664 = state_68617__$1;
(statearr_68632_68664[(5)] = ex68628);


var statearr_68633_68665 = state_68617__$1;
(statearr_68633_68665[(1)] = (4));

(statearr_68633_68665[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_68634 = [null,null,null,null,null,null,null,null,null];
(statearr_68634[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_68634[(1)] = (1));

return statearr_68634;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_68617){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68617);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68635){var ex__2730__auto__ = e68635;
var statearr_68636_68666 = state_68617;
(statearr_68636_68666[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68617[(4)]))){
var statearr_68637_68667 = state_68617;
(statearr_68637_68667[(1)] = cljs.core.first((state_68617[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68668 = state_68617;
state_68617 = G__68668;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_68617){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_68617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68638 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68638[(6)] = c__2749__auto__);

return statearr_68638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__68670 = arguments.length;
switch (G__68670) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__68672 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68672,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68672,(1),null);
var cb_STAR_ = (function (header,data){
var G__68675 = cljs.core.clj__GT_js(header);
var G__68676 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__68675,G__68676) : callback.call(null,G__68675,G__68676));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__68677 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68677,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68677,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68730){
var state_val_68731 = (state_68730[(1)]);
if((state_val_68731 === (7))){
var inst_68691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68692 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_68693 = cljs.core.PersistentHashMap.fromArrays(inst_68691,inst_68692);
var inst_68694 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_68693);
var inst_68695 = (function(){throw inst_68694})();
var state_68730__$1 = state_68730;
var statearr_68732_68764 = state_68730__$1;
(statearr_68732_68764[(2)] = inst_68695);

(statearr_68732_68764[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (1))){
var state_68730__$1 = state_68730;
var statearr_68733_68765 = state_68730__$1;
(statearr_68733_68765[(2)] = null);

(statearr_68733_68765[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (4))){
var inst_68680 = (state_68730[(2)]);
var inst_68681 = cljs.core.clj__GT_js(inst_68680);
var inst_68682 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68681) : reject.call(null,inst_68681));
var state_68730__$1 = state_68730;
var statearr_68734_68766 = state_68730__$1;
(statearr_68734_68766[(2)] = inst_68682);

(statearr_68734_68766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (13))){
var inst_68709 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68710 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_68711 = cljs.core.PersistentHashMap.fromArrays(inst_68709,inst_68710);
var inst_68712 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_68711);
var inst_68713 = (function(){throw inst_68712})();
var state_68730__$1 = state_68730;
var statearr_68735_68767 = state_68730__$1;
(statearr_68735_68767[(2)] = inst_68713);

(statearr_68735_68767[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (6))){
var state_68730__$1 = state_68730;
var statearr_68736_68768 = state_68730__$1;
(statearr_68736_68768[(2)] = null);

(statearr_68736_68768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (3))){
var inst_68728 = (state_68730[(2)]);
var state_68730__$1 = state_68730;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68730__$1,inst_68728);
} else {
if((state_val_68731 === (12))){
var state_68730__$1 = state_68730;
var statearr_68737_68769 = state_68730__$1;
(statearr_68737_68769[(2)] = null);

(statearr_68737_68769[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (2))){
var _ = (function (){var statearr_68738 = state_68730;
(statearr_68738[(4)] = cljs.core.cons((5),(state_68730[(4)])));

return statearr_68738;
})();
var inst_68688 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_68730__$1 = state_68730;
if(cljs.core.truth_(inst_68688)){
var statearr_68739_68770 = state_68730__$1;
(statearr_68739_68770[(1)] = (6));

} else {
var statearr_68740_68771 = state_68730__$1;
(statearr_68740_68771[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (11))){
var inst_68706 = (state_68730[(2)]);
var state_68730__$1 = (function (){var statearr_68742 = state_68730;
(statearr_68742[(7)] = inst_68706);

return statearr_68742;
})();
if(cljs.core.truth_(password)){
var statearr_68743_68772 = state_68730__$1;
(statearr_68743_68772[(1)] = (12));

} else {
var statearr_68744_68773 = state_68730__$1;
(statearr_68744_68773[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (9))){
var state_68730__$1 = state_68730;
var statearr_68745_68774 = state_68730__$1;
(statearr_68745_68774[(2)] = null);

(statearr_68745_68774[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (5))){
var _ = (function (){var statearr_68746 = state_68730;
(statearr_68746[(4)] = cljs.core.rest((state_68730[(4)])));

return statearr_68746;
})();
var state_68730__$1 = state_68730;
var ex68741 = (state_68730__$1[(2)]);
var statearr_68747_68775 = state_68730__$1;
(statearr_68747_68775[(5)] = ex68741);


var statearr_68748_68776 = state_68730__$1;
(statearr_68748_68776[(1)] = (4));

(statearr_68748_68776[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (14))){
var inst_68715 = (state_68730[(2)]);
var inst_68716 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_68717 = fluree.db.util.core.without_nils(inst_68716);
var inst_68718 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_68719 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68721 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_68717,inst_68718,null];
var inst_68722 = (new cljs.core.PersistentVector(null,4,(5),inst_68720,inst_68721,null));
var inst_68723 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68719,inst_68722);
var inst_68724 = (function (){var _ = inst_68715;
var data = inst_68717;
var pc = inst_68718;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__68749 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__68749) : reject.call(null,G__68749));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__68750 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__68750) : reject.call(null,G__68750));
} else {
var G__68751 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__68751) : resolve.call(null,G__68751));

}
}
});
})();
var inst_68725 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68718,inst_68724);
var _ = (function (){var statearr_68752 = state_68730;
(statearr_68752[(4)] = cljs.core.rest((state_68730[(4)])));

return statearr_68752;
})();
var state_68730__$1 = (function (){var statearr_68753 = state_68730;
(statearr_68753[(8)] = inst_68723);

return statearr_68753;
})();
var statearr_68754_68777 = state_68730__$1;
(statearr_68754_68777[(2)] = inst_68725);

(statearr_68754_68777[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (10))){
var inst_68700 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68701 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_68702 = cljs.core.PersistentHashMap.fromArrays(inst_68700,inst_68701);
var inst_68703 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_68702);
var inst_68704 = (function(){throw inst_68703})();
var state_68730__$1 = state_68730;
var statearr_68755_68778 = state_68730__$1;
(statearr_68755_68778[(2)] = inst_68704);

(statearr_68755_68778[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68731 === (8))){
var inst_68697 = (state_68730[(2)]);
var state_68730__$1 = (function (){var statearr_68756 = state_68730;
(statearr_68756[(9)] = inst_68697);

return statearr_68756;
})();
if(cljs.core.truth_(ledger)){
var statearr_68757_68779 = state_68730__$1;
(statearr_68757_68779[(1)] = (9));

} else {
var statearr_68758_68780 = state_68730__$1;
(statearr_68758_68780[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0 = (function (){
var statearr_68759 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68759[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2727__auto__);

(statearr_68759[(1)] = (1));

return statearr_68759;
});
var fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1 = (function (state_68730){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68730);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68760){var ex__2730__auto__ = e68760;
var statearr_68761_68781 = state_68730;
(statearr_68761_68781[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68730[(4)]))){
var statearr_68762_68782 = state_68730;
(statearr_68762_68782[(1)] = cljs.core.first((state_68730[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68783 = state_68730;
state_68730 = G__68783;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__ = function(state_68730){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1.call(this,state_68730);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2727__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68763 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68763[(6)] = c__2749__auto__);

return statearr_68763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__68785 = arguments.length;
switch (G__68785) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68852){
var state_val_68853 = (state_68852[(1)]);
if((state_val_68853 === (7))){
var inst_68797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68798 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_68799 = cljs.core.PersistentHashMap.fromArrays(inst_68797,inst_68798);
var inst_68800 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_68799);
var inst_68801 = (function(){throw inst_68800})();
var state_68852__$1 = state_68852;
var statearr_68854_68896 = state_68852__$1;
(statearr_68854_68896[(2)] = inst_68801);

(statearr_68854_68896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (20))){
var inst_68835 = (state_68852[(2)]);
var inst_68836 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_68837 = [ledger,password,user,auth,expire];
var inst_68838 = cljs.core.PersistentHashMap.fromArrays(inst_68836,inst_68837);
var inst_68839 = fluree.db.util.core.without_nils(inst_68838);
var inst_68840 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_68841 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68843 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_68839,inst_68840,null];
var inst_68844 = (new cljs.core.PersistentVector(null,4,(5),inst_68842,inst_68843,null));
var inst_68845 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68841,inst_68844);
var inst_68846 = (function (){var _ = inst_68835;
var data = inst_68839;
var pc = inst_68840;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__68855 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__68855) : reject.call(null,G__68855));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__68856 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__68856) : reject.call(null,G__68856));
} else {
fluree.db.connection.add_token(conn,result);

var G__68857 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__68857) : resolve.call(null,G__68857));

}
}
});
})();
var inst_68847 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68840,inst_68846);
var _ = (function (){var statearr_68858 = state_68852;
(statearr_68858[(4)] = cljs.core.rest((state_68852[(4)])));

return statearr_68858;
})();
var state_68852__$1 = (function (){var statearr_68859 = state_68852;
(statearr_68859[(7)] = inst_68845);

return statearr_68859;
})();
var statearr_68860_68897 = state_68852__$1;
(statearr_68860_68897[(2)] = inst_68847);

(statearr_68860_68897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (1))){
var state_68852__$1 = state_68852;
var statearr_68861_68898 = state_68852__$1;
(statearr_68861_68898[(2)] = null);

(statearr_68861_68898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (4))){
var inst_68786 = (state_68852[(2)]);
var inst_68787 = cljs.core.clj__GT_js(inst_68786);
var inst_68788 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68787) : reject.call(null,inst_68787));
var state_68852__$1 = state_68852;
var statearr_68862_68899 = state_68852__$1;
(statearr_68862_68899[(2)] = inst_68788);

(statearr_68862_68899[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (15))){
var inst_68822 = (state_68852[(8)]);
var state_68852__$1 = state_68852;
var statearr_68863_68900 = state_68852__$1;
(statearr_68863_68900[(2)] = inst_68822);

(statearr_68863_68900[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (13))){
var inst_68815 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68816 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_68817 = cljs.core.PersistentHashMap.fromArrays(inst_68815,inst_68816);
var inst_68818 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_68817);
var inst_68819 = (function(){throw inst_68818})();
var state_68852__$1 = state_68852;
var statearr_68864_68901 = state_68852__$1;
(statearr_68864_68901[(2)] = inst_68819);

(statearr_68864_68901[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (6))){
var state_68852__$1 = state_68852;
var statearr_68865_68902 = state_68852__$1;
(statearr_68865_68902[(2)] = null);

(statearr_68865_68902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (17))){
var inst_68826 = (state_68852[(2)]);
var state_68852__$1 = state_68852;
if(cljs.core.truth_(inst_68826)){
var statearr_68866_68903 = state_68852__$1;
(statearr_68866_68903[(1)] = (18));

} else {
var statearr_68867_68904 = state_68852__$1;
(statearr_68867_68904[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (3))){
var inst_68850 = (state_68852[(2)]);
var state_68852__$1 = state_68852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68852__$1,inst_68850);
} else {
if((state_val_68853 === (12))){
var state_68852__$1 = state_68852;
var statearr_68868_68905 = state_68852__$1;
(statearr_68868_68905[(2)] = null);

(statearr_68868_68905[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (2))){
var _ = (function (){var statearr_68869 = state_68852;
(statearr_68869[(4)] = cljs.core.cons((5),(state_68852[(4)])));

return statearr_68869;
})();
var inst_68794 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_68852__$1 = state_68852;
if(cljs.core.truth_(inst_68794)){
var statearr_68870_68906 = state_68852__$1;
(statearr_68870_68906[(1)] = (6));

} else {
var statearr_68871_68907 = state_68852__$1;
(statearr_68871_68907[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (19))){
var inst_68829 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68830 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_68831 = cljs.core.PersistentHashMap.fromArrays(inst_68829,inst_68830);
var inst_68832 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_68831);
var inst_68833 = (function(){throw inst_68832})();
var state_68852__$1 = state_68852;
var statearr_68872_68908 = state_68852__$1;
(statearr_68872_68908[(2)] = inst_68833);

(statearr_68872_68908[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (11))){
var inst_68812 = (state_68852[(2)]);
var state_68852__$1 = (function (){var statearr_68874 = state_68852;
(statearr_68874[(9)] = inst_68812);

return statearr_68874;
})();
if(cljs.core.truth_(password)){
var statearr_68875_68909 = state_68852__$1;
(statearr_68875_68909[(1)] = (12));

} else {
var statearr_68876_68910 = state_68852__$1;
(statearr_68876_68910[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (9))){
var state_68852__$1 = state_68852;
var statearr_68877_68911 = state_68852__$1;
(statearr_68877_68911[(2)] = null);

(statearr_68877_68911[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (5))){
var _ = (function (){var statearr_68878 = state_68852;
(statearr_68878[(4)] = cljs.core.rest((state_68852[(4)])));

return statearr_68878;
})();
var state_68852__$1 = state_68852;
var ex68873 = (state_68852__$1[(2)]);
var statearr_68879_68912 = state_68852__$1;
(statearr_68879_68912[(5)] = ex68873);


var statearr_68880_68913 = state_68852__$1;
(statearr_68880_68913[(1)] = (4));

(statearr_68880_68913[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (14))){
var inst_68822 = (state_68852[(8)]);
var inst_68821 = (state_68852[(2)]);
var inst_68822__$1 = user;
var state_68852__$1 = (function (){var statearr_68881 = state_68852;
(statearr_68881[(8)] = inst_68822__$1);

(statearr_68881[(10)] = inst_68821);

return statearr_68881;
})();
if(cljs.core.truth_(inst_68822__$1)){
var statearr_68882_68914 = state_68852__$1;
(statearr_68882_68914[(1)] = (15));

} else {
var statearr_68883_68915 = state_68852__$1;
(statearr_68883_68915[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (16))){
var state_68852__$1 = state_68852;
var statearr_68884_68916 = state_68852__$1;
(statearr_68884_68916[(2)] = auth);

(statearr_68884_68916[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (10))){
var inst_68806 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68807 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_68808 = cljs.core.PersistentHashMap.fromArrays(inst_68806,inst_68807);
var inst_68809 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_68808);
var inst_68810 = (function(){throw inst_68809})();
var state_68852__$1 = state_68852;
var statearr_68885_68917 = state_68852__$1;
(statearr_68885_68917[(2)] = inst_68810);

(statearr_68885_68917[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (18))){
var state_68852__$1 = state_68852;
var statearr_68886_68918 = state_68852__$1;
(statearr_68886_68918[(2)] = null);

(statearr_68886_68918[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68853 === (8))){
var inst_68803 = (state_68852[(2)]);
var state_68852__$1 = (function (){var statearr_68887 = state_68852;
(statearr_68887[(11)] = inst_68803);

return statearr_68887;
})();
if(cljs.core.truth_(ledger)){
var statearr_68888_68919 = state_68852__$1;
(statearr_68888_68919[(1)] = (9));

} else {
var statearr_68889_68920 = state_68852__$1;
(statearr_68889_68920[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_68890 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68890[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_68890[(1)] = (1));

return statearr_68890;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_68852){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68852);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68891){var ex__2730__auto__ = e68891;
var statearr_68892_68921 = state_68852;
(statearr_68892_68921[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68852[(4)]))){
var statearr_68893_68922 = state_68852;
(statearr_68893_68922[(1)] = cljs.core.first((state_68852[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68923 = state_68852;
state_68852 = G__68923;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_68852){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_68852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68894 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68894[(6)] = c__2749__auto__);

return statearr_68894;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__68925 = arguments.length;
switch (G__68925) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68960){
var state_val_68961 = (state_68960[(1)]);
if((state_val_68961 === (1))){
var state_68960__$1 = state_68960;
var statearr_68962_68984 = state_68960__$1;
(statearr_68962_68984[(2)] = null);

(statearr_68962_68984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (2))){
var _ = (function (){var statearr_68963 = state_68960;
(statearr_68963[(4)] = cljs.core.cons((5),(state_68960[(4)])));

return statearr_68963;
})();
var inst_68934 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_68960__$1 = state_68960;
if(cljs.core.truth_(inst_68934)){
var statearr_68964_68985 = state_68960__$1;
(statearr_68964_68985[(1)] = (6));

} else {
var statearr_68965_68986 = state_68960__$1;
(statearr_68965_68986[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (3))){
var inst_68958 = (state_68960[(2)]);
var state_68960__$1 = state_68960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68960__$1,inst_68958);
} else {
if((state_val_68961 === (4))){
var inst_68926 = (state_68960[(2)]);
var inst_68927 = cljs.core.clj__GT_js(inst_68926);
var inst_68928 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_68927) : reject.call(null,inst_68927));
var state_68960__$1 = state_68960;
var statearr_68967_68987 = state_68960__$1;
(statearr_68967_68987[(2)] = inst_68928);

(statearr_68967_68987[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (5))){
var _ = (function (){var statearr_68968 = state_68960;
(statearr_68968[(4)] = cljs.core.rest((state_68960[(4)])));

return statearr_68968;
})();
var state_68960__$1 = state_68960;
var ex68966 = (state_68960__$1[(2)]);
var statearr_68969_68988 = state_68960__$1;
(statearr_68969_68988[(5)] = ex68966);


var statearr_68970_68989 = state_68960__$1;
(statearr_68970_68989[(1)] = (4));

(statearr_68970_68989[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (6))){
var state_68960__$1 = state_68960;
var statearr_68971_68990 = state_68960__$1;
(statearr_68971_68990[(2)] = null);

(statearr_68971_68990[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (7))){
var inst_68937 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68938 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_68939 = cljs.core.PersistentHashMap.fromArrays(inst_68937,inst_68938);
var inst_68940 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_68939);
var inst_68941 = (function(){throw inst_68940})();
var state_68960__$1 = state_68960;
var statearr_68972_68991 = state_68960__$1;
(statearr_68972_68991[(2)] = inst_68941);

(statearr_68972_68991[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (8))){
var inst_68943 = (state_68960[(2)]);
var inst_68944 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_68945 = [jwt,expire];
var inst_68946 = cljs.core.PersistentHashMap.fromArrays(inst_68944,inst_68945);
var inst_68947 = fluree.db.util.core.without_nils(inst_68946);
var inst_68948 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_68949 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68951 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_68947,inst_68948,null];
var inst_68952 = (new cljs.core.PersistentVector(null,4,(5),inst_68950,inst_68951,null));
var inst_68953 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68949,inst_68952);
var inst_68954 = (function (){var _ = inst_68943;
var data = inst_68947;
var pc = inst_68948;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__68973 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__68973) : reject.call(null,G__68973));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__68974 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__68974) : resolve.call(null,G__68974));

}
});
})();
var inst_68955 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_68948,inst_68954);
var _ = (function (){var statearr_68975 = state_68960;
(statearr_68975[(4)] = cljs.core.rest((state_68960[(4)])));

return statearr_68975;
})();
var state_68960__$1 = (function (){var statearr_68976 = state_68960;
(statearr_68976[(7)] = inst_68953);

return statearr_68976;
})();
var statearr_68977_68992 = state_68960__$1;
(statearr_68977_68992[(2)] = inst_68955);

(statearr_68977_68992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2727__auto__ = null;
var fluree$db$connection_js$state_machine__2727__auto____0 = (function (){
var statearr_68978 = [null,null,null,null,null,null,null,null];
(statearr_68978[(0)] = fluree$db$connection_js$state_machine__2727__auto__);

(statearr_68978[(1)] = (1));

return statearr_68978;
});
var fluree$db$connection_js$state_machine__2727__auto____1 = (function (state_68960){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68960);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68979){var ex__2730__auto__ = e68979;
var statearr_68980_68993 = state_68960;
(statearr_68980_68993[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68960[(4)]))){
var statearr_68981_68994 = state_68960;
(statearr_68981_68994[(1)] = cljs.core.first((state_68960[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68995 = state_68960;
state_68960 = G__68995;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2727__auto__ = function(state_68960){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2727__auto____1.call(this,state_68960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2727__auto____0;
fluree$db$connection_js$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2727__auto____1;
return fluree$db$connection_js$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68982 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68982[(6)] = c__2749__auto__);

return statearr_68982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

