// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__67172_67353 = cljs.core.seq(servers);
var chunk__67173_67354 = null;
var count__67174_67355 = (0);
var i__67175_67356 = (0);
while(true){
if((i__67175_67356 < count__67174_67355)){
var server_67357 = chunk__67173_67354.cljs$core$IIndexed$_nth$arity$2(null,i__67175_67356);
var healthcheck_uri_67358 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_67357),"/fdb/health"].join('');
var resp_chan_67359 = fluree.db.util.xhttp.post_json(healthcheck_uri_67358,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___67360 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67360,healthcheck_uri_67358,resp_chan_67359,server_67357){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67360,healthcheck_uri_67358,resp_chan_67359,server_67357){
return (function (state_67245){
var state_val_67246 = (state_67245[(1)]);
if((state_val_67246 === (1))){
var state_67245__$1 = state_67245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67245__$1,(2),resp_chan_67359);
} else {
if((state_val_67246 === (2))){
var inst_67231 = (state_67245[(7)]);
var inst_67231__$1 = (state_67245[(2)]);
var inst_67232 = fluree.db.util.core.exception_QMARK_(inst_67231__$1);
var state_67245__$1 = (function (){var statearr_67247 = state_67245;
(statearr_67247[(7)] = inst_67231__$1);

return statearr_67247;
})();
if(inst_67232){
var statearr_67248_67361 = state_67245__$1;
(statearr_67248_67361[(1)] = (3));

} else {
var statearr_67249_67362 = state_67245__$1;
(statearr_67249_67362[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (3))){
var inst_67231 = (state_67245[(7)]);
var inst_67234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67235 = cljs.core.ex_message(inst_67231);
var inst_67236 = cljs.core.ex_data(inst_67231);
var inst_67237 = ["Server contact error: ",inst_67235,inst_67236];
var inst_67238 = (new cljs.core.PersistentVector(null,3,(5),inst_67234,inst_67237,null));
var inst_67239 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67238);
var state_67245__$1 = state_67245;
var statearr_67250_67363 = state_67245__$1;
(statearr_67250_67363[(2)] = inst_67239);

(statearr_67250_67363[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (4))){
var inst_67241 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_67357);
var state_67245__$1 = state_67245;
var statearr_67251_67364 = state_67245__$1;
(statearr_67251_67364[(2)] = inst_67241);

(statearr_67251_67364[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67246 === (5))){
var inst_67243 = (state_67245[(2)]);
var state_67245__$1 = state_67245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67245__$1,inst_67243);
} else {
return null;
}
}
}
}
}
});})(seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67360,healthcheck_uri_67358,resp_chan_67359,server_67357))
;
return ((function (seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,switch__2726__auto__,c__2749__auto___67360,healthcheck_uri_67358,resp_chan_67359,server_67357){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_67252 = [null,null,null,null,null,null,null,null];
(statearr_67252[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_67252[(1)] = (1));

return statearr_67252;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_67245){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67245);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67253){var ex__2730__auto__ = e67253;
var statearr_67254_67365 = state_67245;
(statearr_67254_67365[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67245[(4)]))){
var statearr_67255_67366 = state_67245;
(statearr_67255_67366[(1)] = cljs.core.first((state_67245[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67367 = state_67245;
state_67245 = G__67367;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_67245){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_67245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,switch__2726__auto__,c__2749__auto___67360,healthcheck_uri_67358,resp_chan_67359,server_67357))
})();
var state__2751__auto__ = (function (){var statearr_67256 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67256[(6)] = c__2749__auto___67360);

return statearr_67256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67360,healthcheck_uri_67358,resp_chan_67359,server_67357))
);



var G__67368 = seq__67172_67353;
var G__67369 = chunk__67173_67354;
var G__67370 = count__67174_67355;
var G__67371 = (i__67175_67356 + (1));
seq__67172_67353 = G__67368;
chunk__67173_67354 = G__67369;
count__67174_67355 = G__67370;
i__67175_67356 = G__67371;
continue;
} else {
var temp__5804__auto___67372 = cljs.core.seq(seq__67172_67353);
if(temp__5804__auto___67372){
var seq__67172_67373__$1 = temp__5804__auto___67372;
if(cljs.core.chunked_seq_QMARK_(seq__67172_67373__$1)){
var c__5568__auto___67374 = cljs.core.chunk_first(seq__67172_67373__$1);
var G__67375 = cljs.core.chunk_rest(seq__67172_67373__$1);
var G__67376 = c__5568__auto___67374;
var G__67377 = cljs.core.count(c__5568__auto___67374);
var G__67378 = (0);
seq__67172_67353 = G__67375;
chunk__67173_67354 = G__67376;
count__67174_67355 = G__67377;
i__67175_67356 = G__67378;
continue;
} else {
var server_67379 = cljs.core.first(seq__67172_67373__$1);
var healthcheck_uri_67380 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_67379),"/fdb/health"].join('');
var resp_chan_67381 = fluree.db.util.xhttp.post_json(healthcheck_uri_67380,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000)], null));
var c__2749__auto___67382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67382,healthcheck_uri_67380,resp_chan_67381,server_67379,seq__67172_67373__$1,temp__5804__auto___67372){
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = ((function (seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67382,healthcheck_uri_67380,resp_chan_67381,server_67379,seq__67172_67373__$1,temp__5804__auto___67372){
return (function (state_67272){
var state_val_67273 = (state_67272[(1)]);
if((state_val_67273 === (1))){
var state_67272__$1 = state_67272;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67272__$1,(2),resp_chan_67381);
} else {
if((state_val_67273 === (2))){
var inst_67258 = (state_67272[(7)]);
var inst_67258__$1 = (state_67272[(2)]);
var inst_67259 = fluree.db.util.core.exception_QMARK_(inst_67258__$1);
var state_67272__$1 = (function (){var statearr_67274 = state_67272;
(statearr_67274[(7)] = inst_67258__$1);

return statearr_67274;
})();
if(inst_67259){
var statearr_67275_67383 = state_67272__$1;
(statearr_67275_67383[(1)] = (3));

} else {
var statearr_67276_67384 = state_67272__$1;
(statearr_67276_67384[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67273 === (3))){
var inst_67258 = (state_67272[(7)]);
var inst_67261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67262 = cljs.core.ex_message(inst_67258);
var inst_67263 = cljs.core.ex_data(inst_67258);
var inst_67264 = ["Server contact error: ",inst_67262,inst_67263];
var inst_67265 = (new cljs.core.PersistentVector(null,3,(5),inst_67261,inst_67264,null));
var inst_67266 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_67265);
var state_67272__$1 = state_67272;
var statearr_67277_67385 = state_67272__$1;
(statearr_67277_67385[(2)] = inst_67266);

(statearr_67277_67385[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67273 === (4))){
var inst_67268 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_67379);
var state_67272__$1 = state_67272;
var statearr_67278_67386 = state_67272__$1;
(statearr_67278_67386[(2)] = inst_67268);

(statearr_67278_67386[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67273 === (5))){
var inst_67270 = (state_67272[(2)]);
var state_67272__$1 = state_67272;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67272__$1,inst_67270);
} else {
return null;
}
}
}
}
}
});})(seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67382,healthcheck_uri_67380,resp_chan_67381,server_67379,seq__67172_67373__$1,temp__5804__auto___67372))
;
return ((function (seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,switch__2726__auto__,c__2749__auto___67382,healthcheck_uri_67380,resp_chan_67381,server_67379,seq__67172_67373__$1,temp__5804__auto___67372){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_67279 = [null,null,null,null,null,null,null,null];
(statearr_67279[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_67279[(1)] = (1));

return statearr_67279;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_67272){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67272);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67280){var ex__2730__auto__ = e67280;
var statearr_67281_67387 = state_67272;
(statearr_67281_67387[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67272[(4)]))){
var statearr_67282_67388 = state_67272;
(statearr_67282_67388[(1)] = cljs.core.first((state_67272[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67389 = state_67272;
state_67272 = G__67389;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_67272){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_67272);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
;})(seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,switch__2726__auto__,c__2749__auto___67382,healthcheck_uri_67380,resp_chan_67381,server_67379,seq__67172_67373__$1,temp__5804__auto___67372))
})();
var state__2751__auto__ = (function (){var statearr_67283 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67283[(6)] = c__2749__auto___67382);

return statearr_67283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});})(seq__67172_67353,chunk__67173_67354,count__67174_67355,i__67175_67356,c__2749__auto___67382,healthcheck_uri_67380,resp_chan_67381,server_67379,seq__67172_67373__$1,temp__5804__auto___67372))
);



var G__67390 = cljs.core.next(seq__67172_67373__$1);
var G__67391 = null;
var G__67392 = (0);
var G__67393 = (0);
seq__67172_67353 = G__67390;
chunk__67173_67354 = G__67391;
count__67174_67355 = G__67392;
i__67175_67356 = G__67393;
continue;
}
} else {
}
}
break;
}

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67327){
var state_val_67328 = (state_67327[(1)]);
if((state_val_67328 === (7))){
var inst_67299 = (state_67327[(7)]);
var inst_67306 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67299,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_67327__$1 = state_67327;
if(inst_67306){
var statearr_67329_67394 = state_67327__$1;
(statearr_67329_67394[(1)] = (9));

} else {
var statearr_67330_67395 = state_67327__$1;
(statearr_67330_67395[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (1))){
var inst_67292 = (state_67327[(8)]);
var inst_67291 = (state_67327[(9)]);
var inst_67291__$1 = promise_chan;
var inst_67292__$1 = cljs.core.async.timeout((60000));
var inst_67293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67294 = [inst_67291__$1,inst_67292__$1];
var inst_67295 = (new cljs.core.PersistentVector(null,2,(5),inst_67293,inst_67294,null));
var state_67327__$1 = (function (){var statearr_67331 = state_67327;
(statearr_67331[(8)] = inst_67292__$1);

(statearr_67331[(9)] = inst_67291__$1);

return statearr_67331;
})();
return cljs.core.async.ioc_alts_BANG_(state_67327__$1,(2),inst_67295);
} else {
if((state_val_67328 === (4))){
var inst_67299 = (state_67327[(7)]);
var inst_67292 = (state_67327[(8)]);
var inst_67303 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67299,inst_67292);
var state_67327__$1 = state_67327;
if(inst_67303){
var statearr_67332_67396 = state_67327__$1;
(statearr_67332_67396[(1)] = (6));

} else {
var statearr_67333_67397 = state_67327__$1;
(statearr_67333_67397[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (13))){
var state_67327__$1 = state_67327;
var statearr_67334_67398 = state_67327__$1;
(statearr_67334_67398[(2)] = null);

(statearr_67334_67398[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (6))){
var state_67327__$1 = state_67327;
var statearr_67335_67399 = state_67327__$1;
(statearr_67335_67399[(2)] = new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715));

(statearr_67335_67399[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (3))){
var state_67327__$1 = state_67327;
var statearr_67336_67400 = state_67327__$1;
(statearr_67336_67400[(2)] = new cljs.core.Keyword("fluree.db.connection","server-found","fluree.db.connection/server-found",-972719416));

(statearr_67336_67400[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (12))){
var inst_67317 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"server","server",1499190120)], 0));
var inst_67318 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67319 = [(500),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_67320 = cljs.core.PersistentHashMap.fromArrays(inst_67318,inst_67319);
var inst_67321 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_67320);
var inst_67322 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_67321);
var state_67327__$1 = (function (){var statearr_67337 = state_67327;
(statearr_67337[(10)] = inst_67317);

return statearr_67337;
})();
var statearr_67338_67401 = state_67327__$1;
(statearr_67338_67401[(2)] = inst_67322);

(statearr_67338_67401[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (2))){
var inst_67299 = (state_67327[(7)]);
var inst_67291 = (state_67327[(9)]);
var inst_67297 = (state_67327[(2)]);
var inst_67298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67297,(0),null);
var inst_67299__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67297,(1),null);
var inst_67300 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67299__$1,inst_67291);
var state_67327__$1 = (function (){var statearr_67339 = state_67327;
(statearr_67339[(7)] = inst_67299__$1);

(statearr_67339[(11)] = inst_67298);

return statearr_67339;
})();
if(inst_67300){
var statearr_67340_67402 = state_67327__$1;
(statearr_67340_67402[(1)] = (3));

} else {
var statearr_67341_67403 = state_67327__$1;
(statearr_67341_67403[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (11))){
var inst_67310 = (state_67327[(2)]);
var state_67327__$1 = state_67327;
var statearr_67342_67404 = state_67327__$1;
(statearr_67342_67404[(2)] = inst_67310);

(statearr_67342_67404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (9))){
var inst_67298 = (state_67327[(11)]);
var state_67327__$1 = state_67327;
var statearr_67343_67405 = state_67327__$1;
(statearr_67343_67405[(2)] = inst_67298);

(statearr_67343_67405[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (5))){
var inst_67314 = (state_67327[(2)]);
var inst_67315 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword("fluree.db.connection","timeout","fluree.db.connection/timeout",-1888211715),inst_67314);
var state_67327__$1 = state_67327;
if(inst_67315){
var statearr_67344_67406 = state_67327__$1;
(statearr_67344_67406[(1)] = (12));

} else {
var statearr_67345_67407 = state_67327__$1;
(statearr_67345_67407[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (14))){
var inst_67325 = (state_67327[(2)]);
var state_67327__$1 = state_67327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67327__$1,inst_67325);
} else {
if((state_val_67328 === (10))){
var state_67327__$1 = state_67327;
var statearr_67346_67408 = state_67327__$1;
(statearr_67346_67408[(2)] = null);

(statearr_67346_67408[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67328 === (8))){
var inst_67312 = (state_67327[(2)]);
var state_67327__$1 = state_67327;
var statearr_67347_67409 = state_67327__$1;
(statearr_67347_67409[(2)] = inst_67312);

(statearr_67347_67409[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0 = (function (){
var statearr_67348 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67348[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__);

(statearr_67348[(1)] = (1));

return statearr_67348;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1 = (function (state_67327){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67327);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67349){var ex__2730__auto__ = e67349;
var statearr_67350_67410 = state_67327;
(statearr_67350_67410[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67327[(4)]))){
var statearr_67351_67411 = state_67327;
(statearr_67351_67411[(1)] = cljs.core.first((state_67327[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67412 = state_67327;
state_67327 = G__67412;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__ = function(state_67327){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1.call(this,state_67327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67352 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67352[(6)] = c__2749__auto__);

return statearr_67352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = cljs.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120)], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"chan","chan",-2103021695),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67456){
var state_val_67457 = (state_67456[(1)]);
if((state_val_67457 === (7))){
var state_67456__$1 = state_67456;
var statearr_67458_67484 = state_67456__$1;
(statearr_67458_67484[(2)] = null);

(statearr_67458_67484[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (1))){
var state_67456__$1 = state_67456;
var statearr_67459_67485 = state_67456__$1;
(statearr_67459_67485[(2)] = null);

(statearr_67459_67485[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (4))){
var inst_67413 = (state_67456[(2)]);
var state_67456__$1 = state_67456;
var statearr_67460_67486 = state_67456__$1;
(statearr_67460_67486[(2)] = inst_67413);

(statearr_67460_67486[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (6))){
var inst_67435 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_67456__$1 = state_67456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67456__$1,(9),inst_67435);
} else {
if((state_val_67457 === (3))){
var inst_67454 = (state_67456[(2)]);
var state_67456__$1 = state_67456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67456__$1,inst_67454);
} else {
if((state_val_67457 === (12))){
var inst_67448 = (state_67456[(2)]);
var state_67456__$1 = state_67456;
var statearr_67461_67487 = state_67456__$1;
(statearr_67461_67487[(2)] = inst_67448);

(statearr_67461_67487[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (2))){
var inst_67424 = (state_67456[(7)]);
var inst_67429 = (state_67456[(8)]);
var inst_67419 = (state_67456[(9)]);
var _ = (function (){var statearr_67462 = state_67456;
(statearr_67462[(4)] = cljs.core.cons((5),(state_67456[(4)])));

return statearr_67462;
})();
var inst_67419__$1 = cljs.core.random_uuid();
var inst_67420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67421 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443)];
var inst_67422 = (new cljs.core.PersistentVector(null,2,(5),inst_67420,inst_67421,null));
var inst_67423 = (function (){var lock_id = inst_67419__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lock-id","lock-id",1910364390),lock_id,new cljs.core.Keyword(null,"socket","socket",59137063),cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_67424__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_67422,inst_67423);
var inst_67425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67426 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"lock-id","lock-id",1910364390)];
var inst_67427 = (new cljs.core.PersistentVector(null,3,(5),inst_67425,inst_67426,null));
var inst_67428 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_67424__$1,inst_67427);
var inst_67429__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67419__$1,inst_67428);
var inst_67430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67431 = [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_67432 = (new cljs.core.PersistentVector(null,3,(5),inst_67430,inst_67431,null));
var inst_67433 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_67424__$1,inst_67432);
var state_67456__$1 = (function (){var statearr_67463 = state_67456;
(statearr_67463[(7)] = inst_67424__$1);

(statearr_67463[(8)] = inst_67429__$1);

(statearr_67463[(9)] = inst_67419__$1);

(statearr_67463[(10)] = inst_67433);

return statearr_67463;
})();
if(inst_67429__$1){
var statearr_67464_67488 = state_67456__$1;
(statearr_67464_67488[(1)] = (6));

} else {
var statearr_67465_67489 = state_67456__$1;
(statearr_67465_67489[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (11))){
var inst_67440 = (state_67456[(11)]);
var inst_67439 = (state_67456[(12)]);
var inst_67433 = (state_67456[(10)]);
var inst_67446 = fluree.db.util.xhttp.try_socket(inst_67439,sub_chan,pub_chan,inst_67433,(60000),inst_67440);
var state_67456__$1 = state_67456;
var statearr_67467_67490 = state_67456__$1;
(statearr_67467_67490[(2)] = inst_67446);

(statearr_67467_67490[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (9))){
var inst_67424 = (state_67456[(7)]);
var inst_67437 = (state_67456[(13)]);
var inst_67429 = (state_67456[(8)]);
var inst_67439 = (state_67456[(12)]);
var inst_67419 = (state_67456[(9)]);
var inst_67433 = (state_67456[(10)]);
var inst_67437__$1 = (state_67456[(2)]);
var inst_67438 = clojure.string.replace(inst_67437__$1,"http","ws");
var inst_67439__$1 = [inst_67438,"/fdb/ws"].join('');
var inst_67440 = (function (){var lock_id = inst_67419;
var state = inst_67424;
var have_lock_QMARK_ = inst_67429;
var resp_chan = inst_67433;
var healthy_server = inst_67437__$1;
var ws_url = inst_67439__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_67441 = fluree.db.util.core.exception_QMARK_(inst_67437__$1);
var state_67456__$1 = (function (){var statearr_67468 = state_67456;
(statearr_67468[(11)] = inst_67440);

(statearr_67468[(13)] = inst_67437__$1);

(statearr_67468[(12)] = inst_67439__$1);

return statearr_67468;
})();
if(inst_67441){
var statearr_67469_67491 = state_67456__$1;
(statearr_67469_67491[(1)] = (10));

} else {
var statearr_67470_67492 = state_67456__$1;
(statearr_67470_67492[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (5))){
var _ = (function (){var statearr_67471 = state_67456;
(statearr_67471[(4)] = cljs.core.rest((state_67456[(4)])));

return statearr_67471;
})();
var state_67456__$1 = state_67456;
var ex67466 = (state_67456__$1[(2)]);
var statearr_67472_67493 = state_67456__$1;
(statearr_67472_67493[(5)] = ex67466);


if((ex67466 instanceof Error)){
var statearr_67473_67494 = state_67456__$1;
(statearr_67473_67494[(1)] = (4));

(statearr_67473_67494[(5)] = null);

} else {
throw ex67466;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (10))){
var inst_67437 = (state_67456[(13)]);
var inst_67433 = (state_67456[(10)]);
var inst_67443 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"ws","ws",86841443)], 0));
var inst_67444 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_67433,inst_67437);
var state_67456__$1 = (function (){var statearr_67474 = state_67456;
(statearr_67474[(14)] = inst_67443);

return statearr_67474;
})();
var statearr_67475_67495 = state_67456__$1;
(statearr_67475_67495[(2)] = inst_67444);

(statearr_67475_67495[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67457 === (8))){
var inst_67433 = (state_67456[(10)]);
var inst_67451 = (state_67456[(2)]);
var _ = (function (){var statearr_67476 = state_67456;
(statearr_67476[(4)] = cljs.core.rest((state_67456[(4)])));

return statearr_67476;
})();
var state_67456__$1 = (function (){var statearr_67477 = state_67456;
(statearr_67477[(15)] = inst_67451);

return statearr_67477;
})();
var statearr_67478_67496 = state_67456__$1;
(statearr_67478_67496[(2)] = inst_67433);

(statearr_67478_67496[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_67479 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67479[(0)] = fluree$db$connection$establish_socket_$_state_machine__2727__auto__);

(statearr_67479[(1)] = (1));

return statearr_67479;
});
var fluree$db$connection$establish_socket_$_state_machine__2727__auto____1 = (function (state_67456){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67456);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67480){var ex__2730__auto__ = e67480;
var statearr_67481_67497 = state_67456;
(statearr_67481_67497[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67456[(4)]))){
var statearr_67482_67498 = state_67456;
(statearr_67482_67498[(1)] = cljs.core.first((state_67456[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67499 = state_67456;
state_67456 = G__67499;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__2727__auto__ = function(state_67456){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__2727__auto____1.call(this,state_67456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____0;
fluree$db$connection$establish_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67483 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67483[(6)] = c__2749__auto__);

return statearr_67483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {fluree.db.index.Resolver}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.storage.core.Store}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.group = group;
this.storage_read = storage_read;
this.storage_list = storage_list;
this.storage_write = storage_write;
this.storage_exists = storage_exists;
this.storage_rename = storage_rename;
this.storage_delete = storage_delete;
this.object_cache = object_cache;
this.async_cache = async_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k67501,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__67505 = k67501;
var G__67505__$1 = (((G__67505 instanceof cljs.core.Keyword))?G__67505.fqn:null);
switch (G__67505__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "group":
return self__.group;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-list":
return self__.storage_list;

break;
case "storage-write":
return self__.storage_write;

break;
case "storage-exists":
return self__.storage_exists;

break;
case "storage-rename":
return self__.storage_rename;

break;
case "storage-delete":
return self__.storage_delete;

break;
case "object-cache":
return self__.object_cache;

break;
case "async-cache":
return self__.async_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k67501,else__5346__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__67506){
var vec__67507 = p__67506;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67507,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67507,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.connection.Connection{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"group","group",582596132),self__.group],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__67500){
var self__ = this;
var G__67500__$1 = this;
return (new cljs.core.RecordIter((0),G__67500__$1,27,new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (27 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (){var fexpr__67510 = (function (coll__5340__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
});
return fexpr__67510(this__5339__auto____$1);
})();
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this67502,other67503){
var self__ = this;
var this67502__$1 = this;
return (((!((other67503 == null)))) && ((((this67502__$1.constructor === other67503.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.id,other67503.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.servers,other67503.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.state,other67503.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.req_chan,other67503.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.sub_chan,other67503.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.pub_chan,other67503.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.group,other67503.group)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.storage_read,other67503.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.storage_list,other67503.storage_list)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.storage_write,other67503.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.storage_exists,other67503.storage_exists)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.storage_rename,other67503.storage_rename)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.storage_delete,other67503.storage_delete)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.object_cache,other67503.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.async_cache,other67503.async_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.parallelism,other67503.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.serializer,other67503.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.default_network,other67503.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.transactor_QMARK_,other67503.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.publish,other67503.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.transact_handler,other67503.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.tx_private_key,other67503.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.tx_key_id,other67503.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.meta,other67503.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.add_listener,other67503.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.remove_listener,other67503.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.close,other67503.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this67502__$1.__extmap,other67503.__extmap)))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$index$Resolver$resolve$arity$2 = (function (conn,p__67511){
var self__ = this;
var map__67512 = p__67511;
var map__67512__$1 = cljs.core.__destructure_map(map__67512);
var node = map__67512__$1;
var id__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67512__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67512__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var tempid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67512__$1,new cljs.core.Keyword(null,"tempid","tempid",1427663222));
var conn__$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"empty","empty",767870958),id__$1)){
return fluree.db.storage.core.resolve_empty_leaf(node);
} else {
var G__67513 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__67514 = (function (_){
return fluree.db.storage.core.resolve_index_node.cljs$core$IFn$_invoke$arity$3(conn__$1,node,(function (){
var G__67515 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("fluree.db.connection","resolve","fluree.db.connection/resolve",1461537079),id__$1,tempid], null);
var G__67516 = null;
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__67515,G__67516) : self__.async_cache.call(null,G__67515,G__67516));
}));
});
return (self__.async_cache.cljs$core$IFn$_invoke$arity$2 ? self__.async_cache.cljs$core$IFn$_invoke$arity$2(G__67513,G__67514) : self__.async_cache.call(null,G__67513,G__67514));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 27, [new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),null,new cljs.core.Keyword(null,"default-network","default-network",586420705),null,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),null,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),null,new cljs.core.Keyword(null,"add-listener","add-listener",313698051),null,new cljs.core.Keyword(null,"group","group",582596132),null,new cljs.core.Keyword(null,"meta","meta",1499536964),null,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),null,new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),null,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),null,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),null,new cljs.core.Keyword(null,"serializer","serializer",-875689688),null,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),null,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),null,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),null,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"servers","servers",1881102005),null,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),null,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),null,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),null,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),null,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),null,new cljs.core.Keyword(null,"publish","publish",-1178026850),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k67501){
var self__ = this;
var this__5350__auto____$1 = this;
var G__67517 = k67501;
var G__67517__$1 = (((G__67517 instanceof cljs.core.Keyword))?G__67517.fqn:null);
switch (G__67517__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "group":
case "storage-read":
case "storage-list":
case "storage-write":
case "storage-exists":
case "storage-rename":
case "storage-delete":
case "object-cache":
case "async-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k67501);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__67500){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__67518 = cljs.core.keyword_identical_QMARK_;
var expr__67519 = k__5352__auto__;
if(cljs.core.truth_((function (){var G__67521 = new cljs.core.Keyword(null,"id","id",-1388402092);
var G__67522 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67521,G__67522) : pred__67518.call(null,G__67521,G__67522));
})())){
return (new fluree.db.connection.Connection(G__67500,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67523 = new cljs.core.Keyword(null,"servers","servers",1881102005);
var G__67524 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67523,G__67524) : pred__67518.call(null,G__67523,G__67524));
})())){
return (new fluree.db.connection.Connection(self__.id,G__67500,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67525 = new cljs.core.Keyword(null,"state","state",-1988618099);
var G__67526 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67525,G__67526) : pred__67518.call(null,G__67525,G__67526));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__67500,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67527 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046);
var G__67528 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67527,G__67528) : pred__67518.call(null,G__67527,G__67528));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__67500,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67529 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215);
var G__67530 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67529,G__67530) : pred__67518.call(null,G__67529,G__67530));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__67500,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67531 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593);
var G__67532 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67531,G__67532) : pred__67518.call(null,G__67531,G__67532));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__67500,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67533 = new cljs.core.Keyword(null,"group","group",582596132);
var G__67534 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67533,G__67534) : pred__67518.call(null,G__67533,G__67534));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__67500,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67535 = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537);
var G__67536 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67535,G__67536) : pred__67518.call(null,G__67535,G__67536));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,G__67500,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67537 = new cljs.core.Keyword(null,"storage-list","storage-list",1202854328);
var G__67538 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67537,G__67538) : pred__67518.call(null,G__67537,G__67538));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,G__67500,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67539 = new cljs.core.Keyword(null,"storage-write","storage-write",595144816);
var G__67540 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67539,G__67540) : pred__67518.call(null,G__67539,G__67540));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,G__67500,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67541 = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075);
var G__67542 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67541,G__67542) : pred__67518.call(null,G__67541,G__67542));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,G__67500,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67543 = new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229);
var G__67544 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67543,G__67544) : pred__67518.call(null,G__67543,G__67544));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,G__67500,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67545 = new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532);
var G__67546 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67545,G__67546) : pred__67518.call(null,G__67545,G__67546));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,G__67500,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67547 = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287);
var G__67548 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67547,G__67548) : pred__67518.call(null,G__67547,G__67548));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,G__67500,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67549 = new cljs.core.Keyword(null,"async-cache","async-cache",-190459891);
var G__67550 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67549,G__67550) : pred__67518.call(null,G__67549,G__67550));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,G__67500,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67551 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333);
var G__67552 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67551,G__67552) : pred__67518.call(null,G__67551,G__67552));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,G__67500,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67553 = new cljs.core.Keyword(null,"serializer","serializer",-875689688);
var G__67554 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67553,G__67554) : pred__67518.call(null,G__67553,G__67554));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,G__67500,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67555 = new cljs.core.Keyword(null,"default-network","default-network",586420705);
var G__67556 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67555,G__67556) : pred__67518.call(null,G__67555,G__67556));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,G__67500,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67557 = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057);
var G__67558 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67557,G__67558) : pred__67518.call(null,G__67557,G__67558));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,G__67500,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67559 = new cljs.core.Keyword(null,"publish","publish",-1178026850);
var G__67560 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67559,G__67560) : pred__67518.call(null,G__67559,G__67560));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__67500,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67561 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037);
var G__67562 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67561,G__67562) : pred__67518.call(null,G__67561,G__67562));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__67500,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67563 = new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122);
var G__67564 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67563,G__67564) : pred__67518.call(null,G__67563,G__67564));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__67500,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67565 = new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145);
var G__67566 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67565,G__67566) : pred__67518.call(null,G__67565,G__67566));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__67500,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67567 = new cljs.core.Keyword(null,"meta","meta",1499536964);
var G__67568 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67567,G__67568) : pred__67518.call(null,G__67567,G__67568));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__67500,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67569 = new cljs.core.Keyword(null,"add-listener","add-listener",313698051);
var G__67570 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67569,G__67570) : pred__67518.call(null,G__67569,G__67570));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__67500,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67571 = new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802);
var G__67572 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67571,G__67572) : pred__67518.call(null,G__67571,G__67572));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__67500,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__67573 = new cljs.core.Keyword(null,"close","close",1835149582);
var G__67574 = expr__67519;
return (pred__67518.cljs$core$IFn$_invoke$arity$2 ? pred__67518.cljs$core$IFn$_invoke$arity$2(G__67573,G__67574) : pred__67518.call(null,G__67573,G__67574));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__67500,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__67500),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"servers","servers",1881102005),self__.servers,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),self__.req_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),self__.sub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),self__.pub_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"group","group",582596132),self__.group,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),self__.storage_read,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),self__.storage_list,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-write","storage-write",595144816),self__.storage_write,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),self__.storage_exists,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),self__.storage_rename,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),self__.storage_delete,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),self__.object_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),self__.async_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),self__.parallelism,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"serializer","serializer",-875689688),self__.serializer,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"default-network","default-network",586420705),self__.default_network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"publish","publish",-1178026850),self__.publish,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),self__.transact_handler,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),self__.tx_private_key,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),self__.tx_key_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"meta","meta",1499536964),self__.meta,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"add-listener","add-listener",313698051),self__.add_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),self__.remove_listener,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$read$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_read.cljs$core$IFn$_invoke$arity$1 ? self__.storage_read.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_read.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$write$arity$3 = (function (_,k,data){
var self__ = this;
var ___$1 = this;
return (self__.storage_write.cljs$core$IFn$_invoke$arity$2 ? self__.storage_write.cljs$core$IFn$_invoke$arity$2(k,data) : self__.storage_write.call(null,k,data));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$exists_QMARK_$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_exists.cljs$core$IFn$_invoke$arity$1 ? self__.storage_exists.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_exists.call(null,k));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$rename$arity$3 = (function (_,old_key,new_key){
var self__ = this;
var ___$1 = this;
return (self__.storage_rename.cljs$core$IFn$_invoke$arity$2 ? self__.storage_rename.cljs$core$IFn$_invoke$arity$2(old_key,new_key) : self__.storage_rename.call(null,old_key,new_key));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$list$arity$2 = (function (_,d){
var self__ = this;
var ___$1 = this;
return (self__.storage_list.cljs$core$IFn$_invoke$arity$1 ? self__.storage_list.cljs$core$IFn$_invoke$arity$1(d) : self__.storage_list.call(null,d));
}));

(fluree.db.connection.Connection.prototype.fluree$db$storage$core$Store$delete$arity$2 = (function (_,k){
var self__ = this;
var ___$1 = this;
return (self__.storage_delete.cljs$core$IFn$_invoke$arity$1 ? self__.storage_delete.cljs$core$IFn$_invoke$arity$1(k) : self__.storage_delete.call(null,k));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__67500){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.group,self__.storage_read,self__.storage_list,self__.storage_write,self__.storage_exists,self__.storage_rename,self__.storage_delete,self__.object_cache,self__.async_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__67500,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"servers","servers",-773333764,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"req-chan","req-chan",1604607481,null),new cljs.core.Symbol(null,"sub-chan","sub-chan",-371906688,null),new cljs.core.Symbol(null,"pub-chan","pub-chan",1593615934,null),new cljs.core.Symbol(null,"group","group",-2071839637,null),new cljs.core.Symbol(null,"storage-read","storage-read",754838990,null),new cljs.core.Symbol(null,"storage-list","storage-list",-1451581441,null),new cljs.core.Symbol(null,"storage-write","storage-write",-2059290953,null),new cljs.core.Symbol(null,"storage-exists","storage-exists",-1251171694,null),new cljs.core.Symbol(null,"storage-rename","storage-rename",1329931298,null),new cljs.core.Symbol(null,"storage-delete","storage-delete",-1024062237,null),new cljs.core.Symbol(null,"object-cache","object-cache",-489792760,null),new cljs.core.Symbol(null,"async-cache","async-cache",1450071636,null),new cljs.core.Symbol(null,"parallelism","parallelism",709609194,null),new cljs.core.Symbol(null,"serializer","serializer",764841839,null),new cljs.core.Symbol(null,"default-network","default-network",-2068015064,null),new cljs.core.Symbol(null,"transactor?","transactor?",-260540530,null),new cljs.core.Symbol(null,"publish","publish",462504677,null),new cljs.core.Symbol(null,"transact-handler","transact-handler",895032490,null),new cljs.core.Symbol(null,"tx-private-key","tx-private-key",408863405,null),new cljs.core.Symbol(null,"tx-key-id","tx-key-id",188619382,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"add-listener","add-listener",1954229578,null),new cljs.core.Symbol(null,"remove-listener","remove-listener",1221883725,null),new cljs.core.Symbol(null,"close","close",-819286187,null)], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,group,storage_read,storage_list,storage_write,storage_exists,storage_rename,storage_delete,object_cache,async_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__67504){
var extmap__5385__auto__ = (function (){var G__67575 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__67504,new cljs.core.Keyword(null,"id","id",-1388402092),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"publish","publish",-1178026850),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"close","close",1835149582)], 0));
if(cljs.core.record_QMARK_(G__67504)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__67575);
} else {
return G__67575;
}
})();
return (new fluree.db.connection.Connection(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"group","group",582596132).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"default-network","default-network",586420705).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"publish","publish",-1178026850).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(G__67504),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__67504),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__67581 = servers_STAR_;
var vec__67582 = G__67581;
var seq__67583 = cljs.core.seq(vec__67582);
var first__67584 = cljs.core.first(seq__67583);
var seq__67583__$1 = cljs.core.next(seq__67583);
var server = first__67584;
var r = seq__67583__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__67581__$1 = G__67581;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__67588 = G__67581__$1;
var seq__67589 = cljs.core.seq(vec__67588);
var first__67590 = cljs.core.first(seq__67589);
var seq__67589__$1 = cljs.core.next(seq__67589);
var server__$1 = first__67590;
var r__$1 = seq__67589__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
}

if(cljs.core.truth_((function (){var and__5043__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__5043__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__67591 = r__$1;
var G__67592 = is_https_QMARK_;
var G__67593 = result_STAR_;
G__67581__$1 = G__67591;
https_QMARK___$1 = G__67592;
result__$1 = G__67593;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__67594 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)], null));
if((G__67594 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__67594);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67623){
var state_val_67624 = (state_67623[(1)]);
if((state_val_67624 === (7))){
var inst_67609 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_67610 = new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_67611 = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var inst_67612 = new cljs.core.Keyword(null,"servers","servers",1881102005).cljs$core$IFn$_invoke$arity$1(conn);
var inst_67613 = fluree.db.connection.establish_socket(inst_67609,inst_67610,inst_67611,inst_67612);
var state_67623__$1 = state_67623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67623__$1,(9),inst_67613);
} else {
if((state_val_67624 === (1))){
var state_67623__$1 = state_67623;
var statearr_67625_67644 = state_67623__$1;
(statearr_67625_67644[(2)] = null);

(statearr_67625_67644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67624 === (4))){
var inst_67595 = (state_67623[(2)]);
var state_67623__$1 = state_67623;
var statearr_67626_67645 = state_67623__$1;
(statearr_67626_67645[(2)] = inst_67595);

(statearr_67626_67645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67624 === (6))){
var inst_67606 = (state_67623[(7)]);
var state_67623__$1 = state_67623;
var statearr_67627_67646 = state_67623__$1;
(statearr_67627_67646[(2)] = inst_67606);

(statearr_67627_67646[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67624 === (3))){
var inst_67621 = (state_67623[(2)]);
var state_67623__$1 = state_67623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67623__$1,inst_67621);
} else {
if((state_val_67624 === (2))){
var inst_67606 = (state_67623[(7)]);
var _ = (function (){var statearr_67629 = state_67623;
(statearr_67629[(4)] = cljs.core.cons((5),(state_67623[(4)])));

return statearr_67629;
})();
var inst_67601 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_67602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67603 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_67604 = [inst_67603,new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"socket","socket",59137063)];
var inst_67605 = (new cljs.core.PersistentVector(null,3,(5),inst_67602,inst_67604,null));
var inst_67606__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_67601,inst_67605);
var state_67623__$1 = (function (){var statearr_67630 = state_67623;
(statearr_67630[(7)] = inst_67606__$1);

return statearr_67630;
})();
if(cljs.core.truth_(inst_67606__$1)){
var statearr_67631_67647 = state_67623__$1;
(statearr_67631_67647[(1)] = (6));

} else {
var statearr_67632_67648 = state_67623__$1;
(statearr_67632_67648[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67624 === (9))){
var inst_67615 = (state_67623[(2)]);
var inst_67616 = fluree.db.util.async.throw_err(inst_67615);
var state_67623__$1 = state_67623;
var statearr_67633_67649 = state_67623__$1;
(statearr_67633_67649[(2)] = inst_67616);

(statearr_67633_67649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67624 === (5))){
var _ = (function (){var statearr_67634 = state_67623;
(statearr_67634[(4)] = cljs.core.rest((state_67623[(4)])));

return statearr_67634;
})();
var state_67623__$1 = state_67623;
var ex67628 = (state_67623__$1[(2)]);
var statearr_67635_67650 = state_67623__$1;
(statearr_67635_67650[(5)] = ex67628);


if((ex67628 instanceof Error)){
var statearr_67636_67651 = state_67623__$1;
(statearr_67636_67651[(1)] = (4));

(statearr_67636_67651[(5)] = null);

} else {
throw ex67628;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67624 === (8))){
var inst_67618 = (state_67623[(2)]);
var _ = (function (){var statearr_67637 = state_67623;
(statearr_67637[(4)] = cljs.core.rest((state_67623[(4)])));

return statearr_67637;
})();
var state_67623__$1 = state_67623;
var statearr_67638_67652 = state_67623__$1;
(statearr_67638_67652[(2)] = inst_67618);

(statearr_67638_67652[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__2727__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__2727__auto____0 = (function (){
var statearr_67639 = [null,null,null,null,null,null,null,null];
(statearr_67639[(0)] = fluree$db$connection$get_socket_$_state_machine__2727__auto__);

(statearr_67639[(1)] = (1));

return statearr_67639;
});
var fluree$db$connection$get_socket_$_state_machine__2727__auto____1 = (function (state_67623){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67623);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67640){var ex__2730__auto__ = e67640;
var statearr_67641_67653 = state_67623;
(statearr_67641_67653[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67623[(4)]))){
var statearr_67642_67654 = state_67623;
(statearr_67642_67654[(1)] = cljs.core.first((state_67623[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67655 = state_67623;
state_67623 = G__67655;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__2727__auto__ = function(state_67623){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__2727__auto____1.call(this,state_67623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__2727__auto____0;
fluree$db$connection$get_socket_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__2727__auto____1;
return fluree$db$connection$get_socket_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67643 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67643[(6)] = c__2749__auto__);

return statearr_67643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__5045__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"server","server",1499190120),new cljs.core.Keyword(null,"chan","chan",-2103021695)], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593).cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e67656){var e = e67656;
fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unable to publish message on websocket. Error encoding JSON message: ",message], null));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(p__67658){
var map__67659 = p__67658;
var map__67659__$1 = cljs.core.__destructure_map(map__67659);
var conn = map__67659__$1;
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67659__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67659__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67659__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67805){
var state_val_67806 = (state_67805[(1)]);
if((state_val_67806 === (7))){
var inst_67801 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
var statearr_67808_67882 = state_67805__$1;
(statearr_67808_67882[(2)] = inst_67801);

(statearr_67808_67882[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (20))){
var _ = (function (){var statearr_67809 = state_67805;
(statearr_67809[(4)] = cljs.core.rest((state_67805[(4)])));

return statearr_67809;
})();
var state_67805__$1 = state_67805;
var ex67807 = (state_67805__$1[(2)]);
var statearr_67810_67883 = state_67805__$1;
(statearr_67810_67883[(5)] = ex67807);


var statearr_67811_67884 = state_67805__$1;
(statearr_67811_67884[(1)] = (10));

(statearr_67811_67884[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (27))){
var inst_67762 = (state_67805[(7)]);
var inst_67762__$1 = (state_67805[(2)]);
var inst_67763 = inst_67762__$1 === true;
var state_67805__$1 = (function (){var statearr_67812 = state_67805;
(statearr_67812[(7)] = inst_67762__$1);

return statearr_67812;
})();
if(cljs.core.truth_(inst_67763)){
var statearr_67813_67885 = state_67805__$1;
(statearr_67813_67885[(1)] = (28));

} else {
var statearr_67814_67886 = state_67805__$1;
(statearr_67814_67886[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (1))){
var inst_67660 = (0);
var state_67805__$1 = (function (){var statearr_67815 = state_67805;
(statearr_67815[(8)] = inst_67660);

return statearr_67815;
})();
var statearr_67816_67887 = state_67805__$1;
(statearr_67816_67887[(2)] = null);

(statearr_67816_67887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (24))){
var inst_67752 = (state_67805[(9)]);
var state_67805__$1 = state_67805;
var statearr_67817_67888 = state_67805__$1;
(statearr_67817_67888[(2)] = inst_67752);

(statearr_67817_67888[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (39))){
var inst_67787 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
var statearr_67818_67889 = state_67805__$1;
(statearr_67818_67889[(2)] = inst_67787);

(statearr_67818_67889[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (4))){
var inst_67663 = (state_67805[(10)]);
var inst_67663__$1 = (state_67805[(2)]);
var state_67805__$1 = (function (){var statearr_67819 = state_67805;
(statearr_67819[(10)] = inst_67663__$1);

return statearr_67819;
})();
if(cljs.core.truth_(inst_67663__$1)){
var statearr_67820_67890 = state_67805__$1;
(statearr_67820_67890[(1)] = (5));

} else {
var statearr_67821_67891 = state_67805__$1;
(statearr_67821_67891[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (15))){
var inst_67676 = (state_67805[(11)]);
var state_67805__$1 = state_67805;
var statearr_67822_67892 = state_67805__$1;
(statearr_67822_67892[(2)] = inst_67676);

(statearr_67822_67892[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (21))){
var inst_67706 = (state_67805[(12)]);
var inst_67708 = (state_67805[(13)]);
var inst_67710 = (state_67805[(14)]);
var inst_67713 = (state_67805[(15)]);
var inst_67663 = (state_67805[(10)]);
var inst_67709 = (state_67805[(16)]);
var inst_67705 = (state_67805[(17)]);
var inst_67707 = (state_67805[(18)]);
var inst_67660 = (state_67805[(8)]);
var inst_67714 = (state_67805[(19)]);
var inst_67716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67717 = [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_67713];
var inst_67718 = (new cljs.core.PersistentVector(null,2,(5),inst_67716,inst_67717,null));
var inst_67719 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_67718,inst_67708);
var inst_67746 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_67747 = (function (){var resp_chan = inst_67708;
var timeout = inst_67714;
var c__2749__auto____$1 = inst_67746;
var i = inst_67660;
var vec__67698 = inst_67663;
var data = inst_67707;
var map__67701 = inst_67710;
var _ = inst_67705;
var req_id = inst_67713;
var operation = inst_67706;
var msg = inst_67663;
var temp__5804__auto__ = inst_67663;
var opts = inst_67709;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67744){
var state_val_67745 = (state_67744[(1)]);
if((state_val_67745 === (1))){
var inst_67723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67724 = cljs.core.async.timeout(timeout);
var inst_67725 = [resp_chan,inst_67724];
var inst_67726 = (new cljs.core.PersistentVector(null,2,(5),inst_67723,inst_67725,null));
var state_67744__$1 = state_67744;
return cljs.core.async.ioc_alts_BANG_(state_67744__$1,(2),inst_67726);
} else {
if((state_val_67745 === (2))){
var inst_67729 = (state_67744[(7)]);
var inst_67728 = (state_67744[(2)]);
var inst_67729__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67728,(0),null);
var inst_67730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67728,(1),null);
var inst_67731 = (function (){var vec__67720 = inst_67728;
var resp = inst_67729__$1;
var c = inst_67730;
return (function (p1__67657_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__67657_SHARP_,req_id);
});
})();
var inst_67732 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),inst_67731);
var inst_67733 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67730,resp_chan);
var state_67744__$1 = (function (){var statearr_67823 = state_67744;
(statearr_67823[(8)] = inst_67732);

(statearr_67823[(7)] = inst_67729__$1);

return statearr_67823;
})();
if(inst_67733){
var statearr_67824_67893 = state_67744__$1;
(statearr_67824_67893[(1)] = (3));

} else {
var statearr_67825_67894 = state_67744__$1;
(statearr_67825_67894[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67745 === (3))){
var inst_67729 = (state_67744[(7)]);
var state_67744__$1 = state_67744;
var statearr_67826_67895 = state_67744__$1;
(statearr_67826_67895[(2)] = inst_67729);

(statearr_67826_67895[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67745 === (4))){
var inst_67736 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_67737 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67738 = [(408),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_67739 = cljs.core.PersistentHashMap.fromArrays(inst_67737,inst_67738);
var inst_67740 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67736,inst_67739);
var state_67744__$1 = state_67744;
var statearr_67827_67896 = state_67744__$1;
(statearr_67827_67896[(2)] = inst_67740);

(statearr_67827_67896[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67745 === (5))){
var inst_67742 = (state_67744[(2)]);
var state_67744__$1 = state_67744;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67744__$1,inst_67742);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_67828 = [null,null,null,null,null,null,null,null,null];
(statearr_67828[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_67828[(1)] = (1));

return statearr_67828;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_67744){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67744);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67829){var ex__2730__auto__ = e67829;
var statearr_67830_67897 = state_67744;
(statearr_67830_67897[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67744[(4)]))){
var statearr_67831_67898 = state_67744;
(statearr_67831_67898[(1)] = cljs.core.first((state_67744[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67899 = state_67744;
state_67744 = G__67899;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_67744){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_67744);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67832 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67832[(6)] = c__2749__auto____$1);

return statearr_67832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_67748 = cljs.core.async.impl.dispatch.run(inst_67747);
var state_67805__$1 = (function (){var statearr_67833 = state_67805;
(statearr_67833[(20)] = inst_67748);

(statearr_67833[(21)] = inst_67719);

return statearr_67833;
})();
var statearr_67834_67900 = state_67805__$1;
(statearr_67834_67900[(2)] = inst_67746);

(statearr_67834_67900[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (31))){
var inst_67762 = (state_67805[(7)]);
var inst_67768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67769 = [inst_67762,"Error processing message in producer."];
var inst_67770 = (new cljs.core.PersistentVector(null,2,(5),inst_67768,inst_67769,null));
var inst_67771 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_67770);
var state_67805__$1 = state_67805;
var statearr_67835_67901 = state_67805__$1;
(statearr_67835_67901[(2)] = inst_67771);

(statearr_67835_67901[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (32))){
var inst_67762 = (state_67805[(7)]);
var inst_67773 = (inst_67762 == null);
var state_67805__$1 = state_67805;
if(cljs.core.truth_(inst_67773)){
var statearr_67836_67902 = state_67805__$1;
(statearr_67836_67902[(1)] = (34));

} else {
var statearr_67837_67903 = state_67805__$1;
(statearr_67837_67903[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (33))){
var inst_67791 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
var statearr_67838_67904 = state_67805__$1;
(statearr_67838_67904[(2)] = inst_67791);

(statearr_67838_67904[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (13))){
var inst_67676 = (state_67805[(11)]);
var inst_67673 = (state_67805[(2)]);
var inst_67674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67673,(0),null);
var inst_67675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67673,(1),null);
var inst_67676__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67673,(2),null);
var state_67805__$1 = (function (){var statearr_67839 = state_67805;
(statearr_67839[(22)] = inst_67675);

(statearr_67839[(23)] = inst_67674);

(statearr_67839[(11)] = inst_67676__$1);

return statearr_67839;
})();
if(cljs.core.truth_(inst_67676__$1)){
var statearr_67840_67905 = state_67805__$1;
(statearr_67840_67905[(1)] = (14));

} else {
var statearr_67841_67906 = state_67805__$1;
(statearr_67841_67906[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (22))){
var state_67805__$1 = state_67805;
var statearr_67842_67907 = state_67805__$1;
(statearr_67842_67907[(2)] = null);

(statearr_67842_67907[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (36))){
var inst_67789 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
var statearr_67843_67908 = state_67805__$1;
(statearr_67843_67908[(2)] = inst_67789);

(statearr_67843_67908[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (29))){
var inst_67762 = (state_67805[(7)]);
var inst_67766 = fluree.db.util.core.exception_QMARK_(inst_67762);
var state_67805__$1 = state_67805;
if(inst_67766){
var statearr_67844_67909 = state_67805__$1;
(statearr_67844_67909[(1)] = (31));

} else {
var statearr_67845_67910 = state_67805__$1;
(statearr_67845_67910[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (6))){
var state_67805__$1 = state_67805;
var statearr_67846_67911 = state_67805__$1;
(statearr_67846_67911[(2)] = null);

(statearr_67846_67911[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (28))){
var state_67805__$1 = state_67805;
var statearr_67847_67912 = state_67805__$1;
(statearr_67847_67912[(2)] = null);

(statearr_67847_67912[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (25))){
var state_67805__$1 = state_67805;
var statearr_67848_67913 = state_67805__$1;
(statearr_67848_67913[(2)] = fluree.db.connection.default_publish_fn);

(statearr_67848_67913[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (34))){
var inst_67775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67776 = ["Error processing message in producer. Socket closed."];
var inst_67777 = (new cljs.core.PersistentVector(null,1,(5),inst_67775,inst_67776,null));
var inst_67778 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_67777);
var state_67805__$1 = state_67805;
var statearr_67849_67914 = state_67805__$1;
(statearr_67849_67914[(2)] = inst_67778);

(statearr_67849_67914[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (17))){
var inst_67676 = (state_67805[(11)]);
var inst_67665 = (state_67805[(24)]);
var inst_67683 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_67676,inst_67665);
var state_67805__$1 = state_67805;
var statearr_67850_67915 = state_67805__$1;
(statearr_67850_67915[(2)] = inst_67683);

(statearr_67850_67915[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (3))){
var inst_67803 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67805__$1,inst_67803);
} else {
if((state_val_67806 === (12))){
var state_67805__$1 = state_67805;
var statearr_67851_67916 = state_67805__$1;
(statearr_67851_67916[(2)] = null);

(statearr_67851_67916[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (2))){
var state_67805__$1 = state_67805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67805__$1,(4),req_chan);
} else {
if((state_val_67806 === (23))){
var inst_67752 = (state_67805[(9)]);
var inst_67751 = (state_67805[(2)]);
var inst_67752__$1 = publish;
var state_67805__$1 = (function (){var statearr_67852 = state_67805;
(statearr_67852[(9)] = inst_67752__$1);

(statearr_67852[(25)] = inst_67751);

return statearr_67852;
})();
if(cljs.core.truth_(inst_67752__$1)){
var statearr_67853_67917 = state_67805__$1;
(statearr_67853_67917[(1)] = (24));

} else {
var statearr_67854_67918 = state_67805__$1;
(statearr_67854_67918[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (35))){
var state_67805__$1 = state_67805;
var statearr_67855_67919 = state_67805__$1;
(statearr_67855_67919[(1)] = (37));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (19))){
var inst_67692 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
var statearr_67857_67920 = state_67805__$1;
(statearr_67857_67920[(2)] = inst_67692);

(statearr_67857_67920[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (11))){
var inst_67663 = (state_67805[(10)]);
var state_67805__$1 = state_67805;
var statearr_67858_67921 = state_67805__$1;
(statearr_67858_67921[(2)] = inst_67663);

(statearr_67858_67921[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (9))){
var inst_67660 = (state_67805[(8)]);
var inst_67796 = (state_67805[(2)]);
var inst_67797 = (inst_67660 + (1));
var inst_67660__$1 = inst_67797;
var state_67805__$1 = (function (){var statearr_67859 = state_67805;
(statearr_67859[(26)] = inst_67796);

(statearr_67859[(8)] = inst_67660__$1);

return statearr_67859;
})();
var statearr_67860_67922 = state_67805__$1;
(statearr_67860_67922[(2)] = null);

(statearr_67860_67922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (5))){
var state_67805__$1 = state_67805;
var statearr_67861_67923 = state_67805__$1;
(statearr_67861_67923[(2)] = null);

(statearr_67861_67923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (14))){
var inst_67676 = (state_67805[(11)]);
var inst_67678 = fluree.db.util.async.channel_QMARK_(inst_67676);
var state_67805__$1 = state_67805;
var statearr_67862_67924 = state_67805__$1;
(statearr_67862_67924[(2)] = inst_67678);

(statearr_67862_67924[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (26))){
var inst_67706 = (state_67805[(12)]);
var inst_67713 = (state_67805[(15)]);
var inst_67707 = (state_67805[(18)]);
var inst_67756 = (state_67805[(2)]);
var inst_67757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67758 = [inst_67706,inst_67713,inst_67707];
var inst_67759 = (new cljs.core.PersistentVector(null,3,(5),inst_67757,inst_67758,null));
var inst_67760 = (inst_67756.cljs$core$IFn$_invoke$arity$2 ? inst_67756.cljs$core$IFn$_invoke$arity$2(conn,inst_67759) : inst_67756.call(null,conn,inst_67759));
var state_67805__$1 = state_67805;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67805__$1,(27),inst_67760);
} else {
if((state_val_67806 === (16))){
var inst_67681 = (state_67805[(2)]);
var state_67805__$1 = state_67805;
if(cljs.core.truth_(inst_67681)){
var statearr_67863_67925 = state_67805__$1;
(statearr_67863_67925[(1)] = (17));

} else {
var statearr_67864_67926 = state_67805__$1;
(statearr_67864_67926[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (38))){
var state_67805__$1 = state_67805;
var statearr_67865_67927 = state_67805__$1;
(statearr_67865_67927[(2)] = null);

(statearr_67865_67927[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (30))){
var inst_67793 = (state_67805[(2)]);
var _ = (function (){var statearr_67866 = state_67805;
(statearr_67866[(4)] = cljs.core.rest((state_67805[(4)])));

return statearr_67866;
})();
var state_67805__$1 = state_67805;
var statearr_67867_67928 = state_67805__$1;
(statearr_67867_67928[(2)] = inst_67793);

(statearr_67867_67928[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (10))){
var inst_67663 = (state_67805[(10)]);
var inst_67665 = (state_67805[(2)]);
var inst_67669 = cljs.core.sequential_QMARK_(inst_67663);
var state_67805__$1 = (function (){var statearr_67868 = state_67805;
(statearr_67868[(24)] = inst_67665);

return statearr_67868;
})();
if(inst_67669){
var statearr_67869_67929 = state_67805__$1;
(statearr_67869_67929[(1)] = (11));

} else {
var statearr_67870_67930 = state_67805__$1;
(statearr_67870_67930[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (18))){
var inst_67663 = (state_67805[(10)]);
var inst_67665 = (state_67805[(24)]);
var inst_67685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67686 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_67663], 0));
var inst_67687 = ["Error processing ledger request, no valid return channel: ",inst_67686].join('');
var inst_67688 = [inst_67665,inst_67687];
var inst_67689 = (new cljs.core.PersistentVector(null,2,(5),inst_67685,inst_67688,null));
var inst_67690 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_67689);
var state_67805__$1 = state_67805;
var statearr_67871_67931 = state_67805__$1;
(statearr_67871_67931[(2)] = inst_67690);

(statearr_67871_67931[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (37))){
var inst_67762 = (state_67805[(7)]);
var inst_67781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67782 = ["Error processing message in producer. Socket closed. Published result",inst_67762];
var inst_67783 = (new cljs.core.PersistentVector(null,2,(5),inst_67781,inst_67782,null));
var inst_67784 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_67783);
var state_67805__$1 = state_67805;
var statearr_67872_67932 = state_67805__$1;
(statearr_67872_67932[(2)] = inst_67784);

(statearr_67872_67932[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67806 === (8))){
var inst_67708 = (state_67805[(13)]);
var inst_67710 = (state_67805[(14)]);
var inst_67663 = (state_67805[(10)]);
var inst_67709 = (state_67805[(16)]);
var _ = (function (){var statearr_67873 = state_67805;
(statearr_67873[(4)] = cljs.core.cons((20),(state_67805[(4)])));

return statearr_67873;
})();
var inst_67702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67703 = ["Outgoing message to websocket: ",inst_67663];
var inst_67704 = (new cljs.core.PersistentVector(null,2,(5),inst_67702,inst_67703,null));
var inst_67705 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_67704);
var inst_67706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67663,(0),null);
var inst_67707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67663,(1),null);
var inst_67708__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67663,(2),null);
var inst_67709__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67663,(3),null);
var inst_67710__$1 = cljs.core.__destructure_map(inst_67709__$1);
var inst_67711 = cljs.core.random_uuid();
var inst_67712 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_67711);
var inst_67713 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_67710__$1,new cljs.core.Keyword(null,"req-id","req-id",-471642231),inst_67712);
var inst_67714 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_67710__$1,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var state_67805__$1 = (function (){var statearr_67874 = state_67805;
(statearr_67874[(12)] = inst_67706);

(statearr_67874[(13)] = inst_67708__$1);

(statearr_67874[(14)] = inst_67710__$1);

(statearr_67874[(15)] = inst_67713);

(statearr_67874[(16)] = inst_67709__$1);

(statearr_67874[(17)] = inst_67705);

(statearr_67874[(18)] = inst_67707);

(statearr_67874[(19)] = inst_67714);

return statearr_67874;
})();
if(cljs.core.truth_(inst_67708__$1)){
var statearr_67875_67933 = state_67805__$1;
(statearr_67875_67933[(1)] = (21));

} else {
var statearr_67876_67934 = state_67805__$1;
(statearr_67876_67934[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____0 = (function (){
var statearr_67877 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67877[(0)] = fluree$db$connection$msg_producer_$_state_machine__2727__auto__);

(statearr_67877[(1)] = (1));

return statearr_67877;
});
var fluree$db$connection$msg_producer_$_state_machine__2727__auto____1 = (function (state_67805){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67805);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67878){var ex__2730__auto__ = e67878;
var statearr_67879_67935 = state_67805;
(statearr_67879_67935[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67805[(4)]))){
var statearr_67880_67936 = state_67805;
(statearr_67880_67936[(1)] = cljs.core.first((state_67805[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67937 = state_67805;
state_67805 = G__67937;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__2727__auto__ = function(state_67805){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__2727__auto____1.call(this,state_67805);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_producer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67881 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67881[(6)] = c__2749__auto__);

return statearr_67881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(req_chan){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ping","ping",-1670114784),true], null));
});
/**
 * Returns a channel that will eventually have a websocket. Will exponentially backoff
 *   until connection attempts happen every two minutes. Uses the existing conn and will
 *   reuse the existing sub-chan and pub-chan so the msg-consumer/producer loops do not
 *   need to be restarted.
 */
fluree.db.connection.reconnect_conn = (function fluree$db$connection$reconnect_conn(conn){
fluree.db.connection.close_websocket(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn));

var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_67975){
var state_val_67976 = (state_67975[(1)]);
if((state_val_67976 === (7))){
var inst_67946 = (state_67975[(7)]);
var state_67975__$1 = state_67975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67975__$1,(9),inst_67946);
} else {
if((state_val_67976 === (1))){
var inst_67938 = (1);
var state_67975__$1 = (function (){var statearr_67977 = state_67975;
(statearr_67977[(8)] = inst_67938);

return statearr_67977;
})();
var statearr_67978_68001 = state_67975__$1;
(statearr_67978_68001[(2)] = null);

(statearr_67978_68001[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (4))){
var inst_67943 = (state_67975[(2)]);
var inst_67944 = fluree.db.connection.get_socket(conn);
var state_67975__$1 = (function (){var statearr_67979 = state_67975;
(statearr_67979[(9)] = inst_67943);

return statearr_67979;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67975__$1,(5),inst_67944);
} else {
if((state_val_67976 === (15))){
var inst_67971 = (state_67975[(2)]);
var state_67975__$1 = state_67975;
var statearr_67980_68002 = state_67975__$1;
(statearr_67980_68002[(2)] = inst_67971);

(statearr_67980_68002[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (13))){
var inst_67938 = (state_67975[(8)]);
var inst_67953 = (state_67975[(10)]);
var inst_67961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67962 = [inst_67953,"Cannot establish connection to a healthy server, backing off:",inst_67938,"s."];
var inst_67963 = (new cljs.core.PersistentVector(null,4,(5),inst_67961,inst_67962,null));
var inst_67964 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_67963);
var inst_67965 = ((2) * inst_67938);
var inst_67966 = ((60) * (2));
var inst_67967 = ((inst_67965 < inst_67966) ? inst_67965 : inst_67966);
var inst_67938__$1 = inst_67967;
var state_67975__$1 = (function (){var statearr_67981 = state_67975;
(statearr_67981[(8)] = inst_67938__$1);

(statearr_67981[(11)] = inst_67964);

return statearr_67981;
})();
var statearr_67982_68003 = state_67975__$1;
(statearr_67982_68003[(2)] = null);

(statearr_67982_68003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (6))){
var inst_67946 = (state_67975[(7)]);
var state_67975__$1 = state_67975;
var statearr_67983_68004 = state_67975__$1;
(statearr_67983_68004[(2)] = inst_67946);

(statearr_67983_68004[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (3))){
var inst_67973 = (state_67975[(2)]);
var state_67975__$1 = state_67975;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67975__$1,inst_67973);
} else {
if((state_val_67976 === (12))){
var inst_67959 = (state_67975[(2)]);
var state_67975__$1 = state_67975;
if(cljs.core.truth_(inst_67959)){
var statearr_67984_68005 = state_67975__$1;
(statearr_67984_68005[(1)] = (13));

} else {
var statearr_67985_68006 = state_67975__$1;
(statearr_67985_68006[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (2))){
var inst_67938 = (state_67975[(8)]);
var inst_67940 = (inst_67938 * (1000));
var inst_67941 = cljs.core.async.timeout(inst_67940);
var state_67975__$1 = state_67975;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67975__$1,(4),inst_67941);
} else {
if((state_val_67976 === (11))){
var inst_67953 = (state_67975[(10)]);
var inst_67957 = fluree.db.util.core.exception_QMARK_(inst_67953);
var state_67975__$1 = state_67975;
var statearr_67986_68007 = state_67975__$1;
(statearr_67986_68007[(2)] = inst_67957);

(statearr_67986_68007[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (9))){
var inst_67951 = (state_67975[(2)]);
var state_67975__$1 = state_67975;
var statearr_67987_68008 = state_67975__$1;
(statearr_67987_68008[(2)] = inst_67951);

(statearr_67987_68008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (5))){
var inst_67946 = (state_67975[(7)]);
var inst_67946__$1 = (state_67975[(2)]);
var inst_67947 = fluree.db.util.core.exception_QMARK_(inst_67946__$1);
var state_67975__$1 = (function (){var statearr_67988 = state_67975;
(statearr_67988[(7)] = inst_67946__$1);

return statearr_67988;
})();
if(inst_67947){
var statearr_67989_68009 = state_67975__$1;
(statearr_67989_68009[(1)] = (6));

} else {
var statearr_67990_68010 = state_67975__$1;
(statearr_67990_68010[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (14))){
var inst_67953 = (state_67975[(10)]);
var state_67975__$1 = state_67975;
var statearr_67991_68011 = state_67975__$1;
(statearr_67991_68011[(2)] = inst_67953);

(statearr_67991_68011[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (10))){
var inst_67954 = (state_67975[(12)]);
var state_67975__$1 = state_67975;
var statearr_67992_68012 = state_67975__$1;
(statearr_67992_68012[(2)] = inst_67954);

(statearr_67992_68012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67976 === (8))){
var inst_67954 = (state_67975[(12)]);
var inst_67953 = (state_67975[(10)]);
var inst_67953__$1 = (state_67975[(2)]);
var inst_67954__$1 = (inst_67953__$1 == null);
var state_67975__$1 = (function (){var statearr_67993 = state_67975;
(statearr_67993[(12)] = inst_67954__$1);

(statearr_67993[(10)] = inst_67953__$1);

return statearr_67993;
})();
if(cljs.core.truth_(inst_67954__$1)){
var statearr_67994_68013 = state_67975__$1;
(statearr_67994_68013[(1)] = (10));

} else {
var statearr_67995_68014 = state_67975__$1;
(statearr_67995_68014[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0 = (function (){
var statearr_67996 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67996[(0)] = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__);

(statearr_67996[(1)] = (1));

return statearr_67996;
});
var fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1 = (function (state_67975){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_67975);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67997){var ex__2730__auto__ = e67997;
var statearr_67998_68015 = state_67975;
(statearr_67998_68015[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_67975[(4)]))){
var statearr_67999_68016 = state_67975;
(statearr_67999_68016[(1)] = cljs.core.first((state_67975[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68017 = state_67975;
state_67975 = G__68017;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__ = function(state_67975){
switch(arguments.length){
case 0:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1.call(this,state_67975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____0;
fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$reconnect_conn_$_state_machine__2727__auto____1;
return fluree$db$connection$reconnect_conn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68000 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68000[(6)] = c__2749__auto__);

return statearr_68000;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(p__68018){
var map__68019 = p__68018;
var map__68019__$1 = cljs.core.__destructure_map(map__68019);
var conn = map__68019__$1;
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68019__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215));
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68019__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68019__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68019__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var ping_transactor_after = (2500);
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68130){
var state_val_68131 = (state_68130[(1)]);
if((state_val_68131 === (7))){
var inst_68126 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68132_68188 = state_68130__$1;
(statearr_68132_68188[(2)] = inst_68126);

(statearr_68132_68188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (20))){
var inst_68077 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68133_68189 = state_68130__$1;
(statearr_68133_68189[(2)] = inst_68077);

(statearr_68133_68189[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (27))){
var inst_68095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68096 = ["Connection closed."];
var inst_68097 = (new cljs.core.PersistentVector(null,1,(5),inst_68095,inst_68096,null));
var inst_68098 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),inst_68097);
var state_68130__$1 = state_68130;
var statearr_68134_68190 = state_68130__$1;
(statearr_68134_68190[(2)] = inst_68098);

(statearr_68134_68190[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (1))){
var inst_68020 = (0);
var state_68130__$1 = (function (){var statearr_68135 = state_68130;
(statearr_68135[(7)] = inst_68020);

return statearr_68135;
})();
var statearr_68136_68191 = state_68130__$1;
(statearr_68136_68191[(2)] = null);

(statearr_68136_68191[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (24))){
var inst_68064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68065 = [new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581)];
var inst_68066 = [keep_alive_fn];
var inst_68067 = cljs.core.PersistentHashMap.fromArrays(inst_68065,inst_68066);
var inst_68068 = ["Unsupported callback registered",inst_68067];
var inst_68069 = (new cljs.core.PersistentVector(null,2,(5),inst_68064,inst_68068,null));
var inst_68070 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68069);
var state_68130__$1 = state_68130;
var statearr_68137_68192 = state_68130__$1;
(statearr_68137_68192[(2)] = inst_68070);

(statearr_68137_68192[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (4))){
var inst_68025 = (state_68130[(8)]);
var inst_68030 = (state_68130[(2)]);
var inst_68031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68030,(0),null);
var inst_68032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68030,(1),null);
var inst_68033 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_68032,inst_68025);
var state_68130__$1 = (function (){var statearr_68138 = state_68130;
(statearr_68138[(9)] = inst_68031);

return statearr_68138;
})();
if(inst_68033){
var statearr_68139_68193 = state_68130__$1;
(statearr_68139_68193[(1)] = (5));

} else {
var statearr_68140_68194 = state_68130__$1;
(statearr_68140_68194[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (15))){
var inst_68050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68051 = ["No keep-alive callback is registered"];
var inst_68052 = (new cljs.core.PersistentVector(null,1,(5),inst_68050,inst_68051,null));
var inst_68053 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68052);
var state_68130__$1 = state_68130;
var statearr_68141_68195 = state_68130__$1;
(statearr_68141_68195[(2)] = inst_68053);

(statearr_68141_68195[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (21))){
var inst_68061 = cljs.core.eval(keep_alive_fn);
var state_68130__$1 = state_68130;
var statearr_68142_68196 = state_68130__$1;
(statearr_68142_68196[(2)] = inst_68061);

(statearr_68142_68196[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (31))){
var state_68130__$1 = state_68130;
var statearr_68143_68197 = state_68130__$1;
(statearr_68143_68197[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (32))){
var inst_68122 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68145_68198 = state_68130__$1;
(statearr_68145_68198[(2)] = inst_68122);

(statearr_68145_68198[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (33))){
var inst_68031 = (state_68130[(9)]);
var inst_68109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68110 = fluree.db.util.json.parse(inst_68031);
var inst_68111 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_68110], 0));
var inst_68112 = ["Received message:",inst_68111];
var inst_68113 = (new cljs.core.PersistentVector(null,2,(5),inst_68109,inst_68112,null));
var inst_68114 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"finer","finer",974902846),inst_68113);
var inst_68115 = fluree.db.util.json.parse(inst_68031);
var inst_68116 = fluree.db.conn_events.process_events(conn,inst_68115);
var inst_68020 = (0);
var state_68130__$1 = (function (){var statearr_68146 = state_68130;
(statearr_68146[(10)] = inst_68114);

(statearr_68146[(11)] = inst_68116);

(statearr_68146[(7)] = inst_68020);

return statearr_68146;
})();
var statearr_68147_68199 = state_68130__$1;
(statearr_68147_68199[(2)] = null);

(statearr_68147_68199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (13))){
var inst_68085 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68148_68200 = state_68130__$1;
(statearr_68148_68200[(2)] = inst_68085);

(statearr_68148_68200[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (22))){
var state_68130__$1 = state_68130;
var statearr_68149_68201 = state_68130__$1;
(statearr_68149_68201[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (29))){
var inst_68124 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68151_68202 = state_68130__$1;
(statearr_68151_68202[(2)] = inst_68124);

(statearr_68151_68202[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (6))){
var inst_68031 = (state_68130[(9)]);
var inst_68093 = (inst_68031 == null);
var state_68130__$1 = state_68130;
if(cljs.core.truth_(inst_68093)){
var statearr_68152_68203 = state_68130__$1;
(statearr_68152_68203[(1)] = (27));

} else {
var statearr_68153_68204 = state_68130__$1;
(statearr_68153_68204[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (28))){
var inst_68031 = (state_68130[(9)]);
var inst_68100 = fluree.db.util.core.exception_QMARK_(inst_68031);
var state_68130__$1 = state_68130;
if(inst_68100){
var statearr_68154_68205 = state_68130__$1;
(statearr_68154_68205[(1)] = (30));

} else {
var statearr_68155_68206 = state_68130__$1;
(statearr_68155_68206[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (25))){
var state_68130__$1 = state_68130;
var statearr_68156_68207 = state_68130__$1;
(statearr_68156_68207[(2)] = null);

(statearr_68156_68207[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (34))){
var state_68130__$1 = state_68130;
var statearr_68157_68208 = state_68130__$1;
(statearr_68157_68208[(2)] = null);

(statearr_68157_68208[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (17))){
var inst_68079 = (state_68130[(2)]);
var inst_68080 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68081 = fluree.db.connection.close_websocket(inst_68080);
var inst_68082 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
var inst_68083 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_68082);
var state_68130__$1 = (function (){var statearr_68158 = state_68130;
(statearr_68158[(12)] = inst_68079);

(statearr_68158[(13)] = inst_68081);

return statearr_68158;
})();
var statearr_68159_68209 = state_68130__$1;
(statearr_68159_68209[(2)] = inst_68083);

(statearr_68159_68209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (3))){
var inst_68128 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68130__$1,inst_68128);
} else {
if((state_val_68131 === (12))){
var inst_68043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68044 = ["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."];
var inst_68045 = (new cljs.core.PersistentVector(null,1,(5),inst_68043,inst_68044,null));
var inst_68046 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),inst_68045);
var inst_68047 = keep_alive_fn;
var inst_68048 = (keep_alive_fn == null);
var state_68130__$1 = (function (){var statearr_68160 = state_68130;
(statearr_68160[(14)] = inst_68047);

(statearr_68160[(15)] = inst_68046);

return statearr_68160;
})();
if(cljs.core.truth_(inst_68048)){
var statearr_68161_68210 = state_68130__$1;
(statearr_68161_68210[(1)] = (15));

} else {
var statearr_68162_68211 = state_68130__$1;
(statearr_68162_68211[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (2))){
var inst_68025 = (state_68130[(8)]);
var inst_68025__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_68026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68027 = [sub_chan,inst_68025__$1];
var inst_68028 = (new cljs.core.PersistentVector(null,2,(5),inst_68026,inst_68027,null));
var state_68130__$1 = (function (){var statearr_68163 = state_68130;
(statearr_68163[(8)] = inst_68025__$1);

return statearr_68163;
})();
return cljs.core.async.ioc_alts_BANG_(state_68130__$1,(4),inst_68028);
} else {
if((state_val_68131 === (23))){
var inst_68075 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68164_68212 = state_68130__$1;
(statearr_68164_68212[(2)] = inst_68075);

(statearr_68164_68212[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (35))){
var inst_68120 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68165_68213 = state_68130__$1;
(statearr_68165_68213[(2)] = inst_68120);

(statearr_68165_68213[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (19))){
var inst_68059 = typeof keep_alive_fn === 'string';
var state_68130__$1 = state_68130;
if(cljs.core.truth_(inst_68059)){
var statearr_68166_68214 = state_68130__$1;
(statearr_68166_68214[(1)] = (21));

} else {
var statearr_68167_68215 = state_68130__$1;
(statearr_68167_68215[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (11))){
var inst_68038 = fluree.db.connection.reconnect_conn(conn);
var state_68130__$1 = state_68130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68130__$1,(14),inst_68038);
} else {
if((state_val_68131 === (9))){
var inst_68020 = (state_68130[(7)]);
var inst_68087 = fluree.db.connection.ping_transactor(req_chan);
var inst_68088 = (inst_68020 + (1));
var inst_68020__$1 = inst_68088;
var state_68130__$1 = (function (){var statearr_68168 = state_68130;
(statearr_68168[(16)] = inst_68087);

(statearr_68168[(7)] = inst_68020__$1);

return statearr_68168;
})();
var statearr_68169_68216 = state_68130__$1;
(statearr_68169_68216[(2)] = null);

(statearr_68169_68216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (5))){
var inst_68020 = (state_68130[(7)]);
var inst_68035 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_68020);
var state_68130__$1 = state_68130;
if(inst_68035){
var statearr_68170_68217 = state_68130__$1;
(statearr_68170_68217[(1)] = (8));

} else {
var statearr_68171_68218 = state_68130__$1;
(statearr_68171_68218[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (14))){
var inst_68040 = (state_68130[(2)]);
var inst_68020 = (0);
var state_68130__$1 = (function (){var statearr_68172 = state_68130;
(statearr_68172[(17)] = inst_68040);

(statearr_68172[(7)] = inst_68020);

return statearr_68172;
})();
var statearr_68173_68219 = state_68130__$1;
(statearr_68173_68219[(2)] = null);

(statearr_68173_68219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (26))){
var inst_68073 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68174_68220 = state_68130__$1;
(statearr_68174_68220[(2)] = inst_68073);

(statearr_68174_68220[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (16))){
var inst_68055 = cljs.core.fn_QMARK_(keep_alive_fn);
var state_68130__$1 = state_68130;
if(inst_68055){
var statearr_68175_68221 = state_68130__$1;
(statearr_68175_68221[(1)] = (18));

} else {
var statearr_68176_68222 = state_68130__$1;
(statearr_68176_68222[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (30))){
var inst_68031 = (state_68130[(9)]);
var inst_68102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68103 = [inst_68031];
var inst_68104 = (new cljs.core.PersistentVector(null,1,(5),inst_68102,inst_68103,null));
var inst_68105 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68104);
var inst_68020 = (0);
var state_68130__$1 = (function (){var statearr_68177 = state_68130;
(statearr_68177[(18)] = inst_68105);

(statearr_68177[(7)] = inst_68020);

return statearr_68177;
})();
var statearr_68178_68223 = state_68130__$1;
(statearr_68178_68223[(2)] = null);

(statearr_68178_68223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (10))){
var inst_68091 = (state_68130[(2)]);
var state_68130__$1 = state_68130;
var statearr_68179_68224 = state_68130__$1;
(statearr_68179_68224[(2)] = inst_68091);

(statearr_68179_68224[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (18))){
var inst_68057 = (keep_alive_fn.cljs$core$IFn$_invoke$arity$0 ? keep_alive_fn.cljs$core$IFn$_invoke$arity$0() : keep_alive_fn.call(null));
var state_68130__$1 = state_68130;
var statearr_68180_68225 = state_68130__$1;
(statearr_68180_68225[(2)] = inst_68057);

(statearr_68180_68225[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68131 === (8))){
var state_68130__$1 = state_68130;
if(cljs.core.truth_(keep_alive)){
var statearr_68181_68226 = state_68130__$1;
(statearr_68181_68226[(1)] = (11));

} else {
var statearr_68182_68227 = state_68130__$1;
(statearr_68182_68227[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0 = (function (){
var statearr_68183 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68183[(0)] = fluree$db$connection$msg_consumer_$_state_machine__2727__auto__);

(statearr_68183[(1)] = (1));

return statearr_68183;
});
var fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1 = (function (state_68130){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68130);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68184){var ex__2730__auto__ = e68184;
var statearr_68185_68228 = state_68130;
(statearr_68185_68228[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68130[(4)]))){
var statearr_68186_68229 = state_68130;
(statearr_68186_68229[(1)] = cljs.core.first((state_68130[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68230 = state_68130;
state_68130 = G__68230;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__ = function(state_68130){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1.call(this,state_68130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__2727__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68187 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68187[(6)] = c__2749__auto__);

return statearr_68187;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__68232 = arguments.length;
switch (G__68232) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__68233 = opts;
var map__68233__$1 = cljs.core.__destructure_map(map__68233);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68233__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68233__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
return (function (k){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68285){
var state_val_68286 = (state_68285[(1)]);
if((state_val_68286 === (7))){
var inst_68243 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_68244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68245 = [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_68246 = (new cljs.core.PersistentVector(null,2,(5),inst_68244,inst_68245,null));
var inst_68247 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_68243,inst_68246);
var state_68285__$1 = state_68285;
var statearr_68287_68318 = state_68285__$1;
(statearr_68287_68318[(2)] = inst_68247);

(statearr_68287_68318[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (1))){
var state_68285__$1 = state_68285;
var statearr_68288_68319 = state_68285__$1;
(statearr_68288_68319[(2)] = null);

(statearr_68288_68319[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (4))){
var inst_68234 = (state_68285[(2)]);
var state_68285__$1 = state_68285;
var statearr_68289_68320 = state_68285__$1;
(statearr_68289_68320[(2)] = inst_68234);

(statearr_68289_68320[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (15))){
var inst_68254 = (state_68285[(7)]);
var inst_68273 = (state_68285[(2)]);
var inst_68274 = [new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_68275 = [(5000),inst_68273,new cljs.core.Keyword(null,"json","json",1279968570)];
var inst_68276 = cljs.core.PersistentHashMap.fromArrays(inst_68274,inst_68275);
var inst_68277 = fluree.db.util.xhttp.get(inst_68254,inst_68276);
var state_68285__$1 = state_68285;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68285__$1,(16),inst_68277);
} else {
if((state_val_68286 === (13))){
var inst_68264 = (state_68285[(8)]);
var inst_68254 = (state_68285[(7)]);
var inst_68266 = [new cljs.core.Keyword(null,"headers","headers",-835030129)];
var inst_68267 = [inst_68264];
var inst_68268 = cljs.core.PersistentHashMap.fromArrays(inst_68266,inst_68267);
var inst_68269 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_68254,inst_68268,private$);
var inst_68270 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_68269);
var state_68285__$1 = state_68285;
var statearr_68290_68321 = state_68285__$1;
(statearr_68290_68321[(2)] = inst_68270);

(statearr_68290_68321[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (6))){
var inst_68240 = (state_68285[(9)]);
var state_68285__$1 = state_68285;
var statearr_68291_68322 = state_68285__$1;
(statearr_68291_68322[(2)] = inst_68240);

(statearr_68291_68322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (3))){
var inst_68283 = (state_68285[(2)]);
var state_68285__$1 = state_68285;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68285__$1,inst_68283);
} else {
if((state_val_68286 === (12))){
var inst_68264 = (state_68285[(2)]);
var state_68285__$1 = (function (){var statearr_68292 = state_68285;
(statearr_68292[(8)] = inst_68264);

return statearr_68292;
})();
if(cljs.core.truth_(private$)){
var statearr_68293_68323 = state_68285__$1;
(statearr_68293_68323[(1)] = (13));

} else {
var statearr_68294_68324 = state_68285__$1;
(statearr_68294_68324[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (2))){
var inst_68240 = (state_68285[(9)]);
var _ = (function (){var statearr_68295 = state_68285;
(statearr_68295[(4)] = cljs.core.cons((5),(state_68285[(4)])));

return statearr_68295;
})();
var inst_68240__$1 = jwt;
var state_68285__$1 = (function (){var statearr_68296 = state_68285;
(statearr_68296[(9)] = inst_68240__$1);

return statearr_68296;
})();
if(cljs.core.truth_(inst_68240__$1)){
var statearr_68297_68325 = state_68285__$1;
(statearr_68297_68325[(1)] = (6));

} else {
var statearr_68298_68326 = state_68285__$1;
(statearr_68298_68326[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (11))){
var inst_68258 = (state_68285[(10)]);
var state_68285__$1 = state_68285;
var statearr_68300_68327 = state_68285__$1;
(statearr_68300_68327[(2)] = inst_68258);

(statearr_68300_68327[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (9))){
var inst_68249 = (state_68285[(11)]);
var inst_68250 = (state_68285[(12)]);
var inst_68253 = (state_68285[(2)]);
var inst_68254 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68253),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68250)].join('');
var inst_68256 = ["Accept"];
var inst_68257 = ["application/json"];
var inst_68258 = cljs.core.PersistentHashMap.fromArrays(inst_68256,inst_68257);
var state_68285__$1 = (function (){var statearr_68301 = state_68285;
(statearr_68301[(7)] = inst_68254);

(statearr_68301[(10)] = inst_68258);

return statearr_68301;
})();
if(cljs.core.truth_(inst_68249)){
var statearr_68302_68328 = state_68285__$1;
(statearr_68302_68328[(1)] = (10));

} else {
var statearr_68303_68329 = state_68285__$1;
(statearr_68303_68329[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (5))){
var _ = (function (){var statearr_68304 = state_68285;
(statearr_68304[(4)] = cljs.core.rest((state_68285[(4)])));

return statearr_68304;
})();
var state_68285__$1 = state_68285;
var ex68299 = (state_68285__$1[(2)]);
var statearr_68305_68330 = state_68285__$1;
(statearr_68305_68330[(5)] = ex68299);


if((ex68299 instanceof Error)){
var statearr_68306_68331 = state_68285__$1;
(statearr_68306_68331[(1)] = (4));

(statearr_68306_68331[(5)] = null);

} else {
throw ex68299;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (14))){
var inst_68264 = (state_68285[(8)]);
var state_68285__$1 = state_68285;
var statearr_68307_68332 = state_68285__$1;
(statearr_68307_68332[(2)] = inst_68264);

(statearr_68307_68332[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (16))){
var inst_68279 = (state_68285[(2)]);
var inst_68280 = fluree.db.util.async.throw_err(inst_68279);
var _ = (function (){var statearr_68308 = state_68285;
(statearr_68308[(4)] = cljs.core.rest((state_68285[(4)])));

return statearr_68308;
})();
var state_68285__$1 = state_68285;
var statearr_68309_68333 = state_68285__$1;
(statearr_68309_68333[(2)] = inst_68280);

(statearr_68309_68333[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (10))){
var inst_68249 = (state_68285[(11)]);
var inst_68258 = (state_68285[(10)]);
var inst_68260 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68249)].join('');
var inst_68261 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_68258,"Authorization",inst_68260);
var state_68285__$1 = state_68285;
var statearr_68310_68334 = state_68285__$1;
(statearr_68310_68334[(2)] = inst_68261);

(statearr_68310_68334[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68286 === (8))){
var inst_68249 = (state_68285[(2)]);
var inst_68250 = clojure.string.replace(k,"_","/");
var inst_68251 = fluree.db.connection.get_server(conn_id,servers);
var state_68285__$1 = (function (){var statearr_68311 = state_68285;
(statearr_68311[(11)] = inst_68249);

(statearr_68311[(12)] = inst_68250);

return statearr_68311;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68285__$1,(9),inst_68251);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_68312 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68312[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_68312[(1)] = (1));

return statearr_68312;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_68285){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68285);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68313){var ex__2730__auto__ = e68313;
var statearr_68314_68335 = state_68285;
(statearr_68314_68335[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68285[(4)]))){
var statearr_68315_68336 = state_68285;
(statearr_68315_68336[(1)] = cljs.core.first((state_68285[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68337 = state_68285;
state_68285 = G__68337;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_68285){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_68285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68316 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68316[(6)] = c__2749__auto__);

return statearr_68316;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

fluree.db.connection.lookup_cache = (function fluree$db$connection$lookup_cache(cache_atom,k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5804__auto__)){
var v = temp__5804__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
return null;
}
}
});
/**
 * Default synchronous object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
var temp__5802__auto__ = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto__)){
var v = temp__5802__auto__;
return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
});
});
/**
 * Default asynchronous object cache to use for ledger.
 */
fluree.db.connection.default_async_cache_fn = (function fluree$db$connection$default_async_cache_fn(cache_atom){
return (function (k,value_fn){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var temp__5802__auto___68362 = fluree.db.connection.lookup_cache(cache_atom,k,value_fn);
if(cljs.core.truth_(temp__5802__auto___68362)){
var v_68363 = temp__5802__auto___68362;
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,v_68363);
} else {
var c__2749__auto___68364 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68349){
var state_val_68350 = (state_68349[(1)]);
if((state_val_68350 === (1))){
var inst_68338 = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
var state_68349__$1 = state_68349;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68349__$1,(2),inst_68338);
} else {
if((state_val_68350 === (2))){
var inst_68340 = (state_68349[(7)]);
var inst_68340__$1 = (state_68349[(2)]);
var inst_68341 = fluree.db.util.core.exception_QMARK_(inst_68340__$1);
var state_68349__$1 = (function (){var statearr_68351 = state_68349;
(statearr_68351[(7)] = inst_68340__$1);

return statearr_68351;
})();
if(inst_68341){
var statearr_68352_68365 = state_68349__$1;
(statearr_68352_68365[(1)] = (3));

} else {
var statearr_68353_68366 = state_68349__$1;
(statearr_68353_68366[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68350 === (3))){
var state_68349__$1 = state_68349;
var statearr_68354_68367 = state_68349__$1;
(statearr_68354_68367[(2)] = null);

(statearr_68354_68367[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68350 === (4))){
var inst_68340 = (state_68349[(7)]);
var inst_68344 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,inst_68340);
var state_68349__$1 = state_68349;
var statearr_68355_68368 = state_68349__$1;
(statearr_68355_68368[(2)] = inst_68344);

(statearr_68355_68368[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68350 === (5))){
var inst_68340 = (state_68349[(7)]);
var inst_68346 = (state_68349[(2)]);
var inst_68347 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(out,inst_68340);
var state_68349__$1 = (function (){var statearr_68356 = state_68349;
(statearr_68356[(8)] = inst_68346);

return statearr_68356;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_68349__$1,inst_68347);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = null;
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0 = (function (){
var statearr_68357 = [null,null,null,null,null,null,null,null,null];
(statearr_68357[(0)] = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__);

(statearr_68357[(1)] = (1));

return statearr_68357;
});
var fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1 = (function (state_68349){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68349);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68358){var ex__2730__auto__ = e68358;
var statearr_68359_68369 = state_68349;
(statearr_68359_68369[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68349[(4)]))){
var statearr_68360_68370 = state_68349;
(statearr_68360_68370[(1)] = cljs.core.first((state_68349[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68371 = state_68349;
state_68349 = G__68371;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__ = function(state_68349){
switch(arguments.length){
case 0:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1.call(this,state_68349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____0;
fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto____1;
return fluree$db$connection$default_async_cache_fn_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68361 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68361[(6)] = c__2749__auto___68364);

return statearr_68361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

return out;
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"threshold","threshold",204221583),cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,ledger_id,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null),(function (p1__68372_SHARP_){
if(cljs.core.truth_(p1__68372_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-listener","db/invalid-listener",632510971)], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,ledger_id,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + ledger-id.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,ledger_id,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key,fn);
});
/**
 * Removes listener on given network + ledger-id for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,ledger_id,key){
return fluree.db.connection.remove_listener_STAR_(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),network,ledger_id,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,new cljs.core.Keyword(null,"token","token",-1211463215)], null),(function (p1__68373_SHARP_){
var or__5045__auto__ = p1__68373_SHARP_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return token;
}
}));

return true;
}catch (e68374){var e = e68374;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"close?","close?",1600185693),false,new cljs.core.Keyword(null,"health","health",-295520649),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"connected-to","connected-to",-1930163150),null,new cljs.core.Keyword(null,"socket","socket",59137063),null,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),null,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.PersistentArrayMap.EMPTY], null));
var map__68375 = opts;
var map__68375__$1 = cljs.core.__destructure_map(map__68375);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229));
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581));
var storage_delete = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532));
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"publish","publish",-1178026850));
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"close-fn","close-fn",-1779772512));
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"default-network","default-network",586420705));
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287));
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037));
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),(4));
var group = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"group","group",582596132));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122));
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"private","private",-558947994));
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"storage-read","storage-read",-885692537));
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"serializer","serializer",-875689688),fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"memory","memory",-1449401430),(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075));
var keep_alive = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827));
var async_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891));
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"storage-write","storage-write",595144816),(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"memory?","memory?",-596367598),false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__68375__$1,new cljs.core.Keyword(null,"private-key-file","private-key-file",-1118989000),"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__68375__$1,new cljs.core.Keyword(null,"storage-list","storage-list",1202854328));
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-configuration","db/invalid-configuration",559343174)], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__5045__auto__ = object_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var async_cache_fn = (function (){var or__5045__auto__ = async_cache;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_async_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"close?","close?",1600185693),true);

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"info","info",-317069002),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["connection closed"], null));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__5045__auto__ = storage_read;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__5045__auto__ = storage_exists;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = storage_read;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__5043__auto__ = storage_write;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__5043__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287),new cljs.core.Keyword(null,"default-network","default-network",586420705),new cljs.core.Keyword(null,"parallelism","parallelism",-930922333),new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037),new cljs.core.Keyword(null,"add-listener","add-listener",313698051),new cljs.core.Keyword(null,"group","group",582596132),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"tx-private-key","tx-private-key",-1231668122),new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),new cljs.core.Keyword(null,"storage-read","storage-read",-885692537),new cljs.core.Keyword(null,"serializer","serializer",-875689688),new cljs.core.Keyword(null,"memory","memory",-1449401430),new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075),new cljs.core.Keyword(null,"async-cache","async-cache",-190459891),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"keep-alive","keep-alive",-47515827),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"tx-key-id","tx-key-id",-1451912145),new cljs.core.Keyword(null,"storage-write","storage-write",595144816),new cljs.core.Keyword(null,"req-chan","req-chan",-35924046),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"servers","servers",1881102005),new cljs.core.Keyword(null,"pub-chan","pub-chan",-46915593),new cljs.core.Keyword(null,"storage-list","storage-list",1202854328),new cljs.core.Keyword(null,"sub-chan","sub-chan",-2012438215),new cljs.core.Keyword(null,"storage-rename","storage-rename",-310600229),new cljs.core.Keyword(null,"keep-alive-fn","keep-alive-fn",-1421484581),new cljs.core.Keyword(null,"storage-delete","storage-delete",1630373532),new cljs.core.Keyword(null,"publish","publish",-1178026850)],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),group,meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,async_cache_fn,state_atom,keep_alive,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),storage_delete,publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__68376_68377 = new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__68376_68377.cljs$core$IFn$_invoke$arity$0 ? fexpr__68376_68377.cljs$core$IFn$_invoke$arity$0() : fexpr__68376_68377.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___68421 = arguments.length;
var i__5770__auto___68422 = (0);
while(true){
if((i__5770__auto___68422 < len__5769__auto___68421)){
args__5775__auto__.push((arguments[i__5770__auto___68422]));

var G__68423 = (i__5770__auto___68422 + (1));
i__5770__auto___68422 = G__68423;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__68380){
var vec__68381 = p__68380;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__68381,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__2749__auto___68424 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_68404){
var state_val_68405 = (state_68404[(1)]);
if((state_val_68405 === (1))){
var inst_68384 = fluree.db.connection.get_socket(conn);
var state_68404__$1 = state_68404;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68404__$1,(2),inst_68384);
} else {
if((state_val_68405 === (2))){
var inst_68387 = (state_68404[(7)]);
var inst_68386 = (state_68404[(8)]);
var inst_68386__$1 = (state_68404[(2)]);
var inst_68387__$1 = (inst_68386__$1 == null);
var state_68404__$1 = (function (){var statearr_68406 = state_68404;
(statearr_68406[(7)] = inst_68387__$1);

(statearr_68406[(8)] = inst_68386__$1);

return statearr_68406;
})();
if(cljs.core.truth_(inst_68387__$1)){
var statearr_68407_68425 = state_68404__$1;
(statearr_68407_68425[(1)] = (3));

} else {
var statearr_68408_68426 = state_68404__$1;
(statearr_68408_68426[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68405 === (3))){
var inst_68387 = (state_68404[(7)]);
var state_68404__$1 = state_68404;
var statearr_68409_68427 = state_68404__$1;
(statearr_68409_68427[(2)] = inst_68387);

(statearr_68409_68427[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68405 === (4))){
var inst_68386 = (state_68404[(8)]);
var inst_68390 = fluree.db.util.core.exception_QMARK_(inst_68386);
var state_68404__$1 = state_68404;
var statearr_68410_68428 = state_68404__$1;
(statearr_68410_68428[(2)] = inst_68390);

(statearr_68410_68428[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68405 === (5))){
var inst_68392 = (state_68404[(2)]);
var state_68404__$1 = state_68404;
if(cljs.core.truth_(inst_68392)){
var statearr_68411_68429 = state_68404__$1;
(statearr_68411_68429[(1)] = (6));

} else {
var statearr_68412_68430 = state_68404__$1;
(statearr_68412_68430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68405 === (6))){
var inst_68386 = (state_68404[(8)]);
var inst_68394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68395 = [inst_68386,"Cannot establish connection to a healthy server, disconnecting."];
var inst_68396 = (new cljs.core.PersistentVector(null,2,(5),inst_68394,inst_68395,null));
var inst_68397 = fluree.db.util.log.log(fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_68396);
var inst_68398 = cljs.core.async.close_BANG_(conn);
var state_68404__$1 = (function (){var statearr_68413 = state_68404;
(statearr_68413[(9)] = inst_68397);

return statearr_68413;
})();
var statearr_68414_68431 = state_68404__$1;
(statearr_68414_68431[(2)] = inst_68398);

(statearr_68414_68431[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68405 === (7))){
var inst_68400 = fluree.db.connection.msg_consumer(conn);
var state_68404__$1 = state_68404;
var statearr_68415_68432 = state_68404__$1;
(statearr_68415_68432[(2)] = inst_68400);

(statearr_68415_68432[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68405 === (8))){
var inst_68402 = (state_68404[(2)]);
var state_68404__$1 = state_68404;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68404__$1,inst_68402);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__2727__auto__ = null;
var fluree$db$connection$state_machine__2727__auto____0 = (function (){
var statearr_68416 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68416[(0)] = fluree$db$connection$state_machine__2727__auto__);

(statearr_68416[(1)] = (1));

return statearr_68416;
});
var fluree$db$connection$state_machine__2727__auto____1 = (function (state_68404){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_68404);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e68417){var ex__2730__auto__ = e68417;
var statearr_68418_68433 = state_68404;
(statearr_68418_68433[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_68404[(4)]))){
var statearr_68419_68434 = state_68404;
(statearr_68419_68434[(1)] = cljs.core.first((state_68404[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68435 = state_68404;
state_68404 = G__68435;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$connection$state_machine__2727__auto__ = function(state_68404){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__2727__auto____1.call(this,state_68404);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__2727__auto____0;
fluree$db$connection$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__2727__auto____1;
return fluree$db$connection$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_68420 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_68420[(6)] = c__2749__auto___68424);

return statearr_68420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq68378){
var G__68379 = cljs.core.first(seq68378);
var seq68378__$1 = cljs.core.next(seq68378);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68379,seq68378__$1);
}));

