// Compiled by ClojureScript 1.11.60 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.fql_resp');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(ledger_id){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,ledger_id);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__65037 = arguments.length;
switch (G__65037) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2749__auto___65185 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65124){
var state_val_65125 = (state_65124[(1)]);
if((state_val_65125 === (7))){
var inst_65055 = (state_65124[(7)]);
var inst_65058 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_65055);
var state_65124__$1 = state_65124;
var statearr_65126_65186 = state_65124__$1;
(statearr_65126_65186[(2)] = inst_65058);

(statearr_65126_65186[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (20))){
var inst_65079 = (state_65124[(8)]);
var inst_65050 = (state_65124[(9)]);
var inst_65083 = fluree.db.auth.roles(inst_65050,inst_65079);
var state_65124__$1 = state_65124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65124__$1,(23),inst_65083);
} else {
if((state_val_65125 === (27))){
var inst_65050 = (state_65124[(9)]);
var inst_65098 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65099 = fluree.db.time_travel.as_of_block(inst_65050,inst_65098);
var state_65124__$1 = state_65124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65124__$1,(30),inst_65099);
} else {
if((state_val_65125 === (1))){
var state_65124__$1 = state_65124;
var statearr_65127_65187 = state_65124__$1;
(statearr_65127_65187[(2)] = null);

(statearr_65127_65187[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (24))){
var inst_65091 = (state_65124[(10)]);
var inst_65050 = (state_65124[(9)]);
var inst_65093 = fluree.db.permissions.permission_map(inst_65050,inst_65091,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_65124__$1 = state_65124;
var statearr_65128_65188 = state_65124__$1;
(statearr_65128_65188[(2)] = inst_65093);

(statearr_65128_65188[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (4))){
var inst_65038 = (state_65124[(2)]);
var inst_65039 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65038);
var inst_65040 = cljs.core.async.close_BANG_(pc);
var state_65124__$1 = (function (){var statearr_65129 = state_65124;
(statearr_65129[(11)] = inst_65039);

return statearr_65129;
})();
var statearr_65130_65189 = state_65124__$1;
(statearr_65130_65189[(2)] = inst_65040);

(statearr_65130_65189[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (15))){
var inst_65055 = (state_65124[(7)]);
var inst_65069 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65055)," unknown."].join('');
var inst_65070 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65071 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_65072 = cljs.core.PersistentHashMap.fromArrays(inst_65070,inst_65071);
var inst_65073 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65069,inst_65072);
var inst_65074 = (function(){throw inst_65073})();
var state_65124__$1 = state_65124;
var statearr_65131_65190 = state_65124__$1;
(statearr_65131_65190[(2)] = inst_65074);

(statearr_65131_65190[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (21))){
var state_65124__$1 = state_65124;
var statearr_65132_65191 = state_65124__$1;
(statearr_65132_65191[(2)] = null);

(statearr_65132_65191[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (31))){
var inst_65105 = (state_65124[(12)]);
var inst_65055 = (state_65124[(7)]);
var inst_65107 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65105,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_65055);
var state_65124__$1 = state_65124;
var statearr_65133_65192 = state_65124__$1;
(statearr_65133_65192[(2)] = inst_65107);

(statearr_65133_65192[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (32))){
var inst_65105 = (state_65124[(12)]);
var state_65124__$1 = state_65124;
var statearr_65134_65193 = state_65124__$1;
(statearr_65134_65193[(2)] = inst_65105);

(statearr_65134_65193[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (33))){
var inst_65091 = (state_65124[(10)]);
var inst_65110 = (state_65124[(2)]);
var state_65124__$1 = (function (){var statearr_65135 = state_65124;
(statearr_65135[(13)] = inst_65110);

return statearr_65135;
})();
if(cljs.core.truth_(inst_65091)){
var statearr_65136_65194 = state_65124__$1;
(statearr_65136_65194[(1)] = (34));

} else {
var statearr_65137_65195 = state_65124__$1;
(statearr_65137_65195[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (13))){
var inst_65066 = (state_65124[(14)]);
var inst_65065 = (state_65124[(2)]);
var inst_65066__$1 = fluree.db.util.async.throw_err(inst_65065);
var state_65124__$1 = (function (){var statearr_65138 = state_65124;
(statearr_65138[(14)] = inst_65066__$1);

return statearr_65138;
})();
if(cljs.core.truth_(inst_65066__$1)){
var statearr_65139_65196 = state_65124__$1;
(statearr_65139_65196[(1)] = (14));

} else {
var statearr_65140_65197 = state_65124__$1;
(statearr_65140_65197[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (22))){
var inst_65089 = (state_65124[(2)]);
var state_65124__$1 = state_65124;
var statearr_65141_65198 = state_65124__$1;
(statearr_65141_65198[(2)] = inst_65089);

(statearr_65141_65198[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (36))){
var inst_65118 = (state_65124[(2)]);
var inst_65119 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65118);
var _ = (function (){var statearr_65142 = state_65124;
(statearr_65142[(4)] = cljs.core.rest((state_65124[(4)])));

return statearr_65142;
})();
var state_65124__$1 = state_65124;
var statearr_65143_65199 = state_65124__$1;
(statearr_65143_65199[(2)] = inst_65119);

(statearr_65143_65199[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (29))){
var inst_65055 = (state_65124[(7)]);
var inst_65105 = (state_65124[(2)]);
var state_65124__$1 = (function (){var statearr_65144 = state_65124;
(statearr_65144[(12)] = inst_65105);

return statearr_65144;
})();
if(cljs.core.truth_(inst_65055)){
var statearr_65145_65200 = state_65124__$1;
(statearr_65145_65200[(1)] = (31));

} else {
var statearr_65146_65201 = state_65124__$1;
(statearr_65146_65201[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (6))){
var inst_65055 = (state_65124[(7)]);
var inst_65049 = (state_65124[(2)]);
var inst_65050 = fluree.db.util.async.throw_err(inst_65049);
var inst_65051 = opts;
var inst_65052 = cljs.core.__destructure_map(inst_65051);
var inst_65053 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65052,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_65054 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65052,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_65055__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65052,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65052,new cljs.core.Keyword(null,"block","block",664686210));
var state_65124__$1 = (function (){var statearr_65147 = state_65124;
(statearr_65147[(15)] = inst_65053);

(statearr_65147[(16)] = inst_65056);

(statearr_65147[(17)] = inst_65054);

(statearr_65147[(9)] = inst_65050);

(statearr_65147[(7)] = inst_65055__$1);

return statearr_65147;
})();
if(cljs.core.truth_(inst_65055__$1)){
var statearr_65148_65202 = state_65124__$1;
(statearr_65148_65202[(1)] = (7));

} else {
var statearr_65149_65203 = state_65124__$1;
(statearr_65149_65203[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (28))){
var inst_65050 = (state_65124[(9)]);
var state_65124__$1 = state_65124;
var statearr_65150_65204 = state_65124__$1;
(statearr_65150_65204[(2)] = inst_65050);

(statearr_65150_65204[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (25))){
var state_65124__$1 = state_65124;
var statearr_65151_65205 = state_65124__$1;
(statearr_65151_65205[(2)] = null);

(statearr_65151_65205[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (34))){
var inst_65096 = (state_65124[(18)]);
var state_65124__$1 = state_65124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65124__$1,(37),inst_65096);
} else {
if((state_val_65125 === (17))){
var inst_65053 = (state_65124[(15)]);
var state_65124__$1 = state_65124;
var statearr_65152_65206 = state_65124__$1;
(statearr_65152_65206[(2)] = inst_65053);

(statearr_65152_65206[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (3))){
var inst_65122 = (state_65124[(2)]);
var state_65124__$1 = state_65124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65124__$1,inst_65122);
} else {
if((state_val_65125 === (12))){
var inst_65053 = (state_65124[(15)]);
var inst_65079 = (state_65124[(2)]);
var state_65124__$1 = (function (){var statearr_65153 = state_65124;
(statearr_65153[(8)] = inst_65079);

return statearr_65153;
})();
if(cljs.core.truth_(inst_65053)){
var statearr_65154_65207 = state_65124__$1;
(statearr_65154_65207[(1)] = (17));

} else {
var statearr_65155_65208 = state_65124__$1;
(statearr_65155_65208[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (2))){
var _ = (function (){var statearr_65156 = state_65124;
(statearr_65156[(4)] = cljs.core.cons((5),(state_65124[(4)])));

return statearr_65156;
})();
var inst_65047 = fluree.db.session.db(conn,ledger,null);
var state_65124__$1 = state_65124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65124__$1,(6),inst_65047);
} else {
if((state_val_65125 === (23))){
var inst_65085 = (state_65124[(2)]);
var inst_65086 = fluree.db.util.async.throw_err(inst_65085);
var state_65124__$1 = state_65124;
var statearr_65157_65209 = state_65124__$1;
(statearr_65157_65209[(2)] = inst_65086);

(statearr_65157_65209[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (35))){
var inst_65110 = (state_65124[(13)]);
var state_65124__$1 = state_65124;
var statearr_65158_65210 = state_65124__$1;
(statearr_65158_65210[(2)] = inst_65110);

(statearr_65158_65210[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (19))){
var inst_65091 = (state_65124[(10)]);
var inst_65091__$1 = (state_65124[(2)]);
var state_65124__$1 = (function (){var statearr_65159 = state_65124;
(statearr_65159[(10)] = inst_65091__$1);

return statearr_65159;
})();
if(cljs.core.truth_(inst_65091__$1)){
var statearr_65160_65211 = state_65124__$1;
(statearr_65160_65211[(1)] = (24));

} else {
var statearr_65161_65212 = state_65124__$1;
(statearr_65161_65212[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (11))){
var state_65124__$1 = state_65124;
var statearr_65163_65213 = state_65124__$1;
(statearr_65163_65213[(2)] = null);

(statearr_65163_65213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (9))){
var inst_65061 = (state_65124[(2)]);
var state_65124__$1 = state_65124;
if(cljs.core.truth_(inst_65061)){
var statearr_65164_65214 = state_65124__$1;
(statearr_65164_65214[(1)] = (10));

} else {
var statearr_65165_65215 = state_65124__$1;
(statearr_65165_65215[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (5))){
var _ = (function (){var statearr_65166 = state_65124;
(statearr_65166[(4)] = cljs.core.rest((state_65124[(4)])));

return statearr_65166;
})();
var state_65124__$1 = state_65124;
var ex65162 = (state_65124__$1[(2)]);
var statearr_65167_65216 = state_65124__$1;
(statearr_65167_65216[(5)] = ex65162);


var statearr_65168_65217 = state_65124__$1;
(statearr_65168_65217[(1)] = (4));

(statearr_65168_65217[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (14))){
var inst_65066 = (state_65124[(14)]);
var state_65124__$1 = state_65124;
var statearr_65169_65218 = state_65124__$1;
(statearr_65169_65218[(2)] = inst_65066);

(statearr_65169_65218[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (26))){
var inst_65056 = (state_65124[(16)]);
var inst_65096 = (state_65124[(2)]);
var state_65124__$1 = (function (){var statearr_65170 = state_65124;
(statearr_65170[(18)] = inst_65096);

return statearr_65170;
})();
if(cljs.core.truth_(inst_65056)){
var statearr_65171_65219 = state_65124__$1;
(statearr_65171_65219[(1)] = (27));

} else {
var statearr_65172_65220 = state_65124__$1;
(statearr_65172_65220[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (16))){
var inst_65076 = (state_65124[(2)]);
var state_65124__$1 = state_65124;
var statearr_65173_65221 = state_65124__$1;
(statearr_65173_65221[(2)] = inst_65076);

(statearr_65173_65221[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (30))){
var inst_65101 = (state_65124[(2)]);
var inst_65102 = fluree.db.util.async.throw_err(inst_65101);
var state_65124__$1 = state_65124;
var statearr_65174_65222 = state_65124__$1;
(statearr_65174_65222[(2)] = inst_65102);

(statearr_65174_65222[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (10))){
var inst_65050 = (state_65124[(9)]);
var inst_65055 = (state_65124[(7)]);
var inst_65063 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_65050,inst_65055);
var state_65124__$1 = state_65124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65124__$1,(13),inst_65063);
} else {
if((state_val_65125 === (18))){
var inst_65079 = (state_65124[(8)]);
var state_65124__$1 = state_65124;
if(cljs.core.truth_(inst_65079)){
var statearr_65175_65223 = state_65124__$1;
(statearr_65175_65223[(1)] = (20));

} else {
var statearr_65176_65224 = state_65124__$1;
(statearr_65176_65224[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (37))){
var inst_65110 = (state_65124[(13)]);
var inst_65113 = (state_65124[(2)]);
var inst_65114 = fluree.db.util.async.throw_err(inst_65113);
var inst_65115 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65110,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_65114);
var state_65124__$1 = state_65124;
var statearr_65177_65225 = state_65124__$1;
(statearr_65177_65225[(2)] = inst_65115);

(statearr_65177_65225[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65125 === (8))){
var inst_65055 = (state_65124[(7)]);
var state_65124__$1 = state_65124;
var statearr_65178_65226 = state_65124__$1;
(statearr_65178_65226[(2)] = inst_65055);

(statearr_65178_65226[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2727__auto__ = null;
var fluree$db$api$query$state_machine__2727__auto____0 = (function (){
var statearr_65179 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65179[(0)] = fluree$db$api$query$state_machine__2727__auto__);

(statearr_65179[(1)] = (1));

return statearr_65179;
});
var fluree$db$api$query$state_machine__2727__auto____1 = (function (state_65124){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65124);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65180){var ex__2730__auto__ = e65180;
var statearr_65181_65227 = state_65124;
(statearr_65181_65227[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65124[(4)]))){
var statearr_65182_65228 = state_65124;
(statearr_65182_65228[(1)] = cljs.core.first((state_65124[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65229 = state_65124;
state_65124 = G__65229;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2727__auto__ = function(state_65124){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2727__auto____1.call(this,state_65124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2727__auto____0;
fluree$db$api$query$state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2727__auto____1;
return fluree$db$api$query$state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65183 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65183[(6)] = c__2749__auto___65185);

return statearr_65183;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65370){
var state_val_65371 = (state_65370[(1)]);
if((state_val_65371 === (7))){
var inst_65250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65251 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65252 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65253 = [inst_65251,inst_65252];
var inst_65254 = (new cljs.core.PersistentVector(null,2,(5),inst_65250,inst_65253,null));
var state_65370__$1 = state_65370;
var statearr_65372_65442 = state_65370__$1;
(statearr_65372_65442[(2)] = inst_65254);

(statearr_65372_65442[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (20))){
var inst_65280 = (state_65370[(7)]);
var state_65370__$1 = state_65370;
var statearr_65373_65443 = state_65370__$1;
(statearr_65373_65443[(2)] = inst_65280);

(statearr_65373_65443[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (27))){
var state_65370__$1 = state_65370;
var statearr_65374_65444 = state_65370__$1;
(statearr_65374_65444[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (1))){
var state_65370__$1 = state_65370;
var statearr_65376_65445 = state_65370__$1;
(statearr_65376_65445[(2)] = null);

(statearr_65376_65445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (24))){
var inst_65279 = (state_65370[(8)]);
var state_65370__$1 = state_65370;
if(cljs.core.truth_(inst_65279)){
var statearr_65377_65446 = state_65370__$1;
(statearr_65377_65446[(1)] = (26));

} else {
var statearr_65378_65447 = state_65370__$1;
(statearr_65378_65447[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (39))){
var inst_65325 = (state_65370[(9)]);
var inst_65326 = (state_65370[(10)]);
var inst_65351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65352 = [inst_65325,inst_65326];
var inst_65353 = (new cljs.core.PersistentVector(null,2,(5),inst_65351,inst_65352,null));
var state_65370__$1 = state_65370;
var statearr_65379_65448 = state_65370__$1;
(statearr_65379_65448[(2)] = inst_65353);

(statearr_65379_65448[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (4))){
var inst_65230 = (state_65370[(2)]);
var state_65370__$1 = state_65370;
var statearr_65380_65449 = state_65370__$1;
(statearr_65380_65449[(2)] = inst_65230);

(statearr_65380_65449[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (15))){
var inst_65264 = (state_65370[(11)]);
var inst_65259 = (state_65370[(12)]);
var inst_65273 = (state_65370[(2)]);
var inst_65274 = [inst_65264,inst_65273];
var inst_65275 = (new cljs.core.PersistentVector(null,2,(5),inst_65259,inst_65274,null));
var state_65370__$1 = state_65370;
var statearr_65381_65450 = state_65370__$1;
(statearr_65381_65450[(2)] = inst_65275);

(statearr_65381_65450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (21))){
var inst_65279 = (state_65370[(8)]);
var state_65370__$1 = state_65370;
var statearr_65382_65451 = state_65370__$1;
(statearr_65382_65451[(2)] = inst_65279);

(statearr_65382_65451[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (31))){
var inst_65320 = (state_65370[(2)]);
var state_65370__$1 = state_65370;
var statearr_65383_65452 = state_65370__$1;
(statearr_65383_65452[(2)] = inst_65320);

(statearr_65383_65452[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (32))){
var inst_65326 = (state_65370[(10)]);
var inst_65329 = cljs.core.pos_int_QMARK_(inst_65326);
var state_65370__$1 = state_65370;
var statearr_65384_65453 = state_65370__$1;
(statearr_65384_65453[(2)] = inst_65329);

(statearr_65384_65453[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (40))){
var inst_65357 = (state_65370[(13)]);
var inst_65281 = (state_65370[(14)]);
var inst_65355 = (state_65370[(2)]);
var inst_65356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65355,(0),null);
var inst_65357__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65355,(1),null);
var inst_65358 = (inst_65357__$1 > inst_65281);
var state_65370__$1 = (function (){var statearr_65385 = state_65370;
(statearr_65385[(13)] = inst_65357__$1);

(statearr_65385[(15)] = inst_65356);

return statearr_65385;
})();
if(cljs.core.truth_(inst_65358)){
var statearr_65386_65454 = state_65370__$1;
(statearr_65386_65454[(1)] = (41));

} else {
var statearr_65387_65455 = state_65370__$1;
(statearr_65387_65455[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (33))){
var inst_65327 = (state_65370[(16)]);
var state_65370__$1 = state_65370;
var statearr_65388_65456 = state_65370__$1;
(statearr_65388_65456[(2)] = inst_65327);

(statearr_65388_65456[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (13))){
var inst_65265 = (state_65370[(17)]);
var inst_65267 = fluree.db.time_travel.block_to_int_format(db,inst_65265);
var state_65370__$1 = state_65370;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65370__$1,(16),inst_65267);
} else {
if((state_val_65371 === (22))){
var inst_65298 = (state_65370[(2)]);
var state_65370__$1 = state_65370;
if(cljs.core.truth_(inst_65298)){
var statearr_65389_65457 = state_65370__$1;
(statearr_65389_65457[(1)] = (23));

} else {
var statearr_65390_65458 = state_65370__$1;
(statearr_65390_65458[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (36))){
var state_65370__$1 = state_65370;
var statearr_65391_65459 = state_65370__$1;
(statearr_65391_65459[(2)] = null);

(statearr_65391_65459[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (41))){
var inst_65281 = (state_65370[(14)]);
var state_65370__$1 = state_65370;
var statearr_65392_65460 = state_65370__$1;
(statearr_65392_65460[(2)] = inst_65281);

(statearr_65392_65460[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (43))){
var inst_65356 = (state_65370[(15)]);
var inst_65362 = (state_65370[(2)]);
var inst_65363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65364 = [inst_65356,inst_65362];
var inst_65365 = (new cljs.core.PersistentVector(null,2,(5),inst_65363,inst_65364,null));
var _ = (function (){var statearr_65393 = state_65370;
(statearr_65393[(4)] = cljs.core.rest((state_65370[(4)])));

return statearr_65393;
})();
var state_65370__$1 = state_65370;
var statearr_65394_65461 = state_65370__$1;
(statearr_65394_65461[(2)] = inst_65365);

(statearr_65394_65461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (29))){
var inst_65256 = (state_65370[(18)]);
var inst_65311 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65256], 0));
var inst_65312 = ["Invalid block range provided: ",inst_65311].join('');
var inst_65313 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65314 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65315 = cljs.core.PersistentHashMap.fromArrays(inst_65313,inst_65314);
var inst_65316 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65312,inst_65315);
var inst_65317 = (function(){throw inst_65316})();
var state_65370__$1 = state_65370;
var statearr_65395_65462 = state_65370__$1;
(statearr_65395_65462[(2)] = inst_65317);

(statearr_65395_65462[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (6))){
var inst_65248 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65370__$1 = state_65370;
var statearr_65396_65463 = state_65370__$1;
(statearr_65396_65463[(2)] = inst_65248);

(statearr_65396_65463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (28))){
var inst_65322 = (state_65370[(2)]);
var state_65370__$1 = state_65370;
var statearr_65397_65464 = state_65370__$1;
(statearr_65397_65464[(2)] = inst_65322);

(statearr_65397_65464[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (25))){
var inst_65327 = (state_65370[(16)]);
var inst_65325 = (state_65370[(9)]);
var inst_65324 = (state_65370[(2)]);
var inst_65325__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65324,(0),null);
var inst_65326 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65324,(1),null);
var inst_65327__$1 = cljs.core.pos_int_QMARK_(inst_65325__$1);
var state_65370__$1 = (function (){var statearr_65398 = state_65370;
(statearr_65398[(16)] = inst_65327__$1);

(statearr_65398[(9)] = inst_65325__$1);

(statearr_65398[(10)] = inst_65326);

return statearr_65398;
})();
if(inst_65327__$1){
var statearr_65399_65465 = state_65370__$1;
(statearr_65399_65465[(1)] = (32));

} else {
var statearr_65400_65466 = state_65370__$1;
(statearr_65400_65466[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (34))){
var inst_65332 = (state_65370[(2)]);
var inst_65333 = cljs.core.not(inst_65332);
var state_65370__$1 = state_65370;
if(inst_65333){
var statearr_65401_65467 = state_65370__$1;
(statearr_65401_65467[(1)] = (35));

} else {
var statearr_65402_65468 = state_65370__$1;
(statearr_65402_65468[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (17))){
var inst_65279 = (state_65370[(8)]);
var inst_65281 = (state_65370[(14)]);
var inst_65284 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65279], 0));
var inst_65285 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65281], 0));
var inst_65286 = ["Start block is out of range for this ledger. Start block provided: ",inst_65284,". Database block: ",inst_65285].join('');
var inst_65287 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65288 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65289 = cljs.core.PersistentHashMap.fromArrays(inst_65287,inst_65288);
var inst_65290 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65286,inst_65289);
var inst_65291 = (function(){throw inst_65290})();
var state_65370__$1 = state_65370;
var statearr_65403_65469 = state_65370__$1;
(statearr_65403_65469[(2)] = inst_65291);

(statearr_65403_65469[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (3))){
var inst_65368 = (state_65370[(2)]);
var state_65370__$1 = state_65370;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65370__$1,inst_65368);
} else {
if((state_val_65371 === (12))){
var inst_65265 = (state_65370[(17)]);
var inst_65256 = (state_65370[(18)]);
var inst_65263 = (state_65370[(2)]);
var inst_65264 = fluree.db.util.async.throw_err(inst_65263);
var inst_65265__$1 = cljs.core.second(inst_65256);
var state_65370__$1 = (function (){var statearr_65404 = state_65370;
(statearr_65404[(17)] = inst_65265__$1);

(statearr_65404[(11)] = inst_65264);

return statearr_65404;
})();
if(cljs.core.truth_(inst_65265__$1)){
var statearr_65405_65470 = state_65370__$1;
(statearr_65405_65470[(1)] = (13));

} else {
var statearr_65406_65471 = state_65370__$1;
(statearr_65406_65471[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (2))){
var _ = (function (){var statearr_65407 = state_65370;
(statearr_65407[(4)] = cljs.core.cons((5),(state_65370[(4)])));

return statearr_65407;
})();
var inst_65245 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65246 = cljs.core.sequential_QMARK_(inst_65245);
var state_65370__$1 = state_65370;
if(inst_65246){
var statearr_65408_65472 = state_65370__$1;
(statearr_65408_65472[(1)] = (6));

} else {
var statearr_65409_65473 = state_65370__$1;
(statearr_65409_65473[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (23))){
var inst_65279 = (state_65370[(8)]);
var inst_65280 = (state_65370[(7)]);
var inst_65300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65301 = [inst_65279,inst_65280];
var inst_65302 = (new cljs.core.PersistentVector(null,2,(5),inst_65300,inst_65301,null));
var state_65370__$1 = state_65370;
var statearr_65410_65474 = state_65370__$1;
(statearr_65410_65474[(2)] = inst_65302);

(statearr_65410_65474[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (35))){
var inst_65256 = (state_65370[(18)]);
var inst_65335 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65256], 0));
var inst_65336 = ["Invalid block range provided: ",inst_65335].join('');
var inst_65337 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65338 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65339 = cljs.core.PersistentHashMap.fromArrays(inst_65337,inst_65338);
var inst_65340 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65336,inst_65339);
var inst_65341 = (function(){throw inst_65340})();
var state_65370__$1 = state_65370;
var statearr_65411_65475 = state_65370__$1;
(statearr_65411_65475[(2)] = inst_65341);

(statearr_65411_65475[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (19))){
var inst_65279 = (state_65370[(8)]);
var inst_65294 = (state_65370[(2)]);
var state_65370__$1 = (function (){var statearr_65412 = state_65370;
(statearr_65412[(19)] = inst_65294);

return statearr_65412;
})();
if(cljs.core.truth_(inst_65279)){
var statearr_65413_65476 = state_65370__$1;
(statearr_65413_65476[(1)] = (20));

} else {
var statearr_65414_65477 = state_65370__$1;
(statearr_65414_65477[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (11))){
var inst_65279 = (state_65370[(8)]);
var inst_65281 = (state_65370[(14)]);
var inst_65278 = (state_65370[(2)]);
var inst_65279__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65278,(0),null);
var inst_65280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65278,(1),null);
var inst_65281__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65282 = (inst_65279__$1 > inst_65281__$1);
var state_65370__$1 = (function (){var statearr_65416 = state_65370;
(statearr_65416[(8)] = inst_65279__$1);

(statearr_65416[(7)] = inst_65280);

(statearr_65416[(14)] = inst_65281__$1);

return statearr_65416;
})();
if(cljs.core.truth_(inst_65282)){
var statearr_65417_65478 = state_65370__$1;
(statearr_65417_65478[(1)] = (17));

} else {
var statearr_65418_65479 = state_65370__$1;
(statearr_65418_65479[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (9))){
var inst_65256 = (state_65370[(18)]);
var inst_65259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65260 = cljs.core.first(inst_65256);
var inst_65261 = fluree.db.time_travel.block_to_int_format(db,inst_65260);
var state_65370__$1 = (function (){var statearr_65419 = state_65370;
(statearr_65419[(12)] = inst_65259);

return statearr_65419;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65370__$1,(12),inst_65261);
} else {
if((state_val_65371 === (5))){
var _ = (function (){var statearr_65420 = state_65370;
(statearr_65420[(4)] = cljs.core.rest((state_65370[(4)])));

return statearr_65420;
})();
var state_65370__$1 = state_65370;
var ex65415 = (state_65370__$1[(2)]);
var statearr_65421_65480 = state_65370__$1;
(statearr_65421_65480[(5)] = ex65415);


if((ex65415 instanceof Error)){
var statearr_65422_65481 = state_65370__$1;
(statearr_65422_65481[(1)] = (4));

(statearr_65422_65481[(5)] = null);

} else {
throw ex65415;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (14))){
var state_65370__$1 = state_65370;
var statearr_65423_65482 = state_65370__$1;
(statearr_65423_65482[(2)] = null);

(statearr_65423_65482[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (26))){
var inst_65279 = (state_65370[(8)]);
var inst_65305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65306 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65307 = [inst_65279,inst_65306];
var inst_65308 = (new cljs.core.PersistentVector(null,2,(5),inst_65305,inst_65307,null));
var state_65370__$1 = state_65370;
var statearr_65424_65483 = state_65370__$1;
(statearr_65424_65483[(2)] = inst_65308);

(statearr_65424_65483[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (16))){
var inst_65269 = (state_65370[(2)]);
var inst_65270 = fluree.db.util.async.throw_err(inst_65269);
var state_65370__$1 = state_65370;
var statearr_65425_65484 = state_65370__$1;
(statearr_65425_65484[(2)] = inst_65270);

(statearr_65425_65484[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (38))){
var inst_65325 = (state_65370[(9)]);
var inst_65326 = (state_65370[(10)]);
var inst_65347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65348 = [inst_65326,inst_65325];
var inst_65349 = (new cljs.core.PersistentVector(null,2,(5),inst_65347,inst_65348,null));
var state_65370__$1 = state_65370;
var statearr_65426_65485 = state_65370__$1;
(statearr_65426_65485[(2)] = inst_65349);

(statearr_65426_65485[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (30))){
var state_65370__$1 = state_65370;
var statearr_65427_65486 = state_65370__$1;
(statearr_65427_65486[(2)] = null);

(statearr_65427_65486[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (10))){
var inst_65256 = (state_65370[(18)]);
var state_65370__$1 = state_65370;
var statearr_65428_65487 = state_65370__$1;
(statearr_65428_65487[(2)] = inst_65256);

(statearr_65428_65487[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (18))){
var state_65370__$1 = state_65370;
var statearr_65429_65488 = state_65370__$1;
(statearr_65429_65488[(2)] = null);

(statearr_65429_65488[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (42))){
var inst_65357 = (state_65370[(13)]);
var state_65370__$1 = state_65370;
var statearr_65430_65489 = state_65370__$1;
(statearr_65430_65489[(2)] = inst_65357);

(statearr_65430_65489[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (37))){
var inst_65325 = (state_65370[(9)]);
var inst_65326 = (state_65370[(10)]);
var inst_65344 = (state_65370[(2)]);
var inst_65345 = (inst_65326 < inst_65325);
var state_65370__$1 = (function (){var statearr_65431 = state_65370;
(statearr_65431[(20)] = inst_65344);

return statearr_65431;
})();
if(cljs.core.truth_(inst_65345)){
var statearr_65432_65490 = state_65370__$1;
(statearr_65432_65490[(1)] = (38));

} else {
var statearr_65433_65491 = state_65370__$1;
(statearr_65433_65491[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65371 === (8))){
var inst_65256 = (state_65370[(18)]);
var inst_65256__$1 = (state_65370[(2)]);
var inst_65257 = cljs.core.some(cljs.core.string_QMARK_,inst_65256__$1);
var state_65370__$1 = (function (){var statearr_65434 = state_65370;
(statearr_65434[(18)] = inst_65256__$1);

return statearr_65434;
})();
if(cljs.core.truth_(inst_65257)){
var statearr_65435_65492 = state_65370__$1;
(statearr_65435_65492[(1)] = (9));

} else {
var statearr_65436_65493 = state_65370__$1;
(statearr_65436_65493[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0 = (function (){
var statearr_65437 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65437[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__);

(statearr_65437[(1)] = (1));

return statearr_65437;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1 = (function (state_65370){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65370);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65438){var ex__2730__auto__ = e65438;
var statearr_65439_65494 = state_65370;
(statearr_65439_65494[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65370[(4)]))){
var statearr_65440_65495 = state_65370;
(statearr_65440_65495[(1)] = cljs.core.first((state_65370[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65496 = state_65370;
state_65370 = G__65496;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__ = function(state_65370){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1.call(this,state_65370);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65441 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65441[(6)] = c__2749__auto__);

return statearr_65441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65646){
var state_val_65647 = (state_65646[(1)]);
if((state_val_65647 === (7))){
var inst_65558 = (state_65646[(2)]);
var inst_65559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65558,(0),null);
var inst_65560 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65558,(1),null);
var inst_65568 = cljs.core.vals(inst_65560);
var inst_65569 = cljs.core.seq(inst_65568);
var inst_65570 = cljs.core.first(inst_65569);
var inst_65571 = cljs.core.next(inst_65569);
var inst_65572 = cljs.core.PersistentVector.EMPTY;
var inst_65573 = inst_65568;
var inst_65574 = inst_65572;
var state_65646__$1 = (function (){var statearr_65648 = state_65646;
(statearr_65648[(7)] = inst_65570);

(statearr_65648[(8)] = inst_65559);

(statearr_65648[(9)] = inst_65573);

(statearr_65648[(10)] = inst_65574);

(statearr_65648[(11)] = inst_65571);

return statearr_65648;
})();
var statearr_65649_65702 = state_65646__$1;
(statearr_65649_65702[(2)] = null);

(statearr_65649_65702[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (20))){
var inst_65580 = (state_65646[(12)]);
var inst_65585 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_65586 = cljs.core.PersistentHashMap.EMPTY;
var inst_65587 = [true,inst_65586];
var inst_65588 = cljs.core.PersistentHashMap.fromArrays(inst_65585,inst_65587);
var inst_65589 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_65588,inst_65580);
var state_65646__$1 = state_65646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65646__$1,(22),inst_65589);
} else {
if((state_val_65647 === (27))){
var inst_65634 = (state_65646[(2)]);
var state_65646__$1 = state_65646;
var statearr_65650_65703 = state_65646__$1;
(statearr_65650_65703[(2)] = inst_65634);

(statearr_65650_65703[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (1))){
var state_65646__$1 = state_65646;
var statearr_65651_65704 = state_65646__$1;
(statearr_65651_65704[(2)] = null);

(statearr_65651_65704[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (24))){
var inst_65598 = (state_65646[(13)]);
var inst_65636 = (state_65646[(2)]);
var inst_65637 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_65638 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_65639 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_65640 = [inst_65638,inst_65639,inst_65598,inst_65636];
var inst_65641 = cljs.core.PersistentHashMap.fromArrays(inst_65637,inst_65640);
var _ = (function (){var statearr_65653 = state_65646;
(statearr_65653[(4)] = cljs.core.rest((state_65646[(4)])));

return statearr_65653;
})();
var state_65646__$1 = state_65646;
var statearr_65654_65705 = state_65646__$1;
(statearr_65654_65705[(2)] = inst_65641);

(statearr_65654_65705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (4))){
var inst_65499 = (state_65646[(2)]);
var state_65646__$1 = state_65646;
var statearr_65655_65706 = state_65646__$1;
(statearr_65655_65706[(2)] = inst_65499);

(statearr_65655_65706[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (15))){
var inst_65518 = (state_65646[(14)]);
var inst_65537 = (state_65646[(15)]);
var inst_65521 = (state_65646[(16)]);
var inst_65522 = (state_65646[(17)]);
var inst_65544 = (state_65646[(18)]);
var inst_65539 = (state_65646[(19)]);
var inst_65530 = (state_65646[(20)]);
var inst_65523 = (state_65646[(21)]);
var inst_65517 = (state_65646[(22)]);
var inst_65529 = (state_65646[(23)]);
var inst_65515 = (state_65646[(24)]);
var inst_65550 = (function (){var first__65527 = inst_65529;
var subject = inst_65537;
var flake = inst_65529;
var vec__65512 = inst_65515;
var seq__65513 = inst_65518;
var r = inst_65530;
var asserted_subjects = inst_65522;
var vec__65525 = inst_65521;
var G__65511 = inst_65521;
var flake_SINGLEQUOTE_ = inst_65544;
var first__65514 = inst_65517;
var retracted_subjects = inst_65523;
var asserted_QMARK_ = inst_65539;
var seq__65526 = inst_65530;
return (function (p1__65498_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__65498_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_65551 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_65523,inst_65537,inst_65550);
var tmp65652 = inst_65522;
var inst_65521__$1 = inst_65530;
var inst_65522__$1 = tmp65652;
var inst_65523__$1 = inst_65551;
var state_65646__$1 = (function (){var statearr_65656 = state_65646;
(statearr_65656[(16)] = inst_65521__$1);

(statearr_65656[(17)] = inst_65522__$1);

(statearr_65656[(21)] = inst_65523__$1);

return statearr_65656;
})();
var statearr_65657_65707 = state_65646__$1;
(statearr_65657_65707[(2)] = null);

(statearr_65657_65707[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (21))){
var inst_65596 = (state_65646[(2)]);
var state_65646__$1 = state_65646;
var statearr_65658_65708 = state_65646__$1;
(statearr_65658_65708[(2)] = inst_65596);

(statearr_65658_65708[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (13))){
var inst_65539 = (state_65646[(19)]);
var inst_65544 = (state_65646[(2)]);
var state_65646__$1 = (function (){var statearr_65659 = state_65646;
(statearr_65659[(18)] = inst_65544);

return statearr_65659;
})();
if(cljs.core.truth_(inst_65539)){
var statearr_65660_65709 = state_65646__$1;
(statearr_65660_65709[(1)] = (14));

} else {
var statearr_65661_65710 = state_65646__$1;
(statearr_65661_65710[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (22))){
var inst_65581 = (state_65646[(25)]);
var inst_65574 = (state_65646[(10)]);
var inst_65591 = (state_65646[(2)]);
var inst_65592 = fluree.db.util.async.throw_err(inst_65591);
var inst_65593 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_65574,inst_65592);
var inst_65573 = inst_65581;
var inst_65574__$1 = inst_65593;
var state_65646__$1 = (function (){var statearr_65662 = state_65646;
(statearr_65662[(9)] = inst_65573);

(statearr_65662[(10)] = inst_65574__$1);

return statearr_65662;
})();
var statearr_65663_65711 = state_65646__$1;
(statearr_65663_65711[(2)] = null);

(statearr_65663_65711[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (6))){
var inst_65521 = (state_65646[(16)]);
var inst_65529 = (state_65646[(23)]);
var inst_65528 = cljs.core.seq(inst_65521);
var inst_65529__$1 = cljs.core.first(inst_65528);
var inst_65530 = cljs.core.next(inst_65528);
var inst_65531 = cljs.core.not(inst_65529__$1);
var state_65646__$1 = (function (){var statearr_65664 = state_65646;
(statearr_65664[(20)] = inst_65530);

(statearr_65664[(23)] = inst_65529__$1);

return statearr_65664;
})();
if(inst_65531){
var statearr_65665_65712 = state_65646__$1;
(statearr_65665_65712[(1)] = (8));

} else {
var statearr_65666_65713 = state_65646__$1;
(statearr_65666_65713[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (28))){
var inst_65619 = (state_65646[(26)]);
var inst_65612 = (state_65646[(27)]);
var inst_65629 = (state_65646[(2)]);
var inst_65630 = fluree.db.util.async.throw_err(inst_65629);
var inst_65631 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_65612,inst_65630);
var inst_65611 = inst_65619;
var inst_65612__$1 = inst_65631;
var state_65646__$1 = (function (){var statearr_65667 = state_65646;
(statearr_65667[(27)] = inst_65612__$1);

(statearr_65667[(28)] = inst_65611);

return statearr_65667;
})();
var statearr_65668_65714 = state_65646__$1;
(statearr_65668_65714[(2)] = null);

(statearr_65668_65714[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (25))){
var inst_65612 = (state_65646[(27)]);
var state_65646__$1 = state_65646;
var statearr_65669_65715 = state_65646__$1;
(statearr_65669_65715[(2)] = inst_65612);

(statearr_65669_65715[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (17))){
var inst_65573 = (state_65646[(9)]);
var inst_65580 = (state_65646[(12)]);
var inst_65579 = cljs.core.seq(inst_65573);
var inst_65580__$1 = cljs.core.first(inst_65579);
var inst_65581 = cljs.core.next(inst_65579);
var inst_65582 = cljs.core.not(inst_65580__$1);
var state_65646__$1 = (function (){var statearr_65670 = state_65646;
(statearr_65670[(25)] = inst_65581);

(statearr_65670[(12)] = inst_65580__$1);

return statearr_65670;
})();
if(inst_65582){
var statearr_65671_65716 = state_65646__$1;
(statearr_65671_65716[(1)] = (19));

} else {
var statearr_65672_65717 = state_65646__$1;
(statearr_65672_65717[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (3))){
var inst_65644 = (state_65646[(2)]);
var state_65646__$1 = state_65646;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65646__$1,inst_65644);
} else {
if((state_val_65647 === (12))){
var inst_65529 = (state_65646[(23)]);
var inst_65542 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_65529);
var state_65646__$1 = state_65646;
var statearr_65673_65718 = state_65646__$1;
(statearr_65673_65718[(2)] = inst_65542);

(statearr_65673_65718[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (2))){
var inst_65515 = (state_65646[(24)]);
var _ = (function (){var statearr_65674 = state_65646;
(statearr_65674[(4)] = cljs.core.cons((5),(state_65646[(4)])));

return statearr_65674;
})();
var inst_65515__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_65516 = cljs.core.seq(inst_65515__$1);
var inst_65517 = cljs.core.first(inst_65516);
var inst_65518 = cljs.core.next(inst_65516);
var inst_65519 = cljs.core.PersistentHashMap.EMPTY;
var inst_65520 = cljs.core.PersistentHashMap.EMPTY;
var inst_65521 = inst_65515__$1;
var inst_65522 = inst_65519;
var inst_65523 = inst_65520;
var state_65646__$1 = (function (){var statearr_65675 = state_65646;
(statearr_65675[(14)] = inst_65518);

(statearr_65675[(16)] = inst_65521);

(statearr_65675[(17)] = inst_65522);

(statearr_65675[(21)] = inst_65523);

(statearr_65675[(22)] = inst_65517);

(statearr_65675[(24)] = inst_65515__$1);

return statearr_65675;
})();
var statearr_65676_65719 = state_65646__$1;
(statearr_65676_65719[(2)] = null);

(statearr_65676_65719[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (23))){
var inst_65611 = (state_65646[(28)]);
var inst_65618 = (state_65646[(29)]);
var inst_65617 = cljs.core.seq(inst_65611);
var inst_65618__$1 = cljs.core.first(inst_65617);
var inst_65619 = cljs.core.next(inst_65617);
var inst_65620 = cljs.core.not(inst_65618__$1);
var state_65646__$1 = (function (){var statearr_65677 = state_65646;
(statearr_65677[(26)] = inst_65619);

(statearr_65677[(29)] = inst_65618__$1);

return statearr_65677;
})();
if(inst_65620){
var statearr_65678_65720 = state_65646__$1;
(statearr_65678_65720[(1)] = (25));

} else {
var statearr_65679_65721 = state_65646__$1;
(statearr_65679_65721[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (19))){
var inst_65574 = (state_65646[(10)]);
var state_65646__$1 = state_65646;
var statearr_65680_65722 = state_65646__$1;
(statearr_65680_65722[(2)] = inst_65574);

(statearr_65680_65722[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (11))){
var inst_65529 = (state_65646[(23)]);
var state_65646__$1 = state_65646;
var statearr_65682_65723 = state_65646__$1;
(statearr_65682_65723[(2)] = inst_65529);

(statearr_65682_65723[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (9))){
var inst_65539 = (state_65646[(19)]);
var inst_65529 = (state_65646[(23)]);
var inst_65537 = fluree.db.flake.s(inst_65529);
var inst_65538 = fluree.db.flake.op(inst_65529);
var inst_65539__$1 = inst_65538 === true;
var state_65646__$1 = (function (){var statearr_65684 = state_65646;
(statearr_65684[(15)] = inst_65537);

(statearr_65684[(19)] = inst_65539__$1);

return statearr_65684;
})();
if(cljs.core.truth_(inst_65539__$1)){
var statearr_65685_65724 = state_65646__$1;
(statearr_65685_65724[(1)] = (11));

} else {
var statearr_65686_65725 = state_65646__$1;
(statearr_65686_65725[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (5))){
var _ = (function (){var statearr_65687 = state_65646;
(statearr_65687[(4)] = cljs.core.rest((state_65646[(4)])));

return statearr_65687;
})();
var state_65646__$1 = state_65646;
var ex65681 = (state_65646__$1[(2)]);
var statearr_65688_65726 = state_65646__$1;
(statearr_65688_65726[(5)] = ex65681);


if((ex65681 instanceof Error)){
var statearr_65689_65727 = state_65646__$1;
(statearr_65689_65727[(1)] = (4));

(statearr_65689_65727[(5)] = null);

} else {
throw ex65681;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (14))){
var inst_65518 = (state_65646[(14)]);
var inst_65537 = (state_65646[(15)]);
var inst_65521 = (state_65646[(16)]);
var inst_65522 = (state_65646[(17)]);
var inst_65544 = (state_65646[(18)]);
var inst_65539 = (state_65646[(19)]);
var inst_65530 = (state_65646[(20)]);
var inst_65523 = (state_65646[(21)]);
var inst_65517 = (state_65646[(22)]);
var inst_65529 = (state_65646[(23)]);
var inst_65515 = (state_65646[(24)]);
var inst_65546 = (function (){var first__65527 = inst_65529;
var subject = inst_65537;
var flake = inst_65529;
var vec__65512 = inst_65515;
var seq__65513 = inst_65518;
var r = inst_65530;
var asserted_subjects = inst_65522;
var vec__65525 = inst_65521;
var G__65511 = inst_65521;
var flake_SINGLEQUOTE_ = inst_65544;
var first__65514 = inst_65517;
var retracted_subjects = inst_65523;
var asserted_QMARK_ = inst_65539;
var seq__65526 = inst_65530;
return (function (p1__65497_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__65497_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_65547 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_65522,inst_65537,inst_65546);
var tmp65683 = inst_65523;
var inst_65521__$1 = inst_65530;
var inst_65522__$1 = inst_65547;
var inst_65523__$1 = tmp65683;
var state_65646__$1 = (function (){var statearr_65690 = state_65646;
(statearr_65690[(16)] = inst_65521__$1);

(statearr_65690[(17)] = inst_65522__$1);

(statearr_65690[(21)] = inst_65523__$1);

return statearr_65690;
})();
var statearr_65691_65728 = state_65646__$1;
(statearr_65691_65728[(2)] = null);

(statearr_65691_65728[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (26))){
var inst_65618 = (state_65646[(29)]);
var inst_65623 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_65624 = cljs.core.PersistentHashMap.EMPTY;
var inst_65625 = [true,inst_65624];
var inst_65626 = cljs.core.PersistentHashMap.fromArrays(inst_65623,inst_65625);
var inst_65627 = fluree.db.query.fql_resp.flakes__GT_res(db,cache,fuel,(1000000),inst_65626,inst_65618);
var state_65646__$1 = state_65646;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65646__$1,(28),inst_65627);
} else {
if((state_val_65647 === (16))){
var inst_65554 = (state_65646[(2)]);
var state_65646__$1 = state_65646;
var statearr_65692_65729 = state_65646__$1;
(statearr_65692_65729[(2)] = inst_65554);

(statearr_65692_65729[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (10))){
var inst_65556 = (state_65646[(2)]);
var state_65646__$1 = state_65646;
var statearr_65693_65730 = state_65646__$1;
(statearr_65693_65730[(2)] = inst_65556);

(statearr_65693_65730[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (18))){
var inst_65559 = (state_65646[(8)]);
var inst_65598 = (state_65646[(2)]);
var inst_65606 = cljs.core.vals(inst_65559);
var inst_65607 = cljs.core.seq(inst_65606);
var inst_65608 = cljs.core.first(inst_65607);
var inst_65609 = cljs.core.next(inst_65607);
var inst_65610 = cljs.core.PersistentVector.EMPTY;
var inst_65611 = inst_65606;
var inst_65612 = inst_65610;
var state_65646__$1 = (function (){var statearr_65694 = state_65646;
(statearr_65694[(13)] = inst_65598);

(statearr_65694[(30)] = inst_65609);

(statearr_65694[(27)] = inst_65612);

(statearr_65694[(31)] = inst_65608);

(statearr_65694[(28)] = inst_65611);

return statearr_65694;
})();
var statearr_65695_65731 = state_65646__$1;
(statearr_65695_65731[(2)] = null);

(statearr_65695_65731[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65647 === (8))){
var inst_65522 = (state_65646[(17)]);
var inst_65523 = (state_65646[(21)]);
var inst_65533 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65534 = [inst_65522,inst_65523];
var inst_65535 = (new cljs.core.PersistentVector(null,2,(5),inst_65533,inst_65534,null));
var state_65646__$1 = state_65646;
var statearr_65696_65732 = state_65646__$1;
(statearr_65696_65732[(2)] = inst_65535);

(statearr_65696_65732[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_65697 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65697[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__);

(statearr_65697[(1)] = (1));

return statearr_65697;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1 = (function (state_65646){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65646);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65698){var ex__2730__auto__ = e65698;
var statearr_65699_65733 = state_65646;
(statearr_65699_65733[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65646[(4)]))){
var statearr_65700_65734 = state_65646;
(statearr_65700_65734[(1)] = cljs.core.first((state_65646[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65735 = state_65646;
state_65646 = G__65735;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__ = function(state_65646){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1.call(this,state_65646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65701 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65701[(6)] = c__2749__auto__);

return statearr_65701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65767){
var state_val_65768 = (state_65767[(1)]);
if((state_val_65768 === (1))){
var inst_65736 = cljs.core.volatile_BANG_((0));
var inst_65737 = cljs.core.PersistentHashMap.EMPTY;
var inst_65738 = cljs.core.volatile_BANG_(inst_65737);
var inst_65739 = cljs.core.first(resp);
var inst_65740 = cljs.core.rest(resp);
var inst_65741 = cljs.core.PersistentVector.EMPTY;
var inst_65742 = inst_65736;
var inst_65743 = inst_65738;
var inst_65744 = inst_65739;
var inst_65745 = inst_65740;
var inst_65746 = inst_65741;
var state_65767__$1 = (function (){var statearr_65769 = state_65767;
(statearr_65769[(7)] = inst_65742);

(statearr_65769[(8)] = inst_65745);

(statearr_65769[(9)] = inst_65746);

(statearr_65769[(10)] = inst_65743);

(statearr_65769[(11)] = inst_65744);

return statearr_65769;
})();
var statearr_65770_65785 = state_65767__$1;
(statearr_65770_65785[(2)] = null);

(statearr_65770_65785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65768 === (2))){
var inst_65742 = (state_65767[(7)]);
var inst_65743 = (state_65767[(10)]);
var inst_65744 = (state_65767[(11)]);
var inst_65748 = fluree.db.api.query.format_block_resp_pretty(db,inst_65744,inst_65743,inst_65742);
var state_65767__$1 = state_65767;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65767__$1,(4),inst_65748);
} else {
if((state_val_65768 === (3))){
var inst_65765 = (state_65767[(2)]);
var state_65767__$1 = state_65767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65767__$1,inst_65765);
} else {
if((state_val_65768 === (4))){
var inst_65745 = (state_65767[(8)]);
var inst_65746 = (state_65767[(9)]);
var inst_65750 = (state_65767[(2)]);
var inst_65751 = fluree.db.util.async.throw_err(inst_65750);
var inst_65752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65753 = [inst_65751];
var inst_65754 = (new cljs.core.PersistentVector(null,1,(5),inst_65752,inst_65753,null));
var inst_65755 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_65746,inst_65754);
var inst_65756 = cljs.core.first(inst_65745);
var state_65767__$1 = (function (){var statearr_65773 = state_65767;
(statearr_65773[(12)] = inst_65755);

return statearr_65773;
})();
if(cljs.core.truth_(inst_65756)){
var statearr_65774_65786 = state_65767__$1;
(statearr_65774_65786[(1)] = (5));

} else {
var statearr_65775_65787 = state_65767__$1;
(statearr_65775_65787[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65768 === (5))){
var inst_65742 = (state_65767[(7)]);
var inst_65755 = (state_65767[(12)]);
var inst_65745 = (state_65767[(8)]);
var inst_65743 = (state_65767[(10)]);
var inst_65758 = cljs.core.first(inst_65745);
var inst_65759 = cljs.core.rest(inst_65745);
var tmp65771 = inst_65742;
var tmp65772 = inst_65743;
var inst_65742__$1 = tmp65771;
var inst_65743__$1 = tmp65772;
var inst_65744 = inst_65758;
var inst_65745__$1 = inst_65759;
var inst_65746 = inst_65755;
var state_65767__$1 = (function (){var statearr_65776 = state_65767;
(statearr_65776[(7)] = inst_65742__$1);

(statearr_65776[(8)] = inst_65745__$1);

(statearr_65776[(9)] = inst_65746);

(statearr_65776[(10)] = inst_65743__$1);

(statearr_65776[(11)] = inst_65744);

return statearr_65776;
})();
var statearr_65777_65788 = state_65767__$1;
(statearr_65777_65788[(2)] = null);

(statearr_65777_65788[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65768 === (6))){
var inst_65755 = (state_65767[(12)]);
var state_65767__$1 = state_65767;
var statearr_65778_65789 = state_65767__$1;
(statearr_65778_65789[(2)] = inst_65755);

(statearr_65778_65789[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65768 === (7))){
var inst_65763 = (state_65767[(2)]);
var state_65767__$1 = state_65767;
var statearr_65779_65790 = state_65767__$1;
(statearr_65779_65790[(2)] = inst_65763);

(statearr_65779_65790[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0 = (function (){
var statearr_65780 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65780[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__);

(statearr_65780[(1)] = (1));

return statearr_65780;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1 = (function (state_65767){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65767);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65781){var ex__2730__auto__ = e65781;
var statearr_65782_65791 = state_65767;
(statearr_65782_65791[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65767[(4)]))){
var statearr_65783_65792 = state_65767;
(statearr_65783_65792[(1)] = cljs.core.first((state_65767[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65793 = state_65767;
state_65767 = G__65793;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__ = function(state_65767){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1.call(this,state_65767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65784 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65784[(6)] = c__2749__auto__);

return statearr_65784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__65795 = arguments.length;
switch (G__65795) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__65797){
var map__65798 = p__65797;
var map__65798__$1 = cljs.core.__destructure_map(map__65798);
var query = map__65798__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65798__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_65883){
var state_val_65884 = (state_65883[(1)]);
if((state_val_65884 === (7))){
var inst_65809 = (state_65883[(7)]);
var inst_65813 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65814 = ["_auth/id",inst_65809];
var inst_65815 = (new cljs.core.PersistentVector(null,2,(5),inst_65813,inst_65814,null));
var state_65883__$1 = state_65883;
var statearr_65885_65929 = state_65883__$1;
(statearr_65885_65929[(2)] = inst_65815);

(statearr_65885_65929[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (20))){
var inst_65863 = (state_65883[(2)]);
var inst_65864 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_65883__$1 = (function (){var statearr_65886 = state_65883;
(statearr_65886[(8)] = inst_65863);

return statearr_65886;
})();
if(cljs.core.truth_(inst_65864)){
var statearr_65887_65930 = state_65883__$1;
(statearr_65887_65930[(1)] = (22));

} else {
var statearr_65888_65931 = state_65883__$1;
(statearr_65888_65931[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (27))){
var inst_65810 = (state_65883[(9)]);
var inst_65866 = (state_65883[(10)]);
var inst_65872 = (state_65883[(2)]);
var inst_65873 = fluree.db.util.core.response_time_formatted(inst_65810);
var inst_65874 = [(200),inst_65872,(100),inst_65873];
var inst_65875 = cljs.core.PersistentHashMap.fromArrays(inst_65866,inst_65874);
var state_65883__$1 = state_65883;
var statearr_65889_65932 = state_65883__$1;
(statearr_65889_65932[(2)] = inst_65875);

(statearr_65889_65932[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (1))){
var state_65883__$1 = state_65883;
var statearr_65890_65933 = state_65883__$1;
(statearr_65890_65933[(2)] = null);

(statearr_65890_65933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (24))){
var inst_65878 = (state_65883[(2)]);
var _ = (function (){var statearr_65891 = state_65883;
(statearr_65891[(4)] = cljs.core.rest((state_65883[(4)])));

return statearr_65891;
})();
var state_65883__$1 = state_65883;
var statearr_65892_65934 = state_65883__$1;
(statearr_65892_65934[(2)] = inst_65878);

(statearr_65892_65934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (4))){
var inst_65799 = (state_65883[(2)]);
var state_65883__$1 = state_65883;
var statearr_65893_65935 = state_65883__$1;
(statearr_65893_65935[(2)] = inst_65799);

(statearr_65893_65935[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (15))){
var inst_65850 = (state_65883[(11)]);
var state_65883__$1 = state_65883;
var statearr_65894_65936 = state_65883__$1;
(statearr_65894_65936[(2)] = inst_65850);

(statearr_65894_65936[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (21))){
var inst_65859 = (state_65883[(2)]);
var inst_65860 = fluree.db.util.async.throw_err(inst_65859);
var state_65883__$1 = state_65883;
var statearr_65895_65937 = state_65883__$1;
(statearr_65895_65937[(2)] = inst_65860);

(statearr_65895_65937[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (13))){
var inst_65850 = (state_65883[(11)]);
var inst_65808 = (state_65883[(12)]);
var inst_65849 = (state_65883[(2)]);
var inst_65850__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_65808);
var state_65883__$1 = (function (){var statearr_65896 = state_65883;
(statearr_65896[(11)] = inst_65850__$1);

(statearr_65896[(13)] = inst_65849);

return statearr_65896;
})();
if(cljs.core.truth_(inst_65850__$1)){
var statearr_65897_65938 = state_65883__$1;
(statearr_65897_65938[(1)] = (15));

} else {
var statearr_65898_65939 = state_65883__$1;
(statearr_65898_65939[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (22))){
var inst_65863 = (state_65883[(8)]);
var inst_65866 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65867 = cljs.core.sequential_QMARK_(inst_65863);
var state_65883__$1 = (function (){var statearr_65899 = state_65883;
(statearr_65899[(10)] = inst_65866);

return statearr_65899;
})();
if(inst_65867){
var statearr_65900_65940 = state_65883__$1;
(statearr_65900_65940[(1)] = (25));

} else {
var statearr_65901_65941 = state_65883__$1;
(statearr_65901_65941[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (6))){
var inst_65824 = (state_65883[(14)]);
var inst_65808 = (state_65883[(12)]);
var inst_65823 = (state_65883[(2)]);
var inst_65824__$1 = fluree.db.util.async.throw_err(inst_65823);
var inst_65825 = fluree.db.api.query.resolve_block_range(inst_65824__$1,inst_65808);
var state_65883__$1 = (function (){var statearr_65902 = state_65883;
(statearr_65902[(14)] = inst_65824__$1);

return statearr_65902;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65883__$1,(10),inst_65825);
} else {
if((state_val_65884 === (25))){
var inst_65863 = (state_65883[(8)]);
var inst_65869 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_65863);
var state_65883__$1 = state_65883;
var statearr_65903_65942 = state_65883__$1;
(statearr_65903_65942[(2)] = inst_65869);

(statearr_65903_65942[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (17))){
var inst_65855 = (state_65883[(2)]);
var state_65883__$1 = state_65883;
if(cljs.core.truth_(inst_65855)){
var statearr_65904_65943 = state_65883__$1;
(statearr_65904_65943[(1)] = (18));

} else {
var statearr_65905_65944 = state_65883__$1;
(statearr_65905_65944[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (3))){
var inst_65881 = (state_65883[(2)]);
var state_65883__$1 = state_65883;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65883__$1,inst_65881);
} else {
if((state_val_65884 === (12))){
var inst_65808 = (state_65883[(12)]);
var inst_65841 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65808], 0));
var inst_65842 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65841].join('');
var inst_65843 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65844 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65845 = cljs.core.PersistentHashMap.fromArrays(inst_65843,inst_65844);
var inst_65846 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65842,inst_65845);
var inst_65847 = (function(){throw inst_65846})();
var state_65883__$1 = state_65883;
var statearr_65906_65945 = state_65883__$1;
(statearr_65906_65945[(2)] = inst_65847);

(statearr_65906_65945[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (2))){
var inst_65809 = (state_65883[(7)]);
var _ = (function (){var statearr_65907 = state_65883;
(statearr_65907[(4)] = cljs.core.cons((5),(state_65883[(4)])));

return statearr_65907;
})();
var inst_65808 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_65809__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_65810 = fluree.db.util.core.current_time_millis();
var inst_65811 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_65883__$1 = (function (){var statearr_65908 = state_65883;
(statearr_65908[(9)] = inst_65810);

(statearr_65908[(15)] = inst_65811);

(statearr_65908[(7)] = inst_65809__$1);

(statearr_65908[(12)] = inst_65808);

return statearr_65908;
})();
if(cljs.core.truth_(inst_65809__$1)){
var statearr_65909_65946 = state_65883__$1;
(statearr_65909_65946[(1)] = (7));

} else {
var statearr_65910_65947 = state_65883__$1;
(statearr_65910_65947[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (23))){
var inst_65863 = (state_65883[(8)]);
var state_65883__$1 = state_65883;
var statearr_65911_65948 = state_65883__$1;
(statearr_65911_65948[(2)] = inst_65863);

(statearr_65911_65948[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (19))){
var inst_65849 = (state_65883[(13)]);
var state_65883__$1 = state_65883;
var statearr_65912_65949 = state_65883__$1;
(statearr_65912_65949[(2)] = inst_65849);

(statearr_65912_65949[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (11))){
var inst_65824 = (state_65883[(14)]);
var inst_65829 = (state_65883[(16)]);
var inst_65830 = (state_65883[(17)]);
var inst_65836 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_65824,inst_65829,inst_65830,opts);
var state_65883__$1 = state_65883;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65883__$1,(14),inst_65836);
} else {
if((state_val_65884 === (9))){
var inst_65811 = (state_65883[(15)]);
var inst_65818 = (state_65883[(2)]);
var inst_65819 = [inst_65818];
var inst_65820 = cljs.core.PersistentHashMap.fromArrays(inst_65811,inst_65819);
var inst_65821 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_65820);
var state_65883__$1 = state_65883;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65883__$1,(6),inst_65821);
} else {
if((state_val_65884 === (5))){
var _ = (function (){var statearr_65914 = state_65883;
(statearr_65914[(4)] = cljs.core.rest((state_65883[(4)])));

return statearr_65914;
})();
var state_65883__$1 = state_65883;
var ex65913 = (state_65883__$1[(2)]);
var statearr_65915_65950 = state_65883__$1;
(statearr_65915_65950[(5)] = ex65913);


if((ex65913 instanceof Error)){
var statearr_65916_65951 = state_65883__$1;
(statearr_65916_65951[(1)] = (4));

(statearr_65916_65951[(5)] = null);

} else {
throw ex65913;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (14))){
var inst_65838 = (state_65883[(2)]);
var inst_65839 = fluree.db.util.async.throw_err(inst_65838);
var state_65883__$1 = state_65883;
var statearr_65917_65952 = state_65883__$1;
(statearr_65917_65952[(2)] = inst_65839);

(statearr_65917_65952[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (26))){
var inst_65863 = (state_65883[(8)]);
var state_65883__$1 = state_65883;
var statearr_65918_65953 = state_65883__$1;
(statearr_65918_65953[(2)] = inst_65863);

(statearr_65918_65953[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (16))){
var inst_65808 = (state_65883[(12)]);
var inst_65853 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_65808);
var state_65883__$1 = state_65883;
var statearr_65919_65954 = state_65883__$1;
(statearr_65919_65954[(2)] = inst_65853);

(statearr_65919_65954[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (10))){
var inst_65808 = (state_65883[(12)]);
var inst_65827 = (state_65883[(2)]);
var inst_65828 = fluree.db.util.async.throw_err(inst_65827);
var inst_65829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65828,(0),null);
var inst_65830 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65828,(1),null);
var inst_65831 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65832 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_65808,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_65833 = cljs.core.keys(inst_65832);
var inst_65834 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65831,inst_65833);
var state_65883__$1 = (function (){var statearr_65920 = state_65883;
(statearr_65920[(16)] = inst_65829);

(statearr_65920[(17)] = inst_65830);

return statearr_65920;
})();
if(inst_65834){
var statearr_65921_65955 = state_65883__$1;
(statearr_65921_65955[(1)] = (11));

} else {
var statearr_65922_65956 = state_65883__$1;
(statearr_65922_65956[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65884 === (18))){
var inst_65824 = (state_65883[(14)]);
var inst_65849 = (state_65883[(13)]);
var inst_65857 = fluree.db.api.query.format_blocks_resp_pretty(inst_65824,inst_65849);
var state_65883__$1 = state_65883;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65883__$1,(21),inst_65857);
} else {
if((state_val_65884 === (8))){
var state_65883__$1 = state_65883;
var statearr_65923_65957 = state_65883__$1;
(statearr_65923_65957[(2)] = null);

(statearr_65923_65957[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_65924 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65924[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2727__auto__);

(statearr_65924[(1)] = (1));

return statearr_65924;
});
var fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1 = (function (state_65883){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_65883);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e65925){var ex__2730__auto__ = e65925;
var statearr_65926_65958 = state_65883;
(statearr_65926_65958[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_65883[(4)]))){
var statearr_65927_65959 = state_65883;
(statearr_65927_65959[(1)] = cljs.core.first((state_65883[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65960 = state_65883;
state_65883 = G__65960;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__ = function(state_65883){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1.call(this,state_65883);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_65928 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_65928[(6)] = c__2749__auto__);

return statearr_65928;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__65961 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65961,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65961,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65961,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65961,(3),null);
var vec__65964 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65964,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65964,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__65967 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.t(flake),new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65967,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65967,(1),null);
var or__5045__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__5775__auto__ = [];
var len__5769__auto___65971 = arguments.length;
var i__5770__auto___65972 = (0);
while(true){
if((i__5770__auto___65972 < len__5769__auto___65971)){
args__5775__auto__.push((arguments[i__5770__auto___65972]));

var G__65973 = (i__5770__auto___65972 + (1));
i__5770__auto___65972 = G__65973;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq65970){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq65970));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66169){
var state_val_66170 = (state_66169[(1)]);
if((state_val_66170 === (7))){
var inst_66096 = (state_66169[(7)]);
var inst_66089 = (state_66169[(8)]);
var inst_66095 = cljs.core.seq(inst_66089);
var inst_66096__$1 = cljs.core.first(inst_66095);
var inst_66097 = cljs.core.next(inst_66095);
var state_66169__$1 = (function (){var statearr_66171 = state_66169;
(statearr_66171[(7)] = inst_66096__$1);

(statearr_66171[(9)] = inst_66097);

return statearr_66171;
})();
if(cljs.core.truth_(inst_66096__$1)){
var statearr_66172_66272 = state_66169__$1;
(statearr_66172_66272[(1)] = (9));

} else {
var statearr_66173_66273 = state_66169__$1;
(statearr_66173_66273[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (20))){
var inst_66159 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
var statearr_66174_66274 = state_66169__$1;
(statearr_66174_66274[(2)] = inst_66159);

(statearr_66174_66274[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (27))){
var inst_66135 = (state_66169[(10)]);
var inst_66114 = (state_66169[(11)]);
var inst_66117 = (state_66169[(12)]);
var inst_66137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66138 = [inst_66117,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_66139 = (new cljs.core.PersistentVector(null,2,(5),inst_66137,inst_66138,null));
var inst_66140 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_66135,inst_66139,fluree.db.api.query.min_safe,inst_66114);
var state_66169__$1 = state_66169;
var statearr_66175_66275 = state_66169__$1;
(statearr_66175_66275[(2)] = inst_66140);

(statearr_66175_66275[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (1))){
var state_66169__$1 = state_66169;
var statearr_66176_66276 = state_66169__$1;
(statearr_66176_66276[(2)] = null);

(statearr_66176_66276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (24))){
var inst_66096 = (state_66169[(7)]);
var inst_66127 = (state_66169[(13)]);
var inst_66117 = (state_66169[(12)]);
var inst_66129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66130 = [inst_66117,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_66131 = (new cljs.core.PersistentVector(null,2,(5),inst_66129,inst_66130,null));
var inst_66132 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_66127,inst_66131,cljs.core.conj,inst_66096);
var state_66169__$1 = state_66169;
var statearr_66178_66277 = state_66169__$1;
(statearr_66178_66277[(2)] = inst_66132);

(statearr_66178_66277[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (4))){
var inst_65975 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
var statearr_66179_66278 = state_66169__$1;
(statearr_66179_66278[(2)] = inst_65975);

(statearr_66179_66278[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (15))){
var inst_66090 = (state_66169[(14)]);
var inst_66097 = (state_66169[(9)]);
var tmp66177 = inst_66090;
var inst_66089 = inst_66097;
var inst_66090__$1 = tmp66177;
var state_66169__$1 = (function (){var statearr_66180 = state_66169;
(statearr_66180[(14)] = inst_66090__$1);

(statearr_66180[(8)] = inst_66089);

return statearr_66180;
})();
var statearr_66181_66279 = state_66169__$1;
(statearr_66181_66279[(2)] = null);

(statearr_66181_66279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (21))){
var inst_66090 = (state_66169[(14)]);
var inst_66117 = (state_66169[(12)]);
var inst_66121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66122 = [inst_66117,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66123 = (new cljs.core.PersistentVector(null,2,(5),inst_66121,inst_66122,null));
var inst_66124 = cljs.core.assoc_in(inst_66090,inst_66123,inst_66117);
var state_66169__$1 = state_66169;
var statearr_66182_66280 = state_66169__$1;
(statearr_66182_66280[(2)] = inst_66124);

(statearr_66182_66280[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (31))){
var inst_66143 = (state_66169[(15)]);
var state_66169__$1 = state_66169;
var statearr_66183_66281 = state_66169__$1;
(statearr_66183_66281[(2)] = inst_66143);

(statearr_66183_66281[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (32))){
var inst_66097 = (state_66169[(9)]);
var inst_66151 = (state_66169[(2)]);
var inst_66089 = inst_66097;
var inst_66090 = inst_66151;
var state_66169__$1 = (function (){var statearr_66184 = state_66169;
(statearr_66184[(14)] = inst_66090);

(statearr_66184[(8)] = inst_66089);

return statearr_66184;
})();
var statearr_66185_66282 = state_66169__$1;
(statearr_66185_66282[(2)] = null);

(statearr_66185_66282[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (33))){
var inst_66090 = (state_66169[(14)]);
var state_66169__$1 = state_66169;
var statearr_66186_66283 = state_66169__$1;
(statearr_66186_66283[(2)] = inst_66090);

(statearr_66186_66283[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (13))){
var inst_66099 = (state_66169[(16)]);
var state_66169__$1 = state_66169;
var statearr_66187_66284 = state_66169__$1;
(statearr_66187_66284[(2)] = inst_66099);

(statearr_66187_66284[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (22))){
var inst_66090 = (state_66169[(14)]);
var state_66169__$1 = state_66169;
var statearr_66188_66285 = state_66169__$1;
(statearr_66188_66285[(2)] = inst_66090);

(statearr_66188_66285[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (29))){
var inst_66143 = (state_66169[(2)]);
var state_66169__$1 = (function (){var statearr_66189 = state_66169;
(statearr_66189[(15)] = inst_66143);

return statearr_66189;
})();
if(cljs.core.truth_(show_auth)){
var statearr_66190_66286 = state_66169__$1;
(statearr_66190_66286[(1)] = (30));

} else {
var statearr_66191_66287 = state_66169__$1;
(statearr_66191_66287[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (6))){
var inst_66075 = (state_66169[(2)]);
var inst_66076 = fluree.db.util.async.throw_err(inst_66075);
var inst_66084 = resp;
var inst_66085 = cljs.core.seq(inst_66084);
var inst_66086 = cljs.core.first(inst_66085);
var inst_66087 = cljs.core.next(inst_66085);
var inst_66088 = cljs.core.PersistentHashMap.EMPTY;
var inst_66089 = inst_66084;
var inst_66090 = inst_66088;
var state_66169__$1 = (function (){var statearr_66192 = state_66169;
(statearr_66192[(14)] = inst_66090);

(statearr_66192[(17)] = inst_66087);

(statearr_66192[(18)] = inst_66076);

(statearr_66192[(19)] = inst_66086);

(statearr_66192[(8)] = inst_66089);

return statearr_66192;
})();
var statearr_66193_66288 = state_66169__$1;
(statearr_66193_66288[(2)] = null);

(statearr_66193_66288[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (28))){
var inst_66135 = (state_66169[(10)]);
var state_66169__$1 = state_66169;
var statearr_66194_66289 = state_66169__$1;
(statearr_66194_66289[(2)] = inst_66135);

(statearr_66194_66289[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (25))){
var inst_66127 = (state_66169[(13)]);
var state_66169__$1 = state_66169;
var statearr_66195_66290 = state_66169__$1;
(statearr_66195_66290[(2)] = inst_66127);

(statearr_66195_66290[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (34))){
var state_66169__$1 = state_66169;
var statearr_66196_66291 = state_66169__$1;
(statearr_66196_66291[(2)] = null);

(statearr_66196_66291[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (17))){
var inst_66161 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
var statearr_66197_66292 = state_66169__$1;
(statearr_66197_66292[(2)] = inst_66161);

(statearr_66197_66292[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (3))){
var inst_66167 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66169__$1,inst_66167);
} else {
if((state_val_66170 === (12))){
var inst_66096 = (state_66169[(7)]);
var inst_66076 = (state_66169[(18)]);
var inst_66101 = fluree.db.api.query.auth_match(auth,inst_66076,inst_66096);
var inst_66102 = cljs.core.not(inst_66101);
var state_66169__$1 = state_66169;
var statearr_66198_66293 = state_66169__$1;
(statearr_66198_66293[(2)] = inst_66102);

(statearr_66198_66293[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (2))){
var _ = (function (){var statearr_66199 = state_66169;
(statearr_66199[(4)] = cljs.core.cons((5),(state_66169[(4)])));

return statearr_66199;
})();
var inst_65981 = (function (){return (function (p1__65974_SHARP_){
return fluree.db.flake.t(p1__65974_SHARP_);
});
})();
var inst_65982 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_65981,resp);
var inst_65983 = cljs.core.set(inst_65982);
var inst_66071 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_66072 = (function (){var ts = inst_65983;
var c__2749__auto____$1 = inst_66071;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66069){
var state_val_66070 = (state_66069[(1)]);
if((state_val_66070 === (7))){
var inst_66015 = (state_66069[(7)]);
var inst_66003 = (state_66069[(8)]);
var inst_66009 = (state_66069[(9)]);
var inst_65997 = (state_66069[(10)]);
var inst_66008 = (state_66069[(2)]);
var inst_66009__$1 = fluree.db.util.async.throw_err(inst_66008);
var inst_66011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66012 = [inst_66003,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66013 = (new cljs.core.PersistentVector(null,2,(5),inst_66011,inst_66012,null));
var inst_66014 = cljs.core.assoc_in(inst_65997,inst_66013,inst_66009__$1);
var inst_66015__$1 = auth;
var state_66069__$1 = (function (){var statearr_66200 = state_66069;
(statearr_66200[(7)] = inst_66015__$1);

(statearr_66200[(11)] = inst_66014);

(statearr_66200[(9)] = inst_66009__$1);

return statearr_66200;
})();
if(cljs.core.truth_(inst_66015__$1)){
var statearr_66201_66294 = state_66069__$1;
(statearr_66201_66294[(1)] = (8));

} else {
var statearr_66202_66295 = state_66069__$1;
(statearr_66202_66295[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (1))){
var inst_65991 = (state_66069[(12)]);
var inst_65991__$1 = ts;
var inst_65992 = cljs.core.seq(inst_65991__$1);
var inst_65993 = cljs.core.first(inst_65992);
var inst_65994 = cljs.core.next(inst_65992);
var inst_65995 = cljs.core.PersistentHashMap.EMPTY;
var inst_65996 = inst_65991__$1;
var inst_65997 = inst_65995;
var state_66069__$1 = (function (){var statearr_66203 = state_66069;
(statearr_66203[(13)] = inst_65993);

(statearr_66203[(14)] = inst_65996);

(statearr_66203[(12)] = inst_65991__$1);

(statearr_66203[(10)] = inst_65997);

(statearr_66203[(15)] = inst_65994);

return statearr_66203;
})();
var statearr_66204_66296 = state_66069__$1;
(statearr_66204_66296[(2)] = null);

(statearr_66204_66296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (4))){
var inst_66003 = (state_66069[(8)]);
var inst_66006 = fluree.db.time_travel.non_border_t_to_block(db,inst_66003);
var state_66069__$1 = state_66069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66069__$1,(7),inst_66006);
} else {
if((state_val_66070 === (13))){
var inst_66004 = (state_66069[(16)]);
var inst_66061 = (state_66069[(2)]);
var inst_65996 = inst_66004;
var inst_65997 = inst_66061;
var state_66069__$1 = (function (){var statearr_66205 = state_66069;
(statearr_66205[(14)] = inst_65996);

(statearr_66205[(10)] = inst_65997);

return statearr_66205;
})();
var statearr_66206_66297 = state_66069__$1;
(statearr_66206_66297[(2)] = null);

(statearr_66206_66297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (6))){
var inst_66065 = (state_66069[(2)]);
var state_66069__$1 = state_66069;
var statearr_66207_66298 = state_66069__$1;
(statearr_66207_66298[(2)] = inst_66065);

(statearr_66207_66298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (3))){
var inst_66067 = (state_66069[(2)]);
var state_66069__$1 = state_66069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66069__$1,inst_66067);
} else {
if((state_val_66070 === (12))){
var inst_66014 = (state_66069[(11)]);
var state_66069__$1 = state_66069;
var statearr_66208_66299 = state_66069__$1;
(statearr_66208_66299[(2)] = inst_66014);

(statearr_66208_66299[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (2))){
var inst_65996 = (state_66069[(14)]);
var inst_66003 = (state_66069[(8)]);
var inst_66002 = cljs.core.seq(inst_65996);
var inst_66003__$1 = cljs.core.first(inst_66002);
var inst_66004 = cljs.core.next(inst_66002);
var state_66069__$1 = (function (){var statearr_66209 = state_66069;
(statearr_66209[(16)] = inst_66004);

(statearr_66209[(8)] = inst_66003__$1);

return statearr_66209;
})();
if(cljs.core.truth_(inst_66003__$1)){
var statearr_66210_66300 = state_66069__$1;
(statearr_66210_66300[(1)] = (4));

} else {
var statearr_66211_66301 = state_66069__$1;
(statearr_66211_66301[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (11))){
var inst_65993 = (state_66069[(13)]);
var inst_65996 = (state_66069[(14)]);
var inst_66004 = (state_66069[(16)]);
var inst_66014 = (state_66069[(11)]);
var inst_65991 = (state_66069[(12)]);
var inst_66003 = (state_66069[(8)]);
var inst_66009 = (state_66069[(9)]);
var inst_65997 = (state_66069[(10)]);
var inst_65994 = (state_66069[(15)]);
var inst_66021 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66022 = [inst_66003,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66023 = (new cljs.core.PersistentVector(null,2,(5),inst_66021,inst_66022,null));
var inst_66036 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_66037 = (function (){var t = inst_66003;
var first__65990 = inst_65993;
var G__65987 = inst_65996;
var c__2749__auto____$2 = inst_66036;
var G__66010 = inst_66014;
var block = inst_66009;
var r = inst_66004;
var seq__66000 = inst_66004;
var seq__65989 = inst_65994;
var acc = inst_65997;
var vec__65988 = inst_65991;
var vec__65999 = inst_65996;
var first__66001 = inst_66003;
return (function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66034){
var state_val_66035 = (state_66034[(1)]);
if((state_val_66035 === (1))){
var state_66034__$1 = state_66034;
var statearr_66212_66302 = state_66034__$1;
(statearr_66212_66302[(2)] = null);

(statearr_66212_66302[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66035 === (2))){
var ___$1 = (function (){var statearr_66213 = state_66034;
(statearr_66213[(4)] = cljs.core.cons((5),(state_66034[(4)])));

return statearr_66213;
})();
var ___$2 = (function (){var statearr_66214 = state_66034;
(statearr_66214[(4)] = cljs.core.rest((state_66034[(4)])));

return statearr_66214;
})();
var state_66034__$1 = state_66034;
var statearr_66215_66303 = state_66034__$1;
(statearr_66215_66303[(2)] = db);

(statearr_66215_66303[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66035 === (3))){
var inst_66032 = (state_66034[(2)]);
var state_66034__$1 = state_66034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66034__$1,inst_66032);
} else {
if((state_val_66035 === (4))){
var inst_66024 = (state_66034[(2)]);
var state_66034__$1 = state_66034;
var statearr_66217_66304 = state_66034__$1;
(statearr_66217_66304[(2)] = inst_66024);

(statearr_66217_66304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66035 === (5))){
var ___$1 = (function (){var statearr_66218 = state_66034;
(statearr_66218[(4)] = cljs.core.rest((state_66034[(4)])));

return statearr_66218;
})();
var state_66034__$1 = state_66034;
var ex66216 = (state_66034__$1[(2)]);
var statearr_66219_66305 = state_66034__$1;
(statearr_66219_66305[(5)] = ex66216);


if((ex66216 instanceof Error)){
var statearr_66220_66306 = state_66034__$1;
(statearr_66220_66306[(1)] = (4));

(statearr_66220_66306[(5)] = null);

} else {
throw ex66216;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_66221 = [null,null,null,null,null,null,null];
(statearr_66221[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_66221[(1)] = (1));

return statearr_66221;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_66034){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66034);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66222){var ex__2730__auto__ = e66222;
var statearr_66223_66307 = state_66034;
(statearr_66223_66307[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66034[(4)]))){
var statearr_66224_66308 = state_66034;
(statearr_66224_66308[(1)] = cljs.core.first((state_66034[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66309 = state_66034;
state_66034 = G__66309;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_66034){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_66034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66225 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66225[(6)] = c__2749__auto____$2);

return statearr_66225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_66038 = cljs.core.async.impl.dispatch.run(inst_66037);
var inst_66039 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_66040 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66041 = ["?auth","?id"];
var inst_66042 = (new cljs.core.PersistentVector(null,2,(5),inst_66040,inst_66041,null));
var inst_66043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66045 = [inst_66003,"_tx/auth","?auth"];
var inst_66046 = (new cljs.core.PersistentVector(null,3,(5),inst_66044,inst_66045,null));
var inst_66047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66048 = ["?auth","_auth/id","?id"];
var inst_66049 = (new cljs.core.PersistentVector(null,3,(5),inst_66047,inst_66048,null));
var inst_66050 = [inst_66046,inst_66049];
var inst_66051 = (new cljs.core.PersistentVector(null,2,(5),inst_66043,inst_66050,null));
var inst_66052 = [inst_66042,inst_66051];
var inst_66053 = cljs.core.PersistentHashMap.fromArrays(inst_66039,inst_66052);
var inst_66054 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_66036,inst_66053) : fluree.db.api.query.query_async.call(null,inst_66036,inst_66053));
var state_66069__$1 = (function (){var statearr_66226 = state_66069;
(statearr_66226[(17)] = inst_66023);

(statearr_66226[(18)] = inst_66038);

return statearr_66226;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66069__$1,(14),inst_66054);
} else {
if((state_val_66070 === (9))){
var state_66069__$1 = state_66069;
var statearr_66227_66310 = state_66069__$1;
(statearr_66227_66310[(2)] = show_auth);

(statearr_66227_66310[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (5))){
var inst_65997 = (state_66069[(10)]);
var state_66069__$1 = state_66069;
var statearr_66228_66311 = state_66069__$1;
(statearr_66228_66311[(2)] = inst_65997);

(statearr_66228_66311[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (14))){
var inst_66023 = (state_66069[(17)]);
var inst_66014 = (state_66069[(11)]);
var inst_66056 = (state_66069[(2)]);
var inst_66057 = fluree.db.util.async.throw_err(inst_66056);
var inst_66058 = cljs.core.assoc_in(inst_66014,inst_66023,inst_66057);
var state_66069__$1 = state_66069;
var statearr_66229_66312 = state_66069__$1;
(statearr_66229_66312[(2)] = inst_66058);

(statearr_66229_66312[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (10))){
var inst_66019 = (state_66069[(2)]);
var state_66069__$1 = state_66069;
if(cljs.core.truth_(inst_66019)){
var statearr_66230_66313 = state_66069__$1;
(statearr_66230_66313[(1)] = (11));

} else {
var statearr_66231_66314 = state_66069__$1;
(statearr_66231_66314[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66070 === (8))){
var inst_66015 = (state_66069[(7)]);
var state_66069__$1 = state_66069;
var statearr_66232_66315 = state_66069__$1;
(statearr_66232_66315[(2)] = inst_66015);

(statearr_66232_66315[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_66233 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66233[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_66233[(1)] = (1));

return statearr_66233;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_66069){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66069);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66234){var ex__2730__auto__ = e66234;
var statearr_66235_66316 = state_66069;
(statearr_66235_66316[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66069[(4)]))){
var statearr_66236_66317 = state_66069;
(statearr_66236_66317[(1)] = cljs.core.first((state_66069[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66318 = state_66069;
state_66069 = G__66318;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_66069){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_66069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66237 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66237[(6)] = c__2749__auto____$1);

return statearr_66237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
});
})();
var inst_66073 = cljs.core.async.impl.dispatch.run(inst_66072);
var state_66169__$1 = (function (){var statearr_66238 = state_66169;
(statearr_66238[(20)] = inst_66073);

return statearr_66238;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66169__$1,(6),inst_66071);
} else {
if((state_val_66170 === (23))){
var inst_66127 = (state_66169[(2)]);
var state_66169__$1 = (function (){var statearr_66239 = state_66169;
(statearr_66239[(13)] = inst_66127);

return statearr_66239;
})();
var statearr_66240_66319 = state_66169__$1;
(statearr_66240_66319[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (35))){
var inst_66157 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
var statearr_66242_66320 = state_66169__$1;
(statearr_66242_66320[(2)] = inst_66157);

(statearr_66242_66320[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (19))){
var state_66169__$1 = state_66169;
var statearr_66243_66321 = state_66169__$1;
(statearr_66243_66321[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (11))){
var inst_66108 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
if(cljs.core.truth_(inst_66108)){
var statearr_66246_66322 = state_66169__$1;
(statearr_66246_66322[(1)] = (15));

} else {
var statearr_66247_66323 = state_66169__$1;
(statearr_66247_66323[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (9))){
var inst_66099 = (state_66169[(16)]);
var inst_66099__$1 = auth;
var state_66169__$1 = (function (){var statearr_66248 = state_66169;
(statearr_66248[(16)] = inst_66099__$1);

return statearr_66248;
})();
if(cljs.core.truth_(inst_66099__$1)){
var statearr_66249_66324 = state_66169__$1;
(statearr_66249_66324[(1)] = (12));

} else {
var statearr_66250_66325 = state_66169__$1;
(statearr_66250_66325[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (5))){
var _ = (function (){var statearr_66251 = state_66169;
(statearr_66251[(4)] = cljs.core.rest((state_66169[(4)])));

return statearr_66251;
})();
var state_66169__$1 = state_66169;
var ex66245 = (state_66169__$1[(2)]);
var statearr_66252_66326 = state_66169__$1;
(statearr_66252_66326[(5)] = ex66245);


if((ex66245 instanceof Error)){
var statearr_66253_66327 = state_66169__$1;
(statearr_66253_66327[(1)] = (4));

(statearr_66253_66327[(5)] = null);

} else {
throw ex66245;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (14))){
var inst_66105 = (state_66169[(2)]);
var state_66169__$1 = state_66169;
var statearr_66254_66328 = state_66169__$1;
(statearr_66254_66328[(2)] = inst_66105);

(statearr_66254_66328[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (26))){
var inst_66135 = (state_66169[(2)]);
var state_66169__$1 = (function (){var statearr_66255 = state_66169;
(statearr_66255[(10)] = inst_66135);

return statearr_66255;
})();
var statearr_66256_66329 = state_66169__$1;
(statearr_66256_66329[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (16))){
var inst_66096 = (state_66169[(7)]);
var state_66169__$1 = state_66169;
if(cljs.core.truth_(inst_66096)){
var statearr_66258_66330 = state_66169__$1;
(statearr_66258_66330[(1)] = (18));

} else {
var statearr_66259_66331 = state_66169__$1;
(statearr_66259_66331[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (30))){
var inst_66118 = (state_66169[(21)]);
var inst_66143 = (state_66169[(15)]);
var inst_66117 = (state_66169[(12)]);
var inst_66145 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66146 = [inst_66117,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_66147 = (new cljs.core.PersistentVector(null,2,(5),inst_66145,inst_66146,null));
var inst_66148 = cljs.core.assoc_in(inst_66143,inst_66147,inst_66118);
var state_66169__$1 = state_66169;
var statearr_66260_66332 = state_66169__$1;
(statearr_66260_66332[(2)] = inst_66148);

(statearr_66260_66332[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (10))){
var inst_66096 = (state_66169[(7)]);
var state_66169__$1 = state_66169;
var statearr_66261_66333 = state_66169__$1;
(statearr_66261_66333[(2)] = inst_66096);

(statearr_66261_66333[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (18))){
var inst_66096 = (state_66169[(7)]);
var inst_66076 = (state_66169[(18)]);
var inst_66114 = (state_66169[(11)]);
var inst_66114__$1 = fluree.db.flake.t(inst_66096);
var inst_66115 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66076,inst_66114__$1);
var inst_66116 = cljs.core.__destructure_map(inst_66115);
var inst_66117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66116,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66118 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66116,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_66169__$1 = (function (){var statearr_66262 = state_66169;
(statearr_66262[(11)] = inst_66114__$1);

(statearr_66262[(21)] = inst_66118);

(statearr_66262[(12)] = inst_66117);

return statearr_66262;
})();
var statearr_66263_66334 = state_66169__$1;
(statearr_66263_66334[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66170 === (8))){
var inst_66163 = (state_66169[(2)]);
var inst_66164 = cljs.core.vals(inst_66163);
var _ = (function (){var statearr_66265 = state_66169;
(statearr_66265[(4)] = cljs.core.rest((state_66169[(4)])));

return statearr_66265;
})();
var state_66169__$1 = state_66169;
var statearr_66266_66335 = state_66169__$1;
(statearr_66266_66335[(2)] = inst_66164);

(statearr_66266_66335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0 = (function (){
var statearr_66267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66267[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__);

(statearr_66267[(1)] = (1));

return statearr_66267;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1 = (function (state_66169){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66169);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66268){var ex__2730__auto__ = e66268;
var statearr_66269_66336 = state_66169;
(statearr_66269_66336[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66169[(4)]))){
var statearr_66270_66337 = state_66169;
(statearr_66270_66337[(1)] = cljs.core.first((state_66169[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66338 = state_66169;
state_66169 = G__66338;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__ = function(state_66169){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1.call(this,state_66169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2727__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66271 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66271[(6)] = c__2749__auto__);

return statearr_66271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (block){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66462){
var state_val_66463 = (state_66462[(1)]);
if((state_val_66463 === (7))){
var inst_66361 = (state_66462[(7)]);
var inst_66363 = fluree.db.api.query.resolve_block_range(inst_66361,query_map);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(10),inst_66363);
} else {
if((state_val_66463 === (20))){
var inst_66387 = (state_66462[(2)]);
var inst_66388 = fluree.db.util.async.throw_err(inst_66387);
var inst_66389 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66388);
var inst_66390 = (inst_66389 - (1));
var state_66462__$1 = state_66462;
var statearr_66464_66527 = state_66462__$1;
(statearr_66464_66527[(2)] = inst_66390);

(statearr_66464_66527[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (27))){
var state_66462__$1 = state_66462;
var statearr_66465_66528 = state_66462__$1;
(statearr_66465_66528[(2)] = null);

(statearr_66465_66528[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (1))){
var state_66462__$1 = state_66462;
var statearr_66466_66529 = state_66462__$1;
(statearr_66466_66529[(2)] = null);

(statearr_66466_66529[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (24))){
var inst_66397 = (state_66462[(2)]);
var inst_66398 = fluree.db.util.async.throw_err(inst_66397);
var inst_66399 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66398);
var state_66462__$1 = state_66462;
var statearr_66467_66530 = state_66462__$1;
(statearr_66467_66530[(2)] = inst_66399);

(statearr_66467_66530[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (39))){
var inst_66434 = (state_66462[(2)]);
var inst_66435 = fluree.db.util.async.throw_err(inst_66434);
var state_66462__$1 = state_66462;
var statearr_66468_66531 = state_66462__$1;
(statearr_66468_66531[(2)] = inst_66435);

(statearr_66468_66531[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (4))){
var inst_66339 = (state_66462[(2)]);
var state_66462__$1 = state_66462;
var statearr_66469_66532 = state_66462__$1;
(statearr_66469_66532[(2)] = inst_66339);

(statearr_66469_66532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (15))){
var inst_66370 = (state_66462[(8)]);
var state_66462__$1 = state_66462;
var statearr_66470_66533 = state_66462__$1;
(statearr_66470_66533[(2)] = inst_66370);

(statearr_66470_66533[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (21))){
var inst_66371 = (state_66462[(9)]);
var inst_66361 = (state_66462[(7)]);
var inst_66395 = fluree.db.time_travel.as_of_block(inst_66361,inst_66371);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(24),inst_66395);
} else {
if((state_val_66463 === (31))){
var inst_66355 = (state_66462[(10)]);
var state_66462__$1 = state_66462;
var statearr_66471_66534 = state_66462__$1;
(statearr_66471_66534[(2)] = inst_66355);

(statearr_66471_66534[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (32))){
var inst_66418 = (state_66462[(11)]);
var inst_66413 = (state_66462[(12)]);
var inst_66361 = (state_66462[(7)]);
var inst_66422 = (state_66462[(2)]);
var inst_66423 = fluree.db.api.query.format_history_resp(inst_66361,inst_66413,inst_66418,inst_66422);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(29),inst_66423);
} else {
if((state_val_66463 === (40))){
var inst_66439 = (state_66462[(13)]);
var inst_66413 = (state_66462[(12)]);
var inst_66441 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_66442 = cljs.core.count(inst_66413);
var inst_66443 = [inst_66439,inst_66442,(200)];
var inst_66444 = cljs.core.PersistentHashMap.fromArrays(inst_66441,inst_66443);
var state_66462__$1 = state_66462;
var statearr_66472_66535 = state_66462__$1;
(statearr_66472_66535[(2)] = inst_66444);

(statearr_66472_66535[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (33))){
var inst_66354 = (state_66462[(14)]);
var state_66462__$1 = state_66462;
var statearr_66473_66536 = state_66462__$1;
(statearr_66473_66536[(2)] = inst_66354);

(statearr_66473_66536[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (13))){
var inst_66457 = (state_66462[(2)]);
var _ = (function (){var statearr_66474 = state_66462;
(statearr_66474[(4)] = cljs.core.rest((state_66462[(4)])));

return statearr_66474;
})();
var state_66462__$1 = state_66462;
var statearr_66475_66537 = state_66462__$1;
(statearr_66475_66537[(2)] = inst_66457);

(statearr_66475_66537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (22))){
var inst_66361 = (state_66462[(7)]);
var inst_66401 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66361);
var state_66462__$1 = state_66462;
var statearr_66476_66538 = state_66462__$1;
(statearr_66476_66538[(2)] = inst_66401);

(statearr_66476_66538[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (36))){
var inst_66426 = (state_66462[(15)]);
var inst_66361 = (state_66462[(7)]);
var inst_66432 = fluree.db.api.query.format_blocks_resp_pretty(inst_66361,inst_66426);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(39),inst_66432);
} else {
if((state_val_66463 === (41))){
var inst_66439 = (state_66462[(13)]);
var state_66462__$1 = state_66462;
var statearr_66477_66539 = state_66462__$1;
(statearr_66477_66539[(2)] = inst_66439);

(statearr_66477_66539[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (29))){
var inst_66354 = (state_66462[(14)]);
var inst_66425 = (state_66462[(2)]);
var inst_66426 = fluree.db.util.async.throw_err(inst_66425);
var state_66462__$1 = (function (){var statearr_66478 = state_66462;
(statearr_66478[(15)] = inst_66426);

return statearr_66478;
})();
if(cljs.core.truth_(inst_66354)){
var statearr_66479_66540 = state_66462__$1;
(statearr_66479_66540[(1)] = (33));

} else {
var statearr_66480_66541 = state_66462__$1;
(statearr_66480_66541[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (6))){
var inst_66351 = (state_66462[(16)]);
var inst_66360 = (state_66462[(2)]);
var inst_66361 = fluree.db.util.async.throw_err(inst_66360);
var state_66462__$1 = (function (){var statearr_66481 = state_66462;
(statearr_66481[(7)] = inst_66361);

return statearr_66481;
})();
if(cljs.core.truth_(inst_66351)){
var statearr_66482_66542 = state_66462__$1;
(statearr_66482_66542[(1)] = (7));

} else {
var statearr_66483_66543 = state_66462__$1;
(statearr_66483_66543[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (28))){
var inst_66356 = (state_66462[(17)]);
var inst_66418 = (state_66462[(2)]);
var state_66462__$1 = (function (){var statearr_66484 = state_66462;
(statearr_66484[(11)] = inst_66418);

return statearr_66484;
})();
if(cljs.core.truth_(inst_66356)){
var statearr_66485_66544 = state_66462__$1;
(statearr_66485_66544[(1)] = (30));

} else {
var statearr_66486_66545 = state_66462__$1;
(statearr_66486_66545[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (25))){
var inst_66357 = (state_66462[(18)]);
var inst_66412 = (state_66462[(2)]);
var inst_66413 = fluree.db.util.async.throw_err(inst_66412);
var state_66462__$1 = (function (){var statearr_66487 = state_66462;
(statearr_66487[(12)] = inst_66413);

return statearr_66487;
})();
if(cljs.core.truth_(inst_66357)){
var statearr_66488_66546 = state_66462__$1;
(statearr_66488_66546[(1)] = (26));

} else {
var statearr_66489_66547 = state_66462__$1;
(statearr_66489_66547[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (34))){
var inst_66353 = (state_66462[(19)]);
var state_66462__$1 = state_66462;
var statearr_66490_66548 = state_66462__$1;
(statearr_66490_66548[(2)] = inst_66353);

(statearr_66490_66548[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (17))){
var inst_66370 = (state_66462[(8)]);
var inst_66361 = (state_66462[(7)]);
var inst_66384 = (inst_66370 - (1));
var inst_66385 = fluree.db.time_travel.as_of_block(inst_66361,inst_66384);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(20),inst_66385);
} else {
if((state_val_66463 === (3))){
var inst_66460 = (state_66462[(2)]);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66462__$1,inst_66460);
} else {
if((state_val_66463 === (12))){
var inst_66449 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_66450 = ["History query not properly formatted. Provided ",inst_66449].join('');
var inst_66451 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66452 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66453 = cljs.core.PersistentHashMap.fromArrays(inst_66451,inst_66452);
var inst_66454 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66450,inst_66453);
var inst_66455 = (function(){throw inst_66454})();
var state_66462__$1 = state_66462;
var statearr_66491_66549 = state_66462__$1;
(statearr_66491_66549[(2)] = inst_66455);

(statearr_66491_66549[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (2))){
var _ = (function (){var statearr_66492 = state_66462;
(statearr_66492[(4)] = cljs.core.cons((5),(state_66462[(4)])));

return statearr_66492;
})();
var inst_66349 = query_map;
var inst_66350 = cljs.core.__destructure_map(inst_66349);
var inst_66351 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66352 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_66353 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_66354 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_66355 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_66356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_66357 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_66358 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66350,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_66462__$1 = (function (){var statearr_66493 = state_66462;
(statearr_66493[(20)] = inst_66352);

(statearr_66493[(17)] = inst_66356);

(statearr_66493[(19)] = inst_66353);

(statearr_66493[(21)] = inst_66358);

(statearr_66493[(18)] = inst_66357);

(statearr_66493[(10)] = inst_66355);

(statearr_66493[(16)] = inst_66351);

(statearr_66493[(14)] = inst_66354);

return statearr_66493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(6),sources);
} else {
if((state_val_66463 === (23))){
var inst_66352 = (state_66462[(20)]);
var inst_66393 = (state_66462[(22)]);
var inst_66361 = (state_66462[(7)]);
var inst_66403 = (state_66462[(2)]);
var inst_66404 = fluree.db.api.query.get_history_pattern(inst_66352);
var inst_66405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66404,(0),null);
var inst_66406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66404,(1),null);
var inst_66407 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_66408 = [inst_66393,inst_66403];
var inst_66409 = cljs.core.PersistentHashMap.fromArrays(inst_66407,inst_66408);
var inst_66410 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_66361,inst_66406,cljs.core._EQ_,inst_66405,inst_66409);
var state_66462__$1 = state_66462;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66462__$1,(25),inst_66410);
} else {
if((state_val_66463 === (35))){
var inst_66430 = (state_66462[(2)]);
var state_66462__$1 = state_66462;
if(cljs.core.truth_(inst_66430)){
var statearr_66494_66550 = state_66462__$1;
(statearr_66494_66550[(1)] = (36));

} else {
var statearr_66495_66551 = state_66462__$1;
(statearr_66495_66551[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (19))){
var inst_66371 = (state_66462[(9)]);
var inst_66393 = (state_66462[(2)]);
var state_66462__$1 = (function (){var statearr_66496 = state_66462;
(statearr_66496[(22)] = inst_66393);

return statearr_66496;
})();
if(cljs.core.truth_(inst_66371)){
var statearr_66497_66552 = state_66462__$1;
(statearr_66497_66552[(1)] = (21));

} else {
var statearr_66498_66553 = state_66462__$1;
(statearr_66498_66553[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (11))){
var inst_66370 = (state_66462[(8)]);
var inst_66358 = (state_66462[(21)]);
var inst_66377 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_66358);
var state_66462__$1 = (function (){var statearr_66500 = state_66462;
(statearr_66500[(23)] = inst_66377);

return statearr_66500;
})();
if(cljs.core.truth_(inst_66370)){
var statearr_66501_66554 = state_66462__$1;
(statearr_66501_66554[(1)] = (14));

} else {
var statearr_66502_66555 = state_66462__$1;
(statearr_66502_66555[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (9))){
var inst_66369 = (state_66462[(2)]);
var inst_66370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66369,(0),null);
var inst_66371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66369,(1),null);
var inst_66372 = cljs.core.contains_QMARK_(query_map,new cljs.core.Keyword(null,"history","history",-247395220));
var state_66462__$1 = (function (){var statearr_66503 = state_66462;
(statearr_66503[(9)] = inst_66371);

(statearr_66503[(8)] = inst_66370);

return statearr_66503;
})();
if(inst_66372){
var statearr_66504_66556 = state_66462__$1;
(statearr_66504_66556[(1)] = (11));

} else {
var statearr_66505_66557 = state_66462__$1;
(statearr_66505_66557[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (5))){
var _ = (function (){var statearr_66506 = state_66462;
(statearr_66506[(4)] = cljs.core.rest((state_66462[(4)])));

return statearr_66506;
})();
var state_66462__$1 = state_66462;
var ex66499 = (state_66462__$1[(2)]);
var statearr_66507_66558 = state_66462__$1;
(statearr_66507_66558[(5)] = ex66499);


if((ex66499 instanceof Error)){
var statearr_66508_66559 = state_66462__$1;
(statearr_66508_66559[(1)] = (4));

(statearr_66508_66559[(5)] = null);

} else {
throw ex66499;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (14))){
var inst_66370 = (state_66462[(8)]);
var inst_66379 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66370);
var state_66462__$1 = state_66462;
var statearr_66509_66560 = state_66462__$1;
(statearr_66509_66560[(2)] = inst_66379);

(statearr_66509_66560[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (26))){
var inst_66357 = (state_66462[(18)]);
var inst_66415 = cljs.core.set(inst_66357);
var state_66462__$1 = state_66462;
var statearr_66510_66561 = state_66462__$1;
(statearr_66510_66561[(2)] = inst_66415);

(statearr_66510_66561[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (16))){
var inst_66382 = (state_66462[(2)]);
var state_66462__$1 = state_66462;
if(cljs.core.truth_(inst_66382)){
var statearr_66511_66562 = state_66462__$1;
(statearr_66511_66562[(1)] = (17));

} else {
var statearr_66512_66563 = state_66462__$1;
(statearr_66512_66563[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (38))){
var inst_66377 = (state_66462[(23)]);
var inst_66439 = (state_66462[(2)]);
var state_66462__$1 = (function (){var statearr_66513 = state_66462;
(statearr_66513[(13)] = inst_66439);

return statearr_66513;
})();
if(cljs.core.truth_(inst_66377)){
var statearr_66514_66564 = state_66462__$1;
(statearr_66514_66564[(1)] = (40));

} else {
var statearr_66515_66565 = state_66462__$1;
(statearr_66515_66565[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (30))){
var inst_66356 = (state_66462[(17)]);
var state_66462__$1 = state_66462;
var statearr_66516_66566 = state_66462__$1;
(statearr_66516_66566[(2)] = inst_66356);

(statearr_66516_66566[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (10))){
var inst_66365 = (state_66462[(2)]);
var inst_66366 = fluree.db.util.async.throw_err(inst_66365);
var state_66462__$1 = state_66462;
var statearr_66517_66567 = state_66462__$1;
(statearr_66517_66567[(2)] = inst_66366);

(statearr_66517_66567[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (18))){
var state_66462__$1 = state_66462;
var statearr_66518_66568 = state_66462__$1;
(statearr_66518_66568[(2)] = (-1));

(statearr_66518_66568[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (42))){
var inst_66447 = (state_66462[(2)]);
var state_66462__$1 = state_66462;
var statearr_66519_66569 = state_66462__$1;
(statearr_66519_66569[(2)] = inst_66447);

(statearr_66519_66569[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (37))){
var inst_66426 = (state_66462[(15)]);
var inst_66437 = fluree.db.api.query.block_Flakes__GT_vector(inst_66426);
var state_66462__$1 = state_66462;
var statearr_66520_66570 = state_66462__$1;
(statearr_66520_66570[(2)] = inst_66437);

(statearr_66520_66570[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66463 === (8))){
var state_66462__$1 = state_66462;
var statearr_66521_66571 = state_66462__$1;
(statearr_66521_66571[(2)] = null);

(statearr_66521_66571[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_66522 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66522[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2727__auto__);

(statearr_66522[(1)] = (1));

return statearr_66522;
});
var fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1 = (function (state_66462){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66462);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66523){var ex__2730__auto__ = e66523;
var statearr_66524_66572 = state_66462;
(statearr_66524_66572[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66462[(4)]))){
var statearr_66525_66573 = state_66462;
(statearr_66525_66573[(1)] = cljs.core.first((state_66462[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66574 = state_66462;
state_66462 = G__66574;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__ = function(state_66462){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1.call(this,state_66462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66526 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66526[(6)] = c__2749__auto__);

return statearr_66526;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66707){
var state_val_66708 = (state_66707[(1)]);
if((state_val_66708 === (7))){
var inst_66604 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_66605 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_66604].join('');
var inst_66606 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66607 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66608 = cljs.core.PersistentHashMap.fromArrays(inst_66606,inst_66607);
var inst_66609 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66605,inst_66608);
var inst_66610 = (function(){throw inst_66609})();
var state_66707__$1 = state_66707;
var statearr_66709_66788 = state_66707__$1;
(statearr_66709_66788[(2)] = inst_66610);

(statearr_66709_66788[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (20))){
var inst_66642 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
if(cljs.core.truth_(inst_66642)){
var statearr_66710_66789 = state_66707__$1;
(statearr_66710_66789[(1)] = (21));

} else {
var statearr_66711_66790 = state_66707__$1;
(statearr_66711_66790[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (27))){
var inst_66586 = (state_66707[(7)]);
var state_66707__$1 = state_66707;
var statearr_66712_66791 = state_66707__$1;
(statearr_66712_66791[(2)] = inst_66586);

(statearr_66712_66791[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (1))){
var state_66707__$1 = state_66707;
var statearr_66713_66792 = state_66707__$1;
(statearr_66713_66792[(2)] = null);

(statearr_66713_66792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (24))){
var inst_66648 = (state_66707[(8)]);
var state_66707__$1 = state_66707;
var statearr_66714_66793 = state_66707__$1;
(statearr_66714_66793[(2)] = inst_66648);

(statearr_66714_66793[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (39))){
var inst_66592 = (state_66707[(9)]);
var state_66707__$1 = state_66707;
if(cljs.core.truth_(inst_66592)){
var statearr_66715_66794 = state_66707__$1;
(statearr_66715_66794[(1)] = (42));

} else {
var statearr_66716_66795 = state_66707__$1;
(statearr_66716_66795[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (46))){
var inst_66680 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66681 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66682 = cljs.core.PersistentHashMap.fromArrays(inst_66680,inst_66681);
var inst_66683 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_66682);
var inst_66684 = (function(){throw inst_66683})();
var state_66707__$1 = state_66707;
var statearr_66717_66796 = state_66707__$1;
(statearr_66717_66796[(2)] = inst_66684);

(statearr_66717_66796[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (4))){
var inst_66576 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
var statearr_66718_66797 = state_66707__$1;
(statearr_66718_66797[(2)] = inst_66576);

(statearr_66718_66797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (15))){
var inst_66589 = (state_66707[(10)]);
var inst_66627 = (state_66707[(11)]);
var inst_66629 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_66627);
var inst_66630 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_66627);
var inst_66631 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_66627);
var inst_66632 = fluree.db.api.query.get_sources(inst_66629,inst_66630,inst_66631,inst_66589);
var state_66707__$1 = state_66707;
var statearr_66719_66798 = state_66707__$1;
(statearr_66719_66798[(2)] = inst_66632);

(statearr_66719_66798[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (48))){
var inst_66637 = (state_66707[(12)]);
var inst_66691 = (state_66707[(2)]);
var inst_66692 = fluree.db.util.async.throw_err(inst_66691);
var state_66707__$1 = (function (){var statearr_66720 = state_66707;
(statearr_66720[(13)] = inst_66692);

return statearr_66720;
})();
if(cljs.core.truth_(inst_66637)){
var statearr_66721_66799 = state_66707__$1;
(statearr_66721_66799[(1)] = (49));

} else {
var statearr_66722_66800 = state_66707__$1;
(statearr_66722_66800[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (50))){
var inst_66692 = (state_66707[(13)]);
var state_66707__$1 = state_66707;
var statearr_66723_66801 = state_66707__$1;
(statearr_66723_66801[(2)] = inst_66692);

(statearr_66723_66801[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (21))){
var inst_66644 = cljs.core.volatile_BANG_((0));
var state_66707__$1 = state_66707;
var statearr_66724_66802 = state_66707__$1;
(statearr_66724_66802[(2)] = inst_66644);

(statearr_66724_66802[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (31))){
var inst_66590 = (state_66707[(14)]);
var state_66707__$1 = state_66707;
if(cljs.core.truth_(inst_66590)){
var statearr_66725_66803 = state_66707__$1;
(statearr_66725_66803[(1)] = (33));

} else {
var statearr_66726_66804 = state_66707__$1;
(statearr_66726_66804[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (32))){
var inst_66667 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
var statearr_66727_66805 = state_66707__$1;
(statearr_66727_66805[(2)] = inst_66667);

(statearr_66727_66805[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (40))){
var inst_66669 = (state_66707[(15)]);
var state_66707__$1 = state_66707;
var statearr_66728_66806 = state_66707__$1;
(statearr_66728_66806[(2)] = inst_66669);

(statearr_66728_66806[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (33))){
var inst_66590 = (state_66707[(14)]);
var state_66707__$1 = state_66707;
var statearr_66729_66807 = state_66707__$1;
(statearr_66729_66807[(2)] = inst_66590);

(statearr_66729_66807[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (13))){
var inst_66587 = (state_66707[(16)]);
var inst_66616 = (state_66707[(2)]);
var inst_66617 = fluree.db.util.async.throw_err(inst_66616);
var inst_66618 = fluree.db.time_travel.as_of_block(inst_66617,inst_66587);
var state_66707__$1 = state_66707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66707__$1,(12),inst_66618);
} else {
if((state_val_66708 === (22))){
var state_66707__$1 = state_66707;
var statearr_66730_66808 = state_66707__$1;
(statearr_66730_66808[(2)] = null);

(statearr_66730_66808[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (36))){
var inst_66594 = (state_66707[(17)]);
var state_66707__$1 = state_66707;
var statearr_66731_66809 = state_66707__$1;
(statearr_66731_66809[(2)] = inst_66594);

(statearr_66731_66809[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (41))){
var inst_66677 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
if(cljs.core.truth_(inst_66677)){
var statearr_66732_66810 = state_66707__$1;
(statearr_66732_66810[(1)] = (45));

} else {
var statearr_66733_66811 = state_66707__$1;
(statearr_66733_66811[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (43))){
var inst_66588 = (state_66707[(18)]);
var state_66707__$1 = state_66707;
var statearr_66734_66812 = state_66707__$1;
(statearr_66734_66812[(2)] = inst_66588);

(statearr_66734_66812[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (29))){
var inst_66669 = (state_66707[(15)]);
var inst_66669__$1 = (state_66707[(2)]);
var state_66707__$1 = (function (){var statearr_66735 = state_66707;
(statearr_66735[(15)] = inst_66669__$1);

return statearr_66735;
})();
if(cljs.core.truth_(inst_66669__$1)){
var statearr_66736_66813 = state_66707__$1;
(statearr_66736_66813[(1)] = (39));

} else {
var statearr_66737_66814 = state_66707__$1;
(statearr_66737_66814[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (44))){
var inst_66674 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
var statearr_66738_66815 = state_66707__$1;
(statearr_66738_66815[(2)] = inst_66674);

(statearr_66738_66815[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (6))){
var state_66707__$1 = state_66707;
var statearr_66739_66816 = state_66707__$1;
(statearr_66739_66816[(2)] = null);

(statearr_66739_66816[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (28))){
var inst_66591 = (state_66707[(19)]);
var state_66707__$1 = state_66707;
if(cljs.core.truth_(inst_66591)){
var statearr_66740_66817 = state_66707__$1;
(statearr_66740_66817[(1)] = (30));

} else {
var statearr_66741_66818 = state_66707__$1;
(statearr_66741_66818[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (51))){
var inst_66702 = (state_66707[(2)]);
var _ = (function (){var statearr_66742 = state_66707;
(statearr_66742[(4)] = cljs.core.rest((state_66707[(4)])));

return statearr_66742;
})();
var state_66707__$1 = state_66707;
var statearr_66743_66819 = state_66707__$1;
(statearr_66743_66819[(2)] = inst_66702);

(statearr_66743_66819[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (25))){
var state_66707__$1 = state_66707;
var statearr_66744_66820 = state_66707__$1;
(statearr_66744_66820[(2)] = (1000000));

(statearr_66744_66820[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (34))){
var inst_66594 = (state_66707[(17)]);
var state_66707__$1 = state_66707;
if(cljs.core.truth_(inst_66594)){
var statearr_66745_66821 = state_66707__$1;
(statearr_66745_66821[(1)] = (36));

} else {
var statearr_66746_66822 = state_66707__$1;
(statearr_66746_66822[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (17))){
var inst_66593 = (state_66707[(20)]);
var inst_66638 = (state_66707[(21)]);
var inst_66636 = (state_66707[(2)]);
var inst_66637 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_66593);
var inst_66638__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_66593);
var state_66707__$1 = (function (){var statearr_66747 = state_66707;
(statearr_66747[(22)] = inst_66636);

(statearr_66747[(12)] = inst_66637);

(statearr_66747[(21)] = inst_66638__$1);

return statearr_66747;
})();
if(cljs.core.truth_(inst_66638__$1)){
var statearr_66748_66823 = state_66707__$1;
(statearr_66748_66823[(1)] = (18));

} else {
var statearr_66749_66824 = state_66707__$1;
(statearr_66749_66824[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (3))){
var inst_66705 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66707__$1,inst_66705);
} else {
if((state_val_66708 === (12))){
var inst_66620 = (state_66707[(2)]);
var inst_66621 = fluree.db.util.async.throw_err(inst_66620);
var state_66707__$1 = state_66707;
var statearr_66750_66825 = state_66707__$1;
(statearr_66750_66825[(2)] = inst_66621);

(statearr_66750_66825[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (2))){
var inst_66590 = (state_66707[(14)]);
var inst_66587 = (state_66707[(16)]);
var inst_66586 = (state_66707[(7)]);
var inst_66585 = (state_66707[(23)]);
var inst_66591 = (state_66707[(19)]);
var inst_66592 = (state_66707[(9)]);
var inst_66588 = (state_66707[(18)]);
var inst_66593 = (state_66707[(20)]);
var inst_66594 = (state_66707[(17)]);
var inst_66589 = (state_66707[(10)]);
var _ = (function (){var statearr_66751 = state_66707;
(statearr_66751[(4)] = cljs.core.cons((5),(state_66707[(4)])));

return statearr_66751;
})();
var inst_66583 = flureeQL;
var inst_66584 = cljs.core.__destructure_map(inst_66583);
var inst_66585__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_66586__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_66587__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66588__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_66589__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_66590__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_66591__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_66592__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_66593__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_66594__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66584,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_66595 = (function (){var construct = inst_66585__$1;
var select = inst_66586__$1;
var block = inst_66587__$1;
var where = inst_66588__$1;
var prefixes = inst_66589__$1;
var map__66582 = inst_66584;
var selectDistinct = inst_66590__$1;
var selectOne = inst_66591__$1;
var from = inst_66592__$1;
var opts = inst_66593__$1;
var selectReduced = inst_66594__$1;
return (function (p1__66575_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__66575_SHARP_);
});
})();
var inst_66596 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66597 = [inst_66586__$1,inst_66591__$1,inst_66590__$1,inst_66594__$1];
var inst_66598 = (new cljs.core.PersistentVector(null,4,(5),inst_66596,inst_66597,null));
var inst_66599 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_66598);
var inst_66600 = cljs.core.count(inst_66599);
var inst_66601 = (inst_66595.cljs$core$IFn$_invoke$arity$1 ? inst_66595.cljs$core$IFn$_invoke$arity$1(inst_66600) : inst_66595.call(null,inst_66600));
var state_66707__$1 = (function (){var statearr_66752 = state_66707;
(statearr_66752[(14)] = inst_66590__$1);

(statearr_66752[(16)] = inst_66587__$1);

(statearr_66752[(7)] = inst_66586__$1);

(statearr_66752[(23)] = inst_66585__$1);

(statearr_66752[(19)] = inst_66591__$1);

(statearr_66752[(9)] = inst_66592__$1);

(statearr_66752[(18)] = inst_66588__$1);

(statearr_66752[(20)] = inst_66593__$1);

(statearr_66752[(17)] = inst_66594__$1);

(statearr_66752[(10)] = inst_66589__$1);

return statearr_66752;
})();
if(cljs.core.truth_(inst_66601)){
var statearr_66753_66826 = state_66707__$1;
(statearr_66753_66826[(1)] = (6));

} else {
var statearr_66754_66827 = state_66707__$1;
(statearr_66754_66827[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (23))){
var inst_66648 = (state_66707[(8)]);
var inst_66593 = (state_66707[(20)]);
var inst_66647 = (state_66707[(2)]);
var inst_66648__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_66593);
var state_66707__$1 = (function (){var statearr_66755 = state_66707;
(statearr_66755[(24)] = inst_66647);

(statearr_66755[(8)] = inst_66648__$1);

return statearr_66755;
})();
if(cljs.core.truth_(inst_66648__$1)){
var statearr_66756_66828 = state_66707__$1;
(statearr_66756_66828[(1)] = (24));

} else {
var statearr_66757_66829 = state_66707__$1;
(statearr_66757_66829[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (47))){
var inst_66653 = (state_66707[(25)]);
var inst_66627 = (state_66707[(11)]);
var inst_66686 = (state_66707[(2)]);
var inst_66687 = fluree.db.util.core.current_time_millis();
var inst_66688 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_66653);
var inst_66689 = fluree.db.query.fql.query(inst_66627,inst_66688);
var state_66707__$1 = (function (){var statearr_66758 = state_66707;
(statearr_66758[(26)] = inst_66687);

(statearr_66758[(27)] = inst_66686);

return statearr_66758;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66707__$1,(48),inst_66689);
} else {
if((state_val_66708 === (35))){
var inst_66665 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
var statearr_66759_66830 = state_66707__$1;
(statearr_66759_66830[(2)] = inst_66665);

(statearr_66759_66830[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (19))){
var inst_66637 = (state_66707[(12)]);
var state_66707__$1 = state_66707;
var statearr_66760_66831 = state_66707__$1;
(statearr_66760_66831[(2)] = inst_66637);

(statearr_66760_66831[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (11))){
var inst_66589 = (state_66707[(10)]);
var inst_66627 = (state_66707[(2)]);
var state_66707__$1 = (function (){var statearr_66762 = state_66707;
(statearr_66762[(11)] = inst_66627);

return statearr_66762;
})();
if(cljs.core.truth_(inst_66589)){
var statearr_66763_66832 = state_66707__$1;
(statearr_66763_66832[(1)] = (15));

} else {
var statearr_66764_66833 = state_66707__$1;
(statearr_66764_66833[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (9))){
var inst_66613 = (state_66707[(28)]);
var state_66707__$1 = state_66707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66707__$1,(13),inst_66613);
} else {
if((state_val_66708 === (5))){
var _ = (function (){var statearr_66765 = state_66707;
(statearr_66765[(4)] = cljs.core.rest((state_66707[(4)])));

return statearr_66765;
})();
var state_66707__$1 = state_66707;
var ex66761 = (state_66707__$1[(2)]);
var statearr_66766_66834 = state_66707__$1;
(statearr_66766_66834[(5)] = ex66761);


if((ex66761 instanceof Error)){
var statearr_66767_66835 = state_66707__$1;
(statearr_66767_66835[(1)] = (4));

(statearr_66767_66835[(5)] = null);

} else {
throw ex66761;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (14))){
var inst_66624 = (state_66707[(2)]);
var inst_66625 = fluree.db.util.async.throw_err(inst_66624);
var state_66707__$1 = state_66707;
var statearr_66768_66836 = state_66707__$1;
(statearr_66768_66836[(2)] = inst_66625);

(statearr_66768_66836[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (45))){
var state_66707__$1 = state_66707;
var statearr_66769_66837 = state_66707__$1;
(statearr_66769_66837[(2)] = null);

(statearr_66769_66837[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (26))){
var inst_66586 = (state_66707[(7)]);
var inst_66647 = (state_66707[(24)]);
var inst_66636 = (state_66707[(22)]);
var inst_66593 = (state_66707[(20)]);
var inst_66652 = (state_66707[(2)]);
var inst_66653 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_66593,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_66636,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_66652,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_66647], 0));
var state_66707__$1 = (function (){var statearr_66770 = state_66707;
(statearr_66770[(25)] = inst_66653);

return statearr_66770;
})();
if(cljs.core.truth_(inst_66586)){
var statearr_66771_66838 = state_66707__$1;
(statearr_66771_66838[(1)] = (27));

} else {
var statearr_66772_66839 = state_66707__$1;
(statearr_66772_66839[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (16))){
var inst_66634 = cljs.core.PersistentHashMap.EMPTY;
var state_66707__$1 = state_66707;
var statearr_66773_66840 = state_66707__$1;
(statearr_66773_66840[(2)] = inst_66634);

(statearr_66773_66840[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (38))){
var inst_66663 = (state_66707[(2)]);
var state_66707__$1 = state_66707;
var statearr_66774_66841 = state_66707__$1;
(statearr_66774_66841[(2)] = inst_66663);

(statearr_66774_66841[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (30))){
var inst_66591 = (state_66707[(19)]);
var state_66707__$1 = state_66707;
var statearr_66775_66842 = state_66707__$1;
(statearr_66775_66842[(2)] = inst_66591);

(statearr_66775_66842[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (10))){
var inst_66613 = (state_66707[(28)]);
var state_66707__$1 = state_66707;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66707__$1,(14),inst_66613);
} else {
if((state_val_66708 === (18))){
var inst_66638 = (state_66707[(21)]);
var state_66707__$1 = state_66707;
var statearr_66776_66843 = state_66707__$1;
(statearr_66776_66843[(2)] = inst_66638);

(statearr_66776_66843[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (42))){
var inst_66592 = (state_66707[(9)]);
var state_66707__$1 = state_66707;
var statearr_66777_66844 = state_66707__$1;
(statearr_66777_66844[(2)] = inst_66592);

(statearr_66777_66844[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (37))){
var inst_66585 = (state_66707[(23)]);
var state_66707__$1 = state_66707;
var statearr_66778_66845 = state_66707__$1;
(statearr_66778_66845[(2)] = inst_66585);

(statearr_66778_66845[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (8))){
var inst_66587 = (state_66707[(16)]);
var inst_66612 = (state_66707[(2)]);
var inst_66613 = sources;
var state_66707__$1 = (function (){var statearr_66779 = state_66707;
(statearr_66779[(28)] = inst_66613);

(statearr_66779[(29)] = inst_66612);

return statearr_66779;
})();
if(cljs.core.truth_(inst_66587)){
var statearr_66780_66846 = state_66707__$1;
(statearr_66780_66846[(1)] = (9));

} else {
var statearr_66781_66847 = state_66707__$1;
(statearr_66781_66847[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66708 === (49))){
var inst_66687 = (state_66707[(26)]);
var inst_66647 = (state_66707[(24)]);
var inst_66692 = (state_66707[(13)]);
var inst_66627 = (state_66707[(11)]);
var inst_66694 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_66695 = cljs.core.deref(inst_66647);
var inst_66696 = fluree.db.util.core.response_time_formatted(inst_66687);
var inst_66697 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66627);
var inst_66698 = [(200),inst_66692,inst_66695,inst_66696,inst_66697];
var inst_66699 = cljs.core.PersistentHashMap.fromArrays(inst_66694,inst_66698);
var state_66707__$1 = state_66707;
var statearr_66782_66848 = state_66707__$1;
(statearr_66782_66848[(2)] = inst_66699);

(statearr_66782_66848[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_66783 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66783[(0)] = fluree$db$api$query$query_async_$_state_machine__2727__auto__);

(statearr_66783[(1)] = (1));

return statearr_66783;
});
var fluree$db$api$query$query_async_$_state_machine__2727__auto____1 = (function (state_66707){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66707);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e66784){var ex__2730__auto__ = e66784;
var statearr_66785_66849 = state_66707;
(statearr_66785_66849[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66707[(4)]))){
var statearr_66786_66850 = state_66707;
(statearr_66786_66850[(1)] = cljs.core.first((state_66707[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66851 = state_66707;
state_66707 = G__66851;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2727__auto__ = function(state_66707){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2727__auto____1.call(this,state_66707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_66787 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_66787[(6)] = c__2749__auto__);

return statearr_66787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2749__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2750__auto__ = (function (){var switch__2726__auto__ = (function (state_66992){
var state_val_66993 = (state_66992[(1)]);
if((state_val_66993 === (7))){
var inst_66987 = (state_66992[(2)]);
var _ = (function (){var statearr_66994 = state_66992;
(statearr_66994[(4)] = cljs.core.rest((state_66992[(4)])));

return statearr_66994;
})();
var state_66992__$1 = state_66992;
var statearr_66995_67071 = state_66992__$1;
(statearr_66995_67071[(2)] = inst_66987);

(statearr_66995_67071[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (20))){
var inst_66959 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_66996_67072 = state_66992__$1;
(statearr_66996_67072[(2)] = inst_66959);

(statearr_66996_67072[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (27))){
var inst_66939 = (state_66992[(7)]);
var state_66992__$1 = state_66992;
var statearr_66997_67073 = state_66992__$1;
(statearr_66997_67073[(2)] = inst_66939);

(statearr_66997_67073[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (1))){
var state_66992__$1 = state_66992;
var statearr_66998_67074 = state_66992__$1;
(statearr_66998_67074[(2)] = null);

(statearr_66998_67074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (24))){
var inst_66936 = (state_66992[(8)]);
var state_66992__$1 = state_66992;
var statearr_66999_67075 = state_66992__$1;
(statearr_66999_67075[(2)] = inst_66936);

(statearr_66999_67075[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (39))){
var inst_66926 = (state_66992[(9)]);
var inst_66893 = (state_66992[(10)]);
var inst_66904 = (state_66992[(11)]);
var inst_66970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66971 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_66904];
var inst_66972 = (new cljs.core.PersistentVector(null,2,(5),inst_66970,inst_66971,null));
var inst_66973 = cljs.core.assoc_in(inst_66893,inst_66972,inst_66926);
var state_66992__$1 = state_66992;
var statearr_67000_67076 = state_66992__$1;
(statearr_67000_67076[(2)] = inst_66973);

(statearr_67000_67076[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (4))){
var inst_66852 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67001_67077 = state_66992__$1;
(statearr_67001_67077[(2)] = inst_66852);

(statearr_67001_67077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (15))){
var inst_66926 = (state_66992[(9)]);
var inst_66891 = (state_66992[(12)]);
var inst_66929 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_66926);
var inst_66930 = (inst_66891 == null);
var state_66992__$1 = (function (){var statearr_67002 = state_66992;
(statearr_67002[(13)] = inst_66929);

return statearr_67002;
})();
if(cljs.core.truth_(inst_66930)){
var statearr_67003_67078 = state_66992__$1;
(statearr_67003_67078[(1)] = (18));

} else {
var statearr_67004_67079 = state_66992__$1;
(statearr_67004_67079[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (21))){
var inst_66929 = (state_66992[(13)]);
var state_66992__$1 = state_66992;
var statearr_67005_67080 = state_66992__$1;
(statearr_67005_67080[(2)] = inst_66929);

(statearr_67005_67080[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (31))){
var state_66992__$1 = state_66992;
var statearr_67006_67081 = state_66992__$1;
(statearr_67006_67081[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (32))){
var inst_66955 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67008_67082 = state_66992__$1;
(statearr_67008_67082[(2)] = inst_66955);

(statearr_67008_67082[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (40))){
var inst_66924 = (state_66992[(14)]);
var state_66992__$1 = state_66992;
if(cljs.core.truth_(inst_66924)){
var statearr_67009_67083 = state_66992__$1;
(statearr_67009_67083[(1)] = (42));

} else {
var statearr_67010_67084 = state_66992__$1;
(statearr_67010_67084[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (33))){
var inst_66929 = (state_66992[(13)]);
var inst_66891 = (state_66992[(12)]);
var inst_66950 = ((inst_66929 > inst_66891) ? inst_66929 : inst_66891);
var state_66992__$1 = state_66992;
var statearr_67011_67085 = state_66992__$1;
(statearr_67011_67085[(2)] = inst_66950);

(statearr_67011_67085[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (13))){
var inst_66915 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67012_67086 = state_66992__$1;
(statearr_67012_67086[(2)] = inst_66915);

(statearr_67012_67086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (22))){
var inst_66936 = (state_66992[(8)]);
var inst_66929 = (state_66992[(13)]);
var inst_66936__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_66929);
var state_66992__$1 = (function (){var statearr_67013 = state_66992;
(statearr_67013[(8)] = inst_66936__$1);

return statearr_67013;
})();
if(inst_66936__$1){
var statearr_67014_67087 = state_66992__$1;
(statearr_67014_67087[(1)] = (24));

} else {
var statearr_67015_67088 = state_66992__$1;
(statearr_67015_67088[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (36))){
var inst_66892 = (state_66992[(15)]);
var inst_66926 = (state_66992[(9)]);
var inst_66964 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_66926,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_66965 = (inst_66892 + inst_66964);
var state_66992__$1 = state_66992;
var statearr_67016_67089 = state_66992__$1;
(statearr_67016_67089[(2)] = inst_66965);

(statearr_67016_67089[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (41))){
var inst_66962 = (state_66992[(16)]);
var inst_66903 = (state_66992[(17)]);
var inst_66968 = (state_66992[(18)]);
var inst_66982 = (state_66992[(2)]);
var inst_66890 = inst_66903;
var inst_66891 = inst_66962;
var inst_66892 = inst_66968;
var inst_66893 = inst_66982;
var state_66992__$1 = (function (){var statearr_67017 = state_66992;
(statearr_67017[(15)] = inst_66892);

(statearr_67017[(10)] = inst_66893);

(statearr_67017[(12)] = inst_66891);

(statearr_67017[(19)] = inst_66890);

return statearr_67017;
})();
var statearr_67018_67090 = state_66992__$1;
(statearr_67018_67090[(2)] = null);

(statearr_67018_67090[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (43))){
var inst_66926 = (state_66992[(9)]);
var state_66992__$1 = state_66992;
var statearr_67019_67091 = state_66992__$1;
(statearr_67019_67091[(2)] = inst_66926);

(statearr_67019_67091[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (29))){
var inst_66944 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67020_67092 = state_66992__$1;
(statearr_67020_67092[(2)] = inst_66944);

(statearr_67020_67092[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (44))){
var inst_66893 = (state_66992[(10)]);
var inst_66904 = (state_66992[(11)]);
var inst_66979 = (state_66992[(2)]);
var inst_66980 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66893,inst_66904,inst_66979);
var state_66992__$1 = state_66992;
var statearr_67021_67093 = state_66992__$1;
(statearr_67021_67093[(2)] = inst_66980);

(statearr_67021_67093[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (6))){
var inst_66905 = (state_66992[(20)]);
var inst_66890 = (state_66992[(19)]);
var inst_66901 = cljs.core.seq(inst_66890);
var inst_66902 = cljs.core.first(inst_66901);
var inst_66903 = cljs.core.next(inst_66901);
var inst_66904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66902,(0),null);
var inst_66905__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66902,(1),null);
var inst_66906 = (inst_66905__$1 == null);
var state_66992__$1 = (function (){var statearr_67022 = state_66992;
(statearr_67022[(11)] = inst_66904);

(statearr_67022[(20)] = inst_66905__$1);

(statearr_67022[(17)] = inst_66903);

return statearr_67022;
})();
if(cljs.core.truth_(inst_66906)){
var statearr_67023_67094 = state_66992__$1;
(statearr_67023_67094[(1)] = (8));

} else {
var statearr_67024_67095 = state_66992__$1;
(statearr_67024_67095[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (28))){
var inst_66891 = (state_66992[(12)]);
var inst_66942 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_66891);
var state_66992__$1 = state_66992;
var statearr_67025_67096 = state_66992__$1;
(statearr_67025_67096[(2)] = inst_66942);

(statearr_67025_67096[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (25))){
var inst_66939 = (state_66992[(7)]);
var inst_66891 = (state_66992[(12)]);
var inst_66939__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_66891);
var state_66992__$1 = (function (){var statearr_67026 = state_66992;
(statearr_67026[(7)] = inst_66939__$1);

return statearr_67026;
})();
if(inst_66939__$1){
var statearr_67027_67097 = state_66992__$1;
(statearr_67027_67097[(1)] = (27));

} else {
var statearr_67028_67098 = state_66992__$1;
(statearr_67028_67098[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (34))){
var state_66992__$1 = state_66992;
var statearr_67029_67099 = state_66992__$1;
(statearr_67029_67099[(2)] = null);

(statearr_67029_67099[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (17))){
var inst_66923 = (state_66992[(21)]);
var inst_66962 = (state_66992[(2)]);
var state_66992__$1 = (function (){var statearr_67030 = state_66992;
(statearr_67030[(16)] = inst_66962);

return statearr_67030;
})();
if(cljs.core.truth_(inst_66923)){
var statearr_67031_67100 = state_66992__$1;
(statearr_67031_67100[(1)] = (36));

} else {
var statearr_67032_67101 = state_66992__$1;
(statearr_67032_67101[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (3))){
var inst_66990 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66992__$1,inst_66990);
} else {
if((state_val_66993 === (12))){
var inst_66893 = (state_66992[(10)]);
var state_66992__$1 = state_66992;
var statearr_67033_67102 = state_66992__$1;
(statearr_67033_67102[(2)] = inst_66893);

(statearr_67033_67102[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (2))){
var inst_66862 = (state_66992[(22)]);
var inst_66866 = (state_66992[(23)]);
var inst_66867 = (state_66992[(24)]);
var _ = (function (){var statearr_67034 = state_66992;
(statearr_67034[(4)] = cljs.core.cons((5),(state_66992[(4)])));

return statearr_67034;
})();
var inst_66858 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_66859 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66860 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_66861 = (new cljs.core.PersistentVector(null,2,(5),inst_66859,inst_66860,null));
var inst_66862__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_66861);
var inst_66863 = (function (){var global_block = inst_66858;
var global_meta_QMARK_ = inst_66862__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__5045__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__5043__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__5043__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_66864 = cljs.core.PersistentHashMap.EMPTY;
var inst_66865 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_66866__$1 = cljs.core.reduce_kv(inst_66863,inst_66864,inst_66865);
var inst_66867__$1 = fluree.db.util.core.current_time_millis();
var inst_66869 = (function (){var global_block = inst_66858;
var global_meta_QMARK_ = inst_66862__$1;
var queries = inst_66866__$1;
var start_time = inst_66867__$1;
return (function (p__66868){
var vec__67035 = p__66868;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67035,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67035,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_66870 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_66869,inst_66866__$1);
var inst_66884 = cljs.core.seq(inst_66870);
var inst_66885 = cljs.core.first(inst_66884);
var inst_66886 = cljs.core.next(inst_66884);
var inst_66887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66885,(0),null);
var inst_66888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66885,(1),null);
var inst_66889 = cljs.core.PersistentHashMap.EMPTY;
var inst_66890 = inst_66870;
var inst_66891 = null;
var inst_66892 = (0);
var inst_66893 = inst_66889;
var state_66992__$1 = (function (){var statearr_67038 = state_66992;
(statearr_67038[(22)] = inst_66862__$1);

(statearr_67038[(25)] = inst_66886);

(statearr_67038[(15)] = inst_66892);

(statearr_67038[(26)] = inst_66888);

(statearr_67038[(10)] = inst_66893);

(statearr_67038[(12)] = inst_66891);

(statearr_67038[(23)] = inst_66866__$1);

(statearr_67038[(19)] = inst_66890);

(statearr_67038[(24)] = inst_66867__$1);

(statearr_67038[(27)] = inst_66887);

return statearr_67038;
})();
var statearr_67039_67103 = state_66992__$1;
(statearr_67039_67103[(2)] = null);

(statearr_67039_67103[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (23))){
var inst_66957 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67040_67104 = state_66992__$1;
(statearr_67040_67104[(2)] = inst_66957);

(statearr_67040_67104[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (35))){
var inst_66953 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67041_67105 = state_66992__$1;
(statearr_67041_67105[(2)] = inst_66953);

(statearr_67041_67105[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (19))){
var inst_66929 = (state_66992[(13)]);
var inst_66891 = (state_66992[(12)]);
var inst_66933 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_66891,inst_66929);
var state_66992__$1 = state_66992;
if(inst_66933){
var statearr_67042_67106 = state_66992__$1;
(statearr_67042_67106[(1)] = (21));

} else {
var statearr_67043_67107 = state_66992__$1;
(statearr_67043_67107[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (11))){
var inst_66892 = (state_66992[(15)]);
var inst_66893 = (state_66992[(10)]);
var inst_66891 = (state_66992[(12)]);
var inst_66867 = (state_66992[(24)]);
var inst_66909 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_66910 = fluree.db.util.core.response_time_formatted(inst_66867);
var inst_66911 = [inst_66893,inst_66892,inst_66891,inst_66910];
var inst_66912 = cljs.core.PersistentHashMap.fromArrays(inst_66909,inst_66911);
var state_66992__$1 = state_66992;
var statearr_67045_67108 = state_66992__$1;
(statearr_67045_67108[(2)] = inst_66912);

(statearr_67045_67108[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (9))){
var inst_66866 = (state_66992[(23)]);
var inst_66904 = (state_66992[(11)]);
var inst_66905 = (state_66992[(20)]);
var inst_66918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66919 = [inst_66904,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_66920 = (new cljs.core.PersistentVector(null,2,(5),inst_66918,inst_66919,null));
var inst_66921 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_66866,inst_66920);
var inst_66922 = cljs.core.__destructure_map(inst_66921);
var inst_66923 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66922,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_66924 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66922,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_66992__$1 = (function (){var statearr_67046 = state_66992;
(statearr_67046[(14)] = inst_66924);

(statearr_67046[(21)] = inst_66923);

return statearr_67046;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66992__$1,(14),inst_66905);
} else {
if((state_val_66993 === (5))){
var _ = (function (){var statearr_67047 = state_66992;
(statearr_67047[(4)] = cljs.core.rest((state_66992[(4)])));

return statearr_67047;
})();
var state_66992__$1 = state_66992;
var ex67044 = (state_66992__$1[(2)]);
var statearr_67048_67109 = state_66992__$1;
(statearr_67048_67109[(5)] = ex67044);


var statearr_67049_67110 = state_66992__$1;
(statearr_67049_67110[(1)] = (4));

(statearr_67049_67110[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (14))){
var inst_66926 = (state_66992[(9)]);
var inst_66923 = (state_66992[(21)]);
var inst_66926__$1 = (state_66992[(2)]);
var inst_66927 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_66926__$1);
var state_66992__$1 = (function (){var statearr_67050 = state_66992;
(statearr_67050[(9)] = inst_66926__$1);

(statearr_67050[(28)] = inst_66927);

return statearr_67050;
})();
if(cljs.core.truth_(inst_66923)){
var statearr_67051_67111 = state_66992__$1;
(statearr_67051_67111[(1)] = (15));

} else {
var statearr_67052_67112 = state_66992__$1;
(statearr_67052_67112[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (26))){
var inst_66946 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
if(cljs.core.truth_(inst_66946)){
var statearr_67053_67113 = state_66992__$1;
(statearr_67053_67113[(1)] = (30));

} else {
var statearr_67054_67114 = state_66992__$1;
(statearr_67054_67114[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (16))){
var state_66992__$1 = state_66992;
var statearr_67055_67115 = state_66992__$1;
(statearr_67055_67115[(2)] = null);

(statearr_67055_67115[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (38))){
var inst_66927 = (state_66992[(28)]);
var inst_66968 = (state_66992[(2)]);
var state_66992__$1 = (function (){var statearr_67056 = state_66992;
(statearr_67056[(18)] = inst_66968);

return statearr_67056;
})();
if(cljs.core.truth_(inst_66927)){
var statearr_67057_67116 = state_66992__$1;
(statearr_67057_67116[(1)] = (39));

} else {
var statearr_67058_67117 = state_66992__$1;
(statearr_67058_67117[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (30))){
var state_66992__$1 = state_66992;
var statearr_67059_67118 = state_66992__$1;
(statearr_67059_67118[(2)] = (207));

(statearr_67059_67118[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (10))){
var inst_66985 = (state_66992[(2)]);
var state_66992__$1 = state_66992;
var statearr_67060_67119 = state_66992__$1;
(statearr_67060_67119[(2)] = inst_66985);

(statearr_67060_67119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (18))){
var inst_66929 = (state_66992[(13)]);
var state_66992__$1 = state_66992;
var statearr_67061_67120 = state_66992__$1;
(statearr_67061_67120[(2)] = inst_66929);

(statearr_67061_67120[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (42))){
var inst_66926 = (state_66992[(9)]);
var inst_66976 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_66926);
var state_66992__$1 = state_66992;
var statearr_67062_67121 = state_66992__$1;
(statearr_67062_67121[(2)] = inst_66976);

(statearr_67062_67121[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (37))){
var state_66992__$1 = state_66992;
var statearr_67063_67122 = state_66992__$1;
(statearr_67063_67122[(2)] = null);

(statearr_67063_67122[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66993 === (8))){
var inst_66862 = (state_66992[(22)]);
var state_66992__$1 = state_66992;
if(cljs.core.truth_(inst_66862)){
var statearr_67064_67123 = state_66992__$1;
(statearr_67064_67123[(1)] = (11));

} else {
var statearr_67065_67124 = state_66992__$1;
(statearr_67065_67124[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0 = (function (){
var statearr_67066 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67066[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__);

(statearr_67066[(1)] = (1));

return statearr_67066;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1 = (function (state_66992){
while(true){
var ret_value__2728__auto__ = (function (){try{while(true){
var result__2729__auto__ = switch__2726__auto__(state_66992);
if(cljs.core.keyword_identical_QMARK_(result__2729__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2729__auto__;
}
break;
}
}catch (e67067){var ex__2730__auto__ = e67067;
var statearr_67068_67125 = state_66992;
(statearr_67068_67125[(2)] = ex__2730__auto__);


if(cljs.core.seq((state_66992[(4)]))){
var statearr_67069_67126 = state_66992;
(statearr_67069_67126[(1)] = cljs.core.first((state_66992[(4)])));

} else {
throw ex__2730__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67127 = state_66992;
state_66992 = G__67127;
continue;
} else {
return ret_value__2728__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__ = function(state_66992){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1.call(this,state_66992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2727__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2727__auto__;
})()
})();
var state__2751__auto__ = (function (){var statearr_67070 = (f__2750__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2750__auto__.cljs$core$IFn$_invoke$arity$0() : f__2750__auto__.call(null));
(statearr_67070[(6)] = c__2749__auto__);

return statearr_67070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2751__auto__);
}));

return c__2749__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__67128 = query_type;
var G__67128__$1 = (((G__67128 instanceof cljs.core.Keyword))?G__67128.fqn:null);
switch (G__67128__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__67128__$1)].join('')));

}
});
