// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('sci.impl.load');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('sci.impl.types');
goog.require('sci.impl.utils');
goog.require('sci.impl.vars');
sci.impl.load.handle_refer_all = (function sci$impl$load$handle_refer_all(the_current_ns,the_loaded_ns,include_sym_QMARK_,rename_sym,only){
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var only__$1 = (cljs.core.truth_(only)?cljs.core.set.call(null,only):null);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,p__31728){
var vec__31729 = p__31728;
var k = cljs.core.nth.call(null,vec__31729,(0),null);
var v = cljs.core.nth.call(null,vec__31729,(1),null);
if(cljs.core.truth_((function (){var and__5043__auto__ = (k instanceof cljs.core.Symbol);
if(and__5043__auto__){
var and__5043__auto____$1 = include_sym_QMARK_.call(null,k);
if(cljs.core.truth_(and__5043__auto____$1)){
return ((cljs.core.not.call(null,only__$1)) || (cljs.core.contains_QMARK_.call(null,only__$1,k)));
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,k),v);
} else {
return ns;
}
}),referred,the_loaded_ns);
return cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
});
sci.impl.load.handle_require_libspec_env = (function sci$impl$load$handle_require_libspec_env(_ctx,env,current_ns,the_loaded_ns,lib_name,p__31732){
var map__31733 = p__31732;
var map__31733__$1 = cljs.core.__destructure_map.call(null,map__31733);
var _parsed_libspec = map__31733__$1;
var as = cljs.core.get.call(null,map__31733__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var refer = cljs.core.get.call(null,map__31733__$1,new cljs.core.Keyword(null,"refer","refer",-964295553));
var rename = cljs.core.get.call(null,map__31733__$1,new cljs.core.Keyword(null,"rename","rename",1508157613));
var exclude = cljs.core.get.call(null,map__31733__$1,new cljs.core.Keyword(null,"exclude","exclude",-1230250334));
var only = cljs.core.get.call(null,map__31733__$1,new cljs.core.Keyword(null,"only","only",1907811652));
var use = cljs.core.get.call(null,map__31733__$1,new cljs.core.Keyword(null,"use","use",-1846382424));
var the_current_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null));
var the_current_ns__$1 = (cljs.core.truth_(as)?cljs.core.assoc_in.call(null,the_current_ns,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"aliases","aliases",1346874714),as], null),lib_name):the_current_ns);
var rename_sym = (cljs.core.truth_(rename)?(function (sym){
var or__5045__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return sym;
}
}):cljs.core.identity);
var include_sym_QMARK_ = (cljs.core.truth_(exclude)?(function (){var excludes = cljs.core.set.call(null,exclude);
return (function (sym){
return (!(cljs.core.contains_QMARK_.call(null,excludes,sym)));
});
})():cljs.core.constantly.call(null,true));
var the_current_ns__$2 = (cljs.core.truth_(refer)?(cljs.core.truth_((function (){var or__5045__auto__ = cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,"all","all",892129742),refer);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return use;
}
})())?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,null):((cljs.core.sequential_QMARK_.call(null,refer))?(function (){var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns__$1);
var referred__$1 = cljs.core.reduce.call(null,(function (ns,sym){
if(cljs.core.truth_(include_sym_QMARK_.call(null,sym))){
return cljs.core.assoc.call(null,ns,rename_sym.call(null,sym),(function (){var temp__5802__auto__ = cljs.core.find.call(null,the_loaded_ns,sym);
if(cljs.core.truth_(temp__5802__auto__)){
var vec__31734 = temp__5802__auto__;
var _k = cljs.core.nth.call(null,vec__31734,(0),null);
var v = cljs.core.nth.call(null,vec__31734,(1),null);
return v;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')));
}
})());
} else {
return ns;
}
}),referred,refer);
return cljs.core.assoc.call(null,the_current_ns__$1,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
})():(function(){throw (new Error(":refer value must be a sequential collection of symbols"))})()
)):(cljs.core.truth_(use)?sci.impl.load.handle_refer_all.call(null,the_current_ns__$1,the_loaded_ns,include_sym_QMARK_,rename_sym,only):the_current_ns__$1
));
var env__$1 = cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),current_ns], null),the_current_ns__$2);
var temp__5804__auto___31738 = (function (){var G__31737 = the_loaded_ns;
var G__31737__$1 = (((G__31737 == null))?null:new cljs.core.Keyword(null,"obj","obj",981763962).cljs$core$IFn$_invoke$arity$1(G__31737));
var G__31737__$2 = (((G__31737__$1 == null))?null:cljs.core.meta.call(null,G__31737__$1));
if((G__31737__$2 == null)){
return null;
} else {
return new cljs.core.Keyword("sci.impl","required-fn","sci.impl/required-fn",2082701278).cljs$core$IFn$_invoke$arity$1(G__31737__$2);
}
})();
if(cljs.core.truth_(temp__5804__auto___31738)){
var on_loaded_31739 = temp__5804__auto___31738;
on_loaded_31739.call(null,cljs.core.PersistentArrayMap.EMPTY);
} else {
}

return env__$1;
});
sci.impl.load.add_loaded_lib = (function sci$impl$load$add_loaded_lib(env,lib){
cljs.core.swap_BANG_.call(null,env,cljs.core.update,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652),(function (loaded_libs){
if((loaded_libs == null)){
return cljs.core.PersistentHashSet.createAsIfByAssoc([lib]);
} else {
return cljs.core.conj.call(null,loaded_libs,lib);
}
}));

return null;
});
sci.impl.load.handle_require_libspec = (function sci$impl$load$handle_require_libspec(ctx,lib,opts){
var env_STAR_ = new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx);
var env = cljs.core.deref.call(null,env_STAR_);
var cnn = sci.impl.utils.current_ns_name.call(null);
var lib__$1 = cljs.core.get.call(null,new cljs.core.Keyword(null,"ns-aliases","ns-aliases",1290254821).cljs$core$IFn$_invoke$arity$1(env),lib,lib);
var temp__5802__auto__ = new cljs.core.Keyword(null,"as-alias","as-alias",82482467).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5802__auto__)){
var as_alias = temp__5802__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,null,lib__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"as","as",1148689641),as_alias], null)));
} else {
var map__31740 = opts;
var map__31740__$1 = cljs.core.__destructure_map.call(null,map__31740);
var reload = cljs.core.get.call(null,map__31740__$1,new cljs.core.Keyword(null,"reload","reload",863702807));
var reload_all = cljs.core.get.call(null,map__31740__$1,new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
var namespaces = cljs.core.get.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var reload_STAR_ = (function (){var or__5045__auto__ = reload;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = reload_all;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(ctx);
}
}
})();
var temp__5802__auto___31743__$1 = (cljs.core.truth_(reload_STAR_)?null:cljs.core.get.call(null,namespaces,lib__$1));
if(cljs.core.truth_(temp__5802__auto___31743__$1)){
var the_loaded_ns_31744 = temp__5802__auto___31743__$1;
var loading_31745 = new cljs.core.Keyword(null,"loading","loading",-737050189).cljs$core$IFn$_invoke$arity$1(ctx);
if(cljs.core.truth_((function (){var and__5043__auto__ = loading_31745;
if(cljs.core.truth_(and__5043__auto__)){
return (((!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"loaded-libs","loaded-libs",-1156389652).cljs$core$IFn$_invoke$arity$1(env),lib__$1)))) && (cljs.core.nat_int_QMARK_.call(null,loading_31745.indexOf(lib__$1))));
} else {
return and__5043__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,(function (){var lib_emphasized = ["[ ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib__$1)," ]"].join('');
var loading__$1 = cljs.core.conj.call(null,loading_31745,lib__$1);
var loading__$2 = cljs.core.replace.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([lib__$1,lib_emphasized]),loading__$1);
return ["Cyclic load dependency: ",clojure.string.join.call(null,"->",loading__$2)].join('');
})(),lib__$1);
} else {
cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns_31744,lib__$1,opts));
}
} else {
var temp__5802__auto___31746__$2 = new cljs.core.Keyword(null,"load-fn","load-fn",-2121144334).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_(temp__5802__auto___31746__$2)){
var load_fn_31747 = temp__5802__auto___31746__$2;
var curr_ns_31748 = cljs.core.deref.call(null,sci.impl.utils.current_ns);
var temp__5802__auto___31749__$3 = load_fn_31747.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),lib__$1,new cljs.core.Keyword(null,"libname","libname",135992497),lib__$1,new cljs.core.Keyword(null,"ctx","ctx",-493610118),ctx,new cljs.core.Keyword(null,"opts","opts",155075701),opts,new cljs.core.Keyword(null,"ns","ns",441598760),sci.impl.types.getName.call(null,curr_ns_31748),new cljs.core.Keyword(null,"reload","reload",863702807),(function (){var or__5045__auto__ = reload;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return reload_all;
}
})()], null));
if(cljs.core.truth_(temp__5802__auto___31749__$3)){
var map__31741_31750 = temp__5802__auto___31749__$3;
var map__31741_31751__$1 = cljs.core.__destructure_map.call(null,map__31741_31750);
var file_31752 = cljs.core.get.call(null,map__31741_31751__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var source_31753 = cljs.core.get.call(null,map__31741_31751__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var handled_31754 = cljs.core.get.call(null,map__31741_31751__$1,new cljs.core.Keyword(null,"handled","handled",1889700151));
var ctx_31755__$1 = cljs.core.update.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,ctx,new cljs.core.Keyword(null,"bindings","bindings",1271397192),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"reload-all","reload-all",761570200),reload_all),new cljs.core.Keyword(null,"loading","loading",-737050189),(function (loading){
if((loading == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [lib__$1], null);
} else {
return cljs.core.conj.call(null,loading,lib__$1);
}
}));
if(cljs.core.truth_(source_31753)){
try{sci.impl.vars.push_thread_bindings.call(null,cljs.core.PersistentArrayMap.createAsIfByAssoc([sci.impl.utils.current_ns,curr_ns_31748,sci.impl.utils.current_file,file_31752]));

try{cljs.core.deref.call(null,sci.impl.utils.eval_string_STAR_).call(null,ctx_31755__$1,source_31753);
}finally {sci.impl.vars.pop_thread_bindings.call(null);
}}catch (e31742){if((e31742 instanceof Error)){
var e_31756 = e31742;
cljs.core.swap_BANG_.call(null,env_STAR_,cljs.core.update,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.dissoc,lib__$1);

throw e_31756;
} else {
throw e31742;

}
}} else {
}

if(cljs.core.truth_(handled_31754)){
} else {
cljs.core.swap_BANG_.call(null,env_STAR_,(function (env__$1){
var namespaces__$1 = cljs.core.get.call(null,env__$1,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469));
var the_loaded_ns = cljs.core.get.call(null,namespaces__$1,lib__$1);
return sci.impl.load.handle_require_libspec_env.call(null,ctx,env__$1,cnn,the_loaded_ns,lib__$1,opts);
}));
}
} else {
var or__5045__auto___31757 = (cljs.core.truth_(reload_STAR_)?(function (){var temp__5804__auto__ = cljs.core.get.call(null,namespaces,lib__$1);
if(cljs.core.truth_(temp__5804__auto__)){
var the_loaded_ns = temp__5804__auto__;
return cljs.core.reset_BANG_.call(null,env_STAR_,sci.impl.load.handle_require_libspec_env.call(null,ctx,env,cnn,the_loaded_ns,lib__$1,opts));
} else {
return null;
}
})():null);
if(cljs.core.truth_(or__5045__auto___31757)){
} else {
throw (new Error(["Could not find namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib__$1),"."].join('')));
}
}
} else {
throw (new Error(["Could not find namespace ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib__$1),"."].join('')));
}
}

sci.impl.load.add_loaded_lib.call(null,env_STAR_,lib__$1);

return null;
}
});
sci.impl.load.load_lib = (function sci$impl$load$load_lib(var_args){
var args__5775__auto__ = [];
var len__5769__auto___31762 = arguments.length;
var i__5770__auto___31763 = (0);
while(true){
if((i__5770__auto___31763 < len__5769__auto___31762)){
args__5775__auto__.push((arguments[i__5770__auto___31763]));

var G__31764 = (i__5770__auto___31763 + (1));
i__5770__auto___31763 = G__31764;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(sci.impl.load.load_lib.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,prefix,lib,options){
if(cljs.core.truth_((function (){var and__5043__auto__ = prefix;
if(cljs.core.truth_(and__5043__auto__)){
return (cljs.core.name.call(null,lib).indexOf(".") > (0));
} else {
return and__5043__auto__;
}
})())){
sci.impl.utils.throw_error_with_location.call(null,["Found lib name '",cljs.core.name.call(null,lib),"' containing period with prefix '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),"'.  lib names inside prefix lists must not contain periods"].join(''),lib);
} else {
}

var lib__$1 = (cljs.core.truth_(prefix)?cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(lib)].join('')):lib);
var opts = cljs.core.apply.call(null,cljs.core.hash_map,options);
return sci.impl.load.handle_require_libspec.call(null,ctx,lib__$1,opts);
}));

(sci.impl.load.load_lib.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(sci.impl.load.load_lib.cljs$lang$applyTo = (function (seq31758){
var G__31759 = cljs.core.first.call(null,seq31758);
var seq31758__$1 = cljs.core.next.call(null,seq31758);
var G__31760 = cljs.core.first.call(null,seq31758__$1);
var seq31758__$2 = cljs.core.next.call(null,seq31758__$1);
var G__31761 = cljs.core.first.call(null,seq31758__$2);
var seq31758__$3 = cljs.core.next.call(null,seq31758__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31759,G__31760,G__31761,seq31758__$3);
}));

/**
 * Prepends a symbol or a seq to coll
 */
sci.impl.load.prependss = (function sci$impl$load$prependss(x,coll){
if((x instanceof cljs.core.Symbol)){
return cljs.core.cons.call(null,x,coll);
} else {
return cljs.core.concat.call(null,x,coll);
}
});
/**
 * Returns true if x is a libspec
 */
sci.impl.load.libspec_QMARK_ = (function sci$impl$load$libspec_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) || (((cljs.core.vector_QMARK_.call(null,x)) && ((((cljs.core.second.call(null,x) == null)) || ((cljs.core.second.call(null,x) instanceof cljs.core.Keyword)))))));
});
/**
 * Loads libs, evaling libspecs, prefix lists, and flags for
 *   forwarding to load-lib
 */
sci.impl.load.load_libs = (function sci$impl$load$load_libs(ctx,kw,args){
var args_STAR_ = cljs.core.cons.call(null,kw,args);
var flags = cljs.core.filter.call(null,cljs.core.keyword_QMARK_,args_STAR_);
var opts = cljs.core.interleave.call(null,flags,cljs.core.repeat.call(null,true));
var args_STAR___$1 = cljs.core.filter.call(null,cljs.core.complement.call(null,cljs.core.keyword_QMARK_),args_STAR_);
var supported_31797 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"use","use",-1846382424),null,new cljs.core.Keyword(null,"as","as",1148689641),null,new cljs.core.Keyword(null,"require","require",-468001333),null,new cljs.core.Keyword(null,"verbose","verbose",1694226060),null,new cljs.core.Keyword(null,"reload","reload",863702807),null,new cljs.core.Keyword(null,"reload-all","reload-all",761570200),null,new cljs.core.Keyword(null,"refer","refer",-964295553),null], null), null);
var unsupported_31798 = cljs.core.seq.call(null,cljs.core.remove.call(null,supported_31797,flags));
if(unsupported_31798){
sci.impl.utils.throw_error_with_location.call(null,cljs.core.apply.call(null,cljs.core.str,"Unsupported option(s) supplied: ",cljs.core.interpose.call(null,",",unsupported_31798)),args);
} else {
}

if(cljs.core.seq.call(null,args_STAR___$1)){
} else {
sci.impl.utils.throw_error_with_location.call(null,"Nothing specified to load",args);
}

var seq__31765 = cljs.core.seq.call(null,args_STAR___$1);
var chunk__31766 = null;
var count__31767 = (0);
var i__31768 = (0);
while(true){
if((i__31768 < count__31767)){
var arg = cljs.core._nth.call(null,chunk__31766,i__31768);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__31783_31799 = arg;
var seq__31784_31800 = cljs.core.seq.call(null,vec__31783_31799);
var first__31785_31801 = cljs.core.first.call(null,seq__31784_31800);
var seq__31784_31802__$1 = cljs.core.next.call(null,seq__31784_31800);
var prefix_31803 = first__31785_31801;
var args_STAR__31804__$2 = seq__31784_31802__$1;
if((prefix_31803 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__31786_31805 = cljs.core.seq.call(null,args_STAR__31804__$2);
var chunk__31787_31806 = null;
var count__31788_31807 = (0);
var i__31789_31808 = (0);
while(true){
if((i__31789_31808 < count__31788_31807)){
var arg_31809__$1 = cljs.core._nth.call(null,chunk__31787_31806,i__31789_31808);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_31803,sci.impl.load.prependss.call(null,arg_31809__$1,opts));


var G__31810 = seq__31786_31805;
var G__31811 = chunk__31787_31806;
var G__31812 = count__31788_31807;
var G__31813 = (i__31789_31808 + (1));
seq__31786_31805 = G__31810;
chunk__31787_31806 = G__31811;
count__31788_31807 = G__31812;
i__31789_31808 = G__31813;
continue;
} else {
var temp__5804__auto___31814 = cljs.core.seq.call(null,seq__31786_31805);
if(temp__5804__auto___31814){
var seq__31786_31815__$1 = temp__5804__auto___31814;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31786_31815__$1)){
var c__5568__auto___31816 = cljs.core.chunk_first.call(null,seq__31786_31815__$1);
var G__31817 = cljs.core.chunk_rest.call(null,seq__31786_31815__$1);
var G__31818 = c__5568__auto___31816;
var G__31819 = cljs.core.count.call(null,c__5568__auto___31816);
var G__31820 = (0);
seq__31786_31805 = G__31817;
chunk__31787_31806 = G__31818;
count__31788_31807 = G__31819;
i__31789_31808 = G__31820;
continue;
} else {
var arg_31821__$1 = cljs.core.first.call(null,seq__31786_31815__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_31803,sci.impl.load.prependss.call(null,arg_31821__$1,opts));


var G__31822 = cljs.core.next.call(null,seq__31786_31815__$1);
var G__31823 = null;
var G__31824 = (0);
var G__31825 = (0);
seq__31786_31805 = G__31822;
chunk__31787_31806 = G__31823;
count__31788_31807 = G__31824;
i__31789_31808 = G__31825;
continue;
}
} else {
}
}
break;
}
}


var G__31826 = seq__31765;
var G__31827 = chunk__31766;
var G__31828 = count__31767;
var G__31829 = (i__31768 + (1));
seq__31765 = G__31826;
chunk__31766 = G__31827;
count__31767 = G__31828;
i__31768 = G__31829;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__31765);
if(temp__5804__auto__){
var seq__31765__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31765__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__31765__$1);
var G__31830 = cljs.core.chunk_rest.call(null,seq__31765__$1);
var G__31831 = c__5568__auto__;
var G__31832 = cljs.core.count.call(null,c__5568__auto__);
var G__31833 = (0);
seq__31765 = G__31830;
chunk__31766 = G__31831;
count__31767 = G__31832;
i__31768 = G__31833;
continue;
} else {
var arg = cljs.core.first.call(null,seq__31765__$1);
if(sci.impl.load.libspec_QMARK_.call(null,arg)){
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,null,sci.impl.load.prependss.call(null,arg,opts));
} else {
var vec__31790_31834 = arg;
var seq__31791_31835 = cljs.core.seq.call(null,vec__31790_31834);
var first__31792_31836 = cljs.core.first.call(null,seq__31791_31835);
var seq__31791_31837__$1 = cljs.core.next.call(null,seq__31791_31835);
var prefix_31838 = first__31792_31836;
var args_STAR__31839__$2 = seq__31791_31837__$1;
if((prefix_31838 == null)){
sci.impl.utils.throw_error_with_location.call(null,"prefix cannot be nil",args);
} else {
}

var seq__31793_31840 = cljs.core.seq.call(null,args_STAR__31839__$2);
var chunk__31794_31841 = null;
var count__31795_31842 = (0);
var i__31796_31843 = (0);
while(true){
if((i__31796_31843 < count__31795_31842)){
var arg_31844__$1 = cljs.core._nth.call(null,chunk__31794_31841,i__31796_31843);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_31838,sci.impl.load.prependss.call(null,arg_31844__$1,opts));


var G__31845 = seq__31793_31840;
var G__31846 = chunk__31794_31841;
var G__31847 = count__31795_31842;
var G__31848 = (i__31796_31843 + (1));
seq__31793_31840 = G__31845;
chunk__31794_31841 = G__31846;
count__31795_31842 = G__31847;
i__31796_31843 = G__31848;
continue;
} else {
var temp__5804__auto___31849__$1 = cljs.core.seq.call(null,seq__31793_31840);
if(temp__5804__auto___31849__$1){
var seq__31793_31850__$1 = temp__5804__auto___31849__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31793_31850__$1)){
var c__5568__auto___31851 = cljs.core.chunk_first.call(null,seq__31793_31850__$1);
var G__31852 = cljs.core.chunk_rest.call(null,seq__31793_31850__$1);
var G__31853 = c__5568__auto___31851;
var G__31854 = cljs.core.count.call(null,c__5568__auto___31851);
var G__31855 = (0);
seq__31793_31840 = G__31852;
chunk__31794_31841 = G__31853;
count__31795_31842 = G__31854;
i__31796_31843 = G__31855;
continue;
} else {
var arg_31856__$1 = cljs.core.first.call(null,seq__31793_31850__$1);
cljs.core.apply.call(null,sci.impl.load.load_lib,ctx,prefix_31838,sci.impl.load.prependss.call(null,arg_31856__$1,opts));


var G__31857 = cljs.core.next.call(null,seq__31793_31850__$1);
var G__31858 = null;
var G__31859 = (0);
var G__31860 = (0);
seq__31793_31840 = G__31857;
chunk__31794_31841 = G__31858;
count__31795_31842 = G__31859;
i__31796_31843 = G__31860;
continue;
}
} else {
}
}
break;
}
}


var G__31861 = cljs.core.next.call(null,seq__31765__$1);
var G__31862 = null;
var G__31863 = (0);
var G__31864 = (0);
seq__31765 = G__31861;
chunk__31766 = G__31862;
count__31767 = G__31863;
i__31768 = G__31864;
continue;
}
} else {
return null;
}
}
break;
}
});
sci.impl.load.eval_require = (function sci$impl$load$eval_require(var_args){
var args__5775__auto__ = [];
var len__5769__auto___31867 = arguments.length;
var i__5770__auto___31868 = (0);
while(true){
if((i__5770__auto___31868 < len__5769__auto___31867)){
args__5775__auto__.push((arguments[i__5770__auto___31868]));

var G__31869 = (i__5770__auto___31868 + (1));
i__5770__auto___31868 = G__31869;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.load.eval_require.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"require","require",-468001333),args);
}));

(sci.impl.load.eval_require.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_require.cljs$lang$applyTo = (function (seq31865){
var G__31866 = cljs.core.first.call(null,seq31865);
var seq31865__$1 = cljs.core.next.call(null,seq31865);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31866,seq31865__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_require_state,sci.impl.load.eval_require);
sci.impl.load.eval_use = (function sci$impl$load$eval_use(var_args){
var args__5775__auto__ = [];
var len__5769__auto___31872 = arguments.length;
var i__5770__auto___31873 = (0);
while(true){
if((i__5770__auto___31873 < len__5769__auto___31872)){
args__5775__auto__.push((arguments[i__5770__auto___31873]));

var G__31874 = (i__5770__auto___31873 + (1));
i__5770__auto___31873 = G__31874;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(sci.impl.load.eval_use.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,args){
return sci.impl.load.load_libs.call(null,ctx,new cljs.core.Keyword(null,"use","use",-1846382424),args);
}));

(sci.impl.load.eval_use.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(sci.impl.load.eval_use.cljs$lang$applyTo = (function (seq31870){
var G__31871 = cljs.core.first.call(null,seq31870);
var seq31870__$1 = cljs.core.next.call(null,seq31870);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31871,seq31870__$1);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_use_state,sci.impl.load.eval_use);
sci.impl.load.eval_refer_clojure = (function sci$impl$load$eval_refer_clojure(ctx,exprs){
var ns_sym = new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null);
var exprs__$1 = exprs;
while(true){
if(cljs.core.truth_(exprs__$1)){
var vec__31875 = exprs__$1;
var k = cljs.core.nth.call(null,vec__31875,(0),null);
var v = cljs.core.nth.call(null,vec__31875,(1),null);
var G__31878_31883 = k;
var G__31878_31884__$1 = (((G__31878_31883 instanceof cljs.core.Keyword))?G__31878_31883.fqn:null);
switch (G__31878_31884__$1) {
case "exclude":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.utils.current_ns_name.call(null);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn,new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),v);
});})(exprs__$1,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym))
);

break;
case "only":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.utils.current_ns_name.call(null);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var other_vars = cljs.core.select_keys.call(null,other_ns,v);
return cljs.core.update_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),cljs.core.merge,other_vars);
});})(exprs__$1,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym))
);

break;
case "rename":
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),((function (exprs__$1,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym){
return (function (env){
var cnn = sci.impl.utils.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var other_ns = cljs.core.get_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),ns_sym], null));
var the_current_ns__$1 = cljs.core.reduce.call(null,((function (exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym){
return (function (acc,p__31879){
var vec__31880 = p__31879;
var original_name = cljs.core.nth.call(null,vec__31880,(0),null);
var new_name = cljs.core.nth.call(null,vec__31880,(1),null);
return cljs.core.update_in.call(null,cljs.core.assoc_in.call(null,acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refers","refers",158076809),new_name], null),cljs.core.get.call(null,other_ns,original_name)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"refer","refer",-964295553),ns_sym,new cljs.core.Keyword(null,"exclude","exclude",-1230250334)], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),original_name);
});})(exprs__$1,cnn,namespaces,the_current_ns,other_ns,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym))
,the_current_ns,v);
return cljs.core.assoc_in.call(null,env,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cnn], null),the_current_ns__$1);
});})(exprs__$1,G__31878_31883,G__31878_31884__$1,vec__31875,k,v,ns_sym))
);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31878_31884__$1)].join('')));

}

var G__31886 = cljs.core.nnext.call(null,exprs__$1);
exprs__$1 = G__31886;
continue;
} else {
return null;
}
break;
}
});
sci.impl.load.eval_refer_STAR_ = (function sci$impl$load$eval_refer_STAR_(env,ns_sym,filters){

var cnn = sci.impl.utils.current_ns_name.call(null);
var namespaces = new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469).cljs$core$IFn$_invoke$arity$1(env);
var ns = (function (){var or__5045__auto__ = cljs.core.get.call(null,namespaces,ns_sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
throw (new Error(["No namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns_sym)].join('')));
}
})();
var fs = cljs.core.apply.call(null,cljs.core.hash_map,filters);
var public_keys = cljs.core.filter.call(null,cljs.core.symbol_QMARK_,cljs.core.keys.call(null,ns));
var rename = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"rename","rename",1508157613).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})();
var exclude = cljs.core.set.call(null,new cljs.core.Keyword(null,"exclude","exclude",-1230250334).cljs$core$IFn$_invoke$arity$1(fs));
var to_do = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"all","all",892129742),new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs)))?public_keys:(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"refer","refer",-964295553).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = new cljs.core.Keyword(null,"only","only",1907811652).cljs$core$IFn$_invoke$arity$1(fs);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return public_keys;
}
}
})());
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = to_do;
if(cljs.core.truth_(and__5043__auto__)){
return (!(cljs.core.sequential_QMARK_.call(null,to_do)));
} else {
return and__5043__auto__;
}
})())?(function(){throw (new Error(":only/:refer value must be a sequential collection of symbols"))})():null);
var the_current_ns = cljs.core.get.call(null,namespaces,cnn);
var referred = new cljs.core.Keyword(null,"refers","refers",158076809).cljs$core$IFn$_invoke$arity$1(the_current_ns);
var referred__$1 = cljs.core.reduce.call(null,(function (referred__$1,sym){
if(cljs.core.not.call(null,exclude.call(null,sym))){
var v = cljs.core.get.call(null,ns,sym);
if(cljs.core.truth_(v)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym)," does not exist"].join('')
));
}

return cljs.core.assoc.call(null,referred__$1,(function (){var or__5045__auto__ = rename.call(null,sym);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return sym;
}
})(),v);
} else {
return referred__$1;
}
}),referred,to_do);
var the_current_ns__$1 = cljs.core.assoc.call(null,the_current_ns,new cljs.core.Keyword(null,"refers","refers",158076809),referred__$1);
var namespaces__$1 = cljs.core.assoc.call(null,namespaces,cnn,the_current_ns__$1);
var env__$1 = cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),namespaces__$1);
return env__$1;
});
/**
 * The function equivalent of :refer is handled differently than what we
 *   did before (this is more like what Clojure itself does.) For
 *   referring clojure.core we still use the old code.
 */
sci.impl.load.eval_refer = (function sci$impl$load$eval_refer(var_args){
var args__5775__auto__ = [];
var len__5769__auto___31890 = arguments.length;
var i__5770__auto___31891 = (0);
while(true){
if((i__5770__auto___31891 < len__5769__auto___31890)){
args__5775__auto__.push((arguments[i__5770__auto___31891]));

var G__31892 = (i__5770__auto___31891 + (1));
i__5770__auto___31891 = G__31892;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(sci.impl.load.eval_refer.cljs$core$IFn$_invoke$arity$variadic = (function (ctx,ns_sym,filters){
if(cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"clojure.core","clojure.core",-189332625,null),ns_sym)){
sci.impl.load.eval_refer_clojure.call(null,ctx,filters);
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"env","env",-1815813235).cljs$core$IFn$_invoke$arity$1(ctx),sci.impl.load.eval_refer_STAR_,ns_sym,filters);
}

return null;
}));

(sci.impl.load.eval_refer.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(sci.impl.load.eval_refer.cljs$lang$applyTo = (function (seq31887){
var G__31888 = cljs.core.first.call(null,seq31887);
var seq31887__$1 = cljs.core.next.call(null,seq31887);
var G__31889 = cljs.core.first.call(null,seq31887__$1);
var seq31887__$2 = cljs.core.next.call(null,seq31887__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31888,G__31889,seq31887__$2);
}));

cljs.core.vreset_BANG_.call(null,sci.impl.utils.eval_refer_state,sci.impl.load.eval_refer);
