// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs._init_state = (function flureenjs$_init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"as-aliases","as-aliases",1485064798)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ctx","ctx",1146921409,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a value from the user's context if set. Provide the key or key sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path + query costs"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,803,null,803,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,803,null,new cljs.core.Symbol(null,"any","any",-948528346,null),803,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,7,546,null,546,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,546,null,new cljs.core.Symbol(null,"any","any",-948528346,null),546,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,7,372,null,372,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,372,null,new cljs.core.Symbol(null,"any","any",-948528346,null),372,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns true if key is present.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,135,null,135,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,135,null,new cljs.core.Symbol(null,"any","any",-948528346,null),135,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,363,null,363,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null))),"Returns a value from the user's context if set. Provide the key or key sequence.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ctx","fluree.db.dbfunctions.fns/ctx",570947084,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__63376","p__63376",-174922287,null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null)),null,cljs.core.list(null,null),1,false,363,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null),363,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"key-or-ks","key-or-ks",715926861,null)], null))),"Returns a value from the user's context if set. Provide the key or key sequence.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,504,null,504,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),504,null,504,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,7,775,null,775,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,775,null,new cljs.core.Symbol(null,"any","any",-948528346,null),775,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,684,null,684,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,684,null,new cljs.core.Symbol(null,"any","any",-948528346,null),684,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,570,null,570,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,570,null,new cljs.core.Symbol(null,"any","any",-948528346,null),570,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,426,null,426,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),426,null,new cljs.core.Symbol(null,"any","any",-948528346,null),426,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,7,825,null,825,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,825,null,new cljs.core.Symbol(null,"any","any",-948528346,null),825,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,7,303,null,303,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,303,null,new cljs.core.Symbol(null,"any","any",-948528346,null),303,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,171,null,171,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,171,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),171,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,763,null,763,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,763,null,new cljs.core.Symbol(null,"any","any",-948528346,null),763,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,813,null,813,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,813,null,new cljs.core.Symbol(null,"any","any",-948528346,null),813,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),41,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),41,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,41,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),41,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,439,null,439,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),439,null,new cljs.core.Symbol(null,"any","any",-948528346,null),439,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,619,null,619,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),619,null,new cljs.core.Symbol(null,"any","any",-948528346,null),619,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,491,null,491,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),491,null,new cljs.core.Symbol(null,"any","any",-948528346,null),491,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,272,null,272,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p__62887","p__62887",-1312559381,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,272,null,new cljs.core.Symbol(null,"any","any",-948528346,null),272,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"keys","keys",1068423698),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"cache","cache",403508473,null),new cljs.core.Symbol(null,"db","db",-1661185010,null)], null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,315,null,315,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,315,null,new cljs.core.Symbol(null,"any","any",-948528346,null),315,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,7,111,null,111,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,111,null,new cljs.core.Symbol(null,"any","any",-948528346,null),111,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,645,null,645,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,645,null,new cljs.core.Symbol(null,"any","any",-948528346,null),645,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,583,null,583,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,583,null,new cljs.core.Symbol(null,"any","any",-948528346,null),583,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,465,null,465,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),465,null,new cljs.core.Symbol(null,"any","any",-948528346,null),465,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),52,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),52,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,52,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),52,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,75,null,75,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,75,null,new cljs.core.Symbol(null,"any","any",-948528346,null),75,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,787,null,787,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),787,null,787,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,413,null,413,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),413,null,new cljs.core.Symbol(null,"any","any",-948528346,null),413,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,658,null,658,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,658,null,new cljs.core.Symbol(null,"any","any",-948528346,null),658,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,7,147,null,147,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,147,null,new cljs.core.Symbol(null,"any","any",-948528346,null),147,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,606,null,606,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),606,null,new cljs.core.Symbol(null,"any","any",-948528346,null),606,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,386,null,386,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns a hash-set of values","9 + count of items in hash-set"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),386,null,new cljs.core.Symbol(null,"any","any",-948528346,null),386,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns a hash-set of values","9 + count of items in hash-set"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,245,null,245,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),245,null,new cljs.core.Symbol(null,"any","any",-948528346,null),245,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,7,709,null,709,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,709,null,new cljs.core.Symbol(null,"any","any",-948528346,null),709,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),22,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),22,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,22,new cljs.core.Symbol(null,"any","any",-948528346,null),22,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,203,null,203,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),203,null,203,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,671,null,671,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,671,null,new cljs.core.Symbol(null,"any","any",-948528346,null),671,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,60,null,60,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,60,null,new cljs.core.Symbol(null,"any","any",-948528346,null),60,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,88,null,88,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,88,null,new cljs.core.Symbol(null,"any","any",-948528346,null),88,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,837,null,837,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,837,null,new cljs.core.Symbol(null,"any","any",-948528346,null),837,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,696,null,696,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,696,null,new cljs.core.Symbol(null,"any","any",-948528346,null),696,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,100,null,100,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,100,null,new cljs.core.Symbol(null,"any","any",-948528346,null),100,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),632,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,452,null,452,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),452,null,new cljs.core.Symbol(null,"any","any",-948528346,null),452,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,7,159,null,159,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,159,null,new cljs.core.Symbol(null,"any","any",-948528346,null),159,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,7,558,null,558,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,558,null,new cljs.core.Symbol(null,"any","any",-948528346,null),558,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,593,null,593,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),593,null,new cljs.core.Symbol(null,"any","any",-948528346,null),593,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,123,null,123,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),123,null,new cljs.core.Symbol(null,"any","any",-948528346,null),123,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,751,null,751,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,751,null,new cljs.core.Symbol(null,"any","any",-948528346,null),751,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,478,null,478,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),478,null,new cljs.core.Symbol(null,"any","any",-948528346,null),478,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,400,null,400,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),400,null,new cljs.core.Symbol(null,"any","any",-948528346,null),400,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,7,258,null,258,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,258,null,new cljs.core.Symbol(null,"any","any",-948528346,null),258,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,7,328,null,328,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.","9 + length of path + query costs"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,328,null,new cljs.core.Symbol(null,"any","any",-948528346,null),328,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Used to get-all values in a nested result set, or also can follow a subject down the provided path and return a set of all matching subjects.","9 + length of path + query costs"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,216,null,216,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),216,null,216,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),35,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),35,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,35,new cljs.core.Symbol(null,"any","any",-948528346,null),35,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,7,739,null,739,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,739,null,new cljs.core.Symbol(null,"any","any",-948528346,null),739,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),14,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),14,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,14,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),14,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,7,721,null,721,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,721,null,new cljs.core.Symbol(null,"any","any",-948528346,null),721,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,7,531,null,531,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,531,null,new cljs.core.Symbol(null,"any","any",-948528346,null),531,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,232,null,232,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),232,null,new cljs.core.Symbol(null,"any","any",-948528346,null),232,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,7,190,null,190,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,190,null,new cljs.core.Symbol(null,"any","any",-948528346,null),190,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,7,349,null,349,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Users/wmorgan/dev/fluree/db-main/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,349,null,new cljs.core.Symbol(null,"any","any",-948528346,null),349,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Returns the value of a nested structure","Length of path"])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 29, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"get","get",1683182755),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"cache","cache",-1237023054),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"fine","fine",-873037193),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"ctx","ctx",-493610118),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 29, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"fine","fine",-873037193),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"cache","cache",-1237023054),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"ctx","ctx",-493610118),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null,cljs.core.PersistentArrayMap.EMPTY]));
});
flureenjs._ns_state = cljs.js.empty_state.call(null,flureenjs._init_state);
var st_76902 = flureenjs._ns_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_76902,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs._app_state !== 'undefined')){
} else {
flureenjs._app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"2.0.0-alpha3"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs._app_state)));
flureenjs._njs_crypto = (function (){try{return require("crypto");
}catch (e76903){var ex = e76903;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join('')], null));

fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"warning","warning",-1685650671),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Private key generation is not available."], null));

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.setLogging = (function flureenjs$setLogging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__76905 = opts_SINGLEQUOTE_;
var map__76905__$1 = cljs.core.__destructure_map.call(null,map__76905);
var level = cljs.core.get.call(null,map__76905__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.setLogging', flureenjs.setLogging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.accountId = (function flureenjs$accountId(var_args){
var G__76907 = arguments.length;
switch (G__76907) {
case 1:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.accountId.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.accountId', flureenjs.accountId);

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.accountId.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.accountId.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.httpSignature = (function flureenjs$httpSignature(var_args){
var G__76910 = arguments.length;
switch (G__76910) {
case 4:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.httpSignature', flureenjs.httpSignature);

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.httpSignature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.httpSignature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.httpSignature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.publicKeyFromPrivate = (function flureenjs$publicKeyFromPrivate(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.publicKeyFromPrivate', flureenjs.publicKeyFromPrivate);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.publicKey = (function flureenjs$publicKey(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.publicKey', flureenjs.publicKey);
/**
 * Generates a private-public key pair using the Node.js
 *   crypto module. The JavaScript code looks like:
 * 
 *   const ecdh = crypto.createECDH('secp256k1');
 *   ecdh.generateKeys()
 *   return { private: ecdh.getPrivateKey('hex'),
 *            public:  ecdh.getPublicKey('hex','compressed')};
 *   
 */
flureenjs._generate_key_pair = (function flureenjs$_generate_key_pair(){
if(cljs.core.truth_(flureenjs._njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs._njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *   the public key and account id. Return keys are :public,
 *   :private, and :id.
 *   
 */
flureenjs.newPrivateKey = (function flureenjs$newPrivateKey(){
try{var kp = flureenjs._generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e76912){var e = e76912;
fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join('')], null));

throw e;
}});
goog.exportSymbol('flureenjs.newPrivateKey', flureenjs.newPrivateKey);
/**
 * Returns a signature for a message given a private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or ledger level.
 *   This will only succeed if signed by the default private key for the tx-group,
 *   or if setting for a ledger-id, either the tx-group or network.
 * 
 *   It will overwrite any existing default private key.
 * 
 *   It will respond with true or false.
 * 
 *   Returns promise that eventually contains the results. 
 */
flureenjs.setDefaultKey = (function flureenjs$setDefaultKey(var_args){
var G__76914 = arguments.length;
switch (G__76914) {
case 2:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.setDefaultKey', flureenjs.setDefaultKey);

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.setDefaultKey.call(null,conn,null,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,null,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,ledger_id,private_key){
return flureenjs.setDefaultKey.call(null,conn,network,ledger_id,private_key,null);
}));

(flureenjs.setDefaultKey.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,ledger_id,private_key,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_76973){
var state_val_76974 = (state_76973[(1)]);
if((state_val_76974 === (7))){
var inst_76932 = (state_76973[(7)]);
var state_76973__$1 = state_76973;
var statearr_76975_77016 = state_76973__$1;
(statearr_76975_77016[(2)] = inst_76932);

(statearr_76975_77016[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (20))){
var inst_76944 = (state_76973[(8)]);
var inst_76962 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_76944);
var state_76973__$1 = state_76973;
var statearr_76976_77017 = state_76973__$1;
(statearr_76976_77017[(2)] = inst_76962);

(statearr_76976_77017[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (1))){
var state_76973__$1 = state_76973;
var statearr_76977_77018 = state_76973__$1;
(statearr_76977_77018[(2)] = null);

(statearr_76977_77018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (4))){
var inst_76915 = (state_76973[(2)]);
var inst_76916 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76917 = [inst_76915];
var inst_76918 = (new cljs.core.PersistentVector(null,1,(5),inst_76916,inst_76917,null));
var inst_76919 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_76918);
var inst_76920 = reject.call(null,inst_76915);
var state_76973__$1 = (function (){var statearr_76978 = state_76973;
(statearr_76978[(9)] = inst_76919);

return statearr_76978;
})();
var statearr_76979_77019 = state_76973__$1;
(statearr_76979_77019[(2)] = inst_76920);

(statearr_76979_77019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (15))){
var inst_76950 = (state_76973[(10)]);
var inst_76931 = (state_76973[(11)]);
var inst_76952 = fluree.crypto.sign_message.call(null,inst_76950,inst_76931);
var state_76973__$1 = state_76973;
var statearr_76980_77020 = state_76973__$1;
(statearr_76980_77020[(2)] = inst_76952);

(statearr_76980_77020[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (21))){
var inst_76964 = (state_76973[(2)]);
var state_76973__$1 = state_76973;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_76973__$1,(18),inst_76964);
} else {
if((state_val_76974 === (13))){
var state_76973__$1 = state_76973;
var statearr_76981_77021 = state_76973__$1;
(statearr_76981_77021[(2)] = null);

(statearr_76981_77021[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (6))){
var inst_76929 = (state_76973[(12)]);
var state_76973__$1 = state_76973;
var statearr_76982_77022 = state_76973__$1;
(statearr_76982_77022[(2)] = inst_76929);

(statearr_76982_77022[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (17))){
var inst_76931 = (state_76973[(11)]);
var inst_76955 = (state_76973[(2)]);
var state_76973__$1 = (function (){var statearr_76983 = state_76973;
(statearr_76983[(13)] = inst_76955);

return statearr_76983;
})();
if(cljs.core.truth_(inst_76931)){
var statearr_76984_77023 = state_76973__$1;
(statearr_76984_77023[(1)] = (19));

} else {
var statearr_76985_77024 = state_76973__$1;
(statearr_76985_77024[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (3))){
var inst_76971 = (state_76973[(2)]);
var state_76973__$1 = state_76973;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_76973__$1,inst_76971);
} else {
if((state_val_76974 === (12))){
var inst_76944 = (state_76973[(8)]);
var inst_76946 = fluree.db.util.core.without_nils.call(null,inst_76944);
var inst_76947 = fluree.db.util.json.stringify.call(null,inst_76946);
var state_76973__$1 = state_76973;
var statearr_76986_77025 = state_76973__$1;
(statearr_76986_77025[(2)] = inst_76947);

(statearr_76986_77025[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (2))){
var inst_76929 = (state_76973[(12)]);
var _ = (function (){var statearr_76987 = state_76973;
(statearr_76987[(4)] = cljs.core.cons.call(null,(5),(state_76973[(4)])));

return statearr_76987;
})();
var inst_76927 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_76928 = cljs.core.__destructure_map.call(null,inst_76927);
var inst_76929__$1 = cljs.core.get.call(null,inst_76928,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_76930 = cljs.core.get.call(null,inst_76928,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_76931 = cljs.core.get.call(null,inst_76928,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_76932 = fluree.db.util.core.current_time_millis.call(null);
var state_76973__$1 = (function (){var statearr_76988 = state_76973;
(statearr_76988[(12)] = inst_76929__$1);

(statearr_76988[(7)] = inst_76932);

(statearr_76988[(11)] = inst_76931);

(statearr_76988[(14)] = inst_76930);

return statearr_76988;
})();
if(cljs.core.truth_(inst_76929__$1)){
var statearr_76989_77026 = state_76973__$1;
(statearr_76989_77026[(1)] = (6));

} else {
var statearr_76990_77027 = state_76973__$1;
(statearr_76990_77027[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (19))){
var inst_76950 = (state_76973[(10)]);
var inst_76955 = (state_76973[(13)]);
var inst_76957 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_76958 = [inst_76950,inst_76955];
var inst_76959 = cljs.core.PersistentHashMap.fromArrays(inst_76957,inst_76958);
var inst_76960 = fluree.db.operations.command_async.call(null,conn,inst_76959);
var state_76973__$1 = state_76973;
var statearr_76991_77028 = state_76973__$1;
(statearr_76991_77028[(2)] = inst_76960);

(statearr_76991_77028[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (11))){
var inst_76931 = (state_76973[(11)]);
var inst_76936 = (state_76973[(15)]);
var inst_76941 = (state_76973[(2)]);
var inst_76942 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_76943 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,ledger_id,private_key,inst_76936,inst_76941];
var inst_76944 = cljs.core.PersistentHashMap.fromArrays(inst_76942,inst_76943);
var state_76973__$1 = (function (){var statearr_76993 = state_76973;
(statearr_76993[(8)] = inst_76944);

return statearr_76993;
})();
if(cljs.core.truth_(inst_76931)){
var statearr_76994_77029 = state_76973__$1;
(statearr_76994_77029[(1)] = (12));

} else {
var statearr_76995_77030 = state_76973__$1;
(statearr_76995_77030[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (9))){
var inst_76930 = (state_76973[(14)]);
var state_76973__$1 = state_76973;
var statearr_76996_77031 = state_76973__$1;
(statearr_76996_77031[(2)] = inst_76930);

(statearr_76996_77031[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (5))){
var _ = (function (){var statearr_76997 = state_76973;
(statearr_76997[(4)] = cljs.core.rest.call(null,(state_76973[(4)])));

return statearr_76997;
})();
var state_76973__$1 = state_76973;
var ex76992 = (state_76973__$1[(2)]);
var statearr_76998_77032 = state_76973__$1;
(statearr_76998_77032[(5)] = ex76992);


var statearr_76999_77033 = state_76973__$1;
(statearr_76999_77033[(1)] = (4));

(statearr_76999_77033[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (14))){
var inst_76931 = (state_76973[(11)]);
var inst_76950 = (state_76973[(2)]);
var state_76973__$1 = (function (){var statearr_77000 = state_76973;
(statearr_77000[(10)] = inst_76950);

return statearr_77000;
})();
if(cljs.core.truth_(inst_76931)){
var statearr_77001_77034 = state_76973__$1;
(statearr_77001_77034[(1)] = (15));

} else {
var statearr_77002_77035 = state_76973__$1;
(statearr_77002_77035[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (16))){
var state_76973__$1 = state_76973;
var statearr_77003_77036 = state_76973__$1;
(statearr_77003_77036[(2)] = null);

(statearr_77003_77036[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (10))){
var inst_76932 = (state_76973[(7)]);
var inst_76939 = (inst_76932 + (30000));
var state_76973__$1 = state_76973;
var statearr_77004_77037 = state_76973__$1;
(statearr_77004_77037[(2)] = inst_76939);

(statearr_77004_77037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (18))){
var inst_76966 = (state_76973[(2)]);
var inst_76967 = cljs.core.clj__GT_js.call(null,inst_76966);
var inst_76968 = resolve.call(null,inst_76967);
var _ = (function (){var statearr_77005 = state_76973;
(statearr_77005[(4)] = cljs.core.rest.call(null,(state_76973[(4)])));

return statearr_77005;
})();
var state_76973__$1 = state_76973;
var statearr_77006_77038 = state_76973__$1;
(statearr_77006_77038[(2)] = inst_76968);

(statearr_77006_77038[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_76974 === (8))){
var inst_76930 = (state_76973[(14)]);
var inst_76936 = (state_76973[(2)]);
var state_76973__$1 = (function (){var statearr_77007 = state_76973;
(statearr_77007[(15)] = inst_76936);

return statearr_77007;
})();
if(cljs.core.truth_(inst_76930)){
var statearr_77008_77039 = state_76973__$1;
(statearr_77008_77039[(1)] = (9));

} else {
var statearr_77009_77040 = state_76973__$1;
(statearr_77009_77040[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_77010 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77010[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_77010[(1)] = (1));

return statearr_77010;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_76973){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_76973);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77011){var ex__2749__auto__ = e77011;
var statearr_77012_77041 = state_76973;
(statearr_77012_77041[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_76973[(4)]))){
var statearr_77013_77042 = state_76973;
(statearr_77013_77042[(1)] = cljs.core.first.call(null,(state_76973[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77043 = state_76973;
state_76973 = G__77043;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_76973){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_76973);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77014 = f__2769__auto__.call(null);
(statearr_77014[(6)] = c__2768__auto__);

return statearr_77014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.setDefaultKey.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___77050 = arguments.length;
var i__5770__auto___77051 = (0);
while(true){
if((i__5770__auto___77051 < len__5769__auto___77050)){
args__5775__auto__.push((arguments[i__5770__auto___77051]));

var G__77052 = (i__5770__auto___77051 + (1));
i__5770__auto___77051 = G__77052;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__77046){
var vec__77047 = p__77046;
var opts = cljs.core.nth.call(null,vec__77047,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq77044){
var G__77045 = cljs.core.first.call(null,seq77044);
var seq77044__$1 = cljs.core.next.call(null,seq77044);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__77045,seq77044__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordGenerate = (function flureenjs$passwordGenerate(var_args){
var G__77054 = arguments.length;
switch (G__77054) {
case 4:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordGenerate', flureenjs.passwordGenerate);

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.passwordGenerate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.passwordGenerate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.passwordGenerate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.passwordLogin = (function flureenjs$passwordLogin(var_args){
var G__77057 = arguments.length;
switch (G__77057) {
case 4:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.passwordLogin', flureenjs.passwordLogin);

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.passwordLogin.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.passwordLogin.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renewToken = (function flureenjs$renewToken(var_args){
var G__77060 = arguments.length;
switch (G__77060) {
case 2:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renewToken', flureenjs.renewToken);

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renewToken.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renewToken.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *   :retracted key containing maps of data organized by subject
 *   and containing full predicate names.
 */
flureenjs.blockEventToMap = (function flureenjs$blockEventToMap(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77094){
var state_val_77095 = (state_77094[(1)]);
if((state_val_77095 === (1))){
var state_77094__$1 = state_77094;
var statearr_77096_77111 = state_77094__$1;
(statearr_77096_77111[(2)] = null);

(statearr_77096_77111[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77095 === (2))){
var _ = (function (){var statearr_77097 = state_77094;
(statearr_77097[(4)] = cljs.core.cons.call(null,(5),(state_77094[(4)])));

return statearr_77097;
})();
var inst_77075 = flureenjs._db_instance.call(null,conn,ledger);
var state_77094__$1 = state_77094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77094__$1,(6),inst_77075);
} else {
if((state_val_77095 === (3))){
var inst_77092 = (state_77094[(2)]);
var state_77094__$1 = state_77094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77094__$1,inst_77092);
} else {
if((state_val_77095 === (4))){
var inst_77063 = (state_77094[(2)]);
var inst_77064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77065 = [inst_77063];
var inst_77066 = (new cljs.core.PersistentVector(null,1,(5),inst_77064,inst_77065,null));
var inst_77067 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77066);
var inst_77068 = reject.call(null,inst_77063);
var state_77094__$1 = (function (){var statearr_77099 = state_77094;
(statearr_77099[(7)] = inst_77067);

return statearr_77099;
})();
var statearr_77100_77112 = state_77094__$1;
(statearr_77100_77112[(2)] = inst_77068);

(statearr_77100_77112[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77095 === (5))){
var _ = (function (){var statearr_77101 = state_77094;
(statearr_77101[(4)] = cljs.core.rest.call(null,(state_77094[(4)])));

return statearr_77101;
})();
var state_77094__$1 = state_77094;
var ex77098 = (state_77094__$1[(2)]);
var statearr_77102_77113 = state_77094__$1;
(statearr_77102_77113[(5)] = ex77098);


var statearr_77103_77114 = state_77094__$1;
(statearr_77103_77114[(1)] = (4));

(statearr_77103_77114[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77095 === (6))){
var inst_77077 = (state_77094[(2)]);
var inst_77078 = fluree.db.util.async.throw_err.call(null,inst_77077);
var inst_77079 = (function (){var db = inst_77078;
return (function (p1__77062_SHARP_){
return cljs.core.nth.call(null,p1__77062_SHARP_,(4));
});
})();
var inst_77080 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_77081 = cljs.core.group_by.call(null,inst_77079,inst_77080);
var inst_77082 = cljs.core.__destructure_map.call(null,inst_77081);
var inst_77083 = cljs.core.get.call(null,inst_77082,true);
var inst_77084 = cljs.core.get.call(null,inst_77082,false);
var inst_77085 = (function (){var db = inst_77078;
var map__77074 = inst_77082;
var add = inst_77083;
var retract = inst_77084;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_77086 = inst_77085.call(null,inst_77083);
var inst_77087 = inst_77085.call(null,inst_77084);
var inst_77088 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_77086,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_77087);
var inst_77089 = resolve.call(null,inst_77088);
var _ = (function (){var statearr_77104 = state_77094;
(statearr_77104[(4)] = cljs.core.rest.call(null,(state_77094[(4)])));

return statearr_77104;
})();
var state_77094__$1 = state_77094;
var statearr_77105_77115 = state_77094__$1;
(statearr_77105_77115[(2)] = inst_77089);

(statearr_77105_77115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$blockEventToMap_$_state_machine__2746__auto__ = null;
var flureenjs$blockEventToMap_$_state_machine__2746__auto____0 = (function (){
var statearr_77106 = [null,null,null,null,null,null,null,null];
(statearr_77106[(0)] = flureenjs$blockEventToMap_$_state_machine__2746__auto__);

(statearr_77106[(1)] = (1));

return statearr_77106;
});
var flureenjs$blockEventToMap_$_state_machine__2746__auto____1 = (function (state_77094){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77107){var ex__2749__auto__ = e77107;
var statearr_77108_77116 = state_77094;
(statearr_77108_77116[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77094[(4)]))){
var statearr_77109_77117 = state_77094;
(statearr_77109_77117[(1)] = cljs.core.first.call(null,(state_77094[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77118 = state_77094;
state_77094 = G__77118;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$blockEventToMap_$_state_machine__2746__auto__ = function(state_77094){
switch(arguments.length){
case 0:
return flureenjs$blockEventToMap_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$blockEventToMap_$_state_machine__2746__auto____1.call(this,state_77094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$blockEventToMap_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$blockEventToMap_$_state_machine__2746__auto____0;
flureenjs$blockEventToMap_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$blockEventToMap_$_state_machine__2746__auto____1;
return flureenjs$blockEventToMap_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77110 = f__2769__auto__.call(null);
(statearr_77110[(6)] = c__2768__auto__);

return statearr_77110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.closeListener = (function flureenjs$closeListener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.closeListener', flureenjs.closeListener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs._db_instance = (function flureenjs$_db_instance(var_args){
var G__77120 = arguments.length;
switch (G__77120) {
case 2:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs._db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs._db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2768__auto___77196 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77169){
var state_val_77170 = (state_77169[(1)]);
if((state_val_77170 === (7))){
var inst_77140 = (state_77169[(7)]);
var state_77169__$1 = state_77169;
if(cljs.core.truth_(inst_77140)){
var statearr_77171_77197 = state_77169__$1;
(statearr_77171_77197[(1)] = (9));

} else {
var statearr_77172_77198 = state_77169__$1;
(statearr_77172_77198[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (1))){
var state_77169__$1 = state_77169;
var statearr_77173_77199 = state_77169__$1;
(statearr_77173_77199[(2)] = null);

(statearr_77173_77199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (4))){
var inst_77121 = (state_77169[(2)]);
var inst_77122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77123 = [inst_77121];
var inst_77124 = (new cljs.core.PersistentVector(null,1,(5),inst_77122,inst_77123,null));
var inst_77125 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77124);
var inst_77126 = cljs.core.async.put_BANG_.call(null,pc,inst_77121);
var inst_77127 = cljs.core.async.close_BANG_.call(null,pc);
var state_77169__$1 = (function (){var statearr_77174 = state_77169;
(statearr_77174[(8)] = inst_77125);

(statearr_77174[(9)] = inst_77126);

return statearr_77174;
})();
var statearr_77175_77200 = state_77169__$1;
(statearr_77175_77200[(2)] = inst_77127);

(statearr_77175_77200[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (6))){
var inst_77139 = (state_77169[(10)]);
var state_77169__$1 = state_77169;
var statearr_77176_77201 = state_77169__$1;
(statearr_77176_77201[(2)] = inst_77139);

(statearr_77176_77201[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (3))){
var inst_77167 = (state_77169[(2)]);
var state_77169__$1 = state_77169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77169__$1,inst_77167);
} else {
if((state_val_77170 === (12))){
var inst_77143 = (state_77169[(11)]);
var inst_77144 = (state_77169[(12)]);
var inst_77161 = (state_77169[(2)]);
var inst_77162 = fluree.db.util.async.throw_err.call(null,inst_77161);
var inst_77163 = cljs.core.assoc.call(null,inst_77162,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_77143,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),inst_77144);
var inst_77164 = cljs.core.async.put_BANG_.call(null,pc,inst_77163);
var _ = (function (){var statearr_77177 = state_77169;
(statearr_77177[(4)] = cljs.core.rest.call(null,(state_77169[(4)])));

return statearr_77177;
})();
var state_77169__$1 = state_77169;
var statearr_77178_77202 = state_77169__$1;
(statearr_77178_77202[(2)] = inst_77164);

(statearr_77178_77202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (2))){
var inst_77139 = (state_77169[(10)]);
var _ = (function (){var statearr_77179 = state_77169;
(statearr_77179[(4)] = cljs.core.cons.call(null,(5),(state_77169[(4)])));

return statearr_77179;
})();
var inst_77137 = opts;
var inst_77138 = cljs.core.__destructure_map.call(null,inst_77137);
var inst_77139__$1 = cljs.core.get.call(null,inst_77138,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_77140 = cljs.core.get.call(null,inst_77138,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_77141 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_77142 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_77143 = cljs.core.nth.call(null,inst_77142,(0),null);
var inst_77144 = cljs.core.nth.call(null,inst_77142,(1),null);
var state_77169__$1 = (function (){var statearr_77180 = state_77169;
(statearr_77180[(10)] = inst_77139__$1);

(statearr_77180[(13)] = inst_77141);

(statearr_77180[(11)] = inst_77143);

(statearr_77180[(7)] = inst_77140);

(statearr_77180[(12)] = inst_77144);

return statearr_77180;
})();
if(cljs.core.truth_(inst_77139__$1)){
var statearr_77181_77203 = state_77169__$1;
(statearr_77181_77203[(1)] = (6));

} else {
var statearr_77182_77204 = state_77169__$1;
(statearr_77182_77204[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (11))){
var inst_77155 = (state_77169[(2)]);
var state_77169__$1 = state_77169;
var statearr_77184_77205 = state_77169__$1;
(statearr_77184_77205[(2)] = inst_77155);

(statearr_77184_77205[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (9))){
var inst_77140 = (state_77169[(7)]);
var inst_77148 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77149 = fluree.db.connection_js.validate_token.call(null,conn,inst_77140);
var inst_77150 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_77149);
var inst_77151 = ["_auth/id",inst_77150];
var inst_77152 = (new cljs.core.PersistentVector(null,2,(5),inst_77148,inst_77151,null));
var state_77169__$1 = state_77169;
var statearr_77185_77206 = state_77169__$1;
(statearr_77185_77206[(2)] = inst_77152);

(statearr_77185_77206[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (5))){
var _ = (function (){var statearr_77186 = state_77169;
(statearr_77186[(4)] = cljs.core.rest.call(null,(state_77169[(4)])));

return statearr_77186;
})();
var state_77169__$1 = state_77169;
var ex77183 = (state_77169__$1[(2)]);
var statearr_77187_77207 = state_77169__$1;
(statearr_77187_77207[(5)] = ex77183);


var statearr_77188_77208 = state_77169__$1;
(statearr_77188_77208[(1)] = (4));

(statearr_77188_77208[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (10))){
var state_77169__$1 = state_77169;
var statearr_77189_77209 = state_77169__$1;
(statearr_77189_77209[(2)] = null);

(statearr_77189_77209[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77170 === (8))){
var inst_77157 = (state_77169[(2)]);
var inst_77158 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_77157);
var inst_77159 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_77158);
var state_77169__$1 = state_77169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77169__$1,(12),inst_77159);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_77190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77190[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_77190[(1)] = (1));

return statearr_77190;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_77169){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77191){var ex__2749__auto__ = e77191;
var statearr_77192_77210 = state_77169;
(statearr_77192_77210[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77169[(4)]))){
var statearr_77193_77211 = state_77169;
(statearr_77193_77211[(1)] = cljs.core.first.call(null,(state_77169[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77212 = state_77169;
state_77169 = G__77212;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_77169){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_77169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77194 = f__2769__auto__.call(null);
(statearr_77194[(6)] = c__2768__auto___77196);

return statearr_77194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return pc;
}));

(flureenjs._db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__5775__auto__ = [];
var len__5769__auto___77255 = arguments.length;
var i__5770__auto___77256 = (0);
while(true){
if((i__5770__auto___77256 < len__5769__auto___77255)){
args__5775__auto__.push((arguments[i__5770__auto___77256]));

var G__77257 = (i__5770__auto___77256 + (1));
i__5770__auto___77256 = G__77257;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__77216){
var vec__77217 = p__77216;
var opts = cljs.core.nth.call(null,vec__77217,(0),null);
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77238){
var state_val_77239 = (state_77238[(1)]);
if((state_val_77239 === (1))){
var state_77238__$1 = state_77238;
var statearr_77240_77258 = state_77238__$1;
(statearr_77240_77258[(2)] = null);

(statearr_77240_77258[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77239 === (2))){
var _ = (function (){var statearr_77241 = state_77238;
(statearr_77241[(4)] = cljs.core.cons.call(null,(5),(state_77238[(4)])));

return statearr_77241;
})();
var inst_77231 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_77232 = flureenjs._db_instance.call(null,conn,ledger,inst_77231);
var inst_77233 = resolve.call(null,inst_77232);
var ___$1 = (function (){var statearr_77242 = state_77238;
(statearr_77242[(4)] = cljs.core.rest.call(null,(state_77238[(4)])));

return statearr_77242;
})();
var state_77238__$1 = state_77238;
var statearr_77243_77259 = state_77238__$1;
(statearr_77243_77259[(2)] = inst_77233);

(statearr_77243_77259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77239 === (3))){
var inst_77236 = (state_77238[(2)]);
var state_77238__$1 = state_77238;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77238__$1,inst_77236);
} else {
if((state_val_77239 === (4))){
var inst_77220 = (state_77238[(2)]);
var inst_77221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77222 = [inst_77220];
var inst_77223 = (new cljs.core.PersistentVector(null,1,(5),inst_77221,inst_77222,null));
var inst_77224 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77223);
var inst_77225 = reject.call(null,inst_77220);
var state_77238__$1 = (function (){var statearr_77245 = state_77238;
(statearr_77245[(7)] = inst_77224);

return statearr_77245;
})();
var statearr_77246_77260 = state_77238__$1;
(statearr_77246_77260[(2)] = inst_77225);

(statearr_77246_77260[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77239 === (5))){
var _ = (function (){var statearr_77247 = state_77238;
(statearr_77247[(4)] = cljs.core.rest.call(null,(state_77238[(4)])));

return statearr_77247;
})();
var state_77238__$1 = state_77238;
var ex77244 = (state_77238__$1[(2)]);
var statearr_77248_77261 = state_77238__$1;
(statearr_77248_77261[(5)] = ex77244);


var statearr_77249_77262 = state_77238__$1;
(statearr_77249_77262[(1)] = (4));

(statearr_77249_77262[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_77250 = [null,null,null,null,null,null,null,null];
(statearr_77250[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_77250[(1)] = (1));

return statearr_77250;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_77238){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77238);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77251){var ex__2749__auto__ = e77251;
var statearr_77252_77263 = state_77238;
(statearr_77252_77263[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77238[(4)]))){
var statearr_77253_77264 = state_77238;
(statearr_77253_77264[(1)] = cljs.core.first.call(null,(state_77238[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77265 = state_77238;
state_77238 = G__77265;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_77238){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_77238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77254 = f__2769__auto__.call(null);
(statearr_77254[(6)] = c__2768__auto__);

return statearr_77254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq77213){
var G__77214 = cljs.core.first.call(null,seq77213);
var seq77213__$1 = cljs.core.next.call(null,seq77213);
var G__77215 = cljs.core.first.call(null,seq77213__$1);
var seq77213__$2 = cljs.core.next.call(null,seq77213__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__77214,G__77215,seq77213__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *   If collection doesn't exist, returns nil.
 */
flureenjs.collectionId = (function flureenjs$collectionId(db,collection){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77288){
var state_val_77289 = (state_77288[(1)]);
if((state_val_77289 === (1))){
var state_77288__$1 = state_77288;
var statearr_77290_77306 = state_77288__$1;
(statearr_77290_77306[(2)] = null);

(statearr_77290_77306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77289 === (2))){
var _ = (function (){var statearr_77291 = state_77288;
(statearr_77291[(4)] = cljs.core.cons.call(null,(5),(state_77288[(4)])));

return statearr_77291;
})();
var inst_77277 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_77288__$1 = (function (){var statearr_77292 = state_77288;
(statearr_77292[(7)] = inst_77277);

return statearr_77292;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77288__$1,(6),db);
} else {
if((state_val_77289 === (3))){
var inst_77286 = (state_77288[(2)]);
var state_77288__$1 = state_77288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77288__$1,inst_77286);
} else {
if((state_val_77289 === (4))){
var inst_77266 = (state_77288[(2)]);
var inst_77267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77268 = [inst_77266];
var inst_77269 = (new cljs.core.PersistentVector(null,1,(5),inst_77267,inst_77268,null));
var inst_77270 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77269);
var inst_77271 = reject.call(null,inst_77266);
var state_77288__$1 = (function (){var statearr_77294 = state_77288;
(statearr_77294[(8)] = inst_77270);

return statearr_77294;
})();
var statearr_77295_77307 = state_77288__$1;
(statearr_77295_77307[(2)] = inst_77271);

(statearr_77295_77307[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77289 === (5))){
var _ = (function (){var statearr_77296 = state_77288;
(statearr_77296[(4)] = cljs.core.rest.call(null,(state_77288[(4)])));

return statearr_77296;
})();
var state_77288__$1 = state_77288;
var ex77293 = (state_77288__$1[(2)]);
var statearr_77297_77308 = state_77288__$1;
(statearr_77297_77308[(5)] = ex77293);


var statearr_77298_77309 = state_77288__$1;
(statearr_77298_77309[(1)] = (4));

(statearr_77298_77309[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77289 === (6))){
var inst_77277 = (state_77288[(7)]);
var inst_77279 = (state_77288[(2)]);
var inst_77280 = fluree.db.util.async.throw_err.call(null,inst_77279);
var inst_77281 = fluree.db.dbproto._c_prop.call(null,inst_77280,new cljs.core.Keyword(null,"id","id",-1388402092),inst_77277);
var inst_77282 = cljs.core.clj__GT_js.call(null,inst_77281);
var inst_77283 = resolve.call(null,inst_77282);
var _ = (function (){var statearr_77299 = state_77288;
(statearr_77299[(4)] = cljs.core.rest.call(null,(state_77288[(4)])));

return statearr_77299;
})();
var state_77288__$1 = state_77288;
var statearr_77300_77310 = state_77288__$1;
(statearr_77300_77310[(2)] = inst_77283);

(statearr_77300_77310[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionId_$_state_machine__2746__auto__ = null;
var flureenjs$collectionId_$_state_machine__2746__auto____0 = (function (){
var statearr_77301 = [null,null,null,null,null,null,null,null,null];
(statearr_77301[(0)] = flureenjs$collectionId_$_state_machine__2746__auto__);

(statearr_77301[(1)] = (1));

return statearr_77301;
});
var flureenjs$collectionId_$_state_machine__2746__auto____1 = (function (state_77288){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77302){var ex__2749__auto__ = e77302;
var statearr_77303_77311 = state_77288;
(statearr_77303_77311[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77288[(4)]))){
var statearr_77304_77312 = state_77288;
(statearr_77304_77312[(1)] = cljs.core.first.call(null,(state_77288[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77313 = state_77288;
state_77288 = G__77313;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$collectionId_$_state_machine__2746__auto__ = function(state_77288){
switch(arguments.length){
case 0:
return flureenjs$collectionId_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$collectionId_$_state_machine__2746__auto____1.call(this,state_77288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionId_$_state_machine__2746__auto____0;
flureenjs$collectionId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionId_$_state_machine__2746__auto____1;
return flureenjs$collectionId_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77305 = f__2769__auto__.call(null);
(statearr_77305[(6)] = c__2768__auto__);

return statearr_77305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionId', flureenjs.collectionId);
/**
 * Returns promise containing predicate id given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicateId = (function flureenjs$predicateId(db,predicate){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77336){
var state_val_77337 = (state_77336[(1)]);
if((state_val_77337 === (1))){
var state_77336__$1 = state_77336;
var statearr_77338_77354 = state_77336__$1;
(statearr_77338_77354[(2)] = null);

(statearr_77338_77354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77337 === (2))){
var _ = (function (){var statearr_77339 = state_77336;
(statearr_77339[(4)] = cljs.core.cons.call(null,(5),(state_77336[(4)])));

return statearr_77339;
})();
var inst_77325 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_77336__$1 = (function (){var statearr_77340 = state_77336;
(statearr_77340[(7)] = inst_77325);

return statearr_77340;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77336__$1,(6),db);
} else {
if((state_val_77337 === (3))){
var inst_77334 = (state_77336[(2)]);
var state_77336__$1 = state_77336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77336__$1,inst_77334);
} else {
if((state_val_77337 === (4))){
var inst_77314 = (state_77336[(2)]);
var inst_77315 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77316 = [inst_77314];
var inst_77317 = (new cljs.core.PersistentVector(null,1,(5),inst_77315,inst_77316,null));
var inst_77318 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77317);
var inst_77319 = reject.call(null,inst_77314);
var state_77336__$1 = (function (){var statearr_77342 = state_77336;
(statearr_77342[(8)] = inst_77318);

return statearr_77342;
})();
var statearr_77343_77355 = state_77336__$1;
(statearr_77343_77355[(2)] = inst_77319);

(statearr_77343_77355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77337 === (5))){
var _ = (function (){var statearr_77344 = state_77336;
(statearr_77344[(4)] = cljs.core.rest.call(null,(state_77336[(4)])));

return statearr_77344;
})();
var state_77336__$1 = state_77336;
var ex77341 = (state_77336__$1[(2)]);
var statearr_77345_77356 = state_77336__$1;
(statearr_77345_77356[(5)] = ex77341);


var statearr_77346_77357 = state_77336__$1;
(statearr_77346_77357[(1)] = (4));

(statearr_77346_77357[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77337 === (6))){
var inst_77325 = (state_77336[(7)]);
var inst_77327 = (state_77336[(2)]);
var inst_77328 = fluree.db.util.async.throw_err.call(null,inst_77327);
var inst_77329 = fluree.db.dbproto._p_prop.call(null,inst_77328,new cljs.core.Keyword(null,"id","id",-1388402092),inst_77325);
var inst_77330 = cljs.core.clj__GT_js.call(null,inst_77329);
var inst_77331 = resolve.call(null,inst_77330);
var _ = (function (){var statearr_77347 = state_77336;
(statearr_77347[(4)] = cljs.core.rest.call(null,(state_77336[(4)])));

return statearr_77347;
})();
var state_77336__$1 = state_77336;
var statearr_77348_77358 = state_77336__$1;
(statearr_77348_77358[(2)] = inst_77331);

(statearr_77348_77358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateId_$_state_machine__2746__auto__ = null;
var flureenjs$predicateId_$_state_machine__2746__auto____0 = (function (){
var statearr_77349 = [null,null,null,null,null,null,null,null,null];
(statearr_77349[(0)] = flureenjs$predicateId_$_state_machine__2746__auto__);

(statearr_77349[(1)] = (1));

return statearr_77349;
});
var flureenjs$predicateId_$_state_machine__2746__auto____1 = (function (state_77336){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77350){var ex__2749__auto__ = e77350;
var statearr_77351_77359 = state_77336;
(statearr_77351_77359[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77336[(4)]))){
var statearr_77352_77360 = state_77336;
(statearr_77352_77360[(1)] = cljs.core.first.call(null,(state_77336[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77361 = state_77336;
state_77336 = G__77361;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$predicateId_$_state_machine__2746__auto__ = function(state_77336){
switch(arguments.length){
case 0:
return flureenjs$predicateId_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$predicateId_$_state_machine__2746__auto____1.call(this,state_77336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateId_$_state_machine__2746__auto____0;
flureenjs$predicateId_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateId_$_state_machine__2746__auto____1;
return flureenjs$predicateId_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77353 = f__2769__auto__.call(null);
(statearr_77353[(6)] = c__2768__auto__);

return statearr_77353;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateId', flureenjs.predicateId);
/**
 * Returns promise containing predicate name given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicateName = (function flureenjs$predicateName(db,predicate){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77384){
var state_val_77385 = (state_77384[(1)]);
if((state_val_77385 === (1))){
var state_77384__$1 = state_77384;
var statearr_77386_77402 = state_77384__$1;
(statearr_77386_77402[(2)] = null);

(statearr_77386_77402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77385 === (2))){
var _ = (function (){var statearr_77387 = state_77384;
(statearr_77387[(4)] = cljs.core.cons.call(null,(5),(state_77384[(4)])));

return statearr_77387;
})();
var inst_77373 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_77384__$1 = (function (){var statearr_77388 = state_77384;
(statearr_77388[(7)] = inst_77373);

return statearr_77388;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77384__$1,(6),db);
} else {
if((state_val_77385 === (3))){
var inst_77382 = (state_77384[(2)]);
var state_77384__$1 = state_77384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77384__$1,inst_77382);
} else {
if((state_val_77385 === (4))){
var inst_77362 = (state_77384[(2)]);
var inst_77363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77364 = [inst_77362];
var inst_77365 = (new cljs.core.PersistentVector(null,1,(5),inst_77363,inst_77364,null));
var inst_77366 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77365);
var inst_77367 = reject.call(null,inst_77362);
var state_77384__$1 = (function (){var statearr_77390 = state_77384;
(statearr_77390[(8)] = inst_77366);

return statearr_77390;
})();
var statearr_77391_77403 = state_77384__$1;
(statearr_77391_77403[(2)] = inst_77367);

(statearr_77391_77403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77385 === (5))){
var _ = (function (){var statearr_77392 = state_77384;
(statearr_77392[(4)] = cljs.core.rest.call(null,(state_77384[(4)])));

return statearr_77392;
})();
var state_77384__$1 = state_77384;
var ex77389 = (state_77384__$1[(2)]);
var statearr_77393_77404 = state_77384__$1;
(statearr_77393_77404[(5)] = ex77389);


var statearr_77394_77405 = state_77384__$1;
(statearr_77394_77405[(1)] = (4));

(statearr_77394_77405[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77385 === (6))){
var inst_77373 = (state_77384[(7)]);
var inst_77375 = (state_77384[(2)]);
var inst_77376 = fluree.db.util.async.throw_err.call(null,inst_77375);
var inst_77377 = fluree.db.dbproto._p_prop.call(null,inst_77376,new cljs.core.Keyword(null,"name","name",1843675177),inst_77373);
var inst_77378 = cljs.core.clj__GT_js.call(null,inst_77377);
var inst_77379 = resolve.call(null,inst_77378);
var _ = (function (){var statearr_77395 = state_77384;
(statearr_77395[(4)] = cljs.core.rest.call(null,(state_77384[(4)])));

return statearr_77395;
})();
var state_77384__$1 = state_77384;
var statearr_77396_77406 = state_77384__$1;
(statearr_77396_77406[(2)] = inst_77379);

(statearr_77396_77406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicateName_$_state_machine__2746__auto__ = null;
var flureenjs$predicateName_$_state_machine__2746__auto____0 = (function (){
var statearr_77397 = [null,null,null,null,null,null,null,null,null];
(statearr_77397[(0)] = flureenjs$predicateName_$_state_machine__2746__auto__);

(statearr_77397[(1)] = (1));

return statearr_77397;
});
var flureenjs$predicateName_$_state_machine__2746__auto____1 = (function (state_77384){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77398){var ex__2749__auto__ = e77398;
var statearr_77399_77407 = state_77384;
(statearr_77399_77407[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77384[(4)]))){
var statearr_77400_77408 = state_77384;
(statearr_77400_77408[(1)] = cljs.core.first.call(null,(state_77384[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77409 = state_77384;
state_77384 = G__77409;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$predicateName_$_state_machine__2746__auto__ = function(state_77384){
switch(arguments.length){
case 0:
return flureenjs$predicateName_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$predicateName_$_state_machine__2746__auto____1.call(this,state_77384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicateName_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicateName_$_state_machine__2746__auto____0;
flureenjs$predicateName_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicateName_$_state_machine__2746__auto____1;
return flureenjs$predicateName_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77401 = f__2769__auto__.call(null);
(statearr_77401[(6)] = c__2768__auto__);

return statearr_77401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.predicateName', flureenjs.predicateName);
/**
 * Returns promise containing subject id given a subject
 *   identity or a subject id.
 *   If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77435){
var state_val_77436 = (state_77435[(1)]);
if((state_val_77436 === (1))){
var state_77435__$1 = state_77435;
var statearr_77437_77453 = state_77435__$1;
(statearr_77437_77453[(2)] = null);

(statearr_77437_77453[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77436 === (2))){
var _ = (function (){var statearr_77438 = state_77435;
(statearr_77438[(4)] = cljs.core.cons.call(null,(5),(state_77435[(4)])));

return statearr_77438;
})();
var inst_77421 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_77435__$1 = (function (){var statearr_77439 = state_77435;
(statearr_77439[(7)] = inst_77421);

return statearr_77439;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77435__$1,(7),db);
} else {
if((state_val_77436 === (3))){
var inst_77433 = (state_77435[(2)]);
var state_77435__$1 = state_77435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77435__$1,inst_77433);
} else {
if((state_val_77436 === (4))){
var inst_77410 = (state_77435[(2)]);
var inst_77411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77412 = [inst_77410];
var inst_77413 = (new cljs.core.PersistentVector(null,1,(5),inst_77411,inst_77412,null));
var inst_77414 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77413);
var inst_77415 = reject.call(null,inst_77410);
var state_77435__$1 = (function (){var statearr_77441 = state_77435;
(statearr_77441[(8)] = inst_77414);

return statearr_77441;
})();
var statearr_77442_77454 = state_77435__$1;
(statearr_77442_77454[(2)] = inst_77415);

(statearr_77442_77454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77436 === (5))){
var _ = (function (){var statearr_77443 = state_77435;
(statearr_77443[(4)] = cljs.core.rest.call(null,(state_77435[(4)])));

return statearr_77443;
})();
var state_77435__$1 = state_77435;
var ex77440 = (state_77435__$1[(2)]);
var statearr_77444_77455 = state_77435__$1;
(statearr_77444_77455[(5)] = ex77440);


var statearr_77445_77456 = state_77435__$1;
(statearr_77445_77456[(1)] = (4));

(statearr_77445_77456[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77436 === (6))){
var inst_77427 = (state_77435[(2)]);
var inst_77428 = fluree.db.util.async.throw_err.call(null,inst_77427);
var inst_77429 = cljs.core.clj__GT_js.call(null,inst_77428);
var inst_77430 = resolve.call(null,inst_77429);
var _ = (function (){var statearr_77446 = state_77435;
(statearr_77446[(4)] = cljs.core.rest.call(null,(state_77435[(4)])));

return statearr_77446;
})();
var state_77435__$1 = state_77435;
var statearr_77447_77457 = state_77435__$1;
(statearr_77447_77457[(2)] = inst_77430);

(statearr_77447_77457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77436 === (7))){
var inst_77421 = (state_77435[(7)]);
var inst_77423 = (state_77435[(2)]);
var inst_77424 = fluree.db.util.async.throw_err.call(null,inst_77423);
var inst_77425 = fluree.db.dbproto._subid.call(null,inst_77424,inst_77421,false);
var state_77435__$1 = state_77435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77435__$1,(6),inst_77425);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__2746__auto__ = null;
var flureenjs$subid_$_state_machine__2746__auto____0 = (function (){
var statearr_77448 = [null,null,null,null,null,null,null,null,null];
(statearr_77448[(0)] = flureenjs$subid_$_state_machine__2746__auto__);

(statearr_77448[(1)] = (1));

return statearr_77448;
});
var flureenjs$subid_$_state_machine__2746__auto____1 = (function (state_77435){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77449){var ex__2749__auto__ = e77449;
var statearr_77450_77458 = state_77435;
(statearr_77450_77458[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77435[(4)]))){
var statearr_77451_77459 = state_77435;
(statearr_77451_77459[(1)] = cljs.core.first.call(null,(state_77435[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77460 = state_77435;
state_77435 = G__77460;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__2746__auto__ = function(state_77435){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__2746__auto____1.call(this,state_77435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__2746__auto____0;
flureenjs$subid_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__2746__auto____1;
return flureenjs$subid_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77452 = f__2769__auto__.call(null);
(statearr_77452[(6)] = c__2768__auto__);

return statearr_77452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.deleteLedger = (function flureenjs$deleteLedger(var_args){
var G__77462 = arguments.length;
switch (G__77462) {
case 2:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.deleteLedger', flureenjs.deleteLedger);

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.deleteLedger.call(null,conn,ledger,null);
}));

(flureenjs.deleteLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77535){
var state_val_77536 = (state_77535[(1)]);
if((state_val_77536 === (7))){
var inst_77478 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_77535__$1 = state_77535;
var statearr_77537_77582 = state_77535__$1;
(statearr_77537_77582[(2)] = inst_77478);

(statearr_77537_77582[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (20))){
var inst_77486 = (state_77535[(7)]);
var inst_77510 = (state_77535[(2)]);
var state_77535__$1 = (function (){var statearr_77538 = state_77535;
(statearr_77538[(8)] = inst_77510);

return statearr_77538;
})();
if(cljs.core.truth_(inst_77486)){
var statearr_77539_77583 = state_77535__$1;
(statearr_77539_77583[(1)] = (21));

} else {
var statearr_77540_77584 = state_77535__$1;
(statearr_77540_77584[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (1))){
var state_77535__$1 = state_77535;
var statearr_77541_77585 = state_77535__$1;
(statearr_77541_77585[(2)] = null);

(statearr_77541_77585[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (24))){
var inst_77517 = (state_77535[(2)]);
var inst_77518 = fluree.db.util.async.throw_err.call(null,inst_77517);
var state_77535__$1 = state_77535;
var statearr_77542_77586 = state_77535__$1;
(statearr_77542_77586[(2)] = inst_77518);

(statearr_77542_77586[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (4))){
var inst_77463 = (state_77535[(2)]);
var inst_77464 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77465 = [inst_77463];
var inst_77466 = (new cljs.core.PersistentVector(null,1,(5),inst_77464,inst_77465,null));
var inst_77467 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77466);
var inst_77468 = reject.call(null,inst_77463);
var state_77535__$1 = (function (){var statearr_77543 = state_77535;
(statearr_77543[(9)] = inst_77467);

return statearr_77543;
})();
var statearr_77544_77587 = state_77535__$1;
(statearr_77544_77587[(2)] = inst_77468);

(statearr_77544_77587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (15))){
var inst_77499 = (state_77535[(10)]);
var inst_77501 = fluree.db.util.core.without_nils.call(null,inst_77499);
var inst_77502 = fluree.db.util.json.stringify.call(null,inst_77501);
var state_77535__$1 = state_77535;
var statearr_77545_77588 = state_77535__$1;
(statearr_77545_77588[(2)] = inst_77502);

(statearr_77545_77588[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (21))){
var inst_77510 = (state_77535[(8)]);
var inst_77505 = (state_77535[(11)]);
var inst_77512 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_77513 = [inst_77505,inst_77510];
var inst_77514 = cljs.core.PersistentHashMap.fromArrays(inst_77512,inst_77513);
var inst_77515 = fluree.db.operations.command_async.call(null,conn,inst_77514);
var state_77535__$1 = state_77535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77535__$1,(24),inst_77515);
} else {
if((state_val_77536 === (13))){
var inst_77487 = (state_77535[(12)]);
var inst_77494 = (inst_77487 + (30000));
var state_77535__$1 = state_77535;
var statearr_77546_77589 = state_77535__$1;
(statearr_77546_77589[(2)] = inst_77494);

(statearr_77546_77589[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (22))){
var inst_77499 = (state_77535[(10)]);
var inst_77520 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_77499);
var state_77535__$1 = state_77535;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77535__$1,(25),inst_77520);
} else {
if((state_val_77536 === (6))){
var state_77535__$1 = state_77535;
var statearr_77547_77590 = state_77535__$1;
(statearr_77547_77590[(2)] = null);

(statearr_77547_77590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (25))){
var inst_77522 = (state_77535[(2)]);
var inst_77523 = fluree.db.util.async.throw_err.call(null,inst_77522);
var state_77535__$1 = state_77535;
var statearr_77548_77591 = state_77535__$1;
(statearr_77548_77591[(2)] = inst_77523);

(statearr_77548_77591[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (17))){
var inst_77486 = (state_77535[(7)]);
var inst_77505 = (state_77535[(2)]);
var state_77535__$1 = (function (){var statearr_77549 = state_77535;
(statearr_77549[(11)] = inst_77505);

return statearr_77549;
})();
if(cljs.core.truth_(inst_77486)){
var statearr_77550_77592 = state_77535__$1;
(statearr_77550_77592[(1)] = (18));

} else {
var statearr_77551_77593 = state_77535__$1;
(statearr_77551_77593[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (3))){
var inst_77533 = (state_77535[(2)]);
var state_77535__$1 = state_77535;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77535__$1,inst_77533);
} else {
if((state_val_77536 === (12))){
var inst_77484 = (state_77535[(13)]);
var state_77535__$1 = state_77535;
var statearr_77552_77594 = state_77535__$1;
(statearr_77552_77594[(2)] = inst_77484);

(statearr_77552_77594[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (2))){
var _ = (function (){var statearr_77553 = state_77535;
(statearr_77553[(4)] = cljs.core.cons.call(null,(5),(state_77535[(4)])));

return statearr_77553;
})();
var inst_77475 = (opts == null);
var state_77535__$1 = state_77535;
if(cljs.core.truth_(inst_77475)){
var statearr_77554_77595 = state_77535__$1;
(statearr_77554_77595[(1)] = (6));

} else {
var statearr_77555_77596 = state_77535__$1;
(statearr_77555_77596[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (23))){
var inst_77525 = (state_77535[(2)]);
var inst_77526 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_77527 = [(200),inst_77525];
var inst_77528 = cljs.core.PersistentHashMap.fromArrays(inst_77526,inst_77527);
var inst_77529 = cljs.core.clj__GT_js.call(null,inst_77528);
var inst_77530 = resolve.call(null,inst_77529);
var _ = (function (){var statearr_77556 = state_77535;
(statearr_77556[(4)] = cljs.core.rest.call(null,(state_77535[(4)])));

return statearr_77556;
})();
var state_77535__$1 = state_77535;
var statearr_77557_77597 = state_77535__$1;
(statearr_77557_77597[(2)] = inst_77530);

(statearr_77557_77597[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (19))){
var state_77535__$1 = state_77535;
var statearr_77558_77598 = state_77535__$1;
(statearr_77558_77598[(2)] = null);

(statearr_77558_77598[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (11))){
var inst_77484 = (state_77535[(13)]);
var inst_77491 = (state_77535[(2)]);
var state_77535__$1 = (function (){var statearr_77560 = state_77535;
(statearr_77560[(14)] = inst_77491);

return statearr_77560;
})();
if(cljs.core.truth_(inst_77484)){
var statearr_77561_77599 = state_77535__$1;
(statearr_77561_77599[(1)] = (12));

} else {
var statearr_77562_77600 = state_77535__$1;
(statearr_77562_77600[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (9))){
var inst_77483 = (state_77535[(15)]);
var state_77535__$1 = state_77535;
var statearr_77563_77601 = state_77535__$1;
(statearr_77563_77601[(2)] = inst_77483);

(statearr_77563_77601[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (5))){
var _ = (function (){var statearr_77564 = state_77535;
(statearr_77564[(4)] = cljs.core.rest.call(null,(state_77535[(4)])));

return statearr_77564;
})();
var state_77535__$1 = state_77535;
var ex77559 = (state_77535__$1[(2)]);
var statearr_77565_77602 = state_77535__$1;
(statearr_77565_77602[(5)] = ex77559);


var statearr_77566_77603 = state_77535__$1;
(statearr_77566_77603[(1)] = (4));

(statearr_77566_77603[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (14))){
var inst_77491 = (state_77535[(14)]);
var inst_77486 = (state_77535[(7)]);
var inst_77496 = (state_77535[(2)]);
var inst_77497 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_77498 = [new cljs.core.Keyword(null,"delete-ledger","delete-ledger",-264475890),ledger,inst_77491,inst_77496];
var inst_77499 = cljs.core.PersistentHashMap.fromArrays(inst_77497,inst_77498);
var state_77535__$1 = (function (){var statearr_77567 = state_77535;
(statearr_77567[(10)] = inst_77499);

return statearr_77567;
})();
if(cljs.core.truth_(inst_77486)){
var statearr_77568_77604 = state_77535__$1;
(statearr_77568_77604[(1)] = (15));

} else {
var statearr_77569_77605 = state_77535__$1;
(statearr_77569_77605[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (16))){
var state_77535__$1 = state_77535;
var statearr_77570_77606 = state_77535__$1;
(statearr_77570_77606[(2)] = null);

(statearr_77570_77606[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (10))){
var inst_77487 = (state_77535[(12)]);
var state_77535__$1 = state_77535;
var statearr_77571_77607 = state_77535__$1;
(statearr_77571_77607[(2)] = inst_77487);

(statearr_77571_77607[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (18))){
var inst_77505 = (state_77535[(11)]);
var inst_77486 = (state_77535[(7)]);
var inst_77507 = fluree.crypto.sign_message.call(null,inst_77505,inst_77486);
var state_77535__$1 = state_77535;
var statearr_77572_77608 = state_77535__$1;
(statearr_77572_77608[(2)] = inst_77507);

(statearr_77572_77608[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77536 === (8))){
var inst_77483 = (state_77535[(15)]);
var inst_77480 = (state_77535[(2)]);
var inst_77481 = fluree.db.connection_js.check_connection.call(null,conn,inst_77480);
var inst_77482 = cljs.core.__destructure_map.call(null,inst_77480);
var inst_77483__$1 = cljs.core.get.call(null,inst_77482,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_77484 = cljs.core.get.call(null,inst_77482,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_77485 = cljs.core.get.call(null,inst_77482,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_77486 = cljs.core.get.call(null,inst_77482,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_77487 = fluree.db.util.core.current_time_millis.call(null);
var state_77535__$1 = (function (){var statearr_77573 = state_77535;
(statearr_77573[(13)] = inst_77484);

(statearr_77573[(15)] = inst_77483__$1);

(statearr_77573[(12)] = inst_77487);

(statearr_77573[(16)] = inst_77481);

(statearr_77573[(7)] = inst_77486);

(statearr_77573[(17)] = inst_77485);

return statearr_77573;
})();
if(cljs.core.truth_(inst_77483__$1)){
var statearr_77574_77609 = state_77535__$1;
(statearr_77574_77609[(1)] = (9));

} else {
var statearr_77575_77610 = state_77535__$1;
(statearr_77575_77610[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_77576 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77576[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_77576[(1)] = (1));

return statearr_77576;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_77535){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77535);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77577){var ex__2749__auto__ = e77577;
var statearr_77578_77611 = state_77535;
(statearr_77578_77611[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77535[(4)]))){
var statearr_77579_77612 = state_77535;
(statearr_77579_77612[(1)] = cljs.core.first.call(null,(state_77535[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77613 = state_77535;
state_77535 = G__77613;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_77535){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_77535);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77580 = f__2769__auto__.call(null);
(statearr_77580[(6)] = c__2768__auto__);

return statearr_77580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.deleteLedger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledgerInfo = (function flureenjs$ledgerInfo(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77635){
var state_val_77636 = (state_77635[(1)]);
if((state_val_77636 === (1))){
var state_77635__$1 = state_77635;
var statearr_77637_77652 = state_77635__$1;
(statearr_77637_77652[(2)] = null);

(statearr_77637_77652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77636 === (2))){
var _ = (function (){var statearr_77638 = state_77635;
(statearr_77638[(4)] = cljs.core.cons.call(null,(5),(state_77635[(4)])));

return statearr_77638;
})();
var inst_77625 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_77635__$1 = state_77635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77635__$1,(6),inst_77625);
} else {
if((state_val_77636 === (3))){
var inst_77633 = (state_77635[(2)]);
var state_77635__$1 = state_77635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77635__$1,inst_77633);
} else {
if((state_val_77636 === (4))){
var inst_77614 = (state_77635[(2)]);
var inst_77615 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77616 = [inst_77614];
var inst_77617 = (new cljs.core.PersistentVector(null,1,(5),inst_77615,inst_77616,null));
var inst_77618 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77617);
var inst_77619 = reject.call(null,inst_77614);
var state_77635__$1 = (function (){var statearr_77640 = state_77635;
(statearr_77640[(7)] = inst_77618);

return statearr_77640;
})();
var statearr_77641_77653 = state_77635__$1;
(statearr_77641_77653[(2)] = inst_77619);

(statearr_77641_77653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77636 === (5))){
var _ = (function (){var statearr_77642 = state_77635;
(statearr_77642[(4)] = cljs.core.rest.call(null,(state_77635[(4)])));

return statearr_77642;
})();
var state_77635__$1 = state_77635;
var ex77639 = (state_77635__$1[(2)]);
var statearr_77643_77654 = state_77635__$1;
(statearr_77643_77654[(5)] = ex77639);


var statearr_77644_77655 = state_77635__$1;
(statearr_77644_77655[(1)] = (4));

(statearr_77644_77655[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77636 === (6))){
var inst_77627 = (state_77635[(2)]);
var inst_77628 = fluree.db.util.async.throw_err.call(null,inst_77627);
var inst_77629 = cljs.core.clj__GT_js.call(null,inst_77628);
var inst_77630 = resolve.call(null,inst_77629);
var _ = (function (){var statearr_77645 = state_77635;
(statearr_77645[(4)] = cljs.core.rest.call(null,(state_77635[(4)])));

return statearr_77645;
})();
var state_77635__$1 = state_77635;
var statearr_77646_77656 = state_77635__$1;
(statearr_77646_77656[(2)] = inst_77630);

(statearr_77646_77656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerInfo_$_state_machine__2746__auto__ = null;
var flureenjs$ledgerInfo_$_state_machine__2746__auto____0 = (function (){
var statearr_77647 = [null,null,null,null,null,null,null,null];
(statearr_77647[(0)] = flureenjs$ledgerInfo_$_state_machine__2746__auto__);

(statearr_77647[(1)] = (1));

return statearr_77647;
});
var flureenjs$ledgerInfo_$_state_machine__2746__auto____1 = (function (state_77635){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77648){var ex__2749__auto__ = e77648;
var statearr_77649_77657 = state_77635;
(statearr_77649_77657[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77635[(4)]))){
var statearr_77650_77658 = state_77635;
(statearr_77650_77658[(1)] = cljs.core.first.call(null,(state_77635[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77659 = state_77635;
state_77635 = G__77659;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$ledgerInfo_$_state_machine__2746__auto__ = function(state_77635){
switch(arguments.length){
case 0:
return flureenjs$ledgerInfo_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$ledgerInfo_$_state_machine__2746__auto____1.call(this,state_77635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerInfo_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerInfo_$_state_machine__2746__auto____0;
flureenjs$ledgerInfo_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerInfo_$_state_machine__2746__auto____1;
return flureenjs$ledgerInfo_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77651 = f__2769__auto__.call(null);
(statearr_77651[(6)] = c__2768__auto__);

return statearr_77651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerInfo', flureenjs.ledgerInfo);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledgerList = (function flureenjs$ledgerList(conn){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77681){
var state_val_77682 = (state_77681[(1)]);
if((state_val_77682 === (1))){
var state_77681__$1 = state_77681;
var statearr_77683_77698 = state_77681__$1;
(statearr_77683_77698[(2)] = null);

(statearr_77683_77698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77682 === (2))){
var _ = (function (){var statearr_77684 = state_77681;
(statearr_77684[(4)] = cljs.core.cons.call(null,(5),(state_77681[(4)])));

return statearr_77684;
})();
var inst_77671 = fluree.db.operations.ledgers_async.call(null,conn);
var state_77681__$1 = state_77681;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77681__$1,(6),inst_77671);
} else {
if((state_val_77682 === (3))){
var inst_77679 = (state_77681[(2)]);
var state_77681__$1 = state_77681;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77681__$1,inst_77679);
} else {
if((state_val_77682 === (4))){
var inst_77660 = (state_77681[(2)]);
var inst_77661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77662 = [inst_77660];
var inst_77663 = (new cljs.core.PersistentVector(null,1,(5),inst_77661,inst_77662,null));
var inst_77664 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77663);
var inst_77665 = reject.call(null,inst_77660);
var state_77681__$1 = (function (){var statearr_77686 = state_77681;
(statearr_77686[(7)] = inst_77664);

return statearr_77686;
})();
var statearr_77687_77699 = state_77681__$1;
(statearr_77687_77699[(2)] = inst_77665);

(statearr_77687_77699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77682 === (5))){
var _ = (function (){var statearr_77688 = state_77681;
(statearr_77688[(4)] = cljs.core.rest.call(null,(state_77681[(4)])));

return statearr_77688;
})();
var state_77681__$1 = state_77681;
var ex77685 = (state_77681__$1[(2)]);
var statearr_77689_77700 = state_77681__$1;
(statearr_77689_77700[(5)] = ex77685);


var statearr_77690_77701 = state_77681__$1;
(statearr_77690_77701[(1)] = (4));

(statearr_77690_77701[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77682 === (6))){
var inst_77673 = (state_77681[(2)]);
var inst_77674 = fluree.db.util.async.throw_err.call(null,inst_77673);
var inst_77675 = cljs.core.clj__GT_js.call(null,inst_77674);
var inst_77676 = resolve.call(null,inst_77675);
var _ = (function (){var statearr_77691 = state_77681;
(statearr_77691[(4)] = cljs.core.rest.call(null,(state_77681[(4)])));

return statearr_77691;
})();
var state_77681__$1 = state_77681;
var statearr_77692_77702 = state_77681__$1;
(statearr_77692_77702[(2)] = inst_77676);

(statearr_77692_77702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledgerList_$_state_machine__2746__auto__ = null;
var flureenjs$ledgerList_$_state_machine__2746__auto____0 = (function (){
var statearr_77693 = [null,null,null,null,null,null,null,null];
(statearr_77693[(0)] = flureenjs$ledgerList_$_state_machine__2746__auto__);

(statearr_77693[(1)] = (1));

return statearr_77693;
});
var flureenjs$ledgerList_$_state_machine__2746__auto____1 = (function (state_77681){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77681);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77694){var ex__2749__auto__ = e77694;
var statearr_77695_77703 = state_77681;
(statearr_77695_77703[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77681[(4)]))){
var statearr_77696_77704 = state_77681;
(statearr_77696_77704[(1)] = cljs.core.first.call(null,(state_77681[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77705 = state_77681;
state_77681 = G__77705;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$ledgerList_$_state_machine__2746__auto__ = function(state_77681){
switch(arguments.length){
case 0:
return flureenjs$ledgerList_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$ledgerList_$_state_machine__2746__auto____1.call(this,state_77681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledgerList_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledgerList_$_state_machine__2746__auto____0;
flureenjs$ledgerList_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledgerList_$_state_machine__2746__auto____1;
return flureenjs$ledgerList_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77697 = f__2769__auto__.call(null);
(statearr_77697[(6)] = c__2768__auto__);

return statearr_77697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.ledgerList', flureenjs.ledgerList);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than ledger-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the ledger-id, don't wait for transaction to be finished
 * 
 */
flureenjs.newLedger = (function flureenjs$newLedger(var_args){
var G__77707 = arguments.length;
switch (G__77707) {
case 2:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.newLedger', flureenjs.newLedger);

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.newLedger.call(null,conn,ledger,null);
}));

(flureenjs.newLedger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77828){
var state_val_77829 = (state_77828[(1)]);
if((state_val_77829 === (7))){
var inst_77733 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_77828__$1 = state_77828;
var statearr_77830_77895 = state_77828__$1;
(statearr_77830_77895[(2)] = inst_77733);

(statearr_77830_77895[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (20))){
var inst_77740 = (state_77828[(7)]);
var inst_77778 = (state_77828[(2)]);
var inst_77779 = fluree.db.util.core.current_time_millis.call(null);
var state_77828__$1 = (function (){var statearr_77831 = state_77828;
(statearr_77831[(8)] = inst_77778);

(statearr_77831[(9)] = inst_77779);

return statearr_77831;
})();
if(cljs.core.truth_(inst_77740)){
var statearr_77832_77896 = state_77828__$1;
(statearr_77832_77896[(1)] = (21));

} else {
var statearr_77833_77897 = state_77828__$1;
(statearr_77833_77897[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (27))){
var inst_77792 = (state_77828[(10)]);
var inst_77794 = fluree.db.util.core.without_nils.call(null,inst_77792);
var inst_77795 = fluree.db.util.json.stringify.call(null,inst_77794);
var state_77828__$1 = state_77828;
var statearr_77834_77898 = state_77828__$1;
(statearr_77834_77898[(2)] = inst_77795);

(statearr_77834_77898[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (1))){
var state_77828__$1 = state_77828;
var statearr_77835_77899 = state_77828__$1;
(statearr_77835_77899[(2)] = null);

(statearr_77835_77899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (24))){
var inst_77746 = (state_77828[(11)]);
var state_77828__$1 = state_77828;
var statearr_77836_77900 = state_77828__$1;
(statearr_77836_77900[(2)] = inst_77746);

(statearr_77836_77900[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (4))){
var inst_77708 = (state_77828[(2)]);
var inst_77709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77710 = [inst_77708];
var inst_77711 = (new cljs.core.PersistentVector(null,1,(5),inst_77709,inst_77710,null));
var inst_77712 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77711);
var inst_77713 = cljs.core.ex_data.call(null,inst_77708);
var inst_77714 = cljs.core.ex_message.call(null,inst_77708);
var inst_77715 = cljs.core.assoc.call(null,inst_77713,new cljs.core.Keyword(null,"message","message",-406056002),inst_77714);
var inst_77716 = cljs.core.clj__GT_js.call(null,inst_77715);
var inst_77717 = reject.call(null,inst_77716);
var state_77828__$1 = (function (){var statearr_77837 = state_77828;
(statearr_77837[(12)] = inst_77712);

return statearr_77837;
})();
var statearr_77838_77901 = state_77828__$1;
(statearr_77838_77901[(2)] = inst_77717);

(statearr_77838_77901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (15))){
var inst_77768 = (state_77828[(13)]);
var inst_77770 = fluree.db.graphdb.validate_ledger_name.call(null,inst_77768,"alias");
var state_77828__$1 = state_77828;
var statearr_77839_77902 = state_77828__$1;
(statearr_77839_77902[(2)] = inst_77770);

(statearr_77839_77902[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (21))){
var inst_77740 = (state_77828[(7)]);
var state_77828__$1 = state_77828;
var statearr_77840_77903 = state_77828__$1;
(statearr_77840_77903[(2)] = inst_77740);

(statearr_77840_77903[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (31))){
var state_77828__$1 = state_77828;
var statearr_77841_77904 = state_77828__$1;
(statearr_77841_77904[(2)] = null);

(statearr_77841_77904[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (32))){
var inst_77742 = (state_77828[(14)]);
var inst_77803 = (state_77828[(2)]);
var state_77828__$1 = (function (){var statearr_77842 = state_77828;
(statearr_77842[(15)] = inst_77803);

return statearr_77842;
})();
if(cljs.core.truth_(inst_77742)){
var statearr_77843_77905 = state_77828__$1;
(statearr_77843_77905[(1)] = (33));

} else {
var statearr_77844_77906 = state_77828__$1;
(statearr_77844_77906[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (33))){
var inst_77798 = (state_77828[(16)]);
var inst_77803 = (state_77828[(15)]);
var inst_77805 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_77806 = [inst_77798,inst_77803];
var inst_77807 = cljs.core.PersistentHashMap.fromArrays(inst_77805,inst_77806);
var inst_77808 = fluree.db.operations.command_async.call(null,conn,inst_77807);
var state_77828__$1 = state_77828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77828__$1,(36),inst_77808);
} else {
if((state_val_77829 === (13))){
var state_77828__$1 = state_77828;
var statearr_77845_77907 = state_77828__$1;
(statearr_77845_77907[(2)] = null);

(statearr_77845_77907[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (22))){
var inst_77779 = (state_77828[(9)]);
var state_77828__$1 = state_77828;
var statearr_77846_77908 = state_77828__$1;
(statearr_77846_77908[(2)] = inst_77779);

(statearr_77846_77908[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (36))){
var inst_77810 = (state_77828[(2)]);
var inst_77811 = fluree.db.util.async.throw_err.call(null,inst_77810);
var state_77828__$1 = state_77828;
var statearr_77847_77909 = state_77828__$1;
(statearr_77847_77909[(2)] = inst_77811);

(statearr_77847_77909[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (29))){
var inst_77742 = (state_77828[(14)]);
var inst_77798 = (state_77828[(2)]);
var state_77828__$1 = (function (){var statearr_77848 = state_77828;
(statearr_77848[(16)] = inst_77798);

return statearr_77848;
})();
if(cljs.core.truth_(inst_77742)){
var statearr_77849_77910 = state_77828__$1;
(statearr_77849_77910[(1)] = (30));

} else {
var statearr_77850_77911 = state_77828__$1;
(statearr_77850_77911[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (6))){
var state_77828__$1 = state_77828;
var statearr_77851_77912 = state_77828__$1;
(statearr_77851_77912[(2)] = null);

(statearr_77851_77912[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (28))){
var state_77828__$1 = state_77828;
var statearr_77852_77913 = state_77828__$1;
(statearr_77852_77913[(2)] = null);

(statearr_77852_77913[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (25))){
var inst_77779 = (state_77828[(9)]);
var inst_77786 = (inst_77779 + (30000));
var state_77828__$1 = state_77828;
var statearr_77853_77914 = state_77828__$1;
(statearr_77853_77914[(2)] = inst_77786);

(statearr_77853_77914[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (34))){
var inst_77792 = (state_77828[(10)]);
var inst_77813 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_77792);
var state_77828__$1 = state_77828;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_77828__$1,(37),inst_77813);
} else {
if((state_val_77829 === (17))){
var inst_77749 = (state_77828[(17)]);
var inst_77773 = (state_77828[(2)]);
var state_77828__$1 = (function (){var statearr_77854 = state_77828;
(statearr_77854[(18)] = inst_77773);

return statearr_77854;
})();
if(cljs.core.truth_(inst_77749)){
var statearr_77855_77915 = state_77828__$1;
(statearr_77855_77915[(1)] = (18));

} else {
var statearr_77856_77916 = state_77828__$1;
(statearr_77856_77916[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (3))){
var inst_77826 = (state_77828[(2)]);
var state_77828__$1 = state_77828;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77828__$1,inst_77826);
} else {
if((state_val_77829 === (12))){
var inst_77763 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_77828__$1 = state_77828;
var statearr_77857_77917 = state_77828__$1;
(statearr_77857_77917[(2)] = inst_77763);

(statearr_77857_77917[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (2))){
var _ = (function (){var statearr_77858 = state_77828;
(statearr_77858[(4)] = cljs.core.cons.call(null,(5),(state_77828[(4)])));

return statearr_77858;
})();
var inst_77730 = (opts == null);
var state_77828__$1 = state_77828;
if(cljs.core.truth_(inst_77730)){
var statearr_77859_77918 = state_77828__$1;
(statearr_77859_77918[(1)] = (6));

} else {
var statearr_77860_77919 = state_77828__$1;
(statearr_77860_77919[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (23))){
var inst_77746 = (state_77828[(11)]);
var inst_77783 = (state_77828[(2)]);
var state_77828__$1 = (function (){var statearr_77861 = state_77828;
(statearr_77861[(19)] = inst_77783);

return statearr_77861;
})();
if(cljs.core.truth_(inst_77746)){
var statearr_77862_77920 = state_77828__$1;
(statearr_77862_77920[(1)] = (24));

} else {
var statearr_77863_77921 = state_77828__$1;
(statearr_77863_77921[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (35))){
var inst_77818 = (state_77828[(2)]);
var inst_77819 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_77820 = [(200),inst_77818];
var inst_77821 = cljs.core.PersistentHashMap.fromArrays(inst_77819,inst_77820);
var inst_77822 = cljs.core.clj__GT_js.call(null,inst_77821);
var inst_77823 = resolve.call(null,inst_77822);
var _ = (function (){var statearr_77864 = state_77828;
(statearr_77864[(4)] = cljs.core.rest.call(null,(state_77828[(4)])));

return statearr_77864;
})();
var state_77828__$1 = state_77828;
var statearr_77865_77922 = state_77828__$1;
(statearr_77865_77922[(2)] = inst_77823);

(statearr_77865_77922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (19))){
var state_77828__$1 = state_77828;
var statearr_77866_77923 = state_77828__$1;
(statearr_77866_77923[(2)] = null);

(statearr_77866_77923[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (11))){
var inst_77749 = (state_77828[(17)]);
var inst_77752 = (state_77828[(20)]);
var inst_77759 = (state_77828[(21)]);
var inst_77759__$1 = (state_77828[(2)]);
var inst_77760 = fluree.db.graphdb.validate_ledger_name.call(null,inst_77759__$1,"ledger");
var inst_77761 = fluree.db.graphdb.validate_ledger_name.call(null,inst_77752,"network");
var state_77828__$1 = (function (){var statearr_77868 = state_77828;
(statearr_77868[(22)] = inst_77760);

(statearr_77868[(23)] = inst_77761);

(statearr_77868[(21)] = inst_77759__$1);

return statearr_77868;
})();
if(cljs.core.truth_(inst_77749)){
var statearr_77869_77924 = state_77828__$1;
(statearr_77869_77924[(1)] = (12));

} else {
var statearr_77870_77925 = state_77828__$1;
(statearr_77870_77925[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (9))){
var inst_77753 = (state_77828[(24)]);
var inst_77756 = cljs.core.subs.call(null,inst_77753,(1));
var state_77828__$1 = state_77828;
var statearr_77871_77926 = state_77828__$1;
(statearr_77871_77926[(2)] = inst_77756);

(statearr_77871_77926[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (5))){
var _ = (function (){var statearr_77872 = state_77828;
(statearr_77872[(4)] = cljs.core.rest.call(null,(state_77828[(4)])));

return statearr_77872;
})();
var state_77828__$1 = state_77828;
var ex77867 = (state_77828__$1[(2)]);
var statearr_77873_77927 = state_77828__$1;
(statearr_77873_77927[(5)] = ex77867);


var statearr_77874_77928 = state_77828__$1;
(statearr_77874_77928[(1)] = (4));

(statearr_77874_77928[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (14))){
var inst_77749 = (state_77828[(17)]);
var inst_77766 = (state_77828[(2)]);
var inst_77767 = cljs.core.nth.call(null,inst_77766,(0),null);
var inst_77768 = cljs.core.nth.call(null,inst_77766,(1),null);
var state_77828__$1 = (function (){var statearr_77875 = state_77828;
(statearr_77875[(25)] = inst_77767);

(statearr_77875[(13)] = inst_77768);

return statearr_77875;
})();
if(cljs.core.truth_(inst_77749)){
var statearr_77876_77929 = state_77828__$1;
(statearr_77876_77929[(1)] = (15));

} else {
var statearr_77877_77930 = state_77828__$1;
(statearr_77877_77930[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (26))){
var inst_77778 = (state_77828[(8)]);
var inst_77783 = (state_77828[(19)]);
var inst_77747 = (state_77828[(26)]);
var inst_77744 = (state_77828[(27)]);
var inst_77748 = (state_77828[(28)]);
var inst_77739 = (state_77828[(29)]);
var inst_77750 = (state_77828[(30)]);
var inst_77745 = (state_77828[(31)]);
var inst_77742 = (state_77828[(14)]);
var inst_77743 = (state_77828[(32)]);
var inst_77741 = (state_77828[(33)]);
var inst_77752 = (state_77828[(20)]);
var inst_77759 = (state_77828[(21)]);
var inst_77788 = (state_77828[(2)]);
var inst_77789 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_77790 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77752),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77759)].join('');
var inst_77791 = [inst_77790,inst_77744,inst_77745,new cljs.core.Keyword(null,"new-ledger","new-ledger",34666434),inst_77788,inst_77747,inst_77778,inst_77750,inst_77748,inst_77739,inst_77783,inst_77741,inst_77743];
var inst_77792 = cljs.core.PersistentHashMap.fromArrays(inst_77789,inst_77791);
var state_77828__$1 = (function (){var statearr_77878 = state_77828;
(statearr_77878[(10)] = inst_77792);

return statearr_77878;
})();
if(cljs.core.truth_(inst_77742)){
var statearr_77879_77931 = state_77828__$1;
(statearr_77879_77931[(1)] = (27));

} else {
var statearr_77880_77932 = state_77828__$1;
(statearr_77880_77932[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (16))){
var state_77828__$1 = state_77828;
var statearr_77881_77933 = state_77828__$1;
(statearr_77881_77933[(2)] = null);

(statearr_77881_77933[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (30))){
var inst_77742 = (state_77828[(14)]);
var inst_77798 = (state_77828[(16)]);
var inst_77800 = fluree.crypto.sign_message.call(null,inst_77798,inst_77742);
var state_77828__$1 = state_77828;
var statearr_77882_77934 = state_77828__$1;
(statearr_77882_77934[(2)] = inst_77800);

(statearr_77882_77934[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (10))){
var inst_77753 = (state_77828[(24)]);
var state_77828__$1 = state_77828;
var statearr_77883_77935 = state_77828__$1;
(statearr_77883_77935[(2)] = inst_77753);

(statearr_77883_77935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (18))){
var inst_77767 = (state_77828[(25)]);
var inst_77768 = (state_77828[(13)]);
var inst_77775 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77767),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77768)].join('');
var state_77828__$1 = state_77828;
var statearr_77884_77936 = state_77828__$1;
(statearr_77884_77936[(2)] = inst_77775);

(statearr_77884_77936[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (37))){
var inst_77815 = (state_77828[(2)]);
var inst_77816 = fluree.db.util.async.throw_err.call(null,inst_77815);
var state_77828__$1 = state_77828;
var statearr_77885_77937 = state_77828__$1;
(statearr_77885_77937[(2)] = inst_77816);

(statearr_77885_77937[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77829 === (8))){
var inst_77753 = (state_77828[(24)]);
var inst_77735 = (state_77828[(2)]);
var inst_77736 = fluree.db.connection_js.check_connection.call(null,conn,inst_77735);
var inst_77737 = cljs.core.__destructure_map.call(null,inst_77735);
var inst_77738 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_77739 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_77740 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_77741 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_77742 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_77743 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_77744 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_77745 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_77746 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_77747 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_77748 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_77749 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_77750 = cljs.core.get.call(null,inst_77737,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_77751 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_77752 = cljs.core.nth.call(null,inst_77751,(0),null);
var inst_77753__$1 = cljs.core.nth.call(null,inst_77751,(1),null);
var inst_77754 = clojure.string.starts_with_QMARK_.call(null,inst_77753__$1,"$");
var state_77828__$1 = (function (){var statearr_77886 = state_77828;
(statearr_77886[(24)] = inst_77753__$1);

(statearr_77886[(34)] = inst_77736);

(statearr_77886[(17)] = inst_77749);

(statearr_77886[(26)] = inst_77747);

(statearr_77886[(27)] = inst_77744);

(statearr_77886[(28)] = inst_77748);

(statearr_77886[(29)] = inst_77739);

(statearr_77886[(35)] = inst_77738);

(statearr_77886[(30)] = inst_77750);

(statearr_77886[(31)] = inst_77745);

(statearr_77886[(7)] = inst_77740);

(statearr_77886[(11)] = inst_77746);

(statearr_77886[(14)] = inst_77742);

(statearr_77886[(32)] = inst_77743);

(statearr_77886[(33)] = inst_77741);

(statearr_77886[(20)] = inst_77752);

return statearr_77886;
})();
if(inst_77754){
var statearr_77887_77938 = state_77828__$1;
(statearr_77887_77938[(1)] = (9));

} else {
var statearr_77888_77939 = state_77828__$1;
(statearr_77888_77939[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_77889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77889[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_77889[(1)] = (1));

return statearr_77889;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_77828){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77828);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77890){var ex__2749__auto__ = e77890;
var statearr_77891_77940 = state_77828;
(statearr_77891_77940[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77828[(4)]))){
var statearr_77892_77941 = state_77828;
(statearr_77892_77941[(1)] = cljs.core.first.call(null,(state_77828[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77942 = state_77828;
state_77828 = G__77942;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_77828){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_77828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77893 = f__2769__auto__.call(null);
(statearr_77893[(6)] = c__2768__auto__);

return statearr_77893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.newLedger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *   tuple of either [network ledger alias] or [network ledger].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger id.
 * 
 *   If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger-ident.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolveLedger = (function flureenjs$resolveLedger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_77961){
var state_val_77962 = (state_77961[(1)]);
if((state_val_77962 === (1))){
var state_77961__$1 = state_77961;
var statearr_77963_77978 = state_77961__$1;
(statearr_77963_77978[(2)] = null);

(statearr_77963_77978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77962 === (2))){
var _ = (function (){var statearr_77964 = state_77961;
(statearr_77964[(4)] = cljs.core.cons.call(null,(5),(state_77961[(4)])));

return statearr_77964;
})();
var inst_77954 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_77955 = cljs.core.clj__GT_js.call(null,inst_77954);
var inst_77956 = resolve.call(null,inst_77955);
var ___$1 = (function (){var statearr_77965 = state_77961;
(statearr_77965[(4)] = cljs.core.rest.call(null,(state_77961[(4)])));

return statearr_77965;
})();
var state_77961__$1 = state_77961;
var statearr_77966_77979 = state_77961__$1;
(statearr_77966_77979[(2)] = inst_77956);

(statearr_77966_77979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77962 === (3))){
var inst_77959 = (state_77961[(2)]);
var state_77961__$1 = state_77961;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_77961__$1,inst_77959);
} else {
if((state_val_77962 === (4))){
var inst_77943 = (state_77961[(2)]);
var inst_77944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77945 = [inst_77943];
var inst_77946 = (new cljs.core.PersistentVector(null,1,(5),inst_77944,inst_77945,null));
var inst_77947 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77946);
var inst_77948 = reject.call(null,inst_77943);
var state_77961__$1 = (function (){var statearr_77968 = state_77961;
(statearr_77968[(7)] = inst_77947);

return statearr_77968;
})();
var statearr_77969_77980 = state_77961__$1;
(statearr_77969_77980[(2)] = inst_77948);

(statearr_77969_77980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_77962 === (5))){
var _ = (function (){var statearr_77970 = state_77961;
(statearr_77970[(4)] = cljs.core.rest.call(null,(state_77961[(4)])));

return statearr_77970;
})();
var state_77961__$1 = state_77961;
var ex77967 = (state_77961__$1[(2)]);
var statearr_77971_77981 = state_77961__$1;
(statearr_77971_77981[(5)] = ex77967);


var statearr_77972_77982 = state_77961__$1;
(statearr_77972_77982[(1)] = (4));

(statearr_77972_77982[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolveLedger_$_state_machine__2746__auto__ = null;
var flureenjs$resolveLedger_$_state_machine__2746__auto____0 = (function (){
var statearr_77973 = [null,null,null,null,null,null,null,null];
(statearr_77973[(0)] = flureenjs$resolveLedger_$_state_machine__2746__auto__);

(statearr_77973[(1)] = (1));

return statearr_77973;
});
var flureenjs$resolveLedger_$_state_machine__2746__auto____1 = (function (state_77961){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_77961);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e77974){var ex__2749__auto__ = e77974;
var statearr_77975_77983 = state_77961;
(statearr_77975_77983[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_77961[(4)]))){
var statearr_77976_77984 = state_77961;
(statearr_77976_77984[(1)] = cljs.core.first.call(null,(state_77961[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__77985 = state_77961;
state_77961 = G__77985;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$resolveLedger_$_state_machine__2746__auto__ = function(state_77961){
switch(arguments.length){
case 0:
return flureenjs$resolveLedger_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$resolveLedger_$_state_machine__2746__auto____1.call(this,state_77961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolveLedger_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolveLedger_$_state_machine__2746__auto____0;
flureenjs$resolveLedger_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolveLedger_$_state_machine__2746__auto____1;
return flureenjs$resolveLedger_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_77977 = f__2769__auto__.call(null);
(statearr_77977[(6)] = c__2768__auto__);

return statearr_77977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.resolveLedger', flureenjs.resolveLedger);
/**
 * Returns session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78004){
var state_val_78005 = (state_78004[(1)]);
if((state_val_78005 === (1))){
var state_78004__$1 = state_78004;
var statearr_78006_78021 = state_78004__$1;
(statearr_78006_78021[(2)] = null);

(statearr_78006_78021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78005 === (2))){
var _ = (function (){var statearr_78007 = state_78004;
(statearr_78007[(4)] = cljs.core.cons.call(null,(5),(state_78004[(4)])));

return statearr_78007;
})();
var inst_77997 = fluree.db.session.session.call(null,conn,ledger);
var inst_77998 = cljs.core.clj__GT_js.call(null,inst_77997);
var inst_77999 = resolve.call(null,inst_77998);
var ___$1 = (function (){var statearr_78008 = state_78004;
(statearr_78008[(4)] = cljs.core.rest.call(null,(state_78004[(4)])));

return statearr_78008;
})();
var state_78004__$1 = state_78004;
var statearr_78009_78022 = state_78004__$1;
(statearr_78009_78022[(2)] = inst_77999);

(statearr_78009_78022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78005 === (3))){
var inst_78002 = (state_78004[(2)]);
var state_78004__$1 = state_78004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78004__$1,inst_78002);
} else {
if((state_val_78005 === (4))){
var inst_77986 = (state_78004[(2)]);
var inst_77987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77988 = [inst_77986];
var inst_77989 = (new cljs.core.PersistentVector(null,1,(5),inst_77987,inst_77988,null));
var inst_77990 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_77989);
var inst_77991 = reject.call(null,inst_77986);
var state_78004__$1 = (function (){var statearr_78011 = state_78004;
(statearr_78011[(7)] = inst_77990);

return statearr_78011;
})();
var statearr_78012_78023 = state_78004__$1;
(statearr_78012_78023[(2)] = inst_77991);

(statearr_78012_78023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78005 === (5))){
var _ = (function (){var statearr_78013 = state_78004;
(statearr_78013[(4)] = cljs.core.rest.call(null,(state_78004[(4)])));

return statearr_78013;
})();
var state_78004__$1 = state_78004;
var ex78010 = (state_78004__$1[(2)]);
var statearr_78014_78024 = state_78004__$1;
(statearr_78014_78024[(5)] = ex78010);


var statearr_78015_78025 = state_78004__$1;
(statearr_78015_78025[(1)] = (4));

(statearr_78015_78025[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__2746__auto__ = null;
var flureenjs$session_$_state_machine__2746__auto____0 = (function (){
var statearr_78016 = [null,null,null,null,null,null,null,null];
(statearr_78016[(0)] = flureenjs$session_$_state_machine__2746__auto__);

(statearr_78016[(1)] = (1));

return statearr_78016;
});
var flureenjs$session_$_state_machine__2746__auto____1 = (function (state_78004){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78017){var ex__2749__auto__ = e78017;
var statearr_78018_78026 = state_78004;
(statearr_78018_78026[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78004[(4)]))){
var statearr_78019_78027 = state_78004;
(statearr_78019_78027[(1)] = cljs.core.first.call(null,(state_78004[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78028 = state_78004;
state_78004 = G__78028;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__2746__auto__ = function(state_78004){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__2746__auto____1.call(this,state_78004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__2746__auto____0;
flureenjs$session_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__2746__auto____1;
return flureenjs$session_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78020 = f__2769__auto__.call(null);
(statearr_78020[(6)] = c__2768__auto__);

return statearr_78020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78055){
var state_val_78056 = (state_78055[(1)]);
if((state_val_78056 === (1))){
var state_78055__$1 = state_78055;
var statearr_78057_78073 = state_78055__$1;
(statearr_78057_78073[(2)] = null);

(statearr_78057_78073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78056 === (2))){
var _ = (function (){var statearr_78058 = state_78055;
(statearr_78058[(4)] = cljs.core.cons.call(null,(5),(state_78055[(4)])));

return statearr_78058;
})();
var inst_78040 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_78055__$1 = (function (){var statearr_78059 = state_78055;
(statearr_78059[(7)] = inst_78040);

return statearr_78059;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78055__$1,(7),db);
} else {
if((state_val_78056 === (3))){
var inst_78053 = (state_78055[(2)]);
var state_78055__$1 = state_78055;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78055__$1,inst_78053);
} else {
if((state_val_78056 === (4))){
var inst_78029 = (state_78055[(2)]);
var inst_78030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78031 = [inst_78029];
var inst_78032 = (new cljs.core.PersistentVector(null,1,(5),inst_78030,inst_78031,null));
var inst_78033 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78032);
var inst_78034 = reject.call(null,inst_78029);
var state_78055__$1 = (function (){var statearr_78061 = state_78055;
(statearr_78061[(8)] = inst_78033);

return statearr_78061;
})();
var statearr_78062_78074 = state_78055__$1;
(statearr_78062_78074[(2)] = inst_78034);

(statearr_78062_78074[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78056 === (5))){
var _ = (function (){var statearr_78063 = state_78055;
(statearr_78063[(4)] = cljs.core.rest.call(null,(state_78055[(4)])));

return statearr_78063;
})();
var state_78055__$1 = state_78055;
var ex78060 = (state_78055__$1[(2)]);
var statearr_78064_78075 = state_78055__$1;
(statearr_78064_78075[(5)] = ex78060);


var statearr_78065_78076 = state_78055__$1;
(statearr_78065_78076[(1)] = (4));

(statearr_78065_78076[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78056 === (6))){
var inst_78046 = (state_78055[(2)]);
var inst_78047 = fluree.db.util.async.throw_err.call(null,inst_78046);
var inst_78048 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_78047);
var inst_78049 = cljs.core.clj__GT_js.call(null,inst_78048);
var inst_78050 = resolve.call(null,inst_78049);
var _ = (function (){var statearr_78066 = state_78055;
(statearr_78066[(4)] = cljs.core.rest.call(null,(state_78055[(4)])));

return statearr_78066;
})();
var state_78055__$1 = state_78055;
var statearr_78067_78077 = state_78055__$1;
(statearr_78067_78077[(2)] = inst_78050);

(statearr_78067_78077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78056 === (7))){
var inst_78040 = (state_78055[(7)]);
var inst_78042 = (state_78055[(2)]);
var inst_78043 = fluree.db.util.async.throw_err.call(null,inst_78042);
var inst_78044 = fluree.db.dbproto._search.call(null,inst_78043,inst_78040);
var state_78055__$1 = state_78055;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78055__$1,(6),inst_78044);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__2746__auto__ = null;
var flureenjs$search_$_state_machine__2746__auto____0 = (function (){
var statearr_78068 = [null,null,null,null,null,null,null,null,null];
(statearr_78068[(0)] = flureenjs$search_$_state_machine__2746__auto__);

(statearr_78068[(1)] = (1));

return statearr_78068;
});
var flureenjs$search_$_state_machine__2746__auto____1 = (function (state_78055){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78055);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78069){var ex__2749__auto__ = e78069;
var statearr_78070_78078 = state_78055;
(statearr_78070_78078[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78055[(4)]))){
var statearr_78071_78079 = state_78055;
(statearr_78071_78079[(1)] = cljs.core.first.call(null,(state_78055[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78080 = state_78055;
state_78055 = G__78080;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__2746__auto__ = function(state_78055){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__2746__auto____1.call(this,state_78055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__2746__auto____0;
flureenjs$search_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__2746__auto____1;
return flureenjs$search_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78072 = f__2769__auto__.call(null);
(statearr_78072[(6)] = c__2768__auto__);

return statearr_78072;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 * including the provided flakes. Flakes can contain one or more 't's,
 * but should be sequential and start after the current 't' of the provided
 * db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 * 't' is negative and thus should be in descending order.
 * 
 * A forward-time-travel db can be further forward-time-traveled.
 * 
 * A forward-time travel DB is held in memory, and is not shared across servers.
 * Ensure you have adequate memory to hold the flakes you generate and add. If
 * access is provided via an external API, do any desired size restrictions or
 * controls within your API endpoint.
 * 
 * Remember schema operations done via forward-time-travel should be done in a
 * 't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forwardTimeTravel = (function flureenjs$forwardTimeTravel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78104){
var state_val_78105 = (state_78104[(1)]);
if((state_val_78105 === (1))){
var state_78104__$1 = state_78104;
var statearr_78106_78122 = state_78104__$1;
(statearr_78106_78122[(2)] = null);

(statearr_78106_78122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78105 === (2))){
var _ = (function (){var statearr_78107 = state_78104;
(statearr_78107[(4)] = cljs.core.cons.call(null,(5),(state_78104[(4)])));

return statearr_78107;
})();
var inst_78092 = cljs.core.js__GT_clj.call(null,flakes);
var inst_78093 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_78092);
var state_78104__$1 = (function (){var statearr_78108 = state_78104;
(statearr_78108[(7)] = inst_78093);

return statearr_78108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78104__$1,(6),db);
} else {
if((state_val_78105 === (3))){
var inst_78102 = (state_78104[(2)]);
var state_78104__$1 = state_78104;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78104__$1,inst_78102);
} else {
if((state_val_78105 === (4))){
var inst_78081 = (state_78104[(2)]);
var inst_78082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78083 = [inst_78081];
var inst_78084 = (new cljs.core.PersistentVector(null,1,(5),inst_78082,inst_78083,null));
var inst_78085 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78084);
var inst_78086 = reject.call(null,inst_78081);
var state_78104__$1 = (function (){var statearr_78110 = state_78104;
(statearr_78110[(8)] = inst_78085);

return statearr_78110;
})();
var statearr_78111_78123 = state_78104__$1;
(statearr_78111_78123[(2)] = inst_78086);

(statearr_78111_78123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78105 === (5))){
var _ = (function (){var statearr_78112 = state_78104;
(statearr_78112[(4)] = cljs.core.rest.call(null,(state_78104[(4)])));

return statearr_78112;
})();
var state_78104__$1 = state_78104;
var ex78109 = (state_78104__$1[(2)]);
var statearr_78113_78124 = state_78104__$1;
(statearr_78113_78124[(5)] = ex78109);


var statearr_78114_78125 = state_78104__$1;
(statearr_78114_78125[(1)] = (4));

(statearr_78114_78125[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78105 === (6))){
var inst_78093 = (state_78104[(7)]);
var inst_78095 = (state_78104[(2)]);
var inst_78096 = fluree.db.util.async.throw_err.call(null,inst_78095);
var inst_78097 = fluree.db.graphdb.forward_time_travel.call(null,inst_78096,null,inst_78093);
var inst_78098 = cljs.core.clj__GT_js.call(null,inst_78097);
var inst_78099 = resolve.call(null,inst_78098);
var _ = (function (){var statearr_78115 = state_78104;
(statearr_78115[(4)] = cljs.core.rest.call(null,(state_78104[(4)])));

return statearr_78115;
})();
var state_78104__$1 = state_78104;
var statearr_78116_78126 = state_78104__$1;
(statearr_78116_78126[(2)] = inst_78099);

(statearr_78116_78126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forwardTimeTravel_$_state_machine__2746__auto__ = null;
var flureenjs$forwardTimeTravel_$_state_machine__2746__auto____0 = (function (){
var statearr_78117 = [null,null,null,null,null,null,null,null,null];
(statearr_78117[(0)] = flureenjs$forwardTimeTravel_$_state_machine__2746__auto__);

(statearr_78117[(1)] = (1));

return statearr_78117;
});
var flureenjs$forwardTimeTravel_$_state_machine__2746__auto____1 = (function (state_78104){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78104);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78118){var ex__2749__auto__ = e78118;
var statearr_78119_78127 = state_78104;
(statearr_78119_78127[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78104[(4)]))){
var statearr_78120_78128 = state_78104;
(statearr_78120_78128[(1)] = cljs.core.first.call(null,(state_78104[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78129 = state_78104;
state_78104 = G__78129;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$forwardTimeTravel_$_state_machine__2746__auto__ = function(state_78104){
switch(arguments.length){
case 0:
return flureenjs$forwardTimeTravel_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$forwardTimeTravel_$_state_machine__2746__auto____1.call(this,state_78104);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forwardTimeTravel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forwardTimeTravel_$_state_machine__2746__auto____0;
flureenjs$forwardTimeTravel_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forwardTimeTravel_$_state_machine__2746__auto____1;
return flureenjs$forwardTimeTravel_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78121 = f__2769__auto__.call(null);
(statearr_78121[(6)] = c__2768__auto__);

return statearr_78121;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.forwardTimeTravel', flureenjs.forwardTimeTravel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.isForwardTimeTravelDb = (function flureenjs$isForwardTimeTravelDb(db){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78156){
var state_val_78157 = (state_78156[(1)]);
if((state_val_78157 === (7))){
var state_78156__$1 = state_78156;
var statearr_78158_78177 = state_78156__$1;
(statearr_78158_78177[(2)] = db);

(statearr_78158_78177[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78157 === (1))){
var state_78156__$1 = state_78156;
var statearr_78159_78178 = state_78156__$1;
(statearr_78159_78178[(2)] = null);

(statearr_78159_78178[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78157 === (4))){
var inst_78130 = (state_78156[(2)]);
var inst_78131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78132 = [inst_78130];
var inst_78133 = (new cljs.core.PersistentVector(null,1,(5),inst_78131,inst_78132,null));
var inst_78134 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78133);
var inst_78135 = reject.call(null,inst_78130);
var state_78156__$1 = (function (){var statearr_78160 = state_78156;
(statearr_78160[(7)] = inst_78134);

return statearr_78160;
})();
var statearr_78161_78179 = state_78156__$1;
(statearr_78161_78179[(2)] = inst_78135);

(statearr_78161_78179[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78157 === (6))){
var state_78156__$1 = state_78156;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78156__$1,(9),db);
} else {
if((state_val_78157 === (3))){
var inst_78154 = (state_78156[(2)]);
var state_78156__$1 = state_78156;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78156__$1,inst_78154);
} else {
if((state_val_78157 === (2))){
var _ = (function (){var statearr_78163 = state_78156;
(statearr_78163[(4)] = cljs.core.cons.call(null,(5),(state_78156[(4)])));

return statearr_78163;
})();
var inst_78141 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_78156__$1 = state_78156;
if(inst_78141){
var statearr_78164_78180 = state_78156__$1;
(statearr_78164_78180[(1)] = (6));

} else {
var statearr_78165_78181 = state_78156__$1;
(statearr_78165_78181[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78157 === (9))){
var inst_78144 = (state_78156[(2)]);
var inst_78145 = fluree.db.util.async.throw_err.call(null,inst_78144);
var state_78156__$1 = state_78156;
var statearr_78166_78182 = state_78156__$1;
(statearr_78166_78182[(2)] = inst_78145);

(statearr_78166_78182[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78157 === (5))){
var _ = (function (){var statearr_78167 = state_78156;
(statearr_78167[(4)] = cljs.core.rest.call(null,(state_78156[(4)])));

return statearr_78167;
})();
var state_78156__$1 = state_78156;
var ex78162 = (state_78156__$1[(2)]);
var statearr_78168_78183 = state_78156__$1;
(statearr_78168_78183[(5)] = ex78162);


var statearr_78169_78184 = state_78156__$1;
(statearr_78169_78184[(1)] = (4));

(statearr_78169_78184[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78157 === (8))){
var inst_78148 = (state_78156[(2)]);
var inst_78149 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_78148);
var inst_78150 = cljs.core.clj__GT_js.call(null,inst_78149);
var inst_78151 = resolve.call(null,inst_78150);
var _ = (function (){var statearr_78170 = state_78156;
(statearr_78170[(4)] = cljs.core.rest.call(null,(state_78156[(4)])));

return statearr_78170;
})();
var state_78156__$1 = state_78156;
var statearr_78171_78185 = state_78156__$1;
(statearr_78171_78185[(2)] = inst_78151);

(statearr_78171_78185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__ = null;
var flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____0 = (function (){
var statearr_78172 = [null,null,null,null,null,null,null,null];
(statearr_78172[(0)] = flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__);

(statearr_78172[(1)] = (1));

return statearr_78172;
});
var flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____1 = (function (state_78156){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78156);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78173){var ex__2749__auto__ = e78173;
var statearr_78174_78186 = state_78156;
(statearr_78174_78186[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78156[(4)]))){
var statearr_78175_78187 = state_78156;
(statearr_78175_78187[(1)] = cljs.core.first.call(null,(state_78156[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78188 = state_78156;
state_78156 = G__78188;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__ = function(state_78156){
switch(arguments.length){
case 0:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____1.call(this,state_78156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____0;
flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto____1;
return flureenjs$isForwardTimeTravelDb_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78176 = f__2769__auto__.call(null);
(statearr_78176[(6)] = c__2768__auto__);

return statearr_78176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.isForwardTimeTravelDb', flureenjs.isForwardTimeTravelDb);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitorTx = (function flureenjs$monitorTx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78211){
var state_val_78212 = (state_78211[(1)]);
if((state_val_78212 === (1))){
var state_78211__$1 = state_78211;
var statearr_78213_78229 = state_78211__$1;
(statearr_78213_78229[(2)] = null);

(statearr_78213_78229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78212 === (2))){
var _ = (function (){var statearr_78214 = state_78211;
(statearr_78214[(4)] = cljs.core.cons.call(null,(5),(state_78211[(4)])));

return statearr_78214;
})();
var inst_78201 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_78202 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_78211__$1 = (function (){var statearr_78215 = state_78211;
(statearr_78215[(7)] = inst_78201);

return statearr_78215;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78211__$1,(6),inst_78202);
} else {
if((state_val_78212 === (3))){
var inst_78209 = (state_78211[(2)]);
var state_78211__$1 = state_78211;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78211__$1,inst_78209);
} else {
if((state_val_78212 === (4))){
var inst_78189 = (state_78211[(2)]);
var inst_78190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78191 = [inst_78189];
var inst_78192 = (new cljs.core.PersistentVector(null,1,(5),inst_78190,inst_78191,null));
var inst_78193 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78192);
var inst_78194 = cljs.core.clj__GT_js.call(null,inst_78189);
var inst_78195 = reject.call(null,inst_78194);
var state_78211__$1 = (function (){var statearr_78217 = state_78211;
(statearr_78217[(8)] = inst_78193);

return statearr_78217;
})();
var statearr_78218_78230 = state_78211__$1;
(statearr_78218_78230[(2)] = inst_78195);

(statearr_78218_78230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78212 === (5))){
var _ = (function (){var statearr_78219 = state_78211;
(statearr_78219[(4)] = cljs.core.rest.call(null,(state_78211[(4)])));

return statearr_78219;
})();
var state_78211__$1 = state_78211;
var ex78216 = (state_78211__$1[(2)]);
var statearr_78220_78231 = state_78211__$1;
(statearr_78220_78231[(5)] = ex78216);


var statearr_78221_78232 = state_78211__$1;
(statearr_78221_78232[(1)] = (4));

(statearr_78221_78232[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78212 === (6))){
var inst_78204 = (state_78211[(2)]);
var inst_78205 = cljs.core.clj__GT_js.call(null,inst_78204);
var inst_78206 = resolve.call(null,inst_78205);
var _ = (function (){var statearr_78222 = state_78211;
(statearr_78222[(4)] = cljs.core.rest.call(null,(state_78211[(4)])));

return statearr_78222;
})();
var state_78211__$1 = state_78211;
var statearr_78223_78233 = state_78211__$1;
(statearr_78223_78233[(2)] = inst_78206);

(statearr_78223_78233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitorTx_$_state_machine__2746__auto__ = null;
var flureenjs$monitorTx_$_state_machine__2746__auto____0 = (function (){
var statearr_78224 = [null,null,null,null,null,null,null,null,null];
(statearr_78224[(0)] = flureenjs$monitorTx_$_state_machine__2746__auto__);

(statearr_78224[(1)] = (1));

return statearr_78224;
});
var flureenjs$monitorTx_$_state_machine__2746__auto____1 = (function (state_78211){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78211);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78225){var ex__2749__auto__ = e78225;
var statearr_78226_78234 = state_78211;
(statearr_78226_78234[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78211[(4)]))){
var statearr_78227_78235 = state_78211;
(statearr_78227_78235[(1)] = cljs.core.first.call(null,(state_78211[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78236 = state_78211;
state_78211 = G__78236;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$monitorTx_$_state_machine__2746__auto__ = function(state_78211){
switch(arguments.length){
case 0:
return flureenjs$monitorTx_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$monitorTx_$_state_machine__2746__auto____1.call(this,state_78211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitorTx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitorTx_$_state_machine__2746__auto____0;
flureenjs$monitorTx_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitorTx_$_state_machine__2746__auto____1;
return flureenjs$monitorTx_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78228 = f__2769__auto__.call(null);
(statearr_78228[(6)] = c__2768__auto__);

return statearr_78228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.monitorTx', flureenjs.monitorTx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd    - a map with the command/transaction data as a JSON string
 *  - sig    - the signature of the above stringified map
 *  - id     - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - ledger - the ledger for this transaction
 */
flureenjs.txToCommand = (function flureenjs$txToCommand(var_args){
var G__78238 = arguments.length;
switch (G__78238) {
case 3:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.txToCommand.call(null,ledger,txn,private_key,null);
}));

(flureenjs.txToCommand.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78353){
var state_val_78354 = (state_78353[(1)]);
if((state_val_78354 === (7))){
var state_78353__$1 = state_78353;
var statearr_78355_78422 = state_78353__$1;
(statearr_78355_78422[(2)] = ledger);

(statearr_78355_78422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (20))){
var inst_78267 = (state_78353[(7)]);
var inst_78307 = (state_78353[(2)]);
var inst_78308 = cljs.core.nth.call(null,inst_78307,(0),null);
var inst_78309 = cljs.core.nth.call(null,inst_78307,(1),null);
var inst_78310 = fluree.db.util.core.current_time_millis.call(null);
var state_78353__$1 = (function (){var statearr_78356 = state_78353;
(statearr_78356[(8)] = inst_78310);

(statearr_78356[(9)] = inst_78309);

(statearr_78356[(10)] = inst_78308);

return statearr_78356;
})();
if(cljs.core.truth_(inst_78267)){
var statearr_78357_78423 = state_78353__$1;
(statearr_78357_78423[(1)] = (27));

} else {
var statearr_78358_78424 = state_78353__$1;
(statearr_78358_78424[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (27))){
var inst_78267 = (state_78353[(7)]);
var state_78353__$1 = state_78353;
var statearr_78359_78425 = state_78353__$1;
(statearr_78359_78425[(2)] = inst_78267);

(statearr_78359_78425[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (1))){
var state_78353__$1 = state_78353;
var statearr_78360_78426 = state_78353__$1;
(statearr_78360_78426[(2)] = null);

(statearr_78360_78426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (24))){
var inst_78281 = (state_78353[(11)]);
var inst_78298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78299 = [inst_78281,null];
var inst_78300 = (new cljs.core.PersistentVector(null,2,(5),inst_78298,inst_78299,null));
var state_78353__$1 = state_78353;
var statearr_78361_78427 = state_78353__$1;
(statearr_78361_78427[(2)] = inst_78300);

(statearr_78361_78427[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (4))){
var inst_78239 = (state_78353[(2)]);
var inst_78240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78241 = [inst_78239];
var inst_78242 = (new cljs.core.PersistentVector(null,1,(5),inst_78240,inst_78241,null));
var inst_78243 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78242);
var inst_78244 = cljs.core.clj__GT_js.call(null,inst_78239);
var inst_78245 = reject.call(null,inst_78244);
var state_78353__$1 = (function (){var statearr_78362 = state_78353;
(statearr_78362[(12)] = inst_78243);

return statearr_78362;
})();
var statearr_78363_78428 = state_78353__$1;
(statearr_78363_78428[(2)] = inst_78245);

(statearr_78363_78428[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (15))){
var inst_78265 = (state_78353[(13)]);
var inst_78281 = (state_78353[(11)]);
var inst_78283 = cljs.core.not_EQ_.call(null,inst_78265,inst_78281);
var state_78353__$1 = state_78353;
var statearr_78364_78429 = state_78353__$1;
(statearr_78364_78429[(2)] = inst_78283);

(statearr_78364_78429[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (21))){
var inst_78265 = (state_78353[(13)]);
var inst_78293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78294 = [inst_78265,null];
var inst_78295 = (new cljs.core.PersistentVector(null,2,(5),inst_78293,inst_78294,null));
var state_78353__$1 = state_78353;
var statearr_78365_78430 = state_78353__$1;
(statearr_78365_78430[(2)] = inst_78295);

(statearr_78365_78430[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (31))){
var inst_78310 = (state_78353[(8)]);
var inst_78317 = (inst_78310 + (30000));
var state_78353__$1 = state_78353;
var statearr_78366_78431 = state_78353__$1;
(statearr_78366_78431[(2)] = inst_78317);

(statearr_78366_78431[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (32))){
var inst_78319 = (state_78353[(2)]);
var state_78353__$1 = (function (){var statearr_78367 = state_78353;
(statearr_78367[(14)] = inst_78319);

return statearr_78367;
})();
var statearr_78368_78432 = state_78353__$1;
(statearr_78368_78432[(2)] = null);

(statearr_78368_78432[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (33))){
var inst_78319 = (state_78353[(14)]);
var inst_78314 = (state_78353[(15)]);
var inst_78309 = (state_78353[(9)]);
var inst_78308 = (state_78353[(10)]);
var inst_78262 = (state_78353[(16)]);
var inst_78268 = (state_78353[(17)]);
var _ = (function (){var statearr_78369 = state_78353;
(statearr_78369[(4)] = cljs.core.cons.call(null,(36),(state_78353[(4)])));

return statearr_78369;
})();
var inst_78335 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_78336 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_78262,txn,inst_78314,inst_78308,inst_78309,inst_78319,inst_78268];
var inst_78337 = cljs.core.PersistentHashMap.fromArrays(inst_78335,inst_78336);
var inst_78338 = fluree.db.util.core.without_nils.call(null,inst_78337);
var inst_78339 = fluree.db.util.json.stringify.call(null,inst_78338);
var ___$1 = (function (){var statearr_78370 = state_78353;
(statearr_78370[(4)] = cljs.core.rest.call(null,(state_78353[(4)])));

return statearr_78370;
})();
var state_78353__$1 = state_78353;
var statearr_78371_78433 = state_78353__$1;
(statearr_78371_78433[(2)] = inst_78339);

(statearr_78371_78433[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (13))){
var inst_78273 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_78274 = (new Error(inst_78273));
var inst_78275 = (function(){throw inst_78274})();
var state_78353__$1 = state_78353;
var statearr_78373_78434 = state_78353__$1;
(statearr_78373_78434[(2)] = inst_78275);

(statearr_78373_78434[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (22))){
var state_78353__$1 = state_78353;
var statearr_78374_78435 = state_78353__$1;
(statearr_78374_78435[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (36))){
var _ = (function (){var statearr_78376 = state_78353;
(statearr_78376[(4)] = cljs.core.rest.call(null,(state_78353[(4)])));

return statearr_78376;
})();
var state_78353__$1 = state_78353;
var ex78372 = (state_78353__$1[(2)]);
var statearr_78377_78436 = state_78353__$1;
(statearr_78377_78436[(5)] = ex78372);


var statearr_78378_78437 = state_78353__$1;
(statearr_78378_78437[(1)] = (35));

(statearr_78378_78437[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (29))){
var inst_78266 = (state_78353[(18)]);
var inst_78314 = (state_78353[(2)]);
var state_78353__$1 = (function (){var statearr_78379 = state_78353;
(statearr_78379[(15)] = inst_78314);

return statearr_78379;
})();
if(cljs.core.truth_(inst_78266)){
var statearr_78380_78438 = state_78353__$1;
(statearr_78380_78438[(1)] = (30));

} else {
var statearr_78381_78439 = state_78353__$1;
(statearr_78381_78439[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (6))){
var inst_78257 = cljs.core.first.call(null,ledger);
var inst_78258 = cljs.core.second.call(null,ledger);
var inst_78259 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78257),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78258)].join('');
var state_78353__$1 = state_78353;
var statearr_78382_78440 = state_78353__$1;
(statearr_78382_78440[(2)] = inst_78259);

(statearr_78382_78440[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (28))){
var inst_78310 = (state_78353[(8)]);
var state_78353__$1 = state_78353;
var statearr_78383_78441 = state_78353__$1;
(statearr_78383_78441[(2)] = inst_78310);

(statearr_78383_78441[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (25))){
var state_78353__$1 = state_78353;
var statearr_78384_78442 = state_78353__$1;
(statearr_78384_78442[(2)] = null);

(statearr_78384_78442[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (34))){
var inst_78342 = (state_78353[(2)]);
var inst_78343 = fluree.crypto.sign_message.call(null,inst_78342,private_key);
var inst_78344 = fluree.crypto.sha3_256.call(null,inst_78342);
var inst_78345 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"ledger","ledger",561720706)];
var inst_78346 = [inst_78342,inst_78343,inst_78344,ledger];
var inst_78347 = cljs.core.PersistentHashMap.fromArrays(inst_78345,inst_78346);
var inst_78348 = resolve.call(null,inst_78347);
var _ = (function (){var statearr_78385 = state_78353;
(statearr_78385[(4)] = cljs.core.rest.call(null,(state_78353[(4)])));

return statearr_78385;
})();
var state_78353__$1 = state_78353;
var statearr_78386_78443 = state_78353__$1;
(statearr_78386_78443[(2)] = inst_78348);

(statearr_78386_78443[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (17))){
var inst_78286 = (state_78353[(2)]);
var state_78353__$1 = state_78353;
if(cljs.core.truth_(inst_78286)){
var statearr_78387_78444 = state_78353__$1;
(statearr_78387_78444[(1)] = (18));

} else {
var statearr_78388_78445 = state_78353__$1;
(statearr_78388_78445[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (3))){
var inst_78351 = (state_78353[(2)]);
var state_78353__$1 = state_78353;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78353__$1,inst_78351);
} else {
if((state_val_78354 === (12))){
var state_78353__$1 = state_78353;
var statearr_78389_78446 = state_78353__$1;
(statearr_78389_78446[(2)] = null);

(statearr_78389_78446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (2))){
var _ = (function (){var statearr_78390 = state_78353;
(statearr_78390[(4)] = cljs.core.cons.call(null,(5),(state_78353[(4)])));

return statearr_78390;
})();
var inst_78255 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_78353__$1 = state_78353;
if(inst_78255){
var statearr_78391_78447 = state_78353__$1;
(statearr_78391_78447[(1)] = (6));

} else {
var statearr_78392_78448 = state_78353__$1;
(statearr_78392_78448[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (23))){
var inst_78305 = (state_78353[(2)]);
var state_78353__$1 = state_78353;
var statearr_78393_78449 = state_78353__$1;
(statearr_78393_78449[(2)] = inst_78305);

(statearr_78393_78449[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (35))){
var inst_78320 = (state_78353[(2)]);
var inst_78321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78322 = [inst_78320];
var inst_78323 = (new cljs.core.PersistentVector(null,1,(5),inst_78321,inst_78322,null));
var inst_78324 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78323);
var inst_78325 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_78326 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_78327 = cljs.core.PersistentHashMap.fromArrays(inst_78325,inst_78326);
var inst_78328 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_78327);
var inst_78329 = (function(){throw inst_78328})();
var state_78353__$1 = (function (){var statearr_78394 = state_78353;
(statearr_78394[(19)] = inst_78324);

return statearr_78394;
})();
var statearr_78395_78450 = state_78353__$1;
(statearr_78395_78450[(2)] = inst_78329);

(statearr_78395_78450[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (19))){
var inst_78265 = (state_78353[(13)]);
var state_78353__$1 = state_78353;
if(cljs.core.truth_(inst_78265)){
var statearr_78396_78451 = state_78353__$1;
(statearr_78396_78451[(1)] = (21));

} else {
var statearr_78397_78452 = state_78353__$1;
(statearr_78397_78452[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (11))){
var inst_78265 = (state_78353[(13)]);
var inst_78280 = (state_78353[(2)]);
var inst_78281 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_78353__$1 = (function (){var statearr_78399 = state_78353;
(statearr_78399[(11)] = inst_78281);

(statearr_78399[(20)] = inst_78280);

return statearr_78399;
})();
if(cljs.core.truth_(inst_78265)){
var statearr_78400_78453 = state_78353__$1;
(statearr_78400_78453[(1)] = (15));

} else {
var statearr_78401_78454 = state_78353__$1;
(statearr_78401_78454[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (9))){
var inst_78268 = (state_78353[(17)]);
var inst_78270 = cljs.core.sequential_QMARK_.call(null,inst_78268);
var state_78353__$1 = state_78353;
if(inst_78270){
var statearr_78402_78455 = state_78353__$1;
(statearr_78402_78455[(1)] = (12));

} else {
var statearr_78403_78456 = state_78353__$1;
(statearr_78403_78456[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (5))){
var _ = (function (){var statearr_78404 = state_78353;
(statearr_78404[(4)] = cljs.core.rest.call(null,(state_78353[(4)])));

return statearr_78404;
})();
var state_78353__$1 = state_78353;
var ex78398 = (state_78353__$1[(2)]);
var statearr_78405_78457 = state_78353__$1;
(statearr_78405_78457[(5)] = ex78398);


var statearr_78406_78458 = state_78353__$1;
(statearr_78406_78458[(1)] = (4));

(statearr_78406_78458[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (14))){
var inst_78277 = (state_78353[(2)]);
var state_78353__$1 = state_78353;
var statearr_78407_78459 = state_78353__$1;
(statearr_78407_78459[(2)] = inst_78277);

(statearr_78407_78459[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (26))){
var inst_78303 = (state_78353[(2)]);
var state_78353__$1 = state_78353;
var statearr_78408_78460 = state_78353__$1;
(statearr_78408_78460[(2)] = inst_78303);

(statearr_78408_78460[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (16))){
var inst_78265 = (state_78353[(13)]);
var state_78353__$1 = state_78353;
var statearr_78409_78461 = state_78353__$1;
(statearr_78409_78461[(2)] = inst_78265);

(statearr_78409_78461[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (30))){
var inst_78266 = (state_78353[(18)]);
var state_78353__$1 = state_78353;
var statearr_78410_78462 = state_78353__$1;
(statearr_78410_78462[(2)] = inst_78266);

(statearr_78410_78462[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (10))){
var state_78353__$1 = state_78353;
var statearr_78411_78463 = state_78353__$1;
(statearr_78411_78463[(2)] = null);

(statearr_78411_78463[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (18))){
var inst_78265 = (state_78353[(13)]);
var inst_78281 = (state_78353[(11)]);
var inst_78288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78289 = [inst_78265,inst_78281];
var inst_78290 = (new cljs.core.PersistentVector(null,2,(5),inst_78288,inst_78289,null));
var state_78353__$1 = state_78353;
var statearr_78412_78464 = state_78353__$1;
(statearr_78412_78464[(2)] = inst_78290);

(statearr_78412_78464[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78354 === (8))){
var inst_78268 = (state_78353[(17)]);
var inst_78262 = (state_78353[(2)]);
var inst_78263 = opts;
var inst_78264 = cljs.core.__destructure_map.call(null,inst_78263);
var inst_78265 = cljs.core.get.call(null,inst_78264,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_78266 = cljs.core.get.call(null,inst_78264,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_78267 = cljs.core.get.call(null,inst_78264,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_78268__$1 = cljs.core.get.call(null,inst_78264,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_78353__$1 = (function (){var statearr_78413 = state_78353;
(statearr_78413[(18)] = inst_78266);

(statearr_78413[(13)] = inst_78265);

(statearr_78413[(7)] = inst_78267);

(statearr_78413[(16)] = inst_78262);

(statearr_78413[(17)] = inst_78268__$1);

return statearr_78413;
})();
if(cljs.core.truth_(inst_78268__$1)){
var statearr_78414_78465 = state_78353__$1;
(statearr_78414_78465[(1)] = (9));

} else {
var statearr_78415_78466 = state_78353__$1;
(statearr_78415_78466[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_78416 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78416[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_78416[(1)] = (1));

return statearr_78416;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_78353){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78353);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78417){var ex__2749__auto__ = e78417;
var statearr_78418_78467 = state_78353;
(statearr_78418_78467[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78353[(4)]))){
var statearr_78419_78468 = state_78353;
(statearr_78419_78468[(1)] = cljs.core.first.call(null,(state_78353[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78469 = state_78353;
state_78353 = G__78469;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_78353){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_78353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78420 = f__2769__auto__.call(null);
(statearr_78420[(6)] = c__2768__auto__);

return statearr_78420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.txToCommand.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__78471 = arguments.length;
switch (G__78471) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78500){
var state_val_78501 = (state_78500[(1)]);
if((state_val_78501 === (7))){
var inst_78486 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_78500__$1 = state_78500;
var statearr_78502_78523 = state_78500__$1;
(statearr_78502_78523[(2)] = inst_78486);

(statearr_78502_78523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (1))){
var state_78500__$1 = state_78500;
var statearr_78503_78524 = state_78500__$1;
(statearr_78503_78524[(2)] = null);

(statearr_78503_78524[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (4))){
var inst_78472 = (state_78500[(2)]);
var inst_78473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78474 = [inst_78472];
var inst_78475 = (new cljs.core.PersistentVector(null,1,(5),inst_78473,inst_78474,null));
var inst_78476 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78475);
var inst_78477 = reject.call(null,inst_78472);
var state_78500__$1 = (function (){var statearr_78504 = state_78500;
(statearr_78504[(7)] = inst_78476);

return statearr_78504;
})();
var statearr_78505_78525 = state_78500__$1;
(statearr_78505_78525[(2)] = inst_78477);

(statearr_78505_78525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (6))){
var state_78500__$1 = state_78500;
var statearr_78506_78526 = state_78500__$1;
(statearr_78506_78526[(2)] = null);

(statearr_78506_78526[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (3))){
var inst_78498 = (state_78500[(2)]);
var state_78500__$1 = state_78500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78500__$1,inst_78498);
} else {
if((state_val_78501 === (2))){
var _ = (function (){var statearr_78508 = state_78500;
(statearr_78508[(4)] = cljs.core.cons.call(null,(5),(state_78500[(4)])));

return statearr_78508;
})();
var inst_78483 = (opts == null);
var state_78500__$1 = state_78500;
if(cljs.core.truth_(inst_78483)){
var statearr_78509_78527 = state_78500__$1;
(statearr_78509_78527[(1)] = (6));

} else {
var statearr_78510_78528 = state_78500__$1;
(statearr_78510_78528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (9))){
var inst_78493 = (state_78500[(2)]);
var inst_78494 = cljs.core.clj__GT_js.call(null,inst_78493);
var inst_78495 = resolve.call(null,inst_78494);
var _ = (function (){var statearr_78511 = state_78500;
(statearr_78511[(4)] = cljs.core.rest.call(null,(state_78500[(4)])));

return statearr_78511;
})();
var state_78500__$1 = state_78500;
var statearr_78512_78529 = state_78500__$1;
(statearr_78512_78529[(2)] = inst_78495);

(statearr_78512_78529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (5))){
var _ = (function (){var statearr_78513 = state_78500;
(statearr_78513[(4)] = cljs.core.rest.call(null,(state_78500[(4)])));

return statearr_78513;
})();
var state_78500__$1 = state_78500;
var ex78507 = (state_78500__$1[(2)]);
var statearr_78514_78530 = state_78500__$1;
(statearr_78514_78530[(5)] = ex78507);


var statearr_78515_78531 = state_78500__$1;
(statearr_78515_78531[(1)] = (4));

(statearr_78515_78531[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78501 === (8))){
var inst_78488 = (state_78500[(2)]);
var inst_78489 = fluree.db.connection_js.check_connection.call(null,conn,inst_78488);
var inst_78490 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_78491 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_78490,inst_78488);
var state_78500__$1 = (function (){var statearr_78516 = state_78500;
(statearr_78516[(8)] = inst_78489);

return statearr_78516;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78500__$1,(9),inst_78491);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_78517 = [null,null,null,null,null,null,null,null,null];
(statearr_78517[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_78517[(1)] = (1));

return statearr_78517;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_78500){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78518){var ex__2749__auto__ = e78518;
var statearr_78519_78532 = state_78500;
(statearr_78519_78532[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78500[(4)]))){
var statearr_78520_78533 = state_78500;
(statearr_78520_78533[(1)] = cljs.core.first.call(null,(state_78500[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78534 = state_78500;
state_78500 = G__78534;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_78500){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_78500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78521 = f__2769__auto__.call(null);
(statearr_78521[(6)] = c__2768__auto__);

return statearr_78521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.blockRangeWithTxn = (function flureenjs$blockRangeWithTxn(var_args){
var G__78536 = arguments.length;
switch (G__78536) {
case 3:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRangeWithTxn', flureenjs.blockRangeWithTxn);

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.blockRangeWithTxn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.blockRangeWithTxn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78568){
var state_val_78569 = (state_78568[(1)]);
if((state_val_78569 === (1))){
var state_78568__$1 = state_78568;
var statearr_78570_78587 = state_78568__$1;
(statearr_78570_78587[(2)] = null);

(statearr_78570_78587[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (2))){
var inst_78549 = (state_78568[(7)]);
var _ = (function (){var statearr_78571 = state_78568;
(statearr_78571[(4)] = cljs.core.cons.call(null,(5),(state_78568[(4)])));

return statearr_78571;
})();
var inst_78549__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_78550 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_78551 = cljs.core.__destructure_map.call(null,inst_78550);
var inst_78552 = cljs.core.get.call(null,inst_78551,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_78553 = cljs.core.get.call(null,inst_78551,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_78554 = flureenjs._db_instance.call(null,conn,ledger,inst_78549__$1);
var state_78568__$1 = (function (){var statearr_78572 = state_78568;
(statearr_78572[(7)] = inst_78549__$1);

(statearr_78572[(8)] = inst_78552);

(statearr_78572[(9)] = inst_78553);

return statearr_78572;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78568__$1,(6),inst_78554);
} else {
if((state_val_78569 === (3))){
var inst_78566 = (state_78568[(2)]);
var state_78568__$1 = state_78568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78568__$1,inst_78566);
} else {
if((state_val_78569 === (4))){
var inst_78537 = (state_78568[(2)]);
var inst_78538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78539 = [inst_78537];
var inst_78540 = (new cljs.core.PersistentVector(null,1,(5),inst_78538,inst_78539,null));
var inst_78541 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78540);
var inst_78542 = reject.call(null,inst_78537);
var state_78568__$1 = (function (){var statearr_78574 = state_78568;
(statearr_78574[(10)] = inst_78541);

return statearr_78574;
})();
var statearr_78575_78588 = state_78568__$1;
(statearr_78575_78588[(2)] = inst_78542);

(statearr_78575_78588[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (5))){
var _ = (function (){var statearr_78576 = state_78568;
(statearr_78576[(4)] = cljs.core.rest.call(null,(state_78568[(4)])));

return statearr_78576;
})();
var state_78568__$1 = state_78568;
var ex78573 = (state_78568__$1[(2)]);
var statearr_78577_78589 = state_78568__$1;
(statearr_78577_78589[(5)] = ex78573);


var statearr_78578_78590 = state_78568__$1;
(statearr_78578_78590[(1)] = (4));

(statearr_78578_78590[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78569 === (6))){
var inst_78549 = (state_78568[(7)]);
var inst_78552 = (state_78568[(8)]);
var inst_78553 = (state_78568[(9)]);
var inst_78556 = (state_78568[(2)]);
var inst_78557 = fluree.db.query.block.block_range.call(null,inst_78556,inst_78552,inst_78553,inst_78549);
var state_78568__$1 = state_78568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78568__$1,(7),inst_78557);
} else {
if((state_val_78569 === (7))){
var inst_78559 = (state_78568[(2)]);
var inst_78560 = fluree.db.util.async.throw_err.call(null,inst_78559);
var inst_78561 = fluree.db.query.range.block_with_tx_data.call(null,inst_78560);
var inst_78562 = cljs.core.clj__GT_js.call(null,inst_78561);
var inst_78563 = resolve.call(null,inst_78562);
var _ = (function (){var statearr_78579 = state_78568;
(statearr_78579[(4)] = cljs.core.rest.call(null,(state_78568[(4)])));

return statearr_78579;
})();
var state_78568__$1 = state_78568;
var statearr_78580_78591 = state_78568__$1;
(statearr_78580_78591[(2)] = inst_78563);

(statearr_78580_78591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_78581 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_78581[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_78581[(1)] = (1));

return statearr_78581;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_78568){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78582){var ex__2749__auto__ = e78582;
var statearr_78583_78592 = state_78568;
(statearr_78583_78592[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78568[(4)]))){
var statearr_78584_78593 = state_78568;
(statearr_78584_78593[(1)] = cljs.core.first.call(null,(state_78568[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78594 = state_78568;
state_78568 = G__78594;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_78568){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_78568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78585 = f__2769__auto__.call(null);
(statearr_78585[(6)] = c__2768__auto__);

return statearr_78585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.blockRangeWithTxn.cljs$lang$maxFixedArity = 4);

flureenjs.blockQuery = (function flureenjs$blockQuery(var_args){
var G__78596 = arguments.length;
switch (G__78596) {
case 3:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockQuery', flureenjs.blockQuery);

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.blockQuery.call(null,conn,ledger,query_map,null);
}));

(flureenjs.blockQuery.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78657){
var state_val_78658 = (state_78657[(1)]);
if((state_val_78658 === (7))){
var state_78657__$1 = state_78657;
var statearr_78659_78700 = state_78657__$1;
(statearr_78659_78700[(2)] = null);

(statearr_78659_78700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (20))){
var inst_78636 = (state_78657[(2)]);
var state_78657__$1 = state_78657;
var statearr_78660_78701 = state_78657__$1;
(statearr_78660_78701[(2)] = inst_78636);

(statearr_78660_78701[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (1))){
var state_78657__$1 = state_78657;
var statearr_78661_78702 = state_78657__$1;
(statearr_78661_78702[(2)] = null);

(statearr_78661_78702[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (4))){
var inst_78597 = (state_78657[(2)]);
var inst_78598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78599 = [inst_78597];
var inst_78600 = (new cljs.core.PersistentVector(null,1,(5),inst_78598,inst_78599,null));
var inst_78601 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78600);
var inst_78602 = reject.call(null,inst_78597);
var state_78657__$1 = (function (){var statearr_78662 = state_78657;
(statearr_78662[(7)] = inst_78601);

return statearr_78662;
})();
var statearr_78663_78703 = state_78657__$1;
(statearr_78663_78703[(2)] = inst_78602);

(statearr_78663_78703[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (15))){
var state_78657__$1 = state_78657;
var statearr_78664_78704 = state_78657__$1;
(statearr_78664_78704[(2)] = null);

(statearr_78664_78704[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (21))){
var inst_78649 = (state_78657[(2)]);
var inst_78650 = fluree.db.util.async.throw_err.call(null,inst_78649);
var inst_78651 = cljs.core.clj__GT_js.call(null,inst_78650);
var inst_78652 = resolve.call(null,inst_78651);
var _ = (function (){var statearr_78665 = state_78657;
(statearr_78665[(4)] = cljs.core.rest.call(null,(state_78657[(4)])));

return statearr_78665;
})();
var state_78657__$1 = state_78657;
var statearr_78666_78705 = state_78657__$1;
(statearr_78666_78705[(2)] = inst_78652);

(statearr_78666_78705[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (13))){
var inst_78624 = (state_78657[(8)]);
var inst_78615 = (state_78657[(9)]);
var inst_78624__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_78615);
var inst_78625 = (inst_78624__$1 == null);
var state_78657__$1 = (function (){var statearr_78667 = state_78657;
(statearr_78667[(8)] = inst_78624__$1);

return statearr_78667;
})();
if(cljs.core.truth_(inst_78625)){
var statearr_78668_78706 = state_78657__$1;
(statearr_78668_78706[(1)] = (15));

} else {
var statearr_78669_78707 = state_78657__$1;
(statearr_78669_78707[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (6))){
var inst_78611 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_78657__$1 = state_78657;
var statearr_78670_78708 = state_78657__$1;
(statearr_78670_78708[(2)] = inst_78611);

(statearr_78670_78708[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (17))){
var inst_78630 = (state_78657[(10)]);
var inst_78630__$1 = (state_78657[(2)]);
var inst_78631 = (inst_78630__$1 == null);
var state_78657__$1 = (function (){var statearr_78671 = state_78657;
(statearr_78671[(10)] = inst_78630__$1);

return statearr_78671;
})();
if(cljs.core.truth_(inst_78631)){
var statearr_78672_78709 = state_78657__$1;
(statearr_78672_78709[(1)] = (18));

} else {
var statearr_78673_78710 = state_78657__$1;
(statearr_78673_78710[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (3))){
var inst_78655 = (state_78657[(2)]);
var state_78657__$1 = state_78657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78657__$1,inst_78655);
} else {
if((state_val_78658 === (12))){
var inst_78620 = (state_78657[(11)]);
var state_78657__$1 = state_78657;
var statearr_78674_78711 = state_78657__$1;
(statearr_78674_78711[(2)] = inst_78620);

(statearr_78674_78711[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (2))){
var inst_78608 = (state_78657[(12)]);
var _ = (function (){var statearr_78675 = state_78657;
(statearr_78675[(4)] = cljs.core.cons.call(null,(5),(state_78657[(4)])));

return statearr_78675;
})();
var inst_78608__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_78609 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_78608__$1);
var state_78657__$1 = (function (){var statearr_78676 = state_78657;
(statearr_78676[(13)] = inst_78609);

(statearr_78676[(12)] = inst_78608__$1);

return statearr_78676;
})();
if(cljs.core.truth_(opts)){
var statearr_78677_78712 = state_78657__$1;
(statearr_78677_78712[(1)] = (6));

} else {
var statearr_78678_78713 = state_78657__$1;
(statearr_78678_78713[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (19))){
var inst_78630 = (state_78657[(10)]);
var inst_78634 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_78630);
var state_78657__$1 = state_78657;
var statearr_78679_78714 = state_78657__$1;
(statearr_78679_78714[(2)] = inst_78634);

(statearr_78679_78714[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (11))){
var inst_78615 = (state_78657[(9)]);
var inst_78608 = (state_78657[(12)]);
var inst_78640 = (state_78657[(2)]);
var inst_78641 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_78642 = [inst_78640];
var inst_78643 = cljs.core.PersistentHashMap.fromArrays(inst_78641,inst_78642);
var inst_78644 = fluree.db.util.core.without_nils.call(null,inst_78643);
var inst_78645 = cljs.core.merge.call(null,inst_78615,inst_78644);
var inst_78646 = cljs.core.update.call(null,inst_78608,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_78645);
var inst_78647 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_78646);
var state_78657__$1 = state_78657;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78657__$1,(21),inst_78647);
} else {
if((state_val_78658 === (9))){
var inst_78617 = (state_78657[(14)]);
var state_78657__$1 = state_78657;
var statearr_78681_78715 = state_78657__$1;
(statearr_78681_78715[(2)] = inst_78617);

(statearr_78681_78715[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (5))){
var _ = (function (){var statearr_78682 = state_78657;
(statearr_78682[(4)] = cljs.core.rest.call(null,(state_78657[(4)])));

return statearr_78682;
})();
var state_78657__$1 = state_78657;
var ex78680 = (state_78657__$1[(2)]);
var statearr_78683_78716 = state_78657__$1;
(statearr_78683_78716[(5)] = ex78680);


var statearr_78684_78717 = state_78657__$1;
(statearr_78684_78717[(1)] = (4));

(statearr_78684_78717[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (14))){
var inst_78638 = (state_78657[(2)]);
var state_78657__$1 = state_78657;
var statearr_78685_78718 = state_78657__$1;
(statearr_78685_78718[(2)] = inst_78638);

(statearr_78685_78718[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (16))){
var inst_78624 = (state_78657[(8)]);
var inst_78628 = fluree.db.connection_js.validate_token.call(null,conn,inst_78624);
var state_78657__$1 = state_78657;
var statearr_78686_78719 = state_78657__$1;
(statearr_78686_78719[(2)] = inst_78628);

(statearr_78686_78719[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (10))){
var inst_78615 = (state_78657[(9)]);
var inst_78620 = (state_78657[(11)]);
var inst_78620__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_78615);
var state_78657__$1 = (function (){var statearr_78687 = state_78657;
(statearr_78687[(11)] = inst_78620__$1);

return statearr_78687;
})();
if(cljs.core.truth_(inst_78620__$1)){
var statearr_78688_78720 = state_78657__$1;
(statearr_78688_78720[(1)] = (12));

} else {
var statearr_78689_78721 = state_78657__$1;
(statearr_78689_78721[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (18))){
var state_78657__$1 = state_78657;
var statearr_78690_78722 = state_78657__$1;
(statearr_78690_78722[(2)] = null);

(statearr_78690_78722[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78658 === (8))){
var inst_78609 = (state_78657[(13)]);
var inst_78617 = (state_78657[(14)]);
var inst_78615 = (state_78657[(9)]);
var inst_78614 = (state_78657[(2)]);
var inst_78615__$1 = cljs.core.merge.call(null,inst_78609,inst_78614);
var inst_78616 = fluree.db.connection_js.check_connection.call(null,conn,inst_78615__$1);
var inst_78617__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_78615__$1);
var state_78657__$1 = (function (){var statearr_78691 = state_78657;
(statearr_78691[(14)] = inst_78617__$1);

(statearr_78691[(15)] = inst_78616);

(statearr_78691[(9)] = inst_78615__$1);

return statearr_78691;
})();
if(cljs.core.truth_(inst_78617__$1)){
var statearr_78692_78723 = state_78657__$1;
(statearr_78692_78723[(1)] = (9));

} else {
var statearr_78693_78724 = state_78657__$1;
(statearr_78693_78724[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_78694 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78694[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_78694[(1)] = (1));

return statearr_78694;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_78657){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78695){var ex__2749__auto__ = e78695;
var statearr_78696_78725 = state_78657;
(statearr_78696_78725[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78657[(4)]))){
var statearr_78697_78726 = state_78657;
(statearr_78697_78726[(1)] = cljs.core.first.call(null,(state_78657[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78727 = state_78657;
state_78657 = G__78727;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_78657){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_78657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78698 = f__2769__auto__.call(null);
(statearr_78698[(6)] = c__2768__auto__);

return statearr_78698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.blockQuery.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 * to end if provided (exclusive).
 * 
 * Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.blockRange = (function flureenjs$blockRange(var_args){
var G__78729 = arguments.length;
switch (G__78729) {
case 2:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.blockRange', flureenjs.blockRange);

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.blockRange.call(null,db,start,null,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.blockRange.call(null,db,start,end,null);
}));

(flureenjs.blockRange.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78756){
var state_val_78757 = (state_78756[(1)]);
if((state_val_78757 === (1))){
var state_78756__$1 = state_78756;
var statearr_78758_78775 = state_78756__$1;
(statearr_78758_78775[(2)] = null);

(statearr_78758_78775[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78757 === (2))){
var _ = (function (){var statearr_78759 = state_78756;
(statearr_78759[(4)] = cljs.core.cons.call(null,(5),(state_78756[(4)])));

return statearr_78759;
})();
var inst_78741 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_78756__$1 = (function (){var statearr_78760 = state_78756;
(statearr_78760[(7)] = inst_78741);

return statearr_78760;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78756__$1,(7),db);
} else {
if((state_val_78757 === (3))){
var inst_78754 = (state_78756[(2)]);
var state_78756__$1 = state_78756;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78756__$1,inst_78754);
} else {
if((state_val_78757 === (4))){
var inst_78730 = (state_78756[(2)]);
var inst_78731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78732 = [inst_78730];
var inst_78733 = (new cljs.core.PersistentVector(null,1,(5),inst_78731,inst_78732,null));
var inst_78734 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78733);
var inst_78735 = reject.call(null,inst_78730);
var state_78756__$1 = (function (){var statearr_78762 = state_78756;
(statearr_78762[(8)] = inst_78734);

return statearr_78762;
})();
var statearr_78763_78776 = state_78756__$1;
(statearr_78763_78776[(2)] = inst_78735);

(statearr_78763_78776[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78757 === (5))){
var _ = (function (){var statearr_78764 = state_78756;
(statearr_78764[(4)] = cljs.core.rest.call(null,(state_78756[(4)])));

return statearr_78764;
})();
var state_78756__$1 = state_78756;
var ex78761 = (state_78756__$1[(2)]);
var statearr_78765_78777 = state_78756__$1;
(statearr_78765_78777[(5)] = ex78761);


var statearr_78766_78778 = state_78756__$1;
(statearr_78766_78778[(1)] = (4));

(statearr_78766_78778[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78757 === (6))){
var inst_78747 = (state_78756[(2)]);
var inst_78748 = fluree.db.util.async.throw_err.call(null,inst_78747);
var inst_78749 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_78748);
var inst_78750 = cljs.core.clj__GT_js.call(null,inst_78749);
var inst_78751 = resolve.call(null,inst_78750);
var _ = (function (){var statearr_78767 = state_78756;
(statearr_78767[(4)] = cljs.core.rest.call(null,(state_78756[(4)])));

return statearr_78767;
})();
var state_78756__$1 = state_78756;
var statearr_78768_78779 = state_78756__$1;
(statearr_78768_78779[(2)] = inst_78751);

(statearr_78768_78779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78757 === (7))){
var inst_78741 = (state_78756[(7)]);
var inst_78743 = (state_78756[(2)]);
var inst_78744 = fluree.db.util.async.throw_err.call(null,inst_78743);
var inst_78745 = fluree.db.query.block.block_range.call(null,inst_78744,start,end,inst_78741);
var state_78756__$1 = state_78756;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78756__$1,(6),inst_78745);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_78769 = [null,null,null,null,null,null,null,null,null];
(statearr_78769[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_78769[(1)] = (1));

return statearr_78769;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_78756){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78770){var ex__2749__auto__ = e78770;
var statearr_78771_78780 = state_78756;
(statearr_78771_78780[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78756[(4)]))){
var statearr_78772_78781 = state_78756;
(statearr_78772_78781[(1)] = cljs.core.first.call(null,(state_78756[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78782 = state_78756;
state_78756 = G__78782;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_78756){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_78756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78773 = f__2769__auto__.call(null);
(statearr_78773[(6)] = c__2768__auto__);

return statearr_78773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.blockRange.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collectionFlakes = (function flureenjs$collectionFlakes(db,collection){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78808){
var state_val_78809 = (state_78808[(1)]);
if((state_val_78809 === (1))){
var state_78808__$1 = state_78808;
var statearr_78810_78825 = state_78808__$1;
(statearr_78810_78825[(2)] = null);

(statearr_78810_78825[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78809 === (2))){
var _ = (function (){var statearr_78811 = state_78808;
(statearr_78811[(4)] = cljs.core.cons.call(null,(5),(state_78808[(4)])));

return statearr_78811;
})();
var state_78808__$1 = state_78808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78808__$1,(7),db);
} else {
if((state_val_78809 === (3))){
var inst_78806 = (state_78808[(2)]);
var state_78808__$1 = state_78808;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78808__$1,inst_78806);
} else {
if((state_val_78809 === (4))){
var inst_78783 = (state_78808[(2)]);
var inst_78784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78785 = [inst_78783];
var inst_78786 = (new cljs.core.PersistentVector(null,1,(5),inst_78784,inst_78785,null));
var inst_78787 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78786);
var inst_78788 = reject.call(null,inst_78783);
var state_78808__$1 = (function (){var statearr_78813 = state_78808;
(statearr_78813[(7)] = inst_78787);

return statearr_78813;
})();
var statearr_78814_78826 = state_78808__$1;
(statearr_78814_78826[(2)] = inst_78788);

(statearr_78814_78826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78809 === (5))){
var _ = (function (){var statearr_78815 = state_78808;
(statearr_78815[(4)] = cljs.core.rest.call(null,(state_78808[(4)])));

return statearr_78815;
})();
var state_78808__$1 = state_78808;
var ex78812 = (state_78808__$1[(2)]);
var statearr_78816_78827 = state_78808__$1;
(statearr_78816_78827[(5)] = ex78812);


var statearr_78817_78828 = state_78808__$1;
(statearr_78817_78828[(1)] = (4));

(statearr_78817_78828[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78809 === (6))){
var inst_78799 = (state_78808[(2)]);
var inst_78800 = fluree.db.util.async.throw_err.call(null,inst_78799);
var inst_78801 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_78800);
var inst_78802 = cljs.core.clj__GT_js.call(null,inst_78801);
var inst_78803 = resolve.call(null,inst_78802);
var _ = (function (){var statearr_78818 = state_78808;
(statearr_78818[(4)] = cljs.core.rest.call(null,(state_78808[(4)])));

return statearr_78818;
})();
var state_78808__$1 = state_78808;
var statearr_78819_78829 = state_78808__$1;
(statearr_78819_78829[(2)] = inst_78803);

(statearr_78819_78829[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78809 === (7))){
var inst_78795 = (state_78808[(2)]);
var inst_78796 = fluree.db.util.async.throw_err.call(null,inst_78795);
var inst_78797 = fluree.db.query.range.collection.call(null,inst_78796,collection);
var state_78808__$1 = state_78808;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78808__$1,(6),inst_78797);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collectionFlakes_$_state_machine__2746__auto__ = null;
var flureenjs$collectionFlakes_$_state_machine__2746__auto____0 = (function (){
var statearr_78820 = [null,null,null,null,null,null,null,null];
(statearr_78820[(0)] = flureenjs$collectionFlakes_$_state_machine__2746__auto__);

(statearr_78820[(1)] = (1));

return statearr_78820;
});
var flureenjs$collectionFlakes_$_state_machine__2746__auto____1 = (function (state_78808){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78808);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78821){var ex__2749__auto__ = e78821;
var statearr_78822_78830 = state_78808;
(statearr_78822_78830[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78808[(4)]))){
var statearr_78823_78831 = state_78808;
(statearr_78823_78831[(1)] = cljs.core.first.call(null,(state_78808[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__78832 = state_78808;
state_78808 = G__78832;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$collectionFlakes_$_state_machine__2746__auto__ = function(state_78808){
switch(arguments.length){
case 0:
return flureenjs$collectionFlakes_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$collectionFlakes_$_state_machine__2746__auto____1.call(this,state_78808);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collectionFlakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collectionFlakes_$_state_machine__2746__auto____0;
flureenjs$collectionFlakes_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collectionFlakes_$_state_machine__2746__auto____1;
return flureenjs$collectionFlakes_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78824 = f__2769__auto__.call(null);
(statearr_78824[(6)] = c__2768__auto__);

return statearr_78824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.collectionFlakes', flureenjs.collectionFlakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__78834 = arguments.length;
switch (G__78834) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_78939){
var state_val_78940 = (state_78939[(1)]);
if((state_val_78940 === (7))){
var state_78939__$1 = state_78939;
var statearr_78941_78993 = state_78939__$1;
(statearr_78941_78993[(2)] = null);

(statearr_78941_78993[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (20))){
var inst_78863 = (state_78939[(7)]);
var inst_78856 = (state_78939[(8)]);
var inst_78867 = (state_78939[(9)]);
var inst_78888 = cljs.core.dissoc.call(null,inst_78867,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_78889 = cljs.core.assoc.call(null,inst_78888,new cljs.core.Keyword(null,"opts","opts",155075701),inst_78856);
var inst_78890 = fluree.db.api.query.history_query_async.call(null,inst_78863,inst_78889);
var state_78939__$1 = state_78939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78939__$1,(23),inst_78890);
} else {
if((state_val_78940 === (27))){
var inst_78902 = (state_78939[(2)]);
var inst_78903 = fluree.db.util.async.throw_err.call(null,inst_78902);
var state_78939__$1 = state_78939;
var statearr_78942_78994 = state_78939__$1;
(statearr_78942_78994[(2)] = inst_78903);

(statearr_78942_78994[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (1))){
var state_78939__$1 = state_78939;
var statearr_78943_78995 = state_78939__$1;
(statearr_78943_78995[(2)] = null);

(statearr_78943_78995[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (24))){
var inst_78856 = (state_78939[(8)]);
var inst_78867 = (state_78939[(9)]);
var inst_78898 = cljs.core.dissoc.call(null,inst_78867,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_78899 = cljs.core.assoc.call(null,inst_78898,new cljs.core.Keyword(null,"opts","opts",155075701),inst_78856);
var inst_78900 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_78899);
var state_78939__$1 = state_78939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78939__$1,(27),inst_78900);
} else {
if((state_val_78940 === (4))){
var inst_78835 = (state_78939[(2)]);
var inst_78836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78837 = [inst_78835];
var inst_78838 = (new cljs.core.PersistentVector(null,1,(5),inst_78836,inst_78837,null));
var inst_78839 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_78838);
var inst_78840 = cljs.core.clj__GT_js.call(null,inst_78835);
var inst_78841 = reject.call(null,inst_78840);
var state_78939__$1 = (function (){var statearr_78944 = state_78939;
(statearr_78944[(10)] = inst_78839);

return statearr_78944;
})();
var statearr_78945_78996 = state_78939__$1;
(statearr_78945_78996[(2)] = inst_78841);

(statearr_78945_78996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (15))){
var inst_78867 = (state_78939[(9)]);
var inst_78885 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_78867);
var inst_78886 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_78885);
var state_78939__$1 = state_78939;
if(inst_78886){
var statearr_78946_78997 = state_78939__$1;
(statearr_78946_78997[(1)] = (20));

} else {
var statearr_78947_78998 = state_78939__$1;
(statearr_78947_78998[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (21))){
var inst_78867 = (state_78939[(9)]);
var inst_78895 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_78867);
var inst_78896 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_78895);
var state_78939__$1 = state_78939;
if(inst_78896){
var statearr_78948_78999 = state_78939__$1;
(statearr_78948_78999[(1)] = (24));

} else {
var statearr_78949_79000 = state_78939__$1;
(statearr_78949_79000[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (31))){
var inst_78910 = (state_78939[(2)]);
var inst_78911 = fluree.db.util.async.throw_err.call(null,inst_78910);
var state_78939__$1 = state_78939;
var statearr_78950_79001 = state_78939__$1;
(statearr_78950_79001[(2)] = inst_78911);

(statearr_78950_79001[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (32))){
var inst_78860 = (state_78939[(11)]);
var inst_78856 = (state_78939[(8)]);
var inst_78867 = (state_78939[(9)]);
var inst_78914 = cljs.core.dissoc.call(null,inst_78867,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_78915 = cljs.core.assoc.call(null,inst_78914,new cljs.core.Keyword(null,"opts","opts",155075701),inst_78856);
var inst_78916 = fluree.db.api.query.multi_query_async.call(null,inst_78860,inst_78915);
var state_78939__$1 = state_78939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78939__$1,(35),inst_78916);
} else {
if((state_val_78940 === (33))){
var state_78939__$1 = state_78939;
var statearr_78951_79002 = state_78939__$1;
(statearr_78951_79002[(2)] = null);

(statearr_78951_79002[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (13))){
var inst_78932 = (state_78939[(2)]);
var inst_78933 = cljs.core.clj__GT_js.call(null,inst_78932);
var inst_78934 = resolve.call(null,inst_78933);
var _ = (function (){var statearr_78952 = state_78939;
(statearr_78952[(4)] = cljs.core.rest.call(null,(state_78939[(4)])));

return statearr_78952;
})();
var state_78939__$1 = state_78939;
var statearr_78953_79003 = state_78939__$1;
(statearr_78953_79003[(2)] = inst_78934);

(statearr_78953_79003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (22))){
var inst_78928 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
var statearr_78954_79004 = state_78939__$1;
(statearr_78954_79004[(2)] = inst_78928);

(statearr_78954_79004[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (29))){
var state_78939__$1 = state_78939;
var statearr_78955_79005 = state_78939__$1;
(statearr_78955_79005[(1)] = (32));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (6))){
var inst_78852 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_78939__$1 = state_78939;
var statearr_78957_79006 = state_78939__$1;
(statearr_78957_79006[(2)] = inst_78852);

(statearr_78957_79006[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (28))){
var inst_78856 = (state_78939[(8)]);
var inst_78867 = (state_78939[(9)]);
var inst_78907 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_78867);
var inst_78908 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_78907,inst_78856);
var state_78939__$1 = state_78939;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78939__$1,(31),inst_78908);
} else {
if((state_val_78940 === (25))){
var inst_78867 = (state_78939[(9)]);
var inst_78905 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_78867);
var state_78939__$1 = state_78939;
if(cljs.core.truth_(inst_78905)){
var statearr_78958_79007 = state_78939__$1;
(statearr_78958_79007[(1)] = (28));

} else {
var statearr_78959_79008 = state_78939__$1;
(statearr_78959_79008[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (34))){
var inst_78922 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
var statearr_78960_79009 = state_78939__$1;
(statearr_78960_79009[(2)] = inst_78922);

(statearr_78960_79009[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (17))){
var inst_78867 = (state_78939[(9)]);
var inst_78879 = cljs.core.dissoc.call(null,inst_78867,new cljs.core.Keyword(null,"type","type",1174270348));
var state_78939__$1 = state_78939;
var statearr_78961_79010 = state_78939__$1;
(statearr_78961_79010[(2)] = inst_78879);

(statearr_78961_79010[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (3))){
var inst_78937 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_78939__$1,inst_78937);
} else {
if((state_val_78940 === (12))){
var inst_78867 = (state_78939[(9)]);
var inst_78871 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_78872 = (new cljs.core.PersistentArrayMap(null,2,inst_78871,null));
var inst_78873 = (new cljs.core.PersistentHashSet(null,inst_78872,null));
var inst_78874 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_78867);
var inst_78875 = inst_78873.call(null,inst_78874);
var state_78939__$1 = state_78939;
if(cljs.core.truth_(inst_78875)){
var statearr_78962_79011 = state_78939__$1;
(statearr_78962_79011[(1)] = (14));

} else {
var statearr_78963_79012 = state_78939__$1;
(statearr_78963_79012[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (2))){
var inst_78849 = (state_78939[(12)]);
var _ = (function (){var statearr_78964 = state_78939;
(statearr_78964[(4)] = cljs.core.cons.call(null,(5),(state_78939[(4)])));

return statearr_78964;
})();
var inst_78848 = fluree.db.util.json.parse.call(null,param);
var inst_78849__$1 = cljs.core.js__GT_clj.call(null,inst_78848,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_78850 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_78849__$1);
var state_78939__$1 = (function (){var statearr_78965 = state_78939;
(statearr_78965[(12)] = inst_78849__$1);

(statearr_78965[(13)] = inst_78850);

return statearr_78965;
})();
if(cljs.core.truth_(opts)){
var statearr_78966_79013 = state_78939__$1;
(statearr_78966_79013[(1)] = (6));

} else {
var statearr_78967_79014 = state_78939__$1;
(statearr_78967_79014[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (23))){
var inst_78892 = (state_78939[(2)]);
var inst_78893 = fluree.db.util.async.throw_err.call(null,inst_78892);
var state_78939__$1 = state_78939;
var statearr_78968_79015 = state_78939__$1;
(statearr_78968_79015[(2)] = inst_78893);

(statearr_78968_79015[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (35))){
var inst_78918 = (state_78939[(2)]);
var inst_78919 = fluree.db.util.async.throw_err.call(null,inst_78918);
var state_78939__$1 = state_78939;
var statearr_78969_79016 = state_78939__$1;
(statearr_78969_79016[(2)] = inst_78919);

(statearr_78969_79016[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (19))){
var inst_78883 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
var statearr_78970_79017 = state_78939__$1;
(statearr_78970_79017[(2)] = inst_78883);

(statearr_78970_79017[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (11))){
var inst_78867 = (state_78939[(9)]);
var state_78939__$1 = state_78939;
var statearr_78972_79018 = state_78939__$1;
(statearr_78972_79018[(2)] = inst_78867);

(statearr_78972_79018[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (9))){
var inst_78859 = (state_78939[(14)]);
var inst_78863 = (state_78939[(7)]);
var inst_78858 = (state_78939[(15)]);
var inst_78856 = (state_78939[(8)]);
var inst_78862 = (state_78939[(2)]);
var inst_78863__$1 = fluree.db.util.async.throw_err.call(null,inst_78862);
var inst_78864 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_78863__$1,inst_78858,inst_78859,inst_78856);
var state_78939__$1 = (function (){var statearr_78973 = state_78939;
(statearr_78973[(7)] = inst_78863__$1);

return statearr_78973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78939__$1,(10),inst_78864);
} else {
if((state_val_78940 === (5))){
var _ = (function (){var statearr_78974 = state_78939;
(statearr_78974[(4)] = cljs.core.rest.call(null,(state_78939[(4)])));

return statearr_78974;
})();
var state_78939__$1 = state_78939;
var ex78971 = (state_78939__$1[(2)]);
var statearr_78975_79019 = state_78939__$1;
(statearr_78975_79019[(5)] = ex78971);


var statearr_78976_79020 = state_78939__$1;
(statearr_78976_79020[(1)] = (4));

(statearr_78976_79020[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (14))){
var inst_78856 = (state_78939[(8)]);
var inst_78877 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_78856);
var state_78939__$1 = state_78939;
if(cljs.core.truth_(inst_78877)){
var statearr_78977_79021 = state_78939__$1;
(statearr_78977_79021[(1)] = (17));

} else {
var statearr_78978_79022 = state_78939__$1;
(statearr_78978_79022[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (26))){
var inst_78926 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
var statearr_78979_79023 = state_78939__$1;
(statearr_78979_79023[(2)] = inst_78926);

(statearr_78979_79023[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (16))){
var inst_78930 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
var statearr_78980_79024 = state_78939__$1;
(statearr_78980_79024[(2)] = inst_78930);

(statearr_78980_79024[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (30))){
var inst_78924 = (state_78939[(2)]);
var state_78939__$1 = state_78939;
var statearr_78981_79025 = state_78939__$1;
(statearr_78981_79025[(2)] = inst_78924);

(statearr_78981_79025[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (10))){
var inst_78867 = (state_78939[(9)]);
var inst_78866 = (state_78939[(2)]);
var inst_78867__$1 = fluree.db.util.async.throw_err.call(null,inst_78866);
var inst_78868 = fluree.db.util.core.exception_QMARK_.call(null,inst_78867__$1);
var state_78939__$1 = (function (){var statearr_78982 = state_78939;
(statearr_78982[(9)] = inst_78867__$1);

return statearr_78982;
})();
if(inst_78868){
var statearr_78983_79026 = state_78939__$1;
(statearr_78983_79026[(1)] = (11));

} else {
var statearr_78984_79027 = state_78939__$1;
(statearr_78984_79027[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (18))){
var inst_78867 = (state_78939[(9)]);
var inst_78881 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_78867);
var state_78939__$1 = state_78939;
var statearr_78985_79028 = state_78939__$1;
(statearr_78985_79028[(2)] = inst_78881);

(statearr_78985_79028[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_78940 === (8))){
var inst_78849 = (state_78939[(12)]);
var inst_78860 = (state_78939[(11)]);
var inst_78856 = (state_78939[(8)]);
var inst_78850 = (state_78939[(13)]);
var inst_78855 = (state_78939[(2)]);
var inst_78856__$1 = cljs.core.merge.call(null,inst_78850,inst_78855);
var inst_78857 = cljs.core.__destructure_map.call(null,inst_78849);
var inst_78858 = cljs.core.get.call(null,inst_78857,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_78859 = cljs.core.get.call(null,inst_78857,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_78860__$1 = flureenjs._db_instance.call(null,conn,ledger,inst_78856__$1);
var state_78939__$1 = (function (){var statearr_78986 = state_78939;
(statearr_78986[(14)] = inst_78859);

(statearr_78986[(11)] = inst_78860__$1);

(statearr_78986[(15)] = inst_78858);

(statearr_78986[(8)] = inst_78856__$1);

return statearr_78986;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_78939__$1,(9),inst_78860__$1);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_78987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78987[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_78987[(1)] = (1));

return statearr_78987;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_78939){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_78939);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e78988){var ex__2749__auto__ = e78988;
var statearr_78989_79029 = state_78939;
(statearr_78989_79029[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_78939[(4)]))){
var statearr_78990_79030 = state_78939;
(statearr_78990_79030[(1)] = cljs.core.first.call(null,(state_78939[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79031 = state_78939;
state_78939 = G__79031;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_78939){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_78939);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_78991 = f__2769__auto__.call(null);
(statearr_78991[(6)] = c__2768__auto__);

return statearr_78991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.historyQuery = (function flureenjs$historyQuery(var_args){
var G__79033 = arguments.length;
switch (G__79033) {
case 2:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.historyQuery', flureenjs.historyQuery);

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.historyQuery.call(null,sources,query_map,null);
}));

(flureenjs.historyQuery.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_79063){
var state_val_79064 = (state_79063[(1)]);
if((state_val_79064 === (1))){
var state_79063__$1 = state_79063;
var statearr_79065_79081 = state_79063__$1;
(statearr_79065_79081[(2)] = null);

(statearr_79065_79081[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79064 === (2))){
var _ = (function (){var statearr_79066 = state_79063;
(statearr_79066[(4)] = cljs.core.cons.call(null,(5),(state_79063[(4)])));

return statearr_79066;
})();
var inst_79045 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79046 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_79045);
var inst_79047 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79048 = cljs.core.merge.call(null,inst_79046,inst_79047);
var inst_79049 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_79050 = [inst_79048];
var inst_79051 = cljs.core.PersistentHashMap.fromArrays(inst_79049,inst_79050);
var inst_79052 = cljs.core.merge.call(null,inst_79045,inst_79051);
var inst_79053 = fluree.db.api.query.history_query_async.call(null,sources,inst_79052);
var state_79063__$1 = state_79063;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79063__$1,(6),inst_79053);
} else {
if((state_val_79064 === (3))){
var inst_79061 = (state_79063[(2)]);
var state_79063__$1 = state_79063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79063__$1,inst_79061);
} else {
if((state_val_79064 === (4))){
var inst_79034 = (state_79063[(2)]);
var inst_79035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79036 = [inst_79034];
var inst_79037 = (new cljs.core.PersistentVector(null,1,(5),inst_79035,inst_79036,null));
var inst_79038 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79037);
var inst_79039 = reject.call(null,inst_79034);
var state_79063__$1 = (function (){var statearr_79068 = state_79063;
(statearr_79068[(7)] = inst_79038);

return statearr_79068;
})();
var statearr_79069_79082 = state_79063__$1;
(statearr_79069_79082[(2)] = inst_79039);

(statearr_79069_79082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79064 === (5))){
var _ = (function (){var statearr_79070 = state_79063;
(statearr_79070[(4)] = cljs.core.rest.call(null,(state_79063[(4)])));

return statearr_79070;
})();
var state_79063__$1 = state_79063;
var ex79067 = (state_79063__$1[(2)]);
var statearr_79071_79083 = state_79063__$1;
(statearr_79071_79083[(5)] = ex79067);


var statearr_79072_79084 = state_79063__$1;
(statearr_79072_79084[(1)] = (4));

(statearr_79072_79084[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79064 === (6))){
var inst_79055 = (state_79063[(2)]);
var inst_79056 = fluree.db.util.async.throw_err.call(null,inst_79055);
var inst_79057 = cljs.core.clj__GT_js.call(null,inst_79056);
var inst_79058 = resolve.call(null,inst_79057);
var _ = (function (){var statearr_79073 = state_79063;
(statearr_79073[(4)] = cljs.core.rest.call(null,(state_79063[(4)])));

return statearr_79073;
})();
var state_79063__$1 = state_79063;
var statearr_79074_79085 = state_79063__$1;
(statearr_79074_79085[(2)] = inst_79058);

(statearr_79074_79085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_79075 = [null,null,null,null,null,null,null,null];
(statearr_79075[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_79075[(1)] = (1));

return statearr_79075;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_79063){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_79063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e79076){var ex__2749__auto__ = e79076;
var statearr_79077_79086 = state_79063;
(statearr_79077_79086[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_79063[(4)]))){
var statearr_79078_79087 = state_79063;
(statearr_79078_79087[(1)] = cljs.core.first.call(null,(state_79063[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79088 = state_79063;
state_79063 = G__79088;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_79063){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_79063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_79079 = f__2769__auto__.call(null);
(statearr_79079[(6)] = c__2768__auto__);

return statearr_79079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.historyQuery.cljs$lang$maxFixedArity = 3);

flureenjs.multiQuery = (function flureenjs$multiQuery(var_args){
var G__79090 = arguments.length;
switch (G__79090) {
case 2:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multiQuery', flureenjs.multiQuery);

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multiQuery.call(null,source,multi_query_map,null);
}));

(flureenjs.multiQuery.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_79120){
var state_val_79121 = (state_79120[(1)]);
if((state_val_79121 === (1))){
var state_79120__$1 = state_79120;
var statearr_79122_79138 = state_79120__$1;
(statearr_79122_79138[(2)] = null);

(statearr_79122_79138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79121 === (2))){
var _ = (function (){var statearr_79123 = state_79120;
(statearr_79123[(4)] = cljs.core.cons.call(null,(5),(state_79120[(4)])));

return statearr_79123;
})();
var inst_79102 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79103 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_79102);
var inst_79104 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79105 = cljs.core.merge.call(null,inst_79103,inst_79104);
var inst_79106 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_79107 = [inst_79105];
var inst_79108 = cljs.core.PersistentHashMap.fromArrays(inst_79106,inst_79107);
var inst_79109 = cljs.core.merge.call(null,inst_79102,inst_79108);
var inst_79110 = fluree.db.api.query.multi_query_async.call(null,source,inst_79109);
var state_79120__$1 = state_79120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79120__$1,(6),inst_79110);
} else {
if((state_val_79121 === (3))){
var inst_79118 = (state_79120[(2)]);
var state_79120__$1 = state_79120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79120__$1,inst_79118);
} else {
if((state_val_79121 === (4))){
var inst_79091 = (state_79120[(2)]);
var inst_79092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79093 = [inst_79091];
var inst_79094 = (new cljs.core.PersistentVector(null,1,(5),inst_79092,inst_79093,null));
var inst_79095 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79094);
var inst_79096 = reject.call(null,inst_79091);
var state_79120__$1 = (function (){var statearr_79125 = state_79120;
(statearr_79125[(7)] = inst_79095);

return statearr_79125;
})();
var statearr_79126_79139 = state_79120__$1;
(statearr_79126_79139[(2)] = inst_79096);

(statearr_79126_79139[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79121 === (5))){
var _ = (function (){var statearr_79127 = state_79120;
(statearr_79127[(4)] = cljs.core.rest.call(null,(state_79120[(4)])));

return statearr_79127;
})();
var state_79120__$1 = state_79120;
var ex79124 = (state_79120__$1[(2)]);
var statearr_79128_79140 = state_79120__$1;
(statearr_79128_79140[(5)] = ex79124);


var statearr_79129_79141 = state_79120__$1;
(statearr_79129_79141[(1)] = (4));

(statearr_79129_79141[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79121 === (6))){
var inst_79112 = (state_79120[(2)]);
var inst_79113 = fluree.db.util.async.throw_err.call(null,inst_79112);
var inst_79114 = cljs.core.clj__GT_js.call(null,inst_79113);
var inst_79115 = resolve.call(null,inst_79114);
var _ = (function (){var statearr_79130 = state_79120;
(statearr_79130[(4)] = cljs.core.rest.call(null,(state_79120[(4)])));

return statearr_79130;
})();
var state_79120__$1 = state_79120;
var statearr_79131_79142 = state_79120__$1;
(statearr_79131_79142[(2)] = inst_79115);

(statearr_79131_79142[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_79132 = [null,null,null,null,null,null,null,null];
(statearr_79132[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_79132[(1)] = (1));

return statearr_79132;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_79120){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_79120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e79133){var ex__2749__auto__ = e79133;
var statearr_79134_79143 = state_79120;
(statearr_79134_79143[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_79120[(4)]))){
var statearr_79135_79144 = state_79120;
(statearr_79135_79144[(1)] = cljs.core.first.call(null,(state_79120[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79145 = state_79120;
state_79120 = G__79145;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_79120){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_79120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_79136 = f__2769__auto__.call(null);
(statearr_79136[(6)] = c__2768__auto__);

return statearr_79136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.multiQuery.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_79169){
var state_val_79170 = (state_79169[(1)]);
if((state_val_79170 === (1))){
var state_79169__$1 = state_79169;
var statearr_79171_79186 = state_79169__$1;
(statearr_79171_79186[(2)] = null);

(statearr_79171_79186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79170 === (2))){
var _ = (function (){var statearr_79172 = state_79169;
(statearr_79172[(4)] = cljs.core.cons.call(null,(5),(state_79169[(4)])));

return statearr_79172;
})();
var inst_79158 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79159 = fluree.db.api.query.query.call(null,source,inst_79158);
var state_79169__$1 = state_79169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79169__$1,(6),inst_79159);
} else {
if((state_val_79170 === (3))){
var inst_79167 = (state_79169[(2)]);
var state_79169__$1 = state_79169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79169__$1,inst_79167);
} else {
if((state_val_79170 === (4))){
var inst_79146 = (state_79169[(2)]);
var inst_79147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79148 = [inst_79146];
var inst_79149 = (new cljs.core.PersistentVector(null,1,(5),inst_79147,inst_79148,null));
var inst_79150 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79149);
var inst_79151 = cljs.core.clj__GT_js.call(null,inst_79146);
var inst_79152 = reject.call(null,inst_79151);
var state_79169__$1 = (function (){var statearr_79174 = state_79169;
(statearr_79174[(7)] = inst_79150);

return statearr_79174;
})();
var statearr_79175_79187 = state_79169__$1;
(statearr_79175_79187[(2)] = inst_79152);

(statearr_79175_79187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79170 === (5))){
var _ = (function (){var statearr_79176 = state_79169;
(statearr_79176[(4)] = cljs.core.rest.call(null,(state_79169[(4)])));

return statearr_79176;
})();
var state_79169__$1 = state_79169;
var ex79173 = (state_79169__$1[(2)]);
var statearr_79177_79188 = state_79169__$1;
(statearr_79177_79188[(5)] = ex79173);


var statearr_79178_79189 = state_79169__$1;
(statearr_79178_79189[(1)] = (4));

(statearr_79178_79189[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79170 === (6))){
var inst_79161 = (state_79169[(2)]);
var inst_79162 = fluree.db.util.async.throw_err.call(null,inst_79161);
var inst_79163 = cljs.core.clj__GT_js.call(null,inst_79162);
var inst_79164 = resolve.call(null,inst_79163);
var _ = (function (){var statearr_79179 = state_79169;
(statearr_79179[(4)] = cljs.core.rest.call(null,(state_79169[(4)])));

return statearr_79179;
})();
var state_79169__$1 = state_79169;
var statearr_79180_79190 = state_79169__$1;
(statearr_79180_79190[(2)] = inst_79164);

(statearr_79180_79190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__2746__auto__ = null;
var flureenjs$query_$_state_machine__2746__auto____0 = (function (){
var statearr_79181 = [null,null,null,null,null,null,null,null];
(statearr_79181[(0)] = flureenjs$query_$_state_machine__2746__auto__);

(statearr_79181[(1)] = (1));

return statearr_79181;
});
var flureenjs$query_$_state_machine__2746__auto____1 = (function (state_79169){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_79169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e79182){var ex__2749__auto__ = e79182;
var statearr_79183_79191 = state_79169;
(statearr_79183_79191[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_79169[(4)]))){
var statearr_79184_79192 = state_79169;
(statearr_79184_79192[(1)] = cljs.core.first.call(null,(state_79169[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79193 = state_79169;
state_79169 = G__79193;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__2746__auto__ = function(state_79169){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__2746__auto____1.call(this,state_79169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__2746__auto____0;
flureenjs$query_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__2746__auto____1;
return flureenjs$query_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_79185 = f__2769__auto__.call(null);
(statearr_79185[(6)] = c__2768__auto__);

return statearr_79185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *   given flakes applied.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.queryWith = (function flureenjs$queryWith(db,param){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_79226){
var state_val_79227 = (state_79226[(1)]);
if((state_val_79227 === (1))){
var state_79226__$1 = state_79226;
var statearr_79228_79244 = state_79226__$1;
(statearr_79228_79244[(2)] = null);

(statearr_79228_79244[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79227 === (2))){
var _ = (function (){var statearr_79229 = state_79226;
(statearr_79229[(4)] = cljs.core.cons.call(null,(5),(state_79226[(4)])));

return statearr_79229;
})();
var inst_79207 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79208 = cljs.core.__destructure_map.call(null,inst_79207);
var inst_79209 = cljs.core.get.call(null,inst_79208,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_79210 = cljs.core.get.call(null,inst_79208,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_79211 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_79210);
var state_79226__$1 = (function (){var statearr_79230 = state_79226;
(statearr_79230[(7)] = inst_79209);

(statearr_79230[(8)] = inst_79211);

return statearr_79230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79226__$1,(6),db);
} else {
if((state_val_79227 === (3))){
var inst_79224 = (state_79226[(2)]);
var state_79226__$1 = state_79226;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79226__$1,inst_79224);
} else {
if((state_val_79227 === (4))){
var inst_79194 = (state_79226[(2)]);
var inst_79195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79196 = [inst_79194];
var inst_79197 = (new cljs.core.PersistentVector(null,1,(5),inst_79195,inst_79196,null));
var inst_79198 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79197);
var inst_79199 = cljs.core.clj__GT_js.call(null,inst_79194);
var inst_79200 = reject.call(null,inst_79199);
var state_79226__$1 = (function (){var statearr_79232 = state_79226;
(statearr_79232[(9)] = inst_79198);

return statearr_79232;
})();
var statearr_79233_79245 = state_79226__$1;
(statearr_79233_79245[(2)] = inst_79200);

(statearr_79233_79245[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79227 === (5))){
var _ = (function (){var statearr_79234 = state_79226;
(statearr_79234[(4)] = cljs.core.rest.call(null,(state_79226[(4)])));

return statearr_79234;
})();
var state_79226__$1 = state_79226;
var ex79231 = (state_79226__$1[(2)]);
var statearr_79235_79246 = state_79226__$1;
(statearr_79235_79246[(5)] = ex79231);


var statearr_79236_79247 = state_79226__$1;
(statearr_79236_79247[(1)] = (4));

(statearr_79236_79247[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79227 === (6))){
var inst_79209 = (state_79226[(7)]);
var inst_79211 = (state_79226[(8)]);
var inst_79213 = (state_79226[(2)]);
var inst_79214 = fluree.db.util.async.throw_err.call(null,inst_79213);
var inst_79215 = fluree.db.dbproto._forward_time_travel.call(null,inst_79214,inst_79211);
var inst_79216 = fluree.db.api.query.query.call(null,inst_79215,inst_79209);
var state_79226__$1 = state_79226;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79226__$1,(7),inst_79216);
} else {
if((state_val_79227 === (7))){
var inst_79218 = (state_79226[(2)]);
var inst_79219 = fluree.db.util.async.throw_err.call(null,inst_79218);
var inst_79220 = cljs.core.clj__GT_js.call(null,inst_79219);
var inst_79221 = resolve.call(null,inst_79220);
var _ = (function (){var statearr_79237 = state_79226;
(statearr_79237[(4)] = cljs.core.rest.call(null,(state_79226[(4)])));

return statearr_79237;
})();
var state_79226__$1 = state_79226;
var statearr_79238_79248 = state_79226__$1;
(statearr_79238_79248[(2)] = inst_79221);

(statearr_79238_79248[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$queryWith_$_state_machine__2746__auto__ = null;
var flureenjs$queryWith_$_state_machine__2746__auto____0 = (function (){
var statearr_79239 = [null,null,null,null,null,null,null,null,null,null];
(statearr_79239[(0)] = flureenjs$queryWith_$_state_machine__2746__auto__);

(statearr_79239[(1)] = (1));

return statearr_79239;
});
var flureenjs$queryWith_$_state_machine__2746__auto____1 = (function (state_79226){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_79226);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e79240){var ex__2749__auto__ = e79240;
var statearr_79241_79249 = state_79226;
(statearr_79241_79249[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_79226[(4)]))){
var statearr_79242_79250 = state_79226;
(statearr_79242_79250[(1)] = cljs.core.first.call(null,(state_79226[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79251 = state_79226;
state_79226 = G__79251;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$queryWith_$_state_machine__2746__auto__ = function(state_79226){
switch(arguments.length){
case 0:
return flureenjs$queryWith_$_state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$queryWith_$_state_machine__2746__auto____1.call(this,state_79226);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$queryWith_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$queryWith_$_state_machine__2746__auto____0;
flureenjs$queryWith_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$queryWith_$_state_machine__2746__auto____1;
return flureenjs$queryWith_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_79243 = f__2769__auto__.call(null);
(statearr_79243[(6)] = c__2768__auto__);

return statearr_79243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
});
goog.exportSymbol('flureenjs.queryWith', flureenjs.queryWith);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__79253 = arguments.length;
switch (G__79253) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_79286){
var state_val_79287 = (state_79286[(1)]);
if((state_val_79287 === (7))){
var state_79286__$1 = state_79286;
var statearr_79288_79309 = state_79286__$1;
(statearr_79288_79309[(2)] = null);

(statearr_79288_79309[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (1))){
var state_79286__$1 = state_79286;
var statearr_79289_79310 = state_79286__$1;
(statearr_79289_79310[(2)] = null);

(statearr_79289_79310[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (4))){
var inst_79254 = (state_79286[(2)]);
var inst_79255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79256 = [inst_79254];
var inst_79257 = (new cljs.core.PersistentVector(null,1,(5),inst_79255,inst_79256,null));
var inst_79258 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79257);
var inst_79259 = cljs.core.clj__GT_js.call(null,inst_79254);
var inst_79260 = reject.call(null,inst_79259);
var state_79286__$1 = (function (){var statearr_79290 = state_79286;
(statearr_79290[(7)] = inst_79258);

return statearr_79290;
})();
var statearr_79291_79311 = state_79286__$1;
(statearr_79291_79311[(2)] = inst_79260);

(statearr_79291_79311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (6))){
var inst_79270 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_79286__$1 = state_79286;
var statearr_79292_79312 = state_79286__$1;
(statearr_79292_79312[(2)] = inst_79270);

(statearr_79292_79312[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (3))){
var inst_79284 = (state_79286[(2)]);
var state_79286__$1 = state_79286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79286__$1,inst_79284);
} else {
if((state_val_79287 === (2))){
var inst_79267 = (state_79286[(8)]);
var _ = (function (){var statearr_79294 = state_79286;
(statearr_79294[(4)] = cljs.core.cons.call(null,(5),(state_79286[(4)])));

return statearr_79294;
})();
var inst_79266 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_79267__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_79266);
var inst_79268 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_79267__$1);
var state_79286__$1 = (function (){var statearr_79295 = state_79286;
(statearr_79295[(9)] = inst_79268);

(statearr_79295[(8)] = inst_79267__$1);

return statearr_79295;
})();
if(cljs.core.truth_(opts)){
var statearr_79296_79313 = state_79286__$1;
(statearr_79296_79313[(1)] = (6));

} else {
var statearr_79297_79314 = state_79286__$1;
(statearr_79297_79314[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (9))){
var inst_79278 = (state_79286[(2)]);
var inst_79279 = fluree.db.util.async.throw_err.call(null,inst_79278);
var inst_79280 = cljs.core.clj__GT_js.call(null,inst_79279);
var inst_79281 = resolve.call(null,inst_79280);
var _ = (function (){var statearr_79298 = state_79286;
(statearr_79298[(4)] = cljs.core.rest.call(null,(state_79286[(4)])));

return statearr_79298;
})();
var state_79286__$1 = state_79286;
var statearr_79299_79315 = state_79286__$1;
(statearr_79299_79315[(2)] = inst_79281);

(statearr_79299_79315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (5))){
var _ = (function (){var statearr_79300 = state_79286;
(statearr_79300[(4)] = cljs.core.rest.call(null,(state_79286[(4)])));

return statearr_79300;
})();
var state_79286__$1 = state_79286;
var ex79293 = (state_79286__$1[(2)]);
var statearr_79301_79316 = state_79286__$1;
(statearr_79301_79316[(5)] = ex79293);


var statearr_79302_79317 = state_79286__$1;
(statearr_79302_79317[(1)] = (4));

(statearr_79302_79317[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79287 === (8))){
var inst_79268 = (state_79286[(9)]);
var inst_79267 = (state_79286[(8)]);
var inst_79273 = (state_79286[(2)]);
var inst_79274 = cljs.core.merge.call(null,inst_79268,inst_79273);
var inst_79275 = cljs.core.assoc.call(null,inst_79267,new cljs.core.Keyword(null,"opts","opts",155075701),inst_79274);
var inst_79276 = fluree.db.api.query.query_async.call(null,db,inst_79275);
var state_79286__$1 = state_79286;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79286__$1,(9),inst_79276);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_79303 = [null,null,null,null,null,null,null,null,null,null];
(statearr_79303[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_79303[(1)] = (1));

return statearr_79303;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_79286){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_79286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e79304){var ex__2749__auto__ = e79304;
var statearr_79305_79318 = state_79286;
(statearr_79305_79318[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_79286[(4)]))){
var statearr_79306_79319 = state_79286;
(statearr_79306_79319[(1)] = cljs.core.first.call(null,(state_79286[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79320 = state_79286;
state_79286 = G__79320;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_79286){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_79286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_79307 = f__2769__auto__.call(null);
(statearr_79307[(6)] = c__2768__auto__);

return statearr_79307;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__79322 = arguments.length;
switch (G__79322) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_79349){
var state_val_79350 = (state_79349[(1)]);
if((state_val_79350 === (1))){
var state_79349__$1 = state_79349;
var statearr_79351_79367 = state_79349__$1;
(statearr_79351_79367[(2)] = null);

(statearr_79351_79367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79350 === (2))){
var _ = (function (){var statearr_79352 = state_79349;
(statearr_79352[(4)] = cljs.core.cons.call(null,(5),(state_79349[(4)])));

return statearr_79352;
})();
var inst_79335 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_79336 = fluree.db.util.json.parse.call(null,sql_str);
var inst_79337 = fluree.db.query.sql.parse.call(null,inst_79336);
var inst_79338 = cljs.core.update.call(null,inst_79337,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_79335);
var inst_79339 = fluree.db.api.query.query_async.call(null,db,inst_79338);
var state_79349__$1 = state_79349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_79349__$1,(6),inst_79339);
} else {
if((state_val_79350 === (3))){
var inst_79347 = (state_79349[(2)]);
var state_79349__$1 = state_79349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_79349__$1,inst_79347);
} else {
if((state_val_79350 === (4))){
var inst_79323 = (state_79349[(2)]);
var inst_79324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79325 = [inst_79323];
var inst_79326 = (new cljs.core.PersistentVector(null,1,(5),inst_79324,inst_79325,null));
var inst_79327 = fluree.db.util.log.log.call(null,fluree.db.util.log.logger,new cljs.core.Keyword(null,"severe","severe",-1364500238),inst_79326);
var inst_79328 = cljs.core.clj__GT_js.call(null,inst_79323);
var inst_79329 = reject.call(null,inst_79328);
var state_79349__$1 = (function (){var statearr_79354 = state_79349;
(statearr_79354[(7)] = inst_79327);

return statearr_79354;
})();
var statearr_79355_79368 = state_79349__$1;
(statearr_79355_79368[(2)] = inst_79329);

(statearr_79355_79368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79350 === (5))){
var _ = (function (){var statearr_79356 = state_79349;
(statearr_79356[(4)] = cljs.core.rest.call(null,(state_79349[(4)])));

return statearr_79356;
})();
var state_79349__$1 = state_79349;
var ex79353 = (state_79349__$1[(2)]);
var statearr_79357_79369 = state_79349__$1;
(statearr_79357_79369[(5)] = ex79353);


var statearr_79358_79370 = state_79349__$1;
(statearr_79358_79370[(1)] = (4));

(statearr_79358_79370[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_79350 === (6))){
var inst_79341 = (state_79349[(2)]);
var inst_79342 = fluree.db.util.async.throw_err.call(null,inst_79341);
var inst_79343 = cljs.core.clj__GT_js.call(null,inst_79342);
var inst_79344 = resolve.call(null,inst_79343);
var _ = (function (){var statearr_79359 = state_79349;
(statearr_79359[(4)] = cljs.core.rest.call(null,(state_79349[(4)])));

return statearr_79359;
})();
var state_79349__$1 = state_79349;
var statearr_79360_79371 = state_79349__$1;
(statearr_79360_79371[(2)] = inst_79344);

(statearr_79360_79371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2746__auto__ = null;
var flureenjs$state_machine__2746__auto____0 = (function (){
var statearr_79361 = [null,null,null,null,null,null,null,null];
(statearr_79361[(0)] = flureenjs$state_machine__2746__auto__);

(statearr_79361[(1)] = (1));

return statearr_79361;
});
var flureenjs$state_machine__2746__auto____1 = (function (state_79349){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_79349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e79362){var ex__2749__auto__ = e79362;
var statearr_79363_79372 = state_79349;
(statearr_79363_79372[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_79349[(4)]))){
var statearr_79364_79373 = state_79349;
(statearr_79364_79373[(1)] = cljs.core.first.call(null,(state_79349[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__79374 = state_79349;
state_79349 = G__79374;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
flureenjs$state_machine__2746__auto__ = function(state_79349){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2746__auto____0.call(this);
case 1:
return flureenjs$state_machine__2746__auto____1.call(this,state_79349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2746__auto____0;
flureenjs$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2746__auto____1;
return flureenjs$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_79365 = f__2769__auto__.call(null);
(statearr_79365[(6)] = c__2768__auto__);

return statearr_79365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

