// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.spec');
goog.require('cljs.core');
goog.require('fluree.db.util.json');
goog.require('alphabase.core');
goog.require('fluree.db.util.core');
goog.require('clojure.string');
fluree.db.spec.EMAIL = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
fluree.db.spec.safe_name = (function fluree$db$spec$safe_name(x){
try{return cljs.core.name.call(null,x);
}catch (e18331){var e = e18331;
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
}});
/**
 * (type-check type object) transforms an object to match the type. If it
 *   cannot be transformed, it throws an ex-info with a map from paths into the
 *   object to errors encountered at those paths.
 */
fluree.db.spec.type_check = (function fluree$db$spec$type_check(var_args){
var G__18334 = arguments.length;
switch (G__18334) {
case 2:
return fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$2 = (function (object,spec){
var errors = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var conformed = fluree.db.spec.type_check.call(null,object,spec,cljs.core.PersistentVector.EMPTY,errors);
var error_seq = cljs.core.reduce_kv.call(null,(function (e,k,v){
return cljs.core.conj.call(null,e,cljs.core.assoc.call(null,v,new cljs.core.Keyword(null,"path","path",-188191168),k));
}),cljs.core.PersistentVector.EMPTY,cljs.core.deref.call(null,errors));
if(cljs.core.empty_QMARK_.call(null,error_seq)){
return conformed;
} else {
throw cljs.core.ex_info.call(null,["Could not conform object: ",cljs.core.pr_str.call(null,object)," to type ",cljs.core.pr_str.call(null,spec)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"body","body",-2049205669),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.apply.call(null,cljs.core.print_str,"Validation error.",cljs.core.mapv.call(null,(function (p1__18332_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(p1__18332_SHARP_))," at ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.mapv.call(null,fluree.db.spec.safe_name,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(p1__18332_SHARP_))),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.spec.safe_name.call(null,new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(p1__18332_SHARP_)))," but got \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"object","object",1474613949).cljs$core$IFn$_invoke$arity$1(p1__18332_SHARP_)),"\"."].join('');
}),error_seq)),new cljs.core.Keyword(null,"errors","errors",-908790718),error_seq], null)], null));
}
}));

(fluree.db.spec.type_check.cljs$core$IFn$_invoke$arity$4 = (function (object,spec,path,errors_atom){
try{var error = (function() { 
var G__18344__delegate = function (p__18336){
var vec__18337 = p__18336;
var message = cljs.core.nth.call(null,vec__18337,(0),null);
throw cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Invalid object";
}
})(),cljs.core.PersistentArrayMap.EMPTY);
};
var G__18344 = function (var_args){
var p__18336 = null;
if (arguments.length > 0) {
var G__18345__i = 0, G__18345__a = new Array(arguments.length -  0);
while (G__18345__i < G__18345__a.length) {G__18345__a[G__18345__i] = arguments[G__18345__i + 0]; ++G__18345__i;}
  p__18336 = new cljs.core.IndexedSeq(G__18345__a,0,null);
} 
return G__18344__delegate.call(this,p__18336);};
G__18344.cljs$lang$maxFixedArity = 0;
G__18344.cljs$lang$applyTo = (function (arglist__18346){
var p__18336 = cljs.core.seq(arglist__18346);
return G__18344__delegate(p__18336);
});
G__18344.cljs$core$IFn$_invoke$arity$variadic = G__18344__delegate;
return G__18344;
})()
;
var spec__$1 = (((spec instanceof cljs.core.Keyword))?cljs.core.name.call(null,spec):spec);
if((spec__$1 == null)){
if((object == null)){
return object;
} else {
return error.call(null);
}
} else {
if(typeof spec__$1 === 'string'){
var optional = clojure.string.ends_with_QMARK_.call(null,spec__$1,"?");
var base_spec = ((optional)?cljs.core.subs.call(null,spec__$1,(0),(((spec__$1).length) - (1))):spec__$1);
if(((optional) && ((object == null)))){
return null;
} else {
if(cljs.core._EQ_.call(null,base_spec,"any")){
return object;
} else {
if(cljs.core._EQ_.call(null,base_spec,"boolean")){
if(cljs.core.boolean_QMARK_.call(null,object)){
return object;
} else {
return error.call(null);
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"int")){
return (object | (0));
} else {
if(cljs.core._EQ_.call(null,base_spec,"long")){
if(typeof object === 'number'){
return cljs.core.long$.call(null,object);
} else {
if(typeof object === 'string'){
var i = parseInt(object);
if(((((-9007199254740991) <= i)) && ((i <= (9007199254740991))))){
return i;
} else {
return error.call(null,["Long ",object," is outside of javascript max integer size of 2^53 - 1."].join(''));
}
} else {
return error.call(null);

}
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"bigint")){
var i = ((typeof object === 'string')?parseInt(object):object);
if(((typeof i === 'number') && (((((-9007199254740991) <= i)) && ((i <= (9007199254740991))))))){
return i;
} else {
return error.call(null,["Bigintegers are not supported in javascript. max integer size of 2^53 - 1, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(object)].join(''));
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"float")){
if(typeof object === 'number'){
return object;
} else {
if(typeof object === 'string'){
return parseFloat(object);
} else {
return error.call(null);

}
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"double")){
if(typeof object === 'number'){
return object;
} else {
if(typeof object === 'string'){
return parseFloat(object);
} else {
return error.call(null);

}
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"bigdec")){
return error.call(null,["Javascript does not support big decimals. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(object)].join(''));
} else {
if(cljs.core._EQ_.call(null,base_spec,"string")){
if((object instanceof cljs.core.Keyword)){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(object),(1));
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);

}
} else {
if(cljs.core._EQ_.call(null,base_spec,"bytes")){
if(typeof object === 'string'){
var uc = object.toLowerCase();
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[0-9a-f]+$/,uc))){
return uc;
} else {
return error.call(null,"Bytes type must be in hex string form.");
}
} else {
if(cljs.core.sequential_QMARK_.call(null,cljs.core.js__GT_clj.call(null,object))){
return alphabase.core.bytes__GT_hex.call(null,object);
} else {
return error.call(null);

}
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"instant")){
try{return fluree.db.util.core.date__GT_millis.call(null,object);
}catch (e18340){var e = e18340;
return error.call(null);
}} else {
if(cljs.core._EQ_.call(null,base_spec,"uri")){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);
} else {
if(cljs.core._EQ_.call(null,base_spec,"email")){
if(cljs.core.truth_((function (){var and__5043__auto__ = typeof object === 'string';
if(and__5043__auto__){
return cljs.core.re_find.call(null,fluree.db.spec.EMAIL,object);
} else {
return and__5043__auto__;
}
})())){
return object;
} else {
return error.call(null);
}
} else {
if(((cljs.core._EQ_.call(null,base_spec,"tag")) || (cljs.core._EQ_.call(null,base_spec,"ref")))){
return cljs.core.long$.call(null,object);
} else {
if(cljs.core._EQ_.call(null,base_spec,"uuid")){
if(typeof object === 'string'){
return object;
} else {
if(cljs.core.uuid_QMARK_.call(null,object)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(object);
} else {
return error.call(null);

}
}
} else {
if(cljs.core._EQ_.call(null,base_spec,"json")){
try{if(typeof object === 'string'){
fluree.db.util.json.parse.call(null,object);

return object;
} else {
return fluree.db.util.json.stringify.call(null,object);
}
}catch (e18341){var _ = e18341;
return error.call(null);
}} else {
if(cljs.core._EQ_.call(null,base_spec,"geojson")){
try{var parsed = ((typeof object === 'string')?fluree.db.util.json.parse.call(null,object):object);
if(cljs.core.truth_(fluree.db.util.json.valid_geojson_QMARK_.call(null,parsed))){
if(typeof object === 'string'){
return object;
} else {
return fluree.db.util.json.stringify.call(null,object);
}
} else {
return error.call(null);
}
}catch (e18342){var _ = e18342;
return error.call(null);
}} else {
return error.call(null,["Unknown base spec ",base_spec].join(''));

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
} else {
return error.call(null,["Unknown type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(spec__$1)].join(''));

}
}
}catch (e18335){var e = e18335;
cljs.core.swap_BANG_.call(null,errors_atom,cljs.core.assoc,path,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.str.cljs$core$IFn$_invoke$arity$1(e),new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"object","object",1474613949),object], null));

return object;
}}));

(fluree.db.spec.type_check.cljs$lang$maxFixedArity = 4);

