// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.ledger_id = ledger_id;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k26875,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__26879 = k26875;
var G__26879__$1 = (((G__26879 instanceof cljs.core.Keyword))?G__26879.fqn:null);
switch (G__26879__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "ledger-id":
return self__.ledger_id;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k26875,else__5346__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__26880){
var vec__26881 = p__26880;
var k__5367__auto__ = cljs.core.nth.call(null,vec__26881,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__26881,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#fluree.db.session.DbSession{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__26874){
var self__ = this;
var G__26874__$1 = this;
return (new cljs.core.RecordIter((0),G__26874__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this26876,other26877){
var self__ = this;
var this26876__$1 = this;
return (((!((other26877 == null)))) && ((((this26876__$1.constructor === other26877.constructor)) && (((cljs.core._EQ_.call(null,this26876__$1.conn,other26877.conn)) && (((cljs.core._EQ_.call(null,this26876__$1.network,other26877.network)) && (((cljs.core._EQ_.call(null,this26876__$1.ledger_id,other26877.ledger_id)) && (((cljs.core._EQ_.call(null,this26876__$1.db_name,other26877.db_name)) && (((cljs.core._EQ_.call(null,this26876__$1.update_chan,other26877.update_chan)) && (((cljs.core._EQ_.call(null,this26876__$1.transact_chan,other26877.transact_chan)) && (((cljs.core._EQ_.call(null,this26876__$1.state,other26877.state)) && (((cljs.core._EQ_.call(null,this26876__$1.schema_cache,other26877.schema_cache)) && (((cljs.core._EQ_.call(null,this26876__$1.blank_db,other26877.blank_db)) && (((cljs.core._EQ_.call(null,this26876__$1.close,other26877.close)) && (((cljs.core._EQ_.call(null,this26876__$1.id,other26877.id)) && (cljs.core._EQ_.call(null,this26876__$1.__extmap,other26877.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k26875){
var self__ = this;
var this__5350__auto____$1 = this;
var G__26884 = k26875;
var G__26884__$1 = (((G__26884 instanceof cljs.core.Keyword))?G__26884.fqn:null);
switch (G__26884__$1) {
case "conn":
case "network":
case "ledger-id":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k26875);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__26874){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__26885 = cljs.core.keyword_identical_QMARK_;
var expr__26886 = k__5352__auto__;
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__26886))){
return (new fluree.db.session.DbSession(G__26874,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,G__26874,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__26874,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,G__26874,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,G__26874,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,G__26874,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,G__26874,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__26874,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__26874,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__26874,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__26885.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__26886))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__26874,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__26874),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),self__.ledger_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__26874){
var self__ = this;
var this__5342__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.ledger_id,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__26874,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"ledger-id","ledger-id",-949008754,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,ledger_id,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__26878){
var extmap__5385__auto__ = (function (){var G__26888 = cljs.core.dissoc.call(null,G__26878,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__26878)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__26888);
} else {
return G__26888;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__26878),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__26878),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__26891 = session;
var map__26891__$1 = cljs.core.__destructure_map.call(null,map__26891);
var network = cljs.core.get.call(null,map__26891__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__26891__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,ledger_id){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,ledger_id){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,ledger_id], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.ready_QMARK_ = (function fluree$db$session$ready_QMARK_(db_info){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(db_info)));
});
fluree.db.session.load_ledger_info = (function fluree$db$session$load_ledger_info(conn,network,ledger_id){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_26933){
var state_val_26934 = (state_26933[(1)]);
if((state_val_26934 === (7))){
var inst_26907 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not found on this ledger group."].join('');
var inst_26908 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26909 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_26910 = cljs.core.PersistentHashMap.fromArrays(inst_26908,inst_26909);
var inst_26911 = cljs.core.ex_info.call(null,inst_26907,inst_26910);
var inst_26912 = (function(){throw inst_26911})();
var state_26933__$1 = state_26933;
var statearr_26935_26958 = state_26933__$1;
(statearr_26935_26958[(2)] = inst_26912);

(statearr_26935_26958[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (1))){
var state_26933__$1 = state_26933;
var statearr_26936_26959 = state_26933__$1;
(statearr_26936_26959[(2)] = null);

(statearr_26936_26959[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (4))){
var inst_26892 = (state_26933[(2)]);
var state_26933__$1 = state_26933;
var statearr_26937_26960 = state_26933__$1;
(statearr_26937_26960[(2)] = inst_26892);

(statearr_26937_26960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (6))){
var inst_26904 = (state_26933[(7)]);
var inst_26903 = (state_26933[(2)]);
var inst_26904__$1 = fluree.db.util.async.throw_err.call(null,inst_26903);
var inst_26905 = cljs.core.empty_QMARK_.call(null,inst_26904__$1);
var state_26933__$1 = (function (){var statearr_26938 = state_26933;
(statearr_26938[(7)] = inst_26904__$1);

return statearr_26938;
})();
if(inst_26905){
var statearr_26939_26961 = state_26933__$1;
(statearr_26939_26961[(1)] = (7));

} else {
var statearr_26940_26962 = state_26933__$1;
(statearr_26940_26962[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (3))){
var inst_26931 = (state_26933[(2)]);
var state_26933__$1 = state_26933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26933__$1,inst_26931);
} else {
if((state_val_26934 === (12))){
var inst_26926 = (state_26933[(2)]);
var state_26933__$1 = state_26933;
var statearr_26941_26963 = state_26933__$1;
(statearr_26941_26963[(2)] = inst_26926);

(statearr_26941_26963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (2))){
var _ = (function (){var statearr_26942 = state_26933;
(statearr_26942[(4)] = cljs.core.cons.call(null,(5),(state_26933[(4)])));

return statearr_26942;
})();
var inst_26898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26899 = [network,ledger_id];
var inst_26900 = (new cljs.core.PersistentVector(null,2,(5),inst_26898,inst_26899,null));
var inst_26901 = fluree.db.operations.ledger_info_async.call(null,conn,inst_26900);
var state_26933__$1 = state_26933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26933__$1,(6),inst_26901);
} else {
if((state_val_26934 === (11))){
var inst_26904 = (state_26933[(7)]);
var state_26933__$1 = state_26933;
var statearr_26944_26964 = state_26933__$1;
(statearr_26944_26964[(2)] = inst_26904);

(statearr_26944_26964[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (9))){
var inst_26928 = (state_26933[(2)]);
var _ = (function (){var statearr_26945 = state_26933;
(statearr_26945[(4)] = cljs.core.rest.call(null,(state_26933[(4)])));

return statearr_26945;
})();
var state_26933__$1 = state_26933;
var statearr_26946_26965 = state_26933__$1;
(statearr_26946_26965[(2)] = inst_26928);

(statearr_26946_26965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (5))){
var _ = (function (){var statearr_26947 = state_26933;
(statearr_26947[(4)] = cljs.core.rest.call(null,(state_26933[(4)])));

return statearr_26947;
})();
var state_26933__$1 = state_26933;
var ex26943 = (state_26933__$1[(2)]);
var statearr_26948_26966 = state_26933__$1;
(statearr_26948_26966[(5)] = ex26943);


if((ex26943 instanceof Error)){
var statearr_26949_26967 = state_26933__$1;
(statearr_26949_26967[(1)] = (4));

(statearr_26949_26967[(5)] = null);

} else {
throw ex26943;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (10))){
var inst_26904 = (state_26933[(7)]);
var inst_26917 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_26904);
var inst_26918 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26917),"."].join('');
var inst_26919 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26920 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_26921 = cljs.core.PersistentHashMap.fromArrays(inst_26919,inst_26920);
var inst_26922 = cljs.core.ex_info.call(null,inst_26918,inst_26921);
var inst_26923 = (function(){throw inst_26922})();
var state_26933__$1 = state_26933;
var statearr_26950_26968 = state_26933__$1;
(statearr_26950_26968[(2)] = inst_26923);

(statearr_26950_26968[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26934 === (8))){
var inst_26904 = (state_26933[(7)]);
var inst_26914 = fluree.db.session.ready_QMARK_.call(null,inst_26904);
var inst_26915 = (!(inst_26914));
var state_26933__$1 = state_26933;
if(inst_26915){
var statearr_26951_26969 = state_26933__$1;
(statearr_26951_26969[(1)] = (10));

} else {
var statearr_26952_26970 = state_26933__$1;
(statearr_26952_26970[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0 = (function (){
var statearr_26953 = [null,null,null,null,null,null,null,null];
(statearr_26953[(0)] = fluree$db$session$load_ledger_info_$_state_machine__2746__auto__);

(statearr_26953[(1)] = (1));

return statearr_26953;
});
var fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1 = (function (state_26933){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_26933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e26954){var ex__2749__auto__ = e26954;
var statearr_26955_26971 = state_26933;
(statearr_26955_26971[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_26933[(4)]))){
var statearr_26956_26972 = state_26933;
(statearr_26956_26972[(1)] = cljs.core.first.call(null,(state_26933[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26973 = state_26933;
state_26933 = G__26973;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__ = function(state_26933){
switch(arguments.length){
case 0:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1.call(this,state_26933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____0;
fluree$db$session$load_ledger_info_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_ledger_info_$_state_machine__2746__auto____1;
return fluree$db$session$load_ledger_info_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_26957 = f__2769__auto__.call(null);
(statearr_26957[(6)] = c__2768__auto__);

return statearr_26957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
fluree.db.session.load_current_db = (function fluree$db$session$load_current_db(conn,p__26974){
var map__26975 = p__26974;
var map__26975__$1 = cljs.core.__destructure_map.call(null,map__26975);
var blank_db = map__26975__$1;
var network = cljs.core.get.call(null,map__26975__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__26975__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27050){
var state_val_27051 = (state_27050[(1)]);
if((state_val_27051 === (7))){
var inst_26993 = (state_27050[(7)]);
var inst_26992 = (state_27050[(2)]);
var inst_26993__$1 = fluree.db.util.async.throw_err.call(null,inst_26992);
var state_27050__$1 = (function (){var statearr_27052 = state_27050;
(statearr_27052[(7)] = inst_26993__$1);

return statearr_27052;
})();
if(cljs.core.truth_(inst_26993__$1)){
var statearr_27053_27088 = state_27050__$1;
(statearr_27053_27088[(1)] = (8));

} else {
var statearr_27054_27089 = state_27050__$1;
(statearr_27054_27089[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (20))){
var inst_26998 = (state_27050[(8)]);
var inst_27031 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26998)," for ledger: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27032 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27033 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27034 = cljs.core.PersistentHashMap.fromArrays(inst_27032,inst_27033);
var inst_27035 = cljs.core.ex_info.call(null,inst_27031,inst_27034);
var inst_27036 = (function(){throw inst_27035})();
var state_27050__$1 = state_27050;
var statearr_27055_27090 = state_27050__$1;
(statearr_27055_27090[(2)] = inst_27036);

(statearr_27055_27090[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (1))){
var state_27050__$1 = state_27050;
var statearr_27056_27091 = state_27050__$1;
(statearr_27056_27091[(2)] = null);

(statearr_27056_27091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (4))){
var inst_26976 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
var statearr_27057_27092 = state_27050__$1;
(statearr_27057_27092[(2)] = inst_26976);

(statearr_27057_27092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (15))){
var inst_27040 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
var statearr_27058_27093 = state_27050__$1;
(statearr_27058_27093[(2)] = inst_27040);

(statearr_27058_27093[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (21))){
var inst_27038 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
var statearr_27059_27094 = state_27050__$1;
(statearr_27059_27094[(2)] = inst_27038);

(statearr_27059_27094[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (13))){
var inst_26997 = (state_27050[(9)]);
var inst_27002 = fluree.db.query.schema.schema_map.call(null,inst_26997);
var inst_27003 = fluree.db.query.schema.setting_map.call(null,inst_26997);
var inst_27004 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(inst_26997);
var inst_27005 = cljs.core.swap_BANG_.call(null,inst_27004,cljs.core.empty);
var state_27050__$1 = (function (){var statearr_27060 = state_27050;
(statearr_27060[(10)] = inst_27005);

(statearr_27060[(11)] = inst_27003);

return statearr_27060;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(16),inst_27002);
} else {
if((state_val_27051 === (22))){
var inst_26998 = (state_27050[(8)]);
var inst_27026 = (state_27050[(2)]);
var inst_27027 = fluree.db.util.async.throw_err.call(null,inst_27026);
var inst_27028 = (inst_26998 + (1));
var inst_26997 = inst_27027;
var inst_26998__$1 = inst_27028;
var state_27050__$1 = (function (){var statearr_27061 = state_27050;
(statearr_27061[(8)] = inst_26998__$1);

(statearr_27061[(9)] = inst_26997);

return statearr_27061;
})();
var statearr_27062_27095 = state_27050__$1;
(statearr_27062_27095[(2)] = null);

(statearr_27062_27095[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (6))){
var inst_26985 = (state_27050[(2)]);
var inst_26986 = fluree.db.util.async.throw_err.call(null,inst_26985);
var inst_26987 = cljs.core.__destructure_map.call(null,inst_26986);
var inst_26988 = cljs.core.get.call(null,inst_26987,new cljs.core.Keyword(null,"block","block",664686210));
var inst_26989 = cljs.core.get.call(null,inst_26987,new cljs.core.Keyword(null,"index","index",-1531685915));
var inst_26990 = fluree.db.storage.core.reify_db.call(null,conn,network,ledger_id,blank_db,inst_26989);
var state_27050__$1 = (function (){var statearr_27063 = state_27050;
(statearr_27063[(12)] = inst_26988);

return statearr_27063;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(7),inst_26990);
} else {
if((state_val_27051 === (17))){
var inst_26997 = (state_27050[(9)]);
var inst_27008 = (state_27050[(13)]);
var inst_27010 = (state_27050[(2)]);
var inst_27011 = fluree.db.util.async.throw_err.call(null,inst_27010);
var inst_27012 = cljs.core.assoc.call(null,inst_26997,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27008,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27011);
var state_27050__$1 = state_27050;
var statearr_27064_27096 = state_27050__$1;
(statearr_27064_27096[(2)] = inst_27012);

(statearr_27064_27096[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (3))){
var inst_27048 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27050__$1,inst_27048);
} else {
if((state_val_27051 === (12))){
var inst_27042 = (state_27050[(2)]);
var state_27050__$1 = state_27050;
var statearr_27065_27097 = state_27050__$1;
(statearr_27065_27097[(2)] = inst_27042);

(statearr_27065_27097[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (2))){
var _ = (function (){var statearr_27066 = state_27050;
(statearr_27066[(4)] = cljs.core.cons.call(null,(5),(state_27050[(4)])));

return statearr_27066;
})();
var inst_26983 = fluree.db.session.load_ledger_info.call(null,conn,network,ledger_id);
var state_27050__$1 = state_27050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(6),inst_26983);
} else {
if((state_val_27051 === (19))){
var inst_26997 = (state_27050[(9)]);
var inst_27017 = (state_27050[(14)]);
var inst_27020 = cljs.core.__destructure_map.call(null,inst_27017);
var inst_27021 = cljs.core.get.call(null,inst_27020,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27022 = cljs.core.get.call(null,inst_27020,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27023 = cljs.core.get.call(null,inst_27020,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27024 = fluree.db.dbproto._with.call(null,inst_26997,inst_27022,inst_27021);
var state_27050__$1 = (function (){var statearr_27067 = state_27050;
(statearr_27067[(15)] = inst_27023);

return statearr_27067;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(22),inst_27024);
} else {
if((state_val_27051 === (11))){
var inst_26998 = (state_27050[(8)]);
var inst_26988 = (state_27050[(12)]);
var inst_27000 = (inst_26998 > inst_26988);
var state_27050__$1 = state_27050;
if(cljs.core.truth_(inst_27000)){
var statearr_27069_27098 = state_27050__$1;
(statearr_27069_27098[(1)] = (13));

} else {
var statearr_27070_27099 = state_27050__$1;
(statearr_27070_27099[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (9))){
var state_27050__$1 = state_27050;
var statearr_27071_27100 = state_27050__$1;
(statearr_27071_27100[(2)] = null);

(statearr_27071_27100[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (5))){
var _ = (function (){var statearr_27072 = state_27050;
(statearr_27072[(4)] = cljs.core.rest.call(null,(state_27050[(4)])));

return statearr_27072;
})();
var state_27050__$1 = state_27050;
var ex27068 = (state_27050__$1[(2)]);
var statearr_27073_27101 = state_27050__$1;
(statearr_27073_27101[(5)] = ex27068);


if((ex27068 instanceof Error)){
var statearr_27074_27102 = state_27050__$1;
(statearr_27074_27102[(1)] = (4));

(statearr_27074_27102[(5)] = null);

} else {
throw ex27068;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (14))){
var inst_26998 = (state_27050[(8)]);
var inst_27014 = fluree.db.storage.core.read_block.call(null,conn,network,ledger_id,inst_26998);
var state_27050__$1 = state_27050;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(18),inst_27014);
} else {
if((state_val_27051 === (16))){
var inst_27003 = (state_27050[(11)]);
var inst_27007 = (state_27050[(2)]);
var inst_27008 = fluree.db.util.async.throw_err.call(null,inst_27007);
var state_27050__$1 = (function (){var statearr_27075 = state_27050;
(statearr_27075[(13)] = inst_27008);

return statearr_27075;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27050__$1,(17),inst_27003);
} else {
if((state_val_27051 === (10))){
var inst_27045 = (state_27050[(2)]);
var _ = (function (){var statearr_27076 = state_27050;
(statearr_27076[(4)] = cljs.core.rest.call(null,(state_27050[(4)])));

return statearr_27076;
})();
var state_27050__$1 = state_27050;
var statearr_27077_27103 = state_27050__$1;
(statearr_27077_27103[(2)] = inst_27045);

(statearr_27077_27103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (18))){
var inst_27017 = (state_27050[(14)]);
var inst_27016 = (state_27050[(2)]);
var inst_27017__$1 = fluree.db.util.async.throw_err.call(null,inst_27016);
var state_27050__$1 = (function (){var statearr_27078 = state_27050;
(statearr_27078[(14)] = inst_27017__$1);

return statearr_27078;
})();
if(cljs.core.truth_(inst_27017__$1)){
var statearr_27079_27104 = state_27050__$1;
(statearr_27079_27104[(1)] = (19));

} else {
var statearr_27080_27105 = state_27050__$1;
(statearr_27080_27105[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27051 === (8))){
var inst_26993 = (state_27050[(7)]);
var inst_26995 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_26993);
var inst_26996 = (inst_26995 + (1));
var inst_26997 = inst_26993;
var inst_26998 = inst_26996;
var state_27050__$1 = (function (){var statearr_27081 = state_27050;
(statearr_27081[(8)] = inst_26998);

(statearr_27081[(9)] = inst_26997);

return statearr_27081;
})();
var statearr_27082_27106 = state_27050__$1;
(statearr_27082_27106[(2)] = null);

(statearr_27082_27106[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$load_current_db_$_state_machine__2746__auto__ = null;
var fluree$db$session$load_current_db_$_state_machine__2746__auto____0 = (function (){
var statearr_27083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27083[(0)] = fluree$db$session$load_current_db_$_state_machine__2746__auto__);

(statearr_27083[(1)] = (1));

return statearr_27083;
});
var fluree$db$session$load_current_db_$_state_machine__2746__auto____1 = (function (state_27050){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27050);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27084){var ex__2749__auto__ = e27084;
var statearr_27085_27107 = state_27050;
(statearr_27085_27107[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27050[(4)]))){
var statearr_27086_27108 = state_27050;
(statearr_27086_27108[(1)] = cljs.core.first.call(null,(state_27050[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27109 = state_27050;
state_27050 = G__27109;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$load_current_db_$_state_machine__2746__auto__ = function(state_27050){
switch(arguments.length){
case 0:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$load_current_db_$_state_machine__2746__auto____1.call(this,state_27050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$load_current_db_$_state_machine__2746__auto____0;
fluree$db$session$load_current_db_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$load_current_db_$_state_machine__2746__auto____1;
return fluree$db$session$load_current_db_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27087 = f__2769__auto__.call(null);
(statearr_27087[(6)] = c__2768__auto__);

return statearr_27087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Perform a compare and set operation to update the db stored in the session
 *   argument's state atom. Update the cache to `new-db-ch`, but only if the
 *   previously stored db channel is the same as the `old-db-ch`. Returns a boolean
 *   indicating whether the cache was updated.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(p__27110,old_db_ch,new_db_ch){
var map__27111 = p__27110;
var map__27111__$1 = cljs.core.__destructure_map.call(null,map__27111);
var state = cljs.core.get.call(null,map__27111__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core._EQ_.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (p__27112){
var map__27113 = p__27112;
var map__27113__$1 = cljs.core.__destructure_map.call(null,map__27113);
var s = map__27113__$1;
var current = cljs.core.get.call(null,map__27113__$1,new cljs.core.Keyword("db","current","db/current",-1088041545));
if(cljs.core._EQ_.call(null,current,old_db_ch)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),new_db_ch);
} else {
return s;
}
}))),new_db_ch);
});
/**
 * Clears db channel from session state, forcing a new full load next time db
 *   channel is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(p__27114){
var map__27115 = p__27114;
var map__27115__$1 = cljs.core.__destructure_map.call(null,map__27115);
var state = cljs.core.get.call(null,map__27115__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
});
/**
 * Clears any cached database channels and forces an immediate reload. Returns a
 *   channel that will contain the newly loaded database
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(p__27116){
var map__27117 = p__27116;
var map__27117__$1 = cljs.core.__destructure_map.call(null,map__27117);
var conn = cljs.core.get.call(null,map__27117__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var blank_db = cljs.core.get.call(null,map__27117__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
var state = cljs.core.get.call(null,map__27117__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var db_ch = cljs.core.async.promise_chan.call(null);
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),db_ch);

var c__2768__auto___27154 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27137){
var state_val_27138 = (state_27137[(1)]);
if((state_val_27138 === (1))){
var state_27137__$1 = state_27137;
var statearr_27139_27155 = state_27137__$1;
(statearr_27139_27155[(2)] = null);

(statearr_27139_27155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (2))){
var _ = (function (){var statearr_27140 = state_27137;
(statearr_27140[(4)] = cljs.core.cons.call(null,(5),(state_27137[(4)])));

return statearr_27140;
})();
var inst_27127 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27137__$1 = state_27137;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27137__$1,(6),inst_27127);
} else {
if((state_val_27138 === (3))){
var inst_27135 = (state_27137[(2)]);
var state_27137__$1 = state_27137;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27137__$1,inst_27135);
} else {
if((state_val_27138 === (4))){
var inst_27118 = (state_27137[(2)]);
var inst_27119 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27120 = fluree.db.util.log.error.call(null,inst_27118,"Error reloading db");
var inst_27121 = cljs.core.async.put_BANG_.call(null,db_ch,inst_27118);
var state_27137__$1 = (function (){var statearr_27142 = state_27137;
(statearr_27142[(7)] = inst_27119);

(statearr_27142[(8)] = inst_27120);

return statearr_27142;
})();
var statearr_27143_27156 = state_27137__$1;
(statearr_27143_27156[(2)] = inst_27121);

(statearr_27143_27156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (5))){
var _ = (function (){var statearr_27144 = state_27137;
(statearr_27144[(4)] = cljs.core.rest.call(null,(state_27137[(4)])));

return statearr_27144;
})();
var state_27137__$1 = state_27137;
var ex27141 = (state_27137__$1[(2)]);
var statearr_27145_27157 = state_27137__$1;
(statearr_27145_27157[(5)] = ex27141);


var statearr_27146_27158 = state_27137__$1;
(statearr_27146_27158[(1)] = (4));

(statearr_27146_27158[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27138 === (6))){
var inst_27129 = (state_27137[(2)]);
var inst_27130 = fluree.db.util.async.throw_err.call(null,inst_27129);
var state_27137__$1 = state_27137;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27137__$1,(7),db_ch,inst_27130);
} else {
if((state_val_27138 === (7))){
var inst_27132 = (state_27137[(2)]);
var _ = (function (){var statearr_27147 = state_27137;
(statearr_27147[(4)] = cljs.core.rest.call(null,(state_27137[(4)])));

return statearr_27147;
})();
var state_27137__$1 = state_27137;
var statearr_27148_27159 = state_27137__$1;
(statearr_27148_27159[(2)] = inst_27132);

(statearr_27148_27159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = null;
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0 = (function (){
var statearr_27149 = [null,null,null,null,null,null,null,null,null];
(statearr_27149[(0)] = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__);

(statearr_27149[(1)] = (1));

return statearr_27149;
});
var fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1 = (function (state_27137){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27137);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27150){var ex__2749__auto__ = e27150;
var statearr_27151_27160 = state_27137;
(statearr_27151_27160[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27137[(4)]))){
var statearr_27152_27161 = state_27137;
(statearr_27152_27161[(1)] = cljs.core.first.call(null,(state_27137[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27162 = state_27137;
state_27137 = G__27162;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__ = function(state_27137){
switch(arguments.length){
case 0:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1.call(this,state_27137);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____0;
fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$reload_db_BANG__$_state_machine__2746__auto____1;
return fluree$db$session$reload_db_BANG__$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27153 = f__2769__auto__.call(null);
(statearr_27153[(6)] = c__2768__auto___27154);

return statearr_27153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return db_ch;
});
/**
 * Gets the channel containing the current database from the session's state. If
 *   no database channel is cached then the current database is loaded form storage
 *   and a new channel containing it is cached. Returns the cached channel that
 *   will contain the current database
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(var_args){
var G__27164 = arguments.length;
switch (G__27164) {
case 1:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 = (function (p__27165){
var map__27166 = p__27165;
var map__27166__$1 = cljs.core.__destructure_map.call(null,map__27166);
var session = map__27166__$1;
var blank_db = cljs.core.get.call(null,map__27166__$1,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534));
return fluree.db.session.current_db.call(null,session,blank_db);
}));

(fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$2 = (function (p__27167,blank_db){
var map__27168 = p__27167;
var map__27168__$1 = cljs.core.__destructure_map.call(null,map__27168);
var session = map__27168__$1;
var conn = cljs.core.get.call(null,map__27168__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var state = cljs.core.get.call(null,map__27168__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
cljs.core.swap_BANG_.call(null,state,(function (s){
return cljs.core.update.call(null,cljs.core.assoc.call(null,s,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null)),new cljs.core.Keyword("req","count","req/count",2145574363),cljs.core.inc);
}));

var or__5045__auto__ = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var cur_ch = cljs.core.async.promise_chan.call(null);
var state_ch = new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(cljs.core.swap_BANG_.call(null,state,(function (s){
if(cljs.core.not.call(null,new cljs.core.Keyword("db","current","db/current",-1088041545).cljs$core$IFn$_invoke$arity$1(s))){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_ch);
} else {
return s;
}
})));
if(cljs.core._EQ_.call(null,cur_ch,state_ch)){
var c__2768__auto___27206 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27188){
var state_val_27189 = (state_27188[(1)]);
if((state_val_27189 === (1))){
var state_27188__$1 = state_27188;
var statearr_27190_27207 = state_27188__$1;
(statearr_27190_27207[(2)] = null);

(statearr_27190_27207[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27189 === (2))){
var _ = (function (){var statearr_27191 = state_27188;
(statearr_27191[(4)] = cljs.core.cons.call(null,(5),(state_27188[(4)])));

return statearr_27191;
})();
var inst_27178 = fluree.db.session.load_current_db.call(null,conn,blank_db);
var state_27188__$1 = state_27188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27188__$1,(6),inst_27178);
} else {
if((state_val_27189 === (3))){
var inst_27186 = (state_27188[(2)]);
var state_27188__$1 = state_27188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27188__$1,inst_27186);
} else {
if((state_val_27189 === (4))){
var inst_27169 = (state_27188[(2)]);
var inst_27170 = cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword("db","current","db/current",-1088041545),null);
var inst_27171 = fluree.db.util.log.error.call(null,inst_27169,"Error loading current db");
var inst_27172 = cljs.core.async.put_BANG_.call(null,cur_ch,inst_27169);
var state_27188__$1 = (function (){var statearr_27193 = state_27188;
(statearr_27193[(7)] = inst_27171);

(statearr_27193[(8)] = inst_27170);

return statearr_27193;
})();
var statearr_27194_27208 = state_27188__$1;
(statearr_27194_27208[(2)] = inst_27172);

(statearr_27194_27208[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27189 === (5))){
var _ = (function (){var statearr_27195 = state_27188;
(statearr_27195[(4)] = cljs.core.rest.call(null,(state_27188[(4)])));

return statearr_27195;
})();
var state_27188__$1 = state_27188;
var ex27192 = (state_27188__$1[(2)]);
var statearr_27196_27209 = state_27188__$1;
(statearr_27196_27209[(5)] = ex27192);


var statearr_27197_27210 = state_27188__$1;
(statearr_27197_27210[(1)] = (4));

(statearr_27197_27210[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27189 === (6))){
var inst_27180 = (state_27188[(2)]);
var inst_27181 = fluree.db.util.async.throw_err.call(null,inst_27180);
var state_27188__$1 = state_27188;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_27188__$1,(7),cur_ch,inst_27181);
} else {
if((state_val_27189 === (7))){
var inst_27183 = (state_27188[(2)]);
var _ = (function (){var statearr_27198 = state_27188;
(statearr_27198[(4)] = cljs.core.rest.call(null,(state_27188[(4)])));

return statearr_27198;
})();
var state_27188__$1 = state_27188;
var statearr_27199_27211 = state_27188__$1;
(statearr_27199_27211[(2)] = inst_27183);

(statearr_27199_27211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27200 = [null,null,null,null,null,null,null,null,null];
(statearr_27200[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27200[(1)] = (1));

return statearr_27200;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27188){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27201){var ex__2749__auto__ = e27201;
var statearr_27202_27212 = state_27188;
(statearr_27202_27212[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27188[(4)]))){
var statearr_27203_27213 = state_27188;
(statearr_27203_27213[(1)] = cljs.core.first.call(null,(state_27188[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27214 = state_27188;
state_27188 = G__27214;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27188){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27204 = f__2769__auto__.call(null);
(statearr_27204[(6)] = c__2768__auto___27206);

return statearr_27204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return cur_ch;
} else {
return state_ch;
}
}
}));

(fluree.db.session.current_db.cljs$lang$maxFixedArity = 2);

/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_promise_ch = (function fluree$db$session$indexing_promise_ch(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock. Returns two-tuple of [lock? promise-chan]
 *   where lock? indicates if the lock was successful, and promise-chan is whatever
 *   promise-chan is registered for indexing.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,pc){
var swap_res = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),pc);
} else {
return s;
}
}));
var res_pc = new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(swap_res);
var lock_QMARK_ = cljs.core._EQ_.call(null,pc,res_pc);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lock_QMARK_,res_pc], null);
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
}));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__5045__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var ledger_id = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),ledger_id);

return ledger_id;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__5043__auto__ = network;
if(cljs.core.truth_(and__5043__auto__)){
return maybe_alias;
} else {
return and__5043__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__5642__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__5643__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__5644__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__5645__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__5646__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__5646__auto__,method_table__5642__auto__,prefer_table__5643__auto__,method_cache__5644__auto__,cached_hierarchy__5645__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27216){
var state_val_27217 = (state_27216[(1)]);
if((state_val_27217 === (1))){
var state_27216__$1 = state_27216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27216__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27218 = [null,null,null,null,null,null,null];
(statearr_27218[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27218[(1)] = (1));

return statearr_27218;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27216){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27219){var ex__2749__auto__ = e27219;
var statearr_27220_27223 = state_27216;
(statearr_27220_27223[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27216[(4)]))){
var statearr_27221_27224 = state_27216;
(statearr_27221_27224[(1)] = cljs.core.first.call(null,(state_27216[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27225 = state_27216;
state_27216 = G__27225;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27216){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27222 = f__2769__auto__.call(null);
(statearr_27222[(6)] = c__2768__auto__);

return statearr_27222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27226){
var map__27227 = p__27226;
var map__27227__$1 = cljs.core.__destructure_map.call(null,map__27227);
var data = map__27227__$1;
var block = cljs.core.get.call(null,map__27227__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27227__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27227__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27286){
var state_val_27287 = (state_27286[(1)]);
if((state_val_27287 === (7))){
var inst_27238 = (state_27286[(7)]);
var inst_27241 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27242 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27243 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27241),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27242),": Received block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current at block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27238),". No-op."].join('');
var inst_27244 = fluree.db.util.log.info.call(null,inst_27243);
var state_27286__$1 = state_27286;
var statearr_27288_27322 = state_27286__$1;
(statearr_27288_27322[(2)] = inst_27244);

(statearr_27288_27322[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (1))){
var state_27286__$1 = state_27286;
var statearr_27289_27323 = state_27286__$1;
(statearr_27289_27323[(2)] = null);

(statearr_27289_27323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (4))){
var inst_27228 = (state_27286[(2)]);
var state_27286__$1 = state_27286;
var statearr_27290_27324 = state_27286__$1;
(statearr_27290_27324[(2)] = inst_27228);

(statearr_27290_27324[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (15))){
var inst_27267 = (state_27286[(2)]);
var state_27286__$1 = state_27286;
var statearr_27291_27325 = state_27286__$1;
(statearr_27291_27325[(2)] = inst_27267);

(statearr_27291_27325[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (13))){
var inst_27258 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27260 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27261 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27262 = [inst_27260,inst_27261];
var inst_27263 = (new cljs.core.PersistentVector(null,2,(5),inst_27259,inst_27262,null));
var inst_27264 = fluree.db.conn_events.process_event.call(null,inst_27258,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27263,data);
var state_27286__$1 = state_27286;
var statearr_27292_27326 = state_27286__$1;
(statearr_27292_27326[(2)] = inst_27264);

(statearr_27292_27326[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (6))){
var inst_27237 = (state_27286[(8)]);
var inst_27238 = (state_27286[(7)]);
var inst_27236 = (state_27286[(2)]);
var inst_27237__$1 = fluree.db.util.async.throw_err.call(null,inst_27236);
var inst_27238__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27237__$1);
var inst_27239 = (block <= inst_27238__$1);
var state_27286__$1 = (function (){var statearr_27293 = state_27286;
(statearr_27293[(8)] = inst_27237__$1);

(statearr_27293[(7)] = inst_27238__$1);

return statearr_27293;
})();
if(cljs.core.truth_(inst_27239)){
var statearr_27294_27327 = state_27286__$1;
(statearr_27294_27327[(1)] = (7));

} else {
var statearr_27295_27328 = state_27286__$1;
(statearr_27295_27328[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (17))){
var state_27286__$1 = state_27286;
var statearr_27296_27329 = state_27286__$1;
(statearr_27296_27329[(2)] = null);

(statearr_27296_27329[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (3))){
var inst_27284 = (state_27286[(2)]);
var state_27286__$1 = state_27286;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27286__$1,inst_27284);
} else {
if((state_val_27287 === (12))){
var inst_27279 = (state_27286[(2)]);
var state_27286__$1 = state_27286;
var statearr_27297_27330 = state_27286__$1;
(statearr_27297_27330[(2)] = inst_27279);

(statearr_27297_27330[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (2))){
var inst_27234 = (state_27286[(9)]);
var _ = (function (){var statearr_27298 = state_27286;
(statearr_27298[(4)] = cljs.core.cons.call(null,(5),(state_27286[(4)])));

return statearr_27298;
})();
var inst_27234__$1 = fluree.db.session.current_db.call(null,session);
var state_27286__$1 = (function (){var statearr_27299 = state_27286;
(statearr_27299[(9)] = inst_27234__$1);

return statearr_27299;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27286__$1,(6),inst_27234__$1);
} else {
if((state_val_27287 === (11))){
var state_27286__$1 = state_27286;
var statearr_27301_27331 = state_27286__$1;
(statearr_27301_27331[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (9))){
var inst_27281 = (state_27286[(2)]);
var _ = (function (){var statearr_27303 = state_27286;
(statearr_27303[(4)] = cljs.core.rest.call(null,(state_27286[(4)])));

return statearr_27303;
})();
var state_27286__$1 = state_27286;
var statearr_27304_27332 = state_27286__$1;
(statearr_27304_27332[(2)] = inst_27281);

(statearr_27304_27332[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (5))){
var _ = (function (){var statearr_27305 = state_27286;
(statearr_27305[(4)] = cljs.core.rest.call(null,(state_27286[(4)])));

return statearr_27305;
})();
var state_27286__$1 = state_27286;
var ex27300 = (state_27286__$1[(2)]);
var statearr_27306_27333 = state_27286__$1;
(statearr_27306_27333[(5)] = ex27300);


if((ex27300 instanceof Error)){
var statearr_27307_27334 = state_27286__$1;
(statearr_27307_27334[(1)] = (4));

(statearr_27307_27334[(5)] = null);

} else {
throw ex27300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (14))){
var state_27286__$1 = state_27286;
var statearr_27308_27335 = state_27286__$1;
(statearr_27308_27335[(2)] = null);

(statearr_27308_27335[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (16))){
var inst_27238 = (state_27286[(7)]);
var inst_27270 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27271 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27272 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27270),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27271),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27238),". Forcing a db reload."].join('');
var inst_27273 = fluree.db.util.log.info.call(null,inst_27272);
var inst_27274 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27286__$1 = (function (){var statearr_27309 = state_27286;
(statearr_27309[(10)] = inst_27273);

return statearr_27309;
})();
var statearr_27310_27336 = state_27286__$1;
(statearr_27310_27336[(2)] = inst_27274);

(statearr_27310_27336[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (10))){
var inst_27237 = (state_27286[(8)]);
var inst_27238 = (state_27286[(7)]);
var inst_27234 = (state_27286[(9)]);
var inst_27249 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27250 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27251 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27249),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27250),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27252 = fluree.db.util.log.trace.call(null,inst_27251);
var inst_27253 = (function (){var current_db_ch = inst_27234;
var current_db = inst_27237;
var current_block = inst_27238;
return (function (f){
if((f instanceof fluree.db.flake.Flake)){
return f;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,f);
}
});
})();
var inst_27254 = cljs.core.map.call(null,inst_27253,flakes);
var inst_27255 = fluree.db.dbproto._with.call(null,inst_27237,block,inst_27254);
var inst_27256 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27234,inst_27255);
var state_27286__$1 = (function (){var statearr_27311 = state_27286;
(statearr_27311[(11)] = inst_27252);

return statearr_27311;
})();
if(inst_27256){
var statearr_27312_27337 = state_27286__$1;
(statearr_27312_27337[(1)] = (13));

} else {
var statearr_27313_27338 = state_27286__$1;
(statearr_27313_27338[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (18))){
var inst_27277 = (state_27286[(2)]);
var state_27286__$1 = state_27286;
var statearr_27314_27339 = state_27286__$1;
(statearr_27314_27339[(2)] = inst_27277);

(statearr_27314_27339[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27287 === (8))){
var inst_27238 = (state_27286[(7)]);
var inst_27246 = ((1) + inst_27238);
var inst_27247 = cljs.core._EQ_.call(null,block,inst_27246);
var state_27286__$1 = state_27286;
if(inst_27247){
var statearr_27315_27340 = state_27286__$1;
(statearr_27315_27340[(1)] = (10));

} else {
var statearr_27316_27341 = state_27286__$1;
(statearr_27316_27341[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27317 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27317[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27317[(1)] = (1));

return statearr_27317;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27286){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27286);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27318){var ex__2749__auto__ = e27318;
var statearr_27319_27342 = state_27286;
(statearr_27319_27342[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27286[(4)]))){
var statearr_27320_27343 = state_27286;
(statearr_27320_27343[(1)] = cljs.core.first.call(null,(state_27286[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27344 = state_27286;
state_27286 = G__27344;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27286){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27321 = f__2769__auto__.call(null);
(statearr_27321[(6)] = c__2768__auto__);

return statearr_27321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27351){
var state_val_27352 = (state_27351[(1)]);
if((state_val_27352 === (1))){
var inst_27345 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27346 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27347 = new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015).cljs$core$IFn$_invoke$arity$1(session);
var inst_27348 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27346),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27347)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27349 = fluree.db.util.log.debug.call(null,inst_27348);
var state_27351__$1 = (function (){var statearr_27353 = state_27351;
(statearr_27353[(7)] = inst_27345);

(statearr_27353[(8)] = inst_27349);

return statearr_27353;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27351__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27354 = [null,null,null,null,null,null,null,null,null];
(statearr_27354[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27354[(1)] = (1));

return statearr_27354;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27351){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27355){var ex__2749__auto__ = e27355;
var statearr_27356_27359 = state_27351;
(statearr_27356_27359[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27351[(4)]))){
var statearr_27357_27360 = state_27351;
(statearr_27357_27360[(1)] = cljs.core.first.call(null,(state_27351[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27361 = state_27351;
state_27351 = G__27361;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27351){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27358 = f__2769__auto__.call(null);
(statearr_27358[(6)] = c__2768__auto__);

return statearr_27358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + ledger-id will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27363 = arguments.length;
switch (G__27363) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (p__27364){
var map__27365 = p__27364;
var map__27365__$1 = cljs.core.__destructure_map.call(null,map__27365);
var session = map__27365__$1;
var conn = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var ledger_id = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var id = cljs.core.get.call(null,map__27365__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,ledger_id);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,ledger_id){
var temp__5802__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(temp__5802__auto__)){
var session = temp__5802__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27418){
var state_val_27419 = (state_27418[(1)]);
if((state_val_27419 === (7))){
var inst_27414 = (state_27418[(2)]);
var state_27418__$1 = state_27418;
var statearr_27420_27451 = state_27418__$1;
(statearr_27420_27451[(2)] = inst_27414);

(statearr_27420_27451[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (1))){
var state_27418__$1 = state_27418;
var statearr_27421_27452 = state_27418__$1;
(statearr_27421_27452[(2)] = null);

(statearr_27421_27452[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (4))){
var inst_27370 = (state_27418[(7)]);
var inst_27369 = (state_27418[(2)]);
var inst_27370__$1 = fluree.db.util.async.throw_err.call(null,inst_27369);
var inst_27371 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27372 = (inst_27370__$1 == null);
var state_27418__$1 = (function (){var statearr_27422 = state_27418;
(statearr_27422[(8)] = inst_27371);

(statearr_27422[(7)] = inst_27370__$1);

return statearr_27422;
})();
if(cljs.core.truth_(inst_27372)){
var statearr_27423_27453 = state_27418__$1;
(statearr_27423_27453[(1)] = (5));

} else {
var statearr_27424_27454 = state_27418__$1;
(statearr_27424_27454[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (15))){
var inst_27406 = (state_27418[(2)]);
var state_27418__$1 = (function (){var statearr_27425 = state_27418;
(statearr_27425[(9)] = inst_27406);

return statearr_27425;
})();
var statearr_27426_27455 = state_27418__$1;
(statearr_27426_27455[(2)] = null);

(statearr_27426_27455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (13))){
var inst_27410 = (state_27418[(2)]);
var state_27418__$1 = state_27418;
var statearr_27428_27456 = state_27418__$1;
(statearr_27428_27456[(2)] = inst_27410);

(statearr_27428_27456[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (6))){
var inst_27371 = (state_27418[(8)]);
var inst_27377 = (inst_27371 == null);
var state_27418__$1 = state_27418;
if(cljs.core.truth_(inst_27377)){
var statearr_27429_27457 = state_27418__$1;
(statearr_27429_27457[(1)] = (8));

} else {
var statearr_27430_27458 = state_27418__$1;
(statearr_27430_27458[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (17))){
var _ = (function (){var statearr_27431 = state_27418;
(statearr_27431[(4)] = cljs.core.rest.call(null,(state_27418[(4)])));

return statearr_27431;
})();
var state_27418__$1 = state_27418;
var ex27427 = (state_27418__$1[(2)]);
var statearr_27432_27459 = state_27418__$1;
(statearr_27432_27459[(5)] = ex27427);


var statearr_27433_27460 = state_27418__$1;
(statearr_27433_27460[(1)] = (16));

(statearr_27433_27460[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (3))){
var inst_27416 = (state_27418[(2)]);
var state_27418__$1 = state_27418;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27418__$1,inst_27416);
} else {
if((state_val_27419 === (12))){
var state_27418__$1 = state_27418;
var statearr_27434_27461 = state_27418__$1;
(statearr_27434_27461[(2)] = null);

(statearr_27434_27461[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (2))){
var state_27418__$1 = state_27418;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27418__$1,(4),update_chan);
} else {
if((state_val_27419 === (11))){
var state_27418__$1 = state_27418;
var statearr_27435_27462 = state_27418__$1;
(statearr_27435_27462[(2)] = null);

(statearr_27435_27462[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (9))){
var state_27418__$1 = state_27418;
var statearr_27436_27463 = state_27418__$1;
(statearr_27436_27463[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (5))){
var inst_27374 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27375 = fluree.db.util.log.info.call(null,"Channel closed for session updates for:",inst_27374);
var state_27418__$1 = state_27418;
var statearr_27438_27464 = state_27418__$1;
(statearr_27438_27464[(2)] = inst_27375);

(statearr_27438_27464[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (14))){
var inst_27371 = (state_27418[(8)]);
var inst_27370 = (state_27418[(7)]);
var _ = (function (){var statearr_27439 = state_27418;
(statearr_27439[(4)] = cljs.core.cons.call(null,(17),(state_27418[(4)])));

return statearr_27439;
})();
var inst_27394 = cljs.core.nth.call(null,inst_27370,(0),null);
var inst_27395 = cljs.core.nth.call(null,inst_27370,(1),null);
var inst_27396 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27397 = cljs.core.pr_str.call(null,inst_27370);
var inst_27398 = fluree.db.util.core.trunc.call(null,inst_27397,(200));
var inst_27399 = fluree.db.util.log.trace.call(null,inst_27396,inst_27398);
var inst_27400 = fluree.db.session.process_ledger_update.call(null,inst_27371,inst_27394,inst_27395);
var state_27418__$1 = (function (){var statearr_27440 = state_27418;
(statearr_27440[(10)] = inst_27399);

return statearr_27440;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27418__$1,(18),inst_27400);
} else {
if((state_val_27419 === (16))){
var inst_27370 = (state_27418[(7)]);
var inst_27384 = (state_27418[(2)]);
var inst_27385 = fluree.db.util.log.error.call(null,inst_27384,"Exception processing ledger updates for message: ",inst_27370);
var state_27418__$1 = state_27418;
var statearr_27441_27465 = state_27418__$1;
(statearr_27441_27465[(2)] = inst_27385);

(statearr_27441_27465[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (10))){
var inst_27412 = (state_27418[(2)]);
var state_27418__$1 = state_27418;
var statearr_27442_27466 = state_27418__$1;
(statearr_27442_27466[(2)] = inst_27412);

(statearr_27442_27466[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (18))){
var inst_27402 = (state_27418[(2)]);
var inst_27403 = fluree.db.util.async.throw_err.call(null,inst_27402);
var _ = (function (){var statearr_27443 = state_27418;
(statearr_27443[(4)] = cljs.core.rest.call(null,(state_27418[(4)])));

return statearr_27443;
})();
var state_27418__$1 = state_27418;
var statearr_27444_27467 = state_27418__$1;
(statearr_27444_27467[(2)] = inst_27403);

(statearr_27444_27467[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27419 === (8))){
var inst_27370 = (state_27418[(7)]);
var inst_27379 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id)].join('');
var inst_27380 = cljs.core.first.call(null,inst_27370);
var inst_27381 = fluree.db.util.log.warn.call(null,"Ledger update received for session that is no longer open:",inst_27379,"Message: ",inst_27380);
var state_27418__$1 = state_27418;
var statearr_27445_27468 = state_27418__$1;
(statearr_27445_27468[(2)] = inst_27381);

(statearr_27445_27468[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0 = (function (){
var statearr_27446 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27446[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__);

(statearr_27446[(1)] = (1));

return statearr_27446;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1 = (function (state_27418){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27418);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27447){var ex__2749__auto__ = e27447;
var statearr_27448_27469 = state_27418;
(statearr_27448_27469[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27418[(4)]))){
var statearr_27449_27470 = state_27418;
(statearr_27449_27470[(1)] = cljs.core.first.call(null,(state_27418[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27471 = state_27418;
state_27418 = G__27471;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__ = function(state_27418){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1.call(this,state_27418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2746__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27450 = f__2769__auto__.call(null);
(statearr_27450[(6)] = c__2768__auto__);

return statearr_27450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
/**
 * Creates a connection without first checking if one already exists. Only useful
 *   if reloading and replacing an existing session.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27472){
var map__27473 = p__27472;
var map__27473__$1 = cljs.core.__destructure_map.call(null,map__27473);
var network = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var db = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ledger_id = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015));
var transactor_QMARK_ = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27473__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cur_db = (cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","current","db/current",-1088041545),cur_db,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[ledger_id,cljs.core.async.chan.call(null),db_name,state__$1,close,id,schema_cache,(cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null),network,null,conn]));
var current_db_fn = cljs.core.partial.call(null,fluree.db.session.current_db,session);
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,ledger_id,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27477 = block_result;
var map__27477__$1 = cljs.core.__destructure_map.call(null,map__27477);
var block = cljs.core.get.call(null,map__27477__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27477__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27477__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27477__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27477__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__5045__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27478 = tx_result;
var map__27478__$1 = cljs.core.__destructure_map.call(null,map__27478);
var t = cljs.core.get.call(null,map__27478__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27478__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27474_SHARP_){
return cljs.core._EQ_.call(null,t,fluree.db.flake.t.call(null,p1__27474_SHARP_));
}):(function (p1__27475_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27475_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27476_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27476_SHARP_))){
return cljs.core.nth.call(null,p1__27476_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27479 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27479,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27479,(1),null);
var error = cljs.core.nth.call(null,vec__27479,(2),null);
var message = cljs.core.nth.call(null,vec__27479,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__5045__auto__ = message;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));

var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27483 = arguments.length;
switch (G__27483) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27484){
var map__27485 = p__27484;
var map__27485__$1 = cljs.core.__destructure_map.call(null,map__27485);
var state = cljs.core.get.call(null,map__27485__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27485__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27485__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27485__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27486 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27486,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27486,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27486,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__5045__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"ledger-id","ledger-id",1705427015),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__5045__auto____$1 = state;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5804__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5804__auto__)){
var tx_callbacks = temp__5804__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27489 = cljs.core.seq.call(null,tids);
var chunk__27490 = null;
var count__27491 = (0);
var i__27492 = (0);
while(true){
if((i__27492 < count__27491)){
var tid = cljs.core._nth.call(null,chunk__27490,i__27492);
var temp__5804__auto___27605__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27605__$1)){
var keyed_callbacks_27606 = temp__5804__auto___27605__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27607 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27533_27608 = cljs.core.seq.call(null,keyed_callbacks_27606);
var chunk__27534_27609 = null;
var count__27535_27610 = (0);
var i__27536_27611 = (0);
while(true){
if((i__27536_27611 < count__27535_27610)){
var vec__27545_27612 = cljs.core._nth.call(null,chunk__27534_27609,i__27536_27611);
var k_27613 = cljs.core.nth.call(null,vec__27545_27612,(0),null);
var f_27614 = cljs.core.nth.call(null,vec__27545_27612,(1),null);
try{f_27614.call(null,tx_response_27607);
}catch (e27548){var e_27615 = e27548;
fluree.db.util.log.error.call(null,e_27615,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27616 = seq__27533_27608;
var G__27617 = chunk__27534_27609;
var G__27618 = count__27535_27610;
var G__27619 = (i__27536_27611 + (1));
seq__27533_27608 = G__27616;
chunk__27534_27609 = G__27617;
count__27535_27610 = G__27618;
i__27536_27611 = G__27619;
continue;
} else {
var temp__5804__auto___27620__$2 = cljs.core.seq.call(null,seq__27533_27608);
if(temp__5804__auto___27620__$2){
var seq__27533_27621__$1 = temp__5804__auto___27620__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27533_27621__$1)){
var c__5568__auto___27622 = cljs.core.chunk_first.call(null,seq__27533_27621__$1);
var G__27623 = cljs.core.chunk_rest.call(null,seq__27533_27621__$1);
var G__27624 = c__5568__auto___27622;
var G__27625 = cljs.core.count.call(null,c__5568__auto___27622);
var G__27626 = (0);
seq__27533_27608 = G__27623;
chunk__27534_27609 = G__27624;
count__27535_27610 = G__27625;
i__27536_27611 = G__27626;
continue;
} else {
var vec__27549_27627 = cljs.core.first.call(null,seq__27533_27621__$1);
var k_27628 = cljs.core.nth.call(null,vec__27549_27627,(0),null);
var f_27629 = cljs.core.nth.call(null,vec__27549_27627,(1),null);
try{f_27629.call(null,tx_response_27607);
}catch (e27552){var e_27630 = e27552;
fluree.db.util.log.error.call(null,e_27630,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27631 = cljs.core.next.call(null,seq__27533_27621__$1);
var G__27632 = null;
var G__27633 = (0);
var G__27634 = (0);
seq__27533_27608 = G__27631;
chunk__27534_27609 = G__27632;
count__27535_27610 = G__27633;
i__27536_27611 = G__27634;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27635 = seq__27489;
var G__27636 = chunk__27490;
var G__27637 = count__27491;
var G__27638 = (i__27492 + (1));
seq__27489 = G__27635;
chunk__27490 = G__27636;
count__27491 = G__27637;
i__27492 = G__27638;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__27489);
if(temp__5804__auto____$1){
var seq__27489__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27489__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27489__$1);
var G__27639 = cljs.core.chunk_rest.call(null,seq__27489__$1);
var G__27640 = c__5568__auto__;
var G__27641 = cljs.core.count.call(null,c__5568__auto__);
var G__27642 = (0);
seq__27489 = G__27639;
chunk__27490 = G__27640;
count__27491 = G__27641;
i__27492 = G__27642;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27489__$1);
var temp__5804__auto___27643__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5804__auto___27643__$2)){
var keyed_callbacks_27644 = temp__5804__auto___27643__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_27645 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27553_27646 = cljs.core.seq.call(null,keyed_callbacks_27644);
var chunk__27554_27647 = null;
var count__27555_27648 = (0);
var i__27556_27649 = (0);
while(true){
if((i__27556_27649 < count__27555_27648)){
var vec__27565_27650 = cljs.core._nth.call(null,chunk__27554_27647,i__27556_27649);
var k_27651 = cljs.core.nth.call(null,vec__27565_27650,(0),null);
var f_27652 = cljs.core.nth.call(null,vec__27565_27650,(1),null);
try{f_27652.call(null,tx_response_27645);
}catch (e27568){var e_27653 = e27568;
fluree.db.util.log.error.call(null,e_27653,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27654 = seq__27553_27646;
var G__27655 = chunk__27554_27647;
var G__27656 = count__27555_27648;
var G__27657 = (i__27556_27649 + (1));
seq__27553_27646 = G__27654;
chunk__27554_27647 = G__27655;
count__27555_27648 = G__27656;
i__27556_27649 = G__27657;
continue;
} else {
var temp__5804__auto___27658__$3 = cljs.core.seq.call(null,seq__27553_27646);
if(temp__5804__auto___27658__$3){
var seq__27553_27659__$1 = temp__5804__auto___27658__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27553_27659__$1)){
var c__5568__auto___27660 = cljs.core.chunk_first.call(null,seq__27553_27659__$1);
var G__27661 = cljs.core.chunk_rest.call(null,seq__27553_27659__$1);
var G__27662 = c__5568__auto___27660;
var G__27663 = cljs.core.count.call(null,c__5568__auto___27660);
var G__27664 = (0);
seq__27553_27646 = G__27661;
chunk__27554_27647 = G__27662;
count__27555_27648 = G__27663;
i__27556_27649 = G__27664;
continue;
} else {
var vec__27569_27665 = cljs.core.first.call(null,seq__27553_27659__$1);
var k_27666 = cljs.core.nth.call(null,vec__27569_27665,(0),null);
var f_27667 = cljs.core.nth.call(null,vec__27569_27665,(1),null);
try{f_27667.call(null,tx_response_27645);
}catch (e27572){var e_27668 = e27572;
fluree.db.util.log.error.call(null,e_27668,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__27669 = cljs.core.next.call(null,seq__27553_27659__$1);
var G__27670 = null;
var G__27671 = (0);
var G__27672 = (0);
seq__27553_27646 = G__27669;
chunk__27554_27647 = G__27670;
count__27555_27648 = G__27671;
i__27556_27649 = G__27672;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__27673 = cljs.core.next.call(null,seq__27489__$1);
var G__27674 = null;
var G__27675 = (0);
var G__27676 = (0);
seq__27489 = G__27673;
chunk__27490 = G__27674;
count__27491 = G__27675;
i__27492 = G__27676;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_27677 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2768__auto___27678 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_27589){
var state_val_27590 = (state_27589[(1)]);
if((state_val_27590 === (1))){
var state_27589__$1 = state_27589;
var statearr_27591_27679 = state_27589__$1;
(statearr_27591_27679[(2)] = null);

(statearr_27591_27679[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (2))){
var inst_27574 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27589__$1 = state_27589;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27589__$1,(4),inst_27574);
} else {
if((state_val_27590 === (3))){
var inst_27587 = (state_27589[(2)]);
var state_27589__$1 = state_27589;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27589__$1,inst_27587);
} else {
if((state_val_27590 === (4))){
var inst_27576 = (state_27589[(7)]);
var inst_27576__$1 = (state_27589[(2)]);
var inst_27577 = (inst_27576__$1 == null);
var state_27589__$1 = (function (){var statearr_27592 = state_27589;
(statearr_27592[(7)] = inst_27576__$1);

return statearr_27592;
})();
if(cljs.core.truth_(inst_27577)){
var statearr_27593_27680 = state_27589__$1;
(statearr_27593_27680[(1)] = (5));

} else {
var statearr_27594_27681 = state_27589__$1;
(statearr_27594_27681[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (5))){
var inst_27579 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27580 = fluree.db.util.log.info.call(null,"Transactor session closing for db:",inst_27579);
var state_27589__$1 = state_27589;
var statearr_27595_27682 = state_27589__$1;
(statearr_27595_27682[(2)] = inst_27580);

(statearr_27595_27682[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (6))){
var inst_27576 = (state_27589[(7)]);
var inst_27582 = transact_handler_27677.call(null,conn,inst_27576);
var state_27589__$1 = (function (){var statearr_27596 = state_27589;
(statearr_27596[(8)] = inst_27582);

return statearr_27596;
})();
var statearr_27597_27683 = state_27589__$1;
(statearr_27597_27683[(2)] = null);

(statearr_27597_27683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27590 === (7))){
var inst_27585 = (state_27589[(2)]);
var state_27589__$1 = state_27589;
var statearr_27598_27684 = state_27589__$1;
(statearr_27598_27684[(2)] = inst_27585);

(statearr_27598_27684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2746__auto__ = null;
var fluree$db$session$state_machine__2746__auto____0 = (function (){
var statearr_27599 = [null,null,null,null,null,null,null,null,null];
(statearr_27599[(0)] = fluree$db$session$state_machine__2746__auto__);

(statearr_27599[(1)] = (1));

return statearr_27599;
});
var fluree$db$session$state_machine__2746__auto____1 = (function (state_27589){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_27589);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e27600){var ex__2749__auto__ = e27600;
var statearr_27601_27685 = state_27589;
(statearr_27601_27685[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_27589[(4)]))){
var statearr_27602_27686 = state_27589;
(statearr_27602_27686[(1)] = cljs.core.first.call(null,(state_27589[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27687 = state_27589;
state_27589 = G__27687;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$session$state_machine__2746__auto__ = function(state_27589){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2746__auto____1.call(this,state_27589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2746__auto____0;
fluree$db$session$state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2746__auto____1;
return fluree$db$session$state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_27603 = f__2769__auto__.call(null);
(statearr_27603[(6)] = c__2768__auto___27678);

return statearr_27603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__27690 = arguments.length;
switch (G__27690) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__27691 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__27688_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__27688_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__27691);
} else {
return G__27691;
}
})();
var seq__27692 = cljs.core.seq.call(null,sessions);
var chunk__27693 = null;
var count__27694 = (0);
var i__27695 = (0);
while(true){
if((i__27695 < count__27694)){
var session = cljs.core._nth.call(null,chunk__27693,i__27695);
fluree.db.session.close.call(null,session);


var G__27697 = seq__27692;
var G__27698 = chunk__27693;
var G__27699 = count__27694;
var G__27700 = (i__27695 + (1));
seq__27692 = G__27697;
chunk__27693 = G__27698;
count__27694 = G__27699;
i__27695 = G__27700;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__27692);
if(temp__5804__auto__){
var seq__27692__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27692__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__27692__$1);
var G__27701 = cljs.core.chunk_rest.call(null,seq__27692__$1);
var G__27702 = c__5568__auto__;
var G__27703 = cljs.core.count.call(null,c__5568__auto__);
var G__27704 = (0);
seq__27692 = G__27701;
chunk__27693 = G__27702;
count__27694 = G__27703;
i__27695 = G__27704;
continue;
} else {
var session = cljs.core.first.call(null,seq__27692__$1);
fluree.db.session.close.call(null,session);


var G__27705 = cljs.core.next.call(null,seq__27692__$1);
var G__27706 = null;
var G__27707 = (0);
var G__27708 = (0);
seq__27692 = G__27705;
chunk__27693 = G__27706;
count__27694 = G__27707;
i__27695 = G__27708;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
