// Compiled by ClojureScript 1.11.60 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.subject_crawl.subject');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('fluree.db.index');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.query.subject_crawl.common');
goog.require('fluree.db.dbproto');
/**
 * Returns chan of subjects in chunks per index-leaf
 *   that can be pulled as needed based on the selection criteria of a where clause.
 */
fluree.db.query.subject_crawl.subject.subjects_chan = (function fluree$db$query$subject_crawl$subject$subjects_chan(p__23673,error_ch,vars,p__23674){
var map__23675 = p__23673;
var map__23675__$1 = cljs.core.__destructure_map.call(null,map__23675);
var db = map__23675__$1;
var conn = cljs.core.get.call(null,map__23675__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var novelty = cljs.core.get.call(null,map__23675__$1,new cljs.core.Keyword(null,"novelty","novelty",-1590246024));
var t = cljs.core.get.call(null,map__23675__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var map__23676 = p__23674;
var map__23676__$1 = cljs.core.__destructure_map.call(null,map__23676);
var _where_clause = map__23676__$1;
var p = cljs.core.get.call(null,map__23676__$1,new cljs.core.Keyword(null,"p","p",151049309));
var o = cljs.core.get.call(null,map__23676__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var idx = cljs.core.get.call(null,map__23676__$1,new cljs.core.Keyword(null,"idx","idx",1053688473));
var o_STAR_ = (function (){var temp__5806__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if((temp__5806__auto__ == null)){
var temp__5804__auto__ = new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(temp__5804__auto__)){
var variable = temp__5804__auto__;
return cljs.core.get.call(null,vars,variable);
} else {
return null;
}
} else {
var v = temp__5806__auto__;
return v;
}
})();
var vec__23677 = (function (){var G__23680 = idx;
var G__23680__$1 = (((G__23680 instanceof cljs.core.Keyword))?G__23680.fqn:null);
switch (G__23680__$1) {
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,o_STAR_,null,null,(2147483647))], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(-2147483647)),fluree.db.flake.__GT_Flake.call(null,null,p,null,null,null,(2147483647))], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23680__$1)].join('')));

}
})();
var fflake = cljs.core.nth.call(null,vec__23677,(0),null);
var lflake = cljs.core.nth.call(null,vec__23677,(1),null);
var filter_fn = (cljs.core.truth_((function (){var and__5043__auto__ = o_STAR_;
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),idx);
} else {
return and__5043__auto__;
}
})())?(function (p1__23671_SHARP_){
return cljs.core._EQ_.call(null,o_STAR_,fluree.db.flake.o.call(null,p1__23671_SHARP_));
}):(cljs.core.truth_(new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(o))?(function (){var f = cljs.core.get_in.call(null,o,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"filter","filter",-948537934),new cljs.core.Keyword(null,"function","function",-2127255473)], null));
return (function (p1__23672_SHARP_){
return f.call(null,fluree.db.flake.o.call(null,p1__23672_SHARP_));
});
})():null));
var idx_root = cljs.core.get.call(null,db,idx);
var cmp = new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(idx_root);
var range_set = fluree.db.flake.sorted_set_by.call(null,cmp,fflake,lflake);
var in_range_QMARK_ = (function (node){
return fluree.db.query.range.intersects_range_QMARK_.call(null,node,range_set);
});
var query_xf = fluree.db.query.subject_crawl.common.where_subj_xf.call(null,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"start-test","start-test",-952983565),cljs.core._GT__EQ_,new cljs.core.Keyword(null,"start-flake","start-flake",-1895859803),fflake,new cljs.core.Keyword(null,"end-test","end-test",481973727),cljs.core._LT__EQ_,new cljs.core.Keyword(null,"end-flake","end-flake",-38740179),lflake,new cljs.core.Keyword(null,"xf","xf",401902988),(cljs.core.truth_(filter_fn)?cljs.core.map.call(null,(function (flakes){
return cljs.core.filter.call(null,filter_fn,flakes);
})):null)], null));
var resolver = fluree.db.index.__GT_CachedTRangeResolver.call(null,conn,cljs.core.get.call(null,novelty,idx),t,t,new cljs.core.Keyword(null,"async-cache","async-cache",-190459891).cljs$core$IFn$_invoke$arity$1(conn));
var tree_chan = fluree.db.index.tree_chan.call(null,resolver,idx_root,in_range_QMARK_,fluree.db.query.range.resolved_leaf_QMARK_,(1),query_xf,error_ch);
var return_chan = cljs.core.async.chan.call(null,(10),cljs.core.comp.call(null,cljs.core.map.call(null,fluree.db.flake.s),cljs.core.dedupe.call(null)));
var c__2768__auto___23750 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23719){
var state_val_23720 = (state_23719[(1)]);
if((state_val_23720 === (7))){
var inst_23715 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
var statearr_23721_23751 = state_23719__$1;
(statearr_23721_23751[(2)] = inst_23715);

(statearr_23721_23751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (1))){
var state_23719__$1 = state_23719;
var statearr_23722_23752 = state_23719__$1;
(statearr_23722_23752[(2)] = null);

(statearr_23722_23752[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (4))){
var inst_23683 = (state_23719[(7)]);
var inst_23683__$1 = (state_23719[(2)]);
var inst_23684 = (inst_23683__$1 == null);
var state_23719__$1 = (function (){var statearr_23723 = state_23719;
(statearr_23723[(7)] = inst_23683__$1);

return statearr_23723;
})();
if(cljs.core.truth_(inst_23684)){
var statearr_23724_23753 = state_23719__$1;
(statearr_23724_23753[(1)] = (5));

} else {
var statearr_23725_23754 = state_23719__$1;
(statearr_23725_23754[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (15))){
var state_23719__$1 = state_23719;
var statearr_23726_23755 = state_23719__$1;
(statearr_23726_23755[(2)] = false);

(statearr_23726_23755[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (13))){
var inst_23695 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
if(cljs.core.truth_(inst_23695)){
var statearr_23727_23756 = state_23719__$1;
(statearr_23727_23756[(1)] = (14));

} else {
var statearr_23728_23757 = state_23719__$1;
(statearr_23728_23757[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (6))){
var inst_23683 = (state_23719[(7)]);
var inst_23688 = cljs.core.seq.call(null,inst_23683);
var inst_23689 = inst_23688;
var inst_23690 = (0);
var state_23719__$1 = (function (){var statearr_23729 = state_23719;
(statearr_23729[(8)] = inst_23690);

(statearr_23729[(9)] = inst_23689);

return statearr_23729;
})();
var statearr_23730_23758 = state_23719__$1;
(statearr_23730_23758[(2)] = null);

(statearr_23730_23758[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (17))){
var state_23719__$1 = state_23719;
var statearr_23731_23759 = state_23719__$1;
(statearr_23731_23759[(2)] = null);

(statearr_23731_23759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (3))){
var inst_23717 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23719__$1,inst_23717);
} else {
if((state_val_23720 === (12))){
var inst_23705 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
var statearr_23732_23760 = state_23719__$1;
(statearr_23732_23760[(2)] = inst_23705);

(statearr_23732_23760[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (2))){
var state_23719__$1 = state_23719;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23719__$1,(4),tree_chan);
} else {
if((state_val_23720 === (19))){
var inst_23713 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
var statearr_23733_23761 = state_23719__$1;
(statearr_23733_23761[(2)] = inst_23713);

(statearr_23733_23761[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (11))){
var state_23719__$1 = state_23719;
var statearr_23734_23762 = state_23719__$1;
(statearr_23734_23762[(2)] = true);

(statearr_23734_23762[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (9))){
var inst_23707 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
if(cljs.core.truth_(inst_23707)){
var statearr_23735_23763 = state_23719__$1;
(statearr_23735_23763[(1)] = (17));

} else {
var statearr_23736_23764 = state_23719__$1;
(statearr_23736_23764[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (5))){
var inst_23686 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23719__$1 = state_23719;
var statearr_23737_23765 = state_23719__$1;
(statearr_23737_23765[(2)] = inst_23686);

(statearr_23737_23765[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (14))){
var inst_23690 = (state_23719[(8)]);
var inst_23689 = (state_23719[(9)]);
var inst_23697 = cljs.core.next.call(null,inst_23689);
var inst_23698 = (inst_23690 + (1));
var inst_23689__$1 = inst_23697;
var inst_23690__$1 = inst_23698;
var state_23719__$1 = (function (){var statearr_23738 = state_23719;
(statearr_23738[(8)] = inst_23690__$1);

(statearr_23738[(9)] = inst_23689__$1);

return statearr_23738;
})();
var statearr_23739_23766 = state_23719__$1;
(statearr_23739_23766[(2)] = null);

(statearr_23739_23766[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (16))){
var inst_23702 = (state_23719[(2)]);
var state_23719__$1 = state_23719;
var statearr_23740_23767 = state_23719__$1;
(statearr_23740_23767[(2)] = inst_23702);

(statearr_23740_23767[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (10))){
var inst_23689 = (state_23719[(9)]);
var inst_23693 = cljs.core.first.call(null,inst_23689);
var state_23719__$1 = state_23719;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23719__$1,(13),return_chan,inst_23693);
} else {
if((state_val_23720 === (18))){
var inst_23711 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_23719__$1 = state_23719;
var statearr_23741_23768 = state_23719__$1;
(statearr_23741_23768[(2)] = inst_23711);

(statearr_23741_23768[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23720 === (8))){
var inst_23689 = (state_23719[(9)]);
var state_23719__$1 = state_23719;
if(cljs.core.truth_(inst_23689)){
var statearr_23742_23769 = state_23719__$1;
(statearr_23742_23769[(1)] = (10));

} else {
var statearr_23743_23770 = state_23719__$1;
(statearr_23743_23770[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23744 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23744[(0)] = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__);

(statearr_23744[(1)] = (1));

return statearr_23744;
});
var fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1 = (function (state_23719){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23719);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23745){var ex__2749__auto__ = e23745;
var statearr_23746_23771 = state_23719;
(statearr_23746_23771[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23719[(4)]))){
var statearr_23747_23772 = state_23719;
(statearr_23747_23772[(1)] = cljs.core.first.call(null,(state_23719[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23773 = state_23719;
state_23719 = G__23773;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__ = function(state_23719){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1.call(this,state_23719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23748 = f__2769__auto__.call(null);
(statearr_23748[(6)] = c__2768__auto___23750);

return statearr_23748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_chan;
});
fluree.db.query.subject_crawl.subject.flakes_xf = (function fluree$db$query$subject_crawl$subject$flakes_xf(p__23774){
var map__23775 = p__23774;
var map__23775__$1 = cljs.core.__destructure_map.call(null,map__23775);
var _opts = map__23775__$1;
var db = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"db","db",993250759));
var fuel_vol = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"fuel-vol","fuel-vol",1195097142));
var max_fuel = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012));
var error_ch = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var vars = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var filter_map = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"filter-map","filter-map",-314788257));
var permissioned_QMARK_ = cljs.core.get.call(null,map__23775__$1,new cljs.core.Keyword(null,"permissioned?","permissioned?",-560602803));
var permissions = (cljs.core.truth_(permissioned_QMARK_)?fluree.db.query.subject_crawl.common.subj_perm_filter_fn.call(null,db):null);
return (function (sid,port){
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23820){
var state_val_23821 = (state_23820[(1)]);
if((state_val_23821 === (7))){
var inst_23791 = (state_23820[(7)]);
var inst_23793 = fluree.db.query.subject_crawl.common.filter_subject.call(null,vars,filter_map,inst_23791);
var state_23820__$1 = state_23820;
var statearr_23822_23858 = state_23820__$1;
(statearr_23822_23858[(2)] = inst_23793);

(statearr_23822_23858[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (1))){
var state_23820__$1 = state_23820;
var statearr_23823_23859 = state_23820__$1;
(statearr_23823_23859[(2)] = null);

(statearr_23823_23859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (4))){
var inst_23776 = (state_23820[(2)]);
var inst_23777 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23776);
var inst_23778 = cljs.core.async.close_BANG_.call(null,port);
var state_23820__$1 = (function (){var statearr_23824 = state_23820;
(statearr_23824[(8)] = inst_23778);

(statearr_23824[(9)] = inst_23777);

return statearr_23824;
})();
var statearr_23825_23860 = state_23820__$1;
(statearr_23825_23860[(2)] = null);

(statearr_23825_23860[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (15))){
var inst_23808 = (state_23820[(10)]);
var inst_23808__$1 = (state_23820[(2)]);
var inst_23809 = cljs.core.seq.call(null,inst_23808__$1);
var state_23820__$1 = (function (){var statearr_23826 = state_23820;
(statearr_23826[(10)] = inst_23808__$1);

return statearr_23826;
})();
if(inst_23809){
var statearr_23827_23861 = state_23820__$1;
(statearr_23827_23861[(1)] = (17));

} else {
var statearr_23828_23862 = state_23820__$1;
(statearr_23828_23862[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (13))){
var inst_23801 = (state_23820[(11)]);
var state_23820__$1 = state_23820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23820__$1,(16),inst_23801);
} else {
if((state_val_23821 === (6))){
var inst_23790 = (state_23820[(2)]);
var inst_23791 = fluree.db.util.async.throw_err.call(null,inst_23790);
var state_23820__$1 = (function (){var statearr_23829 = state_23820;
(statearr_23829[(7)] = inst_23791);

return statearr_23829;
})();
if(cljs.core.truth_(filter_map)){
var statearr_23830_23863 = state_23820__$1;
(statearr_23830_23863[(1)] = (7));

} else {
var statearr_23831_23864 = state_23820__$1;
(statearr_23831_23864[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (17))){
var inst_23808 = (state_23820[(10)]);
var inst_23811 = cljs.core.async.put_BANG_.call(null,port,inst_23808);
var state_23820__$1 = state_23820;
var statearr_23832_23865 = state_23820__$1;
(statearr_23832_23865[(2)] = inst_23811);

(statearr_23832_23865[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (3))){
var inst_23818 = (state_23820[(2)]);
var state_23820__$1 = state_23820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23820__$1,inst_23818);
} else {
if((state_val_23821 === (12))){
var inst_23801 = (state_23820[(2)]);
var state_23820__$1 = (function (){var statearr_23833 = state_23820;
(statearr_23833[(11)] = inst_23801);

return statearr_23833;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23834_23866 = state_23820__$1;
(statearr_23834_23866[(1)] = (13));

} else {
var statearr_23835_23867 = state_23820__$1;
(statearr_23835_23867[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (2))){
var _ = (function (){var statearr_23836 = state_23820;
(statearr_23836[(4)] = cljs.core.cons.call(null,(5),(state_23820[(4)])));

return statearr_23836;
})();
var inst_23785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23786 = [sid];
var inst_23787 = (new cljs.core.PersistentVector(null,1,(5),inst_23785,inst_23786,null));
var inst_23788 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23787);
var state_23820__$1 = state_23820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23820__$1,(6),inst_23788);
} else {
if((state_val_23821 === (19))){
var inst_23814 = (state_23820[(2)]);
var inst_23815 = cljs.core.async.close_BANG_.call(null,port);
var _ = (function (){var statearr_23837 = state_23820;
(statearr_23837[(4)] = cljs.core.rest.call(null,(state_23820[(4)])));

return statearr_23837;
})();
var state_23820__$1 = (function (){var statearr_23838 = state_23820;
(statearr_23838[(12)] = inst_23814);

return statearr_23838;
})();
var statearr_23839_23868 = state_23820__$1;
(statearr_23839_23868[(2)] = inst_23815);

(statearr_23839_23868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (11))){
var inst_23796 = (state_23820[(13)]);
var state_23820__$1 = state_23820;
var statearr_23841_23869 = state_23820__$1;
(statearr_23841_23869[(2)] = inst_23796);

(statearr_23841_23869[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (9))){
var inst_23796 = (state_23820[(2)]);
var state_23820__$1 = (function (){var statearr_23842 = state_23820;
(statearr_23842[(13)] = inst_23796);

return statearr_23842;
})();
if(cljs.core.truth_(permissioned_QMARK_)){
var statearr_23843_23870 = state_23820__$1;
(statearr_23843_23870[(1)] = (10));

} else {
var statearr_23844_23871 = state_23820__$1;
(statearr_23844_23871[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (5))){
var _ = (function (){var statearr_23845 = state_23820;
(statearr_23845[(4)] = cljs.core.rest.call(null,(state_23820[(4)])));

return statearr_23845;
})();
var state_23820__$1 = state_23820;
var ex23840 = (state_23820__$1[(2)]);
var statearr_23846_23872 = state_23820__$1;
(statearr_23846_23872[(5)] = ex23840);


var statearr_23847_23873 = state_23820__$1;
(statearr_23847_23873[(1)] = (4));

(statearr_23847_23873[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (14))){
var inst_23801 = (state_23820[(11)]);
var state_23820__$1 = state_23820;
var statearr_23848_23874 = state_23820__$1;
(statearr_23848_23874[(2)] = inst_23801);

(statearr_23848_23874[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (16))){
var inst_23804 = (state_23820[(2)]);
var inst_23805 = fluree.db.util.async.throw_err.call(null,inst_23804);
var state_23820__$1 = state_23820;
var statearr_23849_23875 = state_23820__$1;
(statearr_23849_23875[(2)] = inst_23805);

(statearr_23849_23875[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (10))){
var inst_23796 = (state_23820[(13)]);
var inst_23798 = permissions.call(null,inst_23796);
var state_23820__$1 = state_23820;
var statearr_23850_23876 = state_23820__$1;
(statearr_23850_23876[(2)] = inst_23798);

(statearr_23850_23876[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (18))){
var state_23820__$1 = state_23820;
var statearr_23851_23877 = state_23820__$1;
(statearr_23851_23877[(2)] = null);

(statearr_23851_23877[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23821 === (8))){
var inst_23791 = (state_23820[(7)]);
var state_23820__$1 = state_23820;
var statearr_23852_23878 = state_23820__$1;
(statearr_23852_23878[(2)] = inst_23791);

(statearr_23852_23878[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0 = (function (){
var statearr_23853 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23853[(0)] = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__);

(statearr_23853[(1)] = (1));

return statearr_23853;
});
var fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1 = (function (state_23820){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23854){var ex__2749__auto__ = e23854;
var statearr_23855_23879 = state_23820;
(statearr_23855_23879[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23820[(4)]))){
var statearr_23856_23880 = state_23820;
(statearr_23856_23880[(1)] = cljs.core.first.call(null,(state_23820[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23881 = state_23820;
state_23820 = G__23881;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__ = function(state_23820){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1.call(this,state_23820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$flakes_xf_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23857 = f__2769__auto__.call(null);
(statearr_23857[(6)] = c__2768__auto__);

return statearr_23857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
});
/**
 * For queries that specify _id as the predicate, we will have a
 *   single subject as a value.
 */
fluree.db.query.subject_crawl.subject.subjects_id_chan = (function fluree$db$query$subject_crawl$subject$subjects_id_chan(db,error_ch,vars,p__23882){
var map__23883 = p__23882;
var map__23883__$1 = cljs.core.__destructure_map.call(null,map__23883);
var f_where = map__23883__$1;
var o = cljs.core.get.call(null,map__23883__$1,new cljs.core.Keyword(null,"o","o",-1350007228));
var return_ch = cljs.core.async.chan.call(null);
var _id_val = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(o);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,vars,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(o));
}
})();
if(cljs.core.truth_(_id_val)){
} else {
throw cljs.core.ex_info.call(null,["When using _id as the predicate, a value must be provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(f_where)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var c__2768__auto___23920 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_23903){
var state_val_23904 = (state_23903[(1)]);
if((state_val_23904 === (7))){
var inst_23891 = (state_23903[(7)]);
var inst_23894 = cljs.core.async.put_BANG_.call(null,error_ch,inst_23891);
var state_23903__$1 = state_23903;
var statearr_23905_23921 = state_23903__$1;
(statearr_23905_23921[(2)] = inst_23894);

(statearr_23905_23921[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23904 === (1))){
var inst_23884 = typeof _id_val === 'number';
var state_23903__$1 = state_23903;
if(cljs.core.truth_(inst_23884)){
var statearr_23906_23922 = state_23903__$1;
(statearr_23906_23922[(1)] = (2));

} else {
var statearr_23907_23923 = state_23903__$1;
(statearr_23907_23923[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23904 === (4))){
var inst_23900 = (state_23903[(2)]);
var inst_23901 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_23903__$1 = (function (){var statearr_23908 = state_23903;
(statearr_23908[(8)] = inst_23900);

return statearr_23908;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23903__$1,inst_23901);
} else {
if((state_val_23904 === (6))){
var inst_23891 = (state_23903[(7)]);
var inst_23891__$1 = (state_23903[(2)]);
var inst_23892 = fluree.db.util.core.exception_QMARK_.call(null,inst_23891__$1);
var state_23903__$1 = (function (){var statearr_23909 = state_23903;
(statearr_23909[(7)] = inst_23891__$1);

return statearr_23909;
})();
if(inst_23892){
var statearr_23910_23924 = state_23903__$1;
(statearr_23910_23924[(1)] = (7));

} else {
var statearr_23911_23925 = state_23903__$1;
(statearr_23911_23925[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23904 === (3))){
var inst_23889 = fluree.db.dbproto._subid.call(null,db,_id_val);
var state_23903__$1 = state_23903;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23903__$1,(6),inst_23889);
} else {
if((state_val_23904 === (2))){
var state_23903__$1 = state_23903;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_23903__$1,(5),return_ch,_id_val);
} else {
if((state_val_23904 === (9))){
var inst_23898 = (state_23903[(2)]);
var state_23903__$1 = state_23903;
var statearr_23912_23926 = state_23903__$1;
(statearr_23912_23926[(2)] = inst_23898);

(statearr_23912_23926[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23904 === (5))){
var inst_23887 = (state_23903[(2)]);
var state_23903__$1 = state_23903;
var statearr_23913_23927 = state_23903__$1;
(statearr_23913_23927[(2)] = inst_23887);

(statearr_23913_23927[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23904 === (8))){
var inst_23891 = (state_23903[(7)]);
var inst_23896 = cljs.core.async.put_BANG_.call(null,return_ch,inst_23891);
var state_23903__$1 = state_23903;
var statearr_23914_23928 = state_23903__$1;
(statearr_23914_23928[(2)] = inst_23896);

(statearr_23914_23928[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0 = (function (){
var statearr_23915 = [null,null,null,null,null,null,null,null,null];
(statearr_23915[(0)] = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__);

(statearr_23915[(1)] = (1));

return statearr_23915;
});
var fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1 = (function (state_23903){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_23903);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e23916){var ex__2749__auto__ = e23916;
var statearr_23917_23929 = state_23903;
(statearr_23917_23929[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_23903[(4)]))){
var statearr_23918_23930 = state_23903;
(statearr_23918_23930[(1)] = cljs.core.first.call(null,(state_23903[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23931 = state_23903;
state_23903 = G__23931;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__ = function(state_23903){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1.call(this,state_23903);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subjects_id_chan_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_23919 = f__2769__auto__.call(null);
(statearr_23919[(6)] = c__2768__auto___23920);

return statearr_23919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));


return return_ch;
});
fluree.db.query.subject_crawl.subject.subj_crawl = (function fluree$db$query$subject_crawl$subject$subj_crawl(p__23932){
var map__23933 = p__23932;
var map__23933__$1 = cljs.core.__destructure_map.call(null,map__23933);
var opts = map__23933__$1;
var db = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"db","db",993250759));
var error_ch = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"error-ch","error-ch",-1177587736));
var f_where = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"f-where","f-where",-958007776));
var limit = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var parallelism = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"parallelism","parallelism",-930922333));
var vars = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var finish_fn = cljs.core.get.call(null,map__23933__$1,new cljs.core.Keyword(null,"finish-fn","finish-fn",1593909598));
var c__2768__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2769__auto__ = (function (){var switch__2745__auto__ = (function (state_24000){
var state_val_24001 = (state_24000[(1)]);
if((state_val_24001 === (7))){
var inst_23945 = fluree.db.query.subject_crawl.subject.subjects_chan.call(null,db,error_ch,vars,f_where);
var state_24000__$1 = state_24000;
var statearr_24002_24039 = state_24000__$1;
(statearr_24002_24039[(2)] = inst_23945);

(statearr_24002_24039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (20))){
var inst_23989 = (state_24000[(2)]);
var state_24000__$1 = state_24000;
var statearr_24003_24040 = state_24000__$1;
(statearr_24003_24040[(2)] = inst_23989);

(statearr_24003_24040[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (1))){
var state_24000__$1 = state_24000;
var statearr_24004_24041 = state_24000__$1;
(statearr_24004_24041[(2)] = null);

(statearr_24004_24041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (4))){
var inst_23934 = (state_24000[(2)]);
var state_24000__$1 = state_24000;
var statearr_24005_24042 = state_24000__$1;
(statearr_24005_24042[(2)] = inst_23934);

(statearr_24005_24042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (15))){
var inst_23947 = (state_24000[(7)]);
var inst_23953 = (state_24000[(8)]);
var inst_23958 = (state_24000[(9)]);
var inst_23952 = (state_24000[(10)]);
var inst_23979 = cljs.core.async.close_BANG_.call(null,inst_23947);
var inst_23980 = cljs.core.async.close_BANG_.call(null,inst_23952);
var inst_23981 = cljs.core.async.close_BANG_.call(null,inst_23953);
var inst_23982 = finish_fn.call(null,inst_23958);
var state_24000__$1 = (function (){var statearr_24006 = state_24000;
(statearr_24006[(11)] = inst_23980);

(statearr_24006[(12)] = inst_23979);

(statearr_24006[(13)] = inst_23981);

return statearr_24006;
})();
var statearr_24007_24043 = state_24000__$1;
(statearr_24007_24043[(2)] = inst_23982);

(statearr_24007_24043[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (13))){
var inst_23968 = (state_24000[(14)]);
var inst_23977 = (inst_23968 == null);
var state_24000__$1 = state_24000;
if(cljs.core.truth_(inst_23977)){
var statearr_24008_24044 = state_24000__$1;
(statearr_24008_24044[(1)] = (15));

} else {
var statearr_24009_24045 = state_24000__$1;
(statearr_24009_24045[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (6))){
var inst_23943 = fluree.db.query.subject_crawl.subject.subjects_id_chan.call(null,db,error_ch,vars,f_where);
var state_24000__$1 = state_24000;
var statearr_24010_24046 = state_24000__$1;
(statearr_24010_24046[(2)] = inst_23943);

(statearr_24010_24046[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (17))){
var inst_23991 = (state_24000[(2)]);
var state_24000__$1 = state_24000;
var statearr_24011_24047 = state_24000__$1;
(statearr_24011_24047[(2)] = inst_23991);

(statearr_24011_24047[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (3))){
var inst_23998 = (state_24000[(2)]);
var state_24000__$1 = state_24000;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24000__$1,inst_23998);
} else {
if((state_val_24001 === (12))){
var inst_23947 = (state_24000[(7)]);
var inst_23953 = (state_24000[(8)]);
var inst_23952 = (state_24000[(10)]);
var inst_23968 = (state_24000[(14)]);
var inst_23972 = cljs.core.async.close_BANG_.call(null,inst_23947);
var inst_23973 = cljs.core.async.close_BANG_.call(null,inst_23952);
var inst_23974 = cljs.core.async.close_BANG_.call(null,inst_23953);
var inst_23975 = (function(){throw inst_23968})();
var state_24000__$1 = (function (){var statearr_24012 = state_24000;
(statearr_24012[(15)] = inst_23972);

(statearr_24012[(16)] = inst_23973);

(statearr_24012[(17)] = inst_23974);

return statearr_24012;
})();
var statearr_24013_24048 = state_24000__$1;
(statearr_24013_24048[(2)] = inst_23975);

(statearr_24013_24048[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (2))){
var _ = (function (){var statearr_24014 = state_24000;
(statearr_24014[(4)] = cljs.core.cons.call(null,(5),(state_24000[(4)])));

return statearr_24014;
})();
var inst_23940 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(f_where);
var inst_23941 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23940);
var state_24000__$1 = state_24000;
if(inst_23941){
var statearr_24015_24049 = state_24000__$1;
(statearr_24015_24049[(1)] = (6));

} else {
var statearr_24016_24050 = state_24000__$1;
(statearr_24016_24050[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (19))){
var state_24000__$1 = state_24000;
var statearr_24017_24051 = state_24000__$1;
(statearr_24017_24051[(2)] = null);

(statearr_24017_24051[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (11))){
var inst_23967 = (state_24000[(2)]);
var inst_23968 = cljs.core.nth.call(null,inst_23967,(0),null);
var inst_23969 = cljs.core.nth.call(null,inst_23967,(1),null);
var inst_23970 = cljs.core._EQ_.call(null,inst_23969,error_ch);
var state_24000__$1 = (function (){var statearr_24019 = state_24000;
(statearr_24019[(14)] = inst_23968);

return statearr_24019;
})();
if(inst_23970){
var statearr_24020_24052 = state_24000__$1;
(statearr_24020_24052[(1)] = (12));

} else {
var statearr_24021_24053 = state_24000__$1;
(statearr_24021_24053[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (9))){
var inst_23953 = (state_24000[(8)]);
var inst_23963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23964 = [error_ch,inst_23953];
var inst_23965 = (new cljs.core.PersistentVector(null,2,(5),inst_23963,inst_23964,null));
var state_24000__$1 = state_24000;
return cljs.core.async.ioc_alts_BANG_.call(null,state_24000__$1,(11),inst_23965);
} else {
if((state_val_24001 === (5))){
var _ = (function (){var statearr_24022 = state_24000;
(statearr_24022[(4)] = cljs.core.rest.call(null,(state_24000[(4)])));

return statearr_24022;
})();
var state_24000__$1 = state_24000;
var ex24018 = (state_24000__$1[(2)]);
var statearr_24023_24054 = state_24000__$1;
(statearr_24023_24054[(5)] = ex24018);


if((ex24018 instanceof Error)){
var statearr_24024_24055 = state_24000__$1;
(statearr_24024_24055[(1)] = (4));

(statearr_24024_24055[(5)] = null);

} else {
throw ex24018;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (14))){
var inst_23993 = (state_24000[(2)]);
var state_24000__$1 = state_24000;
var statearr_24025_24056 = state_24000__$1;
(statearr_24025_24056[(2)] = inst_23993);

(statearr_24025_24056[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (16))){
var state_24000__$1 = state_24000;
var statearr_24026_24057 = state_24000__$1;
(statearr_24026_24057[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (10))){
var inst_23995 = (state_24000[(2)]);
var _ = (function (){var statearr_24028 = state_24000;
(statearr_24028[(4)] = cljs.core.rest.call(null,(state_24000[(4)])));

return statearr_24028;
})();
var state_24000__$1 = state_24000;
var statearr_24029_24058 = state_24000__$1;
(statearr_24029_24058[(2)] = inst_23995);

(statearr_24029_24058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (18))){
var inst_23958 = (state_24000[(9)]);
var inst_23968 = (state_24000[(14)]);
var inst_23985 = cljs.core.conj.call(null,inst_23958,inst_23968);
var inst_23958__$1 = inst_23985;
var state_24000__$1 = (function (){var statearr_24030 = state_24000;
(statearr_24030[(9)] = inst_23958__$1);

return statearr_24030;
})();
var statearr_24031_24059 = state_24000__$1;
(statearr_24031_24059[(2)] = null);

(statearr_24031_24059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24001 === (8))){
var inst_23947 = (state_24000[(7)]);
var inst_23953 = (state_24000[(8)]);
var inst_23952 = (state_24000[(10)]);
var inst_23947__$1 = (state_24000[(2)]);
var inst_23948 = fluree.db.query.subject_crawl.subject.flakes_xf.call(null,opts);
var inst_23949 = cljs.core.drop.call(null,offset);
var inst_23950 = cljs.core.take.call(null,limit);
var inst_23951 = cljs.core.comp.call(null,inst_23949,inst_23950);
var inst_23952__$1 = cljs.core.async.chan.call(null,(32),inst_23951);
var inst_23953__$1 = cljs.core.async.chan.call(null);
var inst_23954 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23952__$1,inst_23948,inst_23947__$1);
var inst_23955 = fluree.db.query.subject_crawl.common.result_af.call(null,opts);
var inst_23956 = cljs.core.async.pipeline_async.call(null,parallelism,inst_23953__$1,inst_23955,inst_23952__$1);
var inst_23957 = cljs.core.PersistentVector.EMPTY;
var inst_23958 = inst_23957;
var state_24000__$1 = (function (){var statearr_24032 = state_24000;
(statearr_24032[(7)] = inst_23947__$1);

(statearr_24032[(18)] = inst_23954);

(statearr_24032[(19)] = inst_23956);

(statearr_24032[(8)] = inst_23953__$1);

(statearr_24032[(9)] = inst_23958);

(statearr_24032[(10)] = inst_23952__$1);

return statearr_24032;
})();
var statearr_24033_24060 = state_24000__$1;
(statearr_24033_24060[(2)] = null);

(statearr_24033_24060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = null;
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0 = (function (){
var statearr_24034 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24034[(0)] = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__);

(statearr_24034[(1)] = (1));

return statearr_24034;
});
var fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1 = (function (state_24000){
while(true){
var ret_value__2747__auto__ = (function (){try{while(true){
var result__2748__auto__ = switch__2745__auto__.call(null,state_24000);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2748__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2748__auto__;
}
break;
}
}catch (e24035){var ex__2749__auto__ = e24035;
var statearr_24036_24061 = state_24000;
(statearr_24036_24061[(2)] = ex__2749__auto__);


if(cljs.core.seq.call(null,(state_24000[(4)]))){
var statearr_24037_24062 = state_24000;
(statearr_24037_24062[(1)] = cljs.core.first.call(null,(state_24000[(4)])));

} else {
throw ex__2749__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2747__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24063 = state_24000;
state_24000 = G__24063;
continue;
} else {
return ret_value__2747__auto__;
}
break;
}
});
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__ = function(state_24000){
switch(arguments.length){
case 0:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0.call(this);
case 1:
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1.call(this,state_24000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____0;
fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto____1;
return fluree$db$query$subject_crawl$subject$subj_crawl_$_state_machine__2746__auto__;
})()
})();
var state__2770__auto__ = (function (){var statearr_24038 = f__2769__auto__.call(null);
(statearr_24038[(6)] = c__2768__auto__);

return statearr_24038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2770__auto__);
}));

return c__2768__auto__;
});
